

#Travels of Sir William Brereton in Ireland, 1635


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Travels of Sir William Brereton in Ireland, 1635
================================================


Author: William Brereton
------------------------


### File Description

Edward HawkinsElectronic file compiled by Beatrix Färber , Janet Crawford

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 2. Second draft.Extent of text: 
22200 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E630001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions**2. William Brereton, Travels in Holland, the United Provinces, England, Scotland and Ireland, 1634–1635, ed. and publ. by Edward Hawkins, printed for the Chetham Society, vol. 1 (Manchester 1844.)
**Literature**2. Barnaby Rich, New Description of Ireland, London 1610.
3. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
4. John Dymmok, 'A treatice of Ireland. Edited by Richard Butler', Tracts relating to Ireland 2, 1–90, Irish Archaeological Society (Dublin 1843).
5. Luke Gernon, 'A discourse of Ireland, anno 1620'. In: C. L. Falkiner (ed.), Illustrations of Irish history and topography, mainly of the seventeenth century. (London, New York, Bombay 1904) 345–362.
6. William Lithgow, The totall discourse of the rare adventures & painefull peregrinations of long nineteene years travayles from Scotland to the most famous Kingdomes in Europe, Asia and Affrica. Glasgow, 1906.
7. William Lithgow, Rare adventures and painful peregrinations of long nineteen years travayles (1632). Reprint, edited with an introduction by Gilbert Phelps. (London 1974).
8. Gerard Boate, Ireland's Naturall History, London 1652. Chetham Society. Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan (New York 2006).
9. Stanley G. Mendyk, Gerard Boate and 'Irelands Naturall History'. Journal of the Royal Society of Antiquaries of Ireland, 115 (1985), 5–12.
10. Albert Jouvin, de Rochefort, Description of Ireland after the Restoration. [This is an extract from vol. vi, pp 472–493 of Albert Jouvin, de Rochefort, Le Voyageur d'Europe: où sont les Voyages de France, d'Italie et de Maltre, ... Paris 1672.] The English translation is taken from Francis Grose and Thomas Astle (eds.), Antiquarian Repertory: A Miscellaneous Assemblage of Topography, History, Biography, Customs, and Manners (1775?–)1779; reprinted London 1807–1809 for Edward Jeffery.
11. Thomas Dinely, Observations on a tour through the kingdom of Ireland in 1681. Dublin 1858. Reprinted by E. P. Shirley (ed.) as 'Observations in a voyage through the kingdom of Ireland, 1680', Journal of the Kilkenny and South-East of Ireland Archaeological Society, new ser., 1 (1856–1857), 143–146, 170–188; new ser., 2 (1858–1859), 22–32, 55–56; new ser., 4 (1862–1863), 38–52, 103–109, 320–338; new ser., 5 (1864–1866), 40–48, 268–290, 425–446; new ser., 6 (1867), 73–91, 176–204.
12. Walter Harris, (ed.) Hibernica, or, some antient pieces relating to Ireland ... 2 vols. Dublin, 1747–1750.
13. John Dubourdieu, Statistical survey of the County of Down: with observations on the means of improvement: drawn up for the consideration, and by order of the Dublin Society, by John Dubourdieu. (Dublin 1802).
14. John Dubourdieu, Statistical survey of the County of Antrim: with observations on the means of improvement: drawn up for the consideration, and by directions of the Dublin Society, by the Rev. John Dubourdieu, rector of Annahilt. (Dublin 1812).
15. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." Paris, 1653.]
16. John D'Alton, The history of Drogheda: with its environs, and an introductory memoir of the Dublin and Drogheda railway. (Dublin 1844).
17. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
18. John D'Alton & J.R. O'Flanagan, The history of Dundalk and its environs from the earliest historic period to the present times with memoirs of its eminent men. (Dublin 1864).
19. Rev. George Hill (ed.), The Montgomery Manuscripts (Belfast 1869).
20. George Benn, History of Belfast (London 1877).
21. William Monck Mason, The history and antiquities of the collegiate and cathedral church of St Patrick near Dublin, from its foundation in 1190 to the year 1819. (Dublin 1820).
22. Charles Smith, The ancient and present state of the county and city of Cork: Containing a natural, civil, ecclesiastical, historical, and topographical description thereof. Dublin: printed for W. Wilson, 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger (Cork: Guy & Co., 1893–1894).
23. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. Dublin: Printed for W. Wilson 1773; 1774.
24. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774; reprinted Dublin/Cork: Mercier Press 1979).
25. Philip Herbert Hore (ed.), History of the town and county of Wexford: Tintern abbey, Rosegarland, and Clonmines, from the earliest times to the rebellion of 1798: compiled principally from the state papers, the public records, and MSS. of the late Herbert F. Hore. 6 vols. (London 1901–1911).
26. Walter Harris, The antient and present state of the County of Down. Containing a chorographical description, with the natural and civil history of the same ... With a survey of the new canal; as also, a new and correct map of the County. Dublin, Printed by A. Reilly, for Edward Exshaw 1744. Reprinted Ballinahinch 1979.
27. Samuel McSkimin, The history and antiquities of the County of the town of Carrigfergus: from the earliest records till 1839. (Belfast 1829, reprinted 1909).
28. John Pentland Mahaffy, An Epoch in Irish History: Trinity College, Dublin; its Foundation and Early Fortunes, 1591–1660. (London 1903).
29. P. W. Joyce, A Social History of Ancient Ireland (New York, London, and Bombay: Longmans, Green, & Company. 1903. 2 volumes.
30. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
31. P. W. Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe (Dublin: Éamonn de Búrca for Edmund Burke 1995).
32. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history. 3 vols. (London 1885–1890). (A digital copy is available at www.archive.org.)
33. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
34. Hiram Morgan, The Battle of Kinsale (Bray 2004).
35. R. N. Dore, The early Life of Sir William Brereton, Transactions of the Lancashire and Chester Antiquarian Society 63 (1953) 1–8.
36. John Morrill, Sir William Brereton and England's Wars of Religion, The Journal of British Studies 24/3. (July 1985) 311–332.
37. R. N. Dore (ed.), The Letter Books of Sir William Brereton, Lancashire and Cheshire Record Society 123 (Gloucester 1984).
38. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 363–407 of the volume.


#### Editorial Declaration


##### Correction


Text proofread three times at CELT.


##### Normalization


The electronic text was first edited by Edward Hawkins and published for the Chetham Society, vol. 1 (Manchester 1844). It was reprinted in the Illustrations of Irish History by C. Litton Falkiner, from which it is taken. Footnotes are included and tagged note; those by Hawkins are marked with the resp="EH" (attribute within the XML encoding). Non-standard spellings of names of people and places are regularised using the reg attribute within the tags. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the travel journal; div1=the section; paragraphs are marked; page-breaks are marked pb n="". The author's introduction is contained in an unnumbered div in the front matter.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal names, and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By William Brereton (1635) #### Use of language


##### Language: [EN] Introduction and main text are in English. The editor has modernized Brereton's language.


##### Language: [GA] A few words are in Irish.


##### Language: [LA] A few words are in Latin.


### Revision History


* (2010-07-15) Beatrix Färber (ed.)

* Conversion script run, header updated; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-09-23) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-26) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header.
* (2007-04-25) Beatrix Färber (ed.)

* File proof-read (3); additions to bibliography made; more markup applied; file parsed; SGML and HTML files created.
* (2007-04-08) Janet Crawford (ed.)

* File proof-read (2).
* (2007-04-05) Beatrix Färber (ed.)

* Header created with bibliography.
* (2007-03-31) Benjamin Hazard (ed.)

* First proofing; basic structural markup added
* (2007-03-31) Benjamin Hazard (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E630001


### Travels of Sir William Brereton in Ireland, 1635: Author: William Brereton


### Travels of Sir William Brereton in Ireland, 1635


This account of Ireland in 1635 is extracted from the Travels in Holland, the United Provinces, England, Scotland and Ireland, 1634–1635, of Sir **Brereton**, Bart., the well-known Parliamentary general.[1](javascript:footNote('E630001/note001.html')) Brereton's journal of his travels, after remaining for two centuries in manuscript, was printed in 1844 from the original in the possession of **Sir Philip de Malpas Grey Egerton**, and forms the first volume of the publications of the Chetham Society. The manuscript had previously undergone some curious vicissitudes, and a high testimony to the interest and value of Brereton's narrative of his adventures at home and abroad is supplied in **Sir Walter Scott**'s warm approbation. Scott strongly urged its publication, actually ‘tendering his own services as editor, and offering to supply all the necessary explanatory notes.’ Most people will share the regret of Mr. Hawkins, the editor of the Chetham Society's volume, ‘that this most valuable offer should have been declined.’


Although the existence of the manuscript was known to writers on Irish antiquities for many years prior to its being printed, Brereton's narrative has been little noticed by writers on Ireland. **Monck Mason** was shown it by **Sir William Betham**, and in a note at p. 7 of his History of St. Patrick's Cathedral, published in 1820, he printed Brereton's description of the appearance of that edifice in 1635. **Dubourdieu** in his Statistical Survey of the County of Down, published in 1802, printed the paragraphs of the journal which relate to that county, and the same writer also refers to the narrative in his Survey of the County of Antrim (1812). Dubourdieu mentions, on the authority of **Bishop Percy**, with whose ownership the Chetham Society's pedigree of the manuscript begins, that the journal belonged to the well-known antiquary, **General Vallancey**, who had bought it at an auction in 1791. It was doubtless on **Vallancey**'s death in 1812 that Bishop



---

p.364




Percy acquired the manuscript.[2](javascript:footNote('E630001/note002.html')) Portions of the Irish narrative were also printed by the **Rev. Sir Francis Lynch Blosse** in the Church of Ireland Magazine for 1826, but without any attempt at annotation, and in **D'Alton**'s History of Drogheda part of Brereton's account of that city is given, as the description of ‘an anonymous traveller.’ The fact that the Irish journal occupies barely a fifth of the Chetham Society's publication has caused it to be overlooked even by writers interested in the historical topography of Ireland, as well as by the historians. It is not mentioned in Andersen's Book of British Topography, and the writer of the notice of Brereton in the Dictionary of National Biography, though he states that Brereton's travels extended to Ireland, mentions the diary only as affording information regarding the social condition of England and Scotland. Neither **Froude** nor **Lecky** in their rapid surveys of seventeenth century history, nor **Gardiner** in the admirable Irish chapters of his chief work, makes any mention of Brereton's narrative. Although the Chetham Society's edition of the Travels is now out of copyright, the Irish Section has not been printed here without the courteous concurrence of the present secretary. Those notes to the Chetham edition which have been utilised in this volume bear the initials of Mr. Hawkins. For the remainder the present editor is responsible.




---

p.365


July 4.—We went from hence[3](javascript:footNote('E630001/note003.html')) to the Port Patrick, which is foul winter way over the mossy moors, and there we found only one boat, though yesternight there were fifteen boats here. We hired a boat of about ten ton for five horses of ours, and for five Yorkshiremen and horses; for this we paid 1£ and conditioned that no more horses should come aboard, save only two or three of an Irish laird's, who then stayed for a passage, and carried his wife and three horses. His name is Levinston, laird Dun Draide.[4](javascript:footNote('E630001/note004.html')) Here we shipped our horses two hours before we went aboard. It is a most craggy, filthy passage, and very dangerous for horses to go in and out; a horse may easily be lamed, spoiled, and thrust into the sea; and when any horses land here, they are thrown into the sea, and swim out. Here was demanded from us by our host, Thomas Marsh-banke, a custom of 2s. an horse, which I stumbled at, and answered that if he had authority to demand and receive it, I was bound to pay it, otherwise I was free to pay or refuse: herewith he was satisfied, and declined his further demand. Here is a pretty chapel lately built by Sir Hugh Montgomeries,[5](javascript:footNote('E630001/note005.html')) laird of Dunskie on this side, where he hath a



---

p.366




castle, and of Newton de Clanboyes[6](javascript:footNote('E630001/note006.html')) on the Irish side, where he hath a market town.


The boatman that carried us in a bark of about fifteen ton, his name was David Dickie, who hath a dainty, fine, pretty, nimble boy to his son, who will make a good sailor. The boat is a good sailing vessel, with good expert mariners, but not manned with sufficient number of men. She took in four horses more than we covenanted, and was so much overthronged with passengers as we had not every man his own length allowed to lie in at ease. Our horses were shipped about two hour, the wind being north-west; but turning into the south-west, or rather west-south-west, we went not aboard until after three hour; the wind then being so much averse and so directly against us, as that we could not get out of the haven, so as they were constrained to haul out with a cock-boat a good way. We were got clear out of the haven about four hour, and before we had sailed a league, the wind was more averse; but presently favouring us something more with a full gale of wind, we had so speedy a passage as that by six hour we were within sixteen miles of the coast of Ireland. The wind then failed, and was sometimes very weak and poor, and sometimes due west and directly averse, yet we passed on though slowly, and about eight or nine mile from the coast of Ireland we passed the **Strangawre**,[7](javascript:footNote('E630001/note007.html')) which is a mighty high running channel, where there is a concurrence and confluence of three strong tides, which run about nine or ten mile in length, and about two mile in breadth; these occasioned by the islands and points of land; but when we passed them, the wind was so weak, as it was there more calmed and less troubled than in any other part of our passage. We had no sooner passed the **Strangawre**, but (although when we went aboard it was very calm and like to be fair weather, which gave encouragement to them to hazard a passage by night) the wind failed us,



---

p.367




and we were much affected with the apprehension of the inconvenience of lying at sea all night, because the tides are so strong as they would carry us with the ebbing water down towards the isles of Scotland, the wind also being either so averse as to bring us back to the shore of Scotland, or to concur with the tide to carry us down towards the isles of Scotland; but then suddenly arose a strong wind and storms of rain, which did come out of the west and from the landward, which did much perplex the sailors, so as they were constrained to take down, and did in all haste take down, the lower part of the mainsail and the foresail, which they call the main bowline or main bonnet. Two or three of these showers and storms did follow one another, which though they did increase and renew our fears, yet it pleased God (who knows better what might conduce unto our safety than ourselves) to make these storms the instruments of bringing us to harbour about two hour upon the coast of Ireland, under the **Black Rock**,[8](javascript:footNote('E630001/note008.html')) which is in the **island of Mague**;[9](javascript:footNote('E630001/note009.html')) hereby we were sheltered all night from most cruel, violent, and tempestuous storms, which did much affect and discourage us, though we lay at anchor and under the shelter of a high hill. Here we took up our lodging in this open boat, and suffered a wet cold lodging, yet it pleased God that I took no cold, nor did any other distemper seize upon me save only a faintingness when I came on shore, and an extreme purging, although the sea wrought effectually and plentifully with me, and purged me more by vomit only when I was at sea than ever formerly, so as my stomach was not only cleared and discharged of phlegm, but also of abundance of choler and green stuff.


'Twixt **Erwin** in Scotland and **Colrane**[10](javascript:footNote('E630001/note010.html')) in Ireland are the highest running seas about the sound of **Raughrick**,[11](javascript:footNote('E630001/note011.html')) which is an island belonging to the Earl of Antrim. The shortest passage 'twixt Scotland and Ireland is from **Mule Kenteir**,[12](javascript:footNote('E630001/note012.html')) a rock or point of the Highlanders in Scotland, which is



---

p.368




sixteen mile to the Fair-head or Marble-head:[13](javascript:footNote('E630001/note013.html')) in Ireland; this is only a passage for the Highlanders; from Port Patrick to **Carrick-Fergus** is about nineteen leagues, and to **Donoh-a-Dee**,[14](javascript:footNote('E630001/note014.html')) or Groomes Port, about fifteen leagues, as one of the sailors informed me. At our landing in Ireland, the ship came as near the shore as she durst, and all the horses were thrown into the sea, and did swim to land, and climb a great steep rock.


July 5.—Upon the Lord's day in the morning we went ashore the coast of Ireland, in the Isle of Mague, where we were landed upon the rock, whence we found a difficult and tedious passage; and at the top of the hill we were very civilly and courteously entertained by a Scotch gentleman, who lives in a mean, poor house, hath good store of corn, milk, calves, and kine; hence we went to **Carrick-Fergus**, corruptly called Knock-Fergus, which is four miles, and came thither about two hour. Took up our inn in Mrs. Wharton's house, who is a Chester woman, a neat woman in her house; good lodging and usage, sixpence ordinary, fourpence a night hay and oats, sixpence peck provender.


This town, so called from one Fergus, who built the castle, and from Carrick, which in Irish signifies a rock;[15](javascript:footNote('E630001/note015.html')) and indeed the town may well take his denomination from the castle, which is seated upon a rock, and commands both town and haven. Almost all the houses in this town were built castle-wise, so as though the Irish made spoil of and burnt the town, yet were they preserved unburnt. This is but a pretty little town within the walls of a very small extent and capacity; the only grace of this town is the Lord Chichester's house,[16](javascript:footNote('E630001/note016.html')) which is a very stately house, or
 



---

p.369




rather like a prince's palace, whereunto there belongs a stately gate-house, and graceful terrace and walk before the house, as is at Denton my Lord Fairfax house.[17](javascript:footNote('E630001/note017.html')) A very fair hall there is, and a stately staircase and fair dining-room carrying the proportion of the hall; fine garden and mighty spacious orchards, and they say they bear good store of fruit. I observed on either side of his garden there is a dove-house, placed one opposite to the other in the corner of the garden, and 'twixt the garden and orchards a most convenient place for apricots or some such tender fruit, to be planted against the dove-house wall, that by the advantage of the heat thereof they may be rendered most fruitful, and come sooner to maturity, but this use is not made thereof. Very rich furniture belongs unto this house, which seems much to be neglected and begins to go something to decay. It is a most stately building, only the windows and rooms and whole frame of the house is over-large and vast; and in this house you may observe the inconvenience of great buildings which require an unreasonable charge to keep them in repair, so as they are a burthen to the owners of them.


There is maintained in this town two companies of soldiers, the one a troop of horse, the other of foot, consisting of fifty in either company, under the command of my Lord of Chichester's eldest son.[18](javascript:footNote('E630001/note018.html')) The troop of horse were lately sent to attend my Lord Deputy, in this progress very completely furnished, well horsed, and in red coats all suitable.


It is reported of this town that they have been always loyal and faithful to the state of England.[19](javascript:footNote('E630001/note019.html')) This is seated



---

p.370




upon a loch which comes from the sea, and is navigable with the tide for small vessels to the quay. This loch runs all along to Belfast, which is eight mile from Carrickfergus, and is thither also navigable; it is about three or four miles broad, well furnished with fish, and also with fowl in winter. Here upon that part of this loch next to Belfast I observed a convenient seat. From Carrickfergus to Belfast you ride all upon the loch-side; it is most base way, and deep in winter and wet weather, though now it is hard and dry.


July 6.—This town of Carrickfergus is governed by a mayor, sheriff, and aldermen, endowed with great privileges, and is the shire town. At Belfast my Lord Chichester hath another dainty stately house (which is indeed the glory and beauty of that town also), where he is most resident, and is now building an outer brick wall before his gates. This is not so large and vast as the other, but more convenient and commodious; the very end of the loch toucheth upon his garden and backside; here also are dainty orchards, gardens, and walks planted.[20](javascript:footNote('E630001/note020.html')) Near here unto, Mr. Arthur Hill (son and heir to Sir Moyses Hill)[21](javascript:footNote('E630001/note021.html')) hath a brave plantation, which he holds by lease, which still is for thirty years to come; the land is my Lord Chichester's, and the lease was made for sixty years to Sir Moyses Hill by the old Lord Chichester. This plantation it is said doth yield him a 1,000£. per annum. Many Lancashire and Cheshire men are here planted; with some of them I conversed. They sit upon a rack rent, and pay 5s. or 6s. an acre for good ploughing land, which now is clothed with excellent good corn. From Belfast to Linsley Garven[22](javascript:footNote('E630001/note022.html')) is about seven mile, and is a paradise in comparison of any part of Scotland. Linsley Garven is well seated, but



---

p.371




neither the town nor country thereabouts well planted, being almost all woods, and moorish until you come to Dromore. This town belongs to my Lord Conoway,[23](javascript:footNote('E630001/note023.html')) who hath there a good handsome house, but far short of both my Lord Chichester's houses, and this house is seated upon an hill, upon the side whereof is planted a garden and orchard, and at the bottom of which hill runs a pleasant river which abounds with salmon; hereabouts my Lord Conoway is now endeavouring a plantation, though the land hereabouts be the poorest and barrenest I have yet seen, yet may it be made good land with labour and charge.


From Linsley Garven to Dromore is about seven mile. Herein we lodged at Mr. Haven's house, which is directly opposite to the Bishop of Dromore[24](javascript:footNote('E630001/note024.html')) his house, which is a little timber house of no state nor receipt. His chaplain's name is Leigh, born in Manchester. This is a very dear house: 8d. ordinary ourselves, 6d. our servants, and we were over-reckoned in beer. This town, as it is the seat of the bishop of this see, so he is lord of it, and it doth wholly belong unto him. In this diocese, as Mr. Leigh his chaplain reported, this is the worst part of the kingdom, mid the poorest land and ground, yet the best church livings, because there are no impropriations.


At my coming to Carrickfergus, and being troubled with an extreme flux, not as yet come to so great height as a bloody flux, my hostess, Miss Wharton, directed me the use of cinnamon in burnt claret wine, or rather red wine, as also the syrup and conserve of sloes well boiled, after they have been strained and mingled according to discretion with sugar, they are to be boiled with sugar until they be cleared, having been first boiled in water until they be softened, and then strained.[25](javascript:footNote('E630001/note025.html'))




---

p.372


July 7.—We left Dromore and went to the Newrie,[26](javascript:footNote('E630001/note026.html')) which is sixteen miles. This is a most difficult way for a stranger to find out. Herein we wandered, being lost amongst the Irish towns. The Irish houses are the poorest cabins I have seen, erected in the middle of the fields and grounds, which they farm and rent. This is a wild country, not inhabited, planted, nor enclosed, yet it would be good corn if it were husbanded. I gave an Irishman to bring us into the way a groat, who led us like a villain directly out of the way and so left us, so as by this deviation it was three hour before we came to the Newrie. Much land there is about this town belonging to Mr. Bagnall,[27](javascript:footNote('E630001/note027.html')) nothing well planted. He hath a castle in this town, but is for most part resident at Green Castle; a great part of this town is his, and it is reported that he hath a 1,000£ or 1,500£ per annum in this country. This is but a poor town, and is much Irish, and is navigable for boats to come up unto with the tide. Here we baited at a good inn, the sign of the Prince's Arms. Hence to Dundalk is eight mile; stony, craggy, hilly, and uneven, but a way it is nothing difficult to find. Before you come to Dundalk you may discern four or five towers or castles seated upon the seaside.


This town of Dundalk hath been a town of strength, and is still a walled town, and a company of fifty soldiers were here in garrison under the command of **Sir Faithful Fortescue**.[28](javascript:footNote('E630001/note028.html')) This town is governed by two bailiffs, sheriffs,



---

p.373




and aldermen;[29](javascript:footNote('E630001/note029.html')) the greatest part of the inhabitants of the town are popishly affected, and although my Lord Deputy, at the last election of burgesses for the Parliament, commended unto them **Sir Faithful Fortescue** and **Sir Arthur Teringham**,[30](javascript:footNote('E630001/note030.html')) yet they rejected both, and elected a couple of recusants. One of the present bailiffs is popish. Abundance of Irish, both gentlemen and others, dwell in this town, wherein they dare to take the boldness to go to mass, openly. This town seated upon the sea, so as barks may come within a convenient distance with the flood; much low, level, flat land hereabouts, which is often overflowed in the winter, and here is abundance of fowl, and a convenient seat. Here we lodged at one Mrs. Veasie's house, a most mighty fat woman; she saith she is a Cheshire woman, near related in blood to the Breretons, desired much to see me; so fat she is, as she is so unwieldy she can scarce stand or go without crutches. This reported one of the best inns in the north of Ireland; ordinary 8d. and 6d., only the knave tapster over-reckoned us in drink.


July 8.—We left Dundalk and came to **Tredaugh**,[31](javascript:footNote('E630001/note031.html')) which is accounted sixteen mile, but they are as long as twenty-two mile.[32](javascript:footNote('E630001/note032.html')) About five mile hence we saw **Sir Faithful Fortescue**'s house or castle,[33](javascript:footNote('E630001/note033.html')) wherein for most part he is resident, which he holds by a long lease upon a small rent under my Lord Primate of Armagh. This is a dainty, pleasant, healthful, and commodious seat, and it is worth unto him about [*...*]. During ten miles riding from this town, much rich corn land, and the country well planted; the other six miles towards **Tredaugh**, until you come near unto it, not so rich nor so well husbanded.




---

p.374


This town, as it is the largest and best built town I have yet seen in Ireland, so it is most commodiously seated upon a good navigable river, called Boyne, whereinto flows the sea in so deep a channel (though it be very narrow) as their ships may come to their doors.[34](javascript:footNote('E630001/note034.html')) This river is built on both sides, and there is on either side a convenient quay; a stone wall built all along the river, so as a ship may lie close unto this quay, and may unload upon her. It is like the quay of Newcastle, and those channels I have seen in Holland in their streets. This town is also commodiously situated for fish and fowl. It is governed by a mayor, sheriffs, and twenty-four aldermen; most of these, as also the other inhabitants of the town, popishly affected, insomuch as those that have been chosen mayors, who for the most part have been recusants, have hired others to discharge that office.[35](javascript:footNote('E630001/note035.html')) One man (it is said) hath been hired by deputation to execute that place thirteen times; the present mayor also is but a deputy, and the reason why they make coy to execute that office is because they will avoid being necessitated to go to church.


I observed in this city divers fair, neat, well-built houses, and houses and shops well furnished, so as I did conceive this to be a rich town, the inhabitants more civilised and better apparelled. But this is graced with nothing more than my Lord Primate's palace, which is seated near unto the east gate. This is a neat, handsome, and convenient house, built within this twenty years by **Primate Hampton**.[36](javascript:footNote('E630001/note036.html')) The building is foursquare, of wood, rough-cast and not high; an handsome, plain, though long and narrow hall, two dining-rooms, one little neat gallery which leads into the chapel, which also *is a* pretty little plain and convenient chapel, whereinto there lead two ways, the one at the great



---

p.375




door out of the hall or court, the other, which is more private, out of the gallery; there is a little pair of organs herein. Whilst **Dr. Usher**[37](javascript:footNote('E630001/note037.html')) (my Lord Primate that now is) is here resident, he preacheth constantly every Lord's day in the morning in the church. There is a sermon therein in the afternoon, and after the same is ended, one of my Lord's chaplains repeats his sermon in his own chapel, whither not only all his own family resort, but also (the common door being open) those of the town that please may resort thereunto. In one of the dining-rooms is this conceit: the arms of this see and bishopric, and Bishop Hampton's own arms or coat enquartered together, and underneath is this inscription or motto: Fac tu similiter. Here is a pretty neat garden, and over against the window in the gallery end, upon a bank, these words in fair great letters are written: ‘O man, remember the last great day!’ The bank is bare, the proportion of the letters is framed and cut in grass. In this palace the Primate is most resident when he is not at **Dublin**.


In this town are two churches, one placed on the one side the river, the other on the other, over which is a wooden bridge. In the great church[38](javascript:footNote('E630001/note038.html')) my Lord Primate preacheth every Sabbath. In the body of the church, over against the pulpit, the communion table is placed lengthwise in the aisle; the body of the church is kept in good repair. The chancel, as no use is made of it, so it is wholly neglected and in no good repair; only herein is a fair monument for my **Lord Moore**,[39](javascript:footNote('E630001/note039.html')) his lady, Sir Edward Moore and Sir Thomas Moore, his sons, and their wives and children; amongst these is one erected for the Lady Salisbury,[40](javascript:footNote('E630001/note040.html')) now



---

p.376




living at Chester. On the other side, opposite hereunto, is **Sir Francis Roe**'s monument, who died when mayor; he is pictured in his scarlet gown.[41](javascript:footNote('E630001/note041.html'))


July 9.— From **Tredaugh** we came to the **Swordes**, which is fourteen miles thence, and six from thence to **Dublin**. Here we lodged at the sign of the Boot, a tavern, and were well used, and found far better accommodation in so mean a village than could be expected. The way from **Tredaugh** hither as dainty fine a way as I ever rid, and a most pleasant country; greatest part corn upon the very sea-coast, almost Wirrall-like,[42](javascript:footNote('E630001/note042.html')) and very good and well-eared corn; the barley now beginning to turn, and will be ripe before the rye. Upon the left hand, about three miles from **Tredaugh**, my Lord N.[43](javascript:footNote('E630001/note043.html')) hath a pleasant-seated house or castle, the prospect whereof commands the sea, and a most plain, rich-champaign corn country towards the land.


About two or three mile from **Swordes** my Lord Chief Baron[44](javascript:footNote('E630001/note044.html')) hath a dainty, pleasant, high-built wood house, and much right and brave land about it, this placed on the right hand; his name is *Sir Richard Bolton*. On the other hand, about half mile, Sir [*...*] hath a gallant pleasant



---

p.377




seat;[45](javascript:footNote('E630001/note045.html')) also[*...*][46](javascript:footNote('E630001/note046.html')). Here I saw very fair large English kine; I enquired the price, which was about 2£ or 2£ 10s. or 3£. These worth in England double the price. Land here sold for about twenty years' purchase, set some for 5s. or 6s. an acre, and meadowing for 2£ an acre, some for 1£. Some land about **Dublin** is set for 2£, 3£, and 4£ an acre.


We came to the city of **Dublin**, July 9, about 10 hour. This is the metropolis of the kingdom of Ireland, and is beyond all exception the fairest, richest, best-built city I have met with in this journey (except **York** and **Newcastle**). It is far beyond **Edinborough**; only one street in Edinborough (the great long street) surpasseth any street here. Here is the Lord Deputy[47](javascript:footNote('E630001/note047.html')) resident in the Castle, and the state and council of this kingdom. There is also an Archbishop of **Dublin**, which is the second in the kingdom. Archbishoprics in Ireland: 1. **Armathe**; 2. **Dublin**; 3. **Casiell**; 4. **Tuam**. Bishoprics in Ireland about eighteen, as they are now united.[48](javascript:footNote('E630001/note048.html'))


This city of **Dublin** so called, it is seated upon the river **Liffie**, which is not navigable about the bridge, nor far, nor flows not above one mile higher. The river is no good channel, but full of shelves and sands; and here is a very vile barred haven, over which few ships can pass that carry four hundred ton or thereabouts. The harbour here is very naked, plain, and the least shelter and protection from storms that I have found in any haven; the most ships ride by the **Ringe's end**, which is a point which runs into the sea, but it is so low, as it is very poor and bare shelter, and little defence against the violence of the storms, so the King's ship which lies here to scour the coasts (which is said to be the Ninth



---

p.378




Whelpe,[49](javascript:footNote('E630001/note049.html')) and the Bonaventure, a tall stout ship) is constrained to remove for harbour, sometimes under the Head of **Howard**,[50](javascript:footNote('E630001/note050.html'))sometimes under the opposite shore.


As I came from **Dublin** to **Hacquett's Town**,[51](javascript:footNote('E630001/note051.html')) I saw the head of the **Liffie**, where she breaks out of the mountains; this is not above seven miles from **Dublin**, and yet fetcheth a course of forty mile before it come to **Dublin**.


There are about thirteen churches in this city. Christ Church, a cathedral, where the Lord Deputy and State frequent; the chancel is only made use of, not the body of the church, wherein are very great strong pillars, though very short; the chancel is but plain and ordinarily kept, the body of the church a more stately building. St. Patrick's Church is a cathedral and prime church in this kingdom. It is denominated from St. Patrick, the tutelar saint and protector of this kingdom. It is in best repair and most neatly whited and kept of any church I have seen in Scotland or Ireland, especially in the chancel, wherein it is curiously and very artificially arched, and whited overhead. The body of the church is a strong ancient structure, wherein are great and strong pillars, but this is not floored overhead. This structure affords two parish churches under one roof, in either of which there is a sermon every Sabbath. In a corner, a small part of the middle aisle, there is a pretty, neat, convenient place framed, wherein there is a sermon every Sabbath at ten hour; and this though it be very little and narrow, yet it is sufficiently enlarged to receive a great congregation, by reason of capacious galleries round about, wherein are abundance of seats placed one above another with great advantage of room. There is also at one hour in the afternoon a sermon in the quire, in the higher end whereof was a very famous, sumptuous and glorious tomb of my **Lord of **Corke****'s.[52](javascript:footNote('E630001/note052.html')) This by the commandment of the



---

p.379




Deputy is taken down, and is now to be erected in the side of the same quire. The marble whereof this was made was gotten within two miles of this city.


St. Warburr's is a kind of a cathedral;[53](javascript:footNote('E630001/note053.html')) herein preacheth judicious **Dr. Hoile**,[54](javascript:footNote('E630001/note054.html')) about ten in morning and three in afternoon, a most zealous preacher, and general scholar in all manner of learning, a mere cynic. **St. Owen's**[55](javascript:footNote('E630001/note055.html')) is the parish wherein my Lord Primate was born; and here in this church doth he preach every Lord's day at eight hour, whilst he is in town. I heard him upon Sabbath last, the most excellent, able man, and most abundantly holy, gracious man that I have heard. St. Bride's where Mr. Jerom[56](javascript:footNote('E630001/note056.html')) preacheth.


July 10.—This day I dined with my Lord Primate of Ireland, **Dr. Usher**, who is a tall, proper, comely man, about fifty-six years of age; a plain, familiar, courteous man, who spends the whole day at his study, except meal time. He seems to be a man of pregnant parts, who hath good intelligence; he is well read in antiquities. His entertainment



---

p.380



good and plentiful, but nothing curious nor excessive. He is a most holy, well-affected bishop, a good companion, a man of good discourse. Having some conference with him about the reading of the book which gives liberty for recreation upon the Lord's day,[57](javascript:footNote('E630001/note057.html')) he used this expression: that there was no clause therein commanding the ministers to read the book, but if it were published in the church by the clerk or churchwardens, the King's command is performed; this was his sense and opinion.


Here was this day at dinner Doctor Richardson,[58](javascript:footNote('E630001/note058.html')) bishop of (Ardagh), a Cheshire man born, an able man, and good scholar; he was born near Chester, and married Sir Henry Bunbury's daughter, whom I went to visit after dinner; a tall, handsome, fat woman. This bishop is an intelligent man, and gave me good resolution and satisfaction in many things.


Hence I went to the Castle, wherein my Lord Deputy resides, within which are both the Houses of Parliament, whereof I took a view: much less and meaner than ours. The Lords' house is now furnished with about sixty or seventy armours for horse, which are my Lord Deputy's: this a room of no great state nor receipt. Herein there sat the first session about eighty lords; not so many the latter.


The Commons House is but a mean and ordinary place; a plain, and no very convenient seat for the Speaker, nor officers.[59](javascript:footNote('E630001/note059.html')) The Parliament men that sat in this house were about 248. There are about 30 or 32 shires, which send 60 or 64 knights for the shire, the rest are burgesses.


Here in this Castle we saw the council chamber, wherein stands a very long table, furnished with stools at both sides



---

p.381




and ends. Here sometimes sit in council about 60 or 64 privy councillors. Here we saw the hall, a very plain room and the dining-room, wherein is placed the cloth of estate over my Lord Deputy's head, when he is at meat.[60](javascript:footNote('E630001/note060.html')) Beyond this is the chamber of presence, a room indeed of state; and next unto this is there a withdrawing chamber, and beyond that a pretty, neat, short gallery, which leads to the council chamber; this was lately built by my **Lord Falkland**, whilst he was here Deputy; the lower part of it is built archwise and very gracefully, so as it is a great ornament to the Castle, about which there are very high walls and of great strength, and a drawbridge which is pulled up every night.


The command which this Castle hath over this city is from some of the leads and towers above on the top of the Castle, whereupon there is ordnance planted; and one fair brass piece of ordnance is placed in the court before the gate. Parker[61](javascript:footNote('E630001/note061.html')) committed a forfeiture herein taking out the stopple, for which he was seized upon, and I paid 6d. to redeem him. Here my Lord Deputy hath lately erected a gallant, stately stable, as any I have seen in the King's dominions; it is a double stable, there being a strong wall in the middle, to either side whereof stand the horses' heads. Thirty horses may stand at ease on either side, the stalls being very large; these are exceeding high, at least five or six yards, and very near the same breadth; no planks made use of, but Holland bricks placed upon the edges, whereon the horses lie and you walk; these as easy to walk upon as to lie upon, and these are made of Holland earth, which is harder and more durable much than our clay; with these the streets are paved in Holland.[62](javascript:footNote('E630001/note062.html'))


July 11—We went to **Sir Thomas Rotheram**[63](javascript:footNote('E630001/note063.html')) (who is a privy councillor), who used us respectively, and accompanied
 


---

p.382




me to the Castle, and showed me the courts of justice, which are conveniently framed and contrived, and these very capacious; the Star-Chamber,[64](javascript:footNote('E630001/note064.html')) the Chancery, the King's Bench and Common Pleas—these rooms as useful as ours in England, but here is not such a stately structure or hall to walk in as Westminster Hall. I saw also the church, which was erected by the Jesuits, and made use by them two years. There was a college also belonging unto them, both these erected in the Back Lane. The pulpit in this church was richly adorned with pictures, and so was the high altar, which was advanced with steps, and railed out like cathedrals; upon either side thereof was there erected places for confession; no fastened seats were in the middle or body hereof, nor was there any chancel; but that it might be more capacious, there was a gallery erected on both sides, and at the lower end of this church, which was built in my **Lord Falkland**'s time, and whereof they were disinvested when my Lord Chancellor and my **Lord of Cork****Cork** executed by commission the Deputy's place. This college is now joined and annexed to the College of Dublin, called *Trinity*, and in this church there is a lecture every Tuesday.[65](javascript:footNote('E630001/note065.html'))


We saw also St. Stephen's Hall, wherein are disposed about eighteen scholars, who are also members of the college whereunto this hall is annexed. This sometimes was a cloister for the Capuchins, who said mass, and preached in a pretty little chapel or chamber; this was likewise taken from them about that time, and now there is prayers in it twice a day. My **Lord of **Cork**** allowed 40£ per annum to maintain this lecture in the Jesuit's church, but now hath withdrawn this exhibition.[66](javascript:footNote('E630001/note066.html')) In this street 



---

p.383




which is called the Bridge Street, almost opposite to this hall, there died this day an Irish merchant, and as we passed by we heard either his wife or sister roaring out as though she were violently distracted; this they say is very ordinary with the Irish, and is their custom.


I went this day to view the college, which is called Trinity College, and was erected by Queen Elizabeth, and endowed with about 1,400£ per annum. There is a provost hereof, **Dr. Chappell**,[67](javascript:footNote('E630001/note067.html')) a vice-provost, and six senior fellows, whose fellowships are worth 9£ per annum, besides their diet; there are eight junior fellows, whose fellowships are worth, besides their diet, 3£ per annum; poor scholars about sixty, whose scholarships are only worth their diets. There are about sixty poor scholars, and about fifteen fellow commoners. In the chapel is a monument for **Dr. Challoner**,[68](javascript:footNote('E630001/note068.html')) sometimes provost of this college, and father to my Lord Primate's wife. Hereunto belongs a pretty little convenient garden. This house is seated in a good air, out of the city, and near the sea. They glory much in their library, whereof I took a full view, and there were showed unto me many manuscripts: one they highly esteem, which they call **Friar Bacon**'s work, and say the same is not anywhere extant save with them; but he must have a stronger faith to believe it than mine, for it is new bound, a very fair manuscript without any blot or blemish; it treats of all manner of learnings; but that it is **Friar Bacon**'s work doth not appear either in the frontispiece, title, or any part of the book, as also the subject seems unto me, and the style not to be **Friar Bacon**'s work; but here it is so received and reported.[69](javascript:footNote('E630001/note069.html'))


---

p.384




This library is not large, well contrived, nor well furnished with books. They say it is to be disposed of to some other uses, and a new library and schools to be erected.


July 12.— I heard my Lord Primate at eight hour at St. Owen's Church, which is his parish, wherein he was born, where he preacheth every Sabbath whilst he is in Dublin. I never heard a more powerful and convincing sermon, and indeed he is a most holy and heavenly man, and as pregnant witted as any I have heard. He doth most industriously apply his study, which he hath placed at a good distance from his house to prevent distraction and diversion by the access of any company to visit him, who are not admitted to disturb his studies. This his course and order is so public as that few come to him at any time of the day, save at the hours of relaxation, which is from eleven to one, and also about supper time; the rest of the day, from five in the morning until six in the evening, is spent ordinarily in his study.


July 13.—I dined with him also, and then he was much more free and familiar with me. I had much private conference with him, and after dinner he took me into his closet, where although there be not very many books, yet those that are, much used and employed. Herein he shewed me the whole books of the Waldenses, which are very rare; they cost him 22£ sterling; they are in octavo, about ten or twelve vol. The language wherein they are printed is a miscellaneous language, 'twixt French and Spanish; these were sent him from a counsellor in France, as also a copy of the plots and designs and proceedings of the inquisitors in France. He reg shewed me his Articles of Religion, printed 1563; but I left mine with him, which was more ancient and orthodox than his. He did enforce me to take away and read a packet of news (which came unto him there) before himself had cast an eye upon it.[70](javascript:footNote('E630001/note070.html'))




---

p.385


At ten hour this Lord's day I heard **Dr. Hoile** preach at St. Warburrs, and at three in afternoon in the same church. He is a most holy man, full of zeal and grace, a general scholar, but not sufficiently furnished with words to express that fulness of matter which aboundeth in him; who is a mere cynic to the world, but doubtless a gracious man in the sight of God. You may with much ease and conveniency hear four sermons every Lord's day, and, as I was informed, six sermons may be heard on one day. This city of Dublin is extending his bounds and limits very far; much additions of building lately, and some of those very fair, stately and complete buildings; every commodity is grown very dear. You must pay also for an horse hire 1s. 6d. a day; here I met with an excellent, judicious, and painful smith. Here are divers commodities cried in Dublin as in London, which it doth more resemble than any town I have seen in the King of England's dominions.


July 14.—Upon Tuesday, July 14, I left Dublin and came to **Hacquetts Town**, about eleven hour at night. It is accounted twenty-seven miles, but it is as long as thirty-seven. After you pass four miles from Dublin, you travel through the mountains, which are dry land, and some of them good pasture for cattle that are young, and sheep, but these are not sufficiently stocked. Towards evening we passed through troublesome and dangerous ways and woods, and had wandered all night had we not hired an Irish guide, by whose direction we arrived at eleven hour at **Hacquetts Town**, where we lodged in a little low, poor thatched castle. Here Mr. Watson, a Lancashire man, hath a plantation. As we passed this way I observed the head of the river **Liffie**, which comes under the bridge at Dublin, whence it is made navigable by the flood, which goeth a mile above the bridge, and little further; I passed also, about



---

p.386




eighteen miles from Dublin, by the head of the **Slane**,[71](javascript:footNote('E630001/note071.html')) which runs to **Waxford**,[72](javascript:footNote('E630001/note072.html')) and is there navigable, and twenty miles above **Waxford**.


This town, called in Irish **Haggers town**, is built upon my Lord of Ormond's land, which he holds by lease for about fifty years; this is in the province of Leinster, and in the county of **Catherloe**.[73](javascript:footNote('E630001/note073.html')) It is lately made a market town (a poor one);[74](javascript:footNote('E630001/note074.html')) it is most inconveniently seated amongst the mountains, a barren dry soil, and not easily improved and made rich. A branch of the river of the **Slane** runs below this town, wherein are but a few straggling houses. Some land is here set by Mr.Watson at 2s. and some at 3s. 4d. an acre, as to John Torkinton, and for thirty years. Here is good butter made as in England, and they say good cheese, but I tasted none. This is in the diocese of **Loghlein**,[75](javascript:footNote('E630001/note075.html')) and so is **Sir Morgan Kavanagh**[76](javascript:footNote('E630001/note076.html')) his estate; the bishop hereof was lately Dean of **Limbreck**, Dr. *Andrews*.[77](javascript:footNote('E630001/note077.html')) Here Mr. Watson hath erected a dainty new church, and maintains a good minister, Mr. Roote's wife's brother. He allows him 40£ pension per annum and his house, and a competent provision of ground. He paid for the purchase of this lease above 500£ fine, and he pays also an 100£ rent. He hath already improved it unto more worth than 400£ per annum, and hath much prejudiced his plantation by insisting upon overhard conditions and demands. Here we were very courteously and kindly entertained all night by **Mr. Needham**, and [*...*] who married Mr. Watson's sister.


July 15.—We went hence through Mr. Watson's woods, wherein is very little good timber, the most small, old, and decayed, and those trees which seem best are shaken and unsound at heart. When we went out of his grounds we entered upon Mr. Chambers' land, and saw abundance



---

p.387




of woods, more than many thousand acres; and some of those parts through which we travelled the ground was so thronged and pestered with wood which was fallen and lay upon the ground, as the ground was thereby made of no use. Out of this part of the wood the best hath been made use of for pipe-staves, which were sold for 6£ a 1,000: upon every 1,000 of these there is now a custom imposed of 3£, which doth so much deduct as there is no valuable advantage, the charge of hewing being 1£ 10s., besides conveying them down by water to **Ennerscoff**,[78](javascript:footNote('E630001/note078.html')) which is twelve miles, at which time there is required the aid and endeavour of a hundred men to conduct and guide them in this narrow, shallow, and crooked river, which runs through this wood.


Before we passed this wood and river, we passed by Minmoare, a little Irish town, where a brother of Chambers dwelleth. Two miles hence is **Carnue**,[79](javascript:footNote('E630001/note079.html')) the town wherein Mr. Chambers his castle is erected, and which is a neat, rough-cast, and well-contrived, convenient house. Here calling to drink a cup of beer (the weather being extreme hot), Mr. Chambers overruled us to stay all night, where we had very free and courteous entertainment. Two of his daughters, now married, are with my **Lord Brabseon**'s *Brabazon's* lady, and Mr. Sandeford's wife.[80](javascript:footNote('E630001/note080.html')) Here is now Mr. Odell, who doth commend and magnify beyond all measure the park belonging to this house, which is about seven miles in compass, and wherein are both fallow and red deer good store. Here is good butter and cheese made, and they say fair English cattle are here bred, though the ground seems but barren and poor, and moorish hereabouts; but here hath a brave large scope of ground, and it is of the best sort that this county of **Wickley** yields. Nor far hence, about a quarter of a mile, he hath erected an iron-work, which is called a



---

p.388




[*...*]. Herein the sows[81](javascript:footNote('E630001/note081.html')) of iron which are brought from **Bristow** are melted into iron bars. They stand in 5£ a ton, being laid down at the door, and are worth in bars xx lb. a ton.


July 16.—We left **Carnue** about seven hour, and went thence into the county of Wexford to **Claghaman**,[82](javascript:footNote('E630001/note082.html')) by **Lord of Baltamoare**'s[83](javascript:footNote('E630001/note083.html')) town, where he hath a brave house, but of no great strength, nor built castle-wise. Here I saw lime burnt, wherewith they use to enrich their ground. This town is seated upon the bank of river **Slane**, which doth hence carry down to **Ennerscoffe**, and so to Wexford, all pipe-staves, boards and other timber which grows in the woods near adjoining. We passed through **Sir Morgan Kavanagh**'s woods, wherein (we were informed in the morning at Carnew) there were lurking about sixteen stout rebels, well appointed, every of them with his pistols, **skene**, and darts; they have also four long pieces, but we saw none, only we had one lusty fellow in jealousy[84](javascript:footNote('E630001/note084.html')) in the wood. Herein there hath been good store of good timber, though now there remains little timber useful, save to burn, and such as cumbreth the ground, but they say he hath better timber in his more remote woods from the river. This is a commodity which will be much wanting in this kingdom, and is now very dear at Dublin. In this wood there runs a little river which divides the counties of Wexford and **Catherloe**, over which when we had passed we went to **Clenmoullen**,[85](javascript:footNote('E630001/note085.html')) the castle and seat of **Sir Morgan Kavanagh**, who seems to be a very honest, fair-dealing man, and his lady[86](javascript:footNote('E630001/note086.html')) a good woman, but both recusants. Here we were
 


---

p.389




entertained with good beer, sack and claret, whereof he was no niggard. He demands a 1,000£. per annum, and a 1,000£ rent for twenty town lands, and, as he saith, it is about 12,000 or 13,000 acres, but I cannot conceive it less than 20,000 acres; much hereof mountain wood, and the rest but poor land, all overgrown with fern and bracken, and not to be improved but with great charge and trouble.


Here he showed me a convenient seat for an iron-work, which may be supplied with sufficient water and charcoal; for this respect I do believe he doth set a far higher valuation and price upon his lands, which he doth much overvalue and esteem. In this wood I observed and tasted of the dew which fell upon the oak leaves, which glistened and shined and tasted like honey; doubtless this kingdom is a most fruitful place for bees. This castle and seat of **Sir Morgan Kavanagh** is an old, high, narrow, and inconvenient building; the stairs leading up into the dining-room mid chambers being narrow and steep, like a steeple stair; this also seated in a most solitary, melancholy place, woods on two sides and plains on the other; these are moors and mountains, whereon they say there are wolves. This also is in the Dufferie,[87](javascript:footNote('E630001/note087.html')) which hath always been reputed a thievish place, but Sir Morgan being demanded, said that the sixteen rebels before-named were most conversant about **Ross** and in the county of **Kilkennie**.


In the way to **Ennescorffie**,[88](javascript:footNote('E630001/note088.html')) about two miles thence on the other side the **Slane**, I went to survey (over the river) the manor of the **Ollort**,[89](javascript:footNote('E630001/note089.html')) in the county of Wexford, in the parish and diocese of **Fernes** and **Loghlein**, which is to be sold with these parcels following: **Taebcurrye**, **Taenknock**, **Rahennemonye**, **Bollincahine**, and **Sherewelch**. Hereunto belongs a court-leet, a court-barron, and one fair. It is mortgaged by one **Mr. Darbie Cavenah**, in Irish called Dormaunt MacDoullin. This land is now in mortgage to one



---

p.390




Turner, an apothecary in Dublin, for 800£, and may be redeemed whensoever the money is paid. This land adjoins to **Sir James Caroll**'s[90](javascript:footNote('E630001/note090.html')) new and stately house, which hath almost sunk him by the charge of building the same. It is called Ballyeskerne. This land lies upon the bank of the **Slane**, which is plentifully furnished with salmon and trouts; down this river abundance of timber is conveyed down to **Waxford**, so to be transported by sea. Upon this river bank many pleasant convenient seats for houses or towns may be found out. Here are coneys belonging hereunto. It will keep cattle, and good sheep and horses; these I saw, though by reason of the most extreme, violent drought both that land and all this country is burnt up and no grass, so as you cannot look upon this land but with much disadvantage; yet it seems to be a good-natured earth, but it hath been overtilled, and much wronged by the Irish husbandry. It is given in for 1,000 acres, but it is by those who know not how to guess at 1,000 acres: for doubtless there is no less than 1,000 acres of arable and pasture land, which may be made rich land by lime, which may be conveniently provided very cheap for 2d. a barrel, and may be conveyed by water at a small charge. Our host, Mr. Plummer (who lives in **Ennerscoffie**, and is a Scotchman; his wife an Englishwoman), affirmed that the third part of the corn (for so the Irish tenants sow their landlords' grounds, and allow them the third sheaf, and take two sheaves for their pains) which grew last year upon that ground was sold for 120£ There is meadow land and bog, which being guttered, ditched, and drained (which may be done with 20£ or 30£ charge) will be good and rich meadow; this is no less than 500 acres. Of commoning also, which yields fern and gorse, and would be made good land with a small charge, there is about 800 acres. Here is woodland belonging hereunto, but how much I am uncertain. Little good timber I saw; some part of the wood may easily be cleared of the oullers[91](javascript:footNote('E630001/note091.html')) and underwood,



---

p.391




and made good meadowing. Here is as handsome an Irish hall upon this ground as ever I saw in this kingdom, and if **Sir James Caroll** will part with his house, it stands most conveniently to be occupied herewith; and it is generally believed that both house and lands may be purchased upon easy terms. This were a brave seat for a younger brother, but this will not be sold, for **Mr. Darbye Cavenah** himself came to me at **Washford**, and would have made a lease for twenty-one years for 200 years, paying in the interim ten shillings an acre, which was a most senseless demand, and as much as the lands can be improved unto at the end of the 200 years; hereupon we brake off.


This kingdom is now divided into four provinces:
I. **Linster**; 2. Munster; 3. Ulster; 4. Connaught. **Linster** containeth these counties: 1. Eastmeath; 2. Westmeath; 3. Dublin; 4. Kildare; 5. Louth—these five called within the English Pale; 6. Longford; 7. King's County; 8. Queene; 9. **Kilkennie**, one of the finest counties in Ireland; 10. **Carloe**; 11. Wexford; 12. **Wickley**. Munster divides itself into these shires and counties: 1. **Waterford**; 2. **Tiperarie** and Cross Tiperarie; 3. **Corke**, greatest in Ireland; 4. **Kerrie**, furthest point of Ireland, south-west; 5. **Limbreck**, the richest land; 6. **Toemond**.[92](javascript:footNote('E630001/note092.html')) Ulster: 1. **Donegall**, furthest north-west county; 2. **Enneschelyn**, or **Fermanough**; 3. Cavan; 4. **Monohain**; 5. Tyrone; 6. **Londonderie**; 7. **Armath**; 8. **Downe-Patrick**; 9. Antrim, wherein stands **Carick-Fergus**. Connaught: 1. **Gallaway**; 2. **Mayeo**; 3. **Rosscommon**; 4. **Letrim**; 5. **Sligoe.**[93](javascript:footNote('E630001/note093.html'))


We lodged on Thursday, July 16, at **Ennerscorffie**, at one Andrew Plummer, a Scotchman, his wife an Englishwoman, where we paid 1s. ordinary for ourselves and 6d. for our servants. Here is a neat little castle in good repair. This and the town and the lands hereabout belong unto **Sir Henry Wallope**,[94](javascript:footNote('E630001/note094.html')) who hath a very brave command and royalty and revenue hereabout. This town is seated upon



---

p.392




the fair river **Slane**, which ebbs and flows even to this town, the greatest part of all the wealthy inhabitants whereof (there cannot be many) are wood merchants. Here our host informed us that Mr. Chambers had now at least, there landed and coming down the water, an hundred thousand pipe-staves, &c., which were worth at Wexford ten (shillings) an hundred: there his money to be received, out of which he cannot gain less than half in half.


July 17.—Here I bought of **John Torkinton** a little white mare; the price was 2£ 4s. He said if I returned her to **Hacquetts Town** when I had finished my journey, I should not abate above 3d. a day. I tried also a grissell gelding, for which I deposited 4£ 2s. 6d. and covenanted in this manner: that if I returned the horse within thirty days I was to receive my money back again, allowing an abatement of 1s. a day for so many days as I had the horse; only by this agreement I was to keep the horse ten days at least, so as if I returned him next day, I must abate 10s. of the 4£ 2s. 6d. This horse was one **Mainwareing**'s,[95](javascript:footNote('E630001/note095.html')) steward to **Sir Henry Wallope**: he descended out of Caringham house, and is uncle to Mr. Mainwareing that now is.[96](javascript:footNote('E630001/note096.html')) This money was left with Mr. Andrew Plummer, who undertook the performance of conditions.


Here we parted with **Mr. Needham**, who appointed with me to meet me on Tuesday morning next at **Carick**,[97](javascript:footNote('E630001/note097.html')) where my Lord of Ormond lives. Hence I sent to Dublin by John Torkinton the two horses there hired, which were



---

p.393




promised to be delivered there the day following, which I made use of, and was to pay for five days, for which I paid in Dublin 12s. beforehand.


We went hence towards Wexford, which is accounted eight mile, but they are very long miles. We crossed the water at **Ennerscoffie** on horseback, and at the **Carick**, a mile from Wexford, we passed over a narrow ferry; all the grass in the country is burnt up, and here they complain of drought, and affirm they never felt such extreme scorching hot weather in Ireland. Here are divers of the Roches, which have much land about Wexford, and who would willingly set or sell; their land lieth very convenient for a Cheshire man.


About a mile hence lies a farm called the Park, which is now leased unto one Mr. Hardye, an Englishman, who lives upon it, and hath an estate in it about thirteen years. The landlord is one **Mr. William Synode** *? Synnot*, of the Lough, a man that needs money. This land is almost 16£ per annum. He saith it contains about three hundred acres, others say two hundred acres, and that it will keep twenty or thirty milch kine, yield sufficient corn for a small family, affords abundance of rabbits, whereof here there are too many, so as they pester the ground, and here may be more fish and fowl provided than to keep a good family, for on three sides it is compassed with great loughs a mile or two broad, so as the flood being in it flows to the very bank sides; when the flood is out, the shore being mud is bare and dry; when the tide is out, the depth of the mud is half a yard or a yard; but I could not find the mud bare, and this was the reason given by Mr. Hardye, that so long as the wind blows west, it clears it of water, but now the wind being at east keeps the tide in; when the flood is in, it is said to be not above one yard deep of water (except at some extraordinary spring tides). I cannot believe but that this mud will much fertilise and enrich the ground. This I do believe is a place of much security to such cattle or goods as are therein kept, and they affirm that they have not lost any since they came thither, which is about eight years.


Here is the best feeding for fowl that I ever saw. This grass which comes from the mud is good food for them, and



---

p.394




there is a good store of it; and here is a little grove of oaks, wherein is no good timber, but it so stands as it is most strong shelter to the fowl that feed or frequent under it.


Here is the most commodious and convenient seat for a c(oy)[98](javascript:footNote('E630001/note098.html')) that ever I saw, but there is no more room whereupon to erect a c(oy) betwixt the water and an high bank of the wood than four or five rood in breadth, but sufficient in length so as you must either make so much of the mud firm land, whereupon to build your c(oy), or else you must only make good one side with two pipes, or you must erect your work upon a point of land which lieth much eastward, and is in view of the town, and much more inconvenient, or you must carry away abundance of earth to make a pond, and pipes in some ground, as yet much too high at the north-west end of the wood. Here grew ollers[99](javascript:footNote('E630001/note099.html')) sufficient to plant a coy, and here is sufficient wood to cleave into stakes for all uses; and as I am informed, reed may be provided out of **Sir Thomas Esmond**'s lands which is on the other side the water, and all necessaries may be supplied by water from the **Slane**. Mr. Hardye demands for his interest, which is for thirteen years, 55£, and will abate nothing.


And herein grow good cherries, and all wood here planted flourisheth well. Mr. Turner, father-in-law to **Mr. William Synode**, demanded an 100£ fine for a lease of eighty years in reversion after the determination of the thirteen years now in being; of the unreasonableness of which demand being convinced, he sent next day a messenger and letter to his son-in-law, Mr. Synode, who desired to know what I would give. I would offer nothing, but Mr. Mainwaring offered 20£ per lease for eighty (years). Mr. Turner replied that 40£ would not be accepted, and an augmentation of the rent 4£ per annum from 16£ to 20£. Upon this we broke off.


We lodged at Wexford at the sign of the Windmill at the house of Paul Bennett. This town is seated upon a



---

p.395




brave spacious harbour, capacious of many thousand sail, but it is much prejudiced and damnified by a most vile barred haven, which, notwithstanding, is far better than formerly. Two narrow bands of sand run along on both sides the channel into the sea, betwixt the points whereof is the channel or passage. Trade much decayeth in this town, and it is very poor by reason of herring fishing here failing. They report here of an incredible multitude of herrings ordinarily taken in one night, in this large and vast harbour, by five or six men in one boat of ten ton burthen, sometimes to the value of 20£, sometimes 40£, sometimes more. This was informed me and affirmed by one that ordinarily fished here and took this proportion. Now of latter times, the herrings have forsaken this coast, this town is much impoverished and decayed. Their quays go to ruin, and are in no good repair; there belonged sometimes unto every great merchant's house seated on the shore either a quay, or a part interest in a quay, or a private way to the quay. Their haven was then furnished with five thousand sail of ships and small vessels for fishing, and is now naked.


July 18—This day I went to the court (the assizes being now here held for this county of **Washford**, which began on Wednesday last, and ended this day), where is their shire hall. The judges that ride this circuit are **Sir George Sherley**,[100](javascript:footNote('E630001/note100.html')) Lord Chief Justice of Ireland, and **Sir John Fillpott**,[101](javascript:footNote('E630001/note101.html')) one of the judges in the Common Pleas, a little, black, temperate man. The one—viz., my Lord Chief Justice —sits upon Isie-prices,[102](javascript:footNote('E630001/note102.html')) the other upon matters of misdemeanours and trials for life and death. Here I saw four justices of peace sit upon the bench with **Sir John Philpott**, amongst which was one Devereux and my cousin Mainwareing, uncle to Mr. Mainwareing of Caringham that now is, a courteous, grave, civil gentleman, who came from the bench and saluted me in the hall, and accompanied me to the tavern, and bestowed wine upon me. He is agent



---

p.396




unto **Sir Henry Wallopp**, and is a justice of peace of this county, and was a burgess for the Parliament.[103](javascript:footNote('E630001/note103.html')) He told me there were three rebels condemned, as also he advised me rather to go by **Balliehack** and by the way of the Passage than by **Ross**, because of the rebels which frequent thereabouts; hereof he said there were about six or eight, and these furnished with some pieces, pistols, darts and skenes, and some of them most desperate spirits, and so cruel, that the inhabitants of the country dare scarce travel that way; these are proclaimed rebels, and such as are to be hanged, drawn and quartered so soon as they are apprehended. So also are those to be dealt withal who are not to be executed. One of them I saw in the streets returning towards the castle, and the women and some other following making lamentation, sometimes so violent as though they were distracted, sometimes as it were in a kind of tune singing; one of these ('twas said) was his wife. This is the Irish garb.[104](javascript:footNote('E630001/note104.html')) This town is governed by a mayor, and two bayliffs or sheriffs, and ten or twelve aldermen.


Beyond the bar also it hath a very safe harbour, and shelter for ships to ride at anchor in, who want tide to bring them into the haven. **Sir Adam Cotcliffe**[105](javascript:footNote('E630001/note105.html')) told me that he had dined at Milford in Wales, and supped in this town, which is about twenty-four hours' sail from **Bristoll**, and as much to Dublin.[106](javascript:footNote('E630001/note106.html')) By reason of the assizes here, the inhabitants of the country resorted hither in greater numbers and better habits (Irish garments I mean) than I have yet seen. Some gentlewomen of good quality here I observed clothed in good handsome gowns, petticoats and hats, who wore Irish rugs which have handsome, comely large fringes, which go about their necks, and serve instead of bands. This



---

p.397




ruggy fringe is joined to a garment which comes round about them, and reacheth to the very ground, and this is an handsome, comely vestment, much more comely as they are used than the rug short cloaks used by the women upon festival days in Abbeville, Bullein, and the nearer parts of Picardie in *France*. The most of the women are barenecked and clean skinned, and wear a crucifix tied in a black necklace, hanging betwixt their breasts. It seems they are not ashamed of their religion, nor desire to conceal themselves; and indeed in this town are many papists.


July 19.—The present mayor, **Mr. Mark
 Cheveu**, attended the judges to the church door, and so did the sheriff of the shire, both which left them there, and went to mass, which is here tolerated, and publicly resorted unto in two or three houses in this town, wherein are very few Protestants, as appeared by that slender congregation at church where the judges were. This morning I went unto and visited both the judges, and was respectively used by them; the mayor, a well-bred gentleman, an inns-of-court man, who is a counsellor, a gentleman that hath an estate in the country, and was knight of this shire for last Parliament, invited me to dinner as also to supper with the judges.[107](javascript:footNote('E630001/note107.html')) He is an Irishman, and his wife Irish, in a strange habit, a threadbare short coat with sleeves, made like my green coat of stuff, reaching to her middle; she knew not how to carve, look, entertain, or demean herself. Here was a kind of beer (which I durst not taste) called charter beer, mighty thick, muddy stuff; the meat nothing well cooked or ordered. Much discourse here, complaint and information given against the rebels, the captain whereof is called **Simon Prendergrasse**, whose brother also will be brought in trouble for relieving, &c. Three carriers were robbed betwixt **Ross** and this town on Friday last, and two other travellers, and one in his lodging, by three of these rebels well appointed, who said if they could have taken my **Lord of Kildare**,[108](javascript:footNote('E630001/note108.html')) who passed



---

p.398




through them nakedly attended, he should have procured their pardon. There was a letter sent and read this night at supper, advertising a gentleman in town that last night they came to his house with a purpose to take away his life, because he prosecuted against them, and informed that they had taken from him the value of 200£. The judge here said, if all the justices of peace did not wait upon them to **Ross**, to guard them from these rebels, he would fine them deeply. The junior judge told me of a very wise demeanour of the now mayor of **Ross**, who being informed that three of these rebels lay asleep near the town, and being required to send out some ten or twelve with him to apprehend them, he answered that he would provide for the safety of his town, commanded the gates to be shut, the drum to be beat, and pieces, warning-pieces, to be discharged, whereby they awaked, and took notice thereof and escaped.


July 20.—We left **Washford**, and the Lord provided a good guide for us, and directed us to a better course than we intended, for instead of going over the passage (which was this day so much troubled and so rough as my Lord of Kildare was in great danger there, and himself and servants constrained to cut the sail ropes and tacklings) we took up our lodging at Tinterden,[109](javascript:footNote('E630001/note109.html')) a dissolved abbey, where now **Sir Adam Cocliffe** lives, and where we were exceedingly kindly and courteously entertained. Now my disease began to increase upon me. This a very fair, large, stately house, and of great receipt. He keeps a good house, and hath a great estate here, and his lady is a dainty, complete, well-bred woman. She is Sir Rob. Rich his daughter. The land on this side **Washford** about four or five miles, and so to **Ballihack**, is much better land than that which I saw in any other part of this county. This day we had more rain than upon any day since we came from home. Here they say no rain fallen this two months, all extreme



---

p.399




dry, but nothing so much burnt up as in the other side of this county.


July 21.—We went home about eight hour, and came to **Ballihack**, a poor little village on this side the passage over the river of **Waterford**, which here is the broadest passage said to be in Ireland, and a most rough, troubled passage when the wind is anything high. Here last day the boat, wherein my Lord of Kildare came over, was in danger to be run under water by carrying too much sail, and running foul upon the passage boat. Down this river come all the shipping for **Waterford**. Here we saw the Ninth Whelp lying at anchor, to guard the fleet which now is ready to go hence to **Bristoll** fair. **Sir Beverley Newcombe** is captain of her, and is now at **Waterford**.[110](javascript:footNote('E630001/note110.html')) They say there are about fifty sail to go to St. James fair at **Bristoll**. The Irish here use a very presumptuous proverb and speech touching this passage. They always say they must be at **Bristoll** fair, they must have a wind to **Bristoll** fair, and indeed it is observed they never fail of a wind to **Bristoll** fair; yea, though the fair be begun, and the wind still averse, yet still do they retain their confident presumption of a wind. It is most safe here to hire a boat to pass over in, not with horses, which is rowed over with four oars. I paid for the hire of it 2s. This is a full mile over. The passage boat which carries your horses will not carry at one time more than two or three horses. Here is far better coming into the boat and landing than at Port Patricke, but less and worse boats. On Munster side is good lodging and accommodation.


This day we passed over the land of a gentleman whose name is [*...*]. He died about seven days ago of a gangrene; his fingers and hands, toes and feet, rotted off, joint by joint. He was but a young man, of above 1,000£ per annum, and married an old woman, a crabbed piece of flesh, who cheated him with a 1,000£ she brought him, for which he was arrested within three days after his marriage.


We came to **Waterford** about three hour, and baited at



---

p.400




the King's Head, at Mr. Wardes, a good house, and a very complete gentleman-like host.This town is reputed one of the richest towns in Ireland. It stands upon a river (called Watterford River),[111](javascript:footNote('E630001/note111.html')) which maintaineth a sufficiently deep and safe channel even to the very quay, which, indeed, is not only the best and most convenient quay which I found in Ireland, but it is as good a quay as I have known either in England or observed in all my travels. A ship of three hundred may come close to these quays. This quay is made all along the river side without the walls, and divers fair and convenient buttresses made about twenty yards long, which go towards the channel. I saw the river at a spring tide flow even with the top of this quay, and yet near the quay a ship of three hundred ton full loaden may float at a low water. Upon this river stand divers forts and castles which command it. At the mouth of the river is there a fort called **Duncannon**, wherein lieth my Lord Esmond's company, consisting of fifty good, expert soldiers.[112](javascript:footNote('E630001/note112.html')) Here is also a company of fifty soldiers, which are under the command of **Sir George Flowre**,[113](javascript:footNote('E630001/note113.html')) an ancient knight. These are disposed of in the fort, which is placed without the gate towards **Caricke**, a pretty little hold, which stands on high and commands the town. There stands upon this river the Carick twelve mile, hence, and **Clonmell** about eight mile thence; hither (as I have heard) the river flows. There is, seated upon this river also Golden Bridge, and there is a passage by water from Cullen [?] and **Limbrecke**. This is no barred, but a most bold haven, in the mouth whereof is placed an eminent tower, a sea



---

p.401




mark, to be discerned at a great distance;[114](javascript:footNote('E630001/note114.html')) yet this river runs so crooked as without a W. or N.W. Hence went a great fleet to **Bristoll** fair, who *stayed* long here waiting for a wind.


This city is governed by a mayor, bailiffs, and twelve aldermen. Herein are seven churches; there have been many more. One of these, Christ Church, a cathedral; St. Patrick's, Holy Ghost, St. Stephen's, St. John—but none of these are in good repair, not the cathedral, nor indeed are there any churches almost to be found in good repair. Most of the inhabitants Irish, not above forty English, and not one of these Irish goes to church. This town trades much with England, France, and Spain, and that which gives much encouragement hereunto is the goodness of the haven.


This town double-walled, and the walls maintained in good repair. Here we saw women in a most impudent manner treading clothes with their feet; these were naked to the middle almost, for so high were their clothes tucked up about them. Here the women of better rank and quality wear long, high laced caps, turned up round about; these are mighty high; of this sort I gave William Dale money to buy me one. Here is a good, handsome market-place, and a most convenient prison that I ever saw for the women apart, and this is a great distance from the men's prison. Herein dwells a judicious apothecary, who hath been bred at **Antwerpe**, and is a traveller; his name is (as I take it) **Mr. Jarvis Billiard**, by whose directions and good advice I found much good, and through God's mercy recovered from my sickness. After I had dined here, I went about four or five hour towards **Caricke**, where I stayed at a ferry about a mile from **Waterford** a whole hour for the boat, wherein we and our six horses were carried over together.


Hence to **Caricke** is accounted nine miles, good large ones, but very fair way, and very ready to find. We came to **Caricke** about nine hour. We lodged at the sign of the Three Cuts at Mr. Croummer's, where is a good neat woman. Here my disease increasing, I wanted good accommodation.



---

p.402



 
Here is my **Lord of Ormond**'s[115](javascript:footNote('E630001/note115.html')) house, daintily seated on the river bank, which flows even to the walls of his house, which I went to see, and found in the outer court three or four hay-stacks, not far from the stable-door; this court is paved. There are also two other courts; the one a quadrangle. The house was built at twice. If his land were improved and well planted, it would yield him great revenue; for it is said he hath thirty-two manors and manor-houses, and eighteen abbeys. This town of **Carick** is seated upon the bank of a fine, pleasant, navigable river, but it is a most poor place, and the houses many quite ruinated, others much decayed; here is no trade at all. This hath been a town of strength and defence; it is walled about, and with as strong a wall, and that to walk upon, as is West Chester; the church in no good repair; nor any of the churches in this country, which argues their general disaffection unto religion. Here in this town is the poorest tavern I ever saw—a little low, thatched Irish house, not to be compared unto Jane Kelsall's of the Green at Handforth.[116](javascript:footNote('E630001/note116.html')) 'Twixt **Waterford** and this town are many spacious sheep-pastures, and very fair large sheep as most in England; the greatest part of the land hereabouts is converted unto this use.


July 22.—From this town I returned back to Waterford, fearing indeed lest the country disease should so far prevail upon me as to disable me to endure, whereas indeed immediately after my departure I did begin by degrees to recover, and was within a few days, aid before my departure out of that kingdom, perfectly recovered, and my body rather inclined to be costive, but yet this did not continue with me above two days; and whereas I feared faintings by reason of sea-sickness, I thank God I was nothing subject thereunto, though I was never well at sea. Here, by promise, **Mr. Needham** of **Hacquett's Town** stood engaged to meet me, and sends in his stead **Mr. Robert Cooke**, an English gentleman who lives about one or two miles from this town, upon a



---

p.403




farm called **Tibruchne** (as I take it), which is my Lord of [*...*] land; he is my **Lord of Ormond**'s uncle. He pays 120£ rent for this farm, and paid an 100£ fine; his term in it is twenty years or thereabouts. The quantity of the ground hereunto belonging, as he valueth and esteems it to be, about 1,000 acres English measure; but, upon my view and survey thereof, I could not judge it to be less than 1,200 or 1,400 acres. This is all good land, and a great part marsh land lying along the river in common and not enclosed, which, if it were but divided and enclosed, would yield more than the rent of the whole, and this would be a small charge to make only ditches; this is commodiously, sometimes and not over often, watered and enriched by this navigable great river, which runs all along this ground a mile or two.


Here I observed a very convenient seat [*...*]. This was this day overflowed with the tide, by reason of a strong east wind concurring with this high St. James' flood; here abundance of fowl in winter. Here is a very fair, handsome English stone house, new built, and also a castle, to both which there comes up at every tide in a deep lough or channel sufficient water to carry a boat, and when the tide is gone out this is dry; so as if a net be placed in the mouth of it (which is but narrow) you may be thereby furnished with salmon, flookes, and other fish sufficient. There is now an Englishman tenant, who lives in the castle, who keeps a dairy and rents thirty kine from him, who keeps them summer and winter; for every cow he is to pay 1£ 10s. per annum, and half of the calves, all which are to be reared. I tasted of their milk, butter and cheese, and it was excellent good; I never drunk so good buttermilk. Here the milk is so good, as they churn that in the evening which was milked in the morning, so as the buttermilk is much sweeter and wholesomer; they never yet sold any cheese, only butter at 4d. a pound. Here I saw abundances of cheeses. Here is a town hereunto belonging, inhabited by Irish, who have no longer estate than from year to year; they pay neither here nor elsewhere no rent in money, only plough the ground to the parts, and allow the landlord



---

p.404



 
a third part; this is so slothfully and improvidently ordered as the ground is much impaired, and yields much less than if well husbanded. But these unprofitable commodities may be removed at pleasure, and without any manner of inconvenience, exclamation or exception. **Mr. Robert Cooke**, who now dwells here, affirmed that this farm would keep 120 kine and their increase, sufficiently plentifully, both summer and winter. There is one now tenant upon another part hereof who will take the whole one half of the farm, so much as is grazing ground for cattle, and will pay 90£ per annum; and indeed **Mr. Cooke** is so honest a gentleman as I cannot but believe his report. He saith it will also keep five or six hundred sheep, as good fair sheep as are Leicestershire or Northamptonshire, and sufficient good corn land may be reserved as will employ two ploughs; besides the moor, which is a rich marsh like Saltney,[117](javascript:footNote('E630001/note117.html')) will keep abundance of young cattle, horses and colts, and in my judgment this marsh land cannot be less than 400 acres. Herein although the salt water this day overflowed in my view, yet owlers[118](javascript:footNote('E630001/note118.html')) grow and prosper well; hence you may go conveniently enough to **Caricke** to church, the church in this town being in decay. Mr. Cooke will part with his interest herein, and demands his 100£ fine and the rent of 120£ per annum; the reason why he will part with his interest is because he hath a kinsman of his name partner with him, who fails in the payment of his part of the rent, for which his cattle was distrained.


July 23.—This day I rested at King's Head at Mr.Warde's and prepared barley water, cordials and perfumes to take to sea, to preserve me from fainting, whereunto I was nothing subject (I thank God) at sea or land. Herein I made use of and spent most of the afternoon with **Mr. Jarvis Billiard**, the apothecary, who showed me the best Mercator that ever I saw in my life; and indeed before my departure hence I was freed from that indisposition.


July 24.—Next morning I went down to the passage, which was so thronged as I could not be furnished with



---

p.405




convenient lodging: hard bed, without curtains, air or casements, a corn room. We lodged at the Bell—6d. ordinary—a most unquiet house at this time. The wind stood well for them (if they could have gotten out to sea) two or three days before, but it was so strong as they durst not adventure out of the river, for fear of being thrown upon some of the crooked points in this river.


July 25.—But upon St. James day the wind was sufficiently calmed, and stood fair, and they in The Whelp discharged a piece of ordinance to summon us aboard very early, so I was constrained to go aboard without my breakfast. There I bought half a mutton, cost 3s., and eggs seven a penny, and three pullets at 3d. apiece, but wanted a stomach to make use of any save eggs and pullets. About six hour I went aboard one of the King's ships, called the Ninth Whelp, which is in the King's books 215 ton and tonnage in King's books.[119](javascript:footNote('E630001/note119.html')) She carries sixteen pieces of ordinance, two brass sakers, six iron demi-culverin drakes, four iron whole culverin drakes, and four iron demi-cannon drakes. They are called drakes. They are taper-bored in the chamber, and are tempered with extraordinary metal to carry that shot; these are narrower where the powder is put in, and wider where the shot is put in, and with this kind of ordinance his Majesty is much affected. This ship is manned with sixty men; the captain is **Sir Beverley Newcomen**;[120](javascript:footNote('E630001/note120.html')) lieutenant, John Newcomen; master, William Brooke; master's mate, William Purser, who hath lost an arm—a temperate, well-governed, and



---

p.406




well-affected man; master gunner, Joseph Dudley; boatswain, corruptly called boseon, John Green; purser, Thomas Morgan; serjeant, Nathaneell Gilson; and indeed the most of the better sort of the rest civilised and well-governed men, and divers of them I observed attentive and diligent at prayer. We had (through God's mercy) a quick, pleasant, and dainty passage, for within twenty-six hours after we parted with Ireland, the utmost point I mean of Irish shore, we were landed at Minehead in **Somersettshire**. This is a most dainty, steady vessel, so long as she carries sail, and a most swift sailer, able to give the advantage of a topsail to any of the rest of this fleet, for whom we made many stays, and yet could not keep behind them, so as they did not put up all their sails as they otherwise might, but suited their course to the pace of this fleet, whom they waited upon to waft over from **Waterford** to **Bristoll** fair, and to guard them from the Turks, of whom there was here a fear and rumour that they were very busy upon the coast of *France*.[121](javascript:footNote('E630001/note121.html')) These are full of men, ordinance and small shot. This day we caused match to be made ready and prepared, and looked for them about **Lundye** next morning, but saw none, only it was the captain's care to see all the sail before him; for which end staying often, the vessel then (as also when she wanted sail) tottered and rolled intolerably; this did make me vomit extremely, and much more sea-sick than otherwise.


Here the captain's cabin was taken up by Alderman Joanes, of Dublin, and Dr. *Tilson*,[122](javascript:footNote('E630001/note122.html')) Dean of Christ Church in Dublin, who came in her by sea from **Dublin** to **Waterford**, and so thence for **Bristoll**; and the captain himself lodged in the master's cabin, so as I could not be accommodated with any more convenient cabin than the master gunner's cabin in the gun-room, but I could not endure under hatches, nor was I any longer in this cabin than about four hours in the night, during which time I could not rest; the ship



---

p.407




tossed so exceedingly so as I thought it had been tempestuous, and yet was it very calm, fair and moon-shine night; and sometimes the waves flashed into the ship at the loop-holes at stern, so as; I could not endure in bed longer than one watch, from ten to two hour, and then I arose and went to the hatches, and presently we discovered **Lundye**, which seems like a high rock in the sea, and is an island; this is accustomed to be the pirates' harbour and shelter, but now we could not discover any.


The remarkable points, shores, sands, rocks and islands in this passage are these: on **Washford** side **Dunkannon**, which is a fort wherein my lord Esmond's company is desposed; and a low point whereon is placed the tower of **Waterford**, a white eminent conspicuous seamark; hence about four miles are two islands called the **Saltes** *Salteso*. On **Waterford** side is **Craydon Head** *Creaden Head*, and the utmost point is called **Horseleffes**, so called from a shelf of sand. Hence to **Lundy** is about thirty leagues.














