

#Tour in England, Ireland, and France, in the years 1826, 1827, 1828, and 1829


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Tour in England, Ireland, and France, in the years 1826, 1827, 1828, and 1829
=============================================================================


Author: Hermann Fürst von Pückler-Muskau
----------------------------------------


### File Description

Translated and edited by Sarah Austin 

Electronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The HEA via PRTLI 4 2. Second draft.Extent of text: 
84595 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2009) (2012) (2013) (2016) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T820002-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions and translations (a small selection)**2. Hermann Fürst von Pückler-Muskau, Briefe eines Verstorbenen. Ein fragmentarisches Tagebuch aus England, Wales, Irland und Frankreich, geschrieben in den Jahren 1828 und 1829. 4 vols. (Stuttgart: Hallberger 1831).
3. Ludmilla Assing-Grimelli (ed.), Briefwechsel und Tagebücher des Fürsten Hermann von Pückler-Muskau [Letters and Diaries of Prince Hermann von Pückler-Muskau] 9 vols., Berlin 1874–1876, reprinted Bern 1971.
4. Tour in England, Ireland and France in the years 1825, 1826, 1827, 1828 and, 1829, (4 vols.), translated by Sarah Austin. (London 1832).
5. E. M. Butler (ed.), A regency Visitor: The English tour of Prince Pückler-Muskau described in his letters 1826-1828. From the original translated by Sarah Austin. With an introdution by E. M. Butler. (London 1957).
6. Therese Erler (ed.), Hermann von Pückler-Muskau, Reisebriefe aus Irland, Berlin (DDR) 1969; reprinted 1980.
7. Flora Brennan (transl.), Pückler's progress: the adventures of Prince Pückler-Muskau in England, Wales and Ireland as told in his letters to his former wife, 1826–9. [A selection from 'Briefe eines Verstorbenen'] (London 1987).
**Further reading: A selection**2. Heinrich Meidinger, Reisen durch Großbritannien und Irland vorzüglich in topographischer, kommerzieller und statistischer Hinsicht. Neuestes Handbuch für Reisende durch die drei vereinigten Königreiche England, Schottland und Irland, 2 vols, (Frankfurt 1828). [His German letters on Ireland are available on CELT].
3. [Karl von Hailbronner], Cartons aus der Reisemappe eines deutschen Touristen (Stuttgart 1837) 279–306.
4. [Franz von Pulszky,] Aus dem Tagebuche eines in Großbritannien reisenden Ungarn (Pesth 1837) 126–149.
5. Friedrich von Raumer, England im Jahre 1835. (Leipzig 1836). [English translation of his letters on Ireland is available on CELT].
6. Johann Georg Kohl, Reisen in Irland (Dresden und Leipzig, Arnoldische Buchhandlung 1843) [English translation available on CELT].
7. Magdalena von Dobeneck, Briefe und Tagebuchblätter aus Frankreich, Irland und Italien, mit einem kleinen Anhang von Compositionen und Gedichten (Nuremberg 1843). [Her German letters are available on CELT.]
8. August Ehrhard: Fürst Pückler. [Translated from French into German by Fr. von Oppeln-Bronikowski]. (Berlin 1935).
9. Klaus-Günther Just, Fürst Hermann von Pückler-Muskau, Leben und Werk. Mit einer Auswahl aus Pückler's Nachlaß (Würzburg 1962).
10. Geraldine F. Grogan, The Noblest Agitator: Daniel O'Connell and the German Catholic Movement, 1830–50 (Dublin 1991).
11. Andreas Oehlke: Irland in deutschen Reisebeschreibungen des 18. und 19. Jahrhunderts, (Frankfurt/Main: Lang 1992).
12. Eda Sagarra, Die "grüne Insel" in der deutschen Reiseliteratur – Deutsche Irlandreisende von Karl Gottlob Küttner bis Heinrich Böll", in: Jäger, Hans-Wolf (Hg.): Europäisches Reisen im Zeitalter der Aufklärung. Neue Bremer Beiträge, (Heidelberg: Winter, 1992).
13. Pól Ó Dochartaigh, 'Bäurischer Adel und edles Bauerntum: Hermann von Pückler-Muskaus Reisebriefe aus dem Irland des Jahres 1828', in: Reisen im Diskurs, ed. Anne Fuchs and Theo Harden (Heidelberg: 1995) 455–469.
14. Eoin Bourke, "The Irishman is no lazzarone": German travel writers in Ireland 1828–1850, in: History Ireland 5:3 (1997) 21–25.
15. Eoin Bourke, "Dass die kunde nicht untergeht!": Pückler-Muskau and Freiligrath on the Irish tithe system, in: Joachim Fischer; Gisela Holfter; Eoin Bourke, Deutsch-irische Verbindungen (Schriftenreihe Literaturwissenschaft, 32, 42) (Trier 1998) 63–76.
16. Heinz Ohff, Der grüne Fürst. Das abenteuerliche Leben des Hermann Pückler-Muskau. (Hardback München 1991; paperback edition 1993; 9th impression 2008).
17. Eoin Bourke, Poor Green Erin (Frankfurt am Main 2011).
18. The German original, 'Briefe eines Verstorbenen', is in the public domain and is available on the Internet for example on The German Gutenberg Project, hosted by Der Spiegel: http://gutenberg.spiegel.de/buch/4338/1.
**The edition used in the digital edition**2. Tour in England, Ireland, and France, in the years 1826, 1827, 1828, and 1829. With remarks on the manners and customs of the inhabitants, and anecdotes of distinguished public characters, in a series of letters.. Hermann Fürst von Pückler-Muskau First edition [xvi+499 pages] Carey, Lee & BlanchardPhiladelphia (1833)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 317–451 of the volume; editorial footnotes are omitted.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors are corrected marked corr sic="" resp="BF".


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the letter; div2=the entry within each letter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal names, and group names are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the letter. ### Profile Description


Created: By Hermann Fürst von Pückler-Muskau Date range: August to December 1828.#### Use of language


##### Language: [EN] The translation is in English.


##### Language: [FR] Many words and phrases are in French.


##### Language: [DE] Many words and phrases are in German.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [IT] Some words and phrases are in Italian.


##### Language: [GA] A few words and phrases are in Irish, including those in anglicized spelling.


### Revision History


* (2016-10-21) Beatrix Färber (ed.)

* Additions made to bibliographic details.
* (2013-11-24) Beatrix Färber (ed.)

* Additions made to bibliographic details.
* (2012-06-14) Beatrix Färber (ed.)

* Additions made to bibliographical details; new wordcount made; file updated.
* (2009-07-22) Beatrix Färber (ed.)

* Proofing (2) finished; some more markup applied; file parsed; SGML and HTML files created.
* (2009-07-20) Beatrix Färber (ed.)

* Proofing (1) and encoding finished; including personal names, group names and place names; file parsed.
* (2009-06-15) Beatrix Färber (ed.)

* Header created.
* (2009-06-11) Beatrix Färber (ed.)

* First proofing, structural and content encoding begun.
* (2009-06-10) Beatrix Färber (data capture)

* Text captured (pages 317–451).




---


#### Corpus of Electronic Texts Edition: T820002-001


### Tour in England, Ireland, and France, in the years 1826, 1827, 1828, and 1829: Author: Hermann Fürst von Pückler-Muskau




---

p.317


### K—— Park, August 4th, 1828

My dearest Friend,


I am in most agreeable quarters. The manner of living is ‘comfortable’ the society cordial, ‘la chère excellente,’ and the freedom, as it is



---

p.318



every where in the country, perfect. Yesterday I took a very agreeable ride of some twenty miles on an untireable horse of my host's; for distances disappear before the excellence of the horses and of the roads: I must tell you all I saw.


I rode first to the small town of **St. Asaph** to look at the cathedral, which is adorned with a beautiful window of modern painted glass. Many coats of arms were extremely well executed, and the artist had the good sense to avoid the common error of endeavouring to represent objects not suited to his art, which requires masses of colour and no delicate and floating shades. To obtain a more perfect knowledge of the country, I ascended the tower. At a distance of about twelve miles I espied a church-like building on the summit of a high mountain, and asked the clerk what it was. He replied, in broken English, that it was ‘the king's tabernacle,’ and that whoever would pass seven years without washing himself, cutting his nails, or shaving his beard, would be allowed to live there; and at the expiration of the seventh year he would have a right to go to **London**, where the king must give him a pension and make him a ‘gentleman.’ The man believed this wild story implicitly, and swore to its truth; ‘Voilà ce que c'est que la foi.’


I inquired afterwards the true state of the affair, and heard the origin of this history; namely, that the building was erected by the province, or ‘county,’ to commemorate the jubilee of the last king's reign, and had stood empty ever since: but that a wag had advertised a considerable reward in the newspapers, to any man who would fulfil the above-named conditions. The common people had mixed up this strange ordeal with the ‘tabernacle’ of **King George III.**


I descended the towers, and now you may see me galloping at the foot of some gentle slopes, till I reach a rocky isolated hill, on which stands **Denbigh Castle**. The side of the hill is covered with the ruinous houses and huts of the miserable little town, and you climb through its narrow lanes to the top. A gentleman, who afterwards declared himself to be the surgeon of the town, very kindly showed me the way, and did the honours of the ruins with great politeness. Here is a sort of casino most romantically situated within the walls, and a very pretty flower-garden, commanding a beautiful view. The rest of this vast edifice offers only a neglected labyrinth of walls, standing amid the rank luxuriance of grass and thistles. Every third year, notwithstanding, a great national festival is held on this spot;—the meeting of Welsh bards, who, like the old German Minnesingers, repair hither to a trial of skill. The victor wins a golden cup; and a chorus of a hundred harps resounds to his fame amid these ruins. The meeting will take place in three months, when the Duke of Sussex is expected to be present.


Following a ravine, I now entered a most lovely valley. Deep wood overshadowed me; rocks stretched out their mossy heads, like old acquaintances from the branches; the wild torrent foamed, leaping and dancing amid the flowers; and the golden-green of the meadows here and there gleamed through the shade. I wandered for some hours in this place, and then climbed the heights by a weary foot-path, to discover where I was. I stood immediately above the bay and the broad tranquil sea, which appeared to be nearer to the gentle descent in front than it really was. After some effort, I espied among the groups of trees on the plain the house of K—— park, and trotting briskly onward, reached it in time to dress for dinner.


### August 5th


I walked this morning, while all the rest of the family were still in bed, with the charming little Fanny, the youngest daughter of the house



---

p.319



who is not yet ‘out.’ She took me round the park and garden, and showed me her ‘dairy’ and ‘aviary.’


I told you once before, that the dairy is one of the principal decorations of an English park, and stands by itself, quite away from the cow-house. It is generally an elegant pavilion, adorned with fountains, marble walls, and rare and beautiful porcelain; and its vessels, large and small, filled with the most exquisite milk and its products, in all their varieties. There can be no better place of refreshment after a walk. It is of course surrounded by a flower-garden, which the English love to attach to all their buildings. In this, the mineral rivalled the vegetable kingdom in brilliancy and beauty of colour. The proprietor has a share in the principal copper mines in **Anglesea**, and little mountains of ore, glittering with red, blue, and green, formed a gorgeous bed for rare and curious plants.


The aviary, which elsewhere is filled with gold pheasants and other foreign birds, was here more usefully tenanted; and was exclusively devoted to cocks and hens, geese, ducks, peacocks, and pigeons. It was however, from its extraordinary cleanliness and nice adaptation, a very pretty and agreeable sight. German housewives, listen and wonder! Twice a-day are the yards, which are provided with the most beautiful receptacles of water,—the separate houses, pigeon-holes, &c., twice a-day are they cleaned: the straw nests of the hens were so pretty; the perches on which the fowls roost, so smooth and clean; the water in the stone basins, which served as duck-ponds, so clear; the barley and the boiled rice (equal to Parisian ‘riz au lait’) so tempting that one thought one's self in the Paradise of fowls. They enjoyed, too, the freedom of Paradise: here were no clipped wings; and a little grove of high trees, close by their house, formed their pleasure-ground. Most of them were still poised in air, waving to and fro on the topmost boughs, when we arrived: but scarcely did they espy the rosy little Fanny tripping towards them, with dainties in her apron, like a beneficent fairy, than they flew down in a tumultuous cloud, and ran to her feet, pecking and fluttering. I felt a sort of pastoral sensibility come over me, and turned homewards, to get rid of my fit of romance before breakfast. But now the children's gardens were to be visited, and a sort of summer house, and heaven knows what;—in short, we were too late, and got a scolding. Miss Fanny exclaimed, with true English pathos,—
  

‘We do but row,
  

And we are steer'd by fate;’
  


in the words of our proverb, Der Mensch denkt Gott lenkt. Yes, indeed, thought I, the little philosopher is right: things always turn out differently from what one intends, even in such small events as these.


After dinner I mounted my horse again. I sought the most untracked ways in the wildest mountain country on the land side, frequently fording the rapid stream, and revelling in the most beautiful and striking scenery. Here and there I met a country girl working in the fields. They are strikingly pretty in the singular costume which sets off their fine persons to the greatest advantage. They are moreover shy as roes, and chaste as vestals. Every thing shows the mountain character; my horse



---

p.320



among the rest:—unwearied as a machine of steel, he gallops over the stones, up hill and down; leaps with undisturbed composure over the gates which continually intercept my way across the fields, and tires me long before he feels the least fatigue himself. This, to me, is the true pleasure of riding; I love to traverse mile after mile of country which I had never seen before, where I know not whither I am going, and must find out my way back as I can.


To-day I came upon a park, in which wooden statues painted white contrasted strangely with the sublimity of nature. No human being was visible; only hundreds of rabbits put their heads out of the holes in the side of the hill, or coursed rapidly across the road. All sorts of strange and curious devices marked the proprietor as an original. The only thing that pleased me was a dark fir grove, surrounded by a belt of bright crimson mallows. I at length reached the top, a bare hill, and went out as I had come in, through a gate, which fell to of itself. The same solitude reigned throughout, and the enchanted castle was soon far behind me.


### **Bangor**, August 8th


I was to stay some weeks at K—— park: but you know my restlessness; uniformity, even of the good, soon wearies me. I therefore took leave of my kind friends,—made a visit of some hours, instead of days, to another country-gentleman who had invited me,—saw a sun-set from the ruins of **Conway Castle**,—ate a plaice, and returned to my headquarters, which I now leave for ever. I am unfortunately not very well, my chest seems somewhat the worse for my late fatigues, and frequently gives me great pain; ‘mais n' importe.’


### **Craig y Don**, August 9th, early


Do you recollect this name? It is the beautiful villa which I described to you. I have since become acquainted with its amiable *possessor*, whose friendly invitation to spend my last night in **Wales** with him I could not resist. The pain in my chest prevented my taking more than short walks in the garden, with the son of my host; and the attempt to climb a hill in the neighbourhood made me so ill that I was obliged to amuse myself after dinner with reading the newspaper. In this vast desert I met with only one thing which I think worth quoting to you. The article treated of the speech from the throne, in which were the words ‘The Speaker is commanded to congratulate the people on their universal prosperity.’ This, says the writer, is too insolent, openly to make a jest of the miseries of the people. It is indeed a settled point, that truth is never to be expected in a speech from the throne; and if ever a king were mad enough to speak the real truth on such an occasion, he must begin his speech, ‘My knaves and dupes,’ instead of the wonted exordium ‘My Lords and Gentlemen.’


My host is a member of the yacht club, and a passionate lover of the sea. Our dinner would have contented the most rigid Catholic in lent: it consisted entirely of fish, admirably dressed in various ways. An oyster bank under his windows contributed its inhabitants for our dessert; the cows grazing before the house also afforded many delicacies; and the hot-houses adjoining the dining-room, delicious fruits.


Does it not do one good to think that perhaps not less than a hundred thousand persons in **England** are in the enjoyment of such an existence as this; of such substantial and comfortable luxury in their peaceful homes! free monarchs in the bosoms of their families, where they live in the security of their inviolable rights of property! Happy men! they are never annoyed with the oppressive missives of uncivil



---

p.321



functionaries, who want to rule everything even in their drawing-rooms and bed-chambers, and think they have rendered the state an important service when they have put the unhappy subject to an expense of many thousand dollars in a year for unnecessary postage; who are not contented to be placed above the governed, but must place themselves against them; thus uniting in their own persons party and judge. Happy men! free from assaults on their purses, from personal indignities, from the insolence of officials, eager to show their power by useless and frivolous vexations, from the avidity of insatiable blood-suckers! unrestrained masters of their own property, and only subject to those laws which themselves have contributed to make! When we reflect on this, we .must confess that **England**, though not a perfect country, is a most fortunate one. We ought not, therefore, to be much offended at Englishmen if, feeling strongly the contrast between their own country and most others, they can never, whatever be their courtesy and kindness, get over the distance which separates them from foreigners. Their feeling of self-respect, which is perfectly just, is so powerful, that they involuntarily look upon us as an inferior race. Just as we, for example, in spite of all our German heartiness, should find it difficult to fraternize with a Sandwich Islander. In some centuries we shall perhaps change places; but at present, unhappily, we are a long way from that.


### **Holyhead**, August 9th,—Evening


I have had a bad night, a high fever, bad weather, and rough roads. The latter misery I incurred by choosing to visit the celebrated ‘Paris mines’ in the Isle of **Anglesea**. This island is the complete reverse of **Wales**; almost entirely flat—no trees, not even a thicket or hedge—only field after field. The copper-mines on the coast are, however, interesting. My arrival having been announced by Colonel H——, I was received with firing of cannon, which resounded wildly from the caves beneath. I collected several beautiful specimens of the splendid and many-coloured ore: the lumps are broken small, thrown into heaps, and set on fire like alum ore, and these heaps left to burn for nine months: the smoke is in part caught, and forms sulphur. It is curious to the uninitiated, that during this nine months' burning, which expels all the sulphur by the force of the chemical affinity created by the fire, the pure copper, which had before been distributed over the whole mass, is concentrated, and forms a little compact lump in the middle, like a kernel in a nutshell. After the burning, the copper, like alum again, is washed; and the water used for the purpose is caught in little pools: the deposit in these, contains from twenty-five to forty per cent. of copper; and the remaining water is still so strongly impregnated, that an iron key held in it, in a few seconds assumes a brilliant copper colour.


The ore is then repeatedly smelted, and at last refined; after which it is formed into square blocks, of a hundred pounds weight, for sale; or pressed by mills into sheets for sheathing vessels. The ore is then repeatedly smelted, and at last refined; after which it is formed into square blocks, of a hundred pounds weight, for sale; or pressed by mills into sheets for sheathing vessels. A singular



---

p.322



circumstance is observable at the founding, which is a pretty sight. The whole mass flows into a sand-bed or matrix, divided into eight or ten compartments, like an eating-trough for several animals: the divisions do not quite reach the height of the exterior edge; so that the liquid copper, which flows in at one end, as soon as the plug is drawn out must fill the first compartment before it reaches the second, and so on. Now the strange thing is, that all the pure copper which was contained in the furnace remains in this first compartment,—the others are filled with slag, which is only used for making roads. The reason is this;—the copper ore contains a portion of iron, which is magnetically affected: this holds the copper together, and forces it to flow out first. Now as they know pretty accurately, by experience, what proportion of pure copper any given mass of ore will contain, the size of these compartments is regulated so as exactly to contain it. The manager, a clever man, who spoke half Welsh half English, told me that he had first invented this manner of founding, which spared much trouble, and that he had taken out a patent for it. The advantages which arise from it are obvious; since without these divisions or compartments, the copper, even if it flowed out first, must afterwards have spread itself over the whole mass. The Russians, who in matters of trade and manufacture suffer nothing to pass neglected, soon sent a traveller hither to make himself master of the process. It was not in the *slightest* degree concealed from him;—indeed it is but justice to say that the masters of all commercial and manufacturing establishments in **England** are
generally very liberal.


While I was yet standing by the furnace, an officer made his appearance, and in the name of the brother of Colonel H——, who is likewise a colonel, and commands a Hussar regiment in this neighbourhood, invited me to dine and spend the night. I was, however, too tired and unwell to venture on the exploit of a mess-dinner in **England**; where, in the provinces at least, the wine is dealt out in right old English measure. I wished too to sail by the packet of to-night; and therefore gratefully declined the invitation, and took the road to **Holyhead**, where I arrived at ten o'clock.


My usual ill luck at sea did not permit me to sail,—the night was so rough that the packet went off without passengers. I staid behind, not very unwillingly, to take another day's rest in a comfortable inn.


### August 10th


Ill and languid as I am, an excursion to the newly built light-house, four miles from hence, has given me extraordinary pleasure. Although the Island of **Anglesea** appears very flat, its picturesque craggy rocks rise on the western shore to a very considerable height above the sea. On one of these rocks, which stands out to sea, abrupt and isolated, is placed the light-house. This indescribably wild cliff is not only perpendicular—the summit actually projects several hundred feet beyond the line of the base; so that it appears rather as if blasted by powder, than the work of nature. Treading on a thick carpet of yellow dwarf broom and crimson heath, you reach the edge of the precipice: you then descend four or five hundred steps, roughly hewn in the rock, till you come to a little bridge suspended on ropes; across this, holding by its net-work sides, you swing, as it were, over the chasm which separates this rock from the main land. Thousands of sea-mews wheeled around us, uttering their ceaseless melancholy wail to the storm. The young ones were 



---

p.323



 
just fledged, and the parent birds took advantage of the rough weather to exercise them. Nothing could be more graceful and interesting than these flying lessons. The young were easily distinguished by their gray colour and their yet unsteady flight; while the old ones hung poised sometimes for the space of a minute without moving a wing, as if upborne motionless by the storm. The young ones often rested in the crevices of the rocks, but were soon driven out to fresh exertions by their inexorable parents.


The light-house is exactly like that which I have described to you at **Flamborough Head**, on the eastern coast of **England**, only without the revolving lights. The neatness of the oil-vessels, and the wonderful brightness of the mirror-like reflectors were here, as there, most admirable. I remarked an ingenious sort of rough-weather window, which may be opened in the hardest gale, without trouble or danger of breaking; and a vertical stone staircase, like a saw, which saves much room. But I cannot make you understand either without a drawing.


### **Dublin**, Aug. 11th


A more unprosperous voyage it is hardly possible to have. I was ten hours tossed about, sick to death. The heat, the disgusting smell of the steam-boiler, the universal sickness,—it was a frightful night—a picture of human misery, worthy of Carl of Carlsberg. In a longer voyage one gets hardened, and many new sources of pleasure compensate for privations; but short voyages, which show only the dark side of the picture, are my greatest aversion. Thank God it's over, and I once more feel firm ground under me; though I sometimes think **Ireland** rocks a little.


### Evening


This country has more resemblance to **Germany** than to **England**. That universal and almost over-refined industry and culture disappears here, and with it, alas! English neatness. The houses and streets have a dirty air, although **Dublin** is adorned with many magnificent palaces and broad straight streets. The lower classes are in rags; those somewhat higher want the English elegance; while the variety of brilliant uniforms, which are never seen in the streets of **London**, still more strongly remind one of the continent. The environs of the city have no longer the accustomed freshness; the soil is more neglected, the grass and trees scantier. The grand features of the landscape, however, the bay, the distant mountains of **Wicklow**, the **Hill of Howth**, the amphitheatrical mass of houses, the quays, the harbour, are beautiful. Such, at least, is the first impression.


I find myself, in the best inn in the city, less comfortable than in the little town of **Bangor**. The house is large, but seems silent and deserted; while I remember that there, only during my dinner, I saw fifteen carriages arrive, all of which were necessarily sent away from the door. The influx of strangers is so great along the high-roads of **England**, that waiters in the inns are not hired, but on the contrary, sometimes pay as much as 300*l.* a year for their places. They make a handsome profit, nevertheless, from the fees they receive. In **Ireland**, we return to the continental custom.


As soon as I had a little refreshed myself I took a walk through the city; in the course of which I passed two rather tasteless monuments. The one represents **William of Orange** on horseback, in Roman costume. Both man and horse are deformed: the horse has a bit in his mouth, and head-gear on,but no appearance of reins, though the king's



---

p.324



hand is stretched out exactly as if he were holding them. Does this mean that **William** wanted no rein to ride John Bull?


The other monument is a colossal statue of Nelson, standing on a high pillar, and dressed in a modern uniform. Behind him hangs a cable, which looks more like a pack-thread. The attitude is devoid of dignity, and the figure is too high to be distinctly seen.


I afterwards came to a large round building, towards which the people crowded, keeping watch on the outside. On inquiry, I learned that the yearly exhibition of fruits and flowers was held here. They were just taking away the former as I entered; notwithstanding which, I saw many fine specimens. In the midst of the flowers, which formed a sort of temple, there was an enclosed space railed round for the fruits, which twelve judges ate with great gravity and apparent satisfaction. They must have been a long time in coming to a decision; for rinds of melons, pears and apples, fragments of pines, stones of plums, apricots and peaches, lay in mountains on the table beneath; and although the flowers were all gradually removed by the proprietors, I did not see that any of the fruits found their way out of this temple of Pomona.


### August 12th


As I knew not what else to do (for all the ‘notables’ who inhabit the town were in the country,) I visited a number of ‘show places.’ First the Castle, where the vice-King resides, and whose miserable state-apartments with coarsely boarded floors do not offer anything very attractive.—A modern Gothic chapel, the exterior of which is a deceptive imitation of antiquity, is more worth seeing: the interior is decorated with splendid painted glass from **Italy**, of the fifteenth century, and richly ornamented with modern carvings in wood, of truly antique beauty. The whole chapel is heated by pipes of hot air; and a passage, warmed in the same manner and carpeted, connects it with the **Lord Lieutenant**'s apartments.


In the extensive and beautiful buildings belonging to the University a student acted as my **Cicerone**. These young men, when within the precincts of the college, are obliged to wear, over their usual clothes, a black mantle, and a strange high cap with tassels three-quarters of an ell long, which gives them a rather grotesque appearance. This dress is as rigorously adhered to, as at one time a pigtail and powder were by Saxon staff-officers.


The young man took me into the Museum; showed me the burning-glass with which **Archimedes** set fire to the Roman fleet! **Ossian**'s harp; a stuffed Indian chieftain with tomahawk and spear; and some fragments of pillars from the **Giant's Causeway**, which could not be more accurately formed by the hand of man, and which ring like English glass. ‘Je vous fais grâce du reste.’


In the great hall in which the examinations are held, (the student told me this with a slight shudder,) stands a Spanish organ, built for the grand Armada.—Much more interesting are the portraits of **Swift** and **Burke**: both physiognomies express the known qualities of the men. The one has an expression as acute and sarcastic as it is native and original: the other, full of intellect and power, somewhat blunt, but yet benevolent and honest, announces the thundering orator who contended sincerely and without reserve for his opinion, but never glossed over his own interest with affected enthusiasm for others.




---

p.325


After visiting the Courts of Justice, the Custom-house, and other magnificent buildings, I was going home, when I was tempted by the advertisement of a ‘Peristrephic Panorama’ of the battle of **Navarino**. This is a very amusing sight; and gives so clear an idea of that ‘untoward event,’ that one may console one's self for not having been there. You enter a small theatre,—the curtain draws up, and behind it is discovered the pictures which represent, in a grand whole, the series of the several incidents of the fight. The canvas does not hang straight down, but is stretched in a convex semicircle, and moved off slowly upon rollers, so that the pictures are changed almost imperceptibly, and without any break between scene and scene. A man describes aloud the objects represented; and the distant thunder of cannon, military music, and the noise of the battle, increase the illusion. By means of panoramic painting, and a slight undulation of that part which represents the waves and the ships, the imitation almost reaches reality.


The first scene represents the bay of Navarino with the whole Turkish fleet in order of battle. At the opposite extremity of the bay is seen **Old Navarino** and its fortress perched on a high rock; on the side of it the village of **Pylos**, and in the foreground the city of **Navarino** with Ibrahim's camp, where groups of fine horses, and beautiful Greek prisoners surrounded by their captors, attract the eye. In the distance, just at the extremity of the horizon, the allied fleets are faintly descried. This picture slowly disappears, and is succeeded by the open sea,—the entrance to the **bay of Navarino** then gradually succeeds. You distinguish the armed men on the rocks, and at length see the allied fleet forcing the passage. By some optical deception everything appears of its natural size; and the spectator seems to be placed in the Turkish position in the bay, and to see the admiral's ship, the Asia, bearing down upon him with all sails set. You see **Admiral Codrington** on the deck in conversation with the captain. The other vessels follow in extending lines, and with swelling sails, as if ready for the attack;—a glorious sight! Next follow the separate engagements of the several ships, the explosion of a fireship, and the sinking of some Turkish frigates. Lastly, the engagement between the Asia and the Egyptian admiral's ship on the one side, and the Turkish on the other, both of which, as you know, sank after an obstinate defence of many hours.


The battle is succeeded by some views of **Constantinople**, which give a very lively idea of Asiatic scenes and habits.


In the evening I visited the theatre; a very pretty house, with a somewhat less rough and obstreperous audience than those of **London**. The actors were not bad, though none of them rose above mediocrity. Numerous uniforms were intermingled among the ladies in the lower tier of boxes, which seemed to be elegantly filled. The higher classes, however, as I am told, seldom visit the theatre here, any more than in **London**.


### August 13th


Having seen enough of the city, I have begun my rides in the neighbourhood, which is much more beautiful than its appearance at my first approach, on the least favourable side, led me to expect. A road commanding charming views,—first of the bay, which is intersected by a mole five miles in length, and bounded at either extremity by the two light-houses of **Dublin** and **Howth**, rising like columns 



---

p.326



in the distance; then of the mountains of **Wicklow**, some clothed with wood, some rising like sugar-loaves high above the others, and lastly, along an avenue of noble elms by the side of a canal,—brought me to the **Phoenix Park**, the Prater of **Dublin**, which in no respect yields to that of **Vienna**, whether we regard its expanse of beautiful turf for riding, long avenues for driving, or shady walks. A large but ill-proportioned obelisk is erected here to the **Duke of **Wellington****. I found the park rather empty, but the streets through which I returned full of movement and bustle. The dirt, the poverty, and the ragged clothing of the common people often exceed all belief. Nevertheless they seem always good-natured, and sometimes have fits of merriment in the open streets which border on madness;—whiskey is generally at the bottom of this. I saw a half-naked lad dance the national dance in the market-place so long, and with such violent exertion, that at last he fell down senseless amid the cheers of the spectators, totally exhausted, like a Mohammedan dervise.


The streets are crowded with beggar-boys, who buzz around one like flies, incessantly offering their services. Notwithstanding their extreme poverty, you may trust implicitly to their honesty; and wretched, lean, and famished as they appear, you see no traces of melancholy on their open, good-natured countenances. They are the best-bred and most contented beggar-boys in the world. Such a little fellow will run by your horse's side for hours, hold it when you alight, go on any errand you like; and is not only contented with the few pence you give him, but full of gratitude, which he expresses with Irish hyperbole. The Irishman appears generally more patient than his neighbours, but somewhat degraded by long slavery.


I was witness among other things to this:—A young man had pasted up a wrong play-bill: the manager of the theatre came up and hit him a slap on the face, and otherwise ill-treated him, without his making any resistance; an Englishman would have made instant reprisals.


I passed the evening in the family circle of an old acquaintance, a brother of the Lord-lieutenant, who was just come to town for a few days. We talked over old times, as we had been much together in **London**. He has a remarkable talent for imitating the late Kemble, whom he resembles in person. I thought I saw Coriolanus and Zanga again.


### August 14th


Another friend, of yet older date, Mr. W——ts, to whom I had once an opportunity of rendering some service in **Vienna**, paid me a visit this morning, and offered me his country-house as a residence.—He had scarcely quitted me, when I was told that Lady ——, an Irish ‘peeress,’ and one of the most beautiful women in the country, whose acquaintance I had cultivated during the last season in the metropolis, was in her carriage below, and wished to speak to me. As I was still in the most absolute ‘negligée’ I told the waiter, (a perfect ‘Jocrisse,’ whose ‘Irish blunders’ daily amuse me,) that I was not dressed, as he saw, but that I would be ready immediately. He announced the state of my toilet; but added, ‘de son chef,’ that ‘my Lady had better come up.’ Imagine my astonishment when he came back and told me that Lady B—— had laughed very much, and had bid him say that she would willingly wait, but that to pay gentlemen morning visits in their chambers was not the custom in **Ireland**.




---

p.327


In this answer appeared the cordial, frank, and good-natured character of the true Irish woman, which I had already learned to love and admire. A prudish Englishwoman would have driven away in high displeasure, and perhaps have ruined the reputation of a young man for such a ‘qui pro quo’ as this: for in English society people do not only stumble at things which in other countries produce quite a contrary effect; but the ‘it is said’ in the mouth of an influential person is a two-edged sword. ‘He has a bad *character*’ is sufficient to shut a hundred doors against a stranger. An Englishman is much less guided by his own observation than is generally imagined: he always attaches himself to some party, with whose eyes he sees.


In the afternoon I went to dine at my friend's villa. The road was very agreeable. It began with the **Phoenix Park**, and followed the course of the Liffey, the river which flows through **Dublin**, where its beautiful quays, stone and iron bridges, add so much to the embellishment of the town. Here it has a rural and romantic character, bordered with the broad leaves of the tussilago, and enclosed by soft hills and verdant thickets. I asked a beggar whom I met, how far it was to W—— park, and whether the road continued equally beautiful all the way. ‘Long life to your honour!’ exclaimed he, with Irish patriotism, ‘only keep right on, and you never saw anything more beautiful in this world!’


The entrance to W—— park is indeed the most delightful in its kind that can be imagined. Scenery, by nature most beautiful, is improved by art to the highest degree of its capability; and without destroying its free and wild character, a variety and richness of vegetation is produced which enchant the eye. Gay shrubs and wild flowers, the softest turf, and giant trees festooned with creeping plants, fill the narrow glen through which the path winds by the side of the clear dancing brook; falling in little cataracts, it flows on, sometimes hidden in the thicket, sometimes resting like liquid silver in an emerald cup, or rushing under overhanging arches of rock, which nature seems to have hung there as triumphal arches for the beneficent naïad of the valley to pass through. As soon as you leave the glen, the enchantment suddenly ceases: the rest in no respect answers your high-raised expectations. Scanty grass, stunted trees, and thick stagnant water, surround a small Gothic castle, which looks like a poor scene in a play. In it, however, you find some interesting objects:—among others, some good pictures; and the best and most cordial host that one can desire. I must also mention a curious ‘pavilion rustique’ which is built in a suitable spot in the ‘pleasure ground.’ It is hexagonal, three sides solid, and fashioned of pieces of rough branches of trees very prettily arranged in various patterns; the other three consist of two windows and a door. The floor is covered with a mosaic of little pebbles from the brook, the ceiling with shells, and the roof is thatched with wheat straw on which the full ears are left.


### August 15th


Although my chest continues to give me pain, and my doctor sometimes makes solemn faces, I go on with my expeditions, which afford me great pleasure.




---

p.328


I had already fixed a longing eye on one of three hills, four or five miles from the city, on the summit of which stand three distinct upright masses of rock, from which it takes its name, ‘The Three Rocks.’ The view from it must needs be beautiful. I got up, therefore, earlier than usual, that I might reach the top in good time. I asked repeatedly in the villages through which I passed, which was the best way, but could never get a distinct answer. At length I was assured by the inhabitants of a house at the foot of the hill, that I could not ride up, and must dismount. This in the present state of my chest was not practicable; but as I have long learned what people's impossibilities are, I took the path they showed me, on horseback, without hesitation. I could safely trust my little compact mare, for the Irish horses climb over rocks or walls like cats. For sometime I followed a tolerably beaten foot-path, and when this ceased, the dry bed of a mountain stream, along which I rode without much difficulty for about two miles. I now found myself on a large and naked ‘plateau,’ and saw the three rocks, like witches' stones, rearing their heads before me. The intervening space, however, seemed an impassable bog. I tried it very cautiously, and found a shingly bottom at about eight or ten inches under the boggy soil. This continued all the way; till after some time I reached firm ground, and stood upon the highest point. The wished-for prospect lay before me: **Ireland**, like a map; **Dublin**, like a smoking lime-kiln in the green plain, (for the coal-smoke did not allow me to distinguish one single building;) the bay with its light-houses; the boldly marked headland of Howth; and on the other side, the mountains of **Wicklow**, stretching away to the horizon, lay beneath me bathed in sunlight, and rewarded me for all my fatigue.


But the scene was yet further animated by a sweet-looking young woman, whom I discovered in this wild solitude, busied in the humble employment of straw-platting. The natural grace of the Irish peasant-women, who are often truly beautiful, is as surprising as their dress, or rather their want of dress; for though it was very cold on these hills, the whole clothing of the young woman before me consisted of a large very coarse straw hat, and *literally* two or three rags of the coarsest sackcloth suspended under the breast by a piece of cord, and more than half disclosing her handsome person. Her conversation was cheerful, sportive and witty; perfectly unembarrassed, and in a certain sense free; but you would fall into a great error if you inferred from that, any levity or looseness of conduct.


The women of this class in **Ireland** are, almost universally, extremely chaste, and still more disinterested. If one of them ever strays from the path of virtue, she is very rarely seduced by those considerations of gain, which are so degrading, and, in such matters, so unnatural.


After I had descended the mountain on the other side, leading my horse, who scrambled after me as well as he could, I reached the high-road, and came upon an open park gate, (for in this also **Ireland** resembles the continent, where every proprietor, from the king to the humble country-gentleman, enhances his own enjoyment by sharing it with the public,) and rode in. I soon gave up the enterprise, however, on seeing two gigantic capuchins with gown and



---

p.329



cross cut out of painted boards, standing in a cross-way, and each of them holding a book on which was written— ‘To the Pheasantry,’ ‘To the Abbey.’ Such bad taste is rare here.


In the street I met a **London** ‘dandy,’ who called out to me, (for I did not recognize him,) laughed heartily at our meeting ‘in such a horrid place,’ ran on for some time in a satirical vein on **Dublin** society, and at last *concluded* by informing me, that through the influence of his family, he had just obtained a place here, which, indeed, brought him in 2000*l.* a year, and gave him nothing to do, but which compelled him ‘pro forma’ to pass a part of every year in this ‘shocking’ abode. With such, and even much richer sinecures, are the younger sons of the English aristocracy provided in countless numbers, and in all parts of the empire. I think, however, that even here, the pitcher will not always go to the well without breaking; though I must confess that these defects in the English government, compared with the arbitrary power exercised in other states, are but spots on the sun.


I of course entirely except **Ireland**, which appears to experience, in almost every instance, a step-mother's care; which contributes largely to the power and splendour of the English nobility, without receiving back the smallest portion of those advantages of which **England** receives so much.


### August 18th


Your letters are still so melancholy, dear Julia. [*...*] You see then that it is not events themselves so much as your own view of them which years have tinged with a more gloomy colour. But alas! this is the most irremediable of all evils! We are not what we were; and the one eternal and universal error remains—that we think we can help ourselves by an exertion of strength when the strength is no longer there:—as soon can we be or look young again! I too begin to feel traces of this—but only there, where the world lays its fetters around me when alone with God and nature, the gloomiest horizon has no power to darken my inner sun.


I accompanied Lady B——, of whom I have already spoken, to breakfast to-day at the country-house of a much admired young lady. The master of the house excused himself on the plea of headache, and I was therefore left to take a long walk in the grounds with the two ladies alone. On our arrival at the gate which was to lead us to one of the most beautiful parts of the wood, it was locked—no key to be found; and according to the report of the old gardener, the lady's maid had gone in, and taken it away with her. A servant was ordered to jump over the wall, and to seek the offender: he came back, however, without any tidings of her. I now got a ladder, and helped my laughing companions to climb over the wall; they professed great awkwardness, but acquitted themselves most gracefully. After walking a quarter of an hour we met the unfortunate lady's maid, and—as she thought herself safe—not alone: it may be imagined in what company. A mute domestic scene followed: and as I am too good natured to laugh, it really grieved me that my ladder had been the cause of such distress. I declined staying to dinner, and hastened back to town to call on Lady M——, to whom I had a letter of introduction, and who had already sent me a polite invitation which I had not been able to accept. I was very eager to make the acquaintance



---

p.330



of a woman whom I rate so highly as an authoress. I found her, however, very different from what I had pictured her to myself. She is a little, frivolous, lively woman, apparently between thirty and forty, neither pretty nor ugly, but by no means disposed to resign all claim to the former, and with really fine and expressive eyes. She has no idea of ‘mauvaise honte’ or embarrassment; her manners are not the most refined, and affect the ‘aisance’ and levity of the fashionable world, which, however, do not sit calmly or naturally upon her. She has the English weakness,—that of talking incessantly of fashionable acquaintances, and trying to pass for very ‘recherché’ to a degree quite unworthy of a woman of such distinguished talents; and she is not at all aware how she thus underrates herself.


She is not difficult to know, for with more vivacity than good taste, she instantly professes perfect openness, and especially sets forth on every occasion her liberalism and her infidelity; the latter of the somewhat obsolete school of Helvetius and Condillac. In her writings she is far more guarded and dignified than in her conversation. The satire of the latter is, however, not less biting and dexterous than that of her pen, and just as little remarkable for a conscientious regard to truth. You may think that with all these elements two hours flew rapidly away. I had enthusiasm enough to be able to utter some ‘à propos’ which pleased her, and she treated me with marked attention: first, because I happened to have a distinguished title; and secondly, because she had seen my name as dancing at Almacks, and as present at several ‘fêtes’ of the great leaders of Ton—a circumstance which appeared so important in her eyes, that she repeatedly recurred to it.


### August 20th


Yesterday evening I was engaged to a ‘soirée’ at Lord C——'s, the head of a new family, but one of the oldest ‘wits’ of **Dublin**. I was invited to accompany his friend lady M——, but was prevented by a tragi-comical incident. I had ridden out to visit Mr L—— at his country-seat (a trouble which between ourselves neither he nor his family deserved), and it was late when I set out on my return. To save time, I took my way across the country, ‘à la Seidlitz.’ For some miles all went on capitally, till just at twilight I came to a very wide ditch, the opposite bank of which was considerably lower than the one on which I stood, and surrounded a broad meadow. I leaped into this enclosure; but on trying to get out on the other side, my horse refused, and all my efforts to bring him to obedience were vain. I alighted to lead him, mounted again to try to leap him at another place,—tried fair means and foul; all equally in vain: till at length he made an awkward attempt at a leap, fell with me into the muddy water, and with some difficulty scrambled back again to the inner and lower bank. All hope of getting out of the enchanted spot in which I was caught as in a mouse-trap, was now lost:—it was become quite dark, I was wet through, and extremely heated; and was at last obliged to come to the determination of leaving my horse, getting over the fatal ditch, ‘tant bien que mal,’ on foot, and seeking help and shelter where I could. The moon came kindly from behind the clouds, and aided me with her welcome light. After a most toilsome walk of half an hour over ploughed land and through high wet grass, I reached a miserable hut, in which every body was



---

p.331



already asleep. I walked in, (for the houses here are never fastened;) a couple of pigs grunted under my feet, and near them lay the master of the house. With some difficulty I made him understand my request, which I enforced by jingling some silver close to his ear. This universal language awakened him more effectually than my invocations; he sprang up, called a comrade, and went out to my ‘Didone abbandonata.’ Irishmen are never at a loss for expedients; they found a broken and deserted wooden bridge near at hand, laid it across the ditch, and I at length found myself on the high road with my liberated steed. I reached home so late, and in such a plight, that I desired nothing but rest, and was sorry to hear that lady M—— had been to fetch me, and had driven away in great vexation an hour ago.


The next morning I went to make my excuses. She pardoned me graciously, but assured me that I had lost a *great deal,* for that all the rank and fashion of the town were there. I assured her with great sincerity that I regretted nothing but the loss of her society, out that I hoped to be indemnified for that as soon as I had made my ‘sentimental journey’ to the county of **Wicklow**, for which my German romantic soul ardently thirsted, and which I intended to commence the following morning on horseback. The conversation became very gay,—for she likes that; and at last ended so petulantly, that she exclaimed, ‘Finissez! when you come back I shall receive you just like an elder sister’: to which I answered, laughing, ‘That I cannot agree to;—je craindrais le sort d'Abufar.’ Addressed to Lady M—— this was certainly rather a ‘fade’ joke.


The continuation of my adventures you will receive from the midst of rocks and mountains.


Adieu! may heaven send you serenity and peace, and may every word of my letters whisper to you ‘true love till death.’


Your

 L——.
### August 22nd, 1828

Beloved Julia,


About noon I quitted **Dublin** entirely alone, comfortably established on my good steed. I left my carriage and people in the town, and sent a little travelling bag, containing my most necessary effects, before me by the stage-coach. Unfortunately, however, this was changed by mistake; and though I waited for it a whole day and night in **Bray**, only twenty miles from **Dublin**, it did not overtake me; rather than go back or wait longer, I bought a Scotch cloak and some linen in **Bray**, and entered on my tour quite after the fashion of a student. I supped with a young parson of good family, who made me laugh heartily at his orthodoxy in matters of religion, interspersed with talk which was by no means remarkable for severe decorum or virtue. But such is the piety of Englishmen,—it is to them at once a party matter and an affair of good manners; and as in politics they follow their party implicitly, through thick and thin, reasonable and unreasonable, because it *is* their party; as they submit to a custom for ever because it *is* a custom; so they regard their religion, (without the least tincture of poetry,) in exactly the same point of view: they go to church on Sundays, just as regularly as



---

p.332



they dress every day for dinner; and regard a man who neglects church, just in the same light as one who eats fish with a knife.


Accompanied by the young divine, who was travelling the same way for some distance, I left **Bray** at five o'clock in the morning. In a most lovely country we passed Kilruddery, a newly built seat of the Earl of Meath, in the style of the houses of Elizabeth's time; in this case the masses are not sufficiently large to produce a good effect. The park is not very extensive, but long and narrow; the gardens, in the old French taste, are very celebrated; but, probably owing to our unpretending appearance, we were most discourteously denied admittance. In **England** this is common enough, but rare in **Ireland**, and gave no very favourable impression of the philanthropy of the possessor. My companion, who is an adherent of ‘la grâce efficace,’—that is to say, who is firmly persuaded that God, from all eternity, predestined his favourites for heaven, and others who pleased him less for hell,—made no doubt, in his wrath, that the Lord of Kilruddery belonged to the latter category. ‘It is a disgrace to an Irishman!’ exclaimed he, angrily; and I had some difficulty in making him understand the duty of tolerance.


A second park, Bellevue, the property of a worthy old gentleman, readily opened its gates to us. Here is a summer-house which seems to hang in the air, and overlooks the ‘Glen of the Downs,’ a deep valley, behind which two extinct volcanoes rear their conical heads. The summer-house had just been prettily covered with purple heather. A less happy thought was a stuffed tiger, lying as if alive in the ante room.


My travelling chaplain here quitted me, and I rode alone to the vale of Durwan, where, in a narrow romantic pass, stands a rock eighty or a hundred feet high, shaped in the rude outline of the human figure. The country people, who relate many wondrous stories about it, call it the Giant. Not far from it are the ruins of a castle, so entirely overgrown with ivy, that you must approach very near to distinguish it from the surrounding trees. At the end of the valley the path winds. over meadows to a considerable height, which command a most exquisite view. I looked across the sea, and saw, almost with a feeling of home sickness, the Welsh mountains in the blue distance.


After having refreshed myself with bread and milk in a little country inn, I took my way to the ‘Devil's Glen,’ which merits the name it bears. The wild scene opens with a Gothic castle, whose blackened walls rise above the surrounding wood: you then plunge into a glen whose sides gradually rise higher and higher, and are more and more contracted, while the moaning breeze rustles louder through the dark thicket, and the torrent roars more fearfully. I rode on with difficulty over the slippery earth, incessantly annoyed by the overhanging boughs, and suddenly found the path terminated by a magnificent cascade, which plunges headlong over lofty crags, and disappears foaming in the bottom. If not the devil himself, it is at least Kühleborn.


Most agreeable is the change from this awful glen to the lovely sylvan valley of Rosanna, where I ate my mid-day repast under the shade



---

p.333



of high ash-trees. I found two regular English tourists, armed with hortus siccus and hammers. They had resided here for some weeks, during which time they had had the clean table-cloth removed from the dirty table, and remained sitting an hour at dessert, with exactly the same punctuality as in a **London** coffee-house, though they had miserable sloe-juice instead of claret, and roasted apples instead of ripe fruit.


At seven o'clock I mounted my horse again, galloped ten miles along the main road, and just before sunset reached the exquisitely beautiful Avondale. In this paradise every possible charm is united. A wood which appears of measureless extent, two noble rivers, rocks of every variety of picturesque form, the greenest meadows, the most varied and luxuriant shrubberies and thickets; in short, scenery changing at every step, yet never diminishing in beauty. The last time I traversed the valley it was moonlight, and I should have found my way with difficulty but for a young man who was returning from shooting; with true Irish kindness and courtesy he accompanied me at least three miles on foot, far beyond the most intricate parts. The night was extremely clear and mild, the sky as blue as by day, and the moon lustrous as a gem. Though I lost something in extent of view, I gained perhaps more by the magic light which was diffused through the atmosphere; by the darker and more fantastic ‘contours’ of the rocks, the thought-pregnant stillness, and the sweetly-awful loneliness of night.


At ten o'clock I reached the end of my day's journey, **Avoca Inn**; where I found very tolerable accommodation, kind and hearty attendance, and moderate charges. I met another English tourist in the eating-room:—but this was a high spirited and interesting young man, who fully sympathized in my rapture at the enchanting country, and with whom I talked away a very pleasant hour at tea, before I sat down to write to you. But now good night, for mountain travel-ling demands early rising.


### **Roundwood**, August 23nd


Yesterday I rode eight German miles,—to-day nine; and my chest is not at all the worse. Pleasure is an excellent restorative; and I have seen so many varied objects, that these few days appear to me like so many weeks.


I had slept well, though the broken windows of my chamber were only repaired with pillows. My humble lodging was succeeded by a better breakfast, and my horse was excellently taken care of. I ride like the Arabs, either at a gallop or a foot pace: this fatigues one the least, and gets over the most ground. My first excursion was to the celebrated ‘Meeting of the Waters,’ where the two rivers **Avon-beg** and **Avon-more** unite their streams. They have chosen the most picturesque spot in which to celebrate their nuptial feast.


On a rock on this side stands **Castle Howard**, with its numerous towers and battlements, which, unluckily, were but just finished, and on a near approach lost all their imposing effect. I found the castle still buried in sleep; and a servant in his shirt showed me the pictures, among which is a splendid portrait of **Mary Stuart**. This must be a speaking likeness; it is clearly of her time; and the attractive, truly French face, with the delicate nose, the captivating mouth, the languishing fire of the eyes; and that indescribable, inimitable expression which, without making any direct advance, yet somehow



---

p.334



 inspires courage, and though not devoid of womanly dignity, yet at the first glance bespeaks confidence and intimacy,—all convince one that thus the woman must have looked, whom scarcely any man could approach nearly, however severed by inequality of rank, without soon assuming the character of a lover. Her hands are exquisite; and in her dress, although of the ‘barroque’ style of that age, there reigns such harmony, that one is instantly convinced she was not less skilled in the arts of the toilet than her countrywomen of the present day.


An excellent road leads from this place through the ‘entire vale’ to the park of **Bally-Arthur**. The peculiar characteristic of this valley is, that the hills on either side are clothed with such impenetrable beech-woods that there is no visible interval between the masses, and it really looks as if you could ride on the tops of the trees. I here quitted the road, and followed a footpath in the thicket, which led me to a very beautiful view; at the termination of the long glen, the towers of **Arklow** appeared as if set in a frame. About a mile and a half further on, the path suddenly ends in a ha-ha, over which my horse utterly refused to leap. As the wall was on my side, and the turf below very soft, I hit upon a new expedient: I tied my handkerchief over the eyes of the refractory beast, and pushed him down backwards over the wall. He was very little frightened, and not at all hurt by the fall as I had expected, and grazed peaceably blindfold till I rejoined him. This manoeuvre saved meat least five miles.


The new park in which I now found myself,—for all this part of the country is a continued pleasure-ground,—belonged to **Shelton Abbey**, a modern piece of Gothicry, intended to represent an old abbey. The possessors had been absent for years; and a negro who was at work in the garden, showed me the rooms, in which are some very interesting pictures. The hero of one is the great-grandfather of the possessor; the scene in **Italy**, and the costume, as well as the manners represented, most strange and even revolting. The civil negro led me across the fields and through a pretty deep ford in the river, (whose ice-cold waters did not seem to alarm him), to the town of **Arklow**, whence I returned along the high road to dinner at **Avoca Inn**. In the course of my ride I ascended another hill, from which I looked down into three distinct valleys, the contrasted character of which afforded a most singular view. Scarcely had I seated myself at table (at **Avoca**), when I was told that some one wished to speak to me. A young man, whom I had never seen, was shown in, and presented to me a pocket-book, which, to my no small astonishment, I recognized as my own; containing, besides other important papers which I always carry about me, all the money I had taken for my journey. I had, Lord knows how, dropped it out of my breast-pocket in the summer-house; and had, therefore, no small reason to congratulate myself on so honourable and obliging a finder. In **England** I should hardly have had the good fortune to see my pocket-book again, even if a ‘gentleman’ had found it; he would probably have let it lie in peace,—or kept it.


I must here take occasion to explain to you what this far-famed epithet ‘gentleman’ means, since the signification affixed to it is inimitably characteristic of the English.


‘A gentleman’ is neither a man of noble birth, nor a man of noble sentiments (weder ein Edelmann noch ein edler Man—neither a



---

p.335



Nobleman nor a noble man;) but, in strictness, a man of independent means, and perfect knowledge of the usages of good society. He who serves or works for the public in any way, (the higher functionaries of the state, and here and there a poet or artist of the first category only excepted,) is no ‘gentleman,’ or at best only a half a one. I was greatly astonished at hearing a certain well-known personage, with whom all lovers of horses, native and foreign, are well acquainted; who is rich, who is on a footing of intimacy with many Dukes and Lords, and enjoys great consideration, but who presides at a weekly auction of horses (thereby doing useful service to the public)—say of himself, ‘I can't imagine how the Duke of B—— could commission me to carry a challenge to Count M——; he ought to have employed a gentleman, those things are not in my way.’


A really poor man, who is not in a situation to contract debts, can on no terms be a ‘gentleman.’ On the contrary, a rich scamp, who has had what is called a good education, so long as he preserves his ‘character’ (reputation) dexterously, passes for a ‘perfect gentleman.’ In the exclusive society of **London** there are yet finer ‘nuances.’ A man, for instance, who were to manifest any timidity or courtesy towards women, instead of treating them in a familiar, confident, and ‘nonchalant’ manner, would awaken the suspicion that he was ‘no gentleman:’ but should the luckless man ask twice for soup at dinner, or appear in evening dress at a breakfast which begins at three in the afternoon and ends at midnight,—he may be a prince and a ‘millionaire,’ but he is no gentleman.


But let us back from Babylon's tyrannous jargon to the freedom of the hills. The country through which I now rode was strikingly like the flat part of **Switzerland**, gradually rising till I found myself opposite to the highest mountains of **Wicklow**, whose heads were shrouded in clouds. The valley of **Glenmalure** has a character of desolate sublimity, which harmonized perfectly with the weather. In the midst stands a deserted and already decaying barrack, which looks like a haunted castle;—neither tree nor bush is to be seen, and the sides of the mountains are covered with loose stones. The valley has only subterranean inhabitants, and their life produces death. Here are great lead-works, whose unwholesome exhalations are traced on the pallid faces of the workmen. I dressed myself in a black slop, and was driven into one of the entrances,—a gloomy and terrific journey. The passages were cold as ice; pitch-darkness reigned in them, and a cutting wind loaded with a death-like smell blew in our faces. Minute drops fell with a hollow sound from the low roof, which bent us nearly double; and the jolting of the car, which a man dragged slowly over the rugged bottom, completed the picture of horrors. The delicate state of my chest did not permit me to remain long here, and I gave up all further researches, glad ‘once more to see the rosy light.’


I had now to ride over a new and magnificent military road (for the government has the watchfulness of a bad conscience about **Ireland**,) over one of the mountains which enclose the valley. The view from the heights was extensive and beautiful, and yet of a very different character from any I had yet seen: it was much improved



---

p.336



by a most favourable light thrown by the sun from beneath a line of black clouds. No effect of light gives such clearness and brilliancy to distant objects as this. The rays lay in broad stripes like a glory on the intersecting lines of hills; and the two **Sugar Loaves** stood overtopping all, in deep blue against this clear horizon. The way down the mountain is so serpentine that I could gallop along it with ease. It was nevertheless quite evening before I reached the last valley which I had yet to see in this day's tour—the Valley of the Seven Churches. Here stood, above a thousand years ago, ‘sic fabula docet,’ a large city with seven churches, which the **Danes** destroyed. A handsome gateway still remains almost entire, though the key-stone is wanting. Time has repaired this loss by a thick ivy branch, which holds together the whole arch. Seven distinct ruins are, according to the popular belief, the remains of those holy structures which gave its name to the valley. Only one of them indisputably bears this character, and is remarkable from one of the highest of those strange mysterious towers, without doors or windows, which are found near many ruins of religious houses in **Ireland**. At the further end of the valley, sunk in the deepest hollow and most sacred repose, sleep two dark lakes, celebrated for the adventures of **Saint Kevin**. The rocks around them are uncommonly steep, and in many places formed like stairs. In one is a narrow and deep cleft, exactly as if cut by a mighty blow. The legend tells that the young giant **Fian MacCumhal**, being thought by his comrades yet too weak to serve in the war they were then waging, cleft the rock with his sword, and so put an end to their doubts. Further still, in a rock overhanging the lake, you descry a black hole in the cave,—**Saint Kevin**'s cell.


Here the saint sought refuge from the persecuting love of the king's beautiful daughter Cathelin, and lived for a long time in solitude on roots and herbs. In a fatal hour the wandering fair-one discovered the fugitive, and surprised him in the dead of night on his mossy couch. With sweet kisses she awakened the ungallant saint; who seeing his danger, took the desperate resolution of pushing Cathelin over the precipice into the lake, where she lost life and love in its dark waters.


But the man of God felt some touch of human pity, and commanded that no other life should ever be lost in these waters,—a charm which, as my guide testified, is in full force to this day. This ‘Cicerone’ was a pretty, and as usual half-naked, boy of about eleven; his dress was a specimen of an Irish toilette, worthy of mention. He wore the coat of a grown man, which besides many diaphanous places, was deficient in a sleeve and a half, and one flap, while the other streamed after him like the tail of a comet. Neckcloth, waistcoat, and shirt were dismissed, as wholly superfluous: to make amends, the remains of a pair of red plush breeches made a most magnificent appearance, though in somewhat strong contrast with the naked legs beneath. To see this figure scramble over the rocks like a squirrel, singing all the while bits of **Tommy Moore** and **Walter Scott**, was certainly characteristic. As he led me to the cave, at a point where the passage was rather slippery, he cried, ‘Oh you can come on very well; I brought **Sir Walter Scott** here, and he climbed over the worst places, though he had a lame foot.’ He could talk of nothing else; and recited rapidly four lines which 



---

p.337


**Scott** or **Moore**, I forget which, had composed in the cavern. These people are so exactly suited to the wild and ruin-clad country, that without them it would lose much of its romantic interest.


In order to reach a tolerable inn at night, I had to ride ten miles over an interminable moor, the usual haunt of all sorts of spirits, though only now and then a solitary Will-o'-the-wisp flitted by me.


When I reached the village, both the inns were filled with ‘tourists’ and it was with the greatest difficulty that I procured a little sort of ante-room, in which I was to sleep on straw. The tea, butter, toast and eggs were, however, excellent, and hunger seasoned my repast. I cannot describe to you how delightful this life is to me. Amidst all its privations, I feel myself a hundred times more ‘à mon aise,’ than encumbered and annoyed with a thousand unnecessary conveniences. I am as free as the bird in the air, and that is one of the highest enjoyments.


And now, honour to whom honour is due. Few men would sit down with religious regularity every evening, after such fatigues, to write you a faithful report of all the events of the day. If it does but give you pleasure, I am rewarded a thousandfold.


### **Bray**, August 24th


Gall maintained, as you may remember, when he examined my skull in **Paris**, that I have a very prominent organ of veneration. Nevertheless many have regarded me as a vile heretic; but he was right;—that is, if religion consists in love, and in a sincere striving after truth. In such a joyful, pious frame of mind did I greet the fresh morning with prayer and praise, and the inward brightness broke through the gloomy damp mist which surrounded me; for the weather was extremely bad. The road too was desert and melancholy;—but, patience! the evening brought back sunshine and beauty.


For the present I saw nothing around me, as far as my eye could reach, but barren heath and moor; a stormy wind blew across it in gusts; and drove before it the rack, which, when I came within its reach, wetted me like a heavy rain. Short and feeble gleams of sun gave momentary hope, till about noon the clouds parted; and exactly as I reached the summit of the mountain above the magnificent valley and lake of **Luggelaw**, the sun gilded all the country beneath me, though the tops of the hills were yet shrouded in mist.


This valley belongs to a wealthy proprietor, who has converted it into a delightful park. It is singularly laid out, and I will try to give you an idea of it. The valley forms a nearly regular long oval basin. The lake occupies the immediate fore-ground to the mountain's foot; the middle-ground is meadow-land, studded with groups of trees, and watered by a meandering stream; and in its centre, backed by a solitary rock, is an elegant ‘shooting lodge.’ The mountains surrounding the valley are very high and steep, and rise on every side, in a bare and unbroken line from the perfectly level plain. On the left are naked rocks of imposing aspect, only here and there overgrown with heath-plants; the three other sides are clothed with thick and varied vegetation, whose foliage hangs into the very lake. At the spot where the mountain streams flow through bright green herbage into the lake, it forms a broad waterfall. It is indeed a lovely spot of earth, lonely and secluded; the wood full of game, the lake full of fish, and nature full of poetry. As the shooting season has not yet



---

p.338



begun, the proprietor was absent; and the wife of the steward, a still pretty woman, though rather ‘passée,’ with handsome white hands, and manners above her station, at my request prepared my breakfast; while her lively little son conducted me about the valley. A beautiful greyhound, who bounded over the ground as lightly as a leaf borne by the wind, and enjoyed his freedom in the wildest gambols, accompanied us. We climbed, not without pain to my chest, ‘car je ne vaux plus rien à pied,’ to a rocky table-land, four hundred feet high, which overlooks the whole valley. Opposite is a strange sport of nature,—a monstrous face regularly formed in stone, looking gloomily and angrily on the lake below. The eye-brows and beard were distinctly marked by moss heath, and the prominent cheeks and deep sunk eyes perfectly formed by the clefts in the rock. The mouth is open;—when you remove further off it closes, but without altering the other features. It is really a high prerogative to possess such a living image of a mountain spirit. He looks, however, as I said, angrily on the lake, and seems to call aloud with open mouth, ‘Ye human creatures, leave my valley, my fish, my game, my rocks, and woods in peace! Leave them, or I will bury you, ye pigmies, under my ruins!’ But it is in vain! the voice of spirits is become powerless since man's own spirit awoke. **Rübezahl**'s countenance is turned to stone, and his voice dies away in the gusty breeze, which irreverently sports with his bushy eyebrows, and curls the waves of the lake as if in scorn against him.


An interval of ten miles of uninteresting country lay between this walk and my arrival at the gate of the park of P——, one of the most extensive and beautiful in **Ireland**. But it was Sunday, the lord of the domain a saint,—and of course the gate locked. On this day, according to his view of the matter, a pious man must on no account leave his house except to enclose himself within the gloomy walls of a damp church: on no account rejoice himself in God's own wondrous and magnificent temple. This was a sin to which Lord P—— would by no means afford encouragement, and at his recent departure had therefore prohibited the opening of his gate. Instructed by the adventure which you may recollect befell me in **England**, I made no attempt at winning a passage by means of a gift, but pursued my way along a wall, over which from time to time I cast a longing and stolen glance at the magnificent waterfall and the enchanting scene. Thou beneficent God! thought I, in what different ways art thou worshipped! One man roasts his neighbour to thy honour; another fashions thee as Apis: some represent thee more partial and unjust than the devil himself; others think they offer thee the most acceptable service when they deface thy loveliest gifts, or deprive themselves and others of the enjoyment of them. Oh! Lord P——, you will not read these lines; but it were good for you if you could, and if you would lay them to heart! Full many a poor man, who sweats through the whole week that he may pay you your rent, would feel his heart expand with joy on a Sunday in your beautiful park, and would bless the goodness of that God who has not left him wholly destitute; who has spread out before his eyes the glory and the beauty of creation. And this joy would be reflected back upon yourself;—but perhaps, you are not even present? Perhaps you send your pious commands from afar? You are, perhaps, like so many of your colleagues, one of those ‘absentees’ who by the hands of ravenous and merciless agents strip the people of their last rag, rob them of their



---

p.339



last potatoe, to enrich the charlatans of **London**, **Paris**, or **Italy**. Then, indeed, if that be the case, your religion can hardly go beyond superstitious veneration for the Sunday, and for the ceremonies of your priests.


From hence to **Bray** the cultivation is luxuriant; the country is filled with houses and gardens of the opulent citizens: the road lies at the foot of the **Great Sugar Loaf**, whose hoary naked cone is barren of all vegetation. I saw some travellers who had just ascended it, and looked like moving chess-men; I envied them the magnificent view, for the day was brilliant and the atmosphere perfectly clear. Towards evening I lay myself down in a lonely spot, among the field-flowers by the side of a brook, and gave myself up to a dreamy and grateful delight in this beautiful world; leaving, like a knight-errant, my faithful steed to graze by my side. I thought of you and of past times; I called on the living to appear, and the dead to arise, and looked into my past life as into a mirror—now with a melancholy, then with a cheerful smile: for through all the follies and vanities of this world, through errors and faults, there still ran one pure silver thread strong enough to endure;—feelings of childlike love, and a high capacity for enjoyments which God's goodness renders attainable by all.


I returned to **Bray** in good time, and found my travelling-bag arrived; it contained many things which, after long privation, were not to be despised: among others, it afforded me the most interesting of companions, **Lord Byron**. I have now two portraits of him before me, drawings which have been given me, and which I have had bound in the Giaour and Don Juan. Like **Napoleon**, while yet aspiring, he is thin, wild and melancholy; when he had reached the summit, he is fat and smiling. But in both these otherwise so different countenances is seen that scornful, haughty spirit, deeply shaken by fate, more deeply sensitive by nature, which animated these features.


I can never refrain from laughing at the English, who pass such pitiful cockney judgments on this their second poet (for after **Shakspeare** the palm is surely his,) because he ridiculed their pedantry, because he could not adapt himself to the manners and usages of their little nook, nor share in their cold superstition; because their insipidity was sickening to him, and because he denounced their arrogance and hypocrisy. Many of them cross themselves (inwardly) when they mention him; and even the women, though their cheeks glow with enthusiasm when they read him, in public take part vehemently against their secret favourite.


It was worthy of grateful **Germany**, worthy of our Patriarch, to erect a lasting German arch of triumph, to a man who belongs to Europe, opposite to that monument of infamy which the English have laboured to build.


Could I but bid you a ‘farewell’ as immortal as his,—it should be no last, I hope no long farewell, but as tender and as touching.
Think of me thus.


Your faithful

 L——


---

p.340


### **Dublin**, Aug. 29th, 1828

Dear and kind one,


I have passed the last few days in bed with fever and pain. I am but now sufficiently recovered to answer your letter. What you send me from B—— is indeed very flattering to me, though the enthusiasm which my little labours excite in him is the growth of his own poetical soul alone, which paints what *ought to be,* and believes that *it is.* Do not wish for my return before it is possible; and trust me, that where a man is *not* he is commonly desired; as soon as he is there, he is thought, by many, in the way.


I rode out again to-day for the first time to see the fair at **Donnybrook**, near **Dublin**, which is a kind of popular festival. Nothing indeed can be more national! The poverty, the dirt, and the wild tumult were as great as the glee and merriment with which the cheapest pleasures were enjoyed. I saw things eaten and drunk with delight, which forced me to turn my head quickly away to remain master of my disgust. Heat and dust, crowd and stench, (‘il faut le dire,’) made it impossible to stay long; but these do not annoy the natives. There were many hundred tents, all ragged like the people, and adorned with tawdry rags instead of flags; many contented themselves with a cross, on a hoop; one had hoisted a dead and half putrid cat as a sign! The lowest sort of rope-dancers and posture-masters exercised their toilsome vocation on stages of planks, and dressed in shabby finery, dancing and grimacing in the dreadful heat till they were completely exhausted. A third part of the public lay, or rather rolled about, drunk; others ate, screamed, shouted and fought. The women rode about, sitting two and three upon an ass, pushed their way through the crowd, smoked with great delight, and coquetted with their sweethearts. The most ridiculous group was one which I should have thought indigenous only to **Rio de la Plata**: two beggars were seated on a horse, who by his wretched plight seemed to supplicate for them; they had no saddle, and a piece of twine served as reins.


As I left the fair, a pair of lovers, excessively drunk, took the same road. It was a rich treat to watch their behaviour. Both were horribly ugly, but treated each other with the greatest tenderness, and the most delicate attention. The lover especially displayed a sort of chivalrous politeness. Nothing could be more gallant, and at the same time more respectful than his repeated efforts to preserve his fair one from falling, although he had no little difficulty in keeping his own balance. From his ingratiating demeanour and her delighted smiles, I could also perceive that he was using every endeavour to entertain her agreeably; and that her answers, notwithstanding her ‘exalté’ state, were given with a coquetry and an air of affectionate intimacy which would have been exquisitely becoming and attractive in a pretty woman.


My reverence for truth compels me to add that not the slightest trace of English brutality was to be perceived: they were more like French people, though their gaiety was mingled with more humour, and more genuine good-nature; both of which are national traits of the Irish, and are always doubled by Potheen (the best sort of whisky illicitly distilled.)




---

p.341


Don't reproach me for the vulgarity of the pictures I send you: they are more akin to nature than the painted dolls of our ‘salons.’


### **Bray**, August 30th


I am returned hither on purpose to see the park of **Powerscourt**, from which Sunday lately debarred me. It would not be easy for Nature to unite greater capabilities than she has lavished here with bounteous hand; and her gifts have been skilfully turned to account. You enter by the **Dargle**, a very deep and narrow glen, thickly wooded with high trees. In the bottom gushes a full and rapid stream. The road ascends on the right side, and the eye travels down the green depths, out of which it catches here and there a gleam of the water, or a bold group of rocks. Three large mountains rise above the glen, and, though at some distance, seem quite close, as their base is hidden: they were tinged this evening with a deep rosy red, by a sun worthy of **Italy**, and contrasted beautifully with the bright green of the oaks.


Further on, the path suddenly opens on a rocky cliff, called ‘The Lover's Leap,’ where the glen diverges into several valleys, formed by chains of lesser hills, but terminated at some distance by the highest mountains of the neighbourhood. In the midst of this landscape appears the house, situated on a gentle slope on the edge of a wood, and surrounded by beautiful flower-gardens. From hence to the great waterfall, a distance of five miles, the road leads through ever varying scenes, which are more like those of beautiful nature than of a park. At length you reach a wood, and the rush of the distant waterfall meets your ear before you catch sight of it. It is inconsiderable, except after rain, but then it is magnificent. The lofty rocks are thickly covered on either side with shrubs, the cascade dashes through their varied foliage, and falling into a basin, flows away through a beautiful meadow. Around this are venerable oaks, under which a house, suited to the character of the place, has been built. Here, refreshments are to be obtained, and it is the usual resort of the many parties of pleasure who come hither. Green footpaths lead still further into the wild mountain country; but as it was already dark, I was obliged to return. On my way hither, I had gone over the greater distances in a gallop; and to avoid unnecessary delay, had taken up the ragged boy who acted as guide, behind me, regardless of the wonderment of the passers by, who knew not what to make of so extraordinary a cavalcade. At night I was obliged to ride slowly along the stony road, till the moon rose, orange-coloured, behind the mountains, and half shrouded herself in evening mists. I reached the inn at **Bray**, tired and hungry, at eleven o'clock.


### August 31st


I found this country inn so pleasant that I resolved to prolong my stay over to day—Sunday. Living at inns affords one a good opportunity of observing the middle classes. Every man here shows himself as he is, and seems to feel himself alone. I have already told you that English travellers of this class (I include all the inhabitants of the three kingdoms who have English manners and habits) usually pass their time, when not out of doors, in a common room called the coffee-room. In the evening this coffee-room is lighted with lamps; candles are carried, if called for, to the gentlemen who sit at the separate 



---

p.342



 
little tables. It has often surprised me that in a country in which luxury and refinement on all the wants of life are so universal, even in the best provincial inns (and often in **London**) tallow candles are commonly used. Wax candles are an unwonted luxury; and if you ask for them, you are treated with redoubled civility, but your bills are also doubled throughout.


It is very diverting to observe the perfect uniformity with which all behave, as if machines out of one workshop. This is particularly observable in their eating: though placed at separate tables, and no individual taking the slightest notice of any other, they all seem to have exactly the same usages, exactly the same gastronomic tastes. Nobody eats soup, which, unless bespoken beforehand, is not to be had. (This is the reason, by-the-bye, for which my old Saxon servant left me. He declared that he could not exist any longer in such a state of barbarism—without soup!) A large joint of roast meat is commonly carried from one to another, and each cuts off what he likes. This is accompanied by potatoes or other vegetables, boiled in water; and a ‘plat de ménage’ filled with sauces is placed on every table; beer is poured out, and there, in a common way, ends the dinner. Only the luxurious eat fish before meat.


But now follows the second stage:—the tablecloth is removed; clean plate, and knife and fork laid; wine and a wine-glass, and a few miserable apples or pears, with stony ship-biscuits, are brought: and now the dinner seems to begin to enjoy tranquillity and comfort. His countenance assumes an expression of satisfaction; apparently sunk in profound meditation, leaning back in his chair, and looking fixedly straight before him, he suffers a sip of wine to glide down his throat from time to time, only breaking the death-like silence by now and then laboriously craunching his rocky biscuits.


When the wine is finished, follows stage the third,—that of digestion. All motion now ceases; his appetite being satisfied, he falls into a sort of magnetic sleep, only distinguishable from the natural by the open eyes. After this has lasted for half an hour or an hour, all at once it ceases; he cries out, as if under the influence of some sudden possession, ‘Waiter, my slippers;’ and seizing a candle, walks off gravely to his chamber to meet his slippers and repose.


This farce acted by five or six men at once has often amused me more than a puppet-show; and I must add, that with the exception of the incident of the slippers, pretty nearly the same scene is represented in the first clubs of the metropolis. I scarcely ever saw an Englishman read at dinner; I am not sure that they don't think it an act of indecorum—perhaps of impiety—like singing or dancing on a Sunday for instance. Perhaps, however, it is only a rule of diatetics converted by time into a law, which no vivacity of temper can break through


Englishmen who do not belong to the aristocracy, and are not very rich, usually travel without a servant by the mail or stage-coach, which deposits them at the inn. The man who waits on strangers to the coach, cleans their boots, &c. has the universal appellation ‘Boots.’ It is, accordingly, ‘Boots’ who brings your slippers, helps you to pull off your boots, and then departs, first asking at what time you will have, not as in **Germany**, your coffee, but your hot water to shave. He appears with it punctually at the appointed hour, and brings. your clothes cleanly brushed. The traveller then hastens to dress himself and return to his beloved coffee-room, where the ingredients



---

p.343



of breakfast are richly spread upon his table. To this meal he seems to bring more animation than to any other, and indeed I think more appetite; for the number of cups of tea, the masses of bread and butter, eggs and cold meat, which he devours, awaken silent envy in the breast, or rather in the stomach, of the less capable foreigner. He is now not only permitted, but enjoined (by *custom,* his gospel) to read. At every cup of tea he unfolds a newspaper of the size of a table-cloth. Not a single speech, crim. con., murder or other catastrophe invented by the ‘accident maker’ in **London**, escapes him.


Like one who would rather die of a surfeit than leave any thing uneaten which he had paid for, the systematic Englishman thinks that having called for a newspaper he ought not to leave a letter of it unread. By this means his breakfast lasts several hours, and the sixth or seventh cup is drunk cold. I have seen this glorious meal protracted so long that it blended with dinner; and you will hardly believe me when I assure you, that a light supper followed at midnight without the company quitting the table.


On this occasion several were assembled; and I must remark, generally, that when that is the case, a very different scene is exhibited. The wine, instead of producing the lethargic reverie I have described, makes them rather too talkative. Something of the kind occurred to-day. Five or six travellers were very jovial, and having carried this a little too far, a violent quarrel arose among them, which, after long continued noise and confusion, ended, strangely enough, in their all falling foul of the waiter and pushing him out at the door. Upon this the host was forced to come in, and to beg pardon for the poor fellow, who was perfectly innocent. Not one of the men who were eating at their solitary tables took the slightest notice of this affray, but stared straight before them just as indifferently as if nothing were going on.


Soon, however, one of them who had begun his dinner very late gave us a new scene. He was dissatisfied with the mutton they had brought him, and desired the waiter to tell the cook she was a d—— b——. On receiving this communication, the Irishwoman lost all respect for the author of so sensible an insult; tore herself out of the arms of her companions who vainly attempted to hold her at the dining-room door, darted with doubled fists on the offender, and overwhelmed him with such a torrent of truly national epithets, that he turned pale and left the field, roaring ‘my slippers’ as loud again as usual, and without further attempt at resistance hastily retreated to his chamber in the third story; for, as you know, the bedrooms here are always under the roof, ‘comme au Columbier.’


When the late Grand Duke of W—— was in **England**, he was seized with the desire to travel alone and incognito by the ‘stage,’ as a means of becoming more intimately acquainted with English life. It amused him much: the next morning, however, he was not a little surprised, when the ‘boots’ brought him his clothes, at his saying, ‘I hope your Royal Highness slept well last night.’ He thought, however, he might have misunderstood, and taking no notice of the thing, continued his journey on the outside. The next morning, the same title. He now inquired into the matter, and found that a card with his name and rank was stitched to the inside of his cloak, and had destroyed his ‘incognito.’ What struck him the most doubtless was, that troubled themselves so little whether a German sovereign



---

p.344



prince sat on the top of the stage-coach or not. The common people in **England** care little about rank,—about foreign rank nothing. It is only the middle classes that are servile: they are delighted to talk to a foreign nobleman because they cannot get at their own haughty aristocracy. The English nobleman, even the least of the Lords, in the bottom of his heart thinks himself a greater man than the king of **France**.


This mode of travelling, to a man who has any thing in view beside mere change of place, or who does not feel himself flattered by the increased reverence of innkeepers and waiters, is certainly preferable to the usual manner of making the grand tour. The diminution of comfort and convenience is counterbalanced by so much that is instructive and agreeable, that one gains a hundredfold by the change.


### **Dublin**, September 1st


I returned, this time, by way of **Kingston**, along a rough but very romantic road, close to the sea. A crowd of beggars stood on the road. They were not, however, deficient in industry and activity, for an old woman among them was busily gathering up some white sand which had fallen from a cart. How I wished to open the treasures of our Sand-Golconda to this poor creature! As I could not, I made her happy with a few pence, of which I always carry a cargo in my coat-pocket to throw out like corn among fowls; for here every body begs.


**Kingston** is a little town, consisting chiefly of the country houses of the opulent people of **Dublin**. The **Lord Lieutenant** sometimes resides here. Since the king's visit a harbour has been made, at which the men are still at work. The shallowness of **Dublin** Bay renders this very desirable; but its principal end now is to give work to the lower classes. The many ingenious inventions which are here applied, the four rail-roads running side by side, on which one horse can draw enormous loads, the chain windlasses by which huge masses are brought to hand and walled into the dam, and other things of the like kind, are uncommonly interesting and instructive. Several large ships are lying in the unfinished harbour, in which they already find deep water and safe anchorage. Among them I was struck by the appearance of a black hulk, which lay like a solitary ghost; it contained, as I was told, the convicts ordered for transportation to **Botany Bay**; the transport ship which was to convey them had already arrived. This is no very severe punishment (deducting sea-sickness), and converts two-thirds of these criminals into useful citizens. Every government might (according to its local resources) create a **Botany Bay**; but it will be long ere the principle of vengeance is banished from our systems of law or of religion.


A monument has been erected at the entrance of the harbour, in honour of the King's memorable visit (memorable, that is, for its disappointing all hopes and expectations). It is designed and executed with the sort of taste which seems to lie like a curse on all the public buildings of **Great Britain**: it is a small, ridiculous stump of an obelisk, perched on the corner of a natural rock; it stands on four balls, and looks precisely as if the first blast of wind would roll it into the sea. One cannot suppress the wish that this may happen;—the sooner the better. The royal crown is stuck at the top like a lid on a mustard-pot, and the whole, contrasted with the noble



---

p.345



dimensions of the harbour and surrounding buildings, is so small and ‘mesquin’ that it might be taken for the whim of a private man, but certainly never for a national monument. Perhaps the architect was a ‘mauvais plaisant,’ and meant it satirically:—as an epigram it is deserving of praise.


The road from hence to **Dublin** is very fine, and covered with riders and carriages. I wondered not to find it watered, which makes the roads near **London** so agreeable. Probably it is only done when the **Lord Lieutenant** is here. The dust to-day was almost insufferable, and all the trees covered as if with chalk.


I returned to **Dublin** just at the moment of a meeting of the ‘**Catholic Association**,’ and alighted at the door of their house: unfortunately, however, neither **Shiel** nor **O'Connell** was present, so that there was no great attraction. Heat and bad smells, (‘car l'humanité Catholique pûe autant qu'une autre,’) drove me out in a few minutes.


In the evening I was better amused by the performances of some other charlatans,—a company of English horse-riders who are here. Mr. Adams, in his way indisputably ‘le premier des hommes,’ was leader of the ‘Academy,’ which deserved its name better than some others I could mention.


It was pleasant to see about twenty elegantly dressed young men, all moving with nearly equal grace and dexterity—often bewildering the eye by the artful confusion, the variety, difficulty and extreme rapidity of their movements, forming a wild dissonance or chaos, and then resolving this into the most graceful harmony. Still more delightful were two inimitable clowns, whose limbs were perfectly at their disposal. The one was excellently supported by his piebald ass, which shamed the noblest horses in the precision with which he executed his feats; and the other on an instrument of his own invention, produced a sort of music so truly mad, that even the mere tones excited resistless laughter.


The performance was closed by a ‘pas de deux’ of the two clowns, danced on their hands and feet; the latter cutting capers in the air, while the former supported the weight of their bodies. Here the human form seemed obliterated; and the scene, frightful as a tale of **Hoffman**'s, appeared to the bewildered spectator like the dance of two mad polypi.


*[Here some leaves of the correspondence are wanting.]*


### B——m, in the West of Ireland, Sept. 5, 1828

Dear Julia,


You make me laugh by your gratitude for my diligence in writing. Are you not aware that I can have no greater enjoyment? I have hardly written a word before I feel myself at home, and new comfort and courage are infused into my heart.


Do you remember the young parson at **Bray**? Though he converted the God of Mercy into the greatest of all tyrants, he himself is a very good-hearted fellow ‘qui n'y entend pas malice.’ He gave me such a hearty invitation to accompany him to his father's house in Connaught,—who, as he assured me, was no less hospitable than 



---

p.346



 
rich,—that I consented, ‘et m'y voilà!’ This wild part of **Ireland**, seldom visited by natives, never by foreigners, has such a bad name, that there is a proverb— ‘Go to hell and Connaught!’ It was therefore a matter worthy of deliberation; but what deters others often attracts me; such situations too I have often found the richest in amusement. The present promises me this in abundance, at least so far as novelty and strangeness go.


Yesterday evening after dinner we left the metropolis in my carriage. We had just a hundred-and-one miles to go. In **England** this is soon accomplished; here things are very differently managed, and it took us four-and-twenty hours.


The scenery is strikingly like the Wendish districts of Lower Lusatia, whither my unlucky stars once drove me; except that there are thick woods, while here, with the exception of a few arid furs, they appear only to *have been.* Boundless plains are covered with bog and turf; the oakwood, thousands of years old, which is found sometimes at a great depth, fetches a high price for decorative furniture; snuff-boxes and ladies' ornaments are likewise made of it. The other part of the soil is sandy or wet: the dry lands are meagre and barren; but on the other hand the bog cultivation, which is admirably understood, is very successful. The bog is first levelled, the projecting part being cut into squares of turf, and the soil then burnt and sown with corn. All the bogs appear to be remarkably deep: the principal crops are buckwheat, potatoes, and oats. The cabins of the inhabitants are beyond description wretched, and the appearance of all the flat country extremely poor, till you approach my friend's estate, where Nature becomes more smiling; and blue hills, the scene of many a wondrous tale, peep above the horizon.


My host, Captain W——, is one of the ‘Notables’ of his county, but his house is not better than that of a German nobleman of moderate estate. English elegance and English luxury are not to be thought of; wax lights are unknown; port and sherry, but above all ‘whiskey-punch’ are the only beverages: the coffee is detestable; but the food excellent, nutritious, and plentiful. The house is not over-clean; the small establishment very respectable from length of service, zeal and attachment, but of a somewhat unwashed and boorish appearance.


From my chamber windows I penetrate into all the mysteries of the domestic economy, which is too modest to spread out the dunghills as chief ‘point de vûe,’ as in North **Germany**. The rain (for alas! it does rain) runs merrily through my windows, and falls in romantic cascades from the window-sill to the floor, where an old carpet thirstily drinks the stream. The furniture is rather tottering; but I have tables enough (a great matter to me with my multitude of things,) and the bed seems at least large and hard enough. In my chimney burns, or rather smoulders, capital turf, which not only gives heat, but covers everything with fine ashes, like an eruption of Vesuvius. All this does not sound brilliant;—but how largely are these trifles outweighed by the patriarchal hospitality, the cheerful, easy, unaffected kindness of the family. It is as if my visit were a distinguished favour, for which all seem to feel indebted to me as for some real service.


### Sept. 6th


I like my host very much; he is seventy-two years old, and still



---

p.347



hale and vigorous as a man of fifty. He must have been very handsome, and has given the world twelve sons and seven daughters,—all by the same wife, who is still living, though just now too unwell for me to see her. Some of the sons and daughters have been long married, and the old man sees his grandsons of twelve at play with his youngest daughter of fourteen. The greater part of the family is now here, which makes the abode rather a noisy one; this is increased by the musical talents of the daughters, who daily perform on an instrument horribly out of tune,—a circumstance which seems not to annoy them in the slightest degree. The men generally talk about horses and dogs, and are somewhat uninstructed. To-day a country squire in the neighbourhood searched long and patiently in a map of Europe for the **United States**:—at last his brother-in-law gave him the fortunate suggestion of trying his luck on the map of the world. The occasion of the search was, that the old gentleman wanted to show me Halifax and B—— town, which latter takes its name from him. He laid the first stone of both during the American war, in which he commanded seven hundred men, and loves to recal those days of his youth and importance. The scrupulous and chivalrous courtesy of his manners, the constant and ready sacrifice of his own convenience to others, are proofs of the education of times long passed, and marks his age more surely than his appearance does.


Our amusements for some days to come are arranged as follows.—In the morning we go to church; the day after to the town of **Galway**, to see some horse-races, in which the poor animals not only run a German mile, but in the course of it have to leap several walls! They are ridden by gentlemen. In the evening is a ball, at which I am promised a sight of all the beauty of the neighbourhood.


To tell you the truth, touched as I am by the kindness shown me in this house, I rather dread a long stay: I should, however, vex these excellent, cordial people if I showed it; ‘Je m'exécute donc de bonne grâce.’


### Sept. 7th


The manners here are so old-fashioned that the master of the house every day drinks to my health, and we have no napkins at table, for which pocket-handkerchiefs or the corners of the table-cloth are obliged to serve as deputies.


We passed four hours this morning in the church of the neighbouring town of Tuam, and saw four clergymen ordained by the archbishop.


The English Protestant service differs much from ours: it is a strange mixture of Catholic ceremony and Protestant simplicity. Pictures on the walls are not suffered,—on the windows they are. The dress of the priests, even of the archbishops, consists only of a white surplice. On the other hand, the seat of the latter, built like a throne, covered with purple velvet and adorned with an archbishop's crown, stands ostentatiously opposite to the chancel. The sermon is read, and lasts very long. The most wearisome part, however, both before and after it, is the endless repetition of antiquated and contradictory prayers, the burthen to which is occasionally re-echoed



---

p.348



in singing from the choir. These form a perfect course of English history. **Henry the Eighth**'s ecclesiastical revolution, **Elizabeth**'s policy, and **Cromwell**'s puritanical exaggerations, meet and shake hands; while certain favourite phrases are repeated every minute, many of which are more characteristic of cringing slaves prostrate in the dust before an eastern tyrant, than of Christian freedom and dignity.


The text was chosen, strangely enough, from the story of the passage of the evil spirits into the herd of swine; and after this had been discussed for an hour, the four priests were ordained.


The old archbishop, who enjoys a high reputation for strict orthodoxy, has a very dignified air, and a fine sonorous voice; but the deportment of the young divines displeased me exceedingly; it was disgustingly hypocritical. They continually wiped their eyes with their pocket-handkerchiefs, held them before their faces as if in the deepest emotion, answered with a broken voice;—in short, **Herrnhuters** could not have acted it better: ‘La grâce n'y étoit pas;’ of no kind.


One of the oddest customs is, that every body during the short prayer at coming and going, turns himself to the wall, or into a corner, as if he were doing something not fit to be seen.


I must frankly confess it,—I do not understand how a reflecting man can be edified by such a service. And yet how beautiful, how elevating might the service of God be, if while we dismissed all ridiculous and unmeaning ceremonies, we did not require an abstract worship, from which sense were utterly excluded,—an impossibility for creatures of sense! Why should we not devote all our best powers to the honour of him who gave them? Why not employ every art in its highest perfection, in order to consecrate to God the noblest, the finest works that the human faculties can produce?


I can imagine a congregation, whose piety is equally removed from mean servility and from arrogant conceit; who meet to praise the infinite greatness and love of the Universal Father, and the wonders of his creation—not to bring within the walls consecrated to him the hatred of bigotry and intolerance;—whose creed demands from each man only that degree of belief which his own inward revelation makes possible to him. Before my fancy no longer float separate churches for Jews, and for fifty sorts of Christians; but true temples of God and Man, whose gates at all times stand open to every human being, who when oppressed by the Earthly, seeks to have the Holy and the Heavenly within him, animated and sustained by all the aids and appliances of sense or spirit; or who longs to pour out the overflowings of his heart, when filled with happiness and gratitude.


### **Galway**, Sept. 8th


We arrived very late on the ‘race-course,’ and saw little of this day's sport. The sight of the people was however extremely curious and interesting to me. In many points of view this nation is really semi-barbarous. The universal want of decent clothing among the lower classes, even on festivals like the present; their utter inability to resist ardent spirits, so long as they have a penny in their pockets; the sudden and continual wild quarrels and national pitched battles with the shillelah (a murderous sort of stick which every man keeps hidden under his rags), in which hundreds take part in a 



---

p.349



minute, and do not resist till several are left dead or wounded on the field; the frightful war-whoop which they set up on these occasions; the revenge for an affront or injury, which is cherished and inherited by whole villages:—on the other hand, the light-hearted carelessness which never thinks of the coming day; the heart-felt merriment, forgetful of all want and suffering; the kind hospitality which ungrudgingly shares their last morsel; the unreserved cordiality with the stranger, who makes any advances to them; the natural fluency and eloquence which they have ever at command;—all are characteristics of a half-civilized people.


Hundreds of drunken men accompanied our carriages as we drove from the race-course to the town, and more than ten times, fights arose among them. The confluence of guests was so great that we with difficulty found a miserable lodging:—our dinner was however good and very abundant.


**Galway** was chiefly built by the Spaniards. Some descendants of the ancient families still exist, as do several very curious houses of that period. It struck me as characteristic, that in a town of forty thousand inhabitants there was not a single bookseller's shop or circulating library to be found. The suburbs and all the villages through which we passed on our way, were of a kind which I should vainly attempt to liken to any thing ever seen before:—pigsties are palaces in comparison; and I often saw numerous groups of children (for the prolificness of the Irish people seems to keep pace with their wretchedness), naked as they came into the world, roll and paddle about with the ducks in the filthy kennels with the greatest delight.


### **Athenrye**, Sept. 10th: Morning


I write to you this morning from the house of one of the sweetest women I ever saw in my life: an African too,—and as she tells me, by birth a Mademoiselle H——. ‘Que dites vous de cela?’ But more of her hereafter. You must now accompany me to the ‘race-course,’ and see the running and leaping from the beginning. It is a remarkable sight of its kind, and exactly suited to a half-savage nation. I confess that it far exceeded my expectations, and kept me in a state of intense anxiety; only one must leave pity and humanity at home, as you will see from what follows.—The race-course is an elongated circle. On the left side is the starting post; opposite to it, on the right, is the goal. Between them, at the opposite points of the circumference, are built walls of stone without mortar, five feet high and two broad. The course, two English miles in length, is run over once and a half. You see then, from my description, that the first wall must be leaped twice, the second only once in each heat. Many horses run, but none is declared winner till he has beaten the others in two heats; so that this is often repeated three, four, or even five times, if a different horse comes in a-head each time. To-day they ran four times; so that the winner, in a space of less than two hours, reckoning the intervals, ran twelve English miles at full speed and leaped the high wall twelve times!—a fatigue which it is difficult to conceive how any horse can stand. Six gentlemen in elegant jockey dresses of coloured silk jackets and caps, leather breeches and top-boots, rode the ‘race.’ I had an excellent hunter belonging to the son of my host, and could, therefore, by crossing the course, keep up perfectly well, and be present at every leap.




---

p.350


It is impossible not to have a favourite on such occasions. Mine, and indeed that of the public, was an extremely beautiful dark bay, called Gamecock, ridden by a gentleman in yellow,—a handsome young man of good family, and a most admirable rider.


After him the horse which pleased me the most was a dark brown mare called Rosina, ridden by a cousin of Captain B——; a bad rider, in sky blue. The third in goodness, in my opinion, Killarney, was a strong, but not very handsome horse, ridden by a young man who showed more power of endurance than perfect horsemanship: his dress was crimson. The fourth gentleman, perhaps the most skilful, though not the strongest of the riders, rode a brown horse, not remarkable in its appearance, and was dressed in brown. The other two deserve no mention, as they were ‘hors du jeu’ from the beginning: they both fell at the first leap; the one sustained a severe injury on the head, the other came off with a slight contusion, but was disabled from riding again. Gamecock, who darted off with such fury that his rider could hardly hold him in, and flew, rather than leapt, over the walls, with incredible bounds, won the first heat with ease. Immediately after him came Rosina without her rider, whom she had thrown, and took the remaining leaps of her own accord with great grace. Gamecock was now so decidedly the favourite that the bets were five to one upon him: but the result was far different from these expectations, and very tragical. After this noble animal had distanced the other two in two successive heats, and had achieved the two first leaps in the most brilliant manner, he set his foot, in the third, on a loose stone which one of the less skilful horses had pushed down as he fell, and which *it was not permitted to remove out of the course.* He fell backward upon his rider with such violence that both lay motionless, when the other riders came up, took not the slightest notice of them, and accomplished the leap. After a few seconds Gamecock got up, but his rider did not recover his senses. A surgeon present soon pronounced his state to be hopeless; both his breast-bone and skull were fractured. His old father, who stood by when the accident happened, fell senseless on the ground, and his sister threw herself with heart-rending cries on the yet palpitating though unconscious body. But the general sympathy was very slight. After the poor young man had been repeatedly bled, so that he lay on the turf weltering in his blood, he was taken away, and the race began again at the appointed time as if nothing had happened.


The brown rider had been the first in the preceding heat, and hoped to win the last and decisive one. It was what the English call ‘a hard race.’ Both horses and men did their part admirably, they ran and leaped almost in rank. Killarney at last won only by a quarter of a head:—it was necessary therefore to run again. This last contest was of course the most interesting, since one of the two running must of necessity win everything. There was a great deal of betting, which at first was even. Twice did the victory appear decided, and yet at last terminated on the contrary side. At the first leap the horses were together; before they reached the second it was evident that the brown was exhausted, and Killarney gained so much upon him that he reached the second wall more than a hundred paces before him. But here, contrary to all expectations, he refused to leap, and the rider had lost all power over him. Before he could be brought to obey, the brown came up,—made his leap



---

p.351



well; and now putting out all his strength, was so much a-head that he seemed sure of winning. Bets were now ten to one. But the last wall was yet to cross, and this was fatal to him. The tired animal, who had exhausted his last remaining strength in fast running, tried the leap willingly enough indeed, but had no longer power to effect it; and half breaking down the wall, he rolled bleeding over and over, burying his rider under him so that it was impossible for him to rise. Killarney's rider had in the mean time brought his refractory horse into subjection, achieved the two remaining leaps amid the cheers of the multitude, and then rode at a foot pace, perfectly at his ease and without a rival, to the goal. He was so exhausted, however, that he could scarcely speak.


In the intervals between the preceeding heats I was introduced to many ladies and gentlemen, all of whom most hospitably invited me to their houses. I however preferred following my young host, who promised to show me the fairest of the fair, if I would give myself up to his guidance, and not object to riding ten miles in the dark. On the way he told me that this lady was called Mrs ——, and was the daughter of the late Dutch governor of ——, that she had had a complaint in the lungs, and was now staying in the solitary village of **Athenrye**, on account of the salubrity of its air.


We did not arrive till ten; and surprised her in her little cottage (for the place is miserable) at tea.


I wish I could describe this sweet and lovely being to you in such a manner as to place her visibly before you; certain that you, like me, would love her at the first glance. But I feel that here all description falls short:—all about her is heart and soul, and that is not to be described;—she was dressed in black, with the greatest simplicity, her dress up to the neck, but fitting closely to her beautiful form. Her person is slender and extremely youthful, full of gentle grace, and yet not without animation and fire in her movements. Her complexion is of a pure and clear brown, and has the soft polish of marble. More beautiful and brilliant black eyes, or teeth of more dazzling whiteness, I never beheld. Her mouth too, with the angelic, childlike character of her smile, is enchanting.


Her refined unaffected good-breeding, the sportive graces of her gay and witty conversation, were of that rare sort which are innate, and must therefore please, whether in **Paris** or in **Pekin**, in town or country. The greatest experience of society could not give more ease or address, and no girl of fifteen could blush more sweetly, or jest more joyously. And yet her life had been the most simple and uniform, and her youth was rather the unfading spring of the soul than that of the body; for she was mother of four children, near thirty, and but just recovered from an attack on the lungs which had threatened to prove fatal. But the fire of all her movements, the lightning-flashes of her conversation, had all the freshness and all the power of youth, imparting a resistless charm to the gentleness of her nature. One felt that this was the child of a warmer and kindlier sun, of a more luxuriant soil, than are to be found in our misty climes. And indeed she felt the most melancholy longings after her native land, and a painful expression passed over all her lovely features as she said, she should never more breathe that balmy air charged with sweet odours. I was too much absorbed in looking at her to think of food, had she not, with all the kind activity of a good housewife, made preparations for entertaining us as well as she could



---

p.352



in her little cabin. A table was set in the room in which we sat; so that our frugal meal caused no interruption to the conversation, and it was long after midnight ere we separated.


It was not till I was in bed that I learned that, finding it impossible to get us beds in a place consisting of only a few cabins, this kind-hearted and unceremonious woman had quitted her own for me, and gone to sleep with her eldest daughter.


Concerning her family, whose name was necessarily so striking to me, Mrs. —— herself could tell me but little. She had married Mr. ——, then a captain in the British army, in her twelfth year: immediately afterwards she lost her father, and embarked with her husband for **Ireland**, which she has never left. She had heard, indeed that she had relations in **Germany**, but never corresponded with them. Three years ago she received a business letter from a cousin in A——, announcing that her father's brother had died and had left her heir to his whole property. The indifference of this African child of nature went so far, that she had not only up to the present time left this letter unanswered, but, as she told me, had never been able to decypher the whole of it, as it was written in Dutch, and she had almost entirely forgotten the language. ‘I don't know the man,’ added she innocently, ‘and the money affairs I left to my husband.’


This bathing-place, **Athenrye**, is also one of the curiosities of **Ireland**. From what I have already said, you will conclude that no Polish village can have a more wretched aspect. The cluster of cabins is on a bare hill rising out of the bog, without tree or bush, without an inn, without any convenience, inhabited only by ragged beggars, and by the few invalids who bring with them everything they want, and must send for even the most trifling article of food to **Galway**, a distance of twelve miles. Once it was otherwise; and it saddens one to see at the further extremity of this wretched village the proud ruins of better times. Here stood a rich abbey, now overgrown with ivy: the arches which once protected the sanctuary lie in fragments amid the unsheltered altars and tombstones. Further on is a castle, with walls ten feet thick, in which King John held his court of justice when he came over to **Ireland**.


I visited these ruins with a most numerous company: I do not exaggerate when I say that at least two hundred half-naked beings, two-thirds of whom were children, had collected round my carriage at a very early hour in the morning, doing nothing: they now thronged round me, all begging, and shouting, ‘Long life to your honour!’ Every individual among them stuck faithfully by me, leaping over stones and brambles. The strangest compliment now and then resounded from the midst of the crowd: at last some called out, ‘Long life to the King!’ On my return I threw two or three handfuls of copper among them; and in a minute half of them, old and young, lay prostrate in the sand, while the others ran with all speed into a whiskey-shop, fighting furiously all the way.


Such is **Ireland**! Neglected or oppressed by the government, debased by the stupid intolerance of the English priesthood, and marked by poverty and the poison of whiskey, for the abode of naked beggars!—I have already mentioned that even among the educated classes of this province, the ignorance appears, with our notions of education, perfectly unequalled: I will only give you one or two examples. To-day something was said about magnetism, and no one



---

p.353



present had ever heard the slightest mention of it. Nay, in B——m, in a company of twenty persons, nobody knew that such places as Carlsbad and Prague existed. The information that they were situated in Bohemia did not mend the matter:—Bohemia was not less unknown; and in short, everything out of **Great Britain** and **Paris** was a country in the moon. ‘And where do you come from?’ asked one. ‘From Brobdignag,’ said I in jest. ‘O! is that on the sea? Have they whiskey there?’ asked another. The son of my host, whom I have repeatedly mentioned, asked me one day very seriously as we met some asses, whether there were any such animals in my country? ‘Ah! but too many,’ replied I.


### B——m, Sept. 12th


Yesterday we returned home, tearing ourselves away from the lovely African, who however had promised soon to follow us. To-day I took advantage of a leisure day to ride to Castle Hackett, a solitary hill in the neighbourhood, believed by the people to be a favourite resort of the fairies, or ‘good people’ as they call them. No nation *is* more poetical, or more richly endowed with fancy. An old man who has the care of the woods of Castle Hackett, and has the reputation of knowing more than other men about the ‘good people,’ told us these circumstances connected with the death of his son, in the style of a romance.


‘I knew it,’ said he, ‘four days before—I knew he would die; for as I was going home that evening about twilight, I saw them scouring in a wild chase over the plain: their red dresses fluttered in the wind; and the lakes turned to ice as they came near, and walls and trees bowed themselves to the earth before them; and they rode over the tops of the thicket as if it were over the green grass. In front rode the queen, on a white stag-like horse; and by her I saw, with a shudder, my son, whom she smiled upon and caressed; while he, with a fevered eye, looked wistfully at her, till all were past Castle Hackett. Then I knew it was all over with him;—that same day he took to his bed;—on the third I carried him to the grave. There was not a handsomer or a better lad in **Connemara**, and it was for that the queen chose him.’


The old man seemed so firmly and unaffectedly convinced of the truth of his story, that it would only have offended him to express the least doubt of it. He replied to our inquiries for further details with great readiness, and I promise myself the pleasure of giving you the most accurate description of the dress of the fairy queen for your next masked ball. At the foot of this hill is a pretty country-seat; and the hill itself is covered to its summit with young and thriving plantations. On the top is a sort of artificial ruin, made of loose stones piled together, laborious and almost dangerous to climb. The view from it is, however, worth the exertion. On two sides the eye wanders over the almost immeasurable plain; on the other two lies **Lough Corrib**, a lake thirty miles in length, behind which are the mountains of Clare; and in still remoter distance the romantic ridge of **Connemara**. The lake just at its middle bends inland like a river, and its waters gradually lose themselves between the lofty mountains, which seem to form a gateway for their entrance. Just at this point the sun set; and Nature, who often rewards my love for her, displayed one of her most wondrous spectacles. Black clouds hung over the mountains, and the whole heavens



---

p.354



were overcast. Only just at the point where the sun looked out from beneath the dusky veil, issued a stream of light which filled the whole ravine with a sort of unearthly splendour. The lake glittered beneath it like molten brass; while the mountains had a transparent, steel-blue lustre, like the gleam of diamonds. Single streaks of rose-coloured cloud passed slowly across this illumined picture over the mountains; while on both sides of the opened heavens, distant rain fell in torrents, and formed a curtain which shut out every glimpse of the remaining world. Such is the magnificence which Nature has reserved for herself alone, and which even **Claude**'s pencil could never imitate.


On our way home my young friend discoursed largely on the perfections of Mrs L——. Among other things, he said, ‘Never with all her vivacity did I see, even for an instant, the least trace of impatience or ill-humour about her; never had a woman a sweeter temper.’ This word is, like ‘gentle,’ untranslatable. Only the nation which invented ‘comfort’ was capable of conceiving ‘good temper,’ for ‘good temper’ is to the moral what ‘comfort’ is to the physical man. It is the most contented, the most comfortable state of the soul: the greatest happiness both for those who possess it, and for those who feel its influence. Perhaps it is found in perfection in woman alone; for it is rather a passive than an active quality: and yet we must by no means confound it with mere apathy, which is either tedious, or exasperates one's anger and contempt; whereas ‘good temper’ soothes and tranquillizes all who approach it. It is a truly kind, loving and cheerful principle; mild and balmy as a cloudless Mayday. With ‘gentleness’ in his own character, ‘comfort’ in his house, and ‘good temper’ in his wife, the earthly felicity of man is complete. ‘Good temper,’ in the highest sense, is doubtless one of the rarest qualities; the consequence of an absolute harmony, or equilibrium of the moral powers, the most perfect health of the soul. Great and striking single qualities cannot therefore be combined with it; for wherever one quality is predominant, the equilibrium is destroyed. It is possible to be most captivating, to inspire passionate love, admiration or esteem, without ‘good temper;’ to be perfectly and lastingly amiable without it, it is impossible. The contemplation of harmony in all things has a salutary effect on the mind; often unconscious of the cause, the soul is gladdened and refreshed by it, whatever be the sense through which it is communicated. A person therefore who is gifted with ‘good temper,’ affords us continual enjoyment, without ever awakening our envy, or exciting any vehement emotion. We gain strength from his tranquillity, courage from his cheerfulness, comfort from his resignation; we feel our anger vanish before his loving patience, and are finally the better and the happier for listening to the spiritual music of his harmony.


How many words, you will say, to describe one! And yet, dear Julia, I have very imperfectly expressed what ‘good temper’ is.


### September, 3th


The beautiful view of yesterday evening enticed me to take a nearer survey of what I had beheld at a distance. My obliging friend speedily fitted out an equipage for this purpose, a little ‘char à banc’, which was drawn by two horses ‘tandem’ (one horse before another). We determined to visit Lake Corrib, Cong and its caverns, and to return in the night. After four hours smart trotting, and 



---

p.355



some little accidents to our frail tackle, we reached Cong, at a distance of twenty miles, where we ate a breakfast we had brought with us, of lobster prepared after the Irish fashion. Knives and forks were not to be had, so that we adopted the Chinese mode of eating. We then set out to the caverns, accompanied as usual by a half-naked cortége.


Every one of them was on the watch to do us some service: if I stooped to pick up a stone, ten or a dozen scrambled for it, and then asked for money; if there was a gate to open, twenty rushed to it, and expected a like reward. After I had given away all my small money, came one who affirmed that he had shown me some trifle or other. I unwillingly refused him, and told him my purse was empty. ‘Oh,’ said he, ‘a gentleman's purse can never be empty!’ no bad answer; for under the form of a compliment lurks a sort of reproach. ‘You look too much like a ‘gentleman’ not to have money, but if you are so ungenerous as not to give any, you are not a true gentleman; and, if you really have none, still less are you one.’ The crowd felt this, and laughed till I bought my deliverance from him. But to return to the ‘Pigeon-hole.’ It lies in the middle of a field, bare, and treeless, which, although flat, is covered with masses of limestone of a peculiar form, between which the scanty soil is with difficulty cultivated. These pieces of rock are as smooth as if polished by art, and look like stones regularly piled and half prepared for some colossal building. In this rocky plain, at about half a mile from Lough Corrib, is the entrance of the cave, like a broad dark well, in which thirty or forty steps, roughly hewn in the rock, lead down to the stream, which here flows subterraneously, making its way through long and romantic arches, till at length it rises into day, and turns a mill. It then buries itself a second time in the earth, and at length appears again as a broad, deep, and crystal river, and thus flows on till it falls into the lake.


Not far from the cave before which we were now standing lives a ‘Donna del Lago’ who pays the lord of the soil four pounds a-year for the privilege of showing the ‘Pigeon-hole’ to strangers. She was admirably fitted for the porteress of such an entrance to the nether world, and indeed the whole scene could not be better ‘in character,’ as the English say. We had descended the steps in the dark, and heard the rush of invisible waters, when the gigantic, haggard old woman, with a scarlet cloak loosely thrown around her, long streaming white hair, and a firebrand in each hand, came down—the living original of Meg Merrilies. It was a wild scene! Her flickering torches threw fitful gleams on the rolling water, and the lofty vaulted roof bristling with stalactites; and now and then brought out the pale and squalid figures behind her with a broad red glare. She took some bundles of straw, and with words which sounded like an incantation, lighted them and threw them blazing into the stream. As they floated rapidly away, they disclosed new grottoes, more grotesque forms, and at length, after a hundred windings, disappeared in the distance like small tapers. We followed them, scrambling over the slippery stones as far as we could, and discovered here and there a trout in the ice-cold water. They have this peculiarity, that whatever bait may be offered them, no attempt to catch one has ever succeeded. The people of course think them enchanted.


On emerging from the darkness to the spot where daylight breaks faintly, as down a shaft, you see the ivy and creeping plants hang



---

p.356



around the rocks in the most picturesque festoons and garlands. Here flocks of wild pigeons roost, whence the cave has its name. The popular superstition permits no sportsmen to molest them in this spot, so that they are fearless as in a dove-cote.


We quitted this gloomy region, where all is close and oppressive, and wandered down to the broad sea-like lake, where all seems to lose itself in boundless space. This majestic body of water fills a basin of twelve German miles long, and at its widest point, three broad. It contains just as many islands as the year days; at least so the natives assert,—I did not count them. It is bounded on two sides by the high mountains of Connemara; on the others its waters are nearly level with the plain: the approach to it opposite to the mountains was, therefore, more beautiful than the return. The navigation of this lake is very dangerous from its numerous rocks and islands, and the sudden squalls which often arise upon it. We saw in a newspaper a short time ago, that a boat, having on board a butcher and his sheep, had gone down, and man and beast perished. We had a very calm, though not a bright day. When we landed, my companion went before to give some orders; while as the sun was setting, I visited the ruins of an abbey, which contained some striking remains of architectural and sculptural beauty.


**Ireland** is studded with ruins of old castles and monasteries more thickly than any country in Europe, though they do not present such enormous masses as those in **England**. These *old* ruins (for unfortunately even here are many new ones) are constantly used by the people as places of burial,—a poetical idea, peculiar, I believe, to this nation. As there are none of those tasteless modern monuments which deform English churches, and the grave is marked only by a mound of earth, or at most a flat stone, the touching picture of human frailty is enhanced, not impaired, by this custom. The impression is, however, sometimes heightened into horror by the little heed paid by those who dig the graves to the earlier buried, whose skeletons are thrown out without ceremony as soon as there is a want of room. The ruins are consequently filled with heaps of skulls and bones thrown confusedly together, and sometimes placed in pyramids or other forms by children at play. I climbed over a heap of mingled stones and bones, and crawled up into a ruinous chamber of the first story, where I feasted myself on the strange romantic picture. On my left the wall had fallen in, and opened to the eye the beautiful landscape which surrounds the lake, with its bright-green foreground, the mountains in the distance, and on one side the house and the high trees in the park of the **Macnamaras**, who reside here. Before me was a window in good preservation, surrounded with carvings like ‘point d'Alençon;’ above it hung large bunches of deep purple blackberries pendant from their luxuriant branches, which crept in one continuous mass along the open wall. On the right, where the wall of the chamber remained perfect, was a low niche, which no doubt formerly contained a saint, but was now occupied by a skull; the empty eye-sockets were directed exactly towards the beautiful landscape spread before it, as if its brilliancy and freshness had power to gladden even death itself. Following the same direction, I discovered a grated window just above the ground, which I had till then overlooked: it gave light to a spacious cellar, in which I descried a vast heap of bones, all arranged in the way I have mentioned, in various forms. The sunny landscape above, the dark charnel-house below, 



---

p.357



 
in which childhood sported with death,—it was a glance at once into life and the grave,—the joys of the one, and the unsympathizing calm of the other; while the rays of the setting sun threw a cheering glow over the living and dead, like messengers from a fairer world.


Our return in a dark night, with incessant rain, was fatiguing and unpleasant; we broke several springs of our carriage, and had all sorts of calamities to endure. We arrived at B—— after midnight, and to my real dismay found the good old Captain and the whole family still up, and waiting supper for us. The prodigal attentions and the infinite kindness of these excellent people daily put me to shame, and I continually admire to see that their cordial hospitality is not deformed by the slightest trace of ostentation.


That my letter may not be too large, and cost too much postage, (for I have to pay some pounds sterling to the English post-office for my voluminous packets,) I close it before I leave B——m. You will know me safe and well up to this point, and in the care of people whose hearts are like your own, however inferior to you they may be in mind and cultivation.—


Heaven bless and preserve you. Your most faithful 

 L.
### B——m Sept 14th, 1828

Beloved Friend,


Your sermon is excellent; your reasons are unanswerable;—but I happen to believe the contrary; and belief is, as you know, a thing which not only removes mountains, but often builds up such as it is impossible too see over. No conversion can consequently be effectual, be the subject what it may, till the opposite belief has already begun to totter. Till that point is reached, though you speak with the wisdom of Plato, and act with the purity of Jesus, every man will retain his belief, on which reason and good sense have ordinarily little influence. He who wishes to produce any sudden change in the minds of men before they are already disposed to it, will either be confined as a madman, or stoned and crucified as a martyr. History teaches us this in every page. What is applicable universally, is also applicable individually,—and now, ‘parlez moi raison si vous l'osez.’—But, seriously speaking, a man who has the misfortune to be born with a too independent spirit, and who cares little for common opinion, merely because it is common, should remain unchanged all his life. The consequences of such a turn of mind, and the hostilities it excites, becomes painful, and at length dangerous, only when he grows weak and ceases to be self-sustained; when instead of despising, as before, the opinions of others, he begins to fear them. The multitude are quick to perceive the change, and instantly begin a steady and vigorous pursuit of the game which flees before them, and which, so long as it stood at bay and looked them boldly in the face, they dared not openly attack. For getting on in the world, there is no better maxim than this, ‘Bouche riante, et front d'airain, et vous passez par tout.’ We Germans are almost always too earnest as well as too timid, and are capable of only momentary struggles against these defects, which, like all such attempts, generally overshoot the mark. This makes us so fond of retirement and of converse with our own fancy,—our best and faithfullest companion;—we are sovereign lords of the regions of air, as **Madame de Stael**


---

p.358



 
says. The world, as it is, does not please us, and we are just as little fitted to please the world. Retirement, and with it freedom, are therefore what we love best.


We have had a strange accomplishment of a prophecy.—Miss Kitty, one of my host's daughters, and a very nice girl, had her fortune told yesterday by gipseys. I was by, and heard the woman say to her, among many common-place predictions, ‘Be upon your guard; for a shot will be fired in at your window, and your stay in B—— will not be long after that.’ We thought the prediction rather serious, and communicated it to the family on our return, but were only laughed at. The next morning early, we were all alarmed by the firing of two shots; Miss Kitty rushed down stairs half dressed, and nearly fainting from terror; and every one in the house ran to see what was the matter. We found that two of Kitty's younger brothers, who had been on a visit to Mrs. M——, had returned quite unexpectedly to fetch their sister, had played the silly trick of firing their fowling-pieces up at her window, and had done it so awkwardly that they had broken it. They were soundly rated, and then drove off with Miss Kitty; so that everything happened precisely as the old woman, Heaven only knows how! had seen in the lines of her hand.


### September 15th


I was a little hypochondriacal and dull yesterday, but to-day I am better in health, and consequently full of philanthropical sentiments,—virtuous, ‘faute d'occasion de pêcher,’ and merry, because I can laugh at myself ‘faute de trouver quelque chose de plus ridicule.’


Meanwhile the scene here has altered. The fair African is arrived, and we immediately set out, ten in number, on a ride; in the course of which the old Captain showed us his bog cultivation and his draining with all the ardour of a young man. He was as much enchanted by a field of potatoes as I by my fair companion. Pointing to a good crop, he cried out with enthusiasm, ‘Is not that a magnificent sight?’ it certainly never came into his head that we could be thinking of other things, and that we assented only out of civility. I found some peasants for my plan of colonization; they were all eager to go, but unfortunately had not a penny in the world in furtherance of such a scheme. One runs no risk in promising them that they will find everything better than they have here, where a man must subsist from half an acre of land; and if he be ever so willing to seek work abroad, cannot find it. Those of them who are best off live in dwellings which our peasants would think too bad for their cows or horses. I visited one of these cabins and found the walls built of rude blocks of stone, with moss stuffed into the interstices, and a roof covered partly with straw, partly with turf. The floor consisted of the bare earth; there was no ceiling, and the roof admitted the light in many places. Chimneys seem to be esteemed a useless luxury. The smoke ascended from the open hearth, and found its way through the holes, which served as windows. A lower shed on the right was the bed-room of the whole family; a similar one on the left, the habitation of the pig and the cow. The house stood in the middle of a field, without garden, and utterly bare, and this they all called an *excellent* house.


When we got home our pretty visitor's hands were nearly frozen, even at this season. They were perfectly white and insensible, and were rubbed a quarter of an hour before the blood and life returned to them. ‘C'est le sang Africain.’ She is in perfect comfort only



---

p.359



when seated close to a glowing turf fire, which would scorch any body else; then she recovers her child-like freedom and sportiveness, which sometimes carries even me away with it.


### September 17th


To-day Mr L—— came to visit us. How strangely are the good things of this world distributed!


He is a furious Orangeman: it was to be expected that such a character as his would range itself on the side of injustice, and delight in party rage. But on what principles! As this is a specimen of the height to which the spirit of party has reached, and the shamelessness with which it dares to avow itself, I will give you the quintessence of his conversation.


‘I have served my king for nearly thirty years in almost every part of the world, and want rest. Nevertheless, it is my most ardent wish, which I daily pray God to grant, that I may live to see a ‘good sound rebellion’ in **Ireland**. If I were called out to serve again, or if I were to lay down my life the very day it broke out, I should make the sacrifice willingly, could I but be sure that the blood of five millions of Catholics would flow at the same time with my own. Rebellion!—that's the point at which I want to see them, at which I wait for them, and to which they must be led on, that we may make an end of them at once; for there can be no peace in **Ireland** till the whole race is exterminated, and nothing but an open rebellion, and an English army to put it down, can effect this!’—Would it not be right to confine such a wicked madman for life, dear Julia, and give his sweet wife to some one more worthy of her? The youthful and uncorrupted hearts of the sons of my host were roused as much as my own: they manfully combatted these diabolical principles; but this exasperated the maniac Orangeman still more, till at length all were silent. Several had early dropped off from table to escape from such revolting conversation.


### September 18th


Mr L——'s visit fortunately lasted only a few days, and we are once more alone. We took advantage of our recovered freedom to make an excursion of twenty miles to Mount B——, the beautiful residence of a nobleman, and did not get back till late at night. The park at Mount B—— affords a perfect study for the judicious distribution of masses of water, to which it is so difficult to give the character of grandeur and simplicity that ought always to belong to them. It is necessary to study the forms of nature for the details; but the principal thing is never to suffer an expanse of water to be completely overlooked, or seen in its whole extent. It should break on the eye gradually, and if possible lose itself at several points at the same time, in order to give full play to the fancy,—the true art in all landscape gardening. The lord of the demesne, who is rich, possesses a numerous collection of pictures, some of which are excellent. There is a winter landscape of **Ruysdaal**'s, the only one of its kind which I remember to have seen by that master. The character of the cold foggy air, and the crisp frozen snow, are so perfectly given, that I almost shivered before it; I felt at least that the flickering blaze in the fire-place beneath had a double charm. A fine and undoubted Rubens, the Miraculous Draught of Fishes is chiefly remarkable for a strange singularity. St Peter has a scarlet wig, and yet the general expression of the picture is not injured. It 



---

p.360



 
has the effect of a glory, and seems to shed light around. I should think it was a trial of skill, perhaps undertaken by the painter in consequence of some jest, ‘pour prouver la difficulté vaincue.’ A very laborious landscape on wood, by an unknown hand, was formerly in the private collection of Charles I., whose cipher and name, with the crown above, are branded on the back. The gem of the collection appeared to me a picture of Rembrandt's, supposed to be the portrait of an Asiatic Jew; it is, at any rate, the ideal of one. The reality of the eyes and their blighting look is almost terrific; the dark and sinister, yet sublime expression of the whole is increased by the inky blackness of the rest of the picture, out of which the fiery eyes and satanic mouth look as if peeping forth frightfully from the midst of Egyptian night.


After breakfast several hunters and racers were brought out, and we exhibited our feats of horsemanship to the ladies. The hunters of this country are not, perhaps, quite so swift as the best English ones, but they are unequalled at leaping, to which they are trained from their youth. They go up to a wall with the most perfect composure, and mount it with their fore and hind feet like a dog. If there is a ditch on the other side, they leap that also by giving themselves a fresh ‘élan’ on the top of the wall. The less the rider attempts to help a well trained horse the better. If he keeps a steady light rein upon him he may safely leave him to himself.


I don't know whether these details of horsemanship are very interesting to you, but as my letters are at the same time my journal (for how should I find time to keep any other?) you must be so kind as to receive with indulgence whatever has any interest, not only for you, but for myself.


### **Galway**, September 19th, Evening


You know that my determinations are often of a very sudden nature,—my pistol-shots, as you used to call them. I have just discharged one. You may think that I did not quit such cordial friends without great regret, but I had resolved to go, and adhered steadily to my resolution. To avoid the delay of sending for post-horses, I rode with James for the last time on ‘Doctor,’ his admirable hunter, to Tuam, leaving all needful arrangements to my servant. I intended to leave Tuam by the mail, but it was not its day for going, and no species of conveyance to **Galway** was to be had, except the little two-wheeled cart of the man who carries the letter-bags, in which there is room for two passengers. I did not deliberate long, but giving James a last shake by the hand, sprang into this frail vehicle, and ‘clopin-clopant,’ away rattled the old horse with us through the streets. The other passenger was a fine athletic young man, well dressed, with whom I soon got into an interesting conversation on the beauties and wonders of his country, and the character of his countrymen. He was not long without affording me a fresh proof of the hearty kindness and civility of the latter. I was very lightly dressed, and heated with riding, so that I suffered from the cold wind. I offered the driver some money to surrender his cloak to me: on a nearer view, however, this appeared so fearfully dirty and disgusting, that I could not bring myself to put it on. The young man immediately took off a magnificent great-coat of vast dimensions, and almost forced me to take it, protesting that he never caught cold, that he could sleep in the water without taking any harm, and that he had put on the great-coat only because he did not 



---

p.361



 
know what to do with it. This friendly act of his made us more quickly acquainted than we should otherwise have been; and the time passed away, amid all sorts of talk, much more rapidly than I had ventured to hope; for the distance was six German miles, the road very rough, the equipage as bad as possible, the seat uneasy, the country monotonous and dreary. Not a hill, not a tree to be seen; only a network of walls drawn over the whole surface. Every field is enclosed within walls of loose stones without mortar, but so well constructed, that unless violently shaken they stand very firm. Many ruins of castles were visible, but in such a flat, desert plain, without one bush or bough to break it, they produced no romantic effect.


We found the ragged potatoe-eating people everywhere gay and joyous. They always beg, to be sure, but they beg laughing, with wit, humour, and the drollest expressions, without importunity, and without ‘rancune’ if they get nothing. Most striking, amid such singular poverty, is the no less singular honesty of these people; perhaps, however, the one arises out of the other, for luxury makes us covetous, and the poor man can often bear the privation of necessaries more easily than the rich of superfluities.


We saw a number of labourers sitting by the road-side on heaps of stone, which they were breaking. My companion said, ‘Those are conquerors; their whole business is to break in pieces and destroy, and they rise on the ruins they make.’ Meanwhile our driver blew his horn to announce the post, for which, as with us, everything must make way: the tone, however, came forth with such difficulty and sounded so piteously, that we all laughed. A pretty boy, of about twelve, looking like a personification of happiness and joy, though half naked, was sitting on a heap of stones, hammering. He shouted with mischievous glee, and called out to the angry driver, ‘Oh ho, friend! your trumpet has caught cold; it is as hoarse as my old grandmother: cure it directly with a glass of potheen, or it will die of a consumption before you reach **Galway**!’ A loud laugh from all the labourers followed as chorus. ‘There,’ said my companion, ‘there you see our people,—starvation and laughter,—that is their lot. Would you believe that, from the number of labourers and the scarcity of labour, not one of these men earns enough to buy sufficient food; and yet every one of them will spare something to his priest: and if you go into his cabin, will give you half of his last potatoe and a joke into the bargain.’


We now approached the **Galway** mountains, over which the sun was setting magnificently. This is a spectacle which I can never behold unmoved; it always enchants me, and leaves a feeling of calm and security, arising from the certainty that this language, which God himself speaks to us, cannot lie, though human revelations be but piece-meal, differently understood by every different interpreter, and often abused to the purposes of cunning and selfishness.


We alighted at the same inn at which I had been during the races; and to make some return for my young friend's civility, I invited him to sup with me. It was late when we separated,—probably forever; but such acquaintanceships I like; they leave no time for dissembling: ignorant of each other's social relations, each values in the other only *the man.* Whatever each obtains from the other of kind feeling or good opinion, he owes to himself alone.




---

p.362


### September 20th. Morning


I had hoped my carriage would have arrived during the night, but it is not yet come; and I therefore employed my leisure in taking a more perfect survey of this ancient city. I was greatly assisted by some fragments of an old Chronicle, which I accidentally picked up in a grocer's shop, where I made some inquiries. In an obscure corner of the town stands a house of extreme antiquity, over the door of which are still to be seen a skull and cross-bones, remarkably well sculptured, in black marble. This house is called ‘The Cross-bones,’ and its tragical history is as follows.


In the fifteenth century, **James Lynch**, a man of old family and great wealth, was chosen mayor of **Galway** for life;—an office which was then nearly equal to that of a sovereign in power and influence. He was reverenced for his inflexible rectitude, and loved for his condescension and mildness. But yet more beloved,—the idol of the citizens and their fair wives,—was his son, according to the Chronicle, one of the most distinguished young men of his time. To perfect manly beauty and the most noble air, he united that cheerful temper, that considerate familiarity, which subdues while it seems to flatter,—that attaching grace of manner, which conquers all hearts without an effort, by its mere natural charm. On the other hand, his oft-proved patriotism, his high-hearted generosity, his romantic courage, and complete mastery in all warlike exercises, forming part of an education singular in his age and country, secured to him the permanency of an esteem which his first aspect involuntarily bespoke.


So much light was not without shadow. Deep and burning passions, a haughty temper, jealousy of all rival merit, rendered all his fine qualities only so many sources of danger to himself and others. Often had his stern father, although proud of such a son, cause for bitter reproof, and for yet more anxious solicitude about the future. But even he could not resist the sweetness of the youth,—as quick to repent as to err, and who never for a moment failed in love and reverence to himself. After his first displeasure was past, the defects of his son appeared to him as they did to all others, only spots on the sun. He was soon still further tranquillized by the vehement and tender attachment which the young man appeared to have conceived for Anna Blake, the daughter of his best friend, and a girl possessing every lovely and attaching quality. He looked forward to their union as the fulfilment of all his wishes. But fate had willed it otherwise.


While young Lynch found more difficulty in conquering the heart of the present object of his love than he had ever experienced before, his father was called by business to **Cadiz**;—for the great men of **Galway**, like the other inhabitants of considerable sea-ports in the middle ages, held trade on a large scale to be an employment nowise unworthy even *of* men of noble birth. **Galway** was at that time so powerful and so widely known, that, as the Chronicle relates, an Arab merchant, who had long traded to these coasts from the East, once inquired ‘in what part of **Galway** **Ireland** lay?’


After **James Lynch** had delegated his authority to trusty hands, and prepared every thing for a distant journey, with an overflowing heart he blessed his son, wished him the best issue to his suit, and sailed for his destination. Wherever he went, success crowned his undertakings. For this he was much indebted to the friendly services of a Spanish merchant named Gomez, towards whom his noble heart conceived the liveliest gratitude.




---

p.363


It happened that Gomez also had an only son, who, like Edward Lynch, was the idol of his family, and the darling of his native city, though in character, as well as in external appearance, entirely different from him. Both were handsome; but Edward's was the beauty of the haughty and breathing Apollo; Gonsalvo's of the serene and mild St. John. The one appeared like a rock crowned with flowers; the other like a fragrant rose-covered knoll, threatened by the storm. The Pagan virtues adorned the one; Christian gentleness and humility the other. Gonsalvo's graceful person exhibited more softness than energy; his languid dark blue eyes, more tenderness and love than boldness and pride; a soft melancholy overshadowed his countenance, and an air of voluptuous suffering quivered about his smiling lips, around which a timid smile rarely played, like a gentle wave gliding over pearls and coral. His mind corresponded to such a person: loving and endearing, of a grave and melancholy serenity, of more internal than external activity, he preferred solitude to the bustle and tumult of society, but attached himself with the strongest affection to those who treated him with kindness and friendship. His inmost heart was thus warmed by a fire, which, like that of a volcano buried too deep to break out at the surface, is only seen in the increased fertility of the soil above, which it clothes in the softest green, and decks with the brightest flowers. Thus captivating, and easily captivated, was it a wonder if he stole the palm even out of the hand of Edward Lynch? But Edward's father had no such anticipations. Full of gratitude to his friend, and of affection for his engaging son, he determined to propose to the old Gomez a marriage between Gonsalvo and his daughter. The offer was too flattering to be refused. The fathers were soon agreed; and it was decided that Gonsalvo should accompany his future father-in-law to the coast of **Ireland**, and if the inclinations of the young people favoured the project, their union should take place at the same time with Edward's, after which they should immediately return to **Spain**. Gonsalvo, who was just nineteen, accompanied the revered friend of his father with joy. His young romantic spirit enjoyed in silent and delighted anticipation the varying scenes of strange lands which he was about to see; the wonders of the deep which he would contemplate; the new sort of existence of unknown people with whom he was to be connected; and his warm heart already attached itself to the girl, of whose charms her father gave him, perhaps, a too partial description.


Every moment of the long voyage, which at that time abounded with dangers and required a much longer period than now, increased the intimacy and mutual attachment of the travellers: and when at length they descried the port of **Galway**, the old Lynch congratulated himself not only on the second son which God had sent him, but on the beneficial influence which the unvarying gentleness of the youth would have on Edward's darker and more vehement character.


This hope appeared likely to be completely fulfilled. Edward, who found all in Gomez that was wanting in himself, felt his own nature as it were completed by his society; and as he had already learned from his father that he was to regard him as a brother, their friendship soon ripened into the warmest and most sincere affection.


But not many months had passed before some uneasy feelings arose in Edward's mind to trouble this harmony. Gonsalvo had become the husband of his sister, but had deferred his return to **Spain**


---

p.364



for an indefinite time. He was become the object of general admiration, attention, and love. Edward felt that he was less happy than formerly. For the first time in his life neglected, he could not conceal from himself that he had found a successful rival of his former universal and uncontested popularity. But what shook him most fearfully, what wounded his heart no less than his pride, what prepared for him intolerable and restless torments, was the perception, which every day confirmed, that Anna, whom he looked upon as *his,*—though she still refused to confess her love,—that *his* Anna had ever since the arrival of the handsome stranger grown colder and colder towards himself. Nay, he even imagined that in unguarded moments he had seen her speaking eyes rest, as if weighed down with heavy thoughts, on the soft and beautiful features of Gomez, and a faint blush then pass over her pale cheek; but if his eye met hers, this soft bloom suddenly become the burning glow of fever. Yes, he could not doubt it; her whole deportment was altered: capricious, humoursome, restless, sometimes sunk in deep melancholy, then suddenly breaking into fits of violent mirth, she seemed to retain only the outward form of the sensible, clear-minded, serene, and equal tempered girl she had always appeared. Everything betrayed to the quick eye of jealousy that she was the prey of some deep-seated passion,—and for whom?—for whom could it be but for Gomez! for him, at whose every action it was evident the inmost cords of her heart gave out their altered tone. It has been wisely said, that love is more nearly akin to hate than to liking. What passed in Edward's bosom was a proof of this. Henceforth it seemed his sole enjoyment to give pain to the woman he passionately loved: and now, in the bitterness of his heart, held guilty of all his sufferings. Wherever occasion presented itself, he sought to humble and to embarrass her, to sting her by disdainful pride, or to overwhelm her with cutting reproaches; till, conscious of her secret crime, shame and anguish overpowered the wretched girl, and she burst into torrents of tears, which alone had power to allay the scorching fever of his heart. But no kindly reconciliation followed these scenes, and, as with lovers, resolved the dissonance into blessed harmony. The exasperation of each was only heightened to desperation: and when he at length saw enkindled in Gomez,—so little capable of concealment,—the same fire which burnt in the eyes of Anna; when he thought he saw his sister neglected and himself betrayed by a serpent whom he had cherished in his bosom,—he stood at that point of human infirmity, of which the All-seeing alone can decide whether it be madness, or the condition of a still accountable creature.


On the same night in which suspicion had driven Edward from his couch, a restless wanderer, it appears that the guilty lovers had for the first time met in secret. According to the subsequent confession of Edward, he had concealed himself behind a pillar, and had seen Gomez, wrapped in his mantle, glide with hurried steps out of a well-known side-door in the house of Anna's father, which led immediately to her apartments.—At the horrible certainty which now glared upon him, the fury of hell took possession of his soul: his eyes started from their sockets, the blood rushed and throbbed as if it would burst his veins, and as a man dying of thirst pants for a draught of cooling water, so did his whole being pant for the blood of his rival. Like an infuriate tiger he darted upon the unhappy youth, who recognized him, and fled. Edward instantly



---

p.365



overtook him, seized him, and burying his dagger a hundred times, with strokes like lightning-flashes, in the quivering body, gashed with satanic rage the beautiful features which had robbed him of his beloved, and of peace. It was not till the moon broke forth from behind a dark cloud, and suddenly lighted the ghastly spectacle before him,—the disfigured mass, which retained scarcely a feature of his once beloved friend, the streams of blood which bathed the body and all the earth around it,—that he waked with horror as from some infernal dream. But the deed was done, and judgment was at hand.


Led by the instinct of self-preservation, he fled, like Cain, into the nearest wood. How long he wandered there he could not recollect. Fear, love, repentance, despair, and at last madness, pursued him like frightful companions, and at length robbed him of consciousness,—for a time annihilating the terrors of the past in forgetfulness; for kind nature puts an end to intolerable sufferings of mind, as of body, by insensibility or death.


Meanwhile the murder was soon known in the city; and the fearful end of the gentle youth, who had confided himself, a foreigner, to their hospitality, was learned by all with sorrow and indignation. A dagger, steeped in blood, had been found lying by the velvet cap of the Spaniard, and not far from it a hat, ornamented with plumes and a clasp of gems, showed the recent traces of a man who seemed to have sought safety in the direction of the wood. The hat was immediately recognized as Edward's; and as he was nowhere to be found, fears were soon entertained that he had been murdered with his friend. The terrified father mounted his horse, and, accompanied by a crowd of people calling for vengeance, swore solemnly that nothing should save the murderer, were he even compelled to execute him with his own hands.


We may imagine the shouts of joy, and the feelings of the father, when at break of day Edward Lynch was found sunk under a tree, living, and although covered with blood, yet apparently without any dangerous wound. We may imagine the shudder that ran through the crowd,—but the feelings of the father we *cannot* imagine,—when, restored to sense, he embraced his father's knees, declared himself the murderer of Gonsalvo, and earnestly implored instant punishment.


He was brought home bound, tried before a full assembly of the magistrates, and condemned to death by his own father. But the people would not lose their darling. Like the waves of the tempest-troubled sea, they filled the market-place and the streets, and forgetting the crime of the son in the relentless justice of the father, demanded with threatening cries the opening of the prison and the pardon of the criminal. During the night, though the guards were doubled, it was with great difficulty that the incensed mob were withheld from breaking in. Towards morning, it was announced to the mayor that all resistance would soon be vain, for that a part of the soldiers had gone over to the people;—only the foreign guard held out, and all demanded with furious cries the instant liberation of the criminal.


At this, the inflexible magistrate took a resolution, which many will call inhuman, but whose awful self-conquest certainly belongs to the rarest examples of stoical firmness.—Accompanied by a priest, he proceeded through a secret passage to the dungeon of his son; and when, with newly-awakened desire of life, excited by the sympathy of his fellow-citizens, Edward sunk at his feet, and asked



---

p.366



eagerly if he brought him mercy and pardon? The old man replied with unfaultering voice, ‘No, my son, in this world there is no
mercy for you: your life is irrevocably forfeited to the law, and at sunrise you must die. One-and-twenty years have I prayed for your earthly happiness,—but that is past,—turn your thoughts now to eternity; and if there be yet hope there, let us now kneel down together and implore the Almighty to grant you mercy hereafter;—but then I hope my son, though he could not live worthy of his father, will at least know how to die worthy of him.’ With these words he rekindled the noble pride of the once dauntless youth, and after a short prayer, he surrendered himself with heroic resignation to his father's pitiless will.


As the people, and the greater part of the armed men mingled in their ranks, now prepared, amidst more wild and furious menaces, to storm the prison, James Lynch appeared at a lofty window; his son stood at his side with the halter round his neck. ‘I have sworn,’ exclaimed the inflexible magistrate, ‘that Gonsalvo's murderer should die, even though I must perform the office of the executioner myself. Providence has taken me at my word; and you, madmen, learn from the most wretched of fathers that nothing must stop the course of justice, and that even the ties of nature must break before it.’


While he spoke these words he had made fast the rope to an iron beam projecting from the wall, and now suddenly pushing his son out of the window, he completed his dreadful work. Nor did he leave the spot till the last convulsive struggles gave certainty of the death of his unhappy victim.


As if struck by a thunder-clap, the tumultuous mob had beheld the horrible spectacle in death-like silence, and every man glided as if stunned to his own house. From that moment the mayor of **Galway** resigned all his occupations and dignities, and was never beheld by any eye but those of his own family. He never left his house till he was carried from it to his grave. Anna Blake died in a convent. Both families in course of time disappeared from the earth; but the skull and cross-bones still mark the scene of this fearful tragedy.


### **Limerick**, Sept. 21st


At ten o'clock my carriage arrived, and I immediately quitted **Galway**. As long as the country remained monotonous, I beguiled the time by reading. At **Gort** it becomes more interesting. Not far from it flows a river, which, like that at **Cong**, looses itself several times in the earth. One of the deepest basins which it forms is called ‘The Punch-bowl.’ To fill such a bowl would require a larger tun than that at Heidelberg.


You now begin to approach the **Clare mountains**: and Nature decks herself in more picturesque attire. A park belonging to **Lord Gort** broke upon me like a magnificent picture: it is bounded by a broad lake, in which are thirteen beautiful wooded islands; these, with the mountains in the back-ground, and the expanse of water, which the eye never completely embraces, in front, produced a grand and striking effect. One of the most miserable post-horses seemed to participate so intensely in my delight, that it was impossible to make him stir. After many vain attempts to induce him to change his position, during which the postilion repeatedly protested that it was only this one spot to which he was so attached, but that if we could once get him away from it, he would go like the devil himself, we were obliged to unharness him;—he had begun to kick and to



---

p.367



break our crazy equipage. In comparison with the Irish post establishment, that of **Saxony**, erst so celebrated, might fairly be called excellent. Bleeding skeletons, galled all over, starved and superannuated, are fastened by rotten harness to your carriage, and if you ask your postilion (whose dress consists of a few rags,) if he thinks that such cattle can go a mile, much more a stage of twelve or fifteen, he answers very seriously, ‘Sure there's no better equipage in **England**; I shall take your honour there in less than nothing.’ Scarcely, however, have you gone twenty steps, when something breaks, one horse is restive, and the other falls down exhausted: this does not put him the least out of countenance, he has always some admirable excuse ready, and at last, if nothing else will do, he declares himself bewitched.


This was the course of things to-day. We must probably have passed the night in the park of Gort, had not assistance and horses been most hospitably despatched to us from the house. Notwithstanding this, our stay was so long that it was ten before I reached **Limerick**. My letter is so thick that I must send it away before its corpulence becomes ‘impayable.’ You will not hear of me again in less than a fortnight, as I am determined to plunge into those wild regions, which foreign foot has seldom trod.


Pray for a prosperous journey for me; and above all, love me with the same tenderness as ever. Your faithful

 L——
### **Limerick**, Sept. 22nd, 1828

Dearest Friend,


**Limerick** is the third city in **Ireland**, and of the kind of cities I like, old and venerable, adorned with Gothic churches and moss-covered ruins; with dark narrow streets, and curious houses of various dates; a broad river flowing through its whole length, and crossed by several antique bridges; lastly, a busy market-place, and cheerful environs. Such a city has for me a charm like that of a wood, whose dark branches, now low, now high, afford sylvan streets of various forms, and frequently over-arch the way like a Gothic roof. Modern regular cities are like a trimly cut French garden: they do not suit my romantic taste.


I was not quite well, and returned after a little walk in the town to my inn. I found a sexton of one of the Catholic churches waiting for me; he told me that they had rung the bells as soon as they knew of my arrival, and hoped I would give them ten shillings as a gratuity. ‘Je l'envoyai promener.’ In a few minutes a Protestant functionary of the same sort was announced. I asked him what he wanted. ‘Only to warn your royal highness against the impositions of the Catholics, who annoy strangers in the most shameless manner, and to beg that your royal highness will not give them anything:—at the same time I take the liberty to ask a small contribution to the Protestant poor-house.’ (You must observe that the people of this country are extremely lavish of titles to anybody who travels with four horses.) ‘Go to the d——l, Protestants and Catholics,’ said I in a rage, and flung the door in his face.


But this was not all; I was soon waited upon by a deputation of the catholics, consisting of the French Consul (an Irishman,) a relation and namesake of **O'Connell**, and some others, who harangued me, and begged to present me with the Order of the Liberator. I



---

p.368



had the greatest possible difficulty in excusing myself from this honour, and in declining an invitation to dine with their club. We compromised the matter by my accepting the offer of two of them to accompany me all over the town as ciceroni.


I resigned myself very patiently, and was first conducted to the cathedral, a building of great antiquity, more in the style of a fortress than of a church; the architecture solid and rude, but imposing by its massiveness. In the interior I admired a carved chair of the most exquisite workmanship; it is five hundred years old, and made of bog-oak, which time has rendered black as ebony. Its rich ornaments consisted of beautiful arabesques and most curious masks, which were different on every side. The grave of Thomond, King of Ulster and **Limerick**, though mutilated and defaced by modern additions, is a very interesting monument. Descendants of this royal line are still in existence. The head of the family bears the title of Marquis of Thomond, a name which you will remember to have seen in my letters from **London**, where its possessor was distinguished for the excellence of his dinners. **Ireland** has many families of great antiquity, who pique themselves on never having contracted a ‘mésalliance,’ a practice so common among the English and French nobility, that pure unmixed blood (stiftsfähiges Blut, as we call it in **Germany**) is no longer to be found in either of those kingdoms. The French nobles called these marriages for money ‘mettre du fumier sur ses terres,’ a joke not very flattering to the bride.—And many an English lord owes all the present splendour of his family to such ‘fumier.’


We quitted the church, and were proceeding to visit the rock near the Shannon, upon which the English signed the treaty after the battle of the Boyne; a treaty which they have not been remarkably scrupulous in observing. I remarked that we were followed by an immense crowd of people, which increased like an avalanche, and testified equal respect and enthusiasm. All on a sudden they shouted ‘Long life to **Napoleon** and Marshal ——.’ ‘Good God,’ said I, ‘for whom do the people take me? As a perfectly unpretending stranger I cannot in the least degree understand why they seem disposed to do me so much honour.’ ‘Was not your father the Prince of ——?’ said **O'Connell**. ‘Oh no,’ replied I; ‘my father was indeed a nobleman of rather an older date, but very far from being so celebrated.’ ‘You must forgive us then,’ said **O'Connell** incredulously; ‘for to tell you the truth, you are believed to be a natural son of **Napoleon**, whose partiality to your supposed mother was well known.’ ‘You joke,’ said I laughing: ‘I am at least ten years too old to be the son of the great emperor and the beautiful princess.’ He shook his head, however, and I reached my inn amid reiterated shouts. Here I shut myself up, and shall not quit my retreat to-day. The people, however, patiently posted themselves under my windows, and did not disperse till it was nearly dark.


### **Tralee**, Sept. 23rd


This morning I was again received with cries of ‘Long life to **Napoleon** and your honour!’ And while my servant, who was seated in my carriage, and passed for **Napoleon**'s son, drove off in the midst of cheers and acclamations, I slipped out at a back-door, with 



---

p.369



 
a lad who carried my travelling bag, and took my place in the stage, which was to convey me to the **lake of Killarney**. My people had orders to wait for me in **Cashel**, where I shall probably rejoin them in a fortnight.


With my present simple exterior no human being thought of assailing me with homage; and I could not help philosophizing on this public farce, and thinking how often the desire of glory and renown leads only to disguise and false assumption. Certainly of all the dreams of life this is the most shadowy! Love sometimes satisfies, knowledge tranquilizes, art gladdens and amuses; but ambition, ambition gives only the tormenting passion of a hunger which nothing can allay,—a chase after a phantom which is ever unattainable.


In a quarter of an hour I was comfortably established in the stage-coach. The passengers inside consisted of three women; one fat and jovial, another extremely lean, and a third pretty and well proportioned. There was also a man who had the air of a pedagogue, with a long face, and still longer nose. I sat entrenched between the two slender ladies, and conversed with the corpulent one, who was very talkative. On my letting down a window she told us that she had lately been nearly *sea-sick* in this very coach, because an ailing lady who sat opposite to her would not allow a window to be opened on any account. That *she,* however, did not give it up; and after a quarter of an hour's persuasion had succeeded in prevailing on the lady to admit of one inch of air; a quarter of an hour after another inch, and so on, till she manoeuvred the whole window open. ‘Excellent,’ said I; ‘that is exactly the way in which women manage to get all they wish; first *one* inch, and then—as much as they want. How differently do men act under similar circumstances,’ continued I. ‘An English writer, in his directions to travellers, says, that if anybody in the mail should insist on keeping all the windows closed, you should not enter into any ‘pour parler’ with him, but immediately thrust your elbow through the window as if by accident, beg his pardon, and quietly enjoy the cool air.’ The ruins of Adair now attracted our attention, and interrupted the conversation. Further on the Shannon appeared in all its grandeur. In some parts it is like an American river, nine miles broad, and its shores finely wooded. At Lisdowel, a little place where we dined, hundreds of beggars assembled as usual about the coach. One novelty struck me; they had little wooden cups fixed at the end of long sticks, which they reached in at the window, and thus more conveniently secured the desired ‘pence.’ One beggar had built himself a sort of sentry-box of loose stones in the road, in which he seemed to remain in a state of perpetual bivouac. I must conclude; for the mail drives off again in a few hours, and I want rest. More to-morrow.


### **Killarney**, Sept. 24th


In the course of to-day I saw twelve rainbows, a bad omen for the steadiness of the weather; but I receive it as a good one for me. It promises me a many-coloured journey. The company had dropped off, one by one, like ripe fruit, and I found myself alone with an Irish gentleman, a *manufacturer* from the north, when I entered the pretty cheerful town of **Killarney**, where the incessant resort of English tourists has almost introduced into the inns English elegance and English prices. We immediately inquired for boats, and for the best way of seeing the lake, but were told that it was *impossible* to go on in such a storm: no boat could ‘live on the lake,’ as the fisherman expressed it. An English dandy, who had joined us during breakfast,



---

p.370



ridiculed these assurances; and as I, you know, am also rather incredulous about *impossibilities,* we outvoted the manufacturer, who showed very little ardour for the undertaking, and embarked, ‘malgré vent et marée,’ near **Ross Castle**, an old ruin not far from **Killarney**.


We had a capital boat, an old characteristic-looking grey-headed steersman, and four sturdy rowers. The heaven was as if torn open; in some places blue, in others various shades of gray; but for the most part raven-black. Clouds of all forms rolled in wild disorder, now and then tinged by a rainbow, or lighted by a pale sun-beam. The high mountains scarcely appeared through their gloomy veil, and on the lake all was like night. The Black waves heaved in busy and ceaseless tumult; here and there one bore a crest of snow-white form. As the motion was nearly as great as at sea, I was slightly sea-sick. The manufacturer was pale from fear; the young Englishman, proud of his amphibious nature, laughed at us both. Meanwhile the storm piped so loud that we could hardly hear each other speak; and when I asked the old steersman where we should land first, he said, ‘At the Abbey, if we can land anywhere.’ This did not sound encouraging. Our boat, which was the only one on the lake, for even the fishermen would not venture out, danced so fearfully up and down without making the smallest way, in spite of all the efforts of the rowers, that the manufacturer began to think of wife, children and manufactory, and peremptorily insisted on returning, as he had no intention of sacrificing his life to a party of pleasure. The dandy on the other hand was ready to burst with laughter: he protested that he was a member of the Yacht Club, and had seen very different sort of danger from this; and promised the rowers, who would rather have been at home, money without end if they would but hold out. For my own part, I followed **General Yermoloff**'s maxim, ‘neither too rash nor too timid,’ took no part in the contest, wrapped myself in my cloak, and awaited the issue in peace. It seems I had all the beauty of the scene to myself; one of my companions being prevented from seeing it by fear, the other by self-complacency. For some time we struggled with the waves, on which we floated like seabirds in storm and darkness; till at last such a violent wind came upon us from a gorge in the mountains opposite to which we lay, that it grew rather too serious even for the ‘member of the Yacht Club,’ and he acceded to the request of the steersman, to row back with the wind, and land on an island till the storm abated a little, which was generally the case about noon.


This happened as he predicted: and after encamping for some hours in **Innisfallen**, a lovely little islet with beautiful groups of trees and ruins, we were able to continue our voyage. All the islands of this little lake, even to the smallest, called **the Mouse**, which is only a few yards long, are thickly clothed with arbutus, and other evergreens. They grow wild; and both in summer and in winter enliven the scene with the bright colours of their flowers and fruit. The forms of many of these islets are as curious as their names. They are generally called after O'Donaghue. Here is O'Donaghue's ‘White Horse,’ on whose rocky hoofs the surf breaks; there, his ‘Library;’ further on, his ‘Pigeon-house,’ or his ‘Flower-garden;’ and so on. But you do not know how the **lake of Killarney** arose. Listen then.


O'Donaghue was the powerful chieftain of a clan inhabiting a great and opulent city, which stood where the lake now rolls its waters. It had everything in abundance except water; and the legend says, that the only little spring which it possessed was the gift of a mighty sorcerer, 



---

p.371



who called it up at the prayer of a beautiful virgin; adding a solemn warning, that they should never forget to close it every evening with a large silver cover which he left for that purpose. The strange forms and ornaments seemed to confirm this wonderful command; and never was the old custom neglected.


But O'Donaghue, a mighty and dauntless warrior (perhaps too, like Talbot, an incredulous one,) only made merry at this story, as he called it; and one day, being heated with more wine than usual, he commanded, to the terror of all present, the silver cover to be carried into his house, where, as he jestingly said, it would make him an excellent bath. All remonstrances were vain: O'Donaghue was accustomed to make himself obeyed: and as his terrified vassals at length dragged in their ponderous burthen, amid groans and lamentations, he exclaimed laughing ‘Never fear, the cool night air will do the water good, and in the morning you will all find it fresher than ever.’ But those who stood nearest to the silver cover turned away shuddering, for it seemed to them as if the strange intricate characters upon it moved, and wreathed like a knot of twisted snakes, and an awful sound appeared to come forth mournfully from it. Fearful and anxious, they retired to rest: one alone fled to the adjoining mountains. And now when morning broke, and this man looked down into the valley, he thought he was in a dream;—city and land had disappeared; the rich meadows were no more to be seen, and the little spring bursting forth from the clefts of the earth has swelled into a measureless lake. What O'Donaghue prophesied was true; the water had become cooler for them all, and the new vessel had prepared for him his last bath.


In very clear bright weather, as the fishermen assured us, some have seen at the lowest bottom of the lake, palaces and towers glimmering as through glass: but many have beheld, at the approach of a storm, O'Donaghue's giant figure riding over the waves on a snorting white horse, or gliding along the waters with the quickness of lightning in his unearthly bark.


One of our boat's crew,—a man of about fifty, with long black hair, which the wind blew wildly about his temples, of an earnest and quiet but imaginative look,—was stealthily pointed out to me by one of his companions, while they whispered in my ear that ‘he had met him.’


You will believe that I quickly entered into conversation with this boatman, and sought to gain his confidence, knowing that these people, whenever they anticipate unbelief and jesting, observe an obstinate silence. At first he was reserved; but at length he became warmed, and swore by **St. Patrick** and the Virgin that what he was going to tell me was the naked truth. He said he had met O'Donaghue at twilight, just before the raging of one of the most terrific storms he had ever witnessed. He had staid out late fishing; it had rained torrents the whole day; it was piercingly cold, and without his whiskey-bottle he could not have held out any longer. Not a living soul had been visible on the lake for a long time,—when all at once a boat, as if fallen from the clouds, sailed towards him; the oars plied like lightning, and yet no rowers were visible: but at the stern sat a man of gigantic stature: his dress was scarlet and gold, and on his head he wore a three-cocked hat with broad gold lace. The spirit-boat passed him: Paddy fixed his eyes intently upon it: but when the tall figure was over against him, and two large black eyes glared forth out of the mantle, and scorched him like living coals, the whiskey fell out of his hand, and he did not come to himself till the



---

p.372



rough caresses of his other half waked him. She was in a great rage, and called him a drunken fellow:—She might think the whiskey had brought him to that, but he knew better.


Is it not curious that the costume here described exactly corresponds with that of our German Devil of the last century, who is now come into such great favour again? And yet Paddy had most certainly never heard of the Freischütz. It seems almost as if Hell had its ‘Journal des Modes’. I was extremely amused at the old man's penitence and distress after he had finished his story. He loudly reproached himself for it, crossed himself, and incessantly repeated, ‘O'Donaghue, though terrible, looked like a real gentleman; for,’ said he, looking round fearfully, a perfect ‘gentleman’ he was, is now, and always will remain. The younger boatmen were not such firm believers, and seemed to have a good mind to joke the ghost-seer a little, but his seriousness and indignation soon overawed them all. One of these young men was a perfect model of a youthful Hercules. With all the overflowing spirits of a body sound to the core, he played incessant tricks, and did the work of three at the same time. We landed at **Mucruss Abbey**, which stands in Mr. Herbert's park, notwithstanding which it is plentifully furnished with skulls and bones. The ruins are of considerable extent, and full of interesting peculiarities. In the court yard is a yew-tree, perhaps the largest in the world; it not only overtops all the building, but its branches darken the whole court, like a tent. In the first story I observed a fire-place, on which two ivy branches, one on each side, formed a most beautiful and regular decoration, while their leaves covered the mantel-piece with a mass of foliage.


Our guide here gave us a curious example of the unbounded power of the Catholic priests over the common people. Two clans, the **Moynihans** and the **O'Donaghues**, had been in a state of perpetual feud for half a century. Wherever they met in any considerable numbers, a shillelah battle was sure to take place, and many lives were usually lost. Since the formation of the **Catholic Association**, it has become the interest of the priests to establish peace and concord in their flocks. Accordingly, after the fight which took place last year, they enjoined as penance that the **Moynihans** should march twelve miles to the north, and the **O'Donaghues** an equal distance to the south, and both pronounce certain prayers at their journey's end; that all the lookers on should make a pilgrimage of six miles in some other direction; and in case of a repetition of the offence, the penance to be doubled. All this was executed with religious exactness; and ever since the war is at an end.


Continuing our progress for about three miles on this side the lake, we landed on a thickly wooded shore, and visited **O'Sullivan's waterfall**, which, swollen by the rain, was doubly magnificent. The luxuriance of the trees and trailing of the plants which overhang it, and the cave opposite, in which you stand protected from the wet to view this foaming cataract, increase the picturesque and wild beauty of the scene. Here are sweet lonely walks, which lead over the mountains to a village imbedded in a wood, and cut off from all the world.


But as the sun was struggling with the clouds, and we were soaked through and through (by the heavens and the lake whose waters had more than once washed over us,) and very weary, we resolved to close our labours for to-day, and to return by **Lady Kenmare**'s pretty villa. As we had still about four miles to go by water, the handsome young fellow, who by-the-bye, in spite of his athletic frame, had a



---

p.373



most remarkable resemblance to **Mademoiselle Sontag**, offered to bet three shillings that he would row us home in half an hour. The old ghost-seer would not undertake such an exertion, but young Sontag declared he would row for him. We accepted the wager, and now flew like an arrow across the lake. Never did I see a finer exhibition of power and persistency, amid constant singing, jokes, and sportive tricks. The rowers won their wager only by half a minute, but received from us more than double their bet, which all promised with great glee to drink in the course of the night. To conclude the whole, they held a conversation, already got up for the purpose, with the echo of the walls of Ross Castle. The answers had always some double meaning; for instance, ‘Shall we have a good bed?’ answer, ‘Bad,’ and so on.


### Sept. 25th


Unfortunately two Englishmen of my acquaintance arrived to-day, and joined us, which destroyed my beloved incognito; for though I am no ‘exalted personage,’ I find as much pleasure in it as if I were. When one is unknown, one always escapes some *gene*, and gains some freedom the more, however inconsiderable one may be. As I could not help myself in this case, I contrived at least to perform half this day's tour by land with my worthy friend the manufacturer, and let the three Englishmen go together by boat. It was the same which we had yesterday, and had then engaged for to-day. My poney had the high sounding name of ‘the Knight of the Gap.’ He was but a recreant knight, however, and would not move without whip and spur. Before we came to the great ravine or gap, from which he takes his name, we had a very beautiful view of the mountains from a hill which rises in the midst of the plain. Mountain, water, and trees, were so happily distributed as to produce the more refreshing harmony:—the long ravine appears all the wilder and more monotonous; in the style of **Wales**, but not so vast. In one part of it a large mass of rock loosened itself some years ago, and lies, split in two, across the road. A man had the project of excavating these pieces of rock as a hermitage, but remained faithful to his strange dwelling only three months. The people, with their usual energy of expression, call it ‘the madman's rock.’ Some way further on we saw an old woman cowering on the road, whose appearance exceeded all that has ever been invented in fairy tales. Never did I see anything more frightful and disgusting: I was told that she was a hundred-and-ten years old; and had survived all her children and grandchildren. Although in an intellectual point of view reduced to a mere animal, all her senses were in tolerable preservation. Her form was neither human nor even animal, but resembled rather an exhumed corpse reanimated. As we rode by, she uttered a piteous whine, and seemed satisfied when we threw her money. She did not reach however to pick it up, but sank back into her former torpor and apathy. All the furrows of her livid face were filled with black dirt, her eyes looked diseased, her lips were of a leaden blue; in short, imagination could conceive nothing so shocking.


We met our boat at **Brandon Castle**, a ruin rendered habitable, with a high tower and neglected pleasure-grounds. There are some pieces of water through which our guides carried us on their backs. The boat appeared ‘à point nommé’; it sailed round a projecting point just as we reached the shore, and had on board the best bugleman in **Killarney**. He blew a sort of Alpine horn with great skill, and called forth many a delightful echo. We passed the arch of a bridge, on which, when the waters are swollen, boats are often wrecked. Our bugleman told us that he had been twice upset here, and the last time nearly drowned. He wished, therefore, to be put on shore, and climb along the rocks past this



---

p.374



formidable place; but the old steersman would not consent, declaring that if the strange gentlemen remained in the boat it became him to stay, and be drowned with them. We all passed quite safely however.


The rock called **The Eagle's Nest**, which is the almost constant abode of those kingly birds, is of a fine and imposing form. Not far from it is Coleman's Leap,—two rocks standing upright in the water at some distance; on which are the marks of feet, three or four feet deep in the rock. Such leaps and footmarks are to be found in almost all mountains. Our boat was fully victualled for a brilliant dinner (a thing which Englishmen seldom forget,) and as we espied a most romantic cottage under high *chestnut* trees, we determined to land here, and eat our repast. It would have been extremely agreeable, had not the dandy spoiled it by his affectation, his want of all feeling for the beautiful, and his ill-natured ‘persiflage’ of the less polished but far more estimable Irishman. He gave him the nickname of Liston (a celebrated actor, who is particularly distinguished in silly absurd characters,) and made the poor devil unconsciously act so burlesque a part, that I was reluctantly constrained to laugh, though the whole thing was quite ‘hors de saison,’ and in the most execrable taste. It is possible, too, that the Irishman only affected stupidity, and was, in fact, the most cunning of the two,—at least he addressed himself to eating and drinking with such unwearied perseverance while the others were occupied with laughing, that very little remained for them. I cannot deny that he received powerful support in this department from me.—A fresh-caught salmon broiled on arbutus-sticks over the fire was an admirable specimen of Irish fare.


We rowed slowly back by moonlight, while the bugleman's horn started echo after echo from her repose. It was an enchanting night; and wandering from thought to thought, I reached a state of mind in which I too could have seen ghosts. The men near me seemed to me only like puppets; Nature alone, and the sweetness and the majesty that surrounded me, seemed real.


Whence comes it, thought I, that a heart so loving is not social? that men are generally of so little worth to you?—Is your soul too small for intercourse with the intellectual world, too nearly allied to plants and animals?—or have you outgrown the forms of this state of existence in some prior one, and feel pent up in your too narrow garments? And when the melancholy tones of the bugle-horn again trembled in soft notes across the waves, and gave to my fancies the sounds of a strange language, like the voice of invisible spirits, I felt like **Göthe**'s fisherman,—as if some irresistible force dragged me softly down into the calm element, to seek O'Donaghue in his coral rocks.


Before we landed, a curious ceremony took place. The boat's crew, with young Sontag at their head,—who always called me ‘his gentleman,’ in virtue of a somewhat larger fee he had received from me,—asked permission to lie-to at a little island, and to christen this after me, which could only be done by moonlight. I was therefore told to stand on a projecting rock: the six boatmen leaning on their oars formed a circle around me, while the old man solemnly pronounced a sort of incantation in a wild measure, which sounded awfully in this romantic scenery and the night. Young Sontag then broke off a large arbutus branch, and giving a twig of it first to me, and then to the gentlemen in the boat, we fixed them in our hats; the rest he divided among his comrades, and then asked me—with respectful earnestness what name the island—with O'Donaghue's permission—was in future to bear? ‘Julia!’ said I with a loud voice:—on which this name was repeated, not very accurately, three times with thundering hurrahs. A third man now took a bottle filled with water, delivered a long address in verse to O'Donaghue, and threw the bottle with all his might against a piece of rock, so that it broke into a thousand pieces. A second bottle filled with whiskey was then drunk to my health, and a threefold cheer



---

p.375



again given to Julia Island. The boatmen, to whom the name was strange, took it for mine, and henceforth called me nothing but Mr. Julia, which I heard with a melancholy satisfaction.


Your domains are thus increased by an island on the romantic **lake of Killarney**: it is only a pity that the next company that lands on the same spot will probably rob you of it; for doubtless such christenings take place as often as godfathers are to be found. The real child, the whiskey-bottle, is always at hand. Nevertheless, I enclose an arbutus leaf from the identical sprig which flourished on my hat, that you may at least retain undisputed possession ofsomething from your island.


### **Glengariff**, Sept. 26th


To write to you to-day is really an effort which deserves reward; for I am excessively tired, and have, like my father **Napoleon**, been obliged to drink coffee incessantly to keep me awake.


I left **Killarney** at nine o'clock in the morning in a car of the most wretched construction, and followed the new road which leads along the upper and lower lake to the **Bay of Kenmare**. This road discloses more beauties than are seen from the lakes themselves, which have the great disadvantage of affording a picturesque view on one side only,—the other shore is quite flat. On the road which lies along the side of the mountain and through a wood, every turn presents you with pictures, which are the more beautiful from being framed. I remark, generally, that views seen from the water lose: they want the principal thing—the foreground.


Near a beautiful cascade, and in the most charming wilderness, though not far from the road, a merchant has built himself a villa, and surrounded it with a garden and park. He must have expended at least five or six thousand pounds,—perhaps much more,—and yet the land is the property of his family only for ninety-nine years; at the expiration of that time it falls, together with all that is upon it, to the lord of the soil, Lord Kenmare, and must be delivered up to him in perfect repair. No German would feel disposed to spend his money in decorative improvements on such terms: but in **England**, where almost the whole soil belongs either to the government, the church, or the powerful aristocracy, and therefore can seldom be purchased in fee; where, on the other hand, industry, fostered by a wise government, in alliance with agriculture, has enriched the middling and trading classes,—such contracts are extremely common, and obviate many of the inconveniences of the distribution of landed property, without diminishing its great utility to the state.


The ascent now became steeper and steeper, and we soon found ourselves in the midst of bare heights; for vegetation here seldom extends above midway up the mountains. It is not as in **Switzerland**, where luxuriant verdure reaches almost to the snowy region. To take **Switzerland** as a standard by which to try **Ireland**, would however be absurd. Both countries afford romantic beauties of a totally different character; both excite admiration and astonishment at the sublime works of Nature, though in **Switzerland** they are on a more colossal scale. The road was so winding, that after half an hour's climbing we found ourselves precisely over the cottage I mentioned, which with its shining gray thatch looked, at that depth, like a little mouse sunning itself in the green grass;—for the sun, after a long struggle, had at length become undisputed lord of the heavens.


Eight miles from **Killarney** we reached the highest point of the road, where stands a solitary inn. You look down upon the broad valley, in whose lap lies the greater part of the three lakes, so that you behold them all with one glance.


From this point the road descends, leading between naked mountains of bold forms to the sea. It was fair-time when I arrived in **Kenmare**, and I could 



---

p.376



hardly penetrate through the bustling crowd with my one-horse vehicle, especially from the number of drunken men who would not—perhaps could not—get out of the way. One of them fell in consequence of an attempt to do so, and knocked his head so violently on the pavement that he was carried away senseless,—a thing of such common occurrence that it attracted no attention. The skulls of Irishmen appear to be universally of a more firm and massive construction than those of other people, probably because they are trained to receive shillelah blows. While I dined, I had another opportunity of observing several affrays. First a knot of people collect, shouting and screaming; this rapidly thickens; and all at once, in the twinkling of an eye, a hundred shillelahs whirl in the air, and the thumps,—which are generally applied to the head,—bang and snap like the distant report of fire-arms, till one party has gained the victory. As I was now at the fountain-head, through the mediation of mine host I bought one of the finest specimens of this weapon, yet warm from the fight. It is as hard as iron, and that it may be sure to do execution, it is also weighted at the end with lead.


The celebrated **O'Connell** is now residing at about thirty miles from hence, in his solitary fortress in the most desert region of **Ireland**. As I have long wished to know him, I sent a messenger from this place, and determined, while waiting for his answer, to make an excursion to **Glengariff Bay**, whither I accordingly set out as soon as I had dined.


Driving is now completely at an end: I can proceed only on a poney or on foot. I set out, a poney carrying my baggage, and I and my guide walking by his side. If either of us were tired, the good little horse was to carry us too. The sun soon set, but the moon shone bright. The road was not uninteresting, though horribly bad, often leading through bog and brook without bridge or stepping-stone. It became indescribably difficult after six or eight miles, where we had to climb a high and nearly perpendicular hill, treading only on loose and pointed stones, from which we slipped back at every step nearly as far as we went forward. The descent on the other side was still worse, especially when a mountain intercepted the moon's light. I was so weary that I could walk no further, and seated myself on the poney. This little creature showed almost human intelligence. Going up-hill he helped himself with his nose, and I think even with his teeth, as a fifth leg; and down-hill,he wriggled with incessant twisting of his body like a spider. When he came to a boggy place, in which there was only here and there a stone, thrown by way of step, he crept as slowly as a sloth, always trying first with his foot whether the stone would bear him and his burthen. The whole scene was most singular. The night was so clear, that I could see around me to a great distance; but nothing met my eye save rocks ranged above rocks, of every shape and kind, standing out gigantic, wild and sharp, against the sky. No living creature, not a tree or bush, was to be seen, only our own shadows trailed after us; not a sound was heard but our own voices, and sometimes the distant rush of a mountain-stream, or more rarely the melancholy horn of a herdsman collecting his cattle wandering amid these pathless wilds. Once only we saw one of these cows, which, like the mountain-sheep of **Wales**, have caught the shyness of wild animals. She was lying in the road, but on our approach sprang bellowing over the rocks, and vanished in the darkness like a black spirit.


About an hour before you reach **Glengariff Bay** the landscape becomes as luxuriant and park-like as it has heretofore been dreary and barren. Here the rocks arise in the strangest forms, out of Hesperian thickets of arbutus, Portugal laurel, and other lovely and fragrant shrubs. Many of these rocks stand like palaces, smooth as marble, without excrescence or inequality; others form pointed pyramids, or long continuous walls. In the valley sparkled solitary lights, and a gentle breeze waved the tops of the high oaks, ashes, and birches, intermingled with beautiful holly, whose scarlet berries were visible even by 



---

p.377



moonlight. The magnificent bay now glittered under the web of moonbeams which lay upon it; and I really thought myself in Paradise when I reached its shore, and alighted at the door of a pretty cheerful inn. Cheerful as was its exterior, mourning was within its gates. The host and hostess, very respectable people, came out to receive me, dressed in deep mourning. On my inquiring the cause, they told me that her sister, the most beautiful girl in **Kerry**, eighteen years of age and the picture of health, died the day before of a brain-fever, or rather, of the igngrance of the village doctor: the poor woman added, weeping, that a week's illness had changed her to forty, so that nobody could recognize the corpse of the once blooming girl, or those sweet features which were so lately the pride of her parents and the admiration of all the young men in the neighbourhood.


She lies close by my bed-room, dear Julia! parted from me only by a few boards.—Four feet from her stands the table at which I am writing to you. Such is the world;—life and death, joy and grief, are never far apart.


### **Kenmare**, Sept. 27th


At six o'clock I was stirring, and at seven in the magnificent park of Colonel W——, brother of Lord B——, whose family possesses all the country around the bays of **Bantry** and **Glengariff**, perhaps the most beautiful part of **Ireland**. The extent of this estate is princely, although in a pecuniary point of view not so considerable, the greater part of the land, consisting of uncultivated rocks and mountains, which pay only the rent of romantic beauties and magnificent views. Mr. W——'s park is certainly one of the most perfect creations of that kind, and owes its existence entirely to his perseverance and good taste. It is true, that he could nowhere have found a spot of earth more grateful for his labours; but it seldom happens that art and nature so cordially unite. It is enough to say that the former is perceptible only in the most perfect harmony; otherwise, it appears to vanish into pure nature:—not a tree or a bush seems planted by design. The vast resources of distant prospect are wisely husbanded; they come upon the eye by degrees, and as if unavoidably: every path is cut in a direction which seems the only one it could take without constraint and artifice: the most enchanting effects of woods and plantations are produced by skilful management, by contrast of masses, by felling some, thinning others, clearing off or keeping down branches; so that the eye is attracted now into the depths of the wood, now above, now below the boughs; and every possible variety within the region of the beautiful is produced. This beauty is never displayed naked, but always sufficiently veiled to leave the requisite play for the imagination: for a perfect park,—in other words, a tract of country idealized *by art,*—should be like a good book, which suggests *at least* as many new thoughts and feelings as it expresses.


The dwelling-house is not visible till you reach an opposite height; it then suddenly emerges from the mass of wood, its outline broken by scattered trees in groups, and its walls garlanded with ivy and roses and creeping plants. It was built after the plan of the possessor; in a style not so much Gothic as antiquely picturesque, such as a delicate feeling of the suitable and harmonious conceived to be in keeping with the surrounding scenery. The execution is excellent; for the imitation of the antique is quite deceptive. The ornaments are so sparingly and so suitably interspersed, the whole so well constructed for habitation and comfort, and the part which appears the oldest has such a neglected and uninhabited air, that the impression it made, on me at least, completely answered the intention of the architect; for I took it to be an old abbey, lately rendered habitable, and modernized just so far as our habits rendered necessary. At the back of the house are hothouses and a walled garden in beautiful order, both connected with the sitting-rooms,—so that you



---

p.378



live in the midst of flowers, tropical plants and fruits, without leaving the house. The climate is the most favourable possible for vegetation,—moist, and so warm that not only azaleas, rhododendrons, and all sorts of evergreens stand abroad through the winter, but even, in a favourable aspect, camellias. Dates, pomegranates, magnolias, lyriodendrons, &c. attain their fullest beauty; and the three last are not even covered. The situation affords extensive views, remarkable variety, and yet a complete whole, enclosed within high mountains. **Bantry** and **Glengariff** bays are seas in miniature, and supply to the eye the want of the ocean. On the land side the wavy lines of mountain seem nearly endless.


The lesser bay of **Glengariff**, which stretches in front of the house, is nine miles, the other fifty miles in circumference. Among the mountains immediately opposite to the park rises another sugar-loaf, and at its foot a narrow line of hills stretches into the midst of the bay, where its termination is picturesquely marked by a deserted fort. The park itself lies along one entire side of the bay, and at its lesser end borders on that of **Bantry**, where Lord B——'s house forms the principal object from this side. This whole beautiful domain was called out of nothing only forty years ago, and is yet only half finished. Such a work deserves a crown: and the excellent man who with slender means, but with singular talent and perseverance, has accomplished it, ought to be held up as a model to those Irish proprietors who spend their money abroad. I heard with real satisfaction, that on his and Lord B——'s estates party hate is unknown. Both are Protestants,—all their ‘tenants’ are Catholics; nevertheless they render an obedience as boundless as it is voluntary and cordial. Colonel W——, indeed, lives like a patriarch among them, as I learnt from the common people themselves, and settles all their differences, so that not a penny is spent in the wire-drawings of the law.


You may be sure that I was eager to make the acquaintance of so admirable a man: I esteemed myself, therefore, highly favoured by fortune in meeting him in the park inspecting the operations of his workmen. Our conversation took a very interesting and, to me, very instructive turn. I readily accepted his invitation to breakfast with him and his family; and found in his wife a lady with whom I had made a transient acquaintance in the whirl of **London**. She received so unexpected a guest most cordially, and introduced me to her two daughters of seventeen and eighteen. They are not yet out; for as I have told you, in **England**, where they bring out horses ‘sans comparaison’ too early, the poor girls are let to grow almost old before their leading-strings are taken off and they are launched into the wicked world.


The family show me all possible civility and kindness; and as the ladies saw me so passionate a lover of nature, they urged me to stay some days, that I might visit the various wonders of their neighbourhood, especially the celebrated waterfall, and view from Hungry Hill, in their company. It was impossible for me to stay, as I had already announced myself at **O'Connell**'s; but shall certainly avail myself of their invitation on my way to **Cork**, for such society is not of the kind that I shun.


I therefore contented myself for the present with taking a long walk with the whole family, first along the bay, to obtain a general view of the park and garden; then into a wood, in which Lord B—— has a ‘shooting lodge.’ This spot is as if invented for a romance. All that the most secluded solitude, the richest vegetation, the freshest and greenest meadows, surrounded by rocks and mountains; valleys on whose sides precipitous walls of rock, sometimes a thousand feet high, thickly-wooded glens, a rapid torrent dashing over masses of rock and over-arched by picturesque bridges of trunks and arms of trees; groves amid which the sunbeams play, and the cool waters refresh a



---

p.379



thousand wild flowers; animals sporting about in joyous security, majestic eagles and gay-plumed singing birds, all rendered doubly dear to the poetic heart by the sweetest repose and retirement;—all that such elements can produce is here found combined in the richest profusion. With melancholy regret I quitted these enchanting fancies of our dear mother earth, and tore myself away, when we reached the rustic gate, at which my guide and poney were already waiting for me.


As I took leave of my new friends, and turned my back on the lovely valley, the heavens were overclouded anew, and on my entrance into the dreary rocky region which I described to you yesterday, assumed the hue most suited to my disposition and to the surrounding objects. Tired of my long ride of yesterday, I wished to walk; but on my inquiring for my over-shoes, which the wetness of the road rendered needful, I found that the guide had lost one of them; and as fine scenery is better enjoyed dry-footed, I sent him back, hoping to restore to my sorrowful galoche its faithful mate, at least for the morrow: for to-day I resolved to continue my way through thick and thin on foot.


A soft rain began to fall,—one mountain after another was veiled from sight; and I wandered on, to the region where only the vast bones of the earth are visible, casting back many a melancholy lingering thought to the lost paradise. Meanwhile the rain became more and more heavy, and sudden gusts of wind soon announced a serious storm. I had to climb the high mountain which lies in the middle of the first half of the way, and already I was met by torrents of water which gushed like little cascades through every cleft. As I am seldom in the way of enjoying such a bath in the open air, I waded with a great feeling of satisfaction and pleasure through the streams, throwing myself in some degree into the pleasurable state of mind of a duck. Nothing of that kind is, as you know, impossible to my mobile fancy. But as the weather became every minute more dark and stormy, my thoughts also became more gloomy, and indeed fell almost into the fashionable scornful satanic vein. The superstition of the mountains surrounded me; I could not withstand it, and **Rübezahl**, the Bohemian Huntsman, elfs, fairies, and the Evil One himself, all passed before my mind; and I asked myself, ‘why should not the Devil appear to me, as well as to other respectable gentlemen?’ At this instant I reached the highest point of the steep mountain.


The storm howled furiously, water fell in sheets from the heavens, and the deep basin below me appeared now and then for a minute from behind its black curtain, and then vanished again in the rolling mist and the gathering twilight. A sudden gust of wind now completely inverted my umbrella, and nearly threw me down. I felt as if some giant fist had struck me. I turned and saw—nothing:—But how? does not something move there in the corner?—by heaven it does! My amazement was not slight when I now discerned, as clearly as darkness and rain would permit, a figure clad in black from head to foot, with a scarlet cap on its head advancing at a slow and limping pace towards me.


Now, dear Julia, ‘est-ce moi ou le diable qui écrira le reste?’ or do you think I am inventing a fable to amuse you. ‘Point du tout’—‘Dichtung und Wahrheit’ is my motto. At all events I must close my letter here: I venture to hope my next will be expected with some impatience. Wholly yours,
  

L——.




---

p.380


### **Kenmare**, Sept. 28th, 1828

Beloved Friend,—


Was it the devil or not then? you ask. ‘Ma foi, je n'en sais rien.’ At any rate he had assumed a very ‘recommendable,’ though rather dangerous form, that of a pretty girl, who, wrapped in her long dark blue cloak, made darker by the rain, and with the red cap of **Kerry** on her head, barefoot and shivering with cold, was going to pass by me, when I asked her what made her limp? and why she was wandering alone in such weather? ‘Ah’ said she, in half-intelligible patois, and pointing to her foot bound up, ‘I was only going to the next village, and I am belated, and I fell into the terrible weather, and I have hurt myself very much;’ and then she looked down with an arch bashfulness, and showed the pretty wounded ancle. We walked on together *and* shared the difficulties of the way,—helped one another where we could, and at length found in the valley, first, better weather; then a place of shelter; and at last, a refreshing draught of new milk.


Thus invigorated I wandered on by night; and when I reached **Kenmare**, I had walked four German miles in something more than six hours: I was, however, heartily tired, and as soon as I reached my bed-room I exclaimed with
Wallenstein, *Ich denke einen langen Schlaf zu thun!’’*

(Wallenstein's Tod V, 5, 85)




### **Derrinane Abbey**, Sept. 29th


This accordingly happened; and I had plenty of time, for the weather was so horribly bad that I waited in vain, alas! till three in the afternoon for better. I had sent a messenger to **O'Connell** the evening before, and had very inconsiderately paid him beforehand. I found him at the inn, without an answer and with broken shins. As soon as he had felt the money in his pocket he had been unable to resist the whiskey, and in consequence he and his horse had fallen down a rock in the night. He had, however, had the extraordinary sense and thought to send on a friend of his to fulfil his mission; and at my waking I found a very polite invitation from **the Great Agitator**.


I have already said that I did not set out till three o'clock; and although I had to ride seven hours with a most violent rain beating in my face, and in this desert where not even the shelter of a single tree is to be found, I had not a dry thread upon me after the first half hour. I would on no account have missed this extraordinary part of my adventures.


The beginning was certainly difficult. At first I could not get a horse, for that which I had ridden at **Glengariff** had hurt his foot. At length appeared an old black cart-horse, which was destined for my use, and a sort of cat-like little animal intended for my guide. I was also in imbroglio with regard to my toilet. The lost galoche had not been found, and the umbrella was already unreeled on the haunted mountain. I replaced the first by a large slipper of my host's; the second I tied together as well as I could, and then holding it before me like a shield, with a pocket-hankerchief covered with a piece of oilcloth over my head, I galloped off in search of fresh adventures,—a perfect **Don Quixote**, and attended by a no less faithful representative of **Sancho Panza**.


Before I got a quarter of a mile from the town a destructive gust of wind made a deplorable end of my umbrella, once the ornament of New Bond Street, and since the companion of so many a disaster. All its cords broke, and left only a torn piece of silk and a bundle of whalebone in my grasp: I gave the remains to my guide, and surrendered myself without further solicitude



---

p.381



or defence to the elements, determined to bear good-humouredly what could not be altered.


As long as we coasted the bay of **Kenmare**, we rode on as quickly as possible, the road being tolerable. Soon, however, it assumed a worse aspect. The entrance to the wilder mountain country is marked by a picturesque bridge, thrown across a chasm an hundred feet high, called ‘The Bridge of the Black Water.’ The sides of the chasm were clothed with oaks,—the last trees which I beheld. I remarked that my valise, which my guide had fastened on his horse, must inevitably be soaked through, and ordered the man to endeavour, if possible, to get a mat or sack at the nearest cabin, to lay over it. This incautious act I had abundant cause to rue: he too was, apparently, detained by the fascinations of whiskey; at any rate, though I frequently stopped in the hope that he would overtake me, I did not see him again till just at the end of my journey, which afterwards caused me the greatest perplexity.


The road, which gradually grew worse and worse, lay for the most part close to the sea, which the storm threw into magnificent agitation;—sometimes across a dreary flat of bog, sometimes by the side of chasms and steep precipices, or through wide chaotic plains, in which masses of rock were thrown together in such wild confusion, that it seemed the spot from which the giants had stormed heaven.


At rare intervals I met a solitary ragged wanderer; and the thought often recurred to me, how easy it were in this desert region to rob or murder me without the slightest risk of discovery. My whole travelling property resides in my breast pocket; for in the Grecian fashion I carry ‘omnia mea’ with me. But far removed from all predatory thoughts, these poor good-hearted people invariably greeted me with respectful kindness, although my exterior was anything but imposing, and to an English eye by no means bespoke a ‘gentleman.’ I was frequently in utter uncertainty which of the half-imperceptible roads I ought to take, but unfortunately determined to keep as near to the sea as possible, which, though not the nearer, was the surest. Meanwhile time passed on; and when, at long intervals, I met a human being, and asked ‘How far is it to **Mr. O'Connell**'s?’ the object of my visit always drew down a blessing upon me. I was answered with a ‘God bless your honour!’ but the miles seemed rather to increase than to diminish.


At length it began to grow dark just as I reached a part of the coast, which assuredly it would be difficult to parallel. Foreign travellers have probably never been thrown into this desolate corner of the earth, which belongs rather to owls and sea-mews than to men, and of whose awful wildness it is difficult to give an idea.—Torn, jagged, coal-black rocks, with deep caverns, into which the sea breaks with ceaseless thunder, and then again dashes over the top of the tower-like crags its white foam; which, drying, is borne by the wind in compact masses, like locks of wool, over the highest points of the mountains;—the wailing cry of the restless fluttering sea-fowl, piercing through the storm with its shrill monotonous sound; the incessant howl and roar of the undermining waves, which sometimes suddenly dashed over my horse's hoofs, and then ran hissing back again; the comfortless removal from all human help;—the ceaseless pattering rain, and the coming-on of night on an uncertain and entirely unknown road.


I began really to feel uneasy, in earnest,—not half in jest as the day before. Your eager search for the romantic will turn out as ill for you, as for the Sorrowful Knight, thought I, and urged on my tired horse to his utmost speed. He stumbled every moment over the loose stones, and with great difficulty I at length brought him into a heavy trot. My anxiety was increased by **O'Connell**'s letter. He had written to me that the proper approach to his house was from **Killarney**,—that carriages must cross thence by water; but that the road



---

p.382



from **Kenmare** was the most difficult, and that I must therefore be sure to provide myself with a safe guide. And, as is generally the case when we pursue one train of thoughts with great pertinacity, a popular tale of **Croker**'s, which I had lately read came into my mind. ‘No land,’ says he, ‘is better than the coast of Inveragh to be drowned in the sea; or if you like that better, to break your neck on shore.’ Yet thought I—and here my horse suddenly stumbled, shyed, and turned with such a leap as I had hardly given the old mare credit for. I now found myself in a narrow pass. It was still light enough to see several steps before me clearly, and I could not understand what had struck this panic into my horse. Making all the resistance he could, and only in obedience to the admonitions of my shillelah, he at length went on again; but in a few steps I perceived with astonishment that the path, which had appeared pretty well tracked, terminated directly in the sea. The bridle nearly dropped out of my hand, as a foaming wave chased by the storm sprang upon me like a huge monster, and scattered the narrow cleft far behind me with its spray. Here was really a difficult situation. Bare inaccessible rocks surrounded me on every side,—before me rolled the ocean,—there was nothing for me but to retreat. But if I had lost my way, as I could not but suspect, how could I reckon on meeting my guide, even by returning; and if I did not meet him, where was I to pass the night? With the exception of **O'Connell**'s old castle, there was no hope of meeting with the least trace of a shelter for twenty miles round. I was already shivering with cold and wet, and my constitution would certainly not carry me through a bivouac in such a night. I had doubtless cause for some alarm. It was useless, however, to consider: I must ride back, that was clear; and as quickly as possible. My horse seemed to have come to the same conclusion; for, as if inspired with new force, he bore me away from the spot at a gallop. But would you believe it: a black figure was again destined to help me in my difficulty. You will say this is too much. ‘Ce n'est pas ma faute; le vrai souvent n'est pas le vrai-semblable.’ In short, I saw a black figure glide like a dim phantom across my path, and disappear behind the rocks. Invocations, prayers, promises, were in vain:—Was it a smuggler allured to this coast by the ample facilities it offers? or a superstitious peasant who took my unhappy person for a ghost? At all events it appeared that he did not choose to venture from his hiding-place, and I began to despair of the help I had thought at hand; when suddenly his head peeped out close to me from the cleft of a rock. I soon succeeded in tranquillizing his fears, and he explained to me the puzzle of the road terminating in the sea. ‘This road was made for low water; the tide is now,’ he said, ‘about half in; a quarter of an hour later it is imposible to pass; but now, if you'll pay me well, I will try and bring you through,—but we must not loose a moment.’ With these words he seated himself at one bound on the horse behind me, and we made what speed we could back to the sea, which was rolling with great rapidity.


I felt a strange sensation as we now appeared deliberately to plunge down into the stormy sea, and had to make our difficult way amid the white waves and the rocks, which looked like ghosts in the dim twilight.


We had the greatest trouble too with the horse: however, the black man knew the ground so perfectly that we reached the opposite coast in safety, though bathed up to the arms in salt-water.


Unluckily, the terrified beast shyed again here at a projecting rock, and broke both the rotten girths directly in the middle, a mischance for which there was no remedy here. After all my disasters, I had the agreeable prospect of riding the last six miles balancing on the loose saddle. My black guide had indeed given me the clearest directions for the prosecution of my journey; but it was now so dark that the landmarks were no longer visible.


The road as it appeared to me, across a wide moor, and was at first quite



---

p.383



level. After half an hour of rough and stumbling trotting, during which I pressed my knees as hard as possible together, that I might not lose my saddle, I remarked that the road turned again to the right into the higher range of mountains; for the climbing grew steeper and more continual. Here I found a woman, who was passing the night with her pigs or goats. The road branched off into two divisions, and I asked her which I must take to reach Derrinane Abbey? ‘Oh! both lead there,’ said she; ‘but that on the left is two miles nearer.’ Of course I took this, but soon found to my cost that it was practicable only for goats. I execrated the old witch, and her traitorous intelligence:—my poor horse exhausted himself in vain efforts to climb through the blocks of stone, and at length, half stumbling half falling, he threw both saddle and me. It was impossible to keep the saddle on him alone; it fell down incessantly, and I was obliged to load my own shoulders with it, and to lead my horse besides. Till now I had kept in pretty good temper;—the spirit was still willing, but the flesh began to be weak:—the man on the cliff had said, only six miles further, and you are there; and now, after half an hour's hard riding, the woman insisted upon it that it was still six miles, the shortest way, to Derrinane. I began to fear that this mountain fortress was not to be found, and that I was the sport of Kobolds, who bandied me from one to another. I seated myself on a stone quite out of heart, fevered with alternate heat and cold; when, like the voice of an angel in the wilderness, the shouts of my guide resounded in my ear, and I soon heard the trampling of his horse's hoofs. He had taken quite a different way though the interior of the mountains, to avoid the sea, and had luckily met the woman whose direction I had followed.


In the delicious feeling of present security, I forgot all my disasters, loaded my deliverer with the saddle and my wet cloak, gave up my horse to his guidance, and seated myself upon his, thus making what speed I might. We had, in fact, five miles yet to ride, and that through a mountain-pass surrounded by precipices,—but I can give you no further description of the road. The darkness was so complete, that I was obliged to strain my eyes to the utmost to follow the man, who appeared only like a dim shadow flitting indistinctly before me. I perceived by the stumbling of my horse that we were on uneven ground; I felt that it was a continual alternation of steep ascents and descents; that we waded through two deep and rapid mountain torrents,—but that was all:—now and then, indeed, I suspected, rather than saw, that a bare wall of rock rose by my side, or the deeper black beneath me betrayed the precipice which yawned below.


At length,—at length a bright light broke through the darkness; the road grew more even; here and there a bit of hedge was visible; and in a few minutes we stopped at the gate of an ancient building standing on the rocky shore, from the windows of which a friendly golden radiance streamed through the night.


The tower clock was striking eleven, and I was, I confess, somewhat anxious as to my dinner, especially as I saw no living being, except a man in a dressing-gown at an upper window. Soon, however, I heard sounds in the house; a handsomely-dressed servant appeared, bearing silver candlesticks, and opened the door of a room, in which I saw with astonishment a company of from fifteen to twenty persons sitting at a long table, on which were placed wine and desserts. A tall handsome man, of cheerful and agreeable aspect, rose to receive me, apologized for having given me up in consequence of the lateness of the hour, regretted that I had made such a journey in such terrible weather, presented me in a cursory manner to his family, who formed the majority of the company, and then conducted me to my bedroom. This was the great **O'Connell**.




---

p.384


On my return to the dining-room I found the greater part of the company there assembled. I was most hospitably entertained; and it would be ungrateful not to make honourable mention of Mr. **O'Connell**'s old and capital wine. As soon as the ladies had quitted us, he drew his seat near me, and **Ireland** was of course the subject of our conversation. He asked me if I had yet seen many of the curiosities of **Ireland**? whether I had been at the **Giant's Causeway**?— ‘No,’ replied I, laughing, ‘before I visit the **Giant's Causeway**, I wished to see **Ireland**'s Giants;’ and therewith drank a glass of claret to his high undertakings.


**Daniel O'Connell** is indeed no common man,—though the man of the commonalty. His power is so great, that at this moment it only depends on him to raise the standard of rebellion from one end of the island to the other. He is, however, too sharp-sighted, and much too sure of attaining his end by safer means, to wish to bring on any such violent crisis. He has certainly shown great dexterity in availing himself of the temper of the country at this moment, legally, openly, and in the face of the government, to acquire a power scarcely inferior to that of the sovereign; indeed, though without arms or armies, in some instances far surpassing it:—for how would it have been possible for His Majesty George IV. to withhold 40,000 of his faithful Irishmen for three days from whiskey-drinking; which **O'Connell** actually accomplished in the memorable Clare election. The enthusiasm of the people rose to such a height, that they themselves decreed and inflicted a punishment for drunkenness. The delinquent was thrown into a certain part of the river, and held there for two hours, during which time he was made to undergo frequent submersions.


The next day I had fuller opportunity of observing **O'Connell**. On the whole, he exceeded my expectations. His exterior is attractive; and the expression of intelligent good-nature, united with determination and prudence, which marks his countenance, is extremely winning. He has, perhaps, more of persuasiveness than of genuine large and lofty eloquence; and one frequently perceives too much design and manner in his words. Nevertheless, it is impossible not to follow his powerful arguments with interest, to view the martial dignity of his carriage without pleasure, or to refrain from laughing at his wit. It is very certain that he looks much more like a general of **Napoleon**'s than a **Dublin** advocate. This resemblance is rendered much more striking by the perfection with which he speaks French,—having been educated at the Jesuits' Colleges at Douai and St. Omer. His family is old, and was probably one of the great families of the land. His friends, indeed, maintain that he springs from the ancients kings of Kerry,—an opinion which no doubt adds to the reverence with which he is regarded by the people. He himself told me,—and not without a certain *pretension,*—that one of his cousins was Comte O'Connell, and ‘cordon rouge’ in **France**, and another a baron, general and chamberlain to the Emperor of Austria; but that he was the head of the family. It appeared to me that he was regarded by the other members of it with almost religious enthusiasm. He is about fifty years old, and in excellent preservation, though his youth was rather wild and riotous.


Among other things he became notorious, about ten years ago, for a duel he fought. The Protestants, to whom his talents early made him formidable, set on a certain Desterre,—a bully and fighter by profession,—to ride through all the streets of **Dublin** with a hunting-whip, which, as he declared, he intended to lay on the shoulders of the king of **Kerry**. The natural consequence was a meeting the next morning, in which **O'Connell** lodged a bullet in Desterre's heart; Desterre's shot went through his hat. This was his first victory over the **Orangemen**, which has been followed by so many more important, and, it is to be hoped, will be followed by others more important still.




---

p.385


His desire for celebrity seemed to be boundless; and if he should succeed in obtaining emancipation, of which I have no doubt, his career, so far from being closed, will I think only then properly begin. But the evils of **Ireland**, and of the constitution of **Great Britain** generally, lie too deep to be removed by emancipation.—To return to **O'Connell**; I must mention, that he has received from nature an invaluable gift for a party-leader; a magnificent voice, united to good lungs and a strong constitution. His understanding is sharp and quick, and his acquirements out of his profession not inconsiderable. With all this, his manners are, as I have said, winning and popular; although somewhat of the actor is perceivable in them, they do not conceal his very high opinion of himself, and are occasionally tinged by what an Englishman would call ‘*vulgarity,*’ Where is there a picture entirely without shade!


Another interesting man, the real though not ostensible head of the Catholics, was present, **Father L'Estrange**, a friar, and **O'Connell**'s confessor. He may be regarded as the real founder of that **Catholic Association** so often derided in **England**, but which by merely *negative* powers, by dexterous activity in secret, and by universally organizing and training the people to one determinate end, attained a power over them as boundless as that of the hierarchy in the middle ages; with this difference, that the former strove for light and liberty, the latter for darkness and slavery. This is another outbreak of that *second* great revolution, which solely by intellectual means, without any admixture of physical force, is advancing to its accomplishment; and whose simple but resistless weapons are public discussion and the press. **L'Estrange** is a man of philosophical mind and unalterable calmness. His manners are those of an accomplished gentleman, who has traversed Europe in various capacities, has a thorough knowledge of mankind, and with all his mildness cannot always conceal the sharp traces of great astuteness. I should call him the ideal of a well-intentioned Jesuit. As **O'Connell** was busy, I took an early walk with the friar to a desert island, to which we crossed dry-footed over the smooth sand now left by the ebb. Here stand the genuine ruins of **Derrinane Abbey**, to which **O'Connell**'s house is only an appendix. It is to be repaired by the family, probably when some of their hopes are fulfilled.


On our return we found **O'Connell** on the terrace of his castle, like a chieftain surrounded by his vassals, and by groups of the neighbouring peasantry, who came to receive his instructions, or to whom he laid down the law. This he can the more easily do being a lawyer; but nobody would dare to appeal from his decisions: **O'Connell** and the Pope are here equally infallible. Lawsuits therefore do not exist within his empire; and this extends not only over his own tenantry, but I believe over the whole neighbourhood.


I wondered, when I afterwards found both **O'Connell** and **L'Estrange** entirely free from religious bigotry, and even remarked in them very tolerant and philosophical views, though they persisted in choosing to continue true Catholics. I wished I had been able to conjure hither some of those furious imbeciles among the English Protestants,—as for instance Mr. L——, who cry out at the Catholics as irrational and bigoted; while



---

p.386



they themselves alone, in the true sense of the word, cling to the fanatical faith of their politico-religious party, and are firmly predetermined to keep their long ears for ever closed to reason and humanity.


In the course of the day we were to have a hare-hunt, (for **O'Connell** has a small pack of hounds,) which would certainly have presented a most picturesque spectacle on these mountains and broad naked steeps: the bad weather, however, prevented it. I found much greater enjoyment in repose, and in the very interesting company, to which I am indebted for much instructive information.


### **Kenmare**, Sept. 30th


Although my kind hosts with true Irish hospitality pressed me to stay a week longer for a great festival which is in preparation, and to which a large company is expected, I did not think it right to take this entirely ‘à la lettre;’ besides which I had such a longing after **Glengariff**f, that I did not wish to absent myself from it longer than was necessary for the end I had in view. I therefore took leave of the family this morning, with the sincerest thanks for the friendly welcome they had given me. **O'Connell** himself escorted me to the boundaries of his demesne, mounted on a large and handsome gray horse, on which he looked more military than ever. The rugged way is bare of all vegetation, but affords many sublime views, sometimes inland, sometimes to the sea, studded with rocks and islands, some of which rise completely isolated out of the water like high-peaked mountains. **O'Connell** pointed out one to me, on which he told me he had ordered an ox to be landed that he might fatten on the rich and undisturbed herbage. After some days the animal took such decided possession of the island that he was furious if any body attempted to land on it, and attacked and drove away even the fishermen who used to dry their nets on the shore. He was often seen, like Jupiter under his transformation, with uplifted tail and glaring eyes, bounding furiously along to reconnoitre the bounds of his domain, and to see if any intruder dared to approach. The emancipated ox at last became so troublesome and dangerous, that they were obliged to shoot him. This appeared to me a good satire on the love of liberty, which as soon as it has gained the power it seeks, degenerates into violence and tyranny; and the association of ideas brought many comical images involuntarily before my mind.


We afterwards came to a remarkable ruin, one of those so-called Danish forts, which were built, not *by* the **Danes** but *against* them. They are more than a thousand years old, and the lower walls, although put together without mortar, remain in excellent preservation. At the ruins of a bridge carried away by the swelling of a mountain-stream, **O'Connell** stopped to take a final leave of me. I could not help expressing to the champion of the rights of his countrymen, my wish that when we next met, the dungeons and fortresses of English intolerance might be overthrown by him and his allies, as completely as these ruined walls had been by the swollen and overflowing torrent. So we parted.


As I returned by nearly the same way as I had come, I have little new to say about it, except that, though the day was fine, it tired me twice as much as before; probably because my mind was less excited. Not far from **Kenmare** I met several loads of stones, planks, beer, and butter. Every thing is conveyed on the backs of horses. The Irish are very ingenious



---

p.387



in means of transport. I have already described their admirable cars, with which one horse can so commodiously draw five or six persons. They have also a sort of car, equally well contrived, for the carriage of hay, wood, &c.; by means of which one horse does as much work as three with us. This is accomplished entirely by the skill with which the weight is balanced. A car is loaded with long timber, for instance, in such a manner that the horse is hardly visible under the complete covering of wood, the ends of which project many yards before the horse's head and behind the car. The division of the weight at each end is thus so perfect that the timbers press only on one point, and the horse has thus comparatively little to draw. The driver helps a little, going up or down hill, by heaving up or bearing down the ends, which the slightest force is sufficient to move.


In the same manner five or six heavy oak planks are laid flat across the saddle of a horse, who carries them thus, like a balancing pole, without much labour, though the same weight in a different volume, a chest for instance, would suffice to crush him. They have another ingenious contrivance for transporting stone; a sort of wooden baskets or cradles which they hang over the saddle, binding them on the horse's back over a thick bundle of straw.


The merry humour and good-natured politeness of the people I met were very engaging. I know no nation of which the lower classes appear so little selfish; so thankful for the least friendly word vouchsafed to them by a gentleman, without the least idea of gain. I really know no country in which I would rather be a large landed proprietor than here. What I did elsewhere, and earned only ingratitude and opposition of every kind, would here attach ten or twelve thousand people to me body and soul;—the only difference is, that here with much less time and cost I should have attained infinitely greater results, since here nature and man make almost every thing attainable. The people taken in a body, with all their wildness, unite the frank honesty and poetical temper of the Germans, with the vivacity and quickness of conception of the French, and the pliability, naturalness, and submissiveness of the Italians. It may with the fullest justice be said of them, that their faults are to be ascribed to others, their virtues only to themselves. Now I am upon this subject, I must relate to you an incident of no great importance which befell me some days ago: it deserves mention, as illustrative of the national character.


As I was going from **Killarney** to **Kenmare**, I met a continual succession of people driving cattle from some neighbouring fair. Most of them were riding colts they had just bought, without bridles; and as man and beast were strangers to each other, the latter were not in a very perfect state of subordination: we were therefore often forced to stop. At last I grew tired of this; and at the third or fourth rencontre of the kind, I called out to the people that I had not time to spend half the day on the road on account of their clumsiness; and somewhat hastily ordered the coachman to drive on. In in instant two colts set off with their riders, galloping before the carriage as hard as ever they could, while the whole drove of cattle took to the mountains. I was now sorry for my impatience, and desired the driver to stop again. There were in all four or five drovers whom I had thus routed, all sturdy young fellows; and the trick I had played them was certainly one of the most disagreeable that could be imagined, as it would take them at least half an hour to collect their dispersed cattle. If a traveller in a miserable one-horse vehicle



---

p.388



had given such a job to Germans, Englishmen, or Frenchmen, they would certainly have attacked him with appropriate abuse, and very likely have tried to catch him and do him some injury. The behaviour of these good-natured fellows was far different: at once respectful and witty. ‘Oh! murther, murther!’ cried one, while his ‘crantancarous’ colt made another attempt to dart up the hill, and nearly threw him; ‘God bless your honour! but every *gentleman* in **England** and **Ireland** gets out of the way of cattle! Oh, for God's sake stop now, your honour, stop!’ I immediately stopped: and after the poor devils had had the greatest trouble in fetching back the part of the cattle that had run the furthest, they came back to my car, with a ‘long life to your honour!’ to thank me for my goodness, and went merrily off with their recaptured prize. I must confess that their behaviour was far more commendable than mine, which I repaired as well as I could by means of a handsome present.


### October 1st: Morning


Although dreadfully tired I could not sleep last night, and asked the host if he had a book. He brought me an old English translation of the Sorrows of Werther. You know highly, how intensely I honour our prince of poets, and will therefore hardly believe me when I say that I had never read this celebrated book. The cause would appear to many very childish. The first time it came into my hands, the passage at the beginning in which Charlotte wipes the little boy's dirty nose excited in me such disgust that I could read no further; and this disagreeable image remained, always present to my mind. I now, however, set earnestly to work to read it, struck with the strangeness of the accident which led me to read Werther for the first time in a foreign tongue, and in the midst of the wild mountains of **Ireland**. But even here, I must honestly confess I could not feel any hearty relish for the antiquated Sufferings; the quantity of bread and butter, the provincial and obsolete manners, and even the ideas, which were then new, but are now become common-place,—like **Mozart**'s beautiful melodies degraded into street ditties; lastly, the involuntary recollection of **Potier**'s admirable parody,—it was absolutely impossible for me to work myself up to the right ‘communion frame of mind,’ as Madame von Frömmel calls it. But thus much I could perceive, jesting apart, that the book was calculated to ‘far furore’ at one period: for the morbid state of mind under which **Werther** sinks is truly German, and German feeling was just then beginning to make its way through the materialism which had taken possession of the rest of Europe. Wilhelm Meister indeed followed it with far different steps; and Faust has since traversed it with giant strides. We have, I think, outgrown the Werther period, but have not yet reached that of Faust; nor will any age, so long as men exist, outgrow that.


In the tragedy of Faust, as in those of ***Shakespeare***, the whole inward man is mirrored forth; the principal figure is a personification of the eternal mysterious longings of the human heart, the restless striving after the Unknown and the Unattainable. Hence this drama can obviously never have a fully definitive end, even were it extended through many more acts than it is. But as the lofty spirit here treads a path dizzy as the bridge of Al 



---

p.389



Sirat, he is every moment nearer to the bottomless fall than the human animal who remains quietly on the secure plain, and feeds.


A cousin of **O'Connell**'s, who gives hunting parties on the **lake of Killarney**, had promised me one for to-morrow. I have, however, a positive antipathy to going to see what I have seen before, as long as there is any thing new to see; and I cannot imagine that dogs and horses can make any great alteration in the features of a scene I know so well. On the other hand, in **Glengariff**, amiable people and a great deal of novelty awaited me: I therefore preferred it, rode once more across the **Devil's Mountain**, this time by daylight, and arrived here about an hour ago. I am established in a pretty little room, and all the glories of the Bay are spread before my window.


Before I quitted **Kenmare** my vanity was put to a severe trial. The Irish naïveté of the inkeeper's daughter made such an agreeable impression on me, that on my return to her father's inn I scarcely talked to any body else, and thus won her good graces. She had never quitted her native mountains, and was as ignorant of the world as it is possible to conceive. I asked her, in jest, if she would go with me to **Cork**. ‘Oh no,’ said she, ‘I should be afraid to go so far with you.—Do tell me now who you really are: You are a Jew;—that I know already.’ ‘Why, are you mad?’ said I; ‘what makes you think I must be a Jew?’ ‘Ah, you can't deny it; hav'n't you a black beard all round your chin, and five or six gold rings on your fingers? And are you not an hour washing yourself in a morning, and don't you go through ceremonies such as no Christian ever saw? Confess it now,—you are a Jew, ar'n't you?’ My disclaimer was of no use. At last, however, she said good-humouredly, that if I positively would not allow that I was one, she wished at least that I might ‘become as rich as a Jew,’ (an English phrase.) I confirmed this with a Christian ‘Amen.’


### October 2d


I am just returned from an excursion of sixteen miles with Colonel W—— to **Hungry Hill**, a lofty mountain at the end of **Bantry Bay**, remarkable for its waterfall, and for **Thomas O'Rourke**'s flight to the moon on an eagle's back, which began here, and has so often been related in prose and verse. Even in **Germany** this amusing tale has been repeatedly translated, and has probably fallen into your hands. The hero of the story is a game-keeper of Lord B——'s, who is still alive, and almost always drunk. On our return Colonel W—— introduced him to me at the inn. He is now extremely proud of his celebrity, and seemed to me when I saw him to be projecting another visit to the moon.


The quantity of rain which has fallen these few days has added much to the beauty of the waterfalls. The fall at **Hungry Hill** entirely disappears in dry weather, but after violent rains exceeds the **Staubbach** and **Terni**. **Hungry Hill** is a huge mass of naked rock about two thousand feet high. On the land side it forms two steep terraces, on the ‘plateau’ between which there is a lake, which of course is not visible from below, whence you see only the continuous lines of these colossal terraces. The upper one consists of bare rock, and is divided in the middle by a deep vertical groove, which looks as if cut by art; the lower, although also free from any visible inequality, has its side clothed with heather and coarse grass, on which hundreds of goats are seen grazing.


Through the groove or channel mentioned above the mass of water shoots from the highest point of the mountain, falls into the lake on the



---

p.390



lower terrace, and filling that, rushes down afresh in four distinct cascades on the valley below. These form such vast arches, that the goats feed peacefully under them, while the streams convert the meadows below into a temporary lake.


As the spectator who stands below cannot see the division between the upper and the lower falls, nor the lake which lies between them, the whole appears one enormous cataract, the effect of which exceeds all description. Colonel W—— assured me that when the waters are at the highest he has seen the arch so enormous, that, to use his expression, a regiment of soldiers might have marched under it without a man being wetted; and, as he added, the noise would serve admirably for the thunder of the cannon.


One of the neighbouring glens was, according to the somewhat fabulous history of **Ireland**, the scene of a memorable battle between the great O'Sullivan and O'Donovan. The people show the remains of a very old arbutus, on which, as they relate, O'Donovan was hanged. It is very certain that money and jewels have recently been found buried deep in the earth in this enclosure.


The eagles of these mountains, who build on inaccessible rocks, play a very principal part in the popular stories. They are extremely large and strong, and it is certain that they sometimes carry off even children. Some time ago an eagle carried off a boy of three years old, and deposited him, probably because he was too heavy, nearly uninjured on a shelf of rock, to which the people below climbed and saved him. The new Ganymede, the ‘corpus delicti,’ is now living, and in full vigour. Another more tragical circumstance of the same kind occurred a few months ago. An eagle bore off a little girl before her father's eyes, and disappeared with her among the rocks; nor could the least trace of the poor child ever be discovered.


### October 3d


Col. W—— is as great a ‘parkomane’ as I, but not quite such a ‘gourmet’. Field-sports by land and water furnish his table with many delicacies. The grouse or moor-fowl are particularly good; and the oysterbed on the edge of the park supplies oysters of a peculiar fine flavour, and as large as a plate. The bay swarms with fish and sea-dogs:—I saw one of the latter sitting on a projecting cliff just opposite my window, and listening with a delighted and almost dancing motion to the music of a bagpipe which resounded from a neighbouring public-house. These creatures are so passionately fond of music, that they follow the pleasure-boats, with bands of music on board, in herds of twenty or thirty. They are decoyed in this way by sportsmen. It is really barbarous thus to abuse their love of the arts!


Unfortunately it rained all day, so that I was obliged to remain in the house. In the morning I attended the daily worship of the family, the female members of which are somewhat bigoted as to form, though, as it seemed to me, sincerely pious. We all sat round in a circle, and the mother read one verse out of the Church of England Prayer-book, the eldest daughter the next, and so on, alternately, imitating the parson and clerk at a church. After this, the daughter, who has something reserved and enthusiastic about her, began a strange and very long prayer, which lasted a full quarter of an hour; during which all, (and of course I among the number,) turned decorously towards the wall, fell on their knees before their chair, and hid their faces in their hands. The mother sighed



---

p.391



and groaned; the father seemed somewhat ‘ennuyée’ the youngest daughter,—a charming girl, who is a good deal more mundane than her sister,—had now and then fits of absence; and the son had thought it expedient to absent himself altogether. I, who think every sincere feeling or virtuous aspiration, at whatever time of the day, a prayer to God, believed myself not impiously employed in observing a little what was going on.


After the company had all stood up, brushed their knees, and smoothed down their petticoats, (for English enthusiasm does not easily forget *itself,*) a chapter from the Gospel was read by the mother. The one chosen was that in which six thousand men were fed on three loaves and two fishes, if I remember right, and much was still left remaining.


Happily for us, our dinner was not measured out to us upon this scale, and the gifts of God were consumed with great cheerfulness and satisfaction. To this; however, I soon gave an involuntary shock: I happened to speak in jest of the comet of the year 1832, which, it is predicted, is to approach near the earth's orbit than any hitherto known. I remarked that, according to **Lalande**'s reckoning, a comet which should approach within fifty thousand miles of the earth must inevitably exercise such a power of attraction as to raise the waters of the sea above the top of Chimborazo. If the one of 1832 comes so near us, said I, we shall infallibly all be drowned. ‘I beg your pardon, that is impossible,’ replied Mrs. W—— very earnestly, ‘for that would be a second deluge, and you appear to have entirely forgotten that we are promised in the Bible that there should never be another deluge, but that the earth should at last be destroyed by fire.’ (‘II faut avouer que la faveur n'est pas grande.’) ‘That this destruction is at hand,’ continued she, sighing, ‘I certainly believe; for the most learned of our pious men are agreed that we are now, probably, in the seventh kingdom of the Revelation of St. John, in which the end of the world is predicted, and in which our Saviour will come to judge us.’ What singular people these ‘saints’ are! On this, mother and daughter fell into such a violent, and at last such a bitter dispute, that I, unworthy layman, was obliged to interpose, and endeavour to re-establish peace. The question was, whether, at the time of this final catastrophe, men were to be immediately judged and then burnt, or first burnt and then judged. The daughter indignantly asked (‘je vous jure que je ne brode pas’) if our Saviour, on his coming, was to wait to pronounce judgment till the world was burnt? She said it was plainly written in the Scriptures that he would come to judge the quick and the dead; and how would this be possible if all were first burnt? It was clear that the world would not be burnt till all were judged. This the mother declared was perfect ‘nonsense!’—that men must necessarily first die, before they could receive either eternal blessedness or damnation,—that the passage which speaks of the quick and the dead, regarded only on the one hand those who would be still living at the time of the conflagration, or on the other, those who had long lain in the grave. She insisted therefore, ‘*first* burnt, and *then* judged.’ Both now appealed to me, in the hope of strengthening themselves by the accession of a partisan. I ventured to reply that I really was not much skilled in these details, and that their dispute appeared to me very like that in which **Madame du Deffant** was called upon to decide, viz., whether St. Denis had walked one mile or six without his head: to which she replied, ‘que dans ces sortes de choses ce n'est que le premier pas qui coute!’ That I must confess that in the doctrines of Christ I had always chiefly sought to imbibe



---

p.392



rules of duty, confidence in God, meekness, and love to man, though I had unhappily rarely succeeded to the extent of my wishes. I hoped, however, that I might dismiss all anxiety as to whether we were to be first judged and then burnt, or first burnt and then judged; that I believed whatever God did was perfectly well done. I must confess that I considered myself just as much in the hand of God, and just as near to his power, in the present life as after the close of my earthly career, or even after the destruction of the little globe which we call ‘the world.’ That judgment was in my opinion for ever going on, and was as eternally active as the spirit which creates and vivifies the universe. This confession of faith had the effect of entirely reconciling the combatants, by uniting them against me. I retreated from the field, however, in so dexterous a manner as not entirely to lose their favour.


In the evening, between torrents of rain, twilight, and sunset, we had another magnificent effect of light. *Our* waterfall in the park was so swollen that it took up itself to thunder a little too, and grass and bush were prettily illuminated with gay sunbeams. We walked about till it was quite dark, saw the **Great Sugar Loaf** gradually change its hue from dark blue into rose-colour, and feasted our eyes on the clear mirror of the lake, the leaping of the fish on its surface, and the peaceful sporting of the otters.


Every thing here is beautiful,—even the air, which is famed for its salubrity. There are no tormenting insects; for the bay is so deep, that the ebb leaves no muddy shore, and the constant gentle breeze of the valley is probably not agreeable to them. The climate is extremely equable, neither too hot nor too cold; and the vegetation so luxuriant, that only one thing more and one less are wanting to clothe the greater part of the bare mountains, and even the interstices between the rocks, with the richest and most beautiful woods: these two things are, planters, and goats. The former have no money, or none that they choose to spend in planting *here;* the latter suffer nothing to grow that is not enclosed within double walls. It appears that these mountains were formerly covered with forests; but the English, who have never had any other thought with regard to **Ireland** but how to draw as much money from her as possible, felled them all. Their remains are still visible in many places.


Another advantage of this spot is, to my taste at least, its perfect seclusion. It can hardly be reached in a carriage; and with the exception of a few curious travellers, like myself, no attempt is made to overcome the difficulty of the approach. It is inhabited by a good-natured people, not congregated in villages, but scattered in solitary dwellings amid the mountains, and living a patriarchal life, unspoiled by the tumult of cities. Nor are they so distressingly poor as in other parts of the country: their wants are few; turf for fuel they have for the fetching, grass for their cows in the bogs, and the sea supplies them with an abundance of fish far beyond what they can consume. For a landowner, inspired with a spirit of enterprize and a love of improvement, an inexhaustible field here presents itself. Were I a capitalist, this is the spot where I would settle.


My worthy host takes upon himself to forward this letter immediately. Heaven grant that it may find you in the same happy state of mind which has inspired it! Remember the favourite saying of my venerable ancestress,—‘Coeur content, grand talent.’


Your truly devoted,

 L——


---

p.393


### **Glengariff**, October 4th, 1828

Dear Julia,


To-morrow I set out, ‘et bien à regret.’ I carry with me a precious memorial, one of the few perfectly delightful pictures which I have met with in my wanderings.


In my walk this morning, I found heath-plants of such luxuriance hanging from the rocks, that one stalk measured ten feet in length. The gardener, who accompanied me, drew my attention to another curiosity. In a secluded spot, not far from the pretty rustic dairy, a swarm of bees had made a large honeycomb in the open air; it was suspended to the branch of a blackberry-bush in the thicket. The weight of the honey bowed the branch to the earth; and they were still busily adding to the store. The dairy is roofed with earth, out of which the purple heather is growing. A clear spring flows through it, on whose banks the Egyptian lotus thrives admirably, and stands through the winter.


In the afternoon I rode out with Colonel W—— to visit an eagle's nest. We first passed the belt of wood in which Lord B——'s pretty shooting-lodge stands, then forded the swollen river three times, and after some hours riding, reached a wild desert, where at the foot of a perpendicular rock stand two solitary huts. About five hundred feet over head is the eagle's eirie, in a cleft overhung with ivy. At their hatching season they are frequently seen flying home with fowls, hares, lambs, &c. for the family table; by some curious instinct, however, they are warned never to carry off any thing from the two families below them, but to respect the same laws of hospitality which are observed towards themselves. I was greatly disappointed that these monarchs of the rocks did not make their appearance; they were both gone on some distant expedition.


We returned across the **Sugar-loaf**. This is the haunt of a wild huntsman, and no mortal tally-ho may sound as far as his right of sporting extends. If any attempt it, he quickly rushes by with all his wild troop, and hurries the rash offender along in his train. He is of a totally different nature from his German comrade. He is an elfin king, as small as **Tom Thumb**, splendidly dressed in emerald green, and accompanied by a train mounted on horses as big as rats, who gallop over rock and sea with the swiftness of lightning. The **Sugar-loaf** itself is the great resort of all the Irish fairies: its caverns are full of fossil-shells and stones of fantastic shapes, which excite the curiosity of the visitor; but no native would pass a night in one of them for all the treasures the earth contains. From the summit of this mountain, or rather rock, down to the cavern, a strange sport of nature is visible in clear weather;—two channels or grooves, winding, but always parallel, which in the distance look exactly like ruts: what could they be but the track of the fairy queen's carriage, in which indeed many an old mountaineer has seen her at rise or set of sun, riding in unearthly pomp to grace the annual feast with her presence. The old man would doubtless be ready to confirm his statement with the most solemn oaths,—for he believes it. This it is which gives to the legends of the Irish such a wonderful charm that it is almost impossible to withstand it.


Colonel W——, who was formerly a passionate lover of the chase,



---

p.394



knows every mountain in the district from the summit to the foot, and ‘chemin faisant,’ told me so many interesting particulars about them, that my letter would never come to an end if I attempted to make it the faithful echo of all his stories.


Hunting is here attended with dangers of no trifling kind. They are of three sorts: first, the being suddenly surprised in the midst of the rocks with one of those cold fogs which here frequently come on, and enwrap the wanderer with almost instant darkness and icy chill; he has then only the alternative either of perishing from cold (for the fogs sometimes hang in the gorges for whole days and nights,) or of falling headlong down some invisible precipice. If he is in favour with the fairies, he emerges happily into light; but wo to him who has incurred their displeasure!—his friends find him the next morning frozen or dashed to pieces. The second peril is of quite a different kind. On the wide interminable table-lands, which blend with the horizon like the sea, not a bush or hillock breaking the sublime monotony, are extensive bogs, which the game (the grouse, a bird somewhat like a partridge, peculiar to the British islands,) chooses as its favourite haunt. These bogs are full of little clumps like mole-hills, formed by the heather, scattered about at intervals. The bogs can only be traversed by jumping from one of these clumps to another: if in the ardour of the chase the sportsman misses his leap, and does not find another clump close by to jump to instantly, he is certain to sink in the morass. The only means of deliverance is instantly to stretch out his arms, or to hold his gun horizontally, till help arrives, or till he can struggle on to the next clump.


But worse and more tremendous than all this, is an attack from one of the wild oxen which inhabit these mountains. Colonel W—— has been several times in this predicament, and always had the good fortune to escape, though in different ways. Once he or his servant shot the bull before he came up with them: another time he took refuge in one of the bogs I have just described, where the furious beast dare not follow him, but laid regular siege to him for more than an hour. The history of his latest adventure seemed to me particularly curious, and proves that man, with strength, courage and address, may single-handed resist any other living creature. Colonel W—— was accompanied by a friend, and by a native of these mountains, who led the dogs, and was furnished with a long white staff, such as is in use here. Just as the Colonel's friend shot a grouse, he saw at the distance of about eighty feet a bull advancing furiously towards them. Colonel W—— called out to his friend to load instantly, while he fired; and was taking aim, when the man called out, ‘Promise me a glass of whiskey extra, and I will manage the beast by myself.’ W—— fired, but his gun missed fire; his friend had not loaded; and he had hardly time to call out, ‘You shall have a dozen bottles,’ when this hero of the mountains ran towards the ox at the same speed with which it was rushing upon them. In the twinkling of an eye they were together. The young man, with singular dexterity, caught the horns of the bull, whose head grazed the earth, darted a step sideways, and then during the spring of his antagonist, making a similar step backwards, with the rapidity of lightning caught the bull's tail, without letting go his stick. All this was done with the quickness of thought; and now began the strangest race that ever was beheld. The bull tried by every means to get rid of the burthen hanging at his tail, but in vain. Up hill and down, over rock, and through river, he ran like mad; while his companion, like a Kobold, 



---

p.395



swung himself over every obstacle, often flying rather than running, at the end of the creature's tail. In a short time the bull was wearied by fear and fatigue, and at length sank down exhausted and powerless at the foot of a green declivity, immediately in front of the spot where Colonel W—— and his friend beheld with astonishment the issue of the contest. But his punishment only now began, and probably his vicious temper was on that day cured for ever. For now the mountaineer began to employ his stick, weighted with lead and armed with an iron point, which he had providentially kept as an instrument of correction, and belabouring the beast with all his might, forced him to crawl down the mountain, where he at length sank, with his tongue hanging out of his mouth and panting for breath, at Colonel W——'s feet, who left him in this state of total exhaustion. The young peasant, whom Colonel W—— described as a wonder of youthful power and agility, seemed, on the contrary, not the least fatigued by his chase, nor vain of his achievement; but coolly looking about for his powder-horn and his dogs, did not expend a word on the past, except just to wink to Colonel W——, and say, ‘Now, master, don't forget the bottles.’


The sight of a fox-chase among these rocks must be magnificent,—now sweeping along their heights or sides,—now fox and hounds darting down the steep declivities, all suddenly vanishing like a shadowy picture in the gorges. Colonel W—— once saw such a one from **Hungry Hill**, in which the whole pack ran under the arch of the waterfall, while their cry mingled wildly with the roaring of the cataract, till at last Reynard experienced the same lot which had befallen three or four of the dogs; he slipped from the polished rock, and fell, amid shouts and halloos, from a height of several hundred feet into the midst of the hunters, who were looking on at their ease from the meadow below.


Shall I tell you any more stories?—Well, then, once more for witches and fairies: saddle me the poney, and away to the land of tales and legends; of the land-rocks, and the waves which for ages have fretted them away with their snow-white teeth.


Jump up behind me, Julia, ‘en croupe,’ like an Irish girl, and follow me quickly through the air, back to **Iveragh**, **O'Connell**'s wild region. Truly is it a land of the eagle and the vulture, of the stormy wave and the rugged rock! But there is a spot in **Ballinskellig bay**, not far from **O'Connell**'s Castle-abbey, where in old times many a dance was danced, and many a wedding celebrated. For peaceful and lovely was the lonely spot, with its velvet turf; its high walls of rock sheltered it from the storm, and sand smooth as satin edged the sea, which seemed to sleep, like the entire creation, in the clear moonlight, its little billows only lightly ruffled by the zephyr's breath, rolling and curling with a dreamy soothing motion.


### **Macroom**, October 5th, 1828

Dearest one,


The parting was hard; but you who wish me in a very different place, will say that I have staid quite long enough. I tore myself away from these excellent people and their romantic dwelling. It was Sunday; and



---

p.396



the worthy lady, in spite of her manifest regard for me, could not help exclaiming reproachfully, ‘But how is it possible that a good man like you can set out upon a journey on a Sunday?’ You know that the English have stamped this day with a sort of death-like character; dancing, music and singing are forbidden; indeed, the severely pious hang their canary-birds in some remote corners, that no voice of song may offend their ears during these holy hours. This idolatry of the Sunday began in the time of **James the First**, and was the cause of furious dissentions. No bread must be baked, and no useful work performed; but drunkenness and other vices thrive more luxuriantly than on the week-days. I have observed that the streets are never so bestrewed with drunken people as on Sunday evenings; nor, as is well known to the police, are the resorts of vice ever so filled. Many English people think dancing on a Sunday unquestionably a greater crime than a little theft or so; and I lately read in print a history of **Whitby**, in which it was seriously affirmed, that the rich abbey there was doubtless destroyed because the monks did not only indulge in every possible crime, rape and murder not excepted, but their sinful abbot had permitted the repairs of the abbey and other labours to go on on a Sabbath-day.


The worthy Mrs. W—— was infected with this same strange conceit; and it was somewhat difficult for me to excuse my half-committed sin on the ground of urgent necessity. To appease her, I went first with the whole family along the bay to B—— church, which was quite out of my way. In going along, I related to her the strange vision of one of the sons of my former excellent host, Captain B——, by which he had been induced to go over to the Catholic church. He was, as he himself told me, a most zealous Protestant and Orangeman, and went one day into a Catholic chapel in **Dublin**, rather with the intention of making himself merry at the ceremonies than from any better motive. But the beautiful music touched him against his will; and as he raised his eyes to the high altar, the Redeemer stood bodily before him, his eyes fixed intently on him with an expression of angelic mildness. The divine vision smiled upon him, beckoned with his hand, and then slowly ascended, still looking fixedly at him, till at length it disappeared, borne by angels through the dome. From this moment B—— was persuaded he was an especial object of the divine favour; and in a few days he became a member of *another* church which has the exclusive privilege of ensuring salvation, (for the orthodox English Protestants also believe that they enjoy this monopoly.) How philosophically did my pious friends reason on *this* conversion! ‘Is it possible!’ exclaimed they. ‘What superstition! Without doubt this was either a feverish delirium, or the man is a hypocrite, and has good reasons for what he does. Either he is mad, or he invented the story for his own profit.’


Oh, men, men! How justly does Christ say, ‘Ye behold the mote in the eye of another; ye cannot see the beam in your own!’ No doubt this is the case with us all, more or less; and be assured I make no exception in favour of your poor friend.


We parted at last, not without emotion; and I seated myself on a mountain car, drawn by a horse whose appearance was by no means brilliant. The young ladies were greatly delighted at my eccentric mode of travelling. The journey I had to accomplish was thirty miles, and began most tediously. After a little time the wretched horse was so restive at going up hill, that I was obliged to alight, rather than run the risk of being dashed 



---

p.397



down a precipice. The stubborn beast was now forced to be constantly led, without which he would not advance a single step. For a long while the driver trotted sturdily on by his side, but at length could go no further; and Heaven knows what would have become of us, had we not luckily met a man on horseback, who consented to harness in his horse instead of ours. I reached **Macroom** late in the evening. Nothing struck me much in the way but a long and deep glen, in which at the time of the White Boy conspiracies, Lord B—— and Colonel W—— were attacked by a party who were posted on the heights, and had a narrow escape for their lives. The **White Boys** had taken their measures extremely well, and during the night had loosened a great mass of rock, which they suddenly rolled down directly across the road through which the troops were marching. By this means the detachment of cavalry was not only prevented from advancing, but was cut off in its rear, and thus placed in a desperate situation. A great many were killed; the two gentlemen, who rode capital hunters, luckily escaped. Their good steeds climbed up the almost inaccessible side of a rock, amidst an incessant shower of musketry. Colonel W—— was slightly wounded in the right arm; Lord B—— escaped quite unhurt.


In this extremely wild region, not far from hence, lies a large lake with a woody island in its centre. Here stands a chapel of great sanctity, to which numerous pilgrimages are yearly made. It was too late for me to see it more nearly.


**Macroom** is a cheerful pretty place, with a handsome house belonging to the uncle of the beautiful African, or rather of her husband. She gave me a letter to him, but I had not time to use it.


### Cork, Oct. 6th


I left **Macroom** very early in a ‘gingle,’ a sort of covered stage with two horses. It rained and blew again; for, dear Julia, I find that I am no longer, as the Irish prettily say, ‘on the sunny side of life.’


My fellow-travellers were three women and a great cub of five years old, who made himself extremely disagreeable, and was horribly spoiled by his pretty and lively mamma. Although he had a great loaf, and a cake of similar dimensions, with which he was incessantly stuffing himself, and filling the coach with bits and crumbs, his ill humour broke out at every moment. The scream he then set up, and the stamping of his feet, which he often placed upon mine without the slightest reserve; the coaxings of the mother, and her cries for help to her husband on the outside; then her incessant prayers to ‘stop just a moment,’ because the poor little dear was ill with the motion of the coach, or because he was thirsty, or because something or other; her keeping the windows hermetically closed for fear he should catch cold, in spite of his furred coat;—it was really a trial of fortitude. The young woman seemed as anxious for herself as for her child; whenever the coach leaned a little on one side, she began to scream, and clung to me with both hands, taking me almost round the neck. This was the most endurable of my sufferings; and I often amused myself with increasing her fright. In the intervals she enlarged with great patriotism on the beauty of the country, pointed out to me the fine ruins, and told me their histories. At last she showed me a pointed and tower-like stone, and said that a Danish king had thrown this across the sea to show his strength. She would have her husband get down from the roof to admire this stone, and remarked to him with some 



---

p.398



contempt that the men now-a-days were miserable feeble pigmies compared to those giants. At the same time she gave him the boy to take beside him. The poor devil made a long face, pulled his nightcap over his ears, and quietly obeyed orders.


The country was now very fertile, full of rich meadows, with here and there a stately mansion. **Cork** lies most picturesquely in a deep valley on the sea-shore. It has an air of antiquity, which is rendered more peculiar by the roofs of scale-like slates with which many of the houses are covered. The two new prisons are magnificent buildings; they are erected, the one by the city, the other by the county: the former is in an antique taste, the latter in the perfectly Gothic style, and has the appearance of a great fortress.


After I had breakfasted, I hired what they call here a whale-boat, narrow and pointed at each end, and thence safer and swifter, and sailed with a fair wind along the bay, which is called the river of **Cork**, to **Cove**, where I intended to dine. A part of this bay, which is about three-quarters of a mile broad, forms one of the most beautiful harbours in the world. Both shores consist of high hills, covered with palaces, villas, country-seats, parks, and gardens. On either side, rising in unequal height, they form the richest and most varied boundary. By degrees the city advances into the middle of the picture, and terminates on the brow of the highest hill, with the imposing mass of the barracks. This is the view from the sea. Towards **Cove** it frequently changes, as the windings of the channel present objects in different positions. One of these pictures was finely bounded by a Gothic castle, which has been built with great good taste by the city on a bold projecting rock. Its admirable site not only gives it importance, but it appears, if I may so say, as if it grew there naturally; while buildings of this kind in ordinary situations so often strike one as unpleasant ‘hors d'oeuvres.’ Though I think we excel the English in the higher sorts of architecture, we are very deficient in attention to the objects and the scenery which surround our buildings; and yet these are the circumstances which ought generally to decide the style.


This castle seemed built for one of the sea-kings, for the only entrance is from the sea. A colossal gate, adorned with a coat of arms, beneath which the waves wash the steps, overarches the dark entry. I thought of **Folko** with the vulture's wings returning hither after a successful seafight; and peopled the deep with fantastic beings from **Fouqué**'s Magic Ring.


We sailed with a fair wind past **Passage**, a fishing village, and then past **Monkstown**, which takes its name from a ruin of a monastery in a wood above. The rain, which had ceased for a time, here began to fall again, but I was requited by a splendid effect. We turned, near the island of Arboul, into the narrow bay of **Cove**, which afforded a very beautiful view; its mouth is bounded on the left by a high coast, covered with houses and gardens; on the right by the rocky island I have just named, on which are situated a fort, marine buildings, and store-houses containing the ‘matériel’ for the naval service; before us, in the bay itself, lay several line-of-battle ships and frigates, and another convict ship at anchor; behind them arose the town of **Cove**, built in steps or terraces on the side of the mountain.


While all this was full in our view, the sun, now near its setting, broke forth from a flame-coloured spot in the heavens, below the rain clouds,



---

p.399



while a rainbow more perfect and deeply coloured than I ever remember to have seen, with both feet on the sea, spanned the entrance of the bay like a portal of flowers leading from earth to heaven. Within its gigantic arch appeared the sea and the ships, shaded from the surf's rays by a mountain behind us perfectly black; in contrast with which the evening glow resting on the lofty amphitheatre of **Cove**, shed such a glory that the sea-mews poised in it looked like glittering silver, and every window in the town, (which is spread out on the side of the hill,) gleamed like burnished gold. This indescribably beautiful scene not only lasted till we entered the bay, but just before we landed the rainbow doubled itself, each bow glowing in equal beauty of colour. We had hardly set foot on the shore when both disappeared almost instantaneously.


I now established myself very agreeably at the window of the little inn, in the hope of an excellent fast-day dinner of the most delicate fresh fish. No part of my scheme was verified but the fasting; not a fish, not an oyster was to be had. This happens oftener than you would think in the little fishing towns on the coast, every thing ‘disponible’ being immediately carried to the great cities. In this point of view therefore I attained my end but badly, and I was forced to content myself with the eternal ‘mutton-chops.’ However, I did not suffer this to disturb my equanimity. I read an old newspaper or two, not having seen one for a long time, and took my way homewards by land, when it was nearly dark. An open car, with a bundle of straw as a seat, was the only carriage I could get. The wind blew cold and gusty, and I was obliged to wrap myself closely in my cloak. We skirted the shore at a considerable elevation, and the numerous lights of the ships and marine buildings below us were like an illumination. Five flickering flames danced like Will-o'-the-wisps on the black convict ship, and the report of a cannon from the guard-ship thundered through the stillness of night.


As this view disappeared, I turned my eyes to the unusually clear firmament. Who can look intently on the sublime and holy beauty of those glittering worlds, and not be penetrated by the deepest and the sweetest emotions? They are the characters by which God has from all time spoken most clearly to the soul of man; and yet I had not thought of these heavenly lights so long as the earthly ones sparkled before me! But thus is it ever. When earth forsakes us, we seek heaven. Earth is nearer, and her authority more powerful with us; just as the peasant stands more in awe of the justice than of the king; the soldier fears the lieutenant more than the general; the courtier is more assiduous to please the favourite than the monarch; and lastly, the fanatic—but we won't philosophize further about it, dear Julia; for I need not repeat to you, ‘qu'il ne faut pas prendre le valet pour le roi.’


### **Mitchelstown**, October 9th.—Morning


At four o'clock yesterday afternoon I left **Cork** by the mail. I was seated by the coachman, whose four horses I occasionally drove. For about three miles from the city the country continues picturesque; it then became uninteresting, and soon it was too dark to distinguish. After a few stages we left most of our passengers, and I took my seat inside the coach, where I was destined to enjoy a three hours tête-à-tête with a lady,—unfortunately, however, she was seventy, and a Puritan. This *disagreeable* company, combined with the eulogies which a former travelling companion had pronounced on the newly built Gothic castle



---

p.400



at **Mitchelstown**, induced me to leave the mail in the middle of the night, and to stay here till the morrow. At seven o'clock I was waked to go to view this much lauded edifice. I was sorely disappointed, as were some other strangers who had been drawn hither by the same object. We were certainly shown a huge heap of stone which had cost its possessor 50,000*l.*; but one ingredient was unluckily forgotten,—good taste. The building is, in the first place, much too high for its extent; the style is confused without variety; the outline heavy, and the effect small, though the mass is great. It stands, too, on the bare turf, without the slightest picturesque break, which castles in the Gothic or kindred styles peculiarly need; and the inconsiderable park possessed neither a handsome group of trees nor a prospect worth describing.


I have thrown away so many words on this abortive work, because, from the name of its possessor, and the great cost of its erection, it enjoys a certain reputation in **Ireland**. Yet how infinitely preferable is the place of my excellent Colonel W——, on which perhaps an eighth part of the money has been spent.


The internal decorations of the castle are of a piece with its exterior: in five minutes we had quite enough of them, and as we heard of a fine prospect from the top of the tower, but the key was no where to be found, we all returned in no very good-humour to our inn. Here one of the strangers entertained me during breakfast with all sorts of interesting stories of this part of the country and its inhabitants. He told me among other things, that Lord K—— and his family had been remarkable for their very extraordinary adventures. He is now one of the most zealous **Orangemen**, and is rather feared than loved. His father, when just twelve years old, was married to the heiress of the whole property now possessed by the family, who was just ten. The tutor and governess received the strictest injunctions to watch the young couple most narrowly, and to prevent every possibility of a tête-à-tête. But somehow or other, as my informant said, three years afterwards they found means to elude their vigilance, and the present Lord was the result of this little ‘equipée.’ They had afterwards several children, of whom I happened to know one at **Vienna**. He was a remarkably handsome man, and celebrated for his ‘bonnes fortunes;’ at one time the avowed lover of the Duchess of ——, whom he treated with so little ceremony, that once when he invited me to breakfast at the hotel where they were living, I found the Duchess alone, and he came into the room some time after, in dressing gown and slippers, out of his or their chamber.


The youngest child grew up to be one of the most attractive girls in **Ireland**. She was just sixteen when a cousin on the mother's side, a married man, named F——, who then enjoyed the greatest celebrity as a resistless seducer, fell in love with her, and confirmed his reputation in so conspicuous a manner, that he actually brought this beautiful girl, the idolized daughter of an earl, not only to sacrifice her innocence to him, but to accompany him to **England** as his avowed mistress. Here they lived for a year, at first in concealment; but at last he had the effrontery to take her to one of the most frequented watering-places. Her abode was of course discovered, and she was carried off at her father's command, and placed in safe custody in the north of **England**. F——, perhaps only irritated by the resistance of the family, determined, let it cost what it would, to get her again into his power; and as he thought she had been taken to her father's residence, he hurried off to



---

p.401


**Ireland** in disguise. Here he lodged in the very inn in which we were breakfasting, and endeavoured to discover the place of her concealment. His minute inquiries, his mysterious behaviour, and the unlucky accident that a former acquaintance of his met him and remarked that he never saw a greater resemblance than between this stranger and the notorious F——, awakened the suspicions of the host, who immediately went to impart them to Lord K——. The Earl received the communication with perfect apparent indifference, and only enjoined on the informer absolute secrecy. He then asked at what hour the stranger generally rose; learned that it was never before eight: dismissed the host with a present,—and added, that he would examine into the matter himself at six o'clock the next morning, at which hour he desired him to expect him, and to be quite alone. Morning came; and with it, punctually, the Earl. Without any further inquiry he went up stairs accompanied by the host, and desired the stranger's servant to open his master's door instantly. The man refused; on which he broke open the door with his foot, walked up to the bed in which F——, awakened by the noise, had just raised himself, looked intently at him; and as soon as he had satisfied himself of his identity, drew a pistol from his pocket, and with perfect coolness blew out the brains of this modern Don Juan, who sank back in the bed without a groan. The sequel proves how lightly the laws sit on great men in **England**, when there is not a still greater who has an interest in putting them in force. Lord K—— was, indeed, brought to trial; but as he had taken good care to arrange the affair with the only two witnesses, and to get them out of the way, he was acquitted for want of evidence. No man in **England** can be tried twice for the same offence; so that from this moment, in spite of the perfect notoriety of the murder, all danger to the murderer was at an end. The unhappy girl soon after disappeared,—it was reported, died. Lord K—— long survived her; and at a very late period of his life was famed for the beauty of his mistresses, one of whom inhabited each of his seats. The consequences of this depravity, at length, was a separation from his wife, and the bitter hostility and litigation which subsisted between them till his death. Meanwhile his eldest son, the present Earl, had married, while yet a minor, in **Sicily**; had already three children by his young wife, and lived completely separated from his country; when suddenly he received a most affectionate invitation from his father, who promised to forget and forgive the past. He was induced by this to set out for **Ireland** with all his family. Scarcely was he returned, when his father employed all his influence to get the marriage annulled. The young mother was sent home; and the children, declared illegitimate, were disposed of in **England**. The son, contrary to all expectation, seems to have given in to his father's schemes without much difficulty, and soon after married a rich heiress. After his father's death he carried on a still fiercer lawsuit with his mother than his father had done, in order to get possession of an estate which she refused him. In this, however, he could not accomplish his end; nor could she at a later period obtain hers, which was to disinherit him entirely.


Here is a picture of the manners of the great and noble of the eighteenth century.


### **Cashel**.—Evening


My communicative friend travelled on with me to **Cashel**. The weather



---

p.402



was tolerable,—that is, it did not rain, and that was sufficient in this watery land to set my worthy Irishman repeatedly exclaiming, ‘What a delightful day!’ ‘What lovely weather!’—I proposed to go a part of the way on foot; on which a tall lad of eighteen, ragged ‘comme de raison,’ offered himself as guide. He walked with great difficulty in a sort of slippers, and appeared to have wounded his feet. I asked him if that was the case: ‘Oh no,’ said he, ‘it's only the shoes I've put on, because I'm going to be a soldier, and must get used to wearing shoes: but the things are such a plague that I can't get on with them at all.’


After my usual fashion of disdaining no sources of information,—by which means I often glean some ears from conversation even with the lowest,—I made inquiries of my guide as to the present state of his country. ‘Yes,’ said he, ‘it's quiet enough here at present, but in **Tipperary**, which we shall soon come to, especially off to the north, they know how to stand against the **Orangemen**: **O'Connell** and the **Association** have organized us there, like regular troops: I belong to them, and I have a uniform at home: if you saw me in it, you'd hardly know me;—three weeks ago we all met there, above 40,000 men, to be reviewed. We had all green jackets, (for every man must get one as well as he can,) with an inscription on the arm—King George and **O'Connell**. We have chosen our own officers; they drill us, and we can march and wheel already like the redcoats. We had no arms to be sure, but they could be had too if **O'Connell** chose. We had flags, and whoever deserted them or got drunk, we threw into the water till he was sober again: but that very seldom happened.—They call us **O'Connell's Militia**.’


The Government has since prudently forbidden this military display; and my promising citizen-soldier was furious against Lord K——, who had arrested all his tenants (little farmers who are as dependent on their lords as serfs) who were present at the review. ‘But,’ added he, ‘every hour that they sit in prison shall be paid by their tyrants, whom we had rather see dead than alive;—if they in **Cork** here were not such tame sheep! In **Tipperary** they would have settled his business long ago: **O'Connell** never comes here, even when it's his nearest way, for he cannot endure the sight of K——.’


This is the spirit of party every where at work! and so well informed is this nation of beggars as to the state of their affairs!


The journey to **Cahir** was not very interesting. The road lies between two chains of mountains, the **Galtees** and the **Knockmildown mountains**; but as the wide plain between them affords little wood or variety of objects, the view is not agreeable. My travelling companion pointed out the highest peak of the **Galtees**, where the most renowned sportsman of the neighbourhood was buried with his dog and his gun. Not far from thence are subterranean caverns, of unfathomable extent, full of stalactites. They are accessible only in the hottest weather; at all other seasons they are filled with water.


In **Cahir** there is a beautiful park belonging to **Lord Glengall**, who furnished the **London** caricaturists and the public with so much amusement last year. At the entrance is an imposing ruined castle of King John's, on whose tower **Lord Glengall**'s banner is now flying. At the other end



---

p.403



of the park is the contrast to this ruin, namely, a ‘cottage ornée’, in which the possessor resides when he is here. The situation of this cottage is so charming and so well chosen that it deserves a fuller description. The whole park, beginning with the town and King John's castle, consists of a long and narrow valley, with a river flowing through meadows. Along these, clumps of trees and little thickets are beautifully scattered, and a path leads on each side of the river. The mountain ridges which close the valley are completely clothed with wood, through which the paths are cut. Near the end of the park, which is about three miles long, the glen opens and discloses a beautiful view of the higher **Galtees**. But before you reach this point there is a long isolated hill, directly in the middle of the valley, rising from the meadow-land. On this side is built the cottage, more than two-thirds hidden by the wood which clothes the whole hill. Within this wood is situated the ‘pleasure-ground’ and gardens of various sorts, with flowery walks which command the loveliest views of the valley on either side. Several ruins of castles and monasteries are visible on the distant mountains; but in the immediate neighbourhood all is repose, rural quiet, and the gay beauty of flowers even in winter.


On my return to dinner, the landlord told me, as a great piece of news, that the carriage and servants of a foreign prince had been waiting for him in **Cashel** for the last fortnight; but that he was gone on a secret journey to **O'Connell**, and that the whole country was in a stir and wonderment about it.


Many thought he was sent by the King of **France**, with secret propositions to **O'Connell**; some had actually seen him in **Limerick**, and maintained that he was a son of **Napoleon**.


While my host was uttering this and more nonsense of the like kind, not suspecting that he was talking to the ‘personage’ himself, who had just dismounted from a car; he announced that the second car, (the only carriage to be got,) was ready, and waited my orders. I set out, and had soon an opportunity of making fresh philosophical observations on the power of habit in the beast that drew me. He was a very good and willing animal; but as soon as he reached the place where for fifteen years he had been accustomed to be led to water, he suddenly stopped, and fire would not have moved him till he had had his drink. After that he needed no driving; but he repeated the same manoeuvre when we met a return car, on which occasions it is usual to stop and exchange information. As if suddenly struck lame, he drew up and stood stock still; as soon as the drivers had shaken hands over his back he instantly went on of his own accord. This is really the great secret in the education of man or beast,—habit, ‘voilà tout.’ The Chinese are a glorious example of this. I remember that once in **London**, the well-known ambassador of a great nation tried at great length to convince me that the Chinese form of government was the best and most efficient, because there every thing remained unaltered: ‘C'est plus commode pour ceux qui regnent, il n'y a pas de doute.’


About seven I reached **Cashel**, having passed the **Suir**, a river which is called the flower of **Ireland**, because the richest pastures and the most beautiful seats lie on its banks. I found a terrible tumult in the inn,—one of the liberal ‘Clubs’ were having a meeting and a dinner. I had



---

p.404



hardly taken possession of my room, when the president, in propria persona, and a deputation, came to invite me to their dinner. I entreated them to excuse me, on the ground of the fatigue of my journey and a violent head-ache, but promised to come in at the dessert, for indeed I was curious to see what was going forward. The club was instituted with an admirable purpose;—it consisted of Catholics and Protestants, who proposed to unite their efforts to reconcile the parties, and to co-operate with all their might to obtain emancipation. When I entered, I found from eighty to a hundred persons sitting at a long table; they all stood up while the president led me to the top. I thanked them; upon which they drank my health, and I was again forced to reply. Innumerable other toasts followed, all accompanied by speeches. The eloquence of the speakers was not very remarkable, and the same common-places were served up over and over again in different words. In half an hour I seized a favourable moment to take my leave.—Forgive me, for I was very tired.


I have not heard any thing from you for a long time, and must wait for letters till I get to **Dublin**. Only be well,—that is the main thing for you; and don't cease to love me, for that is the main thing for me.


Your faithful

 L——
### **Cashel**, Oct. 10th, 1828;

Dear and kind friend,


The Rock of Cashel, with its celebrated noble ruin is one of the greatest lions of **Ireland**, and was mentioned to me by **Walter Scott** himself as the most worth visiting after the Abbey of **Holy Cross**. It is a rock standing isolated in the midst of the plain. It is odd enough, that in one of the distant mountains there is a cavity of just the same size as the rock:—according to the legend, the devil bit it out in a rage at losing a soul he was carrying off to hell. As he flew over **Cashel** he spit the bit out again. Upon this rock M'Cormack, king and archbishop of **Cashel**, built a castle and a chapel, which are both in remarkable preservation.


In the twelfth century, I think, **Donald O'Brien** added the church and abbey. The whole forms a most magnificent ruin, in which all the details of Saxon architecture may be studied in the most interesting manner. This has been greatly facilitated by the labours of the son-in-law of the present archbishop, **Dr. Cotton**, who some months ago had M'Cormack's chapel entirely cleared of the accumulations of dirt and rubbish, and has, at considerable expense, rendered the whole ruin accessible. Nothing can be more strange,—I might say, more barbarically elegant,—than these grotesque, fantastic, but often admirably executed ornaments. Many sarcophagi and monuments found buried under rubbish or earth, suggests curious and interesting speculations. One is tempted to think that the frightful images, like Indian idols, must have belonged to some earlier religion, did we not know how slowly Paganism gave way to Christianity, how obstinately it still lingers. I have in my possession a little bell, which one of my ancestors brought with him from the prisons of the Inquisition, and on which the Virgin is surrounded with apes instead of angels, some playing the violin, while others are making somersets in the clouds!




---

p.405


I examined the whole ruin minutely, and climbed to the highest accessible point just as the sun was setting over the **Devil's Bite**. The archbishop had had the kindness to send his librarian to show me the ruin. From this gentleman I learned that the celebrated and often cited Psalter, written in the Irish language, which is mentioned in every Traveller's Guide as the standing wonder of **Cashel**, is a mere fable; at least, that no such thing was ever known to exist here. This interested me little; but I was really alarmed at hearing that the Catholics entertain the idea of restoring and rebuilding the church, if they could get possession of the ground. Heaven preserve the sacred ruin from their pious designs! On a plain in front of the church stands an extremely ancient and mutilated statue of **St. Patrick**, on a pedestal of granite. Near this was formerly to be seen the coronation-seat, said to have been brought from Portugal hither, and afterwards sent to the coronation of the Scottish king, Fergus, at Scone, whence Edward I. brought it to Westminster-abbey, where it now is.


At the foot of the **Rock of Cashel** stand the very curious ruins of **Hore Abbey**, which, it is asserted, were formerly connected with the castle by subterranean passages. The beautiful proportions and perfect ornaments of a great window are particularly striking.


### October 11th


One of the gentlemen whose acquaintance I made yesterday, a man of good family and engaging manners, offered me his horse to visit the ruins of the Abbey of **Athassil**, and the park and seat of the wealthy **Earl of **Llandaff****. The excellent hunters soon carried us to the spot: the object, however, was not equal to my expectations. The abbey is certainly a beautiful and extensive ruin; but its situation, in a bog surrounded by ploughed fields without tree or shrub, is so unfavourable as to deprive it of all picturesque effect. **Lord Llandaff**'s park is likewise of great extent, two thousand eight hundred acres, but has no distinguishing beauties. The trees are not fine, water almost entirely wanting, and the modern Gothic house, painted light blue, appear to me hideous. The possessor is a still handsome and interesting man of seventy, who has the great, and in **Ireland** the rare merit of residing on his property. We found a person who is distinguished in society by the foreign polish of his manners, in the character of a plain farmer, in marsh-boots and water-proof cloak, standing in the rain directing his labourers. This pleased me greatly, for reasons you can guess.


On our return, Captain S—— gave me a great many interesting details respecting the really atrocious and crying injustice and oppression under which the Irish Catholics labour: it is more intolerable than that which the Greeks suffer from their Turkish masters. The Catholics are not allowed to call their places of worship churches, only chapels; they must have no bells in them,—things inconsiderable in themselves, but degrading and insulting in their intent. No Catholic can, as you know, sit in Parliament, nor be general in the army, minister of state, judge, &c. Their priests cannot perform the ceremony of marriage, in cases where one party is Protestant, and their titles are not recognised by the law. The most scandalous thing however is, that the Catholics are forced to pay enormous sums to the Protestant clergy, while they have entirely to



---

p.406



maintain their own, of whom the state takes no notice. This is manifestly one great cause of the incredible poverty of the people. How intolerable must it appear in a country like **Ireland**, where more than two-thirds of the whole population are most zealously devoted to the Catholic religion!


In the South the proportion is much larger. In the county of **Tipperary** there are about 400,000 Catholics, and only 10,000 Protestants: nevertheless, the Protestant clergy costs the inhabitants the following sums yearly:




|  |  |
| --- | --- |
| The Archbishop | £25,000 |
| The Dean | 4,000 |
| For about 50 parishes, on average, each | 1,500 |





which charge, of course, falls mainly on the Catholics. Most of the parsons do not even live in **Ireland**, but put some poor devil with a salary of £50 or £60 a year to perform their duties: these are the far-famed curates: the duties are indeed soon performed, as there are parishes which do not contain more than ten Protestants; and, indeed, there is one in, this neighbourhood in which *not one* is to be found; and not even a church,—only an old ruin, in which the ‘farce’ of divine worship is once a year acted to empty walls, during which a Catholic, hired for the occasion, performs the office of clerk! Meanwhile, the clergy are year after year wearing away the pavement of **London** and **Paris**, and living as unspiritual a life as possible. I lately read in an English newspaper, that a clergyman in **Boulogne** had lost a large sum at play; that an affair had ensued in which he had shot his antagonist, and had been obliged immediately to quit the place and *return to his living.* Even the higher clergy, who must at least reside at certain stated periods in their episcopal and archiepiscopal sees, suffer none of their ill-gotten gains, (for what else can money so acquired be called?) to return back again to the poor people from whom they have wrung it, but save all they can, that they may enrich their families.


Can anybody wonder that such institutions have frequently goaded the unhappy people to despair and rebellion? and yet at every struggle their chains are riveted tighter, and eat more deeply into the bleeding flesh. Wherever you see a beautiful estate and fertile land, if you ask who is the proprietor, you are generally told ‘It is forfeited land,’ once belonging to Catholics, now to Protestants. **O'Connell** told me, that not long ago a law was in force, ordaining that no Catholic should hold landed property in **Ireland**; and if a Protestant could prove before a court of justice that this was in any instance the case, the property was taken from the Catholic and given to him: the only remedy lay in a feigned conversion. But in spite of this bounty on hypocrisy and deceit, land to the value of millions of pounds was transferred into the hands of Protestants by this atrocious process. Is it not marvellous that Protestants, who in a barbarous age severed themselves from the Romish church on account of her intolerance and rapacity, should now, in an enlightened one, cherish the very same vices,—thus incurring a far greater comparative load of guilt than they would have had to bear before. Will this monstrosity, the offspring of despotism and hypocrisy, which has so long been nourished by the tears and blood of the world, never be destroyed by more enlightened generations! If ever it is, they will look back upon us with the same sort of pity as we do upon the darkness of the middle ages.




---

p.407


In the afternoon I visited the Catholic dean, an extremely agreeable man, who lived a long time on the continent, and was chaplain to the late Pope. His frank and enlightened conversation excited my surprise; for we are accustomed to think that every Catholic must of necessity be a superstitious bigot. Among other things, he said to me, ‘Believe me, this country is devoted to misfortune. We have scarcely such a thing as a Christian among us: Catholics and Protestants have one common religion—that of hatred.’


Some time afterwards, Captain S—— brought me the latest newspaper, in which my visit to the meeting was mentioned: the few words I said there, and the other speeches, were dressed up with the accustomed charlatanerie, and filled three or four columns of the paper. To give you a specimen of this ‘genre,’ and at the same time to cut a figure in your eyes by my eloquence, I translate the beginning of the article, in which I am puffed in the same style as that in which a quack doctor sets forth the unparalleled virtues of his pills, or a horse-dealer those of his horses:—listen.


‘As soon as the arrival of the * * * * was known, the president, accompanied by a deputation, repaired to his apartment, to invite him to honour our feast with his presence. Shortly afterwards, the * * * * entered the room. His air is ‘commanding and graceful.’ He wore moustaches, and although very pale, his countenance is ‘exceedingly pleasing and expressive.’ He took his seat at the upper end of the table, and, bowing to the company, spoke distinctly and ‘with proper emphasis,’ though with a foreign accent, the following words: ‘Gentlemen, Although ill and very tired, I feel myself too much flattered by your kind invitation not to accept it with thanks, and to express to you personally the lively interest I take in your struggles on behalf of your country. May God bless this beautiful and richly-gifted land! which offers to every foreigner such manifold enjoyments; but in which I, especially, have reason to acknowledge with the deepest gratitude, the kindness and hospitality which I have every where experienced. May Heaven, I repeat, bless this sorely-tried country, and every true Irishman, whether Catholic or Protestant, who desires the welfare not of any exclusive sect or party, but of **Ireland**!—a welfare that can be attained only by peace, forbearance, and ‘civil and religious liberty,’ (a standing phrase in these islands.) Gentlemen, fill your glasses and allow me to give you a toast: ‘The King, and Erin go bragh!’ (This is the old Irish motto, which is on the medal of the order of the Liberator, and signifies ‘Erin for ever!’)’’


The President:—‘Gentlemen, I beg you to participate in my feelings, and to receive the expression of them from me. May our ‘illustrious guest,’ to whose health we now fill our glasses, if ever he return among us,—find us in the enjoyment of equal laws and equal privileges, and in the possession of that internal tranquillity which alone we have combined to obtain. Three times three:—The ‘* * * *.’’ I repeated my thanks for the honour done me, and added, ‘That nothing could make me happier than to be an eye-witness of the fulfilment of their and my wishes, in a country which I loved as my own, and quitted with extreme regret.’


Now, dear Julia, what do you think of me? Cannot I string common-places as well as another upon occasion? What is no common-place, though reiterated at the end of every one of my letters, is, the assurance of the tender affection with which I am, and ever shall be,


Your Friend

 L——.


---

p.408


### **Cashel**, Oct. 12th, 1828;

Dearest friend,


Why do I like so much to write to you? Certainly because it gives you pleasure to hear from me from afar: but also, because you understand me, which nobody else does. This alone would suffice to enchain me to you for ever, for I live *in* the world, but *with* you alone,—as much alone, as if we were on a desert island. Thousands of beings swarm around me, but I can speak only with you. If I attempt it with others, my habit and disposition, always to speak the truth, often cost me dear; or I blunder in some way or other. Worldly wisdom is as decidedly and unattainably denied to my nature, as to the swan—who in winter waddles clumsily across the frozen lake before your window—the power of running races with the sledges that glide over it. However, his time too comes, when he cleaves his own free and beautiful element, or sails through the blue aether. Then he is himself again.


But back to **Cashel**.—I used my good friend's horses, which daily stand at my disposal, for a second excursion to the ruins of **Holy Cross**, six miles off, the worthy rival of the **Devil's Rock**. We amused ourselves by riding across the country, and leaping some stone enclosures; and reached a height from which ‘The Rock,’ as it is here briefly called, presents the most imposing aspect. The circle of distant blue mountains encircling the rock, which stands alone in the midst of the fruitful plain; the castle, abbey, and cathedral,—which, forming a majestic group, look down from the summit, and in silent and sublime language relate the history of successive ages; lastly, the town at its foot, so wretched, although the seat of two archbishops, (a Protestant and a Catholic,) and which also tells its own mute but intelligible tale concerning the present times,—combine to awaken varied and contradictory emotions.


**Holy Cross** is of a totally different character.— **Cashel** stands in solitary grandeur, all rock and stone, barren and black, with only here and there a straggling ivy-branch creeping feebly through a crevice. **Holy Cross**, on the contrary, lies in a valley on the banks of the **Suir**, buried in copsewood, and clothed with ivy of such luxuriant growth that hardly a wall can be seen: and even the lofty cross, the last which still remains standing, is so enwreathed with it, that it seems as if it clung fondly to shelter it from every profane touch. The interior is magnificent, and contains the beautiful monument of **Donough O'Brien**, king of **Limerick**, who founded this abbey in the twelfth century; and a canopy, exquisitely carved in stone, under which repose the ashes of the abbots, both in perfect preservation. The view from the tower is beautiful. You are very near the **Devil's Bite**, whose grotesque form is too striking not to have furnished matter for legends to the Irish, who have a story ready fitted to every extraordinary natural object.


We hastened back sooner than I wished, in consequence of an invitation



---

p.409



I had received from the Catholic dean to meet the archbishop and sixteen other clergymen at dinner: no layman but myself was invited. The table did honour to a chaplain of the Holy Father. ‘You never were at a dinner, I dare say,’ said the archbishop to me, ‘at which all the guests were clerical.’ ‘Yes, indeed, my lord,’ replied I; ‘and what is more, I myself was a sort of bishop a little while ago.’ ‘How is that possible?’ said he, surprised. I explained to him, that I [*gap: deleted/extent: a line*] ‘We are, therefore,’ said I, ‘eighteen priests here *assembled*; and I can assure you, that I make no distinction between Catholics and Protestants;—that I see in both only Christians.’


The conversation then turned on religious subjects, and was in a perfectly free and impartial spirit. Never did I perceive the least trace of bigotry or of the disgusting affectation of puritanical rigour. At the dessert, several sang their national songs, some of which had no pretension to sanctity. As the one who sat next me remarked some little surprise on my countenance, he said in my ear, ‘Here we forget the foreign * * * *, the archbishop, and the priest,;—at table, we are only gentlemen, and meet to enjoy ourselves.’ This man was the undisputed descendant of an Irish royal line; and although no trace of it remained about him, he was not the less proud of it. ‘I have a strange abode for a clergyman,’ said he; ‘if ever you visit **Ireland** again, I hope you will allow me the pleasure of doing the honours of it to you. It lies immediately under the **Devil's Bite**, and a finer view than this same Bite commands does not exist in all **Ireland**.’ He afterwards remarked, that to be a Catholic in this country is almost a proof of noble blood: as only the new families are Protestant, the Catholics must of necessity be the old ones; for since the reformation *they* have made no proselytes.


The melodies which were sung had a striking resemblance to those of the Wendish nations. This is one of the many features of similarity which strike me between those nations and the Irish. Both manufacture, and have an exclusive taste for, spirit distilled from corn; both live almost entirely on potatoes; both have the bagpipe; both are passionate lovers of singing and dancing, and yet their national airs are of a melancholy character; both are oppressed by a foreign nation, and speak a gradually expiring language, which is rich and poetical, though possessed of no literature; both honour the descendants of their ancient princes, and cherish the principle that what is not renounced is not utterly lost; both are superstitious, cunning, and greatly given to exaggeration; rebellious where they can, but somewhat cringing to decided and established power; both *like* to go ragged, even when they have the means of dressing better; and lastly, spite of their miserable living, both are capable of great exertion, though they prefer indolence and loitering; and both alike enjoy a fertile soil, which the Wendish phrase calls ‘the roast meat of poor people.’ The better qualities which distinguish the Irish are theirs alone.


I took advantage of the acquaintance I made to-day, to gain more information respecting the actual proportion in number between Catholics and Protestants. I found all I had heard fully confirmed, and have gained some further details: among others, the official list of a part of the present parishes and livings in the diocese of **Cashel**, which is too remarkable not to send it to you, though the matter is somewhat dry, and seems almost too pedantic for our correspondence.




---

p.410





| *Parish* | Catholics | Protestants[1](javascript:footNote('T820002-001/note001.html')) |
| --- | --- | --- |
| **Thurles** has | 12,000 | 250 |
| **Cashel** | 11,000 | 700 |
| **Clonoughty** | 5,142 | 82 |
| **Cappawhyte** | 2,800 | 76 |
| **Killenaule** | 7,040 | 514 |
| **Boherlahan** | 5,000 | 25 |
| **Feathard** | 7,600 | 400 |
| **Kilcummin** | 2,400 | — |
| **Mickarty** | 7,000 | 80 |
| **Golden** | 4,000 | 120 |
| **Anacarty** | 4,000 | 12 |
| **Doniskeath** | 5,700 | 90 |
| **New Erin** | 4,500 | 30 |






In thirteen districts, 78,182 Catholics and 2,379 Protestants.


Each of these districts has only one Catholic priest, but often four or five Protestant clergymen; so that, on an average, there are scarcely twenty persons to each Protestant congregation. **Kilcummin** is the place I mentioned to you where there is not a single parishioner, and the service, which according to law must be performed once a year, is enacted in the ruin with the help of a Catholic clerk. In another, called **Tollarnane**, the same farce takes place. But not a whit the less must the non-attending parishioners pay the uttermost farthing of their tithes and other dues; and no claims are so bitterly enforced as those of this Christian church:—there is no pity, at least none for Catholics. A man who cannot pay the rent of the church-land he farms, or his tithes to the parson, inevitably sees his cow and his pig sold, (furniture, bed, &c. he has long lost,) and himself, his wife, and probably a dozen children, (‘car rien n'engendre comme les pommes de terre et la misère,’) thrust out into the road, where he is left to the mercy of that Providence who feeds the fowls of the air and clothes the lilies of the field. ‘Quelle excellente chose qu'une religion d'état!’ So long as such exist, and every individual is not permitted, as in the **United States**, to worship God in his own way, without any civil disability or loss,—so long the age of barbarism has not ceased. The time must come when in the state, as in nature, laws alone must rule. Religion will then be left to her appropriate functions: she will console us in misfortune, and heighten our pleasures; but she will cease to wield the sceptre or the sword. The laws alone should employ inflexible restraint; opinion should enjoy unbounded freedom. The civilized portion of mankind have a right to demand this at the stage to which they have attained, and to which they have fought their way through so much suffering and blood. What frantic folly, to want to prescribe to men what is to become of them after death, or what they shall believe about it! It is bad enough that here on earth the best institutions, the wisest laws, must ever be defective;—let the invisible future at least shape itself out to every mind according to that mind's power and comprehension! And yet have great and wise and good men thought themselves justified in exercising this sort of despotism. But such is human frailty! the same individual will prove himself sublime in eleven things, and in the twelfth think and act like an idiot.


While **Cardinal Richelieu** afforded to all succeeding ages the model of a great and sagacious minister, his chief solicitude was to be thought a good poet; and he tortured himself to write wretched tragedies, which after his death were waste paper. The great **Louis**, who might be called



---

p.411



the absolute king ‘par excellence,’ seriously exclaimed after the battle of **Malplaquet**, ‘Et Dieu, a-t-il donc oublié ce que j'ai fait pour lui?’ **Cromwell**, at once an enthusiast and the most audacious and most cunning of dissemblers, after heaping murder on murder and violence on violence, found his conscience tranquillized, when in answer to his interrogatories a clergyman assured him, that a man who had once felt assured of the motions of grace within him, must be eternally blessed, let him have done what he would. ‘Then I am saved,’ cried the Protector joyfully, ‘for I know to a certainty that once, at least, I felt myself in a state of grace.’ Such are men! and *therefore* is it that human authority will never have weight with me, when it is not confirmed by my own judgment, exercised to the best of my power after mature reflection. Nay, were even all mankind opposed to me, it could not alter an opinion so formed. Thank God! we are all individual minds, and not sheep who must follow one leader. And what is universal opinion? One is tempted to think it is only another name for universal error, so frequently does it alter. It seems to depend only on time and place. If you are born in **Constantinople** you swear by Mahomet;, in the rest of Europe by Moses or Christ; in India, by Brama. Had you come into the world a subject of Augustus, you would have been a Pagan. In the Middle Ages you would have advocated fist-law (Faust-recht;) and now you clamour for the liberty of the press, as the one thing without which it is impossible to exist. You yourself, in the course of your short life,—how different is your being! how different your modes of thinking, as a child, as a youth, as an old man! **Herder** was right when he said, ‘No two drops of water are alike,—and yet you would give to all mankind the same belief!’ We might add, No atom remains unchanged, and you would bid the human mind stand still!


Before the archbishop retired, he said to me in a most obliging manner, ‘You are, as you tell us, a bishop, consequently you owe obedience to the archbishop. I employ this my authority to command you to dine here to-morrow with your colleague the Bishop of **Limerick**, whom we expect to-day;—I must hear of no excuse.’ I answered, taking up the jest, ‘I readily confess that it does not beseem me to withstand the discipline of the Church, and Your Grace and the Dean know so well how to sweeten obedience, that I submit the more willingly.’


I passed the evening in the society of the * * *. I have seldom found Protestant clergymen so frank and sincere as these Catholics. We came to the conclusion, that we must either receive blindly the hereditary faith the Church prescribes; or, if this be not in our power, from our own religious system as the result of individual thoughts and individual feelings,—which may rightly be called the religion of philosophers. The * * * spoke French most fluently, I therefore quote his own words: ‘Heureusement on peut en quelque sorte combiner l'un et l'autre; car, au bout du compte, il faut une religion positive au peuple.’ ‘Et dites surtout,’



---

p.412



replied I, ‘qu'il en faut une aux rois et aux prêtres; car aux uns elle fournit le 'par la grâce de Dieu, et aux autres, de la puissance, des honneurs, et des richesses; le *peuple* se contenterait, peut-être, de bonnes lois et d'un gouvernement libre.’ ‘Ah,’ interrupted he, ‘you think like **Voltaire**,’
  

*Les prêtres ne sont pas ce qu'un vain peuple pense,
  

 Et sa crédulité fait toute notre science.’’*

(Voltaire, Oedipe)


  

 ‘Ma foi,’ said I, ‘si tous les prêtres vous ressemblaient je penserais bien autrement.’


### October, 13th: Evening


I was unfortunately unable to keep my word with my friendly Amphitryon. A ‘megrim’ confined me all day to my bed. The archbishop sent me word that he would cure me; and, if I would but bring firm faith, would be sure to drive away the headache-fiend by a well-applied exorcism. I was, however, obliged to reply, that this devil was one of the most tractable, and that he respected no one but Nature, who sends and recalls him at her pleasure, which, alas! is seldom in less than four-and-twenty hours. I must therefore cut off even you, dearest Julia, with a few words.


### October 14th


‘Après la pluie le soleil!’ This day has indemnified me for the last. I was on horseback by six o'clock, on my way to breakfast at Captain S——'s country-house, where the sportsmen were to rendezvous for a hare-hunt. I found six or seven sturdy squires assembled: they do not think much, but their life is all the more gay and careless. After we had eaten and drank the most heterogeneous things,—coffee, tea, whiskey, wine, eggs, beef-steaks, honey, mutton-kidneys, cakes, and bread and butter, one after another,—the company seated themselves on two large cars, and took the direction of the **Galtee mountains**; where, at a distance of about eight miles, the hounds and horses were waiting for us. The weather was fine, and the ride very pleasant, along a ridge of hills commanding a full view of the fruitful plain, enclosed by mountains and richly varied by a multitude of gentlemen's seats and ruins which are scattered over the whole level country. I enjoyed these beauties, as usual, alone; my companions had only dogs and horses in their heads. A spot was pointed out to me where a strange phenomenon took place ten years ago. A bog which lay at a considerable elevation, forced up probably by subterranean springs, was completely loosened from its bottom, and travelled on in a mass, sixteen feet high and three or four acres in extent. It moved on in a continual zigzag, according to the nature of the objects it encountered; and thus passed over a distance of nine miles till it reached the nearest river, into which it slowly discharged itself, causing an overflow of the waters. The rate of its progress was about three miles an hour. It laid waste every thing in its course. Houses were levelled with the earth at its touch; trees torn up at once by the roots; the fields completely covered, and the valleys filled with bog. An immense multitude had assembled at the end of its course, without the power of offering the slightest resistance to the progress of this awful and majestic phenomenon.


On our arrival at the appointed place of meeting, the horses were there, but no dogs. There were, however, a great many gentlemen, and instead



---

p.413



of hunting hares we now all traversed the fields in every direction in search of the stray hounds. The sort of riding on these occasions is a thing of which people in our country can form no idea. Although most of the fields are enclosed by stone hedges from three to six feet high, and either piled loosely together or regularly cemented, and some of them edged by ditches; or strong walls of earth and stones pointed at the top, from five to seven feet high, with a ditch on one, sometimes on both sides;—all this is not admitted as any pretext whatever for the riders to deviate from a straight line. If I mistake not, I have already described to you how wonderfully the horses here leap; the sagacity is also admirable with which they distinguish a loose hedge from a firm one; one recently thrown up, from one hardened by time. The loose ones they spring over at one leap,— ‘clear them,’ according to the technical expression; but they take the firm ones more easily, making a sort of halt at the top. All this takes place equally well in a full gallop, or, with the utmost coolness, at a foot pace, or with a very short run. Some gentlemen fell, but were only laughed at; for a man who does not break his neck on the spot must look for no pity, but on the contrary, ridicule. Others dismounted at very bad places, and their docile steeds leaped without them, and then stood still, grazing while their riders climbed over. I can assure you I very often thought I should be compelled to follow their example; but Captain S——, who knew the excellent horse on which he had mounted me, and was always by my side, encouraged me to trust with perfect security to the admirable creature; so that at the end of the day I had acquired a very considerable reputation even among ‘fox-hunters.’ Certainly it is only in **Ireland** one sees all that horses are capable of; the English are far behind them in this respect. Wherever a man could get through, my horse found means to do so in one way or other, leaping, crawling, or scrambling. Even in swampy places where he sank up to his girths, he laboured through without the least hurry or agitation, where a more lively and timorous horse, though equally strong, would certainly never have made his way. Such a horse on a field of battle would be beyond all price: but only very early and perfect training, joined to the excellence of the breed, can produce such an one. Experience shows that a peculiar bent of education, continued through centuries, ends in rendering the superinduced qualities natural even in animals. I saw pointers in **England**, which without any training, stood still and pointed as decidedly the first time they were taken out shooting, as if they had been ever so carefully trained.


The price of these admirable horses was extremely reasonable ten years ago, but since the English have begun to buy them for hunting, it is greatly raised, and an Irish hunter of the quality of the one I rode to-day, would fetch from a hundred and fifty to two hundred guineas. At the **Galway** races I saw a celebrated blood-hunter, for which Lord Cl—— had given the latter sum. He had won every ‘steeple-chase’ he had ever run; was as light as he was powerful, swift as the wind, a child could manage him, and no hedge was too high, no ditch too wide for him.


At length we found the dogs: the men who had the care of them having got completely drunk. Our hunt did not end till the approach of twilight. It was become excessively cold, and the flickering fire, with the table spread before it, shone most agreeably upon us on our arrival at Captain S——'s house. A genuine sportsman's and bachelor's feast followed. There was no attempt at show or elegance. Glasses, dishes, and all the furniture of the table, were of every variety of form and date: one man drank his wine out of a liqueur glass, another out of a champagne



---

p.414



glass, the more thirsty out of tumblers. One ate with his great-grandfather's knife and fork, his neighbour with a new green-handled one which the servant had just bought at **Cashel** fair. There were as many dogs as guests in the room: every man waited on himself; and the meats and potables were pushed on the table in abundance by an old woman and a heavy-fisted groom. The fare was by no means to be despised, nor the wine either, nor the **potheen** clandestinely distilled in the mountains, which I here tasted for the first time genuine and unadulterated. For sweetening a pudding, two large lumps of sugar were handed about, and we rubbed them together as the savages do sticks for kindling the fire. That the drinking was on a vast and unlimited scale you may safely presume: but though many at last could not speak very articulately, yet no one attempted any thing indecorous or ill-bred; and the few who were much excited, enhanced the merriment by many a ‘bon mot’ or droll story.


I am indebted for the great cordiality, I might say enthusiasm, with which I am received here, to my visit to the ‘Man of the People,’ with whom the curious believe me to be in God-knows-what connection. I am greeted with hurrahs in every village I ride through; and in **Cashel**, the market-place, in which my inn stands, is daily filled with people, who congregate at an early hour, and cheer me every time I go out. Many press forward and ask leave to shake my hand, (a no very gentle operation,) and are quite happy when they have accomplished this.


We rose from table very late. I was packed into my host's car with another gentleman, and set off for **Cashel** through an icy fog. Every individual ran out to my assistance. One would draw a pair of furred gloves on my hands; another lent me a cloak; a third tied a handkerchief round my neck;—every man insisted on doing me some little service: and with many a ‘God bless his Highness!’ I was at length suffered to depart. The gentleman with me, Mr. O'R——, was the most original, and the most drunk of any. Equally bent on doing me some kindness, he invariably made the matter worse than he found it. He unfastened my cloak, in trying to fasten it; tore off my handkerchief, instead of tying it; and fell upon me, in his efforts to make room. His poetical humour displayed itself as characteristically when we reached the Rock of **Cashel**. It was dreadfully cold, and the cloudless firmament twinkled and glittered as if bestrewn with diamonds. Between the road and the rock, however, a thick mist lay along the earth, and covered the whole surrounding country as with a veil, though it did not rise higher than to the foot of the ruin. Its base was invisible, and it appeared as if it stood built on a cloud in the blue aether, and in the midst of the stars. I had been admiring this striking night-scene some time, when my neighbour, whom I thought asleep, suddenly cried aloud, ‘Ah, there is my glorious rock! look, how grand! and above all, the sacred place where all my ancestors repose, and where I too shall lie in peace!’ After a pause he tried in a fit of greater ecstasy to stand up, which but for me would probably have ended in his falling from the carriage. As soon as he was firm on his legs, he took off his hat reverently, and with a sort of devotion, at once affecting and burlesque, called out with tears in his eyes, ‘God bless Almighty God, and glory to him!’ Notwithstanding the nonsense, I was touched by the feeling which broke through it, and in this at least I sympathized with my whole soul.




---

p.415


### October 15th


Lord H——, whom I knew in **London**, invited me to spend some days at his beautiful residence in this neighbourhood. This invitation I was obliged to refuse, but went to-day to dine with him. The well-kept pleasure-ground, and the excavation of a hollow for a little lake, recalled to me but too strongly the castle where you, my dear! are now living, to be able to look at it without emotion. When shall we see each other again! when shall we breakfast under the three lime-trees with the swans who so trustingly fed out of our hands, while your tame doves picked up the crumbs at our feet, and the little coco, surprised and jealous, looked at the audacious birds with his wise eyes,—a picture at which the ‘blasé’ man of the world shrugs his shoulders contemptuously, but which touches our hearts in all its native simplicity.


Lord H—— is not one of those Irish nobles who withdraw the whole of their revenues from their country: he sometimes resides there: but he understands his interest so ill, that instead of placing himself at the head of the people, he sets himself in opposition to them. The natural consequence ensues: **Lord *Llandaff***, though a Protestant, is beloved: Lord H—— is hated, though personally he does not appear to me to deserve it. I heard much of his excessive cruelties towards the Catholics, and I was indeed witness to his violent temper on this subject. I think, however, that in this case, as in so many others, the mere change of one's own point of view alters all the relations of things. This is a grand rule of the practical philosophy of life, and the effect is certain: for the objects are only raw material matter; every thing depends on the manner in which the individual understands and shapes them. How many situations may thus be transformed from black into rose-coloured, as soon as one resolutely takes off the black spectacles, or puts on the rose-coloured ones. With what spectacles will you read my letter?—I hear your answer, and kiss you for it.


Heaven guard you, and keep you in this mind!


Your devoted

 L——
### Ban——, October 17th, 1828

Beloved Julia,


Since yesterday I have been an inhabitant of a pretty Gothic cottage at the foot of a mountain. From one of my windows I see fertile fields: from the other, wood, lake, and rocks. The master of the house is Mr. O'R——'s brother, who possesses besides this charming residence a very pretty wife, to whom I pay my court a little, for the gentlemen drink and hunt too much for my taste. The family estate would have naturally devolved on my whimsical friend; but as he was always rather a wild bird, who from his boyhood had a strong propensity for whiskey-punch and a joyous life, his father, having the disposal of it, left it to his youngest son. The brothers are nevertheless the best possible friends; and the light-hearted kindly nature of the eldest finds no wormwood in the wine which he drinks at his brother's table; while on the other side, the younger respects the poverty of his kind-hearted and amusing elder, (who gets regularly drunk every evening,) and lets him want for nothing. Such a connexion does honour to both, the more, because at the father's death the



---

p.416



lawyers were of opinion that the will might have been set aside. Both have doubtless acted with as much wisdom as kindness to leave it uncontested, and thus keep the oyster for themselves.


We passed the whole day in rambling about these magnificent mountain-paths. Others went out snipe-shooting, after which we sat *at the dinner table till 2 o'clock in the morning.* Very soon after the dessert was served, the ladies, as usual, left us: and now the drinking began in earnest. Coffee was brought very late; on the heels of which followed a stimulating ‘souper’ of ‘devils’ of all sorts, raw oysters and pickles. This formed the prelude to **potheen** punch, of which several drank from twelve to sixteen large tumblers, whilst O'R—— kept the whole company ‘in a roar of laughter’ by his inexhaustible wit and mad tricks. Besides this, every man was forced to sing a song: I among the rest, a German one, of which nobody understood a word, but all were very politely delighted. At two, I retired; but all the others staid. As my chamber was unfortunately directly over them, it was long before I could sleep for their noise and laughter.


### October 19th


You will wonder at the somewhat coarse and low life I led here, and to say the truth I wonder at it myself; but it is ‘genuine,’ that is to say, perfectly natural to these people, and nothing assumed; and that has ever a charm of its own, at least for me. Besides, the lady of the house is really charming, lively and graceful as a French-woman, with a foot like a zephyr.


This morning we hunted hares, and many a bold leap was taken. In the evening they produced the most celebrated piper of **Ireland**, Keans Fitzpatrick, called the King of the Pipers, having been honoured with the approbation of ‘His most gracious Majesty King George the Fourth.’ Indeed, the melodies which the blind minstrel draws from his strange instrument are often as surprising as they are beautiful, and his skill is equal to his highly polished and noble air. These pipers, who are almost all blind, derive their origin from remote antiquity. They are gradually fading away, for all that is old must vanish from the earth.


### October 19th


In the course of the day we met two men of very suspicious appearance in a wood. My companion very cooly pointed them out to me as notorious robbers, who had managed, partly by cunning, partly by the general terror they inspired, to preserve their liberty;—another proof how defective is the government and how entirely perverted are all the relations and sentiments of society; two things by which **Ireland** is specially characterized. Both of these men, who called themselves farmers because they rented a little bit of potatoe-field were of a singularly striking and national aspect. The one, a slender man of about forty, handsome, with a wild but imposing physiognomy, was a highly picturesque figure, even in his rags. Contempt of all danger was impressed upon his noble brow;—indifference in all disgrace played scornfully about his audacious mouth. His history confirmed the language of his features. He wore three or four military medals, which he had gained in the wars in **Spain** and



---

p.417


**France**. In consequence of repeated proofs of his remarkable courage he had been raised to the rank of a non-commissioned officer, from which his had been disorderly conduct soon caused him to be degraded: he had then served a second time, again distinguished himself, and again for the same reasons as before been disgraced, though not convicted of any capital offence.—He is now strongly suspected of being the leader of the band of robbers who infest the **Galtees**, and have committed several murders. His companion was in external appearance the complete reverse of him; he was, for an Irish farmer, unusually well clad, that is to say, in whole clothes; sixty years old, short and thick-set, and in his whole aspect almost like a Quaker. In his sanctified countenance, however, lurked such an expression of cunning and of pitiless determination, that he appeared to me much more terrible than the other. He was prosecuted two years ago for forging bank-notes; and was very nearly convicted, when he was rescued from the gallows by a dexterous lawyer to whom he entrusted his case. With tears of gratitude he put fifty pounds into the hand of his deliverer, lamenting most pathetically that he could not requite him better. The advocate was satisfied with his success, and put the notes into his pocket-book. What was his indignation at finding that Paddy had paid him in the very notes from the consequences of the manufacture of which he had just saved him! When the Irish take a bad turn, (and the only wonder is that they do not all do so,) they are the most dangerous people in the world; their most prominent qualities—courage, levity, and cunning,—are but too efficient in enabling them to dare every thing and to effect much.


### October 21st


I had so often laid the hospitality of these worthy squires under contribution, that I was obliged ‘en conscience’ to make some return. I therefore invited them all to dine with me before my departure. In the morning I gave a cock-fight, ‘car il faut hurler avec les loups;’ then a concert of the great piper; then we had a ride; and lastly ‘grand festin, grand chère, et bon feu.’ During our ride we came to a spot at which a magistrate named Baker was shot three years ago. He was a man exactly in the stile of the Bailiffs (*Amtmänner*) in **Iffland**'s Plays; only, alas! there was no noble character to thwart and counteract him. The day before his death, in discharging a man whom he had imprisoned for six weeks on a charge of suspected revolutionary practices, he publicly said, ‘Last month I sent you word that I wanted to speak to you;—you would not come. I have given you this little lesson for it, which I hope will make you more complying in future: if not, in six weeks more you shall swing; of that you may rest assured!’ The county was at that time under ‘martial law,’ in consequence of some disturbances; and almost unlimited power was given to the local authorities, whose insolence and atrocity therefore knew no bounds. The immediate cause of Baker's death was of a kind which deprives one of all pity for him. He was indebted £500 to a dairyman, partly for articles supplied to his household, partly for money he had borrowed. This he had promised to pay as soon as the man found a suitable match for his daughter, whose portion the money was to be. In a few years this took place, and the dairyman humbly entreated to be paid. Baker, however, continually put him off under various pretences; and finding he could obtain nothing but vain promises, the poor fellow at length threatened him with an action, and set off for **Cork** to consult a lawyer. Taking advantage of his absence, Baker appeared the



---

p.418



next day at his house, followed by a detachment of soldiers, and with infernal hypocrisy asked his wife, then pregnant of her seventh child, whether she knew of any concealed arms, and told her that her husband was strongly accused of having secreted some. The woman answered without fear or hesitation, that she was sure no such thing existed in her house; that her husband would never have any thing to do with such plots; as Mr. Baker himself, who was an old acquaintance, well knew. ‘Take care what you say,’ said Baker; ‘for if any thing is found after you have denied it, you are subject to transportation for life.’ The woman persisted in her denial ‘Well, then, at your peril be it,’ said he. ‘Soldiers, search the house thoroughly, and bring me word what you find.’ They found nothing; but a second search being made, under Baker's own superintendance, a loaded pistol was produced by some man, who pretended to have found it under some straw; into which it was always suspected Baker himself had just thrust it. The woman was immediately dragged away, and being regarded as convicted by the presence of the corpus delicti, was, after a short trial, sentenced to transportation. In a few days her husband returned, and moved heaven and earth to obtain her pardon. In vain did he entreat that at least he might be suffered to go to **Botany Bay** instead of his unhappy wife, the pregnant mother of six children. He offered to give Baker the £500. But this fiend remained inexorable, jeeringly reminding the despairing husband ‘that he wanted the money to portion off his daughter, who,’ he added, ‘might now keep house for him, if after the consequences of the search he had still any house to keep. That he need not trouble himself about his wife's travelling expenses, for that the Government would generously provide for them.’ The law had its course; the poor woman was transported, and is perhaps now at **Port Jackson**. The husband, made furious by despair, and joined by her brothers and two other men, shortly after avenged her, by Baker's cruel death. They fell upon him in the open fields, hunted him like a wild beast, and killed him slowly by a number of shots. All were taken and hanged.


Tales of horror like this were formerly of daily occurrence in this unhappy land, and even now have not entirely ceased. That such a contrast should exist between **England** and **Ireland**, and under the same Government too; that it should be suffered to endure for centuries, is indeed afflicting to every philanthropic mind. Unbridled bigotry, and rapacity unwilling to disgorge any part of its former prey, are the causes;—six millions of human beings the victims.


I have nothing remarkable to relate concerning my dinner-party: it was
like its predecessors, and lasted far too long.


It was formerly the custom to give parties, of which the sole and avowed object was desperate drinking,—a fashion which is comparatively fallen into disuse. It was a common thing for a man to lock himself into a room with a hogshead of wine and some jolly companions, and not to leave it till the last drop was emptied. Barrington mentions such a party in his memoirs. It was given in a shooting lodge, in which the wall had been covered with mortar only the day before, and was of course still wet. Here the company were locked in with a pipe of claret, just arrived from **France**; and when some of them who had tumbled against the wall, awoke in the morning from their night's debauch, they found themselves so thoroughly identified with it that they were obliged to be cut away, some with the loss of their clothes and others of their hair.


After my guests had exhausted their store of anecdotes, which were not



---

p.419



precisely of a kind to entertain you with, they resorted to all sorts of practical jokes and ‘tours de force.’ One of these was quite new to me. It is an experiment which any body may try, and it struck me as curious enough. The wildest and fiercest game-cock may be rendered motionless, and compelled to lie in deathlike stillness as long as you please, by simply laying him on a table, with his beak close to a white line drawn across it. Nothing is necessary but first to draw this line with chalk, then to take the cock in your hands and lay him on the table with his beak turned towards it. You press him down, and there he will lie as if bound by some spell; his beak stretched out, and his eyes immoveably fixed on the white line, till you take him away. The experiment must be tried by candlelight.


‘Voilà de grandes bagatelles, mais à la guerre comme à la guerre.’


### October 22th


As Fitzpatrick the piper, whom I had sent for to my party yesterday, was still in the town, I had him come to play ‘privatim’ in my room while I breakfasted, and observed his instrument more accurately. It is, as you know, peculiar to **Ireland**, and contains a strange mixture of ancient and modern times. The primitive simple bagpipe is blended with the flute, the oboe, and some tones of the organ and of the bassoon: altogether it forms a strange but pretty complete concert. The small and elegant bellows which are connected with it are fastened to the left arm by means of a riband, and the leathern tube communicating between them and the bag lies across the body; while the hands play on an upright pipe with holes like a flageolet, which forms the end of the instrument, and is connected with four or five others joined together like a colossal Pan's pipe. During the performance, the right arm moves incessantly backwards and forwards on the body, in order to fill the bellows. The opening of a valve brings out a deep humming sound, which forms an ‘unisono’ accompaniment to the air. By this agitation of his whole body, while his fingers were busied on the pipes I have described, Fitzpatrick produced tones which no other instrument could give out. The sight, in which you must picture to yourself the handsome old man with his fine head of snow-white hair, is most original and striking; it is, if I may say so, tragicomic. His bagpipe was very splendidly adorned, the pipes were of ebony ornamented with silver, the riband embroidered, and the bag covered with flame-coloured silk fringed with silver.


I begged him to play me the oldest Irish airs; wild compositions, which generally begin with a plaintive and melancholy strain like the songs of the Slavonic nations, but end with a jig, the national dance, or with a martial air. One of these melodies gave the lively representation of a fox-hunt, another seemed to me borrowed from the Hunters' Chorus in the Freischütz; it was five hundred years older. ‘Les beaux esprits se rencontrent dans tous les ages.’


After playing some time, the venerable piper suddenly stopped, and said smiling, with singular grace, ‘It must be already well known to you, noble Sir, that the Irish bagpipe yields no good tones when sober: it requires the evening, or the stillness of night, joyous company, and the delicious fragrance of steaming whiskey-punch. Permit me, therefore, to take my leave.’


I offered such a present as I thought worthy of this find old man, whose image will always float before me as a true representative of Irish nationality.




---

p.420


With Fitzpatrick I take my leave of you, dearest Julia, to set out on
my return to **Dublin**, whence I calculate on despatching my next letter to you.


Your faithful 

 L——.**Dublin**, October 24th, 1828
------------------------------


Good and dear friend,


#### 


After leading a half savage life so long, the tameness of the city appears quite strange. I can now imagine the home-sickness of the North American Indians, even the most civilized of whom always return to their woods at last. Freedom has such a matchless charm.


Yesterday, after dinner, I left **Cashel**, taking Captain S——'s brother in the carriage with me. While daylight lasted we saw at least twenty ruins, far and near. One of the most beautiful stands at the foot of an isolated hill, **Killough Hill**, called the garden of **Ireland**, because, according to the popular tradition, every indigenous plant in **Ireland** is to be found on it. The cause of this unwonted fertility is, that it was formerly the summer residence of the fairy queen, whose gardens bloomed here. The soil still retains some portion of its wondrous virtues. The ruin has likewise one of the mysterious slender round towers without any entrance. Some few of them have an opening or door, not at the bottom, however, but in the middle. It is impossible to conceive a more romantic watch-tower for the fairy hill. The weather was remarkably mild and beautiful, and the full moon so brilliant that I could read with perfect ease in my carriage. We slept, nevertheless, through a great part of the night.


I found a letter from you in **Dublin**;—a thousand thanks for all the kindness and affection towards me which it contains. Do not be too anxious as to the situation of your friend. Tell her she must act as necessity requires, avert what can be averted, postpone inevitable evil as long as possible, but always bear calmly what is actually present. This at Least is my philosophy. Your quotation from **Madame de Sévigné** amused me extremely. Her letters are certainly extraordinary; repeating the same things, and those trivial enough, though volume after volume; yet by the new turn she continually gives them, always entertaining, sometimes bewitching; depicting court, city and country with equal grace; taking a somewhat affected love for the most insignificant of women as her main theme, yet never wearying: these were certainly conditions which no one but herself could have fulfilled. She is not in the least degree romantic, nor was she, while living, remarkably distinguished; but she is, without question, the best-bred model ‘du ton le plus parfait.’ Without doubt she also possessed ‘good temper’ bestowed by nature, ennobled and refined by art. Art is at least visible throughout; and probably her letters, which she knew were eagerly read by many, were carefully polished, and were calculated as much for society as for her daughter; for the admirable lightness of her style betrays much more of care than the ‘épanchement’ of the moment permits. The representation of the manners of the day has a considerable effect in heightening the interest of the letters, but I doubt whether such letters written now would enjoy equal success. We are become both too serious and too avaricious. ‘Les jolis riens ne suffisent



---

p.421



plus.’ We want excitement, and violent excitement. Where a giant like **Lord Byron** appears, little prettinesses sink into insignificance. I was just now reading in his works,—for I never travel without them. I fell upon the description of a scene precisely like many I have lately witnessed. In what elevated language did I find my own feelings expressed! I translate it for you as well as I can, in a sort of poetic prose, and as literally as possible:—
  


> 1. Der Himmel wandelt sich!—Welch ein Wechsel! O Nacht—
>   
> Und Sturm und Finsterniss, wohl seyd ihr wundermächtig!
>   
> Doch lieblich Eure Macht—dem Lichte gleich,
>   
> Das aus dem dunklen Aug des Weibes bricht.—Weithin
>   
> Von Gipfel zu Gipfel, die schmetternden Felsen entlang
>   
> Springt der eilende Donner. Nicht die einsame Wolke allein,
>   
> Jeder Berg hat eine Zunge gefunden,
>   
> Und Jura sendet durch den Nebelvorhang Antwort
>   
> Zurück, dem lauten Zuruf der jubelnden Alpen.
>   
> Das ist eine Nacht!—o herrliche Nacht!
>   
> Du wurdest nicht gesandt für Schlummer. Lass auch mich
>   
> Ein Theilnehmer seyn an Deiner wilden, fernhin schallenden Freude
>   
> Ein Theil vom Sturme—und ein Theil deiner selbst—
>   
> Wie der See erleuchtet glänzt—gleich dem phosphorischen Meer!
>   
> Und die vollen Regentropfen—wie sie herabtanzen auf seine Wellen!
>   
> Und nun wird Alles wieder schwarz—und von neuem
>   
> Hallt der Berge Chorus wieder, in lauter Lust,
>   
> Als säng' er Triumph über eines jungen Erdbebens Geburt!
> 


[2](javascript:footNote('T820002-001/note002.html'))


Is not that beautiful? What true poetic feeling! What a pity that we have no good translation of his works. **Göthe** alone were able to give a perfectly satisfactory version of them,—if he were not occupied in creating what equals them in grandeur, and surpasses them in lightness, grace and sweetness.


### October 25th


I called yesterday at the **Lord Lieutenant**'s house in the **Phoenix Park**. He invited me to dine with him to-day. The party was brilliant. He is beloved in **Ireland** for his impartiality, and for the favour he has always shown to the cause of emancipation. His exploits as a general officer are well known, and no man has a more graceful and polished address in society. A more perfect work of art than his false leg I never saw.


The



---

p.422



Marquis, although not young, has still a very fine person, and his artificial leg and foot rival the other ‘à s'y méprendre.’ The only thing which betrays it, is some little difficulty in walking. On the whole, I know few Englishmen who have so good a ‘tournure’ as the present **Lord Lieutenant** of **Ireland**. When he resides in the city, a very rigid etiquette, like that of a little court, is observed; but in the country he lives like a private gentleman. The power and dignity of a **Lord Lieutenant** are considerable as representative of the King; but he holds them only at the pleasure of the ministry. Among other privileges he has that of creating Baronets; and in former times inn-keepers, and men even less qualified, have received that dignity. When his functions cease he gains no accession of rank by the past performance of them. His salary during his continuance in office is £50,000 per annum, and a residence free of charge; so that he can very well lay by his own income. This, however, the present **Lord Lieutenant** does not appear disposed to do: his establishment is very liberal and splendid. He is surrounded too by very interesting men, who unite extreme good breeding with frankness and cordiality, and seem to judge of party questions with moderation and good sense. From what I have said, it may safely be presumed that Lord Anglesea's residence here will not be of long duration; and indeed I heard some hints to that effect. As he suffers dreadfully from Ticdouloureux, I recommended H—— to him, as a person remarkable for cures of that complaint, and gave his physician the book in which he treats of it. The Marquis said, smiling, ‘I shall find no difficulty in obtaining leave of absence;’ at the same time casting a significant glance on his private secretary. This confirmed me in the surmise I have just expressed. It will be a great calamity for **Ireland**, who rejoices in the new and unaccustomed blessing of a governor who views the disgusting religious dissensions by which she has so long been torn, with the eye of a philosopher.


Before I drove to the **Phoenix Park** I attended divine worship in a Catholic chapel. It is a handsome building: the interior is a large oval, with a colonnade of Ionic pillars running round it, surmounted by a beautiful dome, and an excellent **alto-relievo** in the arched roof above the altar: it represents the Ascension. The figure and expression of our Saviour are peculiarly admirable. The fancy of the artist has placed him before us such as we must imagine him. The Catholics affirm that they possess genuine portraits of Christ. Indeed, in the south of **Germany** I once saw an advertisement of a collection of genuine portraits of God Almighty.


The chief altar stands quite alone, and is of a simple and beautiful form: it is of white marble, and was made in **Italy**. The slab on the top and the base are of dark marble. The front fa[cedil ]ade is divided into three compartments, on the middle is a monstrous pyx of gold bronze, and on each side **bas-reliefs** of praying angels.


Above, on the centre of the altar, stands a magnificent temple of splendid gems and gold, in which the real pyx is kept, and near it two no less magnificent golden candlesticks. On each side of the altar stands a tripod, supported by angels with folded wings; on the tablet at the top are placed the Host and the wine. The details are executed in the best possible taste, and a grand simplicity reigns through the whole. From the roof hangs a massive silver chain, supporting an antique lamp of the same metal, which is kept perpetually burning. It is certainly one of the most beautiful institutions of the Catholic religion, that some churches stand open day and night to all who long for communion with Heaven. In **Italy**


---

p.423



I scarcely ever went to rest without visiting one of these; and giving myself up to the wondrous effect produced in the stillness of night by the red fantastic light thrown on the vaulted roof by the few scattered lamps, I never failed to find some solitary figure, kneeling in supplicating reverence before one of the altars, busied only with his God and himself, and utterly unmindful of all that passed around. In one of these churches stood the gigantic statute of St. Christopher, leaning against the middle pillar, and touching the roof with his head. On his shoulders was his heavy burthen, the miraculous child; and in his hand, as a staff, a full-grown trunk of a tree, with fresh green boughs, which were renewed every month. The light of a lamp suspended above, surrounded the infant Christ with a glory, and threw some rays, as if in benediction, upon the pious giant.


When I compare the Catholic service as it is performed here, with that of the English Protestant church, I must unquestionably prefer the former. It may perhaps contain some superfluous ceremonies, some which even border on the burlesque, such as the tossing about of the censers, the continual shifting of dresses, &c.; but still this form of worship has a sort of antique grandeur which imposes and satisfies. The music was excellent; the singers very good, and, which amazingly enhanced the effect, invisible. Some Protestants call this a taint of sensuality; but I cannot discover why the scream of an unmusical Lutheran congregation, which rends one's ears, should be more pious than good music, executed by people who have been well taught. Even with a view to the contents of the sermon, the comparison was greatly to the advantage of the Catholic church. While the Protestant congregation at **Tuam** was entertained with miracles, swine, and evil spirits, the discourse here was purely moral and practical. The eloquent preacher had taken envy as his subject, and said among other excellent remarks, ‘If you would know whether you are entirely free from this crime, so afflicting to humanity, so degrading to the individual who cherishes it,—examine yourselves thoroughly, whether you never experienced an unquiet and dissatisfied feeling at the constant and growing prosperity of another; whether you never felt a slight satisfaction at the tidings that some mischance had happened to a fortunate neighbour? This is a serious inquiry, and few will make it earnestly without advantage.’


The way in which every one reads silently in his prayer-book, while the sublime music elevates the soul, and withdraws it from the earthly and trivial, appears to me far preferable to the loud responses and prayers of the Anglican church. During this interval of silent veneration, little heed is given to the ceremonies, the change of raiment, or the incensing the priests. But even allowing for these slight blemishes, the Catholic church strikes the mind, as a whole, as something congruous and harmonious with itself, and venerable from its antiquity and its consistency: the English Protestant church, on the contrary, as something patch-work, incongruous, and unconnected. In connexion with the German church (of course I mean as it is understood by such men as **Krug** and **Paulus**,) these two establishments might be likened to three individuals who were in a magnificent place, affording every variety of enjoyment, and of valuable information; but shut out from God's sun and his beautiful open creation



---

p.424



by a high wall. The first of the three was satisfied with the glitter of the jewels and the light of the tapers, and never cast one wistful glance toward the few chinks in the wall which admitted some glimpse of daylight. The other two were restless and dissatisfied; they felt that there was something still better and fairer abroad, and determined to get over the high wall, cost what it would. Well provided with every thing they thought they should want, they began this great undertaking. They had many perils, many inconveniences to encounter, but at length they reached the top. Here, indeed, they could behold the sun's radiant countenance, but clouds often concealed it, and the beautiful green of the meadows beneath was often deformed by weeds and thorns, amidst which terrible wild beasts roamed prowling about. But nothing could daunt the second of the three, nor turn him from his enterprise; his intense desire for freedom conquered all fear and all doubt: unhesitatingly, he let himself down into the new world, and as he left every thing behind him that he might be perfectly unimpeded, he soon disappeared within the sacred enclosure. As to the third, he remains still sitting on the wall, between heaven and earth; still living on the food, and delighting in the finery he brought with him from below, and unable to wean himself from it, though the rays of the sun, which now fall uninterrupted on the false tinsel, shows it in all its worthlessness. Like the ass in the fable, he hesitates between the two bundles of hay, without knowing which to prefer. Backward he cannot go, and he has not courage to go forward; the flesh-pots of **Canaan** detain him where he is so long as they last.


### October 27th


If I do not choose to make ‘allotria’ that is to talk of things which have nothing to do with my travels or my residence here, living in the world will make my letters very barren. I could draw out a scheme or formula and have it lithographed, leaving a few blanks to be filled ad libitum. For instance, ‘Rose late, and out of humour. Walked, rode, or drove out to make visits. Dined with Lord ——, or Mr. ——; dinner good, or bad; conversation, common places. Evening, a tiresome party, rout, ball, or above all, amateur concert. N. B. My ears still ache.’ In **London**, might be added, as a standing remark, ‘The crowd nearly suffocated me, and the heat was greater than on the highest bench of a Russian vapour bath.’ Physical exertion to-day=5 degrees (reckoning a fox-hunt at 20,) intellectual profit therefrom =0. Result, ‘Diem perdidi.’


It is not quite so bad here: in this season the fatigue one has to undergo does not exceed that of a large German town; but there are a great superabundance of invitations which one cannot civilly refuse. For how truly can I say with the English poet, ‘How various are the feelings of guests in that world which is called great and gay, but which is the most melancholy and tedious of any to those who cannot share in its gaiety!’


### October 28th


I am just returned from a dinner-party, in which there was rather a provincial tone, but no want of pretension. Some things were comical enough; but the worst of it is, one buys a little laughing with such a quantity of ennui. The dinner too was a real ‘mystification’ for a ‘gourmet,’ and the house and park correspond with it.


My propitious star placed me at table next to Lord P——, a celebrated political character, who has taken his stand on the good and noble side,



---

p.425



and has remained faithful to the cause of emancipation. It gave me great pleasure to find that his views of things agreed so perfectly with those which I had been led to entertain from my own observations on the spot. One of his expressions struck me by its ‘naïveté.’ I remarked to him, that from what I saw, even emancipation could do little good; for that the real evil was, that the soil was the property of an aristocracy, whose interests would always lead them to reside in **England**; and above all, the sums which were extorted from the poor Catholics by the Protestant church. So long as this remained unaltered, I saw no hope of any better state of things.


‘Yes,’ replied he; ‘but to alter *that* is impossible. If the Protestant clergy were deprived of their wealth they would lose all their importance.’ ‘How can that be?’ replied I, laughing. ‘Is it possible that virtue, mild instruction, and pious devotion to the duties of his office, would not ensure to a clergyman, even of the highest rank, more respect with a moderate income than immoderate luxury; or are 20,000*l.* a-year really necessary ‘to make a Bishop or Archbishop appear decently in society?’’ ‘My dear Sir,’ answered Lord P——, ‘such a thing may exist and maintain itself abroad, but will never do in Old **England**, where, above all, money, and *much money* is required and necessary to obtain respectability and consideration.’ This remark was not applied to the aristocracy; but it is not the less true that money is essential to its very existence, although it now affects, with no little display of haughtiness, to estimate noble birth far above mere wealth.


Lady M——, who was present, entertained the company as usual by her wit. She amused me with some diverting anecdotes [*gap: deleted/extent: two lines*]


It is remarkable, that in no country does one meet half so many old maids as in **England**; and very frequently they are rich. Their excessive pride of wealth, which leads them to think no rank and greatness sufficient for them, or the exaggerated romantic notions in which they are brought up, are the causes of this phenomenon. English girls insist on being loved entirely and solely for themselves. French women make no such pretension, judging rightly enough, that this devoted affection will grow out of marriage, where there are the qualities fitted to produce it; and that where these do not exist, it will not endure, whatever the lover may say or believe to the contrary. The English, like true Turks, keep the intellects of their wives and daughters in as narrow bounds as possible, with a view of securing their absolute and exclusive property in them as much as possible, and in general their success is perfect. A foreigner serves as an amusement, a plaything to Englishwomen, but always inspires them with some degree of fear and reserve. It is extremely rare for them to bestow as much of their confidence upon him as upon a countryman.




---

p.426


They regard him as a half atheist, or a superstitious worshipper of Baal, and sometimes amuse themselves with attempting to convert him. I do not speak here of the **London** Exclusives; they give the same result as the rubbing together of all colours,—none remains.


### October 29th


The beautiful weather tempted me out into the country. I rode about the whole day, and saw two fine seats, **Malahide** and **Howth**. They have one peculiarity in common; both have remained for nine hundred years in the possession of the same family, which no English seat that I have seen or heard of can boast. **Malahide** has also an historical interest, for it belongs to the **Talbots**; and the armour of the celebrated warrior, with the mark of a blow from a partisan on the breast is preserved here. One-half of the castle is extremely old, the other was demolished by **Cromwell**, and rebuilt in the antique style. In the former part they showed me chairs five hundred years old, and a room in which the rich ‘boiserie,’ the carved ceiling and the floor, all of black oak, had remained unchanged for seven hundred years. The new part contains many interesting pictures.


There is a portrait of the **Duchess of **Portsmouth****, so lovely that I almost envied **Charles the Second** even in his grave, the glory of making her a Duchess. An old picture of **Mary Stuart**, although represented at an advanced period of her life, confirmed me in my conviction of the resemblance of the portrait of this unfortunate and beautiful queen, which I saw in the County **Wicklow**. I looked with interest at a scene at the court of Madrid, with a portrait of the king seated in great solemnity in a scarlet robe; **Charles the First, as Prince of **Wales****, dancing rather ‘légèrement,’ a minuet with the Infanta; and the gay, seducing ****Buckingham**** magnificently dressed, and paying assiduous court to one of the ladies of honour.


**Howth Castle**, belonging to the **St. Lawrence** family, and inhabited by **Lord **Howth****, who is no absentee, has been more modernized, and with no happy effect. The Grecian portico accords but ill with the small Gothic windows and the high gables. Here likewise the sword and armour of a celebrated ancestor with a romantic name is carefully preserved. He was called Sir **Armoricus Tristram**, and in the year 1000 gave battle to the **Danes** on this spot, and I think lost his life. The antique stables were full of noble hunters: Lord Howth's hounds are also very celebrated. On my return I went to the theatre, where **Ducrow**, the English **Franconi**, ennobles his art by his admirable representation of animated statues. This is a high enjoyment to a lover of art, and far surpasses the ‘Tableaux’ which are in such favour on the continent. When the curtain draws up, you see a motionless statue on a lofty pedestal in the centre of the stage. This is **Ducrow**; and it is hardly credible how an elastic dress can fit so exquisitely and so perfectly represent marble, only here and there broken by a bluish vein. He appeared first as the Hercules Farnese. With the greatest skill and precision he then gradually quitted his attitude from one gradation to another, of display of strength; but at the moment in which he presented a perfect copy of the most celebrated statues of antiquity, he suddenly became fixed as if changed to marble. Helmet, sword, and shield, were now given to him, and transformed him in a moment into the wrathful **Achilles**, **Ajax**, and other Homeric heroes. Then came the Discobolus and others, all equally perfect and true. The last was the attitude of the fighting Gladiator, succeeded by a masterly



---

p.427



representation of the dying Gladiator. This man must be an admirable model for painters and sculptors: his form is faultless, and he can throw himself into any attitude with the utmost ease and grace. It struck me how greatly our unmeaning dancing might be ennobled, if something like what I have described were introduced, instead of the absurd and vulgar hopping and jumping with which we are now entertained. It gave me pain to see this fine artist, (for he certainly merits no less a name,) ride nine horses at once, in the character of a Chinese sorcerer; drive twelve at once in that of a Russian courier; and lastly, go to bed with a poney dressed as an old woman.


I must now bid you good night, and good-bye for some days. To-morrow morning early this letter will go by post.


Your faithful


L——.**Dublin**, October 30th, 1828
------------------------------


Dearest Julia,


#### 


Oh what reproaches! However, three letters at once are a compensation for every thing. I read the news from home till I nearly appeased my appetite for it, and can hardly express my gratitude to you [*gap: deleted/extent: one line*] You are indeed right; such an ally as you would be of great use to me. Governess Prose would have kept Poetry better within bounds; and the boy who never grows old, and whose nature it is to play with gay soap-bubbles, would perhaps, under the guidance of a sage Mentor, have tried to pluck some more solid earthly fruit, instead of grasping at the rainbow balls. ‘Mais tout ce qui est, est pour le mieux!’ Let us never forget this axiom. **Voltaire** was wrong to turn it into jest; and **Panglos** was really in the right. This persuasion can alone console us under all afflictions; and for myself, I confess it is the essence of my religion.


Your letter No. 1 is wisdom and goodness itself: but, dear Julia, as far as the former is concerned, it is powder and shot thrown away upon me. I am too much—what shall I call it?—a man of feeling and impulse, and shall never be wise, *i. e.* prudent in a worldly sense. But I am so much the more accessible to kindness,—yours only excepted; the measure of which is already so full and overflowing, that not a drop more can find entrance into my heart. With this full heart you must once for all be satisfied; your poor friend can give you no more. But is it possible that you can find room for fears that these two years of absence can have changed me towards you? that I may no longer find in you what I formerly found,—and so on. Do you know what the English would call this?— ‘Nonsense.’ That I can wish nothing more intensely than to see you again, my unwearied correspondence might surely convince you; but you quite forget that [*gap: deleted/extent: two lines*]


How often have I told you that I am not suited to the world! My defects as well as my merits, nay even the intellectual character which you imagine you find in me, are only so many stumbling-blocks in my way. A man who is intelligent, somewhat poetical, good-natured and sincere, is commonly awkward and ill at ease in every-day society. Like all those,—to use the words of an English writer,—whose feelings and affections paralyze



---

p.428



their advantages, I do not find out till too late what was the prudent and discreet course: ‘an artless disposition,’ continues the Englishman, ‘which is ill adapted to enter the lists with the cunning and the cold selfishness of the world.’ I know a distinguished man, a hundredfold my superior, who in this respect is in the same predicament, and who continually laments that he has been transformed from a poet into a statesman. ‘I ought to have ended my life as I began it,’ said he; ‘wandering about the world unknown, and rejoicing undisturbed in the beauty and grandeur of God's works; or remote from men, shut up in my study, alone with my books, my fancy, and my faithful dog.’


### October 31st


I spent a very pleasant evening to-day at Lady M——'s. The company was small, but amusing, and enlivened by the presence of two very pretty friends of our hostess, who sang in the best Italian style. I talked a great deal with Lady M—— on various subjects, and she has talent and feeling enough always to excite a lively interest in her conversation. On the whole, I think I did not say enough in her favour in my former letter; at any rate, I did not then know one of her most charming qualities,—that of possessing two such pretty relatives.


The conversation fell upon her works, and she asked me how I liked her Salvator Rosa? ‘I have not read it,’ replied I; ‘because,’ (I added by way of excusing myself, ‘tant bien que mal,’) ‘I like your fictions so much, that I did not choose to read any thing historical from the pen of the most imaginative of romance writers.’ ‘O, that is only a romance,’ said she ; ‘you may read it without any qualms of conscience.’ ‘Very well,’ thought I; ‘probably that will apply to your travels too,’—but this I kept to myself. ‘Ah,’ said she, ‘believe me, it is only ennui that sets my pen in motion; our destiny in this world is such a wretched one that I try to forget it in writing.’ (Probably the **Lord Lieutenant** had not invited her, or some other great personage had failed in his engagement to her, for she was quite out of spirits.) ‘What a fearful puzzle is this world,’ said she: ‘Is there a presiding Power or not? And if there be one, and he were malevolent! what a horrible idea!’ ‘But in Heaven's name,’ replied I, ‘how can a woman of sense, like you,—forgive me,—utter such nonsense?’ ‘Ah, I know well enough all that you can say on that subject,’ said she; ‘certainly, no man can give me.’ This obscurity in a most acute mind was unintelligible to me, even in a woman. (‘Ne vous en fâchez pas, Julie!’)


Lady M——'s husband, formerly a physician, now a philosopher and author, and what the French call ‘un bon homme,’ affecting moreover the man of taste and judgment, gave me a book of his, containing a thoroughly materialist system of philosophy: there are, however, some good things in it, and it has altogether more merit than I should have expected from the author. I was busied in reading it half the night. From the unconnected and daring character of the whole, I however concluded either that Lady M—— had written a considerable portion of it herself, or at least that these views of things had thrown her mind into such a state of doubt and confusion, that she had actually imagined the question whether God might



---

p.429



not possibly be malevolent. Your celebrated people are but men like others, Heaven knows!—scholars and statesmen, philosophers and poets. At every acquaintance of this sort that I make, I think of **Oxenstierna**, who, when his young son expressed some hesitation and diffidence as to the part he should play at the Congress of **Münster** in the presence of so many great and wise men, replied with a smile, ‘Ah, my son, depart in peace, and see by what manner of men the world is governed!’


### Nov. 1st


‘Les Catholiques me font la cour ici.’ The * * * sent me word through his wife, that as I was a lover of their church music, I should go to their chapel to-day, where the choir would be remarkably full and good, and he himself was to perform the service. I heard indeed some magnificent vocal music, (in which female voices took part,) accompanied only by some few notes of a powerful organ. It was a high enjoyment——this sublime music, which filled the soul with a fulness of delight, and raised it on its soft wings above the cares of this lower world, while the whole congregation knelt in reverent supplication.


You will begin to think, dear Julia, that I intend to imitate the Duke of C——, and turn Catholic. And to say the truth, the motives which lead to such a change do not appear to me wholly absurd. Protestantism,—such Protestantism as we commonly find,—is not a whit more rational, and far less poetical and attractive to the senses. I am fully persuaded, however, that a new **Luther** or a new Messiah is at hand, and will help us through all our difficulties and doubts: then we shall not need to cast a look behind us;—till then, I can quite imagine that many may find more consistency, at least, in the Catholic faith. It is no imperfect half-idolatry, but perfect and consistent,—a ladder descending from heaven to earth, whose last steps are those deified creatures, those kind sympathizing saints of both sexes, who are so near to us, and who know so well our human wishes, emotions, and passions! [*gap: deleted/extent: one line and a half*]


When the priest and the acolytes toss about the censers; when the bishop every minute puts on a fresh embroidered garment,—now standing still before the altar, now running forwards, then backwards, then touching the ground with his forehead, and at length turning himself about like a weather-cock with the pyx, and then keeping his eyes fixed upon it as upon a microscope,—I am perfectly prepared to hear any of the miracles, wonders, or monstrous absurdities with which religion has been overlaid. But when a man in simple garb, and quiet reasonable appearance, gets up and speaks to me of patience, of purity, of eternal truth and eternal love, and then goes on to ascribe to the God of justice and of love, and to his noblest and purest interpreter on earth, fables and *atrocities* which shock every sound and unperverted understanding, and then requires me to receive them as something holy and divine,—I turn disgusted from such hypocrisy or such folly. A bigot may reply, Your sound understanding is no measure for the ways or the works of God. To which I answer, But *your* God is a human being; and our understanding and our reason, with our knowledge of external nature, and the experience thence derived, are the only true and genuine revelation of God, of which we are all sharers and which no one can doubt. Man is so formed by nature, that it is his inevitable destiny for ever to carry on through these means his own education, for ever to advance in the career of improvement.




---

p.430


Thus Christianity was a consequence of this progressive civilization; as were at an earlier period the Mosaic law, and at a later the Reformation, and its second act the French Revolution. Its latest results are the universal liberty of thought and of printing which have sprung from the latter event, and all that is now preparing by their more tranquil but so much the more certain operation. In every case we find only the results of the same gradual civilization. No man can know the highest point which this civilization will reach; but be that point what it may, it must always retain its human character, and be furthered by human means.


### Nov. 2nd


My last and longest visit this morning was to the sweet girls I met at Lady M——'s. I took them some Italian music, which they sang like nightingales, and with a total absence of all pretension and all affectation. Their father is a distinguished physician; and like most of the ‘doctors’ of eminence here, a ‘Baronet’ or ‘Knight,’ a title which is not esteemed a mark of nobility in **England**, although some families of great antiquity and consideration bear it. There are, however, Creti and Pleti, as among our lower nobility. A Baronet is generally called not by his family, but by his Christian name; as Sir Charles, Sir Anthony; as in **Vienna** they say, Graf Tinterle, *Fürst* Muckerle, and so on. The medical Knight of whom I now speak, received his title in consequence of the establishment of excellent baths, and is a very interesting man. His wife seemed to me still more remarkable for talent. She is very superior to her celebrated relative in accurate tact and judgment, and possesses an extraordinary power of mimicry, whose comic bent does not always spare her own family. The daughters, though perfectly different, are both very original; the one in the gentle, the other in the wild ‘genre.’ I always call her Lady M——'s ‘wild Irish girl.’ All three have a characteristic nationality, and indeed have never quitted **Ireland**.


In the evening Lady M—— told me that the translations of her works, which were often so bad as to destroy the sense, were a source of great vexation to her. In her Letters on **Italy** for instance, where she says of the Genoese, ‘They bought the scorn of all Europe,’ the translator read for *scorn, corn,* and wrote, ‘Gênes dans ce temps achetait tout le blé de l'Europe.’


### Nov. 3d


I rose early, and went to the window, when a genuine Irish scene presented itself to my eyes; such a one as no other country can show. Opposite to me in the street sat an old woman selling apples, and smoking her pipe with great satisfaction. Nearer to the house a man in a ragged dress was performing all sorts of antics, assisted by his monkey. A regular ring of people, four or five deep, surrounded him, and at every fresh trick there was a loud shout, accompanied by such ‘demonstrations,’ cries and gesticulations, that you would have thought they were quarrelling, and would soon get to blows. The recommencement of the acting,



---

p.431



however, immediately caused a deathlike stillness. But now the most lively person of the audience could not be satisfied to remain a mere spectator; she must take a part in the action; and with uncontrollable gaiety sprang into the magic circle, seized the terrified monkey, and outdid him in antics, leaps, and grimaces of every kind, which were rewarded by the redoubled shouts and laughter of the multitude. The rage for acting grew infectious; many joined the first actress; the order which had hitherto prevailed became more and more lost in wild confusion; the original performer, anxious for the safety of his ally the monkey, or fearful lest he should be corrupted by bad example, broke hastily off. His retreat soon assumed the air of a hurried flight; the whole crowd rushed, screaming and shouting, after him; every one tried to be close at his heels, some jeered at him, and several shilelahs, which pleasure had till now kept sheathed, came to view. Others took the part of the fleeing artist, who meanwhile disappeared; and before they knew what they were about, the pursuit ended in a universal battle among the pursuers.


A bachelor's dinner at Lord S——'s, at which I was present, closed my day nearly as tumultuously, though not quite so violently, and kept me awake till midnight. ‘Voilà tout ce que j'ai à vous conter d'aujourdhui.;’


### November 6th


I spend a great deal of my time with the little nightingales, see Lady M—— frequently, and avoid general society as much as I can. The young ladies keep a burlesque journal, in which they write a chronicle of their daily ‘fata,’ illustrated with the most extravagant drawings, which is infinitely diverting. After that we sing, talk, or act pictures, in which the mother, with her talent for the drama, contrives admirable dresses out of the most heterogeneous materials. You would have laughed if you had seen the ‘wild Irish girl,’ with moustaches and whiskers marked with charcoal, pocket-handkerchief and stick in her hand, come in as my caricature. These girls have an inexhaustible fund of grace and vivacity, extremely un-English, but truly Irish.


The eldest, who is eighteen, has brown eyes, and hair of a most singular kind and expression, the latter has a sort of deep golden hue without being red, and in the former is a tranquil humid glow, over which comes at times a perfectly red light like that of fire; but yet it always remains only an intense glow, not a lightning-flash like that which often glances from the eyes of the little wild girl. With her, all is flame; and under her maidenly blushes there often breaks out the determination and high spirit of a boy. Indiscreet, and carried away by the impulse of the moment, she sometimes gives way to too great vivacity, which, however, from her sweet simplicity and inimitable grace, does but enhance the charm which distinguishes her. To-day when my carriage was announced, I exclaimed with a sigh, ‘Ah, que cette voiture vient mal à propos!’ ‘Eh bien,’ cried she, with the perfect air of a little hussar, (she was still in male costume,) ‘envoyez la au diable.’ A very severe and reproving look from her mamma, and one of terror from her gentle sister, covered all of her little face, that was not concealed by her disguise, over and over with scarlet: she cast down her eyes ashamed, and looked indescribably pretty.




---

p.432


### Nov. 17th


Lady M—— received me to-day in her authoress-boudoir, where I found her writing, not without some view to effect, elegantly dressed, and with a mother-of-pearl and gold pen in her hand. She was employed on a new book, for which she had invented a very good title, ‘Memoirs of Myself and for Myself.’ She asked me whether she should put ‘of myself’ or ‘for myself’ first. I decided for the former as the more natural order; for I observed she must *write,* before she can *have written.* Upon this we fell into a sportive contest, in which she reproached me with my German pedantry, and maintained that hitherto ‘bonnet blanc’ and ‘blanc bonnet’ had been the same; the justice of which I was obliged to admit. The motto she had chosen was from **Montaigne**, ‘Je n'enseigne pas, je raconte.’ She read me some passages, which I thought very good. This woman, who appears so superficial, is quite another being when she takes the pen in her hand.


She told me that she intended to go next winter to **Paris**, and wished to go on into **Germany**, but that she had a great dread of the Austrian police. I advised her to go to **Berlin**. ‘Shall not I be persecuted there?’ said she. ‘God forbid!’ rejoined I: ‘in **Berlin** talent is worshipped: only I advise you to take at least one of your pretty young friends, who is fond of dancing and dances well, so that you may be invited to the balls at court, and may thus have an opportunity of becoming acquainted with our amiable and accomplished young military men: they are well worth knowing, and you may not find any other way of being introduced to them.’ At this moment her husband entered, and begged me to get his philosophical work translated into German, that he might not figure there only as aid-de-camp to his wife, but fly with his own wings. I promised all he wished; but observed that a new prayer-book would have a better chance of success at the present day than a new system of philosophy, of which we had enough already.


In the evening I took a box in the Equestrian theatre for the young ladies, who go out very little. Their ‘naif’ delight at the varied skill of the riders was most charming to witness. The little one never turned her eyes for a moment from **Ducrow**'s terrific feats; she trembled all over with anxiety and eagerness, and kept her hands fast clenched the whole time.


There was a child of wonderful beauty in the company, just seven years old, who danced on horseback, performed a variety of parts with uncommon grace, and especially that of **Napoleon**, in which the tiny girl mimicked the abrupt manners of the Emperor most divertingly, and was rewarded by thunders of applause. My young friends wished to have a nearer view of her, and I accordingly went behind the scenes, where she was just undressed, and stood naked as a little Cupid before the looking-glass. Her part was finished for the night; and as soon as she was dressed again I took her in my arms, and brought ‘l'enfant prodige,’ as she was called in the bills, in triumph to the box. After the first caresses were over, the little creature was the most attentive spectator of the performance among us, though one might have thought she had enough of it every day. Only a paper of sweetmeats which I gave her had power to distract her attention for a few minutes. She sat for some time on the lap of the elder Miss ——, who put her down rather suddenly, and accidentally scratched the child's arm against a pin in her dress, so as to draw blood. We were all afraid she would cry; but the miniature 



---

p.433


**Napoleon** was only angry, beat the offender as hard as she could, and cried out indignantly, ‘Fy, for shame, you stung me like a bee!’ With that she sprung on the lap of the younger, laid her little arms over the edge of the box, and fixed her eyes again with undisturbed attention on the Siege of Saragossa. Between the acts Lady C——, to whom I had related the laughable mistake concerning me in **Limerick**, told her I was **Napoleon**'s son. She turned quickly round, looked at me fixedly for awhile, and then exclaimed with the most serious ‘grandezza,’ ‘O, I have played your father very often, and always gained uncommon applause by it.’ Thus natural, droll, and completely free from embarrassment, the little thing captivated us all: and we saw with regret the end of the performance approaching—the signal for us to part with her. She would not let anybody but me carry her down, because I had brought her up. When we arrived behind the scenes, where every place was filled with horses, I scarcely knew how we should get through. She cried out eagerly, while she slapped my arm impatiently with her little velvet hand, ‘Come, are you afraid? only do you go on, I'll keep the horses in order;’ and so saying she distributed to the right and left, blows on the noses of her old acquaintances, who obediently made way for us to pass. ‘Now set me down!’ said she; and scarcely did her feet touch the ground, when with the swiftness of a little hare she flew across the back part of the stage, and vanished in the crowd. Children are certainly the most graceful of all creatures when they are not crippled and distorted by education: seldom, however, does so much genuine nature appear on the stage, yet seldomer perhaps on the theatre of the great world.


### Nov. 18th


I forgot to mention to you that I have met **O'Connell** again here. I heard him speak at the meetings of the **Catholic Association**, the present **Irish Parliament**, which I visited to-day for the second time. I was received, as a well-disposed foreigner, with applause, and **O'Connell** immediately made room for me between himself and Lord C——. The room is not very large, and as dirty as the English House of Commons. Here too every man keeps his hat on, except while he is speaking: here too are good and bad orators; but certainly occasionally less dignified manners than there. The heat was suffocating, and I had to sit out five hours; but the debate was so interesting that I scarcely remarked the annoyances. **O'Connell** was undoubtedly the best speaker. Although idolized by the greater number, he was severely attacked by several, and defended himself with equal address and moderation: on the other hand, he assailed the Government without reserve; and in my opinion in too strong expressions. It was easy to perceive that much intrigue and several firmly united parties, whose minds were made up beforehand, were to be found here, as in other bodies of the like kind, and consequently that the discussion was often only a sort of sham-fight. The leaders at least had however studied their parts well. The three most prominent speakers are **O'Connell**, **Shiel**, and **Lawless**. Mr. Fin and Mr. Ford also spoke well, and with great dignity of manner. **Shiel** is a man of the world, and has even more ease in society than **O'Connell**: but as a speaker he appeared to me too affected, too artificial; and all he said, too much *got up;* his manner was theatrical, and there was no real feeling in the ‘delivery’ of his speech, as the English expressively call it. I am not surprised that,



---

p.434



in spite of his undoubted talents, he is so much less popular than **O'Connell**. Both are very vain, but the vanity of **O'Connell** is more frank, more confiding, and sooner satisfied; that of **Shiel**, irritable, sore, and gloomy. The one is therefore, with reference to his own party, steeped in honey; the other in gall; and the latter, though contending for the same cause, is evidently jealous of his colleague, whom he vainly thinks to surpass. Mr. L——s is the Don Quixote of the **Association**. His fine head and white hair, his wild but noble dignity, and his magnificent voice, excite an expectation of something extraordinary when he rises: but the speech, which commences in an earnest tone, soon falls into the most incredible extravagancies, and sometimes into total absurdity, in which friend and foe are assailed with equal fury. He is therefore little heeded; laughed at when he rages like King Lear, unmindful of his audience, and of all that is passing around him. The dominant party, however, use him to make a noise when they want him. To-day he outdid himself to such a degree in the flight he took, that he suddenly erected the standard of Deism in the midst of the Catholic, arch-**Catholic Association**. Perhaps, indeed, this was only done to give occasion to **O'Connell** to call him indignantly to order, and to bring in a pious tirade; for on the orator's rostrum as on the tub, on the throne as in the puppet-show booth, clap-traps are necessary.


I rested myself this evening in the accustomed place. ‘Tableaux’ were again the order of the day. I had to appear successively as Brutus, an Asiatic Jew, Francis the First, and Saladin. Miss J—— was a captivating little fellow as a student of **Alcala**; and her eldest sister, as a fair slave, a welcome companion to Saladin. As the beautiful Rebecca she also assorted not ill with the Oriental Jew. All these metamorphoses were accomplished by the mother with the help only of four candles, two looking-glasses, a few shawls and coloured handkerchiefs, a burnt cork, a pot of rouge, and different heads of hair. Yet Talma could not have dressed Brutus better, nor altered the physiognomy more completely, than with these slight materials Lady C—— had the skill to do.


To conclude, we drew caricatures, and at my request each sister attempted a portrait of the other. Both succeeded very well, and are now placed in my gallery.


### Nov. 19th


To-day I found myself compelled to do something which was very disagreeable to me, and which I had long deferred; I was obliged to resort to my ‘grand expedient,’ in order to conquer my aversion. You will laugh when I tell you what this is; but I find it a powerful aid in great things as well as in small. The truth is, there are few men who are not sometimes capricious, and yet oftener vacillating. Finding that I am not better than others in this respect, I invented a remedy of my own, a sort of *artificial resolution* respecting things which are difficult of performance,—a means of securing that firmness in myself which I might otherwise want, and which man is generally obliged to sustain by some external prop. My device then is this:—I give my word of honour most solemnly



---

p.435



to myself, to do, or to leave undone, this or that. I am of course extremely cautious and discreet in the use of this expedient, and exercise great deliberation before I resolve upon it; but when once it is done, even if I afterwards think I have been precipitate or mistaken, I hold it to be perfectly irrevocable, whatever inconveniences I foresee likely to result. And I feel great satisfaction and tranquillity in being subject to such an immutable law. If I were capable of breaking it after such mature consideration, I should lose all respect for myself;—and what man of sense would not prefer death to such an alternative? for death is only a necessity of nature, and consequently not an evil;—it appears to us so only in connexion with our present existence; that is to say, the instinct of self-preservation recoils from death; but reason, which is eternal, sees it in its true form, as a mere transition from one state to another. But a conviction of one's own unconquerable weakness is a feeling which must embitter the whole of life. It is therefore better, if it comes to the struggle, to give up existence for the present with a feeling of inward triumph, than to crawl on with a chronic disease of the soul. I am not made dependent by my promise; on the contrary, it is just that which maintains my independence. So long as my persuasion is not firm and complete, the mysterious formula is not pronounced; but when once that has taken place, no alteration in my own views—nothing short of physical impossibility—must, for the welfare of my soul, alter my will. But whilst I thus form to myself a firm support in the most extreme cases, do you not see that I also possess a formidable weapon of attack, if I were compelled to use it, however small and inconsiderable the means may appear to many? I, on the contrary, find something very satisfactory in the thought, that man has the power of framing such props and such weapons out of the most trivial materials, indeed out of nothing, merely by the force of his will, which hereby truly deserves the name of omnipotent. I cannot answer for it that this reasoning will not appear to you, dear Julia, distorted and blameworthy: indeed it is not made for a woman; while on the other hand a completely powerful mind would perhaps as little stand in need of it. Every man must however manage himself according to his own nature; and as no one has yet found the art of making a reed grow like an oak, or a cabbage like a pine-apple, so must men, as the common but wise proverb has it, cut their coat according to their cloth. Happy is he who does not trust himself beyond his strength! But without being so tragical about the matter, this *grand expedient* is of admirable use in trifles. For example, to fulfil tedious, irksome duties of society with the resignation of a calm victim,—to conquer indolence so as to get vigorously through some long deferred work,—to impose upon oneself some wholesome restraint, and thus heighten one's enjoyment afterwards,—and many, many more such cases, which this occasionally sublime, but generally childish life presents.


After dinner, to drive away blue devils, I took a long ride into the country towards the mountains. After riding about twelve miles I came to a bare region of interminable bog extending in all directions. You would have thought yourself a hundred miles from any capital. The character of the country was not wild, not so desert as a plain of sand, but awfully void, lonely, and monotonous. One single wretched cabin was visible, but in ruins, and uninhabited; and a white footpath winded along toilfully through the brown heather, like a huge worm. The whole ground



---

p.436



was lightly powdered with snow, and the wind blew icy cold over the bare heights. Nevertheless the melancholy of the scene had such a strange attraction for me, that necessity alone made me turn my horse's head homewards. Nearer to **Dublin** I found an isolated mountain, on which was a strange caprice;—a house built in imitation of a rock; and in fact so like one, that it deceived me till I saw the entrance. I reached my inn by moonlight, with a face burning with the keen air. I had invited **Father L'Estrange** to dine with me, ‘car j'aime les prêtres, comme **Voltaire** la Bible, malgré tout ce que j'en dis.’


I found too a letter from you; but I must complain that you do not write to me sufficiently in detail. Do consider that every trifle from home is precious. Whether my favourite horse is well; whether my sweet little friend the parroquet sometimes calls on my name; whether your domestic tyrant Fancy is more or less naughty; whether the parrots are ‘in good spirits,’ the new plantations thriving, the visitors to the baths gay;—all these particulars have an extraordinary interest at a distance of some hundreds of miles. But I see clearly that if I have a mind to know all these things I must take you by surprise, if it be but for one day. You know that I hate all scenes and solemnities, all tumultuous meetings, and all leave-takings; ‘un beau matin’ therefore you will find me comfortably established in your breakfast-room, where I shall receive you with a smile, as if my long journey had been but a dream; ‘et toute la vie, hélas! est elle autre chose?’ Seriously, we ought to learn to take all these things much more coolly and easily than we fancy possible.—An English dandy may serve you as an admirable model. His best friend and comrade was going to India; and in his emotion at taking leave of him, was going to grasp both his hands, and to shake them perhaps for the last time: the ‘Incroyable,’ half warding him off, held out the tip of his little finger to him, while he lisped smiling, ‘Strange and horridly fatiguing English custom, for two men to move each other's arms up and down like the handle of a pump!’


Your portrait did not give me so much pleasure as it ought. The features are much too hard, and must be ‘softened’ before it can pass as a representative of the original,—whose image, however, is too vividly pressed on my heart to want any refreshing.


Your ever faithful

 L——
### **Dublin**, November 20th, 1828

Beloved friend,


I frequently meet a man here, B— H—, whose company is highly interesting to me. Although a clergyman, he is one of the few independent thinkers who are able to throw off the tyranny of early impressions and old habits, and to see by the light of reason, in other words, of divine revelation, alone. In his opinion, too, a crisis in religious affairs is at hand. ‘Ecclesiastical establishments,’ said he to-day, ‘are manifestly the monstrous offspring of the sublime and the ridiculous, of eternal truth and dark ignorance, of genuine philosophy and gross idolatry. The more men learn, the more science enables us to understand external nature and the nature of our own being by well-established facts, the milder, the more moral will our manners as well as our governments become. More slowly,



---

p.437



religions will follow. Even the Christian religion, though in its origin one of the mightiest efforts towards the amelioration of mankind, ever prompted by the deepest meditation, and the purest heart has, as the history of our church shows in almost every page since its establishment, deluged the world a hundred times with blood, and given birth to a succession of the most frantic absurdities; while philosophy and science have continually acted as humanizers, without ever demanding such victims, or committing such outrages. The question is, whether **Newton**, in discovering the secrets of Heaven,—whether the inventors of the compass or the printing-press,—have not done more for mankind, *i. e.* more to further the progress of civilization, than any of the numerous founders of sects and religions, who require that men should swear exclusive allegiance to them. There may, indeed, come a time in which religion and poetry will be regarded as sisters,—in which a religion of state will appear as ludicrous as a poetry of state. Were I a Turk, I should say to myself, It is certainly difficult to get so entirely free of all the prejudices and superstitions of childhood, as to regard the persuasion of millions, with a firm unshaken eye, as folly: but having once convinced myself that it is so, I will not remain a Turk. As Christian, I say, I will adhere to the *pure doctrine* which my reason can revere; but I will have the courage to reject the mass of unpoetical fables, and all the misrepresentations and disfigurements of the time of its birth, and still more the bloody and ferocious heathenism incorporated with it by succeeding ages, even though two hundred millions of men should sincerely receive them as divine, on the authority of men erring as themselves. This was the principle on which **Luther** acted, when he took the first steps towards Reform; but the light which he purified stands greatly in need of a fresh cleansing. Honour and reverence be to the churchman who shall be great and pure-minded enough to feel himself called to this god-like work! who shall endeavour to execute it without compromise or fear of men, though the multitude of hypocrites and pharisees will cry out against him; for history clearly shows that he has nothing else to expect.’


‘Has it not ever been the few who have seen and acknowledged the better and the true? Has it not ever been the many who have proscribed and persecuted them? Was truth on the side of the fanatical herd who gave the poison-cup to Socrates? or of that which crucified Jesus? or of that which burnt **Huss**? No; it was not till centuries afterwards that the multitude embraced the persecuted faith, and hardened themselves into the same stubborn and furious orthodoxy for it, which they had displayed against it. The want of a religion is unquestionably one of the most imperious cravings of our nature, especially where laws and institutions are yet in their infancy. He who cannot frame one for himself, must receive the *form* of it from others:—such will always be the many. This easily explains the grounds upon which the power of the church and the priesthood must ever rest, and why men are thus kept in leading-strings for hundreds, nay thousands of years. But to strengthen and perpetuate this power, knowledge must always be repressed in favour of faith. Where inquiry is free, one fraud after another disappears, though slowly;—light bursts at length even upon the darkest corner. When this point is once reached, the fetters laid upon conscience are broken, and every individual demands a boundless field for the exercise of his faith and of his judgment. Absolute sultans, fat dervises, and haughty satraps, must then fall together, like the dead lees in generous wine. How miserable a figure do those make, who, at the dawn of such a day, think they can stop the



---

p.438



rising of the sun by turning their backs upon it, or by holding their antiquated, decayed, and worm-eaten screen, which is no longer in a state to exclude even a moonbeam, before their eyes! They may for a while succeed in keeping *themselves* in the shade, but they cannot shroud the bright forehead of the day. On the contrary, their struggles, as impotent as they are passionate are the surest harbingers of its inevitable approach.’ I agree, for the most part, with B—— H——; but whether his sanguine hopes will so soon, or indeed ever on this earth, be realized, is another question. That the world can no longer be governed on jesuitical principles, and that the liberty of the press, if firmly maintained, works, and will work, incalculable wonders, I am well convinced:—but men will still be men, and force and fraud will, I fear, ever predominate over reason.


In the forenoon I visited the courts of justice with **Father L'Estrange**, to hear the military-looking **O'Connell** plead, in his powdered long-tailed wig, black gown, and bands. We afterwards went to the meeting of the **Association**, to see the great Agitator in a totally different character. The meeting was very stormy. Mr. L——s spoke like a madman, and attacked **O'Connell** himself so violently that he almost lost his wonted dignity. He made an admirable reply; though he strained too much after wit, which was not always in the best taste. After this, a dozen spoke at once. The secretary called to order, but had not authority enough to enforce obedience. In short, the scene began to be rather indecorous, till at last a handsome young man with enormous whiskers and an ‘outré’ dress, (the dandy of the **Association**,) sprang on the table, and uttered a thundering speech which, obtained great applause, and thus restored peace.


I dined at Lady M——'s. She had invited me by a note, such as I have received a dozen of during my stay here:—I must mention them as characteristic, for I never in my life saw worse calligraphy or a more negligent style from a lady's pen. The aim of the great authoress was manifest;—to announce the most perfect ‘insouciance,’ the most entire ‘abandon,’ in the affairs of ordinary life; just as the great solo dancers in **Paris** affect to walk with their toes turned in, that they may not betray the dancer by profession. At table Lady M——, with her aid-de-camp K. Cl——, ‘faisoient les frais d'esprit obligé.’ **Mr. Shiel**, too, appeared in the character of an agreeable man of the world. The most amusing part of the entertainment, however, was the acting of proverbs by Lady M—— and her sister, who both extemporized admirably in French. Among others, they performed ‘Love me, love my dog,’ as follows:
  

Dramatis personae:—Lady M——, an old coquette; Lady C——, an Irish ‘fortune-hunter;’ her eldest daughter, the French femme-de-chambre; the youngest, a captain of the Guards, a lover of the lady. Scene the first:—Lady M—— with her maid at her toilet. Confidential advice of Josephine, in the course of which she betrays various laughable secrets of the toilet. Distress of the coquette at the first appearance of wrinkles. Assurances of the Abigail that, by candle-light, nobody can be handsomer. As a proof of this, the various lovers are adduced, and love-affairs of former times recapitulated. ‘La comtesse convient de ses conquêtes,’ and with much humour draws a picture of her triumphs. ‘Chut!’ cries the waiting-maid, ‘j'entends le capitaine.’ This personage, an exclusive, enters with great ‘fracas,’ carrying a little dog under his arm, and after some tender compliments tells her that he is obliged to rejoin his regiment, and wishes to leave her his little Fidèle,



---

p.439



that the fair countess may never forget to remain ‘fidèle’ to him. Burlesque protestations, sobs, embraces, farewells. Scarcely is the captain gone, when the Irishman appears with a marriage-contract in his hand, by which the countess is to assign over her whole fortune to him. Like a man well versed in womankind, he treats her somewhat cavalierly, though with a display of passion, so that after a feeble defence and a little scene, she consents. Meanwhile the Irishman observes the little dog, and asks with some surprise whose it is. She stammers out a sort of apologetic answer. O'Connor MacFarlane now plays the part of the infuriate jealous lover. The women vainly attempt to appease him; he storms, and insists on the instant dismissal of the intruder. The countess makes an attempt to faint—but all is in vain; even Josephine, who during the discussion of the marriage-contract has just received a purse behind her mistress' back, takes the part of the incensed Irishman, who with one hand holds back his lady, and with the other at length throws the unfortunate little dog out at the door. But, alas! at this very moment the captain returns to bring the collar which he had forgotten, and Fidèle jumps into his arms. The terrified women take to flight; the men measure each other with their eyes. O'Connor MacFarlane utters dreadful menaces; but the captain draws his sword, and his antagonist jumps out at the window,—The skeleton is meagre; but the spirit, humour, and wit, by which it was filled out, rendered it extremely entertaining. The imperfections of the costume made it only more piquant. The ladies, for instance, had put on a coat and waistcoat over their own dresses, and stuck a hat on their heads; their swords were riding-whips, and Fidèle a muff.


Lady M—— afterwards related to me many interesting circumstances respecting the celebrated Miss O'Neil, whom, as you know, I regard as the greatest dramatic artist it has ever fallen to my lot to admire. She said that this extraordinary young woman, who from the very commencement of her career had given evidence of the highest genius, remained utterly neglected at the theatre in **Dublin**, where she performed for some years. She was at that time so poor, that when she returned home at night after the greatest exertions, she found no other refreshment than a plate of potatoes and a miserable bed which she shared with three sisters. Lady M—— once visited her, and found the poor girl mending her two pair of old stockings, which she was obliged to wash daily for her appearance on the stage. Lady M—— now procured for her various articles of dress, and took upon herself in some degree the care of her toilet, which had been extremely neglected. She obtained more applause after this, though still but little. At this time one of the managers of the **London** theatres accidentally came to **Dublin**, saw her, and had the good taste and judgment immediately to engage her for the metropolis. Here she at once produced the most extraordinary sensation; and from a poor unknown young actress, rose in one moment to be the first star of the theatrical firmament of **England**. I still remember her acting with rapture: I have never since been able to endure the part of Juliet, played even by our best actresses; all appear to me stiff, affected, unnatural. One must have seen the whole thread of the life of the *Shakespearian* Juliet thus spun before one's eyes to conceive the effect. At first, it was only the sportive youthful joyousness of the caressing child: then, when awakened by love, a new sun appeared to rise upon her; all her attitudes and movements assumed a more soft, voluptuous air; her countenance, her whole person became radiant,—she was the



---

p.440



southern maiden devoting her whole soul and life to her beloved with all the fire of her clime. Thus did she burst into the loveliest and richest blossom;—but care and sorrow soon ripened the noble fruit before our eyes. The most imposing dignity, the deepest conjugal tenderness, the firmest resolve in extremity, now took the place of glowing passion, of the quick sense which seemed framed but to enjoy:—and how was her despair depicted at the last, when all was lost! How fearful, how heart-rending, how true, and yet how ever beautiful, did she know how to rise even to the very last moment! Certain of her aim, she sometimes ventured to the very utmost verge of her art, and did what no other could have attempted without falling into the ridiculous: but in her, it was just these efforts which operated as electric shocks. Her madness and death in Belvidera, for instance, had such a terrific physical truth, that the sight of it was hardly endurable; and yet it was only the agony of the soul, showing through every fibre of her body, which had an effect so powerful, so almost annihilating, on the spectator. I remember well that on the evening in which I saw that, I remained wholly insensible to any physical impression; and even the next morning, when I awoke, wept bitterly over Belvidera's fate. I was certainly very young then, but my feelings were those of many; and it was a striking fact, that Germans, Frenchmen, and Italians, were equally enthusiastic admirers of her; though, generally speaking, one must have a thorough knowledge of the language and character of the nation, to feel perfectly satisfied with its actors. *She,* however, had no trace of mannerism; it was only human nature in its truest and noblest form, which spoke to every human heart. She could not be properly called beautiful; yet she had a stately person, noble shoulders and arms, and beautiful hair. But her peculiar charm was that indefinable pathetic expression which at the first glance moved the inmost feelings of the heart. In such features, you think you discover the trace of every passion, though an unearthly calm is spread over them like ice over a volcano.


The inhabitants of **Dublin** had long remained blind to so much genius and talent; but the year after, when the celebrated, admired, adored Miss O'Neil returned from **London** to act a few of her most popular parts, the infectious enchantment was so powerful, that not only the whole public was in the greatest state of tumult and agitation, but many ladies were carried out from the theatre fainting. One became really insane from witnessing Belvidera's madness, and actually died in a mad-house. Really such facts as these render the enthusiasm of the many almost disgusting.


This great actress was also distinguished for her remarkably amiable character: she entirely supported her family, even at the time of her greatest poverty. She made her first appearance at a little private theatre in the country: this was afterwards shut, and only occasionally used by a dilettanti company, when the profits of their performance were given to the poor of the county. They wrote to Miss O'Neil, who was then in **England**, and begged her to consecrate this place, which had witnessed her first efforts, by the last triumph of her genius, now the admiration of the three kingdoms; whatever terms she might propose would be agreed to. She replied, that she felt herself extremely flattered and honoured by the request; but that so far from accepting any pecuniary compensation, she would gladly seize the opportunity of offering this tribute to the cradle of her humble talents. Only on this condition, and that of being allowed to contribute her mite to her poor countrymen, would she appear



---

p.441



on the day appointed.—I was assured by eye-witnesses that they had never seen a more perfect piece of acting than her's on this occasion. Never had Miss O'Neil been better supported,—never did she so surpass herself. It was a curious accident that a young Irish gentleman of fortune fell in love with her that very day, and shortly after married her. He robbed the public of an inestimable treasure; but who can blame him? Miss O'Neil has now several children, is still charming, and lives happily on her husband's property. She has never trodden a stage, either public or private, since her marriage.


*[The conclusion of this letter, which, as it appears from the beginning of the following one, contains a description of some public entertainments and occurrences, is missing.]*


### **Dublin**, December 7th, 1828

Dear Julia,


The descriptions of public dinners and the [*gap: deleted/extent: one line and a half*] are now at an end, and I must conduct you to a breakfast at the Post-office. The Director, **Sir Edward Lee**, a very agreeable and accomplished man, who gave the entertainment, first conducted us, in company with a number of elegant ladies, through the various offices ‘pour nous faire gagner de l'appetit.’ In one of them, called the ‘Dead Letter Office,’ a very strange incident occurred in our presence. All letters, the address of which is unintelligible, or which are addressed to persons who cannot be discovered, are taken into this office, where they are opened at the end of a fortnight, and, if they contain nothing important, burnt. This seems to me rather a barbarous custom, since many a heart might be broken from the loss of what a Post-office clerk might think ‘of no importance.’ So it is, however, and we found three men busied in the operation. Several of us seized these doomed epistles, and turned them over with great curiosity, when the clerk who stood nearest to me took up rather a large packet on which there was no address whatever, only the post-mark of an Irish country town. How great was his surprise and that of all of us, when on opening it we saw not a single line of writing, but £2700 in bank-notes! This, at least, appeared ‘of importance’ to all, and an order was immediately given to write to the town in question to make inquiry about it.


In the evening I went to pay the ‘nightingales’ a visit, but found them flown, and only their father at home, with whom I had a scientific conversation. He showed me several curious newly-invented instruments;—one among them for ascertaining the exact strength of the lungs, and therefore invaluable in consumptive diseases. He told me that a person high in office was given over last year by all of the most eminent physicians in **Dublin**, as far gone in pulmonary consumption. Believing his danger to be imminent, he had made up his mind to give up his place, and to go to **Montpellier**, as the only means of prolonging his life. Sir A—— was at last consulted, and resolved to try this instrument, which he had just received from **London**. Scarcely could he *believe* his eyes



---

p.442



when he found on experiment that the lungs of the patient were two degrees stronger than his own,—he being in perfect health. The disease was now discovered to be in the liver, though it had exhibited every symptom of consumption; and in four months the patient was entirely cured, and kept his lucrative place which he had determined to give up.


I shall not describe to you the various instruments of torture which I saw; ‘tant pis pour l'humanité, qu'il en faut tant.’ A prettier thing was a barometer, in the figure of a lady, who at the approach of bad weather holds up her umbrella, in a hard rain opens it, and in settled fine weather uses it as a walking-stick. To use a lady as a continually changing prophet of weather. ‘Quelle insolence!’


### December 8th


Sir A——, who has a place in the Bank, showed that building to me this morning. The edifice is fine, and formerly served as a place of meeting for both houses of the **Irish Parliament**, whose restoration is now so ardently desired. The thing most worth seeing is the printing of bank-notes. The whole machinery is moved by a magnificent steam-engine, while a smaller one fills the boiler with water and the furnace with coals, so that human assistance is scarcely wanted. In the first room the printing ink is prepared; in the next the bank-notes *receive* their various marks and ornaments. This process is very rapidly performed. Only one man is employed at each press; and while he places the blank papers, one after another, under the stamp, the number of printed notes marks itself in the inside of a closed box. In the next room they are numbered. This is done on a small chest; and the machinery numbers them, as if by invisible hands, from one to a thousand. The man employed there has nothing to do but to blacken the numbers as they come out with printer's ink, and to lay the notes in their proper order. All the rest is accomplished by the machine.


Every note which returns to the Bank after circulation is immediately torn, and kept seven years, at the expiration of which time it is burnt. This last operation leaves a residuum of indigo, copper, and the materials of the paper, which looks like metal, and glitters with all the colours of the rainbow. Of course many hundred notes go to make up an ounce of this substance, of which I carried away a beautiful piece.


We afterwards ascended the roof of this great building, a sort of world in miniature, whence, like the ‘Diable Boiteux,’ we could see into the surrounding houses; but at length so confused ourselves, that we thought we should need Ariadne's clue to enable us to find our way down again. I arrived too late, in consequence, at dinner at Sir E—— L——'s; a thing which is not taken so ill in **England** as with us.


### Dec. 9th


**Lord Howth** invited me to a stag-hunt, whence I am just returned, equally tired and pleased. My lessons in **Cashel** were now of great use to me, for **Lord Howth** is one of the best and most determined riders in **Great Britain**. He had given me a very good horse, in spite of which I fell twice: this also happened once to **Lord Howth** himself, and I followed him so well that I think I brought no discredit on our cavalry. At length more than two-thirds of our fifty red-coats were missing. I was particularly struck with an officer who had lost an arm, and nevertheless



---

p.443



was one of the first: his admirable horse had not refused or missed a single leap.


This sort of hunt is a very agreeable diversion now and then; but how a man can devote himself to so utterly unintellectual an amusement three times a week, for six months of every year, and always pursue it with the same passion, does, I own, remain unintelligible to me. What, besides, makes stag-hunting much less interesting in **England** than on the continent, is, that the stags are tame, and are trained to the sport like race-horses. They are brought to the place of rendezvous in a kind of box, and there turned out. When they have run a certain distance, the hunt begins, and before it ends the hounds are called off, and the stag is put into the box again and kept for another hunt. Is not this horribly prosaic, and scarcely compensated by the ‘agrément’ of being in continual risk of breaking one's neck over a wide ditch, or one's head against a high wall?


### December 10th


For some weeks past I have been a frequent visitor at the Gymnastic Academy. These exercises are become very fashionable in **Great Britain** and **Ireland**. Certainly they are of inestimable value in the training of youth; they are a highly improved Turnen, but without politics. When one considers what facilities are now at hand for the physical as well as moral education of man; how those whom nature has misshapen are placed within cases of iron till they are transformed into Apollos; how noses and ears are created; and how academies are daily advertised in the newspapers, in which the most profound erudition is engaged to be communicated in three years,—one really longs to be a child again, that one might come in for a share of all these advantages. It appears as if the law of gravitation operated in the moral as well as in the physical world, and that ‘the march of intellect’ went on in an increasing ratio like the rapidity a falling cannon-ball. A few more political revolutions in Europe, the perfecting of steam-power for soul and body, and God knows what we may get to, even without the discovery of the art of steering air-balloons. But to return to the Gymnasium, the utility of which, at least, is undoubted. It strengthens the frame to such a degree, and imparts such agility to the limbs, that a man really doubles or trebles his existence by it. It is literally the fact, that I saw a young man, the arch of whose breast, after an uninterrupted practice of three months, had increased seven inches; the muscles of his arms and thighs had at the same time enlarged to three times their volume, and were as hard as iron. But even much older people,—men of sixty,—though they cannot expect to effect such changes, may strengthen themselves very considerably by moderate exercise in the gymnasium. I constantly found men of this age, who played their part very well among the young ones who had but recently begun. Some perseverance is however necessary; for the older a man is, the more painful and fatiguing is the beginning. Many feel themselves for months as if they had been on the rack, or were set fast with universal rheumatism. A Frenchman was at the head of the establishment, although his predecessor had sacrificed himself, two years before, to the glory of



---

p.444



his art: his name was Beaujeu. He was endeavouring to show two ladies, (for there are also feminine gymnastics,) how easy exercise No. 7. was. The pole broke, and s did, in consequence of his fall, his spine. He died in a few hours; and, with an elevation and enthusiasm worthy of a greater cause, exclaimed with his last breath, ‘Voilà le coup de grâce pour la gymnastique en Irlande.’ His prediction however, was not fulfilled, for both gentlemen and ladies are more gymnastically-minded than ever.


### **Dublin**, December 14th


As I have been unwell for several days and unable to go out, I have no interesting news to give you. You must therefore receive with indulgence a few detached thoughts, the offspring of solitude; or if they tire you, leave them unread.


#### PARLOUR PHILOSOPHY


What is good or evil fortune? As the former has seldom fallen to my lot, I have often proposed the question to myself. Blind and accidental, it certainly is not; but necessary, and part of a series, like every thing else in the universe, though its causes do not always depend on ourselves. How far, however, we really have it in our power to bring it on ourselves, is a salutary inquiry for every one. Lucky and unlucky occasions present themselves to every man in the course of his life; and the art of seizing the one and averting the other with address, is commonly what procures for a man the reputation of fortunate. It cannot however be denied that, in the case of some men, the most powerful and the wisest combinations continually fail, by what we call accident; nay, that there is a sort of secret foreboding or presentiment, which gives us the dim feeling that our project will not succeed. I have often been tempted to think that luckiness and unluckiness are a sort of subjective properties which we bring with us into the world, like health, strength, a finely organized brain, and so on; and whose preponderating power must always attract things magnetically to themselves. Like all other properties, this of luckiness may be cultivated or let to lie dormant, may be increased or diminished. The will does much; and thence the proverbs, Nothing venture nothing have, (Wagen gewinnt:) Boldness and luck go together, (Kühnheit gehört zum Glück.) It is also observable that luckiness, like the other faculties, falls off with age, that is, with the vigour of the material. This is certainly not the consequence of weaker or more ill-advised plans or rules, but appears truly to be the decline of a secret power which, so long as it is young and vigorous, governs fortune, but in later years is no longer able to hold her in. High play affords very good studies on this subject; and perhaps this is the only poetical side of that dangerous passion: for nothing affords so true a picture of life as the hazard-table; nothing affords a better criterion to the observer, by which to try his own character, and that of others. All rules which avail in the struggle of life, avail also in this; and penetration combined with energy is always sure, if not to conquer, at least to make a very able defence. But if it is combined with the talent or gift of luckiness, a sort of **Napoleon** of the gaming-table is the result. I am not now speaking of that class of gentlemen ‘qui corrigent la fortune.’ But even here the resemblance is still true: for how often in the world do you meet men who govern fortune by



---

p.445



fraud?—the most unfortunate, be it said by the by, of all speculators. Their occupation is truly drawing water in a sieve; the collecting of rotten nuts. For what is enjoyment without security? and what can outward fortune avail where the internal equilibrium is destroyed?


There are men who, although endowed with distinguished qualities, never know how to make them available in the world, unless they have been from the beginning of their career placed by fate in their right position. They can never reach it by their own efforts; because a too feminine fancy, liable to the constant impression of extraneous forms, prevents them from seeing things as they really are, and causes them to live in a world of airy floating phantasms. They set about their projects with ardour and talent; but their fancy hurries after, mounted on her poetical steed, and conducts them so rapidly through her kingdom of dreams, to their end, that they can no longer endure the slow and weary journey through the difficulties and obstacles of the real road. Thus they suffer one project after another to fall to the ground before it has attained to maturity. And yet, like every thing else in the world, this unfortunate turn of mind has its advantages. It prevents a man, indeed, from making his fortune, as it is commonly called, but affords incalculable comfort under misfortune, and an elasticity of spirit that nothing can entirely crush,—for the race of pleasure-giving creatures of the imagination is absolutely inexhaustible. A whole city of castles in the air is always at the command of mortals of this class, and they enjoy, in hope, an everlasting variety of realities. Such people may be of infinite use to other more sedate, reflecting, and matter-of-fact men, if these latter do but understand the art of awakening their enthusiasm. Their intellectual faculties derive from a positive steady *purpose,* and from the constraint which it imposes, a degree of constancy and persevering energy which their own interest could never have inspired; and their ardour is more durable for the good of others than for their own. From similar causes, if they are placed by some superior power on the summit of the hill from the commencement of their lives, they will accomplish great things by themselves; for in this case the most grand and varied materials are already furnished; and along with them, the enthusiasm which persons of this character want, is produced, and fixed on some adequate and determinate object. There is nothing entirely new, uncertain, and baseless to create or to found;—only to employ, to improve, to elevate, to adorn, what already lies under their eye and hand, with the acuteness and address of a skilful artist. From, such an eminence, which is their proper station, their keen, far-sighted glance, supported by a thousand executive heads and hands, strengthened by their own inward poetic eye, will reach further than that of more every-day natures. But at the foot or on the slope of the hill this acuteness of the mental sight is of no use to them, because their horizon is bounded; and for climbing the toilsome ascent, their indolent limbs will not serve them, nor could they resist the airy phantoms which would tempt them from their path. They live and die, therefore, on the hill, without ever reaching its summit, and consequently without ever being fully conscious of their own power. Of such men, the well-known saying might be reversed, and we might say with truth, ‘Tel brille au *premier* rang qui s'éclipse au *second.*’


However beautiful and noble the words Morality and Virtue may sound, the universal distinct recognition of them as *the useful* is the only thing that will be truly salutary and beneficial to human society. He who



---

p.446



clearly sees that the sinner is like the savage who hews down the whole tree in order to come at the fruit, often sour, or tasteless, or unwholesome; while the virtuous man is like the prudent gardener who, waiting their maturity, gathers all the sweet produce, with the joyful consciousness that he has destroyed no future crop;—this man's virtue will probably stand on the most secure basis. The more enlightened men in general are, as to what is good or profitable for them, the better and more humane will their manners and conduct towards each other become. Action and reaction will then proceed in a beneficent circle;—enlightened individuals will establish better forms of government and better institutions, and these again will increase the intelligence of all who live under them. If matters once reached such a point, that a truly rational and elevating system of education freed us from the chimeras of dark times, dismissed all constraint on religious opinions among other obsolete absurdities, while it clearly demonstrated the inward and outward necessity of Love and Virtue to the happy existence of human society; while by the establishment of wise, firm, and consistent laws and political institutions, sprung from the conviction of this necessity, it imposed sufficient restraint to ensure the permanent adherence to these by the salutary habits produced,—Paradise would exist on earth.


Mere penal laws, whether for here or hereafter, without this profound conviction,—all worldly policy, in the sense of clever, adroit knaves,—all prophets, all superhuman extra-revelations, heaven, hell, and priests,—will never bring us to this: indeed, so long as all these hang on the spokes, the wheel of improvement will revolve but slowly and painfully. For this reason, so many strive with all their might against such a result; nay, even Protestants *protest backwards,* and many desire to establish a new continental embargo to shut out foreign light.


‘Au reste,’ one cannot take it amiss of any man ‘qu'il prêche pour sa paroisse.’ To require from an English archbishop with 50,000*l.* a year that he should be an enlightened man, is as preposterous as to expect from the Shah of Persia that he should transform himself into a constitutional monarch of his own free will. There are few men who would voluntarily refuse a rich and splendid sinecure, where nothing is required of them but to fling a little dust in the people's eyes, or to be a despot ruling millions with his nod. It is the business of human society, if possible, to put things upon such a footing that none of us, be our good-will for it ever so great, can either get such a sinecure or become such a despot.


When I was a child, it often happened to me that I could get no rest for thinking of the fate of **Hannibal**, or that I was in despair at the battle of **Pultawa**;—now I am grieving over **Columbus**. We are greatly indebted to the distinguished American, **Washington Irving**, for this history. It is a beautiful tribute to the great navigator, brought from the land which he gave to the civilized world, and which appears destined to be the last station traversed by the cycle of human perfectibility.


What a man was this sublime endurer! Too great for his age: for forty years he was deemed by it but a madman; during the rest of his life he was the victim of its hatred and jealousy, under which he sank at length in want and misery. But such is the world: and would be enough to



---

p.447



make us mad, did we fix our minds upon particulars, and did not reflection soon teach us that for wise Nature the individual is nothing, the species every thing. We live for and through mankind, and every thing finds its compensation in the great whole. This reflection suffices to tranquillize any reasonable man; for every seed springs up,—if not exactly for the hand that sowed it, yet be it evil or good, not one is lost to the human race.


What has often and bitterly vexed me, is to hear people lament the wretchedness of this life, and call the world a vale of sorrows. This is not only the most crying ingratitude (humanly speaking,) but the true sin against the Holy Ghost. Is not enjoyment and well-being manifestly throughout the world the positive natural state of animated beings? Is not suffering, evil, organic imperfection or distortion, the negative shadow in this general brightness? Is not creation a continual festival to the healthy eye,—the contemplation of which, and of its splendour and beauty, fills the heart with adoration and delight? And were it only the daily sight of the enkindling sun and the glittering stars, the green of the trees and the gay and delicate beauty of flowers, the joyous song of birds, and the luxuriant abundance and rich animal enjoyment of all living things, it would give us good cause to rejoice in life. But how much still more wondrous wealth is unfolded in the treasures of our own minds! what mines are laid open by love, art, science, the observation and the history of our own race, and, in the deepest deep of our souls, the pious reverential sentiment of God and his universal work! Truly we were less ungrateful were we less happy; and but too often we stand in need of suffering to make us conscious of this. A cheerful grateful disposition is a sort of sixth sense, by which we perceive and recognise happiness. He who is fully persuaded of its existence may, like other unthinking children, break out into occasional complaints, but will sooner return to reason; for the deep and intense feeling of the happiness of living, lies like a rose-coloured ground in his inmost heart, and shines softly through the darkest figures which fate can draw upon it.


Paradoxes of my friend —— ——. Yes, certainly the spirit rules in us and we in it; and is eternal, and the same which rules through all worlds; but that which we call our human soul, we frame to ourselves here. The apparent double being in us,—of which one part follows the impulses of sense, while the other reflects upon the nature and movements of its companion, and restrains it,—naturally arises from the (so to say) double nature and destiny of man, who is framed to live as an individual, and also as an integral part of society. The gift of speech was a necessary condition of this latter form of existence, which without it could never have arisen. A solitary man is, and must remain, nothing better than an extremely intelligent brute; he has no more a soul than any other such:—the experiment may be repeated any day. But as soon as the man begins to live with other men, as soon as the interchange of observations is rendered possible to him by speech, he begins to perceive that the individual must submit to what is for the good of the whole—of the society, that is, to which he belongs; that he must make some sacrifices to its maintenance: this is the first rise of the moral principle, the essence of the soul. The feeling of his own weakness and uncertainty next gives birth to religion; the feeling of need of others like himself, to love. Selfishness and humanity now enter upon that continual antagonism which is called, I know not why, the inexplicable riddle of life; though



---

p.448



with my view of the matter, nothing appears to me more natural and consequential. The real problem for mankind is, merely to establish the proper balance between these two poles. The more perfectly this is attained, the better and the happier is thenceforward the condition of the man, the family, the state. Either extreme is pernicious. The individual who tries to benefit himself alone, must succumb at length to the power of the many. The romantic enthusiast who starves himself to feed others, will be called by men, (who are ready enough to admire any sacrifice made to them, though they often laugh at it too,) magnanimous, or foolish, according to their peculiar fancy: but such conduct can never be general, and can never become a *norma* or pattern for imitation—in other words, a *duty.* Martyrs who give themselves to the flames in honour of the sacred number three, or let the nails grow through the back of the hands to the glory of Brama, belong to this same class, though to the lowest step of it; and receive, according to the prevalent notions of their age, the appellation of saint or madman, but are at all events mere exceptions, (Abnormitäten.) Not that I mean to deny that a rational abnegation and sacrifice of oneself for the good of others is noble and beautiful: by no means. It is unquestionably a beautiful, that is, a beneficent example of the victory of the social over the selfish principle, which forms a refreshing contrast to the far too numerous instances of those whose views never extend beyond themselves, and who end in becoming the pitiless remorseless criminals against whom society is compelled to declare everlasting war. But since we are bound to ourselves more nearly than to society, by that law of self-preservation which is necessary to our existence, egotists are more common than philanthropists, vicious men than virtuous. The former are the truly rude and ignorant, the latter the civilized and instructed. (An ‘avviso’ by the by to all governments who wish to rule in the dark.) But as even the most civilized have a substratum of rudeness, just as the most highly polished marble when broken exhibits the rough grain beneath, philanthropy herself cannot deny that she is the offspring of self-interest,—that she is indeed only self-interest diffused over the whole of mankind.


Where this feeling, therefore, displays itself in a very grand and energetic manner, though it be for the sole advantage of the individual, the possessors of it, such as are commonly called great men and heroes, compel the admiration even of those who disapprove their course of action. Nay, experience teaches us, that men who, with consummate indifference to the good of others, have heaped innumerable sufferings on their fellow men, if they have at the same time manifested a gigantic and over-mastering power, and been favoured by fortune, have invariably been the objects of the high admiration even of those who suffered under them. This shows what I said before, that necessity and fear are the germs of human society, and continue to be the mightiest levers under all circumstances; and that power, (or strength,) is always the object of the greatest reverence and admiration. **Alexander** and **Caesar** cut a greater figure in history than **Horatius Cocles** and **Regulus**, (admitting the latter not to be fabulous personages.) Disinterestedness, friendship, philanthropy, generosity, are flowers of rarer growth; they generally unfold themselves at a later season, and with a more delicate fragrance. To the philosophic mind the highest power manifests itself in perfect goodness: and devotedness to others in the end becomes the highest enjoyment to the individual himself.




---

p.449


Another, and, as it seems to me, a striking proof that what we call Morality is entirely the growth of social life, is, that, as it appears to me, we recognise no such principle in our conduct towards other beings. If it were in our power, we should willingly enough pluck a star from heaven and analyse it for the benefit of *our* science; nor, if we had an angel in our power, should we be very scrupulous in our treatment of him, were we certain we had nothing to fear from him. That our treatment of the lower animals, and in too many cases of the negroes, is utterly and purely selfish, and that we must have reached a high point of civilization before even we cease to torment them or to let them suffer *uselessly* and *wantonly,* is but too obvious a fact. Nay more; men, even among each other, throw off the positive moral principle, as soon as a power which they recognise as competent partially dissolves the obligations of society. As soon as war is declared, the most virtuous soldier kills his fellow man ‘ex officio,’ though perhaps he be but the compulsory servant of a despot whom in his heart he regards as the scum of the earth: or the Pope, in the name of the religion of love, absolves men from every sentiment of truth, rectitude or humanity; and immediately the pious burn, torture, kill, lie, ‘con amore,’ and die satisfied and blessed, in fulfilment of their duty, and to the glory of God!


The lower animals, which are destined to live for themselves alone, know no virtue, and *have, therefore, no soul,* as it is truly said. Yet in the domestic animals, notwithstanding the low order of their reasoning faculty,—from education and from the sort of social intercourse in which they live with man, we may perceive very obvious traces of morality, and the gradual creation of a perception of right and wrong. We see that they are capable of disinterested love; capable even of great self-sacrifice without the motive of fear:—in short, they enter upon the same path as men, their *souls* begin to germinate and expand; and had animals the faculty of speech, it is possible they would advance to a level with ourselves.


Our best and most useful study would be, to endeavour to see what we are, and wherefore we are so, without vain hypotheses or tedious discussions:—this is the only road to a permanent spread of clear and enlightened ideas, and consequently to true happiness. It may be questioned whether German philosophy has not chosen too poetical a path; whether it do not rather resemble a rocket, which soars into the heavens in a thousand sparkles and tries to assimilate itself to the stars, but soon vanishes into nothing,—than a fire which gives out beneficent light and heat. How many eccentric systems of this kind, from **Kant** to **Hegel**, have glittered their moment, and then either rapidly expired, or lived on, divided into obscure and unprofitable fragments!


It is very problematical whether society have reaped so much practical advantage from them as from the now so little valued French philosophers, who stuck to what was near at hand; and in the first place so effectually divided the main nerve of the boa of priestly superstition with their sharp operating-knives, that it has never since been able to do more than feebly drag itself about. The philosopher ought surely to embrace actual life in his speculations, (the greatest of all sages was not less practical, than comprehensively intelligent;) and men who instruct mankind in this manner stand higher in the history of its benefactors than the most astonishing of the firework-makers above mentioned.


The true and only object of philosophy is unquestionably the investigation



---

p.450



of truth;—of such truth, be it observed, as *can be investigated,* for such alone can give any results. To inquire into the incomprehensible is to thrash straw. The most direct way to the attainment of discoverable truth is in my opinion now, as in the days of **Aristotle**, only that of experiment. At a later stage of science we may venture to say with justice, because the law *is* so, experience *must* confirm my conclusions; but this law could only have been discovered by means of prior experiment. **Lalande** might very fairly maintain that such and such stars must stand in such and such relations, although the most accurate observation seemed to prove the contrary, because he already knew the unalterable rule; but without **Newton**'s falling apple, &c.,—without the previous and long-continued observations of individual phenomena, and the truths thence elicited,—the secrets of the heavens were still a book with seven seals.


But if philosophy would seek out truth, she ought above all to seek it in relation to the human species. Histories of mankind, in the widest sense, and whatever can be deduced from them for the behoof of the present and the future, must ever be her chief object. By following this direction, we may gradually succeed in arriving, from the knowledge of what has been and is, at the knowledge of causes; *i. e.* why things are so, and not otherwise: and then again, going back from fact to fact, may approach to fundamental laws, and thus find out a *norma* or rule for the future. Although the first causes of all existence should forever remain undiscoverable by us, it were sufficient, could we clearly and distinctly ascertain what were the original powers of *our* being, what they have become, and what direction we ought to endeavour to give to their further growth. Here the reflection will forcibly present itself, that a further progression and improvement are only possible in the element of freedom, and with an unrestrained interchange of ideas. The most noble and important invention by or for mankind, was therefore indisputably that of printing. Happily, it was born quick and active, for the human intellect was at its birth sufficiently matured to employ this mighty engine for the furtherance of the greatest ends. This invention alone has since rendered it possible to call into life that gigantic power, which nothing will long be able to withstand—public opinion. By this I do not mean the clamours of the mob, but the judgment of the best and wisest, which, since they have found an organ, have penetrated to all, and in the end must effect the destruction of those mere clamours.


Without printing, there would have been no **Luther**;—and until that epoch, had Christianity really been able to make its way? At the time of the thirty years' war, at the time of the English Queen Mary, at the time of the Inquisition, ‘horribile dictu!’ had Christianity rendered men more merciful, more moral, more benign? I see little evidence of it. Freedom of the press was the great step which at once brought us infinitely nearer to the grand end—the universal diffusion of intelligence; and has given such an impulse to human affairs, that we now learn and accomplish more in ten years than our ancestors did in a hundred. The mass of information and intelligence thus accumulated, is what we must look to for the amelioration of the condition of mankind. In every age there have been illustrious men,—men, perhaps, whom no succeeding age will surpass or equal: but they stood alone; and although their effect on the world was not utterly lost, they could generally diffuse but a partial and momentary light, which the lapse of time dimmed or quite obscured.



---

p.451



Let us take as an instance Christ, who, as **Gibbon** has shown, appealed under peculiarly favourable circumstances. How many men have called, and do call, themselves after his name; and how many are *true* Christians? He, the most liberal, the most tolerant, the most sincere and benign of men, has served for nearly two thousand years as a shield to despotism, persecution, and falsehood, and lent his exalted and sacred name to a new form of heathenism.


It is therefore, I repeat, only the *mass* of knowledge, the intelligence which has pervaded *a whole nation,* which can form the basis of permanent, solid and rational institutions, through which society and individuals may be made better and happier. Towards this the world now tends. Politics, in the highest signification of the word, is the religion of the present time. For that, all the enthusiasm of mankind is awakened; and should crusades now be undertaken, that alone would be the object. The notion of representative chambers has now-a-days a more electric effect than that of a ruling church; and even the fame of the warrior begins to grow pale, by the side of that enlightened statesman and citizen. *Prove all things, and hold fast that which is good!’’*

(1 Thess. 5, 21)




But now ‘trêve de bavardage.’ In the mountains I should not have bored you with so much of it; but within the dingy walls of a city I feel as Faust did within those of his study. But a little breeze has sprung up. To-morrow a fresher gale will swell my sails. Wherever I am,—in prison, or under the blue sky,—I am, and shall ever be,


Your true, heartily devoted, 

 L——. *P. S. This is my last letter from **Dublin**. I have had my carriage packed and sent to S——; dismissed my Englishmen, and shall travel under the ‘*nom de guerre*’ you know of,—which is now become ‘romantic,’ by **Bath** and **Paris** with one honest Irish servant. I shall neither hurry, nor stay longer than necessary. The most difficult business—taking leave of friends—is done, and nothing now detains me.*





