

#The Woods of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Woods of Ireland
====================


Author: Caesar Litton Falkiner
------------------------------


### File Description

Electronic file compiled by Beatrix Färber and Janet Crawford

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 2. Second draft.Extent of text: 
7600 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900000-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Further Reading**2. Giraldus Cambrensis, Topographia Hibernica, 1188: J. F. Dimock (ed.) Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera. London 1867.
3. Barnaby Rich, New Description of Ireland, London 1610.
4. William Camden, Britannia (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English with additions and improvements, was published by Dr Edmund Gibson 1722.
5. Meredith Hanmer, The chronicle of Ireland. Collected by Meredith Hanmer in the yeare 1571. (Dublin 1633). Available online as a very large .pdf file at http://www.archive.org/details/irelandchronicles00hanmuoft.
6. Sir George Carew, Earl of Totnes, Sir Thomas Stafford: Pacata Hibernia. Ireland appeased and reduced. Or, an historie of the late warres of Ireland, especially within the province of Mounster, under the government of Sir George Carew, Knight, then Lord President of that province, and afterwards Lord Carew of Clopton, and Earle of Totnes, &c. Wherein the siedge of Kinsale, the defeat of the Earle of Tyrone, and his armie; the expulsion and sending home of Don Iuan de Aguila, the Spanish generall, with his forces; and many other remarkeable passages of that time are related. Illustrated with seventeene severall mappes, for the better understanding of the storie. (London 1633). [Reprinted, ed. Standish Hayes O'Grady, Pacata Hibernia, or A history of the wars in Ireland during the reign of Queen Elizabeth. 2 vols. (London 1896).]
7. Gerard Boate, Ireland's Naturall History, London 1652. Chetham Society. [Reprinted as 'Gerard Boate's natural history of Ireland', edited with an introduction by Thomas E. Jordan (New York 2006).]
8. Stanley G. Mendyk, Gerard Boate and 'Irelands Naturall History'. Journal of the Royal Society of Antiquaries of Ireland, 115 (1985), 5–12.
9. John Lynch, Cambrensis Eversus (St Malo 1662). [Reprinted, ed. M. Kelly. 3 vols. (Dublin 1848).]
10. Sir Patrick Finglas, A Breviate of the Getting of Ireland and of the Decaie of the Same, in: Hibernica: or, some antient pieces relating to Ireland, ed. Walter Harris (Dublin: 1747)
11. John Derricke, The image of Irelande: with a discoverie of woodkarne, 1581; with the notes of Sir Walter Scott, edited, with introduction, by John Small (Edinburgh 1883).
12. Sir William Petty, The political anatomy of Ireland ... to which is added .. an account of the wealth and expences of England. London: Printed for D. Brown and W. Rogers 1691. [Reprinted as 'The political anatomy of Ireland: with the establishment for that kingdom, and verbum sapienti', introduction by J. O'Donovan. (Shannon: IUP 1970)].
13. Robert Payne, 'A brief description of Ireland to XXV of his partners for whom he is undertaker, by Robert Payne, A.D. 1590,' ed. Aquila Smith, Tracts relating to Ireland, vol ii, Miscellany of the Irish Archaeological Society (Dublin 1841).
14. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
15. John Dymmok, 'A treatice of Ireland. Edited by Richard Butler', Tracts relating to Ireland vol ii, Miscellany of the Irish Archaeological Society (Dublin 1843), 1–90.
16. Walter Harris, (ed.) Hibernica, or, some antient pieces relating to Ireland ... 2 vols. (Dublin 1747–1750).
17. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof (Dublin 1774; reprinted Dublin/Cork: Mercier Press 1979).
18. Arthur Young, A tour in Ireland: with general observations on the present state of the kingdom: made in the years 1776, 1777, and 1778, and brought down to the end of 1779. 2 vols. 1780. [Reprinted, with an introduction by J. B. Ruane, 2 vols. (Shannon: IUP 1970)].
19. Sir William Betham, Origin and History of the Constitution of England and of the Early Parliaments of Ireland (Dublin 1834).
20. William Edward Hartpole Lecky, A history of Ireland in the eighteenth century. 5 vols. New edition 1892–1896.
21. P. W. Joyce, A Social History of Ancient Ireland, 2 volumes (New York, London, and Bombay: Longmans, Green, & Company. 1903).
22. P. W. Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869-1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe. (Dublin: Éamonn de Búrca for Edmund Burke 1995).
23. Richard Bagwell, Ireland under the Stuarts and during the Interregnum. Vol. I: 1603–I642; Vol. II: 1642–1660; Vol.III: 1660–1690.(London 1909–1916). (A digital copy is available at www.archive.org.)
24. A. C. Forbes, 'Some legendary and historical references to Irish woods and their significance', in: Proceedings of the Royal Irish Academy, 41 B (1932) 15–36.
25. K.W. Nicholls, 'Anglo-French Ireland and after', in: Peritia 1 (1982) 372–74.
26. J. R. Pilcher, Seán Mac An tSaoir (eds.), Woods, trees and forests in Ireland: proceedings of a seminar held on 22 and 23 February 1994. Dublin: Royal Irish Academy, 1995.
27. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
28. K.W. Nicholls, Woodland cover in pre-modern Ireland, in: Patrick Duffy, David Edwards and Elizabeth Fitzpatrick (eds.), Gaelic Ireland, c.1250–1650: land, lordship and settlement (Dublin 2001) 181–206.
29. Philip O'Sullivan Beare, The Natural History of Ireland, ed. by Denis C. O'Sullivan (Cork: Cork University Press 2009).
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 143–159 of the volume. Appended to the text are two appendices giving details about the woods of Ireland, which are reproduced in the electronic edition.


#### Editorial Declaration


##### Correction


Text proofread three times at CELT.


##### Normalization


The electronic text represents the edited text. Footnotes are included and tagged note. Non-standard spellings of names are regularised using the reg attribute within the XML/SGML tags. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; back back matter containing two appendices. Page-breaks are marked pb.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal names, and terms are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: By C. Litton Falkiner (c. 1904) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [GA] Some words and phrases are in Irish.


### Revision History


* (2010-06-23) Beatrix Färber (ed.)

* Additions to bibliography made; conversion script run; file updated.
* (2008-07-31) Beatrix Färber (ed.)

* Keywords added; file validated, addition to bibliography and new wordcount made.
* (2007-06-14) Beatrix Färber (ed.)

* Header completed; file parsed; SGML and HTML files created.
* (2007-06-09) Beatrix Färber (ed.)

* File proof-read (3); more markup applied.
* (2007-06-08) Beatrix Färber (ed.)

* Provisional header created.
* (2007-06-08) Janet Crawford (ed.)

* File proof-read (2).
* (2007-05-12) Benjamin Hazard (ed.)

* First proofing; some structural and content markup added.
* (2007-05-12) Benjamin Hazard (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900000-001


### The Woods of Ireland: Author: Caesar Litton Falkiner




---

p.143


The Woods of Ireland
--------------------


That the climate and soil of Ireland are naturally suited to the growth of timber of nearly every useful kind indigenous to Europe, and that the island was anciently stored with woods and forests of vast extent, is proved not only by the testimony of all who have considered its physical and geological formation, but by the express statement of historians and chroniclers, and the convincing implication of our topographical nomenclature. The woods of Ireland, and especially those formerly adjacent to our capital, were famous even before the coming of the English. It was from the fair green of **Oxmantown**, once covered with woods that extended westward over the whole of what is now the Phoenix Park, that William Rufus drew the timber for the roof of Westminster Hall, where, as the chronicle of **Dr. Hanmer** has it, *no English spider webbeth or breedeth to this day.’’*

**Meredith Hanmer**'s Chronicle, Ancient Irish Histories. , ii. p. 194.

 The practice of using Irish timber for buildings intended to be durable seems to have been usual in England in early times. The spire of the thirteenth century bell-tower of Worcester Cathedral, taken down in 1647, was of *massive timber, Irish and unsawed.’’*

 Journal of Kilkenny Archaeological Society. , 1856-7, p. 236.

 And, as tradition avers, it was from Cullenswood that, only a generation after the coming of the Normans, the Byrnes and Tooles made the descent upon the Bristolmen who had settled in **Dublin** for which Easter Monday was long had in remembrance in **Dublin** as ‘Black Monday.’[1](javascript:footNote('E900000-001/note001.html'))


**Giraldus Cambrensis** states in his Topographia Hibernica that the woodlands of Ireland exceeded in his day the plains or cleared and open land. And not even the zealous



---

p.144




fervour of the author of Cambrensis Eversus has seriously endeavoured to refute this assertion of our earliest descriptive chronicler.[2](javascript:footNote('E900000-001/note002.html')) Anyone who looks into **Dr. Joyce**'s suggestive book on Irish names of places will be astonished to note the extent to which the root words expressive of woods, forests, and trees are found in the names of hills and valleys, town-lands, and districts which are now bare of every vestige of the abundant timber of which these names have long been the only memory. For example: — The barony of **Kilmore**, near **Charleville**, gets its name from the great wood which in the sixteenth century formed, as the Pacata Hibernia tells us, one of the strongest barriers against the soldiers of **Elizabeth**. **Dr. Joyce** has calculated that in at least seven hundred cases the **kils** and **kills** so numerous in the place names of Ireland really represent the word **coill**, and are witnesses to woods no longer visible; while **coillte,** the plural, and **coillín,** the diminutive of **coill**, account for many more. **Fidh** or **fioth** (fih), another term for wood, also occurs frequently, and the two baronies of **Armagh**, called **the Fews**, are of this origin. **Ros** too, occasionally stands for wood, as in the Abbey of **Rosserk** in **Mayo**, **Roscrea**, **New Ross**, and best known of all, **Roscommon**. **Fasach** (faussagh), a wilderness, **Scairt** (scart), a thicket of scrub, and **Muine** (munny), a shrubbery, are a few among many arboreal terms which abound in the index locorum, and contribute to justify the term **Inis-na-veevy** or woody island, which is among the bardic names of Ireland. Over and above the terms signifying woods, are those which denote particular trees, of which **Daire** (Derry), an oakwood, with its many variations, is the most important.[3](javascript:footNote('E900000-001/note003.html')) The Annals of the Four Masters abound in references to the ancient woods of Ireland, which prove that in a great part of the country a dominant characteristic of the social system of ancient Ireland was the forest life of the people. And if we may accept as accurate a passage in the Annals of Ulster, for the year 835 A.D.,[4](javascript:footNote('E900000-001/note004.html')) the



---

p.145




acorn and nut crop was so large in that year as to close up the streams, so that they ceased to flow in their usual course.


That this state of things survived to an era well within historical memory is abundantly demonstrated by many authorities. **Sir John Davies**, a writer whose observations and conclusions, even when we disagree with them, are always suggestive, has noted the degree in which the political system adopted by the Norman colonists of Ireland, and pursued, whether by choice or necessity, by the English Government for many centuries, had the effect of preserving this feature. That system was to drive the native population from the plains to the woods; with the result that the Irish territories tended to become ever more and more a succession of forest fastnesses. Had a different plan been adopted, the woods, as **Davies** points out, would have been wasted by English habitations, as had happened just before his own time in the territories of **Leix** and **Offaly**, round the new-made forts of Maryborough and Philipstown.


The early Plantagenets made some attempt to establish the forest laws in Ireland. In the neighbourhood of **Dublin**, at all events, a considerable tract must have been brought within their operations, for in 1229 Henry III. granted permission to Luke, Archbishop of **Dublin**, to carry out the disafforesting of certain lands formerly belonging to the see of **Glendalough**. It is certain that a royal forest was formed at **Glencree**, in the **county Wicklow**. In 1244 sixty does and twenty bucks were ordered to be *taken alive in the king's parks nearest to the port of Chester to be sent to the port of **Dalkey**, Ireland, and delivered to the king's Treasurer in **Dublin** to stock the king's Park of **Glencry**’’*

Calender of State Papers (Ireland), 1171–1251, p.398. 

; and that the King's lands were not limited to a mere park, but included a forest properly so called, may be inferred from the language of a mandate of Edward I. permitting William Burnel, constable of the **Castle of **Dublin****, *to have in the king's forest of **Glencry** twelve oak trees fit for timber of the king's gift to construct his house of Glenecapyn.’’*

Calender of State Papers (Ireland), 1285–1292, p. 281.

. 



---

p.146




A reference to the misconduct of the Abbot and monks of St. Mary's, **Dublin**, in hunting in the King's forest without license supports the same conclusion.[5](javascript:footNote('E900000-001/note005.html')) But the royal forest of Glencree disappears from view, like so much else, amid the confusion that followed the wars of the Bruces. No mention of it is to be found subsequent to the reign of Edward I. The whole district comprised in the modern county of **Wicklow** relapsed after the Bruce disturbance into the control of the Irish septs of the Byrnes and Tooles; nor was it effectively redeemed by the Crown until the opening of the seventeenth century.[6](javascript:footNote('E900000-001/note006.html'))


Apart, however, from this formation of the royal forest of Glencree, no attempt was made for above three centuries after the arrival of the English in Ireland to encroach to any serious extent upon the native reserves of the Irish inhabitants, though a Statute of Edward I., passed in 1296, contained a clause which was designed to provide highways through the country.[7](javascript:footNote('E900000-001/note007.html')) But the wars of the Bruces which followed within a few years of this enactment, and the subsequent decadence of English power, prevented the taking of any effective steps under this Statute.


Down to the middle of the sixteenth century, it may fairly be said, no substantial alteration took place in the face of Ireland in this regard. In **Chief Justice Finglas**'s Breviate of the Getting of Ireland and of the Decay of the Same, written about 1529, occurs a passage which shows that well on into the reign of **Henry VIII.**, the period, indeed, at which the English Pale had shrunk to its narrowest limits, 



---

p.147




the districts in which English law remained supreme were everywhere hedged round by impassable forests. Finglas prescribed a remedy very similar to that enforced by Edward I., more than two centuries earlier: *Item—That the deputy be eight days in every summer cutting passes of the woods next adjoining to the king's subjects, which shall be thought most needful,’’*

;—and he enumerates above thirty passes, most of them adjacent to the Pale, which required to be made or maintained.[8](javascript:footNote('E900000-001/note008.html')) The numerous writers to whom we owe our knowledge of Elizabethan Ireland and of the age immediately succeeding, concur in representing the great forests as having survived in most places to the middle of the sixteenth century, and in many till well into the seventeenth.[9](javascript:footNote('E900000-001/note009.html')) **Sir Henry Piers**, in his History of Westmeath, [10](javascript:footNote('E900000-001/note010.html')) designed to illustrate the **Down** Survey, speaks of that county as deficient in nothing, *except only timber of bulk, with which it was anciently well stored.’’*

. Yet barely a century before this was written, **Westmeath** had been one of the most secure fortresses of ‘the king's Irish enemies,’ as the native septs were called; and it was for this reason that under **Henry VIII.** the county was



---

p.148




severed from **Meath** to which it had anciently belonged.[11](javascript:footNote('E900000-001/note011.html')) During the wars of **Elizabeth** it was still a proverb that ‘The Irish will never be tamed while the leaves are on the trees’, meaning that the winter was the only time in which the woods could be entered by an army with any hope of success; and the system of ‘plashing’, by which the forest paths were rendered impassable through the interlacing of the boughs of the great trees with the abundant underwood, was the obstacle accounted by most of **Elizabeth**'s soldiers the most dangerous with which they were confronted. **Derricke**, in his Image of Ireland, written in 1581, gives a description of the woods which, even if we discount the figures on the score of poetic licence, must be held to show that in his day the forests still covered enormous areas. He speaks of them as often twenty miles long:[12](javascript:footNote('E900000-001/note012.html'))

> 1. The woodes above and 'neath those hills,
>   
> Some twentie miles in length:
>   
> Round compacte with a shakynge bodye,
>   
> A forte of pasayng strength.
> 




The adoption of a resolute policy in Ireland by the Tudor sovereigns was the first step towards the reduction of these immense woodland areas. The gradual extension throughout the country of the measures first applied to **Westmeath** led, under the reigns of **Mary** and **Elizabeth**, to a rapid clearance of large tracts of the country. **Fynes Moryson**, in the closing years of **Elizabeth**, found the central plain of Ireland nearly destitute of trees. *I confess myself, [he writes,] to have been deceived in the common fame that all Ireland is woody, having found in my long journey from **Armagh** to **Kinsale** few or no woods by the way, excepting the great woods of **Ophalia**; and some low, shrubby places which they call glens.’’*

Fynes Moryson, Description of Ireland, ed. C. L. Falkiner *(see CELT file T100071, p. 228.)*

 [13](javascript:footNote('E900000-001/note013.html')) The Pale had, of course, for centuries been denuded of its woods, if it ever



---

p.149




possessed them on a large scale, and as early as 1534 an ordinance of **Henry VIII.** had directed every husbandman to plant twelve ashes within the ditches and closes of his farm. With the disappearance, in the person of **Tyrone**, of the last Irish chieftain powerful enough to hold independent sway in the island, this clearance was extended towards **Ulster**. By **Strafford**'s time **Wicklow**, **Wexford**, and **Carlow**, the **Queen's county** were the only districts in which the forests were still extensive. And even here they had begun decline. **Sir William Brereton** noted in 1635 that in the neighbourhood of **Carnew**, in **Sir Morgan Kavanagh**'s once thick woods, there remained ‘little timber useful save to burn, and such as cumbreth the ground.’ He adds that wood is ‘a commodity which will be much wanting in this kingdom, and is now very dear at **Dublin**.’[14](javascript:footNote('E900000-001/note014.html')) The civil war which followed the Rebellion of 1641 doubtless tended largely in the same direction, and by the time of the Commonwealth **Boate** noted in his Natural History of Ireland that in some parts you might travel whole days without seeing any trees save a few about gentlemen's houses. This was especially so on the northern road, where for a distance of sixty miles from the capital not a wood worth speaking of was to be seen. *For [he adds] the great woods which the maps do represent to us upon the mountains between **Dundalk** and **the Newry** are quite vanished, there being nothing left of them these many years since, but only one tree standing close by the highway, at the very top of one of the mountain, so as it may be seen a great way off, and therefore serveth travellers for a mark.’’**Boate**'s Ireland's Naturall History. , chapter xv.*
The destruction of the woods, due in the first place to deliberate policy and in the next to the accidents of war, was accelerated both during the long peace that preceded the Rebellion, and afterwards in the years following the Restoration, by the progress of the arts of peace. The revival of Irish industries was nearly as fashionable a shibboleth in the middle of the sixteenth century as it has



---

p.150




been at intervals in later ages. In those days the favourite objects of solicitude were the manufacture of pipe-staves, and the development of the iron-works which were then supposed to be the true El Dorado of Irish enterprise—most people holding with Bacon that ‘Iron is a brave commodity where wood aboundeth.’ Both industries depended for their success upon the woods, which were accordingly drawn upon regardless of the consequences. From **Munster** whole shiploads of pipe-staves were exported, to the great profit of the proprietors and the great destruction of the woods; and **Boate** says, *it is incredible what quantity of charcoal is consumed by one iron-work in a year.’’*

**Boate**'s Ireland's Naturall History. , chapter xvi.

 **Richard Boyle**, the well-known Earl of Cork, was reputed to have made 100.000£ by his iron-works, and the sale of timber must have brought him almost as much again. **Sir William Petty**'s was another of the great fortunes in part accumulated by the destruction of the woods of Ireland. But that **Petty**, undoubtedly one of the most large-minded Englishmen whom the confiscations of the seventeenth century attracted to Ireland, was not unmindful of the need for maintaining the timber supplies of the country, may be inferred from the fact that in his Political Anatomy of Ireland, he recommends the *planting [of] three millions of timber trees upon the bounds and mears of every denomination of lands [in the country].’’**Petty**'s Political Anatomy of Ireland. , chapter ii.* So rapid was the consumption, however, that the want of fuel, formerly abundant, began to make itself felt. **Thomas Dinely** writing in his Journal,[15](javascript:footNote('E900000-001/note015.html')) about the year 1681, remarks on the consequent substitution for the first time of turf for wood firing. *The wars [he says] and their rebellions having destroyed almost all their woods both for timber and firing, their want is supplyed by the bogs.’’* A century later **Arthur Young** noted that in the neighbourhood of **Mitchelstown** there were *a hundred thousand acres in which you might take a breathing gallop to find a stick large enough to beat a dog,



---

p.151




yet is there not an enclosure without the remnants of trees, many of them large.’’**Young**'s Tour in Ireland. , ii. p. 62.*[16](javascript:footNote('E900000-001/note016.html'))
The troubles of the Revolution and the succeeding changes were also injurious to the woods. The Commissioners of Forfeited Estates comment severely on the general waste committed by the grantees of these properties, instancing in particular the woods round **Killarney**, where trees to the value of 20,000£. were cut down, and the **Muskery** district, where the destruction was almost as great.[17](javascript:footNote('E900000-001/note017.html')) That this reckless dealing with the timber supply of the country was continued for the best part of a generation may be inferred from a passage in the seventh Drapier's Letter, in which **Swift** asserts his belief *that there is not another example in Europe of such a prodigious quantity of excellent timber cut down in so short a time with so little advantage to the country either in shipping or building.’’*

**Swift**'s Works. , ed. **Sir Walter Scott**, vii. p. 52; Prose Works, ed. Temple Scott (Bohn's Library), vi. p. 200.

 This process of rapid consumption of the anciently abundant woods of Ireland continued far into the eighteenth century, and notwithstanding a succession of enactments designed to encourage planting, the woodland areas diminished so rapidly that, to quote **Arthur Young** once more, *the greatest part of the country continues to exhibit a naked, bleak, dreary view for want of wood, which has been destroyed for a century past with the most thoughtless prodigality, and still continues to be cut and wasted as if it was not worth the cultivation.’’**Young**'s Tour in Ireland. ii. p. 62.*
Although some maps of the time of **Henry VIII.** are extant which indicate very roughly the wooded districts, nothing approaching to a statistical record of the distribution of the woods of Ireland is available for an earlier date than the seventeenth century. **Baron Finglas**'s rough list of passes has already been referred to, and is the earliest specific



---

p.152




notice on the subject. In **Dymmok**'s Treatise of Ireland, 1599, is given *A particular of such strengths and fastnesses of wood and bog as are in every province in Ireland’’*

Irish Archaeological Society's Tracts Relating to Ireland. , ii. p. 26.

 in which the principal forest districts are set out by name. It is evident, however, that **Dymmok** derived his information not from any first-hand acquaintance with the whole country, but from the notes of one of the most diligent inquirers into the condition and resources of Ireland who had ever visited the country, the well-known **Sir George Carew**. In the Lambeth Manuscripts, which bear his name, are to be found **Carew**'s observations on the subject.[18](javascript:footNote('E900000-001/note018.html')) They are much fuller than **Dymmok**'s list. Half a century after **Carew**'s time, the Books of Survey and Distribution, compiled in 1657, and preserved in the Irish Record Office, show the dimensions of the woodlands throughout the country as ascertained at that date. The maps of the **Down** Survey also indicate in a rough way the distribution of the woods. And a list of the iron-works through the country in the seventeenth century would indicate as many places in which substantial woods still existed at that period.
It appears from these and other sources, that at about the close of the seventeenth century the woods or forests of importance were distributed roughly, thus:


1. **Leinster**: In the counties of **Wicklow**, **Wexford**, **Carlow**, and **Kilkenny**, and in the great territories of **Leix** and **Offaly**, covering the greater portion of **Queen's** and part of **Leitrim**.
2. **Ulster**: In the counties of **Tyrone**, **Londonderry**, **Antrim**, and **Down**, particularly on the east and west shores of **Lough Neagh**, and the territories adjacent.
3. **Munster**: In Cork, **Kerry**, and **Limerick**, the southern borders of **Tipperary**, and East **Waterford**.
4. **Connaught**: In the barony of **Tyrawly**, in **Mayo** and North **Sligo**, in **Roscommon**, and along the course of the **Shannon**.


It is obvious, however, that the rapid diminution of the



---

p.153




woodland area during the seventeenth century was not an absolutely unmitigated misfortune. It was the natural consequence of that social transformation which necessarily followed the effective assertion of the authority of the English Crown throughout the island in the reign of **James I**. Apart from all questions between the races, it was as desirable as it was natural that large districts formerly usurped by the forest should be restored to agriculture. Had the clearances effected, first by the soldiers of **Elizabeth** and next by the planters of **James**, ended with those which followed the Restoration, there would have been no great reason to complain. But an era of confiscation was necessarily unfavourable to the development of the resources of the land; and successive owners, threatened with the early determination of their interest in their estates, utilised the short period of possession to turn their timber into gold. Thus the woods that had survived fell at an alarming rate, and the Government were obliged to intervene. Accordingly, the Irish statute-book, from the Restoration to the middle of the eighteenth century, contains many measures which had for their object the encouragement of planting, and the replacing of the timber in districts from which it had disappeared. Some of these are of great interest, and well deserve attention.


The earliest instance of legislation for the protection of trees was the application to Ireland by **Strafford** of an English statute of **Elizabeth** to avoid and prevent divers misdemeanours of idle and lewd persons in barking of trees.’’

 An Act of 10th Charles I.  (chapter 23) gave this measure force in Ireland; but it appears to have been designed mainly for the protection of the orchards and young trees in the plantation districts, and not to have been directed to the conservation of the larger woods. The seventeenth century had almost run its course before any further statute was passed. In 1698, however, the ministers of **William III.** felt it was time to intervene. An Act for Planting and Preserving Timber Trees and Woods recognises in its preamble the operation of the causes



---

p.154




which had led to the too rapid destruction of the old woods. It runs thus:— *Forasmuch as by the late rebellion in the Kingdom and the several iron-works formerly here, the timber in utterly destroyed, so as that at present there is not sufficient for the repairing the houses destroyed, much less a prospect of building and improving in after times, unless some means be used for the planting and increase of timber trees.’’*
The remedies prescribed by this act were threefold:
1. All resident freeholders, having estates to the value of 10£ yearly and upwards, and all tenants for years at a rent exceeding that sum, having an unexpired term of ten years, were required, under a penalty from and after March 25, 1703, to plant every year, for thirty-one years, ten plants of five years' growth of oak, fir, elm, ash, or other timber. Owners of iron-works were required to plant five hundred such trees annually, so long as the iron-works were going.
2. Every occupier of above five hundred Irish acres was required to plant and enclose, within seven years of the passing of the Act, one acre thereof, and to preserve the same as a plantation for at least twenty years.
3. All persons and corporations seized of lands of inheritance were charged with the planting of their respective proportions of 260,600 trees yearly of oak, elm, or fir for a period of thirty-one years. The proportions in which these trees were to be planted in each county is set out in a list in the fourth section of the act, and the proportion in which each county should be planted was to be apportioned by the grand juries, by baronies, and parishes at each summer assizes.[19](javascript:footNote('E900000-001/note019.html'))



A further provision gave tenants planting pursuant to the statute a right to one-third of the timber so planted. This was increased by a later Act to one-half.


The legislation of **William III.** was followed by several acts passed in succeeding reigns with the same object. An



---

p.155




Act of Queen Anne abolished the duties on unwrought iron, bark, hoops, staves and timber, and forbade exportation of these commodities except to England. And a further Act forbade the use of home-grown gads or withes, or the erection of May-poles of home-growth. These Acts, however, failed to produce the desired effect. [20](javascript:footNote('E900000-001/note020.html')) **Thomas Prior**, in the appendix to his List of Absentees, attributed this failure to the insufficient interest given to tenants in the trees planted by them, and suggested that planting should be encouraged by obliging owners, on the fall of leases, to pay their tenants the timber value of all trees planted by the latter. An Act of **George III.** passed in 1775 expressly recognised in its preamble the failure of the earlier legislation, which it accordingly repealed. It made fresh provision for the preservation of trees, and did something to carry out Prior's views, which were zealously supported by the Royal Dublin Society, an institution of which Prior was one of the founders, and which has always been honourably distinguished by the interest it has displayed in the preservation of the woods of Ireland.


The stimulating criticism and suggestions of **Arthur Young**, who, as already noted, visited Ireland just at this time, undoubtedly had much to do with the more enlightened views on the subject which, towards the close of the eighteenth century, began to characterise the majority of Irish landowners. One or two of his observations on this subject are worth quoting. *I have made [says Young] many very minute calculations of the expense, growth, and value of trees in Ireland, and am convinced from them that there is no application of the best land of the kingdom will equal the profit of planting the worst of it.’’*

Young's Tour in Ireland. , ii. p. 64.

 The remark savours, perhaps, of the accustomed optimism of the reforming



---

p.156




stranger who has never submitted his theories to the test of practice, and is ready to sell wisdom before he has bought experience. But no more competent observer than **Arthur Young** has ever applied a trained and cautious intelligence to the consideration of the economic problems of Ireland. It is certain that, however wisely we may hesitate to adopt literally this epigrammatic summary of his views on planting, **Young**'s opinions were based on an unusually thorough statistical investigation of the country, coupled with an exceptionally wide knowledge of agricultural conditions in other European countries. **Young**'s observations on the subject are the more worth noting in view of modern conditions because he bestowed much attention on the means of enlisting the peasantry in the cause of planting, and displayed a firm confidence that *instead of being the destroyers of trees they might be made preservers of them.’’* With this view he recommends in his Observations that premiums should be given to farmers who planted and preserved trees, and suggested that the tenantry should be obliged to plant under a special clause in their leases, requiring them to plant a given number of trees per annum in proportion to the size of their holdings.
Appendix 1
----------




---

p.157


### Appendix I: Woods and Fastnesses in **Ulster**


**Glenbrasell**, by **Lough Eaugh** (**Lough Neagh**), a great boggy and *woody fastness*.


**Glencan**, a boggy and *woody* country environed with two rivers viz.: the **Blackwater** and the **Ban**.


**Killultagh**, a safe boggy and *woody* country, upon **Lough Eaugh**.


**Kilwarlon**, the like bounden together.


**Kilautry**, lying between **Kilwarlen** and **Lecale**.


**Glenconkeyn**,[21](javascript:footNote('E900000-001/note021.html')) on the river **Ban**'s side, in **O'Chane**'s country, the chief *fastness* and refuge of the Scotts.


The Length and Breadth of the Woods and Fastnesses in **Munster**


**Glengaruf**, in O'Sullivan More's country, 4 miles long and 2 broad.


**Glenroght**, in **Desmond**, 3 long and 2 broad.


**Leanmore**, in **Desmond**, 3 long and 3 broad.


**Glenglas** and **Kilmore** in the **County Limerick**, 12 long and 7 broad.


**Dromfynine**, in the **County Cork**, on the **Blackwater**, 6 long and 2 broad.


**Arlo** and **Muskryquirke**, in **Tipperary**, 9 long and 3 broad.


**Kilhuggy**, in **Tipperary**, bordering on **Limerick**, 10 long and 7 broad.


**Glenflesk**, 4 long and 2 broad.


Woods and Fastnesses in **Connaught**


The woods and bogs of **Kilbigher**.


**Killcallon**, in MacWilliam's county.


**Killaloa**, in county of **Leitrim**.


The woods and *bogs* near the **Corleus**.


Woods and Fastnesses in **Leinster**


**Glandilour**, a fastness in Pheagh M'Hugh's countrie.


**Shilelagh**, **Sir Henry Harrington**'s, in the county of **Dublin**.




---

p.158


**The Duffries**, in the County of **Wexford**.


**The Drones** and **Leverocke**, in the county of **Catherlogh**.


The great bog in the **Queen's county**, which reacheth to **Limerick**.


**The Fuse** in the County of **Kildare**.


The woodland bogs of **Monaster-Evan**, **Gallin** and **Slievemargy** in the **Queen's county**.


**The Rowry**, near **St. Mullins**, where the **Nur** and **Barrow** unite together, and makes *it* *half* an island.


Part of **Coulbracke**, joyning upon the County of **Kilkenny**.[22](javascript:footNote('E900000-001/note022.html'))


Appendix 2
----------


### Appendix II: Statute 18th William III. Cap. I. Section 4.


And be it further enacted, that the proportion of each county, county of a city, and county of a town of the said two hundred and sixty thousand six hundred trees aforesaid, is and shall be as hereinafter is declared.


1. **Antrim county** and **Carrickfergus**, nine thousand seven hundred and fifty.
2. **Ardmagh county**, four thousand seven hundred and fifty.
3. **Catherlagh county**, three thousand two hundred and fifty.
4. **Cavan county**, four thousand six hundred.
5. **Clare county**, seven thousand eight hundred.
6. **Cork county and city**, twenty-six thousand six hundred.
7. **Donegal county**, eight thousand three hundred and fifty.
8. **Down county**, eight thousand four hundred.
9. **Dublin county** (whereof the city and its liberties, twenty-one thousand five hundred) thirty-one thousand nine hundred.
10. **Fermanagh county**, four thousand five hundred and fifty.
11. **Gallway county** (whereof on **Gallway town and liberties**, one thousand three hundred) eleven thousand eight hundred.
12. **Kerry county**, four thousand six hundred.
13. **Kildare county**, seven thousand one hundred and fifty.
14. **Kilkenny county** (whereof on **Kilkenny city and liberties**, seven hundred) nine thousand.


---

p.159

17. **King's county**, three thousand nine hundred.
18. **Leitrim county**, three thousand two hundred and fifty.
19. **Limerick county** (whereof on **Limerick city and liberties**, one thousand three hundred) nine thousand six hundred.
20. **Londonderry county**, city and barony of **Colerain**, six thousand five hundred.
21. **Longford county**, two thousand six hundred.
22. **Lowth county** (whereof **Drogheda and liberties**, six hundred and fifty) five thousand two hundred.
23. **Mayo county**, six thousand five hundred.
24. **Meath county**, twelve thousand three hundred and fifty.
25. **Monaghan county**, four thousand five hundred.
26. **Queen's county**, three thousand nine hundred and fifty.
27. **Roscommon county**, six thousand five hundred.
28. **Sligo county**, five thousand two hundred.
29. **Tipperary** and **Holy-Cross**, eighteen thousand two hundred.
30. **Tyrone county**, six thousand five hundred.
31. **Waterford** county (whereof on **Waterford city and liberties**, one thousand and fifty) six thousand five hundred and fifty.
32. **Westmeath county**, six thousand six hundred.
33. **Wexford county**, six thousand five hundred.
34. **Wicklow county**, three thousand two hundred and fifty.
