

#The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country
====================================================================


Author: Unknown
---------------


### File Description

John O'DonovanElectronic edition compiled by Beatrix Färber , Benjamin Hazard

 3. Third draft.Extent of text: 32900 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2004) (2010) (2011) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: G105007Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript Sources**2. Dublin, Royal Irish Academy MS 535, olim 23 P 2 olim Book of Lecan, ff. 90–92. For further details see Kathleen Mulchrone, T. F. O'Rahilly et al. (eds.), Catalogue of Irish Manuscripts in the Royal Irish Academy (Dublin 1926–70) fasc. 13, 1551–1610. This vellum MS was complied for Giolla Iosa Mór Mhic Fhir Bhisigh before his death in A.D. 1418. *Digital images of the Book of Lecan can be viewed on the website of the ISOS Project* (http://www.isos.dias.ie/english/index.html).
**Internet Resources**2. A PDF version of O'Donovan's Miscellany is available at http://www.archive.org.
3. The LOCUS Project, UCC (http://www.ucc.ie/locus/).
4. Hogan's Onomasticum online (http://publish.ucc.ie/doi/locus).
5. http://www.logainm.ie (the website of the Irish Placenames Commission).
6. Dr Katherine Simms's Bardic Poetry Database hosted on the DIAS website (http://bardic.celt.dias.ie/).
**Editions and translations**2. John O'Donovan (ed. and trans.), The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country, from the Book of Lecan with translation and notes and a map of Hy-Many (Dublin 1843; reprinted by Tower Books, Cork 1976; reprinted by Irish Genealogical Foundation, Kansas City, Missouri, c. 1992).
3. Kathleen Mulchrone (ed.), The Book of Lecan, Leabhar Mór Mhic Fhir Bhisigh Leacain: Facsimiles in Collotype of Irish Manuscripts II, being a collection of pieces (prose and verse) in the Irish language, in part compiled in the early fourteenth century with a descriptive introduction and indexes (Dublin 1937).
**Literature: The Uí Maine and the Book of Uí Maine**2. R. A. S. Macalister (ed.), The Book of Uí Maine, otherwise called The Book of the O'Kelly's, with a descriptive introduction and indexes (Dublin 1942).
3. J. V. Kelleher, 'Uí Maine in the annals and genealogies to 1225 [Pt.1]', Celtica 9 (1971) 61–112.
4. William O'Sullivan, 'The book of Uí Maine, formerly the book of Ó Dubhágain: scripts and structure', Éigse 23 (1989) 150–166.
5. Máire Ní Mhaonaigh, 'Nósa Ua Maine: fact or fiction?', in: Thomas Charles-Edwards, Thomas Mowbray, Morfydd E.Owen, Paul Russell (eds.), The Welsh king and his court (Cardiff: University of Wales Press on behalf of the History and Law Committee of the Board of Celtic Studies, 2000) 362–381.
6. Paul Russell, 'Nósa Ua Maine: the customs of the Uí Mhaine', in: Thomas Charles-Edwards, Thomas Mowbray, Morfydd E.Owen, Paul Russell (eds.), The Welsh king and his court (Cardiff: University of Wales Press on behalf of the History and Law Committee of the Board of Celtic Studies, 2000) 527–551.
**Literature: History, Genealogy and medieval society in Ireland**2. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
3. Roderic O'Flaherty, Ogygia seu, Rerum Hibernicarum chronologia: Ex pervetustis monumentis fideliter inter se collatis eruta, atque e sacris ac prophanis literis primarum orbis gentium tam genealogicis, quam chronologicis sufflaminata praesidiis. (...) (London 1685). (An English translation by the Reverend James Hely was published in Dublin 1793).
4. John O'Donovan (ed.), The Genealogies, Tribes and Customs of Hy-Fiachrach (Dublin 1844).
5. Eoin Mac Neill (=John Mac Neill), Early Irish population-groups: their nomenclature, classification, and chronology, Proceedings of the Royal Irish Academy (C), 29, (1911–12) 59–114.
6. Kuno Meyer (ed.), 'The Laud genealogies and tribal histories', ZCP 8 (1912) 292–338, 418–19 (corrigenda) [from Laud Misc. 610].
7. Toirdhealbhach Ó Raithbheartaigh (ed.), Genealogical tracts: being a collection of excerpts in the Book of Lecan (Dublin 1932).
8. T. F. O'Rahilly, Early Irish History and Mythology (Dublin 1946).
9. John V. Kelleher, 'The pre-Norman Irish genealogies', Irish Historical Studies 16 (1968) 138–153.
10. Francis John Byrne, Tribes and tribalism in early Ireland, Ériu 22 (1971) 128–166.
11. Gearóid Mac Niocaill, Ireland before the Vikings (Dublin 1972).
12. Kenneth W. Nicholls, Gaelic and gaelicised Ireland in the Middle Ages (Dublin 1972, new edition 2003).
13. Francis John Byrne, Irish kings and high-kings (New York 1973, second edition Dublin 2001).
14. Francis John Byrne, 'Senchas: the nature of Gaelic historical tradition', in John Barry (ed.), Historical Studies 9 (Belfast 1974), 137–159.
15. David N. Dumville, 'Kingship, genealogies, and regnal lists', in: P. H. Sawyer & I. N. Wood (eds.), Early medieval kingship (Leeds 1977) 72–104.
16. Donnchadh Ó Corráin, An chléir agus leann dúchais anallód: an ginealas, Léachtaí Cholm Cille 16 (1986) 71–86.
17. John Bradley (ed.), Settlement and society in medieval Ireland: studies presented to F. X. Martin (Dublin 1988).
18. Dáibhí Ó Cróinín, Early medieval Ireland: 400–1200 (Dublin 1995).
19. Gerard Moran and Raymond Gillespie (eds.), Galway history and society: interdisciplinary essays on the history of an Irish county (Dublin 1996).
20. Donnchadh Ó Corráin, 'Creating the past: the early Irish genealogical tradition', Peritia 12 (1998) 177–208.
21. Alfred P. Smyth (ed.), Seanchas: studies in early and medieval Irish archaeology, history and literature in honour of Francis J. Byrne (Dublin 2000).
22. Patrick J. Duffy, David Edwards, and Elizabeth FitzPatrick (eds.), Gaelic Ireland, c.1250–c.1650: land, lordship, and settlement (Dublin 2001).
23. Donnchadh Ó Corráin, 'Prehistoric and Early Christian Ireland', in Roy Foster (ed.), The Oxford Illustrated History of Ireland (Oxford 2001) 1–52.
24. Paul MacCotter, Medieval Ireland: territorial, political and economic divisions (Dublin 2008).
25. Michael Herity, 'Whitley Stokes's correspondence with John O'Donovan, 1857–1861', Studia Hibernica, 36 (2009–2010) 9–89.
**Literature: John O'Donovan and the Ordnance Survey**2. Patricia Boyne, John O'Donovan (1806–1861): a biography (Kilkenny 1987).
3. H. Richardson (ed.), Ordnance survey memoirs for the parishes of Desertmartin and Kilcronaghan 1836-1837 (Magherafelt 1986).
4. Michael Herity (ed.), Ordnance Survey letters: letters containing information relative to antiquities collected during the progress of the Ordnance Survey [by John O'Donovan, Eugene Curry, Thomas O'Connor, Patrick O'Keeffe and others], with an Introduction and prefatory matter (Dublin 2001-).
5. Gillian M. Doherty, The Irish Ordnance Survey: History, culture and Memory. Dublin 2004.
**The edition used in the digital edition**2. The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country. John O'Donovan (ed), First edition [212 pages] Irish Archaeological SocietyDublin (1843)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition represents Introduction (pp 1–21) and main body (pp 24–92) of the text. The Irish text is on the even pages, with facing English translation on the odd pages. The translation is appended. The extensive textual notes are included and tagged *note type="auth" n=""*. They are also included in the wordcount above. The editor's appendix is omitted. A map included in the printed edition is at various points mentioned by O'Donovan.


#### Editorial Declaration


##### Correction


The Irish text has been proof-read three times, translation and notes twice.


##### Normalization


The electronic text represents the edited text in line with CELT practice. Text in Latin/English is marked. Normal CELT conventions have been applied in regard to text divisions, word segmentation, and capitalization in proper names. Some typographical errors in the translation are corrected using corr, with the original spelling retained in its sic attribute.


##### Quotation


Direct speech is tagged q. Citations are tagged cit. This element contains bibl and qt elements.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the genealogy; div1=the original/translation; div2=the section within original/translation; div3=the sub-section. Paragraphs are marked; page-breaks are marked pb n="". MS foliation is not indicated in the printed edition.


##### Interpretation


Some group-names and place-names are tagged, Irish cultural terms retained in the English translation are marked term lang="ga".


#### Canonical References


This text uses the DIV2 element to represent the section. ### Profile Description


Created: 
 Date range: 900–1200 [Irish text].
 (1842 [translation]) #### Use of language


##### Language: [GA] The text is in Middle Irish.


##### Language: [LA] Some words are in Latin.


##### Language: [EN] Introduction, translation and footnotes are in English.


### Revision History


* (2014-04-23) Beatrix Färber (ed.)

* Item added to bibliographic details.
* (2011-10-14) Beatrix Färber (ed.)

* Additions made to bibliographic details and minor changes to header; new wordcount made. Encoding improved.
* (2010-04-10) Beatrix Färber (ed.)

* Conversion script run; header updated; new wordcount made; encoding of personal and group names in Introduction improved and updated.
* (2008-09-29) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-27) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T15:34:28+0100) Peter Flynn (ed.)

* Converted to XML
* (2004-06-24) Beatrix Färber (ed.)

* Divisions restructured; all footnotes numbered, introduction and footnotes proofed (2), main part proofed (3), quotations, names, places and terms marked up; content markup extended; additions to bibliography; HTML file created.
* (2004-05-26) Benjamin Hazard (ed.)

* Introduction proofed; structural and content markup added; file parsed.
* (2004-05-24) Beatrix Färber (ed.)

* Footnotes numbered; Latin and English parts marked up; minor changes to header.
* (2004-05-20) Benjamin Hazard (ed.)

* File proofed (2); structural and content markup applied to text; header created; bibliography compiled; file parsed.
* (2004-05-07) Benjamin Hazard (text capture)

* Additional text captured by scanning.
* (Pre-1997) Staff of the CURIA project (text capture)

* Text captured by scanning and file proofed (1).




---


#### Corpus of Electronic Texts Edition: G105007


### The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country: Author: Unknown




---

p.1


### Introductory Remarks


The following account of the families and customs of Hy-Many is printed from the Book of Lecan, fol. 90 to 92, exactly as it stands in the original, excepting only that the contractions are not retained, and such grammatical marks are introduced as were deemed necessary to render the language intelligible to an Irish scholar not familiar with MS. abbreviations. The Book of Lecan was compiled from various other MSS. for **Gilla Iosa More Mac Firbis**, chief historian of the **O'Dowds of Tireragh**, in the county of Sligo, about the year 1418; but the work has been already so well described by **O'Reilly**, in his Irish Writers (vol. i. of the Transactions of the Iberno-Celtic Society), that it is not necessary to give any detailed description of it in this place.


Whether the tract on the customs of Hy-Many was originally composed at the period of the compilation of the Book of Lecan, or transcribed from an older MS., we are not at present able to decide satisfactorily, as no other copy of it has been discovered, but it is highly probable that it was transcribed, and perhaps abridged, from some MS. belonging to the territory of Hy-Many. The Book of Hy-Many, supposed to contain various tracts relating to the territory, is still in existence, and is believed to be in the possession of a private collector in England; it is, however, inaccessible to the Editor, who


---

p.2




is therefore unable to say, whether the tract, now for the first time printed, is to be found in that MS. or not; but if we may judge from the account of its contents published by **O'Reilly** (ubi supra, p. 122), we should be led to conclude that the book of Hy-Many does not contain this tract, and hence it may fairly be doubted whether a second copy of it is now extant, The **Rev. Patrick Mac Loughlin**, in his abstract of the Book of Lecan, states, that this is the most curious tract in that volume.


As none of our writers has yet described the boundaries of the famous territory of Hy-Many, or given any detailed account of its history, it will be necessary here to point out its limits, and to give a brief outline of the principal historical events with which it is connected. **Denis H. Kelly, Esq. of **Castle Kelly****, has kindly sent the Editor the following account of the extent of Hy-Many, which is worth preserving, though far from being perfect: 
Between the reigns of Colla Uais, 130th monarch of Ireland, A. D. 327, and that of Coelbad, 132nd monarch, A. D. 357, Maine the Great, the son of Imchad, and grandson of Donald, who was the son of Achy Ferdaghiall, obtained Imania in the south of Connaught and county of Galway, which his posterity greatly enlarged and extended beyond the river Suck to the Shannon, through the county of Roscommon. This territory of Imania was variously called Hymanny, Imanny, Ithmania, Mainech, Ivemaine, Hymaine, Omaine, Omanny, or Uimaine, and appears from various authorities to have consisted of the southern part of what is now called the county of Roscommon, and the northern part of the county of Galway. What its exact extent was cannot now be positively ascertained; but from the various family estates at present belonging, and those which are well known formerly to have belonged, to persons of the name of Kelly or O'Kelly, in that particular part of the kingdom, as well as from the different old castles which popular tradition and historical records point out as having been built by, or in the possession of the O'Kellys, there is good reason to suppose that it extended over the barony of Athlone, in the county of Roscommon, and the baronies of Ballymoe, Tiaquin, Killian, and


---

p.3




Kilconnell, in the county of Galway; and this conjecture is strengthened by an old pedigree in the possession of the Rev. A. Kelly, of Castle Kelly, the present head of the name, compiled by that learned antiquarian, **Charles O'Conor, Esq., of **Belanagare****, which, in its account of the family, between the years 1393 and 1423, mentions the barony of Tiaquin, as the appanage of one younger son; the barony of Kilconnell, as that of another; the barony of Athlone, as that of a third; and the lands of Rahera, as that of a fourth, and which styles the eldest son by the second wife as Teige More of Cruffon, a name by which the peasantry still designate a large district in the county of Galway, long celebrated for its coarse linen manufacture, containing the barony of Killian and a large part of Ballymoe.’’




Among the castles built by the O'Kellys, and which are all situated in this district, are those of Moate, near Roscommon; Galy, on the borders of the Shannon, near Knockcroghery; Athleague, Corbeg, and Skryne, in the county Roscommon, and Garbally, Aughrim, Monivea, Gallagh, Mullaghmore, Moy-lough, and Aghrane, now Castle Kelly, in the county of Galway. The Abbey of Kilconnell was also reconstructed by William O'Kelly, and Knockmoy, Clonmacnoise, and Clontuskert, experienced the liberality of the chiefs of Hy-maine. **Sir Richard Cox**, in his explanatory index to his History of Ireland, has the word 'Imanya;' to which is added as explanation, ‘O'Kelly's country, in the counties of Galway and Roscommon; the O'Kellys were kings of this country.’ In **Ware**'s Antiquities, Hymaine is mentioned as ‘a territory in the county of Galway, bordering on the county of Roscommon, and at times extended by conquest into it, usually called Mainech, the O'Daly's country and the O'Kellys.’ In the Pacata Hibernia, we find ‘that the parliament army retreating from Munster, passed vaguely through the county of Galway, until they came to the Kellys' country, where they were fought withal by Sir Thomas Burke, the Earl of Clanricarde's brother and Sir Thomas Maltby, who were more in number than the rebels;’ and **Camden**, in his Brittannia, treating of the county of Roscommon, mentions: ‘More southward lies Athlone, the barony of the O'Kellys.’ From these authorities the above conjecture assumes considerable probability, and Hymaine appears entitled to a respectable situation among the petty sovereignties of Ireland.’’




‘Hy-Maine’ signifies ‘Maine's territory’; ‘Hy’ or ‘I’ being the plural of ‘Ua’ or ‘O’, a grandson, and is frequently prefixed to the name of any remarkable progenitor 


---

p.4




of a family, as well to particularize the family as the lands they possess. In a note to the word O'Kelly, in the Memoirs of **Charles O'Conor, Esq., of **Belanagare****, are the following words: Antiquissima haec familia originem ducit ab Imchado Regulo Iathmainiae, cujus posteri ab ipsius pro nepote Maino magno assumpserunt nomen Iathmainiae seu Hymainy, quod praedia Mainiae significat, atque ab eo descendentes usque ad Thaddaeum de Tailtionn, cujus tempore Angli invaserunt Hiberniam, Iathmainiae Reguli nuncupati sunt, et multa habuerunt privilegia a regibus Connaciae. Possidebant tertiam partem omnium praedarum et naufragiorum, necnon fodinarum auri et argenti et mettallorum, pluraque alia quae in antiquis Chronicis nominantur.’’




‘**O'Halloran**, in his Introduction to the History and Antiquities of Ireland, says, ‘the M'Dermotts were hereditary marshalls to the kings of Connaught, and the O'Kellys hereditary treasurers;’ and in the commencement of the pedigree now in the possession of the Rev. A. Kelly, compiled by **Charles O'Conor, Esq., of **Belanagare****, it is stated: ‘The illustrious family of Hymanny, who, since the reception of surnames in the eleventh century, took the name of O'Kelly, had a territory in Connaught of about 200 square miles, extending through the county of Galway, and the southern part of Roscommon, as far as the river Shannon.’’


But fortunately we are not left to guess at the extent of this ancient territory, for its exact boundaries are given in a vellum MS. preserved in the Library of Trinity College, Dublin (H. 3. 18. p. 412). And as this short but important document appears to have been unknown to all our writers, and has never been published, I shall transcribe it, word for word as it stands in the original, dispensing with the contractions as usual. It will show that Hy-Many originally extended from Clontuskert, near Lanesborough, in the county of Roscommon, southwards, to the boundary of Thomond or the county of Clare, and from Athlone, westwards, to Seefin and Athenry, in the present county of Galway.


Criochairecht O Maine.
‘Secht tricha, secht tuatha, secht m-baile, secht leath-bhaile. O **Cluain Tuaiscert**


---

p.5




na **Sinna** co h-**Aireanach**; ó **Aireanach** co **Rinn Duin**; ó **Rinn Duin** co **Rinn Cleatchair**; ó **Rinn Cleathchair** co **Ath Luain**; ó **Ath Luain** co **Snamh dá Én**; ó **Snamh dá Én** co **Ath Crocha**; ó **Ath Crocha** co **Lusmhagh**; ó **Lusmhagh Deirgdeirc**; ó **Deirgdheirc** co **Gréin**; ó **Gréin** co **Suidhe Finn**; ó **Suidhe Finn** co **Ath na Riogh**; ó **Ath na Riog** co **Umnaig**; ó **Umnaig** co **Ath in Saluin**; ó **Ath in Saluin** co **Tir Mic Tréna**; o sin co h-**Escir Alaing**; o tha sin co h-**Ath Mogha**; o tha sin co **Sidh Neannta**; o tha sin co teit 'sa **Sinainn** arís.’


Boundaries of Hy-Many. 
It contains seven cantreds, seven tuathas, seven townlands, seven half townlands.
Its boundary extends from Cluain Tuaiscert[1](javascript:footNote('G105007/note001.html')) na Sinna to Aireanach;[2](javascript:footNote('G105007/note002.html')) from Aireanach to Rinn Duin;[3](javascript:footNote('G105007/note003.html')) from Rinn Duin to Rinn Cleathchair;[4](javascript:footNote('G105007/note004.html')) from Rinn Cleathchair to Ath-Luain;[5](javascript:footNote('G105007/note005.html')) from Ath-Luain to Snamh da en;[6](javascript:footNote('G105007/note006.html')) from Snamh da en to Ath Crocha;[7](javascript:footNote('G105007/note007.html')) from Ath Crocha to Lusmagh;[8](javascript:footNote('G105007/note008.html')) from Lusmagh to Deirgdeirc;[9](javascript:footNote('G105007/note009.html')) from Deirgdeirc to Grian;[10](javascript:footNote('G105007/note010.html')) from Grian to Suidhe Finn;[11](javascript:footNote('G105007/note011.html')) from


---

p.6




Suidhe Finn to Ath na riogh;[12](javascript:footNote('G105007/note012.html')) from Ath na riogh to Umnaigh; from Umnaigh[13](javascript:footNote('G105007/note013.html')) to Ath an saluin;[14](javascript:footNote('G105007/note014.html')) Ath an saluin to Tir Mhic Trena;[15](javascript:footNote('G105007/note015.html')) from thence to Escir Alaing;[16](javascript:footNote('G105007/note016.html')) from thence to Ath Mogha;[17](javascript:footNote('G105007/note017.html')) from thence to Sidh Neannta;[18](javascript:footNote('G105007/note018.html')) and thence to the Shannon again.’’




The same boundaries are given in a short poem preserved in another vellum MS. in the Library of Trinity College: but as this poem gives only one additional name, viz. Magh Muaidh, which is the plain near Knockmoy Abbey, it is not inserted here, to avoid the unnecessary repetition of what has been already given in prose.


The most conspicuous of the same boundaries are also mentioned in a MS. poem in the same library, addressed to William, son of Donogh,


---

p.7




who was son of Conor O'Kelly, on the occasion of his having invited all the poets, minstrels, and other professors of art in Ireland, to his house, in the year 1457. In this poem it is stated, that William, the son of Duvessa (his mother), had got possession of the entire territory of Hy-Many, extending, according to its well known boundaries, from Grian to Caraidh.


That he recovered such parts of the principality of his ancestors as had been wrested from them by adventurers, and that he even took possession of some portions of the territories of his neighbours; that the three celebrated fords called Ath na Riogh,[19](javascript:footNote('G105007/note019.html')) Ath Luain,[20](javascript:footNote('G105007/note020.html')), and Ath-liag,[21](javascript:footNote('G105007/note021.html')) were included in his principality, and that his lands were bounded by the great lakes of Loch High, and Loch Dergdherc; and also that the great plain of Maonmhagh [Moinmoy], the ancient patrimony of the Clanna Moirne, which had been in the occupation of strangers till William grew up, was again restored to the Hy-Many, and divided among their septs.


It is also stated in a poem addressed to Eoghan O'Madden, chief of Sil Anmchadha, contained in a fragment of the Book of Hy-Many, preserved in the Library of Trinity College (H. 2. 7. p. 190), that Uaran, now Oran, in the county of Roscommon, Lusmagh in the now King's county, and even Lough Greine, now in the north of the county of Clare, were a part of Hy-Many; and it is stated in a second poem, preserved in the same MS., addressed to the same chieftain, that Hy-Many extended from Grian to Caraidh, and included Dun Imghain, now Dunamon, Inis Clothrann in Lough Ree, and Inis Cealltra in Lough Dergdherc.


To give any thing like the history of Hy-Many would far exceed


---

p.8




the limits which the Editor intends for this preface, and the reader must rest satisfied with a brief account of the first formation of the principality by Maine Mor, the ancestor of all the Hy-Many, and a list of the successive chiefs from Maine Mor, as they are given in a poem addressed to Eoghan O'Madden, who died in 1347.


The most authentic and most circumstantial account of the first settlement of Maine Mor, ancestor of all the Hy-Maine, and his people, in this territory, is preserved in the Life of St. Grellan, the patron of this tribe, who flourished in the fifth century, a paper copy[22](javascript:footNote('G105007/note022.html')) of which is preserved in the Library of the Royal Irish Academy. In this Life, it is stated, that this part of the province of Connaught was in the possession of the Firbolgs in the time of St. Patrick and St. Grellan, and that the latter was assigned a place called Achadh Fionnabhrach, by Duach Gallach, king of Connaught, where the saint built a church before Maine Mor arrived in Connaught. I shall present the reader with the whole account of the settlement of Maine and his people in this district, as contained in this work. After giving a detailed account of the baptism of Eoghan Sriabh, the son of Duach Gallach, king of Connaught, and of a miracle performed by St. Grellan, the biographer proceeds as follows: Do berthar an baile seo, ina n-dearnadh an miorbuile si do, .i. Achadh Fionnurach a ainm conuigi sin, agus Craobh Ghreallain a ainm o sin a leith, o'n craoibh sheilbhe thucc Duach agus Padraicc


---

p.9




do Ghreallan ann, agus ro orduic cios do'n maicchleireach, .i. seacht m-bruit o gach bainrioghain; agus ar n-orducchadh na cana, do iarr coruidheacht Phadraicc fris in chios chanadh sin do; agus tuccadh iar sin.’’




Agus as a h-aithle sin do luidh Greallan a d-trian uachtarach an chuiccidh sin, go raibhi acc siubhal an tire, agus nir oiris a mheanma for inadh dar imgidh no go rainic Macch Seincheineoil, baile a raibhi Cian d'Fearaibh Bolg, ri an tire, agus airiseas i g-ceand an erlaimh for an ionadh sin, .i. Cill Cluaine a ainm.’’


As i sin aimsir in ar iomraidhedar aicme Colla da Chríoch teacht a h-Oirgiallaibh, agus ar eadh a dubhradar: Is lionmhar ar laochraidh, agus as ádhbhal ar n-oireacht, agus a ta ár n-aicme ar n-iomdugadh, agus ní bh-fhuiccheam ionad a n-aon chuicceadh uile gan fás easccairdis ettruinn, oir ni maith fhuilngid na h-uaisle a g-cúmhgach; agus a dubradar, 'Feucham cia an chuicceadh ina teirce daoine do'n Bhanba, agus ina lia d'Fhearaibh Bolcc, agus cumhgaidhiom orra é. Ata cuigeadh Chonnacht acc na h-Aithigh Tuathaibh, acht cios uathoibh diar m-brathair-ne, agus ionsaighiom é.' agus as iad ro chan an comhrádh so, .i. Máine Mor, o sloinntior na sluaicch, agus Eochaidh Fear da ghiall, a athair, ag a rabhadar geill Uladh agus Oirghiall a n-aoinfheacht.’’


Do ghluaisiodar na glan-shluaigh sin go h-obann, arrachta, 'na g-catha coirighthe, co na d-taintib agus tredaib, o Chlochar mac Daimhin go Druim Clasach, ris a n-abarthar Tir Maine, itir Loch Ri agus Suca. Ro airgeadar an tír, agus ro chuirsiod teachta uatha go Cian, .i. tigerna an tire, go Mag Seinchineoil, agus ro innisiodar aicme Cholla dá Chrioch do bheith acc cuinge cíosa agus criche fair; agus ro h-eaglaigheadh Cian ris na h-iomráitibh sin. Ro thinoil a throm shluaicch, agus ro b'é a lion, .i. deic cet ar fichit, ac a raibi scciath, agus cloideamh, agus cathbarr, amhail atbert an rann:’’



> 1. Aoin-fhear as gach lios amach,
>   
> as eadh do ticceadh le Cian
>   
> a Macch Seinchineoil, ní breucc,
>   
> deich cét ar trichad cet scciath.
> 


The place where this miracle was wrought, i.e. Achadh Fionnabhrach by name, was granted to St. Grellan, but it has been ever since called Craobh Greallain, i.e. the branch of Grellan, from the branch which king Duach and St. Patrick presented to St. Grellan, in token of possession. And the king also ordered, that seven garments should be given from every chieftain's wife, as a tribute to the young cleric; and when this tribute was ordained, St. Grellan asked the guarantee of St. Patrick for the payment of it, which was agreed to.’’


After this St. Grellan proceeded to the upper third of that province, and continued to traverse the country; but his attention was not fixed on any place over which he had passed, till he cae to Magh Seincheineoil, of which Cian, who was of the Firbolgic race, was king, who waited on the saint at the place where he was then staying, since called Cill Cluaine.[23](javascript:footNote('G105007/note023.html'))’’


It was at this period the race of Colla da Chrioch meditated to migrate from Oirghialla, and they said: ‘Numerous are our heroes and great is our population, our tribe having multiplied, and we cannot all find room in any one province without quarrelling among ourselves, for nobles cannot well bear to be confined;’ and they also said: ‘Let us see which province of Banba is thinnest in population, and in which most Firbolgs remain; and let us narrow it on them. The province 


---

p.10




of Connaught is in the possession of these **Attacots**, excepting that they pay tribute to our relative, and let us attack it.’ Those who held this conversation were Maine Mor, from whom the hosts of Hy-many are named, and Eochaidh Ferdaghiall, his father, who had the hostages of Ulidia and Oirghialla together.’’


These fine hosts suddenly and heroically proceeded in well arranged battalions, with their flocks and herds, from Clochar Mac Daimhin[24](javascript:footNote('G105007/note024.html')) to Druim Clasach, which is called Tir-Many, *situated* between Loch Ri[25](javascript:footNote('G105007/note025.html')) and the river Suca [Suck]. They plundered the country, and despatched messengers to Cian, lord of the country, to Magh Seincheineoil, and they told him that the descendants of Colla da Chrioch had come to demand tribute and territory from him. And Cian was terrified by these sayings. He assembled his great forces, and their number was thirty hundred, who bore shield and sword and helmet, as the rann states:


---

p.11



> 1. * One man out of every fort
> 	  
> 	is what went forth with Cian,
> 	  
> 	In Magh Seincheineoil,—no falsehood,—
> 	  
> 	ten hundred and thirty hundred shields.
> 




Agus ro b'e fad agus leathad an mhuighe, .i. ó **Dhun na Riocch** go h-**Abhainn Bairrchinn**, agus o **Ath n-Fasdoicc** go h-**Ath n-Dearg Duin**, re n-abarthar **Ath an Chorrdhoire**; agus nir fhan Cian do'n ruathar sin, no go rainic go h-iomurlar **Thire Maine**, agus no thinóilsiod an fheadhan dob' uaisle díobh dá n-ionnsaiccheadh ann sin; agus so thabhacht do Greallan sin, .i. sliocht Colla da Chrioch do bheith is in guasacht sin, agus no ghluais go tinniosnach dia d-teasarccain, agus as ann ro oiriseadar an dá fheadhain, agus ro choiscc a g-ceannfhairrcce, agus ro shnaidhm sith etorra, agus ro ordaicch tri n-aonmhuir o na h-uaislibh a laimh Cein fria chomhal sin. Agus Amhalgaidh, mac Maine Moir, as é fa h-uaisle do na h-eitiribh sin, agus tuccadh a laimh rachtaire Chein é. Agus gradhaigios bean an rachtaire e, agus ar na aithne sin do'n rachtaire líonas lonus agus mioscais na bráicche é, treas an mnaoi, agus téid mar a raibhi Cian, agus cuireas faoi milleadh na m-bracchadh gan fhuireach a n-aon oidhche. Agus do bhí ionad coinne ar na mhárach acc Cian co n-a shochraide ar **Macch Seimhni**, .i. n-imiol **Muighe Seinchineoil**, re h-Echaidh agus re Maine, agus re beccan do mhaithibh a muintire; agus ro chumadar go raibhi fleadh acc Cian ina comhair, agus ni h-eadh ro baoi acht feall; agus tarfas do Greallan an comhairle sin, oir as é fein do budh cor etorra, agus as é ionadh a raibhi Eochaidh agus Maine a m-bun a m-**Bearrnaicch na n-Arm** a n-ucht **Maenmuighe**, re n-abarthar an **Seisidh Beacc**.’’


And the length and breadth of the plain was from Dun na riogh to the river of Bairrchinn, and from Ath n-Fasdoig to Ath Dearg-duin, which is now called Ath an Chorrdhoire; and Cian delayed not on this occasion until he had reached the plain of Tir-Maine, and the noblest tribes among the race of Colla came to meet them there; and it was shown to St. Grellan how the race of Colla Da Chrioch were in this peril; and the saint came speedily to protect them, and he repressed both parties, and checked their animosity, and ratified a peace between them, and ordered that three times nine persons out of their nobility should be given into the hands of Cian, *as pledges* to observe this *peace*. Amhalgaidh, the son of Maine, was the noblest of these hostages, and he was delivered into the hands of Cian's lawgiver. And the wife of the lawgiver fell in love with him, which when the lawgiver had observed, he was filled with jealousy, and hatred of the prisoner, on account of the wife; and he went to where Cian was, and induced him to kill the hostages without delay in one night. On the day following, Cian and his forces had a conference at Magh Seimhni, on the confines of Magh Seincheineoil, with Eochaidh and Maine, and a few of the chiefs of their people; and it was pretended that Cian had a feast prepared for them, but he had not but treachery. This design was made known to St. Grellan, who was the guarantee between them. At this time Eochaidh and Maine were at the foot of Bearnach na n-arm in Maenmagh, now called Seisidh beag.’’




---

p.12


O 't-chonairc Greallan o dhorus a **reclera** na h-armo con mor shochraide sin, sinidh an da dhóid do chum an Duileamhain, iar n-a imdhearccadh ar eagla a slánaiccheachta do mhilleadh, agus fuair a itghe ó Dia, gur boccadh an magh mor sin fo chosaib Chéin co n-a mhuintir, go n-dearnadh cuthaidhe agus criathrach de, gur sluicceadh Cian co n-a mhuinntir tres na feartaibh sin: conadh **Mag Liac** ainm an mhuighe sin ó dhoilgios na laochraidhe d'a n-dioghbail do'n naomh-chléireach. Tainic Maine co n-a mhuinntirr a bail a raibh Greallán, agus ro chromadar na cinn do, agus ro inis doibh mar do fhealladh orra, agus mar do shaer Dia agus é féin iad ar lucht an fhill. At-bert Greallan friu; ‘tabhruídh-si an tír si, agus fuathaídh an feall, agus biaidh mo bheannacht-sa accaibh, agus coimhéadaigh bár m-braithrios, agus orduiccídh mo cháein agus mo dhligh féin dam-sa ó niodh go brath.’ ‘Beir-si féin,’ bar Maine, ‘an bhreath bhus áil dhuit.’ ‘Berad,’ bar eisiomh, agus at-bert Greallan an athchumair si sios.’’




---

p.13



> 1. Mor mo chain ar cloinn Maine,
>   
> sgreaball gacha h-aon bhaile,
>   
> a ratha bhíos go ro-ghlan, réidh;
>   
> ní cíos gan adhbhar éiséin.
> 2. Céd ghin gacha cloinne dhamh,
>   
> dhá m-baisder liom do bunadh,
>   
> a cíos c*h*ugam as cíos cruaidh,**
>   
> gach céd arc is gac céd uan.
> 3. Liom, go madh liaiti a n-eallach,
>   
> ó chloinn Maine an céd shearrach,
>   
> tionnlaicid a cíos dom' cill,
>   
> i n-éccmais criche is fearuinn.
> 4. Dál n-Druithne ní dhlicchim de,
>   
> cíos no freaccradha oile,
>   
> do cluintear go teand a n-dál;
>   
> ni leam Muintir Maeilfhinnáin.
> 5. Na Maineach ó sin amach,
>   
> liom a g-cáin is a g-cabhach,
>   
> Dínaid mo cheall da coimhde,
>   
> liom a g-ceann sa g-coimheircce.
> 6. A m-buadh 's a n-geasa sin,
>   
> me do ordaigh gan ainimh.
>   
> An feadh ra bhuid do mo reir,
>   
> buaidh gach catha is a cathréim.
> - Dénuid na gradha garcca,
>   
> comairle mo chomharba,
>   
> I measg Gaoidheal tuaith is teas,
>   
> is riar h-aoinfhir gan aimhleas.
> - Taithaidh mo chill crédmhigh,
>   
> do ainic gach n-ainéccidh
>   
> na h-eurat a cain dam-sa,
>   
> do ghébhut mar gheallam-sa.
> - Mo bheannacht ar an sliocht seang,
>   
> ar chloinn Maine na bh-fithcheall,
>   
> ní bladhfidear for an chloinn,
>   
> acht go roisiot mo bhachall.
> - Meircce catha na cloinne
>   
> mo bhacall go fír-thoicche,
>   
> nocho n-eatfaid catha a g-clodh,
>   
> beud a ratha go ró-mhór.
> Mor, &c.
> 



When St. Grellan had, from the door of his church, perceived these arms, and these great hosts, he raised his two hands to God, being apprehensive that his guarantee would be violated, and he obtained his request from God, for the great plain was softened and made a quagmire under the feet of Cian and his people, so that they were swallowed into the earth; and the place received the name of Magh Liach, i.e. the plain of sorrow, from the sorrow of the heroes, who were thus cut off by the holy cleric. Then Maine and his people came to where St. Grellan was, and bowed down their heads to him, and he told them how treachery had been designed for them, and how God and himself had saved them from those treacherous people.[26](javascript:footNote('G105007/note026.html')) St. Grellan then said to them, ‘take possession of this territory, abominate treachery, and you shall have my blessing; observe brotherly love, and ordain my tribute and my own law for me from this day out for ever.’ ‘Pass thy own award,’ said Maine, ‘in whatever is pleasing to thee.’ ‘I will,’ said St. Grellan, and he repeated these brief verses following:’’



> 1. Great is my tribute on the race of Maine,
>   
> a screaball *scruple* out of every townland,
>   
> Their successes shall be bright and easy;
>   
> it is not a tribute acquired without cause.
> 2. The first born of every family to me,
>   
> that are all baptized by me,
>   
> Their tribute *paid* to me is a severe tribute,
>   
> every firstling pig and firstling lamb.
> 3. To me belongs—may their cattle thence be the more numerous;—
>   
> from the race of Maine, the firstling foal,
>   
> Let them convey their tributes to my church,
>   
> besides territory and land.
> 4. From Dal Druithne I am not entitled to
>   
> tribute or other demands,
>   
> Their fame is much heard of;
>   
> the Muinntir Maeilfinnain belong not to me.
> 5. Of all the Hy-Many, these excepted,
>   
> the tributes and rents are mine,
>   
> Let them protect my church for its God.
>   
> Their chief and his subjects are mine.
> 6. Their success and injunctions
>   
> it was I that ordained, without defect.
>   
> While they remain obedient to my will,
>   
> they shall be victorious in every battle.
> 7. Let the warlike chiefs observe
>   
> the advice of my successor,
>   
> And among the Gaels north and south,
>   
> their's shall be the unerring director.
> 8. Frequent my sacred church
>   
> which has protected each refugee,
>   
> Refuse not *to pay* your tribute to me,
>   
> and you shall receive as I have promised.
> 9. My blessing on the agile race,
>   
> the sons of Maine of chess-boards,
>   
> That race shall not be subdued,
>   
> so as they carry my crozier.
> 
> 
> ---
> 
> p.14
> 
> 12. *Let* the battle standard of the race
>   
> *be* my crozier of true value,
>   
> *And* battles will not overwhelm them,
>   
> their successes shall be very great.
> Great, &c.
> 
> 


It is also stated in a poem, addressed to the celebrated **Eoghan O'Madden**, chief of Sil-Anmchadha, written previously to the year 1347, that his ancestors came from Clochar mac n-Daimhin.


In a poem addressed to the same chieftain, a curious list of the chiefs of Hy-Many, of whom seven were his ancestors, is given; and though the list cannot be considered perfect, it is nevertheless valuable, as preserving the names of several chiefs of this territory not to be found in any other authority; without it nothing like an accurate series of the early chiefs of Hy-Many could now be given, as the Irish annals are imperfect.

1. Maine Mor, ancestor of all the Hy-Many, was chief of the territory for fifty years, after which he died a natural death.
2. Bresal, son of Maine, thirty years, when he died a natural death, which the poem states was surprising, as he had been much engaged in wars.
3. Fiachra Finn, the son of Bresal (No. 2), seventeen years, when he was treacherously slain by his brother Maine Mall. Fiachra Finn is styled in the poem, ‘a tower in conflict and battle.’ He is the ancestor of the O'Naghtens and O'Mullallys or Lallys.
4. Conall Cas-ciabhach, *i.e. of the curled tresses*, was prince of Hy-Maine, twenty-two years, when he was slain. He was brother of Fiachra Finn.
5. Dallan, who was also a brother of Fiachra Finn, was prince of Hy-Maine for eleven years, when he was mortally wounded and afterwards drowned.
6. Duach, the son of Dallan (No. 5), was prince of Hy-Many for sixteen years, when he was slain by Maine Macamh. He is called in the poem ‘a good man, and an impartial distributor of justice.’
7. Lughaidh, the son of Dallan, and brother of Duach, was prince or chief ruler of Hy-Many for fourteen years, when he died a natural death.


---

p.15

10. Feradhach, the son of Lughaidh, was prince of Hy-Many for twenty-four years, when he was slain by his successor.
11. Marcan was chief or prince of Hy-Maine for fifteen years, when he was slain by the sword as, the poem states, he had deserved.
12. Cairbre Crom,[27](javascript:footNote('G105007/note027.html')) son of Feradhach, prince of Hy-Many nine years, when he was slain by his successor. He granted to St. Kieran seventeen townlands in Hy-Many.
13. Cairbre Mac Feachtaine, or Mac Feichine, the son of Feradhach (No. 8), was prince of Hy-Many for twenty-six years, when he was slain by Crimthann, after the former had slain his own brother, Cairbre Crom. He was father of Brenainn Dall, who died in the year 597, and of the celebrated Aedh Guaire, the relative of St. Rodanus of Lorrah, who is mentioned in the account of the cursing of Tara in the Annals of Clonmacnoise. He is the ancestor of the tribe called Cinel Fechin, who were seated in the barony of Leitrim, in the south of the county of Galway.


---

p.16

16. Cormac, son of Cairbre Crom, was prince of Hy-Maine for twenty years, when he died a natural death. This chieftain is called a saint, and the patron of Cill Cormaic.
17. Eoghan Finn, the son of Cormac, was prince of Hy-Many for nineteen years, when he died a natural death. He is the ancestor of the Northern Hy-Maine or O'Kellys.
18. Eoghan Buac, the son of Cormac, and brother of Eoghan Finn, was prince of Hy-Many for nineteen years, when he also died a natural death. He is the ancestor of the Southern Hy-Many or O'Maddens.
19. Fichellach, the son of Dicholla, who was son of Eoghan Finn (No. 13), was prince of Hy-Many for twelve years, when he was slain by the army of Cobhthach, the son of Maelduin, who was son of Donnghallach, who was son of Anmchadh, who was son of Eoghan Buac (No. 14, supra).
20. Cobhthach, son of Maelduin, was prince of Hy-Many for twenty years, when he was slain by Finnachta, son of Oilill, son of Innrachtach, son of Fichellach, son of Dluthach, son of Dicholla, son of Eoghan Finn.
21. Finnachta, son of Oilill, was prince of Hy-Maine for seventeen years, when he was treacherously slain by the son of Cobhthach.
22. Aeiril, or Oilell, the son of Aedh Finn, son of Anmchadh, son of Eogan Buac, was prince of Hy-Maine for fourteen years, when he fell in treachery by Ceallach, the ancestor after whom the O'Ceallaighs, or O'Kellys, have taken their surname.
23. Cellach, son of Finnachta, who was son of Oilill, who was son of Innrachtach, who was son of Fichellach, who was son of Dluthach, who was son of Dicholla, who was son of Eoghan Finn (No. 13, supra), was chief of Hy-Many for eighteen years when he was slain.
24. Diarmaid, the son of Aedh, was prince of Hy-Many for forty years, when he died a natural death. He was one of the seven princes of Hy-Many who were of the O'Madden or Sil Anmchadha line.
25. Tadhg, or Teige Mor O'Kelly, was prince of Hy-Many for thirteen years, when he fell in the battle of Clontarf, fighting on the side of Brian Boru, monarch of Ireland, A.D. 1014.
26. Gadhra, lord of Sil Anmchadha, on the death of Teige Mor O'Kelly, became lord of all Hy-Many, a dignity which he enjoyed for twelve years, when he died a natural death.





---

p.17


Gadhra, the twenty-second prince of Hy-Many, is the last mentioned in the poem from which this list has been taken, and which was addressed to Eoghan O Madden, chief of Sil Anmchadha and presumptive heir of Hy-Many, who died in the year 1347, according to the Four Masters. After giving this list of the chieftains, the Bard goes on to carry the pedigree of his patron, Eoghan O'Madden, from Gadhra, the last of the chiefs he enumerates, down to his own time, as follows:

1. GADHRA, or GARA, was father of
2. MADUDAN (or MADDEN), who was father of
3. DIARMAID, who was father of
4. MADUDAN, who was father of
5. DIARMAID, who was father of
6. MADUDAN MOR, who was father of
7. CATHAL, who was father of
8. MURCHADH, of Magh Bealaigh, who was father of
9. EOGHAN O MADDEN, to whom the poem was addressed.



In another poem, preserved in the same manuscript, and addressed to the same Eoghan O'Madden, the seven chieftains of his family, who became princes of all Hy-Many, are enumerated in the following order: 1. Eoghan Buac, 2. Cobhthach, 3. Oilill, 4. Gadhra Mor, son of Dunadhach, 5. Diarmaid, 6. Oilill, 7. Diarmaid; and the Bard adds, that Eoghan O'Madden himself was expected to be the eighth.


The other chiefs of Hy-Many will be given in the pedigree of O'Kelly, Note A, at the end of this tract. *This is not reproduced in the CELT edition.*


After the Burkes, or De Burghs, had established themselves in the county of Galway, the limits of Hy-Many were very much circumscribed[28](javascript:footNote('G105007/note028.html')), the baronies of Leitrim, Eoughrea, and Athenry, which 


---

p.18




were originally a part of Hy-Many, being seized upon by the Burkes, and made a part of their territory of Clanrickard; and it is remarkable that in the year 1585, O'Madden's country was not considered a part of Hy-Many. In the reign of Elizabeth it consisted only of five baronies, as appears from a curious document to be found among the 'Inrolments tempore Elizabethae,' in the Auditor General's Office, Dublin, dated 6th August, 1585. From this Document the Editor is tempted to present the reader with the following extract, which throws a curious light on the state of Hy-Many in the reign of Queen Elizabeth: Agreement between the Irish chieftains and inhabitants of Imany, called the O'Kellie's country, on both sides of the river of Suck, in Connaught, and the Queen's Majesty, viz. Hugh O'Kelly of Lisecalhone,[29](javascript:footNote('G105007/note029.html')) otherwise called O'KELLY, Teige Mac William O'Kelly, of Mullaghmore[30](javascript:footNote('G105007/note030.html')), and Connor Oge O'Kelly, of Killiane,[31](javascript:footNote('G105007/note031.html')) competitors for the name of Tanestshippe of O'KELLY 


---

p.19




Connor ne Garroghe O'Kelly, of Gallaghe,[32](javascript:footNote('G105007/note032.html')) and Shane ne Moye O'Kelly, of the Criaghe,[33](javascript:footNote('G105007/note033.html')) Generosus; William O'Mannine, of Mynloghe,[34](javascript:footNote('G105007/note034.html')) otherwise called O'MANNINE; Moriartagh O'Concannon, of Kiltullagh,[35](javascript:footNote('G105007/note035.html')) otherwise called O'CONCANNON; Shane O'Naghten, of Moynure,[36](javascript:footNote('G105007/note036.html')) otherwise called O'NAGHTEN; Edmond Mac Keoghe, of Owenagh, otherwise called MAC KEOGHE; Donogh O'Murry, of Ballymurry,[37](javascript:footNote('G105007/note037.html')) otherwise called O'MURRY; Covaghe O'Fallone, of the Milltowne,[38](javascript:footNote('G105007/note038.html')) otherwise called O'FALLONE; and Connor Mac Geraghte, otherwise called MAC GERUAGHTE.[39](javascript:footNote('G105007/note039.html'))


The territory of Imany, called O'Kelly's country, is divided into five principal barronyes, that is to wytte, Athlone, Killconnell, Teaquine, Killyane, and Maycarnane,[40](javascript:footNote('G105007/note040.html')) all which contain 665 1/2 quarters of land, each at 120 acres.’’




---

p.20


It is agreed by all the forenamed parties that the captainshippe and tanistshippe of the said country, heretofore used by the said O'Kellies, and all ellections and Irish customary division of lands shall be utterly abolished and extinct for ever: that Hugh, otherwise called O'KELLY, shall possess these four quarters of land, viz. Lisennoke, Ferranbreaghe, Lysdallen, and Moydowe, now in his possession, and which are situated in Eraght-O'Murry and Mac Edmond's country, in the barony of Athlone, with a chief rent out of various other lands within the said country, which amount in the whole to £56 19s. 6d. during his natural life, and after his death the said lands to be freed and discharged of the aforesaid rents.’’


That Teige Mac William O'Kelly shall have and possess the quarters of Mullaghmore, Cornegallaghe, Carrownesire, and Carrowneboe. And Connor Oge O'Kelly shall have four quarters in and about the town of Killiane, but upon this special condition, which they bind themselves to, that they and their heirs shall henceforth behave themselves like good subjects; shall put no ymposition or chardge upon the inhabyters of the lands, and shall bring uppe their children after the English fashions, and in the use of the Englishe tounge.’’


The Editor cannot close these remarks without returning thanks to those friends who have assisted him in editing and illustrating the present tract on Hy-Many. Among these he has the honor of reckoning D. H. Kelly, of Castle Kelly, Esq., the representative of an ancient branch of the O'Kellys of Hy-Many, who has kindly communicated many curious facts relating to the history and topography of Hy-Many, and with whom the Editor spent some happy days in examining the ancient localities of the territory; also **James Hardiman, Esq.**, the Author of the History of Galway, whose knowledge of the Anglo-Norman records of Ireland is not exceeded, if equalled, by any one now living, and whose acquaintance with the history of


---

p.21




Ireland in general, and with that of his native province in particular, entitles him to a distinguished place among the historians of Ireland. The Editor also feels it his duty to acknowledge the great obligations he owes to **Dr. Todd**, of Trinity College, not only for the facilities he has afforded him in giving him access to the MSS. of the University Library, but also for many valuable suggestions as to the mode of translating and elucidating the present tract. He is further bound to record his obligations to Mr. **Eugene Curry**, whose acquaintance with the contents of the Irish MSS. in the Library of Trinity College and elsewhere is not equalled by any living scholar. And he has likewise to express his gratitude to **Mr. Petrie**, the most distinguished antiquary in Ireland, from whom he first acquired whatever skill he possesses in distinguishing history from fable; and to **Captain Larcom**, of the Royal Engineers, under whom the Editor has been employed for the last twelve years in examining the ancient and modern topography of Ireland, and who has kindly afforded him many facilities in referring to the published Ordnance Maps, for the modern topographical information contained in the notes to the present tract.


J.O'D.


---

p.24


Tuarasgbhail **Ua Maine**
-------------------------

Genealach h-**Ua Maine** and so
-------------------------------


Maine Mor, mac Eachach Fir da Giall, mic Domhnaill, mic Imchada, mic Colla da Crích, aen mhac lais, .i. Bresal. Cuig meic la Bresal, .i. Fiachra Find, ocus Dallan, ocus Conall, ocus Creamthand,[41](javascript:footNote('G105007/note041.html')) ocus Maine Mall, a quo h-**Ui Maine Brengair**. Tri meic Dallain, mic Bresail, .i. Duach, ocus Lugaidh, ocus Loman. Cuig meic Lugaidh, .i. dá Eogan, ocus Cremthand Cael, ocus Fearadach, ocus Findall Fathach, ut dixit poeta:


> 1. Eogan, Eogan, Crimthand Cael,[42](javascript:footNote('G105007/note042.html'))
>   
> fa saer an cinel brathar,
>   
> cuig meic Lugaid, niss timair
>   
> Fearadach, Finnall Fathach.
> 




Tri meic Fearagaidh,[43](javascript:footNote('G105007/note043.html')) .i. Cairpri Crom, ocus Cairpri Mac


---

p.26




Feithine,[44](javascript:footNote('G105007/note044.html')) ocus Nadsluaig, a quo h-Ua Finain. Cairpri, mac Feithine, ceithri meic lais, .i. Brenaind Dall, ocus Aed Abla, ocus Aed Guairi, ocus Loithin.[45](javascript:footNote('G105007/note045.html')) Ocht meic Brenaind Daill, .i. Colman, ocus Coman, ocus Maelbracha, no Cronan, ocus Garban, ocus Toman, ocus Amlaib *al. Amalgaidh*, ocus Maine, ocus Fland.


#### **Clann Chomain**


Conall, mac Cormaic, mic Ceithernaig, mic Fogartaig, mic Fearadaig, mic Eachtgaile, mic Sechnasaigh, mic Congail, mic Eogain, mic Comain, mic Brenaind Daill, mic Cairpri Feichine, mic Fearadaig, mic Luigdheach, mic Dallain, mic Bresail, mic Máine Móir.


#### **Clann Cremthaind**


Murchatan,[46](javascript:footNote('G105007/note046.html')) mac Sochlachain,[47](javascript:footNote('G105007/note047.html')) mic Diarmata, mic Fergusa, mic Murchada, mic Duib-da-Thuath, mic Daimine, mic Daimdairi, mic Ailella, mic Coirbine, mic Aeda, mic Crimthaind Chaeil, mic Lugdach, mic Dallain, mic Bresail, mic Maine Moir.


#### Nunc h-**Ua Nadsluaig** .i. h-**Ua Finain**


Ailell, mac Finain, mic Ceallaig, mic Nadsluaig, mic Fearadaig, mic Luigdeach, mic Dallain, mic Bresail, mic Maine Moir.


#### **Cland Cairpri Cruim**


Cairpri Crom en mac lais, .i. Cormac. Da mac la Cormac, 


---

p.28




.i. Eogan Finn, ocus Eogan Buac. Eogan Finn, dia ta tuaiscert **O Maine**, ocus Eogan Buacc, a quo deiscert **O Maine**.


Ceathrar mac la h-Eogan Finn, .i. Dicholla, ocus Fithchellach, ocus Maelanfaid, ocus Scannlan, ocus Scannall. Maelanfaid eisidi, a quo h-**Ua Duibgind**.[48](javascript:footNote('G105007/note048.html'))


#### **Clann Cernaig** Inso


Connagan mac Cernaig, mic Ailella, mic Cernaig, mic Coscraig, mic Fidchellaig, mic Dicolla, mic Eogain Find.


Cosgrach, mac Cernaig, mic Ailella, ceithri meic deg lais; dibaid iad-sidhein acht cethrar, .i. Flaithem, ocus Cernach, ocus Daithgeal, ocus Duibinnracht. Dubcailli, mac Lachtnain, mic Indrachtaig, mic Fhlaithim, mic Cosgraigh, mic Cernaig.


Loingseach, mac mic Cormaic, mic Ciardeirg, mic Fidgaili, mic Flaithim, mic Cosgraig.


Is iad so for-sloinnti **Sil Cernaig**, .i. h-**Ua Finain**,[49](javascript:footNote('G105007/note049.html')) h-**Ua Laidhin**,[50](javascript:footNote('G105007/note050.html')) h-**Ua Lachtnan**,[51](javascript:footNote('G105007/note051.html')) h-**Ua Conbuidi**,[52](javascript:footNote('G105007/note052.html')) h-**Ua Ullscaid**,[53](javascript:footNote('G105007/note053.html')) h-**Ua Cheinnedid**,[54](javascript:footNote('G105007/note054.html'))


---

p.30




h-**Ua Dorchaidi**,[55](javascript:footNote('G105007/note055.html')) h-**Ua Sidachain**,[56](javascript:footNote('G105007/note056.html')) h-**Ua Furadain**,[57](javascript:footNote('G105007/note057.html')) h-**Ua Cuilein**,[58](javascript:footNote('G105007/note058.html')) h-**Ua Crabadain**.[59](javascript:footNote('G105007/note059.html'))


[60](javascript:footNote('G105007/note060.html'))
#### **Clann Aedagain**


Maelisa Ruadh, mac Saerbrethaig, mic Flaind, mic Gilli Shuasanaig, mic Saerbrethaig, mic Muirchertaig, mic Floind, mic Aedagain, mic Goistin, mic Flaithim, mic Flaithgili, mic Cosgraig, mic Fidchellaig.


Indrachtach, mac Dluthaig, mic Oilella,[61](javascript:footNote('G105007/note061.html')) mic Innrechtaig, mic Dluthaig,[62](javascript:footNote('G105007/note062.html')) mic Fhithchellaig,[63](javascript:footNote('G105007/note063.html')) mic Dicholla, mic Eogain Find, mic Cormaic, mic Cairpri Cruim.


Duibginn, mac Feargaili, mic Ailella, mic Conaill, mic Ailella, mic Innrachtaig.


Ceallach, mac Findachta, mic Ailella, mic Innrachtaig.


#### Clann Flaitheamail, Mic Dluthaig


Maelbrigdi, mac Indrachtaig, mic Flaithnia, mic Flaitheamail, mic Dluthaig.


#### h-**Ua Domnaill**


Domnall, mac Dunchada, mic Muirchertaig, mic Flaithnia, mic Dluthaig,[64](javascript:footNote('G105007/note064.html')) mic Fidcheallaig, mic Dicholla.




---

p.32


[65](javascript:footNote('G105007/note065.html'))
#### **Clann Bresail**, a quo h-**Ui Domnallan**


Domnallan, mac Maelbrigdi, mic Grenain, mic Loingsich, mic Domnallain, mic Bresail, mic Dluthaig, mic Fithchellaig,[66](javascript:footNote('G105007/note066.html')) mic Dicholla, mic Eogain Find.


#### **Clann Fiachra Finn** ann so


Ceithri meic Fiachra Find, .i. Amlaib, Cairpri, Eochaidh, Seisgnia.


#### **Clann Amlaib**


Nechtain,[67](javascript:footNote('G105007/note067.html')) mac Maeilcheir, mic Aengusa, mic Tuathail, mic Miclaeich, mic Conalaig, mic Amalgaid, mic Deinmnedaig, mic Dima, mic Laidgind, mic Maeluidir, mic Aeda, mic Finntain, mic Amlaib, mic Fiachrach Find, mic Bresail, mic Maine Moir.


[68](javascript:footNote('G105007/note068.html'))
#### Genealac h-**Ui Maeilalaid**.


Amlaib, mac Gilli Crisd, mic Domnaill, mic Ceindeidid, mic Domnaill, mic Maelfhalaid, a quo h-Ua Maeilfalaid, mic Concichi, mic Maeltuili, mic Meiclaich, mic Condalaig.


Catt, mac Seisgnia, mic Fiachrach Find, an uair do marb se Ailell, mac Fiachrach Find, do chuaid se co h-Aedan Bruindi Luim, mic Fergusa, mic Eogain, mic Neill Noígiallaig; ocus, is uime a dearthai Aedan Bruindi Luim, .i. a bruinni lom o fhaebraib colg,


---

p.34




ocus arm, ocus tuc Cat Eadan, ingen Aedain, ocus rug sí mac do, .i. Ruadan mac Cait, o fuiled muinnter Ruadhan, ocus ro ansad a comfhagas a shean-athar, .i. Aedan, mac Fergusa, ocus a **Cuil Aneirig** do ansad.


[69](javascript:footNote('G105007/note069.html'))
#### Nunc **Sil Maelanfaid**. Do Genealach h-**Ui Loman**.


Ruaidri, mac Coindligain, mic Draignein, mic Echach, mic Connmaig, mic Forbasaig, mic Coidbeanaig, mic Rechtagain, mic Odrain, mic Maeilenaid, mic Eachach, mic Ainmirech, mic Aengusa Lomain, mic Dallain, mic Bresail, mic Maine Moir, a quo h-**Ua Maine**.


Cuig meic Aengusa Lomain, mic Dallain, .i. da Eochaid, ocus Ainmiri, ocus Carrthach, ocus Fathach, ut poeta dixit:


> 1. Eochaid, Eochaid, Ainmire,
>   
> Carrthach, caime craebdosa,
>   
> drong brathar do airmisa,
>   
> Fathach Finn, mac Aengusa.
> 




#### **Cinel Critain** andso


Flandagan, mac Meiscill, mic Bruagair, mic Findachta, mic Conclochair, mic Faelchon, mic Critain, mic Ainmirech, mic Aengusa Lomain.


[70](javascript:footNote('G105007/note070.html'))
#### **Cinel Fathaidh** inso


Cormac, mac Maenaig, mic Ailibair, mic Colaim, mic Rechtamail, mic Colmain, mic Flaind, mic Aengusa, mic Uradrain, mic Fathaid, mic Aengusa Lomain.




---

p.36


[71](javascript:footNote('G105007/note071.html'))
#### Genealach h-Ui Lomain Findabrach ann so


Fland, mac Cinaetha, mic Donngaili, mic Eachach, mic Airmedaig, mic Congalaig, mic Inndelbaid, mic Daithnennaig, mic Crundain, mic Fergna, mic Aedha Senaig, mic Eachach, mic Ainmirech, mic Aengusa Lomain.


[72](javascript:footNote('G105007/note072.html'))
#### Genealac h-**Ua Cormaic Maenmuigi**.


Niall, mac Cearbaill mic Mailcoba, mic Rudgusa, mic Follachtaig, mic Concaissil, mic Fhachtna, mic Lachtnain, mic Fhindtain Uallaig, mic Seith, mic Cormaic, mic Crimthainn, mic Bresail, mic Maine Moir.


#### Genealach h-**Ua n-Duach**


Duach, mac Dallain, mic Bresail, mic Maine Moir.




---

p.38


[73](javascript:footNote('G105007/note073.html'))
#### Genealach **Chinel Aeda**


Cubaga mac Ceallaig, mic Dungaili, mic Congail, mic Congusa, mic Ronain, mic Maeluma, mic Crimthainn, mic Bresail, etc.


[74](javascript:footNote('G105007/note074.html'))
#### Genealach **Sil n-Anmchada**


Anmchad, mac Eogain Buacc, mic Cormaic, mic Cairpri Chruim, tri meic lais, .i. Dondgalach, ocus Fiangalach, ocus Forbasach. Maelduin, mac Donngalaig, da mac lais, .i. Cobthach, ocus Indrachtach. Gadra, mac Dunagaig, mic Loingsig, mic Dunagaid, mic Cobthaig, mic Mailiduin, mic Donngalaig, mic Anmchada.


Maelcothaig, mac Donngaili, mic Anmchada. Da mac Dunagaig, mic Cobthaig, .i. Loingsech, ocus Draignen, a quo h-Ua Draignen,[75](javascript:footNote('G105007/note075.html')) .i. Ceandfaelad, mac Find, mic Tresaig, mic Draignen, mic Dunadaig. Coig meic Loingsig, .i. Gadra, ocus Gledra, ocus Cinaeth, ocus Currain, a quo h-Ua Churrain,[76](javascript:footNote('G105007/note076.html')) ocus Flandchad, a quo h-Ua Flandchada.[77](javascript:footNote('G105007/note077.html')) Echtigern, mac Gadra, mic Loingsig. h-**Ua Chinaeith**,[78](javascript:footNote('G105007/note078.html')) o Chinaeth, mac Loingsig. h-**Ua Gledra**,[79](javascript:footNote('G105007/note079.html')) o Gledra, mac Loingsich. Dongalach, mac Anmchaid, a quo **Muinnter Chobthaig**,[80](javascript:footNote('G105007/note080.html'))


---

p.40




ocus h-**Ui Donngalaig**.[81](javascript:footNote('G105007/note081.html')) Fiangalach, mac Anmchaid, a quo **Muinnter Chonnagain**,[82](javascript:footNote('G105007/note082.html')) ocus meic Cadhusaig,[83](javascript:footNote('G105007/note083.html')) ocus h-**Ui Ainchine**,[84](javascript:footNote('G105007/note084.html')) mic Ceallaig, ocus h-**Ua Bimnein**[85](javascript:footNote('G105007/note085.html')) mic Muireadaig, ocus h-**Ua Tholairg**[86](javascript:footNote('G105007/note086.html')) mic Neill, ocus h-**Ua Aithusa**[87](javascript:footNote('G105007/note087.html')) mic Neill, ocus h-**Ua Braenain**,[88](javascript:footNote('G105007/note088.html')) ocus **Muinnter Chicharan**,[89](javascript:footNote('G105007/note089.html')) ocus **Muinntir Rodaigi**,[90](javascript:footNote('G105007/note090.html')) ocus **Muinnter Congalaig**,[91](javascript:footNote('G105007/note091.html')) ocus h-**Ua Daigin**.[92](javascript:footNote('G105007/note092.html'))


Uallachan, mac Flaind, mic Flandchada, mic Innrachtaig, mic Mailiduin, mic Donngaili, mic Anmchaid, mic Eogain Buac. Is o'n Uallachan sin **Meg Uallachain**,[93](javascript:footNote('G105007/note093.html')) .i. sein-riga na n-Anmchadach.


Lorcan, mac Muroin, mic Floind, mic Indrachtaig, a quo h-**Ua Dublaich**.[94](javascript:footNote('G105007/note094.html')) Forbusach, mac Anmchada, a quo **Muinnter Lorcain**,[95](javascript:footNote('G105007/note095.html')) ocus **Mic Ceillaig**,[96](javascript:footNote('G105007/note096.html')) ocus h-**Ua Findachtaig**,[97](javascript:footNote('G105007/note097.html')) ocus h-**Ua Coscraid**,[98](javascript:footNote('G105007/note098.html'))


---

p.42




ocus h-**Ua Maenaig**,[99](javascript:footNote('G105007/note099.html')) ocus h-**Ua Connachtain**,[100](javascript:footNote('G105007/note100.html')) ocus h-**Ua Chanain**,[101](javascript:footNote('G105007/note101.html')) ocus h-**Ua Maelduib**.[102](javascript:footNote('G105007/note102.html'))


[103](javascript:footNote('G105007/note103.html'))
#### **Muindter Chobthaig** and so, a quo h-**Ua Gadra**, .i. **Muinnter Madadain**,


Ocus **Muinnter Chinaith**,[104](javascript:footNote('G105007/note104.html')) ocus **Muinnter Tresaig**,[105](javascript:footNote('G105007/note105.html')) ocus **Muinnter Laegairi** mhic Dunadaig, ocus h-**Ua Flannchada**,[106](javascript:footNote('G105007/note106.html')) ocus h-**Ua Gledraig**,[107](javascript:footNote('G105007/note107.html')) ocus h-**Ua Currain**,[108](javascript:footNote('G105007/note108.html')) ocus h-**Ua Aedha**,[109](javascript:footNote('G105007/note109.html')) ocus h-**Ua Cairten**,[110](javascript:footNote('G105007/note110.html')) ocus h-**Ua Chuagain**.[111](javascript:footNote('G105007/note111.html'))


Cland Indrachtaig, mic Mailiduin, .i. **Muinnter Ruairc**,[112](javascript:footNote('G105007/note112.html')) ocus **Mic Brain**,[113](javascript:footNote('G105007/note113.html')) ocus **Mic Muroin**,[114](javascript:footNote('G105007/note114.html')) &ca. ocus **Muinnter Mailchada**, a quo **Muinnter Dublaind**,[115](javascript:footNote('G105007/note115.html')) ocus h-**Ua Flannchada**, &ca. ocus **Muinnter Mailcroin**,[116](javascript:footNote('G105007/note116.html')) **Mic Dungail**,[117](javascript:footNote('G105007/note117.html')) ocus **Muinnter Arrachtan**,[118](javascript:footNote('G105007/note118.html')) ocus **Muinnter Duibgilla**,[119](javascript:footNote('G105007/note119.html')) ocus **Muinnter Conrai**.[120](javascript:footNote('G105007/note120.html'))


#### Do Genealach h-**Ui Ceallaig** and so


Domnall Mor, mac Taidg Thaillten, mic Concobair in Catha, mic Diarmada, mic Taidhg, mic Murchaid, mic Concobair, mic 


---

p.44




Taidg Catha Briain,[121](javascript:footNote('G105007/note121.html')) mic Murcaidh, mic Aedha, mic Ceallaig,[122](javascript:footNote('G105007/note122.html')) mic Findachta, mic Ailella, mic Innrechtaig, mic Dluthaig, mic Fhidchellaig, mic Dicholla, mic Eogain Finn, mic Cormaic, mic Cairpri Cruim, mic Fearadaig, mic Lugaid, mic Dallain, mic Bresail, mic Maine Moir.


Aed mac Diarmada, mic Taidg Chata Briain.


Tadg Dub, mac Aeda, mic Diarmada.


#### Clann Domnaill, mic Taidg Taillten and so


Sé meic Domnaill Moir, mic Taidg Taillten, .i. Concobar, ocus Tadg Find Muigi Ruscach, ocus Eogan, ocus Tomas Espuc,[123](javascript:footNote('G105007/note123.html')) ocus Lochlaind, ocus Diarmaid. Ingen Domnaill Moir h-I Bhriain, mathair an t-seisir sin, ocus derbshiur di mathair Fheidlimid, mic Cathail Croibdheirg, ocus derbsiur eli doib mathair Ricaird, mic Uilliam Find, o fhuil Clann Ricaird.


Clann Concobair, mic Domnaill Moir, .i. Domnall. Cuig meic la Domnall, .i. Gilliberd, ri **O Maini**, ocus Dauith, ocus Tadg Mor Catha **Atha na Righ**, ocus Concobar, ri **O Maine**, ocus Aed; ocus nir b'inann mathair leo, acht le dis, .i. Tadg, ocus Conchobar; Abis, ingen h-Ui Fhlaind, a mathair.


**Clann Gilliberd** in so, .i. Diarmaid, mac Gilliberd, ri **O Maine**, ocus Tomas Espuc,[124](javascript:footNote('G105007/note124.html')) ocus Domnall Tuathach, ocus Murchadh, ocus Cormac, ocus Brian, ocus Dáuíth, a sinnsear.




---

p.46


Clann Diarmada, mic Gilliberd, .i. Concobar Cerrbach, ocus Sean; én mathair leo, ocus Maine, ocus Tadhg; Mor, ingen Aeda h-I Concobair, mathair an Taidg sin. Concobar, mac Concobair, Cerrbaig. Tadg, mac Diarmada, mic Gilliberd, tri meic leis, .i. Uilliam, ocus Donchad, ocus Seaan.


Clann Tomais Espuic, mac Gilliberd, .i. Maeleachlainn, ocus Muircertach, ocus Tomas, ocus Diarmaid, ocus Murchad, ocus Tomaltach.


Clann Domnaill Tuathaig, mic Gilliberd, .i. Uilliam, ocus Ruaidhri, ocus Cairpri, ocus Brian, ocus Roberd, ocus Domnall. En mac la Murchad, mac Gilliberd, Dauith. Da mac la Cormac, mac Gilliberd, Murchad ocus Tomas. Clann Dauith, meic Gilliberd, Brian, ocus da Muircertach, ocus Eogan, ocus Aed, ocus Murchad. Aen mac la Donnchad, mac Gilliberd, Gilliberd.


Tadg Chatha **Atha na Rig**, mac Domnaill, tri meic lais, .i. Donnchad, ocus Tadg, ocus Concobar. Tri meic la Tadg, .i. Tadg Og, ocus Donnchad Ruadh, ocus Tadg Ruadh eile. Tri meic la Concobar, mac Taidg, .i. Ruaidri, ocus Eogan, ocus Aed.


Concobar, mac Domnaill, mic Concobair, mic Domnaill Moir, tri meic lais, .i. Domnall, ocus Maine, ocus Eogan. Muirchertach, ocus Uilliam Ballach, da mac Domnaill, mic Concobair. Tri meic ag Maine, mac Concobair, .i. Murchad, ocus Donnchad Ballach, ocus Maine. Aen mac Eogain, mic Concobair, .i. Brian mac Eogain. Aed, mhac Domnaill, mic Concobair, mic Domnaill Moir, da mac lais, .i. Pilip ocus Siacus. Clann Domnaill, mic Concobair, conuigi sin.


Donnchad Muimnech, mac Concobair, mic Domnaill, nai meic lais, .i. Muircertach, ocus Aed, ocus Maileachlainn, ocus Maine; Ingen Meic Uigilin,[125](javascript:footNote('G105007/note125.html')) a mathair. Mic aile do, Tadg ocus Concobar;


---

p.48




dibaid iad-sidi, ocus Emand, ocus Uilliam, ocus Domnall Muimnech. Dubesa, ingen Maileachlainn, mic Donnchaid, mic Domnaill, mic Magnusa, mic Toirrdealbaig Moir h-I Concobair, ri **Erenn**, mathair na mac sin. Aed, mac Donnchaid Muimnig, cuig meic leis, .i. Muircertaig, ocus Domnall Mor, ocus Mathgamain. Róis, ingen h-I Madagain, mathair na mac sin. Eogan, ocus Seaan, ocus Tomas, na meic sin ele.


Tri meic la Domnall Mor, mac Aeda, .i. Concobar, ocus Domnall Ab, ocus Donnchad Gall. Ceithri meic la Mathgamain, mac Aeda, .i. Maeleachlainn, ocus Aed, ocus Ruaidri, ocus Eogan. Maeleachlainn, mac Donnchaid Muimnig, se meic lais, .i. Diarmaid, mac ingine h-I Mailalaid, Brian, ocus Murchad, da mac ingine h-I Fhlandagan. Eochaid, ocus Ceallach, ocus Donnchad, tri meic ingine h-I Concobair. Eochaid, mac Mailechlainn, tri meic lais, .i. Maileachlainn, ocus Cairpri, ocus Diarmaid. Da mac la Cellach, .i. Brian ocus Donnchad. Da mac la Donnchad, mac Mailechlainn, .i. Seaan ocus Domnall.


#### **Clann Maine** inso


Maine, mac Donnchaid, tri meic lais, .i. Pilip, ocus Tadg, ocus Eogan. Clann mor la Pilip, .i. Maine, ocus Donnchad, ocus Muirchertach, .i. an t-Espuc,[126](javascript:footNote('G105007/note126.html')) ocus Diarmaid Cleirech, ocus Aed. Tri meic la h-Emann, mac Domnaill Muimnig, .i. Emann Og, ocus Uilliam, ocus Tadg; mac do Thadg Brian.


#### Clann Uilliam, Mic Donnchaid and so


Maeleachlainn,[127](javascript:footNote('G105007/note127.html')) mac Uilliam, ingen h-I Grada a mathair, ocus 


---

p.50




Uilliam Og, ocus Tadg, ocus Aed Buidi, clann Uilliam in sin. Maeleachlainn clann mor lais, .i. Ruaidri, ocus Brian, ocus Concobar.[128](javascript:footNote('G105007/note128.html')) Ingen Baiter a Burc mathair an trir sin. Aed,[129](javascript:footNote('G105007/note129.html')) ocus Feradach, ocus Tadg, ocus Donnchad, ocus Domnall, ocus Uilliam, ocus Emand. Finnguala, ingen Toirrdelbaig h-I Concobair, mathair na mac sin. En mac la Muircertach, mac Uilliam, mic Donnchaid Muimnig, .i. Domnall. As iad so clann Concobair, mic Domnaill Moir, .i. Domnall O'Cellaig, ocus Donnchad Muimnech, &ca, ocus Maine Mor, ocus Murchad, ocus Cathal, ocus Cairpri Brathair, ocus Muris, ocus Nicol. Ingen h-I Eighin mathair Domnaill ocus Murchaid; Ingen h-I Lochlainn mathair Donnchaid Muimnig ocus Maine; Ingen Mec Con Mara mathair Cathail, ocus Cairpri, ocus Muiris. Maine, mac Diarmada, mic Taidg, mic Maine Moir. Da mac la Maelechlainn, mac Cormaic, mic Murchaid, mic Concobair, mic Domnaill Moir, .i. Siacus, ocus Cormac, ocus Diarmaid an tres. Tri meic la Siacus, .i. Seaan, ocus Mailechlainn Cleirech, ocus Tadg. Cathal, mac Concobair, mic Domnaill Moir, tri meic lais, .i. Cairpri, dibaid, ocus Maeleachlainn, ocus Uilliam. Clann maith la Maelechlainn, .i. Concobar, ocus Cairpri, ocus Maine Cleirech. Ingen h-I Madagain mathair an trir sin. Mac aili do Aed. Cuig meic Uilliam, mic Cathail, mic Concobair, .i. Seaan, ocus Magnus, ocus Diarmaid, ocus Lochlainn, ocus Diarmaid, ocus Siacus. Ingen Meg Oirechtaig mathair na mac sin. Muircertach mac aili do. Maelechlainn, mac Concobair, mic Mailechlainn, mic Cathail. Clann Eogain, mic Domnaill Moir, .i. Mathgamain, ocus Donnchad Mor, ocus Brian, ocus Cairpri, ocus Domnall Cleirech. Do badur triuir mac ag


---

p.52




Mathgamain,[130](javascript:footNote('G105007/note130.html')) .i. Pilip, ocus Ruaidri, ocus Concobar. Ingen Me*ic* Cochlain mathair an trir sin. Da badar ceithri meic ag Pilip, .i. Cairpri, ocus Murchad, ocus Catal, ocus Maelechlainn. Mathgamain, mac Murchaid, mic Pilip, mic Mathgamna. Seacht meic ag Ruaidri, .i. Donnchad, ocus Domnall, ocus Mathgamain, ocus Tadg, ocus Concobar, ocus Brian, ocus Diarmaid. Mor, ingen Uilliam Leith a Búrc, mathair Donnchaid; Ingen h-I Concobair Failgi mathair Domnaill, ocus Ruaidri, mic Lochlaind, o fuiled Cland Lochlaind Ruaid. Maelruanaid, mac Ruaidri, an t-ochtmad mac. Domnall, mac Ruaidri, aen mac lais, .i. Tadg. Eogan, mac Ruaidri, mic Donnchaid. Uilliam, mac Donnchaid, mic Ruaidri. En mac la Maelruanaid, mac Ruaidri, .i. Seaan. Tri meic Briain, mic Ruaidri, .i. Maghnus ocus Muirchertach ocus Concobar. Cormac, mac Cairpri, mic Eogain, mac do Prioir **Cluana Tuaiscirt**.[131](javascript:footNote('G105007/note131.html'))


Clann Concobair mic Mathgamna mic Eogain: Ceitri meic aigi, .i. Eochaid, ocus Domnall, ocus Pilip, ocus Magnus. Mac do Pilip Concobar. Clann Donnchaid Moir, mic Eogain, .i. Concobar, ocus Eogan, ocus Maeleaclainn Dubh, ocus Aed. Donnchad, ocus Concobar Odur, da mac Conchobair, mic Donnchaid. Clann Donnchaid, mic Concobair, mic Donnchaid Moir, .i. Maine, ocus Murchad, ocus Muircertach Cleirech, ocus Domnall Glas. Clann Briain, mic Eogain, .i. Donncuan, ocus Brian, ocus Murchad. Da mac Duinnchuan, Aed ocus Tomas. Maine, mac Siacusa, mic Briain, mic Briain, mic Eogain. Ocus Domnall, mac Siacusa. Tadg, mac Murchaid, mic Eogain, tri meic lais, .i. Lochlainn, ocus Domnall, ocus Siacus. Seann ocus Cormac, da mac Cairpri, mic Eogain. Tri meic Domnaill Chleirig, mic Eogain, .i. Uilliam,


---

p.54




ocus Pilip Cas, ocus Eogan. Clann Uilliam, mic Domnaill Cleirigh, .i. Muircertach, ocus Dauith, ocus Diarmaid, ocus Concobar Cluasach. Clann Pilip Chais, .i. Tadg, ocus Aed, ocus Maelechlainn, ocus an Dall. Clann Taidg, mic Pilip, .i. Tomas, ocus Muircertach, ocus Donnchad,[132](javascript:footNote('G105007/note132.html')) ocus Diarmaid. Clann Maelechlainn, mic Philip Cais, .i. Maghnus, ocus Concobar Riabach, ocus Seaan Dub, ocus Domnall. Tadg Find Muigi Ruscach, mac Domnaill Moir, mic Taidg Taillten, da mac lais, .i. Cathal ocus Diarmaid. Tri meic la Cathal, .i. Tomaltach, ocus Aed, ocus Maelechlainn. Murchad, mac Maeileachlainn, mic Cathail, mic Taidg Finn. Da mac Diarmada, mic Thaidg Fhinn, .i. Art Ruad, ocus Tadg Direach. Da mac ag Art Ruad, .i. Tomaltach, ocus Magnus. Da mac ag Tadg Díreach, .i. Mathgamain ocus Donnchad. Diarmaid ocus Concobar, da mac Aeda, mic Catail, mic Taidg Finn.


Tadg, mac Maileachlainn, ocus Ruaidri, ocus Murchad, clann Maileachlainn, mic Cathail, mic Taidg Find.


Clann Lochlaind, mic Domnaill Moir, .i. Aed, ocus Magnus, ocus Simon Cleirech, ocus Tadg, ocus da Domnall, ocus Cairpri. Clann Lochlainn, mic Aeda, mic Lochlainn Moir, .i. Ruaidri, ocus Lochlainn Og, ocus Maine, ocus Tadg Dub, ocus Murchad Ruad. Tri meic Ruaidri, mic Lochlaind, .i. Donnchad, ocus Domnall, ocus Conchobar. Da mac Lochlaind Oig, .i. Donnchad, ocus Maeleachlainn. En mac la Donnchad, mac Aeda, mic Lochlaind, .i. Tadg. Domnall, mac Aeda, mic Lochlainn. Cairpri, mac Aeda, mic Lochlainn. Magnus, mac Lochlainn, mic Domnaill Moir, da mac lais, .i. Tadg ocus Domnall. En mac la Domnall, .i. Magnus. En mac la Tadg, .i. Conchobar. Clann Simoin, mic Lochlainn, mic Domnaill Moir, .i. Brian,


---

p.56




ocus Seaan, ocus Uilliam, ocus Cathal, ocus Diarmaid, ocus Tomaltach, ocus Tomas Ruad. Clann Diarmada, mic Domnaill Moir, mic Taidg Taillten, .i. Eochaid ocus Donnchad. Nicol, mac Tomais, mic Eochaid, mic Diarmada, mic Domnaill Moir. Clann Tomais, mic Domnaill Moir, .i. Siacus ocus Seaan. Tadg, imnorra, mac Siacusa, mic Tomais Espuc, mic Domnaill Moir.


#### Genealach h-**I Cheallaig** ann so

1. Tadg,
2. Mac Maeilechlainn,
3. Mic Uilliam,
4. Mic Donncaid Muimnig,
5. Mic Concobair,
6. Mic Domnaill,
7. Mic Taidg Taillten,
8. Mic Concobair an Catha,
9. Mic Diarmata,
10. Mic Concobair,
11. Mic Taidg Chatha Briain,
12. Mic Murchaid,
13. Mic Aeda,
14. Mic Ceallaig,
15. Mic Fhindachtaig,
16. Mic Ailella,
17. Mic Finnrachtaig,
18. Mic Fidcellaig,
19. Mic Dluthaig,
20. Mic Dicholla,
21. Mic Eogain Finn,
22. Mic Cormaic,
23. Mic Cairpri Cruim,
24. Mic Feradaig,
25. Mic Luigeach,
26. Mic Dallain,
27. Mic Bresail,
28. Mic Maine Moir,
29. Mic Echach Fir da Giall,
30. Mic Domnaill,
31. Mic Imchada,
32. Mic Colla da Crich,
33. Mic Echach Doimlen,
34. Mic Cairpri Lifechair,
35. Mic Cormaic Ulfhada,
36. Mic Airt Aeinfir,
37. Mic Cuind Ced-cathaigh.


#### Genealach h-**I Madagain**

1. Murchad,
2. Mac Eogain,
3. Mic Murchaid,
4. Mic Cathail,
5. Mic Madagain Moir,
6. Mic Diarmada,[133](javascript:footNote('G105007/note133.html'))
7. Mic Dunagaid,


---

p.58

10. Mic Gadra,[134](javascript:footNote('G105007/note134.html'))
11. Mic Dunagaid,[135](javascript:footNote('G105007/note135.html'))
12. Mic Cobthaig,[136](javascript:footNote('G105007/note136.html'))
13. Mic Mailiduin,[137](javascript:footNote('G105007/note137.html'))
14. Mic Donngaili,[138](javascript:footNote('G105007/note138.html'))
15. Mic Anmcada,[139](javascript:footNote('G105007/note139.html'))
16. Mic Eogain Buac,[140](javascript:footNote('G105007/note140.html'))
17. Mic Cormaic,[141](javascript:footNote('G105007/note141.html'))
18. Mic Cairpri,[142](javascript:footNote('G105007/note142.html'))
19. Mic Feradaig,[143](javascript:footNote('G105007/note143.html'))
20. Mic Luigeach
21. Mic Dallain,
22. Mic Bresail,
23. Mic Maine Moir,
24. Mic Eachach Fir da Giall,
25. Mic Domnaill,
26. Mic Imchada,
27. Mic Colla da Crich,
28. Mic Eachach Doimlen,
29. Mic Cairpri Lifechair,
30. Mic Cormaic,
31. Mic Airt,
32. Mic Cuind Ced-cathaig,
33. Mic Feidlimid Rechtmair,
34. Mic Tuathal Techtmair,
35. 
36. Mic Fiacha Findalaig,
37. Mic Feradaig Find Fechtnaig,
38. Mic Crimthaind Nia Nair,
39. Mic Lugaid Riab n-Derg.




---

p.62


Nosa **Ua Maine**
-----------------


Is iad so lucht cóimíicca[144](javascript:footNote('G105007/note144.html')) **Chlainni Ceallaig**:[145](javascript:footNote('G105007/note145.html')) h-**I Duibgind**,[146](javascript:footNote('G105007/note146.html')) ocus h-**I Geibendaig**,[147](javascript:footNote('G105007/note147.html')) ocus **Mé Cathail**,[148](javascript:footNote('G105007/note148.html')) ocus Meg Floind,[149](javascript:footNote('G105007/note149.html')) ocus Muinter Murchadan;[150](javascript:footNote('G105007/note150.html')) ocus **Cland Aedagáan**,[151](javascript:footNote('G105007/note151.html')) no cur druideadur re h-Ollamnacht an aird-righ.[152](javascript:footNote('G105007/note152.html'))


Trian cuigid[153](javascript:footNote('G105007/note153.html')) a n-duthaid co bráth do bunad. Ocus trian cacha taisceada talman, dá fhuigter[154](javascript:footNote('G105007/note154.html'))


---

p.64




a falach, no fudomain do na fianaib sin; ocus trian érca[155](javascript:footNote('G105007/note155.html')) cach éin fhir d'a muintir, da faicfigther d'aicmi in aird-rig.


Trian cach turchairthi da ticfad a cuanaib **Connacht**[156](javascript:footNote('G105007/note156.html')) do'n chlainn maicni sin.




---

p.66


Marasgalacht a shluaig ag na saer-clannaib o Charaid co Luimnech,[157](javascript:footNote('G105007/note157.html')) a Laignib, ocus a laech Mhumhain.


Sluaiged Erraig ocus Fodmair[158](javascript:footNote('G105007/note158.html')) d'anacal ar na h-aicmedaib sin, can comus a n-iarrata d'á n-aindeoin.


Ni fiada fear do'n chuiged[159](javascript:footNote('G105007/note159.html')) ar na fineadaib, acht mad Maineach eli d'á fhiadnugadh.


Mad faidi na caecais ar mís sluaiged **Connacht**,[160](javascript:footNote('G105007/note160.html')) comas teachta d'á tig ag na **Mainechaib**.


Gid mór líte do líter[161](javascript:footNote('G105007/note161.html')) do lucht gaidi orra, ni dlegaid acht aen fer, na ain-testa d'a shéna, no d'a suigiugadh.


Cach sochar[162](javascript:footNote('G105007/note162.html')) dá suidhighid leabair d'**Airgiallaib**, a leithéid d' **O'Cellaig** o **Chonnachta**.


Is iad so .vii. n-oirrigi[163](javascript:footNote('G105007/note163.html')) **O Máine**, .i. **O Conaill**,[164](javascript:footNote('G105007/note164.html')) ocus is inand dúchi do ocus do **MáCnáimhíin**[165](javascript:footNote('G105007/note165.html')) ocus d' **O Duburrla**;[166](javascript:footNote('G105007/note166.html')) orriga na n-**Anmchadach**,[167](javascript:footNote('G105007/note167.html'))


---

p.68




.i. **Muintir Madadan**:[168](javascript:footNote('G105007/note168.html')) Riga **Maenmaigi**,[169](javascript:footNote('G105007/note169.html')) .i. Muintir Nechtain,[170](javascript:footNote('G105007/note170.html')) ocus h-**I Mailalaid**.[171](javascript:footNote('G105007/note171.html')) Ocus ata tuarusdal o ri **Erenn**, gid ingnad, do rigaib **O Fiachrach Finn**[172](javascript:footNote('G105007/note172.html')) sech rigaib O Maine.




---

p.70


Na sé Sogain[173](javascript:footNote('G105007/note173.html')) co n-a trícha, ge bé aicmi acu d'á faemaid tigernus, as orrig re fead a thigernuis h-e, .i. **Cinel Rechta**, ocus **Cenel 


---

p.72




Trena**, ocus **Cenel Luchta**, ocus **Cenel Fergna**, ocus **Cenel n-Domangein**, ocus **Cenel n-Geigill**: trí h-orra ar **Sil Crimthainn Cháil**,[174](javascript:footNote('G105007/note174.html')) dá orrig d'á shíl féin, ocus orrig do **Shil Muireadaig**.[175](javascript:footNote('G105007/note175.html')) Is iad so an triur sin, .i. h-I Mailruanaid,[176](javascript:footNote('G105007/note176.html')) ocus h-I Muroin,[177](javascript:footNote('G105007/note177.html')) ocus h-I Chathail.[178](javascript:footNote('G105007/note178.html'))




---

p.74


Rig an **Chalaid**,[179](javascript:footNote('G105007/note179.html')) o'n Móin Inraidech[180](javascript:footNote('G105007/note180.html')) co **Cluain Tuaiscirt na Sinda**,[181](javascript:footNote('G105007/note181.html')) .i. mac Gilliduib;[182](javascript:footNote('G105007/note182.html')) h-Ua Laegachain, no Laegog,[183](javascript:footNote('G105007/note183.html')) flaith na find tricha sin.


Seacht flaithi **O Máine**,[184](javascript:footNote('G105007/note184.html')) .i. **Mac Eidigan**,[185](javascript:footNote('G105007/note185.html')) flaith **Clainni Diarmada**; ocus **Mac Gilli-Enan**,[186](javascript:footNote('G105007/note186.html')) flaith **Clainni Flaithemail**, *ocus*


---

p.76


**Muindtir Chinaith**,[187](javascript:footNote('G105007/note187.html')) ocus Flaith **Clainni Breasail** .i. **Muinnter Domnallan**,[188](javascript:footNote('G105007/note188.html')) ocus Flaith **Clainni Duibgind**,[189](javascript:footNote('G105007/note189.html')) .i. **O Duibgind**, ocus **Ó Gabrán**[190](javascript:footNote('G105007/note190.html')) ar **Dail n-Druithni**, ocus **Ó Docomlan**[191](javascript:footNote('G105007/note191.html')) ar **Rinn na h-Eignidi** ocus **Ó Donnchada** ar **Aib Cormaic Maenmuigi**;[192](javascript:footNote('G105007/note192.html')) O Mailbrigdi,[193](javascript:footNote('G105007/note193.html')) .i. flaith na **Bredcha**, an tuath as uaisli a n-**Ib Maine**.


Seacht prim-chomarbada[194](javascript:footNote('G105007/note194.html')) **O Maine**, .i. Comarba **Cluana Ferta**,[195](javascript:footNote('G105007/note195.html'))


---

p.78




ocus Comarba **Cilli Mian**,[196](javascript:footNote('G105007/note196.html')) ocus Comarba **Cilli Tulach**,[197](javascript:footNote('G105007/note197.html')) Comarba **Cilli Cumadan**,[198](javascript:footNote('G105007/note198.html')) ocus Comarba **Camcha Brigdi**,[199](javascript:footNote('G105007/note199.html')) mar a m-baister popal **O Maine** ocus Comarba **Cluana Tuaiscirt na Sinda**,[200](javascript:footNote('G105007/note200.html')) d'ár ab dual rigad **Sil Cellaig**,[201](javascript:footNote('G105007/note201.html')) ocus Comarba **Cluana Cain Cairill**.[202](javascript:footNote('G105007/note202.html'))


Baisded **Sil Maine** do Brigid,[203](javascript:footNote('G105007/note203.html')) ocus gen co beirter an baisded and, comus phingni baisdi da thabach ag a comarb o na h-aicmeadaib sin; ocus a roinn ar tri a muig: a trian di féin, ocus a trian do **Druim Drestan**,[204](javascript:footNote('G105007/note204.html')) ocus a trian do **Cluain Emain**.[205](javascript:footNote('G105007/note205.html'))




---

p.80


An **sgreaball ongtha**[206](javascript:footNote('G105007/note206.html')) o gach Maineach do **Cromthar Aed Anmchadach**.[207](javascript:footNote('G105007/note207.html'))


Adlucad **Sil Cairpri Cruim**[208](javascript:footNote('G105007/note208.html')) do **Chluain mic Nois**, ocus do **Chiaran**; A chain do **Chiaran**, 'na (no d'á) chenn sin. Seacht m-baili deg d'fhearand t-saer a n-**Ib Maine** aigi.[209](javascript:footNote('G105007/note209.html'))


**Sgreball caethrech**[210](javascript:footNote('G105007/note210.html')) uatha do Grellan, edir mnai ocus fir, o h-**Sil Maine**.


A ceannus catha ag Grellan, .i. an Bachall Greallain, no a h-innsamail, a m-brataig rig **O Maine**.[211](javascript:footNote('G105007/note211.html'))




---

p.82


Seacht m-bruit ó'n banrigain do **Cairig Deargan**[212](javascript:footNote('G105007/note212.html')) cacha bliadna, ocus pinginn o gach ingin Mainig, re cois cána Ciarain.


Cach cis do bo dual do na cineadaib si do thabairt do **Padraig**, asa beith o **Glun Padraig**[213](javascript:footNote('G105007/note213.html')) co **Glaisi Uair**,[214](javascript:footNote('G105007/note214.html')) ag **Cairill**, ocus asin sair co **Sinaind**[215](javascript:footNote('G105007/note215.html')) ag **Greallan** ocus ag **Padraig**.


**Dear-thuatha** **O Máine** re forgnam,[216](javascript:footNote('G105007/note216.html')) .i. **Dealbna**[217](javascript:footNote('G105007/note217.html')) o **Ath Liac** co **Succa**,[218](javascript:footNote('G105007/note218.html')) mar a m-bruchtann as a tobar ag **Sliabh Formaili**.[219](javascript:footNote('G105007/note219.html')) **Catraig Suca**, o **Thuaim Catraig**[220](javascript:footNote('G105007/note220.html')) uachtarach co **Portaib Fidigi**,[221](javascript:footNote('G105007/note221.html'))


---

p.84




da cac taib do'n t-**Suca**; ocus **Corco Moncho**,[222](javascript:footNote('G105007/note222.html')) ocus **Dal n-Druithni**,[223](javascript:footNote('G105007/note223.html')) ocus fir **Muigi Sein-chineol**,[224](javascript:footNote('G105007/note224.html')) no cor' shuigigid **saer-clanda**[225](javascript:footNote('G105007/note225.html')) ina n-inadaib d'a n-eisi; ocus **Muintir Milcon**;[226](javascript:footNote('G105007/note226.html')) ocus do fhedfaidís aird-riga **O Maine** meadugad císa ar na clann-maicnib sin; **Muintir I Mailfhinnain**[227](javascript:footNote('G105007/note227.html')) tré na n-deoraigecht; ocus ataid bailti[228](javascript:footNote('G105007/note228.html')) nár


---

p.86




airmimar d'**Feraib Bolc** is na crichaib sin re fognam do na flaithib, ocus fa lucht freasdail ocus fir duchais do rigaib **O Maine**. **Cadanaig** na **Fead**[229](javascript:footNote('G105007/note229.html')) co n-a fineadaib, ocus iarsma **Fear m-Bolg** aes fedma duchusa **O Maine**.


An marasgalacht sluaig[230](javascript:footNote('G105007/note230.html')) d'**O Conaill**[231](javascript:footNote('G105007/note231.html')) ocus do **Mac Eidigain**.[232](javascript:footNote('G105007/note232.html')) An taisigecht scuir[233](javascript:footNote('G105007/note233.html')) ag h-**Ib Fiacrach Find**, ocus ag **Sil Sogain**.[234](javascript:footNote('G105007/note234.html'))


Cuid h-**I Cheallaig** do dóirrseoracht rig **Connacht** d'**Ib Fiachrach Find**.[235](javascript:footNote('G105007/note235.html'))


Taisigecht allaid[236](javascript:footNote('G105007/note236.html')) h-**I Conchobair** a h-ucht h-**I Chellaig** ag **Dail n-Druithni**.[237](javascript:footNote('G105007/note237.html'))


Roind an aird-rig can uireasbaid ag **Ua Urain**[238](javascript:footNote('G105007/note238.html')) **Cluana Ruis**.[239](javascript:footNote('G105007/note239.html'))




---

p.88


A thaisigecht com-óil ag **Ib Lomain**.[240](javascript:footNote('G105007/note240.html'))


An **cul-choimed**[241](javascript:footNote('G105007/note241.html')) ag **Clann Indrechtaig**[242](javascript:footNote('G105007/note242.html')) ocus ag **Sil m-Brain** ocus **Aililla**[243](javascript:footNote('G105007/note243.html')) co n-a n-aicmedaib.


An taisigeacht eallaig[244](javascript:footNote('G105007/note244.html')) co n-a cornaib ocus co n-a fithchellaib, ocus co n-a failgib, co n-a h-ór ocus co n-a h-airged ag **Clannaib Flaitheamhla**.[245](javascript:footNote('G105007/note245.html'))


Na h-airm ocus na h-eidig ag **Clannaib Bresail**,[246](javascript:footNote('G105007/note246.html')) ocus is leo comrag coitchend do fhregra tar cend O'Maine, re cach coiccrich coimigthig.


Tigernus cacha droingi bias ag digail easonorach h-**Ua Maine** do **Sil Crimthain Cail**, .i. do Crumthann, ocus do **Clann Aedagan**;[247](javascript:footNote('G105007/note247.html')) ocus as leo comus na cath do corugud, ocus dul a n-inad aird-rig is animreasain. Is a timcheall **Shogain** thimsaigid cach uili co h-imreasain, uair is iad as corp lathair catha do chach.


Re h-**Aes m-Brengair**[248](javascript:footNote('G105007/note248.html')) rachtus[249](javascript:footNote('G105007/note249.html')) an aird-rig, ocus le h-**Aib Draignen**[250](javascript:footNote('G105007/note250.html')) **Aird na Cno**[251](javascript:footNote('G105007/note251.html')) coir na **Clann-Maicne**.




---

p.90


Na conarta ag **Crumthann**. Cuid h-**Ui Ceallaig** do conartaib h-**Ui Conchobair** ag **Ib Teimnein** **Muilind Glaisni**.[252](javascript:footNote('G105007/note252.html')) A iarann for **Aib Tuathaig**[253](javascript:footNote('G105007/note253.html')) **Eachdroma**,[254](javascript:footNote('G105007/note254.html')) ocus for **Aib Baedain** **Badna**.[255](javascript:footNote('G105007/note255.html'))


Doirrseoracht an aird-rig ag **Clannaib Indrechtaig** ocus is le h-**Aib Brain** a bunadus.


A rigad ocus a aith-rigad a h-ucht h-**Ua Maine** ag **Clannaib Diarmada**, ocus ag **Ib Cormaic** **Maenmuigi**, ocus ag **Muintir Mithigen**[256](javascript:footNote('G105007/note256.html')) .i. ocus comarbad **Chluana Tuaiscirt**.


A thaisigecht scuir ag **Sogan**. Le **Cenel Aeda**[257](javascript:footNote('G105007/note257.html')) oilemain a each. Le deiscert **Echtgi**[258](javascript:footNote('G105007/note258.html')) oilemain a chon. Le **Dail n-Druithne** imarchur a fhina o chaladaib an iarthair co h-isdagaib an aird-rig. Le h-**Aib Docomlain**[259](javascript:footNote('G105007/note259.html')) denam a forgneama, iter tigib ocus taeb-chomach, a tri h-isdagaib uachtaracha an aird-rig. Le **Bolg-Thuathaib** **Bagna** denam a isdad is na portaib ichtaracha. Le trichaid ced an **Chalaid** a maeraigecht, edir chis ocus tabach.


A uagra catha ar **Crumthann**. A coindobrain, ocus a iascairecht


---

p.92




do'n taib thuaid do **Fhid Mónach**.[260](javascript:footNote('G105007/note260.html')) Biathad a graidi ocus a comed ar **Bolg-Thuath** **Echthgi**. Gach uili opair rigus a leas ocus tidlaicfis beos a gabail o **Cathraigi**,[261](javascript:footNote('G105007/note261.html')) acht na curter as a tigernus iad.


A cro catha, ocus tairisi a taisceda ocus coimead a giall is in **Bretaig**.[262](javascript:footNote('G105007/note262.html'))


A cruitiredha, .i. h-**Ui Longargain**[263](javascript:footNote('G105007/note263.html')) o **Baile na Banabai**,[264](javascript:footNote('G105007/note264.html')) ocus a chornaireada o **Lis na Cornairega**,[265](javascript:footNote('G105007/note265.html')) .i. h-**Ui Sídhachain**.[266](javascript:footNote('G105007/note266.html'))


A chongmhail 'na inad rig, ocus a chomairci for ri **Caisil**, uair is i slánaighecht rig **Caisil** congbus ri h-**Ua Maine** ó **Shil Muireadaig**.[267](javascript:footNote('G105007/note267.html')) Conad airi sin is **geis** do ri h-**Ua Maine** fogra catha ar **Eoganacht**.[268](javascript:footNote('G105007/note268.html'))


Tuarustal rig **Connacht** re comháiremh do ri h-**Ua Maine** (uair is beg theid d'á chís ar chomhadhaibh), amhail adh rubhradh ann so:


> 1. Dligid ri h-**Ua Maine**, an mal,
>   
> Dech n-eich tar saebh srothaib sál,
>   
> Dech n-goili re gnimh fergi ag fuin,
>   
> Dech meirgi ocus .x. matail. Finit.
> 






---

p.25


Account of Hy-Many
------------------

Genealogy of the Hy-Many here,
------------------------------


Maine Mor, son of Eochaidh, Ferdaghiall, son of Domhnall, son of Imchadh, son of Colla da Crich, had one son, namely, Bresal. Bresal had five sons, namely, Fiachra Finn, Dallan, Conall, Creamthann, and Maine Mall, a quo h-Ui Maine Brengair. Dallan, son of Bresal, had three sons viz., Duach, Lughaidh, and Loman. Lughaidh had five sons, viz., two Eoghans, Cremthann Gael, Fearadhach, and Finnal Fathach, ut dixit poeta:


> 1. Eoghan, Eoghan, Crimthann Cael,
>   
> Noble was the race of brothers,
>   
> Five sons of Lughaidh, the resolute,
>   
> Feradhach, Finnall Fathach.
> 




Fearaghach had three sons, viz., Cairpri Crom, Cairpri Mac Feithine,


---

p.27




and Nadsluaigh a quo O'Finain. Cairpri Mac Feithine had four sons, viz., Brenainn Dall, Aedh Abla, Aedh Guairi, and Loithin. Brenainn Dall had eight sons, viz., Colman, Coman, Maelbracha, or Cronan, Garbhan, Toman, Amlaibh *Amalgaidh*, Maine and Flann.


#### The Clann Comain


Conall, son of Cormac, son of Ceithernach, son of Fogartach, son of Fearadhach, son of Eachtghal, son of Sechnasach, son of Congal, son of Eoghan, son of Coman, son of Brenainn Dall, son of Cairpri Fechine, son of Fearadhach, son of Lughaidh, son of Dallan, son of Bresal, son of Maine Mor.


#### The Clann Cremthainn


Murchatan, son of Sochlachan, son of Diarmait, son of Fergus, son of Murchadh, son of Dubh-da-Thuath, son of Daimin, son of Darnhdairi, son of Ailell, son of Coirbin, son of Aedh, son of Crimthann Cael, son of Lughaidh, son of Dallan, son of Breasal, son of Maine Mor.


#### Now Ua Nadsluaigh, i. e. O'Finain


Ailell, son of Finan, son of Cellach, son of Nadsluaigh, son of Fearadhach, son of Lughaidh, son of Dallan, son of Bresal, son of Maine Mor.


#### The Clann Cairpri Cruim


Cairpri Crom had one son, namely, Cormac. Cormac had two sons, viz., Eoghan Finn and Eoghan Buac. From Eoghan Finn, the


---

p.29




Northern Ui Maine are descended, and from Eoghan Buac, the Southern Ui Maine.


Eoghan Finn had four sons, namely, Dicholla, Fithchellach, Maelanfaidh, Scannlan, and Scannall. From this Maelanfaidh O'Duibhginn is descended.


#### The Clann Cernaigh here


Connagan, son of Cernach, son of Ailell, son of Cernach, son of Coscrach, son of Fidhchellach, son of Dicholla, son of Eoghan Finn.


Cosgrach, son of Cernach, son of Ailell, had fourteen sons, who all died without issue except four, viz., Flaithemh, Cernach, Daithgeal, and Duibhinnracht. Dubhcailli, son of *Lachtnan*, son of Innrachtach, son of Flaithemh, son of Cosgrach, son of Cernach.


Loingsech, son of the son of Cormac, son of Ciardearg, son of Fidhgal, son of Flaithemh, son of Cosgrach.


These are the common surnames of the race of Cernach, viz., O'Finain, O'Laidhin, O'Lachtnain, O'Conbhuidhi, O'Ullscaidh,


---

p.31




O'Ceinneididh, O'Dorchaidhi, O'Sidhachain, O'Furadhain, O'Cuilein, O'Crabhadhain.


#### The Clann Aedhagain


Maelisa, the Red, son of Saerbrethach, son of Flann, son of Gilla Suasanaigh, son of Saerbrethach, son of Muirchertach, son of Flann, son of Aedhagan, son of Goistin, son of Flaithemh, son of Flaithghil, son of Cosgrach, son of Fidhchellach.


Innrachtach, son of Dluthach, son of Oilell, son of Innrechtach, son of Dluthach, son of Fithchellach, son of Dicholla, son of Eoghan Finn, son of Cormac, son of Cairpri Crom.


Duibhginn, son of Feargal, son of Ailell, son of Conall, son of Ailell, son of Innrachtach.


Ceallach, son of Finnachta, son of Ailell, son of Innrachtach.


#### The Clann Flaitheamhail Mic Dluthaigh


Maelbrighdi, son of Innrachtach, son of Flaithnia, son of Flaitheamhail, son of Dluthach.


#### Ua Domhnaill


Domhnall, son of Donnchadh, son of Muirchertach, son of Flaithnia, son of Dluthach, son of Fidhcheallach, son of Dicholla.




---

p.33


#### The Clann Bresail, a quo the O'Domhnallains


Domhnallan, son of Maelbrighdi, son of Grenan, son of Loingsech, son of Domhnallan, son of Bresal, son of Dluthach, son of Fithchellach, son of Dicholla, son of Eoghan Finn.


#### The Clann Fiachra Finn here


Fiachra Finn had four sons, viz., Amlaibh, Cairpri, Eochaidh, Seisgnia.


#### The Clann Amlaibh


Nechtaina, son of Maelcheir, son of Aengus, son of Tuathal, son of Maclaeich, son of Connalach, son of Amhalgaidh, son of Deinmnedhach, son of Dima, son of Laidginn, son of Maeluidhir, son of Aedh, son of Finntan, son of Amhlaibh, son of Fiachra Finn, son of Bresal, son of Maine Mor.


#### Genealogy of the O'Maeilalaidhs


Amlaibh, son of Gilla Christ, son of Domhnall, son of Ceinneididh, son of Domhnall, son of Maelfhalaidh, a quo O'Maelfhalaidh, son of Cucichi, son of Maeltuili, son of Maclaeich, son of Connalach.


Catt, son of Seisgnia, son of Fiachra Finn, when he slew Ailell, son of Fiachra Finn, went to Aedan Bruinni Luim, son of Fergus, son of Eoghan, son of Niall of the Nine Hostages: he was called Aedan Bruinni Luim, because his breast was bare from the edges of swords and arms; and Catt married Eadan, the


---

p.35




daughter of Aedan, and she brought forth a son for him, viz., Ruadan Mac Caitt, from whom the Muinter Ruadhain are descended; and they remained in the vicinity of their grandfather, i. e. of Aedan, the son of Fergus, at a place called Cuil Aneirig.


#### Now the Sil Maelanfaidh.—Pedigree of O'Lomain


Ruaidhri, son of Coinnligan, son of Draighnen, son of Eochaidh, son of Connmach, son of Forbasach, son of Coidbeanach, son of Rechtagan, son of Odhran, son of Maelenaidh, son of Eochaidh, son of Ainmire, son of Aengus Loman, son of Dallan, son of Bresal, son of Maine Mor, a quo h-Ui Maine.


Aengus Loman, the son of Dallan, had five sons, viz., two Eoch-aidhs, Ainmire, Carrthach, and Fathach; ut poeta dixit:
 

> 1. Eochaidh, Eochaidh, Ainmire,
>   
> Carrthach, the beautiful, fair branch,
>   
> A race of brothers I have enumerated
>   
> *And* Fathach Finn were the sons of Aengus.
> 




#### The Cinel Critain here


Flannagan, son of Meisgell, son of Bruagar, son of Finnachta, son of Cuclochair, son of Faelchu, son of Critan, son of Ainmire, son of Aengus Loman.


#### The Cinel Fathaidh here


Cormac, son of Maenach, son of Ailibar, son of Colum, son of Rechtamhail, son of Colman, son of Flann, son of Aengus, son of Uradhran, son of Fathadh, son of Aengus Loman.




---

p.37


#### Pedigree of O'Lomain of Finnabhair here


Flann, son of Cinaeth, son of Donnghal, son of Eochaidh, son of Airmedhach, son of Congalach, son of Inndelbhaidh, son of Daithnennaigh, son of Crundan, son of Fergna, son of Aedh Senach, son of Eochaidh, son of Ainmire, son of Aengus Loman.


#### Pedigree of Hy-Cormaic oOf Maenmagh


Niall, son of Cerbhall, son of Maelcobha, son of Rudgus, son of Follachtach, son of Cucaissil, son of Fachtna, son of Lachtnan, son of Finntan Uallach, son of Siath, son of Cormac, son of Crimthann, son of Bresal, son of Maine Mor.


#### Pedigree of Hy-Duach


Duach, son of Dallan, son of Bresal, son of Maine Mor.




---

p.39


#### Pedigree of Cinel Aedha


Cubaga, son of Cellach, son of Dungal, son of Congal, son of Cugusa, son of Ronan, son of Maelumha, son of Crimthann, son of Bresal, &c.


#### Pedigree of the Sil Anmchadha


Anmchadh, son of Eoghan Buacc, son of Cormac, son of Cairpri Crom, had three sons, viz., Donngalach, Fiangalach, and Forbasach. Maelduin, son of Donngalach, had two sons, viz., Cobhthach and Innrachtach. Gadhra, son of Dunadhach, son of Loingsech, son of Dunadhach, son of Cobhthach, son of Maelduin, son of Donngalach, son of Amnchadha.


Maelcothaigh, son of Donngalach, son of Anmchadh. Dunadhach, the son of Cobhthach, had two sons, viz., Loingsech and Draighnen, a quo h-Ua Draighnen, viz., Ceannfaeladh, son of Finn, son of Tresach, son of Draighnen, son of Dunadhach. Loingsech had five sons, viz., Gadhra, Gledra, Cinaeth, Curran, a quo h-Ua Churrain, and Flannchadh, a quo h-Ua Flannchadha. Echtighern was son of Gadhra, son of Loingsech. Ua Cinaeith descends from Cinaeth, son of Loingsech; O'Gledra from Gledra, son of Loingsech. From Donngalach, son of Anmchadh are descended Muintir Chobhthaigh


---

p.41




and the h-Ui Donngalaigh. From Fiangalach, son of Anmchadh, are sprung Muinter Chonnagain, the Mac Cadhusaighs, the h-Ui Ainchine Mic Ceallaigh, h-Ua Bimnein Mic Muireadhaigh, h-Ua Tolairg Mic Neill, h-Ua Aithusa Mic Neill, h-Ua Brenainn, Muinter Chicharain, Muinter Rodaighi, Muinter Conghalaigh, and h-Ua Daigin.


Uallachan, son of Flann, son of Flannchadh, son of Innrachtach, son of Maelduin, son of Donngal, son of Anmchadh, son of Eoghan Buac. From this Uallachan are sprung the Mac Uallachans, i. e. the old chieftains of Sil Anmchadha, From Lorcan, son of Muron, son of Flann, son of Innrachtach, is descended Ua Dubhlaich. From Forbasach, son of Anmchadha, are descended Muinter Lorcain, the


---

p.43




Mac Cellaighs, Ua Finnachtaigh, Ua Coscraidh, Ua Maenaigh, Ua Connachtain, Ua Canain, and Ua Maelduibh.


#### The Muinnter Chobhthaigh here, from whom are Ua Gadhra, i. e. Muinter Madadhain,


And Muinter Chinaith, and Muinter Tresaigh, and Muinter Laeghaire Mic Dunadhaigh, Ua Flannchadha, Ua Gledraigh, Ua Currain, Ua Aedha, Ua Cairten, and Ua Cuagain.


Of the race of Innrachtach, son of Maelduin, are Muinter Ruairc, the Mac Brains, the Mac Muroins, &c. Muinter Mailchada, of whom are Muinter Dubhlainn, Ua Flannchadha, &c., also Muinter Mailcroin, Mic Dungail, Muinter Arrachtain, Muinter Duibhgilla, and Muinter Conrui.


#### The Pedigree of O'Ceallaigh here


Domhnall Mor, son of Tadhg Taillten, son of Conchobhar of the Battle, son of Diarmaid, son of Tadhg, son of Murchadh, son of Conchobhar,


---

p.45




son of Tadhg of the Battle of Brian, son of Murchadh, son of Aedh, son of Ceallach, son of Finnachta, son of Ailell, son of Innrechtach, son of Dluthach, son of Fidhcheallach, son of Dicholla, son of Eoghan Finn, son of Cormac, son of Cairpri Crom, son of Feradhach, son of Lughaidh, son of Dallan, son of Bresail, son of Maine Mor.


Aedh, son of Diarmaid, son of Tadhg of the Battle of Brian.


Tadhg Dubh, son of Aedh, son of Diarmaid.


#### The Race of Domhnall, Son of Tadhg Taillten, here


Domhnall Mor, the son of Tadhg Taillten, had six sons, viz., Conchobhar, Tadhg Finn of Magh Ruscach, Eoghan, Thomas the Bishop, Lochlainn, and Diarmaid. The daughter of Domhnall Mor O'Brien was the mother of these six sons, and her sister was the mother of Feidhlimidh, the son of Cathal Croibhdherg *Charles the Redhanded* O'Conor, and another sister of theirs was the mother of Rickard, son of William Finn, from whom are the Clann-Rickard.


Conchobhar, the son of Domhnall Mor, had a son Domhnall. Domhnall had five sons, viz., Gilbert, King of Hy-Many, David, Tadhg Mor of the Battle of Ath na Righ *Athenry*, and Conchobhar, King of Hy-Many*,* and Aedh. Only two of them were by the same mother, viz., Tadhg and Conchobhar, and their mother was Abis, the daughter of O'Flainn *O'Flynn*.
The issue of Gilbert were, Diarmaid Mac Gilbert, King of Hy-Many, Thomas the Bishop, Domhnall Tuathach, Murchadh, Cormac, Brian, and David, who was the sinnsear *i. e. the eldest son*.




---

p.47


The sons of Diarmaid Mac Gilbert were Conchobhar Cerrbhach, and John, who had the same mother; Maine, and Tadhg. Mor, the daughter of Aedh O'Conor, was the mother of this Tadhg. Conchobhar Cerrbhach had a son Conchobhar. Tadhg, the son of Diarmaid, son of Gilbert, had three sons, viz., William, Donnchadh, and John.


The sons of Thomas the Bishop, the son of Gilbert, were Maeileachlainn, Muirchertach, Thomas, Diarmaid, Murchadh, and Tomaltach.


The sons of Domhnall Tuathach, the son of Gilbert, were William, Ruaidhri, Cairpri, Brian, Robert, and Domhnall. Murchadh, son of Gilbert, had one son, David. Cormac, son of Gilbert, had two sons, viz., Murchadh and Thomas. David, son of Gilbert, had issue Brian, two Muirchertachs, Eoghan, Aedh, and Murchadh. Donnchadh, son of Gilbert, had one son, namely, Gilbert.


Tadhg of the Battle of Ath na Righ, the son of Domhnall, had three sons, viz., Donnchadh, Tadhg, and Conchobhar. Tadhg, had three sons, viz., Tadhg Og, Donnchadh Euadh, and a second Tadhg, *surnamed* Ruadh. Conchobhar, son of Tadhg, had three sons, viz., Ruaidhri, Eoghan, and Aedh.


Conchobhar, son of Domhnall, son of Conchobhar, son of Domhnall Mor, had three sons, viz., Domhnall, Maine, and Eoghan*.* Domhnall, son of Conchobhar, had two sons, viz., Muirchertach and William Ballach. Maine, son of Conchobhar, had three sons, viz., Murchadh, Donnchadh Ballach, and Maine. Eoghan, son of Conchobhar, had one son, Brian Mac Eoghain. Aedh, son of Domhnall, son of Conchobhar, son of Domhnall Mor, had two sons, viz., Philip and Siacus. So far the descendants of Domhnall, son of Conchobar.


Donnchadh Muimhnech, son of Conchobhar, son of Domhnall, had nine sons, viz., Muirchertach, Aedh, Mailechlainn, and Maine; their mother was the daughter of Mac Uighilin; his other sons were


---

p.49




Tadhg and Conchobhar, who died without issue, Edmond, William and Domhnall Muimhnech. Duibhesa, the daughter of Maileachlainn, son of Donnchadh, son of Domhnall, son of Maghnus, son of Toirdhelbhach Mor O'Conchobhair, king of Ireland, was the mother of these sons. Aedh, son of Donnchadh Muimhnech, had five sons, viz., Muirchertach, Domhnall Mor, and Mathghamhain; Rose, the daughter of O'Madaghain, was the mother of these sons; Eoghan, John, and Thomas were the other sons.


Domhnall Mor, son of Aedh, had three sons, viz., Conchobhar, Domhnall, the Abbot, and Donnchadh Gall. Mathghamhain, the son of Aedh, had four sons, viz., Maeleachlainn, Aedh, Ruaidhri, and Eoghan. Maeleachlainn, son of Donnchadh Muimhnech, had six sons, viz., Diarmaid, the son of O'Mailalaidh's daughter, Brian, and Murchadh, the two sons of the daughter of O'Flannagain, Eochaidh, Cellach, and Donnchadh, the three sons of the daughter of O'Conchobhair, Eochaidh, son of Maileachlainn, had three sons, viz., Maileachlainn, Cairpri, and Diarmaid. Cellach had two sons, viz., Brian and Donnchadh. Donnchadh, son of Maileachlainn, had two sons, viz., John and Domhnall.


#### The Descendants of Maine here


Maine, son of Donnchadh, had three sons, viz., Philip, Tadhg, and Eoghan. Philip had many sons, viz., Maine, Donnchadh, Muirchertach the Bishop, Diarmaid Cleirech, and Aedh. Edmond, son of Domhnall Muimhnech, had three sons, viz., Edmond Og, William, and Tadhg. Tadhg had a son Brian.


#### The Descendants of William, Son of Donnchadh, here


Maeleachlainn, the son of William (his mother was the daughter


---

p.51




of O'Grady), William Og, Tadhg, and Aedh Buidhe, were the sons of William. Maeleachlainn had many sons, viz., Ruaidhri, Brian, Conchobhar (the daughter of Walter Burke was the mother of these three), Aedh, Feradhach, Tadhg, Donnchadh, Domhnall, William, and Edmond. Finnguala, daughter of Toirrdelbhach O'Conchobhair, was the mother of these sons. Muirchertach, son of William, son of Donnchadh Muimhnech, had one son, namely, Domhnall. These were the sons of Conchobhar, the son of Domhnall Mor, viz., Domhnall O'Ceallaigh, Donnchadh Muimhnech, &c. Maine Mor, Murchadh, Cathal, Cairpri the Friar, Mauris, and Nichol. The daughter of O'Heighin *O'Heyne* was the mother of Domhnall and Murchadh; the daughter of O'Lochlainn was the mother of Donnchadh Muimhnech and Maine; and the daughter of Mac Conmara *Mac Namara* was the mother of Cathal, Cairpri, and Maurice. Maine was the son of Diarmaid, son of Tadhg, son of Maine Mor. Maeleachlainn, son of Cormac, son of Murchadh, son of Conchobhar, son of Domhnall Mor, had two sons, viz., Siacus and Cormac, and a third son Diarmaid. Siacus had three sons, viz., John, Mailechlainn the Cleric, and Tadhg. Cathal, son of Conchobhar, son of Domhnall Mor, had three sons, viz., Cairpri, who died without issue, Maeleachlainn and William. Maeleachlainn had good sons, viz., Conchobhar, Cairpri, and Maine the Cleric; the daughter of O'Madaghain was the mother of these three; he had another son Aedh. William, son of Cathal, son of Conchobhar, had five sons, viz., John, Magnus, Diarmaid, Lochlainn, Diarmaid, and Siacus; the daughter of Mac Oirechtaigh *Geraghty* was the mother of these sons. Muirchertach was another son of his. Maeleachlainn was the son of Conchobhar, son of Maeleachlainn, son of Cathal. The sons of Eoghan, son of Domhnall, were Mathgamhain, Donnchadh Mor, Brian, Cairpri, and Domhnall the Cleric. Mathghamhain had three sons, viz., Philip, Ruaidhri, Conchobhar. The daughter of Mac Cochlain was the mother of these


---

p.53




three. Philip had four sons, viz., Cairpri, Murchadh, Cathal, and Maeleachlainn. Mathghamhain, son of Murchadh, son of Philip, son of Mathghamhain. Ruaidhri had seven sons, viz., Donnchadh, Domhnall, Mathghamhain, Tadhg, Conchobhar, Brian, and Diarmaid. Mor, the daughter of William Liath Burke, was the mother of Donnchadh. The daughter of O'Conchobhair Failghi was the mother of Domhnall and of Ruaidhri, the son of Lochlainn, from whom the Clann Lochlainn Ruaidh are descended. Maelruanaidh Mac Ruaidhri was the eighth son. Domhnall, the son of Ruaidhri, had one son, namely, Tadhg. Eoghan was son of Ruaidhri, son of Donnchadh. William, the son of Donnchadh, son of Ruaidhri. Maelruanaidh, son of Ruaidhri, had one son, namely, John. Brian, son of Ruaidhri, had three sons, viz., Maghnus, Muirchertach, and Conchobhar. Cormac, son of Cairpri, son of Eoghan, had a son who was prior of Cluain Tuaiscirt. The sons of Conchobhar, son of Mathghamhain, son of Eoghan. He had four sons, viz., Eochaidh, Domhnall, Philip, and Maghnus. Philip had a son Conchobhar. The sons of Donnchadh Mor, son of Eoghan, were Conchobhar, Eoghan, Maeleachlainn Dubh, and Aedh. Donnchadh and Conchobhar Odhur were the sons of Conchobhar, son of Donnchadh. The sons of Donnchadh, the son of Conchobhar, son of Donnchadh Mor, were Maine, Murchadh, Muirchertach the Cleric, and Domhnall Glas. The sons of Brian, son of Eoghan, were Donncuan, Brian, and Murchadh. Donncuan had two sons, namely, Aedh and Thomas. Maine was son of Siacus, son of Brian, son of Brian, son of Eoghan. Domhnall, son of Siacus. Tadhg, son of Murchadh, son of Eoghan, had three sons, viz., Lochlainn, Domhnall, and Siacus. John and Cormac were the two sons of Cairpri, son of Eoghan.


---

p.55




Domhnall the Cleric, son of Eoghan, had three sons, viz., William, Philip Cas, and Eoghan. The sons of William, son of Domhnall the Cleric, were Muirchertach, David, Diarmaid, and Conchobhar Cluasach. The sons of Philip Cas were Tadhg, Aedh, Maeleachlainn, and the Blind Man. The sons of Tadhg, son of Philip, were Thomas, Muirchertach, Donnchadh, and Diarmaid. The sons of Maeleachlainn, son of Philip Cas, were Maghnus, Conchobhar Riabhach, John Dubh, and Domhnall. Tadhg Finn, of Magh Ruscach, son of Domhnall Mor, son of Tadhg Taillten, had two sons, namely, Cathal and Diarmaid. Cathal had three sons, viz., Tomaltach, Aedh, and Maeleachlainn. Murchadh was son of Maeleachlainn, son of Cathal, son of Tadhg Finn. Diarmaid, son of Tadhg Finn, had two sons, viz., Art Ruadh and Tadhg Direch. Art Ruadh had two sons, viz., Tomaltach and Maghnus. Tadhg Direch had two sons, viz., Mathghamhain and Donnchadh. Diarmaid and Conchobhar were the two sons of Aedh, son of Cathal, son of Tadhg Finn.


Tadhg Mac Maileachlainn, Ruaidhri, and Murchadh were the sons of Maeleachlainn, son of Cathal, son of Tadhg Finn.


The sons of Lochlainn, son of Domhnall Mor, were Aedh Maghnus, Simon the Cleric, Tadhg, two Domhnalls, and Cairpri. The sons of Lochlainn, son of Aedh, son of Lochlainn Mor, were Ruaidhri, Lochlainn Og, Maine, Tadhg Dubh, and Murchadh Ruadh. Ruaidhri, son of Lochlainn, had three sons, viz., Donnchadh, Domhnall, and Conchobhar. Lochlainn Og had two sons, viz., Donnchadh and Maeleachlainn. Donnchadh, son of Aedh, son of Lochlainn, had one son, namely, Tadhg. Domhnall was son of Aedh, son of Lochlainn. Cairpri was son of Aedh, son of Lochlainn. Maghnus, son of Lochlainn, son of Domhnall Mor, had two sons, viz., Tadhg and Domhnall. Domhnall had one son, namely, Maghnus. Tadhg had one son, namely, Conchobhar. The sons of Simon, son of Lochlainn, son of Domhnall Mor, were Brian, John, William, Cathal, Diarmaid, Tomaltach,


---

p.57




and Thomas Ruadh. The sons of Diarmaid, son of Domhnall Mor, son of Tadhg Taillten, were Eochaidh and Donnchadh. Nichol was son of Thomas, son of Eochaidh, son of Diarmaid, son of Domhnall Mor. The sons of Thomas, son of Domhnall Mor, were Siacus and John. Tadhg was the son of Siacus, son of Thomas, the Bishop, son of Domhnall Mor.


#### Pedigree of O Ceallaigh here

1. Tadhg,
2. Son of Maeleachlainn,
3. Son of William,
4. Son of Donnchadh Muimhnech,
5. Son of Conchobhar,
6. Son of Domhnall,
7. Son of Tadhg Taillten,
8. Son of Conchobhar of the Battle,
9. Son of Diarmaid,
10. Son of Conchobhar,
11. Son of Tadhg of the Battle of Brian,
12. Son of Murchadh,
13. Son of Aedh,
14. Son of Ceallach,
15. Son of Finnachtach,
16. Son of Ailell,
17. Son of Finnrachtach,
18. Son of Fidhchellach,
19. Son of Dluthach,
20. Son of Dicholla,
21. Son of Eoghan Finn,
22. Son of Cormac,
23. Son of Cairpri Crom,
24. Son of Feradhach,
25. Son of Lughaidh,
26. Son of Dallan,
27. Son of Bresal,
28. Son of Maine Mor,
29. Son of Eochaidh Ferdaghiall,
30. Son of Domhnall,
31. Son of Imchadh,
32. Son of Colla da Crich,
33. Son of Eochaidh Doimhlen,
34. Son of Cairpri Lifechair,
35. Son of Cormac Ulfhada,
36. Son of Art Aeinfhir,
37. Son of Conn of the Hundred Battles.


#### Pedigree of O Madaghain

1. Murchadh,
2. Son of Eoghan,
3. Son of Murchadh,
4. Son of Cathal,
5. Son of Madaghan Mor,
6. Son of Diarmaid,
7. Son of Dunadhach,


---

p.59

10. Son of Gadhra,
11. Son of Dunadhach,
12. Son of Cobhthach,
13. Son of Maelduin,
14. Son of Donngal,
15. Son of Anmchadh,
16. Son of Eoghan Buac,
17. Son of Cormac,
18. Son of Cairpri,
19. Son of Feradhach,
20. Son of Lughaidh,
21. Son of Dallan,
22. Son of Bresal,
23. Son of Maine Mor.
24. Son of Eochaidh Ferdaghiall,
25. Son of Domhnall,
26. Son of Imchadh,
27. Son of Colla da Crich,
28. Son of Eochaidh Doimlein,
29. Son of Cairpri Lifechair,
30. Son of Cormac,
31. Son of Art,
32. Son of Conn Ced-cathach,
33. Son of Feidhlimidh Rechtmhar,
34. Son of Tuathal Techtmhar,
35. Son of Fiacha Finnalaigh,
36. Son of Feradhach Finnfechtnach,
37. Son of Crimhthann Nianar,
38. Son of Lughaidh Riabh n-Derg.




---

p.63


Customs of Hy-Many
------------------


These are the tributaries of the Clann Ceallaigh: the O'Duibhginns, the O'Geibhennaighs, the Mac Cathails, the Mac Floinns, Muinter Murchadhan; and the Clann Aedhagain until they became Ollamhs to the arch-chief.


The third part of the province is *to be* their patrimonial country for ever. And the third part of every treasure


---

p.65




found hidden or buried in the depths of the earth is to be given to
 these tribes; and the third part of the **eric** for every man of their people that is killed is to be given to the family of the arch-king.


The third part of every treasure thrown by the sea into the harbours of Connaught *is to be given* to that tribe.




---

p.67


The marshallship of the forces *of all Hy-Many*, from Caradh to Luimnech, *on all expeditions* into Leinster, and into heroic Munster, belongs to the noble tribes.


These tribes are freed from the hostings of Spring and Autumn, and there is no power to ask them against their will.


No man of the province is to be taken as witness against these tribes, but another Hy-Manian is to bear witness.


If the hosting of Connaught should remain longer than a fortnight and a month, the Manians have liberty to return home.


However great *may* be the accusation brought against them by dishonest people, only one man or one witness is required to deny it or prove it *against the other party*.


Every privilege which books mention to be allowed to the Oirghialla, the same is given to O'Kelly by the Connacians.


These are the seven **oirrighi** *i.e. sub-chiefs* of Hy-Many, viz., O'Conaill, and he has the same patrimony as Mac Cnaimhin and


---

p.69




O'Dubhurrla. The chiefs of the Sil Anmchadha are the O'Madudhains. The kings of Maenmagh are Muintir Neachtain and


---

p.71




the O'Maeilallaidhs. And the king of Erin, strange to say, gives a subsidy to the chiefs of the Hy-Fiachrach Finn, more than *[or in preference to]* the king of Hy-Many.


The six Soghans with their cantred: to whomsoever of them they cede the chieftainship, he is called **Orrigh** during his reign.




---

p.73


These are the Cinel Rechta, the Cinel Trena, the Cinel Luchta, the Cinel Fergna, the Cinel Domaingen, the Cinel Geigill. There are three **Orrigh**s *i.e. sub-chiefs* over the Race of Crimhthann Cael, viz., two **Orrigh**s of his own race, and two of the Sil-Muireadhaigh.


These are the three, viz., the O'Mailruanaidhs, the O'Muroins, and the O'Cathails.




---

p.75


The king of Caladh, *which extends from* Moin Inraidech to Cluain Tuaiscirt of the Shannon, is Mac Gilliduibh, O'Laeghachain, or O'Laeghog, are the **flaith**s *i.e. chieftains* of that fair cantred.


The seven **flaith**s of Hy-Many are these, viz., Mac Eidhigan, chief of Claim Diarmada; Mac Gilli-Enan and Muinter Chinaith are


---

p.77




chiefs of Clann Flaitheamhail; Muinter Domhnallain, chief of Clann Breasail; O'Duibhginn, chief of Clann Duibhginn; O'Gabhrain of Dal n-Druithne; O'Docomhlan of Rinn na h-Eignide; O'Donnchadha of Aibh Cormaic Maenmuighe; and O'Mailbrighdi is chief of Bredach, the noblest cantred in Hy-Many.


There are seven principal **Comharba**s in Hy-Many, viz., the


---

p.79


**Comharba** of Cluain Fearta, the **Comharba** of Cill Mian, the **Comharba** of Cill Tulach, the **Comharba** of Cill Cumadan, the **Comharba** of Camach Brighdi, where the people of Hy-Many are baptized, the **Comharba** of Cluain Tuaiscirt of the Shannon, in whom it is hereditary to inaugurate the *chiefs of the* race of Cellach; and the **Comharba** of Cluain Cain Cairill.


St. Bridget has the baptism of the race of Maine, and although the baptism may not be brought thither, *i. e. to her church* the **comharba** has the power of collecting the baptismal penny from these tribes; and it *i.e. the money thus obtained* is divided into three parts, of which one-third part is given to herself, *i. e. to her **Comharba***, one-third to Druim Drestan, and one-third to Cluain Emhain.




---

p.81


Cromthar Aedh of Sil Anmchadha, has a **sgreaball ongtha** from every Hy-Manian.


The burial of the race of Cairpri Crom belongs to Clonmacnoise and St. Ciaran, for which a tribute is paid to St. Ciaran; he has seventeen townlands of free land in Hy-Many.


The race of Maine, both women and men, pay a **sgreaball caethrach** to St. Grellan.


St. Grellan presides over their battles, i. e. the crozier of St. Grellan, or some such, is *borne* in the standard of the king of Hy-Many.




---

p.83


Seven garments are given by the queen to St. Cairech Dergain yearly, and a penny by every Hy-Manian daughter along with the tribute of St. Ciaran.


Every tribute which these tribes were bound to give to St. Patrick *in the district which extends* from Glun-Phadruig to Glaisi Uair, now belongs to St. Cairell; and thence eastwards to the Sinainn, belongs to St. Grellan and St. Patrick.


The enslaved tribes of Hy-Many for servitude are these, viz. the Dealbhna from Ath Liag, to where the River Suca *i.e. Suck* springs from the well in Sliabh Formaili. The **Cathraigh** of the Suca


---

p.85


*extending* from Upper Tuaim Cathraigh to Porta Fidigi, on both sides of the Suca; also the Corco Moncho and Dal n-Druithni, and the men of Magh Sen-chineoil, until noble tribes were planted in their places after them; and also Muinter Milcon. And the arch-chiefs of Hy-Many had the power to increase the rents on those tribes ad libitum. Also the family of the O'Mailfinnains,


---

p.87




on account of their exile. There are also townlands which we have not mentioned of the Firbolgs in those districts *who are bound* to serve the chiefs, and who are serfs and hereditary followers of the kings of Hy-Maine. The Cadanachs of the Feadha, with their tribes, and the remnants of the Fir Bolgs, are the hereditary servitors of Hy-Maine.


O'Conaill and Mac Eidhigan have the *marshallship* of the forces, and the Hy-Fiachrach Finn and the race of Soghan have the *office of* **taisigheacht scuir**.


O'Kelly's part of the office of door-keeper to the king of Connaught belongs to the Hy-Fiachrach Finn.


The ***taisigheacht allaidh*** of O'Conor *king of Connaught* belongs to the Dail Druithni, at the recommendation of O'Kelly.


The office of distributor *butler* to the arch-chief, without limitation, belongs to O'h-Uroin, of Cluain Ruis.




---

p.89


The superintendence of his banquets belongs to O'Lomain.


The office of **Cul-choimed** belongs to the Clann Indrechtaigh, and to the races of Bran and Ailil with their adherents.


The **taisighecht eallaigh**, together with the keeping of the cups, chess-boards, rings, gold and silver, belongs to the Clann-Flaitheamhla.


The arms and the dresses are with the Clann Bresail, and it is theirs to respond for Hy-Maine to every general challenge of combat from strange territories.


The headship of every people who revenge the insults of Hy-Maine belongs to the race of Crimthann Cael, i. e. to the Crumthanns and the Clann Aedhagain, and theirs is the privilege to array the battalions and go in the place of the arch-chief in the conflict. It is around the Soghans all assemble to the conflict, for they are the body *i. e. phalanx* of every battle-field to all.


To the Aes Brengair belongs the stewardship of the arch-chief, and it is the office of the Hy-Draighnen of Ard na Cno to distribute justice to the tribes.




---

p.91


The hounds are with the Crumhthanns *Cruffons*. O'Kelly's part of O'Conor's hounds are with the Hy-Teimnein of Muilenn Glaisni. His iron is with the Hy-Tuathaigh, of Echdhruim, and the Hy-Baedain, of Badhna.


The office of door-keeper to the arch-chief belongs to the Clann Indreachtaigh; the Hy-Brain had it at first.


The inauguration and dethroning *of the arch-chief* at the instance of the Hy-Maine, belong to the Clann Diarmada, to the Hy-Cormaic of Maenmagh, and to the family of Mithighen, **Comharba**s of Cluain Tuaiscirt.


The Soghans have **taisigheach scuir** *i. e. superintendence of the horse*. The Cinel-Aedha have the rearing of his horses. The inhabitants of the southern part of Echtghe have the rearing of his hounds. The Dal Druithne have the carrying of the wine from the harbours of the west of Connaught to the seats of the arch-chief. The Hy-Docomhlann have the erection of the edifices, both houses and out-houses, at the three upper habitations of the arch-chief. The Bolgic tribes of Badhna *i.e. Slieve Baun* have the building of his edifices at the lower seats. The Cantred of Caladh have his stewardship both of rent and exactions.


The Crumhthanns have the proclamation of his battles. The


---

p.93




inhabitants of the northern part of Fidh-Monach have his otters and fishing. The Bolgic tribe of Echtghe *i.e. Slieve Aughty* have the feeding and keeping of his stud. Every work he requires or commits to them is to be executed by the Cathraighi, so as that they are not deprived of their lordship.


His implements of battle, the keeping of his treasures, and the keeping of his hostages, are in Bredach.


His harpers are the O'Longargains, of Baile na Banabai, and his **cornairedha** *i.e. trumpeters* are *the family* of Lis na Cornaireagha, that is, the O'Sidheachains.


He is to be maintained in his kingly place and protected by the king of Cashel, for it is the guarantee of the king of Cashel that keeps the king of Hy-Maine from *being overwhelmed by* the Sil-Muireadhaigh. Wherefore the king of Hy-Maine is under a solemn injunction not to wage war on the Eoghanachts.


The subsidy of the king of Connaught to be reckoned out to the king of Hy-Maine,—(and it is little of his tribute goes in gifts),— is as follows here, as was said in these lines:


> 1. The king of Hy-Maine, the hero, is entitled
>   
> To ten steeds, which came across the boisterous brine,
>   
> To ten foreigners ready at deed of anger,
>   
> Ten standards and ten mantles.
> 




Finit.