

The journal of John Stevens, containing a brief account of the war in Ireland, 1689–1691


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The journal of John Stevens, containing a brief account of the war in Ireland, 1689–1691
========================================================================================


Author: John Stevens
--------------------


### File Description

Robert H. MurrayElectronic edition compiled and proof-read by Beatrix Färber 

Funded by University College, Cork 2. Second draft.Extent of text: 
119770 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2010) (2016) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E680002-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

#### Sources


**Manuscript source**2. London, British Library, Add. 36296.
3. London, British Library, Lansdowne MSS. 828, ff. 10, 10 b, 11 (contains introduction)
**Books by John Stevens**2. John Stevens, A Journal of my Travels since the Revolution containing a brief account of all the War in Ireland, ed. by R. H. Murray (Oxford 1912) [London: British Library, Add. Ms. 36,296].
**Further Reading: a Selection**2. Gerard Boate, Ireland's Naturall History, London 1652. Chetham Society. Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan (New York 2006).
3. George Walker, A true account of the siege of London-Derry (London 1689).
4. An Account of the town and castle of Charlemont in Ireland, besieg'd by a detached body of the Duke of Schombergs army under the command of Lieutenant General Douglas (London 1689).
5. George Story, A true and impartial history of the most material occurrences in the kingdom of Ireland during the last two years: by an eye-witness (=An impartial history of the wars of Ireland, Part 1) (London 1691).
6. George Story, A continuation of the impartial history of the wars of Ireland (London 1693).
7. Laurence Eachard, An Exact Description of Ireland (London 1691).
8. Anon., An exact journal of the victorious progress of Their Majesties forces under the command of Gen. Ginckle, this summer in Ireland: giving a particular account of the several skirmishes, battles, sieges and surrenders of Athlone, Galloway, Slego, &c. together with the total defeat of the Irish at Agrim and Thomond-Bridge: and lastly of the capitulation and surrender of Limerick. (London: Printed for Randolph Taylor near Stationer's Hall, 1691).
9. Nicholas Bernard, The whole proceedings of the siege of Drogheda: to which is added, A true account of the siege of London-derry (Dublin 1736).
10. Robert Parker (of the Royal Regiment of Foot in Ireland), Memoirs of the Military Transactions in Ireland (...) from 1683 to 1718. Published by his son (Dublin 1746).
11. W. Harris, History of the Life and Reign of William III. (Dublin 1749).
12. Thomas Burke (de Burgho), Hibernia Dominicana: sive historia provinciae Hiberniae Ordinis Praedicatorum [...] (Coloniae Agrippinae (= Cologne) 1762).
13. Mémoires du maréchal de Berwick, écrits par lui-même (...) (Paris 1778).
14. William Tighe, Statistical Survey of the County of Kilkenny (Dublin 1802).
15. John Nichols, Literary anecdotes of the eighteenth century: comprizing biographical memoirs of William Bowyer, Printer, F. S. A. and many of his learned friends (. . .), 9 volumes (London 1812–1816).
16. Rev. J. S. Clarke (ed.), The Life of King James the Second, King of England, etc., collected out of the Memoirs writ of his own Hand, 2 volumes (London 1816).
17. G. S., Two unpublished diaries connected with the battle of the Boyne, one entitled "Bonnivert's Journey" taken from the Sloane Mss. (Brit. Mus.) and the other from the autobiography of Rev. Rowland Davis, Ulster Journal of Archaeology (1:4 1856) 77–95; 169
18. Charles O'Kelly, Macariae Excidium, or the destruction of Cyprus, ed. J. C. O'Callaghan, 1850. [An allegory of the war from the Gaelic Irish point of view.]
19. J. D'Alton, King James' s Irish Army List, 1689 (Dublin 1861).
20. Onno Klopp, Der Fall de Hauses Stuart und die Succession des Hauses Hannover in Gross-Britannien und Irland (Vienna 1875–1888).
21. P. W. Joyce, A Social History of Ancient Ireland. 2 volumes. (New York, London, and Bombay 1903).
22. The memoirs of Ann, Lady Fanshawe, wife of Sir Richard Fanshawe, bart., 1600–72, reprinted from the original MS. in the possession of Mr. Evelyn John Fanshawe of Parsloes, (London 1907).
23. Demetrius Charles Boulger, The Battle of the Boyne: together with an account based on French and other unpublished records of the war in Ireland (1688–1691) and of the formation of the Irish brigade (...) France (London: Seeker 1911).
24. Robert H. Murray, Revolutionary Ireland and its Settlement (London 1911).
25. Robert H. Murray, The diary of Bonnivert, 1690, (giving an account of the Jacobite War), PRIA 30, sect. C, 331–341, January 1913 [Available online at CELT].
26. Robert H. Murray, Ireland, 1603–1714 (London 1920).
27. J. M. Flood, The sieges of Limerick, 1690–91; a narrative based on contemporary sources. (Limerick: Limerick Leader, 1944).
28. R. B. McDowell, 'The problem of religious dissent in Ireland, 1660–1740'. Bulletin, Irish Committee of Historical Sciences 40 (1945).
29. J. G. Simms, Williamite peace tactics, 1690-1, Irish Historical Studies 8:32 (1952/53) 303–23.
30. J. Jordan, 'Würtemberg at Limerick, 1690'. Studies; an Irish quarterly review, 43 (1954) 219–225.
31. J(ohn) G(erard) Simms, 'The surrender of Limerick, 1691'. Irish Sword, 2:1 (1954) 23–28.
32. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
33. J. G. Simms, The Williamite confiscation in Ireland, 1690–1703 (London: Faber and Faber 1956).
34. J. G. Simms, 'Eye-witnesses of the Boyne'. Irish Sword, 6:22 (1963–4) 16–27.
35. J. G. Simms, 'The siege of Derry (1689)'. Irish Sword, 6:25 (1963–4) 221–33.
36. J. G. Simms, The Jacobite Parliament of 1689 (Dundalk: Dundalgan 1966).
37. J. G. Simms, The siege of Derry (Dublin: APCK 1966).
38. J. G. Simms, Jacobite Ireland 1685-91 (London: Routledge and Kegan Paul 1969).
39. Liam Cox, The Williamite war in Westmeath and Ginkle's march to Athlone, Irish Sword 9 (1970) 308–317.
40. F.G. James, Ireland in the Empire, 1688-1770: a history of Ireland from the Williamite wars to the eve of the American Revolution (Cambridge MA 1973).
41. Michael Hewson, Robert Stearne's diary of the Williamite campaign, An Cosantóir 33 (1977) 49–53.
42. Sheila Mulloy, 'French eye-witness of the Boyne', Irish Sword 15 (1982) 105–111.
43. J. G. Simms, War and politics in Ireland: 1649–1730; edited by D.W. Hayton and Gerard O'Brien. London: Hambledon, 1986.
44. Patrick Macrory, The siege of Derry (Oxford: Oxford University Press 1988).
45. Peter McCartney, The siege of Derry 1689 (Derry: Guildhall Press, 1988).
46. D. Murtagh, H. Murtagh, 'The Irish Jacobite army, 1689–91', Irish Sword, 18 (1990) 32–48.
47. P. W. Joyce, The origin and history of Irish names of places. [Facsimile of the original edition in 3 volumes published 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe. Dublin: Éamonn de Búrca for Edmund Burke 1995.
48. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
49. Ian McBride, he siege of Derry in Ulster Protestant mythology (Dublin 1997).
50. William Kelly (ed.), The sieges of Derry. (Dublin: Four Courts 2001).
51. Michael Sheane, The great siege (Ilfracombe 2002).
52. Michael Sheane, King William's victory: the Battle of the Boyne (Ilfracombe 2006).
53. John Childs, The Williamite wars in Ireland, 1688–91 (London 2007).
54. Matthew Glozier and David Onnekink (eds.), War, religion and service: Huguenot soldiering, 1685–1713 (Aldershot 2007).
55. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. The journal of John Stevens, containing a brief account of the war in Ireland, 1689–1691. John StevensRobert H. Murray (ed), First edition [lxiv+241 pages; appendix, index; bibliography; one map.] Clarendon Press Oxford (1912)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the author's introduction and pp 1–216 of the volume. The editor's footnotes are included. Where they contain tabular information, the presentation of the electronic edition may differ slightly for technical reasons, but all information given is preserved unless otherwise indicated.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


Non-standard spellings of personal names and place names are standardised using the reg attribute within the corresponding name tags. Other place-names are tagged. Outdated spellings are encoded orig, with the reg attribute indicating the normalised spelling. Where the hardcopy has phrases in uppercase, in the electronic edition these are encoded in emph tags and normalised to mixed case. Encoding is subject to revision. 


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the book; div1=the part. The subsections are structured by entries given in chronological order; paragraphs are marked; page-breaks are marked pb n="". The editor's introduction is contained in an unnumbered div in the front matter.


##### Standard Values


The dates are those given by Stevens. For his variation between 'old style' (st. vet.) and 'new style' (st. no.) see footnote on p. 17. The format given here is the ISO form, yyyy-mm-dd.


##### Interpretation


Place-names, group and personal names are not tagged. Words, terms, and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the book. ### Profile Description


Created: By John Stevens
 Date range: 1689–1691.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] Many words and phrases in the footnotes are in French.


##### Language: [ES] Some words and phrases are in Spanish.


##### Language: [PT] A phrase is in Portuguese.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [IT] A word is in Italian.


##### Language: [GA] A word is in Irish (in anglicised spelling).


### Revision History


* (2016-07-26) Beatrix Färber (ed.)

* Additions made to bibliographic details, new wordcount, and new SGML and HTML files created.
* (2012-01-31) Beatrix Färber (ed.)

* File re-parsed; header updated; new SGML and HTML files created.
* (2012-01-30) Juliette Maffet (ed.)

* Proofing and checking of French text within the file.
* (2010-10-27) Beatrix Färber (ed.)

* Online proofing; English sections of file spell-checked; SGML and HTML versions updated.
* (2010-10-26) Beatrix Färber (ed.)

* Conversion script run; header modified; file re-parsed; SGML and HTML versions created.
* (2010-10-24) Beatrix Färber (ed.)

* Second proofing and application of all structural and content content encoding finished; file validated.
* (2010-10-08) Beatrix Färber (ed.)

* Header created with bibliographic details.
* (2010-10) Beatrix Färber (ed.)

* File proofed (2); more content encoding applied.
* (2010-09 to 2010-10) Beatrix Färber (ed.)

* File proofed (1); strucutral and content encoding applied.
* (2010-07-14) Beatrix Färber (text capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E680002-001


### The journal of John Stevens, containing a brief account of the war in Ireland, 1689–1691: Author: John Stevens


PREFACE
-------


This first edition of the Journal of John Stevens has had the advantage of the criticisms of two masters of seventeenth-century history, Mr. R. Bagwell and Professor C. H. Firth, who most kindly read through the manuscript and proof-sheets. To Professor Fitzmaurice-Kelly's special and intimate knowledge of Spanish literature I owe not a little. Mr. A. C. Stewart, of the British Museum, furnished me with valuable suggestions. Messrs. Macmillan & Co. have been good enough to allow me to use the map of **Limerick** in my Revolutionary Ireland and its Settlement. My thanks are due to Dr. F. Elrington Ball and Mr. T. U. Sadleir, for their readiness to advise me on difficult points, and also to Major and Mrs. Lenox Conyngham, of Spring Hill, for their kindness in lending me their copy of the Negociations ... en Irlande, 1689–90 by Comte d'Avaux. It only remains for me to express my gratitude to my wife for the patience and judgement with which she revised the proof-sheets.


ROBERT H. MURRAY.
  
11 Harcourt Terrace, Dublin.




---

p.ix


Introduction
------------


### The Life of John Stevens


Of the life of John Stevens not many details remain, but from his journal some facts emerge. Thus, he served three years in the army in Portugal, he was in civil employment in England, and at the time of the Revolution he was collecting the excise and was stationed at **Welshpool**; he spent a year in Wales. He first saw **Drogheda** in 1685, and **Limerick** in 1686, and when he lived in **Dublin** he did so ‘in esteem and with splendour’. Twice in his journal he refers to a book of his travels in Ireland, but this has disappeared. In Singer's edition of the Clarendon correspondence occur some references to him. In the Appendix to the first volume is printed the Earl of Clarendon's list of the gentlemen of his bedchamber, with remarks on their character. There Stevens is described as ‘an honest, sober, young fellow, and a pretty scholar. His father is a page of the back-stairs to the Queen Dowager, and has been so from her first landing: he waited on my father in Spain. He is a Roman Catholic. They are very good, quiet people. I would be glad to get a colours for him.’ The advent of Tyrconnel to power effectually stopped all favour for any friend of Clarendon. On October 23, 1686, the latter wrote to Rochester:
  


‘We have now fresh reports out of England that there are speedily to be great alterations in the army; and reports of that kind having often proved true, I hope your Lordship will forgive me, if by way of provision I take the liberty upon the encouragement you have formerly given me, to bespeak your Lordship's favour on behalf of some young men who have depended upon me, and came over with me, and to whom I would be very glad to do good. And, if 



---

p.x



beggars may be choosers, your Lordship will give me leave to mention the names of the persons and the employments I could wish for them.  
[*...*]  
 There are two others for whom I would be very glad to provide: one De la Hyde, and one Stevens. They are both Roman Catholics.  
[*...*]  
 Stevens is a very honest young man; his father belongs to the Queen Dowager. A colours would make him very happy.’


On November 17, 1686, he again wrote to Rochester:
  


‘This bearer, Stevens, came over with me, one of my gentlemen at large; he is a very honest young man; his father is a page of the back-stairs to the Queen Dowager, and did formerly wait upon my father at **Madrid**. I intended to have done something for him, but so little interest has a Lord Lieutenant at present, that he can provide for nobody, which makes men think a little of themselves. His father has sent over for him, in hopes to get him into something there; if he have need of your help, let me beg you to assist him. I am sure he will deliver a letter safe to you, and therefore I will write of such things as are not fit to mention by the post.’


Two days later he writes to the same correspondent: ‘I have written to you by a servant of mine who goes hence to-day for Chester; one Stevens, who will deliver it safe to you within a few days after this.’ Stevens was an ardent Jacobite, and therefore he fled to France on the nth of January, 1689. On the 2nd of May, 1689, he landed at **Bantry**, and took part in the war. The journal ceases in the middle of an account of the battle of **Aughrim**. He was not attainted until 1695: his death occurred on October 26, 1726.


Before the Jacobite war he had paid some attention to literature, but after the war he devoted himself to it. There can be no doubt that Stevens knew Spanish well, but this was not a very rare accomplishment in his time. Hence he cannot be regarded as a pioneer. There is a steady production of translations from Spanish dating back to the early sixteenth century, when Lord Berners issued his versions of San Pedro's Cárcel de Amor and Guevara's Libro aureo. 



---

p.xi



It may, indeed, be contended that Berners's knowledge of Spanish is questionable, and that his translations—so called—are from a French rendering of the Spanish texts. This is quite possible. But there is no doubt at all that Sir Thomas North knew Spanish, and to him is due a very admirable translation of Guevara, published under the title of The Diall of Princes in 1557. North, then, is a pioneer, and the many men who made translations from the Spanish between North's time and Shelton's are also pioneers. Shelton is the author of the first translation of Don Quixote (1612–20). He had the rare good fortune to translate a masterpiece, and, though his version is full of little mistakes, it is in the grand manner. He had the advantage of being a contemporary of Cervantes, and he renders his author with an Elizabethan amplitude which atones for incidental slips and negligences. His translation has an individual savour that keeps it alive.


It is plain, then, that Stevens was not an explorer in an unknown domain. He had many predecessors, and his work is not on the same level as the work of the best of his predecessors. His translations are not equal to North's Guevara, to David Rowland's Lazarillo de Tormés, to Shelton's Cervantes. And he had an unhappy trick of inviting comparisons. Thus in 1706 he takes Shelton in hand, and issues him revised and corrected, and so on. It is difficult not to resent this. It may be that Stevens corrects some of Shelton's oversights, but in doing this he lowers the tone of the translation, and all the sparkle goes out of it. Again, take the volume published by Stevens in 1707, under the title of The Spanish Libertines. It contains, amongst other things, a version of La Celestina. A man who knows no Spanish might get some idea of the original by reading this version, but it is a wan, pale transcription indeed if one compares it with the vigorous, full-blooded translation of La Celestina, issued by James Mabbe 



---

p.xii



in the previous century. The fact that Stevens invites these comparisons is distinctly unfortunate for him. He is not in the same class with North, and Shelton, and Mabbe, nor even on the same level as Rowland, or as Bartholomew Young, the translator of the Diana. He lacks the lustiness of L'Estrange, though he knew far more Spanish; in all respects he ranks below Southey; and as a scholar he is much inferior to Ticknor and Stirling-Maxwell.


From his numerous works nothing personal can be gleaned about the writer: they are uniformly inscribed ‘Captain Stevens.’ Even the dedications yield scanty information. The translation of Sandoval's History of Charles V is dedicated in 1705 to James, Duke of Ormonde, and runs as follows: ‘I should be wholly at a loss how to accost your Grace, did I present you a work of another nature; but the martial spirit that reigns throughout this whole book, emboldens me to approach so noble a person, who has made war his exercise and delight.’ The subscribers to The History of the Ancient Abbeys include peers, prelates, and clergy, but with the exception of Sir John Vanbrugh their names are not very well known. There are a few Irish subscribers, such as Mr. Williamson of **Dublin**, merchant. From the preface to this book it is evident that Stevens formed a high impression of the value of his work. ‘It is well known,’ he states, ‘that Sir Walter Raleigh's History of the World at the first met with a very cold reception; but time made its value known. The Monasticon Anglicanum lay many years before its fame had spread itself abroad. Many now celebrated writers have been for some time as it were buried, and unregarded. I do not mean to rank myself among them; but this I am fully convinced of, that as prejudice shall begin to wear off I shall meet with a more favourable entertainment.’ His first publication was an abridged translation in three octavo volumes of Manoel de Faria e Sousa's Europa Portugueza: it appeared in 1695. Three years afterwards



---

p.xiii



he translated the same writer's History of Portugal to 1640, which he continued to 1698: it was dedicated to Catherine, Queen Dowager of England, and daughter of King John of Portugal. He also rendered into English Francisco de Quintana's The most entertaining History of Hippolyto and Aminta, of which a second edition appeared in 1727. His translation of Juan de Mariana's History of Spain appeared in 1699: it must be regarded as meant for the general public. Scholars who did not happen to know Spanish would naturally turn to Mariana's Latin version of his history, of which twenty-five books appeared in 1592, while the whole thirty books appeared in 1605. The Spanish version, also by Mariana, appeared at intervals during the years 1601, 1608, 1617, 1623. It is obvious that the Latin version preceded the Spanish one, but Mariana greatly improved his work in the latter form, and Stevens did well in choosing this as his basis. His translation does not convey the stately archaism of Mariana's style, but no doubt it was useful enough to a generation that was gradually growing less familiar with Spanish. In 1715 he published a translation of The History of Persia, written in Arabic by Mirkond; and an abridgement of the lives of the kings of Harmuz or Ormuz, by Torunxa. Stevens gave a very free translation of Antonio de Herrera's General History of the Vast Continent and Islands of America, commonly called the West Indies; this was issued from 1725 to 1726, and was reprinted in 1740. His plan of publishing in 1711 A New Collection of Voyages and Travels deserves notice.


‘As for the method here intended,’ the advertisement declares, ‘it is to publish every month, as much as will make a book of 12d., or 18d., according as it can be contrived, without breaking off abruptly, to leave the relation maimed and imperfect.  
[*...*]  
 Now each month being sold stitched, every buyer may afterwards bind them up when he has an author complete.   
[*...*]  
 All the books shall be adorned with proper maps and useful cuts.’




---

p.xiv


The Collection of Voyages and Travels consists of The Description, &c., of the Molucca and Philippine Islands, by L. de Argensola; The Travels of P. de Cieza in Peru; The Travels of the Jesuits in Ethiopia; The Captivity of the Sieur Mouette in Fez and Morocco; The Travels of P. Teixeira from India to the Low Countries by Land; and A Voyage to Madagascar by the Sieur Cauche. This collection was republished in 1719.


A devout Roman Catholic, Stevens exhibited much interest in ecclesiastical matters. In 1718 he published, without putting the usual ‘Captain Stevens’ on the title-page, a folio translation and abridgement of **Dugdale**'s Monasticon Anglicanum. Ralph Thoresby, a correspondent of Stevens, attributed it to a Spanish priest. According to him it is ‘an useful book in its kind’, though ‘there are both typographical errors and others, besides some reflections upon the Revolution’.[1](javascript:footNote('E680002-001/note001.html')) In 1722–3 Stevens published The History of the Antient Abbeys, Monasteries, Hospitals, Cathedral and Collegiate Churches,... being two additional volumes to Sir William Dugdale's Monasticon Anglicanum. In 1722 he issued anonymously Monasticon Hibernicum; or the monastical History of Ireland. According to Stevens ‘the same is neither a translation nor his own compiling’. He uses Louis Alemand's Histoire Monastique d'Irlande (Paris, 1690) extensively, and though ‘this Monastical History of Ireland is due to him, he having laid the foundations, and found most of the materials, yet can it not be called a translation, on account of the many additions and alterations that have been made to it.’[2](javascript:footNote('E680002-001/note002.html')) Unlike his adaptation of Herrera, his version of the Venerable Bede's Ecclesiastical History of Britain is so literal as to be obscure. Some of the notes were used by W. Hurst in his translation published in 1814, while in 1840 Dr. Giles and the volume in Bohn's Antiquarian Library, 
**Camden**


---

p.xv



1847, made Stevens's translation the basis. From the French he translated in 1712, for Lintot, part of Dupin:[3](javascript:footNote('E680002-001/note003.html')) this is probably Louis Ellie Dupin's Bibliothèque Universelle des Historiens. He rendered into English in 1722 P. J. D'Orleans's Histoire des Révolutions en Angleterre sous la Famille des Stuarts. This indefatigable worker also compiled A Brief History of Spain, 1701; The Ancient and Present State of Portugal, 1701, founded on Faria e Sousa's Asia Portugueza; The Lives and Actions of all the Sovereigns of Bavaria, 1706; A Spanish-English and English-Spanish Dictionary, 1726; and The Royal Treasury of England, or, an historical account of all taxes, from the conquest to this present year, 1725; and a second edition, 1733. There is no date of publication of The rule establish'd in Spain for the trade in the West Indies; being a proper scheme for directing the trade to the South Sea, now by act of parliament to be establish'd in Great Britain. A careful perusal of this volume yields no information on the workings of the mercantile policy, for it is merely a technical trade manual of West Indian commerce. Stevens translated it from a book by Don Joseph de Veitia Linage, Knight of the Order of Santiago, and Treasurer and Comptroller of the India House. Doubtless the manual was useful to merchants, for it gives the laws, ordinances, customs, practices, and, in fine, all that relates to the trade of the West Indies: thus there is an account of the methods of local courts, the table of duties, and the manner of assaying.


All the time these historical, ecclesiastical, and commercial volumes were pouring forth Stevens was not forgetting his literary studies. In 1697 was issued his version of Francisco Manoel de Mello's The Government of a Wife: it was dedicated to Don Sen da Cunha, the Portuguese envoy. In the same year Stevens published a version of Quevedo's Fortune in her Wits, or the Hour of all Men. In 1707 he issued 
 


---

p.xvi



a translation of the collected comical works of Quevedo, which was republished in 1709 and in 1742. A rendering by Stevens of Quevedo 's Pablo de Segovia, the Spanish Sharper, formed the basis of the Edinburgh version of 1798, and was reprinted in the second volume of ‘The Romancist Novelists' Library’, edited by W. C. Hazlitt in 1841. The Edinburgh issue begins with a version of Quevedo's Sueños (i. e. Visions), and this does not seem to be from the Spanish. It seems that Stevens—or whoever the translator was—had simply taken L'Estrange's translation, and touched it up. L'Estrange himself did not translate from the Spanish, but from a corrupt French version. Under the circumstances, the rendering ascribed to Stevens need not be taken seriously. On page 293, column a, of James Lyman Whitney's Catalogue of the Spanish Library and of the Portuguese Books bequeathed by George Ticknor to the Boston Public Library (Boston, 1879), the following manuscript note is quoted from Ticknor's copy: ‘This translation is said by T. Roscoe ( Spanish Novelists, ii. 8, 1832) to be made by Stevens.  
[*...*]  
 The Visiones are a **rifacimento** of Sir Roger L'Estrange's translation of them, rather than a new one.’ Perhaps it is worth remarking that Major Hume in his Spanish Influence on English Literature states[4](javascript:footNote('E680002-001/note004.html')) that ‘Captain Stevens also translated  
[*...*]  
 The Life of Paul the Spanish Sharper, and evidently some of Swift's most scathing satires are inspired by this and others of Quevedo's works’. There is, however, no evidence to support this view. Swift might, of course, have read Quevedo in one of the poor English versions, but this is a very different matter, and certainly cannot be proved. In spite of his wide knowledge of Spanish, the translations of Stevens from that language are not distinguished, and are often careless. He did honest journeyman's work in a rather humdrum way, which was not wholly bad, and perhaps served its purpose at the time. It is fair to remember that 



---

p.xvii



his translations of Quevedo are the basis of Pineda's version published in 1743; that shows his influence to some degree, though Pineda and his work are long forgotten. On the whole, then, Stevens is not eminent as a Spanish scholar.


### Authorities on the Jacobite War


Thus our author's tale of work is long and not altogether undistinguished. One example, however, remains to be considered, and it belongs to a class entirely different from all the others. This is A Journal of My Travels since the Revolution, and it has not been published till now. This journal begins on January 16, 1689, and abruptly closes on July 1, 1691, while the writer is giving an account of the battle of **Aughrim**; perhaps his copy fell out of his knapsack. As this volume constitutes an important addition to the literature of the Revolution in Ireland it becomes necessary for us to consider the authorities for that movement. In the Royal Irish Academy, **Dublin**, there are seven folio volumes of much importance. These volumes begin with a proclamation of 1671, and a list of goods sold by Arthur Gore on June 19, 1676, and proceed to give a letter of Tyrconnel, December 18, 1689, which informs us that the **Derry** people ‘continue obstinate in their rebellion.’ They come down to February, 1692, when they cease. Among them are original letters from James to Hamilton, while the latter was engaged in the siege of the maiden city. In Trinity College, **Dublin**, is preserved the correspondence of George Clarke, Secretary-at-war (1690–4). Clarke's thirteen volumes are larger than the seven of the R. I. A., and they deal with operations all over Ireland. This secretary preserved all letters sent to him, and from them an intelligible view of the Williamite side of the war can be obtained. From the Jacobite standpoint they can be supplemented by the material in the Archives des Affaires Étrangères, **Paris**. Much trouble is caused to the student by the fact that these 



---

p.xviii



supplementary papers are in **Dublin** and **Paris** respectively, for they afford the most valuable insight into the minds of the generals. The Bodleian Library contains the Nairne Papers (1689–1701); some of these have been printed by J. Macpherson in his Original Papers. The papers of Sir Robert and Edward Southwell, principal Secretaries of State in Ireland, are now divided between the British Museum, Trinity College, **Dublin**, and the Public Record Office of the same city. These papers, however, are more valuable for the rest of William's reign than for the early period. Dr. T. K. Abbott's excellent Catalogue of the MSS. of T. C. D. gives particulars of such other sources as I. 6. 9, three volumes, E. 2. 19, F. 4. 3, K. 4. 10. In the Public Record Office, **Dublin**, the letters written in 1690 to Edward Southwell from **Cork**, **Kinsale**, and other towns (125/1), and those written in 1690 and in 1690–3 to. Edward and Robert relating to French prisoners and French privateers and other matters (125/3, 132, 138, 141/5, 142) deserve attention. As yet all these sources are unpublished.


Among the published authorities J. S. Clarke's Life of James II ranks as a primary authority. James, like his cousin Louis XIV, spent time in compiling an account of his life. Before he sent his wife and child with **Lauzun** to a place of safety in 1688 he secured his Memoirs, which he had kept most carefully. James enclosed them in a box and gave it to Terriesi, the Tuscan envoy. He sent to Terriesi one of his most confidential servants at midnight with papers and writings, requesting him to take charge of them as ‘he knew not where to place them in more honest hands.’
  
 

‘So the King having just time to thrust them all confusedly into it, sent it to him, which he, imagining it to be jewels of great value, was exceeding careful of it; tho' that imagination had like to have occasioned its miscarriage   
[*...*]  
 An Italian servant of the envoy's conveyed it safe to Leghorn, as directed; from whence the Grand Duke sent two galleys on purpose to convoy it into France, through 



---

p.xix



which kingdom it was brought likewise guarded up to St. Germains, all persons supposing it to be some great treasure: which tho' it was not of that nature which people imagined it, contained what in itself was much more valuable  
[*...*]  
 nine tomes, writ in his own hand, and which  
[*...*]  
 he appointed to be lodged in the Scotch College at **Paris**, where they will remain, not only an eternal, glorious monument of his actions, but a standing model both to his own Royal Posterity and to all Christian Princes of the most perfect resignation while a subject, and the most generous moderation while a king.’


While James was living at Saint-Germain he added notes upon later events. During the French Revolution the manuscript of the Memoirs was burnt. Tradition relates that it was brought to Saint-Omer with the intention of depositing it safely in England, but as it bore the arms of England and France fear of the revolutionary government caused its destruction. Though the Memoirs thus perished, yet a biography based upon them remained in existence. King James's son gave orders for a Life of his father soon after 1701. Ranke does not think that evidence exists to warrant the assumption that Innes, Principal of the Scots College, had the largest share in the composition, although James confided his Memoirs and papers to Innes a few months before his death. The Chevalier de Saint-George read the Life, underlined passages in it, and bequeathed it to his family. In 1707 he sent for that part of the Memoirs which referred to the year 1678. After the death of the Duchess of Albany, the wife of Charles Edward, the Life passed into the hands of the Benedictines at Rome, and was purchased by the British Government. The Napoleonic wars placed obstacles in the way of its safe transmission. It came to Leghorn, then to Tunis, then to Malta, and at last, in 1810, to England. The Prince Regent, who had a regard for the Stuarts, requested his chaplain and librarian, J. Stanier Clarke, to edit it, and in 1816 two handsome volumes were issued.




---

p.xx


The Life is in four parts. The first, which is unimportant, goes down to the Restoration in 1660; the second, which is most valuable, to the accession of James II; the third to his flight from England at the end of 1688; and the fourth embraces the rest of his life. Ranke [5](javascript:footNote('E680002-001/note005.html')) analyses the value of the four parts with his usual acuteness. It is clear that the original was written in a fragmentary manner—the most detailed portions by James, others compiled by his secretaries. Ranke did not use the Caryll Papers, which show that John Caryll, secretary to James's wife, Mary Beatrice, was working at the Life. Its originals are preserved at Windsor, with the other Stuart Papers, uncatalogued and inaccessible to the public.[6](javascript:footNote('E680002-001/note006.html')) At Welbeck there is a MS. (folio) which successively belonged to Henri Oswald de la Tour d'Auvergne, Archbishop of Vienna, Augustus Frederick, Duke of Sussex, Sir Thomas Phillipps, who also owned the Journal of Stevens, and the Duke of Portland. The title of this MS. is ‘Memoires de Jacques Second, Roy de la Grande Bretagne, etc. De glorieuse Memoire. Contenant l'histoire des quatre Campagnes que sa Majesté fit, estant Duc de York, sous Henry de la Tour D'Auvergne, Vicomte de Turenne, dans les Années 1652, 1653, 1654 et 1655  
[*...*]  
 Traduits sur l'Original Anglois écrit de la propre main de sa dite Majesté, conservé par son ordre dans les Archives du Collége des Ecossois á **Paris**. Le tout certifié et attesté par la Reyne Mère et Regente de la Grande Bretagne, etc., MDCCIV.’ From his careful survey of the Memoirs Ranke concludes that the biography is not the work of James. The extracts, however, of Carte and Macpherson prove that it is based on autobiographical notes and other authentic material. When the biographer does not use these, his work possesses little value: where he agrees with the extracts, there is little doubt that we have 



---

p.xxi



genuine autobiographic material. The fourth part has much to say on the war in Ireland. James drew up several reports on this war and sent them to Louis; these reports and the biography exhibit substantial agreement. In Macpherson's Original Papers there are passages identical with the words of the biography.


In 1830 the British Foreign Office printed privately the Négociations de M. le Comte D'Avaux en Irlande. These negotiations are concerned with the years 1689 and 1690, and cover over 750 pages. They are of the greatest value in revealing the motives of the inner policy of Louis XIV, the divisions among the Irish, the state of the army, and kindred problems. In the Memoirs of Sir J. Dalrymple there is printed a useful selection of letters. Mr. W. J. Hardy has edited the Calendar of State Papers, Domestic Series; volumes i, ii, and iii cover the years 1689 to 1691. In the Record Office, London, the State Papers, Ireland, volumes 352 and 353, the State Papers, Ireland, Signet Office, volume xii, and the State Papers, Ireland, Entry Books, volume i, are of the utmost importance.


The author of A Light to the Blind is probably **Nicholas Plunket**, an able lawyer, member of a branch of the house of Fingall. Under the pseudonym of John Rogers he acted in 1713–14 as a secret agent in England and on the Continent, working zealously in the interests of James Francis Edward Stuart. Together with the secretary of James, David Nairne, he planned a Jacobite descent to make their master James III of England. The exact title of Plunket's volume is A Light to the Blind; whereby they may see the dethronement of James the second, king of England: with a brief narrative of his war in Ireland: and of the war between the emperor and the king of France for the crown of Spain. Anno 1711. It begins with an account of James II before and after his accession to the crown, and furnishes details of the last 



---

p.xxii



days and death of that monarch in September 1701. There are three books, and the third discusses Continental affairs during the war of the Spanish Succession. A Light to the Blind is written from the standpoint of a firm believer in the Stuart cause. To Plunket, as to Stevens, James is the lawful king and William merely the Prince of Orange. The war is regarded as a revolt from the rule of the sovereign who ruled by right divine. Plunket, moreover, is persuaded that the Duke of Tyrconnel was a statesman of the first order. His death ‘pulled down a mighty edifice—a considerable Catholic nation—for there was no other subject left able to support the national cause.’ Towards Sarsfield the writer assumes an attitude of hostility, though he praises the ‘noble feat’ of the destruction of the Williamite Artillery at **Ballyneety**. A Light to the Blind bestows much attention upon the schemes of Louis XIV, and indicates why the French monarch should support the Irish. Take the following passages:
  


‘Here (i.e. at **Waterford**) the Prince of Orange may say, as Julius Caesar did in his expedition of Zela, veni, vidi, vici; so many towns hath the Prince taken without resistance. Which if each of them had given. Orange had been undone. For the wars of Ireland would have been prolonged; and consequently the Confederacy abroad would have been forced within two years at the farthest to make a peace with France for want of the assistance of England; which was all employed against the Irish. By which peace all the power of France would fall upon poor England, to her chastisement for her frequent rebellion; and to the dethroning of that unnatural usurper   
[*...*]  
’ (p. 618).
  


‘The most Christian king (i.e. Louis) was altogether for preserving **Limerick**; and that he doubted not of its baffling the enemy, as it did in the year antecedent. This sending of such considerable stores doth also indicate, that his Majesty was for continuing the war of Ireland; and that for this end he would send a reinforcement to the Irish army in spring following.  
[*...*]  
 The monarch of France had powerful motives for keeping on foot the Irish war. For thereby he would sooner dissolve the 



---

p.xxiii



hostile Confederacy abroad, as retaining the power of England (on which the League much depended) here in Ireland employed; and in the sequel thereof that Prince would be able to restore sooner the banished King of England.  
[*...*]  
 'Tis for these reasons, that the King of France conceived afterwards great indignation at the surrender of **Limerick**; because it frustrated his mighty expectations (pp. 775–6).  
[*...*]  
 'Tis therefore that **Limerick** must make provisos for the nation in general. She is encouraged thereunto by the knowledge of her own strength: which is so great, that she can force the enemy to raise his siege. By which the war is prolonged, at least to the end of the next campaign. At the beginning thereof, the Confederate Princes will be compelled, without dispute, to strike a peace with France, as not being able to hold out any longer thro' the want of England's army and money, which must be employed in the Irish war. Hence immediately follows the dethronement of Orange, and the restoration of the King. General Ginkell understood very well this affair by his granting better conditions to the garrison of **Limerick** than are given to any besieged town whatsoever: tho' he gave not so good, as might have been extorted from him, which was occasioned by the too easy compliance of the Irish Commissioners, who were appointed to treat with him (pp. 789–90).  
[*...*]  
 The King of France made a false step in the politics, by letting the Irish war to fall: because that war was the best medium in the world for destroying soon the Confederacy abroad, by reason that the Confederate Princes could not prolong the foreign war without the army and money of England, which were employed in the war of Ireland’ (p. 828).
  
 

It ought to be added that **Sir John Gilbert** issued a poor edition of A Light to the Blind, published under the title of A Jacobite Narrative of the War in Ireland (1689–91); it can also be read in the Tenth Report, Appendix, part v, of the Historical Manuscripts Commission (pp. 107–204).


Colonel Charles O'Kelly (1621–95) in his Macariae Excidium, or The Destruction of Cyprus, writes from the point of view of one who fought on the side of King James. He had fought for the Stuarts from the days of Cromwell, and he finally sheathed his sword in 1691. He was an old 



---

p.xxiv



man when he served under Sarsfield, but he was defeated by Captain Thomas Lloyd. After the conclusion of the war he retired to his residence at Aughrane, now Castle Kelly, where he spent his remaining days in writing his history of the Irish wars. It affects to be a history of the destruction of Cyprus (Ireland), written originally in Syriac by Philotas Phylocypres (O'Kelly). The author consistently substitutes appellations for the men and places of the time, as, for example: Cyprus for Ireland, Cilicia for England, Pamphilia for Scotland, Syria for France, and Egypt for Spain. Thus William becomes Theodore, Louis is Antiochus, James is Amasis, Avaux is Demetrius, Tyrconnel is Coridon, Sarsfield is Lysander, Lauzun, significantly enough, is Asimo. The fifty-fourth paragraph will give a fair idea of Colonel O'Kelly's book.
  

*Non alia,' it runs, 'unquam urbs, licet omnium aetatum annales, populorumque omnium res gestas evolveris, aut acriori impetu oppugnata, aut pertinacioribus animis defensa, quam Paphus ea tempestate fuit. Nihil inausum, nihil intentatum reliquit Theodorus quod aut bellicarum artium peritia, aut experientia magni Ducis, aut veteranarum cohortium robur exequi posset, ut oppidum in suam potestatem redigeret: nec segniori conatu Cyprii quidquid spectata in adversis virtus et infracta malis constantia, aut agere poterat, aut pati, fortiter et impigre efficiebant, tolerabantque, quo locum tanto tamque acri nisu petitum non minori pervicacia defensarent: continui hinc vallo assultantium, inde portis erumpentium congressus, tam ex obsidentium quam ex praesidiariorum numero, ingentem fortissimorum virorum multitudinem absumebant: illos spes et partae ante victoriae in ipsa pericula praecipites agebant: hos imminens patriae excidium, religionis ardor, et in regem inconcussa fides ad ultima audendum succendebant. Undevicesima die Theodorus (qui ne pedem latum sine sanguine et vulneribus progredi poterat) strata muri parte per patentes ruinas impetum fecit: ubi ad tres integras horas dubio utrimque marte pugnatum est: et quanquam hostium alii ipsam urbem perrupissent, obstinatis tamen propugnatorum viribus exturbabantur, et in castra non 



---

p.xxv



sine magna militum jactura redigebantur. Postridie Theodorus cum aleam universae rei in medium conjicere, et omnibus copiis oppidum denuo aggredi statuisset, quanquam Ducem se perterritis offerret, et discriminum societatem non respueret, haud tamen evicit aut persuadere valuit, ut aut caeptis insisterent, aut expertam virtutem novis conatibus irritarent. Unde accensus ira, dolore furens, et ignominiae impatiens degenerem suorum pavorem detestatus castra deserit, et cursu, quam potuit contentissimo Paleam pergit, ibique conscensa navi in Ciliciam revertitur. Interea exercitus, desperato rerum eventu, tumultuaria profectione, relicta Papho, in interiora regreditur.’’*


*Never was a Town better attacked,' runs the old translation of this passage, 'and better defended, than the city of Paphos *(Limerick)*. Theodore *(William)* left nothing unattempted that the Art of War, the Skill of a great Captain, and the Valor of veteran Soldiers, could put in Execution to gain the place; and the Cyprians *(Irish)* omitted Nothing that Courage and Constancy could practise to defend it. The continual Assaults of the One, and frequent Sallys of the Other, consuming a great many brave Men, both of the Army and Garrison. On the 19th Day, Theodore (after fighting for every Inch of Ground he gained), having made a large Breach in the Wall, gave a general Assault, which lasted for three Hours; and tho' his Men mounted the Breach, and some entered the Town, they were gallantly repulsed, and forced to retire, with considerable Loss. Theodore, resolving to renew the Assault next Day, could not persuade his Men to advance, tho' he offered to lead them in Person; whereupon, all in a Rage, he left the Camp, and never stopt till he came to Palaea *(Waterford)*, where he took Shipping for Cilicia; his Army in the mean Time retiring, by Night, from Paphos.’’*

Macariae Excidium




The internal evidence points to the conclusion that the Latin text is the original of O'Kelly's narrative. Unlike Plunket, he is not at all friendly to Tyrconnel, and is a warm partisan of St. Ruth. Making allowance for these prejudices, Macariae Excidium is a very able record.


**William King**, the greatest archbishop of **Dublin**; wrote The State of the Protestants of Ireland under the late 



---

p.xxvi



King James's Government: in which their Carriage towards him is justified, and the absolute Necessity of their endeavouring to be freed from his Government, and of submitting to their present Majesties is demonstrated. The title of this book indicates precisely its object: it is an apologia for the Revolution. With it may be compared Charles Leslie's Answer to a Book intituled The State of the Protestants in Ireland. It is no injustice, however, to Leslie to say that **King**'s book is incomparably superior. Moreover, the facts that King gives are correct, though now and then he uses rhetoric. His references to contemporary events are faithful, though his inferences are occasionally open to comment. One case may be given. King is contrasting the state of Ireland before and after the Revolution, and here one might expect that his eloquence and indignation might overcome his regard for the truth. As a matter of fact they do not. Such manuscripts as Add. 21138, Add. 17406 and 2902 (British Museum) provide chapter and verse for every statement **King** makes. His correspondence in seventeen volumes is preserved in Trinity College, **Dublin**, and it covers the period from 1696 to 1727. This correspondence the present editor has read and re-read, and every fresh reading confirms his respect for the accuracy and insight of King. Its evidential value stands high, for the letters he wrote to his numerous correspondents, gentle and simple, were written while the events were fresh. A man who has had good opportunities of learning the truth about public affairs, and has been in the habit of recording things as they happen, as King did, is an invaluable witness. It is interesting to observe the change in his attitude to public affairs. He was of Scots descent, and at first regarded events in Ireland from an external point of view, but as he grew older he became warmly interested in the stirring events of his day. The majority of his critics have judged 



---

p.xxvii



King by his State of the Protestants of Ireland: they have not judged him by his singularly able and statesmanlike letters. The perusal of a letter such as that of January 6, 1697 (197, f. 151, British Museum) is enough to convince the student that he is dealing with an authority of the highest value and impartiality.


Among the published material it is difficult to find detailed accounts of the Jacobite War. Works like Dumont de Bostaquet's Mémoires inédits, **Berwick** Mémoires, Schomberg's Diary, the Journal of Mullenaux, and Parker's Memoirs, give on the whole scanty detail. The few unpublished records resemble the published in this matter. Thus Ensign Cramond's diary (Add. 29878) gives no information of importance. It has no title, but begins ‘The Route of Colonel Wauchope's Regiment beginning the 15 of October, 1688.’ Cramond served in the Low Countries and in Ireland from 1688 to 1691, but was clearly a man of action and nothing else. His diary follows immediately after the details of the number of miles marched each day; and at the end of the slim volume there are money accounts. There are thirty-seven written leaves in it, besides almost the same number that are blank. Bonnivert's Journal (1033, British Museum) is somewhat more satisfactory, though it is also deficient in detail. It occupies only twelve written leaves, besides one leaf of drawings and two of medical receipts. It has no title, but begins ‘I came out of London the 6 of June, 1690.’ On f. 5, according to Bonnivert, the Enniskilleners ‘are but middle sized men, but they are nevertheless brave fellows. I have seen 'em like masty dogs run against bullets.’ F. 8 points out that at the battle of the **Boyne** the enemy ‘drew up upon a line only, and our army was upon three.’ The account of the battle is wretched: there are no particulars of the movements of the troops. Nevertheless Bonnivert finds space to record the fact that his 



---

p.xxviii



side wore green in their hats. F. 10 describes Sarsfield's exploit at **Ballyneety** and places the success of the surprise upon the ‘ill management of Captain Poultney, who having had the conduct of eight pieces of artillery and several other provisions unadvisedly ordered his detachment to unbridle and turn the horses to grass.’ Both these diaries were obviously kept in the pockets of their owners. Cramond's diary measures 6 1/3 x 3 inches, and Bonnivert's 5 7/8 x 3 1/2 inches.


### The Journal of John Stevens


It is a satisfaction to turn from the meagre information of these two diaries to the comparatively ample account of John Stevens. His journal measures 8 x 4 3/4; inches and covers no less than 163 pages. The copy now edited lies in the British Museum (Add. 36296). It was bought at the sale of the library of Sir F. A. F. Constable, of Tixall, in 1899. It belonged previously to John Warburton, Somerset Herald, being lot 326 in the sale-catalogue of his library in 1759. The Biographies of English Catholics in the Eighteenth Century, by the Rev. John Kirk, D.D., edited by J. H. Pollen, S.J., and E. Burton, D.D., affords some additional information on the history of the manuscript from 1759 to 1899. Dr. Kirk was born in 1760 and died in 1851. He finished his work, which was a part of his projected continuation of Dodd's Church History, in 1841, but it was not printed till 1909. The editors conjecture that the majority of the Lives were written before 1820. In a short notice of Stevens on p. 219, the writer refers to the Journal:
  


‘In the library of Burton Constable, I remember to have seen a MS. (M. 266) with this title: A Journal of my Travels since the Revolution. Containing a brief account of all the War in Ireland impartially related, and what 



---

p.xxix



I was an eye-witness to and deliver upon my own knowledge distinguished from what I received from others.’


He also mentions the printed slip which is pasted on the title-page of the British Museum copy. This newspaper cutting states that:
  


‘The Author of the above was Mr. John Stevens, a Roman Catholic, and before and at the Revolution, a Collector of the Excise in Wales: after which he followed the Fortunes of his Master, and became a Captain in the Army. He is well known to the learned World by his valuable Continuation of Dugdale's Monasticon, and numerous translations chiefly from the Spanish and Portuguese.—S. P.’


At the end of the notice of Cuthbert Constable, formerly Tunstall, in Dr. Kirk's volume, there is a short list of manuscripts at Burton Constable, in which the Journal is included (p. 54). But as Cuthbert Constable died in 1746, and as the Journal was in the Warburton sale in 1759, it must have been after his time that the Journal was acquired. The purchase at the Tixall sale in 1899 is intelligible, for Sir Thomas Hugh Clifford Constable, originally Clifford, succeeded both to Tixall and Burton Constable. It is interesting to note that the printed slip, pasted on the title page of Add. 36296 has evidently been taken from a sale-catalogue; lots 1050 to 1054 are catalogued on the other side. The initials S. P. are those of Samuel Parker, bookseller and auctioneer. Though he sold the Warburton Library, this extract has not been taken from that catalogue, 1759. In the Warburton Catalogue, lots 318 to 327 are all Stevens's manuscripts. Lot 325 is A Diary or Account of my Life (Capt. Stevens's) and Actions, written by himself, 8vo. Lot 326 is A Journal of my Travels since the Revolution —it is Add. 36296; while lot 327 is A Journal of all my Travels since I left London, to follow our most merciful, most pious and 



---

p.xxx



most gracious Sovereign James II by the Grace of God, etc— A Journal of my Voyage from London to Lisbon, etc., 4to. In the Phillipps sale, April 28, 1911, under lot 959 (three volumes folio) several of the sub-titles, e. g. The Miser Jilted, a novel, agree with those mentioned in lot 319 of the Warburton catalogue.


A version of an introduction to the Journal will be found in Lansdowne MSS. 828, ff. 10, 10b, 11, beginning, ‘I had been above a year in Wales, upon business, at the time when the never to be forgotten catastrophe, commonly called the Revolution, happened   
[*...*]  
’ and ending, ‘Perceiving I could expect no further security, I resolved to withdraw, sent for my horses over night, and left Poole the next morning early, being Monday.’ On f. 10b the writer, in stating the scope of his work, refers to himself as ‘having in order to this constantly kept a journal, and often broke my rest, after much fatigue, rather than interrupt the series of my observations.’ Though in general these three pages differ from Add. 36296 there are still obvious points of similarity. There is another version not merely of the introduction but of a large part of the Journal, and this was used by Ranke ( History of England principally in the Seventeenth Century, vi, pp. 128–43). Ranke married an Irishwoman, a daughter of John Cosby Graves of **Dublin**, and in 1865 he went to Cheltenham in order to pay a visit to his brother-in-law, John Graves. Bishop Graves of **Limerick** was another brother-in-law. The well-known antiquary. Sir Thomas Phillipps, lived in the neighbourhood and permitted Ranke to use his famous collection (cf. ‘Reminiscences of Leopold von Ranke’, by his son, General Friduhelm von Ranke, in Temple Bar, March 1906). Sir Thomas evidently on this visit gave the historian access to his copy of the Journal of Stevens. This copy and the British Museum one differ in some particulars, and the differences can be clearly 



---

p.xxxi



seen by comparing two sections dealing with the same matter:
  

*The Phillipps Copy.* *(Column 1)*
  

The most sacred Majesty having, through the infinite goodness and providence of Almighty God, made his escape from Rochester, out of the hands of his ever rebellious subjects, and most inhuman son-in-law, nephew, and enemy, William, Prince of Orange, and the most happy news of his safe arrival and kingly reception in France, being spread all over England, the small remainder of his loyal subjects, those few thousands, who had not bowed their knees to Baal, either in their person, or at least in their wishes, hastened to follow him. Some, through the great incumbrance of their families, others through want, having been plundered of all their substance, others for fear of being burdensome to him in his exile, and lastly, some in hopes of being more serviceable to him when providence should ordain his return, remained in their more than egyptian slavery, yet a very great number gathering together the small remainder of their shipwreck, and laying aside all worldly considerations, having only before their eyes their duty and love to their sovereign, resolved to follow him through all hazards, in hopes of being
  

*Add. 36296. *(Column 2)**
  

His most sacred Majesty having, through the infinite goodness and providence of Almighty God, made his escape from Rochester, [*gap: extent: four lines*]and the most happy news of his safe arrival, and kingly reception in France, being spread all over England, the small remainder of his loyal subjects, (those few thousands, who had not bowed their knees to Baal) either in their persons, or at least in their wishes hasted to follow him. Some through the great incumbrance of their families, others through want, having been plundered of all their substance, others for fear of being burdensome to him in his exile, and lastly some in hopes of being more serviceable to him, when Providence should ordain his return, remained in their more than Egyptian slavery. Yet a very considerable number gathering together the small remainder of their shipwreck, and laying aside all worldly considerations, having only before their eyes their duty and love to their sovereign, resolved to follow him through all hazards, in hopes of being 



---

p.xxxii


*(Column 1)*
  

instrumental in regaining his just right. I shall ever esteem it the most glorious action of all my life, that I made myself one of this number, and cannot but be proud, that in all the hardships and misfortunes which attended this my tedious exile, I have never been dismayed, or given way to despair, but relied always on the justice of our cause, and all our miseries have been easy to me, in consideration of the happiness of my return home.
  

But to come to the intended matter, to wit, my transactions after his Majesty's departure, it is first to be observed, that though immediately resolved to follow, yet through the difficulty of getting passes, and many other impediments, I could not set out till Friday, January of 1688. Yet, before I proceed, I cannot but look back as far as the original of all my country's and my own misfortunes, to wit, the time of the invasion, and, by way of introduction, make some remarks of what happened to me from that time till I left England, in short, as things have since occurred to me upon penning this part in haste. When the spirit of witchcraft or rebellion, which the scripture tells us are alike, had well possessed itself, and as it were fixed its abode in the hearts
  

*(Column 2)*
  

instrumental in regaining his just rights. I shall ever esteem it the most glorious action of my life that I made myself one of this number, and cannot but be proud that in all the hardships and misfortunes, which have attended this my tedious exile, I have never been dismayed, or given way to despair: but relied always on the justice of our cause, and all miseries have been easy to me in consideration of the happiness of my return home. To come closer to the matter, to wit my transactions after his Majesty's departure, it is to be observed, that though I immediately resolved to follow, yet through the difficulty of getting passes, and many other impediments, I could not set forward till Friday, January the 11th, 1688/9. Yet before I proceed, I cannot but look back as far as the original of all this country's and my own misfortunes, to wit, the time of the invasion. And by way of introduction make some remarks of what happened to me from that time, till I left England, in short as things have occurred to me upon penning this paper in haste. When the spirit of witchcraft, or rebellion (which the Scripture tells us are alike) had well possessed itself, and as it were fixed its abode in the hearts of most of his Majesty's dissembling 



---

p.xxxiii


*(Column 1)*
  

of most of his Majesty's dissembling enthusiastic subjects, through the mediation of their pharisaical teachers at the time when men began to lament the danger of losing their religion, who were never known to be possessed of or pretend to any, all this time was I employed in Wales, receiving of some of his Majesty's revenue there, being in a public employment, and keeping much company, I could not but easily discern how prone all were to mutter about breach of laws, and invading of religion, and it was plainly to discern, that many who said well thought very evil. This I found by long experience, yet the fear of punishment kept their tongues as well as hands within the limits of the law.
  

*(Column 2)*
  

enthusiastic subjects, through the mediation of their Pharisaical teachers, at the time when men began to lament the danger of losing their religion, who were never known to be possessed of or pretend to any, at this time was I employed in Wales in receiving his Majesty's revenue of excise there. Being in a public employment and keeping much company, I could not but easily discern how prone all were to mutter about breach of laws and invading of religion, and it was plainly to be discerned, that many who said Well Well, thought very evil. This I found by long experience, yet the fear of punishment kept their tongues as well as hands within the limits of the law.


It would not appear that the two versions end at the same place. Ranke (vi. 143) seems to indicate that his version stops at July 30, 1690, whereas Add. 36296 continues to July 12, 1691. The British Museum manuscript appears to be an earlier version than that quoted by Ranke. The evidence, such as it is, seems to point to this conclusion. Reference, however, should be made to the erasures in Add. 36296. On f. 80b, nine lines, which are not in Ranke, have been crossed out, and these lines are clearly utilized on ff. 81b, 82 of the manuscript. This, though by no means conclusive, would, considering the similarity of the two versions, argue in favour of the priority of Add. 36296. It is true that there has been an alteration in the title of Add. 36296, which would go against the view suggested. In this case, on the other hand, it is evident that the alteration 



---

p.xxxiv



has not been made at the first time of writing, but at a later date, and it may therefore have been subsequent to the making of the second version. Ranke (vi. 143) appears to be summing up the rest of his manuscript when he writes that ‘The author goes on to describe the disorders during the retreat up to the 30th of July, and inserts a few more details as to the battle itself. The manuscript ends abruptly in the middle of a sentence.’ As he gives the beginning of it on p. 128 there is no reason otherwise for his mentioning the 30th of July. Though his head-lines on page 128 run ‘Extracts from the Diary of a Jacobite relating to the War in Ireland, 1689 and 1690’, not much importance is to be attached to them, though they might perhaps be taken as a kind of negative evidence.


The Journal (Add. 36296) cannot have been kept from day to day, but has been written up from notes that have been so kept. Clearly Stevens kept such a day-to-day journal, and he must have based the present work very closely upon it. But this work, viz. Add. 36296, cannot be that day-to-day journal, for it has certainly been written up afterwards. In the first place the appearance and the form of the work both afford proof of that. The Journal is divided into an introduction and two parts, a system of division which suggests that the writer had the end in sight. Apart, however, from questions of appearance and form, there are various passages where Stevens obviously generalizes and anticipates in a way which he could not have done had he been writing from day to day. A short list of such passages places this beyond doubt: the italics, of course, are the editor's:
  


f. 14b. ‘I understood not this word *then,* but having *afterwards* found the benefit of it, think it not amiss in this place, to give an account of it, which is this.’
  

f. 23. ‘the *following* part of my exile will show I have not wanted my part in most sort of sufferings.’ 



---

p.xxxv



f. 40a. ‘Mr. Lazenby, *afterwards* a Captain.’
  


f. 48b. ‘Of these several gave us at least as good a proof of their loyalty  
[*...*]  
 when to punish theirs and our sins it pleased God to suffer his Majesty's forces to be defeated, and us to be reduced to the miseries I shall *hereafter* mention.’
  


f. 65b. Note his *general* remarks on the stay in **Dublin**.
  


f. 81b. Note the reference to the *first* siege of **Limerick**, with its implication that there had been a second.
  


f. 84a. ‘I wonder I outlived the miseries of this dismal day, but that I have *since* found I was reserved to suffer many more and if possible greater.’
  


f. 89a. See the entry under July 16, 1690, and particularly f. 90b, ‘wherewith we *afterwards* held out so long, and *at*  purchased so good conditions.’ Note on the same folio his reasons for giving a general description of **Limerick**. ‘**Limerick** being the principal city at this time and *long after* that held out for the king, and consequently there being *often* occasion and that on account of *many* memorable occurrences to speak of it, I will endeavour to give a true and exact description of it.’
  


f. 97a. ‘This day also the French forces departed for **Galway** to the great satisfaction not only of the inhabitants, but of all the garrison that remained in town. They remained *some* time at **Galway** *till* ships came to carry them into France, thinking it impossible **Limerick** should hold out a siege, offering to lay wagers it would be taken in three days.’
  


f. 114b. ‘These extremities endured as they were with courage and resolution are sufficient with any reasonable persons to clear the reputation of the Irish from the malicious imputations of their enemies; and yet this is not all that can be said for them. We have already seen them defend an almost defenceless town against 



---

p.xxxvi



a victorious disciplined army, and we *shall* see them the *following* summer under all these hardships fight a battle with the utmost bravery.’
  


f. 115b. ‘But I must not here *anticipate* upon what happened so long *after.* The battle of **Aughrim** which is that I have made the last observation upon *will* be mentioned in its own place and with more particulars. Let us now return to our hard winter in **Limerick**.’


F. 50b illustrates the character of the work. ‘As I do not pretend to write a history or give an account’, Stevens points out, ‘of the particular transactions of the times, but only as far as I was concerned, or where I was present myself, so having spent much time in speaking of my private affairs, it will not be amiss to set down some few observations of the general state of affairs, during this my vacation from business though not from sufferings.’ The reference on f. 118b to f. 92 is also illustrative: ‘This town and the road to it I shall not need to give any account of in this place, having said as much of it as is requisite before, when we passed the same way the first time towards **Athlone**, as is to be seen in this *book*, i. 92.’


The Journal, then, of Stevens was not kept from day to day. It thus lacks order; dates are dropped into it or are left out of it as the purpose of the writer is best served. On the whole, though the Journal is barren of some personal details one wants to know, it is a very human document indeed. It is plain that a scholar like the author did not relish his life as a soldier. He is conscious of the mistakes of his generals, of the loss of promotion, of the lack of pay, of the blisters on his feet, and of the hunger in his stomach. Stevens sees and he makes the reader see. For the truth, the sincerity, and the reality of his account of the Jacobite war much grumbling may be forgiven him. In interest his Journal is comparable to Mercer's Journal of the Waterloo 



---

p.xxxvii



Campaign. Both Mercer and Stevens were scholars and lovers of books. No doubt Mercer is an optimist, but he was on the winning side. Stevens is a pessimist, but was he not on the losing side? He does not take mud, rain, toil, hunger, the peril of death, all as part of the day's work. There are curious omissions in the Journal. For example, there is no reference to Sarsfield's destruction of William's siege-train at **Ballyneety**, a feat that must have raised the spirits of the besieged to no common degree. The battles of the **Boyne** and of **Aughrim**, and the sieges of **Limerick**, arrest the attention of all readers, and their tale has been told over and over again. But what may be called the unrecorded marches and skirmishes of the campaign possess genuine interest; and Stevens describes them with great vividness. He makes us see the rough material out of which the Irish army was formed; for the men he has a hearty admiration, while for the officers, like most observers, he has nothing but contempt. An extract taken straight from his day-to-day Journal is simple, but he forgets this simplicity when he moralizes over the battle-field the next day. Then he makes deliberate—and, it may be added, unhappy—attempts at fine writing. He indulges in apostrophes to the reader, to posterity, and to his native country. He is, however, simple and direct when he has a line of conduct to describe or an actual tale of fighting to tell. Part of the value of the Journal lies in the insight it gives into the fortunes and sufferings of the Jacobites. Like the Macariae Excidium of Colonel O'Kelly, it makes the men who fought for the land of Ireland appear more human than they had been to the reader of other records. For Stevens renders it abundantly clear that the Irishmen of 1688—and it may be added, the Irishmen of 1912—cared for two things, and two things only, and they are land and religion. The entries of the writer are most damaging to James, for he points out the incapacity of his generals, the immorality of 



---

p.xxxviii



the officers, and the prevalent thieving and drunkenness. When King made these charges he was considered partial, but a fervent Jacobite also makes them. He amply confirms **King**'s view of the general corruption of the country. The Journal is interesting, because it brings back living pictures, as seen through living human eyes, of the battles of two centuries ago—battles, insignificant in themselves, which changed the current of the world's history. Thus the effects of the battle of the **Boyne** are deeply graven on the history of the world. For first it decided the fate of the lesser kingdom, then that of the greater, and finally that of Europe. On Irish soil William was fighting not merely for the  of England, but also for his fatherland as well as for his allies. Above all, he was fighting for the principle of liberty in the life of nations, the principle that the Grand Alliance had called into vigorous existence. On Irish soil James was in reality fighting, not for his own cause, but for that of his master, the King of France. William and James did not, as men have often said, represent the principles of Protestantism and Roman Catholicism; they rather represented the eternal struggle between liberty and tyranny. The **Boyne** proved to the despotic power of Louis what **Salamis** was to Xerxes and **Leipzig** to Napoleon. It would have been well for the French monarch if the results of that skirmish had not been half hidden from his view by the victories of Beachy Head, Fleurus, and Staffarda. The Holy Roman Emperor and the Pope both rejoiced to hear the good news from Ireland, for Gallicanism had at last received a severe blow. While state religion had thus been checked, liberty had been allowed to develop more freely than before, and both these priceless blessings are the results of that memorable July day.




---

p.xxxix


### The Condition of the Army


Upon the commissariat of the army Stevens has somewhat to say, and the method of supplying clothing deserves attention. The pay of the soldier consisted of (i) subsistence money, the regulated rates being, for a trooper, two shillings out of his total of two and sixpence; for a dragoon, one and twopence out of one and sixpence; for a foot-soldier, sixpence out of eightpence, (ii) the gross off-reckonings, which were the difference between the whole pay and the subsistence, and (iii) the net off-reckonings, which were the balance of the gross off-reckonings after all lawful deductions. These net off-reckonings formed the clothing fund, and belonged to the colonel for that purpose. Out of the off-reckonings was deducted one shilling in the pound on the whole pay, besides one day's pay per annum, for Chelsea Hospital and other purposes. Take the case of a private foot-soldier:—
  


£ s. d.
  


Total pay at 8d. per day . . .12 3 4
  

Deduct subsistence at 6d. . . .9 2 6
  
 
Gross off-reckonings. . .3 0 10
  
 

s. d.
  


Deduct 1s per £ on annual pay. . .1 2 2
  
 
One day's pay for Chelsea. . .0 8
  
 
0 12 10
  
 

Net off-reckonings. . .2 8 0
  



These net off-reckonings belonged to the colonel, and out of them he was obliged to clothe his regiment. This amount was not excessive for each private, for in 1678 two pounds thirteen shillings was reckoned the proper cost of the annual clothing of an infantry soldier. Of course, allowance must be made for the saving effected by regimental contracts. Moreover, some clothing was not required because of casualties and non-effective men. When the regiment was on active service the colonel could not employ a contractor, 



---

p.xl



and in this case the Commissariat procured the clothing and deducted the price from the pay of the troops.


It is clear that the margin of profit to a just colonel was reduced to a vanishing point, yet it is common to find that the colonel received from £200 to £600 a year from the net off-reckonings. This money was of course stolen from the private soldier.[7](javascript:footNote('E680002-001/note007.html')) Not only was he thus defrauded, but he also suffered in other ways. Even the subsistence money of sixpence a day was tampered with. In April 1686 Clarendon wrote to Rochester: ‘And some (Irish) colonels told me they were offered £600 by tradesmen to have the clothing of their regiments, which they thought a very unconscionable thing, to get so much money into their own pockets out of the poor soldiers' bellies. I confess I thought it very hard that the King should allow 6d. a day, and the poor soldier have but 2d. of it.’ It was easy to swindle the soldier, for the colonel appointed the regimental agents, through whose hands all the money passed. These agents bribed the commanding officer, sometimes offering him so much as £600 for the year. Sometimes instead of a lump sum the colonel received a percentage on the contract. Sometimes the amount of the contract was increased and the colonel received the increase. These abuses were checked by the plan adopted by the colonel of the Irish Foot-Guards. He allowed each captain to arrange for his company, but this excellent method was not carried out by his successor. On the 10th of April, 1686, Clarendon wrote to Rochester:
  


‘Speaking of the clothing of the army puts me in mind to tell you of a particular. My lord Arran (who loved to get money) left the clothing of the regiment of Guards to each particular captain to take care of his own company, which got him the perfect love of the officers. My Lord of Ossory has ordered it otherwise, and sent orders to the Receiver-General (at least it is come in his name) to pay the deductions no more to the captains, but that he will appoint 



---

p.xli



one to take care of the clothing of the regiment. This makes a loud noise among the officers, and I doubt it will not be represented in England to his advantage.’


Schomberg complained repeatedly in his dispatches of the neglect and cheating of the men by their officers, of the bad state of the men's clothing, and of the astonishing avarice of the colonels who thought of nothing beyond making an income out of their regiments. He characterized the officers of the artillery as ignorant, lazy, and timid.[8](javascript:footNote('E680002-001/note008.html')) On the officers in general he made remarks in his letters to William on August 27 and September 20, 1689. The latter of these pointed out that ‘il y a bien encore d'autres officiers que je voudrais qu'ils fussent en Angleterre. Je n'ai jamais vu de plus méchants et de plus interessés; tout le soin des colonels n'est que de vivre de leurs regiments, sans aucune autre application.’ ‘If the Irish colonels’, he writes, ‘were as capable and as eager for war as they are for sending forage parties to plunder the country  
[*...*]  
 our affairs would stand better. The incapacity of the officers is indeed great, but their carelessness and laziness are still greater.’ The ignorant and indolent officers delayed the erection of huts till it was too late to procure dry timber for the walls or dry straw for the roofs.[9](javascript:footNote('E680002-001/note009.html')) On December 26, Schomberg wrote: ‘I never was in an army where are so many new and lazy officers. If all were broke who deserved it on this account, there would be few left.’ [10](javascript:footNote('E680002-001/note010.html')) If Schomberg had grounds for complaining of the character of his officers, Rosen and Lauzun had equally good grounds for complaining of the character of theirs. Mr. Osborne's paper of March 9 and 10, 1689, states ‘that for the Irish army, though their horses were good, yet their riders were but contemptible fellows, many of 
 


---

p.xlii



them having been lately cowherds, &c.’ Ireland's Lamentation (p. 31) points out that ‘those of their present army, both officers and soldiers, are mostly the very scum of the country, cow-boys, and such trash, as tremble at the firing of a musket, much more will at many.’ Stevens speaks in cordial terms of the usefulness of the private, ‘but the officers were only those from the plough, from the following of cows, from digging potatoes, and such like exercises. Because they had a few men to follow them, or bore the name of a good family, they were put into commissions, without experience, without conduct, without authority, and without even the sense of honour.’ The estimate of Avaux coincides with that of Stevens. The Irish ‘sont très bien faits: mais il ne sont ny disciplinez ny armez, et de surplus sont de grands voleurs.’ Upon the cavalry Avaux bestows some praise, but none upon the infantry. In a letter of September 20, 1689, to Louvois, he wrote: ‘La moitié des troupes n'est point habillée, et n'a ny ceinturons ny bandoulieres; la pluspart de mousquets des regimens qui viennent du nord et des autres provinces, sont hors d'estat de servir.  
[*...*]  
 On a beaucoup plus de confience en la cavalerie, dont la plus grande partie est assez bonne; on ne peut voir de meilleur regiment que celuy de Tirconnel et celuy de Galmoy; celuy de Parker, quoyque nouvellement levé, est bon aussi. Le Colonel Salsfield a amené d'assez bonne cavalerie, et il y a quelques regimens de dragons en fort bon estat.’


In another letter of April 16/6, 1689, to Louvois he declared that ‘la pluspart de ces regimens sont levez par des gentils-hommes, qui n'ont jamais esté à l'armée, que ce sont des tailleurs, des bouchers, des cordonniers, qui ont formé les compagnies qui les entretiennent à leurs despens, et en les capitaines.’ Macaulay doubtless had this letter before him when he wrote that ‘Their colonels were generally men of good family, but men who had never seen service. Their captains were butchers, tailors, shoemakers.’ It is therefore necessary 



---

p.xliii



to point out that the statement of Avaux cannot be generalized in the easy way that Macaulay generalizes. Five of the captains were peers, and many of the other officers, especially in the cavalry regiments, were the sons of peers. Many, too, were the sons of baronets, or heirs of the oldest families. Names like Butler, Burke, Dillon, Fitzgerald, French, Macarthy, Macmahon, Magennis, Nagle, Nugent, O'Brien, O'Byrne, O'Donovan, O'Ferrall, O'More or Moore, O'Neill, O'Rourke, and Plunket, demonstrate the truth of this fact. Regarding the type of officer there are many references in Avaux, e.g. Avaux to Louvois, May 12, June 26, July 10; Avaux to Louis, August 30; Avaux to Louvois, September 20; Avaux to Louis, October 21. The letter of September 20 pointed out that ‘nous avons peu d'officiers generaux sur qui l'on puisse compter; les officiers subalternes sont bien plus mauvais, et à la reserve d'un tres petit nombre, il n'y en a point qui ayt soin des soldats, des armes, de la discipline; et j'aprehende beaucoup que les soldats ne se decouragent lorsqu'ils ne verront pas des officiers à leur teste qui les menent hardiment.’ The letter of October 21 discloses an appalling lack of discipline: 

‘II seroit bon aussy que le Roy voulust bien prendre soin de faire executer ce qu'il a resolu, et qu'il fist chatier les officiers qui manquent à leur devoir. II n'y a ny ordre, ny discipline dans l'armée: les soldats mettent l'espée à la main contre leurs superieurs; les officiers et les cavaliers qui ont esté à la garde avancée, lorsque nous etions à une lieüe et demy du camp de M. de Schomberg, ont esté trouvez presque toutes les nuits couchez sur de la paille et endormis, leurs chevaux dessellez et debridez; on ne manquoit pas d'en faire des plaintes au Roy d'Angleterre qui disoit que cela estoit fort mal, et il n'en a jamais esté autre chose. Les capitaines sont d'une tres grande negligence, et souffrent que leurs soldats gastent et brisent leurs mousquets; de sorte que si on n'y apporte pas plus d'ordre, nostre Maiesté auroit beau envoyer cinquante mille mousquets de France, qu'il n'y en auroit pas dix mille en estat de servir dans ces troupes cy, au bout de six mois.’




---

p.xliv


When Macaulay therefore censures the bad clothing of the troops as due to the defective commissariat he is in error: it was really due mainly to the avarice of the colonels and slightly to the neglect of the captains.


It is worthy of notice that the colonel and lieutenant-colonel had troops in the cavalry and companies in the infantry, and they drew pay as captains of these in addition to their pay as colonels and lieutenant-colonels. In foot regiments the major had always a company, but not in horse or dragoon regiments. The colonel, lieutenant-colonel, and major with the adjutant, quarter-master, and surgeon constituted the regimental staff. The other officers were divided into three grades, captain, lieutenant, and ensign in the infantry or cornet in the cavalry. Promotion as a rule went by selection on the colonel's recommendation, not by seniority or merit. From the autobiography of James II it appears that he bought the Earl of Macclesfield's first troop of Guards for the Duke of Monmouth in 1674.[11](javascript:footNote('E680002-001/note011.html')) On June 22, 1686, Clarendon wrote to Sunderland:
  


‘My lord Tyrconnel told me, tho' I had nothing of it from your Lordship (which I should have been very glad to have known the King's mind in), that the King gave Col. Salkeld the command of the Horse Grenadiers as a recompense of his former services, in lieu of his employment of lieutenant-colonel, and in order to his disposing of it to his advantage. Though I know it is against his Majesty's resolution of not suffering commands in the army to be sold, yet, considering what has been told me, and that there can be no harm in making the proposition, I am desired by my Lord Ikerrin, that the King may be acquainted, that his Lordship and Col. Salkeld are agreed for that command of the Grenadiers; but then my Lord Ikerrin hopes that the King will give him leave to surrender the company, which he now has, to a friend of his; and he desires it may be to one Lieutenant John Roth. If his Majesty approve hereof, your Lordship will be pleased to let me know it, and to send over the commissions.’



---

p.xlv



On July 22, 1686, Clarendon wrote another letter to Sunderland, ‘And now I must put your Lordship in mind of Captain Toby Caulfield, who was to have had Ridley's command; the company which he formerly had, having been given to my Lord Ikerrin, which he has sold by the King's permission lately to one Rooth.’ On December 18, 1686, he wrote to Rochester, ‘I sell no offices, I wish the officers of the army did not; then there would not be so much sharking from the poor soldier, as there is.’ The journal of John Stevens bears ample testimony that such conduct as Clarendon's was the exception, not the rule. The colonel regarded the places of the quarter-master, adjutant, and agent, as a source of pecuniary gain, for all three were appointed by him. The officers followed the corrupt example set by the colonel. They secured to him the fresh sale or gift of their places; they kept these vacant and drew the income of their holders. When a vacancy occurred the colonel concealed the fact as long as he could, and the salary of the officer still borne upon the muster-rolls went into his pocket. According to the declared accounts, Chelsea Hospital, 1680–5, the following are examples of prices paid for commissions: 




| *Commission* | £ |
| --- | --- |
| Lieutenancy in the Irish Foot-Guards, prior to 1685 | 1,100 |
| Lieutenant-Colonel's commission | 3,440 |
| Captain's commission | 1,720 to 6,000 |
| Lieutenant's commission | 600 to 1,075 |
| Cornet's commission | 2,100 |
| Ensign's commission | 400 to 610 |
| Quarter-master's commission | 1,000 |






Stevens has a detailed description of the first siege of **Limerick**, and in it one matter calls for comment. ‘I can affirm’, writes the **Duke of **Berwick****, ‘that not a single drop of rain fell for above a month before or for three weeks after’[12](javascript:footNote('E680002-001/note012.html')) the siege. This statement is flatly contradicted by Stevens. On the 29th of August he writes: ‘The night was extreme cold, dark, and rainy’ and the 3rd of September ‘was 



---

p.xlvi



appointed a general day of review for the garrison in the King's Island, but the weather proving extreme foul it was put off.’ The entry of the 29th shows in what sense he uses the word foul, for there he writes that ‘the weather began to grow foul with extreme rain’. Dumont de Bostaquet[13](javascript:footNote('E680002-001/note013.html')) and Story[14](javascript:footNote('E680002-001/note014.html')) confirm the accuracy of Stevens. Moreover, in the Clarke Correspondence (vol. ii, f. 116) occurs the significant statement: ‘I wish that the inclemency of the weather does not incommode the progress of the siege of **Limerick**.’ Though Corporal Trim was not an exact historian, there is no reason for disbelieving his recollection of the state of the weather, and he asserts, as all his readers remember, with emphasis, ‘besides, there was such a quantity of rain fell during the siege, the whole country was like a puddle.’ Williamite and Jacobite authorities, then, agree that rain fell. The question that now awaits an answer is, Why did **Berwick** state the contrary? He was so young that he gained no honour at the siege, and he was jealous of Sarsfield. The perplexing problem then occurs that a person who from the nature of the case must have known the truth does not tell it, even though it favours him. It is, however, not without parallel. When Napoleon occupied Moscow it was burnt. The Governor of Moscow, Count Rostopchin, at the time boasted that he had fired the town. Many years afterwards, when an exile from Russia, he denied that he had ordered the conflagration. Which is to be behaved, his early affirmation or his subsequent denial?


### The Brass Money


Stevens had troubles due to the foul weather, but he had other troubles due to bad money. On ff. 39b, 55b, 62b, 71a, 72a, 95a, 97a, 113b, and 117a, he refers to the many difficulties caused by the new coinage of James. It 



---

p.xlvii



is obvious from his remarks that at first the nominal and the real value of the brass money coincided, but when French silver began to circulate, depreciation ensued. To the political economist the cause is clear, for by Gresham's law bad currency tends to drive out good currency. The working of this law was recognized by **Aristophanes**,[15](javascript:footNote('E680002-001/note015.html')) by **Nicolas Oresme** in a report to Charles V of France about 1366, by **Copernicus** in a report or treatise written for Sigismund I, King of Poland, about 1526, and by Sir Thomas Gresham in the middle of the sixteenth century. It proved a most unfortunate law for James, for the depreciation of the brass currency brought untold misery upon the country. On the 25th of March, 1689, James issued a proclamation which raised the value of English gold twenty per cent., and English silver a little over eight per cent., and foreign gold and silver money in proportion. On the 18th of June by another proclamation he made two sorts of money, of brass and copper metal. Though an enormous quantity of these coins was placed in circulation, it proved insufficient for the wants of the king. At first this money was not legal tender for mortgages, bills, bonds, or obligations, debts due by record, and money left in trust, but by the proclamation of the 4th of February these exceptions were swept away. In order to supply the mint with metal Lord Melfort sent an order to Lord Mountcashel, master-general of the ordnance, to deliver to the commissioners of the mint some old brass guns, which were in the castle-yard. All collectors of revenue—in this order Stevens would take deep interest—were required to send up all the brass and copper in their respective districts. In order to encourage men to bring their plate to the mint to exchange it for this copper money, the commissioners gave sixpence in the pound in copper for all the silver and gold they received, and this silver and gold were to be taken at the current value and full weight allowed. 



---

p.xlviii



On the 28th of February the interest given on loans was six per cent., and on the 9th of June, 1690, it had advanced to ten per cent. On the 28th of March, 1690, penny pieces, half-penny pieces, and crown pieces were struck. In order to remedy the scarcity of money, to pay the army, and to enable the subject to contribute to the heavy expenses, a certain quantity of white mixed metal was ordered, by proclamation of the 21st of April, 1690, to be coined into crown pieces, to pass for five shillings each. The refusal of these pieces was to be ‘punished according to the utmost rigour of the law’, and counterfeiters of them were adjudged guilty of high treason. Moreover, all persons who should discover ‘such offender or offenders, so as he or they be brought to condign punishment’ were to be recompensed either by a reward of twenty pounds, or ‘one moiety of the estate, real and personal’ of the offender. Heavy penalties were to be imposed on any persons who presumed ‘either to import, into any part of this realm, or export into any other country whatsoever, any of the said coin or money of white mixed metal’, and rewards were offered for their discovery. As in the case of the pewter pence and halfpence, these crowns were not intended to ‘continue for any long time’, and when they were ‘decried and made null’ full value was to be given for them in gold and silver, and they were to be received in payment of all debts due to the Crown. From an abstract (Madden MSS., T.C.D., F. 4. 4) it seems the whole sum coined amounted to £1,596,799 0s. 6d. The account stands thus:




| Weight of Metal. Pound. Ounces. | coined into | *type of coin* | Value £ s. d. |
| --- | --- | --- | --- |
| 62,422 2 1/3 |  | large shillings | 245,879 17 0 |
| 110,308 15 |  | large half-crowns | 443,498 10 0 |
| 172,731 1 1/2 |  | large shillings and half-crowns | 689,378 7 0 |
| 14,080 3 |  | small sixpences | 49,042 6 6 |
| 8,914 11 3/4; |  | small shillings | 41,800 0 0 |
| 21,267 0 3/4; |  | small half-crowns | 127,200 0 0 |
| 389,724 2 1/3 |  |  | 1,596,799 0 6 |








---

p.xlix


The records of Stevens are the best proof that such proclamations as James issued invariably fail in the end. On f. 62b he remarks, ‘The army was punctually paid, and the brass money passed as current, and was of equal value with silver.’ When the French arrived they ‘were paid in silver, which was no small damage and discouragement to the rest of the army who received none but brass money’ (f. 71a) . Less than three months had sufficed to bring about this change in value. F. 95 a shows marked depreciation:
  

‘The brass money which our misfortunes had much lessened in the common esteem, the French made so contemptible it was scarce of any value, for they being always paid in silver, had no regard for the brass, but would give half-a-crown of that coin for a silver three-halfpenny piece, and forty shillings for a silver crown whereupon all things were sold accordingly as a pair of shoes for forty shillings, stockings that used to be sold for ninepence or tenpence were now worth five shillings, ale ninepence or twelvepence the quart, wine four shillings brass or sevenpence silver, brandy ten shillings brass, or tenpence silver. In short all things were at this time according to this rate (for it grew worse and worse daily), and we who were paid in brass had a miserable existence.’


On f. 62b Stevens gives prices before depreciation. Then ale was threepence a quart, whereas now it was ninepence or twelvepence, a rise of two hundred to three hundred per cent. In **Dublin**, too, ale was twelvepence a quart.[16](javascript:footNote('E680002-001/note016.html'))


### The Irish Divisions


The confusion caused by the base money was a grave trouble, but far graver was that brought about by the divisions among the Irish themselves. On this point Clarke is clear:
  


‘Besides all these contradictions his Majesty had another to struggle with, which was discord and disunion amongst his own people, which are never failing concomitants of difficult and dangerous conjunctures.  
[*...*]  
 But the King was 



---

p.l



forced to work with such tools as he had, or such as were put into his hands, which required so much dexterity to hinder their hurting one another, and by consequence himself, as to draw any use from such ill-suited and jarring instruments.’[17](javascript:footNote('E680002-001/note017.html'))


James found that two distinct, even contradictory, lines of policy were pressed upon him by his English and Irish supporters respectively. The features of the English Jacobite—Stevens was one—are well known, for they have been drawn by a succession of skilled artists, and in him is to be discerned the characteristic weakness of the House of Stuart—a greater regard for dynastic than for national interests. Stevens was so devoted to James that he could not condemn his conduct at the battle of the **Boyne**, but it is worthy of note he never mentions his king again. To him the sovereign meant everything, the state very little indeed. The Lord's anointed might commit iniquity, and still be able to rely upon the personal devotion of his liegeman. On the other hand, the features of the Irish Jacobite cannot be drawn in clear outline, for they are sometimes veiled in the shifting mists of variety, sometimes hidden in the dim shadows of uncertainty. His ancestors cared for the first James because they believed that he was descended from their own Milesian kings, but this attachment was not reciprocated, and the feeling passed away. The Celt wants to see a sovereign regularly in order to adore him. James I was never in Ireland, and the ministers he sent failed to develop the feeling of devotedness to his dynasty. Moreover, all the traditions of an Irish Jacobite were those of a man with ancestors in persistent opposition to the line of Stuart. His grandfather perhaps shared the flight of the earls to Spain. His father, it may be, had borne his part in the rebellion of 1641. He had been despoiled of some, if not all, of his family estate by Charles II. The romantic devotion of the Highlander to the name of 



---

p.li



Stuart meant absolutely nothing to him. The Jacobite poetry of Scotland and the Jacobite poetry of Ireland offer a strange contrast—the former is dynastic and personal, the latter is neither; it speaks almost exclusively of Ireland and exhibits a passionate devotion to it. The Highland loyal fervour was inconceivable to the Irish Celt, for to him the words sovereign and oppressor were convertible terms. He cared for James almost as little as a Williamite cared for James. In fact the attitude of Louis of France and of the Jacobite of Ireland to the fallen monarch was not widely different. They both used him for a definite purpose, and when this use was fulfilled they intended to pay but scant attention to the instrument they had employed. It was the intention of Louis that James should keep William busily engaged in order that he might have no leisure to thwart his Continental schemes. The Irish Jacobite aimed at recovering the land of his forefathers as the reward of his support of James. His grievances were mainly economic, and the year 1688 seemed to present a suitable opportunity for their redress. By supporting James he might secure the co-operation of France and thus pave the way to a restoration of his own ancient possessions, for the defeat of England would inevitably mean the disappearance of the colonist. He cared but little that James should recover his throne in England. In fact his interests and those of James were in direct opposition. If James were again King of England, he must pay heed to his subjects there, and this meant that he could not yield sufficient deference to the wishes of the Irish Jacobite, who wanted only the independence of his native island, with perhaps James reigning over him.


To the English Jacobite these aspirations were largely incomprehensible. Stevens, for example, regarded **Dublin** as but one stage in the return journey to London. The English Jacobite was as much an exile in **Dublin Castle** as he had been at Saint-Germain. In fact, of the two courts 



---

p.lii



he much preferred the latter, for there he met men whom he understood, and whose feelings he could divine. Moreover, he perceived that, if his master yielded to the pressure of the Irish Jacobites, his hopes of crossing the Irish Sea to England were never destined to be realized. Whatever measures were proposed the thought could never be long absent from his mind. What will be the opinion of England about them? He knew that if the Irish party despoiled the Protestants in Ireland, all his chances, as Stevens perceived, were doomed. If, on the other hand, the policy of James showed a broad-minded toleration to them, then his prospects of recall vastly improved. It is to the credit of James that he tried—for a time, at least—to hold the balance true. He drew up a proclamation assuring the colonists of their restoration to their estates and of their admission to office, but the Irish and French successfully opposed its publication. The dispatches of Tyrconnel and the Journal of John Stevens reveal the existence of the chasm that yawned between the two types of thought. The want of sympathy and the lack of understanding are plainly visible in every line they write. The prevailing Irish sentiment can be seen in Bishop Molowny's letter to Bishop Tyrrel, March 8, 1689, wherein he warns his correspondent that a grave fallacy lurks in the theory that affairs in England must be arranged as an indispensable preliminary to their own restoration:
  


‘which is the same as to say at Doomsday: For never a Catholic or other Englishman will ever think or make a step for your restoration, but leave you as you were hitherto and leave your enemies over your heads to crush you at any time they please, and cut you off root and branch as they now publicly declare; and blame themselves they have not taken away your lives along with your estates long ago!   
[*...*]  
 I dare aver, if Ireland were put upon such a foot by the King, he shall never fear any rebellion in England, especially if Scotland be faithful to him and France a friend; all which can now be well contrived and concerted.’[18](javascript:footNote('E680002-001/note018.html'))




---

p.liii


The last sentence gives an important clue to the policy pursued by the Irish Jacobites, for they followed Bishop Molowny's advice and placed implicit trust in France. Of course Avaux sympathized with the bishop, for though their aims were different, the measures they advocated were identical. Tyrconnel and the French were desirous of leading James in one path, while Melfort and the English wanted to conduct him along a road diametrically opposite. James saw, on the one hand, that he must continue to raise, in the Irish, the hopes raised by his own Lord Deputy; on the other, that if he expected to be restored to England he must protect the colonists. The two lines of policy were absolutely incompatible, but, standing hesitatingly at the parting of the ways, he tried to achieve the impossible, and effect a conciliation of divergent interests by a policy of mere oscillation. Thus at one time he urged the Protestant bishops to oppose the repeal of the Act of Settlement, at another he insisted on its speedy revocation. An extract from the journals of the proceedings in the Irish Parliament reveals the vacillating character of his policy. On the 28th of May, 1689, a motion of adjournment for a holiday was brought forward. The king asked, ‘What holiday?’ Answer, ‘The restoration of his brother and himself.’ He replied, ‘The fitter to restore those loyal Catholic gentlemen who had suffered with him and been kept unjustly out of their estates. The motion rejected.’ James saw at the time and saw more clearly long afterwards, that his land policy must set the English faction against the Irish. Two passages in his Memoirs are highly significant. ‘Nothing but his unwillingness’, he maintains, ‘to disgust those who were otherwise affectionate subjects could have extorted his consent to the Irish policy from him. It had, without doubt, been more generous in the Irish not to have pressed so hard upon their prince when he lay so much at their mercy, and more prudent not to have grasped at regaining all before they were sure of keeping what they 



---

p.liv



already possessed.’ ‘But the Irish, by reckoning themselves sure of their game, when in reality they had the worst of it, thought of nothing but settling themselves in riches and plenty by breaking the Act of Settlement, and by that means raise new enemies before they were secure of mastering those they had already on their hands.’ He yielded to pressure, and, unfortunately for him, it became known that he would yield to pressure. Louis and Avaux at last triumphed, and James became as clay in the hands of the potter. The two Frenchmen discerned that the prospects of an English counter revolution were small indeed, while those of an Irish revolution were tolerably great. Ireland might possibly secure a nominal independence, but France would be the power behind the throne. The colonists could be expelled, the Roman Catholics restored, and their Church be made the established Church of the nation. Ireland would be linked to France by the strong tie of a common hostility to England. Louis might count on the Irish to fight his battles and their land to provision his troops. The harbours of the country, especially in the south, would afford support to his navy, whence his ships might issue forth to harass the trade of England. Little wonder that with these aims in view Avaux supported the Irish party so heartily. Louvois was delighted to receive from his political agent such welcome news. The best thing, Louvois replied, that King James could do would be to forget that he had ever reigned in Great Britain, and to think only of putting Ireland into a good condition, and of establishing himself firmly there. Divide et impera is a sound maxim under certain conditions, but in Ireland it proved fatal to the prospects of James in England. The differences between the two types of Jacobite became so acute that the Irish actually proposed to exclude from their party all Roman Catholics of English descent. The quarrel between the Irish Jacobites and the English in the parliament of 1689 became the feud between the Tyrconnelites



---

p.lv



and the Sarsfieldites, as Stevens found to his cost, at the siege of **Limerick**. The difference of the principles of the English Jacobites from those of the Irish meant to an ordinary Irishman that Tyrconnel held one view of a given policy while Sarsfield maintained another. Inevitably the strife between principles became one between parties*.* Of course these divisions ruined the king's cause in Ireland. That James was a humane man on the whole few would deny, still there is in the archives of D'Este the terrible letter of the 24th of February, 1689, to the Cardinal D'Este. ‘J'espère,’ he wrote, ‘que Sa Sainteté croira que l'occasion qui se présente de détruire l'Erésie (i.e. in Ireland) avec une armée Catholique n'est pas de celles qu'on doit perdre.’ His stay in Ireland, however, convinced him that such a plan would utterly defeat his projects. He shrank from such a cruel policy, but Avaux did not. The letter of Avaux of August the 14th, 1689, to Louis, and the king's reply of September the 6th, prove that the former urged James to put his policy into practice. The first letter runs thus:
  


‘Le Roy d'Angleterre m'avoit escouté assez paisiblement la premiere fois que je luy avois proposé ce qu'il y auroit à faire contre les Protestans, lorsque quelques uns d'eux se seroient soulevez, et auroient attaqué les Catholiques, mais comme il n'avoit rien determiné, et que je luy ay demandé depuis cela ce qu'il luy plaisoit d'ordonner, il m'a respondu d'un ton fort aigre, qu'il ne vouloit pas egorger ses sujets, que c'estoit son peuple, et qu'on ne l'obligeroit jamais à le traitter de la sorte. Je luy repartis que je ne luy proposois rien de fort inhumain, que je ne pretendois pas qu'on fist aucun mal aux Protestans qu'apres qu'on les verroit se soulever et que s'il en usoit autrement, la pitié qu'il auroit pour eux seroit une cruauté pour les Catholiques. Je le suppliay ensuitte de me dire quelle estoit son intention, et ce qu'il vouloit que les Catholiques de Kork fissent, s'ils voyoient que les Protestans de **Bandon** eussent massacré tous les Catholiques, et ainsi des autres villes: il me dit qu'ils attendoient à se deffendre quand les Protestans les attaqueroient. Je representay que les Protestans ne leur donneroient pas avis de ce qu'ils auraient dessein de faire, et 



---

p.lvi



qu'ils massacreroient tous les Catholiques les uns apres les autres; il ne m'a respondu autre chose que ‘Tant-pis, Monsieur’.’
  

The second letter shows that even Louis would not consent to such a proposal.
  


‘Je n'approuve pas cependant la proposition que vous faites de faire main basse sur tous les Protestans du royaume, du moment qu'en quelque endroit que ce soit, ils se seront soulevez; et outre que la punition d'une infinité d'innocens pour peu de coupables, ne seroit pas juste, d'ailleurs les represailles contre les Catholiques seroit d'autant plus dangereuse, que les premiers se trouveront mieux armez et soutenus de toutes les forces d'Angleterre.’


The divisions of the Irish and English Jacobites hindered the return of James to England, but the advice of Avaux must irrevocably have destroyed any such prospect. Undoubtedly Avaux intended by this universal annihilation of the Protestants to separate England and Ireland for ever, to place the two nations in a permanently hostile position in order that French interests might be advanced.


### The Social Condition of the Country


From f. 87b to f. 88b Stevens writes a tantalizingly short sketch of the social condition of the country, though here and there throughout the Journal he also affords interesting information. He notes that the people are ‘the greatest lovers of milk I ever saw, which they eat and drink above twenty several sorts of ways, and what is strangest for the most part love it best when sourest’. **Fynes Moryson** (1600–3) agrees that ‘they feed most on white meats, and esteem for a great dainty sour curds, vulgarly called by them Bonaclabbe (i.e. Bonnyclabber). And for this cause they watchfully keep their cows, and fight for them as for their religion and life; and when they are almost starved, yet they will not kill a cow, except it be old and yield no milk. Yet will they upon hunger in time of war open a vein of 



---

p.lvii



the cow and drink the blood, but in no case kill or much weaken it. A man would think these men to be Scythians, who let their horses' blood under their ears, and for nourishment drink their blood, and, indeed (as I have formerly said), some of the Irish are of the race of Scythians.’[19](javascript:footNote('E680002-001/note019.html')) **Dean Swift**, in one of his ironical articles, entitled The Answer to the Craftsman, wrote ‘to which employment they (i.e. the Irish graziers) are turned by nature as descended from the Scythians, whose diet they are still so fond of. So Virgil describeth it:—
  

*Et lac concretum cum sanguine bibit equino. ‘And he drinks curdled milk with horse's blood—’’’*

misquoted from Georgica 3, 463.


  


Which in English is Bonnyclabber.’ According to **Luke Gernon**, in the baser cabins, in 1620, ‘you shall have no drink but Bonnyclabber, milk that is soured to the condition of buttermilk, nor no meat, but mullagham (mallabanne), a kind of chokedaw cheese, and blue butter, and no bread at your first coming in, but if you stay half an hour you shall have a cake of meal unboulted, and mingled with butter baken on an iron called a griddle, like a pudding cake.’ According to **M. de la Boullaye le Gouz**, who visited Ireland in 1644, ‘The Irish gentlemen eat a great deal of meat and butter, but little bread. They drink milk, and beer into which they put laurel leaves, and eat bread baked in the English manner. The poor grind barley and peas between two stones and make it into bread, which they cook upon a small iron table heated on a tripod; they put into it some oats, and this bread, which in the form of cakes they call Haraan, they eat with great draughts of buttermilk.’ **Fynes Moryson** says ‘their ordinary food for the common sort is of white meats, and they eat cakes of oats for bread, and drink not English beer made of malt and hops, but ale.   
[*...*]  
 And for the cheese or butter commonly made by the English-Irish an Englishman would not touch it with his lips though he 



---

p.lviii



were half-starved; yet many English inhabitants make very good of both kinds. In cities they have such bread as ours, but of a sharp savour, and some mingled with anice-seeds and baked like cakes, and that only in the houses of the better sort.’ On the other hand, **Le Gouz** thought the butter, the beef, and the mutton better than in England, and he pronounced the beer good and the brandy excellent. **Boisseleau** was as unfavourable as **Fynes Moryson**, and to him Ireland was ‘a country where there is no corn, no bread, no medicine, and where a wounded man is as good as dead.’ During the Jacobite war there was marked deficiency in the supply of salt and saltpetre. Of course, meat could not be cured and gunpowder could not be manufactured on a proper scale. **Fynes Moryson** admits that ‘the Irish aqua vitae, commonly called usquebaugh, is held the best in the world of that kind, which is made also in England, but nothing so good as that which is brought out of Ireland.  
[*...*]  
 Neither have they any beer made of malt and hops, nor yet any ale—no, not the chief lords, except it be very rarely; but they drink milk like nectar, warmed with a stone first cast into the fire, or else beef-broth mingled with milk.’ Rosen complained that the beer was brewed so badly that it could not be drunk without producing dysentery, from which one man died out of ten. Perhaps Captain Gafney's cure for ague may be noticed. It is ‘One ounce of cortex new, one dram of powder of snake weed, one dram of powder of nutmegs made up into an electuary, with a sufficient quantity of syrup of lemons, you are to take the bigness of a chestnut of it three or four times in the four and twenty hours, whilst it (i.e. the ague) lasts shaking, after it a glass of claret warmed mixed with brandy and sugar.’ **Fynes Moryson** records the fact that ‘they who are sick thereof, upon a received custom, do not use the help of the physician, but give themselves to the keeping of Irish women, who starve the ague, giving the sick man no meat, who takes nothing 



---

p.lix



but milk and some vulgarly known remedies at their hand.’ **Sir William Brereton** gives (in 1635) another medical recipe: ‘At my coming to **Carrickfergus**, and being troubled with an extreme flux, not as yet come to so great a height as a bloody flux, my hostess, Miss Wharton, directed me the use of cinnamon in burnt claret wine, as also the syrup and conserve of sloes well boiled, after they have been strained and mingled according to discretion with sugar, they are to be boiled with sugar until they be cleared, having been first boiled in water until they be softened and then strained.’


Stevens points out that ‘all smoke, women as well as men, and a pipe an inch long serves the whole family several years, and though never so black or foul is never suffered to be burnt. Seven or eight will gather to the smoking of a pipe, and each taking two or three whiffs gives it to his neighbours, commonly holding his mouth full of smoke till the pipe comes about to him again.’ **Le Gouz** and Stevens agree in their description of Irish shoes. The former remarks, ‘Their shoes, which are pointed, they call brogues, with a single sole. They often told me of a proverb in English, ‘Airische brogues for English dogues’ (Irish brogues for English dogs), ‘the shoes of Ireland for the dogs of England,’ meaning that their shoes are worth more than the English.’ They also agree in their account of the cabins. They are, according to **Le Gouz**, ‘four walls the height of a man, supporting rafters over which they thatch with straw and leaves. They are without chimneys and make the fire in the middle of the hut, which greatly incommodes those who are not fond of smoke.  
[*...*]  
 They have little furniture, and cover their rooms with rushes, of which they make their beds in summer, and of straw in winter. They put the rushes a foot deep on their floors, and on their windows, and many of them ornament the ceilings with branches.’


Other inmates of the cabin were more unpleasant than 



---

p.lx



the smoke, as Stevens testifies. **Fynes Moryson** asserts that ‘in cities passengers may have feather beds, soft and good, but most commonly lousy, especially in the highways, whether that came by their being forced to lodge common soldiers, or from the nasty filthiness of the nation in general.’ Even **Le Gouz** admits that ‘the generality of them have no shirts, and about as many lice as hairs on their heads, which they kill before each other without any ceremony.’ M. Bouridal describes the Irish soldiers, who landed in France in 1691, as ‘shirtless, shoeless, hatless, and afflicted with vermin.’ Travellers like **Stanihurst**, an Irishman, **Spenser**, **Fynes Moryson**, **Cuellar**, **Rinuccini**, **Eachard**, **Hartlib**, and **Le Gouz**, all take as unfavourable a view of Irish civilization as John Stevens. Moreover, Stevens speaks of remote western parts beyond the control of England. In the course of his marches Stevens encountered the ‘creaghts’. **Fynes Moryson** shows that ‘plenty of grass makes the Irish have infinite multitudes of cattle, and in the heat of the last rebellion the very vagabond rebels had great multitudes of cows which they still (like the nomads) drove with them whithersoever themselves were driven, and fought for them as for their altars and families.’ These nomads were the creaghts. When James I endeavoured to give a system of administration to Ireland he met with the greatest difficulty from this pastoral population, accustomed to wander about without any fixed habitation after their herds of cattle, living largely on white meats, as the produce of their cows was called. At this period there was not, according to **Sir John Davies**, one fixed village in county Fermanagh.[20](javascript:footNote('E680002-001/note020.html')) In a letter to the Earl of Salisbury, written during the first circuit ever held in Fermanagh, **Davies** mentions that the fixing a site for a jail and sessions house had been delayed ‘until my Lord Deputy had resolved on a fit place for a market and corporate town; for the habitations of this people are 
 


---

p.lxi



so wild and transitory, as there is not one fixed village in all this country.’ **Fynes Moryson** describes their dwellings as made of wattles or boughs, covered with long turves or sods of grass, which they could easily remove and put up as they wandered from place to place in search of pasture, following their vast herds of cattle with their wives and children, and removing still to fresh lands as they had depastured the former, and living chiefly on the milk of their cows.[21](javascript:footNote('E680002-001/note021.html')) The aggregate of families that in one body followed a herd was called a ‘Creaght’. In **Ulster**, north and west of **Lough Neagh**, it seems that the whole population was formed of creaghts, living this wild and nomadic life. In other parts of Ireland there was the kindred custom of **Boolying**, in which the owners of cattle and their families spent much of the year in the wilds and mountains with their cows, but they seem to have returned to fixed habitations. **Edmund Spenser** sets forth the evils of boolying, that it was difficult to enforce law, for such wandering peoples could scarcely be made responsible for offences. The government grappled with the matter, and in the Commission issued for the survey of **Ulster**, on the suppression of Tyrone's rebellion, dated July 16, 1605, the commissioners are directed to take order for building several towns and villages for settling such subjects as have no certain habitation, ‘by reason whereof, the inhabitants of the same do for the most part wander up and down loosely, following their herds of cattle without any certain habitation.’[22](javascript:footNote('E680002-001/note022.html')) In a letter to the king, October 31, 1610, complaining of some of the difficulties of the plantation, the Earl of Chichester says that, though the Irish of this territory had plentifully tasted of his Majesty's clemency and happy government to their great profit and comfort, yet, to alter their rude and uncivil customs, and to bring them to live by their labours on small portions of land by manuring and stocking it with goods of their own, was as grievous 



---

p.lxii



unto them as to be made bond-slaves. With the **Ulster** Plantation appeared the definite appropriation of the lands among the new settlers, and with it disappeared the custom of creaght.


The disappearance took time, but ultimately it came. The letter of January 26, 1653, states that
  


‘Upon serious consideration had of the inconveniency of permitting the Irish to live in creaghts after a loose and disorderly manner, whereby the enemy comes to be relieved and sustained, and the contribution (i. e. the monthly assessment) oft damaged; we issued our order dated the 11th of October last for the fixing such persons upon lands proportionable to their respective stock and enjoining them to betake themselves to tillage and husbandry, and in case of refusal to seize upon the cattle and stock of such persons, and appraising them upon oath to expose them to sale for the best advantage of the Commonwealth.’


‘We’ are the commissioners for the government of Ireland. They go on to complain of want of intelligence, and require their officers to report how far they have gone in the execution of the order, and lay down that in fixing all such creaghts they take care that they be disposed at most distance from their friends and relations, to the end all relief may be the better debarred from the enemy. An army, whether Williamite or Cromwellian, was obliged to depend for support on supply raised by the assessment of a gross sum on each county, and then apportioned on the inhabitants according to their several stocks and crops. The difficulty of assessing such wanderers as the creaghts can easily be imagined, and was set forth in another order, by which fresh measures were directed for extinguishing them by ‘unheading the creaghts’, that is, imprisoning the chief man of the creaght until the rest of it were certified to have transplanted themselves and taken up a fixed abode in **Connaught**. This order states:
  


‘29 August, 1656.—Whereas the Lord Deputy has been informed by his Council that at this present there are some 



---

p.lxiii



creaghts that have removed out of **Ulster** who, according to an ancient but barbarous manner of life, have no fixt place of habitation, but wander up and down with their families and substance to the prejudice and just offence of divers people, and to the defrauding of the public of the cess and duty which is legally due: His Excellency Lord Henry Cromwell thereby appoints persons to enquire what creaghts are in **Meath** or thereabouts, how long they have continued there, how called, from whence and by whose encouragement they came thither, and by what authority they practise that vagrant and savage life so contrary to Christian usage: And to the end such a lewd custom may be duly discountenanced and made exemplary, His Excellency thereby orders that the heads or chief persons of those creaghts be secured in some safe place, and the persons of the rest of the said wanderers kept likewise in restrain, until they shall give security for their speedy transplanting into **Connaught**. The heads of the said creaghts to remain in custody until the return of a certificate from the commissioners at **Loughrea** that the said creaghts are actually removed with their stock and substance, and settled there. The persons who are to execute this order to take the names of the said creaghts and an inventory of such of their stock and goods as shall be judged fit to be reserved for the maintenance of such chief person secured as aforesaid.’


Story saw some of the wild Irish near **Newry** in 1690, and writes: ‘Some call them creaghts, from the little huts they live in, which they build so conveniently with hurdles and long turf, that they can remove them in summer towards the mountains, and bring them down to the valleys in winter.’[23](javascript:footNote('E680002-001/note023.html')) It is clear, however, that the historian confounds the Irish term creaghts with the English word crate, hurdle or wicker-work. His error is intelligible, for the word was applied to an Irish village or collection of those frail habitations, even though they were not intended to be moved. Stevens met creaghts, and Story may well have met them. In spite of law and in spite of orders traces of the creaghts persisted till the middle of the eighteenth century.




---

p.lxiv


### The Dates of the Journal

1. January 11 . . . . . . f. 2b
2. September 6 . . . . . . f. 4b
3. January 11 . . . . . . f. 10b
4. February 1 . . . . . . f. 18a
5. March 4 . . . . . . f. 26a
6. April 3 . . . . . . f. 33b
7. May 5 . . . . . . f. 36b
8. Dates cease . . . . . . f. 44b
9. August 20 . . . . . . f. 60a
10. September 5 . . . . . . f. 60b
11. October 4 . . . . . . f. 62a
12. Dates cease . . . . . . f. 66a
1. May 19 . . . . . . f. 73b
2. June 1 . . . . . . f. 76b
3. July 1 . . . . . . f. 79b
4. August 1 . . . . . . f. 97a
5. September 1 . . . . . . f. 108b
6. Dates cease . . . . . . f. 113a
1. April 20 . . . . . . f. 116a
2. May 4 . . . . . . f. 117b
3. June 2 . . . . . . f. 118a
4. July 1 . . . . . . f. 125a


### The Notes


In compliance with a suggestion of Professor Firth, the notes have been re-arranged to avoid having too many on one page: the index of events and persons will facilitate reference. *(The indices have been omitted from the CELT edition. They may be consulted in the PDF version of Stevens Journal available on www.archive.org on the Internet.)*Notes on well-known people, e.g. Schomberg, are short, while those on obscure people are necessarily longer.


The spelling of the Journal has been modernized. Names of places have also been modernized, e.g. when Stevens writes Ierney the editor writes Ernée. Where there seems a doubt the spelling of Stevens has been given.




---

p.




---

p.


### An Introduction to the Journal


{ms folio 1b}His Most Sacred Majesty having, through the infinite goodness, and providence of Almighty God, made his escape from Rochester,[24](javascript:footNote('E680002-001/note024.html')) and the most happy news of his safe arrival, and kingly reception in France,[25](javascript:footNote('E680002-001/note025.html')) being spread all over England: the small remainder of his loyal subjects (those few thousands who had not bowed their knees to Baal) either in their persons, or at least in their wishes hasted to follow him. Some through the great incumbrance of their families, others through want having been plundered of all their substance, others for fear of being burdensome to him in his exile, and lastly some in hopes of being more serviceable to him, when Providence should ordain his return, remained in {ms folio 2a} their more than Egyptian slavery. Yet a very considerable number gathering together the small remainders of their shipwreck, and laying aside all worldly considerations, having only before their eyes their duty and love to their sovereign, resolved to follow him through all hazards, in hopes of being instrumental in regaining his just rights. I shall ever esteem it the most glorious action of my life that I made myself one of this number, and cannot but be proud that in all the hardships, and misfortunes, which have attended this my tedious exile, I have never been dismayed, or given way to despair; but relied always on the justice of our cause, and all miseries have been easy to me in consideration of the happiness of my return home. To come closer to the matter, to wit my transactions after his Majesty's 



---

p.4



departure, it is to be observed, that though I immediately resolved to follow, yet through the difficulty of getting passes, and many other impediments, {ms folio 2b} I could not set forward till Friday, January the 11th, 1688/9. Yet before I proceed I cannot but look back as far as the original of all this country's and my own misfortunes, to wit, the time of the invasion. And by way of introduction make some remarks of what happened to me from that time, till I left England, in short as things have occurred to me upon penning this paper in haste. When the spirit of witchcraft, or rebellion (which the Scripture tells us are alike [26](javascript:footNote('E680002-001/note026.html'))) had well possessed itself, and as it were fixed its abode in the hearts of most of His Majesty's dissembling (enthusiastic subjects, through the mediation of their Pharisaical teachers,[27](javascript:footNote('E680002-001/note027.html')) at the time when men began to lament the danger of losing their religion, who were never known to be possessed of, or pretend to any, at this time was I employed in Wales in receiving His Majesty's revenue of excise there. Being in a public employment {ms folio 3a} and keeping much company, I could not but easily discern, how prone all were to mutter about breach of laws, and invading of religion, and it was plainly to be discerned, that many who said Well Well, thought very evil. This I found by long experience, yet the fear of punishment kept their tongues as well as hands within the limits of the law. The first hardened piece of insolence that I observed, was upon the news of the Seven Bishops[28](javascript:footNote('E680002-001/note028.html')) being released, at which time in **Welshpool** in



---

p.5



Montgomeryshire where I commonly resided, and many other places about, were made public bonfires in contempt of His Majesty's proclamation forbidding the same, or rather in defiance of his authority, through which those incendiaries were committed, and again set loose, to blow up that fire they had before left concealed, and which has since raged through these three miserable kingdoms. No sooner had {ms folio 3b} these (to use His Majesty's own phrase) seven trumpets of rebellion recovered their undeserved liberty, but they spread themselves through the kingdom, each taking his part, and sounding so loud that they drew after them, not only, their own insignificant flock, commonly distinguished by the name of Church of England men, but all the other herds of wild animals that ranged the vast forest of the English heresy and schism. So that it was wonderful to see so many monsters, so far different in nature, who but just before were devouring one another, in a moment so united, and linked together, only by the thirst and desire of satiating themselves with the blood of a king, and his few Catholic subjects. One of these seven champions of Satan, to wit Dr. Lloyd, Bishop of St. Asaph,[29](javascript:footNote('E680002-001/note029.html')) took his progress through that part of the country where I was then employed, and it was most manifestly to be seen that every town he passed through received from him {ms folio 4a} the infection he came to spread, and all sorts of people sucked in the poison so greedily, that the country which before laboured under but some small symptoms of sedition, and could easily have been recovered, was now grown drunk with rebellion, and swelled to that height with the venomous contagion, that no antidotes were of strength enough to restore it. It was, *immedicabile vuluus, ense recidendum’’*

**Ovid**, Metamorphoses. , I. 190–1.

, only to be cured by cutting off the infected parts, to prevent the sound from partaking in the contagion. This was the posture of affairs in 



---

p.6



Wales and generally throughout England, when I was obliged to go to London to settle my accounts. I found that city (which as it is the capital of the kingdom so has it ever been the head in all insurrections and treasons) no less modelled than its members, and most men either carried a tacit treason in their faces, or palliated in their words. Here I continued the space of three weeks, till the {ms folio 4b} news of the Dutch fleet having passed the Downs, and afterwards in sight of the Isle of Wight that ever accursed villain and ungrateful wretch, the Earl of Dartmouth, with the English fleet under his command never endeavouring to disturb or molest them.[30](javascript:footNote('E680002-001/note030.html')) Alarmed with this news I thought fit to haste down to secure what part of His Majesty's interest I was entrusted with in Wales, and accordingly set out on Tuesday, the 6th of September, in the Shrewsbury coach, and on Wednesday the 7th at night I received a letter at Northampton, with the news of the Prince of Orange's landing at Torbay with 14,000 men on Monday the 5th of the eighth month. This made me the more earnest to be at my journey's end, yet arrived not at **Welshpool** till Monday the 12th, the coach having broken short of Shrewsbury, and keeping us a day extraordinary on the road. Being arrived I found the generality of the people began to be more open {ms folio 5a} hearted, and were not at all averse to the Prince of Orange or his designs, and thus it continued some days, the dispositions of the people being daily sounded by the leading men, and each preparing horse and arms under pretence of a militia for an insurrection. Till the false Lord Cornbury[31](javascript:footNote('E680002-001/note031.html')) having openly taken to himself the title of traitor, 



---

p.7



 
by going over to the enemy with such as he had prepared, or ensnared, gave courage to many to rise, as did in Wales the Lord Herbert of Cherbury[32](javascript:footNote('E680002-001/note032.html')) and with him Sir John Price and many more of note, followed at first by a few of their own tenants, and servants. These first secured Ludlow with a small number, but were soon reinforced from all parts of the country, fathers sending their sons, and masters their servants with their best horses and arms, giving out for fear of any misfortune that they ran away from them. What money of the king's was in my hands before I had taken care to return to London, and it being time {ms folio 5b} now again to receive the fresh duty I ordered it to be deferred knowing well that the rebels seized the king's money wherever they found it, and being satisfied they had the same design upon me. And having intelligence there was a design to seize my horses, I sent them by means of one Mr. Jones of **Welshpool** to Mr. Vaughan of Lludiaths whom I suspected and he afterwards proved as great a rebel as the rest, but at that time such men's houses only were safe. Yet I resolved to stay and see the extremity of things myself, knowing there were some under me, who designed to receive the king's duty, and wanted only my absence to authorize them in doing of it, and was resolved to expose myself rather than the king's authority should be made an instrument to receive his money to serve against himself. Which whilst I was in **Welshpool** was attempted in other parts of the country by one Search, a villain, who was supervisor under me, but I having timely notice by my letters prevented his malicious intent from taking effect. But I dwell too long upon {ms folio 6a} this subject, and to come closer to the point in hand, I continued here till such time as all the country round was in open rebellion, having taken arms, plundered several houses and, among the rest, one of Duke Powis [33](javascript:footNote('E680002-001/note033.html')) at 



---

p.8



Buttington, a mile from **Welshpool**, and committed several outrages, especially in destroying chapels in most places. Finding it was impossible to do the king any further service being hourly in danger of being seized and imprisoned by the rebels, I thought it convenient in time to withdraw. Accordingly having sent for my horses overnight, I left **Welshpool** in the morning early, and went, that day being Monday, to Wrexham in Denbighshire, twenty-four miles from **Welshpool**, knowing the road to London was every way beset, and that it was impossible for me to avoid being examined and secured, both as being well known, and obliged in conscience not to deny my religion, which was cause enough then to rob, and secure me. The next day, Tuesday, I left Wrexham and went to Holywell in Flintshire, still northward and from {ms folio 6b} London, and finding the country very peaceable, and that no injury was offered to us, but the people continued in their obedience, without so much as a thought of rising at least in appearance, I continued four days with great satisfaction, hoping the king had yet some good subjects, and all was not lost. The last of these four days, being Saturday, came the news that His Majesty with the queen and prince, were privately withdrawn from Whitehall, and it was thought were gone into France. The company I then kept were four or five priests, and though at first we seemed not to believe, yet finding a confirmation from all hands of the truth of this report, we were as it were thunderstruck, till coming out of our amazement every one began to consider which way best to shift for himself. One of the priests desired me to stay and he would secure himself and me among his friends in the country, but having taken a resolution immediately to follow His Majesty's fortunes, I prepared to take my journey next morning. Some hopes I had that Chester still held for the king, being told before the Lord Molyneux[34](javascript:footNote('E680002-001/note034.html')) had secured it with Gage's Regiment, 



---

p.9



and some Irish Dragoons {ms folio 7a} and that there were lately landed 3,000 men out of Ireland, but I was soon undeceived and found Gage's Regiment and the Dragoons had been disarmed, the city being secured by the major for the Prince of Orange, and the Irish recruits being only many ships full of women and children that fled from Ireland for fear of chimerical massacres. I entertained thoughts of going over to Ireland to serve the king there, but was soon dashed with a false report, that the Lord Deputy had been seized upon, and delivered the sword to the Lords Granard,[35](javascript:footNote('E680002-001/note035.html')) Mountjoy,[36](javascript:footNote('E680002-001/note036.html')) and others. So that the only way left was to London and thence follow His Majesty; in order to which on Sunday morning I rode over the sands to Chester, which is thirteen miles from Holywell and fearing to be stopped there ordered one Mr. Cole, a Protestant, who went with me as a friend, not to call me by my own name. At Chester I alighted at the posthouse, having found the gates of the city locked, and much difficulty to get in, but the first thing the Postmaster asked my friend was whether he knew one Mr. Stevens that



---

p.10



was employed in Montgomeryshire, meaning myself, and my friend as readily denied having any knowledge of me {ms folio 7b} yet this gave me cause to apprehend danger, and to avoid suspicion I thought fit not to leave the house, but dining there was known by some passengers who came out of Ireland yet they could not hit upon my name. Thus I spent the day with many apprehensions, being known by several, whom still I shifted off, and took a place in the coach for London by a false name, not daring ride my own horses for fear they should be taken from me on the road, and give occasion of securing me. On Monday morning having recommended my horses to my friend I set out in company with two women who fled from Ireland, and a disbanded lieutenant of Colonel Gage's Regiment. This night we lay at Whitchurch, where as soon as alighted we were examined by some of the watchmen of the town who were in arms, and these were easily satisfied and left us; but as the lieutenant and I (understanding our circumstances to be alike) were going to bed came up another parcel of the same sort of rabble governed by a hot-headed nonsensical young fellow who gave us much trouble, and could not be satisfied but that we were dangerous men and ought to be secured, till our landlord taking him down with difficulty convinced him by {ms folio 8a} the powerful argument of much ale and brandy. Tuesday morning early we set out and baited[37](javascript:footNote('E680002-001/note037.html')) at Newport, where we again suffered persecution at the hands of our ignorant examiners. Here we met with one that was a steward or some such sort of instrument to the Earl of Macclesfield,[38](javascript:footNote('E680002-001/note038.html')) who, having seated himself among the rabble that came to examine us, perplexed us more than all the rest, and had quite daunted my fellow sufferer, and almost put me to a stand, till on a sudden he confessed he only asked those 



---

p.11



questions out of curiosity being no justice of the peace, which taking hold of I replied, he did very ill to put us to all that trouble without reason or authority, and that he must expect no further answer from me till he could show his authority to examine. Wine and ale reconciled our differences and all being well composed we set out with our new fellow traveller, whom at first I thought there was more reason to fear than our chance enemies on the road, but was soon rid of my apprehensions. For no sooner were we seated in the coach, but our fugitive Irish zealots lamenting the imaginary calamities of their Protestant brethren in Ireland, he took thence occasion to rail at His Majesty's government, not naming him, {ms folio 8b} but stabbing his reputation, through the sides of his counsellors, to justify the Prince of Orange's invasion and extol the successful rebellion of His Majesty's ever perverse subjects. Not able to bear with so much insolence, and laying aside all thoughts of the danger I exposed myself to in opposing the prevailing party, I very freely replied to all he said, in such manner that though it be impossible without a miracle to convince an old hardened rebel as he was, yet I left him nothing more to say for his cause. At this time the rumour of the Irish burning and murdering all before them, which had been maliciously spread on purpose for the destruction of the Catholics, had prevailed, and people dreamed of nothing but blood and massacres, the very forgers of the lie having told it so often that they believed it themselves. My antagonist was not void of his share in this fear, whereupon finding he could not prevail on me with his arguments he thought good to compound, and telling me he knew well I was a Papist, and that he loved no good man the worse for his religion, and therefore would agree, if I would defend him against the Irish in case we met them, he would carry me safe to London notwithstanding all the watches and guards that were on the road to examine passengers. Though I found this to be a very {ms folio 9a} advantageous offer to me being in continual danger of being stopped by every impertinent constable, or watchman, and knowing there is no surer way to avoid being robbed than to make a friend of the highwayman; yet having found 



---

p.12



his blind side I would not show him mine, and therefore with much indifference I thanked him for his kind offer, telling him I stood not in need of any assistance to carry me through the world having done nothing that I was ashamed of, or afraid to answer, but that not being used to converse with the rabble, nor acquainted with the nonsense of their dialect, he would do me a favour to keep them from me, and to requite the obligation I engaged to protect and defend him against all the wild Irish in the kingdom. Thus agreed we came to the Four Crosses, where we lay this night, and it being a lone place where there are but three or four houses, we had no trouble from our learned examiners, the Mobile, under the title of Constable and Watch. Here I found the Earl of Castlemaine[39](javascript:footNote('E680002-001/note039.html')) and Mr. Thomas Price of Llanvilling, a Montgomeryshire gentleman, with whom I had been before acquainted, they were both privately going to the house of the latter, thinking to be there private. I told them the danger the country being in arms, and showed no {ms folio 9b} safety could be expected there, yet they thought their own course best, but no sooner was I arrived at London, than I heard what I had told them proved true, which was that the said Earl was in Shrewsbury Gaol. Wednesday we baited at Castle Bromwich, and lay at Coventry meeting with no trouble for what there was, my fellow traveller according to contract took upon himself and answered to the mayor of the town for both. We heard some of the distressed unarmed Irish had been in this town on their way to Chester and kindly received by the inhabitants, but commanded back to London by order from the Prince of Orange. Thursday night we lay at Northampton, 



---

p.13



Friday at Dunstable, and Saturday came safe to London. At Highgate I first saw some of the Prince of Orange's foreigners, who quartered and kept guard there and next found them possessed of all the guards in London. I found the face of affairs quite altered, the usurper in quiet possession of the Royal Palaces, the rebellious subjects rejoicing in their new government, some stickling for their ever admired idol of a commonwealth, others to set up their Jeroboam and adore their Golden Calf, whilst the distressed loyalists either fled their barbarous country, or groaned under the slavery of {ms folio 10a} their inhuman governors. Nothing was more frequently heard than villanous reflections on their Most Sacred Majesties and Royal Highness to such a height of impudence, that the very relating of it would breed horror in a moral heathen much more in Christians, whom their faith obliges not only to obey but reverence their superiors, especially kings who are God's Vicegerents, who tell us By him they reign and decree justice, and not by authority of the rabble, as our new pseudo-evangelists would persuade us.[40](javascript:footNote('E680002-001/note040.html')) The calamities of the royal party and an earnest desire of serving His Majesty made me impatient to quit the kingdom. Therefore never regarding 



---

p.14



the difficulties that obstructed his return, or the hardships and miseries I might endure in a country, where my sovereign was only upon courtesy, I resolved as soon as possible to leave father, friends, ease, and country to bear my part in his fortunes.


 {ms folio 10b}
### The Journal


Friday the 11th of January 1688/9 about two of the clock afternoon I embarked at Billingsgate stairs on a Deal hooker bound for Deal, the wind at north-west. There were on board between forty and fifty passengers, whereof about twelve or fourteen gentlemen, the rest private soldiers all on the same account, flying the Prince of Orange's usurpation, and our fellow subjects' most unparalleled rebellion. We had many spectators on the shore, but civiller than what others on the like occasion had found. Sailing down we had some scoffs cast upon us from other boats as we passed, but no stop or trouble till about seven at night, when we met with abundance of ice, and that very thick. Still we made the best of our way, the wind blowing a fresh gale, till about eight, when it grew very dark, and there being no seamen aboard, but the master who was almost blind, and a little boy, we ran aground about two miles within Gravesend, where we lay about three-quarters of an hour, and then the water flowing brought us off. We kept on with great difficulty by reason of the great flakes of ice the tide drove up and, having happily escaped being stopped or examined at Gravesend, by the help of the darkness were again aground about eleven of the clock three miles below the town, where we lay all night.


Saturday the 12th in the morning at high water we floated again, and, nothing remarkable happening, cast anchor that night at the buoy in the Nore amidst the rebellious English fleet, the false Lord Dartmouth then riding admiral there. Within an hour the said lord sent his lieutenant aboard of us to see our passes; he was very civil, and not too exact {ms folio 11a} or rigid, and went away satisfied. However about twelve of the clock, though it was very dark, and somewhat rough, we thought it better to commit ourselves to the mercy of the 



---

p.15



 
sea, than rely any longer on the courtesy of the rebellious fleet.


Sunday the 13th: the morning proved excessive cold with much snow and the darkness was such that we knew not how to avoid the sands, and about three of the clock were the third time aground, about three leagues within Margate, on a hard sand with an ebbing water, so that there was little likelihood of getting off, and, the wind blowing very fresh, though not stormy, the vessel beat violently on the bank for near half an hour, to the great terror of us all, expecting either that or the next ebb at farthest to be lost. Thus we all betook ourselves to prayers. After a while one Mr. Usher that had been lieutenant at sea, spying the light of a ship at a great distance from {ms folio 11b} us, heaved all things out of our cockboat, and put her over the side of the vessel, pretending to go to the other ship to bring us assistance, and inquire where we were, for our master was wholly ignorant, and fancied it was Sandwich Bay, whereas next day we found we were not near it. But Mr. Usher's real intention was to save himself, and consequently leaped the first into the boat, three others presently following him; I seeing all throng to the ship side, fearing the boat would be sunk, would not attempt to get into it, but resigned myself to God's Will, and resolved to take my fortune in the vessel. The fourth man leaping into the boat from the deck put her away from the side of the vessel, and she drove off without oars, or sail, the tide carrying her violently away in a minute, so that we gave them for lost, having only just heard them cry out for oars, when it was out of our power to assist them. How sadly we passed the rest of the night {ms folio 12a} may be imagined, between the compassion for our (as we imagined) lost companions, and the apprehensions of being lost ourselves, yet compared with them we thought ourselves in much the better condition. When day appeared we found all about us for above a mile dry except some little channels not a foot deep: whereupon I advised the master to carry out an anchor before the water rise towards the channel, that might bring about the head of the vessel at high water, for the wind was almost in our stern, 



---

p.16



and ahead high banks of sand, the channel on the starboard side and to windward so that without some help it was impossible to bring her about when she began to float. This advice as all other he slighted. About half flood the vessel began to beat on the sand, without any probability of getting off, but on the contrary was driven by the wind upon the higher banks which were right ahead of us. {ms folio 12b} Then the master began to wish his anchor had been out, but in vain, having no boat to carry it with, till one Captain Mullins, a passenger, with much ado persuaded him to keep her head to windward with two very long oars there happened to be aboard, which with much pain and trouble at length brought her into the channel. This was no small joy to all the disconsolate company, so we set sail, having now only the compassion for our lost companions to afflict us. When we had run about three leagues and were right against Margate, we spied a boat making towards us from a great ship that lay off; our hearts dictated good hopes, and the boat coming aboard brought our four till then lost companions, whom having received with much joy we prosecuted our voyage. But the manner of their escape was by means of Mr. Usher, who being a seaman studied the means to drive the boat towards shore, but having neither oars nor sail, endeavoured {ms folio 13a} to pull up the seats, and failing of that, they being too fast, at length he found a broomstaff upon which as a mast he fixed his own coat, putting a cane one of the company had through the arms instead of a yard, one holding the broomstaff and two the ends of the coat, and thus he steered as much as he could towards the shore, till day appearing they discovered the aforesaid ship, which being hailed sent out her pinnace, carried them aboard, and treated them civilly, from whence spying our vessel they were sent to us as has been above related. About the North Foreland, notwithstanding all our persuasions, our blind pilot stood in so close to the shore, that having of our own accord cast the lead, we found but half a foot more water than the vessel drew, and were still standing in to the shoal water, where if we had touched all must inevitably have perished, so we stood off again; and cast anchor before Deal about 



---

p.17



 
three in the afternoon. Here to our great {ms folio 13b} admiration, we were quietly received without the least affront or reflection thrown upon us.


Monday the 14th: we continued at Deal, endeavouring to persuade the master of the same hooker that brought us to carry us to **Calais**; we used all our endeavours, but could not at first prevail so that some of the company were for going to Dover, which I was utterly against, knowing what multitude of people flocked thither to be transported, and being informed of the barbarous usage most of them received there. At night having very well treated the master of the vessel and his wife, we agreed to find fifteen passengers, who should give him ten shillings a man for their passage in hand and he to make what he could besides, and to sail next day, which was the hardest to obtain, but at length we concluded on it. Yet I cannot but once more remark that though we continued there a whole day and walked about the town, we were {ms folio 14 a} very civilly used everywhere without the least insolency being offered to us, as was to many others.


Tuesday the 15th: we embarked about noon, the vessel being ashore, and about two sailed, the wind at north-west, that night came to an anchor in **Calais** road, not daring to venture in in the dark. The night proved very favourable, being calm but very cold, and the number of passengers was so great in proportion to the vessel that there was not room for us all to sit much less to lie under deck, and were forced to walk great part of the night in the cold air. Beside we had so little forecast as not to put aboard anything either to eat or drink, which proved no small punishment though the time was short, being most of us very hungry and thirsty.


Wednesday the 16th (st. vet. and 26th st. no.): [41](javascript:footNote('E680002-001/note041.html')) in the morning boats came off from **Calais**, it being then ebb so that the vessel could not get in. We went ashore being carried out 



---

p.18



of the boats on men's backs, {ms folio 14b} and landed about a mile from the town. Without the **Watergate** we were stopped by the guard, and kept near two hours in the rain, for the town major to come to view us: at length he came.[42](javascript:footNote('E680002-001/note042.html')) The first thing he proposed to us was to give in our names, the king having provided that all soldiers should be put into Routes?[43](javascript:footNote('E680002-001/note043.html')) I understood not this word then, but having afterwards found the benefit of it think it not amiss in this place to give an account of it, which is thus. When any parties march through the peaceable part of France, there is a Route assigned them, which is an order from the king specifying the number of soldiers and officers with their respective qualities; every day's march is assigned and quarters allotted them in every town. Sometimes their billets run for free quarter and in this case the king allows their landlords the established rates for maintaining every man in the taxes he is to pay and billets are received as money. In other places he gives them pay, and then only 
lodging and dressing of meat {ms folio 15a} is required of the landlord: and lastly where towns are not capable of furnishing such numbers, the king has commissaries called *Tapiés*[44](javascript:footNote('E680002-001/note044.html')) who are bound to furnish each soldier with a pound of flesh, one of bread, and a quart of wine; ensigns have three men's allowance, lieutenants four, and captains six, and in many places forage for officers' horses. What the king allows in money to his own 



---

p.19



subjects I know not, but with us it was fivepence to a foot soldier, tenpence to horse, two shillings and one penny to an ensign, two shillings and sixpence a lieutenant, and six shillings and eightpence a captain per diem, but upon free quarter or receiving meat this money is not allowed.[45](javascript:footNote('E680002-001/note045.html'))
The people, being much used to the rudeness of the French soldiers, I found very willing to be rid of us and would give a captain a crown to be rid of him though but for one night and so proportionable to all others, for a longer or shorter time, the custom being to make every third or at most each fourth day a day of rest. Thus much by way of digression as to the meaning of the Route. {ms folio 15b} Not understanding this then and fearing that whosoever gave in his name was as good as listed into the French service, I would by no means hearken to it, my intention being only to follow my own sovereign's fortunes and by him to live and die. Hereupon I told the town major, there were several soldiers there might perhaps embrace his proposal, but there were about a dozen gentlemen of us there who desired to make the best of our way after the king at our own expense. We had much ado to satisfy him in this point, he pressing still to have us take the benefit of the Route, which 



---

p.20



we absolutely refused, being resolved not to give in our names till we had seen our king and received his commands. After keeping us an hour longer in the rain (though weary enough with our foregoing ill night's lodging), he would have conducted us through the town with a guard of musketeers, pleading his king's order for so doing, by reason of the great number of English that daily resorted thither. In fine he conveyed all the company into the lower town or suburb, except me and three more, who struck off from his guard and took a lodging at an inn in {ms folio 16a} the town. The remainder of this day and


Thursday the 27th (st. no.) I spent in viewing the town, which is small and hath not anything very remarkable. The chief thing are the fortifications, which are in part new, and still more works carrying on. In the evening word was brought that the town major ordered all English gentlemen to retire into the suburbs, which I obeyed for that night in hopes of getting away the next morning by water to St. Omer, and so went out of town an extraordinary dirty way over a great field, which divides the town and suburb, which is also excessive dirty and has but little accommodation at best, much less then being very full of English. With much difficulty I found a lodging and lay there that night, but


Friday the 28th: to go on with the style of the country, returning to town in the morning I was stopped by the sentry at the gate, there being many at the same time waiting there, and having stayed a while till an officer was called, he with 
difficulty let me and three other gentlemen in. We {ms folio 16b} spent most of our time in seeking conveniency to go to **Paris**, but such was the throng that coaches and horses were bespoke many days beforehand, and lodgings and provisions were risen to an excessive rate which made all men endeavour to fly the town the sooner. This night I continued in town.


Saturday the 29th: meeting with the Lord Buchan[46](javascript:footNote('E680002-001/note046.html')) and several other Scotch gentlemen, we agreed with a boat to 



---

p.21



carry us the next day to St. Omer, and in order to it I lay that night in the suburb near the water side.


Sunday the 30th: in the morning we went aboard a boat, carrying no provision as being told we had but eight leagues to St. Omer, and the boat to be drawn by horses. About half way we met much ice, and were told the channel was quite closed up a little farther. We were therefore obliged to strike off into the channel that comes from Dunkirk, which was clear, but by this means we had farther to go about than we had at first setting {ms folio 17a} out from **Calais**. That night we were forced to stay at a miserable village, where there were no beds but good clean straw, and scarce anything to eat, which made us very earnest to be gone the sooner, and accordingly


Monday the 31st: we returned to the boat about three in the morning, and having gone about two leagues were again stopped, the floods having been so great that the water was too high at a bridge we came to for the boat to go through. The night being excessive cold I went ashore to seek some fire at two or three poor houses by the bridge, and the first there was neither fire nor fuel, and having with much difficulty, by reason of the darkness and dirtiness of the way, got over to another I found five or six poor women warming themselves at a little straw, having nothing else to burn. There we sat awhile to refresh our joints that were almost benumbed with cold, and when day appeared returned to the boat. The water falling a little, with much difficulty the boat was forced through. Having gone {ms folio 17b} about a league farther came to another bridge, which being also too full of water the boat's head struck against a piece of timber whereon the planks lay and broke it, which caused the neighbouring boors to stop the boat to pay for repairing the damage. After a long dispute and almost alarming the country they agreed, and so we went on for near two leagues when we struck out of this cut channel into the river of St. Omer, and then no longer could be drawn by horses, but hoisted sail, and as our good fortune ordered it the wind was fair, and we sailed till about three in the afternoon we arrived at Watou, and were forced to stop some time to satisfy the customhouse officers. Here 



---

p.22



on the top of a hill stands the famous house and church of the English Jesuits of St. Omer, which we only saw from the bottom having no time to go up.[47](javascript:footNote('E680002-001/note047.html')) We soon sailed again having two leagues to St. Omer, where we arrived just at night, and were carried before the major of the suburb, who was very obliging and directed us to the best inn {ms folio 18a} there, the gates of the town, being then shut. It is remarkable that all this way we came the country is very plain, and was for the most part overflowed and frozen over insomuch that many of the poor country people's houses were rendered inaccessible, the frost not being thick enough to bear. Some cottages were destroyed, and the most considerable houses had broken the ice, and had boats at their doors with ladders to their windows, their lower floors being full of water.


Tuesday the 1st of February (sti. no.): I continued at St. Omer, which is a very fine city having large and handsome streets, the buildings generally good and several stately churches.[48](javascript:footNote('E680002-001/note048.html')) Here the English Jesuits have a very magnificent college newly built of stone, but not yet quite finished. The great market place is large and beautiful; the walls and outworks of the town of a considerable strength. The river runs up to the gates, on each side of which is a very fine quay for the vessels that come up. But the most remarkable thing is that the {ms folio 18b} inhabitants of the one side can by no means be persuaded to marry or contract any alliance with those of the other; nay, they will scarce trade or have any commerce with them, and yet they do not pretend to give any reason that ever I could learn for this.[49](javascript:footNote('E680002-001/note049.html')) Having in vain sought most part of this day for some conveniency to go to Amiens, all being taken up by the multitude of English that resorted to 



---

p.23



this town, and people of the best quality being content to give any rates for wagons. At length the Lord Buchan, Lieutenant Hickford, Lieutenant Usher, Lieutenant Macculla, Ensign Ferjuson and I agreed for twenty crowns for a cart to carry us the next day.


Wednesday the 2nd of February (to go on with the style of the country): about eight in the morning we saw a narrow long cart hooped over and covered with an oiled cloth, in which there was not room for us without our portmanteaus, so that to make room for them, after crowding four into the cart, two were forced to sit upon the horses that drew. In this manner we set out, and went three leagues of good way, most of it paved, to Aire, a small {ms folio 19a} but neat town, walled and well fortified, where we stayed no longer than to refresh ourselves, and then went on two or three of us always afoot, as we did till we came to Amiens. This night we lay at Auchel, a little village three leagues from Aire, where were only three poor inns, which not being capable of entertaining the great number of people that travelled that way, the greater part lay upon straw. These three leagues the way was very deep and hilly, the soil a stiff clay.


Thursday the 3rd: went to St. Pol which is but four leagues, there being no conveniency to lodge farther, unless we went six leagues which, our way of travelling, could not be performed that day. This is a pretty good town now somewhat decayed: it has been fortified, whereof at present only the memory remains in an old ruined wall. There are here four little churches. I went to see the monastery of the Carmelites, wherein I found nothing remarkable but that they received and treated us with much civility; as did also a sort of religious women, who have here a house and church {ms folio 19b} and whose profession is to assist the sick.


Friday the 4th: travelled six leagues to Doullens, a good little town; but coming in at night I could remark nothing in it but one good church and the inn where I lodged, which was very magnificent in its rooms, being very large and extraordinary well furnished. The town in a bottom enclosed by very high hills.




---

p.24


Saturday the 5th: we arrived at Amiens, which is eight leagues from Doullens, were conducted to the governors, who soon dispatched us. All this road from Aire is very bad, deep, and a stiff clay, insomuch that walking as for the most part I did, by reason of the smallness and uneasiness of our cart, so much dirt stuck to the shoes I could scarce many times lift my feet. For it is generally a very fat soil, yet mixed with a small sand, which binds it together like lime, the way all between arable land, but not separated by any hedges or otherwise, the country being all open without any distinction of fields or enclosures, not any banks, ditches or scarce a tree. Only about the towns and villages there is some wood, but no more ground enclosed than just serves {ms folio 20a} for their gardens and orchards. The people for the most part are extremely poor, and consequently their villages very inconsiderable, and such as afford little or no accommodation for travellers.


At Amiens I continued Sunday, Monday, and Tuesday, the 6th, 7th and 8th. Most of which time was spent in seeing that city, to give a particular account whereof would require a much longer stay there and might afford matter for a particular work. To be short it is a very fine city and much beyond any I have seen in England, except London, as are many other cities of France. The streets are large and well paved, the buildings lofty and sightly, the number of churches very considerable, whereof I saw many. The cathedral is very magnificent, large and well built, all the front covered with images of stone: there is an ascent of about twelve or fourteen steps to the gate.[50](javascript:footNote('E680002-001/note050.html')) Just within on the right hand is an image of St. Christopher with our Saviour on his shoulders, of {ms folio 20b} a prodigious bigness. In this church I saw a skull, which is kept in great veneration, being esteemed to be that of 



---

p.25



St. John the Baptist.[51](javascript:footNote('E680002-001/note051.html')) The steeple is large, but the spire upon it so little that it is only remarkable for the disproportion it bears to so sumptuous a building.[52](javascript:footNote('E680002-001/note052.html')) Just at the bottom of the steps of this church stands another dedicated to St. Joseph, but in it nothing remarkable. The nuns they call of the Paraclete have a church small and neat, but which deserves to be taken notice of as being very curiously painted both roof and walls, which they say was all done by the nuns. In the middle of the roof is our Saviour crucified, which seems to look upon a man below, whatever part of the church he stands in. There is a church of St. Denis, not worthy of note, but for its churchyard, which is a large square with a cloister about it; on most of the graves are iron or wooden crosses and all about great heaps of skulls and {ms folio 21a} other bones. The Dominicans' church is large, but of no extraordinary structure, and so the rest. Here is an hospital that will contain above 200 sick very well attended, but one much larger and fairer is building, and near finished. The citadel is not considerable, nor did I here remark anything else fit for this place.[53](javascript:footNote('E680002-001/note053.html'))


Wednesday the 9th: we set out for **Paris**, sixteen of us in a thing they call a coach; in England it would pass for a wagon, only the covering is more like that of a coach. This day we travelled seven leagues to Breteuil, a good small town plentiful enough of all accommodations. The road though bad was not so deep as before, the country more enclosed, and pleasanter than the last we came through, but what added to it was that our coach was much easier than the cart we had to Amiens.


Thursday the 10th: we made seven leagues more to Clermont, a large and beautiful town, which I believe takes its name from its situation, being on a {ms folio 21b} high hill visible at a great distance, and from the valley affords a very pleasant prospect; the hill being very steep the ascent is round it, and the way at the bottom for a considerable space is narrow with a deep ditch on each side.




---

p.26


Friday the 11th: seven leagues to Lucheux, which is a good small town and has convenient inns, though not like the last. The country about is hilly and this stands on a small hill. The road is pleasant, being gravelly, and on both sides are many vineyards, which produce good grapes, but yield a very small wine.


Saturday the 12th: baited at St. Denis, seven leagues distant from Lucheux, and two from **Paris**. It is but a small town, but in it that most famous and stately church from which I believe the town takes its name, being the burial place not only of St. Denis the patron but of many kings of France, and most worthy of admiration for the unknown value of its treasure.[54](javascript:footNote('E680002-001/note054.html')) The valley wherein it stands is very large, plain and beautiful, being full of many small but well built {ms folio 22a} towns, which render it extraordinary pleasant; the road through it is all causeway, and the fields are so stored with partridges that they run in great numbers along by the road none daring to shoot or take them.[55](javascript:footNote('E680002-001/note055.html')) This evening we arrived at **Paris** of which place I will not attempt to give any account, it being too great a subject for my pen, and my stay there too short to render me capable of it. Here I continued Sunday and Monday.




---

p.27


Tuesday the 15th: I took coach for St. Germains, where both their Majesties with the Prince of Wales then kept their court. It is four leagues from **Paris**, the way most sandy and causeway, but a little hilly. On the left of the road stands a house of the king's, called Madrid. St. Germains stands upon a hill, the ascent very steep, the town is capable of entertaining a great court, the palace large and beautiful, but not regular; many new buildings are begun about it.[56](javascript:footNote('E680002-001/note056.html')) The gardens are divided into pleasant walks, but nothing extraordinary in them: the most remarkable is a {ms folio 22b} walk and horse way along the side of the hill about a mile long, where turning off upon the left the way leads into the forest, and there to a fine little pleasure house.[57](javascript:footNote('E680002-001/note057.html')) But this as all the other palaces of France have been already described by many and my intention is only a bare memoir of my travels, not a description of the country. My life here was not so settled or pleasant to give me leisure or desire to view and give an account of what I saw, but such as can be imagined of a poor banished man, full of many cares and hardships, which I had been but little inured to before, having amidst all my misfortunes no other comfort but that of a just cause, remembering that Beati qui persecutionem patiuntur propter iustitiam,[58](javascript:footNote('E680002-001/note058.html')) and a sense of loyalty towards the best of princes, whom I saw flying the most general and barbarous rebellion the world has seen, except what the same people had shown in this unparalleled monarch's father's day, wherein he was so considerable a sufferer {ms folio 23a} being so many years banished, as is well known. The sufferings of my king in his exile, the dangers of my father mother and brethren whom I had left in the power of my inhuman countrymen, and my own condition in a strange country without any friends but such as were under my own circumstances, were causes sufficient to produce care and trouble to the most insensible of men. And if hitherto I seem



---

p.28



not to have endured much hardship and fatigue, the following part of my exile will show I have not wanted my part in most sort of sufferings. Here and in **Paris** I continued till


Thursday the 24th of February: being the first Thursday in Lent, when finding most of my friends were gone before on their way to Brest, in several routes, I having stayed till this time in hopes of a bill of exchange from England. Finding none come and fearing to be left behind, when the rest were shipped for Ireland in order to serve the king there, I went this afternoon to **Paris**, where I took a place with the messenger, to go the {ms folio 23b} next day for **Orleans**, being in haste to overtake my friends that were gone before, and ambitious to be among the first that went over to serve His Majesty in Ireland.


Friday the 25th: in the morning I left **Paris** in company with Major O'Regan, Captain Fortescue and two more; on the road my Lord Hunsdon joined us and travelled this day fourteen leagues; four to Orsay, four to Ernée, and six to Étampes, a good town where we lay this night.[59](javascript:footNote('E680002-001/note059.html'))


Saturday the 26th: we set out very early, and went through to **Orleans** being twenty leagues: six to Outarville,[60](javascript:footNote('E680002-001/note060.html')) four to Toury, where we baited, four thence to Artenay, and thence six to **Orleans**. This road is generally deep in winter, wherefore for the conveniency of travellers there is a continued causeway from **Paris** to **Orleans** broad enough for coaches, and well kept in repair, but for horse great part of the way is good all the year. This manner of travelling with the messenger, 



---

p.29



 
I think, is not used anywhere but in France, and is without doubt one of the greatest conveniences in the world. {ms folio 24a} There are set rates so that they dare not ask the greatest stranger more than is appointed, and at that price the messenger is bound to furnish travellers with able horses, and if any fail on the road to find fresh ones: he is also to provide them diet and lodging, which is always ready at their common stages, and proportionable to the number of guests. There is a plentiful table, good wine, and as much as they will drink till the cloth is taken off, very good beds, rooms well furnished, and fire in winter. So that whoever travels this way needs be at no expense upon the road and is free from trouble, all things being provided as decent and plentifully as may satisfy the most curious and persons of most considerable quality.


Sunday the 27th: I continued at **Orleans**, which is a very beautiful city, well built after the ancient manner. Here are many large churches, which I cannot much commend for their structure or ornament, the churches in France being generally inferior to those of Flanders. The cathedral is very large and well {ms folio 24b} built, but only part of the choir is in use, the rest having been defaced and almost ruined by the Huguenots, and not yet repaired.[61](javascript:footNote('E680002-001/note061.html')) The Jesuits' is large and the richest for ornaments, the Dominicans' and Franciscans' large but mean. Over the river Loire is a beautiful stone bridge, adorned with a large crucifix, with the king kneeling on the right and Joan of Arc, commonly called the Maid of **Orleans**, on the left, as a memorial of their success under her against the English, who burnt her as a witch, the French to this day paying reverence to her as a saint.


Monday the 28th: after noon we embarked upon the Loire in large flat-bottomed boats, about 100 passengers in each. These vessels have no deck, but were covered over with slit deal set up like the ridge of a house. With us were put into every boat hogsheads of wine, beef boiled and roast, and 



---

p.30



bread for four days. The river is very wide but extraordinary shallow, unless just the channel, which runs winding and is very difficult to hit, and our boats were so long and unwieldy, and had but two or three men each to manage them, that the two first days we made not much way, being very often run aground and spending much time {ms folio 25a} in getting off; at night sometimes we anchored and sometimes made way. This river is one of the most delightful places in the world, at least far the pleasantest that ever I saw for so great an extent, what I saw from **Orleans** to **Nantes** being eighty-six leagues. There are several beautiful towns upon its banks as Blois, Tours, Saumur, [*gap: extent: 6 to 7 letters*] and several other places of less note. I can give no account of them in particular, having only been ashore at Blois, and that not above one hour at midnight. In general they make a fine prospect to the water, and have very fair bridges over the river, under which the current is so rapid that it is dangerous to pass, especially for such unwieldy boats as ours were. The violence of the stream at the bridge of Saumur carried one of our boats in which were above 100 passengers first against a stone wall, and then it struck at the bridge, which much disabled the vessel and gave such a crack that many of the passengers, thinking she would have sunk, leaped over, whereof the greatest part were drowned to the number of fourteen or fifteen, as was {ms folio 25b} thought, though none could tell the certain number. The country along the banks of the river is full of pleasant seats, and both sides so well peopled that it looks almost like one continued street for several leagues, only divided by pleasant gardens and vineyards. But the most curious thing of all is to see many thousands of little houses and some very considerable ones, dug out from the sides of the hills and rocks, there being scarce any materials used to the building of their walls but what nature herself has there placed, the rooms being cut out of the sides of the hills, the front only has some addition. Even with every floor and on the very tops of their houses are pleasant gardens and vineyards, and trees of a considerable bulk grow on them. Only the front of these houses generally is to be seen, the other parts being buried underground and 



---

p.31



nothing but the tops of chimneys discernible on the hills.


Monday the 28th: as was said before, we embarked upon this river, and continued Tuesday, Wednesday, Thursday and Friday; the day, the weather {ms folio 26a} being fair and the country so diverting, passed away easily, but the nights were very cold, and we had no accommodation for lying.


Friday the 4th of March: late at night with much difficulty we obtained leave to land at **Nantes**, where we continued Saturday and Sunday. This is a very good harbour and commonly well stored with ships, its trade to most parts of Europe being very considerable, the most noted commodity which takes name from the place is brandy.[62](javascript:footNote('E680002-001/note062.html')) The city reaches a great length along the water with very good buildings, being merchants, and storehouses. It has a good bridge, and many considerable churches, especially the cathedral, which is large and beautiful.[63](javascript:footNote('E680002-001/note063.html')) It is a bishopric and university very plentiful of all provisions, and well stored with all things, either for necessary use or luxury, which it affords at moderate rates. This was the first place where I received the benefit of the Route, which was the same as free quarters, being diet and lodging, only the billet mentioned a captain's allowance not to exceed four livres or 6s. 8d. per diem, a lieutenant's {ms folio 26b} 3s. 4d. and an ensign 2s. 6d., which rates, as provisions are there, are competent to live plentifully. Here I had a captain's billet and continued to be treated as such all the way, being entered as such by the king's order under Major Ingram, who commanded a Route, and was my friend. Other boats came in on Saturday and Sunday, which well stocked the city with the king's subjects, and the country small towns not being fit to entertain so great a number, it was ordered we that came first should march on Monday, the others to follow in several bodies. This is the first town we were in of Brittany, and lies upon the very borders of that province.


Monday the 7th: we marched to Savenay, seven leagues from **Nantes**, the leagues in Brittany are very long[64](javascript:footNote('E680002-001/note064.html')) and it 



---

p.32



proved a tedious journey to many of us who were forced to march afoot and were but little accustomed to that way of travelling. The road was generally good and the weather very fair; in some bottoms only we found boggy ground which tired us extremely. In all this way there is never a town, but two very poor villages, where nevertheless we found some refreshment. The way was so tedious or some of us such bad travellers that we made it ten {ms folio 27a} of the clock at night before we reached Savenay extremely tired, and very few had beds though it was my good fortune to get one. Our company being very great, and this but a mean place, most houses had four, six or eight quartered upon them, the houses were but ordinary, and the people generally poor.


Tuesday the 8th: we marched two leagues to Donges; this was very plain and good, about the middle of it is a small inlet from the sea, very wide, but runs not far up, so that there is a way about, and a shorter over a ferry. Not having time to recover the former day's weariness and my feet being very sore, I found this day's march though so short extreme tiresome. Donges is so small that we were forced to lie twelve or fourteen in a house, with little accommodation, and had no provision but what the king's commissary, whom they call the Tapié, had made for us. The Tapié goes before all such as march by way of the Route, and, having an account of their number and quality, provides meat, bread and wine for them, allowing a captain six rations or men's proportion, a lieutenant {ms folio 27b} four, and an ensign three. This method is used either where provision is not to be found for such a number as the Route contains, or in privileged towns that are exempted from providing anything but lodging to such as quarter in them.


Wednesday the 9th: to Herbignac seven leagues, where we continued Thursday the 10th, as the general custom is after two or three days' march to make a séjour, or day of rest at the most convenient town on the road. Herbignac is a good town, but inferior to many in Brittany.


Friday the 11th: it was designed we should march to Ambon, but when we were within a league of it the commissary, that always went with us, sent word the townspeople 



---

p.33



 
were all fled for fear of us and therefore ordered we should be dispersed into the neighbouring villages. Though the disorders committed by some of our men were great, yet I cannot conceive so considerable a place as this was should be left waste at the approach of two or three hundred unarmed, banished men, whose whole dependence was then {ms folio 33a} upon that country and their king. But these commissaries there as in all other countries make the most of their employments, so ours, it may be believed, for some good consideration from the town, gave out they were fled and scattered us to quarter in the country, for marching through next day we found all people undisturbed in their houses. Major Ingram's and Major Fountain's Routes in the first of which I was marched to a village called Kervoyal by the seaside, a very mean place being the abode of only a few poor fishermen. It rained violently from the time we halted till we came to this place, and it being a byway over fields was very dirty and slippery, which added much to our affliction, being most wet to the skin, tired, and then calling to mind all our past sufferings, and apprehending what were yet to come. For sorrow seldom comes alone, and one affliction either renews the memory of another or afflicts a man with the fear of future calamities. But to proceed—in this condition we came to a miserable {ms folio 28b} village, where to our greater vexation it was long ere we could find any that spoke French, many of the meaner sort of people in this country only speaking their own British language, which, as several of our authors affirm, so I then found it to be true, that it is very like our Welsh, both by some little insight I had in that language myself, having lived above a year in Wales, and much more by a Welsh gentleman that was in my company and had some sort of discourse with the people in that language, they understanding each other reasonably well. After all our trouble and fatigue I found much better quarters than I expected or the place promised, having good wine and a bed not at all contemptible.


Saturday the 12th: being excessively tired and my feet sore I got upon one of the carts that carried our luggage and was drawn by oxen, and in this manner was carried four leagues 



---

p.34



to Vannes, our next stage, which is a large beautiful town, the seat of a parliament,[65](javascript:footNote('E680002-001/note065.html')) a bishopric {ms folio 29a} and university. Our entertainment was suitable to the place, which was very refreshing after our late fatigue.


Monday the 14th: our appointed stage was but three leagues to Auray, so it was agreed by the commissary and captains of Routes to burn that town, as the phrase is, that is receive money for our quarters, and march through to Landevant three leagues farther, which was appointed for the next day. The country here is very pleasant full of rising hilly ground, but not mountainous, with large delightful commons, wherein is store of hares. This town is not large, but well built, and has many wealthy inhabitants, who afforded us good quarters, but our stay was only for one night.


Tuesday the 15th: three leagues to Hennebont a large town, has many good houses, and one great and handsome church; but the worst contrived in the manner of its streets that ever I saw, there being not one good one in the whole, and one part of them steep as precipices, most very narrow, and short.[66](javascript:footNote('E680002-001/note066.html')) Here we continued Wednesday {ms folio 29b} the 16th, at first to the great satisfaction of some of our young gallants, though they had afterwards leisure to repent. For in this as in most great towns of France there are many gentlewomen, who appear very splendid in apparel, and among them some of tolerable faces; to some of our company a painted face with petticoats was an angel, and every one fancied if he walked but by the lady's side, and she happened to look that way, though it were but to spit, that he had won her heart, for I observed some of these courtiers spoke not one word of French, yet they followed the women about the town, and even to their chambers courting them with bows and grimaces, the custom of France and their civility to strangers or their design to ridicule them allowing this liberty. With the assistance of such as could stammer some French balls were 



---

p.35



 
contrived, and nothing appeared among these youths but joy, as if all our miseries which were now beginning had been ended. In fine there was music, dancing, singing, feasting and, to close up all, gaming, {ms folio 30a} so that the ladies and their countrymen having found the weak place in the English and Irishmen's heads, kept such of them as held out longest a day after the Routes were marched, and then sent them on horseback after us with scarce as much money in their pockets, as would pay the hire of their horses. The whole pack was so well fleeced, that some were forced to sell part of their apparel, wherewith they thought to have purchased the ladies' hearts. It had been happy for them had they read and taken Solomon's advice in the Proverbs, viz.: *Ne dederis mulieribus substantiam tuam.’’*

Proverbs xxxi. 3

 For he that treats or plays with women to win their hearts plays his money against dross. But it is time to go on five leagues farther.


On Thursday the 17th: to Quimperle a town reputed much inferior to the last, but in my esteem equal to it or rather better were it not somewhat decayed. It has at the entrance a commendable river oh the one hand, and on the other a noble mansion house of the Duke Mazarin. The descent from a hill to the town yields a pleasant prospect thereof; has one good {ms folio 30b} street, many fair houses, and one large church, not to speak of monasteries whose chapels as inconsiderable I commonly omit. The Duke Mazarin, being in town and commanding, ordered the Tapié or commissary of provisions to furnish us all with both fresh and salt fish, which had not been done in any other place it being now Lent time.


On Friday the 18th, in the morning the duke invited us all to a most splendid breakfast he had provided for us, where was all variety of fish exquisitely dressed, with other sorts of dainties fit for the time, plenty of the best wines, and an inexpressible civility and courtesy shown by him to every individual person. I cannot but say I saw not in all France a more general or particular act of civility than this in all my progress through it. The entertainment ended, we set out and marched five leagues to a very poor small and much decayed 



---

p.36



town called Rosporden, where for want of more room we were forced to quarter all the officers of a Route in a house, yet so we fared not amiss, but where I was had all beds and good conveniency {ms folio 31a} for dressing our meat, which the Tapié provided, and good wine.


Saturday the 19th: we marched four leagues to the famous and, by most of us that were some days in it, much beloved City of Quimper—Corentin, *Quimpir* where we continued many days, wherefore I shall take the freedom to enlarge somewhat here, since time allows and the place deserves it. This city stands in a bottom, on the banks of a very pleasant navigable river, which runs through it: on all sides it is surrounded with high hills that overlook it, on the south side they are close to the town and very steep. The cathedral is very large and sumptuous, has a beautiful choir, and all round it many chapels well adorned:[67](javascript:footNote('E680002-001/note067.html')) the market-place wherein it stands is large and plentifully supplied with all sorts of fish, which it being then Lent constantly filled it. There are several other churches and chapels both without and within the town, and monasteries of religious men and women, which though not very sumptuous yet help to beautify and adorn the city, as does the bishop's house adjoining to the church {ms folio 31b} of a goodly structure. The streets are not very commendable being after the old fashion generally narrow, but in the suburbs which are very large the streets are wider; the houses everywhere spacious though not very sightly, being ancient buildings. About a mile from the town is a pleasant house of the archbishop's not much to be commended for its greatness, yet valuable for its gardens divided into delightful walks and fishponds with much variety and several ornaments. Strangers here find very good entertainment, provisions being very cheap, their inns though not like those of England, yet well furnished with good beds, and meat cleanly and well dressed, variety of good wines and the common rate M. the bottle, and a good table for 15d. ordinary with a pint of wine a man. Here we may be said to have first breathed after our toils, resting sixteen or seventeen days, 



---

p.37



 
being well paid and having all things cheap, with good quarters, where we were entertained with all possible civility and liberality, the people being extremely courteous {ms folio 32a} and much more than many of our company deserved. There were among us many that made it their daily practice to commit new disorders, and preyed upon the poor people as if they had been in an enemy's country, whilst the government out of respect to our distressed king winked at their crimes, they grew the more insolent, and consequently made our name the more odious, the people admiring that men who pretended they suffered for conscience and loyalty should so little fear God and respect the king for whose honour they ought to carry themselves with all possible modesty. To be short there were thefts, uproars in the streets, insolences in quarters, and all sorts of disorders that could have been acted by a dissolute army in an enemy's country. Yet I cannot but admire that, since I have seen many of the greatest rascals in the company preferred to considerable posts, more by their impudence than merit, and they quite forgot their former despicable condition. Ease and plenty, the sources of luxury, made the more moderate wanton, so that all losses {ms folio 32b} seemed forgot, all sorrows drowned, and nothing appeared but mirth, drinking, gaming, courting of ladies, treating, and all youthful delights were reassumed, as if we had reached the promised land, and had not a wide desert of troubles to go through. Such as placed their delight in wine and good company had plentifully wherewithal to satisfy their appetites, which forwarded some evening quarrels, and what was worst some disturbances even with the watch of the town to our no small discredit. The gamester wanted not associates, and those of the fair sex, who had often the good quality to win the ready money and lose upon credit, which our gentlemen were too well bred to scruple, though they had afterwards reason and leisure to repent. The most general folly was the amours that were followed with as much eagerness as if we had fixed there never to remove. Every man was happy in his own conceit, master of his lady's affections, proposed and impatiently expected the hour of enjoying what he so much laboured for; 



---

p.38



whilst the crafty females admitted their addresses, refused not their treats, received their presents, and by several wiles drained their pockets, laughed at their ignorance, deceived them of their expectations {ms folio 33a} and sent them away without money or enjoyment, their pockets empty, and their hearts full of sorrow. This town wanted not nevertheless the seeds of vice, lewd women and debauched men. But what I cannot but mention and appeared the most scandalous, was a monastery of nuns, who kept young gentlewomen boarders, yet with such liberty that the convent was the daily rendezvous of our most extravagant and disorderly young gentlemen, where though it were Lent and even Passion Week they spent whole days with such licentiousness as was a reproach to the place, a profanation of the time, and a general scandal to all men. As our stay in this town was considerable, so have I enlarged sufficiently upon it, and will now only add that it was a place of great refreshment to us all, every one having the divertissement he desired, our pay being sufficient to keep us plentifully, and as there was much vice, which our coming was no small addition to, so was there all the encouragement imaginable to virtue, in the holiness of the time, the devotion of divine service in the churches and the good example of many of the inhabitants. {ms folio 33b} It is now time to take leave of this place and go forward on 


Palm Sunday, the 3rd of April, to Locronan three leagues, the weather was fair, the way good, for a large space a great road then a very wide open common, where we saw many of the country people well armed who had been mustering. On the road, a league from Locronan, is a small village, wherein is a pretty little church. Here as I was passing through looking into the church a woman came running and rung the bell, and inquiring into the occasion, we found some of our scattering scoundrels were pillaging the poultry thereabouts, which caused the ringing the bell to alarm the neighbourhood, the people being abroad by reason of the muster and because it was Sunday. Coming out we saw six of our men running with their drawn swords after ten or twelve of the poor naked country men and women, who getting over a style faced about 



---

p.39



 
and crying ‘Frappé Frappé,’ that is strike or throw, sent such a shower of stones as made them retire having almost knocked down two of them, but their ammunition {ms folio 34a} falling short the country people retreated again to another parcel of stones, and there made good their ground. Having seen this, and having no influence over those people to quiet them, I thought good to haste away lest the country rising should take me in as a party concerned in the fray, and came early to Locronan. This is a small town, very poor, and much decayed, where we were much straightened for quarters, and hard put for diet, fish being very scarce, and the Tapié providing only flesh, which we would not eat in the holy week. My landlord, who was an old lawyer, told me that town had always been exempted even in the present king's days from quartering soldiers, and that they had consented to it now only in kindness to us and upon promise that it should not be made a precedent.


Monday the 4th: we had a long but not very tiresome march to Crozon six leagues, the weather was fair, the way good, and country very pleasant, full of rising fertile ground but no mountain or steep ascent. This town is somewhat larger and better than the last, seated high, the streets open, and has pleasant seats about it.


{ms folio 34b}Tuesday the 5th: we marched a league to a little town upon the Bay of Brest called Le Faou, where the ships' boats took up, and carried us aboard the ships that lay there in order to carry us into Ireland. This bay makes one of the finest harbours in the world being at least three leagues over every way, enclosed round with high hills which shelter it much from storms, and make it very secure: the mouth of it, being very long and narrow, lies east and west, and is divided into two channels, a long ridge of rocks lying along the middle. The north channel is best and most used, both have much water but little room for a ship to tack which makes it the more difficult coming in and out. On the north side is a fort whereon are planted above fifty pieces of cannon, the lower tier almost level with the water. On the south side a lesser fort, each has the full command of its channel, and between both the passage is not to be forced. Opposite to the channel 



---

p.40



is the citadel of Brest upon a high rock, large and till now of the ancient fortification, but at this time they were demolishing the old and making a new work of it after the modern manner, in which as well as the other works of the town we were told 10,000 men were daily employed. To furnish these men {ms folio 35a} the country all round the town for several miles is divided into a certain number of parts and each of these divisions sends in all their labouring men to such a number as is required, who continue at the work for eight days, being allowed bread, meat, and fourpence a day for their labour, and the eight days being expired are relieved by the next division, till it goes round. Within the citadel on the north-east of the bay is the town, the passage to it by the water is between two strong batteries well planted with large cannon pointing every way, the batteries not above a musket shot from each other; this leads into the river of Brest which is narrow, but carries so much water that vessels of above 100 guns lie there, and this is one of the chiefest ports in France for laying up their great ships. A little way within the batteries is a strong boom across the river, which is no more open in day than just to allow room for a ship to pass in and out, and at night is closed up. At this time there lay here about a dozen men-of-war all I believe of the first rate. The principal part of the town is on the south side having nothing in it commendable, the churches mean, the streets narrow and foul, some good houses, many very indifferent; the Jesuits {ms folio 35b} were building a new church and monastery, but neither finished. The best thing about the town is the hospital, which is beautiful and very well served, but not very large. The walls and other fortifications of the town were now a raising so that no account can be given of them, but that they are about a mile in circumference. On the north side is either a part of this, or another small town, with a good quay before it which on the other side is but small and here reaches all along. What is most remarkable here is the Royal Magazine and Stores, wherein are all sorts of arms and ammunition, in great quantity and kept with excellent order. Besides the general every great ship has a particular storehouse, wherein is all 



---

p.41



 
manner of rigging and necessaries for the said ships, and their names written over the doors. There are several docks for building of ships, great forges for making of anchors and other iron work, yards and houses for the rope and cable makers, carpenters' yards, stores of iron, hemp, masts, and in fine all things requisite for the sea service in great quantity. In one of the docks I saw a great old tattered vessel, which is there kept as a memorial of her having fought, as they say, thirty galleys and come off with honour. We continued here about five weeks, being told daily we should sail {ms folio 36a} with the first fair wind, but it was only to amuse us, for most of the ships were not arrived, or fitted till long after our coming to Brest, and the arms and ammunition were not put aboard till a few days before we left it. This report was given out in order to keep us aboard, for by reason of our extravagancies committed before in the country there were no quarters or allowance appointed for us ashore, but provision ordered in the ships. Some continued ashore most of this time, but all could not do it, the town being excessive dear and lodgings so scarce that we paid half a crown a night for an ordinary bed. The encouragement to stay aboard was but little, the French officers giving us no manner of respect, and scarce affording to speak to us. Our provision was bad meat, and worse fish, very nastily dressed and as nastily eaten for want of table linen, butter of several colours, and but little of any of them, the best thing there was the wine, and that little, and indifferent. For lodging we had the soft planks, without anything to cover us but our own clothes, or else some scurvy hammocks among the seamen, which they several times maliciously cut down in the night. For quietness' {ms folio 36b} sake I took my bed upon the lockers in the great cabin during the whole time of my stay aboard. Several times it was ordered that all should repair to the ships but few obeyed, so it was given out sometimes that the wind was coming fair and we should sail, then all flocked aboard, but the next day they returned ashore. Thus we continued for about five weeks, as I said before, till


Thursday the 5th of May: the wind coming to south-east the Admiral and all his squadron weighed, and fell down 



---

p.42



towards the mouth of the harbour, but the wind then calming cast anchor again, the rest of the fleet stirred not. I was at first with all the Route put aboard the Entreprenant, a ship of about 60 guns, where we continued till the Sunday before we sailed, when several of us were removed to the Oiseau, of 45 guns, that was designed and under sail for the East Indies, but remanded, unladen, and fresh lading put in her to go with us. Before we leave the harbour it will not be amiss to give an account of what number of vessels our fleet consisted and their names. There were 25 men-of-war from 60 to 40 guns. 

1. L' Ardent commanded by M. de Château Renault, Admiral
2. {ms folio 37a}Le St. Michel, *commanded by* M. Gabaret, Vice-Admiral
3. Le Courageux *commanded by* M. Forraud, Rear-Admiral
4. Le François
5. Le Vermandois
6. Le Duc
7. Le Pendant
8. Le Fort—60
Le Léger
9. Le Précieux
10. Le Capable
11. L' Arrogant
12. Le Diamant
13. Le Furieux
14. Le Faucon
15. Le Modéré
16. L' Entreprenant—60
17. Le Neptune
18. L'Arc en Ciel
19. L' Excellent
20. Le Sage
21. L'Emporté
22. L' Oiseau—45
23. L'Apollon
24. Le Sérieux


Two frigates of 20, or 22 guns each, which the French do 
not call men-of-war, viz. 

1. La Tempête
2. La Présente


Eleven fireships:
 
1. Le Bouffon
2. L'Hercule
3. Le Pétillant
4. Le Maligne
5. L' Incommode
6. Le Terneuvie(?)
7. Le Déguisé
8. Le Gaillard
9. La Catherine
10. L'Inconnue
11. L'Éveillé



{ms folio 37b}Friday the 6th: in the morning the wind being at north-east the whole fleet weighed and sailed out, the wind held 



---

p.43



most part of the day at north-east and north by east; at night it came to north, and blew hard, the night overcast with a very thick fog, we run to westward.


Saturday the 7th: the wind blowing fresh at north-east we bore up north-north-west and north-west and by north, the night was fair but we made little sail.


Sunday the 8th: the wind continued at north-east and we bore up north-north-west all day, the night fair, but made little way. This day we discovered one sail, which, a frigate having chased and brought up, proved an Englishman bound for France and was soon after discharged. A Portuguese bound for London sailed through the fleet, which having hailed made her way. We lay by about noon for a while, and some consultation was held aboard the Admiral, after which we held on our course.


Monday the 9th: the wind continued and we lay close upon it to north-north-west and north-west, and by west about seven we discovered land and about noon came up within half a league of the shore, and found we were fallen ten leagues to leeward, the Admiral intending to have been {ms folio 38a} as far to windward, the shore we came up with was Castlehaven. We stood off again, and tacked to gain upon the wind. Towards evening on a sudden the Admiral fell off with the wind and steered west-south-west, then lay by and made little or no way all night. This morning a small vessel of Ostend was taken by one of our ships. Two English men-of-war were discovered and chased for some time, by which was guessed the fleet was not far off, which was the reason our Admiral changed his resolution of bearing up for **Kinsale**.


Tuesday the 10th: the wind still at north-east we continued our course west-south-west in sight of land till coming up with **Berehaven** or **Bantry Bay**, for two parts of it bear these several names, we bore to windward and stood in for about a league, anchored close under the shore four leagues from the bottom of the bay and town of **Bantry**. This afternoon intelligence being brought that the English fleet was seen, the Admiral ordered all the English, Scotch and Irish to the number of about 1,500 with all the money, arms, and ammunition 



---

p.44



brought from France, and four day's provision for each man, to be put aboard five fireships, the {ms folio 38b} two small frigates, and another small vessel, and so conveyed up the bay and landed. Which was accordingly put in execution, but the time being short, many were landed upon the rocks at midnight, none being permitted to stay aboard, although several pressed for it very earnestly. The night was spent in as much misery as can be imagined by them ashore upon the bare, uncouth rocks, it being very cold and no shelter to be had, and by us aboard the small vessels, which were so thronged there was scarce room to stand, much less to sit or lie down.


Wednesday the 11th, and 1st of May (st. vet.): for being come to shore I will hereafter follow this account, we weighed at break of day, the wind still at north-east, and the bay lies north-east and south-west, so we spent the whole day tacking. But at noon we discovered the English fleet making up to the French, who having before their anchors apeak weighed and met them, having the wind and tide with them. Particulars I cannot pretend to give an account of, but that we saw them near four hours hotly engaged, and then they fell down a till we quite lost sight first of the English, then of the {ms folio 39a} French; in the evening the latter returned and anchored where they were in the morning.[68](javascript:footNote('E680002-001/note068.html')) Just at sunset the wind calmed quite where we were, and we were towed by our boats into the creek where **Bantry** stands. This is an extraordinary bay, being between four and five leagues in length, everywhere wide, but more or less as some points butt out. The largest ships may anchor anywhere close under the shore, there being for the most part within 100 yards of it fourteen or fifteen fathom water, at the entrance into the creek about seven and more within. All round the bay are high rocky mountains with some few scattering cottages. This night much against our 



---

p.45



 
will we continued aboard, yet had we known the entertainment we were to find ashore, as bad as it was in the ships, we had chosen to stay in them.


Thursday the 2nd: we landed at **Bantry**, which is a miserable poor place, not worthy the name of a town, having not above seven or eight little houses, the rest very mean cottages. The least part of us could not be contained in this place, so most were sent two or three miles round to no better cottages to quarter. {ms folio 39b} Two nights that we continued here I walked two miles out of town to lie upon a little dirty straw in a cot or cabin, no better than a hog-sty among near twenty others. The houses and cabins in town were so filled that people lay all over the floors. Some gentlemen I knew who took up their lodging in an old rotten boat that lay near the shore, and there wanted not some who quartered in a sawpit. Meat the country brought in enough, but some had not money to buy, and those who had for want of change had much difficulty to get what they wanted, the people being so extreme poor that they could not give change out of half a crown or a crown, and guineas were carried about the whole day and returned whole. Drink there was none, but just at our landing a very little wort hot from the fire, which nevertheless was soon drunk; and good water was so scarce that I have gone half a mile to drink at a spring. About half a mile from this is the old town of **Bantry**, much like the new. Upon a hill over the town and creek is a fort built by **Cromwell**, now gone to decay but never of any considerable strength.


Friday the 3rd: we continued in this miserable place. Both days were spent in landing {ms folio 40a} the arms and ammunition that came with us. The **Earl of Clancarty**'s Regiment[69](javascript:footNote('E680002-001/note069.html')) came to town, and during our stay had no better quarters than the open fields without tents.




---

p.46


Saturday the 4th: much of the morning was spent in looking for horses; at last with much difficulty Mr. Lazenby,[70](javascript:footNote('E680002-001/note070.html')) afterwards a captain in Colonel Butler of Kilcash's Regiment, bought a little nag, on which we laid his, Captain afterwards Major Price's,[71](javascript:footNote('E680002-001/note071.html')) and my clothes in two portmanteaus, and having loaded our horse marched afoot driving him before us twelve miles to Dunmanway, a place consisting of only one gentleman's house and some scattering cabins. The road is all mountains very high, steep and rough, with few or scarce any houses near the way. Having sent before to take quarters we prevailed for money to get a good barn, where we made fire and had clean straw to lie on, conveniences that very many met not withal who were forced to stay all night in the open fields.


Sunday the 5th: marched six miles to **Enniskeen**, the first three like the day before, the other much plainer. This is a tolerable town, and appeared much the better to us after coming {ms folio 40b} from the miserable places before mentioned. Here we only refreshed ourselves, and went on six miles farther to **Bandon**, a considerable walled town, where we found good entertainment, though at this time it was ill-inhabited many of the richest being fled, after the king had most graciously pardoned their unnatural rebellion in presuming to take up arms and shut out His Majesty's forces upon framed fears and pretences.


Monday the 6th: marched twelve miles to **Cork**; in all this way there is not so much as a village unless such as consist of 



---

p.47



ten or twelve poor cots or cabins, inhabited by the miserable country people, who live only upon their potatoes and sour milk. The road is all rough mountain rocky way. Having marched these three days afoot I had great difficulty to reach **Cork**, both by reason of my weariness, as also the soreness of my feet, which kept me in excessive pain and anguish. I gave God thanks that I reached the town, where providence ordained we were stopped two days, by order to wit.


Tuesday and Wednesday, the 7th and 8th: all the company before intending to take no rest till our arrival at **Dublin**, which was also my {ms folio 41a} earnest desire, but finding myself unfit to march I was glad to be stopped to rest. Neither could I well stay behind my company, having spent most of what money I brought out of England and being disappointed of a bill I expected at **Paris**, coming away in haste, so that afterwards I was beholden to Mr. Lazenby whom I have before spoken of, and who lent me money in my want, without any farther acquaintance than what we contracted at Quimper Corentin, when some that were my friends in England refused to assist me. It was not therefore without reason I called him brother, as also Major Price, to whom also I owe many obligations we three having contracted a peculiar friendship and kept together from the beginning of our acquaintance with a true brotherly love, which we continued not only then but long after till the misfortunes of the times parted us.


Thursday the 9th: we set out having hired a man and horse to carry our clothes, and marched with much difficulty, the way being hilly and my feet very sore to **Rathcormack** a little town, which was very full, yet afforded {ms folio 41b} us good quarters.[72](javascript:footNote('E680002-001/note072.html'))


Friday the 10th: in the morning, we marched four miles to **Kilworth**, a small market town. Though the way was good, the excessive heat of the sun so overcame us that we were 
forced to take two or three hours' rest here, when venturing to set forward we soon found ourselves in as bad or rather a worse condition, it being just the heat of the day, and having a vast high and rough mountain to pass over which held for 



---

p.48



four miles and so tired us that we were glad again to take shelter in a cottage at the foot of the hill till evening, which being cool we travelled on four miles farther and a much better way with woods and much shelter to **Clogheen**, a little town that has some good houses, and a clear brook runs through the middle of it.


Saturday the 11th: we found the way good, yet having marched but three miles to a village whose name I learned not, but a river runs through it and over it stands an old castle, I was so spent with heat and the continual fatigue that I had been left behind had I not with much difficulty hired a horse, the people being very fearful, because many upon pretence of hiring horses {ms folio 42a} for a few miles went quite away with them; thus I rode five miles to **Clonmel**. This is one of the prettiest towns I have seen, though small. It is walled, and famous for the opposition it made against the former usurper, **Oliver Cromwell**; the principal streets are in the form of a cross with a handsome town house much about the centre of it, the streets clean, and the houses well built, a navigable river running by the side of it next which are the ruins of a large old convent, then in possession of the Franciscan friars. Having found by experience that we could not march in the heat of the day, we resolved for the future to travel all or most part of the night, and rest the days, and accordingly we stirred not till the following evening, which was Sunday the 12th: and then set out about seven of the clock and marched a good rate till eleven, at which time we reached the nine mile house: the first five miles are plain good way, the other four hilly and very rough. This is a lone house, however we wanted not conveniency to rest here till break of day.


Monday the 13th: early we marched five miles {ms folio 42b} to **Callan**, now a very poor place, but by its ruins appears to have been somewhat considerable, having refreshed ourselves here during the heat of the day, we went on in the evening six miles to **Kilkenny**.[73](javascript:footNote('E680002-001/note073.html')) I will not here pretend to give any 



---

p.49



 
account of this place, though it well deserves it, having some notes of it in my former travels, which if it please God to restore me to my native country I may perhaps find and join to these, nor had I now time or ease to give a worthy description of this place.


Tuesday the 14th: in the evening being all ready to set out, we loaded our small luggage on a car we bought in town, putting to it a large horse belonging to Captain Arnold[74](javascript:footNote('E680002-001/note074.html')) who here joined with us and had a boy to drive it, and being eased of that trouble I stopped in the street to speak with an acquaintance till all my company marched out of town before me, and thinking to overtake them I lost my way within a mile of the town, till meeting with a countryman he put me again into the road, where I travelled alone three or four miles and then overtook one Mr. Brett,[75](javascript:footNote('E680002-001/note075.html')) whom I had before known in {ms folio 43a} England. But he being afoot as well as I, a corpulent man and very lame, I could not prevail with him to go any farther than to a small farmer's house seven miles from **Kilkenny**, where having after much entreaty obtained admittance we found a good will in the people but no great refreshment, they having nothing to eat or drink but milk, a diet I was not yet used to, and clean straw to lie on. As it was we took our rest till about three of the clock on


Wednesday the 15th: in the morning, when being earnest to find my company, we went on forgetting to inquire for them at **Wells**, a small village a mile from our place of rest, till we went two miles farther to **Leighlinbridge**, where is only a large stone bridge over the **Barrow**, two good houses of entertainment 



---

p.50



and a few small cabins, I was much concerned after strict inquiry to hear no news of my company. Being thus restless having halted a little while I resolved to go on, and at our setting out a countryman informing us there was one Brett, a rich farmer, on the other side the river, and that it was as near a way to **Carlow** as that we intended to take, I was with difficulty persuaded {ms folio 43b} to take that way in hopes to get horses of the said farmer, only because my new companion's name was Brett. In fine we went, and though strangers for the name's sake found a kind reception, and had two horses lent us as far as **Carlow** and a boy to bring them back. It was early when we came to the town, and to my great satisfaction found my former company, and having resolved to go forwards at night, though I desired it my friend Mr. Brett would by no means part with the horses, but kept both them and the boy (not regarding his tears) with him till night, when we set out on promise to carry them but five miles farther, but being come to **Castledermot**, and finding the conveniency so great, we made bold with them for three miles more to **Timolin**, which we reached near midnight, and there rested till morning.


Thursday the 16th: having dismissed the boy with the horses, we marched afoot seven miles to **Kilcullen Bridge**, and having there refreshed ourselves till evening, went on five miles farther to the **Naas**, a good town though at this time decayed, the walls of it as many other things are gone to ruin. About a mile from the town in some old walls is preserved the memory of a stately seat, intended though never finished {ms folio 44a} by the loyal Earl of Strafford when Lord Lieutenant of Ireland. Here first of all we found difficulty in getting quarters, and, having got a billet of the sovereign on an inn, were refused not only beds, but fire and meat and drink for our money, till finding the perverseness of the people we possessed ourselves of a room, broke open the cellar doors, and took out meat, wine, and whatever we found for our use; our landlord having made his complaint to the sovereign, and, meeting a rebuke instead of redress, served, and attended us for the future with great diligence, and found 



---

p.51



 
all things necessary, which we paid for to his content, though for his rudeness he deserved it not, and it was left to our choice by the sovereign. The man being an Irishman and a Catholic made his ill carriage towards us appear the more strange, but his religion and country he thought would bear him out. This was the first violence in all my travels hitherto I offered to anybody, and the world may judge with how much justice I might force my way to meat, drink, and a bed for money, being hungry, dry and weary, and having the government to back me.


Friday the 17th: being somewhat cool, we marched with ease six miles to Rathcoole, and having {ms folio 44b} rested a sufficient while, with great satisfaction marched the remaining six miles to **Dublin**, our so long wished for port.[76](javascript:footNote('E680002-001/note076.html')) Yet was it not without some shame and trouble I entered the town afoot and all covered with dust, having lived there sometime before in esteem and with splendour, and fearing to meet with many that had formerly known me in a prosperous condition. And yet what greater glory or honour could I wish than to be seen and known a signal sufferer for my religion, my king, for justice and loyalty. But man's ambitions has always aspirations, and covets the grandeur of the world: it feeds not itself with the 



---

p.52



 
true and inward knowledge of the honour due unto virtue, but is still greedy of outward appearances. For although the principal happiness of man ought to consist in the innocence of his conscience and justice of his actions: our weak nature is so much depraved that we value not what we are but what we are thought. Most men aspire not to be truly virtuous, but to be esteemed so, and even those who are endowed with any peculiar virtues do place the greatest satisfaction in having them known, and study how to make them shine the brighter in the eyes of the world. The scholar breaks his rest, flies company, lives retired, scarce allows himself time to eat or sleep, minds {ms folio 45a} nothing but his books, spends his days in reading and the nights in thinking, and this not to improve himself or instruct others, but that his works may be carried from hand to hand, his name honoured, and his memory preserved. The lawyer continually turns over his volumes, roars at the bar, takes in hand the wrongful as well as the righteous cause, and why but to gain applause, to be esteemed the great interpreter of the law, to rise in time and be seated on the tribunal, and to be gazed at and admired by the multitude. The soldier endures the scorching heat of the summer, and piercing cold of winter in the fields, lies on the ground, suffers hunger and thirst, and daily exposes himself to all dangers that his valour may be extolled, his sufferings recorded, and his magnanimity celebrated. It may perhaps be answered these and all others labour and toil to acquire riches, and merit preferment. But what is the use of riches only to shine brighter than others in the eyes of the people, and what is preferment but to stand a step above the rest, and be more seen and taken notice of: since the country gentleman of a moderate estate, eats, drinks, sleeps, {ms folio 45b} and indulges himself as well, or rather more than the greatest general, the ablest lawyer, the profoundest scholar or the mightiest monarch in the universe. And again for the practice of virtue and study of piety, none so free or so truly fitted as the man who, content in a middle estate, is not drawn away with the noise and profaneness of the soldier, not distracted with the subtleties and pride of the scholar, not involved in 



---

p.53



 
the cares and injustice of the lawyer, nor plunged in the abyss of thoughts, business, ambition and vanities that attend such as follow the court or converse in affairs of state and government. But I have made too long a digression did not my long continuance in **Dublin** allow of it, and since the occurrences during my residence there cannot merit a daily observation as hitherto in my travels, I will only make some general remarks and afterwards go on with my following misfortunes.


As **Paris** or St. Germains was the first place of rest, where every one that followed the king intended to take the measures of his {ms folio 46a} future proceedings, so being commanded from thence and His Majesty residing in **Dublin**, that was the second harbour, where every one proposed to refit himself for the residue of his long voyage, and to weather the ensuing storms. Formerly in England peace flourishing there, and I being settled in a good civil employment had laid aside all thoughts of any military preferment, but now the king having more need of soldiers than receivers, and my design in following of him being to signalize my loyalty, and be serviceable to him, not to seek my own ease, conveniency or interest, I resolved upon a soldier's life, at least till such time as it should please God to reenthrone His Majesty. And though my experience in martial affairs could not entitle me to any considerable post, and consequently enable me to do any extraordinary service: yet I concluded in whatever capacity employed I might be useful, and doubted not but for the present my zeal would supply what was wanting in experience. 
The methods to be taken to be employed in the army were, first by immediate application to His Majesty either by word of mouth or by way of petition. {ms folio 46b} The former was the more general, for even kings in distress grow cheap, and their very friends usurp an unbecoming familiarity with them; but nature and my education had engrafted in me such a reverence for Majesty that though I daily saw others (who had less right or pretensions than myself) boldly breathe their pretensions in the king's ears, and that to such a degree of freedom that one who was but an ensign in England durst pull him 



---

p.54



by the sleeve because he passed without taking notice of him; yet I could never presume to give myself the liberty of speaking to him, and the excessive forwardness of others made me the more backward. The latter by petition was both modest and likely to succeed: but seeing him daily perplexed with the continual importunities of so many I concluded it more respectful to find out some other expedient, though not so advantageous to myself, than to add to his great burden of care. The second method was going to **Londonderry** then besieged by the king's forces, to serve there as a volunteer in some regiment till places should fall, and preferment become due. This suited best with my inclinations, but being destitute of money to subsist there, and having no horse to carry me down, I was forced to lay aside the thoughts of it, though it was the thing I most earnestly desired. These two mediums laid aside, the third and last was to try friends in order to be either assisted with {ms folio 47a} money or recommended to some regiment. But friendship was grown as rare in Ireland as loyalty in England. There were many who during my prosperity, when they thought I should have no occasion to make use of them, had made me great offers of service if occasion should offer, but with my condition their minds were changed. Among the rest I cannot but mention the Earl of Limerick[77](javascript:footNote('E680002-001/note077.html')) in whose ancient acquaintance with my father and the knowledge he had of me I reposed no small confidence. The Lord Primate of Ireland, F. Dominick Macguire,[78](javascript:footNote('E680002-001/note078.html')) with whom while 



---

p.55



 
chaplain to Don Pedro Ronquillo[79](javascript:footNote('E680002-001/note079.html')) the Spanish Ambassador in England, I had a particular familiarity, and the Duke of Powis from whom in London and Wales I had received some assurances of favour. The first of these received me so coldly that I never made a second application to him. In the second I found not much more encouragement, and all I received was formal excuses. The third and last, after many fair words 



---

p.56



having endeavoured to incline me to apply myself to a civil employment, which I utterly refused, would propose or hear of nothing but riding in the guards, and finding by this he only strove to shift me off I consented to it only to try the utmost of his promises. But finding me comply with that he soon fell off, telling me none were to be admitted into the guards {ms folio 47b} but such as brought horses, which he well knew I could not, nor was there any such thing, for many even to the degree of footmen were afterwards received and the king mounted them. Forsaken thus by all I had put my confidence in, I passed many days in melancholy thoughts without making application to any, since I found there was no faith in the promises of the great ones, and friendship was but a mere name, there being in reality no such thing to be found among us. How much sorrow and affliction I knew during the time I was without employment is not to be expressed or easily conceived by any but such as have had some share in the like misfortunes. For what greater calamity than to be in a strange country without money, destitute of friends, and this a man that had never known want and had only taken a voluntary exile for the love of his prince. Such as were able to relieve or assist me in the midst of plenty pleaded poverty, and either laid up for imaginary dangers of future want or else blinded with that ‘Auri sacra fames’, could not or would not see my condition, or at least reach out their hands to lift me from the affliction they saw me fallen into. It is true I made not my condition known to many, for not being used to want I blushed to think that any man should but imagine I was in necessity. It was then a common thing and many gentlemen laboured under as bad {ms folio 48a} circumstances as myself, but my proud heart could not be brought to confess poverty, but on the contrary endeavoured to hide and conceal it. Many had found shifts to maintain themselves, which I could not make use of as not just or honourable, and I thank God through all the course of my misfortunes I do not know that ever my thoughts dictated to me to strain my conscience to any unlawful or my reputation to any uncreditable action. Yet such was the course of the world that many who pretended



---

p.57



 
to have followed His Majesty for honour and conscience by their base and unwarrantable proceedings not only were rendered scandalous themselves in the eyes of all men, but gave occasion to malicious reflections on His Majesty's most righteous cause from the foul mouths of his malicious enemies by its being asserted by such vile wretches. But let not the profane slanderers of the best of kings think this a justification of their traitorous aspersions. Christianity is not of the less value for the foul actions of such heretics and schismatics as they, the Catholic religion for having some ill livers, or His Majesty's cause for being defended by some libertines. Neither is this a reflection upon those truly honourable gentlemen, who through a true sense of loyalty {ms folio 48 b} and love of their religion quitted their country and fortunes: or such strangers who upon the same motives resolved to expose themselves to all dangers and hardships in so just a cause. The libertines I speak of were such whose debts or scandalous lives attended by all manner of crimes had rendered England unsafe for, and therefore they laid hold of this opportunity to palliate shame or fear that drove them away: or such whose desperate fortunes hoped some better change in the common calamities, and for their private interest valued not the ruin of their country. Men who thought a good cause would justify all villanies, who esteemed it a Christian liberty to rob their brethren, and a meritorious act to plunder the wicked Egyptians or Protestants, without any allowance from God and contrary to the express commands of their prince. Of these several gave us at last as good a proof of their loyalty as they had done before of their virtues, by deserting and running over to the rebels, when to punish theirs and our sins it pleased God to suffer His Majesty's forces to be defeated, and us to be reduced to the miseries I shall hereafter mention. To name these objects of scorn and contempt is too tedious, nor do I think such as blotted themselves out of {ms folio 49a} the list of true loyalists ought to fill a place in this short compendium of loyal sufferings. Some did not blush to vex His Majesty with repeated petitions magnifying their losses, multiplying their sufferings and wants, 



---

p.58



 
suing for relief till overcome by their perpetual importunities they forced him to lay out his small treasures to maintain their extravagances. Others more inhuman, though entrusted and entertained in the king's service, made use of the very power he had given them to sell him and betray his interest. As, not to instance any more, some did in the case of seizing serviceable horses to mount the guards and other troops; when some of the highest rank protected for money the best horses though belonging to Protestants, and, others having bought many with the king's own money put into their hands for that use, sold them afterwards again for their own private advantage; notwithstanding the urgent necessity of mounting the guards and other troops, and to the great detriment of His Majesty's service. To relieve my present necessities I sold what most conveniently I could spare by degrees as necessity pressed till I was obliged to part with some rings, among the rest one a particular token {ms folio 49b} of my father's, which much troubled me. But necessity has no law, for it brought me to part with the hilt and pommel of my sword, which were silver, and supply their place with brass; that I might truly be said to live by my sword, though not then a soldier but in my wishes and resolutions. Having thus struggled long with my ill fortune, at length it pleased God to send me some present relief by the hands I least expected it from, to wit a Protestant, one Mr. Hunt,[80](javascript:footNote('E680002-001/note080.html')) whom I had formerly known and been kind to when he was yeoman of the wineseller to the then Lord Lieutenant of Ireland, the Earl of Clarendon.[81](javascript:footNote('E680002-001/note081.html')) This man meeting and inviting me into a tavern perceived I suppose by my appearing somewhat dejected from whence it proceeded, and, very generously of his own accord without the least 



---

p.59



motion made by me, offered to lend me £10 upon my note, which he as freely performed the next morning. I cannot but think it a very worthy remark that in such times a man should so generously trust me, when the war, hindering a commerce with England, took away the greatest probability of payment, when my life was so uncertain being resolved for the army, when Catholics would not assist one another, than for a Protestant unlooked for to offer relief to a Catholic and in fine when repeated promises of friendship were cancelled, {ms folio 50a} a slender and long interrupted acquaintance to take place and give them all an example of sincerity and justice. It has not been yet in my power (though I repaid the money) to requite the kindness, but God, who has given me a grateful heart to acknowledge, I hope, will, when our sins are sufficiently punished and His anger appeased, put me in a condition to make a competent return to such obligations. And if ever I live to see prosperity in this world it shall be my study to appear grateful to such as have been friends to me in my troubles. All this while I had no prospect of any employment, till the siege of **Londonderry** being raised,[82](javascript:footNote('E680002-001/note082.html')) and the forces that were there dispersed into several garrisons, many of the officers flocked to court, and among the rest Mr. Ignatius Usher[83](javascript:footNote('E680002-001/note083.html')) whom I have before mentioned in my passage from England, and then a captain in the Right Honourable the Lord Grand Prior's Regiment. He, seeing me at court without any employment and knowing my resolution was to serve in the army, presented me to the Lord Grand Prior who immediately gave me the promise of a lieutenancy in his regiment, and a few days after delivered me the commission. Thus what all my pretended powerful friends would not effect in near three months was done with only one word in less than a week by him I least expected it from, and I was settled in a post to my own satisfaction for the present, not at all doubting very soon to reach preferment.


{ms folio 50b}As I do not pretend to write a history or give an account of the particular transactions of the times, but only as far as I was 



---

p.60



 
concerned or where I was present myself, so having spent much time in speaking of my private affairs it will not be amiss to set down some few observations of the general state of affairs, during this my vacation from business, though not from sufferings.


At my arrival in Ireland the face of affairs was such as seemed to promise a prosperous success to our undertakings, a speedy restoration to the king, and a glorious reward to all our sufferings.[84](javascript:footNote('E680002-001/note084.html')) Several small rebellions breaking out in the kingdom were suppressed, the rebels in many encounters worsted and forced to shut themselves up in garrisons, almost all the kingdom quietly settled under His Majesty's obedience, and **Londonderry** and **Enniskillen** seemed rather, despairing of pardon, to prolong the punishment due to their obstinacy than 



---

p.61



to hope to withstand His Majesty's arms. **Enniskillen** was not looked upon as a place of consideration having received little addition of strength from art, and what it had from nature being only a great lough or lake wherein it is seated and all men concluded its fate depended wholly upon **Londonderry**, and the conquest of the one would produce {ms folio 51a} the surrender of the other. **Londonderry** was reputed a place of no strength, having only a bare wall without any outworks to support it, the garrison was represented as raw undisciplined men, full of divisions and subject to no command, the multitude within great and provisions very short. In fine nothing was thought of could obstruct the speedy conquest of those so much contemned garrisons. In this assurance of our own strength and the enemy's weakness the English exile flattered himself with the thoughts of a speedy return to his country, and the Irish proprietor thought of nothing but entering upon his estate and driving out the new possessor, the statesmen new modelled the government of these kingdoms, and the soldier divided the spoils of the country, and assigned himself the rewards of his labours. The event hath shown how wild these conceptions were, and reason might have informed any understanding person, whose passion or mistaken zeal had not blinded him, that the posture of our affairs was far different from what was represented, and the methods then followed very unlikely to bring things to that issue every one expected. I make no pretence to the spirit of prophecy, yet scarce any misfortune has befallen us but what {ms folio 51b} I have foreseen and told several, who can bear me witness of this truth. Nor do I aspire to be esteemed a statesman or politician, and yet I could not but make some reflections upon the manner of our proceedings and the then state of our military and civil government. What our army either was or might be made is very hard to give an account of. The common computation was incredible, for most men reckoned the whole nation, every poor country fellow having armed himself with a **skeine** as they call it or dagger, or a ropery like a half pike, weapons fit only to please themselves, or else to put them in a posture of robbing and plundering 



---

p.62



the whole country, under pretence of suppressing the rebellious Protestants. The insolences committed by this sort of people, commonly called Rapparees, were such that having overstocked themselves with other men's cattle they destroyed millions throughout the kingdom only for their hides or tallow, and sometimes only to exercise their malice, leaving the carcasses to rot in the fields.[85](javascript:footNote('E680002-001/note085.html')) To return to the point our muster-rolls run high, every officer being quartered near home the better to enable him to raise his men or rather to put it into his power to muster all the rabble of the country, which when he was to march towards the enemy either he had no right to command or else they {ms folio 52a} deserted. I am an eye-witness that regiments that mustered 700 and upwards at home came not into the field or even to **Dublin** 400 strong. It may be objected the army at first not being paid there was no reason for the officers to cheat, but I answer the daily expectation of receiving money from France made them fill up the muster-rolls though not the companies: besides the reputation of raising so many men was some encouragement, and the obligation they were under from their very commissions,



---

p.63



which were given upon condition to furnish the number of men for the service. What was worst of all the people, greedy of novelties and ignorant of the dangers and hardships attending the military life, flocked to be soldiers as if their whole business had been to live at ease and rifle their enemies; but when they perceived how dear they were to buy their bread and liberty, rather than expose their lives or undergo the labours and wants a soldier is often exposed to, they deserted in vast numbers, returning to their former security, slavery and beggary on the mountains. Yet if the strength of an army had consisted in multitudes, the number of regiments might have made some amends for their weakness. But the want of discipline and experience, which we conceited in our enemies, and which made us despise them, was the heaviest misfortune we {ms folio 52b} laboured under ourselves. Our men were newly brought from the mountains, used to live in slavery without the use of any weapon: the most of them had never fired a musket in their lives. A people used only to follow and converse with cows, so hard to be made sensible of the duty of a soldier or be brought to handle their arms aright, that it was difficult to make many of them understand the common words of command, much less to obey them. Besides their natural uncouthness, they are stubborn and conceited, to be governed with rigour and severity, not to be wrought upon with lenity and gentleness; for by experience I have found they not only fear, but respect and love the officer much more that beats them daily without mercy than him that cherishes and carries a light hand over them. They will follow none but their own leaders, many of them men as rude, as ignorant, and as far from understanding any of the rules of discipline as themselves.[86](javascript:footNote('E680002-001/note086.html')) This was the utter ruin of the army, none fitter to raise men than he that had been ever bred in the mountains. When raised there was 



---

p.64



no respect from soldier to officer, they were all fellow mountaineers. The commissioned officer could not punish his {ms folio 53a} sergeant or corporal because he was his cousin or foster-brother, and they durst not correct the soldier lest he should fly in their face or run away. These officers had seen and knew no more than their men, and consequently understood as little how to exercise or train them; every one thought himself qualified enough to bear a commission if he could march before his men, and repeat by rote the words of the common exercise. For want of arms most of the army was taught the little they learnt with sticks, and when they came to handle pike or musket they were to begin again; though I knew a colonel who said his regiment could exercise to admiration before ever they had handled arms. Many regiments were armed and sent upon service who had never fired a shot, ammunition being kept so choice that they were never taught to fire, and it is hard to guess when these men were upon action whether their own or the enemy's fire was most terrible to them. And the commanders, it has been often observed, have not only wanted valour to lead on or conduct to post their men to advantage but through ignorance have run themselves into dangers and then cowardly and basely been the first that betook themselves to a shameful flight. {ms folio 53b} These miscarriages were so far from being punished that they were excused, and palliated; the very reasons that ought to be urged as an aggravation of the crime, and consequently of the punishment, were offered and received as extenuations of the offence; as the inequality of numbers, being surprised, the disadvantage of ground, want of ammunition, and the like. Nor was this all. The cowardice of the officers was retorted upon the soldiers, and I have known a commander preferred for quitting his post, when the poor soldier suffered for the same. Particularly in the defeat of the Lord Mountcashel[87](javascript:footNote('E680002-001/note087.html')) I observed some that never looked back till they 



---

p.65



came to **Dublin**, and others that lay in ditches were more countenanced than those that had brought up the rear in some order; nay those who had quitted their horses to tread the bogs and lost their very boots, shoes, pistols, and swords to run the lighter, were the men who carried it highest in **Dublin**. I do not design this to have it thought the private men were not faulty, they have given us too many examples of their baseness and want of courage; but doubtless had their leaders been such as they ought many enterprises {ms folio 54a} had met with better success. Nor is it a reflection on those worthy gentlemen, who understood their duty, had a sense of honour, had been abroad or served some time here. This will be found 



---

p.66



for the most part to touch only those, who from the plough, from following of cows, from digging potatoes and such-like exercises, because they had a few men to follow them, or bore the name of a good family, were put into commission without experience, without conduct, without authority and even without a sense of honour. Perhaps some may say this looks like an aspersion upon the king, who was then present, and by whose authority the army and kingdom were governed; but I have always had so great a veneration for Majesty, as not to suffer my very thoughts to censure or judge of the least action of my sovereign. Princes are said to see and hear all things, but they see with other men's eyes and hear with other men's ears. They, and only they, were guilty of all miscarriages and oversights who recommended and preferred unworthy persons, who palliated base actions and stifled the truth for their own private advantage to the great detriment of the public. Such a considerable number of experienced officers had {ms folio 54b} followed the king out of England and France, as would have sufficiently supplied the want there was in the army, have well disciplined those raw men, and given them a good example of courage and resolution. These were laid aside and made useless upon pretence they had no interest in the country, that the people would not follow strangers, and that they were unacquainted with the manner of governing them. Lest so many gentlemen whose zeal had drawn them so far to serve His Majesty should perish for want of bread some expedient must be found, which was to give them subsistence as officers in second or reformed, that they might assist and instruct the effective, whose pride was such they would choose rather to live ever in their ignorance than owe their instruction to those who had learnt their experience with many labours and dangers. From this beginning sprung that multitude of seconds and reformados that the kingdom afterwards swarmed with. The officers of every regiment that was broken were put upon this list, nay any that could find no other way of maintenance and had but the least acquaintance with a field-officer was thrust in, and at last it came to that pass {ms folio 55a} that they were foisted upon regiments at a muster 



---

p.67



without king or general's knowledge. Not to speak of others, in the Right Honourable the Lord Grand Prior's Regiment wherein I serve, though but thirteen companies, we had at one time ninety-four officers. These supernumeraries, seconds, reforms or what you please to call them, were of no use to His Majesty's service, and a prodigious increase to the charge of the army. Having taken in hand to speak of the army, my proper sphere, I have dwelt long upon it, and will therefore only give some small remarks upon other occurrences and proceed. One of the things which lulled us asleep and sunk us in a deep security and confidence of our strength was the power of France, which was so extolled in all its particulars, and so magnified in the supplies they sent us and the success of their arms, as if the good fortune, riches, grandeur, and justice of the world had been centred there, and all the universe besides stripped and left naked to glorify that nation. It was not thought enough to cry up the advantage of the French at **Bantry** over a single squadron only of the English fleet into a complete and glorious victory, though never a ship taken or sunk or the pursuit followed. Every day supplied us with fresh fables of the {ms folio 55b} entire defeat of both English and Dutch fleets, and with hyperbolical and monstrous relations of the greatness of the French both as to the number and bigness of ships: whilst both the former, which for so many years had been the terror of the seas and found none to contend with about the sovereignty of them, but between themselves, were vilified to such a degree as if they had been but a few Algiers pirates or Newfoundland fishermen. The incredible number of arms reputed to be brought from France would have furnished **Xerxes**' army and they, added to what were before in the kingdom, made not up 50,000 men. The millions of money spoken of would have impoverished Croesus and broken the bank of Venice, if drawn from them, and the king, to supply the pressing necessity of the army, was forced to coin brass, authorizing it to pass current as silver or gold by proclamation with a promise to make it good at his restoration to the throne. The first of this money was shillings and sixpences, afterwards it came 



---

p.68



to half-crowns, and at last to crown pieces. As to the stamp, they were all alike as far as half-crowns, differing only in bigness and the mark of the value. On the one side the king's head and round it Iacobus II Dei Gratia.[88](javascript:footNote('E680002-001/note088.html')) On the other the imperial crown and cross {ms folio 56a} sceptres; over the crown the value of the piece as VI, or XII, or XXX; under the crown the month the piece was coined in, on the side of it IR, and round it MAG . BR . FRA . ET . HIB . REX . and the year of our Lord. On the one side of the crown pieces was the king on horseback and about it, IAC . II . DEI . GRA . MAG . BRI . FRA . ET . HIB . REX. On the other side the arms of the four kingdoms in a cross as they are upon guineas with the crown in the centre, the words ANÓ . DOM . over the scutcheons of Scotland and Ireland and under them the year in figures, about it this motto, CHRISTO VICTORE TRIVMPHO.[89](javascript:footNote('E680002-001/note089.html')) Though we stood so much in need of French succours, and their aid and actions were so much extolled, yet the persons of some few Frenchmen were not acceptable to the Irish, and the English though never so loyal were suspected and hated. For as it is said of princes, that they love the treason but hate the traitor, so many here pretended to love the loyalty but abhorred the person of an Englishman. And notwithstanding there were but a few of both nations in the kingdom, especially near His Majesty, the clamour against English and French advice was no less than was one in England against popish councillors and French pensioners. To satisfy the humours of the people a parliament {ms folio 56b} was called,[90](javascript:footNote('E680002-001/note090.html')) which having sat many days granted the king a subsidy that never turned to any account, but the 



---

p.69



chief thing they did was to repeal the Act of Settlement.[91](javascript:footNote('E680002-001/note091.html')) Nothing could be more pernicious, or a greater obstruction to 



---

p.70



the king's service than was this parliament. First it drew to and kept in **Dublin** all that time the nobility and principal gentry who before were dispersed at their posts, raising or encouraging and exercising their men or upon actual service. Secondly, the Act of Repeal being passed, private interest outweighing the public good, every one quitted his command to enter upon his estate, to settle his house, and improve his fortune. And the estated men not content to forsake the service themselves kept with them for their own use all the better sort of country people, so that none but the most rude and useless sort of mountaineers took to the army. Thirdly, the Protestants, who before might have perhaps stood neuter or hoped for some reconciliation, their estates being taken away, were in a manner necessitated to espouse the rebellion, which alone could restore them to their, although unjustly yet long enjoyed, fortunes. For it was not to be doubted that those men, who had rebelled for only the fear of losing a religion they were never in possession of, would prove the most incorrigible traitors, being actually deprived of those estates they had so long kept in their hands. Thus it appears by the sitting of this parliament {ms folio 57a} the army was much damaged and weakened, the king lost the assistance of many of his friends and gained a vast number of irreconcilable enemies. Lest I seem too much to intermeddle in affairs of state so far elevated above my station, I will pass by many things worthy to be noted in the management of the siege of **Londonderry**.[92](javascript:footNote('E680002-001/note092.html'))


---

p.71



As that we sat down before it with not the fourth part of the number that was within, and, though supplies were continually marching down, the strength of the besiegers was not much increased, the numbers being so small they only made up for those that daily deserted. That for battery there were but two or three pieces which played only upon great days, and that with much moderation, ammunition being scarce and the charge of carrying it so far great. That the mouth of the lough or bay through which only relief could come to the town was not either choked by sinking some vessels in it or secured by a strong boom, but only a chain laid across it tied at both ends on the shores with some old ropes, which being rotted by the weather or not sound before gave way to the first small vessel that attempted the passage. Which vessel though stranded and very near our blind gunners could or would not hit, though they made several shots at her. {ms folio 57b} That having gathered all the rebellious Protestants of the country about, and placed them between the town and our trenches to force the besieged either to relieve them, which would put an end to their provisions, or to surrender rather than see all 



---

p.72



their friends perish, not only they were very soon dismissed with protections, but among them hundreds of useless people that came out of the town, which was a great relief to the besieged being eased of so many mouths, and a disreputation to the king's party as wanting resolution to go on with the enterprise undertaken or maturity in their counsels.[93](javascript:footNote('E680002-001/note093.html')) To be short we were blind to see our own faults and had Argus eyes to discover the enemy's, or rather we looked for motes in their eyes not regarding the beams in our own. Next to **Londonderry**, **Belturbet** defeat for the shame of it deserves to be buried in perpetual oblivion, and therefore I will say no more of it.[94](javascript:footNote('E680002-001/note094.html'))


It is time to conclude this discourse, and with it put a period to this first part of my travels and journal from the time I left England till I departed **Dublin** to go to my command in the Right Honourable the Lord Grand Prior's Regiment.[95](javascript:footNote('E680002-001/note095.html'))




---

p.73


The time of this my peregrination was about nine months, and the length of my travels mentioned in this part 1,146 
miles as will appear by the following computation. {ms folio 58a column 1} 




| The Distances from Town to Town are as follows | Miles |
| --- | --- |
| From Welshpool to Wrexham | 24 |
| Thence to Holywell | 12 |
| Thence to Chester | 13 |
| Thence to Whitchurch | 14 |
| Thence to Newport | 12 |
| Thence to Four Crosses | 14 |
| Thence to Coventry | 26 |
| Thence to Northampton | 24 |
| Thence to Newport Pagnell | 10 |
| Thence to Dunstable | 14 |
| Thence to St. Albans | 10 |
| Thence to Barnet | 10 |
| Thence to London | 10 |
| From London to Calais | 93 |
| p.74 |
| Thence to St. Omer | 16 |
| Thence to Aire | 6 |
| Thence to Auchel | 6 |
| Thence to St. Pol | 8 |
| Thence to Doullens | 12 |
| Thence to Amiens | 16 |
| Thence to Breteuil | 14 |
| Thence to Clermont | 14 |
| Thence to Lucheux | 14 |
| Thence to St. Denis | 14 |
| Thence to Paris | 6 |
| Thence to St. Germains | 12 |
{ms folio 58a column 2}| From Paris to Orsay | 8 |
| Thence to Ernée | 8 |
| Thence to Étampes | 12 |
| Thence to Outarville | 12 |
| Thence to Toury | 8 |
| Thence to Artenay | 8 |
| Thence to Orleans | 12 |
| Thence to Nantes | 172 |
| Thence to Savenay | 21 |
| Thence to Donges | 6 |
| Thence to Herbignac | 21 |
| Thence to Kervoyal | 15 |
| Thence to Vannes | 12 |
| Thence to Auray | 9 |
| Thence to Landevant | 9 |
| Thence to Hennebont | 9 |
| Thence to Quimperlé | 15 |
| Thence to Rosporden | 15 |
| Thence to Quimper-Corentin | 12 |
| Thence to Locronan | 9 |
| Thence to Crozon | 18 |
| Thence to Le Faou | 3 |
| Thence to Brest | 9 |
| From Brest to Bantry Bay | 240 |
| From the mouth of the Bay to the town | 12 |
| p.75 |
{ms folio 58b column 1}| From Bantry to Dunmanway | 12 |
| Thence to Enniskeen | 6 |
| Thence to Bandon Bridge | 6 |
| Thence to Cork | 12 |
| Thence to Rathcormack | 10 |
| Thence to Kilworth | 4 |
| Thence to Clogheen | 8 |
| Thence to Clonmel | 8 |
| Thence to Callan | 14 |
| Thence to Kilkenny | 6 |
| Thence to Leighlin Bridge | 10 |
| Thence to Carlow | 5 |
| Thence to Castledermot | 5 |
| Thence to Timolin  | 3 |
| Thence to Kilcullen Bridge | 7 |
| Thence to the Naas | 5 |
| Thence to Rathcoole | 6 |
| Thence to Dublin | 6 |
| The distances between the most remarkable towns thus |  |
| From Welshpool to Holywell | 36 |
| From Holywell to Chester | 13 |
| From Chester to London | 144 |
| From London to Calais | 93 |
| From Calais to Amiens | 64 |
| From Amiens to Paris | 60 |
| From Paris to St. Germains | 12 |
| From Paris to Orleans | 68 |
{ms folio 58b column 2}| From Orleans to Nantes | 172 |
| From Nantes to Brest | 183 |
| From Brest to Bantry Bay | 240 |
| From the mouth of the Bay to the town | 12 |
| From Bantry to Cork | 36 |
| From Cork to Dublin | 97 |
| In all  | 1,226 |



[96](javascript:footNote('E680002-001/note096.html'))




---

p.76


Which is the sum of the distance of the straight roads allowing but two miles to a league from **Calais** till you come to **Nantes**, though in and near the low Countries the leagues are longer, and in Brittany where they are very large three miles to a league, the same upon sea. But the miles in England and Ireland are set down according to the known and generally allowed computation. This is too great a space of ground for so short a compendium, and much more might be expected to be said of so many remarkable places and occurrences, but my misfortunes gave me not leisure to enlarge 
myself.


{ms folio 59a}Thus I have run through this first part of my pilgrimage, and what is this but a shadow to the remaining part of my toils, sufferings, and afflictions. Yet since the heathen said Dulce pro patria mori, I may well add Dulcius pro fide, et rege pati. And though these kingdoms have been the causers of all the calamities that have befallen them through their heresy, rebellion, and multiplicity of other sins, as the Jews through their idolatry and other vices, so I cannot but lament with the prophet Jeremiah the ruin of the country, the banishment of my king, the desolation of his dominions, the extirpation of the true religion, and persecution of the faithful. What the said prophet Jeremiah saith in the Lamentations may be well applied to our countries, cap. i, v. 8 Peccatum peccavit Hierusalem propterea instabilis facta est; and cap. 2, V. 14 Prophetae tui viderunt tibi falsa et stulta, nec aperiebant iniquitatem tuam. A text very suitable to the wicked doctrines preached and taught by the infamous Protestant parsons, and their blasphemous incendiary bishops. Our nobility are like those of whom Isaiah, cap. i, v. 23, saith, Principes tui infideles socii furum. And I wish {ms folio 59b} God has not pronounced against these perverse kingdoms the judgement formerly against Samaria by the mouth of the prophet Amos, cap. 13, v. i. Pereat Samaria quoniam ad amaritudinem concitavit deum, in gladio pereant, parvuli eorum elidantur, et foetae eorum 



---

p.77



discindantur.[97](javascript:footNote('E680002-001/note097.html')) God grant afflictions may humble our hearts, that we may join in prayer with the prophet Jeremiah and say. Recordare domine quid acciderit nobis, intuere et respice opprobrium nostrum. Hereditas nostra versa est ad alienos; domus nostrae ad extraneos?[98](javascript:footNote('E680002-001/note098.html'))


{ms folio 60a}The second part of the Journal
------------------------------


#### 3


Quien se muda, Dios le ayuda. God helps him that changes, saith the Spanish proverb. It hath not been my fortune to verify this saying, for though I have changed from a civil to a military life, my fortune hitherto hath been retrograde and gone in diminution. Yet no man has more reason to bless and praise the infinite goodness of God, who has brought me safe out of all dangers, and preserved me in entire health in all the hardships I have gone through. This I look upon to be Melioris tessera fati, and hope God has reserved me for some better fate that I may see my sovereign victorious and partake of the fruits of peace, as I have borne my part in the calamities of war, and that such as shall see me happy and peruse this compendium of my sorrows may say, Dulcia quam meruit, qui tam gustavit amara.


Having received my commission I made all the haste my want would admit of to go to the regiment, and being furnished with a good horse by Major Price, I set out from **Dublin** on Tuesday the 20th of August, and went that night to **Drogheda** where the regiment was then in quarters. Here I continued some days, and hoping to return soon into England, where I had left a collection of my former travels and in it some description of this town, I forbore to {ms folio 60b} take any notes, and shall only add that it is twenty miles from **Dublin**. There happened nothing remarkable, nor did we stir till Thursday, September the 5th, when we marched out and encamped, many regiments in number but most very weak, on the south side the town. We spent several days here exercising and furnishing the men with what necessaries the time would allow of. The army daily increased in numbers,



---

p.79



and expressed a great alacrity and readiness to march towards the enemy, though most of the men were very raw and undisciplined, and the generality almost naked or at least very ragged and ill shod.[99](javascript:footNote('E680002-001/note099.html')) The only creditable and hopeful part of the army were the horse, who were for the most part good men, well armed and mounted, but their number not very great.


Saturday the 14th:[100](javascript:footNote('E680002-001/note100.html')) advice being given that the rebels 



---

p.80



advanced from **Dundalk**, the whole army marched through **Drogheda** to **Ardee**, which is eight miles: a rich and fertile country, a good way the weather being dry, and we marching over the green fields. We encamped on the south side the river along the sides of the hills, having the town on the left. Many regiments lay this night in the open air for want of tents, it being too late to build huts. The night was, though fair, extreme cold, but our forward hopes made all things easy.


Sunday the 15th: detachments were drawn out to fetch wood and straw, and the rest of the day spent in building the huts. The post of our regiment was the left of the second line, there being but three elder regiments in the {ms folio 61a} field. About midnight the alarm beat furiously, the whole army was under arms very readily, and having continued so a while returned, it being a false alarm given on purpose to try how quick the men could be drawn up in case of any surprise.


Monday the 16th: His Majesty in person with a great body of horse marched to discover the enemy's motion, and, finding they kept close having met no opposition upon the way, sent orders for the army to march,[101](javascript:footNote('E680002-001/note101.html')) which was not done till the next day, being




---

p.81


#### 3


Tuesday the 17th: when the whole army decamped, and, the ground taken up to encamp being bare of trees, every soldier was obliged to carry some of the wood for building of their huts, which, notwithstanding, many would drop by the way rather than carry so far, though afterwards they found the want of it, being forced to lie that night without shelter, and the next day to go far for wood. This day's march was about six miles, the king's quarters at a village near **Fane Bridge**, where His Majesty lay in a little thatched cabin, there being never a better house near. The whole army encamped in two lines along the fields on the left of the village as far as **Allardstown Bridge**,[102](javascript:footNote('E680002-001/note102.html')) having the river before them for a defence, and our outguards upon the passes. This is about four miles from **Dundalk**, on all sides a pleasant and fruitful country, though not so beautified with good fences as it deserves or is usual in England. Here we lay still and nothing remarkable happened till 


Saturday the 21st: by break of day the whole army {ms folio 61b} was drawn out and marched in two columns, the one over **Fane**,[103](javascript:footNote('E680002-001/note103.html'))


---

p.82



the other over Allardstown Bridge, up to the face of the enemy's camp with intention to draw them to a battle, some of our horse and dragoons making up very close to the passes upon the river that covered the enemies, who kept themselves very close, not appearing at all without their entrenchments, which were strong and well backed with cannon and lined with musketeers. Having stood there a considerable time and there being no possibility of forcing their works, nor our condition enforcing us to press too far being both more healthy and better supplied than were the rebels, we returned to our camp. Great was the general satisfaction of all men[104](javascript:footNote('E680002-001/note104.html')) that we had braved the enemy in their works, and not so much as upon our retreat received the least token of their inclination to fight. This was no small confirmation of what we had been informed before that many were ready and willing to desert, who only wanted the opportunity, and therefore it was supposed Schomberg[105](javascript:footNote('E680002-001/note105.html')) kept his men close in the trenches to prevent the possibility of making their escape. Nor was this all our intelligence gave us to understand, and it was afterwards confirmed that the flux raged amongst them whereof vast numbers died daily. The weather continued very various, sometimes great rains, then very sharp weather, then foggy and mizzling. From this time there happened nothing worth relating till 


Friday the 27th: the rebels fired all their great {ms folio 62a} guns three times and several volleys of small shot, which they performed with incomparable exactness not one shot falling out of time. This we were informed was for joy of some advantage gained by the rebels at **Sligo**, which they represented as very considerable to keep up the hearts of their 



---

p.83



fainting men, yet afterwards it was found to be a mere fiction.[106](javascript:footNote('E680002-001/note106.html'))


Saturday the 28th: passed without anything of note, and Sunday the 29th was only remarkable for a most violent storm of wind and rain, which lasted the whole day but ceased at night. The next day proved fair, and very cold with a northerly wind. The three days following warmer but very wet.


Friday and Saturday, the 4th and 5th of October: the weather was more favourable. The first of these days was sent out a detachment towards the mountains, the design as was said to rescue some prisoners that were kept under a slight guard at Carlingford. They returned the day following without effecting anything, the enterprise being discovered to the enemy, of whom meeting some small party in the mountains they had killed fourteen without any loss on our side. This last night also orders were given to march at break of day. Whilst the army continued encamped in this place it suffered no want of anything that was necessary. There was plenty of forage for the horse, besides what was destroyed to endamage the enemy, which was a great quantity that lay close under their camp, and which they never made any attempt to defend, though our parties burnt it in open day to see to draw them out. {ms folio 62b} The country abounded with straw and corn which served both to lie upon and cover our huts wherewith we supplied the want of tents, there being very few in the army, and even such as had them made huts as being both warmer, and drier. The army was punctually paid, and the brass money passed as current and was of equal value with silver,[107](javascript:footNote('E680002-001/note107.html')) which made the camp so plentiful of 



---

p.84



provisions that I have seen a good carcass of beef sold for eight (shillings), and commonly for ten or twelve, good mutton for twelve or thirteen pence a quarter, geese for six or eight pence a piece, and so proportionably of all sorts of provision.[108](javascript:footNote('E680002-001/note108.html')) At the head-quarters French wines and brandy were at twelvepence the bottle, and at several sutlers throughout the camp at one shilling and sixpence. The scarcest thing was ale, and yet no great want of it at threepence per quart. The camp was a daily market plentifully furnished,[109](javascript:footNote('E680002-001/note109.html')) unless some 



---

p.85



few days when the extremity of bad weather permitted not the country people to travel. There may be assigned three reasons of this resort of provisions to the army. First the want of buyers in the market towns most of the Protestants being fled, and the Catholics being either in the army or retired for fear of the rebels and even of our own men. Secondly the natural inclination of the people towards the army that restrained the enemy from making roads into the country. And thirdly the good order observed, whereby the soldiers were restrained from committing any outrages 
upon the people, which made them have recourse to us the more freely.


Sunday the 6th: at break of day we fired all {ms folio 63a} the huts, and the wind blowing the same way we were to march carried such a cloud of smoke along with it, the thickness of the weather keeping it down, that it blinded us for a considerable space, and thereby several battalions were put into such disorder that it appeared more like a flight than the retreat of an army that had laid so long to brave its enemies, and had they been near enough to make use of the opportunity they had with little danger put us into a great consternation. Had the rebels but stirred the least in order to molest us upon our march, there happened another accident which might have been of a very fatal consequence, and this was that not only the foot but all the horse and dragoons were marched above two miles, leaving behind not only His Majesty's baggage but his person in his quarters with only, his troop of guards, notwithstanding some regiments of horse and dragoons had been ordered to attend him, who nevertheless marched away after the rest till General Rosen himself came up and caused the whole army to halt and face about. His Majesty being come up we continued our march to **Ardee**, where we encamped on the north side of the river having the town on our left. In this encampment our lines were not very regular by reason of the ill disposition of the ground.


Monday the 7th: we continued in the same place. At 



---

p.86



night received orders for Sir Charles Kearney's[110](javascript:footNote('E680002-001/note110.html')) brigade to remove the next morning. This brigade consisted {ms folio 63b} of the regiments of the Lord Grand Prior and Colonel Thomas Butler of Kilcash, which were joined, and Colonel Dillon's, which contained two battalions. The reason of their removal was because the ground they were in was very low, and the season being extreme wet there was danger of the water rising so as to come into their huts, and no dry space before them to draw up.


Tuesday the 18th: the aforesaid brigade marched to [*...*] upon a high ground about three miles from **Ardee**, on the right of all the army and towards the seaside upon the road that goes from **Dundalk** to **Drogheda**. Here we encamped, and the Earl of Clanricarde's[111](javascript:footNote('E680002-001/note111.html')) and Cormuck O'Neill's regiments of foot joined us; the latter consisted of two battalions, and on the left we had the Lord Dungan's Dragoons. All the horse were quartered in the neighbouring villages and country houses. Many days we lay here without any manner of action, the enemy keeping close in their quarters notwithstanding our horse drew daily near to provoke them. The extremity of the weather brought many inconveniences and bred much sickness in our camp. For the most part the rains were so violent that neither huts nor tents could keep out the water, and the earth was so soaked that we were not only wet in the 



---

p.87



day but had no conveniency of lying dry the night, many of the soldiers' huts being a foot deep in water, till by making breaches without them some remedy was applied to that inconveniency. What small intervals of fair weather there were, being not sufficient to dry the earth, and the winds at those times for the most part so boisterous that they were {ms folio 64a} almost as prejudicial and offensive as the rains, which had also caused a scarcity of fuel, the turf bogs being overflowed and though there was some wood the army being ill furnished with conveniences for cutting of it. This rigour of the season brought with it other inconveniences, for it much hindered the recourse of the country people with provisions, and in this particular the officers suffered more than the soldiers, who ranging about either bought or stole cattle and had ammunition bread, which was not allowed the officers. But flesh was the least of our wants, most laying in provision when it was to be had for time of want; the scarcest things were drink, bread among the officers, and salt in general,[112](javascript:footNote('E680002-001/note112.html')) whereof the want was great. The lying cold and wet and too much eating of flesh, which the new raised men were not used to, and that half boiled or broiled on the coals without salt, bred much sickness in the army whereof many died, and a much greater number was daily sent away, besides what went off without leave, either sick or weary of these hardships.


Tuesday the 29th: a strong party of the enemy marched as far as one of our advanced posts, which was at **Tallantstown**, a house of the Earl of Louth's[113](javascript:footNote('E680002-001/note113.html')) with a court before it encompassed with a stone wall, whither were sent from the army weekly a captain, two lieutenants, and an ensign with sixty men, whereof twenty with an officer were detached to a bridge about a furlong from the house, where was an old mill 



---

p.88



with loopholes to fire through, but the river was fordable in several places. The enemy coming up, our men quitted their {ms folio 64b} post at the bridge and retired to the house, the rebels advancing only took prisoner a sergeant that had remained without, and drove away some cattle, but, a small number approaching the house, a lieutenant of theirs was killed and two men wounded, they left the dead body behind and retired. Had the main body of the enemy been upon the back of that party and pursued the enterprise the event could not but have been fatal to us. For upon the news of that post being attacked the alarm being beaten, not the fourth part of our men could be found at their arms, the rest, the day being fair, were ranging the country for provisions, straw, or other necessaries.


Saturday the 2nd of October: I was commanded to the advanced guard at **Tallantstown**, with a captain of Colonel Butler of Kilcash's Regiment,[114](javascript:footNote('E680002-001/note114.html')) a lieutenant of the same, an ensign of ours, and sixty men. Having relieved the guard, and sent the lieutenant with twenty men as usual to the bridge, about midnight we were alarmed by a shot from the said bridge, and stood at arms about the wall all night but saw none of the enemy. This night also came to us a lieutenant with twenty men with orders to relieve us, the army being to decamp the next morning. His orders were for us to march immediately, but by reason of the alarm it was deferred till morning.


Sunday the 3rd: at break of day we marched in good order, and with lighted matches some part of the way, lest any of the enemy, having passed the house by night, might be in the way, but we met none and coming to the camp found the army was {ms folio 65a} marched, whom we followed with speed towards **Drogheda**. The captain that commanded the detachment being well mounted left us ordering every man to make the 



---

p.89



best of his way, upon which they all dispersed, and I being on foot and not able to travel so fast was left behind, and could reach no farther this night than **Castlelumney**, a poor miserable village four miles from **Drogheda**, consisting of about half a score little cottages. Into one of these I was forced to take up amongst forty or fifty poor country wretches, with near twenty sick soldiers, scarce any fire, and no straw nor so much as room to lie down. This made three nights together that I passed without sleep, and the day following the third day of marching afoot, a hardship too great for one so little accustomed to those toils, and rather to be attributed to a particular providence of God that carried me through it than my own strength, for as the Spaniards say, No hizo Dios á quien desamparar, God made nobody with a design to forsake him.


Monday the 4th: I took my way along the hills and came about noon to **Drogheda**. The great rains had made the ways almost impassable, the horse road which is most old causeway being broken up and quite out of repair, and the footway in the fields very boggy with abundance of ditches at that time full of water. It was extreme tiresome to me marching afoot, but to avoid the inconveniences and toils of the camp at such an unseasonable time of the year all things appeared more easy. In **Drogheda** we continued till


Thursday the 14th, when the Grand Prior's Regiment {ms folio 65b} being appointed to quarter in **Dublin**, we marched and, within a mile of **Ballough** dividing the regiment for conveniency of quarters, one part went on to **Ballough** and the other, in which I was, struck off to the left towards the sea to the town of **Lusk**, where we had very good quarters.


Friday the 15th: the regiment joined again on the road, and marched without any considerable halt to **Dublin**, each day's march being ten miles. Our quarters were assigned us in the college,[115](javascript:footNote('E680002-001/note115.html')) where the scholars being turned out another 



---

p.90



regiment had been quartered before, and where the soldiers during the whole winter suffered many inconveniences. One of the greatest was the want of firing, which this winter was extreme dear in **Dublin**, the great supply of the city being the English and Welsh coals, and the traffic with England being cut off they had no other fuel but turf and some wood, both which the expense of the city being great were brought very far and consequently sold very dear. And the soldiers not able to buy did much mischief by night breaking up waste houses for timber, cutting all the trees and destroying the hedges near the town. When this relief was taken from them by prohibition upon severe penalties and setting sentinels upon waste houses, after long suffering the governor of **Dublin**, that was then Simon Luttrell,[116](javascript:footNote('E680002-001/note116.html')) gave an allowance of turf for 



---

p.91



the use of the Grand Prior's Regiment in the college, which was so small that it came not to above a turf to each man in a day. Being returned to **Dublin** I will as in the first part make some general remarks of what happened during our {ms folio 66a} abode there, the actions of this winter being very inconsiderable and my purpose to speak in particular only of such things as I had part in or at least whereof I can give a most certain relation.
  

The happy success of this campaign,[117](javascript:footNote('E680002-001/note117.html')) so far victorious as that the enemy had refused the battle, and that it was credibly reported through sickness and the hardships of the camp they had lost 10,000 men, had not only given a great reputation to 



---

p.92



His Majesty's affairs, but lifted the hearts of all true loyalists to an assured hope of extraordinary success the next summer. And even the remaining part of the winter it was thought might be employed to great advantage not only in refitting the army against spring and other necessary preparations, but in keeping a good correspondence in England preparatory to His Majesty's coming thither, and gaining some advantageous posts in the north of Ireland either through the weakness of the rebels or their inclination to embrace His Majesty's mercy; they being daily represented to be so weakened as not to be able to maintain their garrisons, and in such despair of relief from their miseries that they would upon any conditions return to their obedience. This too great confidence of the good posture of our affairs produced in all men such a security as proved without doubt very prejudicial to our interest in the end. Every one laying aside the care of the public wholly devoted himself either to his private affairs or to his pleasure and ease. The main business of recruiting and disciplining the army was for a long time laid aside, and instead thereof the forces that were on foot suffered to disperse about the country to live at ease {ms folio 66b} without restraint, without exercise and without order. For the benefit of the officers the muster-rolls were always full, though to the great damage of the public; the regiments continued really in the same posture of weakness they came from the camp. As an example may be produced the regiment of Colonel Thomas Butler of Kilcash which mustering always upwards of 600 men could not at any other day bring into the field above 200.[118](javascript:footNote('E680002-001/note118.html')) Men were either so wicked or so ignorant that they strove to make their harvest of His Majesty before his affairs were ripe. This and their country affairs was their chief study, till having gathered a sufficient quantity of money they were in a condition to appear at court; so that notwithstanding His Majesty's repeated orders for all officers to repair to their commands the city swarmed with them, the greatest part not blushing to give the king daily testimonies of their 



---

p.93



disobedience by presuming to appear in his presence. But what is worse if worse can be than disobeying and cheating our sovereign, the money ill gotten was as ill spent in all manner of debauchery, luxury, and riot.[119](javascript:footNote('E680002-001/note119.html')) Oaths, curses, and blasphemies were the one-half of the common familiar discourse, the other part very often containing nothing but the repetition of past enormities or the plotting and contriving of some fresh piece of extraordinary lewdness. Drunkenness was so eagerly prosecuted that no liquors were strong, nor no days long enough to satiate some overhardened drunkards, whilst others, not so seasoned, by often sleeps supplied the weakness of their brain. The women were so suitable to the times that they rather enticed men to lewdness than carried the least face of modesty, in so much that in every corner of the town {ms folio 67a} might be said to be a public stew.[120](javascript:footNote('E680002-001/note120.html')) In fine, **Dublin** seemed to be a seminary of vice, an academy of luxury or rather a sink of corruption, and living emblem of Sodom. Neither their own faculties nor their frauds practised against the king being sufficient to supply the prodigalities of some officers, having forced a credit as far as it would go, they stuck not to support their extravagances by oppression of the country, open violence, and rapine, not to speak of such as 



---

p.94



lived by false dice, and such-like underhand deceitful practices. Nor was it to be admired that in so general a contempt of the express commandments of God, the precepts of the church should pass unregarded, the holy time of Lent and other fasts as to the practice being wholly forgot, only the memory of the name remaining. And yet amidst these enormities every mouth was full of religion and loyalty, every one promising a happy success to the rightful cause, as if that had authorized us in the practice of all sorts of villanies. As if the wickedness of our lives had not equalled if not surpassed the guilt of our enemy's rebellion. And as if God had not raised and supported them for a scourge of our impieties, as he did the Assyrians and Babylonians to punish his chosen people's infidelities, and the Mohammedans to chastize the general profanations of Christendom. Some perhaps may say these reflections are either too severe or not so becoming the pen of a soldier as of a friar. To the first I answer that as I exempt not myself from my part in the very crimes I inveigh against, so I desire every man to {ms folio 67b} appropriate no more to himself of this charge than what his conscience shall accuse him of, and when every one has taken his proportion they may leave the remainder at my door. And for the latter part I think none fitter to comment upon vice than he that has seen most of it or to declaim against a wicked life than he that ought always to be provided for death.


Our intelligence in England for a long time seemed to carry a favourable aspect, some little vessels running often from **Dublin** to the coast which, returning always safe, filled us with the news of the good disposition of affairs there towards His Majesty's service. But neither in this particular was there used that secrecy and caution that became a business of that consequence. It was not enough that every one knew when a vessel was to sail for England, but that at her return the common discourse of the town was what business she went upon and what success she had met with, who managed the intelligence on the other side, to whom commission was given to dispose and provide men, what number of men were in readiness, where and in what manner horses and arms were 



---

p.95



kept and provided for the service, what Protestants had engaged to assist and second the enterprise; to be short the whole series of the transactions was related as if each man had been entrusted with the management thereof between the king and his correspondents. These reports whether true or false could not but be very obnoxious to His Majesty's designs. If true, His Majesty's intentions being made public were easily to be prevented from taking any effect, and the lives of those {ms folio 68a} persons he held correspondence with were brought into an almost unavoidable danger. If false, with the enemy they might carry some opinion of truth, and at least serve for a pretence to oppress and disarm such as they but suspected to have any inclination to His Majesty's service, to the general ruin of the Catholics of England, and endangering those few Protestants that had any sparks of loyalty still surviving in them. Neither were these discourses carried in private between Catholics, but they had so much indiscretion as to make their boasts of their intelligence to the Protestants, who generally knew better than ourselves what things were in agitation. All the king's goodness and clemency was not of any force to reclaim the hardened heart of one of the bigot rebellious Protestants; so far from it that they attributed all His Majesty's mercy to fear, and in their obstinacy and malice despised all dangers and perils to keep a settled correspondence with their rebel brethren in arms. Great was the secrecy wherewith these people managed their villanous practices; they knew the privacies of the king's counsel, and it could never be found who betrayed him any further than mere surmises. They gave account of all passages and accidents to the enemy receiving the like from them, and yet no messenger of theirs either discovered or was surprised; all that could be perceived was that some people as well from **Dublin** as other parts made their escape, who were never so mad as to return. On the contrary some persons that the king sent into England were apprehended, not without manifest tokens of being betrayed by intelligence given from **Dublin**.
  

**Dundalk** being abandoned by the rebels greatly confirmed 



---

p.96



the credit of their vast losses in that place by sickness, for besides the infinite number of graves {ms folio 68b} a vast number of dead bodies was found there unburied, and not a few yet breathing but almost devoured with lice and other vermin.[121](javascript:footNote('E680002-001/note121.html')) This spectacle not a little astonished such of our men as ventured in amongst them, seeing that raging with hunger some had eaten part of their own flesh and having yet their speech begged as a charity to be killed, and yet among all these examples of God's vengeance could I never hear of any that showed the least signs of repentance, but died in their hardness of heart and impenitence. Such was the stench of the place as at first was thought would have rendered it uninhabitable, yet afterwards it was cleansed, garrisoned, and fortified. The recovery of this place made more assured the hopes of further advantages, it being the general belief that weakness or despair would oblige the rebels to quit many 



---

p.97



other posts and retire again all their force to **Londonderry** and **Enniskillen**, and some there were so forward as to imagine even those places would not secure their fears, but they would, having destroyed all the north, withdraw themselves into England and Scotland. The Protestants, that were amongst us being better informed of the strength and resolution of their brethren, laughed at these devices, and not without reason. God's and our enemies were not so weakened as to be driven to abandon what they had so dearly purchased, for allowing as was reported they had lost 10,000 men, yet by the common consent of all men, Schomberg at first had in his army 22,000 men besides the Enniskillingers and other rabble of the country, so that according to this computation there still remained 12,000, not reckoning the aforesaid northern spawn. With this {ms folio 69a} strength might have well been entertained a defensive summer war fortifying their best holds, much more the unseasonable time of winter not fit for any action in the field. It was vain to think God's judgements should produce any despair or remorse in the rebels, their hearts, like Pharaoh and his Egyptians, were hardened with punishment.[122](javascript:footNote('E680002-001/note122.html')) The nature of an Englishman is to be tenacious of the opinion he has once conceived, to be positive in his own conceits, to be firm in his resolutions, to this being joined a genuine boldness of spirit, a contempt of danger, and a disdain of being outdone by another, he will rather perish than not go through with what he has once undertaken. Without suspicion of flattering England I may say of its people as once St. Gregory, Angli quasi Angeli, for whilst the true religion flourished among them no nation was more beautified with learned, heroic and godly men, and even in this corruption of times among such true sons of the church as have weathered the storms of persecution may be discerned the relics of that lustre which once glorified the whole island. But it is a true maxim in philosophy that, Corruptio optimi 



---

p.98



pessima, so those most noble spirits, the angels, blest with the beatific vision of the Almighty, when through their pride and rebellion they were cast down from heaven, of the most pure, most innocent, and most sublime creatures of God's creation they became the most loathsome, most malicious and most vile objects of His eternal wrath and indignation. Even so the English, who were once the pattern of piety, the mirror of religion and pillars of God's church, being fallen into apostasy, became the very {ms folio 69b} advocates of vice, the great example of profaneness, and the chief support of heresy, schism, irreligion, and atheism. Neither is it ignorance, but that natural obstinacy I mentioned before, that retains them in this deplorable estate; they see the grossness of their error, and yet such is their pride they cannot submit to acknowledge it. They were not deluded or drawn into this rebellion against their sovereign, no it was malice and perverseness of heart that forced that universal consent; the fear of being obliged to confess their rebellion against the church made them also traitors to their king. No oppression at home, no miseries abroad, no punishments of men or judgements of God, are able to enforce them to the least act of remorse; the more they are scourged the more they persist, the nearer they see their fault the farther they are from owning it, they kick against the spur, and though they feel the smart yet they cover the sore. To conclude, such is the perverseness, obstinacy, pride, malice, and impenitence of an English rebel and heretic, that the one rather than submit to his king will venture to be hanged, and the other sooner than beg pardon of God himself will inevitably be damned. Both Irish and Scotch, in respect of those of their nations who bear part in the rebellion against God and the king, and who have drunk plentifully of this poison, I believe may apply this at home. To return where I left off, the horror of the place fatal to so many, the stench of the dead bodies, and the diseases that never ceased to rage, made the rebels quit **Dundalk**. Afterwards being refreshed in other garrisons {ms folio 70a} by breathing a sweeter air, and God's wrath giving some respite to their miseries, they not only endeavoured to maintain their garrisons,



---

p.99



 
but made many incursions into our frontiers. What wants were among them, if any such, were plentifully supplied out of England, both as to provisions and recruits of men, besides that most of the north country rebels having been long in **Londonderry** and **Enniskillen** were well used to handle arms, but returned then I suppose to take possession of their houses and lands, which for fear of the king's army or love of their darling treason they had quitted.
  

During the whole winter season till we took the field there happened nothing considerable but the defeat at **Cavan**[123](javascript:footNote('E680002-001/note123.html')) and the loss of **Charlemont**.[124](javascript:footNote('E680002-001/note124.html')) To **Cavan** had been sent a strong detachment of the best men of several regiments, not without great expectation of their performing some very considerable 

Avaux to Seignelay, December 6; Avaux to Louis, January 25 and February 18, 1690; Kazner, i. 328–9, ii. 347; Lauzun to Louvois, May 10–20, 1690, Ministère de la Guerre; Great News from Ireland. A letter from Lisnagarvey, March 20, 1690 (London, 1690, Thorpe); Story, 11; Clarke, ii. 385–90; C.S.P., Dom., 1689/90, pp. 320, 444; C.S.P., Dom., 1690/91, pp. 5,13: ‘**Charlemont** has surrendered from want of provisions.’ Ibid., p. 14: ‘Letters from Ireland of the 18th say that the garrison of **Charlemont** was forced to eat horse hides.’ Ibid., p. 15: ‘They marched out with 600 men, bag and baggage, but very miserable creatures, being reduced to the utmost extremity, for when we entered the place there was but half a salted horse found, and that in the governor, Teague O'Regan's house, for his own use.’ Light to the Blind, 585: ‘It was easy in the winter to send provisions into that town for a much longer siege: yet it was not done. You shall meet with more of those failures before the war ends.’ Among the wounded was Captain Rapin, who wrote the History of England.
  
Teague O'Regan was a hot-headed Irish officer in charge of the fortress of **Charlemont** with a garrison of about three hundred men. ( C.S.P., Dom., 1690/1, pp. 5, 13–15; C.S.P., Dom., 1689/90, pp. 320, 444; Light to the Blind, 585; Kazner, i. 329, ii. 347; Lauzun to Louvois, May 10–20, 1690, Ministère de la Guerre; Story, 11; Clarke, ii. 385–90.) After a stout defence O'Regan, who seems to have been a sort of Charles Napier, surrendered on the 12th of May from lack of provisions, but marched out with the honours of war. Schomberg came to meet the late governor, who cut a most extraordinary figure. The last time the two commanders had met, the latter had served as a lieutenant of the Scots gendarmes under the former. The duke asked how it was that with the garrison so straitened for food, so many women and children should have been retained in the place. The Irish officers replied that their soldiers would desert unless they had their wives and sweethearts with them. ‘Well,’ retorted the veteran warrior, ‘there seems certainly to be a good deal of love in it, but also a good deal of foolishness;’ and he at once ordered a loaf to be given to each man. The colonel of the Brandenburg regiment expressed his disappointment with the appearance of the men who resisted him. It is strange to note that friends and foes alike expressed a certain contempt for the Irish soldiers. 



---

p.100



piece of service. The event answered not the opinion conceived of them, for scarce were they arrived there, sooner than put to the rout with great infamy, having scarce seen the face of their enemies, nor had the slaughter been less had the rebels been as forward to make use of their advantage as they were fortunate to gain it. With much industry the greatest part were persuaded to fly to the fort, others fled whither their fear dictated, some few were killed or taken, the most of these officers. Some men's fear gave them wings to bring this news to **Dublin**, which was variously represented first according to the terror of the relators as a general slaughter, then smothered and palliated with the name of a retreat; but the Protestants had still the true intelligence, and our detachments returning home with shame, the whole matter {ms folio 70b} was known. I mean the sum of the defeat, loss, and disgrace were known, for to particulars no credit could be given, every one relating what his fear first and then the case of his own credit suggested, scarce any two agreeing in their account, but all joining to frame excuses to cover an inexcusable shame. **Charlemont** whilst in our possession was not only accounted very considerable for its strength and situation, but esteemed the key of the north; their stores of ammunition, and provision greatly magnified, and the incursions made by the garrison were no small matter of discourse in **Dublin**. Schomberg, being better informed of the condition of the place, took his opportunity when 600 men had carried in a small supply of provisions to sit down before it, enclosing at the same time the convoy, whose relief was not sufficient to maintain themselves, much less to be any succour to the garrison. Knowing the scarcity of provisions must soon oblige the governor to surrender, whose courage if attacked would have held the place to the last, Schomberg after the usual summons was content to block it up till hunger should open that way, which all his force could scarce have done without great loss. After suffering all sorts of extremities having not only eaten the horses but their hides, the constancy of Thady O'Regan the governor was forced to submit to necessity, and having obtained honourable conditions delivered the garrison, and upon his arrival at 



---

p.101



court in token of His Majesty's grace was knighted. Though it was well known the town was in no possibility to hold out, nothing was attempted for the relief of it; but when lost, as much as the importance*,* conveniency and strength of it had been magnified before, so much was it then contemned and despised.


{ms folio 71a}In the spring arrived at **Cork** the French fleet, bringing besides wheat and ammunition eight battalions of foot well clothed, armed, and disciplined, in return whereof they received a like number of unarmed, ragged, and inexperienced men.[125](javascript:footNote('E680002-001/note125.html')) These forces being landed and well refreshed at **Cork** and all about the country, by easy marches came to **Dublin** to the great satisfaction of all good men, and no less vexation of the rebellious party. These men raised a great expectation of themselves in every one's thoughts, and not without reason, they being the very flower of the foot of the army. M. de Lauzun had the command of them;[126](javascript:footNote('E680002-001/note126.html')) they brought twelve 



---

p.102



field-pieces, and were paid in silver, which was no small damage and discouragement to the rest of the army who received none but brass money, for by that means this sort of coin lost much of its former value. Brass money for some time passed at the full rate as current as silver, till some people going to France, and others, wanting silver to trade there, began to give above the rates of the proclamation for silver and gold coin, and it being considerably improved the French failed not to lay hold of the opportunity and make their advantage, till pistoles came to be sold for three pounds apiece in brass, and so proportionably for other lesser coin. Hence proceeded that excessive dearness of provisions and all manner of necessaries, not from any scarcity but from the contempt of the coin, which was very prejudicial to the whole army who lived upon bare subsistence without any other advantages. Especially those in **Dublin** suffered much, being quartered (except the guards) in waste houses, and such places where they {ms folio 71b} had no help of housekeepers as formerly in quarters, and the prices of all things extraordinary. I do not lay this down as the effect of the French being paid in silver, for as I have said above, this took beginning and was well improved before their coming, though they added much to it. Besides for some days before their arrival the regiments in **Dublin** had been quartered upon the citizens, and upon the coming of the French were removed to the skirts of the city 



---

p.103



and neighbouring villages. Whosoever was the first contriver of quartering soldiers in waste houses and such-like places without doubt had more prospect of interest than love to the army. Every housekeeper that would be exempted was obliged to purchase a protection, which besides all underhand charges cost him one, two or more featherbeds with necessary good blankets, or in default of such beds two, three or four pounds according to the value of his house or humour of them that were to impose the rate. By this means were levied above five hundred good beds, besides a vast sum of money, all as was pretended to furnish conveniences for soldiers in waste houses that they might not be burdensome to the inhabitants. In truth all this served only to enrich some few private persons through whose hands it went and who made a prey of the city under colour of easing it. For except some few old beds that were sent to the hospital, no account was ever had of the above-mentioned number, and all the poor soldiers had of that great quantity of money raised were some poor straw beds, and those so scarce that they served not one-half of the men, those who had them {ms folio 72a} lying little better than upon the floor, through the thinness of the straw, almost naked by reason of the badness of their clothes and the blankets, and starved for want of firing, having none but what they stole with the utter ruin of many good houses, and of all the hedges, bushes, and trees about **Dublin**.


Money, like blood in the body of man, ought to have its circulation, and passing from one hand to another be as it were in a continual motion, from the subject to the king, from the king to the soldier, from the soldier to the tradesman, from the tradesman to the merchant, from the merchant to the countryman, from the countryman to the gentleman, and from every one again to the king. The distempers that the kingdom laboured under had stopped this circulation in such manner that though it continued its course in some measure through the body of the people, the recourse to the king, the head, was almost quite diverted. All the branches of His Majesty's revenue were so sunk that the receipt scarce turned to any account, and a subsidy granted when the parliament 



---

p.104



sat was near lost in the very collecting. This obliged His Majesty to continue the coining a vast quantity of brass, having no other means left to support his army. Not only all the old brass and copper that could be found in **Dublin** or the country was consumed, but many of the largest brass guns were melted down, and the want still continuing it was to be feared all the cannon of that sort of metal in the kingdom were in danger. To supply in some measure this necessity the new half-crowns were made smaller, and all {ms folio 72b} the old large ones called in, which being new stamped passed for crowns. Another remedy was also designed, which was to make crown pieces of pewter or block tin, some few of these were coined being in all respects like the brass, only that on the outward edge in the manner of the English milled money was this motto, MELIORIS TESSERA FATI, and the year of His Majesty's reign, and in the middle was fixed as it were riveted in a small piece of brass, but this money was never made current.


Summer drawing on the preparations for the campaign began to be hastened, and the war which the winter seemed to have lulled asleep being awakened, every man was employed in furnishing himself for the field.[127](javascript:footNote('E680002-001/note127.html')) Every regiment 



---

p.105



in its quarters was mustered and reviewed, an account given of all their wants, arms, cloths, and tents delivered, and nothing omitted for the well furnishing and equipping the army. The Grand Prior's Regiment consisted of twenty-two companies, but none of them full, it was therefore reduced to thirteen, and with the broken new companies were filled up the old ones. But as it commonly happens among those people, the captains had no long joy of this recruit, for soon after they were taken from under the command of their own idol officers they began to desert, their old officers not only conniving but encouraging the men to quit the service, laying aside the care of the public good for a private malice, though all the officers were continued in pay as reformed or seconds. The dearness of the time and smallness of our pay kept the officers low, and of consequence their equipage for the camp was the easier provided. Each captain of the Grand Prior's had a tent allowed {ms folio 73a} him, and every two subalterns, being a soldier's tent raised one breadth of cloth from the ground, 



---

p.106



the tent given, the additional part to be deducted out of their pay. Upon the same account every one had liberty to take up red cloth, white lining, and pewter buttons to make regimental coats. All this was had out of the stores and never paid for.
  

As I have made general remarks upon the times, and not forbore to expose the errors of others, so before I proceed I cannot but reflect upon my own course of life (though in very few words) during this season. Díme con quién andas, diréte quién eres.[128](javascript:footNote('E680002-001/note128.html')) ‘Tell me your company*,* I'll tell you your manners,’ saith the Spaniard. When the air is infected with pestilential vapours, every man endeavours to fortify himself against it with some antidotes or preservatives. But when the wickedness of the times carries an infectious contagion to annoy the souls of men, few are those who have recourse to the true mediums to preserve themselves against the pestilence of vice. I was neither more wise nor more holy than the rest of the world to know how to avoid the danger of too much company. It is the general error of youth that to prevent or divert melancholy or care they embrace all sorts of society, and the consequence of it is excess of drinking and other vices. I wanted not my share in this distraction being young and having little employment to take up my time, my thoughts were much subject to melancholy for the loss of my friends, and for wants, which, not being used to, were the more grievous to me. My course to disperse these thoughts was not such as it should be; the duties of my post were not enough to take up the least part of my time, and instead of employing {ms folio 73b} the remaining part in such studies or exercises as might not only have been delightful at present, but in process of time advantageous to me, I employed myself wholly in following the court, in walking the town, in superfluous visits, in keeping company, and what is worse in drinking and suchlike idle and foolish divertisements of youth. I do not pretend to so much reservedness or zeal as wholly to condemn these pastimes, which used with moderation are in themselves innocent enough; I reprehend in myself the excessive use of 



---

p.107



 
them, and that I was so wholly devoted to them as that they seemed to be my sole business during my stay in **Dublin**. All things that have a face of moderation seem to bear a show of virtue according to the received maxim, In medio consistit virtus, and all extremes though in things that seem innocent are vicious, since the Scripture tells us, *Eccles. vii. 17,

Noli esse iustus multum: neque plus sapias quam necesse est, ne obstupescas.’’*

 I wish my future life may carry such a temperature (since I cannot so much as aim at the perfection of a Christian life) that profitable studies may be the slackening of my cares, and innocent pleasures the divertisement from study, that I may be happy in that true mixture mentioned by the poet, ‘Omne tulit punctum qui miscuit utile dulci.’[129](javascript:footNote('E680002-001/note129.html')).


Monday, May the 19th, 1690: the Lord Grand Prior's Regiment,[130](javascript:footNote('E680002-001/note130.html')) having the day before received what clothes, and 



---

p.108



arms they wanted, was drawn up in **Oxmantown Green**,[131](javascript:footNote('E680002-001/note131.html')) where it was first viewed by the king, and then marched away towards the north. This night {ms folio 74a} we encamped about half a mile beyond **Swords**, which is six miles from **Dublin**. The town of **Swords** is but mean and has nothing in it remarkable but the ruins of an ancient great church, where I suppose was also formerly a considerable monastery; about the town also is as much as can preserve the memory of its having been walled. It being the first night, and I, as yet somewhat unprovided to lie in the field, ventured with leave to go about two miles from the regiment to a place called **Saucerstown**, a village consisting of only a few scattered cottages, where I found one tolerable, and in it good quarters.


Tuesday the 20th: about five of the clock in the morning I returned to the regiment and found them ready to march. It was ordered that neither officer nor soldier should quit the ranks which was no small fatigue, the weather being hot and the road excessive dusty to that degree that we were almost stifled and blinded, and so covered with dust that we scarce knew ourselves, all which fell most grievously upon such as marched afoot, whereof I was one. From **Swords** to **Ballough** is four miles, thence to **Balrothery** two, both of them poor villages, these last two miles of the longest I have seen. Hence to **Gormanstown** three miles, not worthy the name of a town, but at best only a tolerable village, most remarkable for giving title to a lord, who has a good house in the place, but poorly provided at that time, as some of our officers {ms folio 74b} found by experience, who went to it only to get any sort of drink, there being then none to be had for money. Here we made a halt for about two hours, but found no refreshment, but what we brought with us unless the cool air and grass. Hence 



---

p.109



we marched two miles farther to **Jenkinstown Bridge**, where we drew up in a large field in order to pitch our tents, but before the ground was marked out orders came to march to **Drogheda**, three miles from this place, and we were quartered in the city, where we found one battalion of His Majesty's Foot Guards, the Earl of Tyrone's Regiment of Foot,[132](javascript:footNote('E680002-001/note132.html')) and 100 of the Life Guards.[133](javascript:footNote('E680002-001/note133.html')) All the country between this city and **Dublin** is very pleasant, and a good soil, having great store of corn*,* some good pasture, the road in summer very good, but in winter extreme deep unless helped by an old broken causeway full of holes. **Drogheda** is the capital of the county of **Louth**, and according to the ancient division of Ireland, the first and chief of the whole province of **Ulster**, which in ancient times comprehended the whole county of **Louth**, and was divided from **Leinster** by the river **Boyne**, but in a later division the said county of **Louth** is added to the province of **Leinster**. The **Boyne** divides the city, the principal part whereof as is before said stands in the county of **Louth**, the remainder on the south side of the river in the county of **Meath**, most part whereof is demolished ever since **Cromwell** besieged it, he having made his breach on the south-east side, where he also ruined an ancient church. On this side also is the mount, not so large {ms folio 75a} as capable of being made strong, and has the full command of the whole city. Both parts are joined by a wooden bridge, as high as which close to the quays ships of considerable burden have water enough, but the river though deep is narrow. About the year 1685, when first I saw this city it was in a flourishing condition, well inhabited and 



---

p.110



had a considerable trade at sea. Since this rebellion it is totally ruined, its trade lost, most of the inhabitants fled, and the buildings ready to fall to the ground. We continued here in quarters till


Saturday the 24th: a detachment of His Majesty's Horse Guards, then two battalions of the foot guards, then the Lord Grand Prior's Regiment, and, to close up the rear, a troop of the Lord Dungan's Dragoons; in this manner we marched about three or four miles to **Mellifont**, as to the village very inconsiderable. But what makes the place anything known is a large but now much decayed house in a bottom enclosed with wooded hills and a very fair park, all of the estate of the infamous Earl of **Drogheda**, infamous both as a rebel and notorious coward.[134](javascript:footNote('E680002-001/note134.html')) On a ridge of hills to the northward of this place we encamped the horse and foot guards on the left, it being next to the general's quarters, the Grand Prior and two troops of Colonel Sutherland's Horse[135](javascript:footNote('E680002-001/note135.html')) on the right, leaving in the centre a large interval for other regiments to encamp.




---

p.111


#### 3


Sunday the 25th: Colonel M'Ellicott's Regiment encamped on the left of us.[136](javascript:footNote('E680002-001/note136.html')) They marched in about 550 strong, besides officers and sergeants, very well armed and clothed.


{ms folio 75b}Monday the 26th: in the morning the Earl of Tyrone's Regiment joined us, and encamped on the right of the guards, about 500 and odd strong. Soon after them came up Colonel Parker's Regiment of Horse, consisting of eight troops in all, 300 men complete; they marched through, and took their ground about a quarter of a mile from the head of our line. A troop of the Lord Dungan's Dragoons marched in with this last regiment, but neither these nor those before mentioned encamped with us. These two days we had very foul weather, towards evening it cleared a little.


Tuesday the 27th: though the weather was extreme foul with a continual violent rain all the foot were drawn out and kept at arms all day only to satisfy the impertinent curiosity of some ladies, who appeared in a coach towards evening, and whom we were commanded to receive with the same respects as are used to be paid to the king, though there were few there who did not curse them in their hearts and even some with loud voices. For although we were obliged to obey our 



---

p.112



superiors, who, as may appear by the course of our misfortunes, were generally better courtiers than soldiers, yet we could not but resent being fatigued a whole day at arms when the rain ran through our clothes the most part of the time as if we had been kept standing in a river up to the neck, and had no retreat but our poor tents, nothing of the king's service or martial discipline requiring this hardship to be imposed on us, but rather the drawing out of so many battalions of armed men in such unseasonable weather was to surprise the fortress of those (I doubt not overwell fortified) ladies' hearts. This night we received orders for marching the next morning.


{ms folio 76a} Wednesday the 28th: the general beat at three, all the line was at arms at four, and began at five to march off from the left. First the horse guards, then two troops of Colonel Sutherland's, next the two battalions of foot guards and other regiments successively, and lastly the Lord Grand Prior's; after them followed the ammunition and baggage and Colonel Parker's Horse, which doubtless was designed to close the rear, but on the sudden without much order they marched off and left us. The country here is very open, the first mile and half a broad road between cornfields, then a common above a mile over very thick of fern, thence to **Ardee** about four miles. We marched through three miles farther and encamped at night between **Stormanstown** and **Cookstown**, both little more than the ruins of two gentlemen's houses. The line was extended near a mile in length, the guards taking the right, the Lord Grand Prior the left, the rest in the centre being in all but six battalions, leaving intervals for such battalions as were designed to fill up the line. The horse guards held the right and Colonel Parker's Horse the left, the Lord Dungan's Dragoons on the right of the guards. The line lay along the side of a pleasant hill, all the fields about full of grass, but very little corn.


Thursday the 29th: joined us eight complete troops of Quarter-Master General Maxwell's Regiment of Dragoons, being 400 men well armed and mounted. They encamped on the left of Parker's Horse.




---

p.113


#### 3


Friday the 30th: the Earl of Antrim's Regiment of Foot[137](javascript:footNote('E680002-001/note137.html')) encamped on the right next the Grand Prior's, their muster-rolls and computation amounted to near 800, but after a diligent search and inquiry I could not find above 550 private men.


Saturday the 31st: in the morning two women were {ms folio 76b} hanged as spies by order of Major-General Léry,[138](javascript:footNote('E680002-001/note138.html')) the commander-in-chief. In the afternoon the Earl of Westmeath's Regiment[139](javascript:footNote('E680002-001/note139.html')) about 550 strong encamped on the right of Antrim. These two days' provisions of all sorts were very scarce and 



---

p.114



dear; the badness of the weather contributing much thereto, by reason the country about us was bare, and all necessaries brought far, which was difficult to the poor people in bad weather.


Sunday the 1st of June: nothing of note.


Monday the 2nd: a party of horse and dragoons sent out returned at night, having marched about nine miles and scarce seen any human creature but an old woman dying for want in the church at Carrickmacross, and two men on the road by whom they understood there was no body of the enemy near.


Friday the 6th: the Earl of Louth's Regiment[140](javascript:footNote('E680002-001/note140.html')) came up 



---

p.115



to us and encamped on the right of Sir Michael Creagh. The same night His Majesty's second troop of guards joined the detachments that were with us before. The three foregoing days nothing of note happening are therefore omitted, as also the following being the 7th.


Sunday the 8th: a party of horse and dragoons under the command of Brigadier Maxwell returned, having been within two or three miles of **Armagh**, and hardly seen any living creature all the way. Four deserters came to us from the enemy.


Monday the 9th: four troops of Brigadier Maxwell's dragoons that were behind joined the regiment, making up twelve complete troops and near 600 men well accoutred and disciplined.


Tuesday the 10th: the camp was alarmed by a report of some body of the enemy being seen between us and **Dundalk**. The horse and dragoon pickets mounted, horses were taken from grass, and some parties {ms folio 77a} went out, but it proved a very groundless alarm.


Wednesday the 11th: two of Sir Michael Creagh's men,[141](javascript:footNote('E680002-001/note141.html')) being taken six or seven miles from the camp, were shot as deserters. The weather till now having continued very cold, wet, and raw, became on a sudden extreme hot.


Thursday, Friday, and Saturday nothing of note but that this last day being appointed a general muster; there being but one commissary of the foot only the two battalions of guards mustered.


Sunday the 15th all the other foot regiments mustered beginning from the right. The Earl of Clare's Regiment of Foot joined the army.


Tuesday the 17th: the general beat between two and three o'clock in the morning, about an hour after, the troop, with orders to decamp, the army marched off from the right towards **Dundalk**. First to **Tallantstown Bridge** near which 



---

p.116



stands a house of the Lord Louth's, not at all considerable though once a garrison of ours, it being half thatched. Thence cross the ground we had encamped on the year before, where we found standing the entrenchments we had then made. We passed through **Louth**, a very poor inconsiderable village, without so much as the remains of any former grandeur, which in many parts of Ireland is to be seen in the considerable ruins that are about small places. From this poor hole does this county, esteemed one of the best in Ireland, take name. This day's march was ten miles, the country very pleasant and a rich soil, but most lying waste since this rebellion broke out into open war. It is generally hilly without any large plain, not much enclosed or rather most enclosures thrown down these times, {ms folio 77b} and there being no stocks of cattle to eat it up the fields were plentifully stored with grass. Our headquarters were at **Castle Bellew**, a house of the lord of the same name[142](javascript:footNote('E680002-001/note142.html')) and colonel in His Majesty's army, about a mile from **Dundalk**. The army encamped on the side of a hill on the left of the head-quarters, facing towards **Newry**. The town of **Dundalk**, as was said before, within a mile of the right, the river at a considerable distance before us. The day proved excessive hot and the march long, for these are not like the ordinary miles of England. But what was most tiresome was our regiment's bringing up the rear, which is often forced to run when the van walks at ease, and is often made more uneasy through the indiscretion of commanding officers, especially when they take not good measures in marching through defiles. Upon all halts the rear is marching up while the front rests, so that they have scarce a breathing before the drum beats to march; unless general officers will be so kind to their men, where no danger is near, as to let them halt in 



---

p.117



columns as they march, and not oblige them still to draw up in a line.


Wednesday the 18th: the Duke of Tyrconnel's and Lord Galmoy's[143](javascript:footNote('E680002-001/note143.html')) Regiments of Horse came into the field, and encamped, the first on the right, the other on the left of the first line.


Thursday the 19th: the general beat at three, all the foot were at arms between five and six. About an hour after, the Earls of Westmeath and Antrim's Regiments marched and took the left of the Lord Grand Prior's, then the three regiments marched about half a mile towards Newry road, where we halted in the fields, and heard mass after which was an alarm. All the horse and dragoons mounted, the {ms folio 78a} foot guards had before marched down and were posted at a distance on the right, now the horse and dragoons advanced. Several parties were sent out to the Four-mile Bridge, but it proving a false alarm, the horse and dragoons soon returned to the camp, but the foot continued at arms in the fields till nine o'clock at night.


Friday the 20th: the French and other regiments coming up, the whole army decamped, the first line pitching their tents on the top of the hill, which before were not so regular along the sides of it, and stretched out the line a considerable space on the left. The second line also moved, several regiments being removed from the first into the second.


Saturday the 21st: a strong detachment of firelocks was sent out to a castle on the Newry road. At night 200 chosen men out of five regiments, being 40 of each, were sent to lie 



---

p.118



upon Newry road upon intelligence of some party of the enemy advancing.


Sunday the 22nd: a party of horse under the command of Lieutenant-Colonel Dempsey,[144](javascript:footNote('E680002-001/note144.html')) advancing towards **Newry**, fell into a body of the enemy and, being overpowered, retreated; till coming to the above said detachment of 200 foot under the command of Lieutenant-Colonel FitzGerald[145](javascript:footNote('E680002-001/note145.html')) and finding them receive the enemy vigorously, they rallied. The rebels made no great resistance, our foot firing hotly, but fled towards **Newry**, the horse pursuing them a considerable space. Of the rebels above sixty were killed, of ours a few wounded and fewer killed, among which was Lieutenant-Colonel Laurence Dempsey, shot through the {ms folio 78b} shoulder whereof he died. I was not present at this action but had the account from some who were. This day was taken one who received pay as sergeant in our regiment, deserting to the enemy and hanged at the head of the battalion. Three others who together with the former, being all Scotchmen, had served in Dumbarton's Regiment[146](javascript:footNote('E680002-001/note146.html')) and made their escape from Flanders into France 



---

p.119



and thence sent over to us, went away to the rebels, which caused a reasonable suspicion that they and some of the same stamp that were among us came over as spies rather than to serve.


Monday the 23rd: the whole army prepared to march early in the morning, and moved about noon. Men were detached from each regiment to receive salt meat and bread at the stores at **Dundalk**, but it being known the king designed to abandon that place, the soldiers in a disorderly manner fell to plundering the stores, which caused no small confusion, every one there laying hold of what he could, and running a several way. We marched back about nine miles in such manner as looked more like a flight than deliberate retreat, and encamped on the north side of **Ardee**.


Tuesday, Wednesday, and Thursday nothing of note happened, but we continued in the same place and spent the two last days in exercise, and teaching the men to fire, which many of them had never been accustomed to before.


{ms folio 79a}Friday the 27th: we decamped and leaving **Ardee** on the right marched about five miles and encamped. This place fared no better than **Dundalk**, being plundered by our own men and left almost desolate. Before the Rebellion it was an indifferent good town, but most of the inhabitants fled from their homes and allegiance, and the rest either dead or left worth nothing. Here we understood the enemy was advancing.


Saturday the 28th: we marched again about five miles and encamped within three of **Drogheda**, near a small village, along cornfields, gardens, and meadows, the river **Boyne** in the rear. This night no word was given, but about midnight in great hurry ammunition delivered out, then orders to take down all tents and send away the baggage. This done the whole army drew out without beat of drum and stood at their arms the whole night, expecting the approach of the enemy.


Sunday the 29th: about break of day no enemy appearing, the army began to march in two columns, the one through 



---

p.120


**Drogheda**, the other over the river at **Oldbridge**, and encamped again in two lines in very good order on the south side of the **Boyne**, between two and three miles from **Drogheda**, the river running along the whole front; the design being to make good the passes of it against the enemy, who were too strong to be engaged in plain field till we were reinforced or they obliged to fight at disadvantage, {ms folio 79b} it being very easy to keep the passes of the river, and the rebels being in some distress for want of provisions. But no human policies are sufficient to stop the course of fate.[147](javascript:footNote('E680002-001/note147.html'))


Monday the 30th: early in the morning the enemy appeared on the tops of the hills beyond the river, some of the poor country people flying before them. They marched down and spread themselves along the sides of the hills where they encamped, but so as we could not discover them all, a great part being covered by the higher grounds. Part of our cannon was carried down and planted on the pass or ford, which from thence played upon some regiments of theirs, and did some but not considerable execution. After noon they began to play upon us with their cannon and some mortars, but no considerable damage was received on either side.


Tuesday the 1st of July: very early the tents were thrown down, the baggage sent away, but the soldiers ordered to carry their tents, some of which were afterwards together with their snapsacks laid in heaps in the fields with some 



---

p.121



 
few sentinels, the rest thrown about as they marched, but in conclusion, as the fortune of the day was, all lost. We had this morning received advice that the enemy marching by night had beaten off a regiment of our dragoons that guarded the bridge of **Slane** and possessed themselves of it, and now we saw them marching off from their right towards it. We on the other side marched from the left, the river being between both: for a considerable space we marched under the enemy's {ms folio 80a} cannon, which they played furiously without any intermission, yet did but little execution. We continued marching along the river till coming in sight of the enemy who had passed it and were drawing up, we marched off to the left as well to leave ground for them that followed to draw up, as to extend our line equal with theirs, and finding them still stretching out towards their right we held on our march to the left. Being thus in expectation of advancing to engage, news was brought us that the enemy, having endeavoured to gain the pass we had left behind, were repulsed with considerable loss on both sides, the Lord Dungan, a colonel of dragoons, and many brave men of ours being killed. This latter part was true, the former so far from it that they gained the ford, having done much execution on some of our foot that at first opposed them and quite broke such of our horse as came to rescue the foot, in which action the horse guards and Colonel Parker's Regiment of Horse behaved themselves with unspeakable bravery,[148](javascript:footNote('E680002-001/note148.html')) but not being seconded and overpowered by the enemy after 



---

p.122



having done what men could do they were forced to save their remains by flight, which proved fatal to the foot. For the horse in general, taking their flight towards the left, broke the whole line of the foot, riding over all our battalions. The Lord Grand Prior's wherein I served was then in Duleek Lane, enclosed with high banks, marching ten in rank. The horse came on so unexpected and with such speed, some firing their pistols, that we had no time to receive or shun them, but all supposing them to be the enemy (as indeed they were no better to us) took to their heels, no officer being {ms folio 80b} able to stop the men even after they were broken, and the horse past, though at the same time no enemy was near us or them that fled in such haste to our destruction. This I can affirm, having stayed in the rear till all the horse were past, and looking about I wondered what madness possessed our men to run so violently nobody pursuing them. What few men I could see I called to, no commands being of force, begging them to stand together and repair to their colours, the danger being in dispersing; but all in vain, some throwing away their arms, others even their coats and shoes to run the lighter. The first cause I had to suspect the rout at the ford was that the **Duke of **Berwick****,[149](javascript:footNote('E680002-001/note149.html')) whose command was with the horse, came to us and discovering a party of horse at a distance, thinking they were the enemy, commanded our musketeers to line the side of the bank over which they appeared, till finding they were our own men we continued our march. This first made 



---

p.123



 
me apprehend all was not well, and was soon confirmed, hearing it whispered among the field officers, but in conclusion what I have before related put us all beyond {ms folio 81a} doubt. I shall not presume to write all the particulars of this unfortunate day's transactions, the confusion being such that few can pretend to do it. I will therefore proceed to what followed as far as I can assert for truth. I thought the calamity had not been so general till viewing the hills about us I perceived them covered with soldiers of several regiments, all scattered like sheep flying before the wolf, but so thick they seemed to cover the sides and tops of the hills. The shame of our regiment's dishonour only afflicted me before; but now all the horror of a routed army, just before so vigorous and desirous of battle and broke without scarce a stroke from the enemy, so perplexed my soul that I envied the few dead, and only grieved I lived to be a spectator of so dismal and lamentable a tragedy. Scarce a regiment was left but what was reduced to a very inconsiderable number by this, if possible, more than panic fear. Only the French can be said to have rallied, for only they made head against the enemy, and a most honourable retreat, bringing off their cannon, and marching in very good order after sustaining the shock of the enemy, who thereupon made a halt, not only to the honour of the French but the preservation of the rest of the scattered army. Nor ought any part of this glory to be attributed to the Count de Lauzun, or La Hoguette,[150](javascript:footNote('E680002-001/note150.html')) who at first left their men, but only to the valour and conduct of M. Zurlauben, colonel of the Blue 



---

p.124



Regiment, who with unparalleled bravery headed and brought off his men, whereas the other two fled and more especially Hoguette was in such a {ms folio 81b} consternation that the next day when he was above thirty miles from the enemy he caused a bridge to be broken for fear of pursuit, though at the same time the river was passable for foot both above and below the said bridge, so great is the infatuation of a coward when no danger is near but what his weak imagination suggests. The Lord Grand Prior's Regiment, but a little before consisting of 1,000 men including all officers, now gathered to about 400, and the most part of those in such posture as promised rather the repeating their late shame than the revenging of it on their enemies. Some had lost their arms, others their coats, others their hats and shoes, and generally every one carried horror and consternation in his face. Many officers were not exempt from having their part of the disgrace with the soldiers, above half being missing when we endeavoured to rally, some were not heard of till we met in **Limerick**, and some stayed in **Dublin** till the coming of the enemy, who showed them no other favour than to make them all prisoners. Of those who appeared several had thrown away their leading staves, others their pistols they were before observed to carry in their girdles, and even some for lightness had left their swords behind them, and I can affirm it as a truth being an eyewitness I saw an ensign had cast off his hat, coat and shoes to make the better use of his heels, which he also did the second time at **Limerick** when the great assault was made the first siege. I could give a list of many of their names but that I think them too infamous to fill up any place here, yet I have since seen several of them and even that ensign above mentioned preferred and in esteem, when others have been put by {ms folio 82a} their right for no other reason given but because they were wounded in the service, and those men have carried themselves with such insolence as if there had been no witnesses left of their cowardice. This, as well for number as goodness of men, was esteemed one of the best regiments of foot in the army, 



---

p.125



and being such may sufficiently declare what became of the rest. Brigadier Wauchope,[151](javascript:footNote('E680002-001/note151.html')) who commanded our brigade, and whose greatest confidence was in our regiment, finding them in no disposition for service, commanded to march up the hill. I, being the eldest lieutenant then present, led the second division of shot, and perceived, as we marched, the first to open to the right and left and begin to disperse, whereupon I commanded to close and keep their ranks, but they answered they had none to lead them, the brigadier and colonel being a little advanced to the top of the hill to view the enemy below, and the captains on what pretence I know not having all quitted their post. I soon reduced the men and for a while marched at the head of them till some captains returning I went back to my own post. What with the ill example of the officers and what with the terror that had seized the whole army, when we had reached the top of the hill in despite of all commands or persuasions the men instantly slunk away, so that within half an hour or little more we had scarce eighty left together. We held on our march all day our men dispersing in such manner that we could hardly keep twenty with the colours. The like small remains of many other regiments bore us company. By the way some few of the Lord Dungan's dragoons[152](javascript:footNote('E680002-001/note152.html')) joined us, who were in no less 



---

p.126



confusion than the foot. This day's flight was attended {ms folio 82b} with all the fear and confusion that may be imagined in men surrounded with the greatest of dangers, though ours through the providence of God and valour of the French had none to pursue or offend them. For the enemy finding the French stand and some of our horse to make head never pursued their victory or improved their advantage,[153](javascript:footNote('E680002-001/note153.html')) which if they had done a small party might have cut us off, so that none had been left to make head again and but few of those present to lament the misfortune of the day. Whether treason, cowardice, or ill conduct had the greatest share in the shame and losses of this day with many remains in dispute, nor can be decided by me not being privy to the counsels nor in a post to see all 



---

p.127



particulars, or be a competent judge of the actions of generals.[154](javascript:footNote('E680002-001/note154.html')) The soldier blamed the officer, the officer the general, some were accused as traitors, others as unskilful of their duty, but the greatest imputation was of want of valour. But if it be lawful for me to give my sentiments on the matter in my opinion much may be laid upon mismanagement, but much more upon cowardice, and am apt to believe all the clamour of treason was raised by some who had given the most eminent signs of fear to cover theirs and the general disgrace. To prove there was treachery it was given out that the cannon which commanded the ford upon the enemy's coming down to force that pass was first forbidden to be fired and then drawn off; that several regiments appointed by the king to make good the said ford were commanded away unknown by whom, and that when the enemy had possessed {ms folio 83a} themselves of the ditches about it the horse were sent down to charge them, it being the duty of the foot, whereby many of those horse were lost and the remainder put to the rout. It is agreed on all hands the action at the ford was ill managed, but not having been present I will not speak to particulars, [or] only in general what is allowed by all. That there was not a sufficient number of foot left to maintain it, and even most of those that were came down too late, and as was said before the horse were put to repulse the enemy's foot who had before possessed themselves of the ditches. As touching the cannon it was doubtless time to draw it off when, had it stayed but never so little, it must have fallen into the hands of the enemy. I cannot but think it was some oversight to march the most of the foot, who were to engage the enemy that came over at **Slane Bridge**, along the sides of the hills by the river under the enemy's cannon, when there was a way above shorter and out of the reach of their shot. Having passed that and extending to make an equal line with the enemy towards the left we were again marched through lanes 



---

p.128



when there were plain open fields both in front and rear. No general officer above a brigadier was seen among us, and, which is very rare, no word given to us. Nor is it to be forgot that His Majesty, having appointed brandy to be distributed to each regiment so that each man might receive a small proportion, in order to cheer them for the fatigue of the day, it was never delivered till we were marching, when the soldiers, quitting their ranks for greediness of the liquor, not having time to stay, beat out the heads of the hogsheads and dipped into them the kettles they {ms folio 83b} had to boil their meat, drinking so extravagantly that I am sure above 1,000 men were thereby rendered unfit for service, and many were left dead drunk scattered about the fields. But, to come to our last point, it was certainly an unparalleled fright that caused our own horse to ride over the greatest part of our first line of foot and break ten or twelve of our battalions, firing upon them as enemies, and yet I must confess some of these were the men that with great bravery had sustained the shock of the enemy's horse, and were outdone by numbers not by valour, I mean Colonel Parker's Regiment.[155](javascript:footNote('E680002-001/note155.html')) There is no place of excuse for the 



---

p.129



dragoons, especially the Earl of Clare's,[156](javascript:footNote('E680002-001/note156.html')) (commonly known by the name of Yellow Dragoons, being the colour of their clothes) who were the first that fled having scarce seen the enemy, and that with such recipitation that several of them carried the news the next day to **Limerick**, and some not thinking themselves safe there with the same speed into the remotest parts of the county of **Clare**, their native soil, being above 100 miles from the **Boyne**. Neither does the baseness of the foot appear less notorious, for some regiments being broken by our own horse, others though untouched took the flight for company, and neither the one nor the other could ever be prevailed with to make head against the enemy and second the French (who were in danger to be cut off), nor so much as to form their battalions and march off with their colours in good order. To the contrary though the action was not till noon several foot soldiers made such haste that they were seen in **Dublin** before three of the clock, having in that short time run near twenty miles, which perhaps might have had some colour of excuse had the enemy {ms folio 84a} been at their heels, but there was none to hurt and it was only their own fear pursued them. The weight of our misfortunes made me forget many particulars, and yet methinks I have said too much and dwelt too long on a subject of so much shame, God of his goodness make all men sensible of their dishonour that they may resolve to live victorious or at least die honourably. In the condition I have before mentioned we marched or rather fled till it was 



---

p.130



quite dark, when the Duke of Berwick ordered to halt in a field about five miles from **Dublin**, there being now left together the colours of only five or six regiments and at first halting not above 100 men in all, though before morning we were much increased, sentinels being placed on the road to turn all soldiers in to the field. In this place we took some rest on the grass till break of day. As to my own particular I wonder I outlived the miseries of this dismal day, but that I have since found I was reserved to suffer many more and if possible much greater. Grief (though the greatest) was not my only burden, marching from three in the morning afoot till dark night, the excessive heat of the sun, and a burning thirst proceeding from the aforesaid causes, which was so vehement I could not quench it though drinking at every ditch and puddle, were all together sufficient to have conquered a much stronger body. But God who gave the cross gave me strength to carry it, that I might have part in the remainder of our chastisement and I hope in His mercy, when our sins by our sufferings shall be expiated and His anger appeased. He will also grant me the blessing of seeing my sovereign restored to his throne victorious.


{ms folio 84b} Wednesday the 2nd: at break of day those few drums there were beat as formally as if we had been a considerable body, but it was only mere form and we scarce the shadows of regiments, the bodies being dispersed and gone. What was left in dismal manner marched as far as **Dublin**, where when each commanding officer came to view his strength, shame of marching in such case through the city we not long before had filled with expectation of our actions and hopes of gathering part of the scattered herd caused us to halt in the fields without the town. The colours of each regiment being fixed on eminences that all stragglers might know whither to repair, in the space of near three hours each regiment had gathered a small number, the Grand Prior's as one of the most considerable being then 100 strong. Thus we marched through the skirts of the city, passing over the river at the **Bloody Bridge**, which is the farthest off in the suburbs, being now only the remains of four regiments, the others being either quite 



---

p.131



 
dispersed or gone other ways, we halted again in a field at **Kilmainham**, a hamlet adjoining to the city. The general opinion was that we were to encamp in the park till such time as our men came up, and what forces had not been in the rout as also the militia should join us, and then either maintain the city, or, if it were judged expedient, give the enemy battle, which gave occasion to some of our small number to steal away into town thinking they might soon be back with us. But about noon we were all undeceived, the other three regiments having orders to march, and ours only left there without any or knowing whence to expect them. Being thus left by all our lieutenant-colonel marched us away, which we did not hold above a quarter of an hour when we were reduced to only twenty men with the colours. On the road we overtook the Lord Kilmallock's Regiment, which was untouched, being quartered in **Dublin** when the defeat at the **Boyne**.[157](javascript:footNote('E680002-001/note157.html')) The whole day was a continual series of false alarms, the greatest reached us within two miles of the **Naas**, where Kilmallock's 



---

p.132



officers attempting to draw up their men to line the hedges, the confusion and terror of the soldiers who had never seen the enemy was such they were forced in all haste to march away. It was ridiculous to see the brother of the traitor {ms folio 85a} O'Donnell,[158](javascript:footNote('E680002-001/note158.html')) who had the name of lieutenant-colonel reformed in our regiment, pretend to take authority upon him here, and order us to line the hedges, when at that time our whole strength was but six musketeers, eight pikes, four ensigns, and one lieutenant besides myself, to this was that but the day before hopeful regiment reduced, and yet not one of the number killed, unless they perished who were left drunk when we fled which were four or five. For our comfort no enemy was within twenty miles of us, but fear never thinks itself out of danger. We followed Kilmallock's men with such speed it had been hard for an enemy to overtake us, and that regiment though till then untouched was in such a consternation that when they came to the **Naas** they were not 100 strong. Here being quite spent with marching two days without rest or food I used my utmost endeavours to persuade O'Donnell, who as I said pretended to act as lieutenant-colonel, to take up quarters for the few men that were left, to refresh them that night, and be the better able to march next morning, but all in vain. The general infection had seized him and he fancied each minute he stayed was to him time lost and an opportunity given to the enemy to gain ground upon us. Therefore following the dictates of his fear he hasted away commanding



---

p.133



all to follow him, but necessity pressing more than his usurped authority, I stayed a while in the town with an ensign who had a lame horse, and having refreshed ourselves with bread and drink which was all the town afforded, we followed both on the same lame creature five miles to **Kilcullen Bridge**, where we could hear no news of our men, though they lay there that night. So inconsiderable was a regiment grown that it could not be heard of in a town where there are not above twenty or thirty houses and but three good ones. Here we took up for the remaining part of the night in a waste house, and rested the best we could till break of day.


Thursday the 3rd: we were roused out of a dead sleep, proceeding from excessive weariness not from the easiness of the beds which were no other than the planks, at break of day by a great number of dragoons and others riding through the town as fast as their horses could carry them, and crying the enemy was within a mile of them. Being awaked and our lodging nothing pleasant we set out on our lame horse and having travelled five or six miles {ms folio 85b} were overtaken by the Duke of Tyrconnel [159](javascript:footNote('E680002-001/note159.html')) and his family, some whereof challenged 



---

p.134



the horse, and indeed he had the king's mark, they being too strong for us to cope with, for then might was the greatest right. They carried him away leaving us afoot weary, and without friends, or money. In this condition being desperate we attacked a village with design to force away a horse under the colour of pressing, but in reality was not much better than robbing. But the women of the village, setting up the cry, soon gave the alarm to all the men that were abroad, who flocking in with their roperies or half pikes had put us to the rout again, but that I had my leading staff which being longer than their weapons terrified and made them give way where I came, but whatever was gained I was forced to lose to protect my companion, who having no weapon but his sword was too hard set, and doubtless had he been furnished with a half-pike we had got the better of the whole village and forced away two horses. As the case stood we were obliged to quit our pretensions and march off without horses, but not without some peals of curses for our good intentions and the good bangs I had given some of the men in the skirmish. Thus disappointed we struggled with weariness in hopes to reach **Athy**, when a great shower of rain falling increased our misfortune, making the ground so slippery we could scarce draw our tired limbs along. Now again in extremity it pleased God to relieve us, for a friend of mine, one Mr. Dowdall,[160](javascript:footNote('E680002-001/note160.html')) overtaking of us well mounted took me up behind him and a cornet of Luttrell's Regiment[161](javascript:footNote('E680002-001/note161.html')) my companion, I having 



---

p.135



long refused to ride unless he were mounted, thus they carried us four miles to **Athy**. Hoping the rain would cease we stayed till almost evening refreshing ourselves, and it being then too late to travel took up our quarters at **Shanganagh**, a small village a mile from **Athy**, and found the best entertainment we had met with since the unhappy rout. **Athy** is part in the county of **Kildare** and part in the Queen's county, divided by a small river, which parts the town and two counties, which are again joined here by a good stone bridge. The town is pretty large and well built after the ancient manner, {ms folio 86a} though not equal with the cities, yet not inferior to most towns of that country.


Friday the 4th: meeting a servant to one of our lieutenants I borrowed a horse he had, and pressed or forced away another about a mile from our quarters, but without saddle or bridle, which was very uneasy, but anything more tolerable than going afoot, and thus mounted we got about noon to **Kilkenny**, which is sixteen miles.[162](javascript:footNote('E680002-001/note162.html')) To do justice I restored the horse to his owner before entering the town, contrary to the advice of all present, but as it was unjust to detain the horse without any other pretension but force so it was inhuman to do it after the poor man had followed sixteen miles afoot upon my promise of restitution. Nor was the manner of taking the horse unpleasant, for at least twenty of the poor people flocking to his defence with several weapons. I frighted away and kept them all oft by presenting a matchlock I had taken from the lieutenant's man, though without powder, ball, or so much as a match. All the shops and public-houses in the town were shut, and neither meat nor drink to be had though many were fainting through want and weariness. Hunger and thirst put me forward to seek relief, where nothing but necessity could have carried me, but the invincible power of want hides all blushes, so hearing the stores at the castle were broken up and much bread and drink given out, I resolved to try my 



---

p.136



fortune there and found drink carried out in pails, and many of the rabble drunk with what they had got; yet upon my approach I perceived some officers whom want had carried thither as well as me but were somewhat more forward, so ill treated by Brigadier Wauchope first and next by the Duke of Tyrconnel, who gave a lieutenant a thrust on the breast with his cane, that I went away resolved rather to perish than run the hazard of being ill used. As soon as we were drove away the town and stores were sold for £300, which a great officer of ours put into his own pocket, when good men were perishing with hunger and weariness, and what was left to the enemy might have plentifully relieved their wants. Our colours and some officers were now in town but no soldiers, so the ensigns were ordered to strip their colours, and thus we set out on our way to **Limerick**, my ensign having met me there, and {ms folio 86b} furnished me with a mare he had taken up upon the road. A troop of **Dublin** militia marched this day for **Limerick**. We set out five in company, and having travelled about six miles over the mountain found night drawing on, and therefore struck down to a small village in the famous bog of **Monelly**. Here are the ruins of an ancient monastery, and is therefore to this day called the monastery of **Kilcooly**. There is nothing left of it but the ruined walls divided into two or three little tenements, the churchyard enclosed, the church walls are standing which show it to have been large and beautiful, there are several tombs, round one of which belonging to some of the Butlers are still the twelve Apostles and upon one of the walls a crucifix and image of our blessed lady at the foot of it, all of marble. The bog of **Monelly** by some is reported to be sixty, by others thirty miles in length. I cannot find it to be so much as the lesser computation, but at that time being a dry summer it looked more like a pleasant plain than bog, being full of cornfields, meadows, castles and villages, enclosed all round with high mountains to which it yields a delightful prospect. It is very level and they say in winter most overflowed, and in time of great rains the villages almost inaccessible, but even in the hottest season some parts are impassable, This place is eight miles from **Kilkenny**; in it we 



---

p.137



found good entertainment for ourselves and horses, which was all the comfort left amidst so many fatigues and misfortunes.


Saturday the 5th: on our march we passed by **Clonamicklon**, a house of the Lord Ikerrin[163](javascript:footNote('E680002-001/note163.html')) about a mile from **Kilcooly**, and rested five miles farther at **Killenaule**, a small poor village on the mountain, whence we travelled to **Cashel** which is six miles. It is an archbishopric and the metropolitan see of **Munster**, and one of the ancientest in the kingdom. The cathedral seems not so beautiful as ancient and stands like a castle on the top of a rocky hill out of town, I thought it not worth time to go up to see it, being satisfied with the outward appearance. All manner of refreshment was hard to be had here but necessity overcame all difficulties. Hence we travelled five miles to a gentleman's house upon the road, where was plenty of all provisions. Some few of our stray officers, being got in before, endeavoured to make good the house against us, the confusion of the time which ought {ms folio 87a} the more to have endeared us to each other, being fellow sufferers in the same cause, making some men rather inhuman and barbarous to those they should relieve and support. Insomuch that one who was within the house would not admit his own brother who came with me to the gate, and where such near ties of blood could not prevail, it is not to be thought our being fellow officers in the same regiment could have any influence. Fair means being of no effect, necessity obliged us to use violence, and with much difficulty we forced our way into the house, where was such plenty as might have contented an entire regiment, much more about a dozen that we were in all, and yet those few first possessors thought all too little for themselves.


Sunday the 6th: we travelled four miles to **Cullen** a small town, where we heard mass the church being then in the possession of the Catholics. Hence is seven miles to **Cahirconlish**, a small village, where was assembled a great number of the country people armed with roperies to receive the Duke 



---

p.138



of Tyrconnel, thence a mile to **Carrig**, and from this four miles to **Limerick**. In the suburbs we met some of our fellow officers who acquainted us there was no accommodation in the town for man or horse, whereupon we turned back and took quarters at a good farm-house a mile from the town, where we found good entertainment and, what was very pleasing, civil reception, in this place as many others, which was a dainty, the best drink was milk and water. The reason no room could be had in town was that most of the best was taken up by the principal officers, and they that came first had taken possession of whatever small places the great ones had rejected. We continued here Monday and Tuesday suffering hourly and furious assaults on our quarters from all who passed that way, which with much difficulty we made good. Some, but few, of our regiment came up during this time; but vast numbers of all sorts of people flocked to town. Hitherto all things remained in confusion no resolutions being taken and consequently all left to their liberty without any command, till at length.


Wednesday the 9th: orders were given to all officers to endeavour to gather the remains of their regiments, and to ours in {ms folio 87b} particular to march four miles to the westward of **Limerick** [164](javascript:footNote('E680002-001/note164.html')) to a village called **Carrigogunnell** and the adjacent places, there to quarter till the rest of our dispersion came up and we received fresh orders. The most remarkable thing in this march was that the number of officers exceeded that of the private men, and yet not one-half of the former were present. These quarters proved very refreshing after our long fatigue, the people being generally very kind, as some thought partly for love, but in my opinion most through fear. For most certain it is few are fond of such guests as soldiers are upon free quarter, especially such as ours were ravenous and unruly, but it is the wisest course to make a virtue of necessity, and offer that freely which otherwise would be extorted forcibly. We had here plenty of meat and barley 



---

p.139



 
bread baked in cakes over or before the fire and abundance of milk and butter, but no sort of drink. Yet there this is counted the best of quarters, the people generally being the greatest lovers of milk I ever saw, which they eat and drink above twenty several sorts of ways, and what is strangest for the most part love it best when sourest. They keep it in sour vessels and from time to time till it grows thick, and sometimes to that perfection it will perfume a whole house, but generally speaking they order it so that it is impossible to boil it without curdling four hours after it comes from the cow. Oaten and barley bread is the common fare, and that in cakes, and ground by hand. None but the best sort or the inhabitants of great towns eat wheat, or bread baked in an oven, or ground in a mill. The meaner people content themselves with little bread but instead thereof eat potatoes, which with sour milk is the chief part of their diet, their drink for the most part water, sometimes coloured with milk; beer or ale they seldom taste unless they sell something considerable in a market town. They all smoke, women as well as men, and a pipe an inch long serves the whole family several years and though never so black or foul is never suffered to be burnt. Seven or eight will gather to the smoking of a pipe and each taking two or three whiffs gives it to his neighbour, commonly holding his mouth full of smoke till the pipe comes about to him again. They are also much given {ms folio 88a} to taking of snuff. Very little clothing serves them, and as for shoes and stockings much less. They wear brogues being quite plain without so much as one lift of a heel, and are all sowed with thongs, and the leather not curried, so that in wearing it grows hard as a board, and therefore many always keep them wet, but the wiser that can afford it grease them often and that makes them supple. In the better sort of cabins there is commonly one flock bed, seldom more, feathers being too costly; this serves the man and his wife, the rest all lie on straw, some with one sheet and blanket, others only their clothes and blanket to cover them. The cabins have seldom any floor but the earth, or rarely so much as a loft, some have windows, others none. They say it is of late years that chimneys are used, yet the house is 



---

p.140



never free from smoke. That they have no locks to their doors is not because there are not thieves but because there is nothing to steal. Poverty with neatness seems somewhat the more tolerable, but here nastiness is in perfection, if perfection can be in vice, and the great cause of it, laziness, is most predominant. It is a great happiness that the country produces no venomous creature, but it were much happier in my opinion did it produce no vermin. Whether nastiness or the air be the cause of it I know not, but all the kingdom, especially the north, is infected with the perpetual plague of the itch. In fine unless it be the Scotch no people have more encouragement to be soldiers than these, for they live not at home so well at best as they do at worst in the army both for diet and clothes, and yet none will sooner murmur and complain of hardship than they. It is not through prejudice I give this account, but of love to truth, for few strangers love them better or pity them more than I do. And therefore to do them justice, I cannot but say it is not to be admired they should be poor having been so long under the heavy yoke of the Oliverian English party, whose study it was always to oppress and if possible to extirpate them. Poverty is a source from whence all other worldly miseries proceed, it makes them ignorant not having wherewithal to apply themselves to studies, it enervates the spirits and makes them dull and slothful and so from race to race they grow more and more degenerate, wanting the improvements of a free and ingenuous {ms folio 88b} education, and being still brought up in a sort of slavery and bondage. This may be easily evinced by such of their gentry who having been abroad become very accomplished men either in learning warlike affairs or the more soft and winning arts of the court. Though the Scotch abroad be not inferior to them, yet at home they are as poor, as ignorant, more brutish and more nasty without any excuse for it, having never been oppressed or kept under as the others by a foreign yoke. This I have found by long and dear-bought experience and thought it not unworthy observation in these few days of respite from labour, having nothing else to divert my melancholy thoughts during this small breathing after so 



---

p.141



great a series of misfortunes. Our scattered forces daily gathered to **Limerick** being thence directed each regiment to their respective quarters.[165](javascript:footNote('E680002-001/note165.html'))


Saturday the 12th: in pursuance of the orders received the night before, we rendezvoused at the head-quarters to the number of about 150 men, some with arms fixed, others unfixed, and others without any arms. Thus we marched to **Limerick**, and halted there a considerable time without the town, to receive bread, where about fifty more joined us. Hence we marched three miles to the eastward of the city and encamped in a plain on the left of the Royal Regiment of Foot Guards, which here made two small battalions not equal to 



---

p.142



one good one, having before made three complete and large ones.


Sunday the 13th was spent in building huts, it being too late the night before and all our tents lost the unfortunate day at the **Boyne**, as was most of the baggage of the army. The tents were most thrown about the fields or left in heaps with the soldiers' snapsacks before the rout. The officers' baggage was all sent away with a guard towards **Dublin** before we marched, but upon the defeat much plundered by those who were appointed to preserve it, and most of what they left ransacked by our own dragoons, and even by some of our officers who being well mounted were swiftest to overtake it. As afterwards appeared by many who were discovered and convicted of the fact, and, among others for an instance, our captain-lieutenant was found wearing the clothes and linen of a considerable officer of horse and refusing upon demand to make restitution, tried {ms folio 89a} for the same by a court-martial, where he could give no account how he came by them, and was accordingly found guilty of the fact, commanded to restore all that was challenged, and by favour of the times only imprisoned during some few days. By this disorder of our own men though the enemy got but little, very many of us were left almost naked, not having so much as a shirt to change. In which condition being a stranger and without friends I continued many days, for money was as scarce as clothes and what we had only brass, which was then of very little or no value, till I met an Englishman who had but three shirts yet taking compassion of me gave me one, which was the first relief I had after losing all. One comfort was I did not want companions in misery, though few reduced to so great extremity as myself, the Irish being in their own country, and though perhaps many far from home yet few but had some friend to assist them; and most of the English officers 
were then withdrawn from the regiment.


Monday the 14th: we were reviewed by Brigadier Wauchope, and our regiment found to consist of 150 men with arms fixed, 50 unfixed, and almost 100 without arms. A dismal and most shameful sight, the king a fortnight before giving 



---

p.143



 
pay and bread to 800 men in this regiment all well armed and clothed, and now reduced to this without firing one shot at or scarce seeing the enemy. The calamity was general and no one regiment could upbraid another, their circumstances were so much alike. It was proposed and threatened to shoot some of the unarmed men for an example to terrify others from throwing away their arms, but the numbers being so very great it was only declared to them how well they had deserved to die. A strict charge was given to the officers to see the fixed arms well kept, to fix such as were broken, and use all possible endeavours to find more, and keep the men under discipline.


Tuesday the 15th: nothing remarkable happened, but many of our men came up and joined their regiments.


Wednesday the 16th: in the morning we decamped, and the regiments being so very weak as I said before they were joined by two and two, to us was joined the Lord Slane's.[166](javascript:footNote('E680002-001/note166.html')) The whole day was spent in marching to **Limerick**, though it was not full four miles. In the city {ms folio 89b} were left all the French, the Royal Regiment of Foot Guards, the Grand Prior's, Major General Boisseleau[167](javascript:footNote('E680002-001/note167.html')) and Sir John FitzGerald's, the rest 



---

p.144



marched through and encamped. This day was to have been put in execution a design before projected and contrived by some of our most active officers, but that accidentally discovered to and prevented by his grace the Duke of Tyrconnel, which was thus. A council being held by the Duke and other leading men to consult what was to be done in this desperate state of our affairs, his grace was of opinion all was lost, and therefore thought convenient to make the best conditions with the enemy and surrender before it was too late. This advice was so far from being approved that it moved much indignation in some of the hearers, and that with just cause, and it was unanimously resolved to suffer the utmost extremities rather than submit to the usurper, and to hold out what was left to the last. Hereupon the duke thinking it impossible to keep the field, and, running from one dangerous extreme to another no less prejudicial, declared himself for hamstringing all the horses, and bringing the men with what provisions could be gathered into the garrisons, a proposal no less dangerous in the consequences if followed than cruel in the execution. These opinions caused great heats and animosities, all men in general exclaiming against them, and those in particular who were of a contrary faction to the duke laying hold of this opportunity to make him odious to the army, and if possible to remove him from the government, as was afterwards attempted by sending commissioners into France to that effect. The duke being thus lessened in the public esteem, though he retained the character, and all orders run in his name as Lord Lieutenant, yet was there not the due subordination to him, and many private cabals were held not only without his knowledge, but to oppose his authority, and among the rest this whereof I now speak. It consisted of many field officers of the contrary faction to the duke, among others the Luttrells, the O'Neills,[168](javascript:footNote('E680002-001/note168.html')) and, though inferior in post, 



---

p.145



 
Connel, then lieutenant-colonel to the Lord Slane, had a principal part as being a young active man and well beloved among the foot. They, finding that the French intended to leave us and embark themselves and their cannon for France, and considering that thereby we were {ms folio 90a} not only weakened in men, whereof they feared not so much the want, but in so many good arms at that time so scarce among us.[169](javascript:footNote('E680002-001/note169.html')) The French being then quartered in the city and the Irish forces encamped, as was said before, they agreed on this day to send orders to the camp, as from the Duke of Tyrconnel, though unknown to him, for the forces to march to **Limerick**, in appearance as if to march through and encamp on the other side, but the officers privy to the design being ready, they should suffer all to march in till such time they had filled all the streets, and the French not suspecting any design on them, but being dispersed and unarmed they were on a sudden upon a sign given to seize the gates of the city, and then by beat of drum to command the French to march out leaving their arms behind them, and not suffer them anywhere to come to a head with arms, but thus naked to ship them with all convenient speed for France, and distribute their arms among our men that wanted. This project was carried on with such secrecy and so well laid it had certainly taken effect had not one of the managers ignorantly, as thinking him a party, opened it to the then colonel, after major-general, Mark Talbot, who having got an inkling soon dived to the bottom of the contrivance, and immediately made it known to the Duke of Tyrconnel, who found no difficulty to break all their measures, though he caused the army to march as they had designed, but he parted the managers, and they finding themselves discovered had 



---

p.146



no opportunity to execute their design. The duke showed much prudence in this action, for though he prevented the execution, he would not seem to know anything of the design, and it was so hushed that it never came to the knowledge of many, which was a great happiness, for had the French been sensible of any such attempt it might have proved fatal both to them and us. It was no less our good fortune, in my opinion, that it did not succeed, for although the cabal had designed to send commissioners into France to estimate and excuse the fact by urging the absolute necessity there was of keeping those arms, yet I doubt they would have found no favourable reception, nor indeed could the action be well justified, but would doubtless have incensed the court of France against us, {ms folio 90b} and we had been left to perish for want of those small supplies wherewith we afterwards held out so long, and at last purchased so good conditions. Though all seemed hushed and quiet yet there was some confusion among the heads, which occasioned that we had no quarters assigned us this night, but, after standing till dark night at arms, were dismissed to shift for ourselves till next morning.


Thursday the 17th: quarters were assigned us, in some houses one, in some two companies. **Limerick**, being the principal city at this time and long after that held out for the king, and consequently there being often occasion and that on account of many memorable occurrences to speak of it, having been long quartered in it during that season, I will endeavour to give a true and exact description of it, but as brief as the small compass of this journal requires. **Limerick** is seated in a plain on the banks of the river **Shannon**, a branch whereof runs through and divides it into two, the one called the English, the other the Irish town, and encompasseth the former together with a considerable spot of ground without the walls called the King's Island, and so falls again into the main body of the river as appears in the map,[170](javascript:footNote('E680002-001/note170.html')) to which recourse may be had in relation to all that shall occur hereafter, 



---

p.147



 
all remarkable places being marked with letters or figures and those explained on the map. The English town, by some as being the principal distinguished by the name of the city, is seated within the island made by the **Shannon**. It is encompassed by a stone wall in most places four, in some but three, foot thick. The houses are most of stone strong built and generally high, the whole consists but of one large street, the rest being all narrow lanes. Within the walls are two churches and two chapels. Our Lady's Church, which is the cathedral, is large and has a high tower, and was in the hands of the Catholics all the time of our residence there, and the body of it towards the latter end made a magazine of meal. St. Munchin's, over against the bishop's house, small and inconsiderable, before our time decayed, first made by us a place for gunsmiths to work in, after a magazine of warlike stores. The Dominicans had built a new chapel in the place called St. Dominic's Abbey in the upper part of the city, the Augustines had another {ms folio 91a} on the river near **Ball's Bridge**. On the east side without the walls down to the water was a large suburb, and in it St. Francis's Abbey at that time possessed by the Franciscans, the most part ruined, but the body of the church which was very large then in use, the other ruined parts being cut off. On the west side is the quay, though narrow in compass yet considerable for that upon high tide vessels of two hundred tons come up to it. Without the island gate stood a house of entertainment with a bowling-green and pleasant gardens. At our coming there were only the ruins of a small fort in the island, the rest being partly a common walk for the citizens and let out for grazing, this land being of the perquisites belonging to the constable of the King's Castle. Over the **Shannon** is a very large stone bridge called **Thomond Bridge**, at the end whereof was another considerable suburb and a hill that overlooks all the city and renders it not tenable if that be possessed by an enemy. Within the city adjacent to the bridge is the **King's Castle**, the walls thereof like to those of the city, but strengthened with square towers or bulwarks whereon were several good pieces of cannon. This castle, the bridge, and walls of 



---

p.148



the city were the work of King John. Over that branch of the **Shannon** which compasses the island is **Ball's Bridge**, of stone but small, the river being narrowest there; this joins the two towns and leads into the principal street of the Irish, the rest as in the other being all but narrow lanes. From the bridge this street runs to St. John's gate, the principal entrance of the town, joining to which is the citadel; to the cityward it is square of small compass and has two small platforms, without it makes a half-moon; the whole work of stone but weak, and was then furnished with only a few small pieces of artillery. On the other hand not far from the gate is St. John's Church, the parish, wherein nothing worthy of note. Between this and **Mungret Gate** was the Capuchin's chapel, so new it never was completely finished. The whole length of the east side under the wall was all tanyards, besides many more in the island, the tanning trade being here very considerable. In the angle made by the {ms folio 91b} great street and **Mungret Lane** stands **Thom Core Castle**, reported to be built by the Danes, but in reality is nothing but a high stone house, in nothing that I could perceive differing from many others of the town. The walls of this town are everywhere four foot thick strengthened with several towers; there are four gates Mungret, East and West Water, and St. John's. Without this was a very large suburb the main street whereof reached to Cromwell's fort, which is near a quarter of a mile southward, and the road to **Kilkenny**. It runs also a considerable way to the eastward and on the other side westward, till it joined that of **Mungret Gate** and came almost down to the body of the **Shannon**, so that it compassed almost the whole town. In digging this latter part for the fortifications were found vast numbers of skulls and other bones of men, but I could not meet any could give an account how they came there. Though the buildings of the suburbs were not for the most part equal to those within the walls, yet there were many very fine houses and I believe the suburbs on all sides were larger and contained more inhabitants than both the towns within the walls. Yet all these at our first coming, except that small part about **St. Francis's Abbey** in the island, were laid level with the ground 



---

p.149



for the better defence of the place and all the gardens and orchards utterly destroyed.[171](javascript:footNote('E680002-001/note171.html')) Nor did the ruin stop at the suburbs, for upon the approach of the enemy our dragoons burnt all round, far and near, and at several times the country before very well peopled and improved was almost turned to a desert, the fury of war destroying in one year the improvements of many years' peace, but hereof I shall speak more in the proper place. I shall only add that when first I saw this city, about four years before, it was inferior to none in Ireland but **Dublin** and not to very many in England and have lived to see it reduced to a heap of rubbish, the greatest and best part utterly demolished and scarce a house left that sustained not some damage. Such are the effects of war and such the fruits of rebellion. To return to the course of our proceedings, the French were employed in demolishing the suburbs, which they performed with such wonderful dexterity, it was almost incredible so much could have been razed in so short a time, but their {ms folio 92a} talent lay in destroying. There being no outworks to the town but only the bare wall, it was resolved to cast up such as the shortness of the time would permit, the main part whereof was only a covered way round the walls with three or four little works within like bastions but very small and inconsiderable, with slight lines of communication between them. Before **Mungret Gate** to take in a rising ground that might annoy the town was cast up a large but slight hornwork. On the east side at a little distance from each other, almost, opposite to the south-east angle, two small redoubts, and another of only stones heaped one upon another opposite to **St. John's Gate**. In order hereunto this day the Lord Gormanstown's and Lord Bellew's Regiments, which were joined and amounted to near 1,200 men, mounted the work.


Friday the 18th: the Lord Grand Prior's to which were 



---

p.150



joined the Lord Slane's and major-general Boisseleau's mounted the work, with a detachment of the Foot Guards. The French besides levelling the suburbs undertook to throw down the parapet of the citadel, which was of stone and not fit for service, and instead thereof raised a strong sod work capable of six or seven cannon and of force against the enemy's batteries. All the timber of the houses was ordered to be preserved and carried into town.


Saturday the 19th: Colonel Talbot with all the Grenadiers of the camp prepared the palisades. Gordon O'Neill and O'Donovan's Regiments [172](javascript:footNote('E680002-001/note172.html')) were at the work with all their 



---

p.151



 
officers. The brigadiers of each brigade were appointed to view all the officer's horses, such as were fit for service to be priced and taken for the king's use, the officers of such regiments as were to continue in town commanded to dispose of the rest.


Sunday the 20th: Gormanstown's and Bellow's Regiments 
at the work.


Monday the 21st: the days being long and very hot it was found the men could not hold out with vigour from sunrise to sunset, it was therefore thought expedient to keep them close whilst at it and have them relieved; accordingly Hamilton's Regiment, mounted first, were relieved by Kilmallock's and they again by Burke's [173](javascript:footNote('E680002-001/note173.html'))


{ms folio 92b}Tuesday the 22nd: The Grand Prior's, Bellew's, and Gormanstown's Regiments, commanded by the Lord Slane, marched about five miles into the county of **Clare** towards **Brian's Bridge** to a wood near the river to bring palisades, which were there ready cut. Gordon O'Neill was at the work in the town.


Wednesday the 23rd: **Athlone** having been some days besieged and by Colonel Grace the governor well defended, it was thought fit to send him some relief, the enemy being only on the **Leinster** side of the river and **Connaught** side open. Here upon this day one battalion of the guards, the Grand Prior, Slane and Boisseleau's detachments making another battalion, Gormanstown and Bellew a third, Hamilton and Sir Maurice Eustace[174](javascript:footNote('E680002-001/note174.html')) a fourth, and the French detachments, 



---

p.152



two other small battalions, marched out of **Limerick** and lay this night at **Killaloe**, the men without tents or quarters in the gardens. The officers were quartered in the town, the great ones taking up the best houses which are not many, the inferior were crowded into very poor cabins that only served barely to cover them from the weather. These eight miles from **Limerick** is part of the county of **Clare** and is all very bare, there being in this way scarce any corn or meadow, but only a hilly common in some places boggy, everywhere covered with fern and rushes, which is all it produces. The road is hard and pleasant for the most part open and often crossed by small brooks and springs, near a mile at first is a large causeway over a bog, not unlike to the old Roman ways being raised high because of the floods. A little above the midway is the wood whence we had the palisades, it is not large nor produces any large timber. **Killaloe** is a bishopric, but as to the town the meanest I ever saw dignified with that character, except St. David and St. Asaph in Wales, having but very few houses that are anything tolerable, the rest and even those in no very great number are thatched cabins or cottages, in fine it has nothing beyond many villages in England, nor is it equal to some, except the church be reckoned which indeed is large, and so all is said of it, having nothing else beautiful or commendable. The bishop's house like the rest has nothing worthy observation. The **Shannon** runs by the town, and in this place is so {ms folio 93a} rocky it is not navigable, so that all goods must be carried from **Limerick** till above the town by land, and being embarked there the river is again navigable for many miles. The most remarkable thing here was that the protestant bishop of the place continued then and long after in his diocese under his Majesty's government.[175](javascript:footNote('E680002-001/note175.html'))


Thursday the 24th: we marched first along the side of the 



---

p.153



mountain near the **Shannon**, which about this place makes a very large lough or lake. This way is very close and woody but lasts not long, as soon as out of it the rest is across the barren hills till we came to a small village called **Tomgraney**, which is five Connaught miles from **Killaloe**, and the miles here are of an excessive length. We halted a little farther at another village called **Scarriff**, neither of these places worth the naming but for some iron mills that were there before the war. Close by these two places is a large stone bridge which joins, or rather the river that runs under it parts, the counties of **Clare** and **Galway**, the same being also the bounds of the provinces of **Munster** and **Connaught**. At **Scarriff** begins one of the most desert wild barbarous mountains that ever I beheld and runs eight miles outright, there being nothing to be seen upon it but rocks and bogs, no corn, meadow, house or living creature, not so much as a bird. Nothing grows there but a wild sedge, fern, and heath. In wet winters this way is absolutely impassable, in dry summers it is a soft way, but at best in many places very boggy, so that at no time cannon or heavy carriages can pass that way.[176](javascript:footNote('E680002-001/note176.html')) This day we marched about four miles of the mountain, a violent rain falling most part of the time, which made the way extreme toilsome afoot the long sedge twisting about the feet, and the bog sucking them up, as that which immediately draws in the water being naturally soft and yielding. For our comfort at night we had a bare bog to lie on without tents or huts or so much as the shelter of a tree, hedge, or bank. The rain held most part of the night, and scarce any firing to be had the place being furnished but with a few and those small scattered trees, and we tired and without any tools to cut wood. Meat was as scarce as other necessaries, but that we might not be destitute of all, Providence had furnished a small brook which, though {ms folio 93b} foul and ill tasted by reason of the rain and bog, afforded us plenty of drink.


Friday the 25th: with the day began our march over the 



---

p.154



remaining part of this barbarous mountain, just at the end whereof is a wood very thick*,* the trees coarse and misshapen and as the others affords no large timber. It was a great satisfaction to us from the tops of the mountains to discover at a distance ploughed land, pasture and some few scattered cottages. At length having passed what was left of the solitude we came to a small place the English call **Woodford** and the Irish **Graig**, where it being St. James's Day we halted and heard mass.[177](javascript:footNote('E680002-001/note177.html')) Then marched four miles farther through a more tolerable country, but not over fertile or well improved to a poor village called **Duniry**, where we were drawn up in the fields early enough to have hutted had there been necessaries for building.[178](javascript:footNote('E680002-001/note178.html')) Wood there was but scarce anything wherewith to cut it, yet for form the soldiers were obliged to break boughs the best they could and make the shape of huts, which there being no straw or other thing to cover them with, was merely for show and not conveniency, so that in fine we lay without any other covering than the canopy of heaven. I know not whether a true devotion wherewith soldiers are seldom overstocked or whether it were not rather superstition to which they are subject enough, that prevailed with our men to spare a few trees, that stood in the front of our battalion. The country people, whether as a received tradition or to the intent to save them, telling some story of a saint who had lived there and after his death visibly punished some one who had presumed to destroy the trees. The story I understood not well, nor ever before or since heard of the saint, but many such are usually related there.


Saturday the 26th: the news of raising the siege of **Athlone** being come to the Duke of Berwick who commanded in chief, though the news was not made known, yet why kept secret is a mystery, the Irish forces continued here, but the French detachments marched back to **Limerick** to our great satisfaction, 



---

p.155



for of late these who were sent to assist us were grown if possible a worse enemy than those we were in arms against, which was occasioned by our misfortune at the **Boyne** in this manner. Since that most unhappy day (when as the Scripture has it, we fled nobody pursuing of us[179](javascript:footNote('E680002-001/note179.html')) {ms folio 94a} the army like sheep without a shepherd having dispersed themselves all over the country lived upon the spoil of the people they ought to have defended from their enemies. When we began again to make head at **Limerick**, both in camp and in the town the soldiers were forbidden upon pain of death to plunder, to quit their colours marching, and several severe punishments threatened to all manner of offences, but nothing at all put in execution. The soldiers, who (like a wild horse that has once got his head is not easily to be checked or stopped) had tasted the sweet of living at discretion on the public, and were grown proud of being under no command, were not easily to be curbed without some very severe examples, which were so far from being made that the men began to believe their officers durst not punish them. Nay some stuck not to say they were disbanded and consequently under no command, which notion they had taken from some timorous officers, who at or near **Dublin** ordered their men to shift for themselves, notwithstanding the colours of most were marched flying to encourage the men to repair to them, and only Sir Michael Creagh's Regiment[180](javascript:footNote('E680002-001/note180.html')) was formally disbanded by their major in **Dublin**, the colonel being too swift to stay for that ceremony, and by what authority the major dismissed them is hard to find, but fear is unaccountable. In fine the dread and consternation of some officers had debauched the whole army and the time hardly allowed a speedy redress to these abuses. But to come to the cause of this reflection, the French improving this opportunity were run to that height of insolence that they 



---

p.156



were more terrible to the country and offensive to the army than our very enemies. They generally contemned the Irish, esteeming them all as cowards for the disgrace at the **Boyne**, and were much the more confirmed in their opinion, because all their insolences passed unpunished, the government winking at their crimes, and each particular person, I know not through what infatuation, putting up peaceably with whatever indignities they were pleased to heap on them. From ill language they came to worse actions, often beating even the soldiers and forcing from them and from their officers whatever they liked, and very rare that they met with any check, but still if any opposition {ms folio 94b} were made they carried all before them, not because they really were superior in any respect, but because the others had, as I believe, conceived some such opinion of them, like horses that are ridden because they know not how much they are stronger than their rider. A passage I saw under the walls of **Limerick** may serve for an instance how much they stood in awe of the French. When the first works were carrying on about the town, there lay heaps of timber and boards of the ruined houses. Three soldiers coming to one of the heaps would have carried away some piece for firing, but a Frenchman, a person of no command as being only an officer's servant, not only hindered but gave them very ill language first, and then fell upon and beat them severely, which caused a great disturbance among the other soldiers who were at the work. Whereupon the officer of the guard at **St. John's Gate**, which was just by, sent a sergeant with a file of musketeers to secure the Frenchman, who seeing them come for him was so far from submitting that he drew and drove them all back to their guard. And yet the fellow was not so desperate but that an officer coming up to him with his sword drawn, he submitted and went peaceably to the guard, but his countrymen were not sparing of their reflections upon an insignificant fellow's driving with only his sword a halberd and so many muskets. Wherever they marched they plundered the country without any distinction of friend or enemy, and their own officers were so far from curbing that it is rather to be believed they were sharers with them, and 



---

p.157



consequently not only connived at but encouraged these disorders. Their colonels and general officers having all quitted them at the **Boyne** except Zurlauben,[181](javascript:footNote('E680002-001/note181.html')) who brought them off with honour and failed not to give some of their characters to the French court, though favour there as well as in others covered their indelible stains. As for our officers they paid them not the least respect, and this very march some of them shot a lieutenant of the Grand Prior's Regiment only for challenging a saddle they had stolen, of which wounds he died two days after, and some of our men having taken the murderer, they forcibly rescued him so that this barbarous action passed unpunished as all the rest. True it is many were made {ms folio 95a} officers, whose want of sense and honour and even of the mien of gentlemen, brought a contempt upon all, and the ignorance of their duty or licentiousness of the time caused many gross errors against martial discipline, so the abovesaid lieutenant was ranging the country when he ought to have been marching in his post and met a dishonourable and deserved death, though not from that hand, the extravagances of officers though generally an example and encouragement being no justification of the insolences and barbarities of the soldiers. These villanies caused all people to fly before us as we marched and all provisions were hidden from us wherever we came, so that we suffered much, and sometimes necessity obliged us to be cruel and force from the poor people what they hid from others. The brass money which our misfortunes had much lessened in the common esteem the French made so contemptible it was scarce of any value, for they being always paid in silver, had no regard for the brass, but would give half a crown of that coin for a silver three-halfpenny piece and 



---

p.158



forty shillings for a silver crown. Whereupon all things were sold accordingly, as a pair of shoes for forty shillings, stockings that used to be sold for nine or tenpence were now worth five shillings, ale nine or twelvepence the quart, wine four shillings brass or sevenpence silver, brandy ten shillings brass or tenpence silver. In short all things were at this time according to this rate (for it grew worse and worse daily) and we who were paid in brass had a miserable sustenance. The people shut up their shops and followed no trade and the French soldiers engrossed the whole into their own hands at their own rate. But to return to our march:


Sunday the 27th: we marched to **Loughrea** six miles, all the country hitherto is wild, mountainous and in my judgement may be called barren, but some people are so blinded with affection they will not allow the worst of soils to be called barren, because it produces fern and wild sedge, which the miserable cattle having no better are forced to feed upon, and yet some will maintain that to be a rich soil, which all the art of man cannot improve so as to bear anything but oats and potatoes. At the town begins a valley which extends some miles in length and breadth. It is not very plain, but has several old ruins of castles and gentlemen's houses {ms folio 95b} and there being many enclosures from the mountains it looks like an exceeding pleasant and fertile place, but coming to view all this near it is only ruins and a barren soil, wherein are some scattered cornfields, some coarse pasture and the rest nothing but fern and rushes. The town is like the country, promises well at a distance, but when near you find only the remains of a formerly indifferent place with some memory of walls, the gates yet standing. There is also little more than the ruins of a very considerable house belonging to the Earls of Clanricarde. Adjoining to the town is a great lough or lake out of which runs a small river, and from the lough I suppose the town takes its name. Here every company had a house assigned for quarters.


Monday the 28th: we continued here. Brigadier Sarsfield[182](javascript:footNote('E680002-001/note182.html'))


---

p.159



marched away with the horse under his command who had quartered in the neighbourhood. At our setting out of **Limerick** there marched also four pieces of cannon and a body of horse and dragoons, all which took the way of **Loughrea** for the conveniency of the road which is hard and fit for draught, whereas the way the foot took (as I said before) was unfit for heavy carriages, but being the shorter was judged best for the foot, both for their ease and that they might the sooner relieve **Athlone**, which was thought to be pressed and in danger and by their coming might be strengthened the better to expect farther relief. But upon the news of the enemies quitting the siege, the foot marched back the easiest though the longest way, and where they could have quarters to refresh them.




---

p.160


#### 3


Tuesday the 29th proved an excessive hot day, yet we marched nine miles of that country (which are the longest I ever saw) without halting, then rested a while near Gort,[183](javascript:footNote('E680002-001/note183.html')) a very small inconsiderable village upon a very rocky river, over which is a stone bridge, and adjoining to it a very large house. The road hither is along one end of the bottom I spoke of before, and partakes much of the hills and barrenness. After a short halt we marched three miles farther to a mill about a mile from the place called **Toberreendony**, famous for a clear spring dedicated to our blessed lady, as the name imports in Irish, and held in great veneration by all the neighbouring people.[184](javascript:footNote('E680002-001/note184.html')) Part of this way is through lanes, the rest very stony and hilly. Upon the road advice was brought that the enemy ad approached to **Limerick** and it was feared they would attempt to pass the **Shannon**, which if they had compassed might have been the loss of us all, we being but a small number of foot {ms folio 96a} and without horse or dragoons. Hereupon ammunition was distributed and both officer and soldier ordered upon pain of death not to stir from their post but to lie down upon their arms and take some rest till such time the general should beat, which was appointed within two hours, having halted about ten at night to march again at twelve. And though we had marched with only half an hour's rest from morning till this time at night and at a great rate yet could we the whole day make but twelve miles. I cannot but observe how little confidence was then to be reposed in our men, for notwithstanding the severe orders the fear of the enemy prevailed so much more over them than that of punishment, or any sense of honour, or their safety in standing by each other, that it appeared with the light at least one half of them were stolen away in the dark, those that were left being ready upon the first alarm to follow the example set them by their companions.


Wednesday the 30th: between twelve and one in the morning the general beat, and again ordered that no man 



---

p.161



upon pain of death should stir from his post in marching. We marched through a very thick wood and extraordinary rough stony way long before the least light appeared, and the road being so uncouth was exceeding troublesome in the dark. We had many falls and that sometimes in the water, some stony brooks crossing the wood and nobody seeing where they set their feet. When day appeared we were out of the wood and in a better way. Soon after day we halted to gather our scattered men and march again with some lighted matches. Now it appeared very many of our men had left us and among them some who had the reputation of being very brave, many of which upon occasions of danger I have found to be the backwardest of all, and that they gained a name only by being mutinous troublesome fellows, always in private broils, yet durst not look upon the common enemy. Having marched seven miles this morning we made a considerable halt to refresh the men at **Quin**, a small village, where are some considerable remains of an ancient church and abbey, then possessed by the Franciscan friars. Whilst we halted some men of each regiment were sent with officers to look out for provisions in the neighbourhood to bring to the men, who were commanded to pay for what they had. There was no other neighbourhood to seek anything, but those they call the creaghts,[185](javascript:footNote('E680002-001/note185.html')) which are much like the Tartar hordes, being a number of people some {ms folio 96b} more some less, men, women and children under a chief or head of the name or family, who range about the country with their flocks or herds and all the goods they have in the world, without any settled habitation, building huts wherever they find pasture for their cattle and removing as they find occasion. This is a custom much used in Ireland, especially in time of war as now, when thousands of all sorts fled from the dominion of the usurper and had no other manner of living but this. But the custom I believe is immemorial and was doubtless in use among them before the conquest by the English. They have small cars and garrons or little horses to carry their 



---

p.162



necessaries and live most upon the milk of their cows. With what they can spare they buy bread and other necessaries, or in these times of confusion make no scruple of taking where they find it. Particularly in gathering cattle they are industrious, for many who came from their habitations in **Ulster** with only one or two cows by the time they came to the neighbourhood of **Limerick** were increased some to fifty, some a hundred, and some more head of black cattle. They examine not whose ground they encamp in, and when they march drive all the cattle that comes in their way, and in some places I have heard them complained of as more grievous and burdensome to the country than the army, which seemed to me improbable and almost impossible, but that the country people affirmed the robberies and insolences of the soldiers were much inferior to the extravagant barbarities of those people. In short if they came first they left nothing for the army, and where they came after they carried away whatever the army had left. And though the irreconcilable hatred between **Ulster** and **Munster** be cause enough for those people eternally to reproach and slander each other,[186](javascript:footNote('E680002-001/note186.html')) and that they are never wanting in that part, yet certain it is the creaghts were worse to the country than the professed enemy or their costly friends, the king's army, and even in this the two provinces strove to be upon equal terms, the one always railing and the other always giving fresh occasion to rail. But it must be observed there were creaghts of the other provinces as well as **Ulster** though not so numerous, yet whatever was done the **Ulster** had the name of it. The design was to have marched through this day to **Limerick**, which was twelve miles from this place, a great march though the county of **Clare** miles be not altogether so long as those of **Connaught**. But being informed 



---

p.163



there was no danger of the enemy we only marched half-way to **Sixmilebridge**, which is {ms folio 97a} an indifferent good town and takes its a name from its distance from **Limerick** and a small bridge over a little river that runs through it, and thence into the **Shannon**, yet we were quartered three or four companies in a house.


Thursday the 31st: we marched to **Limerick** which is six large miles, almost half the way over a high steep and stony mountain, the rest plain and most part lanes, cornfields and meadows on both sides, all enclosed as in England. There is another way to avoid the mountain but farther about: I shall speak of it when I come to travel it. From our setting out till our return to **Limerick** we suffered much for want of provisions and above all of bread, for no ammunition bread was given and scarce any could be bought, only very rarely some few cakes of oats or bere, a grain much like to though not the same but bigger and coarser than barley, whereof all their beer and ale is made, little or none of their land producing the true barley. The city being filled with the chief officers, both civil and military, the guards and French, we were quartered in the Irish town one or two companies in a house.


Friday the 1st of August: all the regiments were drawn out and reviewed in the King's Island in order, as was given out, to receive money and bread and have quarters regulated. After standing at arms till about two of the clock we were dismissed without any thing, only orders that an officer of a company should make a true return of their arms fixed and unfixed, and of the number of their men present.


Saturday the 2nd: most of our horse and dragoons, some on the one side of the river some on the other, marched towards **Athlone**. This day also the French forces departed for **Galway** to the great satisfaction not only of the inhabitants, but of all the garrison that remained in town. They remained some time at **Galway** till ships came to carry them into France, thinking it impossible **Limerick** should hold out a siege, offering to lay wagers it would be taken in three days.[187](javascript:footNote('E680002-001/note187.html'))


---

p.164



Immediately upon their departure His Grace the Duke of Tyrconnel ordered it to be proclaimed that no person should presume to ask above thirty shillings for a pistole, thirty-eight shillings for a guinea and seven and sixpence for a crown in silver, pistoles before being sold for five pounds in brass and silver crowns for thirty or forty shillings. Nay this day the French marched out some of them gave a crown for each silver three-halfpenny piece.


{ms folio 97b} Sunday the 3rd: nothing of note, but that advice was brought of the approach of the enemy, and all preparations for their reception hastened accordingly.


Monday and Tuesday, the 4th and 5th: most part of these two days the foot, who were encamped on the east side of the town, marched through into the King's Island, carrying with them all the materials for building their huts, and encamped there. The small works about the town not being finished, the men were kept at work incessantly day and night.


Wednesday the 6th: there was nothing remarkable, but a review being taken of the Lord Grand Prior's regiment it was found to consist of 446 private men, besides corporals, sergeants and commissioned officers, making in all 543. Of these many sick and absent, but many more without arms. Though there was the name of many regiments in the garrison yet very few of them were near this number and fewer equal in goodness of men. I speak it not out of affection or vanity because I served in it, but because it was one of the oldest in the kingdom, giving their precedence only to the Guards and disputing the right with Hamilton's, all others yielding to it.




---

p.165


#### 3


Thursday the 7th: on the works mounted by brigades at noon went the Lord Grand Prior and Hamilton[188](javascript:footNote('E680002-001/note188.html')) and the regiments joined to them, which made a large brigade and had not as at other times a particular brigadier, but were commanded by him whose day it was. The enemy encamped within three miles of the town and our dragoons retired, burning all the country as they went. The devastation spread on all sides, and quite round might be seen some villages, and many farms, and considerable gentlemen's country houses in flames. Our negligence at first was cause that our works, though mean and inconsiderable, were not yet finished, so that no intermission could be allowed. Gordon and Felix O'Neill[189](javascript:footNote('E680002-001/note189.html')) with other regiments joined to them relieved the work in the evening to continue all night till break of day.


Friday the 8th: Gormanstown[190](javascript:footNote('E680002-001/note190.html')) and Bellew,[191](javascript:footNote('E680002-001/note191.html')) &c., mounted the work and were relieved at noon by the Grand Prior, &c. This morning the enemy's horse and dragoons came up within half a mile of the town, showing themselves on the rising 



---

p.166



grounds, and having taken {ms folio 98a} a view of all posts returned to their camp. A party of Colonel Luttrell's Horse being abroad, a small skirmish happened between them and some of the most advanced of the enemies. There was nothing in it considerable, only two of the enemy being taken and three or four killed, of ours only one wounded.


Saturday the 9th: the Prince of Orange invested the town, enclosing with his army all that is not surrounded by the **Shannon**.[192](javascript:footNote('E680002-001/note192.html')) Detachments of our foot, supported by the dragoons, disputed every field with the enemy, lining the hedges and retiring orderly from one to another after several volleys and some execution till they came within shelter of our cannon or outworks, and there they continued in small bodies in the ditches and kept their ground all night. In this skirmishing we lost but very few men, nor indeed could we spare them so that it was done only for form and to amuse the enemy. Giving way still as they pressed upon us, there was never an officer killed but Sir Maurice Eustace had his horse shot under him in the midst of us, and Fitzpatrick's major his in a field below us, but neither they nor any of us hurt. I will not be too exact in affirming what garrison we had, I know both to encourage us and terrify the enemy we were given out to be



---

p.167



15,000 strong, but I can be positive that to my knowledge we were not in all 10,000, including the unarmed men which were a considerable number.[193](javascript:footNote('E680002-001/note193.html')) This day the Grand Prior with the regiments joined, which I shall no more repeat, mounted the hornwork, Hamilton the east side trenches, Maxwell's Dragoons[194](javascript:footNote('E680002-001/note194.html')) from the south-east to the south-west tower, on the west side Bellew and Gormanstown. Detachments mounted the redoubts, the walls and English town being posts of less consequence, and never falling to these that were the best regiments, except the walls when the siege grew hot; I shall make no mention of them, not being able to give a general account of all places, being constantly tied to the duties of my post, which being in a regiment of such repute was commonly where there was most probability of service. I shall be brief in my relation of the siege, affirming only what I saw or received from eyewitnesses of credit, for considering my post at that time very much cannot be expected, and I had rather be brief with truth and omit small passages than by pretending {ms folio 98b} to more particulars than I can affirm deliver falsehoods or at least uncertainties. There was within the hornwork a small stone half-moon that covered **Mungret Gate**, now 



---

p.168



quite made up. This place was appointed for a party of horse and here constantly stood about thirty of Luttrell's regiment ready upon all occasions.


Sunday the 10th: one battalion of the Royal regiment of Foot Guards relieved the hornwork, Gordon[195](javascript:footNote('E680002-001/note195.html')) and Felix O'Neill the east side, Luttrell's Dragoons **St. John's Gate**, FitzGerald and Kilmallock the west. The enemy fired most part of the day some field pieces from Cromwell's fort and the hill opposite to the south-west commonly called the Ball tower. They did no execution though two or three balls went through the Capuchins' chapel in time of mass. Our cannon answered upon all occasions though to as little effect, only that we looked on the enemy's losses through multiplying glasses their loss could not be much, but some there was.


Monday the 11th: the Grand Prior mounted the east side where the O'Neills were, the second battalion of guards relieved the first and the rest in order. The Grand Prior also relieved the two redoubts of the south-east angle. The cannon played hot on both sides till the enemy's on a sudden gave over, it was thought ours had dismounted or at least endamaged some of their pieces. Some battalions of the enemy's being encamped within sight and reach of our guns, they played through them so smartly, that they were obliged to remove.


Tuesday the 12th: the works were relieved as before. We heard nothing of the enemy all day they continuing very quiet, as was thought being busy in the wood cutting of faggots, wherever they could be perceived to move in any body within reach on cannon continually played on them.[196](javascript:footNote('E680002-001/note196.html'))




---

p.169


#### 3


Wednesday the 13th: we mounted the same place, all other posts were relieved as usual, for the whole strength of the garrison even now at first consisted but of one relief, so that we were on duty every other day and were besides subject to all accidents of alarms which were frequent, and towards the latter end our duty was continual. This day before mounting was a review of all that were not upon duty. The unarmed men {ms folio 99a} were continually kept at work, the chief part whereof was in the King's Island, where was raised a square fort with four bulwarks, on one of them a small platform for three or four guns to play over the branch of the river that makes the island, where it was thought the enemy designed to raise a battery, having made some odd shots from thence. There were besides some breastworks cast up at such places as the river was most easy to be forded. This day passed without any molestation from the enemy.


Thursday the 14th: all the works relieved as usual. The enemy lay very still till about two or three of the clock, at which time they began to play furiously with four pieces of cannon on our platform of the citadel, and so continued very hot for about two hours, when on a sudden they gave over. Our cannon the meanwhile was not idle, but answered them so smartly both from that platform and above within the citadel that by their sudden ceasing as well as other signs which we could perceive, it was concluded we had done some considerable damage to their battery. On our side only a lieutenant lost an arm, seven or eight killed, and as many wounded.


Friday the 15th: we mounted as before. The enemy's cannon played at our platforms and did little or no hurt. Only on the north side some few men were hurt and two or three killed by the cannon balls which rebounded back from the stone wall.


Saturday the 16th: the works relieved as usual. All our unarmed men were continually kept at work, some fortifying 



---

p.170



the King's Island, others beating down the battlements on the walls, which were very high, took up much of the wall and did much harm when struck by the enemy's shot, because being of stone they flew about and {ms folio 99b} wounded all that stood near.


Sunday the 17th: having relieved the works the whole day continued very quiet. About midnight the enemy advanced on the south and south-east sides of the town. Not far from the south-east angle were two small redoubts and a third opposite to **St. John's Gate** on the south side. This last they attacked, which though made up only of loose stones laid one upon another was vigorously maintained by Hamilton and Eustace's Grenadiers, who behaved themselves so well that they repulsed the rebels and kept their ground till ordered to retire, that poor work being no longer tenable. A detachment of the Grand Prior's men, who were in the remotest of the two redoubts opposite to the south-east angle behaved themselves so ill that they quitted their post at the first charge and fled, some to the other redoubt and some to the trenches, with such precipitation that they lost their arms, the officers commanding there being the first, as it afterwards appeared, that gave the example to the soldiers of running, which they so readily followed that not one shot was spent in defence of the post. Lieutenant-Colonel Connel[197](javascript:footNote('E680002-001/note197.html')) of the Lord Slane's Regiment advanced out of the trenches, endeavouring to encourage the men to retrieve their honour by regaining the redoubt, but {ms folio 100a} the enemy being in possession and our men in a consternation nothing was effected, only that with some small reinforcement he put himself into the other redoubt, which secured it for that time he continuing there till we were relieved. The enemy after this success attempted not to proceed any farther, but were heard to work all the remaining part of the night and the next day, being




---

p.171


#### 3


Monday the 18th: it appeared they had raised a new battery upon **Cromwell's Fort**, so called for that it was raised by that usurper in the former rebellion when he besieged **Limerick**. It stands on a hill which overlooks the town about a quarter of a mile distant from it, the redoubt we lost the last night on the south side lying in the mid way to it. As soon as day appeared they began to play from that new battery with four pieces of cannon upon our small platform that covered the south-east angle, but with little success, some few balls being buried in it, others flying quite over the town, and some after glancing along the wall falling into our trenches, whereof one broke the legs of three men and a piece of another killed one man, but we retiring our men under shelter received no further damage. At the usual time we were relieved by first battalion of the Royal Regiment of Foot Guards, who were afterwards to be relieved by their second battalion, that post being taken from us, either because it being the most {ms folio 100b} exposed and consequently most honourable seemed of right to belong to the Guards or else silently to reproach us for the loss of the redoubt. This night the enemy advanced and attacked that redoubt we were still masters of near the south-east angle, and having made some show of attempting the trenches retired without gaining anything, their assault being but weak and of no continuance. The town took the alarm and all the garrison that was within continued the whole night, either on the walls or at arms, in the streets ready upon all occasions.


Tuesday the 19th: a strong detachment of the best men with firelocks and swords, for it is to be observed we had but few of those sorts of arms, was drawn out of the best regiments that relieved the trenches. The Grand Prior's with Colonel Moore's Regiment[198](javascript:footNote('E680002-001/note198.html')) mounted the hornwork where



---

p.172



the Regiment of Guards did duty before they were removed to the trenches on the east side. The hornwork is on the west side enclosing a small old stone half-moon before **Mungret Gate** now made up; in this half-moon stood continually a troop of horse ready upon all occasions. The hornwork was large to cover a hill which commands the greatest part of the town. The Grand Prior's battalion covered the south and west parts of the hornwork, Moore's the north or rather the north-west.


{ms folio 101a} The detachment before mentioned was advanced before the trenches on the east to have secured the redoubt of the south-east angle, if attacked, but the enemy attempted it not, and contented themselves with drawing a trench parallel to ours from the redoubt they had taken towards the river, our advanced men never endeavouring to disturb them, whereas they might easily have obstructed their work and done good execution upon them. Nothing else happened of moment, but whereas before we relieved the works in the morning now it was put off till the evening.


Wednesday the 20th: the enemy played from their battery on **Cromwell's Fort**, and from another they had newly raised on the redoubt they took from us opposite to the south-east angle. In the afternoon they vigorously attacked the redoubt we still maintained on the same side not far from their new battery. Lieutenant-Colonel Kelly of the Guards commanded there and twice repulsed the rebels,[199](javascript:footNote('E680002-001/note199.html')) but the third time the post was abandoned without any apparent reason for it, the defendants having sustained no loss and the enemy giving way; only the fear of our men, and, as I heard, the ill example of some officers, who {ms folio 101b} first quitted the post putting them to flight. An unfortunate sally was made after the loss of the redoubt at the east **Watergate** by all our horse, a party of 
 


---

p.173



dragoons afoot, and a body of foot. The loss of our horse for their number was great, many of them being killed and wounded. The foot behaved not themselves so well as was expected, but the dragoons advanced boldly and did much execution among the enemy's horse till being overpowered they retired in very good order, still firing as they gave way. Our loss was considerable and among the rest were killed Colonel Purcell[200](javascript:footNote('E680002-001/note200.html')) and his Lieutenant-Colonel Power,[201](javascript:footNote('E680002-001/note201.html')) and 



---

p.174



Lieutenant-Colonel Mockler.[202](javascript:footNote('E680002-001/note202.html')) The enemy lost a great number of officers and soldiers.[203](javascript:footNote('E680002-001/note203.html')) In the evening we were relieved, but to as little rest as at other times, for


Thursday the 21st: about one or two in the morning we were alarmed and continued at arms in the street and on the walls till about six when we were again dismissed. All the day the enemy continued their work, having every day brought great quantities of faggots, which now they employed in securing and carrying on their trenches towards the river. In the evening the posts were all relieved according to custom and this night we received no disturbance from the enemy.


{ms folio 102a} Friday the 22nd: with the day the enemy began to batter the tower on the south-east angle with four pieces of cannon and continued it hotly without any intermission till about noon or somewhat after the upper part of it fell to the ground, the remaining part being still as high as the wall. After this they slackened in their fury of firing, but gave not wholly over continuing to make some shots at the same tower and some at another in the middle of the east wall. It was now ordered we should relieve at one of the clock the time the 



---

p.175



enemy relieved their trenches. This was the first night for a week that we were not alarmed in town, yet our men on the walls continued till day firing upon the enemy, who were carrying on their approaches on the east side, and threw many bombs and carcasses[204](javascript:footNote('E680002-001/note204.html')) into the town which they had not done before, yet they did no considerable execution.


Saturday the 23rd: they spent the whole day battering the east wall next the tower they had ruined the day before, playing incessantly with six pieces of cannon planted on a battery they had raised in the first redoubt they took from us directly opposite to the south-east angle. They {ms folio 102b} also made many shots at the citadel by **St. John's Gate**. The stones that flew from the wall and splinters of balls which broke against those hard stones killed some and wounded many of our men, because the narrowness of our works afforded no shelter and the ruins of the walls could not be avoided in the straightness of the trenches. The citadel and south wall received little or no damage, but on the east side the top of the wall was shaken. After noon there was a cessation of arms for about two hours to bury the dead, which lay above ground since the day we lost the last redoubt and made the unfortunate sally. Then the works were relieved. A detachment of 100 men out of several regiments was sent to join the guards in the trenches on the east side where the enemy pushed on their approaches and had their chief battery. I was ordered with this detachment and we were posted in the north end of the trench next the river, that being the most exposed place of all the works because all the enemy's cannon that played upon the wall drove clouds of stones and rubbish upon it which flew with great violence and wounded many. Besides it was {ms folio 103a} thought the enemy would make an attack upon that place because it was the weakest and even naked at low water. The officers had positive orders if attacked to kill any soldier that should offer to fly, and it was also declared death for any officer to quit his post though never so hard pressed. However we only essayed the fury of the cannon which played day and night, for the enemy attempted not the post. They were all 



---

p.176



night at work our men from the wall incessantly firing upon them. This night also they threw a considerable number of bombs and carcasses into the town, but had no extraordinary effect besides the beating down two great houses and firing some thatched stables which abroad made show of a great fire.[205](javascript:footNote('E680002-001/note205.html'))


Sunday the 24th: with the day we discovered the enemy had advanced their trenches within fifty paces of our counterscarp on the east side, and were raising a battery in the redoubt they last gained of us. All the day they played hotly from the other on the wall which was much damaged thereby. Nothing else remarkable happened this day. The works were relieved as usual except our detachment which through the negligence of the major continued on till night.


{ms folio 103b}Monday the 25th: the enemy began very early and continued all day playing hotly from two batteries, the one of twelve pieces of cannon against the intended breach in the east wall. The other was of four newly raised in the bottom near the bog opposite to the middle tower of the east wall, whence they made many shots at the Franciscans' chapel, standing near the east gate of the English town where we had three pieces of cannon that flanked their trenches. They also played them at **Ball's Bridge** which joins the English and Irish towns, being built over that arm of the **Shannon** which encloses the English town and King's Island. About noon both sides 



---

p.177



relieved their works. Many of the enemy's balls from the east side flew over the town into the hornwork, they aiming high to bring down the top of the wall by degrees. After night they threw many bombs and carcasses which did no great hurt, but one firing a thatched mill near the citadel made without the show of a great fire at which the rebels shouted, but their joy was soon extinguished with the flame. This was all the harm done this night.


Tuesday the 26th: the day began as usual with {ms folio 104a} the noise of the cannon from all the enemy's batteries. This day they perfected their intended work, having made a breach in the southernmost part of the east wall near twenty paces wide, and though somewhat high yet easy of ascent, the vast quantity of rubbish beaten from the upper part of the wall and tower having almost filled the counterscarp so that there was no difficulty in mounting. Their cannon also levelled the glacis of the covered way and, having beat down the palisades, opened a plain passage to the breach and that gave a fair invitation to assault the town. This night they threw but few bombs and fewer carcasses seeming to be sparing of both. None of them did any damage worth mentioning.[206](javascript:footNote('E680002-001/note206.html'))


Wednesday the 27th: the enemy's batteries played furiously, the farthest off being the least at **Ball's Bridge**, the great one at the breach till they had laid it open above thirty paces and made the ascent plainer on their side than it was from the town. About noon the trenches were to be relieved which in part was done, only the Grand Prior's to which, as was said before, because of the weakness of regiments were joined Slane's and Boisseleau's,[207](javascript:footNote('E680002-001/note207.html')) stood at arms in the street in order to have relieved {ms folio 104b} the hornwork. It had been before ordered that as they relieved one regiment should still stand at arms till another came in. It was our good fortune to 



---

p.178



attend then when on a sudden we were commanded to light our matches and that scarce done to march towards **St. John's Gate** and man the walls, but before we could reach it our governor, Major-General Boisseleau, came running and, ordering us to the left, led to the breach. Before we could come up the running we perceived the breach possessed by the enemy, a great number came down into the retrenchment made within it and above twenty of them were got into the street. Having heard no firing of small shot before, we at the first sight thought they had been our guards retiring out of the counterscarp, they being all in red coats, till we discovered the green boughs in their hats which was the mark of distinction worn by the rebels, whereas ours was white paper. Besides an officer on the breach brandishing his sword called upon his men to follow, crying the town was their own. Our guards, who were in the counterscarp, upon the first appearance of the enemy abandoned their post without firing a shot, flying with such precipitation that many of them forced their way through our dragoons, who were posted on the right of them towards **St. John's Gate**. These dragoons behaved themselves with {ms folio 105a} much bravery presenting their pieces upon such of the guards as had not pierced through them, which obliged many to stand as did some of their officers ashamed of the infamous flight of their men. With these few that stood by them the dragoons made good their post during the whole time of the action. Meanwhile the Grand Prior's Regiment had well lined the retrenchment within the breach and, being undeceived that the enemy and not our own men were those that rushed in so impetuous, the word was given to fire, which was performed so effectually that a considerable number of the rebels dropped, and our men renewed their charges with such vigour that in a very short space they had not left one enemy within the breach, though still nothing daunted they pressed over, fresh men succeeding those that were killed or wounded. This sort of fight was continued near an hour, our battalion alone making good their ground against that multitude of enemies which being still backed with new supplies was all that while insensible of its losses. During this dispute most of the 



---

p.179



inhabitants of the Irish town giving it for lost fled into the English town, as did also the regiment of Colonel Butler of Ballyraggett,[208](javascript:footNote('E680002-001/note208.html')) to which three others were joined, and all ordered to support us that bore the brunt at the breach. The guards that were {ms folio 105b} upon the gate of the English town at **Ball's Bridge** shut it against these regiments, which by that means were again formed and marched to the breach, but not till the heat of the action was over the enemy having been beaten from it, which was in this manner. Our continual fire having made a great slaughter among the rebels and they beginning to abate of their first fury, M. de Beaupré,[209](javascript:footNote('E680002-001/note209.html')) a Frenchman, and Lieutenant-Colonel to Boisseleau our Governor, leaped over our retrenchment making to the breach. Most men strove to be foremost in imitating so good an example, so that being followed by a resolute party he soon recovered the top of the breach. Here the fight was for some time renewed and continued with sword in hand and the butt end of the musket. Our other men upon the walls were not idle this while, some firing and others casting stones upon the enemy beneath, which 



---

p.180



did no small execution, but the greatest havoc was made by two pieces of cannon playing from the citadel and two others from the King's Island, as also two others from the Augustine chapel near **Ball's Bridge** which last scoured all along our counterscarp then filled with rebels, and the other four swept them in their approach on the south and east sides. The enemy thus cut off on all sides came on faintly, and a barrel of powder which lay near the south-east tower accidentally taking fire and blowing up some that {ms folio 106a} were near it, the rest conceived it had been a mine and fled, neither fair words nor threats of officers prevailing to bring them back. The action continued hot and dubious for at least three hours, and, above half an hour after, went in diminution till the enemy wholly drew off. A great slaughter was made of them: deserters and prisoners who spoke the least, affirming above 3,000 were killed and wounded but others spoke of much greater numbers, and I am apt to believe by what we afterwards found unburied there could not be much less than 3,000 killed. On our side the dead and wounded amounted not to 500, among the first were Lieutenant-Colonel Beaupré before mentioned and Colonel Barnewall[210](javascript:footNote('E680002-001/note210.html')) who had no post there but being under some imputation of cowardice came to clear his honour at the expense of his life; among the latter a French major of the regiment of Boisseleau and others of less note, as also Lieutenant-Colonel Smith,[211](javascript:footNote('E680002-001/note211.html')) captain of a company of foot guards killed, and Sir James Mockler, Lieutenant-Colonel of Dragoons wounded. It was God's providence that the enemy attacked not the hornwork at the same time as the breach, for those regiments that were in it, though never assaulted apprehending the town was lost quitted it, and fled {ms folio 106b} down to the river without reflecting there was no way for them there to escape and that their only security was in their arms; but God had 



---

p.181



not ordained the town should be lost at this time. After the enemy was wholly withdrawn from the attack the guards repossessed themselves of the counterscarp. Those who had made good the breach continued in arms about it all the night without receiving any molestations from the enemy, unless the firing now and then of a cannon, as it had been to keep us waking, and the casting a few bombs and carcasses which had little or no effect.[212](javascript:footNote('E680002-001/note212.html'))


Thursday the 28th: the enemy played their cannon very hot at the breach to enlarge it towards the south angle, and to beat down a small part of that tower which sheltered our men on the south wall from their shot, and had been prejudicial to them mounting the breach. The first they performed as to laying the breach wider open, but their design on the remaining part of the tower took no effect. From their lower battery next to the bog they plied the bridge so warmly it was very dangerous to pass. This, as was remarked before, is not the great bridge over the main body of the **Shannon**, but a small one over a branch of it, and joins the English and Irish towns; the communication between which they laboured to cut off, which if effected must {ms folio 107a} have proved fatal to us, but the damage they did was inconsiderable. In the morning 



---

p.182



early the Grand Prior's regiment was relieved with orders to refresh only for four hours and then to be at arms again, which being done, 250 men were drawn in five detachments of 50 each and posted in several places. That which I commanded was ordered to the middle tower on the east wall which was much shaken and still battered, where we continued all the rest of the day and night following. Several were this day killed in the counterscarp by the stones that flew from the wall.


Friday the 29th: the enemy's cannon played as before and enlarged the breach to above forty paces. At the bridge one shot cut both the chains of the drawbridge and did some other damage but not of much moment, because the enemy's battery had not a full view of it, and their shot came slanting towards one end, yet the passage was very dangerous. The Grand Prior's detachments were all relieved this afternoon except that where I commanded, which continued in the same place till night, when being relieved we only marched into the street, and having joined the rest of the regiment to the trenches on the south-west side of the town, where we continued all night expecting an attack. The night was extreme cold, dark and rainy and we almost spent for want of rest.[213](javascript:footNote('E680002-001/note213.html')) For my own particular as appears by this relation I had had none at all for three nights before this and but very little during the whole siege, nor indeed was {ms folio 107b} it possible to have much being upon duty every other day and continually alarmed when we expected to rest. Our cannon and small shot fired the whole night round the walls, and much railing was betwixt our men and the enemies, for we were so closed up on all sides that though the night was stormy we could easily hear one another.


Saturday the 30th: in the morning we observed there was great silence in the enemy's works and day appearing we could not perceive any body in them, which at first was looked upon as a stratagem to draw us out of our works, but some few being sent out to discover returned and brought the news that all abroad was clear. Immediately the word was carried 



---

p.183



 
about all our works that the rebels had raised the siege and stole away in the dead of night, which at first seemed incredible to many. In a short space our men could not be contained within the works but running out found the enemy's trenches and batteries abandoned, and their dead lying everywhere in great numbers unburied, being those that were killed at the assault. All that had anything they stripped but the plunder was very poor, the clothes being old and coarse and having lain two days and upwards in the dirt and rain upon those carcasses. There were found above one thousand pickaxes, shovels and spades, many bales of fine flax which they used instead of woolpacks to cover their workmen with wooden frames to support them, some {ms folio 108a} frames with iron hooks to hang out lights upon, and some but not many arms. Though the enemy had abandoned their works yet they were not gone far and had still three small pieces of cannon at **Cromwell's Fort** which played towards **St. John's Gate**, and we could see great bodies of them marching at a small distance; besides in many places the ditches were lined not far from our works whence they fired upon such as ventured out. A detachment of ours sallying out of the hornwork drove some of them from their ditches, but relief coming down to them our men were forced to retire. The guns at **Cromwell's Fort** continued long firing, but at length were drawn off and we repossessed ourselves of all the posts we had lost during the siege, destroying as much as we could all the enemy's works. Our men were very disorderly and could by no means be restrained from straying abroad, which if the enemy had returned upon us must doubtless have put us into much confusion if not endangered the town, many of our men being but little disciplined, and our former misfortunes having rendered them too apprehensive of danger especially when not foreseen. The works were relieved about noon after the usual manner and the enemy encamped within three or four miles of the town. This day about noon marched {ms folio 108 b} into town 1,500 men, being all firelocks sent to recruit the garrison from the army in **Connaught**; a small supply, had the siege continued, considering there was but one relief in the town and all that were quite 



---

p.184



 
spent with continual fatigue, but such as the relief was it came not till the enemy were gone.


Sunday the 31st: the enemy continued encamped in the same place. All our works were mounted as before, the Grand Prior's regiment at the breach. Several detachments and all the unarmed men were put to work to bring in the faggots the enemy had gathered in great numbers, and about thirty gabions they left behind, which were placed upon the breach.


Monday September the 1st: our men continued bringing in the faggots, demolishing the enemy's works and removing the rubbish from before the breach. The prisoners we had were sent out with a guard to bury the enemy's dead that lay very thick about the town and began to grow noisome. All posts were relieved, but the Grand Prior's men continued for want of orders all day at the breach and were drawn off towards evening.


Tuesday the 2nd: the enemy lay still in the same place, but we received intelligence that they had sent away their sick and wounded men, as also their artillery and heavy baggage. It was hereupon ordered that for the future only seventy men of each battalion should do duty instead of the whole.


Wednesday the 3rd: was appointed a general day of review for the garrison in the **King's Island**, but the {ms folio 109a} weather proving extreme foul it was put off.[214](javascript:footNote('E680002-001/note214.html'))


Thursday the 4th: all the foot drew out into the **King's Island** and were reviewed by the Duke of Berwick, then Lieutenant-General and General Governor of Ireland. I designed to have taken a particular account of the strength of all regiments, but the weather proving very foul we were discharged.


Tuesday the 9th: in the morning arrived at **Limerick** Lieutenant-Colonel Boismeral,[215](javascript:footNote('E680002-001/note215.html')) who had been sent with 100 foot and 100 dragoons to garrison **Kilmallock**. He returned this day with all his men disarmed, having to his eternal infamy delivered up that place and his arms, without 



---

p.185



firing a shot, to a small body of horse, notwithstanding the town was enclosed with a good stone wall, yet he only asked leave to depart when shame might have obliged him never to return. All his excuse was that the enemy threatened to bring foot and cannon, the very name whereof, though there was no probability of the execution, frighted him into such a shameful surrender.


Sunday the 14th: I walked out to view the ground where the enemy encamped, in one part whereof where their forges had stood were found ten or twelve tons of **Kilkenny** coals, and under ground above 400 bombs and carcasses with a great quantity of cannon ball of all sizes, which upon their raising the siege they had buried. {ms folio 109b} But the most remarkable thing was a spectacle of horror near this place, for here were to be seen the ruins of a hospital built by them for their wounded men, which at their departure they most inhumanly burnt full as it was of those miserable wretches, whereof many were consumed to ashes, others lay within half burnt, and others that had more strength or were nearer crept out at the three doors, and soon failing for want of relief dropped down and lay dead about the field. A piece of barbarity we have not heard of amongst the most savage nations.[216](javascript:footNote('E680002-001/note216.html')) There might be destroyed in this inhuman manner about 300 men, for so many, deserters told us, there were in the hospital, and the carcasses and limbs that lay about unconsumed were very numerous. I cannot but observe here that all about the city, but more especially in this place last mentioned, there were infinite numbers of crows and ravens, which seemed to have resorted from all parts of the country to prey upon the dead bodies 



---

p.186



which lay everywhere unburied. They were with the plenty of food grown excessively fat, which made them appear above the common size, and so tame that they walked among men familiarly, as homebred fowl do. All being quiet about us nothing worth observing occurred till


Monday the 29th, when four battalions of foot marched out of **Limerick**, and encamped about a quarter of a mile from the town, and not far from **Cromwell's Fort**. The regiments {ms folio 110a} being very weak, several of them were put together to make up battalions. Those that encamped were the Grand Prior's to which were joined Slane's and Boisseleau's, Butler[217](javascript:footNote('E680002-001/note217.html')) joined by Sir Michael Creagh, Westmeath and Grace, the two MacMahons,[218](javascript:footNote('E680002-001/note218.html')) and Iveagh composed the third battalion, and Gordon and Felix O'Neill the fourth. The third of these battalions had no arms at all, the other three for the most part were armed, but not completely; this is to be understood of firearms, for very few had swords. This day the weather began to grow foul with much rain and great storms of wind, which continued all the while we lay encamped here. The fields we lay in were very green, and we wanted not wood, an orchard at hand supplying us plentifully, but there was no straw in 



---

p.187



 
all the country about, unless what the enemy had left, which was not fit for use so that the poor soldiers' huts had scarce any covering, and the poor men lay on the wet ground.


Tuesday the 30th: we received the news of the loss of **Cork**,[219](javascript:footNote('E680002-001/note219.html')) which, though afterwards contradicted, proved true. The manner of it I do not undertake to relate, as not having been present, and the relations we had differing very much.


Saturday October the 4th: marched out of **Limerick** towards the county of **Kerry** Brigadier MacGillicuddy,[220](javascript:footNote('E680002-001/note220.html')) and the Lord Kenmare's Regiments[221](javascript:footNote('E680002-001/note221.html')) of Foot.


Sunday the 5th: the Lord Slane's Regiment, which till now had been joined to the Grand {ms folio 110b} Prior's, marched away from the camp.


Monday the 6th: the Horse Guards, the second Battalion of Foot Guards, the Grand Prior's Regiment to which were joined Boisseleau's, as was said before, and FitzGerald's instead of Slane's, and Butler of Ballyraggett's Regiment joined by those, of Creagh and Grace,[222](javascript:footNote('E680002-001/note222.html'))


---

p.188



marched and lay that night at the **Sixmilebridge** in the county of **Limerick**, where there are only some poor thatched cottages, so that some lay in the field, and some crowded into those poor huts; the night was very boisterous. I having been ill for some days had leave and was advised to stay in **Limerick**, and indeed was in no good condition to march, especially afoot, having no horse, and in such bad weather. However I could not live from my regiment, which was all the home I had and all the friends. Besides that I was ashamed to stay when the regiment was going where there was some talk of service, and therefore followed the best I could, and being, as I said, afoot and somewhat weak could go but four miles, and lay at night at a fair house but very bare, as having been plundered, as was all the country about. The last inhabitant of it was one Croker a Protestant,[223](javascript:footNote('E680002-001/note223.html')) who went away with the enemy, the ancient proprietor then in possession one Burke.


Tuesday the 7th: I set out with the day {ms folio 111a} and joined our forces at the Bridge. We marched thence three miles to **Bruff**, a small but not contemptible town, where we halted awhile, and found, contrary to report we had heard before, no want of entertainment, but what was caused by the shyness of the poor people and the too much eagerness of the soldiers, whose pressing necessities were a sufficient excuse of their rudeness. Yet it had been given out that the country was quite destroyed, and neither meat nor drink to be found on all the way to **Cork**. After this little halt, we marched on three miles farther to **Kilmallock**. Notwithstanding the 



---

p.189



rains we had before this road was good, there being a causeway throughout betwixt the two towns, and the paths within the fields being sound, as not much beaten, few people travelling at that time. **Kilmallock** lies in a bottom just under a high hill, which quite overlooks it, and is surrounded with a stone wall after the old manner with battlements, but not broad enough for two men to walk on it abreast. The ruins show it to have been a good town, the houses being of stone, lofty and large, but most of them ruined, and but few of those that remain inhabited, both parties having been in the place, and the greatest part of the inhabitants fled or at least had removed their best effects. Here are also some remains of a large church; a small river runs by the walls. The Grand Prior's battalion, as well officers as soldiers, quartered in one large house. There was no provision {ms folio 111b} to be found here but only butter and some small quantity of drink, which was soon spent. We had brought with us six days' bread, and all the gardens were full of cabbages, which subsisted the men.


Wednesday the 8th: a subaltern officer of each battalion was sent out with a detachment to bring in spades, shovels, and pickaxes from the country. The Duke of Berwick, who came to town the night before, went out with the horse, and returned without meeting any enemy. Towards evening marched into the town Colonel Nugent's Regiment of Foot, called the Caps, because they all wore them like Grenadiers, as being more easily to be had than hats.[224](javascript:footNote('E680002-001/note224.html'))


Thursday the 9th: nothing happened of note, but whereas we expected some works would have been carried on with the tools taken up the day before, they were only ordered to be left at the general's quarters.


Friday the 10th: the four battalions of foot were drawn out upon the hill over the town, where the Duke of Berwick took a view of them, and they returned to their quarters.




---

p.190


#### 3


Saturday the 11th: in the morning the foot drew out again on the hill and marched away, having left detachments who burnt **Kilmallock**, the horse doing the same to Charleville, having before wasted the country round about and fired several villages. This morning we marched back three miles to Bruff, and with us the Horse Guards {ms folio 112a} and Duke of Tyrconnel's Regiment of Horse. These last encamped in the gardens of a great house near **Bruff** belonging to one Evans, which, being very large and built after the manner of a castle with large stone walls and battlements, had been burnt by our army: the place was called **Ballygrennan**. All the Foot and the Horse Guards quartered in the town, which being but small they were much thronged, and to straighten our quarters a house accidentally took fire, and the wind being very high burnt down five or six others that contained a considerable number of men. All the morning whilst we were drawn up on the hill and marched, there continued a most violent storm of wind and rain, which cleared up when we came to **Bruff** but it fatigued us extremely on the march. All the country about **Bruff** is very pleasant, being a large valley and good land well peopled and improved. The town is small and has nothing in it worth observing. There was corn and cattle enough, plenty of cabbages in the gardens, and what was the great support of the people and soldiers, large fields of potatoes, yielding prodigious quantities of them, and all little enough considering the vast consumption, for they often serve instead of bread, and the soldiers would be feeding on them all the day.


We continued here all Sunday the 12th, {ms folio 112b} and Monday the 13th and Tuesday the 14th, without anything worth observing, unless the bringing in of six or seven prisoners and two deserters; but this night about midnight, by the mistake of our advanced guards, we were alarmed and continued under arms above an hour. The night was favourable being very fair and moonlight, when finding our mistake we returned to our quarters with orders to be ready upon beat of drum.


Wednesday the 15th: at the same time the tattoo was beating we received orders to be in readiness, and so continued all 



---

p.191



night. The guards were doubled and our horse and dragoons drawn out and ready all night, which proved very dismal for wind and rain. What occasioned the alarm I cannot tell, but it much harassed the men and proved a false one. But we were very subject to mistake, to watch when no danger was near and sleep when it hung over our heads. All this while the weather was very foul, our quarters bad, and provisions scarce because of the soldiers' rudeness, so that it was now come to pass that a man must either rob with the rest or starve by himself.


Thursday the 16th: we returned to **Limerick**. Here I continued in quarters with the regiment all the winter, during which time there happened very little or nothing of note, for our forces being very inconsiderable and much harassed, there {ms folio 113a} was no possibility of gaining any advantage upon the enemy, who at the same time made no other of our weakness but to live the more at ease. The weather it must be confessed, for the most part, was not fit for any action, yet considering how much they were superior to us they might without much difficulty have taken opportunities to straighten us in our quarters, which in a small time must have reduced us to extremity, and would consequently have saved the expense of another campaign, and the lives of many men they lost in it. But they seemed to be stupefied or wholly devoted to their ease, leaving us in quiet possession of the whole province of **Connaught**, besides the entire county of **Kerry** and the greatest part of the county of **Limerick**. These counties maintained the greatest part of our small army especially with flesh and potatoes, for all sorts of grain was very scarce. In **Limerick**, which was the head-quarters, we lived most of the winter upon salt beef allowed out of the stores, had one while ammunition bread made of all sorts of corn put together allowed in a small quantity, but for the most part instead of bread we received half a pint of wheat for officers, and the soldiers the same quantity of barley or oats in grain, to make our own bread. Of salt {ms folio 113b} beef the allowance was half a pound a day. As for pay a small part of the winter we received subsistence money in brass, which was equivalent almost to nothing, for 



---

p.192



a captain's subsistence which was a crown a day would yield but one quart of ale and that very bad, whereas for four Irish halfpence there was much better drink to be had. Wine and brandy bore prices proportionable and so everything else in that coin, for with silver necessaries might be had at reasonable rates, but there were few who had any of that metal. To instance something more of the value of brass money we gave a crown for a loaf of bread very little bigger than a London penny loaf when corn is cheap. I gave five pounds in brass for a pair of shoes, nor could I have purchased them at that rate, but that the shoemaker was allowed a wretched garret to lie in the house where my company quartered; for it is to be observed that most of the garrison was quartered by companies or greater numbers in empty houses, only the officers quartering in those that were inhabited. After this having got cloth, lining, and buttons out of the king's store to make me a suit of clothes, and employing a soldier who was a tailor and managed all things the most frugal way to make it, the expense of making or the tailor's bill came to eighteen pounds, and yet was there not a needleful of silk in the suit, a all the seams being sewed with {ms folio 114a} thread, and the buttonholes wrought with worsted. But to proceed, before Christmas all the brass was consumed, so that nothing remaining to coin money, and there being no duties or taxes to be raised because the small territory we had was in no capacity of paying any, the army from that time never received any pay whatsoever, and to say the truth they were better satisfied without it than with such as they had before, for the brass was accounted to them as if it had been gold or silver, and at the same time was worth nothing, whereas now as they received nothing so they had nothing to account for. It is really wonderful, and will perhaps to after ages seem incredible, that an army should be kept together above a year without any pay, or if any small part of it they received any it was, as has been said, equivalent to none. And what is yet more to be admired the men never mutinied nor were they guilty of any disorders more than what do often happen in those armies that are best paid. Nor was this all they might have complained of. In 



---

p.193


**Limerick** as has been said all the garrison lay in empty houses, where they had neither beds nor so much as straw to lie on, or anything to cover them during the whole winter, and even their clothes were worn to rags, insomuch that many could scarce hide their nakedness in the daytime, and abundance of them {ms folio 114b} were barefoot or at least so near it that their wretched shoes and stockings could scarce be made to hang on their feet and legs. I have been astonished to think how they lived and much more that they should voluntarily choose to live so, when if they would have forsaken the service they might have been received by the enemy into good pay and want for nothing. But to add to their sufferings the allowance of meat and corn was so small that men rather starved than lived upon it. These extremities endured as they were with courage and resolution are sufficient with any reasonable persons to clear the reputation of the Irish from the malicious imputations of their enemies; and yet this is not all that can be said for them. We have already seen them defend an almost defenceless town against a victorious disciplined army, and we shall see them the following summer under all these hardships fight a battle with the utmost bravery, though overcome by numbers rather than valour. Let not any mistake and think I either speak out of affection or deliver what I know not; for the first I am no Irishman to be anyway biased, and for the other part I received not what I write by hearsay but was an eyewitness. As for the city of **Limerick**, which I said was almost defenceless, it had no other but an old stone wall made against bows and arrows, I mean the first siege, and a poor covered way we made in a {ms folio 115a} month's time. The enemy delayed coming to attack us, for when we came to the place it was all encompassed for a great way with suburbs and gardens, and had no other work but the bare wall I have mentioned. All the works there were we made in that short space of time by which any man may judge what they were, and the better to satisfy such as cannot form a true notion of them, they must understand that the French regiments we had with us at the **Boyne**, and who assisted in raising these very works, when they heard that the enemy drew near, 



---

p.194



utterly refused to stay in the town and stand a siege, alleging, and with good reason, that the place was not tenable, and this because they had seen fortified towns and by their strength were sensible of the weakness of this, whereas the Irish who had never seen a place well fortified thought this an impregnable fortress, and I have heard almost as much said by Irish officers, some of whom in private I undeceived as having been abroad and knowing more of that particular than they. As for the battle in which I say the Irish were overcome by numbers, this I can positively affirm, having myself taken the numbers of each regiment when drawn out, that we did not make 17,000 in all horse, foot and dragoons, and that in all places we had three to two against us. This I am sure of: in the foot and in the horse I believe the odds was much greater. {ms folio 115b} But I must not here anticipate upon what happened so long after. The battle of **Aughrim** which is that I have made the last observation upon will be mentioned in its own place and with more particulars.[225](javascript:footNote('E680002-001/note225.html')) Let us now return to our hard winter in **Limerick**, where the poor men, besides all the other 



---

p.195



difficulties they had to struggle with of hunger, nakedness, &c., in the severest of all the season for rain and storms were set to work upon repairing the breach and raising a new bastion without it. I was myself three weeks with every day a fresh detachment upon this work, and the season was so bad that we never had a dry day, and accordingly the work advanced. At the end of this time I obtained to be myself relieved and by reason of the bad weather within a few days after, the breach being made up with stone taken from a quarry just at the foot of it, the work ceased without, there being no possibility of carrying it on. In February following engineers being come from France, the work was resumed all round the town by a great number of men. The soldiers were promised three pence, ensigns fifteen pence, lieutenants twenty pence, and captains half a crown a day in silver for their work, that is the soldiers to work and officers to inspect them, which made all willing to undertake the task, having no other pay and being in such want as has been already mentioned. The engineers being all French and not speaking {ms folio 116a} any English such officers were made choice of to attend the work as could speak French, of which number I was one, and continued at the work daily, not excepting Sundays from the middle of February till the 20th of April. The first three weeks we were justly paid according to promise, without any deduction, but then the rest of the time, being about six weeks they let run on, and when at last we came to be paid, they lowered the captain's pay to twenty pence and the lieutenant's to fifteen pence besides deducting for half days and the like, so that the officer's pay falling so short I refused to follow the work any longer, and chose rather than be so imposed upon to do my regimental duty for nothing with the rest. Besides the chief engineer and I had some words, he presuming that small pay would have made me more submissive to him, but I freely told him I would attend the work no more, and as positively performed it, though he sent some of the under engineers and officers of our regiment to court me to return, and even when the regiment marched out to take the field he sent to offer to get leave for me to stay all the summer in the 



---

p.196



town at the work, which I refused, though much more for my safety, ease and profit, but neither did I like the man nor could I ever be persuaded to forsake my regiment, or had it been proper for a man that valued his reputation to stay from it when marching against the enemy. {ms folio 116b} These works round the town consisted of six great bastions, curtains, and covered way enclosing all the Irish town, being that which lies on the south side of an arm of the river **Shannon**, that divides it from the English town seated in the island formed by the said river, and called the King's Island. This part lay most exposed to the enemy and was therefore best fortified. However an entrenchment or covered way was made about the King's Island to secure it from all attempts, and in the middle of it a Fort Royal with four bastions and a line of communication to the English town. All these particulars may be seen in the map[226](javascript:footNote('E680002-001/note226.html')) and therefore I shall not spend more time in describing them. But to return to the men, I must observe, lest I seem to conceal anything that was intended for their advantage, that to comfort them in their miseries there was a very small quantity of tobacco and brandy allowed them weekly out of the stores. As for the brandy I believe they scarce ever tasted it, of the tobacco, which for the most part was rotten, some very inconsiderable quantity was distributed among them, all the brandy and remaining part of the tobacco being by the majors, who were entrusted to distribute it, converted to their own use, it is likely, by the consent of their superiors who doubtless shared the profit {ms folio 117a} with them. These things were so visible that the meanest soldiers were sensible of them though they bore them with great patience, yet I who always used that freedom that might not give occasion of scandal did not fail betwixt jest and earnest to tell the major of our regiment my opinion of that proceeding, who from that time forward ever allowed me as much of both or rather more than was my due, and I might have had much more would I have asked it, for to give him his due he did not want for good nature though interest blinded him as well as the rest; and for myself I was never very covetous of either brandy or 



---

p.197



tobacco. Having said enough of these particulars, I must here take notice, which should have been done before, that on the 26th of January 1690/1 the value of brass money was pretended to be settled by proclamation, but that availing nothing on the first of February following it was cried down, which might have been done long before or not at all, because as has been already shown, it was of no value.


On the 18th of April, 1691, arrived an express from France, with the news of the taking of **Mons** by the French; for which on the 19th Te Deum was sung in the church of St. Mary being the cathedral.[227](javascript:footNote('E680002-001/note227.html')) The cannon was also three times discharged, and as many volleys of small shot, and there were bonfires and other {ms folio 117b} demonstrations of joy.


May the 4th: marched out of **Limerick** a detachment of fifty men of a regiment, more of the Guards, and Burke's 
company of two hundred Fusiliers, in all about eight hundred men. They marched to **Lough Gur**, seven miles from **Limerick**; to fortify a pass there, which when finished they all returned, except Burke's company left to make good that place.


May the 9th: arrived in the river **Shannon** a French squadron of men-of-war, having sent some ships to **Galway**, and about noon landed the French general M. St. Ruth,[228](javascript:footNote('E680002-001/note228.html')) who was received with real demonstrations of joy. The 17th was a general muster of the garrison of **Limerick**, and the 18th and 19th the regiments were particularly reviewed, delivered 



---

p.198



in their unfixed arms and received others. The last of these days Brigadier Talbot, natural son to the Duke of Tyrconnel, was declared colonel of the regiment, which till then had been the Grand Prior's, in which, as has been said, I served. On the 18th also Sir John FitzGerald's Regiment of Foot marched into **Limerick** and encamped, on the 20th Colonel Connel's, on the 21st MacGillicuddy's, and on 23rd Power's Regiment without arms, and the same morning marched out Gordon O'Neill and Nugent's Regiments towards **Athlone**. The 24th they were followed by the first battalion of Guards and Felix O'Neill's Regiment, on the 26th by MacGillicuddy, Connel and Macguire,[229](javascript:footNote('E680002-001/note229.html')) {ms folio 118a} on the 27th by the second battalion of Guards, Saxby and Sir John FitzGerald, on the 29th by the Lord Slane, and Colonel FitzGerald, and on the 30th by the Lord Iveagh, O'Donnell, the Lord Kenmare, and Macarthy.[230](javascript:footNote('E680002-001/note230.html'))
  
 
This same day Art MacMahon's regiment entered **Limerick** unarmed. The 31st the Lord Enniskillen's Regiment marched away for **Galway**, and the same day Hugh MacMahon's came to **Limerick** unarmed.


June the 2nd: Purcell's Regiment of Horse,[231](javascript:footNote('E680002-001/note231.html')) Carroll's[232](javascript:footNote('E680002-001/note232.html'))


---

p.199



Dragoons, and the two MacMahons' Regiments of Foot marched out of **Limerick** towards the camp.


The 3rd: came to **Limerick** Cormuck O'Neill's Regiment of Foot consisting of about nine hundred men as likely, clever, lusty, well-shaped fellows, as ever eyes beheld.


Thursday the 4th of June: marched out of **Limerick** Brigadier Talbot's Regiment, which was before the Grand Prior's, in which I served. It was then about four hundred strong. We halted a considerable time beyond **Thomond Bridge**, till one small field piece and one cart laden with ammunition joined us, and then we marched without any other stop to the camp at **Killaloe**, eight miles from **Limerick**, where we pitched our tents on the left of the Guards, all on the south side of the town, but without any order. This town and the road to it I shall not need to give any account of in this place, having said as much of it as is requisite before when {ms folio 118b} we passed the same way the first time towards **Athlone**, as is to be seen in this book, folio 92. This night the soldiers passed with much inconveniency for besides that we had but four tents to a company there were neither tentpoles nor pins; some few made what shift they could to set them up, the rest lay about under the hedges. The day was fair and pleasant to march, but the night extraordinary wet and cold, considering the season of the year. In this place we found fifteen battalions of foot, whereof two were of the Guards.


Friday the 5th: two hundred men were detached to bring wood, and the whole day spent in building huts, which were covered with turf or long sods cut off the face of the earth, very thin and four or five feet long, which in Ireland they call strauths. The reason of this shift was because there was no straw left in the country or other sort of thatch to be had, and we were obliged to hut because, as was said above, each company had but four tents, one of which was taken for the 



---

p.200



officers, and though our companies were thin, ten huts would scarce contain them by reason of the great number of women and children always following the camp. Nor was this evil to be remedied under our circumstances, forasmuch as most of the army consisted of soldiers of other provinces then in the enemy's hands, and those poor wretches had no other home but the army, and must perish without it.


Saturday the 6th: part of the day was spent in exercise, wherein I found our old men as imperfect, through the want of use, as the new. We received six days' bread late at night, twelve {ms folio 119a} bullocks for the regiment, and orders to march the next morning.


Sunday the 7th: Brigadier Talbot's, Saxby's, and FitzGerald's Regiments of Foot marched[233](javascript:footNote('E680002-001/note233.html')) at three of the clock in the morning. First to **Tomgraney**, five miles, a little ruined town, within half a mile of which is **Scarriff**, neither of them worth the noting but for the iron mills there formerly, now gone to decay. The road is all mountain with a wood along the **Shannon**. Hence we marched to **Graig** or as the English call it **Woodford**, eight miles over an uncouth barbarous mountain full of bogs and covered only with wild sedge, fern, and heath, without one house, cottage or so much 



---

p.201



as a living creature of any sort to be seen. In winter this way is impassable when the season is wet, but in a dry summer good, yet at best boggy in some places. The miles are long and the day was very hot without the least breath of wind, tiresome to the soldiers and to me so much that had we not made a halt two miles beyond Graig, I had not been able to go farther, being afoot and quite spent with the fatigue. Nor is it to be admired that officers should be afoot when we were cooped up in a corner of the country where horses were grown very scarce, the army having been so long without pay, as was mentioned before miserably poor, and I as a stranger particularly wanting many helps which the natives had. At Woodford there is an iron work in the bottom upon a small river that falls into the **Shannon**: the town stands on the hill above it. {ms folio 119b} The bridge at **Tomgraney** joins, or rather the river that runs under it parts, the county of **Clare** from that of **Galway**, the same being also the bounds of the provinces of **Munster** and **Connaught**. To add to our weariness we were marched an English mile beyond the town and, there being no convenient ground to encamp, were obliged to march back through the town, where we encamped on the side of a hill, but with much confusion and disorder, as well in the manner of our drawing up as pitching the ground. Here some bullocks were slaughtered and divided to the soldiers.


Monday the 8th: the general beat at four, but we stirred not in two hours after, then set forward and marched seven miles, which in this country are the longest in Ireland, though none there be short. The first part of this way is mountain, 
then a pleasant bottom, most good pasture land. We struck two miles into this valley and ought to have kept along the sides of the hills, but none knowing the way went astray near two miles, for after four hours' march we were at the abbey, which is but two miles from **Woodford**. Thence three miles along a pleasant country till we came to **Portumna Park**, which is very pleasant and delightful, and a full mile through it, and just under it the town of **Portumna**, small yet better than many of the country towns in that province. We made no halt, but marched a mile farther and encamped on a rising 



---

p.202



ground. The day was hot, and though the number of miles small {ms folio 120a} the way seemed long and tiresome. Some small allowance of beef was here given to the soldiers.


Tuesday the 9th: nothing of note, but that one small bullock was divided among all the officers of the regiment, a very poor allowance, and all they received since they left **Limerick**.


Wednesday the 10th: the general beat at five in the morning, yet we stirred not till towards noon, then marched five miles to **Meelick**. The country is pleasant, being diversified with cornfields, pasture land, and some underwood and brakes. From the time we left **Limerick** till we came to this place I did not see ten head of any sort of cattle, but what was with the army, either horses, cows, or sheep, very few people and nothing but ruined villages. At **Meelick** in the small islands the river **Shannon** there makes the people had secured some small flocks of sheep and a few black cattle. This place consists of a few scattering cottages, one gentleman's house in an island and an old castle in another little island, upon one of the passes of the **Shannon**, which pass is convenient enough for travellers with a guide; but not for an army, the ford being narrow with several windings and dangerous on both sides. Here is also {ms folio 120b} the residence of a few Franciscan friars only remarkable for the poverty of their house and chapel which are nothing but long thatched cabins. The walls of a handsome chapel designed by these friars are standing, but never roofed or further finished than the raising of them to their full height. All round is a very delightful plain, the soil good, but inclining to bog in wet weather.


Thursday the 11th: a review of the brigade was taken by Brigadier Talbot;[234](javascript:footNote('E680002-001/note234.html')) the general beat at noon in order to march, 



---

p.203



yet nothing was moved. Here the **Shannon** divides itself into several branches and forms many islands.


Friday the 12th: four deserters came over to us, who gave an account that the enemy were 13,000 strong at **Ballyboy** in horse, foot and dragoons. We had before received information that they were 15,000 between **Athlone** and Mullingar, and had taken **Ballymore**, a place of very considerable strength, in less than forty-eight hours.[235](javascript:footNote('E680002-001/note235.html')) Here we lay still, without anything remarkable happening till


Friday the 19th, when, about three in the morning an express came with orders pursuant to which we decamped and marched immediately five miles to a place whose name, if it has any, I could not learn, there being no village, house or place of note near it. The first mile of this way is a large beaten road as bad at this time with the continual rain as if it had been the depth of winter, where stands the much noted house in **Connaught** called Eyre's Court, being a pleasant seat built by one Mr. Eyre and much celebrated in the {ms folio 121a} country, but by what I could perceive in marching by it nothing answerable to what fame reports. All that can be said, it is a pretty gentleman's seat, the house large with a pleasant wood on the back of it; but no good prospect any way, nor any river near it. Round about is hilly ground, which, with the improvements and the convenient neighbourhood of a small village, make it delightful enough. The land hither is most enclosed, though some of it full of shrubs and wild. The next two miles is all common, covered with fern, heath, much sedge and some patches of good grass and several bogs. No dwelling is in this way, but at the end of the two miles an old house or castle, where begins for the following two miles to be some enclosures and much more bog and shrubby land. At the end of our march we found fifteen battalions of foot encamped in a line, the horse and dragoons 
 


---

p.204



at a distance from them in several places, without order. We pitched in the rear of the other line, being four regiments of foot, a long narrow ridge of rising ground running between us and the other foot, so narrow and beaten that it looks as if made by hand, yet is really a small work of nature. The reason of our march was to form a body with the other troops, the enemy having sat down before **Athlone**. We heard much firing and detachments of the first fifteen regiments were sent thither.


Saturday the 20th: we marched but two miles {ms folio 121b} through a pleasant hilly country, and then encamped, twenty battalions of foot, besides horse and dragoons, in the same manner as the day before, the latter whose number was increased, all scattered, and four battalions of foot, which were the beginning of a second line divided from the first by a ridge of rising ground. About the first every way it is all hilly, and in the rear of the second line a spacious beautiful valley, as far as a man's sight could extend, but most of it boggy, and I believe is overflowed in winter by the river Suck, which lay behind us. On our left was the town or village of **Ballinasloe**, or according to the Irish pronunciation Ballinaslouagh. We heard the cannon at **Athlone** firing hotly all the day. After noon marched thither Major-General Hamilton's, and the Lord Galway's Regiments of Foot, with all the officers in second of the army.


Sunday the 21st the army decamped and marched through **Ballinasloe** seven miles, and encamped on an eminence, about two miles or better from **Athlone**.[236](javascript:footNote('E680002-001/note236.html')) **Ballinasloe** is but a mean ruinous place, with some remains of a remarkable 



---

p.205



house or castle as they call it which seems to have been formerly a pleasant seat. The river here runs in two branches over which there are as many stone bridges. The first is about 140 of my paces in walking in length; much about that distance from it is the other, in length 250 of the same paces, which shows the breadth of the river, and that in great floods swells beyond the extremities of the bridges, and in the interval {ms folio 122a} between both, wherein also stands a considerable part of the village somewhat to the southward, and to the northward the castle. The first mile of this day's march was on a broad road much like some of the wide by-ways in England, and after that all is wild common, some boggy, some stony, and full of shrubs, and one small spot of a wood. The ground we encamped on was very high, rough, and full of shrubs, which made our camp very irregular, there being in many places scarce flat enough to pitch the tents for stones and bushes. The army spread out all in length, Colonel Talbot's Regiment on the left of all the foot, four regiments were upon duty in the town and trenches, eight more encamped without the town, and several others at small distances betwixt the town and the grand camp.


Monday the 22nd: very early Brigadier Talbot's and the Lord Iveagh's Regiments[237](javascript:footNote('E680002-001/note237.html')) of Foot relieved the trenches on 



---

p.206



the north side of the town upon the fords of the river, where they lay all that day and night without anything worth note happening, but spent the night pleasantly in raillery with the enemy on the other side.[238](javascript:footNote('E680002-001/note238.html')) The enemy's batteries of cannon and mortars played very warmly, the first all day till late at night firing incessantly upon the castle, and broke down some of the wall, but did no other considerable execution. The latter threw bombs day and night, which did some execution but not considerable. It was supposed their chief bombardier was either killed or wounded, because a shot being levelled at {ms folio 122b} him the firing ceased for a considerable time, and after that their bombs fell not within so narrow a compass as before.


Tuesday the 23rd: we continued in the same post all the day much of which was spent in a sort of voluntary cessation on the banks of the river, where the guards on both sides discoursed familiarly till some general of the enemy's coming down broke off the communication, and we fell to firing at one another for a short space, and then ceased without any harm done on either part. The enemy's cannon and mortars played at the castle, but not so hot as the day before. In the morning before day appeared we heard the noise of carriages, and when it grew light saw some bodies of the enemy marching. This day came to our camp eight field-pieces with ammunition and other necessaries. At night Gordon O'Neill's Regiment relieved us in the trenches; but we only drew back, and lay all night upon the bivouac on the bog under the hills, which are the road to **Athlone** near the river.


Wednesday the 24th: at the first dawning of the day we marched off, and returned to the camp. From the camp to the town, for above a **Connaught** mile, is through the shrubs and bushes, till within a large mile of the town is a small bridge over a little brook, and from thence forward a plain hard 
 


---

p.207



road along the sides and tops of the hills, and on the right a large bog, everywhere dry and passable in summer; on the left {ms folio 123a} is a hilly dry ground, but close by the town a large spot of bog. The enemy continued playing from their batteries on the town.


Thursday the 25th: there was a general muster in the morning; soon after we had orders to be all ready in half an hour, and presently again to decamp; which was done, and we marched down about a mile nearer to the town, where we encamped on a ground much like the last, but far from water. The enemy had now mounted more cannon and played most violently without intermission on the castle. Here we were new formed into brigades, and ours made up of Colonel Talbot's, the Lord Slane's, Colonel Dillon's,[239](javascript:footNote('E680002-001/note239.html')) the Lord Bophin's,[240](javascript:footNote('E680002-001/note240.html')) and Colonel O'Brien's Regiments.


Friday the 26th: the enemy's fire at the castle continued very hot all the day, but nothing else of note happened.


Saturday the 27th: the enemy having made some attempt 



---

p.208



upon the bridge, Brigadier Talbot's Regiment was commanded down, having lain about an hour near the town to second those in the trenches in case of an assault. The enemy's bodies, which before appeared, dispersing, we marched back, but before we could reach the camp met the general who remanded us back again. All the afternoon we lay by the bridge a mile from the town, and in the evening marched on {ms folio 123b} just to the entrance of the town, where we lay till it was dark, not being well able to enter sooner because the enemy's batteries would have had a full view of us. At night we marched in and relieved the trenches on the left of the bridge, which was defended by several companies of Grenadiers.


Sunday the 28th: continued playing incessantly. About one in the morning the enemy, creeping over their barricades of faggots on the bridge, made up the broken arch with planks, both sides plying their small shot and hand grenades without intermission; yet they did their work and retired. No sooner was it done than five or six of our men, getting over our work of faggots on the bridge, notwithstanding the enemy's continual fire, took up the planks, and throwing them into the river, returned in safety. The great and small shot never ceased firing, and some time before noon the enemies with their grenades fired our faggots on the bridge, which, being very dry and not covered with earth, burnt most furiously. I was commanded with a detachment of forty men of our regiment, and other officers of the other regiments in the town with proportionable numbers of their men to put a stop to the fire, which notwithstanding all our endeavours raged so violently that it took hold of the houses adjoining to the bridge. The enemy in the meanwhile bent thirty pieces of {ms folio 124a} cannon and all their mortars that way, so that what with the fire and what with the balls and bombs flying so thick that spot was a mere hell upon earth, for the place was very narrow which made the fire scorch, and so many cannon and mortars incessantly playing on it there seemed to be no likelihood of any man coming off alive. However we threw down one house, and the men, being hasty to run off with 



---

p.209



the timber for their own security, that gave a stop to the progress of the fire, which then began to decline till it quite ceased. We had very many men killed here of the detachments that came to work, and the rest being gone off, a French major we had in our regiment, besides the Irish, commanded me back to my post. And this I think was the hottest place that ever I saw in my time of service.[241](javascript:footNote('E680002-001/note241.html')) The fire being quite put out, a new traverse of faggots was raised where it stopped. Many who had served long in France said they had never seen such furious firing for so long a time, and, besides the bombs, the enemy threw out of their mortars a vast quantity of stones; besides that the place being so close the cannon balls which struck against the castle walls beat off abundance of stones from them, which did as much mischief as the others. The whole action continued {ms folio 124b} about four hours, most of the men who once got away returning no more, which made the work the longer for those who were forced to continue at it. By this means only seven of my detachment were killed and nineteen wounded out of forty, and I received no hurt myself. Yet returning to my post in the trenches I was knocked down with a stone that flew from the castle wall, which only stunned me, a good beaver I had on saving my head. Another stone from the wall gave me a small hurt on the shin, which was not considerable. At night most of the officers standing about a barrel of powder to be distributed among the men, a bomb fell in the midst of us, but we all lying down, it pleased God it took not the powder, and we all escaped unhurt. About midnight we were relieved by Colonel Nugent's Regiment, and lay the remainder of the night on the bivouac in the ditch of the castle.


Monday the 29th: with the dawning of the day we marched to the camp. This morning some of the enemy's Grenadiers advancing were so well received that we heard they lost above a hundred. Two officers and five soldiers of ours, venturing up to the enemy's faggots on the bridge, set them 



---

p.210



on fire, and the wind favouring us destroyed them all. {ms folio 125a} Four of the seven returned safe. After this the enemy fired only some odd shot all the day, and continued as quiet the night.[242](javascript:footNote('E680002-001/note242.html'))


Tuesday the 30th: most of the day passed in silence. In the afternoon on a sudden the whole camp was alarmed, and we marched down to the bridge within a mile of **Athlone** where we understood the town was taken, the enemy having entered both at the bridge and ford without the least opposition made on our side. The Regiments of O'Gara,[243](javascript:footNote('E680002-001/note243.html')) Cormuck O'Neill,[244](javascript:footNote('E680002-001/note244.html')) and others that were in the works, quitting them at the first onset without firing a shot, so that there was no time for any relief to enter the place. Some of the enemy who ventured without the castle were driven back without any loss whereupon they retired and secured themselves within, whilst our men who had quitted the town ran in great confusion over the bog. All our army stood at arms near the place but could do nothing, the castle being strong on the 



---

p.211



land side. In this posture we continued till towards night with manifest tokens of fear in most men's faces, as if utter ruin had been hanging over us upon the loss of that place, though the army was untouched, and, except the defence of the **Shannon**, no loss sustained.[245](javascript:footNote('E680002-001/note245.html')) At night we returned to the camp, threw down our tents and made all ready to march.


Wednesday the first of July: before day we marched about two or three miles, and encamped on a {ms folio 125b} plain about the same distance from **Athlone**. This march was performed with great confusion and disorder, such a panic fear having seized our men that the very noise of ten horsemen would have dispersed as many of our battalions, above half the soldiers scattering by the way without any other thing but their own apprehensions to fright them. This, was a general thing in ten regiments of foot that marched, and so great was the terror that in Brigadier Talbot's Regiment, one of the eldest and best in the army, there were but 190 men left when we came to encamp, our last muster amounting to 400 and upwards. We lay here the remaining part of the day without any disturbance, many men dropping in to us, their fear somewhat abating by our encamping so near the enemy. The weather was extreme wet and provisions very scarce this day, all the servants being gone to **Ballinasloe** with what little necessaries every man had.


Thursday the 2nd: the general beat at four in the morning, and our little army soon after marched and encamped three 



---

p.212



miles from that place on the bog and sides of hills, two miles from **Ballinasloe**, with a bog in front, impassable for horse, only by a narrow causeway through a thick impenetrable underwood. Here we first encamped regularly in two lines with the horse on both wings, the regiment of foot guards in the centre, which was the first time that had been practised among us.


{ms folio 126a} Friday the 3rd: we marched again three miles, two to **Ballinasloe** and one beyond it, and encamped on the sides of the hills near a village called **Aughrim**[246](javascript:footNote('E680002-001/note246.html')) far from water and fire, without any other thing worth observing.


Saturday the 4th: nothing remarkable.


Sunday the 5th: a party of our horse and dragoons advancing to discover the enemy met a small squadron of about thirty-six of them near the place on which we encamped before, of whom they killed about twenty and took five prisoners, pursuing the rest till within a mile or two of **Athlone**. Every regiment was this day reviewed by its major.


Monday the 6th: returns were given in by the commanding officers of each regiment of their men and arms, the commanders-in-chief having to that purpose taken another review.


Tuesday the 7th: the general beat at break of day with directions not to stir tent or baggage till further order, but to keep in a readiness to march. Thus we continued most part of the day, and after noon it was declared we were not to march. This day was broken at the head of the picket guards, drawn together for that purpose, Lieut.-Col. James O'Neill[247](javascript:footNote('E680002-001/note247.html')) of the Regiment of Cormuck O'Neill, and obliged to carry a musket in the same regiment for quitting his post and running away shamefully at **Athlone**, which either was the cause or contributed much to the losing of that town, {ms folio 126b} the whole regiment by his example basely abandoning the 



---

p.213



works and flying in such disorder that they lost a considerable number of their arms. Five captains of the same regiment were then also suspended.


Wednesday the 8th: the army began to march early, but the rear stirred not till noon, and we moved but a mile from the place, encamping on a plainer, pleasanter ground than the last. This day was very remarkable, first for the violent scorching heat of the sun, which I then thought so excessive as to exceed what I had felt in three years I lived in Portugal; but the reason might (be) because in that country I was never much exposed to it whereas here I marched afoot without any better place to refresh in after all than a small soldier's tent; next for the prodigious thunder, which during three hours it continued at a great distance all men took for hot firing of cannon till coming near it lasted about an hour longer in monstrous claps so great as are seldom heard, and all ended in such a violent shower of rain as ran through the tents as if there had been none. Here our artillery encamped in the front of the first line.


Thursday the 9th: this morning returned to the camp a party of our horse, who having met some of the enemy's advanced guards beyond **Ballinasloe**, killed nine and took five prisoners.


Friday the 10th: the whole body of the enemy {ms folio 127a} advanced, their horse driving ours before them even to our camp.


Saturday the 11th: the enemy encamped near **Ballinasloe**, their horse advancing even to the hills opposite to our camp, which were divided from us only by the bog, and on them they kept their videttes. Both parties lay still all day, nothing remarkable happening, only preparing to engage the next day, which was


Sunday the 12th: when the enemy moved from their camp betimes and appeared on the hills opposite to us about eight of the clock. Then they began to open to the right and left, still stretching out all day insomuch that we had cause to fear they would be able to flank as well as face us. They brought down their cannon, and played it from the most advantageous posts, but to little effect by reason of good 



---

p.214



ground we were possessed of; they also threw some bombs, but to as little purpose. In the meantime we were not idle; the army was drawn out, and the small artillery we had placed to the best advantage to gall them. Detachments went down from our right to skirmish with the enemy as they came down from the hills and opened their left towards our right.[248](javascript:footNote('E680002-001/note248.html'))


 {ms folio 128a}[249](javascript:footNote('E680002-001/note249.html'))
### An Account of His Majesty's Royal Camp near Dundalk Friday June The 19th, 1690


First on the right the Lord Dungan's regiment of dragoons consisting of eight troops at fifty men in a troop, 400 men.[250](javascript:footNote('E680002-001/note250.html'))


2. His Majesty's first troop of Guards under the command of the Earl of Dover, consisting of 200 private gentlemen, 
2 lieutenants, 1 cornet, 1 guidon, 4 exangs,[251](javascript:footNote('E680002-001/note251.html')) [*...*] brigadiers, and 8 sub-brigadiers.


3. The second troop of Guards under the command of 
[*...*] in all respects answerable to the first.


4. The Duke of Tyrconnel's {ms folio 128b} Regiment of Horse, nine troops, 50 men each, in all 450.[252](javascript:footNote('E680002-001/note252.html'))




---

p.215


5.[253](javascript:footNote('E680002-001/note253.html')) The Royal Regiment of Foot Guards being twenty-six companies 80 in a company, 2,080 private men, besides officers. All well armed, clad in red lined with blue, their colours the royal colours of England St. George's cross and the arms of the four kingdoms.[254](javascript:footNote('E680002-001/note254.html'))


6. The Earl of Antrim's Regiment. Thirteen companies, 50 per company, 650 private men. Clothed in white lined with red. Their colours a red cross in a green field, in each quarter of the field a hand proper coming out of the clouds, holding a cross of Jerusalem or cross-crosslet gold, in the centre of the colours the Irish harp with a crown imperial with this motto In hoc signo vinces.[255](javascript:footNote('E680002-001/note255.html'))


7. The Lord Bellew's Regiment, thirteen companies, 
62 men each, 806 private men. Their clothes red, lined in orange tawny. Their colours bendy black, and tawny or filamot on the top. Next the spear, a crown {ms folio 129a} imperial, and round it this motto Tout D'En Haut. In the centre the Irish harp and crown imperial. The colonel's colours has a small red cross patée for distinction.[256](javascript:footNote('E680002-001/note256.html'))


8. Gordon O'Neill's Regiment, thirteen companies, 62 men each, 806 private men. Clothed in red, lined white, faced red. The colours white in the centre, a bloody hand round it, this motto Pro Rege et Patria pugno, the colonel's next, the spear a red cross patée for distinction.[257](javascript:footNote('E680002-001/note257.html'))


9. The Lord of Louth's Regiment, thirteen companies as the last, {ms folio 129b} clothed white lined and faced filamot, the colours filamot plain the colonel, the others with a blue cross in the centre, a crown imperial with this motto Festina lente.[258](javascript:footNote('E680002-001/note258.html'))




---

p.216


10. The Lord Grand Prior's Regiment, thirteen companies at 62 men each, 806 men, 39 corporals, 26 sergeants, 12 ensigns, 13 lieutenants, 11 captains, 1 major, 2 lieutenant-colonels, 13 besides [sic] officers in commission that have no companies, and such as are reformed, in all, [*...*]. Clothed in red lined white, all but the drums, who are blue with white and [*...*] loops. The Grenadier's white and red loops, their caps with a flaming city, and this {ms folio 130a} motto, *The fruits of Rebellion*. The colonel's colours white, the other two with the same device and motto as the Grenadiers' caps.[259](javascript:footNote('E680002-001/note259.html'))


These seven battalions of foot, with eight of French in all 
fifteen, made up the first line.


First line
  

dragoons two regiments . . . 800
  

horse . . . 1,700
  

foot fifteen battalions at 600 . . . 9,000
  

....................................................11,500
  

The second line equal to the first . . . 11,500
  
 
....................................................23,000
  
 
The reserve equal to half one of the lines[*...*] 5,250
  
 
....................................................28,250


### APPENDIX


In Lambeth Library there is a MS., 711, no. 4, entitled The Irish Villany | Feelingly represented | By the Baron of Courthuy Rousele | With an exact account of all his Troubles, Sufferings, Losses and Dangers | During the Irish Wars And how Miraculously | He has Escap'd Hanging With many Remarkable and pleasant Passages Concerning the Irish And their Babylonicall Gover*t* | Written in Dublin A*[ordm ]* 1692. | And Dedicated to y*e* Hon*ble* Trustees A*[ordm ]* 1700|. | It is beautifully written on foolscap size paper. Rousele begins his narrative with an account of his marriage in St. James' Church, London, in July 1686, to Mary Carteret, and he notes that his bride came to him ‘without a penny of portion.’ 
He tells how he settled first at Castle-hacket and then at Shrule in Mayo. On p. 16 there is a paragraph beginning ‘'Tis very well known that the Irish are a wild, stubborn, malicious, and cunning temper and constitution (the horses and cows are so too),’ a passage recalling Plato's description of the conduct of animals under a democratic government. Rousele declares that ‘Those that have described the humours of the natives would speak of the Irish in this manner. They are naturally strong, very nimble, haughty of spirit, silly in their discourses, careless of their lives, great admirers of their foolish and superstitious religion, which they neither understand nor follow, according to the canons of the Church of Rome: they are patient in cold and hunger, implacable in enmity, constant in love, light in belief, greedy of glory, great flatterers and dissemblers, stubborn as mules, great cheats in their dealings, ready to take an oath on all occasions, commonly great thieves, very barbarous when they have the upper hand, of a bloody temper, very unjust to their neighbours, breakers of their trust, mortal enemies to all those that are not of the Romish Religion, and ready to rebel against the English on all occasions. A fine description indeed of a nation.’ In reading this account we must remember the fact that the writer complains (p. 25) that he had been wronged and abused by Arthur French, Mayor of **Galway**, Captain Richard Martin, Sarsfield, and Lord Dillon: his 



---

p.218



wrongs and abuses give a distinct bias to his narrative. His kindness to the Williamite prisoners in **Galway** deserves mention, for they acknowledge that he ‘did supply us daily with meat and drink, besides half an ounce of tobacco to each man every day, to prevent the loathsome smell of the dungeon and gave us very often money besides. And tho' he was an enemy to the civil government he did venture to intercede for us to col. Macdonnell, then governor, and got us the privilege that the protestants of the town might bring us their charity, and yet nevertheless his own abated not.’


Like a great contemporary who hated mankind but liked individual men, Rousele liked individual Roman Catholics though he hated their communion. When near **Ross** in County **Wexford** he described what he labelled ‘Ignorance and superstition of the Irish’:—
  


‘I could not forbear (seeing) so many unworthy and base actions which were daily committed against the poor English who lived quietly and inoffensively. I remember that sometimes after mass I did speak to them (i.e. the Irish) in this manner, Gentlemen you know very well King James by his Proclamations will have the English protected, and therefore you are obliged to use them well for your King's sake, and not wrong and affront them whenever you can. You take away all their substance, you make them to be rebels, as you call them, if they will or not, seeking all sorts of inventions to make them leave their habitations, that by those means, without making any opposition, you may make yourselves masters of what they have. And when they answered me that it was lawful to destroy disaffected people and Huguenots, I endeavoured as modestly and as civilly as I could to show them how much they were mistaken, and that their priests should burn in hell upon their account, because they did not thunder against them in their meetings, to make them sensible of their barbarous injustices, which great sin, I said, no priest could absolve without making restitution. If you were overpowered by the English, said I, and that they should use you as you use them now, would you not damn and curse them, and call them all the rogues and villains? I am sure you would not fail to say quod tibi non vis fieri, alteri ne feceris; and why then, said I, are you so cruel and unjust to your fellow Christians, who do nothing either to offend or provoke you?  
[*...*]  
 
This discourse and several others of the same nature, made one Mr. Wall (who was a very sensible man), say   
[*...*]  
 I have heard our friars of **Ross** say that the Irish are the greatest 



---

p.219



thieves in the world, but that they do not trouble their heads with restitution   
[*...*]  

  

I asked one day a good rich farmer, How many gods there were? He mused and said nothing. Well, said I, how many persons are there? He looked upon the ground still remaining silent, which made me say, Is it not a great shame for a man of your age to be so ignorant? Sure you have heard often enough that there is but one God and Three Persons. To which he replied in a sudden (taking me by the sleeve) I knew well enough that there was one on one side and three on another, but I could not for my life join them together.’
  

‘This innocent creature knew no more of the Christian religion than a wild Indian, and when I complained of this insufferable ignorance to one of the Franciscan friars of **Ross**, he said, I hope God will pardon him and others, because since Cromwell's time the poor people have had but very little instruction, and we may thank the English for it.’ Cf. Archbishop King's Quaedam Vitae Meae Insigniora; ‘I heard scarcely anything concerning religion which I understood before my tenth year; then (i.e. 1660) schools being established I made a commencement in letters, but learned little concerning religion, neither had I known nor heard any one praying to God in secret, nor anything concerning the public or private worship of God, nor of the Catechism, Sacraments, Creed, Ten Commandments, nor of worship on the Lord's Day. I have said before, that I entered school in 1659 with many schoolfellows, but there was not one out of all, as far as I remember, who once offered private prayer to God, nor could it well happen that they should do so, for when all forms of prayer were abolished, it could scarcely happen that rude and illiterate youths should conceive prayers of their own. So all secret prayers ceased, nor were the boys taught to pray, as the custom had been, from their cradles, and to resort to prayers, privately, morning and evening. Thus, I confess that I heard nothing sacred, nor knew that such a duty was incumbent on me before I entered college, nor do I remember that it was done by any one.’


