

#The History of the Kingdom of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The History of the Kingdom of Ireland
=====================================


Author: Richard Burton [= Nathaniel Crouch]
-------------------------------------------


### File Description

Electronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project.Proof corrections by Janet Crawford

 1. First draft, revised and corrected.Extent of text: 
62270 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2007) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E680001-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

Nathaniel Crouch (c.1640–1725?), was an English bookseller, publisher and writer with a shop in London. He wrote under the pseudonym Robert Burton, or R. B. "This pseudonym was a reference to the author of 'The Anatomy of Melancholy' (1620)," which "became a best-seller partly because it translated hundreds of quotations from Greek and Latin into English, thereby giving many humbly educated men a passing knowledge of the classics. In a similar fashion Crouch's history books presented shortened and simplified versions of serious works to audiences that might otherwise never have read them." (DNB) In editions printed after his death, the pseudonym Richard Burton, rather than Robert Burton, was sometimes used. Crouch published many books on history and divinity. The histories were compiled by himself, and written in a comparatively plain style. Between 1666 and 1725 he seems to have published nearly eighty books, all intended for the popular market within England. In his prefaces he drew particular attention to the value for money offered through his works. At the cost of one shilling per book they sold well and were frequently reprinted. Crouch wrote and published for a sizeable and growing market in a time when literacy was increasing. He was no historian. It is not surprising to find inaccuracies and polemic partiality in his account. This text is given as a specimen of a popular history interpretation by an Englishman, illustrative of an account that would have been popular with the less educated social groups. [Source: DNB article by Jason Mc Elligott; supplemented by R. Mayer's article (see below).]

#### Sources


**About or by Nathaniel Crouch**2. R. Mayer, 'Nathaniel Crouch, bookseller and historian: popular historiography and cultural power in late seventeenth-century England', Eighteenth-Century Studies, 27 (1993–4), 391–420.
3. Gilles Duval, 'Trois aventuriers de l'imprimé en Angleterre au XVIIIe siècle: Nathaniel Crouch, John Dunton et Thomas Gent', Revue d'histoire moderne et contemporaine, 52:1 (2005) 5–127.
4. The History of the Kingdoms of Scotland and Ireland (1686).
5. Richard Burton [=Nathaniel Crouch], History of the Wars of England, with all the most remarkable passages, till the death of King Charles I. and his trial and last speech at large. (1681?)
6. Richard Burton [=Nathaniel Crouch], The History of Oliver Cromwell (1693).
7. Richard Burton [=Nathaniel Crouch], The History of the House of Orange (1693).
8. Richard Burton [=Nathaniel Crouch], The History of the Two Late Kings, Charles the Second & and James the Second (1693).
9. Richard Burton [=Nathaniel Crouch], The History of the Principality of Wales (1695).
10. Richard Burton [=Nathaniel Crouch], The History of Scotland (1696).
**Further Reading: a Selection**2. Acts and ordinances of the interregnum (1642–60), collected and edited by C. H. Firth and R.S. Rait. London: H. M. Stationery Office, 1911. (3 volumes.) Volume 2: Acts and ordinances from 9th February, 1649 to 16th March, 1660; see 598–603, 722–53.
3. Ireland under the Commonwealth: being a selection of documents relating to the government of Ireland from 1651–1659, edited by Robert Dunlop. 2 volumes. (Manchester: Manchester University Press. 1913) Volume 1.
4. William Francis Thomas Butler, Confiscation in Irish history (Dublin 1917, London 1918, reprinted 1970: Kennikat Press).
5. R. B. McDowell, 'The problem of religious dissent in Ireland, 1660–1740'. Bulletin, Irish Committee of Historical Sciences 40 (1945).
6. Jane H. Ohlmeyer, Civil war and restoration in the three Stuart kingdoms: the career of Randal MacDonnell, marquis of Antrim, 1609–1683. (Cambridge: Cambridge University Press 1993.)
7. Jane H. Ohlmeyer (ed.), Ireland from independence to occupation 1641–1660 (Cambridge: Cambridge University Press 1995).
8. Jane H. Ohlmeyer 'The civil wars in Ireland'. In: John Philipps Kenyon; Jane H. Ohlmeyer (eds.), The civil wars: a military history of England, Scotland, and Ireland 1638–1660 (Oxford: Oxford University Press 1998) 73–102.
9. Micheál Ó Siochrú, Confederate Ireland 1642–1649: a constitutional and political analysis. (Dublin: Four Courts Press 1998).
10. Jane H. Ohlmeyer (ed.). Political thought in seventeenth-century Ireland: kingdom or colony. Cambridge: Cambridge University Press in association with the Folger Institute, Washington, DC, 2000.
11. Pádraig Lenihan, Confederate Catholics at War 1641–49 (Cork: Cork University Press, 2001).
12. Henry Mangan, 'The sieges of Derry and Limerick'. Nineteenth Century & After, 50 (1901) 459–478.
13. Demetrius Charles Boulger, The Battle of the Boyne: together with an account based on French and other unpublished records of the war in Ireland (1688–1691) and of the formation of the Irish brigade (...) France (London: Seeker 1911).
14. J. M. Flood, The sieges of Limerick, 1690–91; a narrative based on contemporary sources. (Limerick: Limerick Leader, 1944).
15. D. Murtagh, 'Origins of Irish nationalism'. Studies; an Irish quarterly review, 39 (1950) 87–90.
16. J. Jordan, 'Würtemberg at Limerick, 1690'. Studies; an Irish quarterly review, 43 (1954) 219–225.
17. J(ohn) G(erard) Simms, 'The surrender of Limerick, 1691'. Irish Sword, 2:1 (1954) 23–28.
18. J. G. Simms, The Williamite confiscation in Ireland, 1690–1703 (London: Faber and Faber 1956).
19. J. G. Simms, 'Eye-witnesses of the Boyne'. Irish Sword, 6:22 (1963–4) 16–27.
20. J. G. Simms, 'The siege of Derry (1689)'. Irish Sword, 6:25 (1963–4) 221–33.
21. J. G. Simms, The Jacobite Parliament of 1689 (Dundalk: Dundalgan 1966).
22. J. G. Simms, The siege of Derry (Dublin: APCK 1966).
23. J. G. Simms, Jacobite Ireland 1685-91 (London: Routledge and Kegan Paul 1969).
24. Michael Hewson, 'Robert Stearne's diary of the Williamite campaign'. An Cosantóir 33 (1977) 49–53.
25. Sheila Mulloy, 'French eye-witness of the Boyne'. Irish Sword, 15 (1982) 105–111.
26. J. G. Simms, War and politics in Ireland: 1649–1730; edited by D.W. Hayton and Gerard O'Brien. London: Hambledon, 1986.
27. Patrick Macrory, The siege of Derry (Oxford: Oxford University Press 1988).
28. Peter McCartney, The siege of Derry 1689 (Derry: Guildhall Press, 1988).
29. D. Murtagh, H. Murtagh, 'The Irish Jacobite army, 1689–91'. Irish Sword, 18 (1990) 32–48.
30. William Kelly (ed.), The sieges of Derry. (Dublin: Four Courts 2001).
31. Adrian Johns, 'Printing, publishing and reading in London, 1660–1720'. In Patrick Karl O'Brien (ed.), Urban achievement in early modern Europe: golden ages in Antwerp, Amsterdam and London (Cambridge: Cambridge University Press 2001, 264–83).
32. James Raven, 'The economic context (1557–1695)'. In: John Barnard; Donald Francis McKenzie (eds.), The Cambridge history of the book in Britain, vol. 4: 1557–1695; with the assistance of Maureen Bell (Cambridge: Cambridge University Press 2002, 568–82).
33. Donald Francis McKenzie, 'Printing and publishing 1557–1700: constraints on the London book trades'. In: John Barnard; Donald Francis McKenzie (eds.), The Cambridge history of the book in Britain, vol. 4: 1557–1695; with the assistance of Maureen Bell (Cambridge: Cambridge University Press 2002, 553–67).
34. James Raven, The business of books: booksellers and the English book trade, 1450–1850, (New Haven (CT) & London: Yale University Press 2007).
**The edition used in the digital edition**2. The History of the Kingdom of Ireland; being an Account of all the Battles, Sieges, and other considerable Transactions, both Civil and Military, during the late Wars there, till the entire Reduction of that Country, by the Victorious Arms of our most gracious Sovereign, King William (...). Richard Burton [=Nathaniel Crouch] A new edition with wood-cut portraits [138 pages] Printed for Machell Stace, no. 5, Middle Scotland Yard, by W. Smith & Co. 6, King Street, Seven Dials.Westminster (1811)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the author's introductory pages (unnumbered) and pp 1–136 of the volume.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


Non-standard spellings of personal names and place names are standardised using the reg attribute within the corresponding name tags. Otherwise, names are not tagged. Outdated spellings are encoded orig, with the reg attribute indicating the normalised spelling. Where the hardcopy has phrases in uppercase, in the electronic edition these are encoded in emph tags and normalised to mixed case. Encoding is subject to revision. The illustrations are not reproduced.


##### Quotation


Direct speech is tagged q. The author does not identify his written sources.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the history; div1=the book. There are no chapters; paragraphs are marked; page-breaks are marked pb n="". The author's introduction is contained in an unnumbered div in the front matter.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, group and personal names are not tagged. Words, terms, and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the book. ### Profile Description


Created: By Richard Burton [ =Nathaniel Crouch]
 Date range: 1692-1693.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] A few words are in Latin.


##### Language: [GA] A few terms are in Irish.


### Revision History


* (2008-09-23) Beatrix Färber (ed.)

* Keywords added; file validated; new wordcount made.
* (2008-07-26) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header.
* (2007-11-28) Beatrix Färber (ed.)

* Additions to bibliography and new wordcounts made, file re-parsed; SGML and HTML files updated.
* (2007-11-23) Beatrix Färber (ed.)

* File parsed; SGML and HTML files created.
* (2007-11-20) Beatrix Färber (ed.)

* Additions to header and bibliography made.
* (2007-11-14) Beatrix Färber (ed.)

* Bibliography created; second proof-reading begun; more structural and content markup applied.
* (2007-11-13) Beatrix Färber (ed.)

* Header created.
* (2007-09-25) Janet Crawford (ed.)

* File proofed (1); basic structural and content markup applied.
* (2007-09-19) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E680001-001


### The History of the Kingdom of Ireland: Author: Richard Burton [= Nathaniel Crouch]




---

p.??


### To the Reader


The Kingdom of Ireland has, for several ages, been an **Aceldama**, or field of slaughter, watered with the blood of Englishmen; occasioned by their repeated rebellions, and inveterate aversion to the English Nation; in pursuance whereof, they have left no treacheries, murders, or villainies unattempted, being encouraged thereto by their ignorant and superstitious Priests, to whose dictates this stupid people entirely submit, and who endeavour to foment and cherish this inexorable hatred, formerly under pretence of recovering their liberty, but, since the Reformation, upon account of difference in religion, which made them very troublesome to the renowned Queen Elizabeth, and as one chief occasion of the horrid and bloody massacre in 1641. In the late reigns, they were somewhat quieter, receiving much favour and countenance from the court; but upon his present Majesty's glorious expedition into this kingdom, they made an absolute defection from the crown of England, and had totally reduced that country to Popish idolatry, and French slavery, if his Majesty's victorious arms, and admirable conduct, had not, by the blessing of heaven, reconquered and reduced this stubborn nation to their former subjection; of which the following History gives a brief account, as well as of the


---

p.??




ancient inhabitants thereof, and of all considerable matters from its first conquest, to this time; which being full of variety and delight, I doubt not, will be as acceptable to the reader, as my former mean endeavours of this kind.


R. B.


---

p.1


Ireland hath been always accounted a land of wonders, and many strange relations have been made thereof; though the greatest wonder seems to be, that such incredible stories should be told, and so firmly believed as they are by the Irish and divers others, to this very day. To give you a taste of them, we find it recorded in their histories, that in the north of Munster there are two islands, a greater and less, in the first never any woman or female creature entereth but they instantly die, as hath been experimented by bitches and she cats brought thither to that purpose. The cock birds sing and hop upon the trees; but the hens avoid it as a fatal place. The lesser is called the Living Isle, because none can die therein, and therefore those that dwell here, when they are even tired with living, by reason of sickness or old age, desire to be conveyed thither, and no sooner arrive, but they give up the ghost. In the west part of Connaught, say they, there is an island called **Aren**, to which St. Brendan doth often resort, the air whereof is so great an enemy to putrefaction, that they never bury the bodies of the dead, but are kept above ground without the least smell or offence; so that a son may there view his father, grandfather, and all his relations for many ages past.




---

p.2


In Ulster is a lake thirty thousand paces long, and fifteen thousand broad, out of which ariseth the noble northern river called **Bane**, wherein there are abundance of great fish, so that the nets are often broke. It is believed by the inhabitants, that they were very wicked, vicious people formerly living in this place; and there was an old prophecy in every one's mouth, that whenever a well which was therein, and was continually covered and locked up carefully, should be left open, so great a quantity of water should issue thereout, as would forthwith overflow the whole adjacent country. It happened that an old beldam coming to fetch water, heard her child cry, upon which running away in haste, she forgot to cover the spring, and coming back to do it, the land was so over-run that it was past her help; and at length she, her child, and all in that territory were drowned, which caused this pool, that remains to this day. A strange spring is likewise discoursed of in Ulster, wherewith if a man wash his hair or beard they presently turn gray, and another of a contrary quality, making all gray hair black. I have seen a man, saith my author, who washing half his beard with this water, it was all white, the other part remaining brown. In Connaught is a well on the top of a hill that ebbs and flows equally with the sea, yet the water is fresh.


At Castlenock, near Dublin, is a window neither glazed nor latticed, yet a candle being set there in the greatest wind or storm, burns as quietly as in the greatest calm; and a spring, the water whereof is wholesome to human bodies, but poison to beasts. In Kildare is a curious field upon an hill, where the Irish say a great battle will one time or other be fought between the Irish and English, with such vast effusion of blood, that a mill in a valley hard by shall be turned four and twenty hours with the streams thereof. In a plain in this country, they relate, those stones were formerly placed which are new on Salisbury Plain, and conveyed thither with sleight of hand by Merlin the Welsh prophet, at the request of Aurelius Ambrosius, king of the Britons. In the south part of Munster is an island blessed by St. Brendane, a famous she saint in this island, with this strange quality, that if any hare, stag, or other wild beast be chased thereabout, it makes toward this islet, swimming over a small stream into it, whither the dogs dare not pursue, but standing on this side the bank, see their enemy sit there securely, protected by some invisible bars from danger. But the most remarkable wonder of all is that of St. Patrick's purgatory, thus described by the superstitious Irish writers: In Ulster there is a pool which incompasseth 



---

p.3




an island, in one part whereof stands a church exceedingly enlightened by the glorious appearance of angels; the rest of the isle is dark and horrid, seeming only a den for devils and evil spirits, wherein is a pit, which, by a door, leadeth into a cave of stone, divided into seven parts, which is called St. Patrick's purgatory; for when this Irish saint preached the gospel to them, and told them of joys eternal in another life for the godly, and miserable torments to the wicked, the people came and spake thus to him: ‘Sir, though we like your preaching, yet we are not willing to lose our liberty; you tell us many strange stories, persuading us to forsake our pleasures and delights on earth, for which you promise us a reward to an unknown place in the other world. You likewise threaten us with a dismal dungeon, appointed for offenders, which, if we could believe to be true, would more effectually prevail with us to leave our delights, than any other motive.’


St. Patrick perceiving that the fear of torment had more influence upon them than the blessedness of heaven, prayed earnestly that God would give them some resemblance of the future misery of sinful souls; whereupon he was directed to this place, wherein if any person would enter, he was to prepare himself by prayer and fasting fifteen days, during which time the friars represented to him the horrors of the place, and how the evil spirits would torture them; so that, as soon as they were in, what for want of food and sleep, their fancies have been much disturbed, and they have dreamed of those terrible things that have been told them; which indeed was the whole mystery of all these illusions, as divers affirmed, who tried the experiment in those superstitious times; however, the priests made good use of it, by gaining credit and money from the poor deluded people. Neither is that excellent blessing procured to this island by the prayers of their patron St. Patrick to be forgot, namely, their freedom from serpents, and all other venomous creatures; to confirm which, one of their authors confidently relates the following story: A young man in the north of England, lying asleep in the fields, with his mouth open, an adder crept into it, and so down into his belly, and tormented him with such violent pains, that he desired his friends to kill him, it never ceasing to tear and rend his bowels but while he was eating; medicines, nor pilgrimages to saints would do no good; at length being advised to go to Ireland, he no sooner arrived there, and had eat and drank upon the island, but the serpent was immediately killed within him, and voiding it downward, was instantly cured, and returned in good health to England. So that it 



---

p.4




was a proverb formerly, there was nothing venomous in Ireland but the men and women, which was intended of the savage and brutish manners of the wild Irish.


Neither was the inhabiting of this country less miraculous, than the place, especially as to the antiquity thereof; for it is recorded in the Irish chronicles, that when the patriarch Noah threatened the people of the old world, that vengeance would follow their wickedness, and thereupon built an ark to convince them, that the whole earth would be overflown in a few years, the generality disregarded his admonitions, only Cesarea, Noah's niece, believing her uncle s prophecy, got a ship, and, accompanied with three men, and fifty women, resolved to find out some country, never yet inhabited, but unspotted with vice, and thereby free from the sentence of God's wrath: after long sailing and many dangers, they at length arrived in Ireland; but within forty days after their landing, the universal deluge came, and swept away all these new inhabitants at once; this, they say, happened in the year after the creation of the world 1556; which was very wonderful, being long before the art of navigation was invented.


But to let this pass with as little credit as the reader pleases, it will be a sufficient honour to the antiquity of the Irish, to allow that their country was first peopled by some of Noah's kindred, even as soon as any island in the world; for their histories relate, that about two hundred years after the flood, upon the confusion of tongues at Babel, Japhet and his posterity, emboldened by Noah's ark, built a ship, wherein they adventured to make new discoveries in the unknown parts of the world; among them was one Bastolenus, who encouraged by the example of Nimrod, then monarch of Assyria, resolved to settle a kingdom in these western islands, where he might rule without *control*, and at length, fortune brought him and his people to the coast of Ireland, where he settled, and left three sons behind him. Among his followers, were some of the posterity of Cham, that were giants, who, by the example of Ninus, rebelled against their king, and set up another, who contended together with dubious success; at length the giants were utterly subdued, their enemies sparing neither man, woman, nor child, and to satisfy their revenge to the full, they would not vouchsafe to bury them; but let them lie like dead dogs, the stench whereof caused such a mortal pestilence, that few of the victors escaped with life, but those who fled away by sea, to avoid the infection.


And here our Irish author tells us, that one of the giants, named Ruanus, who was preserved, lived above two thousand years after 



---

p.5




(twice the age of Methusalem), by whom St. Patrick was thoroughly informed of the state of this country, and being baptized by him, died in the year of our Lord 430. Some few of these giants hid themselves in caves and dens after the last battle, till famine forced them to seek for relief, when creeping out, and finding no resistance, they grew bolder, and having notice how matters had happened, settled themselves in the best part of the country; then Magog, one of the sons of Japhet, inhabiting in Scythia, in process of time, several of his posterity, desirous to seek adventures, landed in Ireland, but were chased thence by the giants, after wars had continued between them two hundred and sixteen years. Next, the five sons of Dela from Greece came hither, and utterly routed the giants, being before weakened by their own dissension, and then divided the country into five provinces, as they are at this day, fixing a stone in the midst of the country, to make the division more equal; but at length ambition prevailing, one of these sons, named Slanius, subdued his other brethren, and reigned alone, but was interrupted in his new dominion by an army of Scythians, who invaded the land, and after them the Britons, and then the Scots under Gathelus, as is afore-mentioned, came from Spain, and fixed here, reigning a great while in peace, till the Picts came thither out of Scythia under Roderick, being accidentally cast ashore upon those coasts, who were brought before the king of Ireland, to whom Roderick thus spake:


‘It is not because we degenerate from the courage of our ancestors, but by the frowns of fortune, that we are now become humble supplicants to Ireland, who never yet submitted to any other nation; behold, Sir King, and regard us well, and then believe that it is no small occasion which makes our lusty bodies thus to stoop. Scythians we are, even Picts of Scythia, from which two names there redounds to us much glory; we will not whine and complain, that civil wars at home forced us from our own country, thereby to move pity in you towards strangers, let our servants and children discourse that at leisure, we only desire the favour to reside some short time in your land, as our necessities require. A king craves this kindness of a king, and soldiers of soldiers; princes are easily sensible how much it concerns their honour and interest to relieve and support other princes oppressed by traitorous practices; yea, all men are naturally inclined to have compassion of their fellow creatures, and to be sensibly touched with their calamities; admit, then, we beseech you, these scattered remnants of Scythia. If your land be narrow, we are not many; if your soil be barren, we are born and bred to hardiness. If you live 



---

p.6




in peace, we are at your command as subjects. If you make war, we are ready to serve you as soldiers*.* We demand no kingdom, no state, no pomps, nor triumphs in Ireland; we are here alone, and have left those things behind us, with our enemies; howsoever you dispose of us, we shall be content therewith, not remembering what we formerly have been, but what we now are.’


After mature consultation with their ancient records, which forbid them to mingle divers nations in one realm, as occasioning quarrels and dissensions, and considering their want of room, they persuaded these strangers to go into Britain, providing ships and guides to convey them thither, who landed them in the north parts, now called Scotland, where, contrary to their expectation, Marius, king of the Britons, waiting their coming, fell upon them, and slew king Roderick, and most of his followers; those who escaped, upon humble submission, he licensed to inhabit the uttermost parts of Scotland; at length Fergus came out of Ireland with his Scots, and inhabited there, as is already related. The Irish, as some authors write, were first converted to Christianity by St. James the apostle about this time, though themselves say, that **Paladius** was first sent from Pope Celestine to preach the gospel to them; and after him the renowned St. Patrick, who acted wonders among them, making many female saints, and among others, St. Bridget, a bye-blow of a captain in Leinster, who finding his wench with child, after she was delivered of this Bridget, sold her privately to an Irish conjurer, for fear of his wife's jealousy; the young lass was instructed in the faith by St. Patrick, and was of so great judgment, that not only the people, but a whole synod of bishops assembled near Dublin to hear her wise counsel in many weighty causes. One action in her childhood made her famous: the king of Leinster had bestowed on her father, for his good service, a rich sword, garnished with many costly jewels: this damsel going often to visit her poor sick neighbours, and having not wherewithal to relieve them by reason of the covetousness of her father and mother, she secretly gave them those jewels out of that useless sword, which being known, the king was much offended thereat, and coming one time to banquet with her father, he called her before him, not yet above nine years old, demanding how she durst in that manner deface the gift of a king; she answered, ‘They are bestowed upon a better king than you, whom finding in such extremity, I would have given all that my father, yea all that you had, and yourselves too, if it were in my power, rather than Jesus Christ should starve.’




---

p.7


In the year of Christ 586, the Danes, or Norwegians, being much inclined to invade other countries, sensible they could not find more barren lands than their own, grew dreadful both by sea and land, seizing upon the isles of Orkney, and going from thence to Ireland, under one Turgesius, conquering the Irish kings; and reigned thirty years, exercising all kind of tyranny upon the nobility and commons; it happened that the king of Meath was in some trust with him, of whom he required his only daughter for his concubine; the father readily answered, ‘Saving your Highness's fancy, there are divers ladies of quality in this country, fitter bed-fellows for a king, than my brown girl;’ and then reckoned up many of his nieces and cousins, extolling them to be rather angels than mortal creatures, that he even ravished the tyrant with joy before he saw them; but making some delay, he began to suspect that it was only a trick to preserve his daughter from him; to take off which the king of Meath spake thus to him: ‘If I should say that I willingly gave you my only daughter to be deflowered, your Highness's wisdom would surely judge I did but flatter you; and yet if ten such daughters were dearer to me than the satisfying your pleasure, by whose bounty and goodness she, and I, and all the rest are supported, I should be unworthy of that friendship and confidence which you are pleased to allow me; as for the wench, she must needs reckon it a great honour to be admitted to the bed of so great a prince, since queens have formerly taken long journies, to yield themselves up to noble conquerors, in hope to have issue by them; if there be any scandal in it, a short time will wear that out, but such a friend as you have been to me and mine, I can never hope to find, and therefore fear your displeasure more than the loss of twenty maidenheads, since fathers have not valued to give their own wives to satisfy the lusts of their sons; appoint then the time and place, remote from your court, and I will send you my daughter, accompanied with twelve or sixteen ladies, the meanest of whom is an empress in comparison of her, and when they are before you, choose your game as you like, and if my child chance to please you, she cannot be too good to be at your command; I desire only, that if any other of your friends shall require the same favour, your Majesty would remember whose daughter she is.’


The tyrant dismissed him with repeated thanks for this liberal offer, and the king of Meath, at the time appointed, dressed up his daughter in the best manner, and with her sixteen handsome beautiful young men in women's clothes, who were all presented to him in his privy chamber, none being present but a few debauched attendants;



---

p.8



 
whereupon these young men drew out their daggers, and killed the tyrant and all the rest, with very small resistance. This act was soon blown over all Ireland, and the oppressed princes instantly rose in arms to recover their liberties; all Meath and Leinster quickly assembled, whom the king commending for their forwardness in so natural a quarrel, thus encouraged; ‘My Lords and Friends, the case neither admitteth delay, nor requires any great consulting; speed and courage is all in all, while the thing is fresh and new, and some of our enemies are still and asleep, some lament, others curse, some are counselling, but all dismayed, let us prevent their fury, dismember their strength, cut off their flight, and seize upon their places of refuge and defence; it is no victory if we pluck their feathers, and do not break their necks; not to chase them in, but to rouse them out; to weed them, not to rake them over; not to tread them down, but utterly to root them up; this lesson the tyrant himself taught me; for demanding once of him, by way of parable, how land might be freed from certain ravenous fowls that annoyed it, he advised us to watch where they bred, and fire their nests about their ears; let us go, then, and fall upon these cormorants which shroud themselves in our possessions; and let us destroy them, that neither nest nor root, neither seed nor stalk, neither branch nor stump, remain of this cursed and ungracious generation.’


He had scarce ended his oration, when the people with shouts of joy extolled him as the defender of their lives and liberties, assuring him of their utmost assistance; and so joining their forces, they with a running camp in a very short time cleared every corner of the land of the Norwegians, razing their castles to the ground, killing all that resisted, and banishing the rest, whereby every prince again recovered his own government. The histories of Denmark relate, that sometime before this, Fridlenus, king of the Danes, arriving in Ireland, besieged Dublin, but perceiving it hard to take by reason of the strength of the walls, he contrived to catch a number of swallows who had their nests in the houses within the city, and tying wild-fire to their feet, they flying home set the houses on fire, which whilst the citizens endeavoured to quench, they entered the city: after which, Gonno, the third king of Denmark, though a Pagan, married Thyra, daughter to the Christian king Etheldred of Britain, by whom he had two sons, Canute and Harold, who first invaded England, and then Ireland, where, at the siege of Dublin, Canute was slain, who for his valour was so extremely beloved by his father, that he vowed to kill him with his own hands who should bring him tidings 



---

p.9




of his death. Gonno was now very old and blind, pleasing himself in nothing more than hearing of the victories of his sons; when, therefore, Queen Thyra had notice of her son's death, which neither she nor any other durst discover to him, she contrived to clothe her husband all in mourning, and prepared all other things usual at a funeral, and then used many lamentable expressions of grief for the loss of some friend; which Gronno perceiving, ‘Wo is me,’ said he, ‘you then signify the death of my son Canute:’ whereunto she answered, ‘that he himself, and not she, had now discovered the truth;’ whereupon, for grief thereof, he instantly gave up the ghost.


We find little material in the Irish chronicles, from this time till the conquest thereof by King Henry the Second, which how it was occasioned I shall now relate. In the year 1167, **Dermod Macmorrogh**, King of Leinster, possessed all the east parts of the isle along the sea-coasts, using great cruelty toward the lords and gentry: it happened that Morrice, King of Meath, going far into the country, Dermod in the mean time stole away his Queen by her consent, which Morrice, upon his return, resolving to revenge, represented it to Roderick O'Connor, King of Connaught, and monarch of all Ireland, beseeching his assistance against the vile adulterer. The people of Leinster, detesting both Dermod and his quarrel, for his former tyrannies, universally forsook him, so that he was forced to fly to King Henry the Second for succour, who was then employed in his Wars in France. Henry had before cast an eye upon Ireland, because they always assisted the French with men, and Adrian, an Englishman, being now Pope, he obtained his consent for the conquest thereof, upon condition of reducing the inhabitants to Christianity, who were almost turned barbarous: at this very time Dermod offered him his service, of which he was very joyful; but having wars with France, he had not opportunity to go with him, and therefore taking an oath of fidelity and obedience from him, he took him into his protection, and, for his more speedy assistance, sent him into England honourably attended, with letters patents to this effect: ‘Henry, King of England, Duke of Normandy and **Aquitain**, and Earl of Anjou, to all our faithful subjects, Englishmen, Normans, Welshmen, and Scots, and to all other nations whatsoever subject to our dominion, sendeth greeting. When these letters shall come to your hands, know ye that we have received Dermod, Prince of Leinster, into the bosom of our grace and benevolence; wherefore, whosoever 



---

p.10




of our loving subjects within our dominions will aid, assist, and restore him, as our liege-man and faithful subject, be you assured that you have not only our license, but shall receive our favour and thanks for the same.’ With these letters he arrived at Bristol, where he agreed with Richard Strongbow, Earl of Pembroke, to give him his only daughter in marriage, for which the Earl was the next spring to settle him in his kingdom, which was to descend to him in right of his wife after Dermod's decease: in the mean time Robert Fitz-Stephens, and Maurice Fitz-Gerald, his brother, gentlemen of Wales, promised Dermod, that if he would assure them an estate in the town of Wexford for ever, they would assist him to begin the recovery of his country, while the Earl of Pembroke was providing stronger forces; and accordingly Dermod going over privately before, they, with thirty knights, sixty esquires, and three hundred archers, landed in Ireland, being the first Englishmen that ever came thither, and marching toward Wexford, Dermod met them with five hundred men, and joining their forces they soon took the town of Wexford, which was freely given to Fitz-Stephens, according to their covenant; and their army daily increasing, they prevailed so much, that Roderick, the monarch, assembled all the petty kings to defend their country: at length an agreement was made, whereby Dermod was restored to his former estate, and more forces arriving from England, Dermod encouraged thereby, resolved to be revenged of those of Dublin, who had been great enemies to him and his father, and marching thither, they soon submitted themselves to him.


Now arrived the Earl of Pembroke with a considerable aid, wherewith he made such notable conquests, that King Henry, growing jealous of his greatness, sent an edict to *recall* all the English out of Ireland; but the troubles raised by Thomas Becket, Archbishop of Canterbury, hindered the prosecution thereof. Pembroke was then in Dublin, where he was closely besieged by the Irish under Roderick (Dermod dying some time before), and was at last reduced to such extremity, that they resolved to sally forth and die like men, rather than starve; and so issuing out with not above two or three hundred men, they valiantly assaulted their enemies' camp, consisting of near thirty thousand, with so much resolution, that with great slaughter of them they obtained a glorious victory, chasing their enemies till night came on, and then returning triumphantly with abundance of provisions and rich spoil into the city, Roderick himself hardly escaping with his life; after which, the Earl of Pembroke coming into England 



---

p.11




surrendered Dublin and all the castles and forts on the sea-coasts to King Henry, and thereby removed his jealousy, and was again received into favour.


In 1172, King Henry the Second landed with a considerable army, whom Roderick, in behalf of himself and all the other petty princes of that kingdom, acknowledged for his sovereign lord, and the supreme prince of all that island, so that none refused obedience to Henry, but only the province of Ulster. The Christmas after, the king royally feasted all those princes who were become his subjects at Dublin, and then taught the Irish first to eat crane's flesh, which was before abhorred by them: he then called a synod, where divers abuses were reformed, and new canons made for the future government of the church; and among others, ‘That, since it had pleased God to bring them under the English dominion, they should for the future observe all the rites and ceremonies of the English church.’ Soon after King Henry returned to England, being summoned by the Pope to answer for the death of Thomas Becket, which occasioned much trouble. In 1185, Henry made over all his right and title to Ireland to his youngest son, John, afterwards King of England, who landing at Waterford, accompanied with a few dissolute companions, whose advice he only regarded, caused great commotions, whereupon he went back again the same year. After the death of his brother, Richard the First, John succeeded, and came again into Ireland, settling the country, and banishing the **Lacies** for some misdemeanors; but upon submission, gave them pardon, though not without paying him great fines.


In 1300, Edward the First sent for aid out of Ireland, to assist him in his wars against Scotland; and after his death the Scots invaded Ireland, being assisted by the wild Irish, whereby the country was miserably ruined, four princes of Connaught joining with them; but by the valour of the English, eleven thousand were slain in one fight, among whom were the King of Connaught, O'Kelly, a great lord, and divers others. The death of O'Kelly is somewhat remarkable; the Lord Bermingham, commander of the English army, sent one John Hussey, his esquire, into the field to view the dead bodies, and search whether his old mortal enemy, O'Kelly, were slain among the rest. Hussey goes only with one man to turn up the bodies, and was presently espied by O'Kelly, that lay lurking behind a bush, who knowing Hussey to be a stout man, came towards him and said, ‘Hussey, thou seest I am armed at all points as well as my esquire, thou art naked, with thy page only, so that had I not a great kindness 



---

p.12




for thee, for thine own sake, I would slay thee for the sake of thy master; but if thou wilt come and serve me as I desire, I promise, upon St. Patrick's staff, to make thee a lord of a greater estate in Connaught, than thy master hath in Ireland.’ These words not prevailing upon Hussey, a lusty fellow belonging to O'Kelly began to reproach him for refusing so fair an offer, so that Hussey had now three to deal with; he therefore dispatched this fellow first, and then struck O'Kelly's esquire such a blow under the ear, that he laid him for dead; lastly, he fell upon O'Kelly himself, and instantly slew him; and then perceiving the esquire, who was only astonished with the stroke, to revive again, he caused him to carry his lord's head upon a truncheon, and presented it to Bermingham, who for this notable service knighted Hussey, and gave him large possessions, the successors of whose family were afterwards lords of Galtrim.


In King Edward the Second's reign, the Lord Roger Mortimer was sent over justice into Ireland, at which time Edward Bruce, brother to Robert Bruce, King of Scotland, who had taken several places, and caused himself to be crowned King of Ireland, was slain in a great battle, wherein the Scots were vanquished; one Malpas, an Englishman, who rushed into the midst of the fight to encounter Bruce hand to hand, was in the search found dead, fallen upon the body of Bruce. This year, 1320, an university was erected in Dublin, about which time the lady Alice Kettell, with her two companions, Petronelle and Basell, were charged with enchantment, and that they had conference every night with a spirit called Robin Artisson, to whom they sacrificed in the highway nine red cocks, and eleven peacocks' eyes; and that this lady swept the streets of Kilkenny in the twilight, bringing all the filth to the door of her son, William Outlaw, muttering these words: 


> 1. To the house of William, my son,
>   
> Go all the wealth of Kilkenny town.
> 




The lady made her escape, but in searching her closet (saith my author) they found a wafer of sacramental bread, having the Devil's name stamped thereon instead of Jesus Christ, and an ointment wherewith she greased a staff, upon which she galloped through thick and thin, as she pleased. Petronelle was burnt at Kilkenny upon this account.


In the reign of King Edward the Third, 1329, the Irish in Meath and Leinster rebelled, and vanquished the Earl of Ormond, burning 



---

p.13




fourscore English in a church, and committing woeful outrages; at length the citizens of Wexford falling upon them, slew four hundred, the rest being drowned in the water of Slane. At this time Sir Robert Savage, a wealthy knight, dwelt in Ulster, who, to secure himself from the incursions of the Irish, began to fortify his manor-houses with castles and ditches, exhorting his son and heir to do the same, for the benefit of himself and posterity. ‘Father,’ says young Savage, ‘I remember the proverb, Better a castle of bones than, of stones; where I have the strength and courage of men, by the grace of God I will never *encumber* myself with dead walls; my fort shall be the youthful blood of my friends, and where I have room to fight.’ The father in a fume left building, but the neglect of this counsel was the ruin of that and many other English families in Ulster. This Savage having raised forces against the Irish, gave to every man before the fight a stout cup of aqua vitae, wine, or strong ale, and provided plenty of beef, venison, and fowls for their return; which his captains disliking, considering the uncertainty of war, since the enemy might happen to feast upon the same, they being so few against a multitude of Irish, he smiling— ‘Gentlemen,’ said he, ‘you are too full of envy; this world is but an inn, wherein we have no certain interest, but are only tenants at the will of the lord. If it please him to command us hence, as from our lodging, and set other good fellows in our room, what hurt can it be for us to leave them meat for their suppers? Let them stoutly win it and eat it. If they should come to our houses, we could not but welcome them with what the country affords, and therefore much good may it do them with all my heart: however, I have such confidence in your courage and gallantry, that I doubt not but we shall return home safe at night, and banquet merrily upon our own provisions;’ which happened accordingly, for falling upon them, they in a short time cut off three thousand Irish-men, and returned triumphantly home.


In 1394, King Richard the Second being much grieved for the death of his beloved Queen Ann, not able to endure his chambers of state without tears, passed over into Ireland to divert himself, where divers princes renewed their homage to him.


In 1398, the Irish rebelling, Roger Mortimer, Earl of March, the King's lieutenant, was slain, with divers other persons of quality; to revenge which, King Richard again sailed to Ireland, and had several successful skirmishes against them, killing at one time two hundred of the rebels, and many more afterward; and then going to Dublin, he continued there some time, divers lords and princes submitting 



---

p.14




themselves, and were received very courteously by him. During his stay here, he had intelligence that Henry, Duke of Lancaster, his uncle, whom he had lately banished, was returned into England, designing to deprive him of his crown; whereupon he committed the Duke's son, and the Duke of Glocester's son, both then in Ireland, prisoners to the castle of Trim, and then embarking, arrived in Wales, where he found such weak assistance, that at length he fell into his adversary's hands, and was deposed by authority of Parliament, the Duke of Lancaster being admitted to reign in his stead, by the name of Henry the Fourth; in whose second year Sir Stephen Scroop was made lieutenant, who was much exclaimed against by the people, for his former violences and extortions under King Richard; upon which his lady assured him, she would no longer continue with him there, unless he took a solemn oath upon a Bible, not knowingly or willingly to wrong any Christian creature in that kingdom, and to repair all the wrongs he had done, she having made such a vow to Christ, that unless this were performed she could not live with him, without peril of her soul. Her husband consented hereto, and became afterwards as famous for justice, as he had been before infamous for oppression.


In the reign of King Henry the Fifth, 1420, James Butler, Earl of Ormond, being lieutenant, some of the Irish lords making insurrections, the Earl fought with them in the Red Moor of Athy, where (saith my author) the sun being almost down, miraculously stood still for three hours, till the Irish, who were commanded by O'More, and his terrible army, were utterly vanquished, with the loss of a very few English; neither did the bog or quagmire endamage either horse or man of Ormond's party till the feat was accomplished, but continued firm, like other ground.


In King Henry the Sixth's reign, Richard, Duke of York, father to Edward the Fourth, was lieutenant, his second son, George, after Duke of Clarence, being born in the castle of Dublin.


The Earl of Desmond was deputy in Edward the Fourth's time, who speaking disgracefully of the King's marrying the Lady Elizabeth Gray, she caused his government in Ireland to be examined, and for misdemeanors therein, he was condemned and beheaded at Tredagh.


Girald, Earl of Kildare, was deputy in Henry the Seventh's time, to whom Richard Symonds, a subtle priest, applied himself, bringing to him a young lad, his scholar, named Lambert, whom he affirmed to be the son of George, Earl of Clarence, lately escaped out of 



---

p.15




the Tower of London. The youth had been so well tutored, and acted the part of a prince so gracefully, that the Earl of Kildare and 



many others of the nobility espoused his quarrel, and crowned him King in Dublin, with much joy and triumph; and then raising forces, they embarked for England, and landed in Lancashire, but were defeated by King Henry's army, and Lambert taken, but pardoned for life. In 1460, the Duchess of Burgundy raised another spirit or illusion, one Perkin Warbeck, whom she sent into Ireland, assuring the lords that he was the youngest son of King Edward the Fourth, named Richard, who had been strangely preserved from the cruelty of his uncle Crook-back; but he being taken prisoner, confessed the whole imposture.


In King Henry the Eighth's time, the Earl of Kildare was continued deputy, a plain, open-hearted man, very passionate, and soon appeased. Being once in a great rage with his servants, one of his esquires offered Mr. Boyce, a gentleman-retainer, an Irish hobby, upon condition he would just then pluck an hair from the Earl's 



---

p.16




beard. Mr. Boyce took him at his word, and knowing the Earl's good nature, stepped to him, and acquainted him with the business: ‘Well,’ said the Earl, ‘I am content, but if thou pluck above one hair, I shall reach thee a sound box on the ear.’ Being accused before Henry the Seventh for burning the cathedral of Cashel, and many witnesses appearing to justify it, he suddenly confessed the fact, to the wonder and detestation of those present: who admiring how he would come off— ‘By Jesus!’ says he, ‘I would never have done it, had I not been told that the Archbishop was within it.’ Now he being there present, and principal accuser, the King laughed at the plainness of the man, that he should allege that for an excuse, which was the greatest aggravation of his offence: lastly, they summed up all in this article, finally, all Ireland cannot rule this Earl. ‘No?’ quoth the King; ‘then in good faith, he shall rule all Ireland,’ and thereupon constituted him deputy.


In 1521, Thomas Howard, Earl of **Surry** afterwards Duke of Norfolk was made Lord Lieutenant, and the Earl of Kildare was, 



---

p.17




by the contrivance of his enemies, summoned over into England, to answer several accusations against him; and being brought before the council, the proud Cardinal Wolsey, then Lord Chancellor, charged him with several misdemeanors, as holding correspondence with the Irish rebels, especially the Earl of Desmond, his kinsman, who had been treating with the French and Emperor about invading the island, and not seizing him when in his power, with divers other crimes, using these expressions to Kildare, among others: ‘Surely this juggling and false play becomes neither a man of honesty nor honour: had you but lost a horse or a cow, two hundred of your retainers had come at your whistle to rescue the prey, even from the uttermost parts of Ulster; all the Irish in the country must have fled before you; but in pursuing so great an enemy as Desmond, merciful God! how nice, how fearful, how backward have you been. One while he is from home, another time he keeps close home; sometimes he is fled, sometimes on the borders, where you dare not venture. I find, my Lord, there are dreadful bugbears on the borders, which affright the Earl of Kildare— Earl! nay, King of Kildare; for when you please, you can command like an emperor; where you are malicious, the most loyal subjects are accounted Irish enemies, and where you please, an Irish rebel shall pass for a dutiful subject: hearts and hands, lives and fortunes, lie all at your pleasure, and those that do not fawn upon you, and flatter you, dare not presume to come into your presence.’


The, Earl, as well as the lords of the council, were much offended at this odious and abusive discourse, which was usual with the Cardinal, desiring him to name and prove particulars: at length Kildare being out of patience, interrupted him, saying, ‘I find, my Lord, that you are very fit to be the mouth of this board; but, my Lord, those that put these words into your Grace's mouth, had very wide ones themselves, and have long gaped for my ruin, and having no other stuff, have filled their mouths with smoke: what my cousin Desmond hath contrived, I know not; I beshrew his naked heart for holding out so long. But what is this to me? Cannot he conspire, but I must be of his council? Cannot he hide, except I wink? Can he have no friends, but I must be the traitor? This is strange reasoning. You would not see him, say they; when was he within my view? Who stood by when I let him escape? They will swear it, they say: why? because they have my letters. They may lie lewdly against my cousin Desmond, since none dares contradict them; but, for my part, I never thought them to have so much wit or honesty, that I would have ventured the 



---

p.18




life of a good hound upon their secrecy or silence, much less my own. Touching my kingdom, I know not what your Lordship means. If your Grace imagine that a kingdom consists in serving God, obeying my prince, ruling with love, suppressing rebels, and executing justice, I would be glad to be invested with so royal a name; but if you term me King, as repining at the government of my sovereign, conniving at malefactors, or injuring the peaceable, I utterly disclaim that odious title, admiring that your Grace, out of your profound wisdom, seems to appropriate so sacred a name to such wicked actions. But, however, I wish, my Lord, you and I were to change kingdoms but for one month, I doubt not, but in that time I should gather up more crumbs than the revenues of my earldom are worth. But you are well and warm, and continue you so still, but do not upbraid me with such base crimes. I slumber in a hard cabin, while you sleep on a bed of down; I serve the King under the cope of heaven, when you are served at home under a canopy; I drink water out of my iron head-piece, when you drink wine out of golden cups; my horse is trained up for the wars, while your gennet is taught to amble; you are be-graced and be-lorded, you are crept and kneeled unto, when, in the mean time, I can find small regard with the Irish borderers, who are so stout, they will never kneel to me, except I cut off their legs by the knees.’


The council were much pleased at these sharp girds of Kildare against Wolsey, who, rising up in a fury, committed the Earl to prison; but he was afterwards bailed by the Duke of Norfolk, to the Cardinal's great grief, and entertained in his house; during which, the Irish made another insurrection, and the Cardinal again charging Kildare as the fomenter thereof, committed him to the Tower, for which he was much pitied by the Lieutenant and all the court, who loved him heartily. One night, when the Lieutenant and he were playing at shovel-board, a warrant was sent for executing Kildare, at which the Lieutenant fetching a deep sigh, ‘By St. Bride,’ says he, ‘Lieutenant, there is some mad game in that scroll of paper, but let it fall how it will, have at the game.’ When he understood the message, ‘Well,’ said he, ‘pray do me the favour to go to the King, and know certainly whether it be his pleasure.’ The Lieutenant was much afraid of displeasing the Cardinal, yet kindness to his friend prevailing, he posted to the King at midnight, and having admittance, shewed him the warrant. The King, incensed, as he said, at the sauciness of the priest, gave him his signet in token of a countermand; which when the Cardinal understood, he raved and raged in 



---

p.19




such furious language, that the Lieutenant went away, leaving him to mutter the Devil's pater-noster by himself. Shortly after, Wolsey was thrown out of favour, and the Earl restored to his life and estate, and Sir William Skeffington being made deputy of Ireland, carried Kildare along with him.


About this time, the Lieutenant being at dinner, news came that the O'Mores were in arms, and ready to invade the English pale; whereupon the Mayor of Dublin raising forces, marched against them, who dispersing themselves, a party fell upon the carriages, which were weakly guarded, but were so warmly received by a stout young man, named Patrick Fitz-Simmons, that he routed them and cut off two of the rebels' heads. Next morning the Governor's men, who fled from Fitz-Simmons, reported that he run away, and the carriages were lost; whereupon the Governor coming in a rage to the Mayor's tent, cried out that his man Fitz-Simmons was a cowardly traitor, in running away, and losing the carriages. Fitz-Simmons skipping out of the tent in his shirt, with the two heads in his hand— ‘My Lord,’ said he, ‘I am no coward, I stood to my tackling, and when your men gave me the slip, I rescued the carriages, of which these heads are a token,’ throwing them down before him. ‘Sayest thou so?’ cried the Lieutenant; ‘then I cry thee mercy, and I would I had been with thee:’ and so praising and rewarding him, he dismissed him, and soon after the O'Mores retired to their bogs and fastnesses.


In 1532, the Earl of Kildare having several great enemies in Ireland, was again sent for over into England, and charged with furnishing his own forts with artillery out of the castle of Dublin, for which he was committed to prison: he left his son and heir, Thomas Fitz-Gerald, Vice-deputy in his stead; who hearing his father was in custody, the enemies of the Geraldines incited him to a rebellion, thereby to destroy the family of the Geralds: so that Lord Thomas calling a council, his horsemen and servants rushed into the chamber completely armed, for he had been informed that his father was to be put to death, and himself to be seized, and therefore resolved to defend himself. Turning then to the Chancellor, he said, ‘How injuriously soever we have been used, and are thus forced to defend ourselves by arms, since our service and loyalty is misrepresented to our prince, yet let none say hereafter, but we acted like gentlemen and soldiers in using this open hostility, and not treacherously and basely. This sword of state is yours, and not mine; I received it 



---

p.20




with an oath, and have used it to your benefit, and should therefore stain my honour, if I should turn it to your damage or hurt: I have now need of my own sword, for the other only flattereth me with a painted scabbard, but hath indeed a pestilent edge, already bathed in the blood of the Geraldines, and now newly whetted for further destruction; defend yourselves, therefore, from us, as from declared enemies. I am none of King Henry's deputy, I am his mortal foe; I have more mind to conquer than to govern, to meet him in the field, than to serve him as an officer: if all the hearts in England and Ireland, who have cause so to do, would join in this quarrel, as I hope they will, they would soon make him repent his tyranny and cruelty, for which the ages to come may justly register him amongst the most barbarous tyrants, of abominable and hateful memory.’


The Lord Chancellor taking Lord Thomas by the hand, requested him, for the love of God, to hear a few words, and then made a most passionate oration, accompanied with many tears, to dissuade him from this rash enterprise; but all in vain, for Lord Thomas thus proceeded: ‘It is very easy for the sound to give counsel to the sick; if the case were yours, you would be as impatient, it may be, as I: as you require me to honour my prince, so duty binds me to reverence my parents; therefore, he that tyrannically designs to kill my innocent father, and threatens my destruction, I will never acknowledge to be my king; if, as you intimate, I happen to miscarry, I had rather die valiantly, and at liberty, than live under Henry in slavery and bondage.’


With these words delivering up the sword, he flung away like a madman, and assembling all the Irish he could get together, they committed several outrages and mischiefs, and seizing upon **Alen, Archbishop of Dublin**, his old enemy, his followers murdered him. At length, after many skirmishes, he was, by the Lord-deputy Gray, persuaded to submit himself to the king; and going to England, was committed to the Tower, orders being sent to Ireland for apprehending his five uncles, who were all seized, namely, James, Walter, Oliver, John, and Richard Fitz-Gerald, though two of them always opposed their nephew's proceedings; but King Henry being incensed against them, because he was informed, that as long as any Geraldine breathed in the country, he could never conquer it, resolved to be rid of them all. Thus were the five brethren sailing to England, some comforting themselves with the King's mercy, and others with their own innocency, when Richard **Fitzgerald**, who was 



---

p.21




more bookish than the rest, chanced to ask the master what the name of his ship was, who answering it was called The Cow, ‘Nay, then, good brethren,’ quoth he, ‘I utterly despair of our return to Ireland; for I remember I have heard an old prophecy, that five brethren to an earl should be carried into England in the belly of a cow, and never come back again.’ At which words the rest began to howl and lament in a grievous manner, which seemed very strange to the spectators, that five such valiant gentlemen should be so disturbed at an old prophecy. However, what he foretold proved true, for they no sooner arrived, but Thomas Fitz-Gerald was executed at Tower Hill, and the five brethren hanged and quartered at Tyburn; the old Earl of Kildare died for grief in the Tower, and Gerald, the younger brother of Thomas, flying out of Ireland, travelled many foreign countries, and at length died at Naples. Soon after, the Lord-deputy Gray was beheaded on Tower Hill, being accused for holding correspondence with the Fitz-Geralds, though many thought him innocent thereof.


In the three and thirtieth of **King Henry the Eighth, the title of King of Ireland** was by a parliament settled upon him and his successors for ever, whereas before they were only called Lords of Ireland.


During the short reigns of King Edward the Sixth and Queen Mary, our chronicles relate little of any transactions in Ireland.


In 1566, the seventh of Queen Elizabeth, for the great fame of her wisdom, **Donald M'Carti More**, a great potentate of Ireland, came and delivered up into her hands all his ample territories, which she restored to him again, and in requital created him Earl of Glencare, giving him many presents, and paying the expense of his voyage.


In 1570, O'Brian, Earl of Thomond, not brooking the severe government of Edward Fitton, president of Connaught, entered into a conspiracy, which being ready to break forth, was strangely discovered; for the day before they meant to take up arms, Fitton knowing nothing of it, sent word to the Earl in a friendly manner, that the next day he and some of his friends would come and dine with him. The Earl having a guilty conscience, thought his designs were revealed, and that Fitton would rather come as an enemy than a guest; whereupon he presently fled to France, where he confessed the whole to Queen Elizabeth's ambassador, by whose intercession he was afterwards pardoned and restored. Four years after, Sir Henry 



---

p.22




Sidney, Lord Deputy, going into Ulster, several Irish grandees submitted themselves, and were received into favour.


In 1573, the famous rebel, Gerald Fitz-Gerald, the eleventh Earl of Desmond of this family, having a long time escaped the English in his lurking-places, was now discovered by a common soldier in a poor cottage, and there slain; his head was sent into England, and set upon London Bridge. This end had this great lord, who possessed whole countries, and had at least five hundred gentlemen of his own name and race, all whom, and his own life also, he lost within three years, very few of his family being left alive: and this disaster he fell into by being traitorous to his prince, at the instigation of certain Popish priests, of whom the chief was one Nicholas Sanders, an Englishman, who at the same time died miserably of famine; for running mad upon his ill success, he wandered up and down the mountains, finding nothing to sustain him.


In 1585, the **Bourks** raised a rebellion, the Irish declaring they would have one of that family rule over them, or some other Lord out of Spain; neither could they be quieted till the president of Connaught's



---

p.23




brother, following them into the woods, drove away five thousand head of their cattle, so that after forty days, half starved, they came forth and submitted themselves: but the president understanding, that about this time two thousand Scotch islanders were landed and joined with the Irish, and ready to break into Connaught, he musters up his men to give them battle; but they flying to bogs and woods, he retires back, as though in fear, thereby to draw them to the firm ground, and then set upon them with his whole force, slaying three thousand, which was all their number, except fourscore; by which notable victory, the insolent attempts of the Scotch islanders were wholly crushed.


In 1590, Hugh Cavelock, so called because he had been so long kept in fetters, the son of Shane O'Neill, accused Hugh, Earl of Tyrone, for holding correspondence with the Spaniards in 1588, who, to prevent the accusation, took a cord, and with his own hands strangled Hugh; for which being sent for over, he was pardoned, upon condition of future obedience, and reducing the country to civility. After this Mac-Mahon, a potentate of Ireland, compelled those under him to pay tribute, whereupon the deputy caused him to be taken and tried by a jury of common soldiers, and then to be hanged up, dividing his lands between some of the Mahons and the English. Then Brian O'Roch, fearing he should be served in the same manner, raised a rebellion, and being defeated, fled into Scotland, but at the Queen's request was delivered up, and was arraigned at Westminster for dragging the Queen's picture at an horse-tail, and for giving the Spaniards entertainment; which being told him by an interpreter, for he could speak no English, he said, ‘He would not be tried, unless the Queen herself were judge:’ but being informed this was the law, he only said, ‘If it must be so, it must be so;’ and was condemned and executed at Tyburn, which he valued as little as if all had been in jest.


In 1596, Tyrone, with considerable forces, raised a rebellion, and was proclaimed traitor; after which he gave the English a great defeat; whereupon all Ulster, Munster, and Connaught were in arms against the English: at length the Earl of Essex was sent against him, who instead of fighting, made a truce with him; but afterwards the English so prevailed, that Tyrone, finding his condition desperate, resolved to throw himself upon the Queen's mercy without conditions: hereupon being admitted to the presence of the Deputy, at the very entry of the room he fell on his knees, begging



---

p.24




pardon for his great fault against God, and a most bountiful Prince. The next day the Deputy took him along with him to Dublin, intending to send him to England, but before he could come thither the Queen died.


In King, James's reign, Tyrone and all his adherents absolutely submitted to his Majesty's pleasure; who, by an act of oblivion, published by proclamation under the great seal, did forgive and utterly extinguish all offences against the crown, and all particular trespasses between subject and subject, to all who would come into the justice of assize by such a day, and claim the benefit thereof; by which all the Irishry, who in former times were generally left under the tyranny of their lords and chieftains, and had no defence nor justice from the crown, were now received into his Majesty's immediate protection. The public peace being thus established, public justice was next settled by dividing all Ireland into shires, and erecting circuits in every province, and governing all things therein according to the laws of England, and lastly, the estates and possessions of the English as well as Irish, were settled throughout the kingdom, to the great comfort and security of all men, and thereupon ensued the calmest and most universal peace for above forty years that ever was seen in Ireland.


* Copied by permission of James Bindley, Esq. from a scarce book in his library, entitled La Spada d'Honore, &c., da Primo Damaschino, 4to. Roma, 1680, which contains the only portrait hitherto discovered of the Earl of Tyrone.




---

p.25


Yet the foundation thereof was not so strongly laid, but it received a shake by the first storm that threatened England: for being engaged in a war with France and Spain about the beginning of the reign of King Charles the First, 1627, there was occasion for sending some additional forces into Ireland for the security thereof, upon which a proposition was made to the chief of the Irish nation, by the **Lord Deputy Falkland**, for contributing a competent sum of money toward the maintenance of those forces, to be established by the way of a standing army, to which they would not condescend without a toleration of religion first obtained, though Archbishop Usher, then Lord Primate of all Ireland, in a great assembly of Irish and English at Dublin, used many cogent arguments to persuade them to it, and among others, ‘That their being Romanists would not exempt them the more from the danger of a common enemy, as they might conjecture from the answer which the Duke of Medina Sidonia gave in this case in 1588: That his sword knew no difference between a catholic and an heretic, but that he came to make way for his master.’ Divers other notable instances he gave, whereby he prophetically intimated what afterward fell upon Ireland in 1641, when above one hundred and fifty thousand British planters were most inhumanly massacred by the outrageous Irish, without the least provocation given to perpetrate such wicked and unparallelled acts of barbarism.


But before I proceed to give an account of that dismal tragedy, I will make some brief deduction of some former transactions in this kingdom, and discover the beginnings and progress of the general rebellion in 1641.


Ireland, for near five hundred years, has continued under the sovereignty of the crown of England, and presently after its first conquest was planted with English colonies, long since worn out, or generally become Irish, and therefore hath in this last age been supplied with great numbers of people from England and Scotland to settle there. The Irish, as we have related, want not many fabulous inventions to magnify the original of their nation; but whether the Scythians, Gauls, Africans, Goths, or some other eastern nations that anciently inhabited Spain came and sat down there, is very uncertain; yet their manners, customs, words, names, and still retained ceremonies, seem very much to demonstrate their first rise from some of those people; for it may be conjectured, that as the eastern parts of Ireland bordering upon England were first planted by the old Britons, several of their words being still in use; and as the northern parts were first inhabited by the Scythians, from whom it was called Scyteland or 



---

p.26




Scotland; so the south and more western parts thereof were peopled by the maritime parts of Spain, being the next continent, not by the present Spanish nation, who are now a different mixture of people, but it is probable by the Gauls, who anciently inhabited all the seacoasts of Spain.


The whole kingdom of Ireland was divided into five principal chieftains, or commanders, that is, **Macmorough** of Leinster, **Mac-cartye** of Munster, **O'Neal** of Ulster, **O'Connor** of Connaught, and **O'Malaghlin** of Meath, who were called kings; but as they had neither hereditary right nor lawful election, so they were neither anointed nor crowned, but made their way by the sword, and were invested with certain barbarous ceremonies and ruled with all manner of tyranny, the people being absolute slaves to all the savage customs practised under their dominion, which continued till the reign of Henry the Second, King of England, in whose time the undertaking for the conquest of Ireland was very successful, being made by most powerful, though private adventurers, upon this occasion.


**Dermod Macmorough**, King of Leinster, being forced to fly his country by the Kings of Connaught and Meath, repaired to King Henry, then personally attending his wars in France, and earnestly implored his aid, for recovering his territories, most injuriously, as he pretended, taken from him. The King refused to embark in the quarrel, yet graciously recommended the justice of his cause to all his loving subjects, and assured them, that whoever would assist Dermod, should have free liberty to transport their forces, and be held to do very acceptable service therein; whereupon Strongbow, Earl of Pembroke, resolved, as a private adventurer, to aid him with his utmost power, and Dermod coming to him at Bristol, an agreement was made, that Strongbow should marry Dermod's only daughter, Eva, and after his death, should enjoy the kingdom of Leinster, of which she was heiress; after which, Strongbow engaging some other private gentlemen in the design, they got together a party of 490 men, which they transported in three ships to Wexford, in Ireland, and there joining with some of Dermod's forces, they not only reduced that town, but soon after possessed themselves of all the maritime parts of Leinster.


King Henry, upon the news of the prosperous reducement of so large a territory, by such inconsiderable forces, desirous to share with his subjects, both in the profit and glory of so great an action, resolved to make an expedition thither in person; when he arrived there, the presence of so great a Prince had such a strange influence on the minds of the rude savage natives, that, partly by the power of his arms, 



---

p.27




and partly by his grace and favour, in receiving them upon their feigned submissions, he soon subdued this barbarous divided people. This happened in 1172. The King found the land good and nourishing, with plenty of all kind of provisions, the soil rich and fertile, the air sweet and temperate, the havens safe and commodious, several towns and villages scattered up and down in several parts of the country, but the buildings so mean and contemptible, that when the King arrived at Dublin, their chief city, he found no place for entertainment; but was obliged to set up a long house made of smoothed wattles, after the manner of that country, and therein kept his Christmas; all their forts, castles, stately buildings, and other edifices, were afterwards erected by the English, except some of their maritime towns, which were built by the Easterlings, which formerly inhabited there; he found, likewise, several monuments of piety, and other remarkable testimonies, that the Christian religion had been planted there about 400 years after Christ, by some holy and learned men from foreign parts, as Sedulius, **Paladius**, and Patricius the famous Irish saint, born at Kirkpatrick, near Glasgow, in Scotland, who came hither out of a pious desire to propagate the gospel, and for the conversion of a barbarous people, instructing them in the principles of the Christian faith; and St. Patricius, with his unwearied endeavours, had such great success, that some authors write, the church of Armagh was by him erected into an episcopal see, 350 bishops consecrated, great numbers of clergymen instituted, who (notwithstanding the notorious ignorance and debauchery of the common people) being most monks by profession, and of strict and severe lives, were so admired by other nations in those rude times, that in respect to them Ireland was termed the Isle of Saints: but so quickly did piety decay, that this name was lost, yea, the very prints and characters of devotion obliterated, even among the clergy themselves; and so filthy and depraved were the manners of the common people, that when King Henry the Second designed to go thither, he obtained a bull of Pope Adrian to go over and conquer Ireland, and reduce the beastly inhabitants into the way of truth; and the King at his arrival found them so indeed, being generally void of all manner of civility, governed by no settled laws, living like beasts, biting and devouring one another, without all rules, customs, or reasonable constitutions, either for regulation of property, or against open force and violence, most notorious murders, rapes, robberies, and other acts of inhumanity and barbarism, raging without control or punishment; whereupon he, without any manner of scruple, or further inquisition into particular titles, resolving,



---

p.28




it seems, to make good by the sword the Pope's donation, made a general seizure of all the lands of the whole kingdom, and without further ceremony took them into his own hands; and the more speedily to introduce religion and civility, and accomplish the work so gloriously begun, the King called a great council at **Lissemore**, where he caused the laws of England to be received and settled in Ireland, which he united to the imperial crown of England, and distributed the whole land among his English officers and soldiers.


A learned author, in his observations upon the causes of the sudden reducing of Ireland, gives this as one reason thereof, that a synod or council of the clergy being assembled at Armagh, and that point fully debated, it was unanimously agreed, ‘That the sins of the people, and particularly their buying of Englishmen from pirates, and detaining them under most miserable bondage, was one great occasion of the heavy judgment fallen upon the nation; and that Heaven, by way of just retaliation, had now suffered them to be reduced by the English to the same slavery:’ whereupon they ordered all the English in captivity throughout the land to be released. If so heavy a judgment fell upon them for the hard usage of some few English, what expiation can they now pretend to make, for the effusion of so much innocent blood in 1641, when in two years time above three hundred thousand Protestants were cruelly murdered in cold blood?


King John came into Ireland in his minority to little purpose; but upon a second general defection in the twelfth year of his reign, he made a second expedition thither, and built several forts and strong castles, many of which remain to this day: he erected courts of judicature, and settled the English colonies and civil government. King Richard II. upon the same occasion, made two voyages thither in person; but both these Princes, to save English blood and treasure, and having likewise troubles at home, were both content to suffer themselves to be abused by the feigned submissions of the Irish, who finding their present inability to resist such great forces, came from the farthest parts of the kingdom to submit to their mercy: and yet some have observed, that they left not one true subject more behind them, than they found at their first arrival. However, by the presence of these Princes, and the care of the governors set over them, the first adventurers, and others of the English nation, drove the Irish out of all the habitable parts of the country, especially those on the seacoasts, and afterwards grew so potent, that they entertained private animosities against each other; yea, their dissensions were so 



---

p.29




great, that at length they drew in the Irish, whom they had driven up into the mountains, and ever esteemed their most deadly enemies, to take part in their quarrels, shamelessly using their assistance, for the enlargement of their own private territories, against their own compatriots and joint tenants in that good land. The Irish, glad of the occasion, fomented these broils among the English, whom they mortally hated to the utmost; and notwithstanding the great privileges they enjoyed by their protection, always shewed the utmost aversion to them and their laws; insomuch, that besides the five Irish Kings and their families aforementioned, the rest of that nation were always reckoned aliens and absolute enemies; so that from Henry II. to Henry VIII. none were admitted to be subjects, or received any benefit by the English laws, but such as purchased charters of denization; and it was no capital offence to kill any of them, since the laws did neither protect their lives nor revenge their deaths, so that living in the bogs, and woods on the mountains, they upon all occasions declared their malice and hatred against the English colonies planted near them.


However, the English were still owners and possessors of the
 kingdom, and kept themselves almost entire for the first hundred
 years after their arrival, not suffering the Irish to live
 promiscuously among them, but by an high hand kept them in due
 obedience and subjection to the crown of England; and when they
 afterwards grew more careless, and intermingled among them,
 whereby the English learnt their beastly manners and customs,
 there were very severe laws made against them; so that in the
 reign of King Edward III. it was declared high treason to marry
 with the Irish, or to let them nurse their children; and to use
 the Irish language, names, or apparel, was made a **premunire**, that is, to lose their estates, and be perpetually imprisoned: and though, in after ages, the English endeavoured to civilize the people, and introduce the English laws, language, habit, and customs among them, thereby to reduce them to civility, yet such was their rough, rebellious disposition, and their implacable malice to the English, that nothing could attemper or reduce them to any tolerable patience, or persuade them to live peaceably among them; so that in all times, as well when they were admitted into the condition of subjects, as while they were esteemed and treated as enemies, they took all advantages most perfidiously to rise up and imbrue their hands in the blood of their English neighbours; and Ireland hath long continued a true **Aceldama**, or field of blood, and dismal sepulchre for the English nation; for after their intermixing 



---

p.30




with the Irish, they barbarously degenerated into their manners and customs, insomuch that by their intestine broils, and the mischievous attempts of the Irish upon them, the English, from their first access to Ireland, till the reign of Queen Elizabeth, being above 380 years, had no settled peace nor comfortable subsistence amongst them, but were in such perpetual troubles, and so overworn with misery, that they could scarce survive the universal calamity that overspread the face of the whole kingdom.


Whereupon that excellent Queen, in the beginning of her reign, out of her pious intentions and affections to her people, took care to redress these disorders, and sending over prudent and religious governors, made a great reformation, by many good laws enacted against the barbarous customs of the Irish, and for the execution of justice throughout the country, which were reduced into shires, and sheriffs and other ministers of justice placed in them; and the high powers, usurpations, and extortions of the Irish were restrained, and several destructive customs repressed: the two presidential courts of Munster and Connaught were then instituted, and special order taken for free schools to be erected for educating youth throughout the kingdom; but these and other courses for the advancement of true religion and civility, were highly disagreeable to the loose humours of the natives, who pretended the English government was insupportable, and began desperately to struggle for their liberty. Several plots were laid, some by those who were of the old English by extraction, and divers rebellions and petty revolts happened during that Queen's reign, which she timely suppressed either by force or favour, often renewing her kindness to them upon their continued provocations, restoring some rebellious lords to their forfeited estates and commands, and bestowing new titles of honour upon others: but all was in vain, the malignant impressions of irreligion and barbarism, transmitted from their ancestors, either by infusion or natural generation, had so irrefragably stiffened their necks, and hardened their hearts, that they still retained all their wicked customs and inclinations, without change in their affections or manners, having their eyes inflamed, and their minds enraged with rancour and revenge against the English nation, breathing forth nothing but their ruin, destruction, and utter extirpation, and resolving at once to disburthen the whole kingdom and their posterity of them, and deliver themselves from their subjection to the crown of England. A desperate rebellion was raised by the Earl of Tyrone, who had received titles of honour from the Queen, a command of horse and foot, great proportions of land, and other



---

p.31




favours, which he now ingratefully cancelled, engaging most of the Irish, and some English degenerate families, in his treacherous designs, and likewise calling in some foreign forces to his assistance. The Queen, perceiving that no obligations would secure the Irish loyalty, resolved to reduce them by force, which was done in a short time, and Tyrone brought upon his knees, though not without the expense of much English blood, above a million of money, the country miserably wasted, and a general desolation and famine overspreading the land.


King James, at his first coming to the crown, conceiving that the powerful conjunction of England and Scotland would overcome the Irish, and contain them in their due obedience, resolved not to take any advantage of these forfeitures and great confiscations, which he was most justly entitled to by Tyrone's rebellion, but restored all the natives to the entire possession of their own lands; after which, for six years the country was indifferent quiet, when Tyrone made a second insurrection, and drew in the whole province of Ulster, who



---

p.32




were absolutely at his devotion, to join with him; but his plot failed him, for not finding himself in a capacity to resist the English forces, he fled into Spain, promising speedily to return with foreign succours; but by the care of the government, this designed rebellion was quelled in the beginning, and Tyrone never came back: after which, King James being justly provoked by the high ingratitude of these traitors, caused their persons to be attainted, and their lands to be seized, and distributed them among British undertakers, many of whom came over and settled in the province of Ulster with their families, and built several good towns and castles in divers parts of the country, whereby much civility was introduced, and the whole kingdom began to flourish in costly buildings and all manner of improvements, and the very Irish seemed to be much satisfied with the peace and tranquillity they enjoyed.


King Charles the First was no less indulgent to them, for in 1640, upon the complaint and remonstrance sent him from both Houses of Parliament, then sitting at Dublin, representing the heavy pressures they had suffered under the government of the Earl of Strafford, he made present provision for their redress, constituting Sir William Parsons and Sir John Borlace Lords Justices of that kingdom, who declared against the late proceedings, as varying from the common law, and abated the subsidy that was given in the Earl of Strafford's time, from 40,000 to 12,000£ and soon after Robert Sidney, Earl of Leicester, was made Lord Lieutenant. The Roman Catholics likewise privately enjoyed the free exercise of their religion, and by the over-great indulgence of the late governors, had their titular arch-bishops, bishops, vicars-general, provincial consistories, deans, abbots, priors and nuns, who, without control, exercised a voluntary jurisdiction over them: they had also their priests, Jesuits, and friars, who came in great numbers from foreign parts, and without restraint settled themselves in all the chief towns, villages, noblemen and gentlemen's houses, and none of the laws were put in execution against them; and the ancient animosities between the two nations seemed to be buried, so that they lived together in peace for forty years, marriages and all other endearments of friendship passing between them: and the Irish lords and gentlemen found such advantage by the English commerce and cohabitation in the great improvement of their lands and native commodities, beyond what they ever formerly enjoyed, that Phelim O'Neal, and many other principal leaders in the succeeding rebellion, had not long before turned their Irish tenants out of their lands, and exposed them to starve



---

p.33




upon the mountains, and took the English for their tenants, who gave them greater rents, and payed them more certainly. These and many other symptoms of a nourishing kingdom seemed to declare, that the peace and tranquillity of the nation was fully settled, and humanly probable so to continue; and the Irish army raised for the invasion of Scotland was peaceably disbanded, and no noise of war remained in the coasts.


In this great calm the English continued in a most deep security, when on a sudden the Irish Papists raised a rebellion so execrable in itself, so odious to God and the whole world, as no age, kingdom, nor people can parallel the horrid cruelties and abominable murders that were without number, as well as without mercy, committed upon the British inhabitants throughout the land, of what sex, age, or condition soever, which was long before presaged by some discerning persons, particularly by the excellent, learned, and religious Archbishop Usher, of Armagh, who, amongst many other extraordinary gifts and graces wherewith he was endowed, had a wonderful spirit of prophecy, from which, among many other things, he foretold this bloody rebellion forty years before it came to pass, in a sermon preached at Dublin in 1601, where, from Ezekiel iv. 6, discoursing concerning the prophets bearing the iniquity of Judah forty days, the Lord therein appointing a day for a year, he made this direct application in relation to the connivance at Popery at that time: ‘From this year,’ says he, ‘will I reckon the sin of Ireland, that those whom you now embrace, shall be your ruin, and you shall bear your iniquity;’ which prediction proved exactly true, for from that time, 1601, to 1641, was just forty years. It is observed, that the Irish have naturally a dull and deep reservedness, which makes them carry on their business with much silence and secrecy; but yet it is admirable to consider how this mischievous plot, which was generally to be acted by several persons in divers places at the same time, should, without noise, be brought to the very point of execution, without any notice or intimation given to any two of that huge multitude of persons who were designed to be sacrificed in it, there not being any certain discovery made of it till October 22d, which happened in the manner following:


Owen O'Conolly, a gentleman of a mere Irish family, but had long lived among the English, being a servant to Sir John Clotworthy, and trained up in the Protestant religion, came to the Lord Justice Parsons about nine o'clock that evening, and gave an account of a wicked and damnable plot, contrived by the Irish Papists, for seizing



---

p.34




the castle of Dublin the very next day, with all the arms and ammunition therein; and at the same hour all other forts and magazines of arms in the kingdom: and that all the Protestants and English who would not join with them, should be cut off, and thereby the Papists would be possessed of the government and kingdom at the same instant. Upon this discovery, the Lords Justices and council caused recruits to be put into the castle, and the city to be guarded, and then endeavoured to seize the traitors, many of whom came into the city that night; and Hugh Mac-Mahon, Esq. grandson to the rebel Tyrone, and the Lord Maguire, two of the principal conspirators, were made prisoners; but several others of the chief escaped that night: so that only thirty of the most inconsiderable were taken, the great ones having too many friends in the city, who furthered their escape. Mac-Mahon being examined before the council, without much difficulty confessed the plot, resolutely telling them, ‘That on that very day, October 23, 1641, all the forts and strong places in Ireland would be taken; that he, with the Lord Maguire, Hugh Birne, Captain Brien O'Neill, and several other Irish gentlemen, were come up expressly to surprise the castle of Dublin; that twenty men out of each county were to be there to join with them; that all the Popish lords and gentlemen in the kingdom were engaged in this plot; that what was that day to be done in other parts of the country, was so far advanced by that time, as it was impossible for the wit of man to prevent it:’ and added, ‘that it was true they had him now in their power, and might use him how they pleased, but he was sure he should be revenged.’


The next day news arrived that the Irish were risen in the province of Ulster, plundering, burning, and massacring the poor English; and the rebellion appeared to be general over all the northern part of the kingdom; and every hour people arrived at Dublin, like Job's messengers, telling the story of their own sufferings, and the fearful murders of the Protestants in all parts from whence they came. The rebels grew stronger every day, and by the latter end of October had got possession of all the towns, forts, castles, and gentlemen's houses in seven whole counties, and half the county of Down, except Londonderry, Coleraine, and the town and castle of **Inniskillen**. This impetuous torrent of success seemed to proceed from the great security and confidence the English had in the Irish, with whom they lived peaceably and quietly, and to whom they had not given the least provocation; so that in the northern counties they were suddenly swallowed up and over-run, before they could make any manner of



---

p.35




resistance; for most of the English having either Irish tenants, servants, landlords, or familiar neighbours, so soon as the country began to rise about them, many fled to them for preservation, and with great confidence put their lives, wives, children, and all they had into their power; but these generally either betrayed them into the hands of other rebels, or most perfidiously murdered them with their own hands.


The priests had now influenced the Irish with bloody maxims, and the day before the horrid massacre began, they gave the people a dismission at mass, with full liberty to go out and take possession of all their lands, which they pretended were unjustly detained from them by the English, assuring them, ‘That it was a mortal sin to give any manner of relief or protection to the Protestants, and that they ought to spare neither man, woman, nor child; that they might lawfully strip, rob, and despoil them of all their goods and chattels; that the Protestants were worse than dogs, for they were devils, and worshipped the devil, and that the killing of such was an excellent preservative against the pains of purgatory, since the bodies of such Catholics as should die in this quarrel would not be cold before their souls should ascend up to heaven, without touching at purgatory;’ which cursed doctrine caused some of these murdering villains to boast, that if they should die presently, they were certain of going straight to heaven.


Having thus received the watchword from their priests, both as to time and place, they rose up, actuated as it were by the same spirit in several places, at one and the same time, murdering and stripping some, and expelling others out of their habitations: all bonds of faith and friendship were now broken, the Irish landlords made a prey of their English tenants, Irish tenants and servants made a sacrifice of their English landlords and masters; one neighbour was cruelly murdered by another, yea, the very Irish children stripped and killed the English children; and it was esteemed a meritorious work in any of them, that could by any means and ways whatsoever bring an Englishman to slaughter. The English, in the mean time, though in some churches and castles they made a very gallant defence with small parties, yet did not draw together in any considerable body, so as to withstand the numerous forces of the rebels: so that generally every man striving the best he could to secure his own family, goods, and chattels, gave their enemies opportunity to destroy them all; which they acted with great delight, to satiate their ancient implacable malice, declaring, ‘That it did them a great deal of good to wash



---

p.36




their hands in the Protestants' blood;’ and so it appeared, by the examination of several English persons upon oath, who gave the following account of some of their most notorious cruelties, and barbarous murders.


That in the county of Fermanagh, multitudes were killed in cold blood, some at plough, others as they sat peaceably in their own houses, or travelling on the way, without any manner of provocation. At Lisgool Castle, above 150 men, women, and children, were burnt or smothered, the rebels having set it on fire. In the castle of Moneah ninety Protestants were murdered; and in the castle of Tullah, which was delivered upon promise of fair quarters, they first stripped and then murdered them all without mercy. At Lisnaskea they hanged and killed above 100 Scots: this county was very well planted by the British undertakers, but all of them and their tenants, in a very short space, were in a most horrible manner destroyed or banished from their habitations. They compelled one Middleton to hear mass, and to swear never to alter from it, and immediately after caused him, his wife, and children, to be hanged up, and 100 persons more in that town. There were a thousand men, women, and children carried out at several times, and unmercifully drowned at Portnedown bridge, which was broken in the midst, and 4000 more in several parts of that country, the rebels thrusting them into the river with their swords and pikes; and if any endeavoured to swim, they knocked them on the head, or shot them: among others, one Mrs. Campbell being forcibly brought by them to the river, and finding no means to escape their fury, suddenly clasped her arms about one of the chief rebels that was most forward to thrust her into the water, and carried him to the bottom with her, and so they were both drowned together.
They burnt the cathedral of Armagh, and murdered five hundred persons there; and forty-eight families were murdered by order of Sir Phelim O'Neill, who had remained protected by him three quarters of
a year before. John Cander being told by a rebel that he would not kill him till he had said his prayers, the poor man was no sooner on his knees, but he instantly cut off his head. Some of the villains, when the Protestants desired to make their prayers before their death, told them, ‘That they should bequeath their souls to the devil, and that they need not pray, for their souls were with the devil already;’ and with these words in their mouth, would slaughter and put them to death. Others they buried alive, and some were twice or thrice hanged up, and others wounded, and left half dead, crying out lamentably for some to come and dispatch them out of their miseries,



---

p.37




by killing them. At Clownis, in the county of Fermanagh, seventeen persons being hanged till they were half dead, were cast together into a pit, and covered with a little earth, sending forth most lamentable groans for a great while after; and among them four or five young children, the youngest of whom, not fully dead, put forth the hand, crying, ‘Mammy, mammy,’ to the murdered mother, but was without mercy buried alive by these miscreants. Some they grievously wounded, and then hung them up upon tenterhooks: others were drawn with ropes about their necks through woods and bogs, and hanged up, and taken down again several times, to make them confess their money. These inhuman monsters exercised horrid cruelty on the female sex, whom they neither pitied nor spared, hanging up several women great with child, and then ripped up their bellies, letting the little infants fall out, and using such barbarous, beastly actions towards them, as are unfit to be related. At Kinnard, the rebels sent abroad their children in troops, armed with long wattles and whips, wherewith to beat the murdered bodies of men about their nudities, until they beat, or rather thresh them off; and for this villainous service were received with great joy by their parents: and if any woman were found dead, lying with her face downward, they would turn them on their backs, and in great numbers the Irish would resort to look on them, censuring and abusing them with all manner of filthiness. In Sligo thirty Protestants, men and women, were murdered in the jail, after which the villains placed some of the dead bodies of the men, naked, upon the bodies of the women; in which posture they continued to be seen by the Irish of the town next morning, who much delighted and rejoiced in these inhuman actions: and they that came to bury the prisoners, stood up to the mid-leg in the blood and brains of those that were so murdered; after which the river of Sligo, which used to abound in fish, afforded none at all for a long time, though the friars, in their white habits, went in solemn procession, and threw holy water therein.


It would be almost endless to give a particular account of all the detestable cruelties and murders acted by these incarnate devils upon the innocent English, of whom they destroyed near 300,000 in a few months; being chiefly animated thereto by their villainous priests, upon the account of their religion; and therefore they often declared their despight to the Bible, as being directly contrary to their cursed principles and practices. In one place they burnt two English Bibles, saying, *It was hell-fire they burnt.* They laid another in a puddle of water, and then stamping on it, said, ‘A plague on it, this Bible



---

p.38




hath bred all the quarrel.’ A rebel persuaded a man and his wife to join with them in the massacre, who protested, that rather than they would forsake their religion, they would die upon the sword's point; he would then have had the woman burn her Bible, but she refused, saying, she would rather die than do it; whereupon they were both cruelly murdered. They murdered Mr. Bingham, a famous minister, and cutting off his head, put a gag in his mouth, and laving the leaf of a Bible before him, bid him preach, saying, his mouth was open, and wide enough.


During these horrid barbarities, there were several indications of divine displeasure apparent in divers places, the truth of which was sworn to, and affirmed by witnesses of credit and reputation: as in the province of Munster, near the silver works, where, while the rebels were massacring a great number of Protestant men, women, and children on the Lord's-day afternoon, a most loud and dreadful noise, and storm of thunder, lightning, wind, hailstones, and rain happened, though it was fair all the day before; which much affrighted the murderers themselves, who confessed it to be a sign of God's anger against them for their bloody cruelty. At Portnedown Bridge, where so many thousand Protestants were drowned, the remaining inhabitants were so terrified with the noise of spirits and visions for revenge, that they durst not continue thereabout; and some of the rebels themselves said to others, that the blood of some of those that were knocked on the head, and afterward drowned in this river, remained on the bridge, and could not be washed away: there appeared sometimes men, sometimes women, breast high in the river, with hands lifted up, crying out with fearful shrieks and voices, ‘Revenge! revenge! revenge!’ and it was not long ere divine justice overtook them; for many thousands of the most notorious murderers perished by the sword and plague that followed it; so that it was computed that in a few years scarce any of these miscreants remained alive, but were sent to their own place, to give an account of their tremendous brutalities.


The King having made a truce with the Scots, who were entered with an army into England to demand the redress of their grievances, and the forces on both sides being disbanded, he made a journey into Scotland in the beginning of August, 1641, and continued there till the latter end of October, when this horrid rebellion happened. Owen O'Conolly, the first discoverer of the plot, brought the first letters to London, and received as a reward 500£ in money, and an annuity of 200£ a year; and presently the Parliament provided for the relief of Ireland, and the lords of the council, and the Lords Justices there,



---

p.39




had, with the arms that were in Dublin, armed many well-affected gentlemen, and several active commanders were sent out of the city, to defend the adjoining places from the approach of the rebels; at which time the Parliament sent over 20,000£ for a present supply, but could not relieve them with any forces till December following, when Sir Simon Harcourt arrived with seasonable supplies of men and money, and raised the siege of Drogheda, which had been much straitened by Sir Phelim O'Neill and the rebels; and the English recovered Dundalk, Newry, and several other towns and castles out of their hands.


But though the rebellion broke out in October 23d, yet the King, who was now returned from Scotland, did not proclaim them rebels till January 1st following, and then gave strict command that only forty proclamations should be printed, and that none of them should be published without the King s express order, which the Parliament, among other things, afterwards taxed him with; who replied thereto, that he was unwilling to make the Irish desperate, and utterly undo his Protestant subjects, who were then too weak to withstand so potent a rebellion; and that the Lords Justices of Ireland required only twenty, as many of themselves well knew: yet this proceeding unhappily increased the jealousies that began to arise between the King and his English Parliament, because it was publicly discoursed that it had not been done at all, but that some worthy Protestant Lords had earnestly advised him to proclaim them speedily, that a better course might be taken against them, and to wash off that foul stain from himself, by prosecuting severely those wicked villains, who reported *everywhere*, ‘That they had authority from the King to seize upon the holds of the English Protestants; that they were the Queen's soldiers, and rose to maintain the King's prerogative against the puritan Parliament of England; that they told the poor Protestants it was for no purpose to fly for safety into England, for that kingdom would be as much distressed as theirs; and that the King intended to forsake his Parliament in England, and make war against them, and that then they would come over (having done their work in Ireland), and help the King against his English Parliament.’ The Lords therefore advised him by all means to purge himself of these accusations, than which there could not be greater on earth.


Soon after the Earl of Leicester was made Lord Lieutenant of Ireland, the Earl of Strafford being beheaded some time before at Tower Hill: but the relief of that bleeding kingdom was much obstructed by the wide breaches which daily happened between the King and the



---

p.40




Parliament, particularly upon his going, January 4th, attended with 300 armed gentlemen, into the House of Commons, and demanding five members to be delivered him, which the Parliament declared to be ‘An high breach of their privileges, a great scandal to the King and his government, a seditious act, manifestly tending to the subversion of the peace, and an injury and dishonour to the said members, there being no legal charge or accusation against them; and that there could be no vindication of those privileges, unless his Majesty would discover the names of those who advised him to such unlawful courses.’ After this, the Parliament considered of a bill for pressing soldiers to be sent out of Scotland to Ireland, as being near; but the King excepted against it while it lay in the House of Lords, as a diminution to his prerogative; whereupon the Parliament, in their petition to him, asserted, ‘That the King, by taking notice of a bill while in a debate in the House of Lords, had broken the fundamental privilege of Parliament; which he ought not to do concerning any bill, till it be presented to him in due course of Parliament, and desired reparation.’ They then desired that an army of Scots should be sent thither, and that they should have the keeping of the town and castle of Carrickfergus; but the King said, that he doubted this might be to the damage of England. The Scots commissioners replied, ‘That they were sorry his Majesty, being their native King, should repose less trust in them than their neighbouring nation had freely done;’ so that at length this was granted.


It was thought to be the most feasible way for reducing Ireland, that proportions of land there should be shared among English adventurers, proportional to those sums of money they should subscribe; that so, whosoever in person or purse should assist in conquering the bloody rebels, might be recompensed if the work were done; and propositions were framed in Parliament to that purpose, which the King confirmed, though at first he laughed at them, and was heard to say, ‘That they were like to him who sold the bear's skin before the bear was killed.’ At length an act was passed for empowering the Parliament to carry on that war, till Ireland should be declared wholly subdued; and that no peace nor cessation of arms should ever be made with the rebels, without consent of both Houses of Parliament. The King then offered to go in person thither, but the Parliament thought it not fit to hazard his person in such an expedition.


The Queen, about February, went to Holland, carrying with her most of the crown jewels, which she had pledged for money and arms for the King, her husband, and for which she was afterwards voted a



---

p.41




traitor by the Parliament. The King having taken leave of her at Dover, went with the Prince and Duke of York to Theobalds, and from thence to Newmarket, where both Houses presented him a declaration, sent by two Lords, in which they repeat the old grievances, the war of Scotland, the rebellion in Ireland, his entering the House of Commons, his causeless fear of residing near London, to the perplexing of the kingdom, the hindering the relief of Ireland, and encouraging the ill-affected party in the kingdom: to which the King answered with great indignation, extenuating some things, and excusing others, accusing them for raising needless fears and jealousies: after which the King passed farther north to York; upon which the Parliament voted, ‘That the King's absence so far remote from his Parliament is not only an obstruction, but may be a destruction to the affairs of Ireland; that when the Lords and Commons in Parliament shall declare what the law of the land is, to have this not only questioned and controverted, but contradicted, and a command that it should not be obeyed, is an high breach of the privilege of Parliament; that they which advised the King to absent himself from his Parliament, are enemies to the peace of this kingdom, and justly to be suspected as favourers of the rebellion in Ireland.’


From York the King sent a message to the Parliament, April 8th, 1642, that he would go in person over to Ireland against those bloody rebels, and intended to raise a guard for his person in Cheshire to carry thither, of 2000 foot and 100 horse, whom he would arm from his magazine of Hull: but the Parliament having intimation that the King designed to seize that magazine, to arm himself against them, sent Sir John Hotham thither, who refused to admit him entrance; upon which the King proclaimed him traitor, and complained to the Parliament of the affront, who endeavoured to appease him, but justified Hotham's act, and declared that the proclaiming him traitor, without process of law, was against the liberty of the subject, and laws of the land.


The King daily summoned the gentry of the northern counties to attend him at York as a guard for his person, which he declared was in danger from the Parliament; who thereupon declared, ‘That it appears that the King, seduced by wicked counsel, intends to make a war against the Parliament, who, in all their consultations and actions, have proposed no other end to themselves but the care of his kingdoms, and the performance of all duty and loyalty to his person: that whensoever the King maketh war upon the Parliament, it is a breach of the trust reposed in him by his people, contrary to his oath, and



---

p.42




tending to the dissolution of the government; that whosoever shall serve and assist him in such wars, are traitors by the fundamental laws of this kingdom, and have been so adjudged by two acts of Parliament, 11 Richard II. and 1 Henry IV. and that such persons ought to suffer as traitors.’ The King justified himself in his declarations and proclamations against the Parliament, which daily encountered each other; so that all things tended to an absolute rupture, and presaged the calamities of the civil war, which soon after followed; for both sides flying to arms, and the nation being divided into parties, several bloody battles were fought, and the whole kingdom was in a flame.


In 1643, the Parliament of England invited the Scots to come in to their assistance, with an army of 21,000 horse and foot, engaging to pay them an 100,000£ towards the charge of raising them. On the other side, the King, to withdraw the Protestant army out of Ireland, for aiding him against the Scots, concluded a cessation of arms for a year with those rebels, and 3000 of the English army were embarked from thence to join with the King. This cessation was much complained of by the Parliament, since it was not only for the benefit of the Irish rebels, who gave him 3000£ for the favour, but also directly contrary to the act which the King had lately signed, that no cessation should be made without the consent of both Houses. Thus was assistance brought to either side, and that English army, which for almost a year had fought valiantly and victoriously against those rebels, was now brought over to fight against the Parliament of England.


The war still continued with much vigour, and great slaughter was made throughout the kingdom; yet in the midst thereof some glimmerings of peace began to appear, for in 1644, conditions were proposed both by the King and Parliament, and a treaty began at Uxbridge between commissioners from both parties, during which the care of the war was not neglected on either side, the King endeavouring to bring over some forces from the Duke of Lorraine, and some Irish to his assistance; and by his letters to the Lord Lieutenant, to make a peace with the rebels, or at least to continue the cessation for a year, and to promise and grant them the free exercise of the Romish religion, assuring them, that if by their assistance he could but finish his war in England, he would abrogate those laws made against the Papists there. He gave thanks likewise to Muskerry, Plunket, and others of that party, promising a pardon for all that was past: but they were much troubled at the treaty of peace with the



---

p.43




Parliament; being sensible, that one necessary condition thereof must be the vigorous prosecution of the war in Ireland. The King, to remove this fear, writ to the Lord Lieutenant, that he could not refuse to make a peace with his Parliament, only upon the account of those Irish, it being a point not popular: yet, from that consideration, the Lieutenant might raise an advantage, to hasten a peace with them, it letting them know their own danger, by being excluded from all hope of pardon from the Parliament; for (saith he) if we agree upon all other conditions, it will not be convenient for me to disagree only concerning those Irish: therefore, let them take what I offer, while time is, and hasten the peace, and when once my faith is passed, no human force shall make me break it.


The Queen also being then in France, writing to her husband, seemed to grieve much, that at Uxbridge they were to treat of religion in the first place, assuring him, ‘That if any thing severe against the Catholics should be concluded, and yet a peace not be made, the King could not hope for any assistance from the Catholic princes, or from the Irish, who must needs think, that after they had done their best, they should at last be forsaken;’ and often intreats the King, that he would never forsake the Catholics, who had faithfully served him in the wars, &c. The commissioners met at Uxbridge; but nothing at all was concluded at that treaty, so that the war must decide it; in pursuance whereof, both parties strengthen themselves with fresh forces; and the King's army was very formidable; but not content with so great a power of English soldiers, he seemed more earnest than before, to get over the Irish; he had committed the business to Ormond, to make an absolute peace; but perceiving their demands were too high, so that nothing was effected, he now employed the Earl of Glamorgan, son to the Marquis of Worcester, a zealous Papist, and therefore more acceptable with the rebels; giving him full power to make a peace, and indulge to the Irish whatever might seem needful; and this was transacted so secretly, that both the Lord Lieutenant Ormond, and the Lord Digby, secretary of Ireland, were ignorant thereof, till it was afterward discovered and made public: But the King finding it difficult to make such a peace as would bring him certain assistance otherwise, that he might throw all that envy upon Glamorgan, impowered him, unknown to the rest; for so the rebels, sweetened with large promises (unknown to Ormond) might the better admit of conditions just in shew, and openly excusable; and the King might draw from Ireland such soldiers as would more firmly adhere to his side, and whom



---

p.44




he might trust (as being the greatest haters of the English Protestants, and despairing of pardon) against the Parliament of England. He therefore gave letters of authority to Glamorgan in these words:

> Charles, by the grace of God, King of England, &c. Defender of the Faith; to our trusty and well beloved cousin, Edward, Earl of Glamorgan, greeting;
> being confident of your wisdom and fidelity, We do by these letters, as if under our great seal, grant unto you, full power and authority, to treat with the confederate Roman Catholics in Ireland, and to indulge them all those things which necessity shall require, and which we cannot so commodiously do by our Lieutenant, nor ourself publicly own at present: Therefore, We command, that you do this business with as much secrecy as can be; whatsoever you shall think fit to be promised in my name, that I do attest, upon the word of a King and a Christian, to grant to those confederate Catholics, who by their assistance have abundantly shewed their zeal to us, and our cause.
> 
> 
> Given at Oxford, under our royal seal, March 12, and 20th year of our reign.




In pursuance of these powers, the Earl of Glamorgan assured the King, he would land 6000 Irish Papists in May following in Wales, and with the transport ships, block up Milford Haven, having already to advance the same, thirty thousand pounds in money, 10,000 muskets, 2000 case of pistols, 800 barrels of powder, besides his own artillery, and a certainty of 30,000£ more. The King likewise obliged the Earl of Antrim to join with the Marquis of Montrose, then in arms in Scotland, who engaged to send 10,000 Irish thither from Ireland, where the passage was shortest, to assist him; but was very deficient therein, being scarce able to send 1200 thither.


In 1644, the Parliament ordered the arraignment of the Lord Maguire, and Colonel Mahon, who were seized at Dublin, the night before the discovery of the rebellion there, and had been in the town ever since: they were now brought to their trial at the King's Bench bar, at Westminster, where Maguire insisted much upon his peerage,
but was over-ruled; and both found guilty of high treason, by a jury of Middlesex gentlemen, and executed at Tyburn. In 1646, the Lord Lieutenant endeavoured to make the cessation with the Irish a kind of a peace; which they condescended to upon the following propositions: ‘1. That the exercise of the Roman Catholic religion
should be in Dublin and Drogheda, and in the kingdom of Ireland, as free as in Paris and Brussels. 2. That the privy council of Ireland consist of members true and faithful to his Majesty, and who have been enemies to the Parliament. 3. That Dublin, Drogheda, Trim, Newry,



---

p.45


**Catherlough**, Carlingford, and all Protestant garrisons, be manned by the confederate Catholics, to keep the same for the use of the King, and defence of the kingdom. 4. That the said counsellors, generals, commanders, and soldiers, do swear and engage to fight against the Parliament of England, and all the King's enemies; and that they will never come to any agreement with them, to the prejudice of his Majesty's rights, and the kingdoms. 5. That both parties, according to their oath of association, shall to the best of their power and cunning, defend the fundamental laws of the kingdom, the King's rights, and liberties of the subject.’


This peace was kept by some of the moderate Papists; but was ill resented, both by the Parliament of England, and the Pope's Nuncio, who influenced the most serious Papists; to put a stop to which, the Parliament sent 2000 men from Chester, under Colonel George Monk, with three commissioners, to the Lord Lieutenant at Dublin; who refused to deliver the city to them, without the King's command: so that after having treated the commissioners, the English forces were again embarked, and landed at Belfast, in Ireland, whereby they did very good service against O'Neill and his fellow rebels, who had of late been too successful against the Protestants. On the other side, the Nuncio's party were so elevated with the hopes of shaking off the English yoke, neither of the two kingdoms being now in a capacity to relieve Ireland, that the Romish Clergy thundered out excommunication against any that should acquiesce in the said peace and agreement, and with an army of 17,000 horse and foot, resolved to besiege
Dublin; which so startled the Protestants, that the Lord Lieutenant was obliged to resume the former treaty with the Parliament's commissioners, and the King finding that all his secret transactions with the Earl of Glamorgan were discovered by the letters taken at Naseby fight, to the great disgust of the people in general; and that all the assurance he had from the Lord Lieutenant, and the Lord Digby, were disappointed the falseness and treachery of the rebels; he, though with much reluctancy, consented, that all manner of treaty with the enemy should cease; the Earl of Glamorgan being, for a pretence, imprisoned. The Lord Lieutenant being pressed with the danger of a siege from the Roman Catholic confederates, in 1647, delivered up Dublin to the Parliament's commissioners; he having articled for his passing freely to the King, on whom he waited, while the army carried him about, and afterwards put him to death; and from thence passed to France, from whence, about September, 1648, the Catholic confederates, dreading a storm from England, by letters to the King, had



---

p.46




importuned him to send for the said Marquis of Ormond, late Lord Lieutenant; and ordered him to return again into Ireland, upon their engagement and protestation of plenary submission to his Majesty's authority, and to him, as his Lieutenant, as being the only proper person for that employment: the Marquis accordingly undertook it, and making an agreement with the Lord Inchiquin, and his forces, and likewise with those of the Marquis of Clanrickard, and the Earl of Castlehaven, and the confederate Catholics, who had proclaimed the Nuncio's party rebels and traitors; being all joined under his command, they designed to reduce Dublin, then possessed by the Parliament's forces; but differences soon arose about the exercise of the Popish religion, and upon points of command, whereby Owen O'Neill, that had a considerable party of Irish, was disobliged, who thereupon makes an agreement with Colonel Monk, in the name of the Parliament, though they afterwards disclaimed it (but acknowledged his faithfulness and well-meaning therein, by a vote of Parliament), considering how odious it would be, to have assistance from Irish rebels; however, he aided them all he could, and relieved Londonderry, then
besieged by the confederate forces: at length, the Marquis of Ormond comes before Dublin with his army, and obliges Colonel Jones, the governor, who had drawn out some of the garrison to interrupt them, to retire into the city, which was indifferently fortified, and plentifully manned, both with horse and foot; and therefore he durst not venture his army upon a desperate assault, since the garrisons of Drogheda and Trim lay so convenient to attempt upon them, commanded by Colonel Monk and O'Neill: so that the Marquis wanting money and provisions, and the English and Irish forces murmuring against each other, he was almost resolved to have marched away; but O'Neil's party being soon after defeated, and a convoy of arms and ammunition, which were sent him by Colonel Monk, being taken by the Lord Inchiquin, Drogheda was surrendered, together with Dundalk, the garrison compelling Colonel Monk to deliver it, and the soldiers took up arms for the King; the garrison of Trim was soon after taken from the Parliament; after which, the Lord Inchiquin brings up his forces, now much increased, to assist the Marquis at the siege of Dublin; who designed to shut up the garrison within their works, and hinder them from getting forage, or to graze their cattle without the line which was drawn round the town; the besieged perceiving the danger of being thus closely confined, whereby they would have been prevented of all succour, both from land and sea; and knowing the Marquis's want of horse to guard the new forts, resolved, by a desperate sally, to disturb them, which they



---

p.47




made accordingly, Aug. 2, 1649, about eight in the morning, with 1200 foot, and 4000 horse, and finding the new fortification slight, and the resistance weak, they soon were masters of it; from whence seeing the Irish fly in great disorder, they, contrary to the first intentions, pursued the besiegers, even to the avenues of their camp, and being animated by Colonel Jones, their governor, who had newly received a supply of 3000 men from England, they fell with such fury upon the whole army at Rathmines, consisting of 19,000 men, that in a short time they put them to the rout, killing 4000 on the place, and making 2517 prisoners, many of them persons of quality, taking all their cannon, and a rich camp to reward the soldiers. Most of the Lord Inchiquin's foot, that at first made some resistance, seeing the day lost, changed sides, and joined with the Parliament's forces.


All this was done in so short a space, and with so little noise, that the Lord Dillon, and the rest of the Marquis's forces on the other side the river Liffey, knew nothing of it, till some runaways brought the news, the Irish making such haste home, in so panic a fear, that the Lord Lieutenant could not possibly rally



---

p.48




them; and therefore fled with a considerable party to Kilkenny, and there endeavoured to draw together as many of his dispersed troops as possible, with which he speeds away to Trim and Drogheda, where he had notice, that Oliver Cromwell, the Parliament's general, was landed with considerable forces; upon which he put a garrison of 300 horse, and 2500 foot into Drogheda, which was thought sufficient, and having furnished it with what provisions he was able, and made Sir Arthur Aston governor, went from thence to Trim and Terrogan. About this time, Londonderry, possessed by the Parliament, and besieged by Ormond's forces, was relieved, and the siege raised; and not long after a ship from Spain brought the plague into Galway, whereof a great number of the Irish died.


Cromwell having refreshed his men at Dublin, marches to besiege Drogheda, and made himself master of it in a little time, after a stout resistance from the garrison, putting most of the officers, and every tenth soldier, to the sword to terrify others from making opposition against his victorious arms: Sir Arthur Aston, and several other principal officers and gentlemen, with near 3000 soldiers, being slain. After this, Cromwell besieges the town of Wexford, and soon reduced it, even before the Lord Lieutenant's eyes, with the loss of 2000 of the Irish; upon this, the Marquis makes an agreement with Owen O'Neill, whereby the Ulster army were to join with his, under the
command of Luke Taaf, who was made governor of Ross; but soon forced to surrender it to General Cromwell; after which, the garrisons of Bandonbridge, **Youghall**, Cork, **Kingsale**, and all the English towns in Munster, declared for the Parliament; and Cromwell marched to besiege Dungannon; but finding little hopes of reducing it quickly, he resolves to go to Kilkenny, and the Marquis of Ormond, and the Lord Inchiquin retiring without hindering his march, he took in several strong towns and forts, and at length attacks Kilkenny with such vigour, that he took it in six days time; after which, he besieges **Clonmell**, a strong garrison, during which, Colonel Reynolds and Hewson attack Trim, and the Lord Broghill defeats the Bishop of Ross, who designed to relieve **Clonmell**, which soon after was taken by assault, and a great carnage made, because of their obstinacy in defending the same. After this, Cromwell, having in ten months done the work of so many years, returns to England, and Colonel Ireton being made Lord-deputy is sent over thither, there being only Limerick, Waterford, Galway, and some few castles in the hands of the Irish, the first of which was surrendered to him Oct. 29th, 1651; but he dying, Colonel Edmund Ludlow succeeded him, as Lieutenant-General of the



---

p.49




army of that kingdom: The war was now almost at an end, and the Lord Clanrickard being in Galway, sends a letter to Ludlow, to desire him to appoint commissioners to meet with others, for the composure and conclusion of this wasting bloody war, which Ludlow refused; but sent him word: ‘That if the Irish would submit, they should have such articles and conditions, as were fit for them;’ this prevailed on several parties, as the Lord Muskerry's, Fitz-Patricks, and the Odroyrs to come in and submit, upon condition they might transport their forces into the service of the King of Spain: the Earl of Ormond, and the Lord Inchiquin, not pleased with the face of affairs, left that kingdom some time before, and went to France; and in 1652, the remaining Irish, under the Lord Clanrickard, having received several defeats by the English forces. May 12th Galway was surrendered, and afterward the whole country was reduced to the obedience of the English Parliament; Sir Phelim O'Neill, the arch-rebel, being likewise taken, hanged, and quartered. The last of the Irish, who held out in the bogs and fastnesses, was General O'Brian, who at length finding the weakness of his party, and weary of his skulking condition, obtained the usual articles of transportation; upon which articles it was reckoned, that from the year 1652, to 1653, near 27,000 Irish had departed the kingdom, and the rest were transported into the province of Connaught, environed on one side by the sea, and locked up by rivers and garrisons on the other, out of which they were not to stir, under a severe penalty: By this means, the country was much depopulated, and the Lord Fleetwood, and the commissioners in Ireland sent over letters, that some English colonies might be sent thither to inhabit, great privileges being offered to them that would transport themselves; and accordingly went over to better their fortunes; and in a short time, this harassed and ruinated kingdom began to flourish again, both in tillage, buildings, and all other accommodations.


I have been very brief in relating any thing of the affairs of England, or of the actions of Oliver Cromwell, in this kingdom; having already published two books, one, the History of the Wars of England, with all the most remarkable passages, till the death of King Charles I. and his trial and last speech at large: and another, called the History of the Life and Actions of Oliver Cromwell, with his death and burial; both of the same value with this, to which I refer the reader, for further satisfaction.


In 1654, the Lord Fleetwood was sworn Lord-deputy of Ireland, Serjeant Steel was made Lord Chancellor, and Serjeant Pepys Lord Chief-justice; Colonel Hammond Corbet, with others, being made of the



---

p.50




privy council, they ordered that March 1st, 1654, should be the longest time allowed to the Irish, to transport themselves out of that kingdom, under very severe penalties. But a while after Oliver Cromwell having taken the government upon himself, with the title of Lord Protector, in July 1655, Henry Cromwell, his son, was made by him Lord Lieutenant of Ireland, in the place of the Lord Fleetwood, all things still continuing very quiet there: the same year, Archbishop Usher of Armagh died, a prelate of incomparable learning and piety, upon whose funeral the Protector expended 200£ After the death of Oliver Cromwell, his son Richard succeeded; but in a short time, was removed from the government, by Major-General Lambert, and the army, and the remnant of the long Parliament restored in 1659, who sent dispatches to the Lord Henry, to surrender the government of Ireland to Chancellor Steel, and Lord Chief Baron Corbet, which he did, without opposition; and to oblige the Parliament the more, signified by an express, that he was preparing to come for England with all speed, to give them an account of that kingdom; which he had left in a very good condition, and hoped that his successor might reap more content in the government, than he had found: after his arrival, he applied himself to the Council of State, and had liberty, by an order, to go into the country, or whither he pleased.


But the nation being discontented at the continual fluctuations of the government, the long Parliament being soon after turned out again by the army, the people generally desired a free Parliament: and General Monk marching out of Scotland with his army, and reinstating the Parliament, and restoring the excluded members, in March 1659, they dissolved themselves, having sent out writs for electing a new representative, to meet April 25th following, and about the same time, **Sir Charles Coot**, in Ireland, declares himself for a free Parliament; and thereupon possessed himself of Dublin castle, having before surprised Galway from Colonel Sadler in this manner: He invited him and his officers, all zealous for the long Parliament, to his house over the water, to be merry; which done, Sir Charles pretended a desire to drink a glass of wine in Galway privately with the Colonel: so they two secretly took a boat, with each a servant, and being on the other side, Sir Charles said; ‘Colonel Sadler, I am resolved for a free Parliament, and to have this garrison; you have a sword about you, draw and fight, or else engage your honour, you will make no disturbance in the town upon our admission, and my declaration;’ to which Sadler, surprised and troubled, answered: ‘He would acquiesce;’ upon this he caused the gate to be opened, and Sir Charles having declared himself, the soldiers cried out, ‘A Coot, a Coot, and a free Parliament:’



---

p.51




After this he secured Sadler, and Sir Hardress Waller at Dublin, and immediately all Ireland declared themselves satisfied in this change, offering their lives and fortunes in the defence of the Parliament, then assembled; and soon after a convention was called at Dublin, in nature of a Parliament, to provide for the safety of the kingdom, from whence the Lord Shannon, Sir John Clotworthy, and Major Aston were sent as commissioners to England, where the Parliament voted the restoration of King Charles II. and upon notice thereof, the like was done in Ireland, and several of the most eminent of that nation were, upon the King's arrival at Whitehall, sent by the convention to wait upon him in the name of that kingdom, with a tender of their allegiance, and a present of 4000£ to the Duke of York; and soon after the King was proclaimed, and universally acknowledged throughout the kingdom.


But it was not long ere the great inclinations to the Popish party in Ireland were made apparent in the court of England, and several disputes arose about the settlement of that kingdom; which were debated before the King and Council, where the Lord Chief Justice Santry, in an excellent speech, represented to the board, the horrid rebellion of 1641, with the barbarous and inhuman massacres, which he had been eye witness of: in opposition to which Sir Nicholas Plunket, one of the Pope's knights, endeavoured to defend the Irish, but so weakly, having a bad cause to manage, that the Lord Santry clearly carried the point in the judgment of the auditors; he desiring that they might be tried by the common law, where they would meet with a fair and indifferent trial by juries of their neighbours, and thereby could have no wrong done them: but the King having dissolved the convention, and called a Parliament in Ireland, he prevailed so much upon them, that an **act of settlement** was pressed, and a court of claims thereby erected, who were to determine all differences between the English and Irish proprietors of the lands there, and to declare who were nocent, and who innocent Papists. These commissioners being nominated by the King, he had so great an influence over them, that they commonly gave their opinions according to his direction, which was oftentimes very favourable to the Irish rebels, particularly in the case of the Earl of Antrim, one of the chief of them, as by the following letter to the Duke of Ormond, then Lord Lieutenant, and the privy council there, doth appear.


> CHARLES R.
>   
>  Right trusty and well beloved cousins and counsellors, &c. We greet you well.
> How far we have been from interposing on the behalf of any of our Irish subjects, who by their miscarriages in the late rebellion
> 
> 
> 
> ---
> 
> p.52
> 
> 
> 
> 
> in that kingdom of Ireland, had made themselves unworthy of our grace and protection, is notorious to all men; and we were so jealous in that particular, that shortly after our return into this our kingdom, when the Marquis of Antrim came hither to present his duty to us, upon the information we received from those persons who then attended us, by a deputation from our kingdom of Ireland, or from those who at that time owned our authority there, that the Marquis of Antrim had so misbehaved himself towards us, and our late royal Father of blessed memory, that he was in no degree worthy of the least countenance from us, and that they had manifest and unquestionable evidence of such his guilt. Whereupon we refused to admit the said Marquis so much as into our presence; but on the contrary, committed him prisoner to our Tower of London; where, after he had continued several months under a strict restraint, upon the continued information of the said persons, we sent him into Ireland, without interposing the least on his behalf, but left him to undergo such a trial and punishment, as by the justice of that our kingdom should be found due to his crime, expecting still that some heinous matter would be objected and proved against him, to make him uncapable, and to deprive him of that favour and protection from us, which we know his former actions and services had merited. After many months attendance there, and (we presume) after such examinations as were requisite, he was at last dismissed without any censure, and without any transmission of charge against him to us, and with a license to transport himself into this Kingdom: We concluded that it was then time to give him some instance of our favour, and to remember the many services he had done, and the sufferings he had undergone, for his affections and fidelity to our royal Father and ourself, and that it was time to redeem him from those calamities, which yet do lie as heavy upon him since, as before our happy return. And thereupon we recommended him to you, our Lieutenant, that you should move our council there, for preparing a bill to be transmitted to us, for the reinvesting him, the said Marquis, in the possession of his estate in that our kingdom, as had been done in some other cases. To which letter, you, our said Lieutenant, returned us answer, that you had informed our council of that our letter, and that you were, upon consideration thereof, unanimously of opinion, that such a bill ought not to be transmitted to us, the reason whereof would forthwith be presented to us from our council. After which time we received the inclosed petition from the said Marquis, which we referred to the considerations and examinations of the lords of our privy council whose names are mentioned in that our reference, which is annexed
> 
> 
> 
> ---
> 
> p.53
> 
> 
> 
> 
> to the said petition; who thereupon met together, and after having heard the Marquis of Antrim, did not think to make any report to us, till they might see and understand the reasons which induced you not to transmit the bill we had proposed, which letter was not then come to our hands. After which time we have received your letter of the 18th of March, together with several petitions which had been presented to you, as well from the old soldiers and adventurers, as
> from the Lady Marchioness of Antrim, all which we likewise transmitted to the lords referees, upon a second petition presented to us by the Lord Marquis, which is here likewise inclosed, commanding our said referees to take the same into their serious consideration, and to hear what the petitioner had to offer in his own vindication, and to report the whole matter to us; upon a third petition herein likewise inclosed, we required them to expedite with what speed they could. By which deliberate proceedings of ours you cannot but observe, that no importunity how just soever, could prevail with us to bring our self to a judgment in this affair, without very ample information. Our said referees, after several meetings, and perusal of what had been offered to them by the said Marquis, have reported unto us, that they have seen several letters, all of them the hand-writing of our royal Father to the said Marquis, and several instructions concerning his treating and joining with the Irish, in order to the King's service, by reducing to their obedience, and by drawing some forces from them, for the service of Scotland. That besides the letters and orders under his Majesty's hand, they have received sufficient evidence and testimony of several private messages and directions sent from our royal Father, and from our royal Mother, with the privity, and with the directions of the King our Father; by which they are persuaded, that whatever intelligence, correspondence or actings, the said Marquis had with the confederate Irish Catholics, was directed or allowed by the said letters, instructions, and directions; and that it manifestly appears to them, that *the King our Father was well pleased with what the Marquis did, after he had done it, and approved the same.*
> 
> 
> This being the true state of the Marquis his case, and there being nothing proved upon the first information against him, nor any thing contained against him in your letter of March 18th; but that you were informed he had put in his claim before the commissioners, appointed for executing the act of settlement; and that if his innocency be such as is alleged, there is no need of transmitting such a bill to us, as is desired; and that if he be nocent, it consists not with the duty which you owe to us, to transmit such a bill, as if it should pass into a
> 
> 
> 
> ---
> 
> p.54
> 
> 
> 
> 
> law, must needs draw a great prejudice upon so many adventurers and soldiers, which are, as is alleged, to be therein concerned. We have considered of the petition of the adventurers and soldiers, which was transmitted to us by you; the equity of which consists in nothing, but that they have been peaceably in possession, for the space of seven or eight years, of those lands which were formerly the estate of the Marquis of Antrim, and others, who were all engaged in the late Irish rebellion; and that they shall suffer very much, and be ruined, if those lands should be taken from them. And we have likewise considered another petition from several citizens of London, near sixty in number, directed to ourself, wherein they desire, that the Marquis his estate may be made liable to the payment of his just debts, that so they may not be ruined in the favour of the present possessors, who (they say) are but a few citizens and soldiers, who have disbursed very small sums thereon. Upon the whole matter no man can think we are less engaged by our declaration, and by the act of settlement, to protect those who are innocent, and who have faithfully endeavoured to serve the Crown, how unfortunate soever; than to expose to justice those who have been really and maliciously guilty. And therefore we cannot in justice, but upon the petition of the Marquis of Antrim, and after the serious and strict inquisition into his actions, declare unto you, That *we do find him innocent from any malice or rebellious purpose against the Crown;* and that what he did by way of correspondence, or compliance with the Irish rebels, was in order to the service of our royal Father, and warranted by his instructions, and the trust reposed in him; and that the benefit thereof accrued to the service of the Crown, and not to the particular advantage and benefit of the Marquis. And as we cannot in justice deny him this testimony, so we require you to transmit our letter to our commissioners, that they may know our judgment in this case of the Lord of Antrim, and proceed accordingly. And so we bid you heartily farewell.
> 
> 
> Given at our Court at Whitehall, July 10th, in the 15th year of our reign, 1663. 
>   
> 
> To our right trusty and right entirely well-beloved cousin and counsellor, James Duke of Ormond our Lieutenant-General and general Governor of our kingdom of Ireland; and to the lords of our council of that our kingdom.
>   
> 
> Entered at the Signet Office, July 13th, 1663.
>   
>  By his Majesty's command,
>   
> 
> Henry Bennet.






---

p.55


Soon after, the following answer of the Duke of Ormond, and the Irish privy council, to the foregoing letter, was sent to Sir Henry Bennet, principal secretary of state.

> 
> ‘On the 20th, I, the Lord Lieutenant, received his Majesty's letter of July 10, concerning the Marquis of Antrim, which I imparted to the council; upon reading whereof at this board, we observing, that though in several other matters relating to the proceedings of his Majesty's commissioners appointed for executing the act of settlement, his Majesty vouchsafed to direct this letter to the commissioners: yet that those letters concerning the Marquis of Antrim are directed to us, the Lieutenant, and council, requiring us to transmit the same to the commissioners, that they may know his Majesty's judgment in the case of the Lord Antrim, as it stands stated in those his Majesty's letters, and proceed accordingly: We hence gathered, that his Majesty did judge it fit, that those his letters for the Marquis of Antrim should be directed to us, to the end, that if we, his Majesty's servants, here upon the place, should find more in the Marquis of Antrim's case, than are in those letters taken notice of, either
> 
> 
> 
> ---
> 
> p.56
> 
> 
> 
> 
> in relation to his Majesty, or his affairs, then in such case, we might humbly represent the same to his Majesty; and as it was the use and custom here in former times, and particularly in the times of his Majesty's royal Father, of blessed memory, that if any directions came from the King, which, in the execution thereof, might occasion inconveniences to his Majesty's service, the same was stayed, until the matter was by the chief governor here humbly represented to the King: so it is also agreeable to his Majesty's instructions to me, the Lord Lieutenant, particularly in things relating to his Majesty's revenue, which likewise is the present case, for his Majesty's revenues are like to be hereby much lessened; and moreover it is agreeable likewise with his now Majesty's gracious pleasure, signified thither by the lords of his Majesty's most honourable privy council, by their letters of Aug. 12, 1661, directed to the late justices and council; wherein it was declared, that his Majesty and the lords of the most honourable privy council, were well assured of a demur the said justices and council had made upon letters from his Majesty, and their forbearance to proceed thereupon, till they should receive his Majesty's further pleasure: and therefore upon full consideration thereof had at this board, we humbly conceive, that it is our duty to his Majesty, to defer for some time, the transmitting the said letters to the said commissioners, till we shall have represented to his Majesty, that which appears to us here; which it seems was not made known to his Majesty, or those lords of the privy council, to whose consideration his Majesty referred the Marquis of Antrim's petitions, mentioned in his Majesty's letters: We observe that his Majesty's said letters seem to be grounded on these particulars: 1. That after many months attendance here, and, as his Majesty is pleased to declare; that he presumes that after such examinations as were requisite, the Marquis of Antrim was dismissed hence, without any censure, and without transmitting any charge against him to his Majesty; and nothing proved against him on the first information, nor any thing contained against him in our letters of March 18. 2. The report made by these lords of his Majesty's most honourable privy council, to whom his Majesty referred the consideration of the Lord of Antrim's petitions. 3. That the Marquis's case, as it stands stated in those letters, is the true state of his case. As to the first, we find, that the lords of his Majesty's privy council, by their letters of Dec. 19, 1660, directed to the justices of this kingdom, signified, that the Marquis of Antrim, the prisoner in the Tower of London, petitioned his Majesty to be heard, as to his being criminal in the aspersing the memory of
> 
> 
> 
> ---
> 
> p.57
> 
> 
> 
> 
> the late King our Sovereign; and their lordships, by these letters, required the justices, with all convenient speed, to send their lordships authentic copies of all papers whatsoever, under his own hand, or any other which may any way relate to the said Marquis being guilty of so foul a crime as the defaming his late Majesty; and that the justices should cause all such witnesses resident in this kingdom, who can allege any thing to the proving thereof, to be examined, and the examinations to be returned to their lordships attested by us, and the justices appointed to take the same; and in pursuance of those letters, the justices caused a commission to issue under his Majesty's great seal to several persons, some of them members of this board, and some of his Majesty s judges, and some of his learned council, to call before them, and examine witnesses upon oath, concerning the Lord of Antrim's aspersing the memory of his late Majesty; that those commissioners having examined several witnesses, and returned their examinations to the justices, with their letters of Feb. 20, 1660, directed to the lords of his Majesty's privy council, transmitted the same to their lordships. That March 29, 1661, it was ordered by his Majesty in council, that in order to a farther proceeding here against the Lord Antrim, the examinations and other papers should be returned hither. Thus far the matter proceeded, before the arrival of the Lord Lieutenant in this kingdom. Aug. 18,166(1), the Lord Chief-justice Santry made a report at this board, of the examinations taken concerning the Marquis, and upon his petition it was ordered, that the Chief-justice should cancel the recognizance acknowledged by the Marquis and his sureties; and as to his being criminal in aspersing and defaming the memory of his Majesty's royal Father, we humbly crave leave to send herewith the said examinations, and other papers concerning the same, which we humbly submit to his Majesty's consideration; and we confess we are not willing, upon these examinations and papers, to aggravate any thing against him; and therefore it was, that there was no censure, nor any transmission of charge against him to his Majesty; and as to our letters of March 18, we confess there is nothing contained therein against him, nor indeed, under favour, did we conceive it proper in those letters to object any thing of crime to him; our work in those letters being but to inform his Majesty only of the particulars then under consideration, and what occurred upon occasion of two petitions exhibited, the one by the Lady Marchioness of Antrim, the other in the name of several adventurers and soldiers, and their assigns and tenants; for we did not imagine the Lord Marquis would have attempted to put his Majesty upon a difficulty of giving a rule contrary
> 
> 
> 
> ---
> 
> p.58
> 
> 
> 
> 
> to the act of settlement, but would have abiden the trial in the proper way prescribed by the act, wherein it is provided that the said Marquis shall be restored to his estate in such manner and form, and according to such order and method, and no other, as the Lord Viscount Netterville and the Lord Viscount Gilmoy ought, by virtue of the act, to be restored: and besides, we had no notice from thence that the matters relating to the said Marquis were under debate or consideration there, which might give us occasion humbly to represent to his Majesty those things which now, for his Majesty s service, we are necessitated to do.’
> 
> 
> ‘To the second, namely, the report made that those of the lords of the council to whom his Majesty referred the Marquis's petition, we must acknowledge the justice of their lordships' proceedings upon what appeared to them: but there are some which we do verily believe were not made known to them, and which do appear to us here, wherein we may not be silent, without breach of justice to his Majesty; for I, the Lord Lieutenant, do well know, that the peaces made by me in 1646 and in 1648, in this kingdom, and both derived by authority from his Majesty's royal Father, were both opposed by the Lord Marquis of Antrim, who continually served with the Pope's Nuncio and his adherents against his Majesty's authority, then entrusted with me, the Lieutenant, and appeared active in all assemblies and counsels wherein he was present, in open opposition to all members of those assemblies and counsels, who endeavoured to incline the people to submission to the peace; when I, the Lord Lieutenant, laboured earnestly, by all just and honourable ways and means, to reduce his Majesty's subjects in this kingdom to their due obedience to his Majesty, and to give him assistance whereof he stood in need, in the greatest and most imaginable necessity; and when the Marquis of Antrim and the Pope's Nuncio, and clergy's party and their adherents, laboured industriously to withdraw them from their obedience and assistance to his Majesty, and so far prevailed, that when things were in a tendency towards sending 10,000 men to his Majesty's assistance, the Lord of Antrim declared openly in the confederates' great assembly, that not a man should go put of the province of Ulster; and in the end, both these peaces were, by that disloyalty to his Majesty, and by the countenance and continuance of the said Marquis, rendered fruitless; and what great and general evils followed thereupon to his Majesty and all his kingdoms, we need not now repeat; whence it was that in the act of settlement it is enacted, that such as at any time adhered to the Nuncio or clergy's party, or papal power,
> 
> 
> 
> ---
> 
> p.59
> 
> 
> 
> 
> in opposition to the King's authority, shall not be restored as innocent Papists: and this being the Marquis of Antrim's case, how far it may be fit for his Majesty (in the greatest humility we mention it) to direct, contrary to the said act of Parliament, that the commissioners upon these his Majesty's letters should proceed to find him innocent (for so the letter seems to imply), and that, as we humbly conceive, without giving any latitude of power to the commissioners to examine matter of fact, pursuant to the said act of Parliament, we humbly submit to his Majesty's great wisdom; and, as we humbly conceive, it is not to be imagined that his late Majesty, a Prince of most eminent honour and prudence, would privately intrust the Marquis of Antrim to oppose the conclusion of those peaces, for the obtaining whereof his Majesty had given public authority to the Lieutenant; or that he ever gave any subsequent approbation, which tended to his said Majesty's utter ruin: and if it should be supposed that the Marquis's compliance with the Nuncio and clergy's party, though most irreconcileable enemies to the English crown and interest, might have been allowed of by his said Majesty, upon the Marquis's undertaking to employ the credit he should thereby gain amongst them, to dispose them at least to forbear that violent opposition to all overtures tending to the reduction of the Irish confederates to their obedience, and to the assistance of his late Majesty. It cannot be rationally supposed, as we humbly conceive, but that the reason and end of the Marquis's compliance would either, by his late Majesty, for the better management of the affair, or by the Marquis himself, for his security and exoneration, have been made known to me, the Lord Lieutenant, the Marquis having frequent opportunity to do it. The conclusion of this point is, that as the Marquis's constant opposition to all the motions of peace set on foot, by virtue of authority derived from his late Majesty, hath been made apparent to us by sufficient proofs, so it is clearly manifested by his taking the oath of association, a copy whereof is here inclosed, and that by the administration of those who, when they had, by his assistances, prevailed in the breach of the peace, and of the public faith of the confederates, assumed to themselves, in the year 1646, the government of that party, under the name of a supreme council; as also by his becoming one of that council, and signing several letters and instruments, whereof some were directed to me, the Lieutenant, and all this without any correspondence with me, or the least private intimation that his purpose, in those his proceedings, had any authority from his Majesty, or any respect to his service. And as to the third, the two last-mentioned particulars do seem to us to
> 
> 
> 
> ---
> 
> p.60
> 
> 
> 
> 
> manifest, that the Marquis's case, as it stands stated in these letters, is not the whole state of the case, seeing those material things are omitted therein, which we have before expressed, which indeed we should willingly have forborn, if our silence could have consisted with the duty which we owe to his Majesty, and to the settlement of this kingdom, and to that which we humbly conceive is expected from us by his Majesty; for there is now, and hath been for above a month last past, under our consideration here, the *draft* of a new act, to supply those defects in the present act of settlement, which experience hath manifested to become absolutely necessary to be remedied, in order to the general settlement of this kingdom: and it is most evident, that if the said Marquis shall be declared innocent, and that in so extraordinary a way, as it would be contrary to the act of settlement, being the public and fundamental security of men's estates, so it would have this further operation, that the end of that intended act for gaining of reprisals for the estates of justly restorable persons, such as his Majesty, by his gracious declaration, was pleased to acknowledge himself obliged to provide for, will become in an high degree disappointed, and what general mischiefs and inconveniences may hereupon follow, to the settlement of the kingdom in general, is very apparent. When we had thus far proceeded in our letter, a petition of the adventurers and soldiers, and their assigns, concerning the estate formerly belonging to the said Marquis, was exhibited at this board; which being read before us, we find it to contain such matters concerning the Marquis of Antrim, as we humbly conceive are necessary, upon this occasion, to be made known to his Majesty; and therefore do esteem it our duty to exhibit it to his Majesty's review and royal consideration, all which we humbly submit to his Majesty's excellent judgment: and we desire you to move his Majesty for a signification of his good pleasure herein to us his servants, as speedily as with convenience may be, if his Majesty, in his wisdom, shall so judge fit.’
> 
> 
> ‘And so we remain, from the council chamber at Dublin, July 31, 1663, your assured loving friends, Ormond, Maurice Eustace, Chancellor; James Dublin, Ossory, Shannon Dungannon, Hen. Midensis, Mich. Cork, William Lawfield, Rich. Coot, Hen. Tichburn, Rob. Forth, James Ware, George Wentworth, Robert Meredith, Theoph. Jones, Thomas Clergiss.’
> 
> 
> ‘To the Right Honourable Sir Hen. Bennet, Knight, his Majesty's principal Secretary of State.’
> 
> 
> 






---

p.61


But what effect this letter had, and what the Marquis of Antrim's true case was, appears by the following letter, which fully states the same:

> Dublin, Aug. 22, 1663.
> ‘Ever honoured Sir, last Thursday we came to trial with my Lord Marquis of Antrim, but, according to my fears (which you always surmised to be in vain), he was, by the King's extraordinary and peremptory letter of favour, restored to his estate as an innocent Papist. We proved eight qualifications in the act of settlement against him, the last of which made him incapable of being restored as innocent. We proved, 1. that he was to have a hand in surprising the castle of
> Dublin in the year 1641; 2. that he was of the rebels' party before the 15th of September, 1643, which we made appear by his hourly and frequent intercourse with Renny O'More and many others, being himself the most notorious of the said rebels; 3. that he entered into the Roman Catholic confederacy before the peace in 1643; 4. that he constantly adhered to the Nuncio's party, in opposition to his Majesty's authority; 5. that he *sat* from time to time in the supreme council of Kilkenny; 6. that he signed that execrable oath of association; 7. that he was commissioned and acted as Lieutenant-general from the said assembly at Kilkenny; 8. that he declared, by several letters of his own penning, himself in conjunction with Owen Roe O'Neill, and a constant opposer to the several peaces made by the Lord Lieutenant with the Irish. We were seven hours by the clock in proving our evidence against him, but at last the King's letter being opened and read in court, Rainsford, one of the commissioners, said to us, that the King's letter on his behalf was evidence without exception, and thereupon declared him to be an innocent Papist. This cause, Sir, hath (though many reflections have passed upon the commissioners before) more startled the judgments of all men, than all the trials since the beginning of their sitting; and it is very strange and wonderful to all of the long robe, that the King should give such a letter, having divested himself of that authority, and reposed the trust in commissioners for that purpose: and likewise it is admired that the commissioners, having taken solemn oaths to execute nothing but
> according to, and in pursuance of, the act of settlement, should barely upon his Majesty's letter declare the Marquis innocent. To be short, there never was so great a rebel that had so much favour from so good a King: and it is very evident, that the consequence of these things will be very bad; and if God, of his extraordinary mercy, do not
> 
> 
> 
> ---
> 
> p.62
> 
> 
> 
> 
> prevent it, war, and (if possible) greater judgments, cannot be far from us; where vice is patronized, and Antrim, a rebel upon record, and so lately and clearly proved one, should have no other colour for his actions but the King's own letter, which takes off all imputations from Antrim, and lays them totally upon his own father. Sir, I shall by the next, if possible, send you over one of our briefs against my Lord by some friend; it is too large for a packet, it being no less in bulk than a book of martyrs.’
> 
> 
> 




Well might the Irish decline their trials by indifferent juries, and appeal to this court of claims, which the Lord Chief-justice Santry declared was like the Usurper's high court of justice, arbitrary and unlimited; and the English complained that the natives, by this illegal court, were made innocent, though they were known to be deeply concerned in the rebellion; for that it was beyond all peradventure that not ten of the Irish Papists were free from rebellion and murder, and most of them stood indicted and outlawed for treason, and therefore despaired upon their trial at the bar to make any considerable defence: upon this, a new act was prepared to explain the former; but Talbot (after Tyrconnel) being made a principal agent for the Irish, and they insinuating themselves into the favour of Rainsford (afterward made a judge in England for his good services in Ireland) and the commissioners of the court of claims, it so fell out, that though it was believed, upon the King's restoration, there could not have been the twentieth part of Ireland gained from the English, yet, by recommendatory letters and other stratagems of the court in England, there was almost an half of the kingdom in value lost, and at the same time the most innocent Irish lost their estates, and the greatest rebels got twice more than they had before the rebellion began; to such a height was Popery already grown, which so far encouraged the Irish, that they often told the English, that in a short time the Protestants must be all of their religion.


In 1669, the Lord Roberts was made Lord Lieutenant of Ireland, but soon recalled, and John, Lord Berkley, was sent in his room.


In 1670, the Papists set up a pretence that the King, when in exile, had engaged to the French King to restore the Irish to their religion and estates, which not being done, might occasion a breach with that crown; whereupon commissions were sent to Irish Papists to make them justices of peace, in which office they soon discovered themselves to be so partial and insolent, that their proceedings were abhorred, not only by the Protestants, but the most thinking Irish.



---

p.63




After this, there was a design for regulating the corporations of Ireland, and the Popish party began with Dublin, where, without any legal proceeding or pretence, seven of the Aldermen, and Sir William Davis, the Recorder, who were opposite to the Romish party, were turned out in a tumultuous, irregular manner, and seven of the rabble put in their places; and Sir Ellis Leighton, the Lord Lieutenant's secretary, was made Recorder; and Papists were daily brought into the common council, to the great terror of the citizens, who plainly perceived that the design was apparently levelled at the foundation of the Protestant interest and religion, and for introducing Popery and arbitrary power: in which opinion they were confirmed by some passages that happened about the same time, particularly that Talbot, the Popish Archbishop of Dublin in 1672, desiring of the Lord Lieutenant to borrow the hangings of the castle, silver candlesticks, and other plate, to be used at high mass, they were sent by Sir Ellis Leighton, with this compliment, that he hoped to have high mass by Christmas at Christ-church: to effect which, soon after an horrid plot was discovered, whereby all the Protestants were to have been barbarously murdered; and the signal appointed to distinguish the Irish from the heretics, was a cross of straw, which the priests earnestly enjoined every one to fix over their doors, telling them the omission thereof might be their ruin; for where the cross were not found, they would be destroyed as heretics: but this horrid conspiracy being happily discovered, upon search small crosses of straw not easily perceived, were found on the houses of most of the Irish in the province of Munster: but the government of Ireland was at that time so Popishly inclined, that they would not encourage the further discovery thereof; and those that appeared earnest in laying it open, had their cattle stole, and were threatened to have their houses burnt, so that the whole villainy was hushed up in silence.


In 1673, the Earl of Essex was made Lord Lieutenant of Ireland, the proceedings in the former year being thought by courts of England too barefaced. This worthy and prudent governor managed affairs with so much skill and integrity, that the Papists could hope for no advantage whilst he held the sword; therefore one Sheridan and Edward Coleman were thought fit instruments to embarrass affairs, and manage the Catholic interest; but by the unparalleled conduct of this prudent Earl, he so far outvied the Romish politics, as to cajole that party into an approbation of those proceedings, which proved fatally destructive to their designs; of which at length the Duke of York was so sensible, that he became his inveterate enemy, and set



---

p.64




up private designs against him, and at length prevailed to have him recalled; and in 1677 the Duke of Ormond was again sent Lord Lieutenant thither.


This year the Papists set up another project, which was that the French should make some new demands for the Irish, upon pretence of the articles made by King Charles II. in their favour, and the King of England was to admit the French to land men: the Earl of Tyrone, the Lord Brittas, and others, were also to raise men in Ireland, in order to make a diversion to the putting the Popish plot in force in England; and an insurrection was designed at the same time in Ireland. The King was unacquainted with the chief part of the contrivance, the Duke of York having undertaken to qualify him, if he should hear of the Irish intrigue; but this was divulged by some of the Irish, and the King was hardly prevailed with not to believe it: at length the King and council, fearing some danger from Ireland, the Duke of Ormond was sent thither, and the Duke of York did not think it seasonable to oppose it, but yet prevailed so powerfully with the King, that he sent orders for raising men in Ireland upon pretence of foreign service: they were all Papists, except some officers who were ready to be so, but the Lord Lieutenant would not deliver them arms, so they were exercised with sticks.


The next year, 1678, the Popish plot was discovered in England, and soon after that in Ireland, which was detected by those of their own party and religion, not one Protestant appearing as evidence against them; upon which orders came from England for disarming all Papists, but their friends at court had given them timely notice to conceal them, so that not above 150 arms were found among all the Papists in Ireland, they hiding them in bogs and other secret places without any damage. The Lord Brittas and others escaped into France; the Earl of Tyrone was committed to the Gate-house; Talbot (since Tyrconnel), with his brother, the Popish Archbishop, were imprisoned in Dublin Castle, where the last died; the Duke of York was sent to Flanders, and all things appeared so discouraging, that an Irish lord swore a great oath, that he believed Jesus Christ was a Protestant, for that nothing they could do did prosper.


The Parliament of England were very busy in searching into the bottom of the Popish conspiracy, and found many great persons concerned therein: several Papists were executed for the same, but still the court endeavoured, by all manner of arts, to obstruct any further discoveries, the Duke of York's interest still prevailing, who was come from Flanders; but upon the sitting of the Parliament was



---

p.65




obliged to go to Scotland, from whence he sent private encouragements to the Irish Papists, not to despair of retrieving all again: but the English there were very secure, as judging themselves happy under the peaceable government of the Duke of Ormond, and their interest in Ireland seemed more firm than ever, because they were of opinion that this late conspiracy of the Irish would prevent the King's *showing* them any kindness for the future: the Lord Lieutenant likewise procured a grant for calling a Parliament there, the news whereof so alarmed the Duke of York, that he came with all speed from Scotland to prevent it, which he likewise effected, and the Irish afterward boldly affirmed, *That there would be no Parliament till the Duke came to the crown;* which they seemed to believe would be very shortly; and accordingly the death of King Charles the Second happened in February, 1684, following, which still remains a mystery, though the Papists in Ireland for some time before could fix upon the utmost period of his life: and now the long looked-for day was come, which so transported them after all the dangers and difficulties they had met with, that they could hardly contain their joys within any bounds.


So soon as King Charles II. was dead, the Duke of Ormond was removed from the government of Ireland, and upon his arrival in England, found King James inclined to such violent courses, as, it is thought, broke his heart, he dying soon after. Before his going, he called his officers of his army together, and taking a glass of wine in his hand, ‘Look here, gentlemen (says he), they say at court I am now become an old doting fool; you see my hand doth not shake, nor does my heart fail, nor doubt I but I shall make some of them see their mistake.’


The Lord Primate and the Lord Granard were now made Lords Justices of Ireland; but the daily reported insolences of the Irish nobility and gentry, as well as the commonalty, soon made them weary of their government, for they repaired in great numbers to Dublin, and in all places reproached and abused the English with the most impious calumnies and reflections; and those that refused to drink confusion to all Protestants and their religion, were seized with warrants, and threatened to be murdered. The defeat of the Duke of Monmouth in 1685 heightened their rage more, and made them contrive hellish plots against the lives and estates of the Protestants, under the pretence that they designed to massacre the Irish, though they themselves knew too well that such an horrid attempt was as impossible as ridiculous, if any should have been so villainous



---

p.66




to have contrived it, since in the most parts of the kingdom the Irish were vastly more numerous than the English; nay, in some counties an hundred families for one.


After this, Tyrconnel began to model the army and disarm the Protestants, upon pretence that Monmouth's rebellion had infected many, and might delude more in that kingdom; and the Irish declared, that if any arms were found in the Protestants' hands, they would be judged persons disaffected to the King and his government; which so affrighted many, that they brought in their own arms, and delivered them up to the Papists: after which Tyrconnel went to England, accompanied with one Neagle, a cunning Irish lawyer, who published an account of the injustice of the act of settlement, reflecting with all manner of invectives against King Charles II. But matters being not ripe enough in England, King James did not think it convenient to propose Tyrconnel for Lord Lieutenant at present, and therefore it was contrived by the Popish Cabal, that the Earl of Clarendon should go over Lord Lieutenant, and Tyrconnel Lieutenant-general of the army.


When the Earl arrived there, the English were much discouraged, because of his relation to the King; but their hopes were extremely revived, when they found him acting with inviolable integrity to the Protestants. The Irish grandees were very little concerned at it, proceeding still with all violence in ruining the Protestants' interest, and animating their vassals with hopes that he would soon be removed, the Irish composing barbarous songs in praise of Tyrconnel; and that his heroic hand should destroy the English church. They declared publicly, ‘That they liked no government but that of France, and that they would make King James as absolute as King Lewis; that they would shortly have the English churches and houses, and if they suffered them to live, would make them *hewers of wood, and drawers of water*; that Ireland must be a Catholic country, and that they would make the English as poor devils as when they came first thither:’ and of this they were so confident, that the most serious amongst them privately advised their Protestant friends to change their religion; ‘for,’ said they, ‘you will be forced to do it in a while, and if you delay a little time, it may be too late; and perhaps you may not be accepted, for no Protestant must expect to enjoy any thing in this kingdom, and we resolve to reduce all things to the state they were in before **Poinings's act**, in King Henry the Seventh's time.’ Yea, King James himself and his followers used to say, ‘That the Irish must be restored to their former power, estates, and religion in that kingdom;’



---

p.67




and when the English objected that their proceedings were arbitrary and against law, they called them traitors, crying, ‘Damn your laws, it is the King's pleasure it should be so; and you are all a company of rebels, because you are not of the King's religion, and will not own his will and pleasure to be above all laws.’


But the English Roman Catholics were not so confident of their game, so that in a general meeting of the chief of them at the Savoy, before Father Peters, they seemed very doubtful of the King's capacity or willingness to expose himself to the hazard of securing the Catholic religion in his reign, considering his age, and the almost insurmountable difficulties they were to encounter with to effect it; and therefore moved the King, that their estates might be secured by an act of Parliament, with liberty of exercising their religion only privately: but Peters opposed this, as a consideration too worldly, adding, that if they would pursue his measures, he doubted not to see the holy church triumphant in England. Other Papists desired the



---

p.68




King they might have liberty to sell their estates and retire into France, and by his intercession might be provided for in that King's dominions: to which he replied, ‘That before their desires came to him, he had often thought of them, and had, as he believed, provided a sure sanctuary for them in Ireland, if all those endeavours should be blasted in England, which he had made for their security, and of whose success he had not reason to despair;’ adding many zealous expressions of his extreme kindness for the Catholic church; as, ‘that he resolved rather to die a martyr, than not to settle the Roman religion; and that he would choose to die the next day, that design being compassed, rather, than live fifty years without effecting it, having already been almost a martyr for the Catholic cause, which had been the occasion of all his troubles.’


In pursuance of these resolutions, the King gave himself wholly up to the conduct and counsels of the furious Jesuits, being entered into their society, and was become a lay-brother of that order, and consequently judged it meritorious to extirpate and destroy heresy, especially being told, ‘That it would be a most glorious action, and that no doubt he would be canonized for a saint, if he could reduce three kingdoms to their ancient obedience to the holy see, from which they had been so long apostates, and had nursed up so many damned heretics, to the disturbance of holy church.’


But the present Lord Lieutenant being an obstacle to the vigorous progress of Popery in Ireland, the Jesuits resolved to remove him, of which design a person of honour acquainted the King, who absolutely denied there was any such intention, or that he had any thoughts of it, nor did believe he ever should (whilst both lived) remove him from that government, though the Papists in Ireland confidently affirmed, that he had before given assurance to Father Peters, that Tyrconnel should be Lord-deputy; and accordingly, in 1686, he obtained that government against all opposition, the news of which so surprised the Protestants in Ireland, that almost all that were able deserted the kingdom, and flocked in great numbers to the Isle of Man, Scotland, and other places, so great was their terror and consternation at these dreadful tidings, and the dismal effects which they expected from his management of affairs. At length Tyrconnel arrived there, after having been kept a considerable time at the sea side by contrary winds; which seemed a signal act of providence, to give warning and opportunity to the people to fly from the judgments just ready to fall upon that distressed kingdom. The Lord Clarendon surrendered the sword to him, with an admirable speech, concluding, that as he had kept an



---

p.69




equal hand of justice to the Roman Catholics, so he hoped his Lordship would do to the Protestants: but Popery was the scene which must be acted, and the Protestants trembled at the terrible consequences thereof, whilst the Irish triumphed and insulted over their dejection, reproaching them both as Englishmen and Protestants, and usually calling them fanatic dogs, and damned heretics: yea, so barbarous were their affronts and indignities, that the English were daily afraid of a general massacre, to be inhumanly put in execution against them.


Tyrconnel now places Popish judges and officers in all the courts of judicature; and then proceeds against the charters of all the cities and corporations of the kingdom: He endeavoured to persuade the Lord Mayor, Aldermen, and Common Council of Dublin to surrender theirs to the King; but meeting with much opposition therein, he in a rage told them, ‘that this was the continuance of their former rebellion, having turned out all the loyal subjects in the last war of Ireland, and would do so now, if it were in their power;’ whereupon they produced a letter from King Charles I. dated at Oxford, containing great acknowledgments of their signal loyalty and faithfulness to him, with high assurances of being eminently rewarded, if he were again restored to his crown: but this availed nothing; for the common saying of the Irish was, ‘that King James would regard no man for any service formerly done to him, his father, or brother; but only for future service that he expected from them.’ So that though the citizens of Dublin sent a gentleman on purpose to the King with a petition, and representation of their case, yet he would not regard him; but upon first sight asked him, if he had the Lord-deputy's leave to come with this petition; and that he had those in Ireland that understood the law better than himself, and so turned from him; and he was forced to go back again, re infecta. Yet the city of Dublin was resolved not to betray their liberties; but employed the council to defend their charters; but these judges who had already broken through all *enclosures* of law, and trampled upon the known constitutions of the kingdom, that they were opposite to their Popish and arbitrary designs, over-ruled all their pleadings, and gave judgment against them, to the universal excessive joy of the Irish; and great mortification of the Protestants. Consonant to the sentence against Dublin, was judgment given against all the charters of the kingdom, except those who quietly surrendered them.


The new Lord-deputy now chose him a privy council, that, all but three, had scarce common sense, of which two of them would often complain, saying, that nothing could pass at the council-board of public



---

p.70




concern, but their countrymen must first ask Teige, ‘if that would not spoil his potatoe garden;’ but, however, they all agreed to enslave and beggar their country, especially in matter of trade, as appeared by Tyrconnel's first proclamation, with the advice of his council, to break an act of Parliament in taking off the duty of iron, and this without asking the King leave; but as soon as it was heard of in England, a proclamation came from thence, forbidding this wise act made by these notable statesmen; and the Lord Bellasis swore in council; ‘That fool in Ireland, was fool and madman enough to ruin ten kingdoms:’ and Father Peters secretly reprimanded him for his political blunder: and *wrote* to him, if he acted not with greater caution, the King could not possibly preserve him in that government. This, with the vast numbers of people that deserted the kingdom upon Tyrconnel's coming Lord-deputy thither, whereby the towns and cities were made almost desolate, and traffic so ruined, that the public revenue was sunk incredibly from the former value, were so strongly pressed against him at the English privy council to his disadvantage, that he obtained the favour of King James, to meet and confer with him at Chester, carrying along with him Judge Rice for his counsellor, and a subtle fellow, who told the King so many fine stories, there being none to contradict him, that he was dismissed, contrary to the hopes and expectations of many who thought he would never have returned again, Lord-deputy. When he took leave of several privy counsellors and officers at his going to wait on King James at Chester, Aug. 1687, he said, *‘I have put the sword in your hands:’* and then, in his usual *style*, *prayed God to damn them all, if ever they parted with it again.*


During Tyrconnel's stay here, the new judges went their circuits, wherein they discovered the most gross partiality imaginable; for though they found the jails full of Tories and Irish robbers committed for several notorious crimes, yet with the assistance of Irish sheriffs and juries, they were most of them discharged, without punishment, either being indicted by wrong names, or else by taking off the prosecutors with threats; that if they proceeded, their cattle would be stolen, their houses burned, or their throats cut, which often happened: and this was done in pursuance of one of the Lord-deputy's instructions from court to them; that they should by all possible means weaken the Protestant interest, which they so effectually performed, that no Englishman was secure of any thing he had, by their exorbitant proceedings against them: so that had these barbarous injustices, and public oppressions and violences in the several law courts (even
such as never were till then heard of among Christians) continued but



---

p.71




a few years longer, these, without other means, might have wholly reduced the kingdom into Irish hands; it being observed, that never one cause came before them upon a trial for land, but the judgment was constantly given in favour of the Irish.


As to the army in Ireland, of which I have mentioned something before, I shall add, that when King James came to the crown, they consisted in about 7000 men, as cordial to his interest as possible, both officers and soldiers respecting him as their master and father; and *showed* a great forwardness to have assisted him against Monmouth and Argyle: yet he was no sooner settled in the throne; but he began to turn the most zealous of them out of his service; because he could not expect they would be useful to him in destroying the Protestant religion, and liberties of the subjects, which was the service he expected from them; and therefore took their troops away, and gave them to persons of mean or broken fortunes, and some of them unqualified by law, and no consideration was had to loyalty or merit, unless a man were a Papist; of which there were too many notorious instances: and the manner of them being discarded, was with so much falsehood and barbarity from Tyrconnel, as might have shaken the obedience of any army but this in the world; and caused them to have dispatched so false a wretch, for in the morning he would take an officer into his closet, and with his usual oaths, curses, and damnations, would profess the greatest kindness and friendship, assuring them of the continuance of their commissions; and in the afternoon, would cashier them with all manner of scorn and contempt; nay, while he was caressing them, he had actually given away their commands. As for the soldiers and troopers, he marched them to some place so far distant from their quarters, that they were not much known; and there, after great hardships, stripped the foot of their clothes, which they had *paid* for, and the troopers of their horses, boots, and furniture, bought with their own money; and turned them off to walk barefoot some 100 others 150 miles to their houses and homes: and though they were promised something for their horses; yet their attendance cost them twice as much as they expected, and most of them, after all, got nothing; by this means 2 or 300 Protestant gentlemen, who had laid out great part of their fortunes, and contracted debts to obtain commissions, were not left worth any thing; but were turned out without reason, or any consideration, and 5 or 6000 soldiers sent a begging; an hardship perhaps, never put upon an army before, for no other reason, but because they were Englishmen and Protestants; and Irishmen and Papists were by King James put in their places, clearly demonstrating,



---

p.72




that he had no regard to the laws, or the preservation of that kingdom; and that he absolutely designed to ruin the Protestant, and advance the Popish interest in Ireland: and the same fate attended all the Protestant civil officers, several of them being outed, though they had places by patent for life, sheriffs, justices of peace, officers of the revenue, &c. who were all changed for Roman Catholics, and this before the news of the glorious expedition of his now Majesty, the Prince of Orange, and without any provocation, or the least pretence of disloyalty.


Dec.. 9, 1687, being Sunday, in the morning, happened such an inundation of water at Dublin, as was never known before, carrying away stone bridges, overflowing houses, for three days together, so that a great part of the city was much endamaged thereby to their great detriment and loss, and was the more remarkable; because no great rain, only a few small showers, had fallen the night before; which seemed to presage the deluge of troubles that were impending over the poor English in that distressed kingdom.


The Earl of Castlemaine being returned to England, from his embassy to the Pope, and having received no preferment, complained to the Pope, who *wrote* to his Nuncio to address the King in his behalf; and being seconded by Father Peters, it was resolved in the cabinet council, Dec. 23, that Jefferies, the Lord Chancellor, for tampering in the business of Magdalen college, should be put out, and three of the lords of the treasury, be made lords commissioners of the great seal, and that Castlemaine should be lord treasurer, Peters roundly telling the King, ‘that the most effectual means for accomplishing his design of establishing the Catholic religion, was to let his prime ministers, and the world understand, that no service they had or could do should protect them, or be reckoned of any account, if they boggled in the least tittle or circumstance relating to the Catholic cause.’


But still the furious Jesuits and their accomplices were very much unsatisfied, that, notwithstanding they had a Catholic King upon the throne, yet the Popish religion made but small progress, and there was but a mean harvest of converts to the Roman faith; nay, not in Ireland, where all the power both civil and military was in their hands; hereupon a project is contrived to destroy the act of settlement there, in hopes the Protestants would rebel, and forfeit their estates, whereby they should have an opportunity totally to extirpate them out of that kingdom; and so be in a capacity, in a short time, to subdue England and Scotland likewise: in order hereto the Lord Chief-justice Nugent, Lord Chief-baron Rice and Neagle, drew up the form of an act, which, 



---

p.nn




---

p.73




in the nature of it, gave the whole lands of Ireland into the hands of the King, and though the Catholics were to have but half their estates, yet the other part was under such qualifications, as the King might dispose of them to those who were most obedient and useful to him: this was brought over by these three, who were called the Irish ambassadors, and at length approved of by Father Peters, and presented to the King with strong assurances; that if he would but call a Parliament there, they could have whom they pleased elected, all corporations being already put into Popish hands, and all the sheriffs of counties, Papists; who would be sure to make returns as they thought fit.


King James, who was become a vassal to the French King, durst not refuse their proposals, for fear of disobliging him; and having (as he constantly did) debated it in the cabinet council, it was resolved to be brought into the privy council, which the King did accordingly; and being read, the Lord Bellasis passionately inveighed against it, saying; ‘That if such designs as these were encouraged, the Catholics of England had best in time look out for another country, and not stay to be made a sacrifice for Irish rebels.’ Others seconded it, and none durst offer any thing in behalf of it; afterwards the three Irish ambassadors had audience at the council, where Rice spoke in the behalf of the rest; but the Lords Bellasis and Powis called him fool and knave, even in the King's presence: Bellasis bidding them make haste to the fool their master, and bid him, the next message he sent, to employ wiser men, and upon a more honest errand; and every one fell so violently upon them, that they kissed the King's hand and departed, he himself not speaking a word; but instantly breaking up the council: and the noise of their business being known abroad, the boys in the streets run after the coach, where Rice and Nugent at any time were, with potatoes stuck in sticks, crying out, ‘make way for the Irish ambassadors.’


In 1688, the joyful news of the birth of the supposed Prince of Wales arrived there, about the same time with that of the imprisoning the bishops in the Tower, which filled them with such exultations, that they could hardly bear it, glorying, ‘they had now a Prince, who would become a patron to holy church, and perpetuate the Catholic religion to all posterity, by the utter extirpation of heresy.’ It is remarkable, that as soon as ever it was publicly declared the Queen was with child, the Irish throughout the nation were so confident that it would be a son, that they offered to lay twenty guineas to one of it; which the English were very sensible they would never have ventured,



---

p.74




had they not been acquainted with the mystery of it. And now they express their rejoicing with bonfires, bagpipes, drinking and revelling for several nights together, forcing the English to come out of their beds, and to drink the King and Prince's good health, with confusion to their enemies, upon their knees; which they well understood were the Protestants: and such as would not comply, were called fanatic Oliverian dogs and they hardly refrained from murdering them; and the officers of Christ-church were committed to the stocks, because Tyrconnel fancied that the bells did not ring merrily enough on that occasion.


But the Scripture says, *the joy of the wicked is short,* and so their's proved; for a while after a ship came from Amsterdam to Dublin, with letters from a friend of Tyrconnel's, to acquaint him, that he did imagine the Prince of Orange had a design against England, since none in Holland could guess what else the great and hasty preparations made there should mean; Tyrconnel sent this letter to the secretary of state, who *showed* it the King; but they made no other use of it, than to scorn and ridicule his intelligence, as the secretary did in a letter sent back to him: but fresh suspicions daily arose, and the matter seemed still more probable; whereupon the huffing Irish called the English, rebels, saying, they were sure they would join with the Prince, and as certain that they would be beaten, and be served the same sauce as Monmouth was; and bloodily and maliciously expressed themselves against the Prince, whose head they threatened to stick on a pole, and carry it round the kingdom; and after King James's proclamation came to them, Lord Chief-justice Nugent, that confident, ignorant Irishman, in his charge to the jury, among other villifying reproaches upon the Prince of Orange, audaciously and impudently added; ‘that now the states of Holland were weary of their Prince, they had sent him over to be dressed as Monmouth was; but that was too good for him, and that he doubted not before a month passed, to hear that they were hung up all over England in bunches, like ropes of onions.’


At the time of his present Majesty's descent into England, the Popish army in Ireland were about 8000, whereof near half were sent into England to assist King James, and the others were dispersed up and down the kingdom; being but an handful in comparison of the Protestants, who had arms enough in Dublin alone, to have mastered them; and it was proposed by some (when they heard the King had sent commissioners to treat with his Highness the Prince of Orange) to seize the castle of Dublin, with the stores and ammunition, which



---

p.75




had been very feasible, by securing Tyrconnel, who had only 600 men to guard him; and they, by the continual expresses from England, of the wonderful progress of the Prince's forces, were so generally discouraged, that they declared themselves desirous to lay down their arms, proposing to themselves, only to remain in the same condition they were in King Charles II.'s time, and Tyrconnel himself commanded the Protestants to signify the same to their friends in England, that he was willing to part with the sword upon those terms, with King James's leave; for though he received the first news of the Prince's landing with the greatest disdain and contempt, boasting, that he was able to raise an army of 100,000 men, on a month's notice, and gave commissions to every one that would accept of them, yet the additional accounts of his Highness's daily success raised such a consternation in him, that by all his actions it did sufficiently appear he had no thoughts of standing out, and all his discourses expressed his disordered and ill apprehension of the present tendency of affairs; which was much increased by the dreadful alarm that the Protestants had, from a letter sent to the Earl of Mount-Alexander, giving him an account of an horrible massacre designed upon the Protestants on December 9, being Sunday; the letter came to Dublin the Friday before, and the news thereof so terrified the Protestants, that the next day above 3000 got away into the ships that were in the harbour at that time; which were so crammed, that they were ready to be stifled, deserting their houses, and all that ever they had in the world, and running to the ships with scarce clothes on their backs, and went to the Isle of Man, England, or the north of Ireland; such strange confusions and distractions did the dread of the barbarous and cruel usage which they feared from the Irish produce, many of them having been eye-witnesses of the horrid murders and ravages committed by them in 1641.


Tyrconnel having notice of this sudden hurry, on Sunday morning, sent two Protestant lords to persuade the people not to go away, and ordered a yatch to fetch back them that were gone; but both proved ineffectual: he then sent to some of the principal Protestants in Dublin assuring them with many oaths and protestations, that he had an utter abhorrence of any such design as massacring the Protestants, and begged them to persuade their friends not to remove: the dreadful tidings arrived at other places in Ireland, that very Sunday morning, while the people were at church, and struck them with such horror and amazement, for fear of present destruction, that many for haste got out of the windows, others were ready to be squeezed to death at



---

p.76




the doors, many left their hats and perriwigs behind them; yea, the clothes on their backs were torn to pieces in the crowd, others were trampled under foot, and the women in worse condition than the men: nay, for several Sundays after, the Protestants carried arms with them to church, the minister himself being armed while preaching. Whether the design was real or no, or whether this discovery prevented it, is not known; but certainly the dread of it produced the greatest horror, grief, and despair, that human nature could be capable of.


In this consternation things continued till January, when advice coming of King James's flying to France, the Irish Lords moved Tyrconnel to deliver up the sword, which many thought he would have been easily persuaded to, since at the beginning of the alarm it was believed that he would be the first man in the government who would endeavour his escaping, having already packed up most of his goods of value, and shipped some of his treasure. His whole council were of the opinion that he should surrender, and he finding himself so very weak, and so much in the power of the Protestants, protested to them with the deepest oaths and curses, according to his usual acts of dissimulation, falsehood, and flattery, ‘That he would be rid of the government very willingly, so as it might be with honour; that it was easy for him to ruin and destroy the kingdom, and make it not worth a groat, but impossible to preserve it for his master.’ At another time he told them, ‘That he could not deliver the sword with honour till it was demanded, and asked them whether they would have him throw it over the castle wall, for there was none to take it?’ Some imagined that he intended in earnest to have parted with it, especially if it had been demanded before King James went into France; having likewise before procured letters to be sent to England, to excuse the mal-administrations in the government; ‘and that it was the opinion of all the Catholics that the kingdom would be ruined, and themselves also, if they yielded not to the Prince of Orange; that they would be contented to be reduced to the same state they were in when King James came to the crown,’ &c.


But after all, the generality of the Protestants were of opinion that he meant nothing less, only designed to gain time and delude them till he had got a kind of an army together to master them; and they were confirmed therein by his secret giving out 500 commissions of one sort and another in a day. The Irish likewise assembled in great bodies, and were called Rapparees, armed with skeines and half pikes, killing the cattle of the English, and stealing an hundred or two at once in



---

p.77




a night, so that many substantial Protestants, who owned several hundreds of black cattle and sheep, &c. had not one left; and for forty miles together in the province of Munster, the Irish cabins were full of beef stolen from the English, which they did not so much as bestow salt upon, but hung it up in the smoke, so that it looked and stunk as bad as carrion: it was affirmed, that in nine days the Irish stole 11,000 cattle in that one province, and at length, to complete the miseries of the Protestants, they robbed and pillaged their houses, so that those who had lived in great hospitality and plenty, now wanted bread to eat, and had nothing left to preserve them from starving.


All this while the new levies were mustering every day, the priests putting off their wolves' clothing, and with their swords and perriwigs turned commanders, and exercised the Irish soldiers. All the scum and rascality of the country were made officers; *everywhere* Papists enlisted themselves, and the priests suffered no man to come to mass, that did not arm himself with a skeine and half pike; the better sort of their captains and inferior officers had been footmen or servants to Protestants, most of them sons or descendants of the rebels in 1641, who had murdered so many Protestants; many were outlawed and condemned persons for torying and robbing; no less than fourteen notorious Tories were officers in Cormuck O'Neill's regiment, and these new commissioned officers were obliged, without pay, to subsist their men (as they called it), being between forty and fifty thousand, for three months, a thing impossible for them to do, since most of them were not able to maintain themselves; which gave mortal apprehensions to the Protestants, who had reason to fear the destruction that immediately fell on them, when they saw their enemies in arms, and their own lives and goods in the power and at the mercy of those thieves, robbers, and Tories, now armed and authorized, from whom they could scarce secure themselves, when it was in their power to pursue and hang them: and this was acknowledged by one of their own justices, who, in his charge at the quarter-sessions, declared, ‘That among other conveniences which they received from this government, one was, that it had rid them of Tories, for all these were taken into the King's army.’


Tyrconnel and his council were still in amaze and confusion, and all unanimous to submit, except Nugent and Rice; but on a sudden they came to a conclusion that might quiet the Irish lords, who were for submission to the Prince and government of England; and the project was, that the **Lord Montjoy**, a Protestant, and the



---

p.78




Lord Chief-baron Rice, should be sent over to the late King James in France, to represent to him ‘the impossibility of their holding out against England, and the necessity to yield to the time, and make the best terms they could, till a better opportunity presented to serve himself of his Irish subjects.’ This was a Jesuitical stratagem, contrived by Rice and Neagle, as one of them afterward boasted, carried on without the privity of any but the Lord-deputy and themselves; and every body told the **Lord Montjoy** that it was all sham and trick, only to amuse the Protestants, and remove him out of the way, who was most likely to head them: yet the Lord Tyrconnel swore most solemnly, ‘That he was in earnest in this message, and that he knew the French court would oppose it to the utmost, who regarded only their own interest, and did not care if Ireland were sunk into the pit of hell, so they could give the Prince of Orange a diversion but for three months; but (said he) if the King be persuaded to ruin his fastest friends only to gratify France, and do himself no service, he is neither so merciful nor wise as I believe him to be. If he recover England, Ireland will fall in course; but he can never expect to conquer England by Ireland: if he attempts it, he ruins Ireland to do himself no kindness, but rather to exasperate England the more against him, and make his restoration impossible;’ intimating, ‘that if the King would not do it, he would look on his refusal to be forced on him by those in whose power he was, and that he should think himself obliged to do it without his consent.’ The **Lord Montjoy** alleged, ‘That his going into France could not influence the councils in England, who could reduce the kingdom without his assistance; and that he must either obey the Deputy, or declare war against him and King James's interest; which he did not think safe, since he had no order nor encouragement from England; but, on the contrary, all the advice he had from thence was to be quiet, and not to meddle; that he was obliged to King James, and neither his conscience nor gratitude would permit him, in his present circumstances, to make war on his own authority against him, whilst there was any possibility of doing the business peaceably.’ Upon these motives, **Lord Montjoy** proceeds in this negotiation, and took shipping with Rice at Waterford in January, 1688, Tyrconnel having first granted these general concessions to the Protestants: ‘1. That no more commissions should be given out, nor new men raised; 2. that no more of the army should be sent to the north; 3. that none should be questioned for what was past; 4. that no private house should be obliged to quarter soldiers.’ These he sent about the kingdom by letters; yet the **Lord Montjoy**


---

p.79




was no sooner gone, but, according to his usual falsehood, he denied all, and was angry at the dispersing the letters. Soon after came news that the **Lord Montjoy** was made a prisoner in the Bastile in France, which more exasperated the Protestants against King James as a violator of public faith to his subjects, and likewise ruined the little reputation that his Lord-deputy had among them.


Soon after, a French engineer landed at Cork, and came with all expedition to Dublin, assuring Tyrconnel that King James would be suddenly with him, and that nothing was to be feared from England till the end of the summer. Upon this the face of things quickly altered, and the little hopes that had hitherto supported the English, now utterly vanished, so that there appeared a necessity of associating together, and getting into the castles and best places of strength they had, for the defence and preservation of their lives. Some Protestants had, a while before, put themselves into a posture of defence in the north, &c. but proclamations were issued out by the council (signed by several Protestants commanding them to go to their respective homes, under the penalty of being proceeded against as traitors, which proved fatal to the English, they judging thereby the danger was not so great as they imagined: but at length matters were reduced to such extremity, that no course remained to preserve the Protestants, but of making their escape; for though the Lord Kingstone, Sir Arthur Royden, and others, endeavoured to have secured several places, yet matters were managed so indiscreetly, that all proved ineffectual, and their inconsiderable forces were soon defeated; after which, Tyrconnel disarmed all the Protestants throughout the kingdom in one day. In the cities and towns they shut up the gates, and none were suffered to pass in or out, without being strictly searched for arms; under pretence of which they also came into the English houses, and often seized on their plate and money, or what else they could meet with in this confusion, which lasted several days, during which, most of the horses which belonged to English gentlemen and farmers were seized in the country for the King's use; which were brought into the towns, where the soldiers were quartered in so great numbers, in private as well as public houses, that the English had scarce beds to lie on.


About this time, Colonel Hamilton is sent with an army to the north of Ireland, and though more early in the year than usual, yet the judges were sent into the country, on pretence to punish the thieves and robbers that plundered the Protestants; but the design was to condemn those poor Protestants that had taken up arms, and



---

p.80




defended their houses against them, and likewise to raise money for the army, there being very little in the Exchequer: and the judges read a letter in every county, directed from the government to the principal gentlemen, and to the minister and Popish priest of every parish, requiring them to summon their parishioners together, and persuade them to subscribe to the utmost of their ability, for the subsistence of the King's forces, assuring them that he would be soon at the head of them, with a considerable assistance from France; and that they who had no money, should send in meal, malt, beef, cheese, butter, herrings, or else leather brogues, stockings, wool, cloth, linen, or any other goods the country afforded. This was a great oppression to the Protestants, who, though they had but very little left by the rabble, yet must contribute largely, or else were reckoned well-wishers to the King's enemies.


The Lord Galmoy was likewise sent with forces to guard the passages between the north of Ireland, and those parts of Munster and Connaught that adjoined to Ulster, to prevent the south and western Protestants from joining, who being a malicious and bloody Papist, first drew blood there, causing two gentlemen who had taken arms for their own defence, under Colonel Sandason, to be hanged on a signpost at Belnahatty, and their heads being cut off, were kicked about the streets by his soldiers, like foot-balls; at Omagh he took two others upon the same pretence, and caused the son first to hang his father, and carry his head on a pole through the streets, crying, ‘This is the head of a traitor;’ and then the young man himself was hanged. It was also reported, that some of his dragoons meeting with a clergyman's wife, whose husband had fled northward, several of them, one after another, ravished her, and then ripped up her belly, and exposed her with a dead man upon her. At Tipperary, an English gentleman seeing some dragoons marching towards his house, shut up his doors (it being late in the evening), as if they were gone to bed; but sixteen of them coming thither, and not being quickly admitted, they forced open his doors, calling him traitor for shutting them against the King's forces; and having pillaged all things of value, they then deflowered his daughter and only child before his face; all sixteen lay with her, and three of them (as was affirmed by his family) after she was actually dead. These were the beginnings of the villainies which the Protestants suffered from these execrable wretches.


While things were in this posture, King James was hourly expected by the Irish, and almost every post a false alarm is given that he was landed, bonfires being made, and guns discharged in the several



---

p.81




garrisons: and that so often, that not only Protestants, but also many Papists, thought it to be but a sham of Tyrconnel's to discourage the Protestants, and obtain better terms from them: but at length, March 12, 1689, he landed at **Kingsale**, at which the Protestants and some Papists seemed not very well satisfied; nay, the first were so indifferent, that for a fortnight after he arrived, they would not believe it, because they imagined he had no great kindness for them: however, they thought he would have made their condition more easy for the present, and spoke them fair, considering that the Irish depended upon many friends which they boasted they had in Scotland and England. But King James soon let the world know he was not fond of such dependencies; for coming to Cork, where he was received by the mayor and aldermen in their formalities, the recorder, in a long speech, magnified the Irish loyalty and valour, saying, ‘That he now hoped his Majesty was convinced of their fidelity, and that they were better subjects than the church of England men.’ To this part of the speech the King replied, ‘That he acknowledged all the recorder had said to be true; and that he hoped, by their forces and the assistance he should receive from his brother of France, to be restored to his throne, in spite of those slaves of the church of England.’ At this very time the judges held the assizes there, and one Brown, a gentleman of about 500£ a year, who had been in arms against the Rapparees, being there a prisoner, he put himself on his trial, and petitioned King James, thinking that he would begin with an act of mercy, and give him his life; but, on the contrary, he left him to the law, whereby he was sure to be condemned, and accordingly was hanged and quartered. From hence King James took his journey to Dublin, where he was received with all demonstrations of joy imaginable by Tyrconnel and the Popish party, who looked upon him as their only support, champion, and deliverer. He was no sooner arrived, but the Irish discovered what his future designs were in their common talk at public houses, declaring openly, ‘That the King would have such a powerful army of French, Irish, and Scots Roman Catholics, as should force the English into obedience; that he did not think of returning into England by the means of any Protestant friends, but by a French power, so that when he came to his throne he might rule as he thought fit; that the Protestants of Ireland might feed themselves with what hopes they pleased, but they should quickly find the King would neither value nor regard them; that the King had a long time caressed the damned church of England (as they called it), and that he could do no good with them, but now he would do his business without them, and so find an opportunity of shaking them quite off; that they



---

p.82




did not doubt but to be in the midst of England by midsummer, and make that the seat of war, thereby preserving their own country, estates, and tenants, and living on the churls (as they called the English), who, they said, were rich, and a giddy, inconstant people, not being satisfied with any kind of government, and would, they doubted not, be soon divided and broken among themselves, so that they did not fear carrying their point.’


King James himself, by his discourses and actions, soon confirmed the same; for he had but two considerable Protestants in his army, Sir Thomas Newcomen and Colonel Russell. These he immediately disbanded, without any other objection but their religion, and declared to Colonel Sarsfield, who desired commissions for two of his


Protestant relations, and offered to be bound for their fidelity, *That he would trust no Protestant;* and was heard to say, as he came out of his chapel, upon occasion of some of his courtiers discoursing about Protestants, *That a Protestant stunk in his nostrils.* And as his words, so



---

p.83




his deeds discovered his abhorrence of them; for he had not been long in Dublin, when the wife of one Maxwell (who was condemned for betaking himself, with some others, to a strong house in Queen's County, for the security of their lives), presented a petition to the King to pardon her husband. This poor woman had, by her piteous entreaties, prevailed with the high sheriff to reprieve him for fifteen days, that she might use her interest to save him, though against the command of the bloody Lord Gilmoy, who ordered him to be presently executed: she accordingly went to Dublin, hoping that the King might be persuaded to do one act of grace, being just come to the city; and the high sheriff went with her, and promised her admittance to the presence, where she appeared in the most lamentable condition that was possible to excite compassion, having four or five small children hanging about her, all in tears, and delivered her petition, praying his Majesty to pardon, or at least to reprieve her poor husband for some time; which she delivered in such melting terms, as moved the very Irish nobility then present to second her request, and might have mollified the hardest heart in the world: but the answer she had from King James was, *Woman, your husband shall die;* and the high sheriff was severely reprimanded for not executing him according to his warrant, and threatened, that if the prisoner escaped he should die for him; and was commanded to hang him immediately, which was done accordingly. There are several other instances or this kind, and it may easily be imagined how great an encouragement this kind of behaviour in a prince was to the rude soldiers to treat the poor Protestants, not only in the country, but even in Dublin, under the very eye of the government, in a barbarous manner. It was ordinary with them to take the meat that the poor people had provided for their families, without thanks or payment; nor could a Protestant be abroad after sunset, without danger of his life. One Power, bred a Protestant, but turned Papist in King James's time, coming to his house one evening, was set upon by two soldiers, demanding his money, and calling him heretic dog: he thought to have excused himself, and made some opposition, but was shot through the body with a pistol, and fell dead, as well as unpitied, at his own door. About the same time, a gentleman walking in a bowling-green in Dublin, was stabbed by some soldiers; and a poor tapster of an alehouse standing one day at the door on the Wood Key, was by some dragoons thrown into the water and drowned, and no notice taken of it, but only as a jest: so that considering how the King and government did connive at things of this nature, and that all the Irish bear so implacable an hatred



---

p.84




to the English, and are a people of much cruelty, and forwardness to shed blood, when they have an advantage, and which, to be sure, was not lessened by their being managed by Frenchmen; I say, considering all these circumstances, it may seem very wonderful, that they did not attempt a general massacre, all the time before the English forces arrived there; but it must be attributed only to the Divine Providence (which restrains even the devils) that prevented these bloodhounds from destroying the poor Protestants, at whom they stood grinning, and wanted only the word to cut their throats, as they and their predecessors did in 1641.


King James, before his arrival in Ireland, had resolved immediately to call a Popish Parliament there, to destroy the act of settlement, and restore the Irish rebels to their estates; which he was so impatient in, that he issued out writs for them to sit May 7, 1689, at Dublin, though it seemed directly against his interest at this time; and many of his own party ridiculed him and his councils, to call a Parliament to spend their time in wrangling about settling the kingdom, and disposing estates before it was reduced to the King's obedience: but hereby it pleased God to infatuate them; for had they applied themselves to the siege of Londonderry, it is to be feared, that town, and others in the north, had been taken before the succours came, and then all Ireland had been their own; which might have been of very fatal consequence. For the Protestants, upon the orders that were issued through all parts of the kingdom, to take away their arms and serviceable horses, concluded that an English army was either landed in some part of the kingdom, or that the government expected one; which so encouraged the Protestants, that in many places they betook themselves into castles and strong holds, thinking that if they could defend themselves from flying parties and the rabble, the Irish army would be so employed by the forces of England, that there could be no formal sieges laid against them; and they should secure themselves with their horses and arms, till they might find an opportunity of joining with the English army: but these poor men soon after found their mistake, and thereupon were forced to surrender upon tolerable conditions, had they been observed: but the Irish, instead of performing them, sent them to jail, tried and executed several for high treason, and kept others in miserable captivity and slavery.


This vile treachery and severe usage encouraged the Protestants in the north, who were possessed of Londonderry, **Inniskillen**, and some other places, to defend themselves against the utmost efforts of the enemy: for Tyrconnel, as we have heard, having armed a rabble of 40



---

p.85




or 50,000 Irish Papists, to live upon the country without pay, from whence ensued miserable depredations, open and noon-day robberies, and an inevitable and sudden ruin of the British and Protestant interest in Ireland, the Protestants of the north thought themselves no longer under obligation to be active in their own destruction; but took up arms in defence of their laws, against those who acted in contradiction to all laws; and from whom they had reason to fear all kind of cruelty and barbarity.


It happened that the Lord Tyrconnel, having orders to transport 3 or 4000 of his Irish soldiers to England to assist King James, he took a particular care to send away the whole regiment, quartered in and about Londonderry; but soon saw his error, and endeavoured to repair it, by commanding the Earl of Antrim to quarter there with his regiment, who appeared before the town without the King's livery, or any officers of note, or the least warning of their coming; and having no other arms but skeanes, clubs, and such other weapons as Reams and Tories use; and this happening about the very time that the Protestants were alarmed with the letter sent to the Lord Mount-Alexander, concerning a designed massacre, the people of the town were so affrighted, that they refused them entrance into the city, and consulted their own safety, concluding to shut their gates. One of the companies were already in view of the town, and two of the officers in it; but the younger sort got together, and with their swords drawn, ran to the main guards; seized the key, drew up the bridge, and locked the ferry gate, though the Irish soldiers were advanced within sixty yards of it; from thence they went to secure the other three gates, and having placed guards at each of them, met in the market; so happily did these resolute youths nick the very minute of their design, and upon such a seemingly rash and desperate action did the preservation of that important place, and consequently, in some measure, the whole kingdom, out of the hands of the Irish, depend.


The alarm of the designed massacre, and Tyrconnel's arming such a numerous swarm of Irish highlanders, had the like effect upon the Protestants of **Inniskillen**; and knowing this was the only place of consequence upon **Lough Earne**, which had held out with remarkable courage against the Irish rebels in 1641, and which if they were now possessed of, would give them an open passage from Connaught to Ulster, they therefore resolve not to admit the two companies of Irish Papists, which were ordered thither to quarter in the town; but instantly dispatched letters to all the Protestant gentlemen thereabout, for their advice and assistance in that juncture; not judging themselves able to



---

p.86




keep out the two foot companies, they being but eighty dwellers in all, and few or no arms amongst them; the messengers returned with very little encouragement, most of the English dissuading them from the enterprise, as dangerous, the Irish being well provided of arms, ammunition, and provisions, whereas they had not ten pound of powder, nor twenty well fixed fire arms in the town: but the resolution of the people surmounted all these difficulties, resolving to run all hazards, rather than expose their lives to the mercy of their barbarous and bloody principled enemies; the Irish army approaching them within eighteen miles, they made fresh instances to their neighbours to come to their aid, promising that whilst they *stayed* with them, they should have free quarter for man and horse; whereupon several Protestants came into the town, with their best horses and arms, promising to stand by them in defence of their lives, and the Protestant religion; which they did believe, by the preparations they heard were making by the enemy, would be very soon invaded; and the news they heard from Londonderry did much fortify their courage: so that upon the approach of the Irish companies, the **Inniskillen** horse and foot advanced towards them; but came no sooner in view, ere the two companies, with the whole rabble that was with them, turned their backs and fled, without halting, in very great fear and disorder; and their officers being then at dinner at a gentleman's house not far from thence, hearing the **Inniskillen** men were come out, left their dinners before they had half done, and ran away after them, and all of them got the next day twenty-four miles off, in great terror of the **Inniskilleners**, who afterward performed many admirable actions against the Irish.


King James's pretended Parliament *sat* in Dublin, from May 7, 1689, to July 20, following, and in that short time, entirely destroyed the settlement of Ireland, and outed both the Protestant clergy and laity of their freeholds and inheritances, by repealing the two acts of settlement: ‘whereby two-thirds of the Protestants of the kingdom held their estates: and the real estates of all that dwelt or *stayed* in any place in the three kingdoms, who did not own King James's power, or corresponded with any such, as they termed rebels, or were any ways aiding, abetting or assisting to them from Aug. 1, 1688, are declared to be forfeited and vested by the King:’ by which clause, almost every Protestant that could write in the kingdom, had forfeited his estate; for the packets went constantly from London to Dublin, and back again, from August 1688, to March following, and few had friends in England or the north but corresponded with them by letters; and every such



---

p.87




letter is made, by this clause, a forfeiture of estate. They likewise passed an act of attainder, whereby above 3000 Protestants were attainted, and their estates forfeited to the King, some for being in arms; but the greatest part for absenting themselves, and going out of the kingdom.


These proceedings were thought very severe by the Protestants, since those that armed themselves did not attempt any thing, even against those whom the Lord-deputy, against the laws of the kingdom, and the interest of the nation, had entrusted with arms and employments, except in their own defence, when invaded and assaulted by them: neither was there one act of hostility committed, wherein the Protestants were not on the defensive: their crime then, if any, was only that they were unwilling to be robbed and plundered, as their neighbours were, without opposition; but disarmed some of those who under colour of being King James's soldiers, destroyed the country; this was all the reason Tyrconnel had to proclaim them rebels, for killing and murdering his Majesty's subjects, and with pillaging the country; whereas it was notorious, they never killed any but whom they found actually robbing, for killing of whom the laws of the kingdom not only indemnified them, but likewise assigned them a reward; and it is as plain, that the Protestants preserved the country from being pillaged: and for this they now forfeited their estates: as for those that were absent, it would have been unwisely done for the Protestants that were gone to England, to have returned again to a ruinous kingdom, the actual seat of war, where all the goods they had left behind were embezzled by robbers; and their estates given to those sons of rebellion in 1641, and when men of the best estates in Ireland wished themselves away; and many were content to leave all, and venture their lives in little boats, to the mercy of the seas in the depth of winter, reckoning any thing safer and easier, than to stay under a government which had effectually destroyed all the measures of right and wrong; and condemned so many gentlemen to the loss of all, without allowing them the favour either of being tried or heard: and of those that *stayed*, many of them were killed by the soldiers, murdered in their houses, executed by martial law, starved and famished in jails, and destroyed by many other violences; the Papists declaring, ‘That they designed to starve one half of the Protestants, and hang the other, and that it would never be well, till this was done:’ So that all King James's proceedings in that kingdom clearly manifested his design to be the absolute enslaving it to arbitrary power and Popery, by his invading their liberties and estates, and exposing their lives to his peremptory



---

p.88




will and pleasure. This the Protestants in the north, as well as others, were very sensible of; and therefore the people of Londonderry resolved to hold out to the last extremity.


Some time before, the English navy being out at sea, to prevent supplies from France, Admiral Herbert, with his squadron, had notice by his scent-ships, that part of the French fleet were abroad, and stood for the Irish coast: whereupon he sailed after them, and found them in Bantry-bay, whereupon drawing his ships up into a line, and lying upon the stretch, he battered them extremely, from ten in the morning, till five in the afternoon, at what time the French admiral went off, and stood farther into the bay: on our side, we lost Captain Aylmer of the Portland, with a lieutenant, and about 300 seamen killed and wounded; the damage of the French was equal to ours, though they had the bay to shelter them, the wind, and a double number of ships. So soon as the English were gone, the French weighed anchor for fear of a second engagement.


King James now sets forward with his army toward Londonderry; where the garrison had already proclaimed King William and Queen Mary, and had received from England 480 barrels of powder, and arms for 2000 men, with. a commission to Colonel Lundy to be governor, and promise of further supply. King James's army consisted in about 12,000 men, and a very good train of artillery; his generals were Monsieur de Mornont, general of the French horse, the Sieur Piscina, general of the foot; Colonel Hamilton, lieutenant-general of the Irish foot, all under the standard of France; and consisting of several regiments, commanded by the Duke of Berwick, and Fitz-James his brother, the Lord Netterville Abercorn, Colonel Sheldon, and Colonel Randleigh. The King had some assurance given him, that the town, upon his approach, would undoubtedly surrender, and that the very sight of so formidable an army would fright them into a compliance; and therefore, April 18, he advances with his army before the walls with flying colours. Orders were given that none should fire, till the King's demands were first known; but the people of Londonderry wondering to see Lieutenant-General Hamilton approaching the walls, contrary to his engagement not to come within four miles of the town, imagined they were betrayed, and fired their guns upon them; which being unexpected by the enemy, some of them fled, others hid themselves, and a great many were killed; and it was reported that one Captain Froy was slain near the King's person, who was in some disorder to find himself so roughly and unmannerly treated by those from whom he expected a dutiful compliance, as well as at the behaviour



---

p.89




of his army, so different from the character he had received of both; and therefore those in the town, who had encouraged him to try this dangerous experiment, sent some persons to the King to excuse it, by alleging the difficulty of commanding an untractable multitude. But upon their return, they were, three days before this, kept out by the people; Colonel Cunningham and Richards came into the Lough from England, with two regiments and other necessaries for the supply of Derry, with instructions to receive orders from Governor Lundy, who thereupon called a council of war, where the two colonels being present, with others, unacquainted with the condition of the town, or the inclination or resolution of the people, they make an order, ‘That there not being provision in the town for the present garrison and the two regiments, for above a week or ten days; and the place not being tenable against a formidable army, therefore it was not advisable to land the two regiments; and that considering the enemy will soon possess themselves of the place, the principal officers shall privately withdraw, that the inhabitants, by a timely capitulation, may make the better terms with the enemy:’ in pursuance, of this order, Colonels Cunningham and Richards, with their officers, went to their ships; which, with two regiments on board, sailed back for England: and the council, in pursuance of these pernicious intentions, proceeded to conclude upon a surrender, and drew up a paper to that purpose, which most of them signed; and the town was designed to have been delivered up in two or three days.


In the mean time, the officers and soldiers in Londonderry, who knew nothing of the order of council, earnestly intreated Colonel Lundy, that the English forces might land, that, with their assistance, they might take the field, and fight the enemy before the cannon were brought over, in order to the preservation of that corner, into which the provisions and wealth of three or four counties were crowded: the Colonel, to delude them, told them publicly, ‘That it was resolved, the English forces should immediately land, and when they were in their quarters, the gates should be opened, and all join in defence of the town;’ and to carry on the intrigue, the sheriffs were ordered to go through the city, to provide quarters for them; but all this was a mere sham, that he and the officers might get away with the greater ease and safety.


A party of Irish having a few days before attempted to ford the river at Castle Fin, were repulsed by some forces sent out of Derry, who opposed their coming over, till all their ammunition was spent; after which, they followed the rest of the English army, which were



---

p.90




10,000 strong, and made good their retreat to Derry; but were much surprised to find the gates shut against them by the Governor's order: so that many officers, soldiers, and private gentlemen, were forced that night to lie about the walls; but the next day, with much difficulty, and some violence upon the *sentry*, by firing at him, and calling for fire to burn the gates, that and the other gates were thrown open: this and other passages, occasioned great jealousies of the Governor; but when the town-clerk found it absolutely necessary to publish the resolutions of the council of war, ‘That Colonel Cunningham, his ships, men, and provisions, should return to England, and all gentlemen and others in arms, should quit the garrison, and go along with him;’ the common soldiers were extremely enraged at their officers, several of whom at this time had deserted them, and fled for England: so that they could not forbear expressing it with violence on some of them; one Captain Bell was shot dead, and another burnt, who with more officers was got into a boat, as they imagined to get away.


King James, upon the repulse he had received, retired the same evening with his army to St. Johnstown, about five miles from Derry; and *stayed* there two days to wait for an answer from the city, to the proposal he had made April 17: ‘That, to prevent the effusion of Christian blood, if they would surrender the city, honourable terms should be allowed them;’ the council, in the absence of Colonel Lundy (who thought it for his safety to keep his chamber) proceeded upon the Governor's project, to choose twenty men to go out and capitulate with King James; but the multitude on the walls, and at the gates hearing of it, were so exceedingly incensed, that they threatened: ‘if a man of them offered to go out on that errand, they would treat him as a betrayer of the town, the Protestant religion, and King William's interest:’ Upon which, none of them durst offer to go, and so a stop was put to that dangerous capitulation, notwithstanding the orders of the Governor in council; so little did the soldiers regard any command that seemed to cross their resolutions of defending the city. The multitude having thus broken the authority of the council, they, with Colonel Lundy, thought fit to withdraw, and he with some difficulty, got to the ships at Culmore, and from thence to England: upon which, the garrison seeing they were deserted by their Governor; and having resolved to defend the town against the enemy, they chose Mr. Walker, a clergyman, and Major Baker, to be their governors during the siege; and the soldiers whom their officers had left, chose their captains, and each captain which of the colonels he would serve under, aft they pleased themselves; and one Mr. Bennet was sent to England,



---

p.91




to give an account of their resolutions to maintain the place; and to desire speedy succours to be sent from thence for their assistance.


April 9, a trumpet came to the walls from King James, to know why they sent not out commissioners to treat according to their proposals; but the people having put a stop to it, Colonel Witney wrote a few lines to excuse themselves to the King: the next day the Lord Straband came up, making many proposals; and offering his King's pardon, protection, and favour, if they would surrender the town; but these fine words had no place with the garrison; for at the very time of this capitulating, the enemy were observed to use that opportunity, for drawing their cannon to a convenient stand: whereupon they desired his Lordship to withdraw, or else they should fire upon him; he still continued his complements, till they plainly told him, they would never deliver the town to any but King William and Queen Mary, and their order: my Lord having ended all his insinuations, found himself at last obliged to retire; so that King James having lost all hopes of accommodation, resolved, if possible, to reduce them by force, and



---

p.92




raised several batteries against the town, his head quarters being still at St. Johnstown. The fort of Culmore had some time before been deserted by Captain Jemmat, the governor, by order of Colonel Lundy, and a few Irish possessed themselves of it; but it was soon recovered by a small artifice. Divers skirmishes happened between the two armies during the siege, particularly May 6, in a sally made by the besiegers, wherein 200 of the enemy were killed, and 500 wounded, 300 of whom died in a few days of their wounds; and among others, General Momune, a Frenchman, with other officers of note.


The enemy now remove their main body from St. Johnstown, and pitch their tents about two miles from Derry, on a hill, placing such strict guards on all sides of the town, that the besieged found it impossible to convey or receive any intelligence, and difficult to come by the wells of water; which they often sought for, and cost some of them their blood. June 4, the enemy with a body of horse and foot, made an attack on the windmill works; beginning with a loud huzza, which was seconded from all parts of the camp, with most dreadful shrieks and howlings of a numerous rabble that attended their army: the faggot-men were forced to quit their new defence; which they laid before them for security against the shot, and run for it; Captain Butler, with thirty horse, mounted the works; but none of his men falling, though shot at, the besieged found they had armour, and therefore killed their horses, whereby only three troopers escaped: the Irish foot did not run away so fast as usual, which was wondered at, till it was observed, that in their retreat they took the dead on their backs, to secure themselves from the shot; which was more secure than when they were alive: the enemy, in this action, lost 400 men, most of their officers killed, and some made prisoners, the besieged had only six soldiers and a captain killed. June 15, a fleet of thirty sail came into the Lough from England; but to prevent their coming up to the town, the enemy contrived a boom of timber, joined with iron chains, and a cable of twelve inches, and afterward another, of which the besieged had an account by some prisoners taken, which very much discouraged them, for they doubted whether the fleet (at the first sight of which they were very joyful) would be able to get up with the provisions which they so extremely wanted, insomuch that the men, where they could find an horse a grazing near the windmill, would kill and eat him. The enemy, upon the appearing of the ships, seemed to be in a mighty consternation, pulling down their tents, and the soldiers changing their red coats, ran away; but the terror was soon over, when they saw them make no great attempt to come up, though they



---

p.93




had both wind and tide to assist them; and thereupon they raised batteries to hinder them, and made the boom aforementioned.


June 24, Rosen, the French Marshal-general, arrived in the camp; and finding so little progress in the siege, he swore by the belly of God, he would demolish the town, and bury the besieged in the ashes; and put all to the sword without consideration of age or sex, and study the most exquisite torments, to lengthen out the misery of those that opposed his command; but Providence disappointed his cruel malice, and delivered the poor Protestants out of his bloody hands.


The besieged used all possible endeavours to get intelligence from the ships, by making many signs from the steeple, by cannon shot, and by drawing in their flag, to represent their distressed condition to them; but all proved ineffectual. At length, June 25, one Roch, who got to the water side over against them, and then swam across the river, came and gave them an account of the ships, men, provision and arms in them for their relief, adding, that it was desired, that if he got safe to town, to give them in the ships notice of it by four guns from the steeple; which was accordingly done; they endeavoured to send back to Major-general Kirk, and one wept to that purpose; but was taken and hanged by the enemy: the besieged were more straitened every day by the enemy, their iron balls being now spent; so that they were obliged to make balls of brick, covered over with lead. June 30, the Lord Clancarty, at the head of a regiment, possesses himself of a line, and enters some miners in a low cellar; but the besieged fired so briskly upon them, that his Lordship was forced to quit his post, and leave his miners, and 100 of his best men dead on the place, which much discouraged the Irish, who had a prophecy among them, that a Clancarty should knock at the gates of Derry; but we see that little value is to be put either upon Irish prophecies or courage.


The same day, Governor Baker died, which was a sensible loss to the garrison, and generally lamented, being a valiant person, who in all his actions *showed* the greatest honour, courage, and conduct.
And now Rosen sends a letter into the town, that ‘if they did not surrender by six o'clock in the afternoon, July 1, he would order all the Protestants in the adjacent towns to be driven under the walls of Derry, where they should perish, if not relieved by the besieged; that he would destroy all the country, if any troops came to their relief: but if the garrison would become royalists (as he termed it), and deliver it on any tolerable conditions, he would protect them from all injuries, and give them his favour.’ The besieged received all these proposals with contempt, and some indignation, having before made an order,



---

p.94




that it should be death to mention a surrender. The enemy drive the poor Protestants, according to their threatening, under the walls; and the besieged thinking them enemies, fired on them; but were mightily pleased to hear that Divine Providence had spared them; and that their shot had killed three of the enemy; there were some thousands of them, which so enraged the besieged, that in sight of their camp, they erected a gallows, threatening to hang their friends that were prisoners, unless they were removed and sent home again: the prisoners themselves reproached the Irish, declaring they could not blame the besieged for putting them to death, seeing their people exercised such severity and cruelty upon the poor Protestants that were under protection: the sight of the gallows, and the importunity of some friends of those that were to suffer, at length prevailed, so that, July 4, the poor people had leave to return home. The enemy had now advanced so near the town, that the besieged, from the works, could talk with the Irish, who expressed great prejudice and hatred against the French, cursing ‘those damned fellows that watched in trunks (meaning their jack-boots), who had all preferments in the army that fell; and took the bread out of their mouths; and they believed would have all the kingdom to themselves at last.’ July 11, the enemy called for a parley; and sent one to know if they would treat about surrendering; which the besieged, to gain time, thought fit to agree to, and commissioners were named on both sides; but the enemy not allowing them time till July 26, the treaty soon ended. The garrison was now reduced to 4456 men, who were under the greatest extremity for want of provision, in so much that horse-flesh was sold for 20d. a pound; a quarter of a dog, fattened by eating the dead bodies of the Irish, 5s. 6d.; a dog's head, 2s. 6d.; a cat, 4s. 6d.; a rat, 1s.; a mouse, 6d.; a pound of grease, 1s.; a pound of tallow, 4s.; a pound of salted hides, 1s.; a quart of horse blood, 1s.; a horse pudding, 6d.; an handful of sea wreck, 2d.; of chick weed, 1d.; a quart of meal, when found, 1s.; yea, at length they were under so great a necessity, that they had nothing left unless they could prey one upon another: and a fat gentleman thought his body in such danger, that he hid himself for three days, imagining that several soldiers looked on him with a greedy eye; their drink was water, and cost very dear, they mixed it with ginger and anise-seeds, of which they had great plenty: they eat a composition of tallow and starch, which did not only nourish and support them, but was an infallible cure of the looseness, which many were sorely troubled with: and yet, in the midst of this extremity, the spirit and courage of the soldiers was so



---

p.95




great, that they were often heard confidently, and with some anger contend, whether they should take their pay and arrears in Ireland or in France, when, alas! they could not promise themselves twelve hours life.


But the hour of their extremity was the fit season for Divine Providence to interpose, and render itself the more observable in their deliverance, for July 28, about seven in the evening, they perceived three ships, which were the Montjoy of Derry, the Phoenix of **Colerain**, and the Dartmouth frigate, which they soon discovered were the ships Major-general Kirk had sent, who had assured them, ‘That he would certainly relieve them when they could hold out no longer, though he endangered himself, his men, and ships.’ The enemy fired most desperately upon them from the fort of Culmore, and both sides the river; and they made sufficient returns with the greatest bravery. When they had passed the fort, the expectations of speedy succour raised in the besieged a strange transport of joy: the Montjoy made a little stop at the boom, occasioned by her rebound after striking, and breaking it, so that she was run aground; upon which the enemy, who gathered in swarms to the water-side, set up the loudest huzzas, and the most dreadful to the besieged that they ever heard, crying out, *Their ships were taken.* They fired all their guns upon her, and were preparing boats to burn her; but by great providence she firing a broadside, the shock loosened her, so that she got clear, and passed the boom; the Phoenix all this while was engaged, and the Dartmouth gave them very warm entertainment: at length the ships got to them, to the inexpressible transport and comfort of the distressed garrison, who only reckoned upon two days life, and had no more than nine lean horses left, and one pint of meal to each man; hunger and the fatigue of war had so prevailed among them, that of 7,500 men regimented, they had now alive but 4,300, whereof at least one-fourth part were rendered unserviceable. This brave undertaking, and their several successful attempts against the enemy, so discouraged them, that, July 31st, they raised the siege, and run away in the night-time, robbing and burning all before them for several miles. The next morning, after the men were refreshed with their new provisions, they went out to see what was become of the besiegers, whom they saw in their march, and pursued a little too far, so that the rear-guard of the enemy's horse turned, and killed seven of their men; and upon the news of the defeat of Lieutenant-general Mac-Carty, they so hastened their march, that they broke in pieces four of their great guns, and threw twelve cart-loads of arms and ammunition into the



---

p.96




river; and the besieged had above 2,000 arms, besides money, clothes, &c. Thus, after 105 days being close besieged by near 20,000 men, constantly supplied from Dublin, God Almighty was pleased to deliver this poor city from a powerful and inveterate enemy, to their great disappointment and disreputation; insomuch that King James, upon his retiring, was reported to have said in disdain to his commanders, ‘*Gentlemen, I think we have made a very fine summer's work of it.*’ The enemy lost near 9,000 men before the walls, and 100 of their best officers, most of them by the sword; the rest of fevers and flux, and the French pox, which was very remarkable on the bodies of several of their dead officers and soldiers; whereas the besieged had only 80 men slain by the enemy.


Neither were the **Inniskillen** men wanting in performing many notable actions, for during the whole time of the siege they kept at least one half of the Irish army from coming before Londonderry, for fear they should relieve the town; so that they durst not make a regular attack upon the place, but were forced to divide their men, keeping strong guards at several distant places, and therefore they deserve no small part of the honour of that place's preservation; and particularly the remarkable defeat given to the Irish the day before the raising the siege (the news whereof made the enemy run away with such great haste and precipitation), ought never to be forgotten; for July 30th, the **Inniskilliners** hearing that a body of about 6,000 Irish, under Major-general Mac-Carty, were marching toward them, they very boldly and bravely went to meet them about twenty miles off, at a place called Newtown Butler, where, though the enemy had secured their army beyond a long bog, yet the courage of the English was so great, that they came up to the mouths of their cannon, and seized them, killing all their cannoneers, which so terrified the Irish, that both horse and foot instantly fled; and the English foot pursuing theirs, and giving quarter to few or none but officers that day, they not having courage to fight for their lives, desperately leaped into the bog in several places, to the number of about 500, and none escaped drowning, except one person only, who got through after many a shot made after him. In this action a remarkable stroke was given by Captain William Smith, who at one blow cut off the upper part of a man's head just under the hat, as much of the skull as was within the hat, with all the brains, being quite struck away from the other part of the skull that stuck with the body, and not so much as a bit of skin to keep them together, but what was cut quite through. Mac-Carty, when his men were fled, got away with five or six officers to



---

p.97




a wood near the place where the cannon were taken, and soon they came back again on horseback, and he fired his pistol on those that guarded the cannon; upon which seven or eight soldiers, who before thought them friends, fired their musquets at him, and killed his horse, wounding him in several places; and then, to put him out of his pain, one of the soldiers clubbed his musquet to have knocked
out his brains; upon which, one of his company cried out, ‘Hold your hand, it is General Mac-Carty:’ whereupon Captain Cooper coming up, gave him and the rest quarter; and asking him why he so rashly hazarded his life, when he might have escaped, he replied, ‘That he now found the kingdom like to be lost, his army being the best for number that King James had, unless those before Derry, who were then much broken; and that he came with a design to lose his life, and was sorry he had missed of his end, being unwilling to outlive that day.’ This was a most remarkable victory, obtained under the command of the valiant Colonel Woolsley; the Irish were reckoned 5,000, and the English not above 2,000; the enemy confessed that 3,000 of their men were wanting: they lost seven cannon, fourteen barrels of powder, a great quantity of cannon and musquet ball, and all their drums and colours. The English lost not above twenty men, and forty or fifty wounded; and hereby the siege of **Inniskillen** was prevented, which, by a letter found about Mac-Carty, was designed to have been besieged in a few days by this party, who were to be joined with another detachment under the Duke of Berwick. It has been since published, that this great defeat partly happened by a fatal mistake in the word of command among the Irish; for the **Inniskillen** men charged the Irish right wing very smartly, which Mac-Carty perceiving, ordered some of his men to face to the right, and march to relieve their friends. The officer that received the orders mistook, and commanding the men, instead of facing to the right, to face to the right-about, and so march: the Irish in the rear, seeing their front look with their faces towards them and move, thought they had been running, and so, without more ado, threw down their arms, and run away; the rest, seeing their men run in the rear, run after them for company, and were most of them cut off, or drowned in the bogs and loughs; so unhappy may a small thing prove to a great body of men, and at other times, a little thing in appearance proves very advantageous; for we read of a Roman at plough, who stood with his ox-yoke in a gap, and stopped the soldiers that were running away; this made them face about and gain the field, though all men must acknowledge, in that action of the **Inniskilleners**, as well as at Londonderry, there was a



---

p.98




great deal to be attributed to their valour, but more to the providence of God.


Another remarkable passage is related, that before the fight, about an hour and half after sunset, the people of **Inniskillen** saw from thence a great light in the air above Newtown Butler, where Mac-Carty then lay with his army, which continued, for some hours, so that they concluded the Irish had set that town and all the country about on fire, or raised some fire in the country, to give notice to Lieutenant-general Sarsfield to join with them; but after the fight was over, upon inquiry into the matter, they found there was no fire that night raised among them. This is the more observable, because the like was seen at Glaslough, before the action they had there with the Irish of the garrison of Charlemont, whom they defeated March 13th before, killing their leader and about 200 of his men, with the loss only of one captain. About a week before this happened, at eleven o'clock in a very dark night, several pillars of fire appeared in the air, pointing from towards Charlemont, which were so light they might have read by them, and continued thus two hours, to the observation of all people there. The like account we have from Dr. Robert Maxwell, late Bishop of Kilmore, of what happened in the rebellion of 1641, who relates that fifty-six Protestants, men, women, and children, were taken out of his house, and drowned by the Irish at Cure-bridge; and that three or four nights before, in the dark of the moon, about one o'clock in the night, a light was observed in manner of a long pillar, to shine for a great way through the air, and refracted upon the north gable of his house; it gave so great a light about an hour together, that divers of the watch read both letters and books of a very small character thereby, which the Doctor believed did presage that bloody massacre which ensued. It is difficult to enter into the reason of these things, but this is only matter of fact, and every man is left to his own conjectures in them.


During these transactions in Ireland, King William gives out commissions in England to raise eighteen regiments of foot, and four or five of horse; and the levies went on with such speed, that the greatest part were raised, armed, and clothed in six weeks, and August 12, they were embarked at High-Lake, near Chester, for Ireland, being about 10,000 foot and horse; and three days after they landed near Carrickfergus, encamping in the fields that night: the garrison apprehending a siege, burnt their suburbs, and prepared for their defence; whereupon Duke Schomberg, general of all their Majesty's forces, sent five regiments to encamp before the town, and more the next day,



---

p.99




which surrounded it; whereupon they desired a parley, and required time to send to King James for succours, which the General absolutely refused, and with his mortars and cannon played upon the town. Four days after, they beat another parley, desiring to march out with their drums beating, &c.; but this was denied. During the parley, the Duke visited all the trenches, and observed the walls of the castle, and a poor Dutchman was shot from the walls, making his returns to reproaches against King William, saying, ‘That their King was a tinker-king, and had nothing but brass money:’ he was not nimble enough at getting off when the parley was over, and so lost his life for his jest's sake.


August 25th, the guns played furiously, and made a great breach in the walls, which the Irish seeing, and fearing our men would enter, they got a great number of cattle together, and drove them all as near the top of the breach as they could force them to go, keeping themselves close behind them: several of the cattle were killed by



---

p.100




the shot, and as they fell the Irish threw earth, stones, and wood upon them; but this they thought would not hold long, and so desired a third parley, and at length it was agreed that they should march out with their arms and some baggage, which they did accordingly: and the English forces took possession of Carrickfergus (as they had done before of the towns of Belfast and Antrim, which the enemy for fear had deserted). While they were in treaty at Carrickfergus, and the articles were scarce agreed to, Mac-Carty More, governor of the town, was got in the Duke's kitchen in the English camp; which his Grace smiled at, and did not invite him to dinner, saying, ‘If he had *stayed* like a soldier with his men, he would have sent to him; but if he would go and eat with servants in a kitchen, let him be doing.’ The country people were so inveterate against the soldiers (remembering how they served them some few days before), that they stripped most part of the women, and forced a great many arms from the men, and took it very ill that the Duke did not hang them all, notwithstanding the articles: nay, they were so rude, that the Duke was obliged to ride in among them with his pistol in his hand, to keep the Irish from being murdered; who were forced to fly to the soldiers for protection, so angry were they at one another, though they all live in the same country. The enemy had about 150 killed and wounded in the siege, and the English as many killed, and about 60 wounded.


The English army now march on, through Lisburn, Dromore, Loughbrickland, and so to Newry, which they found newly burnt and deserted by the Duke of Berwick and his forces, who had only time to set it on fire, and take all the people, with whatsoever was valuable, along with him; upon which the Duke sent a trumpet to the Irish, to let them know, ‘That if they burnt any more towns, he would give them no quarter.’


September 7th, the army marched thence to Dundalk, which was likewise deserted, but not burnt: here they encamped within a mile of the town, in a low, moist ground, where many grew sickly, the Irish boasting to the Protestants when they went away, ‘That they would drive the English all back again into the sea, or else they would die of themselves, not being used to the field, especially in a strange country, and at that time of the year.’ And indeed it went hard with them for want of provisions, especially bread, of which the enemy grew sensible. They had before retreated beyond Drogheda in much consternation, not doubting but the Duke, being an old general, would not have come into Ireland without a good army, and all things well provided; and were upon the point of deserting not only Drogheda,



---

p.101




but Dublin also, by the advice of the French General Rosen, and to retreat towards Athlone and Limerick; but when De Rosen heard that Duke Schomberg halted, he said he was sure they wanted something, and therefore advised to hasten their army together, in which Tyrconnel was so diligent, that from 8,000 he made a body of 20,000 men in a few days, with which they marched to Ardee, and seized all the provisions that the Protestants had got together for the English army, which they expected there, but unhappily *stayed* too long.


September 13th, the English received 204 loads of bread, which the ships brought to Carlingford; and then the General ordered the camp to be fortified, that the enemy might not break in upon them, and strict guards to be kept in the night, because they had notice that the Irish marched toward them; and accordingly, September 21st, they advanced to the English camp, and offered battle; but the Duke, knowing they could not easily force the camp, and for several other prudential reasons, declined to engage; upon which the Irish drew off to Drogheda: about which time, a correspondence was discovered to be held with the enemy by some soldiers in the French regiments, upon which six of the principal conspirators were hanged, who all died Papists, and confessed they enlisted themselves on purpose to bring over as many as they could to King James. They prayed for King William and Queen Mary, and asked their pardons for their treachery; and declared further, that if the General had engaged the enemy when they offered battle, they themselves were to put the English army into confusion, by firing in the rear, and so deserting; so that it was a great providence that the Duke then refused to fight.


September 25th, Colonel Lloyd, with about 1,000 **Inniskilleners**, defeated a body of 5,000 Irish that were going to Sligo, killing 700, and taking O'Kelly and forty more officers prisoners, with a great booty of about 8,000 cattle, with the loss only of fourteen men; the news whereof coming to Duke Schomberg in the camp, he ordered all the **Inniskillen** horse and foot that had lately joined the army to draw out, and complimented them so far, as to ride all along the line with his hat off, and then ordered some fireworks to be made for joy. A great many now began to be sick, by reason of the bad weather, and most were so lazy, that they would starve rather than fetch fern, or any thing else to keep themselves dry and warm; which was the greatest occasion of distempers, sickness, and death itself; and many, when dead, were incredibly lousy, which caused the General to say, ‘The Englishmen will fight, but they do not love to work.’ Both forage



---

p.102




and firing grew now very scarce, which increased the distempers among the soldiers, upon which the sick were ordered to be sent aboard the ships at Dundalk, that had brought fresh provisions.


The beginning of November, the enemy decamped and marched to winter quarters; and at the same time Sligo was taken by Sarsfield, who came upon them unexpectedly with a considerable body, and the place not being provided either with ammunition or water, it was surrendered to the Irish upon honourable terms. As the English soldiers came out of the town, Colonel Sarsfield stood with a purse of guineas, and offered to every one that would serve King James five guineas advance, with horse and arms; but they all answered, *They would never fight for thePapishes,* as they called them: nay, even those that were a dying in the camp, were wont to express no other sorrow, than —*Plague on thesePapishes, that we must die here, and not have leave to so and fight them.* The sickness increased, and great numbers died daily, so that the General concluded to decamp from Dundalk, and march back to Belfast; which they did accordingly, the sick being carried in waggons, and the army marched in the wet and snow, so that many perished by the way: yet upon an alarm that the enemy were coming upon them, they grew very hearty, and began to unbuckle their tents, saying, ‘If the Irish came, they should pay for their lying in the cold so long.’ As to the number of men that died of this great mortality, it is computed that near 1,700 died about Dundalk; about 2,000 were shipped for England, and not much above half came ashore, but died at sea: so that in the whole they lost near 5,000 men, which was imputed very much to the bad weather, the moistures of the place, and the tenderness and carelessness of the English; whereas the Dutch kept themselves so clean and warm, that not above eleven of them died the whole campaign.


A remarkable passage happened a year before, near Dundalk, which seemed to presage this great destruction of men: a worthy gentleman, with two others and their servants, coming from Dublin to the north, as they approached Dundalk about nine at night, espied several little trinkling lights in the air, with two larger than the rest, about the ground where the English army encamped this year; and at the same time they heard the most heavy and dismal groans in the world, which continued till they came to Newry; but the lights they saw only upon the plains of Dundalk.


November 23d, the enemy, with a detachment of 1,600 men and 100 volunteers, attempted to force the pass at Newry, and then designed to go along the line, and destroy the frontier garrisons: there were



---

p.103




not above sixty English in the town, and not forty of those able to present a musket, who yet fired upon them so briskly, and affrighted them with such loud huzzas, that the Irish imagining their number far greater than they were, fled, leaving six men dead, and carrying off twelve horse-load of dead and wounded men.


December 4th, Colonel Woolsely went in the night with a party of **Inniskillen** horse toward Belturbet; upon whose approach the garrison, being surprised, yielded to the first summons. Soon after, Lieutenant-general Mac-Carty made his escape from **Inniskillen**, where he was prisoner: he pretended to be sick, and desired the Duke to remove his guards, which was granted; and the town standing on a lough, the water came to the door, whereupon he found means to corrupt a serjeant, and got two small boats to carry him and his moveables; the Serjeant went along with him, but returned that night to deliver a letter, which, with Mac-Carty's pass, being found in the lining of his hat, he was the next day shot for it. The Duke was much concerned at the news, and said, *He took him for a man of honour, but he would not expect that in an Irishman any more.*


In February, Colonel Woolsely, with 700 foot and 300 horse, routed a body of 4,000 Irish at Cavan, killing about 300 soldiers and several officers; and sixty soldiers, with twelve officers, were made prisoners, and all with the loss only of thirty men and two captains.


February 15th, Sir John Lanier, with a party of 1,000 horse, foot, and dragoons, went from Newry toward Dundalk, which the enemy had fortified very well since the English had left it, and therefore he did not think fit to attempt it; however, he drew up near the town, upon which the Irish came out, but soon retired, and the Major-general burnt the west part of the town, and took Bedloe Castle, with thirty prisoners and the ensign that commanded it, and returned with a booty of nigh 1,500 cows and horses. The ensign was carried before the General at Lisburn, who took him aside to inquire about the posture of the enemy. ‘You (says the Duke) have a commission, and for that reason (if not otherwise) you are a gentleman; this obligeth you to speak truth, which if you do not, I can know it by examining other prisoners, and then I shall have no good opinion of you:’ but though the Duke talked with him half an hour, it was thought he discovered little material.


In March, 400 Danes landed at Belfast, with the Prince of Wirtemberg, their general, being lusty fellows, well clothed and armed. The same month, about 5,000 French foot landed at **Kingsale** with two generals, the Count de Lauzun and the Marquis de Leary, King James sending back as many Irish under Lieutenant-general Mac-Carty. Our



---

p.104




fleet then attending the Queen of Spain, made this undertaking very easy to the French. Before they arrived, some of the Irish nobility in discourse with King James, said to him, ‘Sir, is not the French fleet in danger to be met with by the English?’ To which he replied, ‘That he, during his time, had taken care that the English should not have any great strength by sea; and now to equip and set out a fleet would be tedious, besides the expenses, and that he did not doubt but the French would master them.’ As soon as these forces landed at Cork, above 500 of them died of some pestilent distemper; the rest being come to Dublin, General Lauzun sent to the governor, Lutterel, to deliver the keys of the city and castle to him, pursuant to King James's promise to his master, to give him possession of Dublin, and all the strong places in Ireland. Lutterel replied, he would first acquaint the King; and accordingly accompanied the Lord Mayor and Aldermen to address the King, telling him, that they had hitherto ventured their lives and fortunes in his defence, and therefore hoped he would still confide in them to govern Dublin, and would not make them absolute subjects to the French King. To whom he replied, ‘That he had engaged his word to his brother Lewis, that Lauzun should have the government of Dublin, and could not recede from it.’ Thereupon the keys of the city were delivered, but the French would not mount the guards till they had likewise the keys of the castle, which were likewise given them; and so they possessed themselves of the city and castle, swearing, ‘They had no King but King Lewis, nor would they obey any other, and under him their general, Lauzun.’ From thence they grew very insolent to Protestants, and as they passed by any of the clergy, threatened them severely; so that they consulted to disguise themselves in frize coats, for security against these French vultures. They had not been above two days in Dublin, when they murdered two or three Protestant clothiers in the city, at a place called Comb, for protecting their wives from being ravished; of which inhuman act no more notice was taken, than if two dogs had been shot. They took a country maid that came to market with her father, and deflowered her in the open street at noon-day. Many such barbarous villainies were committed by them, there being above 10,000 Protestant men in Dublin able to bear arms, besides women and children; and being barred the liberty of the markets by the French, who would not sell bread to the Protestants, as the Irish Papist soldiers did, it was almost a miracle that thousands had not perished. Many of the sober Papists were also sensible of their rudeness, and grew mighty dejected, often complaining to their King of the disdainful treatment they received from the French, who called them ten thousand cowards,



---

p.105




and said they were beaten by a priest and a few boys, meaning the valiant Colonel Walker, and those matchless heroes that defended Londonderry; and that D'Avaux, the French ambassador, said to General Lauzun upon his landing, ‘You are come to be a sacrifice for a poor-spirited and cowardly people, whose soldiers will never fight, and whose officers would never obey orders, and therefore will meet with the same fate that our master's army did at Candia, that is, to be wasted and destroyed by the enemy, and deserted by those you came to relieve.’ But King James had no power to help himself or them, having by his degenerate and mean spirit truckled his authority, and became subject to the power of France, and contented himself to be a King in name only.


April 6th, 1690, Colonel Woolsely, with a detached party of 700 men, attacked the castle of Killishandra with such briskness, that the enemy surrendered it, they being 150 men. On the 10th, Colonel Tiffen sent out a party from Ballyshannon, who brought off a prey from the neighbourhood of Sligo, and killed about sixteen of the enemy as they pursued them.


April 12th, Sir Cloudesly Shovel came to Belfast as convoy to several ships that brought over necessaries for the army; and having



---

p.106




notice of a frigate at anchor in the bay of Dublin, with other small vessels, laden with hides, tallow, wool, and some plate, and other goods, designed for France, he sailed thither, and leaving the great ships in the bay, with the Monmouth yacht, and two or three more, and several long boats, he went to Polebeg, where the frigate lay, of sixteen guns and four patereroes, being a scotch ship taken the year before in the Channel. When King James heard of it, he said, *It was some of his loyal subjects of England returning to their duty and allegiance:* but when he saw them draw near the ship, and heard the firing, he *rode* out towards Ring's-end, whither gathered a vast crowd of people of all sorts, and several regiments were drawn up, if possible, to kill those bold fellows at sea, who durst on a Good Friday (as this happened to be) perform so wicked a deed, as they said. Captain Bennet, that commanded the frigate, run her aground, and after several firings from her and some other ships, when they saw a fire-ship coming in, which Sir Cloudesly had given a sign to, they all quitted the frigate, being at first forty, but lost six or seven in the action. Sir Cloudesly was in the Monmouth yacht; in going off, one of the hoys run aground, and was dry when the tide was gone, and the rest of the boats were not far off, being full of armed men; and a Frenchman of King James's guards coming nigh the boats, to fire his pistols in a bravado, had his horse shot under him, and was forced to fling off his jack-boots and run back in his stockings to save himself. Some of the seamen went on shore, and took his saddle and furniture; when the tide came in, they went off with their prize to the ships below. King James went back very much dissatisfied, and, it was reported, should say, *That all the Protestants in Ireland were of Cromwell's breed, and deserved to have their throats cut:* however, all the Protestants that walked that way during the action, were imprisoned, and two made their escape to the boats. Monsieur Callimot, with his French regiment, had some time before attempted the strong castle of Charlemont, setting fire to the bridge, and killing about twenty men, and then retreated.


May 2, the Irish put relief into the place, which was conveyed with a detachment of 4 or 500 men, and Colonel Callimot's regiment, who were quartered at Blackwater, knowing the convoy must return, resolved to intercept them; and as they were marching back, fell upon them with such courage, that he forced them again into the castle, and this they did two or three times, which Teague O'Regan, the old Irish governor, perceiving, he swore, if they could not get out, they should have no entertainment nor lodging within: and was as good as his word,



---

p.107




for they were forced to make little huts within the palisadoes, so that between Teague and the English, the poor fellows were in a lamentable condition. After this, the General sent several regiments to block up Charlemont, with cannon to force old Teague out of his nest if possible, having summoned him to surrender some time before, who returned the messenger with this answer; ‘Go tell thy master, from Teague O'Regan, that he is an old knave, and by St. Patrick, he shall not have the town at all;’ when, God knows, there was no town standing, but an old castle. The Duke only smiled and said, *he would give Teague greater reason to be angry in a short time;* and accordingly those Irish that had a mind to go out, being kept in, soon made victuals very scarce, and no hopes of relief appearing, the old governor sent to treat about a surrender, and the terms being soon agreed to, this strong place was delivered up, about 400 men, and 200 Irish women and children marching out of it: the Duke stood to observe them, and Teague O'Regan appeared mounted upon an old stone-horse, very lame with spavin and cratches, and so vicious, that he would fall a-squealing and kicking if any body came near him; Teague himself had a great bunch upon his back, a plain red coat, an old weather-beaten wig hanging down at full length, a little narrow white beaver cocked up, a yellow cravat-string tied all on one side, his boots with a thousand wrinkles; and though it was very hot, a great muff hanging about his back, and, for uniformity, he was almost fuddled with brandy. In this equipage he approached the Duke; but had not made his compliment ere the jade fell to work, so that the Duke had scarce time to make a civil return; the Duke smiled afterwards, and said, *Teague's horse was very mad, and himself very drunk.* The officers and soldiers made the Duke a great many legs, and stared upon him, to see whether he was a man or some other strange creature; for the Irish usually asked one another, ‘what *is that Shambear that all this talk is of?*’ *The* Duke enquired why they kept so many women and children in their garrison, which must needs consume their provisions; he was told, ‘that the Irish are naturally very hospitable, and that they all fared alike; but that the soldiers would never be persuaded to stay in garrison, without their wives and mistresses:’ The Duke replied, *there was more love than policy in it*. The Irish were to be guarded to Armagh, and among them were two priests, one of whom, in the way, fell into discourse with a dragoon about transubstantiation; but being baffled, was so angry, that he fell a-beating the dragoon, who not being used to blows, thrashed the priest severely, of which



---

p.108




complaint being made to Teague, he replied; *I be very glad of it, what te deal had he to do to dispute religion with a dragoon.*


King William being concerned that the war in Ireland should divert his forces from going into France, resolved, if possible, to reduce the kingdom this summer, by going thither in person; and every one knew his Majesty's industry, courage, and resolution to be so great, that he would endeavour to make a quick dispatch, and accordingly having left Kensington June 4, ten days after he arrived safe at Carrickfergus, with his Highness Prince George, the Duke of Ormond, the Earls of Oxford, Manchester, Scarborough, and several other persons of quality, and was received by the officers, soldiers, and people with all manner of demonstrations of joy, the latter looking on his Majesty as their good angel, who was come to deliver them from worse than Egyptian bondage. Next day several of the nobility, officers, gentry, and clergy, presented a very loyal address to the King, which he graciously accepted. His Majesty was not idle, and seeing things



---

p.109




did not go on so fast as he desired, expressed some dissatisfaction, saying, *that he did not come there to let grass grow under his feet;* he made his word good; for having taken a view of his army, which, with the great recruits lately sent from England, amounted to about 36,000 compounded of English, Dutch, Danes, Germans, and French, his Majesty advanced toward Dundalk.


The certain news of King William's landing coming to Dublin, it was moved by some Irish in King James's council, that the Protestants should be shut up in churches and hospitals, and then if they lost the day, to set fire to all, and destroy the people and city together: but the Irish Papists both in the city and army, applied themselves to the King, and told him; ‘they should then be as much sufferers as the Protestants, and that they would not draw a sword in his defence, unless all thoughts of burning the city were laid aside;’ and declared further, ‘that as soon as they heard of any appearance of fire, they would desert his service, and fly to King William's mercy;’ which menaces put a stop to this horrid project. Before this, a camp had been laid out by the Irish about Ardee, and King James had ordered his army to rendezvous there from several parts of the kingdom; and June 16, he marched out of Dublin to join them with about 6000 French foot, most old soldiers, well armed and clad. The whole Irish army encamped, made about 27,000, all well clothed, and in good heart, both horse and foot, besides 15,000 more that remained in garrisons, and the same day 6000 of the country militia came to quarter in the city. The Protestants expected the Irish would have been much dejected upon King William's arrival: but, on the contrary, they triumphed and rejoiced, as if they had got him in a pound, and the day were their own, assuring themselves, that either the French fleet would prevent his return to England, or that an insurrection would be made there, boasting that an 100,000 men were ready to rise and declare for a commonwealth. The Protestants knew not what to believe, for they were kept as prisoners of war, and could know no more than they pleased to tell them; but they were more afraid that some desperate persons had undertaken to destroy King William, because their confidence was so great, that some told their Protestant friends, *they would be glad to go to mass within a twelvemonth.*


When King James was gone, Colonel Lutterel, who was left governor, ordered all persons that walked in the streets without swords or bayonets, to be taken up and secured, whereby all Protestants who
were suffered to wear none, were put into custody; after which followed a proclamation; ‘that not above five Protestants, besides the



---

p.110




family, should meet together in any place, upon pain of death.’ So that now they durst not go to church, as they had hitherto done; the churchmen still remained with them, though they had lost all their maintenance by the Irish Parliament, except what was given them by the people; Dr. King was sent prisoner to the castle, and few Protestants durst walk the streets. The method that King James and the French proposed to deal with King William's army, was, to make good the passes upon the Newry mountains, and at Dundalk; to spin out the war, and dispute their ground without coming to a general battle, till they came to the Boyne, and there to defend the pass; but still without a battle, if they could help it, much hoping for some extraordinary thing from a party in England, &c. But King William soon broke all their measures, for resolving to lose no time, he came to the camp at Loughbrickland, where having taken a critical review of every regiment, his Majesty and Prince George had their moving houses set up, and never after lay out of the camp during their stay in Ireland.


The King ordered a party to go out to discover the motions of the enemy, and heard they were marching off from Dundalk toward Ardee; upon which the English army advanced to Newry, and from thence to Dundalk, and so forward to Ardee, the Irish still retiring; and at length passing over the Boyne: upon which the whole army move in three lines toward the Boyne, and by the way some dragoons found in an old house about 200 scythes stretched out upon beams, which the enemy had either forgot, or left behind for haste; and one of them being brought to the King, he smiled and said, *it was a desperate weapon.* The Irish encamped on the other side the Boyne, and the King from an hill took a view of them, and then rode along the river side to make more strict observations, during which a cannon ball from the enemy killed two horses and a man about one hundred yards from the King; and instantly comes another, which had like to have been a fatal bullet, for it grazed upon the bank of the river, and in the rising, slanted upon the King's right shoulder, and tore out a piece of his coat, and also the skin and flesh; and afterward broke the head of a gentleman's pistol. A gentleman seeing his Majesty struck, rode up, and put his handkerchief upon the place: his Majesty took little notice of it; but rode on about forty yards further, the enemy's cannon firing upon them all the while, and killed two of the guards, and nine horses, disturbing the rest; which the Irish perceiving, set up a prodigious shout all over the camp, as if our army had been destroyed. The King went to change his coat, and get his shoulder dressed, and then



---

p.111




rode about to see the army; after which a council of war was called; and his Majesty declared, that he was resolved to pass the river next day, and accordingly all things were provided, every man having a green bough or sprig in his hat, the enemy wearing pieces of paper in theirs; the word that night was ‘Westminster;’ and about twelve at night, rode with torches quite through the army. The next morning, July 1, the Dutch blue guards took the river first, some eight or ten a breast, being presently almost up to the middle; the enemy stood on the other side; but did not fire till our men were toward the middle of the river, and then a whole peal of shot came from the hedges, breastworks, houses, and all about; but only one man fell, and another staggered; a lieutenant of grenadiers was the first that got footing on the other side, who instantly drew up two files of men, then stooped, and the enemy fired over him from the next hedge, and afterward quitted the hedge, which the rest that were posted thereabout seeing, they likewise fled, and were followed by a volley of shot from our men: when, on a sudden, a great many battalions of the enemy appeared from behind the little hills. We had two French regiments, and one English, who passed the river at the same time, about two hundred yards below, and routed those that opposed them; the Dutch advanced still, and the Irish quitted the hedges and van, straggling up and down the field; all our horse went over to the right and left, except one squadron of Danes, whom Lieutenant-colonel Hamilton charged so home with 60 horse, that they came faster back than they went. The want of horse was so apparent here, that the very country people cried out ‘horse, horse,’ which word going to the right wing, who thought it had been ‘halt,’ stopped them nigh half an hour's time; which, with about 40 Irish horse breaking through the French regiment at the same time, was thought to be the occasion of Duke Schomberg's going over so unseasonably; for in this hurry he was killed near a little village beyond the river; the Irish troopers, as they rode through, struck at him with their swords, and some believe that his own men firing too hastily when the Duke was before them, shot him themselves; his mortal wound was through the neck, and he had one or two cuts in the head; he fell down, and did not speak a word. Dr. Walker going, as was said, to look after the Duke, was shot in the belly. The action continued very hot for about an hour; but then the Irish retreated to a rising ground, drew up to charge our party again that had passed the river. The Danish and Dutch horse, with Colonel Woolsely's horse and dragoons, and likewise the Danish foot, and Colonel Cutt's regiment, now got over the river; the King during these transactions,



---

p.112




was almost *everywhere*, riding between our army and their's, and giving the necessary orders, attended only with one dragoon, and then passed the river with some difficulty; for his horse being bogged on the other side, he was forced to alight, till a gentleman helped him to get his horse out. When the men were got on the other bank, and put in order, his Majesty drew his sword; but with some trouble, by reason of his wounded arm, and marched before them toward the enemy, who were coming in good order upon our foot, with double the number, and charged several times at the head of them. Our horse were forced to give ground, though the King was with them; his Majesty then went to the **Inniskilleners**, and asked *what they would do for him,* and advanced before them; their officer told them who it was, and at the head of these men the King received the enemy's fire; the Danish horse once gave way; but the King went himself, and brought them up again; of the Irish, King James's horse and foot guards principally maintained this opposition, and suffered much, Lieutenant-general Hamilton, who had been employed by King William, betrayed his trust, finding the Irish foot did not answer his expectation, he put himself at the head of the horse; and when they were defeated, he was taken prisoner, having received a wound on the head, and brought to the King, who asked him whether the Irish would fight any more, *Yes,* said he, *and please your Majesty, upon my honour I believe they will, for they have a good body of horse still.* The King looked a little aside at him, and repeated once or twice *your honour,* &c. intimating that he had but little left, who had forfeited it by joining with Tyrconnel; and this was all the rebuke the King gave him (who always says much in few words), for his unfaithfulness. In the mean time, the Irish being beaten from the pass, the English hastened towards the body of the enemy, that were posted at Duleek; and as they advanced, the enemy drew off with such speed, that they left a great many arms and ammunition behind in that village; and before our horse could come up to attack them, they were gone at least a mile before, their horse and ammunition in the rear; and their foot marching in great haste and confusion. We pursued them three miles; but did not attack them, by reason of the boggy fields and ditches. Of the Irish were killed the Lords Dungan and Carlingford, and many other officers, with about 1,500 men. It was observed, that most of the horsemen who charged so desperately were drunk with brandy, of which each man that morning had half a pint for his own share. Of the English, were killed nigh 400; but the greatest loss was of Duke Schomberg, whom his very enemies acknowledged a brave man, and a great



---

p.113




general: he was certainly a man of excellent education, who was thoroughly acquainted with men and things, courteous and civil to all; and yet has always something so great, that commanded respect from all persons: a strong hearty man, though 82 years old, and when unbowelled, his heart, entrails, and brain, were as fresh and sound as a man of 20, and might have probably lived longer, if Providence had not ordered it otherwise.


King James, during part of the action, stood at a *little old church upon an hill;* but when he saw how matters went, he marched to Duleek, and from thence to Dublin. The first news at that place was, ‘that King James had got the day, our general was killed, and the Prince of Orange (as they called him) taken prisoner; that the French fleet was in the bay of Dublin; that a French express was come from Waterford, with the news of taking the Isle of Wight by the French, and of their being gone to Dover.’ This was very afflicting to the poor Protestants, who were all confined to their houses; but towards night, some that had made their escape upon tired horses, brought word, that the Irish were much worsted, and others, that they were totally routed. Near ten o'clock at night, King James came in with about 200 horse, all in disorder; they concluded now, that it was an absolute defeat, and that the English were just ready to come into the town; but were greatly surprised when, an hour or two after, they heard the whole body of the Irish horse coming in, in very good order, with kettle drums, hautboys, and trumpets; and early the next morning, the French, and a great part of the Irish foot; who being a little rested, marched out again to meet the English that were supposed to draw nigh.


When King James came to the castle gate, the Lady Tyrconnel met him; and after he was up stairs, asked him what he would have for his supper? Who then gave her an account what a breakfast he had got; which made him have but little stomach to his supper. Next morning, July 2, about five o'clock, King James sent for the Irish lord mayor, and some principal persons to the castle, and told them; ‘That in England he had an army which durst have fought, but they proved false, and deserted him; and that here he had an army which was loyal enough, but would not stand by him, so that he was now necessitated to provide for his safety, and that they should make the best terms for themselves that they could.’ He told his menial servants, ‘that he should now have no further occasion to keep such a court as he had done; and that therefore they were at liberty to dispose of themselves; he desired them all to be kind to the Protestants, and not to burn or injure them nor the city, for though he



---

p.114




quitted it, he did not quit his interest in it.’ Immediately after he took horse, and with about twelve in company went towards Bray and so to Waterford, having appointed his carriages to meet him another way, where he embarked for France; having some days before, distrusting the issue, ordered Sir Patrick Trant to go from the camp at the Boyne to Waterford, and provide shipping; it is said he did not sleep till he got on ship-board. All that day nothing was to be seen in Dublin, but officers, carriages, and dusty wounded soldiers, with several of King James's horse guards coming in straggling, without pistols or swords, and the principal Popish persons of the town, their wives, and families going away. The gates were still kept by the Irish militia, and the castle by 250 of the Governor's foot soldiers, who still threatened that before they left the city they would burn and plunder it; this of a long time had been their talk (as we have heard,) though King James said, *it was a report raised by the Protestants, to make him odious;* yet some Irish persons of note advised their Protestant friends a few days before this, to leave the town, because they would not be safe there.


The Protestants (some of whom were crowded into the hospitals, colleges and churches, others into stinking, nasty, unhealthy rooms) knew not yet what to think of themselves; but hoped the English were so near as to prevent their being burnt; but about four in the afternoon, instead of them, they perceived the Irish horse, which were drawn out in the morning, and thought to be quite gone, entering the town, followed by the French and Irish foot in a full body; presently a noise run through the city, that they were come to fire it; and the Papists who had secured themselves in Protestants houses began to look brisk again; but all these forces marched through the town, without doing any injury, and were drawn up by Tyrconnel, on the further side of it, to march away; the militia followed them, only the Governor remained, who at last resolved to march also, and drive two or three hundred of the principal Protestant prisoners before him; but while they were preparing for this, a false alarm was spread, that a party of English being landed at the harbour, were just at the town's end, it was too dusky to discover the truth, and they had not time to send a messenger; but in haste shifted for themselves. The Protestants now began to look out (whom the Irish had released, not out of love to them; but for fear the English were at their heels), yet knew not well in what condition they were; but venturing to the castle, they found Captain Farlow, who had been prisoner there, keeping garrison alone, upon which Captain Fitz-Gerald, and several others, who had been prisoners, went and *stayed* there all night; still they were unsecure, and had no arms. Early next morning, July 3, the Protestants run about



---

p.115




to the Papists houses, demanding their arms, who being quite dispirited, delivered them without dispute; and the Bishop of Meath, Dr. King, and several other principal Protestants, sent away an express to King William, that the town was at liberty, desiring his Majesty's presence and protection, and began to form a Protestant militia. Till Thursday, July 3, in the afternoon, they heard not a word of the English army, and reports were raised, that the French and Irish were coming back, which much damped the Protestants; but this was soon blown over, and they now perceived themselves to be free, which filled their hearts with so much joy, that they run about saluting and embracing one another, and blessing God for this wonderful deliverance, as if they had been raised from the dead: the streets were filled with crowds and shouts, and the Papists were now under the same terrors that they had been in some days before. At 8 that night, one troop of English dragoons came as a guard to an officer, who was sent to take charge of the stores; it is impossible to express the rejoicing of the People at sight of them; they hung about the horses, and were ready to pull the men off, and hug them in their arms, as they marched up to the castle.


The night after the battle, the English lay upon their arms at Duleek, and next morning a party were sent to fetch the tents and baggage from beyond the Boyne, and another party of 1000 horse and dragoons, and 300 foot, and eight pieces of cannon, marched to summon Drogheda. The Governor received the first summons very indifferently; but being threatened that if he forced the cannon to be fired on them, they should have no quarter; thereupon he believing that the Irish army was totally routed, surrendered upon condition, to be conducted to Athlone, there being about 1300 of them, who marched out without arms, according to agreement.


July 3, King, William marched forward, and was met at Bally Brigham by one Mr. Saunders, from the Protestants of Dublin, with a tender of their allegiance. The Duke of Ormond marched thither with 1000 horse, and the Dutch guards took possession of the castle; and two days after his Majesty came to Finglass, within two miles of Dublin, 300 citizens coming to wait upon, and welcome him and his army, and abundance of people flocked from all places to see the camp, and their great deliverer, whose just merits found commendations from his very enemies; and whose soul is not subject to fear, or any thing that is below a Prince; and who is only faulty in exposing his royal Person too far. On Sunday, his Majesty went to St. Patrick's church in Dublin, and returned to his camp to dinner; and on Monday, the bishops



---

p.116



 

and clergy presented a very loyal address, the Bishop of Meath making a speech, telling his Majesty, ‘That they came not to beg his protection, for he had given sufficient demonstrations of his affection toward them, by venturing his royal person for their deliverance; but they came to congratulate his arrival, to pray for the continuance of his good success, and to give his Majesty all the assurance imaginable of their loyalty and obedience, intreating him not to think the worse of them for staying in Ireland, and submitting to a power, that it was impossible for them to resist, since they had been as serviceable to his Majesty's interest by staying, as they could have been otherwise,’ &c. The King made answer: ‘That as he had, by the blessing of God, succeeded so far, he doubted not, but, by God's assistance, to free them absolutely, and that in a short time, from Popish tyranny, which was his design in coming.’ They then desired his Majesty's leave to appoint a day of public thanksgiving, which was done accordingly.


The Irish went away in such haste, that they left 16,000£ in brass money in the treasury, and a great quantity of French souses; of the first of which King James coined above 11,000£ the half crowns of which were now cried down for pence; yet this did not grate so heavily upon the people, as his late taking away all the Protestant staple goods, as wool, hides, and tallow, to send to France in exchange for wine and linen for his army: their tanned leather was also taken away for the use of the soldiers. The revenue he raised otherwise, was by a subsidy granted by Parliament of 27,000£ a month, for thirteen months, which fell severely upon the Protestants, who were forced to pay ready money, though by plundering they were generally deprived of their stocks, rents, and incomes; and to *show* what future security they were like to have for their estates, King James, by proclamation, under pretence of his prerogative royal, laid a tax of 20,000£ a month, for three months, upon goods and chattels, that granted by Parliament being only upon land. This way of levying money startled every body: the pretended Parliament was then in being, and adjourned till January 12, 1689, which happened to be about the very time when the King and his council were upon this project, some in the council opposed it, alleging, ‘That there was no need of levying money by extraordinary ways, when it might be had otherwise; and that it would cause his enemies to say, that he affected arbitrary power:’ but he was very angry with those that *sspoke* against it, saying, ‘That they had made him believe it was a branch of his prerogative to levy money, and if he could not do that, he could do nothing.’ And thereupon Popish commissioners were appointed to assess it, who 



---

p.117




never failed to lay the greatest burden upon their Protestant neighbours, who, in effect, paid all the taxes that King James ever received in Ireland.


July 7th, King William published a declaration, assuring all labourers, soldiers, farmers, ploughmen, and courtiers, as also all citizens, tradesmen, townsmen, and artificers, of his royal protection, who should return to their abodes by August 1, and deliver their arms to the justices of peace, and that they should be secured in their legal rights, goods, stocks, and chattels, &c. The next day the King took a view of his army by distinct regiments, and though it rained very fast, yet his Majesty *sat* on horseback in the midst of it. It was observable, that with heat, dust, and marching, most of the soldiers had got very sore lips; nor was his Majesty himself exempt from this inconvenience, for he had toiled and laboured as much as the best of them.


July 9th, the King had an account of the misfortune of the English and Dutch fleets, and at the same time he divided his army, going himself with the greatest part westward, and sending Lieutenant-general Douglas with three regiments of horse, two of dragoons, and ten of foot toward Athlone, about fifty miles from Dublin. In their march they took two spies, with letters from Athlone; one was to advise one Tute to defend an island near Mullingar, in which the governor had store of horses, and other things of value. Another letter was from an officer at Athlone, to his father in the country, telling him, ‘That the Lord Tyrconnel, Duke of Berwick, and several other great officers, were come to Limerick with a good body of horse, and that all their army would be there in two or three days, so that they would make either a hog or a dog of it (as he expressed it); that the Dauphin was landed in England with a great army; that the French had beat the English and Dutch fleets; that Duke Schomberg was dead, and it was said the Prince of Orange was so too; that their King was gone to France, but it was no great matter where he was, for they were better without him.’ Then he advised his father not to take a protection from the English, because those that did so were looked upon as enemies: and after his letter was sealed, he had writ on the outside, ‘Just now we have an account from a gentleman that is come to us from Dublin, that Orange is certainly dead, so that all will be well again.’ Such were their hopes and expectations at that time; yet we find that the Irish had but a mean opinion of King James, some of them saying, ‘That he was fitter to be a monk than a King;’ and Sarsfield, sometime afterward speaking of the action at 



---

p.118




the Boyne, swore, ‘If the English would change Kings, they would fight it over again and beat us;’ so material is the courage and countenance of the chief commander in an army, especially a King, which makes his nobility, gentry, and officers, strive to imitate his example, by which he is better served, and commonly more fortunate.


July 17th, the army encamped within a mile of Athlone, the enemy playing the great guns on them as they marched, with little damage. The general sent a drum to summon the town, but old Colonel Grace, the governor, fired a pistol at him, and sent word, these were the terms he was for: upon which the English were contriving to raise batteries, but the enemy having made provision for their coming, and Lieutenant-general Douglas not having cannon large enough to endamage the town, and also very little bread, it was resolved by a council of war to remove from the town, which was done at twelve at night, with all their baggage, the enemy not so much as firing one gun at them; and soon after they joined the King's army.


July 9th, his Majesty encamped at Crumlin, two miles west of Dublin, where he settled the method of granting protections to those Irish that would submit to the government; and gave orders that, upon pain of death, no soldier should dare plunder the country, or any protected person, nor to take violently the least value from either Protestant or Papist, abuses of this kind having been lately complained of. Two days after, the King passing by the Ness, saw a soldier robbing a poor woman, which enraged his Majesty so much, that he beat him with his cane, and commanded that he and others, found guilty of the like disobedience, should be executed; which had so good an effect upon that army, that no pilfering happened for a long time after. The King had notice in his march of the confusion of the enemy, and their resort to Limerick; and people from Kilkenny gave an account, that some Irish horse and foot were there still, but with thoughts of quitting it upon our approach; which they did, after having forced the inhabitants to give them a sum of money to save the town from plundering; upon which a party of the horse, under the Duke of Ormond, went to take possession of the place.


July 19th, the King dined with the Duke at his castle of Kilkenny, which Count Lauzun had preserved with all the furniture in a good condition, the cellars being well furnished with wine, which they had not time to drink at their going off. Colonel Epinger was sent from thence with 1,000 horse and dragoons, to secure the town of Wexford, which was deserted by the Irish garrison: as also Clonmell, whither Count Schomberg marched with a body of horse, being one of the



---

p.119




strongest towns in Ireland, and cost Cromwell 2,000 men in taking it: the Irish pretended to defend it now, and levelled the suburbs and hedges, but at length marched off, having got 300£ of the people to secure it from burning and plunder.


July 22d, Major-general Kirk sent a trumpet to summon the town of Waterford to surrender, which they refused in very civil terms; but at length, on the 25th, they delivered it up on articles, and at the same time the strong fort of Duncannon, seven miles below Waterford, was surrendered upon the like terms. The King went into Waterford, and took care that none should be disturbed in their persons or goods. At the King's return to his camp, his Majesty held a council, where he declared his resolution to go for England, upon some accounts he had from thence, leaving Count Solms commander in chief; but a few days after, having advice from England that the French were gone off the coast, and had only burnt a small village in the west, his Majesty resolved to return to the army; and August 8th, the Lord Portland and Brigadier Stuart were sent toward Limerick



---

p.120




with about 1,100 (horse and foot, and the next day the whole army advanced. The King having ordered their several posts, sent a trumpet to summon the town: it seems a great part of the garrison were for surrendering it, but Mons. Boileau, the French governor, the Duke of Berwick, and Colonel Sarsfield, much opposed it, telling the soldiers, ‘That there were great divisions and insurrections in England; that the Dauphin was landed there with 50,000 men, and that the Prince of Orange would be obliged soon to draw home his army to England.’ The trumpeter was sent back from Mons. Boileau, with a letter directed to Sir R. Southwell, secretary of state, not sending directly to the King, because it is thought he would avoid giving him the title of Majesty—‘That he was surprised at the summons, and that he thought the best way to gain the Prince of Orange's good opinion, was by a vigorous defence of that town, which his Majesty had entrusted him withal’. The next morning a cornet deserted the enemy, who told King William, ‘That a great many were for surrendering; that Count Lauzun, with the French, were encamped nigh Galway, the Irish refusing to receive them into the town, because themselves had done so some time before at Limerick; that Tyrconnel, with most of the Irish horse, and some foot, were encamped about eight miles on the other side of Limerick; that there were fourteen regiments of foot, three of horse, and two of dragoons then in the town.’


This city is very strong, both by nature and art, and the Irish had now added some new fortifications to it. In 1651, Lieutenant-general Ireton laid siege to it for several months, and did not take it at last, for it was in some measure betrayed to him by one Colonel Stennel and others of the Irish, who, against the governor's consent, received in two or three hundred men, thereby getting possession of the town. Ireton hanged the mayor and several others that were still for defending it.


When his Majesty *sat* down before Limerick, he had only a field train of artillery, because some imagined the town would have surrendered upon summons; but it being refused, six cannon, called pounders, two eighteen-pounders, a great quantity of ammunition, provisions, tin boats, and abundance of other materials, were upon the road from Dublin, under the convoy of two troops of Colonel Villars's horse, of which Sarsfield having intelligence by a French gunner who went over to the enemy, he passed the river in the night with a body of horse; for being satisfied, that if this train arrived before Limerick it would not be able to hold out, he resolved to run the hazard of destroying them: if he succeeded, he broke our measures;



---

p.121




if not, he designed for France, as he afterward declared. The King had notice of his march, and to prevent the worst, ordered 500 horse to march and meet the guns; but by some neglect in the officers, it was one or two o'clock in the morning before the party marched, which they then did very slowly, till about an hour after they saw a great light in the air, and heard a strange rumbling noise, which they imagined to be the blowing up of the train, as really it was: for on Sunday night, August 11, the guns lay at Cashel, and on Monday they marched beyond Cullen to a little old ruinous castle, called Ballymedy, not seven miles from the camp, and being so near did not fear an enemy, especially having no notice; and therefore being weary of marching, had turned most of their horses to grass, leaving a very slender guard, and the greatest part went to sleep; but some never awaked in this world, for Sarsfield lurking among the mountains all the day, and being guided through by-ways to the very spot, he unawares fell in upon them, and cut several to pieces, with some waggoners and country people that were coming to the camp with provisions. The chief officer seeing how it was, commanded to sound to horse; but those that went to fetch them up were killed by the way. The officers and others, after the best resistance they could make, were forced to shift for themselves, with loss of horses and goods: a lieutenant and some few troopers were killed, in all about sixty. The Irish got what horses they could, some broke the boats, others the guns, and drawing all the carriages and waggons, with bread and ammunition together in a heap, what they could not carry away, they laid a train and fired at their going off, blowing up all with an astonishing noise, whereby every thing that would burn was reduced to ashes. The party of horse that were sent against them came when the business was over, in sight of the enemy's rear, but wheeling toward the left, to intercept their passage over the Shannon, they unhappily went another way. This was very unwelcome news in the camp; however, the siege went on, and several more guns were planted, and firings continued briskly from divers batteries.


August 12th, Brigadier Stuart went with a detachment of men and four field pieces toward Castle-Connel, upon whose approach the garrison, consisting of 126, surrendered, and were brought prisoners to the camp.


August 19th, our batteries played upon the walls and houses of Limerick, and the King riding softly up toward Cromwell's Fort, as his horse was entering a gap, a gentleman stayed his Majesty to speak



---

p.122




with him, and in that very moment a great cannon bullet was shot into, that very place, which would have struck his Majesty and horse too all in pieces, if his usual good angel had not defended him; yet it raised the dust all about him, of which he took little notice, but alighting, came and laid him down on the fort among all the dust.


August 20th, a brisk attack was made by Colonel Cutt's grenadiers, who, with some others, made themselves masters of a fort near St. John's Gate; after which the enemy sallied out of the town, and a very hot action happened, but the Irish were at length beat back into the town, with the loss of 300 men; of ours, 58 foot were killed, and 140 wounded; of horse, 21 killed, and 52 wounded.


August 23d, a truce was made for burying the dead on both sides. We found a French officer wounded, and his horse lying upon him, and yet he was alive and recovered, though he lay from Wednesday to Saturday. A chaplain in the army happened to go down after the fort was taken, and seeing a trooper, as he thought, mortally wounded, he went to give him good advice, which the other was very thankful for: in the mean time comes the sally, and our horse came thundering down, at which the clergyman hastening away, fell down; the wounded trooper seeing him fall, thought he had been dead, and went to strip him, having soon got off his coat, at which the other called to him to hold, asking him what he meant. ‘Sir,’ says the trooper, ‘I beg your pardon, for I believed you were killed, and therefore I thought myself obliged to take care of your clothes, as well as you did of my soul.’


August 27th, a breach, about twelve yards long, and pretty flat, being made nigh St. John's Gate, the King gave orders for attacking the counterscarp that afternoon, which was done by 500 grenadiers, and some other regiments of foot and horse, with much resolution. The Irish having all their guns ready, discharged great and small shot among them abundantly, and our men were not behind in either; so that in two minutes the noise was so terrible, as if the skies had rent asunder; which was seconded with dust, smoke, and all the terrors that the art of man could invent to ruin and undo one another, the excessive heat making it yet more uneasy. The grenadiers threw in their grenadoes, and afterward got upon the counterscarp; upon which the Irish were throwing down their arms, and running into the town with all speed, which our men perceiving, entered the breach pell mell upon them, and above half the Earl of Drogheda's grenadiers, and some others, were actually in the town; the regiments that were to second the grenadiers went to the counterscarp, and having no



---

p.123




order to go further, stopped. The Irish were all running from the walls, and quite over the bridge into the English town, but seeing only a few of our men enter, they were with much ado persuaded to rally. Those English that were in seeing themselves not followed, and their ammunition being spent, designed to retreat again, but some were shot, others taken, and very few came out again unwounded. The Irish then ventured on the breach again, and from the walls and all other places severely pestered those on the counterscarp for three hours together with bullets, stones, and broken bottles, even from the very women, who boldly stood in the breach, and were nearer our men than their own; so that the ammunition of the besiegers being spent, they thought it safest to return to their trenches. In the heat of the attack the Brandenburg regiment, who behaved themselves very well, were got upon the Black Battery, where the enemy's powder happened to take fire, and blow up a great many of them, the men, faggots, stones, &c. flying into the air with a dreadful noise. From half an hour after three till seven, there was one continued fire of both great and small shot without intermission, insomuch that the smoke from the town reached in one continual cloud to the top of a mountain at least six miles off. When our men retreated, some were brought out of the trenches dead, others without a leg or arm, and several blind with powder; and among them a great many Brandenburgers, who looked like furies with the gunpowder. The King stood nigh Cromwell's Fort all the time, and afterward went to his camp much concerned, as well as the whole army, a mixture of anger and sorrow appearing in all their faces. We lost at least 500 upon the place, and had 1000 more wounded: we killed a great number of the Irish by our cannon, but it cannot be thought their loss should be equal to ours, having the advantage of the walls to defend themselves. The soldiers were desirous of a second attack, seeming resolved to have the town, or die every man; but they did not know the scarcity of our ammunition, and besides it began to rain, and the next day rained very fast, so that it was resolved by a council of war the siege should be raised. We found some difficulty in getting off our cannon, the ways were so soft with the wet, and we also obliged to draw them off with oxen, the enemy having taken part of our train-horses, which was one main reason of raising the siege. In a day or two after, Mons. Boileau, the governor of Limerick, made a speech to the Irish, telling them, ‘That with much ado he had persuaded them to defend the town, which with God's help they had done; but assured them it was not fear, but prudence and policy, that had made the English quit



---

p.124




the siege, as appeared by their slow marches;’ and withal told them his opinion, that the next time the enemy came they would have it; which said, he took leave, and went to the French forces then at Galway, and designed for France.


The day the siege was raised, the King went to Waterford, and thence to England, sending the Lord Sidney, and Thomas Coningsby, Esq. to the camp, with a commission to be Lords Justices.


Sept. 8th, the Lord Lisburn went before Kilmallock, being a garrison of 200 men, which, upon the approach of our forces, yielded on the first summons, Nignah Castle having done the like some time before to Major-general Ginkle.


September 21st, the Earl of Marlborough landed near Cork with several forces, and was joined by Major-general Scravenmore and others, who presently invested the town, and soon after made a breach in the walls, so that after seven days siege the garrison surrendered upon articles.




---

p.125


October 2d, the Earl of Marlborough marched thence to **Kingsale**; the town was presently delivered: he then sent a summons to the governor to surrender up the forts, who returned answer, *That it would be time enough to talk of a surrender a month hence:* upon this several batteries were raised against the old, and afterward the new fort, which played with such success, that they were both delivered up October 15th following. After the taking these two places, part of the Irish army in Kenneigh made several incursions, and burnt all the towns and villages of the counties of Limerick and Cork, and the enemies gave leave to several Protestants to come from Limerick, where all provisions were very scarce. In November, General Ginkle returns to Dublin. In December, several Rapparees were got to the end of the Bog of Allen, about twelve miles from Dublin, it being about forty miles in length, and having several woody islands, from whence they plundered all the adjacent country; but Colonel Fouks drove them from their posts. Several small skirmishes happened in the winter between the English and the Rapparees, wherein the first obtained divers notable advantages, though generally their parties were much inferior to the enemy, which was a great disheartening to them.


May 7th, 1691, the whole army took the field under General Ginkle, and the Irish were busy in making preparations for their defence, having a new French general, named St. Ruth, sent them, who issued out all orders in King Lewis's name, and required the Irish officers to take new commissions under the French King, in prosecution of the design of subjecting Ireland to France. The first place the English attempted was Ballymore, seated upon an high tongue of firm land, jetting out into a lake, and strengthened with several fortifications: five batteries were raised against it, and the next morning the General sent a messenger to the governor, ‘That if the garrison would surrender within two hours, he would save their lives, and receive them as prisoners of war; if not, that they should expect no quarter.’ The governor would not return a direct answer, in hopes of better terms; whereupon several breaches were made, which put them into such a consternation, that divers white flags were hung out, and May 9th the garrison surrendered, out of which marched above 1000 soldiers and Rapparees, and about 600 women and children.


June 18th, the army marched from Ballymore, and the next day came before Athlone, and thought it very strange to see none but French colours in four parts of an Irish garrison: a battery of ten guns was instantly planted, which were so well directed, that in a 



---

p.126




few hours the bastion against which they played was laid in ruins, and thereupon General Ginkle ordered an assault to be made. The enemy seemed at first resolved to have maintained the breach, but upon sight of the hand grenadoes, they fled in great confusion to the other side of the town, which was divided by a river; so that the English had nothing to do but to enter, not twenty of our men being wounded, and some few slain. One part of the town being thus taken, the cannon played with great success upon the castle and the enemy's works on the other side the river, the Irish having broken down the stone bridge: but the general resolved to ford the river to get to them, and accordingly, June 30th, the sign being given by ringing the church bells, 1,500 grenadiers, with whom Major-general Talmash 


went that day as volunteer, entered the water. The enemy at first fired very smartly, but the English wading up to their breasts in water with continual huzzaing, advanced under the smoke and shelter of their own cannon, and coming to the other side, they threw their 



---

p.127




grenadoes so furiously, that the enemy abandoned their posts and trenches, and in less than half an hour we were entirely masters of the town, with all the enemy's works, and the ruins of the castle. Major-general Maxwell and divers other officers, with 200 common soldiers, were taken prisoners, and near 1,200 killed on the place, besides several officers of note; the rest escaped over the ramparts, and fled to the enemy's camp, from whence some battalions were coming to their relief, but meeting the fugitives, and receiving a warm salute from those works, which were so lately their own, they retreated to their camp. The English in this unparalleled action had not above 20 slain, and 30 wounded.


The Irish army, upon reducing the town, decamped in the night, and retreated ten miles off: the English followed them, and having passed a river that lay between them and the enemy near Aghrim, after some skirmishing they drove in their out-guards, the English cannon having in the mean time dislodged the rebels' horse from the end of a narrow lane that leads to Aghrim. The Irish drew down great bodies of horse and foot from their camp, which was advantageously placed and strongly posted behind the high banks that lay one beyond another, and fell upon the left wing of the English, and had a warm dispute with our foot for two hours; but at last the rebels gave ground, notwithstanding new supplies of horse and foot were continually sent to relieve and second those that gave way; but the English courage surmounted all dangers, who charged so bravely up the hills upon the squadrons of the enemy, that they put them to an absolute rout, and pursued them about four miles, the night preventing them from following farther, it being six in the evening before they engaged, and eight before they took their flight. The Irish were never known to fight with more resolution, especially the foot; but it was their last effort, wherein the gasping honour of the choice of all the Catholic nobility and gentry in the kingdom strove to do their utmost: and, besides, their number was much superior to ours, being no less than 20,000 foot, and 8,000 horse and dragoons, with all the advantage imaginable that the situation of ground could afford them; so that nothing but the blessing of God, and the superior valour and conduct of the English, could have wrested such a complete victory out of their hands. Of the enemy, 8,000 were slain upon the place, and among them the French General St. Ruth, who was killed by a cannon bullet; the Lord Galway, and several others of quality; about 500 were taken prisoners, among whom were the principal commanders in the army, with 12 standards and 30 colours.




---

p.128


After the battle, the General sent Brigadier Epinger with 1,000 horse and dragoons to seize Portumna, where the rebels had a great magazine of provisions, who soon possessed themselves of it; and the next day the fort and castle of Bomaker surrendered, whereby the English became masters of all the passes upon the Shannon, except Limerick, and those within eight miles of it.


July 17th, the army came before Galway, and the General sent a trumpet to the Lord Dillon, governor of the town, that he should have quarter and pardon pursuant to the Lords Justices' proclamation, which he sent him, if he surrendered before the cannons were brought to fire upon the garrison. His answer was, That Mons. d'Ussone, who commanded, was of the same opinion with him and the rest of the officers, and that they resolved to defend the place to the last: upon which the English instantly made their approaches with such vigour, that they took a fort up on an hill which commanded a valley between them and the town, without the loss of one man, and then crossed over the river in two boats so suddenly, that the enemy were frighted into a treaty. Balderick O'Donnel, who designed to throw his brigade into the place, being prevented of his intentions by the prudent management of the general, so that July 26th, the city of Galway was actually surrendered, Mons. d'Ussone, according to his desire, marching out incognito some hours before.


August 25th, the army came before Limerick, and soon after several batteries were raised against the city. The General hearing that some regiments of the enemy's horse and Rapparees were drawn together in Kerry, about sixteen miles off, he sent away Brigadier Levison with 500 horse and dragoons in pursuit of them, which they did so effectually, that few of them escaped. The English at the siege advanced to Cromwell's Fort, the enemy quitting both that and their line of communication to the church, and returned to their entrenchments near the town. About the same time the Earl of Tyrconnel died, as was certainly said, out of anguish of mind, to see the ruinous condition of his master's affairs, and was buried at Limerick. The General having notice that Colonel Henry Lutterel was seized by order of the French Lieutenant-general d'Ussone, for having made some proposals for a surrender, and that he was sentenced to death by a court martial, he sent word to the monsieur by a trumpet, that if any man were put to death for having a mind to come over to the English, he would revenge it double upon the Irish prisoners, which prevented his death. Several forts and castles about the town were daily taken in, and the batteries played continually upon the city, which set it on fire in divers



---

p.129




places, and ruined the walls and castle. About the same time, the Irish having put between two and three hundred Protestants into a little island in the Shannon, under a sufficient guard, their sad and starved condition so moved the compassion of the Irish officers who guarded them, and were also desirous to go over to the English, that they sent to Major Stroud, who was posted hard by with some of the militia, to let him know their intentions; upon which the Major went over with a party in small boats, and brought away both the guards and prisoners, who were almost starved for want of food, in a place where they had only two pitiful huts to shelter them from the cold and rain.


September 8th, a great battery of twenty-two pieces of cannon began to play very early in the morning, and in a short time made a breach of above thirty yards in the English town, and firing without intermission, made terrible havoc, dismounting the enemy's cannon, set the English town several times on fire, and laid the greatest part in rubbish. Some of the bombs fell into the enemy's stores, burnt two of their magazines of biscuit, one of brandy, and one of powder, so that they were forced to remove the remainder into the Irish town.


September 15th, the Lord Lisburn was killed by a cannon ball, and two days after Sligo was taken by the Earl of Granard, the garrison consisting of five or six hundred men, who left in the place sixteen pieces of cannon, thirty barrels of powder, with shot and provisions proportionable. One Captain Taaffe came out of Limerick to the English, and informed the General that the English town was utterly ruined; that the cannon and bombs had killed a great number of the garrison, who were reduced to 6,000 foot, and very ill clad.


General Ginkle having resolved that part of the army should pass the Shannon, and remove the Irish horse which lay in the county of Clare, and so shut up the town on that side, to conceal his design, he ordered the heavy cannon to be drawn off and shipped, and quitted several castles, as if he intended to raise the siege; which the enemy observing, expressed their joy by loud and repeated shouts: but the game night the pontons were secretly laid over the Shannon, and by break of day the royal regiment of dragoons, and a detachment of horse, passed the river undiscovered. Brigadier Clifford lay with four regiments of dragoons, to have prevented their landing; but when he perceived they were got over, he brought down all his men on foot (their horses being at grass) to make what opposition they could, but



---

p.130




were presently routed, and for haste threw away their arms, leaving behind them all their tents, baggage, saddles, and other accoutrements, with two pieces of cannon, and a standard. These frequent successes much intimidated the enemy, and the French that were in Limerick had some time before endeavoured to get away, but a squadron of English and Dutch men of war, and the provision and ammunition ships from **Kingsale** being by the General's orders come into the Shannon, they returned back again, but a vessel, on board which were St. Ruth's goods and plunder, attempting to get out of the Shannon, was taken by one of their Majesties frigates.


Sept. 22, The General passed the Shannon with a strong party of horse, dragoons, and foot, and 14 pieces of cannon; who were drawn up before the Irish town, notwithstanding the continual fire of the enemy; and then ordered them to attack the fort that secured Thomond bridge: the besieged at the same time sending two great detachments to reinforce and second the Irish that defended it. However, the English went on with such courage and bravery that they beat them from their works, and forced them to fly toward the town; but the Governor fearing the victorious English would enter with them, durst not let down the draw-bridge to receive them; which occasioned a great slaughter of the vanquished Irish, so that nothing was to be seen from the foot of Thomond bridge to the draw-bridge but heaps of dead bodies; 600 of the enemy were slain, and 130 taken prisoners, and among them several great officers. Whilst the conflict endured, the Irish played very furiously with their great and small shot; and the metal of the English precipitating them too far, exposed them to the enemy's fire, whereby many more were killed than would have been otherwise; so that near 300 were slain and wounded, though not any one of remark. The next day afternoon, the enemy beat a parley on both sides the river, and desired a truce, to be continued for three days, that they might send to their horse which lay about Clare, to know upon what conditions they desired to be comprehended in the capitulation.


Sept. 25, Colonel Sheldon and other Irish officers came into the English camp, and from thence to Limerick; the next day Sarsfield and Nohop dined with the General; and the Lord Cutts, and Sir David Collier, Colonel Tiffany, and Colonel Piper were sent as hostages into the town, and four Irish lords remained in the camp as hostages for the garrison.


Sept, 27, The Irish sent them out their proposals, which the General not approving, instead of an answer sent back twelve other articles,



---

p.131




which were all he would allow them, and at the same time gave orders for the great guns and mortars to be ready if they refused to consent to them; who seeing the General's resolution, and finding no other remedy, at length, October 3, the articles of capitulation were signed; consisting of two parts, the first relating to civil affairs, which were signed by the Lord Justices, the General, and the persons deputed by the garrison; the other in reference to military affairs, which were subscribed by the generals on both sides: such of the French and Irish as had a mind to pass the seas, were to have liberty, for their present convenience, to stay in the English town and island till they could be shipped away, and the castles of Ross, Clare, with all other places and castles that were then in possession of the Irish, were forthwith to be delivered to the English. In pursuance of this agreement, one gate of the town was delivered up that evening, and the next day the Lord Cutts marched into the Irish town, and took possession of it with seven regiments of foot.


At this very time news came that divers French men of war, with transport ships, were on the coasts, and endeavoured to put into some places distant from Limerick, either not knowing the harbours, or being uncertain how affairs stood there; but at length, it seems, they had certain knowledge that Limerick had submitted and upon what terms and one article being, that such of the Irish and French as had a mind to leave the kingdom and go to France might stay to expect a free passage thither without disturbance; the French being hereby assured not to be attacked by our men of war, they boldly appeared on the coasts of Kerry, being; about twenty-five men of war, and twenty-five transport ships, with some fire-ships, having aboard 1000 arms, wine, brandy, and other provisions. And that it might be thought their design coming was only to carry off the French and Irish that were unwilling to stay, Monsieur D'Ussone, the late French governor, took the first opportunity to give notice of them to Major-General Talmash, who was appointed by the General to command in Limerick; whereupon it being judged most convenient that they should transport themselves in French ships, than to trust ours in the enemy's ports, the transport ships were admitted to come into the river Shannon, but the men of war and fire-ships to keep out at sea, and those transport ships to have liberty to take on board such as would freely embark.


But the Irish noblemen and gentlemen having been made too sensible of the French insolency in their own country, resolved not to trust to their kindness in France, and therefore many of them, as well as some chiefs of the Rapparees, came in, and freely took the oath of



---

p.132




fidelity to their Majesties. But others being promised great advantages in France, were persuaded by Sarsfield, Sheldon, and other commanders, to embark with them, and make their fortunes in the service of the late King James.


Nov. 1, The Irish entirely left the English town of Limerick, and part of them went aboard the French ships, one of which that carried 400 men, with several valuable goods, ran upon a rock, and about 100 were drowned.


Dec. 22, The remainder of the Irish, being about 2600 men, women, and children, were by Sarsfield embarked from Cork to France, though he thought to have carried off a far greater number, but several whole regiments deserted him upon advice of the ill treatment the Irish already landed in France had received, where the officers were generally displaced, or made to serve in lower stations, and Frenchmen put over their heads. After this, Colonel Foulk, Governor of Dublin, had orders to disband the Irish regiments that came over to us upon the surrender of Limerick, except 1400, who were sent into the service of the Emperor of Germany.


Ireland being thus happily reduced to the obedience of their Majesties, General Ginkle went to Dublin, where he and the rest of the gallant commanders were received with a general joy and the highest marks of respect to their merits, who had been so serviceable to the kingdom. Soon after the General embarked for England, and was received very graciously by their Majesties, and created Earl of Athlone, the Parliament likewise sending their thanks to him for his good services, desiring him to communicate the same to all the officers that served under him in this expedition. And he, together with them, was highly entertained with a noble treat by the city of London.


The Lords Justices were very diligent to settle matters in Ireland, which now began to breathe again, after such ruins and devastations as had been made by the brutish Irish; and the Parliament in England abrogated the oath of allegiance in that kingdom, and ordered another oath to be taken. Sir David Collier was made Governor of Limerick.


In August, 1692, the Lord Viscount Sidney being constituted Lord-Lieutenant of Ireland, arrived there, and was received with loud peals of cannon, and complimented by the nobility; and after having taken the oath, the sword was delivered to him, and the day ended with acclamations of joy, and bonfires; and soon after his Excellency issued out writs for calling a Parliament in that kingdom, who met accordingly, and his Excellency in an eloquent speech declared ‘The happiness they enjoyed by being restored to this great privilege, since



---

p.133




the kingdom could not so well be recovered to any degree of settlement legally as by a Parliament constituted and settled; and that he hoped they would make use of it to pass such laws as might tend to the firm settlement of the country upon the Protestant interest, and that it would be a great satisfaction to his Majesty to see them established in peace and prosperity, having had so great and glorious a part in relieving them from the calamities under which they laboured.’


After this the Commons presented their Speaker, and proceeded to swear their members; they then ordered an address of thanks to be drawn up to his Majesty, and another to the Lord-Lieutenant, and then passed, ‘1. an act of recognition of their Majesties undoubted title to the crown of Ireland. 2. For encouraging Protestant strangers to settle in that kingdom. 3. For an additional excise upon beer, ale, and other liquors. 4. For taking affidavits in the country.’ After which the Parliament was prorogued to April, and from thence to September 1693.




---

p.134


1. Sir Charles Porter, Knight, Lord Chancellor
2. Dr. Michael Boyle, Lord Arch-bishop of Armagh, Primate of Ireland
3. Dr. Fr. March, Archbishop of Dublin
4. Dr. Narcissus March, Archbishop of Cashell
5. Dr. Joseph Vesey, Archbishop of Tuam
6. Richard, Earl of Cork, Lord Treasurer


1. Butler, Duke of Ormond
2. Schomberg, Duke of Leinster


1. Fitz-Gerald, Earl of Kildare
2. O'Bryan, Earl of Thomond
3. Bourk, Earl of Clanrickard
4. Touchett, Earl of Castlehaven
5. Boyle, Earl of Cork
6. M'Donnel, Earl of Antrim
7. Nugent, Earl of Westmeath
8. Dillon, Earl of Roscommon
9. Ridgeway, Earl of Londonderry
10. Fielding, Earl of Desmond
11. Brabazon, Earl of Meath
12. Barry, Earl of Barrymore
13. Vaughan, Earl of Carbury
14. Plunket, Earl of Fingal
15. Chichester, Earl of Donnegal
16. Lambert, Earl of Cavan
17. O'Bryan, Earl of Inchiquin
18. Mac-Carty, Earl of Clancarty
19. Boyle, Earl of Orrery
20. Coote, Earl of Montrath
21. Moore, Earl of Drogheda
22. Talbot, Earl of Waterford and Wexford
23. Montgomery, Earl of Mount-Alexander
24. Palmer, Earl of Castlemaine
25. Taaffe, Earl of Carlingford
26. Power, Earl of Tyrone
27. Jones, Earl of Ranelagh
28. Aungier, Earl of Longford
29. Forbes, Earl of Granard
30. Dungan, Earl of Limerick
31. Coote, Earl of Ballymore
32. Ginkle, Earl of Athlone


1. Preston, Viscount Gormanstown
2. Roch, Viscount Fermoy
3. Butler, Viscount Mountgarret
4. Villiers, Viscount Grandison
5. Annesly, Viscount Valentia
6. Dillon, Viscount Costello and Gallen
7. Netterville, Viscount Dowth


---

p.135

10. Loftus, Viscount Ely
11. Beaumont, discount Swords
12. Magennis, Viscount Iveagh
13. Needham, Viscount Kilmurry
14. Sarsfield, Viscount Kilmallock
15. Burk, Viscount Mayo
16. Sanderson, Viscount Castletown
17. Chaworth, Viscount Armagh
18. Scudamore, Viscount Sligo
19. Lumly, Viscount Waterford
20. Smith, Viscount Strangford
21. Wenman, Viscount Tuam
22. Molineux, Viscount Maryborough
23. Fairfax, Viscount Emly
24. Butler, Viscount Kerrine
25. Fitz-William, Viscount Merion
26. O'Dempsey, Viscount Clanmalier
27. Cockaine, Viscount Cullen
28. Tracey, Viscount Rathcoole
29. Smith, Viscount Carrington of Barreford
30. Bulkley, Viscount Cashell
31. Brounker, Viscount Lyons
32. Ogle, Viscount Catherlough
33. Butler, Viscount Galmoy
34. Barnewall, Viscount Kingsland
35. Boyle, Viscount Shannon
36. Skeffington, Viscount Massareene
37. Cholmondeley, Viscount Kells
38. Fanshaw, Viscount Dromore
39. O'Bryan, Viscount Clare
40. Trevor, Viscount Dungannon
41. Boyle, Viscount Dungarvan
42. Berkely, Viscount Fitzharding of Beerhaven
43. Caulfield, Viscount Charlemont
44. Wingfield, Viscount Powerscourt
45. Boyle, Viscount Blessington
46. Lane, Viscount Lanesborough
47. Dawney, Viscount Down
48. Parsons, Viscount Ross
49. Steward, Viscount Montjoy
50. Loftus, Viscount Lisburn, extinct
51. Bourke, Viscount Galway
52. Brown, Viscount Kenmare
53. Mac-Carty, Viscount Mountcashell
54. Chevers, Viscount Mount-Linster


1. Bermingham, Baron of Athenry
2. Courcy, Baron of **Kingsale**
3. Fitz-Morris, Baron of Kerry and Lixnaw
4. Fleming, Baron of Slane
5. St. Lawrence, Baron of Howth
6. Barnewell, Baron of Trimleston
7. Plunkett, Baron of Dunsany
8. Butler, Baron of Dunboyne
9. Fitz-Patrick, Baron of Upper-Ossory
10. Plunket, Baron of Lowth
11. Burke, Baron of Castle-Connell
12. Butler, Baron of Cahir
13. Burk, Baron of Brittas
14. Steward, Baron of Castle-Steward, extinct
15. Foliot, Baron of Ballyshannon
16. Maynard, Baron of Wicklow
17. George, Baron of Dundalk
18. Digby, Baron of Geashill
19. Fitz-Williams, Baron of Lifford
20. Blaney, Baron of Monaghan
21. Malone, Baron of Clanmallowne and Courchy
22. Herbert, Baron of Castle Island
23. Calvert, Baron of Baltimore
24. Brereton, Baron of Loughlin


---

p.136

27. Hare, Baron of Coleraine
28. Sherard, Baron of Leitrim
29. Maguire, Baron of **Inniskillen**
30. Hamilton, Baron of Strabane
31. Hawley, Baron of Duncannon
32. Allington, Baron of Killard
33. King, Baron of Kingston
34. Barry, Baron of Santry
35. Annesly, Baron of Altham
36. Bellow, Baron of Duleek
37. Petty, Baron of Shelburne
38. Fitton, Baron of Gawsworth
39. Bourk, Baron of Bophin
40. Nugent, Baron of Riverstown
41. Cutts, Baron of Gowran
42. Coningsby, Baron of Clanbrazil


1. Armagh.
2. Dublin.
3. Cashell.
4. Tuam.


1. Meath.
2. Kildare.
3. Waterford.
4. Clonfert.
5. Elphin.
6. Ferns and Leighlin.
7. Clogher.
8. Dromore.
9. Ossory.
10. Derry.
11. Down.
12. Killaloe.
13. Cork.
14. Limerick.
15. Cloyne.
16. Killala.
17. Raphoe.
18. Kilmore.


1. University, one, Dublin.



There are 32 Counties in Ireland, out of which are returned in all 275 Parliament-men.




---

p.137


1. 1603 Sir George Carey, Treasurer   
[*...*]  
 Deputy
2. 1604 Arthur Chichester, Lord Belfast   
[*...*]  
 Deputy
3. 1613 Thomas Jones, Lord Archbishop of Dublin   
[*...*]  
 Justices
4. Sir Richard Wingfield   
[*...*]  
 Justices
5. 1614 Lord Belfast   
[*...*]  
 L. Deputy
6. 1615 Lord Archbishop of Dublin   
[*...*]  
 Justices
7. Sir John Denham   
[*...*]  
 Justices
8. 1616 Sir Oliver St. John   
[*...*]  
 L. Deputy
9. 1622 Adam Loftus, Viscount Ely   
[*...*]  
 Justices
10. Richard Wingfield, Viscount Powerscourt   
[*...*]  
 Justices
11. 1622 Henry Carey, Viscount Falkland   
[*...*]  
 L. Deputy
12. 1629 Adam Loftus, Viscount Ely   
[*...*]  
 Justices
13. Richard Boyle, Earl of Cork   
[*...*]  
 Justices
14. 1633 Thomas, Viscount Wentworth   
[*...*]  
 L. Deputy
15. 1636 Adam Loftus, Viscount Ely   
[*...*]  
 Justices
16. Ch. Wandesford, Esq. Master of the Rolls   
[*...*]  
 Justices
17. 1636 Thomas, Viscount Wentworth   
[*...*]  
 Lieutenant
18. 1639 Robert Dillon, Lord Kilkenny, West   
[*...*]  
 Justices
19. Charles Wandesford, Esq   
[*...*]  
Justices
20. 1640 Thomas Wentworth, Earl of Strafford   
[*...*]  
Lieutenant
21. 1640 Charles Wandesford, Master of the Rolls   
[*...*]  
 Deputy
22. 1641 Sir William Parsons   
[*...*]  
 Justices
23. Sir John Borlace, Master of the Ordnance   
[*...*]  
 Justices
24. 1642 Sir John Borlace   
[*...*]  
Justices
25. Sir Henry Tichbourne   
[*...*]  
 Justices
26. 1643 James Butler, Marquis of Ormond   
[*...*]  
 Lieutenant
27. 1654 Charles Fleetwood   
[*...*]  
 Deputy
28. 1655 Henry Cromwell   
[*...*]  
 Lieutenant
29. 1659 Chancellor Steel   
[*...*]  
 Justices
30. Chancellor Baron Corbet   
[*...*]  
 Justices
31. 1660 Maurice Eustace, Lord Chancellor   
[*...*]  
 Justices
32. Roger, Earl of Orrery   
[*...*]  
 Justices
33. Charles, Earl of Montrath   
[*...*]  
 Justices


---

p.138

36. 1662 James Butler, Duke of Ormond   
[*...*]  
 Lieutenant
37. 1663 Thomas, Earl of Ossary   
[*...*]  
 Deputy
38. 1665 Duke of Ormond   
[*...*]  
 Lieutenant
39. 1668 Earl of Ossary   
[*...*]  
 Deputy
40. 1669 John, Lord Roberts   
[*...*]  
 Lieutenant
41. 1670 John, Lord Berkley   
[*...*]  
 Deputy
42. 1671 Lord Archbishop of Dublin   
[*...*]  
 Justices
43. Sir Arthur Forbes   
[*...*]  
 Justices
44. 1671 John, Lord Berkley   
[*...*]  
 Lieutenant
45. 1672 Arthur Capel, Earl of Essex   
[*...*]  
 Lieutenant
46. 1678 Duke of Ormond   
[*...*]  
 Lieutenant
47. 1684 Lord Primate   
[*...*]  
 Justices
48. Lord Granard   
[*...*]  
 Justices
49. 1685 Earl of Clarendon   
[*...*]  
 Lieutenant
50. 1686 Earl of Tyrconnel   
[*...*]  
 Lieutenant
51. 1690 Lord Viscount Sidney   
[*...*]  
 Justices
52. Thomas Coningsby, Esq.   
[*...*]  
 Justices
53. 1692 Lord Viscount Sidney   
[*...*]  
 Lieutenant












