

#The Fortunes of Sir Robert Ardagh


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Fortunes of Sir Robert Ardagh
=================================


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 2. Second draft.Extent of text: 10845 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2011) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E830000-003Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

*The Last Heir of Castle Connor* was first published in 1838 in the *Dublin University Magazine*.

#### Sources


**Editions**2. Joseph Sheridan Le Fanu, The Fortunes of Sir Robert Ardagh, The collected works of Joseph Sheridan Le Fanu, 3 volumes; introduction by Sir Devendra P. Varma, New York: Arno Press 1977. [Facsimile reprint of 1871 edition.]
3. Joseph Sheridan, The Purcell Papers, vol. 1, London:Bentley 1880. [Reprinted, with an introduction by Robert Lee Wolff (New York and London 1979).
**Further reading**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October-November 1916) 30–33.
8. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
9. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
10. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
11. V.S. Pritchett, The living novel, London: Chatto and Windus 1946.
12. Elizabeth Bowen, Collected Impressions, London 1950.
13. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
14. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
15. A.B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
16. Peter Penzoldt, The Supernatural in Fiction, New York: Humanities Press 1952.
17. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
18. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
19. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
20. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
21. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
22. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
23. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
24. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
25. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
26. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
27. E.F. Beiler, 'Introduction' to J.S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
28. J.C. Beckett, The Anglo-Irish Tradition, London 1976.
29. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London: Faber 1977.
30. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Athens, Ohio: Ohio University Press 1978.
31. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
32. Joseph Browne, 'Ghosts and Ghouls and Le Fanu', Canadian Journal of Irish Studies 8 (1982) 5-15.
33. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
34. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
35. Jolanta Nalecz-Wojtczak, 'Joseph Sheridan Le Fanu and New Dimensions for the English Ghost Story', in: Wolfgang Zach and Heinz Kosok (eds.), Literary Interrelations: Ireland, England and the World, vol. 2, Tübingen: Günter Narr 1987.
36. Victor Sage, Horror Fiction in the Protestant Tradition, London: Macmillan 1988.
37. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
38. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
39. Marie Mulvey-Roberts (ed.), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
40. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
41. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
42. Michael Charlesworth (ed.), The Gothic revival, 1720–1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
43. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
44. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
45. James Walton, Vision and Vacancy: the Fictions of J.S. Le Fanu. Dublin, University College Dublin Press, 2007.
**The edition used in the digital edition**2. The Purcell Papers. Joseph Sheridan Le Fanu First edition [3 volumes; volume 1 contains the story.] Richard BentleyLondon (1880)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 340–360.


#### Editorial Declaration


##### Correction


Text has been proofed once at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors, or inconsistencies of hyphenation in the hardcopy edition, are corrected using the corr sic="" tag.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word (and punctuation mark).


##### Segmentation


div0=the story; div1=the section. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from other languages are marked.


#### Canonical References


This text uses the DIV1 element to represent the story. ### Profile Description


Created: 1838#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words are in Latin.


### Revision History


* (2011-10-18) Beatrix Färber (ed.)

* Corrections made to file header; file updated; new wordcount made.
* (2008-09-25) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2007-04-05) Beatrix Färber (ed)

* Proofing continued, structural and content markup added; file parsed; HTML file created.
* (2007-04-01) Beatrix Färber (ed)

* Header inserted; file proofed (1).
* (2007-02-12) Beatrix Färber (data capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E830000-003


### The Fortunes of Sir Robert Ardagh: Author: Joseph Sheridan Le Fanu




---

p.




---

p.340


The Fortunes of Sir Robert Ardagh
---------------------------------


### Being a second Extract from the Papers of the late

Father Purcell.

**The earth hath bubbles as the water hath—And these are of them.’’**

**William Shakespeare**, Macbeth. , III.1


In the south of Ireland, and on the borders of the county of Limerick, there lies a district of two or three miles in length, which is rendered interesting by the fact that it is one of the very few spots throughout this country, in which some vestiges of aboriginal forest still remain. It has little or none of the lordly character of the American forest, for the axe has felled its oldest and its grandest trees; but in the close wood which survives, live all the wild and pleasing peculiarities of nature: its complete irregularity, its vistas, in whose perspective the quiet cattle are peacefully browsing; its refreshing glades, where the grey rocks arise from amid the nodding fern; the silvery shafts of the old birch trees; the knotted trunks of the hoary oak, the grotesque but graceful branches which never shed their honours under the tyrant pruning-hook; the soft green sward; the chequered light and shade; the wild luxuriant weeds; the lichen and the moss—all, all are beautiful alike in the green freshness of spring, or in the sadness and sere of autumn. Their beauty is of that kind which makes the heart full with joy—appealing to the affections with a power which belongs to nature only. This wood runs up, from below the base, to the ridge of a long line of irregular hills, having perhaps, in primitive times, formed but the skirting of some mighty forest which occupied the level below.


But now, alas! whither have we drifted? whither has the tide of civilisation borne us? It has passed over a land unprepared for it—it has left nakedness behind it; we have lost our forests, but our 





---

p.341




marauders remain; we have destroyed all that is picturesque, while we have retained *every thing* that is revolting in barbarism. Through the midst of this woodland there runs a deep gully or glen, where the stillness of the scene is broken in upon by the brawling of a mountain-stream, which, however, in the winter season, swells into a rapid and formidable torrent.


There is one point at which the glen becomes extremely deep and narrow; the sides descend to the depth of some hundred feet, and are so steep as to be nearly perpendicular. The wild trees which have taken root in the crannies and chasms of the rock have so intersected and entangled, that one can with difficulty catch a glimpse of the stream, which wheels, flashes, and foams below, as if exulting in the surrounding silence and solitude.


This spot was not unwisely chosen, as a point of no ordinary strength, for the erection of a massive square tower or keep, one side of which rises as if in continuation of the precipitous cliff on which it is based. Originally, the only mode of ingress was by a narrow portal in the very wall which overtopped the precipice, opening upon a ledge of rock which afforded a precarious pathway, cautiously intersected, however, by a deep trench cut with great labour in the living rock; so that, in its original state, and before the introduction of artillery into the art of war, this tower might have been pronounced, and that not presumptuously, almost impregnable.


The progress of improvement and the increasing security of the times had, however, tempted its successive proprietors, if not to adorn, at least to enlarge their premises, and at about the middle of the last century, when the castle was last inhabited, the original square tower formed but a small part of the edifice.


The castle, and a wide tract of the surrounding country, had from time immemorial

belonged to a family which, for distinctness, we shall call by the name of Ardagh; and owing to the associations which, in Ireland, almost always attach to scenes which have long witnessed alike the exercise of stern feudal authority, and of that savage hospitality which distinguished the good old times, this building has become the subject and the scene of many wild and extraordinary traditions. One of them I have been enabled, by a personal acquaintance with an eye-witness of the events, to trace to its origin; and yet it is hard to say whether the events which I am about to record appear more strange or improbable as seen through the distorting medium of tradition, or in the appalling dimness of uncertainty which surrounds the reality.


Tradition says that, sometime in the last century, Sir Robert 





---

p.342




Ardagh, a young man, and the last heir of that family, went abroad and served in foreign armies; and that, having acquired considerable honour and emolument, he settled at Castle Ardagh, the building we have just now attempted to describe. He was what the country people call a *dark* man; that is, he was considered morose, reserved, and ill-tempered; and, as it was supposed from the utter solitude of his life, was upon no terms of cordiality with the other members of his family.


The only occasion upon which he broke through the solitary monotony of his life was during the continuance of the racing season, and immediately subsequent to it; at which time he was to be seen among the busiest upon the course, betting deeply and unhesitatingly, and invariably with success. Sir Robert was, however, too well known as a man of honour, and of too high a family, to be suspected of any unfair dealing. He was, moreover, a soldier, and a man of an intrepid as well as of a haughty character; and no one cared to hazard a surmise, the consequences of which would be felt most probably by its originator only.


Gossip, however, was not silent; it was remarked that Sir Robert never appeared at the race-ground, which was the only place of public resort which he frequented, except in company with a certain strange-looking person, who was never seen elsewhere, or under other circumstances. It was remarked, too, that this man, whose relation to Sir Robert was never distinctly ascertained, was the only person to whom he seemed to speak unnecessarily; it was observed that while with the country gentry he exchanged no further communication than what was unavoidable in arranging his sporting transactions, with this person he would converse earnestly and frequently. Tradition asserts that, to enhance the curiosity which this unaccountable and exclusive preference excited, the stranger possessed some striking and unpleasant peculiarities of person and of garb —she does not say, however, what these were—but they, in conjunction with Sir Robert's secluded habits and extraordinary run of luck—a success which was supposed to result from the suggestions and immediate advice of the unknown—were sufficient to warrant report in pronouncing that there was something *queer* in the wind, and in surmising that Sir Robert was playing a fearful and a hazardous game, and that, in short, his strange companion was little better than the devil himself.


Years, however, rolled quietly away, and nothing novel occurred in the arrangements of Castle Ardagh, excepting that Sir Robert parted with his odd companion, but as nobody could tell whence he came, so nobody could say whither he had gone. Sir Robert's 





---

p.343




habits, however, underwent no consequent change; he continued regularly to frequent the race meetings, without mixing at all in the convivialities of the gentry, and immediately afterwards to relapse into the secluded monotony of his ordinary life.


It was said that he had accumulated vast sums of money—and, as his bets were always successful, and always large, such must have been the case. He did not suffer the acquisition of wealth, however, to influence his hospitality or his housekeeping—he neither purchased land, nor extended his establishment; and his mode of enjoying his money must have been altogether that of the miser—consisting merely in the pleasure of touching and telling his gold, and in the consciousness of wealth.


Sir Robert's temper, so far from improving, became more than ever gloomy and morose. He sometimes carried the indulgence of his evil dispositions to such a height that it bordered upon insanity. During these paroxysms he would neither eat, drink, nor sleep. On such occasions he insisted on perfect privacy, even from the intrusion of his most trusted servants;—his voice was frequently heard, sometimes in earnest supplication, sometime as if in loud and angry altercation with some unknown visitant;—sometimes he would, for hours together, walk to and fro throughout the long oak wainscoted apartment, which he generally occupied, with wild gesticulations and agitated pace, in the manner of one who has been roused to a state of unnatural excitement by some sudden and appalling intimation.


These paroxysms of apparent lunacy were so frightful, that during their continuance even his oldest and most faithful domestics dared not approach him; consequently, his hours of agony were never intruded upon, and the mysterious causes of his sufferings appeared likely to remain hidden for ever.


On one occasion a fit of this kind continued for an unusual time, the ordinary term of their duration—about two days—had been long past, and the old servant who generally waited upon Sir Robert after these visitations, having in vain listened for the well-known tinkle of his master's hand-bell, began to feel extremely anxious; he feared that his master might have died from sheer exhaustion, or perhaps put an end to his own existence during his miserable depression. These fears at length became so strong, that having in vain urged some of his brother-servants to accompany him, he determined to go up alone, and himself see whether any accident had befallen Sir Robert.


He traversed the several passages which conducted from the new to the more ancient parts of the mansion, and having arrived in the old hall of the castle, the utter silence of the hour,





---

p.344




for it was very late in the night, the idea of the nature of the enterprise in which he was engaging himself, a sensation of remoteness from *any thing* like human companionship, but, more than all, the vivid but undefined anticipation of something horrible, came upon him with such oppressive weight that he hesitated as to whether he should proceed. Real uneasiness, however, respecting the fate of his master, for whom he felt that kind of attachment which the force of habitual intercourse not unfrequently engenders respecting objects not in themselves amiable—and also a latent unwillingness to expose his weakness to the ridicule of his fellow-servants, combined to overcome his reluctance; and he had just placed his foot upon the first step of the staircase which conducted to his master's chamber, when his attention was arrested by a low but distinct knocking at the hall-door. Not, perhaps, very sorry at finding thus an excuse even for deferring his intended expedition, he placed the candle upon a stone block which lay in the hall, and approached the door, uncertain whether his ears had not deceived him. This doubt was justified by the circumstance that the hall entrance had been for nearly fifty years disused as a mode of ingress to the castle. The situation of this gate also, which we have endeavoured to describe, opening upon a narrow ledge of rock which overhangs a perilous cliff, rendered it at all times, but particularly at night, a dangerous entrance. This shelving platform of rock, which formed the only avenue to the door, was divided, as I have already stated, by a broad chasm, the planks across which had long disappeared by decay or otherwise, so that it seemed at least highly improbable that any man could have found his way across the passage in safety to the door—more particularly on a night like that, of singular darkness. The old man, therefore, listened attentively, to ascertain whether the first application should be followed by another. He had not long to wait; the same low but singularly distinct knocking was repeated; so low that it seemed as if the applicant had employed no harder or heavier instrument than his hand, and yet, despite the immense thickness of the door, so very distinct, that he could not mistake the sound.


It was repeated a third time, without any increase of loudness; and the old man, obeying an impulse for which to his dying hour he could never account, proceeded to remove, one by one, the three great oaken bars which secured the door. Time and damp had effectually corroded the iron chambers of the lock, so that it afforded little resistance. With some effort, as he believed, assisted from without, the old servant succeeded in opening the door; and a low, square-built





---

p.345




figure, apparently that of a man wrapped in a large black cloak, entered the hall. The servant could not see much of this visitant with any distinctness; his dress appeared foreign, the skirt of his ample cloak was thrown over one shoulder; he wore a large felt hat, with a very heavy leaf, from under which escaped what appeared to be a mass of long sooty-black hair;—his feet were cased in heavy ridingboots. Such were the few particulars which the servant had time and light to observe. The stranger desired him to let his master know instantly that a friend had come, by appointment, to settle some business with him. The servant hesitated, but a slight motion on the part of his visitor, as if to possess himself of the candle, determined him; so, taking it in his hand, he ascended the castle stairs, leaving his guest in the hall.


On reaching the apartment which opened upon the oak-chamber he was surprised to observe the door of that room partly open, and the room itself lit up. He paused, but there was no sound; he looked in, and saw Sir Robert—his head and the upper part of his body reclining on a table, upon which burned a lamp; his arms were stretched forward on either side, and perfectly motionless; it appeared that, having been sitting at the table, he had thus sunk forward, either dead or in a swoon. There was no sound of breathing; all was silent, except the sharp ticking of a watch, which lay beside the lamp. The servant coughed twice or thrice, but with no effect—his fears now almost amounted to certainty, and he was approaching the table on which his master partly lay—to satisfy himself of his death—when Sir Robert slowly raised his head, and throwing himself back in his chair, fixed his eyes in a ghastly and uncertain gaze upon his attendant. At length he said, slowly and painfully, as if he dreaded the answer—


‘In God's name, what are you?’


‘Sir,’ said the servant, ‘a strange gentleman wants to see you below.’


At this intimation Sir Robert, starting on his feet and tossing his arms wildly upwards, uttered a shriek of such appalling and despairing terror that it was almost too fearful for human endurance; and long after the sound had ceased it seemed to the terrified imagination of the old servant to roll through the deserted passages in bursts of unnatural laughter. After a few moments Sir Robert said—


‘Can't you send him away? Why does he come so soon? Oh God! oh God! let him leave me for an hour—a little time. I can't see him now—try to get him away. You see I can't go down now—I have not strength. Oh God! oh God! let him come back in an hour—it is





---

p.346




not long to wait. He cannot lose any thing by it—nothing, nothing, nothing. Tell him that; say any thing to him.’


The servant went down. In his own words, he did not feel the stairs under him till he got to the hall. The figure stood exactly as he had left it. He delivered his master's message as coherently as he could. The stranger replied in a careless tone—


‘If Sir Robert will not come down to me, I must go up to him.’


The man returned, and to his surprise he found his master much more composed in manner. He listened to the message, and though the cold perspiration rose in drops upon his forehead faster than he could wipe it away, his manner had lost the dreadful agitation which had marked it before. He rose feebly, and casting a last look of agony behind him, passed from the room to the lobby, where he signed to his attendant not to follow him. The man moved as far as the head of the staircase, from whence he had a tolerably distinct view of the hall, which was imperfectly lighted by the candle he had left there.


He saw his master reel, rather than walk down the stairs, clinging all the way to the banisters. He walked on, as if about to sink every moment from weakness. The figure advanced as if to meet him, and in passing struck down the light. The servant could see no more; but there was a sound of struggling, renewed at intervals with silent but fearful energy. It was evident, however, that the parties were approaching the door, for he heard the solid oak sound twice or thrice, as the feet of the combatants, in shuffling hither and thither over the floor, struck upon it. After a slight pause he heard the door thrown open with such violence that the leaf seemed to strike the sidewall of the hall, for it was so dark without that this could only be surmised by the sound. The struggle was renewed with an agony and intenseness of energy, that betrayed itself in deep-drawn gasps. One desperate effort, which terminated in the breaking of some part of the door, producing a sound as if the door-post was wrenched from its position, was followed by another wrestle, evidently upon the narrow ledge which ran outside the door, overtopping the precipice. This proved to be the final struggle, for it was followed by a crashing sound as if some heavy body had fallen over, and was rushing down the precipice, through the light boughs that crossed near the top. All then became still as the grave, except when the moan of the night wind sighed up the wooded glen.


The old servant had not nerve to return through the hall, and to him that night seemed all but endless; but morning at length came, and with it the disclosure of the events of the night. Near





---

p.347




the door, upon the ground, lay Sir Robert's sword-belt, which had given way in the scuffle. A huge splinter from the massive door-post had been wrenched off by an almost superhuman effort—one which nothing but the gripe of a despairing man could have severed—and on the rock outside were left the marks of the slipping and sliding of feet.


At the foot of the precipice, not immediately under the castle, but dragged some way up the glen, were found the remains of Sir Robert, with hardly a vestige of a limb or feature left distinguishable. The right hand, however, was uninjured, and in its fingers were clutched, with the fixedness of death, a long lock of coarse sooty hair—the only direct circumstantial evidence of the presence of a second person. So says tradition.


This story, as I have mentioned, was current among the dealers in such lore; but the original facts are so dissimilar in all but the name of the principal person mentioned and his mode of life, and the fact that his death was accompanied with circumstances of extraordinary mystery, that the two narratives are totally irreconcilable, (even allowing the utmost for the exaggerating influence of tradition,) except by supposing report to have combined and blended together the fabulous histories of several distinct heroes of the family of Ardagh. However this may be, I shall lay before the reader a distinct recital of the events from which the foregoing tradition arose. With respect to these there can be no mistake; they are authenticated as fully as any thing can be by human testimony; and I state them principally upon the evidence of a lady who herself bore a prominent part in the strange events which she related, and which I now record as being among the few well-attested tales of the marvellous which it has been my fate to hear. I shall, as far as I am able, arrange in one combined narrative the evidence of several distinct persons who were eye-witnesses of what they related, and with the truth of whose testimony I am solemnly and deeply impressed.


Sir Robert Ardagh was the heir and representative of the family whose name he bore; but owing to the prodigality of his father, the estates descended to him in a very impaired condition. Urged by the restless spirit of youth, or more probably by a feeling of pride which could not submit to witness, in the paternal mansion, what he considered a humiliating alteration in the style and hospitality which up to that time had distinguished his family, Sir Robert left Ireland and went abroad. How he occupied himself, or what countries he visited during his absence, was never known, nor did he afterwards make any allusion or encourage any inquiries





---

p.348




touching his foreign sojourn. He left Ireland in the year 1742, being then just of age, and was not heard of until the year 1760—about eighteen years afterwards—at which time he returned. His personal appearance was, as might have been expected, very greatly altered, more altered, indeed, than the time of his absence might have warranted one in supposing likely. But to counterbalance the unfavourable change which time had wrought in his form and features, he had acquired all the advantages of polish of manner, and refinement of taste, which foreign travel is supposed to bestow. But what was truly surprising was, that it soon became evident that Sir Robert was very wealthy—wealthy to an extraordinary and unaccountable degree; and this fact was made manifest, not only by his expensive style of living, but by his proceeding to disembarrass his property, and to purchase extensive estates in addition. Moreover, there could be nothing deceptive in these appearances, for he paid ready money for every thing, from the most important purchase to the most trifling.


Sir Robert was a remarkably agreeable man, and possessing the combined advantages of birth and property, he was, as a matter of course, gladly received into the highest society which the metropolis then commanded. It was thus that he became acquainted with the two beautiful Miss F——ds, then among the brightest ornaments of the highest circle of Dublin fashion. Their family was in more than one direction allied to nobility; and Lady D——, their elder sister by many years, and sometime married to a once well-known nobleman, was now their protectress. These considerations, beside the fact that the young ladies were what is usually termed heiresses, though not to a very great amount, secured to them a high position in the best society which Ireland then produced. The two young ladies differed strongly, alike in appearance and in character. The elder of the two, Emily, was generally considered the handsomer—for her beauty was of that impressive kind which never failed to strike even at the first glance, possessing as it did all the advantages of a fine person and a commanding carriage. The beauty of her features strikingly assorted in character with that of her figure and deportment. Her hair was raven black and richly luxuriant, beautifully contrasting with the even, perfect whiteness of her forehead—her finely pencilled brows were black as the ringlets that clustered near them—and her blue eyes, full, lustrous, and animated, possessed all the power and brilliancy of the black, with more than their softness and variety of expression. She was not, however, merely the tragedy queen. When she smiled, and that was not seldom, the dimpling of cheek and chin,





---

p.349




the laughing display of the small and beautiful teeth—but more than all, the roguish archness of her deep, bright eye, showed that nature had not neglected in her the lighter and the softer characteristics of woman.


Her younger sister Mary was, as I believe not unfrequently occurs in the case of sisters, quite in the opposite style of beauty. She was light-haired, had more colour, had nearly equal grace, with much more liveliness of manner. Her eyes were of that dark grey which poets so much admire—full of expression and vivacity. She was altogether a very beautiful and animated girl—though as unlike her sister as the presence of those two qualities would permit her to be. Their dissimilarity did not stop here—it was deeper than mere appearance—the character of their minds differed almost as strikingly as did their complexion. The fair-haired beauty had a large proportion of that softness and pliability of temper which physiognomists assign as the characteristics of such complexions. She was much more the creature of impulse than of feeling, and consequently more the victim of extrinsic circumstances than was her sister. Emily, on the contrary, possessed considerable firmness and decision. She was less excitable, but when excited her feelings were more intense and enduring. She wanted much of the gaiety, but with it the volatility of her younger sister. Her opinions were adopted, and her friendships formed more reflectively, and her affections seemed to move, as it were, more slowly, but more determinedly. This firmness of character did not amount to any thing masculine, and did not at all impair the feminine grace of her manners.


Sir Robert Ardagh was for a long time apparently equally attentive to the two sisters, and many were the conjectures and the surmises as to which would be the lady of the choice. At length, however, these doubts were determined; he proposed for and was accepted by the dark beauty, Emily F——d.


The bridals were celebrated in a manner becoming the wealth and connections of the parties; and Sir Robert and Lady Ardagh left Dublin to pass the honeymoon at the family mansion, Castle Ardagh, which had lately been fitted up in a style bordering upon magnificent. Whether in compliance with the wishes of his lady, or owing to some whim of his own, his habits were henceforward strikingly altered; and from having moved among the gayest if not the most profligate of the votaries of fashion, he suddenly settled down into a quiet, domestic, country gentleman, and seldom, if ever, visited the capital, and then his sojourns were as brief as the nature of his business would permit.




---

p.350


Lady Ardagh, however, did not suffer from this change further than in being secluded from general society; for Sir Robert's wealth, and the hospitality which he had established in the family mansion, commanded that of such of his lady's friends and relatives as had leisure or inclination to visit the castle; and as their style of living was very handsome, and its internal resources of amusement considerable, few invitations from Sir Robert or his lady were neglected.


Many years passed quietly away, during which Sir Robert's and Lady Ardagh's hopes of issue were several times disappointed. In the lapse of all this time there occurred but one event worth recording. Sir Robert had brought with him from abroad a valet, who sometimes professed himself to be French, at others Italian, and at others again German. He spoke all these languages with equal fluency, and seemed to take a kind of pleasure in puzzling the sagacity and balking the curiosity of such of the visitors at the castle as at any time happened to enter into conversation with him, or who, struck by his singularities, became inquisitive respecting his country and origin. Sir Robert called him by the French name, JACQUE, and among the lower orders he was familiarly known by the title of ‘Jack, the devil,’ an appellation which originated in a supposed malignity of disposition and a real reluctance to mix in the society of those who were believed to be his equals. This morose reserve, coupled with the mystery which enveloped all about him, rendered him an object of suspicion and inquiry to his fellow-servants, amongst whom it was whispered that this man in secret governed the actions of Sir Robert with a despotic dictation, and that, as if to indemnify himself for his public and apparent servitude and self-denial, he in private exacted a degree of respectful homage from his so-called master, totally inconsistent with the relation generally supposed to exist between them.


This man's personal appearance was, to say the least of it, extremely odd; he was low in stature; and this defect was enhanced by a distortion of the spine, so considerable as almost to amount to a hunch; his features, too, had all that sharpness and sickliness of hue which generally accompany deformity; he wore his hair, which was black as soot, in heavy neglected ringlets about his shoulders, and always without powder—a peculiarity in those days. There was something unpleasant, too, in the circumstance that he never raised his eyes to meet those of another; this fact was often cited as a proof of his being SOMETHING NOT QUITE RIGHT, and said to result not from the timidity which is supposed in most cases





---

p.351




to induce this habit, but from a consciousness that his eye possessed a power, which, if exhibited, would betray a supernatural origin. Once, and once only, had he violated this sinister observance: it was on the occasion of Sir Robert's hopes having been most bitterly disappointed; his lady, after a severe and dangerous confinement, gave birth to a dead child. Immediately after the intelligence had been made known, a servant, having upon some business passed outside the gate of the castle yard, was met by Jacque, who, contrary to his wont, accosted him, observing, ‘so, after all the pother, the son and heir is still-born.’ This remark was accompanied by a chuckling laugh, the only approach to merriment which he was ever known to exhibit. The servant, who was really disappointed, having hoped for holy-day times, feasting and debauchery with impunity during the rejoicings which would have accompanied a christening, turned tartly upon the little valet, telling him that he should let Sir Robert know how he had received the tidings which should have filled any faithful servant with sorrow; and having once broken the ice, he was proceeding with increasing fluency, when his harangue was cut short and his temerity punished, by the little man raising his head and treating him to a scowl so fearful, half-demoniac, half-insane, that it haunted his imagination in nightmares and nervous tremors for months after.


To this man Lady Ardagh had, at first sight, conceived an antipathy amounting to horror, a mixture of loathing and dread so very powerful that she had made it a particular and urgent request to Sir Robert, that he would dismiss him, offering herself, from that property which Sir Robert had, by the marriage settlements left at her own disposal, to provide handsomely for him, provided only she might be relieved from the continual anxiety and discomfort which the fear of encountering him induced.


Sir Robert, however, would not hear of it; the request seemed at first to agitate and distress him; but when still urged in defiance of his peremptory refusal, he burst into a violent fit of fury; he spoke darkly of great sacrifices which he had made, and threatened that if the request were at any time renewed he would leave both her and the country for ever. This was, however, a solitary instance of violence; his general conduct towards Lady Ardagh, though at no time uxorious, was certainly kind and respectful, and he was more than repaid in the fervent attachment which she bore him in return.


Some short time after this strange interview between Sir Robert and Lady Ardagh; one night after the family had retired to bed, and when everything had been quiet for some time, the bell of





---

p.352




Sir Robert's dressing-room rang suddenly and violently; the ringing was repeated again and again at still shorter intervals, and with increasing violence, as if the person who pulled the bell was agitated by the presence of some terrifying and imminent danger. A servant named Donovan was the first to answer it; he threw on his clothes, and hurried to the room with haste proportioned to the urgency of the call.


Sir Robert had selected for his private room an apartment remote from the bed-chambers of the castle, most of which lay in the more modern parts of the mansion, and secured at its entrance by a double door; as the servant opened the first of these, Sir Robert's bell again sounded with a longer and louder peal; the inner door resisted his efforts to open it; but after a few violent struggles, not having been perfectly secured, or owing to the inadequacy of the bolt itself, it gave way, and the servant rushed into the apartment, advancing several paces before he could recover himself. As he entered, he heard Sir Robert's voice exclaiming loudly— ‘Wait without, do not come in yet;’ but the prohibition came too late. Near a low truckle-bed, upon which Sir Robert sometimes slept, for he was a whimsical man, in a large armchair, sat, or rather lounged, the form of the valet Jacque, his arms folded, and his heels stretched forward on the floor, so as fully to exhibit his misshapen legs, his head thrown back, and his eyes fixed upon his master with a look of indescribable defiance and derision, while, as if to add to the strange insolence of his attitude and expression, he had placed upon his head the black cloth cap which it was his habit to wear.


Sir Robert was standing before him, at the distance of several yards, in a posture expressive of despair, terror, and what might be called an agony of humility. He waved his hand twice or thrice, as if to dismiss the servant, who, however, remained fixed on the spot where he had first stood; and then, as if forgetting every thing but the agony within him, he pressed his clenched hands on his cold damp brow, and dashed away the heavy drops that gathered chill and thickly there. Jacque broke the silence.


‘Donovan,’ said he, ‘shake up that drone and drunkard, Carlton; tell him that his master directs that the travelling carriage shall be at the door within half an hour.’


The servant paused, as if in doubt as to what he should do; but his scruples were resolved by Sir Robert's saying hurriedly, ‘Go—go, do whatever he directs; his commands are mine; tell Carlton the same.’


The servant hurried to obey, and in about half an hour the





---

p.353




carriage was at the door, and Jacque, having directed the coachman to drive to B——n, a small town at about the distance of twelve miles—the nearest point, however, at which post horses could be obtained— stepped into the vehicle, which accordingly quitted the castle immediately.


Although it was a fine moonlight night, the carriage made its way but very slowly, and after the lapse of two hours the travellers had arrived at a point about eight miles from the castle, at which the road strikes through a desolate and heathy flat, sloping up, distantly at either side into bleak undulatory hills, in whose monotonous sweep the imagination beholds the heaving of some dark sluggish sea, arrested in its first commotion by some preternatural power. It is a gloomy and divested spot; there is neither tree nor habitation near it; its monotony is unbroken, except by here and there the grey front of a rock peering above the heath, and the effect is rendered yet more dreary and spectral by the exaggerated and misty shadows which the moon casts along the sloping sides of the hills.


When they had gained about the centre of this tract, Carlton, the coachman, was surprised to see a figure standing, at some distance in advance, immediately beside the road, and still more so when, on coming up, he observed that it was no other than Jacque whom he believed to be at that moment quietly seated in the carriage; the coachman drew up, and nodding to him, the little valet exclaimed, ‘Carlton, I have got the start of you; the roads are heavy, so I shall even take care of myself the rest of the way; do you make your way back as best you can, and I shall follow my own nose;’ so saying, he chucked a purse into the lap of the coachman, and turning off at a right angle with the road, he began to move rapidly away in the direction of the dark ridge that lowered in the distance.


The servant watched him until he was lost in the shadowy haze of night; and neither he nor any of the inmates of the castle saw Jacque again. His disappearance, as might have been expected, did not cause any regret among the servants and dependants at the castle; and Lady Ardagh did not attempt to conceal her delight; but with Sir Robert matters were different, for two or three days subsequent to this event he confined himself to his room, and when he did return to his ordinary occupations, it was with a gloomy indifference, which showed that he did so more from habit than from any interest he felt in them. He appeared from that moment unaccountably and strikingly changed, and thenceforward walked through life as a thing from which he could derive neither profit nor pleasure. His temper, however, so 





---

p.354




far from growing wayward or morose, became, though gloomy, very, almost unnaturally, placid and cold; but his spirits totally failed, and he grew silent and abstracted.


These sombre habits of mind, as might have been anticipated, very materially affected the gay housekeeping of the castle; and the dark and melancholy spirit of its master seemed to have communicated itself to the very domestics, almost to the very walls of the mansion.


Several years rolled on in this way, and the sounds of mirth and wassail had long been strangers to the castle, when Sir Robert requested his lady, to her great astonishment, to invite some twenty or thirty of their friends to spend the Christmas, which was fast approaching, at the castle. Lady Ardagh gladly complied, and her sister Mary, who still continued unmarried, and Lady D—— were of course included in the invitations. Lady Ardagh had requested her sisters to set forward as early as possible, in order that she might enjoy a little of their society before the arrival of the other guests; and in compliance with this request they left Dublin almost immediately upon receiving the invitation, a little more than a week before the arrival of the festival which was to be the period at which the whole party were to muster.


For expedition's sake it was arranged that they should post, while Lady D——'s groom was to follow with her horses; she taking with herself her own maid and one male servant. They left the city when the day was considerably spent, and consequently made but three stages in the first day; upon the second, at about eight in the evening, they had reached the town of K——k, distant about fifteen miles from Castle Ardagh. Here, owing to Miss F——d's great fatigue, she having been for a considerable time in a very delicate state of health, it was determined to put up for the night. They, accordingly, took possession of the best *sitting-room* which the inn commanded, and Lady D——remained in it to direct and urge the preparations for some refreshment, which the fatigues of the day had rendered necessary, while her younger sister retired to her bed-chamber to rest there for a little time, as the parlour commanded no such luxury as a sofa.


Miss F——d was, as I have already stated, at this time in very delicate health; and upon this occasion the exhaustion of fatigue, and the dreary badness of the weather, combined to depress her spirits. Lady D—— had not been left long to herself, when the door communicating with the passage was abruptly opened, and her sister Mary entered in a state of great agitation; she sat down pale and trembling upon one of the chairs, and it was not until





---

p.355




a copious flood of tears had relieved her, that she became sufficiently calm to relate the cause of her excitement and distress. It was simply this. Almost immediately upon lying down upon the bed she sank into a feverish and unrefreshing slumber; images of all grotesque shapes and startling colours flitted before her sleeping fancy with all the rapidity and variety of the changes in a kaleidoscope. At length, as she described it, a mist seemed to interpose itself between her sight and the ever-shifting scenery which sported before her imagination, and out of this cloudy shadow gradually emerged a figure whose back seemed turned towards the sleeper; it was that of a lady, who, in perfect silence, was expressing as far as pantomimic gesture could, by wringing her hands, and throwing her head from side to side, in the manner of one who is exhausted by the over indulgence, by the very sickness and impatience of grief, the extremity of misery. For a long time she sought in vain to catch a glimpse of the face of the apparition, who thus seemed to stir and live before her. But at length the figure seemed to move with an air of authority, as if about to give directions to some inferior, and in doing so, it turned its head so as to display, with a ghastly distinctness, the features of Lady Ardagh, pale as death, with her dark hair all dishevelled, and her eyes dim and sunken with weeping. The revulsion of feeling which Miss F——d experienced at this disclosure— for up to that point she had contemplated the appearance rather with a sense of curiosity and of interest, than of any thing deeper—was so horrible, that the shock awoke her perfectly. She sat up in the bed, and looked fearfully around the room, which was imperfectly lighted by a single candle burning dimly, as if she almost expected to see the reality of her dreadful vision lurking in some corner of the chamber. Her fears were, however, verified, though not in the way she expected; yet in a manner sufficiently horrible—for she had hardly time to breathe and to collect her thoughts, when she heard, or thought she heard, the voice of her sister, Lady Ardagh, sometimes sobbing violently, and sometimes almost shrieking as if in terror, and calling upon her and Lady D——, with the most imploring earnestness of despair, for God's sake to lose no time in coming to her. All this was so horribly distinct, that it seemed as if the mourner was standing within a few yards of the spot where Miss F——d lay. She sprang from the bed, and leaving the candle in the room behind her, she made her way in the dark through the passage, the voice still following her, until as she arrived at the door of the sitting-room it seemed to die away in low sobbing.


As soon as Miss F——d was tolerably recovered, she declared





---

p.356




her determination to proceed directly, and without further loss of time, to Castle Ardagh. It was not without much difficulty that Lady D—— at length prevailed upon her to consent to remain where they then were, until morning should arrive, when it was to be expected that the young lady would be much refreshed by at least remaining quiet for the night, even though sleep were out of the question. Lady D—— was convinced, from the nervous and feverish symptoms which her sister exhibited, that she had already done too much, and was more than ever satisfied of the necessity of prosecuting the journey no further upon that day. After some time she persuaded her sister to return to her room, where she remained with her until she had gone to bed, and appeared comparatively composed. Lady D—— then returned to the parlour, and not finding herself sleepy, she remained sitting by the fire. Her solitude was a second time broken in upon, by the entrance of her sister, who now appeared, if possible, more agitated than before. She said that Lady D—— had not long left the room, when she was roused by a repetition of the same wailing and lamentations, accompanied by the wildest and most agonized supplications that no time should be lost in coming to Castle Ardagh, and all in her sister's voice, and uttered at the same proximity as before. This time the voice had followed her to the very door of the *sitting-room*, and until she closed it, seemed to pour forth its cries and sobs at the very threshold.


Miss F——d now most positively declared that nothing should prevent her proceeding instantly to the castle, adding that if Lady D—— would not accompany her, she would go on by herself. Superstitious feelings are at all times more or less contagious, and the last century afforded a soil much more congenial to their growth than the present. Lady D—— was so far affected by her sister's terrors, that she became, at least, uneasy; and seeing that her sister was immovably determined upon setting forward immediately, she consented to accompany her forthwith. After a slight delay, fresh horses were procured, and the two ladies and their attendants renewed their journey, with strong injunctions to the driver to quicken their rate of travelling as much as possible, and promises of reward in case of his doing so.


Roads were then in much worse condition throughout the south, even than they now are; and the fifteen miles which modern posting would have passed in little more than an hour and a half, were not completed even with every possible exertion in twice the time. Miss F——d had been nervously restless during the journey. Her head had been out at the carriage window every minute; and





---

p.357




as they approached the entrance to the castle demesne, which lay about a mile from the building, her anxiety began to communicate itself to her sister. The postillion had just dismounted, and was endeavouring to open the gate—at that time a necessary trouble; for in the middle of the last century porter's lodges were not common in the south of Ireland, and locks and keys almost unknown. He had just succeeded in rolling back the heavy oaken gate so as to admit the vehicle, when a mounted servant rode rapidly down the avenue, and drawing up at the carriage, asked of the postillion who the party were; and on hearing, he rode round to the carriage window and handed in a note which Lady D—— received. By the assistance of one of the coach-lamps they succeeded in deciphering it. It was scrawled in great agitation, and ran thus—




> *My Dear Sister—my dear Sisters both,*—
> In God's name lose no time, I am frightened and miserable; I cannot explain all till you come. I am too much terrified to write coherently; but understand me—hasten—do not waste a minute. I am afraid you will come too late. 
> 
> 
> E. A.




 The servant could tell nothing more than that the castle was in great confusion, and that Lady Ardagh had been crying bitterly all the night. Sir Robert was perfectly well. Altogether at a loss as to the cause of Lady Ardagh's great distress, they urged their way up the steep and broken avenue which wound through the crowding trees, whose wild and grotesque branches, now left stripped and naked by the blasts of winter, stretched drearily across the road. As the carriage drew up in the area before the door, the anxiety of the ladies almost amounted to agony; and scarcely waiting for the assistance of their attendant, they sprang to the ground, and in an instant stood at the castle door. From within were distinctly audible the sounds of lamentation and weeping, and the suppressed hum of voices as if of those endeavouring to soothe the mourner. The door was speedily opened, and when the ladies entered, the first object which met their view was their sister, Lady Ardagh, sitting on a form in the hall, weeping and wringing her hands in deep agony. Beside her stood two old, withered crones, who were each endeavouring in their own way to administer consolation, without even knowing or caring what the subject of her grief might be.


Immediately on Lady Ardagh's seeing her sisters, she started up, fell on their necks, and kissed them again and again without speaking, and then taking them each by a hand, still weeping bitterly, she led them into a small room adjoining the hall, in which burned a light, and, having closed the door, she sat down





---

p.358




between them. After thanking them for the haste they had made, she proceeded to tell them, in words incoherent from agitation, that Sir Robert had in private, and in the most solemn manner, told her that he should die upon that night, and that he had occupied himself during the evening in giving minute directions respecting the arrangements of his funeral. Lady D—— here suggested the possibility of his labouring under the hallucinations of a fever; but to this Lady Ardagh quickly replied:


‘Oh! no, no! would to God I could think it. Oh! no, no! wait till you have seen him. There is a frightful calmness about all he says and does; and his directions are all so clear, and his mind so perfectly collected, it is impossible, quite impossible;’ and she wept yet more bitterly.


At that moment Sir Robert's voice was heard in issuing some directions, as he came downstairs; and Lady Ardagh exclaimed, hurriedly:


‘Go now and see him yourself; he is in the hall.’


Lady D—— accordingly went out into the hall, where Sir Robert met her; and, saluting her with kind politeness, he said, after a pause:—


‘You are come upon a melancholy mission— the house is in great confusion, and some of its inmates in considerable grief.’ He took her hand, and looking fixedly in her face, continued: ‘I shall not live to see *to-morrow*'s sun shine.’


‘You are ill, sir, I have no doubt,’ replied she; ‘but I am very certain we shall see you much better to-morrow, and still better the day following.’


‘I am *not* ill, sister,’ replied he. ‘Feel my temples, they are cool; lay your finger to my pulse, its throb is slow and temperate. I never was more perfectly in health, and yet do I know that ere three hours be past, I shall be no more.’


‘Sir, sir,’ said she, a good deal startled, but wishing to conceal the impression which the calm solemnity of his manner had, in her own despite, made upon her, ‘Sir, you should not jest; you should not even speak lightly upon such subjects. You trifle with what is sacred—you are sporting with the best affections of your wife——’


‘Stay, my good lady,’ said he; ‘if when this clock shall strike the hour of three, I shall be *any thing* but a helpless clod, then upbraid me. Pray return now to your sister. Lady Ardagh is, indeed, much to be pitied; but what is past cannot now be helped. I have now a few papers to arrange, and some to destroy. I shall see you and Lady Ardagh before my death; try to compose her—her sufferings distress me much; but what is past cannot now be mended.’




---

p.359


Thus saying, he went up stairs, and Lady D—— returned to the room where her sisters were sitting.


‘Well,’ exclaimed Lady Ardagh, as she re-entered, ‘is it not so?—do you still doubt?—do you think there is any hope?’


Lady D—— was silent.


‘Oh! none, none, none,’ continued she; ‘I see, I see you are convinced,’ and she wrung her hands in bitter agony. ‘My dear sister,’ said Lady D——, ‘there is, no doubt, something strange in all that has appeared in this matter; but still I cannot but hope that there may be something deceptive in all the apparent calmness of Sir Robert. I still must believe that some latent fever has affected his mind, or that, owing to the state of nervous depression into which he has been sinking, some trivial occurrence has been converted, in his disordered imagination, into an augury foreboding his immediate dissolution.’


In such suggestions, unsatisfactory even to those who originated them, and doubly so to her whom they were intended to comfort, more than two hours passed; and Lady D—— was beginning to hope that the fated term might elapse without the occurrence of any tragical event, when Sir Robert entered the room. On coming in, he placed his finger with a warning gesture upon his lips, as if to enjoin silence; and then having successively pressed the hands of his two sisters-in-law, he stooped sadly over the fainting form of his lady, and twice pressed her cold, pale forehead, with his lips, and then passed silently out of the room.


Lady D——, starting up, followed to the door, and saw him take a candle in the hall, and walk deliberately up the stairs. Stimulated by a feeling of horrible curiosity, she continued to follow him at a distance. She saw him enter his own private room, and heard him close and lock the door after him. Continuing to follow him as far as she could, she placed herself at the door of the chamber, as noiselessly as possible; where after a little time she was joined by her two sisters, Lady Ardagh and Miss F——d. In breathless silence they listened to what should pass within. They distinctly heard Sir Robert pacing up and down the room for some time; and then, after a pause, a sound as if some one had thrown himself heavily upon the bed. At this moment Lady D——, forgetting that the door had been secured within, turned the handle for the purpose of entering; when some one from the inside, close to the door, said, ‘Hush! hush!’ The same lady, now much alarmed, knocked violently at the door—there was no answer. She knocked again more violently, with no further success. Lady Ardagh, now uttering a piercing shriek, sank in a swoon upon the floor. Three or four





---

p.360




servants, alarmed by the noise, now hurried up stairs, and Lady Ardagh was carried apparently lifeless to her own chamber. They then, after having knocked long and loudly in vain, applied themselves to forcing an entrance into Sir Robert's room. After resisting some violent efforts, the door at length gave way, and all entered the room nearly together. There was a single candle burning upon a table at the far end of the apartment; and stretched upon the bed lay Sir Robert Ardagh. He was a corpse—the eyes were open—no convulsion had passed over the features, or distorted the limbs—it seemed as if the soul had sped from the body without a struggle to remain there. On touching the body it was found to be cold as clay—all lingering of the vital heat had left it. They closed the ghastly eyes of the corpse, and leaving it to the care of those who seem to consider it a privilege of their age and sex to gloat over the revolting spectacle of death in all its stages, they returned to Lady Ardagh, now a widow. The party assembled at the castle, but the atmosphere was tainted with death. Grief there was not much, but awe and panic were expressed in every face. The guests talked in whispers, and the servants walked on tiptoe, as if afraid of the very noise of their own footsteps.


The funeral was conducted almost with splendour. The body, having been conveyed, in compliance with Sir Robert's last directions, to Dublin, was there laid within the ancient walls of St. Audoen's Church—where I have read the epitaph, telling the age and titles of the departed dust. Neither painted escutcheon, nor marble slab, have served to rescue from oblivion the story of the dead, whose very name will ere long moulder from their tracery—


 Et sunt sua fata sepulchris.[1](javascript:footNote('E830000-003/note001.html'))


 The events which I have recorded are not imaginary. They are *FACTS;* and there lives one whose authority none would venture to question, who could vindicate the accuracy of every statement which I have set down, and that, too, with all the circumstantiality of an eye-witness.[2](javascript:footNote('E830000-003/note002.html'))












