

#The Commonwealth of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Commonwealth of Ireland
===========================


Author: Fynes Moryson
---------------------


### File Description

Charles Hughes translated by Charles HughesElectronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 2. Second draft, revised and corrected.Extent of text: 

32150 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100072Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Oxford, Corpus Christi College Library, MS 94.
**Editions/Translations**2. Fynes Moryson, A History of Ireland from the year 1599 to 1603: with a short narration of the state of the kingdom from the year 1169; to which is added a description of Ireland. 2 vols. Dublin 1735. [A reprint of part 2 and 3, Book 3, chapter 5 of the *Itinerary*.]
3. Henry Morley (ed.), Ireland under Elizabeth and James the first, described by Edmund Spenser, by Sir John Davies, ... and by Fynes Moryson, Carisbrooke Library Series 10, London and New York 1890.
4. Charles Hughes, Shakespeare's Europe. Unpublished Chapters of Fynes Moryson's Itinerary: being a Survey of the Condition of Europe at the end of the Sixteenth Century. With an Introduction and an Account of Fynes Moryson's Career. London: Sherratt & Hughes 1903 [for chapters on Ireland see especially pp 185–260; 285–289; 481–486].
5. Fynes Moryson, An itinerary, containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland & Ireland. 4 vols. Printed at the University Press by Robert Maclehose & Company Ltd. for James Maclehose and Sons, Publishers to the University of Glasgow, 1907–1908. [Reprint of 1617 edition.]
6. Graham Kew (ed.), The Irish sections of Fynes Moryson's unpublished itinerary, Dublin: Irish Manuscripts Commission 1998 [first published in Analecta Hibernica 37 (1995/1996) 1–137].
7. Internet resources at www.archive.org. An electronic text of the whole work has been made available by the University of Toronto Centre for Classical and Renaissance Literature.
**Further reading: A selection**2. Edward Campion, A historie of Ireland (London 1571; facsimile, ed. M. Hamner, reprinted 1971).
3. Richard Stanihurst, A Treatise containing a Plain and Perfect Description of Ireland (London 1577).
4. Barnaby Rich, New Description of Ireland (London 1610).
5. Sir George Carew, Earl of Totnes, Sir Thomas Stafford: Pacata Hibernia. Ireland appeased and reduced. Or, an historie of the late warres of Ireland, especially within the province of Mounster, under the government of Sir George Carew, Knight, then Lord President of that province, and afterwards Lord Carew of Clopton, and Earle of Totnes, &c. Wherein the siedge of Kinsale, the defeat of the Earle of Tyrone, and his armie; the expulsion and sending home of Don Iuan de Aguila, the Spanish generall, with his forces; and many other remarkeable passages of that time are related. Illustrated with seventeene severall mappes, for the better understanding of the storie. (London 1633). Reprinted, ed. Standish Hayes O'Grady, Pacata Hibernia, or A history of the wars in Ireland during the reign of Queen Elizabeth. 2 vols. (London 1896).
6. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
7. Sir John Davies, A discoverie of the true causes why Ireland was never entirely subdued, nor brought under obedience of the crowne of England, until the beginning of his Majestie's happie raigne (London 1612; reprinted 1969).
8. William Lithgow, Rare Adventures and Painful Peregrinations (1632). Reprint, edited with an introduction by Gilbert Phelps (London: The Folio Society 1974).
9. Philip O'Sullivan Beare, Briefe relation of Ireland, and the diversity of Irish in the same, ed. by James Hardiman, in: W. J. Battersby (ed.), The Complete Catholic Directory, Almanack and Registry for the Year of our Lord 1841, vol. 1 (Dublin 1841) 362–373.
10. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." Paris, 1653.]
11. Walter Harris (ed. and transl.), The works of Sir James Ware concerning Ireland revised and improved. 3 vols. ... I. Containing, the history of the bishops ... II. Containing, the antiquities of Ireland. ... III. Containing the writers of Ireland. In two books. All written in Latin ... now newly translated into English ... (Dublin 1739–1746).
12. Thomas Dinely, Observations on a Tour through the Kingdom of Ireland in 1681 (Dublin 1858, reprinted in Kilkenny Archaeological Society's Journal, Second Series, 4 (1856–57) 143–46, 170–88; 5 (1858–59) 22–32, 55–56; 7 (1862–63) 38–52, 103–109, 320–38; 8 (1864–66) 40–48, 268–90; 425–46; 9 (1867) 73–91, 176–204).
13. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
14. John Dymmok, 'A treatice of Ireland. Edited by Richard Butler', Tracts relating to Ireland 2, 1–90, Irish Archaeological Society (Dublin 1843).
15. Charles Smith, The ancient and present state of the county and city of Cork: Containing a natural, civil, ecclesiastical, historical, and topographical description thereof. Dublin: printed for W. Wilson, 1774. Reprinted by the Cork Historical and Archæological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork: Guy & Co., 1893–1894.
16. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. Dublin: Printed for W. Wilson 1773; 1774.
17. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979.
18. Richard Pococke, A Tour in Ireland in 1752; ed. by George T. Stokes, as 'Bishop Pococke's tour in Ireland in 1752' (Dublin and London 1891).
19. P. W. Joyce, A Social History of Ancient Ireland (New York, London, and Bombay: Longmans, Green, & Company. 1903. 2 volumes.
20. P. W. Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe. Dublin: Éamonn de Búrca for Edmund Burke 1995.
21. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history. 3 vols. London: Longmans Green 1885–1890.
22. J. C. Whitebrook, Fynes Moryson, Giordano Bruno and William Shakespeare, Notes and Queries 171 (1936) 255–260.
23. Gilbert Waterhouse, Fynes Moryson: traveller, Bulletin, Irish Committee of Historical Sciences, 36 (1945).
24. F. Walsham, Fynes Moryson and four indentures, Lincolnshire Historian 2:2 (1955) 18–23.
25. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
26. L. W. Kenny, Contemporary sources for Essex's lieutenancy in Ireland, 1599, Irish Historical Studies 11:41 (1958/1959) 8–17.
27. Andrew Hadfield; John McVeagh (eds.), Strangers to that land: British perceptions of Ireland from the Reformation to the famine (Ulster Editions and Monographs 5) (Gerards Cross: Smythe 1994).
28. John McVeagh (ed.), Irish Travel Writing. A Bibliography (Dublin 1996).
29. Hiram Morgan, The Battle of Kinsale (Bray 2004).
30. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green , and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 233–309 of the volume; being the fourth and last volume, Book 2, chapter 5 of Moryson's *Itinerary*.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text was first edited by Charles Hughes in Shakespeare's Europe, reprinted in the Illustrations of Irish History by C. Litton Falkiner, from which it is taken. Footnotes by Falkiner are included in note tags.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the chapter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal and organisation names, and terms are tagged. Words and phrases from languages other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: Translation by Charles Hughes Date range: 1902–1903.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] A few words are in Irish.


##### Language: [LA] A few words are in Latin.


### Revision History


* (2010-07-15) Beatrix Färber (ed.)

* Conversion script run, header updated; additions to bibliographic details made; more content encoding added; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-09-05) Beatrix Färber (ed.)

* File validated.
* (2008-09-05) Beatrix Färber (ed.)

* Keywords added.
* (2008-07-27) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, title elements streamlined, content of 'langUsage' revised; minor modifications made to header.
* (2007-02-10) Beatrix Färber (ed.)

* File parsed; SGML and HTML files created.
* (2007-02-10) Beatrix Färber (ed.)

* File proof-read (2); marked up.
* (2007-02-01) Beatrix Färber (ed.)

* file proof-read (1).
* (2007-01-25) Beatrix Färber (ed.)

* Header created.
* (2007-01-25) Beatrix Färber (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: T100072


### The Commonwealth of Ireland: Author: Fynes Moryson




---

p.233


The Commonwealth of Ireland
---------------------------


### Of the Commonwealth of **Ireland** according to all the particular subjects mentioned in the title of the first chapter and first book of this part.[1](javascript:footNote('T100072/note001.html'))


Now briefly I will write of the Irish Commonwealth, wherein it shall suffice with a finger to point at the fountains of past mischiefs.


It is governed by a **Lord Deputy** and Council of State resident at **Dublin**, and the Councillors are made by the King's letters, and continue in that place during their life, yet at the King's pleasure to recall or remove them, whereof notwithstanding we have few or none examples, and at the end of the war they were not many, only consisting of the Lord Chancellor, the Lord High Treasurer, the Master of the Rolls, the Marshal of **Ireland**, the Master of the Ordinance, the Treasurer at Wars, the Bishop of Meath, the Secretary and some few chief colonels of the army, but since that time there have been two Secretaries of State, and the number hath been much increased by the **Lord Chief Baron** and many other gentlemen both of the army and otherwise. Besides that, the Lords Presidents of provinces are always understood to be of this Council when they come to **Dublin** or any place





---

p.234




where the **Lord Deputy** resides. As for the **Lord Deputy**, he is made by the King's letters patent during pleasure, and commonly hath continued some three years, but sometimes fewer or many more years, at the King's pleasure. Sometimes he hath the title of Lord-Lieutenant for greater honour, as the **Earl of **Essex**** lately had, and sometimes for diminution is styled Lord Justice, as more specially when, upon the death of the **Lord Deputy**, one or more Lords Justices are chosen to govern till a new Deputy be appointed. Yet of old when our kings were styled Lord of **Ireland**, this chief governor under them was commonly styled Lord Justice.[2](javascript:footNote('T100072/note002.html')) But howsoever the titles differ, the power is all one. Sometimes of old, kings' brothers and sons (as John, son to Henry II., and Lionel, Duke of Clarence, son to Edward III., and George, Duke of Clarence, brother to Edward IV.) have governed this kingdom with title of Lord-Lieutenant, and with power to leave their own Deputy to govern it when at any time themselves returned into **England**, which Deputy gave them at the Court an account of the Irish affairs, where they gave the like account thereof to the King and his Council of State. In our time **Charles Blount, Lord Mountjoy**, for his great deserts in subduing **Tyrone**'s rebellion, was by our sovereign King James created Earl of Devonshire, and besides rich rewards of inheritance in **England** was made Lord-Lieutenant of **Ireland**, with two parts of the **Lord Deputy**'s entertainment, who had the other third part with his own commands in the army and kingdom, and gave like account of the Irish affairs to this noble Earl living at Court, only he was not the Earl's, but the King's Deputy. And this Earl during his life not only swayed all Irish suits at the Court, but all other chief affairs in **Ireland**, his letters of direction being as commands to the Deputy. But after his death the entertainment and full power returned to the Lord Deputy,





---

p.235




the command of Lord-Lieutenant ceasing from that time to this day, which dignity indeed seems more fit for the sons or brothers of kings than for any subject. It is enacted by Statute of Parliament[3](javascript:footNote('T100072/note003.html')) in the 33rd year of King Henry VIII., that upon the death of the Lord Deputy or like vacancy of that government the Lord Chancellor and Council there may choose one or two to supply the place of Lord Justice till the King may be advertised of that vacancy, and appoint another government, provided that they choose no churchman, nor any but an Englishman.[4](javascript:footNote('T100072/note004.html')) The foresaid Lord Lieutenant, Deputy, or Justice (be they one or more) have ample power, little differing from regal, yet always limited according to the King's letters patent, which do very rarely enlarge or restrain the same to one more than the other, and that power also is countermanded many times by instructions from the state and by letters from the kings of **England**. The Lord Deputy by his letters patent under the great seal of **Ireland** may grant pardon of life, lands and goods, to any guilty or condemned man, even to traitors, only special treasons against the King's person are commonly excepted, as likewise wilful murders, which the kings themselves profess not to pardon. And to these men he may likewise give the King's protection for a time, when they live in the woods as outlaws or rebels; and in like sort he may give the lands and goods of felons and traitors convicted to any of his servants or friends, or to whom he will, either English or Irish. The King commonly reserves to his own gift some eight chief places, as of the Lords Presidents, the Lord High Treasurer, the Lord Chancellor, the Master of the Rolls, the Secretary, the Chief Justice, and Chief Baron, and likewise some chief places of the army, as of the Marshal, the Master of the Ordinance, and the Master Treasurer at Wars. For all other places the Lord Deputy grants them under the great seal of **Ireland** (as the former also when he is first warranted





---

p.236




by letters out of **England**), and these he disposeth not only for his own time, but for the life of the possessors. The King reserves to himself the choice of bishops, but all other church livings are in the Lord Deputy's gift. The King reserves to himself the pupils of earls and barons, but the rest are in the Lord Deputy's gift, who likewise disposeth to his servants, friends and followers all intrusions; alienations, fines, and like things of great moment. And howsoever by inferior commissions some of the Council are joined to assist the Deputy in disposal of these things, yet that was wont *to* be only for form, these Councillors very rarely opposing themselves to his pleasure. Yea, the gifts of the higher places in the state and army, of bishoprics, of earls' and barons' pupils, though reserved to the King, were wont seldom to be granted in **England** but upon the Lord Deputy's letters of recommendation sent out of **Ireland**. Finally, the Lord Deputy may leave forces, and do all things of regal authority save coining of money, which was always coined at **London** and sent into **Ireland**.[5](javascript:footNote('T100072/note005.html')) True it is that in those things which are put in his mere power by his letters patent he hath always subjected himself to instructions and letters sent out of **England**, which notwithstanding seldom have crossed his free disposal of all things in his power, since he used to grant them presently, before any can pass into **England** and return, having obtained them there.


Notwithstanding in things put in his mere power, the most wise and moderate Deputies, foreseeing the short time of their government, and knowing that the councillors of state have their places for life, and observing that most Deputies returned into **England** laden with complaints, as well of councillors as of many private men, so as after good service they have been glad to receive the pardon of their errors for their deserved reward, for these causes have been so wary as in many things of their absolute power they used to refer the consideration of them to one or two of the Council, by that art





---

p.237




drawing their consent, and yet still having their own intentions seldom or never opposed by those councillors, who found those referments graceful and profitable to them, and so willingly seconded the Lords Deputies' pleasure.[6](javascript:footNote('T100072/note006.html'))


In my opinion nothing is so contrary to the affections of the Irish to which the King's personal presence might not easily lead or draw them,[7](javascript:footNote('T100072/note007.html')) more than his sword in his Deputy's hand can force them. But the dangerous passages of the sea and the general affairs of state giving the Irish small hope of their King's frequent presence, no doubt in his absence they more reverence a **Lord Deputy** that is by degree a Duke, Earl or Baron, than any knight though he be of any like great family, and such a Deputy shall by the authority of his degree more easily suppress their rebellious spirits against the state, and tyranny towards their tenants, than any Deputy of inferior degree can do, by greater valour and wisdom. And since the Irish are most prone to tumults and commotions, their nature in general rather requires a valiant, active Deputy, than one that is wise and politic, if withal he be slow and fainthearted.


But it may well be doubted whether the short government commonly allotted to the Deputies be profitable to our state or no. For magistrates often changed like hungry flies suck more blood, and as the devil rageth more because his time is short, so these magistrates, fearing soon to be recalled, are not so much bent to reform the commonwealth, the fruit whereof should be reaped by the successor, as they are vigilant to enrich themselves and their followers. Neither indeed can that crafty and subtle nation be well known to any governor by few years' experience. So as the Irish, hoping the magistrate shall be recalled before he be skilful of their affairs, and that another far more unskilful





---

p.238




shall be sent over in his place, use nothing more than dilatory temporising in their obedience to the King's commands or laws, hoping that new magistrates will give new laws; and so, if they can, put off any business for the present, if it be but for a day, thinking with crafty Davus[8](javascript:footNote('T100072/note008.html')) that in the meantime some chance may happen to their advantage, daily gaping for such changes and inquiring after nothing more. Yea, many times they are not deceived in this hope, but flocking to the new Deputy at his first arrival with their causes formerly determined though not to their mind and liking, they many times extort from these Deputies wanting experience new determinations, disagreeable and perhaps contrary to the former, with great hurt to the commonwealth and disgrace to the government.


It may be objected that it may prove dangerous to give a great man the absolute command of a kingdom for many years. No doubt, as barbarous nations, not knowing God whom they see not, worship his creatures by which immediately he confers ill or good upon them, so the Irish in the first place obey their landlords as nearest benefactors or oppressors, and in the next place, the **Lord Deputy**, whose person they see and whose power they feel; yet so as keeping faith promised to the present Deputy, they think themselves free from keeping the same to his successors, and for the King, he as unknown and farthest from revenge, hath ever been less feared by them. But the state may always be confident of a **Lord Deputy**, whose faithfulness and ends free from ambition, are well known to them. And let him be never so fit to embrace new and dangerous counsels, yet if he have a good estate of lands in **England** there is no danger of his attempts. For a wise man would not change that certain estate for any hopes of **Ireland**, which will always be most uncertain, as well because the kingdom cannot subsist without the support of some powerful king, as because the minds of the Irish are unstable, and as the common people everywhere, so they in a far greater measure, have most inconstant affections. Besides that such ambitious designs cannot by any man be





---

p.239




resolved in council, much less put in execution, before the state of **England** may have means to know and prevent them.


Their objection is of greater force who think it fit these governments be often changed, that many of the English may know the affairs of that kingdom, which otherwise will be known to few. But what if three years will not suffice to understand how to govern that crafty nation! Surely at least after these years of contemplation, methinks some time should be given to the governor to bring his counsels and experience into actual reformation. For as heretofore they have been often changed, so the Deputies have laboured more to compose tumults and disorders for the time than to take away the causes, and to make the peace permanent, lest their successor should enter upon their harvest, imputing the troubles to them, and arrogating the appeasing thereof to himself. Whereupon sharp emulation, or rather bitter malice, hath commonly been between the Deputies nearest foregoing and succeeding. So as the new Deputy, affecting private fame rather than public good, hath seldom or never trodden the steps of his predecessor, but rather insisted upon his own maxims of government, especially caring that his actions be not obscured by those of his predecessor, and this Babylonian confusion of distracted and contrary motions in the chief governors hath made the Irish, like wild colts having unskilful riders, to learn all their jadish tricks. Whereas if the government were continued till the magistrate might know the nature of the people, with the secrets of that state, and apply the remedies proper thereunto; if after their government (according to the custom of the state of Venice) each Deputy should give in writing to the state in **England** a full relation of his government and the state of that kingdom, so as his successor might weave the same web he had begun, and not make a new frame of his own; if in regard the King's presence in **Ireland** may rather be wished than hoped, some special commissioners, sworn to faithful relation, were chosen in **England** once in two or three years, and sent over to visit the affairs of that kingdom, and to make like relation thereof





---

p.240




at their return: no doubt that kingdom might in short time be reformed, and the King's revenues might be so increased, as **Ireland** might not only maintain itself in peace, but restore part of the treasure it hath formerly exhausted in **England**, and lay up means to supply future necessities of that state, since the said Deputies and commissioners would every one be ashamed not to add something to the public good of their own, and much more to do that was already done, or rather to destroy it by their employment. And the Irish would thereby be put from their shifting hopes, gaping for new, unskilful, and diversely affected magistrates, which have always animated them to destroy obedience and rebellious courses.[9](javascript:footNote('T100072/note009.html'))


By the complaint of former ages rather than experience in our time, I have observed that the **Lord Deputy**'s authority in **Ireland** hath been much weakened by the granting of suits and rewards in **England** to many of the Irish, without having any recommendations from their Deputy, and much more because the judicial causes of the Irish have been determined in **England** without the **Lord Deputy**'s privity, or having been formerly determined in **Ireland**, were sent back to be again examined and determined, according to letters of favour obtained by the plaintiffs in **England**, which made the subject proud, and to triumph upon the overruled magistrate, who no doubt is either unfit to govern a kingdom, or ought best to know who deserve punishment, who reward, and the most fit ways to determine judicial causes. Wherein I dare boldly say the contrary proceedings of our time, giving that magistrate his due honour, hath much advanced the public good.


Some do not approve the residence of the **Lord Deputy** at **Dublin**, and would have it rather at Athlone, upon the





---

p.241




edge of **Connaught** and **Ulster**, where he should have those seditious provinces before him, and might easily fall with his forces into **Munster**, and so should be nearer hand to prevent tumults with his presence and compose them with his power, and likewise should have at his back the Pale (containing five shires, and so called because they ever were more quiet and subject to the English), and so might stop all rebels from disturbing the Pale, which would not only yield supplies of necessaries to his train and soldiers, but also give safe passage for transporting munition and victuals to Athlone from the store-houses at **Dublin**. And this counsel was so much urged to **Queen Elizabeth**, as these reasons, together with the saving of the charge to maintain a governor in **Connaught** with counsellors to assist him, and the like charge then intended for **Ulster** moved her to refer the determination thereof to the **Lord Mountjoy**, then Deputy, and the Council of State, who altered nothing because that course would have ruined or decayed the city of **Dublin**, and especially because the rebellion was soon after appeased, and our state hath commonly used, like mariners to be secure in fair weather, and never fly to the tacklings till a storm come.


Touching the mere **Irish**, before I speak of them give me leave to remember four verses expressing four mischiefs afflicting them, as fruits of their idleness, slovenliness, and superstition:




> 1. Quatuor hybernos vexant animalia, turpes
>   
> Corpora vermiculi, sorices per tecta rapaces,
>   
> Carnivori vastantque lupi crudeliter agros,
>   
> Haec tria nequitia superas Romane sacerdos.
> 



> 1. For four vile beasts **Ireland** hath no fence:
>   
> Their bodies lice, their houses rats possess;
>   
> Most wicked priests govern their conscience,
>   
> And ravening wolves do waste their fields no less.
> 




That may be well said of the Irish which **Caesar** in his Commentaries writes of the old Germans: like beasts they do all things by force and arms, after a slavish manner. The magistrate doth nothing publicly or privately without arms. They revenge injuries seldom by law, but rather by the





---

p.242




sword and rapine, neither are they ashamed of stealth or taking preys or spoils. Formerly I have showed that the **Englishmen** who subdued **Ireland**, and long maintained the conquest thereof, did flock into **England** upon the civil wars between the houses of York and Lancaster, as well to bear up the factions as to inherit their kinsmen's lands in **England**, and so left waste their possessions in **Ireland**. At that time the mere **Irish** rushed into those vacant possessions, and the better to keep them, from that time were ever prone to rebellions, that the course of law might cease while they were in arms; and from that time resumed old barbarous laws and customs, which had been long abolished, and by withdrawing themselves from obedience to our laws, became powerful tyrants in all countries. From that time they did ever put forth and secretly maintain upon all fit occasions some outlaws to disturb peace (like our **Robin Hood** and Little John in the times of Richard I. and John, kings of **England**), growing to that impudency as these outlaws are not by them termed rebels, but men in action, living in the woods and boggy places. Among them (and many of the **English-Irish** by their example) those that became lords of countries were ever as many heads so many monstrous tyrants. These have not their lands divided in many countries, as our noblemen in **England** (whereby they are less powerful to disturb peace) but possess whole countries together, whereof notwithstanding great parts lie waste only for want of tenants. And because they have an ill custom, that tenants are reputed proper to those lands on which they dwell, without liberty to remove their dwelling under another landlord, they still desire more land, rather to have the tenants than the land, whereas, if we could furnish their old lands with tenants (as perhaps they have in some sort done since the last rebellion, of which and former times I write) they would much exceed our greatest lords in yearly revenues.


It is a great mischief that, among them, all of one name or sept and kindred dwell not (as in **England**) dispersed in many shires, but all live together in one village, lordship, and county, ready and apt to conspire together in any mischief.




---

p.243


And by an old law, which they call of themistry vulgarly called **tanistry**[10](javascript:footNote('T100072/note010.html'))—by many of our laws abolished, yet still in force among themselves—every sept chooseth their chief head or captain, not the eldest son of the eldest family, but the oldest, or rather the most daring, man (whereby they always understand the most licentious swordsman) as most fit to defend them. And this chief they not only choose among themselves, but of corrupt custom impudently challenged to be confirmed by the Lord Deputies, producing many like grants of that dignity made of old by the Lord Deputies under their hands and seals, than which nothing can be more fit to maintain factions and tumults, and to hinder the course of the King's laws. By the same law—often abolished by us, but still retained in use among them—they will needs have the choice of him that shall inherit the land of the last chief of any sept or name, not respecting therein the eldest son according to our laws, but him that most pleaseth their turbulent humours, whence flows a plentiful spring of murders, parricides and conspiracies against the kings and their laws. For first hereby they professed to live after their own laws, and openly denied obedience to the King's laws; and again (to give an instance of one mischief, passing over many other of no less moment), when any of these chiefs or lords of countries upon submission to the state, hath surrendered his lands to the King, and taken a new grant of them by the King's letters patent with conditions fit for public good, they boldly say that he held his lands by the tenure of **tanistry** only for his life, and so will not be tied to any of his acts. And it is no matter what they profess, why should we hear their words when we see their deeds? I do not think, but know, that they will never be reformed in religion, manners, and constant obedience to our laws but by the awe of the sword, and by a strong hand, at least for a time, bridling them.


By these and like corrupt customs, neglecting our laws,





---

p.244




they become disturbers of the peace, and after a barbarous manner, for terror or in pride, add to their names O (noting the chief or head) and Mac (noting the son of such a one), and thus they are called ***O'Neales***, **O'Donnells**, **MacMahownes**, with a rabble of like names, some rather seeming the names of devouring giants than Christian subjects; yea, some of old English families, degenerating into this barbarism, have changed their names after the Irish tongue, as the **Urslies**[11](javascript:footNote('T100072/note011.html')) are called Mahownes, taking the notation from the name of a bear: yea, some of the most licentious take to themselves nicknames suitable to their wicked dispositions, as one of the **O'Donnells** was called Garbe,[12](javascript:footNote('T100072/note012.html')) that is a choleric, strong (or lusty) gallant, and such he was indeed. And some as if they were knights of Amadis of Gaul, and had the valour of those errant knights, were called the Knight of the Valley, the White Knight, and the like. And withal they despise our titles of earls and lords, which so weakens the great men's estimation among them as they must cast them away, and assume their old barbarous names whensoever they will have the power to lead the people to any rebellious action. For in those barbarous names and nicknames the Irish are proud to have the rebellious acts of their forefathers sung by their bards or poets, at their feasts and public meetings. Again, they have a corrupt custom to increase their power by fostering their children with the most valiant, rich, and powerful neighbours, since that people bears such strange reverence to this bond and pledge of love, as they commonly love their foster-children more than their own. The events of which custom forced our progenitors to make severe laws against the same, which notwithstanding, howsoever restrained for the time, grew again to be of force among them in our age.




---

p.245


They have likewise a ridiculous custom—that married women give fathers to their children when they are at the point of death; insomuch as they have a pleasant tale—that a younger son hearing his mother give base fathers to some of his brethren, besought her with tears to give him a good father. But commonly they give them fathers of the ***O'Neales***, **O'Donnells**, or such great men, or at least those that are most famous for licentious boldness. And these bastard children ever after follow these fathers, and, thinking themselves to descend of them, will be called swordsmen, and, scorning husbandry and manual arts, live only of rapine and spoil.


These foresaid mere **Irish** lords of countries govern the people under them with such tyranny, as they know no king in respect of them, who challenge all their goods and chattels to be theirs, saying that their progenitors did not only give them lands to till, but also cows and other goods to possess at the lord's will and disposal. Neither take they any rent of them for their lands, but at pleasure impose money upon them upon all occasions of spending, as journeys to **Dublin** or into **England**, paying their debts, entertaining of the Lord Deputy or judges, and like occasions, sometimes true, sometimes feigned, taking a great or small portion of their goods according to the quality of the cause. And these exactions they do well call cuttings,[13](javascript:footNote('T100072/note013.html')) wherewith they do not only cut, but devour the people. And it little availeth these poor tenants, though some of them can prove by indentures that they are freeholders, and not tenants at will, for of old to the end of the last war (of which time I write and desire to be understood) the lords by tyrannical custom still overswayed the people's right in these courses. And this custom was the fountain of many evils, more especially of one mischief—that if the tenant by any crime forfeited his goods, the lord denied him to have any property therein; and yet if the same goods were seized by the sheriff for any fines for the King, or debts of the lord to





---

p.246




private men, the tenants forthwith exclaimed of injustice to punish them for the lord's offences with this (as it were) dilemma, still deluding the execution of justice. Yea, these lords challenged right of inheritance in their tenants' persons, as if by old covenants they were born slaves to till their ground, and do them all like services, and howsoever they were oppressed might not leave their land to dwell under any other landlord. And these suits between the lords for right in tenants were then most frequent. Thus I remember the son of Henry Oge[14](javascript:footNote('T100072/note014.html')) to be killed in the country of MacMahon while he went thither to bring back by force a fugitive tenant (as they term them). Like suits for tenants were frequent at this time between the new created Earl of Tirconnell and **Sir Neale Garve**,[15](javascript:footNote('T100072/note015.html')) and at first the magistrate commanded the Earl to restore to **Sir Neale** his old tenants; but when peace was more settled, the itinerant judges, going to **Ulster**, added a general caution in this case—that the tenants should not be forced to return, except they were willing, professing at public meetings, with great applause of the people, that it was most unjust the King's subjects, born in a free commonwealth, should be used like slaves. Again these lords, challenging all their tenants' goods, think scorn to have any cows or herds of cattle of their own, though sometimes they permit their wives to have some like property. They distribute their lands among their tenants, to be tilled only for one, two, or three years, and so the people build no houses, but, like nomads living in cabins, remove from one place to another with their cows, and commonly retire them within thick woods not to be entered without a guide, delighting in this roguish life, as more free from the hand of justice and more fit to commit rapines. Thus the country people living under the lords' absolute power as slaves, and howsoever they have plenty of corn, milk, and cattle, yet having no property in anything,





---

p.247




obey their lords in right and wrong, and being all of the Roman Church, and being taught that it is no sin to break faith with us, and so little regarding an oath taken before our magistrates, the King was often defrauded of his right by the falsehood of juries, in his inheritance, wards, attainders, escheats, intrusions, alienations, and all pleas of the crown. At the end of the war, among infinite examples, this was well seen in the case of **Meade, the Recorder of **Cork****, who, having committed open treason, was acquitted by an Irish jury, himself craftily hastening his trial for fear he should be tried in **England**.[16](javascript:footNote('T100072/note016.html')) The Court of the Star Chamber, shortly after established, severely punished juries for abuses of this last kind, but with what effect is beside my purpose to write. These Irish lords in the last war had a cunning trick—that howsoever the father possessing the land bore himself outwardly as a subject, yet his sons, having no land in possession, should live with the rebels, and keep him in good terms with them, and his goods from present spoiling. The lords of **Ireland**, at this time whereof I write, nourished thieves, as we do hawks, openly boasting among themselves who had the best thieves. Neighbours entertaining these men into their families, for mutual prejudices, was a secret fuel of the Civil War, they being prone to rebellion, and in peace not forbearing to steal at home, and to spoil all passengers near their abode.


The wild or mere **Irish** have a generation of poets, or rather rhymers vulgarly called bards, who in their songs used to extol the most bloody, licentious men, and no others, and to allure the hearers, not to the love of religion and civil manners, but to outrages, robberies, living as outlaws, and contempt of the magistrates' and the King's laws. Alas! how





---

p.248




unlike unto **Orpheus**, who, with his sweet harp and wholesome precepts of poetry, laboured to reduce the rude and barbarous people from living in woods to dwell civilly in towns and cities, and from wild riot to moral conversation. All good men wished these knaves to be strictly curbed and severely punished. For the mere **Irish**, howsoever they understood not what was truly honourable, yet out of barbarous ignorance are so affected to vainglory, as they nothing so much feared the Lord Deputy's anger as the least song or ballad these rascals might make against them, the singing whereof to their reproach would more have daunted them than if a judge had doomed them to the gallows. They had also another rabble of jesters, which used to frequent the tables of lords and gentlemen, continual tellers of news, which commonly they reduced to the prejudice of the public good.


Again, the Irish in general, more especially the mere **Irish**, being slothful and given to nothing more than base idleness, they nourished a third generation of vipers vulgarly called carrows,[17](javascript:footNote('T100072/note017.html')) professing (forsooth) the noble science of playing at cards and dice, which so infected the public meetings of the people and the private houses of lords, as no adventure was too hard in shifting for means to maintain these sports. And indeed the wild Irish do madly affect them, so as they will not only play and lose their money and movable goods, but also engage their lands—yea, their own persons, to be held as prisoners—by the winner, till he be paid the money for which they are engaged. It is a shame to speak, but I heard by credible relation that some were found so impudent as they had suffered themselves to be led as captives, tied by the parts of their body which I will not name, till they had money to redeem themselves. Could a provost-marshal be better employed than in hanging up such rascals and like vagabond persons? For howsoever none could better do it





---

p.249




than the sheriffs, yet because the Irish frequently, and in part justly, complained of their extortions (as I shall after show), I dare not say that martial law might well be committed to them.


The Irish thus given to idleness, naturally abhor from manual arts and civil trades to gain their own bread, and the basest of them will be reputed gentlemen and swordmen, for so they are termed who profess to live by their swords and have been always apt to raise civil wars, and ever most hardly drawn to lay down arms by which they had liberty to live in riot. Many examples might be given in the highest kind of mischief produced by this idleness; but that the vice is most natural to the Irish I will only give one example, which myself observed of fishermen in the cities of **Munster**, who being no swordsmen, yet were generally so slothful, as in the calmest weather, and the greatest concourse of noblemen, when they had no fear of danger, and great hope of gain, though seas abound with excellent fish and the province with frequent ports and bays most fit for fishing, yet so long as they had bread to eat would not put to sea, no, not commanded by the Lord Deputy, till they were beaten by force out of their houses. And in my opinion this idleness hath been nourished by nothing more (as I have formerly showed upon other occasions) than by the plenty of the land and great housekeeping drawing the people from trades, while they can be fed by others without labour. This experience hath showed of old, as well in **England**, where the greatest robberies were commonly done by idle serving men swarming in great houses, as in the more northern parts, and in **Ireland**, where the multitude of loose followers hath of old been prone to fight their lords' quarrels—yea, to rebel with them. Whereas no doubt the exercise of trades, and the custom of industry to live every man of his own, are a strong establishment of any commonwealth. The mere **Irish** given to sloth are also most luxurious, and not to speak of the abundance of meats, they are excessively given to drunkenness. For howsoever while they live in woods and in cabins with their cattle they could be content with





---

p.250




water and milk, yet when they came to towns nothing was more frequent than to tie their cows at the doors, and never part from the taverns till they had drunk them out in sack and strong water, which they call **usquebaugh**; and this did not only the lords, but the common people, though half naked for want of clothes to cover them. No man may justly marvel if, among such people, dissolute hucksters, apt to raise seditions and live like outlaws, be frequently found. Therefore at the end of the last war it was wished and expected that this luxury should be suppressed, at least from general excess, that all vagabond persons should be severely punished, that the people should be allured and drawn to love manual arts and trades, and specially husbandry of tillage. For whereas all, yea the most strong and able bodies, and men given to spoils and robberies in all times, gladly employed themselves in feeding of cows, that course of life was embraced by them as suitable to their innate sloth, and as most fit to elude or protract all execution of justice against them, while they commonly lived in thick woods abounding with grass. But no doubt it were much better if **Ireland** should be reduced to less grazing and more tillage by the distribution of lands among tenants, in such sort as ever after it should (as in **England**) be unlawful to change any tillage into pasture.


Touching the **English-Irish**—namely, such as descend of the first English conquering that country, or since in divers ages and times to this day transplanted out of **England** into **Ireland**—it is wonderful, yet most true, that for some later ages they have been (some in high, some in less measure) infected with the barbarous customs of the mere **Irish** and with the Roman religion, so as they grew not only as adverse to the reformation of civil policy and religion as the mere **Irish**, but even combined with them and showed such malice to the English nation as if they were ashamed to have any community with it, of country, blood, religion, language, apparel, or any such general bond of amity. And for this alienation they did not shame in the last civil war to allege reasons to justify their





---

p.251




so doing—namely, that they whose progenitors had conquered that kingdom, and were at first thought most worthy to govern the same under our kings, were by a new law excluded from being deputies, and had otherwise small or no power in the state. Again, that after they were broken and worn out in the civil war of **England** between the houses of York and Lancaster, they were not strengthened with new colonies out of **England**, and so being weaker than the mere **Irish**, were forced to apply themselves to the stronger, by contracting affinity with them, and using their language and apparel. These and like reasons they pretended, which I will first answer, and then show the true causes thereof. It cannot be denied but the **English-Irish** after the first conquest were by our kings made chief governors of that kingdom, yea and many ages after were sometimes lord deputies, and were always capable of that place, till the time of King Henry VIII.,[18](javascript:footNote('T100072/note018.html')) but never without detriment of the Commonwealth, and danger from them that possessed it. To the first **English-Irish** born of noble families in **England** our kings gave large patrimonies and great privileges, making them sometimes governors of the state, but in process of time, some of them forgetting their country, blood, and all pledges of love towards the English, not only became rebels, but by degrees grew like the mere **Irish** in all things, even in hating the English, and becoming chief leaders to all seditions; growing at last to such pride in the last civil war, as if they had not rewards when they deserved punishments, or could not obtain pensions to serve the state, they were more ready to rebel than the mere **Irish** themselves. Among these, some in hatred to the English changed their English names into Irish, yet retaining the old notation, as the **Urselies** called themselves **MacMahownes**, some in **Ulster** of the family of Veres called themselves Macrones, others of the family of great Mortimer called themselves Macmarrs. These and some others, as Bermingham descended of old English barons, and the Lord Courcy, whose progenitors of the English nobility were among the chief





---

p.252




and first conquerors of the kingdom, grew so degenerate, as in the last rebellion they could not be distinguished from mere **Irish**. The rest retaining their old names, and in good measure the English manners, as Tyrrell, Lacy, many of the **Bourkes** and **Geraldines**, and some of the **Nugents**, yet became chief leaders in the late rebellion. These men no man will judge capable of the chief governments in that kingdom. But let them pass, and let us consider if the **English-Irish** that in the rebellion remained subjects, and will not be stained with the name of rebels, have any just cause to complain that they are excluded from the government, because the law forbids them to be Deputies. They are in **England** free denizens, having equal right with the English to inherit lands, and bear offices, and obtain any dignity whereof their merit or the King's favour may make them capable. Let them remember that the **Earl Strongbow**, being the leader of the English that first conquered **Ireland**, when the King would have committed him the government thereof, did modestly refuse the same, except the King would join some assistants with him, not ignorant what danger that magistracy would bring to him more than to any other. Let them remember that among other noble families of the English conquerors, first **Lacy**, then **Courcy**, had the chief government of that kingdom, but the first was recalled into **England** to give account of his government, not without danger of losing his head; the other was long cast into prison. Let them remember that the **Lord Deputy**'s place did weaken and almost destroy the family of the **Geraldines**, after which time King Henry VIII. by Act of Parliament first excluded the **English-Irish** from being chief governors of that kingdom, as common experience made all men find that government not only dangerous to themselves advanced to it, but also more displeasing to the people, who least like the command of their own countrymen, and were most ready to load them with complaints in **England**, as also their own countrymen being councillors of state, whose oppressions they most felt, and grieved at. Yet many **English-Irish** continued councillors of state at the time of **Queen





---

p.253




Elizabeth** and the last rebellion whereof I write. For my part, if the **English-Irish** had English affections, I would think no difference should be made between them and the English. But in the last rebellion nothing was more evident than that our secret counsels were continually made known to **Tyrone** and other rebels, and let men judge unpartially, who could more justly be suspected of this falsehood than the councillors of state born in that kingdom? Many counsels were propounded for reforming the state, for banishing **Jesuits** and other troublers of the state, and let themselves unpartially speak, who did more frustrate those designs than the councillors of that time born in that kingdom? Were not the Chief Justice and the Chief Baron of that time both born and bred in **Ireland**?[19](javascript:footNote('T100072/note019.html')) Let them say truly for what good service of theirs **Queen Elizabeth** appointed overseers to look into their actions and make them known to her Deputy. No doubt that wise Queen either thought the counsels of **Sir Robert Dillon, Knight**, the said Chief Justice of **Ireland**, contrary to the public good, or upon better advice she would never have removed him from that place which her gracious favour had first conferred upon him. What needs we use circumstances; the general opinion of that time was, that the **English-Irish** made councillors of state and judges of courts did evidently hurt the public good, and that their false-hearted help did more hinder reformation than the open acts of the rebels. Generally before this time they were papists, and if some of them upon hypocritical dispensation went to church, commonly their parents, children, kinsmen and servants were open and obstinate papists in profession. Tell me any one of them who did, according to the duty of their place, publicly commend or command to the people the use of the Common Prayer Book, and the frequenting of our churches? Why do they glory of their governing the commonwealth





---

p.254




if they cannot show one good act of reformation persuaded and perfected by them?


In the reign of King Edward III., when the King found the Pope obstinate for usurping the hereditary right of him and his subjects, in bestowing church livings under their patronage, and valiantly opposed himself to this and other oppressions of the Pope, observing that his counsels were no way more crossed than by **Italians** and **Frenchmen**, whom the Pope had cunningly preferred to bishoprics and benefices, yea, to be of the King's council of state, whereby they had means to betray the secrets of the state, he wisely made an Act of Parliament in the twenty-fifth year of his reign, whereby he provided remedy against these unfaithful counsellors and churchmen. That which King Edward might do in this case, may not his successors do the same in **Ireland** upon like danger, sequestering any suspected persons from places in counsel and judgment. When magistrates themselves use only connivancy in punishing disobedience to the laws, and sects in religion, doth not their example confirm the people in disobedience to their king? But you shall know the lion by his paw (as the proverb saith). Let us further see how the **English-Irish** in those times carried themselves in military commands committed to them. **Queen Elizabeth**, finding that the Lords Deputies from the first beginning of the last rebellion had made a great error in levying companies of the **English-Irish** to suppress the mere **Irish**, so having trained them up as the very horse-boys of them following our army were proved good shot, was at last forced to entertain of them many companies of foot and troops of horse in her pay, lest they should fall to the rebel party. Of these some worthy commanders did good service, and all in general, so long as they were employed in our army, served bravely, so as the **Lord Deputy** was often bold to take the field when half his forces consisted of them. But when they were left in garrison, especially in their own countries, it was observed that generally they did no service; but, lying still, wasted the Queen's treasure, and lest they should lose their pay, which they





---

p.255




esteemed a revenue, or religion should be reformed in time of peace (which they most feared), they did make our counsels known to the rebels, did underhand relieve them, and used all means to nourish and strengthen the rebellion. It is strange but most true that, as well to merit the rebels' favour, as to have the goods of their country safe from spoiling, the very subjects gave large contributions to the rebels, insomuch as one country (whereby an estimate of the rest may be made) did pay the rebels three hundred pounds yearly, using this art to avoid the danger of the law, that when they made a cutting upon cows for this purpose, they pretended to make this exaction for the lord's use, underhand sending the rebels word thereof that they might by force surprise those cows, which indeed were levied for them. And besides all or most of them had children, brothers or kinsmen joined with the rebels, as hostages of their love, and pledges of reconcilement upon all events. Again, I said formerly that the septs, or men of one name and blood, lived together in one town and country, each sept having a captain or chief of that name. Now this point is a great mystery, that they could give no more certain pledge of faith to us than to draw blood of any of these septs. But the **Lord Deputy** making it a chief project to make them draw blood in this kind upon their neighbours, found it a most hard thing to effect with any of the **English-Irish**, yea with those that were in the Queen's pay; yet the **English-Irish** being in the state's pay, lest they should be held altogether unprofitable, and to purchase reward of service, would sometimes kill a poor rebel, or bring him alive to the state, whose revenge they feared not, yea perhaps a rebel of note to whom the chief neighbour rebels bore malice, and so cast him into their hands. And this done they used to triumph as though they had done a masterpiece of service, and could hardly have the patience to expect a ship to carry them into **England** that in Court they might importune extraordinary reward besides their ordinary pay. To be brief, the Queen's letters shall bear me witness that the **English-Irish** placed in garrisons at their own home lived idle without doing any





---

p.256




service, exhausted the public treasure, and by all means nourished the rebellion, especially by plots laid at private parlies and at public meetings upon hills (called raths), where many treacherous conspiracies were made. Would any equal man blame a prince for putting such soldiers out of pay, for prohibiting such parlies, and for careful watching over such meetings? Great privileges were worthily granted at first to the great lords of English race for their conquest, and great power over the people was wisely given them at first, both for reward and for power to keep the mere **Irish** in subjection. But if these lords use their privileges and power to contrary ends, spoiling the subjects and wasting the country by their swordmen, when the cause ceased shall not the effect cease? When their virtue is changed and their ends corrupted, may not a wise prince abridge their privileges and power? The same is the reason of the law forbidding any of the **English-Irish** to be **Lord Deputy**. The famous **Queen Elizabeth**, finding the ill event of these ill causes, became jealous of the **English-Irish** councillors of state and judges, and used the aforesaid remedies against a chief justice and a chief baron of that time.[20](javascript:footNote('T100072/note020.html')) Formerly I acknowledge that the **English-Irish** served bravely in our army, while they were under the **Lord Deputy**'s eyes; and some worthy commanders of them showed great faithfulness, and did special services; yet this most wise Queen found their defects, and that the strength of her affairs consisted in breeding English soldiers, so as she commanded the other companies to be no more supplied, but to be cast by degrees, as they grew defective, and in the meantime to be employed out of their own countries, where they might not fear to draw blood of the bordering septs. The **Earl of Clanricarde** served the said Queen so well, as he cannot be too much commended for the same, and was also highly in her favour; yet when the **Earl of **Essex**** had left him governor of his own country, howsoever, she would not openly displace him, yet she ceased not till by her directions he was induced to a





---

p.257




voluntary resignation thereof into her hands. For indeed, the **English-Irish** and mere **Irish** of that time were generally so humorous as their fathers or brothers that died having any government of the country or command in the army, they esteemed the same as due to them by inheritance, or at least if they were not conferred on them, grew discontented and prone to any mischievous course. To conclude, the **English-Irish** of that time (few or none excepted) were obstinate and most superstitious papists, and what our state might have hoped from such men in high places of government let wise men judge.


The second excuse of the **English-Irish** for applying themselves to the mere **Irish** in manners, laws and customs, and so growing strangers (if not enemies) to the English, hath some colour of truth, but can never justify this action: namely, that the colonies of the first English conquering **Ireland**, being broken and wasted in the civil war of **England** between the houses of York and Lancaster, were never supplied, but left so weak as they were forced to apply themselves to the mere **Irish** as the stronger. Since the noble families of **England** were much wasted in the same war, no marvel if at the end thereof, our Kings first intended the restoring of **England** to the former vigour before they could cast their eyes upon **Ireland**, and in this meantime the mere **Irish** had taken such root, and so overtopped the **English-Irish** as the sending of English colonies thither so long as the mere **Irish** remained good subjects, would rather have disturbed than established peace. The first fair occasion of planting new English colonies there was given in the reign of **Queen Elizabeth** by two rebellions, the first of the **English-Irish** Geraldines, who had the Earl of Desmond for their head, the second of the mere **Irish** and many **English-Irish**, having the **Earl of **Tyrone**** for their head. Touching the first, when the Earl of Desmond was subdued, and that rebellion appeased, the said Queen (of happy memory) intended great reformation by planting new English families upon the forfeited lands of the Earl of Desmond in **Munster**. But this good intention was made void by a great error of





---

p.258




that time, in that those lands were granted, partly to obstinate papists, partly to courtiers who sold their shares to like obstinate papists, as men that would give most for them. Whereof two great mischiefs grew. First, that these papists being more obstinate than others, and thereupon choosing to leave their dwelling in **England**, where the securing of the laws bridled them, and to remove into **Ireland**, where they might be more remote, and so have greater liberty, showed the old proverb to be true: 


> 1. Caelum non animum mutant qui trans mare currunt.
>   
> Passing the sea with a swift wind, doth change the air but not the mind.
> 





For they not only remained papists, but grew more and more obstinate with liberty, and by their example confirmed both the **English-Irish** and mere **Irish** in that superstition. Secondly, these new-planted English (commonly called undertakers) being thus ill affected, did not perform the covenants imposed in their grants for establishing peace in that province; for they neither built castles, to strengthen them against times of rebellion, neither did they plant their lands with well-affected tenants out of **England**, giving them freeholds, copyholds, and leases, and tying them to serve on foot or horseback upon all occasions of tumult or war, which would much have strengthened the English against the mere **Irish** and all invasions. But they took a contrary course, not only planting their lands with mere **Irish** tenants (to whom they gave no such tenor of freehold, copyhold or lease, and who served them upon base abject conditions, whereby they made great profit for the present), but also entertaining them for servants in their families for the same reason of present profit. And this made their great profit of small continuance, and their dwellings of less strength and safety. For in the first troubles of the next rebellion of **Tyrone**, themselves and the state found by woeful experience that they had noway strengthened the province, but only dispeopled and wasted other lands to bring tenants upon their own, so as the King's other rents were thereby as much diminished as increased by their rents, and the number of





---

p.259




horse or foot to defend the province were nothing increased by them; neither had they made greater number of English to pass in juries between the King and the subjects, so as the Lord President had not power to suppress the first rebels, and the judges in all trials were forced to use the **Irish**, who made no conscience of doing wrong to the King and the English subjects. Again, their Irish tenants either ran away, or turning rebels spoiled them, and the Irish in their houses were ready to betray them, and open their doors to the rebels. So, as some of those undertakers were in the first tumult killed, some taken prisoners were cruelly handled, and had their wives and daughters shamefully abused, great part ran out of the kingdom, and yet shamed not to claim and profess in the end of the rebellion these lands, the defence whereof they had so basely forsaken. Some few kept their old revenued castles, but with great charge to the state in maintaining warders to defend them, which warders were so many as greatly diminished the force of our army in the field. Thus were the good purposes of that first plantation made frustrate by ill-disposed undertakers.


Touching the other rebellion of **Tyrone**, the appeasing thereof concurred at one instant with the death of our said Queen, beyond which time my purpose is not to write, and therefore it should be impertinent for me worthily to magnify the plantation in the north established by King James, our gracious sovereign. Only I will say for the want of former colonies planting, whereof the **English-Irish** complain, that as the plantation after Desmond's rebellion was made frustrate by ill-disposed undertakers, so, from the foresaid civil wars between the houses of York and Lancaster to the end of **Tyrone**'s rebellion, all the English in general that voluntarily left **England** to plant themselves in **Ireland**, either under the said undertakers of **Munster**, or upon the lands of any other **English-Irish** throughout **Ireland**, or to live in cities and towns, were generally observed to have been either papists, men of disordered life, bankrupts, or very poor (not speaking of those of the army remaining





---

p.260



 

there after the rebellion, who are of another time succeeding that whereof I write, and well known to be of good condition). By which course **Ireland**, as the heel of the body, was made the sink of **England**, the stench whereof had almost annoyed very Cheapside, the heart of the body, in **Tyrone**'s pestilent rebellion. To conclude, I deny not but the excuse of weakness in the **English-Irish** colonies, forcing them to apply to the mere **Irish** as stronger, hath in part a true ground, though it cannot justify the act. And if I should persuade the planting of **Ireland** with new colonies, I should now speak out of time, when that profitable and necessary action is in great measure performed by the providence of our dread sovereign. If I should commend and extol the Act, I fear I should therein be reputed as foolish as the sophister, who in a public assembly made a long oration in praise of **Hercules**, whom no man at that time or formerly ever dispraised.


But I will pass from their alleged excuses to the true causes of their alienation from us and application to the mere **Irish**. The grand cause is their firm consent with them in the Roman religion, whereof I shall speak at large in the next book of this part.[21](javascript:footNote('T100072/note021.html')) The second cause, also predominant, though in a lower degree, is the profit they have long time found in the barbarous laws and customs of the **Irish**, by tyrannical oppression of the poor people under them, of which point I have formerly spoken in this chapter. The third cause is their contracting affinity with them by marriage, and amity by mutual fostering of children. The fourth is community of apparel. The fifth community of language. Of which three last causes I will now speak briefly.


The power of these three last causes to corrupt the manners and faith of any nation, being well known, the





---

p.261




progenitors of our kings with consent of the states of that kingdom in Parliament, did of old make many Acts against them, which sometimes wrought reformation, but without any during effect. For, contrary to these laws, the **English-Irish** have for many ages, almost from the first conquest, contracted marriages with the mere **Irish**, whose children of mingled race could not but degenerate from their English parents, and also mutually fostered each other's children, which bond of love the **Irish** generally so much esteem as they will give their foster-children a part of their goods with their own children, and the very children fostered together love one another as natural brothers and sisters, yea, their foster brothers or sisters better than their own. Only I must say for the **English-Irish** citizens, especially those of **Cork**, that they have ever so much avoided these marriages with the mere **Irish**, as for want of others commonly marrying among themselves, all the men and women of the city had for many ages been of kindred in near degree one with the other. Again, contrary to the said laws, the **English-Irish** for the most part have for many ages had the same attire and apparel with the mere **Irish**, namely the nourishing of long hair (vulgarly called glibs[22](javascript:footNote('T100072/note022.html'))) which hangs down to the shoulders, hiding the face, so as a malefactor may easily escape with his face covered therewith, or by colouring his hair, and much more by cutting it off, may so alter his countenance as those of his acquaintance shall not know him; and this hair being exceeding long, they have no use of cap or hat. Also they wear straight breeches, called trousers, very close to the body, and loose coats like large waistcoats, and mantles instead of cloaks, which mantles are as cabin for an outlaw in the woods, a bed for a rebel, and a cloak for a thief, and being worn over the head and ears, and hanging down to the heels, a notorious villain lapped in them may pass any town or company without being known. Yet I must likewise confess that the best part of the citizens did not then use this Irish apparel.[23](javascript:footNote('T100072/note023.html'))




---

p.262


Again, contrary to the said laws, the **English-Irish** altogether used the Irish tongue, forgetting or never learning the English. And this communion or difference of language hath always been observed a special motive to unite or alienate the mind of all nations, so as the wise **Romans**, as they enlarged their conquests, so they did spread their language, with their laws and the divine service all in the Latin tongue, and by rewards and preferments invited men to speak it; as also the **Normans** in **England** brought in the use of the French tongue in our common law, and all words of art in hawking, hunting, and like pastimes. And in general all nations have thought nothing more powerful to unite minds than the community of language. But the law to spread the English tongue in **Ireland** was ever interrupted by rebellions, and much more by ill-affected subjects, so as at this time whereof I write the mere **Irish** disdained to learn or speak the English tongue, yea, the **English-Irish** and the very citizens (excepting those of **Dublin** where the Lord Deputy resides), though they could speak English as well as we, yet commonly speak Irish among themselves, and were hardly induced by our familiar conversation to speak English with us. Yea, common experience showed, and myself and others often observed, the citizens of **Waterford** and **Cork** having wives that could speak English as well as we bitterly to chide them when they speak English with us, insomuch as after the rebellion ended, when the itinerant judges went their circuits through the kingdom each half year to keep assizes, few of the people, no, not the very jurymen, could speak English, and at like sessions in **Ulster**, all the gentlemen and common people (excepting only the judges' train) and the very jurymen put upon life and death and all trials in law, commonly speak Irish, many Spanish, and few or none could or would speak English. These outward signs, being the touchstones of the inward affection, manifestly showed that the **English-Irish** held it a reproach among themselves to apply themselves any





---

p.263




way to the **English**, or not to follow the **Irish** in all things. Insomuch as I have heard twenty absurd things practised by them, only because they would be contrary to us, whereof I will only name some few for instances. Our women, riding on horseback behind men, sit with their faces towards the left arm of the man, but the Irish women sit on the contrary side, with their faces to the right arm. Our horses draw carts and like things with traces of ropes or leather, or with iron chains, but they fasten them by a withe to the tails of their horses, and to the rumps when the tails be pulled off, which had been forbidden by laws, yet could never be altered.[24](javascript:footNote('T100072/note024.html')) We live in cleanly houses; they in cabins or smoky cottages. Our chief husbandry is in tillage; they despise the plough, and where they are forced to use it for necessity, do all things about it clean contrary to us. To conclude, they abhor from all things that agree with English civility. Would any man judge these to be born of English parents, or will any man blame us for not esteeming or employing them as English who scorn to be so reputed? The penal laws against abuses had often been put in execution, but as the Popes, by their book taxing all sins with a penalty, did rather set sin at a price than abolish it, so they who had letters patent to execute these penal laws did not so much seek reformation, as by a moderate agreement for the penalties to raise a yearly rent to themselves, and so making the fault more common, did eat the sins of the people.


The fair cities of **Ireland** require something to be said of them. They were at first all peopled with **Englishmen**,





---

p.264




and had large privileges, but in time became wonderfully degenerate, and perverted all these privileges to pernicious uses, as they were degenerated from the English to the Irish manners, customs, diet, apparel (in some measure), language, and generally all affections, so besides the universal inclination of merchants, no swordsmen more nourished the last rebellion than they did by all means in their power. First, they did so for fear lest upon peace established they might be inquired into for their religion, being all obstinate papists, abhorring from entering a church as the beasts tremble to enter the lion's den, and where they were forced to go to church (as the Mayor and Aldermen of **Dublin** to attend the Lord Deputy), there using to stop their ears with wool or some like matter, so as they could not hear a word the preacher spoke (a strange obstinacy, since faith comes by hearing, to resolve not to hear the charmer charm he never so wisely).[25](javascript:footNote('T100072/note025.html')) Secondly, for covetousness, since during the rebellion great treasure was yearly sent out of **England**, whereof no small part came to their hands from the army for victuals, apparel, and like necessaries. Yea, not content with this no small enriching of their estate, to nourish the war and thereby continue this enriching, as also for private gain from the rebels, they furnished them continually with all necessaries, never wanting crafty evasions from the capital danger of the law in such cases. For among other subtleties, were observed some of them to load great quantity of English woollen cloth and like necessaries upon carts and horses, as if they would send them to some of our neighbour garrisons; but we found manifest probabilities, yea certain proofs, that in the meantime they advertised some rebels of this transportation, who meeting the goods, intercepted the same as it were by force, and their servants returned home with a great outcry of this surprisal, but neither wounded nor so much as sad in countenance, as their masters proved never the poorer; for no doubt those rebels paid them largely for those goods, who without warm





---

p.265




clothes should have suffered a hard life in the woods. Nay more, they furnished them even with swords, with guns, and with gunpowder, and all our arms; by which abominable act they made excessive profit, the rebels being sometimes in such want of munition as they would give whole herds of cows for a small quantity of munition, for they could easily recover cows again by rapine, but most hardly get supplies of arms and munition. And these arms the citizens used to buy of our cast captains, as powder from our soldiers having a surplusage of that which was allowed them for exercise of their pieces, and also underhand of traitorous under-ministers in our office of the Ordinance residing in their cities. And in like sort they furnished the rebels with our best victuals. For the ministers of our victuallers, under pretence of leave to sell victuals to the citizens if they feared it would grow musty, did often sell our best biscuit and victuals to the citizens, who secretly sold it to the rebels. These their abominable practices were well seen and greatly detested, but could not easily be remedied, the delinquents ever having colourable evasions, and especially because there was no forbidding the emption of munition to merchants upon pain of death (which was thought most necessary), except our stores of munition had then been, and had had sure hope to be, fully supplied, in regard that the winds are there so uncertain as the public stores not being continually furnished, an army might run great hazard before new supplies came if the merchants could no way relieve it. And this necessity of supplying our stores we found apparently at **Kinsale**, where as soon as our ships with men and munition were arrived, the wind turned, and still continued contrary till we took the town by composition, being more than six weeks.


Again, for the great privileges granted to the first English ancestors of these cities, more specially in all this discourse meaning **Waterford**, **Cork**, and **Limerick**, for **Dublin** was in part overawed by the Lord Deputy's residency, and **Galway** gave some good testimonies of fidelity in those dangerous times, I will show, by one or two instances, how the





---

p.266




degenerate citizens of that time perverted the same to pernicious uses. **Waterford** had a privilege by charter from King John that they should not at any time be forced to receive any of the King's forces into the city. And when, upon their manifest rebellion at the very end of the last rebellion, the **Lord Mountjoy, then Lord Deputy**, bringing to their city the forces of our sovereign, King James, therewith to conform them to his Majesty's laws, they, alleging this charter, refused to receive any of the said forces into their city, his lordship vowed to cut King John's charter (as not grantable to such prejudice of his successors) with King James his sword, and to sow salt upon the soil of their destroyed city if they obeyed him not, and with much disputation and power hardly drew them from the ridiculous plea of the said charter.[26](javascript:footNote('T100072/note026.html')) Secondly, all fines for violating penal statutes of the admiralty and all others were by an old charter granted to the citizens, and in these days whereof I write, the citizens degenerated from English to Irish (or rather, to Spanish), if our magistrates imposed any fines upon delinquents, especially in cases for reformation of religion and the like, would privately remit those mulcts falling to the treasure of the city, which impunity made them offend the law without fear, as this and like immunities made them without danger of the law to transport prohibited wares, to parley with rebels, to export and import traitorous **Jesuits** in their ships, and to do manifold insolencies, while it was in the hand of the mayor and his brethren freely to remit all penalties imposed on delinquents. These and like privileges were in those days judged too great for any merchants, and most unfit for merchants of suspected fidelity (to say no worse). To conclude, these citizens were for the most part in those days no less alienated from the English than the very mere **Irish**, upon the same fore-alleged causes, as in one particular case of their community of language with





---

p.267




the **Irish** I have showed, and could many ways illustrate, if I took any pleasure to insist upon that subject.


The **English-Irish** thus affected did generally in these times impute some errors to the state. First, that when any dissolute swordsman, for want, or for means to support his luxury, began to rob and spoil, and so to live in the woods for safety from the law—and there never wanted some like-affected persons, ready, upon the first rumour thereof, to fly unto the woods and live like outlaws with him, which small number the state might easily have prosecuted to death for example and terror to others—yet when these men had spoiled the country and all passengers, experience taught that the state, for fear of a small expense in prosecuting them, used upon their first submission to grant them protections to come in, and then not only to pardon them, but to free them from restitution of that they had robbed, so as good and quiet subjects might see their goods possessed by them, and yet could not recover them. Yea, nothing was more frequent than for the state to give rewards and yearly pensions to like seditious knaves, in policy (forsooth) lest they should trouble the peace, and put the state to charge in prosecuting them. So, as quiet and good subjects being daily wronged without redress, and seditious knaves being rewarded for not doing ill, and, as it were, hired to live as subjects, they said it was no marvel that so many dissolute persons swarmed in all parts of that kingdom. **Galba, the Roman Emperor**, in his oration to his soldiers expecting and murmuring for a largesse, or free gift, at his election, said bravely that he did enrol and not hire his subjects to serve in the war, but this free speech to a dissolute army cost him his life and empire; and such was then the miserable state of **Ireland**, as these corruptions could not altogether be avoided, though they savoured rather of a precarium imperium—that is, a ruling by entreaty and rewards, than absolute command over subjects.


But they further urged that these abuses grew from the corruption of the chief magistrates, for as he said well that no city was impregnable that would open their gates to give





---

p.268




entrance to an enemy's ass laden with gold, so **Ireland** could not have firm peace while no man was so wicked who, for a bribe of cows[27](javascript:footNote('T100072/note027.html')) (such and no other are the bribes of the **Irish**) found that the Lord Deputy's followers and servants, yea, councillors of state, and (I shame to speak it) the very wives and children of the Lord Deputy ready to beg his pardon, who seldom or never missed to obtain it. They further urged that not only armed rebels were in this kind pardoned, but also that those taken and put in our prisons were commonly by like corruption freely pardoned, or suffered under hand to break prison, and then pardoned under pretence of the public good to save charges in prosecuting them, whereof they gave instances of ***O'Donnell***[28](javascript:footNote('T100072/note028.html')) breaking prison in the beginning, and **Cormac MacBaron**'s eldest son in the end of the rebellion, and of many like rebels of note. So as nothing was more vulgarly said among the rebels themselves than that they could have pardon whensoever they listed, according to the poet:


> 1. Crede mihi, res est ingeniosa dare.
>   
> Believe, 'tis a most witty course, 
>   
> to give and bribe with open purse.
> 




And touching the prisons, they said that the jailors of provincial and other prisons seldom brought their prisoners to be tried before judges, but some were executed by martial law, contrary to the dignity of civil justice; others they would affirm to be dead upon their bare word without testimony of the Crowner, or any like proceeding necessary in that case. Others they would affirm to have been freed by the command of provincial governors available rather by custom than law. Yea, they would not shame to confess some to have escaped by breaking prison, as if they were not to be punished for so gross negligence, admitting no excuse.


Touching the sacred power of pardons and protections they confessed that it was fit to give power of protection to





---

p.269




military governors that they might bring rebels in to the state, but they alleged many corrupt abuses committed in that case, whereby not only armed rebels, but many taken prisoners, having once their protection, had means with safety of their persons to importune the state for obtaining their pardon in which kind **MacCarthen**, notorious for many murders, and many like notable villains, had lately been freed from the hand of justice. Again, they confessed that the general giving of protection and pardons by the Lord Deputy was necessary after the rebellion was grown strong and general, when it behoved the state (as a mother) with open arms to receive her disobedient children to mercy lest they should be driven to desperate courses, especially since the punishment of all was impossible in such a strong combination: that of the chief was difficult for their strong factions, and of particular and inferior offenders was somewhat unequal, if not unjust. But they freely said that our State had greatly erred in not making strong and sharp opposition to the first eruption of that rebellion before they were united, yea, rather dallying with them till by mutual combinations they were grown to a strong body, and that for saving of charges, without which it was hoped they might by fair treaties be reclaimed, which foolish frugality in the end caused an huge exhausting of the public treasure, and which vain hope had no probable ground, since the Irish attributed our moderate courses in reducing, rather than conquering them to our fear rather than our wisdom; waxing proud when they were fairly handled and gently persuaded to their duties, as no nation yields more abject obedience when they are curbed with a churlish and severe hand. How much better (said they) had our State done to have given no protection or pardon in the beginning, but to have severely put to death all that fell into our hands (which examples of terror were as necessary in **Ireland** as they ever had been rare), or if pity and mercy had been judged fit to be extended to any, surely not to those who after malicious and bloody acts of hostility were at last broken and unable longer to subsist, much less without





---

p.270




some pecuniary mulct or fine towards the public charge, or with freedom from making restitution to private men, and, least of all, with rewards and pensions bestowed on them for a vain hope of future service. In all which kinds they gave many instances that our state had often erred. To conclude, they said that sharp and speedy prosecution in the beginning had been most easy (scattered troops being soon suppressed with small forces), and no less advantageous and profitable to the state (as well by the confiscation of their lands and goods as by long and firm peace likely to follow such terrifying examples of justice).


Again, they bitterly imputed this error to our state, proved by many notable instances, that Irish and **English-Irish**, who had forsaken their lords in rebellion to serve in our army, after when their lords were received to mercy, with free pardon and restoring of honour and lands, had been quitted and left by us to live again under the same lords highly offended with them, and so never ceasing till they had brought them to beggary, if not to the gallows, which proceeding of ours in their opinion argued that, so we could keep the great lords in good terms, we cared not to forsake the weaker and leave them to the tyranny of the other. Yea, that to these great lords that of rebels were become subjects, our state granted warrants to execute martial law against vagabond and seditious persons, who upon the same pretences had often executed these men returning to them from the service of the state, and more specially those who had faithfully served us in the wars for spies, and for guides to conduct our forces through their bogs and woods and fortified places, or if they had not dared so to execute those men, yet by violent oppressions had brought them to beggary, and sometimes by secret plots had caused them to be killed. In this case, if I may boldly speak my opinion, I should think it were impossible so to protect inferior persons of best desert in time of peace from the tyranny of great lords, as they should no way oppress or hurt them either by their power which is transcendent, or by their craft wherein no people may compare with them. And as formerly I have





---

p.271




spoken at large of oppressions done by their power, so I will give one notable instance of their tyranny by craft. The famous traitor **Hugh, late Earl of **Tyrone****, used in his cups to brag that by one trick he had destroyed many faithful servants to the state, namely, by causing them underhand to be brought in question for their life, and then earnestly entreating the Lord Deputy and the judges to pardon them, who never failed to execute them whose pardon he craved. But why we should subject the servants of the state to the oppression of great lords that had been rebels, or why the state should upon any pretence grant them martial law (the examples of both which I confess were frequent and pregnant), I think no colourable reason can be given.


To be short, among many other errors they did much insist upon this. That our state, contrary to our law of **England**, yearly made such men sheriffs of the counties as had not one foot of land in the counties, and that they bought those places of the Lord Deputy's servants on whom he used yearly to bestow them; which made great corruption, since they who buy must sell. Yea, that these sheriffs were commonly litigious men to the county, who having many suits in law, bought those places to have power in protracting or perverting the justice of their own (as also their friends') causes, especially by making juries serve their turn. And most of all that these sheriffs, as having ill conscience of their own oppression, used yearly after the expiring of their offices, to sue out and obtain the King's general pardon under the great seal of **Ireland**, the bare seeking whereof implied guiltiness, so as the ministers of the state above all other men should be excluded from being capable to have these pardons who ought to be free of all dangerous crimes. Hereof myself can only say, that in **England** these pardons are not obtained without great difficulty; and that the Irish lords in and before the last rebellion complained of nothing more than the extortions and oppressions of these sheriffs, and their numerous trains and dependants, yet pretended the same for a chief cause of their taking arms.


Touching the general justice of **Ireland**, howsoever it was





---

p.272




in the last rebellion tied hand and foot, yet of the former establishment thereof and the hopeful beginning to flourish at the end of the rebellion, something must be said. And first, in general, the **English** have always governed **Ireland** not as a conquered people by the sword and the conqueror's law, but as a province united upon marriage or like peaceable transactions, and by laws established in their parliaments with consent of the three estates. The supreme magistrate is the Lord Deputy (of whose power I have spoken) with the Council of State named and appointed in **England**, and these have their residence at **Dublin**. The next is the Lord President of **Munster**, with counsellors or provincial assistants, named and appointed by the Lord Deputy, with a chief justice and the King's attorney for the province, not having any courts of justice, but only assisting the Lord President at the council table, where, and likewise at **Dublin**, causes are judged by the Lord Deputy and the Lord President, as at the council table in **England**, according to equity with respect to the right of the law.[29](javascript:footNote('T100072/note029.html')) The province of **Connaught** was in like sort governed by a governor (after styled Lord President) with councillors to assist him, and among them a chief justice and the King's attorney, as in **Munster**, both governing in chief as well for military as civil matters, according to their instructions out of **England**, and the directions and commands from the Lord Deputy. The state proposed in like sort to establish the province of **Ulster**,[30](javascript:footNote('T100072/note030.html')) but at the end of the rebellion the **Earl of **Tyrone**** laboured earnestly not to be subject to any authority but that of the Lord Deputy, so as there only some governors of forts and counties (as in other parts of **Ireland**) had authority to compose differences between inferior subjects.




---

p.273


The cities and towns had their subordinate magistrates, as mayors and sovereigns to govern them. But the courts for the common law for all **Ireland** were only at **Dublin**, as the King's Bench, the Common Pleas, and the Exchequer, as likewise the Chancery for Equity. And there the King's records were kept by a Master of the Rolls.[31](javascript:footNote('T100072/note031.html')) And all causes in these several courts were pleaded in the English tongue, and after the manner of the courts in **London**, save that **Ireland** of old times had made such frequent relapses to the sword, as the practice of the law was often discontinued, and the customs of the courts by intermission were many times forgotten, and the places being then of small profit were often supplied by unlearned and unpractised men.[32](javascript:footNote('T100072/note032.html')) And there also at the end of the war was erected the court of the Star Chamber. And there resided the chief judges of the whole kingdom, as the Lord Chancellor, Mr. Chief Justice, the Chief Justice of the Common Pleas, and the Chief Baron of the Exchequer, who had not formerly the style of lords nor scarlet habits, both which were granted them after the rebellion ended, to give more dignity to the law.[33](javascript:footNote('T100072/note033.html')) All the counties had sheriffs for execution of justice yearly appointed by the Lord Deputy, only **Ulster** was not then divided into counties, as now it is, and hath the same officers.[34](javascript:footNote('T100072/note034.html'))


Touching the laws. The mere **Irish** from of old to the very end of the war had certain judges among themselves, who determined their causes by an unwritten law, only retained by tradition, which in some things had a smack of right and equity, and in some others was contrary to all divine and human laws. These judges were called





---

p.274


**Brehons**, altogether unlearned, and great swillers of Spanish sack (which the Irish merrily called the King of Spain's daughter). Before these judges no probable or certain arguments were available to condemn the accused, but only manifest apprehensions in the fact. A murder being committed, these judges took upon them to be intercessors to reconcile the murderer with the friends of the murdered, by a gift vulgarly called Iriesh.[35](javascript:footNote('T100072/note035.html')) They did extort unreasonable rewards for their judgment, as the eleventh part of every particular thing brought in question before them. For the case of incontinency, they exacted a certain number of cows (which are the Irish rewards and bribes) from the married and unmarried, though they lived chastely (which indeed was rare among them), yet more for the married and unchaste than from others. Myself spoke with a gentleman then living, who affirmed that he had paid seven cows to these judges, because he could not bring witnesses of his marriage, when he had been married fifty years. Among other their barbarous laws, or rather customs and traditions, I have formerly spoken of their tenure of land, vulgarly called themistry, or **tanistry**, whereby not the eldest son but the elder uncle, or the most valiant (by which they understand the most dissolute swordsman), of the family succeeded the deceased by the election of the people, whereof came many murders and parricides and rebellions, besides great wrongs done to the state, as in this particular case:—If the predecessor, of free will or constrained by arms, had surrendered his inheritance to the King, and had taken it back from the King's grant by letters patents, upon rent and other conditions for the public good, they at his death made this act void, because he had no right but for life. By these judges and by these and like laws were the mere **Irish** judged to the end of the last rebellion, though the English laws had long before been received in **Ireland** by consent of the three states in Parliament.


For in the tenth year of King Henry VII.,[36](javascript:footNote('T100072/note036.html')) by the





---

p.275




consent of the three states in Parliament, the barbarous Brehon judges and laws, and this particular law of themistry by name, were all abrogated, and the common law and statutes of Parliament made to that day in **England**, were all established in **Ireland**. And from the first conquest to that time and long after, the states of **Ireland** were called to the Parliament by the King's writs, and the laws there made were sent into **England**, and there allowed or deaded in silence by the King; and so the approved were sent back to the Lord Deputy, who accordingly confirmed them for Acts of that Parliament, and rejected the other by the king's authority, by which also the **Lord Deputy**, according to his instructions from the King, prorogued or dissolved the Parliaments. But if the worthy progenitors of our late kings should revive, and see the face of these Parliaments changed, and the very **English-Irish** backward to make laws of reformation, they would no doubt repent their wonted leniency in making them lawgivers to themselves, and freeing them from constraint in that kind. At first this government was fatherly to subjects being as children, but if they were now degenerated, should not the course of government be made suitable to their changed affections? No doubt if the King of **Spain** (whom then they adored as preserver of their liberty, and whose yoke then they seemed glad to undergo) had once had the power to make them his subjects, they should have learned by woeful experience that he should by the same power have imposed such laws on them as he thought fit, without expecting any consent of theirs in Parliament, and would quickly have taught them what difference ever was between the Spanish and English yoke. But if this course might in us seem tyrannical, the statesmen of that time judged it easy by a fairer means to bring them to conformity in a Parliament: namely, by a new plantation of English well affected in religion (who after the war might be sent in great numbers and find great quantities of land to inhabit), out of which men the Lord Deputy by the sheriff's and other assistance, might easily cause the greatest part of the knights of the shire and burgesses to be chosen





---

p.276




for the swaying of the Lower House. As likewise by sending over wise and grave judges and bishops, and if need were by creating or citing new barons by writs (in imitation of King Edward III.), being men well affected to religion and the state, so to sway the Upper House.


The general peace after the rebellion (when **Ireland** was left as a pair of clean tables, wherein the state might write laws at pleasure) gave all men great hope that the laws should receive new life and vigour. Hitherto the barbarous lords at hand had been more feared and obeyed than the King afar off, and though they had large territories, yet neither themselves had raised answerable profit (at least by way of rent) nor the King's coffers had ever swelled with the fatness of peace. But the end of the war was the time (if ever) to stretch the King's power to the uttermost north, to bring the lords to civil obedience, to enrich them by orderly rents, and to fill the King's coffers out of their abundance. And indeed the courts of justice at **Dublin** began to be much frequented before our coming from thence, and shortly after each half year itinerant judges began to ride their circuits through all the parts of **Ireland**, and those who had passed through all **Ulster** to keep assizes there, made hopeful relation of their proceeding to the Earl of Devonshire, Lord-Lieutenant of **Ireland**, residing in the English Court, advertising him that in those sessions they had persuaded the lords to grant their tenants their land by freeholds, copyholds, and leases, that they might build houses, and clear the passes of their woods, to make free passage from town to town, and likewise to give the King a yearly composition of rents and services, and themselves abolishing the old tyrannical exactions called cuttings, to establish their yearly revenues by certain rents, which would be more profitable to them. That the lords seemed gladly to yield to these persuasions, and to establish certain rents to themselves, so they might be permitted after the old manner to make only one cutting upon their tenants for the payment of their debts. That they, the judges, had taught the inferior gentlemen and all the common people that they were not slaves





---

p.277




but free men, owing only rents to their lords, without other subjection, since their lords as themselves were subject to a just and powerful king, whose sacred majesty at his great charge maintained them his judges to give equal justice to them both, with equal respect to the lords and to them for matters of right. That a great lord of **Ulster** named **O'Cane**, having imprisoned a tenant without legal course, they had not only rebuked him for usurping that power over the King's subjects, but howsoever he confessed his error publicly, and desired pardon for it, yet, for example, they had also imposed a fine upon him for the same. And that the inferior gentlemen and all the common people gladly embraced this liberty from the yoke of the great lords, and much applauded this act of justice upon **O'Cane**, promising with joyful acclamations a large composition of rents and services to the King, so this justice might be maintained to them, and they be freed from the tyranny of their lords. So as it seemed to the judges there remained nothing to content the people but a constant administration of this justice, with some patience used towards the people at first in bearing with their humours, among which they more specially noted these:—That they not only expected easy access to the Lord Deputy, the judges and the inferior magistrates, but were generally so litigious and so tedious in complaints as they could not be contented without singular patience. And that from the lords to the inferior sort they had a ridiculous fashion, never to be content without the magistrate's hand under their petitions, and therewith to be content were it never so dilatory, yea flat contrary to their request, which hand they used to sign though they knew the ill and crafty uses the Irish made of it, who coming home would show this hand to their tenants and adversaries, without reading the words to which it was set, and so pretending the magistrates' consent to their request, many times obtained from ignorant people their own unjust ends. Yet had not the law as yet that general and full course in **Ireland** which after it had by continuance of peace, and by that dignity which the King's majesty gave to the law, in granting the title





---

p.278




of lords to the chief judges, and the scarlet robes to them all.


It remains to say something of the hands whereby the law was to be put in practice, namely the lawyers. They were either **English**, sent, or willingly coming out of **England**, more specially at the end of the rebellion, of whose concurring in the reformation of **Ireland** I make no doubt; or **English-Irish**, who of old, and now after the rebellion, in greater numbers pleaded most of the causes in the courts of justice. These **English-Irish** lawyers were always wont to study the common laws of **England** in the Inns of Court at **London**, and being all of the Roman religion (as the rest in **Ireland**), did so lurk in those Inns of Court as they never came to our churches, nor any of them had been observed to be taught the points of our religion there, but having got a smack of the grounds of our law, and retaining the old superstition in religion, they returned to practise the law in **Ireland**, where they endeavoured nothing more than to give the subjects counsel how they might defraud the King of his rights, and find evasions from penalties of the law, more specially in matters of religion, the reformation whereof they no less feared than the rest, and therefore contrary to their profession nourished all barbarous customs and laws, being the seeds of rebellion, and sought out all evasions to frustrate our statutes abrogating them, and tending to the reformation of civil policy and religion. For prevention of which mischief many thought in those times it were fit to exclude them from practice at the bars of justice, but since experience hath taught us how weak this remedy is, while the priests swarm there, combining the people, according to the rule of St. Paul, not to go to law under heathen magistrates, for such or no better they esteemed ours, and so reducing all suits of law, and the profit thereby arising, to the hands of the same lawyers in private determinations, whom the state excluded from public pleading at our bars; so as there is no way better to remedy this mischief than during their education at our inns of court in **England** to bring





---

p.279




them to church, and teach them our religion, and after to punish some particular men that are of greatest practice and most refractory, by which examples, and the strict eye and hand of our magistrates seen to hang over them, this mischief might in time either be taken away or be made less general.


These lawyers taught the proud and barbarous lords of **Ireland** how they might keep the people of their countries in absolute subjection, and make them not only obey for fear of their power daily hovering over their heads, but also to think that their lords by right of law or equivalent custom had absolute command over their goods and bodies. By which and like means they not only gave strength to rebellious affections, but also made open resistance to all intended reformations, to their uttermost power seeking to root out the wise foundations to that end carefully laid by former ages, or at least to shake them and still keep them from any firm establishment. In this kind I will only give one instance. When **Rory O'Donnell**[37](javascript:footNote('T100072/note037.html')) at the end of the rebellion was come over into **England**, with the **Lord Mountjoy** (after created Earl of Devonshire), there to obtain the confirmation from the King's majesty of that pardon and grant of his brother's land[38](javascript:footNote('T100072/note038.html')) (the second arch-rebel) which the said lord had promised him at his submission while he was yet in **England**, and all that depended formerly on his brother, hovered between hope and fear how they and that country should be established, one of these lawyers employed there by the said **Rory** persuaded **MacSwyne** and **O'Boyle**, and other gentlemen of old freeholders in Tirconnell under the **O'Donnells**, that they had no other right in their lands but only the mere pleasure and will of O'Donnell. This the said gentlemen, though rude, and in truth barbarous, and altogether ignorant in our laws, not only denied, but offered to produce old writings to prove the contrary. When that fox perceived their confidence, and after heard that the said **Rory** had his pardon, and lands confirmed in **England**, and was moreover created Earl of Tirconnell, he essayed these gentlemen another way, telling them





---

p.280




that the King having granted pardon, and all his brother's land to this new **Earl of **Tirconnell****, they having yet no pardon had lost all their old right in their lands, were it freehold or at the lord's pleasure, or what other right soever, and so could now have no dependency but on the Earl's favour. Herein he told a triple lie: first, that he denied their right of freehold which was held to be most certain, though it had been abolished by long tyranny of the chief lord, and perhaps at first owed him some limited services, as **Tirlogh MacHenry** for the Fewes, and **Henry Oge** for his country, did both owe to the **Earl of **Tyrone****, and all under lords in **England** owe to the lord paramount. Secondly, that he affirmed the whole province to be given to the Earl by the King, whereas it was granted in these express words, ‘to hold to his Majesty's special grace in as ample manner as his brother held it before the rebellion’ (in which he was as far engaged as his brother), which grant took not away the former right of freehold or other that any subject might pretend. Thirdly, that he restrained the King's gracious pardon as if it extended only to the Earl, when it was general to all the inhabitants of **Tirconnell**, restoring them all to their former rights. Yet by this shameful lie he obtained the unjust end he sought, to the great prejudice of the King's majesty's service, and of his subjects in **Tirconnell**. For these gentlemen and the rest of the people in that province being ignorant of the law, and afraid of every rumour, upon a guilty conscience of deserved punishment in their rebellion, and the new change of the state in **England**, were easily induced to renounce all their rights to the said Earl (though with great prejudice to themselves and ignominy to the justice of the state), and to receive their lands by new grants from the Earl as of his mere grace and favour. And howsoever the itinerant judges did after make known their error to them, and gave them hope this act would be reversed upon their complaint, yet they chose rather to enjoy their estates in this servile kind with the said Earl's favour, than to recover their rights and freedoms by course of law with his displeasure.




---

p.281


Again these lawyers in all parts of **Ireland** taught the people artificial practices to defraud the king of his rights, in services due to the lords of their fees in his Court of Wards, and liveries, intrusions, alienations, yea in very confiscations of goods and lands, the preservation whereof to the heirs will always make the possessor more prone to treasons and all wickedness. For the truth whereof I appeal to all friends and servants of former Lords Deputies, who have obtained any such gifts of wards, intrusions, alienations and confiscations; for they well know what tedious suits, crafty circumventions, and small profit they have found thereby. And I appeal to the manifold conveyances of lands by feoffees of trust, and all crafty devices, nowhere so much used as in **Ireland**. Insomuch as nothing was more frequent than for Irishmen, in the time of our war with **Spain**, to live in **Spain**, in **Rome**, and in their very seminaries, and yet by these and like crafty conveyances to preserve to them and their heirs their goods and lands in **Ireland**, yea very spiritual livings for life, not rarely granted to children for their maintenance in that superstitious education, most dangerous to the state.


I formerly showed that King Henry VII. established the English laws in **Ireland**, yet the common law, having not his due course in the time of the rebellion, most civil causes were judged according to equity at the council tables, as well at **Dublin** as in the provinces of **Munster** and **Connaught**, and by military governors in several counties. And for these laws of **England**, the most remarkable of them shall be explained in the discourse before promised of the commonwealth of **England**.[39](javascript:footNote('T100072/note039.html'))


In like sort the laws of **England** were for capital matters established in **Ireland**, but during the rebellion and at the end thereof the martial law was generally used, hanging up malefactors by withes instead of ropes upon their first





---

p.282




apprehension. In cases of treason the great lords of the kingdom were of old judged by the assembly of the three states in Parliament; but since Henry VII.'s time they are tried as in **England**, the lords being beheaded, and others hanged, drawn and quartered. As in **England** so there, not only treasons but wilful murders and felonies are punished by death and confiscation of lands and goods. By the law in **England**, so in **Ireland**, the accessory cannot be tried before the principal be apprehended and brought to his trial, so as the principal escaping, receivers cannot be judged. And so for other capital laws of **England**, which shall be at large set down in the foresaid treatise. The English laws of inheritance are likewise of force in **Ireland**, the elder brother having right to the lands of descent, and the father's last will disposing purchased lands and goods among his wife and children, and the wife being widow, besides her part that may be given her by her husband's last will, having the jointure given her before marriage, and if none such were given her, then having right to the third part of his lands for her life.


Touching the degrees in the commonwealth; not to speak of the offices of the Lord Chancellor and the Lord High Treasurer, giving place above all degrees of nobility, the highest degree is that of Earls. And the Earl of Ormond in this time whereof I write was Lord High Treasurer of **Ireland**, and knight of the noble **Order of the Garter** in **England**. The next degree is that of Barons.[40](javascript:footNote('T100072/note040.html')) And in general, as the degrees of the Irish nobility in **England** give place to all the English of the same degree, so do the English to the Irish in **Ireland**. But howsoever the Irish lords, to make their power greater in peace, are content to have the titles of earls and barons, yet they most esteem the titles of O and Mac set before their surnames, after their barbarous manner (importing the chief of the sept or name), as 





---

p.283


**O'Neale**, **>O'Donnell**, **MacCarthy**, and the like. And these names they used to resume when they would lead the people into rebellion. The title of Knights Baronets was not then known in **Ireland**. They have no order of knighthood like that of the **Order of the Garter** in **England**,[41](javascript:footNote('T100072/note041.html')) and the like in other kingdoms, but only, as in **England**, such knights as are made by the sword of the King, or of the Lord Deputy there, who always has the power, by his permission from the King, to make any man knight whom he judges worthy of that dignity.[42](javascript:footNote('T100072/note042.html')) The poorest of any great sept or name repute themselves gentlemen, and so will be swordmen, despising all arts and trades to maintain them; yet such is the oppression of the great lords towards the inferior sort, the gentlemen and freeholders, as I have seen the chief of a sept ride, with a gentleman of his own name (and so learned as he spoke Latin) running barefooted by his stirrup. The husbandmen were then as slaves, and most exercised grazing, as the most idle life, using tillage only for necessity.


Touching the degrees in the family. The citizens of **Munster**, as in **Waterford**, **Limerick**, and more specially in **Cork**, and they of **Galway** in **Connaught**, upon the law forbidding marriage with the mere **Irish**, and especially to keep the wealth of the city within the walls thereof, have of old custom used to marry with their own citizens, whereby most of the families and private branches of them were in near degree of consanguinity one with another, frequently marrying within the degree forbidden by the law of God. And the married women of **Ireland** still retain their own surnames, whereas the English, losing them utterly, do all take the surname of their husbands. The men hold it disgraceful to walk with their own wives abroad, or to ride with their wives behind them.





---

p.284




The mere **Irish** divorced wives, and with their consent took them again frequently, and for small, yea ridiculous, causes, always paying a bribe of cows to the Brehon judges, and sending the wife away with some few cows more than she brought. And I could name a great lord among them, who was credibly reported to have put away his wife of a good family and beautiful, only for a fault as light as wind (which the Irish in general abhor), but I dare not name it, lest I offend the perfumed senses of some whose censure I have incurred in that kind. The more civil sort were not ashamed, and the mere **Irish** much less, to own their bastards, and to give them legacies by that name. Insomuch as they have pleasant fables of a mother, who upon her deathbed (according to their above-mentioned custom), giving true fathers to her children, and finding her husband offended therewith, bade him hold his peace, or else she would give away all his children. As also of a boy, who seeing his mother give base fathers to some of his brethren prayed her with tears to give him a good father. The children of the **English-Irish**, and much more of the mere **Irish**, are brought up with small or no austerity, rather with great liberty, yea licentiousness. And when you read of the foresaid frequent divorces, and generally of the women's immoderate drinking, you may well judge that incontinency is not rare among them; yea even in that licentiousness they hold the general ill affection to the English, sooner yielding those ill fruits of love to an Irish horse-boy than to any English of better condition; but how their priests triumph in this luxurious field let them tell who have seen their practice.


It remains to speak something of their military affairs. Their horsemen are all gentlemen (I mean of great septs or names, how base soever otherwise), and generally the Irish abhor from using mares for their saddle, and indeed they use no saddles, but either long, narrow pillions bumbasted or bare boards of that fashion. So as they may easily be cast off from their horses, yet being very nimble do as easily mount them again, leaping up without





---

p.285




any help of stirrups, which they neither use nor have, as likewise they use no boots nor spurs.[43](javascript:footNote('T100072/note043.html')) They carry weighty spears, not with points upwards, resting them on their sides or thighs, but holding them in their hands with the points downwards, and striking with them as with darts, which darts they used to carry, and to cast them after their enemies when they wheel about; these spears they use to shake over their heads, and by their sides carry long swords, and have no defensive armour but only a morion on their heads. They are more fit to make a bravado and to offer light skirmishes than for a sound encounter. Neither did I ever see them perform anything with bold resolution. They assail not in a joint body but scattered, and are cruel executioners upon flying enemies; but otherwise, howsoever they make a great noise and clamour in the assault, yet, when they come near, they suddenly and ridiculously wheel about, never daring to abide the shock. So as howsoever the troops of English horse by their strong second give courage and strength to their foot companies, yet these Irish horsemen basely withdrawing themselves from danger are of small or no use, and all the strength of the Irish consists of their foot, since they dare not stand in a plain field, but always fight upon bogs and passes of skirts of woods, where the foot being very nimble come off and on at pleasure, and if the enemies be fearful upon the deformity and strength of their bodies or barbarous cries they make in the assault, or upon any ill accident show fear and begin to fly, the Irish foot without any help of horse are exceeding swift and terrible executioners, in which case only of flying or fearing they have at any time prevailed against the **English**. And how unprofitable their horse are, and of what small moment to help their foot, that one battle at **Kinsale** did abundantly show, where the Irish horse and foot being encouraged by the **Spaniards** to stand in the plain field, the horse were so far from giving the foot any courage or second, as for fear they break first through





---

p.286




their own bodies of foot, and after withdrawing themselves to a hill distant from the foot as if they intended rather to behold the battle than to fight themselves, by this forsaking of their foot they might justly be said to be the chief cause of their overthrow. Their horses are of a small stature, excellent amblers, but of little or no boldness and small strength either for battle or long marches, fit and used only for short excursions in fighting and short journeys, and, being fed upon bogs and soft ground, are tender-hoofed, and soon grow lame used upon hard ground. So as our English horsemen, having deep war saddles and using pistols as well as spears and swords, and many of them having corslets and like defensive arms, and being bold and strong for encounters and long marches, and of greater stature than the **Irish**, our troops must needs have great advantages over theirs.


Touching their foot, he that had seen them in the beginning of the rebellion so rude—as being to shoot off a musket, one had it laid on his shoulders, another aimed it at the mark, and a third gave fire, and that not without fear and trembling—would have wondered, in short time after, to see them most bold and ready in the use of their pieces, and would have said that the **Spartans** had great reason who made a law never to make long war with any of their neighbours, but after they had given them one or two foils for strengthening of their subjection, to give them peace, and lead their forces against some other, so keeping their men well trained, and their neighbours rude, in the feats of war. But when the **Earl of **Tyrone**** first intended to rebel, he used two crafty practices. The first, to pretend a purpose of building a fair house (which we hold a sure argument of faithful hearts to the state), and to cover it with lead, whereby he got license to transport a great quantity of lead out of **England**, which after he converted to make bullets. The second, to pretend to join his forces in aid of the English against the first rebels which himself had put forth, whereby he got our captains, with licence of the state, to train his men, who were after called ‘Butter Captains’ because they





---

p.287




and their men lived upon cess in his country, having only victuals for their reward. And surely, howsoever some of the English state lightly regarded the frequent rebellion of the Irish, thinking them rather profitable to exercise the **English** in arms than dangerous to disturb the state; yet woeful experience taught us that the last rebellion wanted very little of losing that kingdom. The Irish foot in general are such as, I think, men of more active bodies, more able to suffer cold, heat, hunger, and thirst, and whose minds are more void of fear, can hardly be found. It is true that they rather know not than despise the rules of honour observed by other nations; that they are desirous of vainglory, and fearful of infamy, appears by their estimation of their bards or poets, whom they gladly hear sing of their praise, as they fear nothing more than rhymes made in their reproach. Yet because they are only trained to skirmish upon bogs and difficult passes or passages of woods, and not to stand or fight in a firm body upon the plains, they think it no shame to fly or run off from fighting, as they advantage (and indeed at **Kinsale**, when they were drawn by **Spaniards** to stand in firm body upon the plain, they were easily defeated). And because they are not trained to keep or take strong places, they are easily beaten out of any forts or trenches, and a weak house or fort may easily be defended with a few shot against their rude multitude. Divers kinds of foot use divers kinds of arms. First, the **Galliglasses** are armed with morions and halberts. Secondly, the **Kerne** and some of their footmen are armed with weighty iron mails and jacks, and assail horsemen aloof with casting darts, and at hand with the sword. Thirdly, their shot, which I said to be so rude in the beginning of the rebellion as three men were used to shoot off one piece not without fear, became in few years most active, bold, and expert in the use of their pieces. All these foot assail the enemy with rude barbarous cries, and hope to make them afraid therewith, as also with their nakedness and barbarous looks, in which case they insist violently, being terrible executioners, by their swiftness of foot upon flying enemies, never sparing any that yield to mercy; yea,





---

p.288






being most bloody and cruel towards their captives upon cold blood, contrary to the practice of all noble enemies, and not only mangling the bodies of their dead enemies, but never believing them to be fully dead till they have cut off their heads. But after the **English** had learned to abide their first assault firmly and without fear, notwithstanding their boldness and activity, they found them faintly to assail, and easily to give ground when they were assailed, yet never could do any great execution on them upon the bogs and in woods, where they were nimble to fly, and skilful in all passages, especially our horse there not being able to serve upon them. To conclude, as they begin to fight with barbarous cries, so it is ridiculous and most true that when they begin to retire from the skirmish, some run out to brawl and scold like women with the next enemies, which sign of their skirmish ending and their retiring into the thick woods never failed us.


Touching the ships in **Ireland**, they had then no men-of-war, nor merchants' ships armed, only some three or four trading for **Spain** and **France** carried a few iron pieces for defence against pirates in our Channel that might assail them in boats, and they were all under one hundred tons burthen. The rest of their ships were all of much less burthen, serving only to transport passengers to and fro, and horses and merchandise out of **England**, little or nothing being carried out of **Ireland** in time of the rebellion. And these were not many in number, the English ships most commonly serving for those purposes. So, as little can be said of their mariners for navigation, only by the general nature of the people, I suppose, that they being witty, bold, and sluggish, if they had liberty to build great ships for trade, they were like to prove skilful and bold in navigation, but never industrious in traffic. It is true that the arch-traitor **Earl of **Tyrone****, upon his good successes, grew at last so proud, as in a treaty of peace he propounded an article, that it might be lawful for the **Irish** to build great armed ships for trade, and men-of-war for the defence of the coast; but it was with scorn rejected by the Queen's Commissioners. Lastly, I think I may boldly say, that no





---

p.289




island in the world hath more large and commodious havens for the greatest ships—and whole fleets of them—than **Ireland** hath on all sides; excepting **St. George's Channel**, which hath many flats, and the havens there be few, small and barred, or unsafe to enter; for, otherwise in one-third part of **Ireland**, from **Galway** to **Killybegs** in the north, it hath fourteen large havens, whereof some may receive two hundred, some three hundred, some four hundred great ships, and only two or three are barred and shallow, besides divers large and commodious havens in **Munster**.


Having spoken particularly of their horse and foot and shipping, I will add something in general of the Irish wars. It hath been observed that every rebellion in **Ireland** hath grown more dangerous than the former, and though mariners are industrious and vigilant in a tempest, yet the **English** have ever been slow in resisting the beginnings of sedition, but as mariners sleep securely in calms, so the **English** having appeased any rebellion, ever became secure without taking any constant course to prevent future dangers in that kind. In this last rebellion I am afraid to remember how little that kingdom wanted of being lost and rent from the English Government, for it was not a small disturbance of peace or a light trouble of the state, but the very foundations of the English power in that kingdom were shaken and fearfully tottered, and were preserved from ruin more by the Providence of God out of His great mercy (as may appear by the particular affairs at the siege of **Kinsale**) than by our counsels and remedies (which were in the beginning full of negligence, in the progress distracted with strong factions, and to the end slow and sparing in all supplies), so as if the Irish soldiers which were at first unskilful (and ought to have been so kept in true policy of state) as in short time they grew skilful and ready in the use of the piece, the sword and other arms, and very active and valiant in light skirmishes, had likewise attained the discipline of war to march orderly and fight upon the plain, to assault and keep forts, and to manage great ordnance (which they neither had nor knew to use); if





---

p.290




the barbarous lords, as they were full of pride, some vaunting themselves to be descended from the old kings of **Ireland**, so had not nourished factions among themselves, but had consented to choose a king over them, after their many good successes, more specially after the defeat of **Blackwater** (when it was truly said of the **Earl of **Tyrone**** that the **Romans** said of **Hannibal** after the defeat of **Cannae**, ‘Thou knowest to overcome, but knowest not to make use of thy victory’); not to speak of the Providence of God even miraculously protecting our religion against the papists; no doubt in human wisdom that rebellion would have had another end than by the grace of God it had. And it was justly feared that if constant serious remedies were not used to prevent future eruptions, the next rebellion might prove fatal to the English state.


Now that I may not seem forward to reprove others, but negligent in observing our own errors, give me leave to say boldly, and to show particularly, that the following and no other causes brought upon us all the mischiefs to which the last rebellion made us subject. When any rebel troubled the state our custom was, for saving of charges, not to suppress him with our own arms, but to raise up some of his neighbours against him, supporting him with means to annoy him, and promoting him to greater dignities and possessions of land, and if he were of his own blood, then making him chief of the name (which dignity we should constantly have extinguished since nothing could more disturb peace than to have all septs combined under one head). And these neighbour lords thus raised never failed to prove more pernicious rebels than they against whom they were supported by us. One instance shall serve for proofs: that of the **Earl of **Tyrone****, raised by our state from the lowest degree against his kinsman **Tirlogh Linnagh**,[44](javascript:footNote('T100072/note044.html')) whom the Queen too long supported, even till his men were expert in arms, and too highly exalted, even till he had all





---

p.291




his opposite's power in his hand, which he used far worse than the other, or any of the **O'Neales** before him. In our state parcatur sumptui, let cost be spared, were ever two most fatal words to our government in **Ireland**, as by this and that which follows shall plainly appear. When the rebellion first began we, to save charges, not only used the Irish one against the other, but long forbore to levy English soldiers, vainly thinking to reduce them by treaties. When the rebellion was increased we, to save charges in transporting English soldiers, raised whole companies of **English-Irish**, and as our captains had trained Tyrone's men while he pretended service to the state, so now we trained in our army all the **English-Irish**, giving them free use of arms, which should be kept only in the hands of faithful subjects. This raising of whole companies of foot and troops of horse among them, was a great error, for they once having gotten the use of arms we durst not cast them, lest they should fall to the rebels' party. Perhaps their social arms might have been useful if we had mixed them in our companies, and that in small limited numbers, but we not only raised whole bands of them, and all of one sept or name (easily conspiring in mischief), and used their service at home (where they would now draw blood upon any neighbour sept and lived idly upon their own provisions, putting all the Queen's pay into their purses, which might have been prevented by employing them in remote places), but sometimes trusted them with keeping of forts, for which service they are most unfit, though we doubted not of their faithfulness, justly then suspected, yea, further weakened all our own bands and troops by entertaining them. For an English troop of horse sent out of **England**, commonly in a year's space was turned half into **Irish** (having worse horses and arms and no saddle, besides the loss of the English horsemen) only because the **Irish** would serve with their own horses and could make better shift with less pay. And in like sort our English bands of foot were in short time filled with **English-Irish**, because they could make better shift for clothes and meat, with less pay from their captains.




---

p.292


In all the war we only used the **English-Irish** for horseboys, who were slothful in our service, and little loved us, but having learned our use of arms, and growing of ripe years, often proved stout rebels. To conclude these errors, I confess that the **English-Irish** served valiantly and honestly in our army, whereof many times a third part consisted of them, but many particular events taught us that these our counsels were dangerous, and made us wish they had been prevented at first, though in the end for necessity we made the best use we could of the worst.


Other great abuses, though less concerning the **Irish** in particular, were committed in our army. The munitions in great part was of sale wares, as namely the tools for pioneers, and muskets slightly made to gain by the emption, which our officers might have shamed to see compared with those the **Spaniards** brought to **Kinsale**. Our powder and all munitions were daily sold to the rebels by divers practices, for sometimes the under-officers of the Ordinance there would sell some proportions of divers kinds of munition to citizens or ill-affected subjects, and sometimes the cast captains, commonly using to appropriate to themselves the arms of their cast soldiers, did sell them to the citizens, and sometimes the common soldier, having a proportion of powder allowed him for exercise of his piece, sold to the citizens whatsoever he could spare thereof, or of the powder left him after skirmishes, and all these munitions sold to the citizens were by them underhand conveyed to the rebels, who would give more for them than they were worth. In like sort the contractors serving the army with victuals, having obtained from the council in **England** liberty to sell to the citizens and poor subjects such victuals as were like to grow mouldy, their servants in **Ireland** many times, while they served the army with mouldy biscuit and cheese, did underhand sell the best to such citizens and subjects, by whom it was conveyed to the rebels. For reforming of which abuses, command was given out of **England** that some offenders should be detected, and severely punished for example, and that the citizens should be forbidden upon





---

p.293




great penalty to buy any munition upon pretence to sell it to subjects, who should rather be served out of the public stores, and that the victuallers should be restrained from selling any victuals, or because that could not be without great loss to the public state in allowing great waste, that faithful overseers at least might be appointed to view what was mouldy, and to whom it was sold. But these abuses were not detected till towards the end of the rebellion, so as the remedies too late prescribed were never put in execution.


Again, one great mischief did great prejudice to us, that our stores were not always furnished aforehand, so as the moving of our army was often stayed till the munition and victuals arrived, which is most dangerous, especially in **Ireland**, where winds out of **England** are very rare, and blow contrary half a year together; whereof we had experience at **Kinsale**, where as soon as our soldiers, munition and victuals were happily arrived, the wind turned presently to the west, and blew no more out of **England** till the **Spaniards** had yielded upon composition.


Again, our provant master for apparelling the soldier dealt as corruptly as the rest, not sending half the proportion of apparel due to the soldier, but compounding for great part thereof with the captains in ready money, they having many Irish soldiers who were content to serve without any clothes so good as the allowed price required. The provant masters thus compounding with the captains, they contented the soldiers with a little drinking money, which the **Irish** desired rather than clothes, not caring to go half naked, by whose example some of the **English** were drawn to like barbarous baseness. So as in a hard winter siege, as at **Kinsale** (and likewise at other times), they died for cold in great numbers, to the grief of all beholders. Again, we had no hospitals to relieve the sick and hurt soldiers, so as they died upon a small cold taken, or a prick of the finger, for want of convenient relief for few days till they might recover.


Thus however they wanted not excellent chirurgeons and careful of them, yet particularly at the siege of **Kinsale**,





---

p.294




they died by dozens on a heap, for want of little cherishing with hot meat and warm lodging, notwithstanding the Lord Deputy's care, who had imposed on his chaplain the task to be as it were the sick soldiers' steward, to dispense a good proportion of victuals ready dressed for comfort of the sick and hurt soldiers, at the charitable alms of the captains above the soldiers' pay. Where a king fights in the head of his army, such brave soldiers as ours were could not have suffered want, but deputies and generals, though honourable and charitable persons, cannot go much beyond their tether. To conclude, nothing hath more preserved the army of the United Netherlanders than such public houses, where great numbers have been recovered, that without them must needs have perished.


Lately **Guicciardini** writes that the Popes are more abused in their musters of soldiers than any other prince; which may be true compared with the frugal **Venetians**, and states of the **Low Countries**, and with armies where the prince is in prison. But I will boldly say that **Queen Elizabeth** of happy memory, fighting by her generals, was incredibly abused in the musters of her army, both in the **Low Countries** and **France**, and especially in **Ireland**, where the strongest bands of one hundred and fifty by list never exceeded one hundred and twenty by poll at the taking of the field, upon pretence of ten dead pays allowed the captain for his servants waiting on him, and for extraordinary pays he might give some gentlemen of his company, as also for sick soldiers left in his garrison, besides that many times the strongest bands were much weaker by wanting of supplies of **Englishmen** to fill them. But they were far more weak at pretence of men dead in the summer service, yet were the coming out of the field and retiring of garrisons upon checks nothing answerable to the deficient numbers, wherein the Queen was much wronged, paying more than she had, and her general served with great disadvantages, being reputed to fight with greater numbers in list, when he had not two-third parts of them by poll, yet scarce half of them, considering the men taken out of the army for warders in





---

p.295




castles and forts. It is a pity the Pope's should not be much more abused in; but temporal princes, to whom the mystery of arms properly belongeth, ought carefully to prevent this mischief to pay men in list who are not to be found by poll when they should fight. And more specially in forts, where the covetous captains abating their numbers, and passing their false musters by bribery, lie open to the enemies' surprisal, as besides many other examples we found by the destruction of our garrison at the **Derry** in **O Dogherty**'s rebellion, where the captain wanted many of his number, and of those he had, many were **English-Irish**, serving for small pay, to whom the keeping of forts should not be committed. The Queen, to prevent this mischief, increased her number of commissaries, but that was only to increase the captain's bribes, not the number of his men. Therefore some thought the best reformation would be, if the pay formerly made to the captain for his whole band were paid by a sworn commissary to the soldiers by poll, and those commissaries exemplarily punished upon any deceit, whose punishment the soldier would not only well, besides that the apparel provided by them was nothing near (induce), but joyfully applaud. Others thought the pay should still be made to the captains as honourable persons, so their deceit were punished by note of infamy, and cashiering out of employment, in which case their honour being dear to them, they would either not offend, or few examples of punishment would reduce all to good order in short time.


Having largely written of all mischiefs grown in the government of **Ireland**, I will add something of the reformation intended at the end of the last rebellion. The worthy **Lord Mountjoy** (as I have mentioned in the end of the second part of this work) having reduced **Ireland** from the most desperate estate, in which it had ever been since the Conquest, to the most absolute subjection, being made as a fair pair of tables wherein our state might write what laws best fitted it; yet knowing that he left that great work imperfect and subject to relapse, except





---

p.296




his successors should finish the building whereof he had laid the foundation, and should polish the stones which he had only rough hewed; and finding every rebellion in **Ireland** to have been more dangerous than the former, and the last to have wanted little of casting the **English** out of that kingdom, was most careful to prevent all future mischiefs. To which end (howsoever his designs were diverted), I dare boldly say, both from his discourse with nearest friends and from the papers he left, that he projected many good points of reformation, whereof these few that follow are worthy to be remembered.


First, to establish the maintenance of some necessary forts planted within land remote from seas and rivers, the warders whereof might clear all passes (or passages of bogs and woods), and might not only keep the **Irish** in awe, but be to the state as it were spies to advertise all mutinous and seditious inclinations. Also, to plant like garrisons upon such havens as be easy and commodious for the descent of foreign enemies. And because the cities (especially of **Munster**) having large privileges granted to the first English inhabitants (as, namely, the profit of fines and penal statutes) had many ways abused them in the last rebellion, to the prejudice of the commonwealth (as, namely, in remitting to the delinquents all fines and penalties imposed on them for transporting and importing **Jesuits** and priests and prohibited wares), and also because these cities in the rebellion, had nourished the same by secret practices, and in the end thereof had by open sedition in the cause of religion forfeited their charters, his lordship purposed to procure the cutting of many exorbitant privileges in the renewing of their charters, and likewise the establishing of forts with strong garrisons upon those cities which had showed themselves most false-hearted and mutinous, more specially **Cork** and **Waterford**, who had denied entrance to the King's forces, and were only reduced by a strong hand from their obstinate sedition, without which forts he thought the cities would neither be kept in obedience for the safety of the army, nor be brought to any due reformation in religion.




---

p.297


But howsoever **Dublin** was no less ill-affected in the cause of religion than the rest, yet he thought it sufficiently restrained by the residency of the Lord Deputy in the Castle, and great numbers of **English** that lodged in the city attending upon the state. For the forts within land[45](javascript:footNote('T100072/note045.html')) he hoped they would in short time become towns well inhabited, as was found by experience in the old forts of **Leix** and **Ophaly**, and in some new forts in **Ulster**, and that they would much strengthen the state, so great caution were had that only English soldiers should keep them, and that by faithful musters they were kept strong, so as the covetousness of captains might not lay them open to surprisal, either by taking Irish soldiers serving for less pay, or by wanting their full numbers of warders; and that, as the garrisons were to have land allotted and many privileges granted to them, so constant care was taken to keep them from spoiling the country by severe discipline. Again, for the forts, because he feared the soldiers could not be kept from making affinity by marriage with the neighbouring **Irish**, and for that the captains and officers were likely to entertain the **Irish** for soldiers and servants as content with small or no wages, whereby the forts could not but be subject to betraying, as likewise for that the captains were likely, in time, by letters patents from the state, to appropriate to themselves the land allotted to each fort for the public use of the garrisons, and for divers like reasons, more specially for that the continual sound of drums and trumpets was dissonant from a commonwealth peaceably governed, his lordship thought these forts were not like to yield such strength to the state as the planting of faithful colonies. And so his lordship in the second place purposed to persuade the reformation of the old colonies and the leading of new into that kingdom, both to be planted upon the sea coasts and upon rivers and navigable lakes lying upon the





---

p.298




sea, forcing the **Irish** to inhabit the country within land, whereby these colonies might be free or more safe from their assaults, and not only be easily relieved out of **England**, but grow rich with foreign traffic. And to this purpose to exchange inland possessions pertaining to the old colonies or belonging to the King with such Irish as then had their lands upon the sea coasts, rivers, and lakes, giving them greater proportions of ground to make them better content with this exchange. Some advised in this exchange to give the **Irish** also those spiritual livings which they held by custody as vacant at that time, but this course was thought to overthrow the foundations of all good reformation that must begin with religion, which could not be established without settling a learned and honest clergy, nor they be maintained without these livings. But because the **Irish** and **English-Irish** were obstinate in Popish superstition, great care was thought fit to be taken that these new colonies should consist of such men as were most unlike to fall to the barbarous customs of the **Irish**, or the Popish superstition of **Irish** and **English-Irish**, so as no less cautions were to be observed for uniting them and keeping them from mixing with the other than if these new colonies were to be led to inhabit among the barbarous **Indians**. In which respect caution was thought fit to be had, that these new colonies should not consist of obstinate papists, nor criminal fugitives, cut-purses, and infamous women, or persons rather drawn out to cleanse **England** of ill members, than to reduce **Ireland** to civility and true religion, but of honest gentlemen and husbandmen to inhabit the country, and honest citizens and merchants to inhabit the cities, with women of good fame, and especially learned and honest preachers and ministers for them both. That the citizens, consisting of noble and plebeian families, should build and fortify cities upon the rivers and lakes, to be thoroughfares for the whole kingdom, all other by-passages through woods and desert places being shut up, so as thieves and malefactors might more easily be apprehended, and all cattle being not otherwise to be sold or bought





---

p.299




than in the public markets of cities, all thefts and rapines might easily be detected, and the barbarous people seeing the citizens to live plentifully under good government, and to grow rich by trades and traffic, might in time be allured to embrace their civil manners and profitable industry. That the gentlemen inhabiting the adjoining countries should dwell in castles of stone, and not keep their husbandmen under absolute command as tenants at will, but grant them freeholds, copyholds, and leases, with obligation to maintain horse and foot, and to rise up with them for defence of the country from thefts and incursions. And in case **England** was not able to supply these colonies, or the **English** (as less industrious) were not thought so fit for this purpose, without others joined with them, then his lordship judged the Netherlander most fit to be drawn to this work as a people most industrious, peaceable, and subject to just command, and abounding with inhabitants, but straitened by not having large territories. Many other cautions were projected for the quality of these colonies, as that they should not dwell together in great numbers of one sept or name, nor should consist of bordering people used to live like outlaws upon spoil, and one sept to have deadly quarrels and hatred (as it were by inheritance) with another. That they should be a free people like the **Flemings**, and used to live of themselves like them and the **Italians**, not used to the absolute command of lords after the servile manner of **Ireland**, which dependency makes them apt to follow their lords into rebellion and private quarrels. That they should be such as were not used to live in smoky cottages and cabins, or to go naked and in ragged apparel, but in commodious houses and decently attired, that so they might not be apt to fall to the Irish manners, but rather to bring them to civility. That they should be planted in remote places from their native home lest in seditions they might easily draw their neighbouring friends and countrymen to take part with them. Finally and especially, that they should be soundly affected to the reformed religion. Thirdly, because his lordship knew all endeavours would





---

p.300




be in vain if civil magistrates should think by fair means without the sword to reduce the **Irish** to due obedience (they having been conquered by the sword, and that maxim being infallible that all kingdoms must be preserved by the means by which they were first gained, and the **Irish** especially being by their nature pliable to a hard hand, and jadish when upon the least pricking of provender the bridle is let loose upon them): therefore it was thought fit that the **Irish** should not only bear no arms in the pay of the state (which should ever be committed to the hands of most faithful subjects), but should also have all private arms taken from them till by Parliament it might be agreed what use of swords or pieces were fit to be granted some men by privilege for grace and ornament, or for necessary use as for fowling and like uses. And howsoever this disarming of the **Irish** could not well be done during the rebellion, when the Council of **England** commanded it, because the submitted **Irish** should thereby have been left a prey to the spoiling of those that were still in rebellion, yet nothing seemed more fit and easy to be done when the rebellion was fully appeased, and our conquering army hovered like falcons over the heads of any that should dare to resist. And likewise that law of reformation should be enacted by Parliament if either the **Irish** would consent or could be overtopped by the voices of the new colonies and bishops, or otherwise should be imposed by absolute power, as no doubt the King of **Spain** would do upon any his subjects in like case, to whose subjection the **Irish** seemed then strongly affected. Fourthly, for the last alleged reason, his lordship purposed to procure that the English army should be continued in some strength till religion were reformed, whereof I shall treat in the last chapter of the next book, and till the King's revenues, customs and tributes were established, whereof something must here be added.


Of old the customs of exported or imported merchandise were very small, the people having few commodities to export, and desiring not to have more imported than wines and such things for necessity, upon which things the ancient





---

p.301




kings imposed small or no customs, in regard the conquered **Irish** were basely poor, and content with any apparel, yet with nakedness, and with milk and butter for food, and for that it was fit the **English-Irish** should have immunity from such burthens, thereby to draw more inhabitants into that kingdom. For which reason also the tolls within land and the rents of the King's lands of inheritance were of small value, and both they and the customs, yea the very fines of penal statutes were for rewards of service given, or let upon a small rent to the **English-Irish** cities, and lords of countries. In the last rebellion the whole revenues of the kingdom, amounting to some thirty thousand pounds yearly, were so far from defraying the charge of the army as it cost the state of **England** one year with another, all reckonings cost up, between two and three hundred thousand pounds yearly above the revenue. And the rebellion being appeased, when the army was reduced to 1,200 foot, and some 400 horse, yet the charge of these small forces, and the stipends of magistrates and judges, exceeded the revenues some forty-five thousand pounds yearly. But due courses being taken in this time of peace, it was thought the revenues might be much increased, than which nothing was more necessary. The Irish cows are so stubborn, as many times they will not be milked but by some one woman, when, how, and by whom they list. If their calves be taken from them, or they otherwise grow stubborn, the skins of the calves stuffed with straw must be set by them to smell on, and many fooleries done to please them, or else they will yield no milk. And the inhabitants of that time were no less forward in their obedience to the state than their beasts were to them. But I would gladly know from them by what right they challenge more privilege than **England** hath, why they should not bear the same tributes and subsidies that **England** beareth, and why so rich a kingdom should be so great a burthen to the state of **England**, and not rather yield profit above the charge thereof. One lord of the county of **Carbery**[46](javascript:footNote('T100072/note046.html')) being in rebellion maintained one thousand





---

p.302




rebels against the state, who after becoming a subject was hardly drawn to serve the state with thirty foot at the invasion of the **Spaniards**, and yet thought he deserved thanks and reward for that poor supply. I cannot wonder enough, how the lords of **Ireland** can be so kind in their own affections as having maintained some 15,000 men in rebellion, they should think much in time of peace to pay the stipends of magistrates and judges, and to maintain the small remnant of the English army, being some 1,200 foot and under 500 horse. Of old after the first conquest, when **Ulster** was obedient to the state, that province alone paid 30,000 marks yearly into the Exchequer, and besides (as many relations witness) maintained some thousands of foot for the state service, yielding also timber to build the King's ships, and other helps of great importance to the state. No doubt **Ireland**, after the rebellion appeased, was in short time like to be more rich, and happy in all abundance, than ever it had been, if the subjects would delight in the arts of peace; and the fertility of **Ireland** yieldeth not to **England** if it had as many and as industrious inhabitants. In summer it hath less heat than **England**, which, proceeding from the reflection of the sun upon the earth, is abated by the frequent bogs and lakes (which, together with raw or little roasted meats, cause the country diseases of fluxes and agues fatal to the English), but this defect might be helped by the industry of husbandmen draining the grounds, and may hinder the ripening of some fruits, but no way hurts the corn, though perhaps it may cause a later harvest than **England** hath. Again in winter, by the humidity of sea and land, **Ireland** is less subject to cold than **England**, so as the pastures are green, and the gardens full of rosemary, laurel and sweet herbs, which the cold of **England** often destroyeth. It passeth **England** in rivers and frequent lakes abounding with fish, whereof one lake [river] called the **Bande** [Bann] yieldeth 500£ yearly rent by fishing. The havens from **Galway** to **Calebeg** [Killybegs], a third part of the kingdom, are fourteen in number, whereof some will receive two hundred, some three hundred, some four hundred





---

p.303




great ships, and only two or three of them are barred and shallow, and all these with the other harbours, creeks, and seas on all sides of **Ireland** abound with plenty of excellent fish, if the inhabitants were industrious to get them for food and traffic.


For the increasing of the King's customs in time by insensible degrees, it was thought the **Irish** were not likely to repine much thereat, since that burthen grieveth none that are content with native commodities, and affect not foreign luxuries, but they have been little used to taxes and tributes upon their land, and have ever kicked at the least burthen in that kind for the service of the state, only bearing it cheerfully for their own ends, as to support the Popish religion, and to maintain agents in **England**, to plead for that and other clamorous grievances. Howsoever the question is not how willingly they will yield profit to the King, but how it may be most commodiously raised. To which purpose in regard the wealth of **Ireland** consists especially in cattle and victuals, and wanted nothing more than money, the best relations of the Irish estate in those times of the rebellion appeased, though not so fit to raise it by new compositions of all countries, and increasing the old, as by making **Ireland** only to bear the charge of the magistrates' and judges' stipends, and moreover (as it were) a nursery for some competent English forces, extracting old soldiers from thence upon occasion of service, and sending new men to be trained up in their place. This done, whereas foreign enemies heretofore thought **Ireland** the weakest place wherein **England** might be annoyed, henceforward, they would rather dare to invade **England** than **Ireland** thus armed. And the rents by compositions would be a trifle in respect of this profit of cessing soldiers. By cessing[47](javascript:footNote('T100072/note047.html')) I mean the allotting of certain numbers to each city and shire to be maintained by them, who would be as so many spies to observe their parlies and conspiracies, and as garrisons in towns to keep them in awe, whither they might be sent in





---

p.304




greater or less numbers as the public service required. Provided always that this cessing should be to the King's profit only, not (as it was in the last rebellion) for the captain's profit, who took all the profit thereof without taking a penny less pay from the state, or making any satisfaction to the subjects, though they had their hands to charge them. As this cessing was thought to be most profitable to the state (easing it of the army's charge, especially for victuals, whereof the public stores could never be replenished but with far greater expense than any compositions were like to yield), so was this kind of charge most easy for the **Irish** abounding in victuals. Provided that the soldiers were restrained from extorting by violence more than should be due to them, and the due provision were gathered by orderly course. For prevention whereof, and for the soldiers' safety, they should not lie scattered in the country, but together in garrisons, yet not leaving it in the power of the **Irish** to starve them, but they fetching in victuals aforehand, if according to order it were not brought to them. Provided also, that the soldiers travelling for any service should in like sort be restrained from extortions. When the rebellion was ended, and the English army in strength, this course was thought easy to be settled, and if at any time after the state should think fitter to receive yearly rents it was not doubted but this course for a time would after make the people glad to raise their compositions so as the cessing might be taken away. And by this practice we see that **France** hath of late raised great tributes, increasing them upon new burthens of war, and so making the most seditious to abhor troubles, and love peace.


Then it was projected that commissioners should be sent over out of **England**, to view such lands, for which small or no rent had long been paid to the King, upon false pretence that they lay waste. To raise the rents of those undertakers in **Munster**, to whom the Queen having granted to some three thousand, to some more, acres of good land for small rent, or they having bought it at second-hand





---

p.305




at so easy a price, as some of them raised as much profit in one year as paid the purchase, and they having broken all their covenants with the Queen, not peopling the land with English tenants, nor having English servants, but using the **Irish** for both, as serving upon base conditions, and not building their castles, but suffering the old castles to go to ruin, and so in the rebellion being betrayed by their own Irish men, and having no **English** to serve the state, or keep their own possessions, were forced upon the first tumults to quit their lands, or charge the Queen with warders to keep their castles, for which causes, if their estates were not taken from them upon breach of covenants, yet at least they deserved to be charged with greater rents. To tie them strictly to be observing hereafter of all covenants, for the public good, upon pain to forfeit their grants. To dispose for the King's best profit all concealed lands given to superstitious uses, which were thought of great value. To dispose of spiritual lands and livings by custody to the King's profit, for a time till a learned clergy might be settled. To rate the cessing of soldiers in **Ulster**, where it was thought the people would willingly bear any reasonable burthen, so they might be freed from the great lords' tyranny. To do the like in other parts of the kingdom, at least for a time, since if after yearly rents were thought more commodious the people would more willingly raise the compositions to be freed from this cessing, and maintaining of garrisons. Lastly, to raise the customs by degrees, and to consider what privileges of cities, or of private men, for that present deserving little of the state, were fit to be cut off, or restrained.


By these means it was thought no difficult thing in few years highly to raise the King's revenues, and to reform in some good measure the civil and ecclesiastical policy. Provided that these commissioners, being of the best sort for nobility and experience, were after the first reformation continued still in that employment, and sent over once in five years, or like space of time, to visit that kingdom, especially for administration of justice, yet by the way (with arts of peace, and by degrees) for settling and increasing the





---

p.306




King's revenues, which we see daily and wisely to have been done in **England**. Thus the **Irish**, bearing common and equal burthen with the English, should have no just cause to complain, and finding rebellions to increase their burthens would be taught to love peace; the **English** should be eased from bearing the wonted burthen of their seditions; the King should have means in **Ireland** to reward his magistrates and servants in that kingdom. And it was hoped such treasure might in time be drawn out of **Ireland** as might in some measure repay the great expenses **England** hath heretofore disbursed to keep **Ireland** in peace, without raising any least profit from a conquered kingdom.


To conclude, as I have taken the boldness plainly and truly to give some light of the doubtful state of **Ireland** about the time of the last rebellion, so methinks no Irish or **English-Irish** of these times should take offence at any things I have written if they be clear from the ill affections wherewith those times were polluted (I mean in general, since I have not concealed that some of them deserved well in those worst times). And for all other men I trust that in their love to truth and for the use may be made of this plain narration in future times, they will pardon any rudeness of style or errors of judgment which I may have incurred. God is my witness that I envy not to the **English-Irish** any wealth, liberty, or prerogative they may justly challenge, nor yet to the mere **Irish** a gentle and moderate government, so the **English-Irish** had the noble and faithful hearts of their progenitors towards the Kings of **England**, or that leniency would make the **Irish** more obedient, which heretofore hath rather puffed them with pride and wanton frowardness. But as they were both in those times very disobedient (if not malicious) to the State of **England**, I have been bold to say that things so standing, **England** ought to use power where reason availeth not. Nothing is so proper as to rule by force whom force hath subjected. To keep the **Irish** in obedience by arms who were first conquered by arms, and to use the like bridle towards the **English-Irish**, who degenerating became partners in their





---

p.307




rebellions. To impose laws on them by authority for the public good, whom reason cannot persuade to make them by consent for their own good. To reform the old colonies deformed by their own faults, and to establish them by planting new. And to take the sword out of madmen's hands, for such are they that use arms against those that armed them. All subjects must be kept in duty by love or fear; love were better towards both, and especially the **English-Irish**; but the mere **Irish** are more pliable to fear, and such of the other as by habit have gotten their barbarous affections must be manacled in the same chain with them. Reformation is necessary; neither of them admits any. We must reform, and that will gall them, and their pride in those times was likely to make them kick. It remained that, by constant counsel and all honest means, we should take from such subjects all power to wreak their malice. For to use remedies sufficient to provoke them to anger, and to withhold those that might suppress their fury, were great folly. In a word, nothing is more dangerous than middle counsels, which **England** of old too much practised in **Ireland**. To what purpose are good laws made, if the people cannot be led or forced to obedience? A man in those days might more easily lead bears and lions than the **Irish**. If **Orpheus** himself could not make those stones and trees dance after his harp, then **Hercules** and **Theseus** must make them follow their clubs. The marshals must make them feel punishment whom philosophers and lawgivers find without all feeling of their public good. Let any man who hath been served with Irish footmen in sober sadness tell me the truth, if he have not always found them most obedient (by general experience) under a hard hand, but stubborn and froward towards their masters as soon as they are well clothed and set on horseback, for they are all in their opinion and they all will be gentlemen, which poverty made them forget. This properly belongs to the mere **Irish**, but such of the **English-Irish** as are become of that nature must be content to be joined with them, till they return to English manners and affections. Some of our old governors wisely observed





---

p.308






this nature of the **Irish**, and practised the right course to bridle it, proclaiming their commands at the point of the sword. Such was the **Lord Gray**, in the late Queen's reign **Lord Deputy** of **Ireland**, who knew best of all his predecessors to bridle their fierce and clamorous nation.[48](javascript:footNote('T100072/note048.html')) Such was **Sir Richard Bingham**,[49](javascript:footNote('T100072/note049.html')) though only a subordinate governor of the province of **Connaught**, who with a handful of soldiers, and a heavy hand of justice, taught us what reformation might be wrought this way if it were constantly and sincerely followed. But I know not upon what grounds of policy the counsellors of our state in those days did not approve their actions. For the complaints of the subdued **Irish** (which no nation can more skilfully frame to gain, or at least tie, their judges, they being always clamorous, but in adversity as abject suppliants as proud enemies in prosperity)—I say their complaints found such pity in the royal (may I with leave say womanly?) breast of the late famous Queen, and such favour with the lords of her council (perhaps desiring the present, rather than durable peace of that kingdom), as these late rebels were sent back comforted for their losses with fair promises; and the magistrates, recalled into **England**, reaped heavy reproof for their merited reward. So as their successors, either terrified by that ill success or ambitious to gain the hearts of the Irish (at which the counsels of the next Deputy seemed to aim), or upon vain hope to reduce that nation to obedience by leniency, did in all judicial causes so much respect the Irish, as to that end they spared not to lay unequal burthens sometimes on the **English**. Thus new magistrates bringing new laws and counsels wrought that confusion which they sought to avoid. For one Deputy was sharp and severe, another affable and gentle, whereas in all good governments, howsoever the magistrates are changed, the face of justice should





---

p.309




constantly remain one and the same. And what prejudice to the commonwealth this course hath of old wrought in **Ireland** particularly experience hath made manifest. God grant that hereafter we may at least (according to the Latin proverb) grow wise with the wounded fisherman, and as in the last rebellion we were good Epimethei, to discern (by the sense of ill accidents) the true causes thereof, so hereafter we may become provident Promethei, in diverting foreknown dangers, before they fall heavily upon us.














