

#Sir Francis Bacon's MSS relating to Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Sir Francis Bacon's MSS relating to Ireland
===========================================


Author: Francis Bacon
---------------------


### File Description

Proof corrections by Janet Crawford, Beatrix Färber 

Introduction by Hiram Morgan

Funded by University College, Cork, School of History and  
The HEA under PRTLI4 3. Third draft, enlarged and revised.Extent of text: 42267 words#### Publication


CELT: Corpus of Electronic Texts: a project of the History Department, University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2011) (2019) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E600001-015Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


Research on this collection of documents was assisted by monies from the Programme for Research in Third-Level Institutions, Cycle 4.


#### Sources


**MS sources**2. Hatfield, Cecil Papers, Ms 65 no. 35 (Document 6); Ms 67, no. 19 (Document 7).
3. Lambeth Palace, (Carew Papers) MS 619, pp. 288–9 (Document 30).
4. London, UK National Archives, Kew, SP63/232, no. 19 (Documents 21, 31).
5. London, UK National Archives, Kew, SP63/234, 6A (Document 33).
6. New York, The Pierpont Morgan Library, MA 1160 (Collections of charges and speeches by Francis Bacon), no. 13, ff.161–71 (Document 19).
7. Oxford, Bodleian Library, Carte MS 61 p. 64 (Document 24).
**Literature**2. Thomas Smith, A Letter sent by I. B. gentleman (London 1572).
3. Richard Beacon, Solon his follie (Oxford 1594).
4. [Francis Bacon], A declaration of the Practices and Treasons attempted and committed by Robert late Earl of Essex and his complices against Her Majesty and her kingdoms (London 1602).
5. Francis Bacon, Sir Francis Bacon, his Apologie, in certaine imputations concerning the late Earle of Essex (London 1604).
6. Thomas Blenerhasset, A direction for the plantation of Ulster (London 1610).
7. Fynes Moryson, An Itinerary (London 1617).
8. Edwin A. Abbot, Francis Bacon: An account of His Life and Works (London, 1885).
9. Hiram Morgan, 'Francis Bacon and policy-making in Ireland under Elizabeth and James', Proceedings of the Royal Irish Academy, Vol 119C, 1–25 .
10. Richard Serjeantson, 'Francis Bacon, colonisation and the limits of Atlanticism', Nature, politics, and the imagination in the thought of Francis Bacon (1561–1626) (Berkeley, CA, 2014), available online at https://docplayer.net/65319781-Francis-bacon-colonisation-and-the-limits-of-atlanticism.html.
**Secondary literature (a selection)**2. T. W. Moody, The Londonderry Plantation, 1609–1641, (Belfast 1939).
3. D. B. Quinn, 'Sir Thomas Smith (1513–77) and beginnings of English colonial theory', Proceedings of American Philosophical Society 1945, 543–60.
4. J. M. Jones, Mountjoy: the Last Elizabethan Deputy, 1563–1606, (Dublin 1958).
5. Philip Robinson, The Plantation of Ulster, (Dublin 1984).
6. Raymond Gillespie, Colonial Ulster: the settlement of East Ulster, 1600–1641 (Cork 1985).
7. Hiram Morgan, 'The colonial venture of Sir Thomas Smith in Ulster, 1571–75', Historical Journal 28 (1985) 261–78.
8. Hans S. Pawlisch, Sir John Davies and the Conquest of Ireland: A Study in Legal Imperialism (Cambridge 1985).
9. Michael MacCarthy-Morrogh, The Munster Plantation (Oxford 1986).
10. Micheal Percival-Maxwell, Scottish migration to Ulster in the reign of James I (London 1990).
11. Raymond Gillespie, 'Documents and sources: plantation and profit: Richard Spert's tract on Ireland, 1608', Irish Economic and Social History 20 (1993) 62–71.
12. Willy Maley, 'Another Britain'?: Bacon's certain considerations touching the plantation in Ireland (1609), Prose Studies: History, Theory, Criticism, 18/1 (1995) 1–18.
13. Robert J. Hunter, 'Plantation in Donegal', In: William Nolan, Liam Ronayne, Mairead Dunlevy (eds.), Donegal: history & society. Interdisciplinary essays on the history of an Irish county, (Dublin 1995) 283–324.
14. Victor Treadwell, Buckingham and Ireland, 1616–1628 (Dublin 1998).
15. John McCavitt, Sir Arthur Chichester, Lord Deputy of Ireland, 1605–16 (Belfast 1998).
16. Brendan Bradshaw, and Peter Roberts (eds.), British Consciousness and Identity: The Making of Britain, 1533–1707. Cambridge: Cambridge University Press 1998.
17. John Andrews, 'Plantation Ireland: a review of settlement history'. In: Terence B. Barry (ed.), A history of settlement in Ireland (London 1999) 140–157.
18. James Stevens Curl, The Honourable the Irish Society and the plantation of Ulster, 1608–2000: the City of London and the colonisation of County Londonderry in the province of Ulster in Ireland, a history and critique. (Chichester 2000).
19. Nicholas P. Canny, Making Ireland British, 1580–1650. (Oxford 2001).
20. Toby Christopher Barnard, 'The Making of Great Britain and Ireland', In: Barry Coward (ed.), A companion to Stuart Britain (Blackwell Companions to British History) (Oxford 2003) 26–44.
21. Raymond Gillespie, 'Planned migration to Ireland in the seventeenth century', In: Patrick J. Duffy, Gerard Moran (eds.), To and from Ireland: planned migration schemes c.1600–2000 (Dublin 2004) 39–56.
22. Hiram Morgan, The Battle of Kinsale (Bray 2004).
23. Patrick Fitzgerald, 'Scottish migration to Ireland in the seventeenth century'. In: Alexia Grosjean, Steve Murdoch (eds.), Scottish communities abroad in the early modern period (Studies in medieval and Reformation traditions 107) (Leiden 2005) 27–52.
24. David Edwards. 'A haven of popery: English Catholic migration to Ireland in the age of plantations', In: Alan Ford; John McCafferty (eds.), The origins of sectarianism in early modern Ireland (Cambridge 2005) 95–126.
25. Jon Crawford, A Star Chamber court in Ireland: the Court of Castle Chamber, 1571–1641, (Dublin 2005) 305–6.
26. Hiram Morgan, 'Francis Bacon and policy-making in Ireland under Elizabeth and James', Proceedings of the Royal Irish Academy, Sect. C, forthcoming 2019.
**Francis Bacon's Life and Work (a selection)**2. Arthur Rowland Skemp, Francis Bacon, T. C. & E. C. Jack. (London 1912).
3. A. W. Green, Sir Francis Bacon, his life and works. (Syracuse, New York 1948).
4. Benjamin Farrington, Philosophy of Francis Bacon. (Chicago: University of Chicago Press 1967).
5. F. J. Levy, Tudor historical thought. (Toronto: University of Toronto Press 1967).
6. Paolo Rossi, Francis Bacon: From Magic to Science, translated by Sacha Rabinovitch. (Chicago: University of Chicago Press 1968).
7. Albert Joseph Loomie, 'Bacon and Gondomar: an unknown link in 1618', Renaissance Quarterly 21 (1968) 1–10.
8. Lisa Jardine, Francis Bacon: the Discovery and Art of Discourse (Cambridge 1974).
9. Jan Van Dorsten, 'Literary patronage in Elizabethan England: the early phase', In: G. F. Lytle; Stephen Orgel, (eds.), Patronage in the Renaissance (Folger Institute essays) (Princeton, New Jersey: Princeton University Press 1981) 191–206.
10. Ian Box, 'Bacon's Essays: from political science to political prudence'. History of Political Thought 3:1 (1982) 31–49.
11. Clark Hulse, 'Spenser, Bacon, and the myth of power', In: H. Dubrow; R. Strier (eds.), The Historical Renaissance: new essays on Tudor and Stuart literature and culture. (Chicago, Illinois 1988) 315–346.
12. Julian Martin, Francis Bacon, the state, and the reform of natural philosophy. (Cambridge 1992).
13. Jürgen Klein (ed.), State, science and modernization in England: from the Renaissance to the present time (Herborn symposium 1990), (Alstediana–Forschungen zur Mentalitäts- und Wissenschaftsgeschichte der Frühen Neuzeit 1). (Hildesheim: Olms 1994).
14. Markku Peltonen, (ed.). The Cambridge companion to Bacon. (Cambridge: Cambridge University Press 1996).
15. Perez Zagorin, Francis Bacon. (Princeton, New Jersey: Princeton University Press 1998).
16. Lisa Jardine, Alan Stewart, Hostage to fortune: the troubled life of Francis Bacon, 1561–1626. (London: Gollancz 1998).
17. Stephen Gaukroger, Francis Bacon and the transformation of early-modern philosophy. (Cambridge: Cambridge University Press 2001).
18. David Burnett, A thinker for all seasons: Sir Francis Bacon and his significance today. (Durham: New Century 2000).
19. Kenneth Cardwell, 'An Overlooked Tract by Francis Bacon', Huntington Library Quarterly, 65:3:4 (2002).
20. Joseph M. Levine, 'Intellectual History as History', Journal of the History of Ideas, 66:2 (2005) 189–200.
21. William A. Sessions, 'Bacon's Spenser', In: Ton Hoenselaars; Arthur F. Kinney (eds.), Challenging humanism: essays in honor of Dominic Baker-Smith (Newark: University of Delaware Press 2005) 209–228.
22. Sarah Irving, 'In a pure soil': Colonial anxieties in the work of Francis Bacon, History of European Ideas, 32:3 (2006) 249–262.
23. Julie Robin Solomon; Catherine Gimelli Martin (eds.), Francis Bacon and the refiguring of early modern thought (Literary and scientific cultures of early modernity). (Aldershot: Ashgate 2006).
24. Stephen A. McKnight, The religious foundations of Francis Bacon's thought. (Columbia, Missouri: University of Missouri Press 2006).
25. Todd Wayne Butler, Imagination and politics in seventeenth-century England; (Aldershot: Ashgate 2008).
26. Correspondence of Francis Bacon project, directed by Alan Stewart (see http://www.livesandletters.ac.uk/projects/correspondence-francis-bacon).
27. Another Internet resource is: http://www.luminarium.org/sevenlit/bacon/
**The editions used in the digital edition**2. **Basil Montagu**, The speech used by Sir Francis Bacon, Lord Keeper of the Great Seal of England, to Sir William Jones, upon his calling to be Lord Chief Justice of Ireland, 1617 in The Works of Francis Bacon, Lord Chancellor of England. A new edition. , London, William Pickering (1825–1834: 1825) volume 2 of 16 page 476–477
3. **Basil Montagu**, Letter of Francis Bacon to George Villiers, Marquis of Buckingham, 27 July 1618 in The Works of Francis Bacon, Lord Chancellor of England. A new edition. , London, William Pickering (1825-1834) volume 3 of 16 page 83
4. **Basil Montagu**, Considerations touching the Queen's Service in Ireland, Certain considerations touching the Plantation in Ireland in The Works of Francis Bacon, Lord Chancellor of England. A new edition. , London, William Pickering (1825-1834: 1826) volume 5 of 16 page 169–185; 187–196
5. **Basil Montagu**, The proceedings of the Earl of Essex in The Works of Francis Bacon, Lord Chancellor of England. A new edition. , London, William Pickering (1825–1834: 1826) volume 6 of 16 page 277–298
6. **Basil Montagu**, Francis Bacon to Sir Robert Cecil, Letter of Sir Francis Bacon to the Earl of Essex, Letter of Sir Francis Bacon to the Earl of Essex, Letter from Francis Bacon to the Earl of Essex, Letter of Francis Bacon to the Earl of Essex, Letter of Sir Francis Bacon to Sir Robert Cecil, Letter of Sir Francis Bacon to King James, New Year 1609, Letter from Francis Bacon to Mr. Pierce, Secretary to the Deputy of Ireland, Letter of Francis Bacon to William Jones, Lord Chief Justice of Ireland, April 1618, Letter of Francis Bacon to George Villiers, The Marquis of Buckingham, 12 November 1618 in The Works of Francis Bacon, Lord Chancellor of England. A new edition. , London, William Pickering (1825–1834: 1830) volume 12 of 16 page 15–23; 27–28; 73; 117; 156; 165; 352; 360
7. **Basil Montagu**, The speech used by Sir Francis Bacon, Lord Keeper of the Great Seal of England, to Sir William Jones, upon his calling to be Lord Chief Justice of Ireland, 1617 in The Works of Francis Bacon, Lord Chancellor of England. A new edition: with a Life of the author. , Philadelphia, A. Hart, late Carey & Hart (1850) volume 2 of 3 page 476–477
8. **James Spedding**, Letter of Francis Bacon to Anthony Bacon, 26 August 1594, Letter of Francis Bacon to Sir Francis Allen, 20 December 1598 in The letters and Life of Francis Bacon: including all his occasional works, namely letters, speeches, tracts, state papers, memorials, devices, and all authentic writings not already printed among his philosophical literary or professional works. , London, Longman, Green, Longman, and Roberts (1861–74) volume 1 of 15 page 264–265; 314–15
9. **James Spedding**, Letter of Francis Bacon to Sir John Davies, Attorney General in Ireland, 23 October 1607, Letter of Francis Bacon to King James, 13 August 1613 in The letters and Life of Francis Bacon: including all his occasional works, namely letters, speeches, tracts, state papers, memorials, devices, and all authentic writings not already printed among his philosophical literary or professional works. , London, Longman, Green, Longman, and Roberts (1861–74) volume 4 of 15 page 5–6; 386–387
10. **James Spedding**, Letter of Francis Bacon to King James, *?Feb1614*, Letter of Francis Bacon to King James, 5 June 1616, Letter of Francis Bacon to Sir George Villiers, 1 July 1616, Letter of Francis Bacon to Sir George Villiers, 2 July 1616 in The letters and Life of Francis Bacon: including all his occasional works, namely letters, speeches, tracts, state papers, memorials, devices, and all authentic writings not already printed among his philosophical literary or professional works. , London, Longman, Green, Longman, and Roberts (1861–74) volume 5 of 15 page 1–2; 355–6; 375; 377
11. **James Spedding**, Mr Attorney's certificate touching the Patent for slitting Iron Bars, 27 January 1616, Privy Council to Lord Deputy of Ireland, 16 March 1617, Letter of Francis Bacon to George Villiers, Marquis of Buckingham, 25 May 1617 in The letters and Life of Francis Bacon: including all his occasional works, namely letters, speeches, tracts, state papers, memorials, devices, and all authentic writings not already printed among his philosophical literary or professional works. , London, Longman, Green, Longman, and Roberts (1861–74) volume 6 of 15 page 135; 154–156; 207–208
12. **C.W. Russell and John P. Prendergast**, A direction or advice unto her Majesty's Attorney-General of Ireland, touching certain doubts in law, which may arise in the proceeding against the recusant corporations in Ireland,  Letter of Francis Bacon to Sir John Davies, Attorney-General of Ireland, 26 December 1606 in Calendar of State Papers, Ireland, 1606-08. , London, Longman & Co. (1877) volume 14page civ–cv; 47

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Editorial Declaration


##### Correction


Text has been proof-read once and parsed.


##### Normalization


The electronic text represents the edited text. The spelling has been normalised silently. Words and phrases in languages other than English are tagged.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div1=the document. The page-breaks referred to at the beginning of each document are those of the printed editions used.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Dates are not tagged.


#### Canonical References


This text uses the DIV1 element to represent the Document. ### Profile Description


Created: by Francis Bacon
 Date range: 1598–1618.#### Use of language


##### Language: [EN] The text is in early seventeenth-century English. Spelling has been normalised in Montagu's edition.


##### Language: [LA] Some phrases are in Latin.


##### Language: [IT] Some words are in Italian.


##### Language: [FR] Some words are in French.


##### Language: [GA] One word is in Irish, in anglicised spelling.


##### Language: [ES] A phrase is in Spanish.


### Revision History


* (2019-03-25) Beatrix Färber (ed.)

* New word count made; file re-parsed; new SGML and HTML files created.
* (2019-03-25) Hiram Morgan (ed.)

* Additions and modifications made to bibliography and file.
* (2019-03-21) Beatrix Färber (ed.)

* Encoding and TEI Header modified; file re-parsed; new SGML and HTML files created.
* (2019-03) Hiram Morgan (ed.)

* Introduction and bibliographical items modified.
* (2013-09-03) Beatrix Färber (ed.)

* Minor changes made to encoding; file re-parsed; new SGML and HTML files created.
* (2011-02-01) Beatrix Färber (ed.)

* Corrections and additions integrated; header modified; file re-parsed; new SGML and HTML files created.
* (2011-02-01) Hiram Morgan (ed.)

* Whole file proofed (2); corrections and additions made.
* (2011-01-17) Beatrix Färber (ed.)

* Edition details added to header; new SGML and HTML files created.
* (2011-01-10) Beatrix Färber (ed.)

* Header updated accordingly; enlarged & modernised edition converted to XML; all structural and content markup applied, file parsed; new wordcount made.
* (2010-12-20) Hiram Morgan (ed.)

* New prefatory note and enlarged & modernised edition (Word document) with additional bibliographical items supplied.
* (2010-04-24) Beatrix Färber (ed.)

* Header updated; file parsed, new SGML and HTML files created.
* (2010-02-12) Hiram Morgan (ed.)

* Additions to bibliography and minor changes to prefatory note made.
* (2009-08-04) Beatrix Färber (ed.)

* Header finished; file parsed. SGML and HTML versions created.
* (2009-07-23) Beatrix Färber (ed.)

* New header created; more letters and a speech added and encoded. New file structure created.
* (2009-07-20) Hiram Morgan (ed.)

* Introduction supplied; additions to bibliography supplied; dates to the letters supplied where indicated.
* (2009-06-06) Beatrix Färber (ed.)

* Header created; structural markup applied; file parsed.
* (2009-04-06) Beatrix Färber (ed.)

* Bibliography compiled.
* (2009-04) Janet Crawford, Tipperary (ed.)

* Text proofed (1).
* (2009-04-02) Beatrix Färber (ed.)

* Text captured; page breaks inserted.




---


#### Corpus of Electronic Texts Edition: E600001-015


### Sir Francis Bacon's MSS relating to Ireland: Author: Francis Bacon


### Bacon's MSS relating to Ireland: Prefatory note


Sir Francis Bacon (1561–1626), the English scientist, jurist and politician, had a lot to say about Elizabethan and Jacobean policy in Ireland and had a significant impact upon it. This online edition includes the bulk of his extant manuscript material relating to Ireland. Much of this has appeared before — skittered throughout Bacon's Works and his Letters and Life in the early nineteenth century and the Calendar of State Papers Ireland in the early twentieth century. It is concentrated here in one block in modernised spelling and punctuation and is organised in chronological order so that the development of his interest can be easily tracked. This edition, which incorporates a couple of newly-identified pieces of Bacon, has different types of document — position papers with their covering letters, one recorded speech, various business letters, two reports, two court prosecutions and five legal opinions.


The most famous Bacon text relating to Ireland is his tract Certain Considerations touching the Plantation in Ireland presented to James I at the start of 1609 when plans were being evolved for the colonisation of Ulster. However he had already given other pieces of advice or counsel to the Earl of Essex and Robert Cecil (later the earl of Salisbury), and was to do so afterwards to George Villiers (later the duke of Buckingham) and to George Jones, the newly-appointed Chief Justice of Ireland. The advice given to Essex and Cecil was in a private capacity and relates to the completion of the Elizabethan conquest of Ireland. The advice given to King James, Villiers and Jones was proffered when Bacon held office in England first as solicitor-general, then becoming eventually Lord Chancellor and relates to the post-war consolidation of English rule in Ireland. This advice on contemporary policy and high politics was not meant for public view and was not published in his lifetime. When these documents were eventually published, some of them were wrongly dated, and hence were often out of their proper context, usually because their covering letters had been omitted.


Bacon first appeared as an advisor to the Earl of Essex discussing, amongst other things in the 1590s, the war in Ireland. It is interesting how Bacon's letters — serious Tacitean missives laced with Latin tags — are similar to Essex's own. The first on Ireland was written when Mr Secretary Robert Cecil went off on embassy to France in the spring of 1598. Bacon told Essex that involvement in the Irish Question was a way to ‘purchase honour’ on three grounds — that it would rekindle the Devereux role there begun by his father, that it was the single biggest and most time-consuming issue then in train and that putting ‘it in frame’ would be a demonstrable contrast with the actions of those who put it out of frame. Essex, he reckoned, would gain honour simply by being seen to have the right people employed there and he should start by consulting those in England with experience of office or martial affairs in Ireland. A second letter soon after shows that Essex was indeed taking a closer interest in Irish affairs and it indicates that he had asked the advice of this ‘ignorant statesman’ on the ongoing talks with the Earl of Tyrone. Bacon was willing to give Tyrone the benefit of the doubt but wanted soldiers ready in England if a peace could not be secured. It is plain that Bacon preferred the peace option in Ireland so as to eliminate the threat of Spanish intervention, to win over wayward subjects there by just measures and to eventually divide and disunite the Irish confederates. To attain this Bacon was in favour of sending over a reform commission ‘of peaceable men chiefly of respect and countenance’. However if Tyrone proved to be dissembling and the peace deal collapsed, a full re-conquest had to be determined upon and Essex himself should be ready to take up the charge. One way or other Bacon saw Ireland as a way of Essex winning ‘a great deal of honour gratis’!


There is another Bacon epistle in early 1599, an exhortatory one, when Essex did eventually accept the office of Lord Lieutenant of Ireland — ‘a service of great merit and great peril’. It reflected the doubts Essex had himself about the task ahead and his worries about the backbiting and intrigue against him at court in his absence. Once again honour is at stake — ‘you go upon the greater peril of your fortune, and the less of your reputation; and so the honour countervaileth the adventure; of which honour your lordship is in no small possession’. In these circumstances Bacon advises a positive approach; that Essex can win glory where others have failed and that it is a noble enterprise to recover subjects to their allegiance. Indeed he asserts that the greatest triumphs of the Romans, were wars against rebels and conquests of savages such as the Germans and Britons. Success in Ireland would be not just transient and enriching victories such as Essex had already won against Spain — like capturing ‘some rich carrack’ — but a more permanent and worthwhile achievement. In Ireland Essex would be engaged in a civilising mission ‘to replant and refound the policy of that nation, to which nothing is wanting but a just and civil government’. Bacon suggests that in the winning of honour, merit is better than fame, discipline better than adventure and a mix of war and diplomacy better than sheer force. Most interestingly — prophetically as to what would subsequently take place — Bacon urged Essex to proceed as a good Protestant by following instructions, because exceeding their limits might prove ‘a dangerous disavow’. However Bacon admits in signing off that he is no expert in these matters. That his authority is largely academic, writing as he does ‘in methodo ignorantiae, which is when a man speaketh of any subject not according to the parts of matter, but according to the model of his own knowledge.’


In the summer of 1602 we find Bacon writing a far longer piece of advice on Ireland — indeed one of the most conciliatory English documents on Ireland in the whole Tudor period. With Bacon having of course turned against his former patron, this document was now directed to Robert Cecil. Bacon urges Cecil to seize the opportunity of the recent English successes against Tyrone to take in hand the cause of Ireland. According to Bacon, if Cecil pursues a timely peace in Ireland, he will not only increase his own honour but also the Queen's reputation. Though if Bacon, in giving this advice, had an eye to his own advancement, urging Cecil to make himself by this matter ‘as good a patriot as you are a politique’ seems a tad foolish.


Bacon's Certain Considerations touching the Queen's service in Ireland outlined four objectives — extinguishing the embers of war, recovering the hearts of the people, removing the cause of further conflict and reviving the plantations — necessary to reduce the country ‘as well to civility and justice as to obedience and justice’. The peaceable approach carried strategic and cost advantage. With Spain distracted by commitments in North Africa, the Irish could be weaned off their expectation of Spanish support and in turn the severance of these two parties — the Irish and the Spaniards — might assist the negotiation of an Anglo-Spanish treaty. In pursuing reconciliation and reconstruction in Ireland, Bacon was concerned not just to proceed politiquely but also legally — for instance he refers to the question of ius gentium in the wrapping-up of the Irish war. Here he favours the Italian approach of Banditti leaders being killed as examples rather than the extirpation of a whole people as if they are savages. He insisted that the queen ‘taketh no pleasure in effusion of blood, or displanting of ancient generations’. Though discussing similiar issues as Spenser and other contemporary treatise writers on Ireland, Bacon has important liberal aspects. He is in favour of winning over the Irish as equals under the law, welcoming them at court and even rewarding Irish nobles with lands in England as Philip II had done with Portuguese potentates in Spain when he conquered their country.


If the emergency use of martial law is as necessary, it should only be used for a time and in its implementation the military man should be twinned with a judge using summary justice in a form as close as possible to the laws of England. Bacon is even more radical when it came to religion. Breaking with over forty years of royal supremacy and ecclesiastical uniformity, Bacon is even ready to concede a limited toleration of Catholicism in Ireland after the model of the Edict of Nantes. He knows this will be an attraction for English recusants to move to Ireland but he does not see that as so bad in itself as it will aid the country's development. Anyhow this was not intended as a permanent concession but as an act of expediency to give the crown time to invest in the proper evangelisation of Ireland. In this regard Bacon has the same line as the concluding section of Spenser's View where the deployment of trained and committed preachers was demanded. Bacon also wants to re-establish the shattered plantation of Munster, but this time with a view to the interests of the state rather than its private developers by picking better undertakers and fortifying only in places designated as being strategically important. In making this proposal, Bacon taps into the war-weariness evident amongst Robert Cecil and other English leaders. This Bacon tract, because it was separated from its covering letter, has confusingly been attributed to Mountjoy and as a result some historians have considered that Lord Deputy more liberal than he actually was.[1](javascript:footNote('E600001-015/note001.html')) In fact this was Bacon at his most progressive — Mountjoy's conclusion of the war was on the contrary draconian, bloody, expensive and long-drawn out.


Bacon had an opportunity to play a more direct role in the development of policy in Ireland when in office under James I. The Flight of the Earls in 1607 followed by the Revolt of O'Doherty in 1608 at last provided the opportunity for an extensive programme of confiscation and colonisation in Ulster. In putting his ideas in ‘this little book’ to James I at New Year in 1609, Bacon was reacting to some of the early plantation proposals being made by officials in Ireland. Bacon felt assured in proffering advice of his own, as he was now in the same position of solicitor-general as Sir John Popham had been when he had taken a leading role of the 1580s plantation of Munster. Bacon is anxious to have James I play an active part in establishing and promoting the plantation in order to avoid the problems of the earlier colonial ventures in Ireland. He emphasizes how important the project will be to the king's reputation — that besides the Union of Crowns, the Ulster Plantation will be other great endeavour of his reign. The tone is extremely unctuous: ‘as in the works of God, the creation is greater than the preservation.’ Plantations were the way of founding or refounding kingdoms and this godly work would lead to the eventual prosperity and happiness of Britain's sister kingdom of Ireland. With the owners having already vacated the premises, he is able to assert that there was no extirpation involved. On this occasion there is no powerful elite requiring conciliation, merely the need to evolve a civilising mission. Here he uses the metaphor of the harp of Orpheus casting its harmonious spell over nature. ‘This therefore, of all other most memorable and honourable, your majesty hath now in hand; especially if your Majesty join the harp of David, in casting out the evil spirit of superstition, with the harp of Orpheus, in casting out desolation and barbarism’.


As well as stoking the king's ego, Bacon emphasized the strategic advantages of the project. It has civic importance in England and Scotland because by relieving those countries of surplus people it ‘may prevent many seeds of future perturbations’; in terms of military policy the plantation will finally secure this formerly troublesome province, which attracting foreign interference, was the strategic weak-spot of the British state; and overall he claimed that it would make another Britain out of Ireland by developing its potential, both human and material, for fiscal and military benefit of the state. The king's reputation and involvement was needed to animate the whole enterprise. So too were rich and committed undertakers; these should be coupled in the plantation grants with army veterans who would help provide security. It was no use giving out grants of lands in Ulster to pleasure seekers or profiteers — the undertakers had to be in it for the long haul. In this planting, honour was more important than profit. Bacon urged the rewarding of knighthoods — echoes of Essex perhaps — for those involved. He was also proposing new titles of dignity for nobles undertaking the larger grants. This suggestion is probably the origin of the title of baronet subsequently created as an honour for some of those willing to invest in the plantation. Robert Cecil had a hand in developing this idea but is surely significant Francis's half-brother Nicholas Bacon was created the first baronet in 1611.[2](javascript:footNote('E600001-015/note002.html')) To further encourage the undertakers, he suggested that the king add the moribund Earl of Ulster title to his son's Prince of Wales title.


In Bacon's view the plantation of Ulster had to be a public enterprise if it was going to work. He wanted the direct involvement of the English parliament to finance infrastructure such as bridges, roads and fortifications; in the end it would of course be the City of London providing this much needed strategic investment in the project. Reacting to preliminary proposals and indeed previous failings, Bacon was urging careful attention to the conditions the undertakers would enter into so as to ensure subsequent implementation. Furthermore aware that Ulster was in actual fact inhabited and that swordsmen and kern were a threat there, he was urging nucleated settlements not isolated outposts because that fault in ‘the last plantation of Munster, made the work of years to be but the spoil of days’. Overall — in the belief that the Irish government did not have time besides its normal duties — Bacon wanted the establishment of a resident Plantation commission to have continual bureaucratic oversight of the project. This advice given to the king by Bacon on the Ulster Plantation and its concern for reputation and state-building makes an interesting contrast with published propaganda for the same plantation, for instance Thomas Blenerhasset's A direction for the plantation in Vlster (London, 1610). It also makes a fine contrast with A letter sent by I.B. gentleman — the first printed propaganda for plantation in Ireland which had been put out by the classically-minded Sir Thomas Smith and his son in 1572. It is furthermore worth reading this private document in comparison with Bacon's general comment on plantation which he published in Essays or Counsels, Civil and Morall in 1625. The former clearly influenced the latter and though his commentary in the latter was mainly sparked by the Virginia plantation, it is plain that more similarities had appeared between the European and American ventures than he originally thought.


After the Ulster plantation was up and running, Bacon's advice on Ireland continued when he was lord chancellor. We find him advising James I's favourite George Villiers in 1616 on the legal aspects of policy towards recusant towns for Oliver St John's instructions when assuming government of Ireland. Once again Bacon was against forcing consciences — he is plainly in favour of an oath of allegiance rather than an oath of supremacy being tendered to magistrates. He also favoured legal process over government edicts in dealing with the town liberties. He was against weeding out Popery by the temporal sword; putting his hopes instead somewhat optimistically in better clergy and better education and the mostly Protestant plantations eventually overwhelming the Catholic side. For political reasons he was against reducing the size of the council in Ireland but for financial reasons he was in favour of establishing a select group of councillors who would work to improve the revenue and this eventually happened. We also have a surviving valedictory speech by Bacon as a client — Sir William Jones — prepares to leave England to take up a new post as Chief Justice of Ireland. Bacon pointed out to Jones that he will also have a political role as a member of the Irish Privy Council. In this regard Bacon reminds Jones that he will be playing his part in the king's already successful project of the developing of a kingdom which a generation ago many people had wished was sunk beneath the sea. As councillor of state Jones should pay special regard to the plantations (where he was to hold the planters to their covenants not only in the one in Ulster but also in the others now being established in Wexford, Longford and Leitrim), that he should look to the increase of the king's revenue and that he should take an interest in the care of religion. This last charge, preventing the emergence of a Counter-reformation Ireland, Bacon held the most challenging of the lot — ‘lest Ireland civil become more dangerous to us than Ireland savage’!


In spite of the different political situations and personal circumstances in which these position papers were written, there is a fair degree of continuity in the ideas Bacon put forward in relation to Ireland over this twenty year span. Bacon comes across as a moderate in terms of Irish policy. He regards Ireland as a junior kingdom in need of tutelage and improvement and not as a colony. He sees Ireland as part of Europe — he tells William Jones that Ireland is the last of the children of Europa which is being reclaimed from desolation as a sister kingdom and in advising King James on Ulster plantation he clearly sees the inhabitants of Ireland as equal subjects of a kingdom distinct from Britain. Bacon wants an obedient and prosperous Ireland achieved by the reward of its inhabitants and amelioration of their condition rather than their coercion or extirpation. Nor is he interested in forcing the Irish to become Protestants. As the Nine Years War (1594–1603) comes to a close, he is willing to advocate some form of religious toleration whilst at the same time intensifying evangelisation and when anti-recusancy action is underway in the mid-1610s he favours only exemplary action conducted by the normal judicial mechanisms. Essentially Bacon would have come across as Eudoxus, the England-based policy wonk in Spenser's famous dialogue rather than Irenius, the old Ireland hand. He is an armchair imperialist; he is not a capitalist-colonist. He is interested in honour, sometimes personal honour but mostly the reputation of the state. He is more interested in policy than profit. He is building a British state but it involves for him more European statecraft than exploitative colonialism. Note his famous reference to the Virginia colony, whilst making his proposals for the Ulster plantation, as being ‘an enterprise in my opinion differing as much from this, as Amadis de Gaul differs from Caesar's Commentaries’. His approach is academic based often on classical precepts rather than on the ruthless realism of an acquisitive man on the spot. He is a scholarly metropolitan policy-maker not a colonial subaltern.


When we move on to assess his short business letters, we can see Bacon operating first in a private and then later in a public capacity. These have two principal elements — gathering information and obtaining and giving out jobs. In his very first letter referring to Ireland we see him informing his brother about news arriving at Court relating to Maguire's revolt and the position of the earl of Tyrone. In his second letter we see he him offering to provide information to his cousin Robert Cecil in France where he is involved in international negotiations. When Bacon himself reached office, we see him demanding information from correspondents, in particular from contacts in Ireland. For instance his correspondence with Sir John Davies, the solicitor-general. In a letter of 1606, Bacon is refusing to exchange news with Davies who has imparted no occurrences there, however in the next extant letter when Bacon is in office, the Solicitor-general of Ireland is being more forthcoming. ‘I would be glad to hear often from you, and to be advertised how things pass, whereby to have some occasion to think some good thoughts; though I can do little’. In other words, such knowledge provided the raw material for Bacon's analysis of Irish affairs. As English solicitor-general, Bacon could not do much but he could when he gained experience and was later promoted to more senior and more influential posts. Bacon's role as a patron is also exhibited in these letters. As a friend and advisor of the earl of Essex, we have examples of him in 1598 using his good offices with the earl to suggest individuals, who have sought his intercession, for posts in the army going to Ireland. After Bacon attained office in England — especially when he became Lord Chancellor — we see him increasingly using his position to obtain legal posts for clients in Ireland. In 1616 and in 1617 we have letters to Buckingham where he proposes Wrytington and then Lowder for posts in the Irish judiciary. And Sir Edward Jones, the new Lord Justice of Ireland, was clearly a client of Bacon's — one who was not only being advised to carry through the policies he favoured there but also of course expected to act as an intelligencer for him.


This collection also includes two reports written by Bacon which relate to Ireland. The first is his account of the hearing into the Earl of Essex's activities in Ireland which took place at York House in June 1600. Bacon had been — as a Queen's Counsel at that time — part of the crown's prosecution of his former friend and patron and Queen Elizabeth subsequently asked him to provide an account which has come down to us in incomplete form. In this instance Essex's actions in Ireland were condemned but in a relatively benign way; however when the following year the earl was tried for an attempted coup d'état, Bacon published his case and trial as A declaration of the Practices and Treasons attempted and committed by Robert late Earl of Essex and his complices against Her Majesty and her kingdoms (London, 1601). That printed pamphlet has not been included as it deals mostly with what took place in London in the immediate run-up to Essex's attempt to seize power. Yet it had as a peroration — Essex's Lord Lieutenancy in Ireland — which was a massive misrepresentation of his government there. It was now being claimed that Essex had gone into Ireland with malice aforethought, that ‘he carried into Ireland a heart corrupted in allegiance and pregnant of those and like treasons which afterwards came to light’. This public denunciation by Bacon of his former patron not only played badly with Essex's remaining friends but also probably with the Irish, all of whom, rebels included, had high hopes of Essex. In 1604 Bacon published An apology concerning the earl of Essex in an attempt to explain and justify his behaviour. From the outset it emphasized Bacon's chief intention as being to serve the state — ‘whatsoever I did concerning that action and proceeding, was done in my duty and service to the Queen and the State; in which I would not show myself false-hearted nor faint-hearted for any man's sake living’. This motivation — often manifest in a most unctuous and fawning fashion — was always to the forefront when he eventually obtained the opportunity to serve under James.


Bacons's other significant engagement related to the gerrymandered Irish parliament of 1613. Bacon briefed himself well and came to play an important part advising the king on the subsequent commission sent into Ireland and in dealing with the Irish Catholic deputation which arrived at Court to put their grievances to James. Indeed it may be that the parliamentary crisis in Ireland was important in bringing Bacon's political capabilities to the king's notice because since the death of Salisbury the year previous there was no English minister specializing in Irish matters. Indeed Bacon later informed George Villiers in 1616 that ‘when the great rent and divisions were in the Parliament of Ireland, I was no unfortunate remembrancer to his Majesty's princely wisdom in that business’.


In June 1613 after the opening of Irish parliament collapsed into chaos and an Irish delegation arrived in London, Bacon drew up and sent to the king 'a little breviat of the Irish business'. Although this 'breviat' is no longer attached to the covering letter held by the Folger Library, it can be identified as Bacon's charge of the Irish recusant party's representatives before the King and Privy Council. This was originally listed as being amongst the Carew Papers at Crowcombe Court, Somerset, by Historical Manuscript Commissioners in 1874.[3](javascript:footNote('E600001-015/note003.html')). However thirty years later those papers were sold off to private collectors and in effect lost to scholars. Fortunately this document has recently been identified amongst manuscripts acquired subsequently by the Pierpont Morgan Library in New York and it now appears here for the first time. The Irish delegation were prosecuted for ‘disturbing, crossing and traducing of the Parliament in Ireland called by Your Majesty’. As it stands, this document is a disappointment. Rather than being full of interesting constitutional insights on Anglo-Irish relations by England's leading intellectual, it is a rhetorical and fawning performance by a barrister who has been handed a brief with great knockabout potential. The delegates are represented as leaders of ‘a party’ — an interesting usage in parliamentary history — who have acted not only in a contemptuous, presumptuous and disorderly fashion but also possibly with seditious intent. They had deigned to question the new corporations erected as a result of the king's ‘most Christian and Blessed act’ in assisting the country with plantations. They had even asked to see the Lord Deputy's instructions regarding the parliament which was an intolerable presumption on the parts of subjects. Then when parliament collapsed over the appointment of a speaker, this party tried to ‘give law in a fashion to the deputy & capitulate & treat with him upon what conditions they will repair a parliament’. For Bacon this was the beginnings of liberty and conditional obedience being ‘as much as to say if you will yield to us in all we require, we will do as shall please us’. Furthermore since coming into England, these agents had complained about the infringement of parliamentary rights in an attempt ‘to sow the seeds of scandal and discontent even within the parliament of England’. To this Bacon responded, describing himself as a parliament man of thirty-two years' experience, that under King James the ‘liberties of parliament have been ampliate and enlarged and not infringed or restrained’. Bacon ended his charge of the Irish agents by burlesquing the case of Thomas Luttrell who ‘like a tribune of the people’ entered the House of Lords in Dublin to upbraid the Lord Deputy where he sat in his robes of state. Bacon's performance here seems at variance with the moderate opinions he has expressed regarding Ireland. However this was more about defending the actions of an absolutist state and flattering its prince. These delegates were not being ridiculed for being Irish but for demanding their constitutional rights. That explains government fears that they would make common cause with English parliamentary opponents. Interestingly we have another letter from Bacon to the King early the following year where he advises putting off another session of the troublesome Irish parliament so that it will not disturb the planned English one. Instead a carefully stage-managed English parliament should be called first so as to provide an example of obedience to its postponed Irish counterpart.


Bacon's other charge was against William Talbot who was considered the Irish recusants ‘chief oracle for law’. Whereas the other Irish delegates had been placed under house arrest at Croyden, Talbot had been sent to the Tower after refusing to repudiate Francisco Suarez's views of the duty of Catholic subjects to heretical monarchs.[4](javascript:footNote('E600001-015/note004.html')) These were circulating in Defensio catholicae fidei contra anglicanae which Suarez had recently published at the Pope's behest against the 1606 English oath of allegiance. When the book reached England, James had ordered its burning by the public hangman. Talbot did not, it seems, possess a copy of the book but when he continued to refuse to deny Suarez's doctrines, he was called before the Star Chamber in March 1614. Suarez had upheld the Pope's claims of temporal authority over kings and the right to deprive them and thereby to incite subjects to tyrannicide. Bacon denounced these ‘monstrous opinions’ and cited the recent regicides in France and the attempted ones in England. Though Talbot's statement did not venture an opinion on the book and acknowledged his loyalty to King James as sovereign, he also submitted all matters of faith to the judgment of the Catholic church. Bacon was prepared to be lenient and accept this formulation but also thought it was too conditional and far too late in the day. Bacon's charge of Talbot and indeed his case against the whole deputation were referred to again the following month. That was when King James famously denounced the Irish Catholic delegates as ‘but half-subjects’, dismissed their complaints and dispatched them home to redeem themselves by behaving properly in their delayed parliamentary deliberations.[5](javascript:footNote('E600001-015/note005.html')).


Bacon and the solicitor-general Henry Hobart also gave a legal opinion on whether the oath of allegiance could be tendered to these Irish in England. They agreed that the oath was not statute law in Ireland and in effect only voluntary. If the delegates had not recently taken communion, they could be required to take the oath but the law officers left it up to the king and privy council whether this applied to non-residents. This opinion is here included with four other legal opinions relating to Ireland which Bacon gave, often in tandem with other English law-officers and judges. The decisions in which Bacon was involved seem to be strict interpretations of existing law and practise, in particular that the laws operating in England were not necessarily the same as those operating in Ireland. Bacon regards Ireland as separate jurisdiction; he does not regard — at least so it seems — laws made in England to be superior to laws made in Ireland. These decisions do not appear to be anti-Irish or to favour England or Englishmen over Irish subjects of the crown; on the other hand none of these decisions go against the interests of the state. The question is whether or not these legal opinions are similar to the judicial resolutions of his Irish counter-part, Sir John Davies, which Hans Pawlisch has called judge-made law. When they relate to new policies, they surely can be. The judgement relating to Burrell's operation of an Iron Foundary for the East India Company in County Cork seems neutral enough as does the opinion relating to attainted lands, bishops' lands and alienations sent over to the Chief Baron of the Exchequer in Ireland. His decision made together with Ellesmere relating to recusant mayors in Irish town corporations was a call for the strict enforcement of the existing law but the decision made on his own in 1616 relating to Irish towns exporting wool was a more radical departure. Reacting to a proposal by the outgoing Lord Deputy, Sir Arthur Chichester, and London merchants, Bacon was interpreting town charters and statutes to propose a new stapling arrangement for the export of wool. The plan was to extend the number of Irish staple towns which would in future channel all their wool exports through corresponding English staple towns. This was a monopolist, mercantilist and statist measure. Irish wool exports henceforth would go only to England to be taxed by approved state contractors. In 1617 this measure was agreed by the Privy Council of which Bacon was now a prominent member as Lord Chancellor and sent as an instruction into Ireland to be enacted by proclamation. At the time of this Privy Council order, there was already opposition in Ireland to the plan. The scheme never worked in practice — all but one of the proposed Irish staple towns refused to participate and in 1619 the Irish Council, forwarding petitions for redress, stated that it had produced ‘none of the good it promised’.[6](javascript:footNote('E600001-015/note006.html'))


This wool staple scheme may have been a disaster but it was only one of the new Irish policies in which Bacon was now closely involved as part of an attempt at administrative and fiscal reform in Ireland. In 1616 he helped draft a new commission for wards in Ireland. Two years later he was crowing to Buckingham about the increased revenues raised by this measure in Ireland and hoping that similar improvements might be adopted in England. In April 1617 Buckingham had informed him that the king wanted him to ‘go thoroughly about the business of Ireland, whereinto you are so well entered’.[7](javascript:footNote('E600001-015/note007.html')) Might it be that whilst it was Buckingham who had control of patronage in Ireland, it was Bacon who was chief architect of policy there between 1616 and 1621?


Hiram Morgan




---

p.314


Letter of Francis Bacon to Anthony Bacon, 26 August 1594
--------------------------------------------------------


### *Spedding, Letters & Life, I, 314–15*

Brother,
My cousin Cooke is come four days since and appointeth towards Italy this day se'nnight. I pray take care for the money to be paid here within four or five days. The sum you remember is £150.




---

p.315


I hear nothing from the Court in mine own business. There hath been a defeat of some force in Ireland by Maguire, which troubleth the Queen, being unaccustomed to such news thence; and thereupon the opportunity is said to be less to move her. Yet there is an amends in eodem genere by the coming in of the Earl of Tyrone, as was expected.


I steal to Twickenham, purposing to return this night; else I had visited you as I came from the Tower. Thus in haste I leave you to God's preservation. From Gray's Inn, this 26th of August, 1594.


Your entire loving brother,
Fr. Bacon


---

p.165


Letter of Francis Bacon to Sir Robert Cecil, ?February 1598
-----------------------------------------------------------


### *Montagu, Works of Bacon, XII, 165*

My singular good Lord,
The argument of my letters to your lordship rather increaseth than spendeth; it being only the desire I have to salute you: which, by your absence is more augmented than abated. For me to write your lordship occurrences either of Scottish brags or Irish plants or Spanish ruffling, or Low Country states, were (besides that it is alienum quidam from mine own humour) to forget to whom I write; save that you, that know true advertisement, sometimes desire and delight to hear common reports; as we that know but common reports desire to hear the truth. But to leave such as to write to your fortunes, I write to yourself in regard of my love to you, you being as near to me in heart's blood as in blood of descent. This day I had the contentment to see your father upon occasion; and methought his lordship's countenance was not decayed, nor his cough vehement; but his voice was as faint all the while as at first.


Thus, wishing your lordship a happy and speedy return, I commend you to the Divine Majesty.




---

p.15


Letter of Sir Francis Bacon to the Earl of Essex *late Feb/early March 1598*
----------------------------------------------------------------------------


### Montagu, Works of Bacon, XII, 15–7.

My singular good Lord,
I do write, because I have not yet had time fully to express my conceit, nor now, to attend you touching Irish matters, considering them as they may concern the state; that it is one of the aptest particulars that hath come, or can come upon the stage, for your lordship to purchase honour upon, I am moved to think for three reasons; because it is ingenerate in your house in respect of my lord your father's noble attempts; because of all the accidents of state at this time, the labour resteth upon that most; and because the world will make a kind of comparison between those that set it out of frame, and those that shall bring it into frame: which kind of honour giveth



---

p.16



the quickest kind of reflection. The transferring this honour upon yourself consisteth in two points: the one, if the principal persons employed come in by you, and depend upon you; the other, if your lordship declare yourself to undertake a care of that matter. For the persons, it falleth out well that your lordship hath had no interest in the persons of imputation: For neither Sir William FitzWilliams, nor Sir John Norris was yours: Sir William Russell was conceived yours, but was curbed: Sir Conyers Clifford, as I conceive it, dependeth upon you, who is said to do well; and if my Lord of Ormond in this interim do accommodate well, I take it he hath always had good understanding with your lordship. So as all things are not only whole and entire, but of favourable aspect towards your lordship, if you now choose well: wherein, in your wisdom, you will remember there is a great difference in choice of the persons, as you shall think the affairs to incline to composition, or to war. For your care-taking, popular conceit hath been, that Irish causes have been much neglected, whereby the very reputation of better care will be a strength: and I am sure, her Majesty and my lords of the council do not think their care dissolved, when they have chosen whom to employ; but that they will proceed in a spirit of state, and not leave the main point to discretion. Then if a resolution be taken; a consultation must proceed; and the consultation must be governed upon information to be had from such as know the place, and matters in fact; and in taking of information I have always noted there is a skill and a wisdom. For I cannot tell what account or inquiry hath been taken of Sir William Russell, of Sir Ralph Bingham, of the Earl of Thomond, of Mr. Wilbraham: but I am of opinion, much more would be had of them, if your lordship shall be pleased severally to confer, not obiter, but expressly, upon some caveat given them to think of it before, for, ‘bene docet qui prudenter 



---

p.17



interrogat.’ For the points of opposing them, I am too much a stranger to the business, to deduce them: but in a topic methinks the pertinent interrogations must be either of the possibility and means of accord, or of the nature of the war, or of the reformation of the particular abuses, or of the joining of practice with force in the disunion of the rebels. If your lordship doubt to put your sickle in other men's harvests, yet consider you have these advantages. First, time being fit to you in Mr. Secretary's absence: next, ‘vis unita fortior’: thirdly, the business being mixed with matters of war, it is fittest for you: lastly, I know your lordship will carry it with that modesty and respect towards aged dignity, and that good correspondence towards my dear ally, and your good friend, now abroad, as no inconvenience may grow that way. Thus have I played the ignorant statesman, which I do to nobody but your lordship, except I do it to the queen sometimes, when she trains me on. But your lordship will accept my duty and good meaning, and secure me touching the privateness of that I write.


Your Lordship's, to be commanded,


Fr. Bacon


---

p.17


Letter of Sir Francis Bacon to the Earl of Essex *late March/early April 1598*
------------------------------------------------------------------------------


### Montagu, Works of Bacon, XII, 17–9.


Those advertisements which your lordship imparted to me, and the like, I hold to be no more certain to make judgment upon than a patient's water to a physician: therefore for me upon one water to make a judgment, were indeed like a foolish bold mountebank, or Dr. Birket, yet, for willing duty's sake, I will set down to your lordship what opinion sprung in my mind upon that I read. The letter from the council there, leaning to distrust, I do not much rely upon, for three causes. First, because it is always 



---

p.18



both the grace and the safety from blame of such a council to err in caution: whereunto add, that it may be they, or some of them, are not without envy towards the person who is used in treating the accord. Next, because the time of this treaty hath no show of dissimulation, for that Tyrone is now in no straits, but like a gamester that will give over because he is a winner, not because he hath no more money in his purse.


Lastly, I do not see but those articles whereon they ground their suspicion, may as well proceed out of fear as out of falsehood, for the retaining of the dependence of the protracting the admission of a sheriff, the refusing to give his son for hostage, the holding from present repair to Dublin, the refusing to go presently to accord, without including O'Donnell, and others his associates, may very well come of a guilty reservation, in case he should receive hard measure, and not out of treachery; so as if the great person be faithful, and that you have not here some present intelligence of present succours from Spain, for the expectation whereof Tyrone would win time, I see no deep cause of distrusting the cause if it be good. And for the question, her Majesty seemeth to me a winner three ways: first, her purse shall have rest: next, it will divert the foreign designs upon that place: thirdly, though her Majesty is like for a time to govern precario in the north, and be not in true command in better state there than before, yet, besides the two respects of ease of charge, and advantage of opinion abroad, before mentioned, she shall have a time to use her princely policy in two points: in the one, to weaken by division and disunion of the heads; the other, by recovering and winning the people by justice, which of all other causes is the best. Now for the Athenian question, you discourse well, ‘Quid igitur agendum est?’ I will shoot my fool's bolt, since you will have it so. The Earl of Ormond to be encouraged and comforted above all things, the garrisons to 



---

p.19



be instantly provided for; for opportunity makes a thief: and if he should mean never so well now, yet such an advantage as the breaking of her Majesty's garrisons, might tempt a true man. And because he may as well waver upon his own inconstancy, as upon occasion, and want of variableness is never restrained but with fear, I hold it necessary to be menaced with a strong war; not by words, but by musters and preparations of forces here, in case the accord proceed not; but none to be sent over lest it disturb the treaty, and make him look to be overrun as soon as he hath laid down arms. And, but that your lordship is too easy to pass, in such cases, from dissimulation to verity, I think, if your lordship lent your reputation in this case, it is to pretend, that if not a defensive war, as in times past, but a full re-conquest of those parts of the country be resolved on, you would accept the charge, I think it would help to settle him, and win you a great deal of honour gratis. And that which most properly concerneth this action, if it prove a peace, I think her Majesty shall do well to cure the root of the disease, and to profess by a commission of peaceable men chiefly of respect and countenance, the reformation of abuses, extortions and injustices there, and to plant a stronger and surer government than heretofore, for the ease and protection of the subject; for the removing of the sword, or government in arms, from the Earl of Ormond, or the sending of a deputy, which will eclipse it, if peace follow, I think unseasonable. Lastly, I hold still my opinion, both for your better information, and your fuller declaration of your care, and evermore meriting service, that your lordship have a set conference with the persons I named in my former writing. I rest,


At your lordship s service,


Fr. Bacon


---

p.??


Letter of Francis Bacon to the Earl of Essex, 1 November 1598
-------------------------------------------------------------


### *Cecil Papers, Hatfield House, Manuscript MS 65, no. 35 (by permission of the Marquis of Salisbury)*

It may please your good Lord,
I am moved to commend your lordship for a company now for Ireland. Captain Best, whom I understand to be of so good note for his good services in the wars, as he cannot but be known in that proportion to your lordship who, I know, beareth a register of mens' good deservedness in this profession.


Besides as I am informed, he needeth not the wars for an occupation but having good means followeth them upon a good spirit. To these respects, I thought only to add the circumstance of my good affection towards him and earnest recommendation of his request. And so I commend your lordship to God's best preservation. From Gray's Inn, this 1 of November.


Yours lordship's ever most humble and deeply bound.
Fr. Bacon


---

p.??


Letter of Francis Bacon to Ed. Reynolds, 1598
---------------------------------------------


### *Cecil Papers, Hatfield House, Manuscript MS 67, no. 19 (by permission of the Marquis of Salisbury)*

Mr Reynolds,
I obtained his lordship's full promise for a company for Captain Garrett, wherefore I pray you his name may be entered into his lordship's private list and that you will yield him such your care and favour as to the effections of my lordship's promise appertaineth, wherein you shall deserve my best thanks. So with my loving commendation, I rest


Your friend very assured,
Fr. Bacon


---

p.264


Letter of Francis Bacon to Sir Francis Allen, 20 December 1598
--------------------------------------------------------------


### *Spedding, Life & Letters, I., 264–5.*

Sir Francis Allen,
I do so much favour this gentleman, Mr Garret, who from my service entered into a course of following the wars, which hath succeeded unto him, as to his own commendation, so yet nevertheless not hitherto to his settling in any place answerable to his desert and profession; in regard whereof, understanding of the nomination and appearance of your employment in Ireland, he conceiveth it will be some establishment to him if he may run your fortune, being by you accepted in the place of your lieutenant, your own virtue and reputation considered, and the uncertainty of the French employment. Of his proof and sufficiency to serve I write the less, because I take it to be well known to yourself. But for my particular I do assure you I can hardly imagine a matter wherein you shall more effectually tie me unto 


---

p.265



you than in this. I wished him to use me but as a means of my brother's commendation, which I esteemed to be of extraordinary weight with you. But because this was the readier and that the entireness between my brother and myself is well known unto you, he desired to begin with this. Thus I wish you all prosperity. From Hampton Court, the 20th of December, 1598.


Yours in unfeigned good affection.


Fr. Bacon I am sorry to hear from Mr. Anthony Standen how sharply and unreasonably you were assailed by the gout. But you have of him a careful solicitor, and if I can come in to him with any good endeavour of mine you may reckon of it.


---

p.20


Letter from Francis Bacon to the Earl *of Essex*, *January/February/March 1599*
-------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 20–3*

My Singular Good Lord,
Your note of my silence in your occasions hath made me set down these few wandering lines, as one that would say somewhat, and can say nothing touching your lordship's intended charge for Ireland; which my endeavour I know your lordship will accept graciously and well, whether your lordship take it by the handle of the occasion ministered from yourself, or of the affection from which it proceedeth. Your lordship is designed to a service of great merit and great peril; and as the greatness of the peril must needs include no small consequence of peril, if it be not temperately governed; so all immoderate success extinguisheth merit, and stirreth up distaste and envy, the assured forerunner of whole changes of peril. But I am at the last point first, some good spirit leading my pen to presage your lordship s success; wherein it is true, I am not without my oracle and divinations, none of them superstitious, and yet not all natural: for, first, looking into the course of God's providence in things now depending, and calling into consideration how great things God hath done by her majesty, and for her collect he hath disposed of this great dissection in Ireland, whereby to give an urgent occasion to the reduction of that whole kingdom, as upon the rebellion of Desmond there ensued the reduction of that province. Next, your lordship goeth against three of the unluckiest vices of all other, disloyalty, ingratitude, and insolence; which three offences in all examples have seldom their doom adjourned to the world to come. Lastly, he that shall have had the honour to know your lordship inwardly, as I have had, shall find ‘bona exta,’ whereby he may better ground a divination of good, than upon the dissection of a sacrifice. But that part I leave, for it is fit for 


---

p.21




others to be confident upon you, and you to be confident upon the cause, the goodness and justice whereof is such as can hardly be matched in any example, it being no ambitious war of foreigners, but a recovery of subjects, and that after lenity of conditions often tried; and a recovery of them not only to obedience, but to humanity and policy, from more than Indian barbarism. There is yet another kind of divination familiar in matters of state, being that which Demosthenes so often relieth upon in his time, where he saith, that which for the time past is worst of all, is for the time to come the best, which is, that things go ill not by accident but by error; wherein though your lordship hath been a waking censor, yet you must look for no other now, but ‘medice, cura te ipsum’; and although your lordship shall not be the blessed physician that cometh to the declination of the disease, yet you embrace that condition which many noble spirits have accepted for advantage, which is, that you go upon the greater peril of your fortune, and the less of your reputation; and so the honour countervaileth the adventure; of which honour your lordship is in no small possession, when that her majesty, known to be one of the most judicious princes in discerning of spirits that ever governed, hath made choice of you merely out of her royal judgment, (her affection inclining rather to continue your attendance,) into whose hands and trust to put the commandment and conduct of so great forces, the 
gathering in the fruit of so great charge, the execution of so many councils, the redeeming of the defaults of so many former governors, and the clearing the glory of so many happy years reign, only in this part excepted. Nay farther, how far forth the peril of that state is interlaced with the peril of England; and therefore how great the honour is to keep and defend the approaches of this kingdom, I hear many discourse; and indeed there is a great difference, whether the tortoise gather herself into her shell hurt or unhurt; and if any man be of 



---

p.22



opinion, that the nature of an enemy doth extenuate the honour of a service, being but a rebel and a savage, I differ from him; for I see the justest triumphs that the Romans in their greatest greatness did obtain, and that whereof the emperors in their styles took additions and denominations, were of such an enemy; that is, people barbarous, and not reduced to civility, magnifying a kind of lawless liberty, prodigal of life, hardened in body, fortified in woods and bogs, placing both justice and felicity in the sharpness of their swords. Such were the Germans and ancient Britons, and divers others. Upon which kind of people, whether the victory be a conquest, or a re-conquest upon a rebellion or revolt, it made no difference that ever I could find, in honour. And therefore it is not the enriching the predatory war that hath the pre-eminence in honour; else should it be more honour to bring in a carrack of rich burthen, than one of the twelve Spanish apostles. But then this nature of people doth yield a higher point of honour (considering in truth and substance) than any war can yield which should be achieved against a civil enemy, if the end may be ‘pacique imponere morem’, to replant and refound the policy of that nation, to which nothing is wanting but a just and civil government. Which design, as it doth descend to you from your noble father, (who lost his life in that action, though he paid tribute to nature, and not to fortune,) so I hope your lordship shall I be as fatal a captain to this war, as Africanus was to the war of Carthage, after that both his uncle and his father had lost their lives in Spain in the same war.


Now although it be true, that these things which I have writ (being but representations unto your lordship of the honour and appearance of success and enterprise) be not much to the purpose of my direction, yet, it is that which is best to me, being no man of war, and ignorant in the particulars of state: for a man may by the eye set up the white right in the midst of the butt, though he be no archer. 



---

p.23



Therefore I will only add this wish, according to the English phrase, which termeth a well-wishing advice a wish, that your lordship in this whole action, looking forward, set down this position; that merit is worthier than fame; and looking back hither, would remember this text, that ‘obedience is better than sacrifice.’ For designing to fame and glory may make your lordship, in the adventure of your person, to be valiant as a private soldier, rather than as a general; it may make you in your commandments rather to be gracious than disciplinary; it may make you press action, in the respect of the great expectation conceived, rather hastily than seasonably and safely; it may make you seek rather to achieve the war by force, than by mixture of practice; it may make you (if God shall send you prosperous beginnings) rather seek the fruition of the honour, than the perfection of the work in hand. And for your proceeding like a good protestant (upon warrant, and not upon good intention) your lordship knoweth, in your wisdom, that as it is most fit for you to desire convenient liberty of instruction, so it is no less fit for you to observe the due limits of them, remembering that the exceeding of them may not only procure (in case of adverse accident) a dangerous disavow, but also (in case of prosperous success) be subject to interpretation, as if all was not referred to the right end.


Thus I have presumed to write these few lines to your lordship, ‘in methodo ignorantiae,’ which is, when a man speaketh of any subject not according to the parts of the matter, but according to the model of his own knowledge: and most humbly desire your lordship, that the weakness thereof may be supplied in your lordship, by a benign acceptation, as it is in me by my best wishing.


Fr. Bacon


---

p.156


Letter of Francis Bacon to the Earl of Essex, September 1599
------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 156.*

My Lord,
Conceiving that your Lordship came now up in the person of a good servant to see your sovereign mistress, which kind of compliments are many times instar magnorum meritorum, and therefore that it would be hard for me to find you, I have committed to this poor paper the humble salutations of him that is more yours than any man's and more yours than any man. To these salutations I add a due and joyful gratulation, confessing that your Lordship, in your last conference with me before your journey, spoke not in vain, God making it good, That you trusted we should say Quis putasset? Which as it is found true in a happy sense, so I wish you do not find another Quis putasset in the manner of taking this so great a service. But I hope it is, as he said, Nebecula est, cito transibit: and that your Lordship's wisdom and obsequious circumspection and patience will turn all to the best. So referring all to some time that I may attend you,


I commit you to God's best preservation.




---

p.277


The proceedings of the Earl of Essex, June 1600
-----------------------------------------------


### *Montagu, Works of Bacon, VI, 277–98*


The points of form worthy to be observed.


The fifth of June in Trinity term, upon Thursday, being no Star-Chamber day, at the ordinary hour when the courts sit at Westminster, were assembled together at the Lord Keeper's house in the great chamber, her Majesty's Privy Council, enlarged and assisted for that time and cause by the special call and associating of certain selected persons. viz. Four earls, two barons, and four judges of the law, making in the whole a council or court of eighteen persons, who were attended by four of her Majesty's learned counsel for charging the earl; and two clerks of the council, the one to read, the other as a register; and an auditory of persons, to the number, as I could guess, of two hundred, almost all men of quality, but of every kind or profession; nobility, court, law, country, city. The upper end of the table left void for the earl's appearance, who, after the commissioners had sat a while, and the auditory was quiet from the first throng to get in, and the doors shut, presented himself and kneeled down at


---

p.278



 the board's end, and so continued till he was licensed to stand up.


> 
> The names of the Commissioners.
> 
> 
> Lord Archbishop, Lord Keeper, etc.
> 
> 
> 




It was opened, that her Majesty being imperial, and immediate under God was not holden to render account of her actions to any; howbeit, because she had chosen ever to govern, as well with satisfaction as with sovereignty, and the rather, to command down the winds of malicious and seditious rumours wherewith men's conceits may have been tossed to and fro, she was pleased to call the world to an understanding of her princely course held towards the earl of Essex, as well in here-before protracting as in now proceeding.


The earl repairing from his government into this realm in August last, contrary to her Majesty's express and most judicial commandment, though the contempt were in that point visible, and her Majesty's mind prepared to a just and high displeasure, in regard of that realm of Ireland set a hazard by his former disobedience to her royal directions, yet kept that stay, as she commanded my lord only to his chamber in court, until his allegations might by her Privy Council be questioned and heard; which account taken, and my lord's answers appearing to be of no defence, that shadow of defence which was offered consisted of two parts, the one his own conceit of some likelihood of good effects to ensue of 


---

p.279



the course held, the other a vehement and overruling persuasion of the council there, though he were indeed as absolutely freed from opinion of the Council of Ireland, as he was absolutely tied to her Majesty's trust and instructions. Nevertheless, her Majesty not unwilling to admit to any extenuation of his offence; and considering the one point required advertisement out of Ireland, and the other further expectation of the event and sequel of the affairs there, and so both points asked time and protraction; her Majesty proceeded still with reservation, not to any restraint of my lord according to the nature and degree of his offence, but to a commitment of him, sub libera custodia in the Lord Keeper's house.


After, when both parts of this defence plainly failed my lord, yea, and proved utterly adverse to him, for the Council of Ireland in plain terms disavowed all those his proceedings, and the event made a miserable interpretation of them, then her Majesty began to behold the offence in nature and likeness, as it was divested from any palliation or cover, and in the true proportion and magnitude thereof, importing the peril of a kingdom; which consideration wrought in her Majesty a strange effect, if anything which is heriocal in virtue can be strange in her nature; for when offence was grown unmeasurably offensive, then did grace superabound; and in the heat of all the ill news out of Ireland, and other advertisements thence to my lord's disadvantage, her Majesty entered into a resolution, out of herself and 


---

p.280



her inscrutable goodness, not to overthrow my lord's fortune irreparably, by public and proportionable justice: notwithstanding, inasmuch as about that time there did fly about in London streets and theatres divers seditious libels; and Paul's and ordinaries were full of bold and factious discourses, whereby not only many of her Majesty's faithful and zealous counsellors and servants were taxed, but withal the hard estate of Ireland was imputed to anything rather than to the true cause, the earl's defaults, though this might have made any prince on earth to lay aside straightways the former resolution taken, yet her Majesty in her moderation persisted in her course of clemency, and bethought herself of a mean to right her own honour, and yet spare the earl's ruin; and therefore taking a just and most necessary occasion upon these libels, of an admonition to be given seasonably, and as is oft accustomed; the last Star-chamber day of Michaelmas term, was pleased, that declaration should be made, by way of testimony, of all her honourable Privy Council, of her Majesty's infinite care, royal provisions, and prudent directions for the prosecutions in Ireland, wherein the earl's errors, by which means so great care and charge was frustrated, were incidently touched.


But as in bodies very corrupt, the medicine rather stirreth and exasperateth the humour than purgeth it, so some turbulent spirits laid hold of this proceeding in so singular partiality towards my lord, as if it had been to his disadvantage, and gave out 


---

p.281



that this was to condemn a man unheard, and to wound him on his back, and to leave Justice her sword and take away her balance, which consisted of an accusation and a defence; and such other seditious phrases: whereupon her Majesty seeing herself interested in honour, which she hath ever sought to preserve as her eye, clear and without mote, was enforced to resolve of a judicial hearing of the cause, which was accordingly appointed in the end of Hilary term. At the which time warning being given to my lord to prepare himself, he falling, as it seemed to a deep consideration of his estate, made unto her Majesty by letter an humble and effectual submission, beseeching her that that bitter cup of justice might pass from him, for those were his word; which wrought such an impression in her Majesty's mind, that it not only revived in her her former resolution to forbear any public hearing, but it fetched this virtue out of mercy by the only touch, as few days after my lord was removed to further liberty in his own house, her Majesty hoping that these bruits and malicious imputations would of themselves wax old and vanish: but finding it otherwise in proof, upon taste taken by some intermission of time, and especially beholding the humour of the time in a letter presumed to be written to her Majesty herself by a lady, to whom, though nearest in blood to my lord, it appertained little to intermeddle in matters of this nature, otherwise than in course of humility to have solicited her grace and mercy; in which letter, in a certain violent and mineral 


---

p.282



spirit of bitterness, remonstrance and representation is made to her Majesty, as if my lord suffered under passion and faction, and not under justice mixed with mercy; which letter, though written to her sacred hands, and therefore unfit to pass in vulgar hands, yet was first divulged by copies everywhere, that being, as it seemeth, the newest and finest form of libelling, and since committed to the press: her Majesty in her wisdom seeing manifestly these rumours thus nourished had got too great a head to be repressed without some hearing of the cause, and calling my lord to answer; and yet on the other side, being still informed touching my lord himself of his continuance of penitence and submission, did in conclusion resolve to use justice, but with the edge and point taken off and rebated; for whereas nothing leaveth that taint upon honour, which is a person of my lord's condition is hardliest repaired, in question of justice, as to be called to the ordinary and open place of offenders and criminals, her Majesty had ordered the hearing should be intra domesticos parietes and not luce forensi. And whereas again in the Star Chamber there is certain formalities not fit in regard of example to be dispensed with, which would strike deeper both into my lord's fortune and reputation; as to the fine which is incident to a sentence there given, and the imprisonment of the Tower, which in case of contempts that touch the point of estate doth likewise follow; her Majesty turning this course, had directed that the matters should receive, before a great, honourable, 


---

p.283



and selected council, a full and deliberate, and yet in respect, a private, mild and gracious hearing.


All this was not spoken in one undivided speech, but partly by the first that spoke of the learned counsel, and partly by some of the commissioners; and for in this and the rest I keep order of nature, and not of circumstance.


1. The matters laid to my lord's charge.


The matters wherewith my lord was charged were of two several natures; of an higher, and of an inferior degree of offence.


The former kind purported great and high contempts and points of misgovernance in his office of her Majesty's lieutenant and governor of her realm of Ireland; and in the trust and authority thereby to him committed.


The latter contained divers notorious errors and neglects of duty, as well in his government as otherwise.


The great contempts and points of misgovernment and malversation in his office were articulate into three heads.


1. The first was the journey into Munster, whereby the prosecution in due time upon Tyrone in Ulster was overthrown; wherein he proceeded contrary to his directions, and the whole design of his employment: whereof ensued the consumption of her Majesty's treasure and provisions, and the evident peril of that kingdom.




---

p.284


2. The second was the dishonourable and dangerous treaty held, and cessation concluded with the same arch-rebel Tyrone.


3. The third was his contemptuous leaving his government, contrary to her Majesty's absolute mandate under her hand and signet, and in a time of so imminent and instant danger.


For the first, it had two parts; that her Majesty's resolution and direction was precise and absolute for the northern prosecution, and that the same direction was by my lord in regard of the journey to Munster, wilfully and contemptuously broken.


It was therefore delivered, that her Majesty, touched with a true and princely sense of the torn and broken estate of that kingdom of Ireland, entered into a most Christian and magnanimous resolution to leave no faculty of her regal power or policy unemployed for the reduction of that people, and for the suppressing and utter quenching of that flame of rebellion, wherewith that country was and is wasted: whereupon her Majesty was pleased to take knowledge of the general conceit, how the former making and managing of the actions there had been taxed, upon two exceptions; the one, that the proportion of forces which had been there maintained and continued by supplies, were not sufficient to bring the prosecutions to a period: the other, that the prosecutions had been also intermixed and interrupted with too many temporizing treaties, whereby the rebel did not only gather strength, but 


---

p.285



also find his strength more and more, so as ever such smothers broke forth again into greater flames. Which kind of discourses and objections, as they were entertained in a popular kind of observation, so were they ever chiefly patronized and apprehended by the earl, both upon former times and occasions, and now last when this matter was in deliberation. So as her Majesty, to acquit her honour and regal function, and to give this satisfaction to herself and others, that she had left no way untried, resolved to undertake the action with a royal army and puissant forces, under the leading of some principal nobleman; in such sort, that, as far as human discourse might discern, it might be hoped, that by the expedition of a summer, things might be brought to that state, as both realms may feel some ease and respiration; this from charge and levies, and that from troubles and perils. Upon this ground her Majesty made choice of my lord of Essex for that service, a principal peer and officer of her realm, a person honoured with the trust of a privy counsellor, graced with the note of her Majesty's special favour, infallibly betokening and redoubling his worth and value, enabled with the experience and reputation of former services, and honourable charges in the wars; a man every way eminent, select and qualified for a general of a great enterprise, intended for the recovery and reduction of that kingdom, and not only or merely as a lieutenant or governor of Ireland.


My lord, after that he had taken the charge upon 


---

p.286



him, fell straightways to make propositions answerable to her Majesty's ends, and answerable to his own former discourses and opinions; and chiefly did set down one full and distinct resolution, that the design and action, which of all others was most final and summary towards an end of those troubles, and which was worthy of her Majesty's enterprise with great and puissant forces, was a prosecution to be made upon the arch-traitor Tyrone in his own strengths within the province of Ulster, whereby both the inferior rebels which rely upon him, and the foreigner upon whom he relieth, might be discouraged, and so to cut asunder both dependences: and for the proceeding with greater strength and policy in that action, that the main invasion and impression of her Majesty's army should be accompanied and corresponded unto by the plantation of strong garrisons in the north, as well upon the river of Loughfoyle as a postern of that province, as upon the hither frontiers, both for the distracting and bridling of the rebels forces during the action, and again, for the keeping possession of the victory, if God should send it.


This proposition and project moving from my lord, was debated in many consultations. The principal men of judgement and service in the wars, as a council of war to assist a council of state, were called at times unto it; and this opinion of my lord was by himself fortified and maintained against all contradiction and opposite argument; and in the end, ex unanimi consensus it was concluded and 


---

p.287



resolved that the axe should be put to the root of the tree: which resolution was ratified and confirmed by the binding and royal judgement of her sacred Majesty, who vouchsafed her kingly presence at most of those consultations.


According to a proposition and enterprise of this nature, were the proportions of forces and provisions thereunto allotted. The first proportion set down by my lord was the number of 12,000 foot and 1,200 horse; which being agreed unto, upon some other accident out of Ireland, the earl propounded to have it made 14,000 foot and 1,300 horse, which was likewise accorded; within a little while after the earl did newly insist to have an augmentation of 2,000 more, using great persuasions and confident significations of good effect, if those numbers might be yielded to him, as which he also obtained before his departure; and besides the supplies of 2,000 arriving in July, he had authority to raise 2,000 Irish more, which he procured by his letters out of Ireland, with pretence to further the northern service: so as the army was raised in the conclusion and list to 16,000 foot and 1,300 horse, supplied with 2,000 more at three months' end and increased with 2,000 Irish upon this new demand; whereby her Majesty at that time paid 18,000 foot and 1,300 in the realm of Ireland. Of these forces, divers companies drawn out of the experienced bands of the Low Countries; special care taken that the new levies in the country should be the ablest, and most disposed bodies; the army also animated and 


---

p.288



encouraged with the service of divers brave and valiant noblemen and gentlemen voluntaries; in sum, the most flourishing and complete troops that have been known to have been sent out of our nation in any late memory. A great mass of treasure provided and issued, amounting to such a total, as the charge of that army, all manner of ways, from the time of the first provisions and setting forth, to the time of my lord's returning into England, was verified to have drawn out of the coffers, besides the charge of the country, the quantity of £300,000, and so ordered as he carried with him three months' pay beforehand, and likewise victual, munition, and all habilments of war whatsoever, with attendance of shipping allowed and furnished in a sortable proportion, and to the full of all my lord's own demands. For my lord being himself a principal counsellor for the preparations, as he was to be an absolute commander in the execution, his spirit was in every conference and conclusion in such sort, as when there happened any points of difference upon demands, my lord using the forcible advantages of the toleration and liberty which her Majesty's special favour did give unto him, and the great devotion and forwardness of his fellow-counsellors to the general cause, and the necessity of his then present service, he did ever prevail and carry it; insomuch as it was objected and laid to my lord's charge as one of his errors and presumptions, that he did oftentimes upon their prepositions and demands, enter into contestations with her Majesty, more a great deal than 


---

p.289



was fit. All which propositions before mentioned being to the utmost of my lord's own askings, and of that height and greatness, might really and demonstratively express and intimate unto him, besides his particular knowledge which he had, as a counsellor of state, as the means both of her Majesty and this kingdom, that he was not to expect to have the commandment of 16,000 foot and 1,300 horse, as an appurtenance to his lieutenancy of Ireland, which was impossible to be maintained; but contrariwise, that in truth of intention he was designed as general for one great action and expedition, unto which the rest of his authority was but accessory and accommodate.


It was delivered further, that in the authority of his commission, which was more ample in many points than any former lieutenant had been vested with, there were many direct and evident marks of his designation to the northern action, as principally a clause whereby merum arbitrium belli et pacis was reposed in his sole trust and discretion, whereas all the lieutenants were ever tied unto the peremptory assistance and admonition of a certain number of voices of the council of Ireland The occasion of which clause so passed to my lord, doth notably disclose and point unto the precise trust committed to my lord for the northern journey; for when his commission was drawn at first according to former precedents, and on the other side my lord insisted strongly to have this new and prima facie vast and exorbitant authority, he used this argument;


---

p.290



that the council of Ireland had many of them livings and possessions in or near the province of Leinster and Munster; but that Ulster was abandoned from any such particular respects, whereby it was like, the council there would be glad to use her Majesty's forces for the clearing and assuring of those territories and countries where their fortunes and estates were planted: so as, if he should be tied to their voices, he were like to be diverted from the main service intended: upon which reason that clause was yielded unto.


So as it was then concluded, that all circumstances tended to one point, that there was a full and precise intention and direction for Ulster, and that my lord could not descend into the consideration of his own quality and value; he could not muster his fair army; he could not account with the treasurer, and take consideration of the great mass of treasure issued; he could not look into the ample and new clause of his letters patent; he could not look back, either to his own former discourses, or to the late propositions whereof himself was author, nor to the conferences, consultations, and conclusions thereupon, nor principally to her Majesty's royal direction and expectation, nor generally to the conceit both of subjects of this realm, and the rebels themselves in Ireland; but which way soever he turned, he must find himself trusted, directed, and engaged wholly for the northern expedition.


The parts of this that was charged were verified by


---

p.291



three proofs: the first, the most authentical but the least pressed, and that was her Majesty's own royal affirmation, both by her speech now and her precedent letters; the second, the testimony of the privy council, who upon their honours did avouch the substance of that was charged, and referred themselves also to many of their lordships' letters to the same effect; the third, letters written from my lord after his being in Ireland, whereby the resolution touching the design of the north is often knowledged.


There follow some clauses both of her Majesty's letters and of the lords of her council, and of the earl's and the council of Ireland, for the verification of this point.


Her Majesty, in her letter of the 19th of July to my lord of Essex, upon the lingering of the northern journey, doubting my lord did value service, rather by the labour he endured, than by the advantage of her Majesty's royal ends, hath these words:
‘You have in this dispatch given us small light, either when or in what order you intend particularly to proceed to the northern action; wherein if you compare the time that is run on, and the excessive charges that are spent, with the effects of any thing wrought by this voyage, howsoever we remain satisfied with your own particular cares and travails of body and mind, yet you must needs think that we, that have the eyes of foreign princes upon our actions, and have the hearts of people to comfort and cherish, who groan under the burden


---

p.292



of continual levies and impositions, which are occasioned by these late actions, can little please ourself hitherto with any thing that hath been effected.’


In another branch of the same letter, reflecting her royal regard upon her own honour interested in this delay, hath these words:
  


‘Whereunto we will add this one thing that doth more displease us than any charge or offence that happens, which is, that it must be the queen of England's fortune, who hath held down the greatest enemy she had, to make a base bush-kern to be accounted so famous a rebel, as to be a person against whom so many thousands of foot and horse, besides the force of all the nobility of that kingdom, must be thought too little to be employed.’


In another branch, discovering, as upon the vantage ground of her princely wisdom, what would be the issue of the courses then held, hath these words:
  


And therefore, although by your letter we found your purpose to go northwards, on which depends the main good of our service, and which we expected long since should have been performed; yet because we do hear it bruited, besides the words of your letter written with your own hand, which carries some such sense, that you who allege such sickness in your army by being travelled with you, and find so great and important affairs to digest at Dublin, will yet engage yourself personally into Offaly, being our lieutenant


---

p.293



when you have there so many inferiors able, might victual a fort, or seek revenge against those who have lately prospered against our forces. And when we call to mind how far the sun hath run his course, and what dependeth upon the timely plantation of garrisons in the North, and how great scandal it would be to our honour to leave that proud rebel unassayed, when we have with so great an expectation of our enemies engaged ourselves so far in the action; so that, without that be done, all those former courses will prove like via navis in mari; besides that our power, which hitherto hath been dreaded by potent enemies, will now even be held contemptible amongst our rebels: we must plainly charge you, according to the duty you owe to us, so to unite soundness of judgement to the zeal you have to do us service, as with all speed to pass thither in such sort, as the axe might be put to the root of that tree, which hath been the treasonable stock from whom so many poisoned plants and grafts have been derived; by which proceedings of yours, we may neither have cause to repent of our employment of yourself for omitting those opportunities to shorten the wars, nor receive in the eye of the world imputation of so much weakness in ourself, to begin a work without better foresight what would be the end of our excessive charge, the adventure of our people's lives, and the holding up of our own greatness against a wretch, whom we have raised from the dust, and who could never 


---

p.294



prosper, if the charges we have been put to were orderly employed.


Her Majesty in her particular letter written to my lord the 30th of July, bindeth, still expressly upon the northern prosecution, my lord ad principalia rerum in these words:
  


‘First, you know right well, when we yielded to this excessive charge, it was upon no other foundation than to which yourself did ever advise us as much as any, which was, to assail the northern traitor, and to plant garrisons in his country; it being ever your firm opinion, amongst other our council, to conclude that all was done in other kind in Ireland, was but waste and consumption.’


Her Majesty in her letter of the 9th of August to my lord of Essex and the council of Ireland, when, after Munster journey, they began in a new time to dissuade the northern journey in her excellent ear, quickly finding a discord of men from themselves, chargeth them in these words:
  

‘Observe well what we have already written, and apply your counsels to that which may shorten, and not prolong the war; seeing never any of you was of other opinion, than that all other courses were but consumptions, except we went on with the northern prosecution.’


The lords of her Majesty's council, in their letter of the 10th of August to my lord of Essex and the council of Ireland, do in plain terms lay before them the first plot, in these words:
  



---

p.295



‘We cannot deny but we did ground our counsels upon this foundation. That there should have been a prosecution of the capital rebels in the North, whereby the war might have been shortened; which resolution, as it was advised by yourself before your going, and assented to by most part of the council of war that were called to the question, so must we confess to your lordship, that we have all this while concurred with her Majesty in the same desire and expectation.’


My lord of Essex, and the council of Ireland, in their letter of the 5th of May to the lords of the council before the Munster journey write in haec verba.


‘Moreover, in your lordships' great wisdom, you will likewise judge what pride the rebels will grow to, what advantage the foreign enemy may take, and what loss her Majesty shall receive, if this summer the arch-traitor be not assailed, and garrisons planted upon him.’


My lord of Essex in his particular letter of the 11th of July, to the lords of the council, after Munster journey writeth thus:
  


‘As fast as I can call these troops together, I will go look upon yonder proud rebel, and if I find him on hard ground, and in an open country, though I should find him in horse and foot three for one, yet will I by God's grace dislodge him, or put the council to the trouble of, &c.’




---

p.296


The earl of Essex, in his letter of the 14th of August to the lords of the council, writeth out of great affection, as it seemeth, in these words:
  


‘Yet must these rebels be assailed in the height of their pride, and our base clowns must be taught to fight again; else will her Majesty's honour never be recovered, nor our nation valued, nor this kingdom reduced.’


Besides it was noted, that whereas my lord and the council of Ireland, had, by theirs of the 15th of July, desired an increase of 2,000 Irish purposely for the better setting on foot of the northern service; her Majesty, notwithstanding her proportions, by often gradations and risings, had been raised to the highest elevation, yet was pleased to yield unto it.


1. The first part concerneth my lord's ingress into his charge, and that which passed here before his going hence; now followeth an order, both of time and matter, what was done after my lord was gone into Ireland, and had taken upon him the government by her Majesty's commission.


2. The second part then of the first article was to show, that my lord did wilfully and contemptuously, in this great point of estate, violate and infringe her Majesty's direction before remembered.


In delivering of the evidence and proofs of this part, it was laid down for a foundation, that there was a full performance on he Majesty's part of all the points agreed upon for this great prosecution, so


---

p.297



as there was no impediment or cause of interruption from hence.


This is proved by a letter from my lord of Essex and the council of Ireland to the lords of the council here, dated 9th May, which was some three weeks after my lord had received the sword, by which time he might well and thoroughly inform himself whether promise were kept in all things or no, and the words of the letter are these: 
  

‘As your lordships do very truly set forth, we do very humbly acknowledge her Majesty's chargeable magnificence and royal preparations and transportations of men, munition, apparel, money and victuals, for the recovery of this distressed kingdom;’ where note the transportations acknowledged as well as the preparations.


Next it was set down for a second ground, that there was no natural nor accidental impediment in the estate of the affairs themselves, against the prosecution upon Tyrone, but only culpable impediments raised by the journey of Munster.


This appeared by a letter from my lord and the council of Ireland to the lords of the council here, dated the 28th of April, whereby they advertise, that the prosecution of Ulster, in regard of lack of grass and forage, and the poorness of cattle at that time of year, and such like difficulties of the season, and not of the matter, will in better time, and with better commodity for the army, be fully executed about the middle of June or


---

p.298



beginning of July; and signify, that the earl intended a present prosecution should be set on foot in Leinster: to which letters the lords make answer by theirs of the 8th of May, signifying her Majesty's toleration of the delay.




---

p.27


Sir Francis Bacon to Sir Robert Cecil, *Summer 1602*
----------------------------------------------------


### Montagu, Works of Bacon, XII, 27–8

It may please your Honour,
As one that wisheth you all increase of honour, and as one that cannot leave to love the state, what interest soever I have, or may come to have in it, and as one that now this dead vacation time have some leisure ‘ad aliud agendum,’ I will presume to propound unto you that which though you cannot but see, yet I know not whether you apprehend and esteem it in so high a degree that is, for the best action of importation to yourself, of sound honour and merit to her Majesty, and this crown, without ventosity or popularity, that the riches of any occasion, or the tide of any opportunity can possibly minister or offer. And that is, the causes of Ireland, if they be taken by the right handle: for if the wound be not ripped up again, and come to a festered sense, by new foreign succours, I think that no physician will go on much with letting blood ‘in declinatione morbi,’ but will intend to purge and corroborate. To which purpose I send you mine opinion, without labour of words in the inclosed, and sure I am, that if you shall enter into the matter according to the vivacity of your own spirit, nothing can make unto you a more gainful return; for you shall make the queen s felicity complete, which now (as it is) is incomparable; and for yourself, you shall make yourself as good a patriot as you are thought a politic, and to have no less generous ends than dexterous delivery of yourself towards your ends; and as well to have true arts and



---

p.28



 grounds of government, as the facility and felicity of practice and negotiation; and to be as well seen in the periods and tides of estates, as in your own circle and way: than the which I suppose nothing can be a better addition and accumulation of honour unto you.


This, I hope, I may in privateness write, either as a kinsman, that may be bold, or as a scholar, that hath liberty of discourse, without committing of any absurdity. If not, I pray your honour to believe, I ever loved her Majesty and the state, and now love yourself; and there is never any vehement love without some absurdity, as the Spaniard well saith, ‘desuario con la calentura.’


So, desiring your honour's pardon, I ever continue, etc.


Fr. Bacon


---

p.187


Considerations touching the Queen's Service in Ireland *Summer 1602*
--------------------------------------------------------------------


### Montagu, Works of Bacon, V, 187–96.


The reduction of that country, as well to civility and justice, as to obedience and peace, which things, as affairs now stand, I hold to be inseparable, consisteth in four points: 
  


1. The extinguishing of the relics of the war.
  



---

p.188



2. The recovery of the hearts of the people.
  

3. The removing of the root and occasions of new troubles.
  

4. Plantations and buildings.


For the first; concerning the places and times, and particularities of farther prosecution, in fact I leave it to the opinion of men of war; only the difficulty is, to distinguish and discern the propositions, which shall be according to the ends of the state here, that is, final and summary towards the extirpation of the troubles, from those, which though they pretend public ends, yet may refer indeed to the more private and compendious ends of the council there: or of the particular governors or captains. But still, as I touched in my letter, I do think much letting blood, ‘in declinatione morbi’ is against method of cure: and that it will but induce necessity, and exasperate despair; and percase discover the hollowness of that which is done already, which now blazeth to the best show. For Iaglia's and proscriptions of two or three of the principal rebels, they are no doubt, ‘jure gentium’, lawful: in Italy usually practised upon the banditti; best in season when a side goeth down: and may do good in two kinds; the one, if they take effect: the other, in the distrust which may follow amongst the rebels themselves. But of all other points, to my understanding, the most effectual is, the well expressing or impressing the design of this state, upon that miserable and desolate kingdom; containing the same between these two lists or boundaries; the one, that the queen seeketh not an extirpation of that people, 



---

p.189



but a reduction; and that, now she hath chastised them by her royal power and arms, according to the necessity of the occasion, her Majesty taketh no pleasure in effusion of blood, or displanting of ancient generations. The other, that her Majesty's princely care is principally and intentionally bent upon the action of Ireland; and that she seeketh not so much the ease of charge, as the royal performance of the office of protection, and reclaim of those her subjects: and in a word, that the case is altered so far as may stand with the honour of the time past: which it is easy to reconcile, as in my last note I showed. And again, I do repeat, that if her Majesty's design be ‘ex professo’ to reduce wild and barbarous people to civility and justice, as well as to reduce rebels to obedience, it makes weakness turn Christianity, and conditions graces; and so hath a fineness in turning utility upon point of honour, which is agreeable to the humour of these times. And besides, if her Majesty shall suddenly abate the lists of her forces, and shall do nothing to countervail it in point of reputation, of a politic proceeding, I doubt things may too soon fall back into the state they were in. Next to this; adding reputation to the cause, by imprinting an opinion of her Majesty's care and intention upon this action, is the taking away of reputation from the contrary side, by cutting off the opinion and expectation of foreign succours; to which purpose this enterprise of Algiers, if it hold according to the advertisement, and if it be not wrapped up in the period of this summer, 



---

p.190



seemeth to be an opportunity ‘coelitus demissa’. And to the same purpose nothing can be more fit than a treaty, or a shadow of a treaty of a peace with Spain, which methinks should be in our power to fasten at least ‘rumore tonus’, to the deluding of as wise people as the Irish. Lastly, for this point; that which the ancients called ‘potestas facta redeundi ad sanitatem’; and which is but a mockery when the enemy is strong, or proud, but effectual in his declination; that is, a liberal proclamation of grace and pardon to such as shall submit, and come in within a time prefixed, and of some farther reward to such as shall bring others in; that one's sword may be sharpened by another's, is a matter of good experience, and now, I think, will come in time. And percase, though I wish the exclusions of such a pardon exceeding few, yet it will not be safe to continue some of them in their strength, but to translate them and their generations into England; and give them recompence and satisfaction here, for their possessions there, as the king of Spain did, by divers families of Portugal. To the effecting of all the points aforesaid, and likewise those which fall within the divisions following, nothing can be in priority, either of time or matter, better than the sending of some commission of countenance, ‘ad res inspiciendas et componendas’; for it will be a very significant demonstration of her Majesty's care of that kingdom; a credence to any that shall come in and submit; a bridle to any that shall have their fortunes there, and shall apply their propositions to private 



---

p.191



ends; and an evidence that her Majesty, after arms laid down, speedily pursueth a politic course, without neglect or respiration: and it hath been the wisdom of the best examples of government.


Towards the recovery of the hearts of the people, there be but three things, ‘in natura rerum’.
  


1. Religion.
  

2. Justice and protection,
  

3. Obligation and reward.


For religion, to speak first of piety, and then of policy, all divines do agree, that if consciences be to be enforced at all, wherein yet they differ, two things must precede their inforcement; the one, means of instruction; the other, time of operation; neither of which they have yet had. Besides, till they be more like reasonable men than they yet are, their society were rather scandalous to the true religion than otherwise; as pearls cast before swine: for till they be cleansed from their blood, incontinency, and theft, which are now not the lapses of particular persons, but the very laws of the nation, they are incompatible with religion reformed. For policy, there is no doubt but to wrestle with them now, is directly opposite to their reclaiming, and cannot but continue their alienation of mind from this government. Besides, one of the principal pretences, whereby the heads of the rebellion have prevailed both with the people, and with the foreigner, hath been the defence of the catholic religion: and it is this that likewise hath made the foreigner reciprocally more plausible with the rebel. Therefore a toleration of religion, 



---

p.192



for a time, not definite, except it be in some principal towns and precincts, after the manner of some French edicts, seemeth to me to be a matter warrantable by religion, and in policy of absolute necessity. And the hesitation in this point, I think, hath been a great casting back of the affairs there. Neither if any English papist or recusant shall, for liberty of his conscience, transfer his person, family, and fortunes thither; do I hold it a matter of danger, but expedient to draw on undertaking, and to further population. Neither if Rome will cozen itself, by conceiving it may be some degree to the like toleration in England, do I hold it a matter of any moment; but rather a good mean to take off the fierceness and eagerness of the humour of Rome, and to stay further excommunications or interdictions for Ireland. But there would go hand in hand with this, some course of advancing religion indeed, where the people is capable thereof; as the sending over some good preachers, especially of that sort which are vehement and zealous persuaders, and not scholastical, to be resident in principal towns; endowing them with some stipends out of her Majesty's revenues, as her majesty hath most religiously and graciously done in Lancashire: and the recontinuing and replenishing the college begun at Dublin, the placing of good men to be bishops in the sees there, and the taking care of the versions of bibles and catechisms, and other books of instruction, into the Irish language; and the like religious courses, both for the honour of God, and for the 



---

p.193



avoiding of scandal and insatisfaction here, by the show of a toleration of religion in some parts there.


For justice: the barbarism and desolation of the country considered, it is not possible they should find any sweetness at all of justice: if it should be, which hath been the error of times past, formal, and fetched far off from the state; because it will require running up and down for process; and give occasion for polling and exactions by fees, and many other delays and charges. And therefore there must be an interim in which the justice must be only summary: the rather, because it is fit and safe for a time the country do participate of martial government; and therefore, I could wish in every principal town or place of habitation, there were a captain or governor; and a judge, such as recorders and learned stewards are here in corporations, who may have a prerogative commission to hear and determine ‘secundum sanam discretionem’; and as near as may be to the laws and customs of England; and that by bill or plaint, without original writ; reserving from their sentence matter of freehold and inheritance, to be determined by a superior judge itinerant; and both sentences, as well of the bailiwick judge, as itinerant, to be reversed, if cause be, before the council of the province to be established there with fit instructions.


For obligation and reward; it is true, no doubt, which was anciently said, that a state is contained in two words, ‘praemium’ and ‘poena’; and I am persuaded, if a penny in the pound which hath been spent in ‘poena’, for this kind of war is but ‘poena’,



---

p.194



a chastisement of rebels, without fruit or emolument to this state, had been spent ‘in praemio’, that is, in rewarding, things had never grown to this extremity. But to speak forwards. The keeping of the principal Irish persons in terms of contentment, and without cause of particular complaint; and generally the carrying of an even course between the English and the Irish; whether it be in competition, or whether it be in controversy, as if they were one nation, without that same partial course which hath been held by the governors and counsellors there, that some have favoured the Irish, and some contrary, is one of the best medicines of that state. And as for other points of contentment, as the countenancing of their nobility as well in this court as there; the imparting of knighthood; the care of education of their children, and the like points of comfort and allurement; they are things which fall into every man's consideration.


For the extirpating of the seeds of troubles, I suppose the main roots are but three. The first, the ambition and absoluteness of the chief of the families and septs. The second, the licentious idleness of their kernes and soldiers, that lie upon the country, by cesses and such like oppressions. And the third, the barbarous laws, customs, their brehon laws, habits of apparel, their poets or heralds that enchant them in savage manners, and sundry other such dregs of barbarism and rebellion, which by a number of politic statutes of Ireland, meet to be put in execution, are already forbidden; unto which such 



---

p.195




additions may be made as the present time requireth. But the deducing of this branch requireth a more particular notice of the state and manners there, than falls within my compass.


For plantations and buildings, I do find it strange that in the last plot for the population of Munster, there were limitations how much in demesne, and how much in farm, and how much in tenancy; again, how many buildings should be erected, how many Irish in mixture should be admitted, and other things foreseen almost to curiosity: but no restraint that they might not build sparsim at their pleasure; nor any condition that they should make places fortified and defensible: which omission was a strange neglect and secureness, to my understanding. So as for this last point of plantations and buildings, there be two considerations which I hold most material; the one for quickening, and the other for assuring. The first is, that choice be made of such persons for the government of towns and places, and such undertakers be procured, as be men gracious and well beloved, and are like to be well followed. Wherein for Munster, it may be, because it is not ‘res Integra’; but that the former undertakers stand interessed, there will be some difficulty; but surely, in mine opinion, either by agreeing with them, or by over-ruling them with a parliament in Ireland, which in this course of a politic proceeding, infinite occasions will require speedily to be held, it will be fit to supply fit qualified persons for undertakers. The other, that 



---

p.196



it be not left, as heretofore, to the pleasure of the undertakers and adventurers, where and how to build and plant; but that they do it according to a prescript or formulary. For first, the places, both maritime and inland, which are fittest for colonies or garrisons, as well for doubt of the foreigner, as for keeping the country in bridle, will be found, surveyed, and resolved upon; and then that the patentees be tied to build in those places only, and to fortify as shall be thought convenient. And lastly, it followeth of course, in countries of new populations, to invite and provoke inhabitants by ample liberties and charters.




---

p.47


Letter of Francis Bacon to Sir John Davies, Attorney-General of Ireland, 26 December 1606
-----------------------------------------------------------------------------------------


### *Calendar of State Papers, Ireland, 1606–08, 47.*

Good Sir John Davies,
Your mistaking shall not be imputed unto you (for the difference is not much). Your gratulations for my marriage I take kindly; and as I was always delighted with the fruits of your invention, so I would be glad of your imitation, so as you plant not yourself too far off, for I had rather you should be a labourer than a plant in that State. You give me no occasion to write longer, in that you imparted not by our letter any occurrences of yours.


And so with my very loving commendations, I remain
  

Your assured friend,


Fr. Bacon
From Gray's Inn, this 26 December 1606.


---

p.5


Letter of Francis Bacon to Sir John Davies, Attorney General in Ireland, 23 October 1607
----------------------------------------------------------------------------------------


### *Spedding, Letters & Life, IV, 5–6*

Mr. Attorney,
I thank you for your letter and the discourse you sent of this new accident[8](javascript:footNote('E600001-015/note008.html')), as things then appeared. I see manifestly the beginning of better or worse: but me thinketh it is first a tender of the better, and worse followeth but upon refusal or default. I would have been glad to see you here: but I hope occasion reserveth our meeting for a vacation, when we may have


---

p.6



more fruit of conference. To requite your proclamation, which, in my judgement, is wisely and seriously penned, I send you another with us, which happened to be in my hands when yours came. I would be glad to hear often from you, and to be advertised how things pass, whereby to have some occasion to think some good thoughts; though I can do little. At the least it will be a continuance in exercise of our friendship, which on my part remaineth increased by that I hear of your service. And so, in Tormour's haste, I continue


Your very loving friend,


Fr. Bacon
From Gray's Inn, this 23rd of October 1607.


---

p.117


Letter to Mr. Pierce, Secretary to the Deputy of Ireland *between 1607 and 1612*
--------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 117*

Master Pierce,
I am glad to hear of you as I do; and for my part, you shall find me ready to take any occasion to further your credit and preferment: and I dare assure you (though I am no undertaker,) to prepare your way with my Lord of Salisbury, for any good fortune which may befall you. You teach me to complain of business, whereby I write the more briefly; and yet I am so unjust, as that which I allege for mine own excuse, I cannot admit for yours. For I must be expecting, exact your letters with this fruit of your sufficiency, as to understand how things pass in that kingdom. And therefore, having begun, I pray you to continue. This is not merely curiosity, for I have ever (I know not by what instinct) wished well to that impolished part of this Crown.


And so, with my very loving commendations, I remain.


---

p.73


Letter of Sir Francis Bacon to King James, *New Year 1609*
----------------------------------------------------------


### *Montagu, Works of Bacon, XII, 73*

It may please your most excellent Majesty,
 know no better way how to express my good wishes of a new-year to your Majesty, than by this little book, which in all humbleness I send you. The style is a style of business, rather than curious or elaborate, and herein I was encouraged by my experience of your Majesty's former grace, in accepting of the like poor field-fruits, touching the union. And certainly I reckon this action as a second brother to the union, for I assure myself, that England, Scotland, and Ireland, well united, is such a trefoil as no prince except yourself (who are the worthiest) weareth in his crown, si potentia reducatur in actum. I know well that for me to beat my brains about these things, they be majora quam pro fortuna, but yet they be minora quam pro studio et voluntate. For as I do yet bear an extreme zeal to the memory of my old mistress, Queen Elizabeth, to whom I was rather bound for her trust than for her favour; so I must acknowledge myself more bound to your majesty, both for trust and favour; whereof I will never deceive the one, as I can never deserve the other.


And so, in all humbleness kissing your Majesty s sacred hands, I remain




---

p.169


Certain considerations touching the Plantation in Ireland, New year 1609
------------------------------------------------------------------------


### *Montagu, Works of Bacon, V, 169–85.*

To the King.
It seemeth God hath reserved to your Majesty's times two works, which amongst the works of kings have the supreme pre-eminence; the union, and the plantation of kingdoms. For although it be a great fortune for a king to deliver or recover his kingdom from long continued calamities: yet in the judgment of those that have distinguished of the degrees of sovereign honour, to be a founder of estates or kingdoms, excelleth all the rest. For, as in arts and sciences, to be the first inventor is more than to illustrate or amplify; and as in the works of God, the creation is greater than the preservation; and as in the works of nature, the birth and nativity is more than the continuance: so in kingdoms, the first foundation or plantation is of more noble dignity and merit than all that followeth. Of which foundations there being but two kinds; the first, that maketh one of more; and the second, that maketh one of none: the latter resembling the creation of


---

p.170



the world, which was de nihilo ad quid; verses, O fortunatam natam me consule Romam! may be far more truly and properly applied to your Majesty's acts; natam te rege Britanniam; natam Hiberniam. For he spoke improperly of deliverance and preservation; but in these acts of yours it may be verified more naturally. For indeed unions and plantations are the very nativities or birth-days of kingdoms: wherein likewise your Majesty hath yet a fortune extraordinary, and differing from former examples in the same kind. For most part of unions and plantations of kingdoms have been founded in the effusion of blood: but your Majesty shall build in solo puro, et in area pura, that shall need no sacrifices expiatory for blood; and therefore, no doubt, under an higher and more assured blessing. Wherefore, as I adventured, when I was less known and less particularly bound to your Majesty, than since by your undeserved favour I have been, to write somewhat touching the union, which your Majesty was pleased graciously to accept,


---

p.171



and which since I have to my power seconded by my travails, not only in discourse, but in action: so I am thereby encouraged to do the like, touching this matter of plantation; hoping that your Majesty will, through the weakness of my ability, discern the strength of my affection, and the honest and fervent desire I have to see your Majesty's person, name, and times, blessed and exalted above those of your royal progenitors. And I was the rather invited this to do, by the remembrance, that when the Lord Chief Justice deceased, Popham, served in the place wherein I now serve, and afterwards in the attorney's place; he laboured greatly in the last project, touching the plantation of Munster: which nevertheless, as it seemeth, hath given more light by the errors thereof, what to avoid, than by the direction of the same, what to follow.


First therefore, I will speak somewhat of the excellency of the work, and then of the means to compass and effect it. For the excellency of the work, I will divide it into four noble and worthy consequences that will follow thereupon.


The first of the four, is honour; whereof I have spoken enough already, were it not that the harp of Ireland puts me in mind of that glorious emblem or allegory, wherein the wisdom of antiquity did figure and shadow out works of this nature. For the poets feigned that Orpheus, by the virtue and sweetness of his harp, did call and assemble the beasts and birds, of their nature wild and savage, to


---

p.172



stand about him, as in a theatre; forgetting their affections of fierceness, of lust, and of prey; and listening to the tunes and harmonies of the harp; and soon after called likewise the stones and woods to remove, and stand in order about him: which fable was anciently interpreted of the reducing and plantation of kingdoms; when people of barbarous manners are brought to give over and discontinue their customs of revenge and blood, and of dissolute life, and of theft, and of rapine; and to give ear to the wisdom of laws and governments; whereupon immediately followeth the calling of stones for building and habitation; and of trees for the seats of houses, orchards, and inclosures, and the like. This work therefore, of all other most memorable and honourable, your Majesty hath now in hand; especially, if your Majesty join the harp of David, in casting out the evil spirit of superstition, with the harp of Orpheus, in casting out desolation and barbarism.


The second consequence of this enterprise, is the avoiding of an inconvenience, which commonly attendeth upon happy times, and is an evil effect of a good cause. The revolution of this present age seemeth to incline to peace, almost generally in these parts; and your Majesty's most Christian and virtuous affections do promise the same more especially to these your kingdoms. An effect of peace in fruitful kingdoms, where the stock of people, receiving no consumption nor diminution by war, doth continually multiply and increase, must in the end


---

p.173



be a surcharge or overflow of people more than the territories can well maintain; which many times, insinuating a general necessity and want of means into all estates, doth turn external peace into internal troubles and seditions.


Now what an excellent diversion of this inconvenience is ministered, by God's providence, to your Majesty, in this plantation of Ireland? wherein so many families may receive sustentation and fortunes; and the discharge of them also out of England and Scotland may prevent many seeds of future perturbations: so that it is, as if a man were troubled for the avoidance of water from the place where he hath built his house, and afterwards should advise with himself to cast those waters, and to turn them into fair pools or streams, for pleasure, provision, or use. So shall your Majesty in this work have a double commodity, in the avoidance of people here, and in making use of them there.


The third consequence is the great safety that is like to grow to your Majesty's estate in general by this act; in discomfiting all hostile attempts of foreigners, which the weakness of that kingdom hath heretofore invited: wherein I shall not need to fetch reasons afar off, either for the general or particular. For the general, because nothing is more evident than that, which one of the Romans said of Peloponnesus: Testudo intra tegumen tuta est; the tortoise is safe within her shell: but if she put forth any part of her body, then it endangereth not only the part which is so put forth,


---

p.174



but all the rest. And so we see in armour, if any part be left naked, it puts in hazard the whole person. And in the natural body of man, if there be any weak or affected part, it is enough to draw rheums or malign humours unto it, to the interruption of the health of the whole body.


And for the particular, the example is too fresh, that the indisposition of that kingdom hath been a continual attractive of troubles and infestations upon this estate; and though your Majesty's greatness doth in some sort discharge this fear, yet with your increase of power it cannot be, but envy is likewise increased.


The fourth and last consequence is the great profit and strength which is like to redound to your crown, by the working upon this unpolished part thereof: whereof your Majesty, being in the strength of your years, are like, by the good pleasure of almighty God, to receive more than the first-fruits; and your posterity a growing and springing vein of riches and power. For this island being another Britain, as Britain was said to be another world, is endowed with so many dowries of nature, considering the fruitfulness of the soil, the ports, the rivers, the fishings, the quarries, the woods, and other materials; and especially the race and generation of men, valiant, hard, and active, as it is not easy, no not upon the continent, to find such confluence of commodities, if the hand of man did join with the hand of nature. So then for the


---

p.175



excellency of the work, in point of honour, policy, safety, and utility, here I cease.


For the means to effect this work, I know your Majesty shall not want the information of persons expert and industrious, which have served you there, and know the region: nor the advice of a grave and prudent council of estate here; which know the pulses of the hearts of people, and the ways and passages of conducting great actions: besides that which is above all, which is that fountain of wisdom and universality which is in yourself; yet notwithstanding in a thing of so public a nature, it is not amiss for your Majesty to hear variety of opinion: for, as Demosthenes saith well, the good fortune of a prince or state doth sometimes put a good motion into a fool's mouth. I do think therefore the means of accomplishing this work consisteth of two principal parts. The first, the invitation and encouragement of undertakers; the second, the order and policy of the project itself. For as in all engines of the hand there is somewhat that giveth the motion and force, and the rest serveth to guide and govern the same: so it is in these enterprises or engines of estate. As for the former of these, there is no doubt, but next unto the providence and finger of God, which writeth these virtuous and excellent desires in the tables of your Majesty's heart; your authority and affection is primus motor in this cause; and therefore the more strongly and fully your Majesty shall declare


---

p.176



yourself in it, the more shall you quicken and animate the whole proceeding. For this is an action, which as the worthiness of it doth bear it, so the nature of it requireth it to be carried in some height of reputation, and fit, in mine opinion, for pulpits and parliaments, and all places to ring and resound of it. For that which may seem vanity in some things, I mean matter of fame, is of great efficacy in this case.


But now let me descend to the inferior spheres, and speak what co-operation in the subjects or undertakers may be raised and kindled, and by what means. Therefore to take plain grounds, which are the surest: all men are drawn into actions by three things, pleasure, honour, and profit. But before I pursue these three motives, it is fit in this place to interlace a word or two of the quality of the undertakers: wherein my opinion simply is, that if your Majesty shall make these portions of land, which are to be planted, as rewards or as suits, or as fortunes for those that are in want, and are likeliest to seek after them; that they will not be able to go through with the charge of good and substantial plantations, but will deficere in opere medio; and then this work will succeed, as **Tacitus** saith, ‘acribus initiis, fine incurioso.’ So that this must rather be an adventure for such as are full, than a setting up of those that are low of means: for those men indeed are fit to perform these undertakings, which were fit to purchase dry


---

p.177



reversions after lives or years, or such as were fit to put out money upon long returns.


I do not say, but that I think the undertakers themselves will be glad to have some captains, or men of service, intermixed among them for their safety; but I speak of the generality of undertakers, which I wish were men of estate and plenty.


Now therefore it followeth well to speak of the aforesaid three motives. For it will appear the more, how necessary it is to allure by all means undertakers: since those men will be least fit, which are like to be most in appetite of themselves; and those most fit, which are like least to desire it.


First, therefore, for pleasure: in this region or tract of soil, there are no warm winters, nor orange-trees, nor strange beasts, or birds, or other points of curiosity or pleasure, as there are in the Indies and the like: so as there can be found no foundation made upon matter of pleasure, otherwise than that the very general desire of novelty and experiment in some stirring natures may work somewhat; and therefore it is the other two points, of honour and profit, whereupon we are wholly to rest.


For honour or countenance, if I shall mention to your Majesty, whether in wisdom you shall think convenient, the better to express your affection to the enterprise, and for a pledge thereof, to add the earldom of Ulster to the prince's titles, I shall but learn it out of the practice of King Edward I. who first used the like course, as a mean the better to


---

p.178



restrain the country of Wales: and I take it, the prince of Spain hath the addition of a province in the kingdom of Naples: and other precedents I think there are: and it is like to put more life and encouragement into the undertakers.


Also, considering the large territories which are to be planted, it is not unlike your Majesty will think of raising some nobility there; which, if it be done merely upon new titles of dignity, having no manner of reference to the old; and if it be done also without putting too many portions into one hand: and lastly, if it be done without any great franchises or commands, I do not see any peril can ensue thereof. As on the other side, it is like it may draw some persons of great estate and means into the action, to the great furtherance and supply of the charges thereof.


And lastly for knighthood, to such persons as have not attained it; or otherwise knighthood, with some new difference and precedence, it may, no doubt, work with many. And if any man think, that these things which I propound, are aliquid nimis for the proportion of this action, I confess plainly, that if your Majesty will have it really and effectually performed, my opinion is, you cannot bestow too much sunshine upon it. For ‘lunae radiis non maturescit botrus.’ Thus much for honour.


For profit, it will consist in three parts: 
  

First, the easy rates that your Majesty shall be pleased to give the undertakers of the land they shall receive.




---

p.179


Secondly, the liberties which you may be pleased to confer upon them. When I speak of liberties, I mean not liberties of jurisdiction; as counties palatine, or the like, which it seemeth hath been the error of the ancient donations and plantations in that country, but I mean only liberties tending to commodity; as liberty to transport any of the commodities growing upon the countries new planted; liberty to import from hence all things appertaining to their necessary use, custom-free; liberty to take timber or other materials in your Majesty's woods there, and the like.


The third is, ease of charge; that the whole mass of charge doth not rest upon the private purse of the undertakers.


For the two former of these, I will pass them over; because in that project, which with good diligence and providence hath been presented to your Majesty by your ministers of that kingdom, they are in my opinion well handled.


For the third, I will never despair, but that the parliament of England, if it may perceive, that this action is not a flash, but a solid and settled pursuit, will give aid to a work so religious, so politic, and so profitable. And the distribution of charge, if it be observed, falleth naturally into three kinds of charge, and every of those charges respectively ought to have his proper fountain and issue. For as there proceedeth from your Majesty's royal bounty and munificence, the gift of the land, and the other materials; together with the endowment of liberties; and


---

p.180



as the charge which is private, as building of houses, stocking of grounds, victual, and the like, is to rest upon the particular undertakers: so whatsoever is public, as building of churches, walling of towns, town-houses, bridges, causeways, or highways, and the like, ought not so properly to lie upon particular persons, but to come from the public estate of this kingdom; to which this work is like to return so great an addition of glory, strength, and commodity.


For the project itself, I shall need to speak the less, in regard it is so considerately digested already for the county of Tyrone: and therefore my labour shall be but in those things wherein I shall either add to, or dissent from that which is set down; which will include five points or articles.


First, they mention a commission for this plantation: which of all things is most necessary, both to direct, and appease controversies, and the like.


To this I add two propositions: the one, that which perhaps is meant, though not expressed, that the commissioners should for certain times reside and abide in some habitable town of Ireland, near in distance to the country where the plantation shall be; to the end, both that they may be more at hand, for the execution of the parts of their commission; and withal it is like, by drawing a concourse of people and tradesmen to such towns, it will be some help and commodity to the undertakers for things they shall stand in need of: and likewise, it will be a more safe place of receit and store, wherein to


---

p.181



unlade and deposit such provisions as are after to be employed.


The second is, that your Majesty would make a correspondency between the commission there, and a council of plantation here: wherein I warrant myself by the precedent of the like council of plantation for Virginia; an enterprise in my opinion differing as much from this, as Amadis de Gaul differs from Caesar's Commentaries. But when I speak of a council of plantation, I mean some persons chosen by way of reference, upon whom the labour may rest, to prepare, and report things to the council of estate here, that concern that business. For although your Majesty have a grave and sufficient council in Ireland; from whom, and upon whom, the commissioners are to have assistance and dependence; yet that supplies not the purpose whereof I speak. For, considering, that upon the advertisements, as well of the commissioners, as of the council of Ireland itself, there will be many occasions to crave directions from your Majesty and your privy council here, which are busied with a world of affairs; it cannot but give greater expedition, and some better perfection unto such directions and resolutions, if the matters may be considered of aforehand by such as may have a continual care of the cause. And it will be likewise a comfort and satisfaction to some principal undertakers, if they may be admitted of that council.


Secondly, there is a clause wherein the undertakers are restrained, that they shall execute the


---

p.182



plantation in person; from which I must dissent, if I will consent with the grounds I have already taken. For it is not probable that men of great means and plentiful estate will endure the travel, diseasements, and adventures of going thither in person; but rather, I suppose, many will undertake portions as an advancement for their younger children or kinsfolks; or for the sweetness of the expectation of a great bargain in the end, when it is overcome. And therefore, it is like they will employ sons, kinsfolks, servants, or tenants, and yet be glad to have the estate in themselves. And it may be, some again will join their purses together, and make as it were a partnership or joint adventure; and yet man forth some one person by consent, for the executing of the plantation.


Thirdly, there is a main point, wherein I fear the project hath made too much of the line and compass, and will not be so natural and easy to execute, nor yet so politic and convenient: and that is, that the buildings should be sparsim upon every portion; and the castle or principal house should draw the tenements and farms about it as it were into villages, hamlets, or endships; and that there should be only four corporate towns for the artificers and tradesmen.


My opinion is, that the buildings be altogether in towns, to be compounded, as well of husbandries as of arts. My reasons are, 


First, when men come into a country vast, and void of all things necessary for the use of man's life,


---

p.183



if they set up together in a place, one of them will the better supply the wants of another: work-folks of all sorts will be the more continually on work without loss of time; when, if work fail in one place, they may have it fast by; the ways will be made more passable for carriages to those seats or towns, than they can be to a number of dispersed solitary places; and infinite other helps and easements, scarcely to be comprehended in cogitation, will ensue in vicinity and society of people; whereas if they build scattered, as is projected, every man must have a cornucopia in himself for all things he must use; which cannot but breed much difficulty, and no less waste.


Secondly, it will draw out of the inhabited country of Ireland provisions and victuals, and many necessaries; because they shall be sure of utterance: whereas in the dispersed habitations, every man must reckon only upon that that he brings with him; as they do in provisions of ships.


Thirdly, the charge of bawns, as they call them, to be made about every castle or house, may be spared, when the habitations shall be congregated only into towns.


And lastly, it will be a means to secure the country against future perils, in case of any revolt and defection: for by a slight fortification of no great charge, the danger of any attempts of kernes and sword-men may be prevented; the omission of which point, in the last plantation of Munster, made the work of years to be but the spoil of days. And


---

p.184



if any man think it will draw people too far off from the grounds they are to labour, it is to be understood, that the number of the towns be increased accordingly; and likewise, the situation of them be as in the centre, in respect of the portions assigned to them: for in the champaign countries of England, where the habitation useth to be in towns, and not dispersed, it is no new thing to go two miles off to plough part of their grounds; and two miles compass will take up a good deal of country. 


The fourth point, is a point wherein I shall differ from the project rather in quantity and proportion, than in matter. There is allowed to the undertaker, within the five years of restraint, to alien a third part in fee farm, and to demise another third for forty years: which I fear will mangle the portions, and will be but a shift to make money of two parts; whereas, I am of opinion, the more the first undertaker is forced to keep in his own hands, the more the work is like to prosper. For first, the person liable to the state here to perform the plantation, is the immediate undertaker. Secondly, the more his profit dependeth upon the annual and springing commodity, the more sweetness he will find in putting forward manurance and husbanding of the grounds, and therefore is like to take more care of it. Thirdly, since the natives are excluded, I do not see that any persons are like to be drawn over of that condition, as are like to give fines, and undertake the charge of building. For I am persuaded, that the people transported will consist of gentlemen and


---

p.185



their servants, and of labourers and hinds, and not of yeomen of any wealth. And therefore the charge of buildings, as well of the tenements and farms, as of the capital houses themselves, is like to rest upon the principal undertakers. Which will be recompensed in the end to the full, and with much advantage, if they make no long estates or leases. And therefore this article to receive some qualification.


Fifthly, I should think it requisite that men of experience in that kingdom should enter into some particular consideration of the charges and provisions of all kinds, that will be incident to the plantation; to the end, that thereupon some advice may be taken for the furnishing and accommodating them most conveniently, aiding private industry and charge with public care and order.


Thus I have expressed to your Majesty those simple and weak cogitations, which I have had in myself touching this cause, wherein I most humbly desire your pardon, and gracious acceptance of my good affection and intention. For I hold it for a rule, that there belongeth to great monarchs, from faithful servants, not only the tribute of duty, but the oblations of cheerfulness of heart. And so I pray the Almighty to bless this great action, with your Majesty's care; and your care with happy success.




---

p.??


Letter of Sir Francis Bacon to King James, 2 July 1613.
-------------------------------------------------------


### *Folger Shakespeare Library, MS X.d. 158.*

It may please your excellent Majesty.
I am bold to send your Majesty some poor fruits of my diligence, in drawing up a little breviat of the Irish business, wherein your Majesty at the last hearing did acquit yourself so happily to the just admiration of us all. If it may be, of any the least use, to your Majesty's singular judgement, to whom I only do m[ake] it, I shall be very glad; howsoever your Majesty will be graciously pleased to accept of my good mind and affection. For amicus non feriatur. So in all true humbleness, I rest


Your Majesty's most loyal and devoted servant,


Fr. Bacon
2 July 1613


---

p.??


{MS fo. 161r}The charge of the party parliament in Ireland which brake and receded from parliament there assembled and after came to justify and excuse the same by Sir Francis Bacon, his Majesty's Solicitor, before his Majesty sitting in council, where the delinquents were convented.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


### *?July 1613*

#### *The Pierpont Morgan Library, MA 1160 (Collections of charges and speeches by Francis Bacon), no. 13, ff.161–71*

##### *(By permission of the Pierpont Morgan Library).*


It is the duty of Mr Attorney and myself according to our place and oath to prosecute and charge any subject whatsoever without respect of persons which shall condemn or oppose your Majesty's authority, and this to do not only towards particular persons, but if there shall be any party or combination of subjects which shall lift up their horn to high we are by showing them the danger of your Majesty's laws to bring them to an acknowledgement of their fault and duty.


And though your Majesty's sacred person doth in itself after a sort portend grace (because a prosecution with severity has been more fit for your Courts of Justice) yet that (under your Majesty's favour) ought not to alter our part but that we should open and represent to the quick, the true state and weight of the offences{MS fo. 161v}
 
which we shall now charge; that either your Majesty's justices may be thereby better grounded, if your highness shall suffer your laws to pass or your clemency the better perceived if you shall like to extend it.


The great offences wherewith these noblemen and gentlemen have been in part by Mr Attorney and shall be by me charged are bound up (for the most part) in this generality of nature and scope. That they tended to the disturbing, crossing and traducing of the parliament in Ireland called by your Majesty. Of which your Majesty's design, I can not in passage but use a few words.


After that your Majesty cast out that Archrebel Tyrone who in his last actions adds ingratitude to consummate his vices and treasons; and after your Majesty had with great felicity suppressed the rebellion of O'Doherty and Tyrconnell, that was like the stirring and motion of the residue of a serpent's body (when the head is stricken off); and after your Majesty had broken and severed other heads of danger, and acquainted the people with a more immediate dependence upon yourself the estate and made your writ run where sword could scarce make way{MS fo. 162r}
 
before; what rested then to do but to settle things by parliament for your Majesty knew well in your wisdom that there remained yet unto you, a great contention not with persons but with the nature of things with the corruption of religion and manners with the licentious living of soldiers with the oppression of petty and base ministers, and sundry other disorders, which were the relics of inveterate troubles. And for all these there was no better remedy than a parliament not more agreeable to the office of a wise and just king.


The purpose and act of your Majesty being so just, gracious and worthy of yourself hath been in ill time interrupted by these delinquents and other of their party. How they myned against it before the parliament assembled hath been delivered by Mr Attorney who brought the cause in distribution of time to the very next approach of the parliament which the 17th of May last being the end and vigil of the parliament. I shall follow the order of time and set forth before your Majesty the actual breach made in{MS fo. 162v}
 
Parliament accompanied with sundry circumstances of disobedience, and undutiful carriage. These high contempts and disorders appear in the evidence of several writings, and were continued as the acts of 4 immediate succeeding days the 19th, 20th, 21th and 22nd of May in every of which days, there were (as it were) so many violent fits of distemper and that sine signo sanitatis without any good sign of health that I can find save only one which was that in the end they appealed to your Majesty and craved license of access to your presence and princely audience. And yet nevertheless to show again that the change of air did no good in this disease, I shall show your Majesty some passages in two petitions made by the agents since their coming into England no less dangerous than any of the former conceived in Ireland. But before I descend to particulars, I beseech your Majesty to give me leave to say thus much in general and that very brief. First of the persons I do not behold or esteem those lords from whom my Lord of Gormanston and my Lord of Dunboyne have procuration nor likewise those members of the lower house from whom Mr Talbott and the rest of those agents are sent as Houses of Parliament. And yet even Houses of Parliament were they never so full and united, ought to contain themselves within the {MS fo. 163r}
 
bounds of duty and modesty towards their Sovereign both in matter and manner. But that it is not this case. I behold those persons or parties whatsoever they may attribute to themselves Quis panxit leonem but a fraction or schism of a parliament, they being the minor part of either house. Neither do I doubt but even within the party, there is a great difference in affections. For to speak plainly, I never saw men offend in numbers but that error and example misled the greater part and that inward malice and guiltiness rested but upon a few. But that destruction is fitter for your Majesty's censure or grace than for our charge.


As for the facts themselves, I will not define them with the danger of them but certainly I will describe them thus far, that if in any particular man of this party there should appear disloyalty of intent to be coupled with overt act of contempt, it mought cost that man dear, nay as the acts themselves stand, if it had been in some other times of a severer strain, perchance they would have been questioned not as contemptuous only but as seditious. Now to the particulars themselves.


As for the facts themselves, I will not define them with the danger of them but certainly I will describe them thus far, that if in any particular man of this party there should appear disloyalty of intent to be coupled with overt act of contempt, it mought cost that man dear, nay as the acts themselves stand, if it had been in some other times of a severer strain, perchance they would have been questioned not as contemptuous only but as seditious. Now to the particulars themselves.


[9](javascript:footNote('E600001-015/note009.html')) First 19 May 1613 which was the morrow after the parliament begun, eleven of the upper house, amongst whom the lords here present whereof the number did write over hither a letter directed to Your Majesty's self swelling in a presumptuous insolent style, evil becoming subjects towards their Sovereign so high and mighty Monarch, the words are such as the very echo of hearing again of their own words reported{MS fo. 163v}
(now the fit is of) me thinks should astonish them and make them confused.


In this letter they term the proceedings held towards them this Parliament more than ‘preposterous courses’ and in another passage, ‘strange unlooked for and never heard of course’. These be indeed strange and unlooked for invectives and scandals from subjects who, if they complain out, to do it another language. In the entrance of the letter, they make a suit to your Majesty, that if many respects (which they reckon up) do carry them in ought ‘beyond the limits of a well-tempered moderation would be gratiously pleased to pardon their excess, so far as pius dolor and Iusta Iracundia do in themselves deserve’. What phrases call you these? For pius dolor, it may pass but Iusta Iracundia. What you that speak it, you are towards our great Master but as clay in the hands of a potter, or as a head of glass to a head of brass. It were a fit suit for me and it please your Majesty to make unto you, that in showing them their faults if just indignation do transport me, I may be pardoned; for no man that hath good blood in him can speak with patience in a case of so intolerable presumption. You talk of Iusta Iracundia, I tell you if King James's just wrath{MS fo. 164r}
 
be kindled (yeah, but a little) they will be only happy that trust upon his mercy. In the same letter is set forth a general discontent not against the new corporations or boroughs but against the new plantations themselves, which was your Majesty's most Christian and blessed act. Of which plantations, I will only say this by the way. your Majesty doth not displant people to implant others but you introduce people were none were, or at least not in any complete proportion to inhabit and manure the land. Nay, the natives themselves are a great portion of the plantations. The rest bring wealth into the kingdom, they take none forth; that will be soon perceived when the new nourishment will run into the old veins. But certainly this I will affirm, this is not amongst the acts of kings under the sun, an act of truer glory and merit than the act of plantation of people, for a founder of an state is more than a benefactor, to plant is more than to water, and to introduce people is more than to comfort and protect people. And therefore these little emulations will no doubt quickly{MS fo. 164v}
 
cease, and your subjects both of old and new plantations will find their case and condition infinitely amended and grew up together into a mighty nation.


Lastly in the close of this Letter, I find a clause to this effect: ‘We cannot but make known to your Majesty, if the general discontent which these courses have generally bred, whereof if the rebellions and discontented of the nation abroad do take advantage and procure the evil-affected at home, which are numbers (by reason of these already set and intended plantations) in any hostile fashion to set discord on foot and labour, some underhand relief from any prince or estate abroad was peradventure mought be inveigled and drawn to commiserate their pretended distresses and oppression (howsoever we are assured the prowess and power of your Majesty will in the end bring the author thereof to ruin and confusion, yet will all things be brought to a great combustion’, and so great tragedies will follow. I hope you had no ill meaning in this but it is a strange alarm bell{MS fo. 165r}
rung out by subjects' complaint. Nay, you do as it were \_\_\_\_ and teach the method of a rebellion and the degrees and sequences of it, I remember Solon, when he was asked why he had not made any law against parricide, he said he was not willing to put men in mind of it. Me thinks you need (for these letters and copies will fly) put men in mind of it, as for the menace itself (for it is no letter) you will soon find (if that should be) that our sovereign to whom you truly attribute prowess and magnanimity and who is mounted upon the empire of the most martial nations of the world, will soon have his reason of any of his subjects, that shall sake the yoke, or any foreigner their support.


[10](javascript:footNote('E600001-015/note010.html')) The same 19th day, and as it seemeth with the same spirit, there was written and sent a petition (with a declaration annexed) from the party of the lower house directed to the Lords of the Council here wherein because they run much{MS fo. 165v}
upon the same string with the letter of the lords to the king, I will only extract 2 places which are proper to that letter.


The one that they complain of their own wrong. They had, I mean this party being the minor part of the house which was returned into the crown office upon record which is the warrant at least prima facie till expiration, by a trick or stratagem while the major part was gone forth to number themselves, placed Mr Everard in the chair of the Speaker and they complain that he was by force as they term it, taken forth of the chair, this was no force but a repulse of redress or force, if one without authority should come and sit down in one of the judges' places in the King's Bench or Common Pleas, I hope it were no violation of that court to pull him forth but rather precedent.


The second is that they exaggerate their case with such hyperbole and a tempest of rhetoric, as in one place{MS fo. 166r}
they say, ‘Their extremities are so strange as they can find no words to express them’ and in another place that ‘That they are hardly to believed, being for likelihood of impossibility equal to that of Messalina, the wife of the Emperor Claudius in ancient Rome, or to any other accident so rare so ever transmitted to posterity’. This example (I knew the place well) but it so absurd and extravagant meeting with the case in nothing but as the 7 wonders met because they were strange things though one \_\_\_\_\_ and another at Rhodes that a man would think he had \_\_\_\_\_that penned it, save that it is the humour of some to show most reading when they show least wit and to bolt out a saying or a story whether it hit or miss.


[11](javascript:footNote('E600001-015/note011.html')) To proceed to the 20th (for here were Nullus sine crimine dies) I shall set forth to your Majesty a very great presumption and contempt and fit to be looked to in time (for it may climb high) the party in the lower{MS fo. 166v}
house desire my Lord Deputy may have sight and perusal of your Majesty's letter of direction to his lordship touching the corporations and of the \_\_\_\_\_ which are the warrants to the learned counsel for passing their patents as if the party in Parliament should require the sight of the warrants made to Mr Attorney & myself for passing. T*h*is is a presumption not tolerable subjects to intermit themselves into the king's secrets, which are Arcana Imperii, your letters to your deputy are letters of state and counsel, the warrants of learned counsel are secrets of their craft and office. Of these things the one and the other are accountable to your Majesty alone, if any will come between, he must take his answer: Tu quis es qui iudicas servum alienum? Domino suo stat vel cadit, letters patents, records are for the subjects' access but not letters, instructions warrants.


Now come I to the 21st of May at which time this party of the lower house, which the day before would see and seek further than appertained to them will now give law in a fashion to the Deputy{MS fo. 167r}
and capitulate and treat with him upon what conditions, they will repair a parliament which followeth in these words. 'We do offer to your lordship, who carrieth the sway of this realm for his Highness that if we, duly elected and returned, may by your lordship's means be secured in our persons and that we may have benefit of the laws of the kingdom and of the ancient freedom, course and custom of former parliaments held therein with the censuring of the unduly elected, or that have unlawfully intruded into the lower house of parliament together with the determining of the abuses therein committed (all which are proper unto us) but a beginning of liberty, and license for conditional obedience is the first step to absolute disobedience. And their conclusion is pretty, for it is as much to say as if you will yield to us in all we require, we will do as shall please us. For they do not so much as{MS fo. 167v}
make any submission of the point of the Speaker which stood namely \_\_\_\_\_ but in effect make both parts of the article what they will have and what they will do. And certainly these contempts are the greater, because I do not find in the answers or otherwise in the carriage of my Lord Deputy's matter of provocation but a moderate and discrete proceeding.


[12](javascript:footNote('E600001-015/note012.html')) For the 22nd was as it were the state, or heights, of this disease after which succeeded an actual convulsion and rupture of the parliament, there is a petition exhibited to the Lord Deputy by the lords wherein though in few words, there are notable contempts.


First they say that the king's honour will be brought in question 'every day when in execution of the laws now to be made, they shall be cried out against by the subject, as unjustly and disorderly made'. So as now they will have the state in a dilemma, either we shall break the parliament or not, if we break it{MS fo. 168r}
we have our ends, if we break it not, we shall raise such a murmur of the people against it as they shall have little joy of it.


The second is, they fall upon a flat directly and dash upon the rock of your Majesty's authority by an express negative, ‘we purpose to come no more to the parliament until *his* Highness hath taken some course for the better settling of things’. So as here is plainly an actual departure, withdrawing off.


And thirdly, because it may not be thought to be a sudden passion, they make their judgements subscribe to their will and judge themselves adding these words: ‘Neither do we think it presumption in us to signify to your Lordship as much’. So as here is now a feared offence with a hot iron, that there resteth no feeling of it. But that was then. I hope since and now they will have that feeling of their fault, as they will prostrate themselves before your Majesty's grace and clemency which they have tempted certainly very far.


{MS fo. 168v}
So that the last Act and conclusion of this process was that both parties in the upper and lower house without licence obtained merely in contumacy and obstinacy, left the parliament which to do how great an offence, it is in itself though not clad with these circumstances, and how great persons have smarted for it by din and ransom in the King's Bench, Mr Talbot and Mr FitzHarris can tell or if they can not, I can.


And certainly this these contempts had a train and was greatly aggravated by two following circumstances, the one that it was continued after his Majesty's proclamation, which came forth the same day whereby the party in both houses were warned upon their allegiance to repair to their houses. The other that having knowledge that the bill of recognition was according to the manner first to be read in the upper house and so to come down to the lower (which ought to have moved them to have{MS fo. 169r}
laid aside all contestation at least till they had performed duty), yet they so obstinate as that moved them nothing but they thought to salve it by an informal and perfunctory and indeed idle recognition in paper.


Whereas that act being an act which added nothing nor can add nothing to his Majesty's inherent right is only a gratulatory declaration and therefore ought to be performed in due solemnity.


And this hath been the periods of these contempts heaped up in these four days and appearing in the writing by \_\_\_\_ truly vouched and ready to be shown for so much as passed in Ireland.


There remaineth only a point which I mentioned before, how these offences were not cleared by the fire of England, but plain it was according to the verse ‘Caelum non a*nimum* mutant’[13](javascript:footNote('E600001-015/note013.html')) for I find in a petition preferred the 12th of June to your Majesty by their agents here these words: ‘That by the courses held towards them, way is laid open to the infringing of those moderate liberties and privileges which the subjects of his Majesty's kingdoms of England and Ireland have enjoyed since{MS fo. 169v}
the first institution of the laws by which they are governed’. All which tendeth most dangerously and factiously to make further party and to sow the seeds of scandal and discontent, even within the kingdom of England, and most causeless is this scandal, for whosoever hath known your Majesty's parliaments and parliaments of former times which myself hath done, having been a parliament ever since 23 Eliz., now 32 years, will give this testimony that in the time of King James liberties of parliament have been ampliate and enlarged and not infringed or restrained. And the like scandal is included in another petition, 22 June, whereby they prayed counsel to be.


Thus, having opened truly unto your Majesty, the state of the offences wherewith these delinquents are to be charged over and besides that part, which Mr Attorney formerly charged, I most humbly leave them to be made an example of your Majesty's grace or justice according to your royal will and pleasure.


I must conclude with a particular person, Thomas Luttrell, who by that which already{MS fo. 170r}
appeareth hath been a turbulent and audacious instrument in all these businesses. Mr Attorney hath showed how he demanded his wages, but I will show you, he deserved his wages.


This gentleman after Mr Deputy had made an honourable and me thinks seemed a liberal answer to the petition of 21; that they should censure of the miselections and misreturns and willed them to go to their house and present their Speaker. Luttrell gets into his head a captious reply by way of petition: 'We hope your lordship means us only of the ancient boroughs to be the house, that Everard's our speaker' fastening upon my Lord Deputy's own conceits, forgetting the saying Maledicta glossa que corrumpit Textum. But the acting is all.{MS fo. 170v}
He cometh with this petition into the upper house when my Lord Deputy was in the robes of state, representing your Majesty's sacred person and all the nobles and prelates likewise robed, a fair theatre for Mr Luttrell to play his part. He comes to my Lord Deputy in that state without reverence in a mutinous manner, and contained not himself within his errand or petition, but falleth to challenge and quarrel with my lord deputy touching the new corporations. My lord discretely and soberly answered your Majesty mought as lawfully create new boroughs as new counties. Luttrell in a gallant manner as if he had been a tribune of the people replies, we are content with the counties. Whereunto my lord chief justice, a grave and temperate man, yet stoutly as a chief justice should in such a presence and time gave him his own, and told him it was a traitorous speech to make your Majesty's power a dependent upon their contentment. Then fell Luttrell to comparisons and reprehended by my Lord of Thomond, a worthy peer of that kingdom and servant of your Majesty, braved him likewise. But such was the affront as my Lord Deputy had almost forgot the sword of state and thought of the sword of a soldier, all the presence was at a gaze and a wonder, and my Lord{MS fo. 171r}
Chief Justice took him upon the place, a recognizance of £5,000 to be forthcoming. And yet this man must have his wages, if your Majesty send him to the Tower of London, that is his deserved wages, the Mint is not far off. I could speak of his pilgrimages but I stay here and leave him to your Majesty's princely consideration and justice.




---

p.386


Letter of Francis Bacon to King James, 13 August 1613
-----------------------------------------------------


### *Spedding, Letters & Life, IV, 386–7*

To the King's Most Excellent Majesty.
It may please your most excellent Majesty,
  

I was at my house in the country what time the Commissioners and Instructions for Ireland were drawn by Mr. Attorney, but I was present this day the forenoon when they were read before my Lords; and excepted to some points, whereof use was made, and some alterations followed. But I could not in decency except to so much as I thought there mought be cause, lest it mought be thought an humour contradiction or an effect of emulation; which I thank God I am not much troubled with. For so your Majesty's business be well done, whosoever be the instrument, I rest joyful. But because this is tender piece of service, and that which was well directed by your Majesty's high wisdom may be marred in the manage, and that I have been so happy as to have my poor service in this business of Ireland (which I have minded with all my powers, because I thought your estate laboured), graciously accepted by your sacred Majesty, I do presume to present to your Majesty's remembrance (whom I perceive to be one of the most truly politic princes that ever reigned, and the greatest height of my poor abilities is but to understand you well) some few points in a memorial[14](javascript:footNote('E600001-015/note014.html')) enclosed, which I wish to be changed.


They tend to this scope principally; that I think it safest for your Majesty at this time, hoc agere: which is to effect that you may hold a Parliament in Ireland with sovereignty, concord and contentment, and moderate freedom, and so bind up the wound made, without clogging the commission with too many other matters, and to take in other points of the grievances


---

p.387



but obiter. Whereas these instructions are so marshalled as if the grievances were the principal; the grievances which were not commended to these messengers from the party in Ireland, but slept at least a month after their coming hither, and were hatched by these busybodies as fructus nimii otii, and are divers of them of so vulgar a nature as they are complained of both in England and Ireland, and both now and at all times. For your Majesty to give way upon this ground to so particular an enquiry of all these points, I confess I think is inferius Majestate, for they are set down like interrogatories in a suit in law.


And my fear is they will call up and stir such a number of complaints and petitions, (which not being possible to be satisfied), this commission meant for satisfaction will end in murmur. But these things which I write are perhaps but my errors and simplicities. Your Majesty's wisdom must steer and ballast the ship. So most humbly craving pardon, I ever rest.


Your Majesty's most devote and faithful subject and servant,


Fr. Bacon
13 August 1613


---

p.??


Answer to English Privy Council as to the administering the oath of allegiance to Irish delegates in England, 13 October 1613
-----------------------------------------------------------------------------------------------------------------------------


### *UK National Archives, Kew, SP63/232, no. 19*

It may please your lordships.
We are of opinion that the Oath of Allegiance by law is not to be ministered to any his Majesty's subjects in Ireland, parliament men or others, by way of compulsion, because the Statute concerning the same is not in force there.


But we are of opinion that by the Statute of 3rd of his Majesty's reign, the said Oath may bee tendered to any of the Irish here either by the Bishop of London, or by two Justices of the Peace (whereof one to be of the quorum) in case it shall appear by the parties confession or otherwise that they have not received the communion twice this last year.


And by the Statute of the 7th, 2 Justices of peace whereof one to be of the quorum may tender the said oath unto them, without respect had, whether they be not communicants or no.


Nevertheless whether it be convenient to minister it unto them not being persons commorant, and settled here, but only employed for the present business, we must leave it unto his Majesty's and your Lordships' better judgements.


 Henry Hobart.
Fran. Bacon
October 12th 1613
 Endorsed:
 About the Oath of Allegiance, if to the Irish in
 England.



---

p.??




---

p.420


The charge of Sir Francis Bacon knight his Majesty's Attorney General against William Talbot a counsellor at Law of Ireland in an information in the Star Chamber, ore tenus, for a writing under his hand, whereby the said William Talbot being demanded whether the doctrine of Suarez touching deposing and killing of kings excommunicated were true or no. He answered that he referred himself unto that which the Catholic Roman Church should thereof judge.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


### Ultimo termino Hillarii, undecimo Jacobi Regis

#### *Montagu, Works of Bacon, IV, 420–8.*

March 1614 My Lords,
I brought before you the first sitting of this term the cause of duels; but now this last sitting I shall bring before you a cause concerning the great duel which is in the Christian world, the duel and conflict between the lawful authority of sovereign kings, which is God's ordinance for the comfort of human society, and the swelling pride and usurpation of the see of Rome in temporalibus, tending altogether to anarchy and confusion. Wherein if this pretence in the Pope of Rome, by cartels to make sovereign princes as the banditti, and to proscribe their lives, and to expose their kingdoms to prey; if these pretences, I say, and all persons that submit themselves to that part of the Pope's power in the least degree, be not by all possible severity repressed and punished, the state of Christian kings will be no other than the ancient torment described by the poets in the hell


---

p.421



of the heathen; a man sitting richly robed solemnly attended, delicious fare, etc. with a sword hanging over his head, hanging by a small thread, ready every moment to be cut down by an accursing and accursed hand. Surely I had thought they had been the prerogatives of God alone, and of his secret judgements: ‘Solvam cingula regum,’ ‘I will loosen the girdles of kings’: or again, ‘He poureth contempt upon princes;’ or ‘I will give a king in my wrath, and take him away again in my displease’; and the like: but if these be the claims of a mortal man, certainly they are but the mysteries of that person which ‘exalts himself above all that is called God,’ ‘supra omne quod dicitur Deus.’ Note it well, not above God, though in a sense be true, but ‘above all that is called God;’ that is, lawful kings and magistrates.


But, my lords, in this duel I find this Talbot, that is now before you, but a coward; for he hath given ground, he hath gone backward and forward; but in such a fashion, and with such interchange of repenting and relapsing, as I cannot tell whether it doth extenuate or aggravate his offence. If he shall more publicly in the face of the court fall and settle upon a right mind, I shall be glad of it; and he that would be against the king's mercy; but nevertheless the court will proceed by rules of justice.


The offence therefore wherewith I charge this Talbot, prisoner at the bar, is this in brief and in effect: That he hath maintained and maintaineth under his hand, a power in the Pope for deposing and murdering of kings. In what sort he doth this, when I come to the proper and particular charge, I will deliver it in his own words without pressing or straining.


But before I come to the particular charge of this man, I cannot proceed so coldly; but I must express unto your lordships the extreme and imminent danger wherein our dear and dread Sovereign is, in him we all; nay, all princes of both religions, for it is a common cause, do stand at this day, by the spreading


---

p.422



and inforcing of this furious and pernicious opinion of the pope's temporal power: which though the modest sort would blanch with the distinction of in ordine ad spiritualia yet that is but an elusion; for he that maketh the distinction, will also make the case. This peril, though it be in itself notorious, yet because there is a kind of dullness, and almost a lethargy in this age, give me leave to set before you two glasses, such as certainly the like never met in one age; the glass of France, and the glass of England. In that of France the tragedies acted and executed in two immediate kings; in the glass of England, the same, or more horrible, attempted likewise in a queen and king immediate, but ending in a happy deliverance. In France, Henry III, in the face of his army, before the walls of Paris, stabbed by a wretched Jacobine friar. Henry IV, a prince that the French do surname the Great, one that had been a saviour and redeemer of his country from infinite calamities, and a restorer of that monarchy to the ancient state and splendour, and a prince almost heroical, except it be in the point of religion, at a time when he was as it were to mount on horseback for the commanding of the greatest forces that of long time had been levied in France, this king likewise stillettoed by a rascal votary, which had been enchanted and conjured for the purpose.


In England, Queen Elizabeth, of blessed memory, a Queen comparable and to be ranked with the greatest kings, oftentimes attempted by like votaries, Sommerville, Parry, Savage, and others, but still protected by the watchman that slumbereth not. Again, our excellent sovereign King James, the sweetness and clemency of whose nature were enough to quench and mortify all malignity, and a king shielded and supported by posterity; yet this king in the chair of Majesty, his vine and olive branches about him, attended by his nobles and third estate in parliament; ready in the twinkling of an eye, as if it had been a particular doomsday, to have been brought to ashes, dispersed to the four winds. I noted the last day,


---

p.423



my lord chief justice, when he spoke of this powder treason, he laboured for words; though they came from him with great efficacy, yet he truly confessed, and so must all men, that that treason is above the charge and report of any words whatsoever.


Now, my lords, I cannot let pass, but in these glasses which I spoke of, besides the facts themselves and danger, to show you two things; the one, the ways of God Almighty, which turneth the sword of Rome upon the kings that are the vassals of Rome, and over them gives it power; but protecteth those kings which have not accepted the yoke of his tyranny, from the effects of his malice: the other, that, as I said at first, this is a common cause of princes; it involveth kings of both religions; and therefore his Majesty did most worthily and prudently ring out the alarm-bell, to awake all other princes to think of it seriously, and in time. But this is a miserable case the while, that these Roman soldiers do either thrust the spear into the sides of God's anointed, or at least they crown them with thorns; that is, piercing and pricking cares and fears, that they can never be quiet or secure of their lives or states. And so this peril is common to princes of both religions, so princes of both religions have been likewise equally sensible of every injury that touched their temporals.


Thuanus reports in his story, that when the realm of France was interdicted by the violent proceedings of Pope Julius the Second, the king, otherwise noted for a moderate prince, caused coins of gold to be stamped with his own image, and this superscription, ‘Perdam nomen Babylonis e terra.’ Of which Thuanus saith himself had seen divers pieces thereof. So as this catholic king was so much incensed at that time, in respect of the Pope's usurpation, as he did apply Babylon to Rome. Charles the Fifth, emperor, who was accounted one of the Pope's best sons, yet proceeded in matter temporal towards Pope Clement with strange rigour: never regarding the pontificality, but kept him prisoner thirteen months in a pestilent prison: and was hardly dissuaded by his council from


---

p.424



having sent him captive into Spain: and made sport with the threats of Frosberg the German, who wore a silk rope under the cassock, which he would show in all companies; telling them that he carried it to strangle the Pope with his own hands. As for Philip the Fair, it is the ordinary example, how he brought Pope Boniface the Eighth to an ignominious end, dying mad and enraged; and how he styled his rescript to the Pope's bull, whereby he challenged his temporals, Sciat fatuitas vestra, not your beatitude, but your stultitude; a style worthy to be continued in the like cases; for certainly that claim is mere folly and fury. As for native examples, here is too long a field to enter into them. Never kings of any nation kept the partition-wall between temporal and spiritual better in times of greatest superstition: I report me to King Edward I that set up so many crosses, and yet crossed that part of the Pope's jurisdiction, no man more strongly. But these things have passed better pens and speeches; here I end them.


But now to come to the particular charge of this man, I must inform your lordships the occasion and nature of this offence: There hath been published lately to the world a work of Suarez, a Portuguese, a Professor in the university of Coimbra, a confident and daring writer, such an one as Tully describes in derision; ‘nihil tam verens, quam ne dubitare aliqua de re videratur: one that fears nothing but this, lest he should seem to doubt of any thing’. A fellow that thinks with his magistrality and goose-quill to give laws and menages to crowns and sceptres. In this man's writing this doctrine of deposing or murdering kings seems to come to a higher elevation than heretofore; and it is more arted and positived than in others.


For in the passages which your lordships shall hear read anon, I find three assertions which run not in the vulgar track, but are such as wherewith mens ears, as I suppose, are not much acquainted; whereof the first is, That the Pope hath a superiority over kings, as subjects, to depose them; not only for spiritual crimes, as heresy and schism,


---

p.425



but for faults of a temporal nature; forasmuch as a tyrannical government tendeth ever to the destruction of souls. So by this position, kings of either religion are alike comprehended, and none exempted. The second, that after a sentence given by the Pope, this writer hath defined of a series, or succession, or substitution of hangmen, or bourreaux, to be sure, lest an executioner should fail. For he saith, that when a king is sentenced by the Pope to deprivation or death, the executioner, who is first in place, is he to whom the Pope shall commit the authority, which may be a foreign prince, it may be a particular subject, it may be general to the first undertaker. But if there be no direction or assignation in the sentence special nor general, then, de jure, it appertains to the next successor, a natural and pious opinion; for commonly they are sons, or brothers, or near of kin, all is one; so as the successor be apparent; and also that he be a Catholic. But if he be doubtful, or that he be no catholic, then it devolves to the commonalty of the kingdom; so as he will be sure to have it done by one minister or other. The third is, he distinguisheth of two kinds of tyrants, a tyrant in title, and a tyrant in regiment; a tyrant in regiment cannot be resisted or killed without a sentence precedent by the Pope; but a tyrant in title may be killed by any private man whatsoever. By which doctrine he hath put the never so clean but that some vain quarrel or exception may be made unto them, upon the fancy of every private man; and also couples the judgement and execution together, that he may judge him by a blow, without any other sentence.


Your lordships see what monstrous opinions these are, and how both these beasts, the beast with seven heads and the beast with many heads, Pope and people, are at once let in, and set upon the sacred persons of kings.


Now to go on with the narrative; there was an extract made of certain sentences and portions of this book, being of this nature that I have set forth, by a


---

p.426



great prelate and counsellor, upon a just occasion; and there being some hollowness and hesitation in these matters, wherein it is a thing impious to doubt, discovered and perceived in Talbot; he was asked his opinion concerning these assertions, in the presence of the best; and afterwards they were delivered to him, that upon advice, and sedato animo, he might declare himself. Whereupon, under his hand, he subscribes thus:


> May it please your honourable good lordships.
> Concerning this doctrine of Suarez, I do not perceive, by what I have read in this book, that the same doth concern matter of faith, the controversy growing upon exposition of Scripture and councils, wherein being ignorant and not studied, I cannot take upon me to judge; but I do submit my opinion therein to the judgement of the catholic Roman church, as in all other points concerning faith I do. And for matter concerning my loyalty, I do acknowledge my Sovereign liege Lord King James, to be lawful and undoubted king of all the kingdoms of England, Scotland and Ireland; and I will bear true faith and allegiance to his Highness during my life.
> 
> 
> William Talbot.




My lords, upon these words I conceive Talbot hath committed a great offence, and such a one, as if he had entered into a voluntary and malicious publication of the like writing, it would have been too great a offence for the capacity of this court. But because it grew by a question asked by a council of estate, and so rather seemeth, in a favourable construction, to proceed from a kind of submission to answer, than from any malicious or insolent will; it was fit, according to the clemency of the times, to proceed in this manner before your lordships: and yet let the hearers take these things right; for certainly, if a man be required by the council to deliver his opinion whether King James be king or no? and he deliver his opinion that he is not, this is high treason: but I do not say that these words amount to that; and therefore let me upon them truly to your lordships, and therein open


---

p.427



also the understanding of the offender himself, how far they reach.


My lords, a man's allegiance must be independent and certain, and not dependent and conditional. Elizabeth Barton that was called the holy maid of Kent, affirmed, that if King Henry VIII, did not take Catharine of Spain again to his wife within a twelvemonth, he should be no king: and this was treason. For though this act be contingent and future, yet the preparing of the treason is present.


And in like manner, if a man should voluntarily publish or maintain, that whensoever a bull of deprivation shall come forth against the king, that from thenceforth he is no longer king; this is of like nature. But with this I do not charge you neither; but this is the true latitude of your words, That if the doctrine touching the killing of kings be matter of faith, then you submit yourself to the judgement of the catholic Roman church: so as now, to do you right, your allegiance doth not depend simply upon a sentence of the Pope's deprivation against the king; but upon another point also, if these doctrines be already, or shall be declared to be matter of faith. But, my lords, there is little won in this: there may be some difference to the guilt of the party, but there is little danger to the king. For the same Pope of Rome may, with the same breath, declare both. So as still, upon the matter, the king is made but a tenant at will of his life and kingdoms; and the allegiance of his subjects is pinned upon the Pope's acts. And certainly, it is time to stop the current of this opinion of acknowledgement of the Pope's power in temporalibus; or else it will sap and supplant the seat of kings. And let it not be mistaken, that Mr. Talbot's offence should be no more than refusing the oath of allegiance. For it is one thing to be silent, and another thing to affirm. As for the point of matter of faith, or not of faith, to tell your lordships plain, it would astonish a man to see the gulf of this implied belief. Is nothing excepted of it? If a man should ask Mr. Talbot, whether he do condemn


---

p.428



murder, or adultery, or rape, or the doctrine of Mahommet, or of Arius, instead of Suarez? Must the answer be with this exception, that if the question concern matter of faith, as no question it doth, for the moral law is matter of faith, that therein he will submit himself to what the church shall determine? And, no doubt, the murder of princes is more than simple murder. But to conclude, Talbot, I will do you right, and I will not be reserved in this, but to declare that, that is true; that you came afterwards to a better mind; wherein if you had been constant, the king, out of his great goodness, was resolved not to proceed with you in course of justice; but then again you started aside like a broken bow. So that by your variety and vacillation: you lost the acceptable time of your first grace, which was not to have convented you.


Nay, I will go farther with you: your last submission I conceive to be satisfactory and complete; but then it was too late, the king's honour was upon it; it was published and a day appointed for the hearing; yet what preparation that may be to the second grace of pardon, that I know not: but I know my lords, out of their accustomed favour, will admit you not only to your defence concerning that that hath been charged; but to extenuate your fault by any submission that now God shall put into your mind to make.




---

p.??




---

p.1


Letter of Francis Bacon to the King, *?February 1614*
-----------------------------------------------------


### *Spedding, Letters & Life, V, 1–2*

To the King
  

It may please your most excellent Majesty,
I most humbly pray your Majesty to receive into your royal remembrance that one point whereof you spoke unto me: which 


---

p.2



is this; to put but this case to those gentlemen which profess to do you service in Parliament, and desire (as they say) but to have some matter thereupon to work: If your Majesty be resolved not to buy and sell this Parliament, but to perform the part of a King, and not of a merchant or contractor, what they can desire or propound for the satisfaction and comfort of your people.


Of this three uses may be made.


First, if they fall upon an answer as to say, that the Parliament is so now in taste with matters of substance and profit, as it is in vain to think to draw them on but by some offer of that nature, then for their part I shall little esteem their service if they confess themselves to be but brokers for bargains.


Secondly, if they do devise and propound anything that is fit, then that it be followed and pursued, because they are likest to be in love with their own child and to nourish it.


Thirdly, if they show good will to devise some such thing, but that their invention prove barren, in that their proposition be not such but that better may be found, then they may be helpen by some better proposition from your Majesty whereupon they may work.


This, because time runneth, I beseech your Majesty may be put unto them by some such mean as your Majesty is pleased to use, as soon as may be.


I most humbly pray your Majesty also to take into consideration that it may be inconvenient for your Majesty to have a parliament in England and a parliament in Ireland at one time. And therefore I do wish that the Parliament of Ireland (when time shall be) may upon some occasion fitly taken be put off. For I beseech your Majesty to observe this argument further: that the unsettled business of the parliament of Ireland is a just ground for the parliament of England to furnish your Majesty with treasure in omnem eventum. And on the other side the loving and frank proceeding with you by your parliament of England will daunt the ill affected part of the parliament of Ireland.


If your Majesty had heard and seen the thunder of the bells and the lightening of the bonfires for your grandchild, you would say there is little cause to doubt the affections of the people of England in puris naturalibus. God preserve your Majesty. I rest


Your Majesty's most bounden servant,


Fr. Bacon


---

p.??




---

p.civ


A direction or advice unto her Majesty's Attorney-General of Ireland, touching certain doubts in law, which may arise in the proceeding against the recusant corporations in Ireland
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


### Calendar of State Papers, Ireland, 1606-08, pp. civ–cv

[15](javascript:footNote('E600001-015/note015.html'))
1. Are of the opinion that it is a contempt if a mayor take office without first taking the oath, for which he is punishable in the Castle Chamber, and in this they have resolved two doubts which had been moved to them.


1. First, that any one promoted by the queen to any temporal or lay office, before he shall take the office upon him, shall take the oath of supremacy, etc; this extends to a mayor, for that he cometh in by the king's authority, mediately, though not immediately; and in a former clause concerning persons already possessed of dignities and offices, a mayor is expressly named.


---

p.cv

4. Secondly, though no oath be tendered, yet if he exercises his office before he take it, he is punishable, for the word 'shall' is compulsory, and he is to take it at his peril, and he should procure a commission, if no person is authorised to tender the oath.



Notwithstanding, they advise that for the time to come, commissions to administer the oath be directed to the presidents in the provinces, and to the bishops and other chief officers there; and in the Pale to the bishops and some of the Privy Council, to remain dormant with them and to be executed from time to time.


2. Where the corporations by their charters are to choose their mayors, de probioribus, discretioribus, vel idoneis viris, if they choose notorious recusants, they (Ellesmere & Bacon) were of opinion they were not warranted in choosing such persons.


3. When mayors or recorders have exclusive jurisdiction, and being themselves recusants, have made no inquiry or conviction of recusants for years past, they were of opinion that their charter might be questioned upon that point.


Recommend for the time to come, that pursuant to the statute 2 Eliz, the bishop associate himself to the mayor and recorder upon sessions of oyer et terminer, and call upon them to inquire of recusants; and that a letter be written to corporations, reproving their former neglect, and to give the points of the statute in charge, and cause it to be executed in their franchises.


T. Ellesmere, Canc., Fr. Bacon
Endorsed: 'Instructions to Mr Attorney touching recusant corporations'


---

p.??




---

p.135


Mr Attorney's certificate touching the Patent for slitting Iron Bars, 27 January 1616
-------------------------------------------------------------------------------------


### *Spedding, Letters & Life, VI, 135*

It may please your lordships,
According to your lordship's reference of the 12th of June last, I have considered the Patent of Clement Dawbeney, gentleman, for slitting of iron bars into rods. And I have had before me the patentee that now is, and some of the nailers and blacksmiths that complained against the same, whereupon it pleased your lordships to call in the said patent. Bur upon examination of the business I find the complaint to be utterly unjust, and was first stirred up by one Burrell, master carpenter to the East India Company: who hath already himself begun to set up the like engine in Ireland, and therefore endeavoured to overthrow the said Patent, the better to vent his own iron to his further benefit and advantage; whereas the nailers and blacksmiths themselves do all affirm that they are now supplied by the patentee with as much good and serviceable iron or rather better than heretofore they have been, and the said patent hath been of much use to the kingdom in general, and likewise very beneficial to themselves in their trades: and therefore your lordships may be pleased to suffer him quietly to enjoy it without any further interruption; and to this did Burrell himself and the opposers willingly condescend: which nevertheless I submit to the wisdom of this most honourable board.


Jan. 27th 1616
Fr. Bacon


---

p.??




---

p.355


Letter of Francis Bacon to King James, 5 June 1616
--------------------------------------------------


### *Spedding, Letters & Lfe, V, 355–6*

It may please your excellent Majesty,
According to your Majesty's reference signified by Sir Roger Wilbraham, I have considered of the petition of Sir Gilbert Houghton, your Majesty's servant, for a license of sole transportation of tallow, butter and hides, etc, out of your realm of Ireland, and have had conference with the Lord Chichester, late Lord Deputy of Ireland, and likewise with Sir John Davies, your Majesty's Attorney there. And this is that which I find.


First, that hides and skins may not be meddled withal, being a staple commodity of the kingdom, wherein the towns are principally interested.


That for tallow, butter, beef, not understanding it of live cattle, and pipe-staves, for upon they things we fell, although they were not all contained in the petition, but in respect hides were more worth than the rest, they were thought of by way of some supply; these commodities are such as the kingdom may well spare, and in that respect fit to be transported; wherein, nevertheless, some consideration may be had of the profit, that shall be taken upon the license. Neither do I find, that the farmers of the customs there, of which some of them were before me, did much stand upon it, but seemed rather to give away to it.


I find also, that at this time all commodities are free to be transported by proclamation, so as no profit can be made of it, except there be by some prohibition in the letters patents, than by any


---

p.356



new proclamation; and the said letters patents to pass rather here than there, as it was in the license of wines granted to the Lady Arabella; but then those letters patents, to be enrolled in the chancery of Ireland, whereby exemplifications of them may be taken to be sent to the ports.


All which, nevertheless, I submit to your Majesty's better judgement.


Your Majesty's most humble bounden subject and servant,


Fr. Bacon
June 5, 1616.


---

p.??




---

p.375


Letter of Francis Bacon to Sir George Villiers, 1 July 1616
-----------------------------------------------------------


### *Spedding, Letter & Life, V, 375*

Sir,
I send you enclosed a warrant for my Lady of Somerset's pardon, reformed in that main and material point of inserting a clause (that she was not a principal, but an accessory before the fact, by the instigation of base persons). Her friends think long to have it dispatched, which I marvel not at, for that in matter of life moments are numbered.


I do more and more take contentment in His Majesty's choice of Sir Oliver St. Johns, for his deputy of Ireland, finding upon divers conferences with him his great sufficiency; and I hope the good intelligence which he purposeth to hold with me by advertisements from time to time shall work a good effect for his Majesty's service.


I am wonderful desirous to see that kingdom flourish, because it is the proper work and glory of his Majesty and his times. And his Majesty may be pleased to call to mind, that a good while since, when the great rent and divisions were in the Parliament of Ireland, I was no unfortunate remembrancer to his Majesty's princely wisdom in that business. God ever keep you and prosper you.


Your true and most devoted and bounden servant,


Fr. Bacon
1 July, 1616.


---

p.377


Letter of Francis Bacon to Sir George Villiers, 2 July 1616
-----------------------------------------------------------


### *Spedding, Letters & Life, V, 377*

Sir,
I think I cannot do better service towards the good estate of the kingdom of Ireland than to procure the king to be well served in the eminent places of Law and Justice; I shall therefore name unto you for the Attorney's place there, or for the Solicitor's place, if the now Solicitor shall go up, a gentleman of mine own breeding and framing, Mr. Edward Wrytington, of Gray's Inn; he is born to eight hundred pound a year; he is the eldest son of a most severe justicer amongst the recusants of Lancashire, and a man most able for law and speech, and by me trained in the king's causes. My Lord Deputy by my description is much in love with the man. I hear my Lord of Canterbury and Sir Thomas Lake should name one Sir John Bear and some other mean men. This man I commend upon my credit for the good of his Majesty's service. God ever preserve and prosper you. I rest


Your most devoted and most bounden servant,


Fr. Bacon
2 of July, 1616.


---

p.44


Letter of Sir Francis Bacon to Sir George Villiers, of advice concerning Ireland, from Gorhambury to Windsor
------------------------------------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 44–7.*

Sir,
Because I am uncertain whether his Majesty will put to a point some resolutions touching Ireland, now at Windsor: I thought it my duty to attend his Majesty by my letter, and thereby to supply my absence, for the renewing of some former commissions for Ireland, and the framing of a new commission for the wards, and the alienations, which appertain properly to me, as his Majesty's attorney, and have been accordingly referred by the lords, I will undertake that they are prepared with a greater care, and better application to his majesty's service, in that kingdom, than heretofore they have been; and therefore of that I say no more. And for the instructions of the new deputy, they have been set down by the two secretaries, and read to the board, and being things of an ordinary nature, I do not see but they may pass. But there have been three propositions and councils which have been stirred, which seem to me of 



---

p.45



very great importance, wherein I think myself bound to deliver to his majesty my advice, and opinion, if they should now come in question. The first is touching the recusant magistrates of the towns of Ireland, and the commonalties themselves, and their electors, what shall be done; which consultation ariseth from the late advertisements from the two lord justices, upon the instance of the two towns, Limerick and Kilkenny; in which advertisements, they represent the danger only without giving any light for the remedy, rather warily for themselves, than agreeable to their duties and places. In this point, I humbly pray his majesty to remember, that the refusal is not of the *Oath of Allegiance*, (which this is not exacted in Ireland,) but of the *Oath of of supremacy*, which cutteth deeper into matter of 
conscience.


Also that his majesty, will out of the depth of his excellent wisdom and providence, think, and as it were calculate with himself, whether time will make more for the cause of religion in Ireland, and be still more and more propitious, or whether differing remedies will not make the case more difficult. For if time give his majesty the advantage, what needeth precipitation of extreme remedies; but if the time will make the case more desperate, then his majesty cannot begin too soon. Now, in my opinion, time will open and facilitate things for reformation of religion there, and not shut up or lock out the same. For, first, the plantations going on, and being principally of protestants, cannot but mate the other party in time. Also his majesty's care in placing good bishops, and good divines; in amplifying the college there, and looking to the education of wards, and such like; as they are the most natural means, so are they like to be the most effectual and happy, for the weeding out of popery, without using the temporal sword; so that I think I may truly conclude, that the ripeness of time is not yet come.




---

p.46


Therefore my advice is, in all humbleness, that this hazardous course of proceeding to tender the oath to the magistrates of towns, proceed not, but die by degrees. And yet to preserve the authority and reputation of the former council, I would have somewhat done, which is, that there be a proceeding to seizure of liberties, but not by any act of power, but by ‘quo warranto,’ or ‘scire facias’, which is a legal course, and will be the work of three or four terms; by which time the matter will be somewhat cool.


But I would not (in no case) that the proceeding should be with both the towns which stand now in contempt, but with one of them only, choosing that which shall be most fit. For, if his majesty proceed with both, then all the towns that are in the like case will think it a common cause, and that it is but their case to day, and their own to morrow. But if his majesty proceed but with one, the apprehension and terror will not be so strong; for, they may think, it may be their case to be spared, as well as prosecuted. And this is the best advice that I can give to his majesty, in this strait; and of this opinion seemed my lord chancellor to be.


The second proposition is this, it may be, his majesty will be moved to reduce the number of his council of Ireland, (which is now almost fifty) to twenty, or the like number, in respect that the greatness of the number doth both imbase the authority of the council, and divulge the business. Nevertheless, I hold this proposition to be rather specious, and solemn, than needful at this time; for certainly, it will fill the state full of discontentment, which, in a growing and unsettled state, ought not to be. This I could wish, that his majesty would appoint a select number of counsellors there, which might deal in the improvement of his revenue, (being a thing not to pass through too many hands;) and the said selected number should have days of sitting by themselves, at which the rest of the council should 



---

p.47



not be present; which being once settled, then other principal business of state may be handled at these sittings; and so the rest begin to be disused, and yet retain their countenance, without murmur, or disgrace.


The third proposition, as it is moved, seemeth to be pretty, if it can keep promise; for it is this, that a means may be found to re-inforce his majesty's army by five hundred, or a thousand men, and that without any penny increase of charge. And the means should be, that there should be a commandment of a local removing, and transferring some companies from one province to another, whereupon it is supposed, that many that are planted in house and lands, will rather lose their entertainment, than remove; and thereby new men may have their pay, yet, the old be mingled in the country, for the strength thereof. In this proposition two things may be feared; the one, discontent of those that shall be put off; the other, that the companies should be stuffed with novices, tirones instead of veterani. I wish, therefore, that this proposition be well debated, before it be admitted. Thus having performed that which duty binds me to, I commend you to God's best preservation.


Your most devoted and bounden servant.


July 5, 1616.


---

p.188


Opinion of Attorney-General Bacon given to English Privy Council on export of Irish Wool, 22 July 1616
------------------------------------------------------------------------------------------------------


### *Lambeth Palace, MS 619, pp. 188–9*


According to your lordships' reference of the 13th of this instant July, I have considered of the certificate of the Lord Chichester, the Lord Deputy of Ireland, Alderman Cockayne, and George Lowe concerning restraint of exportation of wools, woollen yarn etc. out of Ireland into foreign parts. And I do approve the said certificate with the explanations, alterations and provisions following:


1. First that the five towns named in the certificate as staple towns in England be not understood to pretend any new charters or privileges of staple but only be understood to be towns correspondent for the receiving of wools etc out of the staple to towns of Ireland without any other novelty.


2. Secondly that whereas of the towns of Ireland mentioned in the certificate four of them are ancient staple towns viz, Dublin, Waterford, Cork and Drogheda and one is made a staple town by a late charter from his Majesty, viz. Limerick and three are not yet erected to be staple towns, viz., Galway, Knockfergus, and Londonderry, it is fit that the three towns which have yet no charter of staples have charters to erect them into Staple towns only for these commodities. And it is convenient also that the four other ancient staple towns and Limerick either by accepting of new charters or otherwise by order of the Council of State there be induced to be conform unto the orders which shall now be prescribed for the staple to the end there may be one uniform course held in all the towns.


3. Thirdly that the orders and privileges of all the said charters be considered of and framed here in England and also the charters thereupon to pass here.




---

p.189


4. Fourthly that whereas part of the commodities mentioned in the said certificate are expressly forbidden by the statutes of Ireland to be exported, viz., wools and wool fells and part of them are doubtful, whether they be comprehended in the statutes or no, viz., morlings, shearlings, lambskins and woollen yarn, it were very fit that there were a general proclamation for the restraint of the law where it is clear as for the supply of the same where it is doubtful, and so the orders of the staple to work equally for all.


5. Fifthly whereas it is mentioned in the certificate that if the four ancient towns shall refuse the reception of one his majesty's subjects into their society, then the lord deputy to transfer the staple of wool etc. to such other four towns as his lordship shall think fit; This is to be understood that in case of such refusal the town refusing shall be excluded of the benefit of the **non obstante** or privilege to export, for otherwise that those that they have already by charter cannot be transferred. And the like I would wish to be done if they will not conform themselves to the king's order for the staple of wools.


6. Lastly, all the staple towns must have their Charters or **non obstante** of the statutes made against exportation of wool etc as well such as make it felony as otherwise. And also the forfeiture which by statute is given to the towns must be released.


There would be also good care taken that the fine of the admittance into the staplers company be not great and that none come in but merchants.


July 22 1616
*Endorsed: 'Mr Attorney's Certificate touching the wools of Ireland.'*


---

p.??


Answers to the questions sent into England by the Lord Chief Baron of the Exchequer in Ireland, *?1617*
-------------------------------------------------------------------------------------------------------


### *UK National Archives, Kew, SP63/234, no. 19*


Because the questions are propounded somewhat doubtfully, we have thought good so to answer as may give satisfaction as well to the questions that are propounded as to the other doubts about the same or of the like nature.


1. The first case[16](javascript:footNote('E600001-015/note016.html')) therefore when any man is attainted of treason, be it according to the common law, or the act of parliament, And then it be found by office that he was seized of any land, the king is thereby adjudged and is indeed in actual possession of the land. And if any other had estate or right to the land he hath no remedy to recover it from the king but by petition. In as much as the Statute of 2. Ed. 6. that allows traverse and monstrans de droit in the like cases, is not (as we understand) in force in Ireland, And though the king having lands by such title, grant them away in fee or fee farm, That changes not the case, but that the patentee ought to hold and continue the possession and he that pretends title must sue by petition and otherwise, as if the lands were still in the king's hands with a scire facias thereupon against the patentee.


In this suite of petition there are many delays as by the writes of search and the like yet because they be favours allowed by the law, to the king or his patentee, they cannot be denied him, being part of his defence.


If the patentee be nevertheless holden out of possession he may take any course by entry of or suite in law to recover the same & damages for the wrongful occupation; In which suits the defendants though they have right cannot relieve themselves thereby: But must of force be overthrown in as much as this right is bound by the double matter of record that is against them, till the same by their petition undone it.


And so likewise if the king hath granted away the lands in fee farm, though the patentee be holden out of the possession the king's rent must still be answered, And therefore the ordinary courses are to be taken for the same by extent seizure or the like wherein there can be no defence against the king's writ for the reason to aforesaid.


And it is just, not to suffer the rent to run in arrearage for else the wrongdoer shall pay no rent and the patentee when he shall afterwards recover it shall be charged with his arrearage.


But if the possessions have continued long against the king or his patentee, or if those erroneous and indirect of trying of rights against the king and his patentees by actions of trespass, ejectione firme, new commission or the like have been allowed by the courts of justice there, And that sometimes by allowance and direction out of England (if by these means the right have appeared against the king And if for those or any other reasons, it shall seem good to your lordships not suddenly to have such possessions removed: It may please you to give these or such other directions as shall seem good to your lordships.


First where the lands are in the king's hands and not granted out: It is at his Majesty's pleasure to forbear to seize the lands, upon bond that if they doe not prosecute their pretended right by petition with effect, so as they prove their right in due form in law within some convenient time to be prefixed, That then they shall yield quiet possession with the mean profits incurred.


And if the any of those things be granted out in which case the patentee be denied his ordinary remedies: yet he may with justice be denied to use any course in the king's name for his benefit, And therefore if he will desire to sue by information upon instruction before his patent it may be refused.


Also the patentee can procure no seizure of the land for himself or his majesty otherwise then for the king's rent as aforesaid, in which case the court may dispose of the land as they shall think most convenient.


Lastly if the patentee can be brought to suffer the possession to continue and accept such bond as is before mentioned for the king till the title be tried according to due course of law with expedition it will be a good quiet.


But in this permitting of them (that pretend title against the king or his patentee) to continue their possession that favour (which is granted out of respect of convenience) would be extended only to so much as the pretenders doe actually manure for otherwise they may make it a colour to the possession of large country whereof they have neither use nor occupation which may tend to the depopulation and decay of habitation therein.


Also (if it so seem good to your lordships) a general direction to the courts there would do well, that they should not hereafter permit those disordered proceedings by new inquisitions, trials in ejectione firme or otherwise by the pretenders against the patentees that have as it seems been heretofore allowed against the king and his patents: But to observe in all things the Rule of Law by which they may judge, and the people enjoy their own with certainty, And thus much touching the questions of the first case.


As touching the second case: concerning the properties granted in the time of King Henry the Eight by the Bishop of Meath unto the said king in exchange for certain personages impropriate although we find some difficulty, and there may be difference of opinions whether the said grant of properties be good, although the same were granted by the said Bishop as ordinary unto the king as supreme ordinary, yet the said king and other his Majesty's predecessors and also his highness having been possessed of the same as a revenue of the crown. We are all of clear opinion that the granting of such rectories in fee, fee farm or lease [*gap: torn*] erance to his Majesty by extinguishment, suspension or otherwise of the said duties [*gap: torn*] unto his highness into his Exchequer any the said grants of the said rectories notwithstanding.


As touching the last question whether a fine for alienation be due unto his majesty upon a common recovery suffered in Ireland of lands holden by knight's service in capite: we are of opinion That there is due a fine for Alienation upon such recoveries for that they are now but as conveyances and so accounted in law upon which an use may be raised, and averred as upon a fine or any other assurance.


John Dodderidge, Henry Hobarte, Fr. Bacon.


---

p.154


Privy Council to Lord Deputy of Ireland, 16 March 1617
------------------------------------------------------


### *Spedding, Letters & Life, VI, 154–6*


It is not unknown to you that for many weighty reasons highly concerning the good of both his Majesty's kingdoms of


---

p.155



England and Ireland for preventing the exportation of wool out of that realm into foreign parts, a course was thought upon at your last being here, advised by yourself, the Lord Chichester, and some others to whom that business was recommended, for erecting of certain staple towns in Ireland that should have sole power and authority to transport the wools of that realm, such as were not manufactured in the kingdom, to other Port Towns in England that should be assigned as correspondents to receive that commodity from thence. Hereupon the business being well projected by you and the rest of the Committees with many necessary cautions and provisions, it had besides sundry other references, first to me the Lord Keeper, then his Majesty's Attorney General, and afterwards to other persons, by reason of former employment well experienced in the state of that realm. Upon all which several references we received certificates and opinions, which we send to your Lordship herewith. We are now therefore to let you know that upon mature and grave advertisement the business hath received a full approbation at the Board and is ready for execution. The old staple towns have been dealt withal, as we understand, by those that were the last year sent from hence and were employed by your Lordship for that purpose; which towns, as we hear, are not so conformable and willing to receive the conditions of this new staple now to be established, as is fit they should be; wherein if they persist, or shall refuse to release such customs and forefeitures as are given them by statute, being hereunto first moved by your lordship and that Council, whereof you will advertise us, his Majesty may (if it please him) take from them the benefit of the **non obstante** and so make their privileges of no use unto them, until their conformity he shall vouchsafe to restore them to their exemption again. To this end your lordship is first to cause a proclamation forthwith to be published, for restraining generally the exportation of all sorts of wools, woolfells, morlings, shearlings, lambskins, woollen yarns and flocks; the two first sorts being expressly forbidden by statutes, and for the rest (the statutes being not so clear) his Majesty's proclamation may supply them; so as all being once equally prohibited, his Majesty may release it again to the new staple towns by a **non obstante** in their charters, as also by altering the proclamation with a saving and exception to the old staplers, if their conformity hereafter


---

p.156



do deserve it. Thus your Lordship. sees the course which we think fit to be taken there. For the drawing up of the new charter and the rest which is to be acted here, order is given for it and they shall be dispatched with all expedition. And so, etc.


Lo. Archbishop of Canterbury.
Lo. Keeper.
Lo. Visc. Wallingford.
Lo. Privy Seal.
Lo. Bp of Ely.
Lo. Steward.
Mr. Vice Chamberlain.
Lo. Chamberlain.
Mr. Secr. Lake.
E. of Arundel.
Mr. of the Rolls
March 16, 1616


---

p.??


Lord Keeper Bacon to Dr George Downham, Bishop of Derry. 8 May 1617
-------------------------------------------------------------------


### *UK National Archives, Kew, SP63/234, no. 6A*


After my harty commendations unto your lordship. Whereas it is requisite on the behalf of Dame Elizabeth Killegrew widow, that your lordship and your wife may be warned to appear in Chancery, on Monday next, being the 12th of this instant May, to answer to a Bill there executed against you by her ladyship. I am at her instance to give your lordship notice thereof by this my letter, according to the manner used towards persons of your place and calling, praying and requiring you hereby, to take knowledge thereof, and to give order to those whom you doe employ in such your causes, for your lordship's appearance and putting in of your answers at the time accordingly, whereof hoping there shall be no default on your lordship's part, I bid your lordship hartly farewell.


At Dorsett House,


8 May 1617
Your Lordship's loving friend


Fr. Bacon
  
To the right reverend father in God, the Bishop of Derry in Ireland

Endorsed: 'letter to a great man to appear in the chancery to answer'




---

p.207


Letter of Francis Bacon to George Villiers, Marquis of Buckingham, 25 May 1617
------------------------------------------------------------------------------


### *Spedding, Letters & Life, VI, 207–8*

My very good Lord,
I know your lordship hath a special care of any thing that concerneth the queen. She was entered into dislike of her solicitor, this bearer, Mr. Lowder, and resolute in it. To serve, and not to please, is no man's condition. Therefore, upon knowledge of her pleasure he was willing to part with his place, upon hopes not to be destitute, but to be preferred to one of the barons' places in Ireland. I pray move the king for him, and


---

p.208



let his Majesty know from me that I think (howsoever he pleased not here) he is fit to do his Majesty service in that place; he is grave and formal, which is somewhat there, and sufficient enough for that place. The queen hath made Mr. Hackwell her solicitor, who hath for a long time taken much pains in her business, wherein she hath done well. He was an opposite in Parliament, as Jones was, that the king hath made Chief Justice of Ireland. But I hold it no ill counsel to join, or to remove such men. God preserve and prosper you.


Your true and devoted friend and servant,


Fra. Bacon, C. S.
  
Whitehall,


May 25, 1617.


---

p.351


Letter of Francis Bacon to Thomas Jones, Lord Chancellor of Ireland, 15 April 1618
----------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 351–2*

My Lord Chancellor,
I will not have you account the days of my not answering your letter. It is a thing imposed upon the multitude of my business to lodge many things faithfully, though I make no present return.




---

p.352


Your conjunction and good understanding with the deputy I approve and commend; for I ever loved intire and good compositions, which was the old physic, better than fine separations.


Your friendly attributes I take as effects of affection; which must be causes of any good offices, wherewith I can requite you.


We conceive that kingdom is in growth. God send soundness to the increase; wherein I doubt not but your lordship will do your part.


God keep you.


Your Lordship's very loving friend,


  
York House,


April 15, 1618.Fr. Bacon.


---

p.476


*The speech used by Sir Francis Bacon, Lord Keeper of the Great Seal of England, to 
**Sir William Jones**, upon his calling to be Lord Chief Justice of Ireland, 1617*
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------


### *Montagu, Works of Bacon, New Edition, II, 476–7*

**Sir William Jones**,
The King's most excellent Majesty, being duly informed of your sufficiency every way, hath called you, by his writ now returned, to the state and degree of a serjeant at law; but not to stay there, but, being so qualified, to serve him as his chief justice of his King's bench in his realm of Ireland. And therefore that which I shall say to you, must be applied not to your serjeant's place, which you take but in passage, but to that great place where you are to settle; and because I will not spend time to the delay of the business of 


---

p.477



causes of the court, I will lead you the short journey by examples, and not the long by precepts.


The place that you shall now serve in, hath been fortunate to be well served in four successions before you: do but take unto you the constancy and integrity of Sir Robert Gardiner; the gravity, temper, and direction of Sir James Lea; the quickness, industry, and dispatch of Sir Humphry Winch; the care and affection to the commonwealth, and the prudent and politic administration of Sir John Denham, and you shall need no other lessons. They were all Lincoln's Inn men as you are, you have known them as well in their beginnings, as in their advancement.


But because you are to be there not only chief justice, but a counsellor of estate, I will put you in mind of the great work now in hand, that you may raise your thoughts according unto it. Ireland is the last ex filiis Europae, which hath been reclaimed from desolation, and a desert, in many parts, to population and plantation; and from savage and barbarous customs to humanity and civility. This is the King's work in chief: it is his garland of heroical virtue and felicity, denied to his progenitors, and reserved to his times. The work is not yet conducted to perfection, but is in fair advance: and this I will say confidently, that if God bless this kingdom with peace and justice, no usurer is so sure in seven years space to double his principal with interest, and interest upon interest, as that kingdom is within the same time to double the stock both of wealth and people. So as that kingdom, which once within these twenty years wise men were wont to doubt whether they should wish it to be in a pool, is like now to become almost a garden, and younger sister to Great Britain. And therefore you must set down with yourself to be not only a just governor, and a good chief justice, as if it were in England, but under the King and the deputy you are to be a master-builder, and a master-planter, and reducer of Ireland. To which end, I will trouble you at this time but with three directions.


The first is, that you have special care of the three plantations, That of the north, which is in part acted; that of Wexford, which is now in distribution; and that of Longford and Leitrim, which is now in survey. And take this from me, that the bane of a plantation is, when the undertakers or planters make such haste to a little mechanical present profit, as disturbeth the whole frame and nobleness of the work for times to come. Therefore hold them to their covenants, and the strict ordinances of plantation.


The second is, that you be careful of the King's revenue, and by little and little constitute him a good demesne, if it may be, which hitherto is little or none. For the King's case is hard, when every man's land shall be improved in value with increase manifold and the King shall be tied to his dry rent. My last direction, though first in weight, is, that you do all good endeavours to proceed resolutely and constantly, and yet with due temperance and equality, in matters of religion; lest Ireland civil become more dangerous to us than Ireland savage.


So God give you comfort of your place.


*After Sir William Jones's speech:* 
  


I had forgotten one thing, which was this. You may take exceeding great comfort, that you shall serve with such a deputy; one that, I think, is a man ordained of God to do great good to that kingdom, And this I think good to say to you, that the true temper of a chief justice towards a deputy is, neither servilely to second him, nor factiously to oppose him.




---

p.352


Letter of Francis Bacon to William Jones, Lord Chief Justice of Ireland, April 1618
-----------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 352*

My Lord Chief Justice,
I thank you for your letter, and assure you, that you are not deceived, neither in the care I have of the public in that state, nor in my good wishes, and the effects thereof, when it shall he in my power towards yourself.


I am glad to receive your testimony of my Lord Deputy, both because I esteem your judgment, and because it concurreth with my own.


The materials of that kingdom, which is trade and wealth, grow on apace. I hope the form, which giveth the best living of religion and justice, will not be behind, the rather by you, as a good instrument. I rest


Your lordship's assured friend,


  
York House,


** of April, 1618
Fr. Bacon, Canc.


---

p.83


Letter of Francis Bacon to George Villiers, Marquis of Buckingham, 27 July 1618
-------------------------------------------------------------------------------


### *Montagu, Works of Bacon (New Edition), III, p. 83*

My very good Lord,
I pray your lordship to sign to his Majesty that I thought it my duty to steal at the seal, a book of Sir Francis Steward's, and Sir James Averlony, etc. of £200 land in charge in fee simple: my reasons.


First, it is a perpetuity and so much rent in diminution of revenue certain.


Secondly, the warrant (as is acknowledged) came only from my Lord of Suffolk, and not from Mr. Chancellor. And yet my lord was wont to boast, that since he was treasurer, all commissions and contracts for sale of the king's land were broken off and ceased.


Thirdly, the rate of the monies paid by the gentlemen amounteth to thirteen years' purchase, which is a plain gift of a good proportion of value.


If the Majesty, and now informed, iterate his mandate, it is done, and I excused; but I could wish his Majesty would refer it to the commissioners of the treasury how the gentlemen may be otherwise satisfied.


I received yesternight a brave account of the commission of the wards in Ireland, which this one year is advanced two hundred pounds per annum to four thousand pounds, which is twenty fold multiplied. This I write for two reasons. First, because I glory in it, because it was my work wholly; next, because his Majesty may take occasion by this to look better to the improvement of his wards in England in due time. God ever preserve and prosper you.


Your lordship's most obliged friend and faithful servant,


Fr. Verulam, Canc  
York House,


July 27 1618


---

p.360


Letter of Francis Bacon to George Villiers, The Marquis of Buckingham, 12 November 1618
---------------------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 360*

My very good Lord,
I send the commission for making Lincoln's Inn Fields into walks for his Majesty's signature. It is without charge to his Majesty.


We have had my Lord of Ormond before us. We could not yet get him to answer directly, whether he would obey the king's award or no. After we had endured his importunity and impertinency, and yet let him down to this, that his Majesty's award was not only just and within his submission, but in his favour, we concluded in few words. That the award must be obeyed, and if he did refuse or impugn the execution of it in Ireland, he was to be punished by the justice of Ireland: if he did murmur or scandalize it here, or trouble his Majesty any more, he was to be punished in England. Then he asked whether he might be gone. For that, we told him, his Majesty's pleasure was to be known.


Sir Robert Mansell hath promised to bring in his summary account this day sevennight. God preserve and prosper you.


Your lordship's most obliged friend and faithful servant,


Fr. Verulam, Canc.


---

p.369


Letter of Francis Bacon to George Villiers, marquis of Buckingham, 6 May 1619
-----------------------------------------------------------------------------


### *Montagu, Works of Bacon, XII, 369*

My very good Lord,
I think fit to let your lordship understand what passed yesterday in the Star Chamber touching Suffolk business.


There came to me the clerk of the court in the inner chamber and told me that my Lord of Suffolk desired to be heard by his council at the sitting of the court, because it was pen \_\_\_\_ him.


I called presently Mr. Attorney to me, and asked him whether he knew of the motion, and what it was, and how he was provided to answer it. He signified to me, that my lord would desire to have the commission for examinations in Ireland to be returnable in Michaelmas term. I said it might not be, and presently drew the council then present, to me, and made Mr. Attorney repeat to them the passages past, and settled it, that the commission should be returnable the first day of the next term, and then republication granted, that it might, if accidents of wind and weather permit, come to hearing in the term. And upon motion in open court it was ordered accordingly. God ever preserve and prosper you. I pray God this great easterly wind agree well with His Majesty.


Your Lordship's most obliged friend and faithful servant,


Fr. Verulam, Canc.May 6, 1619
  
 Indorsed:—Sent by Sir Gilbert Houghton'.











