

#Rev. Daniel A. Beaufort's Tour of Kerry, 1788


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Rev. Daniel A. Beaufort's Tour of Kerry, 1788
=============================================


Author: Daniel A. Beaufort
--------------------------


### File Description

Gerard J. LyneElectronic edition compiled and proof-read by Beatrix Färber

Funded by University College, Cork, School of History 1. First draftExtent of text: 19040 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E780002-001Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Notes

We are very grateful to Gerard Lyne, formerly Keeper of Manuscripts at the National Library of Ireland, and the Board of the Kerry Archaeological and Historical Society for their kind permission to publish this material in electronic form on CELT.

#### Sources


**Manuscript**2. Trinity College Library, Ms. 4029–4030.
3. See also: Trinity College Library, Ms. 4031: Daniel Augustus Beaufort, mapmaker, vicar of Collon, 1739-1821. Diary vol. V, 19 November 1786 to 30 April 1790.
4. See also: Trinity College Library, Ms. 4033: Daniel Augustus Beaufort's journal of a tour in the north of Ireland, 9 October to 8 November 1807; journal of a tour in the west of Ireland, 9 August to 8 October 1808 with a few added entries of October 20.
5. Huntington Library of San Marino, California, Papers of Sir Francis Beaufort, 1710-1953 (bulk 1780-1890): mssFB 1-1920 (see http://catalog.huntington.org/record=b1552512~S0).
**Literature (including that referred to in annotations)**2. Charles Smith, The ancient and present state of the county of Kerry (Dublin 1756). Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
3. Dunn [attributed], A Description of Killarney (Dublin 1776). [Available online at CELT].
4. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available online at CELT.]
5. Peter Bernard Scalé, An Hibernian Atlas (London 1776).
6. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin. A new edition by A. W. Hutton, 'Arthur Young's tour in Ireland, 1776–1779', was published 1892 in London, and yet another edition, 'A Tour in Ireland. 1776–1779' edited by Henry Morley in 1887 is available online at CELT.
7. George Taylor and Andrew Skinner, Taylor and Skinner's Maps of the Roads of Ireland, surveyed 1777 (London 1778; Dublin 1783).
8. William Faden, Survey of the lakes of Killarney (...) (London 1786).
9. Philip Luckombe, The compleat Irish traveller (...) 2 vols (London 1788).
10. D. A. Beaufort, Memoir of a map of Ireland, illustrating the topography of that kingdom, and containing a short account of its present state, civil and ecclesiastical; with a complete index to the map (Dublin 1792).
11. D. A. Beaufort, A new map of Ireland, civil and ecclesiastical (Dublin 1792).
12. Caspar Voght, Schilderung von Irland, Bruchstücke aus dem Tagebuche eines Reisenden. Im Herbst 1794, in: August Hennings, Der Genius der Zeit, Bd. 8, (Mai bis August 1796) 566–653. [Available online at CELT.]
13. Jacques Louis de Bougrenet Chevalier de La Tocnaye, A Frenchman's Walk through Ireland 1796–7 (Promenade d'un François dans l'Irlande), translated by John Stevenson (first published Cork 1798; repr. Belfast 1917; Dublin 1984).
14. Isaac Weld, Illustrations of the Scenery of Killarney and the surrounding Country (London 1805).
15. William Wilson, The postchaise companion (Dublin [1806]).
16. J. T. Mackay, Systematic catalogue of the rare plants found in Ireland, in Transactions of the Dublin Society 5 (1806) 59–.
17. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
18. J. Charles, Modern map of the Roads of Ireland including all the Post Towns (Dublin 1814).
19. Thomas Crofton Croker, Researches in the south of Ireland (London 1824) [available online at CELT].
20. [Caesar Otway], Sketches in Ireland descriptive of interesting and hitherto unnoticed districts in the north and south (Dublin 1827).
21. Thomas Crofton Croker, Legends of the lakes: or, Sayings and doings at Killarney, 2 vols. (London 1829).
22. Samuel Lewis, A Topographical Dictionary of Ireland, comprising the several counties, cities, boroughs, corporate, market, and post towns. Parishes, and villages, with historical and statistical descriptions (...) (London 1837). [Available online at http://www.libraryireland.com/topog/index.php].
23. John O'Donovan, 'Letters ... relative to ... Kerry collected during the ... Ordnance Survey in 1841' [typescripts in National Library of Ireland] .
24. George Petrie, The ecclesiastical architecture of Ireland Anterior to the Anglo-Norman invasion (...) (Dublin 1845).
25. John Burke, A genealogical and heraldic dictionary of the landed gentry of Great Britain and Ireland. By John Burke and John Bernard Burke 3 vols (London 1846–1849).
26. W. R. Wilde (ed), A descriptive catalogue of the antiquities of gold in the museum of the Royal Irish Academy (Dublin 1862).
27. M. A. Hickson (ed), Selections from old Kerry records (...) Ser. I (Dublin and London 1872–74).
28. J. A. Froude, The English in Ireland in the eighteenth century, I (London 1872).
29. J. O'Connell, The last colonel of the Irish Brigade, vol. I (London 1892).
30. W. Mac Neill Dixon, Trinity College Dublin (London 1902).
31. J. Carmody, Story of Castle Mayne (...), in *Kerry Archaeological Magazine* 1 (1908) 17–37, 49–79; 119–41.
32. Jeremiah King, King's history of Kerry ... 2nd ed. iv (Wexford, Liverpool and Tralee, [1910–1912]).
33. John Windele, 'Some castles and clans of Desmond, extracted from 'Notices of Cork and Killarney', *Kerry Archaeological Magazine* 2/10 (March 1913) 80–92.
34. W. J. Strickland, A Dictionary of Irish Artists ... I (1913)
35. Rudolf Thurneysen, Die Sage von CuRoi, Zeitschrift für Celtische Philologie 9 (1913) 189–234:190–193, available online at CELT in file G301031; text in Old Irish. German translation (193–196) available online at CELT in file D301031.
36. S. M., The Trant family, in *Kerry Archaeological Magazine* 2/12 (March 1914) 237–262.
37. W. F. T. Butler, Gleanings from Irish history (London 1925).
38. E. C. R. Armstrong (ed), Catalogue of Irish gold ornaments in the collections of the Royal Irish Academy (2nd ed., 1933).
39. William Petty Lansdowne (sixth marquis of Lansdowne), Glanerought and the Petty-Fitzmaurices (London: Oxford University Press 1937).
40. An Seabhac (=Pádraig Ó Siochfhradha), Tríocha-céad Chorca Dhuibhne ... (Baile Átha Cliath 1939). [English transl. by Barra Ó Briain, Tríocha-céad Chorca Dhuibhne: an illustrated English translation (published in instalments 2011-13).
41. J. B. Leslie, Ardfert and Aghadoe clergy and parishes (Dublin 1940).
42. Edward Mac Lysaght (ed), The Kenmare Manuscripts (Dublin 1942).
43. Seán Mac Airt, The Annals of Inisfallen (MS. Rawlinson B. 503) (Dublin: DIAS 1944). Several times reprinted. [Available online at CELT.]
44. Máire Nic Néill, 'Wayside Death Cairns in Ireland', *Béaloideas* 15 (1946) 49–63.
45. Seán Ó Duilearga (ed with Tomás Ó Criomhthain, Robin Flower), Seanchas ón Oileán Tiar (Baile Átha Cliath 1956) 10–19.
46. Pádraig Ó Maidin (ed), 'Pococke's tour of south and south-west Ireland in 1758', *Journal of the Cork Historical and Archaeological Society* 63 (1958), 73–94; 64 (1959), 35–56, 109–30; 65 (1960), 130–41.
47. F. M. Hilliard, 'Philip Ronayne, Gent', *Journal of the Kerry Archaeological and Historical Society* I (1968) 41–5.
48. M. G. Moyles and Pádraig de Brún, 'Charles O'Brien's agricultural survey of Kerry, 1800', *Journal of the Kerry Archaeological and Historical Society* I (1968) 73–100.
49. Mary Scannell and Donall M. Synnott (comp.), Census catalogue of the flora of Ireland (Dublin 1972).
50. Pádraig de Brún, 'John Windele and Father John Casey: Windele's visit to Inis Tuaisceart in 1838', in *Journal of the Kerry Archaeological and Historical Society*, 7 (1974) 71–106.
51. Daithí Ó h-Ógáin, 'An é an t-am fós é?': staidéair ar fhinnscéal Barbarossa ... in Éirinn", in *Béaloideas*, 42–44 (1974–6) 213–308. (See also by the same author, 'Has the Time Come? The Barbarossa legend in Ireland and its historical background,' *Béaloideas* 59 (1991) 197–207.)
52. Seán Ó Luing, 'Richard Griffith and the roads of Kerry', *Journal of the Kerry Archaeological and Historical Society* 8 (1975) 89–113.
53. Thomas Joseph Barrington, Discovering Kerry: its history, heritage and topography (Dublin 1976).
54. Emmanuel-Charles Bénézit, Dictionnaire des peintres, sculpteurs ... et graveurs ..., 10 vols (nouvelle ed., Paris 1976).
55. Mark Bence-Jones, Burke's guide to country houses: Vol I: Ireland (London 1978).
56. Bernard Burke, Burkes's Irish family records [London 1976].
57. Gerard J. Lyne, 'Landlord-tenant relations of the Shelburne estate in Kenmare, Bonane and Tuosist, 1770–75, with a rental of the estate for 1783', *Journal of the Kerry Archaeological and Historical Society*, 12 (1979) 19–62.
58. Seán Ó Luing, 'Local government in Dingle, Ardfert and Tralee in 1837', in *Journal of the Kerry Archaeological and Historical Society*, 12 (1979) 119–37.
59. Edward Keane, P. Beryl Phair, Thomas Ulick Sadleir (eds), King's Inns admission papers 1607–1867 (Dublin 1982).
60. Micheal McGarvie, 'An Irishman in Wales: Daniel Beaufort's journals for 1766 and 1779', Transactions of the Ancient Monuments Society 29 (1985) 90–100.
61. Fergus P. J. Gillespie, 'Mor Muman ocus Aided Cuanach meic Ailchini: a critical edition with introduction, translation, variant manuscript readings, textual notes, glossary, and indexes', Dublin, Unpublished MA thesis: University College Dublin, 1985.
62. Gerard J. Lyne (ed), 'Lewis Dillwyn's visit to Waterford, Cork and Tipperary in 1809', *Cork Historical Society Journal* 91 (1986) 85–104.
63. Cyril C. Ellison, The hopeful traveller: the life and times of Daniel Augustus Beaufort LL.D. 1739–1821 (Kilkenny 1987).
64. Albert Siggins, 'DAB's visit to Roscommon town in 1808', Journal of the Roscommon Historical and Archaeological Society 7 (1998) 24–25.
65. Jane Vivien Spring (ed), Kilcolman: parish registers 1793–1814 and 1824–1900, County Kerry, Church of Ireland, with sections from Killorglin, Aglish, Kiltallagh, Knocknane, Molahiffe (Mudgee/New South Wales, c 2003).
66. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
67. John A. Murphy and Emer Purcell (eds), The Desmond Survey, (2013). It includes Desmond, Peyton and Clancarthy Surveys). [Available online at CELT].
68. Pádraig Ó Riain, A dictionary of Irish Saints (Dublin 2011).
**Internet resources relating to placenames**2. The LOCUS Project, UCC (http://www.ucc.ie/locus/).
3. Hogan's Onomasticum online (http://publish.ucc.ie/doi/locus).
4. http://www.logainm.ie (the website of the Irish Placenames Commission).
**About Daniel A. Beaufort**2. See Oxford DNB online: http://www.oxforddnb.com for entry on 'Beaufort, Daniel Augustus' written by Toby Barnard.
**The edition used in the digital edition**2. **Gerard J. Lyne**, Rev. Daniel A. Beaufort's Tour of Kerry, 1788 in Journal of the Kerry Archaeological and Historical Society, Ed. Kieran O'Shea. , Naas, Leinster Leader (1985) volume 18 page 183–214

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 183–214, which includes the editor's introduction and acknowledgements.


#### Editorial Declaration


##### Correction


The text has been checked and proofread twice. Editorial footnotes are retained, renumbered at CELT, and take the form note type="auth" n="" All supplied text is tagged. Text supplied by the editor is marked sup resp="GJL".


##### Normalization


The electronic text represents the edited text. Some abbreviations in in the footnotes regarding book and journal titles and genealogical information have been expanded silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0= the description; div1= the entry; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. Date values are encoded.


##### Interpretation


Names of people, places and botanical terms are tagged.


#### Canonical References


This text uses the DIV1 element to represent the Entry. ### Profile Description


Created: By Daniel A. Beaufort (1739–1821)
 (August 1788) #### Use of language


##### Language: [EN] The translation is in English.


##### Language: [LA] Some terms are in Latin.


##### Language: [GA] Some words are in Irish.


##### Language: [ES] Two words are in Spanish.


##### Language: [FR] A few words are in French.


### Revision History


* (2014-05-28) Beatrix Färber (ed.)

* File parsed; SGML and HTML files created.
* (2014-05-24) Beatrix Färber (ed.)

* File proofed (2).
* (2014-05-22) Beatrix Färber (ed.)

* File parsed and validated; bibliographical details compiled and checked, provisional SGML and HTML files created.
* (2014-05-21) Beatrix Färber (ed.)

* File proofed (1), structural and content encoding applied including personal and place names; footnotes integrated and renumbered.
* (2014-05-13) Beatrix Färber (ed.)

* Text converted to XML; TEI header created.
* (2014-05-12) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E780002-001


### Rev. Daniel A. Beaufort's Tour of Kerry, 1788: Author: Daniel A. Beaufort




---

p.183


### Rev. Daniel A. Beaufort's Tour of Kerry, 1788


Daniel Augustus Beaufort (1739–1821),[1](javascript:footNote('E780002-001/note001.html')) was the son of Daniel Cornelis de Beaufort, a French Huguenot clergyman who settled in London in the 1720s. He subsequently entered the Church of England, serving as rector of East Barnet where his son, Daniel Augustus, was born. Going to Ireland with the viceroy Lord Harrington in 1747, Beaufort senior became successively rector of Navan, provost of Tuam and finally, rector of Clonenagh, Co. Laois, which post he held until his death in 1788.


Daniel Augustus was educated at Trinity College, Dublin, where he had conferred on him the degree of LL.D. He took orders, and in succession to his father was rector of Navan (1765–1818). In 1790 he was presented by **John Foster**, Speaker of the Irish House of Commons, to the vicarage of **Collon**, Co. Louth, where he built a new church and remained until his death. He married Mary, daughter and co-heiress of William Waller of Allenstown, Co. Meath. His elder son, William Louis Beaufort (1771–1849), whose name features in the diary below, became a Church of Ireland clergyman. His younger son was **Sir Francis Beaufort** (1774–1857), rear admiral and distinguished hydrographer. His daughter Frances became in 1798 the fourth wife of Richard Lovell Edgeworth and the stepmother of the authoress **Maria Edgeworth**.


Beaufort was a man of many parts. He was prominently involved in the foundation of Sunday schools and in the preparation of elementary educational texts. He is credited, moreover, with a large measure of responsibility for the foundation of the **Royal Irish Academy**. He is, however, best remembered as a geographer, his most important work being his civil and ecclesiastical map of Ireland which, with an accompanying memoir, was published in
1792[2](javascript:footNote('E780002-001/note002.html')) under the patronage of the lord lieutenant, the **Marquis of **Buckingham****. This was considered a valuable contribution to geographical studies of the day, though it is worth noting that the eminent antiquarian **John O' Donovan** commented scathingly on what he considered its shortcomings, particularly with regard to placenames.


Beaufort intended by on-the-spot observation to remove the defects of existing maps, and his tour of Kerry, which was only part



---

p.184



of a much more extensive itinerary of the entire country, was undertaken with this aim in view. He seems, in fact, to have been a compulsive traveller and diarist. Between 1764 and 1810 he undertook, besides several Irish tours, similar journeyings through the Low Countries, England and Wales. His wife Mary and daughter Louisa, who accompanied him on several of his peregrinations, (his wife was with him in Kerry in 1788 and again in 1810), also kept some travel diaries of their own. The originals of many of these were acquired some twenty years ago by Trinity College, Dublin.


It may be noted that in addition to his travel diaries Beaufort also kept extensive journals of a more personal nature. The originals of these are today in the Huntington Library of San Marino, California, though microfilm copies are available in Trinity College, Dublin. In addition, the National Library of Ireland holds a quantity of Beaufort correspondence,[3](javascript:footNote('E780002-001/note003.html')) including letters to Daniel Augustus from his future wife and various acquaintances, and also correspondence of his daughters, Harriet and Louisa, and his son William.


Beaufort's diary of his tour of Kerry in 1788 is contained in TCD Mss 4029–30, which also outline the more extensive tour of Ireland which he undertook between 3 July and 17 September of that year. This led him through parts of the north and west to Co. Clare, and thence, via Mallow and Millstreet, Co. Cork, to Killarney. After leaving Kerry via Bantry, he traversed several other parts of Co. Cork, before eventually returning to Dublin. This would seem to have been his first and only systematic tour of Kerry, though he revisited the county, and in 1810 updated some of the earlier entries in his diary.


Beaufort was clearly a methodical and disciplined observer. At the commencement of his journal for 1788 he sets out an elaborate series of objectives which he hoped to achieve in the course of his tour. He proposed to obtain information on a wide range of subjects, including such diverse topics as the quality of the soil in each locality, state of the poor, details of antiquities ‘in anybody's possession’, condition of the corporate boroughs, traditions of the ‘antient Irish’, and names of the Church of Ireland clergy in each parish. Given the limited time and resources at his disposal and his evident lack of contacts outside the rather narrow ambit of Ascendancy Ireland, such a programme would seem to have been somewhat ambitious. A reading even of the Kerry portion of his diary, however, shows that he achieved some degree of success with



---

p.185



regard to all his objectives and his diary provides, in fact, many valuable insights into social and economic conditions in the Kerry of his day. Considering the primitive state of the Irish roads at this period, and the often unsavoury condition of available accommodation, one can only marvel at the hardihood and enterprising spirit displayed by such an intrepid inquirer.


A few points should be noted concerning the text. Beaufort's frequent abbreviations of words and, on occasion, entire sentences, have been silently expanded. Where, however, his abbreviations give rise to doubt this is clearly indicated. His occasional arbitrary switches from past to present tense have, where appropriate, been silently amended, and in a few places the order of his sentences has been changed to provide a more logical sequence. In addition, some repetitive or inconsequential material has been silently suppressed. The manuscript includes some marginal notes dated 1810 and a few which are undated. In the case of most of these undated notes it is possible from an examination of the original manuscript to distinguish those which are contemporaneous with the main text from later entries. The former have been silently incorporated at the appropriate points in the main body of the text; the latter are clearly indicated in the footnotes. Finally, the page references of the original manuscript have been incorporated in square brackets in the printed text.


### Acknowledgements


I wish to thank the Knight of Glin for drawing attention to Beaufort's manuscript and the Board of Trinity College, Dublin, for permission to publish it. Dr Pádraig de Brún of the Dublin Institute for Advanced Studies read the typescript and offered many helpful suggestions. The following also helped: Dr Breandán Ó Cíobháin, **An Coimisiún Logainmneacha**; Maura Scannell, Head of Herbarium, National Botanic Gardens; Fergus Gillespie and Gerard Long, National Library; Dr Michael Ryan and Mary Cahill, National Museum; Judith Cuppage, Dingle Archaeological Survey; Rev Bartholmew Egan, O.F.M., Franciscan House of Studies, Killiney; Daniel Moriarty, Kenmare; Brian Fitzelle, Ardilaun House, Dublin; Mrs K. Brown and Mrs M. O'Riordan, Kerry County Library; Mrs Valerie McK. Barry, Callinfercy House; Mrs Jane V. Spring, New South Wales, Australia.




---

p.186


{Ms 4029 page 88} August 14
  

Set out early from Millstreet (at 7) & at 11 1/2 *[o'clock]* reached Killarney. We had desperate heavy rain. The road is through a dreary but very improveable Mountain. One mile from Killarney are fine oak Woods. The great Inn — Mrs Hamilton's — was full so we went to the second — Coffee's — & were obliged to take lodgings for Mary[4](javascript:footNote('E780002-001/note004.html')) & William[5](javascript:footNote('E780002-001/note005.html')) & me. The Bishop of Limerick's[6](javascript:footNote('E780002-001/note006.html')) visitation was held here this day. He sent to ask me to dinner twice but I did not hear the message till 6 o clock. I went in the evening to see him.


{Ms 4030 page 1} 
August 14 Killarney[7](javascript:footNote('E780002-001/note007.html'))
  

We arrived here before twelve & walked a little about the town. After breakfast saw the Church, which is very shabby, & transcribed a curious epitaph that is to be seen there on marble tablets.[8](javascript:footNote('E780002-001/note008.html')) After dinner I waited on the Bishop[9](javascript:footNote('E780002-001/note009.html')) who had sent several messages to ask me to dinner, but which were not delivered to me till 6 o'clock. At 8 I found him still at the bottle. There I met Dean Graves[10](javascript:footNote('E780002-001/note010.html')) & Dr Day[11](javascript:footNote('E780002-001/note011.html')) & Mr Huson[12](javascript:footNote('E780002-001/note012.html')) — old acquaintances. Day promised to introduce me to Lord Kenmare[13](javascript:footNote('E780002-001/note013.html')) tomorrow.


An assembly tonight at our Inn not very numerous but the



---

p.187




women mostly very pretty, particularly Mrs Herbert[14](javascript:footNote('E780002-001/note014.html')) of Cahirnan & Mrs Dunlavy.[15](javascript:footNote('E780002-001/note015.html')) The Kenmare family w*[ith?]* la Marquise de
Severac[16](javascript:footNote('E780002-001/note016.html')) were there but retired early. Cornet Stapleton was very civil & attentive to us. He will procure us the band & a boat.[17](javascript:footNote('E780002-001/note017.html'))


*[August]* 15
  

Dean Graves breakfasted with us and invited me to go and spend some days at Sackville.[18](javascript:footNote('E780002-001/note018.html')) He offered to introduce me to Lord Kenmare & we {Ms 4030 page 2} walked up there but the family were at prayer. Dr Day went with me after 12 when we were politely received & asked to dine tomorrow. Lord Kenmare shewed *[us]* a curious Gorget of pure gold, 9 Inches in Diameter, found a few days ago under a rock, as his men were making a road. Weight 4ozs., I hear. The fretted borders are evidently done with a stamp, not with a chisel.[19](javascript:footNote('E780002-001/note019.html')) He asked me to dine tomorrow but I refused the honour to go on
the Water.


My party went out to ride in Lord Kenmare's park & I met them between that & Mucruss, a very pretty ride along the River Flesk, which we crossed on a Bridge of 24 arches,[20](javascript:footNote('E780002-001/note020.html')) then passing by



---

p.188



Cahirnane — Mrs Delanys[21](javascript:footNote('E780002-001/note021.html')) — come to the Abbey of Mucruss.[22](javascript:footNote('E780002-001/note022.html')){Ms 4030 page 3}
 A few years ago a hermit dwelt in the Abbey having roofed part of the refectory with broken Coffins. He was teised & plundered & he went away, about 10 years ago. A woman who attends for the friar, to whom the key of the place is entrusted, told us that Mass is celebrated here on a temporary altar with great pomp on the 3d of August, St Jingler's day, when 4 or 5 other friars attend & all the country come here to confess & do penance.[23](javascript:footNote('E780002-001/note023.html')) From hence we crossed into the beautiful grounds of Mucruss, & walked along a terras of uncommon magnificence over hanging the lake to the house of Mr Herbert,[24](javascript:footNote('E780002-001/note024.html')) a very mean & ruinous structure.[25](javascript:footNote('E780002-001/note025.html')) The family *[are]* just gone to England. In Mucrus House is a very fine picture by Hudson[26](javascript:footNote('E780002-001/note026.html')) of Lady Emily Butler sister to the last Duke of Ormond who survived both her brothers, & died at 99 Years 11 Months, as Lord Kenmare told us.[27](javascript:footNote('E780002-001/note027.html')) The Hall is flagged with the red & white marble of Mucruss, of which there is



---

p.189



a great Quarry.[28](javascript:footNote('E780002-001/note028.html')) Near Mucrus is a small Village of Cloghreen, many protestants, & a ruined church.[29](javascript:footNote('E780002-001/note029.html'))


{Ms 4030 page 4} August 16
  

The weather still continuing very showery and a large party from Waterford having engaged the great boat & the Regimental Band we were a good while in doubt whether we should follow them in another boat & so hear the Musick, etc. At last it was decided that we should not to on the Water. Mr Caldwell,[30](javascript:footNote('E780002-001/note030.html')) Mr Walsh[31](javascript:footNote('E780002-001/note031.html')) & I paid a visit to Lord Kenmare, where I made a sketch of a gold breastplate found about a month ago under a large rock, as his men were making a new road here. It is 9 Inches in diameter, & 3 broad at bottom, but very thin. Lord Kenmare says it weighs 14 Guineas.


Lord Kenmare assured us that we might stay here long enough before we should find a better day, & insisted on ordering his boat for us to explore the lake. This we could not reject so the boat was got ready, & my two companions & William rode down to **Ross Castle**[32](javascript:footNote('E780002-001/note032.html')) to embark while Robin[33](javascript:footNote('E780002-001/note033.html')) & I drove on to Mucrus to {Ms 4030 page 5} collect the rest of the party. We drove thro the woods & found them at a stand by a new unfinished bridge. Here with difficulty the Carriages were turned about and we all returned to Mucrus house & at the Quay found our friends who had rowed round.[34](javascript:footNote('E780002-001/note034.html')) From thence we returned to **Ross Castle** where Mr Newport's postilion had like to be drowned by attempting to water his horse in the lake at a place where the bottom is soft {Ms 4030 page 7} Bog. Wet & tired we got to our Inn at 1/2 past 7 & as soon as we had dined, the ladies went



---

p.190




to bed. And so ended a Day, very like this weather, rather dull & stupid, with a few gleams of pleasure & Sunshine.


Lord Kenmare's house is an old plain rough stone building — not lofty but having 13 Windows in front — with very extensive offices as wings on each side. In it are some very good pictures — a beautiful group of elegant figures by Amicdi[35](javascript:footNote('E780002-001/note035.html')) over the Chimney, and a large Vestumnus & Pomona by Sr Peter Lily,[36](javascript:footNote('E780002-001/note036.html')) with his name to it — of more curiosity on account of the painter, than merit from the painting.


His Gardens, of which I saw but little, appear to be in the old stile — fine broad Gravel walks & hedges. There was a canal in the middle but he has long ago converted that to grass. The lake can only be seen from his upper Windows or Garrets.


{Ms 4030 page 8} August 17
  

Sunday — a delightful fine day. I went to Church where Mr Dunlavy read prayers & Herbert[37](javascript:footNote('E780002-001/note037.html')) preached 12 Minutes without being heard or understood by me. After Church Mrs Young[38](javascript:footNote('E780002-001/note038.html')) & I took an airing thro Lord Kenmare's park, saw his Glynn which is exceedingly beautiful & had from the terras in the park a fine view of the lake etc. In this park stands a large Stone upright which seems to have been the back of a Judgment Seat.


*[August]* 18
  

This morning we assembled at 7 1/2 *[o'clock]* for our grand boating party but the day being extremely wet we sat down to **Vingt un**[39](javascript:footNote('E780002-001/note039.html')) after breakfast. At Eleven it began to clear up, the boatman urged us to go, & we all drove down to Ross Castle. We were all very conveniently in the Barge of 8 Oars with a part of the band which Col. Jacques of the 51 *[st Regiment]* {Ms 4030 page 9} lent us, & in



---

p.191



another boat were our Servants & provisions. We reached the Eagle's nest, & were put on shore opposite to it, while our band went into a recess behind it. We heard their musick reverberated from the rock & quite softened, but loud enough & very true. From the rock above our heads some small cannon were fired, precisely opposite the Eagle's nest which repeated the report enlarging it to that of a rowling peal of Thunder. Poor Mrs Pennyfeather[40](javascript:footNote('E780002-001/note040.html')) was obliged to stop her ears so afraid she is of a Gun {Ms 4030 page 10}. A very heavy shower assailed us, & determined us to return to Dinas. On our way we saw a pair of Eagles soaring above us & at the Eagle's nest the royal bird itself upon it which our repeated shouts put to flight.[41](javascript:footNote('E780002-001/note041.html')) It was half after Six when we arrived at Dinas. We dined heartily & merrily on our cold repast & when the musick, the boatmen & servants were all replete set off for Ross Castle, by the brightest Moonlight. The water was smooth, the night calm & our
passage delightfully harmonious in every sense. William in landing his aunt out of the boat fell on his head in the water. Our boatmen plied their oars so lustily that we reached shore by 9 & got {Ms 4030 page 11} drest quick & went to the Assembly which was much larger than the last. Mrs Pennyfeather being extremely well dressed made an elegant appearance and we afterwards supped together. Did not get to bed till two.


*[August]* 19
  

Showery again this morning yet we got to breakfast by 9 & at ten set off for Ross Castle, embarked again in two boats & proceeded to the foot of Glena near Dinas, where a large company was assembled in boats to see a Staghunt, with which O Donoghue[42](javascript:footNote('E780002-001/note042.html')) complimented Mrs Pennyfeather. As soon as we arrived a gun was fired & the hounds laid on. We soon heard their tongue, & by the



---

p.192




course of the sound in the wood, and that of the men who were placed to man the Mountain, we were guided on Westward, and the whole fleet of fifteen sail was in motion. In about an hour we perceived the stag {Ms 4030 page 12} come down from the wood, refresh himself in the lake, and then run along the shore for a mile, when he turned again into the wood. Our Boatmen anxious to catch him if he should take Sail rowed with such spirit as to pass all the rest. But they also passed the stag, for he had doubled, & tho we made haste back we were only in time to see him once more take sail, when he was soon taken up by Mr Galway's[43](javascript:footNote('E780002-001/note043.html')) boat, & tied there. The whole party attended him from hence to Stag Island near which he was untied & thrown into the lake, from which he swam to the shore of that Island, & lay down.


The boats dispersed now different ways — we to Innisfallen, where we had a cold dinner prepared, & fared sumptuously after walking round that Beautiful Island & observing the noble trees that adorn it, particularly a vast **holly** and a great **Yew**, the former large & lofty as an **Oak** & measuring 10 feet in circumference[44](javascript:footNote('E780002-001/note044.html')) {Ms 4030 page 13}. While we were here Mr Mahony[45](javascript:footNote('E780002-001/note045.html')) brought over the hunted stag to this Isle in his boat to secure him from the Mountaineers who would have slain him for his hide. He had been hunted once before, the tip of one ear being cut off — & now the tip of each is gone. We passed our time here agreably till near 9 when we returned as before. When we landed at Innisfallen a crowd of apple women & nutsellers etc. were assembled there before us, just as if it were a fair, or rather like the savages coming down to barter with our ships in distant Islands.


*[August]* 20
  

Mr Caldwell & Mr Walsh agreed to accompany me to Dingle, etc. & so round to Cork {Ms 4030 page 14}. Mr Caldwell having obtained leave from Mrs Delany to see Mr Herbert's collection of drawings we called on her at her very neat English looking house[46](javascript:footNote('E780002-001/note046.html')) near the lake, & went thence to Mucrus, where we were well entertained for 



---

p.193



two hours with some elegant works of Sandby,[47](javascript:footNote('E780002-001/note047.html')) Rowlandson,[48](javascript:footNote('E780002-001/note048.html')) Calendar,[49](javascript:footNote('E780002-001/note049.html')) Tomkins[50](javascript:footNote('E780002-001/note050.html')) & Dom. Serres[51](javascript:footNote('E780002-001/note051.html')) & thro' some beautiful glades with the Gardener who laments that his present master has so different a taste from his father[52](javascript:footNote('E780002-001/note052.html')) that to make the most of the grass he suffers cattle here to browse on the trees & shrubs that clothe these wonderful rocks. In a glade here, the Gardener assured us that abundance of **Morilles**[53](javascript:footNote('E780002-001/note053.html')) grow every year. He shewed us Pears grafted on **Quickbeam**. There are here some very large **Cypress**, & great **Arbutus**. At 6 we got back to dinner {Ms 4030 page 15}. After dinner we amused ourselves correcting the numerous errors in **Col. Vallancey**'s map of the Lake.[54](javascript:footNote('E780002-001/note054.html')) At Mucrus & in Ross Island are mines of Copper & lead-worked till very lately.[55](javascript:footNote('E780002-001/note055.html')) Much of the Ore lies on the Ground. In Mucrus there is a smelting furnace and fine Marble quarries. In Ross are also several quarries of Marble, some shaded & speckled red & white — some grey & white — with other varieties to be seen in chimney pieces all over this town.


There are great numbers of Red Deer always in Mucrus who eat up the corn etc. unless it be watched very close, as the Gardener told us. The country hereabouts is, in general, but poorly cultivated.[56](javascript:footNote('E780002-001/note056.html')) Saturday is Market day in Killarney but there are a vast number of hawkers selling things in the street every day — particularly under the Market house — where also our Carriages stood, & we paid a man to watch them every night. Over this Market house is the Ballroom.


In Killarney are quartered, on the town, 2 troops {Ms 4030 page 16} of 


---

p.194




Dragoons, & 2 Companies of foot, besides 2 Companies more stationed in the Barrack at Ross Castle.[57](javascript:footNote('E780002-001/note057.html'))


*[August]* 21 To Dingle.
  

The first 8 Miles *[are]* well planted & beautiful, affording many fine views of the Lake. We then turn off Norwards thro a dreary country & by a strait road. Slieve na Miss *[Slieve Mish]* stands in front of us & the two ridges leave an opening for Castlemain harbour. Descending into the Vale which the Maing *[Maine]* waters, the Country seems rich & capable of great Improvement at a very small Expense.


Milltown, a small markettown 1 mile South West of Castlemain belongs to Sir William Godfrey[58](javascript:footNote('E780002-001/note058.html')) who lives close to it & it is likely to become a thriving place as Sir William told us that to encourage inhabitants he gives them ground to build on rent free for ever.


There are here 3 Saltworks. The Rock salt & all heavy matters are, brought up narrow {Ms 4030 page 17} Channels, like the Welsh pills,[59](javascript:footNote('E780002-001/note059.html')) to within 1/2 a Mile of the Town where there is a quay.[60](javascript:footNote('E780002-001/note060.html')) We saw there a vessel of 70 tons burden discharge her cargo & another taking in Copper Ore from Killarney. They get also by this conveyance great quantities of rich sand filled with Muscles & other shells, from the Peninsula of Inch Island about 8 Miles navigation, with which they manure their land, at the rate of about 10 boat loads to an Acre, & a boatload sells for 6 shillings. But it is also retailed in horseloads for the convenience of the poor.[61](javascript:footNote('E780002-001/note061.html'))
The Church stands on the West of the town. Here is also a ruined Abbey,[62](javascript:footNote('E780002-001/note062.html')) of which a long Church only is remaining — remarkable 



---

p.195




for the excellent plan of its large Course & for a parapet all round it.


Mr Caldwell & Mr Walsh on their horses & William & I in my chaise had left Killarney at 8 & came here to breakfast in a very poor Inn. After our Meal we walked {Ms 4030 page 18} about — saw a beautiful wood of 100 acres of Sir William Godfrey's copsed & growing well on the fine round hill. As we returned to our Inn the Baronet came to see us, asked us to stay & dine with him — offered us fruit — & actually detained us half an hour to give us a fine apple. He is member for Tralee.


**Castlemain** is now a most wretched village, only a few cabbins at each end of a very long bridge over the Maing. On the East side of this bridge are large ruins of a Castle,[63](javascript:footNote('E780002-001/note063.html')) & on the West some also, with several marks in the battlements where the gate that defended this pass antiently stood. A singular situation for a Castle, in the midst of a river in which the tide might bring large vessels. Yet there is a Constable of this Castle with a Salary of 10 sh*[illings]* per day besides a considerable piece of land near it: Capt Botet,[64](javascript:footNote('E780002-001/note064.html')) who lives at {Ms 4030 page 19} Kinsale, is the present Constable & Sir William Godfrey says it is altogether worth £300 a year.[65](javascript:footNote('E780002-001/note065.html')) In the flats about this river I observed a number of navigable streams that fill with the tide & bring up boats.


*[I]* observe in this country Wooden Mugs of all sizes neatly turned, with handles of the same piece, a difficult work.[66](javascript:footNote('E780002-001/note066.html'))


Here we turn due West with Slieve Miss on our Right which continues under different names such as — *[sic]* etc. to the head of Donmore. The road runs pleasantly along the harbour of Castlemain which is formed by Inch Island. The river Inch tumbles down a wonderfully rocky channel, thro a gap in the Mountains. Here we leave the coast & turn to the Left {Ms 4030 page 20} Breach Innis on our Right 



---

p.196



& Mam Inch on our Left — wild Mountains.[67](javascript:footNote('E780002-001/note067.html')) This road leads us to a nice fertile vale amidst these hills where we took notice of some huge Druidical Stones on the side of **Mam Inch**, one of which we made a drawing of 14 feet high & 1/2 Circumference. On the Eastern angle there seem to be some Ogham Characters. About half a mile farther we saw another on our left[68](javascript:footNote('E780002-001/note068.html')) but it rained so desperately we could not stop.


We soon came to an old house called Hamiltons Inn — worse than any Spanish posada[69](javascript:footNote('E780002-001/note069.html')) — yet kept by a man who lived 14 years coachman to Dr Andrews[70](javascript:footNote('E780002-001/note070.html')) the Provost, & in other elegant houses. It was dark before we reached Dingle & took up our lodgings in a very poor dirty inn, kept by Alexis Moriarty.[71](javascript:footNote('E780002-001/note071.html')) I sent Lady Anns[72](javascript:footNote('E780002-001/note072.html')) letter to Mr Hicksons,[73](javascript:footNote('E780002-001/note073.html')) but {Ms 4030 page 21} he was gone to Tralee. However, his Wife [74](javascript:footNote('E780002-001/note074.html')) invited me to sleep there which I declined.


*[August]* 22
  

Having come in so late it was near two before we got to bed last night. We rose late therefour this very wet morning. We could not get a ride it rained & blew so hard but about 2 it cleared up enough for a walk about the town & round by the shore of the Harbour 



---

p.197



which is stony not sand. We saw also another great Stone a mile West of the town.[75](javascript:footNote('E780002-001/note075.html')) Paid a visit to Mrs Hickson & walked about Lady Anne Fitzgerald's improvements, which never were much & are now much neglected.


### Dingle


A long street on a rising hill, with one cross down to the Quay. Several good houses & some new ones, but all look délabrés. All the antient buildings mentioned by Smith[76](javascript:footNote('E780002-001/note076.html')) have been pulled down within 30 Years — but I suspect that what they called balconies were only large stone windows as in Galway {Ms 4030 page 22}.


The inlet into the harbour between two high points is very pretty. That on the East side is called Nancy Browns parlour[77](javascript:footNote('E780002-001/note077.html')) from a small cave in it, dry at low water & into which the sea flows. Near it were dug out of the sand some years ago 3 very long Cannon which are set up as posts for lamps at the Knight of Kerry's Gate.[78](javascript:footNote('E780002-001/note078.html')) They probably belonged to the Spanish armada of which a great ship was wrecked on the coast.[79](javascript:footNote('E780002-001/note079.html')) Fewer shops in Dingle in proportion to its size than I have seen any where else. A Barrack here for 2 Companies.


The Church[80](javascript:footNote('E780002-001/note080.html')) was very large & consisted formerly of two long paralel Aisles. The East end of the South aisle stands & has a very fine window — the rest is destroyed, and the East end of the North aisle is also cut off by a wall with a mean window which bounds the present church. The South side of it has the Arches which communicated between the two aisles barely stopped up. The Roof is



---

p.198



new but not close at the Bellfry. Inside there are neither Rails nor Desk nor Pulpit nor floor nor ceiling nor plaister on {Ms 4030 page 23} the walls — but 3 large fine Canopy seats, supported by Corinthian columns — one for Mr Mullins[81](javascript:footNote('E780002-001/note081.html')) & two for the Knights family, which are still hung with black (for Lady Anne continued to live here after his death till some ill treatment drove her away). The windows are all broke & there is no door to the Church Yard, but the passage is the filthiest part of the whole town, over shoes every where. In short this is the worst Church I ever saw. Mullins is Rector & — *[sic]* Vicar;[82](javascript:footNote('E780002-001/note082.html')) Mr Goodman[83](javascript:footNote('E780002-001/note083.html')) curate.


At this town is a bleach green & some linnen weaving carried on by Mr Moriarty.[84](javascript:footNote('E780002-001/note084.html')) Dominick Trant[85](javascript:footNote('E780002-001/note085.html')) has an Estate here. Market on Saturdays. Fish very plenty — I bought a great Turbot *[of]* 15 lb for 4s./6d. The borough belongs to Townsend.[86](javascript:footNote('E780002-001/note086.html')) 50 or 60 freemen *[reside]* in Co. Cork — not one resident here.[87](javascript:footNote('E780002-001/note087.html')) No Magistrate or any thing else — 2 only at an Election.[88](javascript:footNote('E780002-001/note088.html')) The borough belonged formerly to the Mullins family {Ms 4030 page 24}.


Vast quantities of Herrings are caught here. The Gourdet[89](javascript:footNote('E780002-001/note089.html')) exists, & we might have had some but for the bad rough weather. Their excellence Alexis vouches. Ti-vouria[90](javascript:footNote('E780002-001/note090.html')) is a little village larger than Ventry. So is Smerwick.


*[August]* 23 To Tralee
  

Disappointed by the bad weather of yesterday, but unable to remain here longer, we set off at 9 — William & I in the chaise by the great road, Mess*[rs]* Caldwell & Walsh by the Connors, a Mountain 5 or 6 miles off which is so perpendicular on the North side that they descended by 13 flights of steep narrow road, just wide enough for one horse, but having a good parapet of sods, yet infinitely too steep to ride it. From thence they crossed for some miles the most beautiful Strand that could be seen[91](javascript:footNote('E780002-001/note091.html')) & saw both Kerry head & Loop head. On this road they met a common fellow with a pack of hounds which he said were his own & that he was paid by the country folks for going about killing the foxes with them.




---

p.200


From the hills on this side of Dingle we saw Ventry bay very distinctly across a very narrow istmus between it & Dingle bay just beyond Mr Mullins new house.[92](javascript:footNote('E780002-001/note092.html')) At 1 1/2 Miles we came to a great Stone a little off the Road on the right hand. Its dimensions were 14 1/2 feet hight & 16 in circumference.[93](javascript:footNote('E780002-001/note093.html'))


We returned the same road we had come {Ms 4030 page 25} for 8 Miles. The Mountains on our Right & Left are well expressed in Sk*[inner?]* & T*[aylor?]*.[94](javascript:footNote('E780002-001/note094.html')) On the sides & in the Vallies there is a good deal of poor tillage — the Crops good & harvest forward — much Wheat & Flax. Some of the highest hills are green to the top. But not a tree anywhere to be seen.


At the fort of Cahirconree[95](javascript:footNote('E780002-001/note095.html')) the View of Kerry head & Tralee bay opens to us. Here we stopped at a cabbin to feed & William & I walked on. The place is called Glandine. From the high ground under Cahirconree saw St Brandons Mountain & head, bluff & boldly projecting a Cliff into the Sea — as also Kerry head from whence low Mountains rise & coast the Shannon for 8 or 10 Miles. Kilgobbin Church & Glebehouse[96](javascript:footNote('E780002-001/note096.html')) *[were]* on the Shore quite under us.


The Rock of Muccollogh[97](javascript:footNote('E780002-001/note097.html')) which stands in Tralee bay, single, is placed too much to the East in Kitchin's map.[98](javascript:footNote('E780002-001/note098.html')) The West Terminus of Tralee bay is a continuous heap of sandhills. Off that point lie the Maghery Islands, where much fine corn grows & Barley is frequently ripe in 6 Weekes from Sowing. 


{Ms 4030 page 26}We pass by a very small ruinous Church of Killeltin.[99](javascript:footNote('E780002-001/note099.html')) A mile 


---

p.201




farther at Derrynane where there are a few trees[100](javascript:footNote('E780002-001/note100.html')) the Chaise overtakes us.


The Road to Tralee is very dull & flat. A mile & half from it a bridge crosses the River, close to which are Saltworks, & an embankment forming against the Sea. Here the Town ought to have been built.


### Tralee


The entrance is very dirty, the town very rambling in its plan. Some good houses on the Mall, a broad street by Sir Barry Denny's[101](javascript:footNote('E780002-001/note101.html')) frightful old Castle.[102](javascript:footNote('E780002-001/note102.html')). A Square very small & irregular. The Church is large & decent but never painted. A large new Jail[103](javascript:footNote('E780002-001/note103.html')) is building. Many houses building so that half the streets are in rubbish.[104](javascript:footNote('E780002-001/note104.html'))


The husbandry seems wretched all round this town, tho' the ground is exceptionally good, & lets near the Town for £4 — and at some miles off for 2 Guineas — per Acre.


{Ms 4030 page 27}The Riders did not arrive till past 6 very weary. Dean Graves called on us & asked us all to breakfast & dinner tomorrow.


*[August]* 24 Ardfert
  

In our way we resolved to see the Spa[105](javascript:footNote('E780002-001/note105.html')) so went round by the bay which, the tide being full appeared to the best advantage, but very bleak & dreary. At last we arrived at a little walled enclosure



---

p.202



on the beach in which is a small well just rudely covered over, with sod benches round the wall. The fair dispenser of these Hygeian Waters soon appeared — a little old woman who could not speak a word of English. But she lifted the water in a tin can & poured it in a rinsed glass, much cleaner than at Mallow. The water much as that of Castle Connel[106](javascript:footNote('E780002-001/note106.html')) to the taste, but leaves no Sulphurous tack.


From hence 4 Miles dreary enough to Ardfert, a very small ruinous village. Sacville is 1/2 m from it on a very small {Ms 4030 page 28} eminence — in this flat Country an exceeding pretty one — just
built by himself *[Dean Graves]* but yet bleak. Here we found his Mother, Wife & Sister — Mrs Drought (Graves),[107](javascript:footNote('E780002-001/note107.html')) Master Doyle,[108](javascript:footNote('E780002-001/note108.html')) etc. Breakfasted & then to Church.


The Church[109](javascript:footNote('E780002-001/note109.html')) is small, with a great pew for Lord Glendore,[110](javascript:footNote('E780002-001/note110.html')) a Throne for the Bishop & a few others, added to the South side of the old Cathedral which is a large ruin, very lofty & very antient. The arches *[are]* chiefly round particularly the West door which is very antient & very curious, of soft red stone well carved, but mostly worn out by the weather. The East window *[consists]* of 3 long ones 30 feet high. The whole South side overhangs & threatens ruin, & they are now undermining it for graves.


There are here several other old walls, one very antique with round arches & carvings round the windows & heads for a cornice or eve house. No traces of the Round tower left.[111](javascript:footNote('E780002-001/note111.html')) Much fine **milkthistle** grows here in the Church yard.


{Ms 4030 page 29} After hearing an excellent Sermon from Dean Graves we went to Lord Glendores thro a large Gothick gateway not of a piece with



---

p.203




the rest of his old fashioned place. The House, built 1722,[112](javascript:footNote('E780002-001/note112.html')) is extremely low, illcontrived & ugly, the furniture mean & the prospect bad. In the Gardens are some shady walks, clipt arcades, weeping willows in abundance — & every thing inspires la melancholie to which the ruin of a large fine Abbey[113](javascript:footNote('E780002-001/note113.html')) contributes its share. Tho none bury here now yet Sculls & bones lie about it. In the grounds, however, are very fine double rows of trees, Beech etc., which finely shelter the ground & make noble shady walks. At Lord Glendore's is a monstrous picture of Macbeth by Fuselli.[114](javascript:footNote('E780002-001/note114.html'))


After this we drove to the Strand & so to dinner by 6 o'clock {Ms 4030 page 30} where Richard Graves, F.T.C.D.,[115](javascript:footNote('E780002-001/note115.html')) made another at a handsome entertainment with much good fruit. At ten we left him & got home by eleven to the Inn.


*[August]* 25 Tralee
  

A new Jail now building here seems very ill contrived — the staircases of timber — the lower rooms dungeons with little light or air, too large for one, too small for many. No communication between the Jailers house & the Jail. The windows of the cells open to the Street. Yet Mr Jerom has approved this plan of Mr Lorby a Carpenter who built {Ms 4030 page 31} it by Contract.


We walked into Sir Barry Denny's house[116](javascript:footNote('E780002-001/note116.html')) which is much better than it appears outside. The grounds behind are well wooded & 



---

p.204



have a pretty walk round them. After breakfast my companions set out in their Cabriole for Killarney where I was to follow after paying two visits. My first was to Mr Blennerhassett[117](javascript:footNote('E780002-001/note117.html')) of Elm grove, whom I found now to be the Collector[118](javascript:footNote('E780002-001/note118.html')) & to live in the town opposite the Inn. When I called he had been gone to Elm Grove some hours. I ordered my chaise & followed but on the road was stopped by Col. Blennerhassett[119](javascript:footNote('E780002-001/note119.html')) of Arbela & Counsellor Frankland[120](javascript:footNote('E780002-001/note120.html')) who knew me and as they were going to see me at *[?Ardarty]* they turned back to the Grove, where the Collector has almost finished an immense house,[121](javascript:footNote('E780002-001/note121.html')) in a low situation, close to the river Leigh *[Lee]* tempted by two small offices to prefer this to a noble situation just above it. Here the Colonel made it such a point that I should stay {Ms 4030 page 32} all night at Arbella — & asked the Collector to dinner etc. — that I consented, mounted my horse & rode with them to see several dippings of the River Leigh, and farther on a great Cavern under a ledge of huge rocks, with an open, or window as they call it, upon a perilous abyss. This is called McElligott's prison.[122](javascript:footNote('E780002-001/note122.html')) The lawn at Arbella *[is]* beautiful verdure — without seeds in one year *[commanding]* a fine horizon of great Mountain tops – Musher, 2 Paps, Mangerton, Tork, the Ricks etc.


At dinner were the Collector, Counsellor & Mrs & Miss Frankland, Mrs Letitia Blennerhassett, Miss Leplant & Miss 


---

p.205




Trench from Cork, Mrs Spring & her son Frank[123](javascript:footNote('E780002-001/note123.html')) who was a lieutenant in the Navey & in all the battles with Suffrein.[124](javascript:footNote('E780002-001/note124.html'))


*[August]* 26
  

After receiving great civilities & 5 Subscriptions[125](javascript:footNote('E780002-001/note125.html')) & a request of Franklands to send him some *[?deeds]* when term commences I left this hospitable house at 7 with Mr Spring who {Ms 4030 page 33} accompanied me to Killarney on horseback. 4 miles North of Arbella etc. & parallel to Slieve Miss are a range of low Mountains[126](javascript:footNote('E780002-001/note126.html')) from near Tralee to Castleisland & so to Co. Cork. The vale between *[is]* exceeding rich fine ground & full of Gentlemens' seats — the whole Arthur Blennerhassett's. No trees but about Seats. Ascend & cross a skirt of Slieve Miss, very wild & neglected.[127](javascript:footNote('E780002-001/note127.html')) The whole North side *[is]* Sir Barry Denny's *[and a]* great part of *[the]* South Sir William Godfrey's. Near Castlemain we pass on our right Kiltalla Church & glebe house.[128](javascript:footNote('E780002-001/note128.html')) Bait[129](javascript:footNote('E780002-001/note129.html')) at Miltown & paye a visit to Sir William Godfrey. His wife is a lunatick, I hear. He showed me a daughter[130](javascript:footNote('E780002-001/note130.html')) deaf & dumb who draws mighty well without instruction — a curious print very large of Sir Edmundbury Godfrey[131](javascript:footNote('E780002-001/note131.html'))


---

p.206



and a fine one of Mrs Mathew. {Ms 4030 page 34} His house[132](javascript:footNote('E780002-001/note132.html')) built by himself is very neat & good. He offered us fruit, etc. Saw in his hothouse the **Asclepius** or **honey tree**.


From a hill 3 Miles beyond Miltown *[there is]* a fine view of Castlemain bay & opposite the Rivers Maing & Lane in their way to it. The Lane, which winds considerably, is very broad at Killorglin & crossed over a bridge of 14 arches.


The Ruin of the Church of Killagh[133](javascript:footNote('E780002-001/note133.html')) is on our left on the East of the Lane. The small village of old Castlemain now *[sic; recte 'not'?]* inhabited is on the West side of the river. The whole forms a fine landscape with some wooded seats on the bank *[which we viewed]* from a hill a quarter mile farther. Two miles farther South we turned East & passed a large rivulet[134](javascript:footNote('E780002-001/note134.html')) pouring from the vast range of Mountains that run East & West covering the Rickes about 2 Miles from us. One mile farther another river[135](javascript:footNote('E780002-001/note135.html')) & 2 miles farther still a very broad one.[136](javascript:footNote('E780002-001/note136.html')) All fall into the Lane. {Ms 4030 page 35} There is a ruined church[137](javascript:footNote('E780002-001/note137.html')) near the Mountains & not far from Churchtown, Mr Blennerhassett's. This track is very wild, yet has several good Seats — McGillycuddys,[138](javascript:footNote('E780002-001/note138.html')) etc.


Came to Beaufort where I met James who had lazily gone so late with a message of my intention to wait on Dr Day that he was gone on the lake. Mrs Day was ill & the gate was locked so there was no admittance. We alighted & walked to Dunloe Castle, Mr 



---

p.207




Mahony's[139](javascript:footNote('E780002-001/note139.html')) — a magnificent situation above the Lane on a high wooded bank, very grand & romantick. From the house a beautiful prospect up the meandering River & of the Lake & on the opposite side of the Lane fine woods of Glenagh *[the property of]* Mr Saunders.[140](javascript:footNote('E780002-001/note140.html')) James made a very pretty drawing of Beaufort & Dunloe.


We proceeded to Killarney where I found our Gentlemen were gone to Mangerton & had ordered Dinner at 1/2 past 5. I asked Mr Spring[141](javascript:footNote('E780002-001/note141.html')) *[to dinner]* & kept him waiting till our friends returned at 1/2 past 7. The whole town crouded with {Ms 4030 page 36} gentlemen & ladies to the Quarter Sessions. I lodge now at Mrs Sweeny's. NB. A Ball last night, one tomorrow, & another on Friday, after the Staghunt.


*[August]* 27
  

After breakfast I went to the other Inn to call on Col. *[?Mecfayer]* who received me very politely. The morning being wet we some way idly did not set off till twelve o'clock, being also delayed by various demands & impositions & losing whips, etc. Then drove to Mucruss, embarked there, sailed thro' Tork lake, landed at Dinas where we met a large party from Mr Herberts, chatted a while & proceeded on our voyage to the upper lake, still in rain & clouds, picked up on the bank Mr Carrol the Painter[142](javascript:footNote('E780002-001/note142.html')) & carried him with us, *[then]* landed on Ronan's Isle from the top of which we might see the whole lake of a fine day. Mr Ronan[143](javascript:footNote('E780002-001/note143.html')) *[sic]* himself locked his door on our approach & stood outside of it like a great Brute



---

p.208


{Ms 4030 page 37}
 & would give us no shelter though it rained very hard.[144](javascript:footNote('E780002-001/note144.html')) We left him & rowing across the lake went up the pretty little river of Derrycunnihy on the retired borders of which Mr Blennerhassett is building a Cottage. Here is a tolerable house of a woodrangers where we eat *[sic]* our eggs & drank Brandy & gave the Woman a shilling. She had offered us some Nuts which she had pulled for us & said she was glad she had given them before she received any gratuity.


Corrected Wilson's plan[145](javascript:footNote('E780002-001/note145.html')) of upper lake. Faden's[146](javascript:footNote('E780002-001/note146.html')) is incorrigible.


Martins are plenty here, & in whatever Islands they have been put they have destroyed all rats, rabbits, & even crows. The boatmen say there are squirrels in the woods, but I doubt it. They say also that there are black hares, & in Winter white ones, in the Mountains.


Donal - a - Neelagh's (the enchanted O'Donaghoe) Room at Ross Castle is still haunted, & they tell dreadful Stories of the consequences of foolhardy soldiers who slept there.[147](javascript:footNote('E780002-001/note147.html'))


It grew a little fairer and we {Ms 4030 page 38} set forward to ascend the Hill, about 1 1/2 Miles to the high road where our carriages waited. At one place the River crosses it *[the path]* & I clambered across



---

p.209



over a vast ledge of Rocks, not without much difficulty. The rest rode through it. It was past 6 when we got on the High road and had 6 miles to travel to Kenmare. Mr Walsh & James rode on to bespeak beds & dinner but James was soon sent back to us with intelligence that the road was so exceedingly rocky & had such steep sharp hill & short turns that he did not think the carriage could get there till 12 o' clock. Upon this Mr Caldwell, William & I mounted our horses and proceeded riding & walking alternately along this horrid road thro tremendous rocks {Ms 4030 page 39} & Mountains.[148](javascript:footNote('E780002-001/note148.html')) At last it grew very dark, but the road was good. The descent being steep, however, I alighted & was walking quietly & solitary down when the Chaise to my astonishment overtook us. I got in and at 9 we arrived all safe at Nedeen,[149](javascript:footNote('E780002-001/note149.html')) where we found but little room at Mrs O Sullivans[150](javascript:footNote('E780002-001/note150.html')) — one bed for us two; another for Mr Caldwell. Mr Walsh lay on Chairs. After a tolerable supper we got into our poor beds at 2.


Capt. Offley of the 21st *[Regiment]* — a friend of Mr Caldwell quartered here — came to see him & engaged us to breakfast & dine the next day. There was no bed for the Servants who sat up all night, nor provender for the horses. I wrote to Mr Pelham[151](javascript:footNote('E780002-001/note151.html')) (naming Lady O'Brien)[152](javascript:footNote('E780002-001/note152.html')) though I knew he was not at home. But



---

p.210



Mr Stewart[153](javascript:footNote('E780002-001/note153.html')) the Curate who read my note gave us hay & stabling & Capt. Offley sent oats.


{Ms 4030 page 40}August 28
  

Kenmare or Neddeen consists of a very few houses; one lately taken from Mr Stewart for a Barrack;[154](javascript:footNote('E780002-001/note154.html')) near the Village a strange illcontrived illexecuted small house[155](javascript:footNote('E780002-001/note155.html')) for the marquis of Lansdown's agent, which cost £1,000, where the Stewarts live with Mr Pelham.


The rocky grounds hereabouts let for one Guinea per Acre — yet the people are better dressed & Housed than with us. Very little tillage — much oats & potatoes are imported — all owing to smuggling, which is now almost annihilated.


The barracks here *[is]* not large enough for one Company *[and]* they have as yet no beds or bedding sent to them. Quartered here now *[are]* Capt. Offley *[and]* Lieuts. Darragh & Fitzgerald, with whom we breakfasted, then paid a visit to Mr Stewart, who very civilly offered to ride with us, & accompanied us along the Shore to the West, as far as Blackwater, a rapid river which in a deep Glen partly wooded tumbles from rock to rock & rolls precipitate a foaming torrent under a very {Ms 4030 page 41} lofty bridge[156](javascript:footNote('E780002-001/note156.html')) which forms the connection between two sloping roads. Along the whole ride *[we]* had a fine view of Kenmare river, and distinctly saw **the Bull**, a vast high rock which faces the mouth of the harbour, 10 leagues from Neddeen.


Just near the Village boats come to the Sound, a narrow part of *[the]* River contracted by a projecting peninsula, on which there are a saltwork & other buildings. Small craft lie in a snug bay behind 



---

p.211




it. The largest Ships come within a mile of it. There are many small Islands here, & the shore being bold shows little strand at low water. Both sides of the River are bounded with very high Mountains. The ruined Chapel of — *[sic]*[157](javascript:footNote('E780002-001/note157.html')) is very near the River about 2 Miles west from Kenmare town.


Much cotton is spun here & some wove — the towels at the Inn were a very thick Muslin made here. But the principal business is carried on by Geo*[rge]* Peat *[sic]*, a Quaker from Ballynakill[158](javascript:footNote('E780002-001/note158.html')) who has invented a machine by which {Ms 4030 page 42} he reduces into cotton tow vast quantities of bad or notty cotton yarn, & then cards & spins it over again. This rubbage is bought at 8d *[? per pound]*. The working stands him in about *[?1/2 d]* & the spinning 1/2 d per pound and is then worth 18d *[?per pound]*[159](javascript:footNote('E780002-001/note159.html')).


As we rode we saw on the South Coast about 6 miles from Kenmare Clonee *[Cloonee]* lake, a little Killarney, being adorned
with arbutus & other trees & full of Islands. Mr Stewart says Valentia is a fine fertile hilly Isle, but without Rock or Mountain. Much flax is cultivated & linnen made there.


We returned & dined at the Barrack at 1/2 past 5. Afterwards Mr Caldwell & Mr Walsh went & lay at Mr Stewart's.


There is a patent for markets here but none held as yet. The town belongs to Lord Lansdown, who does not sufficiently encourage it, by what I hear.


{Ms 4030 page 43}August 29 To Bantry.
  

Breakfasted by invitation at Mr Stewart's where we had the best bread I ever saw. A Miss Irwin was there, from Donegal, niece to Dr Irwin of Clones. At 12 we set out by the short road to Bantry, Mr Stewart assuring me that John Kenny[160](javascript:footNote('E780002-001/note160.html')) travelled it lately with his wife in a Cabriole. Others told us it was not very bad, but the 



---

p.212




generality declared it impassable & warned us not to engage in it — that is, in one half mile called the Priest's leap, on the top of the Mountain which separates Kerry from Cork — the rest being good road.[161](javascript:footNote('E780002-001/note161.html'))


We adventured. Near Neddeen passed the Church on R*[ight?]* of road surrounded by Elm trees.[162](javascript:footNote('E780002-001/note162.html')) The old site[163](javascript:footNote('E780002-001/note163.html')) is on the opposite side of the River. Here is a fine Vale with rich Orchards & some Seats — two of *[them]* Mr Orpin's *[?&]* many *[? stone houses etc.]*. A mile from the town we quit it *[the vale]* & turning Southward crossed a bridge & entered the College Estate[164](javascript:footNote('E780002-001/note164.html')) which extends over a great tract of Country here. There are some considerable woods on it well preserved, because they give their tenants {Ms 4030 page 44} a third part Interest in them — & indeed these tenants seem to plant a good deal besides, & have snug habitations. All the under tenants seem well housed also. But the College cut their Woods too often — every 14 years, I hear.


About a mile farther *[we]* turned off the road on a boggy hill on the right, one or two hundred yards, to see a remarkable Rock that lies on the Surface, about 7 Yards cube, all limestone, whereas this South side of Kenmare is all brown stone without exception & every stone on the North of it Limestone. Upon this Rock grow plants of various kind — Arbutus, Quicken, Holly, Hawthorn, Ivy. What is still more remarkable is that exactly opposite to this rock on the North side of the River there is brown rock.[165](javascript:footNote('E780002-001/note165.html'))


Here Mr Stewart who had accompanied us so far took leave & we proceeded by a very good road thro very rough Mountains. At a place called Gheragh Diveen we turned round {Ms 4030 page 45} a most extraordinary ledge of brown stone ending in a fine rounded slope 



---

p.213




of immense size,[166](javascript:footNote('E780002-001/note166.html')) just near which is a decent Cabbin, some plantations & an improving farm of Robert Downey's.[167](javascript:footNote('E780002-001/note167.html')) A little farther on these lands we turned off to the right to examine a great Cataract which we saw from the road.[168](javascript:footNote('E780002-001/note168.html')) The River Shehan *[Sheen]* falls about 30 feet over very fine black rocks. There are only symptoms of wood about it but if it were let to grow up the scene, closed as it is by huge Mountains, would be truly magnificent. This river forms the bounds between the College & the Marquis of Lansdowne's estates. Just beyond this place the road is quite cut across by torrents to a great depth, yet our carriages had passed the holes (for I rode this morning). The road continued good & the country as savage as possible {Ms 4030 page 46}. On our right at some distance we saw a high waterfall (of the same river I believe)[169](javascript:footNote('E780002-001/note169.html')) which William & James stopped to sketch. Then passing between 2 high ledges of perpendicular rock for a good way we began to ascend towards the Priest's leap.[170](javascript:footNote('E780002-001/note170.html'))

A young man who had accompanied us on horseback for some miles left us here & promised to send us men immediately to help the Chaise over the bad stages. But he disappointed us and when we got to the Priest's leap we were astonished to see how far the Chaise had been carried by the assistance of the 3 Servants only — for this Leap is the most crooked, narrow, intricate, irregular path between & over vast crags of rocks on the top of a high Mount broken into hollows — to go a yard of which the Carriage was to 



---

p.214




be held up by strength, or lifted over obstructions. No man in his senses would ride it — few horses could carry a rider safe over. Yet our {Ms 4030 page 47} excellent Charioteer had, with incredible labour, got nearly half way when he was stopped by impediments which seemed insurmountable. I begged he would desist till we could send him help & for that purpose Mr Caldwell & Mr Walsh rode on. William & I stuck to the Carriage. A small rivulet[171](javascript:footNote('E780002-001/note171.html')) here divides the counties, & forms a horrible bad steep.


It now began to rain very hard. William & I went on to look for Shelter which we found under a rock just where the road begins again. Having got there over such difficult rocky ways I was unwilling to turn back, so we proceeded on foot along a new made road, with some very bad sloughs, winding along the side of a high wild Mountain — a pernicious height above an ill cultivated narrow valley on the Right.[172](javascript:footNote('E780002-001/note172.html')) In about two miles walking, sometimes in the clouds & almost in darkness, {Ms 4030 page 48} we overtook our gentlemen, who had stopped to call up men & then proceeded all together to a cabbin about a Mile farther, where we obtained with some fear & caution of the poor inhabitants, some Brandy, very necessary for persons wet & worn. It was now near 6, so the horsemen went on to Bantry, & William remained with me to wait the event of our chaise & pay the labourers of whom we sent 3 or 4 more from hence. None of the Inhabitants could speak English, but one little girl of 10 years, but they were very civil, gave me milk, potatoes & one egg. They had butter, but neither salt nor bread.


At half past 7 the Chaises & men arrived quite safe, but very tired. We refreshed them with Brandy & potatoes & milk, & then set forward for Bantry — 5 Miles we were told of excellent road {Ms 4030 page 49} but 1/2 a Mile off we came to a rapid River, the Comhola, where we crossed a deep & dangerous ford, nearly in the dark. We got safe *[across]* but the Cabriole had nearly suffered, for the horse being restif fell & the servants (James & Mr Caldwell's man) were obliged to light in the middle of the river.


About nine we reached Bantry, the night growing very bright with Northern lights. Mr Young's[173](javascript:footNote('E780002-001/note173.html')) Inn is an old fabrick, not over good or comfortable, but we were glad to find ourselves there by a good turf fire.














