

#Pococke's Tour in Ireland in 1752


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Pococke's Tour in Ireland in 1752
=================================


Author: Richard Pococke
-----------------------


### File Description

George T. StokesElectronic edition compiled and proof corrections by Beatrix Färber 

Funded by The HEA via PRTLI 4 2. Second draft, revised and corrected.Extent of text: 
75050 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E750002-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript Source**2. Dublin, Trinity College Library, MS 887. According to Macalister (see below) this is not the autograph: 'it seems to be a transcript made by some scribe, neat-fingered but not over-intelligent, as is indicated by his writing *Dunfany* for the familiar name *Dunsany* (misreading the long s) a few lines before the passage which specially interests us. This, as well as the overwhelming probability that the bishop is writing entirely from memory, must be borne in mind characterising the description, which is not a little puzzling.'
**Writings by Richard Pococke**2. Richard Pococke, A Description of the East and of some other Countries, Vol. I, Observations on Egypt (London 1743).
3. Richard Pococke, A Description of the East and of some other Countries, Vol. II.1 Observations on Palaestina or the Holy Land, Syria, Mesopotamia, Cyprus and Candia; Vol. II. 2: Observations on the islands of the Archipelago, Asia Minor, Thrace, Greece, and some other parts of Europe (London 1745).
4. Richard Pococke, "An Account of the Giants Causeway in Ireland, in a Letter to the President from the Rev. Richard Pococke, LL. D. Archdeacon of Dublin, and F. R. S.", Royal Society, Philosophical Transactions, vol. 45 (January 1748).
5. Daniel William Kemp (ed.), Richard Pococke, Tours in Scotland, 1747, 1750, 1760 (Edinburgh, Publications of the Scottish History Society 1, 1887; reprinted Maryland 2003).
6. James Joel Cartwright (ed.), The travels through England of Dr. Richard Pococke, successively Bishop of Meath and of Ossory during 1750, 1751, and later years (London: Camden Society 1888).
7. John McVeigh [=McVeagh] (ed.), Richard Pococke's Irish tours (Dublin 1995). [Edition of all his tours in Ireland, including the previously unedited one through Connaught and Munster 1749].
8. J. C. Hodgson (ed.), 'Northern Journeys of Bishop Richard Pococke', in: North Country Diaries (Second Series), Surtees Society 124 199–252 (Durham, London and Ediburgh 1914).
9. Richard Pococke, An Account of some Antiquities found in Ireland, communicated by the Right Reverend Richard Pococke, late Lord Bishop of Meath, Archaeologia 2 (1773) 32–41.
10. Lilian Dickens and Mary Stanton (eds.), An Eighteenth Century Correspondence (London 1910) [Pococke's correspondence with Sanderson Miller].
11. G. T. Stokes' edition of *Richard Pococke's Tour in Ireland* is available in PDF format at www.archive.org (with illustrations not reproduced in this edition).
**Other descriptions of Ireland;,and books mentioned by Stokes**2. Sir William Brereton, 'Carrickfergus visited in 1635'; edited by E. Hawkins. Carrickfergus & District Historical Journal, 4 (1988–89) 11–16. [Available on CELT.]
3. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of 'Les voyages et observations du sieur de la Boullaye Le Gouz (. . .)' Paris 1653.] [Available on CELT.]
4. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
5. Thomas Dinely, Observations on a Tour through the Kingdom of Ireland in 1681 (Dublin 1858, reprinted in Kilkenny Archaeological Society's Journal, Second Series, 4 (1856–57) 143–46, 170–88; 5 (1858–59) 22–32, 55–56; 7 (1862–63) 38–52, 103–109, 320–38; 8 (1864–66) 40–48, 268–90; 425–46; 9 (1867) 73–91, 176–204).
6. Samuel Molyneux, 'Journey to Connaught, April 1709', ed. Aquilla Smith, The Miscellany of the Irish Archaeological Society (Dublin 1846), 161–178. [Available on CELT.]
7. William Petty, A geographical description of the kingdom of Ireland, newly corrected & improv'd by actual observations. Containing one general map of the whole kingdom with 4 provincial and 32 county maps, (. . .) The whole being laid down from the best maps vizt. Sr. Wm. Petty's, Mr. Pratt's, &c. with a description of each county collected from the best accounts extant (London 1728).
8. Charles Smith (formerly attributed to Walter Harris), The antient and present state of the county of Down. Containing a chorographical description, with the natural and civil history of the same. (. . .) (Dublin 1744).
9. Charles Smith, The antient and present state of the county and city of Waterford (Dublin 1746. Reprinted Cork 1969.)
10. [William Rufus Chetwood and Philip Luckombe], A tour through Ireland in several entertaining letters: wherein the present state of that kingdom is consider'd ... interspersed with observations on the manners, customs, antiquities, curiosities, and natural history of that country ... by two English gentlemen, London 1748.
11. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastiscal division thereof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same (. . .) (Dublin 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the MSS. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork 1893–1894).
12. John Lodge, The Peerage of Ireland, 4 volumes (London 1754).
13. Charles Smith, The ancient and present state of the county of Kerry (Dublin 1756).
14. Thomas Wright, Louthiana: or, an introduction to the antiquities of Ireland: In upwards of ninety views and plans: representing, with proper explanations, the principal ruins, curiosities, and antient dwellings, in the county of Louth. Divided into three books. Taken upon the spot by Thomas Wright (. . .) Engraved by Paul Foudrinier (London 1758).
15. James Kelly (ed), The letters of Lord Chief Baron Edward Willes to the earl of Warwick, 1757–62: an account of Ireland in the mid-eighteenth century (Aberystwyth 1990).
16. John Mitchell, The present state of Great Britain and North America, with regard to agriculture, population, trade, and manufactures, impartially considered (. . .) (London: printed for T. Becket and P.A. De Hondt, 1767).
17. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1773; 1774).
18. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
19. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available on CELT.]
20. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin, printed by George Bonham, for Messrs. Whitestone, Sleater, Sheppard, Williams, Burnet, Wilson Jenkin, Wogan, Vallance, White, Beatty, Byrn, and Burton, 1780; repr. London [etc.] 1887. [Available on CELT.]
21. William Hamilton, Letters concerning the northern coast of the county of Antrim, containing observations on the antiquities, manners, and customs of that country (. . .) illustrated by an accurate map of the County of Antrim, and views of the most interesting objects on the coast (Dublin 1786; various reprints 1790, 1822).
22. George Taylor and Andrew Skinner, Maps of the roads of Ireland surveyed (London 1777; 2nd edition with one extra plate 1782).
23. Charles Vallancey, Collectanea de rebus Hibernicis. (. . .) Published from the MSS, vol ii, Antiquities of Irishtown and Kilkenny (Dublin 1786).
24. George Holmes, Sketches of some of the southern counties of Ireland, collected during a tour in the autumn of 1797 in a series of letters (London 1797). New edition, introduced by Hugh Weir (Whitegate: Ballinakella Press, 1987).
25. Johann Friedrich Hering's description of Connacht, in: Select Documents XLI: Johann Friedrich Hering's description of Connacht, 1806–7, Irish Historical Studies 25/99 (May 1987) 311–321: 315–321. [Available on CELT.]
26. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
27. Richard Cumberland, Memoirs of Richard Cumberland, written by himself. Containing an account of his life and writings, interspersed with anecdotes and characters of several of the most distinguished persons of his time, with whom he has had intercourse and connexion. Two volumes (London 1807).
28. Anne Plumptre, Narrative of a residence in Ireland during the Summer of 1814, and that of 1815 (London 1817). [Available on CELT.]
29. John Christian Curwen, Observations on the state of Ireland, principally directed to its agriculture and rural population; in a series of letters, written on a tour through that country. Printed for Baldwin, Cradock, and Joy. 2 vols. (London 1818).
30. James Hardiman, The history of the town and county of the town of Galway (Dublin 1820). Available online at: http://www.askaboutireland.ie/reading-room/
31. George Newenham Wright, A Guide to the county of Wicklow (London 1822).
32. James Norris Brewer, The Beauties of Ireland (London 1825–26).
33. Caesar Otway, Sketches in Ireland: descriptive of interesting, and hitherto unnoticed districts, in the north and south (Dublin 1827).
34. Patrick Knight, Erris in the Irish highlands and the Atlantic railway (Dublin and London 1836).
35. Caesar Otway, Sketches in Ireland: descriptive of interesting portions of the counties of Donegal, Cork, and Kerry (Dublin 1839).
36. Caesar Otway, A Tour in Connaught (Dublin 1839).
37. Caesar Otway, Sketches in Erris and Tyrawly (Dublin and London 1845).
38. William Reeves, Ecclesiastical Antiquities of Down, Connor, and Dromore, consisting of a taxation of those dioceses, (. . .) (Dublin 1847).
39. Rev. James Graves and J. G. Prim, The History, architecture and antiquities of the cathedral church of St. Canice, Kilkenny (Dublin 1857).
40. Sir Bernard Burke, Vicissitudes of Families: and other essays (London 1860).
41. Mary Delany, The autobiography and correspondence of Mary Granville, Mrs. Delany: with interesting reminiscences of King George the Third and Queen Charlotte (London: Series 1 in 3 volumes, 1861; Series 2 in 3 volumes, 1862).
42. Sir Bernard Burke, A genealogical History of the dormant, abeyant, forfeited and extinct peerages of the British empire. (New ed. London 1866).
43. Sir William Wilde, Lough Corrib, its Shores and Islands (Dublin 1867).
44. George T. Stokes, Ireland and the Celtic Church (Dublin 1886).
45. George T. Stokes, Ireland and the Anglo-Norman Church. A History of Ireland and Irish Christianity from the Anglo-Norman Conquest to the Dawn of the Reformation (London 1889).
46. George Benn, A History of the town of Belfast from the earliest times to the close of the eighteenth century, 2 vols. (London 1877).
47. Reverend Mervyn Archdall, Monasticum Hibernicum; or an History of the Abbies, Priories, and other Religious Houses in Ireland, 2 volumes (London 1786).
**Further reading**2. John Nichols, Literary anecdotes of the eighteenth century: comprizing biographical memoirs of William Bowyer, Printer, F. S. A. and many of his learned friends (. . .), 9 volumes (London 1812–1816).
3. John Nichols, Illustrations of the literary history of the eighteenth century: consisting of authentic memoirs and original letters of eminent persons; and intended as a sequel to the Literary anecdotes, 8 volumes (London 1817–1858).
4. R.A.S. Macalister, Temair Beg: a study of the remains and traditions of Tara. Transactions of the Royal Irish Academy (Dublin 1919) especially note p. 398–99.
5. Michael Quane, 'Pococke School, Kilkenny', The Journal of the Royal Society of Antiquaries of Ireland 80, no. 1 (January 1950) 36–72.
6. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
7. Pádraig Ó Maidín, Pococke's tour of south and south-west Ireland in 1758, Journal of the Cork Historical & Archaeological Society, 2nd ser., 63 (1958) 73–94; 64 (1959) 35–56; 109-130; 65 (1960) 130–141.
8. C. J. Woods, Pococke's journey through County Down in 1760, Ulster Journal od Archaeology, 3rd series 48 (1985), 113–115.
9. Maureen Hegarty, Dr Richard Pococke's travels in Ireland, England and Wales. Old Kilkenny Review: Journal of the Kilkenny Archaeological Society 3 (1987) 388–398.
10. John McVeagh, "Romantick" Ireland: Pococke's tour of Cork and Kerry, 1758. Éire-Ireland, 25:2 (1990) 69–95.
11. James Kelly (ed), The letters of Lord Chief Baron Edward Willes to the earl of Warwick, 1757-62: an account of Ireland in the mid-eighteenth century (Aberystwth 1990).
12. Andrew Hadfield; John McVeagh (eds.), Strangers to that land: British perceptions of Ireland from the Reformation to the famine (Gerards Cross 1994).
13. John McVeagh (ed.), Irish Travel Writing. A Bibliography (Dublin 1996).
14. Celestine Rafferty (ed), Richard Pococke's tour through County Wexford, 1752, Journal of the Wexford Historical Society 21 (2006) 57–69.
15. Aideen Ireland, 'Richard Pococke (1704–65), antiquarian', Peritia 20 (2008) 353–378.
16. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. Pococke's Tour in Ireland in 1752. Richard PocockeGeorge T. Stokes (ed), First edition [187 pages] Hodges, Figgis, and Co.; Simpkin, Marshall, Hamilton, Kent, and Co. Dublin and London (1891)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the editor's introduction and pages 3–186.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The editor left Pococke's spelling uncorrected. In the electronic edition, for obsolete or inaccurate spellings a standardised form is given in the XML encoding, using reg orig="". Due to Pococke's often idiosyncratic spelling, and his frequent recording of small and remote places, not all place-names have been regularised. Likewise, the following changes were made to Pococke's capitalisation: all elements of an encoded place-name were capitalised when in lowercase in the text; a capital letter in a word (other a than noun) after a semicolon was changed to lowercase.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the travel journal; div1=the dated entry. The last pages of Pococke's description are in the form of letters covering various dated entries. For this section the segmentation into dated entries is overridden by the letter containing them; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal names, titles (of books etc) and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the entry. ### Profile Description


Created: By Richard Pococke 
 (1752) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin, and terms in Neolatin.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [FR] Some words and phrases are in French.


##### Language: [IT] Some terms are in Italian.


### Revision History


* (2015-11-24) Beatrix Färber (ed.)

* Additions to bibliography made.
* (2014-03-04) Beatrix Färber (ed.)

* Additions to bibliography made.
* (2014-05-17) Beatrix Färber (ed.)

* Additions to bibliography and new wordcount made.
* (2013-09-06) Beatrix Färber (ed.)

* Additions to bibliography made.
* (2012-11-13) Beatrix Färber (ed.)

* Minor additions to personal names encoding made.
* (2010-07-15) Beatrix Färber (ed.)

* Conversion script run, header updated; addition to bibliographic details made; more content encoding added; new wordcount made; file parsed; new SGML and HTML versions created.
* (2010-04-20) Beatrix Färber (ed.)

* File proofed (2) up to end; more content markup applied; bibliography finished; SGML and HTML files created.
* (2010-03-11) Beatrix Färber (ed.)

* Proofing (1) finished; file parsed.
* (2010-02-05) Beatrix Färber (ed.)

* Header created.
* (2010-01-29) Beatrix Färber (ed.)

* Proofing (1) and application of structural markup started.
* (2010-01-22) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E750002-001


### Pococke's Tour in Ireland in 1752: Author: Richard Pococke




---

p.3


### Introduction


The reader will find in this volume an exact transcript of **Dr. Pococke**'s Tour through **Ireland** in the year 1752, as it is contained in the original manuscript now deposited in the Manuscript Room of **Trinity College**, **Dublin**. That document was often asked for, but was always reported as lost till a few years ago, when the Assistant Librarian, the late **Mr. French**, discovered it lying concealed among the treasures of that great collection.[1](javascript:footNote('E750002-001/note001.html')) The occasion of the present publication was as follows. In December last I contributed an article to the Christmas supplement of the Daily Express, describing some tours through **Ireland**, taken and recorded in the earlier part of the eighteenth century. Among others described by me was **Pococke**'s Tour, into which I had dipped from time to time. That article attracted the notice of a well-known and respected citizen of **Dublin**, who recognised the value of the long-lost document, and generously offered to bear the expense of its publication. It is much to be hoped that his example may stir up others to publish the numerous and valuable Irish records which are at present lying hidden and useless in 



---

p.4



our manuscript collections, such as the Liber Niger Alani, the Crede Mihi, and the great Registers of Christ Church Cathedral, which would throw more light upon the history of mediaeval and feudal **Ireland** than any other documents with which I am acquainted.


The Tour here printed is, as I have said, an exact transcript of the original. I have printed all the mistakes in grammar, in geography, in the spelling of names, whether of towns or persons, making no attempt to correct them. This narrative illustrates one point most clearly. **Pococke** was a learned man, an F.E.S., and a Church dignitary; but spelling was not a fixed quantity in his mind. His spelling of the same name often varies three or four times on the one page. It has more interest, however, than a merely orthographical one. This Tour is a most interesting contribution to Irish social history during a period which is remarkably dark, and deals with a district of country—the sea-coast line all round **Ireland**—of which very little is known at that precise period. **Pococke** started from **Dublin**, went north to the **Giant's Causeway**, penetrated the extremest wilds of **Donegal**, entered the farthest recesses of **Erris**, **Achill**, and **Belmullet**, at a time when **Belmullet** was two days' journey west of **Westport**, and when no wheeled vehicle had ever entered that district, or was to enter it till seventy years later. That circumstance did not trouble **Pococke**, for he always travelled on horseback, with outriders, as **Richard Cumberland**, in his chatty Memoirs, tells us he met him in **Wales**. **Pococke**'s observations and notices about this part of **Connaught** are specially important, because he came just half-way between **Cromwell**'s period and our own. His notices illustrate the effect of the legislation of **Cromwell**. The Roman Catholics of **Ireland** had been, as all know,



---

p.5



transported into **Connaught**; but it is not as well known that while **Cromwell** wished to cut them off from the rest of **Ireland** by the **Shannon**, he also tried to cut them off from the sea, by forbidding any Roman Catholic to settle within a certain distance of the coast—I forget the exact distance—and then settling Protestant colonists all along the coast-line. **Cromwell** tried, in fact, to place the Roman Catholics within a ring-fence. The result is that even to the present day the sea-board parishes contain a more numerous Protestant population than those more inland. It will be easily seen by anyone acquainted with the west, that **Pococke** followed the coast-line very exactly, and seems to have found good congregations all along the coasts of **Sligo**, **Mayo**, and **Galway**.


This Tour, again, illustrates the social state of **Ireland** in another aspect. It shows the stable, fixed character of its population belonging to the upper ranks, notwithstanding all the changes we have experienced. **Pococke**'s position gave him access to the higher ranks of the gentry and I would venture to say, that representatives of much more than one-half of the families mentioned by the Archdeacon would be now found occupying much the same position as then. **Peppers**, **Hamiltons**, **Stewarts**, **Wynnes**, **Shaw Taylors**, **Browns**, **Boyds**, **O'Donnels**, **Burys**, **Pallisers**, **Nunns**—to take but a few specimens—these are all mentioned by **Pococke**, and are still all well-known family names in various parts of **Ireland**. Manners and customs—the state of civilisation—the operation of the penal laws and of the Charter School system—the names and emoluments of the clergy—the condition of trade, commerce, and manufactures—the rent of lands and houses—the state of architecture in country parts—all these points and many others find illustration in the pages of this Tour. The



---

p.6



theological position and ritual of the Irish Church and its dignified clergy in **Queen Anne**'s time are, for instance, illustrated by a passing notice on p. 132. Bishop Milles was a learned churchman of the Laudian and Caroline school. He came from **Oxford** to **Waterford**, introducing altar-pieces, separation of the sexes in church, and other customs of this kind, now regarded as modern ritualistic innovations.[2](javascript:footNote('E750002-001/note002.html')) **Pococke** seems to have made a point of observing the natural history, the botany, zoology, and geology of every part of **Ireland**. This fact renders the Tour of interest to the student of natural science; while the careful notices and descriptions which he bestows upon our ancient buildings, ecclesiastical or secular, deserve the thanks of every antiquarian student, as more than a hundred years ago they engaged the careful attention of that celebrated Irish antiquary, the **Rev. Mervyn Archdall**, who made a copious use of the manuscript which we here print, in the notes to his Monasticon Hibernicum. I have already said that the manuscript of this Tour was long regarded as lost, and only came to light by chance. This tour of 1752 was not the only tour through the West and South made by **Pococke**. Travelling was for him the great end of life; and he seems to have made a tour through **Connaught**, **Clare**, **Kerry**, and **Cork** in 1749, the manuscript of which is now unknown. He several times refers in the text of the present Tour to the observations he made on that occasion; and from a notice in a note in the **Kilkenny Archaeological Society**'s Journal for 1852, I conclude that fifty years ago some persons knew of the existence 



---

p.7



of the manuscript of the earlier tour, and had used it. It is possible, indeed, that the document in question may be in **Oxford**. **Pococke** by his will left all his manuscripts not expressly disposed of to the ‘Ratcliffe Liberary,’[3](javascript:footNote('E750002-001/note003.html')) including the original Minute Book of the Proceedings between 1683–89 of the celebrated **Dublin Philosophical Society**, established by **Sir William Petty**, **Dr. Molyneux**, and **Archbishop Marsh**, which used to meet in **Trinity College**. The value of these tours is very great from an historical point of view. They preceded **Arthur Young**'s tour[4](javascript:footNote('E750002-001/note004.html')) by a quarter of a century, they penetrated a part of **Ireland** he never visited, and they leave us a truthful record of what **Ireland** was then like. How hard, for instance, it is for a modern Irishman to realize the state of this country when **Pococke** saw, as he mentions in his **Donegal** tour, a priest celebrating Mass in the open air, upon a large rock on a lofty mountain's side.


I shall conclude this brief introductory notice with a sketch of **Pococke**'s life. **Richard Pococke, D.D., LL.D.**, was the son of the **Rev. E. Pococke**, of **Southampton**, where he was born in 1704; his eldest sister, Dorothy, having been married just two years earlier—that is, in 1702—to the celebrated **Rev. Joseph Bingham**,[5](javascript:footNote('E750002-001/note005.html')) the 



---

p.8



author of the Antiquities of the Christian Church. **Pococke** was educated at Corp. Christ. Coll., Oxon., where his uncle, **Thomas Milles, was Regius Professor of Greek**. **Milles** was a learned man, the author of a well-known edition of the works of St. Cyril of Jerusalem, and a politician very acceptable to the Government of **Queen Anne**'s time. He was accordingly made Bishop of **Waterford** and **Lismore**—a post which he held for more than thirty years. He was probably the most learned Bishop of **Waterford** that ever ruled that See. By this means young **Pococke** got his foot on the first rung of the ladder of ecclesiastical promotion. As soon as he took Holy Orders, **Bishop Milles** appointed **Pococke** Precentor of **Lismore**— a post the duties of which were so light that he had ample time to indulge his wandering propensities. He began his travels in the east in 1737, where he spent five years. He returned in 1742. In 1743 he published the first volume of his travels, in a splendid folio shape, embellished with numerous plans and engravings, which was followed two years later by two other volumes[6](javascript:footNote('E750002-001/note006.html'))—one continuing the narrative of his travels, and the other giving an account of the Greek inscriptions he had discovered. These volumes are of importance even to the present day, as **Pococke** penetrated into a part of **Syria** which was never again visited till our own time, when **Count De Voguë** explored it, and published a work, beautifully illustrated, telling of its marvellous ruins, under the title of The Architecture of Central Syria. In that work, which I have described at some length in Ireland and the Celtic Church, pp. 289–242, **De Voguë** tells 



---

p.9



us a great deal about Simeon Stylites and his pillar, helping to make that strange character a living personage for us moderns. **De Voguë** gets the credit of this, but **Pococke** preceded him in the work by more than one hundred years, and in his neglected folios gives us splendid plates of Simeon's church and pillar, and other ruins of that district, which **De Voguë** reproduced some twenty years ago. In the enthusiasm for eastern travel and research which now exists it would be well to keep an eye on **Pococke**'s volumes. **Professor Ramsay** has lately published an Historical Geography of Asia Minor. It is well worth while to compare the Bishop's account of **Ancyra**, **Galatia**, and the River **Halys**, with the investigations of the modern scholar and traveller. He also published several papers in the Philosophical Transactions for 1748 and 1753, dealing with the **Giant's Causeway**, which gave rise to considerable scientific discussions, which will be found duly set forth in **Hamilton**'s Letters concerning Coast of Antrim, where a different view is taken. He took a great interest also in Irish antiquities, and in the second volume of Archaeologia, gave an account of some ancient graves and ornaments found at **Carn**, seven miles west of **Mullingar**, on the estate of **Keedah Geoghegan**, Esq. He was appointed Archdeacon of **Dublin** by the Crown in 1745, on the promotion of **Dr. Synge** to the See of **Killaloe**. During his occupation of that office, he held in St. Patrick's the last Archidiaconal Visitation of the clergy which the Irish Church ever saw, though the practice still continues as vigorous as ever in **England**. He was made Bishop of **Ossory** in 1756, where he carried out considerable restorations and repairs in the cathedral and palace at his own costs. He was translated to **Meath** in 1765, where he died suddenly when



---

p.10



engaged in the duties of a Visitation, after a three months' tenure of the See. He found time, however, to leave a mark of his oriental travels in the demesne at **Ardbraccan**, planting the seeds whence sprang the splendid cedars of **Lebanon**, which still stand on the southern side of the pleasure-grounds behind the palace. **Bishop Pococke** deserves to be remembered by the public at large for one reason. He was the first who discovered **Chamonix**, and revealed its beauties to the travelling public; and to this day, as his successor, the Right Rev. W. P. Walsh, D.D., told in a letter to the Kilkenny Moderator of Nov. 20, 1886, his name is graven in large letters on an immense boulder near the **Mer de Glace**, with the date, 1741, in commemoration of the fact that **Pococke** was the **Christopher Columbus** who in that year found out **Chamonix**. **Pococke** was a perpetual traveller. He made extensive tours throughout **England** and **Scotland**. These have been already published: the English tour by the **Camden Society**, and the Scotch by the **Scottish History Society**. The present publication proves that he was not neglectful of the country where he lived, and where his memory is still perpetuated in the useful **Pococke Institution** which he founded in the city of **Kilkenny**. Many other details concerning him, his appearance, mode of life, travels, hospitality, and learning will be found in **Vallancey**'s Collectanea, vol. ii., Antiquities of Irishtown and Kilkenny; in **Mrs. Delany**'s Autobiography; **R. Cumberland**'s Memoirs; and in **Prim**'s History of St. Canice's. **Pococke** when Archdeacon of **Dublin** entertained **Mrs. Delany** and a large company at an afternoon party at his residence. That lively lady did not, however, at all appreciate the learned traveller, but confesses on more than one occasion that she found him and his entertainments extremely dull.




---

p.11


I have tried to find out where **Pococke** lived when Archdeacon of **Dublin** and Rector of St. Peter's, but have failed. Perhaps some reader may be able to throw light on this local problem. About two years ago, the remains of an Egyptian mummy were found in Marsh's Library. It is possible that it may have been deposited there by **Pococke** upon his return from **Egypt**. The priced auction catalogue of his coins and medals, dated 1766, is in **Trinity College** Library. There were several portraits taken of **Bishop Pococke**. One hangs at present in the Board Boom of the **Incorporated Society** in Harcourt Street; while again, **Nichols**, in his Literary Anecdotes, l.c., tells us that there was a full-length portrait of him, in full Turkish dress, possessed by **Pococke**'s first cousin, **Dr. Milles, Dean of **Exeter****.[7](javascript:footNote('E750002-001/note007.html'))


George T. Stokes.
  
All Saints' Vicarage, Blackrock,


2nd April, 1891.


---

p.1


Monday, June 22nd, 1752, I went to **Swords**, dined there with the Chapter of Christ Church. Set out at five northwards, found the country extremely plesant. **Gormanstown**, I crossed a rivulet from the County of **Dublin** into the County of **Meath**, near this is **Lord Gormanstown**'s seat, a Roman Catholick married to **Lord Tremlestown**'s sister. I went on and came to a fine deep rivulet, called the **Nany water**, which passes by **Duleck**, on the south side of an eminence towards the sea is the seat of **Mr. Pepper**; a charming situation with the fields well laid out round about it, and on each side of the river are beautiful meadows on the rising ground, as well as in the narrow vale; we cross'd this water at Da (? Lay) town and came to **Drogheda** which is finely situated on two eminences on each side of the river **Boyne**, and about three miles from the mouth of it. A mile below it is **Beaulieu**, a place much noted for its beautiful situation, and was the country seat of General Bowles.


There are many ruined Churches and Abbies at **Drogheda**, and they have lately built a beautiful Church with Gothick windows in the body of it, and a *handsome* Palladian front of **Ardbraccan** stone.


Tuesday, 23rd.— I set out northward: when I crossed the **Boyne** to **Drogheda** I came into the County of **Louth**, 



---

p.2



which is a good country of arable and pasture, but does not abound in trees. **Drogheda** is near twenty-three miles from **Dublin**. A *little* beyond the 24th stone I came to a stream at a place called **Kaneagh** in **Sr. Wm. Petty**'s map **Killineer** and soon came up to a small hill called **Cullestan**, and a *little* beyond the 24" stone passed the road which leads to **Aherdee**; on the top of the hill to the left, I saw a Church called **Bemister Boyn** (? **Monasterboice**) with a round tower near it,[8](javascript:footNote('E750002-001/note008.html')) and I observed on the sea about 3 miles to the north of the ***Boyne***, **Tutochen** and the high mountains of **Slewgullon** towards **Newry**: on the other side of the hill we came to a stream at **Cloghvaddagh** or Long-stones, to the right of which is the Church of **Mullarah**; at the 28th stone we passed by the Castle of A—lair, and a little further by a river of the same name and soon arrived at **Dunleer** situated on a rivlet which according to **Sr. William Petty** falls into the river that rises out of **Atherdee** bog; going on we saw **Drumcorlagh** on the river to the right, beyond it **Dillings Town** **Lord Antrim**'s a fine situation which came to the family of his wife a Pluckenet (? Plunket).[9](javascript:footNote('E750002-001/note009.html')) We went half a mile to **Cappogh bridge** over the river which runs by **Atherdee**, 



---

p.3



and half a mile further to **Greenmount** a small village at the foot of a mount on the brow of a rising ground fortified with a fossee, and there is a *height* in it at the north west corner, the whole of irregular figure is about 50 paces each way.[10](javascript:footNote('E750002-001/note010.html')) We came in a mile to **Castle Bellingham**, formerly called **Grenan's town** or **Garland's town**, where **Mr. Bellingham** has a very good house which he does not inhabit.[11](javascript:footNote('E750002-001/note011.html')) The river hanging ground and wood between it and the sea is very fine: before I came to this place I saw a ruined Church to the west where I observed a monument to the honour of **John Stanley** of the holy **Order of St. Dominick**, erected by John Stanley Apothecary in **Drogheda** to the memory of this person and some other relations. From **Castle Bellingham** we soon came to the Strand, over which when the *tide* is out they ride to **Dundalk**, we cross'd **Dunnigan river** and soon came to **Lurgan Green** well inhabited for a mile by weavers and labourers, who live very much on the cockles, which they get out of the Strand. Three miles further we came to **Dundalk**, situated towards the mouth of a river on **Dundalk** bay. This is a town chiefly consisting of one Street about half a mile long, it was in the time of **Edward 2d** a royality and the last where a monarch of all **Ireland** was crowned and resided, and did chiefly consist of Castles, some traces of which they say are still to be seen.[12](javascript:footNote('E750002-001/note012.html')) **Lord 



---

p.4



Limerick** lives here, and has made some fine plantations and walks behind a very bad house which is in the street of the town: as walks with Elm hedges on each side, an artificial serpentine river, a Chinese bridge, a thatch'd open house supported by the bodies of firtrees, &c.: and a fine kitchen garden with closets for fruit.[13](javascript:footNote('E750002-001/note013.html'))


At the entrance of the town from the South is a Charter School of 30 girls, founded at first as a Charity School for twenty boys and twenty girls by **Mrs. Ann Hamilton** and erected into a Charter School in 1738 by her son the *present* **Lord Limerick**.[14](javascript:footNote('E750002-001/note014.html')) They are employed in spinning for the Cambrick manufacture here, which I went to see; this manufacture is carried on by a Company who subscribe, and is about half a mile from the town towards the Bay:[15](javascript:footNote('E750002-001/note015.html'))


---

p.5



the design of the building is to be round a Court, with a large opening at every corner to give air; two sides of it are entirely built, having ten houses on each side, a third side has only six houses built and on the fourth side is the Cashier's house with the yarn house on one side of it and the —— House on the other in which they wind off the yarn on quills for weaving; the flax is brought ready scutched and hackled from **France**, they then stove or bake it to make it come finer by brushing it which is peculiar to the Cambrick manufacture; the houses are contiguous and consist of two rooms of a floor and of three floors, one of which is underground and vaulted with good lights in front, which are kept shut, for they must work underground and shut out the fresh air in order to keep the yarn damp, otherwise they cannot weave it: the two rooms hold eight looms, these rooms the Company give rent free, one to each Master who may employ eight, either apprentices or journeymen, and the Company *pays* 'em for what they weave, according to the quantity of it, the finest is what they call 2600 that is so many quills, to each of which are two threads, so that there are in the breadth 5200 threads, and this is worth about fourteen shillings a yard. The market abroad is not high enough for the export, so that most of the consumption is at home; and tho' the Ladies say they cannot afford to wear it because it does not last so long as the French, yet the most discerning cannot distinguish the best from the French. They make 



---

p.6



fine Lawns also, and this is all bleached in yards that are near; working in this close manner is *unwholsome*, and occasions the Itch and Scurvy. They told me that they had forty of our Charter boys. I saw such of them as could be got together and gave them a small present and a word of exhortation. There is also a house for dressing flax for linnen near the town where they did also weave and it is filled with men brought from **Holland**. They are now building a sugar house near the town and they have a handsome Court-house and free School.


From **Dundalk** I went in a chaise for **Carlingford**, sending my horses round by **Newry** to meet me on the other side of the River at **Restrevor**. Being Midsummer Eve there were Bonfires all over the Country, and asking the young man who drove me, what the meaning of it was, he said in these words, It is the Eve of St. John Baptist they make a light, it is the light, He came to testify of the light: we met many going to pilgrimage to St. John's Well at **Newcastle** near **Dundalk**.


I went near two miles in the **Newry** road, and saw to the north on the hill, the old Church of ***Faughcart*** and a mount;[16](javascript:footNote('E750002-001/note016.html')) we turned out of this road to the east and in half a mile came to a rivlet at **Ballimaskanlan**, and in two and a half more to **Rockmarshal** where there is a rivlet runs by a house pleasantly situated on the side of the hill for Lodgers to drink goat's whey; for this road has all along to the north the mountains of **Carlingford**: we passed in the way to this place by **Mr. Tipping**'s Park, which commands



---

p.7



a fine view of the Bay;[17](javascript:footNote('E750002-001/note017.html')) travelling two miles further we saw on the side of the hill a seat of **Mr. Fortescue**'s, called **Piemont**[18](javascript:footNote('E750002-001/note018.html')) now inhabited by one of the **Hamiltons**, and is a very fine situation:[19](javascript:footNote('E750002-001/note019.html')) near it we crossed three mile river, on which is a small village called **Riverstown**. We turned to the north and ascended to **Carlingford**, a poor town of one long Street of cabins, at the foot of the high craggy mountains, from which several little streams descend and pass through the town; at the west end of the town is an old Castle, said to be built by K. John, and remains of several old towers to the sea, which were built to the roads, that are now destroyed and seem to have been ancient habitations.[20](javascript:footNote('E750002-001/note020.html')) This is properly the port of **Newry** from which the vessels go up four miles higher to narrow walls and unload into Gabbots, they say 400 vessels commonly come into this harbor every year: this and the oyster fishery for **Dublin** is the chief support of the Town; and a great number of boats are constantly carrying lime stone from the quarries on each side of the mouth of the harbour to **Newry**, to be burnt for their buildings. There was a tolerable Inn here, but the Bed chamber being 



---

p.8



within the kitchen, as soon as I rose, the pigs made my Levee.


On the 24th I crossed over to **Restrevor**, where Alderman Ross late Lord Mayor of **Dublin**[21](javascript:footNote('E750002-001/note021.html')) has a small house pleasantly situated under the hills, which are covered with wood, near an old Mansion house in which his Father liv'd: I went to pay him a visit, but being early in the morning he was not risen: I went on to the West for near two miles and then turned to the North East along the side of the hills over a rivulet, which joins another and falls in at **Newry**; before I came to eight mile bridge a fine view presented of the Country to the North of beautiful hills under corn, mostly oats in fine verdure, and on one of them saw a Mount, called the **White Mote**. Asking here about the road, if it was hilly? they told me it was; but that the hills were all level, by which I suppose they meant that they were not high. I came over the hills to **Briansford**, on the side of **Tullamore park**, which belongs to **Lord Limerick**; this park is a very fine situation, being divided into two parts by a rivlet which runs in a deep rocky bed covered with trees, and affords a most Romantic prospect, to this rivlet there is a gentle descent; on the other side the Park takes in for a mile the foot of the high mountains of **Moran** (***Mourne***) and particularly of the highest call'd **Slieve Donard** which is 1060 yards high from the surface of the sea to which it extends: the park is all fine wooden and cut into Vistas up the side of the steep hill; there is a *handsome* bridge over the rivlet, where the rocky cliffs on each side may be twenty feet deep, and so cover'd with trees that you can hardly see the water at the bottom in some places. Here just over the rivlet **Lord Limerick** has 



---

p.9



built a thatch'd open place to dine in, which is very Romantick, with a stove near to prepare the Entertainment: above on the North side of this He has begun to build a pretty lodge, two rooms of which are finished, designing to spend the Summer months here: between this park and the sea, are houses for those who come to drink Goat's Whey in May and June, when the milk on account of the flowers on which the Goats feed is in greatest perfection. I here met Lord John Murray brother and Heir apparent to the **Duke of **Athol**, a Colonel of the Highland Regiment** in this kingdom, a most accomplished fine bred Gentleman, and when I went away I found I had been as in his house, and he gave me a letter to the Commanding officer at **Carrickfergus**, hearing me say that I proposed to stay there on Sunday, that he might show me the civilities of the place.


On the 25th I went a mile to **Maghera**, after having been at **Newcastle** a mile to the South east on the sea; it is a good house lately purchased with some land by **Mr. Annesly** and I went to **Tullamore** park I have described. In **Maghera** Church yard is part of a round tower about twelve feet high, and it may be fifteen in diameter, 'tis said, the top was blown down and remained on the ground without breaking in pieces, but I could not be well informed, that it was really so;[22](javascript:footNote('E750002-001/note022.html')) here is an ancient burial place of the **Magennis**'s. I ascended two miles up to the Castle of **Dundrum**, which commands a fine view of all the country; it is of an irregular multangular form, with a fine round tower in it, which in the inside is about thirty feet in diameter; it is sd. to be built by **Sir John De Curcey** for the **Knights Templars**. From this place I



---

p.10



saw plainly the Isle of Man. As the Northern and Southern *tides* meet here, it occasions a great sea and a most extraordinary suction into the bay, which makes it extremely dangerous to come near the Coast, where there are frequent Shipwrecks. I descended a mile to **Mount Panther**, with a design to pay a visit to **Dr. Delany**, but he was not arrived; so passing under the village of **Clough** finely situated on a rising ground, and the residence of **Mr. Annesley**, third son of the famous **Francis Annesley** of the inner Temple. I came to **Mr. Bayley**'s on the bay of Dundrum, to whom I had sent that I would come and dine with him; this Gentleman is brother to **Sir Nicholas Bayley** and has a family Living of £800 a-year. Soon after I came in **Dr. Delany** sent his servant, to borrow something for that they were on the road, and being invited to dine, they soon came in, He and his Lady; and being all agreably surprised,[23](javascript:footNote('E750002-001/note023.html')) I dined, and *rode* seven miles East to ***Killough***, between the sandy banks on the sea, which sometimes move so, as not only to bury rabbit warrens, but as it is supposed whole villages, as has happened in **Cornwall**. ***Killough*** is most pleasantly situated in a small bay which is about a mile deep and not half a mile over, it consists of one Street, but is in a declining way, no soldiers being sent to the Barrack of late years; the linnen manufactory also has failed, and the boiling of rock salt from Liverpool, and the fishery likewise is very small, tho' there is a good pier built to shelter the boats from the South East wind but there is notwithstanding one of the best Inns here in



---

p.11



the whole road. Just out of the town is a Charter School founded by Judge Ward to whom the town belongs, it is for twenty boys and twenty girls, and I went to see it. Near the town is a stream running from a rock, it is the lightest water in **Ireland**; and comes out of the cliffs, which are a cement of pebbles; the rock below being of a slaty kind: at some distance beyond it there is a hole or cave, where the tide comes in, and when it retires, makes a great noise and bubbles up in a very extraordinary manner.[24](javascript:footNote('E750002-001/note024.html'))


On the 26th I went two miles north east to **Ardglass**, where when the tide is quite out, by crossing the strand, the road is about half a mile nearer, it is said, to have been the next town for trade in **Ulster** after **Carrickfergus** before the time of **Queen Elizabeth**. The customs of this place and ***Killough*** were granted by **Hen. 8th** to the **Earl of **Kildare****, who sold 'em to **K. Charles 1st**. This place seems to have been *fortified* by a long building and some towers, the former seems to have been the habitation and store houses of ten Merchant families, consisting of a ground floor and one story over it; what is remarkable from the upper rooms there is a communication something like what they call the murdering holes, but going quite down to the ground so as not to be observed from the outside, which might serve as *shores* to the upper apartments, and it may be for other purposes; a square tower *joins* to this, which is cover'd by another to the South, and there is a third to the east of that, to the north west of them there is a large tower, over the gateway of which was an inscription relating to the Lords of it, the **Kildare family**; and on the height to the west are remains of a gateway to 



---

p.12



what they call the King's Castle: This is a good harbour for small boats, and a ship may ride in 15 feet water at the west part of it, but it is a very small harbour.[25](javascript:footNote('E750002-001/note025.html')) From this place I crossed the country seven miles to ***Downpatrick***, and came to **St. Patrick's Well** under **Strud hill** *? **Struell***, a famous place for pilgrimages; the water rises from a spring cover'd over, and runs into two baths, one public the other private; at the spring they wash their eyes, and in the baths the people as a part of their religion, go in naked and dip themselves, near the well they go round a sort of an Altar, probably the side of an old Chapel by way of Penance, sometimes on their knees; and near it a Chapel was lately built, but 'twas not thought proper to permit them to cover it:[26](javascript:footNote('E750002-001/note026.html')) on the side of this hill to the south is a rock something in form of a seat which they call **St. Patrick's Chair**, with a way round it over the broken rock, and to go in this way, sometimes even on their knees, is also a part of the penance; and on Midsummer day when they are performing their pilgrimages there are a great number of priests near who give them Absolution. A mile farther is ***Downpatrick*** where the hills form a beautiful Amphitheatre; on two of these hills the town is built, and the third side is covered with the wood and gardens that are about a house, which if I mistake not belongs to **Mr. Southwell**, who is Lord of the town: and on the western hill are the walls of the ancient Cathedral, called the Abby, which is not large but has a very venerable aspect; near it are the remains of a round tower. This spot commands a view of the Lake beneath, now indeed almost drained, and of all the country to the south 
 


---

p.13



and west, the small hills being cover'd with corn. From this hill also is a view of the **Abby of Inch** in an Island of the Lough, and of **Mr. Maxwell**'s large house of **Finnibrothy** near it. Below the Abbey is a very *handsome* brick building, in the middle part an apartment for six men, and six women, and at each end a School for ten girls, at the other for as many boys, who are to be fed and lodged as well as cloth'd and taught. All the foundation of **Mr. Southwell** of **King's Weston**. At the lower end of the town is the Townhouse, and above it a *handsome* portico of twenty-four Arches for the linnen Market, which is very considerable at this place, and *adjoining* to that is a School, to teach the poor children of the town, who are not in the other Schools. Near this is a good new-built Church, and beyond that a free School house for teaching Latin, which seemed to be in a ruinous way. The chief support of this place is a market and Fairs for linnen. This is the proper place of Residence for the Bishop and Dean of **Down**, but neither of them have houses here. I had almost forgot to mention four Apartments for Clergymen's widows, which are maintained as well as I could be informed by subscription. On a hill to the North of the town is an ancient fortification, called the Rath of ***Downpatrick***, encompassed with three fossees, it is about 700 yards over, as I have been inform'd, and measures by the ascent sixty feet from the bottom, and it may be questioned, whether this is not the ancient **Dunum** of **Ptolemy**. Near ***Downpatrick*** is a famous horse course for races; here two or three plates are run for, which are given by the Corporation of Horse Breeders in the County of **Down**, erected by **King James II.** under a charter into a Corporation, with liberty to purchase £200 a-year in lands, and a power to have a treasurer, register and other officers, and that a



---

p.14



fair should be held for six days at the time of the races, Customs to be paid belonging to the Corporation, during which fairs, they have power to hold a Court for certain purposes.[27](javascript:footNote('E750002-001/note027.html')) I crossed over the communication between this Lough and that of **Strangford**, and turning to the left came to **Inch Abby**, removed from **Carrig** near **Erynach**; the church appears to have been a grand building, there are three windows to the east, and two on each side near it, all narrow and turned with Gothick arches; on the south side are seen the tops of the seats for the administering Priest and those who assisted him, as cut in the wall and beautified with Gothick sculpture.[28](javascript:footNote('E750002-001/note028.html'))


I saw a number of women in an adjacent *cabin*, and my curiosity led me to go in, it was a wake over the body of an old man, who was stretched on the floor and covered with a sheet. About 3 feet above the corpse was a board covered with a white cloth, on which they place candles; and the women sit round the corpse, they are entertained with a spirit of Barley, call'd Whiskey, with Tabacco and sometimes with bread, cake, &c, and frequently drink to excess with such instances of mortality before their eyes, and this they look on as an act of Devotion. I returned back over the bridge, and saw the sluices to let out the fresh water and keep out the tide, but as there are not sluices enough to carry off the former the draining of the land is not *completed*. A little beyond this is the port of ***Downpatrick*** from the **Bay of Strangford**, to which vessels can come of about fifty Tons. About a mile farther and over this arm of the sea, which they call the Lough, are ruins of the **Abbey of Saul**, founded by St. Patrick for **Canons Regular**, and rebuilt by



---

p.15


**Malachy O'Morgair Bishop of **Down****, it is now entirely ruined, but very near it, are some of the walls of an old Castle. They have lately built a small Church on the site of the Monastery, having according to the style of this country, only windows on the South side and one at the East end. Two or three miles farther we came to the plantation of **Castle Ward** belonging to Judge Ward, situated very beautifully on the **Bay of Strangford**; they are very fine not only in Groves and clumps of trees, but in quick fences to the road, adorned with flowering shrubs as well as rows of trees. Here is a contrivance for a mill by a flood gate to let in the *tide* and another to let it out when they please, by which means they can keep the mill almost always going.[29](javascript:footNote('E750002-001/note029.html')) On a point of land over the Bay to the North of this, is a lofty old fabrick called **Castle Audley**, supposed to be built by one of the **Audley family**, who settled in **Ireland** under **John de Curcey**, about the time of **Henry 2d.** which family has not been long extinct. I went from **Castle Ward** to the Charter School of **Strangford**, which is very near it, for the founding of which the late Earl of Kildare left £500 and his Dowager gave two acres for ever, and 20 acres at half rent;—It is for twenty boys and twenty girls. **Strangford** is very pleasantly situated on the hanging ground over the bay, but it is a very poor town without trade, consisting of little more than one small Street, the buildings of which are mostly on the upper side. The Parish Church is a mile off, if I mistake not at **Baleycuther**, and the chapel in the town repaired by the late Earl of Kildare is going to ruin. About two miles south of **Strangford** is the Castle of **Kilclief** in which about the middle of last century a Bishop of Down



---

p.16



resided.[30](javascript:footNote('E750002-001/note030.html'))


On the 27th I crossed from **Strangford** in the ferry a mile to the country call'd ***Ards***, which is a peninsula and to the town called **Portaferry**, which tho' small is a much better place than **Strangford**; it is built up the side of the hill and has some export of corn and kelp. This Living is the corps of the Chancellorship of **Down**. In all these parts are meeting-houses, and here is one Mass house, the only one in all ***Ards***, the bulk of the people in the County of **Down** being Presbyterians. This Country of ***Ards*** is very beautiful being a rising ground, something like the **Isle of Wight**, except that there is no flat on each side, and it is all cover'd with corn; they manure with marle, which they have in most of the grounds from the North of **Strangford Lough** to the **Bay of Dundrum**, there is a great mixture of shells in it. Those about ***Downpatrick*** I observed were a small beautiful turbinated shell, in ***Ards*** a larger kind, scollops, oysters, cockles and others, it is a mixture of clay and sand; the land will bear a crop of Barley and two of *oats*, and sometimes they sow it four years, but then it hurts the land, and it produces hardly any herbage the first year after it is laid down: if they plough it seven years as some do it ruins the land for several years; but after three years tillage it will bring tolerable grass the first year and very good for three years, and then they plough it again but must not put on more marle, it has been found out about 30 years and probably in a course of years, they may find it proper to try whether more marle may not do the land good. This country chiefly belongs to the **Savages**, **Echlins**, **Baylies** and **Montgomeries**. There is one road on the West side of this country to **Newtown** and another on the East to **Donaghadee**; I took the western 



---

p.17



road, in two miles I came to **Abbacy** or **Ardquine** (a Bishop's estate lease) belonging to the **Echlins**, descendants of a Bishop of Down in 1635. It is thought by some from the name to be the site of the Priory of Eyries, which is not known. About two miles further is a seat of the **Savages** call'd **Ardchin** pleasantly situated on the Lake; but not much improved—the sea has covered most of the low land there is in this country which is not much, and made it a Morass, but they have now drained a good part of it. Two miles further is **Echlin's Ville**, so called from the owner, and as much farther **Inishargy** the seat of **Mr. Bayley**, and two miles further is **Rosemount**, the seat of the **Montgomeries**, so call'd from a mount on the hill over it, and on the sea there is a small Danish fort. This estate is a purchase of a collateral branch of the family of **Sir James Montgomery**, second son of **Lord Montgomery**, of the time of **King Charles the First**, who was bred to the Law, had travelled, and by the epitaph in the Church, appears to have been a linguist and a lover of Poetry. The Mansion house is built near the **Old Gray Abbey**, which is in the style of the Church of **Inch**, and part of it is repaired for divine service.


A Bell mettle jug was found in 1722, in the bog of **Bayleys Murphey** near this place, about eight inches high, with a spout and handle, and was presented to the **University of Dublin**. And in 1728 an earthen Urn with burnt bones in was found on the Abbey lands. The old Town is near the Abbey, and the new town a furlong from it on the sea. They have two or three quarries of very good slate in this Neighbourhood: This part of the country is call'd great ***Ards*** and also **Clanbois**, from an antient clan as supposed; the southern part is little ***Ards***. As we approached towards the North end of the Lough, the road



---

p.18



was more pleasant, as it commanded a better view of the opposite country, from which they cross over the Strand when the *tide* is out, having a pillar built on each side as a mark to direct the passengers. I arrived at **Newtown** most pleasantly situated on the North end of this bay, something like St. Maries near **Southampton**, the Lough and the lands to the south having much the appearance of **Southampton bay** and the **Isle of Wight**: It is a burrough town, and they have a considerable trade in Linnen, especially Diapers. There are remains here of a Dominican Convent, in which Chapters of the order have been held. I omitted to see the beautiful family chapel of the Colviles, who have as I was informed sold this estate to one **Mr. Stewart**. This town is seven miles from **Donaghadee**, at which place I landed from **Scotland** in 1747. A mile in that road is **Movilee** a monastery of **Canons of the order of St. Austin**, founded by **St. Finian** in 550. To the south west of **Newtown** about a mile is a hill called **Scraba** or **Strabo**, where there is a quarry of Free stone; the buildings I saw of it in this country stand very well, tho' it burns black, but I was informed that the stone of the College Library which scales is of this quarry which possibly might be owing to some mismanagement in the quarrying or carriage, and it may be by reason that it might have taken salt water.


I ascended a long hill northward to **Bangor**; on the top of it they were finishing a thatch'd meeting house; I came to this place in order to cross above two leagues to **Carrickfergus**, but the wind being high I went round by **Belfast**. **Bangor** is pleasantly situated on a high ground over the Bay of **Carrickfergus**, it is a poor Burrough town consisting of a long broad street down the side of the hill to the sea, the houses are about 200 in number; tho' they have



---

p.19



a slate quarry near the town, yet the houses are all thatch'd. The chief support of the inhabitants is spinning, there being but two fishing boats tho' it is finely situated for a fishery; it was the estate of the **Hamiltons** Lords of Claneborg, one of which was **Earl of **Clanbrazil**** and has been divided between two co-heiresses, the Mother of **Lord Ikerrin, now Earl of **Carrick**** and Judge Ward's Lady; the mansion house here is very indifferent, but the spruce *fir*, the Ilex, Bays, Hollies and other evergreens, planted at first chiefly in the Flower garden are grown to he very fine forest trees: the church is on the side of the old Abbey, in it is a monument to **Beatrix Hamilton**, with a remarkable copy of English verses, through which there runs a very great strain of piety. There is also a monument to **John Gibson the first Protestant Dean of **Down**** in 1623, in which it is mentioned that when he came there, he had only forty communicants, and when he *died* he left 1200. There was here a famous Abbey of Canons, founded by **St. Congall** about 555, which he himself governed by a particular rule, but afterwards it took the **order of St. Austin**. It is thought that the History of this Abbey is confounded with that of **Bangor** in **England**: in the relation that is given of the great number of monks, and of many of them that were killed at one time. There are remains of one part of it, with the ancient narrow Gothick windows. **Mr. Winder**[31](javascript:footNote('E750002-001/note031.html')) the Minister of this place came to see me, and showed me all these things with great civility. On the high ground here, we saw very plainly that part of **Scotland**, which is called 



---

p.20



the Mull of **Galway**. A little to the East of **Bangor** is **Groom Port Bay** where **Duke Schomberg** with 1,000 men came to anchor in 1689 and soon took **Carrickfergus** and was created **Earl of **Bangor****. In great **Copland Island** at the mouth of the Bay is a slate quarry. I had a very pleasant ride near the Bay for ten miles to **Belfast** in the County of **Antrim**, the direct road being but eight, and there are several gentlemen's houses very finely situated over the bay. **Belfast** stands on the west side of the bay, just at the end of it and is a considerable town of trade, especially in the linnen manufacture, in which they are all concern'd, buying the yarn and giving it to be *woven*, they also send several ships to the West Indies. It is the Estate of the **Earl of ***Donegal*****; and the town are very uneasy that they cannot get new leases to build, all of them being near expiring, for the estate is entailed on the sons of **Mr. Chichester**, who are minors, whose Mother is sister to Sir Roger Neudigate. This Lord is, as in a state of infancy and in the hands of relations who agree to divide all between them, and have not taken out a Commission of Lunacy: And the guardians of the Minors, oppose the procuring an Act of Parliament to enable him to lett the Lands.[32](javascript:footNote('E750002-001/note032.html'))


The river **Lagan** runs through a very fine country, and falls into the sea at **Belfast**, where there is a bridge over it, of about 20 arches 840 feet in length, with a Causeway at both ends which make up 1722 feet, it is 22 feet broad. The country on this river, and all the way to **Ardmagh** is look'd on as the finest spot in **Ireland**, and being well watered and between the **Lough of Strangford** and **Lough Neagh** and **Carrickfergus Bay**, these situations give it a 



---

p.21



very great advantage. The town of **Belfast** consists of one long broad Street, and of several lanes in which the inferior people live; the church seems to be an old tower or Castle, to which they have built so as to make it a greek Cross, and it is a very mean fabrick for such a considerable place; indeed the congregation is but small, and most of them of the lower rank, for of 400 houses, there are but about sixty families that go to Church; the richer people with a number of others are of the new light Presbyterians, the rest of the old light and Papists. The new light are look'd on as Arians; and these two lights have a greater aversion to each other, than they have to the Church. The **Earl of ***Donegal*****'s house at the end of the town was burnt down about the beginning of this century and two daughters were burn'd in it[33](javascript:footNote('E750002-001/note033.html')) the garden, groves, meadows and fields on the river belonging to it are very delightful.


On the 29th. it being a wet morning I did not set out till noon for **Carrickfergus** eight miles distant it is a pleasant road near the bay. This is a poor town tho' well situated, the Castle is built on a rock, which is washed on three sides by the sea, it is a strong place and is kept in pretty good order, and no one being permitted to go to it in time of war, the orders have not been taken off in time of peace. **Lord *Donegal*** has a very large house here, built about the time of **Queen Elizabeth**, when his Ancestor **Sir *(?Arthur)* Chichester** was Lord Deputy of **Ireland**, and obtained the grants of his great Estate, which in this country as I was inform'd is £8,000 a year, that he has



---

p.22



5 or £6,000 a year in other parts, and that if the whole were out of lease it would let for £30,000 a year. There are great plenty of small scollops in this sea: The Mayor has the Admiralty from **Fair Point** to the North to **Beerlooms** near **Strangford**, the creeks of **Bangor** and **Belfast** excepted, they had also in the same extent all customs which **Lord Strafford** purchased for the King for £2,000, after which the Custom house was removed to **Belfast**, and this town began to decline. I dined here. The Mayoralty here is worth disputing, and has caused a division in the town, for it is about £100 a year, chiefly arising out of lands given for forage for the King's troops, who have not of late years been sent to Barracks here. I set forward on the sea coast and passed by **Castle Dobbs**, the seat of that gentleman who is member for **Carrickfergus**, and has so strenuously pushed the affair of a passage through **Hudson's Bay**, but without success. The Castle is a low situation behind the hill, but he is building on a very fine spot on the rising ground. A little further is a very pleasant mansion house of **Mr. Brice**: I ascended a little height, at the top of which a new and most beautiful scene appear'd of the delightful harbour of **Larne**, which comes in between the land, and makes what they call **Magee Island** a Peninsula; but I could not learn that there was any rivlet or opening from the South end of this bay into the sea, as the maps represent it which would make it an Island. It is about six miles in length and a mile and a half broad, and much resembles the high ground that runs the length of the **Isle of Wight**, but it is not so high, and there is no level ground on each side but it is all cover'd with corn and rich pasturage. I saw two roads one along the top of it, another on the west with many houses on each side of it, and if I mistake not there is a third on the 



---

p.23



east side; It is without trees the most beautiful and extraordinary spot that can be imagined: this and the country to **Larne** is the Estate of the **Lord *Donegal***, as all to the north belongs to the **Earl of **Antrim****. I travelled near this fine harbour, and came to a new kind of soil a white *lime stone*, which having flint in it, as chalk always has, I do much suspect that it was formerly in that state, for it will now almost mark white; the flint in it is chiefly of a pale *blue* and whitish: above this is what they call rotten rock, a sort of crumbling stone, which makes excellent roads, soon dissolving and is easy to the horses feet, but it does not last so long as the lime stone, which tho' much harder yet it soon makes a smooth road, but when narrow and raised in the middle, as is the case here, it is slippery and dangerous at least for horses not accustomed to it. Over the rotten rock is a blackish firestone, called a whine stone, it most of it appears to me, to be of the granite kind, but with very small grains. I passed by a pleasant village in a little vale, from which it has the name of **Glyn**, and came to a spring on the *shore*, in which there is a very small fresh water shell-fish, of the wilk or turbinated kind, and a small limpet, no bigger than a vitch, sticking on the stones, which I never saw before in fresh water: but what is most remarkable about this well, on the *shore*, they find the **Asteriae** and **Astroitae**, some of them smaller than ever I met with before, but they are difficult to be found.


**Larne** is pleasantly situated at the north end of this bay, a point of land running out to the south east; directly south of which is the harbour for large vessels, where they are well defended against the weather; and that point is a most pleasant rising ground, on which there is an old Castle. **Larne** tho' a poor town, consists of a street



---

p.24



 
not much less than half a mile in length, and a rivlet falling from the hills at one end, a race of it is brought along behind the houses, which is a great conveniency as well as beauty. They have a little linnen trade, a few fishing boats and salt works (as along the coast) of salt rock of Cheshire boiled with sea water. They have also some little traffick in sending out lime stone and furnishing the neighbouring parts with lime: near the ancient church there is a Mount, which I take to be of the monumental kind, and beyond this is a field, called the Chapel field, where they say are some marks of the foundation of an old Chapel.


On the 30th I set out northward and ascending the hill, saw a *beautiful* country between the low hills to the sea, and the mountains to the west, it is almost all covered with oats, with houses very thick all over it, and little plantations about them in their gardens, so that they appear like little groves or clumps of trees all over the country, which strikes the more, as there is not any other tree to be seen in the country: it is entirely an open country like common fields. From this ground I saw the rocks called by the sailors the maidens, and by the country people the Whilkins. I turn'd out of the way to go to the sea cliffs, which are of the black stone, in order to see what they call the black cave, but found it to be nothing but a passage worn through the rock; beyond this is a fine head called **Baleygelly** the seat of Mr.[*gap: extent: one word*]. I travelled through this fine country, which makes up the great Living of **Larne Castle**: They are notwithstanding very indifferent husbandmen, their common method being to plough one year and lay down one year, nor have they the method I saw in the County of **Down** of making folds with green sod, to fold their sheep in order to manure the land.




---

p.25


I ascended a high hill which is the point that makes the **Bay of Glenarme**, and struck out of the road to the east, to go through **Lord Antrim**'s little park, which is the most beautiful and romantick ground I ever beheld; it is the very point which makes the bay to the north, and is a hanging ground over the sea, from which there is a steep ascent, it may be of fifty yards, on which there is a wood, then there is an uneven lawn with some wood in several parts and rocks rising up so as that at a distance, some of them appear like ruins of Castles, then there is a very steep ascent, not less than 80 or 90 yards high cover'd with wood, this leads to a lawn, and going on towards the north the point of ground rises higher and terminates in a *beautiful* mount which commands a fine prospect, where My Lord often dines: further to the north is another *height*, all the hanging ground from them beautifully cover'd with wood: above this lawn which is within these heights is the perpendicular rock, at least an hundred yards in height, out of which shrubs and trees grow in a most *beautiful* manner; the ascent up to the door of the park at a lower part of the hill is difficult; above this height is the road from **Larne** to **Glenarme** and they tell many extraordinary stories of men and cattle that have fall'n down these precipices and have not been much hurt. I descended a long hill to **Glenarme**, a village situated on each side of a river in a narrow vale, between the hills on the **Bay of Glenarme**, where **Lord Antrim** has resided in an ordinary house, since his habitation at **Ballimagarry** near **Dunluce** was burnt; but there is an old house with good room in it, without a roof which he is about to repair. There are some remains of an old Abbey on the bay, and a sort of rampart on the north of it, as for a place of defence to retire to in a time of danger. Over the town to 



---

p.26



the north is a hill with an easy ascent, on which there is a horse course, which commands a fine view, especially of the great park, and here My Lord has a stable for his race horses; this nobleman's chief amusement being the fine horses which he breeds every year. **Mr. Broome** a relation to the late **Bishop of **Down** Dr. Rider, now Archbishop of **Tuam****, is minister of this parish; he paid me a visit, and carried me to see Lady Antrim's grotto, in which there are a great number of fine and curious shells, and many of the pinna, which are found off the north east point of **Ireland**. He brought me compliments from my **Lord Antrim** that he would be glad to see me. **Mr. Broome** *rode* with me to the great park, which is as curious and beautiful as the other, but in a different way: two rivers rise in the hills meet below and make the river of **Glenarme**, which flows in the narrow valley; the park wall runs along the top of the hills and almost encloses these three rivers, being about nine miles in circumference: the entrance to the park is about half a mile to the west of **Glenarme**, and on both sides of the river both below and on sides of the hills, is an agreeable variety of Lawn and wood for a mile; further on it is all wood and on both sides, and just at the entrance of this wood on an eminence, is a banqueting house in a very romantick situation: when one has enter'd the wood, the bed of the river is deeper, having perpendicular rocks on each side from twenty to forty feet high and trees grow out of them, and one sees between them many *beautiful* cascades, particularly one near 30 feet high; about ten feet below the top is a shelf, and at top the rock overhangs so, as no salmon can get up but they frequently leap and fall on that shelf, and often bruise themselves so that they die. Above is another very beautiful cascade in two or three falls in the breadth of



---

p.27



the river, but the finest in is the middle: I went up the eastern river to see the most *beautiful* of all; which tumbles down is a sheet near 30 feet; from this we ascended up the hill to the east through the wood and came to a lawn, and had a view to the west of the round high top of the [*...*] sleamish (I am the hill) by way of eminence, near which **St. Patrick** when he first came from **Scotland** fed hogs, and on the hill **Skerries** not far from it, are remains of a church, which is said to be the first in **Ireland**. We returned home by the hill to the gate of the park we came in at. I waited on Lord and Lady Antrim, and lay at my Lds. house.


On the first of July, I walk'd up to the course, and set out; My Lord sent a man five miles with me, and **Mr. Brougham** and **Mr. O'Neale** accompanied me three. We passed the end of **Kle Glyn** and ascended towards a high point called **Mount Garranpoint**, and in the map **Ardclinnis Point**, over which there is a very steep road, and at the bottom of it, is a rock, which, before part of it fell down, was thought to be the figure of a fish. From this point the mountains are very fine, quite perpendicular towards the top with trees growing out of them as in the little park, from which large white lime stone rocks have roll'd down, in many of which I saw Belemnites which are frequently found on the *shore*, as well as **echini**; but it is very difficult to separate them from the rock: the lower part of this opening call'd **Red Bay** is much admired, having the same kind of ground on each side of the valley, but no wood below, so that I think it is not near so *beautiful* as the ground of the great park; but it is said that the late Lord had thought of making a park there, which he might have done, only by building a wall at the sea and at the west angle. In this road we observed several streams running from the hill, which



---

p.28



flow'd underground into the sea, on the north side of this vale a river falls into the sea, near the mouth of it are cliffs of a sandy red stone in which there are four or five caves, and some families live in them: and just over the point are remains of an old Castle call'd **Redbay Castle**. On the south side of the bay I observed an old church which answers to the situation of **Galbally** in **Sr. Wm. Petty**'s map. When I passed this point turning round I was surpriz'd at the sight of the end of the mountain to the north east of the valley, which appeared with a most *beautiful* square top, and in some situations like a Lozenge this is call'd **Clockay Brackeen**. I came to another little valley call'd ***Cushendall*** where I dined; Going two miles to **Cushenden Bay**, I was directed about half a mile from the road to see some caves, which are not so curious altogether as the sea cliff, which is the most *beautiful* I ever saw, it consists of pebbles of a middling size of different colours all cemented together; so that it has the appearance of variegated marble, and is exactly like the **Hertfordshire** stone which is used for the top of snuff boxes, except that the stones are much larger, that is from about four or five to 8 or 9 inches in diameter. The sheep take shelter in these caves in the winter, and there is in some part of the grotts a cake of their dung near a foot thick, which the people have not as yet taken away for manure. Over the north side of this bay is an old tower, which is I suppose what is called in the map **Caries Castle**. This head of Land is the most north eastern point of **Ireland**. We returned to the road on the other side of the river and ascended up a very long hill, to a healthy country, which affords good turf with a gravel under it, and the white lime stone is found in many parts through the country The soil being alter'd from **Red Bay** to this place, in which



---

p.29



space there is no lime stone: Very fine roads are made here all the way to **Ballycastle** in which coming near the northern *shore* of **Ireland** we turn'd to the west and passed by **Caravadount**, below which is a Danish fort, and a little farther to the south is a fine flat hill called **Drumnikilliah**, which much resembles the situation of Jerusalem: and so we arrived at **Ballycastle**: From the eastern shore I saw the Isle of **Sanda** to the east of which a McDonel is Laird: And the ***Mull of Kintyre*** in **Scotland** seemed surprizingly near in the bay of ***Cushendun***, tho' it is almost thirty miles distant, but it is a very high land; they often go over to that land for game: where there is great plenty of what is called the black game, which **Lord Antrim** has brought over more than once, but could never get them to breed, or keep them long, so that probably they return back. **Ballycastle** is situated in a sort of a creek, at the mouth of the small river **Glenshesk** in the large open bay which is made by **Fairhead** and the point at **Balintoy**, near which **Sheep Island** is seen, having the Isle of ***Rathlin*** stretching to the north of it from east to west. The *tide* comes in from the north, and probably the tides meeting off **Fairhead** and the ***Mull of Kintyre*** cause such an Eddy current that in the bay the flow lasts nine hours and the ebb only three. **Ballycastle** is a strong instance of the assiduity and judgment of one person **Mr. Boyd** to whom the place belongs, who holds it as a fee farm under **Lord Antrim**, who has made most of his tenants happy in such a tenure; for all this country as I mention'd before belongs to **Lord Antrim**; his ancestors from **Scotland**, the **McDonalds**, conquer'd it, and **Queen Elizabeth** granted it to them by patent; the family are now distinguished by the title of Antrim; it extends from near **Larne** to ***Coleraine***: from ***Larne*** to **Glenarme** the people are mostly Presbyterian,



---

p.30



as well as from **Ballycastle** to **Coleraine**; but from **Glenarme** to **Ballycastle** they are for the most part Papists. **Mr. Boyd**'s great work was to make a safe harbour for shipping, which he had done most effectually, having received £10,000 from the publick for that purpose: It was effected by a pier to the north and east made of piles of oak, fixed together with iron, and all fill'd within with large stones, so that it makes three very good Quays. But unfortunately last winter, some of the piles to the north gave way in a violent storm, and about the same time some of the inner piles of the eastern pier fail'd, occasioned by fastening their cables to them: But when they came to examine the foot of the piles, they found they had been eaten by a small worm, of a different kind from those of the Indies or **Holland**, or from those I saw at **Shoreham**, being very small, about a quarter of an inch long, and as big as a *middling* pin; Looking on them in a microscope, on the back they appear like a smooth grub, on the belly a little like a shrimp, with seven legs on each side, and I think a smaller pair behind, it has large black eyes and the snout seems to be pointed, and probably has on it such a pair of shells to bore as the larger have, but I could not discern it: They make holes in the length of the part of the wood which is always under the salt water, for the air or fresh water kills them: This mole is on the west side of the little bay: To the east along the *shore* which faces it is sandy, and piles are droven in to keep the sea from gaining on the bank, and when it does gain, they fill it again with great *expense*; and they are now making a strong pier built of stone and mortar, where the piles have fail'd, on one side are store houses, on another smiths' forges and all sorts of trades, for building boats and for carrying on the work of the piers, besides this **Mr. 



---

p.31



Boyd** has built a very good Inn, a Brewery, Tan-yard, houses for *boiling* soap, and salt, making candles, and a very fine bleach yard; all which he farms out. He has also built a handsome house for himself, and a brick wall on two sides of a garden of seven acres; and at the same time has carried on the works of a very considerable colliery, which is to the east towards **Fairhead** on the sea side. The first is about a mile from the town, where there is a fine boxwheel for raising the water out of the coalpits, turned by a stream brought from the river by a channel cut along the side of the hill, and through some high ground for above a mile; about half a mile further is a shaft near the top of the cliff, and as much further another to which there is an entrance from the *shore* by a passage, the top and side of which are supported by woodwork: At the collieries are quays for shipping them on small vessels made at great *expense* with large stones. From the first pit there is a way made with wood, as at **Whitehaven** and **Newcastle** for two carts to be drawn on. This sea cliff is very curious, but appears most *beautiful* at **Fairhead**. There is first a stratum of firestone, which is in pillars of one stone, some of them being near twenty feet long, and this seems to be some tendency towards the *natural* production of the **Giant's Causeway**; this in **Fairhead** has something of the appearance of a Gothick work: then there is what they call Till, which I take it, is a ragged broken stone, then free stone, next a vein of coal followed by Till, and then two layers of free stone of different qualities; for there they have grinding stones and whetstones out of different quarries. They have a vitriol spring in one part, and one sees several perpendicular veins in the cliffs which they call faults in the work, they extend into the sea, and one of them being about fifteen or twenty feet broad, appears like a large Causeway.




---

p.32


This Gentleman in the colliery and all the manufactures he supports, has about 300 people employed every day, and in the years of scarcity he took care to buy corn and have it sold at a reasonable price. All these things undertaken and carried on by one man, are a very uncommon and extraordinary instance in a practical way of human understanding and prudence.


The old Town of **Ballycastle** is a quarter of a mile from the port, which consists of a short street, and here they hold their markets; and just below it is an old mansion house in ruins of the Antrim family. When I came to **Ballycastle** **Mr. Boyd** soon found out, I had compliments to him from the **Archbishop of **Dublin****, he obliged me to make his house my home; where I met my acquaintance his daughter **Mrs. Macaulay**, married to **Dr. Macaulay Vicar General of the Diocese of **Dublin****.


On the 2nd he showed me all these things. To the east of the town is a building they call the Abbey, which I suppose was a Convent, in it is a Chapel, on the side of which is the following inscription.
  


> 
> In Dei
>   
> 
> Deiparaeque virginis honorem illustrissimus ac Nobilissimus **Dominus Randolphus M'Donnel Comes de **Antrim**** hoc Sacellum fieri curavit.
> 
> 
> An. Dom. 1612.
> 
> 
> 




On the 3d. I set out with **Mr. Harrison** Minister of the place and another gentleman to see the Charter School, about half a mile beyond the town and founded by **Mr. Boyd** for boys and girls, and taking leave of them I travelled to the west near the sea cliffs which are of lime stone from a little beyond **Ballycastle** to the end of **Balintoy Bay**, where the cliffs are of that sort of rock which is in the cliffs of the **Giant's Causeway**. About two miles from **Ballycastle** I observ'd on the left a long low 



---

p.33



hill called **Cregeny**, where I saw pillars like those in the **Giant's Causeway** of a larger size*;* I measured some of them which were pentagons, one was thirty one inches over, the other twenty; so this is to be reckoned the beginning of this extraordinary natural production. I descended the hill and going along the plain came near the west side of the **Bay of Balintoy**, passing by the church and village of that name and came to the estate of **Mr. M'Neal**, where following a rivlet I came to a small bay, where the stones had some *little* resemblance of the Causeway at a distance, but I found them in large pieces as in quarries; I dined here by the stream. Going on westward I soon came to a little bay, in which there is a small high peninsula with ruins of a Castle on it, called **Donseverick**; from which I walk'd along the top of the sea cliffs, and coming to a little bay to which there is a tolerable descent, the cliff being all covered with grass, I descended as I suppose between two and three hundred yards; on the east side of this bay is a curious high rock, and as there are shelves in the steep cliffs, so the goats go along those shelves to feed: Here we found people a' fishing: Returning up we came to **Port Maher**, for they give all these little creeks or bays the name of ports; I saw the tops of pillars at the bottom of this bay, next we came to **Port Forts Frid**, where there are pillars in the cliffs, and some of them stand single and in a little port beyond it called **Beneagore**, are two or three little risings in the manner of the **Giant's Causeway**. The next is port **Loganeny**, where there is a good way down the cliff and there are pillars towards the top and bottom. The next is **Portnabrok**, where two eagles flew out of the rocks, which were of a lighter colour than any I have seen, and possibly may be of the vulture kind, but I am inform'd



---

p.34



since that they are the rock Eagle, and are larger than the mountain eagle; here are pillars at the bottom of the *shore*, but the two rows above are extremely fine and regular; as well as I could conjecture, there was ten feet of rock, then a tier of pillars forty feet, rock 40 feet, pillars 40 feet, rock 20 ft. and then a steep descent with grass growing on it at least forty feet high: Turning the small end of the glass it had a most *beautiful* effect, they appeared like a landscape of Portico's at a distance, and not unlike the view we have engraved at **Palmyra**. The next is **Port Noffer** and then is **Portnespagna**, which is formed to the west by the point on which are those pillars call'd the chimneys. This little bay has its name from a tradition that a Spanish man of war came near in hazy heather and thought the rocks and pillars were a fort and fired at them, but the rocks made a melancholy reprizal, when as they say she was soon after dash'd against them. I then walked on and looked down on what they call the **Gyants Causelway**, which I viewed in 1747, having walked about four miles along the sea cliffs with equal pleasure and astonishment, viewing this wonderful work of nature.


From the cliffs I struck down through **Bushmills**, ***Dunluce***, and **Ballimagarry** to ***Portrush***, where not meeting with accommodation, I was forced at ten o'clock at night to retire three miles to **Ballimagarry**, where I took up my quarters. I walk'd along on the top of the sea cliffs half a mile to **Dunluce** and it was very curious to see the Gulls in their nests, which they have made of clay and sand in the sides of the perpendicular rocks, so as that the nests overhang from the rock, and great numbers of birds flying about make a very great noise, the eagles come often and take their young which are a delicious morsel for them. The Cormorants build with sea weed on little shelves on



---

p.35



the sides of the rocks and one sees the hen in the nest and her little ones sitting round her and the cock near; which is a very pretty sight. At **Dunluce** I went to see the Castle which is on a rock *joined* to the land by an Istmus that is about thirty feet lower than the top of the rock; and they cross to it by a drawbridge, it is now *joined* by a wall about two feet thick and 30 feet over, on which some people go to it: I walk'd over it; it is an old irregular Castle that may be the 8th of a mile in circumference, and under it is a broad cave with an opening to the south and another to the north to the sea. The Earls of Antrim did live in this Castle, and one of their Ladies not liking the noise of the waves, had a house built for her just at the entrance of it, where she liv'd; which house is now standing without a roof: This if I mistake not was the *Duchess* of Buckingham widow of the Duke who was stab'd at **Portsmouth**, and was married to the head of this family, who had the title of Marquise of Antrim. I went by sea to the **Giant's Causeway**, and taking it as near as I could in a triangle, I measured the three sides and took the bearings and measured an Octagon with all the pillars round it; and return'd, landing in the Port of **Balintray**, at the mouth of the river **Bush**; here they say was formerly a port of trade which had priviledges granted to it. Ascending to the right are two Baths, very near to each other, with a double fossee, they call 'em Danish forts, and say that to this day, some family in Denmark settles these lands on any marriage. A little further but on the cliff is a little cape which is defended by a fossee drawn across the neck of it:—There is a tradition that the Danes went off from this place.


On the 5th I walked two miles to **Balywilly** church of which **Mr. Cuppaige** is Curate whom I had met at **Ballycastle**,



---

p.36



I preach'd for him, and **Mr. Stewart** near invited me to dine with him, but I excused myself; and a person who showed me some civility by accompanying me home: dined with me; I saw in the way a low rocky hill called **Cregahullen-Craig** where there are pillars as in the **Giant's Causeway**, some sides of which I measured and found them to be large; there is another a mile further, and I observed even near as far as **Solomons Porch**, six miles beyond ***Coleraine*** that the rocks have some *little* resemblance of the Causeway, but not in true pillars. In the afternoon I went down to the strand to see grottoes and caves in the Lime stone white cliffs, which begin from **Dunluce** and extend to the strand of **Portrush**, and they are the most extraordinary and *beautiful* I ever saw, some in open grottoes, others in large narrow caves going in a great way, having *beautiful* stalactites in them; one of them exceeds the rest in beauty, being about thirty paces wide and 70 long, with three pillars of rock on the east side, the white colour of the rock and the flints intermixt, and in many parts Belemnites add to the beauty and curiosity of the sight. **Portrush** is a little creek encompassed with sandy banks, which gain on the land as the sands do in **Cornwall**: tho' it is well sheltered yet there runs such a sea, that it is not safe for the boats in winter; at some distance from this Creek is an Island called **Skerries**, and in the map **Portrush Island**, which makes the sea to the south a pretty good road to ride in during the summer-season, but it is only a shelter to the north, the lands on each side being some *little* covering to the East and West. This *little* town is of so *little* consequence that there is not a publick house in it for the accomodation of travellers; they have but one Merchant in the town, who deals chiefly in shipping off corn and kelp. I took a walk also to **Lord



---

p.37



Antrim**'s house close to **Baleymagarry**, which was burnt down about two years ago; it is a fine situation commanding a view of the sea of *Inishowen* to the north west and of the sea coast to the east. The house was built of the pillar stones of the quarry I have mentioned near, and I saw one there of nine sides. **Lord Antrim** had thoughts of building an house on a spot near, but it is said has altered his purpose. From the high lands there is a view of the **Island of Ila**, where it is said is the famous Abbey called **Columkil**, in which the ancient kings of **Scotland** are *buried*; and to the north of this one sees the Island of **Jura**, appearing like three remarkable hills. There is an ancient *cairn* at **Ballimagarry** consisting of ground raised five or six feet, it may be 100 feet in diameter, there are some large stones in the middle, they have the name of the person to whose honour, as tradition *says* it was made. They have a method in the north of weeding their corn with what they call a Clip, it is a pair of pinchers made of two pieces of wood, and handles standing like those of a pair of sheers, and they pull up the strongest docks with it.


On the 7th I *rode* to the **Giant's Causeway**, and attended the raising the most curious stones I could find, and in the even on my return waited on **Mr. Duncane** who lives in the way, with a letter I had to him and came home.


On the 8th I went to the Causeway late, and **Mr. Duncane** came and dined with me, and sent a fresh salmon which was roasted before a turf fire, it was cut in pieces and stuck on five or six sticks set in the ground round the fire and sometimes taken up and turn'd. He left **Mr. Bromhall** with me, his children's Tutor, and I came with him to his house drank tea and came home.


On the 9th I staid within all day and *wrote* letters, **Mr. Duncan** and **Mr. 



---

p.38



Bromhall** came to see me.


On the 10th I went to the Causeway, had many more stones raised in the morning and in the afternoon put aboard a sloop I freighted for **Dublin**, to be filled with coals at **Ballycastle**; came off very late called at **Mr. Duncan** after ten and lay there. Having viewed and examined this *wonderful* work of nature, the **Giant's Causeway**, with as much exactness as I could, and made on it some observations: which I sent to the **Royal Society** and they did me the honour to print them in the Philosophical Transactions of the year 1753.[34](javascript:footNote('E750002-001/note034.html'))


On the 10th I returned to **Ballimagarry** and set out for **Coleraine**, and observed the pillars of stone at **Cross Reagh** within 2 miles of ***Coleraine***: I came to that town which is pleasantly situated on a rising ground to the east of the river **Bann**, which here divides the County of **Antrim** from the County of **Londonderry**. This town has large liberties being an Estate with other lands especially **Derry** that was forfeited by the rebellion of the **O'Kanes** in the time of **Queen Elizabeth**, and was granted by **King James the First** to the twelve Companies of **London**, who divided most of the lands between 'em, but some are in common and particularly the salmon fishery. Out of each of twelve Companies two persons are chose, which make what they call in **London** the **Irish Society**, for the *management* of these estates; and most of them are lett at a low rent, and purchased according to the improved value: There is a *little* town on the other side, which is the parish of **Killowen**. There is a handsome town house in ***Coleraine*** built by the Society; and they have a great market every Saturday for Linnen and yarn which is the chief support of the place. I *rode* a mile below ***Coleraine*** to see the salmon fishery which is very great; they catch 'em with what I think is called a seine-net, that goes across the river, and



---

p.39



so they draw in the net. They have caught sometimes, tho' very rarely 2500 in a day; sell 'em here for a penny a pound fresh, but most of 'em are salted. The fish go up in June and July, spawn in August, and those fish are called fry at first; they come down into the sea about March and April, and return from between 5 and ten pounds in weight, and then they are call'd Grants, and are of a lighter colour than what they call salmon, and rather better for present use, not so strong as salmon, but do very well for salting; afterwards they are call'd salmon and sometimes grow to fifty pounds weight, and that as it is imagined in 3 or 4 years: The white salmon trout besides the colour, differs from them in having a double row of teeth. I returned to ***Coleraine*** and went a mile up the river to see the salmon-leap, the river falls down about ten feet in two or three falls, divided by the rocks: They leap up, and very handsome apartments are made for them above with grates to let the water in, and so they can go no further, and are taken up by a hand net; this diversion I saw.


Over this is a pleasant situation, the house of **Mr. Richardson** a member of Parliament, who married **Sir John Eyles** daughter and purchased of the Society that Estate, opposite to it is a pretty Mount call'd **Mount Sandal**, which seemed to be monumental.


On the 11th I set out with **Mr. Fitzgerald** a surveyor of the Revenue, who had accompanied me yesterday, and with whom I had been acquainted formerly in **Munster**. We *rode* four miles to a village pleasantly situated called **Ardeau**, and a mile further came on the strand from a Glyn between the high cliffs through which a rivlet falls into the sea. Even about this part at a distance the rocks appear a *little* like the Causeway, but they consist only of large stones of the 



---

p.40



rocks in strata something in that manner. The cliffs are very high, at top is a stratum of stone, then of rotten rock and then fine white lime stone. From the height I saw the barr of sand at **Coleraine Harbour** which crosses the mouth of the river in such a manner as that no vessel of any burthen can come over it, and this appears by the sea breaking against it. At these cliffs which extend from near ***Coleraine*** to **Magilligan** four or five miles, that chain of mountains end which run through the County of **Londonderry**, **Tyrone** and **Monaghan** and as I take it, end to the south in low hills in the County of **Cavan**: I came to these cliffs to see a grotto much talk'd of, call'd **Solomons Porch**, but it is nothing compared with those *beautiful* grottoes I saw at **Ballimagarry**: It is only a long narrow cave, the entrance of which without doubt was handsomer before it was very much choak'd up with sand as it is at present. I observed here that the flint lay more in strata than in other parts. Near this grotto is a fine cold spring up the cliff, they come and take a hearty draft of the sea water and then when it purges drink of this water plentifully. We came to the west end of the cliff, and I was sufficiently *recompensed* for my dissappointment by the pleasure I had in the ride afterwards first for two miles along the strand and afterwards when I turned to the south through a plain having high cliffy hills to the east with a gentle ascent for some way from the bottom, the rich hay country of ***Magilligan*** to the west makeing out in that point to the north west towards **Greencastle** in *Inishowen* and makes the entrance about two miles broad into that bay which is called the **Lough of Derry**, then the high hills of *Inishowen* cover'd with corn almost to the top: We had a very good road and passed by the house for Lodging of such people resort to this place in order to drink goats whey,



---

p.41



and came into a plain which extends farther to the East; and came to the direct road from **Coleraine** and arrived at *Newtown Limavady* pleasantly situated on the river **Roe**, near which are some seats with good plantations very finely situated. This town consists of one broad Street, and tho' it has a mean appearance, yet it has a great trade in linnen and linnen yarn, insomuch that there are many in the town who can at any time give considerable bills of Exchange on **London**. This is also an estate of the Society in the hands of [*gap: extent: one word*] stopping here to dine my acquaintance **Dr. Bacon Minister of **Ballykeley**** whom I did design to visit, was passing through and came and dined with me, and then accompanied me to *Limavady*. We passed by the river **Roe**, on each side of which are high rocky cliffs with trees growing out of them, and a wood on each side and some *beautiful* cascades of water rush through the rocks; we came to the sight of the old castle of *Limavady*, the fortress of the **O'Kanes**, the ancient Lords of this Country: It has the name of *Limavady* (the dog's leap) from a narrow passage of the river beneath the rocks a *little* higher up, over which a dog may leap, and young men divert themselves by vaulting over it. This estate was in the possession of that Philips and his descendants who was sent over to divide the land beneath the Companies: and they tell a comical story, that he represented that he could no way make the division so as to take in this estate, and that on this they gave it to him for his trouble: But I was informed that he having a grant of the lands of the Convent of ***Coleraine*** exchanged them for these: However that may be, it is an exceeding fine spot of ground: and the Philips's I have had the pleasure to be long acquainted with, are a younger branch of that family, a *cousin* of **Captain Philips** being the person who sold



---

p.42



the estate. There are several Danish forts about this place, some of which the gentlemen have planted with clumps of *firs* which have a *beautiful* effect. There is a lime stone here which is of a slaty kind or runs in thin strata, and I was inform'd that when polished, it is of the dove colour of the **Ardbraccan** Marble, and I then went two miles farther to **Dr. Bacon**'s parsonage house, a good brick edifice with large gardens and a well improved glebe; the house and part of the improvements were built and made by my worthy friend **Dr. Owen Dean of **Clonmacnoise****. This parish of **Ballykelly** consists of about 700 houses, 30 or 40 acres being a great farm, which gives the country a very rich look all being under corn and good pasturage, for they have a shell bank in the **Lough of Derry** which affords fine manure, ten quarters of shells, each of them two barrels being excellent manure for four years, and will produce two crops of barley and two of *oats*. From this I went to the Charter school, very lately open'd for twenty boys and twenty girls founded by the encouragement of the **Earl of **Tyrone****, who gave 64 acres at twenty shillings a year. I went on to the mansion house of this estate, which came to the Earl from **General Hamilton** and belongs to the Society. The house has been lately burnt and is to be rebuilt. **Lord Tyrone** designing to give this estate to his second son: The estate is finely planted, mostly with *firs* and delightfully situated on the Lough. I took leave of **Dr. Bacon** and went on towards **Kerry**, a most pleasant ride: For the Lough growing narrower, the country on the other side appeared in much greater beauty. I observed some very Romantick situations on the rising ground to the south: To the north I saw a small Lough or large pond, with an Island in it, and over it in a most pleasant situation an old Church; 



---

p.43



This is called **Anack**, and is I suppose the same that **Sr. Wm. Petty** calls **Ardnenoymak**. I came to the river *Finn* over which I crossed to **Londonderry**; this river rises out of Lough *Finn* which is very near the western coast: The towns of **Lifford** and **Strabane** are situated on it, opposite to each other, and it is an exceeding fine country all up the river. **Londonderry** is situated on a height over the river which runs on the east and north sides of it; it is something like the situation of **Guildford**, commands a view of a well improved hilly country, of the river and the narrow part of the Lough or rather the mouth of the river: From the situation of two or three Church yards, where there were old Churches, I concluded that the old town of **Derry** was situated on the side of the windmill hill to the north west and perhaps extended down to the valley below, as I was informed it did. When this estate was granted to the Companies, it was on condition that they should *fortify* it, which they did as it now remains in the modern way, but without any subterraneous works, so that on that account and being encompassed with hills it is by no means a strong place, nor can it possibly be made strong: The walk round the ramparts is very pleasant. The Society also built a handsome Townhouse, and a church at the first settlement, which is an *handsome* parish church; something like many Churches in large country towns in **England** with an organ and Gallery at the west end. The Bishops and Deans seats are pointing to the west, on each side of the opening to the Chancel; and the stalls of the Prebends are to be in a line with them. There is a monument in the church of **Mr. Elvinope** of the first inhabitants who died in 1676—102 years old. The bases of the pillars are of oxes heads, which I take to have been an old Roman altar cut in two pieces, brought probably



---

p.44



from **Scotland** or the north of **England**—The present Primate gave a new organ to the church, who was first Dean and then Bishop of this church. There is a foot Barrack in the town for a Regiment, and a Magazine for powder, and an arsenal for their old Canon. They bombarded and played the canon on the town from the windmill hill and from another height to the south west, and it is said that when they began to batter the town, the besieged sent to 'em not to hurt the town which would be their own, and that they need not batter, as the gates were open for them to come in; and it is said that a Colonel of a Regiment offering his service to try, if he could enter the gates which were actually left open; they having notice of it, planted Canon one over another, gave them a terrible fire, sallyed out and cut the whole Regiment to pieces. Below the town about three miles is **Culmorefort** at the mouth of the river, across which a chain was drawn to prevent any relief coming to them, but a ship went against it under full sail, broke the chain, and brought them provisions when they were in great distress. In the church are two of the Standards which the besieged took from the enemy. The Governor is styled Governor of **Culmore** and **Londonderry** and has a *salary* of £600 a year. The commanding officer is Deputy Governor, and when no troops are in it the Mayor, who is the returning officer of Members both for this town and the County, as I was informed. They have here a great market every Wednesday for linnen and flaxen yarn; ***Coleraine***, ***Newtown Limavady*** and **Strabane** having linnen markets on other days of the week for the same purpose, to which the Merchants go round and buy up the linnens and yarn, the latter is sent to **Manchester**.


On the 12th I spent the day with the Bishop, who on visiting him, insisted on my coming to his house,



---

p.45



and sending my horses to his stables; I walked round the ramparts with **Mr. Bernard**, preached, and in the even walked round the town and to **Windmill Hill**.


On the 13th, it rained very hard all the morning, and I set out in the afternoon towards ***Lough Swilly*** to spend the evening with **Dr. Ledwich**; I met him and he went back with me: This Gentleman is married to a niece of the Bishop: About two miles out of the town I saw on a hill **Eloch Castle** with a tower close to it, which appeared to me to be a round tower. This side of the river **Finn** is in the County of **Donegal** and Barony of ***Inishowen***, which Barony takes in from **Birte** inclusively all the Peninsula to the North, and this is in the Diocese of **Derry**. The rest of the County of **Donegal** if I mistake not is in the Diocese of ***Raphoe***. I crossed the river which rises near **Muff** and came to **Fantham** commonly called **Fawn**, very pleasantly situated on ***Lough Swilly*** opposite to Inch Island. This Lough is formed by the river ***Swilly***, and the *tide* which overflows the flat. That river rises near the western coast, and running by **Letterkenny**, a little below it spreads to near two miles in breadth, it then forms a bay to the south, which with the lake below makes a peninsula of what they call **Birte Island**, and a little further on the opposite *shore* a bay is formed by the river which comes from about **Tully**: below this is Inch (Island), a high ground which covers all this bay to the point on which **Rathmullen** stands, where there is a ferry from **Fawn** about a league over, in passing of which last month a boat was oversett, and almost all the people thirteen or fourteen were drowned: it then takes a pretty direct course to the sea, being all the way about two miles broad; and it is a very pleasant lake. I walked out on the banks of it towards the sea,



---

p.46



 
and in the way came to the Church, where there is a very old Cross, an oblong-square stone with a Cross work'd on it in **Bas relief** and many ornaments round it, there was also a Cross before the churchyard. I then came to a well called St. Mary's well; they have a religious regard for it, and it is arch'd over. A little beyond this is a slaty rock, which opens on the *shore* and is very curiously shaped in most of the members of Architecture. I brought away a piece which forms on each side a different *complete* Cornish; this I take to be owing to the rock on which this slate is formed, as it is supposed to be under that head of natural productions, which is formed by incrustation; and it is not at improbable that the several members of Architecture were taken from some such natural formations in the earth. There is an account in History, that **St. Patrick** was at this place, and crossed over to **Rathmullen**.


On the 14th I set out to go round *Inishowen* and came in two miles to the strand, where I saw people at work with wooden shovels, in turning up the sand, as the sea left the strand, and enquiring what they were about, they told me they were catching sand eeles; I observ'd that the moment the wave leaves the sand, they run in the shovel, and turn up the sand and the fish are taken; they are about 4 or 5 inches long, very small for their length, are made like a whiteing and they say are very good: We came to **Burn Cranmer** a village of one Street on a little height over the sea, between two rivlets, one of which gives name to the place, Burn signifying a rivlet. Here **Mr. Vaughan** endeavoured to establish a linnen manufacture and erected buildings for that purpose, but the people breaking, his design came to nothing. A little beyond the village **Mr. Vaughan** has a house pleasantly



---

p.47



situated, with fine fields and plantations about it. I went on towards **Desert Egnè** and passed by the old church, there being a chapel below for divine service. From this place we ascended still higher and found all bog and heath, and passing two or three hills, we crossed a river, which I suppose is that in **Petty** called **Owen Kirk**, and even here the herdsmen who keep the cattle have two or three acres under corn, gained out of the heath and morass. On a height near **Desert Egni** I observed some stones set up an end as in a circle round a single stone, like those in **Cornwall**.


We had high rocky mountains to the north, the barriers against the northern ocean, and going over a high hill, came to the country called from the parish **Clanmany**, a very rough spot of ground, but surprizingly improved, where ever a plough and spade can work: Coming to a rivlet which runs into a bay, I saw a road which leads to **Bigny** a hamlet to the north west of the point made by these hills; we went on and came to the **Strand Strabeghy** (the deceitful Strand) by reason that it is full of holes and difficult to pass. I was too late and was obliged to go all round it, having been directed this way in hopes of getting the strand; for otherwise the short way is directly across the mountain by **Carne**, which road they told me was not very good. The way was on the south and east side of the strand and crossing a rivlet at the east end of it on a bridge, I came into that peninsula which is called **Malin**: The morass to the east is called Monei reilta (the starry bog) for there being several holes in it full of water it appears in a moonshiny night like stars, which may serve as an instance of the significancy of Irish names, which commonly are descriptive of the Place. We went westward near the Strand and turning to the north passed by 



---

p.48



an old church called **Malin Church**, where they say there was a Convent, and going over two hills I came to what they call **Malin Well**, which is the most northern point of **Ireland** in the degree of 55.19. They told me they had not above two hours night in which they could not read in the longest days, and that the sun was excessively hot in summer. This is farther north than ever I was before: Coming near the sea cliff I look'd for the house I was going to, and could see none, but came to a passage down the cliff where I found the house on the beach under the rocks, and enquiring for the well, they showed me a hollow under a rock at the south end of a high small rocky Island, which at low water is a peninsula: Here people bathe with great success, the water being very salt, as not mixed with the fresh. And the Roman Catholicks plunge in with superstitious notions that the water receives some virtue from the Saint (Terence Marialla) who lived in a cave in the rock of the cliff, where poor people lodge, who come for cure. The house for accomodation is exceeding bad. There is a high beach of pebbles which are esteemed the best in **Ireland**, except those of a port to the north of **Green Castle**. They are mostly Jaspar, some jaspar Agates, Cornelian and Agates; and I met with one which seems to be Chalcedony. I had a letter to **Mr. Harvey** within a mile of the wells, which I sent to him, and soon followed, and met with a most hospitable reception: they presented me with several curious pebbles and a very curious crab dryed, the legs of which are mark'd with winding lines that are white; and from the variegated colour 'tis supposed that it has obtained the name of the Highlander; they are exceeding scarce, and it may be they do not meet with one in seven years. I observ'd a fine square head of land to the west called **Malin Arde**, which



---

p.49



is under corn and appears very *beautiful*, being a peninsula: To the east are very high rocks, where there are eagles which frequently carry off lambs; and a man being let down by ropes to the nest of one of them, in which he found eggs, he met also with a salmon and a Breme; the former swimming in shallow water might easily be taken, but the Breme keeping deep in the sea must have been supposed to have been thrown up. The fishermen observe an extraordinary thing here, that if they find a stone in the cod fish that it is a certain sign of an approaching storm, and it is supposed they swallow it in order to sink themselves to the bottom of the sea, that they may not be dashed against the rocks, as they frequently are, and are taken up dead sometimes in great numbers; It is supposed also that they have a power of disgorging the stone.


On the 15th **Mr. Harvey** sent his man with me to ***Culdaff***: passing the bridge which I came over to this country. I observed a fine habitation over the sea to the north east, **Mr. Donorty**'s called **Catridge**. In five miles we came to ***Culdaff***, where there is a church, and Mrs. Young has a good house with a plantation of trees about it. We soon passed by **Redfort** the house of **Mr. Elwood** Minister of the place, which probably had its name from a red vein of soil about this place; I observed an Island at the north east point and saw **Clonkan Church** to the south west, which is the Parish Church of ***Malin***: We had an unpleasant road across the mountains to the south east, and came to the rivlet, which runs along a valley that meets another which ends in the bay of ***Clanmany***, that I had pass'd and going eastward three miles, came to the **Lough of Derry** near **Moville Parish** where **Mr. O'Neal** has a house pleasantly situated, and I went two miles to the north along the *shore* to **Green Castle** where I dined. I went to see the



---

p.50



fine old Castle, built on a rock, the entrance is defended by two towers, where the chief apartments were; the north end is also defended by towers and it is a strong and delightful situation, it was the *strength* of the O'Donorty's, the last of which family going to **London** to **Queen Eliza.** was Knighted; but afterwards being in rebellion, his estate which was all ***Inishowen*** was forfeited, most part of which now belongs to the **Earl of ***Donegal*****; this Castle may have its name from the green fire stone it is built of: A quarter of a mile from it is a chapel which seemed to have been built with pinnacles and with large windows, and is very uncommon in this country. This is the passage of two miles from the opposite point of **Magilligan**, near which I had passed before from ***Coleraine***. I set out southward and came in five miles to **Redcastle**, where **Mr. Carew** has a very *handsome* house near the sea. I went two miles further to **White Castle** and two to **Turn**, near which the direct road from ***Malin*** comes in, which it is said is through a most pleasant vale, in which I suppose the river runs, that is placed in the large map of **Ireland** near **White Castle**. I came five miles to **Muff**, where the poor Inns were all full, being the market day of **Derry**, from which it is five miles distant. So I sent to **Mr. Hart** half a mile from the town, a pleasant situation near the **Lough of Derry**, brother of **Alderman Hart**, who has been Lord Mayor of **Dublin**,[35](javascript:footNote('E750002-001/note035.html')) who sent me a welcome and his son received me, as the father was gone to repose.


On the 16th **Mr. Hart** treated me with great civility, invited me to spend the day, and sent his son **Captain Hart**


---

p.51



to show me the neat Chapel of **Muff**, and a pleasant view from a hill, from which among other things I saw **Culmore Church**: He accompanied me with great civility as far as the strand which crosses to **Birt**. I crossed that strand the southern side of which is bad, enter'd on it, two miles from **Fatham** or **Fawn** **Dr. Ledwich**es. On the other side of the Strand is a large Meeting house to which there was a great concourse of people from all parts being the Fast day before the Sacrament, and they had a sermon, to which they come fasting and afterwards take their repast. I went on three miles and passed by **Mr. Forwood**'s, having had a view of the fine hill of **Birte** a peninsula called an Island, on the top of which are the remains of an old round Tower; this is part of **Mr. Forwood**'s estate: a *little* mile further brought us to **Newtown Cunningham**, the estate of **Mr. Hamilton**, where his brother the Curate now lives, they are sons of **Archdeacon Hamilton**, who formerly lived here, he is a very fine old Gentleman between 80 and 90, I dined here and came to the top of a high hill, by an easy ascent, from which there was a most glorious view of all **Lough Swilly** seen behind three or four heads of land which lock in and divide it in a most beautiful manner; to the south west we had a view up the river **Swilly** beyond **Letterkenny**, a very fine vale to the south, the Country of **Manor Cunningham** and some adjacent villages, as an Amphitheater, encompassed with hills well improved, rising gently over one another to a considerable height, on the other side of which is ***Raphoe***. I came to **Manor Cunningham** three miles from **Newtown**. It is a large village; I went a *little* beyond it to the Charter School of **Ray** founded by **Dr. Foster late Bishop of ***Raphoe***** on 22 acres of land given by **John Leslie Esqr.** at a small rent, and 2 in perpetuity without rent, for 20 boys and 20 girls. I went on five miles westward to **Letterkenny**; nothing can 



---

p.52



be imagined more *beautiful* than the winding of the **Swilly** and several streams running into it, all at that time full with the *tide*: The view of **Letterkenny** of **Mr. Spaw**'s house beyond it and opposite to it **Captain Chambers** and above it **Major Stafford**'s page to **King James the 2d.**, who has been some time dead, add greatly to the beauty of the prospect.[36](javascript:footNote('E750002-001/note036.html'))


This high ground on each side the river being most like the fine views on the **Aire** in **Yorkshire**. At **Newtown Cunningham** I came into the Barony of **Raphoe** and the Diocese of that name; the Barony of *Inishowen* being in the Diocese of **Derry**. I was informed that the place of residence of the Bishop of Derry was first at **Newtownstewart** and then at **Marra**, they had no Episcopal house at **Derry**, till Bishop King purchased the present house of the Normans by the lease of **Fawn** which they now enjoy. Nor could I be certainly informed that there was ever any Cathedral Church at **Derry**, and the present seems not to be properly a Cathedral, but only made use of by the Bishop and Chapter, the parish belonging to the Deanery, as most of the parishes do near Derry.—**Letterkenny** seems to have its name, as some other places from being the grant or letter to one of the name of Kenny, so in **Boyhlagh Letter**—McWard was probably granted by patent or Letter it may be from the head of a clan to a family of the name of **McWard**—**Letterkenny** is more *beautiful* in prospect than when one enters it, consisting of one Street meanly built, with gardens behind the houses: and there are remains of an old Square Castle. The chief trade of the town consists of shops to furnish the country to the north, and a market for oats and Barley, wheat, some yarn and flax.


We here 



---

p.53



enter'd the Barony of **Kilmacrenan**, and I was detained all the morning of the 17th by rain. In the afternoon I cross'd for five miles over two hills excessive bad roads to **Kilmacrenan**, on the road I saw a new kind of round fort, common here, made of loose stones well put together*:* the walls are ten feet thick and about eight high encompassed with a fosse and about seventeen yards in Diameter within. **Kilmacrenan** is a very poor village on a river called **Gannon**, which runs through rocks beautifully adorned with trees; and all over the Country there is an agreeable variety of Hills, Rocks, Wood and Cornfields. The church is thought to be part of an old Convent of Minorets founded by **O'Donnel**; over the door is a relief of a mitred head. We here came to the fine new road which is making from **Letterkenny** to the north west point of this Barony chiefly carried on under the direction of **Mr. Wray** of ***Ards***: It leads over a very high hill, on which there is a fine lake call'd **Lough Farne** which is about a mile long and a quarter of a mile broad, the new road being carried on three sides of it, and the hills rise above it all round being very high to the south, and on this side is the extraordinary old road, which seems to have been very difficult as well as *frightful* to the traveller, being over a precipice with the deep lake directly under it: To the right of the passage down to **Doe** is a small lake on the side of the hill into which this empties itself and from that the river runs down into the sea. To the East coming up to this lake, I saw another about a mile in circumference it is called **Lough Castle Culane**. Going up the low hills to the north of the lake, I was extremely *surprised* at the view of the Country, consisting below of a great number of small Loughs, in a healthy country and some spots of corn to the north and east, two bays winding in and forming several strands for some miles, many 



---

p.54



of them appearing when the *tide* is in like serpentine rivers, not without many spots of corn and wood. The countries here are distinguished by general names, probably the old names of the clans, by which they are now called and also by the names of the parishes which have generally the same bounds. As the country to the East comprehending the parish of **Clandevadoge** is called *Fanad*, a parish finely bounded by the sea, by *Lough Swilly* by the bays and Strands, which are formed by the sea, which comes in at an opening between this and a division to the westward, call'd ***Rosguill*** named by the **Lord Boyne** whose estate it was **Rosapenna** and now belongs to **Mr. Clements**. This opening is mark'd in the map of **Ireland** by the name of the river **Mullroy**, and by a river in **Petty**'s map, but neither of them show the large bays and strands which are formed by this *inlet*. **Dr. Bedford** lives in that parish, which tho' hilly is all under corn, and it is a most *delightful* retirement. This clergyman is greatly regarded by the people, to whom he is a father, and there being plenty of corn, he has put them in a way of exporting it, by freighting a ship and advises them in everything for their interest. **Rosaquill** is another head of land, the parish if I mistake not, is called **Carrigart** the church of which is just opposite to Rosapenna house. The next division is **Doe**, divided from this by another bay, which is called **Ship haven**, this is the parish of ***Claudahurky***; taking in **Ards** **Mr. Wray**'s and **Horn Head** Captain Stewart's. The fourth part is **Clohaheny**, which takes in all the country to the west, as far as that which is called **the Rosses**, and has in it the Parishes of **Ray** and **Tullaghobegly**, of all which I shall be more particular, when I passe thro' them as I determine on this most romantick prospect of these countries. I returned to **Letterkenny**.


On the 18th I set out for that country by a *different* way,



---

p.55



going towards **Tully** in a road about half a mile distant from **Lough Swilly** and passed by a fort of the same kind as the other called **Lis Ballyart**, the walls of which are twelve feet thick, the diameter within twenty two paces, the fossee fourteen and the rampart is eight broad; I observed that the houses are built with sods, supported within by a wooden frame, which the poor people sometimes leave with their effects, when the collector of the hearth money approaches: The *roofs* indeed of all their cabins are built with stone and clay, are fixt on wooden posts within the wall, which is not strong enough to support the roof. I came to **Tully** consisting only of a few poor scatter'd houses and an Iron work, there being Iron mines at **Lismonokan**, about a mile west of **Letterkenny**, and at **Pluck** two miles from it. We had seen **Rathmellan** a mile to the East a small town at the south west corner of the bay, on which **Rathmellan** stands opposite to **Fawn** where **Dr. Ledwich** lives. I was informed that there are remains of an old Convent here called **Kilodonogh** which is probably the Convent of **Franciscans** called by **Ware** **Kilodonel**. We went on and crossed the river **Gannon** which runs through **Kilmacrenan**, and between the same *beautiful* rocks and trees, which are seen all over the country, especially about **Mr. Grove**'s at **Balymoyle** to the south, with an agreeable variety of corn fields. Over this seat is a fort of the same kind as the others called **Lis Brunhal**, and in the country below are four small Loughs. A little beyond **Tully** to the west is **Lough Ferne** above a mile long, and winding round the north end of it there are at that end two or three small Islands in it. In two or three miles from **Tully** we came to a village call'd **Berenenalagah**: From this place for three miles to **Cranford** the seat of **Mrs. Cunningham** the road was most pleasant, being in the sight of a wood and by the edge of it. We 



---

p.56



descended towards it and came to **Brinian Bay**, a strand, which winds round from the great strand to the west of **Clandevadoge**, and is formed by the inlet of the sea between ***Rosguill*** and ***Fanad***: we crossed the river which falls into it at the west end, and went along this Strand at the edge of a wood which covers the hill, and from this place between woods and rocks and other strands two computed miles to **Cranford** **Mrs. Cunningham**'s, a most exceeding pleasant ride: Afterwards we *rode* by the great Strand, the bay appearing like a large Lake and saw **Rosurkils** and near it the Church of **Clandevadoge**, the country to the west being rough; we passed by several *little* strands, saw some ruined salt pans and works for *boiling* the salt, and came near the Church of **Carrigart**, which is the parish in the division of **Rosapenna** or ***Rosguill***; and passing the end of the strand on which Rosapenna house stands, I dined on the west side of it: Here I observed a long sort of sea weed, much like a rush peeled for lights and pretty long, the call it Raff, I found it five or six yards long and growing to a stone: They say, it is sometimes twenty yards long and that it twines round people in the water to such a degree, that it often occasions drowning: We went on mostly through sands banks, which are rabbit warrens and came near the strand, which from the opening to the west of ***Rosguill*** forms a bay, that extends first to the south and then to the west beyond the **Castle of Doe**. We came opposite to **Ards** **Mr. Wray**'s seat a fine plantation and afterwards to the **Castle of Doe**, to which we might have crossed, if the *tide* had been out; but were obliged to go above a mile farther, and came into the new road from **Letterkenny** and **Salt Hill** and turned to the north. I here observed a stone, which appear'd like a slaty grey marble, but they told me that it is not a lime stone, it is formed



---

p.57



like the slate at **Fawn** in the form of several members of Architecture. We passed a river on a bridge which rises from **Lough Vah**, a Lake in a very Romantick vale, called **Glysivah** which is to the south of the mountain called **Muckish** judged to be one of the highest in **Ireland**. Coming near the west end of the Strand, on which the **Castle of Doe** is built, I saw a *beautiful* fall of water which descends from **Lough Meur**; and going northward I passed by a chapel of ease to **Clonharkurky** church, and a little beyond it a remarkable fort on a high rocky hill, of the same kind as the other walled forts, which is called **Lismore** (the great fort) and passing over a bridge observed a rivlet falling in *beautiful* Maeanders into the sea. Half a mile farther we came to the new Church which is now building for this Parish, with rustick Quoin stones of grey marble, which they have near **Dunfanahy**, and the upper members of a basement round the church, the design is a Venetian window at the end, and four windows on the south side, the frames of, which are to be of the same marble: It is a very fine situation, and the ornamental part is very much to the honour of the Gentleman who is to be at the *expense* of it, **Dr. Obins**, late fellow of **Trinity College**, the minister of this place. We descended down to **Jeshiah Lough**, about two miles in circumference with a small Island in the middle, but it is one of the finest Lakes I ever beheld; the beauty of it chiefly consists in the hills, that are to the south side of it which rise gently from the middle of one side of the Lake and are covered with wood, on each side of which the ground is bolder and affords a most agreeable variety of rock and wood. We then soon came on the strand and turning westward, arrived in less than a mile at a very poor small town called **Dunfanahy** on a small creek in this great Bay, 



---

p.58



which is made by an inlet of the sea to the East of **Horn Head**; I found I could get no sort of accommodation here, and so sent a note to **Mr. Stewart** at the west end of the bay, who returned a Welcome in answer; I went and took up my quarters at his house. As soon as I was set down to supper a messenger came to me from **Mr. Wray** six miles with a letter in which he informed me, that hearing I had passed and knowing there was no accommodation at the place, he desired me to come the next day to his house and that on Monday he would ride with me and show me the curiosities of the Country.


On the 19th I *rode* with the family to Church and preached, met **Mr. Wray** and family there, who came and dined at **Mr. Stewart**'s. This Gentleman's house is situated on the side of the hill over the bay, which extends to the north east and makes **Horn Head**; the house is *fortified* in some manner, and stood a siege against a privateer's crew in the wars at the beginning of this century; there is a bay on the main sea to the north west, called **Trahemore** (the great Strand) between that and the other strand is a great bank and hillocks of sand, which gain on the ground to the east, this and some ground bordering on it, make a very large warren belong to **Mr. Stewart**, of which he makes about £500 a year, killing commonly 14 or 1500 dozen in a year, the skins of which he sells for about nine shillings a dozen, and the flesh for six pence a dozen. In the evening we *rode* across it to the bay, on each side of which the rocks are very fine, the beach consists of large pebbles, and finding ridges of them farther from the sea under the sand, they conclude that the sea looses here. We went to the north west side of the bay to the sea cliffs, to see that great curiosity **Mac Suines Gun**. The cliffs about 100 feet high form a *little* triangular creek



---

p.59



at the bottom of which is a hole in the rock like a large arch, it may be fifty feet wide, this may go in about thirty feet, and over it is an opening which is irregular, but at the top forms a triangle it may be fifteen feet on one side and thirty on the two others; on the arch mentioned on the outside we saw the waves roll in, and filling the hole, they tumbled back with a great noise, 'tho it was a very fine calm evening; but in stormy weather when the waves are drove in with great violence, and one succeeding another very quick, the water is forced up to the top with the very stones, and sometimes with such force that it forms a jetteau in a large body rising very high, some said, a height hardly to be believed, but probably an hundred feet, the wind blowing the water with great force over the land, so as that there is no standing against it, not only on account of the water, but likewise of the stones which it throws up. From this I went over the stony ground, in which the stones are laid along in rows in many places as for bounds, but in some places so near to one another, that I concluded many of them were pickt up by the herdsmen to clear the ground. The rocks at **Horn Head** are very high, and it is a curious sight to see the birds when they are breeding; being much like that of the **Isle of Wight**; they are of three sorts, the Puffin about as big as a partridge, called also Coulterneb, they have a parrot's bill: the Razor bill or Auk, as big as a Pheasant, with a parrot bill likewise: the Furun with a sharpe picked bill; on the strands they have a seapye with a red bill and legs, which lays in the rocks on the *shore* and does not go into the sea, and I was informed that Curlieus lay in the rocks of inland mountains: Passing through the water over a strand, I was made to observe that the birds follow'd the horses, and dived down where 'ere



---

p.60



they had trod, which is to take up the sandeeles, and other small fish that are pressed out of the sand by the feet of the horses. I went to see the marble quarry near **Dunfanahy**, it is a white marble with some *bluish* veins, the bed may be about six or seven feet thick, in which there is one layer near three feet thick, of much better marble than the rest: It *lies* in a large patch from the mountain to the sea, where a stream spreads itself from the mountain; by the look of it and by the manner in which the bed *lies*, I concluded it to be an Alabaster made by the running of the water which brings the fine particles of the stone that unite and form the Alabaster as in the Stalactites; asking the quarriers whether it was an Alabaster, they said it was not, but a lime stone, which I imputed to their ignorance, if so be that Alabaster will burn to lime, as if I mistake not, it does. Going from church in the morning I observed a circumstance, which added to the Romantic view of the mountains to the south: In the side of one of them a sort of Amphitheatre is formed in the rock; here I saw several hundred people spread all over that plain spot and the priest celebrating Mass under the rock, on an altar made of loose stones, and tho' it was half a mile distant, I observed his Pontifical vestment with a black cross on it; for in all this country for sixty miles west and south as far as **Connaught**, they celebrate in the open air, in the fields or on the mountains; the Papists being so few and poor, that they will not be at the *expense* of a public building.


On the 20th I went with this family by invitation five or six miles to the south-east to **Mr. Wray**'s and saw in the way **Doe Castle**, it is a fine square turret of five stories and near sixty feet high, it is encompassed with an inner Wall and Turrets and with a second almost all round. This 



---

p.61



was the strength of the **MacSwines**, who were masters of this Country; and after the wars the head of them being offered part of his lands, as they say, refused them, unless he had all, and the books being shut he lost all. Near this Castle are some small remains of a Convent of Minorites, which must be that Monastery called by the Historians **Baley MacSuine** near **Doe**: They also mention another called **Beleaghan**, which I could not hear of, no more than of ***Muckish Abbey*** put down in the Maps. To the north of this, is what they call the Marble rock, it is a bad white, with large spots of a sort of Ash-colour: what they have raised does not polish well, but if they dug deeper, they might probably find a better vein; it is a very uncommon marble. I went on to **Mr. Wray**'s called ***Ards***, on a rising ground on the north side of the bay, which is formed by an inlet of the sea, half a mile to the east of it, the gardens are on the descent to the bay, that forms a *beautiful* basin before the house, which is well shelter'd not only by the hills to the north, but by the fine plantations about it, and from those hills there is a *beautiful* prospect of the sea, and of the Country and the bays that are near, here I saw Melons ripe, and fruit in great perfection. This gentleman is married to a daughter of **Archdeacon Hamilton** mentioned before who in the troubles went to Magdalen College in Oxford, and is above eighty years old with all his senses and understanding in great perfection: To the publick spirit and activity of **Mr. Wray** those fine roads are owing, which are made over Lough Salt Mountain and in other parts, laid out so as to be finished in about seven years: by allotting such a measure of road yearly to each house, according to the value of the land they hold: they are twenty one feet broad, with a margin on each side of green turf about



---

p.62



two feet wide; they are first raised with the earth that is thrown up to make a fossee on each side, then they lay a coat of broken quarry stone; on that some earth and then gravel at top. These roads considering the cheapness of carriage on *little* truckles drawn by one horse, almost answer the end of water carriage, for they will draw a hogshead of wine, or anything not exceeding 600 lb. weight and one man will attend three or four of them; they commonly feed their horses on the grass they find in the road, so that they will carry a hundred and fifty miles for about three shillings a hundred.


On the 21st I took leave and with **Mr. Stewart**'s family went three miles beyond his house to the west to **Ray** to the house of **Mr. Hartley** the Minister who had invited us to dine with him. **Mr. Babington** who met us on the road, went with me in the way to see the marble quarry. At the Church at **Ray** is a very curious old Cross broken in pieces. I here met young **Mr. Orphilts** a very accomplished young Gentleman, married to another daughter of **Archdeacon Hamilton**, he carried me half a mile to his father's house, where I lay, walking out to the sea side, they here thatch with a course grass called bent, with which also they make cords.


On the 22d. **Mr. Orphilts** went with me a mile to **Mr. MacSuine**'s, where I set out with two hired men and horses to carry my provisions, as well as to show me the way; there are no more gentlemen to the west nor to the south for near thirty miles, till one comes to **Eniskeel**: **Mr. Orphilt** accompanied me some way farther, but whilst I was waiting in the last place, a large Eagle flew directly over the yard and the fowl came all running towards us, and making a noise, from which I judged that they were alarmed by the noise of the eagle's wings when he flies.




---

p.63


They have in these parts two doors to their *cabins*, keeping one only open on the side that is not expos'd to the wind, as they have no light commonly, but by the door. In all these parts the drinking of Whisky very much prevails, they call it in Irish Usquebaugh, which is I suppose the general name for Spirits, as Arraki is in the east, so the eastern Spirit is called Arrack, as the spirit for which **Ireland** is famous is called Usquebaugh. Whiskey is made of Barley, they also distill it from water press'd from potatoes after they are *boiled* to a mash, which they ferment with barme; they have a notion here that it is the wholsomest of spirits; tho' I have reason to think it is the worst of that kind; and has tended very much to debauch and corrupt the common people. We passed by a hamlet called **Ballinascagh**, where there is a very large stone of Granite so equally poised, that a man putting his shoulder to it, moves it very easily, after the manner of the rocking stones in ***Cornwall***. I here saw the machine for twisting straw ropes, which has been thought to have been one of the Egyptian Hieroglyphics, in honour of the person who invented it, it is in this shape the straw is fixed to the top, it is held at the bottom and turn'd round there being a swivel at p. this instrument they call in Irish Corhougan.


Going on farther I saw stones set up an end, seeming to be of that kind of monument which is seen in **Cornwall** and **Wales** call'd the Cromlech, of a large stone laid on three or four stones and are called ——. For three miles we went through a very rough road over the hill called **Crocheniniary**, having Morass to the south full of *little* loughs and a rivlet to the west, which falls into the sea at **Clanashour Bay** where there is a village. I observed at the top of the hill we passed some of the Grey Granite 



---

p.64



extending from east to west mostly in two lines, which probably is the top of some bed of Granite, there being no other pieces about the hill, which rises much higher to the north: A mile further we saw a bay called **Olignio**, where there were some Cottages bordering on the bog, which we passed with some difficulty; being now come to the western *shore*; and having turn'd our faces to the south, we had another hill to the north called **Culsolich**, which is the hill that makes the north west point, we came to **Bolileneu**, where I sat down by a river and dined, having passed these bogs; some poor came about me and I bless God Almighty that I had to feed them! The Irish Grace was said. Raghnakoude nrahan, agles da jesk ring Dieu erna Koub Mille; diring Dieu rockown re dering ren en ring er argoud, agus er argoron.[37](javascript:footNote('E750002-001/note037.html')) In English thus, God blessed the five loaves and the two fishes and divided them among the five thousand; may the blessing of the Great King who made this distribution descend on us and our provision.


We went on half a mile to **Glashau**, here I observed a sort of ash coloured Granite, of which all the rocks are to the sea; and then travelled between sandy banks a quarter of a mile to Carig and about two miles to **Logniau** and a mile further to **Makery Clogher**, in half a mile came to a river and in a mile to **Nickart Wullery**, where I proposed to cross over the river **Slady** on the strand in a Curragh and to swim my horses. A Curragh is a very extraordinary boat, about seven feet long and three feet and a half wide, and about two feet and a half deep in this shape it is made of strong wicker, covered over with the raw hide of a horse or bullock. It is set up an end on the frame which is continued on each side as at .a .a in order to dry it when



---

p.65



they take it out of the water, as they always do; I saw a woman carrying one to a Lough and two children following her, she paddled it along at the head, sometimes on one side, sometimes on the other, and when a puff of wind came she held up her gown for a sail. We cried out to her Brahaskin (well done) and she answered Maugiliore (well enough). The horse that swims at the end of these is held with a bridle by one in the boat. The *tide* was come in too far so I took my lodging in a *cabin* at the village, where the farmer told me I was the first that ever eat of his own provision in his house.


On the 23d. I set forward and in less than a mile passed over the river **Slady** on a bridge, which runs beautifully down the rocks and here they have a salmon fishery, we now entered into the Country called **the Rosses**, or as I suppose the heads, *probably an old word derived from the Arabick Ross* a head or cape of Land, and it is the parish of **Temple Croan**, here the rocks are of the same red Granite as that of Egypt, of which the Obelisks are made. We then went a mile and half and came to a Strand called **Trakern Bay**, and in a mile more to **Molah Durack** and in two miles to strand **Bernientileh**, having all the way a most agreeable variety of Strand, rocks and *little* Loughs and views of Strands or Bays, with rocky Islands in them. We had also Islands in the seas all along on this coast—a *little* farther south is **Colain**, then **Ennisboy**, farther south **Enisurnak** and then **Enniskoul** left dry by the *tide*, here I was to have crossed over: The mountains from **Doe** westward are **Muckish**, **Iacca**, **Altam**, behind which is ***Glenveagh***, then **Mulock**, then ***Errigal***, a most *beautiful* pointed mountain the highest of all, as some think, and the top when seen above some hills appeared like the great Pyramid: Then ***Slieve Snaghta*** (snow mountain): And the low chain of hills running



---

p.66



west of these and to the south are called **Carantricanah**. Having passed the Strand we came to **Kedu**, and had in our view to the left a long *beautiful* Lough called **Wellan**, appearing like a serpentine river. We passed by **Temple Crowan Church**, which is a mean low, thatched building; this Living of £80 a year is in dispute and is lapsed to the Crown, and is most desolate and I may say uninhabited part in the world. We came on to a boggy part of the Country, and having past some difficult places, the guide desired me to walk a short way to **Glasbegginmill** and went in search of a good pass but could not find any and was obliged to come back and go in the *common* way near a rivlet which turns that Mill, which I passed with great difficulty on foot; I saw they were obliged to come to it; the Miller came to meet us, and I asked him if there was a door or a board to lay for the horses to pass; he said there was not; but the guide went to the mill and brought a board and an Oxes skin; so laying sods and heath the skin and the board on that, and sods on each side of it to keep the horses from slipping in, we cross'd on them safely, and passing on still over bog, when we came to any narrow passes, the horses leap'd them; And taking another guide we came to **Letter McWard**, a hamlet of three or four houses. I observed they chose to go on the edges of hanging grounds over rivlets or low places which are driest. We had this morning the **Isle of Arran** to the west, which is about two miles long and a mile broad, and some other Isles south of it, and passed the rivlet called **Cloghnehich** (The grey stone) on which there is held a yearly fair for Cattle: Before we came to **Letter McWard**, we went two miles on a Strand called **Trianah** into which falls the river **Goninesh**. And when we had pass'd over the hill of 



---

p.67


**Letter McWard** we came to a strand and the river **Gubarrow**, which is crossed in a Curragh and the horses are led in and swim across. This river rises to the North east and directly west is a high hill, on the side of which is ***Lough Finn***, out of this lake the river *Finn* rises: Then there is a chain of hills between that and the **Swilly**: The mountain to the north of **Gubarrow** is called **Dirliaconnel**, then going north, follow **Croiveh**, **Craheh**, **Carvan Trianch** and **Bloody Farrel**. This country being entirely unknown I have been the more particular in relation to it, for my own satisfaction. From the Ferry I went westward along the Strand, and passed under an old Church called **Kilkenny**, a chapel of Ease to ***Inniskeel"***, a mile farther I came to a village called **Balyaristan**: and having a letter to **Mr. Stewart** the Minister of **Inniskeel** I came in two miles to his house, the first half on the strand and the remainder within the sand banks; opposite to it is a small Island called **Keel** or **Inniskeel** (Island Red) in which are two churches, about one the Protestants bury, and at the other the Papists; at low water they ride over to it. This Parish extends for near thirty miles from the western point as far as ***Lough Finn***; near that Lough there is a road from it to **Strabane**; and all that country on the ***Finn*** and the **Swilly**, is called the ***Lagan***. There is a voluntary division made of the parish for this turn, there being a chapel to the west served by a clergyman who has half the profits.


On the 24th I set out in the afternoon and going along the strand for a mile, ascended the hill to the west and came to **Lough Kildairar**, and observed an Island in it, with a building on it; we then came to ***Loughros More Bay***, and to a bridge over the river **Oneck**, where there is a stone set up an end nine feet high, four broad and three thick, they call it **Fin McCoue**'s shoulder 



---

p.68



stone, with which he used to divert himself by throwing it like a Quoit. We then went over the ***Ardara*** on a bridge and soon had ***Loughros Beg Bay*** to the west. There are three chains of mountains which run the length of the head of land, one on the Northern *shore*, another on the southern, and the third running along the middle of the country are called the mountains of **Boylagh**, from the half barony of that name; the other half barony of **Banagh** being to the south, we came to **Mugurry** on the entrance between the mountain in the middle, and passing several streams came to ***Mulmusog Mountains*** mountains which are part in **Boylagh** and part in **Banagh** and at length to the long bog called **Stragate Mountain**, over which there is a very good road made to a village call'd **Carrignabouhil** on a rivlet called **Bougoshton** that falls into the ***Bay of Killybegs***, at which place we arrived a very poor town or rather village, situated on the west side of the bay, about a mile from the sea, and from the north end of the bay; it is esteemed one of the finest harbours in **Ireland**: There is a narrow entrance to it, on the inside of which is an old Castle, and over it the foundations of another, call'd **Cat-Castle**. At the lower Castle the East India ships when they came in during ***Queen Anne**'s* war, planted a battery and another on the opposite side, and there is a height over the town, where they say, there was a Castle: There are a very few fishing boats here; but ships belonging to **Ballyshannon** Merchants come here and unload, having Warehouses for that purpose; ***Ballyshannon*** being a bad harbour, by reason of a barr which hinders any ship of Burthen from coming into a safe place. To the west there is an open bay call'd **Ti** or **Tilcers**, where there is a curious cave, and beyond it at **Mount Sleavebag** there is a bed of Marble.


On the 25th, 



---

p.69



I set out for ***Donegal***: In three miles we came to **Dinhonely** and a mile farther to **Brocla's Bay**, on which there is a Castle; two streams fall into the bay of ***Bay of Killybegs*** and three into this. We had St. John's point to the south, where there is a hole like that called MacSuines Gun: There is also a large cave with a table in it, cut in the rock, which they call **Temple Sugan**. Three miles farther we came to **Inver**, another large bay, where I observed a kind of granite lying loose in the bay of a light liver colour with large grains in it, of a kind of sparr. The country to the north is mostly *beautiful* and well improved and particularly three miles farther about **Mount Charles** on the Bay into which the river of ***Donegal*** falls: Here the country consists of small hills all covered with herbage or corn, and some wood to add to the beauty of it. The land running sometimes into the bay in such *little* hills, makes the view from **Mount Charles** which is almost all covered with wood one of the most delightful I ever saw. Three miles more brought us to ***Donegal*** which stands on the east side of the river **Eask** that rises out of a Lough of that name three or four miles to the north west of the town. It is but a poor small town built almost all round a sort of triangular Green: There is an old Castle which had been improved into a good house with the help of some addition to it, particularly there is in it, a very well designed chimney piece in the style of Inigo Jones, but not executed in the best manner: It was the Castle of the **O'Donnels** formerly Lords of this Country, and now belongs to **Sir Arthur Gore**; whose Grandfather lived in it. A quarter of a mile out of the town are the remains of an old Convent of Minorites, said to be founded by **Odo sirnamed Rufus O'Donnel** in 1473 and that there was a good Library in it. The *cloister* consists of small



---

p.70



arches, supported by couplets of pillars on a basement: in one part are two narrow passages one over another, about four feet wide, ten long and seven high, which seem to be places for *depositing* valuable effects in time of danger; the upper one is covered with stones laid along on the beams of stone that cross it, and the lower one with stones laid across on the walls, both exactly after the Egyptian manner; and in a building over it are plain marks of a regular Roman pediment tho' there had been some other building raised against it, which made me conclude that this was the remains of some very ancient building either converted into a Convent, or it may be new founded by **O'Donnel**. ***Donegal*** is a Corporation consisting chiefly if not altogether of out Burgesses. There is a way when the *tide* is out to **Balintra** five miles off, but I went the inland way and struck out of the high road to the south east to go to the Caves called the ***Pullans*** near **Colonel Hamilton**'s house a mile from **Balintra**, by which place I ought to have come instead of going chiefly along by a rivlet a very bad road for three miles: These caves are large and a rivlet runs at the bottom of them, goes under ground and afterwards comes out, but they were so overflowed that I could not go in. **Colonel Hamilton**'s is a fine plantation and a well improved estate. I came through **Balintra**, a very poor town, and in five miles more came by a very fine road to ***Ballyshannon***, where **Mr. Conelly** being to make some short stay there was such a concourse of people, that the Inns were full; So I sent to **Mr. O'Neal the Minister** to accommodate me with a bed, which he did with great politeness. **Ballyshannon** is most delightfully situated near the mouth of the **Erne**, on the north side of it on a bold rising ground, this river rises in the County of [*gap: extent: one word*] and forms that *beautiful*


---

p.71



lake which is known by the name of **Lough Erne**, and perhaps exceeds any in the world for the beauty of Land round it, and of the Islands in it covered with wood. The mouth of this river is blocked up not only by sand, but by a ridge of rocks that cross it, above which there is a fine basin; above that is a shelf of rocks crossing the river which forms most *beautiful* cascades of water, that fall about fifteen feet which has a fine effect from the height under the church, as well as from the other side: and here is a famous salmon leap.


On the 26th I walk'd to see it and met **Mr. Conolly**, who was pleased to take knowledge of me, and to desire me to *join*—and to go and dine with him at **Colonel Foliot**'s: We went to Church, where a dependent of **Mr. Conolly**'s preached before him, after church **Colonel Foliot** invited me to dine with him, and introduced me to **Lord Adam Gordon** brother to the Duke of Gordon, an officer of his Regiment, who is with him at his country house, and his Lordship took me with him in the Colonel's chaise; and we dined a large company at **Colonel Foliot**'s, who brought me back near two miles in his Chaise.


On the 27th **Mr. Oneal** *rode* with me to **Badeke** three miles where there is a fine hanging ground, wood, Islands and several cascades, altogether making a most *beautiful* appearance; we *rode* four miles further opposite to **Sir James Calwell**'s house, this gentleman has spent most of his time abroad, was **Aid de camp** in the Austrian service to **General Odonnel**, whose father dined with us yesterday, and they say is the head of that family descended from the Earl of ***Tyrconnell*** and tho' he has only leases, yet he is the head of the Roman Catholicks in this country, and has a great interest, is a sensible man, and well vested in the Irish History, both written and traditional: and it is said that **Sir James**


---

p.72



 
being agreeable to the Empress was made a Count of the Empire, which title he does not take upon him. **Lough Erne** and the Islands appear very beautiful from this Hill, there being many considerable seats on it as at ***Belturbet*** Lord Lansborough's, Castle Hume, the seat of Loftus Hume, where there is a black marble with a brown cast and so not an agreeable black, but polishes pretty well; and many others. The Lough is divided into two parts the communication being by a narrow channel, on which stands the town of *Enniskillen*. The road we were in is the way to **Lough Derg**, where is the famous place of pilgrimage, called **St. Patrick's Purgatory**. There is a good road as far as to ***Pettigo*** where **Mr. Skelton** lives, who has lately wrote very well against Deism[38](javascript:footNote('E750002-001/note038.html')). 
**Lough Derg** is three miles beyond it through a very rough road. I return'd and dined with **Colonel Murray** (who had come to see me in the morning) I dined in company with **Mr. Conolly**, and many others, this Gentleman is brother to **Lord Elebanck** and to **Mr. Murray** who made so much noise in the Parliament of the year 1750 and is Lieutenant Colonel of foot. I had also in the morning been to visit Mr. and **Mrs. Moore** and **Mr. Taylor** her brother, son to **Sir Thomas Taylor**, who with two four wheel'd Chaises were come from **Lough Erne** and were going to **Giant's Causeway** &c.: I walked in the even to see a cascade three quarters of a mile above the town: The river falls in a narrow channel between the rocks, and there is a descent for a great way, which makes the river very rapid. I observed in the rocks of Marble the **Trochi**, **Entrochi** and **Asteriae**. I walked also down towards the mouth of the river on the east side to a house of **Lord Foliot** to whom this estate did belong, but descending to the Heirs General, it was sold to Mrs. Connelly: The house is particular as it is brick on the



---

p.73



outside and stone within. The Ancestor of that Lord came over from **England** in office; and the Colonel and **Captain Foliot** are descended from Collateral branches. The Lime stone is seen here in many places on the surface of the ground, and the softer parts being worn away, it appears in many odd figures above ground. On the opposite side **Colonel Foliot**'s estate is well improved: Beyond it is **Clary Castle**, the stronghold of that family who have since taken the name of Clark, and beyond that is a curious Grotto, the top of which appears like a fine Arch.


On the 28th **Mr. Oneal** went out with me three miles to the south to see **Lough Melieri**, which to the south is bounded by the mountains in the County of **Leitrim** and extends from the north east to the south west about eight miles and may be between two and three miles long; there are about half a dozen Islands in it covered with wood, a river runs into it from **Lough Cane** which has a communication with **Lough Nilly**, and the water of it falls into the sea at ***Bundrowes***, and all these waters are this way the bounds between **Ulster** and **Connaught** and between the Counties of ***Donegal*** and ***Sligo***. I went to take leave of **Mr. Connolly** and **Colonel Murray**, the former was not at home and I set out for *Sligo*, stopped on the other side of the river at ***Bundrowes***, where there is a Castle on the river which comes out of the **Lake Melvin**; Here I sat down in the County of ***Sligo*** in **Connaught** and dined, the river being beautifully divided into four streams, by beds of pebbles on each of which are boxes to take salmon. In the road from **Ballihaven** in two miles I passed by **Finnah Church**, and then travelled two miles to the river **Drock**, at the mouth of which is a Castle called **Bundrouch**, in half a mile we came to **Castle Duncarbery**, and in a mile more to the mannor of Ward-house belonging to **Mr.



---

p.74



Gore** who has a *jail* for Debtors for a certain sum. Half a mile further we came to a rivlet there being an opening to the south in the mountains called **Glanedy**, through which there is a road to 
***Ballyhamilton***. I observed beyond this a fine mountain called **Gartue**, which seemed to be detached from the rest, but when I came to the west of it, I saw it *joined* on to them: beyond this is the most beautiful mountain I ever beheld, called ***Benbulben***. The upper part is perpendicular, but being worn in a sort of rough pillars by the rain, it appears like a Gothic work, the rest of the mountain is a steep descent and a fine verdure; I saw on it many flocks of sheep which added to the beauty of it: the top of this mountain is flat and here the hills turn to the south. I came to **Bundutt** in about a quarter of a mile, and had **Millino Head** to the south west, a mile further to **Castle Buiskin**, in two miles to **Der Innis**, and as many more to **Rahamly**, in a mile to the river **Grause**, where we turned to the south, in three to **Faranangam river** and in a mile to the river **Drumdive**, where in a churchyard is a curious old cross, on one side of which is a relief of Adam and Eve at the tree of knowledge, and some other defaced reliefs on the other side. Turning to the west I came in three miles more to **Mr Knox**es fine farm to ***Sligo***, having been informed of something curious this way, on the *shore* seven miles from ***Sligo***, but omitted to make a particular enquiry concerning the nature of it. **Sligo** is situated on the south side of the river **Gilly**: There is also a sort of suburb to the north in which there is a barrack, and there is another barrack a little way out of the town, called the Strand barrack, both which are for horse; there is a foot barrack on the other side, within an old regular fortification in **Oliver**'s time, without any fossee,



---

p.75



that now appears the bastion being built high. It is a town of some small trade, tho' a ship of 100 tun can come up only at spring tides, and the ships of any burthen commonly *lie* down at **Poole**, about a mile or two below the town. There are remains of an old Convent here, in which the high altar is seen entire, adorned with Gothick reliefs, and there are two or three old monuments in the church; In the *cloister* are remains of a stone pulpit. The church of *Sligo* the design of **Mr. Castel**'s is in this shape, with windows at w, and galleries at every end except the east; the roof is a curious piece of work, and every way it is one of the best designs[39](javascript:footNote('E750002-001/note039.html')) I have seen. **Mr. Ormsby** has a large house in the town; but the thriving state of the town and the country round, next after the barracks, and **Colonel Wynne**'s improvements, is chiefly owing to the industry and spirit of **Mr Knox**; and it may be reckoned the capital of this north west part of the kingdom.


On the 29th I went two small miles to see **Colonel Wynne**'s house on **Lough Gilley**, and in the way viewed the charter school, which is building out of **Erasmus Smith**'s Charity: There are three good rooms on a floor, a kitchen and two schools, being built for sixty children, the Governor of **Erasmus Smith**'s Schools gave first £500 and then £200, and **Colonel Wynne** gave 4 acres of ground for ever; they have raised



---

p.76



it to the first floor, it is built of the slaty lime stone near it. **Colonel Wynne**'s house is situated on an eminence which has the Lough to the south and east, which is most beautiful in Islands and in the fine rocky hills that are on the south and east sides of it, both the one and the other in great part cover'd with wood. The house is built of a marble, in which I saw shells, as in the Kilkenny marble, and it appeared as if it would polish of a black colour. It is **Mr. Castel**'s design, six rooms of a floor and very well finished insomuch that it may be looked on, as one of the best houses in the Kingdom. I had met **Captain Wynne** the second son on whom I waited, he introduced me to his elder brother, who in the father's absence, with great politeness showed me the house and pressed me to stay dinner, and invited me to stay two or three days. I took leave returned to ***Sligo*** and waited on **Mr Knox**, **Mrs Stewart** of **Hornhead** her brother, and afterwards **Mr Mitchelburn Knox**, the person to whom this Town and County are so much indebted; After dinner I set out on my journey, going first southward three miles to **Belerejoneh Bay** and soon to ***Ballysadare Bay***, where if the *tide* had been out we should have crossed the strand, but being obliged to go round, we passed a road that goes to **Clonine** and came to ***Beltra***, where there is a Church we had almost all the way gone round a fire hill called **Knockrach** which makes the head to the west of ***Sligo***, on the top of it is a remarkable *cairn* or Mount, which if I mistake not is called **Muscarrow**.[40](javascript:footNote('E750002-001/note040.html')) I saw in all this road the stones full of that petrifications of Coral. I have 



---

p.77



reason to think from observations I have since made, that they extend all the way along that country to **Newport Pratt** on the western Ocean. We turned to the west and in a mile came to **Balinley rivlet**, and saw near it the ruins of an old Convent, called **Balinley Abbey**, for here they call all Convents Abbies and in Irish Monastere. Just beyond this we passed by **Bureen Castle** and in three miles came to **Arnaglans**, where there is a large old Castle and two mounts near the village; a mile farther we passed by a height where there were some foundations of **Castle Arragh** and had to the right **Gargaandouch**, a hunting Lodge of **Mr. Wynne**'s. We then came to a bay and turned up **Donecoi**, about two miles from **Castle Arragh**, where there is a large old Castle on a rivlet that runs of a rocky bed, in which I observed the stones lay very much as in square rocky pillars and in their strata. I saw **Grange Castle** about a mile to the east and passed by a Danish Mount and in two miles came to a poor Village called **Doneal** where there is a Castle and rivlet here I lay in a very indifferent Inn.


On the 30th I set forward and in a mile came to **Bellonrow rivlet**, in two miles to **Eskan Bridge**, here is the shell of a good Church and of the Priest's house adjoining to it: Towards this place I had seen the Mycetites or petrified *coraline* growth of the fungus kind, and saw towards the sea a place called **Leaught**, I here also observed a sort of large square pillar on each side of which there are niches as for statues, which probably was a Cross. We came in a mile to a rivlet called **Finich** and being come to the **Bay of Killalla** turned southwards; and here the country is no more stony, except a sort of rubble stone under the good soil; I observed that it is a very fine pasturage, which is converted to sheep walks. In a mile we came



---

p.78



to **Ricleheny Rivlet**, and as much farther nearer to **Castle Ducani**, which is on the sea and two rivlets run by it, having an old Church on the east called **Kiliaglass**, we passed *through* an old Rath, opposite to which to the south is another a rivlet running between them; in half a mile we came to **Carrihubbuck** village and rivlet, in as much more to **Inniscrual**, and at the same distance to rivlet **Belavaddy** and in a mile to **Suemmore** village, Castle and river, and here there is a boat to the opposite side and horses swim over: To the north of this is **Delakish**, and about this part there is a lime stone, which is full of the **Conchae**, **Anomiae**, as well as Cockles and continue for some way: In a quarter of a mile we came to **Doneen**, and soon after to **Kilch** village and rivlet, and in a mile to **Castle Connaught** where there is a rivlet. This Castle is situated on a height almost opposite to the Abbey of Rosserick, we afterwards passed these rivlets not above a quarter of a mile from each other **Rallenon**, **Farengrohen**, **Tramiliese**, **Cayeck**, **Couquiseen**, and **Baurive** which latter is large and falls in beautiful cascades down its rocky bed; and so we soon came to **Ballina** on the ***Moy***, which rises to the south*,* falls into **Lough Conn** and passing out of it again runs by **Foxford** and so it falls into the sea below **Killalla**: We here enter'd into the large County of **Mayo**, bounded by the northern and western ocean, being the north west part of the Kingdom. **Ballina** is pleasantly situated on the west side of the ***Moy*** and is a market town by which, and a foot barrack it is chiefly subsisted. It is but a poor place and belongs to [*...*]


On the east side are the remains of a Monastery, where there is a very good Gothick door case, which consists of about twelve members. From **Ballina** I took a ride to 



---

p.79


**Lough Conn**, which extends in length about eight miles from **Newtown Gore**, **Sir Arthur Gore**'s seat near as **Foxford** and is about a mile broad; the high mountain of **Nevin** is to the south of it, and it is a fine Lake. I returned to **Ballina** and *rode* to **Killalla**, the Bishop was expected home on Saturday, so I took up my abode at his house.


On the 31st **Mr. Carter** the Curate of the place came to see me, and I set out on a journey into **Erris** along the northern Coast. In a mile I came to **Palmerstown**, a village on a rivlet which falls into the sea a *little* below it, **Mr. Palmer** lives at this place, and there are some *little* remains of an old Castle. Here they have a lime stone, and a *little* further a yellow free stone, which I observed also in the cliffs near **Killalla**. In about half a mile we passed near the ruins of the **Abbey of Rafrane**, which must be the Monastery of **Rathbran**: further on I observed some stones as in a circle and some set up an end, after the manner of the ancient burial places in **Cornwall**. I saw **Castle Cariganas** to the left, and in about three miles came to a village and river called **Gartotui** where **Mr. Bark** lives. We went on about two miles to another hill and began to ascend towards **Donfiny** where there is an old Parish Church, and from this height the high rocks are seen off the eastern point, which makes the harbour of **Broadhaven**: These rocks from being very high and sharp, are called the stags of **Broadhaven**: but the weather being very bad I put into a Cabin, and din'd and returned in the evening to **Killalla**, the rains making this journey impracticable.


On the first of August, I *rode* with **Mr. Carter** along the strand two miles southward to ***Abbey Moy***, which is remarkable for having a square tower built, on one side (that is not on the point) of the two Gable ends that form the quire and the body of the Church, Hexagon arches



---

p.80



being turned on consoles from east to west, fixed in the Gable ends, which is a bold execution: there is much good stone work and Masonry about the Church Convent and *cloister*, the latter is built on plain pillars in Couplets as at ***Sligo***, this is called in Ware a Firiery. We went on about two miles to **Rossurk** or **Rosserich** Convent, where the tower is built in the same manner, but exactly on the middle point of the Gable ends: It is remarkable in both these Convents, that there is a closet built of hewn stone for two Confessors to sit in and hear Confessions, with a hole on each side, for the persons who confess to speak through. We went to the side of a rivulet and din'd, and I distributed what I had prepared for my western journey among the poor. In a wall I saw many of the **sunci Lapidei** and petrified corals called by some **Tonchaeanomiae**. **Mr. Linet** a neighbouring Gentleman farmer came and invited me to take a glass of wine, I staid with him half an hour, and found the Bishop come home at **Killalla**. This is a poor town but very pleasantly situated on the east side of the bay near the mouth of the river ***Moy***, which runs on the east side of some Islands that are between the river and **Killalla**, this river is easily crossed in fair weather: The Islands in the bay afford a very delightful prospect.


On the 2nd I preached at the Cathedral, and on the third I went through ***Ballina***, where by **Captain Owen** in whose company I had dined there, I received a very kind and pressing invitation from **Mr. Vaughan** near **Lough Conn**, but being engaged to go on, I excused my self and went forward: There is a road on both sides of the river to **Foxford**, but the new road is on the west side, and after riding about 4 miles, we crossed a hill from which we had a view of **Lough Conn**, and particularly of the south east end of it, from which as I was 



---

p.81



inform'd, there is an outlet into the river ***Moy***, on which **Foxford** stands. We had a view also of all that Morassy ground to the west of **Foxford**, to which place we came, it is situated on the edge of the bog and under rough rocky hills to the east in a very bad air, and all the water about it exceeding bad, except a spring a mile distant; it is a very poor town, but they are building a new Church: They have a barrack for foot, and formerly had iron works here, which before the revolution were in **Judge Ward**'s family, who was born in this Country, but on the wars that family retired to their own estate in the County of **Down**. They brought the iron ore from the mountain called **Nevin** to the west for all these mountains as far as the sea are full of iron ore; they work it up with the ore of **Lancashire**, which hardens it; otherwise it would be too soft. They have now iron works at **Mullamore**, nine miles to the west; and they collect together the wastings of the ore here and carry it to those works. I dined here and visited **Mr. Evelyn** the Minister, and went on: They are searching for coal at **Sleave Horn**, a mountain near. In a mile I passed by **Baky Lough Castle** and went over a river of that name on a bridge and I saw **Toramore Castle** to the left. In about a mile more we passed by an old Church called **Temple a Strada** and soon after I took a view of a Convent called **Strada** where the high altar is beautified with Gothick ornaments and in the middle is a dead Christ in the Virgin's lap, and a person in relief in a compartment on each side. There is also a tomb adorned with curious reliefs, of four kings in different compartments; in another one kneels before a mitred person and there is a relief of St. Peter and St. Paul: In a mile we passed by **Ballicurry** and saw **Currane Castle** to the right and **Turlaw's Church** on a height, where I thought I saw one of the round



---

p.82



towers: A mile further brought us to ***Manilla***, a poor small town situated on a rising ground to the West of a rivlet: It is chiefly a Colony of Protestants, settled here as Freeholders by **Mr. Brown of the Neal**, who founded a Charter School here for 12 boys and 12 girls, by giving 10 acres for ever and twenty at five shillings an acre,[41](javascript:footNote('E750002-001/note041.html')) which I went to see and travelled on towards **Castlebar** three miles farther, I saw to the west **Elm Hall**, a seat and good plantation of **Mr. Cuff**'s of ***Ballinrobe***, passed by [*...*] the house and Estate of **Mr. Domick Brown**, and about a mile from ***Castlebar*** saw [*...*] **Mr. Millars**. ***Castlebar*** is very pleasantly situated on a rising ground to the east of the river which falls out of the Lough of *Castlebar* that has communication with several *beautiful* Loughs round about. It is a pretty good small town, having a good market and a Horse Barrack, and they have lately built a handsome church of **Mr. Castle**'s design, it is the Greek Cross with three galleries: The windows and Cornish are of hewen lime stone which is the finest black marble, and is without mixture polishing as well. The Church is covered with a very good light stone slate of which there is a quarry in a mountain near called **Sleanbawn**; and about two miles from the town they have a quarry of good flags of the same kind of lime stone as the ornamental parts of the Church: There is also the black medicinal slate in some mountain near. This is the estate of **Sir Charles Bingham** now abroad on his travels, who has a small house near the town, built on the scite of an old Castle after the revolution: The two large round towers of the Castle remain in which his grandfather lived with his Father-in-law **Dr. Vesey Archbishop of **Tuam****


---

p.83



in King James's wars and defended themselves against the enemy.


On the 4th **Mr. Ellison** the Clergyman of the town and **Mr. Johnson**, a neighbouring *Clergyman*, came to see me: I set out at noon and observed the road at **Killalla** which comes to the West of **Lough Conn** and to the east of **Nefin**; and going near a mile saw another road which leads into **Erris**, we soon came near to **Lough Honey** to the [*...*] which falls into the lake of 
***Castlebar*** and passed by **Lough Barry** from which there is a communication by a river into the other. I observ'd here that the rocks are chiefly a cement of pebbles a *little* like that of **Hertfordshire**, and many fine stones might be found among them that would polish very beautifully with a variety of good colours: In two miles we came to a rivlet and a *little* farther to the river **Broheh** which rises out of **Lough Belta**, call'd in the maps **Blata** about two miles to the north east and in about two miles falls into the bay of **Newport**.


We came to **Newport** called anciently **Ballyvickan** or **Baleyvaughan**, it is most beautifully situated on a height to the north of a small river which about a mile [*...*] lower falls into that famous bay which is full of *beautiful* Islands. **Westport** a much older town being at the south east angle of it. This estate was a lease of 999 years from the **Ormond family** to **Commissioner Medlicot** and tho' consisting of 70,000 acres, yields at this time but £1700 a year, it was then valued only at £600 a year, of which £200 a year was fined off. **Mr. Pratt** who was clerk of the Treasury had a lease of it from **Medlicot**, built this *little* town, which from him was called **Newport Pratt**. On his failing he suffered himself to be ejected: and now **Mr. Medlicot** has bought the reversion of the £400 a year of **Lord Arran** after that Lord's death. It



---

p.84



consists of the *Manor* of **Burifool**, which has great privileges as a Court for Civil Causes not exceeding £40. The old Mansion house and Castle, are on a *little* Peninsula on the bay of **Burryfool**, which winds up from the harbour towards **Lough Furren**, it was converted into a barrack where **Theophilus Bolton late Archbishop of **Cashel**** was born, when his Father was a Captain quartered here; opposite to it is the Convent of **Burrifoole** which is a poor church and building, tho' it makes some figure at a distance; in it I copyed this inscription on a tomb, 
  

‘Orate pro anima **Davidis Oge Kelly** qui me fieri fecit sibi et heredibus suis Anno Domini 1623 et ejus uxori **Arabia Barret**.’


It is said that this Convent was founded in the time of **Henry VII** by the **Butlers**, and they have a great **Pattern** or festival here on August the 4th, St. Dominick's day: near it is the ancient Parish church of **Burrifool**, removed by an act of Vestry and Council to a Glebe about a furlong above **Newport** on the opposite side. At this place there was formerly a little town, and at present there are a few scatter'd houses. This being the port and a place of some small trade *until***Newport** was built. The Market of **Newport** consists chiefly of frieze, yarn stockins and different sorts of Corn; the provisions in this place are very cheap from June to Christmas. Beef a *penny*, Mutton five farthings a pound, chicken pence a piece, a fat goose for six pence, a Turkey for the same and fat Ducks two pence a piece, fish also is very cheap, and they have a Merchant who imports very good French wine at £16 a *hogshead*.


On the 5th I set out with a guide on hired horses for the Barony of **Erris** and particularly **the Mullet**. We came in a mile to a rivlet they call the Ford, which falls into the bay by the Abbey, half a mile further we were to the



---

p.85



east of **Lough Furren** a *beautiful* Lake into which the *tide* comes, tho' we could not see the communication: It is about a mile long and half a mile broad, **Lough Rafarn** falls into it from the north and is much higher, this is almost as wide and long: on the east side of it, the hills are cover'd with wood, and on the west are high mountains; I observed here a reddish free stone: We went over a hill from which there is a fine view of these lakes and the bay, which appear all like one Lough full of Islands extending for twelve miles to *Croaghpatrick*. We went to a river which we crossed several times, and another falls into it, which we also crossed often and went frequently along the bed of it, and in my return I observed in it towards the Lough near which I went in another road, several bodies of trees lying in it, which they grew on the spot, and were washed down by the torrent. We past **Letikeyn** a few houses to the east of the rivlet, called four miles from **Newport**; we here turned to the west, going up the hill for some way along the bed of the rivlet here I found myself as in an Amphitheater, encompassed with high mountains which made a very Romantick appearance, To the east **Bockworth** and **Billing Carragh**, to the north **Carnen**, and west of that **Mamarahty** and of that ***Little* Nefin**. To the west **Crooknegrah** (sheep mountain) to the south **Furcleogh**: We gain'd the top and descending had a small Lough to the right, passed through some very difficult bogs, and ascended on the side of **Mamarakty** having those high mountains to the south, which stretch towards the Island of ***Achill*** to the west and make the northern point of the **Bay of Newport**: These mountains about five one beyond another have a very curious aspect, the tops of most of them appearing with escallop hollows in perpendicular broken



---

p.86



rocks; they are full of Red Deer, which are very indifferent food, being never fat, however the hunting of them affords good diversion to those who traverse the mountains on foot, but they frequently escape the dogs. This mountain that I had ascended was of a sort of silver mica, which is not a lime stone, for they have none beyond the first hills we crossed to the river, but there is from that to the bay a vein of *blue* lime stone gravel which is good manure, they have also in many places about **Newport** a marle with shells in it, but the land being stiff, it is not a proper manure for it. (We here sprung a cock *grouse* the only one I had ever seen flying and appeared very *beautiful*.) Having gained the height on the side of the hill, we turned northward, and dined at a stream which gushes out of the side of it, from which place I had a glorious view of the mountains of the Isle of ***Achill***, of the sea and some fine mountains to the north east; descending for a mile, we crossed four rivlets and ascended along the foot of a mountain called **Kormestity**, which appears very beautifully like two grand bastions. We travelled on and had to the east another high steep and rocky mountain, and we went by a road which is over a rivlet, and coming to a large vale, in which there is a house and farm, we crossed a mountain torrent and ascending went round the side of the hill for three miles, to what they call the river, in the map it is called the salmon fishery, and the mouth of it is part of the **Black Sod Harbour**; I here observ'd a stone, a sort of silver mica, which *lies* very much in the form of the members of Architecture, and one I saw much like a large Cornish: As soon as we had the mountain to the east of us, we had to the west a morass extending to the sea now full of *little* fords: The most



---

p.87



 
dismal looking country I ever saw, and they say, the greater part irreclaimable; here are however not far from the foot of the hills, three or four *little* farms which chiefly belong to herds. The river we crossed was a rough bottom and very dangerous in time of floods: there is a road by this river to the east into **Tirawley** which *rises* out of the mountains near **Lough Conn**, but it is very boggy and almost impassible, except after that there has been dry weather for some time: We here got into a *cabin* where they had clean straw and clean blankets;—but the man observing the *smoke* was very troublesome to me, he made me a low seat near the fire, and I found it was not so inconvenient, the *smoke* rising up and condensing above. The guide called for an egg, broke off the top and *emptied* it into a scollop shell, as I thought to dress it, for the poor here use scollop shells for all uses they can, as they do on the **Red Sea**, but I was *surprised* when I saw him give a dram about in the egg shell; the woman also melted tallow in a scollop and dipt the rushes in it, and another time they twisted several rushes together, to make a larger light, and stuck it on a slit stick, the base of which was a large turf into which they run one end of it. The common people of the country live too much on these poor wretches when they travel, seldom bringing anything with them; and they were *surprised* when I distributed my bread and meat and what I had among them, and that I gave them a piece of money when I went away. All their vessels are of wood, most of them cut out of solid timber, their stools are long and narrow like a stilion, and their table is a long sort of stool about twenty inches high and broad and two yards long; their food chiefly oat cakes baked on the griddle and potatoes with their butter milk: they had



---

p.88



killed a goat and were *boiling* part of it; but I suppose it was not very good, as they industriously concealed it from me; but they offered to prepare me what they had to eat, which for strangers, is new milk, eggs, butter and oat cake: They have here a french *potato* with a purple blossom, it is something like an apple, but is watery and not so good as the other kinds. However this *potato* does best in sandy and I believe boggy grounds, and the cold and moisture of the *potato* is a good corrective of the heat of the oaten diet. It is the custom for the poor especially the children to come in and sit by the fire of those who are in better circumstances as well as travellers of all kinds, and they give to all, of what is going in their own way.


On the 6th we set forward the Gratefull Host accompanying us above a mile to show us the way through a bog to a large Lough to the north west called **Curraghmore Leterahery** out of which the river **Munry** rises, which we crossed: The Lake does not appear very large in this situation, but seeing it from  higher, I observed two large bays extending to the east and west, there is a small Island near the side we pass'd the ground to the south being on a declivity, I observed that the bog hung over at this part of the Lake, and in some places hung down for two or three yards, kept together by the heath, tho' the hard ground did not appear to have been lately worn away, but was greenish and some plants grew out of it, and I was informed that especially in wet seasons water runs between the bog and the hard ground which made me inclined to think that where bogs are on a declivity and the lower part of them as here is broken away, that they do actually move by their gravity; as the Ice in the Glacieres of **Savoy** certainly does, and falls down into the valley, and they 



---

p.89



affirm, that the ice when it moves is attended with a great noise: We had a boggy way for a mile, and passing by two houses soon came to a Vale, in which there runs a rivlet, and there are two or three natural mounts in it, one of which has been *fortified*; here I stop'd and took some refreshment, and crossing over the foot of a hill, came to a strand which is made by the blacksod harbour to the south and stretches along the south east side of the country within **the Mullet**; a very beautiful Peninsula stretches out into the bay, joined to the eastern land by a long narrow Isthmus. They have a bed of small oysters here, which at spring tides is left by the sea, and the people go and pick 'em up, pickle 'em and send them to **Dublin**: They sell them here for a *penny* a hundred, and on the bank they will load a horse for fourpence. We continued winding round the strand to avoid the bog above, on which the sea has gained in some places, insomuch that there is in some parts, bog on the strand, and one cannot ride on the sea weed, there are also several stumps of trees on the strand. From this strand in my return I went up to the height to see the bay which is formed by **Broadhaven** to the north, and with this bay forms that neck of land which is called **the Mullet**, and *joins* that long strip of land to the mainland which is called **Erris** within **the Mullet**: on the south side of this neck of land **Sir Arthur Shane**'s, whose estate it was began to build a *little* town, and actually cut a communication across the Isthmus large enough for a small boat to pass, which is now choaked up: They laid out also much money on roads into this country, made along the sides of the hills, by cutting away the bog, but this was found to be a bad way, for it makes a course for the water, and rain washing away the earth, leaves it a very 



---

p.90



stony rough road, and when this is done in a flat country, it has not only this effect, but the bog fills up the trench again: for the true way of mending their roads is by raising a Causeway of gravel, and where it is very soft, by laying a *little* heath under it. All the half barony of **Erris** consists of two parishes, **Kilcommon** taking in all without **the Mullet**; and **Kilmore** all that is within **the Mullet**; and they have some time ago obtained an Act of Parliament to build a church on **the Mullet** for the united parishes. We came within **Mullet** to that fine peninsula which is about twelve miles long from north to south and about a mile broad one place with another; the north end is chiefly high heathy ground, from which I saw the stags, as they call 'em, off **Broadhaven**: the rest of the land is partly in small hills, and partly consists of long rising ground, of good land and some sandy banks and loughs; being altogether a most delightful spot in summer. In these sand banks they find a great variety of shells, and lately they found some very curious vertebrae of fish, of which I produced a specimen: They have also discovered some tombs, which they call the tombs of **Lugnadumme** they say they are of an extraordinary size, but now they were all covered over again by the sand. I went to the house of **Mr. Anthony Odonnel** to whom I was recommended by **Mr. Odonnel** of **Newport**; I met his Nephew on the road, who very politely showed me the way, and among other questions asked me if I had any acquaintance there, which was on purpose to have invited me to his house, tho' he had the good sense not to say it; I dined at **Mr. Odonnel**'s, took a walk and saw the old walls of the church of **Tarman Carra** buried in sand, which they say was the church of a Nunnery. I took a ride in the



---

p.91



evening along the sea shore to the north east, which consists of *little* bays, made by the low rocky cliffs, and the waves rolling in on these rocks in calm weather, has one of the most beautiful effects I ever saw. I observed a small detach'd rock, which had some fortification on it, and going further saw a *little* head, which was defended by a modern fortification, made across the neck of it in **Queen Elizabeth**'s time, as they say, in order to deposite goods that were shipwreck'd, that they might not be plundered by the country: They had also built two barracks, one at **Carne** on **the Mullet**, the other at **Learne** on the east side of this Land within, in order to prevent the landing of privateers, but **Queen Anne**'s peace prevented the turning them to that use. I went on further and returned seeing a *little* to the westward a passage under ground from the sea, where the *tide* goes in about fifty yards and is seen from a large hole over it.


On the 7th I set out with **Mr. Odonnel**'s son and newphew to ride to the south of this land: To the south of this part is a strip of land called **Annah** *joined* only by a small neck; and the strand east of it, as well as that to the north is called the strand of **Annah**; this in the map is made an Island, and called **Emlokrash**, the reason of which is this, it was in one farm with the land to the east of **Tarmon Carrah**, which goes by this name. We then came to an open strand called **Baludurish**, in which there are several rocks under the water which render'd it terrible to the sight, even in a calm when the *tide* was coming in; but when we return'd and the *tide* way going out, it was very *beautiful*: on the point to the south of it, are the remains of a Convent called the Convent of the cross and near it is a church of the same name, which the Protestants had begun to repair, for **Sir Arthur Shane**


---

p.92



planted about twenty Protestant families here, on leases for ever of small farms, mostly under a hundred acres: This Gentleman left two daughters, one married to **Mr. Bingham** of **Newbrook**, the other first to **Mr. Wynne**, and now to **Mr. Carter** second son of the Master of the Rolls, these ladies hold the estate in Co-partnership.[42](javascript:footNote('E750002-001/note042.html')) Opposite to this is the Isle of **Ennis Clory**, which is a great burial place, of this Island they say no rat or mouse will live in it, and go so far as to affirm, that if they bring the earth and shake it in a reck of corn, none of these Vermin will touch it. To the south of this is **Enniskerah** and south of that **Enniskeah**, where if I mistake not, is a mineral water, and to this land people frequently go to pass some time for their diversion. The people in this Country are very hospitable, if you cannot stay to have a sheep killed they offer Ale a dram, Eggs and butter, and the woman of the house sits at the table and serves you: They have an odd way in some parts in the north, I did not see it here, when they would preserve meat, they put it into meal to preserve it from the flies, as I suppose, but it becomes musty and very disagreeable. We came to **Lough Cross**, a beautiful lake about two miles in circumference, here are wild Ducks, which as we rode within a few yards of them did not move into the water, and when I rode towards 'em, only walked gently in like tame ducks, and there is a *little* Island in it, in which I suppose they breed. An 



---

p.93



extraordinary thing happened in relation to this lake a few years *ago*; there was a rivlet run from it, to the sea, with a mill on it, in a great flood, it carried away the mill, and the passage was stop'd up, on which the lake retired near a hundred yards from its western bank, so that probably there is some communication under ground from the sea. We came soon after to the **Lough of Leame** near which is the building designed for a barrack; riding on we came to **Castle Tarah**, the ruin of a large old building: Towards the south point of the land we ascended **Mount Tarman**, a round hill not long ago covered with herbage, but the rabbits, burrowing in the land, the wind blew it away, and has left a more curious top all cover' d with *beautiful* large flat stones of grey granite: From this hill is a fine view of the Island of **Achill**, which is very mountainous and about 2 leagues distant: There are in it 25,000 acres of land, and it lets for £300 a year; the inhabitants have a kind of sheep here, with a coarse wool fit for yarn stockins, which they spin and knit and sell the stockins for about ten pence a pair; and with this produce they pay their rent; they have oats and potatoes sufficient for their own use; this is part of **Mr. Medlicote**'s estate. There is a great knowledge gained by experience, as to feeding their cattle on all these mountains, they find that for six months or some certain time they thrive on the same spot and then fall off, so that they move 'em to other parts; some parts are fit for cattle of different ages, and some at different seasons of the year. We came down from this hill to **Mr. Gamble**'s house, and took some refreshment there which was very civilly offer'd us: and returning we went to the east side and near **Mr. Markham**'s the pleasantest situation in the place which *commands* a view of the



---

p.94



Lough, of the sea and Islands and of **Blacksod Harbour**, of **Mullet** and **Erris** to the east, as well as the Isle of ***Achill***; that Island is represented as divided in the middle by a *channel*; there is water goes almost through, but not so as to divide it into the greater and lesser as re-presented in the Map; but little ***Achill*** as I was informed, is only that very small Island at the south point, which is placed in the Map without name. They have a custom of raising heaps of stones called here Iaktch, in other parts *cairns*, to the memory of the dead, mostly in the shape of sugar loaves, which are kept up as long as their friends remain, and are raised commonly not far from the church, in the way to and from the house; some are built with mortar and have inscriptions on them. We came to **the Mullet** and when we were out of it, we took some refreshment; I parted with my friends and the cattle they had mounted me on, and set forward the same way I had come with **Mr. O'Donnel** the gentleman I had met at my entrance into it, who was going to the Fair of ***Ballyhean***.[43](javascript:footNote('E750002-001/note043.html')) The way I was coming into this Country by **Broadhaven** is round by that bay very difficult and boggy and is two days journey from **Killalla**.[44](javascript:footNote('E750002-001/note044.html')) Going along the bog I saw an Eagle and crows about a carcase, for these birds never take notice of their brethren the carniverous race; It was of the large kind, and he seemed 



---

p.95



to attempt to raise himself, but remained very near us, and when we went towards him, he flew low to a turf stack at a *little* distance, for in a calm they sometimes find it difficult to raise themselves from the ground: About half an hour after we saw him fly over us to the north east to the sea. We took up our lodging about a mile to the north of the river at **Mr. Nashe**'s farm house where we had a fine view of the lake; here is an old Square Castle in ruins called **Clonatekilly**; a *little* below it are two caverns, about six feet wide and high and ten long, covered with stones laid across, within one of them was a narrow hole about three feet square like a drein; these seem to be places to hide in upon any danger. They have a way in this country of burying children in some *little* plat near the house, when they are at a distance from the church, and such a burial place I saw.


On the 8th We set out and crossed the river on each side of the banks of which towards the sea are *little* spots of arable land and several houses; and one part of it goes by the name of **Kilkeny**, where they have a considerable salmon fishery. Several people *joined* us going to the fair and we made up a *little* caravan of about seventeen horses: and when we stop'd twice and I divided my bread and liquor among them, and to the two or three protestants my meat also, I was had in great esteem among them, and so early in the evening I finished this curious uncommon journey and arrived at **Newport**; where my friends of **Newport** spent the evening with me.[45](javascript:footNote('E750002-001/note045.html'))


On the 9th **Mr. Herne the Minister**


---

p.96



came to see me, and I preached at his Church. He, **Mr. Odonnel** and **Mr. Moore the Collector** invited me to dine with them; the last very politely by a card the night before, being a *little* indisposed with the Gout, the other that even:—but I was first engaged to **Captain Cantillon the commanding officer of the foot** here. I drank tea with the Collector, *rode* with **Mr. Herne** to see the Monastery of **Burrisool**, and spent the evening with the Collector, and lodged at **Mr. Herne**'s.


On the 10th at noon we set out, all the officers, **Mr. Herne** and the Collector on an expedition in the Revenue Sloop to the Islands, and had a most *delightful* voyage through them to the south west. The sea gains on them and some are almost divided into two; there are fine stones on the *shore* round them, some of the petrified coral rubbed into pebbles and some of the Mycetites; they are Islands covered with pasturage and some with corn; forty of them belong to **Mr. Medlicot**, some to the Archbishop of **Tuam**, some to **Mr. Brown of Westport** and other proprietors on the bay; they say there are 300 of them, and it is look'd on as the Archipelago in miniature and is a most singular beautiful bay:—At the mouth of it is **Clare Island**, belonging to the old proprietors the ***O'Malleys***, I was told it was worth £200 a year; to the south west of it is **Buffin**, belonging as I was informed to **Lord Clanrickard** and worth £150 a year; they have in these two Islands a pretty breed of small horses: they do not submit to pay any tax but the hearth money, and have good water in them, and so have many of the small Islands. About ten leagues off is a bank, where there are plenty of Cod, and it is supposed that it is part of that bank which extends to **Newfoundland**, being supposed to be hills in the sea where the fish *lie*: on this they have



---

p.97



between 40 and 50 fathom water: the fish have very much failed on all the coast since they have burnt the sea weed for kelp, which they not only take away as the sea leaves it, but they cut it off in the sea that it may be thrown up, the fish spawning on this weed. We returned to **Newport** and they spent the evening with me. In the river of **Newport** they have the large fresh water pearl muscle.


On the 11th I set out to the south and all the officers went with me and dined with **Mr. Brown of Westport**, who had sent compliments to me that he should be glad to see me. The road is very pleasant near those *little* bays which are westward from the harbour and in sight of *delightful* Islands. I went to the top of some hills to have a view of them; about two miles and a half distance we came to a rivlet called **Moinah**, which goes under a hill about a quarter of a mile into the sea, and the *tide* comes in by the same passage. A *little* farther we came to a well wall'd round which they call ***O'Malley's* Well**: concerning which there is a tradition in the country, that a female child of this family, being dipt in it became a male, which was probably some trick in order to secure the estate of the family in that child. We descended to **Westport** a small village situated on a rivlet which falls into that bay, and makes the south-east corner of the great bay, in which there are some small Islands. The foot of ***Croaghpatrick*** comes into it which is called [*gap: extent: one word*] (the Eagle mountain) by reason that it appears like an Eagle stretching out its wings; tho' from the north east from 
*Castlebar* it does not appear in that manner: It is not determined whether this mountain or **Nefin** is the higher. The coast extends about ten miles farther to the County of **Galway**, where the country on the western ocean is called **Connemarrah** ( ) probably the



---

p.98



name of some ancient clan;—This it is likely is about the extent of the Barony of **Ballynehinch**; to the north east of this is the **Joyces Country** on ***Lough Mask*** and ***Lough Corrib***, probably the Barony of **Ross**. To the south east is the country of ***Iar-Connaught***, taking in I suppose the Barony of **Moyeulau**. I had designed to have rode along the sea coast, but the weather was so unpromising, that I laid aside that design. **Mr. Brown**'s house is very pleasantly situated on the south side of the rivlet over which he has built two handsome bridges, and has form'd Cascades in the river which are seen from the front of the house; which is built of Hewen stone, a course marble they have here: It is much like Bedford house in Bloomsbury Square, except that it has a pavilion in the middle over the Attick story in which there is a large convenient Bed chamber for the young people, of the size of the hall, the design is with nine windows on a floor and for five rooms; one of which a back wing is not built: It is an exceeding good house and well finished, the design and execution of **Mr. Castel**'s: **Mr. Brown** designs to remove the village and make it a Park improvement all round; there are fine low hills every way which are planted and improved, and the trees grow exceedingly well: the *tide* comes just up to the house; and the Cascades are fine Salmon leaps. In the house are *handsome* chimney pieces of the *Castlebar* marble, which are a good black without any white in them like the Touchstone, which the Italians call Paragone and value very much.


On the 12th I *rode* out with **Mr. Brown** to a hill to see the prospect and to the Park, where he has several red as well as fallow Deer, and in the afternoon I walked out to the quarry and to the side of the bay. I had forgot to mention a small Island called **Ennis Turk** to the south west of **Clare Island**,



---

p.99



there is a good slate quarry in it. They have here a marle with which they manure sandy lands, but I could not be informed that it had any shells in it. **Mr. Brown** makes use of oxen to draw dung, stones, &c.: on sledges which they easily load.


On the 13th **Mr. George Brown**, a younger son, who is at the College, and **Mr. Blake** a young gentleman of Estate, going my way accompanied me, and showed me three miles off, a *little* beyond a village call'd **Baleyburk**, a cave to the right, into which the river **Anne/**falls, and goes for some way under ground, and coming out again falls, as they told me into ***Lough Carra***, and is a river which in the maps is represented as lost in a very small Lough to the west of ***Lough Carra***. It is a very fine face of a rock, consisting of about fifteen strata which lay very regular, I believe most of them are of plain black marble, as I was informed it is of that colour, but some of them when broke are of a brown colour. The river runs principally into one hole, which is as a *beautiful* arch, the strata rising one over another and each beyond the other, until it extends to the face of the rock, the passage may be forty feet wide and long, about 20 high, this leads to the grotto in which the river runs about sixty feet wide from the passage, seventy long, and 50 high, through this the river runs, but being then a flood, it was all over flow'd; to the west of this are two or three other passages into which the river runs when it overflows. Returning to the road we saw ***Kilturk*** a *little* beyond it to the left, a fine old ruined Mansion house of **Mr. Brown**'s in which his father lived, and to the north of that we saw **Holyhill**, **Mr. Chambers**'s. About three miles farther we came to ***Balintubber* Convent**; near **Kilturk** we passed through **Balikeen**, where the famous Fair had been held just 3 measured



---

p.100



miles from **Castlebar**; this is an *handsome* Convent, called also **De Fonte**, from the Irish name which signifies the Town of the Well or Spring: there are handsome pillars and arches in it, and at the east end are two windows of the Saxon Architecture. The Lords of Mayo have their burial place here in a chapel in which there is a handsome altar piece and an altar of hewn stone, round the latter are the figures of our Saviour and the eleven Apostles in relief. Here I took leave of those gentlemen who went on in this road, which leads first to **Castle Burk**, the seat of **Lord Mayo**, where I heard there were some *petrified* stumps of trees and some underground passages to the Castle; beyond it is **Rusk Garrah**, **Sir Henry Lynch**es on *Lough Carra*, it then goes to **Holy Mount**, the Estate and seat of **Vesey Archbishop of **Tuam****, which was esteemed a fine place in those times, and so it goes to **Tuam**; But I crossed to the **Ballinrobe** road I had left a *little* before we soon came near **Lough** Corra at **Ballikeneh** and I went to a rivlet and took some refreshment. I saw to the north about two miles **Newbrook** **Mr. Bingham**'s, and going on came to the bridge of **Fere**, under which ***Lough Carra*** passes into ***Lough Mask***, tho' it is spoken of as a great work, yet it is only a long Causeway, with one arch in the middle which is not large. We passed over a greater work, a road made across a morass, having had a view of **Lough Mask** to the south for some time, I came to ***Ballinrobe***, a very small town pleasantly situated on the river **Robe**, which about a mile below it falls into the **Lough Mask**. The large map of **Ireland** makes a small Lough here which is wrong. They have a *handsome* sessions house built of hewn stone, the assizes being held at this place and at **Castlebar** alternately: They have here fine quarries of a dark grey marble which rises so well that



---

p.101



they make ashler very *little* inferior to hewn stone. This town belongs to **Mr. Cuff** who lives close to it, and is endeavouring to improve the town. There is a Charter School here for thirty children which I went to see where **Mr. Miller**, Minister of the place and **Mr. Lanergan** a clergyman of a neighbouring parish came to me and they spent the evening with me. There are remains of a church of a Monastery of Augustinian hermits near the town.


On the 14th I breakfasted with **Mr. Miller**, having received an invitation from **Mrs. Cuff** in her husband's absence to breakfast with her, but her hour being too late, I was obliged to send an excuse. **Mr. Miller** set out with me towards **Lough Mask**; About a mile from the town I saw a large *cairn* of loose stones, it may be twenty feet high and forty feet diameter, another about a mile to the south with a fossee round it, and a smaller between them, the tradition is, that two armies engaging there, *cairns* were erected over the slain of the principal of them: We came to a fine old Castle called **Castle Mask**, from the top of which I had a beautiful prospect of **Lough Mask**, with many Islands in it cover' d with wood and one in particular with a pleasure house belonging to **Mr. Cuffe**: We had also a view of the mountains of **Joyces Country**. This Castle belonged to one of the **Burks** of **Lord Clanrickard**'s family. On the top of **Benlevegh** in **Joyces Country** I was informed that there was a large Lough near this country of the Joyces in ***Lough Corrib*** is an Island called **Castle Chirk** **Kirk** which is the name of **Mr. Middleton**'s house in **Denbighshire** in **Wales**. I was told that at **Long Abbey** there is a stone head said to be design'd for Roderick O'Connor King of **Connaught**. Beyond **Lough Mask** to the north west towards the sea is a mountain called **Ferramore**


---

p.102



on which there is such a debt to the Crown that no one will occupy it; on it they say are traces of a town, said to be begun to be built by some stranger who came to settle in these parts, and as it is supposed by those people who afterwards built **Galway**. In **Lough Mask** is an Island call'd **Inch en Keill**, consisting of about sixty acres, in which there are two churches. There is also another Island called **Innish Enearton** (The Earls Island) to which they say **Strongbow** fled and was killed there, and if I mistake not they show some place for his tomb. We got into the road from ***Ballinrobe*** to **Hetford**, which passes thro' the **Nail**, from which we had gone from **Cong** to **Tuam** three years ago: We came to **Garn** church a mile from the **Nail**, where I saw a quarry of fine marble, which *polishes* a brownish black, they work it with the hammer for about sixpence a foot. We saw on ***Lough Corrib*** a point of land called **Baley Cumea**, a very fine situation of **Mr. Lynch**es, and to the east we saw **Skrool** famous in History for a very horrid Massacre: In this road I observed what they call the Terloughs, that is meadows that are cover'd with water in the winter, which goes off as it comes in, by underground passages; some of them are good meadows and some only marshes. We crossed **Ross** river into the County of **Galway**, and saw the large Abbey of **Ross**. About a mile lower on the same water: We came to **Hetford** a small town where there is a barrack and a Mansion House of late **Lord St. Georges**, now of **General St. George**, but leased by the late Lord to his daughters heir, married on **Mr. Usher** now **Usher St. George**, who lives there; I was met two miles from this town by the **Revd. Mr. Fletcher** brother to my Agent in **Dublin**, to whom I had sent that I would come and dine with him, he conducted me half a mile beyond 



---

p.103


**Hetford** to his house, where after dinner taking leave of **Mr. Miller**; **Mr. Fletcher** went with me six miles in my road. I passed over **Achlin bridge** and saw an old castle **Ballinacort** lately fitted up; it is in a fine situation and the seat of **Mr. Kirwall**. In three miles I came to **Baliclareh**; and near it on a rivlet saw ***Claregalway Abbey***, where the high tower in the middle of the Church built on arches is a curious piece of architecture; I saw the chapel of the church converted into a Mass house. Three miles more brought me to **Galway**; where I went to the house of my old friend **Mr. Simcocks Warden of **Galway****.


**Galway** is pleasantly situated on a fine bay, which is a very good harbor, and on the river which comes out of ***Lough Corrib***, which spreading here to the east, they call it the Lough; the river runs on a rocky bed, and dividing into three parts it forms two Islands to the west of the Town, on one of which there is a Nunnery. This town was inhabited by the Hollerns Fishermen till one Lynch in 1280 got a grant of the lands of it, from **Edward II.** and as tradition *says* built two Castles, both called **Reinville**, one against the Hollerns the other against the **Flakerts** of ***Connemara***. This was anciently in the Diocese of ***Annadown***, which place I saw on the right on the Lough coming to **Galway**, it is now *absorbed* in **Tuam**. The people of the town got an exemption of this and several other parishes from the Pope, on account as they pretended of the ill behaviour of the clergy the Bishop sent to them: Some say this was when ***Annadown*** was united to **Tuam**. This exemption they got confirmed to them by Charter from **Edward the 6th**, who gave them a power to elect, a guardian and three Vicars of the Church exempt from all jurisdiction whatsoever; the Guardian and senior Vicar preach alternately in the morning, the other



---

p.104



two in the afternoon, and the three Vicars take their turns weekly to read prayers and visit the sick. The Corporation also have a power of punishing or even removing them within the year. This town was formerly of great trade, to which they apply'd themselves when the other parts of **Ireland** were very unquiet: They had a great trade in Spanish wines, which were formerly drank; but above all to **America**, till the act pass'd which obliged all ships from **America** to touch in **England**, from which time the trade of this town began to decay. When the town was in this flourishing condition, there were many large houses built in it of hewn stone, after the Spanish manner, most of which remain and one sees a great number of fine carved windows, Doorcases, chimney pieces, and bow windows in these houses. The trade is now mostly carried on to **France** and **Spain** by the Roman Catholicks, who have correspondents there, and are jealous of others coming into any share with them. When the town was in this flourishing condition, the merchants here purchased almost all the Lands in this country which *do* not belong to the Church and the **Earl of Clanrickard**: The descendants of which merchants are now possessed to the value of £100,000 a year, and others have forfeited or sold to a much greater value. They were of the name of Blake, Darcy, French, Linche, Kirwan, Joyce, Martin, Brown, Bodkin, Terrets, Athy, Funt, Penrice, the three last are extinct or near it. If they had submitted to **Oliver Cromwell**, it would probably have been much better for the town. The remains of the forts he built to attack the town and defend the passes between the Loughs and the sea, are still to be seen. **Lord Mountjoy** built the Citadell at the south east part of the town. They have a large church adjoining it, the



---

p.105


**Lynches** have a chapel in which they bury: In the vestry on three large stones are cut as big as human life, Our Saviour, the Virgin Mary to the right, and to the right of that God the Father and over his head the Dove, they were dug up some where about the church: To the north of the town are the remains of a Franciscan Convent, and the face of an altar or tomb with some reliefs of Saints on it. Both the **Franciscans** and *Dominicans* have Convents here, and there is a Nunnery which serves also for a Boarding School: Just without the gate is a mineral water of a strong taste, which they use for purging, and when drank plentifully, it is said, they answer the end of Scarborough waters. About two miles to the north east in the way I came is a rivlet, which comes out of the river that falls from ***Lough Corrib***, it is call'd **Pool Hurley**, it goes underground there and comes out into the bay of the sea which extends to the east. From a hill about a mile above the town by the canal, is a very fine prospect of the sea, of the country on the other side of the bay, of the isles of **Arran**, of ***Iar-Connaught***, the **Joyces Country** and ***Lough Corrib***. They have in **Galway** three barracks, which hold two Regiments and a half of the present compliment: for it is a garrison town with a Governor who has a salary of £300 a year, but he does not commonly reside, and then the commanding officer acts as Governor.[46](javascript:footNote('E750002-001/note046.html'))


On the 22d at **Galway** I walk'd out morning and 



---

p.106



evening, and **Mr. Heathcote** in a regiment here, who was one of **Lord Chesterfield**'s pages, came to see me, and spent the day with me: In the evening I look'd into the Assembly to see the Company, for the Clergy go here in their Coats.


On Sunday the 23rd I went to wait on the judges and attended them and the Corporation to church and preached before them, **Warden Simcocks** not being well, I dined with the judges at the Mayors, the Gentlemen of the Grand Jury being there. I came home and **Dr. Lynch** spent the evening with us.


On the 24th I took a *little* ride, but the weather did not favour. **Mr. Darcy** came to see me and brought an invitation from the Grand Jury to dine with them, but I was engaged to the Wardens; that Gentleman spent the even with us. A very remarkable thing happened there in relation to one of the **Lynches**, so long *ago* as that he was the fourth or fifth Mayor of the town: His son was coming in a ship from **Spain**, murder'd the Spanish Captain, brought the ship into **Galway** and sold the goods. When this fact came to his father's knowledge, the son was *tried* by the father and condemned, who sat on the bench, and intercession being made for him; he bid the persons come to him in the afternoon, and when they return'd they saw the son hanging out of the chamber window. This house remains as a specimen of an inferior sort of building, and over the door is a death's head and bones of a skeleton. I examined some of the records of the Town;—found that in 1511 butter was a *penny* a pound and a hundred of Eeles here sold for two pence and a Cod for a *half-penny*; in 1526 a carpenter and man's pay was two pence a day with diet. When six and eight pence only was allowed for the Mayor's dinner the twelve Aldermen and such others as he should ask, and there was such a



---

p.107



plenty of fish in 1701 that a thousand Herrings were sold for eight pence. In 1646 they condemned a book as against the King, entitled Disputatio Apologetica et Manifestiva de Jure Regni Hiberniae pro Catholicis Hibernis adversus Haereticos. There is an order that no corn be burned or scortched in the town. In 1632 the oath of Supremacy and Conformity in Religion being required the Mayor and officers resigned, and others were chosen who took the oath. In 1649 they had the plague. In 1654 the Irish were dismissed from all offices, and English protestants chosen in their room. In 1691 the Town surrender'd to **Genkle** on the 26th of July. Having mentioned the Bishoprick of ***Annadown*** or **Enaghdun**, it is to be observed that the Bishoprick of **Mayo** was united to it in 1210. The Bishoprick of **Enaghdun** was long disputed by persons who pretended a right to it from about 1250 to 1318. In the Episcopal Register at **Exeter** I find Bishops of **Annadown** suffragans to the Bishop of Exeter in the following years viz.
  

1. Henry . . . in 1395 and 1398.
2. John . . . 1438.
3. Thos . . . 1458.



On the 25th I was at the doors of **Mr. Brown** and **Mr. Darcy**, took leave of **Captain Heathcote** and after dinner set out, young **Mr. Simcocks** accompanying me three miles to **Oranmore**, where a rivlet falls into the bay; two miles farther we came to **Daren Bridge**, and half a mile farther to **Shilcollogan Bridge**. I observed several large entrenchments on the mountains of ***Burren*** to the west, in the county of **Clare**, one of them they say was the Residence of O'Laughlin King of ***Burren***, and on the Bay about four miles distant is the Abbey of ***Corcumroe***, which they say is a fine ruin, and that on the graves are laid tombs of wood, 



---

p.108



many of them being of yew, with some remains of inscriptions on them: It was anciently called **St. Marie's Abbey**: within a mile of **Gort** we passed through a village called **Kiltorton**. The sheep in all this stony country produce very fine wool much valued and is sent to **Dublin** and **Cork**. I was at **Gort** in 1749 in our Tour through **Munster** and **Connaught**: it was the estate of the **Oshognusses** and was forfeited; and now there is a *barrack* in an old Mansion house of that family built within the walls of the (in the) Castle, it is a very poor market town like a village: In my way to this place about six miles from **Galway**, I had a view of the house of **Mr. Walter Taylor**, whom I had seen in **Galway**, he is above four score years old, and told me had seen about 460 descended from his Father, and several great grand children; he *rode* lately from **Dublin** to **Tullaghmore** in one day, which cannot be less than sixty english measured miles, it is 45 computed irish miles if I do not mistake: As his passion has been to encourage a good breed of horses, so at this time he is a constant attender of all diversions in this country, relating to the improvement of that noble animal.


On the 26th I went two miles south west, passing by an uncommon oval Castle at **Newtown**; the mountains of **Burren** appear to be stony, but the summits of most of them are round and appear as in *beautiful* Terraces. I came to **Kilmacduagh** situated on a rising ground over some *little* Loughs which are to the west. It is the See of an ancient Bishoprick now united to **Clonfert** and consists only of old buildings and of two or three Cabins; it was called the church of Duah: About the middle of the 6 th Century, it had the name of Kil-mac-duah, that is the church of the son of Duah, commonly called it seems Kil-macough. The first building that offers is the ancient Cathedral in the form of a Latin 



---

p.109



Cross; on the south side of which is an ancient Altar in good taste; under a relief of a Bishop is this inscription ‘Sanctus Coloman Patronus Totius Diecesis Duacensis’: In the middle is a crucifix and a person on each side with ‘ Ave Maria’ and some devotion round it: In the **Oshugnussy** chapel, the old Proprietors, is their tomb of the Corinthian order and I observed their arms the Castle of **Gort** supported by two Lyons. In that chapel there is a tomb with this inscription. ‘Orate pro anima Edmondi ocahel Praepositi et Canonici Duacensis 1742.’ To the south is a chapel called **Shatrany**. To the west in the church yard is a small cell where they say the Patron Saint was *buried*, and that the body was afterwards *carried* to **Agherrim**. Between this and the church is Macduagh's Chapel, in which there is a standing large dead Tree, of which they take pieces by way of Relicks; and to the south of this is a raised work of stone, which they call the Saints Bed. In the church yard is one of the round towers, if I mistake not; fifteen feet in diameter: it is finely built of stones well chosen, but do not seem to have been *hammered* and they are not all laid in regular courses, the lower Tier sets out 9 inches, the entrance is about twenty feet above the ground: there are five small windows round at top with pointed arches, and there about six others without any order in different parts: By measuring the shadow I concluded it to be about 82 feet high, a *little* of the point at top is broken off; this I think is the best I have seen after that of the church of **Ardmore**. To the east of the church is our Ladies chapel and to the north of it St. John Baptist's. To the north of it is the Monastery of **Kilmacduagh**, said to be of **Regular Canons**; it is on a neck of Land between two Loughs, of which authors mention, that they empty in summer by whirlpools; but I found that



---

p.110



the water goes off only in a very dry summer and that rarely; when they do empty they catch Eeles and other fish. The church tho' small is a very neat building the pillars and arches of the entrance to the Altar part and of the east window are in a *beautiful* style, and the Angles at the east end, are work'd as in pillars, as at **Lismore Cathedral**: To the south of the church is a Sacristy, and *adjoining* to that a room, in which they probably deposited the valuable effects of the church, which because it is arch'd they call the *jail*. There is a chapel on the south of these, and a room which I conjectured might be a Refectory, and from the buildings, I imagined the **Canons** might live in separate houses not built in the best manner. To the north of the church is an old wall about two feet from the other, it is out of its level, and they have a story of its being a place of penance, and that penitents were used to get in between the wall and let themselves down by way of punishment. The Bishop's house to the north of St. John's Chapel, or as some call it the Seminary is a building of two rooms on a floor; what is singular is a building on the outside like a chimney, but from what I could gather, it was the stairs to which there is a passage, by a sort of a bow window which rests on one stone in the wall, from which they say the Benediction used to be given.


27th. In the way to all these buildings is a Holy Well with a circular enclosure. From this place I came again into the high road at **Crusha** two miles from **Gort**, where there is a tolerable Inn. At **Tuberin** we crossed a stream from the County of **Galway** in **Connaught**, to the County of **Clare** in **Munster**, we came to **Loughed Bridge** which I conjecture to be the river which in part forms those Loughs that are to the west of **Crusheen**: Half a mile farther we crossed another stream and in half



---

p.111



an hour more came to **Crusheen** on an eminence where there is a very good Inn, at which I dined: Till we came to the County of **Clare** the face of the country is all rocky being a greyish marble as I conjecture; about **Galway** it is full of cockles and the **Conchae anomiae**, and in almost all parts the petrified coral more or less. But here the face of the country is entirely different, all in *little* well improved hills, not without wood and something like ***Northamptonshire***. We went on and immediately crossed a stream and had a fine view of ***Lough Inchicronan***, we passed three streams in a mile and came to **Brincastle**, and crossed three more below, I came to a village called Span . . . Hill, where the road strikes out to **Ennis** which I had formerly gone in. This place is three three miles from **Crusheen**, we soon came to **Molieth** **Mr. Macnamarrah**'s, well improved and a fine situation, and at the end of three more came to **Quin**, having had a view of **Colonel Hickman**'s house and of the plantations of **Mr. Burton** and **Sir Edward O'Brien** we had passed in our former journey through this country. Here I saw fine *lime stone* with much of the coral in it  entirely consolidated with the marble. We had also in this road a view of the pleasant bay beyond those Gentlemens' seats, which extends to the north from the **Shannon** and is full of Islands. At **Quin** is one of the finest and most entire Monasteries I have seen in **Ireland**, it belonged to Franciscan Minorites, and is called in Ware **Quinchy**; it is situated on a fine stream, there is an ascent of several steps to the church, and at the entrance one is *surprised* with the view of the high altar entire, and of an altar on each side of the arch to the Chancel; to the south is a chapel with three or four altars in it, and a very Gothick figure in relief of some Saint probably of



---

p.112



St. Patrick on the north side of the Chancel is a fine monument of the **Macnamarahs** of **Ranace**. On a stone by the high altar I saw the name of Kennedye in large letters; In the middle between the body and the chancel, is a fine tower built on two Gable ends. The *cloister* is in the usual form with Couplets of pillars, but particularly in that it has buttresses round by way of ornament there are apartments on three sides of it; what I supposed to be the Refectory, the Dormitory and another grand room to the north of the Chancel; with vaulted rooms under them all; to the north of this large room is a closet over an arch, which leads to an opening, that seemed to be anciently a private way to go down in time of danger, in order to retire to a very strong round tower, the walls of which are near ten feet thick, tho' not above seven or eight feet from the ground; it has been made use of without doubt since the dissolution, as a pidgeon house, and the holes remain in it: In the front of the Convent is a building which seems to have been a **Forastieria** or apartments for strangers, and to the south west are two other buildings: On the other side of the river is a parish church, with a tower built to the corner of it . . . Half a mile to the north east is a *beautiful* turret of a Castle. We went on three miles further to a small town on a fine Rivlet.


On the 28th I went three miles to **Six Mile Bridge**, where there is a *handsome* new church, and near it **Mr. Ivers** has a pleasant new built house. The ride from this place to **Limerick** is very delightful, being well wooded and in sight of the fine river **Shannon**, and of the *beautiful* country on the other side of it. The appearance of the Country on this side **Galway** is very different from what it was farther north for I observed the corn ready for the sickle, and when I passed **Gort**, I found the



---

p.113



harvest in several places far advanced: It is all a hot lime stone which makes the harvest very forward; and I was told that the cattle turn themselves frequently in the night on account of the heat of the ground. In about 2 miles I saw a large old house, near the river called **Bunratty**, which was the Mansion house of the ***O'Briens***, the ancient Earls of Thomond. I came to **Limerick** very strongly situated by nature on the **Shannon**: To the east of it is Irish town, which is pretty strongly *fortified*, the whole being about two miles in circumference; excepting the principal street; All the rest of the town consists of narrow lanes, and it is a very dirty disagreeable place; tho' so large there is not one good Inn where strangers can he well accommodated; they have a tavern indeed which has lodgings in it, commonly filled by officers: Both the air and water are looked on as unwholesome, and the army commonly loose many of their men here: They are chiefly quarter'd in a barrack within the citadel on the west side of the town, and this large city, which has such conveniency of water, has not so much as a fire Engine to make use of, in case of any accident of fire. The Cathedral is a very mean heavy building, but the Quire is fitted up in a neat manner; and in it is a magnificent tomb of black marble, erected to the memory of the Grandfather the Earl of Thomond who lived in the time of **King Charles the Second**, in the place of an old one defaced, of which two couchant Statues remain. This Cathedral was built by **Donald O'Brian King of **Limerick****, and there is a church, in **Limerick** called **St Munchin**, now a Parish Church which is said to have been the Cathedral, and that it was founded by **St Munchin first Bishop of **Limerick****. It is remarkable that the present Cathedral stands near north and south; and they have a tradition that it was a palace



---

p.114



of the **O'Brians**: The Bishoprick of **Ardfort** probably taking in the County of **Kerry** is united to this see, and in that is the *absorbed* Bishoprick of **Hoghadoe** the church of which I formerly saw over the lake of **Killarne**. There is an old Convent turned into a Tan-yard, which they call the Abby; it is on the north side of the town. They have a good Mole for shipping to *lie* in: There is a great manufacture of Serges here, and a very great number of working people in the town, greater perhaps than in any place of the size; and I cannot think they can be less than 40 thousand souls in the town and suburbs. They import wine, timber and all sorts of goods for the supply of this country, and great part of the County of **Tipperary**, as well as the Counties of **Clare** and **King's County**: But **Cork** lies much more convenient for the Export. I walk'd round the town either on the walls or within them and went to the Cathedral service.


On the 29th I *rode* to the west and in a mile crossed over **Brater Bridge** in another mile to **Money** or **Monterel**, commonly called Mongrel, where there are remains of a poor old Convent with a tower, at one corner of the church. I was informed that monks never had towers to their convents, by which I suppose they mean Mendicants *Friars*. In two miles we came to **Cloynreen** village and rivlet and in two more to the ferry over the river **Magel**, on one side of which is **Clogtotacheh Castle**, and on the other, **Column Castle** **Mrs. Harting**'s house near being called Court, as in the Map. In a mile we came to **Kildaimon**, in another to **Lacerane Castle** and **Lough**, and in another mile to a very small Church on a *little* height called **Killallatring**, the walls of it are very thick, with only such a window in the east end, as is seen in the round towers in this shape 



---

p.115



 so as that it is probably one of the most ancient churches in this Kingdom. I came in a mile to a large old Castle called Palace with a village near it of the same name, to the south west of which **Mr. Bury** has begun a new town called **Newmarket**, and is endeavouring to establish a market there. I soon came to ***Shannon Grove***, where **Mr. Bury** has made fine plantations and enclosures. The first thing that offers is a fine orchard with a *cider* house built in elegant taste, the plantations and fields between this and the house are very *beautiful*; the situation of the house is pleasant; commanding a view of the ***Shannon*** and of the fine country on the other side between the great bay to the north and **Limerick**. I then went to see the Charter School which was founded by **Mr. Bury**, who keeps it in very good order. This Gentleman's Mother was daughter of **Archbishop Pallasor**, and his Lady being sister of **Lord Tulloghmore**, his son is next heir to that Nobleman, who has no children. I returned two miles in the same way, having the Castle of **Carigaginiel** on a fine high rock near the **Shannon** in view all the way, as I had also from **Limerick**. We returned to **Kildaimon** and struck out of the road we came in, to the south east, and in three miles came to **Adair** on the **Magee**. This place now a poor village, was they say anciently a walled town, and there are great marks of its having been a place of some consequence; in it are remains of a large old Castle, which belonged to the Earls of Desmond, and of three Monasteries; one at the west end of the village, and is called if I mistake not the Abbey of **West Gate**; and in the middle a small church; there is a tower about 30 feet square, which gives it the air of a Castle. Another Monastery is near the bridge, and is called the **Steeple Abbey**; the openings of the 



---

p.116


*cloister* of this and of the third are like Gothick windows. There are several niches in the walls, besides the seats for the *administering* persons; which were probably so many tombs of ancient families: on the north side of the river a quarter of a mile higher, is what they call the Poors Monastery, tho' it is not inferior to the others in building.


On the 30th in the morn I saw the Convents, and went to Church, **Mr. Quin** a Gentleman of considerable estate here, having met me in **Dublin**, invited me to dine with him, I went to his house and lay there, it is situated on the river, the *tide* coming up just to his house.


On the 31st I set out and travelled near the river two miles to **Croom**, passing by the Park and house of **Lord Carbery** where he lives; his Lordship has another very fine park between **Bruff** and **Limerick**. On each side the river at **Croom**, there is an old Castle: We went on three miles farther to **Alakee** or **Athlacha** crossing a stream which falls into the river; and leaving that stream we went eastward three miles to **Killmallock**, where I had been in 1749, as at all the other places I shall mention as seen this day. This is another ancient wall'd town, in which there are if I mistake not, two old Monasteries and as this town *Athenry* and **Adair** had a Monastery or Monasteries in them, and do not seem to have been situated for trade, it is not improbable that the Monasteries built walls round these towns, for the security of themselves and their tenants, who probably built some of the oldest houses in them, with windows of the Gothick arch; and as the Papists in **King James**'s time were ordered to build houses in walled towns, this might be the occasion of building the greater part of the houses the windows of most of them being in the style of that time. I went to see the Charter School near the town, and from that three miles



---

p.117



to **Kilfinane**; where I visited another Charter School; and meeting **Mr. Graves** minister of the place, I dined with him, and rode six miles to **Charleville**.


On the 1st of September I went to visit Dean Bruce who was out of town, view'd the Charter School; this town is finely situated on an eminence which commands a fine view of the Country to the south; it is the estate of the **Earl of Orrery** and the town is chiefly supported by the Dragoons, for whom there is a barrack, and by the *thoroughfare* which is very [*gap: extent: one word*] since the road from **Limerick** to **Cork** is *carried* through this town which before was farther to the east; near **Ard Patrick** I crossed over the hills to the Valley in which the river **Snider** runs, and first came to ***Buttevant***, which gives the title of Baron to the Earl of Barrimore and the eldest son by Courtesy takes that title: Here are large remains of an old Convent as well as Castle. We crossed over the **Snider** and saw ***Doneraile*** to the left and came to **Malloe** famous for its waters, which are on a lime stone and have something of the virtue of the Bristol waters. There is commonly much company here every summer, and they have a Long Room for Assemblies: It is situated on a small river that here falls into the **Blackwater**, which we crossed, and going over the hill we passed by **Sir Robert Deane**'s house, and came to four mile water where I dined, having met in the way **Lady Dean** and **Mrs. Oliver** in their Chariot and six, with both of whom I was acquainted and paid my compliments to them. I came 8 miles to **Cork** finely situated on the river **Lee** which divides above the town and running on each side of it, makes it an Island, as it does also below and forms the *little* and great Island, below which it spreads again and makes the harbour of **Cork** called the **Cove**, near which there is 



---

p.118



lately built a strong fort to defend the entrance of the harbour; the part of **Cork** which is built to the river is pleasant, but most of the streets are narrow and dirty, which makes chairs of great use here, and there are several of them ply in different parts of the town. This See and Church was founded by **St. Finbarr** in the 7th century, to whom the Cathedral is dedicated and is commonly called **St. Barry's**; the See of **Ross**, is united to **Cork**, supposed to be founded in the 6th Century by **St. Facknan** who built there a Priory of **Canons of St. Austin**. This place is situated to the west on [*gap: extent: one word*]. There are six parish churches in the town, here was one Abbey, four Monasteries, and a Nunnery. The History of a Settlement of a tower of a church here like that of **Pisa**, and of their management of it is a great curiosity: there are several Hospitals in the town; but the foundling Hospital is most remarkable, they have in it about 40, between 2 and 300 abroad, they are well clothed and kept neatly. An act passed lately for their changing children with the Poor house of **Dublin**, in order to prevent any persons putting in children, with design to get them afterwards to their own disposal. The Exchange and Custom house here are *handsome* buildings. The County *jail* at the South gate, is a noble building of three stories, all Rustick, and of the Tuscan order, and appears more like a palace than a *jail*. There are in the town 7366 houses, and the souls are computed to be above 73000. There is a great export from this Port of Beef, butter, wool, and yarn, besides a very considerable import of all sorts of Goods.


On the [*gap: extent: one word*] I *rode* to ***Kinsale*** crossing the **Oun Boy** on the road: it is called eight miles, but is a very unpleasant road all up and down hill, and it is four good hours ride. ***Kinsale*** is about a mile long



---

p.119



situated over the harbour at the mouth of **Bandon** river, consisting of one long narrow Street, and one or two over it on the side of the hill. There is a Charter School here for twenty boys, built by the encouragement of **Mr. Southwell**. It is a very fine harbour and there is a great resort of ships in time of war, and this is the only place in **Ireland** for refitting the King's ships. The harbour is defended by a strong Fort called **Charles's Fort**. The resort to this place is so great in time of war, that their leases pay double rent during any war. As soon as I came to ***Kinsale*** I walk'd towards the school, and meeting **Mr. Woodward** who has a Living near, I din'd with him: I set out in the Evening for ***Innishannon*** six miles up the river **Bandon**; this village is pleasantly situated on the East side of the river, having high ground over it, and on the other side is fine hanging ground cover'd with wood: here **Mr. Atherly** has established a linnen Manufactory in all kinds, where I saw several childen apprenticed from the Charter Schools and the workhouse in **Dublin**; on the *height* is a Charter School finely built for forty children which is just opened, and was founded by **Mr. Atherly**'s encouragement. On the [*gap: extent: one word*] I saw these things and went three miles up the river to **Bandon** situated on each side of the river **Bandon**; it is entirely a Protestant town, and they will not suffer a Papist to live in it: They have a great Woollen Manufactory here, if I mistake not, chiefly of Camblets, and now begin to come into the linnen trade. I went to visit **Dr. Brown** Brother to the **Bishop of **Cork****, who was out of town: so I went about three miles in the road to **Cork**, and leaving it on the right went almost directly north through a very uneven Country about six miles to ***Inniscarra***, a pleasant situation on the **Lee**, between two hills



---

p.120



which are not improved. I went to the parsonage house of **Dr. Philips** which is a *beautiful* plantation and fine retirement, but not finding him at home, I crossed the **Lee** again over a large bridge, and came five miles to **Cork**, seeing the Castle of ***Ballincollig*** to the right, of which there are great remains. I went to **Mr. Falconor** my Banker and then to **Mr. Penrose** where I was invited to lodge.


On the 4th I went three miles on the south side of the river to **Riverstown**, a fine improved estate of the patrimony of the **Bishop of **Cork****: I dined and lay there.


On the 5th I set out and came to the river, and going eastward passed in four miles through ***Carrigtwohill***, where is the burial place of the Cotters; in two miles more to ***Midletown***, a small market town and burrough, near a seat of **Lord Middleton**'s, with a fine park belonging to it this is within two miles of **Cloyne**. I went three miles to **Castlemartyr** and saw the charter school for 40 children; founded by the encouragement given by **His Excellency Henry Boyle**, one of the Lords Justices and speaker of the House of Commons, who has a seat near. He has made an artificial water, it may be beyond anything in Europe; for it encompasses the *little* town to the east of this seat, and one may be rowed four miles on the Canal and serpentine rivers. From this place after I had taken some refreshment, I crossed the mountains of **Tallogh** in the County of **Waterford**, having had a fine view of the sea, and of the mouth of the **Blackwater**. **Tallogh** is situated about a quarter of a mile south of the river **Bride** which two miles lower falls into the **Blackwater**; it is a market town and a Burrough, and they have a Barrack here: It is the estate of the **Earl of **Burlington****. At **Curryglass** not far distant in the County of **Cork** is a pleasant seat and plantation, lately **Mr. Maynard**'s but now



---

p.121



belongs to the Crown; the author of the County of **Cork** *says* that there is a fine white clay here with which the park walls are plaster'd and look very *beautiful*. I came in the evening to **Lismore**, which is a village most pleasantly situated: The Castle and Cathedral are on a hanging ground, some of which is covered with wood over the **Blackwater**: From the Castle and the Warren behind the Cathedral is a fine view of the river both ways, of the meadows on each side, of the wood on the hanging ground and of the Cascade from the Salmon *Weir*; one sees the *beautiful* rock of Killree making out like a head to the north; and below that **Cappoquin** and its Castle: To the south a mountain torrent called **Oenshad** falls into the **Blackwater** directly opposite to the Castle through a Glyn or narrow vale, between the mountain, the lower parts of which are adorned with wood, from this there is an opening into the County of **Tipperary**, and a way into that country by what they call **the Devil's Causeway**; on one side of it there is a fine Lough, in which there is the black Trout; and on each side of this Glyn are high mountains and particularly to the East the highest of them ***Knockmealdown***: the Quire part of the Cathedral is very old, built with sort of Pilasters at the corners, and long narrow windows on each side and at the end. It was founded by **St. Carthage als. Mocoddy** who was driven by **King Blathmac** out of the Abbey of **Batheny** in the County of **Westmeath**. He first founded an Abbey of **Canons Regular** of **St. Augustine**, where the Castle now is: He also founded a School or University here, which was afterwards governed by **St. Cataldus**, who in process of time became Bishop of **Tarentum**.[47](javascript:footNote('E750002-001/note047.html')) This Cathedral was 



---

p.122



repaired by **Munchus King of **Munster**** in 1130. The body of the church is a modern building, probably of the time of **King Charles 2d.** The Chapter house is a good room, there are remains of the staircase in it, and signs of a room above in which they might keep the Archives of the Church. In the church are remains of the tomb of a Magrath in 1557 probably a relation of **Bishop McGrath**. The Chapter consists of a Dean, four other Dignitaries and nine Prebends, and it is founded on the rule of the Cathedral of **Sarum**. There are five vicars Choral, who ought to be presented by the Dignitaries to the Dean as they were formerly, and admitted by him. But the Dean puts them all in. The Author of the County of Waterford *says* there was an Anchorite here, to whom **Baleyhausey** or *Anchorites* Town did belong. And that there was a Lazaret or Hospital here, the Master of which was called the Prior of **Lismore**. 'Tis said the Castle was built by **King John**, but soon destroyed by the Irish; and when rebuilt was the place of the Residence of the Bishops till **Miler McGrath** about 1588 granted it and other lands for a chiefry to **Sir Walter Rawleigh**, from whom it was purchased by the **first Earl of **Cork****. There is a Free School here founded by that Earl. **Sir Robert Boyle** was born in this Castle, and if I mistake not **Congreve the Poet**. I lay at Dean Jervais's and on the [*gap: extent: one word*] I *rode* through the old Park of **Lismore**, now disparked two miles to the **Blackwater** opposite to **Drummannah** **Lord Grandison**'s, leaving the old mount or Fort to the left in the way to **Cappoquin**, from which **Lismore** (The Great Fort) has its name and also **Kilbree**, an estate of the Bishop's, where on a hanging ground over the river is an old House, said to be on the site of an old Castle built by **King John**. A *little* further to the west is the rock 



---

p.123



of **Kilbree** already mentioned, it is to the left over the river, and is a glorious situation for a house; and also **Cappoquin** over which one passes by a long wooden bridge; it is a very small town of one Street with a Barrack at the end of it, for one troop of horse: The Castle over the town is a *beautiful* situation and commands a fine view of the Country every way, and particularly of the rich vale to the east, as far as **Dungarvan**. Between this and **Lismore** at **Salt Bridge** north of the river were Iron works and Iron mines near and a vein of Iron runs through the Park. There are at present Iron works at **Araglas** to the west of **Lismore**. I crossed the **Blackwater** to **Drumanna** to the **Earl of Grandison**'s, situated on a rock over the **Blackwater**, where there was formerly a Castle; the hanging ground and wood on it to the south of it is beautifully laid out in Terraces, slopes and walks down to the river which is navigable to **Cappoquin** for large vessels, and the *tide* goes up near to **Lismore**. There is a *handsome* avenue to Drumanna house from the east: To the north of which is first a wood and several pieces of Water, and then a Park and fine enclosures down to the **Phinisk**, which is the bounds between this Estate and Affane; to the south is a new planted wood of many sorts of trees, with *firs* on each side of the ridings, and near the house is a Green, on one side of which my Lord has built seven houses; that in the middle is a *handsome* edifice for an Inn, the other are for necessary tradesmen.


On the [*gap: extent: one word*] I went with **Lord Grandison** in his chaise half a mile to see a new town he has built called **Villers Town**; the design is two streets crossing each other with a square in the middle for a market and chapel; there are 24 houses built with a garden to each of them and his Lordship is bringing in



---

p.124



about eighty acres of Land at great *expense* for pasturage for the town for as they are all linnen weavers they are not to be diverted by farming: Here are above twenty of the Charter boys apprenticed to the weavers; and My Lord settles a Curate here and intends to build a Chapel; this Chapel is since built. One of the Streets is to be *carried* down to the river, at a place where a small rivlet runs into it, on which, above the town, is a very good bleach yard. His Lordship is about to build a wall to enclose the land for a park between what is designed for this town and the other lands which he has cultivated. I walked in the afternoon about the garden improvements, and went to see the houses on the Green.


On the 1st of September I took leave of the Earl and Countess for so that Lady is distinguished, the daughter being made Viscountess Grandison by Patent to discend to her Heirs Male and is married to **Mr. Mason**. I crossed the **Phinisk** on a bridge and came near **Affane** famous for a particular sort of Cherry, something like a white heart, which **Sir Walter Rawleigh** brought from the Canary Islands. At new **Affane** is a quarry of black and white marble; and a *little* below it at **Torrein** **Mr. Nettles** is a marble of many colours mostly Brown, white, yellow, and *blue*. This place is also famous for *cider*; the plantation of apples having been made in these parts, by the tenants of the **Earl of **Cork****. I crossed to the other road leading from **Cappoquin** to **Dungarvan**, leaving the Parish of **Whitechurch** to the right, in which at **Baleylemon** they have good marle, and in digging for it, they found the horns and most of the bones of a *Moose* Deer or Elk, which I saw at the **Earl of Grandison**'s, a rib also was found a mile from **Whitechurch**, thought to be of an Elephant, but possibly might be the rib of a Whale. At **Ballylemon** also there is a quarry of 



---

p.125



fine dove-coloured and white marble, and at **Kilcrump** in the parish of **Whitechurch** is a black marble, which lies deep and is therefore neglected. I left this road and got into the ***Clonmel*** road which crosses the Parish of **Modeligo**, in which I saw some *little* remains of **Mountain Castle** and another entire Castle called **Slady**, both belonging anciently to the ***Magraths***. I came into the road from **Cappoquin** to ***Clonmel*** and passed by an old Redout for soldiers against Raparees now an Alehouse called **Ballinemult** in the parish of **Seskinan**: Ascending the hill beyond this place, I had a glorious view of the fine country of ***Tipperary*** and of the river ***Suir***, which runs towards ***Clonmel***: We crossed here a small part of that County and descended to Four mile water or the **Nier**, at a bridge over it, where there is a small village at which we dined; and crossing the river came again into the County of **Waterford**. This river rises out of the same mountains as the **Tey** which runs by **Killrossanty**, and the **Malon** which runs by ***Kilmacthomas***, and runs into the sea at **Knockanmahon**, and the **Cloough** which runs by **Curraghmore** **Lord Tyrone**'s seat and so by **Portlaw** in the road from **Waterford** to ***Clonmel*** and falls into the ***Suir***. Ascending the foot of an hill, we had a view of **Kilbruantine** a very pleasant seat of **Mr. Rode Green**'s over the ***Suir***; just opposite to it is **Knocklofty** an exceeding fine situation of **Mr. Hutchinson**'s in the County of ***Tipperary***. Near ***Clonmel*** is a *spa* water, not much frequented at this time. About two miles further brought us to ***Clonmel*** on the other side of the ***Suir*** in the County of **Tipperary**, a very pleasant situation and a thriving town well laid out. Here they have a Manufactory of Serges and other woollen goods, the Assizes are held at this place for the County of ***Tipperary***, and at that time great contracts are made for



---

p.126



wool: It was the Capital of the Duke or Ormond's Palatinate of the County of ***Tipperary***, which was dissolved on the forfeiture of that Nobleman's estate. There is one parish Church in this town, and the Church of the Convent of Minorets, is converted into a Meeting house. Near this town is a very neat well regulated Charter School, for 20 boys and 20 girls, founded on a legacy left by **Mr. Dawson**. There is a horse barrack in this town: on the County of **Waterford** side is a *spa* water formerly frequented. I set out for **Cashel**, call'd 8 miles but cannot be less than 12 measured miles. I passed by **Donoghmore** and in sight of the large Castle of **Mocklerstown**. **Cashel** is situated in a very fine Country two miles from the ***Suir***, and at the foot of the hill on which the old Cathedral stands called the **Rock of Cashel**; It is a poor town, but as the new road from **Dublin** to **Cork** is to pass through it, it is probable that will improve the town. There is no certain account of anything relating to the See of **Cashel** before **Cormac King and Bishop of **Cashel**** in 901, who is said to have built that curious old Chapel *adjoining* to the Cathedral, called **King Cormac's Chapel**, which is arched over and adorned with many *little* pillars like the buildings about the time of **William the Conqueror**: In 1134 **Donald O'Brien King of **Limerick**** built a new Church, probably the old Quire, and made a Chapel or Chapter house of the old Church: there is a fine arch now decaying over the middle of the Cross Isle. To the west of the Church and *adjoining* to it, is a building called King Cormac's palace which was the habitation doubtless of the succeeding Bishops. There are remains in the Church yard of a very ancient Cross. This church is built on a very fine high rock, the top of which is cover'd with Verdure and **Archbishop Bolton** made an easy ascent up to it; it commands



---

p.127



a fine view of all the country round about. In 1569 the See of **Emly** was united to this Archbishoprick. In **Archbishop Price**'s time, a few years ago the Cathedral service was removed from this place to the parish Church. There are remains of a Convent here, for there were two, one of Mendicants, and the other of Minorites. Near this town is **Hore Abby** of St. Mary which belonged to Cistertians. A very fine house was begun here by **Archbishop Goodwin** and finished by **Bolton**, with offices for Registry and Library and he left the best part of his Books to it: The late **Archbishop Price** was a Benefactor towards building a Sumptuous Charter School for sixty children. I went to see it, I set out to the west and passed by **New Park**, **Mr. Pennyfeather**'s seat two miles from **Cashel**, and in three computed miles more came to ***Killenaule***, a small poor town near the Collieries of Coal, which go by that name, a swifter coal than the **Kilkenny** coal, and not so full of Sulphur; here I lay.


And the next day the 14th (by the change of the style from the old to New)[48](javascript:footNote('E750002-001/note048.html')) I went forward and travelling five miles to the north came to **Kilcooly** where there is an old Castle and near it the seat of **Sir William Barker** just on the edge of the bog of **Menela**. There is another road from **Killeneaule** to **Kilkenny** by **Callaghan** but much worse. I then turned to the east, and entering the County of **Kilkenny** in two miles came to **Killaghy** and saw near it **Kilrush**, the seat of **General St. George**, which his Brother the Dean who is in remainder has taken from him; this is a very fine County. We soon came to **St. Albans**, a handsome park and plantation of **Councellor Cuff**'s, who has a good house here. Ascending a hill we had a glorious view of the fine Country Northward along the **Nore** beyond **Durrow** and southward to **Callaghan** and all the country below ***Kilkenny*** on the **Nore**: 



---

p.128



and after riding about four miles came to **Kilkenny** most pleasantly situated on the **Nore**. **Kilkenny** consists of two parts, the city to the south, and the Burrough of St. Kenny's to the north belonging to the Bishop. The See of **Ossory** was first fixed by **St. Kiaran** at **Saiger** now **Seir-Keran** in ***Ely O'Carroll*** in the time of **St. Patrick**, which about 1052 was removed to the Abby of **Aghabo**, of which in 599 **St. Kenny** was first Abbot and was there *buried*: in the time of **Henry 2d.** the See was removed to **Kilkenny**: **Bishop Hacket** is said to have built the *belfry* of polish'd marble. There is a fine round tower here, probably built to the honour of **St. Kenny**. The Bishop had houses at Aghore and Freinston, repaired by Bishop Canewell: This Cathedral is looked on as one of the best in **Ireland**. Near it is the Bishop's house most pleasantly situated on a height over the river. There was a Priory on the east side of the town for **Canons** of **St. Augustine** founded by **William Marescall the elder, Earl of **Pembroke****, which I take to have been where there are the remains on a Convent on the east side of the **Nore**; the sides of the church are all window, and it looks very light. There was a Convent of Minorites on the bank of the **Nore**, which I take to be the church lately rebuilt near the bridge. There was also one of Mendicants founded by **William Marescall junior Earl of **Pembroke**** in 1225. There is a free school here with an endowment, if I mistake not of £120 a year, a house and pleasant meadows on the river; and is the only one in **Ireland** that has some face of a publick school; but the prices are risen so high, that it is to be feared it will fall in its credit. This school was I suppose founded by the **Ormond family**, who resided in the Castle here, which is a noble house situated on a height over the river with a hanging 



---

p.129



ground under it, covered with wood. There is a grand Corinthian gate at the entrance of this house, and at each angle in front a noble round tower: it was very finely furnished, and the furniture was bought by one Hacket a Creature of the family, who when he came to take down the hangings and tapestry, found a second *set* under them, which no one knew of, the others being as 'tis suppos'd put up in haste. There are building here, a *handsome* Session house and *jail* of Kilkenny Marble, with which marble the houses are built, and the streets are paved: of this place it is said that, there is fire without smoke, Water without mud, and Air without Fog; the former is not a benefit as the Coal is so full of Sulphur, that people who are not used to it, cannot bear it in a room; but when burnt first in the Kitchen, the Cinders make a good tolerable fire, but it never flames, must not be stirr'd and looks like red hot iron, it makes an excellent kitchen fire: The coal is found in the hills about five or six miles to the north east of the town; and the Collieries belong to **Lord Castlecomer**. The Kilkenny marble quarry is half a mile to the south of the town, and is a very fine one; they can raise stones of any length; I have seen them fourteen feet long in entire pillars and jaumes of doors of one stone; they have Machinery turned by water for sawing and polishing, and formerly they had them even for turning, and made punch bowls, tea dishes, saucers and frames of pictures. The marble is of two or three kinds, the white being mostly made by petrified shells, but there is a sort called the feather marble from some resemblance of feathers. Some of the marble of the County of **Kerry**, is still more *beautiful* than this, in a variety of petrified shells: This marble makes very fine cisterns, which have been *carried* into Italy and much



---

p.130



valued. The park of **Kilkenny** is on the **Nore** and much esteemed for the pleasantness of it; and beyond it are some remarkable Caverns. The Charter School for forty boys is a mile out of the town and is very well regulated. I dined at **Kilkenny**, walk'd to the school, and rode three miles in the evening to ***Bennetsbridge***, on the **Nore** Here frequent camps have been pitched in order to discipline and review the army, particularly one in 1745.


On the 15th I crossed this bridge and went on the east side of the river, and soon saw on the other side a very pleasant seat on the hanging ground over it, belonging to **Mr. Griffith**: I soon after passed by the seat of the **Lord *Ikerrin*, now Earl of **Carrick****, with fine plantations about it, and saw to the east **Dungarvan**, where there is near the Church, one of the round towers. I came to ***Thomastown***, a small market town and Burrough on the **Nore**, to which place it is navigable for small boats: Between this and Ross is another burrough town called **Innisteag**. At ***Thomastown*** are remains of a fine large Church: A mile beyond the town in the way to **Waterford** are great remains of the **Abby of St. Mary of Jerpont**, it was for Cistertian Monks, founded by **Donald King of **Ossory**** in 1180, whose monument is here, as well as that of **Felix O'Dallan**, who transferred the See of **Ossory** to **Kilkenny**; the Abbot had a seat in Parliament. A *little* lower the river [*gap: extent: one word*] falls from the west into the **Nore** which rises at **Kilcooly**, by which I passed out of the bog of **Monela**, then runs by **Callan** a small town which I have been at, near **Lord Disert**'s seat: and afterwards by **Kells**, through which I have passed in the way from **Kilkenny** to **Carrick**, at which place there is a round tower, there was a Priory of **Augustinian Canons**. Going on over the heathy mountain I saw to the west **Knocktopher**, where I



---

p.131



have often been, and where there was a **Carmelite** Convent founded by **James the Second Earl of Ormond** in 1356. In seven miles from ***Thomastown*** we passed by **Luke's Well**, a place of great Devotion, and in seven more came to **Waterford**, a city which stands very pleasantly on the river ***Suir***, having the finest *quay* in Europe, except that of **Messina** in **Sicily** and is half a mile long and of a good breadth. This city was built some hundred years before **Henry 2nd** by the **Ostmen** or **Danes**. The old town was in a triangular form with a tower at each corner, first Reginald's or Ring tower at the south east corner, then it went along by High Street westward to Turgesius's Tower in Baron Strand Street, from which it extended to St. Martin's Castle by Lady lane and so to Ringtower: It afterwards took in all to John's Gate, Stephen's Gate, Patrick gate and to the *quay*, and it is probable the river came anciently to the town walls: and that the pill or mill race from it washed the southern walls: The City was then enlarged by the English; and I observed the old walls to the *quay* were built of large stones, which are a cement of pebbles and must have been brought from the other side, all the Country being of that kind of stone. Near Patrick's Gate was a square Fort by way of Citadel, where the Barracks are now built. The Cathedral called **Christ Church** dedicated to the Trinity is said to have been built by the **Danes**; and Malchus was the first Bishop in 1096. It is a plain building consisting of the body, the Quire, two Isles and the parish Church of Trinity behind the Quire. To the north was Rices Chapel and the Chapter house, both now pulled down: In the former was a curious Monument of the Rices now in the parish Church: On the south side is St. Saviours Chapel, now the Bishop's Court, and St. 



---

p.132



Nicholas now the Vestry and Chapter house; there is also a chapel opposite to the Bishop's Court. The Quire has lately been much ornamented if intermixture of Grecian with Gothick Architecture be call'd an ornament by a Corinthian Altar piece, which is the gift of **Mrs. Susannah Mason** and cost £200;—by a very *handsome* Canopy over the seat of the Mayor and Aldermen, and by the same over the galleries, and the seats of the families of the Bishops and Dignitaries, by making a Gallery to the north for the Soldiers, to the west over the Organ for the Charity boys—by adorning the Galleries with handsome Ballustrades, new seating the Church and paving it with black and white marble, to which besides the white marble the **Revd. Dr. Jeremiah Milles, Chantor of the Cathedral of **Exeter**** as he was likewise formerly of this Church and Treasurer of **Lismore**, gave the sum of fifty pounds:[49](javascript:footNote('E750002-001/note049.html')) St. Olave's and St. Patrick's Church are both paved with black and white marble, adorned with *handsome* Altar pieces. Pulpits and thrones, and all the seats are so disposed, that the people stand with their faces to the east, the men on one side and the women on the other: these Churches were order'd in this manner and adorned under the care of **Dr. Thomas Milles Bishop of **Waterford** and **Lismore****; who published a learned edition of St. Cyril of Jerusalem, and *wrote* a Treatise against **Mr. Dodwell** of the Immortality of the Soul.[50](javascript:footNote('E750002-001/note050.html')) There was a 



---

p.133


**Dominican** Convent in this city, called the *White Friars*, the Church of which is now the County Court house: The **Benedictine** **Convent of St. John**, founded by **King John**, and the **Franciscan** **Convent of the Holy Ghost**, the Church of which now belongs to the French; another part of it is an Hospital for twenty four Popish widows, founded by the **Walshes**. Lastly, St. Catherines Priory for **Canons of **St. Victor****. The Lepers Hospital was founded by the **Powers Lords of Tyrone**, and the lands are now applied to an Infirmary, and £100 a year to ten decayed house keepers; and *adjoining* to it is another Infirmary founded by the late **Countess of **Tyrone****, which are attended by the same officers: Opposite to the Cathedral is built a very *handsome* House called the Apartment, for ten clergymens' widows, and there are two houses more; they have £10 a year; all the Benefaction of **Bishop Gore**; it is built on the place where **King John**'s house was situated. The Bishop's House is a fine building of hewn stone begun by **Bishop Este**, but is not finished. The city Court house and Exchange, the city *jail* and the fish market, are also *handsome* buildings of hewn stone, and the Custom house of Brick, with hewn stone windows. The Charity School founded by **Bishop Foy**, for 75 boys, is also of Hewn stone, a low Decent building, they are cloth'd and taught, the master has £60 a year and the Catechist £15; and there is a fund for binding them out apprentices. **Mrs. Mary Mason** also erected a good building of Brick, with stone window Cases for thirty girls, who are clothed, fed, lodged, taught to read and work. Behind the Bishop's House where the Mill dam was, is a fine walk, planted with double rows of trees, and is called the Mall; just beyond which at the end of the *quay*, is a fine Bowling green on the River. **Mr. 



---

p.134



Barker**'s hanging gardens are very beautiful. **Mr. Wyse**'s Mills are well worth seeing, in which the preparing of wheat to make flower is performed by Water Wheels; he has also a smelting house there, a manufacture of pins and several other works. There is also a Dock in the marsh for repairing of ships with water pipes laid to it. *They* have a considerable trade here to **Cadiz**, sending Butter, Herrings, &c:
  

and bring back, fruit, Spanish wines, &c.: They send butter to **Holland**; the **Newfoundland** ships come here and take in Pork, *coarse* Linnen and other provisions: They send work'd woollen yarn, Raw hides and Tallow to **England**. The Linnen Manufacture is carried on here of late years with great success. Near **Waterford** **Kilbarry** is a parish where there was a Preceptory belonging to the Knights of Jerusalem, and the lands of the whole parish belong to it.


On the 18th I went from **Waterford** to **Tramore Bay**, passing by **Balinemona** the seat of **Mr. Carew**. **Tramore Bay** is about two miles broad, and has an exceeding fine strand, a rivlet falls into it at the east end where the *tide* coming in, makes the north strand, divided from the other by a strip of land and some sandy hills, and it contains if I mistake not near 2000 acres, and when the *tide* is in, it appears like a fine lake. There is a great Concourse of people of late to this place, in the summer to bathe, and to drink the salt water: and My Worthy friend **Dr. Thomas Archdeacon of **Lismore** and Vicar General of the Diocese**, has built a turret here, in a *beautiful* situation, with one large room up one pair of stairs, and great conveniences under it.[51](javascript:footNote('E750002-001/note051.html')) At this bay are a great variety of curious granites, marbles and jaspars, that have been rolled from the sea; some of which I have had polish'd 



---

p.135



and are very *beautiful*; and to the west is a *little* bay called, if I mistake not, **Carol's Bay**, in which I have been informed are many curious pebbles. There is a bed of excellent oysters in the river which falls into the bay, but they are very scarce. On the other side of this rivlet, on the north side of which is a harbour for small craft, **Mr. Wyse** has a small country house, to which one fords the river; on the sands near it, I have seen Asparagus grow wild, as Eringo does also in great plenty. Going along the sea coast towards **Waterford Harbour** are several caves from the sea, with openings from them to the surface above: one of the finest of them is called the Bishop's hole; a *little* within the mouth of the harbour is a very small bay, called white house bay: on one side are the remains of an old Castle and opposite to it, is a pleasant box call'd Nymph Hall belonging to **Dr. John Alcocks Dean of **Ferns**** and left him by **Mr. Henry Mason**: Beyond it is **Dunmore Castle**, and a *little* further **Woodstown** the seat of **Mrs. Motloe**, from which there is a strand to Passage; but before one comes to it in land is **Crook Castle** and a church that belonged to the **Templars**. Passage is the place where ships *lie* that wait either to go up to the town or sail out of the harbour. The *little* town is situated on a narrow slip under a steep high hill. Further on is Faith leg **Mr. Bolton**'s house and estate, on it is Cheek-point hill, from the top of which is a glorious prospect: The **Nore** and **Barrow** *joined* above **Ross** fall into the ***Suir***. Opposite to this place, having made [*gap: extent: one or two words*] what is called the **Great Island**, tho' it is only a peninsula; going on towards **Waterford** is **Ballymakill** the seat of **Mr. Dobbyn**, a very ancient family, opposite to which is the *little* Island, a fine spot of ground of about an hundred acres, there is a Castle on it, but no spring. Inland



---

p.136


**Killure** a Preceptory of the **Knights Templars**, and Bishops Court a ruined Country house of the **Bishop of **Waterford****. Passing **Waterford** and continuing up the river first is **Grace Dieu** where there is an house on a height, a most pleasant situation and beyond it a good house by the water side which belongs to **Mr. Anderson**. About two miles further is **Skilloteran**, a very neat church on a rivlet, and opposite to it is the Charter School for forty children, founded on the encouragement given by the city of **Waterford** and neighbouring Gentlemen. Near this is a very fine slate Quarry, and about half a mile farther in a bottom on a small rivlet is **Whitfield**, a seat of **Mr. Christmas**'s, a small house with a *handsome* Apartment added to it; the gardens are pretty and a proper advantage is taken of the great command of water; **Mrs. Christmas** made a *beautiful* shell-room of a Summer house, in which there are a great number of fine shells, Corals and pieces of Statuary and Grotesque China. Near **Lisnekil church** in an ancient Danish fort were found two urns of Coarse earth, in one there was a black earth or Ashes, in the other a bracelet of pure gold, weighing about five ounces. At the mouth of this rivlet on the ***Suir*** is a pleasant box, late **Mr. Ivies**, now the habitation of **Mr. Southwell**. To the south east of **Lisnekil** is an old Castle called **Butlers Castle**. It is to be observed that all along on this side of the ***Suir*** there is no lime stone, but plenty of it on the other side, except that about **Kilmeaden** they find it in a marle they have there, some of which is in large lumps: but this marle is of such a nature, that tho' it has been *tried* every way, they cannot find it does any good to the land. At **Kilmeaden** just over the water is a small house of **Lord *Doneraile***'s, now inhabited by **Mr. Usher**; there is also a *spa* water at **Kilmeaden**: and **Mr. Wyse** has



---

p.137



lately made a rivlet navigable from the ***Suir*** about half a furlong [*gap: extent: one word*] to Mills he has built for rowling Copper, smiteing Iron and several other works. Going further up the river, close to it is **Mayfield**, the seat of **Mr. May** built *adjoining* to **Rochet's Castle**; near this the river **Clodugh** falls into the ***Suir***, on which about two miles higher is **Curraghmore**, the seat of the **Earl of **Tyrone****, situated in a bottom. The house is grand and *commands* a view of the mountains to the south west. To the west of it, is a fine artificial Serpentine river and walks are cut through a beautiful wood of well grown oaks. **Lady Tyrone** is making a fine Grotto near it, in which there is a grand profusion of curious shells and Corals. They have a piece of Chrystal in this family of which the country people have a notion, that if is put into the water which the Cattle drink, it will cure the Murrain, it is sent for even from distant places for this purpose.[52](javascript:footNote('E750002-001/note052.html')) In a bog near this place, two of those brass heads of an ancient offensive weapon call'd Celts were found, of which so many have been dug up in several parts of **England**. **Lord Tyrone** has rebuilt in a very elegant manner the parish Church of **Clonegam**. Following the course of the ***Suir*** above **Mayfield** is a ruinous house in a pleasant situation over an height *called* **Montpelier**, and belongs to the **Bolton family**. We then come to **Carrick-beg** opposite to **Carrick** in the County of ***Tipperary***; here was a Minoret Convent, the tower of which is remarkable, it is built on the side wall of the Church from one point as in the middle of the wall below. At this place is the church of **>*Killmolleran***, a parish *absorbed* in that of Desert, from which it is called the Prebendary and Vicaridge of **Desert** and **Killmolleran**; but 



---

p.138



the bounds of the two ancient parishes are not known tho' probably it was the stream at **Coolnemuckey**: At **Carrickbeg** is a large stone bridge over the ***Suir***. In a quarry of soft stone above this place are many Dendrites, formed by the shooting of some minerals, but they easily wash out. To the south at a distance from the ***Suir***, is the large parish of **Mothil**; near the parish church are remains of an old Convent of Cistertian or Augustinian Monks. **Coolnemucky** on the ***Suir*** is an old Castle of **Mr. Wall**'s, to the East of it I saw formerly an oak standing called the Blahoge, the trunk of which was about ten feet diameter, and the boughs spread as it is said, over near an acre of ground: On the side of the hill to the south of ***Coolnemucky***, is a fine plantation of 20,000 *firs*, which thrive much: A *little* further is **Churchtown** the seat of **Mr. Disney** on the river where there is a ford, and there is another about three miles higher, and on a river a *little* beyond the Church of **Desert** is Glyn a house belonging to **Mr. Congreve**, formerly a Castle of the **Everards**: At **Bolenhendeport** upon the mountain, *says* the Author of the County of Waterford, was an Abby, rather a Convent of **St. Madock** for **Canons Regular** of **St. Augustine**. On the first mountain are the houses of several gentlemen farmers, who have small estates here, mostly the **Powers**. This flat on the top of the hills is a pretty good country, and extends two or three miles to the high mountains of **Cummora**, which stretch near as far as **Dungarvan**: on the top of them I have been informed, is a large Lake. This country and the eastern part of the Barony of **Decies**, is called the **Powers' Country** because it was mostly inhabited by people of that name. Within two miles of ***Clonmel*** is an old Castle, if I mistake not, called **Tuchencore**, belonging to **Sir William Osborn**: about two miles 



---

p.139



 
above ***Clonmel*** on the ***Suir***, they find excellent marle, and from it the estate of **Mr. Moore** is called **Marlefield**. As I have before given an account of this country, as I travelled through it as far as **Drumanna** and **Villerstown**, I shall go on with it to the south from those places. And first on the west side of the **Blackwater**. To the west of **Tallon** is the Castle of **Lisfinny** formerly belonging to the Earls of Desmond. Towards ***Youghall*** on a rock over the river is the Castle of **Strancaley**, from which there is a passage cut through the rock to the river; there are traditions of the **Earl of **Desmond**** confining people here, leaving them to perish, and seizing on their Estates, on which part of the Castle and rock were blown up. Lower are the Castles of **Temple Michael** and **Rhincrow alias Kilcrow**, of which there is a tradition that it was the place of the **Knights Templars**. Near this is **Balyntray**, the house of **Mr. Smith**, opposite to which is an island called **Der Inis** and sometimes the **Isle of S. Molanfioe** or Molanna, from a Convent there of **Regular Canons** founded by that saint in the 6th Century. Here they say **Reymond le Gross** was buried, who in the time of **Henry IId.** had a great share in the Conquest of **Ireland**. Near this is the bounds of the County of **Cork** round by a rivlet to the south: Going on the other side of the river we met with a large Castle, said to be built by **King John**, and is called in Irish **Clough**, I should before have mentioned that on the **Phinisk** north of **Drumanna** is **Bewley**, where there are ruins, said to be an house of the **Templars**, but there is no account of it. At **Ballina Multina** there is a quarry of good slates. About **Clashmore** the river **Lichey** falls from the east into the **Blackwater**, on which is the Castle of **Balyheny**; At **Clashmore** there was a Convent of **Canons Regular** founded in the 7th Century by **St. Cronan Mockoa**.




---

p.140


**Kinsale beg** is opposite to **Youghal**, where the church was roofed and covered by **Bishop Milles**, but all the Protestant inhabitants leaving the Parish it was not finished. Near it is **Prospect Hall**, the seat of **Mr. Bernard**, from which there is a fine view of ***Youghall*** on the river which is built up the side of a hill, a *little* like the situation of **Constantinople**, to the south west was a fine Strand four miles long, but by some accident was spoiled for riding: **Pilestown** is the estate of the **Walshes** where judge Walsh lived, who is supposed to be the author of the forged Commission in favour of the Irish Rebels, in the time of **King Charles the First**, according to the Author of the County of Waterford. We now leave the river and turn eastward along the shore and soon came to **Ardmore**, the great (head or height) from a head of land at this place; It was anciently the See of a Bishoprick founded by **St. Declan** of this county who was the first Bishop, about the time of **St. Patrick**: They say, he founded a Monastery here, which might be at the old church over the Sea-cliff; where there are remains of a very ancient building; the Cathedral probably was where the present parish church is, at the west end of which are some curious old reliefs of Saints, of Adam and Eve, &c. the chancel only is covered for the Parish church. Near it is a small square building where **St. Declan** is *buried*: there is the finest and best built round tower here in the Kingdom, fifteen feet in diameter and above a hundred high, it is divided into five parts by four water tables, there are at top two or three beams of timber for hanging a Bell, for which use it certainly served, there being very plain channels in the stones at the bottom of the door worn by the ropes. There are also remains of an old Castle here; on the head of land were formerly lead



---

p.141



mines, and searching of late for ore they found they were worn out, This parish extends a great way into the mountains to the north and four miles to the eastward. There is a great **Pattern** held here on **St. Declan**'s day and penances are performed by creeping under a stone, concerning which they have some strange tradition: old mines also are seen over the mountains, which if I mistake not, are said to have been Iron mines. They have a fine Strand here and a pretty good fishery: Between this and **Dungarvan** is **Rineogonah** parish, from which one may pass over the Strand to **Dungarvan**: but the more common way is over very dismal mountains, which are near on a level with the ground towards the sea, but there is a great descent from them to the vale in which **Dungarvan** is situated on a Bay into which the small river of **Colligan** and **Briskey** fall, the latter is a great torrent after rains. It is situated on the south side of the river and is a good fishing town, and famous for an export of potatoes to many parts of **Ireland**, and I am told they export the yolks of eggs *boiled* hard and salted for **Spain** to be eaten as sauce with their salt fish; there is a bank about ten leagues from **Dungarvan**, where they catch quantities of Hake and Haddock, Cod, Ling, and many other kinds of Fish. They have also a bed here of very large oysters. There is a barrack built in the old Castle, of which there was formerly a Constable: on one side of **Dungarvan** is **Shandon**, the seat of the **Hores**, and on the east side **Clonkasteran**, **Mr. Nugent**'s; opposite to the town on the north side of the river is an old Convent of Augustinian Eremites, founded by the **MacGraths** in the thirteenth century. Going along the coast eastward, **Clonea** is a flat country, and under the Strand is a bog, the turf of which is disagreeable to the smell when it is 



---

p.142



burnt within land, in **Killrossanty** are the Castles of **Barnakill** and **Baleykeroge**. In **Stradballey** at **Ballivony** is a large building and two remarkable wells, which communicate with each other and they are fed by water, brought by a Subterraneous passage: There is a descent by steps to one of them: it is thought to have belonged to the Knights of Jerusalem. At **Kilmacthomas** is a strong Castle of the **Powers**, and a *little* farther about two miles from the sea is **Newtown**, laid out in Streets, and paved and a few houses built, but now ruined all by **Mr. Greatrakes**. Going along the Coast is **Killarimeden**, where on **Lord Ranelagh**'s estate some lead mines have been discovered, which did not answer, but on **Knockanmaham** the Bishop's estate they have worked some copper mines with good success, tho' now they say the vein is grown very small and hardly worth pursuing. I saw some ore which look'd like glass and like broken bugles and some pure native copper: Between this and **Tramore** is nothing remarkable, but **Island Ikane**, so called from very small Islands opposite to it, about two miles from ***Tramore bay***.


On Monday October 2d 1752 I set out from **Waterford** to **Ross** and crossed over to the County of **Kilkenny**, in about two miles I passed by a small *cairn* with a Cross on it, and had soon to the left a rocky hill of that cement of pebbles, chiefly of the Alabaster kind, which abound all over the country and of which the walls of **Waterford** are built; after riding about two miles farther, we passed by an old church call'd **Kilmacoivow**: we had a fine view of the river ***Suir*** and then of the **Nore** and ***Suir*** and going up to a height, I had a delightful prospect of the mouth of the harbour, of the winding of the **Nore** and of what they call the great Island, which is only a Peninsula. We came to the **Nore**


---

p.143



and crossed it into the County of **Wexford** to **Ross**; all the Country we passed over is a union of Vicaridges in the gift of the City of **Waterford**. **Ross** is very pleasantly situated on the river and on the side of the hills over it, a rivlet runs down the middle of it through the street in a *little* hollow between the two hills; it is encompassed with a wall defended by turrets; on the top of the hill is the large church of the Convent of the ***Minorites***, the east end of which serves for a Parish Church; there is a *handsome* tower to it, which commands a view of the Country, of the **Barrow** falling into the **Nore** about a mile higher, a fine flat on the river below, a *little* like the Campo of Scio, except that instead of wall'd gardens, it is laid out in beautiful meadows. In the church they show the tomb of **Rosa Marra**, who they say built the Town walls and the Church, and near it is what they call the tomb of her son, who being drowned as they say, she built **Hook Tower** at the mouth of the **Harbour of Waterford**. Under the south cross Isle are two or three vaults which are open. The body of the church is cover'd with lead. There is a good Town house here, built of a very fine white mountain stone or Granite. The *quay* is a most pleasant walk. Half a mile from the town in the road to **Inniscorthy** is a Charter School for twenty boys and twenty girls.


On the 3d I set out and went about a mile to the south in west in view of the river, and leaving the road to **Ducannon Fort** struck into the road to **Nash** **Balligarvan** and **Clamines**; I went near **Slea Quiltah** which is over the river, in about a mile we came to **Castle Terri** [*gap: extent: one or two words*] and soon came to **Aglamau** and in half a mile further to **Dunmain** **Mr. Beyley**'s having lost the way to **Nash** further to the north, but came into it at **Balligarvan**. The house of



---

p.144


**Dunmeen** was the habitation of **Lord Altham**, where it is said he parted from his Lady, and when afterwards a dead child was born of one of the name of Esther, they afterwards came together, and then it was, as I understood that it is said she was delivered in the house of **Mr. Annesley**, who now again sets up for the estate and title.[53](javascript:footNote('E750002-001/note053.html')) We soon passed near Abbey **Kilbrayney** belonging to **Mr. Cliff**: and farther to the east saw on a height **Brianstown** **Mr. Tench**es; we came in half a mile to **Castle Boley**, and in half a mile more to **Dungulow Castle** and soon after to **Clamines**, which they say was formerly a town of trade, tho' there is now only one house in it, but there are three old towers or Castles remaining in it, one of which is near the Parish church of **St. Nicholas**, and in it was an arch'd chapel with an apartment over it. The other two are in a line, and they say there was a row of houses between them and another row built so as to make a street, and part of the Cross of the Market place is remember'd as standing: Just over the river are remains of a Convent, which I was informed was of **Augustinian Monks**; near it is **St. Marie's chapel**: Just above, the **Blackwater** from the west, and **Folkes's mill river** from the north unite, and make the river of **Clamines**, which lower is called the river of **Bannoe**; the *tide* comes up here making a sort of a bay and at low water they cross over on a kind of a Causeway they have made, but the water comes three or four feet over it: This is a Burrough, **Mr. Annesley**'s estate, but the Burrough is in **Lord Loftus**. I here dined on the provisions I had brought, and a dish of fish the Farmer provided for me, of the white 



---

p.145



Trout and Plaice, the latter very *little* inferior to Turbet. He had a son who is dumb, but very sharp in country business and has a very strong sense of Religion. I here left my horses to cross over to go to **Bannoe** and took horses to ride four miles south to **Fethard**; Having travelled about half way I came to the old Convent of **Tintern**, turned into a mansion house of the **Colclough**'s; the church *was* large with a great tower in the middle, the Chancel part was converted into a house with three floors and chimneys, of which I never saw an instance before: I was informed that this family came over in **Queen Elizabeth**'s time, that an Ancestor marrying a Papist went over to the popish religion, but in the present is a Convert who has fixed a Spinning School here and a linnen Manufactory and built a *little* market house in the village. I came to **Fethard** pleasantly situated on the north side of a small river, about a mile from the **Bay of Bannoe**. It is a Burrough belonging to **Lord Loftus** who has built a *little* town here; It was a *manor* of the Bishop of ***Ferns***, but exchanged for another Estate. The Castle was the Bishop's house*,* one of the name of Ram was the last that liv'd in it: It was afterwards the Mansion house of the **Loftus family**. There are remains of an old chapel and of a building which they say, was the Bishop's Study and that there was a Terrace to it from the Castle: There is a turret near the town built like a Castle, which is on the Glebe, and is supposed to have been the Parsonage house: In this bay there is a small oyster bed for **Lord Loftus**'s use; I had been formerly at this place and the places I shall describe.—Bag and Bun a mile to the south east where **Strongbow** landed in the time of **Henry 2d.** in a *little* bay made by that head and the head to the north of it at the mouth of **Fethard** river. It is said he came with



---

p.146



two ships, one named Bag, the other Bun; there is a double entrenchment round it: A narrow strip of Land extends to the south on the east side of the harbour of **Waterford**, on which stands a Light house called **Hook Tower** and there being a place call'd **Crook** opposite to it, 'tis said that on landing the General declared he would take **Ireland** by Hook or by Crook. Here is Loftus Hall the seat of **Lord Loftus** a descendant of **Primate Loftus**, no tree will grow above the shelter of the walls; the mulberry tree thrives best of any with that shelter: This strip of land is exceeding rich, as it is constantly manur'd by the spray of the sea. About two miles farther to the west is **Duncannonfort**, which was built to command the passage up the river, the lower works are cut out of the rock, and the channel being close to it, no ship can go up but must be within canon shot; some soldiers are always here in Garrison; near this fort is a very good chalybeat spring. **King James** had a ship ready here in case of any disaster, and after the battle of the ***Boyne*** he lay in **Dublin**; and came here the next day and embark'd for **France**. About two miles farther is **Ballyhack** opposite to **Passage** and under the hill in the same manner; here are some great Fairs held for tame fowls of all sorts which sell very cheap, as also white *coarse* frieze at low prices.


On the 4th I left ***Fethard*** and walk'd a mile on the south side of the river to the Mole, in which a vessel of an hundred tun can *lie* safe, but in a storm a ship cannot be secure abroad, except it may be from a westerly wind. I crossed over in about about half a league to **Bannoe** and landed on the strand at that creek of land which *joins* what they call the **Island of Cannoe** to the land here they say was the old and safe entrance when **Clamines** was a town of trade; but now the entrance



---

p.147



is to the west of it, and is *choked* up by several barrs of sand that would make it very difficult, for a ship to pass with safety when the *tides* are high: This Peninsula *is a* fine low round hill covered mostly with corn and appears very *beautiful*. There are only three or four houses at ***Bannoe*** and ruins of a good old church, in which there is an old Font, a tomb with a Latin inscription on it, in the old character and a stone coffin with a hole cut in it to receive the head. This is in the Barony of ***Bargy***, which as well as that of **Forth** is a great corn country, insomuch that they say these two have sent some years from **Wexford**, as one told me 140,000 barrels of Barley, that is half that number of quarters. These countries are entirely different from any other part of **Ireland** exceedingly well inhabited, especially in and towards the Barony of **Forth**; a gentleman's house is seen almost every mile, and besides Villages and Hamlets one sees a house at every ½ quarter of a mile distance, the farms being from five to sixty acres and mostly above twenty, the people neat, well dress'd and very honest. The Barony of **Forth** are a Colony from **England** about the time of **Henry 2d.**, and they are so wedded to their own country, that they have not gone much out of it till of late years, they are become so very populous that they now go to **Newfoundland**, to **England**, and also to harvest to many parts and take farms in ***Bargy*** and about ***Enniscorthy*** where they have manure of marle, for having been used to those improvements which are the gift of nature, they do not care to go where they have not either lime or marle, and this has raised the price of land very much in those parts: In ***Bargy*** which is not altogether so populous, there is a greater appearance of wealth; notwithstanding in **Forth** they live as neat as can be on such small farms and keep



---

p.148



all clean about 'em, their food is Potatoes, barley bread, Bacon, cheese and milk; at the great festivals they have the old English way of making a feast; inviting their friends and their neighbours, the Landlord and the priest, and they have beef, mutton and pudding in great plenty: as they sow horse beans very much and grey *peas*, so they eat both the one and the other with bacon dry as well as green. Near the sea they manure with sea weed, sowing every year and manuring every year, and change the grain, Barley, oats, beans, *peas*, but no wheat; what they want is bought at **Wexford**. If they lime it holds nine years and marle I believe the same. As to their particular Customs, it has been said they go to bed in the middle of the day, which they might do formerly; and now, as the Irish, they *lie* down for an hour in hot weather: All contracts are transacted by exchanging money, and so the contract of marriage is made here; the young man goes with his friends, gives the woman a piece of money; and it having happened sometimes that among people not of good character consummation has ensued, this has been the ground for saying that it was commonly so, and that they married in form afterwards. We went on close to the sea side; in two miles came to **Cullingtown** and soon after to **Bali Teague Island**, as it is called, tho only a Peninsula it is a warren and is a long strip extending westward, and at the west end of it the sea enters and makes those bays to the north of it, which are called **the Broadwater**; in half a mile we came to **Coolhill Castle**, and in a mile more to a *little* town called **Duncormuck**, where there is a church and a bridge over a rivlet, I saw **Kai** **Mr. Wilson**'s to the north, and to the east of **Ballyhenny** **Mr. Vigor**'s; I then passed by **Kilcooly Castle** and rivlet, and observed a singular building on it, like a small



---

p.149



house, this castle seems to have been destroyed on purpose to get the *lime stone* out of it, for from this rivlet, if I do not mistake to **Bridgetown** they get a reddish lime stone, for which they dig in pits, finding it in pieces mixed with the soil, and this has made this country very populous, probably by Colonies from **Forth**. In a mile we came to **Baldwinstown** where there is a Castle and rivlet, and all about it is great plenty of lime stone, which they carry to the distance of four or five miles, they make kilns of sods in the field they would manure and build up the lime stone in a Cone, and burn it with furze and the old kiln remains till they want to make use of it again; but when once a field is arable they keep it for a long time under corn by manuring it again; for in all the road to **Ladies Island** I saw only one piece of fallow, opposite to this part are the **Saltee Islands**, which abound in rabbits and sea birds, there are good springs in them but they are not inhabited. In a mile I came to **Bridgetown**, where there is a large bridge over the river; near it is the Church of **Mulranchy** in which parish it is: in the Church yard is this inscription on a tomb—

> 1. Here *lies* a jolly merry blade
>   
> Who's gone;—but now he's but a shade
>   
> To teach the Ghosts a Masquerade:
>   
> But Pluto likes not such a Guest,
>   
> Bids him depart and go to RestWilliam Hoskins, Dancing Master, 1748.
> 




The estate on this side of the river belongs to the **Ivery family**, who set leases of lives renewable for ever to Protestants, and then sold the estate: so that there are as they say more protestants in this Union, than in all the two 



---

p.150



Baronies of ***Bargy*** and **Forth**; that is I suppose Gentlemen's families excepted; however that may be, there are, as they say, about fifty families, and they have all sorts of trades and seem to be very happy and wealthy; and truely the face of these two Baronies appeared to me like an enchanted Country, so different from anything I had seen indeed anywhere. I took some refreshment here, and in about two miles came to the **Bridge of Bargey**, where there is a Castle; here I came into the Barony of **Forth**, the miles before were so long that three make about five, but in **Forth** they seem to have introduced the English mile, for here I found the miles very short: They call it six miles to **Ladies Island**; and here I saw the marle pits, for manuring the land: I saw **Hia Castle** about a mile from ***Lady's Island***, and at the same distance passed through a village called **Broadway**, and passing over a bridge near an old Church, I observed just opposite to the Island the white sand which is famous here, it is a stratum a foot below the surface, and is carried to all parts for the use of sand boxes,—but they have the same sort on the sea side to the east. ***Lady's Island*** is about a mile round, it is now become a Peninsula: one sees where there was a fossee for the water to pass, and at that place there is a Tower called **Maidentower** which has settled on one side, the foundation appears to be laid on the green sod; here they say was a Draw bridge, there seems to have been a wall built on each side to this tower, and there is a Causeway of large stones to it, to pass over when the Lough was full; within this and about fifty yards is a Gateway and another wall built at about the same distance within; that is the old church, where there is a font of red Granite of which there is great plenty in these parts, there is also in a nich an alabaster



---

p.151



statue of the Virgin and our Saviour and before it an old brass Cross, with one of the four Evangelists in each of the ends of it. This is a place of great devotion among the Roman Catholicks, probably set on foot by the English Colony, that they might have everything within themselves; and they come to do penance here by walking once round the Island barefooted, and three times round the Church and sometimes they perform this three times over, and some on their knees: The tracks of their feet is seen all round the Island; there is an enclosure by the church for the accommodation of pilgrims, who come mostly between the Festival of the Assumption in August, and that of the Nativity of the V. Mary in September: and all the roads are exceeding fine in these parts. But the Lake here is a natural curiosity, it rises so high in about seven years, that it would overflow the inland Country round it; and then three or four hundred people come in and mark out in the sand banks to the south west a fossee about an hundred feet wide and begin to open it in the middle, narrowing it as they go down, they then open it to the sea and at last work upon it towards the Lake if they find the water coming they must instantly leave it, for it gushes out as a great torrent and falls down in a Cascade into the sea, the bottom of the lake being about ten feet above the surface of the Ocean; sometimes it breaks away the bank at night, but if it happens by day they take great quantities of fish, mostly Plaice; but if it goes out by night as it did the last time they loose the fish: the first high wind fills up the opening, the lake fills slowly, as it leaks out for some time at the place they open, but when that is closed up with the slime and earth from within, it fills faster, and in about seven years begins to overflow the lands; the water with the spray of the sea is brackish;



---

p.152



great quantities of wild fowl *lie* on it. I saw the black Gull and green plover, for this Country is famous for Wild fowl; the widgeons are excellent, but the best sort are call'd the Wynniards, so also is the *Barnacle*, the first go inland to the bogs and breed, the Barnacles go to the parts from which they came, to the north, and are seen by the Ships at sea northward with the *tide*; when they are attack'd by Eagles or Hawks by a wonderful instinct, they gather all together and keep beating with their wings and raise the water, so that the bird of prey cannot see to attack 'em, but if any one is disabled and cannot close with them, they are surely taken; they have bounds of furze bushes round this Island to *lie* unobserved and shoot at them.


I set out on the 5th and went two miles to **Carne** village and Head, where one **Mr. Pallasur** lives, the Landlord of the place: **Carnehead** is the south east point of **Ireland**, and makes out to the south in Rocks of Granite, chiefly of the red kind, such as at the Cataracts of the **Nile** of which the Obelisks were made, some of it is greyish in large veins like some in **Cornwall**. I went on to the point which is covered with *mussels*, that fix to it with their beards, there are also welks and limpets on these rocks, and a boy seeing me walk on them came and grop'd for Crabs, and I observed he knew every hole tho' it was under Water; the seals also came very close to the rock and I whistled to them, to which they seemed to give attention, but when they saw me they div'd. I then went along by the sea side northward passed by Carne Church and afterwards St. Margaret's; Major Nuns being a great Landlord in these parts, then by **Baley Trant** **Mr. Hughes**'s, and by an old Church; I went along the Strand for some way, and saw the seals lying out of the water on rocks about an hundred yards from the waterside, they



---

p.153



took no notice of any noise I made to frighten 'em, but when I whistled their whole body was in agitation, as if sensibly affected by it, we saw the heads of others in the water near them which I took to be young ones. In another mile we came to **Balihiar** and at the same distance to **Ballygeny**, in half a mile near **Kilroan Castle** and saw inland **Brinikan Houli**, and **Kilstoran Church** in repair and ***Hill Castle*** and so came to ***Rosslare***, where I dined in a Cabin on what I had brought with me; having travelled on a bank over the sea for about three miles the Coast here making such a turn that we had the sea to the north of **St. Eblin's Point**, we passed to the south making a great shallow bay with the land of **Wells** in the way to **Gory**. I came some part of the way on the strand, as I might have come all along but as I had no view of the country I chose to ride on the Cliffs over the sea which are a kind of *blue* clay with herbage on them, the sand to the southward as well as here being all white, and there is a great variety of Granite among the pebbles on the beach. I *rode* a mile and half farther northward on the point to **Whitehouse** **Mr. Boyd**'s, where in the *warren* on the sandbanks I saw the dwarf withy. I observed them making ropes with rushes twisted with the same kind of instrument I described before, which is here call'd a Crook: At the end of this point is what they call the Fort, where a Custom house officer resides. We passed again near ***Rosslare Castle*** and in about a mile passed by **Grange**; in about two miles we came to **Clonck** where there was a **pattern** or rood, and I saw the young men playing at hand tennis: I observed the women were dressed extremely neat with their short cloaks of cloth. In a mile we had **Kileny Castle** at a *little* distance Mr. **Mr. Harvey**'s, and in another we came to **Kilau**, where there is 



---

p.154



a rivlet, and here they dig very good Lime stone in quarries: I was told also that they are in search of a rich mine in this place: We had gone since we turn'd our faces to the East under the mountain or hill of **Forth**, which extends westward for seven or eight miles, the foot of it this way is rocky and I observed from this place to **Wexford** it consists of a reddish stone; we came in another mile to **Wexford**. The common people of the Barony of **Forth** are mostly Roman Catholicks, and I shall conclude this Barony with some account of their language which is the English of the time of **Henry IId.** and comes pretty near to **Chaucer**'s. They now indeed almost all affect to speak good english, and do speak it with a very good accent, and I met but one who did not speak tolerable modern english, but they make use of some particular expressions, and many of them talk very broad. I took down some of the words and expressions.


1. Right well: very well
2. Broad way: High way
3. Ichas: I was
4. Cal: Horse
5. Cales: Horses
6. Kine: Cows
7. Kew: Cow
8. Well e new: Well enough
9. [54](javascript:footNote('E750002-001/note054.html')) Ichas our ladies Island (Ilone) last yere or Vorn yere.
10. Wast ere in Divline? Dublin.
11. Ichas nere in my lieve. But if Ish live shall go to it fiste March.
12. How old art thou? Fourscore going on five.
13. God Almighty keep thee saf upon zee and Lone.
14. Keep you your health and send you well abrode and better home.
15. Just before the downing.
16. I had a good friend going alsong with me and I did not heed it.



When they come in old age what kin is them upon 'em. This last I cannot explain tho' I *wrote* it down.
  

Wast ere upon Mountain a Forth? this is the hill I *mentioned* near **Wexford** of which they tell a story of a 



---

p.155



person who was going to it and had never been out of the Barony and finding it a great way, return'd, and said that such a one had been in **France** and **Spain**, but was nere so far off. And another who seeing the prospect from the top of it was struck with astonishment and said what a weid worn this is. What a wide world is this. And tho' the difference is so *little*, yet when I heard it spoken I could understand very *little* by reason of the different pronunciation.[55](javascript:footNote('E750002-001/note055.html'))


Between **Grenon Point** I have mentioned and **Kane Point** north of it, is the entrance to the **Bay of Wexford**, which extends southward like a great lake, just opposite to the entrance is an Island called [*gap: extent: one word*] with a Castle on it the town of **Wexford** is situated on the south side of the bay on the angle where the land turns from the north to the west, and a cape extending towards it from the north, it is there only a mile over, opening to the west in a large bason, which appears like a fine lake, with high ground round it beautifully improved with plantations of wood, and particularly **Sir Arthur Gore**'s **Kilpatrick** to the north west, and **Athtraman** **Mr. Stevenson**'s. **Wexford** consists chiefly of two streets, one on the flat, the court and gardens behind the houses extending to the sea, so that there are only two piers built out as *quays*, the other street is over it on the side of the hill: The Streets are very narrow, and there is a wall built round the town which is near a mile in length and the town may be about a furlong broad, the houses are mostly mean buildings, for it is a town of no great trade, by reason that there is a dangerous barr at the entrance of the harbour: The chief 



---

p.156



trade is an export of corn, and an import of deal boards and some wine, it is the nearest land to **England**, being about eighteen leagues from **St David's Head**, **Wicklow** is about the same distance from the head of **Carnarvonshire** which is seen very plainly from **Bray Head** and from the Mountains of **Wicklow**, whereas **Holyhead** is about twenty leagues from the **Hill of Howth** near **Dublin**, so that there have been thoughts of having packet boats from **St David's** to **Wexford**: This is the market town of the south west part of the County and especially of the Barony of **Forth and Bargie**: There is one church in service St [*gap: extent: one word*] the other old churches within the walls are **St Oulak's**, **St Patrick's** and **St Marie's**. Out of the town **St Peter's**, **St Michael** and **St John**, I saw also in the principal street **St Iver's** a sort of chapel with a saxon door to it. Besides these there is a church call'd **Selsker** with a very large tower in the middle of it, which I suppose is that of the Priory of **St Peter and St Paul**, de Selster for **Canons Regular** of St Austin. **St. John** is probably the Priory of St John and **St Bridget** founded by **William Marescall Earl of **Pembroke**** for Knights of the Hospital, of this there are hardly any remains. A *Friary* of **Mendicants** is also mention'd as founded in the time of **Henry IId.** There is a good Courthouse here for the Assizes which are always held at this place, it is esteemed one of the cheapest places in **Ireland**, and they have great plenty of wildfowl in the season, especially widgeons and that kind of them call'd wyniard which are thought to exceed the wild duck, they have also Barnacles: The reason why the market is so cheap, is that it is a nook of **Ireland**, and by its situation and rivers is cut off from a convenient communication with other places. The south supplies 'em with barley and oats, beans and *peas*, the north with wheat, and all 



---

p.157



the country round with tame fowl; the sea with plenty of fish, especially oysters, for which they are famous. There is a very good chalybeat *spa* here which purges by urine, it is at the west end of the town, and there is a walk and long room, formerly much frequented.


On the 6th I crossed over the broad ferry, there is another higher up across the river **Slany** which leads to **Inniscorthy**, and the navigation up that river is very pleasant: there are three roads to **Gory**, one close by the sea, another on the high land over it, and the third the high road I went in, which is the farthest to the west. In a mile we passed by **Tramore Castle** **Mr. Preston**'s, and soon after by **Castle Bridge**, in about three miles we passed over a rivlet called **Arbrohan** and a little further had **Newfort** **Mr. Kenny**'s to the right: half a mile further we passed **Carclough** a hamlet and rivlet, and going as much farther came to **Ballinemona beg**, where about five feet below the surface they have a good manure of sand, full of broken pieces of shells, and beyond this they find in the fields a sort of sparr, which is red, *blue* and white and make use of it for mending the roads; In another mile we came to **Oula**, where there is an old castle, and a rivlet rises here from four or five streams, which come out of the foot of the hill, and on the side of the hill they have a quarry of rough building stones; this is nine computed miles from **Wexford** and half way to **Gory**, and here I dined. In a mile we came to **Killiguian** rivlet and a mile farther to **Wells**, where **Mr. Doyne** has a large brick house. From this place we had a view of a fine vale to the east having a high ground between it and the sea; and all along this vale is a good marle: in half a mile we passed by **Bayley Ray** **Mr. Bolton**'s, and as much farther through a Hamlet called **Bally Edmond**, where there is a rivlet



---

p.158



also; a *little* farther we passed **Ballinatra** hamlet and river, and saw **Mr. Lindon**'s [*gap: extent: one word*] to the right and several other Gentlemens' houses, and descending into a fine vale which forms a sort of Amphitheatre, encompassed with hills and all well wooden and finely improved, we had to the right a wood and house of **Lord Anglesea**'s called **Monroe** and came to **Balliconon** a large village, where there is a church in repair; I then passed the river which runs through this vale, and *rode* over **Ballinmenah Hill** to the vale in which **Gory** stands to the south west of the hill **Tarah**, which like a promontory is seen from the Barony of **Forth**: on this hill we passed over I saw many red stones like the jaspar on which the ancients frequently cut seals, a piece of which I took with me, to have it polished and see the nature of it. **Gory** is a very small neat town, consisting of one broad street about a furlong in length; this with two other *adjoining* parishes belong to the Deanery of **Ferns**, and there is a neat small church here. **Ramsfort** is not a quarter of a mile from the town, the seat of **Mr. Ram**, who is building a grand house of six rooms on a floor, all of it except the grand front is built of the mountain stone or Granite brought from the hills about **Agherin** on the river of **Arklow**, it has in it a sort of silver mica and looks as well as fine white freestone; the grand front is of brick with window and door frames of this stone; there is a fine avenue and plantations about it and a large park. Six miles south west of this place is ***Ferns***, which I had formerly seen, there are great remains there of the Bishop's Castle and other buildings; Branduh King of ***Leinster*** gave **Ferns** to **St. Edan or Moedog** the first Bishop of it and made it an Archbishoprick and the metropolis of **Leinster**. The Bishop was after this for



---

p.159



some time called Bishop of **Wexford**, that is probably of the County, and then without doubt after the Archbishop of **Dublin** was made the Metropolitan.


On the 7th I set forward and in a mile saw **Balinatra** to the left **Mr. Esmonds**'s and farther on **Castletown** to the right, **Mr. Masterson**'s, and in four miles from **Gory** came to a good village called **Coolgrany**, and coming into the County of **Wicklow**, in three more came to **Arklow** Charter School for twenty boys and twenty girls on **Lady Allen**'s Estate,[56](javascript:footNote('E750002-001/note056.html')) which I visited and went on a quarter of a mile to **Arklow**, a poor fishing town, without a Custom house, pleasantly situated near the mouth of the river. They formerly had much fish in the river, but the Coperas of the mines has corrupted the waters, so as that most of the fish are destroyed. They have a good hard marle here, which lasts A a considerable time. There is a foot Barrack in this place, and there was a convent here of **Friars preachers** founded by **Tibald Butler** in 1264, it is said his statue is in the church of it, where he is *buried*. up the river is **Mr. Howard**'s, son of the late Bishop of Elphin,[57](javascript:footNote('E750002-001/note057.html')) **Ballyarklow** **Mr. Sims**; on the southern branch of the river is **Agherim**, that to the north rises near **Ballinderry** on the next and the principal is **Rathdrum** which rises in two Branches, one coming from **Glandelough** the other from **Lough Tee** which falls into **Lough Dan** and so both of them from this river, and the eastern branch comes from **Glanely**: and all this country is very finely improved and adorned with wood and even timber in some parts, all the way as far as **Rathdrum** and along **Glanely**. This country abounds very 



---

p.160



much in copper mines and they have found a sort of Oker which produces lead, out of which they get silver with much gold in it, that is worth ten shillings an ounce: They have also a water which comes from the mines so strongly impregnated with copper that finding an old carr and some tools that were of iron precipitated into copper, they now lay bars of iron in it, and in twelve weeks they are turned to copper, which I was told sometimes weighs heavier than the iron they put in. I crossed over **Redcross Hill** and in five miles came to a village called ***Redcross*** in a fine vale, which is divided from another by some low hills, in which vale stands **Dunganstown**, an old ruined castle belonging to **Mr. Hoy**, who began to build a large house near it: This is about two miles from the sea, and farther south of **Ardaery** (The eastern *height*.) A high tower of this castle and part of the main building is still standing, it having been destroyed in the wars of 1641 by order of the Council of **Kilkenny**, the Lord Deputy having given offence to them. About two miles from **Redcross** are some of the chief of the mines and on or near the river of **Arklow**, they have a smelting house for the Lead ore. I went to **Dr. Wynne**'s at **Dunganstown**, who lives there during the minority of his Nephew; I staid there on the 8th.


And on the 9th I set out, crossed over the hill five miles to **Brinewbridge** and passed **Captain Johnson**'s seat to **Newry bridge** near **Mount Usher** a *little* to the west of which is **Mr. Tigh**'s, a fine finished box and plantations. I came on in the **Dublin** road and went out of it to the west five miles to ***Altadora*** to **Major Browning**'s, passing by a village called **Newtown Mount Kennedy** and near it Mount N[*gap: extent: one or two words*]y which is very beautiful in its plantations chiefly of Firrs, and beyond it is **Teny Park**, formerly so famous for the beauty of its situation. I passed by Hermitage a pretty



---

p.161



box of **Mr. Butler**'s Captain of the Battle axes and brother to **Lord Lanesborough**, it is in a beautiful Glyn or narrow vale, at the head of which a fine cascade tumbles down the hills beautifully adorned with wood; **Altadora** is on the heighth over it and commands a most delightful view of the rich country below and of the sea, it is well shelter'd by the eminence above it every way at about the distance of three miles except to the east and south east and north east; It was the retirement of the late **General Pearce**, who affected to build it as a thatched cabin, and erected a tower to make it look like a village with a church to it: **Major Browning** having purchased it, has improved it with great taste; in the middle is a building consisting of a Hall and beautiful parlor and over them excellent bed-chambers for strangers, with a fine staircase; on each side a wing is built to it,—in one are the apartments for the family,—in the other the kitchen and rooms for servants; two yards to the south with all offices, and to the north and west the garden rises with three or four terraces one over the other, and to the north west are meadows and fields all well planted:[58](javascript:footNote('E750002-001/note058.html')) In a retired part which commands a view of the fine country below and of the sea there are cut on a piece of white marble these lines over which may be placed the Bust of the Laughing Philosopher.



---

p.162



> 1. O Sacred Solitude! Divine retreat!
>   
> Choice of the Prudent! Envy of the Great
>   
> Here from the wayes of men, laid safe ashore,
>   
> We smile to hear the distant billows roar;
>   
> Here blest with health, with business unperplext
>   
> This Life we relish and insure the next.
> 




On the 11th I set forward and in three miles came in the road to **Wicklow** and passing by **Wingates** a fine situation on a height near the sea, we crossed ***Bray Head*** and passed by **Lord Meath**'s house, where in the gardens are fine hedges and plantations, and going to **Bray**, saw to the left **Mr. Odair**'s, an improvement in very good taste, and at a distance ***Powerscourt***, belonging to **Lord Powerscourt**, where there is a large house and great improvements, but the slopes are rather too steep and unnatural; In the Park two miles from the House, is the famous fall of Water, which is a cascade that falls in one spout without breaks for feet, the river which makes it falls into **Bray river**, which rises out of two Loughs up in the side of the mountain, at the west end of **Glancree**: The high ground on each side covered with wood in the way to it is very fine. Below ***Powerscourt*** the Dargil a hanging ground over the river covered with wood affords a beautiful scene. About three miles from this is the **Glyn of the Downes**, which leads from **Dublin** to a place called **the Downs**, about two miles from ***Altadora***, it is a deep Narrow Valley, with high hills on each side, part of them covered with wood and one of them is called the **Sugar loaf**. All this country is most exceeding Romantick and beautiful Near ***Powerscourt***; **Mr. Monk** has a pleasant country house with good plantations about it. The County of **Wicklow** is remarkable for wood, which grows extremely



---

p.163



well in it, they have a saying that a stick put in the ground will grow: Myrtle thrives in their gardens, and is planted abroad in the natural ground.


**Bray** is prettily situated on a height over the river is a very small town, with a Barrack in it. Three *miles* further is **Loughlinstown** an Inn, and a few houses, near which **Mr. Domville** has a ruinous seat, very finely situated, over it is a hill on which **Mr. Malpas** erected an obelisk, to employ the Poor in the year of famine; at the foot of that hill on the sea are lead mines.[59](javascript:footNote('E750002-001/note059.html')) I came by ***Stillorgan*** **Lady Allen**'s seat, where in the Park is a fine obelisk erected on four arches of rustick Grostesque Arches, in the manner of that in the ***Piazza Navona*** at **Rome**, but much larger. We then came by **Mirian** the seat of **Lord Fitzwilliam**, a most glorious situation commanding a fine view which appears very beautiful from the top of the hill, through the Visto's cut in the Grove of *fir* trees. **Butlerstown** is the same kind of situation where **Lord Fitzwilliam** has let his land in small parcels for building country houses. From this place I came by ***Donnybrook*** to **Dublin**.



>   
> **Dublin,**
> 
> July 17th 1753.
> Honoured Madam!
> 
> 
> I left **Dublin** on the 19th of June and went by **Tallogh** a mansion house of the Archbishop of **Dublin**, repaired by **Archbishop Hoadley**; and then coming in between the mountains came by **Blessington**, a village where **Lord 
> 
> 
> 
> ---
> 
> p.164
> 
> 
> 
> Blessington** has a seat, and turning to the south I crossed **Kings river** at **Burgage** where there is a remarkable old cross about fifteen feet high of one piece of mountain stone; passing by **Mr. Leeson**'s fine new built house and offices I came to the **Liffy**, which we cross'd over **Horspeth Bridge**, near which I sat down and dined by the river, and the poor children coming about me, I had the pleasure of feeding them. From this place for about half a mile there are several *beautiful* falls of the river between the rocks; the banks on each side being high and steep, these falls are called **Pooley Pucky**: We soon came to the small village and church of **Holywood**, and passed through the Glyn or narrow vale of **Holywood**, which is very *beautiful* having on each side steep hills covered with wood, and is something like the Glyn of the downs near **Bray**: At the entrance of it I saw they had been working for ore. We came to **Donard** a poor small town like a village; with a ruinous church: About this place three or four rivlets come out of the mountains and form the river **Slaney** which runs through the Counties of **Carlow** and **Wexford**, and falls into the sea at **Wexford**; the first I crossed is called the *little* **Slaney**, the next is the principal stream near Donoghmore Church: Here **Mr. Howard** has an estate, he is son of the late **Bishop of **Elphin****, whose patrimony it was: He has a park here and a hunting house. All this country on the **Slaney** is finely improved and planted in most parts of the way which I went to ***Baltinglass*** five miles further, coming into the high **Dublin** road from **Ballymore-Eustace**, near two miles from ***Baltinglass***, from which the road all the way is through a wood having Mr. [*gap: extent: one word*] seat to the right on the river **Balinglass** is eight computed miles from **Ballymore**, which is seventeen measured miles from **Dublin**, eleven Irish measured miles making fourteen
> 
> 
> 
> ---
> 
> p.165
> 
> 
> 
> English: But the way I came it must be thirty of our measured miles. **Baltinglass** is a very pleasant village, tho' call'd a market town, situated in a bottom on the **Slaney**, and the country round about it is beautifully improved in plantations of Wood: It belongs to **Mr. Stratford**, who has a small park here on the side of a hill, but lives four miles from this place: He has built houses for weavers, a spinning school and Bleach yard, but it does not take much. There was an Abbey here of St Mary of **Baltinglass** or de valle Salutis, the Monks were **Cistertians**, it was founded by **Dermot son of Murchard King of **Leinster**** in 1148.
> 
> 
> On the 20th in the afternoon I went through a very fine country five miles to **Castledermot**, I observ'd in the way some ruins of a place call'd **Grany** and was informed that it had been a convent; it was an Augustinian Nunnery founded about 1200 by **Gualter de **Ridelesford****: In **Castledermot** anciently called **Tristledermot** is a Priory and Hospital of St John Baptist for cross bearing *Friars* founded by **Walter de **Riddlesford****, Lord of the place in **King John**'s time. This town had its name from **St. Diarmitius** who lived here as a Hermit, from whom it was called the desart of Diarmitius. There is a round tower at the Parish church of a larger kind than the common towers of that sort in **Ireland**. They have a Charter School here for forty boys, founded by the encouragement of the late **Lord Kildare**. I went on towards **Athy** and in about a mile came to **Kilkea Hill**, which appeared as if it had been anciently *fortified*, and at the foot of it, on a rivlet which falls into the **Barrow** is a Castle of that name; within a mile of **Athy** we passed by a remarkable old Rath or fort called **Shanrath** and arrived at **Athy**, a small market town well situated on the **Barrow**, they have a new 
> 
> 
> 
> ---
> 
> p.166
> 
> 
> 
> market house and it is a Burrough, there is a large stone bridge here over the **Barrow**. There was a Dominican *friary* here built in 1257, where several Chapters of the order were held: and on the other side of this bridge was a Priory of **St. John** for the order of Cross bearers founded in **King John**'s time by **Richard de **S. Michael** Lord of **Reban****.
> 
> 
> On the 21st I went four miles to **Ballykilcavan** the seat of the **Welshs** where they have pleasant park. I observed in the *lime stone* of this country some of the petrified coral. I came to **Stradbally**, a small market town in a well improved Country. Near it is **Mr. Cosby**'s seat with the finest improvements of high hedges, of white thorn, Horn beam &c: I ever saw round the quarters, which are full of Kitchen stuff and excellent fruit trees. **Mr. Pigot** is building an *handsome* house in a park near the town, the most beautiful part of this garden is a Terrace, over a river and other walks about it, and another river which falls into it: And between these rivers begins that gravelly bank, covered with green sod, called the Escarp, which I shall have occasion to mention below. This might be made a very *beautiful* thing, tho' they are carrying part of it away for gravel for the roads, over one of these rivers the County are building a bridge on the **Carlow** road, which leads to the Charter School: on the other side of the river is a very *handsome* Charter School for forty or three score boys and girls, and it is large enough to hold an hundred: it was founded chiefly on the bounty and under the direction of **Mr. Cosby**. Here was a Convent of **Minorites** founded by **Omore**, and its thought to be the Convent called **Levasia**, for it is called **Strallbally** in **Lese**, and this County, **Kings-County** and some other parts were called the County of **Lese**. I went along a pleasant road through a fine Country, mostly
> 
> 
> 
> ---
> 
> p.167
> 
> 
> 
> on the bank of gravel call'd the **Escar** and in English the ridge, which they say runs almost through the whole country, it is between the two rivlets above mentioned; it is probably that anciently they were larger rivers than at present and that this was the bank between them: After going about three miles I came to **Timohoe**, where there is a remarkable round tower, with a door to it of Saxon architecture which is singular. We came to **Ballyroan** a large village on a rivlet, which falls into the **Nore**, and crossing that river came to **Springmount** the seat of **Mr. Brereton**, near the remains of a fine ruined Castle, on the **Nore** called **Killeny**.
> 
> 
> On the 24th I went to ***Abbeyleix***, the seat of **Lord Knapton** son of **Sir Thomas Vesey late Bishop of **Ossory****,—Here was an Abbey of **Cistertians** supplied from the Abbey of **Baltinglass** in 1183, it is said to be founded by ***Connor O'More***, *buried* there, and in the Street a tomb remains, said to be of ***O'More*** in the spot where the Church stood. I went from this place further to **Water Castle**, **Mr. Lyons**, a fine spot of ground, well adorned with plantations, through which the river **Nore** runs, just as the **Willey** runs through **Wilton**, and it might be made a fine thing, commanding a view of a very *beautiful* country all round.
> 
> 
> On the 26th I crossed on a bridge at **Gortineclea** an old Castle, a rivlet called the gulley, which rises towards **Burres**, in **Ossory** and falls into the **Nore** below **Water Castle**, passing most of the way through a morassy ground: Going to the south of this Morass, I came to **Aghaboe**, a large village where there are remains of a Monastery, and of a singular tower to a building, probably the Refectory now a Church: The tower is five sides of an octagon, near it is a Mount for defence. This was an Abbey of **Dominicans**, built by
> 
> 
> 
> ---
> 
> p.168
> 
> 
> 
> the Lords of **Upper Ossory**: It is said to have been first founded by **St. Kenny** son of **Laidee** a famous poet, and that he was the first Abbot: He *died* in 599: 'tis thought the See of **Ossory** was moved from **Saiger** now called **Seir-Kean** to this place about the year 1052 for then a Church was built there, and **St. Kenny**'s tomb placed in it the See was afterwards moved to **Kilkenny**.
> 
> 
> On the 27th I went three miles westward to **Reshal** on the turnpike road to **Limerick** and fifty miles from **Dublin**; this is a ruined seat of **Lord Montrath**'s, it was the estate and Mansion house of **Costegan** the old proprietor, who was proclaimed as a rebel, and his estate granted to **Sir Charles Coote**, who in 1611 did great services in **Ireland** and was made **Earl of **Montrath**** in 1660—was one of the Lords justices and died in 1661 and was suceeded by his son Charles who in 1696 was also one of the Lords justices: The small old mansion remains, to which **Sir Charles** made great additions, and the Court and garden are encompassed by walls and defended by Turrets, it is a fine situation, commanding a view of the country to the east and the vale to the west and south west, in which the **Nore** runs by ***Borris-in-Ossory***. We returned by **Castletown**, where are remains of an old Castle held by **Colonel FitzPatrick** for **King Charles the First**, who forfeited, and going abroad on the restoration had all returned to him; and **Richard FitzPatrick of this family was created Baron of **Gowran**** in the County of **Kilkenny**: His wife was daughter and heir of **Sir Jno Robinson** of **Farmingwood** in **Northamptonshire**, which estate his son now enjoys, as well as a large estate in **Ireland**. He is a branch of this house the head of which in the time of **Henry 8th** was made Baron of **Upper Ossory**. This title somehow or other was not asserted
> 
> 
> 
> ---
> 
> p.169
> 
> 
> 
> and lying dormant the present **Lord Gowran** was created Viscount of **Upper Ossory**; tho' it is said there is an heir to that title. A mile beyond this place is ***Mountrath***, a small market town, where **Lord Montrath** has a small house. Both these places are on the high road, one forty eight, the other forty seven from **Dublin**.
> 
> 
> On the 29th I went by **Gortineclea** and going on southward passed by ***Cuffsborough***, **Mr. Cuf**'s, where I observed **Trochi** and **Entrochi** in the *lime stone* which *lies* loose in the earth all over this country; and at **Donoghmore**, **Mr. Morri**'s, they have great quarries of this stone, which is a coarse black marble, but not used because the Kilkenny is much better. Going on we saw a small lake to the East called **Ardevin** and near it **Grantsown** an old castle which is now inhabited. Coming on a *height*, I saw to the west a Morass, round which are several places, as near the road **Kilbredy** a ruined Castle; and near that a *fortified* Mount, called **Motchneloiak** (The middle mote) from which **Mr. Flood**'s seat has its name; we then came to a small stream which rises out of the morass: About two miles farther is **Donoughmore**, where there is a barrack for one troop of horse: going about a quarter of a mile farther we crossed over the river **Erkin** on a bridge, near it is **Coolcany** the house of **Mr. Baldwin**: We had left the road of **Rathdowny**, a small town on the south side of the Morass, belonging to the heir of **Mr. Prior** the great patriot of this Kingdom; and going on about two miles came to an old fort called **Rath Philip** on a *height* with a burial place near it, 'tho no sign of a church: about a mile farther we came at Whites wall from the **Queens County** into the County of **Kilkenny**, and in about two miles to **Farta** an old monastery, where there is an old round tower, twelve feet in diameter and by measuring
> 
> 
> 
> ---
> 
> p.170
> 
> 
> 
> the shadow I found it to be eighty three feet high, but the top point is much decayed and there is crack down the East side of it. There is a church in repair, with some old carved work about it; to the north of it is an old chapel in which there is a tomb of the [*gap: extent: one or two words*] with an inscription on it, on the tomb is a ***mezzo relievo*** of a man in armour with a dog at his feet, a sword in his hand stretched on his thigh, and his hand lying on his other leg; the tomb is adorned with sculpture, near it I saw the top of another tomb, which seemed to be of a woman, with a singular Head dress, rising up on each side as in two horns. This is I suppose the **Priory of Kiaran** of **Augustinian Canons** said to be at Fest-re-gerah. I went a furlong farther to **Beggars Inn**, on the new turnpike road from **Dublin** to **Cashel**, five miles from **Longford Pass** and fifteen from **Cashel**; near it is a ruin call'd **Baun Richen**, which they call part of the old monastery, and probably was the farm house belonging to it. The **Caley hills** extend from ***Durrow*** beyond this place to the east of the turnpike road; and from this place is a road to **Kilkenny** ten miles off, through a Glyn or Vale between the hills, in the middle of which is a *little* hill, on the top of which there seemed to be a rath or fort: Going on towards **Durrow** in our return we came in less than a mile to **Aglishhaw Castle**, where is a rivlet that comes out of the Glyn, and a *little* farther we had a mile to the west an old Monastery called **Agha Macart**, and nearer a large fort or Rath. This was a Priory of *St Tigernach* for **Augustinian Canons**. In a mile we passed **Calahil Castle**, a large enclosure with two or three buildings like Chapels. A mile farther we came to **Cahil Castle** to the west, and a *little* beyond saw a very pretty seat called **Newtown**. We then passed a stream,
> 
> 
> 
> ---
> 
> p.171
> 
> 
> 
> which rises from a Holy well, a *little* to the west called **Tubberboh**; and in about a mile and half, by a pleasant road between the woods of **Castle Durrow**, we came to **Durrow** a a small market town, and now a great thoroughfare, the Turnpike road from **Dublin** to **Cashel** being carried through it. **Lord Ashbrook** who till lately had the Title of Castle Durrow has a seat here well situated with a fine Park and Woods.
> 
> 
> I am &c.





> 
> July 3d. 1753. I went from Springmount to ***Burris-in-Ossory***, a village pleasantly situated on the north west side of a chain of beautiful *little* Hills finely improved which extend to the south west towards the mountains called **Devil's Bit**, out of which the rivers ***Suir*** and **Nore** rise. This is an estate given by **King Charles the First** to the favourite **Duke of Buckingham** and is now the estate of one of his family, of the name also of **Villers**. There is a good Mansion house on it of the Architecture of those times, which seems to have been built to an old Castle, this place is 53 miles from **Dublin**. A *little* beyond it we crossed the **Nore**, which almost from its rise runs through a morassy ground to **Montrath**. We passed in sight of **Gorvan Castle**, on one of those hills to the south, and to the north by **Cloncuis Castle**, two miles from **Borres**, it is the estate of **Lord Montrath**. We came to those hills which divide the **Queen's County** from the **King's County**, and in a line from them is the bounds between **Queen's County** and the County of ***Tipperary***, which is marked by a stone a *little* beyond the 56th mile stone on the east side of this hill; just at the end of it is a large Castle called **Ballaghmore Castle** with a wall and ramparts round it. I saw further on to the south as in the Morass a Church with trees planted round it called **Monatinchelich**. We came to **Roscrea** 58 miles from **Dublin**, pleasantly situated
> 
> 
> 
> ---
> 
> p.172
> 
> 
> 
> on a rivlet between the *little* hills, which form a sort of Amphitheater round it, and are bounded by higher hills to the south and north; It is a small town tho' with a *little* encouragement in the Woollen manufacture it might be greatly improved. At the entrance of the town is the front of a very old church to a modern building, it consists of a door and two flat arches on each side of the Saxon Architecture and a **Mezzo relievo** probably of **St Cronan** to whom it is dedicated appears over it much defaced. At a *little* distance is a Cross in a circle, with the Crucifix on one side and another figure on the other, and *adjoining* to it a stone carved in several figures and at each end a **Mezzo relievo** of some saint, they are both of a sandy stone with pebbles in it, in which these hills abound, they are both if I mistake not called the Shrine of **St Cronan**. To the North west is a round tower fifteen feet diameter with two steps round it at the bottom about fifteen feet from the ground is a window with a regular arch, and as much higher another with a pointed top: it appeared to be only about fifty feet high, but the height was probably seven diameters, which seems to be the proportion they observed, that is 105 feet high, the top of it having probably fallen to decay. On the river at the north west part of the town, are pretty perfect remains of the Convent of **Minorites** founded by Biliana Widow of ***Mulroney O'Carroll***. There is a barrack here for one company of foot. This estate did belong to the Bishops of **Killaloe**, who gave it the Crown for the lands of **Newcastle** in the County of **Wicklow** and some other lands which the Bishop never got. The Crown granted it to the **Earl of **Ormond****, it was sold by that Duke to **Mr. Curtis** who sold it to **Mr. Daymore**. There was a fine old Castle on it, and near it is built a good Mansion house; Some walls appear 
> 
> 
> 
> ---
> 
> p.173
> 
> 
> 
> about the grove to the north, probably the circuit of that Castle: It is no Corporation, nor is there any justice of peace within some miles of it, as I was informed; and most of the inhabitants are Papists. I returned to **Springmount** by **Aghaboe**.
> 
> 
> I set out from **Springmount** on the 5th of July and went to **Aghaboe** from which place I got into the road to **Thurles** and passed near the **Castle of Kilbredy** already mentioned, and going towards **Donoghmore**, came within a quarter of a mile of it, to a ruin call'd **Castletown**, it is part of a tower, with foundations of walls about it extending a considerable way; and west of it are foundations of another tower; there seems to have been a large village about the Castle which belongs to the **Villers**, being in the Manor of Buries. I came to **Donoghmore** pleasantly situated on a height over the rivlet, which runs by **Rathdowny**, here is a church and a barrack, it is the estate of **Lord Gowran**; crossing over the rivlet on a heighth, is a Rath call'd **Donoghmore** or, the great hill which has given name to this place. After travelling about four miles I saw to the North west two beautiful Hills; At the east end of the eastern hill is **Ivrin**[60](javascript:footNote('E750002-001/note060.html')) where there is a ruined church, and I have been informed that there is a monument there like a cross, to a son of one of the old Lords of **Upper Ossory** of the **Fitzpatrick family**; we went across the bog by the pass called **Gortahie**; x I saw to the right an old Castle call'd if I mistake not **Kinslaney** x[61](javascript:footNote('E750002-001/note061.html')) About this place came into the County of **Tipperary**, and to a large old Castle with two round towers at the corners, and large apartments *joining*, to one now in ruins, the enclosure is about half an acre, it is called **Tulleah McJames** near which there is such a round tower as is seen often in **Ireland** near churches, which is singular. I saw a large enclosure two miles to the east called **Baunaccarah**,
> 
> 
> 
> ---
> 
> p.174
> 
> 
> 
> passed through a Village call'd **Ballyerle**, where I observed there was a large school at the chapel or Masshouse, where they are taught Latin: Within two miles of **Thurles** I came to **Rahelty Castle**, a good building rounded off at the Angles, an excellent regular arch at the entrance; the rooms on each floor about twenty by thirty, there is a very extensive view from the top of it, of the mountains to the west called **Devil's Bit**, out of which the ***Suir*** and **Nore** rise very near to each other; hills to the south of them called **Kilnemanogh**, the **Galty Mountains** on the borders of the County of ***Tipperary***, **Limerick**, and **Cork**, **Knockmandown** towards **Lismore**, the mountains of the County of **Waterford** and to the south east **Sleannemane**, which is seen plainly from the Key of **Waterford** and stretches its foot near to **Carrick** and ***Clonmel*** and then to the East the hills on which ***Killenaule*** stands which running to the north east are *joined* by **Cullyhill** which extends to ***Durrow***. I arrived at **Thurles** situated on the river ***Suir***, twelve long miles from **Roscrea**, seven from **Cashel** and fifteen from **Kilkenny**. There is a bridge here over the river, the first being at **Loughmore** three miles higher. This river abounds in Pike, Eeles and large Trouts. The town consists of one short street, with a market town in the middle, at the end of it is the old Castle, now the seat of **Mr. Mathews** in which he has built a handsome modern house, in the garden is a Mount with a winding ascent, which probably was an old Danish fort. On the East side of this river is the church which is built to the tower of an old church, the east part of this church being an Arch under the tower; to the east of that is a chapel in which there is a monument of the Archers of Archers Court near, who had contentions with the Lords of **Thurles**. The head dress of the woman is like that at
> 
> 
> 
> ---
> 
> p.175
> 
> 
> **Farta** already described, but not so much pointed at each corner. On the same side are the remains of a convent, a tower and some part of the Cross Isle to the north; it was founded by the **Butlers** for the **order of St. Mary of Mount Carmel**. There is a large popish chapel built chiefly by **Mr. Mathews** according to an inscription set in a wall near it. They have some tradition I believe without foundation, that this Castle did belong to the **Knights Templars**: There are two barracks here for three troops of horse—
> 
> 
> On the 8th of July I left **Thurles**, came in about nine miles to **Burres en Leough**, probably **Burres on the Lough**, being an Island on the bog, which might anciently be a Lough. Here **Mr. Mathews** has a seat; this is called the bog of **Monela**, which extends northward near to **Roscrea**. These Islands consist of a lime stone gravel and large pebbles of lime stone; five miles from **Thurles** we came to **Longford Pass**, where there was a barrack[62](javascript:footNote('E750002-001/note062.html'))[63](javascript:footNote('E750002-001/note063.html')) for half a company of foot, which is now in ruins, not having been used for near twenty years. Three miles from **Thurles**, the road to **Cashel** leaves the road to **Thurles**, pointing almost directly south. A *little* beyond **Longford Pass**, the road goes to the East to **Kilkenny**, and I turned northward in the road to ***Durrow***, having the hills to the East, which extend along the west side of the river **Nore**. There is a hill to the west side of these, on the side of which there is a house called ***Ballyspellan***; a quarter of a mile above it is a mineral water which runs through a black slate, which is Medicinal, and its said there is a composition of sulphur in it; it is esteemed good for all kinds of scrophulous disorders. I came down from this place to **Farta** already mentioned and continuing two miles along the road to
> 
> 
> 
> ---
> 
> p.176
> 
> 
> **Durrow**, I went out of it to the west about half a mile to the monastery of **Agha Macarth** mentioned before, in which there is nothing remarkable, but a gate at the entrance with a true arch of good workmanship, and there are stone sockets for the gate to turn on. This place is on the rivlet called the **Goula**, which runs near **Farta**, and a *little* below this *joins* the river which runs from **Rathdowney**; I crossed the river about 2 miles above it and came to **Grantstown Castle** which is oval. Passing by ***Aghagouran*** a ruined church, I came to a *little* Mount, which is called **the Leap**, and so returned by **Gorthniclea** to **Springmount**.
> 
> 
> On the 13th of July I left **Springmount**, stop'd at **Stradbally** and came to the **Barrow** at **Riverstown**, where one **Mr. Brown** has has a pleasant seat. This a *beautiful* place, and mostly resembles old **Windsor**; the ferry is crossed in a very bad boat, and I was obliged to swim one of my horses.
> 
> 
> I came to **Kildare** on the 14th; I passed over the **Curragh** and came to **Newbridge**; here I saw part of the Head and horns of an Elk, dug out of a neighbouring bog, where they have also found several bones of this animal, and have been informed that they seldom find a skeleton together, but the bones dispersed, probably not only by the current of the water, but where they are found on a descent by the moving of the earth. I stop'd at **Furnace** and arrived at **Dublin** in the evening.
> 
> 
> I am &c.





> Honoured Madam,
> 
> 
> On Monday the 6th of August 1753 I left **Dublin** to go to **Ardbracan** which is two miles beyond **Navan**, in the county of **East Meath**. I went through the **Phoenix Park**, and had on the right the rivlet which rises above **Dunboyn** and falls into the sea by ***Ballybaw Bridge***, near
> 
> 
> 
> ---
> 
> p.177
> 
> 
> **Dublin**, having passed by **Finglass** and **Glasnevin** some parts of it which are planted and are very beautiful. On the top of the hill to the right, is the old ruined church of **Malahilhart**, to which the people resort much out of devotion especially on the Patron day. We crossed the river about a mile from **Dunboyn**, and came from the County of **Dublin** into the County of **East Meath**. Near **Kileen Castle** I saw **Dunsany**, where **Lord Dunsany** lives, a Roman Catholick Lord of about £200 a year. We came up to ***Tara*** at the top of the hill of that name, where the Kings of Meath, one of the five divisions of **Ireland**, are said to have resided; and they have a tradition, that in a field to the west of the church, the five Kings of the five provinces of **Ireland** used to meet. I saw five barrows in this situation on which it is possible the five kings Omorth sat with their people round them,[64](javascript:footNote('E750002-001/note064.html'))
>   
> 
> o
>   
> 
> o
>   
> 
> o
>   
> 
> o
>   
> 
> o
>   
> 
> I conjectured also that they might bear some relation to their respective situations on the southern one is a stone or pillar set up which might belong to the Emperor or head of them the King of **Munster**. In the churchyard also there is an ancient stone set up, on which there is an unshapen short figure, something like Pusterus the German Deity.[65](javascript:footNote('E750002-001/note065.html')) About a small mile to the south, I had seen the remains of a large Rath, called **Errameath**, probably the place of residence of the Kings of **Meath**. Close to ***Tara*** is **Brabazon Lodge** the seat of **Mr. Brabazon**, brother and heir to the Earl of **Meath**; it is a large house, and its said to have been a much greater building, probably round a Court. They say it was built by **Stopford Secretary to **Oliver Cromwell****, from whom I am informed the **Stopfords** of this County are descended. I went a mile across this *demesne* to the north to **Skreens**: on another summit of the hill; here is
> 
> 
> 
> ---
> 
> p.178
> 
> 
> 
> a good old church with a high tower; the east end of the church is in repair. Over the south door is a **Mezzo relievo** of **St. Columb**, to whom the church is dedicated, it is very well executed, in the left hand is a book, in the right, a staff. A *little* below the church are the remains of the friery of **Augustinian Hermits**, to which I was informed 40 acres of land did belong. Descending from **Skreens**, I observed a point of land which has been fortified and beyond it on the west side of the vale is a large Rath, near this is **>Lismullen**, an estate of the **Dillons**: From this vale a river runs down to the high road and meets another, which passes through the vale to the east of **Bellenter** and both of them fall into the **Boyne** opposite to **Ardsallah**. I arrived at **Ardbracan** the Bishop of Meath's, two miles beyond **Navan**, from which place I made several excursions, in which and at other times, I made such observations on the Country about the **Boyne**, as I shall send you the first opportunity.
> 
> 
> I am &c:





> Honoured Madam,
> 
> 
> The ***Boyne*** is said to rise out of a Spring at **Castle Carbery** in the County of **Kildare** called the Mother Spring of the ***Boyne***; but I observed that the larger stream rises out of a Bog, near the Charter School, and that this small stream falls into it. **Castle Carbery** is an estate belonging to the two Coheiresses Miss Cooleings, and is finely situated on a *height* improved with plantations which is seen at a great distance. I went farther down the ***Boyne*** I see **Ballybogan** in the County of **Meath**, a place on the ***Boyne***; which I take to be a Priory dedicated to the Holy Trinity; it was called also **Laude Dei** and belonged to **Canons Regular of **St Austin****. And I once saw some large ruins this way, which are I suppose the remains of that Monastery: Lower is **Clonard** the See of
> 
> 
> 
> ---
> 
> p.179
> 
> 
> 
> an ancient Bishoprick, where I saw some ruins and there was here a Convent of Canonesses, a Priory of **St Peter** of **Canons Regular of **St Austin****, and another Convent of some Order, founded by **St Firmian**. About two miles above **Trim** the river of **Trimleston** falls into the **Blackwater**; on this river is **Trimleston**, the seat of **Lord Trimleston** built to an ancient Castle, that was mostly destroyed in **Oliver**'s time. The present Lord married young and retired to **Paris**, where his genius leading him to Botany, he *studied* Physick, and often gave his advice to the Princes of the Blood and other Nobility: about six years ago he returned on the death of his Father and brought a great collection of Exotic plants, among 'em the Cinamon-tree and the Hermaphrodite, the latter has on it the leaves of Orange, Lemon Citron and Cedra, and each fruit contains in it, the fruit of these four kinds, which caused great speculation at **Paris**, but it was determined it could not be done by any inoculation or Art, but that it was a tree of this kind. As his Lordship's skill in Physick soon became known, people of all conditions resorted to him, and now he allots fridays to hear them all, and he not only hears the poor but gives them drugs, the rich who come to consult, putting into a Box for that purpose; he is a Nobleman of excellent sense and of great politeness and address; he has found out near his house thirty six uncommon plants, most of which he has brought into his garden. The River of **Trimleston** has a large black Trout, exceeding that of the ***Boyne***, and also very good Eeles; I found in it several small shell fish of different kinds, and among them I found one about as big as a silver threepence, a most *complete* Ammon's horn and alive. They have very good quarries here of Lime Stone, some of which rises as flags or broad 
> 
> 
> 
> ---
> 
> p.180
> 
> 
> 
> stones. And **Mr. Barnewall** My Lord's eldest son has sent me petrifications of small Nautilus's found in the quarries. **Lord Trimleston** has a dark avenue to his house, near an English mile long. Three miles beyond it is **Athboy**, where was a Convent of **Carmelites**, and in a chapel of the church I saw an ancient Monument: near it is the hill of **Ward**, from which there is a fine prospect of **Skeles**, ***Ardbraccan***, **Trim** and a great tract of country. **Athboy** stands on the river **Trimleston**, and almost all the way to the west of it, is a bog, the further side of which is the bounds between the County of **East Meath** and **West Meath**. To the north of the Hill of **Ward** is rathmore the ruined seat of **Lord Darnley**,—where there is a large wood. We now come to **Trim** on the ***Boyne***, a small town situated on both sides of the river; it has anciently been walled, and there are remains of the walls and gates, one to the west of the Street from **Dangan**, another still in repair called **Athboy gate**: A high tower remains in part of the Dominican Convent, but one side of it was blown up by **Oliver**'s army. There was a Convent of **Black *Friars*** and **Grey *Friars*** one where the barrack is, and the other to the north of the town: But the greatest piece of Antiquity is a very large Castle, called ****King John**'s Castle**, which is a building of great strength, the enclosure extending to the river. About half a mile from **Trim** on the ***Boyne***, is the Priory of **St Peter** and **St Paul** of **Newtown** near **Trim**, which was also an ancient Bishop's See, of which there were several in the Diocese of **Meath**, many of them consisting of some one of the present twelve Deaneries of the Diocese. They were here **Canons of **St Victor****, and I was informed that a daughter of **King John** *lies* *buried* here of the name of and that they show a stone, said to be over her tomb. Near **Trim** the **Earl of **Roscommon****
> 
> 
> ---
> 
> p.181
> 
> 
> 
> had an estate, who was succeeded by his Brother, that Earl's widow who had the estate at her disposal, was afterwards *married* to the Father of **Mr. Carter Master of the Rolls**, who now enjoys it. At **Ardcreagh** in the way to **Navan** was an old Castle called **Ardcreagh**, to which the ***Duchess* of **Tyrconnel****, sister to the ***Duchess* of **Marlborough****, retired for three or years after the battle of ***Aughrim***, and then went to **London** and **Paris**. Going from **Trim** towards **Dublin** on the road is the Charter School for 20 Boys and 20 Girls. About a mile farther is the church of **Laracor** which belonged to **Dean Swift**, and he lived a month or two in the summer in a *little* house near it. We soon after came to **Dangan** the seat of **Lord Mornington** situated on a most *beautiful* flat, with an Amphitheater of hills rising round it, one over another, in a most *beautiful* manner; at the lower end is a very large piece of water, at one corner of which is an Island, it is a regular fortification, there is a ship a sloop and boats on the water, and a yard for building; the hill beyond it, is improved into a *beautiful* wilderness: on a round hill near the house is a Temple, and the hills round are adorned with obelisks: Pillars and some buildings, altogether the most *beautiful* thing I ever saw.[66](javascript:footNote('E750002-001/note066.html')) A mile beyond it is **Summerhill**, **Mr. Bowley**'s, a commanding Eminence, the house is like a Grand Palace, but in the Vanbrugh Style; the prospect from it is very fine and there are great plantations about it; the country behind it does not answer to the other parts in beauty, for it presents to your view a very disagreable Bog. Not far from this is another fine place belonging to **Lord Bawdon**'s 
> 
> 
> 
> ---
> 
> p.182
> 
> 
> 
> brother, call'd **Bramhall**. Returning to the ***Boyne*** the next place is the [*gap: extent: one word*] Corn Mills belonging to **Mr. Carter**, and below it is [*gap: extent: one word*] a pleasant seat of **Mr. Worthington**'s. Near this on the ***Boyne***, are large ruins of the Bernardine Abbey of **Bectiffe or de Beatitudine** founded by **Merchand O'Melaghlin Prince of **Meath**** about the year 1150. The *cloister* is almost entire with a tower. At this place there is a bridge over the ***Boyne***, which is the shortest road from **Athboy** to **Dublin**: Below this near the road from **Dublin** to **Navan** is **Belenter**, **Mr. Preston**'s a very *handsome* new built house of six rooms a floor, with convenient offices, *joined* by a Corridore, and a Court of offices on each side; there is a fine view of the ***Boyne*** from it, which is at the distance of a furlong from the house. After the ***Boyne*** has run to the east all the way from its rise it here takes a turn a *little* to the north, and at the angle is **Ardsallagh** **Mr. Ludlow**'s seat, lately married to the present **Earl of **Scarborough****'s sister, the house is just over the ***Boyne***, the garden laid out in the old way, has the ***Boyne*** on two sides, and there is a shady walk near the river, having the rock on the other side, which appears in several strata, and is a most singular and beautiful thing; at the mill beyond it there is a rough ford across the river. Below this is a Bridge over the ***Boyne*** and a *little* beyond it **Athumley** lately the seat of **Mr. Coddington**, from which there is a beautiful hanging ground over the river, partly planted with wood, it extends much in the same manner all the way to the mouth of the river on both sides; and half a mile further is the old house of **Athlumley**, very large, and they say never finished; it is the estate of **Sr Quaile Sommerville**: This house was built by **Sr Luke Dowdle** one of the principal fomenters of the Massacre in 1641. The river
> 
> 
> 
> ---
> 
> p.183
> 
> 
> 
> then runs to **Navan** and very near it turns to the East. **Navan** is well situated on an eminence, at the confluence of the **Blackwater** and the ***Boyne***, and there is a *beautiful* hanging ground from the town covered with trees. Passing over the **Blackwater**, I *rode* on the north side of the ***Boyne*** and in a mile came to the church of **Donoghmore**, over which is an ancient round tower fifteen feet in diameter, the three lower tiers of stone set out about half a foot and make three steps round it, the door is about fifteen feet from the ground, there are three members round it, which is not common, and a head on each side of the spring of the arch, and what is singular a Crucifix over the arch, cut in a barbarous manner, as they are usually cut on old crosses. A *little* below this is the Castle of **Dunmow**. In two miles we came to **Stackallen**, first passing by the road which leads to a bridge over the ***Boyne***. **Stackallen** is the seat of the late **Lord *Boyne*** and now of **Mr. Hamilton** brother to the present Lord, near opposite to this, on the other side are the seats of **Mr. Meredith** and **Mr. Lambert**, the former has a large new built house; **Mr. Lambert** is building a very good house on an eminence over the ***Boyne*** where it makes a short turn, so that this situation commands a fine view of the river, near it are some Copper Mines: Going further on the north side of the river I came to **Barstown Cross**, on which there is an inscription, and down to the Castle of **Slane** a large house of **Mr. Cunningham**'s, since who I saw this place has been created **Lord Mount Charles**, it is very finely situated on the river: A *little* above it on the other side is a small rocky hill, from which a perpendicular rock extends down the river for a quarter of a mile, appearing like a wall with trees and shrubs growing out of it, and has a most *beautiful* effect. Above this about a
> 
> 
> 
> ---
> 
> p.184
> 
> 
> 
> furlong from the river is the poor town of **Slane**. They were in search of coal about a mile from this town, and it is said there is certainly coal there, of the kind of **Kilkenny** coal, but that they cannot get it worked by the obstinacy of the Proprietors. From this place to the mouth of the ***Boyne***, I gave you an Account in a letter I *wrote* last May of a tour I made into that Country.
> 
> 
> I am &c:





> Honoured Madam,
> 
> 
> I mentioned in my last that the **Blackwater** falls into the ***Boyne*** at **Navan**. This river rises out of the **Lough Ramor** in the County of **Cavan** and passes by **Kells** a small market town situated on an eminence; about three miles below **Kells**, the river **Monalty** falls into it, which rises likewise in the County of **Cavan** near **Ballyborow**; on it about six miles from its source is **Monalty** a poor village finely situated, there are remains of the enclosure of a Castle, which belongs to the **Betas** the old proprietors; and there is an old Mount in **Mr. Maxwell**'s garden to whom the place belongs. The river then runs near **Ardbraccan** and by **Liscartan**, the family estate of **Lord Cadogan**, which is set in lives for ever at £200 a year; his ancestor was a Colonel in **Oliver**'s Army and governor of **Trim**, had great estates and considerable influence in this Country.
> 
> 
> I made an excursion northward from **Ardbraccan**, and cross'd the river a mile above **Lord Cadogan**'s at **Dunogh Patrick Bridge**: We had a flat morassy country to the west, all the rest hilly rising to the east towards **Navan** and **Slanes** the Castle of which we saw, and in about three miles came to the high road from **Navan** to **Nobber** to **Coote Hill** and to the middle parts of the Kingdom:
> 
> 
> 
> ---
> 
> p.185
> 
> 
> 
> Here is a large Rath commanding an extensive view of a very fine Country. I went northward a mile and a half in the road to **Atherdee** and within a mile of **Suddan** near the borders of the County of ***Louth*** in order to observe the course of the rivers and the Geography of this Country, in which I found the Maps very far from being correct. I turned along a rivlet, which falls into the river call'd **Owen More** (the great river) a *little* below **Nobber**, which is a very poor town, pleasantly situated on that river. The family of the **Balfs** were formerly in some condition here, and they show their ancient monuments. A mile above **Nobber** on the river is **Brittes** the seat of **General Blithe** brother of **Lord Darnley**, a neat box and fine plantation, with some ornamental buildings: A *little* above it the river forms a Lough called **Kilmainham** about a mile in circumference; here I suppose was the Preceptory of the **Knights of Jerusalem**, said to be at **Kilmainham** near the **Nobber**. The country about **Nobber** and for three miles beyond it is covered with loose free stone of a reddish and yellow colour; they told me that **Carrickeleg** at about that distance is a rock of free stone, so that these stones have probably rolled down from this rock. It is on the eminence which must command a view of that valley, in which the river **Lagan** runs and falls into the sea at **Garlandstown** between **Dunleer** and **Dundalk**, and in some parts the County of **Monaghan** from the Counties of **Cavan** and ***Louth***. In sinking a well at **Nobber** near forty feet they found it a gravel mostly consisting of the free Stone and with it large pebbles of Limestone. I went two miles in the high road and turn'd out of it a quarter of a mile to **White Wood** **Lord Gormanstown**'s: This is a fine eminence over the vale between **Kilmainham Lough** and **Lough Carr** about half a mile above it made by the same
> 
> 
> 
> ---
> 
> p.186
> 
> 
> 
> river and it commands a view of both. The house is new built of the free Stone found over the fields. I returned to the road and soon left it, going down near **Lough Carr** to the river above it, and came to a very *beautiful* narrow vale, in which the river runs between two hanging rocky grounds covered with trees. We went through this for half a mile and came to a hilly country and in about half a mile to **Everch Lough**, out of which they say the river **Owenmore** rises, but a river falls into it from **Lough Muff** about a mile higher, which must be the rise of the **Owenmore**. On the south side of the Lough there is a Meeting-house. We then passed a skirt of the County of **Cavan**, and came again into the County of **Meath**, and had to the right a ruin'd Castle called **Faun Breehen** and to the left the river **Carig** which falls into **Monalty** river. There is marle along this Valley with shells in it, and so it is in most parts of the Country I passed through; in the bottoms it is mostly in patches in different parts. I saw here a long hill called **Shribogh**, on which I observed several *little* barrows, as if there had been niches sunk in it, but I could not be informed of any such thing. We had travelled along the foot of the hills which are the bounds between this county and that of **Cavan**, but towards **Monalty** we came into a fine well improved hilly Country. I came to **Monalty** and returned to **Ardbraccan** and to **Dublin**.
> 
> 
> I am &c:





> Honoured Madam,
> 
> 
> On Monday the 27th of August 1753 I went by **Cromlin** into the road to **Naas**, turned out of it in about six miles from **Dublin** up to **Sagart** on the foot of the mountain and in a mile came to **Coolmine Castle**, on the side of the mountain, and a *little* farther at **Newtown**, saw three 
> 
> 
> 
> ---
> 
> p.187
> 
> 
> 
> stones set up on end in a field, they are about five or six feet high, and seem to be part of some piece of Antiquity: in all the streams about these hills are fine stones, which are a Composition of pebbles and would polish. We had a fine view of the Country to the west on each side of the **Liny**, and came to **Rathmore**, a very large Rath or fortress, said to have been the place of Residence of the Kings of **Leinster**, it is about twelve miles from **Dublin**. After travelling about three miles farther we came into a *beautiful* plain country extending to the **Liny**, in which there are some good houses of Gentlemen Farmers, which have a fine effect in the prospect, and came to **Loughlantown** an old Castle belonging to the late **Mr. Calvin** who owned the estate we pass'd through. Half a mile brought us to **Hamitown** the estate of **Mr. Eustace**, situated on a rising ground and commanding an extensive view every way, particularly of the course of the **Liffy**. The park is a remarkable fine spot well planted, and below it a command of water, which might be improved into a *beautiful* serpentine river. I went two miles further to **Kilcullen Bridge**; over the **Liffy** a quarter of a mile below it, is **Castle Martyn**, a pleasant seat of **Mr. Carter Master of the Rolls**, especially the meadows of the river afford most *delightful* walks; on the opposite Northern side there are high cliffs over the **Liffy**. Half a mile above the bridge is the new Abbey, of which the Church remains, and there is a fine old monument in it of **Rowland Eustace** and his wife, who are represented in in **Mezzo relievo**, the former in armour and the woman with a very [67](javascript:footNote('E750002-001/note067.html'))
> 
> 
> 
















