

#Life of St. Declan of Ardmore


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Life of St. Declan of Ardmore
=============================


Author: Patrick Power
---------------------


### File Description

donated by Dennis McCarthy (Atlanta, Georgia, USA)

Funded by University College, Cork and  
Professor Marianne McDonald via the CELT Project 2. Second draft.Extent of text: 16580 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2003) (2008) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T201020Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching. The text is based upon the electronic edition, with kind permission from its transcriber, Dennis McCarthy.


#### Notes

You can purchase the book(s) containing this text via the ITS website (http://www.irishtextssociety.org/). Click on the link to the RIA shop.

#### Sources


**Manuscript sources**2. Brussels, Bibliothèque Royale MS 4190–4200 [in the handwriting of Mícheál Ó Cléirigh].
3. Dublin, Royal Irish Academy, MS 23 M 50, pp 109–120. This represents a copy, dated 1740, of one imperfect exemplar.
**Edition**2. Charles Plummer (ed.), Vitae sanctorum Hiberniae ii (Oxford 1910), 32–59 (Latin Life).
**Literature**2. James Ussher, A discourse of the religion anciently professed by the Irish and British (Dublin 1631).
3. John O'Donovan (ed.), Miscellany of the Celtic Society (Dublin 1859) 1–144.
4. Eugene O'Curry, Lectures on the Manuscript Materials of Ancient Irish History (Dublin 1861).
5. Patrick Power, Log-ainmneacha na nDéise: The place names of Decies (Dublin 1907).
6. P. J. O'Donnell, The Christian episcopate in Ireland before St Patrick, Ecclesiastical Review 58 (1911) 258–74.
7. Charles Plummer (ed.), Beatha naem nÉrenn (Oxford 1922).
8. James Kenney, The sources for the early history of Ireland (2 vols, New York 1929).
9. Patrick Power, Ardmore-Deaglain: its founder and early Christian memorials (Dublin 1931).
10. Paul Grosjean, Notes sur quelques sources de Antiquitates de Jacques Ussher, Analecta Bollandiana 77 (1959) 154–87.
11. M. A. O'Brien, Corpus genealogiarum Hiberniae 1 (Dublin 1962).
12. Kim McCone, An introduction to early Irish saints Lives, Maynooth Review 11 (1984) 26–59.
13. Tomás Ó Cathasaigh, The Déisi and Dyfed, Éigse 20 (1984) 1–33.
14. Richard Sharpe, Quatuor Sanctissimi Episcopi: Irish saints before St Patrick, in: Donnchadh Ó Corráin, Liam Breatnach and Kim McCone (eds.), Sages, saints and storytellers: Celtic Studies in Honour of Professor James Carney (Maynooth 1989) 376–99.
15. Richard Sharpe, Medieval Irish Saints' Lives (Oxford 1991).
16. A. A. Colmcille, Where was Sliabh gCua?, Decies: Journal of the Waterford Archaeological & Historical Society 46 (1992) 5–9.
17. T. G. Fewer, The ruined church of Killea: a consideration of its date and foundation, Decies: Journal of the Waterford Archaeological & Historical Society 52 (1996) 151–167.
18. F. J. Byrne, Irish kings and high-kings (London 1973, reprinted Dublin 2001).
19. Dónal Ó Conchúir, Ardmore and Lismore: the Christian antiquities of Ardmore and the legacy of the Lismore monastery (Waterford 2001).
20. Philip Rance, Attacotti, Déisi and Magnus Maximus: the case for Irish federates in late Roman Britain, Britannia 32 (2001) 243–70.
21. Pádraig Ó Riain, Irish saints' cults and ecclesiastical families, in: Alan Thacker and Richard Sharpe (eds.), Local saints and local churches in the early medieval west (Oxford 2002) 291–302.
**The edition used in the digital edition**2. Life of St. Declan of Ardmore, with an Introduction, translation and notes, by Rev. P. Power, M.R.I.A., University College, Cork. Patrick Power (ed), First edition [xxxi + 202 pp. (Errata; v Preface; vii–xxxi Introduction; 1 plate (Principality of Decies); 3–73 Life of St. Declan; 74–147 Life of St. Mochuda; 150–177 Notes to Life of Declan; 178–195 Notes to Life of Mochuda, 196–202 Index)] Irish Texts Societylondon (1914) . Irish Texts Society [Comann na Sgríbheann Gaedhilge]. , No. 16

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents pp i–xxxi and 3–73 of the printed edition.


#### Editorial Declaration


##### Correction


Text has been proof-read three times.


##### Normalization


The electronic texts represents the edited text. Variant readings from RIA MS 23 M 50 are omitted, but editorial footnotes are marked note type="auth" n="". Text in Latin and

 Irish is indicated.


##### Quotation


Direct spreech is marked q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the saint's life; the front matter contains the introduction, and is tagged div. In the main text, div1 represents the numbered chapter. Page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. There are no dates within the text.


##### Interpretation


Names of persons, groups and places are not tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: Translation by Patrick Power.

 (1913) #### Use of language


##### Language: [EN] Introduction and Translation are in English.


##### Language: [GA] Some terms are in Irish.


##### Language: [LA] Some terms are in Latin.


### Revision History


* (2011-01-26) Beatrix Färber (ed.)

* Conversion script run; header updated, new wordcount made.
* (2008-10-23) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-18) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, 'creation' tags inserted, content of 'langUsage' revised.
* (2007-12-14) Beatrix Färber (ed.)

* Note inserted in header.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:39:43+0100) Peter Flynn (ed.)

* Converted to XML
* (2004-09-20) Beatrix Färber (ed.)

* HTML file created.
* (2004-09-18) Benjamin Hazard (ed.)

* Bibilography compiled; pagebreaks and content markup inserted; file proofed (3) and re-parsed.
* (2003-07-24) Beatrix Färber (ed.)

* Header created, basic structural markup applied; file parsed.
* (2003-07-20) Eoin P. Kelleher (ed.)

* Introduction and translation proof-read (2).
* (2000-03-07) Eoin Lynch and Aidan O'Brien (ed.)

* File proofed (1).
* (1997) Dennis McCarthy (Donation)

* Text donated.




---


#### Corpus of Electronic Texts Edition: T201020


### Life of St. Declan of Ardmore: Author: Patrick Power


### Introduction




---

p.xvi


If thou hast the right, O Erin, to a champion of battle to aid thee thou hast the head of a hundred thousand, Declan of Ardmore.( Martyrology of Oengus).
Five miles or less to the east of Youghal Harbour, on the southern 

Irish coast, a short, rocky and rather elevated promontory juts, with a south-easterly trend, into the ocean *about 51 deg. 57 min. N/ 7 deg. 43 min. W*. Maps and admiralty charts call it Ram Head, but the real name is Ceann-a-Rama and popularly it is often styled Ardmore Head. The material 


---

p.xvii




of this inhospitable coast is a hard metamorphic schist which bids defiance to time and weather. Landwards the shore 

curves in clay cliffs to the north-east, leaving, between it and the iron headland beyond, a shallow exposed bay wherein many a proud ship has met her doom. Nestling at the north side of the headland and sheltered by the latter from Atlantic storms stands one of the most remarkable groups of ancient ecclesiastical remains in Ireland—all that has survived of St. Declan's holy city of Ardmore. This embraces a beautiful and perfect round tower, a singularly interesting ruined church commonly called the cathedral, the ruins of a second church beside a holy well, a primitive oratory, a couple of ogham inscribed pillar stones, &c., &c.


 

No Irish saint perhaps has so strong a local hold as Declan or has 

left so abiding a popular memory. Nevertheless his period is one of 

the great disputed questions of early Irish history. According to 

the express testimony of his Life, corroborated by testimony of the 

Lives of SS. Ailbhe and Ciaran, he preceded St. Patrick in the Irish 

mission and was a co-temporary of the national apostle. Objection, 

exception or opposition to the theory of Declan's early period is 

based less on any inherent improbability in the theory itself than on 

contradictions and inconsistencies in the Life. Beyond any doubt the 

Life does actually contradict itself; it makes Declan a cotemporary 

of Patrick in the fifth century and a cotemporary likewise of St. 

David a century later. In any attempted solution of the difficulty 

involved it may be helpful to remember a special motive likely to 

animate a tribal histrographer, scil.:—the family relationship, if 

we may so call it, of the two saints; David was bishop of the Deisi 

colony in Wales as Declan was bishop of their kinsmen of southern 

Ireland. It was very probably part of the writer's purpose to call 

attention to the links of kindred which bound the separated Deisi; 

witness his allusion later to the alleged visit of Declan to his 

kinsmen of Bregia. Possibly there were several Declans, as there 

were scores of Colmans, Finians, etc., and hence perhaps the confusion 

and some of the apparent inconsistencies. There was certainly a 

second Declan, a disciple of St. Virgilius, to whom the latter 

committed care of a church in Austria where he died towards close of 

eighth century. 


---

p.xviii




Again we find mention of a St. Declan who was a 

foster son of Mogue of Ferns, and so on. It is too much, as Delehaye 

( Legendes Hagiographiques) remarks, to expect the populace to 

distinguish between namesakes. Great men are so rare! Is it likely 

there should have lived two saints of the same name in the same 

country!


The latest commentators on the question of St. Declan's period—and 

they happen to be amongst the most weighty—argue strongly in favour 

of the pre-Patrician mission (Cfr. Prof. Kuno Meyer, Learning in

Ireland in the Fifth Century). Discussing the way in which letters 

first reached our distant island of the west and the causes which led 

to the proficiency of sixth-century Ireland in classical learning 

Zimmer and Meyer contend that the seeds of that literary culture, 

which flourished in Ireland of the sixth century, had been sown 

therein in the first and second decades of the preceding century by 

Gaulish scholars who had fled from their own country owing to 

invasion of the latter by Goths and other barbarians. The fact that 

these scholars, who were mostly Christians, sought asylum in Ireland 

indicates that Christianity had already penetrated thither, or at any 

rate that it was known and tolerated there. Dr. Meyer answers the 

objection that if so large and so important an invasion of scholars 

took place we ought have some reference to the fact in the Irish 

annals. The annals, he replies, are of local origin and they rarely 

refer in their oldest parts to national events: moreover they are 

very meagre in their information about the fifth century. One Irish 

reference to the Gaulish scholars is, however, adduced in 

corroboration; it occurs in that well known passage in St. Patrick's 

 Confessio where the saint cries out against certain 'rhetoricians' 

in Ireland who were hostile to him and pagan,—‘You rhetoricians who 

do not know the Lord, hear and search Who it was that called me up, 

fool though I be, from the midst of those who think themselves wise 

and skilled in the law and mighty orators and powerful in 

everything.’ Who were these 'rhetorici' that have made this passage 

so difficult for commentators and have caused so various 

constructions to be put upon it? It is clear, the professor 

maintains, that the reference is to pagan rhetors from Gaul whose 

arrogant presumption, founded on their learning, made them regard 

with disdain 


---

p.xix




the comparatively illiterate apostle of the Scots. 

Everyone is familiar with the classic passage of Tacitus wherein he 

alludes to the harbours of Ireland as being more familiar to 

continental mariners than those of Britain. We have references 

moreover to refugee Christians who fled to Ireland from the 

persecutions of Diocletian more than a century before St. Patrick's 

day; in addition it is abundantly evident that many 

Irishmen—Christians like Celestius the lieutenant of Pelagius, and 

possibly Pelagius himself, amongst them—had risen to distinction or 

notoriety abroad before middle of the fifth century.


Possibly the best way to present the question of Declan's age is to 

put in tabulated form the arguments of the pre-Patrician advocates 

against the counter contentions of those who claim that Declan's 

period is later than Patrick's:—



1. Positive statement of Life, corroborated by Lives of SS. Ciaran and Ailbhe.
2. Patrick's apparent avoidance of the Principality of Decies.
3. The peculiar Declan cult and the strong local hold which Declan has maintained.


1. Contradictions, anachronisms, etc., of Life.
2. Lack of allusion to Declan in the Lives of St. Patrick.
3. Prosper's testimony to the mission of Palladius as first bishop to the believing Scots.
4. Alleged motives for later invention of Pre-Patrician story.



In this matter and at this hour it is hardly worth appealing to the authority of Lanigan and the scholars of the past. Much evidence not available in Lanigan's day is now at the service of scholars. We are to look rather at the reasoning of Colgan, Ussher, and Lanigan than to the mere weight of their names.


Referring in order to our tabulated grounds of argument, pro and con, and taking the pro arguments first, we may (I.) discard as 

evidence for our purpose the Life of St. Ibar which is very fragmentary and otherwise a rather unsatisfactory document. The Lives 

of Ailbhe, Ciaran, and Declan are however mutually corroborative and consistent. The Roman visit and the alleged tutelage under Hilarius 

are probably embellishments; they look like inventions to explain something and they may contain more than a kernel of truth. At any 

rate they are matters requiring further investigation and elucidation. In this connection it may 


---

p.xx




be useful to recall that the Life (Latin) of St. Ciaran has been attributed by Colgan to Evinus the disciple and panegyrist of St. Patrick.


Patrick's apparent neglect of the Decies (II.) may have no special significance. At best it is but negative evidence: taken, however, in connection with (I.) and its consectaria it is suggestive. We can hardly help speculating why the apostle—passing as it were by its front door—should have given the go-bye to a region so important as the Munster Decies. Perhaps he sent preachers into it; perhaps there was no special necessity for a formal mission, as the faith had already found entrance. It is a little noteworthy too that we do not find St. Patrick's name surviving in any ecclesiastical connection with the Decies, if we except Patrick's Well, near Clonmel, and this Well is within a mile or so of the territorial frontier. Moreover the southern portion of the present Tipperary County had been ceded by Aengus to the Deisi, only just previous to Patrick's advent, and had hardly yet had sufficient time to become absorbed. The whole story of Declan's alleged relations with Patrick undoubtedly suggests some irregularity in Declan's mission—an irregularity which was capable of rectification through Patrick and which de

 facto was 

finally so rectified.


(III.) No one in Eastern Munster requires to be told how strong is 

the cult of St. Declan throughout Decies and the adjacent territory. 

It is hardly too much to say that the Declan tradition in Waterford 

and Cork is a spiritual actuality, extraordinary and unique, even in 

a land which till recently paid special popular honour to its local 

saints. In traditional popular regard Declan in the Decies has ever 

stood first, foremost, and pioneer. Carthage, founder of the tribal 

see, has held and holds in the imagination of the people only a 

secondary place. Declan, whencesoever or whenever he came, is 

regarded as the spiritual father to whom the Deisi owe the gift of 

faith. How far this tradition and the implied belief in Declan's 

priority and independent mission are derived from circulation of the 

 Life throughout Munster in the last few centuries it is difficult 

to gauge, but the tradition seems to have flourished as vigorously in 

the days of Colgan as it does to-day. Declan's 'pattern' at Ardmore 

continues to be still the 


---

p.xxi




most noted celebration of its kind in Ireland. A few years ago it was participated in by as many as 

fourteen thousand people from all parts of Waterford, Cork, and 

Tipperary. The scenes and ceremonies have been so frequently 

described that it is not necessary to recount them here—suffice it 

to say that the devotional practices and, in fact, the whole 

celebration is of a purely popular character receiving no 

approbation, and but bare toleration, from church or clergy. Even to 

the present day Declan's name is borne as their praenomen by hundreds 

of Waterford men, and, before introduction of the modern practice of 

christening with foolish foreign names, its use was far more common, 

as the ancient baptismal registers of Ardmore, Old Parish, and 

Clashmore attest. On the other hand Declan's name is associated with 

comparatively few places in the Decies. Of these the best known is 

Relig Deaglain, a disused graveyard and early church site on the 

townland of Drumroe, near Cappoquin. There was also an ancient 

church called Killdeglain, near Stradbally.


Against the theory of the pre-Patrician or citra-Patrician mission 

we have first the objection, which really has no weight, and which we 

shall not stop to discuss, that it is impossible for Christianity at 

that early date to have found its way to this distant island, beyond 

the boundary of the world. An argument on a different plane is (I.), 

the undoubtedly contradictory and inconsistent character of the Life. 

It is easy however to exaggerate the importance of this point. 

Modern critical methods were undreamed of in the days of our 

hagiographer, who wrote, moreover, for edification only in a 

credulous age. Most of the historical documents of the period are in 

a greater or less degree uncritical but that does not discredit their 

testimony however much it may confuse their editors. It can be urged 

moreover that two mutually incompatible genealogies of the saint are 

given. The genealogy given by MacFirbisigh seems in fact to disagree 

in almost every possible detail with the genealogy in 23 M. 50 R.I.A. 

That however is like an argument that Declan never existed. It 

really suggests and almost postulates the existence of a second 

Declan whose Acts and those of our Declan have become mutually 

confused.




---

p.xxii


(II.) Absence of Declan's name from the Acts of Patrick is a 

negative argument. It is explicable perhaps by the supposed 

irregularity of Declan's preaching. Declan was certainly earlier 

than Mochuda and yet there is no reference to him in the Life of the 

latter saint. Ailbhe however is referred to in the Tripartite Life 

of Patrick and the cases of Ailbhe and Declan are a pari; the two 

saints stand or fall together.


IV.) Motives for invention of the pre-Patrician myth are alleged, 

scil.:—to rebut certain claims to jurisdiction, tribute or 

visitation advanced by Armagh in after ages. It is hard to see 

however how resistance to the claims in question could be better 

justified on the theory of a pre-Patrician Declan, who admittedly 

acknowledged Patrick's supremacy, than on the admission of a 

post-Patrician mission.


That in Declan we have to deal with a very early Christian teacher 

of the Decies there can be no doubt. If not anterior to Patrick he 

must have been the latter's cotemporary. Declan however had failed 

to convert the chieftain of his race and for this—reading between 

the lines of the Life—we seem to hear Patrick blaming him.


The monuments proper of Declan remaining at Ardmore are (a) his 

ORATORY near the Cathedral and Round Tower in the graveyard, (b) his 

STONE on the beach, (c) his WELL on the cliff, and (d) ANOTHER STONE 

said to have been found in his tomb and preserved at Ardmore for long 

ages with great reveration. The Life refers moreover to the 

saint's pastoral staff and his bell but these have disappeared for 

centuries.


The 'Oratory' is simply a primitive church of the usual sixth 

century type: it stands 13' 4" x 8' 9" in the clear, and has, or had, 

the usual high-pitched gables and square-headed west doorway with 

inclining jambs. Another characteristic feature of the early oratory 

is seen in the curious antae or prolongation of the side walls. 

Locally the little building is known as the beannachán, in allusion, 

most likely, to its high gables or the finials which once, no doubt, 

in Irish fashion, adorned its roof. Though somewhat later than 

Declan's time this primitive building is very intimately connected 

with the Saint. Popularly it is supposed 


---

p.xxiii




to be his grave and within it is a hollow space scooped out, wherein it is said his ashes once reposed. It is highly probable that tradition is quite correct as to the saint's grave, over which the little church was erected in the century following Declan's death. The oratory was furnished with a roof of slate by Bishop Mills in 1716.


'St. Declan's Stone' is a glacial boulder of very hard conglomerate 

which lies on a rocky ledge of beach beneath the village of Ardmore. 

It measures some 8' 6" x 4' 6" x 4' 0" and reposes upon two slightly 

jutting points of the underlying metamorphic rock. Wonderful virtues 

are attributed to St. Declan's Stone, which, on the occasion of the 

patronal feast, is visited by hundreds of devotees who, to 

participate in its healing efficacy and beneficence, crawl 

laboriously on face and hands through the narrow space between the 

boulder and the underlying rock. Near by, at foot of a new 

storm-wall, are two similar but somewhat smaller boulders which, like 

their venerated and more famous neighbour, were all wrenched 

originally by a glacier from their home in the Comeragh Mountains 

twenty miles away.


'St. Declan's Well,' beside some remains of a rather large and 

apparently twelfth century church on the cliff, in the townland of 

Dysert is diverted into a shallow basin in which pilgrims bathe feet 

and hands. Set in some comparatively modern masonry over the well 

are a carved crucifixion and other figures of apparently late 

mediaeval character. Some malicious interference with this well led, 

nearly a hundred years since, to much popular indignation and 

excitement.


The second 'St. Declan's Stone' was a small, cross-inscribed 

jet-black piece of slate or marble, approximately—2" or 3" x 1 1/2". 

Formerly it seems to have had a small silver cross inset and was in 

great demand locally as an amulet for cattle curing. It disappeared 

however, some fifty years or so since, but very probably it could 

still be recovered in Dungarvan.


Far the most striking of all the monuments at Ardmore is, of 

course, the Round Tower which, in an excellent state of preservation, 

stands with its conical cap of stone nearly a hundred feet high. Two 

remarkable, if not unique, features of the tower are 


---

p.xxiv




the series of sculptured corbels which project between the floors on the inside, 

and the four projecting belts or zones of masonry which divide the 

tower into storeys externally. The tower's architectural anomalies 

are paralleled by its history which is correspondingly unique: it 

stood a regular siege in 1642, when ordnance was brought to bear on 

it and it was defended by forty confederates against the English 

under Lords Dungarvan and Broghil.


A few yards to north of the Round Tower stands 'The Cathedral' 

illustrating almost every phase of ecclesiastical architecture which 

flourished in Ireland from St. Patrick to the Reformation—Cyclopean, 

Celtic-Romanesque, Transitional and Pointed. The chancel arch is 

possibly the most remarkable and beautiful illustration of the 

Transitional that we have. An extraordinary feature of the church is 

the wonderful series of Celtic arcades and panels filled with archaic 

sculptures in relief which occupy the whole external face of the west 

gable.


St. Declan's foundation at Ardmore seems (teste Moran's Archdall) 

to have been one of the Irish religious houses which accepted the 

reform of Pope Innocent at the Lateran Council and to have 

transformed itself into a Regular Canonry. It would however be 

possible to hold, on the evidence, that it degenerated into a mere 

parochial church. We hear indeed of two or three episcopal 

successors of the saint, scil.:—Ultan who immediately followed him, 

Eugene who witnessed a charter to the abbey of Cork in 1174, and 

Moelettrim O Duibhe-rathre who died in 1303 after he had, according 

to the annals of Inisfallen, ‘erected and finished the Church’ of 

Ardmore. The Wars of the Gaedhil and Gall have reference, circa 

824 or 825, to plunder by the Northmen of Disert Tipraite which is 

almost certainly the church of Dysert by the Holy Well at Ardmore. 

The same fleet, on the same expedition, plundered Dunderrow (near 

Kinsale), Inisshannon (Bandon River), Lismore, and Kilmolash.


Regarding the age of our Life it is difficult with

 the data at hand to say anything very definite. While dogmatism however is 

dangerous indefiniteness is unsatisfying. True, we cannot trace the 

genealogy of the present version beyond middle of the sixteenth


---

p.xxv




 

century, but its references to ancient monuments existing at date of 

its compilation show it to be many centuries older. Its language 

proves little or nothing, for, being a popular work, it would be 

modernised to date by each successive scribe. Colgan was of opinion 

it was a composition of the eighth century. Ussher and Ware, who had 

the Life in very ancient codices, also thought it of great antiquity. 

Papebrach, the Bollandist, on the other hand, considered the Life 

could not be older than the twelfth century, but this opinion of his 

seems to have been based on a misapprehension. In the absence of all 

diocesan colour or allusion one feels constrained to assign the 

production to some period previous to Rathbreasail. We should not 

perhaps be far wrong in assigning the first collection of materials 

to somewhere in the eighth century or in the century succeeding. The 

very vigorous ecclesiastical revival of the eleventh century, at 

conclusion of the Danish wars, must have led to some revision of the 

country's religious literature. The introduction, a century 

and-a-half later, of the great religious orders most probably led to 

translation of the Life into Latin and its casting into shape for 

reading in refectory or choir.


Only three surviving copies of the Irish Life are known to the 

writer: one in the Royal Library at Brussels, the second in the Royal 

Irish Academy Collection (M. 23, 50, pp. 109-120), and the third in 

possession of Professor Hyde. As the second and third enumerated are 

copies of one imperfect exemplar it has not been thought necessary to 

collate both with the Brussels MS. which has furnished the text here 

printed. M. 23, 50 (R.I.A.) has however been so collated and the 

marginal references initialled B are to that imperfect copy. The 

latter, by the way, is in the handwriting of John Murphy na 

Raheenach, and is dated 1740. It has not been thought necessary to 

give more than the important variants.


The present text is a reproduction of the Brussels MS. plus lengthening of contractions. As regards lengthening in question it is to be noted that the well known contraction for ea or e

 has been uniformly transliterated e. Otherwise

 orthography of the MS. has been scrupulously followed—even where inconsistent or incorrect. For the division into paragraphs the editor is not 


---

p.xxvi




responsible; he has merely followed the division originated, or adopted, by the 

scribe. The Life herewith presented was copied in 1629 by Brother 

Michael O'Clery of the Four Masters' staff from an older MS. of Eochy 

O'Heffernan's dated 1582. The MS. of O'Heffernan is referred to by 

our scribe as seinleabhar, but his reference is rather to the 

contents than to the copy. Apparently O'Clery did more than 

transcribe; he re-edited, as was his wont, into the literary Irish of 

his day. A page of the Brussels MS., reproduced in facsimile as a 

frontispiece to the present volume, will give the student a good idea 

of O'Clery's script and style.


Occasional notes on Declan in the martyrologies and elsewhere give 

some further information about our saint. Unfortunately however the 

alleged facts are not always capable of reconciliation with 

statements of our Life, and again the existence of a second, 

otherwise unknown, Declan is suggested. The introduction of rye is 

attributed to him in the Calendar of Oengus, as introduction of wheat 

is credited to St. Finan Camm, and introduction of bees to St. 

Modomnoc,—‘It was the full of his shoe that Declan brought, the full 

of his shoe likewise Finan, but the full of his bell Modomnoc’ ( Cal. 

Oeng., April 7th). More puzzling is the note in the same Calendar 

which makes Declan a foster son of Mogue of Ferns! This entry 

illustrates the way in which errors originate. A former scribe 

inadvertently copied in, after Declan's name, portion of the entry 

immediately following which relates to Colman Hua Liathain. 

Successive scribes re-copied the error without discovering it and so 

it became stereotyped.




---

p.1


The most blessed Bishop Declan of the most noble race of the kings of Ireland, i.e., the holy bishop who is called Declan was of 

the most noble royal family of Ireland—a family which held the sceptre and exacted tribute from all Ireland at Tara for ages. Declan 

was by birth of noble blood as will appear from his origin and genealogy, for it was from Eochaidh Feidhleach, the powerful Ardrigh 

of Ireland for twelve years, that he sprang. Eochaidh aforesaid, had three sons, scil.:—Breas, Nar, and Lothola, who are called the three 

Finneavna; there reigned one hundred and seven kings of their race and kindred before and after them, i.e. of the race of Eremon, king 

of Ireland,—before the introduction of Christianity and since. These three youths lay one day with their own sister Clothra, 

daughter of the same father, and she conceived of them. The son she brought forth as a consequence of that intercourse was marked by 

three red wavy lines which indicated his descent from the three youths aforesaid. He was named Lugaidh Sriabhdearg from the three 

lines in question, and he was beautiful to behold and of greater bodily strength in infancy than is usual with children of his 

age. He commenced his reign as king of Ireland the year in which Caius Caesar died and he reigned for twenty-six years. 

His son was named Criomthan Nianair who reigned but sixteen years. Criomthan's son was named Fearadach Finnfechtnach whose son was


---

p.5




Fiacha Finnolaidh whose son again was Tuathal Teachtmhar. This Tuathal had a son Felimidh Reachtmhar who had in turn three 

sons—Conn Ceadcathach, Eochaidh Finn, and Fiacha Suighde. Conn was king of Ireland for twenty years and the productiveness of crops and 

soil and of dairies in the time of Conn are worthy of commemoration and of fame to the end of time. Conn was killed in Magh Cobha by the 

Ulstermen, scil.:—by Tiopruid Tireach and it is principally his seed which has held the kingship of Ireland ever since. Eochaidh Finn was 

second son to Felimidh Reachtmhar and he migrated to the latter's province of Leinster, and it is in that province his race and progeny 

have remained since then. They are called Leinstermen, and there are many chieftains and powerful persons of them in Leinster. Fiacha 

Suighde moreover, although he died before he succeeded to the chief sovereignty, possessed land around Tara. He left three sons—Ross, 

Oengus, and Eoghan who were renowned for martial deeds—valiant and heroic in battle and in conflict. Of the three, Oengus excelled in 

all gallant deeds so that he came to be styled Oengus of the poisonous javelin. Cormac Mac Art Mac Conn it was who reigned in 

Ireland at this time. Cormac had a son named Ceallach who took by force the daughter of Eoghan Mac Fiacha Suighde to dwell with him, 

i.e. Credhe the daughter of Eoghan. When Oengus Gaebuaibhtheach ('of the poisonous javelin') heard this, viz., that the daughter of his 

brother had been abducted by Ceallach he was roused to fury and he followed Ceallach to Tara taking with him his foster child, 

scil.:—Corc Duibhne, the son of Cairbre, son of Conaire, son of Mogha Lamha whom Cormac held as a hostage from the Munstermen, and 

whom 


---

p.7




he had given for safe custody to Oengus. When Oengus reached Tara he beheld Ceallach sitting behind Cormac. He thrust his spear 

at Ceallach and pierced him through from front to back. However as he was withdrawing the spear the handle struck Cormac's eye and knocked 

it out and then, striking the steward, killed him. He himself (Oengus) with his foster child escaped safely. After a time Cormac, 

grieving for the loss of his son, his eye and his steward at the hands of Oengus of the poisonous javelin and of his kinsmen, ordered 

their expulsion from their tribal territory, i.e. from the Decies of Tara, and not alone from these, but from whole northern half of 

Ireland. However, seven battles were fought in which tremendous loss was inflicted on Cormac and his followers before Oengus and his 

people, i.e. the three sons of Fiacha Suighde, namely, Ross and Oengus and Eoghan, as we have already said, were eventually defeated, 

and obliged to fly the country and to suffer exile. Consequent on their banishment as above by the king of Ireland they sought 

hospitality from the king of Munster, Oilill Olum, because Sadhbh, daughter of Conn Ceadcathach was his wife. They got land from him, 

scil.: the Decies of Munster, and it is to that race, i.e. the race of Eoghan Mac Fiacha Suighde that the kings and country of the Decies 

belong ever since.


Of this same race of Eoghan was the holy bishop Declan of whom I shall speak later scil.: Declan son of Eirc, son of Trein, son of 

Lughaidh, son of Miaich, son of Brian, son of Eoghan, son of Art Corp, son of Moscorb, son of Mesgeadra, son of Measfore, son of Cuana 

Cainbhreathaigh, son of Conaire Cathbuadhaigh, son of Cairbre, son of Eoghan, son of Fiacha Suighde, son of Felimidh Reachtmhar, son of 

Tuathal Teachtmhar.


The father of Declan was therefore Erc Mac Trein. He and 


---

p.9




his wife Deithin went on a visit to the house of his kinsman Dobhran about the time that Declan's birth was due. The child she 

bore was Declan, whom she brought forth without sickness, pain or difficulty but in being lifted up afterwards he struck his head 

against a great stone. Let it be mentioned that Declan showed proofs of sanctification and power of miracle-working in his mother's womb, 

as the prophet writes:—‘De vulva sanctificavi te et prophetam in gentibus dedi te’(Before thou camest forth out of the 

womb I sanctified thee and made thee a prophet unto the nations).[1](javascript:footNote('T201020/note001.html')) 

Thus it is that Declan was sanctified in his mother's womb and was given by God as a prophet to the pagans for the conversion of 

multitudes of them from heathenism and the misery of unbelief to the worship of Christ and to the Catholic faith, as we shall see later 

on. The very soft apex of his head struck against a hard stone, as we have said, and where the head came in contact with the stone it 

made therein a hollow and cavity of its own form and shape, without injury of any kind to him. Great wonder thereupon seized all who 

witnessed this, for Ireland was at this time without the true faith and it was rarely that any one (therein) had shown heavenly Christian 

signs. 'Declan's Rock' is the name of the stone with which the Saint's head came into contact. The water or rain which falls into 

the before-mentioned cavity (the place of Declan's head) dispels sickness and infirmity, by the grace of God, as proof of Declan's 

sanctity.


On the night of Declan's birth a wondrous sign was revealed to all, that is to the people who were in the neighbourhood of the 

birthplace; this was a ball of fire which was seen blazing on summit of the house in which the child lay, until it reached up to heaven 

and down again, and it was surrounded by a multitude of angels. It assumed the shape 


---

p.11




of a ladder[2](javascript:footNote('T201020/note002.html')) such as the Patriarch, Jacob saw. The persons who saw and heard these things wondered 

at them. They did not know (for the true faith had not yet been preached to them or in this region) that it was God who (thus) manifested His wondrous power (works) in the infant, His chosen 

child. Upon the foregoing manifestation a certain true Christian, scil.:—Colman, at that time a priest and afterwards a holy bishop, 

came, rejoicing greatly and filled with the spirit of prophecy, to the place where Declan was; he preached the faith of Christ to the 

parents and made known to them that the child was full of the grace of God. He moreover revealed to them the height of glory and honour 

to which the infant should attain before God and men, and it was revealed to him that he (Declan) should spend his life in sanctity 

and devotion. Through the grace of God, these, i.e. Erc and Deithin, believed in God and Colman, and they delivered the child for baptism 

to Colman who baptised him thereupon, giving him the name of Declan. When, in the presence of all, he had administered Baptism, Colman 

spoke this prophecy concerning the infant ‘Truly, beloved child and lord you will be in heaven and on earth most high and holy, and your 

good deeds, fame, and sanctity will fill all (the four quarters of) Ireland and you will convert your own nation and the Decies from 

paganism to Christianity. On that account I bind myself to you by the tie of brotherhood and I commend myself to your sanctity.’


Colman thereupon returned to his own abode; he commanded that 

Declan should be brought up with due care, that he should be 


---

p.13




well trained, and be set to study at the age of seven years if there could 

be found in his neighbourhood a competent Christian scholar to 

undertake his tuition. Even at the period of his baptism grace and 

surpassing charity manifested themselves in the countenance of Declan 

so that it was understood of all that great should be the goodness 

and the spiritual charm of his mature age. When Dobhran had heard 

and seen these things concerning his kinsman Erc he requested the 

latter and Deithin to give him the child to foster, and with this 

request Erc complied. The name of the locality was 'Dobhran's Place' 

at that time, but since then it has been 'Declan's Place.' Dobhran 

presented the homestead to Declan and removed his own dwelling thence 

to another place. In after years, when Declan had become a bishop, 

he erected there a celebrated cell in honour of God, and this is the 

situation of the cell in question:—In the southern part of the 

Decies, on the east side of Magh Sgiath and not far from the city of 

Mochuda i.e. Lismore. For the space of seven years Declan was 

fostered with great care by Dobhran (his father's brother) and was 

much loved by him. God wrought many striking miracles through 

Declan's instrumentality during those years. By aid of the Holy 

Spirit dwelling in him he (Declan)—discreet Christian man that he 

was—avoided every fault and every unlawful desire during that time.


On the completion of seven years Declan was taken

 from his 

parents and friends and fosterers to be sent to study as Colman had 

ordained. It was to Dioma they sent him, a certain devout man 

perfect in the faith, who had come at that time by God's design into 

Ireland having spent a long period abroad in acquiring learning. He 

(Dioma) built in that place a small cell wherein he might 


---

p.15




instruct Declan and dwell himself. There was given him also, to instruct, 

together with Declan, another child, scil., Cairbre Mac Colmain, who 

became afterwards a holy learned bishop. Both these were for a 

considerable period pursuing their studies together.


There were seven men dwelling in Magh Sgiath, who

 frequently saw 

the fiery globe which it has been already told they first beheld at 

the time of Declan's birth. It happened by the Grace of God that 

they were the first persons to reveal and describe that lightning. 

These seven came to the place where Declan abode and took him for 

their director and master. They made known publicly in the presence 

of all that, later on, he should be a bishop and they spoke 

prophetically:—‘The day, O beloved child and servant of God, will 

come when we shall commit ourselves and our lands to thee.’ And it 

fell out thus (as they foretold), for, upon believing, they were 

baptised and became wise, devout and attentive and erected seven 

churches in honour of God around Magh Sgiath.


Declan remained a long time with Dioma, the holy

 man we have 

named, and acquired science and sanctity and diversity of learning 

and doctrine, and he was prudent, mild, and capable so that many who 

knew his nobility of blood came when they had heard of the fullness 

of his sanctity and grace. Moreover they submitted themselves to him 

and accepted his religious rule. Declan judged it proper that he 

should visit Rome to study discipline and ecclesiastical system, to 

secure for himself esteem 


---

p.17




and approbation thence, and obtain authority to preach to the Irish people and to bring back with him 

the rules of Rome as these obtained in Rome itself. He set out with his followers and he tarried not till he arrived in Rome where they remained some time.


At the same period there was a holy bishop, i.e. Ailbe, who had 

been in Rome for a number of years before this and was in the 

household of Pope Hilary by whom he had been made a bishop. When 

Declan with his disciples arrived in Rome Ailbe received him with 

great affection and gladness and he bore testimony before the Roman 

people to his Declan's sanctity of life and nobility of blood. Declan therefore received marks of honour and sincere affection from the people and clergy of Rome when they came to understand how 

worthy he was, for he was comely, of good appearance, humble in act, 

sweet in speech, prudent in counsel, frank in conversation, virtuous 

in mien, generous in gifts, holy in life and resplendent in miracles.


When Declan had spent a considerable time in Rome

 he was ordained 

a bishop by the Pope, who gave him church-books and rules and orders 

and sent him to Ireland that he might preach there. Having bidden 

farewell to the Pope and received the latter's blessing Declan 

commenced his journey to Ireland. Many Romans followed him to 

Ireland to perform their pilgrimage and to spend their lives there 

under the yoke and rule of Bishop Declan, and amongst those who 

accompanied him was Runan, son of the king of Rome; he was dear to 

Declan.


On the road through Italy Bishop Declan and

 Patrick met. Patrick 

was not a bishop at that time, though he was (made a bishop) 


---

p.19




subsequently by Pope Celestinus, who sent him to preach to the Irish. 

Patrick was truly chief bishop of the Irish island. They bade 

farewell to one another and they made a league and bond of mutual 

fraternity and kissed in token of peace. They departed thereupon 

each on his own journey, scil.:—Declan to Ireland and Patrick to 

Rome.


Declan was beginning mass one day in a church

 which lay in his 

road, when there was sent him from heaven a little black bell, which 

came in through the window of the church and remained on the altar 

before Declan. Declan greatly rejoiced thereat and gave thanks and 

glory to Christ on account of it, and it filled him with much courage 

to combat the error and false teaching of heathendom. He gave the 

bell for safe keeping and carriage, to Runan aforesaid, i.e. son of 

the king of Rome, and this is its name in Ireland—‘The Duibhin 

Declain,’ and it is from its colour it derives its name, for its 

colour is black. There were manifested, by grace of God and 

Declan's merits, many miracles through its agency and it is still 

preserved in Declan's church.


When Declan and his holy companions arrived at

 the Sea of Icht[3](javascript:footNote('T201020/note003.html')) he failed,

 owing to lack of money, to find a ship, 

for he did not have the amount demanded, and every ship was refused 

him on that account. He therefore struck his bell and prayed to God 

for help in this extremity. In a short time after this they saw 

coming towards them on the crest of the waves an empty, sailless ship 

and no man therein. Thereupon Declan said:—‘Let us enter the ship 

in the name of Christ, and He who has sent it to us will direct it 

skilfully to what harbour soever He wishes we should go.’ At the 

word of Declan they entered in, and the ship floated tranquilly and 

safely until it reached harbour in England. Upon its abandonment by 

Declan and his disciples the ship turned 


---

p.21




back and went again to the place from which it had come and the people who saw the miracles and heard of them magnified the name of the Lord and Declan, and the words of the prophet David were verified:—‘Mirabilis Deus in Sanctis Suis (God is wonderful in His Saints).’


After this Declan came to Ireland. Declan was

 wise like a serpent and gentle like a dove and industrious like the bee, for as the bee gathers honey and avoids the poisonous herbs so did Declan, for he gathered the sweet sap of grace and Holy Scripture till he was filled therewith. There were in Ireland before Patrick came thither four holy bishops with their followers who evangelized and sowed the word of God there; these are the four:—Ailbe, Bishop Ibar, Declan, 

and Ciaran. They drew multitudes from error to the faith of Christ, although it was Patrick who sowed the faith throughout Ireland and it is he who turned chiefs and kings of Ireland to the way of baptism, faith and sacrifice and everlasting judgment.


These three, scil.:—Declan, Ailbe and

 Bishop Ibar made a bond of friendship and a league amongst themselves and their spiritual posterity in heaven and on earth for ever and they loved one another. SS. Ailbe and Declan, especially, loved one another as if they were brothers so that, on account of their mutual affection they did not 

like to be separated from one another—except when their followers threatened to separate them by force if they did not go apart for a very short time. After this Declan returned to his own country—to the Decies of Munster—where he preached, and baptized, in the name of Christ, many whom he turned to the Catholic faith from the power of the devil. He built numerous churches in which he placed many of his own followers to serve 


---

p.23




and worship God and to draw people to God from the wiles of Satan.


Once on a time Declan came on a visit to the

 place of his birth, where he remained forty days there and established a religious house in which devout men have dwelt ever since. Then came the seven men we have already mentioned as having made their abode around Magh Sgiath and as having prophesied concerning Declan. They now dedicated themselves and their establishment to him as they had promised and these are their names:—Mocellac and Riadan, Colman, Lactain, 

Finnlaoc, Kevin, etc. These therefore were under the rule and 

spiritual sway of bishop Declan thenceforward, and they spent their 

lives devoutly there and wrought many wonders afterwards.


After some time Declan set out to visit Aongus MacNatfrich, king 

of Cashel, to preach to him and to convert him to the faith of 

Christ. Declan however had two uterine brothers, sons of Aongus, 

scil.: Colman and Eoghan. The grace of the Holy Ghost inspiring him 

Colman went to Ailbe of Emly and received baptism and the religious 

habit at the latter's hands, and he remained for a space sedulously 

studying science until he became a saintly and perfect man. Eochaid 

however remained as he was at home—expecting the kingdom of 

Munster on his father's death, and he besought his father to show due 

honour to his brother Declan. The king did so and put no obstacle in 

the way of Declan's preaching but was pleased with Declan's religion 

and doctrine, although he neither believed nor accepted baptism 

himself. It is said that refusal (of baptism) was based on this 

ground: Declan was of the Decies and of Conn's Half, while Aongus 

himself was of the Eoghanacht of 


---

p.25




Cashel of Munster—always hostile to the Desii. It was not therefore through ill will to the faith that 

he believed not, as is proved from this that, when the king heard of 

the coming to him of Patrick, the archbishop of Ireland, a man who 

was of British race against which the Irish cherished no hate, not 

only did he believe but he went from his own city of Cashel to meet 

him, professed Christianity and was immediately baptised.


After this Declan, having sown the word of God

 and preached to 

the king (although the latter did not assent to his doctrines), 

proceeded to his own country and they (the Desii) believed and 

received baptism except the king alone and the people of his 

household who were every day promising to believe and be baptised. 

It however came about through the Devil's agency that they hesitated 

continually and procrastinated.


Other authorities declare that Declan went many

 times to Rome, 

but we have no written testimony from the ancient biographers that he 

went there more than three times. On one of these occasions Declan 

paid a visit to the holy bishop of the Britons whose name was David 

at the church which is called Killmuine where the bishop 

dwelt beside the shore of the sea which divides Ireland from Britain. 

The bishop received Declan with honour and he remained there forty 

days, in affection and joy, and they sang Mass each day and they 

entered into a bond of charity which continued between themselves and 

their successors for ever afterwards. On the expiration of the forty 

days Declan took leave of David giving him a kiss in token of peace 

and set out himself and his followers to the shore of the sea to take 

ship for Ireland.


Now the bell which we have alluded to as sent

 from heaven to 

Declan, was, at that time, in the custody of Runan to carry as we 

have said, for Declan did not wish, on any 


---

p.27




account, to part with it. On this particular day as they were proceeding towards the ship Runan 

entrusted it to another member of the company. On reaching the shore 

however the latter laid the bell on a rock by the shore and forgot it 

till they were half way across the sea. Then they remembered it and 

on remembrance they were much distressed. Declan was very sorrowful 

that the gift sent him by the Lord from heaven should have been 

forgotten in a place where he never expected to find it again. 

Thereupon raising his eyes heavenward he prayed to God within his 

heart and he said to his followers:—‘Lay aside your sorrow for it is 

possible with God who sent that bell in the beginning to send it now 

again by some marvellous ship.’ Very fully and wonderfully and 

beautifully the creature without reason or understanding obeyed its 

creator, for the very heavy unwieldy rock floated buoyantly and 

without deviation, so that in a short time they beheld it in their 

rear with the bell upon it. And when his people saw this wondrous 

thing it filled them with love for God and reverence for their 

master. Declan thereupon addressed them prophetically:—‘Permit the 

bell to precede you and follow it exactly and whatsoever haven it 

will enter into it is there my city and my bishopric will be whence I 

shall go to paradise and there my resurrection will be.’ Meantime 

the bell preceded the ship, and it eased down its great speed 

remaining slightly in advance of the ship, so that it could be seen 

from and not overtaken by the latter. The bell directed its course 

to Ireland until it reached a harbour on the south coast, scil.:—in 

the Decies of Munster, at an island called, at that time, High Sheep 

Island and the ship made the same port, as Declan 

declared. The holy man went ashore and gave thanks and praise to 

God that he had reached the place of his resurrection. Now, in 

that island 


---

p.29




depastured the sheep belonging to the wife of the chieftain of Decies and it is thence that it derives its Irish 

name—Ard-na-Ccaorac, scil.:—there was in it a high hill and it was 

a promontory beautiful to behold. One of the party, ascending the 

summit of the hill, said to Declan:—‘How can this little height 

support your people?’ Declan replied:—‘Do not call it little hill, 

beloved son, but 'great height',’ and that name has adhered 

to the city ever since, scil.:—Ardmore-Declain. After this Declan 

went to the king of the Desii and asked of him the aforesaid island. 

Whereupon the king gave it to him.


Declan next returned to Ait-mBreasail where, in

 a haven at the 

north side, were the shipping and boats of the island, plying thither 

and backwards. The people of the island hid all their boats not 

willing that Declan should settle there; they dreaded greatly that if 

Declan came to dwell there they themselves should be expelled. 

Whereupon his disciples addressed Declan:—‘Father,’ said they, ‘Many 

things are required (scil.: from the mainland) and we must often go 

by boat to this island and there will be crossing more frequently 

when you have gone to heaven and we pray thee to abandon the place or 

else to obtain from God that the sea recede from the land so that it 

can be entered dry shod, for Christ has said:—‘Whatsoever you shall 

ask of the Father in my name He may give it to you’; 

the place cannot be easily inhabited unless the sea recede from it 

and on that account you cannot establish your city in it.’ Declan 

answered them and said:— 'How can I abandon the place ordained by God 

and in which He has promised that my burial and resurrection shall 

be? As to the alleged inconvenience of dwelling 


---

p.31




therein, do you wish me to pray to God for things contrary to His will—to deprive the 

sea of its natural domain? Nevertheless in compliance with your 

request I shall pray to God and whatever thing be God's will, let it 

be done.' Declan's community thereupon rose up and said:—‘Father, 

take your crosier as Moses took the rod and strike the 

sea therewith and God will thus show His will to you.’[4](javascript:footNote('T201020/note004.html')) His disciples 

prayed therefore to him because they were tried and holy men. They 

put Declan's crosier in his hand and he struck the water in the name 

of the Father and of the Son and of the Holy Ghost and made the sign 

of the cross over the water and immediately, by command and 

permission of God, the sea commenced to move out from its accustomed 

place—so swiftly too that the monsters of the sea were swimming and 

running and that it was with difficulty they escaped with the sea. 

However, many fishes were left behind on the dry strand owing to the 

suddenness of the ebb. Declan, his crosier in his hand, pursued the 

receding tide and his disciples followed after him. Moreover the sea 

and the departing monsters made much din and commotion and when 

Declan arrived at the place where is now the margin of the sea a 

stripling whose name was Mainchin, frightened at the thunder of the 

waves and the cry of the unknown monsters with gaping mouths 

following the (receding) water, exclaimed:—‘Father, you have driven 

out the sea far enough; for I am afraid of those horrid monsters.’ 

When Declan heard this and saw the sea standing still at the word 

of the youth it displeased him and turning round he struck him a 

slight blow on the nose. Three drops of blood flowed from the wound 

on to the ground 


---

p.33




in three separate places at the feet of Declan. Thereupon Declan blessed the nose and the blood ceased immediately 

(to flow). Then Declan declared:—‘It was not I who drove out the sea 

but God in His own great power who expelled it and He would have done 

still more had you not spoken the words you have said.’ Three little 

wells of clear sweet water burst forth in the place where fell the 

three drops of blood at the feet of Declan, and these wells are there 

still and the colour of blood is seen in them occasionally as a 

memorial of this miracle. The shore, rescued from the sea, is a mile 

in width and is of great length around (the island) and it is good 

and fertile land for tillage and pasture—lying beneath the monastery 

of Declan. As to the crosier which was in Declan's hand while he 

wrought this miracle, this is its name—the Feartach Declain, from 

the miracles and marvels wrought through it. I shall in 

another, subsequent, place relate some of these miracles (narrated).


After the expulsion of the sea by this famous

 Saint, scil.: 

Declan, whose name and renown spread throughout Erin because of his 

great and diverse miracles, he commenced to build a great monastery 

by the south side of the stream which flows through the island into 

the sea. This monastery is illustrious and beautiful and its name is 

Ardmor Declain, as we have said. After this came many persons to 

Declan, drawn from the uttermost parts of Ireland, by the fame of his 

holy living; they devoted themselves, soul and body to God and 

Declan, binding themselves beneath his yoke and his rule. Moreover 

he built himself in every place throughout the territory of the 

Decies, churches and monasteries 


---

p.35




and not alone in his own territory (did he build) but in other regions of Ireland under tribute to him. 

Great too were the multitudes (thousands) of men and women who were 

under his spiritual sway and rule, in the places we have referred to, 

throughout Ireland, where happily they passed their lives. He 

ordained some of his disciples bishops and appointed them in these 

places to sow the seed of faith and religion therein. Gentleness and 

charity manifested themselves in Declan to such an extent that his 

disciples preferred to live under his immediate control and under his 

direction as subjects than to be in authority in another monastery.


After this the holy renowned bishop, head of

 justice and faith 

in the Gaelic island came into Ireland, i.e. Patrick sent by 

Celestinus, the Pope. Aongus Mac Nathfrich went to meet him soon as 

he heard the account of his coming. He conducted him (Patrick) with 

reverence and great honour to his own royal city—to Cashel. Then 

Patrick baptised him and blessed himself and his people and his city. 

Patrick heard that the prince of the Decies had not been baptised and 

did not believe, that there was a disagreement between the prince and 

Declan and that the former refused to receive instruction from the 

latter. Patrick thereupon set out to preach to the prince aforesaid. 

Next, as to the four bishops we have named who had been in Rome: 

Except Declan alone they were not in perfect agreement with Patrick. 

It is true that subsequently to this they did enter into a league of 

peace and harmonious actions with Patrick and paid him fealty. 

Ciaran, however, paid him all respect and reverence and was of one 

mind 


---

p.37




with him present or absent. Ailbe then, when he saw the kings 

and rulers of Ireland paying homage to Patrick and going out to meet 

him, came himself to Cashel, to wait on him and he also paid homage 

to him (Patrick) and submitted to his jurisdiction, in presence of 

the king and all others. Bear in mind it was Ailbe whom the other 

holy bishops had elected their superior. He therefore came first to 

Patrick, lest the others, on his account, should offer opposition to 

Patrick, and also that by his example the others might be more easily 

drawn to his jurisdiction and rule. Bishop Ibar however would on no 

account consent to be subject to Patrick, for it was displeasing to 

him that a foreigner should be patron of Ireland. It happened that 

Patrick in his origin was of the Britons and he was nurtured in 

Ireland having been sold to bondage in his boyhood. There arose 

misunderstanding and dissension between Patrick and Bishop Ibar at 

first, although (eventually), by intervention of the angel of peace, 

they formed a mutual fellowship and brotherly compact and they 

remained in agreement for ever after. But Declan did not wish to 

disagree at all with Patrick for they had formed a mutual bond of 

friendship on the Italian highway and it is thus the angel commanded 

him to go to Patrick and obey him:—


The angel of God came to Declan and said to him

 ‘Go quickly to 

Patrick and prevent him cursing your kindred and country, for 

to-night, in the plain which is called Inneoin, he is fasting against 

the king, and if he curses your people they shall be accursed for 

ever.’ Thereupon Declan set out in haste by direction of the angel 

to Inneoin, i.e. the place which is in the centre of the plain of 

Femhin in the northern part of the Decies. He crossed Slieve Gua 

and over the Suir and arrived on the following 

morning at the place where Patrick was. When Patrick and his 

disciples 


---

p.39




heard that Declan was there they welcomed him warmly for 

they had been told he would not come. Moreover Patrick and his 

people received him with great honour. But Declan made obeisance to 

Patrick and besought him earnestly that he should not execrate his 

people and that he should not curse them nor the land in which they 

dwelt, and he promised to allow Patrick do as he pleased. And 

Patrick replied:—‘On account of your prayer not only shall I not 

curse them but I shall give them a blessing.’ Declan went thereupon 

to the place where was the king of Decies who was a neighbour of his. 

But he contemned Patrick and he would not believe him even at the 

request of Declan. Moreover Declan promised rewards to him if he 

would go to Patrick to receive baptism at his hands and assent to the 

faith. But he would not assent on any account. When Declan saw 

this, scil.:—that the king of the Decies, who was named Ledban, was 

obstinate in his infidelity and in his devilry—through fear lest 

Patrick should curse his race and country—he (Declan) turned to the 

assembly and addressed them:—‘Separate yourselves from this accursed 

man lest you become yourselves accursed on his account, for I have 

myself baptised and blessed you, but come you,’ said he, ‘with us, to 

Patrick, whom God has sent to bless you, for he has been chosen 

Archbishop and chief Patron of all Erin; moreover, I have a right to 

my own patrimony and to be king over you as that man (Ledban) has 

been.’ At this speech they all arose and followed Declan who brought 

them into the presence of Patrick 


---

p.41




and said to the latter:—‘See how the whole people of the Deisi have come with me as their Lord to thee 

and they have left the accursed prince whose subjects they have been, 

and behold they are ready to reverence you and to obey you for it is 

from me they have received baptism.’ At this Patrick rose up with 

his followers and he blessed the people of the Deisi and not them 

alone, but their woods and water and land. Whereupon the chiefs and 

nobles of the Deisi said:—‘Who will be King or Lord over us now?’ 

And Declan replied:—‘I am your lord and whomsoever I shall appoint 

offer you as lord, Patrick and all of us will bless, and he shall be 

king over you all.’ And he whom Declan appointed was Feargal 

MacCormac a certain young man of the nation of the Deisi who was a 

kinsman of Declan himself. He (Declan) set him in the midst of the 

assembly in the king's place and he was pleasing to all. Whereupon 

Patrick and Declan blessed him and each of them apart proclaimed him 

chieftain. Patrick moreover promised the young man that he should be 

brave and strong in battle, that the land should be fruitful during 

his reign. Thus have the kings of the Deisi always been.


After these things Declan and Feargal Mac Cormac

 (king of the 

Deisi) and his people gave a large area of land to Patrick in the 

neighbourhood of Magh Feimhin and this belongs to his successors ever 

since and great lordship there. And the place which was given over 

to him is not far from the Suir. There is a great very clear 

fountain there which is called 'Patrick's Well' and this was dear to 

Patrick. After this, with blessing, they took leave of one another 

and Patrick returned to Cashel to Aongus Mac Natfrich and Declan went 

with him.


A miracle was wrought at that time on Declan

 through the


---

p.43




 

intercession and prayers of Patrick for as Declan was walking 

carelessly along he trod upon a piece of sharp iron which cut his 

foot so that blood flowed freely and Declan began to limp. Ailbe of 

Emly was present at this miracle and Sechnall a bishop of Patrick's 

and a holy and wise man, and he is said to be the first bishop buried 

in Ireland. The wound which Declan had received grieved them very 

much. Patrick was informed of the accident and was grieved thereat. 

He said:—‘Heal, O Master (i.e. God), the foot of your own servant 

who bears much toil and hardship on your account.’ Patrick laid his 

hand on the wounded foot and made over it the sign of the cross when 

immediately the flow of blood ceased, the lips of the wound united, a 

cicatrix formed upon it and a cure was effected. Then Declan rose up 

with his foot healed and joined in praising God. The soldiers and 

fighting men who were present cried out loudly, blessing God and the 

saints.


As Patrick and the saints were in Cashel, i.e.

 Ailbe and Declan 

with their disciples, in the territory of Aongus Mac Nathfrich, they 

made much progress against paganism and errors in faith and they 

converted them (the pagans) to Christianity. It was ordained by 

Patrick and Aongus Mac Natfrich in presence of the assembly, that the 

Archbishopric of Munster should belong to Ailbe, and to Declan, in 

like manner, was ordained (committed) his own race, i.e. the Deisi, 

whom he had converted to be his parish and his episcopate. As the 

Irish should serve Patrick, so should the Deisi serve Declan as their 

patron, and Patrick made the **rann**:—

 


> 1. Humble Ailbe the Patrick of Munster, greater than any saying,
>   
> Declan, Patrick of the Deisi—the Decies to Declan for ever.
> 




---

p.45




 

This is equivalent to saying that Ailbe was a second Patrick and that 

Declan was a second Patrick of the Decies. After that, when the king 

had bidden them farewell and they had all taken leave of one another, 

the saints returned to their respective territories to sow therein 

the seed of faith.


Declan and Ferghal Mac Cormac, king of the

 Deisi, with his army 

and followers, met one another at Indeoin and they made still more 

strong on the people the bond of Christian obligation. The king we 

have already mentioned, scil.:—Ledban, the recusant to the Christian 

name, was rejected of all and he came to nothing, leaving no 

knowledge (memory) of his history, as is written of the enemies of 

the faith:—‘Their memory perisheth like a sound’. Moreover

 Declan and Fergal and the chief men of the Deisi decreed this as the place where the king of the Deisi should be inaugurated 

for ever thenceforward, because it was there Patrick and Declan 

blessed the king, Fergal; moreover tradition states that it was there 

the kings were crowned and ruled over the Deisi in pagan times.


At that time there broke out a dreadful plague

 in Munster and it 

was more deadly in Cashel than elsewhere. Thus it affected those 

whom it attacked: it first changed their colour to yellow and then 

killed them. Now Aongus had, in a stone fort called 'Rath na 

nIrlann,' on the western side of Cashel, seven noble hostages. It 

happened that in one and the same night they all died of the plague. 

The king was much affected thereat and he gave orders to have the 

fact concealed lest it should bring disgrace or even war upon him, 

for the hostages were scions of the strongest and most powerful 

families in Munster. On the morrow however Declan came to Cashel and 

talked with Aonghus. The king welcomed him heartily and addressing 

him said to him in presence of persons of his court, 'I pray you, 

Declan, servant of God, that 


---

p.47




in the name of Christ you would raise to life for me the seven hostages whom I held in bondage from the 

chieftains of Munster. They have died from the plague of which you 

hear, and I fear their fathers will raise war and rebellion against 

me, for they are men of strength and power, and indeed we are ashamed 

of their death, for they will say that it is we ourselves who killed 

them.' Declan answered the king, saying to him:—‘Such a matter as 

this—to raise one to life from death—belongs to Omnipotence 

alone—but I shall do whatever is in my power. I go where the bodies 

lie and pray to God for them and let Him do in their regard what 

seems best to Him.’ Next, Declan, with a multitude and his disciples 

together with the king's councillors, went to the place where the 

corpses of the young men lay. The king followed after them until he 

came in sight of the bodies. Declan, full of divine faith, entered 

the house wherein they lay and he sprinkled holy water over them and 

prayed for them in the presence of all, saying:—‘O Lord Jesus 

Christ, only Son of the living God, for thine own name's sake wake 

the dead that they may be strengthened in the Catholic faith through 

our instrumentality.’ Thereupon, at Declan's prayer, the group (of 

corpses) revived and they moved their eyelids and Declan said to them 

‘In the name of Christ, our Saviour, stand up and bless and glorify 

God.’ And at his words they rose up immediately and spoke to all. 

Declan then announced to the king that they were alive and well. 

When people saw this remarkable miracle they all gave glory and 

praise to God. The fame of Declan thereupon spread throughout Erin 

and the king rejoiced for restoration of his hostages.


After this the people of Cashel besought Bishop Declan to bless 

their city and banish the plague from them and to intercede 


---

p.49




with God for those stricken with sickness who could not escape from its toils. 

Declan seeing the people's faith prayed to God and signed with the 

sign of Redemption the four points of the compass. As he concluded, 

there was verified the saying of Christ to His disciples when leaving 

them and going to heaven:—Super aegros

 imponent manus et bene 

habebunt (‘I shall place my hands on the sick and they 

shall be healed’). Soon as Declan had made the sign of the cross 

each one who was ill became well and not alone were these restored to 

health but (all the sick) of the whole region round about in 

whatsoever place there were persons ailing. Moreover the plague was 

banished from every place and all rejoiced greatly thereat as well as 

on account of the resurrection of the dead men we have narrated. The 

king thereupon ordered tribute and honour to Declan and his 

successors from himself and from every king who should hold Cashel 

ever after. Upon this the glorious bishop Declan blessed Aongus 

together with his city and people and returned back to his own place.


One night Declan was a guest at the house of a wealthy man who 

dwelt in the southern part of Magh Femhin; this is the kind of person 

his host was, scil.:—a pagan who rejected the true faith, and his 

name was Dercan. He resolved to amuse himself at the Christians' 

expense; accordingly he ordered his servants to kill a dog secretly, 

to cut off its head and feet and to bury them in the earth and then 

to cook the flesh properly and to set it before Declan and his 

company as their meal. Moreover he directed that the dog should be 

so fat that his flesh might pass as mutton. When, in due course, it 

was cooked, the flesh, together with bread and other food, was laid 

before Declan and his following. At that moment Declan had fallen 

asleep but he was aroused by his disciples that 


---

p.51




he might bless their meal. He observed to them:—‘Indeed I see, connected with this meat, 

the ministry of the devil.’ Whereupon he questioned the waiters as 

to the meat—what kind it was and whence procured. They replied: 

‘Our master ordered us to kill a fat ram for you and we have done as 

he commanded.’ Declan said, ‘Our Master is Jesus Christ and may He 

show us what it is that connects the ministry of Satan with this meat 

and preserve thy servants from eating forbidden food.’ As he spoke 

thus Declan saw in the meat the claw of a dog, for, without intending 

it, they had boiled one quarter of the dog with its paw adhering; 

they thought they had buried it (the incriminating limb) with the 

other paws. Declan exclaimed, ‘This is not a sheep's but a dog's 

foot.’ When the attendants heard this they went at once to their 

master and related the matter to him. Then Dercan came to Declan, 

accepted his faith and received Baptism at his hands, giving himself 

and his posterity to Declan for ever. Moreover he gave his homestead 

to Declan and his people were baptised. After this Dercan requested 

that Declan should bless something in his homestead which might 

remain as a memorial of him (Dercan) for ever. Then Declan blessed a 

bell which he perceived there and its name is Clog-Dhercain 

('Dercan's Bell'); moreover, he declared: ‘I endow it with this 

virtue (power) that if the king of Decies march around it when going 

to battle, against his enemies, or to punish violation of his rights, 

he shall return safely and with victory.’ This promise has been 

frequently fulfilled, but proud (men) undertaking battle or conflict 

unjustly even if they march around it do not obtain victory but 

success remains with the enemy. The name of that homestead was 

Teach-Dhercain ('Dercain's House') and its name now is Coningean, 

from the claw of the hound or dog aforesaid. To this place 

came the saintly concourse, scil:—Coman and Ultan, MacErc 


---

p.53




and Mocoba and Maclaisren, who dedicated themselves to (the service of) God and 

placed themselves under the spiritual rule and sway of Declan.


Thereupon Declan established a monastery in that

 place, 

scil.—in Coningin—and he placed there this holy community with a 

further band of disciples. Ultan however he took away with him to 

the place whither he went.


On another (subsequent) occasion Declan visited Bregia, i.e. 

the original territory which belonged to his race previous to the 

expulsion of his ancestors. There he was treated with particular 

honour by the king of Tara and by the chieftains of Meath by whom he 

was beloved, since it was from themselves (their tribe and territory) 

that his forbears had gone out, for that region was the patrimony of 

his race and within it lies Tara. Declan instituted therein a 

monastery of Canons, on land which he received from the king, and it 

is thence the place is named. Moreover he left therein a relic or 

illuminated book and a famous gospel which he was accustomed to carry 

always with him. The gospel is still preserved with much honour in 

the place and miracles are wrought through it. After this again he 

turned towards Munster.


Declan was once travelling through Ossory when

 he wished to 

remain for the night in a certain village. But the villagers not 

only did not receive him but actually drove him forth by force of 

arms. The saint however prayed to God that it might happen to them 

what the Sacred Scripture says, ‘Vengeance is mine I will repay’[5](javascript:footNote('T201020/note005.html')). The

 dwellers in the village, who numbered sixty, died that same night with the exception of two men and ten 

women to whom the conduct of the others towards the saint had been 

displeasing. On the morrow these men and women came humbly to the 

place where Declan was and they told him—what he himself 

foreknew—how miserably the others had died. They themselves did 

penance and they bestowed on Declan a suitable site whereon he built 

a monastery and he got another piece of land and had the dead buried 

where he built the monastery. The name of that monastery is

Cill-Colm-Dearg. This Colm-Dearg was a kind, holy man and a disciple 

of Declan. He was of East Leinster, i.e. of the Dal Meiscorb, and it 

is from him that the monastery is 


---

p.55




named. When he (Declan) had completed that place he came to his own territory again, i.e. to the Decies.


On a certain day Declan came to a place called Ait-Breasail and 

the dwellers therein would not allow him to enter their village; 

moreover they hid all their boats so that he could not go into his 

own island, for they hated him very much. In consideration however 

of the sanctity of his servant, who prayed in patience, God the 

All-Powerful turned the sea into dry land as you have already heard. 

Declan passed the night in an empty stable out in the plain and the 

people of the village did not give him even a fire. Whereupon, 

appropriately the anger of God fell on them, who had not compassion 

enough to supply the disciple of God with a fire. There came fire 

from heaven on them to consume them all (together with their) 

homestead and village, so that the place has been ever since a 

wilderness accursed, as the prophet writes: civitates eorum 

destruxisti, i.e. the dwellings of the unmerciful are 

laid waste.


On yet another occasion Declan was in his own region—travelling 

over Slieve Gua in the Decies, when his horse from some cause got 

lame so that he could proceed no further. Declan however, seeing a 

herd of deer roaming the mountain close to him, said to one of his 

people: ‘Go, and bring me for my chariot one of these deer to replace 

my horse and take with you this halter for him.’ Without any 

misgiving the disciple went on till he reached the deer which waited 

quietly for him. He chose the animal which was largest and therefore 

strongest, and, bringing him back, yoked him to the chariot. The 

deer thereupon obediently and without effort carried Bishop Declan 

till he came to Magh Femhin, where, when he reached a house of 

entertainment, the saint unloosed the stag and bade him to go free as 

was his nature. Accordingly, at the command of the saintly man and in 


---

p.57




the presence of all, the stag returned on the same road back (to 

the mountain). Dormanach is the name of the man aforesaid who 

brought the stag to Declan and him Declan blessed and gave him a 

piece of land on the north of Decies close by the Eoghanacht and his 

posterity live till now in that place.


On another occasion, Declan, accompanied, as

 usual, by a large 

following, was travelling, when one member of the party fell on the 

road and broke his shin bone in twain. Declan saw the accident and, 

pitying the injured man, he directed an individual of the company to 

bandage the broken limb so that the sufferer might not die through 

excess of pain and loss of blood. All replied that they could not 

endure to dress the wound owing to their horror thereof. But there 

was one of the company, Daluadh by name, who faced the wound boldly 

and confidently and said: ‘In the name of Christ and of Declan our 

patron I shall be surgeon to this foot’; and he said that jestingly. 

Nevertheless he bandaged the foot carefully and blessed it aright in 

the name of God and Declan, and in a little while the wound healed 

and they all gave praise to God. Then Declan said to Daluadh: ‘You 

promised to be surgeon to that foot in Christ's name and in mine and 

God has vouchsafed to heal it at these words: on this account you 

will be a true physician for ever and your children and your seed 

after you for ever shall also possess the healing art, and whomsoever 

they shall practise healing upon in God's name and mine, provided 

there be no hatred (in their hearts) nor too great covetousness of a 

physician's fee to him, God and myself shall send relief.’ This 

promise of Declan has been fulfilled in the case of that family.


 On another occasion, as Declan was travelling

 in the northern 

part of Magh Femhin beside the Suir, he met there a man who was 

carrying a little infant to get it baptised. Declan said to the 

people (his muinntear, or following): 'Wait

 here till 


---

p.59




I baptise yonder child,' for it was revealed by the Holy Ghost to him that he 

(the babe) should serve God. The attendant replied to him that they 

had neither a vessel nor salt for the baptism. Declan said: ‘We have 

a wide vessel, the Suir, and God will send us salt, for this child is 

destined to become holy and wonderful (in his works).’ Thereupon 

Declan took up a fistful of earth and, making prayer in his heart to 

God, he signed the clay with the sign of the cross of redemption. It 

(the handful of earth) became white, dry salt, and all, on seeing it, 

gave thanks and honour to God and Declan. The infant was baptised 

there and the name of Ciaran given him. Declan said: ‘Bring up my 

spiritual son carefully and send him, at a fitting age, for education 

to a holy man who is well instructed in the faith for he will become 

a shining bright pillar in the Church.’ And it was this child, 

Ciaran Mac Eochaidh, who founded in after years a famous monastery 

(from which he migrated to heaven) and another place (monastery) 

besides. He worked many miracles and holy signs and this is the name 

of his monastery Tiprut and this is where it is:—in the 

western part of the Decies in Ui Faithe between Slieve Grot and Sieve Cua and it is within the bishopric of Declan.


On another day there came a woman to Declan's monastery not far 

from the city where she dwelt. She committed a theft that day in 

Declan's monastery as she had often done previously, and this is the 

thing she stole—a habellum; she 

departed homewards taking it with her and there met her a group of 

people on the highway, and the earth, in their presence, swallowed 

her up, and she cast out the tabellum from her bosom and it was 

quickly turned into a stone which the wayfarers took and brought with 

them to Declan. Declan himself had in supernatural vision seen all 

that happened to the woman in punishment of her theft, and the name


---

p.61




 

of Declan was magnified owing to those marvels so that fear took 

possession of all-those present and those absent. The stone in 

question remains still in Declan's graveyard in his own town of 

Ardmore-Declain, where it stands on an elevated place in memory of 

this miracle.


A rich man named Fintan was childless, for his

 wife was barren 

for many years. He himself, with his wife, visited Declan and 

promised large alms and performance of good works provided he 

(Declan) would pray that they might have children: they held it as 

certain that if Declan but prayed for them God would grant them 

children. Declan therefore, praying to God and blessing the pair, 

said: ‘Proceed to your home and through God's bounty you shall have 

offspring.’ The couple returned home, with great joy for the 

blessing and for the promise of the offspring. The following night, 

Fintan lay with his wife and she conceived and brought forth twin 

sons, scil.: Fiacha and Aodh, who, together with their children and 

descendants were under tribute and service to God and Declan.


When it was made known to a certain holy man, scil.:—Ailbe of 

Emly Iubar, chief bishop of Munster, that his last days had come, he 

said to his disciples: ‘Beloved brethren, I wish, before I die, to 

visit my very dear fellow worker, scil.:—Declan.’ After this Ailbe 

set out on the journey and an angel of God came to Declan notifying 

him that Ailbe was on his way to visit him. On the angel's 

notification Declan ordered his disciples to prepare the house for 

Ailbe's coming. He himself went to meet Ailbe as far as the place 

which is called Druim Luctraidh. Thence they came home 

together and Ailbe, treated with great honour by Declan and his 

people, stayed fourteen pleasant days. After 


---

p.63




that the aged saint returned home again to his own city, scil.:—to Emly Iubar. Declan 

came and many of his people, escorting Ailbe, to Druim Luchtradh, and 

Ailbe bade him return to his own city. The two knew they should not 

see one another in this world ever again. In taking leave of one 

another, therefore, they shed plentiful tears of sorrow and they 

instituted an everlasting compact and league between their successors 

in that place. Ailbe moreover blessed the city of Declan, his clergy 

and people and Declan did the same for Ailbe and they kissed one 

another in token of love and peace and each returned to his own city.


On a certain day the Castle of Cinaedh, King of

 the Deisi, took 

fire and it burned violently. It happened however that Declan was 

proceeding towards the castle on some business and he was grieved to 

see it burning; he flung towards it the staff to which we have 

referred in connection with the drying up of the sea, and it (the 

staff) flew hovering in the air with heavenly wings till it reached 

the midst of the flame and the fire was immediately extinguished of 

its own accord through the grace of God and virtue of the staff and 

of Declan to whom it belonged. The place from which Declan cast the 

staff was a long mile distant from the castle and when the king, i.e. 

Cinaedh, and all the others witnessed this miracle they were filled 

with amazement and gave thanks to God and to Declan when they came to 

know that it was he who wrought it. Now the place where the castle 

stands is not far from the Suir, i.e. on the south side of it and the 

place from which Declan cast the staff is beside a ford which is in 

the Suir or a stream which flows beside the monastery called Mag Laca 

which the holy virgins, daughters of the king of Decies, 

have built in honour of God. There is a pile of stones and a cross 

in the place to commemorate this miracle.


On another occasion there approached a foreign

 fleet towards 

Declan's city and this was their design—to destroy and to plunder it 


---

p.65




of persons and of cattle, because they (the foreigners) were people 

hostile to the faith. Many members of the community ran with great 

haste to tell Declan of the fleet which threatened the town and to 

request him to beg the assistance of God against the invaders. 

Declan knew the man amongst his own disciples who was holiest and 

most abounding in grace, scil., Ultan, already mentioned, and him he 

ordered to pray to God against the fleet. Ultan had pity on the 

Christian people and he went instantly, at the command of Declan, in 

front of the fleet and he held his left hand against it, and, on the 

spot, the sea swallowed them like sacks full of lead, and the drowned 

sailors were changed into large rocks which stand not far from the 

mouth of the haven where they are visible (standing) high out of the 

sea from that time till now. All Christians who witnessed this 

rejoiced and were glad and they gave great praise and glory to God 

and to Declan their own patron who caused the working of this miracle 

and of many other miracles besides. Next there arose a contention 

between Ultan and Declan concerning this miracle, for Ultan 

attributed it to Declan and Declan credited it to Ultan; and it has 

become a proverb since in Ireland when people hear of danger or 

jeopardy:—‘The left hand of Ultan against you (the danger).’

 Ultan 

became, after the death of Declan, a miracle-working abbot of many 

other holy monks.


The holy and glorious archbishop, i.e. Patrick,

 sent one of his 

own followers to Declan with power and authority (delegation) from 

the archbishop. And proceeding through the southern part of Decies 

he was drowned in a river there, two miles from the city 

of Declan. When Declan heard this he was grieved and he said: 

'Indeed it grieves me that a servant of God and of Patrick who sent 

him to visit me, having travelled all over Ireland, should be drowned 

in a river of my own territory. Get my chariot for me 


---

p.67




that I may go in haste to see his corpse, so that Patrick may come to hear of the 

worry and the grief I have undergone because of his disciple's 

death.' The body had been recovered before the arrival of Declan by 

others who were close at hand and it had been placed on a bier to be 

carried to Ciaran for interment. Declan however met them on the way, 

when he ordered the body to be laid down on the ground. They 

supposed he was about to recite the Office for the Dead. He (Declan) 

advanced to the place where the bier was and lifted the sheet 

covering the face. It (the face) looked dark and deformed as is 

usual in the case of the drowned. He prayed to God and shed tears, 

but no one heard aught of what he said. After this he commanded:—‘In 

the name of the Trinity, in the name of the Father and of the Son and 

of the Holy Ghost whose religious yoke I bear myself, arise to us for 

God has given your life to me.’ He (the dead man) rose up 

immediately at the command and he greeted Declan and all the others. 

Whereupon Declan and his disciples received him with honour. At 

first he was not completely cured but (was) like one convalescent 

until (complete) health returned to him by degrees again. He however 

accompanied Declan and remained some time with him and there was much 

rejoicing in Declan's city on account of the miracle and his 

(Declan's) name and fame extended over the country generally. This 

disciple of Patrick was named Ballin; he returned with great joy and 

he told him (Patrick) that Declan had raised him from the dead. To 

many others likewise he related what had happened to him. Patrick, 

in presence of many persons, hearing of the miracle gave glory and 

thanks to God and the name of Declan was magnified.


With this extraordinary miracle wrought by

 Declan we wish to 

conclude our discourse. The number of miracles he wrought, 


---

p.69




but which are not written here, you are to judge and gather from what we have 

written. And we wish moreover that you would understand that he 

healed the infirm, that he gave sight to the eyes of the blind, 

cleansed lepers, and gave 'their walk' to cripples; that he obtained 

hearing for the deaf, and that he healed many and various diseases in 

many different places throughout Ireland—(things) which are not 

written here because of their length and because they are so numerous 

to record, for fear it should tire readers to hear so much said of 

one particular person. On that account we shall pass them by.


When Declan realised that his last days were at

 hand and that 

the time remaining to him was very short he summoned to him his own 

spiritual son, scil., MacLiag (residing) in the monastery which is on 

the eastern side of the Decies close to the Leinstermen in order 

that, at the hour of death, he might receive the Body and Blood of 

Christ and the Sacraments of the Church from his hands. Thereupon he 

foretold to his disciples the day of his death and he commanded them 

to bring him to his own city, for it was not there he dwelt at the 

time but in a small venerable cell which he had ordered to be built 

for him between the hill called Ardmore Declain and the ocean—in a 

narrow place at the brink of the sea by which there flows down from 

the hill above a small shining stream about which are trees and 

bushes all around, and it is called Disert Declain. Thence to the 

city it is a short mile and the reason why Declan used go there was 

to avoid turmoil and noise so that he might be able to read and pray 

and fast there. Indeed it was not easy for him to stay even there 

because of the multitude of disciples and paupers and pilgrims and 

beggars who followed him thither. Declan was however generous and 

very sympathetic and on that account it is recorded by tradition that 

a great following (of poor, etc.), generally accompanied him 


---

p.71




and that moreover the little cell was very dear to him for the reason we have given, and many devout people have made it their practice to dwell therein.


When Declan fell ill and became weak in body,

 but still strong 

in hope and faith and love of God, he returned to his own city—his 

people and disciples and clergy surrounding him. He discoursed to 

them on the commands of God and he enjoined on them to live holily 

after his death, to be submissive to authority and to follow as 

closely as possible the way he had marked out and to preserve his 

city in a state of piety and under religious rule. And when they had 

all heard the discourse it grieved them greatly to perceive, from 

what he had said, he realised that in a short time he would go away 

to heaven from them. But they were consoled by his gentle words and 

then there came to him the holy man, to wit, MacLiag, at his own 

request, already referred to. He (Declan) received the Body and 

Blood of Christ and the Sacraments of the Church from his (MacLiag's) 

hand—surrounded by holy men and his disciples, and he blessed his 

people and his dependents and his poor, and he kissed them in token 

of love and peace. Thus, having banished images and the sacrifices 

to idols, having converted multitudes to the true faith, having 

established monasteries and ecclesiastical orders in various places, 

having spent his whole life profitably and holily, this glorious 

bishop went with the angels to heaven on the ninth day of the Kalends 

of August and his body was blessed and honoured with Masses and 

chanting by holy men and by the people of the Decies and by his own 

monks and disciples collected from every quarter at 


---

p.73




the time of his death. He was buried with honour in his own city—in Declan's High-Place—in the tomb which by direction of an angel he had himself indicated—which moreover has wrought wonders and holy signs from that time to now. He departed to the Unity of the Father and the Son and the Holy Ghost in Saecula Saeculorum; Amen.


FINIS.











