

#Lewis Dillwyn's Visit to Kerry, 1809


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Lewis Dillwyn's Visit to Kerry, 1809
====================================


Author: Lewis Weston Dillwyn
----------------------------


### File Description

Gerard J. LyneElectronic edition compiled and proof-read by Beatrix Färber, Rebecca Daly

Funded by University College, Cork, School of History 1. First draftExtent of text: 17215 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800005-001Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Notes

We are very grateful to Gerard Lyne, formerly Keeper of Manuscripts at the National Library of Ireland, and the Board of the Kerry Archaeological and Historical Society for their kind permission to publish this material in electronic form on CELT.

#### Sources


**Manuscript**2. Trinity College Library, Ms. 967 (Q. 3. 19) [Journal of a tour from Swansea to Killarney by L. W. Dillwyn, 1809].
**Literature (including that referred to in annotations)**2. Thomas Molyneux, A Discourse concerning the Danish Mounts, Forts, and Towers in Ireland (Dublin 1725).
3. Pádraig Ó Maidin (ed), 'Pococke's tour of south and south-west Ireland in 1758', *Journal of the Cork Historical and Archaeological Society* 63 (1958), 73–94; 64 (1959), 35–56, 109–30; 65 (1960), 130–41.
4. Charles Smith, The ancient and present state of the county of Kerry (Dublin 1756). Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
5. Dunn [attributed], A Description of Killarney (Dublin 1776). [Available online at CELT].
6. Richard Twiss, A tour in Ireland in 1775 (London: printed for the author, 1776).
7. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available online at CELT.]
8. Peter Bernard Scalé, An Hibernian Atlas (London 1776).
9. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin. A new edition by A. W. Hutton, 'Arthur Young's tour in Ireland, 1776–1779', was published 1892 in London.
10. George Taylor and Andrew Skinner, Taylor and Skinner's Maps of the Roads of Ireland, surveyed 1777 (London 1778; Dublin 1783).
11. Reverend Mervyn Archdall, Monasticum Hibernicum; or an History of the Abbies, Priories, and other Religious Houses in Ireland, 2 volumes (London 1786).
12. Philip Luckombe, The compleat Irish traveller (...) 2 vols (London 1788).
13. Caspar Voght, Schilderung von Irland, Bruchstücke aus dem Tagebuche eines Reisenden. Im Herbst 1794, in: August Hennings, Der Genius der Zeit, Bd. 8, (Mai bis August 1796) 566–653. [Available online at CELT.]
14. Jacques Louis de Bougrenet Chevalier de La Tocnaye, A Frenchman's Walk through Ireland 1796–7 (Promenade d'un François dans l'Irlande), translated by John Stevenson (first published Cork 1798; repr. Belfast 1917; Dublin 1984).
15. Thomas Moore, 'Sweet Innisfallen, fare thee well' (available online at http://www.bartleby.com/270/2/60.html).
16. Isaac Weld, Illustrations of the Scenery of Killarney and the surrounding Country (London 1805).
17. William Wilson, The postchaise companion (Dublin [1806]).
18. J. T. Mackay, Systematic catalogue of the rare plants found in Ireland, in Transactions of the Dublin Society 5 (1806) 59–.
19. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
20. J. Charles, Modern map of the Roads of Ireland including all the Post Towns (Dublin 1814).
21. Thomas Crofton Croker, Researches in the south of Ireland (London 1824) [available online at CELT].
22. George Petrie, The ecclesiastical architecture of Ireland Anterior to the Anglo-Norman invasion (...) (Dublin 1845).
23. M. A. Hickson (ed), Selections from old Kerry records (...) I (Dublin 1872–74).
24. J. A. Froude, The English in Ireland in the eighteenth century, I (London 1872).
25. R. R. Madden (ed), Literary remains of the United Irishmen of l798 (...) (Dublin 1887).
26. A. Moffatt, The Minstrelsy of Ireland (...) (London [1898]).
27. John Windele, 'Some castles and clans of Desmond, extracted from 'Notices of Cork and Killarney', Kerry Archaeologcial Magazine 2 (March 1913) 80–92.
28. Rev. P. A. Walsh, ''The exile of Erin': who wrote it?' (Dublin, 1921). Rev. P. A. Walsh, ''The exile of Erin': who wrote it?' (Dublin, 1921).
29. W. F. T. Butler, Gleanings from Irish history (London 1925).
30. William Petty Lansdowne (sixth marquis of Lansdowne), Glanerought and the Petty-Fitzmaurices (London: Oxford University Press 1937).
31. D. J. O'Sullivan, 'The Bunting Collection of Irish folk music and sings', Irish Folk Song Society Journal 6 (1939) 53–60.
32. J. B. Leslie, Ardfert and Aghadoe clergy and parishes (Dublin 1940).
33. Edward MacLysaght (ed), The Kenmare Manuscripts (Dublin 1942). (Reprinted Shannon: Irish University Press 1970).
34. Seán Mac Airt, The Annals of Inisfallen (MS. Rawlinson B. 503) (Dublin: DIAS 1944). Several times reprinted. [Available online at CELT.]
35. M. Nic Neill, 'Wayside Death Cairns in Ireland', Béaloideas 15 (1946) 49–63.
36. Mary Scannell and Donall M. Synnott (comp.), Census catalogue of the flora of Ireland (Dublin 1972).
37. Seán Ó Luing, 'Richard Griffith and the roads of Kerry', Journal of the Kerry Archaeological and Historical Society 8 (1975) 89–113.
38. Thomas Joseph Barrington, Discovering Kerry: its history, heritage and topography (Dublin 1976).
39. Brian Ó Cuív, A Fragment of Irish Annals. Edited with English translation, Celtica 14 (1981) 83–104. [Mentions Oirbealch at entry 1468.3.]
40. Gerard J. Lyne and M. E. Mitchell (eds), 'A scientific tour through Munster: the travels of Joseph Woods, architect and botanist, 1809', North Munster Antiquarian Journal 27 (1985) 15–61.
41. Gerard J. Lyne (ed), 'Rev. Daniel A. Beaufort's tour of Kerry, 1788', Journal of the Kerry Archaeological and Historical Society 18 (1985) 183–214. [Available online at CELT.]
42. Gerard J. Lyne (ed), 'Lewis Dillwyn's visit to Waterford, Cork and Tipperary in 1809', Journal of the Cork Historical and Archaeological Society 91 (1986) 85–104.
43. Helena C. G. Chesney, 'The young lady of the lichens: Ellen Hutchins (1785–1815)', in: Mary Mulvihill, Stars, shells and bluebells: women scientists and pioneers (Dublin 1997) 28–39.
44. Donal Synnott, Botany in Ireland, in: John Wilson Foster; Helena C. G. Chesney (eds), Nature in Ireland: a scientific and cultural history (Dublin 1997).
45. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
46. John A. Murphy and Emer Purcell (eds), The Desmond Survey, published online at CELT in 2013, and available in CELT file E580000-001 (includes Desmond, Peyton and Clancarthy Surveys).
47. Pádraig Ó Riain, A dictionary of Irish Saints (Dublin 2011).
48. Jane O'Hea O'Keeffe, Voices from the Great Houses (Cork: Mercier Press 2013). Includes a section on the Hutchins family.
49. Kaith Harrison and Eric Smith, Rifle-green by Nature: A Regency Naturalist and His Family, William Elford Leach (London: Ray Society 2008).
**Lewis Weston Dillwyn: Life and Works**2. See the Oxford DNB, online edition, at http://www.oxforddnb.com/view/article/7670
3. According to Copac data, Lewis Weston Dillwyn's diaries (36 vols) are fully transcribed by Richard Morris are and available for academic use at https://cronfa.swan.ac.uk/dspace/handle/10512/111
4. Lewis Weston Dillwyn and Dawson Turner, The botanist's guide through England and Wales (London 1805).
5. Lewis Weston Dillwyn, Letters from Lewis Weston Dillwyn 1803, Oct. 15. 1808, Aug. 27, "one to W. Phillips, 1803, and the other to Sir T. F., 1808" (Copac) [=National Library of Wales MS 14005E, ff. 43–45].
6. Lewis Weston Dillwyn, British Confervae; or colored figures and descriptions of the British plants referred by botanists to the genus Conferva (London 1802–9). (Available at Boole Library, UCC, Special Collections.) [Translated into German as 'Grossbritanniens Conferven, nach Dillwyn f�r deutsche Botaniker bearbeitet von Friedrich Weber und D. M. H. Mohr (Göttingen 1803–1805).
7. Lewis Weston Dillwyn, A Descriptive Catalogue of Recent Shells, arranged according to the Linnaean method: with particular attention to the synonymy (London 1817).
8. Lewis Weston Dillwyn (ed), Historia sive synopsis methodica Conchyliorum, Martini Lister. Editio tertia, recensuit et indice locupletissimo instruxit L. W. Dillwyn. (Oxonii/Oxford 1823).
9. Lewis Weston Dillwyn, Fauna of Swansea, in: British Fish 1848 [book published between 1848 and 1882, according to Copac data].
10. Lewis Weston Dillwyn, Calendar of the diary of Lewis Weston Dillwyn. Vol. 1. 16 October 1817 to 14 November 1823. Vol. 2. 18 November 1823 to 31 December 1833. Vol. 3. 1 January 1834 to 15 July 1852. 3 vols. (Aberystwyth, National Library of Wales, 19--).
11. Lewis Weston Dillwyn, Contributions towards a history of Swansea (Swansea 1840).
12. Lewis Weston Dillwyn, Hortus Collinsonianus: an account of the plants cultivated by Peter Collinson. (Swansea 1843).
13. Lewis Weston Dillwyn, Materials for a Fauna and Flora of Swansea and the neighbourhood (Swansea 1848).
14. Soranus (=Thomas Williams), Lewis Weston Dillwyn, Esq., of Swansea, The Cambrian Journal (Science and scientific men of Wales) (Tenby 1855).
15. Lewis Weston Dillwyn, The diary of Lewis Weston Dillwyn. (South Wales and Monmouth Record Society Publications; vol. 5) (1963).
16. Ray Desmond and Christine Ellwood, Dictionary of British and Irish botanists and horticulturists ... (London 1977, rev. edn 1994).
**The edition used in the digital edition**2. **Gerard J. Lyne**, Lewis Dillwyn's Visit to Kerry, 1809 in Journal of the Kerry Archaeological and Historical Society, Ed. Kieran O'Shea. , Naas, Leinster Leader (1983) volume 15–16 page 83–111

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 83–111, which includes the editor's introduction and the editor's acknowledgements.


#### Editorial Declaration


##### Correction


The text has been checked and proofread twice. Editorial footnotes are retained, renumbered at CELT, and take the form note type="auth" n="" All supplied text is tagged. Text supplied by the editor is marked sup resp="GJL".


##### Normalization


The electronic text represents the edited text. Some abbreviations of titles or botanical terms have been expanded silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0= the description; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. Date values are encoded.


##### Interpretation


Names of people, places and botanical terms are tagged.


#### Canonical References


This text uses the DIV1 element to represent the entry. ### Profile Description


Created: By Lewis Weston Dillwyn (1778–1855)
 (July 1809) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Many botanical terms are in Latin.


##### Language: [GA] Some words are in Irish.


##### Language: [FR] A word or two is in French.


### Revision History


* (2016-11-01) Beatrix Färber (ed.)

* Addition made to bibliography and footnote 1, confirming the identity of William Elford Leach, based on information supplied by Dr Keith Harrison, Harrogate. New SGML and HTML files created.
* (2014-05-28; 2014-06-04; 2014-06-13;) Beatrix Färber (ed.)

* Corrections added. File parsed and validated. SGML and HTML files created.
* (2014-05-26; 2014-06-04; 2014-06-13;) Rebecca Daly (ed.)

* File proofed (2); corrections communicated.
* (2014-05-17) BF (ed.)

* File proofed (1), structural and content encoding applied, including personal and place names. Bibliographic details added.
* (2014-05) Beatrix Färber (ed.)

* Text converted to XML; TEI header created.
* (2014-05) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800005-001


### Lewis Dillwyn's Visit to Kerry, 1809: Author: Lewis Weston Dillwyn




---

p.83


### Lewis Dillwyn's Visit to Kerry, 1809


In July 1809 the Anglo-Welsh naturalist **Lewis Weston Dillwyn** (1778–1855) accompanied by his lifelong friend **Joseph Woods** and another companion named **Leach**, whose identity has not been positively established,[1](javascript:footNote('E800005-001/note001.html')) paid a visit to **Killarney** where they spent some days exploring the town and its neighbourhood. **Dillwyn** kept a diary of his tour the original of which, contained in a small closely-written volume of pocket-book size, is today preserved in Trinity College Dublin (Ms. 967). From it can be reconstructed the following outline of his itinerary. Crossing from **Milford Haven** to **Waterford** on 6 July, between that date and 16 July he travelled, firstly, to **Dungarvan** via **Kilmacthomas**: from thence to **Youghal** via **Clashmore** and then on to **Cork city** via **Castle Martyr** and **Midleton**. He remained two days in **Cork** (which impressed him as ‘a large and handsome city’) and then travelled on to **Clonakilty**, **Dunmanway** and **Bantry**. From **Bantry** he proceeded to **Kenmare** and **Killarney** where he remained for one week. Leaving **Killarney** he proceeded by stages to **Millstreet**, **Mallow**, **Clogheen** and **Clonmel**, from which latter town he returned on 30 July to **Waterford**, and from there arrived back in **Milford Haven** on 1 August. His Kerry sojourn, therefore, though occupying the largest space in his diary comprises only a part of his total itinerary.


The following facts concerning **Dillwyn** have been gleaned from
the Dictionary of National Biography.[2](javascript:footNote('E800005-001/note002.html')) He was born in Ipswich, son of **William Dillwyn** of Highham Lodge, Walthamstow, and was descended from an old Breconshire family. His father was a member of the **Society of Friends** at whose school in Folkestone he was first enrolled before going in 1798 to Dover where he began his study of botany. His later publications included The natural history of British confervae (1802–9), The botanist's guide through England and Wales [a collaborative work] (1805), and A descriptive catalogue of British shells (1817).


In 1803 his father placed him in charge of a pottery which he had



---

p.84



purchased in **Swansea**. He was thus enabled to turn his interests as a naturalist to good account and his porcelain became celebrated for ‘the true and spirited paintings on it of butterflies, flowers, birds, and shells, besides the beauty of the material itself’. He also achieved some distinction in public life. He was for many years a magistrate, was made high sherriff of Glamorganshire in 1818 and in 1832 was returned to the first reformed parliament as M.P. for that shire, a seat which he retained until 1837. He was subsequently elected mayor of **Swansea**. His biographer describes him as ‘thoroughly upright in all his dealings, and a liberal and active country gentleman’.


**Dillwyn** and his companions were, no doubt, mainly interested in the flora and fauna of the south of Ireland in general and of the **Killarney** area in particular. **Killarney** was, of course, by this time well established as a tourist attraction. Its proprietors the earls of Kenmare had early recognised its potential in this respect and commencing around the year 1750 took steps to provide comfortable accommodation for visitors to the town and boats for hire on the lakes.[3](javascript:footNote('E800005-001/note003.html')) The contemporary romantic movement in literature and the arts, with its emphasis on the rural, the rustic and the antique, provided a favourable climate for their efforts and during the decades that followed there converged on **Killarney** a thickening throng of misty-eyed romantics, weaned on a literary diet of **Mac Pherson** and **Sir Walter Scott**, all straining to catch among her lakes and dells the last dying cadences of Hibernia's perenially-broken harp strings. The doyen of the cult in Ireland, **Thomas Moore** himself, descended on the scene, was appropriately affected and penned in memory of his visit his Innisfallen fare thee well.


Fortunately, **Dillwyn** shared to some extent the fashionable tastes of his age. Thus, while his diary contains numerous botanical references, and may even provide the earliest record of certain plant species for Kerry, he tells us even more about the towns and villages through which he passed, the antiquities he visited and the condition, manners and customs of the people with whom he came in contact. He had the advantage of possessing a readymade introduction to the Killarney area in the shape of an account of a tour published two years earlier, by the Dubliner **Isaac Weld**, entitled Illustrations of the scenery of Killarney and the surrounding country (London 1805). It



---

p.85



is clear, in fact, that **Weld**'s work had considerable influence in shaping **Dillwyn**'s Killarney itinerary.[4](javascript:footNote('E800005-001/note004.html')) The latter was, nevertheless, an acute observer in his own right — the result, probably, of combined scientific training and practical business experience. He had, besides, an eye for the humourous and colourful and even more remarkable for a casual diarist, considerable power of description. His jottings — albeit compiled while enduring the misery of a heavy cold contracted en route to **Kenmare** — convey a vivid sense of the beauty and serenity of **Killarney**'s lakes and mountains during the warm, dry summer of 1809.


There was, however, a less attractive side to **Dillwyn**. He was, unfortunately, a religious bigot and his references to the Catholic clergy and Catholic worship in **Killarney**, though of course he would probably not have expressed such views in public, betray a crudely sectarian outlook at odds with the well-deserved reputation for tolerance and philanthropy acquired by the **Society of Friends** in Ireland later in the nineteenth century.[5](javascript:footNote('E800005-001/note005.html')) One must, of course, see his prejudice in the context of his age when sectarian bigotry on all sides was the rule rather than the exception. In addition, he displays certain other unattractive traits, typical of colonialists in every age. He arrived already well stocked with prejudices and, one suspects, found among those he encountered socially — land agents, attorneys, and officials — many who were anxious to reinforce and add to them. Nevertheless, his account, though unsympathetic, is no doubt often accurate.


Like many other visitors he was, for instance, forcibly struck by the lack of a middle class in Irish society. The people he encountered were, he remarks, either well dressed or in rags — their habitations for the most part either mansions or hovels. He complains like many other travellers of the Irish readiness to take financial advantage of strangers. The inns and hotels at which he stayed varied considerably. Some were excellent, others — like the inn he first put up in at **Checkpoint**, Co. Waterford — quite vile. The ingratiating manners of innkeepers, boatmen and jarveys apart, the abiding impression one receives from his account is of a sullen population smarting under many oppressions and in consequence chronically prone to violence. In the course of his short visit **Dillwyn** notes five murders (four of 



---

p.86



them committed in Kerry) two executions and a riot, as well as evidence of popular resistance not only to tithes but rents. One senses also in his account of the conduct of the military authorities in **Killarney** evidence (scarcely surprising in the wake of 1798) of a virulent and triumphalist party spirit but little conducive to reconciliation. This is all the more interesting since evidence of this nature is hard to come by in other contemporary sources.


It should be noted that while the text which follows is in the main a faithful transcript of **Dillwyn**'s manuscript, some lengthy passages descriptive of the geography of the Killarney lakes as well as quotations from published works and one or two brief passages of botanical theorising have been silently omitted. (The botanical names of all plants noted by **Dillwyn** are, however, listed). In addition, the text has been broken into paragraphs — an arrangement not employed in the original diary.


Tuesday, July 18th
  

We had engaged to breakfast at **Ballylickey**[6](javascript:footNote('E800005-001/note006.html')) which lies near the Road from **Bantry** to **Kenmare**, & we accordingly left our inn soon after seven. **Bantry** is rather a small town situated on a Creek at a short distance from the Bay, & it's only decent inn is what the generality of English Travellers would call most miserable. In the Bay large quantities of corallines are dredged up for the purposes of manure,[7](javascript:footNote('E800005-001/note007.html')) & on our way to **Miss Hutchins**'s[8](javascript:footNote('E800005-001/note008.html')) I for an hour examined some Heapes in which I found several scarce and valuable shells &



---

p.87



among these are two or three which **Mr Leach** thinks are new to Britain. After breakfast I examined the remainder of **Miss Hutchins**'s marine algae & she liberally supplied me with specimens of most of the rarer Species. About half past twelve we with regret parted from our new Friends at **Ballylickey** & set out for **Kenmare**. At 1 o'clock we arrived at the foot of the **Priests Leap** from whose highest Summit it is said that a Priest, being pursued by an Enemy, jumped into the Town of **Bantry** which is four Irish miles from its base & there the credulous Catholics still show the mark which his Heel made when he alighted. It is a tremendous Mountain for a Carriage to pass, & can only be accomplished with great difficulty on which account we found a respectable Farmer with fifteen of the Peasantry waiting by Mr. Hutchins's order in readiness to assist us.[9](javascript:footNote('E800005-001/note009.html')) We here left our Carriage and separating from each other we ascended the mountain in different directions in order that we might thereby examine it more thoroughly. We found **Saxifraga umbrosa**[10](javascript:footNote('E800005-001/note010.html')) & **Saxifraga hirsuta**[11](javascript:footNote('E800005-001/note011.html')) in great abundance on all the Rocks as well as many of the more common Mountain plants but we did not meet with any others of the rariores except **Isoetes lacustris**[12](javascript:footNote('E800005-001/note012.html')) which was gathered by **Mr Woods** in a small Lake near the top of the Mountain.


The **Priest's Leap** divides the Counties of **Cork** & **Kerry** into the latter of which we entered when we passed it's Summit. About 100 yards from the top of the Mountain we crossed a small Bridge on which three months ago the Revd Mr. Tisdall,[13](javascript:footNote('E800005-001/note013.html')) Protestant Vicar of



---

p.88



Kenmare was waylaid, robbed, & inhumanly murdered by two Ruffians one of whom named Murphy now lies in Tralee Jail with the clearest Evidence against him. The manner in which he was taken is singular. Mr Tisdall's Body was not found or his dreadful fate known till nine days after the Murder & in the Interim Murphy had escaped to the opposite side of the Kingdom where some Persons seeing such an ill looking Fellow well stocked with Bank Notes suspected they were forged & stopped him at **Kilkenny**. Before he could clear himself from the charge of Forgery, the murder was detected & printed descriptions of Murphy's Person were circulated by Mr Hutchins, one of which reach*[ed]* Kilkenny just as the Magistrate was going to discharge him. He is accused of numerous other Crimes of the very blackest die, & is said to have hired himself for two Guineas, & assassinated a Person whom he never saw till pointed out for the bloody purpose.[14](javascript:footNote('E800005-001/note014.html')) His accomplice was also taken but contrived to murder the Constable who had him in Custody, & thereby effected his excape.[15](javascript:footNote('E800005-001/note015.html'))


It is the custom of this Country when any person has been murdered to form a heap of stones on the Spot, to which every Passer



---

p.89



by adds one or it is supposed that he would otherwise be haunted by the Ghost of the Deceased. The heap, or Cairne as it is here called, was in the present instance so small, that I should hardly have noticed it, if I had not been previously informed of its situation.[16](javascript:footNote('E800005-001/note016.html'))


The **Priest's Leap** is said to be more than 2,000 feet above the level of the Sea,[17](javascript:footNote('E800005-001/note017.html')) and the prospect from its Summit is very grand and extensive. To the Southward the smooth & glassy surface of **Bantry Bay** with its numerous creeks & Inlets formed a fine contrast to the dark line of its surrounding Mountains, & a large tract of Country with the Atlantic Ocean beyond as if spread in a Map beneath us. To the North immediately below us appeared a Tract of dreary Peat without either a House or Tree in view, & beyond it the numerous vast Mountains of Kerry, many of which have no connection with each other, but rise separately from their own Bases, & in this respect the view differs from any other that I have ever seen.


At half past six having all met together and found our Carriage at the foot of the Mountain we proceeded towards **Kenmare** where however we did not arrive till half past eight tho' its distance from **Bantry** is said to be *only* 12 Irish Miles.[18](javascript:footNote('E800005-001/note018.html')) We had sent a Message to the Inn desiring that some Dinner might be prepared against our arrival, but it was not ready till an hour after, & a long hour it seemed for we had not eaten a Mouthfull since Breakfast. I had a violent Cold and felt so much indisposed that tho' I was not at all over fatigued I fell fast asleep immediately after Dinner and was unable even to journalise or preserve my Specimens that Evening.


Wednesday, July 19th
  

We had taken up our Quarters at a comfortable Inn, which is kept



---

p.90



by a Mrs Sullivan & has been recently built by **Lord Henry Petty** who possesses a large property in this Neighbourhood.[19](javascript:footNote('E800005-001/note019.html')) After Breakfast we strolled for about 1 ½ hours on the Banks of **Kenmare Bay**, which is a very fine winding Haven of the same kind as that at **Bantry**. It is, however, still larger, the length being about 30 and the breath from 3 to 9 miles but it's Banks are less mountainous & altogether the effect it produces is less striking & picturesque. **Kenmare** or **Nedeen** by which name it is most commonly known in this Country is a small & straggling Town. Close by the Inn a handsome Chapel has been built & is now nearly finished at the expence of **Lord Henry Petty** for the use of the Catholicks.[20](javascript:footNote('E800005-001/note020.html')) On the Banks of the Bay I collected **Venus Paphia**[21](javascript:footNote('E800005-001/note021.html')) and several other Shells.


There are two Roads from **Kenmare** to **Killarney**, by one of which the distance is 12 & by the other 20 or 24 Miles.[22](javascript:footNote('E800005-001/note022.html')) The former, however, is extremely mountainous & the latter is flat, & as we were told that it also passes thro' a far more beautiful country, we gave it the preference & set out accordingly at ½ past 10.


As near as it is possible to judge of distances where the Roads have never been measured & where they are reckoned differently by every Person you meet, the Country thro' which we passed for the first six Miles was not at all particularly picturesque. It then however became romantic & we soon afterwards entered a very extensive wood of Oak



---

p.91



& Birch which is the first we had seen in Ireland except such as had been planted about the Seats of the Gentry. On the opposite side of the Valley the Mountains rose to a great height & were in some places almost perpendicular, but they derived their principal beauty from the numerous deep Gullies which were well wooded whilst the more prominent points were bare. Our Horses were baited[23](javascript:footNote('E800005-001/note023.html')) at a wretched Pot House & we availed ourselves of the opportunity it afforded to stroll among the neighbouring Woods, but without being able to make any botanical or entomological Discoveries **Saxifraga umbrosa** by the road sides in almost every situation was the commonest of weeds.


About a mile or two from this place our course suddenly changed from Northward to Westward & we then passed the much and deservedly admired **Flesk Rocks** which take their Name from the River that winds along their Feet. They are in many places nearly perpendicular, & notwithstanding their apparent want of Soil, are beautifully scattered over with Oak, Birch & Ash Trees many of which have attained a large size. My idea is that their height is not less than 600 feet. From thence as we approached **Killarney**, the view with the cloud capt Summits of **Macgillycuddy's Reeks** in our front, became more & more mountainous & more sublime.


The entrance into the Town thro' **Lord Kenmare**'s Plantation is handsome but we have yet had no good view of the Lake, **Killarney** being near two English Miles from it's Banks. We drove to Coffees Hotel which tho' very large for a County Inn was so full that we were shoved about from one Room to another, & were obliged to sleep in different houses over the way, which, however, were provided with good Beds.


Thursday, July 20th
  

We determined to commence our operations in this Neighbourhood with a visit to **Dunloh Gap** & accordingly set out in our Carriage, immediately after Breakfast. We drove over an excellent Road by the side of the lower Lake, & about a Mile & a half from **Killarney** passed the Ruins of **Aghadoe Cathedral**, which did not



---

p.92



appear either so extensive or beautiful as we had been led to suppose.[24](javascript:footNote('E800005-001/note024.html')) The surface of the Lake was perfectly smooth & beautifully reflected the numerous well wooded Islands with which it is studded & its Banks on the opposite side are formed by the **Glennaa**
and **Tomies Mountain** beyond which the Reeks appear majestically overtopping them. About 4 or 5 Miles from **Killarney** we turned to the Left beyond the North end of the Lake, & crossed a Bridge over the River **Laune** to **Dunloh Castle**.[25](javascript:footNote('E800005-001/note025.html')) It now consists of a single square Tower which originally formed only a small part of the ancient Edifice & is the residence of Major Mahony.[26](javascript:footNote('E800005-001/note026.html')) The Major as we were ascending on foot to the Castle, met us in his Gig, from which he immediately alighted, & with the utmost politeness conducted us into his Grounds, which are truly beautiful & command some fine views of parts of the lower Lake. It being Session time at **Killarney**[27](javascript:footNote('E800005-001/note027.html')) he apologised for not being able to remain with us long but desired his Son (a fine Lad of about 16) to *do the Honors* in his stead. He first paddled us about in a small pleasure Boat on the River, whose Banks are overhung with Trees, & it's Stream as clear as crystal. We were then conducted to the top Battlements of the Castle from which we enjoyed a fine view of the Lake & its surrounding Country, & afterwards set out again for **Dunloh Gap**. We reached the entrance to the celebrated Chasm at 1 O'Clock & there left our Carriage with directions that the Driver should be in readiness at the same place by ½ past 4.


We first ascended by the side of a clear Stream. When the River



---

p.93



after rain is swollen by the mountain Torrents, the Cascade which it here forms must be a very grand object, but the Stream is now small owing to the present unusually dry weather. Above this Fall we found a deep but narrow Lake whose surface was almost covered with the Flowers of the two **Nymphaeas**[28](javascript:footNote('E800005-001/note028.html')) & of **Lobelia Dortmanna**.[29](javascript:footNote('E800005-001/note029.html')) We here seperated, & each pursuing his Fancy took a different direction among the Rocks we did not meet again for nearly three hours. At the end of the first Lake there is a small ascent over which a widely arched & not inelegant Bridge crosses from one side of the Chasm to the other. From this Bridge I pursued my course nearly to the end of this tremendous defile which is almost three Miles in length, & I passed along the edges of three other Lakes of which the last is particularly romantic and beautiful. It is awfully surrounded with nodding precipices and seems enclosed with Dangers. In several parts of these Lakes we observed **Isoetes lacustris** and I was particularly struck with the beautiful appearance of several large Bushes of the white variety **Erica tetralix**[30](javascript:footNote('E800005-001/note030.html')) which were literally covered with Bloom.


At the further end of the defile I to my no small surprise met our Driver who having got somebody to hold his Horses had rambled to view this stupendous Scene. I asked him how he liked it. ‘Not at all’ said Pat. To my query why he replied ‘Because its such a terrible place & then what's the use of it — why to be sure is'nt one Acre of Land about Waterford worth all of it put together’.[31](javascript:footNote('E800005-001/note031.html'))


In this part of Ireland it seems to be the custom of the Peasantry to wrap themselves up as much as possible in all Weathers, & tho' this day has been exceptionally sultry we have scarcely seen a Man who was not great coated or a Woman who was not muffled up in a large woolen Cloak.


We regained our Chaise about 5 O'Clock, & returned by the Road



---

p.94



we came to **Killarney**, where I found that the Post had just arrived and brought me four Letters from **Swansea**. In consequence of our having determined on some alteration in our future plans we this Evening discharged our Chaise, & Pat wishing long life to our Honors, prepared with a doleful countenance for his return to **Waterford**.[32](javascript:footNote('E800005-001/note032.html')) It was near 8 O'Clock before we got our Dinner, after which we employed ourselves in writing & in preserving Specimens till so late an hour that tho' we were a good deal tired it was after Midnight when we went to Bed.


Friday, July 21st
  

We had set this Day apart for an excursion on the upper and lower Lakes for which purpose we rose early and were in readiness by 7 in the morning but owing to some difficulties about getting a Boat it was near 9 O'Clock before we left our Inn. Having procured a Man with a Bugle & French Horn & made all other necessary arrangements we at length set out on foot & walked along rather an uninteresting Road for nearly two Miles to **Ross Castle**.[33](javascript:footNote('E800005-001/note033.html')) This Castle of which **Weld** has given an accurate Drawing[34](javascript:footNote('E800005-001/note034.html')) stands just over the Bridge which connects **Ross Island** with the main Land & was formerly very strong & used as a *Royal* residence,[35](javascript:footNote('E800005-001/note035.html')) but is now converted to a Barrack.[36](javascript:footNote('E800005-001/note036.html')) We here embarked & were rowed along **Ross Bay** towards the lovely Island of **Innisfallen**, on the edge of which under a Canopy of Ash & Beech Trees stands the ruin of an Abbey which **Lord Kenmare** has converted into a Banqueting House for the accommodation of visitors.[37](javascript:footNote('E800005-001/note037.html')) The northern-most points of **Ross Island** are formed of steep Limestone Rocks, & passing thro' a narrow strait between these and **Mouse Island** we reached the open Lake which then suddenly opened to our view.




---

p.95


In the neighbourhood of **Killarney** there are two Lakes, 4 or 5 Miles distant from each other, & of these one is called the upper and the other the lower Lake. The latter on which we now entered is about 7 Miles long & from 3 to 4 broad. On the West it is bounded by the steep sides of the **Tommies** & **Glennaa** Mountains & the Eastern washes a beautiful well cultivated Country over which several lofty Mountains rise at a short distance. Its surface is studded with more than thirty Islands of various sizes, some of which are barren Craigs, & others are clothed with a great variety of unusually beautiful and richly contrasted foliage. **O'Donoghue's Table** is a naked craig of which so much of the base has been worn away by the continued action of the water, that it appears as if it was artificially supported by four Pillars. The Weather could not have been more delightful, & the surface of the Lake was gently undulated by a faint Breeze.


**Dinis Island** is much resorted to by parties of pleasure, both on account of its internal beauties & the great variety of prospects which it commands. Thro' the narrow Channel at its extremity we were rowed till we had nearly arrived in **Mucross Lake** when turning suddenly to the right we entered the Stream which connects the upper with the lower Lake. Our Boatmen said they never before knew the Water so low, & we in consequence to lighten our Boat were obliged to land by the old Weir Bridge and walk along the Banks of the Channel till we arrived at the **Eagles Nest**. In its loftiest clefts large numbers of Eagles build their Nests. & are generally seen hovering about it, but in this respect we were not fortunate. We here crossed over in our Boat to the opposite shore, & landed a Cannon which our Boatmen had borrowed for the purpose at **Lord Kenmare**'s. We fired six rounds & in the intervals our Musician who was concealed among the opposite Rocks played alternately on the Bugle & French Horn. The repeated Echoes produced by each Discharge of our Cannon resembled loud peals of Thunder & seemed to rend the Rocks. We then reimbarked & having proceeded a short distance, we again landed on a rocky point a little above the **Eagles Nest** where both with our Cannon and Bugle we tried another series of Echoes & thought them still finer than the last.[38](javascript:footNote('E800005-001/note038.html')) We were from there rowed thro' a great variety of exquisitely beautiful scenery, along the numerous windings of the Stream. In about half an hour we arrived in a small Bason encircled by stupendous Rocks & among them a short passage called **Colman's Eye** from some person of that name having



---

p.96



once jumped over it. Thro' this when we had glided the upper Lake suddenly burst on our view & filled me with such delight as I had no idea that any terrestrial scene could have produced. Our Boatmen told us that its length somewhat exceeds two Miles & that it is one Mile broad but it appears much longer.


Among a cluster of beautifully romantic Islands near the extremity of the Lakes is one called **Royane's Island**, distinguishable by its larger size, & by a Cottage which **Lord Kenmare** has built on it for the accommodation of Strangers. The Island consists of a rugged Rock which is covered with the Arbutus, Holly & a variety of Trees and Shrubs.


On this Island we landed & whilst an old woman who attends there on such occasions was preparing a cold Dinner that we had brought with us we wound along a Path to the summit of the Island. Every thing around was wild & magnificent and excepting the Cottage below not a Trace of Man's Labor could be seen.


We returned to our Dinner & as on one excuse or other the Musician had not complied with my request to play 
 God save the King whilst we were on the water I now insisted that it should be played. The Boatmen, at least, pretended not to dislike it & I afterwards gave them leave to play Erin go bras if they chose.[39](javascript:footNote('E800005-001/note039.html')) The principal Boatman who is a shrewd fellow said they did not like those party tunes, one of which I found is Erin go bras & the other



---

p.97


Croppies lie down. He told me that the Band of the Cork Militia lately played the latter thro' the Streets of **Killarney** which occasioned a great riot, & to some just remarks on the impropriety of such conduct he feelingly added ‘For tho' we are all loyal at **Killarney**, yet we are Irishmen’. By our order some Meat had been put up for their Dinners, but neither they nor the Musician would touch a Morsel, & they all dined on three Trout which they had taken with a Fly as we came along. I wonder that our Landlord who is himself a strict Catholick had not recollected that this was Friday.


Having dined we reimbarked & were rowed round the upper end of the Lake to Crosbies Cottage than which it is impossible to imagine a more sequestered or romantic retreat. From thence we returned as we came, but the purple tints of Evening, & the lengthened Shadows from the mountains had so increased the beautiful effect of the Scenery that we enjoyed it almost as much as if we had not seen it before.


The Boatmen as they rowed along amused us with many Tales about **O'Donoghue** who was formerly Lord of this Country, & who tho' he has been dead many hundred years, still frequently appears on the Lake & is often attended with a splendid retinue.[40](javascript:footNote('E800005-001/note040.html')) Our steersman who is 78 years of age declared he had very often seen him, told us many romantic particulars, in perfect unison with the wildness of the Scenery, & which he offered to confirm with an Oath. Two of the other Boatmen also declared they had seen him & that he is often seen rising from & walking or playing *Goals* on the Water, [and this] is by all the Lower orders in this Country, fully and firmly believed.[41](javascript:footNote('E800005-001/note041.html'))


We landed at nine o' Clock on the South side of **Ross Island**, & from thence walked thro' **Lord Kenmare**'s Grounds to our Inn at 



---

p.98


**Killarney**. On the Rocks in the Lake we every where saw an abundance of **Arbutus Unedo**,[42](javascript:footNote('E800005-001/note042.html')) **Pyrus torminalis**[43](javascript:footNote('E800005-001/note043.html')) & **Pyrus Aria**[44](javascript:footNote('E800005-001/note044.html')) & on some boggy ground a little Northward of the **Eagles Nest** we gathered **Schoenus fuscus**.[45](javascript:footNote('E800005-001/note045.html')) Messrs Woods & **Leach** determined to ascend **Macgillycuddy's Reeks** tomorrow but I found my throat so sore & my Cold still so very troublesome that I thought it most prudent not to accompany them & as they intended to start very early we returned to our Rooms at 10 o' Clock.


Saturday, July 22nd
  

My friends set off for the **Reeks** at about 4 this morning & I for the sake of my Cold indulged myself with a Book in Bed till a later hour than usual. I employed myself with writing my Journal of yesterday's excursion & a Letter home which together occupied me till after three, when I took a walk for half an hour about the Town. It is the neatest & best paved of the small Irish Towns that we have yet seen & is said to contain about 4,000 Inhabitants. Among some other very good Houses may be reckoned that of the titular Bishop which adjoins the Catholick Cathedral.[46](javascript:footNote('E800005-001/note046.html')) At the end of the same street is a spacious and rather handsome Building which on enquiry I found is a Nunnery where several unfortunate Females who have taken the black veil are for ever immured.[47](javascript:footNote('E800005-001/note047.html')) There are two Catholick & one Protestant Churches, but the Inhabitants are so very generally attached to the former that the latter is very little frequented. It is said that this religion is more rigidly observed here than in any other Town in Ireland, which may, I apprehend, be attributed to **Lord Kenmare** who with an immense Property & great influence continues firm in his attachment to the Catholick Faith, & the same may be said of nearly all the neighbouring Gentry. I am informed that **Buonaparte**[48](javascript:footNote('E800005-001/note048.html')) by his infamous conduct towards the Pope and the Spanish Monarchy is now abhored as he ought to be by Numbers who before regarded him as their future Deliverer from the oppression under which they at present groan. Much discontent arises from their being obliged to pay



---

p.99



Tithes for the support of what all Catholics are taught to regard as Heresy, but still more from the manner in which these Tithes are collected. The Protestant Clergymen too often let their small Tithes by auction to the highest bidder, and the Purchasers who are called Tythe Farmers are said to make it answer by extorting the utmost Farthing from the very lowest Classes of the Peasantry. One of these Farmers was a few days ago collecting in this manner at **Castle Island** which is only 12 miles from **Killarney** when a few outraged wretches dragged him from the Inn & murdered him in the Street without any Person making the least effort to save him or interfering to prevent the Murderers from effecting their escape. I spoke to several about it but they all considered it as a *white* Murder in which there was no great harm.


After having dined I was preparing for a walk about 6 O'Clock when my Companions returned much sooner than I had expected. They had been on the highest summit of **Macgillycuddy's Reeks**, the ascent to which **Mr Woods** says is not so difficult as **Weld** has represented. The highest point is called **Gheran-tuel**,[49](javascript:footNote('E800005-001/note049.html')) and according to Kirwan's[50](javascript:footNote('E800005-001/note050.html')) measurement is nearly as high as the **Wyddfa** of **Snowden**. From this my friends describe the view as magnificently extensive, but from their account the Mountain seems to offer nothing worth the trouble and fatigue of climbing it. They gathered **Saxifraga Geum** or rather **Saxifraga hirsuta**[51](javascript:footNote('E800005-001/note051.html')) for I believe that the two Plants so called by **Mackay** are not specifically *distinct*, & also another Species which **Mackay** calls adscendens.[52](javascript:footNote('E800005-001/note052.html')) The Mountain seems to afford unusually little sport for a Botanist & they gathered no other Plants which can be considered at all rare except **Rhodiola rosea**[53](javascript:footNote('E800005-001/note053.html')), **Rumex digynus**[54](javascript:footNote('E800005-001/note054.html')) & **Asplenium viride**.[55](javascript:footNote('E800005-001/note055.html'))


Sunday, July 23rd
  

We had heard that Mass in the Chapel of the Nunnery is



---

p.100



performed in public only on Sunday Mornings at ½ past 6 & **Leach** & I therefore rose early for the purpose of attending it. It was with some difficulty & only thro' the assistance of a Catholick from whom we hired our Boat on Friday that we obtained admittance for even the fore Court of the Nunnery was thronged with poor Wretches who were prostrate on their knees. The Moment that we reached the Door, never having seen anything of the kind before I was filled with amazement for large Candles were burning on the Altar which was covered with gewgaws, & the Priest who stood before it wore a kind of white Petticoat which a Robe of Crimson & white Sattin. He really looked more like Punch in a Puppet Show than a Parson performing worship. Only seven Nuns were present of whom five wore the black & two the white Veil[56](javascript:footNote('E800005-001/note056.html')) & they were pent up from the rest of the Congregation by a wooden railing. The Abbess was a tall woman & there seemed to me some thing so severe & forbidding in her deportment, that I from my heart pitied those who were irretrievably subjected to her controul. The Service when we arrived was nearly over, & when it was ended a fellow politely threw some holy water over us & we came away.


Wishing however to know more of their mode of worship & finding as we passed the Cathedral that the Service was about to begin, we entered it. It is a large & gaily painted Building & the Ornaments on & Paintings above the Altar seemed to be good & costly. We in particular remarked several massy Silver Candlesticks of fine workmanship on which large wax Tapers were burning. Even the Aisles & Galleries were already nearly filled with People who were busily employed in counting their Beads. There are no Pews, Seats, or Divisions of any kind whatever in the Body of the Church or Aisles, & the whole Congregation being prostrate on the Stone Floor presented a curious spectacle. In a few minutes after we entered the Priest came in, & took his station before the Altar. His livery resembled that of the Priest at the Nunnery, except that it was still finer, & his crimson Robes, besides the large white Cross, was gaudily ornamented with gold Lace. There was a fine painting of our Saviour over him & the wide difference in the appearance of the great Master & his pretended Disciple, was very striking. I never was so surprized as to find that very nearly all the Service was made up of dumb show, & the remainder consisted in ringing a little Bell, & gabbling a few sentences of Latin so that I could not distinguish a single word. The Audience said nothing & their devotion seemed



---

p.101




wholly to consist of bodily exercises. They sometimes prostrated themselves twice or thrice in a minute, then sprinkled & crossed themselves, counted their Beads &c., & in the short intervals between these Ceremonies some of them with the utmost indifference took Snuff! Beyond anything that I could have imagined it all looked like Mummery, and appeared as if they thought that the great object of their adoration could neither see the Heart or understand any Language but Latin. At the end of the Service the Priest gave notice of a day for the performance of some *sacred* Mystery both in English and Irish, & dismissed the Congregation with a Threat that those who do not then attend the Chapel will be damned.


Just after our return to the Inn, **Counsellor Lapp** who knew me by name when at **Swansea** politely called on & breakfasted with us. Just afterwards we were surprized to see a Post Chaise arrive at an opposite Inn, escorted by a detachment of Dragoons, & containing nothing but a Servant Girl. On enquiry we found that she is a material Evidence against some **White Boys** for the murder of her Master & that the Escort was necessary to prevent her from being murdered by the Murderers Friends.[57](javascript:footNote('E800005-001/note057.html')) According to the representations of Mr Lapp the people are far from being so loyal at **Killarney** as our Boatman wished to make us believe, & he told us that the late Riot arose from the Military Band having been pelted by a Mob whilst playing God save the King, & that they were only dispersed by a charge of Bayonets. As a Punishment for this Outrage the Colonel ordered that the same tune together with Croppies lie down should be played alternately every Evening, & he protected the Band by the Regiment.


**Mr Woods** having determined to devote the day to writing, **Mr Leach** and myself set out without him at ½ past 9 to explore the Peninsula of **Mucross**. We kept along the Road for about 2 Miles & then struck across some Fields to the edge of the Lake where I found **Galium boreale**[58](javascript:footNote('E800005-001/note058.html')) growing in great abundance & **Mr Leach** collected several scarce Insects. We then crossed over a part of **Mr Herbert**'s Grounds to the Ruins of **Mucross Abbey**,[59](javascript:footNote('E800005-001/note059.html')) which is still a favorite



---

p.102



burial place with the Catholicks. Most of the Bodies are not buried but put into a sort of Tomb or rather Cupboard, thro' a trap Door on one side which in many instances was very imperfectly closed. Other Bodies were placed in shallow Graves without any Earth & only a Stone or Plank to cover them. One of these Stones by some means had slipped away, & in looking down we saw two Coffins with the Lids (if they ever had any) broken off so as to expose the half decayed remains of their contents which did not appear to have been dead much more than a Year. Every apartment of the Ruins is used as a Cemetary in the same manner & in each are large Piles of Bones, Skulls & half decayed Coffins. The fact is that the Abbey yard is very small & the Soil very shallow. & the superstitious Peasantry so much prefer being buried on the Southern or Western side that there is not sufficient room for the great number of Bodies which are there brought to be buried. When therefore another of a Family dies that possesses a Tomb, one of the old Tenants is pulled out to make room for the new comer & the Body and Coffin is thrown into the Abbey, within whose sacred precints it is supposed to be perfectly safe.[60](javascript:footNote('E800005-001/note060.html')) The Ruins are for the most part covered with Ivy, & an enormous Yew spreads a deep shade over the Cloisters,[61](javascript:footNote('E800005-001/note061.html')) which added to the sepulchral smell & the sight of so many naked Truths filled me with such a mixture of Awe & Horror that I confess I should not then have liked to be left alone. My imagination involuntarily painted it as ‘The Land of apparitions — empty shades’ & such I am ashamed to
confess was its affect on my Mind that it was sometime before reason



---

p.103



could resume her entire sway. The Eastern Window & several other parts of the Abbey are very handsome, but as a Ruin its beauty cannot be compared with that of **Notley**.[62](javascript:footNote('E800005-001/note062.html'))


From the Abbey we walked to the Villages of **Mucross** & **Clogheen**, & hired a Guide to conduct us to the spots which command the finest views, & which are therefore generally visited by Travellers. The House[63](javascript:footNote('E800005-001/note063.html')) is beautifully situated at the commencement of the Peninsula & is the Residence of **Mr Herbert** now Member for the County.[64](javascript:footNote('E800005-001/note064.html')) The Domains have long been celebrated both for their internal beauties, & for the vast variety of noble Prospects which they command. **Bishop Berkeley** justly remarked ‘that another Louis may lay out another Versailles, but the hand of the Deity only can make **Mucross**’.[65](javascript:footNote('E800005-001/note065.html')) The whole Peninsula consists of rugged Rocks clothed with a great variety of Trees and Shrubs which in some places are so thickly interwoven that the Lake tho' only a few yards distant cannot be seen at all & in others it appears on all sides glittering thro' the Leaves. Every opening of the Woods affords a different view of the Lake, of its Islands & the neighbouring Mountains & each vies with the other in beauty. Some of the little craggy Islands about the Banks are of the most fantastic shapes, & one of them so singularly resembles a Horse when drinking that it is every where known by the name of ‘O'Donoghue's Horse’. As we walked towards **Brickeen** **Turk Lake** was on our left & the Lower Lake on our right & in the very middle of the Peninsula we unexpectely found another small Lake whose surface like a Mirror reflected its sourrounding Rocks & Trees. The sultry heats of noon were tempered by the Breezes from the Lake; the air was filled with the fragrance of wild Flowers, & the Eye wherever it turned beheld a region of Delight, in which Nature seemed to have unlocked all her treasures.


**Col. Herbert** has made a Drive which extends the whole length of the Peninsula, & crossing over a Bridge goes round the Island of



---

p.104


**Brickeen**. Just as we were returning from **Brickeen Island** we hailed a Boat with which four stout Lads were amusing themselves on **Turk Lake**, & after an hour's delightful row we were landed at **Ross Mines** whence on foot we reached **Killarney** at ½ past 5.


At **Bantry** I was told that an able bodied Man gets only ten pence a day for his Labor, but the Wages are here higher I suppose owing to the Mining Establishment on **Ross Island**[66](javascript:footNote('E800005-001/note066.html')) where from four to five hundred are employed. I asked our Guide who was a Laborer what they received at **Mucross**, & he told me ‘A Hog in common times but two tenpennies now we save the Hay’.[67](javascript:footNote('E800005-001/note067.html'))


Just as we were going to Tea Mr [?Japp][68](javascript:footNote('E800005-001/note068.html')) called & introduced Capt. White who I had before seen at Swansea & we accepted an invitation to dine with him tomorrow at his House on **Ross Island**. A Mr Wiggins also called on **Mr Woods** & they remained with us so long that we could do nothing more than journalize a little before Bedtime. Mr Wiggins is Surveyor to Lord Headley's Estates in this neighbourhood[69](javascript:footNote('E800005-001/note069.html')) & they both arrived here a few hours before on their way to Tralee Assize in consequence of 180 of his Lordship's Tenants having signed a resolution that they would pay no more rent!


Monday, July 24th
  

After an early Breakfast we set out on foot to ascend **Mangerton**, which excepting the 
**Reeks** is the highest Mountain about **Killarney**. After having walked three Miles we found a Man willing to be our Guide with whom at ½ past 9 we began the ascent. We wound up a rugged Path & in a short time enjoyed a Bird's Eye view of both the upper and lower Lakes & of all their Islands, Bays, Inlets & Promontories which with their surrounding Mountains form the finest Landscape I have ever seen. In three hours we reached a large Lake situated at the bottom of an enormous hollow near the top of **Mangerton** & surrounded by rocky Precipices of a tremendous height. It is said to be unfathomable and its Irish name signifies the Pit of Hell[70](javascript:footNote('E800005-001/note070.html')) but it is more usually called the **Devil's Punch Bowl**. It is



---

p.105



remarkable for its dark, translucent & very cold waters which so pleased **Charles Fox**[71](javascript:footNote('E800005-001/note071.html')) whilst on a visit at **Lord Kenmare**'s that he swam across the Lake. We tasted some of the *Punch* & hunted over the sides of the *Bowl* in hopes of finding some Alpine Plants but we saw none except **Rumex digymens** of which the leaves served as an excellent relish for some Biscuits we had brought in our Pockets. The Guide to wash down our repast pointed out a small spring that issues from beneath a Rock than which I can imagine nothing more crystalline, & it seemed literally as cold as ice. **Woods** & **Leach** climbed up the almost perpendicular Cliffs, whilst I walked round by a more easy ascent to the Summit of the Mountain which forms a dreary plain without a single Rock on the surface. **Empetrum Nigrum**[72](javascript:footNote('E800005-001/note072.html')) is there very abundant but we could not find any other than Common Plants which with the similar disappointment of my Friends as they ascended the
**Reeks** gave me a poor idea of the botanical fertility of the Kerry Mountains. **Mangerton** commands a magnificently extensive prospect of the neighbouring country, which is bounded on the South & on the West by the Atlantic Ocean, but we had hardly reached the Summit when it began to rain so heavily that the view was greatly obscured & we found it necessary to return. We must not, however, complain for it was the first time that we had been in the least annoyed by the weather since we landed in Ireland, & we found when we approached the foot of the Mountain that it had there scarcely rained at all. The Water that overflows from the Lake runs into the Streams which is [sic] afterwards precipitated down a chasm in the **Turk Mountain** & forms what is called the **Turk Cascade**. The Bed of the Stream is at present nearly dry, & the unusually dry weather, so favourable to the general purposes of our Tour, has prevented us from enjoying the sight, not only of this but also of several other noble falls in the neighbourhood & especially that of **Derricunihy** by the end of the upper Lake.


The People of the Country are extremely superstitious & our Guide amused us all the way with stories about O'Donoghue,
Histories of Fairies, Ghosts, etc. He very gravely told us that the Devil is often seen in every kind of Shape, except that of a Lamb, but that he may always be readily known by a cloven Hoof, which he can neither alter the appearance of or hide. This Wicked One or his Imps sometimes play such pranks about the Mountains that a Priest is not



---

p.106



unfrequently employed to drive him off, & on enquiry I found that ‘No pay no pray’ is a maxim with the Holy Fathers in this as well as all other matters.


Among other traditions one Guide told me that the Danes when they possessed this Country used to make a most excellent kind of Beer from the common Heath of which the natives were so fond that they by force retained two of these Invaders when the remainder reimbarked in order to compel them to teach the manner of brewing it. The two thus retained were a Father & his Son who were tempted with large promises & threatened with torture for the purpose, but the former is said to have killed the latter & then himself to prevent the valuable secret from being known to the Irish who still lament their ignorance of this favourite Beverage of their Ancestors.[73](javascript:footNote('E800005-001/note073.html'))


From the foot of the Mountain we walked to Mucross & again
admired its venerable Abbey, & then strolled across the Domain to the Quay where we found Captain White's four*-*oared Boat in waiting which landed us on **Ross Island** at 5 o Clock. After having been hospitably entertained by Captain White we returned to the Inn on foot & were when we arrived so thoroughly tired that we went almost directly to Bed.


Tuesday, July 25th
  

**Mr Woods** is so delighted with the Scenery about **Killarney** & has found travelling so injurious to his Health that if he could procure a suitable Apartment he determined on spending a few weeks on the borders of the Lake. To the search for some such Apartment he devoted this morning & succeeded in fixing himself very comfortably at **Mucross**. In the meanwhile **Leach** & myself, anxious to make the best use of our time strolled to the Quay at **Ross Castle** with the intention of hiring a Boat & crossing the Lake to **O'Sullivan's Cascade**, but alas, every Boat was engaged. We then went on to **Ross Mines** for the purpose of borrowing Captain White's which he had obligingly said should be always at our service, but here a fresh Disappointment awaited us, for the Boat had been sunk just before in
order to stop it from Leading.[74](javascript:footNote('E800005-001/note074.html')) I however derived some consolation



---

p.107



from the assurance of several Gentlemen who happened to be at the Mines that tho' the Fall is extremely grand when there is plenty of Water yet that it is hardly worth seeing at such a dry Season as the present. I then gave an hour or two to examine the Island on which we found much heavenly scenery but no Rariores except **Lobelia Dortmanna**, **Littorella locustris** & other Plants peculiar to similar situations. I was a good deal puzzled by a very short variety of **Alisma ranunculoides** [75](javascript:footNote('E800005-001/note075.html')) with a single large flower & at first thought it had been a new Species. We returned to our Inn by 5 when Mr Lapp & Capt. White, who had yesterday accepted our Invitation, dined & spent the Evening very pleasantly with us.


Wednesday, July 26th
  

When the Party was formed it was our intention to have gone from **Killarney** to **Dingle**, & from thence via **Tralee** to **Limerick** but the loss of **Mr Woods**' Company, added to the great difficulty (or rather impossibility) of getting either Chaises or Beds in the neighbourhood of **Tralee** during the time of the Assizes which will not be over till next Monday, induced **Mr Leach** & myself to abandon this part of our Plan & we determined on proceeding by the direct Road to **Clonmel**. I rose soon after 6 & packed my Luggage in hopes that we should have been able to procure a Chaisee (for which our Landlord offered to use his best endeavours) & have set out for **Mill Street** in the afternoon. As soon as we had breakfasted we walked to the **Ross Island Mine** where Capt. White had promised that his Boat should be at our disposal. On the Hedges near the Mine we found **Vicia sylvatica**[76](javascript:footNote('E800005-001/note076.html')) growing in great abundance & which I am much mistaken if I did not see growing in **Mucross Abbey** but if so it was there out of flower. We embarked about 10 in Company with a City Ship Merchant who begged to be of our Party, & were first landed on **Innisfallen** which excepting that of **Ross** is the largest Island on the Lakes, & contains about 18 Irish Acres. An old Man who inhabits the only Cottage on the Island officially introduced himself as our Guide & first conducted us over the old Abbey, whose ruins covered with Ivey are far more extensive than they appeared to be as I passed them on Friday.[77](javascript:footNote('E800005-001/note077.html')) The old Chapel is beautifully situated on a Rock



---

p.108



that overhangs the Lake & has been converted by **Lord Kenmare** into a Banqueting House for the accommodation of visitors.[78](javascript:footNote('E800005-001/note078.html')) It is customary for the neighbouring Gentry to give Balls & Fetes champetres here but a large half buried Pile of human Skulls in the ancient Cemetary close by, seems calculated:
  


> 1. 'to spoil the Dance of youthful Blood
>   
> And strike the Dimple from the Cheek of Mirth.'[79](javascript:footNote('E800005-001/note079.html'))
> 


Our Companion seemed to have no idea of Happiness excepting that of making Money & made a great boast of having as he passed thro' **Killarney** on his way to **Tralee** about Business, thus given up one whole day to see the Lakes. He absolutely called us back to ask the name of a Plant that beautifully covered an old Wall & we told him it was Ivy which it seems he had neither seen or heard of before. The leaves were unusually large & it grew perhaps more luxuriantly than I had ever before seen it. He also enquired the name of a Tree which he much admired & when told it was an Ash he declared he should have known the Timber if it had been stripped of the Leaves & began immediately to calculate its value. We found an **Orobanche**[80](javascript:footNote('E800005-001/note080.html')) which is common on Ivy & which Mr Drummond considers as a new Species. When the great City Ship Owner heard such a fine outlandish Name applied to such an ugly Weed he seemed much surprized & his ignorance afforded **Leach** such a fair opportunity for quizzing & cramming him that he occasioned us a good deal of merriment.


**Innisfallen** is skirted on all sides with Ash, Yew & Holly, which have grown to an unusually enormous size (expecially the latter of which one Tree measures 11 feet in circumference) & it abounds with such lovely scenery that I could readily have fancied myself in the very Island of Calypso. I was particularly pleased with the beautiful contrast formed by the silvery tints of the Ash & the solemn shades of the Yew as their quivering Leaves appeared reflected together on the surface of the Lake beneath them.




---

p.109


From this Island we were rowed across the Lake & landed among some noble Woods at the foot of the **Tomies Mountain**, which after having ascended about 50 yards we saw the White Foam of **O'Sullivan's Cascade** sparkling among the Leaves. We found the Stream much more miserable than we expected but the Cascade is not near equally high, nor independent of the far finer Woods by which it is surrounded, so I think it equally beautiful with the lower (?)Culhepeste to which of the Falls about **Pont Nedd Vechn**[81](javascript:footNote('E800005-001/note081.html')) it bears most resemblance. **Hymenophyllum alatum**[82](javascript:footNote('E800005-001/note082.html')) of English Botany grows on the Rocks about the Cascade in great profusion & an examination of recent Specimens has increased my suspicion that it ought not to be regarded as any thing more than a variety of the common Species. On the Rocks we also gathered **Dicranum majus**, **Dicranum falcatum**[83](javascript:footNote('E800005-001/note083.html')), **Hypnum proliferum**[84](javascript:footNote('E800005-001/note084.html')) & several other Mosses in front & on some marshy ground we saw **Sium verticillatum**[85](javascript:footNote('E800005-001/note085.html')) which is rather a common Plant in the neighbourhood of **Killarney**. The City Merchant, surprized to see us gather such large quantities of the **Hymenophyllums** [sic] was very inquisitive about its use, & **Leach** so far made him believe, tho' it is the most scentless of Plants, that it is used by the West Indians in the manufacture of Snuff & gives the fine flavor to Majueba, that he seemed half inclined to ship a Cargo for the London Market.


On our return there was only a gentle Breeze but the waves were sufficiently high to make me feel a little uncomfortable, & the Lake especially in this part is often so violently agitated that even **Lord Kenmare**'s large Yacht dares not venture out. Hurricanes even during the finest Weather, so often & so suddenly descend with impetuous fury from the Mountain that no Boat ever ventures to carry a Sail on the Lake. As the Merchant wished to extend his Voyage, and see a few other Wonders, besides Ivy, to tell about in the City, we agreed for his conveneancy to be landed on the outermost point of **Ross Island**, from which we walked to the Mines. The Man who steered our Boat was a remarkable, shrewd & nearly the most impudent Fellow I every met with & he gave us the following account of himself in the face of the other Boatmen without the least hesitation. ‘I was born & bred in **Killarney** & have lately been discharged on account of my Wounds from his Majesty's Navy in which I have served most of



---

p.110



my Life. I thought as I had been a good deal among the Savages of the Savage Islands & of most other parts of the World that I could continue to live among my own Countrymen but d—m 'em, they are more *uncivilized* than all the Savages in the South Seas, & beat 'em out & out for ferocity, theft & villainy of every kind so that please G—d I shall next week again bid good by to old Ireland for ever’.


We examined the Copper Ore at the Mines which we found imbedded in Lime Stone & were told that till lately it had not been worked since the Danes were in possession of the Country. The Miners in the old Danish Shafts have found several Hammers made of a very hard Stone which is said to differ from any that the neighbourhood produces, but nothing remains of the handle except the Indenture by which it was affix'd to the Stone.[86](javascript:footNote('E800005-001/note086.html')) We returned to **Killarney** after having spent half an hour with Capt. White, who politely offered me one of the Danish Hammers, but it was so ponderous that I hardly thought it worth bringing away.


By the road side we saw **Sirex Gigas**,[87](javascript:footNote('E800005-001/note087.html')) which **Mr Leach** for a long while endeavoured to catch, but in vain. On our arrival at the Inn we were vexed to find that our Landlord's endeavours to get a Chaise had been unsuccessful. None of the Innkeepers at **Killarney** keep any Carriages & only three are kept in the Towne, which the Proprietor will not let for travelling when he can hire them out for pleasuring about the Lakes. The Fellow told me positively that I should not have one on Thursday, nor would he make any promise for Friday or even Saturday, under the pretence that they were half engaged. In order therefore that we might not be thus delayed, we hired a Cart to take our Luggage & determined to set out on foot for **Mill Street** tomorrow morning. It was late before we dined, & as we meant to rise at 5 we settled our Bill & soon afterwards retired early to Bed.



---

p.111



Settling the Bill we however found a tedious Job for very little Mony is to be had & the chief substitute in circulation consists of Killarney Notes[88](javascript:footNote('E800005-001/note088.html')) for the following Sums:
  

d d d d
  

3 6 13 19 ½ 2/- 2/2 2/6.


### Acknowledgements


I wish to thank Dr David Dickson of Trinity College Dublin for drawing attention to **Dillwyn**'s manuscript and the Board of the College for permission to publish it. I owe a special debt of gratitude to Miss M. Scannell, Head of Herbarium, National Botanic Gardens, for elucidating the numerous botanical references. The following also helped: Peter Tynan O'Mahony, Secretary, O'Mahony Records
Society; Dr Breandán Ó Cíobháin, Coimisiún na Logainmneacha; Breandán Breathnach, Na Píobairí Uilleann; Dr Pádraig de Brún, Dublin Institute for Advanced Studies; Rev. Fr Kieran O'Shea, Castleisland; Mr Danny Moriarty, Kenmare; Dr Noel Kissane, Mr Brian McKenna and Peadar Mac Mathúna, National Library; Dr Jim O'Connor and Mr Mark Holmes, Natural History Museum; Mrs K.
Browne and Mrs Margaret O'Riordan, Kerry County Library.














