

#Le h-ais na Teineadh


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Le h-ais na Teineadh
====================


Author: Douglas Hyde
--------------------


### File Description

Donated to CELT by Alan Mac an Bhaird Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
The Higher Education Authority via PRTLI 1. First draft, revised and corrected.Extent of text: 31460 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland— http://www.ucc.ie/celt

 (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: G307006Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only. This work is copyrighted and reproduced here with the kind permission of the copyright holder.


#### Sources


**Literature by or about Douglas Hyde**2. Douglas Hyde, Leabhar Sgeulaigheachta: folk stories in Irish with notes by Dr. Hyde, LL.D. (Dublin: Gill 1889).
3. Douglas Hyde, An Irish funeral oration over Owen O'Neill of the house of Clanaboy, Ulster Journal of Archaeology 3/4; 4/1 (1897) 258-271, 50-55.
4. Douglas Hyde, A literary history of Ireland from the earliest times to the present day (Dublin 1899).
5. Diarmuid Ó Cobhthaigh, Douglas Hyde: an Craoibhin Aoibhinn (Dublin: Maunsel 1917).
6. Douglas Hyde, Catalogue of the books and manuscripts comprising the library of Sir John T. Gilbert (Dublin 1918).
7. Douglas Hyde [=an Craoibhín Aoibhinn] (ed.), Abhráin ghrádha Chúige Chonnacht: ar n-a gcruinniughadh agus ar n-a bhfoillsiughadh de'n chéad uair (Baile Átha Cliath [=Dublin]: Foillseacháin Rialtais 1931).
8. Douglas Hyde [=an Craoibhín Aoibhinn] (ed. & trans.), Abhráin diadha chúige Connacht [=The religious songs of Connacht: a collection of poems, stories, prayers, satures, ranns, charms etc. being chapter VI of the Songs of Connacht (Dublin: Gill 1905-06).
9. Douglas Hyde, Mo thúras go h-Americe (Dublin 1937).
10. Douglas Hyde, Mise agus an Connradh (Dublin 1937).
11. Diarmid Coffey, Douglas Hyde, President of Ireland (Dublin: Maunsel 1918).
12. Review of above, The Irish Monthly, vol. 46/537 (March 1918) 179–180.
13. P. S. O'Hegarty, A bibliography of Dr. Douglas Hyde (Dublin: privately printed by Alex. Thom 1939).
14. Doiminic Ó Dálaigh, 'The young Douglas Hyde', Studia Hibernica 10 (1970) 108–135.
15. Seán Ó Lúing, 'Douglas Hyde and the Gaelic League', Studies: An Irish Quarterly Review 62/246 (summer 1973) 123–138.
16. Gareth W. Dunleavy, Douglas Hyde (Lewisburg, New Jersey: Bucknell University Press 1974).
17. Dominic Daly, The young Douglas Hyde: the dawn of the Irish revolution and renaissance, 1874-1893 (Dublin: Irish University Press 1974).
18. Robert Welch, 'Douglas Hyde and His Translations of Gaelic Verse', Studies: An Irish Quarterly Review 64/255 (autumn 1975) 243–257.
19. Gareth Dunleavy, "Hyde's Crusade for the Language and the Case of the Embarrassing Packets," Studies: An Irish Quarterly Review 73 (1984) 12–25.
20. Douglas Hyde, Language, Lore, and Lyrics: Essays and Lectures. Edited by Breandán Ó Conaire. (Blackrock: Irish Academic Press 1986).
21. Janet Egleson Dunleavy & Gareth W. Dunleavy, Douglas Hyde: a maker of modern Ireland (Berkeley: University of California Press 1991).
22. Brian MacCuarta, review of above, Studies: An Irish Quarterly Review 81/321 (spring 1992) 122–124.
23. Risteárd Ó Glaisne, Dúbhglas de h-Íde (1860-1949): náisiúnach neamhspleách 1910–1949 (Baile Átha Cliath[=Dublin]: Conradh na Gaeilge 1993).
24. Seán Ó Lúing, Celtic studies in Europe: and other essays (Dublin: Geography Publications 2000).
**Works mentioned in this book**2. Thomas Crofton Croker, Fairy Legends and Traditions of the South of Ireland. First published 1825; republished with a Memoir of T. C. Croker by his son, T. F. Dillon Croker (London: William Tegg 1862).
3. Eugene O'Curry, Lectures on the manuscript materials of ancient Irish history (Dublin 1861).
4. Patrick Kennedy, Legendary Fictions of the Irish Celts (London 1866).
5. Patrick Kennedy, The Fireside Stories of Ireland (Dublin: M'Glashan & Gill 1870).
6. Albert Henry Wratislaw, Sixty folk-tales from exclusively Slavonic sources (Boston: Houghton, Mifflin, & Company 1890).
7. Lady Jane Francesca Agnes (Speranza) Wilde, Ancient Legends, Mystic Charms, and Superstitions of Ireland (Boston: Ticknor & Co. 1887).
8. Lady Jane Francesca Agnes (Speranza) Wilde, Ancient cures, charms and usages of Ireland: Contributions to Irish lore (London: Ward and Downey, 1890).
9. D. MacInnes (ed. and trans.), Waifs and strays of Celtic tradition, vol. II. Folk and hero tales; collected, edited (in Gaelic), and translated by the Rev. D. Mac Innes; with a study on the development of the Ossianic saga, and copious notes by Alfred Nutt (London 1890).
10. Jeremiah Curtin, Myths and folk-lore of Ireland (London and Boston 1890).
11. Jeremiah Curtin, Hero Tales of Ireland (1894).
12. Jeremiah Curtin, Tales of the fairies and of the ghost world: collected from oral tradition in South-West Munster by Jeremiah Curtin (London: Nutt 1895).
13. John Francis [=Iain] Campbell, Popular Tales of the West Highlands, orally collected with a translation by J. F. Campbell; vol 4 (Edinburgh 1862).
**The edition used in the digital edition**2. Beside the Fire: a Collection of Irish Gaelic folk stories; with additional notes by Alfred Nutt. Douglas Hyde First edition [lviii + 203 pages] David NuttLondon (1890)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the author's preface, notes by Alfred Nutt, and even pages 2 to 102 of the volume.


#### Editorial Declaration


##### Correction


Text has been checked and proof-read twice.


##### Normalization


The electronic text represents the edited text. In Hyde' edition, the acute accent on words such as mé, t(h)ú, ó, nó, etc. is sometimes omitted; this was rectified. Long eu such as in sgeul, beul was left unmarked. In other cases in the printed edition long vowels are sometimes accented where this is not the norm today, as in síad, rómhad, ceól etc. Corrections to typographical errors are marked corr sic="" resp="", with the editor's ID marked. The word folk-lorist has been changed to folklorist.


##### Quotation


Direct speech is marked q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the group of tales; div1=the individual tale. Page-breaks are marked pb n="".


##### Interpretation


Personal names in the preface are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: 
 (1890) #### Use of language


##### Language: [GA] The text is in Modern Irish from Connaught.


##### Language: [EN] The preface and some words in the stories are in English.


##### Language: [LA] Some words in the preface are in Latin.


##### Language: [DE] Some words in the preface are in German.


##### Language: [FR] Some words in the preface are in French.


### Revision History


* (2010-07-28) Beatrix Färber (ed.)

* Bibliographic details compiled; preface proofed (2); conversion script run, SGML and HTML versions created.
* (2010-07-27) Beatrix Färber (ed.)

* Preface proofed (1) and encoded for structure and content; file parsed, header modified.
* (2010-07-23) Beatrix Färber (ed.)

* Header created.
* (2010-07-22) Beatrix Färber (ed.)

* File proofed (2); structural and content markup added; Preface captured.
* (2010-01) Alan Mac an Bhaird (ed.)

* File proofed (1).
* (2010-01) Alan mac an Bhaird (donation)

* Stories donated to CELT.
* (2010-01) Alan mac an Bhaird (data capture)

* Stories typed in and first proofing.




---


#### Corpus of Electronic Texts Edition: G307006


### Le h-ais na Teineadh: Author: Douglas Hyde




---

p.ix


### Preface


IRISH and Scotch Gaelic folk-stories are, as a living form of literature, by this time pretty nearly a thing of the past. They have been trampled in the common ruin under the feet of the Zeitgeist, happily not before a large harvest has been reaped in Scotland, but, unfortunately, before anything worth mentioning has been done in Ireland to gather in the crop which grew luxuriantly a few years ago. Until quite recently there existed in our midst millions of men and women who, when their day's work was over, sought and found mental recreation in a domain to which few indeed of us who read books are permitted to enter. Man, all the world over, when he is tired of the actualities of life, seeks to unbend his mind with the creations of fancy. We who can read betake ourselves to our favourite novelist, and as we peruse his fictions, we can almost see our author erasing this, heightening that, and laying on such-and-such a touch for effect. His book is the product of his individual brain, and some of us or of our contemporaries have been present at its genesis.




---

p.x


But no one can tell us with certainty of the genesis of the folk-tale, no one has been consciously present at its inception, and no one has marked its growth. It is in many ways a mystery, part of the flotsam and jetsam of the ages, still beating feebly against the shore of the nineteenth century, swallowed up at last in England by the waves of materialism and civilization combined; but still surviving unengulfed on the western coasts of Ireland, where I gathered together some bundles of it, of which the present volume is one.


The folk-lore of Ireland, like its folk-songs and native literature, remains practically unexploited and ungathered. Attempts have been made from time to time during the present century to collect Irish folk-lore, but these attempts, though interesting from a literary point of view, are not always successes from a scientific one. **Crofton Croker**'s delightful book, Fairy Legends and Traditions of the South of Ireland, first published anonymously in 1825, led the way. All the other books which have been published on the subject have but followed in the footsteps of his; but all have not had the merit of his light style, his pleasant parallels from classic and foreign literature, and his delightful annotations, which touch, after a fascinating manner peculiarly his own, upon all that is of interest in his text. I have written the word ‘text’, but that word conveys the idea of an original to be annotated upon; and **Crofton Croker**


---

p.xi




is, alas! too often his own original. There lies his weak point, and there, too, is the defect of all who have followed him. The form in which the stories are told is, of course, **Croker**'s own; but no one who knows anything of fairy lore will suppose that his manipulation of the originals is confined to the form merely. The fact is that he learned the ground-work of his tales from conversations with the Southern peasantry, whom he knew well, and then elaborated this over the midnight oil with great skill and delicacy of touch, in order to give a saleable book, thus spiced, to the English public.


Setting aside the novelists **Carleton** and **Lover**, who only published some incidental and largely-manipulated Irish stories, the next person to collect Irish folk-lore in a volume was **Patrick Kennedy**, a native of the County Wexford, who published Legendary Fictions of the Irish Celts, and in 1870 a good book, entitled, The Fireside Stories of Ireland, which he had himself heard in Wexford when a boy. Many of the stories which he gives appear to be the detritus of genuine Gaelic folk-stories, filtered through an English idiom and much impaired and stunted in the process. He appears, however, not to have adulterated them very much. Two of the best stories in the book, Jack, the Cunning Thief and Shawn an Omadawn, I heard myself in the adjoining county Wicklow, and the versions of them that I heard did not differ very widely from **Kennedy**'s. It 





---

p.xii



 

is interesting to note that these counties, close to the Pale as they are, and under English influence for so long, nevertheless seem to have preserved a considerable share of the old Gaelic folk-tales in English dress, while in Leitrim, Longford, Meath, and those counties where Irish died out only a generation or two ago, there has been made as clean a sweep of folk-lore and Gaelic traditions as the most uncompromising ‘West Briton’ could desire. The reason why some of the folk-stories survive in the eastern counties is probably because the Irish language was there exchanged for English at a time when, for want of education and printed books, folk-stories (the only mental recreation of the people) *had* to transfer themselves rightly or wrongly into English. When this first took place I cannot tell, but I have heard from old people in Waterford, that when some of their fathers or grandfathers marched north to join the Wexford Irish in '98, they were astonished to find English nearly universally used amongst them. **Kennedy** says of his stories: ‘I have endeavoured to present them in a form suitable for the perusal of both sexes and of all ages’; and ‘such as they are, they may be received by our readers as obtained from local sources.’ Unfortunately, the sources are not given by him any more than by **Croker**, and we cannot be sure how much belongs to **Kennedy** the bookseller, and how much to the Wexford peasant.




---

p.xiii


After this come **Lady Wilde**'s volumes—her Ancient Legends, and her recently published Ancient Cures, Charms, and Usages, in both of which books she gives us a large amount of narrative matter in a folk-lore dress; but, like her predecessors, she disdains to quote an authority, and scorns to give us the least inkling as to where such-and-such a legend, or cure, or superstition comes from, from whom it was obtained, who were her informants, whether peasant or other, in what parishes or counties the superstition or legend obtains, and all the other collateral information which the modern *folklorist* is sure to expect. Her entire ignorance of Irish, through the medium of which alone such tales and superstitions can properly, if at all, be collected, is apparent every time she introduces an Irish word. She astonishes us Irish speakers with such striking observations as this—‘Peasants in Ireland wishing you good luck, say in Irish, 'The blessing of Bel and the blessing of Samhain be with you,' that is, of the sun and of the moon.’[1](javascript:footNote('G307006/note001.html')) It 





---

p.xiv



 

would be interesting to know the locality where so curious a Pagan custom is still practised, for I confess that though I have spoken Irish in every county where it is still spoken, I have never been, nor do I expect to be, so saluted. **Lady Wilde**'s volumes are, nevertheless, a wonderful and copious record of folk-lore and folk customs, which must lay Irishmen under one more debt of gratitude to the gifted compiler. It is unfortunate, however, that these volumes are hardly as valuable as they are interesting, and for the usual reason—that we do not know what is **Lady Wilde**'s and what is not.


Almost contemporaneously with **Lady Wilde**'s last book there appeared this year yet another important work, a collection of Irish folk-tales taken from the Gaelic speakers of the south and north-west, by an American gentleman, **Mr. Jeremiah Curtin**. He has collected some twenty tales, which are told very well, and with much less cooking and flavouring than

 



---

p.xv



 

his predecessors employed. **Mr. Curtin** tells us that he has taken his tales from the old Gaelic-speaking men but he must have done so through the awkward medium of an interpreter, for his ignorance of the commonest Irish words is as startling as **Lady Wilde**'s.[2](javascript:footNote('G307006/note002.html')) He follows **Lady Wilde** in this, too, that he keeps us in profound ignorance of his authorities. He mentions not one name, and except that he speaks in a general way of old Gaelic speakers in nooks where the language is still spoken, he leaves us in complete darkness as to where and from whom, and how he collected these stories. In this he does not do himself justice, for, from my own knowledge of Irish folk-lore, such as it is, I can easily recognize that **Mr. Curtin** has approached the fountainhead more nearly than any other. Unfortunately, like his predecessors, he has a literary style of his own, for 





---

p.xvi



 

which, to say the least of it, there is no counterpart in the Gaelic from which he has translated.[3](javascript:footNote('G307006/note003.html'))


We have as yet had no *folklorist* in Ireland who could compare for a moment with such a man as **Iain Campbell**, of Islay, in investigative powers, thoroughness of treatment, and acquaintance with the people, combined with a powerful national sentiment, and, above all, a knowledge of Gaelic. It is on this last rock that all our workers-up of Irish folk-lore split. In most circles in Ireland it is a disgrace to be known to talk Irish; and in the capital, if one makes use of an Irish word to express one's meaning, as one sometimes does of a French or German word, one would be looked upon as positively outside the pale of decency; hence we need not be surprised at the ignorance of Gaelic Ireland displayed by littérateurs who write for the English public, and foist upon us modes of speech which we have not got, and idioms which they never learned from us.


This being the case, the chief interest in too many of our folk-tale writers lies in their individual treatment of the skeletons of the various Gaelic stories obtained through English mediums, and it is not devoid of interest 





---

p.xvii



 

to watch the various garbs in which the sophisticated minds of the ladies and gentlemen who trifled in such matters, clothed the dry bones. But when the skeletons were thus padded round and clad, although built upon folk-lore, they were no longer folk-lore themselves, for folk-lore can only find a fitting garment in the language that comes from the mouths of those whose minds are so primitive that they retain with pleasure those tales which the more sophisticated invariably forget. For this reason folk-lore is presented in an uncertain and unsuitable medium, whenever the contents of the stories are divorced from their original expression in language. Seeing how Irish writers have managed it hitherto, it is hardly to be wondered at that the writer of the article on folk-lore in the Encyclopaedia *Britannica*, though he gives the names of some fifty authorities on the subject, has not mentioned a single Irish collection. In the present book, as well as in my Leabhar Sgeulaigheachta, I have attempted—if nothing else—to be a little more accurate than my predecessors, and to give the *exact language* of my informants, together with their names and various localities—information which must always be the very first requisite of any work upon which a future scientist may rely when he proceeds to draw honey (is it always honey?) from the flowers which we collectors have culled for him.




---

p.xviii


It is difficult to say whether there still exist in Ireland many stories of the sort given in this volume. That is a question which cannot be answered without further investigation. In any other country the great body of Gaelic folk-lore in the four provinces would have been collected long ago, but the ‘Hiberni incuriosi suorum’ appear at the present day to care little for anything that is Gaelic; and so their folk-lore has remained practically uncollected.


Anyone who reads this volume as a representative one of Irish folk-tales might, at first sight, imagine that there is a broad difference between the Gaelic tales of the Highlands and those of Ireland, because very few of the stories given here have parallels in the volumes of **Campbell** and **MacInnes**. I have, however, particularly chosen the tales in the present volume on account of their dissimilarity to any published Highland tales, for, as a general rule, the main body of tales in Ireland and Scotland bear a very near relation to each other. Most of **Mr. Curtin**'s stories, for instance, have Scotch Gaelic parallels. It would be only natural, however, that many stories should exist in Ireland which are now forgotten in Scotland, or which possibly were never carried there by that section of the Irish which colonized it; and some of the most modern—especially of the kind whose genesis I have called conscious—must have arisen amongst the Irish since then, while on the other 





---

p.xix



 

hand some of the Scotch stories may have been bequeathed to the Gaelic language by those races who were displaced by the Milesian Conquest in the fifth century.


Many of the incidents of the Highland stories have parallels in Irish MSS., even incidents of which I have met no trace in the folk-lore of the people. This is curious, because these Irish MSS. used to circulate widely, and be constantly read at the firesides of the peasantry, while there is no trace of MSS. being in use in historical times amongst the Highland cabins. Of such stories as were most popular, a very imperfect list of about forty is given in **Mr. Standish O'Grady**'s excellent preface to the third volume of the **Ossianic Society**'s publications. After reading most of these in MSS. of various dates, and comparing them with such folk-lore as I had collected orally, I was surprised to find how few points of contact existed between the two. The men who committed stories to paper seem to have chiefly confined themselves to the inventions of the bards or professional story-tellers—often founded, however, on folk-lore incidents—while the taste of the people was more conservative, and willingly forgot the bardic inventions to perpetuate their old Aryan traditions, of which this volume gives some specimens. The discrepancy in style and contents between the MS. stories and those of the people leads me to believe that the 





---

p.xx



 

Stories in the MSS. are not so much old Aryan folk-tales written down by scholars as the inventions of individual brains, consciously inventing, as modern novelists do. This theory, however, must be somewhat modified before it can be applied, for, as I have said, there are incidents in Scotch Gaelic folk-tales which resemble those of some of the MS. stories rather nearly. Let us glance at a single instance—one only out of many—where Highland tradition preserves a trait which, were it not for such preservation, would assuredly be ascribed to the imaginative brain of an inventive Irish writer.


The extraordinary creature of which **Campbell** found traces in the Highlands, the Fáchan, of which he has drawn a whimsical engraving,[4](javascript:footNote('G307006/note004.html')) is met with in an Irish MS. called Iollann Arm-Dearg. Old MacPhie, **Campbell**'s informant, called him the ‘Desert creature of Glen Eite, the son of Colin’, and described him as having ‘one hand out of his chest, one leg out of his haunch, and one eye out of the front of his face’; and again, ‘ugly was the make of the Fáchan, there was one hand out of the ridge of his chest, and one tuft out of the top of his head, and it were easier to take a mountain from the root than to bend that tuft.’ This one-legged, one-handed, one-eyed creature, unknown, as **Campbell** remarks, to German or Norse mythology, is thus described 





---

p.xxi



 

in the Irish manuscript: ‘And he (Iollann) was not long at this, until he saw the devilish misformed element, and the fierce and horrible spectre, and the gloomy disgusting enemy, and the morose unlovely churl (mogha); and this is how he was: he held a very thick iron flail-club in his skinny hand, and twenty chains out of it, and fifty apples on each chain of them, and a venomous spell on each great apple of them, and a girdle of the skins of deer and roebuck around the thing that was his body, and one eye in the forehead of his black-faced countenance, and one bare, hard, very hairy hand coming out of his chest, and one veiny, thick-soled leg supporting him and a close, firm, dark blue mantle of twisted hard-thick feathers, protecting his body, and surely he was more like unto devil than to man.’ This creature inhabited a desert, as the Highlander said, and were it not for this corroborating Scotch tradition, I should not have hesitated to put down the whole incident as the whimsical invention of some Irish writer, the more so as I had never heard any accounts of this wonderful creature in local tradition. This discovery of his counterpart in the Highlands puts a new complexion on the matter. Is the Highland spectre derived from the Irish manuscript story, or does the writer of the Irish story only embody in his tale a piece of folk-lore common at one time to all branches of the Gaelic race, and now all but extinct. This last supposition is certainly the true one, for it is 





---

p.xxii



 

borne out by the fact that the Irish writer ascribes no name to this monster, while the Highlander calls him a Fáchan,[5](javascript:footNote('G307006/note005.html')) a word, as far as I know, not to be found elsewhere. But we have further ground for pausing before we ascribe the Irish manuscript story to the invention of some single bard or writer. If we read it closely we shall see that it is largely the embodiment of other folk-tales. Many of the incidents of which it is composed can be paralleled from Scotch Gaelic sources, and one of the most remarkable, that of the prince becoming a journeyman fuller, I have found in a Connacht folk-tale. This diffusion of incidents in various tales collected all over the Gaelic-speaking world, would point to the fact that the story, as far as many of the incidents go, is not the invention of the writer, but is genuine folk-lore thrown by him into a new form, with, perhaps, added incidents of his own, and a brand new dress.


But now in tracing this typical story, we come across another remarkable fact—the fresh start the story took on its being thus recast and made up new. Once the order and progress of the incidents were thus stereotyped, as it were, the tale seems to have taken a new 





---

p.xxiii



 

lease of its life, and gone forth to conquer; for while it continued to be constantly copied in Irish manuscripts, thus proving its popularity as a written tale, it continued to be recited verbally in Scotland in something like the same bardic and inflated language made use of by the Irish writer, and with pretty nearly the same sequence of incidents, the three adventurers, whose Irish names are Ur, Artuir, and Iollann, having become transmogrified into Ur, Athairt, and Iullar, in the mouth of the Highland reciter. I think it highly improbable, however, that at the time of this story being composed—largely out of folk-tale incidents—it was also committed to paper. I think it much more likely that the story was committed to writing by some Irish scribe, only after it had gained so great a vogue as to spread through both Ireland and Scotland. This would account for the fact that all the existing MSS. of this story, and of many others like it, are, as far as I am aware, comparatively modern.[6](javascript:footNote('G307006/note006.html')) Another argument in favour of this 





---

p.xxiv



 

supposition, that bardic tales were only committed to writing when they had become popular, may be drawn from the fact that both in Ireland and the Highlands we find in many folk-lore stories traces of bardic compositions easily known by their poetical, alliterative, and inflated language, of which no MSS. are found in either country. It may, of course, be said, that the MSS. have perished; and we know how grotesquely indifferent the modern Irish are about their literary and antiquarian remains; yet, had they ever existed, I cannot help thinking that some trace of them, or allusion to them, would be found in our surviving literature.


There is also the greatest discrepancy in the poetical passages which occur in the Highland oral version and the Irish manuscript version of such tales as in incident are nearly identical. Now, if the story had been propagated from a manuscript written out once for all, and then copied, I feel pretty sure that the resemblance between the alliterative passages in the two would be much closer. The dissimilarity between them seems to show that the incidents and not the language were the things to be remembered, and that every wandering bard who picked up a new story from a colleague, stereotyped the incidents in his mind, but uttered them whenever he recited 





---

p.xxv




the story, in his own language; and whenever he came to the description of a storm at sea, or a battle, or anything else which the original poet had seen fit to describe poetically, he did so too, but not in the same way or the same language, for to remember the language of his predecessor on these occasions, from merely hearing it, would be well-nigh impossible. It is likely, then, that each bard or story-teller observed the places where the poetical runs should come in, but trusted to his own cultivated eloquence for supplying them. It will be well to give an example or two from this tale of Iollann. Here is the sea-run, as given in the Highland oral version, after the three warriors embark in their vessel:—
  


‘They gave her prow to sea and her stern to shore,
  


They hoisted the speckled flapping bare-topped sails,
  


Up against the tall tough splintering masts,
  
And they had a pleasant breeze as they might chose themselves,
  


Would bring heather from the hill, leaf from grove, willow from its roots.
  


Would put thatch of the houses in furrows of the ridges,
  


The day that neither the son nor the father could do it,
  


That same was neither little nor much for them,
  


But using it and taking it as it might come.
  


The sea plunging and surging,
  


The red sea the blue sea lashing,
  


And striking hither and thither about her planks,
  


The whorled dun whelk that was down on the floor of the ocean,
  


Would give a *snag* on her gunwale and a crack on her floor,
  


She would cut a slender oaten straw with the excellence of her going.’


It will be observed how different the corresponding run in the Irish manuscript is, when thrown into verse, 





---

p.xxvi



 

for the language in both versions is only measured prose:—
  


‘Then they gave an eager very quick courageous high-spirited flood-leap
  


To meet and to face the sea and the great ocean.
  


And great was the horror *****
  


Then there arose before them a fierceness in the sea,
  


And they replied patiently stoutly strongly and vigorously,
  


To the roar of the green sided high-strong waves,
  


Till they made a high quick very-furious rowing
  


Till the deep-margined dreadful blue-bordered sea
  


Arose in broad-sloping fierce-frothing plains
  


And in rushing murmuring flood-quick ever-deep platforms.
  


And in gloomy horrible swift great valleys
  


Of very terrible green sea, and the beating and the pounding
  


Of the strong dangerous waves smiting against the decks
  


And against the sides of that full-great full-tight bark.’


It may, however, be objected that sea-runs are so common and so numerous, that one might easily usurp the place of another, and that this alone is no proof that the various story-tellers or professional bards, contented themselves with remembering the incidents of a story, but either extemporised their own runs after what flourish their nature would, or else had a stock of these, of their own composing, always ready at hand. Let us look, then, at another story of which **Campbell** has preserved the Highland version, while I have a good Irish MS. of the same, written by some northern scribe, in 1762. This story, The Slender Grey Kerne, or Slim Swarthy Champion, as **Campbell** translates it, is full of alliterative runs, which the Highland reciter has retained 





---

p.xxvii



 

in their proper places, but couched in different language, while he introduces a run of his own which the Irish has not got, in describing the swift movement of the kerne. Every time the kerne is asked where he comes from, the Highlander makes him say—
  


‘I came from hurry-skurry.
  


From the land of endless spring,[7](javascript:footNote('G307006/note007.html'))
  


From the loved swanny glen,
  


A night in Islay and a night in Man,
  


A night on cold watching cairns
  


On the face of a mountain.
  


In the Scotch king's town was I born,
  


A soiled sorry champion am I
  


Though I happened upon this town.’


In the Irish MS, the kerne always says—
  


‘In Dun Monaidh, in the town of the king of Scotland,
  


I slept last night,
  


But I be a day in Islay and a day in Cantire,
  


A day in Man and a day in Rathlin,
  


A day in Fionncharn of the watch
  


Upon Slieve Fuaid.
  


A little miserable traveller I,
  


And in Aileach of the kings was I born.
  


And that,’ said he, ‘is my story.’


Again, whenever the kerne plays his harp the Highlander says:—
  


‘He could play tunes and *oirts* and *orgain*,
  


Trampling things, tightening strings,
  


Warriors, heroes, and ghosts on their feet,
  


Ghosts and souls and sickness and fever,
  



---

p.xxvii



 

That would set in sound lasting sleep
  


The whole great world,
  


With the sweetness of the calming[8](javascript:footNote('G307006/note008.html')) tunes
  


That the champion would play.’


The Irish run is as follows:—
  


‘The kerne played music and tunes and instruments of song,
  


Wounded men and women with babes,
  


And slashed heroes and mangled warriors,
  


And all the wounded and all the sick,
  


And the bitterly-wounded of the great world,
  


They would sleep with the voice of the music,
  


Ever efficacious, ever sweet, which the kerne played.’


Again, when the kerne approaches anyone, his gait is thus described half-rhythmically by the Scotch narrator:—‘A young chap was seen coming towards them, his two shoulders through his old coat, his two ears through his old hat, his two squat kickering tatter-y shoes full of cold roadway-ish water, three feet of his sword sideways in the side of his haunch after the scabbard was ended.’


The Irish writer makes him come thus:—‘And he beheld the slender grey kerne approaching him straight, and half his sword bared behind his haunch, and old shoes full of water sousing about him, and the top of his ears out through his old mantle, and a short butt-burned javelin of holly in his hand.’


These few specimens, which could be largely multiplied, 



---

p.xxix






may be sufficient for our purpose, as they show that wherever a run occurs in the Irish the same occurs in the Gaelic, but couched in quite different language, though preserving a general similarity of meaning. This can only be accounted for on the supposition already made, that when a professional bard had invented a successful story it was not there and then committed to paper, but circulated viva voce, until it became the property of every story-teller, and was made part of the stock-in-trade of professional *filès*, who neither remembered nor cared to remember the words in which the story was first told, but only the incidents of which it was composed, and who (as their professional training enabled them to do) invented or extemporised glowing alliterative runs for themselves at every point of the story where, according to the inventor of it, a run should be.


It may be interesting to note that this particular story cannot—at least in the form in which we find it disseminated both in Ireland and Scotland—be older than the year 1362, in which year O'Connor Sligo marched into Munster and carried off great spoil, for in both the Scotch and Irish versions the kerne is made to accompany that chieftain, and to disappear in disgust because O'Connor forgot to offer him the first drink. This story then, and it is probably typical of a great many others, had its rise in its present shape—for, of course, the germ 





---

p.xxx




of it may be much older—on Irish ground, not earlier than the end of the fourteenth or the beginning of the fifteenth century, and was carried by some Irish bard or professional story-teller to the Gaeldom of Scotland, where it is told to this day without any great variations, but in a form very much stunted and shortened. As to the Irish copy, I imagine that it was not written down for a couple of centuries later, and only after it had become a stock piece all over the Scotch and Irish Gaeldom; that then some scribe got hold of a story-teller (one of those professionals who, according to the Book of Leinster, were obliged to know seven times fifty stories), and stereotyped in writing the current Irish variation of the tale, just as **Campbell**, two, three, or four centuries afterwards, did with the Scotch Gaelic version.


It may, of course, be alleged that the bombastic and inflated language of many of the MS. stories is due not to the oral reciter, but to the scribe, who, in his pride of learning, thought to himself, ‘nihil quod tango non orno’; but though it is possible that some scribes threw in extraneous embellishments, I think the story-teller was the chief transgressor. Here, for instance, is a verbally collected specimen from a Connemara story, which contains all the marks of the MS. stories, and yet it is almost certain that it has been transmitted purely viva voce:—'‘They journeyed to the harbour where there was a vessel waiting to take them across the sea. They





---

p.xxxi




struck into her, and hung up the great blowing, bellying, equal-long, equal-straight sails, to the tops of the masts, so that they would not leave a rope without straining, or an oar without breaking, plowing the seething, surging sea; great whales making fairy music and service for them, two-thirds going beneath the wave to the one-third going on the top, sending the smooth sand down below and the rough sand up above, and the eels in grips with one another, until they grated on port and harbour in the Eastern world.’ This description is probably nothing to the glowing language which a professional story-teller, with a trained ear, enormous vocabulary, and complete command of the language, would have employed a couple of hundred years ago. When such popular traces of the inflated style even still exist, it is against all evidence to accredit the invention and propagation of it to the scribes alone.


The relationship between Ireland and the Scottish Gaeldom was of the closest kind, and there must have been something like an identity of literature, nor was there any break in the continuity of these friendly relations until the plantation of Ulster cut off the high road between the two Gaelic families. Even during the fifteenth and sixteenth centuries it is probable that no sooner did a bardic composition win fame in Ireland than it was carried over to try its fortune in Scotland too, just as an English dramatic company will come over from London

 



---

p.xxxii



 

to Dublin. A story which throws great light on the dispersion of heroic tales amongst the Gaelic-speaking peoples, is Conall Gulban, the longest of all **Campbell**'s tales. On comparing the Highland version with an Irish MS., by **Father Manus O'Donnell**, made in 1708, and another made about the beginning of this century, by **Michael O'Longan**, of Carricknavar, I was surprised to find incident following incident with wonderful regularity in both versions. Luckily we have proximate data for fixing the date of this renowned story, a story that, according to **Campbell**, is ‘very widely spread in Scotland, from Beaulay on the east, to Barra on the west, and Dunoon and Paisley in the south.’ Both the Irish and Gaelic stories relate the exploits of the fifth century chieftain, Conall Gulban, the son of Niall of the Nine Hostages, and his wars with (amongst others) the Turks. The Irish story begins with an account of Niall holding his court, when a herald from the Emperor of Constantinople comes forward and summons him to join the army of the emperor, and assist in putting down Christianity, and making the nations of Europe embrace the Turkish faith. We may fairly surmise that this romance took its rise in the shock given to Europe by the fall of Constantinople and the career of Mahomet the Great. This would throw back its date to the latter end of the fifteenth century at the earliest; but one might almost suppose that Constantinople had been long enough held 





---

p.xxxiii



 

by the Turks at the time the romance was invented to make the inventor suppose that it had always belonged to them, even in the time of Niall of the Nine Hostages.[9](javascript:footNote('G307006/note009.html')) We know that romances of this kind continued to be invented at a much later date, but I fancy none of these ever penetrated to Scotland. One of the most popular of romantic tales with the scribes of the last century and the first half of this, was The Adventures of Torolbh Mac Stairn, and again, the Adventures of Torolbh MacStairn's Three Sons, which most of the MSS. ascribe to **Michael Coiminn**, who lived at the beginning of the eighteenth century,[10](javascript:footNote('G307006/note010.html')) and whose romance was certainly not propagated by professional story-tellers, as I have tried to prove was the case with the earlier romances, but by means of numerous manuscript copies; and it is also certain that Coiminn did not relate this tale as the old bards did, but 





---

p.xxxiv



 

wrote it down as modern novelists do their stories. But this does not invalidate my surmise, or prove that Conall Gulban, and forty or fifty of the same kind, had their origin in a written manuscript; it only proves that in the eighteenth century the old order was giving place to the new, and that the professional bards and story-tellers were now a thing of the past, they having fallen with the Gaelic nobility who were their patrons. It would be exceedingly interesting to know whether any traces of these modern stories that had their rise in written manuscripts, are to be found amongst the peasantry as folklore. I, certainly, have found no remnant of any such; but this proves nothing. If Ireland had a few individual workers scattered over the provinces we would know more on the subject; but, unfortunately, we have hardly any such people, and what is worse, the present current of political thought, and the tone of our Irish educational establishments are not likely to produce them. Until something has been done by us to collect Irish folk-lore in as thorough a manner as Highland tales have already been collected, no deductions can be made with certainty upon the subject of the relationship between Highland and Irish folk-tales, and the relation of both to the Irish MSS.


Irish folk-stories may roughly be divided into two classes, those which I believe never had any *conscious* genesis inside the shores of Ireland, and those which 





---

p.xxxv




had. These last we have just been examining. Most of the longer tales about the Fenians, and all those stories which have long inflated passages full of alliterative words and poetic epithets, belong to this class. Under the other head of stories that were never consciously invented on Irish ground, we may place all such simple stories as bear a trace of nature myths, and those which appear to belong to our old Aryan heritage, from the fact of their having parallels amongst other Aryan-speaking races, such as the story of the man who wanted to learn to shake with fear, stories of animals and talking birds, of giants and wizards, and others whose directness and simplicity show them to have had an unconscious and popular origin, though some of these may, of course, have arisen on Irish soil. To this second class belong also that numerous body of traditions rather than tales, of conversational anecdotes rather than set stories, about appearances of fairies, or ‘good people’, or Tuatha De Danann, as they are also called; of pookas, leprechauns, ghosts, apparitions, water-horses, &c. These creations of folk-fancy seldom appear, as far as I have observed, in the folktale proper, or at least they only appear as adjuncts, for in almost all cases the interest of these regular tales centres round a human hero. Stories about leprechauns, fairies, &c., are very brief, and generally have local names and scenery attached to them, and are told conversationally as any other occurrence might be 





---

p.xxxvi



 

told, whereas there is a certain solemnity about the repetition of a folk-tale proper.


After spending so much time over the very latest folk-tales, the detritus of bardic stories, it will be well to cast a glance at some of the most ancient, such as bear their pre-historic origin upon their face. Some of these point, beyond all doubt, to rude efforts on the part of primitive man to realize to himself the phenomena of nature, by personifying them, and attaching to them explanatory fables. Let us take a specimen from a story I found in Mayo, not given in this volume— The Boy who was long on his Mother.[11](javascript:footNote('G307006/note011.html')) In this story, which in **Von Hahn**'s classification would come under the heading of ‘the strong man his adventures’, the hero is a veritable Hercules, whom the king tries to put to death by making him perform impossible tasks, amongst other things, by sending him down to hell to drive up the spirits with his club. He is desired by the king to drain a lake full of water. The lake is very steep on one side like a reservoir. The hero makes a hole at this side, applies his mouth to it, and sucks down the water of the lake, with boats, fishes, and everything else it contained, leaving the lake ‘chomh tirim le bois do láimhe’, ‘as dry as the palm of your hand.’ Even a sceptic will be likely to confess that this tale (which has otherwise no meaning)





---

p.xxxvii



 

is the remains of a (probably Aryan) sun-myth, and personifies the action of the warm sun in drying-up a lake and making it a marsh, killing the fishes, and leaving the boats stranded. But this story, like many others, is suggestive of more than this, since it would supply an argument for those who, like Professor Rhys, see in Hercules a sun-god. The descent of our hero into hell, and his frightening the spirits with his club, the impossible tasks which the king gives him to perform in the hopes of slaying him, and his successful accomplishment of them, seem to identify him with the classic Hercules. But the Irish tradition preserves the incident of drying the lake, which must have been the work of a sun-god, the very thing that Hercules—but on much slighter grounds— is supposed to have been.[12](javascript:footNote('G307006/note012.html')) If this story is not the remains of a nature myth, it is perfectly unintelligible, for no rational person could hope to impose upon even a child by saying that a man drank up a lake, ships, and all; and yet this story has been with strange conservatism repeated from father to son for probably thousands of years, and must have taken its rise at a time when our ancestors were in much the same rude and mindless





---

p.xxxviii



 

condition as the Australian blacks or the Indians of California are to-day.


Again, in another story we hear of a boat that sails equally swiftly over land and sea, and goes straight to its mark. It is so large that if all the men in the world were to enter it there would remain place for six hundred more; while it is so small that it folds up into the hand of the person who has it. But ships do not sail on land, nor grow large and small, nor go straight to their mark; consequently, it is plain that we have here another nature myth, vastly old, invented by pre-historic man, for these ships can be nothing but the clouds which sail over land and sea, are large enough to hold the largest armies, and small enough to fold into the hand, and which go straight to their mark. The meaning of this has been forgotten for countless ages, but the story has survived. Again, in another tale which I found, called The Bird of Sweet Music,[13](javascript:footNote('G307006/note013.html')) a man follows a sweet singing bird into a cave under the ground, and finds a country where he wanders for a year and a day, and a woman who befriends him while there, and enables him to bring back the bird, which turns out to be a human being. At the end of the tale the narrator mentions quite casually that it was his mother whom he met down there.





---

p.xxxix



 

But this touch shows that the land where he wandered was the Celtic Hades, the country of the dead beneath the ground, and seems to stamp the tale at once as at least pre-Christian.


Even in such an unpretending-looking story as The King of Ireland's Son (the third in this volume), there are elements which must be vastly old. In a short Czech story, George with the Goat, we find some of the prince's companions figuring, only slightly metamorphosed. We have the man with one foot over his shoulder, who jumps a hundred miles when he puts it down; while the gun-man of the Irish story who performs two parts—that of seeing and shooting—is replaced in the Bohemian tale by two different men, one of whom has such sight that he must keep a bandage over his eyes, for it he removed it he could see a hundred miles, and the other has, instead of a gun, a bottle with his thumb stuck into it for a stopper, because if he took it out it would squirt a hundred miles. George hires one after the other, just as the prince does in the Irish story. George goes to try to win the king's daughter, as the Irish prince does, and, amongst other things, is desired to bring a goblet of water from a well a hundred miles off in a minute. ‘So,’ says the story,[14](javascript:footNote('G307006/note014.html')) ‘George said to the man who had the foot on his





---

p.xl



 

shoulder, ‘You said that if you took the foot down you could jump a hundred miles.’ He replied: ‘I'll easily do that.’ He took the foot down, jumped, and was there; but after this there was only a very little time to spare, and by this he ought to have been back. So George said to the second. ‘You said that if you removed the bandage from your eyes you could see a hundred miles; peep, and see what is going on.’ ‘Ah, sir, goodness gracious! he's fallen asleep.’ ‘That will be a bad job,’ said George; ‘the time will be up. You third man, you said if you pulled your thumb out you could squirt a hundred miles. Be quick, and squirt thither, that he may get up; and you, look whether he is moving, or what.’ ‘Oh, sir, he's getting up now; he's knocking the dust off; he's drawing the water.’ He then gave a jump, and was there exactly in time.’ Now, this Bohemian story seems also to bear traces of a nature myth; for, as **Mr. Wratislaw** has remarked: ‘the man who jumps a hundred miles appears to be the rainbow, the man with bandaged eyes the lightning, and the man with the bottle the cloud.’ The Irish story, while in every other way superior to the Bohemian, has quite obscured this point; and were it not for the striking Sclavonic parallel, people might be found to assert that the story was of recent origin. This discovery of the Czech tale, however, throws it at once three thousand years back; for the similarity of the Irish and Bohemian 





---

p.xli



 

Story can hardly be accounted for, except on the supposition, that both Slavs and Celts carried it from the original home of the Aryan race, in pre-historic times, or at least from some place where the two races were in contiguity with one another, and that it, too—little as it appears so now—was at one time in all probability a nature myth.


Such myth stories as these ought to be preserved, since they are about the last visible link connecting civilized with pre-historic man; for, of all the traces that man in his earliest period has left behind him, there is nothing except a few drilled stones or flint arrowheads that approaches the antiquity of these tales, as told to-day by a half-starving peasant in a smoky Connacht cabin.


It is time to say a word about the narrators of these stories. The people who can recite them are, as far as my researches have gone, to be found only amongst the oldest, most neglected, and poorest of the Irish-speaking population. English-speaking people either do not know them at all, or else tell them in so bald and condensed a form as to be useless. Almost all the men from whom I used to hear stories in the County Roscommon are dead. Ten or fifteen years ago I used to hear a great many stories, but I did not understand their value. Now when I go back for them I cannot find them. They have died out, and will never again be 





---

p.xlii



 

heard on the hillsides, where they probably existed for a couple of thousand years; they will never be repeated there again, to use the Irish phrase, while grass grows or water runs. Several of these stories I got from an old man, one **Shawn Cunningham**, on the border of the County Roscommon, where it joins Mayo. He never spoke more than a few words of English till he was fifteen years old. He was taught by a hedge schoolmaster from the South of Ireland out of Irish MSS. As far as I could make out from him the teaching seemed to consist in making him learn Irish poems by heart. His next schoolmaster, however, tied a piece of stick round his neck, and when he came to school in the morning the schoolmaster used to inspect the piece of wood and pretend that it told him how often he had spoken Irish when at home. In some cases the schoolmasters made the parents put a notch in the stick every time the child failed to speak English. He was beaten then, and always beaten whenever he was heard speaking a word of Irish, even though at this time he could hardly speak a word of English. His son and daughter now speak Irish, though not fluently, his grandchildren do not even understand it. He had at one time, as he expressed it, ‘the full of a sack of stories,’ but he had forgotten them. His grandchildren stood by his knee while he told me one or two, but it was evident they did not understand a word. His son and daughter laughed at them as nonsense. 





---

p.xliii



 

Even in Achill where, if anywhere, one ought to find folk-stories in their purity, a fine-looking dark man of about forty-five, who told me a number of them, and could repeat Ossian's poems, assured me that now-a-days when he went into a house in the evening and the old people got him to recite, the boys would go out; ‘they wouldn't understand me,’ said he, ‘and when they wouldn't, they'd sooner be listening to ‘géimneach na mbó,’ ‘the lowing of the cows.’’ This, too, in an island where many people cannot speak English. I do not know whether the Achill schoolmasters make use of the notch of wood to-day, but it is hardly wanted now. It is curious that this was the device universally employed all over Connacht and Munster to kill the language. This took place under the eye of **O'Connell** and the Parliamentarians, and, of course, under the eye and with the sanction of the Catholic priesthood and prelates, some of whom, according to Father Keegan, of St. Louis, distinguished themselves by driving the Irish teachers out of their dioceses and burning their books. At the present day, such is the irony of fate, if a stranger talks Irish he runs a good chance of being looked upon as an enemy, this because some attempts were made to proselytize ‘natives’ by circulating Irish bibles, and sending some Irish scripture-readers amongst them. Surely nothing so exquisitely ludicrous ever took place outside of this island of anomalies, as that a 





---

p.xliv



 

Stranger who tries to speak Irish in Ireland runs the serious risk of being looked upon a proselytizing Englishman. As matters are still progressing gaily in this direction, let nobody be surprised if a pure Aryan language which, at the time of the famine, in '47, was spoken at least four million souls (more than the whole population of Switzerland), becomes in a few years as extinct as Cornish. Of course, there is not a shadow of necessity, either social or economical, for this. All the world knows that bi-linguists are superior to men who know only one language, yet in Ireland everyone pretends to believe the contrary, A few words from the influential leaders of the race when next they visit Achill, for instance, would help to keep Irish alive there in saecula saeculorum, and with the Irish language, the old Aryan folk-lore, the Ossianic poems, numberless ballads, folk-songs, and proverbs, and a thousand and one other interesting things that survive when Irish is spoken, and die when it dies. But, from a complexity of causes which I am afraid to explain, the men who for the last sixty years have had the ear of the Irish race have persistently shown the cold shoulder to everything that was Irish and racial, and while protesting, or pretending to protest, against West Britonism, have helped, more than anyone else, by their example, to assimilate us to England and the English, thus running counter to the entire voice of modern Europe, which is in favour of extracting the best 





---

p.xlv




from the various races of men who inhabit it, by helping them to develop themselves on national and racial lines. The people are not the better for it either, for one would fancy it required little culture to see that the man who reads Irish MSS., and repeats Ossianic poetry, is a higher and more interesting type than the man whose mental training is confined to spelling through an article in United Ireland.[15](javascript:footNote('G307006/note015.html'))


---

p.xlvi


 I may mention here that it is not as easy a thing as might be imagined to collect Irish stories. One hears that tales are to be had from such and such a man, generally, alas! a very old one. With difficulty one manages to find him out, only to discover, probably, that he has some work on hand. If it happens to be harvest time it is nearly useless going to him at all, unless one 

 



---

p.xlvi



 

is prepared to sit up with him all night, for his mind is sure to be so distraught with harvest operations that he can tell you nothing. If it is winter time, however, and you fortunately find him unoccupied, nevertheless it requires some management to get him to tell his stories. Half a glass of ishka-baha, a pipe of tobacco, and a story of one's own are the best things to begin with. If, however, you start to take down the story verbatim with pencil and paper, as an unwary collector might do, you destroy all, or your shanachie becomes irritable. He will not wait for you to write down your sentence, and if you call out, ‘Stop, stop, wait till I get this down,’ he will forget what he was going to tell you, and you will not get a third of his story, though you may think you have it all. What you must generally do is to sit quietly smoking 

 



---

p.xlvii



 

your pipe, without the slightest interruption, not even when he comes to words and phrases which you do not understand. He must be allowed his own way to the end, and then after judiciously praising him and discussing the story, you remark, as if the thought had suddenly struck you, ‘budh mhaith liom sin a bheith agam air pháipeur,’ ‘I'd like to have that on paper.’ Then you can get it from him easily enough, and when he leaves out whole incidents, as he is sure to do, you who have just heard the story can put him right, and so get it from him nearly in its entirety. Still it is not always easy to write down these stories, for they are full of old or corrupted words, which neither you nor your narrator understand, and if you press him too much over the meaning of these he gets confused and irritable.


The present volume consists of about half the stories in the Leabhar Sgeulaigheachta, translated into English, together with some half dozen other stories given in the original together with a close English translation. It is not very easy to make a good translation from Irish into English, for there are no two Aryan languages more opposed to each other in spirit and idiom. Still, the English spoken by three-fourths of the people of Ireland is largely influenced by Gaelic idioms, for most of those expressions which surprise Englishmen are really translations from that Irish which was the language of the 





---

p.xlviii



 

speaker's father, grandfather, or great-grandfather—according to the part of the country you may be in—and there have perpetuated themselves, even in districts where you will scarce find a trace of an Irish word. There are, however, also hundreds of Gaelic idioms not reproduced in the English spoken by the people, and it is difficult to render these fitly. **Campbell** of Islay has run into rather an extreme in his translations, for in order to make them picturesque, he has rendered his Gaelic originals something too literally. Thus, he invariably translates bhain se an ceann deth, by ‘he reaped the head off him,’ a form of speech which, I notice, a modern Irish poet and M.P. has adopted from him; but bain, though it certainly means ‘reap’ amongst other things, is the word used for taking off a hat as well as a head. Again, he always translates thu by ‘thou,’ which gives his stories a strange antique air, which is partly artificial, for the Gaelic ‘thou’ corresponds to the English ‘you,’ the second person plural not being used except in speaking of more than one. In this way, **Campbell** has given his excellent and thoroughly reliable translations a scarcely legitimate colouring, which I have tried to avoid. For this reason, I have not always translated the Irish idioms quite literally, though I have used much unidiomatic English, but only of the kind used all over Ireland, the kind the people themselves use. I do not translate, for instance, the Irish for ‘he died,’ by 





---

p.xlix



 

‘he got death,’ for this, though the literal translation, is not adopted into Hibernian English; but I do translate the Irish ghnidheadh se sin by ‘he used to do that,’ which is the ordinary Anglo-Irish attempt at making what they have not got in English—a consuetudinal tense. I have scarcely used the pluperfect at all. No such tense exists in Irish, and the people who speak English do not seem to feel the want of it, and make no hesitation in saying, ‘I'd speak sooner if I knew that,’ where they mean, ‘if I had known that I would have spoken sooner.’ I do not translate (as **Campbell** would), ‘it rose with me to do it,’ but ‘I succeeded in doing it;’ for the first, though the literal translation of the Irish idiom, has not been adopted into English; but I do translate ‘he did it and he drunk,’ instead of, ‘he did it while he was drunk;’ for the first phrase (the literal translation of the Irish) is universally used throughout English-speaking Ireland. Where, as sometimes happens, the English language contains no exact equivalent for an Irish expression, I have rendered the original as well as I could, as one generally does render for linguistic purposes, from one language into another.


In conclusion, it only remains for me to thank **Mr. Alfred Nutt** for enriching this book as he has done, and for bearing with the dilatoriness of the Irish printers, who find so much difficulty in setting Irish type, that 





---

p.l



 

many good Irishmen have of late come round to the idea of printing our language in Roman characters; and to express my gratitude to **Father Eugene O'Growney** for the unwearying kindness with which he read and corrected my Irish proofs, and for the manifold aid which he has afforded me on this and other occasions.




---

p.li


### Postscript by Alfred Nutt


I had hoped to accompany these tales with as full a commentary as that which I have affixed to the Argyllshire Märchen, collected and translated by the Rev. D. MacInnes. Considerations of business and health prevent me from carrying out this intention, and I have only been able to notice a passage here and there in the Tales; but I have gladly availed myself of my friend, **Dr. Hyde**'s permission, to touch upon a few points in his Introduction.


Of special interest are **Dr. Hyde**'s remarks upon the relations which obtain between the modern folk-tale current among the Gaelic-speaking populations of Ireland and Scotland, and the Irish mythic, heroic, and romantic literature preserved in MSS., which range in date from the eleventh century to the present day.


In Ireland, more than elsewhere, the line of demarcation between the tale whose genesis is conscious, and that of which the reverse is true, is hard to draw, and students will, for a long while to come, differ concerning points of detail. I may thus be permitted to disagree at times with **Dr. Hyde**, although, as a rule, I am heartily at one with him.


**Dr. Hyde** distinguishes between an older stratum of folk-tale (the ‘old Aryan traditions’, of p. xix.) and the newer stratum of ‘bardic inventions.’ He also establishes a yet younger class than these latter, the romances of the professional story-tellers of the eighteenth century, who ‘wrote them down as modern novelists do their stories.’ Of these last he remarks (p. xxxiv.), that he has found no remnant of them among the peasantry of to-day; a valuable bit of evidences, although, of course, subject to the inconclusiveness of all merely negative testimony. To revert to the second class, he looks upon the tales comprised in it as being rather the inventions of individual brains than as old Aryan folk-tales (p. xx.) It must at once be conceded, that a great number of the tales and ballads current in the Gaelic-speaking lands undoubtedly received the form under which they are now current, somewhere between the twelfth and the sixteenth centuries; that the authors of that form were equally





---

p.lii




undoubtedly the professional bards and story-tellers attached to the court of every Gaelic chieftain; and that the method of their transmission was oral, it being the custom of the story-tellers both to teach their tales to pupils, and to travel about from district to district.


The style of these stories and ballads enables us to date them with sufficient precision. **Dr. Hyde** also notes historical allusions, such as the reference to O'Connor Sligo, in the story of the Slim Swarthy Champion, or to the Turks in the story of Conall Gulban. I cannot but think, however, that it is straining the evidence to assert that the one story was invented after 1362, or the other after the fall of Constantinople. The fact that ‘Bony’ appears in some versions of the common English mumming play does not show that it originated in this century, merely that these particular versions have passed through the minds of nineteenth century peasants; and in like manner the Connaught fourteenth century chieftain may easily have taken the place of an earlier personage, the Turks in Conall Gulban, of an earlier wizard-giant race. If I cannot go as far as **Dr. Hyde** in this sense, I must equally demur to the assumption (p. xl.), that community of incident between an Irish and a Bohemian tale necessarily establishes the pre-historic antiquity of the incident. I believe that a great many folk-tales, as well as much else of folk-lore, has been developed in situ, rather imported from the outside; but I, by no means, deny importation in principle, and I recognise that its agency has been clearly demonstrated in not a few cases.


The main interest of Irish folk-literature (if the expression be allowed) centres in the bardic stories. I think that **Dr. Hyde** lays too much stress upon such external secondary matters as the names of heroes, or allusions to historical events; and, indeed, he himself, in the case of Murachaidh MacBrian, states what I believe to be the correct theory, namely, that the Irish bardic story, from which he derives the Scotch Gaelic one, is, as far as many of its incidents go, not the invention of the writer, but genuine folk-lore thrown by him into a new form (p. xxii.)


Had we all the materials necessary for forming a judgment, such is, I believe, the conclusion that would in every case be reached. But I furthermore hold it likely that in many cases the recast story gradually reverted

to a primitive folk-type in the course of passing down from the court storyteller to the humbler peasant reciters, that it sloughed off the embellishments of the **ollamhs**, and reintroduced the older, wilder conceptions with which the folk remained in fuller sympathy than the more cultured bard. Compare, for instance, as I compared ten years ago, Maghach Colgar, in **Campbell**'s version (No. 36), with the Fairy Palace of the Quicken Trees. The one tale has all the incidents in the wildest and most fantastic form possible; in the other they are rationalised to the utmost possible extent





---

p.liii




and made to appear like a piece of genuine history. I do not think that if this later version was invented right out by a thirteenth or fourteenth century **ollamh**, it could have given rise to the former one. Either Maghach Colgar descends from the folk-tale which served as the basis of the Irish story, or, what s more likely, the folk, whilst appreciating and preserving the new arrangement of certain well-known incidents, retained the earlier form of the incidents themselves, as being more consonant with the totality of its conceptions, both moral and aesthetic. This I hold to be the vital lesson the *folklorist* may learn from considering the relations of Gaelic folk-tale and Gaelic romance (using the latter term in the sense of story with a conscious genesis): that romance, to live and propagate itself among the folk, must follow certain rules, satisfy certain conceptions of life, conform to certain conventions. The Irish bards and story-tellers had little difficulty, I take it, in doing this; they had not outgrown the creed of their countrymen, they were in substantial touch with the intellectual and artistic laws that govern their subject-matter. Re-arrange, rationalise somewhat, deck out with the questionable adornment of their scanty and ill-digested book-learning—to this extent, but to this extent only, I believe, reached their influence upon the mass of folk-conceptions and presentments which they inherited from their fathers, and which, with these modifications and additions, they handed on to their children.


But romance must not only conform to the conventions, it must also fit in with the *ensemble* of conditions, material, mental and spiritual, which constitute the culture (taking this much-abused word in its widest sense) of a race. An example will make this clear.


Of all modern, consciously-invented fairy tales I know but one which conforms fully to the folk-tale convention— The Shaving of Shagpat. It follows the formula as closely and accurately as the best of **Grimm**'s or of **Campbell**'s tales. To divine the nature of a convention, and to use its capabilities to the utmost, is a special mark of genius, and in this, as in other instances, whatever else be absent from **Mr. Meredith**'s work, genius is indubitably present. But I do not think that The Shaving of Shagpat could ever be acclimatised as a folk-tale in this country. Scenery, conduct of story, characterisation of personages, are all too distinctively Oriental. But let an Eastern admirer of **Mr. Meredith** translate his work into Arabic or Hindi, and let the book fall into the hands of a Cairene or Delhi story-teller (if such still exist), I can well imagine that, with judicious cuts, it should win praise for its reciter in market-place or bazaar. Did this happen, it would surely be due to the fact that the story is strictly constructed upon traditional lines, rather than to the brilliant invention and fancy displayed on every page. Strip from it the wit and philosophy of the author,





---

p.liv




and there remains a fairy tale to charm the East; but it would need to be reduced to a skeleton, and reclothed with new flesh before it could charm the folk of the West.


To bring home yet more clearly to our minds this necessity for romance to conform to convention, let us ask ourselves, what would have happened if one of the Irish story-tellers who perambulated the Western Isles as late as the seventeenth century, had carried with him a volume of Hakluyt or Purchas, or, supposing one to have lingered enough, Defoe or Gil Blas? Would he have been welcomed when he substituted the new fare for the old tales of Finn and the Fians? and even if welcomed, would he have gained currency for it? Would the seed thus planted have thriven, or would it not rather, fallen upon rocky places, have withered away?


It may, however, be objected that the real difference lies not so much in the subject-matter as in the mode of transmission; and the objection may seem to derive some force from what **Dr. Hyde** notes concerning the prevalence of folk-tales in Wicklow, and the nearer Pale generally, as contrasted with Leitrim, Longford, and Meath (p. xii.). It is difficult to over-estimate the interest and importance of this fact, and there can hardly be a doubt that **Dr. Hyde** has explained it correctly. It may, then, be urged that so long as oral transmission lasts the folk-tale flourishes; and only when the printed work ousts the story-teller is it that the folk-tale dies out. But this reasoning will not hold water. It is absurd to contend that the story-teller had none but a certain class of materials at his disposal till lately. He had the whole realm of intellect and fancy to draw upon; but he, and still more his hearers, knew only one district of that realm; and had it been possible for him to step outside its limits his hearers could not have followed him. I grant folk fancy has shared the fortunes of humanity together with every other manifestation of man's activity, but always within strictly defined limits, to transgress which has always been to forfeit the favour of the folk.


What, then, are the characteristic marks of folk-fancy? The question is of special interest in connection with Gaelic folk-lore. The latter is rich in transitional forms, the study of which reveal more clearly than is otherwise possible the nature and workings of the folk-mind.


The products of folk-fancy (putting aside such examples of folk-wisdom and folk-wit as proverbs, saws, jests, etc.), may be roughly divided among two great classes:
  


Firstly, stories of a quasi-historical or anecdotic nature, accepted as actual fact (of course with varying degrees of credence) by narrator and hearer. Stories of this kind are very largely concerned with beings (supernatural, as we should call them) differing from man, and with their relations to and dealings





---

p.lv




with man. Not infrequently, however, the actors in the stories are wholly human, or human and animal. Gaelic folk-lore is rich in such stories, owing to the extraordinary tenacity of the fairy belief. We can hardly doubt that the Gael, like all other races which have passed through a certain stage of culture, had at one time an organised hierarchy of divine beings. But we have to piece together the Gaelic god-saga out of bare names, mere hints, and stories which have evidently suffered vital change. In the earliest stratum of Gaelic mythic narrative we find beings who at some former time had occupied divine rank, but whose relations to man are substantially, as therein presented, the same as those of the modem fairy to the modem peasant. The chiefs of the **Tuatha de Danann** hanker after earthly maidens; the divine damsels long for and summon to themselves earthly heroes. Though undying, very strong, and very wise, they may be overpowered or outwitted by the mortal hero. As if conscious of some source of weakness we cannot detect, they are anxious, in their internecine struggles, to secure the aid of the sons of men. Small wonder that this belief, which we can follow for at least 1,200 years, should furnish so many elements to the folk-fancy of the Gael.


In stories of the second class the action is relegated to a remote past—once upon a time—or to a distant undefined region, and the narrative is not necessarily accepted as a record of actual fact. Stories of this class, whether in prose or verse, may again be subdivided into—humorous, optimistic, tragic; and with regard to the third sub-division, it should be noted that the stories comprised in it are generally told as having been true once, though not in the immediate tangible sense of stories in the first class.


These different narrative groups share certain characteristics, though in varying proportions.


Firstly, the fondness for and adherence to a comparatively small number of set formulas. This is obviously less marked in stories of the first class, which, as being in the mind of the folk a record of what has actually happened, partake of the diversity of actual life. And yet the most striking similarities occur; such an anecdote, for instance, as that which tells how a supernatural changeling is baffled by a brewery of egg-shells being found from Japan to Brittany.


Secondly, on the moral side, the unquestioning acceptance of fatalism, though not in the sense which the Moslem or the Calvinist would attach to the word. The event is bound to be of a certain nature, provided a certain mode of attaining it be chosen. This comes out well in the large group of stories which tell how a supernatural being helps a mortal to perform certain tasks, as a rule, with some ulterior benefit to itself in view. The most disheartening carelessness and stupidity on the part of the man cannot alter the result; the skill and courage of the supernatural helper are powerless without the mortal co-operation.





---

p.lvi




In what I have termed the tragic stories, this fatalism puts on a moral form, and gives rise to the conception of Nemesis.


Thirdly, on the mental side, animism is prevalent, *i.e.*, the acceptance of a life common to, not alone man and animals, but all manifestations of force. In so far as a distinction is made between the life of man and that of nature at large, it is in favour of the latter, to which more potent energy is ascribed.


Just as stories of the first class are less characterised by adherence to formula, so stories of the humorous group are less *characterised* by fatalism and animism. This is inevitable, as such stories are, as a rule, concerned solely with the relations of man to his fellows.


The most fascinating and perplexing problems are those connected with the groups I have termed optimistic and tragic. To the former belong the almost entirety of such nursery tales as are not humorous in character. ‘They were married and lived happily ever afterwards;’ such is the almost invariable end formula. The hero wins the princess, and the villain is punished.


This feature the nursery tale shares with the god-saga; Zeus confounds the Titans, Apollo slays the Python, Lug overcomes Balor, Indra vanquishes Vritra. There are two apparent exceptions to this rule. The Teutonic god myth is tragic; the Anses are ever under the shadow of the final conflict. This has been explained by the influence of Christian ideas; but although this influence must be unreservedly admitted in certain details of the passing of the gods, yet the fact that the Iranian god-saga is likewise undecided, instead of having a frankly optimistic ending, makes me doubt whether the drawn battle between the powers of good and ill be not a genuine and necessary part of the Teutonic mythology. As is well known, Rydberg has established some striking points of contact between the mythic ideas of Scandinavia and those of Iran.


In striking contradiction to this moral, optimistic tendency are the great heroic sagas. One and all well-nigh are profoundly tragic. The doom of Troy the great, the passing of Arthur, the slaughter of the Nibelungs, the death of Sohrab at his father's hands, Roncevalles, Gabhra, the fratricidal conflict of Cuchullain and Ferdiad, the woes of the house of Atreus; such are but a few examples of the prevailing tone of the hero-tales. Achilles and Siegfried and Cuchullain are slain in the flower of their youth and prowess. Of them, at least, the saying is true, that whom the gods love die young. Why is it not equally true of the prince hero of the fairy tale? Is it that the hero tale associated in the minds of hearers and reciters with men who had actually lived and fought, brought down to earth, so to say, out of the mysterious wonderland in which god and fairy and old time kings have their being, becomes





---

p.lvii




thereby liable to the necessities of death and decay inherent in all human things? Some scholars have a ready answer for this and similar questions. The heroic epos assumed its shape once for all among one special race, and was then passed on to other races who remained faithful to the main lines whilst altering details. If this explanation were true, it would still leave unsolved the problem, why the heroic epos, which for its fashioners and hearers was at once a record of the actual and an exemplar of the ideal, should, among men differing in blood and culture, follow one model, and that a tragic one. Granting that Greek and Teuton and Celt did borrow the tales which they themselves conceived to be very blood and bone of their race, what force compelled them all to borrow one special conception of life and fate?


Such exceptions as there are to the tragic nature of the heroic saga are apparent rather than real. The Odyssey ends happily, like an old-fashioned novel, but **Fénélon** long ago recognised in the Odyssey—‘un amas de contes de vieille.’


Perseus again has the luck of a fairy-tale prince, but then the story of his fortunes is obviously a fairy-tale, with named instead of anonymous personages.


Whilst the fairy-tale is akin in tone to the god saga, the ballad recalls the heroic epos. The vast majority of ballads are tragic. Sir Patrick Spens must drown, and Glasgerion's leman be cheated by the churl; Clerk Saunders comes from the other world, like Helge to Sigrun; Douglas dreams his dreary dream, ‘I saw a dead man win a fight, and that dead man was I.’ The themes of the ballad are the most dire and deadly of human passions; love scorned or betrayed, hate, and revenge. Very seldom, too, do the plots of ballad and **Märchen** cross or overlap. Where this does happen it will, as a rule, be found that both are common descendants of some great saga.


We find such an instance in the Fenian saga, episodes of which have lived on in the Gaelic folk memory in the double form of prose and poetry. But it should be noted that the poetry accentuates the tragic side-—the battle of Gabhra, the death of Diarmaid—whilst the prose takes rather some episode of Finn's youth or manhood, and presents it as a rounded and complete whole, the issue of which is fortunate.


The relations of myth and epos to folk-lore may thus be likened to that of trees to the soil from which they spring, and which they enrich and fertilise by the decay of their leaves and branches which mingle indistinguishably with the original soil. Of this soil, again, rude bricks may be made, and a house built; let the house fall into ruins, and the bricks crumble into dust, it will be hard to discriminate that dust from the parent earth. But raise a house of iron or stone, and, however ruined, its fragments can always be recognised.





---

p.lvii




In the case of the Irish bardic literature the analogy is, I believe, with soil and tree, rather than with soil and edifice.


Reverting once more to the characteristics of folk-fancy, let us note that they appear equally in folk-practice and folk-belief. The tough conservatism of the folk-mind has struck all observers: its adherence to immemorial formulas; its fatalistic acceptance of the mysteries of nature and heredity, coupled with its faith in the efficacy of sympathetic magic; its elaborate system of custom and ritual based upon the idea that between men and the remainder of the universe there is no difference of kind.


A conception of the Cosmos is thus arrived at which, more than any religious creed, fulfils the test of catholicity; literally, and in the fullest significance of the words, it has been held ‘semper, ubique et ab omnibus’. And of this conception of the universe, more universal than any that has as yet swayed the minds of man, it is possible that men now living may see the last flickering remains; it is well-nigh certain that our grandchildren will live in a world out of which it has utterly vanished.


For the *folklorist* the Gospel saying is thus more poignant with meaning than for any other student of man's history—‘the night cometh wherein no man may work.’ Surely, many Irishman will take to heart the example of **Dr. Hyde**, and will go forth to glean what may yet be found of as fair and bounteous a harvest of myth and romance as ever flourished among any race.




---

p.2


An Táiliúr agus na trí Bheithigheach
------------------------------------


Bhí táiliúr aon uair amháin i nGaillimh, agus bhí sé ag fuaigheál eudaigh. Chonnairc sé dreancuid ag éirighe amach as an eudach, agus chaith sé an tsnáthad léithe agus mharbh sé an dreancuid. Dubhairt sé ann sin ‘Nach breágh an gaisgidheach mise nuair a bhí mé ábalta air an dreancuid sin do mharbhadh!’


Dubhairt sé ann sin go gcaithfeadh sé dul go B'l'acliath go cúirt an rígh, go bhfeicfeadh sé an dtiucfadh leis a deunamh. Bhi an chúirt sin 'gá dheunamh le fada, acht an méad dí do ghníthidhe ann san lá do leagaidhe ann san oidhche é, agus níor fheud duine air bith a chur suas mar gheall air sin. 'S iad trí fháthach a thigeadh 'san oidhche a bhidheadh 'gá leagadh. D'imthigh an táiliúr an lá air na mhárach, agus do thug sé leis an uirlis, an spád agus an tsluasad.


Níor bhfada chuaidh sé gur casadh capall bán dó, agus chuir sé forán air. ‘Go mbeannuigh Dia dhuit,’ ar san capall, ‘cá bhfuil tú dul?’ ‘Tá mé dul go B'l'acliath,’ ar san táiliúr, ‘le deunamh cúirte an rígh, go bhfágh' mé bean-uasal, má thig liom a deunamh, mar do gheall an rígh go dtiúbhradh sé a inghean féin agus a lán airgid léithe don té sin a thiucfadh leis an chúirt sin do chur suas.’ ‘An ndeunfá poll dam?’ ar san sean-ghearrán bán, ‘rachainn i bhfolach ann nuair atá na daoine mo thabhairt chum an mhuilinn agus chum an atha i riocht nach bhfeicfidh siad mé, óir tá mé cráidhte aca, ag deunamh oibre dhóibh.’





---

p.4




‘Deunfaidh mé sin go deimhin,’ ar san táiliúr, ‘agus fáilte.’ Thug sé an spád leis agus an tsluasad, agus rinne sé poll, agus dubhairt sé leis an g-capall bán dul síos ann, go bhfeicfeadh sé an bhfóirfeadh sé dhó. Chuaidh an capall bán síos ann san bpoll, acht nuair d'fheuch sé do theacht suas arís as, níor fheud sé.


‘Deun áit dam anois,’ ar san capall bán, ‘a thiucfas mé aníos ar an bpoll so nuair a bhéidheas ocaras orm.’ ‘Ní dheunfad,’ ar san táiliúr, ‘fan ann sin go dtigidh mé air m'ais, agus tógfaidh mé aníos thú.’


D'imthigh an táiliúr an lá air na mhárach, agus casadh dhó an sionnach, ‘Go mbeannuigh Dia dhuit,’ ar san sionnach. ‘Go mbeannuigh Dia 'gus Muire dhuit.’ ‘Cá bhfuil tú dul?’ ‘Tá mé dul go B'l'acliath go bhfeuchaidh mé an dtiucfadh liom cúirt dheunamh do'n rígh.’ ‘An ndeunfá áit dam, a rachfainn i bhfolach innti,’ ar san sionnach, ‘tá an chuid eile de na sionnaighibh do m' bhualadh agus ní leigeann siad dam aon nidh ithe 'nna g-cuideachta.’ ‘Deunfaidh mé sin duit,’ ar san táiliúr. Thug sé leis a thuagh agus a shábh, agus bhain sé slata, go ndearnaigh sé, mar dheurfá, cliabh dhó, agus dubhairt sé leis an tsionnach dul síos ann, go bhfeicfeadh sé an bhfóirfeadh sé dhó. Chuaidh an sionnach ann, agus nuair fuair an tailiúr shíos é, leag sé a thóin air an bpoll a bhí ann. Nuair a bhí an sionnach sásta faoi dheireadh go raibh áit dheas aige d'iarr sé air an táiliúr a leigean amach, agus d'fhreagair an táiliúr nach leigfeadh; ‘Fan ann sin go dtigidh mise air m'ais,’ ar sé.


D'imthigh an táiliúr an lá air na mhárach, agus ní fada bhí sé siúbhal gur casadh madr'-alla dhó, agus chuir an mádr'-alla forán air, agus d'fhiafruigh sé dhé cá raibh sé ag triall. ‘Tá mé dul go B'l'acliath go ndeunfaidh mé cúirt do'n rígh má thig liom sin dheunamh,’ ar san táiliúr. ‘Dá ndeunfá ceucht dam,’ ar san madr'-alla, ‘bheidheadh 





---

p.6




mise agus na madr'-alla eile ag treabhadh agus ag forsadh, go mbeidheadh greim againn le n-ithe ann san bhfóghmhar.’ ‘Deunfaidh mé sin duit,’ ar san táiliúr. Thug sé leis a thuagh 's a shábh, agus rinne sé ceucht. Nuair bhí an ceucht deunta chuir sé poll ann san mbéam *(sail)* agus dubhairt sé leis an madr'-alla dul asteach faoi an g-ceucht go bhfeicfeadh sé an raibh treabhach maith ann. Chuir sé a earball asteach ann san bpoll a rinne sé, agus chuir sé ‘peg’ ann-sin ann, agus níor tháinig leis an madr'-alla a earball tharraing amach as arís. ‘Sgaoil mé anois’ ar san madr'-alla, ‘agus deasóchamaoid féin agus treabhfamaoid.’ Dubhairt an táiliúr nach sgaoilfeadh sé é *nó* go dtiucfadh sé féin air ais. D'fhág sé ann sin é agus chuaidh sé go B'l'acliath.


Nuair tháinig sé go B'l'acliath chuir sé páipeur amach an méad luchd' céirde do bhí ag tógbháil na cúirte do theacht chuige-sean, agus go n-íocfadh seisean iad — — agus ní bhídheadh daoine ag fághail 'san am sin acht píghin 'sa lá. Do chruinnigh a lán luchd céirde an lá air na mhárach, agus thosaigh siad ag obair dó. Bhí siad ag dul a bhaile andhiaigh an laé nuair dubhairt an tailiúr leó ‘an chloch mhór sin do chur suas air bhárr na h-oibre a bhí deunta aige.’ Nuair d'árduigheadh suas an chloch mhór sin, chuir an tailiúr slighe éigin fúithi go leagfadh sé anuas í nuair a thiucfadh an fathach chomh fada léithe. D'imthigh an luchd oibre a bhaile ann sin, agus chuaidh an tailiúr i bhfolach air chúl na cloiche móire. Nuair tháinig dorchadas na h-oidhche chonnairc sé na trí fathaigh ag teacht, agus thosuigh siad ag leagadh na cúirte *nó* go dtáinig siad chomh fada leis an áit a raibh an táiliúr shuas, agus bhuail fear aca buille d'á ord air an áit a raibh sé i bhfolach. Leag an tailiúr an chloch anuas air, agus, thuit sí air, agus mharbh sí é. D'imthigh siad a bhaile ann sin, agus d'fhág siad an méad a bhí ann gan leagan, ó bhí fear aca féin marbh.




---

p.8


Tháinig an lucht céirde arís, an lá air na mhárach, agus bhí siad ag obair go dtí an oidhche, agus nuair a bhí siad dul abhaile dubhairt an tailiúr leó an chloch mhór do chur suas air bhárr na h-oibre mar bhí sí an oidhche roimhe sin. Rinne siad sin dó, agus d'imthigh siad abhaile, agus chuaidh an tailiúr i bhfolach, mar bhí sé an tráthnóna roimhe sin. Nuair bhí na daoine uile imthighthe 'nna suaimhneas, tháinig an dá fhathach, agus bhí siad ag leagan an méid a bhí rompa; agus nuair thosuigh siad, chuir siad dá ghlaodh asta. Bhí an tailiúr air siúbhal agus é ag obair *nó* gur leag sé anuas an chloch mhór gur thuit sí air chloigionn an fhathaigh a bhí fúithi agus mharbh sí é. Ní raibh ann sin acht an t-aon fhathach amháin ann, agus ní tháinig seisean go raibh an chúirt críochnuighthe.


Chuaidh an táiliúr chum an rígh ann sin, agus dubhairt sé leis, a bhean agus a chuid airgid do thabhairt dó, mar do bhí an chúirt déanta aige, acht dubhairt an rígh leis nach dtiúbhradh sé aon bhean dó, *nó* go marbhfadh sé an fathach eile, agus nach dtiúbhradh sé dadamh dó anois *nó* go marbhfadh sé an fear deireannach. Dubhairt an táiliúr ann sin go marbhfadh sé an fathach eile dhó, agus fáilte, nach raibh aon mhaille air bith air sin.


D'imthigh an táiliúr ann sin, go dtáinig sé chum na h-áite a raibh an fathach eile, agus d'fhiafruigh ar theastuigh buachaill uaidh. Dubhairt an fathach gur theastuigh, dá bhfághadh sé buachaill a dheunfadh an rud a dheunfadh sé féin. ‘Rud air bith a dheunfas tusa, deunfaidh mise é,’ ar san táiliúr.


Chuaigh siad chum a ndinéir ann sin, agus nuair bhí sé ithte aca dubhairt an fathach leis an táiliúr an dtiucfadh leis an oiread anbhruith ól agus é féin, aníos as a fhiuchadh. ‘Tiucfaidh,’ ar san táiliúr, ‘acht go dtiúbhraidh tú uair dam sul a thosóchamaoid air.’ ‘Bhéarfaidh mé sin duit,’ ar san fathach. Chuaidh an táiliúr amach ann sin, agus 





---

p.10




fuair sé croicionn caorach agus d'fhuaigh sé suas é, go ndearnaigh sé mála dhé agus dheasuigh sé síos faoi na chóta é. Tháinig sé asteach ann sin, agus dubhairt sé leis an bhfathach galún de'n anbhruith ól i dtosach. D'ól an fathach sin aníos as a fhiuchadh.


‘Deunfaidh mise sin,’ ar *san táiliúr*. Bhí sé air siúbhal gur dhóirt sé asteach san g-croicionn é, agus shaoil an fathach go raibh sé ólta aige. D'ól an fathach galún eile ann sin, agus leig an táiliúr galún eile síos 'san g-croicionn, acht shaoil an fathach, go raibh sé 'gá ól. ‘Déanfaidh mise rud anois nach dtiucfaidh leat-sa dheunamh,’ ar san táiliúr. ‘Ní dhéanfá,’ ar san fathach, ‘creud é sin do dhéanfá?’


‘Poll do dheunamh, agus an t-anbhruith do leigean amach arís,’ ar san táiliúr. ‘Déan thú féin i dtosach é,’ ar san fathach. Thug an táiliúr ‘prad’ de'n sgín, agus leig sé amach an t-anbhruith as an g-croicionn. ‘Déan, thusa, sin,’ ar sé leis an bhfathach. ‘Déanfad,’ ar san fathach ag tabhairt prad de'n sgín 'nna bhuilg féin agus mharbh sé é féin. Sin é an chaoi a mharbh sé an tríomhadh fathach.


Chuaidh sé do'n rígh ann sin, agus dubhairt sé leis, an bhean agus a chuid airgid do chur amach chuige, agus go leagfadh sé an chúirt muna bhfághadh sé an bhean. Bhí faitchios orra ann sin go leagfadh sé an chúirt arís, agus chuir siad an bhean amach chuige.


Nuair bhí sé lá imthighthe, é féin agus a bhean, ghlac siad aithreachas agus lean siad é, go mbainfeadh siad an bhean dé arís. Bhí an mhuinntir do bhí 'nna dhiaigh 'gá leanamhaint *nó* go dtáinig siad suas do'n áit a raibh an madr'-alla, agus dubhairt an madr'-alla leó: ‘Bhí an táiliúr agus a bhean ann so andé, chonnairc mise iad ag dul thart, agus má sgaoileann sibh mise anois tá mé níos luaithe 'ná sibh-se, agus leanfaidh mé iad go mbéarfaidh mé orra.’





---

p.12




Nuair chualaidh siad sin sgaoil siad amach an madr'alla.


D'imthigh an madr'-alla agus muinntir Bh'l'acliath, agus bhí siad dá leanamhaint go dtáinig siad do'n áit a raibh an sionnach, agus chuir an sionnach forán orra, agus dubhairt sé leó, ‘Bhí an táiliúr agus an bhean ann so air mhaidin andiú, agus má sgaoilfidh sibh anois mé tá mé níos luaithe 'ná sibh agus leanfaidh mé iad agus béarfaidh mé orra.’ Sgaoil siad amach an sionnach ann sin.


D'imthigh an madr'-alla agus an sionnach, agus arm Bh'l'acliath ann sin, ag feuchaint an ngabhadh siad an táiliúr, agus tháinig siad do'n áit a raibh an sean-ghearrán bán, agus dubhairt an sean-ghearrán bán leó, go raibh an táiliúr, agus a bhean ann sin air mhaidin, ‘agus sgaoiligidhe amach mé,’ ar sé, ‘tá mé níos luaithe 'ná sibh-se agus béarfaidh mé orra.’ Sgaoil siad amach an sean-ghearrán bán, agus lean an sean-ghearrán bán, an sionnach, an madr'-alla, agus arm Bh'l'acliath an táiliúr 's a bean, i g-cuideacht a chéile, agus níor bhfada go dtáinig siad suas leis an táiliúr, agus chonnairc siad é féin 's a bhean amach rompa.


Nuair chonnairc an táiliúr iad ag tigheacht tháinig sé féin 's a bean amach as an g-cóiste, agus shuidh sé síos air an talamh.


Nuair a chonnairc an sean-ghearrán bán an táiliúr ag suidhe síos dubhairt sé, ‘Sin é an cuma a bhí sé nuair rinne sé an poll damhsa, nár fheud mé teacht amach as nuair chuaidh mé asteach ann; ní rachfaidh mé níos foigse dhó.’


‘Ní h-eadh,’ ar san sionnach, ‘acht is mar sin, do bhí sé nuair bhí sé déanamh an ruid damh-sa, agus ní rachfaidh mise níos foigse dhó.’


‘Ní h-eadh!’ ar san madr'-alla, ‘acht is mar sin do 







---

p.14




bhí sé nuair bhí sé déanamh an cheuchta 'nna raibh mise gabhtha. Ní rachfaidh mise níos foigse dhó.’


D'imthigh siad uile uaidh ann sin, agus d'fhill siad. Tháinig an táiliúr agus a bhean a bhaile go Gaillimh. Thug siad dam stocaidh páipéir agus bróga bainne ramhair — chaill mé iad ó shoin. Fuair siad-san an t-áth agus mise an lochán, báitheadh iad-san agus tháinig mise.


Bran
----


Bhí cú breágh ag Fionn. Sin Bran. Chualaidh tú caint air Bhran. Seó an dath a bí air.




> 1. Cosa buidhe a bhí air Bhran
>   
> Dhá thaoibh dubha agus tárr geal,
>   
> Druim uaine air dhath na seilge
>   
> Dá chluais cruinne cóimh-dhearga.
> 







Bhéarfadh Bran air ria Gaéthibh-fiádhna bhí sí chomh luath sin. 



---

p.16




Nuair bhí sí 'nna coileán d'éirigh imreas *nó* troid éigin ameasg na g-con a bhí ag an bhFéin, agus 




> 1. Trí fiche cú agus fiche coileán
>   
> Mharbh Bran agus í 'nna coileán,
>   
> Dá ghé-fiadháin, agus an oiread leó uile.
> 





'Sé Fionn féin a mharbh Bran. Chuaidh siad amach ag fiadhach agus rinneadh eilit de mháthair Fhinn. Bhí Bran dá tóruigheacht.
  




‘Eilit bhaoth fág air sliabh’ ar Fionn.
  


‘A mhic óig,’ ar sise, ‘Cá rachfaidh mé as?’
  


> 1. Má théidhim ann san bhfairrge síos
>   
> Choidhche ní fhillfinn air m'ais,
>   
> 'S má théidhim ann san aer suas
>   
> Ní bheurfaidh mo luathas air Bhran.
> 




‘Gabh amach eidir mo dhá chois’ ar Fionn. Chuaidh sise amach eidir a dhá chois, agus lean Bran í, agus air ngabhail amach di, d'fháisg Fionn a dhá ghlúin uirri agus mharbh sé í.


Bhí inghean ag Bran. Cú dubh a bhí ann san g-coileán sin, agus thóg na Fianna í, agus dubhairt siad leis an mnaoi a bhí tabhairt aire do'n choileán, bainne bó gan aon bhall do thabhairt do'n choileán, agus gach aon deór do thabhairt dó, agus gan aon bhraon chongbháil uaidh. Ní dhearnaidh an bhean sin, acht chongbhuigh cuid de'n bhainne gan a thabhairt uile do'n choileán. An cheud lá do sgaoil na Fianna an cú óg amach bhí gleann lán de ghéadhaibh fiadháine agus d'eunachaibh eile, agus nuair sgaoileadh an cú dubh 'nna measg, do ghabh sí iad uile acht fíor-bheagán aca a chuaidh amach air bhearna a bhí ann. Agus acht gur chongbhuigh 





---

p.18




an bhean cuid de'n bhainne uaithi do mharbhfadh sí iad uile.


Bhí fear de na Fiannaibh 'nna dhall, agus nuair leigeadh an cú amach d'fhiafruigh sé de na daoinibh a bhí anaice leis, cia an chaoi a rinne an cú óg. Dubhairt siad-san leis gur mharbh an cú óg an meud gé fiadháin agus eun a bhí ann san ngleann, acht beagán aca a chuaidh amach air bhearna, agus go raibh sí teacht a bhaile anois. ‘Dá bhfághadh sí an bainne uile a tháinig de'n bhó gan aon bhall’ ar san dall, ‘Ní leigfeadh sí d'eun air bith imtheacht uaithi,’ agus d'fhafruigh sé, ann sin, cad é an chaoi a raibh sí tígheacht a bhaile. ‘Tá sí teacht anois,’ ar siad ‘agus, sgáil' lasta as a muineul agus i air buile.’


‘Tabhair m'impidhe dham anois,’ ar san dall, ‘agus cuir mé 'mo shuidhe ann san g-cathaoir agus cuir gual ann mo láimh, óir muna marbhaim í anois marbhfaidh sí muid (sinn) uile.’ Tháinig an cú, agus chaith sé an gual léithe agus mharbh sé í, agus é dall.


Acht dá bhfághadh an coileán sin an bainne uile do thiucfadh sí agus luidhfeadh sí síos go socair, mar luidheadh Bran.


Mac Righ Éireann
----------------


Bhí mac rígh i n-Éirinn, fad ó shoin, agus chuaidh sé amach agus thug sé a ghunna 's a mhadadh leis. Bhí sneachta amuigh. Mharbh sé fiach dubh. Thuit an fiach dubh air an tsneachta. Ní fhacaidh sé aon rud budh ghile 'ná an sneachta, 





---

p.20




ná budh dhuibhe 'ná cloigionn an fhiaich dhuibh, ná budh dheirge 'ná a chuid fola bhí 'gá dórtadh amach.


Chuir sé faoi geasaibh agus deimúgh na bliadhna nach n-íosadh sé dhá biadh i n-aon bhord, ná dhá oidhche do chodladh ann aon teach, go bhfághadh sé bean a raibh a cloigionn chomh dubh leis an bhfiach dubh, agus a croicionn chomh geal leis an tsneachta, agus a dhá gruaidh chomh dearg le fuil.


Ní raibh aon bhean ann san domhan mar sin, acht aon bhean amháin a bhí ann san domhan shoir.


Lá air na mhárach ghabh sé amach, agus ní raibh airgiod fairsing, acht thug sé leis fiche púnta. Ní fada chuaidh sé gur casadh socraoid dó, agus dubhairt sé go raibh sé chomh maith dhó trí choiscéim dhul leis an g-corrán. Ní raibh na trí choiscéim siúbhalta aige go dtáinig fear agus leag sé a reasta air an g-corp, air chúig phúnta. Bhí dlígheadh i n-Éirinn an t-am sin, duine air bith a raibh fiacha aige air fhear eile, nach dtiucfadh le muinntir an fhir sin a chur, dá mbeidheadh sé marbh, gan na fiacha d'íoc, *nó* gan cead ó'n duine a raibh na fiacha sin aige air an bhfear marbh. Nuair chonnairc Mac Rígh Éireann mic agus ingheana an duine mhairbh ag caoineadh, agus iad gan an t-airgiod aca le tabhairt do 'n fhear, dubhairt sé leis féin, ‘is mór an truagh é nach bhfuil an t-airgiod ag na daoinibh bochta,’ agus chuir sé a láimh ann a phóca agus d'íoc sé féin na cúig phúnta, air son an chuirp. Dubhairt sé go rachfadh sé chum an teampoill ann sin, go bhfeicfeadh sé curtha é. Tháinig fear eile ann sin, agus leag sé a reasta air an g-corp air son cúig phúnta eile. ‘Mar thug mé na ceud chúig phúnta,’ ar Mac Rígh Éireann leis féin, ‘tá sé chomh maith dham cúig phúnta eile thabhairt anois agus an fear bocht do leigean dul san uaigh,’ D'íoc sé na cúig phúnta eile. Ní raibh aige ann sin acht deich bpúnta.




---

p.22


Níor bhfada chuaidh sé gur casadh fear gearr glas dó agus d'fhiafruigh sé dhé cá raibh sé dul. Dubhairt sé go raibh sé dul ag iarraidh mná 'san domhan shoir. D'fhiafruigh an fear gearr glas dé, an raibh buachaill teastáil uaidh, agus dubhairt sé go raibh, agus cad é an pháidhe bheidheadh sé ag iarraidh. Dubhairt seisean ‘an cheud phóg air a mhnaoi, dá bhfághadh sé í.’ Dubhairt Mac Rígh Éireann go g-caithfeadh sé sin fhághail.


Níor bhfada chuaidh siad gur casadh fear eile dhóibh agus a ghunna ann a láimh, agus é ag ‘leibhléaracht’ air an londubh a bhí thall 'san domhan shoir, go mbeidheadh sé aige le n-aghaidh a dhinéir. Dubhairt an fear gearr glas le Mac Rígh Éireann go raibh sé chomh maith dhó an fear sin ghlacadh air aimsir, dá rachfadh sé air aimsir leis. D'fhiafruigh Mac Rígh Éireann an dtiucfadh sé air aimsir leis.
  




‘Rachfad,’ air san fear, ‘má bhfágh' mé mo thuarastal.’
  




‘Agus cad é an tuarastal bhéidheas tú 'g iarraidh?’
  




‘Áit tighe agus gardha.’
  




‘Gheobhaidh tú sin uaim, má éirigheann mo thuras liom.’


D'imthigh Mac Rígh Éireann leis an bhfear glas agus leis an ngunnaire, agus ní fada chuaidh siad gur casadh fear dóibh, agus a chluas leagtha air an talamh, agus é ag éisteacht leis an bhfeur ag fás.
  


‘Tá sé chomh maith dhuit an fear sin ghlacadh air aimsir,’ ar san fear gearr glas.


D'fhiafruigh Mac Rígh Éireann de'n fhear sin an dtiucfadh sé leis air aimsir.
  


‘Tiucfad má bhfágh mé áit tighe agus gardha.’
  




‘Gheobhaidh tú sin uaim má éirigheann an rud atá ann mo cheann liom.’




---

p.24


Chuaidh Mac Rígh Éireann, an fear gearr glas, an gunnaire, agus an cluasaire, agus ní fada chuaidh siad gur casadh fear eile dhóibh agus a leath-chos air a ghualainn, agus é ag congbháil páirce geirrfhiadh gan aon gheirrfhiadh leigean asteach ná amach. Bhí iongantas air Mhac Rígh Éireann agus d'fhiafruigh sé cad é an chiall a raibh a leath-chos air a ghualainn mar sin.
  




‘O,’ ar seisean, ‘dá mbeidheadh mo dhá chois agam air an talamh bheidhinn chomh luath sin go rachfainn as amharc.’
  




‘An dtiucfaidh tú air aimsir liom?’ ar san Mac Rígh.
  




‘Tiucfad, má bhfágh' mé áit tighe agus gardha.’
  




‘Gheobhaidh tú sin uaim,’ ar Mac Rígh Éireann, ‘má éirigheann an rud atá ann mo cheann liom.’


Chuaidh Mac Rígh Éireann, an fear gearr glas, an gunnaire, an cluasaire, agus an coisire air aghaidh, agus níor bhfada go dtáncadar go fear agus é ag cur muilinn gaoithe thart le na leathpholláire, agus a mheur leagtha aige air a shrón ag druidim na polláire eile.
  




‘Cad chuige bhfuil do mheur agad air do shrón?’ ar Mac Rígh Éireann leis.
  




‘O,’ ar seisean, ‘dá séidfinn as mo dhá pholláire do sguabfainn an muileann amach as sin suas 'san aer.’
  




‘An dtiucfaidh tú air aimsir?’ ar san Mac Rígh.
  




‘Tiucfad, má bhfágh' mé áit tighe agus gardha.’
  
 



‘Gheobhaidh tú sin, má éirigheann an rud atá ann mo cheann liom.’


Chuaidh Mac Rígh Éireann, an fear gearr glas, an gunnaire, an cluasaire, an coisire, agus an séidire go dtángadar go fear a bhí 'nna shuidhe air thaoibh an bhóthair, agus é ag briseadh cloch le na leath-thóin agus ní raibh casúr ná dadamh aige. D'fhiafruigh an Mac Rígh dhé, cad chuige a raibh sé ag briseadh na gcloch le na leath-thóin.
  



---

p.26






‘O,’ ar seisean, ‘dá mbualfainn leis an tóin dhúbalta iad dheunfainn púghdar díobh.’
  




‘An dtiucfaidh tú air aimsir liom?’
  




‘Tiucfad, má bhfágh' mé áit tighe agus gardha.’


D'imthigh siad uile ann sin, Mac Rígh Éireann, an fear gearr glas, an gunnaire, an cluasaire, an coisire, an séidire, agus fear briste na g-cloch le taoibh a thóna agus bheurfadh siad air an ngaoith Mhárta a bhí rompa agus an ghaoth Mhárta a bhí 'nna n-diaigh ní bhéurfadh sí orra-san go dtáinig tráthnóna agus deireadh an laé.


Dhearc Mac Rígh Éireann uaidh agus ní fhacaidh sé aon teach a mbeidheadh sé ann an oidhche sin. Dhearc an fear gearr glas uaidh agus chonnairc sé teach nach raibh bonn cleite amach air, ná bárr cleite asteach air, acht aon chleite amháin a bhí ag congbháil dídinn agus fasgaidh air. Dubhairt mac rígh Éireann nach raibh fhios aige cá chaithfeadh siad an oidhche sin, agus dubhairt an fear gearr glas go mbeidheadh siad i dteach an fhathaigh thall an oidhche sin.


Tháinig siad chum an tighe, agus tharraing an fear gearr glas an cuaille cómhraic agus níor fhág sé leanbh i mnaoi searrach i g-capall, pigín i muic, ná broc i ngleann nár iompuigh sé thart trí uaire iad le méad an torain do bhain sé as an g-cuaille cómhraic. Tháinig an fathach amach agus dubhairt sé ‘mothuighim boladh an Éireannaigh bhinn bhreugaigh faoi m'fhóidín dúthaigh.’
  




‘Ní Éireannach binn breugach mise,’ ar san fear gearr glas, ‘acht tá mo mháighistir amuigh ann sin ag ceann an bhóthair agus má thagann sé bainfidh sé an ceann díot.’ Bhí an fear gearr glas ag meudughadh, agus ag meudughadh go raibh sé faoi dheireadh chomh mór leis an g-caisleán. Bhí faitchios air an bhfathach agus dubhairt sé, ‘Bhfuil do mháighistir chomh mór leat féin?’ 





---

p.28




‘Tá,’ ar san fear gearr glas, ‘agus níos mó.’
  




‘Cuir i bhfolach mé go maidin go n-imthigheann do mháighistir,’ ar san fathach.


Chuir sé an fathach faoi ghlas, ann sin, agus chuaidh sé chum a mháighistir.


Tháinig mac rígh Éireann, an fear gearr glas an gunnaire*,* an cluasaire, an séidire, an coisire, agus fear briste na g-cloch le taoibh a thóna, asteach 'san g-caisleán, agus chaith siad an oidhche sin, trian dí le fiannaigheacht agus trian le sgeuluigheacht, agus trian le soirm sáimh suain agus fíor-chodalta.


Nuair d'éirigh an lá air na mhárach thug sé leis a mháighistir agus an gunnaire, agus an cluasaire, agus an coisire, agus an séidire, agus fear briste na g-cloch le taoibh a thóna, agus d'fhág sé amuigh ag ceann an bhóthair iad, agus tháinig sé féin air ais agus bhain sé an glas de 'n fhathach. Dubhairt sé leis an bhfathach gur chuir a mháighistir air ais é i g-coinne an bhirréid dhuibh a bhí faoi cholbha a leabuidh. Dubhairt an fathach go dtiubhradh sé hata dhó nár chaith sé féin ariamh, acht go raibh náire air, an sean-bhirreud do thabhairt dó. Dubhairt an fear gearr glas muna dtiubhradh sé an birreud dó go dtiucfadh a mháighistir air ais, agus go mbainfeadh sé an ceann dé.


‘Is fearr dam a thabhairt duit,’ ar san fathach, ‘agus uair air bith a chuirfeas tú air do cheann é, feicfidh tú uile dhuine agus ní fheicfidh duine air bith thú.’ Thug sé dhó an birreud ann sin, agus chuaidh an fear gearr glas agus thug sé do mhac rígh Éireann é.


Bhí siad ag imtheacht ann sin. Do bhéarfadh siad air an ngaoith Mhárta do bhí rómpa, agus an ghaoth Mhárta do bhí 'nna ndiaigh ní bhéarfadh sí orra-san, ag dul 





---

p.30




do'n domhan thoir. Nuair tháinig tráthnóna agus deireadh an lae dhearc mac rígh Éireann uaidh agus ní fhacaidh sé aon áit a mbeidheadh sé ann an oidhche sin. Dhearc an fear gearr glas uaidh agus chonnairc sé caisleán, agus dubhairt sé, ‘an fathach atá ann san g-caisleán sin, is dearbhráthair do'n fhathach a rabhamar aréir aige, agus béidhmíd ann san g-caisleán sin anocht.’ Tháinig siad, agus d'fhág sé mac rígh Éireann agus a mhuinntir ag ceann an bhóthair, agus chuaidh sé chum an chaisleáin, agus tharraing sé an cuaille cómhraic agus níor fhág sé leanbh i mnaoi ná searrach i g-capall ná pigín i muic, ná broc i ngleann, i bhfoisge seacht míle dhó, nár bhain sé trí iompódh asta leis an méad torain a thug sé as an g-cuaille cómhraic.


Tháinig an fathach amach, agus dubhairt sé ‘Mothuighim boladh an Éireannaigh bhinn bhreugaigh faoi m'fhóidín dúthaigh.’
  




‘Ní Éireannach binn breugach mise,’ ar san fear gearr glas, ‘acht tá mo mháighistir amuigh ann sin ag ceann an bhóthair agus má thagann sé bainfidh sé an ceann díot.’
  




‘Is mór liom dhe ghreim thú, agus is beag liom de dhá ghreim thú’, ar san fathach.
  
 



‘Ní bhfuighfidh tú mé dhe ghreim air bith,’ ar san fear gearr glas agus thoisigh sé ag meudughadh go raibh sé chomh mór leis an g-caisleán.


Tháinig faitchios air an bhfathach agus dubhairt sé, ‘Bhfuil do mháighistir chomh mór leat-sa?’
  
 



‘Tá agus níos mó,’ ar san fear beag glas.
  




‘Cuir i bhfolach mé go maidin go n-imthigheann do mháighistir,’ ar san fathach, ‘agus rud air bith atá tú ag iarraidh caithfidh tú a fhághail.’


Thug sé an fathach leis, agus chaith sé faoi bheul dabhaich é. Chuaidh sé amach agus thug sé asteach mac rígh Éireann, an gunnaire, an cluasaire, an séidire, an coisire, agus fear briste na g-cloch le taoibh a thóna, agus chaith siad an oidhche ann sin, trian le fiannuigheacht, trian le sgeulaigheacht,





---

p.32




agus trian le soirm sáimh suain agus fíor-chodalta, go dtí an mhaidin.


Air maidin, lá air na mhárach, thug an fear gearr glas mac rígh Éireann agus a mhuinntir amach as an g-caisleán agus d'fhág sé ag ceann an bhóthair iad, agus tháinig sé féin air ais agus d'iarr sé na sean-slipéaraidh a bhí faoi colba an leabuidh, air an bhfathach. Dubhairt an fathach go dtiúbhradh sé péire bhútais chomh maith agus chaith sé ariamh d'a mháighistir, agus cad é an maith a bhí ann sna sean-slipéaraibh! Dubhairt an fear gearr glas muna bhfághadh sé na slipeuraidh go rachfadh sé i g-coinne a mháighistir, leis an ceann do bhaint de. Dubhairt an fathach ann sin go dtiubhradh sé dhó iad, agus thug. ‘Am air bith,’ ar seisean, ‘a chuirfeas tú na slipeuraidh sin ort, agus ‘haigh óibhir’ do rádh, áit air bith a bhfuil súil agad do dhul ann, béidh tú innti.’


D'imthigh mac rígh Éireann agus an fear gearr glas, agus an gunnaire, agus an cluasaire, agus an coisire agus an séidire, agus fear briste na g-cloch le taoibh a thóna, go dtáinig tráthnóna agus deireadh an laé; agus go raibh *an capall* ag dul faoi sgáth na copóige agus ní fanfadh an chopóg leis. D'fhiafruigh mac rígh Éireann de'n fhear gearr glas ann sin, cá bheidheadh siad an oidhce sin, agus dubhairt an fear gearr glas go mbeidheadh siad i dteach dearbhráthar an fhathaigh ag a raibh siad aréir. Dhearc mac rígh Éireann uaidh agus ní fhacaidh sé dadamh. Dhearc an fear gearr glas uaidh agus chonnairc sé caisleán mór. D'fhágbhaigh sé mac rígh Éireann agus a mhuinntir ann sin agus chuaidh sé chum an chaisleáin leis féin, agus tharraing sé an cuaille cómhraic, agus níor fhágbhaigh sé leanbh i mnaoi, searrach i láir, pigín i muic, na broc i ngleann nár thionntuigh sé thart trí uaire leis an méad torain a bhain sé as an g-cuaille cómhraic. Tháinig an fathach amach agus dubhairt sé ‘mothuighim





---

p.34




boladh an Éireannaigh bhinn bhreugaigh faoi m'fhóidín dúthaigh.’
  




‘Ní Éireannach binn breugach mise,’ ar san fear gearr glas, ‘acht tá mo mháighistir 'nna sheasamh ann sin, ag ceann an bhóthair, agus má thagann sé bainfidh sé an ceann diot.’


Agus leis sin thosuigh an fear gearr glas ag méadughadh go raibh sé chomh mór leis an g-caisleán faoi dheireadh.


Tháinig faitchios air an bhfathach agus dubhairt sé, ‘bhfuil do mháighistir chomh mór leat féin?’
  


 

‘Tá,’ ar san fear gearr glas, ‘agus níos mó.’
  




‘O cuir mé i bhfolach, cuir mé i bhfolach,’ ar san fathach, ‘go n-imthigheann do mháighistir, agus rud air bith a bheidheas tú ag iarraidh caithfidh tú a fhághail.’


Thug sé an fathach leis, agus chaith sé faoi bheul dabhaich é, agus glas air.


Tháinig sé air ais agus thug sé mac rígh Éireann, an gunnaire, an cluasaire, an coisire, an séidire, agus fear briste na g-cloch le taoibh a thóna asteach leis, agus chaith siad an oidhche sin go súgach, trian dí le fiannuigheacht, agus trian dí le sgeuluigheacht, agus trian dí le soirm sáimh suain agus fíor-chodalta.


Air mhaidin, lá air na mhárach, thug sé mac rígh Éireann agus a mhuinntir amach agus d'fhágbhuigh sé ag ceann an bhóthair iad agus tháinig sé féin air ais, agus leig sé amach an fathach, agus dubhairt sé leis an bhfathach an cloidheamh meirgeach a bhí faoi cholbha a leabuidh do thabhairt dó. 





---

p.36




Dubhairt an fathach nach dtiúbhradh sé an sean-chloidheamh sin d' aon duine, acht go dtiúbhradh sé dhó cloidheamh na trí faobhar, nár fhág fuigheal buille 'nna dhiaigh, agus dá bhfágfadh sé go dtiubhradh sé leis an dara buille é.


‘Ní ghlacfaidh mé sin,’ ar san fear gearr glas, ‘caithfidh mé an cloidheamh meirgeach fhághail, agus muna bhfágh' mé é rachfaidh mé i g-coinne mo mháighistir agus bainfidh sé an ceann díot.’


‘Is fearr dam a thabhairt duit,’ ar san fathach, ‘agus cia bé áit a bhuailfeas tú buille leis an g-cloidheamh sin rachfaidh sé go dtí an gaineamh dá mbudh iarann a bhí roimhe.’ Thug sé an cloidheamh meirgeach dó ann sin.


Chuaidh mac rígh Éireann agus an fear gearr glas, agus an gunnaire, agus an cluasaire, agus an coisire agus an séidire, agus fear briste na g-cloch le taoibh a thóna ann sin, go dtáinig tráthnóna agus deireadh an laé; go raibh an capall ag dul faoi sgáth na copóige agus ní fhanfadh an chopóg leis. Ní bhéarfadh an ghaoth Mhárta a bhí rompa orra agus an ghaoth Mhárta a bhí 'nna n-diaigh ní rug sí orra-san, agus bhí siad an oidhche sin ann san domhan shoir, an áit a raibh an bhean-uasal.


D'fhiafruigh an bhean de mhac rígh Éireann creud do bhí sé ag iarraidh agus dubhairt seisean go raibh sé ag iarraidh í féin mar mhnaoi. ‘Caithfidh tú m'fhágail,’ ar sise, ‘má fhuasglann tú mo gheasa dhíom.’


Fuair sé a lóistín le na chuid buachaill ann san g-caisleán an oidhche sin, agus ann san oidhche tháinig sise agus dubhairt leis ‘seó siosúr agad, agus muna bhfuil an siosúr sin agad air maidin amárach bainfear an ceann díot.’




---

p.38


Chuir sí biorán-suain faoi na cheann, agus thuit sé 'nna chodladh, agus chomh luath a's thuit sé 'nna chodladh rug sí an siosúr uaidh agus d'fhágbhuigh sí é. Thug sí an siosúr do'n rígh nimhe, agus dubhairt sí leis an rígh*,* an siosúr do bheith aige air maidin dí. D'imthigh sí ann sin. Nuair bhí sí imthighthe thuit an rígh nimhe 'nna chodladh agus nuair a bhí sé 'nna chodladh tháinig an fear gearr glas agus na sean-slipéaraidh air, agus an birreud air a cheann, agus an cloidheamh meirgeach ann a láimh, agus cia bé áit a d'fhágbhuigh an rígh an siosúr fuair seisean é. Thug sé do mhac rígh Éireann é, agus nuair tháinig sise air maidin d'fhiafruigh sí ‘a mhic rígh Éireann bhfuil an siosúr agad?’
  




‘Tá,’ ar seisean.


Bhí trí fíche cloigionn na ndaoine a tháinig 'gá h-iarraidh air spícibh timchioll an chaisleáin agus shaoil sí go mbeidheadh a chloigionn air spíce aici i g-cuideacht leó.


An oidhche, an lá air na mhárach, tháinig sí agus thug sí cíar dó, agus dubhairt sí leis muna mbeidheadh an chíar aige air maidin nuair a thiucfadh sí go mbeidheadh an ceann bainte dhé. Chuir sí biorán-suain faoi na cheann agus thuit sé 'nna chodladh mar thuit sé an oidhche roimhe, agus ghoid sise an chíar léithe. Thug sí an chíar do'n rígh nimhe agus dubhairt sí leis gan an chíar do chailleadh mar chaill sé an siosúr. Tháinig an fear gearr glas agus na sean-sléiparaidh air a chosaibh, an sean-bhirreud air a cheann agus an cloidheamh meirgeach ann a láimh, agus ní fhacaidh an rígh é go dtáinig sé taobh shiar dé agus thug sé an chíar leis uaidh.


Nuair tháinig an mhaidin, dhúisigh mac rígh Éireann agus thosuigh sé ag caoineadh na ciaire a bhí imthighthe uaidh. ‘Ná 





---

p.40




bac leis sin,’ ar san fear gearr glas, ‘tá sé agam-sa.’ Nuair tháinig sise thug sé an chíar dí, agus bhí iongantas uirri.


Tháinig sí an tríomhadh oidhche, agus dubhairt sí le mac rígh Éireann an ceann do cíaradh leis an g-cíair sin do bheith aige dhí, air maidin amárach. ‘Nois,’ ar sise, ‘ní raibh baoghal ort go dtí anocht, agus má chailleann tú an t-am so í, tá do chloigionn imthighthe.’


Bhí an biorán-suain faoi na cheann, agus thuit sé 'nna chodladh. Tháinig sise agus ghoid sí an chíar uaidh. Thug sí do'n rígh nimhe í, agus dubhairt sí leis nár fheud an chíar imtheacht uaidh *nó* go mbainfidhe an ceann dé. Thug an rígh nimhe an chíar leis, agus chuir sé asteach í i g-carraig cloiche, agus trí fiche glas uirri, agus shuidh an rígh taoibh amuigh de na glasaibh uile ag doras na carraige, 'gá faire. Tháinig an fear gearr glas, agus na slipeuraidh agus an birreud air, agus an cloidheamh meirgeach ann a láimh, agus bhuail sé buille air an g-carraig cloiche agus d'fhosgail suas í, agus bhuail sé an dara bhuille air an rígh nimhe, agus bhain sé an ceann dé. Thug sé leis an chíar chuig (do) mac rígh Éireann ann sin, agus fuair sé é ann a dhúiseacht, agus é ag caoineadh na cíaire. ‘Súd í do chíar duit,’ ar seisean, ‘tiucfaidh sise air ball, agus fiafróchaidh sí dhíot an bhfuil an chíar agad, agus abair léithe go bhfuil, agus an ceann do cíaradh léithe, agus caith chuici an cloigionn.’


Nuair tháinig sise ag fiafruigh an raibh an chíar aige, dubhairt sé go raibh, agus an ceann do cíaradh léithe, agus chaith sé ceann an rígh nimhe chuici.


Nuair chonnairc sí an cloigionn bhí fearg mhór uirri, agus dubhairt sí leis nach bhfuighfeadh sé í le pósadh go bhfághadh sé coisire a siúbhalfadh le na coisire féin i g-coinne trí bhuideul na h-íochshláinte as tobar an domhain shoir, agus 





---

p.42




dá mbud luaithe a tháinig a coisire féin 'ná an coisire aige-sean, go raibh a cheann imthighthe.


Fuair sí sean-chailleach (bhuitse éigin), agus thug sí trí buideula dhí. Dubhairt ar fear gearr glas trí buideula do thabhairt do'n fhear a bhí ag congbháil páirce na ngeirrfhiadh, agus tugadh dhó iad. D'imthigh an chailleach agus an fear, agus trí buidéala ag gach aon aca, agus bhí coisire mic rígh Éireann ag tígheacht *leath-bhealaigh* air ais, sul a bhí an chailleach imthighthe leath-bhealaigh ag dul ann. ‘Suidh síos,’ ar san chailleach leis an g-coisire, ‘agus leig do sgíth, tá an bheirt aca pósta anois agus ná bí briseadh do chroidhe ag rith.’ Thug sí léithe cloigionn capaill agus chuir sí faoi na cheann é, agus biorán-suain ann, agus nuair leag sé a cheann air, thuit sé 'nna chodladh.


Dhóirt sise an t-uisge a bhí aige amach, agus d'imthigh sí.


B'fhada leis an bhfear gearr glas go raibh siad ag tígheacht, agus dubhairt sé leis an g-cluasaire, ‘Leag do chluas air an talamh, agus feuch an bhfuil siad ag teacht.’ ‘Cluinim,’ ar *seisean*, ‘an chailleach ag teacht, agus tá an coisire 'nna chodladh, agus é ag srannfartuigh.’
  




‘Dearc uait,’ ar san fear gearr glas leis an ngunnaire ‘go bhfeicfidh tú ca bhfuil an coisire.’


Dubhairt an gunnaire go raibh sé ann a leithid sin d'áit, agus cloigionn capaill faoi na cheann, agus é 'nna chodladh.
  




‘Cuir do ghunna le do shúil,’ ar san fear gearr glas, ‘agus cuir an cloigionn ó na cheann.’
  




Chuir sé an gunna le na shúil agus sguaib sé an cloigionn ó na cheann. Dhúisigh an coisire, agus fuair sé na buideula a bhí aige folamh, agus b'éigin dó filleadh chum an tobair arís.


Bhí an chailleach ag teacht ann sin agus ní raibh an coisire le feiceál (feicsint). Ar san fear gearr glas ann





---

p.44




sin, leis an bhfear a bhí ag cur an mhuilinn-gaoithe thart le na pholláire, ‘éirigh suas agus feuch an g-cuirfeá an chailleach air a h-ais.’ Chuir sé a mheur air a shrón agus nuair bhí an chailleach ag teacht chuir sé séideog gaoithe fúithi a sguaib air a h-ais í. Bhí sí teacht arís agus rinne sé an rud ceudna léithe. Gach am a bhidheadh sise ag teacht a bhfogas dóibh do bhídheadh seisean dá cur air a h-ais arís leis an ngaoith do sheideadh sé as a pholláire. Air dheireadh shéid sé leis an dá pholláire agus sguaib sé an chailleach chum an domhain shoir arís. Tháinig coisire mic rígh Éireann ann sin, agus bhí an lá sin gnóthuighthe.


Bhí fearg mhór air an mnaoi nuair chonnairc sí nach dtáinig a coisire féin air ais i dtosach, agus dubhairt sí le mac rígh Éireann, ‘Ní bhfuighfidh tú mise anois *nó* go siúbhailfidh tú trí mhíle gan bhróig gan stoca, air shnáthaidibh cruaidhe.’


Bhí bóthar aici trí mhíle air fad, agus snáthaide geura cruaidhe craithte air, chomh tiugh leis an bhfeur. Ar san fear gearr glas le fear-briste na g-cloch lena leath-thóin, ‘téidh agus maol iad sin.’ Chuaidh an fear sin orra le na leath-thóin agus rinne sé stumpaidh dhíobh. Dubhairt an fear gearr glas leis dul orra le na thóin dhúbalta. Chuaidh sé orra ann sin le na thóin dhúbalta, agus rinne sé púghdar agus praiseach díobh. Tháinig mac rígh Éireann agus shiubhail sé na trí mhíle, agus bhí a bhean gnóthuighthe aige.


Pósadh an bheirt ann sin, agus bhí an chéud phóg le fághail ag an bhfear gearr glas. Rug an bhfear gearr glas an bhean leis féin asteach i seomra, agus thosuigh sé uirri. Bhí sí lán dhe naithreachaibh nimhe, agus bheidheadh mac rígh Éireann marbh aca, nuair a rachfadh sé 'nna chodladh, acht gur phiuc an fear gearr glas aisti iad.


Tháinig sé go mac rígh Éireann ann sin, agus dubhairt sé leis, ‘Tig leat dul le do mhnaoi anois. Is mise an fear 





---

p.46




a bhí ann san g-cómhra an lá sin, a d'íoc tú na deich bpúnta air a shon, agus an mhuinntir seó a bhí leat is seirbhísíghe iad do chuir Dia chugad-sa.’


D'imthigh an fear gearr glas agus a mhuinntir ann sin agus ní fhacaidh mac rígh Éireann arís é. Rug sé a bhean abhaile leis, agus chaith siad beatha shona le chéile.


An Alp-Luachra
--------------


Bhí scológ saidhbhir a gConnachthtaibh aon uair amháin, agus bhí maoin go leór aige, agus bean mhaith agus muiríghin bhreágh agus ní raibh dadamh ag cur buaidhreadh ná trioblóide air, agus dheurfá féin go raibh sé 'nna fhear compórtamhail sásta, agus go raibh an t-ádh air, chomh maith agus air dhuine air bith a bhí beó. Bhí sé mar sin gan bhrón gan buaidhreadh air feadh móráin bliadhain i sláinte mhaith agus gan tinneas ná aicíd air féin ná air a chloinn, *nó* go dtáinig lá breágh annsan bhfóghmhar, a raibh sé dearcadh air a chuid daoine ag deunamh féir annsan moínfheur a bhí a n-aice le na theach féin, agus mar bhí an lá so teith d'ól sé deoch bláthaiche agus shín sé é féin siar air an bhfeur úr bainte, agus mar bhí sé sáruighthe le teas an laé agus leis an obair a bhí sé ag deunamh, do thuit sé gan mhoill 'nna chodladh, agus d'fhan sé mar sin air feadh trí *nó* ceithre uair *nó* go raibh an feur uile craptha agus go raibh a dhaoine oibre imthighthe as an bpáirc.


Nuair dhúisigh sé ann sin, shuidh sé suas air a thóin, agus ní raibh fhios aige cia an áit a raibh sé, *nó* gur chuimhnigh sé faoi dheire gur annsan bpáirc air chúl a thighe féin do bhí sé 'nna luidhe. D'éirigh sé ann sin agus chuaidh sé air ais chum a thighe féin, agus air n-imtheacht dó, mhothaigh sé mar phian no





---

p.48



 

mar ghreim air a bhoilg. Nior chuir sé suim ann, acht shuidh sé síos ag an teine agus thosuigh sé 'gá théigheadh féin.


‘Cá raibh tú?’ ars an inghean leis.
  




‘Bhí mé 'mo chodladh,’ ar seisean, ‘air an bhfeur úr ann sa' bpáirc 'nna raibh siad ag deunamh an fhéir.’
  




‘Creud a bhain duit,’ ar sise, ‘ní fhéuchann tú go maith.’
  




‘Muire! maiseadh! ní'l fhios agam,’ ar seisean, ‘acht tá faitchios orm go bhfuil rud éigin orm, is aisteach a mhothaighim mé féin, ní raibh mé mar sin ariamh roimhe seó, acht béidh mé níos fearr nuair a bhfuighfidh mé codladh maith.’


Chuaidh sé d'á leabuidh agus luidh sé síos, agus thuit sé ann a chodladh, agus níor dhúisigh sé go raibh an ghrian árd. D'éirigh sé ann sin agus dubhairt a bhean leis, ‘Creud do bhí ort nuair rinn' tú codladh chomh fada sin?’
  




‘Níl fhios agam,’ ar seisean.


Chuaidh sé annsan g-cisteanach, n'áit a bhí a inghean ag deunamh cáca le h-aghaidh an bhreác-fast (biadh na maidne), agus dubhairt sise leis ‘Cia an chaoi bhfuil tú andiú, bhfuil aon bhiseach ort*,* a athair?’
  




‘Fuair mé codladh maith,’ ar seisean, ‘acht ní'l mé blas níos fearr 'ná bhí mé aréir, agus go deimhin dá g-creidfeá mé, saoilim go bhfuil rud éigin astigh ionnam, ag rith anonn 's anall ann mo bhoilg o thaoibh go taoibh.’
  




‘Ara ní féidir,’ ar s an inghean, ‘is slaighdeán a fuair tú ad' luighe amuigh ané air an bhfeur úr, agus muna bhfuil tú níos fearr annsan trathnóna cuirfimíd fios air an dochtúir.’




---

p.50


Tháinig an tráthnóna, acht bhí an duine bocht annsan gcaoi cheudna, agus b'éigin dóibh fios chur air an dochtúir. Bhí sé ag rádh go raibh pian air, agus nach raibh fhios aige go ceart cad é an áit ann a raibh an phian, agus nuair nach raibh an dochtúir teacht go luath bhí sgannrughadh mór air. Bhí muinntir an tighe ag deunamh uile shóirt d'fheud siad dheunamh le meisneach a chur ann.


Tháinig an dochtúir faoi dheire, agus d'fhiafruigh sé dhé creud do bhí air, agus dubhairt seisean arís go raibh rud éigin mar éinín ag léimnigh ann a bholg. Nochtuigh an dochtúir é agus rinne sé breathnughadh maith air, acht ní fhacaidh sé dadamh a bhí as am m-bealach leis. Chuir sé a chluas lena thaoibh agus le na dhruim, acht níor chualaidh sé rud air bith cidh *go* raibh an duine bocht é féin ag rádh—‘Anois! Nois! nach g-cluinn tú é? Nois! nach nach bhfuil tú 'g éisteacht leis, ag léimnigh?’ Acht níor thug an dochtúir rud *air* bith faoi deara, agus shaoil sé faoi dheire go raibh an fear as a chéill, agus nach raibh dadamh air.


Dubhairt sé le mnaoi an tighe nuair tháinig sé amach, nach raibh aon rud air a fear, acht gur chreid sé féin go raibh sé tinn, agus go g-cuirfeadh sé druganna chuige an lá air na mhárach a bhéarfadh codladh maith dhó, agus a shochróchadh teas a chuirp. Rinne sé sin, agus shluig an duine bocht na druganna uile agus fuair sé codladh mór arís acht nuair dhúisigh sé air maidin bhí sé níos measa 'ná riamh, acht dubhairt sé nár chualaidh sé an rud ag léimnigh taobh astigh dhé anois.


Chuir siad fios air an dochtúir arís, agus tháinig sé acht níor fheud sé rud air bith dheunamh. D'fhág sé druganna eile leis an bhfear, agus dubhairt sé go dtiucfadh sé arís i g-ceann séachtmhuine eile le na fheicsint. Ní bhfuair an duine bocht fóirighín air bith as ar fhág an dochtúir leis agus nuair tháinig an dochtúir arís fuair sé é 





---

p.52




níos measa na roimhe sin; acht níor fheud sé aon rud dhéanamh agus ní raibh fhios air bith aige cad é'n cineál tinnis do bhí air. ‘Ní bhéidh mé ag glacadh d'airgid uait feasta,’ ar seisean, le mnaoi an tighe, ‘mar nach dtig liom rud air bith dhéanamh annsan g-cúis seó; agus mar nach dtuigim creud atá air, ní leigfidh mé orm é do thuigsint. Tiucfaidh mé le na fheicsint ó am go h-am acht ní ghlacfaidh mé aon airgiod uait.’


Is air éigin d'fheud an bhean an fhearg do bhí uirri do chongmháil asteach. Nuair bhí an dochtúir imthighthe chruinnigh sí muinntir an tighe le chéile agus ghlac siad cómhairle, ‘An dochtúir bradach sin,’ ar sise, ‘ní fiú traithnín é. Bhfuil fhios aguibh creud dubhairt sé? nach nglacfadh sé aon airgiod uainn feasta, agus dubhairt sé nach raibh eólas air bith aige air dadamh. ‘Suf’ air an bitheamhnach! ní thiucfaidh sé thar an tairpeach só go bráth. Rachfamaoid go dtí an dochtúir eile, má tá sé níos faide uainn, féin, is cuma liom sin, caithfimíd a fhághail.’ Bhí uile duine a bhí annsa' teach air aon fhocal léithe, agus chuir siad fios air an dochtúir eile, agus nuair tháinig sé ní raibh aon eólas do b'fhearr aige-sean 'ná do bhí ag an g-ceud-dochtúir acht amháin go raibh eólas go leór aige air a n-airgiod do ghlacadh. Tháinig sé leis an duine tinn d'fheicsint, go minic, agus gach am a tháinig sé do bhí ainm eile aige níos faide 'na a chéile air a thinneas, ainmneacha (anmanna) nár thuig sé féin, ná duine air bith eile, acht bhí siad aige le sgannrughadh na n-daoine.


D'fhan siad mar sin air feadh dhá mhí, gan fhios ag duine air bith creud do bhí air an bhfear bocht, agus nuair nach raibh an dochtúir sin ag déanamh maith air bith dhó, fuair siad dochtúir eile, agus ann sin dochtúir eile, *nó* go raibh uile dhochtúir a bhí annsa' g-condaé aca, faoi dheire, agus 





---

p.54




chaill siad a lán airgid leó, agus b'éigin dóibh cuid d'á n-eallach dhíol le h-airgiod fhághail le na n-íoc.


Bhí siad mar sin le leith-bhliadhain ag congbháil dochtúir leis, agus na dochtúiridh ag tabhairt druganna dhó, agus an duine bocht a bhí ramhar beathaighthe roimhe sin, ag éirighe lom agus tana, go nach raibh unsa feóla air, acht an croicion agus na cnámha amháin.


Bhí sé faoi dheire chomh dona sin gur air éigin d'fheud sé siúbhal, agus d'imthigh a ghoile uaidh, agus budh mhór an *thrioblóid* leis greim aráin bhuig, *nó* deoch bhainne úir do shlugadh agus bhí uile dhuine ag rádh go m-b'fhearr dó bás fhághail, agus budh bheag an t-iongnadh sin, mar nach raibh ann acht mar bheidheadh sgáile i mbuideul.


Aon lá amháin, nuair bhí sé 'nna shuidhe air cháthaoir ag doras an tighe, 'gá ghrianughadh féin ann san teas, agus muinntir an tighe uile imthighthe amach, agus gan duine ann acht é féin, tháinig seanduine bocht a bhí ag iarraidh déirce o áit go h-áit suas chum an dorais, agus d'aithnigh sé fear an tighe 'nna shuidhe annsa' g-cáthaoir, acht bhí sé chomh h-athruighthe sin agus chomh caithte sin gur air éigin d'aithneóchadh duine é. ‘Tá mé ann só arís ag iarraidh déirce ann ainm Dé,’ ars an fear bocht, ‘acht glóir do Dhia a mháighistir creud do bhain duit ní tusa an fear céudna a chonnairc mé leith-bhliadhain ó shoin nuair bhí mé ann só, go bhfóirigh Dia ort.’
  




‘Ara a Sheumais’ ar san fear tinn, ‘is mise nach bhfeudfadh innsint duit creud do bhain dam, acht tá fhios agam air aon rud, nach mbéidh mé bhfad air an t-saoghal so.’
  




‘Acht tá brón orm d'fheicsint mar tá tu,’ ar san déirceach, ‘nach dtig leat innsint dam cia an chaoi ar thosuigh sé leat? creud a dubhairt na dochtúiridh?’
  




‘Na dochtúiridh!’ ar san fear tinn, ‘mo mhallacht orra! Ní'l fhios air dadamh aca, acht ní chóir dam bheith ag





---

p.56




eascuine agus mise chomh fogas sin dom' bhás, ‘súf’ orra ní'l eólas air bith aca.’
  




‘B'éidir,’ ar san déirceach, ‘go bhfeudfainn féin biseach thabhairt duit, dá n-inneós*f*á dham creud atá ort. Deir siad go mbídhim eólach air aicídibh, agus air na luibheannaibh atá maith le na leigheas.’
  




Rinne an fear tinn gáire. ‘Ní'l fear-leighis ann sa' g-condaé,’ ar sé, ‘nach raibh ann só liom; nach bhfuil leath an eallaigh a bhí agam air an bhfeilm díolta le na n-íoc! acht ní bhfuair mé fóirighin dá laghad ó dhuine air bith aca, acht inneósaidh mé dhuit-se mar d'éirigh sé dam air dtús.’ Agus ann sin thug sé cúntas dó air uile phian a mhothuigh sé, agus air uile rud a d'orduigh na dochtúiridh.


D'éist an déirceach leis go cúramach, agus nuair chríochnuigh sé an sgeul uile, d'fhiafruigh sé dhé, ‘cad é an sórt páirce í air ar thuit tú do chodladh?’ 



‘Is móinfheur a bhí ann,’ ar san duine tinn, ‘acht bhí sé go díreach bainte, ann san am sin.’
  




‘Raibh sé fliuch,’ ars an déirceach.
  




‘Ní raibh,’ ar seisean.
  




‘Raibh srothán uisge *nó* caise a' rith thríd?’ ars an déirceach.
  




‘Bhí,’ ar seisean.
  




‘An dtig liom an pháirc fheicsint?’
  




‘Tig go deimhin, agus taisbeunfaidh mé dhuit anois é.’


D'éirigh sé as a cháthaoir agus chomh dona agus bhí sé, stráchail sé é féin air aghaidh, *nó* go dtáinig sé chum na h-áite ann ar luidh sé 'nna chodladh an trathnóna sin. Bhreathnuigh fear-na-déirce air an áit, tamall fada, agus ann sin chrom sé air an bhfeur agus chuaidh sé anonn 's anall agus a chorp lúbtha agus a cheann cromtha ag smeurthacht ann sna luibheannaibh, agus ameasg an luibhearnaigh do bhí ag fás go tiugh ann.


D'éirigh sé faoi dheire, agus dubhairt sé, ‘Tá sé mar shaoil mé,’ agus chrom sé é féin síos arís, agus thosuigh





---

p.58




 ag cuartughadh mar roimhe sin. Thóg sé a cheann an dara uair, agus bhí luibh bheag ghlas ann a láimh. ‘An bhfeiceann tú sin,’ ar sé, ‘áit air bith *i n-*Éirínn a bhfásann an luibh seó ann, bíonn alp-luachra anaice leis, agus shluig tú alp-luachra.’
  




‘Cad é an chaoi bhfuil fhios agad sin?’ ars an duine tinn, ‘dá mbudh mar sin do bhí sé, is dóigh go n-inneósadh na dochtúiridh dham é roimhe seo.’
  




‘Go dtugaidh Dia ciall duit, na bac leis na dochtúiribh,’ ars an déirceach, ‘ní'l ionnta acht eallta amadán. A deirim leat’ ar s*é*, ‘agus creid mise, gur alp-luachra a shluig tu; nach dubhairt tú féin gur mhothuigh tú rud éigin ag léimnigh ann do bolg an chéad lá 'réis tú bheith tinn. B'é sin an alp-luachra, agus mar do bhí an áit sin ann do bholg strainseurach leis i dtosach, bhí sé mí-shuaimhneach innti, ag dul anonn 's anall, acht nuair bhí sé cúpla lá innti, shocruigh sé é féin, agus fuair sé an áit compórtamhail agus sin é an t-ádhbhar fá bhfuil tú ag congmháil chomh tana sin: mar uile ghreim d'á bhfuil tú ag ithe bíonn an alp-luachra sin ag fághail an mhaith as. Agus dubhairt tú féin liom go raibh do leath-thaobh athta, is í sin an taobh 'n áit a bhfuil an rud gránna 'nna chómhnuidhe.’


Níor chreid an fear é, a dtosach, acht lean an déirceach dá chómhrádh leis, ag cruthughadh dhó, gur b' é an fhírinne a bhí sé ag rádh, agus nuair tháinig a bhean agus a inghean air ais arís do'n teach, labhair sé leó-san an chaoi cheudna agus bhí siad réidh go leór le na chreideamhaint.


Níor chreid an duine tinn, é féin, é, acht bhí siad uile ag labhairt leis, go bhfuair siad buaidh air, faoi dheire; agus thug sé cead dóib trí dochtúiridhe do ghlaodhach asteach le chéile, go n-inneósadh sé an sgeul nuadh so dhóibh. Tháinig an triúr le chéile, agus nuair d'éist siad leis an méad a bhí an déirceach ag rádh, agus le cómhrádh na mban, rinne siad gáire agus dubhairt siad nach raibh ionnta acht 





---

p.60




amadáin uile go léir, agus gurb'é rud eile amach 's amach a bhí ar fhear-an-tighe, agus gach ainm a bhí aca air a thinneas an t-am so, bhí sé dhá uair, 's trí huaire níos faide 'ná roimhe sin. D'fhág siad buidéul *nó* cúpla buideul le n-ól ag an bhfear bocht, agus d'imthigh siad leó, ag magadh faoi an rud a dubhairt na mná gur shluig sé an alp-luachra.


Dubhairt an déirceach nuair bhí siad imthighthe. ‘Ní'l iongantas air bith orm nach bhfuil tú fághail beisigh má's amadáin mar iad sin atá leat. Ní'l aon dochtúir ná fear-leighis i n-Éirinn anois a dhéanfas aon mhaith duit-se acht aon fhear amháin, agus is sé sin Mac Diarmada, Prionnsa Chúl-Uí-Bhfinn air bhruach Locha-Uí-Gheadhra an dochtúir is fearr i g-Connachtaib ná 'sna cúig cúigibh.’ ‘Cá bhfuil Loch-Uí-Gheadhra?’ ars an duine tinn. ‘Shíos i g-condaé Shligígh; is loch mór é, agus tá an Prionnsa 'nna chómhnuidhe air a bhruach,’ ar sé, ‘agus má ghlacann tú mo chómhairle-se rachfaidh tú ann, mar 's é an chaoi dheireannach atá agad, agus budh chóir duit-se, a mháighistreas,’ ar sé ag tiontódh le mnaoi an tighe, ‘do chur iach (d'fhiachaibh) air, dul ann, má's maith leat d'fhear a bheith beó.’
  




‘Maiseadh,’ ars an bhean, ‘dheunfainn rud air bith a shlánóchadh é.’
  
 



‘Mar sin, cuir go dtí Prionnsa Chúil-Uí-Bhfinn é,’ ar seisean.
  
 



‘Dheunfainn féin rud air bith le mo shlánughadh,’ ars an fear tinn ‘mar tá's agam nach bhfuil a bhfad agam le marthain air an t-saoghal so, muna ndeuntar rud éigin dam a bhéarfas congnamh agus fóiríghin dam.’
  
 



‘Mar sin, téidh go dtí an Prionnsa,’ ars an déirceach.
  




‘Rud air bith a mheasann tú go ndeunfaidh sé maith dhuit budh chóir dhuit a dhéanamh, a athair,’ ars an inghean.
  




‘Ní'l dadamh le déanamh maith dhó acht dul go dtí an Prionnsa,’ ars an déirceach.




---

p.62


Is mar sin bhí siad ag árgúint agus ag cuibhlint go dtí an oidhche, agus fuair an déirceach leabuidh tuighe annsa' sgioból agus thosuigh sé ag árgúint arís air maidin go mbudh chóir dul go dtí an Prionnsa, agus bhí an bhean agus an inghean air aon fhocal leis, agus fuair siad buaidh air an bhfear tinn, faoi dheire; agus dubhairt sé go rachfadh sé, agus dubhairt an inghean go rachfadh sise leis, le tabhairt aire dhó, agus dubhairt an déirceach go rachfadh seisean leó-san le taisbéant an bhóthair dóibh, ‘agus béidh mise’ ars an bean, ‘air phonc an bháis le h-imnidhe ag fanamhaint libh, go dtiucfaidh sibh air ais.’


D'úghmuigh siad an capall agus chuir siad faoi an gcairt é, agus ghlac siad lón seachtmhuine leó, arán agus bagún agus uibheacha, agus d'imthigh siad leó. Níor fheud siad dul ró fhada an cheud lá, mar bhí an fear tinn chomh lag sin nár fheud sé an crathadh a bhí sé fághail annsa' g-cairt sheasamh, acht bhí sé níos fearr an dara lá, agus d'fhan siad uile i dteach feilméara air thaoibh an bhóthair an oidhche sinn agus chuaidh siad air aghaidh arís air maidin, agus an tromhadh lá annsan trathnóna tháinig siad go h-áit-chómhnuidhe an Phrionnsa. Bhí teach deas aige air bhruach an locha, le cúmhdach tuighe air, ameasg na g-crann.


D'fhág siad an capall agus an cairt i mbaile beag a bhí anaice le háit an Phrionnsa, agus shiúbhail siad uile le chéile go d-táinig siad chum an tighe. Chuaidh siad asteach 'san g-cisteanach agus d'fhiafruigh siad, ‘ar fheud siad an Prionnsa d'fheicsint.’ Dubhairt an searbhfóghanta go raibh sé ag ithe a bhéile acht go dtiucfadh sé, b'éidir, nuair bheidheadh sé réidh.


Tháinig an Prionnsa féin asteach air an móimid sin agus d'fhiafruigh sé dhíobh creud do bhí siad ag iarraidh. D'éirigh an fear tinn agus dubhairt dé leis gur ag iarraidh congnamh ó na onóir do bhí sé, agus d'innis sé an sgeul





---

p.64



 

uile dó. ‘'Nois an dtig le d'onóir aon fhóirighín thabhairt dam?’ ar sé, nuair chríochnuigh sé a sgéul.
  




‘Tá súil agam go dtig liom,’ ar san Prionnsa, ‘air mhódh air bith déanfaidh mé mo dhíthchioll air do shon, mar tháinig tú chomh fada sin le m'fheicsint-se. B'olc an ceart dam gan mo dhíthchioll dheunamh. Tar suas annsa' bpárlúis. Is fíor an rud a dubhairt an sean duine atá ann sin leat. Shluig tú alp-luachra, *nó* rud éigin eile. Tar suas 'sa' bpárlúis liom.’


Thug sé suas leis é, agus is é an béile a bhí aige an lá sin giota mór de mhairtfheóil shaillte. Ghearr sé greim mór agus chuir sé air phláta é, agus thug sé do'n duine bocht le n-íthe é.


‘Óró! Créad atá d'onóir ag déanamh ann sin anois,’ ars an duine bocht, ‘níor shluig mé oiread agus toirt uibhe d'fheóil air bith le ráithche, ní'l aon ghoile agam, ní thig liom dadamh ithe.’
  




‘Bhí do thost, a dhuine,’ ars an Prionnsa, ‘ith é sin nuair a deirim leat é.’


D'ith an fear bocht an oiread agus d'fheud sé, acht nuair leig sé an sgian agus an ghabhlóg as a láimh chuir an Prionnsa iach (d'fhiachaibh) air iad do thógbháil arís, agus do thosughadh ar an nuadh. Chongbhuigh sé ann sin é ag ithe, go raibh sé réidh le pleusgadh, agus níor fheud sé faoi dheire aon ghreim eile shlugadh dá bhfághadh sé ceud púnta.


Nuair chonnairc an Prionnsa nach dtiucfadh leis tuilleadh do shlugadh, thug sé amach as an teach é, agus dubhairt sé leis an inghin agus leis an t-sean-déirceach iad do leanamhaint, agus rug sé an fear leis, amach go móinfhéur breágh glas do bhí os coinne an tighe, agus srothán beag uisge ag *rith* tríd an móinfheur.


Thug sé go bruach an t-srotháin é, agus dubhairt sé leis, luidhe síos air a bholg agus a cheann chongbháil os cionn 





---

p.66




an uisge, agus a bheul d'fhosgailt chomh mór agus d'fheudfadh sé, agus a chongbháil, beag-nach, ag baint leis an uisge, ‘agus fan ann sin go ciúin agus na corruigh, air d'anam,’ ar sé, ‘go bhfeicfidh tú creud éireóchas duit.’


Gheall an fear bocht go mbeidheadh sé socair, agus shín sé a chorp air an bhfeur, agus chongbhuigh sé a bheul fosgailte os cionn an t-srotháin uisge, agus d'fhan sé ann sin gan corrughadh.


Chuaidh an Prionnsa timchioll cúig slata air ais, air a chúl, agus tharraing sé an inghean agus an sean-fhear leis, agus is é an focal deireannach a dubhairt sé leis an bhfear tinn, ‘bí cinnte’ ar sé, ‘agus air d'anam na cuir cor asad, cia bé air bith rud éireóchas duit.’


Ní raibh an duine bocht ceathramhadh uaire 'nna luidhe mar sin nuair thosuigh rud éigin ag corrughadh taobh astigh dhé agus mhothaigh sé rud éigin ag teacht suas ann a sgornach, agus ag dul air ais arís. Tháinig sé suas, agus chuaidh sé air ais trí nó ceithre uaire a ndiaigh a chéile. Tháinig sé faoi dheire go dtí a bheul, agus sheas sé air bhárr a theanga acht sgannruigh sé agus chuaidh sé air ais arís, acht i gceann tamaill bhig tháinig sé suas an dara uair, agus sheas sé air bhárr a theanga, agus léim sé síos faoi dheire annsan uisge. Bhi an Prionnsa ag breathnughadh go geur air, agus ghlaodh sé amach, ‘na corruigh fós,’ mar bhí an fear dul ag éirighe.


B'éigin do'n duine bocht a bheul fhosgailt arís agus d'fhan sé an chaoi cheudna, agus ní raibh sé móimid ann, *nó* go dtáinig an dara rud suas ann a sgornach an chaoi cheudna, agus chuaidh sé air ais arís cúpla uair, amhail a's mar bhí sé sganngruighthe, acht faoi dheire tháinig seisean mar an cheud-cheann suas go dtí an beul agus sheas sé air bhárr a theanga, agus faoi dheire nuair mhothuigh sé boladh an uisge faoi, léim sé síos annsan tsrothán.




---

p.68


Chogair an Prionnsa, agus dubhairt sé ‘Nois tá 'n tart ag teacht orra, d'oibrigh an salann a bhí 'sa' mairtfheóil íad; nois tiucfaidh siad amach.’ Agus sul do bhí an focal as a bheul thuit an tríomhadh ceann le ‘plap’ annsan uisge, agus *móimid* 'nna dhiaigh sin, léim ceann eile síos ann, agus ann sin ceann eile, *nó* gur chómharaigh siad, cúig, sé, seacht, ocht, naoi, deich g-cinn, aon ceann deug, dá cheann deug.
  




‘Sin duisín atá anois’ ars an Prionnsa, ‘Sin é an t-ál, níor tháinig an t-sean-mháthair fós.’


Bhí an fear bocht dul 'g eírighe arís acht ghlaodh an Prionnsa air. ‘Fan mar a bhfuil tu, níor tháinig an mháthair.’


D'fhan sé mar do bhí sé, acht níor tháinig aon cheann eile amach, agus d'fhan sé níos mó ná ceathramhadh uaire. Bhí an Prionnsa féin ag éirighe mí-shuaimhneach, air eagla nach g-corróchadh an sean-Alt-pluachra chor air bith. Bhí an duine bocht chomh sáruighthe sin agus chomh lag sin go m' b'fhearr leis éirighe 'ná fanamhaint mar a raibh sé, agus ann aindheóin gach ruid a dubhairt an Prionnsa bhí sé ag seasamh suas, nuair rug an Prionnsa air a leath-chois agus an déirceach air an g-cois eile, agus do chongbhuigh siad shíos é gan buidheachas dó.


D'fhan siad ceathramhadh uaire eile, gan fhocal do rádh, agus i g-ceann an ama sin mhothuigh an duine bocht rud éigin ag corrughadh arís ann a thaoibh, acht seacht n-uaire níos measa 'na roimhe seó, agus is air éigin d'fheud sé é féin do chongbháil o sgreadach. Bhí an rud sin ag corrughadh le tamall maith ann, agus shaoil sé go raibh a chorp reubtha an taobh astígh leis. Ann sin thosuigh an rud ag teacht suas, agus tháinig sé go dtí a bheul agus chuaidh sé air ais arís. Tháinig sé faoi dheire chomh fada sin gur chuir an duine bocht a dhá mheur ann a bheul agus shaoil sé greim fhághail uirri. Acht má's obann chuir sé a mheura 





---

p.70




'steach is luaithe 'ná sin chuaidh an tsean alt-pluachra air ais.


‘Ór! a bhitheamhnaigh!’ ar san Prionnsa, ‘cad chuige rinn' tú sin? Nach dubhairt mé leat gan cor do chur asad. Má thig sé suas arís fan go socair.’ B'éigin dóibh fanamhaint le leath-uair mar do bhí sean-mháthair na h-alp-luachra sgannruighthe, agus bhí faitchios urri teacht amach. Acht tháinig sí suas arís, faoi dheire; b'éidir go raibh an iomarcuidh tart' urri agus níor fheud sí boladh an uisge a bhí ag cur cathuighthe uirri sheasamh, *nó* b'éidir go raibh sí uaigneach 'r éis a clainne d'imtheacht uaithi. Air mhódh air bith tháinig sí amach go bárr á bhéil agus sheas sí air a theanga chomh fad agus bheitheá ag cómhaireamh ceithre fichid, agus ann sin léim sí mar do léim a h-ál roimpi, asteach 'san uisge, agus budh thruime toran a tuitim' seacht n-uaire, 'ná an plap a rinne a clann.


Bhí an Prionnsa agus an bheirt eile ag breathnughadh air sin go h-iomlán, agus budh bheag nach raibh faitchios orra, a n-anál do tharraing, air eagla go sgannróchadh siad an beithidheach gránna. Chomh luath agus léim sí asteach 'san uisge tharraing siad an fear air ais, agus chuir siad air a dhá chois arís é.


Bhí sé trí huaire gan focal do labhairt, acht an cheud fhocal a dubhairt sé, budh h-é ‘is duine nuadh mé.’


Chongbhuigh an Prionnsa ann a theach féin le coicídheas é, agus thug sé aire mhór agus beathughadh maith dhó. Leig sé dhó imtheacht ann sin, agus an inghean agus an déirceach leis, agus dhiúltuigh sé oiread agus píghin do ghlacadh uatha.


‘B'fhearr liom 'ná deich bpúnta air mo láimh féin,’ ar sé, ‘gur thionntuigh mo leigheas amach chomh maith sin; nár leigfidh Dia go nglacfainn píghin *nó* leith-phi'n uait. Chaill tú go leór le dochtúiribh cheana.’




---

p.72


Tháinig siad a bhaile go sábhálta, agus d'éirigh sé slán arís agus ramhar. Bhí sé chomh buidheach de'n deirceach bocht gur chongbhuigh sé ann a theach féín go dtí a bhás é. Agus chomh fad a's bhí sé féin beó níor luidh sé síos air an bhfeur glas arís. Agus, rud eile; dá mbeidheadh tinneas *nó* easláinte air, ní h-iad na dochtúiridh a ghlaodhadh sé asteach.


Budh bheag an t-iongnadh sin!


Páidín Ó Ceallaigh agus an Easóg
--------------------------------


A bhfad ó shoin bhí fear d'ar' bh'ainm Páidín O'Ceallaigh 'nna chómhnuidhe i ngar do Thuaim i gcondaé na Gaillimhe. Aon mhaidin amháin d'éirigh sé go moch agus ní raibh fhios aige cia an t-am a bhí sé, mar bhí solas breágh ó'n ngealaigh. Bhí dúil aige le dul go h-aonach Cháthair-na-mart le storc asail do dhíol.


Ní raibh sé níos mó 'na trí mhíle air an mbóthar go dtáinig dorchadas mór air, agus thosuigh cith trom ag tuitim. Chonnairc sé teach mór ameasg crann timchioll cúig cheud slat ó'n mbóthar agus dubhairt sé leis féin, ‘rachfaidh mé chum an tíghe sin, go dtéidh an cith thart.’ Nuair chuaidh sé chum an tíghe, bhí an doras fosgailte, agus asteach leis. Chonnairc sé seomra mór air thaoibh a láimhe chlé, agus teine bhreágh 'san ngráta. Shuidh sé síos air stol le cois an bhalla, agus níor bhfada gur thosuigh sé ag tuitim 'nna chodladh, nuair chonnairc sé easóg mhór ag teacht chum na teineadh agus leag sí ginidh air leic an teaghlaigh agus d'imthigh. Níor bhfada go dtáinig sí air ais le ginidh eile agus leag air leic an teaghlaigh é, agus d'imthigh. Bhí sí ag imtheacht agus ag teacht go raibh cárnán mór ginidh air





---

p.74




an teaghlach. Acht faoi dheireadh nuair d'imthigh sí d'éirigh Páidín, agus chuir sé an méad óir a bhí cruinnighthe aici ann a phóca, agus amach leis.


Ní raibh sé a bh-fad imthighthe gur chualaidh sé an easóg ag teacht 'nna dhiaigh agus í ag sgreadaoil chomh h-árd le píobaibh. Chuaidh sí roimh Páidín air an mbóthar agus í ag lubarnuigh anonn 's anall agus ag iarraidh greim sgornaigh d'fhághail air. Bhí maide maith darach ag Páidín agus chongbhuigh sé í uaidh go dtáinig beirt fhear suas. Bhí madadh maith ag fear aca, agus ruaig sé asteach i bpoll 'san mballa í.


Chuaidh Páidín chum an aonaigh, agus ann áit é bheith tígheacht a bhaile leis an airgiod a fuair sé air a shean-asal, mar shaoil sé air maidin go mbeidheadh sé ag déanamh, cheannuigh sé capall le cuid de'n airgiod a bhain sé de'n easóig, agus tháinig sé a bhaile agus é ag marcuigheacht. Nuair tháinig sé chomh fada leis an áit ar chuir an madadh an easóg ann san bpoll, tháinig sí amach roimhe, thug léim suas, agus fuair greim sgornaigh air an g-capall. Thosuigh an capall ag rith, agus níor fheud Páidín a cheapadh, nó go dtug sé léim asteach i g-clais móir a bhí líonta d'uisge agus de mhúlach. Bhí sé 'gá bháthadh agus 'gá thachtadh go luath, go dtáinig fir suas a bhí teacht as Gaillimh agus dhíbir siad an easóg.


Thug Páidín an capall a bhaile leis, agus chuir sé asteach i dteach na mbó é, agus thuit sé 'nna chodladh.


Air maidin, lá air na mhárach, d'éirigh Páidín go moch, agus chuaidh sé amach le uisge agus féar thabhairt do'n chapall. Nuair chuaidh sé amach chonnairc sé an easóg ag teacht amach as teach na mbó, agus í foluighthe le fuil. ‘Mo 





---

p.76




sheacht míle mallacht ort,’ ar Páidín, ‘tá faitchios orm go bhfuil anachain déanta agad.’ Chuaidh sé asteach, agus fuair sé an capall, péire bó-bhainne, agus dá laogh marbh. Tháinig sé amach agus chuir sé madadh a bhí aige andhiaigh na h-easóige. Fuair an madadh greim uirri agus fuair sise greim air an madadh. Budh madadh maith é, acht b'éigin dó a ghreim sgaoileadh sul tháinig Páidín suas; acht chongbhuigh sé a shúil uirri go bhfacaidh sé í ag dul asteach i mbothán beag a bhí air bhruach locha. Tháinig Páidín ag rith agus nuair bhí sé ag an mbotháinín beag thug sé crathadh do'n mhadadh agus chuir sé fearg air, agus chuir sé asteach roimhe é. Nuair chuaidh an madadh asteach thosuigh sé ag tathfant. Chuaidh Páidín asteach agus connairc sé sean-chailleach ann san g-coirnéul. D'fhiafruigh sé dhí an bhfacaidh sí easóg ag teacht asteach.


‘Ní fhacaidh mé,’ ar san chailleach, ‘tá mé breóidhte le galar millteach agus muna dtéidh tú amach go tapa glacfaidh tú uaim é.’


*Chomh* fad agus bhí Páidín agus an chailleach, ag caint, bhí an madadh ag teannadh asteach, *nó* go dtug sé léim suas faoi dheireadh, agus rug sé greim sgornaigh air an g-cailligh.


Sgreadh sise, agus dubhairt, ‘tóg díom do mhadadh a Páidín Ui Cheallaigh, agus deunfaidh mé fear saidhbhir díot.’


Chuir Páidín iach (d'fhiachaibh) air an madadh a greim sgaoileadh, agus dubhairt sé, ‘Innis dam cia thú, *nó* cad fáth ar mharbh tú mo chapall agus mo bha?’
  




‘Agus cad fáth dtug tusa leat an t-ór a raibh mé cúig ceud bliadhain 'gá chruinniughadh ameasg cnoc agus gleann an domhain*?*’
  




‘Shaoil mé gur easóg a bhí ionnad,’ ar Páidín, ‘no ní bhainfinn le do chuid óir; agus nidh eile, má tá tú cúig 





---

p.78




ceud bliadhain air an tsaoghal so tá sé i n-am duit imtheacht chum suaimhnis.’
  




‘Rinne mé coir mhór i m'óige, agus táim le bheith sgaoilte óm' fhulaing má thig leat fiche púnta íoc air son ceud agus trí fichid aifrionn dam.’
  




‘Cá bhfuil an t-airgiod?’ ar Páidín.
  




‘Éirigh agus rómhair faoi sgeith atá os cionn tobair bhig i g-coirneul na páirce sin amuigh, agus gheobhaidh tú pota líonta d'ór. Íoc an fiche púnta air son na n-aifrionn agus béidh an chuid eile agad féin. Nuair a bhainfeas tú an leac de'n phota, feicfidh tú madadh mór dubh ag teacht amach, acht ná bíodh aon fhaitchios ort; is mac damh-sa é. Nuair a gheobhas tú an t-ór, ceannuigh an teach ann a bhfacaidh tú mise i dtosach, gheobhaidh tú saor é, mar tá sé faoi cháil go bhfuil taidhbhse ann. Béidh mo mhac-sa shíos ann san tsoiléar, ní dhéanfaidh sé aon dochar duit, acht béidh sé 'nna charaid maith dhuit. Béidh mise marbh ní ó'n lá so, agus nuair gheobhas tú marbh mé cuir splanc faoi an mbothán agus dóigh é. Ná h-innis d'aon neach beó aon nídh air bith de m' thaoibh-se, agus béidh an t-ádh ort.’
  
 



‘Cad é an t-ainm atá ort?’ ar Páidín.
  




‘Máire ní Ciarbháin,’ arsan chailleach.


Chuaidh Páidín a bhaile agus nuair tháinig dorchadas na h-oidhche thug sé láidhe leis agus chuaidh sé chum na sgeiche a bhí i g-coirneul na páirce agus thosuigh sé ag rómhair. Níor bhfada go bhfuair sé an pota agus nuair bhain sé an leac dé léim an madadh mór dubh amach, agus as go bráth leis, agus madadh Pháidin 'nna dhiaigh.


Thug Páidín an t-ór a bhaile agus chuir sé i bhfolach i dteach na mbó é. Timchioll mí 'nna dhiaigh sin, chuaidh sé go h-aonach i nGaillimh agus cheannuigh sé péire bó, capall 





---

p.80




agus duisín caora. Ní raibh fhios ag na cómharsannaibh cia an áit a bhfuair sé an t-airgiod. Dubhairt cuid aca go raibh roinn aige leis na daoinibh maithe.


Aon lá amháin ghleus Páidín é féin agus chuaidh sé chum an duine-uasail ar leis an teach mór, agus d' iarr air, an teach agus an talamh do bhí 'nna thimchioll, do dhíol leis.


‘Tig leat an teach bheith agad gan chíos, acht tá taidhbhse ann, agus níor mhaith liom tú dul do chómhnuidhe ann, gan a innsint; acht ní sgarfainn leis an talamh gan ceud púnta níos mó 'ná tá agad-sa le tairgsint dam.’
  




‘B'éidir go bhfuil an oiread agam-sa 's atá agad féin’ ar Páidín, ‘béidh mé ann so amárach leis an airgiod má tá tusa réidh le seilbh do thabhairt dam.’
  




‘Beidh mé réidh,’ arsan duine uasal.


Chuaidh Páidín abhaile agus d'innis d'á mhnaoi go raibh teach mór agus gabháltas talmhan ceannuighthe aige.
  




‘Cia an áit a bhfuair tú an t-airgiod?’ arsan bhean.
  




‘Nach cuma dhuit?’ ar Páidín.


Lá air na mhárach, chuaidh Páidín chum an duine-uasail, thug ceud púnta dhó, agus fuair seilbh an tighe agus na talmhan, agus d'fhág an duine-uasal an truscán aige asteach leis an margadh.


D'fhan Páidín ann san teach an oidhche sin, agus nuair tháinig an dorchadas chuaidh sé síos ann san tsoiléar, agus chonnairc sé fear beag le na dhá chois sgartha air bháirille.
  




‘'Nidh Dia dhuit, a dhuine chóir,’ ar san fear beag.
  




‘Go mbudh h-é dhuit,’ ar Páidín.
  




‘Ná bíodh aon fhaitchios ort rómham-sa,’ ar san fear beag, ‘béidh mé 'mo charaid maith dhuit-se má tá tú ionnán rún do chongbháil.’
  



---

p.82




‘Táim go deimhin. Chongbhuigh mé rún do mháthar, agus congbhóchaidh mé do rún-sa mar an g-ceudna.’
  




‘B'éidir go bhfuil tart ort,’ ar san fear beag.
  




‘Ní'l mé saor uaidh,’ air Páidín.


Chuir an fear beag lámh ann a bhrollach, agus tharraing sé corn óir amach, agus thug do Pháidín é, agus dubhairt leis ‘Tarraing fíon as an mbáirille sin fúm.’


Tharraing Páidín lán coirn agus sheachaid do'n fhear beag é. ‘Ól, thú féin, i dtosach,’ ar seisean. D'ól Páidín, tharraing corn eile agus thug *don* fhear beag é, agus d'ól sé é.
  




‘Líon suas agus ól arís,’ ar san fear beag, ‘is mian liom-sa bheith go súgach anocht.’


Bhí an bheirt ag ól go rabhadar leath air meisge. Ann sin thug an fear beag léim anuas air an urlár, agus dubhairt le Páidín, ‘nach bhfuil dúil agad i g-ceól?’
  




‘Tá go deimhin,’ ar Páidín, ‘agus is maith an damhsóir mé.’
  




‘Tóg suas an leac mhór atá 'san g-coirneul úd, agus gheobhaidh tú mo phíobaidh fúithi.’


Thóg Páidín an leac, fuair na píobaidh, agus thug do 'n fhear beag iad. D'fháisg sé na píobaidh air, agus thosuigh sé ag seinm ceóil bhinn. Thosuigh Páidín ag damhsa go raibh sé tuirseach. Ann sin bhí deoch eile aca, agus dubhairt an fear beag:
  




‘Deun mar dubhairt mo mháthair leat, agus taisbéanfaidh mise saidhbhreas mór duit. Tig leat do bhean thabhairt ann so, acht ná h-innis di go bhfuil mise ann, agus ní fheicfidh sí mé. Am air bith a bhéidheas lionn nó fíon ag teastáil uait tar ann so agus tarraing é. Slán leat 





---

p.84




anois, agus téidh ann do chodladh, agus tar chugam-sa an oidhche amárach.’


Chuaidh Páidín 'nna leabuidh, agus níor bhfada go raibh sé 'nna chodladh.


Air maidin, lá air na mhárach, chuaidh Páidín a bhaile agus thug a bhean agus a chlann go dtí an teach mór, agus bhíodar go sona. An oidhche sin chuaidh Páidín síos ann san tsoiléar. Chuir an fear beag fáilte roimhe, agus d'iarr air ‘raibh fonn damhsa air?’
  




‘Ní'l go bhfágh' mé deoch,’ air Páidín.
  




‘Ól do shaith,’ arsan fear beag, ‘ní béidh an báirille sin folamh fad do bheatha.’


D'ól Páidín lán an choirn agus thug deoch do'n fhear beag; ann sin dubhairt an fear beag leis.
  




‘Táim ag dul go Dún-na-sídh anocht, le ceól do sheinm do na daoinibh maithe, agus má thagann tú liom feicfidh tú greann breágh. Bhéarfaidh mé capall duit nach bhfacaidh tú a leithéid ariamh roimhe.’
  




‘Rachfad agus fáilte,’ ar Páidín, ‘acht cia an leis-sgeul a dheunfas mé le mo mhnaoi?’
  




‘Téidh 'do chodladh léithe, agus bhéarfaidh mise amach ó n-a taoibh thú, a gan fhios dí, agus bhéarfaidh mé air ais thú an chaoi cheudna,’ ar san fear beag.
  




‘Táim úmhal,’ ar Páidín, ‘béidh deoch eile agam sul a dtéidh mé as do láthair.’


D'ól sé deoch a ndiaigh díghe, go raibh sé leath air meisge agus chuaidh sé 'nna leabuidh ann sin le na mhnaoi.


Nuair dhúisigh sé fuair sé é féin ag marcuigheacht air sguaib i ngar do Dhún-na-sídh, agus an fear beag ag marcuigheacht air sguaib eile lena thaoibh. Nuair tháinig siad chomh fada le cnoc glas an Dúin, labhair an fear beag 





---

p.86




cúpla focal nár thuig Páidín; d'fhosgail an cnoc glas, agus chuaidh Páidín asteach i seomra breágh.


Ní fhacaidh Páidín aon chruinniughadh ariamh mar bhí ann san dún. Bhí an áit líonta de dhaoinibh beaga, bhí fir agus mná ann, sean agus óg. Chuireadar uile fáilte roimh Dómhnal agus roimh Páidín Ó Ceallaigh. B'é Dómhnal ainm an phíobaire bhig. Tháinig rígh agus bainríoghan na sídh 'nna láthair agus dubhairt siad:
  




‘Tamaoid uile ag dul go Cnoc Matha anocht, air cuairt go h-árd-rígh agus go bainríoghain ár ndaoine.’


D'éirigh an t-iomlán aca, agus chuaidh siad amach. Bhí capaill réidh ag gach aon aca, agus an Cóiste Bodhar le h-aghaidh an rígh agus na bainríoghna. Chuadar asteach 'san g-cóiste. Léim gach duine air a chapall féin, agus bí cinnte nach raibh Páidín air deireadh. Chuaidh an píobaire amach rompa, agus thosuigh ag seinm ceóil dóibh, agus as go bráth leó. Níor bhfada go dtángadar go Cnoc Matha. D'fhosgail an cnoc agus chuaidh an sluagh sídh asteach.


Bhí Finbheara agus Nuala ann sin, árd-rígh agus bainríoghan Shluaigh-sídh Chonnacht, agus mílte de dhaoinibh beaga. Tháinig Finbheara a láthair agus dubhairt:
  




‘Támaoid dul báire bhualadh ann aghaidh sluaigh-sídh Mhúmhan anocht, agus muna mbuailfimíd iad tá ár g-clú imthighthe go deó. Tá an báire le bheith buailte air Mháigh-Túra faoi Shliabh Belgadáin.’
  
 



‘Támaoid uile réidh,’ ar sluagh-sidh Chonnacht, ‘agus ní'l amhras againn nach mbuailfimíd iad.’
  




‘Amach libh uile,’ ar san t-árd-rígh ‘béidh fir Chnuic Néifin air an talamh rómhainn.’


D'imthigheadar uile amach, agus Dómhnal beag agus dá 'r dheug píobaire eile *rompa* ag seinm ceóil bhinn. Nuair





---

p.88




thángadar go Magh-Tóra bhí sluagh-sídh Mhúmhan agus sidh-fhir Chnuic Néifin rompa. Anois, is éigin do'n tsluagh-sídh beirt fhear beó do bheith i láthair nuair a bhíonn siad ag troid *nó* ag bualadh báire, agus sin é an fáth rug Dómhnal beag Páidín Ó Ceallaigh leis. Bhí fear dar ab ainm an Stangaire Buidhe ó Innis i g-condaé an Chláir le sluagh-sídh Mhúmhan.


Níor bhfada gur ghlac an dá shluagh taobha, caitheadh suas an liathróid agus thosuigh an greann dá ríribh.


Bhí siad ag bualadh báire agus na píobairidhe ag seinm ceóil, go bhfacaidh Páidín Ó Ceallaigh sluagh Mhúmhan ag fághail na láimhe láidre, agus thosuigh sé ag cuideachtain le sluagh-sidh Chonnacht. Tháinig an Stangaire i láthair agus d'ionnsuigh sé Páidín Ó Ceallaigh, acht níor bhfada gur chuir Páidín an Stangaire Buidhe air a thar-an-áirde. Ó bhualadh-báire, thosuigh an dá shluagh ag troid, acht níor bhfada gur bhuail sluagh Chonnacht an sluagh eile. Ann sin rinne sluagh Mhúmhan priompolláin díobh féin, agus thosuigh siad ag ithe uile nídh glas d'á dtáinig siad suas leis. Bhíodar ag sgrios na tíre rompa, go dtangadar chomh fada le Conga, nuair d'éirigh na mílte colam as Pholl-mór agus shluig siad ria priompolláin. Ní'l aon ainm air an bpoll go dtí an lá so acht Poll-na-gcolam.


Nuair ghnóthuigh sluagh Chonnacht an cath, thángadar air ais go Cnoc Matha, luthgháireach go leór, agus thug an rígh Finbheara sporán óir do Pháidin Ó Ceallaigh, agus thug an píobaire beag a bhaile é, agus chuir sé 'nna chodladh le na mhnaoi é.


Chuaidh mí thart ann sin, agus ní thárla aon nidh do b'fhiú a innsint; acht aon oidhche amháin chuaidh Páidín síos 'san tsoiléar agus dubhairt an fear beag leis, ‘Tá mo mháthair marbh, agus *dóigh* an bothán os a cionn.’
  



---

p.90




‘Is fíor duit,’ ar Páidín, ‘dubhairt sí nach raibh sí le bheith air an t-saoghal so acht mí, agus tá an mhí suas andé.’


Air maidin, an lá air na mhárach, chuaidh Páidín chum an botháin agus fuair sé an chailleach marbh. Chuir sé splanc faoi an mbothán agus dhóigh sé é. Tháinig sé a bhaile ann sin, agus d'innis sé do'n fhear beag go raibh an bothán dóighte. Thug an fear beag sporán dó agus dubhairt, ‘Ní bhéidh an sporán sin folamh chomh fad agus bhéidheas tú beó. Slán leat anois. Ní fheicfidh tú mé níos mó, acht bíodh cuimhne grádhach agad air an easóig. B'ise tosach agus príomh-ádhbhar do shaidhbhris.’


Mhair Páidín agus a bhean bliadhanta andhiaigh seó, ann san teach mór, agus nuair fuair sé bás d'fhág sé saidhbhreas mór 'nna dhiaigh, agus muirighín mhór le na chathadh.


Sin chugaibh mo sgeul anois ó thús go deire, mar chualaidh mise ó mo mháthair mhóir é.


Uilliam Ó Ruanaigh
------------------


Ann san aimsir i n-allód bhí fear ann dar ab ainm Uilliam Ó Ruanaigh, 'nna chomhnuidhe i ngar do Chlár-Gaillimh. Bhí sé 'nna fheilméar. *Aon* lá amháin tháinig an tighearna-talmhan chuige agus dubhairt. ‘Tá cíos trí bliadhain agam ort, agus muna mbéidh sé agad dam faoi cheann seachtmhaine caithfidh mé amach air thaoibh an bhóthair thú.’
  
 



‘Táim le dul go Gaillimh amárach le h-ualach cruithneachta do dhíol, agus nuais a gheobhas mé a luach íocfaidh mé thú,’ ar Liam. 



Air maidin, lá air na mhárach, chuir sé ualach cruithneachta air an g-cairt agus bhí sé dul go Gaillimh leis. 





---

p.92




Nuair bí sé timchioll míle go leith imthighthe o'n teach, tháinig duine-uasal chuige agus d'fhiafruigh sé dhé ‘An cruithneacht atá agad air an g-cart?’
  




‘'Seadh’ ar Liam, ‘tá mé dul 'gá dhíol le mo chíos d'íoc.’
  




‘Cia mhéad atá ann?’ ar san duine uasal.
  




‘Tá tonna cneasta ann,’ ar Liam.
  




‘Ceannóchaidh mé uait é,’ ar san duine uasal, ‘agus bhéarfaidh mé an luach is mó 'sa' margadh dhuit. Nuair a rachfas tú chomh fad leis an mbóthairín cártach atá air do láimh chlé, cas asteach agus bí ag imtheacht go dtagaidh tú go teach mór atá i ngleann, agus béidh mise ann sin rómhad le d' airgiod do thabhairt duit.’


Nuair tháinig Liam chomh fada leis an mbóthairín chas sé asteach, agus bhí sé ag imtheacht go dtáinig sé chomh fada le teach mór. Bhí iongantas air Liam nuair chonnairc sé an teach mór, mar rugadh agus tógadh ann san g-cómharsanacht é, agus ní fhacaidh sé an teach mór ariamh roimhe, cídh go raibh eólas aige air uile teach i bhfoigseacht cúig mile dhó.


Nuair tháinig Liam i ngar do sgioból a bhí anaice leis an teach mór tháinig buachaill beag amach agus dubhairt, ‘Céad míle fáilte rómhad a Liaim Ui Ruanaigh,’ chuir sac air a dhruim agus thug asteach é. Tháinig buachaill beag eile amach, chuir fáilte roimh Liam, chuir sac air a dhruim, agus d'imthigh asteach leis. Bhí buachaillidhe ag teacht, ag cur fáilte roimh Liam, agus ag tabhairt sac leó, go raibh an tonna cruithneachta imthighthe. Ann sin tháinig iomlán na mbuachaill i láthair agus dubhairt Liam leó: ‘Tá eólas agaibh uile orm-sa agus ní'l eólas agam-sa oraibh-se.’ Ann sin dubhradar leis, ‘Téidh asteach, agus ith do dhinnéar, tá an máighistir ag fanamhaint leat.’


Chuaidh Liam asteach agus shuidh sé síos ag an mbord. Níor ith sé an dara greim go dtáinig trom-chodladh air 





---

p.94




agus thuit sé faoi an mbord. Ann sin rinne an draoidheadóir fear-bréige cosmhúil le Liam, agus chuir a bhaile chum mná Liaim é, leis an g-capall, agus leis an g-cairt. Nuair tháinig sé go teach Liaim chuaidh sé suas ann san t-seomra, luidh air leabuidh, agus fuair bás.


Níor bhfada go ndeachaidh an gháir amach go raibh Liam Ó Ruanaigh marbh. Chuir an bhean uisge síos agus nuair bhí sé teith nigh sí an corp agus chuir os cionn cláir é. Tháinig na cómharsanna agus chaoineadar go brónach os cionn an chuirp, agus bhí truagh mhór ann do'n mhnaoi bhoicht, acht ní raibh mórán bróin uirri féin, mar bhí Liam aosta agus í féin óg. An lá air na mhárach cuireadh an corp agus ní raibh aon chuimhne níos mó air Liam.


Bhí buachaill-aimsire ag mnaoi Liaim agus dubhairt sí leis, ‘budh chóir duit mé phósadh, agus áit Liaim ghlacadh.’
  




‘Tá sé ró luath fós andhiaigh bhás do bheith ann san teach,’ ar san buachaill, ‘fan go mbéidh Liam curtha seachtmhain.’


Nuair bhí Liam seacht lá agus seacht n-oidhche 'nna chodladh tháinig buachaill beag agus dhúisigh é. Ann sin dubhairt sé leis, ‘táir seachtmhain do chodladh. Chuireamar do chapall agus do chairt abhaile. Seó dhuit do chuid airgid, agus imthigh.’


Tháinig Liam a bhaile, agus mar bhí sé mall 'san oidhche ní fhacaidh aon duine é. Air maidin an laé sin chuaidh bean Liaim agus an buachaill-aimsire chum an t-sagairt agus d'iarr siad air iad do phósadh.


‘Bhfuil an t-airgiod-pósta agaibh?’ ar san sagart.
  




‘Ní'l,’ ar san bhean, ‘acht tá storc muice agam 'sa' mbaile, agus tig leat í bheith agad i n-áit airgid.’


Phós an sagart iad, agus dubhairt, ‘cuirfead fios air an muic amárach.’


Nuair tháinig Liam go dtí a dhoras féin, bhuail sé buille 





---

p.96




air. Bhí an bhean agus an buachaill-aimsire ag dul chum a leabuidh, agus d'fhiafruigh siad, ‘cia tá ann sin?’
  
 



‘Mise,’ ar Liam, ‘fosgail an doras dam.’


Nuair chualadar an guth bhí fhios aca gur 'bhé Liam do bhí ann, agus dubhairt a bhean, ‘ní thig liom do leigean asteach, agus is mór an náire dhuit bheith teacht air ais andhiaigh thú bheith seacht lá san uaigh.’ 



‘An air mire atá tú?’ ar Liam.
  




‘Ní'lim air mire,’ ar san bhean, ‘tá fhios ag an uile duine 'sa' bparáiste go bhfuair tú bás agus gur chuir mé go geanamhail thú. Téidh air ais go d'uaigh, agus béidh aifrionn léighte agam air son d'anma bhoicht amárach.’
  




‘Fan go dtagaidh solas an laé,’ ar Liam, ‘agus bhéarfaidh mé luach do mhagaidh dhuit.’


Ann sin chuaidh sé 'san stábla, 'n áit a raibh a chapall agus a mhuc, shín sé ann san tuighe, gur thuit sé 'nna chodladh.


Air maidin, lá air na mhárach, dubhairt an sagart le buachaill beag a bhí aige, ‘téidh go teach Liaim Ui Ruanaigh agus bhéarfaidh an bhean a phós mé andé muc duit le tabhairt a bhaile leat.’


Tháinig an buachaill go doras an tighe agus thosuigh 'gá bhualadh le maide a bhí aige. Bhí faitchios air an mnaoi an doras fhosgailt, acht d'fhiafruigh sí, ‘cia tá ann sin?’
  




‘Mise,’ ar san buachaill, ‘chuir an sagart mé le muc d'fhághail uait.’
  
 



‘Tá sí amuigh 'san stábla,’ ar san bhean.


Chuaidh an buachaill asteach 'san stábla agus thosuigh ag tiomáint na muice amach, nuair d'éirigh Liam agus dubhairt, ‘Cá bhfuil tú ag dul le mo mhuic?’


Nuair chonnairc an buachaill Liam, as go bráth leis, agus níor stop go ndeachaidh sé chum an tsagairt agus a chroidhe ag teacht amach air a bheul le faitchios.


‘Cad tá ort?’ ar san sagart.




---

p.98


D'innis an buachaill dó go raibh Liam Ó Ruanaigh ann san stábla, agus nach leigfeadh sé dhó an mhuc thabhairt leis.


‘Bí do thost, a bhreugadóir,’ar san sagart, ‘tá Liam O'Ruanaigh marbh agus ann san uaigh le seachtmhain.’
  




‘Dá mbeidh' sé marbh seacht mbliadhna connairc mise ann san stábla é dhá mhóimid ó shoin, agus muna g-creideann tu, tar, thú féin, agus feicfidh tú é.’


Ann sin tháinig an sagart agus an buachaill le chéile go doras an stábla, agus dubhairt an sagart, ‘téidh asteach agus cuir an mhuc sin amach chugam.’
  




‘Ní rachfainn asteach air son an mhéid is fiú thú,’ ar san buachaill.


Chuaidh an sagart asteach ann sin agus bhí sé ag tiomáint na muice amach, nuair d'éirigh Liam suas as an tuighe agus dubhairt, ‘cá bhfuil tú dul le mo mhuic, a athair Phádraig?’


Nuair a chonnairc an sagart Liam ag éirighe, as go bráth leis, ag rádh: ‘I n-ainm Dé orduighim air ais go dtí an uaigh thú a Uilliam Ui Ruanaigh.’


Thosuigh Liam ag rith andhiaigh an tsagairt, agus ag rádh ‘A athair Phádraig bhfuil tú air mire? fan agus labhair liom.’


Níor fhan an sagart acht chuaidh a bhaile chomh luath agus d'fheud a chosa a iomchar, agus nuair tháinig sé asteach dhún sé an doras. Bhí Liam ag bualadh an dorais go raibh sé sáruighthe, acht ní leigfeadh an sagart asteach é. Faoi dheireadh chuir sé a cheann amach air fhuinneoig a bhí air bhárr an tíghe agus dubhairt, ‘A Uilliam Ui Ruanaigh téidh air ais chum d'uaighe.’


‘Tá tú air mire a athair Phádraig, ní'l mé marbh, agus ní raibh mé ann aon uaigh ariamh ó d'fhág mé bronn mo mháthar,’ ar Liam.


‘Chonnairc mise marbh thú,’ ar san sagart, ‘fuair tú bás obann agus bhí mé i láthair nuair cuireadh thú 'san uaigh, agus rinne mé seanmóir bhreágh os do chionn.’





---

p.100




‘Diabhal uaim, go bhfuil tú air mire chomh cinnte a's atá mise beó,’ ar Liam.


‘Imthigh as m'amharc anois agus léighfidh mé aifrionn duit amárach,’ ar san sagart.


Chuaidh Liam a bhaile agus bhuail sé a dhoras féin acht ní leigfeadh an bhean asteach é. Ann sin dubhairt sé leis féin, ‘rachfad agus íocfad mo chíos.’ Uile dhuine a chonnairc Liam air a bhealach go teach an tighearna bhí siad ag rith uaidh, mar shaoileadar go bhfuair sé bás. Nuair chualaidh an tighearna talmhan go raibh Liam Ó Ruanaigh ag teacht dhún sé na doirse, agus ní leigfeadh sé asteach é. Thosuigh Liam ag bualadh an dorais mhóir gur shaoil an tighearna go mbrisfeadh sé asteach é. Tháinig an tighearna go fuinneóig a bhí air bhárr an tíghe, agus d'fhiafruigh, ‘cad tá tú ag iarraidh?’
  




‘Tháinig mé le mo chíos íoc, mar fhear cneasta,’ ar Liam.
  




‘Téidh air ais go dtí d'uaigh, agus béarfaidh mé maitheamhnas duit,’ ar san Tighearna.
  




‘Ní fhágfaidh mé seó, go bhfágh' mé sgríbhinn uait go bhfuil mé íoctha suas glan go dtí an Bhealtaine seó chugainn.’


Thug an Tighearna an sgríbhinn dó, agus tháinig sé abhaile. Bhuail sé an doras, acht ní leigfeadh an bhean asteach é, ag rádh leis go raibh Liam Ó Ruanaigh marbh agus curtha, agus nach raibh ann san bhfear ag an doras acht fealltóir.


‘Ní fealltóir mé,’ ar Liam, ‘tá mé andhiaigh cíos trí bhliadhain d'íoc le mo mháighistir, agus béidh seilbh mo thighe féin agam, *nó* béidh fhios agam cad fáth.’


Chuaidh sé chum an sgiobóil, agus fuair sé barra mór iarainn agus níor bhfada gur bhris sé asteach an doras. Bhí faitchios mór air an mnaoi agus air an bhfear nuadh-phósta. Shaoileadar go rabhadar i n-am an eiseirighe, agus go raibh deire an domhain ag teacht.


‘Cad chuige ar shaoil tú go raibh mise marbh?’ ar Liam.





---

p.102




‘Nach bhfuil fhios ag uile dhuine ann san bparáiste go bhfuil tú marbh,’ ar san bhean.
  




‘Do chorp ó'n diabhal,’ ar Liam, ‘tá tú ag magadh fada go leór liom. Fágh dham nidh le n-ithe.’


Bhí eagla mhór air an mnaoi bhoicht agus gleus sí biadh dhó, agus nuair chonnairc sí é ag ithe agus ag ól dubhairt sí, ‘tá míorbhúil ann.’


Ann sin d'innis Liam a sgeul dí, o bhonn go bárr, agus nuair d'innis sé gach nidh, dubhairt sé, ‘Rachfad chum na n-uaighe amárach go bhfeicfead an bitheamhnach do chuir sibh-se i m'áit-sé.’


Lá air na mhárach thug Liam dream daoine leis, agus chuaidh sé chum na roilige, agus d'fhosgail siad an uaigh, agus bhíodar dul an chómhra d'fhosgailt, agus nuair a bhí siad 'gá tógbháil suas léim madadh mór dubh amach, agus as go bráth leis, agus Liam agus na fir eile 'nna dhiaigh. Bhíodar 'gá leanamhaint go bhfacadar é ag dul asteach ann san teach a raibh Liam 'nna chodladh ann. Ann sin d'fhosgail an talamh agus chuaidh an teach síos, agus ní fhacaidh aon duine é ó shoin, acht tá an poll mór le feicsint go dtí an lá so.


Nuair d'imthigh Liam agus na fir óga abhaile d'innis *siad* gach nidh do shagart na paráiste, agus sgaoil sé an pósadh a bhí eidir bean Liaim agus an buachaill-aimsire.


Do mhair Liam bliadhanta 'nna dhiaigh seó, agus d'fhág sé saidhbhreas mór 'nna dhiaigh, agus tá cuimhne air i g-Clár-Gaillimh fós, agus béidh go deó, má théidheann an sgeul so ó na sean-daoinibh chum na ndaoine óg.














