

#Ghost Stories of Chapelizod


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Ghost Stories of Chapelizod
===========================


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 2. Second draftExtent of text: 11570 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2006) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E850000-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

*Ghost Stories of Chapelizod* was first published anonymously in 1851 in the *Dublin University Magazine*.

#### Sources


**Editions**2. Joseph Sheridan Le Fanu, Madam Crowl's Ghost and other Tales of Mystery, collected and edited by M.R. James, London: G. Bell & Sons Limited, 1923.
3. Joseph Sheridan Le Fanu, Ghost Stories of Chapelizod, The collected works of Joseph Sheridan Le Fanu, 3 volumes; introduction by Sir Devendra P. Varma, New York: Arno Press 1977. [Facsimile reprint of 1871 edition.]
**Literature**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October–November 1916) 30–33.
8. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
9. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
10. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
11. V. S. Pritchett, The living novel, London: Chatto and Windus 1946.
12. Elizabeth Bowen, Collected Impressions, London 1950.
13. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
14. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
15. A. B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
16. Peter Penzoldt, The Supernatural in Fiction, New York: Humanities Press 1952.
17. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
18. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
19. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
20. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
21. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
22. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
23. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
24. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
25. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
26. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
27. E. F. Beiler, 'Introduction' to J.S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
28. J. C. Beckett, The Anglo-Irish Tradition, London 1976.
29. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London: Faber 1977.
30. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Athens, Ohio: Ohio University Press 1978.
31. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
32. Joseph Browne, 'Ghosts and Ghouls and Le Fanu', Canadian Journal of Irish Studies 8 (1982) 5-15.
33. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
34. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
35. Jolanta Nalecz-Wojtczak, 'Joseph Sheridan Le Fanu and New Dimensions for the English Ghost Story', in: Wolfgang Zach and Heinz Kosok (eds.), Literary Interrelations: Ireland, England and the World, vol. 2, Tübingen: Günter Narr 1987.
36. Victor Sage, Horror Fiction in the Protestant Tradition, London: Macmillan 1988.
37. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
38. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
39. Marie Mulvey-Roberts (ed.), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
40. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
41. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
42. Michael Charlesworth (ed.), The Gothic revival, 1720–1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
43. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
44. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
45. James Walton, Vision and Vacancy: the Fictions of J. S. Le Fanu. Dublin, University College Dublin Press, 2007.
**The edition used in the digital edition**2. Madam Crowl's Ghost and other Mystery Stories. Joseph Sheridan Le Fanu Reprint [1 volume; viii + 277pp] G. Bell & Sons LimitedLondon (1923)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 129–162.


#### Editorial Declaration


##### Correction


Text has been proofed twice at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors of the hardcopy edition are corrected silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the story. Paragraphs are marked. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from languages other than English are marked.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: By J. S. Le Fanu

 (1851) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Some words are in Irish, but rendered in English spelling.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] Some words are in French.


##### Language: [IT] One word is in Italian.


### Revision History


* (2010-03-26) Beatrix Färber (ed.)

* Header modified, new wordcount made, file parsed.
* (2008-07-25) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, addition to bibliography made, content of 'langUsage' revised; minor modifications made to header.
* (2006-11-27) Beatrix Färber (ed.)

* File proofed (2); file parsed; SGML and HTML file created.
* (2006-11-25) Beatrix Färber (ed.)

* Header created; bibliography compiled; file proofed (1), structural and content markup added.
* (2006-11-22) Beatrix Färber (capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E850000-001


### Ghost Stories of Chapelizod: Author: Joseph Sheridan Le Fanu




---

p.129


### Ghost Stories of Chapelizod


Take my word for it, there is no such thing as an ancient village, especially if it has seen better days, unillustrated by its legends of terror. You might as well expect to find a decayed cheese without mites, or an old house without rats, as an antique and dilapidated town without an authentic population of goblins. Now, although this class of inhabitants are in nowise amenable to the police authorities, yet, as their demeanor directly affects the comforts of her Majesty's subjects, I cannot but regard it as a grave omission that the public have hitherto been left without any statistical returns of their numbers, activity, etc., etc. And I am persuaded that a Commission to inquire into and report upon the numerical strength, habits, haunts, etc., etc., of supernatural agents resident in Ireland, would be a great deal more innocent and entertaining than half the Commissions for which the country pays, and at least as instructive. This I say, more from a sense of duty, and to deliver my mind of a





---

p.130




 grave truth, than with any hope of seeing the suggestion adopted. But, I am sure, my readers will deplore with me that the comprehensive powers of belief, and apparently illimitable leisure, possessed by parliamentary commissions of inquiry, should never have been applied to the subject I have named, and that the collection of that species of information should be confided to the gratuitous and desultory labours of individuals, who, like myself, have other occupations to attend to. This, however, by the way.


Among the village outposts of Dublin, Chapelizod once held a considerable, if not a foremost rank. Without mentioning its connexion with the history of the great Kilmainham Preceptory of the Knights of St. John, it will be enough to remind the reader of its ancient and celebrated Castle, not one vestige of which now remains, and of the fact that it was for, we believe, some centuries, the summer residence of the Viceroys of Ireland. The circumstance of its being up, we believe, to the period at which that corps was disbanded, the headquarters of the Royal Irish Artillery, gave it also a consequence of an humbler, but not less substantial kind. With these advantages in its favour, it is not wonderful that the town exhibited at one time an air of substantial and semi-aristocratic prosperity unknown to Irish villages in modern times.


A broad street, with a well-paved foot-path, and houses as lofty as were at that time to be found in the fashionable streets of Dublin; a goodly stone-fronted barrack; an ancient church, vaulted beneath, and with a tower clothed from its summit to its base with the richest ivy; an humble Roman Catholic chapel; a steep bridge spanning the Liffey, and a great old mill at the near end of it, were the principal features of the town. These, or at





---

p.131




 least most of them, remain still, but the greater part in a very changed and forlorn condition. Some of them indeed are superseded, though not obliterated by modern erections, such as the bridge, the chapel, and the church in part; the rest forsaken by the order who originally raised them, and delivered up to poverty, and in some cases to absolute decay.


The village lies in the lap of the rich and wooded valley of the Liffey, and is overlooked by the high grounds of the beautiful Phoenix Park on the one side, and by the ridge of the Palmerstown hills on the other. Its situation, therefore, is eminently picturesque; and factory-fronts and chimneys notwithstanding, it has, I think, even in its decay, a sort of melancholy picturesqueness of its own. Be that as it may, I mean to relate two or three stories of that sort which may be read with very good effect by a blazing fire on a shrewd winter's night, and are all directly connected with the altered and somewhat melancholy little town I have named. The first I shall relate concerns


The Village Bully
-----------------


About thirty years ago there lived in the town of Chapelizod an ill-conditioned fellow of herculean strength, well known throughout the neighbourhood by the title of Bully Larkin. In addition to his remarkable physical superiority, this fellow had acquired a degree of skill as a pugilist which alone would have made him formidable. As it was, he was the autocrat of the village, and carried not the sceptre in vain. Conscious of his superiority, and perfectly secure of impunity, he lorded it over his fellows in a spirit of cowardly and brutal insolence, which made him hated even more profoundly than he was feared.




---

p.132


Upon more than one occasion he had deliberately forced quarrels upon men whom he had singled out for the exhibition of his savage prowess; and in every encounter his over-matched antagonist had received an amount of ‘punishment’ which edified and appalled the spectators, and in some instances left ineffaceable scars and lasting injuries after it.


Bully Larkin's pluck had never been fairly tried. For, owing to his prodigious superiority in weight, strength, and skill, his victories had always been certain and easy; and in proportion to the facility with which he uniformly smashed an antagonist, his pugnacity and insolence were inflamed. He thus became an odious nuisance in the neighbourhood, and the terror of every mother who had a son, and of every wife who had a husband who possessed a spirit to resent insult, or the smallest confidence in his own pugilistic capabilities.


Now it happened that there was a young fellow named Ned Moran—better known by the soubriquet of ‘Long Ned,’ from his slender, lathy proportions—at that time living in the town. He was, in truth, a mere lad, nineteen years of age, and fully twelve years younger than the stalwart bully. This, however, as the reader will see, secured for him no exemption from the dastardly provocations of the ill-conditioned pugilist. Long Ned, in an evil hour, had thrown eyes of affection upon a certain buxom damsel, who, notwithstanding Bully Larkin's amorous rivalry, inclined to reciprocate them.


I need not say how easily the spark of jealousy, once kindled, is blown into a flame, and how naturally, in a coarse and ungoverned nature, it explodes in acts of violence and outrage.


‘The bully’ watched his opportunity, and contrived to provoke Ned Moran, while drinking in a public-house





---

p.133




 with a party of friends, into an altercation, in the course of which he failed not to put such insults upon his rival as manhood could not tolerate. Long Ned, though a simple, good-natured sort of fellow, was by no means deficient in spirit, and retorted in a tone of defiance which edified the more timid, and gave his opponent the opportunity he secretly coveted.


Bully Larkin challenged the heroic youth, whose pretty face he had privately consigned to the mangling and bloody discipline he was himself so capable of administering. The quarrel, which he had himself contrived to get up, to a certain degree covered the ill blood and malignant premeditation which inspired his proceedings, and Long Ned, being full of generous ire and whiskey punch, accepted the gauge of battle on the instant. The whole party, accompanied by a mob of idle men and boys, and in short by all who could snatch a moment from the calls of business, proceeded in slow procession through the old gate into the Phoenix Park, and mounting the hill overlooking the town, selected near its summit a level spot on which to decide the quarrel.


The combatants stripped, and a child might have seen in the contrast presented by the slight, lank form and limbs of the lad, and the muscular and massive build of his veteran antagonist, how desperate was the chance of poor Ned Moran.


‘Seconds’ and ‘bottle-holders’ —selected of course for their love of the game—were appointed, and ‘the fight’ commenced.


I will not shock my readers with a description of the cool-blooded butchery that followed. The result of the combat was what anybody might have predicted. At the eleventh round, poor Ned refused to ‘give in’; the brawny pugilist, unhurt, in good wind, and pale with





---

p.134




 concentrated and as yet unslaked revenge, had the gratification of seeing his opponent seated upon his second's knee, unable to hold up his head, his left arm disabled; his face a bloody, swollen, and shapeless mass; his breast scarred and bloody, and his whole body panting and quivering with rage and exhaustion.


‘Give in, Ned, my boy,’ cried more than one of the bystanders.


‘Never, never,’ shrieked he, with a voice hoarse and choking.


Time being ‘up’, his second placed him on his feet again. Blinded with his own blood, panting and staggering, he presented but a helpless mark for the blows of his stalwart opponent. It was plain that a touch would have been sufficient to throw him to the earth. But Larkin had no notion of letting him off so easily. He closed with him without striking a blow (the effect of which, prematurely dealt, would have been to bring him at once to the ground, and so put an end to the combat), and getting his battered and almost senseless head under his arm, fast in that peculiar ‘fix’ known to the fancy pleasantly by the name of ‘chancery’, he held him firmly, while with monotonous and brutal strokes he beat his fist, as it seemed, almost into his face. A cry of ‘shame’ broke from the crowd, for it was plain that the beaten man was now insensible, and supported only by the herculean arm of the bully. The round and the fight ended by his hurling him upon the ground, falling upon him at the same time with his knee upon his chest.


The bully rose, wiping the perspiration from his white face with his blood-stained hands, but Ned lay stretched and motionless upon the grass. It was impossible to get him upon his legs for another round. So he was carried down, just as he was, to the pond which then lay close





---

p.135




 to the old Park gate, and his head and body were washed beside it. Contrary to the belief of all he was not dead. He was carried home, and after some months to a certain extent recovered. But he never held up his head again, and before the year was over he had died of consumption. Nobody could doubt how the disease had been induced, but there was no actual proof to connect the cause and effect, and the ruffian Larkin escaped the vengeance of the law. A strange retribution, however, awaited him.


After the death of Long Ned, he became less quarrelsome than before, but more sullen and reserved. Some said ‘he took it to heart’, and others, that his conscience was not at ease about it. Be this as it may, however, his health did not suffer by reason of his presumed agitations, nor was his worldly prosperity marred by the blasting curses with which poor Moran's enraged mother pursued him; on the contrary he had rather risen in the world, and obtained regular and well-remunerated employment from the Chief Secretary's gardener, at the other side of the Park. He still lived in Chapelizod, whither, on the close of his day's work, he used to return across the Fifteen Acres.


It was about three years after the catastrophe we have mentioned, and late in the autumn, when, one night, contrary to his habit, he did not appear at the house where he lodged, neither had he been seen anywhere, during the evening, in the village. His hours of return had been so very regular, that his absence excited considerable surprise, though, of course, no actual alarm; and, at the usual hour, the house was closed for the night, and the absent lodger consigned to the mercy of the elements, and the care of his presiding star. Early in the morning, however, he was found lying in a state of utter helplessness upon the slope immediately overlooking the Chapelizod





---

p.136




gate. He had been smitten with a paralytic stroke: his right side was dead; and it was many weeks before he had recovered his speech sufficiently to make himself at all understood.


He then made the following relation:—He had been detained, it appeared, later than usual, and darkness had closed before he commenced his homeward walk across the Park. It was a moonlit night, but masses of ragged clouds were slowly drifting across the heavens. He had not encountered a human figure, and no sounds but the softened rush of the wind sweeping through bushes and hollows met his ear. These wild and monotonous sounds, and the utter solitude which surrounded him, did not, however, excite any of those uneasy sensations which are ascribed to superstition, although he said he did feel depressed, or, in his own phraseology, ‘lonesome’. Just as he crossed the brow of the hill which shelters the town of Chapelizod, the moon shone out for some moments with unclouded lustre, and his eye, which happened to wander by the shadowy enclosures which lay at the foot of the slope, was arrested by the sight of a human figure climbing, with all the haste of one pursued, over the church-yard wall, and running up the steep ascent directly towards him. Stories of ‘resurrectionists’ crossed his recollection, as he observed this suspicious-looking figure. But he began, momentarily, to be aware with a sort of fearful instinct which he could not explain, that the running figure was directing his steps, with a sinister purpose, towards himself.


The form was that of a man with a loose coat about him, which, as he ran, he disengaged, and as well as Larkin could see, for the moon was again wading in clouds, threw from him. The figure thus advanced until within some two score yards of him, it arrested its





---

p.137




 speed, and approached with a loose, swaggering gait. The moon again shone out bright and clear, and, gracious God! what was the spectacle before him? He saw as distinctly as if he had been presented there in the flesh, Ned Moran, himself, stripped naked from the waist upward, as if for pugilistic combat, and drawing towards him in silence. Larkin would have shouted, prayed, cursed, fled across the Park, but he was absolutely powerless; the apparition stopped within a few steps, and leered on him with a ghastly mimicry of the defiant stare with which pugilists strive to cow one another before combat. For a time, which he could not so much as conjecture, he was held in the fascination of that unearthly gaze, and at last the thing, whatever it was, on a sudden swaggered close up to him with extended palms. With an impulse of horror, Larkin put out his hand to keep the figure off, and their palms touched—at least, so he believed—for a thrill of unspeakable agony, running through his arm, pervaded his entire frame, and he fell senseless to the earth.


Though Larkin lived for many years after, his punishment was terrible. He was incurably maimed; and being unable to work, he was forced, for existence, to beg alms of those who had once feared and flattered him. He suffered, too, increasingly, under his own horrible interpretation of the preternatural encounter which was the beginning of all his miseries. It was vain to endeavour to shake his faith in the reality of the apparition, and equally vain, as some compassionately did, to try to persuade him that the greeting with which his vision closed was intended, while inflicting a temporary trial, to signify a compensating reconciliation.


‘No, no,’ he used to say, ‘all won't do. I know the meaning of it well enough; it is a challenge to meet





---

p.138




 him in the other world—in Hell, where I am going—that's what it means, and nothing else.’


And so, miserable and refusing comfort, he lived on for some years, and then died, and was buried in the same narrow churchyard which contains the remains of his victim.


I need hardly say, how absolute was the faith of the honest inhabitants, at the time when I heard the story, in the reality of the preternatural summons which, through the portals of terror, sickness, and misery, had summoned Bully Larkin to his long, last home, and that, too, upon the very ground on which he had signalised the guiltiest triumph of his violent and vindictive career.


I recollect another story of the preternatural sort, which made no small sensation, some five-and-thirty years ago, among the good gossips of the town; and, with your leave, courteous reader, I shall relate it.


The Sexton's Adventure
----------------------


Those who remember Chapelizod a quarter of a century ago, or more, may possibly recollect the parish sexton. Bob Martin was held much in awe by truant boys who sauntered into the churchyard on Sundays, to read the tombstones, or play leap frog over them, or climb the ivy in search of bats or sparrows' nests, or peep into the mysterious aperture under the eastern window, which opened a dim perspective of descending steps losing themselves among profounder darkness, where lidless coffins gaped horribly among tattered velvet, bones, and dust, which time and mortality had strewn there. Of such horribly curious, and otherwise enterprising juveniles, Bob was, of course, the special scourge and terror. But terrible as was the official aspect of the sexton, and repugnant





---

p.139




 as his lank form, clothed in rusty, sable vesture, his small, frosty visage, suspicious grey eyes, and rusty, brown scratch-wig, might appear to all notions of genial frailty; it was yet true, that Bob Martin's severe morality sometimes nodded, and that Bacchus did not always solicit him in vain.


Bob had a curious mind, a memory well stored with ‘merry tales’, and tales of terror. His profession familiarized him with graves and goblins, and his tastes with weddings, wassail, and sly frolics of all sorts. And as his personal recollections ran back nearly three score years into the perspective of the village history, his fund of local anecdote was copious, accurate, and edifying.


As his ecclesiastical revenues were by no means considerable, he was not unfrequently obliged, for the indulgence of his tastes, to arts which were, at the best, undignified.


He frequently invited himself when his entertainers had forgotten to do so; he dropped in accidentally upon small drinking parties of his acquaintance in public houses, and entertained them with stories, queer or terrible, from his inexhaustible reservoir, never scrupling to accept an acknowledgment in the shape of hot whiskey punch, or whatever else was going.


There was at that time a certain atrabilious publican, called Philip Slaney, established in a shop nearly opposite the old turnpike. This man was not, when left to himself, immoderately given to drinking; but being naturally of a saturnine complexion, and his spirits constantly requiring a fillip, he acquired a prodigious liking for Bob Martin's company. The sexton's society, in fact, gradually became the solace of his existence, and he seemed to lose his constitutional melancholy in the fascination of his sly jokes and marvellous stories.




---

p.140


This intimacy did not redound to the prosperity or reputation of the convivial allies. Bob Martin drank a good deal more punch than was good for his health, or consistent with the character of an ecclesiastical functionary. Philip Slaney, too, was drawn into similar indulgences, for it was hard to resist the genial seductions of his gifted companion; and as he was obliged to pay for both, his purse was believed to have suffered even more than his head and liver.


Be this as it may, Bob Martin had the credit of having made a drunkard of ‘black Phil Slaney’—for by this cognomen was he distinguished; and Phil Slaney had also the reputation of having made the sexton, if possible, a ‘bigger bliggard’ than ever. Under these circumstances, the accounts of the concern opposite the turnpike became somewhat entangled; and it came to pass one drowsy summer morning, the weather being at once sultry and cloudy, that Phil Slaney went into a small back parlour, where he kept his books, and which commanded, through its dirty window-panes, a full view of a dead wall, and having bolted the door, he took a loaded pistol, and clapping the muzzle in his mouth, blew the upper part of his skull through the ceiling.


This horrid catastrophe shocked Bob Martin extremely; and partly on this account, and partly because having been, on several late occasions, found at night in a state of abstraction, bordering on insensibility, upon the high road, he had been threatened with dismissal; and, as some said, partly also because of the difficulty of finding anybody to ‘treat’ him as poor Phil Slaney used to do, he for a time forswore alcohol in all its combinations, and became an eminent example of temperance and sobriety.


Bob observed his good resolutions, greatly to the





---

p.141




 comfort of his wife, and the edification of the neighbourhood, with tolerable punctuality. He was seldom tipsy, and never drunk, and was greeted by the better part of society with all the honours of the prodigal son.


Now it happened, about a year after the grisly event we have mentioned, that the curate having received, by the post, due notice of a funeral to be consummated in the churchyard of Chapelizod, with certain instructions respecting the site of the grave, despatched a summons for Bob Martin, with a view to communicate to that functionary these official details.


It was a lowering autumn night: piles of lurid thunder-clouds, slowly rising from the earth, had loaded the sky with a solemn and boding canopy of storm. The growl of the distant thunder was heard afar off upon the dull, still air, and all nature seemed, as it were, hushed and cowering under the oppressive influence of the approaching tempest.


It was past nine o'clock when Bob, putting on his official coat of seedy black, prepared to attend his professional superior.


‘Bobby, darlin',’ said his wife, before she delivered the hat she held in her hand to his keeping, ‘sure you won't, Bobby, darlin'—you won't—you know what.’


‘I *don't* know what,’ he retorted, smartly, grasping at his hat.


‘You won't be throwing up the little finger, Bobby, acushla?’[1](javascript:footNote('E850000-001/note001.html')) she said, evading his grasp.


‘Arrah,[2](javascript:footNote('E850000-001/note002.html')) why would I, woman? there, give me my hat, will you?’


‘But won't you promise me, Bobby darlin'—won't you, alanna?[3](javascript:footNote('E850000-001/note003.html'))’


‘Ay, ay, to be sure I will—why not?—there, give me my hat, and let me go.’




---

p.142


‘Ay, but you're not promisin', Bobby, mavourneen;[4](javascript:footNote('E850000-001/note004.html')) you're not promisin' all the time.’


‘Well, divil carry me if I drink a drop till I come back again,’ said the sexton, angrily; ‘will that do you? And *now* will you give me my hat?’


‘Here it is, darlin',’ she said, ‘and God send you safe back.’


And with this parting blessing she closed the door upon his retreating figure, for it was now quite dark, and resumed her knitting till his return, very much relieved; for she thought he had of late been oftener tipsy than was consistent with his thorough reformation, and feared the allurements of the half dozen ‘publics’ which he had at that time to pass on his way to the other end of the town.


They were still open, and exhaled a delicious reek of whiskey, as Bob glided wistfully by them; but he stuck his hands in his pockets and looked the other way, whistling resolutely, and filling his mind with the image of the curate and anticipations of his coming fee. Thus he steered his morality safely through these rocks of offence, and reached the curate's lodging in safety.


He had, however, an unexpected sick call to attend, and was not at home, so that Bob Martin had to sit in the hall and amuse himself with the devil's tattoo until his return. This, unfortunately, was very long delayed, and it must have been fully twelve o'clock when Bob Martin set out upon his homeward way. By this time the storm had gathered to a pitchy darkness, the bellowing thunder was heard among the rocks and hollows of the Dublin mountains, and the pale, blue lightning shone upon the staring fronts of the houses.


By this time, too, every door was closed; but as Bob trudged homeward, his eye mechanically sought the public-house which had once belonged to Phil Slaney. 





---

p.143




A faint light was making its way through the shutters and the glass panes over the door-way, which made a sort of dull, foggy halo about the front of the house.


As Bob's eyes had become accustomed to the obscurity by this time, the light in question was quite sufficient to enable him to see a man in a sort of loose riding-coat seated upon a bench which, at that time, was fixed under the window of the house. He wore his hat very much over his eyes, and was smoking a long pipe. The outline of a glass and a quart bottle were also dimly traceable beside him; and a large horse saddled, but faintly discernible, was patiently awaiting his master's leisure.


There was something odd, no doubt, in the appearance of a traveller refreshing himself at such an hour in the open street; but the sexton accounted for it easily by supposing that, on the closing of the house for the night, he had taken what remained of his refection to the place where he was now discussing it al fresco.


At another time Bob might have saluted the stranger as he passed with a friendly ‘good night’; but, somehow, he was out of humour and in no genial mood, and was about passing without any courtesy of the sort, when the stranger, without taking the pipe from his mouth, raised the bottle, and with it beckoned him familiarly, while, with a sort of lurch of the head and shoulders, and at the same time shifting his seat to the end of the bench, he pantomimically invited him to share his seat and his cheer. There was a divine fragrance of whiskey about the spot, and Bob half relented; but he remembered his promise just as he began to waver, and said:


‘No, I thank you, sir, I can't stop to-night.’


The stranger beckoned with vehement welcome, and pointed to the vacant space on the seat beside him.


‘I thank you for your polite offer,’ said Bob, ‘but





---

p.144




 it's what I'm too late as it is, and haven't time to spare, so I wish you a good night.’


The traveller jingled the glass against the neck of the bottle, as if to intimate that he might at least swallow a dram without losing time. Bob was mentally quite of the same opinion; but, though his mouth watered, he remembered his promise, and shaking his head with incorruptible resolution, walked on.


The stranger, pipe in mouth, rose from his bench, the bottle in one hand, and the glass in the other, and followed at the sexton's heels, his dusky horse keeping close in his wake.


There was something suspicious and unaccountable in this importunity.


Bob quickened his pace, but the stranger followed close. The sexton began to feel queer, and turned about. His pursuer was behind, and still inviting him with impatient gestures to taste his liquor.


‘I told you before,’ said Bob, who was both angry and frightened, ‘that I would not taste it, and that's enough. I don't want to have anything to say to you or your bottle; and in God's name,’ he added, more vehemently, observing that he was approaching still closer, ‘fall back and don't be tormenting me this way.’


These words, as it seemed, incensed the stranger, for he shook the bottle with violent menace at Bob Martin; but, notwithstanding this gesture of defiance, he suffered the distance between them to increase. Bob, however, beheld him dogging him still in the distance, for his pipe shed a wonderful red glow, which duskily illuminated his entire figure like the lurid atmosphere of a meteor.


‘I wish the devil had his own, my boy,’ muttered the excited sexton, ‘and I know well enough where you'd be.’




---

p.145


The next time he looked over his shoulder, to his dismay he observed the importunate stranger as close as ever upon his track.


‘Confound you,’ cried the man of skulls and shovels, almost beside himself with rage and horror, ‘what is it you want of me?’


The stranger appeared more confident, and kept wagging his head and extending both glass and bottle toward him as he drew near, and Bob Martin heard the horse snorting as it followed in the dark.


‘Keep it to yourself, whatever it is, for there is neither grace nor luck about you,’ cried Bob Martin, freezing with terror; ‘leave me alone, will you.’


And he fumbled in vain among the seething confusion of his ideas for a prayer or an exorcism. He quickened his pace almost to a run; he was now close to his own door, under the impending bank by the river side.


‘Let me in, let me in, for God's sake; Molly, open the door,’ he cried, as he ran to the threshold, and leant his back against the plank. His pursuer confronted him upon the road; the pipe was no longer in his mouth, but the dusky red glow still lingered round him. He uttered some inarticulate cavernous sounds, which were wolfish and indescribable, while he seemed employed in pouring out a glass from the bottle.


The sexton kicked with all his force against the door, and cried at the same time with a despairing voice.


‘In the name of God Almighty, once for all, leave me alone.’


His pursuer furiously flung the contents of the bottle at Bob Martin; but instead of fluid it issued out in a stream of flame, which expanded and whirled round them, and for a moment they were both enveloped in a faint blaze; at the same instant a sudden gust whisked off





---

p.146




 the stranger's hat, and the sexton beheld that his skull was roofless. For an instant he beheld the gaping aperture, black and shattered, and then he fell senseless into his own doorway, which his affrighted wife had just unbarred.


I need hardly give my reader the key to this most intelligible and authentic narrative. The traveller was acknowledged by all to have been the spectre of the suicide, called up by the Evil One to tempt the convivial sexton into a violation of his promise, sealed, as it was, by an imprecation. Had he succeeded, no doubt the dusky steed, which Bob had seen saddled in attendance, was destined to have carried back a double burden to the place from whence he came.


As an attestation of the reality of this visitation, the old thorn tree which overhung the doorway was found in the morning to have been blasted with the infernal fires which had issued from the bottle, just as if a thunder-bolt had scorched it.


The moral of the above tale is upon the surface, apparent, and, so to speak, *self-acting*—a circumstance which happily obviates the necessity of our discussing it together. Taking our leave, therefore, of honest Bob Martin, who now sleeps soundly in the same solemn dormitory where, in his day, he made so many beds for others, I come to a legend of the Royal Irish Artillery, whose headquarters were for so long a time in the town of Chapelizod. I don't mean to say that I cannot tell a great many more stories, equally authentic and marvellous, touching this old town; but as I may possibly have to perform a like office for other localities, and as Anthony Poplar[5](javascript:footNote('E850000-001/note005.html')) is known,





---

p.147




 like Atropos, to carry a shears, wherewith to snip across all ‘yarns’ which exceed reasonable bounds, I consider it, on the whole, safer to despatch the traditions of Chapelizod with one tale more.


Let me, however, first give it a name; for an author can no more despatch a tale without a title, than an apothecary can deliver his physic without a label. We shall, therefore, call it—


The Spectre Lovers
------------------


There lived some fifteen years since in a small and ruinous house, little better than a hovel, an old woman who was reported to have considerably exceeded her eightieth year, and who rejoiced in the name of Alice, or popularly, Ally Moran. Her society was not much courted, for she was neither rich, nor, as the reader may suppose, beautiful. In addition to a lean cur and a cat she had one human companion, her grandson, Peter Brien, whom, with laudable good nature, she had supported from the period of his orphanage down to that of my story, which finds him in his twentieth year. Peter was a good-natured slob of a fellow, much more addicted to wrestling, dancing, and love-making, than to hard work, and fonder of whiskey punch than good advice. His grandmother had a high opinion of his accomplishments, which indeed was but natural, and also of his genius, for Peter had of late years begun to apply his mind to politics; and as it was plain that he had a mortal hatred of honest labour, his grandmother predicted, like a true fortune-teller, that he was born to marry an heiress, and Peter himself (who had no mind to forego his freedom even on such terms) that he was destined to find a pot of gold. Upon one point both agreed, that being unfitted





---

p.148




 by the peculiar bias of his genius for work, he was to acquire the immense fortune to which his merits entitled him by means of a pure run of good luck. This solution of Peter's future had the double effect of reconciling both himself and his grandmother to his idle courses, and also of maintaining that even flow of hilarious spirits which made him everywhere welcome, and which was in truth the natural result of his consciousness of approaching affluence.


It happened one night that Peter had enjoyed himself to a very late hour with two or three choice spirits near Palmerstown. They had talked politics and love, sung songs, and told stories, and, above all, had swallowed, in the chastened disguise of punch, at least a pint of good whiskey, every man.


It was considerably past one o'clock when Peter bid his companions goodbye, with a sigh and a hiccough, and lighting his pipe set forth on his solitary homeward way.


The bridge of Chapelizod was pretty nearly the midway point of his night march, and from one cause or another his progress was rather slow, and it was past two o'clock by the time he found himself leaning over its old battlements, and looking up the river, over whose winding current and wooded banks the soft moonlight was falling.


The cold breeze that blew lightly down the stream was grateful to him. It cooled his throbbing head, and he drank it in at his hot lips. The scene, too, had, without his being well sensible of it, a secret fascination. The village was sunk in the profoundest slumber, not a mortal stirring, not a sound afloat, a soft haze covered it all, and the fairy moonlight hovered over the entire landscape.


In a state between rumination and rapture, Peter continued to lean over the battlements of the old bridge, and as he did so he saw, or fancied he saw, emerging one





---

p.149




 after another along the river bank in the little gardens and enclosures in the rear of the street of Chapelizod, the queerest little white-washed huts and cabins he had ever seen there before. They had not been there that evening when he passed the bridge on the way to his merry tryst. But the most remarkable thing about it was the odd way in which these quaint little cabins showed themselves. First he saw one or two of them just with the corner of his eye, and when he looked full at them, strange to say, they faded away and disappeared. Then another and another came in view, but all in the same coy way, just appearing and gone again before he could well fix his gaze upon them; in a little while, however, they began to bear a fuller gaze, and he found, as it seemed to himself, that he was able by an effort of attention to fix the vision for a longer and a longer time, and when they waxed faint and nearly vanished, he had the power of recalling them into light and substance, until at last their vacillating indistinctness became less and less, and they assumed a permanent place in the moonlit landscape.


‘Be the hokey,’ said Peter, lost in amazement, and dropping his pipe into the river unconsciously, ‘them is the quarist bits iv mud cabins I ever seen, growing up like musharoons in the dew of an evening, and poppin' up here and down again there, and up again in another place, like so many white rabbits in a warren; and there they stand at last as firm and fast as if they were there from the Deluge; bedad it's enough to make a man a'most believe in the fairies.’


This latter was a large concession from Peter, who was a bit of a free-thinker, and spoke contemptuously in his ordinary conversation of that class of agencies.


Having treated himself to a long last stare at these mysterious fabrics, Peter prepared to pursue his homeward





---

p.150




 way; having crossed the bridge and passed the mill, he arrived at the corner of the main-street of the little town, and casting a careless look up the Dublin road, his eye was arrested by a most unexpected spectacle.


This was no other than a column of foot-soldiers, marching with perfect regularity towards the village, and headed by an officer on horseback. They were at the far side of the turnpike, which was closed; but much to his perplexity he perceived that they marched on through it without appearing to sustain the least check from that barrier.


On they came at a slow march; and what was most singular in the matter was, that they were drawing several cannons along with them; some held ropes, others spoked the wheels, and others again marched in front of the guns and behind them, with muskets shouldered, giving a stately character of parade and regularity to this, as it seemed to Peter, most unmilitary procedure.


It was owing either to some temporary defect in Peter's vision, or to some illusion attendant upon mist and moonlight, or perhaps to some other cause, that the whole procession had a certain waving and vapoury character which perplexed and tasked his eyes not a little. It was like the pictured pageant of a phantasmagoria reflected upon smoke. It was as if every breath disturbed it; sometimes it was blurred, sometimes obliterated; now here, now there. Sometimes, while the upper part was quite distinct, the legs of the column would nearly fade away or vanish outright, and then again they would come out into clear relief, marching on with measured tread, while the cocked hats and shoulders grew, as it were, transparent, and all but disappeared.


Notwithstanding these strange optical fluctuations,





---

p.151




 however, the column continued steadily to advance. Peter crossed the street from the corner near the old bridge, running on tip-toe, and with his body stooped to avoid observation, and took up a position upon the raised foot-path in the shadow of the houses, where, as the soldiers kept the middle of the road, he calculated that he might, himself undetected, see them distinctly enough as they passed.


‘What the div—, what on airth,’ he muttered, checking the irreligious ejaculation with which he was about to start, for certain queer misgivings were hovering about his heart, notwithstanding the factitious courage of the whiskey bottle. ‘What on airth is the manin' of all this? is it the French that's landed at last to give us a hand and help us in airnest to this blessed repale? If it is not them, I simply ask who the div—, I mane who on airth are they, for such sogers as them I never seen before in my born days?’


By this time the foremost of them were quite near, and truth to say they were the queerest soldiers he had ever seen in the course of his life. They wore long gaiters and leather breeches, three-cornered hats, bound with silver lace, long blue coats, with scarlet facings and linings, which latter were shewn by a fastening which held together the two opposite corners of the skirt behind; and in front the breasts were in like manner connected at a single point, where and below which they sloped back, disclosing a long-flapped waistcoat of snowy whiteness; they had very large, long cross-belts, and wore enormous pouches of white leather hung extraordinarily low, and on each of which a little silver star was glittering. But what struck him as most grotesque and outlandish in their costume was their extraordinary display of shirt-frill in front, and of ruffle about their





---

p.152




 wrists, and the strange manner in which their hair was frizzled out and powdered under their hats, and clubbed up into great rolls behind. But one of the party was mounted. He rode a tall white horse, with high action and arching neck; he had a snow-white feather in his three-cornered hat, and his coat was shimmering all over with a profusion of silver lace. From these circumstances Peter concluded that he must be the commander of the detachment, and examined him as he passed attentively. He was a slight, tall man, whose legs did not half fill his leather breeches, and he appeared to be at the wrong side of sixty. He had a shrunken, weather-beaten, mulberry-coloured face, carried a large black patch over one eye, and turned neither to the right nor to the left, but rode on at the head of his men, with a grim, military inflexibility.


The countenances of these soldiers, officers as well as men, seemed all full of trouble, and, so to speak, scared and wild. He watched in vain for a single contented or comely face. They had, one and all, a melancholy and hang-dog look; and as they passed by, Peter fancied that the air grew cold and thrilling.


He had seated himself upon a stone bench, from which, staring with all his might, he gazed upon the grotesque and noiseless procession as it filed by him. Noiseless it was; he could neither hear the jingle of accoutrements, the tread of feet, nor the rumble of the wheels; and when the old colonel turned his horse a little, and made as though he were giving the word of command, and a trumpeter, with a swollen blue nose and white feather fringe round his hat, who was walking beside him, turned about and put his bugle to his lips, still Peter heard nothing, although it was plain the sound had reached the soldiers, for they instantly changed their front to three abreast.




---

p.153


‘Botheration!’ muttered Peter, ‘is it deaf I'm growing?’


But that could not be, for he heard the sighing of the breeze and the rush of the neighbouring Liffey plain enough.


‘Well,’ said he, in the same cautious key, ‘by the piper, this bangs Banagher fairly! It's either the Frinch army that's in it, come to take the town iv Chapelizod by surprise, an' makin' no noise for feard iv wakenin' the inhabitants; or else it's—it's—what it's—somethin' else. But, tundher-an-ouns, what's gone wid Fitzpatrick's shop across the way?’


The brown, dingy stone building at the opposite side of the street looked newer and cleaner than he had been used to see it; the front door of it stood open, and a sentry, in the same grotesque uniform, with shouldered musket, was pacing noiselessly to and fro before it. At the angle of this building, in like manner, a wide gate (of which Peter had no recollection whatever) stood open, before which, also, a similar sentry was gliding, and into this gateway the whole column gradually passed, and Peter finally lost sight of it.


‘I'm not asleep; I'm not dhramin',’ said he, rubbing his eyes, and stamping slightly on the pavement, to assure himself that he was wide awake. ‘It is a quare business, whatever it is; an' it's not alone that, but everything about town looks strange to me. There's Tresham's house new painted, bedad, an' them flowers in the windies! An' Delany's house, too, that had not a whole pane of glass in it this morning, and scarce a slate on the roof of it! It is not possible it's what it's dhrunk I am. Sure there's the big tree, and not a leaf of it changed since I passed, and the stars overhead, all right. I don't think it is in my eyes it is.’




---

p.154


And so looking about him, and every moment finding or fancying new food for wonder, he walked along the pavement, intending, without further delay, to make his way home.


But his adventures for the night were not concluded. He had nearly reached the angle of the short lane that leads up to the church, when for the first time he perceived that an officer, in the uniform he had just seen, was walking before, only a few yards in advance of him.


The officer was walking along at an easy, swinging gait, and carried his sword under his arm, and was looking down on the pavement with an air of reverie.


In the very fact that he seemed unconscious of Peter's presence, and disposed to keep his reflections to himself, there was something reassuring. Besides, the reader must please to remember that our hero had a quantum sufficit of good punch before his adventure commenced, and was thus fortified against those qualms and terrors under which, in a more reasonable state of mind, he might not impossibly have sunk.


The idea of the French invasion revived in full power in Peter's fuddled imagination, as he pursued the nonchalant swagger of the officer.


‘Be the powers iv Moll Kelly, I'll ax him what it is,’ said Peter, with a sudden accession of rashness. ‘He may tell me or not, as he plases, but he can't be offinded, anyhow.’


With this reflection having inspired himself, Peter cleared his voice and began—


‘Captain!’ said he, ‘I ax your pardon, captain, an' maybe you'd be so condescindin' to my ignorance as to tell me, if it's plasin' to yer honour, whether your honour is not a Frinchman, if it's plasin' to you.’


This he asked, not thinking that, had it been as he





---

p.155




 suspected, not one word of his question in all probability would have been intelligible to the person he addressed. He was, however, understood, for the officer answered him in English, at the same time slackening his pace and moving a little to the side of the pathway, as if to invite his interrogator to take his place beside him.


‘No; I am an Irishman,’ he answered.


‘I humbly thank your honour,’ said Peter, drawing nearer—for the affability and the nativity of the officer encouraged him—‘but maybe your honour is in the *sarvice* of the King of France?’


‘I serve the same King as you do,’ he answered, with a sorrowful significance which Peter did not comprehend at the time; and, interrogating in turn, he asked, ‘But what calls you forth at this hour of the day?’


‘The *day,* your honour!—the night, you mane.’


‘It was always our way to turn night into day, and we keep to it still,’ remarked the soldier. ‘But, no matter, come up here to my house; I have a job for you, if you wish to earn some money easily. I live here.’


As he said this, he beckoned authoritatively to Peter, who followed almost mechanically at his heels, and they turned up a little lane near the old Roman Catholic chapel, at the end of which stood, in Peter's time, the ruins of a tall, stone-built house.


Like everything else in the town, it had suffered a metamorphosis. The stained and ragged walls were now erect, perfect, and covered with pebble-dash; window-panes glittered coldly in every window; the green hall-door had a bright brass knocker on it. Peter did not know whether to believe his previous or his present impressions; seeing is believing, and Peter could not dispute the reality of the scene. All the records of his memory seemed but the images of a tipsy dream. In a





---

p.156




 trance of astonishment and perplexity, therefore, he submitted himself to the chances of his adventure.


The door opened, the officer beckoned with a melancholy air of authority to Peter, and entered. Our hero followed him into a sort of hall, which was very dark, but he was guided by the steps of the soldier, and, in silence, they ascended the stairs. The moonlight, which shone in at the lobbies, showed an old, dark wainscoting, and a heavy, oak banister. They passed by closed doors at different landing-places, but all was dark and silent as, indeed, became that late hour of the night.


Now they ascended to the topmost floor. The captain paused for a minute at the nearest door, and, with a heavy groan, pushing it open, entered the room. Peter remained at the threshold. A slight female form in a sort of loose, white robe, and with a great deal of dark hair hanging loosely about her, was standing in the middle of the floor, with her back towards them.


The soldier stopped short before he reached her, and said, in a voice of great anguish, ‘Still the same, sweet bird—sweet bird! still the same.’ Whereupon, she turned suddenly, and threw her arms about the neck of the officer, with a gesture of fondness and despair, and her frame was agitated as if by a burst of sobs. He held her close to his breast in silence; and honest Peter felt a strange terror creep over him, as he witnessed these mysterious sorrows and endearments.


‘To-night, to-night—and then ten years more—ten long years—another ten years.’


The officer and the lady seemed to speak these words together; her voice mingled with his in a musical and fearful wail, like a distant summer wind, in the dead hour of night, wandering through ruins. Then he heard the officer say, alone, in a voice of anguish—




---

p.157


‘Upon me be it all, for ever, sweet birdie, upon me.’


And again they seemed to mourn together in the same soft and desolate wail, like sounds of grief heard from a great distance.


Peter was thrilled with horror, but he was also under a strange fascination; and an intense and dreadful curiosity held him fast.


The moon was shining obliquely into the room, and through the window Peter saw the familiar slopes of the Park, sleeping mistily under its shimmer. He could also see the furniture of the room with tolerable distinctness—the old balloon-backed chairs, a four-post bed in a sort of recess, and a rack against the wall, from which hung some military clothes and accoutrements; and the sight of all these homely objects reassured him somewhat, and he could not help feeling unspeakably curious to see the face of the girl whose long hair was streaming over the officer's epaulet.


Peter, accordingly, coughed, at first slightly, and afterward more loudly, to recall her from her reverie of grief; and, apparently, he succeeded; for she turned round, as did her companion, and both, standing hand in hand, gazed upon him fixedly. He thought he had never seen such large, strange eyes in all his life; and their gaze seemed to chill the very air around him, and arrest the pulses of his heart. An eternity of misery and remorse was in the shadowy faces that looked upon him.


If Peter had taken less *whiskey* by a single thimbleful, it is probable that he would have lost heart altogether before these figures, which seemed every moment to assume a more marked and fearful, though hardly definable, contrast to ordinary human shapes.


‘What is it you want with me?’ he stammered.


‘To bring my lost treasure to the churchyard,’





---

p.158




 replied the lady, in a silvery voice of more than mortal desolation.


The word ‘treasure’ revived the resolution of Peter, although a cold sweat was covering him, and his hair was bristling with horror; he believed, however, that he was on the brink of fortune, if he could but command nerve to brave the interview to its close.


‘And where,’ he gasped, ‘is it hid—where will I find it?’


They both pointed to the sill of the window, through which the moon was shining at the far end of the room, and the soldier said—


‘Under that stone.’


Peter drew a long breath, and wiped the cold dew from his face, preparatory to passing to the window, where he expected to secure the reward of his protracted terrors. But looking steadfastly at the window, he saw the faint image of a new-born child sitting upon the sill in the moonlight, with its little arms stretched toward him, and a smile so heavenly as he never beheld before.


At sight of this, strange to say, his heart entirely failed him, he looked on the figures that stood near, and beheld them gazing on the infantine form with a smile so guilty and distorted, that he felt as if he were entering alive among the scenery of hell, and shuddering, he cried in an irrepressible agony of horror—


‘I'll have nothing to say with you, and nothing to do with you; I don't know what yez are or what yez want iv me, but let me go this minute, every one of yez, in the name of God.’


With these words there came a strange rumbling and sighing about Peter's ears; he lost sight of everything, and felt that peculiar and not unpleasant sensation of falling softly, that sometimes supervenes in sleep, ending





---

p.159




 in a dull shock. After that he had neither dream nor consciousness till he wakened, chill and stiff, stretched between two piles of old rubbish, among the black and roofless walls of the ruined house.


We need hardly mention that the village had put on its wonted air of neglect and decay, or that Peter looked around him in vain for traces of those novelties which had so puzzled and distracted him upon the previous night.


‘Ay, ay,’ said his grandmother, removing her pipe, as he ended his description of the view from the bridge, ‘sure enough I remember myself, when I was a slip of a girl, these little white cabins among the gardens by the river side. The artillery sogers that was married, or had not room in the barracks, used to be in them, but they're all gone long ago.’


‘The Lord be merciful to us!’ she resumed, when he had described the military procession, ‘it's often I seen the regiment marchin' into the town, jist as you saw it last night, acushla. Oh, voch, but it makes my heart sore to think iv them days; they were pleasant times, sure enough; but is not it terrible, avick[6](javascript:footNote('E850000-001/note006.html')), to think it's what it was the ghost of the rigiment you seen? The Lord betune us an' harm, for it was nothing else, as sure as I'm sittin' here.’


When he mentioned the peculiar physiognomy and figure of the old officer who rode at the head of the regiment—


‘*That,*’ said the old crone, dogmatically, ‘was ould Colonel Grimshaw, the Lord presarve us! he's buried in the churchyard iv Chapelizod, and well I remember him, when I was a young thing, an' a cross ould floggin' fellow he was wid the men, an' a devil's boy among the girls—rest his soul!’


‘Amen!’ said Peter; ‘it's often I read his tombstone myself; but he's a long time dead.’




---

p.160


‘Sure, I tell you he died when I was no more nor a slip iv a girl—the Lord betune us and harm!’


‘I'm afeard it is what I'm not long for this world myself, afther seeing such a sight as that,’ said Peter, fearfully.


‘Nonsinse, avourneen,’ retorted his grandmother, indignantly, though she had herself misgivings on the subject; ‘sure there was Phil Doolan, the ferryman, that seen black Ann Scanlan in his own boat, and what harm ever kem of it?’


Peter proceeded with his narrative, but when he came to the description of the house, in which his adventure had had so sinister a conclusion, the old woman was at fault.


‘I know the house and the ould walls well, an' I can remember the time there was a roof on it, and the doors an' windows in it, but it had a bad name about being haunted, but by who, or for what, I forget intirely.’


‘Did you ever hear was there goold or silver there?’ he inquired.


‘No, no, avick, don't be thinking about the likes; take a fool's advice, and never go next or near them ugly black walls again the longest day you have to live; an' I'd take my davy, it's what it's the same word the priest himself id be afther sayin' to you if you wor to ax his raverence consarnin' it, for it's plain to be seen it was nothing good you seen there, and there's neither luck nor grace about it.’


Peter's adventure made no little noise in the neighbourhood, as the reader may well suppose; and a few evenings after it, being on an errand to old Major Vandeleur, who lived in a snug old-fashioned house, close by the river, under a perfect bower of ancient trees, he was called on to relate the story in the parlour.




---

p.161


The Major was, as I have said, an old man; he was small, lean, and upright, with a mahogany complexion, and a wooden inflexibility of face; he was a man, besides, of few words, and if *he* was old, it follows plainly that his mother was older still. Nobody could guess or tell *how* old, but it was admitted that her own generation had long passed away, and that she had not a competitor left. She had French blood in her veins, and although she did not retain her charms quite so well as Ninon de l'Enclos, she was in full possession of all her mental activity, and talked quite enough for herself and the Major.


‘So, Peter,’ she said, ‘you have seen the dear, old Royal Irish again in the streets of Chapelizod. Make him a tumbler of punch, Frank; and Peter, sit down, and while you take it let us have the story.’


Peter accordingly, seated, near the door, with a tumbler of the nectarian stimulant steaming beside him, proceeded with marvellous courage, considering they had no light but the uncertain glare of the fire, to relate with minute particularity his awful adventure. The old lady listened at first with a smile of good-natured incredulity; her cross-examination touching the drinking-bout at Palmerstown had been teazing, but as the narrative proceeded she became attentive, and at length absorbed, and once or twice she uttered ejaculations of pity or awe. When it was over, the old lady looked with a somewhat sad and stern abstraction on the table, patting her cat assiduously meanwhile, and then suddenly looking upon her son, the Major, she said—


‘Frank, as sure as I live he has seen the wicked Captain Devereux.’[7](javascript:footNote('E850000-001/note007.html'))


The Major uttered an inarticulate expression of wonder.




---

p.162


‘The house was precisely that he has described. I have told you the story often, as I heard it from your dear grandmother, about the poor young lady he ruined, and the dreadful suspicion about the little baby. *She*, poor thing, died in that house heart-broken, and you know he was shot shortly after in a duel.’


This was the only light that Peter ever received respecting his adventure. It was supposed, however, that he still clung to the hope that treasure of some sort was hidden about the old house, for he was often seen lurking about its walls, and at last his fate overtook him, poor fellow, in the pursuit; for climbing near the summit one day, his holding gave way, and he fell upon the hard uneven ground, fracturing a leg and a rib, and after a short interval died, and he, like the other heroes of these true tales, lies buried in the little churchyard of Chapelizod.














