

#Captain Cuellar's Adventures in Connacht and Ulster


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Captain Cuellar's Adventures in Connacht and Ulster
===================================================


Author: Francisco de Cuellar
----------------------------


### File Description

Robert Crawfordtranslated by Robert Crawford

Electronic edition compiled by Benjamin Hazard

Funded by University College, Cork and  
Higher Education Authority via the CELT Project 3. Third draft.Extent of text: 12980 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2003) (2008) (2011) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T108200Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching
only.


#### Sources


1. Madrid, La Real Academia de la Historia, Colección Salazar, número. 7, fólio 58.
**Editions and Translations**2. C. Fernández Duro (ed.), La Armada Invencible por el Capitan de Navío de la Real Academia de la Historia, Est. Tipográfico 'Sucesores de Rivadeneyra' 2 vols. (Madrid 1884-–5).
3. J. P. O'Reilly, 'Remarks on certain passages in Captain Cuellar's narrative on his adventures in Ireland after the wreck of the Spanish Armada in 1588–89, followed by a literal translation of that narrative', in Proceedings of the Royal Irish Academy, section C (Dublin 1893), 175–217.
4. H. D. Sedgwick, A letter to his majesty King Philip II of Spain (New York 1895).
5. H. Allingham, Captain Cuellar's adventures in Connacht and Ulster, 1588 AD, to which is added an Introduction and complete translation of Captain Cuellar's narrative of the Spanish Armada, by Robert Crawford (London 1897).
6. H. Allingham and R. Crawford (ed. and transl.), The Spanish Armada: Captain Cuellar's adventures in Connacht and Ulster, a picture of the times drawn from contemporary sources, reprinted to commemorate the 400th anniversary of the wrecking of three vessels on Streedagh Strand (Sligo 1988).
7. B. Clifford (ed.), A story of the Spanish Armada by Captain Francisco de Cuellar, with additional material by various authors (Belfast 1988).
8. P. Gallagher and D.W. Cruickshank (eds.), God's obvious design: papers for the Spanish Armada Symposium, Sligo 1988, with an edition and translation of the account of Francisco de Cuellar (London 1990).
**Secondary Literature (General Reading)**2. H. Allingham, 'The Spanish in Ulster and Connacht' in: The Ulster Journal of Archaeology, vol. 1, part 3 (1895).
3. Enrique Herrera Oria, La Armada Invencible, 1587–1589. Documentos procedentes del Archivo General de Simancas, 1587–9. Archivo Documental Espanol, II (Valladolid 1929).
4. Gabriel Maura Gamazo, Duque de Maura, El Designio de Felipe II y el Episodio de la Armada Invencible (Madrid 1957).
5. G. Mattingly, The Defeat of the Spanish Armada (London 1959).
6. R. Sténuit, Treasures of the Armada (London 1972).
7. E. Grierson, King of Two Worlds (London 1974).
8. N. Fallon, The Armada in Ireland (London 1978).
9. F. Fernández-Armesto, The Spanish Armada: the experience of war in 1588 (Oxford 1988).
10. C. Martin and G. Parker, The Spanish Armada (London 1988).
11. N. A. M. Rodger (ed.), The Armada in the Public Records (London 1988).
12. Carlos Gómez-Centurión Jiménez, Felipe II, La Empresa de Inglaterra y el Comercio Septentrional 1566–1609 (Madrid 1988).
13. Gonzalo Parente, Hugo O'Donnell, Francisco Fernández Segado, María del Carmen Couceiro, María de la Asunción Armada, Los Sucesos de Flandes de 1588 en relación con la empresa de Inglaterra (Madrid 1988).
14. José Luis Casado Soto, Los barcos espa�oles del siglo XVI y la Gran Armada de 1588 (Madrid 1988).
15. Carlos Gómez-Centurión Jiménez, La Invencible y la Empresa de Inglaterra (Madrid 1988).
16. María José Rodríguez Salgado, 'Pilotos y navegación en la Gran Armada de 1588', Revista de Historia Naval 23 (1988), 37–71.
17. J. H. Elliott, Spain and its World: 1500–1700 (Yale 1989).
18. Hugo José O'Donnell y Duque de Estrada, La fuerza de desembarco de la Gran Armada contra Inglaterra (1588). Su origen, organización y vicisitudes (Madrid 1989).
19. Manuel Gracia Rivas, Los Tercios de la Gran Armada, 1587–1588 (Madrid 1989).
20. K. R. Andrews, Trade, plunder and settlement: maritime enterprise and the genesis of the British Empire, 1480–1630 (Cambridge 1991).
21. R. Bonney, Richard, The European dynastic states: 1494–1660 (Oxford 1991).
22. R. A. Stradling, The Armada of Flanders (Cambridge 1992).
23. H. Kamen, Spain: 1469–1714: A society in conflict (London 1993).
24. W. MacCaffrey, Elizabeth I (London 1993).
25. A. G. R. Smith, The Emergence of a Nation State: The commonwealth of England, 1529–1660 (London 1993).
26. J. Lynch, The Hispanic World in crisis and change (Oxford 1994).
27. Enrique García Hernán, La Armada Espa�ola en la Monarquía de Felipe II y la Defensa del Mediterráneo (Madrid 1995).
28. G. Parker, The Grand Strategy of Philip II (Yale 1998).
29. Hiram Morgan, 'Spanish Armadas and Ireland, 1588–1602' in: Luc François and Ann Katherine Isaacs (eds.), The Sea in European History (Pisa 2001).
30. Enrique García Hernán, 'Planes militares de Felipe II para la conquista de Irlanda', in: García Hernán et al. (eds.), Irlanda y la Monarquía Hispánica: Kinsale, 1601–2001. Guerra, Política, Exilio y Religión (Madrid 2002) 185–204.
31. Enrique García Hernán, Irlanda y el rey Prudente, 2 vols. (Madrid 1999–2003).
32. Enrique García Hernán, 'Philip II's Forgotten Armada' in: Hiram Morgan (ed.), The Battle of Kinsale (Dublin 2004) 45–58.
33. Enrique García Hernán, 'La Jornada de Smerwick y sus consecuencias (1579–1588)', in: García Hernán and Recio Morales (eds.), Extranjeros en el Ejército. Militares irlandeses en la sociedad española, 1580–1818 = Essays on the Irish military presence in Early-Modern Spain, 1580–1818 (Madrid 2007) 113–133.
34. Enrique García Hernán, Davide Maffi (eds), Guerra y sociedad en la Monarquía Hispánica. Política, estrategia y cultura en la Europa moderna, 1500–1700 (2 vols. Madrid 2007).
35. Enrique García Hernán, Ireland and Spain in the Reign of Philip II, translated by Liam Liddy and revised by the author (Dublin 2009).
36. Manuel Gracia Rivas, La Sanidad en la jornada de Inglaterra 1587–1588 (Madrid 1988).
37. For a contemporary description of the Spanish Armada by Irish scribes, see the Annals of Loch Cé entry 1588.19 http://www.celt.ucc.ie/published/T100010B/).
**The edition used in the digital edition**2. Captain Cuellar's narrative of the Spanish Armada and of his wanderings and adventures in Ireland. Robert Crawford (ed), First editionElliott StockLondon (1897)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present electronic text represents pages 17–39 of Brendan Clifford's reprint of Hugh Allingham's edition. The letter has appeared in seven modern printed editions since the late nineteenth century. According to Robert Crawford in the Introduction to his translation, there is no evidence to support Henry Sedgwick's assumption that it was originally written to Philip II. This error must, he writes, "have arisen from some misconception as to the meaning of the abbreviations made use of in Spanish epistolary correspondence... Mr Sedgwick has apparently mistaken the initials V.m., which stand for 'Vuestra merced', for V.M. meaning 'Vuestra Majestad' ", and the informal style of the letter "was certainly not such as a captain of the Spanish navy would address to his Sovereign".


#### Editorial Declaration


##### Correction


Text has been proof-read twice.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is marked q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the letter.


##### Interpretation


Names of persons (given names), and places are tagged. Terms for cultural and social roles are not tagged.


### Profile Description


Created: Translation by Robert Crawford
 (1896) #### Use of language


##### Language: [EN] The text is in English.


### Revision History


* (2011-12-07) Beatrix Färber (ed.)

* Additions made to bibliographical details. These were kindly supplied by Benjamin Hazard, UCD.
* (2011-11-11) Beatrix Färber (ed.)

* Bibliographical details updated. These were kindly supplied by Michael White, Universidad Complutense, Madrid, and Benjamin Hazard, UCD.
* (2011-01-22) Beatrix Färber (ed.)

* Minor modifications made to header; new wordcount made.
* (2008-09-07) Beatrix Färber (ed.)

* Keywords added, file validated.
* (2008-07-27) Beatrix Färber (ed.)

* Title elements streamlined.
* (2008-07-18) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, 'creation' tags inserted, content of 'langUsage' revised.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:39:00+0100) Peter Flynn (ed.)

* Converted to XML
* (2004-03-24) Benjamin Hazard (ed.)

* Additions to the bibliography and minor changes to the file.
* (2003-11-20) Beatrix Färber (ed.)

* Wordcount; minor modifications to header; HTML file created.
* (2003-11-19) Benjamin Hazard (ed.)

* Text parsed using NSGMLS.
* (2003-11-14) Benjamin Hazard (ed.)

* Header constructed, structural and content mark-up applied, text proof-read (2).
* (2003-11-12) Benjamin Hazard (ed.)

* Bibliography compiled.
* (2003-11-10) Benjamin Hazard (ed.)

* Text captured by scanning and proof-read (1).




---


#### Corpus of Electronic Texts Edition: T108200


### Captain Cuellar's Adventures in Connacht and Ulster: Author: Francisco de Cuellar


Francisco de Cuellar was aboard the last group of Armada ships wrecked in Ireland, on 25 September 1588. He came ashore at Streedagh strand, north of Sligo Bay, territory controlled by the O'Conors. Moving on into Leitrim he met with Brian O'Rourke of Breffni, before staying at the McClancy castle at Rossclogher for three months. He then went to the place where ‘Alonzo de Leya y el Conde de Paredes y Don Tomas de Granvela’ were lost, which is taken to be Dunluce Castle on the north coast of Antrim, east of Portrush. Then, in search of passage to Scotland, he went to the territory of O'Cahan around Coleraine. His use of the term ‘savage’ to describe the Irish should not necessarily be regarded as pejorative. Inhabitants of Galicia in Spain were referred to in the same way by contemporaries. Although written ‘with emotion recollected in tranquility’, this eye-witness account of Gaelic life makes Francisco de Cuellar's letter a most valuable social document of the period.


Hugh Allingham and Robert Crawford (Ballyshannon 1897), from Cuellar's descriptions.


---

p.17


I believe that you will be astonished at seeing this letter on account of the slight certainty that could have existed as to my being alive. That you may be quite sure of this I write it *the letter,*and at some length, for which there is sufficient reason in the great hardships and misfortunes I have passed through since the Armada sailed from Lisbon for England, from which our Lord, in His infinite good pleasure, delivered me.
As I have not had an opportunity to write to you for more than a year, I have not done so until now that God has brought me to these States of Flanders, where I arrived twelve days ago with the Spaniards who escaped from the ships that were lost in Ireland, Scotland, and Shetland, which were more than twenty of the largest in the Armada.
In them came a great force of picked infantry, many captains, ensigns, commanders, and other war officials, besides several gentlemen and scions of nobility, out of all of whom, being more than two hundred, not five survived; because some of them were drowned, and those who reached the shore by swimming were cut in pieces by the English, whom the Queen keeps quartered in the Kingdom of Ireland.


I escaped from the sea and from these enemies by having commended myself very earnestly to our Lord, and to the Most Holy Virgin, His Mother; and with me three hundred and odd soldiers, who also knew how to save themselves and to swim to shore. With them I experienced great misfortunes: naked and shoeless all the winter: passing more than seven months among


---

p.18



mountains and woods with savages, which they all are in those parts of Ireland where we were shipwrecked.
I think it is not right to omit to narrate to you, or to keep back, the injuries and the great insults that it was sought to inflict upon me, so wrongfully, and without my having committed the fault of neglecting to do my duty, from which our Lord delivered me.


Having been condemned to death, as you will have known, and so ignominiously, and seeing the severity with which the order for execution was given, I demanded, with much spirit and anger, why they inflicted upon me so great an insult and dishonour, I having served the King as a good soldier and loyal subject of his on all occasions and in the encounters which we had with the fleet of the enemy, from which the galleon I commanded always came out of action very badly injured, and with many people killed and wounded.
In it (my demand) I requested that a copy of the order should be given me, and that a judicial inquiry should be made of the three hundred and fifty men who were on board the galleon, and if any one of them considered me to blame they might quarter me.
They did not wish to listen to me, nor to many gentlemen who interceded on my behalf, replying that the Duke was then in retirement, and very morose, and unwilling that any one should speak with him; because, in addition to the miserable success which he always had with the enemy, on the day of my trouble he was informed that the two galleons—San Mateo and San Felipe—of those from Portugal, in which were the two commanders, Don Francisco de Toledo, brother of the Count of Orgaz, and Don Diego Pimentel, brother of the Marquis de Tavara, were lost in the sea, and most of those they carried were cut to pieces and dead.
On this account the Duke kept to his cabin, and the councillors, to make up for his perversity, did wrongs, right and left, on the lives and reputations of blameless persons; and this is so public that every one knows it.


The galleon San Pedro, in which I sailed, received much injury from many heavy cannon balls, which the enemy lodged in her in various parts; and although they were repaired as well as possible at the time, there were still some hidden shot-holes through which much water entered.
After the fierce engagement we had off Calais on the 8th of August, continuing from morning till seven o'clock in the evening—which was the last of all—our Armada being in the act of retiring—oh! I don't know how I can say it—the fleet of our enemy followed behind to drive us from their country; and when it was accomplished, and everything was safe, which was on the 10th of the same *month*, seeing that the enemy had stopped *ceased to follow*, some of the ships of our Armada trimmed up and repaired their damages.
On this day, for my great sins, I was resting for a little, as for ten days I had not slept nor ceased to assist at whatever was necessary for me,—a pilot


---

p.19


*mate*, a bad man whom I had, without saying anything to me, made sail and passed out in advance of the admiral's ship for about two miles, as other ships had done, in order to effect repairs.


When about to lower sails, to see where the galleon was leaking, a tender came alongside and summoned me, on the part of the Duke, to go on board the admiral's ship. I proceeded thither; but before I reached her, orders were given in another ship that I and another gentleman, who was named Don Cristobal de Avila, who went as captain of a store-ship—which was far ahead of my galleon—should be put to death in a most ignominious manner.
When I heard of this severity, I thought I should have burst with passion, saying that all should bear me witness of the great wrong done to me, I having served so well, as could be seen by written document.
The Duke heard nothing of all this, because, as I say, he was in retirement.


Senor Don Francisco Bovadilla alone was he who ordered and countermanded in the Armada; and by him, and others, whose evil deeds are well known, all was managed.
He ordered me to be taken to the ship of the Judge Advocate General, that his advice should be carried out on me. I went there; and although he was severe, the Judge Advocate—Martin de Aranda, for so they called him—heard me, and obtained confidential information concerning me. He discovered that I had served His Majesty as a good soldier, for which reason he did not venture to carry out on me the order that had been given him. He wrote to the Duke about it, that if he did not order him in writing, and signed by his own hand, he would not execute that order, because he saw that I was not in fault, nor was there cause for it.
Accompanying it, I wrote a letter to the Duke of such a nature that it made him consider the affair carefully, and he replied to the Judge Advocate that he should not execute the order upon me, but on Don Cristobal, whom they hanged with great cruelty and ignominy, being a gentleman and well known.
God was pleased to deliver me because I was not in fault, which you will be able to know well, or will have known from many persons who saw it *eye-witnesses*. The said Judge Advocate was always very courteous to me, because of the great respect he had for those who were in the right.


I remained in his ship, in which we were in imminent danger of death, because she opened so much with a storm which sprang up that she continually filled with water, and we could not dry her out with the pumps. We had neither remedy nor succour, except it was from God; for the Duke still did not appear, and all the Armada proceeded, scattered in such manner by the storm that some ships went to Germany, others drove on the islands of Holland and Zealand into the enemies' hands, others went to Shetland, others to Scotland, where they were lost and burned. More than twenty were lost in the Kingdom of Ireland, with all the chivalry and flower of the Armada.




---

p.20


As I have said, the ship I sailed in was from the Levant, to which were attached two others, very large, to afford us aid if they could.
In these came Don Diego Enriquez, ‘the hunchback’, as commander; and not being able to weather *round or double* Cape Clear, in Ireland, on account of the severe storm which arose upon the bow, he was forced to make for the land with these three ships, which, as I say, were of the largest size, and to anchor more than half a league from the shore, where we remained for four days without being able to make any provision, nor could it even be made.
On the fifth *day* there sprang up so great a storm on our beam, with a sea up to the heavens, so that the cables could not hold nor the sails serve us, and we were driven ashore with all three ships upon a beach, covered with very fine sand, shut in on one side and the other by great rocks.
Such a thing was never seen: for within the space of an hour all three ships were broken in pieces, so that there did not escape three hundred men, and more than one thousand were drowned, among them many persons of importance, captains, gentlemen, and other officials.


Don Diego Enriquez died there one of the saddest deaths that has ever been seen in the world.
In consequence of fearing the very heavy sea that was washing over the highest part of the wrecks, he took his ship's boat that was decked, and he and the son of the Count of Villa Franca and two other Portuguese gentlemen, with more than sixteen thousand ducats, in jewels and crown-pieces, placed themselves under the deck of the said boat, and gave the order to close and caulk the hatchway by which they had entered.
Thereupon more than seventy men, who had remained alive, jumped from the ship to the boat, and while she was making for the land so great a wave washed over her that she sank, and all on deck were swept away.
Then she drifted along, rolling over in different directions with the waves, until she went ashore, where she settled wrong side up, and by these mischances the gentlemen who had placed themselves under the deck died within.


More than a day and a half after she had grounded, some savages arrived, who turned her up for the purpose of extracting nails or pieces of iron; and, breaking through the deck, they drew out the dead men.
Don Diego Enriquez expired in their hands, and they stripped him, and took away the jewels and money which they (the dead men) had, casting the bodies aside without burying them.
And because it is a wonderful occurrence, and true without doubt (of a certainty), I have wished to narrate it to you in order that it may be known there (on your side) the manner in which this gentleman died.
And as it would not be right to omit to mention my own good fortune, and how I got to land, I say that I placed myself on the top of the poop of my ship, after having commended myself to God and to Our Lady, and from thence I gazed at the terrible spectacle.


Many were drowning within the ships; others, casting themselves into the water, sank to the bottom without returning to the surface;


---

p.21



others on rafts and barrels, and gentlemen on pieces of timber, others cried aloud in the ships, calling upon God; captains threw their chains and crown-pieces into the sea; the waves swept others away, washing them out of the ships.
While I was regarding this solemn scene, I did not know what to do, nor what means to adopt, as I did not know how to swim, and the waves and storm were very great; and, on the other hand, the land and the shore were full of enemies, who went about jumping and dancing with delight at our misfortunes; and when any one of our people reached the beach, two hundred savages and other enemies fell upon him and stripped him of what he had on until he was left in his naked skin. Such they maltreated and wounded without pity, all of which was plainly visible from the battered ships, and it did not seem to me that there was anything good happening on any side.
I went to the Judge Advocate— God pardon him!—he was very sorrowful and depressed, and I said to him that he should make some provision for saving his life before the ship went to pieces, as she could not last for half a quarter of an hour longer; nor did she last it.
Most of her complement of men and all the captains and officers were already drowned and dead when I determined to seek means of safety for my life, and placed myself upon a piece of the ship that had been broken off, and the


---

p.22



Judge Advocate followed me, loaded with crown-pieces, which he carried stitched up in his waistcoat and trousers.
There was no way to detach the portion of wreck from the ship's side, as it was held fast by some heavy iron chains, and the sea and the pieces of timber floating about loose struck it, nearly killing us.


I managed to find another resource, which was to take the cover of a hatchway, about as large as a good-sized table, that by chance the mercy of God brought to my hand. When I tried to place myself upon it, it sank with me to a depth of six times my height below the surface, and I swallowed so much water that I was nearly drowned.
When I came up again, I called to the Judge Advocate, and I managed to get him upon the hatchway cover with myself. In the act of casting-off from the ship, there came a huge wave, breaking over us in such a manner that the Judge Advocate was unable to resist it, and the wave bore him away and drowned him, crying out and calling upon God while drowning.
I could not aid him, as the hatchway cover, being without weight at one end, began to turn over with me, and at that moment a piece of timber crushed my legs.
With great exertion I righted myself upon my supporting timber; and, supplicating Our Lady of Ontanar, there came four waves, one after the other, and, without knowing how, or knowing how to swim, they cast me upon the shore, where I emerged, unable to stand, all covered with blood, and very much injured.


The enemies and savages, who were on the beach stripping those who had been able to reach it by swimming, did not touch me nor approach me, seeing me, as I have said, with my legs and hands and my linen trousers covered with blood. In this condition I proceeded, little by little, as I could, meeting many Spaniards stripped to the skin, without any kind of clothing whatsoever upon them, chattering with the cold, which was severe, and thus I stopped for the night in a deserted place, and was forced to lie down upon some rushes on the ground, with the great pain I suffered in my leg.
Presently a gentleman came up to me, a very nice young fellow, quite naked, and he was so dazed that he could not speak, not even to tell me who he was; and at that time, which would be about nine o'clock at night, the wind was calm and the sea subsiding. I was then wet through to the skin, dying with pain and hunger, when there came up two people—one of them armed, and the other with a large iron axe in his hands—and upon reaching me and the other *man* who was with me, we remained silent, as if we had not anything amiss *with us*. They were sorry to see us; and without speaking a word to us, cut a quantity of rushes and grass, covered us well, and then betook themselves to the shore to plunder and break open money-chests and whatever they might find, at which work more than two thousand savages and Englishmen, who were stationed in garrisons near there, took part.


---

p.23



Managing to rest a little, I began to doze; and when fast asleep, at about one o'clock in the night, I was disturbed by a great noise of men on horseback—there were more than two hundred of them—who were going to plunder and destroy the ships. I turned to call my companion, to see if he slept, and found he was dead, which occasioned me great affliction and grief. I got to know afterwards that he was a man of position. There he lay on the ground with more than six hundred other dead bodies which the sea cast up, and the crows and wolves devoured them, without there being any one to bury them: not even poor Don Diego Enriquez.


At the dawn of day I began to walk, little by little, searching for a monastery of monks, that I might repair to it *or might recover in it* as best I could, which I arrived at with much trouble and toil. I found it deserted, and the church and images of the saints burned and completely ruined, and twelve Spaniards hanging within the church by the act of the Lutheran English, who went about searching for us to make an end of all of us who had escaped *from the perils of the sea. All the monks had fled*to the woods for fear of the enemies, who would have sacrificed them as well if they had caught them, as they were accustomed to do, leaving neither place of worship nor hermitage standing; for they had demolished them all, and made them drinking places for cows and swine.


In order that you may occupy yourself somewhat after dinner, by way of amusement, in reading this letter, which will almost appear as if taken from some book of chivalry, I write it at such length, so that you may imagine the risks and hardships that I have experienced.


As I did not meet with any one at the said monastery, except the Spaniards hanging within from the iron window gratings of the church, I sallied forth speedily, and betook myself to a road which lay through a great wood. When I had gone by it for the matter of a mile, I met with a woman of more than eighty years of age, a rough savage, who was carrying off five or six cows to hide them in that wood, so that the English who had come to stop in her village might not take them.


As she saw me, she stopped and recognised me, and said to me: ‘Thou Spain’. I said yes to her by signs, and that I had been shipwrecked. She began


---

p.24



to lament much and to weep, making me signs that I was near her house, but not to go there, as there were numerous enemies in it, and they had cut the heads off many Spaniards. All this was affliction and hardship for me, as I travelled alone, and badly injured by a stick of timber, which almost broke my legs in the water.
At last, with the information of the old woman, I decided to go to the shore, where the ships lay that were wrecked three days before, where many parties of people went about carting and removing to their huts all our effects *spoils*.


I did not venture to show myself, nor to approach them, in order that they might not strip me of the poor linen garment I had on my back or kill me, until I saw two Spanish soldiers approaching, stripped naked as when they were born, crying out and calling upon God to help them. The one bore a bad wound in the head, which they had given him when stripping him. They came to me, as I called to them from where I was concealed, and recounted to me the cruel deaths and punishments which the English had inflicted upon more than one hundred Spaniards they had taken.


With this intelligence there was no lack of affliction; but God gave me strength; and after I had commended myself to Him, and to His blessed Mother, I said to those soldiers: ‘Let us proceed to the ships where these people are going about plundering, perhaps we shall find something to eat or drink, for it is certain that I shall die of hunger.’ And going in that direction, we began to see dead bodies, which was a great grief and pity to see those whom the sea continued casting up. There were stretched out upon that strand more than four hundred, among whom we recognised some, and the poor Don Diego Enriquez, whom, with all my sad plight, I did not wish to pass by without burying him in a pit, which we made in the sand, at the water's edge. We laid him there along with another very honourable captain, a great friend of mine, and we had not quite finished burying them, when there came up to us two hundred savages, to see what we were doing. We said to them, by signs, that we were placing there those men who were our brothers, that the crows might not eat them.


Then we went off, and searched for something to eat along the shore—of biscuits, which the sea was casting up—when four savages came up to me to strip me of the clothing which I wore, and another was grieved and took them away; seeing that, they began to maltreat me: and he may have been a chief, for they respected him.


This man, by the grace of God, assisted me and my two companions, and brought us away from there, and remained a good while in our company, until he put us on a road which led from the coast to a village where he lived. There he told us to await him, and that he would return soon and put us on the way to a good place.
Along with all this misery, that road was very stony, and I was unable to move or go a step forward, because I went shoe-less, and dying with pain in one


---

p.26



of my legs, which was severely wounded. My poor companions were naked and freezing with the cold, which was very great; and not being able to exist nor assist me, they went on in front by the road, and I remained there supplicating God's favour.


He aided me, and I began to move along, little by little, and reached a height, from whence I discovered some huts of straw; and going towards them by a valley, I entered a wood. When I had gone a distance of two shots of an arquebus in it, an old savage of more than seventy years came out from behind the rocks, and two young men, with their arms—one English, the other French—and a girl of the age of twenty years, most beautiful in the extreme, who were all going to the shore to plunder.


When they saw me pass among the trees, they changed their course towards me, and the Englishman came up saying, ‘Yield, Spanish poltroon’, and made a slash at me with a knife, desiring to kill me. I warded off the blow with a stick which I carried in my hand; but, in the end, he got at me, and cut the sinew of my right leg. He wanted to repeat the blow immediately, had not the savage come up with his daughter, who may have been this Englishman's friend, and I replied he might do what he wished to me, for fortune had subdued me, and deprived me of my arms in the sea. They took him away from me then, and the savage began to strip me, to the taking off of my shirt, under which I wore a gold chain of the value of rather more than a thousand dollars. When they saw it, they rejoiced greatly, and searched the jacket, thread by thread, in which I carried forty-five crown-pieces in gold, that the Duke had ordered to be given to me at Corunna for two months' pay; and when the Englishman saw that I carried a chain and crown-pieces, he wanted to take me prisoner, saying that he should be offered a ransom. I replied that I had nothing to give; that I was a very poor soldier, and had gained that, what they saw, in the ship. The girl lamented much to see the bad treatment I received, and asked them to leave me the clothes, and not to injure me any more. They all returned to the hut of the savage, and I remained among those trees, bleeding from the wound which the Englishman had inflicted upon me. I proceeded to put on again my jacket and sack-coat; moreover, they had taken away my shirt, and some relics of great value which I wore in a small garment *vestment*, of the Order of the Holy Trinity, that had been given to me at Lisbon.


These the savage damsel took and hung them round her neck, making me a sign that she wished to keep them, saying to me that she was a Christian: which she was in like manner as Mahomet.




---

p.27


From her hut they sent me a boy with a poultice made of herbs, to put upon my wound, and butter and milk and a small piece of oaten bread to eat.


I applied the dressing and ate the food, and the boy went along the road with me, showing me the direction I had to go, and advising me to avoid a village which could be seen from thence, where they had killed many Spaniards, and not one escaped that they could lay their hands upon.


He *or the person* to do me this service was born a Frenchman, who had been a soldier at Terceira, upon whom it pressed heavily to see such injury done me.


When the boy was about to turn back, he told me to continue travelling straight towards some mountains that appeared to be about six leagues off, behind which there were good lands belonging to an important savage very friendly to the King of Spain; **O'Rourke** and that he gave shelter to, and treated well, all the Spaniards who went to him; and that he had in his village more than eighty of those from the ships who reached there naked.


At this news I took some courage; and with my stick in hand, I began to walk as best I could, making for the direction of the mountains *or for the north of the mountains*, as the boy had told me.


That night I reached some huts, where they did not do me harm, because there was in them one who knew Latin; and in the necessity of the circumstances, our Lord was pleased that we should understand one another, talking Latin. I narrated to them my hardships.


The Latin-speaking man sheltered me in his hut that night he dressed my wound, gave me supper, and a place where I might sleep upon some straw. In the middle of the night his father arrived and his brothers, loaded with plunder and our things, and it did not displease the old man that I had been sheltered in his house and well treated.


In the morning they gave me a horse and a boy to convey me over a mile of bad road that there was, with mud up to the girths. Having passed it by the distance of the shot of a cross-bow, we heard a very great noise, and the boy said to me, by signs, ‘Save yourself, Spain’ (for so they call us); ‘many Sassana horsemen are coming this way, and they will make bits of thee if thou doest not hide theself: come this way quickly.’ They call the English ‘Sassanas’. He took me away to hide in some rugged places among the rocks, where we were very well concealed. They would be about one hundred and fifty horsemen going back to the coast to plunder as many Spaniards as they found.


God delivered me from them; and, proceeding on our way, there fell in with me more than forty savages on foot, and they wished to make little pieces of me because they were all Lutherans. They did not do it, as the boy, who


---

p.28



came with me, told them that his master had taken me prisoner, and he had me in custody, and had sent me on that horse to be cured. With all this, it did not suffice to obtain permission for me to pass in peace; for two of those robbers came up to me and gave me six blows of a stick, which bruised my shoulders and arms, and they stripped me of everything that I wore, so as to leave me as naked as when I was born. I speak the truth, by the holy baptism which I received. And seeing myself in this condition, I gave many thanks to God, beseeching of His Divine Majesty that He would fulfil His will on me, as that was what I desired.


The boy of the savage wished to return to his hut with his horse, weeping to see how I was left, stripped naked, so badly treated, and so cold.


I begged of God, very earnestly, that He would transport me to where I should die confessed and in His grace. I took some courage, being in the greatest extremity of misfortune that man ever saw, and with some bracken leaves and a small piece of old matting which I wrapped around my body, I protected myself from the cold as best I could.


I continued travelling, little by little, towards the place that had been pointed out to me, searching for the territory of the chief who had protected the Spaniards; **O'Rourke** and, reaching the mountain range that they gave me for direction, I met with a lake, around which there were about thirty huts, all forsaken and unoccupied, and there I wished to pass the night.


Not having where to go, I sought out the best hut, which appeared to me best to take shelter in for the night; and, as I say, they were unoccupied and without people. On entering the door, I saw it was full of sheaves of oats, which is the ordinary bread that those savages eat, and I gave thanks to God that I was so well off as to have a place to sleep on them; but just then I saw three men emerge from one side, naked as when their mothers had brought them forth, and they stood up and stared at me. They gave me a fright, for I thought they were, without doubt, devils, and they understood no less that I might be so, swathed in my ferns and matting. As I entered, they did not speak to me, because they were quaking, nor, any more, did I to them, not having observed them, the hut being somewhat dark. Seeing myself in this great perplexity, I said: ‘Oh! Mother of God, be with me, and deliver me from all evil.’
When they saw *heard* me speaking Spanish, and calling upon the Mother of God, they also said: ‘Let that great Lady be with us.’


Then I felt reassured, and went up to them, asking them if they were Spaniards. 
Yes, we are, for our sins, they replied. Eleven of us were stripped together at the shore, and in this naked state we came to seek some land of Christians. On the way, there met us a party of enemies, who killed eight of us, and the three who are here made our escape through a wood so thick that they could not discover us. That evening, God provided us with these huts, where we have rested, though there are no people in them nor anything to eat. 
I said to them, then, to be of good courage, and to commend themselves


---

p.29



always to our Lord; that near to where we were there was a land of friends and Christians; and that I brought word of a village, which was three or four leagues distant that belonged to Senor de Ruerque **O'Rourke**, where they had sheltered many of our lost Spaniards; and, although I was very badly treated and wounded, on the morrow we should proceed thither. 
The poor fellows rejoiced, and they asked me who I was. I told them I was Captain Cuellar. They could not believe it, because they had felt sure I was drowned; and they came up to me, and almost completely killed me with embraces.
One of them was an ensign, and the other two private soldiers.


And as the narrative is ludicrous, and true, as I am a Christian, I must proceed to the end with it, in order that you may have something to laugh at. 
I got into the straw, well buried in it, with care, not to injure nor disturb its position: and, having arranged to rise in the morning for our journey, we slept without supping, not having eaten anything but blackberries and water-cresses.
And when, in God's good time, day broke, I was wide awake with the great pain I felt in my legs, I heard talking and the noise of people; and at this juncture there came to the door a savage, with a halberd in his hand, and he began to look at his oats and to talk to himself.


I remained without breathing, and my companions, who had been aroused, *were* watching the savage very attentively from under the straw, and what he intended to do.
It was the will of God that he went out and left, with many others who had come along with him, to reap and work close to the huts in a place where we could not go out without being seen. We remained quiet, buried alive, discussing what it would suit us to do, and we decided not to disinter ourselves, nor to move from that place while those heretic savages were there, who were from the place where so much evil was done to the poor fellows of our Spaniards whom they caught; and they would have done the same to us if they had perceived us there, where we had no one to protect us but God.


Thus passed the whole day; and then, when night came on, the traitors departed to shelter themselves at their villages, while we awaited the rising of the moon. 
Then wrapped up with straw and hay, for it was extremely cold, we sallied forth from that great danger, in which we had been, without waiting for the day. 
We went along, stumbling in the mud, and dying with hunger, thirst, and pain, until God was pleased to bring us to a land of some safety, where we found huts of better people, although all savages, but Christians and charitable. One of them, seeing that I came so badly treated and wounded, took me to his hut and dressed my wounds, he and his wife and sons, and he did not permit me to depart till it appeared I should be well able to reach the village I was bound for. In it I met with more than seventy Spaniards, who all went about naked and severely


---

p.30



maltreated, because the chief was not there.


He had gone to defend a territory which the English were coming to take; and although this man is a savage, he is a very good Christian and an enemy of heretics, always carrying on war with them. He is called Senor de Ruerque **O'Rourke**.


I arrived at his house with great exertion, enveloped in straw and swathed around the body with a piece of matting, in such a plight that no one could see me without being moved to great compassion.
Some of the savages gave me a bad old blanket, full of vermin, with which I covered myself, and somewhat improved matters.
Early next day, about twenty of us Spaniards collected together at the house of this Senor de Ruurque **O'Rourke**, in order that they might give us something to eat, for the love of God; and while we were there begging, news was told us that a Spanish ship was at the coast, that she was very large, and came for those Spaniards who had escaped.


With this news, without waiting longer, the whole twenty of us left for the direction where they told us the ship was, and we met with many hindrances on the way; though, for me it was an advantage and a mercy which God granted me that I did not arrive at the port where she was in the same manner as the others who were with me reached it. They embarked on board of her, as she belonged to the Armada, and had arrived there in a great gale with her main-mast and rigging much injured. Fearing that the enemy might bum her or do her some other injury, for which energetic preparations were being made, they set sail from thence in two days with the crew that came in her and those they had picked up, returning, to run aground and get wrecked, on the same coast. More than two hundred persons were drowned, and those who reached the shore by swimming were taken by the English and all put to death. It pleased God that I alone remained of the twenty who went in search of her, for I did not suffer like the others. For ever blessed be His Most Holy Pity for so great mercies as He has shown to me.


Going along thus, lost with much uncertainty and toil, I met by chance with a road along which a clergyman in secular clothing was travelling (for the priests go about thus in that kingdom, so that the English may not recognise them). He was sorry for me, and spoke to me in Latin, asking me to what nation I belonged and about the shipwrecks that had taken place. God gave me grace so that I was able to reply to everything he asked me in the same Latin tongue; and so satisfied was he with me, that he gave me to eat of that which he carried with him, and he directed me by the right road that I should go to


---

p.31



reach a castle, which was six leagues from there. It was very strong, and belonged to a savage gentleman, a very brave soldier and great enemy of the Queen of England and of her affairs, a man who had never cared to obey her or pay tribute, attending only to his castle and mountains, which made it strong.
I set out for there experiencing much trouble on the road, and the greatest, and that which gave me most pain, was that a savage met me on the way, and, by deceiving me, took me to his hut in a deserted valley, where he said I must live all my life, and he would teach me his trade, which was that of a blacksmith.
I did not know what to answer nor did I venture, so that he should not put me in the forge. Before him I showed a pleasant countenance, and proceeded to work with my bellows for more than eight days, which pleased the wicked savage blacksmith, because I did it carefully, so as not to vex him and an accursed old woman he had for wife.
I was in tribulation and sad with such miserable employment, when our Lord favoured me by causing the clergyman to return by that way, who was surprised to see me, because that savage did not wish to let me go away, as he made use of me. The clergyman scolded him severely, and told me not to be troubled, as he would speak with the chief of the castle to which he had directed me, and get him to send for me, which he did the following day. He sent four men of the savages, who served him, and a Spanish soldier, of which he had already ten with him of those who had escaped by swimming.
When he saw me so stripped *of clothing* and covered with straw, he and all those who were with him grieved greatly, and their women even wept to see me so badly treated.
They helped me as best they could with a blanket of the kind they use, and I remained there three months, acting as a real savage like themselves.


The wife of my master was very beautiful in the extreme, and showed *did* me much kindness. One day we were sitting in the sun with some of her female friends and relatives, and they asked me about Spanish matters and of other parts, and in the end it came to be suggested that I should examine their hands and tell them their fortunes. Giving thanks to God that it had not gone even worse with me than to be gipsy among the savages, I began to look at the hands of each, and to say to them a hundred thousand absurdities, which pleased them so much that there was no other Spaniard better than I, or that was in greater favour with them.
By night and by day men and women persecuted me to tell them their fortunes, so that I saw myself (continually) in such a large crowd that I was forced to beg permission of my master to go from his castle. He did not wish to give it me: however, he gave orders that no one should annoy me or give me trouble.




---

p.32


The custom of these savages is to live as the brute beasts among the mountains, which are very rugged in that part of Ireland where we lost ourselves. They live in huts made of straw. The men are all large bodied, and of handsome features and limbs; and as active as the roe-deer. They do not eat oftener than once a day, and this is at night; and that which they usually eat is butter with oaten bread. They drink sour milk, for they have no other drink; they don't drink water, although it is the best in the world. On feast days they eat some flesh half-cooked, without bread or salt, as that is their custom. They clothe themselves, according to their habit, with tight trousers and short loose coats of very coarse goat's hair. They cover themselves with blankets, and wear their hair down to their eyes. They are great walkers, and inured to toil. They carry on perpetual war with the English, who here keep garrison for the Queen, from whom they defend themselves, and do not let them enter their territory, which is subject to inundation, and marshy. That district extends for more than forty leagues in length and breadth. The chief inclination of these people is to be robbers, and to plunder each other; so that no day passes without a call to arms among them. For the people in one village becoming aware that in another there are cattle, or other effects, they immediately come armed in the night, and ‘go Santiago’ *attack,* and kill one another, and the English from the garrisons, getting to know who had taken, and robbed, most cattle, then come down upon them, and carry away the plunder. They have, therefore, no other remedy but to withdraw themselves to the mountains, with their women and cattle; for they possess no other property, nor more moveables nor clothing. They sleep upon the ground, on rushes, newly cut and full of water and ice.
The most of the women are very beautiful, but badly dressed *got up*. They do not wear more than a chemise, and a blanket, with which they cover themselves, and a linen cloth, much doubled, over the head, and tied in front. They are great workers and housekeepers, after their fashion. These people call themselves Christians. Mass is said among them, and regulated according to the orders of the Church of Rome. The great majority of their churches, monasteries, and hermitages, have been demolished by the hands of the English, who are in garrison, and of those natives who have joined them, and are as bad as they. In short, in this kingdom there is neither justice nor right, and everyone does what he pleases.


As to ourselves, these savages liked us well because they knew we came against *to oppose* the heretics, and were such great enemies of theirs; and if it had not been for those who guarded us as their own persons, not one of us would have been left alive. We had goodwill to them for this, although they were the


---

p.33



first to rob us and strip to the skin those who came alive to land; from whom, and from the thirteen ships of our Armada, in which came so many people of importance, all of whom were drowned, these savages obtained much riches in jewellery and money.
Word of this reached the great Governor of the Queen, who was in the city of Dililin **Dublin**, and he went immediately, with seventeen hundred soldiers, to search for the lost ships and the people who had escaped. They were not much fewer than one thousand men, who, without arms and naked, were wandering about the country in the locality where each ship had been lost.
The majority of these the Governor caught, and hanged them at once or inflicted other penalties, and the people who he knew had sheltered them he put in prison, and did them all the injury he could.
In this manner he took three or four savage chiefs, who had castles, in which they had sheltered some Spaniards; and, having put both parties under arrest, marched with them along the whole of the coasts till he arrived at the place where I was wrecked.


From thence he turned off towards the castle of Manglana **MacClancy**, for so they called the savage with whom I was, who was always a great enemy of the Queen, and never loved anything of hers, nor


---

p.34



cared to obey her, for which reason he (the Governor) was very anxious to take him prisoner.
This savage, taking into consideration the great force that was coming against him, and that he could not resist it, decided to fly to the mountains, which was his only remedy: more he could not do.
We Spaniards, who were with him, had news of the misfortune which was coming upon us, and we did not know what to do, or where to place ourselves in safety.


One Sunday, after mass, the chief, with dishevelled hair down to his eyes, took us apart, and, burning with rage, said that he could not remain, and he had decided to fly with all his villagers, their cattle, and their families, and that we should settle what we wished to do to save our lives. I replied to him to calm himself a little, and that presently we would give him an answer. I went apart with the eight Spaniards who were with me—they were good fellows—and I told them they should well consider all our past misfortunes and that which was coming upon us; and in order not to see ourselves in more, it was better to make an end of it at once honourably; and as we had then a good opportunity, we should not wait any longer, nor wander about flying to the mountains and woods, naked and barefooted, with such great cold as there was. Besides, the savage regretted so much to abandon his castle, we, the nine Spaniards who were there, would cheerfully remain in it and defend it to the death. This we could do very well, although there should come two other such forces, more than that which was coming, because the castle is very strong and very difficult to take if they do not (even though they should) attack it with artillery; for it is founded in a lake of very deep water, which is more than a league wide at some parts, and three or four leagues long, and has an outlet to the sea; and, besides, with the rise of spring tides it is not possible to enter it, for which reason the castle could not be taken by water nor by the shore of the land that is nearest to it. Neither could injury be done it, because *for* a league round the town, which is established on the mainland, it is marshy, breast-deep, so that even the inhabitants *natives* could not get to it except by paths.
Then, considering all this carefully, we decided to say to the savage that we wished to hold the castle and defend it to the death; that he should, with much speed, lay in provisions for six months, and some arms.
The chief was so pleased with this, and to see our courage, that he did not delay much to make all provision, with the concurrence *good-will* of the principal men of his town, who were all satisfied. And, to insure that we should not act falsely, he made us swear that we would not abandon his castle, nor surrender it to the enemy for any bargain or agreement, even if we should perish from hunger; and not to open the gates for Irishman, Spaniard, or any one else till his return, which he would doubtless accomplish.
Then, all that was necessary being well prepared, we moved into the castle, with the ornaments and requisites for the Church service, and some relics which were there, and we placed three or four boatloads of stones within, and six


---

p.35



muskets, with six cross-bows, and other arms. Then the chief, embracing us, retired to the mountains, all his people having already gone there; and the report was spread throughout the country that Manglana's **MacClancy**'s Castle was put in a state of defence, and would not be surrendered to the enemy, because a Spanish captain, with other Spaniards who were within, guarded *held* it.


Our courage seemed good to the whole country, and the enemy was very indignant at it, and came upon the castle with his forces—about eighteen hundred men—and observed us from a distance of a mile and a half from it, without being able to approach closer on account of the water which intervened. From thence he exhibited some warnings, and hanged two Spaniards, and did other damages *injuries* to put us in fear. He demanded many times, by a trumpeter, that we should surrender the castle, and he would spare our lives and give us a pass to Spain. We said to him that he should come closer to the tower, as we did not understand him, appearing always to make little of his threats and promises *words*.


We had been besieged for seventeen days, when our Lord saw fit to succour and deliver us from that enemy by severe storms and great falls of snow, which took place to such an extent that he *the Queen's Governor* was compelled to depart with his force, and to march back to Duplin **Dublin**, where he had his residence and garrisons. From thence he sent us warning that we should keep ourselves out of his hands, and not come within his power; and that he would return in good time to that country.
We replied to him much to our satisfaction, and to that of our Governor of the castle, who, when he got the news that the Englishmen had retired, returned to his town and castle greatly appeased and calmed, and they fêted us much.
He *the chief* very earnestly confirmed us *admitted us to full privileges* as most loyal friends: offering whatever was his for our service, and the chief persons of the land *did the same*, neither more nor less. To me he would give a sister of his, that I should marry her. I thanked him much for this; but contented myself with a guide to direct me to a place where I could meet with embarkation for Scotland.
He did not wish to give me permission *to leave*, nor to any Spaniard of those who were with him, saying that the roads were not safe; but his sole object was to detain us, that we might act as his guard.
So much friendship did not appear good to me; and thus I decided, secretly, with four of the soldiers who were in my company, to depart one morning two hours before dawn, so that they should not pursue *stop* us on the road: and also because one day previously a boy of Manglana's **MacClancy**'s had told me his father had said that he would not let me leave his castle until the King of Spain should send soldiers to that country; and that he wished to put me in prison, so that I might not go.




---

p.36


Possessed of this information, I dressed myself as best I could, and took to the road, with the four soldiers, one morning ten days after the Nativity, in the year 88.
I travelled *went travelling* by the mountains and desolate places, enduring much hardship, as God knows; and at the end of twenty days' journey, I got to the place where Alonzo de Leyva, and the Count de Paredes and Don Tomas de Granvela, were lost, with many other gentlemen, to give an account of whom would need a quire of paper.
I went to the huts of some savages that were there, who told me of the great misfortunes of our people who were drowned at that place, and showed me many jewels and valuables of theirs, which distressed me greatly.
My chief cause of misery was that I had no means of embarking for the Kingdom of Scotland; until one day I heard of the territory of a savage, whom they called Prince Ocan **O'Cahan**, where there were some vessels that were going to Scotland.


Thither I travelled, crawling along, for I could scarcely move because of a wound in one leg; but, as it led to safety, I did all I could to walk, and reached it quickly. The vessels had left two days before, which was no small disappointment for me, as I was in a very dreadful country and among enemies, there being many English stationed at the port, and each day they were with Ocan **O'Cahan**.
At this time I suffered great pain in the leg, so much so that in no manner could I stand upon it. I was advised, too, that I should be very cautious, because there were many English there who would do me great harm if they caught me, as they had done to other Spaniards; especially if they knew who I was.
I did not know what to do, as the soldiers who came with me had left, and gone to another port further on to seek for a passage.


Some women, when they saw me alone, and ill, pitied me, and took me away to their little huts on the mountain, and kept me there for more than a month and a half in safety, and cured me, so that my wound healed, and I felt well enough to go to Ocan's **O'Cahan's** village to speak with him.
But he did not wish to hear or see me; for, it was said, he had given his word to the great Governor of the Queen not to keep any Spaniard in his territory, nor permit one to go about in it.
The English, who were quartered there, having marched off to invade a territory and take it, Ocan **O'Cahan** accompanied them with all his force, so that one could go openly *boldly* about the village, which was composed of thatched huts.
In them there were some very beautiful girls, with whom I was very friendly, and went into their houses occasionally for society and conversation.


One afternoon, while I was there, two young Englishmen came in, one of whom was a sergeant, and possessed information of me, by name, but yet had not seen me before. When they were seated, they asked me if I were a Spaniard; and what I was doing there. I said yes; that I was one of the soldiers of Don


---

p.37



Alonzo de Lufon, who had lately surrendered to them; but on account of a bad leg, I had not been able to leave the district; that I was at their service, to do whatever they wished to command.
They told me to wait a little, and that I should have to go with them to the city of Dublin, where they were many important Spaniards in prison.
I said that I could not walk or go with them, and they sent to search for a horse to carry me. I told them I was very willing to do whatever they wished, and to go with them, with which they were reassured, and began to make fun with the girls.
Their mother made signs to me to go away (that I should leave by the door), and I did so in great haste, leaping banks as I went along. I got among thick brambles, into which I penetrated until I lost sight of Ocan's **O'Cahan**'s Castle, following this course until I wished to lie down for the night.


I had arrived at a very large laguna *lake or marsh*, along the banks of which I saw a herd of cows walking, and I was approaching to see if there was any one with them who could tell me where I was, when I observed two boy savages advancing. They came to collect their cows, and take them up the mountain to where they and their fathers were hiding for fear of the English; and there I spent two days with them, being treated with much kindness.
One of the boys had to go to the village of the Prince of Ocan **O'Cahan** to ascertain what news or rumour there was, and he saw the two Englishmen, who were going about, raging, in search of me.
Information about me had already been given to them, and no one passed by whom they did not ask if he had seen me.
The boy was such a good lad that, upon learning this, he returned to his hut, and informed me of what had occurred, so that I had to leave there very early in the morning, and to go in search of a bishop, who was seven leagues off in a castle where the English kept him in banishment and retirement.


This bishop was a very good Christian, and went about in the garb of a savage for concealment, and I assure you I could not restrain tears when I approached him to kiss his hand. He had twelve Spaniards with him for the purpose of passing them over to Scotland, and he was much delighted at my arrival, all the more so when the soldiers told him that I was a captain. He treated me with every kindness that he could for the six days I was with him, and gave orders that a boat should come to take us over to Scotland, which is usually done in two days. He gave us provisions for the voyage and said mass to us in the castle and spoke with me about some things concerning the loss of the kingdom, and how His Majesty had assisted them; and that he should come to Spain as soon as possible after my arrival in Scotland, where he advised me to live with much patience, as in general they were all Lutherans and very few Catholics. The bishop was called Don Reimundo Termi, bishop of Times (?), an honourable just man. God keep him in His hands and preserve him from his enemies.[1](javascript:footNote('T108200/note001.html'))




---

p.38


The same day at dawn *when it was growing light*, I went to sea in a wretched boat in which we sailed—18 persons—and the wind becoming contrary the same day, we were forced to run before it, at the mercy of God, for Shetland, where we reached the land at daylight; the boat being nearly swamped, and the main-sail carried away. We went on shore to give thanks to God for the mercies He had bestowed upon us in bringing us there alive; and from thence, in two days, with good weather, we left for Scotland, where we arrived in three days: not without danger, on account of the great quantity of water the miserable boat took in.
We blessed God who withdrew us from such perils and so great hardships, and brought us to a land where there might be more succour.
It was said that the King of Scotland protected all the Spaniards who reached his kingdom, clothed them, and gave them passages to Spain; but all was the reverse, for he did no good to anyone, nor did he bestow one dollar in charity. Those of us who reached that kingdom suffered the greatest privations; inasmuch, as we were *left* for more than six months as naked as when we arrived from Ireland, and other places, to seek succour and assistance there, and passages to Spain.
I am inclined to believe that he was much persuaded, on the part of the Queen of England, to hand us over to her. And had not the Catholic Lords and Counts of that kingdom helped us—and there were many, and great gentlemen, to favour us and speak for us to the King, and in the Councils which were held on the subject—without doubt we should have been betrayed *sold,* and handed over to the English. For the King of Scotland is nobody: nor does he possess the authority or position of a king: and he does not move a step, nor eat a mouthful, that is not by order of the Queen. Thus, there are great dissensions among the gentlemen, who bear him no goodwill, and desire to see his reign ended, and the Majesty of the King, our Lord, in his place, that he might establish the Church of God, which has been brought to such ruin there.
This they said to us many times, almost weeping, longing to see that day which, they hoped in God, might soon arrive.
And, as I say, these gentlemen supported us all the time that we were there, and gave us much alms, and were kind to us, sorrowing for our misfortunes, with much pity. They asked us to have patience, and to bear with a people who called us idolaters and bad Christians, and said a thousand heresies to us; for, if one made answer, they would fall upon him and kill him, and it was impossible to live or remain in such a bad kingdom with so bad a king...[2](javascript:footNote('T108200/note002.html')) A despatch was sent to the Duke of Parma...[3](javascript:footNote('T108200/note003.html')) at which his Highness, as a pious prince, grieved, and with great zeal he sought to succour us...[4](javascript:footNote('T108200/note004.html')) to the King, that he would permit us to leave his kingdom, and to the Catholics and friends much gratitude on the part of his Majesty, with his most friendly letters.




---

p.39


There was a Scotch merchant in Flanders, who offered and agreed with his Highness that he would come to Scotland for us and ship us in four vessels, with the provisions which were necessary, and that he would bring us to Flanders, his Highness giving him five ducats for each Spaniard of those that he brought to Flanders.
The agreement was made with him, and he went for us and embarked us, unarmed and naked as he found us, and took us by the ports of the Queen of England, which secured us permission to pass by all the fleets and ships of her kingdom.
All was treacherous; for an arrangement had been made with the ships of Holland and Zealand that they should put to sea and await us at the same bar *entrance to the harbour* of Dunkirk, and there they should put all to death, without sparing one, which the Dutch did as they were commanded; and were on the look-out for us for a month and a half at the said port of Dunkirk, and there they should have caught us all had not God helped us.
God willed that of the four vessels in which we came, two escaped and grounded, where they went to pieces; and the enemy, seeing the means of safety which we were taking, gave us a good discharge of artillery, so that we were forced to cast ourselves afloat *to make a desperate attempt*, and we thought to end it there.
They could not come to our assistance with the boats from the port of Dunkirk, as the enemy cannonaded them briskly. On the other hand, the sea and wind were very high; so that we were in the greatest peril of being all lost.
However, we cast ourselves afloat on timbers, and some soldiers were drowned, as was also a Scotch captain. I reached the shore in my shirt, without other description of clothing, and some soldiers of Medina who were there came to help me.
It was sad to see us enter the town once more, stripped naked; and for the other part we saw, as before our eyes, the Dutch making a thousand pieces of two hundred and seventy Spaniards who came in the ship which brought us to Dunkirk, without leaving more than three alive; for which they are now being paid out, as more than four hundred Dutchmen who have been taken since then have been beheaded. This I have wished to write to you.


From the City of Antwerp, 4th October, 1589. Sgd. FRANCISCO DE CUELLAR.









