

#Annalium Hiberniae Chronicon ad annum MCCCXLIX


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Annalium Hiberniae Chronicon ad annum MCCCXLIX
==============================================


Author: Friar John Clyn
-----------------------


### File Description

Richard ButlerElectronic edition compiled by the CELT Team

Funded by University College, Cork and  
Professor Marianne McDonald via the CELT Project 2. Second draft.Extent of text: 30660 words#### Publication


CELT: Corpus of Electronic Texts: a project of University

College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2003) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: L100011Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Dublin, Trinity College Library, olim E. 3, 20; vellum and paper; 17th century; a transcript made for archbishop Ussher.
3. London, British Library, Additional 4789; paper; 17th century; a transcript by Sir James Ware.
4. Oxford, Bodleian Library, Rawlinson B. 496; paper; 17th century; a transcript made for Sir James Ware.
5. Dublin, Municipal Libraries, Gilbert Manuscripts, 105–6.
6. Dublin, Genealogical Office, 28.
7. The original from which these derive, directly or indirectly, is Liber communitatis fratrum minorum Kilkennie. , now lost. Annals from the beginning to 1346, with annals for 1467 and 1480 in a later hand.
**Editions**2. Richard Butler (ed.), The Annals of Ireland by Friar John Clyn and Thady Dowling (Dublin 1849), 1–46. (Edited without variants from MS (i), but collated against the MS of Sir William Betham [it is not clear which of the Dublin MSS this is], MS (iii), and perhaps others.
3. Bernadette Williams (ed. and trans.), The Annals of Ireland by Friar John Clyn (Dublin 2007).
**Secondary Literature**2. Robin Flower, 'Manuscripts of Irish interest in the British Museum', Analecta Hibernica 2 (1931) 292–340: 324–5.
3. Aubrey Gwynn, 'Some unpublished texts from the Black Book of Christ Church, Dublin', Analecta Hibernica 16 (1946) 281–337: 321.
**The edition used in the digital edition**2. The Annals of Ireland. By Friar John Clyn, of the Convent of Friars Minors, Kilkenny; and Thady Dowling, Chancellor of Leighlin. Together with the Annals of Ross. Richard Butler (ed), First edition [xxxvii + 85 (pp 1–39 the Annals of Clyn; 41–46 the Annals of Ross from TCD MS E. 30. 20, p 396 sqq; 47–70 notes to the Annals of Clyn; 71–85 Index of persons and places.)] The Irish Archaeological SocietyDublin (1849)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents pp i–xxxvii and 1–39 of the printed edition.


#### Editorial Declaration


##### Correction


Introduction and main annals proof-read three times.


##### Normalization


The electronic texts represents the edited text. The editor does not elucidate his editorial policy. Some years are not in sequence in the printed edition, and some appear twice. To avoid duplication of div1 elements, all annal entries have been gathered under the year to which they belong, and brought into line, even though this affects the pagination. Gaps in the text are marked. Marginal additions are indicated as add place="margin"; additions by a second hand are marked add hand="S". One editorial note is tagged note type="auth" n="". For expanding the abbreviation on page 36, CELT is indebted to Christoph Cluse of Trier University.


##### Quotation


Quotations are rendered q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0= the body of annals; the front matter contains the introduction, the back matter contains a postscript. Both of these are tagged as div. In the main text, div1= the individual annal (i.e. the entries for one year); div2= the individual entry in a given annal. Page-breaks are marked. Passages in verse are marked by poem, stanza and line.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names of persons, groups and places are tagged.


#### Canonical References


This text uses the DIV1 element to represent the annal. Refs: ENTRY (DIV2)This text uses the DIV1 element to represent the annal. ### Profile Description


Created: Created by Friar John Clyn, incorporating earlier materials.

 Date range: 1333–1349.#### Use of language


##### Language: [LA] Text is in Latin.


##### Language: [GA] Two words are in Irish.


##### Language: [EN] Introduction and postscript are in English.


#### List of hands


**H** [main] Friar John Clyn

**S** [additional hand at end of text] unknown

### Revision History


* (2010-04-14) Beatrix Färber (ed.)

* Conversion script run; header updated; encoding of dates, titles, personal and place-names in the Introduction improved; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-10-16) Beatrix Färber (ed.)

* Header updated, keywords added, file validated.
* (2008-07-21) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, 'creation' tags inserted, content of 'langUsage' revised; minor modifications made to file and header, addition to bibliography.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:15:33+0100) Peter Flynn (ed.)

* Converted to XML
* (2003-05-19) Donnchadh Ó Corráin (ed.)

* Bibilography compiled.
* (2003-05-21) Beatrix Färber (ed.)

* File parsed; header modified; third proofing of introduction and

main text; more content markup applied.
* (2003-04-24) Ruth Murphy (ed.)

* Header created; second proofing of main text; structural and content markup applied.
* (2003-04-30) Emer Purcell (ed.)

* Second proofing of introduction; basic strucutral markup applied.
* (2003-04-23) Benjamin Hazard (ed.)

* Scanning and first proofing of introduction.
* (1995-08-30) Audrey Murphy (ed.)

* Main text proofed (1).
* (1995 or earlier) Students at the History Department, UCC (Capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: L100011


### Annalium Hiberniae Chronicon ad annum MCCCXLIX: Author: Friar John Clyn


### Introduction


‘An intention there was not long since by **Sir James Ley, Knight, then Lord Chiefe Justice of the King's Bench in **Ireland** (afterwards Lord High Treasurer and Earle of **Marleburgh****), to have published some of our country writers in this kinde, for which end hee caused to be transcribed and made fit for the Presse the Annales of **John Clynne, a Friar Minor of **Kilkenny**** (who lived in the time of **King Edward the Third**), the Annales of the Priory of St John the Evangelist of Kilkenny, and the Annales of Multifernan, Rosse, and Clonmell, &c. But his weighty occasions did afterwards divert his purpose. The copies are yet preserved, and I hope ere long with other Annales and Fragments of the same nature will be divulged.’. So wrote **Sir James Ware**, in his Preface to **Campion**'s and **Hanmer**'s Histories printed in Dublin in the year 1633. More than 200 years have since passed, and by the publication of the Annals of Multifernan, and by the present publication the **Irish Archaeological Society**


---

p.ii




is only now partly realizing the purpose of **Ley**, and the hopes of **Ware**, **Camden**, and **Ussher**.


It is not for those who are endeavouring to put an end to it, to attempt to justify the delay that has occurred in the publication of these chronicles; it may, perhaps, partly be accounted for by the dry and unsatisfactory nature of their contents.


**Clyn** lived ninety years after **Matthew Paris**, and was not many years older than **Froissart**; but instead of the caustic remarks and striking details of the monk of **St. Alban's**,—instead of **Froissart**'s pictured pages, which make us familiar with the sentiments and motives, and even with the outward bearing, of the men of his day,—we have here, for the most part, only mere entries of names and of facts, the ashes of history in which there is no living fire. The fact is so, and must be acknowledged, nor shall we be surprised that it if we consider the circumstances in which **Clyn** and the other Anglo-Irish monkish chroniclers wrote, and the objects which they had in view.


The very materials for writing at that time were not abundant in this country. **Clyn** mentions that he had left parchment for the continuation of his Annals (see page 37), a pious precaution which does not seem to have produced any effect; and being confined by precedent and by an affectation of scholarship to the use of Latin, the monkish chroniclers were trammelled and hampered by a foreign language, with which they were not familiar, and in which they neither spoke nor thought, and in which, like men in a stiff and unusual dress, they moved with slow and awkward formality.


Nor were the authorities, from which they derived their information, calculated to give them confidence and freedom. Their chief written authorities were evidently the Obits of their own, or of some other religious house of the same Order, combined with some brief Registry of public events and of wonderful occurrences, which seems to



---

p.iii




have formed the common historical stock of all our Anglo-Irish monkish chroniclers, and which was probably communicated to the members of the different houses at the provincial or general Chapters of the several Orders.


To synchronize this general history with the Obits and special entries of their own records was the great object of the monkish writers, a task not without difficulty, and in which it is probable that many mistakes were made, as in the older Mortiloges the entries were made under the day of the month, without any notice of the year.


But we must not suppose that those annals were to the monks the dry and bare catalogues which they are to us, or that the inhabitants of the monastery were satisfied with that modicum of knowledge which we have inherited from them. Every name entered in their registry at its entry had its own peculiar history, and that history was preserved in the traditions of the chapter-room and of the cloister. From the founder of the house and the giver of broad lands, to the bequeather of a cope, and the increaser of their gaudy-day pittance, all their benefactors had their places in the grateful memory of the brotherhood; and the novice and the lay brother were often told why this Baron bestowed the rich farm, and why it was leased to such a Knight; why this Lady founded an altar and a chaplaincy, and why such a Burgess was commemorated with a double Lection. Every name in the registry was made the text of some grave homily, or recalled some story, kept alive, not only by being repeated on every recurring anniversary amongst the habitual sitters round the refectory fire, and amongst the pacers in the cloisters, but by being told to the knights and squires who used the monastery as an inn, and to the pilgrims and visitors, from other religious houses who there claimed charitable hospitality.


Nor was it only gratitude, and the wish to maintain the credit of their house before their visitors, that induced the monks to fill up in conversation the bare outline of their registers with traditional histories;



---

p.iv




many of them had the strong interest of relationship, or of family dependence, connected with the names recorded; and it was pleasant to tell how their fathers had fought in the battle in which their benefactor was killed, whose tomb was in the choir and whose death was in the Mortiloge. With respect, then, to occurrences in its own neighbourhood, or referring to its special benefactors, the date and the succession were almost all that was wanted by the inmates of a religious house, and these were supplied by the dryest of their chronicles. The cloister tradition supplied the rest, giving to the merest outline fulness of detail and warmth of colouring.


With regard to the events affecting other religious houses of the same Order, the same knowledge was communicated by the mutual visits of their respective members, and especially by the provincial and general chapters. If we look at a map of any Christian country in the middle ages, we see how the houses of the different Orders were scattered through it, so that lines drawn from one to another would make a close net-work over its whole surface; and it is difficult to limit the amount of general knowledge which must have been in the possession of the inquisitive members of these societies, and of which we have nothing left but these meagre and lifeless chronicles. For the view of the writers there were fields, and flowers, and trees, ‘hominumque boumque labores;’ but the deep flood of oblivion covers them, and we see nothing but the land-marks and the boundary stones.


The authors of most of the other Anglo-Irish monastic annals are unknown, and we can feel no sympathy with the impersonal and unnamed writer who expresses no personal feeling in anything he mentions, and who records, as it were mechanically, all events, whether of joy or sorrow, with equal brevity and with equal coldness.


Of the annals here printed we know at least the name and station of the writer, and the time of their composition.




---

p.v


**John Clyn** was a Franciscan friar, in the convent of that Order in **Kilkenny**. He seems to have been highly esteemed in the brotherhood, for in 1336, when **James, Earl of **Ormonde****, in his old earldom of **Carrick**, founded a locus for **Franciscans**, **John Clyn** was the first Warden or Guardian; **William Naase being Custos**; and **Friar Stephen Barry, Minister Provincial**. The zeal and austerity of the earlier **Franciscans** and **Dominicans** had attracted into their Orders men of the loftiest minds and most generous tempers; and in the fourteenth century, when the fervour of religious enthusiasm was in some degree diminished, there were still to be found in these Orders the most profound theologians and the most subtle speculative philosophers. Among these the **Irish Franciscans** maintained a proud and honourable position. If the haughty attempt of **Primate Albert of **Cologne**** to subject causes, properly belonging to the King's courts, to Papal authority, provoked **Henry III** to forbid the future election of any Franciscan to an Irish see, the prohibition was soon withdrawn, and the royal displeasure was probably amply compensated by that popular favour, which encouraged the **Franciscans** to encroach upon the rights of the Irish parochial clergy. The earliest account of a British pilgrimage into the east was written by **Simon Fitzsimon**, and **Hugh, the Illuminator**, of the Franciscan Friary of **Dublin**, who commenced their pilgrimage to the Holy Land in 1322. And when the **University of Dublin** was opened,—Universitas, as **Clyn** disparagingly says, ‘quoad nomen, set utinam quoad factum et rem’, three of the first four inceptors in theology were friars.




---

p.vi


Of the individual character of **Clyn** we know only what we can gather from his own writings. The few gleams of natural feeling, which occasionally brighten his formal entries, betoken a good and generous mind, and make us lament that he did not let himself out more freely and give utterance more frequently to his own thoughts and sentiments. Some of his observations, brief and rare as they are, are not without pith and point, and few passages, of the same date, are more striking and pathetic in their calm and earnest simplicity, than the close of his work. After thus describing the **Plague** of 1348: ‘That pestilence deprived of human inhabitant villages and cities, and castles and towns, so that there was scarcely found a man to dwell therein; the pestilence was so contagious that whosoever touched the sick or the dead was immediately infected and died; and the penitent and the confessor were carried together to the grave; through fear and dread men scarcely dared to perform the offices of piety and pity in visiting the sick and in burying the dead; many died of boils and abscesses, and pustules on their shins or under their armpits; others died frantic with the pain in their head, and others spitting blood; that year was beyond measure wonderful, unusual, and in many things prodigious, yet’ (is not the observation natural and pathetic?) ‘it was sufficiently abundant and fruitful, however sickly and deadly;’—then, having made entries of a fratricide committed in the midst of the pestilence, by **Connell O'More**, on the morrow of the Purification, and of the vengeance taken for it eight days afterwards, he thus returns: ‘The pestilence was rife in **Kilkenny** in Lent, for, from Christmas Day to the 6th day of March eight friars preachers died of it. Scarcely one alone ever died in a house. Commonly husband, wife, children, and servants, went the one way, the way of death. And I, **Friar John Clyn**, of the Order of **Friars Minor**, and of the convent of Kilkenny, wrote in this book those notable things, which happened in my time, which I saw with my eyes, or which I learned from 



---

p.vii




persons worthy of credit; and lest things worthy of remembrance should perish with time, and fall away from the memory of those who are to come after us, I, seeing these many evils, and the whole world lying, as it were, in the wicked one, among the dead, waiting for death till it come, as I have truly heard and examined, so have I reduced these things to writing; and lest the writing, should perish with the writer, and the work fail together with the workman, I leave parchment for continuing the work, if haply any man survive, and any of the race of Adam escape this pestilence and continue the work which I have commenced.’ Then follows one paragraph for 1349, containing the death and eulogy of **Sir Fulco de la Frene**, and then the copyist's brief entry: ‘Here it seems the author died.’


Like most of the Anglo-Irish chroniclers, **Clyn** passes over in ignorance, or in contempt, the legends, whether poetical, mythical, or enigmatical, with which the Irish seanachies filled up the vestibule of Irish history, thronging its gates with forms of strange aspect, elusive of the grasp. Yet even these legends, as we find them in **Dowling** and in the native annalists, are worthy of record. Although not true in themselves, it is true that they were once believed; and although they may not constitute the history of the times to which they are assigned, they form at least important elements of the character of the times in which they were received. But it is not likely that legends, so widely propagated and so fondly cherished, had no foundation in fact, that they were altogether either poetical fictions, or moral and political parables and myths. It is more reasonable to conjecture that they were the forms of historical narrative used by one people, which, falling into the hands of another people of different language, and of other habits of thought and turns of expression, were understood by them in a sense which they were not intended to bear, and in which they were not used by their authors. We would look upon these



---

p.viii




strange and portentous narratives as the hieroglyphic records of forgotten but substantial history.


We know that the **Northmen** had a peculiar genius for high-wrought, and lofty imagery, enigmatical rather than fantastical; not only were their ships ‘the wooden horses of the ocean’, and their swords ‘serpents’; the very geography of their countries, either from their own taste, or from the taste of their visitors, was allusive and metaphorical. The Baltic Sound, which in the days of **Tacitus**, was called ‘the Pillars of Hercules’, was styled ‘the Hellespont’ by **Saxo Grammaticus**. And the Africa of **Nennius** and **Geoffry of Monmouth** seems to have been the southern coast of the Baltic, the land of the sea robbers, with whom, as **Dubhgalls** or black strangers, we are familiar in Irish history, but who startle and perplex us when we meet them under the name of Africans. It may be conjectured that the wild and seemingly absurd stories of Partholanus, Nemedus, Milesius, are mistranslated and misunderstood narratives of some northern invasions, or rather of some one northern invasion, for all those stories have so many circumstances in common that we cannot but suspect them to be different versions of the same history. At what period these invasions, or this invasion, occurred, it would be difficult to ascertain; it would seem, however, not to have been long prior to the times of **St. Patrick**, who is said to have learned from their contemporary, Ruanus, the history of those events. As to mistakes in Irish chronology, it must be remembered that, from the want of any fixed and commonly acknowledged era, the dates of the occurrences in early Irish history must have been a matter of calculation. Even in the tenth century there is a difference of more than sixty 



---

p.ix




years between the dates of the Annals of Boyle and of the Annals of the Four Masters; and, as low as the twelfth century, public documents were at least occasionally dated, not from any fixed era, but from such an arbitrary and mutable epoch as ‘the year when the kine and swine of Ireland perished by a pestilence.’


The facts mentioned in the earlier parts of **Clyn**'s Annals are, for the most part, common to all the Anglo-Irish annalists, and are to be found, with little variety of expression, in Pembridge and Grace, and the Annals of Multifernan. It would appear, however, from the following pages, that **Clyn**'s Calendar differed from that of the English and Roman Churches, which was received in Ireland; at least if the transcript from which we print is correct, which is very doubtful, it will follow that the **Franciscans** of **Kilkenny** held their festivals of St. Stephen's Day, and of the Conversion of St. Paul, as well as other festivals, on days peculiar to themselves.


In the early part of the fourteenth century the following annals increase in interest. **Clyn**, as we have observed, was appointed the first Warden of the Franciscan Friary of **Carrick** in 1336. For such an office, implying authority and discretion, it is not likely that a man under 30 should have been selected from the convent of Kilkenny; and we may, therefore, conclude that **Clyn** was not born after 1306, and that he may have been several years older. We are then not surprised that his annals begin to expand, and to contain something more than brief and general entries, about the year 1315.


In the present times, when we gather almost all our knowledge from books, the period of whose history men are generally the most ignorant runs backward from their own youth to the commencement of the former generation. The history of the father's age has seldom been compiled by public writers in the days of the son, and is often not 



---

p.x




told by the father, upon whom, as it fell drop by drop, it left an imperfect sense of its relations and proportions; and the son, eager for something new or curious touching venerable antiquity, too often looks without interest or inquiry upon the days of his father, as upon times whose fashions are gone by, and whose notions he has outgrown. Even should the succeeding generation inquire into the history of that which immediately preceded it, the multitude of petty and vulgar details perplex the mind and disgust the imagination; and we wander about, as in a thick wood from which we have no clue to guide us, unable to recognise any of our well-known landmarks. But in the fourteenth century, when reading and writing were rare accomplishments, and when there were no standard libraries, the case was very different. Knowledge was then to be acquired, not from books, but from men. And what could men teach but what they had seen, in the words of **Clyn**, ‘occulata fide’, or what they had heard ‘fide digno relatu’? And, however highly we may value the following annals, from the year 1315, when **Clyn** was probably a grown man, able to make his own observations on passing events, we cannot but lament that he did not burn the previous entries, and write down the remembrances and the traditions of the seniors of his convent.


From the Scottish invasion in 1315, to the plague in 1349, may be considered as the period of Clyn's Annals. It was a dark and stormy period in the history of this country. It is strange that the reigns of the worst and weakest of the kings, that ever sat upon the throne of **England**, should have been the times of the greatest prosperity of the English in **Ireland**. In the times of **King John** and **Henry III** the English authority seemed about to consolidate itself throughout the kingdom. The whole country was then divided into shires, in which the king's justices held their pleas; the bishoprics, even in **Connaught** and **Munster**, were not filled without the king's license. **O'Conor** and **O'Neill** paid their tributes of cows and marks, and obeyed 



---

p.xi




the king's summons; and, although frequently goaded into resistance by the oppressions of the Earls of Ulster and of the lords of Connaught, these Irish dynasts seem to have been willing to consider themselves as English lords, and to have placed confidence in appeals to the justice of the English king; and as the plainest evidence of the tranquillity and prosperity of the country, the London treasury was enriched by the transmission to **London** of money from **Ireland**. Such was the state of **Ireland** during great part of the thirteenth century, as we learn from the Tower Records, from **Rymer**'s Foedera, and from the Rolls of the Irish Chancery, which are the authentic records of Anglo-Irish history. Doubtless the same facts may be learned with still greater distinctness from the Pipe Rolls, should they ever be published.


There were, indeed, in these reigns, feuds, bloody and interminable, between different lords in **Ireland**, both of Irish and of English blood. The predatory habits of the country were continued; and, except for the barbarized names of the Norman barons, the reader of the Irish chronicles would scarcely be able to distinguish the events of a year in the thirteenth century from those of most of the years in the eleventh; but at that period the great distinction between the English settlers and the native Irish was not strongly marked, although it had already manifested itself in religious houses of Irish foundation. The feuds were feuds between neighbours and not between nations. In almost all the frays, which have been dignified by the title of battles, English and Irish fought on both sides; and the descendants of **O'Melaghlin**, **O'Neill**, **O'Connor**, **O'Brien**, and **Mac Murrogh**, boasted that they belonged to the five bloods who were entitled to the coveted distinction of pleading the English law. If the daring and resolute **Prince Edward** spent any time in his lordship of **Ireland**, he probably thought that the authority of the sovereign and the dominion of the law were fully as much respected by the Irish chiefs and



---

p.xii




barons, as they were in England by the turbulent partisans of **De Montfort**, then plotting the overthrow of the monarchy and the imprisonment of the king.


Perhaps it was this confidence in the strength of the English in **Ireland**, joined, it may be, to a willingness to lower the pride and power of the Anglo-Irish nobles, that induced **Edward I** to neglect this country, and to waste the best blood of its lords in the wars in **Gascony** and **Scotland**. To whatever cause it may be ascribed, it is certain that, in the reign of that great and powerful prince, the power of the English government in this country lessened; the English lords became at once weaker and more insubordinate; while they adopted the customs, claimed the privileges, and exercised the tyranny of the native lords, to the extirpation of the sturdy English freeholders, they at the same time frustrated the wise and benevolent wishes of the king. He wished that the distinctions which were now felt between the English and the Irish, should be removed, and that all his Irish subjects, of whatever birth or descent, should enjoy the protection of the English law and submit to its authority.


It is natural that, at the first introduction of a foreign power into any country, the natives should jealously insist upon the preservation of their peculiar laws and customs; and such a condition seems to have been made by the Irish in the time of **Henry II**. But in process of time it is also natural that the weaker people should desire admission into the courts of justice of the stronger, and should petition to be altogether incorporated with them. This is the best homage to superior power and superior civilization. Woe to the stronger if they refuse such homage! Hereafter there will be two nations in one country; they will be for centuries in daily struggle as it were for life or death; and their bitterest enemies will be at their doors.


It is true that the Irish law, to which alone the Irish were subject, gave some advantages to the Irish culprit. For a crime for which an Englishman



---

p.xiii




would be hanged, an Irishman, according to the more lenient enactments of the Brehon law, might compound for a sum varying from £1 to £100 at the will of the judge. It is to be feared that the opposition of the Anglo-Irish lords to the extension of the English law proceeded from very base motives. They were at once jealous of the distinction of the English law, and anxious to escape from it. They claimed that the offences committed by an Englishman against an Irishman, should be tried by the Irish law, and they were unwilling that the offences of an Irishman against an Englishman should not subject the offender to all the penalties of the law of England. The **erics**, or compositions, payable by Irish criminals, enlarged the revenues of the courts of their palatinates and lordships; and, if the lands of the Irish chiefs were to be held by royal charters, the title of the native lords to their territories would then be secured by legal documents, acknowledged in the king's courts, and all chance of gaining possession of them, except by strictly legal means, would be terminated. The question of the advantage of establishing one uniform system of law throughout the country, especially when it was desired by the native party, appears now to be of very simple solution, yet it probably had its difficulties in former days. The opposition of the Anglo-Irish lords may have been justified by reasons which we do not see, and which we could not rightly appreciate. It is not fair to apply the notions of one century as a rule for measuring the conduct of men in another; and perhaps the statesman who is most aware of the conflicting interests and discordant wishes of two races occupying the same country,—of settlers and of natives,—will be the most disposed to excuse the conduct of the Anglo-Irish lords, and to pity the perplexities of the legislators or rulers of the fourteenth century.


In the hope of profiting by these internal dissensions, and being, perhaps, invited over by some of the Irish princes of **Ulster**, **Edward Bruce**, accompanied by **Randolph**, **Steward**, **Menteith**, **Campbell**, and many 



---

p.xiv




other of the knights of **Bannockburn**, with an army of 6000 men, landed in **Larne Lough** on St. Augustine's day, in 1315.


It was a luckless day for **Bruce** and for **Ireland**. Although successful in various engagements, and crowned King of Ireland at **Dundalk**, **Bruce** never had any firm power in this country. Of the English barons scarcely any were accused of favouring him, except the **Lacies** and their followers; and of their disloyalty, although their estates were forfeited and their persons proscribed, there seems to be some doubt. He was boldly opposed by the **Earl of **Ulster****, **Mandeville**, **Logan**, **the Savages**,—‘all hale the flur of Ullyster’,—and by **Bisset**, the descendant of a Scotsman, but not unmindful of the wrongs of his ancestors. Nor was he effectively assisted by the native princes. The usual fate awaited him, of those who, for their own aggrandizement, interfere in the civil dissensions of a foreign country. The objects of the parties are different, and each hopes to use the other only so far as may promote their own purposes. The Irish princes did not fight to change their masters, but to secure their independence, and they were no more willing to submit to a Scoto-Norman than to Anglo-Norman baronage. Meanwhile their general rebellion against the English for their own special objects, and the disunion of the English lords, any one of whom, we are told, would have been able, with his own followers alone, to have driven back **Edward Bruce**, allowed the **Scots**, now commanded by **Robert Bruce**, to ravage Ireland from Carrickfergus to Limerick. Although unable to take any walled town, and suffering the extremity of hunger from the general famine of the dreadful year 1316, in the words of **Clyn**, ‘They went through all the country, burning, slaying, depredating, spoiling towns and castles and even churches, as they went and as they returned.’ The horror at their cruelty, their impiety, and the misery that went with them, dwelt long in the minds of all the inhabitants of **Ireland**; and when the barons of **Meath** and **Louth** gave **Edward Bruce** battle, defeated, 



---

p.xv




and killed him at **Dundalk**, the Irish Annals of Clonmacnois declare that he was slain ‘to the great joy and comfort of the whole kingdom in generall, for there was not a better deed that redounded more to the good of the kingdom, since the creation of the world, and since the banishment of the Finè Fomores out of this land, done in Ireland, than the killing of **Edward Bruce**; for there reigned scarcity of victuals, breach of promises, ill performance of covenants, and the loss of men and women, throughout the whole kingdom, for the space of three years and a half that he bore sway; insomuch that men did commonly eat one another, for want of sustenance, during his time.’


Many generations passed before the devastating effects of the Scottish invasion, passing thus like a stream of lava through the country, were done away. The animosity between the English and the Irish was embittered, the sense of the greatness of the English power was diminished, the authority of law and order was impaired, the castle and the farm-house were alike ruined. The castle was more easily rebuilt than the more important farm-house. The noble may have had other resources; in later times we know that his castle was repaired and the expense of the district; he was bound by stronger ties to the country; and when his castle was rebuilt, it was at least comparatively secure: but when the homestead was wrecked and burned, and the haggard robbed of its stacks, and the bawn left without horse or cow, and ‘all his gear were gone’ the farmer, as he looked about him in despair, might well be excused if he fled away to some safer country; or if, listening to hunger, that evil counsellor, he became an idilman or a kerne, ready to plunder as he had been plundered, and eating up the produce of other men's labours.


If he endeavoured to remain, what was before him, but, poor and dispirited, deprived of his accustomed comforts, and of his comparative respectability, to sink hopelessly into a lower stage of society, and to yield to its customs; or rather to turn in sullen or in passionate anger 



---

p.xvi




from the civilization in which he no longer had a share, and to resent, as an injury, the existence of comforts which were his once, but were to be his no more, and to hate and to scorn their possessors?


Such, doubtless, was the history of the degradation of many English freeholders consequent upon the Scottish invasion; nor could the degradation be limited to the retainer alone. In a country in which there is no foreign interference, no rank of society can stand apart from others, and in proportion to its height it needs the more numerous supporters. The castle walls can no more keep out the influence of the social maxims and principles of the lower ranks of the people, than they can keep out the contagion of their diseases, and the lord necessarily partook of the degradation of the vassal.


To the Scottish invasion, then, may, at least partly, be ascribed the barbarism and the consequent weakness of the English in **Ireland** during the greater part of the fourteenth and the whole of the fifteenth century. In the thirty years that elapsed between that event and the close of **Clyn**'s Annals, that barbarism had made great progress. The power of the central government grew weaker; the lords, whether of Irish or of English blood, became more independent and irresponsible, and, consequently, more arbitrary and tyrannical, and private feuds, resulting in open violence, became of more frequent occurrence. The control of law nearly ceased, and little remained, as a rule of conduct, except the will of the stronger. It then became a question whether this anarchy should continue, or whether it should result in the prevalence of either the English or the Irish system, or, as seemed more probable and more reasonable, whether some third system should not be developed, formed from the amalgamation of these two, and the natural growth of the circumstances of this country.


When the **Normans** came into **Ireland** they brought with them the feudal law system, and that law system, with all its complexities, they endeavoured 



---

p.xvii




to establish wherever they had dominion. It was the system of a victorious army cantoned amongst a conquered nation. In this country the feudal **Normans** met with the remains of the patriarchal system; of our society the type was, not an army, but a family. Such a system, doubtless, was subject to many inconveniences. The breaking up of all general authority, and the multiplication of petty independent principalities, was an abuse incident to the feudal system; it was inherent in the very essence of the patriarchal or family system. That system began, as the feudal system ended, with small, independent societies, each with its own separate centre of attraction, each clustering round the lord or the chief, and each rather repelling than attracting all similar societies. Yet the patriarchal system was not without its advantages. If the feudal system gave more strength to attack a foreign enemy, the patriarchal system secured more happiness at home. The one system implied inequality amongst the few, and slavery amongst the many; the other system gave a feeling of equality to all. It is needless to inquire which of these two systems was the better fitted to develope the powers and the virtues of mankind, and whether either of them could exist in a state of general refinement and civilization, which, perhaps necessarily, developes a system neither feudal nor patriarchal, but commercial, industrial, and pecuniary.


But, surely, it was not strange that a people brought up as members of septs, each recognised by the chief as of his blood, bearing his name, entitled by the law of gavelkind to a share of the public property, should be blind to the evils that belonged to such a system, and should have looked with wonder and contempt on the well regulated gradations of feudal authority, and with horror on feudal vassalage and serfdom. Such were the natural feelings of the native Irish, and when the course of the king's writs, and the power of the English courts, were limited by the weakness of the central government, they joyfully fell back upon their native customs, as expounded by the Brehons



---

p.xviii




upon the hills; and they made welcome, as the sons of Heber, Heremon, Ir, and Ith, those English lords, who, like the **Desmonds**, adopted the manners of the country, and were rebuked amongst their own countrymen, for being more Irish than the Irish. From the very nature of the patriarchal system the exactions of the native chiefs were not excessive. In the hands of the English lords these exactions became intolerable to their English dependents. Unlike the Irish chiefs, the English lords had no rule by which their demands were regulated; they were ignorant of the restrictions of the Brehon law; and the customary cáin or purveyance of the Irish chiefs, and the regulated and ascertained amount of their refections, became in English hands the unlimited, ‘outrageous’, coyne and livery, the ruin of the English yeomanry, and the object of the well-earned maledictions and denunciations of English judges, kings, and parliaments. Yet we find no complaint made by the native Irish against the levy of these dues by the Earls of Desmond. Those potent Earls, descendants of the first conquerors, had adopted the Irish customs, and were in fact, at the same time, Irish chiefs and English lords. By their Irish followers they were beloved with the most romantic and prodigal affection, and respected with almost superstitious veneration; and, so popular was the first Earl amongst the English people of Leinster, that their special object of detestation was **Sir Robert Ufford**, the vigorous English Justice, who drove the Earl into banishment, confiscated his lands, took his castles and at **Castle Island**, in **Kerry**, hanged his seneschal, **Sir John Cottrel**, and his knights, **Sir Eustace Power** and **Sir William Grant**.


It was time that some vigorous exertion should be made for the support of the English government. The haughty Anglo-Irish nobles ill brooked the authority of the English officials, some of whom were men of low rank and of no great personal reputation; and, indignant at the distinction made by the Parliament in **Dublin**, between the English



---

p.xix




by birth and the English by descent, and especially outraged by the King's order for the removal from office of all persons born in Ireland, they had held a Parliament at **Kilkenny**, not summoned by the King, under the presidency of the great **Desmond**. At that Parliament, professing their loyalty to the King, of which they had given proofs in following him, at their own charge, in his wars in **Wales**, **Gascony**, and **Scotland**, they claimed the rights and immunities secured to them by the great Charter, and manifested a determination to resist all attacks upon their privileges or their properties. This jealous and angry feeling between the English by birth and the Anglo-Irish produced an approximation of the Anglo-Irish towards the native Irish; and had not the obnoxious disqualification of the Anglo-Irish been withdrawn, and had not **Desmond** been beaten down by the strong arm of **Ufford**, there seems to have been a probability that the two races would at this time have been incorporated into one people, and that the English and the Irish systems would have been fused and melted into each other. But the circumstances of Ireland did not permit the growth and development of any internal system, with its peculiar compensations, producing in time its own corrections. The process of mutual assimilation was continually checked; Irish civilization, such as it was, was destroyed, and the English statesmen of the fourteenth century vainly busied themselves in striving to erect upon its ruins the incongruous system into which Norman feudalism had then been moulded by the social condition.


During the times contained in these annals the English Government had not power to control the excesses of its subjects, or to repress the attacks of its opponents. The great Anglo-Irish families had become septs. In **Clyn**'s Latin, the St. Aubyns, now corrupted into Tobins, and the Archdeacons, now transformed into the patronymic Mac Odos, or Codys, are ‘naciones et cognomina’; and he speaks of the Hoddinets and Cantetons, ‘cum multis de sanguine eorum’.




---

p.xx


If the Irish chiefs acknowledged no common authority, and felt no common interest, the same division prevailed amongst the lords of English descent. Englishman was now opposed to Englishman, and sought to revenge himself by the help of the Irish; nor did the English refuse their aid to the Irish when plundering their own countrymen. When **Brien O'Brien** ravaged Ossory and slew the loyal English of **Aghaboe** and **Aghamacart**, he had the help of the English of **Ely**.


The country was fast verging towards anarchy, and it was not easy to stay its descent. The sword of the Lord Justice, if put into the hands of any of the native lords, of the **Ormondes** or of the **Kildares**, was used as an instrument to avenge their own wrongs, or to promote their own interests, rather than to execute impartial justice and to promote the welfare of the whole country. Such also was the case during the lieutenancy of any of the great English lords, who had estates or claims in **Ireland**, such as the great **Mortimers**; and, perhaps, nothing brought the royal authority into greater disrepute than the use of it by these men as a cover for private revenge or for private gain. Nor were the evils fewer, if the administration of the government was intrusted to Englishmen unconnected with this country. Men of eminence, so situated, would scarcely accept the office; we know that **Pembridge** altogether refused it; and men of inferior rank and reputation, when invested with deputed and transient authority, were scorned by the haughty Irish lords, and were freely charged by them, and perhaps justly charged, with the grossest peculation and malversation. The castles of **Athlone**, **Roscommon**, **Rinduin**, and **Bunratty**,—say the Irish lords to **Edward** in 1343,—were lost, because his treasurers did not pay the constables the wages charged in their accounts; and they continued to charge for castles and constables, after the castles had been destroyed. Officials liable to such imputations could have no moral influence; and when some sturdy and honest man, like **Sir Thomas Rokeby**, who sold his plate to 



---

p.xxi




pay his soldiers, saying that he would eat off wooden platters and pay in gold and silver,—or when some bold and vigorous soldiers, like **Sir RobertUfford** or **Sir Anthony Lucy**, held the King's commission,— they were hampered by the narrowness of their allowances, and were thwarted by the old peers and ancient officials. The very success of their exertions brought with it no lasting national advantage. If they put down disturbance for a time, and reduced the English dominions to order and submission, yet, at the termination of their authority, there was a renewal of lawlessness; and the only lasting effect of their vigour was the weakening of the natural props and buttresses of internal government, and the consequent increase of anarchy and disturbance.


Such was the political and social state of **Ireland**, during the earlier part of the fourteenth century, as represented in the following annals, and such, with little alteration, it continued to be for several generations. Whatever were the faults of the several parties in this long and bitter struggle,—and, no doubt, all parties had great and grievous faults,—they were the faults rather of the times than of the men. At all events, it little becomes any Irishman of the present day to reproach their memories. He can scarcely do so without reproaching the memory of his own ancestors. There are few living Irishmen, whatever be their names, whether Celtic or Norman, in whose veins does not run the mingled blood of Norman and of Celt, or rather of Irishmen and Englishmen. Nor can the descendants of those good knights, who stood with **Edward III** in the trenches of **Calais**, or of those hardy squires who overthrew the victors at **Bannockburn**, be unwilling to claim kindred with the descendants of the Irish chiefs, whose names were in the songs of the poet and the legends of the saint, when the names of **Normandy** and of Norman were unknown.


Of the condition of the labouring classes during this period we know nothing from chronicles or histories. At that time the condition



---

p.xxii




of the poor was but little regarded, from which circumstance it may perhaps be inferred that there was among them no great, or at least no unusual misery; had such existed it would have forced itself upon the observation of the annalist. We may observe, also, that the existence of villeinage, when the rights to a man's labour was a valuable property shows that the population had not exceeded its just limits, and that the labourer, who, if he wandered from the land, was reclaimed by the lord, must have been supplied with food sufficient to maintain his strength. From monastic registries and chartularies, and other legal documents, we may painfully collect the history of the cultural classes, which the professed historian would not condescend to give; but even more valuable than these sources of information are the notices of labourers and farmers contained in contemporary poetry. What would we not give for such a picture of an Irish cabin in the fourteenth century, as **Chaucer**, the contemporary of **Clyn**, has given of an English cottage in the Nonne's Prieste's Tale?


The social evils of **Ireland**, in the time now under our review, seem to have been but little mitigated by the influence of religion. When the Anglo-Irish nobles were gradually falling into Irish customs, and were confederating, whenever it served their purpose, as readily with Irish against English as with English against Irish, we find national differences and dissensions, where we should least wish to find them, in the monastery and the convent. Although the authorities, as well ecclesiastical as civil, favoured the English party, the strife seems not to have been altogether unequal. ‘In 1325’, writes **Clyn**, ‘there was discord, as it were universally, amongst all the poor religious of **Ireland**, some of them upholding, promoting, and cherishing the part of their own nation, and blood, and tongue; others of them canvassing the offices of prelates and superiors.’ And he adds that in the same year, at the general chapter of the Order, held at **Lyons**, the convents of **Cork**, **Buttevant**, **Limerick**, and **Ardfert**, were taken



---

p.xxiii




from the Irish friars, and assigned as a fifth custody to the English.


In those evil days neither the persons nor the places dedicated to religion were safe from violence. We read in **Clyn**:

‘In the year 1323, on the Friday within the octaves of Easter, Philip Talon, with his son and about twenty-six of the Codhlitanys, was slain by Edmund Butler, Rector of Tullow, who, aided by the Cantitons, dragged them out of the church, and burned the church of Thamolyn, with their women and children, and the reliques of Saint Molyng.’


‘In 1336, on Thursday, the 3rd Ides of April, Master Howel de Bathe, Archdeacon of Ossory, a man of literature and munificence, with Andrew Avenel and Adam de Bathe, was killed by the O'Brynys of Duffyr, in defence of the goods of his church and parish.’


But, perhaps, the most striking entry on this subject is the following:

‘In 1346, on Friday, the 3rd Nones of May, Dermicius Mac Gilpatrick (surnamed Monoculus, in Irish Caeoch), who ever gave himself up to plots and treacheries, little regarding perjury, burned the town of Achabo, having taken and brought O'Carroll with him, and raging against the cemetery, the church, and the shrine of St. Canice, that most 



---

p.xxiv




holy abbot, the patron of the country and the founder of the abbey, like a degenerate son against a father, he burned them and consumed them in unsparing fire.’


Nor were oaths always reverenced, even when administered in any of those strange forms, with which the Irishman still occasionally endeavours to awaken the religious feeling and to bind the conscience of his opponent. So we are told in 1333, in the beginning of June, Scanlei Mac Gylpatrick, after many and reiterated oaths on different books and manifold reliques of saints, treacherously took and killed two of the sons of Fynyn Mac Gylpatrick, his uncle, and blinded and mutilated the third. Yet, notwithstanding the frequency of such acts evidencing the little power of religious principle, our ancestors were not devoid of religious feelings, of which, to omit others, the following entry is a proof: ‘Also in this year (1348), and chiefly in September and October, there came together, from divers parts of **Ireland**, bishops and prelates, churchmen and religious, lords and others, and commonly all persons of both sexes, to the pilgrimage and wading of the water at Thath Molyngis, in troops and multitudes, so that you could see many thousands there at the same time for many days together. Some came from feelings of devotion, but others, and they the majority, from dread of the plague, which then grew very rife.’


In the following annals there are some interesting notices of events not immediately connected with **Ireland**, such as, in 1347, the siege of **Calais**, at which were present **Maurice, Earl of **Kildare****, and the Kilkenny **Knight, Sir Fulco de la Frene**; and in the same year there occurs a very curious notice of the Tribune **Rienzi**. To mention all these, however, would be beyond our due limits; it may, however, be allowed to give here together the various notices which are scattered through different years relative to the City of **Kilkenny**.


We must, however, previously give admission to the following:

‘1329. In that battle, the battle in which the Louth men killed their 



---

p.xxv




new Earl, **John Birmingham**, fell **Caech O'Kayrwill** *O'Carroll*, that famous tympanist and harper, so pre-eminent that he was a phoenix in his art, and with him fell about twenty tympanists, who were his scholars. He was **Caech O'Kayrwill**, because his eyes were not straight, but squinted; and if he was not the first inventor of chord music, yet, of all his predecessors and contemporaries, he was the corrector, the teacher, and the director.’


The following are **Clyn**'s notices of **Kilkenny**:

‘1267. The Friars Preachers opened the convent at Ross, and the chapter of the Minors was held at Kilkenny.’


‘1302. About the feast of Pentecost died Michael, Bishop of Ossory, who was succeeded by William Fitz John, consecrated at Kilkenny, on the Sunday within the octaves of the Epiphany of the same year.’


‘1308. A chapter of the Minors at Kilkenny, on the feast of the Baptist.’


‘1315. A common parliament of the magnates at Kilkenny, in the beginning of June, to give aid and counsel against the Scots.’


‘1318. William Fitz John, Bishop of Ossory, is translated to the archbishopric of Cashel, in whose room is substituted Friar Richard Leddrede, who was consecrated by the Pope at Avignon, where the Roman Court then abode, on the 8th Kalends of May.’


‘1321. The new choir is built at Kilkenny.’


‘1323. Consecration of the great altar of the Friars Minors at Kilkenny. On the same day, to wit, 3rd Ides of January, the funeral of Sir Robert Schortals.’


‘1324. On Thursday, in the octaves of St. Hilary, William Outlaw, entangled in heresy and notoriously defamed, and failing in his purgation, publicly abjured his heresy in the church of St. Mary, in Kilkenny, reading a new profession of faith, and signing it with his own hand.’


‘1331. On Friday, the Feast of St. Cecilia the Virgin, by Nicholas, Lord



---

p.xxvi




Bishop of Waterford, the new cemetery outside the church of the Friars Minor of Kilkenny was consecrated.’


‘1332. The belfry of St. Canice of Kilkenny fell, and great part of the choir; the ruins broke down the vestibule of the chapels and the bells, on Friday, the 11th Kalends of June, so that it was a horrid and pitiful spectacle to the beholders.’


‘1334. On the feast of Tiburtius and Valerian, on Thursday, the burgesses of Kilkenny began to make a pavement.’


‘1335. On Thursday, the morrow of the Invention of the Holy Cross, Sir Remund le Ercedekne, with his two sons, Patrick and Sylvester, Sir William le Ercedekne, and eleven of that name, were slain by Leyath O'Morthe *Lewis O More*, his sons and servants, in a conference at Clargoly, as were Thomas de Bathe, Gerald Bagot, and others, to the number of 50. This Remund, with his two elder sons, and his uncle, Sir William, and three more of the name, were carried to be buried in the convent of the Friars Minors, on seven biers together, one following the other, through the town of Kilkenny, with the wailing of many.’


‘In the same year, on Thursday, the morrow of Lucia the Virgin, the great cross was put up in the centre of the market-place in Kilkenny, at which time many persons, flying to the cross, were marked on the naked flesh with the sign of the cross, with a red hot iron, that they might go to the Holy Land.’


‘1338. Sir Eustace le Poer, on the eve of the Ascension of our Lord, being then seneschal of Kilkenny, attached and imprisoned Sir Fulco and Oliver de la Frene, without showing them any cause for their caption; and they finding rather his malice and his revenge than the rigour of justice, Oliver prudently escaped from the castle on Ascension Day, and on the morrow, having assembled their men and their friends, with the strong hand they broke down the gates of the castle of Kilkenny, and brought out Sir Fulco in spite of the seneschal.’




---

p.xxvii


‘In the same year, on Tuesday, the 15th Kalends of December, there was a very great flood, such as was not seen for forty years before, and it overthrew and carried away many bridges, mills, and buildings. Of the whole abbey of the Friars Minors of Kilkenny only the great altar and the steps of the altar remained uncovered and untouched by the flood.’


‘1340. On the Friday within the octaves of Easter, Robert Conton was killed in the street of Kilkenny.’


‘1343. Building of the new belfry of the church of St. Mary.’


‘1347. On the same day, Palm-Sunday and the day of the Annunciation of the Blessed Mary, at Kilkenny, the Lady Isabella Palmer, who built the front of the choir of the friars, was buried. She reached a praiseworthy old age, and having lived in her widowhood religiously and honourably about seventy years, she passed from this world, as was said, and as is believed, in a state of virginity.’


‘In the same year, on the first Sunday in Advent, began the confraternity of the Friars Minors of Kilkenny, for the purpose of building a new belfry and of repairing the church.’


‘Also Friar Richard, Bishop of Ossory, obtained in the Roman Court an exemption from the jurisdiction and superiority of the Archbishop of Dublin.’


Such, with the notices of the plague before extracted, are the chief events given by **Friar Clyn** relative to the fair city of Kilkenny, in which he passed the greater part of his life.


The Castle still stands, no longer, as in his days, a prison and a fortress, but as **Spenser** described it, *a brave mansion in as fair a land as may be read.’’*

 Vainly will the antiquary seek for the great Cross in the centre of the market-place, where **Clyn** saw the pilgrims to the Holy Land burned with the sign of a cross on the naked flesh, with a hot iron; and where the young men of Kilkenny were taught by the **Protestant Bishop Bale** to act his strange dramas on 



---

p.xviii




a Sunday in 1552. The Cathedral of St. Canice yet remains a memorial of the piety of past generations, consecrated to the glory of God; but **Clyn**'s home is now ruined and profaned. Not gently sinking, like many other holy ruins, in silence and quietude, into natural forms, assimilating with natural objects, with trees, and hills, and rivers, breathing deeper and holier thoughts than in its days of power and splendour, the Friary of St. Francis is now surrounded with poverty and wretchedness in the centre of the town. It was used as a soldiers' barrack while its walls could be inhabited, and now its beautiful church, vocal in **Clyn**'s time with the constant voice of prayer and praise, is a racket-court for the citizens of Kilkenny.


To complete, as far as is in our power, the collection of Irish Annals contemplated by the **Earl of **Marlborough**** in the reign of **James I**, there is printed in the Appendix the only remnant of the Annals of Ross to which we have had access.


For the interesting and valuable notes, marked with his initials, the Editor is indebted to the **Rev. James Graves**, of **Kilkenny**, from whose local knowledge, and antiquarian zeal, that ancient city, and the adjoining district, will hereafter derive yet greater elucidation.


The notes marked ‘A. H.’ have been contributed by the Hon. **Algernon Herbert** and those marked ‘J. O'D.’ by Mr. **O'Donovan**.


The text bas been printed from a MS. in Trinity College Library, Dublin (E. 3, 20), in the same volume which continues the Annals of Ross and Dowling's Annals. It was collated with a copy of a later date in the possession of **Sir William Betham**, which is deficient in a few pages at the end, viz. from line 15, page 33, of the text now published.


Although MSS. of **Clyn** do not seem to have been of rare occurrence in the preceding century, in which they were quoted by **Harris** and 



---

p.xxix




by **Walker**, yet such has been the recent loss of Irish historical documents (affording strong proof of the utility of the labours of our Society), that these were the only MSS. accessible to the Editor when these pages were put to press; and, although evidently carefully written, it was impossible to place implicit reliance on them. It was, therefore, with great pleasure that it was ascertained, when four sheets of this edition had been printed, that a MS. of **Clyn** was to be found amongst the Rawlinson MSS. in the Bodleian Library.


For a most careful and elaborate collation of this earlier authority with the pages already printed from the College and Betham MSS., and with the proof-sheets of the subsequent pages, our Society is indebted to the **Rev. J. Wilson**, of Trinity College, Oxford. And it was



---

p.xxx




with great satisfaction that the Editor perceived that, although in the unprinted pages he adopted some better readings from the Oxford MS., yet that in substance and meaning it agreed so fully with the other MSS. that there was no necessity for cancelling any of the pages already printed off.


### Postscript


After the Notes had been printed off, the Editor received the following remarks, which are too interesting to be omitted, and are, therefore, inserted here. For the information they contain he is indebted to **Mr. Prim**, of **Kilkenny**, and to the **Rev. James Graves**.


The Franciscan Abbey, Kilkenny.


It appears by entries in the Clasped Book of the Corporation of Kilkenny, that the Franciscan abbey was assigned for building barracks on the 19th of September, 1698.


‘5th April, 1700. The waste of Francis' abbey, in addition to the former grant, given for building barracks.’—Id.


‘31st August, 1708 St. Francis' abbey (now in the possession of his father) set to John Desborough, Jun., for forty-one years from the following Michaelmas,



---

p.xxxi




at £10 1s. per annum, excepting thereout the horse-barrack, hay-yard, and the set of pillars and uncovered walls within the said abbey.’—Id.


The Corporation possesses the original grants of the Black and Grey friars, and their possessions, made to them by Henry VIII., in the thirty-fifth year of his reign.


It appears from the City Books that the Franciscan abbey was canted to Alderman Evans at £6 a year, fee-farm lease, December 19th, 1724. It is still held by his descendants, who are reduced to poverty.—J. G.


The ‘Pavage’ of Kilkenny.


The burgesses of Kilkenny were incorported by William, Earl Marshal, the elder, before the year 1220, and received several important Charters from that nobleman's successors in the lordship of the district; but the first royal grant obtained by the Corporation of the town, which can be found in the Calendar of Rolls, was made on the 25th November in the year named in the text, 1334, and as it conferred upon the ‘provost, bailiffs, and true men of Kilkenny,’ the right of pavage for seven years, to pave their town, it appears by our author that they lost no time in carrying its design into execution. [Rot. Claus. 8 Ed. III 123.] However, after the expiration of the seven years of which the privilege of "pavage" lasted, it would seem that the repair of their streets was very much neglected by the burgesses. A manuscript preserved amongst the Clarendon Papers, British Museum (tom. li. No. 479), which was written in the early part of the seventeenth century, and is devoted to a description of Kilkenny and the diocese of Ossory, notices the commencing of the pavement of the town in 1334, and observes: ‘Cujus instaurationem a tanto tempore intermissam aut certe plurimum neglectam aggrediebatur vir nobilis L. S. dum esset urbis Praetor anno salutis ...’ The initials here given would correspond with the name of Luke Shee, son of Sir Richard Shee, Knight of Uppercourt, who was Mayor of Kilkenny in the year 1613, as appears from the following entry in the Red Book of the Corporation of Kilkenny, folio 311, under the date September 10th, 1613: ‘Mr. Luke Shee refused to serve as mayor. His reasons were, that he lived in the country, and, though named an alderman in the Charter, never took the oath



---

p.xxxii




of an alderman. The Corporation answered that he had an house in the town, and therefore was an inhabitant; and that he had voted and acted as an alderman, and therefore was an alderman. He submitted to the Corporation and was fined 100 marks, Irish; and a by-law made that every person hereafter refusing to serve mayor, when elected, shall forfeit 200 marks and be disfranchised.’


The reparation of the ancient pavement of Kilkenny, thus begun by Lucas Shee in 1613, would seem to have been carried out by his immediate successors in office; but the Corporation appears only to have paved the centre of the streets, and to have caused the side ways to be repaired at the expense of the inhabitants. Thus in the Red Book at folio 341, under the date 1615, we find the following entry:


‘A person hired by the city, by the year, to repair the streets. Everybody to find labourers and pave before their own doors; those who have leases, of which twenty-one years are to come, to pay as inheritors; those who have less time, the cost to be divided between them and the landlord, according to the number of years to come.’


In the White Book under the date 27th January, 1670, is the

following: By-law for paving the streets.—‘Every inhabitant, to pave the breadth of his front and twenty feet into the street; and if those pavements do not meet, the city to pave the remainder. But if the gutter be above twenty-one feet from the door, the inhabitant to pave the gutter. If the street be not forty-two feet wide, the opposite inhabitants to be at equal expenses. If not paid on notice from the mayor, to be distrained for double the value of the pavement.’


Again the Clasped Book records that on the 22nd April, 1694, it was ‘Ordered,—that each inhabitant of this city do pave the gutter before their doors, within the walls thereof; and that the city shall pave the rest.’


The Corporation of Kilkenny at the present day defrays the expense of repairing the pavement of the town within the limit of the ancient city walls, but



---

p.xxxiii




without their circuit, all such city works are carried on by the grand jury presentment.—J. G.; A. P.


The Market Cross of Kilkenny.


The ancient and beautiful structure stood in the centre of High-street, near the Tholsel, but was barbarously destroyed, by order of the Corporation, in the year 1771. A drawing of it was preserved by the Rev. Mervyn Archdall, which was engraved for **Ledwich**'s History of Irishtown and Kilkenny, in the second volume of the Collectanea de Rebus Hibernicis, and was copied in the first volume of the Dublin Penny Journal. In both of these works it is stated that the date "M.C.C.C." was indented upon its fourth step; but this must be a mistake, as **Clyn**, having been himself a resident of Kilkenny at the time, could scarcely be incorrect as to the period of its erection. In other respects the drawing would appear to correspond with the description given of the cross by **Archdekin**, **Motraye**, and other old writers. The Clarendon MS., tom. li. No. 479 already alluded to in the note upon the paving of Kilkenny, represents it as an arched structure, supported by marble columns, rising from a graduated base. Above the arch rose a slender shaft, upon the top of which was a richly sculptured cross, adorned with the figures of St. Kyran, St. Canice, St. Patrick, and St. Brigid, all of which religious personages are there asserted to have been the tutelary saints of the town. **Archdekin** states (Theologia Tripart. Universa. par. 3) the Puritan soldiers of **Cromwell** to have shattered, with their muskets, the portion of the carving which represented the symbol of the crucifixion; but **Motraye** mentions that in 1730, though ‘the arms of it were broken off, the shaft, adorned with good figures in relief, was well preserved.’


The plea upon which the Corporation of 1771 sought to justify the destruction of this venerable monument was, that it had fallen into a ruinous condition, and was dangerous to the public; but it is stated by old inhabitants who had often seen the cross before its final obliteration, that the expenditure of a few pounds would have been sufficient to have restored it to perfect repair, and preserve it to future ages. It appears from the municipal records that the civic representative body of the seventeenth century was as anxious for its preservation as the corporators of the eighteenth seem to have been regardless of its value.




---

p.xxxiv


It was recorded in the Red Book that, on the 9th February, 1609, an order was made by the Corporation that ‘the market cross and Croker's cross be for ever repaired and kept in repair by the company of masons, in such manner as the mayor shall direct.’ The preservation of the structure would appear to have been immediately thereupon undertaken, as on the 20th April following an invitation was sent forth to ‘every person that have plows within the city, to send them to draw stones from the quarry to repair the market cross;’ and on the 3rd August, in the next year, the following memorandum was inserted in the Red Book:—‘The market cross repaired May, 1610, by the Company of Masons. The Corporation paid for carriage and lime and sand.’ Again, under the year 1624, October 15th, is this entry: ‘Part of the Black Quarry allowed for making up the south side of the market cross.’


This is the last record which can be discovered of any attempt towards the reparation or preservation of the interesting and venerable structure; but there are some other curious allusions to the cross in the Corporation documents. On the 13th April, 1632, ‘the north side of the market cross was granted to two persons for shops during the fair times of Corpus Christi, in regard that their shops are stopped up by the stations and play of Corpus Christi Day.’ The market cross seems to have been the locality of the performance of the ancient plays and mysteries in Kilkenny. Two of the mysteries there acted, and specially written for the purpose by John Bale, the first Protestant Bishop of Ossory, in the year 1552, are still preserved amongst the Harleian MSS., and are extremely curious and interesting specimens of those religious dramatic entertainments; they are:—a tragedy entitled God's Promises, and a comedy named John Baptist's Preachings in the Wilderness, and both are strongly directed against Popery. The following passage from the curious personal narrative of Bale's Vocation to the Bishopric of Ossory, and Persecutions in the same, printed in the sixth volume of the Harleian Miscellany, is interesting as connected with the subject of this note:


‘On the xx daye of August was the Ladye Marye with vs at Kilkennye proclaimed Queene of England Fraunce and Ireland, with the greatest solempnyte, that there coulde be devised of processions, musters, and disgysings, all the noble Captaynes and Gentilmen thereabout being present. What-a-do I had that daye with the Prebendaryes and Prestes about wearinge the cope, croser, and myter, in prosession, it were to much to write. I tolde them earnestly,



---

p.xxxv




whan they would have compelled me thereunto, that I was not Moyses Minister, but Christes. I desyred them not to compell me to his Denyall, which is, S. Paule sayth, in the repetinge of Moyses sacraments and ceremoniall schaddowes Gal. V. With that I take Christes Testament in my Hande, and went to the Market Crosse, the people in great nombre followinge. There take I the xiii. chap. of S. Paule to the Romanes, declaringe to them brevely what the authoritie was of the worldly powers and Magistrates, what reverence and obedience were due to the same. In the meane tyme had the prestes gotten ii disgysed prestes, one to beare the myter afore me, and another the croser, making iii procesion pageaunts of one. The yonge men, in the forenoon, played a Tragedye of God's promyses in the olde Lawe, at the Market Crosse, with organe plainges, and songes, very aptly. In the afternone agayne they played comedie of Sanct Johan Baptistes preachings, of Christes baptisynge, and of his temptacion in the wildernesse, to the small contentacion of the prestes, and other papistes there.’


There are some curious notices, in the Red Book, of these religious plays subsequently to Bale's time. On the 20th April, 1610, it was resolved, ‘that the Mayor and Aldermen, with the advice of the Sheriffs and such of the second council as they shall cull, shall

order the celebration of Corpus Christi Day in decent and solemn manner as usual, and shall employ carpenters to make rails for keeping out horses and the mob, and for placing strangers at the place where the interlude shall be plaid.’ On the 23rd July, same year, the Corporation granted a salary of twenty shillings per annum to a person ‘for keeping the apparel used on Corpus Christi Day station, and the apparel of the Mories and players of the Resurrection;’ and on the 13th January 1631, was allowed ‘a salary of £3 13s. 4d. per annum to Wiliam Consey, for teaching to write and read, and instructing the children of the natives for the play on Corpus Christi day.’


Croker's cross, alluded to in some of the foregoing extracts, was of lesser importance than the market cross; it was a monument erected in 1407, in commemoration of the victory gained over the Burkes and O'Carrolls, at Callan, by Sir Stephen Scroop, the Lord Deputy, in whose army the burgesses of Kilkenny served, under the leadership of their Sovereign, John Croker. This monument stood in the cross-ways formed by the junction of High-street, Patrick-street, Roseinn-street, and the parade, called Castle-street, but



---

p.xxxvi




it has been long since removed. On the 9th February, 1609, the Corporation ordered, ‘that the market place for cattle be at James's-green and Walkin's-green, and from the market cross to Croker's cross; and no one to buy elsewhere.’ There were also several other similar monuments formerly existing in Kilkenny. The Butt's cross is the only one yet remaining, but the sites of others are determined by the old names of localities, such as St. Leger's cross, Crinius's cross, Scaldcrow's cross, &c. The author of the Clarendon MS., tom. 51, No. 479, states that at the beginning of the seventeenth century there was a monumental cross near the gate of the Franciscan abbey; he, however gives nothing of its history, except that it had been removed thither from the suburb, on the south side of the town, called Loughbuidhe.—J. G.; A. P.


THE CHURCH OF ST. MARY, KILKENNY.


The original structure of St. Mary's church appears to have been purely early English in style, and was probably erected shortly after the incorporation of the town by William Earl Marshal. The tower, whose erection **Clyn** has recorded, existed until the year 1819, when it was taken down. The church is cruciform, and the tower stood at the north-west angle of the body of the building, and was not, as the present tower is, attached to the west gable. An ancient trowel was discovered imbedded in the wall of the old tower, which was used in laying the foundation stone of the new one, but we believe that this relic is not now in existence.


The walls of the present church are portions of the original building, but the triple lancets in the north and south transept gables are the only original windows which have been retained. The chancel has been much curtailed in length, as appears by the following extract from the Vestry Book of the parish:


‘2 March, 1748. Agreed on by the minister, churchwardens, and parishioners, assembled that the eastern Ile or chancel be pulled down within twenty-one foot of the pulpit ... and that the several monuments in ye eastern isle and sheds may be removed and set up in such parts of the church as ye Bishop shall aprove of, at the expense of the proprietors.’


By an entry made in the blank leaf at the commencement of the parish Register



---

p.xxxvii




it appears that in 1774 the Corporation of Kilkenny ‘repaired the steeple, being in a very ruinous condition, and also adorned the church with an organ,’ which cost £300.


The parish of St. Mary is at present a perpetual curacy in the gift of the Bishop of Ossory, the curate being paid by minister's money; but originally it appears to have been an independent rectory. In the early taxations which occur in the Red Book of Ossory it is always termed "ecclesia.


Thus (at fol. 18, dorso) its value and denomination are given as under, in a taxation made at the commencement of the fourteenth century:


‘Ecc. be. Marie Kilkenn. cvi.s viij.d Deci.a x.s viij.d;’ and again in the new taxation made ‘post guerram Scotorum’, circ. 1320, the value and proxy payable thereout is thus given:


‘Ecc. be. Marie iiij.£i Deci.a viij.s procur. xij.d —’ Lib. Rub. Ossor. fol. 22, dorso.


The subsequent history of the parish is exceedingly obscure; whether at this period it was in the gift of the bishop is not stated in the taxations; but from various documents it appears that there was a very intimate connexion between this parish and the Corporation of Kilkenny. In a burgess rent roll, dated ann. 5. Hen. V. there are entries which show that the Sovereign and burgesses of Kilkenny had the setting of various houses and lands which were charged with the supply of lights for the church of St. Mary, and this before the Reformation, and consequent acquirement of confiscated church property.


Again, under the year 1643, we find ‘a docket of St. Mary's lands belonging to the city of Kilkenny,’ mentioning several houses and lands charged with ‘finding ropes for the bells in our Lady's church,’ ‘repairing the church from time to time,’ and ‘keeping, the style, with lock and key to the church-yard.’ Amongst the items is the following: ‘Edmund Grace for the Mary priest chamber and garden 61 years beginning 1621, at 20d per an.’ For a statement made by **Ledwich** on this subject see his Antiquities, second edition, p. 495. His authorities were the MSS. of **Counsellor James Laffan**, Recorder of the city of Kilkenny, which MSS. **Ledwich** borrowed, but never returned.—J. G.




---

p.1




---

p.2


#### 2.0


Anno secundo.


#### 2.1


Innocentes occiduntur.


#### 3.0


Anno tertio.


#### 3.1


**Herodes** occidit seipsum 

cultello, et **Johannes evangelista** natus 

est.


#### 19.0


Anno 19.


#### 19.1


**Johannes Baptista** predicavit in 

deserto.


#### 30.0


Anno 30.


#### 30.1


**Christus** baptizatus, incepit 

predicare, et conversi sunt Apostoli.


#### 33.0


Anno 33.


#### 33.2


9 Kal: Aprilis, **Christus** 

crucifixus est; 6 Kal: Aprilis, surrexit; 4 Nonas Maii, ascendit; 15 Maii, 

Spiritus super Apostolos descendit. Idus Julii, sunt divisi.


#### 33.1


17 Kal: Januarii, **Stephanus** lapidatus 

fuit.


#### 34.0


Anno 34.


#### 34.1


viii Idus Februarii, conversus est **Paulus**. Et 13 conversionis anno gentibus predicavit.


#### 34.2


Et nota, **Britones** in **Anglia** fuerunt ante 

Christi incarnacionem per mille quingentos annos et viii.


#### 34.3


Et quod prima etas mundi fuit ab **Adam** 

usque Diluvium, et continet annos 1256: secunda etas a Diluvio usque 

**Habraham**, et continet annos 292: tertia fuit ab 

**Habraham** usque **David**, et continet annos 

942: quarta a **David** usque transmigrationem 

**Babilonis**, et continet annos 473: quinta a transmigratione usque 

**Christi** adventum, et continet annos 588: sexta etas nulla 

annorum serie certa.


#### 34.4


**Petrus** post Domini passionem tenuit 

cathedram sacerdotalem in partibus orientis annis 4. Anno 20 vero cathedratur **Antiochie** 8 Kal: Maii, ubi sedit annis vii. Ibi primam missam celebravit; dicendo tantum verba Consecrationis, et Pater noster.


#### 38.0


Anno 38.


#### 38.1


**Matheus** scripsit ewangelium.




---

p.3


#### 45.0


Anno 45.


#### 45.1


Cathedratus fuit **Petrus**
**Rome** viii Kal: Februarii; ubi sedit annis 35, et mensibus 6, diebus 

7.


#### 45.2


 Hic 4 **Neronis** anno, cum 

**Paulo** martyrizatus.


#### 48.0


Quadragesimo octavo.


#### 48.1


**Marchus** scripsit 

ewangelium.


#### 49.0


Quadragesimo nono.


#### 49.1


Tempore **beati Petri** 

Maria mater Domini obiit, 8 Kal: Septembris, anno vite sue 63, secundum 

fidem Ebraicam, secundum vero cronica anni computantur sic, 14 

annos habuit quando natus est **Jesus**, 33 annis vixit cum 

filio, post cujus passionem vixit annis 16.


#### 58.0


Anno 58. Lapidatus est **Jacobus**, sed non 

ex toto extinctus.


#### 59.0


Quinquagesimo nono.


#### 59.1


Festus fuit procurator 

**Judeae,** a quo **Paulus** vinctus **Romam** 

mittitur.


#### 62.0


Sexagesimo secundo.


#### 62.1


Lapidatur **Jacobus** frater Domini, a **Judeis**.


#### 63.0


Sexagesimo 3.


#### 63.1


**Maria Magdalena** obiit.


#### 69.0


Sexagesimo 9.


#### 69.1


**Petrus** et 

**Paulus** sub **Nerone** passi sunt; qui eodem 

tempore occidit **Senecam** magistrum suum, matrem suam et 

sororem: et primam intulit christianis persecutionem.


#### 69.2


Hoc tempore **Lucanus** poeta moritur 

Parisius.


#### 72.0


Septuagesimo 2.


#### 72.1


**Jerosolyma** a **Tyto** et **Vespasiano** 

subvertitur.


#### 83.0


 Octuagesimo 3.


#### 83.1


**Johannes** ewangelista in 

**Pahtmos** relegatur, ubi scripsit Apocalypsim et octuagesimo 5 

scripsit ewangelium.


#### 97.0


Nonagesimo 7.


#### 97.1


Passio **Dionisii**, qui postquam decapitatus fuit caput suum portavit ad locum sepulture, cantans hymnum 'Gloria tibi Domine'.


#### 100.0


Anno 100.


#### 100.1


Obiit **Johannes** ewangelista, 

post passionem Domini 50, etatis sue 98.


#### 156.0


Centesimo 56.


#### 156.1


**Lucius** rex **Britannie** efficitur christianus a papa 

**Eleutherio**.


#### 233.0


Duecentesimo 33.


#### 233.1


Ordinatur **Ambrosius** apud **Mediolanum**; et **Augustinus** a beato **Ambrosio** baptizatur.


#### 233.2


Hoc tempore, **Turonis** beatus **Martinus** virtutibus radiabat.


#### 233.3


Jo: et Id: *et **Jeronimus*** apud 

**Behtleem**.


#### 265.0


Anno 265.


#### 265.1


Cepit **Lucius** papa, et 

**Anastasius** fecit simbolum 'Quicunque vult'.


#### 265.2


Et sanctus **Hilarius** claruit: et 

**Donatus** artis grammaticae.


#### 265.3


Et **Sixtus** Papa, et beatus 

**Laurentius** martyrio coronantur.


#### 286.0


Ducentesimo 86.


#### 286.1


**Dioclesiano** imperante, 

facta est persecutio christianorum, que duravit per annos 10.


#### 286.2


Circa illud tempus, heresis Arriana pullulabat, et 

dampnata in **Niceno** concilio.


#### 286.3


Hiis temporibus **Constantius** vir 

mansuetissimus regebat **Hispaniam**, **Galliam**, et 

**Britanniam**, et **Constantinum** reliquit filium suum


---

p.4






ex concubina **Elena**, creatum imperatorem 

**Galliarum**. Hec **Helena** fuit filia regis 

**Britannie**, secundum **Bedam** de gestis 

Anglorum.


#### 286.4


Et **Albanus** martirizatur.


#### 316.0


Anno 316.


#### 316.1


**Silvester** papa incepit, qui 

baptizavit **Constantinum** imperatorem magnum, et a lepra 

mundavit.


#### 316.2


Et sunt ab incarnatione Domini usque primum annum 

**Sylvestri**, 316 anni, et 20 dies.


#### 316.3


Dictus **Constantinus**, filius 

**Helene**, filie regis **Britannie** devicit 

**Maxencium**, et **Lucium**, et **Serenum** imperatores.


#### 316.4


**Maxencio** depulso in **Alexandria**
**Constantinopolim** transiit; et multos christianos occidit, et beatam 

virginem **Katerinam**.


#### 410.0


Anno 410.


#### 410.1


Inventio corporis **Sancti Stephani**, et **Augustinus** composuit librum de Civitate Dei.


#### 413.0


Tercentesimo 13.


#### 413.1


**Jeronymus** 

claruit.


#### 411.0


Quadringentesimo 11.


#### 411.1


Obiit **Martinus** **Turonensis** episcopus.


#### 423.0


Anno 423.


#### 423.1


Obiit **Augustinus**.


#### 423.2


**Palladius** mittitur ad **Hiberniam**.


#### 424.0


Quadringentesimo 24.


#### 424.1


Exordium regum **Francorum**; primus **Faramundus**: secundus 

**Clodio**.


#### 417.0


Quadringentesimo 17.


#### 417.1


Cepit **Celestinus** papa; hic misit beatum **Patricium** in **Hiberniam**.


#### 432.0


Quadringentisimo 32.


#### 432.1


Sanctus **Patricius** venit in **Hiberniam**, cujus etas sic distinguitur. 16 annorum fuit, quando a piratis de **Britannia** in **Hiberniam** captivus ducitur. 6 annis erat in servitute. 18 annis sub sancti 

**Germani** **Ancisiodorensis** episcopi magisterio deguit. 35 

**Hyberniam**, et alias insulas, ad Christum convertit. 33 annis 

contemplationi intendebat. Obiit autem anno 493 incarnacionis Christi; anno 

pontificante **Felice** papa;


#### 432.2


primo imperii **Anastasii** 

imperatoris:


#### 432.3


principante **Aurelio Ambrosio** in 

**Britannia**.


#### 439.0


Quadringentesimo 39.


#### 439.1


Nascitur beata virgo **Brigida**.


#### 457.0


457.


#### 457.1


Venerunt **Saxones** in **Britanniam**.


#### 490.0


490.


#### 490.1


Sanctus **Memertus** instituit 

**Rogaciones**.


#### 500.0


500.


#### 500.1


Obiit beatus **Benedictus**.


#### 525.0


Anno 525.


#### 525.1


**Francia** convertitur ad Christum.


#### 592.0


592.


#### 592.1


Cepit **Gregorius** papa, qui misit 3.o 

sui pontificatus anno beatum **Augustinum**, et alios in 

**Angliam** misit.


#### 595.0


595.


#### 595.1


Venit **Augustinus** in 

**Angliam**.


#### 606.0


Anno 606.


#### 606.1


Cepit **Bonefacius**, hujus 

tempore **Cosdre** rex **Persarum** vastavit 

**Jerosolumam**: et lignum crucis secum in **Persidem** 

perduxit.




---

p.5


#### 638.0


 Anno 638.


#### 638.1


Cepit **Severinus**, hujus 

tempore **Eraclius** occidit **Cosdre** regem 

**Persarum**: et crucis lignum reduxit in **Jerusalem**.


#### 688.0


Sexcentesimo 88.


#### 688.1


**Ysidorus** claruit.


#### 729.0


Anno 729.


#### 729.1


**Beda** claruit.


#### 799.0


Septingentesimo *nonagesimo nono*.


#### 799.1


**Karolus** vadit **Romam**.


#### 800.0


800.


#### 800.1


**Karolus** et **Lodovicus** imperatores perrexerunt in **Britanniam**. ~~Anno Domini 1066.Obiit Edwardus rex Anglie.~~


#### 942.0


Anno 942.


#### 942.1


**Willelmus** Dux **Normannie** occiditur.


#### 900.0


Nongentesimo.


#### 900.1


Obiit **Edmundus** rex martyrio.


#### 973.0


Nongentesimo 73.


#### 973.1


Martirizatus **Edwardus**.


#### 989.0


Nongentesimo 89.


#### 989.1


Obiit beatus **Dunstanus**.


#### 1066.0


Anno Domini 1066.


#### 1066.1


Obiit beatus **Edwardus** anno regni sui 24.


#### 1066.2


**Alfredo** fratre suo occiso per 

**Godewinum** comitem **Cancie**.


#### 1066.3


Cum ergo sanctus **Edwardus** non potiorem 

heredem haberet **Willelmo** cognomento Bastardo duce 

**Normannie**, consobrino suo, eidem regnum **Anglie** testamento 

legavit.


#### 1066.4


Hic **Willelmus** eodem anno, pridie ydus 

Octobris venit in **Angliam**, et interfecit **Haraldum**, filium **Godewini**, apud **Hastings**, et coronatur **Londini**, die Natali 

Domini.


#### 1087.0


Anno Domini 1087.


#### 1087.1


Obiit **Willelmus** 

primus Bastardus, anno regni sui 21.


#### 1087.2


Cui eodem anno successit filius ejus **Willelmus Rufus**.


#### 1103.0


Milesimo centesimo 3.


#### 1103.1


Hic **Willelmus Rufus** occiditur, dum iret venatum, anno regni sui 13.


#### 1103.2


Cui successit **Henricus I**, qui bonas condidit leges in **Anglia**.


#### 1106.0


1106.


#### 1106.1


**Henricus** Rex cepit **Normanniam**.


#### 1106.2


Due Lune vise sunt in celo.


#### 1109.0


1109.


#### 1109.1


Obiit **Anselmus**.


#### 1109.2


**Tamisia** exsiccatur.


#### 1120.0


1120.


#### 1120.1


**Ordo Premonstratensium** confirmatur.


#### 1125.0


1125.


#### 1125.1


Obiit **Henricus** rex. Successit 

**Stephanus**.


#### 1133.0


1133.


#### 1133.1


Domus **Clare-vallis** fundatur.


#### 1133.2


**Malachias** fit archiepiscopus 

**Ardmacanus**.


#### 1139.0


1139.


#### 1139.1


Monachi venerunt in **Hiberniam**.


#### 1142.0


1142.


#### 1142.1


Constituitur abbacia **Mellifontis**.


#### 1144.0


1144.


#### 1144.1


Puer **Willelmus** crucifigitur apud **Norwych**.


#### 1148.0


1148.


#### 1148.1


Obiit **Malachias** **Clarevallis**.


#### 1152.0


1152.


#### 1152.1


Christanus legatus mittitur in **Hiberniam**, 

et distribuit 4 pallia, et 4 archiepiscopatus constituit.


#### 1153.0


1153.


#### 1153.1


Obiit beatus **Bernardus**.


#### 1153.2


Sanguis e terra emanavit, apud **Hameste**.




---

p.6


#### 1161.0


1161.


#### 1161.1


**Thomas** consecratur 

archiepiscopus **Cantuariensis**; et anno 1165 exulatur.


#### 1169.0


1169.


#### 1169.1


**Dermicius McMorkada** ad 

**Henricum secundum** transfretavit pro auxilio 

habendo.


#### 1170.0


1170.


#### 1170.1


**Henricus** primogenitus 

**Henrici 2**, coronatur **Londini** a 

**Roberto** archiepiscopo **Eboracensi** et sex aliis 

episcopis.


#### 1170.2


Contra inhibicionem **Alexandri** pape 

iiii.ti et contra inhibitionem **Sancti Thome**. Ex hac 

consecratione venit episcoporum anathematizatio a sede Apostolica.


#### 1170.3


Inter patrem et filium consecratum dira rebellio. 

**Thome** occisio. Eodem anno scilicet 1170, in estate 

precedente **Thome** martirizationem, venerunt 

**Anglici** primo in **Hiberniam**. Versus:




> 1. Anno mileno centeno septuageno,
>   
> **Anglorum** primas corruit ense **Thomas**;
>   
> Pro Christi sponsa, Christi sub tempore, Christi
>   
> In templo, Christi verus amator obit.
> 




#### 1172.0


Milesimo centesimo 72.


#### 1172.1


Circa Kal. Maii obiit **Dermicius McMorkada** apud 

**Fernis**.


#### 1174.0


1174.


#### 1174.1


**Limericum** ab **Anglicis** occupatur.


#### 1177.0


1177.


#### 1177.1


**Vivianus** legatus mittitur in 

**Hiberniam**; et **Johannes de Curcy**
**Ultoniam** acquisivit.


#### 1183.0


1183.


#### 1183.1


**Anselmus** eligitur in archiepiscopum **Cantuariensem**.


#### 1183.2


1183. **Ordo Templariorum** et **Hospicilariorum** 

confirmatur.


#### 1185.0


1185.


#### 1185.1


Kal: Maii fuit eclipsis solis, sole existente 

colore sanguineo.


#### 1185.2


Post eclipsim **Johannes filius Henrici** regis **Anglie** cum magno exercitu **Hiberniam** intravit, sibi a patre traditam, mense 

Maii.


#### 1186.0


1186.


#### 1186.1


**Ordo Cartueciensium**, et **Granduensium** 

confirmatur.


#### 1186.2


1186. **Hugo de Lacy** 

occiditur.


#### 1187.0


1187.


#### 1187.1


**Jerusalem** cum cruce Domini capitur a **Saracenis**.


#### 1189.0


1189.


#### 1189.1


**Henricus 2**, filius Imperatricis 

obiit, pridie nonas Julii, cui successit filius ejus **Ricardus** magnanimus, coronatus 3 nonas Septembris.


#### 1190.0


Anno 1190.


#### 1190.1


**Ricardus** rex **Anglie** et **Philippus** rex **Francie** vadunt in terram sanctam.


#### 1193.0


1193.


#### 1193.1


**Ricardus** rex **Anglie** 

capitur in **Austria**, in reditu suo ab **Ierosolymis**, et 

redemptus infra sequens triennium, pro C. M. libris.




---

p.7


#### 1199.0


1199.


#### 1199.1


Idem **Ricardus** obiit, interfectus 

4 Idus Aprilis. Cui successit frater ejus **Johannes**, 

coronatus **Westmonasterii** in die Ascensionis, 5 Kal: Junii.


#### 1202.0


1202.


#### 1202.1


Fundatur domus de **Conale** per **Meylerum filium Henrici**.


#### 1204.0


1204.


#### 1204.1


**Johannes de Curcy** 

capitur a **Hugone de Lacy**.


#### 1214.0


1214.


#### 1214.1


Interdictum **Anglie** relaxatur.


#### 1215.0


1215.


#### 1215.1


Concilium generale celebratur **Rome** ab 

**Innocencio 3**, ubi conceditur **Cisterciensibus** 

nullas decimas dare.


#### 1215.2


Et **ordo Minorum** confirmatur.


#### 1216.0


1216.


#### 1216.1


Obiit **Innocencius**.


#### 1216.2


Successit **Honorius**.


#### 1216.3


**Ordo Predicatorum** confirmatur.


#### 1217.0


1217.


#### 1217.1


**Henricus 3** coronatur.


#### 1220.0


1220.


#### 1220.1


Obiit **Meylerus Henrici**, nobilis **Hybernie** conquestor.


Versus: Indomitus domitor totius gentis **Hybere**.


#### 1221.0


1221.


#### 1221.1


Predicatores intraverunt **Angliam**; et 

obiit beatus Dominicus, fundator eorum.


#### 1226.0


1226.


#### 1226.1


Obiit beatus **Franciscus**, 

transactis 20 annis postquam adheserat perfecte consiliis ewangeliorum 

perfectionis.


#### 1228.0


1228.


#### 1228.1


Translacio **beati Francisci**.


#### 1228.2


Et **Jerusalem** redditur christianis.


#### 1231.0


1231.


#### 1231.1


Obiit beatus **Antonius**, doctor de 

**ordine Minorum**.


#### 1232.0


1232.


#### 1232.1


Translatio **beati Antonii**.


#### 1233.0


1233.


#### 1233.1


**Edmundus** fit archiepiscopus 

**Cantuarie**, et translatio **beati Dominici**.


#### 1233.2


Et occiditur **Ricardus** comes Mariscalli 

**Kyldarie** in bello, per **Geraldinos**, locum et partem regis tenentes: Versus:




> 1. Post incarnatum lapsis de Virgine natum
>   
> Annis nongentis tribus triginta trecentis:
>   
> In primo mensis Aprilis, **Kildariensis**
>   
> Pugna die Sabbati fuit, in tristicia fati
>   
> Acciderant stallo pugne comiti Mariscallo.
> 




#### 1240.0


Anno 1240.


#### 1240.1


Nascitur **Edwardus primus filius Henrici** iii.


#### 1240.2


Et obiit **Eadmundus** archiepiscopus 

**Cantuariensis**.


#### 1241.0


1241.


#### 1241.1


**Gregorius** obiit, cui successit **Alexander**.


#### 1241.2


Sedes Romana vacabat per biennium.


#### 1242.0


1242.


#### 1242.1


**Willelmus de Marisco** 

proditor tractus est **London** ad caudas equorum.


#### 1243.0


1243.


#### 1243.1


Obiit **Hugo de Lacy**, 

comes **Ultonie**; et **Henricus** rex **Anglie** 

intravit **Vasconiam**.


#### 1243.2


Obiit **Geraldus filius 

Mauricii**, et **Ricardus de Burgo** in 

**Vasconia**.




---

p.8


#### 1245.0


1245.


#### 1245.1


**Innocentius** papa deposuit 

**Fredericum** imperatorem in concilio **Lugdinensi**, et 

obiit **magister Alexander Halys**, et 

**magister Johannes de Rupella**.


#### 1251.0


1251.


#### 1251.1


Validus ventus fuit in **Hibernia**, idus 

Januarii.


#### 1252.0


1252.


#### 1252.1


Occiditur Sanctus **Petrus** de 

**ordine Predicatorum**, et obiit **David** archiepiscopus 

**Casselensis**.


#### 1252.2


Successit **David McKarwyll**;


#### 1252.3


et magna siccitas fuit; et **Waterfordia** 

comburitur.


#### 1248.0


1248.


#### 1248.1


Incepit guerra **Mackanfy**, et 1250 occiditur idem.


#### 1253.0


1253.


#### 1253.1


Obiit **Robertus 

Grostete**, episcopus **Lincollniensis**; et 

**Alanus** **Lysmoriensis**.


#### 1254.0


1254.


#### 1254.1


**Hybernia** et **Austria** dantur **Edwardo** a patre suo **Henrico**.


#### 1255.0


1255.


#### 1255.1


Obiit **Lucas** **Dublin** archiepiscopus.


#### 1255.2


Et 4000 in **Wallia** occiduntur.


#### 1257.0


1257.


#### 1257.1


Obiit dominus **Mauricius filius Geraldi**, justiciarius **Hybernie**, in habitu, et frater minor.


#### 1258.0


1258.


#### 1258.1


Quatuor fratres regis **Anglie** exulantur, et ceteri alienigene; 12 pares constituuntur in **Anglia**, quorum consilio **Anglia** regeretur.


#### 1260.0


1260.


#### 1260.1


**O'Neyl** regulus **Ultonie** occiditur cum multo populo apud civitatem de **Duno**, dominica infra octavas Ascensionis, et **Willelmus de Dene** fit justiciarius **Hibernie**.


#### 1261.0


1261.


#### 1261.1


Occiditur dominus **Johannes filius Thome**, et filius suus in **Desmonia**.


#### 1262.0


1262.


#### 1262.1


Obiit **Ricardus de Clare**, comes **Gloucestrie**.


#### 1264.0


1264.


#### 1264.1


Bellum de **Lewys**. **Henricus** rex capitur, cum filio suo 

**Edwardo**, et **Ricardus** frater ejus, et 

alii nobiles multi.


#### 1264.2


Eodem anno guerra inter **Geraldinos**, et 

**Walterum de Burgo**, comitem **Ultonie**; et 

**Mauricius** filius **Mauricii** cepit apud 

**Tristeldermot** **Ricardum de la Rokele** 

justiciarium **Hybernie**, et **Theobaldum le Botiller**, et **Johannem de Cogan**, et carceribus de **Leye** et **Donmaske** mancipavit.


#### 1265.0


1265.


#### 1265.1


**Edwardus** evasit de custodia **Symonis de Monteforti**.


#### 1265.2


Et pridie nonas Augusti bellum apud **Evesam**, ubi occiditur **Symon de Monteforti**, et alii nobiles multi.


#### 1267.0


1267.


#### 1267.1


**Predicatores** ceperunt locum de **Ros**, et 

capitulum **Minorum** **Kylkennie**.




---

p.9


#### 1268.0


1268.


#### 1268.1


**Karolus** vicit **Coradellum** imperatorem **Grecorum**.


#### 1268.2


Item, dominus **Robertus de Ufford** fit justiciarius **Hibernie**.


#### 1268.3


Item, **Mauricius filius Geraldi** in mari submergitur, redeundo de **Anglia**, 5 Kal: Augusti.


#### 1269.0


1269.


#### 1269.1


Introitus fratrum in **Clonmele**.


#### 1270.0


1270.


#### 1270.1


**Lodowicus** rex **Francie**, 

et **Edwardus** rex **Anglie** vadunt in **Terram Sanctam**; 

**Lodowicus** in via moritur.


#### 1270.2


Item, **Walterus de Burgo** 

vincitur a rege **Connaccie** apud **Ahtkyppe**; multis nobilibus 

et militibus ex parte **Walteri** interemptis; vix eo fuge 

presid*io* se salvante.


#### 1270.3


Et **Jacobus de Audele**, fit 

justiciarius **Hybernie**.


#### 1271.0


1271.


#### 1271.1


Facta est magna fames in **Hibernia**, et 

pestilentia gravis.


#### 1271.2


Et obiit **Walterus de Burgo** 

comes **Ultonie**.


#### 1271.3


Item, occisi sunt domini **Nicholaus** et 

**Johannes de Verdona**.


#### 1271.4


Obiit **Fulco** archiepiscopus 

**Dublin**.


#### 1271.5


Obiit **Henricus** iiij.us rex 

**Anglie**, anno regni sui 56; et **Edwardus** filius 

ejus cepit regnare 5. Kal: Augusti.


#### 1271.6


Locus **Predicatorum** de **Yohil** 

capitur.


#### 1272.0


1272.


#### 1272.1


**Jacobus de Audele** 

justiciarius occiditur in **Totmonia**.


#### 1272.2


Item, **Mauricius filius 

Mauricii** fit justiciarius **Hybernie**.


#### 1274.0


1274.


#### 1274.1


Concilium generale apud **Lugdunum** 

celebratur a **Gregorio x.**


#### 1274.2


Interfectio **Anglicorum** apud **Glandelory**.


#### 1279.0


1279.


#### 1279.1


**Nicholaus** iiij.us fecit 

declaracionem super regulam **beati Francisci**.


#### 1279.2


In **Yoaellia** terremotus magnus subvertens 

castra, et absorbens homines discordes invicem bellantes.


#### 1279.3


Obiit dominus **David de Barry**.


#### 1280.0


1280.


#### 1280.1


Obiit **Nicholaus** Papa.


#### 1280.2


Et **Stephanus** episcopus **Waterfordie** de **ordine Hospitalariorum** mutavit monetam.


#### 1280.3


Captus fuit **Dermitius McMorkada**.


#### 1280.4


Obiit domina **Margaria de Say**, uxor domini **Roberti de Ufford**; et combusta est **Waterfordia**.


#### 1281.0


1281.


#### 1281.1


Occiditur **Hogekyn McGilpadricke**.


#### 1282.0


1282.


#### 1282.1


Guerra inter **Edwardum** iiij. regem **Anglie**, et **Walenses**.


#### 1282.2


Item, occisi **Morkardaht** et 

**Art McMorkarda**.


#### 1282.3


Capitulum apud **Dundalke**; **Matheus** fit minister **Hybernie**.


#### 1283.0


1283.


#### 1283.1


Fit guerra inter **Edwardum** iiij. 

et **Wallenses**; et destructa est **Wallia** per eum, et occisus 

est **Lewelyn** princeps **Wallie**, et 

**David** frater ejus captus, et tractus cum equis.


#### 1283.1


Item, combusta est **Dublinia** infra muros, in 

crastino Circumcisionis Domini.


#### 1284.0


1284.


#### 1284.1


Castrum de Leye perforatur per **Hybernicos**.


#### 1284.2


**Johannes de Sampford** eligitur 

archiepiscopus **Dublinie**.


#### 1284.3


Capitulum **Minorum** **Dublinie** in Pentecoste.




---

p.10


#### 1284.4


Item, dominus **Galfridus de Sancto Leodegario**, episcopus **Ossoriensis**, acquisivit per duellum, manerium de Serrkeran.


#### 1284.5


Item, dominus **Emflues**
***Alphonsus*** filius **Edwardi** iiij 

obiit.


#### 1284.6


Item, obiit **Karolus**, qui fuit 

Gallicus, et filius ejus fuit incarceratus.


#### 1285.0


1285.


#### 1285.1


Occisus fuit **Willelmus de Larokele**.


#### 1285.2


Obiit **Theobaldus Pincerna**.


#### 1285.3


Item, **Geraldus filius Mauricii, (dictus Rochfalyaht**) captus fuit a suis **Hybernicis** in **Offaly**, et detentus.


#### 1285.4


Item, rex **Philippus** intravit regnum 

**Arragonie**, per preceptum Pape.


#### 1285.5


Dominus **Willelmus Hacket**, cum 

multis de suo genere occisus fuit ab **Hibernicis**.


#### 1286.0


1286.


#### 1286.1


7 Idus Aprilis, id est Dominica Palmarum, **Johannes de Sampford** consecratur **Dublinie** in ecclesia Trinitatis.


#### 1286.2


Item, **Callan** in **Ossoria** combusta est.


#### 1286.3


Captus est **Calvah** apud **Kildariam**.


#### 1287.0


1287.


#### 1287.1


Mortuus est **Geraldus filius 

Mauricii**, capitaneus **Geraldinorum**; hereditatem suam 

dedit domino **Johanni filio Thome**, filio *avunculi* sui; hic **Johannes**, primus de hac natione factus est comes **Kildarie**.


#### 1287.2


Obiit dominus **Thomas de 

Clare**.


#### 1288.0


1288.


#### 1288.1


Dominus **Johannes filius Thome** amisit multos equos et garciones in **Offaly**.


#### 1290.0


1290.


#### 1290.1


**Judei de Anglia** exulantur.


#### 1291.0


1291.


#### 1291.1


Capitulum **Cork**.


#### 1294.0


1294.


#### 1294.1


In festo **beate Margarete** 

virginis, fuit fulgur et corruscatio destruentes blada, unde provenit maxima 

caristia, qua multi fame perierunt.


#### 1294.2


Item, eodem anno, ante festum Omnium Sanctorum, 

applicuit dominus **Gilbertus de Clare**, comes 

**Gloucestrie**, apud **Ros**.


#### 1294.3


Item, eodem anno, dominus **Johannes filius 

Thome** dedit vadium super dominum **Willelmum de 

Vescy**, in principio mensis Aprilis, pugnandi in duello contra eum.


#### 1294.4


Eodem die ad 40 annos occisus fuit **Ricardus** Mariscalli **Kildarie**.


#### 1294.5


1294. **Ricardus de Burgo** comes 

**Ultonie**, captus fuit per **Johannem filium Thome**, sabbato ante festum **Sancte Lucie** virginis.


#### 1302.0


1302.


#### 1302.1


Circa festum Pentecostes, obiit **Michaell **Ossoriensis** episcopus**, cui successit **Willelmus filius Johannis**, consecratus **Kylkennie**, dominica infra octavas Epiphanie, anno eodem.


#### 1303.0


1303.


#### 1303.1


**Ricardus** comes **Ultonie**
**Scotiam** intravit.


#### 1303.2


Obiit **Geraldus, filius Johannis, 

filii Thome**.


#### 1304.0


1304.


#### 1304.1


Abbacia **beate Marie** **Dublinie** et locus **Predicatorum**, eum suburbio illius comburuntur in festo **Sancti Collumbe** abbatis.




---

p.11


#### 1305.0


1305.


#### 1305.1


**O'Conkur**, regulus de **Offaly**, et **Calvaht** frater ejus, cum aliis 12 melioribus illius nationis interficiuntur in domo domini **Petri de Brimegham**, circa festum Trinitatis.


#### 1307.0


1307.


#### 1307.1


In crastino Purificationis Marie, capti fuerunt **Templarii** ubique.


#### 1307.2


Obiit **Ed. iiii.** 7. die 

Julii.


#### 1308.0


1308.


#### 1308.1


Capitulum **Minorum** **Kylkennie**, in festo 

**Baptiste**.


#### 1309.0


1309.


#### 1309.1


Obiit **frater Philippus de Norraht**, feria 3 ante Dominicam Palmarum.


#### 1309.2


Pullulabat secta **Soraboitarum**, presidente 

**Clemente Papa**.


#### 1309.3


Occiditur **Mauricius Canteton** 

et **David** suspensus.


#### 1309.4


Dominus **Johannes Bonevyl** 

occiditur.


#### 1310.0


1310.


#### 1310.1


Captus fuit dominus **Willelmus de 

Burgo**.


#### 1309.2


Interfectus dominus **Johannes de Crok**, cum aliis 

multis in bello de **Bonratte**, in die Ascensionis Domini, omissis in prelio spoliis multis.


#### 1310.3


Item, obiit dominus **Johannes de 

Cogan**.


#### 1311.0


1311.


#### 1311.1


Consilium generale celebratur **Vienne** per **Clementem undecimum**.


#### 1311.2


**Ordo Templariorum** distruitur.


#### 1311.3


1311. Occiditur **Philippus le Poer** per **Rupenses**.


#### 1311.4


Obiit **Eustacius le Poer** ante Pasca.


#### 1311.5


Captus est **Petrus de Caustona**
***Gavaston*** per Baroniam et decapitatus, in festo 

nativitatis **Baptiste**.


#### 1312.0


1312.


#### 1312.1


In festo **Aniceti** martyris, occiditur dominus 

**Nicholaus de Aveneil**, **Patricius 

de Rupe**, et **Hibernici** multi, per dominum **Nicholaum de Verdona**, et burgenses de **Dundalke**, juxta **Dundalke**.


#### 1312.2


1312. Capitulum **Minorum** de **Yohil**.


#### 1312.3


Natus est **Edwardus filius regis 

Edwardi 5**.


#### 1312.4


Et in sequenti Natali dominus **Johannes 

filius Thome** tenuit magnum, opulentum et pacificum festum apud 

**A*w*dayr**, et fecit **Nicholaum filium 

Mauricii de Kirrigia** militem, et alios duos.


#### 1313.0


1313.


#### 1313.1


Obiit dominus **Johannes de 

Burgo filius Ricardi**, circa Pentecosten.


#### 1313.2


Capitulum generale Barc [*gap: extent: a few letters*] nono et 

dominus **Edmundus Pincerna** tenuit **Dublinie** magnum festum in festo **beati Michaelis**, 

et fecit 30 milites.


#### 1313.3


In octabis **beati Francisci** proximo sequentibus capitulum de **Duno**.


#### 1313.4


Item, in natali Domini sequenti proximo, dominus **Mauricius filius Thome** duxit ad domum uxorem suam 

**Katerinam filiam Ricardi** comitis **Ultonie**; et fecit duos ibi milites **Edmundus le 

Botiller**.


#### 1314.0


1314.


#### 1314.1


Moritur **Clemens Papa xi*v***.


#### 1314.2


Item, occiditur dominus **Gilbertus de Clare** comes 

**Gloucestrie**, dominus **Robertus de Clifford**, et alii multi nobiles, atque flos **Anglie** apud 

**Strifling** per **Robertum le Brus** et **Scotos**, in festo **Johannis Baptiste**.


#### 1315.0


1315.


#### 1315.1


Commune parliamentum magnatum **Hibernie** apud **Kilkenniam**, pro


---

p.12






auxilio et consilio habendo contra **Scotos** in principio mensis 

Junii.


#### 1315.2


Illo tempore applicuerunt **Scoti** in 

**Ultonia**, quibus adheserunt toto tempore suo quo fuerunt in 

**Hibernia** quasi omnes **Hybernici** terre, paucis valde fidem 

et fidelitatem servantibus.


#### 1315.3


Eodem anno **Scoti** cum **Hibernicis** 

combusserunt **Dondalk** et locum **Fratrum** spoliarunt libris, pannis, 

calicibus, vestimentis, et multos occiderunt.


#### 1315.4


1315. Strages magna **Hybernicorum**, scilicet de 

**O'Mmorchys**, et hominibus illorum circiter 300 occiduntur juxta 

**Balilethan**, in Epiphania Domini.


#### 1315.5


Item, in crastino conversionis Sancti 

**Pauli** bellum de **Skethrys** inter **Anglicos**, 

ubi occiduntur de **Anglicis** tantum 5; de **Scotis** vero, circa 

70. Ibi occubuit ille nobilis guerrator, **Hamundus le 

Grasse**, et dominus **Willelmus Prindirgast** et 3 alii tantum, **Anglici** tamen campum 

dimiserunt cum **Scotis**, quorum princeps fuit **Edwardus 

le Brus**, ingerens se pro rege **Hibernie**, qui mala 

multa intulit hominibus pacem diligentibus.


#### 1316.0


1316.


#### 1316.1


Dominus **Johannes filius 

Thome**, *et* **Arnaldus le Poer**, ad 

**Edwardum** 5, in **Angliam** se transtulerunt, dantes 

obsides de fide et fidelitate servanda; et rex dedit **Johanni 

filio Thome** comitatum **Kildarie**, **Arnaldo** alias terras, pro garisona.


#### 1316.2


Item, dominus **Willelmus Comyn** 

cum duobus fratribus suis occiditur, circa festum **Baptiste**.


#### 1316.3


Item, occiditur dominus **Henricus Crok**.


#### 1316.4


Item, **Johannes de Dene**, 

**Patricius Lercedekne**, circa idem tempus.


#### 1316.5


Item, eodem anno et tempore, scilicet circa octavas 

**Baptiste**, fit magna strages **Hibernicorum** juxta abbaciam de 

**Balkynglas**; ubi circiter 300 occiduntur.


#### 1316.6


Item, ex **Scotis** interficiuntur circiter 300 in 

**Ultonia** per **Anglicos** patrie.


#### 1316.7


1316. Magna caristia salis in **Hibernia**, sic 

quod unus cranocus communiter vendebatur pro xl. solidis; in aliquibus locis 

pro 4 marcis et ultra.


#### 1316.8


Hoc anno omnes **Hibernici** fidem fedissime et 

fidelitatem deserentes, ut communiter se ad guerram posuerunt.


#### 1316.9


Item, eodem anno, in festo **beati Laurencii** martyris bellum de **Ahtnery** in 

**Connaccia**; ubi interficiuntur de **Hybernicis** per 

**Ricardum de Brimegham**, dominum 

**Willelmum de Burgo** et ceteros **Anglicos**, 

multi reguli et nobiles, secundum communem relatum summa totalis, v [*...*] 

[1](javascript:footNote('L100011/note001.html')) M. in 

universo, numerus capitum abscisorum mille quingenta capita.


#### 1316.10


Item, eodem anno circa natale Domini, intravit dominus 

**Robertus le Brus**, qui se gessit pro rege 

**Scotorum**, **Hyberniam** transiens per totam terram de 

**Ultonia**, ubi applicuit, usque fere **Lymericum**; comburendo, 

occidendo, depredando, spoliando villas, castra et etiam ecclesias, eundo et 

redeundo.




---

p.13


#### 1317.0


1317.


#### 1317.1


In Paschate, fuit magna congregatio magnatum 

**Hibernie** sub montem **de Loddyn** juxta **Lymericum**, 

contra **Scotos**; **Scotis** ex opposito apud castrum 

**Conyl** existentibus; et facti fuerunt ibi de **Anglicis** 6 

milites; et in hyeme precedente dominus **Ricardus de Clare** tenuit magnam gardam apud **Dernaht**.


#### 1317.2


1317. Dominus **Rogerus de Mortuo 

Mari** justiciarius factus, applicuit in Pascha apud **Yohel**, 

cum militibus 38, exiens de navibus fecit 2 milites; et applicans ad se 

dominum **Johannem de Brimegham**, dominum 

**Nicholaum de Verdona**, ejecit omnes de nacione et 

cognomine **de Lacy** ex **Hybernia**; et coegit fugere 

ad **Scotiam** in estate. Et occiduntur juxta **Pontensem** 

civitatem multi de **Ultonia**; quorum principalis fuit ubi de 

interfectis, **Willelmus Savage**.


#### 1317.3


Hii autem et alii **Ultonienses** per 

**Scotos** extra patriam suam expulsi fuerunt; et **Scotos** 

insequentes per **Mediam**, **Legeniam** et **Momoniam**, non minus quasi quam 

**Scoti** preter combustionem et interfectionem populo terre dampnum 

intulerunt.


#### 1317.4


1317. Capitulum **Waterfordie**.


#### 1317.5


Item, facta strages magna exercitus domini 

**Edmundi Pincerne** in **Hibernia** per 

**Donatum O'Karwyll**, ubi interficiuntur circa 

ducenti.


#### 1317.6


Item, **Rogerus de Mortuo Mari** 

fecit **Johannem Brimegham** militem, et alios tres 

vel 4.


#### 1318.0


1318.


#### 1318.1


7 Kal: Aprilis, canonizatur 

**Lodowicus** episcopus et confessor de **ordine Minorum**, 

archiepiscopus **Tolosanus**, filius et heres regis **Cicilie**, a 

**Papa Johanne 22**.


#### 1318.2


Item, duo cardinales in **Angliam** mittuntur pro 

pace formanda inter **Anglicos** et **Scotos**, sed nil profecerunt.


#### 1318.3


Item, eodem anno, dominus **Willelmus filius 

Johannis**, episcopus **Ossoriensis**, transfertur ad 

archiepiscopatum **Casselensem**; cui substituitur frater 

**Ricardus Leddrede**, per 

**Papam Johannem** consecratus **Avinnone**; ubi pro tunc 

degebat curia Romana, scilicet, 8. Kal: Maii.


#### 1318.4


Item, eodem anno, id est, 1318, a festo apostolorum 

**Philippi** et **Jacobi** usque autumpnum, fuit 

maxima caristia et fames, unde multi et innumerabiles moriebantur; nam 

cranocus frumenti ut communiter pro xx. solidis et amplius vendebatur.


#### 1318.5


Item, **Thomas Don**, multarum 

navium depredator, subversor, et pirata crudelis de parte **Scotorum**, 

occisus est.


#### 1318.6


1318. 5. Idus Maii, occiditur dominus 

**Ricardus de Clare** per suos **Hibernicos** de 

**Totmonia** cum aliis 4 militibus, domino **Thoma de 

Lesse**, domino **Henrico de Capella**, 

dominis **Jacobo** et **Johanne de 

Canteton**, et aliis multis, die Jove in mane.


#### 1318.7


Item, Capitulum de **Ros**, in festo 

**Bartholomei** apostoli.




---

p.14


#### 1318.8


Item, in festo Michaelis proximo sequenti, 

applicuit **Alexander Byggenor de Curia**, 

archiepiscopus **Dublinie** factus, et justiciarii nomen et officium 

habens **Hibernie**.


#### 1318.9


Item, eodem anno, 1318, in festo **beati 

Kalixti** pape et martyris, die Sabbati mane, occiditur 

dominus **Edwardus le Brus** (usurpans sibi nomen et 

vocari a suis se faciens regem **Hibernie**), apud **Dundalke**, 

per **Johannem de Brimegham**, et 

**Milonem de Verdona** cum **Scotis** 

multis.


#### 1318.10


Item, eodem anno, occiditur apud **Ros**, 

**Gilbertus de Rupe** (justorum occisor, et fidelium 

depredator) per burgenses de **Ros**.


#### 1318.11


Item, occiditur dominus **Johannes de 

Lyvet**, per **Tolonenses**, et **O'Nolanis**.


#### 1318.12


Item, circa festum Epiphanie interficiuntur per 

**O'Nolanos**, **Petrus de Recheford**, et 

**Oliverus filius David le Grasse**, et alii 

circiter 80, de exercitu domini **Arnaldi le Poer**, 

qui ductor erat et princeps eorum.


#### 1319.0


1319.


#### 1319.1


Occiditur **Johannes filius Donati O'Morthe** et alii fratres sui, pacis et 

pacificorum fidelium impugnator.


#### 1319.2


Item, occiditur dominus **Johannes le 

Botiller**, per satellites domini **Willelmi de 

Brimegham**.


#### 1320.0


1320.


#### 1320.1


Capitulum **Kildarie** in festo Sancti 

**Jacobi** apostoli.


#### 1320.2


Item, occiditur dominus **Fulco de la 

Frene**, per **Willelmum** et **Sylvestrem 

de Marisco** et ceteros satellites **Edmundi 

Pincerne**; volens suos et fideles patrie salvare, ne eos 

spoliarent; scilicet, die Dominica infra octavas **beati Martini** episcopi et confessoris.


#### 1320.3


Item, in estate precedente fuit congregatio pastorum 

diversarum terrarum versus Terram Sanctam, spe tamen frustrata, sine commodo 

qui supervixerant redierunt.


#### 1320.4


1320. Incepit universitas **Dublinie**, universitas 

quoad nomen, sed utinam quoad factum et rem.


#### 1321.0


1321.


#### 1321.1


Inter **Edwardum 5** regem 

**Anglie** et baroniam fuit maxima discordia, propter **Hugonem de Spenser**, qui contra eos fovebatur; et 

ipse **Hugo** per baroniam eum suo patre et filio exulantur, 

sed non diu exilium tenuerunt, reducti iterum per regem, et ditati excellenter.


#### 1321.2


Item, circa festum **Philippi** et 

**Jacobi** occiduntur de **O'Konchours**, circiter 300, 

in confinio **Midie** et **Legenie**, per **Andream de 

Brimegham**.


#### 1321.3


Item, capitulum de **Clare** in festo **Baptiste**.


#### 1321.4


Item, dominus **Johannes Brimegham** fit justiciarius **Hybernie**.


#### 1321.5


Item, **Meylerus le Poer** 

episcopus **Lehtlinensis** consecratus **Waterfordie**, Dominica 

Palmarum precedente.


#### 1321.6


1321. Obiit **Edmundus Pincerna**
**Londonii**, in vigilia exaltacionis Sancte Crucis, et in vigilia 

vigilie **beati Martini** episcopi et confessoris, apud 

**Baligaveran**


---

p.15






sepelitur.


#### 1321.7


Item erigitur novus chorus 

**Kilkennie**.


#### 1321.8


Item circa festum Omnium Sanctorum obiit 

**Willelmus filius Mauricii de 

Canteton**.


#### 1321.9


Item, 1321, occisus est dominus **Omfrey 

de Boun**, comes **Herfordie**, die Sancti 

**Patricii** apud **Burbrigs**, cum 2 militibus, per 

dominum **Andream Harcley**, quem idem comes militem 

fecerat; volens **Andreas** ex hoc regi placere, et placuit; 

quare rex eum comitem fecerat de **Karlel**, nec tamen 

commodum magnum reportavit; quia infra 2 annos ipse fedus cum 

**Scotis** in secreto (ut dicitur), contraxit: et per regem 

**Anglie** tractus et suspensus est.


#### 1321.10


Item, die Lune proximo sequente, in crastino Sancti 

**Benedicti**, decapitatus est dominus 

**Thomas** comes **Lancastrie**, **Leycestrie**, 

**Salisbirie** et **Lincolnie**, ac **Ferers**, 

filius *avunculi* domini regis, et advunculus regis **Francie**, et 

regine **Anglie**, per regem **Anglie** et suos justiciarios, ad 

instigacionem **Hugonis de Spenser**, cujus exilium 

ipse fecit et procuravit in communi parliamento **Londoni**.


#### 1321.11


Item, in eadem quindena, dominus **Rogerus 

de Clifford**, dominus **Johannes 

Mounbrey**, dominus **Bartholomeus de 

Baldismer**, et alii milites et barones, circiter 26, de melioribus 

et potioribus **Anglie**, suspensi et tracti sunt; alii vero multi 

nobiles, barones, milites et armigeri capti in diversis carceribus 

**Anglie** retruduntur, et redimuntur multo precio pro voluntate 

regis.


#### 1322.0


1322.


#### 1322.1


In principio autumpni, obiit **Ricardus 

de Brimegham**, dominus de **Ahtnery**.


#### 1322.2


Item, **Willelmus filius Reginaldi 

Conteton** (maximus malefactorum et depredator), Dominica ante 

festum **beati Michaelis** occiditur.


#### 1322.3


Item, Sabbato, in vigilia vigilie Sancti 

**Luce** ewangeliste occisi per **O'Nolanis**
**Andreas de Brimegham**, et dominus 

**Nicholaus de Lande** cum suis.


#### 1322.4


Item, isto anno, in autumpno intravit 

**Edwardus 5** **Scotiam** cum exercitu copioso valde, de 

quibus multa milia fame perierunt; nec tamen an parum profecerunt; sed redeundo captus dominus **Johannes de Britannia**, 

comes **Richmondie**.


#### 1322.5


Item, circa Natale vendebatur cranocus de sale, xx. et 

plus.


#### 1322.6


Item, 1322, in die Palmarum apud **Waterfordiam** 

consecrantur **Nicholaus Welyfed** episcopus 

**Waterfordie**, **Johannes Lavnaht** episcopus 

**Lysmorensis**, et episcopus **Fynaborensis**, eodem die et 

loco.


#### 1323.0


1323.


#### 1323.1


Feria 6. infra octavas Pasche, occisus est 

**Philippus Talon** cum filio et circiter 26 de 

O'Cod..[*gap: extent: a few letters*]tanys per **Edmundum le 

Botiller**, rectorem de **Tylaht** et **Cantitonenses**, 

qui eos de ecclesia extraxerunt, et ecclesiam de **Thalmolyn** cum 

viris et mulieribus et pueris, et **Sancti Molyng** reliquiis 

combusserunt.


#### 1323.2


Item, intra festum Assumptionis et Nativitatis Virginis, 

captus fuit.....[*gap: extent: a few letters*] **Mac Mor*kada*** et 

**Henricus O'Nolan** interfectus, et alii circa 24, 

per dominum


---

p.16


**Henricum Traharne**, et alios **de 

Valle**.


#### 1323.3


Item, in vigilia ad **Winculorum** Sancti 

**Petri** proximo precedente, dominus **Rogerus 

de Mortuo Mari** evasit de carcere turris 

**Londonii**.


#### 1323.4


1323. Consecratum est altare magnum Fratrum Minorum 

**Kilkennie**.


#### 1323.5


Ipso die, scilicet, 3. Idus Januarii, deposissio domini 

**Roberti Scorthals**.


#### 1323.5


Item, in purificatione **beate Marie** 

applicuit dominus **Johannes Darcy** justiciarius 

**Hibernie**, apud **Dubliniam**.


#### 1323.7


Item in lxx. mortuus est dominus **Willelmus 

de Burgo** junior.


#### 1323.8


Item, in vigilia **Benedicti** abbatis, 

interficiuntur de **Hibernicis** et malefactoribus de 

**Yi*r*left** circiter 200 per dominum **Robertum, filium 

Mathei Caunteton**.


#### 1324.0


1324.


#### 1324.1


Circa Pentecosten obiit in **Scotia** dominus 

**Walterus de Lacy**, de **Hybernia** 

exulatus.


#### 1324.2


Item, circa festum **Baptiste** obiit dominus 

**Eymerus de Valencia** comes **Penbrochi** in 

**Vasconia**.


#### 1324.3


Item, obiit **Johannes** primogenitus 

domini **Thome** comitis **Kyldarie** in **Anglia**, 

regi datus pro obside.


#### 1324.4


Item, eodem anno, scilicet 1324 die Lune in festo 

Processi et **Martiani** martyrum, domina **Alicia 

Kyteler**, propter sortilegia diversa et heresim multimodam, et 

sacrificia demonibus immolata, per fratrem **Ricardum 

episcopum **Ossoriensem****, est heretica judicata, probata et 

condemnata; presentibus domino **Johanne Darcy** 

justiciario **Hybernie**, Priore de **Kylmaynan**, Cancellario, 

Thesaurario, et **Arnaldo le Poer**, senescallo 

**Kylkennie**, hoc videntibus.


#### 1324.5


Item, circa translationem **Sancti Thome** 

martyris occiditur dominus **Walterus de Valle** cum 

filio suo, per illos de cognomine **de Crok**, juxta 

**Nenaht Ybreyn**.


#### 1324.6


Item, in crastino Animarum, anno eodem, mulier quedam 

**Petronilla de Midia** dicta de secta et doctrina 

predicte domine **Alicie** superius memorate, fuit de heresi, 

sortilegio et sacrificio demonibus immolato condemnata et igni tradita et 

combusta. A retro autem actis temporibus non est visum vel auditum, quod 

quispiam pro heresi penam mortis sustineret in **Hibernia** ante ipsam. 

Prima hec omnium secundum hominum memoriam tunc viventium et relatum, non 

dico quam sit quia in hoc facinore primo peccavit, sed quia primo passa est 

mortis justum judieium propter heresim.


#### 1324.7


Item, eodem anno circa festum **Leonardi** 

abbatis, mortuus est dominus **Johannes filius 

Thome**, frater domini **Mauricii filii 

Thome**. Miles iste juvenis juvenum consilio ut plurimum 

constipatus, ductus et seductus, a progenitorum ejus militia et vestigiis 

degenerans, pacis extitit non propugnator nec defensor, sed 

expugnator.


#### 1324.8


Item, hoc anno, scilicet 1324, fuit pestis gravis boum 

et vaccarum, in multis locis **Hibernie**.


#### 1324.9


Item, eodem anno ante Natale, **Arnoldus 

le Poer** tunc senescallus **Kilkennie**, cum aliis de 

comitatu eodem


---

p.17






tenuit magnam gardam apud **Ynistyoke** contra **Rupenses**, et 

eos fortiter obsessit, et obsides coegit reddere de pace et fidelitate amodo 

tenenda.


#### 1324.10


Item, eodem anno die Jovis ..............[*gap: extent: a few letters*] in octavis **Sancti Hilarii**, **Willelmus 

Owtlau** de heresi irretitus, et notorie defamatus, et in 

purgacione deficiens, in ecclesia beate Virginis **Kilkennie**, heresim 

publice abjuravit; professionem novam legens, et manu propria 

conscribens.


#### 1324.11


Item, Dominica precedente, obiit frater 

**David**, Prior de **Inystyoke**, vir venerabilis ac 

honorabilis multorum judicio apud Deum et homines.


#### 1325.1


Item, anno Domini 1325, occiditur **Dermicius 

Oge McKarthy** rex **Desmonie**, per 

**Willelmum filium Nicholai filii 

Mauricii**, apud **Traly**.


#### 1325.2


1325, fuit discordia ut communiter inter religiosos 

pauperes **Hybernie** quasi omnes, quidam eorum nacionis sue et 

sanguinis et lingue partem tenentes et foventes ac promoventes; alii 

prelacionis et superioritatis officia ambientes.


#### 1325.3


1325, die Lune in festo **beati Dominici** confessoris, 

occisus fuit dominus **Johannes de Barry de Hely**, miles strenuus et frequenter probatus in armis, per 

**O'Carwyllis**.


#### 1325.4


1325, die dominico in crastino octav: Sancti 

**Laurentii** occiditur **Dovenaldus Duff 

McGilpadricke** per suos consanguineos, sed prodiciose.


#### 1325.5


Item, eodem anno **Johannes de Brimegham**, et **Thomas le Botiller** 

collegerunt exercitum super **O'Carwyll**; qui hoc anno vix 

reliquit domum, castrum aut villam in **Elycarwyll**, inter 

**Anglicos** et pacis amatores, quin combussit et destruxit.


#### 1325.6


1325, in Pentecoste, capitulum generale celebratum 

**Lugduni**; ubi loca de **Cork**, **Boton**, **Lymyric** et **Tartdart** 

aufer*un*tur ab **Hybernicis** 

fratribus, et **Anglicis**, et quinta custodia assignatur, cum ante 

tantum fuissent 4 custodie.


#### 1325.7


Item, eodem anno feria quinta in crastino sanctorum 

martyrum **Dionisii** &c.; occiditur 

**Willelmus, filius Ricardi le Butiller**, 

cum multis aliis in **Totmonia**.


#### 1325.8


Item, eodem anno, circa festum 

**Sancti Thome** apostoli **Bren O'Bren**, 

vallatus auxilio **Anglicorum** de **Ely**, cepit magnam predam in 

**Ossoria**, in confinio de **Slesblanie**, et super 

**Athbo** et **Admacart**; et interfecerunt fideles 

**Anglicos** circa defensionem bonorum suorum.


#### 1325.9


Item, eodem anno die Lune in festo Epiphanie, in sero 

fuit ventus validissimus et tempestas prosternens domos et edificia, 

denudans ecclesias et monasteria, frangens et evellens radicitus arbores et 

campanilia multa, dispergens tassos bladorum et horrea.


#### 1325.10


Eodem die **Dublinie** fuerunt facti duo milites de 

**ordine Hospitalariorum**.


#### 1326.1


Item, anno 1326, in festo apostolorum 

**Philippi** et **Jacobi** (quod accidit die 

Ascensionis), occiditur per **O'Carwillis**, dominus 

**Matheus de Mylborne**, miles


---

p.18






probus et prudens, nacione Anglicus, sed usu loquendi 

Gallicus, Gallicum tantum loquens.


#### 1326.2


Annus autem iste siccus fuit ultra modum 

**Hybernie** consuetum; sic quod in yeme quasi parum pluvie fuit, in 

vere estate et autumpno quasi nichil, tanta fuit siccitas et tantus calor, 

quod fontes et magni rivuli (ubi semper emanabant aque copiose) penitus 

siccabantur.


#### 1326.3


Anno 1326. Die Martis ante festum 

**Petri ad Vincula**, obiit dominus 

**Ricardus de Burgo** comes **Ultonie** et 

dominus **Connaccie**, apud **Athyssell**;


#### 1326.4


miles prudens, facetus, dives et sapiens, plenus dierum; 

de isto communiter fuit dictum, quod filias ejus nobiliter graciose et 

excellenter maritavit; nam, unam **Roberto de Brus**, 

qui tunc preerat regno **Scotorum**; alteram comiti **Glovernie**; 

tertiam comiti **Kyldarie**; quartam comiti de **Lowht**; quintam 

domino **Mauricio filio Thome**; sextam sed seniorem 

domino **Thome de Multon** maritavit; filium filii 

sui reliquit heredem **Willelmum Johannis de 

Burgo** filii sui et filie comitis **Glovernie**.


#### 1326.5


Item, eodem anno die Lune in crastino Exaltacionis, 

obiit dominus **Willelmus filius Johannis**, quondam 

episcopus **Ossoriensis**; sed postmodum in archiepiscopum 

**Cassellensem** translatus; vir potens et dives, ac venerabilis in 

populo et in clero.


#### 1326.6


Item, eodem die occisi fuerunt de hominibus de 

**Cathyrlaht** et patria illa circiter 80, per **O'Morchys**.


#### 1326.7


1326. viii Kal: Octobris, applicuit domina 

**Isabella regina **Anglicorum**** cum filio suo 

**Edwardo** primogenito, de **Francia**, et vallata 

auxilio comitis **Hanaudie**, et domini **Rogeri de 

Mortuo Mari**; ceperunt **Hugonem de Spenser** comitem **Wyntonie** apud **Bristollum**, et eum 

ibi judicialiter fecerunt trahi, suspendi et decapitari, in quindena **beati Michaelis**.


#### 1326.8


Et in vigilia **beate Katarine** virginis 

eodem anno, dominum **Hugonem de Spenser** juniorem, 

qui filiam duxerat et heredem comitis **Glovernie**; et eum apud 

**Herefordiam** simili pena cum patre suo occiderunt, et eum trahi 

fecerunt, suspendi et decapitari, et membratim dividi, et quarteria sua ad 4 

Anglie angulos transmiserunt, capud mittentes **Londoniam** pro 

spectaculo.


#### 1326.9


Item, eodem tempore, dominus **Walterus 

Stapleton**, episcopus **Exoniensis**, et thesaurarius 

**Anglie**, **Londoniis** est decapitatus per cives, quia erat de 

parte secta et consilio Dispensatorum, qui nitebantur reginam et filium ejus 

destruere (postea regem), et de terra delere, ut dicebatur.


#### 1326.10


Item, anno eodem, in communi parliamento 

**Londonii** circa Epiphaniam deponitur **Edwardus quintus** 

 communi assensu cleri et populi, cui successit **Edwardus vi** filius ejus, 16 annorum; coronatus 

**Londonii** Dominica in vigilia Purificationis beate virginis, anno 

Domini 1326.


#### 1326.11


Obiit autem iste depositus **Edwardus** 

in castro **de Bercley** detentus, in festo sanctorum martyrum


---

p.19


**Eustacii** et sociorum ejus proximo post ejus depositionem 

et sepultus est apud **Gloverniam**.


#### 1327.1


Item, anno 1327, in festo Sancte Trinitatis, occiditur 

**Symon Purcyl**, tunc in officio vicecomitis 

**Kylkennie**, per **O'Brennanis**, et alii eum eo fere 

20.


#### 1327.2


1327, Dominica scilicet prima de Adventu, et in vigilia 

**beati Andree** apostoli, combusta est villa et fere tota 

baronia **de Kenlys** in **Ossoria**, per dominum 

**Willelmum de Brimegham** et **Geraldinos**, 

homines, scilicet, domini **Mauricii filii Thome**; 

et illo die ad octo dies combustum et destructum fuit **Grasiscastel**, 

cum toto territorio in circuitu; et fuit guerra sevissima inter 

**Geraldinos**, **Brimeghamys** et sua*m* sequela*m* ex parte una, 

contra **Poerinos** et illos **de Burgo** ex parte altera. Tunc 

unanimiter contra **Poerinos** insurrexerunt **Geraldini**, 

**Brimeghamys** ............[*gap: extent: a few letters*] sua potentia et illi 

**de Valle**, et **de Sancto Albino**, et **Ketyngys**, cum 

multis aliis nacionibus, et multos **Poerinorum** occiderunt, et fere 

omnes eorum terras combusserunt et destruxerunt.


#### 1327.3


1327. **Romani**, cum **Lodowyco** 

duce **Bavarie** in Imperatorem electum. —*Original hath a blank here - in 

margine.*


#### 1328.0


1328.


#### 1328.1


Feria 3 post Pascha, Nonas scilicet Aprilis, obiit 

dominus **Thomas filius Johannis**, comes 

**Kildarie**, justiciarius tunc **Hibernie**, apud 

**Maynoht**.


#### 1328.2


Item, die Martis pridie Idus Aprilis anno eodem, 

occiditur apud **Bargum**, **Willelmus filius 

Johannis de Rupe**, cum aliis malefactoribus, hominibus 

et consanguineis suis, de loco Predicatorum extractis.


#### 1328.3


Item 11 Kal: ejusdem mensis et anni, occiditur 

**Petrus Poer**, filius et heres baronis de 

**Donhulle**, cum aliis de cognomine suo circa 12, per familiam domini 

**Mauricii filii Thome**; et illo die occiditur 

dominus **Johannes filius Geraldi**, in eodem 

conflictu.


#### 1328.4


Item, eodem anno, 5 Kal: Junii, in vigilia Trinitatis 

obiit dominus **Willelmus de Sancto 

Leodegario**.


#### 1328.5


1328, capitur et occiditur in vigilia vigilie **beati 

Mathei** apostoli **Johannes filius 

Benedicti le Poer**, dominus **de Rahtgormocke** 

et **Kylmydan**, per **Cantitonenses**; et cito post obierunt 

**Katerina filia Mauricii**, uxor ejusdem, et heres 

eorum, apud **Ros**.


#### 1328.6


1328. **Edwardus** rex **Anglie** 

(post conquestum) tercius, fecit fratrem suum (**Johannem de 

Eltam** dictum), comitem **Cornubie**, dominum 

**Rogerum de Mortuo Mari**, comitem **Marchie**, 

et dominum **Jacobum le Botiller**, comitem 

**Ermonie**.


#### 1328.7


Item, 1328, circa festum **Michaelis**, 

**Willelmus de Burgo** comes **Ultonie**, in 

**Anglia** educatus, cum **Matilda** uxore ejus, filia 

domini **Henrici** comitis **Lancastrie**, et 

consanguinea ipsius, ex dispensacione curie disponsati, quia erant in


---

p.20






3 et 4 gradu affinitatis, venerunt ad **Hiberniam**; hic erat filius 

**Johannis de Burgo, filii Ricardi**, et 

**Elizabethe, filie Gilberti de Clare**; cui 

tertia pars terrarum comitis **Glovernie** competebat, ex parte matris 

sue ipsius **Elizabethe**.


#### 1328.8


1328. Dominica in crastino **Agnetis** 

secundo, obiit dominus **Johannes le Poer**, baro 

**de Dunhulle**.


#### 1328.9


Item, eodem anno scilicet ultimo die Februarii, die 

Martis, combustum est **Cumbyr**, per dominum **Willelmum 

de Brimegham**.


#### 1328.10


1328. 2 Idus Martii, die scilicet Martis ante festum 

**Patricii**, obiit **Dublinie** dominus 

**Arnaldus le Poer**.


#### 1329.0


1329.


#### 1329.1


Die Veneris in festo **Tiburcii** et 

**Susanne** combustum fuit **Drumhyrthyr** in vigilia 

vigilie Palmarum, per **O'Brenanys**; et die Lune post, per 

**Donatum McGilpatrick**, combusta patria de 

**Moyarfe** et spoliata.


#### 1329.2


1329. Die Lune in vigilia **Brandani** 

abbatis, occiduntur per **Rupenses** et **Barrenses**
**Jacobus filius Roberti filii Jacobi 

Ketyng**, cum aliis de suo cognomine; dominus 

**Philippus Hoddinnet**, **Hugo 

Canteton**, cum multis de sanguine eorum, circiter 140, tam de 

sanguine, quam de familia eorum.


#### 1329.3


1329. In vigilia Pentecostes, et **beati Barnabe** apostoli, dominus **Johannes de 

Brimegham**, comes de **Lowht** occiditur, contra eum 

conspiraverunt omnes de comitatu suo, nolentes eum regnare super eos; 

concilium fecerunt in unum, et in multitudine magna armatorum congregati, 

nulli de familia ejus parcentes, eum cum 160 et amplius, cum 2 fratribus 

ejus, et de cognomine ipsius circa novem interfecerunt.


#### 1329.4


In ista strage et eodem die **Cam 

O'Kayrwill**, famosus ille **timpanista** et cytharista, in arte sua 

fenix, ea pollens prerogativa et virtute, cum aliis tympanistis discipulis 

ejus circiter 20 ibidem occubuit. Iste .......[*gap: extent: a few letters*] vocatus 

**Cam O'Kayrwyll**, quia luscus erat nec habebat 

oculos rectos, sed oblique respiciens, et si non fuerat artis musice 

cordalis primus inventor, omnium tamen predecessorum et precedentium ipsum, 

ac contemporaneorum, corrector, doctor et director extitit.


#### 1329.5


Item in vigilia vigilie **Columbe** 

abbatis obiit **Robertus de Brus** rex 

**Scotorum**, in armis strenuus, in bellicis negotiis doctus et 

expertus; vulgari et communi relatu, in hiis vix in orbe parem 

habens.


#### 1329.6


Item, eodem anno in crastino **Johannis** 

et **Pauli**, die scilicet Martis, occiduntur per 

**Poerinos**, **Gilbertus** et **Remundus 

de Valle**, **Robertus O'Neyle**, cum 

aliis quasi ......[*gap: extent: a few letters*]


#### 1329.7


Item, eodem anno, Dominica in crastino 

**Magdalene**, occiditur **Malahtlyng 

O'Konkour**, non marte sed arte prodiciosa, per 

**Malmorthe** filium fratris sui, cujus patrem quoque 

principem de **Offaly** (ut regnaret) exulavit, eujus et filium 

**Dermoyd Oge**, et interficientis se fratrem, 

occiderat prodiciose, et sic ars deluditur arte.


#### 1329.8


Item, eodem


---

p.21






die occiduntur de **O'Dymyscy** circiter 200 post mortem ipsius 

**Malahtlyn** patriam ut eam spoliarent intrantes, et in eodem die, 

ibidem occiduntur de **O'Donyn** septemdecim.


#### 1329.9


1329. In prima hebdomada Augusti, **Breyn 

O'Breyn** villas de **Athyssell** et **Tyberary** 

combussit, atque totam patriam in circuitu vastavit spoliavit et destruxit.

Item, Sabbato ante festum **Laurencii**, occiditur per 

**O'Nolanys**, **David le Botiller**, juxta 

**Cathyrlaht**.


#### 1329.10


1329. Circa festum **Sancti Petri ad 

Vincula**, obiit **Londoniis** **Johannes Mc 

Carwyll**, primo episcopus **Corcagiensis**, postea 

**Midensis**, postremo factus archiepiscopus **Casselensis**, de 

Curia Romana rediens.


#### 1329.11


Item, *va* eodem anno, dominus 

**Jacobus pincerna** **Hibernie**, per 

**Edwardum** **Anglie** regem post **Normannorum** 

conquestum tertium, factus est comes **Ormonie** *cat*.


#### 1329.12


Et dominus **Mauricius filius 

Thome** per eundem, eodem anno, **Desmonie** comes est 

creatus.


#### 1329.13


Item, eodem anno, in vigilia **beati 

Laurencii** martyris, dominus **Thomas le 

Botiller** cum aliis circiter 100 per **Mc Hokegan** juxta 

**Molingar** occiditur.


#### 1329.14


Item, eodem anno, 14 Kal: Augusti, **Breyn 

O'Breyn** apud **Yrlef**, interfecit de exercitu 

**Willelmi de Burgo** comitis **Ultonie**, 

**Walterum filium Hillarii de Burgo**, 

**Konkur O'Breyn**, **Nicholaum Mc 

Nemare**, cum aliis nobilibus de **Totmonia**.


#### 1329.15


Item, eodem anno, Dominica ante festum 

**Mathei** apostoli, sole existente in Libra, castrum **de 

Leye** captum est per **O'Dymyscy**.


#### 1329.16


Item, eodem anno die Martis, in vigilia 

**Cicilie** virginis, dominus **Henricus 

Traharne**, et **Laurencius** frater domini 

**Jacobi le Botiller**, per **O'Nolan** sunt 

capti; ob quam rem dominus **Jacobus pincerna** 

collecto nobili exercitu, die Jovis in crastino **Lucie** 

virginis, et die Veneris sequente, terras eorum, et patriam fere totaliter 

ignis combustione vastavit.


#### 1329.17


1329. Idus Martii, captus est 

**Eadmundus** comes **Cantii**; et in crastino 

**Edwardi** regis et martyris decapitatus est apud 

**Wincestriam**, objecta sibi proditione, scilicet quod regem capere et 

occidere niteretur, ut dicebant.


#### 1330.0


1330.


#### 1330.1


In festo **Philippi** et 

**Jacobi** occiditur dominus **Jacobus 

Beufo**, cum aliis fidelibus plebanis circiter 120, per 

**Breyn O'Breyn**.


#### 1330.2


Item, die Lune in vigilia vigilie **beati 

Alexi** confessoris, anno eodem fuit **eclypsis solis**; et illo 

tempore, dominus **Willelmus de Burgo** comes 

**Ultonie** collegit exercitum copiosum **Ultoniensium** et 

**Connactenensium**; et dominus **Jacobus le 

Botiller** suum exercitum *duxit* super **Breyn 

O'Breyn**; eo quod eorum terras et patriam distruxisset. Qui 

omnes parum profecerunt contra eum illa vice; sed sine magno lucro vel 

dampno, dedecore vel honore ad sua sunt reversi.


#### 1330.3


Item, die Mercurii sequenti


---

p.22






in vigilia vigilie **beate Margarete** virginis, in predicta 

congregatione, juxta **Moyalby**, idem comes **Ultonie** fecit 

**Walterum de Brimegham**, et alium de sua familia 

milites. Dominus **Walterus**, dominum **Ricardum 

de la Rokel**, et dominum **Gilbertum de 

Brimegham**; et comes **Hermonie** fecit dominos 

**Eadmundum le Botiller**, **Robertum** 

et **Patricium Travers** milites; et dominus 

**Willelmus de Brimegham**, fecit dominos 

**Johannem de Sancto Albino**, et 

**Johannem Monsel** milites eodem tempore et 

loco.


#### 1330.4


Item, eodem anno, natus est **Henricus** 

primogenitus **regis Edwardi tertii** post conquestum; 

*et postea, mutato nomine 

**Edwardus** appellatur, iste **Edwardus** fuit 

pater **regis Richardi**, qui **Richardusprimo** 

vocabatur **Johannes***.


#### 1330.5


Item, eodem anno, Dominica in festo **Vitalis** et **Agricole**, 

occiditur apud **Kilkenniam**, **Donatus filius 

Galfridi Mc Gilpatrike**.


#### 1330.6


Item, in die Martis sequenti, in festo 

**Sancti Leonardi** natus est **Johannes** primogenitus 

**Jacobi le Botiller**, comitis **Ormonie**, 

apud **Athur**.


#### 1330.7


Item, anno eodem, Dominica in festo 

**beate Katerine**, fuit vehemens ventus et horribilis; et Dominica in vigilia nativitatis Domini ventus consimilis, qui tassos dispersit, domos 

distruxit, et mala multa fecit. Iste annus fuit omnibus hominibus contrarius 

et charus; et multi fame perierunt. Nam cranocus frumenti in hyeme, marca 

vendebatur, et ultra; sed propter bladum de partibus extraneis, parum ultra 

valuit in estate; a Mayo usque Februarium fuit humidus, pluviosus 

nimis et ventosus, ita ut estas et autumpnus in hyemalem tempestatem fere 

videbatur converti.


#### 1330.8


Item in vigilia Circumcisionis, **Ricardus 

O'Nolan**, in campanili monachorum de **Dowsky** fuit 

obsessus, et filium suum in obsidem dare compulsus est.


#### 1330.9


Item, anno eodem, morti damnatur **R. de 

Mortuo Mari** comes **Marchie**, ante Natale Domini.


#### 1330.10


Item, obiit **Walterus le 

Rede**, archiepiscopus **Cassellensis**, et 

**Robertus de Brimegham**, *circa Purificationem*.


#### 1330.11


Item, anno eodem, ante Dominicam Annunciationis, 

dominus **Thomas de Dene** capitur per 

**Hibernicos**, et vulneratur, aliquibus de familia sua peremptis; et 

ipse, die Jovis in crastino **Sancti Aniceti** pape et 

martyris sequenti, de vulnere accepto obiit.


#### 1330.12


Item, circa idem tempus, occiduntur duo filii domini 

**David Beket**, per satellites domini 

**Willelmi de Brimegham**.


#### 1331.0


1331.


#### 1331.1


Die Lune in crastino **Tiburcii** et **Valeriani**, occiduntur de **Mac Morchada** et **O'Brynnys** juxta **Weysfordiam**, per illos de patria illa, plusquam ducenti.


#### 1331.2


1331. Die Mercurii in vigilia 

**beate Marthe** ***beati Marci*** ewangeliste, occiduntur per 

**O'Thohyl**, dominus **Philippus le Brit**, et 

filius ejus, et unus templarius de **Geraldinis**, et alii valentes 

**Anglici** de patria, circiter 30.


#### 1331.3


Item, eodem


---

p.23






anno, die Mercurii infra octavas Pentecostes **Willelmus 

Haket** apud **Yorlys**, cum aliis de patria interficerunt de 

hominibus **Breyn O'Breyn**, et aliis 

**Hibernicis** circiter 50, et ipse idem **Willelmus** 

eodem die et loco occiditur.


#### 1331.4


Item, eodem anno, dominus **Willelmus de 

Brimegham** cum sua familia occupavit tenuit et mansit in sylva 

monachorum de **Dowsky** in estate, et ibidem dominus 

**Eustathius le Poer** die Mercurii in festo **Gervasii** et **Prothasii** desponsavit filiam **Johannis de Brimegham**, comitis de **Lowht**; et Sabbato proximo sequenti, interfecti sunt 9 de **Rupensibus**; inter quos interfectus fuit 

**David filius David filii Alexandri** de 

**Fermoy** et alii cum eis 19. Et captus est ..........[*gap: extent: a few letters*] filius **Georgii de Rupe**, gener domini **Willelmi Brimegham** de nupciis versus **Fernegylan** redeundo.


#### 1331.5


Eodem anno venit dominus **Antonius de Lucy**, justiciarius in **Hyberniam**, circa festum Trinitatis.


#### 1331.6


Item, circa idem tempus obiit **Ricardus 

filius Thome**, filius et heres comitis **Kyldarie**, 

etatis circiter 15 annorum.


#### 1331.7


Item, eodem anno, in vigilia **Alexandri** 

confessoris, satellites **Willelmi de Brimegham** cum 

**Cantitonensibus** et **Hibernicis**, 24 homines de villa 

**Thome** et **Jeriponte** occiderunt, et mala multa in 

patria illa fecerunt isto anno.


#### 1331.8


Item, eodem anno, scilicet 1331, **Mauricius 

filius Thome** comes **Desmonie**, et 

**Willelmus de Brimegham** die Lune, in festo 

**Benedicti** confessoris, pacem cum predicto 

**Antonio** justiciario, pro guerra sua fecerunt et tactis 

Evangeliis et Sanctorum reliquiis, ac Christi corpore adducto, juraverunt 

pacem et fidelitatem domino regi et populo de cetero servare. Multi etiam de 

secta eorum hoc tempore pacem gravi redemptione comparaverunt. Ubi 

proclamatum fuit, quod nulla de cetero pro morte Anglici redemptio 

et pax concederetur. Eodem die juxta **Balligaveran** occiduntur et 

capiuntur **Cantonenses**.


#### 1331.9


Item, isto anno, circa festum **Johannis Baptiste** 

projecti sunt ad terram in portu **Dublinie**, juxta villam, 

multi et grandes pisces marini, ....[*gap: extent: a few letters*] et innumerabiles, quot 

non vidit etas hominum in **Hibernia** tunc viventium; erant in 

longitudine 40 pedum, quidam 30; ita quod quidam illorum vix nec virtute 

hominum, vel robore jumentorum de loco trahi poterant; et tante erant quidam 

altitudinis, ut duobus hominibus longis circa unum piscem stantibus, ex una 

et altera parte ventris *neuter* alterum videre poterat.


#### 1331.10


Item, anno eodem, dominus **Mauricius filius 

Thome**, infra quindenam post pacem sibi concessam per eundem 

justiciarium, apud **Limiricum** est captus, et in custodia sua 

detentus; et vi. Kal. Martii apud **Clonmele** capiuntur per 

eundem domini **Willelmus** et **Walterus 

Brimegham**.


#### 1331.11


1331. Die Lune in festo **beati Hillarionis** abbatis, occiditur **Ricardus** filius


---

p.24


**Philippi O'Nolan**, per **Pincernam** et suos 

consanguineos.


#### 1331.12


Item, eodem anno, die Veneris, in festo **beate Cecilie** virginis, per dominum **Nicholaum**
**Waterfordensem** episcopum, *consecratum* est novum cimiterium extra ecclesiam **Fratrum Minorum** **Kylkenie**.


#### 1331.13


Item, 1331, circa festum Omnium Sanctorum, obiit 

**Dublinie**, **Katerina de Burgo**, uxor 

**Mauricii filii Thome**.


#### 1331.14


Item, eodem anno, circa festum **Lucie** 

virginis, occiditur **Jordanus Caunteton** et alii de 

cognomine suo, per **Brein de Nathyrlah**.


#### 1331.15


Item, hoc anno, dominus **Willelmus de 

Burgo** comes **Ultonie** cepit et incarceravit **Walterum de Burgo** et fratres ejus, in castro de **Knockfergus**.


#### 1331.16


Item, eodem anno, natus est **Jacobus, 

filius Jacobi le Botiller** apud **Kylkenniam**, 

in festo **beati Francisci**.


#### 1332.0


1332.


#### 1332.1


Cecidit campanile Sancti **Kannici**, **Kylkennie**, et magna pars chori, 

vestibulum capellarum, et campanas, et meremium confregit, die Veneris, 11 

Kal: Junii; unde horribile et miserabile spectaculum erat contuentibus.


#### 1332.2


1332. **Antonius de Lucy**, 

justiciarius, in crastino Trinitatis collecto exercitu castrum de 

**Clonmore** reparavit et renovavit; et in principio autumpni immediate 

sequentis, castrum de **Arclo** reedificavit.


#### 1332.3


Item, eodem anno, in festo **Pii** pape, 

die Sabbati **Dublinie** suspenditur dominus **Willelmus 

de Brimegham**, miles strenuus et bellicosus, miles audax et 

inperteritus.


#### 1332.4


Eodem vero tempore, castrum de **Bonrat** (quod 

multorum judicio inexpugnabile videbatur); per **O'Brein** et **Mc 

Nemare** destruitur.


#### 1332.5


1332. Fuit guerra inter **Edwardum de Bayloyle** et **Scotos**; et multi **Scotorum**, per ipsum 

et **Anglicos** sunt interfecti.


#### 1332.6


Item, eodem anno, obiit in carcere **Walterus 

de Burgo**.


#### 1332.7


Item, isto anno, post festum Omnium Sanctorum, comes 

**Ormonie** et **Geraldini** et ***Bu*rgudini**, cum populo 

communi guerram habuerunt, contra **Bren O'Bren**; et 

multos de suis occiderunt valde, et magnas predas ab eo et suis ceperunt.


#### 1333.0


1333.


#### 1333.1


In principio mensis Junii, **Scanlei 

Mc Gylpatrick** prodiciose, post multa et iterata sacramenta 

super diversis libris, et sanctorum multiplicibus reliquiis, duos filios 

**Fynyn Mc Gylpatricke** avunculi sui cepit et 

interfecit; et tercium exoculavit et castravit.


#### 1333.2


Item, eodem anno, sexto die Julii in octabis Trinitatis, 

**Willelmus de Burgo**, comes **Ultonie** 

dominusque **Connactie**, juxta **Cnokfergus** per suos armigeros 

(in quibus confidebat), prodiciose occiditur. Hujus autem sceleris autores 

erant, **Johannes de Logan**, **Robertus 

filius Ricardi Mandevyle**, **Robertus 

filius Martini Mandevyle**, qui tamen breve et momentaneum


---

p.25






ex hoc solacium sunt consequti; nam **Hibernicis** se jungentes (qui 

semper **Anglicorum** et fidelium persecutoribus receptores amici et 

defensores esse solent), infra menses duos, per **Johannem de 

Mandevyle** et paucos de patria, ccc. et amplius uno die occiduntur. 

Hoc malum, ut assolet, per mulierem, scilicet **Gyle de 

Burgo**, uxorem domini **Ricardi de 

Mandevyle** dicebatur perpetratum; eo quod fratrem ejus 

**Walterum de Burgo**, et alios incarceravit. Hic 

comes subtilissimi erat ingenii, reipublice et pacis amator, 20 annorum 

etatis, unicam et unius anni filiam relinquens heredem.


#### 1333.3


Item, feria quinta post octabas Trinitatis, tempore 

parliamenti occiditur apud **Dubliniam** **Murkyht Nicol 

Othothyl**, cum in turma et inter multitudinem ambularet, 

occisore incognito clam fugente, et in turba latitante; et hoc Dei justo 

judicio, qui multos male ipse fideles occiderat ante.


#### 1333.4


Item, comissa sunt multa dira bella inter 

**Anglicos** et **Scotos**; ubi et multa milia **Scotorum** 

sunt occisa, duce **Anglicorum** **Edwardo de 

Bayllol**, qui plus nominis in hiis expedicionibus habuit quam 

facti, qui **Scotiam** sibi jure vendicavit hereditario, 

**David** filio regis **Roberti Brus** 

(qui vivente patre rex **Scotie** coronatur) in **Norwangia** 

fugiente; **Scotis** ad insulas remotas, sed fuge presidio se 

tuentibus.


#### 1333.5


Item, eodem anno, die Sabbati in crastino **Sancti Remigii** episcopi occiditur **Galfridus de 

la Frene** (qui heredem de **Obargi**, **Johannam 

Purcel** duxerat in uxorem), per **O'Morthys** de 

**Slemargys**.


#### 1333.6


Et die Veneris sequenti fit miles **Thomas 

Cantewel**, apud **Yrlef** per **Jacobum le 

Botiller**.


#### 1333.7


Item, circa Epiphaniam, apud **Tyberary** occiditur 

**Willelmus Carraght O'Bren**, de 

**Nathyrlaght**; homo perversus et malus, male vixit, malo fine vitam 

finivit, semper in insidiis, semper in furtis, semper in spoliis et 

homicidiis vivens.


#### 1333.8


Item, pridie Non: Marcii, Dominica quarta, scilicet, xl. 

obiit **frater Adam de Callan**, gardianus de 

**Ros**, vir gratiosus et dilectus, qui xxiiij. annis continue fuit 

gardianus apud **Ros**.


#### 1334.0


1334.


#### 1334.1


In festo **Tibertii** et **Valeriani**, inceperunt 

Burgenses **Kylkennie** pavimentum **Kylkennie** facere, scilicet, 

die Jovis.


#### 1334.2


Item, die Dominico in vigilia **beati 

Marci ewangeliste**, **Thomas Fanyn** 

intravit castrum de **Moytobyr**, et occupavit; ejectis inde hominibus 

domini **Eustachii le Poer** et exclusis. Et pro 

castri defensione, eadem ebdomada occiderunt castri custodes, **Remundum** et **David de Angulo**, et 

**Thomam Roht-Grasse**; et Sabbato sequenti compulsi sunt 

reddere castrum **Jacobo** comiti **Ermonie** tanquam 

domino comitatus, et in manu media, donec discuteretur quis pinguius jus 

haberet.




---

p.26


#### 1334.3


Item, .....[*gap: extent: a few letters*] Kal: Augusti 

**David filius David de Barry**, dominus de 

**Olethan** in **Desmonia**, per **Donatum Carbraht 

Mc Karthey** capitur, interfectis c. de hominibus suis ipso 

die.


#### 1334.4


Item, Sabbato in vigilia **beati 

Augustini**, dominus **Johannes de Sancto 

Albino**, dominus de **Cumcy**, per filios **Walteri 

de Sancto Albino** (in quibus confidebat), in capella propria 

occiditur prodiciose.


#### 1334.5


Item, circa Epiphaniam, **Guydo 

Canteton**, propter multa mala sua opera, que ab pueritia gessit 

inique, rapinas, scilicet, sacrilegia, depredaciones, incendia et homicidia, 

**Dublinie** patibulo patris sui hereditatem invite suscepit; et in 

eodem ligno cum patre suo vitam finivit.


#### 1334.6


Item, in ebdomada ante Purificationem per viii. dies 

fuit nix magna, animalibus multum nociva, sed hominibus plus infesta et 

mala, ut quosdam ex eis (ut ita dicam) incendio occidit; multos mutilavit, 

infinitos graviter et plus solito inflacione pedum, pena et vulneribus 

afflixit; molendina, gurgites et pontes ex glaciei dissolucione confregit et 

destruxit. Hec hominum passio, occisio et mutilacio fuit die Martis, 

scilicet ultimo die Januarii, et maxime propter leporum venacionem.


#### 1335.0


1335.


#### 1335.1


Die Jovis in crastino Invencionis Sancte Crucis, 

occiditur dominus **Remundus le Ercedekne**, cum 

duobus filiis suis **Patricio** et **Silvestro**, dominus **Willelmus le 

Ercedekne** et de illo cognomine xi. per **Leyath 

O'Morthe**, filios et familiam suam in parliamento apud 

**Clar-Goly**; et **Thomas de Bathe**, 

**Geraldus Bagot**, et alii, usque circiter 

quinquaginta. Hic **Remundus** cum duobus primogenitis ejus, 

et domino **Willelmo** avunculo suo, et aliis tribus de 

cognomine eorum, in septem feretris simul et continue per villam 

**Kilkennie**, cum multorum planctu ad locum **Fratrum Minorum** deferuntur 

tumulandi.


#### 1335.2


Item, dominus **Jacobus** comes 

**Ermonie**, et dominus **Mauricius filius 

Thome** comes **Desmonie**, et alii nobiles 

**Hibernie**, duce eorum **Johanne Darcy** tunc 

justiciario **Hibernie**, post assumpcionem **Marie**, **Scotiam** intraverunt cum lvi. navibus; et spoliatis, combustis et subjugatis insulis de **Aron** et **Bote**, ac obsidibus acceptis, indempnes ad **Hiberniam** sunt 

reversi. Pro isto autem passagio, de carucata qualibet pacifica 

**Hibernie**, dabantur duo solidi, a clero decima bonorum suorum, a 

civitatibus et villis magnis, subsidium competens ad regis rogatum; sic ne 

in consequenciam vel consuetudinem duceretur.


#### 1335.3


Item, eodem tempore occiditur dominus **David 

Beket**, per **O'Brynnys**.


#### 1335.4


Item, die Mercurii in octabis **beati 

Francisci**, dominus **Jacobus** comes 

**Ermonie** intravit terras **O'Brynnis** de **Duffyr**, 

spoliavit et combussit, et fecit ibidem **Fulconem de la 

Frene** militem; et dominus **Fulco** fecit dominos 

**Gregorium de la Launde**, et **Matheum 

filium


---

p.27






Oliveri** milites ipso die et loco.


#### 1335.5


Item, die Jovis, in die Animarum, capiuntur per 

**O'Karwillys**, dominus **Ricardus de Mareys**, 

dominus **Robertus Travers**, et dominus 

**Robertus filius David**; occiditur 

**Johannes le Brit** cum aliis.


#### 1335.6


Item, die Jovis, in crastino **Lucie** 

virginis, erecta magna crux in medio fori **Kilkennie**; hoc tempore 

multi ad crucem volantes, crucis signo cum ferro candenti super nudam carnem 

sunt signati, ut in **Terram Sanctam** vadant.


#### 1335.7


Item, die Mercurii in octabis **beati 

Johannis apostoli**, dominus **Mauricius filius 

Thome** comes **Desmonie**, fecit vii. milites juxta 

**Greyn**, in expedicione super **Bren O'Bren**.


#### 1335.8


Item, dominus **Alexander 

Bigenor**, archiepiscopus **Dublinie** incepit diocesim 

**Ossorie** visitare, que a xl. annis ante per nullum metropolitanum 

ordinarie fuerat visitata; scilicet, die Lune in festo **beati 

Vincencii**.


#### 1336.0


1336.


#### 1336.1


Die Jovis, iii. Idus Aprilis, occiditur 

**magister Howelus de Bathe**, archidiaconus **Ossorie** 

(vir literatus et largus), cum **Andrea Avenel**, et 

**Adam de Bathe**, per **O'Bryinys** de 

**Duffyr**, circa defensionem bonorum ecclesie, et parochie sue.


#### 1336.2


Item, tercio die Junii, dominus 

**Jacobus** comes **Ermonie** contulit **Fratribus 

Minoribus** castrum suum et locum de **Carrig**.


#### 1336.3


Item, die Sabbati, in vigilia **beati Johannis Baptiste**, **Brien O'Bryn** combussit villam 

et ecclesiam de **Tyberary**, cum hominibus et mulieribus.


#### 1336.4


Item, die Sabbati in festo apostolorum 

**Petri** et **Pauli**, ingressus fratrum primus in locum de **Carrig**; fratre **Stephano de 

Barry** ministro; fratre **Willelmo Nasse** 

custode, et fratre **Clyn**, primo tunc gardiano.


#### 1336.5


Item, in estate illa fuit guerra inter dominum 

**Fulconem de la Frene**, tenentem et foventem partem 

**Anglicorum** **Ossorie**, et **Leysaght 

O'Morthe**; que ortum habuit ex morte domini 

**Remundi Lercedekne** et suorum; nam idem 

**O'Morthe** omnes **Hibernicos** communiter totius 

**Momonie** et **Lagenie**, suasionibus, promissionibus et 

muneribus alexit ad guerram; solum autem **Scanlan Mc 

Gilpatricke** et **Herry O'Ryan** partem 

tenebant **Anglicorum** et pacis.


#### 1336.6


Item, eadem estate in vigilia **beati 

Jacobi appostoli** occiditur dominus **Mathias 

filius Henrici**, et alii de comitatu **Weysefordie** 

fideles, circiter cc. per **Mc Morcada**, et **O'Brynns**.


#### 1336.7


Item, die Lune in crastino nativitatis 

**Marie**, fuit bellum et duellum assignatum, inter cognatos 

domini **Johannis de Sancto Albino**, et filios 

**Walteri de Sancto Albino**; nam ambe partes domino 

Justiciario manuceperunt ipso die pugnare; sed filii 

**Walteri** finem et exitum prodicionis sue timentes et 

vincdictam, pugnare renuerunt.


#### 1336.8


Item, xiiii, Kal: Decembris, **Walterus 

Oge de Sancto Albino**, per **Johannem 

de Recheford** interficitur, et filios ejus.


#### 1336.9


Item, in vigilia vigilie **beati Andree** 

appostoli, occiduntur **Johannes Cumcy** et 

**Thomas de


---

p.28






Sancto Albino**, per filios **Walteri de Sancto 

Albino**.


#### 1336.10


Item, die Lune in festo **Fabiani** et 

**Sebastiani**, **Jacobus le Botiller** 

apud **Roscre** fecit **Johannem de Recheford** 

et **Galfridum Schorthalis** milites.


#### 1337.0


1337.


#### 1337.1


Dominica de passione, scilicet viij. Idus Aprilis, 

consecratur **Mauricius de Rocheford** episcopus 

**Lymerici**, apud **Lymericum**.


#### 1337.2


Item, die Lune in crastino **beati 

Lawrencii**, miles efficitur **Henricus de 

Valle** per **Pincernam** in expedicione super **O'Brynnis**, apud **Arclo**.


#### 1337.3


Item, die Martis in festo **Kalixti** 

pape, applicuit **Dublinie** dominus **Johannes 

Scharlyngton** justiciarius **Hibernie**, cum germano suo, 

domino **Thoma** **Herefordensi** episcopo, cancellario, 

et **Wallicis** circiter cc. sagittariis.


#### 1337.4


Item, eodem anno, obiit apud **Baligaveran**, 

dominus **Jacobus le Botiller**, primus comes 

**Hermonie**; vir liberalis et amicabilis, facetus et decorus, in flore 

juventutis flos emarcuit xii. Kal: Marcii, die Martis in sero.


#### 1338.1


Item, anno Domini 1338, dominus **Eustachius 

le Poer** in vigilia Assensionis Domini, tunc seneschallus 

**Kilkennie**, attachiavit et incarceravit dominum 

**Fulconem** et **Oliverum de la 

Frene**, nulla eis ostensa causa capcionis; qui timentes potius 

malitiam ejus et vincdictam, quam justitie rigorem; **Oliverus** die Assensionis prudenter de castro evasit, et in crastino congregatis hominibus et amicis eorum, cum manu valida portas castri **Kilkennye** confregerunt et dominum **Fulconem** 

inde, invito senescallo, eduxerunt.


#### 1338.2


Item, eodem anno in festo **Baptiste**
**Edwardus tercius** post conquestum **Anglie**, cum magno exercitu regni sui, et preter illos, cum aliis centum millibus, et 

xli. millibus (ut nuncii referunt), contra ......[*gap: extent: a few letters*] regem 

**Francorum**, **Alemaine** partes intravit.


#### 1338.3


Item, ultimo die Augusti, comes **Desmonie** fecit 

xiiij. milites apud **Rahtymegan**.


#### 1338.4


Item, die Mercurii, scilicet Nonas Octobris, Poterini

 post juramenta et diem captum inter eos, et dominum **Walterum de Valle**, cum esset tunc vicecomes **Tyberarie**, redeundo de comitatu tento apud **Clomele** extra 

villam, eum cum xiii. de sanguine et familia sua occiderunt.


#### 1338.5


Item, die **Sancti Martini** in sero fuit 

ventus validissimus et tempestas horribilis.


#### 1338.6


Item, die Martis, scilicet xv. Kal: Decembris, fuit 

maxima inundancia aque, qualis a xl.ta annis ante non est visa; 

que pontes, molendina et edificia funditus evertit et asportavit; solum 

altare magnum et gradus altaris de tota abbacia **Fratrum Minorum**
**Kilkennie**, aqua non attigit nec cooperuit.


#### 1338.7


Hic annus fuit tempestuosus nimis et nocivus hominibus 

et animalibus; quia a festo Omnium Sanctorum usque Pascha, ut plurimum fuit 

pluvia, nix, aut gelu, a festo **Andree** usque 

**Vincencii** festum cessabant aratra propter nivem et


---

p.29






gelu, que illo tempore quasi continue habundabant. Sal communiter, pro xvi. 

vel xx. solidis vendebatur; propter regum discordiam **Anglie** et 

**Francie**.


#### 1338.8


Hoc anno boves et vacce moriebantur, et oves precipue, 

fere sunt destructe; ita ut juxta communem loquelam, vix septima pars ovium 

a peste evasit, sed agnorum major interitus.


#### 1338.9


Item, in hoc anno in quadragesima, salices in 

**Anglia** rosas protulerunt, que ad diversas terras pro spectaculo 

sunt advecte.


#### 1338.10


Item, circa festum **[gt ]Magdalene**, 

**Anglici** super **Hibernicos** **Desmonie**, scilicet, 

**Mc Karthy**, magnum stratageme fecerunt, et statim post, super 

**O'Dymiscy** fuit facta magna occisio.


#### 1338.11


Item, in principio autumpni, **Mauricius 

filius Thome**, **Desmonie** tunc comes, **Clonmele** 

et **Kylkyban**, a **Willimo de 

Grandissono** *emit*, mille et centum marcis.


#### 1338.12


Item, die Veneris in vigilia vigilie Assumpcionis, 

occiditur per **O'Nolannis** **Laurencius le 

Botiller**, frater comitis **Ermonie**.


#### 1338.13


Item, die Lune in vigilia **beati 

Mathei** apostoli occiditur **Johannes filius 

Johannis de Sancto Albino** (per filium 

**Walteri de Sancto Albino**), et alii sex cum 

eo.


#### 1338.14


Item, anno eodem dominus **Mauricius filius 

Nicholai**, per **Mauricium filium 

Thome** comitem tunc **Desmonie** capitur et incarceratur; 

et infra octabas **beati Francisci**, in carcere, in dieta 

inclusus moritur.


#### 1340.0


1340.


#### 1340.1


In platea **Kilkenie** occiditur 

**Robertus Conton**, die Veneris infra octabas 

Pasche.


#### 1340.2


Item, die Jovis proximo post, occiditur 

**Raynyl, soror Mc Gilpatricke**, per 

**Rechefordis**.


#### 1340.3


Item, Kalendis Maii, passagium omnium navium 

indifferentur conceditur per regem, et concilium suum ville de **Ros**, 

ad instantiam, et laborem, et diligenciam **Radulphi 

Meyleri**.


#### 1340.4


Item, hoc anno in festo **Baptiste**, rex **Anglie** 

cum exercitu suo, classem navium regis **Francie** cepit et destruxit, 

et multa milia hominum in eis inventorum gladio occidit et submersit, et 

regnum **Francie** intravit, debellando, occidendo et comburendo, in 

tantum quod **Anglie** et **Francie** simul regem se vocari fecit 

et scribi in omnibus causis, placitis et literis suis.


#### 1340.5


Item, die Veneris, scilicet iiij.to die 

Augusti, occiduntur per **Mc Morcada** et **O'Nolan**, circiter 

xxiiij. homines de **Balygaveran**. Isto anno sal vendebatur xvi. 

solidis.


#### 1340.6


Item, die Martis in crastino **beate 

Agathe** virginis obiit **frater Rogerus 

Owtlaw**, prior Hospitalis in **Hibernia** apud 

**Any**, tunc locum justiciarii tenens; et etiam cancellarius domini 

Regis, trium simul functus officio. Vir prudens et graciosus, qui multas 

possessiones, ecclesias et redditus ordini suo adquisivit sua industria, et 

regis **Anglie** gratia speciali et licentia.


#### 1342.0


1342.


#### 1342.1


Parum ante Natale Domini obiit 

**Leysart O'Morthe**, a proprio servo in ebrietate 

occisus vir potens, dives et locuples, et in gente sua honoratus.


#### 1342.2


Hic


---

p.30






fere omnes **Anglicos** de terris suis et hereditate violenter ejecit, 

nam uno sero, viii castra **Anglicorum** combussit; et castrum nobile 

de **Dunmaske** domini **Rogeri de Mortuo Mari** 

destruxit, et dominium sibi patrie usurpavit; de servo dominus, de subjecto 

princeps effectus.


#### 1342.3


Item, xvi die Marcii miles efficitur 

**Ricardus filius Remundi le Ercedekne** in 

**Desmonia**, a **Mauricio filio Thome** comitis 

**Desmonie**; et ipse **Ricardus** fecit eodem die tres 

milites; et **Willelmus Grant** illo tempore fecit 

**Johannem le Ercedekne** militem.


#### 1343.0


1343.


#### 1343.1


Fit novum campanile ecclesie **beate 

Marie** **Kilkennie**.


#### 1343.2


Item, in Pentecoste celebratur capitulum generale apud 

**Marciliam**.


#### 1343.3


Item, obiit in festo **Vincencii** 

martiris dominus **rex Robertus, rex **Jerusalem** et 

**Cecilie****, vir celebris et famosus, vir sapiens et sanctus, 

in habitu **Fratrum Minorum** **Neapolim** sepultus.


#### 1343.4


Item, destruuntur et prosternuntur per 

**Hibernicos** **Castrum Viride** in **Ultonia**, et **Castrum 

Kevini** archiepiscopi **Dublinie**.


#### 1344.0


1344.


#### 1344.1


xiij. die Julii applicuit **Dublinie** 

dominus **Radulphus de Ufford**, justiciarius 

**Hibernie**, cum uxore sua **Matilda** comitissa 

**Ultonie**, filia comitis **Lancastrie**; cum pul*ch*ra comitiva 

sagittariorum et aliorum armatorum, et militum, die Martis, 3 Idus Julii. 

Hic terras **Mc Morkada** in **O'Kensely**, et blada 

**Hybernicorum** patrie combussit, et obsides de pace tenenda dare 

compulsit.


#### 1344.2


Item, in eodem anno combusta est villa de 

**Mondesseyl**, et tota patria de **Cumscy** integre, et 

molestores de cognomine **de Sancto Albino** inde sunt expulsi; nec 

domus ibi dimissa in qua possent habitare, per dominum **Fulconem 

de la Frene**, tunc seneschallum **Kilkennie**, imediate 

ante et post nativitatem Domini.


#### 1344.3


Item, in xla, dominus **Radulphus 

Dufford** justiciarius **Hibernie**, **Ultoniam** 

intravit cum manu valida, et passagium de **Ymerdoylan** reparavit, et 

meabile fecit; ejecto **Thoma McArthan** rege patrie, 

interfectis quibusdam de hominibus dire; et **Henricum 

O'Neyl**, regem **Ultonie** deposuit a regno, substituto 

**O'Done** **O'Neyl** pro eo; et sic cum laude et triumpho 

revertitur.


#### 1344.4


Item, in festo Cathedre **Petri**, fuit 

parliamentum factum apud **Callan**, et, quare nescio, ad quod venit 

**Mauricius filius Thome** cum multis millibus 

hominum, ad quod credidit majores terre ad eum venisse; sed rex timens talia 

conventicula suspecta, et potius malum quam bonum ex hoc evenire, per breve 

regis prohibitum est omnibus ne venirent. Et per hoc majores terre predicto 

**Mauricio** se excusabant, sed domi manserunt.


#### 1344.5


Item, filii **Walteri de Sancto 

Albino** utramque villam de **Colaht** combusserunt, et patriam 

spoliaverunt, multos fideles occiderunt, gravia dampna fidelibus patrie 

inferentes.


#### 1344.6


Item, corpus **Joseph** ab 

**Arimathia** **Glosconie** dicitur


---

p.31






hoc anno esse inventum.


#### 1344.7


Item, fit novus rex Insularum, per **Clementem** quintum in Curia 

Romana.


#### 1345.0


1345.


#### 1345.1


Circa Pascha obierunt domini 

**Mauricius Geraldi**, et **Geraldus 

de Rocheford**.


#### 1345.2


Item, **Poerini** combusserunt quasi totam patriam circa 

**Waterfordiam**, destruxerunt et spoliaverunt; et ex hoc quidam eorum 

fuerunt suspensi, tracti, et in quarteria divisi apud **Waterfordiam**.


#### 1345.3


Item, in festo **Baptiste**, **Mauricius** comes tunc **Desmonie** castrum de **Menaht** cum multis milibus obsessit et impugnavit, sed non expugnavit, nec obtinuit; frustratus a 

proposito revertitur.


#### 1345.4


Item, capitulum apud **Clan**, in quo quatuor 

tantum custodie assignantur; et loca **Kilkenie** et **Ros** de 

custodia, **Dublinie** assignantur.


#### 1345.5


Item, obiit dominus **Johannes 

O'Grada**, archiepiscopus **Casselensis**; cui successit 

**frater Radulphus O'Kally**.


#### 1345.6


Item, obiit dominus **Henricus**, comes 

**Lancastrie**; vir venerabilis, potens et bonus.


#### 1345.7


Item, guerra inter **Radulphum de 

Ufford**, justiciarium **Hibernie**, et **Mauricium 

filium Thome**, comitem **Desmonie**; et justiciarius eum 

terris suis, scilicet, **Clomele**, **Kylsylan**, 

**Kysekyl**, **Oconyl**, **Kyrigan** et **Desmonia** 

privavit: bona sua, predia ejus, dominia et possessiones ad opus et manum 

regis confiscando; et majores nacionis et dominii comitis obsides regi de 

fidelitate et subjectione regi servanda et facienda reddere fecit et coegit; 

et multi eorum pacem regis, et cartam pro vita et terris suis habendis magna 

et gravi redempcione comparaverunt et habuerunt.


#### 1345.8


Item, occiduntur per **Mc Dermada**, dominus 

**Robertus de Barry**, et **Philippus 

de Prendergast**, partem regis et justiciarii tenentes, contra 

generum suum; nam, dominus **Robertus** germanam comitis, 

dominus autem **Philippus** filiam germane ejus duxerant in 

uxores.


#### 1345.9


Item, castrum comitis predicti de **Yniskysty**, 

per justiciarium et suos obsessum, die Veneris (in festo 

**Ieronimi doctoris**) est expugnatum et optentum.


#### 1345.10


Item, die Veneris, xii, Kal: Novembris, in festo 

**Hillarionis** abbatis, cum grandi exercitu 

**Lageniensium**, **Momoniensium** et **Connactencium**, 

**Castrum Insule**, (quod vulgi judicio vix erat expugnabile), ipse 

justiciarius ipsum castrum ab ipso et exercitu ante ad quindenam obsessum 

invasit et expugnavit; et tunc primo in hac expedicione et anno, vexillo 

regis erecto, extenso et elevato, **Castrum Insule** invaserunt, 

confregerunt, cum manu valida et fortitudine intruerunt, et inde enim 

**Johannem Coteres**, comitis 

senescallium (qui multas graves, extraneas, et intolerabiles leges dicebatur 

exercuisse, tenuisse et invenisse), die Sabbati in crastino judicialiter 

trahi fecit justiciarius, suspendi, decapitari, interiora ejus comburi et 

membratim dividi, quarteria ejus ob memoriam tyranidis sue ad diversa loca 

provincie


---

p.32






mitti mandavit, ad exemplum aliorum; et dominus **Eustachius 

le Poer**, et **Willelmus le Grant**, 

castrum contra regem et justiciarium tenentes, eodem die de castro educti, 

die Lune proxima sequente in eodem loco tracti et suspensi sunt; et terre 

eorum in manum regis capte et forisfacte sunt.


#### 1345.11


Item, die Sabbati in crastino **Calixti pape** 

occiditur in parliamento a suis consanguineis Tir **Halwaht 

O'Konkur, rex **Conactie****, ex discordia orta inter eos, 

una cum sagitta projecta ad interitum ad comunem populum, eum in genu 

percussit, statim interiit, aliis illesis omnibus permanentibus.


#### 1345.12


Item, in festo Innocencium, **Hibernici** de 

**Slebanie** combusserunt **Bordgwyl**, et **Robertum 

le Gras** et alios **Anglicos** occiderunt; et ipso die 

**Carwill Mc Gilpatricke** patrie princeps, 

occiditur.


#### 1345.13


Item, circa festum Annunciacionis Virginis, dominus 

**Johannes de Weyr**, comes **Oxonie** in 

**Connactia** cum suis de **Britannia** reddiens, tempestate et vi 

ventorum depulsi sunt, dejecti, et inter **Hibernicos** applicuerunt; 

qui spoliaverunt eos bonis suis, equis et armis, graves insultus inferentes, 

et cum eis gravi et impari insultu pugnantes; qui de naufragio seminudi vix 

evaserunt.


#### 1345.14


Eodem tempore dominus **Henricus 

Skrope** in **Desmonia** de **Brytania** veniens, 

tempestate depulsus applicuit; tamen inter fideles, qui nil ei mali 

fecerunt.


#### 1346.1


Item, anno 1346, quinto Idus Aprilis, et Dominica 

Palmarum, obiit apud **Kylmaynam**, dominus **Radulfus 

de Ufford**, justiciarius **Hibernie**, delatus postea ad 

**Angliam** sepeliendus.


#### 1346.2


Item, in vigilia precedenti, obiit in castro 

**Dublinie** dominus **Mauricius filius 

Philippi**, per justiciarium ante captus, et in carcere 

detentus; vir dapsilis et liberalis, licet non multum dives aut 

potens.


#### 1346.3


Item, parum post Pascha, dominus **Johannes 

de Karrev** castrum de **Balymotha** (quod alio nomine de 

**Clerevoyse** dicebatur), renovavit et reparavit, et gardam pro 

custodia loci apposuit.


#### 1346.4


Item, hoc tempore universaliter omnes **Hibernici**
**Lagenie** ad guerram contra **Anglicos** et pacificos se 

posuerunt; comburentes, spoliantes et occidentes quos poterant; non 

parcentes ecclesiis, aut locis sacratis vel sacris, imo ecclesias et 

cimiteria variis in locis spoliaverunt et combusserunt; sicut ecclesiam de 

**Duleke**, et **Fynnowyr**, et **Clodaht**, et 

cetera.


#### 1346.5


Item, occiditur **Dermicius O'Dymiscy**, per **Robertum filium 

Mauricii** militem, feria sexta infra octabas Pasche.


#### 1346.6


Item, in ebdomada post Dominicam in **Albis**, 

castra de **Ley**, **Kylmehyde**, et **Balylethan** capiuntur 

et franguntur per **O'Morthe**, **O'Konkur**, et 

**O'Dymiscy**, die Jovis in crastino Sancte Crucis.


#### 1346.7


Item, die Veneris iii Nonas Maii, **Dermicius 

Mc Gilpatrick** monoculus, qui semper insidiis et prodicionibus 

intendere consuevit, perjuriaque parvi pendens villam de **Athebo** 

combussit, associato


---

p.33






sibi **O'Kayrwyll**, et secum ducto, et in cimiterium et ecclesiam, ac 

**Sancti Cannici** abbatis viri sanctissimi, patroni patrie et 

loci fundatoris, scrinium cum ossamentis et reliquiis ejus igne 

crudelissimo, (tanquam degener filius in patrem) crudeliter deseviens, igne 

crudelissimo combussit et consumpsit. Iste annus sterilis fuit et carus, nam 

cranocus frumenti xii. solidis vendebatur.


#### 1346.8


Item, circa festum **Baptiste** occiduntur de hominibus 

**Ergalie** et **Dundalke** cccc. per **Hibernicos**.


#### 1346.9


Item, illo tempore venit dominus **Walterus 

de Bermegham** justiciarius **Hibernie**.


#### 1346.10


Item, occiditur dominus **Johannes filius 

Georgii de Rupe** per **Ketyngis** et 

**Hodinetis**.


#### 1346.11


Item, baronia et dominium de **Kenlis** que fuit 

domini **Eustachii le Poer** domino 

**Waltero de Bermegham**, et terra domini 

**Willelmi le Grant** domino **Fulconi 

de la Frene** (que regi in eschaetam acciderant) per regem eis 

assignantur.


#### 1346.12


Item, Sabbato in festo **beate Marthe** 

virginis, **Rogerus de la Frene**, tunc vicecomes 

**Kilkennie** cepit magnam predam super **Carwyl Mc 

Gillepatricke**, et super homines ejus, qualem in partibus illis 

raro captam meminit homo a multis annis.


#### 1346.13


**Edwardus rex **Anglie**** post 

conquestum tercius, regnum **Francie** intravit et commissis diris 

preliis et multis multos **Francos** trucidavit, regem **Boemie** 

et regem **Majoricarum** occidit, duces et comites xxv., archiepiscopos 

de **Sannes** et de **Noynn**, et episcopos et abbates multos, 

priorem etiam hospitalis **Franncie**, dominos magnos, barones et 

milites nominatos plus quam ij. milia occidit in bello, xxvi. die Augusti, 

gentes armorum xxv. milia, alios armatos xxx. milia, pedestres absque numero 

interfecit.


#### 1346.14


Item, die Martis in vigilia Sancti 

**Luce** ewangeliste capitur **David le 

Brus** rex **Scotorum**, et comes de **Fyf** atque 

**Willelmus de Douglas**, et occiduntur de 

**Scotis** apud **Dunelmiam** ij. milia per archiepiscopum 

**Eboracensem**, dominum de **Percy**, dominum de **Moubrey** 

et dominum de **Neyvil**.


#### 1346.15


Item, Sabbato in crastino nativitatis **beate 

Marie** occiditur per dominum **Fulconem de 

la Frene** **Thadeus filius Roderici 

O'Carwyl** princeps de **Elycarwyl**, vir potens, locuplex 

et dives et bellicosus precipuus **Anglicorum** et fidelium inimicus et 

persecutor; hic occidit, exulavit et ejecit de terris suis de 

**Elycarwyl** illos de nacione de **Barry**, de 

**Milleborne**, de **Britis** et alios **Anglicos** de 

patria, et terras eorum et castra tenuit et occupavit, omnibus fidelibus 

vicinis gravis tirranus existens. Eodem die per eundem capitur 

**Rury filius O'Morthe**; occiditur 

**Nicholaus le Gras**.


#### 1346.16


Item, in hyeme illa fuit guerra inter 

**Anglicos**, videlicet, **W. Bermegham** 

comitem **Kildarie**, et **O'Morthe** et **O'Dymiscy**, et terras eorum invaserunt et combusserunt, paucos tamen homines 

occiderunt.


#### 1346.17


Item, eodem tempore obiit **Adam 

Northampton**


---

p.34






episcopus **Fernensis**.


#### 1346.18


Item, circa festum **Clementis** 

occiduntur de **O'Dymiscy** xxx. homines per duos, **Thomam 

Wogan** et **Walterum Lenfant** apud 

**Ardscol**.


#### 1346.19


Item, magister **Hugo de 

Saltu**, Dominica de passione in episcopum **Fernensem**
**Dublinie** consecratur.


#### 1347.0


1347.


#### 1347.1


Dominica Palmarum et die Annunciationis **beate 

Marie**, dominus **Nicholaus de 

Verdona** apud **Droukeda** cum magno apparatu et solempni 

funere et multorum procerum conventu honorifice sepelitur.


#### 1347.2


Item, eodem die apud **Kylkenniam** humo domina 

**Isabella Palmer** traditur, que frontem chori 

fratrum erigi fecit, laudabili senio vitam transegit, hac in viduitate 

religiose et honorifice vixit annis circiter lxx., et in virginitate ut 

dicebatur et creditur de hoc seculo migravit.


#### 1347.3


Item, **Mauricius filius Thome** 

comes **Kyldarie** et dominus **Fulco de la 

Frene**, per regem vocati et invitati, **Franciam** intraverunt 

pro obsidione **Calisie**, que duravit a nativitate **beate 

Marie** precedente usque ad festum **Sancti Laurencii** martiris, et tunc post multos insultus et diram 

famem atque incredibilem compulsi sunt **Gallici** claves civitatis et 

seipsos gracie regis **Anglie** submittere.


#### 1347.4


Item, reedificatur villa de **Thagmolingis** per 

**Walterum Bermegham** tunc justiciarium **Hibernie**.


#### 1347.5


Item, capitur **Karolus de Bloys dux **Britannie**** in **Britannia** per dominum 

**Thomam Dagworht** circa festum **Baptiste**.


#### 1347.6


Item, **Fratres Predicatores** **Hibernie** 

impetraverunt relaxacionem et licentiam carnes comedendi ad ext.a, a domino 

**Papa Clemente VI** quam ab exordio sue 

religionis ante non habuerant.


#### 1347.7


Item, in festo vii. Fratrum, obiit **Rogerus 

de la Frene** tunc senescallus **Kilkennie**, juvenis 

validus, prudens et discretus, qui ut putabatur ad magna et ardua 

ascendisset nisi morte prematura preventus fuisset.


#### 1347.8


Item, fit magna discordia, contraversia et sedicio inter 

cives **Bristollie**.


#### 1347.9


Item, incepit confraternitas **Fratrum Minorum**
**Kilkennie** pro campanili novo erigendo et ecclesia reparanda, 

dominica prima adventus Domini.


#### 1347.10


Item, die Veneris in crastino **beati 

Nicholai** obiit **Oliverus de la 

Frene** in officio seneschallie **Kilkennie**, vir probus, 

modestus et prudens.


#### 1347.11


Item, in nataliciis Domini, **Domenaldus 

O'Kenidy filius Philippi**, facta conspiracione 

**Hibernicorum** **Momonie**, **Connactie**, **Midie** 

et **Lagenie**, villam de **Nenaght**, et totam patriam et omnia 

castra **Ermonie** preter castrum de **Nenaght** combussit et 

destruxit; qui feria sexta post festum Annunciacionis **beate 

Marie** per **Purcelles** cum principe sue nacionis 

captus est et incarceratus, et iiij.to Non: Junii judicialiter suspensus est 

et tractus cum filio **Breyn O'Breyn** apud 

**Thurlis** ad caudas equorum, anno scilicet 1348.


#### 1347.12


Item, undecimo die Novembris comitatus **Ermonie** 

et regalitas ejus


---

p.35


**Jacobo le Bottiller** juniori per regem 

conceduntur.


#### 1347.13


Item, **Hugo de Calce** clericus 

Pape et collector et exactor fisci **Dublinie** in festo 

**Patricii** occiditur.


#### 1347.14


Item, **frater Ricardus episcopus 

**Ossoriensis**** in curia Romana optinuit exempcionem a 

jurisdiccione et superioritate archiepiscopi **Dublinie**.


#### 1347.15


Item, **frater Fortenarrus 

Vassali** minister generalis assumitur ad archiepiscopatum 

**Ravenarum**.


#### 1347.16


Item, die Martis scilicet iij. Nonis Junii 

**Dovenaldus Mc Morkada** et **Murcardaht 

Kevanaht** per suos consanguineos in prodicione occiduntur, viri 

bellatores versipelles et pacis ac pacificorum impugnatores graves, ob 

quorum morte venit pax ad tempus, quievit populus pacificus, et cultura 

crevit.


#### 1347.17


Item, fit novus tribunus in Romana civitate 

qui dixit se velle **Romam** et **Ytaliam** et rempublicam 

reparare in melius et resarcire, cujus officii et dignitatis titulus talis 

erat; **Nicholaus** severus et clemens libertatis pacis 

justicie tribunus, sacre Romane reipublice liberator illustris, 

liberator urbis, zelator **Italie**, amator orbis, et 

Augustus.


#### 1348.0


1348.


#### 1348.1


In mense Julii et Augusti, dominus

**Fulco de la Frene** habens curam et custodiam terrarum comitis 

**Ermonie**, ipso comite in **Anglia** commorante, tenuit magnam 

gardam apud **Nenaht**, et reduxit abjectos, revocavit ad propria 

fideles exulatos, muros confractos et diruptos per **Hibernicos** per 

ipsos reparari fecit et coegit, et cum magna multacione et gravi redempcione 

vaccarum et obsidum deliberacione, ad statum primum et subjectionem debitam 

(quod omnibus videbatur fieri non posse) compulit redire.


#### 1348.2


Item, obiit **Laurencius de 

Hastingis comes **Penbrochie****.


#### 1348.3


Item, hoc anno et maxime mense Septembri et Octobri 

convenerunt undique de diversis partibus **Hibernie**, episcopi et 

prelati, viri ecclesiastici et religiosi, magnates et alii, et comuniter 

omnes utriusque sexus ad peregrinacionem et vadacionem aque de 

**Thaht-Molyngis**, turmatim et in multitudine, sic ut multa milia 

hominum simul illuc multis diebus convenire videres, quidam venerunt 

devocionis affectu, alii (sed plures) pestilencie metu, que tunc nimis 

invaluit, que primo juxta **Dubliniam** apud **Howht**
***Dalkey*** et **Drovda** 

incepit, ipsas civitates **Dubliniam** et **Drovhda** fere 

destruxit et vastavit incolis et hominibus. Ita ut in **Dublinia** 

tantum, a principio Augusti usque nativitatem Domini xiiij. milia hominum 

mortui sunt, hec pestilencia ab oriente ut dicebatur incepit, et per 

incredulos et **Saracenos** transiens, de eis octo milia legiones 

hominum interfecit.


#### 1348.4


Item, in provincia, **Avinione** civitate ubi tunc 

Romana viguit et fuit curia, a Januario precedenti incepit, tempore 

**Clementis Pape VI.** ubi et ibi ecclesie et cimiteria 

civitatis non sufficiebant capere mortuorum corpora tumulanda. Et dominus 

ipse papa ordinavit unum cimiterium


---

p.36






novum consecrari, in quo mortui ex clade pestilencie interfecti 

reconderentur. Ita ut a mense Maii usque **Sancti Thome** 

translacionem quinquaginta milia et eo amplius corpora sunt sepulta in eodem 

cimiterio. De ista pestilencia facta est visio mirabilis (ut dicebatur) anno 

precedenti scilicet 1347, in claustro **Cisterciensium** **Tripolis**, sub 

hac forma; quidam monachus celebravit missam coram abbate suo, uno ministro 

presente, et inter ablucionem et communionem misse apparuit quedam manus 

scribens super corporale in quo predictus monachus confecerat. ‘Cedrus alta **Libani** succendetur et ibidem 

**Tripolis** destruetur, et **Acon** capietur, et marchionatus 

mundum superabit, et Saturnus insidiabitur Jovi, et vespertilio fugabit 

ducem ab *mundo universi*. Infra xv. annos erit una fides et 

unus Deus, et altere evanescent, filii **Ierosolomitani** a captivitate 

liberabuntur, gens quedam nascetur sine capite; ve in clero et sterilitate 

navicula **Petri** jactabitur vallidis fluctibus sed evadet et 

dominabitur in fine dierum. In mundo erunt multa prelia et strages magne, et 

fames vallide, hominum mortalitas per loca, regnorum mutaciones, et terra 

**Barbarorum** convertetur, ordines mendicantes certe quam plures 

adversabuntur; bestia orientalis et leo occidentalis universum mundum suo 

subjugabunt imperio; et pax erit in toto orbe terrarum; et copia fructuum 

per xv. annos. Tunc passagium erit commune ab omnibus fidelibus ultra aquas 

congregatas ad **Terram Sanctam**. Et civitas **Jerusalem** glorificabitur; 

et sepulchrum Domini ab omnibus honorabitur; in tanta tranquillitate nova 

audientur de Antechristo. Vigilate.’ Non est auditum a principio seculi tot 

homines pestilencia, fame aut quacunque infirmitate tanto tempore mortuos in 

orbe; nam terre motus, qui per miliaria multa se extendebat, civitates, 

villas et castra subvertebat absorbuit et subversit; pestis ista villas, 

civitates, castra et oppida homine habitatore omnino privavit, ut vix esset 

qui in eis habitaret, ista pestilencia sic erat contagiosa quod tangentes 

mortuos vel inde infirmos incontinenter et inficiebantur et moriebantur, et 

confitens et confessor simul ducerentur ad sepulchrum. Et pre timore et 

horrore, pietatis opera et misericordie, videlicet, visitare infirmos et 

mortuos sepellire, homines excercere vix audebant. Nam multi ex antrace et 

ex apostematibus, et pustulis que creverunt in tibiis et sub asellis 

*axillis*, alii ex passione capitis et quasi in frenesim versi, alii spuendo 

sanguinem moriebantur. Iste annus fuit ultra modum consuetum mirabilis 

insolitus et in multis prodigiosus, fertilis tamen satis et habundans, etsi, 

morbidus et mortalis. In conventu **Minorum** de **Drouda** xxv. et in 

**Dublinia** apud eosdem xxiij. fratres mortui sunt, ante usque 

Natale.


#### 1348.5


Item, die Martis in


---

p.37






crastino Purificacionis, **Connili O'Morthe** patrie 

sue princeps et dominus per germanos ejus in quibus confidebat, cum quibus 

ipso die simul epulabatur confidenter, quorum filios pro fidelitate et 

subjeccione sibi servanda tunc habebat obsides, natorum suorum necem non 

formidantes, et in perjurii crimen incidere non verentes, ambicio dominandi 

fraternum fedus disjunxit et seperavit; et rupto vinculo fraternitatis, 

spreto amore et federe sanguinis, eum prodiciose occiderunt, et quos venter 

et uterus unius mulieris suscepit, tota illa terra et patria recipere non 

valebat; nec aufertur nec etiam differtur inde vindicta, nam octavo die 

**Anglici** de **Ossoria**, qui partem ipsius 

**Conyl** fovebant, patriam intrantes, communi consensu populi 

filius ejus primogenitus **Rury** in principem est electus et 

acceptus, et **Anglicis** **Ossorie** ad sua ut volebant 

revertentibus, **David O'Morthe**, occisi germanus, 

eis obstitit cum quibusdam **Anglicis** comitatus **Kildarie** et 

**Cathirlaht**, in quodam passu arto aliquos equos, qui sarcina et arma 

**Ossoriensium** portabant, abstulerunt, et ibi occisus ipse 

**David**, vir potens, dives et discretus post 

**Conyl** de sanguine parem non habens, et sic vitam perdidit, 

regnum et germanum; alii vero fratres omnes consentientes exulati patriam 

dimittere coguntur.


#### 1348.6


Ista pestilencia apud **Kilkenniam** in xl.a 

invaluit, nam vi.to die Marcii viij **Fratres Predicatores** infra diem 

Natalem obierunt, vix *in* domo unus tantum moriebatur, sed communiter vir 

et uxor cum natis eorum et familia unam viam, scilicet mortis, transierunt.


Ego autem frater **Johannes Clyn** de **Ordine Minorum** et conventu **Kilkennie** hec notabilia facta, que tempore meo 

acciderunt, in hoc libro scripsi, que occulata fide vel fide digno relatu 

didici, et ne gesta notabilia cum tempore perirent et a memoria recederent 

futurorum, videns hec multa mala et mundum totum quasi in maligno positum, 

inter mortuos mortem expectans donec veniat, sicut veraciter audivi et 

examinavi sic in scripturam redegi, et ne scriptura cum scriptore pereat, et 

opus simul cum operario deficiat, dimitto pergamenam pro opere continuando, 

si forte in futuro homo superstes remaneat, an aliquis de genere Ade hanc 

pestilenciam possit evadere et opus continuare inceptum.
#### 1349.0


1349.


#### 1349.1


In magna karistia sere et specierum, nam libra 

sere vendebatur xx.ti denariis, et piperis et zinsiberis xl.ta denariis.


#### 1349.2


Item, in festo **Molingi** episcopi, 

dominus **Fulco de la Frene** confidens in 

promissionibus falaciis **Hibernicorum** interficitur prodiciose, vir 

milicie et militaris a pueritia deditus et intendens, et pacis defeccione 

reipublice defensor, malorum malleus, plurium relatu communi in relacione 

vix in **Hibernia** parem habens; hic **Rupences**, 

**Cantonences** fidelium


---

p.38






oppressores de terra extirpavit, vir magnanimus, minas magnorum et *aggredi* 

non formidans, vir largus et plus nominis quam hominis habens, majoris fame 

quam substancie, profusus erat in dandis epulis, nulli claudens suam jannuam 

*hic vias fidelibus patefecit*, et hominum linguis loquor et communis populi sentenciis vix in 

**Hibernia** relata.


#### 1349.3


*Videtur quod Author hic obiit.*


#### 1349.4


*Prima pestilencia in **Hibernia** multum invaluit 

anno Domini 1349.*


#### 1362.1


*Secunda vero pestilencia similiter invaluit ibidem per xiij. annos postea, viz. anno Domini 1362.*


#### 1373.1


*Tercia etiam pestilencia acc*revit* per xi. annos postea viz. anno Domini 1373.*


#### 1375.0


*Anno Domini 1375.*


#### 1375.1


*In festo **Anne** matris 

virginis **Marie** interfectus fuit **Donatus 

Kevenach Mc Moorke** per **Galfridum de 

Valle** prope **Carlachiam**.*


#### 1382.1


*Quarta autem pestilencia crevit in **Hibernia** per ix. annos post hoc viz. anno Domini 1382.*


#### 1391.1


*Quinta autem pestilencia inolevit consimiliter in partibus ejusdem per ix. annos, similiter post predictos annos, anno viz. Domini 1391.*


#### 1405.0


*Anno Domini 1405.*


#### 1405.1


***Frater Johannes** minister **Hybeirnie** veniendo de capitulo generali captus fuit in mari per **Flandrenses** et solvit pro capcione sua xx.ti. 

marcas, et quinque pro familiis, quo anno fuit lv. annorum, anno viz. *anno* 

Domini 1349 (natus).*


**ANGLIA** habet custodias vij. viz. **Londoniensem**, que 

habet viij. loca, viz. **Londoniam**, **Salisbiriam**, **Cantuariam**, **Wynchilseyam**, **Southamptonam**, **Lewysiam**, **Vintoniam**, et **Chichestriam**.


Item **Oxoniensem**, que habet viijo. loca, scilicet, **Oxoniam**, **Radingiam**, **Behtfordiam**, **Stafordiam**, **Nothyngamiam**, **Northamptonam**, 

**Leycestriam**, et **Gronthamiam**.


Item **Bristollensem**, que habet ix. loca, scilicet, **Bristollum**, **Gloucestriam**, **Herefordiam**, **Carmerdinam**, **Kerdiniam**, **Brugewalterum**, **Exoniam**, **Dorcestriam**, et **Bodminiam**.


Item **Granntebrigiam**, que habet viij. loca, scilicet, **Cantibrigiam**, **Norwicum**, **Sanctum Edmundum**, **Lemiam**, **Gernemutam**, **Gepwycum**, **Colcestriam** et **Dunwycum**.


Item **Wigorniam**, que habet ix. loca, scilicet, **Wigorniam**, **Coventreyam**,


---

p.39


**Lichfeldiam**, **Stafordiam**, **Prestonam**, **Salopidiam**, **Cestriam**, **Lamasiam**, et **Bregenorht**.


Item **Eboracensem**, que habet vij. loca, scilicet, **Eboracum**, **Lyncolniam**, **Beverlacum**, **Duncastriam**, **Sanctum Botulfum**, **Grimisbiam**, et **Scardeburgiam**.


Item **Novi Castri**, que habet ix. loca, scilicet, **Novum Castrum**, **Richemundiam**, **Hertpolliam**, **Carliolum**, **Barwycum**, **Rochysburgiam**, **Hadyngtonam**, **Dunde** et **Dunfres**.


Item duo loca **Sancte Clare**, scilicet **Londonie** et **Bethe** *lviii. loca.*


**IBERNIA** habet custodias, scilicet Dublinencem, que habet 

7 loca, scilicet, **Dubli*ni*am**, **Kildariam**, **Clane**, 

**Totmoy**, **Desertum**, **Weysefordiam** et **Wykynlo**.


Item Pontdris, que habet 6 loca, scilicet, **Pontem**, 

**Trum**, **Dundalke**, **Molynfarnam**, **Dunum**, et 

**Cragfergus**.


Item Casselensem, que habet 6 loca, **Casselum**, **Kylkenniam**, **Rosse**, **Waterfordiam**, **Clounmele**, et **Yohil**.


Item Corkagensem, que habet v. loca, scilicet, **Corkagiam**, **Botoniam**, **Lymericum**, **Thathmelage**, et **Ardart**.


Item Nenaghtensem que habet viij, loca, scilicet **Nenaght**, **Ahtloun**, **Clonronda**, **Clare**, **Galwy**, **Ardmachiam**, **Breffiniam**, et **Kylleyht**. *xxxij. loca*.


Summa omnium domorum 1455, **Sancte Clare** 410, iste est numerus 

provinciarum **ordinis Fratrum Minorum**, custodiarum et locorum, collectis in 

capitulo generali celebrato Anno Domini 1331 (1320) *sic*.
















