

#Annales Breves Hiberniae


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Annales Breves Hiberniae
========================


Author: Thaddeus Dowling
------------------------


### File Description

Richard ButlerElectronic edition compiled by the CELT Team

Funded by University College, Cork and  
Professor Marianne McDonald via the CELT Project 1. First draft, revised and corrected.Extent of text: 28500 words#### Publication


CELT: Corpus of Electronic Texts: a project of University
College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2003) (2008) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: L100012Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript**2. Transcript on paper made for Archbishop James Ussher, TCD Library, Dublin, E. 3. 20.
**Edition**2. Richard Butler (ed.), The Annals of Ireland by Friar John Clyn and Thady Dowling (Dublin 1849).
**The edition used in the digital edition**2. The Annals of Ireland. By Friar John Clyn, of the Convent of Friars Minors, Kilkenny; and Thady Dowling, Chancellor of Leighlin. Together with the Annals of Ross. Richard Butler (ed), First edition [xxxvii + 85 {pp 1-39 the Annals of Clyn; 41-46 the Annals of Ross from TCD MS E. 30. 20, p 396 sqq; 47-70 Notes to the Annals of Clyn; 71-85 
Index of persons and places;} plus xxiv + 66 {pp 1-45 the Annals of Dowling; 46-66 Index of persons and places.}] The Irish Archaeological SocietyDublin (1849)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents pp i–xxiv and 1-45 of the printed edition.


#### Editorial Declaration


##### Correction


Introduction and main annals proofread twice.


##### Normalization


The electronic texts represents the edited text. The editor does not elucidate his editorial policy. The dating is taken from the chronology of the compilers and has not been corrected; however, where there were obvious errors, date values have been added. Some years are not in sequence in the printed edition, and some appear twice. To avoid duplication of div1 elements, stray entries appearing under another year than that to which they belong, have not been given an extra entry. Marginal additions are tagged add place="margin". Text supplied by the editor is tagged sup resp="RB". Where personal, collective and place names are identified in the SGML/XML master file, the regularization is given in the reg attribute of the corresponding on/pn/ps tag.


##### Quotation


Quotations from written sources are rendered qt.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the body of annals; the front matter contains the introduction in an unnumbered div. In the main text, div1 represents the individual annal (i.e. the entries for one year); div2 represents the individual entry in a given annal. Page-breaks are marked. Passages in verse are marked by poem, stanza and line.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names of persons, groups and places are tagged.


#### Canonical References


This text uses the DIV1 element to represent the annal. Refs: EVENT (DIV2)This text uses the DIV1 element to represent the annal. ### Profile Description


Created: By monks and secular scholars, over various centuries.
 Date range: 590–1600.#### Use of language


##### Language: [LA] The text is in Latin.


##### Language: [EN] The introduction is in English; entries and phrases in Elizabethan English appear in the main text.


##### Language: [FR] Some words are in French.


##### Language: [GA] Some words are in Irish, in anglicised spelling.


### Revision History


* (2011-01-21) Beatrix Färber (ed.)

* New wordcount made.
* (2008-10-16) Beatrix Färber (ed.)

* Header updated; keywords added; file validated.
* (2008-07-21) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, 'creation' tags inserted, content of 'langUsage' revised; minor modifications made to header.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T16:16:02+0100) Peter Flynn (ed.)

* Converted to XML
* (2003-12-12) Beatrix Färber (ed.)

* HTML file created.
* (2003-11-10) Beatrix Färber (ed.)

* Header modified; minor modifications to file; personal names tagged (introduction/main text); collective, personal and place names, role names and technical terms identified and tagged (main text), footnotes tagged, editorial corrections incorporated.
* (2003-09-30) Marcos Balé (ed.)

* Content markup applied; queries resolved.
* (2003-06-01) Ruth Murphy (ed.)

* Structural markup of introduction and main text.
* (2003-05-22) Beatrix Färber (ed.)

* Header created.
* (2003-05-09) Emer Purcell (ed.)

* Second proofing of introduction. Basic structural markup applied.
* (2003-04-30) Benjamin Hazard (ed.)

* Scanning and first proofing of introduction.
* (1995-08-30) Audrey Murphy (ed.)

* Main text proofed (2).
* (1995 or earlier) Students at the History Department, UCC (Capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: L100012


### Annales Breves Hiberniae: Author: Thaddeus Dowling


### Introduction


In the fifteenth and sixteenth centuries, the darkest period of Irish society, there were amongst the ecclesiastics of Leighlin some men of inquiring minds and of literary habits. **Nicholas Magwyr**, bishop from 1490 to 1512, was educated in the University of Oxford, and we are told that, 
"when Prebendary of Ullard, he preached and delivered great learninge with no lesse reverence, being in favor with the king and nobilitie of Leinster, who, together with the Deane and Chapter, elected him Bishop of Leighlin.’’

[1](javascript:footNote('L100012/note001.html'))


When advanced to that see he was commended for his hospitality; and the number of cows which he grazed without loss upon the woods and mountains of Knockbrannen[2](javascript:footNote('L100012/note002.html')), Cumnabally, Aghcarew, Ballycarew, and Moilglas, gave proof to his contemporaries how much he was beloved in those districts. This bishop 
had begun many learned works, but could not finish any, ‘saveinge one Cronicle summariely by him collected, and *it* is found in the handes of many in written hand laten.’




---

p.ii


The Life of this learned and popular prelate was written by his chaplain, 
Thomas Brown, and 'his Cronicle' preserved in the Yellow Book of Leighlin, together with further collections made by Thomas Waterfeld, Archdeacon of Leighlin, seems to have formed the groundwork of the Irish collections subsequently made by **Thady Dowling**[3](javascript:footNote('L100012/note003.html')), Treasurer and Chancellor of 
that diocese.


That the following pages contain those collections in the state in which they were left by **Dowling** it would be rash to affirm. In such collections 
every transcriber thinks himself justified in adding new matter, and in 
omitting what he esteems the mistaken entries of the original compiler. In 
successive transcripts marginal observations are apt to steal into the text, 
and from the way in which **Dowling** is hereafter mentioned it would seem that he is rather the chief authority than the sole compiler of these Annals. We must, however, observe, that in the manuscript they are ascribed to **Dowling**, and that we have found no quotation attributed to **Dowling** by Hanmer or Ussher, which is not to be found in these pages.


It is evident that the compiler of these Annals had access to no 
contemptible library of printed books. Giraldus Cambrensis, Powell's 
Caradoc of Llancarvan, and probably that learned Welshman's other works on British History, **Lanquet**'s Chronicle, continued by Bishop Cooper, Sir J. Eliot, 
**Stowe**, and Holinshed, form a library, for which many a modern clerical 
student of Irish history would envy Queen Elizabeth's Chancellor of 
Leighlin. Yet in **Dowling**'s days the old cathedral town of St. Lazerian, looking from its sheltered glen and bright stream, across the rich plain of 
the Barrow, to the blue and undulating outline of Mount Leinster, beautiful 
as it ever must have been to the eye of the painter, was a place ill-fitted 
for quiet study


---

p.iii




and learned research. The neighbouring monastery of the Carmelites at the 
bridge had been converted into a royal garrison, and the goodly Barrow, as 
it flowed under its walls, reflected, not cowls and friars' frocks, but 
matchlocks and iron skull-caps.


In this transmuted monastery, in the beginning of the reign of Edward VI., 
Sir Edward Bellingham, Lord Deputy, kept a stall of twenty or thirty horse; 
and it was from this house that he rode into Munster, to the house of the 
Earl of Desmond, when, being unlooked for and unthought of, he found the 
Earl sitting at his Christmas fire, and took him, and carried him away with 
him to Dublin. Some years later, and in the time of **Dowling**, Leighlin was 
the residence of one of these bold and accomplished soldiers, at once 
worldly and romantic, who gave strength and glory to
the throne of Queen Elizabeth. Here came Sir Peter Carew, who having been in his youth, as recorded by his faithful steward, at Constantinople in the 
Turk's court, at Vienna in the Emperor's palace, at Venice, and in the 
French king's court, and in the houses of most of all Christian princes, in 
every of which places he left some token of his value, settled down at 
Leighlin in his ripe manhood, determined to preserve by policy and the 
strong hand the great Irish inheritance which he claimed by descent, and had 
obtained by law. Here he kept continually, and here, as we shall find, he 
needed to keep, in his own private family, 100 persons, and had always in 
readiness 100 horsemen, well appointed, besides footmen, and 100 **kerns**; here 
his cellar door was never shut, and his buttery always open to all comers of 
any credit. Those days, however, of
military strength and of proud hospitality, worthy of Branksome Hall, soon 
passed away; and when that worthy knight, old Sir Peter, died at Ross, his 
cousin and heir


---

p.iv




young Sir Peter, was unable to defend his inheritance. In 1580, as we learn 
from **Dowling**, there was a great slaughter committed by the **Ketings** at 
Leighlin, and at **Glynmalowra**, in the county of Wicklow, by the Byrnes, where 
young Sir Peter, Baron of Odrone, and Francis Cosby, Esq., captain of the 
loyal **kerns** of Leix, and Master Moore, and Bernard Fitzwilliam, captains, 
were killed, with many other gentlemen of estimation, by Fiagh Mac Hugh 
*O'Byrne*, and other rebels, who afterwards, at the instigation of young 
Maurice Cavanagh of Garrowchill, burned ten townlands in **Idrone**, and carried off as prisoners Master Wood, who was probably one of the Chapter, and Roger Hooker, Dean of Leighlin.


The Chancellor relates the captivity of the Dean of Leighlin with great 
composure, indicating, perhaps, that **Thady Dowling**, with his two Irish names, had no great sympathy with this
English-born Roger Hooker. Yet, if Roger Hooker, as seems likely, was the brother of the writer, John Hooker, alias Vowell, and 
promoted by the interest of the bookish Carew, he was probably no unworthy head of the Chapter of Leighlin, and no unfit associate in **Dowling**'s historical inquiries. If the Dean had his brother's learning it is to be hoped that he did not make as vain a display of it as was made by that worthy English gentleman, who, when member 
for Athenry, in Connaught, in a speech reported by himself, assured the 
Irish House of Commons that the Lord Deputy, Sir Henry Sidney, was treated 
by them as ungratefully as Moses had been treated, and Camillus, and Scipio, 
as Socrates, Themistocles, Miltiades, and others, and proved the same by 
various histories. Such learning we can well spare, but it is to be lamented 
that the Dean has not left any record of his captivity. It would be 
interesting to read how the English Protestant churchman, the friend of the Carews and the brother of their law-agent, was treated, in the fastnesses of Glenmalure, by this Fiagh Mac Hugh, in his house of Balinecorr, who, from being a base varlet,


---

p.v




dared, in Spenser's time, "to front princes, and to make tearms with great potentates.’’




The successor of scholars, such as were the scholars of the time, and, as 
we suppose, the companion of scholars, **Dowling** spent a long life in the discharge of his ecclesiastical functions, and in the study of the 
literature and history of his country. There is something pleasing in the 
picture of such a life in such times, and we like to think of the old man, 
in the midst of an unquiet generation, as a relaxation from grave and 
important duties, now examining the new and costly volumes in the library of 
the learned English knight, and now poring over the manuscript records of 
his cathedral, or striving to find some traces of romantic history in the 
names of the neighbouring townlands, or searching for tombstones in the 
choir, and calling upon the clerk and the carpenter to bear witness that 
they had seen with their eyes the tomb which he had sought for. And, if the 
good Chancellor mistook the import of the epitaph which he read in simple 
verse, and, as has been suggested, confounded Burchard with Borard, and the 
Norwegian pirate with the Norman knight, — and, be it remembered, the mistake may not be on the part of **Dowling**, but on that of his would-be corrector, — still graver mistakes have been made by more learned men, who have not, like honest **Dowling**, preserved the document by which the truth could be ascertained.


As the **O'Dowlings** were one of the six septs of Leix, it is probable that 
our Chancellor was of Irish blood; the Statute against the promotion of 
Irish churchmen remaining, like many better Statutes, a dead letter on the 
Rolls of Parliament. We know from Ware that he was an Irish scholar, and the compiler of an Irish grammar; and in these


---

p.vi




brief Annals he does not omit to mention that the art of printing and of 
founding the letters and characters of the Irish language was introduced 
into Dublin, in the year 1571, by John Kearna, Treasurer of St. Patrick's, and Nicholas Walsh, Bishop of Ossory. That an Irishman by birth and by blood should understand Irish in the sixteenth century provokes no observation; as 
in the beginning of that century the Irish language was generally understood 
among the Anglo-Irish nobles and churchmen.


In the catalogue of the Earl of Kildare's library, taken in 1518, there 
are nearly as many books in Irish as in English; and in 1541 the Irish lords 
of English blood, Barry, Roch, Fitzmaurice, and Birmingham, seem to have 
understood Irish alone; at least Sentleger[4](javascript:footNote('L100012/note004.html')) writes to Henry VIII. that Sir Thomas Cusake's right solemn proposition in giving such laud and praise 
to His Majesty, as justly and most worthily His Majesty had merited, as well 
for the extirpation of the usurped power of the Bishop of Rome out of this 
realm, as also for his innumerable benefits showed to his realms and 
subjects, was briefly and prudently declared in the Irish tongue to the said 
lords by the mouth of the Earl of Ormonde, greatly to their 
contentation.’’




The policy of the English government, the great influx of English 
settlers in the seventeenth century, and the irresistible flow of 
circumstances, have made us an English-speaking population; but at no time, 
from the days of **Dowling** to the present days, have there been wanting, wise and kind-hearted men, who, however they may have rejoiced that the English language, rich with the richest trophies of genius and of thought, was 
their's by inheritance, were anxious, not to supplant English or to extend 
the use of Irish, but to perpetuate the knowledge of the older
and the more venerable language, and to procure,


---

p.vii




through its use, a readier access to the Irish heart and understanding.


It must be confessed, however, that in the following pages we derive but 
little profit from **Dowling**'s Irish scholarship. It is true that he makes mention of the Hibernie Scriptores of the Life of St. Patrick, and of the Hibernie Antiquarii, as well as of the Historici Hibernie, but he cites no Irish manuscript or Irish author by name; and his ancient Irish history is made up of the traditions common to Giraldus Cambrensis, to 
Fordun, and the Four Masters, and left unsifted by them all, mingled with 
extracts from Saxo Grammaticus, and from Powell's edition of Caradoc of 
Llancarvan. Yet, notwithstanding this absence of Irish historical authority 
from **Dowling**'s collections, historical compilations appear to have been at all times amongst the favourite productions of Irish literature. In the catalogue of the Earl of Kildare's Irish Library before referred to, which 
is given in the note[5](javascript:footNote('L100012/note005.html')), there occur names of works evidently historical; and the Four Masters, who, although later compilers, were living in **Dowling**'s old age, made use of nine sets of Irish chronicles, of which six were not 
completed before the commencement of the sixteenth century.


The publication of that great compilation of Irish annals in O'Donovan's splendid edition, rendered doubly valuable as it has been by his 
topographical notes, has made us indifferent to **Dowling**'s neglect of Irish authorities, and has given to the student of Irish history


---

p.viii




ready access to all the knowledge which can be expected from such 
compilations. However honestly drawn up, whether made by the Chancellor of 
Leighlin or by the Friars of Donegal, such compilations in no wise supersede 
the necessity of consulting the original authorities. They must
always bear marks of the character and circumstances, not only of the author 
but also of the compiler, and it is possible that the unconscious 
substitution of one word for another supposed to be equivalent to it, may 
have destroyed the only clue left by the original writer for unravelling the 
system, political, legal, or ecclesiastical, of his times.


Nor have combinations of chronicles, however accurately and fully 
expressed, the interest which belongs to the work of one mind. It would be 
vain to expect in any collection of monkish chronicles the philosophy which 
could fuse and mould their discordant materials into one consistent whole; 
their very copiousness becomes a cause of obscurity, as the attention is 
worn out by the profusion of small events, apparently springing from no 
motive, and certainly leading to no result. As a national history such 
collections of annals must be confused and disheartening, but as materials 
for local history they are invaluable; and if ever freely and boldly used 
for that purpose, they will be found to suggest many thoughts relative to 
the social condition of the country; and being thus resolved into their 
original elements, — for it was as local histories that their chief 
materials were originally composed, — they will cluster in form and 
clearness round various points of great interest. Such is the meagreness of 
our historical records that it is only by the judicious use of these still 
and formal compilations, and of the wild legends of Irish hagiology, that we 
call hope to gain any knowledge of the form and pressure of the ante-Norman 
period of Irish history, to arrange it into its several eras, to ascertain 
the habits and manners of those who lived in them, and to comprehend their 
motives, their objects, and their characters,


---

p.ix




and thus to form some vague notion how their past has influenced our 
present.


The troubles occasioned by the **O'Mores** in Leix, and by the **Cavanaghs** in Carlow and Wexford, form the staple of **Dowling**'s peculiar contributions to Irish history. These troubles, as we learn from the following pages, like almost all other Irish troubles, did not spring originally from political causes, but were directly connected with quarrels about the 
possession of land.


The Norman conquest of England, which preceded the conquest of Ireland by 
little more than a hundred years, had effected as great a revolution in 
landed property in England, as was designed in Ireland; but the Saxon 
occupier soon learned to submit to his Norman landlord: the rights of 
property, however acquired, in England were universally assented to, and 
order and security arose from invasion and spoliation, It was not so in 
Ireland. Some of the causes of this great difference it is not difficult to 
discover. In England the grantees of the Crown — however 
enormous were some of the Conqueror's grants — formed a numerous and 
powerful body of feudal lords, all equally interested in the common title of 
all to their several estates. The presence of the central government, always 
interested in the maintenance of order, tended at once to repress the 
provoking insolence and tyranny of the landlord, and the insubordination of 
the peasant; and where order was observed, and property secure, the industry 
of the tenant and the tradesman, before they were hardened into a middle 
class, repellent alike of lord and of peasant, penetrated the lower poor 
with feelings of hope and of attachment to the existing state of 
society.


In Ireland, on the contrary, the grantees of the Crown were comparatively 
few; from the first the head lords of lands were scattered at wide intervals 
through the country. In the course of one or two generations several of 
their great inheritances descended upon English


---

p.x




nobles resident in England, and leaving their Irish estates to the care of 
Irish undertakers, who seized the first opportunity from agents to become 
proprietors. The power of the Deputy was unable to repress the outrages of 
the landlord or the discontent of the tenant; and where all things were in 
confusion there could be no accumulations of thrift or industry to give hope 
to peaceful ambition, and to make the poor man friendly to the authority of 
the law.


To all these causes of the security of the Norman possessors of Saxon 
estates, and of the constant resistance with which the grandsons of these 
Normans and their descendants were harassed when they relied upon royal 
charters for the grant of Irish lands, must be added, above all, the
different systems of landed tenure which had previously existed in both 
countries.


Whatever may have been the privileges of the Saxon churl, the occupier of 
land, he was still a tenant, holding, on certain conditions, under an 
hereditary, an official, or an elective superior, and liable, on the failure 
of such conditions, to forfeit possession. To the immediate cultivator of 
the soil the distinction of Bocland and Folcland must have been indifferent. 
Whatever theory may be devised to account for the origin of rent in 
countries otherwise circumstanced, and whatever may have been the system of 
landed property originally prevalent amongst the Teutonic nations, it is 
plain that in Saxon Britain, a conquered country, in which the natives were 
not extirpated, there must have been a gradual progress with the increase of 
civilization from the absolute slavery of the indigenous race, from their 
being hewers of wood and drawers of water, through serfdom and villeinage, 
to the commutation of arbitrary into fixed services, ultimately resulting in 
the payment of rent either in money or in kind. And this change must have 
brought about the abolition of national distinctions between the native 
thrall, now raised to the rank of a farmer, and the family of the smaller 
Saxon proprietor,


---

p.xi




who gained their livelihood by the profitable occupation of land.


Whether at the time of the Norman conquest this last result had, or had 
not, been universally arrived at in England in all cases, it is plain that 
by the substitution of a Norman lord for a Saxon thane, the status of the 
Saxon occupier was not essentially changed; the conditions of his tenure may 
have become more burdensome, but he still remained a tenant as he was 
before; and however strong may have been his Saxon indignation at the Norman 
superiority, there was little in it to affect his personal interest, or 
materially to deteriorate his actual condition.


In the greater part of Ireland, on the contrary, although the Saxon or 
Danish[6](javascript:footNote('L100012/note006.html')) system seems to have been introduced into Fingal and into other parts 
of the east coast, previous to the time of Strongbow, there were neither 
landlords nor tenants. Every seignory or chiefry, with the portion of land 
that passed with it, went without partition to the **tanist**, who always came 
in by election, or the strong hand, and not by descent; but by the law of 
**gavelkind**[7](javascript:footNote('L100012/note007.html')) all the inferior tenancies were partible, not, as in Kent, only 
amongst the first heirs male of the last possessor, but at the will of the 
head of the sept, amongst all the males of the sept, whether legitimate or 
illegitimate.


Such was the Irish custom of gavelkind, as explained by the sagacious and 
inquiring Sir John Davies; and although in the third year of James I. it was 
declared and resolved by all the Judges that this custom was void in law, 
not only for the inconvenience and this unreasonableness of it, but because it was a mere personal custom, and could not alter the descent of inheritance; yet so deeply rooted in Irish prejudices was the love of common holdings, with minute and changeable


---

p.xii




subdivisions, that they survived to perplex Sir Henry Piers in Westmeath in 
1697, and Lord George Hill in Donegal in 1846. Perplexing, however, as it 
may have been to landlords, barbarous as it was in the eyes of English 
lawyers, and however opposed to the general improvement of the country, this 
Irish custom of gavelkind not only opened to every man a possibility of 
becoming tanist, or heir apparent, at the death of the chief, but it had 
also the far wider-spreading effect of giving to every man a positive 
interest in the preservation of the family estate, and, when that estate was 
lost, of exciting every man to exert himself for its recovery.


Nor was it clear to the Irish understanding that the lands of the sept 
could ever legally be lost. By Irish law every occupier was but an occupier 
for life, and could alienate or forfeit only his own life-interest. As in 
the somewhat analogous case of the Kentish gavelkind, the father's felony 
could not forfeit the son's right to the lands: in the old adage, though the 
father might be hanged 'on the bough', the son had still a right to 
return 'to the plough'.


With such strong and generally diffused motives for striving to recover 
the landed property of the several septs, it is not surprising that the 
Irish should have availed themselves of the diminution of the small number 
of the original grantees, by absenteeism, by foreign wars, and by 
the wars of the Roses, to re-enter upon lands which had been wrested from 
their own sept, or from some other sept which had 


---

p.xiii




not courage or opportunity to resume their rights. And as such attempts were 
contrary to English law, and inconsistent with English authority, the claims 
of private property excited public disturbance, and what might have been a 
lawsuit became a rebellion.


In the division made at Woodstock, by Henry III., of the great seignory 
of Leinster, between the five sisters of the five childless Earls Marshal, 
the country of Leix, with its chief castle of Dunamase, was assigned to the 
third sister, Eva, wife of De Braosa, Lord of Brecknock; and
her daughter, Matilda, brought the manor to her husband, Roger Mortimer. The 
territory of Leix, previous to the English conquest, had been the patrimony 
of the O'Mores; and after the Scottish invasion, when the power of the 
English was everywhere shaken, the absentee Mortimer[8](javascript:footNote('L100012/note008.html')) esteemed
it a good device for the management of his lands to employ the services of 
one of that supplanted sept, and thought him not dishonoured by the 
service.’’

 It was a common, but a perilous expedient, and the temptation 
proved too strong for the fidelity of Lysaght O'More. Towards the end of the 
reign of Edward II., and probably at the time when Mortimer was proclaimed a 
traitor by his injured sovereign, the hour came for gratifying his inherent 
desire of independence, perhaps his rankling longings for revenge. In one 
night Lysaght O'More burned ten English castles, and destroyed Dunamase, the 
head of Mortimer's barony; and on that night, to use the words of Clyn, from a serf he become a lord, from a subject a prince: De servo dominus, de subjecto princeps effectus.’’




After the death of Lysaght, who was murdered, when drunk, by his servant, 
the manor of Dunamase was recovered from the O'Mores, and in the reign of 
Edward III., during the forfeiture of the Mortimers, was in the hands of Sir 
John Wellesley; but although some


---

p.xiv




of the O'Mores were forced to acknowledge that they held their lands in 
Leix, which then formed part of the county of Kildare, from Mortimer, as of 
his manor of Dunamase, yet the greater part of the De Braos portion of 
Strongbow's palatinate was lost to the Mortimers. Nor was Leix the only 
territory in Leinster, the inheritance of Eva Mac Morogh, of which the 
princely Mortimers were deprived by native claimants. Through the De Burghs 
and the Earls of Gloster they had hereditary claims to the territory of 
Ossory, and when the youthful Earl of March, grandson of Lionel, Duke of 
Clarence, and presumptive heir of the crown of England, was appointed Lord 
Lieutenant by his friend and cousin, Richard II., the viceregal sword added 
but little to his dignity in Ireland, where he was by descent Earl of 
Ulster, Lord of Meath, of Connaught, of Leix, and of Ossory, claiming in all 
these vast franchises the authority of a Lord Palatine, absorbing the royal 
revenues, and exercising royal power. But all these titles, and all this 
power, hereditary and deputed, were vain when employed to recover estates 
once fallen into the hands of Irishmen. In his attempt to rescue lands 
belonging to his mother, which his father had been obliged to reconquer, the 
'courteous' Earl of March was resisted by O'Nowlan, O'Byrne, Mac David 
More *Mac Morogh*, Mortagh Mac Laghlin, and others; a battle was fought at 
Calleston, now Kellistown, in O'Nowlan's country, where Raymond le Gros had 
a castle in the time of Henry II.; the Earl was slain, and his mother, as we 
learn from **Dowling**, gave two chalices, one to Myshall and one to Garrowcheill, to ransom his body, which was sent to England, and interred 
with his forefathers in the Abbey of Wigmore.


In this obscure skirmish, fought in a place whose name has hitherto been 
mistaken and its site unknown, were involved the


---

p.xv




destinies of the British empire; for it was to revenge the death of his 
cousin and presumptive heir that King Richard came a second time into 
Ireland, and so left the field open to Bolingbroke, to whose towering 
ambition the superior claims of Mortimer's orphan children offered only a 
feeble obstacle; and hence the disputed succession, the thinning of the old 
nobles of England, the rise of the landed gentry, and all the thousand 
ever-spreading consequences of the wars of York and Lancaster.


Nor were the long and dangerous insurrections of the MacMoroghs and the 
Cavanaghs less directly connected with disputes about land, than those of 
the O'Nowlans and O'Mores. Connected with King Dermod, if not descended from 
him, and consequently allied in blood to all the noble posterity of 
Strongbow and the Countess Eva, and possessing the distinguished privilege 
of being one of the quinque sanguinum, the Mac Moroghs seem from the 
first to have held undisturbed possession of the hill country on the borders 
of Carlow and Wexford. As the power of the English settlers decreased, the 
native sept gradually spread over the low lands, and acquired extensive 
possessions in both those counties. In 1327, ten years after Bruce's 
invasion, at an assembly of the Irish at Leinster, the power of the sept, 
and certain traditional recollections, secured Donald Mac Murgh's election to the title of King of Leinster, as Pembridge says somewhat scornfully: 
Hibernici de Lagenia collegerunt se simul, et fecerunt 
quemdam Regem, videlicet Donaldum filium Arte Mac Murgh.’’

[9](javascript:footNote('L100012/note009.html'))


The vain boasts of the new king that he would plant his standard within 
two miles of Dublin, and then, after the fashion of the old Irish kings, go 
through all Ireland, were dissipated: he was taken prisoner by Sir Henry 
Traharne, and confined in the castle of Dublin, until, at the end of three 
years, he made his escape, with the help


---

p.xvi




of a rope, bought for him by Adam Nangle, for which, and perhaps with which, Adam Nangle was hanged.


Notwithstanding, Donald Mac Murgh's misfortunes, the captainship of the sept, with the title of king, long continued in this family.


In King Richard's[10](javascript:footNote('L100012/note010.html')) first expedition, on the 16th day of February, 1395, 
Arte Mac Morogh, who was called king, although he had small territories anywhere,’’

 came riding on a black horse to the field of Baligory, near 
Carlow, and having heard the King's letters read, and explained in English, 
by John Molton, clerk, of the diocese of Lincoln, and read in Irish by Friar Edmund Vale, Master of the Hospital of St. John of Jerusalem in Ireland, with Gerald O'Bryn, Donald O'Nolan, Loy Oge, and Shane Mac Mauriceboy of Slewmergy, and Murogh O'Connohur of Offaly, all captains of their respective septs, Arte Mac Morogh, having taken off his girdle, sword, and cap, joining together the palms of his hands, and holding them upright within the hands 
of the Earl of Nottingham, who had then a special commission from the King, did homage and swore allegiance, and bound himself, on the restitution of his wife's barony of the Norragh, and on the annual payment of eighty marks as wages, to enter into the King's service, and to surrender all his lands in Leinster, for which he was to receive compensation by the grant of such lands as he might conquer elsewhere from the enemies of his lord the King.


By this promised removal from Leinster of Mac Morogh and the other Irish captains, the English of Leinster would have been relieved from troublesome neighbours; but the native grasp of hereditary lands is not easily relaxed; and although they now bent before the royal power of England, the Leinster septs were rather disposed to intrude upon the old settled possessions of the English than to relinquish the lands of their ancestors. It was at that very time that the Cavanaghs


---

p.xvii




were supplanting the Carews in Idrone. The barony of the Norragh, the estate 
of his wife, the heiress of the Calfes or De Veels, gave Mac Morogh a 
footing in Kildare; its non-restitution afforded him grounds for the 
continuance of hostilities, and he solemnly assured his wife,’’

 wrote 
the Irish Council in 1399, that he will never be at peace until he has 
restitution of her lands.’’


Scarcely then were the two hampers, filled with Irish surrenders and 
indentures, delivered to the Court of Exchequer in England by the Bishop of 
Salisbury, before disturbances again broke out; and although the Norragh[11](javascript:footNote('L100012/note011.html')) was 
restored to his wife, and the eighty marks annually paid to MacMorogh and to 
many successive Mac Moroghs, yet the lands of the sept in Leinster were 
never relinquished, nor was the title of King of Leinster given up for many 
generations. Even as late as 1522 we have in these Annals the death of 
Gerald Kevanagh Mac Murchad, qui se fecit vocari Regem 
Lagenie et Ducem Laginensium;’’

 and this titular king was buried 
with the king's lieges at Leighlin.
But although, like the other sixty chief captains[12](javascript:footNote('L100012/note012.html')) calling themselves 
kings, or kings' peers or princes, or dukes, or archdukes, living only by 
the sword, and making war and peace for themselves, the Mac Moroghs 
exercised imperial jurisdiction within their narrow boundaries, these
Annals show the insecurity of their power and the troubles of their lives. 
While, however, the captains, by whatever title they were called, were 
occasionally defeated and compelled to submit, or were imprisoned in Dublin 
or in London, or were hanged, the main body of the sept continued
to occupy their hereditary and acquired lands, acknowledging no lord but 
their own elected captain, and no law but that pronounced by their Brehons 
on the hill side.




---

p.xviii


The power of the government of Henry VIII., and the activity of 
Sentleger, brought about a change. The words of the intelligent Lord Deputy, 
in announcing his success to the king, are worthy of notice, as they show 
that the points now insisted on had not escaped his observation:


Perceiving that thos sectes of people called the Cavenaghes, as Mac 
Morogh, and other hys complicis, wer not, as then, in pece with Your 
Magestie, nor yet, at that tyme, had any pledges for securite of the same, 
yt was thought good by me, and other of the Counsell, to make a journay
apon them, whiche we dyd the Monday next after myne arryvall. And 
contynueing teen daies in their countrey, burnyng and destroying the same, 
the said Mac Morogh, with the moste parte of his nation and sect, cam and 
submytted theymself to Your Heighnes obedience, clerely renunsing the name 
of Mac Morogh, and never more, after that day, to elect, nor choise emonge 
them none to bere the same name, ne yet to be their governor, but only Your 
Magestie, and suche as ye shall appoynte to the same; and have promysed to 
take their landes of Your Magestie, to holde the same by knight service, and 
not only to serve you from hensforthe truly according to ther dueties, but 
also to persecute all other of their nation that will disobey the same. And 
athoughe the nature of the Irishemen be very fikill and inconstant, yet it 
is thought here, by Your Magesties Counsell, that thes men whiche thus 
liberally have submytted, renunsing the same name, whiche they wolde never 
do bifor this tyme, will contynue in their sayde goode purpose, seeing we 
handled theyme after their saide submission very gentilly, *not taking from theym any parte of their landes nor goodes*, but only of suche as wolde not condescende to the same reasonable submission; whiche parte so taken we agayne gave on of theymselves, which we sawe moost conformable to the saide honest submission, savely to kepe to Your Magesties use, alleging 
*that yt was neyther their landes nor goodes,* that


---

p.xix




your Majesty so moche estemed, as their due obedience to the same, which at 
lengthe they shuld well perceyve shulde redounde moste to their owne 
profyte.’’

[13](javascript:footNote('L100012/note013.html'))
The increasing tranquillity of the country, and the reviving strength of 
the English Government in the subsequent reigns, involved the Cavanaghs in 
new troubles. Where the English government was acknowledged there the 
English laws were to be exercised, and the legal rights of English subjects 
were to be maintained. When, therefore, Sir Peter Carew[14](javascript:footNote('L100012/note014.html')) of the county of 
Devon, knight, bethought himselfe’’

 upon such lands as his ancestors 
formerly had in Ireland, he laid claim, among other possessions, to the 
barony of Idrone, from which, after the death of Sir Leonard Carew in 1369, 
his ancestor, Sir Thomas, as he alleged, had been driven by M'Murchad, and 
which was then, and had been for 200 years, in the hands of the Cavanaghs. 
The legal evidence of Sir Peter's right both to the lordship of Maston, in 
Meath, and to this barony of Idrone, was sufficient to satisfy Weston, then 
Lord Chancellor, and he entered into possession. In the strange medley of 
**Dowling**'s words, he made the Cavenages compound with him for Odrone, the which he quietly enjoyed, savinge that Maurice Oge Kavenagh of Garrowcheill per fas et nephas tenuit suas terras, vulgariter 
vocatas fyv mart landes absque titulo vel interesse.’’
Even the temporary quietness of Carew's possession may well be doubted. 
He had come from England to awaken obsolete claims, by a precedent capable 
of wide application, and shaking the titles to their lands of all those now 
loyal Irish captains, who, as tenants, managers, or enemies, had re-entered 
on the territories granted by the parchment charters of King Henry II. or 
King John, but which had been re-occupied by the Irish in the fifteenth and 
sixteenth centuries.


---

p.xx




Such claims, however valid according to the principles of English law, 
naturally provoked resistance, even when supported by Sir Peter's 100 **kerns**, 
and by his wise and statesmanlike conduct; and in 1569, the year after he 
had received what **Dowling** calls quiet possession, the
Leinstermen broke out in all sorts of enormities, and men talked of Peter 
Carew's wars, and the Cavanaghs, in **Dowling**'s expressive language, which it 
is needless to translate, were ‘Diaboli contra Petrum 
Carew.’


Such was the origin, and such was the nature, of the wars which disturbed 
the neighbourhood of Leighlin in the days of Chancellor **Dowling**. As some compensation for these troubles, it is to be supposed that he enjoyed the luxury of consulting, in Sir Peter Carew's library, the books of modern date 
to which he often refers. He does not, however, appear to have derived any advantage from the collection of Anglo-Irish documents, once in the possession of Sir George Carew, which now enriches the library at Lambeth.


To some documents, which have since been lost, **Dowling** had ready access. He mentions the Registry, the Records, and the Yellow Book of Leighlin, all of which have disappeared; and we cannot but lament that of these diocesan and capitular muniments he did not make freer use. It is chiefly, if not solely, from incidental notices in such records that we can gain clear notions of the ancient state of agriculture, of the modes of subsistence, and of the mutual relation of landlord, farmer, and labourer, upon which the happiness and the character of a nation so much more depend than upon legislative enactments or political events. The invaluable series of Church records, printed by the Bannatyne Club, has cleared up many doubtful points of great interest relative to the social condition of Scotland; and the internal state of the Anglo-Saxon people cannot be fully understood without consulting the volumes of Mr. Kemble's Codex Diplomaticus.




---

p.xxi


Of the transactions which took place in the time of Dowling in the counties contiguous to Carlow we might expect to find fuller details in the following than in any other pages; yet even in these Dowling has commonly been anticipated by the publication of Hooker, his more copious contemporary. Of the massacre of Mullaghmast, which is omitted by Hooker, Dowling gives the following account:


1577. Moris Mac Lasy Mac Conyll *O'More*, Lord of Merggi 
as he asserted, and successor of the Baron of Omergi, with forty of his followers, after his confederation with Rory O'More, and after a certain promise of protection, was slain at Mullaghmastyn, in the county of Kildare, the place appointed for it, by Master Cosby and Robert Harpoole, having been summoned there treacherously, under pretence of performing service. Harpoole 
excused it that Morris had geven villanous wordes to the breach of his protection.’’


Such is Dowling's account of this event, the only recorded fulfilment of the blind prophecies[15](javascript:footNote('L100012/note015.html')) current in Queen Mary's days, that there should be a bloody field fought at Mullaghmast, between the Irish and the English inhabitants of Ireland. And so bloody, forsooth, shall it be,’’

 says Stanyhurst, that a mill in a vale hard by it shall run four and twenty hours with the stream of blood that shall pour down from the hill.’’
The value, however, of these Annals does not arise so much from any new facts contained in them, as from their showing the difficulty experienced by an inquisitive and not unlearned man, at the close of the sixteenth century, in his endeavours to gain some knowledge of the history of his country. Well might Hooker[16](javascript:footNote('L100012/note016.html')) complain that the Irish public records were slenderly and disorderly kept, and that private historical collections remained in odd and obscure places.


---

p.xxii




The more fully the student of Irish antiquities is acquainted with the earlier collections, manuscript and printed, so much the deeper will be his gratitude for the benefits conferred on him by the sagacity and industry of Sir James Ware, and by the stupendous learning and sun-bright truthfulness of Archbishop Ussher.


The following pages possess some interest, from the indications of the personal feelings of the compiler on religious and political events. **Dowling**, it must be recollected, was an Irish Protestant churchman, holding ecclesiastical preferment in the reigns of Elizabeth and James I.; yet there is little in his Annals to indicate that he felt any interest in the religious excitement of his times. When, at 1420, he tells how James Earl of Ormonde, in his attack on the Irish enemy, made the clergy of every district, twice every week, in solemn procession, pray for his good success, he adds: Would that the clergy of this time would so devoutly call upon God in prayer that the soldiers should believe that victory was from God.’’

 Of Bishop Magwir and Bishop Deoran, ante-Reformation bishops, he speaks with great respect; and Travers, the first bishop of Leighlin nominated by royal authority subsequent to the Reformation, he calls cruel, covetous, vexing his clergy.’’ It is, indeed, to be feared that in the times immediately preceding, as in the times immediately following the Reformation, when as yet religious and political feelings did not run in the same channels, there was not much earnest religion in this country. The barbarous murder of Bishop Deoran, by his Archdeacon Maurice Cavanagh, gives an evil distinction to the diocese of Leighlin, and tends, at least with regard to that district, to confirm the lamentable description of all orders in the Irish Church, as given in the State of Ireland in 1515.


---

p.xxiii


With regard to his political sentiments, it is plain from the tenor of all his observations that **Thady Dowling** was zealously, and — if he was the author of the peevish wish, I would the rest of the rebels had been so bestowed’’

 — somewhat intemperately loyal to the English Government. In the dissensions which harassed the country there was nothing to attract to the side of revolt thoughtful and cultivated men, even when, like the Chancellor of Leighlin, they were of Irish descent. In the centuries of resistance to English law and English government, from the days of Edward Bruce to the days of Roger Moore, notwithstanding the bold pretensions of Hugh O'Neill, there never appeared amongst the opposers of the Government any system or combination which could awake the thought of national independence. Of all such disturbances the objects were local and personal, and violence and lawlessness were the means used to effect them. Evil as was the conduct of the English party (and, however it may be palliated and accounted for, no one will now justify it), their side was the side of order, and of social and mental progress. It is doubtful that a single town can be named which existed in any merely Irish country, inland or on the coast, independent of English authority and of English municipal regulations. The overthrow of the English Government, at any period from the fourteenth to the seventeenth centuries, would have brought about total anarchy, and would have quenched the faint and flickering light of civilization.


---

p.xxiv


It is only necessary in conclusion to say, that the text of the Annals has been taken from a transcript on paper made for Archbishop Ussher, now preserved in the Library of Trinity College, Dublin, Class E. Tab. 3. No. 
20.


The original brass matrix of the Chapter Seal of Leighlin is preserved in 
the Museum of the Royal Irish Academy; from it the following wood-cut has 
been engraved, and is added here as a suitable illustration of this work. It 
is probably a seal of the fifteenth century.




---

p.1


**Bartholenus, aliter Bastolenus**, **Nini** consanguineus ex successione **Nemrodi** 
in familia **Japheti** nepotis, venit in **Hiberniam** cum sua complici et cum suis tribus filiis, qui vocabantur **Languinus**, **Salamius**, et **Ruthurgus**, viri activi 
et bellatores, eradicabant silvas et *inhabitabant* eandem insulam pro majori parte; et ex hoc isti vocavere certa eminentia loca secundum eorum nomina, 
ut **Langrini** strangius, mons **Salanga**, modo collis **Sancti Dominici**, sed ab **Eliota** dicitur our ladies hill, et per hos eorumque posteros regebatur insula per 30 annos.


In consortio ejusdem **Bartholeni** venerunt plures gigantes ex stirpe **Cham**, viribus admirabiles sed stolidi.


**Bergon, filius Neptuni**, acquisivit **Hiberniam** et insulam **Orkney**.


**Ruanus** gigas in illa peste in quadam spelunca se abscondit, vixit (ut 
aiunt) usque in adventum **Sancti Patricii** per spacium 2400 annorum, et omnia illi retulit, et ab eo baptizatus; hoc tempus *longius* est bis quam aetas **Mathusalem**, sed nihil impossibile Deo.


**Genandus**, **Rutheranus** et **Salvius**, Greci, 5. filii **Dale** ex progenie **Nemrodi**, audientes civilem dissentionem facile eos destruxerunt, et regionem in 5. partes


---

p.2




diviserunt, et in cantredas seu baronias et cetera. 
Postea avaritia regnandi inter se pro principatu contenderunt, et fit 
**Salanus** monarcha per 30 annos, et sepelitur in monte in **Midia**.


Quidam scribunt quod hoc tempore alii **Schithiani** de **Nemrodi** heredibus venerunt, et fecerunt Claym ad **Hiberniam** jure hereditario, fuit magna guerra, sed non obtinuerunt.


A.M. 3576, et ante Christum 387. **Brennus, frater Belini, filius Muluntii**, 
de **Brytannia** venit in **Hiberniam**, et sic **Gurgodwyntius** **Belini** predicti [*...*] sed nullam acquirere potuerunt possessioni quietem, pluries repellebantur. **Brennus** hic fuit coheres **Anglie** anno ut supra, et **Gurguntius** iste erat rex **Anglie** anno mundi 3588. **Lanquetus** dicit quod iste locavit **Hiberniam** *Hispano* **Heremono** et suis filiis, sed cronica Scotorum dicit hoc fuisse ante tempus **Gurguntii**.


**Gathelus**, filius cujusdam nobilis in **Gretia**, nomine **Nielani**, in exilio a patria (for robberies) cum suis adherentibus, in bello strenuus et eloquens, nobiliter serviens contra **Aethiopianos**, sub conductu **Mosis** generalis exercitus, duxit in uxorem filiam Pharaonis, et cetera. Ornavit linguam Hibernicam, dicit **Thaddeus**, et cetera.


**Hiber, filius Jubal**, gubernavit **Hispaniam**, et **Hermon** de progenie **Gatheli** (ut quidam putant), venerunt cum filiis, filiabus, uxoribus in **Hiberniam** de licentia **Gurguntii** regis et cetera, qui jurati de homagio et fidelitate obtinuerunt, et cetera.


A.M. 3270. **Brechus, aliter Simon Brechus, filius Humeci, filii Hiberi**, 
venit in **Hiberniam**, primus rex apud eos coronatus, regna*vit* super **Scotos** (aliter **Scythas**) **Hibernie**. Anno mundi 3270, post diluvium 1616, ab urbe condita 55, post introitum **Bruti** 870, et ante **Christum** 697, hic **Simon** attulit cathedram suam regalem de lapide marmoreo in **Hiberniam**, quem lapidem **Fergutius** auferebat in **Scotiam Minorem** et ibidem reliquit, qui **Fergutius** fuit submersus in **Ultonia**, loco ab ejus nomine hodie nuncupato **Carrekfergus**. Haec fuerunt tempore **Helie prophete**.


**Muridi** **Ultonie** regis filii intraverunt **Scotiam Minorem**, et ibi hinc inde remanserunt, quasdam tenentes possessiones, quas eorum posteri tenuerunt 
vivente **Geraldo Cambrensi**, anno domini 1200.




---

p.3


**Hibernici** quidam fuerunt instructi in fide et baptizati per **Jacobum 
Apostolum**, immediate post Christi resurrectionem.


Scotici scriptores asserunt quandam mulierem christianam de **Pictis** in 
conductu regine **Hibernie** remanentem primo eos instruxisse in fide.


#### 389.0


A.D. 389.


#### 389.1


**Patricius** secundum **Hibernie** scriptores filius **Calphurni diaconi**, et filiae presbyteri, natus inter **Scotiam** et **Angliam** in villa nomine **Kyburne**, cujus matris nomen erat **Conches, (Concha)** germana **Sancti Martini**, **Turonensis** episcopi in **Gallia**. Iste **Patritius** etatis xvi, scholaris et cetera, per piratas **Hibernie** captus et in **Hiberniam** ductus, porcorum custos fuit sub Hibernico, nomine **Mc Bway**, sex annis, quo tempore linguam Hibernicam satis addiscebat, et postea ultra mare transfretavit, et cum **Germano **Augarensi** episcopo** sacram paginam per 40 annos addiscebat.


A **Celestino papa** cum literis comendatitiis venit **Hiberniam**, tempore **Laigerii, filii Nielani magni, monarche totius **Hibernie****, 
predicavit, baptizavit et cetera.


Primo de **Ultonia** petiit **Conatiam** ad **Dovaldum, **Conatie** 
dominum**, qui ab illo baptizatus cum suis; qui misit illum ad **Loganum regem 
**Lagenie****, quem baptizavit, et misit in **Momoniam** ad **comitem Dareys** qui ut ceteri et cetera. Postremo xvi. calend: Aprilis anno 
domini 496 obiit et sepelitur in **Duno**.


#### 389.2


Eodem tempore floruerunt **Brigida virgo** et **Sanctus Columba**, quorum in eodem tumulo inventa sunt corpora statim post **Anglorum** conquestum.


Haec **Cambrensis**, et **Johanes Coursey, miles, comes et conquestor **Ultonie**** testatur se vidisse precipua **Hibernie** Jocalia. 'Tres sunt in **Dunno** et cetera'.


#### 389.3


**Norwegiani**, homines bellicosi, audaces, robusti et avidi, 
ad acquirendum aliorum regnorum conquestum multum dediti, postquam insulas 
de **Orkney** et **Ilees** acquisiverunt, viagium huc in **Hiberniam** fecerunt, tempore **Laigerii monarche **Hibernie**** et tempore **Sancti Patricii**, et ab illo tempore usque ad conquestum **Turgesii Norwegii** *regnaverunt* 33 reges in **Hibernia**, vide infra in **Turgesio**.


#### 590.0


A.D. 590.


#### 590.1


**Gurmundus principalis** eorundem
**Norwegianorum** archipirata (sic etiam **Caradocus**) Affricanus natione, de **Norwegianis** acquisivit **Hiberniam** pro parte, et se regem **Hibernie** nominandum; edificavit **Gormagston**, et constituit filium suum et heredem, nomine **Burchardum, aliter Burchardum


---

p.4




Gurmondi, ducem **Lagenie****, cujus successor communiter vocabatur ab **Hibernicis**
**Gormagheyn, dux montis **Onergi****, sed ut alii volunt, ducem **Lagenie** et **baronem le Margee**. Hic **Gurmundus** fuit qui de **Norwegianis** primo invasit **Hiberniam**, et viam primo aperuit hominibus sue patrie in **Hibernico Mari**; et ulterius, **D. Powell** et **Lanquet** et **Gualter Oxonie** et **Caradocus** habent in cronicis, quod iste **Gurmundus** in anno 590 existens archipirata, **Norwegiorum** capitaneus, rex esset **Hibernie**, et post conquestum **Hibernie** accersitus per **Saxones** contra **Carecticum **Britannorum** regem**, vicit (potius fugavit) **Carecticum** in bello, et prosequebatur **Britannos** ultra rivos de **Severne** et **Dee**.


#### 590.2


Et dedit **Lloegriam** **Saxonibus** et ibidem 
edificavit **Gurmondcestriam**, et postea, secundum historiam **Hibernie**, transfretavit in **Galliam** ad conquerendum et cetera, ubi moriebatur, sed **Hibernici** antiquarii negant eum fuisse monarcham **Hibernie**, quia non subjugavit preter **Lageniam** et Midiam quod pro conquestu non reputarunt.


#### 590.3


**Burchardus Gurmundi**, qui vulgariter nominatur **O Gormagheyn, dux (ut asseritur) **Lagenie****, edificasse dicitur **Gurmundi** grangiam, et palatium suum in **Monte Margeo** cum aliis memorabilibus pro se et suis, et fundasse matricem seu prioratum veteris **Leighlen**, sed potius eam dotavit tempore **sancti Eubani** ***Lenie*** patroni; sed quidam nomine **Lazerianus**, episcopus et confessor, pro fundatione et erectione ecclesie cathedralis ibidem anno domini 651 fuit procurator. Vide record **Leiglen**. In eadem ecclesia fertur ille dux esse sepultus ex parte boreali in muro summo chori juxta stallum thesaurarii ecclesie sub lapide marmoreo habens ipsius ducis *nomen* desuper. Wittnesses lyvinge 1589 **Karolus Rowac alias Makeyigan** clerk, **Donagh Mc Gilpatrik**, and **Gilleranoy** carpenters saw the tumbe with their eyes, and **Thady *Dowling*** cancellar: ecclesie found his epitaph in simple verse as followeth:


> 1. Hic jacet humatus dux fundator **Leniae**, *id est Leghleniae*.
>   
> En **Gormondi Burchardus** vir gratus ecclesie.
> 


Extant etiam adhuc alia testimonia circa hanc villam; scilicet nomina quorundam locorum ut **Gormondus Grove** et **Gormondes Foord** et cetera.



#### 542.0


Anno circa 542.


#### 542.1


**Arthurus, filius Uter Pendragon**, subdidit sibi **Scotiam**, **Hiberniam**, **Daciam**, **Norwegiam**, **Islandiam**, **Gutlandiam**, **Insulas Orchadum** et **Galliam**, vicit **Lucium** generall of the Romaine army. Sic **Thaddeus**.




---

p.5


#### 592.0


A.M. 4553. A.D. 592.


#### 592.1


Plures **Britones** fugam receperunt in **Hiberniam** ad evitandam tyrannidem **Ethelfredi** et sociorum **Saxonum**.


#### 830.0


A.M. 4791. A.D. 830.


#### 830.1


**Turgesius Norwegianus** cepit acquirere **Hiberniam** per generalem conquestum, vicit **Edlongdingum regem, monarcham **Hibernie****, obtinuit totam terram et regnavit ut rex xxx annos. Sed quidam tradunt ipsum fuisse locum tenentem **Norwegianorum**; et tandem superbia elatus filiam unicam **Medensis** regis, nomine **O Melaghlen**, struprare (others say marie) volens, petiit ab **O Melaghlen** ut sibi traderet ejus filiam. Rex respondebat quod illud non convenebat, sed tortuoso vultu aspiciens et cetera. Si opporteat, inquit, mittam eam cum aliis pulchrioribus puellis ad certum diem secrete, quod bene placuit **Turgesio**, et assignavit locum et diem. Pater misit eam cum xvi. pulchris juvenibus, quorum quilibet habuit longum cultrum sub muliebri veste, et venientes in cenaculum ubi ille **Turgesius** cum lasciviosis suis complicibus erat, et ubi interfecerunt eum cum suis, et recesserunt ad exercitum regis **Midensis**, qui prope in abscondito juvenum expectabat adventum, et tunc cepit conquestus **Hibernicorum**.


#### 861.0


A.M. 4822. A.D. 861.


#### 861.1


**Abloickus **Hibernie** rex** cum suo conductu applicuit in insulam de **Mona**, aliter **Man**, et *cremando* villam de **Holyhead** spoliavit com*itatum* de **Llynn.** — **Powell** p. 62 (61) et obiit — **Powell** pag. 15.


#### 948.0


A.D. 948.


#### 948.1


**Abbatia beate Marie** juxta **Dublin** erecta per **Danos**. — **Cambrensis**.


#### 950.0


A.D. 950.


#### 950.1


**Dani** venerunt iterum in **Hiberniam**
et interfecerunt in bello **Cormachum, **Hibernie**
monarcham** et episcopum (id est **primatem**) totius **Hibernie**, ac filium **Cukemani**, hominem pium et religiosum, et **Kirvaltum filium Murigani **Lagenie** regis.**[17](javascript:footNote('L100012/note017.html'))


#### 924.0


A.D. 924.


#### 924.1


**Hawlassus **Hibernie** monarcha** interfectus per 
**Adelstanum** ...... apud **Bremestbury** cum rege **Scotie** et 5. regibus 
**Danorum**.[18](javascript:footNote('L100012/note018.html'))


#### 952.0


A.D. 952.


#### 952.1


**Congellach **Hibernie** rex** interfectus.[19](javascript:footNote('L100012/note019.html'))


#### 952.2


**Rodericus filius Edwalli Voel rex **Britannie**** interfectus fuit in **Britannia** per **Hibernicos** qui spoliaverunt comitatum de **Aberfraw**. ibid.


#### 952.3


**Hibernia** destructa per vermes ignotos, duos habentes dentes.[20](javascript:footNote('L100012/note020.html'))




---

p.6


#### 1012.0


A.D. 1012.


#### 1012.1


**Bernardus vulgariter Brian Bowrow **Hibernie** monarcha** ac filius ejus **Murchardus McBrian** et alii ejus reguli circa haec tempora in bello **Clantarf** juxta **Dublin** pugnaverunt viriliter contra **Sutrarcum, aliter Sutrik**, filium **Abloicci regis **Dublin****, et **Moylmordha regem **Lagenie****; qui **Sutrick** conduxit multos milites advenas et piratas pro stipendio, in quo bello ceciderunt **Bernardus ille monarcha** cum suo filio **Mauro**, et aliis quampluribus de familia et exercitu suo, et ex altera parte **Moylmordha **Lagenie** rex** et **Roderikus magnus piratarum advenarum capitaneus** cum innumerabilibus aliis.[21](javascript:footNote('L100012/note021.html'))


#### 1041.0


A.D. 1041.


#### 1041.1


**Conan, filius Jago, rex **Northwallie****, fugit 
in **Hiberniam**, et cum **Alfredo **Dublinii** rege** reintravit **Northwalliam**, et secum attulerunt **Griffith regem **Northwallie**** captivum, et reverterunt in **Hiberniam** non absque detrimento hominum et navium.[22](javascript:footNote('L100012/note022.html'))


#### 1050.0


A.D. 1050.


#### 1050.1


**Conan filius Jago** navigando iterum in **Walliam** amisit quamplures tam per mare submersos quam in terra interfectos, et **Herald** venit cum eo in **Hiberniam** fugiendo quia adulterium cum regina **Anglie** comisit.


#### 1054.0


A.D. 1054.


#### 1054.1


**Hibernici** transfretaverunt ad **Griffith regem** in **Walliam** cum xviii. navibus; **Algerus Leafrici** fuit eorum capitaneus.


#### 1066.0


Circa A.D. 1066.


#### 1066.1


**Dani**, **Norwegii**, **Normanni**, et **Sueviani**, 
nomine communiter **Ostomanni**, e regione de **Scandinavia** fluxerunt in **Franciam**, **Angliam**, **Hiberniam** et ****Scotiam Minorem****.


#### 1071.0


A.D. 1071.


#### 1071.1


**Amylavus Sutaricus**, ad petitionem regis **Lagenie** procuravit **Broydericum gigantem, archipiratam et capitaneum advenarum**, filium domini regis **Danorum** de **Denmark** in **Hiberniam**, qui **Broydericus** et sui interfecerunt **Brian Borowe, supremum **Hibernie** monarcham**, in bello de **Clantarf** juxta **Dublin**, cum suo herede **Morgho Mc Brian** et suo exercitu, pluresque regni nobiles, qui sepeliuntur ante crucem de **Kylmaynam** *circa* Annum Domini 1077, ut quidam historici **Hibernie** scribunt; a quorum opinione **D. Powell** differt in supputatione annorum, nec mirum cum Powell Hibernicas fyguras quibus utitur facile cognoscere non valuit, scribunt enim ho [*...*] 1564.


#### 1074.0


A.D. 1074.


#### 1074.1


**Patricius, **Dublin** episcopus**, fuit in **ecclesia **Sancti Pauli**** **London** per **Lanfrancum **Cantuariensem** archiepiscopum** consecratus, super comendacione **Teudionati, **Hibernie** monarche**, **Goderiique regis **Lagenie****,


---

p.7




ad electionem cleri et populi episcopatus **Dublin**; hic erat eorum mos creandi episcopos, quia nondum Armachanus nec alii **Hibernie** archiepiscopi sua receperunt pallia, ut quidam antiquarii scribunt et affirmant, quod monarcha **Hibernie** propter dominium regale, titulumque honorum coronae et alia regis privilegia, habuit negativam vocem in nominatione episcoporum totius regni.


#### 1077.0


A. D. 1077.


#### 1077.1


**Frotho, aliter Frotheus, rex **Danorum** 3.** post acquisitionem **Britannie** venit in **Hiberniam** et interfecit **O Carvell, capitaneum **Hibernicorum** bellantium**, et recepit fratrem **capitanei** hujusmodi in suam protectionem; et circa hoc tempus **Hibernici** bellaverunt ex parte **Grifitz filii Conan** apud montes **Carmoon** in **Wallia** contra **Trahaern ap Caradoc**, ubi victoriam obtinuerunt famosam.


#### 1105.0


A.D. 1105.


#### 1105.1


**Hugleto **Hibernie** monarcha** (regnante 
**Stracathero gigante**) a **Frotho 4. **Danorum** rege**, in comitiva **Herconis Segathii** **capitanei** exercitus **Danorum**, venit in **Hiberniam**, quem quidem **Herco Segathus** Hibernicus dire vulneravit in capite, sed gigas hic **Stracatherus** talis stature, et animositatis ut obtineret victoriam, et **Dani** crediderunt illum invincibilem, quidam **Hibernici** vocarunt illum **Fin Mc Coyl**, sed brevi post fuit interfectus.


#### 1105.2


Circa hoc tempus **Cowkaggrig de Omoardha** principalis de **Clanmelaghlen** in **Basca**, fundavit et dedicavit **monasterium de Lege Dei** in **Lease Carraghain** in **Lagenia**.


#### 1105.3


**Reygnyrus filius Sydwardi**,
2. ejusdem nominis, **Danorum** rex venit in **Hiberniam**
et interfecit in bello **Melbrichum, regem
**Hibernie****, et **Dublinia** devicta in eadem remansit
per 12 menses.


#### 1105.4


Regnante **Willelmo Rufo conquestoris filio** in **Anglia**, exercitus **Hibernicorum** cum **Riseo, aliter Rees, filio Theodori **Britanni****, devicit regem **Wallie** **Blethyn Convyn** in bello de **Llecryd** in **Wallia** *AD 1087*.


#### 1105.5


**Owinus, filius Cadogan ap Blethyn**, 
**Northwallensis** fugit hic *in* **Hiberniam**, eo quod interfecit **Willelmum de Braubant episcopum**, propter quod rex **Anglie** expulit patrem ejus **Cadogan**, et totam ejus hereditatem in **Cambria** dedit **Gilberto Strangbow, comiti **Strugulensi****, qui comes edificavit castrum de **Kylgaran** juxta **Powis**.


#### 1105.6


**Grifitz filius Risei**, educatus in **Hibernia** ab infantia, incepit vexare dominium **Gilberti Strangbow**, et in adjutorium sibi assumpsit plures **Hibernicos**.




---

p.8


#### 1120.0


A.D. 1120.


#### 1120.1


**Murchardus serenissimus **Lagenie** in **Hibernia** princeps**, fidus amicis, terribilis inimicis, alienis liberalis, a *subditis* propter ejus benemeritam pietatem et justiciam pre caeteris amandus, obiit, (quem cives **Dublin** in domo consilii occiderunt et fecerunt cum cane sepeliri ut infra) et apud **Fernes** sepelitur. He was not so much beloved, but his sonne **Dermot McMorogh** (for his cruelty and adulterie committed with the wif of **Morice alias Murdhich king of **Midia****) was hated, as shall appeare in the history followinge.


#### 1120.2


**Walterus fitz Richard** fit primus comes **Penbrochie** Anno 31. Henrici 1. et edificavit abbatiam de **Tyntern** in **Wallia**, cui successit **Gilbertus Richardus** et cetera. Anno Stephani 14.


#### 1137.0


A. D. 1137.


#### 1137.1


Tres soles apparuerunt coloris rubei, unde magne guerre et effusio sanguinis per totam **Angliam**, **Walliam**, et **Hiberniam**.


#### 1137.2


Eodem anno, mense Junio, duo dracones videbantur circa littus maris in australi parte **Wallie** invicem prosequentes effectus, sequebatur, nam Richardus Marshall de **Hibernia**, et Llewelyn princeps **Wallie**, insurrexerunt, et igne et gladio totam patriam usque ad 
Salisburiam, et sequebatur **fames**. Rex Henricus 3. pacem cum eis fecit.


#### 1137.3


A. D. 1137. Griffith ab Conan, princeps 
**Northwallie**, natus in **Hibernia** ex muliere Hibernica, filia regis Eblane, 
aliter **Dublin**, duxit secum ex **Hibernia** lyras, tympanas, cruttas, cytharas, 
cytharizantes.


#### 1142.0


A. D. 1142.


#### 1142.1


**Kadwalader ap Griffith ap Conan** fugam recepit in **Hiberniam**, et conduxit pro stipendio 2000 marcarum filium **O Carvelli, nomine Cherulsum** capitaneum super 1000 hominibus ad bellum aptis, una cum spoliis et predis suis, et applicuerunt apud **Carnarvon** in **Wallia**, ipse cum suis adversariis de treuga concludens dedit **Hibernicis** nomine stipendii 200 animalia, preter spolia quaedam, sed quia (ad pacem confirmandam) haec spolia restituere recusarunt, **Kadwalader** **Hibernicos** spoliis et omnibus aliis spoliavit, et pro majore parte eos interfecit persequens eos usque ad naves.


#### 1147.0


A. D. 1147.


#### 1147.1


**Cogganus** ecclesie de **Killuskin** aliter **Killeshin** in Margge **Lagenie** patronus floruit hisce diebus, et ut **Nicholaus Magwyre** testatur, scripsit gesta **Malachie Armachani** et **Bernardi Clarevallensis**.


#### 1155.0


1155.


#### 1155.1


**Terdielach rex **Conatie**** in **Hibernia** obiit. *AD 1156*


#### 1155.2


**Roderik Conchurk, rex **Conatie****, factus est **Hibernie** monarcha a vindicando


---

p.9




injuriam **Moricii alias Murdhicii** regis **Midie**, sibi illatam per **Dermitium Mc Murchardi, **Lagenie** regem**, qui **Moricio** in remotis agente rapuit illius uxorem. **Roderik** avidus regnandi (postquam proprium fratrem occidisset) petiit **Lageniam**, expulit **Dermitium**, totam ejus regalitatem in **Lagenia** sibi assumpsit, fit monarcha; peniten*tia* ductus pro nece fratris dicitur erexisse campanilia, alii dicunt quod hoc fecit in signum victorie.


#### 1155.3


**Laurentius O Toole**, abbas **sancti Kevini**, consecratur **archiepiscopus** **Dublin** a **Gelatio **Armachano****, obiit 1180.


#### 1155.4


**Henricus 2.** conduxit magnam classem ex **Hibernia** versus **Britones**.—[23](javascript:footNote('L100012/note023.html'))


#### 1155.5


**Henrici 2.** tempore **Robertus fitz Stephans** cum 30 militibus, 60 armigeris, et 300 sagittariis cum **Mauritio fitz Gerald** applicuerunt apud **Bagganbun** in comitatu **Weixford**. *AD 1169*

> 1. At the creek of **Bagganbun**
>   
> Ireland is lost and wonne.
> 


(Lost by the **Irish** and wonne by the **Welsh**).



#### 1155.6


**Robertus** et **Mauritius** fuere germani ex una matre, **Vesta filia Risei**, avia **Risei ap Griffin principis **Wallie****.


#### 1155.7


**Mauritius de Prindergast** nobilis cum decem militibus et 100 sagittariis ex portu **Milford** in duabus navibus applicuit 2 die Maii.


#### 1155.8


**Dermitius** de horum adventu intelligens misit spurium suum *filium* **Donvald** cum 500 **Hibernicis** ad **Robertum fitz Stephan** et complices ut venirent **Weixfordiam**; villa per tres dies insultante, **Alphonsus episcopus** ibi residens villanos persuadebat se suo regi reddere. **Dermitius** dedit **Roberto fitz Stephans** **Weixford** cum suis pertinenciis, et **Harveio de Monte Marisco** 2 cantredas inter **Weixford** et **Waterford** juxta littus maris jacentes in perpetuum.


#### 1155.9


**Britones** habentes 3000 homines ad bellum, *primo* **Donwaldum principem superioris **Ossorie**** vicerunt, et certos dominos illius loci, et **Dermitio** tradiderunt 300 capita occisorum. Ubi **Robertus Barry** et **Milerus** multum commendebantur.


#### 1155.10


**Roderik Conchur**, monarcha (ut superius) cum aliis regulis quamplurimis insurrexit, et obtulit pacem sub hiis conditionibus quod **Dermot Mc Morogho rex **Lagenie**** de fidelitate jurans monarche, haberet et reciperet omnia jura et dominia regalia in **Lagenia**, quae **Roderik** confiscabat super fuga et demeritis ejus. *secundo* quod idem **Dermot** spurium filium suum **Conthurum** **Roderico** vadiaret pro pace tenenda, cui **Rodericus** promisit filiam suam in maritago dare, si haec fideliter


---

p.10




observentur. *tertio* quod **Dermitius** restitutus dimitteret **Walenses** ex tota **Hibernia** sine spe redeundi.


#### 1155.11


Rex de **Ardglas** fundavit abbatiam de **Mellefont**, que antiquior reperitur aedificata in **Hibernia**, preter **monasterium** **beate Marie** juxta **Dublin** quae incepta fuit per Danos 948, ut supra.


#### 1155.12


**Richardus Strangbo**, obtenta licentia a domino rege, premisit **Reymundum de la Grosse** cum 10 militibus et 70 sagittariis, qui applicuit apud **Dunevols** circa 4 milia a 
**Waterfordia**.


#### 1155.13


**Richardus Strangbow** cum 200 militibus ex **Milfordia** applicuit apud **Waterfordiam** vigilia Bartholomaei et crastino, scilicet die Martis, insultarunt parietes civitatis, a quo bis repulsi, tandem fregerunt parietem sub domo quadam desuper edificata, et inde obtinuerunt sanguineam victoriam. Deinde **Dermot **Laginensis** rex** et **Robertus fitz Stephan** accesserunt ad **Waterfordiam** et nupsit **Evam filiam eidem comiti Strangbo**, cum reversione in successione regni sui post ejus mortem. Iste **Strangbo** dicitur fuisse constabularius **Anglie** et vicedominus **Normannie**, sed tandem propter ejus prodigalitatem impignoravit dominium suum pro majori parte, et in manus regis confiscabatur, adeo quod placuit ei fortunam sequi. **Powell** dicit quod iste comes venit in **Hiberniam** sine licentia regis, ideo terra et dominium suum confiscabantur, et quod petiit restitutionem possessionum suarum aut licentiam conquerendi in ultra-marinis partibus, sed post conquestum **Lagenie** oportebat eum dare domino regi, **Dublin**, **Weixford**, et 
**Waterford**.


#### 1171.0


A. D. *1171*.


#### 1171.1


Civitas **Dublin** fuit capta per **Strangbo**, et **Dermitius rex** ejusdem cives crudeliter punivit; eo quod patrem suum eorum ad tunc regem, in domo consilii *existentem* homicidio interfecerunt, et cum cane sepeliri fecerunt.


#### 1171.2


Eodem anno, **Midia** et confines spoliantur per **Dermitium** igne et gladio, et **Roderik** monarcha decapitari fecit **Conthurum** filium regis **Lagenie**, quia pater ejus noluit expellere incursionem **Britonum**.


#### 1172.0


1172.


#### 1172.1


Clerus apud **Armach** congregati concludunt conquestum **Hibernie** non posse refrenari, et cetera.


#### 1172.2


**Dublin** assalted by **Hastulph** qui olim presidebat eidem civitati, et nunc venit cum **Norwegianis** sub conductu **Johannis Heywod**, quos **Miles Coggan** expulsit. **Heywood** interfectus et **Hastulphus** captus et decapidatus.




---

p.11


#### 1172.3


*Secundo*. **Laurentius archiepiscopus **Dublin****, persuasit **Rodericum monarcham** et **Godthredum regem de **Man****, cum **Hibernicis** et insularibus ad obsidendam civitatem **Dublin**. **Donaldus filius Dermitii** nuper regis **Lagenie**, venit ex **Kynsely**, ac **O Breyn**, nec non dominus de superiore **Ossoria**, obsiderunt castrum de **Carrig Carughornan** juxta **Weixfordiam**, ubi **Robertus fitz Stephan** was betraied, et cetera. Sed **Cogan** et **Dublinenses** confundebant **Rodericum**, et venientes per passum de **Polmonte** confundebant **O Brien** et **Ossorienses**.


#### 1172.4


*Tertio*. **Oraricus rex **Midie****, vocatus monoculus, venit ad **Dublinium** cum magna hominum armatura et obsidens convincebatur per **Cogan**.


#### 1172.5


**Henricus 2.** applicuit apud **Waterfordiam** cum 500 militibus preter equos et sagittarios, anno etatis sue 41. regni 18. et comisit **Robertum fitz Stephan** **Rightgenald** turri, quia absque licentia sua talem conquestum adtemtavit, sed postea cum eo misericorditer dispensavit.


#### 1172.6


Reges Southwest **Hibernie** venerunt ad **Henricum 2**, scilicet **Dermitius rex **Cork****, **Donvaldus rex 
**Lymricii**** in **Cashell**, et **Donvaldus** ac **O Melaghlyn** ex parte boreali, venerunt ad rivulum de **Sure**, et submittendo se juraverunt et exhibuerunt vadimonia de pace domini regis tenenda.


#### 1172.7


Apud **Dublin** venerunt **Machelanus O Phelan**, **O Mac Chalewy**, **O Tuelihelly**, **Gile Mc Holmoc**, **O Cathdhessy**, **O Carvell** de **Uriell**, et **Orwairk** de **Midia**. Sed **Roderik** rex **Conatie** obviavit **Hugone de Lacy** et **Willelmo fitz Adelm** ambasiatoribus domini regis apud rivulum de **Shynien** in confine **Midie**, et fecit homagium et promisit tributum et sic obtinuit pacem domini regis.


#### 1173.0


1173.


#### 1173.1


Cleri **Hibernie** congregati in **Cashell** autoritate **pape Adriani** et **Alexandri** ad instantiam **Henrici 2.** tunc in **Hibernia** existentis pro reformatione ecclesie et cetera. Ubi ****Lismorensis** episcopus legatus, Donatus **Cashellensis****, **Laurentius **Dublin**** et **Catholicus **Tuanensis****.


#### 1173.2


In primis, quod inhabitantes non contraherent aliquod incestuosum matrimonium cum suis consanguineis contra canonum sanctiones.


#### 1173.3


*Secundo*. Quod eorum infantes catechizentur per parochianos in porta ecclesie ante baptismum in fonte.


#### 1173.4


*Tertio*. Quod omnes, qui se pro christianis 
gerunt, solvant integras decimas bladorum, catallorum, et aliorum crescentium absque deductione expensorum, et diminutione.


#### 1173.5


*Quarto*. Quod territorium ecclesie et omnes 
mansiones sint libere et immunes ab omni seculari exactione et impositione, et in specie, quod nec reges nec comites


---

p.12




neque alii domini **Hibernie**, aut eorum filii, aut familia, vel caputanei, vel alii aliqui temporal[*gap: extent: two letters*] petant, aut presumant aliquo modo exigere violenter ab hinc aliqua esculenta aut poculenta, aut pernoctare infra terram ecclesie, nec habeant nec petant fore illam dietam, quam in temporibus retroactis, quarterie annuatim exigere solebant ab ecclesiasticis personis.


#### 1173.6


*Quinto*. Quod homines ecclesiastici per compositionem redemptionis seu recompensationis homicidii per consanguineos comissi, non cogantur aliquid solvere, nisi probentur accessorii in crimine.


#### 1173.7


*Sexto*. Quod testamentum condens faciat testamentum fieri et legi coram personis fide idoneis, et bona sua debitis servorum stipendii solutis dividantur inter uxores, liberos, et executores ad usum funeralium, seu ut *defunctus* in vite tempore aliter ordinavit, et si non habeant liberos dividantur bona inter defunctum et uxorem. Sed si habeant liberos, uxore decessa, tunc dividantur inter se et liberos equaliter.


#### 1173.8


*Septo*. Quod funeralia defunctorum devote et solempniter teneantur et exequantur, et omnes vicini, sive fuerint inimici sive non, habeant tempore funeralium atque exequiarum liberum accessum et recessum.


#### 1173.9


*Octo*. Quod ecclesia **Hibernie** sit in 
uniformitate cum ecclesia Anglicana secundum usum, morem, ritum et ceremoniam ecclesie **Salisburiensis**.


#### 1173.10


Abusus ecclesie **Hibernie** sub sigillo legati fuere propositi, et confirmati per communem Synodi consensum, et postea per **Gelatum alias Gelasium Armachanum primatem** in **Dublin**, qui ratione sue debilitatis et senectutis ad **Cashell** venire non poterat, ita consumptus erat senio quod lacte unius vacce albe utebatur 
tantum, et anno sequenti obiit.


#### 1173.11


**Maelgunus**, germanus regis **Northwallie**, fugit a domino fratre suo in **Hiberniam**, sed revertendo in **Walliam** ex **Hibernia** capiebatur a **David ap Owen** principem predictum ubi plures **Hibernici** conciderunt.


#### 1173.12


**Ororicus, rex **Midiensis****, interficiebatur per **Hugonem Lacy**, quia ille proposuit interficere eum **de Lacy** secum in preliando.


#### 1173.13


**Lymric** iterum capta per **Redmundum de la 
Grace** die Martis, cujus pretextu rex **Conatie** et **Donaldus rex **Thomonie**** 
renovarunt homagium.


#### 1173.14


**Richardus Strangbo**, comes **Penbrochie**, dominus de **Chepsto** et **Ogney** in **Anglia**, comes **Strangulensis**, atque in **Hibernia** comes **Marchiarum**, primus


---

p.13




Anglus qui primo invasit **Hiberniam**, obiit circa Kalendas Junii, et sepelitur in ecclesia Trinitatis **Dublin** coram imagine crucis, relinquens unicam filiam, nomine **Isabellam**, quae remansit sub custodia domini regis **Anglie** 14. annis.


#### 1173.15


Hoc anno **Geraldus Cambrensis** cum fratre suo **Philippo Barry** venit in **Hiberniam** ad taxandum supervidendum seu describendum terram **Hibernie**, qui collegit descriptionem totius terre **Hibernie** ad petitionem **Roberti fitz Stephani** avunculi sui.


#### 1173.16


Eodem anno castrum **Fernes** fuit edificatum per filios **Mauricii fitz Gerald**.


#### 1173.17


**Johannes Courcey**, factus comes **Ultonie**, obtinuit victoriam quinque bellis versus **Ultonienses**, antequam fecit quietum conquestum, scilicet bis in **Down**, semel afferendo *praedam*, semel in **Uriel**, et postremo juxta fontem de **Iveary**.


#### 1173.18


**Vivianus cardinalis** tituli **Sancti Stephani** in **monte Celio** sede Apostolice legatus, ab **Alexandro papa** missus, venit in **Hiberniam** ad significandum titulum et interresse domini regis **Anglie** ad insulam **Hibernie**, super reservatione denarii Petri, et insuper ad denunciandum excommunicatos et maledictos omnes, qui resisterent aut negarent dare cibarium seu victum militibus ac familiis domini regis pro rationabili pretio.


#### 1173.19


**Milo Coggan** et **Richardus, alias Radulfus, filius Stephani** ejus gener interfecti fuerunt inter **Waterfordiam** et **Lism*ore*** per proditorem nomine **Machthyri**, qui duxit eos ad convivium.


#### 1173.20


Ecclesia cathedralis **Sancti Patricii** **Dublin** fundebatur per **Johannem Comen archiepiscopum**, dedit eidem obventiones et convertebat eam a parochiali in Cathedralem, et postea controversia oriebatur inter ecclesiam Trinitatis et eam, sed Trinitas obtinuit preferentiam.


#### 1173.21


Abbatia de **Jeripont** in comitatu **Kilkennie** fundatur per **Donatum O Donachow**.


#### 1173.22


**Meiller** mutavit **Kildariam** pro **Lacia**, nunc vocata **Queenes Countie**, ut **Omoordha** vi et gladio subjugaret, quos **Harvey** in aliquam *non* potuit adducere conformitatem pacis, eo quod ille **Meiller** erat vir bellicosus et sanguineus.


#### 1173.23


**Johannes Lacy**, constabularius de **Cestria**, 
et **Richardus de Peach** missi sunt gubernatores in **Hiberniam**, edificarunt castrum in Frontera id est in **Forhirtha Ynowland**, **Trysteldermot**, et **Tawlaught** et sic deinde reverterunt in **Angliam**.




---

p.14


#### 1173.24


Circa haec tempora **Mauritius fitz Gerald, justiciarius **Hibernie****, edificavit castrum de **Sliggagh** in **Conatia**, vivente **Phelino O Conchur rege** ibidem.


#### 1227.0


1227.


#### 1227.1


Civilis guerra et comotio inter **Hugonem Lacy** et **Willelmum Mariscall**, adeo ut **Midia** devastabatur. **Galfridus Trewell episcopus **Ossoriensis****.


#### 1233.0


1233.


#### 1233.1


**Gualterus Lacy dominus **Midie**** obiit, habens 
ij. filias heredes scilicet **Margaretam** uxorem domini **Thome Verdon**, et 
**Matildam** uxorem **Galfridi Genevile**.


#### 1234.0


1234.


#### 1234.1


**Richardus Mariscall** comes **Penbrochie** et dominus de **Ossoria** in **Hibernia**, dire vulneratus juxta **Kildar** in bello de le greath heath et obiit 4.[ordm ] Aprilis, sepelitur apud **Kilkenniam**, et secundum alios captivus fuit apud **Lacy**. **Powell** dicit hoc fuisse anno 1231, proditione familie sue, pag. 291.


#### 1242.0


1242.


#### 1242.1


**Gilbertus Mariscallus**, 3. filius Willelmi senioris, comes **Penbrochie** factus, intravit suam Hibernicam hereditatem.


#### 1242.2


**Mauritius fitz Gerald de **Tyrconell**** et seisatus in tota provincia dedit dimidiam **Cormaco McDermot McRory**.


#### 1242.3


**Hugo Mapilton episcopus **Ossoriensis**** primus fundator ecclesie **Sancti Kenitii** **Kilkenie** claruit et obiit, ut alii dicunt 1243, alii 1256.


#### 1243.0


1243 aliter 1253.


#### 1243.1


**Hugo Lacy comes **Ultonie**** obiit et sepelitur in monasterio fratrum minorum **Carregfergi**, relinquens unam filiam heredem, quam **Walterus de Burgo** desponsavit et sic factus comes **Ultonie**.


#### 1245.0


1245.


#### 1245.1


**Walterus Mariscallus**, 4. filius **Willelmi senioris, comes **Penbrochie**** obiit apud castrum **Godrici** juxta **Monmoth**, cui successit 5. filius **Ancelmus**, sed quia ordine juris omisso absque licentia domini regis hereditatem intravit, uxor sive relicta ejus portione uxorali gaudere non potuit. Marescallis omissis, 5 fratres absque heredibus decesserunt, et hereditas eorum fuit impartita inter 5. filias Mariscalli, videbis in brevi collectione seu summa per **Nicolaum episcopum **Leighlin**** extracta, quam causa brevitatis hic omitto et scribam in foliis inter alias et cetera.


#### 1252.0


1252.


#### 1252.1


**Henricus 3.** concessit suo seniori filio **Edwardo Gasconie** principi **Hiberniam** et comitatum **Cestrie**.


#### 1253.0


1253.


#### 1253.1


**Johannes Geffrey** miles **justiciarius** **Hibernie**, forsitan eo anno obiit.


#### 1257.0


1257.


#### 1257.1


**Mauritius filius Galfridi de **Geraldinis**** qui primus fundavit **monasterium** fratrum minorum de **Yoghell** alias vocatur **Mauritius fitz Gerald**.


#### 1246.0


1246. *?*


#### 1246.1


**Galfridus de Sancto Leothegario episcopus **Ossoriensis**** famosus obiit.


#### 1246.2


1246 vel 1257. **Aelianus de la Zouch** **justiciarius** **Hibernie**.




---

p.15


#### 1246.3


Vide antea. **Mauritius fitz Gerald** et **Phelinus O Conchur** postquam venerunt ex **Wallia** pugnaverunt ex parte **Cormaci McDermot McRory** contra **O Donull** Hibernicum inimicum, qui subditos domini regis in **Ultonia** crudeliter vexavit post obitum **Lacy** nuper **comitis** ibidem.


#### 1258.0


1258.


#### 1258.1


**Stephanus de longe Espee** justicarius **Hibernie**. Anno 42 Henrici 3. interfecit **O Nel** cum 352 ejus familiaribus in vico de **Down**.


#### 1261.0


1261.


#### 1261.1


**Willelmus Den** **justiciarius** **Hibernie** obiit, et **Johannes fitz Thome de **Geraldinis**** (Desmond) cum filio ejus interfectus, 
qui fuit fundator monasterii de **Trayly**.


#### 1262.0


1262.


#### 1262.1


**Rogerus, episcopus **Ossoriensis****. **Thomas, episcopus **Leighlenensis****.


#### 1264.0


1264.


#### 1264.1


**Mauritius fitz Gerald** et **Mauritius fitz Maurice** (filius ejus) manuceperunt **Richardum de Capella justiciarium** et **Theobaldum Butler** et **Milonem Coggan** apud **Tristledermot** et inde **Hibernia** plena erat civili guerra et comotionibus inter **Geraldinos** et **Walterum Burk comitem **Ultonie****, ceterosque **Burkes**.


#### 1268.0


1268.


#### 1268.1


**Conchur O Brien** fuit interfectus per **Dermitium McMynard**.


#### 1268.2


**Mauritius fitz Gerald comes **Desmondie**** submersus inter **Walliam** et **Waterfordiam**.


#### 1269.0


1269.


#### 1269.1


**Terremotus** in **Hibernia**.


#### 1269.2


Castrum de **Roscoman** fundatum et pene edificatum.


#### 1270.0


1270.


#### 1270.1


**Hugo, **fratrum minorum**, episcopus 
**Ossoriensis****, dedit fontem **Sancti Kenitii** monasterio ibidem.


#### 1271.0


1271.


#### 1271.1


**Richardus Verdon** et **Johannes Verdon** interempti et castrum **Sligo** fundat*um*.


#### 1271.2


**Pestilentia** et **fames** in tota **Hibernia**, et **Fulco archiepiscopus **Dublin**** obiit.


#### 1271.3


**Bonifacius papa** petiit decimam omnium spiritualium promotionum in **Hibernia** pro tribus annis in subsidium ad guerrandum contra regem Aragon.


#### 1271.4


Henricus 3. obiit.


#### 1272.0


1272.


#### 1272.1


**Edwardus 1.**


#### 1272.2


**Dominus Walterus de Genevile** revertens a terra Sancta factus **justiciarius** **Hibernie**.


#### 1272.3


**Waterfordia** fuit cremata in magna parte.


#### 1272.4


**Ricardus de Burgo comes **Ultonie**** et 
**Eustacius le Poer miles** invaserunt **Scotiam**.


#### 1272.5


**Waltergus alias Gwalterus episcopus 
**Leighlen****.


#### 1276.0


1276.


#### 1276.1


Magna strages hominum in **Glyn-burrie** et **Rathpipherd**; et **Hanloynes** persequebantur **O Neill** in bello, et castrum de Roscoman captum est per **Hibernicos** iterum.




---

p.16


#### 1277.0


1277.


#### 1277.1


**O Bryen Roo regulus **Tholeremundi**** interfectus per **Thomam de Clare**, et idem Thomas cum suis fuerunt inclusi per **Hibernicos** in **Slowbanny**.


#### 1277.2


**Edwardus 1.**, statutum de terris in mortuam manum alias mortmayne (anno 9.o Henrici 3. conditum) renovavit, quod fuit confirmatum anno 23 Henrici 8. et cetera, multa dabantur ecclesiis.


#### 1278.0


1278.


#### 1278.1


**MacDermot de **Moylargo**** interfecit **Cothgurum O Conchur regem **Conatie****, et **Johannes de Derlington** *fuit* **archiepiscopus**
**Dublin**, secundum **Raphuell**.


#### 1281.0


1281.


#### 1281.1


**Adam Cusak junior** interfecit **Willelmum Barret** et plures **Hibernicos** in Conatia.


#### 1281.2


**Fulburnus frater, episcopus **Waterfordie****, 
factus est **justiciarius** **Hibernie**.


#### 1282.0


1282.


#### 1282.1


**Morthaghus *(Murtagh)*** et **Arthurus Mc Murchardi** interfecti in **Athlone** per **Pynquietum**.


#### 1283.0


1283.


#### 1283.1


**Galfridus Leothegarius episcopus **Ossoriensis**** secundus fundator ecclesie **Sancti Kenitii** **Kylkennie**, et primus fundator collegii de le comuni aula in **Kilkennia**, qui etiam dedit cameram suam cum manso eidem aulae comuni.


#### 1283.2


**Waterfordia** et **Dublin** casualiter per igne *combust:* et plures **Anglicani** interfecti fuerunt in **Ophaley**, ubi dominus **Theobaldus Butler** perdidit equos et familiam.


#### 1285.0


1285.


#### 1285.1


**Johannes Stamford** consecratur **archiepiscopus** **Dublin**.


#### 1285.2


**Dominus Theobaldus Butler** obiit in **Arcloo**.


#### 1286.0


1286.


#### 1286.1


**Geraldus fitz Morice** captus per **Hibernicos** in **Ophaly**, strages magna in **Rathod *(Ratoth)*** a qua dominus **Galfridus de Genevile** fugiendo, **Geraldus Dogoit** et **Radulphus Petit**, interfecti sunt.


#### 1290.0


1290.


#### 1290.1


**O Mulseaghlen rex **Midie**** interfectus per **Mc Coughlan** et **Wm Burg** devictus apud **Delon** per eundem **Mc Coughlan** cum diversis **Anglis** qui fuerunt interfecti cum eodem rege.


#### 1290.2


**Edwardus Baliol rex **Scotie**** fecit homagium **domino Veschy** **deputato** **Hibernie**, et magna **mortalitas** fuit in **Hibernia** hoc anno et ij annis sequentibus.


#### 1292.0


1292.


#### 1292.1


**Will*el*mus Veschi** **justiciarius** **Hibernie** habuit xv.am partem omnium bonorum temporalium sibi concessam ad onera guerrarum supportanda, et non multis diebus postea idem **Veschie** et **Johannes comes **Kildarie**** contenderunt, cujus causa fugit Veschie in **Franciam**, metu combati prefixi.


#### 1294.0


1294.


#### 1294.1


**Richardus Burgh comes **Ultonie**** et 
**Will*el*mus Burgh** capti sunt per


---

p.17


**Thomam comitem **Kildarie****, et comitatus **Conatie** fuit devastatus, et magna **fames** in **Hibernia**, adeo quod mensura de la cronock solvebatur pro VIIs. VId. *ster.* et **Calough O Conchur** cremavit recordas, rotulos, et rentalia comitatus in castro **Midie**, ut credo in castro de **Baliathroyn alias Thryme**.


#### 1295.0


1295.


#### 1295.1


**Willmus Dongsells**, **justiciarius** **Hibernie**, cujus tempore alterum fecerunt viagium ex **Hibernia** in **Scotiam Minorem**.


#### 1299.0


1299.


#### 1299.1


**Johannes Wogan miles **justiciarius** **Hibernie****, autoritate brevis ad eundum cum domino rege in **Scotiam**, monuit **Richardum de Burgo comitem **Ultonie****, **Galfridum de Genevile**, **Johannem fitz Thomas**, **Johannem fitz Moris**, **Theobaldum le Butler**, **dominum Thomam Verdon**, **dominum Petrum Bremingham**, **dominum Eustace de Power**, **dominum Hugonem de Prechell**, **Johannem de Coggan**, **Johannem de Barry**, **Walterum de *Lacy***, **Richardum de Exceter**, **Johannem Pipard**, **Walterum Limfaunt**, **Willmum Caddell**, **Johannem de Wale**, **Mauritium de Carrwe**, **Georgium de la Roch** ut essent in **Withwalovn** primo Martii.


#### 1301.0


1301.


#### 1301.1


**Lagenienses inferiores** insurrexerunt et devastaverunt comitatum circa castra de **Arcloo** et **Rathdown**, propter quod catalla eorum fuerunt confiscata ad usum domini regis.


#### 1303.0


1303.


#### 1303.1


Comes **Ultonie** cum **Richardo Burgo** et **Eustace Power** militibus intravit **Scotiam Minorem** et antequam recessit ex civitate dubbavit 34 milites. Vide supra.


#### 1304.0


1304.


#### 1304.1


Civitas **Dublin** casualiter cremata fuit in magna parte.


#### 1304.2


**Mortaghus O Conchur, rex de **Ophaly****, et **Calvaticus** ejus frater fuerunt interfecti in curia **Petri Bremyngham** apud **Carrig** in ***Carebria*** per **Jordanem Comyn** filium **Archiepiscopi Comyn**, vide supra. Bishops then did not mary, yet had children.


#### 1305.0


1305.


#### 1305.1


**Richardus Fleeringis *(Haveringis)* archiepiscopus **Dublin****.


#### 1305.2


Interemptio facta super **O Conchur** et familiam et conspiratores suos ubique, et in specie apud castrum de **Geishell** in **Ophaley** per **O Dempsy**.


#### 1306.0


1306.


#### 1306.1


**O Breyen rex **Tuamens**:** et **Downaldus Russe rex **Desmondie**** fuerunt interfecti per **M'Carty**; et magna strages contra **Petrum Butler**, dominum de le **Butler**.


#### 1306.2


**Bala Moor Eustace** fuit combusta et depredata per **Moardhas** et alios **Hibernicos**, et **Henricus Calf** generosus interfectus, magnaque guerra seu civilis factio in **Lagenia** et magna strages in **Glynfell**.




---

p.18


#### 1307.0


1307.


#### 1307.1


**Morchodus Ballach princeps **Lagenie****, decapitatus juxta **Merton** per **David Cantown militem**, et statim postea **Adam Dawn** interfectus, et plures **Anglicani** interfecti in **Conatia** per O Shiell, primo Maii, et **Hibernici** rebelles in **Ophaly** destruxerunt castellum de **Geishell**, et cremaverunt villam de **Leay**.


#### 1307.2


Rex Edwardus I. obiit 7o Julii.


#### 1308.0


1308.


#### 1308.1


***Edwardus* 2.** cepit regnare, secundum alios anno 1307, deinde fecit confiscari bona et proscribere terras et personas **Templariorum** juxta directionem 
Romani Pontificis.


#### 1308.2


**Willmus Mc Balthar** cremavit castrum de **Kennun** et villam de **Courcowley** cum interfectione hominum ibidem.


#### 1308.3


1308, *sexto* Junii. In **Glyndelory alias Glynmolowra**, **Johannes Wogan **justiciarius** **Hibernie**** in fugam coactus per **Hibernicos** rebelles ibidem, et **Johannes de Sancto Howgelyn**, **Johannes Northon**, **Johannes Brereton** et plures alii fuerunt interfecti. **Downlowan**, 
**Typper**, et plures alie villae cremate fuerunt per eosdem rebelles.


#### 1308.4


**Petrus de Gaveston** cum literis et autoritate a domino rege venit in **Hiberniam**, cui dominus rex concessit jura regalia in **Hibernia**, qui **Gaveston** interfecit **O Dempsies**, et edificavit diversa castra, pontes et pavimenta in **Hibernia**, et fuit revocatus in **Angliam** anno sequenti.


#### 1309.0


1309.


#### 1309.1


**Dominus Roger Mortimer** cum sua uxore, scilicet filia **Petri Genevile filii Galfredi Genevile, domini de **Midia****, applicuit in **Hiberniam** vigilia Sanctorum Simonis et Jude, et intravit possessionem segnorii de **Midia** jure uxoris sue quae fuit 
heres.


#### 1310.0


1310.


#### 1310.1


Parlamentum apud **Kildariam** tentum ubi **dominus Arnoldus le Power** fuit acquittus a morte **domini Johannis Boneville** per eum nuper interfecti, quia in defensione sua fecit et cetera.


#### 1311.0


1311.


#### 1311.1


Parlamentum apud **Kilkenniam** coram **Johanne Wogan justiciario**, ubi plures condite sunt leges, que modo non sunt in usu, et in eodem parlamento contenderunt **Rowlandus Joice** **primas** **Armachanus** et **Johannes a Leeckis archiepiscopus **Dublin****, quia **primas** **Dublin** inhibuit ei ne ipse **Armachanus** pontificalia in provincia **Lageniensium** coram eo ferri faciat, vide infra.


#### 1311.2


**Richardus Haveringis **Dublin** archiepiscopus** obiit, qui quinque annis tunc retroactis ratione sumpnii resignavit suam dignitatem.


#### 1311.3


**O Brienses** de **Gailgaish** ad numerum 600 fuerunt interfecti per **Richardum


---

p.19




de Clare justiciarium**, et **Johannes Mc Geoghegan** interemptus per **O Molmoy**, et 
**dominus O Brien** in **Thomond** per suos sequaces necatus.


#### 1312.0


1312.


#### 1312.1


**Dominus Edmundus de le Butler deputatus** **justiciarii Wogan** obsidebat **O Byrnes alias Branenses** in **Glyndelowra**, et cogebat eos paci domini regis se submittere, et anno sequenti die **Sancti Michaelis**, dominico videlicet die, creavit 30 milites apud **Dublin**, et die Lune proximo subjugavit **Branenses** et quietam fecit **Hiberniam**; adeo quod ab **Arcloo** ad **Clonemore** et inde ad **Caterlogh**, et inde ad **Cadelli** domum, et inde ad **Lymritium** solebat progredi cum iij. equestris tantum.


#### 1314.0


1314.


#### 1314.2


Hospitalierii milites **Sancti Johannis** **Jerusalem** fuerunt primo instituti in terra et possessionibus **Templariorum** per totam **Hiberniam**.


#### 1314.2


**Theobaldus Verdon justicarius **Hibernie**** 
constitutus, quo anno fuit rebellio universalis, **Hibernenses** in **Conatia**
**Ultonia** et **Midia** rebellaverunt sic quoque in **Momonia** et **Lagenia** et cetera. **Othoiles**, **Branenses** et **Moardhae** insurrexerunt cremantes et spoliantes a **Wickloo** usque ad **Athy**, non cessando donec 800 eorum fuerunt interfecti per deputatem **Hibernie**; et in **Conatia** juxta **Athenry** **Burgus** et **Bremyngham** interfecerunt **Fedelmicum O Conchur regem **Conatie**** et **O Kelly** in **Manny** cum xj. millibus de eorum confederatoribus.


#### 1314.3


**Edwardus de la Bruce** frater **Roberti regis 
**Scotie**** invadit **Hiberniam**, et in conducto suo habuit comites **de Murrey** et **de Menthothe**, cum domino **Johanne Styward**, **domino Johanne de Cambell**, **domino Thoma Randulph**, **Fergutio de Andressam**, **Johanne Wood**, **Johanne Bishett**, applicuerunt apud **Carrekfergus**, et conquisierunt **Ultoniam** et cremaverunt **Dundalk**, deinde venerunt ad **Castrum** **Knock** proponentes obsidere **Dublin**, sed **Dublinenses** totum suburbium cremaverunt, et pontem fregerunt. Rebelles mutaverunt consilium, manucapiendo senem **Tyrell** de **Castro** **Knock** cum uxore et herede, venerunt per patriam cremando **Naas**, **Tristeldermot**, **Cathirlogh**, **Gawran, alias Balla-Gawran**, **Callan** et **Cashill** et tenuerunt pasca juxta **Lymritium**, et ibidem dictus **Bruce** fecit se denominari monarcha **Hibernie**. Sed civibus **Lymritii** resistentibus, in regressu suo exercit*us* ejus famem ob defectum provisionis patientes, plures eorum in itinere moriebantur, et alii quamplures interfecti in **Westmeath** per **Butleros** et cetera; deinde venientes ad **Dundalk** dictus novus rex inter ceteros decollatus per carnificem de coherte **Dublin** (called **Mappas**) et tunc cessavit conquestus **Dublin**. Suddane clyming sudane falling, an high flood a low ebb. **Mappas** a jugler knocked him with ij. bullets in a bagg and killed him, et ipse


---

p.20



super eum occisus et terra dabatur a rege heredibus suis *quattuor* polles. The ambassadors of **Scotland** expected of the King of **England** some dispatch, and he, as is said, thought to have geven **Bruce** **Ulster**, the head of **Bruce** with other heads after a great feast for a banquet was laid before them, confusi surrexerunt et discesserunt. The **Scottis** were killed by **Brymyngham**, and he made erle of **Louth**, vide infra in **Alexander Bignor**.


#### 1315.0


1315 vel 1316.


#### 1315.1


**Johannes fitz Gerald primus comes **Kildarie**** 
obiit.


#### 1316.0


1316.


#### 1316.1


**Edmundus Butler justicarius **Hibernie****.


#### 1316.2


**Johannes Leech alias Aleecke **Dublin** archiepiscopus** prohibuit primati Armachano ne uteretur cruce, pallio aut aliis pontificalibus insigniis infra provinciam **Dublin**, quoniam Metropolitanus **Dublin** ut allegatum et probatum fuit non cognoscat aliquam superioritatem citra pontificem Romanum; vide supra.


#### 1316.3


1316 secundum alios 1334. **Milerus episcopus **Leighlen****, vel alius ejusdem nominis.


#### 1316.4


1316. **Robertus de la Bruce rex **Scotie**** 
applicuit in **Hibernia** apud **Knock (Carreg) Fergus**, ecclesiam ibidem spoliavit, cepit castrum per sursum redditum custodum, cibo eorum deficiente.


#### 1316.5


Die Lune post festum Omnium Sanctorum. De iisdem Scotis 300 in duplici armatura induti, ac 300 et supra in simplici armatura preter pedestres fuerunt per **Johannem Loggan** et **Hugonem Byssett** milites conducti/interfecti quere [In printed edition, 'conducti' is above line, 'interfecti' below line; both are joined by a curly closing bracket, followed by 'quere [sic]'.]

.


#### 1317.0


1317.


#### 1317.1


**Rogerus Mortymer dominus **Middie**** jure uxoris, fit **justiciarius** **Hibernie**.


#### 1317.2


Tempestas magna et validus ventus insurrexerunt, quae prostraverunt campanile **ecclesie Trinitatis** **Dublin** et domos quamplurimas et alia nocumenta.


#### 1317.3


Fames irrationabilis prevaluit adeo quod mensura tritici de le cronock continens 4or galones solvebatur pro xxiij. s.


#### 1318.0


1318.


#### 1318.1


**Roger Mortimer justiciarius** apud **Yoghill** applicans audivit quod **Edmundus Butler** interfecit plures **Hibernicos** rebelles apud **Tristledermot**, et juxta **Balyleathan alias Loaghan** de familiaribus **O Morochow**.


#### 1318.2


**Alexander Bignor archiepiscopus **Dublin****, qui erigens universitatem in **Dublin** creavit cancellarium et vice-cancellarium, ceterosque officiarios ad eandem requisitos, primo anno sue consecrationis, vide paulo infra. **Alexander Bignor** fit justicarius, in cujus gubernatione **Edwardus le Bruce** cum 2000 **Scotis** et


---

p.21




aliis combinatoribus suis fuerunt interfecti juxta **Dundalk**, per **Johannem Bremyngham comitem de **Louth****, campi generalem capitaneum, et tunc conquestus **Scotorum** cessavit, vide supra.


#### 1318.3


400 fuere interfecti in **Conatia** inter duos nobiles ejusdem patrie circa parvam terre portionem contendentes.


#### 1319.0


1319.


#### 1319.1


Pons de **Kilcullen** et anno sequenti pons **Leiglin** fuerunt edificate per **Mauritium** (**Johannem** alii dicunt episcopum **Kildarie** postea) Jacckis canonicum ecclesie **Kildarie** propriis expensis et licentia prius obtenta.


#### 1320.0


1320.


#### 1320.1


Academia **Dublin** cum privilegiis universitatis a **Johanne 22. papa** erecta, **Alexander Bignor archiepiscopus**, ejusdem fundator, creavit iij. doctores sacre theologie, videlicet **Willelmum Hardity**, **Henricum Cogie** et **Edmundum Bernardin**, et unum doctorem decretorum nomine **Richardum archdiaconum ecclesie **Dublin****, qui postea fuit **cancellarius** dicte universitatis et cetera; qui terminos suos tenuerunt et comendationes solemniter, quaequidem academia fuisse revocata non reperio, immo ut credo quod ipsa per negligentiam et propter 
defectum exhibitionis ruit.


#### 1320.2


**Johannes fitz John 2. comes **Kildarie**** fit 
**justiciarius** **Hibernie** et anno sequenti **Johannes Bremyngham comes de **Louth**** 
fuit creatus **justiciarius** **Hibernie**.


#### 1320.3


**Edmundus Butler** filius **Theobaldi le Butler** domini de **Carrig Rosscrea** apud **London** in vigilia exaltacionis Sancte Crucis, primus comes de **Pincernis**, qui vocabatur comes de **Balygawran** obiit, et vigilia **Sancti Martini** sepeliebatur apud **Balygawran** predictam.


#### 1322.0


1322.


#### 1322.1


**Dominus Johannes Darcy miles** fit 
**justiciarius** **Hibernie**, vide infra anno 1338.


#### 1322.2


1322. In **Kilkennia** vixit quedam domina nobilis nomine **Alicia Kettell** sortilega cum **Petronilla** et **Basilla** suis complicibus et asserebat ipsam habuisse (vide rotulam Episcopi **Ossoriensis**) colloquium omni nocte cum nephando spiritu nomine Robin Artisson, cui ipsa consuevit sacrificare in via regali, ix. gallos rubros et novem pavonum oculos et colligere purgamenta platee in **Kilkenia** post complet*orium* ad domum filii sui, dicendo Anglice hunc versum.


> 1. To the house of W*illia*m my sonne,
>   
> Hie all the welth of Kilkenie towne:
> 




et inveniebatur in camera ejus sacramentalis hostia et nomen diaboli in 
eadem scriptum, una cum tonna olei, cum quo (ut serva ejus fassa fuit) 
baculum ad


---

p.22




equitandum ubi voluerat ungebat, deinde ista nobilis ex favore fugere 
permissa fuit, ceteri vero consolii omnia ista fassi et combusti 
fuerunt.



#### 1326.0


1326.


#### 1326.1


**Edwardus 2.** obiit 25 Januarii, regnavit 18 annis, 6 mensibus et 15 diebus.


#### 1326.2


**Edwardus 3.** cepit regnare.


#### 1326.3


**Adam Niger** de familia de **O Tooles** in **Lagenia** spiritu satanico obsessus, negans incarnationem Christi, trinitatem personarum et resurrectionem carnis, dicensque scriptum esse fabulam et Mariam vite fuisse dissolute, sedemque Apostolicam errores premissos affirmasse et cetera, cremabatur in **Hogges Greene** juxta **Dublin**.


#### 1326.4


**Arthurus Mc Murchardi** et **Henricus Traherne** miles capti per **Butleros**.


#### 1327.0


1327.


#### 1327.1


**Rogerus Owtlaw prior de **Kylmaynam**** fit **justiciarius** **Hibernie**.


#### 1329.0


1329.


#### 1329.1


**Johannes Bremyngham comes de **Louth**** et 
**Talbot** de **Malaghide** cum pluribus aliis interfecti fuerunt apud **Balybregan** 
per inhabitantes patrie.


#### 1329.2


**Thomas Butler** et plures alii fuerunt interfecti per **Mc Geoghan** juxta **Molingar**.


#### 1329.3


**Adam Mc Gillamore** et alii **Hibernici** cremaverunt 80 innocentes in una ecclesia cum presbytero massam celebrante.


#### 1330.0


1330.


#### 1330.1


Cives burgenses **Wexfordie** interfecerunt 400 **Hibernicos** rebelles juxta rivulum de **Slayne**, et anno sequenti plures rebelles **Hibernici** fuerunt interfecti in **Kinsellay**.


#### 1331.0


1331.


#### 1331.1


Castra de **Fernes** et **Cowlaugh** et **Arcloo** capta fuerunt per **O Theothill** qui interfecit Anglicas garrisones ibidem, sed anno sequenti **Anglici** recuperarunt ea, sed castrum de **Bonrath alias Bonrathe** destruitur per **Hibernicos** de **Toamond**.


#### 1332.0


1332.


#### 1332.1


**Edwardus 3.** in bello de **Haldownhill** in **Scotia** interfecit de **Scotis** 8 comites, 900 milites et baronettes, 400 armigeros, et alios innumerabiles, cepit que **Berwick** cum aliis fortalitiis.


#### 1333.0


1333.


#### 1333.1


**Johannes Darcy **Hibernie** **justiciarius**** intravit **Scotiam** et interfecit 700 **Scotos** vocatos red shankes.


#### 1334.0


1334.


#### 1334.1


**Milerus episcopus **Leighlen****.


#### 1334.2


**Johannes episcopus **Leighlin**** cognomine Mulgan primus fundator quatuor capellanorum choralium ecclesie **Cathedralis **Sancti Lazeriani**** **Leighlen**, sepultus fuit juxta tumbam **ducis Gurmundi**, ad stallum *thesaurarii* ecclesie.




---

p.23


#### 1336.0


1336.


#### 1336.1


**Cynnus** et **Oldratus** legistae, Sanctus 
Rochus vel Riochus et S. Hawlerus theologi claruerunt.[In printed edition, 'Cynnus et Oldratus legistae' is above line, 'Sanctus Rochus vel Riochus et S. Hawlerus theologi' below line; both are joined by a curly closing bracket, followed by 'claruerunt'.]

.


#### 1336.2


In die **Sancti Laurentii** plures **Hibernici** 
rebelles interfecti fuerunt in **Conatia** per **Anglos** patrie.


#### 1337.0


1337.


#### 1337.1


**Johannes Charleton baro **Hibernie****. **justiciarius** cum 200 **Walensibus** venit in **Hiberniam**, erat maxima exactio eorum exclamata, unde **Thomas, episcopus **Herdfordiensis****, eligitur et venit **justiciarius** **Hibernie** 1338, et anno [*...*] **Johannes Darcy** assignatus fuit **justiciarius** **Hibernie** durante ejus vita.


#### 1339.0


1339.


#### 1339.1


**Edw. 3.** made clayme ad totum regnum **Francie** tanquam verum ejus dominium et hereditatem, et fecit se proclamari regem **Francie**.


#### 1339.2


**Thomas Minoth**/ **Johannes de Sancto Paulo** 
Archiepiscopus **Dublin**, quere quis prior, quis posterior.[In printed edition, 'Thomas Minoth' is above line, 'Johannes de Sancto Paulo' below line; both are joined by a curly closing bracket, followed by 'Archiepiscopus Dublin, quere quis prior, quis posterior'.]




#### 1340.0


1340.


#### 1340.1


**Edwardus 3.** ad sinistram persuasionem emulorum revocavit omnes libertates antea concessas, inde omnes tam Anglicani quam **Hibernici** tenentes scripserunt domino regi in **Angliam** querulando, et negaverunt interim venire ad parlamentum in **Dublin**.


#### 1348.0


1348.


#### 1348.1


Mortalitas magna et **pestilentia** in **Hibernia**.


#### 1348.2


Translatio **Sancti Fyntani abbatis patroni de **Clonenagh**** in episcopatu **Leighlen** per **Thomam de Sancto Leothegario episcopum **Midensim**** facta fuit, et si queratur quare examinatio miraculorum et autoritas canonizationis hujusmodi non comittebatur potius ordinario loci quam extraneo, resp*ondetur* quod **episcopus** **Leighlen** supplicavit Romano pontifici pro caussione translationis et canonizationis et cetera.


#### 1350.0


1350.


#### 1350.1


**Kymbrichus (ut puto Kenvrik Britanus) Sherman, major **Dublin****, magnus omnium ecclesiarum provintie benefactor, legavit in suo testamento 3000 markes, whether to the church or no quere.


#### 1355.0


1355.


#### 1355.1


**Mauritius fitz Gerald comes **Desmond****, 
durante vita **justiciarius** **Hibernie**, obiit, et **Thomas Rocksey miles**
**justiciarius** succedit.


#### 1357.0


1357.


#### 1357.1


Rex **Anglie** plures habuit ex **Hibernia**, pugnatur versus **Wallenses**, et in **Francia** apud (**Crostea**), ubi obtinuit victoriam famosam et cepit castra in triumpho.


#### 1357.2


**Mauritius fitz Thomas comes **Kildarie**** **justiciarius** secundum **Campion** et **Stanihurst** anno 1357 habuit sibi per literas patentes domini regis in feodo annuali 500 libras ratione sui officii, ea condicione quod ipse haberet secum in quolibet


---

p.24




bello 20 equos magnos cum equestris electis, quorum ipsemet sit unus. Historiographi putant hunc numerum fore ordinarium pro quolibet **deputato** et justiciario guerris et rebellionibus persistere.


#### 1361.0


1361.


#### 1361.1


**Leonellus filius *Edw.* 3. dux de **Clarence** et comes **Ultonie****, **justiciarius** **Hibernie** transtulit scaccarium domini regis ad **Catherlough**, et disbursavit 500 libras in restaurationem parietum ville, et in autumno revocatus fuit in **Angliam**.


#### 1366.0


1366.


#### 1366.1


**Thomas Carrew alias Grew** rejectus fuit (et fugit in **Angliam**) per **Mc Murchardum** a dominio et dominico suo in Baronia de **Idrona** quam tenebat de **Margareta alias Matilda cometissa **Norfolcie**** in 
comitatu **Catherlough** vide infra.


#### 1366.2


Sed postea tempore **Henrici Sydney deputati** quidam senior **Petrus Carew miles** inveniens rotulam evidentiarum et cetera venit et invenit et cetera, unde compulsi componere et cetera, **Sidney** went to hauke et cetera.


#### 1369.0


1369.


#### 1369.1


Anno *Edw.* 3. 44. Parlamentum in **Kilkennia** tentum coram **Willelmo de Windesor justiciario** in quo concessum est domino regi 3000 libras pro subsidio ad guerras, et hoc anno inhibuit **rex Edwardus 3.** peti, colligi aut solvi denarium Petri ad usum ecclesie Romane.


#### 1370.0


1370.


#### 1370.1


**Pestilentia** magna in **Hibernia** adeo quod 
propter imensitatem mortalitatis vocabatur ab antiquis tertia **Hibernie** **pestilentia**.


#### 1372.0


1372.


#### 1372.1


**Patritius Freigney miles senescallus **Lagenie****, ut in registro ecclesie **Leighlen** reperitur, in itinere suo apud **Caterlough**, **Kilkenniam** et **Wexfordiam** anno 45 *Edward.* 3. tenuit curiam libertatis autoritatis domini regis, et fecit inquisitionem de chartis, usibus, libertatibus, et liberis consuetudinibus burgensium et libere tenentium **Lagenie**, copiamque sue inquisitionis decrevit concedi omnibus membris corporationum, qui suas chartas aut rescriptas aut escript perdiderunt in ultimis comotionibus et cetera, si peterent et cetera. He made fayre wether with a vile reach, sed anno sequenti rex propter suas exactiones et cetera, et eo quod deposuit plures injuste ex suis dominiis et libere tenementis revocavit autoritatem, cum incarceravit fecit eum facere restitutionem probantibus et juste accusantibus et imposuit super eum mulctam pecuniariam.


#### 1373.0


1373.


#### 1373.1


**Johannes Hussey baro de **Galtrym****, **Johannes Richard vicecomes de **Midia**** fuerunt interfecti in **Kynealiaagh**.


#### 1373.2


**Galfridus le Wale** interfecit **Donatum Mc Murchard** juxta **Caterlaugh**.


#### 1373.3


**Richardus Bookum episcopus **Leighlen****.




---

p.25


#### 1376.0


1376.


#### 1376.1


**Edwardus 3.** obiit. **Richardus 2.** succedit.


#### 1381.0


1381.


#### 1381.1


**Edmundus Mortimer comes **Marchiarum** et **Ultonie**** (qui desponsavit **Philippam** filiam et solam heredem **Leonelli ducis de **Clarence****) obiit in civitate **Cork**.


#### 1383.0


1383.


#### 1383.1


**Philippus de Courtney** **justiciarius** post mortem **Mortimeri**.


#### 1385.0


1385.


#### 1385.1


**Ricardus Vere marques **Dublin**** creatus est dux **Hibernie** durante vita, et omnia precepta et brevia regalia sub teste et nomine ejus emanaverunt.


#### 1385.2


**Pestilentia** et mortalitas magna vocabatur 4 
**pestilentia**.


#### 1390.0


1390.


#### 1390.1


**Robertus Wadby (Weekeford) frater Augustinianus **archiepiscopus** **Dublin****.


#### 1394.0


1394.


#### 1394.1


**Richardus 2.** pro morte regine sue vexatus venit in **Hiberniam** circa festum Michaelis, et revertebatur circa carnisprivii festum, secundum alios secundum festum **Sancti Johannis**, ad ejus detrimentum, nam **Hereford** et **Lancastrie** et comitatus **Eboraci** insurrexerunt ubi plures **Hibernici** ceciderunt in bellis ex utraque parte pugnantes.


#### 1397.0


1397.


#### 1397.1


**Rogerus Mortimer miles **justiciarius** **Hibernie****, qui jure uxoris sue fuit comes **Marchiarum** et **Ultonie**, fuit cum pluribus aliis interfectus per **O Nowlan**, **O Byrne**, **Mc David More**, **Mortagh Mc Loaghlen** capitaneum turbariorum **Mc Murchardi** et alios suos combinatores apud **Calleston** ab antiquis vocatum **Ardabother**, cujus mater ejus dedit ij. calices, unum in **Misheill**, alterum in **Garghill**, ut haberet illum vel vivum vel mortuum, ad transmittendum illum in **Angliam**.


#### 1397.2


**Richardus Northalis frater carmelitanus** translatus ab alia sede in **Dublin** archiepiscopatum.


#### 1398.0


1398.


#### 1398.1


**Richardus 2. rex** vindicaturus mortem **Rogeri Mortimer** sui **deputati** venit in **Hiberniam** cum 200 navibus apud **Waterfordiam**; et eo tempore coegit **O Nowlan** vi. homines de majori natu sue patrie domino regi dare, ad voluntatem et electionem domini regis annuatim per xi. annos, et 2000 vaccas juvenes quolibet anno ad 7 annos.


#### 1398.2


Post adventum domini regis **Jenicho de Arthois Gaiscoyn** interfecit 200 **Hibernicos** in comitatu **Kildarie**, et **Dublinenses** proximo die mane interfecerunt 40 inimicos, et ceperunt 33, quos captivos secum duxerunt ad **Dublin**.


#### 1398.3


In veteri (old) **Leighlen** fuere 86 burgesses.


#### 1401.0


1401.


#### 1401.1


**Johannes Drack maior **Dublin**** cum suis 
civibus interfecit 400 de **Hibernicis** inimicis juxta **Bree**.




---

p.26


#### 1401.2


Primitiae fuerunt hoc anno assignatae per pontificem Romanum adeo stricte, quod nullus presbyter ad beneficium admittebatur, excepto quod hos fructus prius solveret.


#### 1401.3


**Thomas dominus de Lancaster** filius et locum tenens **domini regis Henrici 4.** in **Hibernia** tenuit parlamentum apud **Rosse**, in quo habuit visum cartarum et patentium horum, qui a domino rege tenuerunt in capite, et inde revertebatur in **Angliam**.


#### 1403.0


1403.


#### 1403.1


**Jacobus le Butler comes **Ormonie****, **justiciarius** domini regis in **Hibernia**.


#### 1404.0


1404.


#### 1404.1


Charta libertatis **Hibernie** et statuta **Kilkennie** fuerunt confirmata autoritate parlamenti coram comite **Ormonie** justiciario **Hibernie**, die **Sancti Vitalis martyris**; et exercitus domini regis interfecerunt 100 de **Hibernicis** inimicis juxta **Kilcaa**, clero pro bono successu pugnantium in processione orante apud **Tristeldermot**.


#### 1405.0


1405.


#### 1405.1


**Jacobus Buteler comes **Ormonie** **justiciarius**
**Hibernie**** obiit apud **Bellyngan alias Belligard**, ut credo.


#### 1407.0


1407.


#### 1407.1


**Jacobus Butler** filius predicti **comitis** premortui fuit **justiciarius** **Hibernie**.


#### 1407.2


**Hugo Mc Adam Mc Gillamor** falsus et ethnicus Hibernicus inimicus in **Ultonia** cremavit et destruxit 40 ecclesias, et manucaptum habuit **Patritium Savadg**, quem crudeliter tractavit, unde vulgo appellabatur [*...*] et iste **Hugo McAdam McGillamor** non diu postea petere beneficium sanctuarii compulsus, sed in ecclesia seu monasterio minorum apud **Knockfergus** sine misericordia et reverentia fuit interfectus, que ipse et pater antea cremaverant.


#### 1408.0


1408.


#### 1408.1


**Stephanus Scrope** fuit **deputatus** **Thome Lancaster** locum tenentis domini regis in **Hibernia**, et obiit apud **Casteldermot**.


#### 1408.2


**Comes **Ormonie****, **comes **Desmonie****, et prior de **Kilmaynam** cum aliis generosis et **capitaneis** invadentes terram **Mc Murchardi** pugnaverunt in vicem in campo, primo **Hibernici** inimici ferociter resistere proposuerunt, et animose pugnaverunt, sed demum eis devictis comes **Ormonie** prosequendo viriliter in fine cepit **O Nowlan** cum duobus filiis suis, et pluribus aliis, quos duxit captivos ad dominum **deputatum**. But these **O Nowlans** were afterwards quite extirped.


#### 1408.2


**O Carvell** et 800 de familia et confederatoribus suis fuerunt interfecti per **comitem **Ormonie**** et alios **Anglos** in suo conducto apud **Callan**, et sol dicebatur


---

p.27




expectasse post naturale tempus et occasum sui, et lucens donec **Angli** equitarunt vj. milia in prosecutione inimicorum suorum.


#### 1409.0


1409.


#### 1409.1


Civitas **Dublin** recepit primo gladium regale ab **Henrico 4.** et tunc creatus est maior cum antea gubernabatur per prepositum, in cujus probatione **Dublinenses** tenent adhuc suum antiquum sigillum cum superscriptione prepositure, et inde pluribus annis tunc sequentibus regebatur illa civitas per maiorem et ij. balivos, sed illos balivos **Edward. 6.** mutavit in ij. vicecomites.


#### 1410.0


1410.


#### 1410.1


Comunitas **Anglie** petiit **Henricum 4. regem** ut auferret temporalitatem a spiritualibus (which trobled **England** and **Ireland**, and especially the clergie of both landes, that they called all their wittes together to defend them selfes) allegando quod terra regni **Anglie** inordinate et negligenter per ecclesiasticos devastata, sufficeret pro creatione et sustentacione xv. comitum, 6200 armigerum, et 100 domibus elemosinariis et hospitalibus, atque exhiberent domino regi annuatim preterea ad sumptus guerrarum supportandos 20 millia librarum, ita quod quilibet comes haberet in feodo annuali seu redditu annuo 3000 marchas, quilibet miles 100 marchas, et 4 carrucatas terre arabilis, quilibet armiger 40 marchas, cum ij. carrucatis terre arabilis, et quodlibet hospitale 100 marchas; sed cleri obstiterunt. **Lanquet** vel **Cooper**.


#### 1410.2


**Fames** magna in **Hibernia**.


#### 1410.3


Prior de **Kilmaynam** **justiciarius** **Hibernie** duxit secum 1500 turbarios, et fecit viagium in patriam **Byrnensium**, ubi plures amisit cum **Johanne Dorpatrik** generoso, quorum turbariorum quidam revolverunt ad inimicos.


#### 1412.0


1412.


#### 1412.1


**Henricus 4.** obiit. **Henricus 5.** succedit.


#### 1412.2


**O Conchur** de **Ophaly** multum nocuit **Midie**, et captivavit 160 **Anglos** una die.


#### 1413.0


1413.


#### 1413.1


**Johannes Stanley** miles fit **justiciarius** **Hibernie**.


#### 1414.0


1414.


#### 1414.1


**Dominus Johannes Talbot de **Sheffield**** creatus locum tenens **Hibernie**, et Robertus Talbot brevi obiit, qui suis expensis fabricari fecit parietes ville **Kilkennie**.


#### 1414.2


**Archiepiscopus** **Dublin** fuit **justiciarius** **Hibernie**, cujus tempore ipso episcopo et clero ad ejus mandatum in processione apud **Tristeldermot**, pro statu et bono successu, et celeri expeditione pugnantium contra **Hibernicos** orantibus, 3000 **Hibernici** inimici fuere interfecti juxta **Kilcaa**, per **comitem **Ormonie**** generalem armi et exercitus et suos **Anglicos**. As his father did a litle before.


#### 1414.3


**Thomas episcopus **Leighlen** cognomine Fleminge frater ordinis Augustiniani**,


---

p.28




in **ecclesia Sancti Trinitatis Dublin** recepit ex parte domini regis homagium et fidelitatem ab **Hugone O Neil** in presentia episcopi ***Ossor:*** quo tempore ipse **Willmus** translatus fuit in ***Cassiliens:*** *archiepiscop:* qui **Thomas** obiit **Leighlen** et juxta voluntatem suam sepultus fuit in **Kilkennia** apud ordinem professionis sue.


#### 1415.0


1415.


#### 1415.1


**Patritius Borrett episcopus **Fernensis**** 
obiit, et sepultus est **Kenlis**.


#### 1416.0


1416.


#### 1416.1


**Stephanus Fleming **archiepiscopus** **Armach**** 
obiit.


#### 1418.0


1418.


#### 1418.1


Consilium regale apud villam de **Naas**
**Lagenie**, ubi concluserunt prosequere **Hibernicos** inimicos.


#### 1419.0


1419.


#### 1419.1


4 Idus Maii. **Donatus More Cavenagh Mc Murchardus principalis omnium **Lageniensium** capitaneus**, quem nominarunt regem **Lagenie**, fuit captus et in **Angliam** missus, ubi per 7 annos fuit balinatus apud fabrum aurarium in Turre, et postea dimissus et destinatus in **Hiberniam** sub certa conditione. Of **Balachillchovan** that scept of **Cavenaghs** of the house of **Mc Morrgh** toke their names.


#### 1419.2


**Thomas le Butler germanus comitis **Ormonie**** (qui vocabatur **Thomas claudus**) ivit in **Franciam** jussu regis **Anglie**, habens in suo conductu 100 equites **Hibernicos** ad suam electionem, qui applicans in **Franciam** versus **Roone** cremavit patriam in suo itinere, et depredavit et predam tam magnam duxit in campum regis erga noctem, adeo quod ubi solvebant mane xs. pro [*gap: extent: two or three words*] habuerunt quarterium seu armum bovile pro 1s. de nocte, sed post captionem civitatis licet ipse prius intravit secundum quosdam ibi obiit, secundum alios in Anglia per venenum mulieris, post reversum.


#### 1420.0


1420.


#### 1420.1


**Jacobus le Butler comes **Ormonie****, locum tenens domini regis in **Hibernia**, occidit plures de familia et terribili exercitu **Ymoardha** juxta **Athy**, et sol preter naturam dicitur et cronicis scribitur stetisse per spacium iij. horarum ita ad mirationem plurium et miraculose, et donec comes vicit hostes in marisco rubeo (redd foord) alias prato rufo de **Athy**, nec grunna alias quackmyre ibi obsistit, quin equites justiciarii currebant in prosecutione hostium sicut hostes.


#### 1420.2


[lt ]!-check--[gt ]**Arthurus more Mc Murcharda**, ferax rebellis, cujus potentie omnes **Lagenienses** resistere non potuerunt, fuit demum per eundem **comitem **Ormonie**** devictus, et mitigatus adeo quod sese et suos confederatores gracie regali submisit.


#### 1420.3


**Thomas comes **Desmond** et **Momonie**** obiit, et sepultus in civitate **Rothmagens**: vide infra in hac pagina annum verum.




---

p.29


#### 1420.4


Comes **Ormonie** **deputatus** regis domavit **O Bryens** de **Gailgaish**, **Burgos** et **Mc Bannanos** in campo seu bellico conflictu juxta **Sagelome**, deinde **Moardhos**, **O Geoghagan**, **Mc Mahonn** et omnes **Hibernicos** inimicos in tribus mensibus, et durante hoc itinere et viagio ipse **deputatus** fecit ubique clerum cujuslibet patrie esse in solemni processione, bis qualibet hebdomada, orantes pro bono et felici statu ejusdem nobilis et aliorum pugnatorum contra dictos suos adversarios ceterosque reipublice dissipatores, utinam clerus hujus temporis Deum sic precibus devote invocarent, ut pugnatores crederent victoriam a Deo obtineri.


#### 1421.0


1421.


#### 1421.1


**Henricus 5.** obiit. **Henricus 6.** succedit.


#### 1421.2


**Richardus O Hiden archiepiscopus **Cassiliensis**** accusatus in parlamento per **Johannem Geest episcopum **Lismor** et **Waterfordie**** super 30 articulis, quorum primus quod noluit promovere aliquem Anglicum ad beneficium in sua diocesi. Alius articulus quod sic consuluit alios comprovinciales episcopos et cetera.


#### 1421.3


**Henricus 6.** cepit regnare ultimo Augusti, et mortuo **Delphino Carolo rege **Francorum****, fuit proclamatus rex **Francie**.


#### 1421.4


**Johannes Swanige** **primas** **Armachanus** obiit.


#### 1421.5


**Mc Mahonn** multum nocuit **Midie** et **Anglicanis** cremando, spoliando, necando, et depredando, donec fuerat devictus per **deputatum** et **Dublinenses**, qui animose et feliciter pugnaverunt.


#### 1433.0


1433 *vide 1419*.


#### 1433.1


**Thomas claudus le Butler** miles **deputatus** domini regis in **Hibernia**, obiit in obsidio civitatis **Roone** in **Francia**.


#### 1438.0


1438.


#### 1438.1


**Thomas Crawley archiepiscopus **Dublin**** revertens a consilio **Basil** autoritate **Eugenii pape**, in **Anglia** obiit.


#### 1439.0


1439.


#### 1439.1


**Richardus Talbot archiepiscopus **Dublin****.


#### 1445.0


1445.


#### 1445.1


**Henricus 6. rex **Anglie**** (comite **Suffolchie** suadente) duxit in uxorem **Margaretam filiam regis **Sicilie****, et repudiavit **filiam comitis **Arminachie****, cum qua primo contraxerat, cujus causa amisit **Normanniam**, et sui subjecti insurrexerunt, et finaliter depositus cum sua regina et filio primogenito fugiebat.


#### 1448.0


1448.


#### 1448.1


Duces ***Eboren:*** et **Lancaster** contenderunt circa coronam, ita quod quilibet eorum prosuo interesse excitarunt principales **Anglos** in **Hibernia** suos amicos respective, qui **Anglici** ceciderant in bello de **Wakinfield**, et sequenti anno in bello de le **Mortimers cross** in **Wallia**, quo **Hibernici** in absentia **Anglorum** assumentes vires et opportunitatem insurrexerunt in **Hibernia**, et obsiderunt ubique castra et fortalicia, que tenuerunt usque ad tempora **Henrici 7** et **8.**


#### 1449.0


1449.


#### 1449.1


**Dux **Eboracensis**** venit in **Hiberniam** cum magno scutto et exercitu


---

p.30




ad pacificandos **Hibernicos** et rebelles, qui nihil estimabile potuit agere, nec parum concludere, nec **Hibernicos** vincere.


#### 1458.0


1458.


#### 1458.1


**Mac Geoghagan** cremavit **Rathmore** cum pluribus villis et villagiis in **Midia**, que est hereditas **Plantagenet ducis **Eboracencis****.


#### 1459.0


1459.


#### 1459.1


**Dux **Eboracensis**** comes **Sarum**, et comes **Warwik** bellaverunt contra regem **Anglie** juxta **London** in **Bloore Heath** sed in fine dux fugit in **Hiberniam**, alii in **Caliciam**. Et anno sequenti (1460) reversus est in **Angliam** et fecit clamen in coronam in parlamento; deinde fuit interfectus cum filio suo **comite **Rutland**** apud **Wakefield** per **Margaretam reginam** et suum exercitum, et sic rex liberatur e carcere.


#### 1459.2


**Edward comes **Marchiarum**** et heres ducis 
**Eboracensis** debellavit contra **Henricum 6.** et post aliquam interfectionem rex 
fugit cum regina et filio, cum regnasset 38 annos, ad ducem de Angeo, et 
iste Edwardus cepit regnare nomine **Edwardus 4.** et regit 22 annis.


#### 1462.0


1462.


#### 1462.1


**Thomas fitz John de **Geraldinis**** qui primo oneravit comitatum **Waterfordie**, **Corken**, **Kery**, et **Limrici** impositionibus Hibernicalibus, scilicet mercuniis, carragiis, pedagiis, et customis obiit, alii tamen dicunt quod ipse comes propter has exactiones et outragias contra pacem domini Regis, et leges **Hibernie** fuit decapitatus apud **Drogheda** per **Johannem Tiptot comitem **Worcestrie** deputatum domini Regis** in terra **Hibernie**. Vide pedegrew **Desmondie** quod non fuit comes, pater tum vivebat et cetera. Usurping upon his father, and going to **Tredaff**, he gave him his curse, and said, thou shalt have an ill end.


#### 1462.2


**Milo Roch episcopus **Leighlen**** **Momonie** natus inter bardos numeratur pro omnibus instrumentis musice et rythmis.


#### 1464.0


1464.


#### 1464.1


**Paulus 2. papa** creatus, avarus, crudelis, injuriosus, immisericors, rudis nec doctus, nec aliquo favore voluit prosequi doctos.


#### 1469.0


1469 *1487*.


#### 1469.1


**Lambertus nomine Peter Perchia de Warwik** coronatus rex in ecclesia Sancte Trinitatis **Dublin**, cujus causa bellum de **Storke vulgarite Martin Swarthsfield**, in quo **Thomas fitz Morice de **Geraldinis**** capitaneus **Hibernicorum** cecidit cum **comite **Lincolnie**** et pluribus nobilibus —**Lanquet**.


#### 1470.0


1470.


#### 1470.1


**Rowlandus Eustace **deputatus** **Hibernie**** obiit.


#### 1471.0


1471.


#### 1471.1


**Thomas fitz Morice comes **Kildarie**** **justiciarius** ***Hibernie*** anno Edwardi 4ti dicitur concessisse privilegium seu licentiam de la mortmayne ecclesie **Sancti Kenitii** **Kilkennie** et collegio vicar choralium ibidem.


#### 1471.2


**Henricus 6.** per **ducem **Clarencie****, comites **Warwick**, ****Penbrochie**** et **Oxford**


---

p.31




dicitur restitutus, et **Edwardum 4.** fugisse in **Flandriam** ad ducem **Burgundie** —**Lanquet**.


#### 1471.3


Sed postea **Edward iste rex** ratione sui fratris ducis Clarencie venit ad **London** et cepit **Henricum regem** in palatio episcopi reginam et **Edwardum principem**, quem interfecit, et regnavit **rex Henricus** in turre per tempus et tunc executus sepeliebatur in **Schordich**.


#### 1473.0


1473.


#### 1473.1


**David episcopus **Ossoriensis**** scribitur habuisse autoritatem **domini regis Edward 4.** per literas suas patentes ad excommunicandos et censurandos omnes contradicentes et injuriantes vicarios de la communi aula.


#### 1475.0


1475.


#### 1475.1


**Edward 4.** navigavit ad ducem **Burgundie**, qui 
habuit secum in exercitu suo 1000 **Hibernicos**, et antequam venerunt rex **Francie** dedit **regi Edwardo** pro bono pacis 75000 nobilia auri puri, et promisit tantum ei annuatim pro 7 annis.


#### 1476.0


1476.


#### 1471.1


**Donaldus Fuscus Kavenagh** qui se vocari regem **Lagenie** permisit obiit. alii anno 1478.


#### 1483.0


1483.


#### 1483.1


**Edward
4.** obiit, relinquens **Edwardum principem** et **Richardum ducem ***Eboracen:***** et **Edward princeps** cepit regnare sub nomine Edward 5. et obiit eodem anno.


#### 1483.2


**Richardus dux Glocestrie** avunculus cepit regnare et regnavit nomine Richard 3. et regnavit 2 annis, interfectus ab **Henrico 7**.


#### 1485.0


1485.


#### 1485.1


**Henricus comes Richmond nomine *Henric* 7.** regnavit et duxit in uxorem **Elizabetham filiam Edwardi 4.** et sic domus ***Eboracen:*** et ***Lancastren:*** unitae et cetera.


#### 1494.0


1494.


#### 1494.1


**Edwardus Poynyngis **deputatus** domini regis** in **Hibernia** plura fecit statuta, et leges renovavit, et ordinationes regni in pristinum cum sua charta confirmavit.


#### 1494.2


Huc usque dicit autor meus **Thaddeus**; **Nicolaus episcopus** in libro flavo **Leighlen** Annotationes fecit.


#### 1494.3


**Octavius **Armachanus**** totius **Hibernie** **primas** addmittens appellationem **David Curreyn** decani et capituli **Leighlen**, a sede metropolitica factam, inhibuit episcopo **Leighlen** ne quod attemptaret in prejudicium decani et capituli appellantium circa suas distributiones quotidianas; per sententie instrumentum apparet episcopum comparuisse vigore inhibitionis et citationis emanate in consistorio generali crastino **Sancti Patricii** in cancello divi Laurentii, presente **Willelmo priore ****Sancti Johannis baptiste**** de **Drogheda**** *tertio* Novembris anno predicto coram eodem primate in presentia domini **Radulphi prioris domus Hospitalis** aut


---

p.32


**ecclesie **Sancti Laurentii**** extra muros ville predicte, reverandi **Johannis episcopi **Midensis****, **Thome Lang clerici**, autoritate apostolica imperiali notarii puplici curie predicte consistorie registrarii et scribe principalis, atque **Thome Moye** apparitoris et preconis, **Nicolai prebendarii de **Hillard**** economi syndinque et prolocutoris capituli atque procuratoris contra eundem episcopum in hac parte destinat.


#### 1494.4


Vide antea quomodo **Archiepiscopus** **Dublin** in 
parlamento **Kilkennie** inhibet **Armachano** ne ferret ante se in sua provincia aliqua episcopalia insignia. Notwithstanding out of the province and in province he was above him.


#### 1494.5


**Nicholaus Magwyr episcopus **Leighlen**** vulgariter nuncupatur **Mc Syr Moris** in **Odrona** **Lagenie** in **Hibernia** natus apud **Tulmogiman**, Sacerdotis spurius, **Thaddeus Dowlinge** comendes him for hospitalitie and the number of cowes that he grased without losse (so well was he beloved) upon the woodes and mountaines of **Knockbrannen**, **Cumnabally**, **Aghcarew**, **Ballycarew** and **Moilglas**, but **Thomas Brown** his chaplen who also wrote his lif, reporteth that he studied in **Oxford**, although it was but ii. yeres and 3 months, yet he profitted so much in logik, philosophie, the seven liberall sciences and divinitie that in his latter days he seemed to excell, he was made prebendarie of **Hillard**, where he preached and delivered great learninge with no lesse reverence, beinge in favor with the King and nobilitie of **Lenister**, who together with the deane and chapter elected him b*ishop* of **Leighlen** to succeed **Milo** then lately deceased. This **Nicolas** had obtained of the bishop of Rome litres of provision and was consecrated b*ishop* being but 30 years of age, to the great losse of the church he died anno 1512 having begonne many learned workes and death preventing his purpose he cold not finish any savinge one 
cronicle sumariely by him collected and is found in the handes of many in written hand laten, and so farre **Dowlinge** and **Browne**.


#### 1495.0


1495.


#### 1495.1


Maxima perturbatio in **Anglia** et **Hibernia** ex parte **Perkin Warbeck** qui se nominavit **Richardum Eboracensem filium Edwardi regis**.


#### 1496.0


1496.


#### 1496.1


**Thomas comes Surrey** et **dominus Nevell** cum magno exercitu fuerunt missi huc in **Scotiam Majorem** ab **Henrico 7.** qui **Scoticos** domuerunt.


#### 1497.0


1497.


#### 1497.1


**Katerina filia Ferdinandi regis **Hispanie**** fecit nupta **principi Arthuro primogenito Henrici 7.** qui in pasce sequenti obiit.


#### 1500.0


1500.


#### 1500.1


**Margareta filia Henrici 7.** nupta fuit **Jacobo regi **Scotie****.




---

p.33


#### 1501.0


1501.


#### 1501.1


**Henricus filius Henrici 7.** constitutus dux **Eborum**, locum tenens domini regis in **Hibernia**, qui postea fuit **Henricus 8.**


#### 1503.0


1503.


#### 1501.1


**Elizabeth regina** obiit in puerperio in turre **London**.


#### 1504.0


1504.


#### 1504.1


Bellum de **Knocktoa** per **Geraldum comitem **Kildarie**, deputatum **Henrici ducis Eboracum**** locum tenentis **Hibernie**, contra **Willelmum Burg de Bellathclare** in **Conacia**, **O Bryen**, **Mc Morogh**, **O Carvell**, et alios boreales. Iste collis de **Knocto** situatus est vi. milliaria a **Galway** et ij milliaria a **Ballaghclare**; de quo versus.


#### 1506.0


1506.


#### 1506.1


**Maria filia regis Henrici 7.** nupta fuit **Carolo archduci Austrie** et principi **Castelle**, et anno sequenti rex **Castelle** obiit.


#### 1508.0


1508.


#### 1508.1


**Henricus 8.** anno etatis 18 cepit 
regnare.


#### 1509.0


1509.


#### 1509.1


**Geraldus comes **Kildarie**** **ordinis garterii** miles qui **Hibernicos** gubernavit 33 annos obiit, et sepultus in capella beate 
Marie infra **ecclesiam Trinitatis** **Dublin**.


#### 1510.0


1510.


#### 1510.1


**Walterus archiepiscopus** fuit **cancellarius** et **justiciarius** **Hibernie**, obiit hoc anno, sic **Nicolaus** scribit.


#### 1510.2


Huc usque **Nicolaus **Leighlen****. Sic **Thaddeus** (vide supra) scribitur.


#### 1512.0


1512.


#### 1512.1


**Maurus Nemorosus (Mauritius Woodkerne) rex 
**Lagenie**** obiit. **Willmus archiepiscopus **Dublin****.


#### 1514.0


1514.


#### 1514.1


Insurrectio magna in **Hibernia**.


#### 1514.2


**Maria soror regis **Anglie**** nupta fuit **Ludovico **Francorum** regi**.


#### 1514.3


**Petrus Butler Mc James**, interfecit **Jacobum nigrum (Duff) le Butler bastardum comitis le Gawran** inter **Donmore** et **Kilkenniam**, secundum alios anno 1497.


#### 1515.0


1515.


#### 1515.1


**Maria regina de Suffolk** nupta fuit **duci de Suffolk**.


#### 1515.2


**Jacobus Butler comes **Ormonie**** insultabatur per cives **Dublin** in manerio archiepiscopi de la *Sanct* Sepulchres, unde legati sunt destinati a Romano pontifice ad puniendam presumptuosam violationem sanctuarii **Sancti Patricii** **Dublin**.


#### 1515.3


**Thomes Halser Anglus **Leighlen** episcopus**, utriusque juris doctor, protonotarius apostolicus, pro **Anglia** **Scotia** et **Hibernia** in basilica apostolorum de urbe *Rom:* cujus vicar generalis erat abbas de **Duysk** nomine **Carolus Cavenagh **cancellarius** ecclesie **Leighlen**** per octo annos, et episcopo mortuo custos fuit spiritualitatis per vi. annos.




---

p.34


#### 1517.0


1517.


#### 1517.1


Magnum gelu in **Hibernia** et **Anglia** adeo quod currus equorum iverunt super flumen de **Tamesey** *in* **Anglia** et super rivos **Hibernie**.


#### 1519.0


1519.


#### 1519.1


**Thomas Howard comes Surrey** qui postea fuit creatus dux **Norfolchie** cum 200 de
regis roba venit locum tenens in **Hiberniam**, et quia magna perturbatio fuit in **Hibernia** **comes **Kildarie**** fuit officio **deputati** depositus; et iste **comes **Surrey**** reduxit **comitem **Desmondie**** et alios **Hibernicos** ad bonam conformitatem, deinde ipse **Surrey** cum multitudine **Hibernicorum** transnavigavit in **Franciam**, cujus quidem recessum habitantes (**Angli**) **Hibernie** querulabant multum propter ejus integritatem, bonam naturam, et modum gubernationis, secundum alios venit anno 1521 et recessit anno 1523.


#### 1522.0


1522.


#### 1522.1


**Geraldus Kevanagh Mc Mochardus**, qui se fecit vocari regem **Lagenie** et ducem **Laginensium** obiit, sepultus **Leighlen**.


#### 1522.2


**Mauritius episcopus **Leighlen** cognominatus 
Deoran** in **Laxia** jam vocata **Queenes County** in **Leinster** 
frater minorum professus, in Theologia controversia et conversatione eloquentissimus predicator, castus a nativitate, episcopatum regebat annum cum dimido *et* ij mensibus; interfectus fuit per **Maurum (Mauritium) Cavenagh archdiaconum** dioceseos inter **Kilneyn** et **Cloaghruish**, eo quod dicti **archdiaconi** et aliorum redarguit perversitatem et corrigere proposuit. Iste **episcopus** in jocando ejus adventu quibusdam persuadentibus duplicari subsidium cleri respondit: Melius radere oves quam destruere.


#### 1522.3


**David Curren** rector de **Urghlen**, curieque consistorii **Leighlen** advocatus ac capellanus choralis in ecclesia cathedrali ibidem, huc usque in memorandis suis, sic **Thaddeus**.


#### 1523.0


1523.


#### 1523.1


**Thomas fitz Water alias Radcliff comes Surrey** dux generosorum exercitus **Anglie** habuit in suo conductu de **Hibernia** plures ad arma homines aptos in expeditionem **Scotie**, et ibidem cremavit 37 villas et transcurrebat ab orientali marchia usque in occidentem depredando et necando.


#### 1523.2


Fames magna in **Hibernia** et **Anglia**, ita ut **Henricus 8.** tenuit festum natalitiorum in patria.


#### 1524.0


1524.


#### 1524.1


**Geraldus comes **Kildarie**** juratus **deputatus**, qui **Maurum (Mauritium) Guer** id est "sharp" interfectorem **episcopi Deoran** predicti cruci affigere curavit, at the head of **Glan Reynald** by **Leighlen**, et ibidem intralia ejus fecit comburi, anno 1525, vide supra.


#### 1525.0


1525.


#### 1525.1


**Robertus Talbot** de **Pollygard**, amicus **Petri Butler comitis Ossorie**, fuit interfectus juxta **Ballymore** per **Jacobum fitz Gerald**, pro eo quod suspectus


---

p.35




erat esse kalendarium actorum **comitis **Kildarie**** quo accusaretur, propter quod Butlerii stomachabantur, adeo quod multa sequebatur regni perturbatio.


#### 1526.0


1526.


#### 1526.1


**Carolus Cavenagh filius Mauritii** juvenis et **Mevina hibernice Mean** mater ejus cum aliis in Castro de **Droymreagh** juxta **Killanna**, modo vocata **Oldabbey**, cremabantur per **Cahir Mc Arte** de **Polmevaty.**


#### 1528.0


1528.


#### 1528.1


**O Neil **Ultoniorum** capitaneus** et **O Conchur** cum suis confederatis insurrexerunt contra **Petrum Butler comitem **Ossorie****, qui **Ultonienses** multum nocuerunt marchis **Midie**, et cetera. Sed **Waterfield** in recordo ecclesie scribit talem comotionem fuisse 1532. Illi etiam invaserunt **Uriell** spoliando et depredando totam patriam.


#### 1528.2


**Geraldus comes **Kildarie**** contra **O Carvell** insurgendo et castrum de **Byrre** insultando fuit dire vulneratus ex castro in latere suo per buletum, cui quidam turbarius jocose dixerat, ‘domine cur gemis tam dire, cum ego semel habui iij buletos in me, et vides domine quam sanus sum ad presens?’ — cui comes mite respondit (in agonia) quod hunc etiam bulletum vellet ipsum in se una cum ceteris habuisse.


#### 1528.3


**Matheus episcopus **Leighlen** agnomine Saunders** natus juxta **Drogheda**, mirifice comendatur a **Waterfieldo**.


#### 1529.0


1529.


#### 1529.1


**Petrus Butler comes **Ossorie**, **Hibernie** 
deputatus**, incepit accusare **comitem **Kildarensem**** coram consilio in **Anglia**, vide haec omnia in Waterfieldo qui eo tempore vixit.


#### 1530.0


1530.


#### 1530.1


**Hibernici** ferociter insurrexerunt in absentia **comitis **Kildarie**** ad tunc in Anglia commorantis, qui dominia dicti **Kildarie**, et plures patrias in circu
itu invaserunt, unde rex transmisit eundem **comitem **Kildarie**** et **Wm. Skevington**, qui rebellium ferocitatem cum celeritate reformarunt.


#### 1530.2


**Cahir Mc Gerald Cavenagh** communiter vocatus 
**Mc Nehenyne Crostey**, the sonne of the ill-begotten doughter, that is, a bastard, fuit factus **Mc Murchardus**, qui **Mauritio Nemoroso **Lagenie**** successit.


#### 1530.3


Edictum in parlamento emanavit quod nullus in regno **Anglie** aut **Hibernie** obtineret aliquod rescriptum aut beneficium ab ecclesia Romana.


#### 1532.0


1532.


#### 1532.1


Parlamentum coram **Geraldo comite **Kildarie**** convocatum, quo finito in **Angliam** coram consilio accusatur, convocatur et in turrim **London** comittitur ubi finem vite imposuit.


#### 1534.0


1534.


#### 1534.1


**Thomas fitz Gerald vocatus Thomas sericus**, in Irish etida orsidan, for that his followers had silk frienges about their head peeces, baro de **Ophaly**,


---

p.36




custos gladii regalis, **deputatus** patris sui, **justiciarius** **Hibernie**, restituit gladium in presentia consilii et loco ubi gladium recepit, et denunciavit ibidem rebellionem fieri publice et omnium subditorum regis bona et catella proscribi, deinde fecit capi **Johannem Allen archiepiscopum **Dublin**** et interfici apud **Tartayn**.


#### 1534.2


Comitatus **Kilkennie** combustus fuit et depredatus per eundem **Thomam fitz Gerald**.


#### 1534.3


**Wm. Skeffington** miles venit in **Hiberniam** cum exercitu militum, **deputatus** obiit apud **Kilmaynam**. — **Stowe**.


#### 1534.4


**Dublinenses** confusi fuerunt et interfecti per **Thomam fitz Gerald** tam apud **Kilmaynam** quam apud **Newgat**, et vicum **Sancti Thome** incendio cremavit.


#### 1535.0


1535.


#### 1535.1


**Nicolaus Moscraw** et **Hamerton** cum exercitu 
militum tunicis albis cruces rubeas gerentibus induti, interfecti fuerunt 
per eundem **Thomam** apud **Clontarff**.


#### 1535.2


**Dominus Leonardus Gray** venit in **Hiberniam** et protexit **Thomam fitz Gerald** cum suis avunculis, **Jacobo**, **Waltero**, **Olivero**, **Johanne** et **Richardo**, qui postea fuerunt omnes super literis domini **deputati** executi, et decollati apud **Tiburun**. Secundum **Stowe** 3 Februarii 1536. Et ipse **Leonardus Gray** postea decollatus apud **Tourehill** anno sequenti, vide alibi.


#### 1536.0


1536.


#### 1536.1


Religiosae domus et monasteria **Hibernie** fuerunt autoritate parlamenti concessa domino regi ad numerum 376 domuum, quorum valor annuatim extendit *ad* 32,000 libras, et bona mobilia eorum ad sumam 100,000 *libra*; et numerus hominum religiosorum in eisdem domibus professorum, et inde ad tunc rejectorum excedit 100,000, 
ceterisque religiosis abbatias suas et monasteria sursum reddentibus voluntarie, certe pensiones fuerunt quoad vixerunt concesse.


#### 1539.0


1539.


#### 1539.1


**O Neil** rebellavit et oriabat fere xx. millia in **Midia** et English pale, sed postea retractus per **Leonardum Gray deputatum**.


#### 1539.2


Estus et ariditas admirabilis aridos fecit rivos magnos, ita quod comuniter darent dimidium grani pro molitura alterius, et multi obierunt febre et fluxu, et hiems sequebatur adeo frigida gelu et nive, quod bestie inumerabiles *per* 
frigore moriebantur, et ultimo **pestis** extirpavit inumerabiles.


#### 1539.3


Maneria **ducis Norfolchie** et **Talbot comitis **Waterfordie** et **Salop**** aliorumque absentium et non habitantium super suas possessiones in **Hibernia** confiscabantur


---

p.37




in manus domini regis autoritate parlamenti apud **Dublin**, coram **Leonardo Gray**, 22 Maii.


#### 1539.4


**Matheus Saunders episcopus **Leighlen****.


#### 1539.5


**Milo Baron** prior de **Inisdiog** **episcopus**
*Ossoriensis*.


#### 1541.0


1541.


#### 1541.1


**Keadan alias Keadagh Mc Congall Mc 
Mealaghlen**, rex ut vocabatur **Laxie**, interfectus fuit juxta **Kylneyn** per **Donaldum Mc Cahil** in festo **Sancti Petri**.


#### 1541.2


**Leonardus Gray **deputatus**** hoc anno executus eo quod private tenuit familiaritatem cum **Thoma Fitz Gerald** rebelle, et eo quod promisit servitores ejus convertere ecclesiam cathedralem de **Down** in stabulam equorum, et quia non punivit suos propter spoliationem subditorum, et eo quod non eque ministravit justitiam postulan*tibus*.


#### 1541.3


**Henricus 8.** proclamabatur rex **Hibernie**.


#### 1541.4


**Antonius Sanctleger** miles fit **deputatus** **Hibernie**, et per concordatum sub suis aliorumque de consiliis manibus in modum charte magne decrevit pro libertate et immunitate ecclesie Hibernicane, videlicet, quod maneria principalia episcoporum **Hibernie**, mansusque rectorum et vicariorum ubi habitant ipsimet, atque mansiones et glebe ecclesiarum valore annuo decem marcarum *sterling* non excedentes, fuisse et esse libera et exempta ab 
omnibus oppressionibus et impositionibus aliisque patrie usibus, coyney et livery, ut patet in archivis ecclesie 
**Leighlen**.


#### 1542.0


1542.


#### 1542.1


**O Neil**, **O Donel**, **Magwir**, **O Kahan**, **Mc Gwyllyn**, **O Hanlan**, cum suis complicibus **Hibernicis** rebellarunt et spoliarunt boreales subditos usque ad **Navan**, et auferebant predas quam maximas, et anno sequenti submiserunt se gratiae regis, una cum **O Bryen** famoso rebelle.


#### 1543.0


1543.


#### 1543.1


**Willmus Brereton** miles fuit **justiciarius** **Hibernie** qui per tempus sui regiminis laudabiliter et pacifice gubernavit **Hiberniam**.


#### 1543.2


Magna perturbatio, crudelis et seditiosa factio in **Hibernia**.


#### 1543.3


**Georg Brown archiepiscopus **Dublin****.


#### 1544.0


1544.


#### 1544.1


**Hibernici** ad numerum 500 sub gubernatione **Poer** et **Finglas** transmissi in preparationem ad Bolen.


#### 1544.2


**Hugo (Con) O Neil dominus in **Ultonia**** creatus fuit per **Henricum 8.** **comes** de **Tyron**, et **Matheus ejus bastardus** creatus **Baro** de **Dunganon**.


#### 1544.3


**Donatus O Bryen** creatus **comes** de **Clanriccard** durante vita.


#### 1545.0


1545.


#### 1545.1


**Cahir Cavenagh Mc Art** de **Poolmohown** alias **Polmonty** **baronetus**


---

p.38


**de Sancto Moling** habuit victoriam de **Gerald Mc Cahir de Gerrowcheyll** juxta **Hacketston** ubi ceciderunt de **Byrnen** et aliis in **Idouagh** 100, et tam multi ex altera parte. I wold the rest of the rebells had been so bestoned.


#### 1545.2


**Jacobus Butler comes **Ormonie**** et **Leonax comes de **Downbrittan**** in **Scotia minore** et **Johannes Travers** miles cum 3000 **Hibernicis** navigaverunt a portu de **Skyrres** et applicuerunt in **Scotia**, ubi nihil memoria dignum fecerunt.


#### 1546.0


1546.


#### 1546.1


**Jacobus Butler comes **Ormonie** et **Ossorie**** obiit in **Holborne**, **London**, 18 Octobris, sepultus in ecclesia **Sancti Thome de Acres**; cor ejus delatum ad ecclesiam **Sanctii Kenitii** **Hibernie**.


#### 1546.2


**Monasterium** fratrum **Carmelitarum** **Leighlen** pontis in **Lagenia** **Hibernie**, erat in manerium aulamque regis et municipum edificatum, ad usum ****capitanei** Coghlen** et regiorum militum et garrison pro defensione patrie versus **Hibernicos** 
rebelles.


#### 1547.0


1547.


#### 1547.1


**Henricus 8.** moritur. **Edwardus 6.** 
succedit.


#### 1547.2


**Edwardus 6.** fecit ij. vicecomites in **Dublin** ubi antea balivi.


#### 1550.0


1550.


#### 1550.1


**Johannes Bale episcopus **Ossorie****.


#### 1550.2


**Robertus Travers regali autoritate episcopus **Leighlen****, cruel, covetous, vexing his clergie, fuit decretum in cancellaria **Hibernie** contra illum ex parte communitatis ecclesie **Leighlen**.


#### 1553.0


1553.


#### 1553.1


**Edwardus 6.** obiit, si causam queras lege Cardanum de genituris.


#### 1553.2


**Jana filia Henrici ducis Suffolcie**, uxor **domini Gilford Dudley filii ducis Northumbrie**, denunciabatur regina **Anglie** vigore cujusdam statuti per eundem **Edward regem** ad persuasionem **ducis Northumbrie** editi, brevi fuit decapitata.


#### 1553.3


**Maria Henrici 8. filia**.


#### 1554.0


1554.


#### 1554.1


**Philippus princeps **Hispanie**** applicuit in **Southampton** in festo **Sancti Jacobi**, et brevi matrimonium cum regina contraxit, et stilus eorum ab heraldo proclamatus et cetera, et stilus **Caroli imperatoris** illius patris in **Gieldhall**, **London** scriptus et cetera.


Charles the fyft his stile set up in golden lettres in **Guyldhall** **London**.


Charles the fyft by favour and assent of devine mercy and grace elected **emperour** of the **Romaynes**, Alway Caesar, **kinge** of **Almain**, **kinge** of **Castill**, **kinge** of **Aragon**, **kinge** of **Leones**, **kinge** of **Naples**, **kinge** of **Cicillia**, **kinge** of **Jerusalem**, **kinge** of **Hungarie**, **kinge** of **Dalmacia**, **kinge** of **Croacia**, **kinge** of **Navarr**, **kinge** of **Granat**, **kinge** of **Morcia**, **kinge** of **Gien**, **kinge** of **Algarb**, **kinge**


---

p.39




of **Dorden**, **kinge** of **Cordubia**, **kinge** of **Valencia**, **kinge** of **Sevil**, **kinge** of **Solet**, **kinge** of **Corse**, **kinge** of **Algezirs**, **kinge** of **Gibraltar**, **kinge** of **Minorica** and **Majorica**, **kinge** of the **Islands of Canarie**, **kinge** of the **Antisles in Inde**, **kinge** of the fyrme land of the ocean seas now called **New Spaine** - **Archduke** of **Austrich**, **duke** of **Burgonie**, **duke** of **Lotharingia**, **duke** of **Brabant**, **duke** of **Lunbrock**, **duke** of **Luxenbrock**, **duke** of **Callabrie**, **duke** of **Athens**, **duke** of **Nigripont**, **duke** of **Wiertingbick**, **duke** of **Gesder** - **Erle** of 
**Flaunders**, **erle** of **Hasburge**, **erle** of **Marcellon**, **erle** of **Artois**, **erle** of **Borgon**, **erle** palatine of the **Mores**, **erle** of **Holland**, **erle** of **Zeland**, **erle** of **Ferret**, **erle** of **Ryburge**, **erle** of **Rosillon**, **erle** of **Brittaine**, **erle** of **Mamier**, **erle** of **Zetaine** — **Lantgrave** of **Alasy** — **Marques** of **Borgon**, **marques** of **Cristan**, **marques** of **Gocia** — **Prince** of **Suetia**, **prince** of **Austrich** — **Lord** of **Frisland**, **lord** of **Slavonia**, **lord** of **Portua**, **lord** of **Bisky**, **lord** of **Molyn**, **lord** of **Salses**, **lord** of **Tripolis**, **lord** of **Meth**, and **lord** of Lordships in **Asia** and **Affrica**..


#### 1554.4


**Petrus Carew miles baro de **Odrona**** in **Hibernia** et **dominus de Mochonus** — court alias **de Mohounstreet** in **Anglia** propter insurrectionem apud **Devonshire** inceptam, audiensque infortunium **Henrici ducis Suffolcie** et postea decapitati cum suo filio et filia **Jana** fugit in **Franciam**. Sed postea revertit et reconciliabatur **Phillippo** et **Marie**.


#### 1554.5


**Elizabetha filia Henrici 8.** turri comissa, 
postea ducta ad **Woodstock**.


#### 1554.6


**Cardinalis Polus** restitutus et cetera, recepit supplicationes omnium in parlamento congregato quod penitieret eos de scismate et cetera, 
supplicarunt ut absolvantur et cetera, ille eloquenti oratione acceptabilis penitentia et cetera ostensa comissione a sede apostolica omnes absolvit et cetera, fit cantatio, Te Deum laudamus et cetera, et hoc apud **Romam** audito processiones fiebant pro vera conversione **Anglicorum** et **Hibernicorum**, et papa concessit per bullam remissionem omnibus de hoc vere gaudentibus.


#### 1554.7


**Georgius Brown archiepiscopus **Dublin****, 
**Edwardus **Midensis****, **Johannes Bale **Ossoriensis** episcopus**, **Robertus Travers **Leighlen** episcopus**, et **Thomas Darey** aliique prelati et beneficiati fuere depositi per **Georgium Dowdall primatem Armachanum**, et **Thomam Lewrous alias Leurus episcopum **Darensem****, primos et principales comissarios et ceteros eorum collegas, et custodia spiritualitatis **Dublin** concessa fuit **Thome Lockwood decano **Sancte Trinitatis** **Dublin****, et custodia spiritualitatis **Leighlen** comissa fuit ****decano** Canell** et **archdiacono** et cetera. *forgett not D. Kenell*.




---

p.40


#### 1554.8


**Thomas Fylay alias Fighill** minorum frater autoritate apostolica **episcopus** **Leighlen**.


#### 1555.0


1555.


#### 1555.1


**Hugo Curren archiepiscopus **Dublin**** vocavit provinciale concilium, ut pretendebat pro reformatione religionis.


#### 1555.2


**Thomas fitz Water alias Radclif comes Sussex **deputatus** **Hibernie****, vide viagium **comitis **Sussex**** et **Thome comitis **Ormonie**** in **Scotiam**.


#### 1555.3


**Thomas **Leighlen** episcopus**, ut patet in archivis ecclesie et libro concilii regalis.


#### 1557.0


1557.


#### 1557.1


**Congal Oge rex **Lacie****, apud pontem **Leighlen** cruci affixus.


#### 1558.0


1558.


#### 1558.1


**Johannes Othownery frater, episcopus **Ossoriensis**** pre dolore amissionis thesauri sui per fures, mortuus. Fures confitebantur et executi.


#### 1558.2


**Maria regina** absente **Philippo** obiit, et multi nobiles cum ea.


#### 1558.3


**Elizabeth regina** 17 Novembris, religio reformata et corrupta pecunia extirpata, vide sequens in statutis **Hibernie**.


#### 1560.0


1560.


#### 1560.1


**Thomas comes **Ormonie**** et **Geraldus comes **Desmonie**** rebellarunt in loco vocato **Aghemoy** infra comitatum **Tipperarie**, ubi pluribus ex parte **Desmonie** interfectis, **comes Geraldus** fuit vulneratus, et captivus in **Angliam** per **Ormond** transmissus.


#### 1566.0


1566.


#### 1566.1


**Edwardus Randolf** armiger locum tenens domini regis in **Ultonia** et collanellus mille pedestrium a **Bristollia** arrivavit in **Knockfergus**, et inde venit in **Dyrrhy** apud **Laughfoil** ubi fortificavit et 12.o Decembris sequente in conflictu vicit **O Neil**, qui cum eo pugnavit, et non postea diu vixit.


#### 1567.0


1567.


#### 1567.1


**Shane O Neil** secundum **Campion** vocans se **O Neil** et dominum provincie **Ultonie** in diversis conflictibus interfecit 3500 de exercitu **Henrici Sidney **deputati** **Hibernie****, ac etiam de **Scoticis** 300, demum suam conmatrem in adulterio publice et notorie tenens, manus violentas 
in presbyterum qui una cum sociis sibi dixit non licere ei (in confessione) uxorem alterius tenere, et in ultima ejus etate crimina leste majestatis comittere et cetera, tandem compulsus ad inimicos 
fugere, quorum patres ipse occiderat, illi in ebrietate ejus cultro eum inciderunt, et interfecerunt, at the key of **Ybuyg**.


#### 1568.0


1568.


#### 1568.1


Whereas before mention was made of **Thomas Carew Baron of **Odrone**** banished, and **Sir Peter Carew knight** claiming of him, at this tyme old **Sir Peter Carew**, (havinge adopted as is said young **Sir Peter Carew**) entered upon the possession of **Odrone**, and made the **Cavenages** compound with him, the which he quietly enjoyed savinge that **Morice Oge Kavenagh**


---

p.41




of **Garrawcheill** per fas et nephas tenuit suas terras vulgariter vocatas fyv-mart Landes absque titulo vel interesse.


#### 1569.0


1569.


#### 1569.1


**Lagenienses** omnibus enormitatibus dediti,
quidam dixere **Peter Carew** his warres,
alii dixere **Edmund Butlers** warres. **Cavanenses** hic diaboli contra **Petrum Carew**.


#### 1570.0


1570.


#### 1570.1


**Adam Loftus archiepiscopus **Dublin****.


#### 1570.2


**Lysac O Moardha (O Moore)** sonne to **Keadau Rough domini de **Lasia**** factus capitaneus ab **Henrico Sidney deputato** servivit animose contra **Ultonienses**, sed postea (canis ad vomitum) inventus in proditionibus, convictus suspensus fuit ad pontem **Leighlen**.


#### 1570.3


**Thomas Butler comes **Ormonie**** venit ex **Anglia**, pacificavit rebelles, (**Robert Mylles** of the saf conduct et cetera) cepit fratrem **Edmundum Butler**, tradidit eum **deputato**, quem **Hibernenses** fecerunt, statuerunt facere eum, capitaneum suum generale, **Petro Carew** principaliter resistente, sed e carcere aufugit, et omnia ei condonata.


#### 1571.0


1571.


#### 1571.1


Magna clades in **Conatia** que vocatur bellum 
de **Srughill** inter **Johannem** [*gap: extent: 1-2 words*] gubernatatom illius provincie de **Conaught** et **Conaghtinenses**, ubi ceciderunt plures ex utraque parte, sed gubernator prevaluit.


#### 1571.2


Scientia imprimendi et cudendi literas et characteres lingue Hibernice incepit in **Hibernia** in civitate **Eoblana** (**Dublin**) per **Johannem Kerna** thesaurarium ecclesie **Sancti Patricii** et **Nicolaum Welsh **Ossoriensem** episcopum**. **Daniel, episcopus **Leighlin**** leased out all in maner.


#### 1572.0


1572.


#### 1572.1


**Willmus fitz Williams **deputatus** **Hibernie****.


#### 1575.0


1575.


#### 1575.1


Rebellio **Ketingensium** sub **Petro Keting** eorum capitaneo sed brevi confusi et occisi.


#### 1575.2


**Thomas comes **Ormond**** rejecit omnes impositiones Coney et Lyvery ex patria sua.


#### 1575.3


**Pestilentia** magna per **Weixfordiam**, **Dublin**, **Naas**, **Athie**, **Carloug** ac **Leighlin-Pontem**, ita quod civitas **Dublin** preter castra tantum fuit quasi depopulata, ut fenum et herbe nascebantur in plateis et valvis ecclesiarum.


#### 1575.4


**Henricus Sidney** iterum **deputatus**, post discessum ***Wm.* fitz Williams**.




---

p.42


#### 1575.5


No terme after Trinities day held at **Dublin**, pretextu infectionis epidimiae pestis, et **archiepiscopus** **Dublin** per totam provinciam fecit litanias et suffragia diebus Dominicis Mercurii et Veneris fieri contra pestem.


#### 1575.6


**Petrus Carew** senior miles vir liberalis, strenuus, potens in armis, stature fortis, licet senex animosus tamen et belliger ex juventute, qui fortiter stravit plures in conflictu de **Knockcownla** de confederatis rebellium, conquestor **Odronie** in **Lagenia** et **Corkybeig** in **Desmohown**, dominus de **Mohownsottrie** in **Anglia**, obiit apud **Rossam-Pontis** in **Hibernia**, et sepelitur in ecclesia Trinitatis apud **Waterfordiam** ab antiquis vocatam **Manapiam**, qui in ultimo ejus eulogio per quinque episcopos approbato et insinuato confirmavit statum ffeofamenti, per eum antea ad usum **Petri juvenis Carew** et **Georgii Carew** (modo presidentis **Momonie**) et ad usum aliorum in **Anglia** ad numerum 15 personarum in toto; volens ut invicem secundum ordinem insertum succederent, si absque masculis de corporibus legitime sic procreatis vel procreandis successione dicesserint.


#### 1576.0


1576.


#### 1576.1


**Walter Devrox comes Essex, comes Marshall in **Hibernia**** obiit **Dublini**, corpus in **Angliam** et cetera.


#### 1577.0


1577.


#### 1577.1


**Rory (Oge O Moor) O Moarda** fecit magnam comotionem immo maximam in **Lagenia**, quam tenuit per xviij. annos, quo tempore currente cremavit **Naas**, **Athy**, **Caterlough**, **Leighlin-Pontem**, **Rathcoyl**, **Tassagard**, **Kilbrid**, **Bayllymore**, **Killy**, et **Rathmore** in **Lagenia** (cepit treacherously Henricum Harington et Alexandrum Cosby); 
cremavit cantredam de **Duthy-Fhelly** dominium **O Carvelli**, **Athlone** in **Conacia**, interfectus *(whome the Irish rimers extol like him that burnt Diana his temple)* fuit per **Bernardum Mc Gilpatrick** dominum de Upper **Ossorie** — vide infra.


#### 1577.2


**Moris Mc Lasy Mc Conyll** dominus de **Merggi** (ut ille asseruit) et **baronis** de **O Mergi** successor, cum 40 hominibus de sua familia post confederationem suam cum **Rory O Moardha** et super quadam protectione, interfectus fuit apud **Molaghmastyn** in comitatu **Kildarie**, ad eundem locum ob id propositum per **magistrum Cosby** et **Robertum Harpoll**, sub umbra servitii accersitus collusorie. **Harpoll** excused it that **Moris** had geven villanous wordes to the breach of his protection.


#### 1577.3


**Eugenius Mc Hugh O Dempsie** de **Clonagovna** miles ac dominus de **Glynmolyra** fuit in castro suo ibidem interfectus per **Lysac Mc Neill y Moardha**.




---

p.43


#### 1577.4


**Georgius Ackworth **legum doctor****, et **Robertus Garvey **legum baccalareus****, destinati ad clerum Hibernicum titulo magistrorum ad facultates pro reformatione cleri, sed ecclesie potius perturbatio sequebatur.


#### 1578.0


1578.


#### 1578.1


**Henricus Sidney deputatus** fecit suspendi 15 de familiaribus **Calvatin Mc Tyrrell** **capitanei** eorum, eo quod extortionem comiserunt circa cibum et pecuniam.


#### 1578.2


**Willelmus Gerrard** armiger **cancellarius** **Hibernie** iterum venit *in* **Hiberniam**. —vide quae scripsit et cetera, et pone eum inter scriptores.


#### 1578.3


**Willelmus Drury miles** (post discessum **Henrici Sideney**) factus **justiciarius** **Hibernie**, moriebatur **Waterfordie**, corpus ferebatur **Dublin**, ubi per plures dies insepultum remanebat, tandem expensis domine regine in ecclesia **Sancti Patricii** 
inhumatur.


#### 1579.0


1579.


#### 1579.1


**Jacobus fitz Moris Geraldinus** cum filio 
prioris de **Rhodes** et **Spaniardis** ad numerum 700 armatis, applicuit in portu de **Coan Thymore** et fecerunt fortalicium apud **Down Moyre** in **Mounster**, ubi postea per **dominum Gray** fuerunt interfecti, paucis exceptis qui capiebantur.


#### 1579.2


**Henricus Davels armiger, vicecomes comitatus **Cork**** occisus apud **Trally** per **Johannem Desmond**.


#### 1579.3


**Willelmus Pellam** miles fit **justiciarius**.


#### 1580.0


1580.


#### 1580.1


**Arthurus Gray de **Wilton**** miles garterii fit **deputatus** **Hibernie** duxit magnum exercitum ad fortalitium de **Down Moyr**, interfecit **Italos** et **Hispanos**, *quattuor* generosis exceptis quorum unus erat filius prioris de **Rhodes**.


#### 1580.2


Magna strages et clades per **Ketingos** apud 
**Leighlen** et apud **Glynmalowra** per **Byrnenses**, ubi **Petrus Oge miles, baro de 
**Odrona****, **Franciscus Cosby** armiger de **Stradbally**, **Laxie** capitaneus turbariorum ligiorum, **magister Moor**, et **Bernard fitz Williams** **capitanei**, fuerunt interfecti una cum aliis quampluribus generosis estimationis per **Feagh Mc Hugh**, et alios rebelles.


#### 1580.3


**Feagh Mc Hugh** de **Balyncorr** in **Cowlraynald**, per procurationem **Mauritii Oge Kavenagh** de **Garrovcheill**, cremavit x. villas in High **Odron**, et captivos secum adduxit **Magistrum Wood** et **Rogerum Hooker decanum **Leighlen**** et alios **Anglicanos**.


#### 1582.0


1582.


#### 1582.1


**Johannes O Desmond** miles captus fuit una cum **Jacobo na Dtynoyll** per **capitaneum Smith** executioni apud [*gap: extent: 1 or 2 words*] demandatus.


#### 1582.2


**Thomas comes **Ormond**** transfretavit in **Angliam** una cum cometissa.




---

p.44


#### 1583.0


1583.


#### 1583.1


**Geraldus fitz James comes **Desmonie**** captus in cabano suo in sylva, et decollatus per **Thomam Kelly** - and this **Kelly** was hanged at **Tyburne**.


#### 1583.2


**Mackworth capitaneus crudelis** interfectus per **Oconors** de **Ophaly**, membrum genitale eo vivente extraxerunt, eumque excoriaverunt.


#### 1583.3


**Thomas comes **Ormonie**** reversus est in **Hiberniam** et factus est gubernator provincie de **Mounster**, et **Desmond** generalis.


#### 1583.4


**Johannes Perrot miles **deputatus** **Hibernie**** pacificavit regnum.


#### 1588.0


1588.


#### 1588.1


Anglicani undertakers **Geraldo comite **Desmonie**** mortuo venerunt familiis ad inhabitandum.


#### 1588.2


**Willelmus fitz Williams** (post discessum 
**Johannis Perrot**) fit **deputatus**, ejus tempore classis navalis **Hispaniorum** magnum habuit infortunium, preter in **Anglia** perdit et cetera. In **Hibernia**. In **Tyreconill** infra **Ultoniam** super locum de 
**Loghfoyl** una navis et 1100 homines. In **Conatia** apud portum de Sligo 3 naves magne, 1500 homines. In **Tyreowley**, 1 navis cum 400 hominibus. In **Cleere** Island 1 navis cum 300 hominibus. In **Fynglassy** una navis et 
400 homines. In **Ophlagartys** contrey, 1 navis cum 200 hominibus. In **Irrish** ij. naves sed homines ex illis in alias naves fugerunt. In **Gallaway** bay, 1 navis et 700 homines. In **Momonia** super **Shenan**, ij. naves et 600 homines. In **Trally**, 1 navis et 24 
homines. In **Deishy**, 1 navis et 500 homines. In **Desmonia** 1 navis 300 homines. 
In rivo de **Shenan** 1 navis quam ipsi proprietarii cremarunt fugiendo in aliam. Summa - Navium 17. Homines 5394. — Vide compositio **Turlagh 
Leoge** et **Hugonis Tyron**. in turre **London**, et cetera.


#### 1589.0


1589.


#### 1589.1


**Richardus Meredith episcopus **Leighlen****.


#### 1589.2


**Orwairk** rebellavit, fugit in **Scotiam**, captus in **Angliam** mittitur, et termino Michaelis apud **Tiburne** suspensus, 1591.


#### 1591.0


1591.


#### 1591.1


**Arthur Achnan Kavenagh** pensionarius domine regine captus in **Monelly**, et cum 7 de suis sociis fuit suspensus juxta **Caterlough**.


#### 1592.0


1592.


#### 1592.1


**Thomas comes **Ormond**** applicuit in **Hibernia**.


#### 1594.0


1594.


#### 1594.1


**Willelmus Russell miles **deputatus** **Hibernie****, 20 Augusti ivit cum exercitu contra **Ultonienses**. **Johannes Noris miles**. **Birnenses** et **Mc Mahown** interfecerunt in uno conflictu 300 homines *exercitus* **Henrici Duke militis**, qui victualia ad **Iniskillen** adferre proposuerant.


#### 1594.2


**Thomas dominus Burgh **deputatus****, obiit apud **Newry**. **Wony Mc Rory**, in **Lease**, et cetera. **Thomas Noris** miles justiciarus uno mense.




---

p.45


#### 1598.0


1598.


#### 1598.1


Adam Loftus et Robertus Gardiner justiciarii. **Thomas comes Ormond** locum tenens exercitum.


#### 1599.0


1599.


#### 1599.1


**Robertus Essex comes **locum tenens** domine regine. **Adam Loftus** et **Georgius Cary** **deputati**** **Essex** in ejus absentia.


#### 1600.0


1600.


#### 1600.1


**Carolus Mountjoy **deputatus** **Hibernie**** mense Martii.


