

#A Proposal for correcting, improving and ascertaining the English Tongue


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Proposal for correcting, improving and ascertaining the English Tongue
========================================================================


Author: Jonathan Swift
----------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
Writers of Ireland II Project 2. Second draft, revised and corrected.Extent of text: 7400 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork.  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2008) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E700001-017Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions and secondary literature**2. An excellent bibliography covering many aspects of Jonathan Swift's Life, his writings, and criticism, compiled by Lee Jaffe, is available at http://www.jaffebros.com/lee/gulliver/bib/index.html.
3. J. Bowles Daly (ed.), Ireland in the days of Dean Swift, Irish tracts 1720–1734. (London 1887).
4. Frederick Ryland (ed.), Swift's Journal to Stella, A.D. 1710–1713. (London 1897).
- Temple Scott (ed.), A tale of a tub, and other early works. (London 1897).6. Frederick Falkiner, Essays on the portraits of Swift: Swift and Stella. (London 1908).
7. C. M. Webster, Swift's Tale of a Tub compared with Earlier Satires of the Puritans. Proceedings of the Modern Language Association 47/1 (March 1932) 171–178.
8. Stephen L. Gwynn, The life and friendships of Dean Swift. (London 1933).
9. Stanley Lane-Poole (ed.), Selections from the prose writings of Jonathan Swift with a preface and notes. (London 1933).
10. Ricardo Quintana, The mind and art of Jonathan Swift. (Oxford 1936).
11. Louis A. Landa, Swift's Economic Views and Mercantilism, English Literary History 10/4 (December 1943) 310–335.
12. R. Wyse Jackson, Swift and his circle. (Dublin 1945).
13. Herbert Davis, The Satire of Jonathan Swift (New York 1947).
14. Martin Price, Swift's rhetorical art. (New York 1953).
15. Robert C. Elliott, Swift and Dr Eachard. Proceedings of the Modern Language Association 69/5 (December 1954) 1250–1257.
16. John Middleton Murry, Jonathan Swift: A Critical Biography. (London 1954).
17. John Middleton Murry, Swift. (London: Published for the British Council and the National Book League 1955).
18. Kathleen Williams, Swift and the age of compromise. (London 1959).
19. John M. Bullitt, Jonathan Swift and the anatomy of satire: a study of satiric technique. (Harvard 1961).
20. Harold Williams (ed.), The Correspondence of Jonathan Swift. (Oxford 1963–65).
21. Herbert J. Davis (ed.), Jonathan Swift: essays on his satire and other studies. (New York 1964).
22. Herbert J. Davis (ed.), Gulliver's Travels. [based on the Faulkner edition, Dublin 1735] (Oxford 1965).
23. Herbert J. Davis (ed.), Swift: poetical works. (New York 1967).
24. R. B. McDowell, 'Swift as a political thinker'. In: Roger Joseph McHugh and Philip Edwards, Jonathan Swift: 1667–1967, a Dublin tercentenary tribute (Dublin 1967). 176–186.
25. Brian Vickers (ed.), The world of Jonathan Swift: essays for the tercentenary. (Oxford 1968).
26. Kathleen Williams, Jonathan Swift. (London 1968).
27. Morris Golden, The self observed: Swift, Johnson, Wordsworth. (Baltimore 1972.)
28. Jane M. Snyder, The meaning of 'Musaeo contingens cuncta lepore', Lucretius 1.934, Classical World 66 (1973) 330–334.
29. Claude Julien Rawson, Gulliver and the gentle reader: studies in Swift and our time. (London and Boston 1973).
30. A. L. Rowse, Jonathan Swift, major prophet. (London 1975).
31. Alexander Norman Jeffares, Jonathan Swift. (London 1976).
32. Clive T. Probyn, Jonathan Swift: the contemporary background. (Manchester 1978).
33. Clive T. Probyn (ed.), The art of Jonathan Swift. (London 1978).
34. Irvin Ehrenpreis, Swift: The man, his works, and the age (three volumes). (London 1962–83).
35. David M. Vieth (ed.), Essential articles for the study of Jonathan Swift's poetry. (Hamden 1984).
36. James A. Downie, Jonathan Swift, political writer. (London 1985).
37. Frederik N. Smith (ed.), The genres of Gulliver's travels. (London 1990).
38. James Kelly, 'Jonathan Swift and the Irish Economy in the 1720s', Eighteenth-century Ireland: Iris an dá chultúr 6 (1991) 7–36.
39. Joseph McMinn (ed.), Swift's Irish pamphlets. (Gerrards Cross 1991).
40. Robert Mahony, Jonathan Swift: the Irish identity. (Yale 1995).
41. Christopher Fox, Walking Naboth's vineyards: new studies of Swift (University of Notre Dame Ward-Philips lectures in English language and literature, Vol. 13). (Notre Dame/Indiana 1995).
42. Claude Rawson (ed.), Jonathan Swift: a collection of critical essays. (Englewood Cliffs, New Jeresey, 1995).
43. Michael Stanley, Famous Dubliners: W. B. Yeats, James Joyce, Jonathan Swift, Wolfe Tone, Oscar Wilde, Edward Carson. (Dublin 1996).
44. Daniel Carey, 'Swift among the freethinkers'. Eighteenth-century Ireland: Iris an dá chultúr, 12 (1997) 89–99.
45. Victoria Glendinning, Jonathan Swift. (London 1998).
46. Aileen Douglas; Patrick Kelly; Ian Campbell Ross, (eds.). Locating Swift: essays from Dublin on the 250th anniversary of the death of Jonathan Swift, 1667–1745. (Dublin 1998).
47. Bruce Arnold, Swift: an illustrated life. (Dublin 1999).
48. Nigel Wood (ed.), Jonathan Swift. (London and New York 1999).
49. Christopher J. Fauske, Jonathan Swift and the Church of Ireland, 1710–24 (Portland/Oregon 2001).
50. David George Boyce; Robert Eccleshall; Vincent Geoghegan (eds.), Political discourse in seventeenth- and eighteenth-century Ireland. (Basingstoke and New York 2001).
51. Ann Cline Kelly, Jonathan Swift and popular culture: myth, media and the man. (Basingstoke 2002).
52. Dirk F. Passmann and Heinz J. Vienken, The library and reading of Jonathan Swift: a bio-bibliographical handbook. 4 vols. (Frankfurt 2003).
53. Mark McDayter, 'The haunting of St James's Library: librarians, literature, and The Battle of the Books'. Huntington Library Quarterly, 66:1–2 (2003) 1–26.
54. Frank T. Boyle, 'Jonathan Swift' [A companion to satire]. In: Ruben Quintero (ed.), A companion to satire (Oxford 2007) 196–211.
55. Harry Whitaker, C. U. M. Smith and Stanley Finger (eds.), Explorations of the Brain, Mind and Medicine in the Writings of Jonathan Swift. Springer (US) 2007.
**The edition used in the digital edition**2. **D. Laing Purves**, A Proposal for correcting, improving and ascertaining the English Tongue in The works of Jonathan Swift D. D., Dean of St. Patrick's, Dublin. Carefully selected: with a biography of the author, by D. Laing Purves; and original and authentic notes, Ed. D. Laing Purves. , Edinburgh, William P. Nimmo & Co. (1880) page 490–495

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The text covers pages 490–495.


#### Editorial Declaration


##### Correction


The text has been proof-read twice.


##### Normalization


The electronic text represents the edited text, with spelling and punctuation modernised. Citations are identified. The editor's notes are tagged note type="auth" n="".


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (hard or soft) crosses a line break, the break is marked after the completion of the hyphenated word (and punctuation mark).


##### Segmentation


div0=the letter; paragraphs are marked; page-breaks are marked pb n="".


##### Interpretation


Names of persons are tagged. Terms and phrases in languages other than English are tagged.


### Profile Description


Created: By Jonathan Swift
 (February 1711/1712) #### Use of language


##### Language: [EN] The whole text is in English.


##### Language: [LA] Some words and phrases are in Latin.


### Revision History


* (2010-08-04) Beatrix Färber (ed.)

* Conversion script run; file proofed (2), more encoding added; header updated, file parsed. New SGML and HTML files created.
* (2008-09-23) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-24) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, content of 'langUsage' revised; minor modifications made to header and file strucutre.
* (2008-03-12) Beatrix Färber (ed.)

* File parsed. SGML and HTML version created.
* (2008-03-10) Beatrix Färber (ed.)

* Proofing completed. More content markup added.
* (2008-03-03) Beatrix Färber (ed.)

* Proofing (1) begun. Structural and content markup applied.
* (2008-03-01) Beatrix Färber (ed.)

* Header inserted including bibliographic details.
* (2007-07-04) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E700001-017


### A Proposal for correcting, improving and ascertaining the English Tongue: Author: Jonathan Swift




---

p.490


To the Most Honourable Robert Earl of Oxford, &c.
My Lord,—


What I had the honour of mentioning to your lordship some time ago in conversation, was not a new thought just then started by accident or occasion, but the result of long reflection; and I have been confirmed in my sentiments by the opinion of some very judicious persons with whom I consulted. They all agreed that noting would be of greater use towards the improvement of knowledge and politeness, than some effectual method for correcting, enlarging, and ascertaining our language; and they think it a work very possible to be compassed under the protection of a prince, the countenance and encouragement of a ministry, and the care of proper persons chosen for such an undertaking. I was glad to find your lordship's answer in so different a style from what has been commonly made use of on the like occasions for some years past, that all such thoughts must be deferred to a time of peace: a topic which some have carried so far, that they would not have us by any means think of preserving our civil or religious constitution, because we are engaged in a war abroad. It will be among the distinguishing marks of your ministry, my lord, that you have a genius above all such regards, and that no reasonable proposal for the honour, the advantage, or the ornament of your country, however foreign to your immediate office, was ever neglected by you. I confess the merit of this candour and condescension is very much lessened, because your lordship hardly leaves us room to offer our good wishes; removing all our difficulties, and supplying all our wants, faster than the most visionary projector can adjust his schemes. And therefore, my lord, the design of this paper is not so much to offer you ways and means, as to complain of a grievance, the redressing of which is to be your own work as much as that of paying the nation's debts, or opening a trade into the South Sea; and though not of such immediate benefit as either of these, or any other of your glorious actions, yet perhaps, in future ages, not less to your honour.


My lord, I do here in the name of all the learned and polite persons of the nation, complain to your lordship, as first minister, that our language is extremely imperfect; that its daily improvements are by no means in proportion to its daily corruptions; that the pretenders to polish and refine it have chiefly multiplied abuses and absurdities; and that in many instances it offends against every part of grammar. But lest your lordship should think my censure to be too severe, I shall take leave to be more particular.


I believe your lordship will agree with me in the reason why our language is less refined than those of Italy, Spain, or France. 'Tis plain that the Latin tongue, in its purity, was never in this island, towards the conquest of which few or no attempts were made till the time of **Claudius**; neither was that language ever so vulgar in Britain as it is known to have been in Gaul and Spain. Farther, we find that the Roman legions here were at length all recalled, to help their country against the Goths and other barbarous invaders. Mean time, the Britons, left to shift for themselves, and daily harassed by cruel inroads from the Picts, were forced to call in the Saxons for their defence; who consequently reduced the greatest part of the island to their own power, drove the Britons into the most remote and mountainous parts, and the rest of the country, in customs, religion, and language, became wholly Saxon. This I take to be the reason why there are more Latin words remaining in the British tongue, than in the old Saxon; which, excepting some few variations in the orthography, is the same, in most original words with our present English, as well as with the German, and other northern dialects.


**Edward the Confessor**, having lived long in France, appears to be the first who introduced any mixture of the French tongue with the Saxon; the court affecting what the prince was fond of, and others taking it up for a fashion, as it is now with us. **William the Conqueror** proceeded much farther; bringing over with him vast numbers of that nation, scattering them in every monastery, giving them great quantities of land, directing all pleadings to be in that language, and endeavouring to make it universal in the kingdom. This at least is the opinion generally received; but your lordship has fully convinced me that the French tongue made yet a greater progress here under **Harry II.**, who had large territories on that continent, both from his father and his wife, made frequent journeys and expeditions thither, and was always attended with a number of his countrymen, retainers at his court. For some centuries after, there was a constant intercourse between France and England, by the dominions we possessed there and the conquests we made; so that our language, between two and three hundred years ago, seems to have had a greater mixture with French than at present, many words having been afterwards rejected, and some since the time of **Spenser**; although we have still retained not a few which have been long antiquated in France. I could produce several instances of both kinds, if it were of any use or entertainment.




---

p.491


To examine into the several circumstances by which the language of a country may be altered, would force me to enter into a wide field. I shall only observe that the Latin, the French, and the English, seem to have undergone the same fortune. The first, from the days of Romulus to those of **Julius Cæsar**, suffered perpetual changes; and by what we meet in those authors who occasionally speak on that subject, as well as from certain fragments of old laws, it is manifest that the Latin, three hundred years before **Tully**, was as unintelligible in his time as the English and French of the same period are now; and these two have changed as much since **William the Conqueror** (which is but little less than 700 years) as the Latin appears to have done in the like term. Whether our language or the French will decline as fast as the Roman did, is a question that would perhaps admit more debate than it is worth. There were many reasons for the corruptions of the last; as, the change of their government into a tyranny, which ruined the study of eloquence, there being no farther use or encouragement for popular orators; their giving not only the freedom of the city, but capacity for employments, to several towns in Gaul, Spain, and Germany, and other distant parts, as far as Asia, which brought a great number of foreign pretenders into Rome; the slavish disposition of the senate and the people, by which the wit and eloquence of the age were wholly turned into panegyric, the most barren of all subjects; the great corruption of manners, and introduction of foreign luxury, with foreign terms to express it; with several others that might be assigned: not to mention those invasions from the Goths and Vandals, which are too obvious to insist on.


The Roman Language arrived at great perfection before it began to decay; and the French, for these last fifty years, has been polishing as much as it will bear, and appears to be declining by the natural inconsistency of that people, and the affectation of some late authors to introduce and multiply cant words, which is the most ruinous corruption in any language. **La Bruyère**, a late celebrated writer among them, makes use of many new terms, which are not to be found in any of the common dictionaries before his time. But the English tongue is not arrived to such a degree of perfection as to make us apprehend any thoughts of its decay; and if it were once refined to a certain standard, perhaps there might be ways found out to fix it for ever, or at least till we are invaded and made a conquest by some other state; and even then our best writings might probably be preserved with care, and grow into esteem, and the authors have a chance for immortality.


But without such great revolutions as these (to which we are, I think, less subject than kingdoms upon the continent) I see no absolute necessity why any language would be perpetually changing; for we find many example to the contrary. From **Homer** to **Plutarch** are above a thousand years; so long at least the purity of the Greek tongue may be allowed to last, and we know not how far before. The Grecians spread their colonies round all the coast of Asia Minor, even to the northern parts lying towards the Euxine, in every island of the Aegean sea, and several others in the Mediterranean; where the language was preserved entire for many ages, after they themselves became colonies to Rome, and till they were overrun by the barbarous nations upon the fall of that empire. The Chinese have books in their language above two thousand years old, neither have the frequent conquests of the Tartars been able to alter it. The German, Spanish, and Italian, have admitted few or no changes for some ages past. The other languages of Europe I know nothing of; neither is there any occasion to consider them.


Having taken this compass, I return to those considerations upon our own language which I would humbly offer your lordship. The period wherein the English tongue received most improvement I take to commence with the beginning of **queen Elizabeth**'s reign, and to conclude with the great Rebellion in forty-two. It is true, there was a very ill taste, both of style and wit, which prevailed under **King James I.**; but that seems to have been corrected in the first years of his successor, who, among many other qualifications of an excellent prince, was a great patron of learning. From the civil war to this present time, I am apt to doubt whether the corruptions in our language have not at least equalled the refinements of it; and these corruptions very few of the best authors of our age have wholly escaped. During the usurpation, such an infusion of enthusiastic jargon prevailed in every writing, as was not shaken off in many years after. To this succeeded that licentiousness which entered with the Restoration, and, from infecting our religion and morals, fell to corrupt our language; which last was not likely to be much improved by those who at that time made up the court of **King Charles II.**; either such who had followed him in his banishment, or who had been altogether conversant in the dialect of those fanatic times; or young men who had been educated in the same country: so that the court, which used to be the standard of propriety and correctness of speech, was then, and I think has ever since continued, the worst school in England for that accomplishment; and so will remain till better care be taken in the education of our young nobility, that they may set out into the world with some foundation of literature, in order to qualify them for patterns of politeness. The consequence of this defect upon our language may appear from the plays and other compositions written for entertainment within fifty years past, filled with a sucession of affected phrases, and new conceited words, either borrowed from the current style of the court, or from those who, under the character of men of wit and pleasure, pretended to give the law. Many of these refinements have already been



---

p.492



long antiquated, and are now hardly intelligible; which is no wonder, when they were the product only of ignorance and caprice.


I have never known this great town without one or two more dunces of figure, who had credit enough to give rise to some new word, and propagate it in most conversations, though it had neither humour nor significancy. If it struck the present taste, it was soon transferred into the plays and current scribbles of the week, and became an addition to our language; while the men of wit and learning, instead of early obviating such corruptions, were too often seduced to imitate and comply with them.


There is another set of men who have contributed very much to the spoiling of the English tongue; I mean the poets from the time of the Restoration. These gentlemen, although they could not be insensible how much our language was already overstocked with monosyllables, yet, to save time and pains, introduced that barbarous custom of abbreviating words to fit them to the measure of their verses; and this they have frequently done so very injudiciously, as to form such harsh unharmonious sounds, that none but a northern ear could endure. They have joined the most obdurate consonants without one intervening vowel, only to shorten a syllable; and their taste in time became so depraved, that what was a first a poetical license not to be justified, they made their choice, alleging that the words pronounced at length sounded faint and languid. This was a pretence to take up the same custom in prose; so that most of the books we see now a-days are full of those manglings and abbreviations. Instances of this abuse are innumerable: what does your lordship think of the words *drudg'd, disturb'd, rebuk'd, fledg'd,* and a thousand others everywhere to be met in prose as well as verse? where, by leaving out a vowel to save a syllable, we form so jarring a sound, and so difficult to utter, that I have often wondered how it could ever obtain.


Another cause (and perhaps borrowed from the former) which has contributed not a little to the maiming of our language, is a foolish opinion, advanced of late years, that we ought to spell exactly as we speak; which besides the obvious inconvenience of utterly destroying our etymology, would be a thing we should never see an end of. Not only the several towns and countries of England have a different way of pronouncing, but even here in London they clip their words after one manner about the court, another in the city, and a third in the suburbs; and, in a few years, it is probable, will all differ from themselves, as fancy or fashion shall direct; all which, reduced to writing, would entirely confound orthography. Yet many people are so fond of this conceit, that it is sometimes a difficult matter to read modern books and pamphlets; where the words are so curtailed, and varied from their original spelling, that whoever has been used to plain English, will hardly know them by sight.


Several young men at the universities, terribly possessed with the fear of pedantry, run into a worse extreme, and think all politeness to consist in reading the daily trash sent down to them from hence; this they call knowing the world, and reading men and manners. Thus furnished, they come up to town, reckon all their errors for accomplishments, borrow the newest set of phrases; and if they take a pen into their hands, all the odd words they have picked up in a coffeehouse, or a gaming ordinary, are produced as flowers of style, and the orthography refined to the utmost. To this we owe those monstrous productions which, under the names of Trips, Spies, Amusements, and other conceited appellations, have overrun us for some years past. To this we owe that strange race of wits who tell us they write to the humour of the age. And I wish I could say these quaint fopperies were wholly absent from graver subjects. In short, I would undertake to show your lordship several pieces where the beauties of this kind are so predominant, that, with all your skill in languages, you could never be able to read or understand them.


But I am very much mistaken if many of these false refinements among us do not arise from a principle which would quite destroy their credit, if it were well understood and considered. For I am afraid, my lord, that, with all the real good qualities of our country, we are naturally not very polite. This perpetual disposition to shorten our words by retrenching the vowels, is nothing else but a tendency to lapse into the barbarity of those northern nations from whom we are descended, and whose languages labour all under the same defect. For it is worthy our observation, that the Spaniards, the French, and the Italians, although derived from the same northern ancestors with ourselves, are with the utmost difficulty taught to pronounce our words; which the Swedes and Danes, as well as the Germans and the Dutch, attain to with ease, because our syllables resemble theirs in the roughness and frequency of consonants. Now, as we struggle with an ill climate to improve the nobler kinds of fruits, are at the expense of walls to receive and reverberate the faint rays of the sun, and fence against the northern blast; we sometimes, by the help of a good soil, equal the production of warmer countries, who have no need to be at so much cost or care. It is the same thing with respect to the politer arts among us; and the same defect of heat which gives a fierceness to our natures, may contribute to that roughness of our language, which bears some analogy to the harsh fruit of colder countries. For I do not reckon that we want a genius more than the rest of our neighbours: but your lordship will be of my opinion, that we ought to struggle with these natural disadvantages as much as we can, and be careful whom we employ whenever we design to correct them; which is a work that has hitherto been assumed by the least qualified hands. So that, if the choice had been left to



---

p.493



me, I would rather have trusted the refinement of our language, as far as it relates to sound, to the judgment of the women, than of illiterate court fops, half-witted poets, and university boys. For it is plain that women, in their manner of corrupting words, do naturally discard the consonants as we do the vowels. What I am going to tell your lordship appears very trifling: that more than once, where some of both sexes were in company, I have persuaded two or three of each to take a pen, and write down a number of letters joined together, just as it came into their heads; and upon reading this gibberish we have found that which the men had wrote, by the frequent encountering of rough consonants, to sound like High Dutch; and the other, by the women, like Italian, abounding in vowels and liquids. Now, though I would by no means give ladies the trouble of advising us in the reformation of our language, yet I cannot help thinking that, since they have been left out of all meetings, except parties at play or where worse designs are carried on, our conversation has very much degenerated.


In order to reform our language, I conceive, my lord, that a free judicious choice should be made of such persons as are generally allowed to be best qualified for such a work, without any regard to quality, party, or profession. These, to a certain number at least, should assemble at some appointed time and place, and fix on rules by which they design to proceed. What methods they will take is not for me to prescribe. Your lordship, and other persons in great employments, might please to be of the number: and I am afraid such a society would want your instruction and example as much as your protection; for I have, not without a little envy, observed of late the style of some great ministers very much to exceed that of any other productions.


The persons who are to undertake this work will have the example of the French before them, to imitate where these have proceeded right, and to avoid their mistakes. Besides the grammar part, wherein we are allowed to be very defective, they will observe many gross improprieties, which, however authorized by practice, and grown familiar, ought to be discarded. They will find many words that deserve to be utterly thrown out of our language; many more to be corrected; and perhaps not a few, long since antiquated, which ought to be restored on account of their energy and sound.


But what I have most at heart is, that some method should be thought on for ascertaining and fixing our language for ever, after such alterations are made in it as shall be thought requisite. For I am of opinion it is better a language should not be wholly perfect, than that it should be perpetually changing; and we must give over at one time, or at length infallibly change for the worse; as the Romans did, when they began to quit their simplicity of style for affected refinements, such as we meet in **Tacitus** and other authors; which ended by degrees in many barbarities, even before the Goths had invaded Italy.


The fame of our writers is usually confined to these two islands; and it is hard it should be limited in time, as much as place, by the perpetual variations of our speech. It is your lordship's observation, that if it were not for the Bible and Common Prayer Book in the vulgar tongue, we should hardly be able to understand anything that was written among us a hundred years ago; which is certainly true: for those books, being perpetually read in churches, have proved a kind of standard for language, especially to the common people. And I doubt whether the alterations since introduced have added much to the beauty or strength of the English tongue, though they have taken off a great deal from that simplicity which is one of the greatest perfections in any language. You, my lord, who are so conversant in the sacred writings, and so great a judge of them in their originals, will agree, that no translation our country ever yet produced, has come up to that of the Old and New Testament: and by the many beautiful passages which I have often had the honour to hear your lordship cite from thence, I am persuaded that the translators of the Bible were masters of an English style much fitter for that work than any we see in our present writings; which I take to be owing to the simplicity that runs through the whole. Then, as to the greatest part of our liturgy, compiled long before the translation of the Bible now in use, and little altered since, there seem to be in it as great strains of true sublime eloquence as are anywhere to be found in our language; which every man of good taste will observe in the communion service, that of burial, and other parts.


But when I say that I would have our language, after it is duly correct, always to last, I do not mean that is should never by enlarged. Provided that no word, which a society shall give a sanction to, be afterwards antiquated and exploded, they may have liberty to receive whatever new ones they shall find occasion for; because then the old books will yet be always valuable according to their intrinsic worth, and not thrown aside on account of unintelligible words and phrases, which appear harsh and uncouth only because they are out of fashion. Had the Roman tongue continued vulgar in that city till this time, it would have been absolutely necessary, from the mighty changes that have been made in law and religion, from the many terms of art required in trade and in war, from the new inventions that have happened in the world, from the vast spreading of navigation and commerce, with many other obvious circumstances, to have made great additions to that language; yet the ancients would still have been read and understood with pleasure and ease. The Greek tongue received many enlargements between the time of **Homer** and that of **Plutarch**, yet the former author was probably as well understood in **Trajan**'s time as



---

p.494



the latter. What **Horace** says of words going off and perishing like leaves, and new ones coming in their place, is a misfortune he laments, rather than a thing he approves; but I cannot see why this should be absolutely necessary, or, if it were, what would have become of his *monumentum ære perennius?’’*

Horace, Ode 3,30.




Writing by memory only, as I do at present, I would gladly keep within my depth; and therefore shall not enter into farther particulars. Neither do I pretend more than to show the usefulness of this design, and to make some general observations, leaving the rest to that of society which I hope will owe its institution and patronage to your lordship. Besides, I would willingly avoid repetition, having about a year ago communicated to the public much of what I had to offer upon this subject, by the hands of an ingenious gentleman, who for a long time did thrice a week divert or instruct the kingdom by his papers, and is supposed to pursue the same design at present under the title of Spectator. This author, who has tried the force and compass of our language with so much success, agrees entirely with me in most of my sentiments relating to it; so do the greatest part of the men of wit and learning whom I have had the happiness to converse with; and therefore I imagine that such a society would be pretty unanimous in the main points.


Your lordship must allow that such a work as this, brought to perfection, would very much contribute to the glory of her majesty's reign; which ought to be recorded in words more durable than brass, and such as our posterity may read a thousand years hence with pleasure as well as admiration. I have always disapproved that false compliment to princes, that the most lasting monument they can have is the hearts of their subjects. It is indeed their greatest present felicity to reign in their subjects' hearts; but these are too perishable to preserve their memories, which can only be done by the pens of able and faithful historians. And I take it to be your lordship's duty, as prime minister, to give order for inspecting our language, and rendering it fit to record the history of so great and good a princess. Besides, my lord, as disinterested as you appear to the world, I am convinced that no man is more in the power of a prevailing favourite passion that yourself; I mean that desire of true and lasting honour which you have borne along with you through every stage of your life. To this you have often sacrificed your interest, your ease, and your health; for preserving and increasing this, you have exposed your person to secret treachery and open violence. There is not perhaps an example in history of any minister who, in so short a time, has performed so many great things, and overcome so many great difficulties. Now, though I am fully convinced, that you fear God, honour your queen, and love your country as much as any of your fellow-subjects; yet I must believe that the desire of fame has been no inconsiderable motive to quicken you in the pursuit of those actions which will best deserve it. But, at the same time, I must be so plain as to tell your lordship that if you will not take some care to settle our language, and put it into a state of continuance, I cannot promise that your memory shall be preserved above a hundred years, farther than by imperfect tradition.


As barbarous and ignorant as we were in former centuries, there was more effectual care taken by our ancestors to preserve the memory of times and persons, than we find in this age of learning and politeness, as we are pleased to call it. The rude Latin of the monks is still very intelligible; whereas, had their records been delivered down only in the vulgar tongue, so barren and so barbarous, so subject to continual succeeding changes, they could not now be understood, unless by antiquaries who made it their study to expound them. And we must at this day have been content with such poor abstracts of our English story, as laborious men of low genius would think fit to give us; and even these, in the next age, would be likewise swallowed up in succeeding collections. If things go on at this rate, all I can promise your lordship is, that about two hundred years hence some painful compiler, who will be at the trouble of studying old language, may inform the world that, in the reign of **queen Anne**, **Robert earl of **Oxford****, a very wise and excellent man, was made high treasurer, and saved his country, which in those days was almost ruined by a foreign war and a domestic faction. Thus much he may be able to pick out, and willingly transfer into his new history, but the rest of your character, which I or any other writer may now value ourselves by drawing, and the particular account of the great things done under your ministry, for which you are already so celebrated in most parts of Europe, will probably be dropped, on account of the antiquated style and manner they are delivered in.


How, then, shall any man who has a genius for history equal to the best of the ancients, be able to undertake such a work with spirit and cheerfulness, when he considers that he will be read with pleasure but a very few years, and in an age or two shall hardly be understood without an interpreter? This is like employing an excellent statuary to work upon mouldering stone. Those who apply their studies to preserve the memory of others, will always have some concern for their own; and I believe it is for this reason that so few writers among us, of any distinction, have turned their thoughts to such a discouraging employment; for the best English historian must lie under this mortification, that, when his style grows antiquated, he will be only considered as a tedious relater of facts, and perhaps consulted in his turn, among other neglected authors, to furnish materials for some future collector.


I doubt your lordship is but ill entertained with a few scattered thoughts upon a subject that deserves to be treated with ability and 



---

p.495



care. However, I must beg leave to add a few words more, perhaps not altogether foreign to the same matter. I know not whether that which I am going to say may pass for caution, advice or reproach; any of which will be justly thought very improper from one in my station to one in yours. However, I must venture to affirm, that if genius and learning be not encouraged under your lordship's administration, you are the most inexcusable person alive. All your other virtues, my lord, will be defective without this; your affability, candour, and good nature; that perpetual agreeableness of conversation, so disengaged in the midst of such a weight of business and opposition; even your justice, prudence, and magnanimity, will shine less bright without it. Your lordship is universally allowed to possess a very large portion in most parts of literature; and to this you owe the cultivating of those many virtues which otherwise would have been less adorned, or in lower perfection. Neither can you acquit yourself of these obligations without letting the arts, in their turn, share your influence and protection: besides, who knows but some true genius may happen to arise under your ministry, *exortus ut *aetherius* sol’’*

Lucretius, De Rerum Natura, III 1044.

. Every age might perhaps produce one or two of these to adorn it, if they were not sunk under the censure and obloquy of plodding, servile, imitating pedants. I do not mean, by a true genius, any bold writer who breaks through the rules of decency to distinguish himself by the singularity of his opinions; but one who, upon a deserving subject, is able to open new scenes, and discover a vein of true and noble thinking, which never entered into any imagination before; every stroke of whose pen is worth all the paper blotted by hundreds of others in the compass of their lives. I know, my lord, your friends will offer in your defence that in your private capacity you never refused your purse and credit to the service and support of learned or ingenious men; and that, ever since you have been in public employment, you have constantly bestowed your favours to the most deserving persons. But I desire your lordship not to be deceived; we never will admit of these excuses, nor will allow your private liberality, as great as it is, to atone for your excessive public thrift. But here again, I am afraid, most good subjects will interpose in your defence, by alleging the desparate condition you found the nation in, and the necessity there was for so able and faithful a steward to retrieve it, if possible, by the utmost frugality. We grant all this, my lord; but then it ought likewise to be considered that you have already saved several millions to the public, and that what we ask is too inconsiderable to break into any rules of the strictest good husbandry. The French king bestows about half-a-dozen pensions to learned men in several parts of Europe, and perhaps a dozen in his whole kingdom; which in the whole do probably not amount to half the income of many a private commoner in England, yet have more contributed to the glory of that prince than any million he has otherwise employed. For learning, like all true merit, is easily satisfied; while the false and counterfeit is perpetually craving, and never thinks it has enough. The smallest favour given by a great prince as a mark of esteem to reward the endowments of the mind, never fails to be returned with praise and gratitude, and loudly celebrated to the world. I have known, some years ago, several pensions given to particular persons, (how deservedly I shall not inquire,) any one of which, if divided into several parcels, and distributed by the crown to those who might upon occasion distinguish themselves by some extraordinary production of wit or learning, would be amply sufficient to answer the end. Or if any such persons were above money, (as every great genius certainly is, with very moderate conveniences of life,) a medal or some mark of distinction would do full as well.


But I forget my province, and find myself turning projector before I am aware; although it be one of the last characters under which I should desire to appear before your lordship, especially when I have the ambition of aspiring to that of being,


with the greatest respect and truth, my lord, your lordship's most obedient, most obliged, and most humble servant,

Jonathan Swift.





