

#A Chapter in the History of a Tyrone Family


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Chapter in the History of a Tyrone Family
===========================================


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 1. First draftExtent of text: 15800 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2006) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E830000-002Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

*A Chapter in the History of a Tyrone Family* was first published anonymously in the *Dublin University Magazine* in 1839.

#### Sources


**Editions**2. Joseph Sheridan Le Fanu, The Purcell Papers, edited and with a prefatory memoir by A. P. Graves. 3 volumes. London: Bentley, 1880.
3. Joseph Sheridan Le Fanu, Ghost Stories and Mysteries, selected and edited by E.F.Bleiler. New York: Dover Publications, 1975.
4. Joseph Sheridan Le Fanu, The collected works of Joseph Sheridan Le Fanu, introduction by Sir Devendra P. Varma. 3 volumes. New York: Arno Press 1977. [Facsimile reprint of 1871 edition.]
**Further reading**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October-November 1916) 30–33.
8. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
9. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
10. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
11. V.S. Pritchett, The living novel, London: Chatto and Windus 1946.
12. Elizabeth Bowen, Collected Impressions, London 1950.
13. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
14. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
15. A.B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
16. Peter Penzoldt, The Supernatural in Fiction, New York: Humanities Press 1952.
17. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
18. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
19. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
20. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
21. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
22. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
23. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
24. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
25. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
26. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
27. E. F. Beiler, 'Introduction' to J. S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
28. J. C. Beckett, The Anglo-Irish Tradition, London 1976.
29. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London: Faber 1977.
30. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Athens, Ohio: Ohio University Press 1978.
31. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
32. Joseph Browne, 'Ghosts and Ghouls and Le Fanu', Canadian Journal of Irish Studies 8 (1982) 5–15.
33. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
34. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
35. Jolanta Nalecz-Wojtczak, 'Joseph Sheridan Le Fanu and New Dimensions for the English Ghost Story', in: Wolfgang Zach and Heinz Kosok (eds.), Literary Interrelations: Ireland, England and the World, vol. 2, Tübingen: Günter Narr 1987.
36. Victor Sage, Horror Fiction in the Protestant Tradition, London: Macmillan 1988.
37. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
38. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
39. Marie Mulvey-Roberts (ed.), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
40. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
41. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
42. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
43. Michael Charlesworth (ed.), The Gothic revival, 1720–1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
44. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
45. James Walton, Vision and Vacancy: the Fictions of J. S. Le Fanu. Dublin, University College Dublin Press, 2007.
**The edition used in the digital edition**2. Ghost Stories and Mysteries. Joseph Sheridan Le Fanu First [1 volume; ix + 372pp] Dover PublicationsNew York (1975)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 189–215.


#### Editorial Declaration


##### Correction


Text has been proofed twice at CELT.


##### Normalization


The electronic text is as edited by E. F. Bleiler who states the material "has been reprinted without abridgment, modernization or other alteration, beyond some regularization of punctuation and the correction of a few obvious typographical errors". Regularizations made at CELT are contained within reg tags, with the form found in Bleiler's edition given in the orig attribute.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the chapter. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from other languages are marked.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: 1839#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] One word is in French.


### Revision History


* (2008-09-25) Beatrix Färber (ed.)

* Keywords added; file validated; new wordcount made.
* (2006-12-06) Beatrix Färber (ed.)

* File proofed (2); file parsed, additions to bibliography made; SGML and HTML file created.
* (2006-12-04) Beatrix Färber (ed.)

* Header created; bibliography inserted; file proofed (1), structural and content markup added.
* (2006-11-29) Beatrix Färber (capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E830000-002


### A Chapter in the History of a Tyrone Family: Author: Joseph Sheridan Le Fanu




---

p.189


### A Chapter in the History of a Tyrone Family

### Being a Tenth Extract from the Legacy of the late Francis Purcell, P.P. of Drumcoolagh.

#### Introduction


In the following narrative, I have endeavoured to give as nearly as possible the ipsissima verba of the valued friend from whom I received it, conscious that any aberration from *her* mode of telling the tale of her own life, would at once impair its accuracy and its effect. Would that, with her words, I could also bring before you her animated gesture, her expressive countenance, the solemn and thrilling air and accent with which she related the dark passages in her strange story; and, above all, that I could communicate the impressive consciousness that the narrator had seen with her own eyes, and personally acted in the scenes which she described; these accompaniments, taken with the additional circumstance that she who told the tale was one far too deeply and sadly impressed with religious principle, to misrepresent or fabricate what she repeated as fact, gave to the tale a depth of interest which the events recorded could hardly, themselves, have produced. I became acquainted with the lady from whose lips I heard this narrative, nearly twenty years since, and the story struck my fancy so much, that I committed it to paper while it was still fresh in my mind, and should its perusal afford you entertainment for a listless half hour, my labour shall not have been bestowed in vain. I find that I have taken the story down as she told it, in the first person, and perhaps, this is as it should be.


She began as follows:




---

p.190


My maiden name was Richardson,[1](javascript:footNote('E830000-002/note001.html')) the designation of a family of some distinction in the county of Tyrone. I was the younger of two daughters, and we were the only children. There was a difference in our ages of nearly six years, so that I did not, in my childhood, enjoy that close companionship which sisterhood, in other circumstances, necessarily involves; and while I was still a child, my sister was married. The person upon whom she bestowed her hand, was a Mr. Carew, a gentleman of property and consideration in the north of England. I remember well the eventful day of the wedding; the thronging carriages, the noisy menials, the loud laughter, the merry faces, and the gay dresses. Such sights were then new to me, and harmonized ill with the sorrowful feelings with which I regarded the event which was to separate me, as it turned out, for ever, from a sister whose tenderness alone had hitherto more than supplied all that I wanted in my mother's affection. The day soon arrived which was to remove the happy couple from *Ashtown House*. The carriage stood at the hall-door, and my poor sister kissed me again, and again, telling me that I should see her soon. The carriage drove away, and I gazed after it until my eyes filled with tears, and, returning slowly to my chamber, I wept more bitterly, and, so to speak, more desolately, than ever I had done before. My father had never seemed to love, or to take an interest in me. He had desired a son, and I think he never thoroughly forgave me my unfortunate sex. My having come into the world at all as his child, he regarded as a kind of fraudulent intrusion, and, as his antipathy to me had its origin in an imperfection of mine, too radical for removal, I never even hoped to stand high in his good graces. My mother was, I dare say, as fond of me as she was of any one; but she was a woman of a masculine and a worldly cast of mind. She had no tenderness or sympathy for the weaknesses, or even for the affections, of woman's nature and her demeanour towards me was peremptory, and often even harsh. It is not to be supposed, then, that I found in the society of my parents much to supply the loss of my sister. About a year after her marriage, we received letters from Mr. Carew, containing accounts of my sister's health, which, though not actually alarming, were calculated to make us seriously uneasy. The symptoms most dwelt upon were loss of appetite and cough. The letters concluded by intimating that he would avail himself of my father and mother's repeated invitation to spend some time at Ashtown, particularly as the physician who had been consulted as to my sister's health had strongly advised a removal to her native air. There were added repeated assurances that nothing serious was apprehended, as it was supposed that a deranged state of the liver was the only source of the symptoms which at first had seemed to intimate consumption.




---

p.191


In accordance with this announcement, my sister and Mr. Carew arrived in Dublin, where one of my father's carriages awaited them, in readiness to start upon whatever day or hour they might choose for their departure. It was arranged that Mr. Carew was, as soon as the day upon which they were to leave Dublin was definitely fixed, to write to my father, who intended that the two last stages should be performed by his own horses, upon whose speed and safety far more reliance might be placed than upon those of the ordinary *post-horses*, which were, at that time, almost without exception, of the very worst order. The journey, one of about ninety miles, was to be divided; the larger portion being reserved for the second day. On Sunday, a letter reached us, stating that the party would leave Dublin on Monday, and, in due course, reach Ashtown upon Tuesday evening. Tuesday came: the evening closed in, and yet no carriage; darkness came on, and still no sign of our expected visitors. Hour after hour passed away, and it was now past twelve; the night was remarkably calm, scarce a breath stirring, so that any sound, such as that produced by the rapid movement of a vehicle, would have been audible at a considerable distance. For some such sound I was feverishly listening.


It was, however, my father's rule to close the house at nightfall, and the window-shutters being fastened, I was unable to reconnoitre the avenue as I would have wished. It was nearly one o'clock, and we began almost to despair of seeing them upon that night, when I thought I distinguished the sound of wheels, but so remote and faint as to make me at first very uncertain. The noise approached; it became louder and clearer; it stopped for a moment. I now heard the shrill screaking of the rusty iron, as the avenue gate revolved on its hinges; again came the sound of wheels in rapid motion.


‘It is they,’ said I, starting up; ‘the carriage is in the avenue.’ We all stood for a few moments, breathlessly listening. On thundered the vehicle with the speed of a whirlwind; crack went the whip, and clatter went the wheels, as it rattled over the uneven pavement of the court; a general and furious barking from all the dogs about the house, hailed its arrival. We hurried to the hall in time to hear the steps let down with the sharp clanging noise peculiar to the operation, and the hum of voices exerted in the bustle of arrival. The hall-door was now thrown open, and we all stepped forth to greet our visitors. The court was perfectly empty; the moon was shining broadly and brightly upon all around; nothing was to be seen but the tall trees with their long spectral shadows, now wet with the dews of midnight. We stood gazing from right to left, as if suddenly awakened from a dream; the dogs walked suspiciously, growling and snuffing about the court, and by totally and suddenly ceasing their former loud barking, expressing the predominance of fear. We stared one upon another in perplexity and dismay, and I think I never beheld more pale faces assembled. By my father's direction, we looked about to find anything which might indicate or account for the noise





---

p.192




 which we had heard; but no such thing was to be seen—even the mire which lay upon the avenue was undisturbed. We returned to the house, more *panic-struck* than I can describe. On the next day, we learned by a messenger, who had ridden hard the greater part of the night, that my sister was dead. On Sunday evening, she had retired to bed rather unwell, and, on Monday, her indisposition declared itself unequivocally to be malignant fever. She became hourly worse, and, on Tuesday night, a little after midnight, she expired.[2](javascript:footNote('E830000-002/note002.html')) I mention this circumstance, because it was one upon which a thousand wild and fantastical reports were founded, though one would have thought that the truth scarcely required to be improved upon; and again, because it produced a strong and lasting effect upon my spirits, and indeed, I am inclined to think, upon my character. I was, for several years after this occurrence, long after the violence of my grief subsided, so wretchedly low-spirited and nervous, that I could scarcely be said to live; and during this time, habits of indecision, arising out of a listless acquiescence in the will of others, a fear of encountering even the slightest opposition, and a disposition to shrink from what are commonly called amusements, grew upon me so strongly, that I have scarcely even yet, altogether overcome them.


We saw nothing more of Mr. Carew. He returned to England as soon as the melancholy rites attendant upon the event which I have just mentioned were performed; and not being altogether inconsolable, he married again within two years; after which, owing to the remoteness of our relative situations, and other circumstances, we gradually lost sight of him.


I was now an only child; and, as my elder sister had died without issue, it was evident that, in the ordinary course of things, my





---

p.193




 father's property, which was altogether in his power, would go to me, and the consequence was, that before I was fourteen, *Ashtown House* was besieged by a host of suitors; however, whether it was that *I* was too young, or that none of the aspirants to my hand stood sufficiently high in rank or wealth, I was suffered by both parents to do exactly as I pleased; and well was it for me, as I afterwards found that fortune, or, rather Providence, had so ordained it, that I had not suffered my affections to become in any degree engaged, for my mother would never have suffered any *silly fancy* of mine, as she was in the habit of styling an attachment, to stand in the way of her ambitious views; views which she was determined to carry into effect, in defiance of every obstacle, and in order to accomplish which, she would not have hesitated to sacrifice anything so unreasonable and contemptible as a girlish passion.


When I reached the age of sixteen, my mother's plans began to *develop* themselves; and, at her suggestion, we moved to Dublin to sojourn for the winter, in order that no time might be lost in disposing of me to the best advantage. I had been too long accustomed to consider myself as of no importance whatever, to believe for a moment that I was in reality the cause of all the bustle and preparation which surrounded me, and being thus relieved from the pain which a consciousness of my real situation would have inflicted, I journeyed towards the capital with a feeling of total indifference.


My father's wealth and connection had established him in the best society, and, consequently, upon our arrival in the metropolis, we commanded whatever enjoyment or advantages its gaieties afforded. The tumult and novelty of the scenes in which I was involved did not fail considerably to amuse me, and my mind gradually recovered its tone, which was naturally cheerful. It was almost immediately known and reported that I was an heiress, and of course my attractions were pretty generally acknowledged. Among the many gentlemen whom it was my fortune to please, one, ere long, established himself in my mother's good graces, to the exclusion of all less important aspirants. However, I had not understood or even remarked his attentions, nor in the slightest degree suspected his or my mother's plans respecting me, when I was made aware of them rather abruptly by my mother herself.


We had attended a splendid ball, given by Lord M——, at his residence in *Stephen's Green*, and I was, with the assistance of my waiting-maid, employed in rapidly divesting myself of the rich ornaments which, in profuseness and value, could scarcely have found their equals in any private family in Ireland. I had thrown myself into a lounging-chair beside the fire, listless and exhausted, after the fatigues of the evening, when I was aroused from the reverie into which I had fallen, by the sound of footsteps approaching my chamber, and my mother entered.


‘Fanny, my dear,’ said she, in her softest tone, ‘I wish to say a word or two with you before I go to rest. You are not fatigued, love, I hope?’


‘No, no, madam, I thank you,’ said I, rising at the same time from





---

p.194




 my seat, with the formal respect so little practised now.


‘Sit down, my dear,’ said she, placing herself upon a chair beside me; ‘I must chat with you for a quarter of an hour or so. Saunders’ (to the maid) ‘you may leave the room; do not close the room door, but shut that of the lobby.’


This precaution against curious ears having been taken as directed, my mother proceeded.


‘You have observed, I should suppose, my dearest Fanny; indeed, you *must* have observed Lord Glenfallen's marked attentions to you?’


‘I assure you, madam,’ I began.


‘Well, well, that is all right,’ interrupted my mother; ‘of course you must be modest upon the matter; but listen to me for a few moments, my love, and I will prove to your satisfaction that your modesty is quite unnecessary in this case. You have done better than we could have hoped, at least so very soon. Lord Glenfallen is in love with you. I give you joy of your conquest,’ and saying this, my mother kissed my forehead.


‘In love with me!’ I exclaimed, in unfeigned astonishment.


‘Yes, in love with you,’ repeated my mother; ‘devotedly, distractedly in love with you. Why, my dear, what is there wonderful in it? Look in the glass, and look at these,’ she continued, pointing with a smile to the jewels which I had just removed from my person, and which now lay a glittering heap upon the table.


‘May there not,’ said I, hesitating between confusion and real alarm; ‘is it not possible that some mistake may be at the bottom of all this?’


‘Mistake, dearest! none,’ said my mother. ‘None; none in the world; judge for yourself; read this, my love,’ and she placed in my hand a letter, addressed to herself, the seal of which was broken. I read it through with no small surprise. After some very fine complimentary flourishes upon my beauty and perfections, as, also, upon the antiquity and high reputation of our family, it went on to make a formal proposal of marriage, to be communicated or not to me at present, as my mother should deem expedient; and the letter wound up by a request that the writer might be permitted, upon our return to *Ashtown House*, which was soon to take place, as the spring was now tolerably advanced, to visit us for a few days, in case his suit was approved.


‘Well, well, my dear,’ said my mother, impatiently; ‘do you know who Lord Glenfallen is?’


‘I do, madam,’ said I rather timidly, for I dreaded an altercation with my mother.


‘Well, dear, and what frightens you?’ continued she. ‘Are you afraid of a title? What has he done to alarm you? he is neither old nor ugly.’


I was silent, though I might have said, ‘He is neither young nor handsome.’


‘My dear Fanny,’ continued my mother, ‘in sober seriousness you





---

p.195




 have been most fortunate in engaging the affections of a nobleman such as Lord Glenfallen, young and wealthy, with first-rate, yes, acknowledged *first-rate* abilities and of a family whose influence is not exceeded by that of any in Ireland—of course you see the offer in the same light that I do—indeed I think you *must*.’


This was uttered in no very dubious tone. I was so much astonished by the suddenness of the whole communication that I literally did not know what to say.


‘You are not in love?’ said my mother, turning sharply, and fixing her dark eyes upon me, with severe scrutiny.


‘No, madam,’ said I, promptly; horrified, as what young lady would not have been, at such a query.


‘I am glad to hear it,’ said my mother, *drily*. ‘Once, nearly twenty years ago, a friend of mine consulted me how he should deal with a daughter who had made what they call a love match, beggared herself, and disgraced her family; and I said, without hesitation, take no care of her, but cast her off; such punishment I awarded for an offence committed against the reputation of a family not my own; and what I advised respecting the child of another, with full as small compunction I would *do* with mine. I cannot conceive anything more unreasonable or intolerable than that the fortune and the character of a family should be marred by the idle caprices of a girl.’


She spoke this with great severity, and paused as if she expected some observation from me. I, however, said nothing.


‘But I need not explain to you, my dear Fanny,’ she continued, ‘my views upon this subject; you have always known them well, and I have never yet had reason to believe you likely, voluntarily, to offend me, or to abuse or neglect any of those advantages which reason and duty tell you should be improved—come hither, my dear; kiss me, and do not look so frightened. Well, now, about this letter, you need not answer it yet; of course you must be allowed time to make up your mind. In the meantime I will write to his lordship to give him my permission to visit us at Ashtown—good-night, my love.’


And thus ended one of the most disagreeable, not to say astounding, conversations I had ever had. It would not be easy to describe exactly what were my feelings towards Lord Glenfallen;— whatever might have been my mother's suspicions, my heart was perfectly disengaged—and hitherto, although I had not been made in the slightest degree acquainted with his real views, I had liked him very much, as an agreeable, well informed man, whom I was always glad to meet in society; he had served in the navy in early life, and the polish which his manners received in his after intercourse with courts and cities had not served to obliterate that frankness of *manner* which belongs proverbially to the sailor. Whether this apparent candour went deeper than the outward bearing, I was yet to learn; however, there was no doubt that, as far as I had seen of Lord Glenfallen, he was, though perhaps not so young as might have been desired in a lover, a singularly pleasing man, and





---

p.196




 whatever feeling unfavourable to him had found its way into my mind, arose altogether from the dread, not an unreasonable one, that constraint might be practised upon my inclinations. I reflected, however, that Lord Glenfallen was a wealthy man, and one highly thought of; and although I could never expect to love him in the romantic sense of the term, yet I had no doubt but that, all things considered, I might be more happy with him than I could hope to be at home. When next I met him it was with no small embarrassment, his tact and good breeding, however, soon reassured me, and effectually prevented my awkwardness being remarked upon; and I had the satisfaction of leaving Dublin for the country with the full conviction that nobody, not even those most intimate with me, even suspected the fact of Lord Glenfallen's having made me a formal proposal. This was to me a very serious subject of self gratulation, for, besides my instinctive dread of becoming the topic of the speculations of gossip, I felt that if the situation which I occupied in relation to him were made publicly known, I should stand committed in a manner which would scarcely leave me the power of retraction.


The period at which Lord Glenfallen had arranged to visit *Ashtown House* was now fast approaching, and it became my mother's wish to form me thoroughly to her will, and to obtain my consent to the proposed marriage before his arrival, so that all things might proceed smoothly, without apparent opposition or objection upon my part; 

whatever objections, therefore, I had entertained were to be subdued; whatever disposition to resistance I had exhibited or had been supposed to feel, were to be completely eradicated before he made his appearance, and my mother addressed herself to the task with a decision and energy against which even the barriers, which her imagination had created, could hardly have stood. If she had, however, expected any determined opposition from me, she was agreeably disappointed; my heart was perfectly free, and all my feelings of liking and preference were in favour of Lord Glenfallen; and I well knew that in case I refused to dispose of myself as I was desired, my mother had alike the power and the will to render my existence as utterly miserable as even the most ill-assorted marriage could possibly have done. You will remember, my good friend, that I was very young and very completely under the control of my parents, both of whom, my mother particularly, were unscrupulously determined in matters of this kind, and willing, when voluntary obedience on the part of those within their power was withheld, to compel a forced acquiescence by an unsparing use of all the engines of the most stern and rigorous domestic discipline. All these combined, not unnaturally, induced me to resolve upon yielding at once, and without useless opposition, to what appeared almost to be my fate. The appointed time was come, and my now accepted suitor arrived; he was in high spirits, and, if possible, more entertaining than ever. I was not, however, quite in the mood to enjoy his sprightliness; but whatever I wanted in gaiety was amply made up in the triumphant and gracious good humour of my mother, whose smiles of benevolence 





---

p.197




and exultation were showered around as bountifully as the summer sunshine. I will not weary you with unnecessary prolixity. Let it suffice to say, that I was married to Lord Glenfallen with all the attendant pomp and circumstance of wealth, rank, and grandeur. According to the usage of the times, now humanely reformed, the ceremony was made, until long past midnight, the season of wild, uproarious, and promiscuous feasting and revelry. Of all this I have a painfully vivid recollection, and particularly of the little annoyances inflicted upon me by the dull and coarse jokes of the wits and wags who abound in all such places, and upon all such occasions. I was not sorry, when, after a few days, Lord Glenfallen's carriage appeared at the door to convey us both from Ashtown; for any change would have been a relief from the irksomeness of ceremonial and formality which the visits received in honour of my newly-acquired titles hourly entailed upon me.


It was arranged that we were to proceed to Cahergillagh, one of the Glenfallen estates, lying, however, in a southern county, so that a tedious journey (then owing to the impracticability of the roads,) of three days intervened. I set forth with my noble companion, followed by the regrets of some, and by the envy of many, though God knows I little deserved the latter; the three days of travel were now almost spent, when passing the brow of a wild heathy hill, the domain of Cahergillagh opened suddenly upon our view. It formed a striking and a beautiful scene. A lake of considerable extent stretching away towards the west, and reflecting from its broad, smooth waters, the rich glow of the setting sun, was overhung by steep hills, covered by a rich mantle of velvet sward, broken here and there by the grey front of some old rock, and exhibiting on their shelving sides, their slopes and hollows, every variety of light and shade; a thick wood of dwarf oak, birch, and hazel skirted these hills, and clothed the shores of the lake, running out in rich luxuriance upon every promontory, and spreading upward considerably upon the side of the hills.


‘There lies the enchanted castle,’ said Lord Glenfallen, pointing towards a considerable level space intervening between two of the picturesque hills, which rose dimly around the lake. This little plain was chiefly occupied by the same low, wild wood which covered the other parts of the domain; but towards the centre a mass of taller and statelier forest trees stood darkly grouped together, and among them stood an ancient square tower, with many buildings of a humbler character, forming together the manor-house, or, as it was more usually called, the Court of Cahergillagh. As we approached the level upon which the mansion stood, the winding road gave us many glimpses of the time-worn castle and its surrounding buildings; and seen as it was through the long vistas of the fine old trees, and with the rich glow of evening upon it, I have seldom beheld an object more picturesquely striking. I was glad to perceive, too, that here and there the blue curling smoke ascended from stacks of chimneys now hidden by the rich, dark ivy, which, in a great measure, covered the building; other indications





---

p.198




 of comfort made themselves manifest as we approached; and indeed, though the place was evidently one of considerable antiquity, it had nothing whatever of the gloom of decay about it.


‘You must not, my love,’ said Lord Glenfallen, ‘imagine this place worse than it is. I have no taste for antiquity, at least I should not choose a house to reside in because it is old. Indeed I do not recollect that I was even so romantic as to overcome my aversion to rats and rheumatism, those faithful attendants upon your noble relics of feudalism; and I much prefer a snug, modern, unmysterious bedroom, with well-aired sheets, to the waving tapestry, mildewed cushions, and all the other interesting appliances of romance; however, though I cannot promise you all the discomfort generally pertaining to an old castle, you will find legends and ghostly lore enough to claim your respect; and if old Martha be still to the fore, as I trust she is, you will soon have a supernatural and appropriate anecdote for every closet and corner of the mansion; but here we are—so, without more ado, welcome to Cahergillagh.’


We now entered the hall of the castle, and while the domestics were employed in conveying our trunks and other luggage which we had brought with us for immediate use to the apartments which Lord Glenfallen had selected for himself and me, I went with him into a spacious sitting-room, wainscoted with finely polished black oak, and hung round with the portraits of various of the worthies of the Glenfallen family. This room looked out upon an extensive level covered with the softest green sward, and irregularly bounded by the wild wood I have before mentioned, through the leafy arcade formed by whose boughs and trunks the level beams of the setting sun were pouring; in the distance, a group of dairy maids were plying their task, which they accompanied throughout with snatches of Irish songs which, mellowed by the distance, floated not unpleasingly to the ear; and beside them sat or lay, with all the grave importance of conscious protection, six or seven large dogs of various kinds; farther in the distance, and through the cloisters of the arching wood, two or three ragged urchins were employed in driving such stray kine as had wandered farther than the rest to join their fellows. As I looked upon this scene which I have described, a feeling of tranquillity and happiness came upon me, which I have never experienced in so strong a degree; and so strange to me was the sensation that my eyes filled with tears. Lord Glenfallen mistook the cause of my emotion, and taking me kindly and tenderly by the hand, he said, ‘Do not suppose, my love, that it is my intention to *settle* here, whenever you desire to leave this, you have only to let me know your wish, and it shall be complied with, so I must entreat of you not to suffer any circumstances which I can *control* to give you one moment's uneasiness. But here is old Martha; you must be introduced to her, one of the heirlooms of our family.’


A hale, good-humoured, erect old woman was Martha, and an agreeable contrast to the grim, decrepid hag which my fancy had conjured





---

p.199




 up, as the depository of all the horrible tales in which I doubted not this old place was most fruitful. She welcomed me and her master with a profusion of gratulations, alternately kissing our hands and apologising for the liberty, until at length Lord Glenfallen put an end to this somewhat fatiguing ceremonial, by requesting her to conduct me to my chamber if it were prepared for my reception. I followed Martha up an old-fashioned oak stair-case into a long, dim passage, at the end of which lay the door which communicated with the apartments which had been selected for our use; here the old woman stopped, and respectfully requested me to proceed.


I accordingly opened the door and was about to enter, when something like a mass of black tapestry as it appeared disturbed by my sudden approach, fell from above the door, so as completely to screen the aperture; the startling unexpectedness of the occurrence, and the rustling noise which the drapery made in its descent, caused me involuntarily to step two or three paces backwards. I turned, smiling and half ashamed, to the old servant, and said, ‘You see what a coward I am.’ The woman looked puzzled, and without saying any more, I was about to draw aside the curtain and enter the room, when, upon turning to do so, I was surprised to find that nothing whatever interposed to obstruct the passage. I went into the room, followed by the servant woman, and was amazed to find that it, like the one below, was wainscoted, and that nothing like drapery was to be found near the door.


‘Where is it?’ said I; ‘what has become of it?’


‘What does your ladyship wish to know?’ said the old woman.


‘Where is the black curtain that fell across the door, when I attempted first to come to my chamber,’ answered I.


‘The cross of Christ about us,’ said the old woman, turning suddenly pale.


‘What is the matter, my good friend,’ said I; ‘you seem frightened.’


‘Oh, no, no, your ladyship,’ said the old woman, endeavouring to conceal her agitation; but in vain, for tottering towards a chair, she sank into it, looking so deadly pale and horror-struck that I thought every moment she would faint.


‘Merciful God, keep us from harm and danger!’ muttered she at length.


‘What can have terrified you so,’ said I, beginning to fear that she had seen something more than had met my eye, ‘you appear ill, my poor woman.’


‘Nothing, nothing, my lady,’ said she, rising; ‘I beg your ladyship's pardon for making so bold; may the great God defend us from misfortune.’


‘Martha,’ said I, ‘something *has* frightened you very much, and I insist on knowing what it is; your keeping me in the dark upon the subject will make me much more uneasy than *anything* you could tell me; I desire you, therefore, to let me know what agitates you; I command you to tell me.’




---

p.200


‘Your ladyship said you saw a black curtain falling across the door when you were coming into the room,’ said the old woman.


‘I did,’ said I; ‘but though the whole thing appears somewhat strange, I cannot see *anything* in the matter to agitate you so excessively.’


‘It's for no good you saw that, my lady,’ said the crone; ‘something terrible is coming; it's a sign, my lady—a sign that never fails.’


‘Explain, explain what you mean, my good woman,’ said I, in spite of myself, catching more than I could account for, of her superstitious terror.


‘Whenever something—something *bad* is going to happen to the Glenfallen family, some one that belongs to them sees a black handkerchief or curtain just waved or falling before their faces; I saw it myself,’ continued she, lowering her voice, ‘when I was only a little girl, and I'll never forget it; I often heard of it before, though I never saw it till then, nor since, praised be God; but I was going into Lady Jane's room to waken her in the morning; and sure enough when I got first to the bed and began to draw the curtain, something dark was waved across the division, but only for a moment; and when I saw rightly into the bed, there was she lying cold and dead, God be merciful to me; so, my lady, there is small blame to me to be daunted when any one of the family sees it; for it's many's the story I heard of it, though I saw it but once.’


I was not of a superstitious turn of mind, yet I could not resist a feeling of awe very nearly allied to the fear which my companion had so unreservedly expressed; and when you consider my situation, the loneliness, antiquity, and gloom of the place, you will allow that the weakness was not without excuse. 

In spite of old Martha's boding predictions, however, time flowed on in an unruffled course; one little incident, however, though trifling in itself, I must relate, as it serves to make what follows more intelligible. Upon the day after my arrival, Lord Glenfallen of course desired to make me acquainted with the house and domain; and accordingly we set forth upon our ramble; when returning, he became for some time silent and moody, a state so unusual with him as considerably to excite my surprise, I endeavoured by observations and questions to arouse him—but in vain; at length, as we approached the house, he said, as if speaking to himself, ‘'twere madness—madness—madness,’ repeating the word bitterly—‘sure and speedy ruin.’ There was here a long pause; and at length turning sharply towards me in a tone very unlike that in which he had hitherto addressed me, he said, ‘Do you think it possible that a woman can keep a secret?’


‘I am sure,’ said I, ‘that women are very much belied upon the score of talkativeness, and that I may answer your question with the same directness with which you put it—I reply that I *do* think a woman can keep a secret.’


‘But I do not,’ said he, drily.


We walked on in silence for a time. I was much astonished at his unwonted





---

p.201




 abruptness—I had almost said rudeness. After a considerable pause he seemed to recollect himself, and with an effort resuming his sprightly manner, he said, ‘well, well, the next thing to keeping a secret well is, not to desire to possess one—talkativeness and curiosity generally go together; now I shall make test of you in the first place, respecting the latter of these qualities. I shall be your *Bluebeard*—tush, why do I trifle thus; listen to me, my dear Fanny; I speak now in solemn earnest; what I desire is, intimately, inseparably, connected with your happiness and honour as well as my own; and your compliance with my request will not be difficult; it will impose upon you a very trifling restraint during your sojourn here, which certain events which have occurred since our arrival, have determined me shall not be a long one. You must promise me, upon your sacred honour, that you will visit *only* that part of the castle which can be reached from the front entrance, leaving the back entrance and the part of the building commanded immediately by it, to the menials, as also the small garden whose high wall you see yonder; and never at any time seek to pry or peep into them, nor to open the door which communicates from the front part of the house through the corridor with the back. I do not urge this in jest or in caprice, but from a solemn conviction that danger and misery will be the certain consequences of your not observing what I prescribe. I cannot explain myself further at present—promise me, then, these things as you hope for peace here and for mercy hereafter.’


I did make the promise as desired, and he appeared relieved; his manner recovered all its gaiety and elasticity, but the recollection of the strange scene which I have just described dwelt painfully upon my mind. More than a month passed away without any occurrence worth recording; but I was not destined to leave Cahergillagh without further adventure; one day, intending to enjoy the pleasant sunshine in a ramble through the woods, I ran up to my room to procure my bonnet and shawl; upon entering the chamber, I was surprised and somewhat startled to find it occupied; beside the fireplace and nearly opposite the door, seated in a large, old-fashioned elbow-chair, was placed the figure of a lady; she appeared to be nearer fifty than forty, and was dressed suitably to her age, in a handsome suit of flowered silk; she had a profusion of trinkets and jewellery about her person, and many rings upon her fingers; but although very rich, her dress was not gaudy or in ill taste; but what was remarkable in the lady was, that although her features were handsome, and upon the whole pleasing, the pupil of each eye was dimmed with the whiteness of cataract, and she was evidently stone blind. I was for some seconds so surprised at this unaccountable apparition, that I could not find words to address her.


‘Madam,’ said I, ‘there must be some mistake here—this is my bed-chamber.’


‘Marry come up,’ said the lady, sharply; ‘*your* chamber! Where is Lord Glenfallen?’




---

p.202


‘He is below, madam,’ replied I; ‘and I am convinced he will be not a little surprised to find you here.’


‘I do not think he will,’ said she; ‘with your good leave, talk of what you know something about; tell him I want him; why does the minx *dilly-dally* so?’


In spite of the awe which this grim lady inspired, there was something in her air of confident superiority which, when I considered our relative situations, was not a little irritating.


‘Do you know, madam, to whom you speak?’ said I.


‘I neither know nor care,’ said she; ‘but I presume that you are some one about the house, so, again, I desire you, if you wish to continue here, to bring your master hither forthwith.’


‘I must tell you, madam,’ said I, ‘that I am Lady Glenfallen.’


‘What's that?’ said the stranger, rapidly.


‘I say, madam,’ I repeated, approaching her, that I might be more distinctly heard, ‘that I am Lady Glenfallen.’


‘It's a lie, you trull!’ cried she, in an accent which made me start, and, at the same time, springing forward, she seized me in her grasp, and shook me violently, repeating, ‘It's a lie—it's a lie!’ with a rapidity and vehemence which swelled every vein of her face; the violence of her action, and the fury which convulsed her face, effectually terrified me, and disengaging myself from her grasp, I screamed as loud as I could for help; the blind woman continued to pour out a torrent of abuse upon me, foaming at the mouth with rage, and impotently shaking her clenched fists towards me.


I heard Lord Glenfallen's step upon the stairs, and I instantly ran out; as I passed him I perceived that he was deadly pale, and just caught the words: ‘I hope that demon has not hurt you?’


I made some answer, I forget what, and he entered the chamber, the door of which he locked upon the inside; what passed within I know not; but I heard the voices of the two speakers raised in loud and angry altercation.


I thought I heard the shrill accents of the woman repeat the words, ‘Let her look to herself’; but I could not be quite sure. This short sentence, however, was, to my alarmed imagination, pregnant with fearful meaning; the storm at length subsided, though not until after a conference of more than two long hours. Lord Glenfallen then returned, pale and agitated. ‘That unfortunate woman,’ said he, ‘is out of her mind; I dare say she treated you to some of her ravings, but you need not dread any further interruption from her, I have brought her so far to reason. She did not hurt you, I trust.’


‘No, no,’ said I; ‘but she terrified me beyond measure.’ ‘Well,’ said he, ‘she is likely to behave better for the future; and I dare swear that neither you nor she would desire, after what has passed, to meet again.’


This occurrence, so startling and unpleasant, so involved in mystery, and giving rise to so many painful surmises, afforded me no very agreeable food for rumination. All attempts on my part to arrive at the truth were baffled; Lord Glenfallen evaded all my inquiries, and at length





---

p.203




 peremptorily forbid any further allusion to the matter. I was thus obliged to rest satisfied with what I had actually seen, and to trust to time to resolve the perplexities in which the whole transaction had involved me. Lord Glenfallen's temper and spirits gradually underwent a complete and most painful change; he became silent and abstracted, his manner to me was abrupt and often harsh, some grievous anxiety seemed ever present to his mind; and under its influence his spirits sunk and his temper became soured. I soon perceived that his gaiety was rather that which the stir and excitement of society produces, than the result of a healthy habit of mind; every day confirmed me in the opinion, that the considerate good nature which I had so much admired in him was little more than a mere manner; and to my infinite grief and surprise, the gay, kind, open-hearted nobleman who had for months followed and flattered me, was rapidly assuming the form of a gloomy, morose, and singularly selfish man; this was a bitter discovery, and I strove to conceal it from myself as long as I could, but the truth was not to be denied, and I was forced to believe that Lord Glenfallen no longer loved me, and that he was at little pains to conceal the alteration in his sentiments. One morning after breakfast, Lord Glenfallen had been for some time walking silently up and down the room, buried in his moody reflections, when pausing suddenly, and turning towards me, he exclaimed, ‘I have it—I have it! We must go abroad, and stay there, too; and if that does not answer, why—why, we must try some more effectual expedient. Lady Glenfallen, I have become involved in heavy embarrassments; a wife, you know, must share the fortunes of her husband, for better for worse; but I will waive my right if you prefer remaining here—here at Cahergillagh; for I would not have you seen elsewhere without the state to which your rank entitled you; besides it would break your poor mother's heart,’ he added, with sneering gravity, ‘so make up your mind— Cahergillagh or France. I will start if possible in a week, so determine between this and then.’


He left the room, and in a few moments I saw him ride past the window, followed by a mounted servant. He had directed a domestic to inform me that he should not be back until the next day. I was in very great doubt as to what course of conduct I should pursue, as to accompanying him in the continental tour so suddenly determined upon. I felt that it would be a hazard too great to encounter; for at Cahergillagh I had always the consciousness to sustain me, that if his temper at any time led him into violent or unwarrantable treatment of me, I had a remedy within reach, in the protection and support of my own family, from all useful and effective communication with whom, if once in France, I should be entirely debarred. As to remaining at Cahergillagh in solitude, and for aught I knew, exposed to hidden dangers, it appeared to me scarcely less objectionable than the former proposition; and yet I feared that with one or other I must comply, unless I was prepared to come to an actual breach with Lord Glenfallen; full of these





---

p.204




 unpleasing doubts and perplexities, I retired to rest. I was wakened, after having slept uneasily for some hours, by some person shaking me rudely by the shoulder; a small lamp burned in my room, and by its light, to my horror and amazement, I discovered that my visitant was the self-same blind old lady who had so terrified me a few weeks before. I started up in the bed, with a view to ring the bell, and alarm the domestics; but she instantly anticipated me by saying, ‘Do not be frightened, silly girl; if I had wished to harm you I could have done it while you were sleeping, I need not have wakened you; listen to me, now, attentively and fearlessly; for what I have to say, interests you to the full as much as it does me; tell me here, in the presence of God, did Lord Glenfallen marry you, *actually marry* you?—speak the truth, woman.’


‘As surely as I live and speak,’ I replied, ‘did Lord Glenfallen marry me, in presence of more than a hundred witnesses.’


‘Well,’ continued she, ‘he should have told you *then*, before you married him, that he had a wife living, which wife I am; I feel you tremble—tush! do not be frightened. I do not mean to harm you—mark me now—you are *not* his wife. When I make my story known you will be so, neither in the eye of God nor of man; you must leave this house upon to-morrow; let the world know that your husband has another wife living; go, you, into retirement, and leave him to justice, which will surely overtake him. If you remain in this house after to-morrow you will reap the bitter fruits of your sin,’ so saying, she quitted the room, leaving me very little disposed to sleep.


Here was food for my very worst and most terrible suspicions; still there was not enough to remove all doubt. I had no proof of the truth of this woman's statement. Taken by itself there was nothing to induce me to attach weight to it; but when I viewed it in connection with the extraordinary mystery of some of Lord Glenfallen's proceedings, his strange anxiety to exclude me from certain portions of the mansion, doubtless lest I should encounter this person—the strong influence, nay, command, which she possessed over him, a circumstance clearly established by the very fact of her residing in the very place where, of all others, he should least have desired to find her—her thus acting, and continuing to act in direct contradiction to his wishes; when, I say, I viewed her disclosure in connection with all these circumstances, I could not help feeling that there was at least a fearful veri-similitude in the allegations which she had made. Still I was not satisfied, nor nearly so; young minds have a reluctance almost insurmountable to believing upon *anything* short of unquestionable proof, the existence of premeditated guilt in *anyone* whom they have ever trusted; and in support of this feeling I was assured that if the assertion of Lord Glenfallen, which nothing in this woman's manner had led me to disbelieve, were true, namely, that her mind was unsound, the whole fabric of my doubts and fears must fall to the ground. I determined to state to Lord Glenfallen freely and accurately the substance of the communication which I had just heard, and in his words and looks to seek for its proof or refutation;





---

p.205




full of these thoughts I remained wakeful and excited all night, every moment fancying that I heard the step, or saw the figure of my recent visitor towards whom I felt a species of horror and dread which I can hardly describe. There was something in her face, though her features had evidently been handsome, and were not, at first sight, unpleasing, which, upon a nearer inspection, seemed to indicate the habitual prevalence and indulgence of evil passions, and a power of expressing mere animal anger, with an intenseness that I have seldom seen equalled, and to which an almost unearthly effect was given by the convulsive quivering of the sightless eyes. You may easily suppose that it was no very pleasing reflection to me to consider, that, whenever caprice might induce her to return, I was within the reach of this violent, and, for aught I knew, insane woman, who had, upon that very night, spoken to me in a tone of menace, of which her mere words, divested of the manner and look with which she uttered them, can convey but a faint idea. Will you believe me when I tell you that I was actually afraid to leave my bed in order to secure the door, lest I should again encounter the dreadful object lurking in some corner or peeping from behind the window curtains, so very a child was I in my fears.


The morning came, and with it Lord Glenfallen. I knew not, and indeed I cared not, where he might have been; my thoughts were wholly engrossed by the terrible fears and suspicions which my last night's conference had suggested to me; he was, as usual, gloomy and abstracted, and I feared in no very fitting mood to hear what I had to say with patience, whether the charges were true or false. I was, however, determined not to suffer the opportunity to pass, or Lord Glenfallen to leave the room, until, at all hazards, I had unburdened my mind.


‘My Lord,’ said I, after a long silence, summoning up all my firmness, ‘my lord, I wish to say a few words to you upon a matter of very great importance, of very deep concernment to you and to me.’ I fixed my eyes upon him to discern, if possible, whether the announcement caused him any uneasiness, but no symptom of any such feeling was perceptible.


‘Well, my dear,’ said he, ‘this is, no doubt, a very grave preface, and portends, I have no doubt, something extraordinary—pray let us have it without more ado.’


He took a chair, and seated himself nearly opposite to me.


‘My lord,’ said I, ‘I have seen the person who alarmed me so much a short time since, the blind lady, again, upon last night;’ his face, upon which my eyes were fixed, turned pale; he hesitated for a moment, and then said—


‘And did you, pray, madam, so totally forget or spurn my express command, as to enter that portion of the house from which your promise, I might say, your oath, excluded you?—answer me that?’ he added fiercely.


‘My lord,’ said I, ‘I have neither forgotten your *commands*, since such they were, nor disobeyed them. I was, last night, wakened from my sleep, as I lay in my own chamber, and accosted by the person 





---

p.206




whom I have mentioned—how she found access to the room I cannot pretend to say.’


‘Ha! this must be looked to,’ said he, half reflectively; ‘and pray,’ added he, quickly, while in turn he fixed his eyes upon me, ‘what did this person say, since some comment upon her communication forms, no doubt, the sequel to your preface.’


‘Your lordship is not mistaken,’ said I; ‘her statement was so extraordinary that I could not think of withholding it from you. She told me, my lord, that you had a wife living at the time you married me, and that she was that wife.’


Lord Glenfallen became ashy pale, almost livid; he made two or three efforts to clear his voice to speak, but in vain, and turning suddenly from me, he walked to the window; the horror and dismay which, in the olden time, overwhelmed the woman of Endor when her spells unexpectedly conjured the dead into her presence, were but types of what I felt, when thus presented with what appeared to be almost unequivocal evidence of the guilt, whose existence I had before so strongly doubted. There was a silence of some moments, during which it were hard to conjecture whether I or my companion suffered most. Lord Glenfallen soon recovered his self-command; he returned to the table, again sat down and said—


‘What you have told me has so astonished me, has unfolded such a tissue of motiveless guilt, and in a quarter from which I had so little reason to look for ingratitude or treachery, that your announcement almost deprived me of speech; the person in question, however, has one excuse, her mind is, as I told you before, unsettled. You should have remembered that, and hesitated to receive as unexceptionable evidence against the honour of your husband, the ravings of a lunatic. I now tell you that this is the last time I shall speak to you upon this subject, and, in the presence of the God who is to judge me, and as I hope for mercy in the day of judgment, I swear that the charge thus brought against me, is utterly false, unfounded, and ridiculous; I defy the world in any point to taint my honour; and, as I have never taken the opinion of madmen touching your character or morals, I think it but fair to require that you will evince a like tenderness for me; and now, once for all, never again dare to repeat to me your insulting suspicions, or the clumsy and infamous calumnies of fools. I shall instantly let the worthy lady who contrived this somewhat original device, understand fully my opinion upon the matter—good morning’; and with these words he left me again in doubt, and involved in all horrors of the most agonizing suspense. I had reason to think that Lord Glenfallen wreaked his vengeance upon the author of the strange story which I had heard, with a violence which was not satisfied with mere words, for old Martha, with whom I was a great favourite, while attending me in my room, told me that she feared her master had ill-used the poor, blind, Dutch woman, for that she had heard her scream as if the very life were leaving her, but added a request that I should not speak of what she had told me to any one, particularly to the master.




---

p.207


‘How do you know that she is a Dutch woman?’ inquired I, anxious to learn anything whatever that might throw a light upon the history of this person, who seemed to have resolved to mix herself up in my fortunes.


‘Why, my lady,’ answered Martha, ‘the master often calls her the Dutch hag, and other names you would not like to hear, and I am sure she is neither English nor Irish; for, whenever they talk together, they speak some queer foreign lingo, and fast enough, I'll be bound; but I ought not to talk about her at all; it might be as much as my place is worth to mention her—only you saw her first yourself, so there can be no great harm in speaking of her now.’


‘How long has this lady been here?’ continued I.


‘She came early on the morning after your ladyship's arrival,’ answered she; ‘but do not ask me any more, for the master would think nothing of turning me out of doors for daring to speak of her at all, much less to /you#, my lady.’


I did not like to press the poor woman further; for her reluctance to speak on this topic was evident and strong. You will readily believe that upon the very slight grounds which my information afforded, contradicted as it was by the solemn oath of my husband, and derived from what was, at best, a very questionable source, I could not take any very decisive measure whatever; and as to the menace of the strange woman who had thus unaccountably twice intruded herself into my chamber, although, at the moment, it occasioned me some uneasiness, it was not, even in my eyes, sufficiently formidable to induce my departure from Cahergillagh.


A few nights after the scene which I have just mentioned, Lord Glenfallen having, as usual, early retired to his study, I was left alone in the parlour to amuse myself as best I might. It was not strange that my thoughts should often recur to the agitating scenes in which I had recently taken a part; the subject of my reflections, the solitude, the silence, and the lateness of the hour, as also the depression of spirits to which I had of late been a constant prey, tended to produce that nervous excitement which places us wholly at the mercy of the imagination. In order to calm my spirits, I was endeavouring to direct my thoughts into some more pleasing channel, when I heard, or thought I heard, uttered, within a few yards of me, in an odd, half-sneering tone, the words, ‘There is blood upon your ladyship's throat.’ So vivid was the impression that, I started to my feet, and involuntarily placed my hand upon my neck. I looked around the room for the speaker, but in vain. I went then to the room-door, which I opened, and peered into the passage, nearly faint with horror, lest some leering, shapeless thing should greet me upon the threshold. When I had gazed long enough to assure myself that no strange object was within sight, ‘I have been too much of a rake, lately; I am racking out my nerves,’ said I, speaking aloud, with a view to reassure myself. I rang the bell, and, attended by old Martha, I retired to settle for the night. While the servant was, as was her custom, arranging the lamp which I have





---

p.208




 already stated always burned during the night in my chamber, I was employed in undressing, and, in doing so, I had recourse to a large looking-glass which occupied a considerable portion of the wall in which it was fixed, rising from the ground to a height of about six feet; this mirror filled the space of a large *panel* in the wainscoting opposite the foot of the bed. I had hardly been before it for the lapse of a minute, when something like a black pall was slowly waved between me and it.


‘Oh, God! there it is,’ I exclaimed wildly. ‘I have seen it again, Martha—the black cloth.’


‘God be merciful to us, then!’ answered she, tremulously crossing herself. ‘Some misfortune is over us.’


‘No, no, Martha,’ said I, almost instantly recovering my collectedness; for, although of a nervous temperament, I had never been superstitious. ‘I do not believe in omens. You know, I saw, or fancied I saw, this thing before, and nothing followed.’


‘The Dutch lady came the next morning,’ replied she.


‘Methinks, such an occurrence scarcely deserved a supernatural announcement,’ I replied.


‘She is a strange woman, my lady,’ said Martha; ‘and she is not *gone* yet—mark my words.’


‘Well, well, Martha,’ said I, ‘I have not wit enough to change your opinions, nor inclination to alter mine; so I will talk no more of the matter. Good night,’ and so I was left to my reflections. After lying for about an hour awake, I at length fell into a kind of doze; but my imagination was still busy, for I was startled from this unrefreshing sleep by fancying that I heard a voice close to my face exclaim as before, ‘There is blood upon your ladyship's throat.’ The words were instantly followed by a loud burst of laughter. Quaking with horror, I awakened, and heard my husband enter the room. Even this was a relief. Scared as I was, however, by the tricks which my imagination had played me, I preferred remaining silent, and pretending to sleep, to attempting to engage my husband in conversation, for I well knew that his mood was such, that his words would not, in all probability, convey anything that had not better be unsaid and unheard.


Lord Glenfallen went into his dressing-room, which lay upon the right-hand side of the bed. The door lying open, I could see him by himself, at full length upon a sofa, and, in about half an hour, I became aware, by his deep and regularly drawn respiration, that he was fast asleep. When slumber refuses to visit one, there is something peculiarly irritating, not to the temper, but to the nerves, in the consciousness that some one is in your immediate presence, actually enjoying the boon which you are seeking in vain; at least, I have always found it so, and never more than upon the present occasion. A thousand annoying imaginations harassed and excited me; every object which I looked upon, though ever so familiar, seemed to have acquired a strange phantom-like character, the varying shadows thrown by the flickering of the lamp-light, seemed shaping themselves into grotesque and unearthly forms, and whenever my eyes





---

p.209




 wandered to the sleeping figure of my husband, his features appeared to undergo the strangest and most demoniacal contortions. Hour after hour was told by the old clock, and each succeeding one found me, if possible, less inclined to sleep than its predecessor. It was now considerably past three; my eyes, in their involuntary wanderings, happened to alight upon the large mirror which was, as I have said, fixed in the wall opposite the foot of the bed. A view of it was commanded from where I lay, through the curtains, as I gazed fixedly upon it, I thought I perceived the broad sheet of glass shifting its position in relation to the bed; I riveted my eyes upon it with intense scrutiny; it was no deception, the mirror, as if acting of its own impulse moved slowly aside, and disclosed a dark aperture in the wall, nearly as large as an ordinary door; a figure evidently stood in this; but the light was too dim to define it accurately. It stepped cautiously into the chamber, and with so little noise, that had I not actually seen it, I do not think I should have been aware of its presence. It was arrayed in a kind of woollen night-dress, and a white handkerchief or cloth was bound tightly about the head; I had no difficulty spite of the strangeness of the attire in recognising the blind woman whom I so much dreaded. She stooped down, bringing her head nearly to the ground, and in that attitude she remained motionless for some moments, no doubt in order to ascertain if any suspicious sound were stirring. She was apparently satisfied by her observations, for she immediately recommenced her silent progress towards a ponderous mahogany dressing table of my husband's; when she had reached it, she paused again, and appeared to listen attentively for some minutes; she then noiselessly opened one of the drawers, from which, having groped for some time, she took something which I soon perceived to be a case of razors; she opened it and tried the edge of each of the two instruments upon the skin of her hand; she quickly selected one, which she fixed firmly in her grasp; she now stooped down as before, and having listened for a time, she, with the hand that was disengaged, groped her way into the dressing room where Lord Glenfallen lay fast asleep. I was fixed as if in the tremendous spell of a *nightmare*. I could not stir even a finger; I could not lift my voice; I could not even breathe, and though I expected every moment to see the sleeping man murdered, I could not even close my eyes to shut out the horrible spectacle, which I had not the power to avert. I saw the woman approach the sleeping figure, she laid the unoccupied hand lightly along his clothes, and having thus ascertained his identity, she, after a brief interval, turned back and again entered my chamber; here she bent down again to listen.


I had now not a doubt but that the razor was intended for my throat; yet the terrific fascination which had locked all my powers so long, still continued to bind me fast. I felt that my life depended upon the slightest ordinary exertion, and yet I could not stir one joint from the position in which I lay, nor even make noise enough to waken Lord Glenfallen. The murderous woman now, with long, silent steps, approached the bed; my very heart seemed turning to





---

p.210




 ice; her left hand, that which was disengaged, was upon the pillow; she gradually slid it forward towards my head, and in an instant, with the speed of lightning, it was clutched in my hair, while, with the other hand, she dashed the razor at my throat. A slight inaccuracy saved me from instant death; the blow fell short, the point of the razor grazing my throat; in a moment I know not how, I found myself at the other side of the bed uttering shriek after shriek; the wretch was, however, determined if possible to murder me; scrambling along by the curtains, she rushed round the bed towards me; I seized the handle of the door to make my escape; it was, however, fastened; at all events, I could not open it; from the mere instinct of recoiling terror, I shrunk back into a corner—she was now within a yard of me—he hand was upon my face—I closed my eyes fast, expecting never to open them again, when a blow, inflicted from behind by a strong arm, stretched the monster senseless at my feet; at the same moment the door opened, and several domestics, alarmed by my cries, entered the apartment.


I do not recollect what followed, for I fainted. One swoon succeeded another, so long and death-like, that my life was considered very doubtful. At about ten o'clock, however, I sunk into a deep and refreshing sleep, from which I was awakened at about two, that I might swear my deposition before a magistrate, who attended for that purpose. I, accordingly, did so, as did also Lord Glenfallen, and the woman was fully committed to stand her trial at the ensuing assizes. I shall never forget the scene which the examination of the blind woman and of the other parties afforded.


She was brought into the room in the custody of two servants; she wore a kind of flannel wrapper which had not been changed since the night before; it was torn and soiled, and here and there smeared with blood, which had flowed in large quantities from a wound in her head; the white handkerchief had fallen off in the scuffle; and her grizzled hair fell in masses about her wild and deadly pale countenance.


She appeared perfectly composed, however, and the only regret she expressed throughout, was at not having succeeded in her attempt, the object of which she did not pretend to conceal. On being asked her name, she called herself the Countess Glenfallen, and refused to give any other title.


‘The woman's name is Flora Van-Kemp,’ said Lord Glenfallen.


‘It *was*, it *was*, you perjured traitor and cheat,’ screamed the woman; and then there followed a volley of words in some foreign language. ‘Is there a magistrate here?’ she resumed; ‘I am Lord Glenfallen's wife—I'll prove it—write down my words. I am willing to be hanged or burned, so *he* meets his deserts. I did try to kill that doll of his; but it was he who put it into my head to do it—two wives were too many;—I was to murder her, or she was to hang me—listen to all I have to say.’


Here Lord Glenfallen interrupted.


‘I think, sir,’ said he, addressing the magistrate, ‘that we had better proceed to business; this unhappy woman's furious recriminations but





---

p.211




waste our time; if she refuses to answer your questions, you had better, I presume, take my depositions.’


‘And are you going to swear away my life, you black perjured murderer?’ shrieked the woman. ‘Sir, sir, sir, you must hear me,’ she continued, addressing the magistrate; ‘I can convict him—he bid me murder that girl, and then, when I failed, he came behind me, and struck me down, and now he wants to swear away my life—take down all I say.’


‘If it is your intention,’ said the magistrate, ‘to confess the crime with which you stand charged, you may, upon producing sufficient evidence, criminate whom you please.’


‘Evidence!—I have no evidence but myself,’ said the woman. ‘I will swear it all—write down my testimony—write it down, I say—we shall hang side by side, my brave Lord—all your own handy-work, my gentle husband.’ This was followed by a low, insolent, and sneering laugh, which, from one in her situation, was sufficiently horrible.


‘I will not at present hear anything,’ replied he, ‘but distinct answers to the questions which I shall put to you upon this matter.’


‘Then you shall hear nothing,’ replied she sullenly, and no inducement or intimidation could bring her to speak again.


Lord Glenfallen's deposition and mine were then given, as also those of the servants who had entered the room at the moment of my rescue; the magistrate then intimated that she was committed, and must proceed directly to gaol, whither she was brought in a carriage of Lord Glenfallen's, for his lordship was naturally by no means indifferent to the effect which her vehement accusations against himself might produce, if uttered before every chance hearer whom she might meet with between Cahergillagh and the place of confinement whither she was despatched.


During the time which intervened between the committal and the trial of the prisoner, Lord Glenfallen seemed to suffer agonies of mind which baffle all description, he hardly ever slept, and when he did, his slumbers seemed but the instruments of new tortures, and his waking hours were, if possible, exceeded in intensity of terrors by the dreams which disturbed his sleep. Lord Glenfallen rested, if to lie in the mere attitude of repose were to do so, in his dressing-room, and thus I had an opportunity of witnessing, far oftener than I wished it, the fearful workings of his mind; his agony often broke out into such fearful paroxysms that delirium and total loss of reason appeared to be impending; he frequently spoke of flying from the country, and bringing with him all the witnesses of the appalling scene upon which the prosecution was founded; then again he would fiercely lament that the blow which he had inflicted had not ended all.


The assizes arrived, however, and upon the day appointed, Lord Glenfallen and I attended in order to give our evidence. The cause was called on, and the prisoner appeared at the bar. Great curiosity and interest were felt respecting the trial, so that the court was crowded to excess.





---

p.212




The prisoner, however, without appearing to take the trouble of listening to the indictment, pleaded guilty, and no representations on the part of the court availed to induce her to retract her plea. After much time had been wasted in a fruitless attempt to prevail upon her to reconsider her words, the court proceeded, according to the usual form, to pass sentence. This having been done, the prisoner was about to be removed, when she said, in a low, distinct voice—


‘A word—a word, my Lord:—is Lord Glenfallen here in the court?’ On being told that he was, she raised her voice to a tone of loud menace, and continued—


‘Hardress, Earl of Glenfallen, I accuse you here in this court of justice of two crimes,—first, that you married a second wife, while the first was living; and again, that you prompted me to the murder, for attempting which I am to die—secure him—chain him—bring him here.’


There was a laugh through the court at these words, which were naturally treated by the judge as a violent extemporary recrimination, and the woman was desired to be silent.


‘You won't take him, then?’ she said; ‘you won't try him? You'll let him go free?’


It was intimated by the court that he would certainly be allowed ‘to go free,’ and she was ordered again to be removed. Before, however, the mandate was executed, she threw her arms wildly into the air, and uttered one piercing shriek so full of preternatural rage and despair, that it might fitly have ushered a soul into those realms where hope can come no more. The sound still rang in my ears, months after the voice that had uttered it was for ever silent. The wretched woman was executed in accordance with the sentence which had been pronounced.


For some time after this event, Lord Glenfallen appeared, if possible, to suffer more than he had done before, and altogether his language, which often amounted to half confessions of the guilt imputed to him, and all the circumstances connected with the late occurrences, formed a mass of evidence so convincing that I wrote to my father, detailing the grounds of my fears, and imploring him to come to Cahergillagh without delay, in order to remove me from my husband's control, previously to taking legal steps for a final separation. Circumstanced as I was, my existence was little short of intolerable, for, besides the fearful suspicions which attached to my husband, I plainly perceived that if Lord Glenfallen were not relieved, and that speedily, insanity must supervene. I therefore expected my father's arrival, or at least a letter to announce it, with indescribable impatience.


About a week after the execution had taken place, Lord Glenfallen one morning met me with an unusually sprightly air—


‘Fanny,’ said he, ‘I have it now for the first time in my power to explain to your satisfaction every thing which has hitherto appeared suspicious or mysterious in my conduct. After breakfast come with me to my study, and I shall, I hope, make all things clear.’




---

p.213


This invitation afforded me more real pleasure than I had experienced for months; something had certainly occurred to tranquillize my husband's mind, in no ordinary degree, and I thought it by no means impossible that he would, in the proposed interview, prove himself the most injured and innocent of men. Full of this hope I repaired to his study at the appointed hour; he was writing busily when I entered the room, and just raising his eyes, he requested me to be seated. I took a chair as he desired, and remained silently awaiting his leisure, while he finished, folded, directed, and sealed his letter; laying it then upon the table with the address downward, he said—


‘My dearest Fanny, I know I must have appeared very strange to you and very unkind—often even cruel; before the end of this week I will show you the necessity of my conduct—how impossible it was that I should have seemed otherwise. I am conscious that many acts of mine must have inevitably given rise to painful suspicions—suspicions which, indeed, upon one occasion, you very properly communicated to me. I have gotten two letters from a quarter which commands respect, containing information as to the course by which I may be enabled to prove the negative of all the crimes which even the most credulous suspicion could lay to my charge. I expected a third by this morning's post, containing documents which will set the matter for ever at rest, but owing, no doubt, to some neglect, or, perhaps, to some difficulty in collecting the papers, some inevitable delay, it has not come to hand this morning, according to my expectation. I was finishing one to the very same quarter when you came in, and if a sound rousing be worth anything, I think I shall have a special messenger before two days have passed. I have been thinking over the matter within myself, whether I had better imperfectly clear up your doubts by submitting to your inspection the two letters which I have already received, or wait till I can triumphantly vindicate myself by the production of the documents which I have already mentioned, and I have, I think, not unnaturally decided upon the latter course; however, there is a person in the next room, whose testimony is not without its value—excuse me for one moment.’


So saying, he arose and went to the door of a closet which opened from the study; this he unlocked, and half opening the door, he said, ‘It is only I,’ and then slipped into the room and carefully closed and locked the door behind him.


I immediately heard his voice in animated conversation; my curiosity upon the subject of the letter was naturally great, so, smothering any little scruples which I might have felt, I resolved to look at the address of the letter which lay, as my husband had left it, with its face upon the table. I accordingly drew it over to me and turned up the direction. For two or three moments I could scarce believe my eyes, but there could be no mistake—in large characters were traced the words, ‘To the Archangel Gabriel in Heaven.’


I had scarcely returned the letter to its original position, and in some degree recovered the shock which this unequivocal proof of insanity produced, when the closet door was unlocked, and Lord Glenfallen re-entered the





---

p.214




 study, carefully closing and locking the door again upon the outside.


‘Whom have you there?’ inquired I, making a strong effort to appear calm.


‘Perhaps,’ said he musingly, ‘you might have some objection to seeing her, at least for a time.’


‘Who is it?’ repeated I.


‘Why,’ said he, ‘I see no use in hiding it—the blind Dutchwoman; I have been with her the whole morning. She is very anxious to get out of that closet; but you know she is odd, she is scarcely to be trusted.’


A heavy gust of wind shook the door at this moment with a sound as if something more substantial were pushing against it.


‘Ha, ha, ha!—do you hear her?’ said he, with an obstreperous burst of laughter. The wind died away in a long howl, and Lord Glenfallen, suddenly checking his merriment, shrugged his shoulders, and muttered—


‘Poor devil, she has been hardly used.’


‘We had better not tease her at present with questions,’ said I, in as unconcerned a tone as I could assume, although I felt every moment as if I should faint.


‘Humph! may be so,’ said he. ‘well, come back in an hour or two, or when you please, and you will find us here.’


He again unlocked the door, and entered with the same precautions which he had adopted before, locking the door upon the inside, and as I hurried from the room, I heard his voice again exerted as if in eager parley. I can hardly describe my emotions; my hopes had been raised to the highest, and now in an instant, all was gone—the dreadful consummation was accomplished—the fearful retribution had fallen upon the guilty man—the mind was destroyed—the power to repent was gone. The agony of the hours which followed what I would still call my *awful* interview with Lord Glenfallen, I cannot describe; my solitude was, however, broken in upon by Martha, who came to inform me of the arrival of a gentleman, who expected me in the parlour. I accordingly descended, and, to my great joy, found my father seated by the fire. This expedition, upon his part, was easily accounted for: my communications had touched the honour of the family. I speedily informed him of the dreadful malady which had fallen upon the wretched man.


My father suggested the necessity of placing some person to watch him, to prevent his injuring himself or others. I rang the bell, and desired that one Edward Cooke, an attached servant of the family, should be sent to me. I told him distinctly and briefly the nature of the service required of him, and, attended by him, my father and I proceeded at once to the study; the door of the inner room was still closed, and everything in the outer chamber remained in the same order in which I had left it. We then advanced to the closet door, at which we knocked, but without receiving any answer. We next tried to open the door, but in vain—it was locked upon the inside; we knocked more loudly, but in vain. Seriously alarmed, I desired the servant to force the door, which





---

p.215




was, after several violent efforts, accomplished, and we entered the closet. Lord Glenfallen was lying on his face upon a sofa.


‘Hush,’ said I, ‘he is asleep’; we paused for a moment.


‘He is too still for that,’ said my father; we all of us felt a strong reluctance to approach the figure.


‘Edward,’ said I, ‘try whether your master sleeps.’


The servant approached the sofa where Lord Glenfallen lay; he leant his ear towards the head of the recumbent figure, to ascertain whether the sound of breathing was audible; he turned towards us, and said—


‘My lady, you had better not wait here; I am sure he is dead!’


‘Let me see the face,’ said I, terribly agitated, ‘you *may* be mistaken.’


The man then, in obedience to my command, turned the body round, and, gracious God! what a sight met my view—he was, indeed, perfectly dead. The whole breast of the shirt, with its lace frill, was drenched with gore, as was the couch underneath the spot where he lay. The head hung back, as it seemed almost severed from the body by a frightful gash, which yawned across the throat. The instrument which had inflicted it, was found under his body. All, then, was over; I was never to learn the history in whose termination I had been so deeply and so tragically involved.


The severe discipline which my mind had undergone was not bestowed in vain. I directed my thoughts and my hopes to that place where there is no more sin, nor danger, nor sorrow.


Thus ends a brief tale, whose prominent incidents many will recognize as having marked the history of a distinguished family, and though it refers to a somewhat distant date, we shall be found not to have taken, upon that account, any liberties with the facts, but in our statement of all the incidents to have rigorously and faithfully adhered to the truth.














