

#A Ballad History of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Ballad History of Ireland
===========================


Author: Thomas Osborne Davis
----------------------------


### File Description

D. J. O'DonoghueElectronic edition compiled by Beatrix Färber

proof corrections by Beatrix Färber

 2. Second draft.Extent of text: 3780 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2008) (2009) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800002-022Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Source**2. First published in *The Nation* 30 November, 1844.
**Editions of this text; other writings by Thomas Davis**2. Thomas Davis, Essays Literary and Historical, ed. by D. J. O'Donoghue, Dundalk 1914.
3. Thomas Davis: selections from his prose and poetry. [Edited] with an introduction by T. W. Rolleston. London and Leipzig: T. Fisher Unwin (Every Irishman's Library). 1910. [Published in Dublin by the Talbot press, 1914.]
4. Sir Charles Gavan Duffy (ed.), Thomas Davis, the memoirs of an Irish patriot, 1840–1846. 1890.
5. Thomas Osborne Davis, Literary and historical essays 1846. Facsimile reprint, with an introduction by John Kelly, 1998, Washington, DC: Woodstock Books.
6. Essays of Thomas Davis. New York, Lemma Pub. Corp. 1974, 1914 [Reprint of the 1914 ed. published by W. Tempest, Dundalk, Ireland, under the title 'Essays literary and historical'.]
7. Thomas Davis: essays and poems, with a centenary memoir, 1845–1945. Dublin, M.H. Gill and Son, 1945. [Foreword by an Taoiseach, Éamon de Valera.]
8. Angela Clifford, Godless colleges and mixed education in Ireland: extracts from speeches and writings of Thomas Wyse, Daniel O'Connell, Thomas Davis, Charles Gavan Duffy, Frank Hugh O'Donnell and others. Belfast: Athol, 1992.
**Selected further reading**2. Arthur Griffith (ed.), Thomas Davis: the thinker & teacher; the essence of his writings in prose and poetry. Dublin: Gill 1914.
3. William O'Brien, The influence of Thomas Davis: a lecture delivered by William O'Brien, M.P., at the City Hall, Cork, on 5th November 1915. Cork: Free Press Office, 1915.
4. Johannes Schiller, Thomas Osborne Davis, ein irischer Freiheitssänger. Wiener Beiträge zur englischen Philologie, Bd. XLVI. Wien und Leipzig, W. Braumüller, 1915.
5. Michael Quigley (ed.), Pictorial record: centenary of Thomas Davis and young Ireland. Dublin [1945].
6. Joseph Maunsell Hone, Thomas Davis (Famous Irish Lives). 1934.
7. M. J. MacManus (ed.), Thomas Davis and Young Ireland. Dublin: The Stationery Office, 1945.
8. J. L. Ahern, Thomas Davis and his circle. Waterford, 1945.
9. Michael Tierney, 'Thomas Davis: 1814–1845'. Studies; an Irish quarterly review, 34:135 (1945) 300–10.
10. Theodore William Moody, 'The Thomas Davis centenary lecture in Newry'. An t-Iubhar (=Newry) 1946, 22–6.
11. D. R. Gwynn, O'Connell, Davis and the Colleges Bill (Centenary Series 1). Oxford and Cork, 1948.
12. D. R. Gwynn, 'John E. Pigot and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 145–57.
13. D. R. Gwynn, 'Denny Lane and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 15–28.
14. N. N., Clár cuimhneacháin: comóradh i gcuimhne Thomáis Daibhis, Magh Ealla, 1942. Baile Átha Cliath (=Dublin) 1942.
15. K. M. MacGrath, 'Writers in the Nation. , 1842–5.' Irish Historical Studies 6, no. 23 (March 1949), 189–223.
16. Christopher Preston, 'Commissioners under the Patriot Parliament, 1689'. Irish Ecclesiastical Record, 5th ser., 74:8 (1950) 141–51.
17. W.B. Yeats, Tribute to Thomas Davis: with an account of the Thomas Davis centenary meeting held in Dublin on November 20th, 1914, including Dr. Mahaffy's prohibition of the 'Man called Pearse,' and an unpublished protest by 'A.E.', Cork 1965.
18. Theodore William Moody, 'Thomas Davis and the Irish nation'. Hermathena, 103 (1966) 5–31.
19. Malcolm Johnston Brown, The politics of Irish literature: from Thomas Davis to W. B. Yeats. Seattle (University of Washington Press) 1973.
20. Eileen Sullivan, Thomas Davis. Lewisburg, New Jersey: Bucknell University Press, 1978.
21. Mary G. Buckley, Thomas Davis: a study in nationalist philosophy. Ph.D. Thesis, National University of Ireland, at the Department of Irish History, UCC, 1980.
22. Giulio Giorello, "A nation once again": Thomas Osborne Davis and the construction of the Irish "popular" tradition. History of European Ideas, 20:1–3 (1995) 211–17.
23. John Neylon Molony, A soul came into Ireland: Thomas Davis 1814–1845. Dublin 1995.
24. Robert Somerville-Woodward, "Two 'views of the Irish language': O'Connell versus Davis." The History Review: journal of the UCD History Society, 9 (1995) 44–50.
25. John Neylon Molony, 'Thomas Davis: Irish Romantic idealist'. In: Richard Davis; Jennifer Livett; Anne-Maree Whitaker; Peter Moore (eds.), Irish-Australian studies: papers delivered at the eighth Irish-Australian Conference, Hobart July 1995 (Sydney 1996) 52–63.
26. David Alvey, 'Thomas Davis. The conservation of a tradition.' Studies; an Irish quarterly review, 85 (1996) 37–42.
27. Harry White, The keeper's recital: music and cultural history in Ireland, 1770–1970. (Cork 1998).
28. Joseph Langtry; Brian Fay, 'The Davis influence.' In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 30–38.
29. Joseph Langtry, 'Thomas Davis (1814–1845).' In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 2–7.
30. Patrick Maume, 'Young Ireland, Arthur Griffith, and republican ideology: the question of continuity.' Éire–Ireland, 34:2 (1999) 155–74.
31. Sean Ryder, 'Speaking of '98: Young Ireland and republican memory'. Éire–Ireland, 34:2 (1999) 51–69.
32. Gerard Kearns, 'Time and some citizenship: nationalism and Thomas Davis'. Bullán: an Irish Studies Review, 5:2 (2001), 23–54.
33. Ghislaine Saison, 'L'écriture de l'histoire chez la Jeune Irlande: quelle histoire pour une nation du consensus et de la réconciliation?' In: Centre de recherche inter-langues angevin, Écriture(s) de l'histoire: Actes du colloque des 2,3 et 4 décembre 1999. (Angers 2001) 435–46.
34. Ghislaine Saison, 'Thomas Davis et la nation irlandaise'. Cercles, 4 (2002), 121–31.
35. Helen Mulvey, Thomas Davis and Ireland: a biographical study. Washington, D.C., Catholic University of America Press, 2003.

Thomas Osborne Davis A Ballad History of Ireland in , Ed. D. J. O'Donoghue Essays Literary and Historical by Thomas Davis. W. Tempest, Dundalgan Press, Dundalk, (1914) page 240–248### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


The electronic text represents the edited text.


##### Quotation


There is no direct speech.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the essay. Page-breaks are marked pb and numbered.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Personal names, titles of books, manuscripts and journals are tagged. Words from a language other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by Thomas Davis
 (1844) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] One word is in Irish.


##### Language: [FR] Two words are in French.


### Revision History


* (2009-07-28) Beatrix Färber (ed.)

* File updated; file validated, new wordcount made.
* (2008-05-30) Beatrix Färber (ed.)

* File proofed (2), structural and content markup applied; header created; file parsed; SGML and HTML files created.
* (2008-05-28) Beatrix Färber (ed.)

* File proofed (1).
* (1996) Audrey Murphy (ed.)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800002-022


### A Ballad History of Ireland: Author: Thomas Osborne Davis




---

p.240


[1](javascript:footNote('E800002-022/note001.html'))A Ballad History of Ireland
---------------------------


Of course the first *object* of the work we project will be to make Irish History familiar to the minds, pleasant to the ears, dear to the passions, and powerful over the taste and conduct of the Irish people in times to come. Mere *events* could be put into a prose history. Exact dates, subtle plots, minute connexions and motives, rarely appear in Ballads, and for these ends the worst prose history is superior to the best ballad series; but these are not the highest ends of history. To hallow or accurse the scenes of glory and honor, or of shame and sorrow; to give to the imagination the arms, and homes, and senates, and battles of other days; to rouse, and soften, and strengthen, and enlarge us with the passions of great periods; to lead us into love of self-denial, of justice, of beauty, of valour, of generous life and proud death; and to set up in our souls the memory of great men, who shall then be as models and judges of our actions—these are the highest duties of history, and these are best taught by a Ballad History.


A Ballad History is welcome to childhood, from its rhymes, its high colouring, and its aptness to memory. As we grow into boyhood, the violent passions, the vague hopes, the romantic 


---

p.241



sorrow of patriot ballads are in tune with our fitful and luxuriant feelings. In manhood we prize the condensed narrative, the grave firmness, the critical art, and the political sway of ballads. And in old age they are doubly dear; the companions and reminders of our life, the toys and teachers of our children and grand-children. Every generation finds its account in them. They pass from mouth to mouth like salutations; and even the minds which lose their words are under their influence, as one can recall the starry heavens who cannot revive the form of a single constellation.


In olden times all ballads were made to music, and the minstrel sang them to his harp or screamed them in recitative. Thus they reached farther, were welcomer guests in feast and camp, and were better preserved. We shall have more to say on this in speaking of our proposed song collection. Printing so multiplies copies of ballads, and intercourse is so general, that there is less need of this adaptation to music now. Moreover, it may be disputed whether the dramatic effect in the more solemn ballads is not injured by lyrical forms. In such streaming exhortations and laments as we find in the Greek choruses and in the adjurations and caoines of the Irish, the breaks and parallel repetitions of a song might lower the passion. Were we free to do so, we could point out instances in the Spirit of the Nation in which the rejection of song-forms seems to have been essential to the awfulness of the occasion.


In pure narratives and in the gayer and more splendid, though less stern ballads, the song-forms and adaptation to music are clear gains.


In the Scotch ballads this is usual, in the 


---

p.242



English rare. We look in vain through **Southey**'s admirable ballads— Mary the Maid of the Inn, Jaspar, Inchcape Rock, Bishop Hatto, King Henry V and the Hermit of Dreux—for either burden, chorus, or adaptation to music. In the Battle of Blenheim there is, however, an occasional burden line; and in the smashing March to Moscow there is a great chorussing about—
  


‘Morbleu! Parbleu!
  

What a pleasant excursion to Moscow.’
  



**Coleridge** has some skilful repetitions and exquisite versification in his Ancient Mariner, Genevieve, Alice du Clos, but nowhere a systematic burden. **Campbell** has no burdens in his finest lyric ballads, though the subjects were fitted for them. The burden of the Exile of Erin belongs very doubtfully to him.


**Macaulay**'s best ballad, the Battle of Ivry, is greatly aided by the even burden line; but he has not repeated the experiment, though he, too, makes much use of repeating lines in his Roman Lays and other ballads.


While, then, we counsel burdens in Historical Ballads, we would recognise excepted cases where they may be injurious, and treat them as in *no case* essential to perfect ballad success. In songs, we would almost always insist either on a chorus verse, or a burden of some sort. A burden need not be at the end of the verse; but may, with quite equal success, be at the beginning or in the body of it, as may be seen in the Scotch Ballads, and in some of those in the Spirit of the Nation.


The old Scotch and English ballads, and **Lockhart**'s


---

p.243



translations from the Spanish, are mostly composed in one metre, though written down in either of two ways. **Macaulay**'s Roman Lays and Ivry are in this metre. Take an example from the last:—
  


‘Press where ye see my white plume shine, amid the ranks of war,
  

And be your Oriflamme to-day the helmet of Navarre.’
  



In the old ballads this would be printed in four lines, of eight syllables and six alternately, and rhyming only alternately,—thus:—
  


‘Press where ye see my white plume shine,
  

Amid the ranks of war,
  

And be your Oriflamme to-day
  

The helmet of Navarre.’
  



So **Macaulay** himself prints this metre in some of his Roman Lays.


But the student should rather avoid than seek this metre. The uniform old beat of eight and six is apt to fall monotonously on the ear, and some of the most startling effects are lost in it. In the Spirit of the Nation the student will find many other ballad metres. **Campbell**'s metres, though new and glorious things, are terrible traps to imitation, and should be warily used. The German ballads, and, still more **Mangan**'s translations of them, contain great variety of new and safe, though difficult metres. Next in frequency to the fourteen syllable line is that in eleven syllables, such as Mary Ambree and Lochinvar; and for a rolling brave ballad 'tis a fine metre. The metre of fifteen syllables, with double rhymes (or accents) in the middle, and that of thirteen, with double rhymes at the end, is tolerably frequent, and the metre used by 


---

p.244


**Father Prout**, in his noble translation of Duke D'Alencon, is admirable, and easier than it seems. By the way, what a grand burden runs through that ballad:—
  


‘Fools! to believe the sword could give to the children of the Rhine,
  

Our Gallic fields—the land that yields the Olive and the Vine!’


The syllables are as in the common metre, but it has thrice the rhymes.


We have seen great materials wasted in a struggle with a crotchetty metre; therefore, though we counsel the invention of metres, we would add, that unless a metre come out racily and appropriately in the first couple of verses, it should be abandoned, and some of those easily marked metres taken up.


A historical ballad will commonly be narrative in its form, but not necessarily so. A hymn of exultation—a call to a council, an army, or a people—a prophecy—a lament—or a dramatic scene (as in Lochiel), may give as much of event, costume, character, and even scenery, as a mere narration. The varieties of form are infinite, and it argues lack of force in a writer to keep always to mere narration, though when exact events are to be told, that may be the best mode.


One of the essential qualities of a good historical ballad is truth. To pervert history—to violate nature, in order to make a fine clatter, has been the aim in too many of the ballads sent us. He who goes to write a historical ballad should master the main facts of the time, and state them truly. It may be well for those perhaps either not to study or to half-forget minute circumstances until after his ballad is drafted out, lest he write a 


---

p.245



 
chronicle, not a ballad; but he will do well, ere he suffers it to leave his study, to re-consider the facts of the time or man, or act of which he writes, and see if he cannot add force to his statements, an antique grace to his phrases, and colour to his language.


Truth and appropriateness in ballads require great knowledge and taste.


To write an Irish historical ballad, one should know the events which he would describe, and know them not merely from an isolated study of his subject, but from old familiarity, which shall have associated with them his tastes and passions, and connected them with other parts of history. How miserable a thing is to put forward a piece of vehement declamation and vague description, which might be uttered of any event, or by the man of any time, as a historical ballad. We have had battle ballads sent us that would be as characteristic of Marathon or Waterloo as of Clontarf—laments that might have been uttered by a German or a Hindu—and romances equally true to love all the world over.


Such historical study extends not merely to the events. A ballad writer should try to find the voice, colour, stature, passions, and peculiar faculties of his hero—the arms, furniture, and dress of the congress, or the champions, or the troops he tells of—the rites wherewith the youth were married—the dead interred, and God worshipped; and the architecture—previous history and pursuits (and, therefore, probable ideas and phrases) of the men he describes.


Many of these things he will get in books. He should shun compilations, and take up original journals, letters, state papers, statutes, and 


---

p.246



 
contemporary fictions and narratives, as much as possible. Let him not much mind **Leland** or **Curry** (after he has run over them), but work like fury at the **Archaeological Society**'s books—at **Harris**'s Hibernica, at **Lodge**'s Desiderata Curiosa Hibernica, at **Strafford**'s Pacata, **Spencer**'s View, **Giraldus**'s Narrative, **Fynes Moryson**'s Itinerary, the Ormond Papers, the State Papers of Henry the Eighth, **Stafford**'s and **Cromwell**'s and **Rinuccini**'s Letters, and the correspondence and journals, from **Donald O'Neill**'s letter to the Pope down to **Wolfe Tone**'s glorious memoirs.


In the songs, and even their names, many a fine hint can be got; and he is not likely to be a perfect Balladist of Ireland who has not felt to tears and laughter the deathless passions of Irish music.


We have condemned compilations; but the ballad student may well labour at **Ware**'s Antiquities. He will find in the History of British Costume, published by the **Useful Knowledge Society** and in the illustrated work now in progress called Old England, but, beyond all other books, in the historical works of **Thierry**, most valuable materials. Nothing, not even the Border Minstrelsy, Percy's Relics, the Jacobite Ballads, or the Archaeological Tracts can be of such service as a repeated study of The Norman Conquest, the Ten Years' Study, and the Merovingian Times of **Augustin Thierry**.


We know he has rashly stated some events on insufficient authority, and drawn conclusions beyond the warrant of his premises; but there is more deep dramatic skill, more picturesque and coloured scenery, more distinct and characteristic 


---

p.247



grouping, and more lively faith to the look and spirit of the men and times and feelings of which he writes, in **Thierry**, than in any other historian that ever lived. He has almost an intuition in favour of liberty, and his vindication of the men of '98 out of the slanderous pages of **Musgrave** is a miracle of historical skill and depth of judgment.


In the **Irish Academy** in Dublin there is a collection (now arranged and rapidly increasing) of ancient arms and utensils. Private collections exist in many provincial towns, especially in Ulster. Indeed, we know an Orange painter in a northern village who has a finer collection of Irish antiquities than all of the Munster cities put together. Accurate observation of, and discussion on, such collections, will be of vast service to a writer of historical ballads.


Topography is also essential to a ballad, or to any Historian. This is not only necessary to save a writer from such gross blunder as we met the other day in Wharton's Ballad, called The Grave of King Arthur, where he talks of ‘the steeps of rough Kildare’, but to give accuracy and force to both general references and local description.


Ireland must be known to her Ballad Historians, not by flat, but by shaded maps, and topographical and scenic descriptions; not by maps of to-day only, but by maps (such as **Ortelius** and the maps in the State Papers) of Ireland in time past; and, finally, it must be known by the *eye*. A man who has not raced on our hills, panted on our mountains, waded our rivers in drought and flood, pierced our passes, skirted our coast, noted our old towns, and learned the shape and colour 


---

p.248



of ground and tree, and sky, is not master of all a Balladist's art. **Scott** knew Scotland thus, and, moreover, he seems never to have laid a scene in a place that he had not studied closely and alone.


What we have hitherto advised relates to the Structure, Truth and Colouring of ballads; but there is something more needed to raise a ballad above the beautiful—it must have Force. Strong passions, daring invention, vivid sympathy for great acts—these are the result of one's whole life and nature. Into the temper and training of ‘A Poet’ we do not presume to speak. Few have spoken wisely of them. **Emerson**, in his recent essay, has spoken like an angel on the mission of ‘The Poet’. Ambition for pure power (not applause); passionate sympathy with the good, and strong, and beautiful; insight into nature, and such loving mastery over its secrets as a husband hath over a wife's mind, are the surest tests of one ‘called’ by destiny to tell to men the past, present, and future, in words so perfect that generations shall feel and remember.


We merely meant to give some ‘Hints on the Properties of Historical Ballads’—they will be idle save to him who has the mind of a Poet.












