

#William Allingham, The Diaries 1824-1846


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


William Allingham, The Diaries 1824-1846
========================================


Author: William Allingham
-------------------------


### File Description

Electronic edition compiled by Beatrix Färber

proof corrections by Beatrix Färber

 1. First draft, revised and corrected.Extent of text: 13500 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2008) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E850006-003Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Allingham's Works**2. William Allingham, Poems (London: Chapman & Hall 1850).
3. William Allingham, Day and Night Songs (London: Routledge 1854).
4. William Allingham, Peace and War (London: Routledge 1854).
5. William Allingham, The Music Master (London: Routledge 1854).
6. William Allingham, The Ballad Book: A Selection of the Choicest British Ballads [Golden Treasury Series] (London: Macmillan 1864).
7. William Allingham, Laurence Bloomfield in Ireland: A Modern Poem (London: Macmillan 1864, 1869; reprinted New York: AMS 1972).
8. William Allingham, Fifty Modern Poems (London: Bell & Daldy 1865).
9. William Allingham, In Fairyland: A Series of Pictures by Richard Doyle with a Poem by William Allingham (London: Longmans, Green 1870).
10. William Allingham, Songs, Ballads and Stories (London: George Bell & Sons 1877).
11. William Allingham, Evil May-Day (London: David Stott 1883).
12. William Allingham, Ashby Manor: A Play in Two Acts (London: David Stott 1883). [Historical drama].
13. William Allingham, The Fairies (London: De La Rue 1883).
14. William Allingham, Blackberries: Picked Off Many Bushes, by D. Pollex and Others; Put in a Basket by W. Allingham (London: Philip & Son 1884).
15. Rhymes for the Young Folk. (London: Cassell 1887).
16. William Allingham, Irish Songs and Poems, with Nine Airs Harmonised for Voice and Pianoforte (London: Reeves & Turner 1887).
17. William Allingham, Flower Pieces and Other Poems (London: Reeves & Turner 1888).
18. William Allingham, Life and Phantasy (London: Reeves & Turner 1889).
19. William Allingham, Thought and Word, and Ashby Manor (London: Reeves & Turner 1890).
20. William Allingham, Blackberries. Revised (London: Reeves & Turner 1890).
21. William Allingham, Laurence Bloomfield in Ireland. Revised (London: Reeves & Turner 1890).
22. William Allingham, Varieties in Prose (London: Longmans Green 1893). [Collected Prose].
23. William Allingham, Sixteen poems by William Allingham, selected by William Butler Yeats. (Dundrum: Dun Emer Press, Dundrum 1905.) Published by Elizabeth Corbet Yeats. [Photo-lithographic reprint published 1971 by IUP.]
24. William Allingham: A Diary, ed. Helen Allingham and Dollie Radford (London: Macmillan 1907). Reprinted by the Folio Society, London 1990.
25. William Allingham, Poems of William Allingham, selected and arranged by Helen Allingham. (London: Macmillan 1912).
26. William Allingham, By the Way: Verses, Fragments, and Notes, ed. Helen Alllingham (London: Longmans, Green 1912).
27. William Allingham, William Allingham's diary; introduction by Geoffrey Grigson (London: Centaur 1967).
28. The poems of William Allingham, ed. with an introduction by John Hewitt. An Comhairle Ealaíon Series of Irish authors. (Dublin: Dolmen 1967).
**Secondary Literature**2. Hans Kropf, William Allingham und seine Dichtung im Lichte der irischen Freiheitsbewegung. Inaugural-Dissertation (Biel 1928).
3. J. Lyle Donaghy, 'William Allingham'. In: Dublin Magazine 20:2 (1945) 34–38.
4. P. S. O'Hegarty, A bibliography of William Allingham. [Reprinted from the Dublin Magazine of Jan–March and July–Sept. 1945] (Dublin: A. Thom & Co. 1945).
5. William Irwin Patrick McDonogh, The life and work of William Allingham. [Unpublished PhD Thesis, Trinity College Dublin 1952, Dept. of English.]
6. Hugh Shields, 'William Allingham and folk song'. In: Hermathena 117 (1974), 23–36.
7. Patricia Mary England, The poetry of William Allingham. [Unpublished M.A. Thesis, University of Birmingham 1976, Dept of English.]
8. Alan Warner, William Allingham: an introduction. (Dublin: Dolmen 1971) [Includes a selection of Allingham's poems.]
9. Alan Warner, William Allingham. (Lewisburg, Pennsylvania: Bucknell University Press 1975).
10. Alan Warner, 'William Allingham: Bibliographical Survey.' Irish Book Lore 2 (1976): 303–307.
11. Samira Aghacy Husni, William Allingham: an annotated bibliography. Beirut, Lebanese Establishment for Publishing & Printing Services, c 1984.
12. Mark Samuels Lasner, 'William Allingham: some uncollected authors lvi. Part 1'. Book Collector 39 (Summer 1991) 174–204.
13. Mark Samuels Lasner, 'William Allingham: some uncollected authors lvi. Part 2'. Book Collector 39 (Autumn 1991) 321–349.
14. Mark Samuels Lasner, 'William Allingham: a bibliographical study. (Philadelphia: Holmes 1993).
15. Malcolm McClure, 'Biographical note: the Allinghams of Ballyshannon' [An interim report]. Donegal Annual 52 (2000) 87–89.
**Literary Background**2. Letters to William Allingham, edited by H. Allingham (London: Longmans 1911), reprinted (New York: AMS Press 1971).
3. G. B. N. Hill, ed., The letters of Dante Gabriel Rossetti to William Allingham, 1854–1870 (1897).

William Allingham The Diaries in , Ed. H. Allingham and D. Radford The Diaries . The Folio Society, London, (1990 (reprint of 1907 edition)) page 19–45### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


Pages 19–45.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is tagged q. 


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the diary; div1=the section. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place names and words from other languages than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by William Allingham
 (1883) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] Some words are in French.


##### Language: [GA] Some terms are in Irish.


##### Language: [LA] Some words are in Latin.


### Revision History


* (2008-07-05) Beatrix Färber (ed.)

* File proofed (2); more structural markup added; additions to bibliography made; file parsed and validated; SGML and HTML files created.
* (2008-07-04) Beatrix Färber (ed.)

* Structural markup added to; file parsed and validated.
* (2008-07-03) Beatrix Färber (ed.)

* File proofed (1); structural and light content markup applied; header created.
* (2008-07-02) Beatrix Färber (ed.)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E850006-003


### William Allingham, The Diaries 1824-1846: Author: William Allingham




---

p.19


The Diaries: 1824–1846
----------------------


The little old Town where I was born has a Voice of its own, low, solemn, persistent, humming through the air day and night, summer and winter. Whenever I think of that Town I seem to hear the Voice. The River which makes it, rolls over rocky ledges into the tide; before, spreads a great Ocean in sunshine or storm; behind, stretches a many-islanded Lake. On the south runs a wavy line of blue Mountains; and on the north, over green or rocky hills, rise peaks of a more distant range. The trees hide in glens, or cluster near the river; gray rocks and boulders lie scattered about the windy pastures. The sky arches wide over all, giving room to multitudes of stars by night, and long processions of clouds blown from the sea; but also, in the childish memory where these pictures live, to deeps of celestial blue in the endless days of summer.


An odd, out-of-the-way little Town, ours, on the extreme western verge of Europe; our next neighbours, sunset way, being citizens of the great New Republic, which indeed, to our imagination, seemed little if at all further off than England in the opposite direction.


I was born in a little House, the most westerly of a row of three, in a street running down to the Harbour. Opposite was a garden wall, with rose-bushes hanging over. If I can remember anything of this first house, which perhaps I cannot, it is the top of the kitchen stairs at the end of the passage, and the dark unknown abyss below. My first appearance in this odd sort of world was in the blustery month of March, two days after the festival of Ireland's patron saint. From the House that I was born in we moved to one somewhat larger, two doors eastward, when I was one year and four months



---

p.20



old, and lived there a little more than two years. Of this second House I certainly retain many impressions. A picture of the Sitting Room, with its darkish carpet of geometric pattern, and its ruddy fire, its window, door, table, chairs, and sofa, in certain relative positions, is dimly revivable. The two or three steps at the front door, and the longer flight leading down into the kitchen, are indented, as it were, on my memory. Steps and stairs are very remarkable objects to most children, I should think, in their earlier stages in the art of walking. A sense of toil and danger is connected with them—and of awe; they are something like what Alpine precipices are to grown-up people.


And when this state of mind is gradually overcome, it blends with the triumphant feeling of power in mounting and descending these difficult heights, and penetrating at will new regions in the remotest recesses of the House.


An early expedition of mine down the kitchen stairs led me into a piece of ill-luck, the consequences of which, trivial as it seemed at the time, have woven themselves into the whole texture of my life, have sensibly lessened its whole share of pleasure and added to it daily and almost hourly vexations. I had crept down the back-stairs to the kitchen, and was pattering across the stone floor, unnoticed by a woman busily engaged in ‘getting up’ some of the household linen. She snatched a ‘flat-iron’ which had been standing in front of the fire, and, turning quickly round to carry it to the smoothing table, encountered Little Me unlucky!—nor was she able to check herself soon enough to keep the hot iron from touching my left eye. General agitation followed, no doubt. I had to spend some days in a darkened room, and compared myself (Aunt Bess told me afterwards) to old Isaac, whose eyes were dim, so that he could not see.


The effect of this accident on my sight was not discovered for years afterwards; its effects on my comfort and character no one knows or even suspects but myself.


While in this house, I received a small box of water-colour paints (I have it still) from my godmother, Mrs Jane Dixon. I was seated one day at the parlour table in my little armchair, screwed on to the top of its table to bring it to a proper height, and with paintbox, brushes, and cup of water, was dabbing and daubing away on various pieces of paper, to the envy of a playfellow, who was at the same table, but had only some bright coloured picture-books



---

p.21



books for his share—a tame amusement compared to painting one's own pictures. My mother or nurse hinted that I might share the use of the paintbox with my companion, but the sense of property was too strong, and I refused. When it appeared that the loan would be disagreeable to me, no more was said: but then I began to turn the matter over in my mind, and secretly bethought me—‘We shall all have to die in a few years; it is not worth while saving up these paints so carefully’—and I intimated my willingness to lend them. There was no sort of moral notion in it; and as to how I first got. the impression of death, I have no clue. It was very likely by means of ‘the dead-bell’, which tolled for funerals, and whose every slow stroke, in the Church tower on the hill, used to sound through the sleepy little Town, and in later years of youth, to smite upon my heart.


It may easily have been among the first things to awaken a child's curious questionings. The notion of Death at this earlier time was not associated, as far as I can recall, with the slightest dread or awe, or feeling of any kind except that (which is perhaps one of the last we should suspect in a child of three years old) of the transitory character of all human possessions.


Later, at the age perhaps of six or seven, I was for a time fully possessed with the conviction that I should never die— that I, for one, must in some way or other escape death. No reasoning led up to this idea, and no effort, voluntary or involuntary, was made to define the mode of exemption or the consequences. There was simply a perception of a fact which had become apparent—as of a mountain on the horizon on an exceptionally clear day, new, dim, but undeniable—the fact that I should not die; nor did I take much notice of it—there it was; and when the mental atmosphere gradually changed, it was invisible again.


In my fourth year (autumn of 1827) our family changed house again; father, mother, myself, and a sister a year and a half younger. The move was only across the street, but the new abode, known as The Cottage, had a character of its own. It was an irregularly built house of two stories, with the general shape ofthe letter L, standing among gardens and shrubberies. The front and the south gable were half covered with clematis, which embowered the parlour windows in summer; and some wall-trained evergreen fringed the one window of the Nursery with dark sharply-cut leaves, in company with a yellow blossoming **Pyrus



---

p.22



Japonica**. Opposite the hall door, a good-sized Walnut Tree growing out of a small grassy knoll leaned its wrinkled stem towards the house, and brushed some of the second-story panes with its broad fragrant leaves. To sit at that little upper-floor window (it belonged to a lobby) when it was open to a summer twilight, and the great Tree rustled gently and sent one leafy spray so far that it even touched my face, was an enchantment beyond all telling. Killarney, Switzerland, Venice could not, in later life, come near it.


On three sides the Cottage looked on flowers and branches, which I count as one of the fortunate chances of my childhood—the sense of natural beauty thus receiving its due share of nourishment, and of a kind suitable to those early years. Grandeur of scenery is lost on a young child; I doubt if any landscape impresses him, however impressionable. Little things, close at hand, make his pleasures and troubles. I was enchanted with our flower-beds and little shrubberies; and in a grass field to which we were sometimes brought, a quarter of a mile away, there was a particular charm in two or three gray rocks encrusted with patches of moss; but of the distant view of the Atlantic Ocean I took no notice at this time.


My Father was fond of flowers and we had a good show of all the old-fashioned kinds in their seasons. I loved the violet and lily of the valley, and above all the rose—all roses, and we had many sorts, damask, cabbage, ‘Scotch’, moss, and white roses in multitude on a great shady bush that overhung the little street at our garden-foot. The profusion of these warm-scented white roses gave a great feeling of summer wealth and joy, but my constant favourite was the ‘Monthly Rose’, in colour and fragrance the acme of sweetness and delicacy combined, and keeping up, even in winter time, its faithful affectionate companionship.


Before the front door grew my dear Walnut Tree out of its little mound, beyond which the narrow drive curved in something of a figure of S to the stable and byre, its little shrubbery on either side shady enough with lilacs and laburnums to yield forest haunts to the childish fancy. Two or three fig-trees there were also, whose fruit swelled but never ripened; and their crooked boughs were chiefly interesting as perches, from which strange altitudes one could look down on the household traffic, horse and foot. Near the north shrubbery's edge grew tufts of



---

p.23



daffodil, and at one place it was overhung by a tall gable thickly clad with ancient ivy. This gable did not appertain to us; its one little window high up, nearly buried in dark leaves, belonged to an inscrutable and most mysterious interior. The Great Pyramid could not give me, in later life, so profound a sense of antiquity and awfulness as this old hay barn gave to the little boy.


Our own more familiar outhouses were highly interesting, each in its own way; the stable for my father's one or two horses, where perpetual twilight reigned and characteristic odours, with its forks and curry-combs, slope-lidded corn bin, and trapdoor to the hayloft above; next the stable, the harness-room, and over this an apple-loft, of most memorable fragrancy; a little higher up the yard, the byre with its two or three deliberate-stepping, sweetbreathed cows, and another loft; and close by in a corner the little stable, wood with thatched roof, of Sheltie, the brownbear-like pony with long mane and tail, which I rode, and whose eccentricities gave birth to most exciting personal adventures. He was fond of standing nearly bolt upright on his hind legs, when I was fain to hug his thick mane. He often had views of his own as to the best road to take, and, suddenly refusing to move forward, would turn round and round like a wheel, then abruptly gallop off in the direction of his stable. One eventful day when I was riding Sheltie about our home limits one of the gates happened to be open, and we passed out unobserved into the street where the pony immediately quickened his pace and, taking the law into his own hands, carried me out of the town and along country roads into a wild unknown region. If I had any alarm or misgiving the joy of novelty overcame it, yet there was a sense of relief when my self-willed steed stopped before the field gate of a farm of my father's about two miles out, which I then recognised, having visited it in his gig once or twice before. The pony had been there at grass and recollected his good times. The cottagers ran out with many exclamations of wonder at sight of us, and one of them, holding Sheltie's bridle, brought me home again, full of a delightful sense of adventure and the importance of having been missed.


[1](javascript:footNote('E850006-003/note001.html')) My Father had this small farm on lease, and also a large field near the town, called ‘The Big Meadow’, in which grazing was let



---

p.24



to some neighbours' milch cows along with our own; but he was not a farmer, and his agricultural produce went mainly to supply his own family and my grandmother's, the surplus being sold.


His business was that of a merchant—a wide designation, and in his case applicable enough; he imported timber, slates, coal and iron, and owned at various times five or six ships, trading chiefly to Canada and the Baltic for timber. There were no exports, save now and again of human beings to **Quebec**. The emigration was small then to what it became in after years, but enough to make ‘going to Ameriky’ one of the most familiar phrases in daily life. My father went out every morning to his office, which was on the other side of the street from our house, and seldom returned till dinner time, half-past four. This and other household facts I became aware of by their recurrence, but took little or no note of them. Every child rates things for himself. Curiosity, mixed with imagination and the love of beauty, was naturally strong in me; but even at this early age, unless I am mistaken, it sought its food in the interests and characteristics belonging to nature and life in general; or rather say that, while rapidly and vividly receptive of all kinds of novel impressions, I strove unfailingly and quite unconsciously to group them according to some principle, refer them to some ideal—though it must be owned that, in the first decade of one's earthly career, principles and ideals are usually of an unsubstantial fantastic sort.


The persons moving around me were as personae merely, and in and for themselves individually interested me little or nothing. I intend all through this record to avoid ‘philosophising’, and give recollections and impressions as simply as may be. What it indicated (if anything special) I know not to this hour, but in these first years I do not remember to have felt any emotion of affection either for my parents or for anybody else. Caresses (if that is to be taken into account) I never had any share of from my parents; they were both undemonstrative in that way by nature, and my mother's constant invalidism and my father's hasty temper kept us children at a distance from both. Yet, coldness was never reckoned one of my faults, and later, say from twelve years old, my attachments to persons were warm and constant.


I dimly recollect my mother as thin, pale, delicate, gentle in voice and movement, with soft dark hair and an oval face slightly sun-freckled. She was kind, sweet, and friendly, and a great



---

p.25



favourite with all who knew her; but her ill health and early death left us, alas! to learn these her merits by hearsay and to love her shadowy memory when the mild presence had vanished for ever. She was married in 1823, and bore the following children:




|  |  |  |
| --- | --- | --- |
| William | born | 10 March 1824. |
| Catherine | " | 25 March 1826. |
| John | " | 12 December 1827.  |
| Jane | " | 25 August 1829. |
| Edward | " | 22 August 1831 (who only lived a few months). |





and a stillborn son on 27 May 1833, at which time she was already far gone in ‘a decline’, due rather to exhaustion than disease.


She died on Tuesday evening, 2 July 1833. She was perhaps not made for longevity, but with more wisdom in its atmosphere her dear and sweet life might have been preserved for many years.


I only recollect her as an invalid, and we children were not allowed to be much with her. But now and again she sung a little to the pianoforte, and two songs of that time have still for me a charm not their own— The Bonnie Breastknots, and It wasn't for you that I heard the bells ringing.


From my nurses and others I picked up a large number of tunes, for I had a decided ‘ear for music’, and Ireland is, or used to be, a country with its air full of singing, whistling, and lilting. Fiddlers abounded, pipers were not scarce; the fame of harpers lingered, but I never heard the Irish Harp till I went South.


My father (on the passage, in these years, between thirty and forty) was a short, active, black-haired man, with very light gray eyes, quick, impatient, curious as to the externals of objects, and easily amused, but disregardful of whatever did not immediately interest him. He had a turn for arithmetic, and was exact in the money part of all dealings; punctual also as to set hours, and letter-writing.


In continuation of unbroken family custom, he was an unswerving adherent of the Established Church; but in politics he had left the Radicalism of his early life for a kind of Toryism which consisted mainly in reading a newspaper on that side, and giving a vote accordingly at the county election.


Honesty, prudence, industry, regularity, conformity—few men will break down with these; and my father had these, under 



---

p.26



fashions peculiar to himself. He had, moreover, though thrifty, a kind of open-handedness, or dislike and impatience of stint; and, above all and best of all, an inherent aversion from every sort of double-dealing and deception, and a total incapacity to practise them. This sincerity—which was often naive and sometimes impolite—he had in common with his brothers and sisters; his mother was of the same nature, and it has descended to her grandchildren. I feel it is no merit in myself, but an inheritance, a something like the shape of my limbs, that I have always an uneasy longing to undeceive people in every case, trivial or important, whether connected with myself or others, where the slightest misconception seems to exist. This tendency (strangely associated with extreme shyness in admitting any personal intimacy) often runs into absurdity, and I am sure I have often left people puzzled by explaining to them more than enough, and setting them perhaps a'search for supposed motives. The tendency is native, and will work. This turn of mind also urges me to point out without delay all the faults I see in any person or thing, even when my admiration is very great, and although I am aware of the certainty of breeding misconceptions thereby.


Both mind and body were exceedingly active, and I was irresistibly drawn to pry into and examine all kinds of objects and places, climb up ladders, walls, gates, trees, sometimes no doubt committing breakage or causing alarm. But there was not the least tinge of malice in my nature, or capability of being pleased by the destruction of anything or the annoyance of anybody, and a wise and sympathetic senior could without special effort have done wonders for my education and happiness. I used often to wonder how it could have happened that I was so much wickeder than everybody else. I should have suffered much more hurt and harm by it but for certain compensations. My great curiosity and interest in outward things, and delight in their beauty and novelty, along with much activity of imagination, or rather fantasy, tended to save me; and at my Grandmother's house—but a little way off, and to which I went as often as I could—I found something of that atmosphere of affection and confidence which is so suitable to the free growth of any tender young soul.


My Grandmother (my father's mother, Jane Hamilton her maiden name) managed to live by a very few simple rules (without even knowing these, as rules), and managed to do it as well



---

p.27



or better than most people. She cared about her own household, first and last; maintained regular hours and a good larder; was kind to her servants, but kept them in their place; petted her grandchildren, and took a great deal of snuff: She had a family Bible, with the births of her numerous sons and daughters— eighteen in all, I think, but many of these died in childhood—recorded in old-fashioned writing on the flyleaves, and a thick old cookery-book bound in black leather; and these I believe were all her books. But she used to sit in the winter evenings, with her cat on her knee, knitting stockings and listening with apparent pleasure to Aunt Maryanne reading the Waverley Novels, and would sometimes make a remark on an extraordinary incident or character—generally on some piece of villainy, and to this effect, ‘They ought to have hanged him!’ From this it may be guessed that the modern scruples about capital punishment had never intruded on her mind; and indeed, as far as I can recollect, she was in doubt about nothing: if it was an old thing it had its label attached, if a novelty she kept it at arm's length. Even the rotation of our planet upon its axis (though not exactly a new opinion) she never believed in. The bare notion of such a turning and twirling would have been enough to make her head light.


I now know that my Grandmother's was a small house, but if I were to describe it from the impressions of those years it would be spacious and many-roomed, with a long, dim, lofty Entrance Hall, wide enough to be the scene of many fancied adventures. The stairs at its end mounted to a landing with flower-stands and a window, and thence to a Drawing-room with what I thought a large window to the street, a little room off this, and two bedrooms looking to the back. Another flight climbed to an upper lobby and the garrets. At the end of the hall, between the foot of the staircase and the kitchen door, was a door, generally locked, whence a few descending stairs led to a curious back-room with hen-coops, a smell of live animals, an ancient wooden partition, and a window dim with old crusted dirt; and, from this a dark flight of stone steps descended to a truly mysterious and almost awful region, a dim back-kitchen paved with rude flags, with a well of living water of unknown depth in a recess of the wall.


Into the Hall (where an old-fashioned lamp of elongated shape, which I never saw lighted, hung from the ceiling) opened the



---

p.28



door of the Parlour, next the street, and my Grandmother's bedroom to the back of the house, both on the left hand as you came in; and on the right, close to the head of the back-stairs, the Kitchen door. Another door on the right, belonging to a Storeroom usually entered from the Kitchen, I never saw opened but twice or thrice, each opening an event and a revelation; a press stood against it on the inner side, and a green hall-chair on the outer. Near the hall door lay an oval mat, and at the stair-foot another, made of ‘bent’, a coarse grass that grows on the sandhills by the sea; these mats being finger-woven and carried round for sale by barefooted women and girls, one or more of whom called nearly every day to ask, ‘D'ye want any mats?’


The Kitchen was floored with square red tiles. Its one tall window, with thick window sashes, beside which was the washing-tub on its stand, looked out on a little backyard. Opposite the door stood a long ‘dresser’ with its rows of plates and dishes, tin porringers and strainers; and under this, in the corner next the window, was the place of a large tub of fresh water which, with its clear olive depth and round wooden dipper swimming like a boat on its tremulous surface, used to give me great delight, judging (as I do in this and similar cases) by my distinct impressions of the forms and colours.


From my own experience I judge that a child's little **camera obscura**, however sensitive to the picturesque, cannot include it on a large scale. There were mountains in daily sight, where I lived, and a large cataract in the river close by; I must also have seen the ocean sometimes, which was but three miles distant, yet it was none of these that impressed me with a sense of beauty and mystery, but the water-tub and the well, flowers and leaves, and, very particularly, a heap of gray rocks, touched with moss and in one part laced with briars, in a certain green field to which the nurse used often to bring us.


No doubt I was a troublesome youngster, superabundantly active, and there were two things which probably helped to make me unacceptable. I was a peculiar-looking, and, no doubt in the opinion of many, an ugly little chap, with an odd cast in his gray eyes; secondly, I was never done asking questions, and hardly ever satisfied with the answers I received. I could read fluently at a very early age, and I remember nothing of being taught. But I do remember, before I could read, learning a sentence in the



---

p.29



Bible Story Book by heart, and then making a pretence of reading it—out of vainglory. The little woodcuts in that book—a **duodecimo** in two volumes—impressed me more than any pictures I have seen since. A wide lonely landscape of hills and water, with the sun looking down upon them, heading the chapter called ‘The Last Days’, remains, in its effect on my mind, the grandest of all works of art. It was a woodcut about an inch long, and no doubt entirely commonplace in itself. I wonder whether something intrinsically great would have impressed me more. Probably not.


With my sisters I was always on good terms, but I cannot remember that they ever seemed to count much then in my life. Places had more reality than persons. My mind was busy with imaginations which gave mysterious importance to every nook of house and garden; and when I began to catch glimpses of things in a wider range, and to overhear hints of a more wonderful world outside of this, magic pictures formed themselves within me of such heavenly beauty as no experience has matched. These had a consistency of their own, and recurred till they left impressions that resembled real memories, and have, I doubt not, made and do still make a large part of the scenery of my Dreams. Beautiful Dreams (I mean in sleep) have been no trivial part of the pleasures of my life. Certain Dreams show up again and again, like the opening of a familiar page. Sometimes there is an interval of years between two appearances of the same Dream. There are several Dreams, each distinct, of Lakes, of Rivers, of Mountains, of Woodlands, of Cities, of Great Buildings, of Strange Countries; a Dream of a Cave, and a Dream of a Gothic Ruin, a Dream of Flying, a Dream of Death, and many more. Dreamland has its own geography, of places wherein all strange adventures and experiences are possible.


My brother John and I had not much in common; but one Sunday evening, I remember (this must have been in our second **lustrum**, perhaps well on in it), we were on the stairs of the Church gallery—a big boy quarrelled with me and suddenly made as though he would throw me over the railing. I was rescued quickly, but during the momentary struggle I saw John's face, who was some steps higher up, looking down with an expression of alarm and horror which I never afterwards forgot, and which gave me a new feeling towards him from that day. He never



---

p.30



knew this; of such slight incidents and lasting effects life is full.


The said Church (of the United English and Irish Establishment) was an important object in my childish life. To me it was a spacious and awe-inspiring Edifice, with windows of peculiar shape, and a square Tower which was the measure of height— ‘as high as the church steeple.’ The broad path curved up to it from a tall old iron gate, through grassy hillocks and ancient tombstones, some of them quaintly carved. The Church stood on the highest ground, and commanded a wide prospect, from its tower-top a panoramic one. Eastward you saw the river rushing down its rocky dell, and behind this some of the hilltops that guard the unseen great Lake out of which it flows. To the south, at a distance of some ten miles, a long range of blue Mountains takes wonderful colours from the changing skies, and in their foldings run up shadowy valleys into a mystical inner region. Between this range and the little gray Town with its long stone bridge, at your feet, spreads the Moy (**math** = plain)—scene of many an ancient fight and foray, an expanse, sloping to the north, of rugged pasture, broken here and there with a rocky copse or farm-shading grove, and many low green **rath**-crowned hills. So one's gaze travelling round to the west, and over the sand-hills and foamy harbour-bar, gladly rests on the great line of the Atlantic Ocean, the nearest land out yonder being two thousand miles away. For north horn of the Bay rises the great rocky precipice called Slieve League, and round to the north and along the northern horizon peer up other blue mountain peaks above a middle distance of gorsy slopes and wind-swept sheepruns, sprinkled with gray rocks and boulders, and hinting to a familiar eye the green circle of a **Rath** on many a low hill. **Mullinashee** (Fairy Hill) this eminence is called on which the Church stands; and not only from it but many another height extensive prospects are visible, with a wide sky overhead, and a pomp and change of cloud-pictures such as I have never seen elsewhere.


Even the streets of the Town afford many a glimpse of green fields, blue mountains, or flowing waters.


The Town and its horizon-circle belonged to each other (in my imagination at least) and gave me a sense of large space and infinite variety, very different no doubt from the image of **Ballyshannon** in the mind of some passing traveller who sees the poor



---

p.31



dull little place, perhaps on one of those by no means unfrequent wet days, and wonders how any human being can willingly live there. But neither was I alone in my feeling. The people of **Ballyshannon** had, and I hope have, their full share of that warm attachment to familiar localities which is notable in the Irish.


‘When a stranger stan's on the Bridge and luks up an' down, mustn't he be delighted!’ said a native to me; and I never heard of any one going to live elsewhere who failed to ‘think long for the ould place’, and, for a time at least, cherish the hope of returning.


Travelling at the time I am speaking of was a rare adventure to poor and even to middle-class people. The journey to **Dublin** was long and costly, and England a strange country which few even dreamt of seeing, except two or three shopkeepers who went once a year to **Manchester** and **Leeds** to buy goods, and the ‘harvest-men’, who brought back home their wages, against the winter, and who like their neighbours invariably thought and spoke of ‘the English’ as of a foreign people, though never, that I heard, uncivilly, unless when some disputation arose. ‘Ameriky’ far off as it was, was a more familiar name and idea; nearly all the letters received and dispatched by the poorer people were from or to that land of promise. The passage-money was but a few pounds, very often sent over by those already in the West, and the emigrants could in many cases embark in their own familiar harbour. I never heard any one express the least fear of the dangers and hardships of the long voyage in an often tightly-packed and ill-found sailing-ship; but great was the grief at leaving home and ‘the ould counthry’, and vehemently, though not affectedly, demonstrative were the frequent parting scenes.


It has always been supposed that some countries have, so to speak, a peculiar magnetic attraction for the souls of their children, and I found plenty of reason, in the conduct of my neighbours as well as my own consciousness, to count Ireland as one of these well-beloved motherlands. This home-love is strongest in the dwellers in her wild and barren places, rock-strewn mountain glens and windy sea-shores, notwithstanding the chronic poverty in which so many of them live. In these remote and wild parts Erin is the most characteristically herself, and the most unlike to Saxon England. Her strange antiquities, visible in gray mouldering fragments; her ancient language, still spoken by



---

p.32



some, and everywhere present in place names, as well as phrases and turns of speech; her native genius for music; her character—reckless, variable, pertinacious, enthusiastic; her manners—reconciling delicate respect with easy familiarity; her mental movements—quick, humorous, imaginative, impassioned; her habits of thought as to property, social intercourse, happiness; her religious awe and reverence; all these, surviving to the present day, under whatever difficulties, have come down from times long before any England existed, and cling to their refuge on the extreme verge of the Old World, among lonely green hills, purple mountains, and rocky bays, bemurmured day and night by the Western Ocean.


I never came back to the **Ballyshannon** country after an absence, without thinking that it looked to be the oldest place I ever saw.


This impression was aided by the character of its superabundant surface rocks—gray gneiss, gray mica-schist masked with yellow lichens, dark gray limestone, weather-stained, or knobbly with mysterious fossils; and the fields too are commonly intersected with rude fences of loose gray stones picked from the soil. But hints and tastes of a richer scenery were not wanting, and all the more prized for their rareness. Productive gardens and orchards there were about the Town, plenty of flowers and fruit, few trees of any size (mostly sycamores and ashes), but here and there a little grove shaded the lawn and avenue of a modest country house, and a mile or two up the rapid River thick copses mingled with large trees embowered the waterside. A small well-wooded park in that region, called **Camlin**, seemed to me the very type of rich sylvan beauty, and my imagination no doubt soon caught rumours and formed pictures better than could ever be realised of the great Lake beyond, with its forested promontories and ‘an island for every day in the year.’ In the opposite quarter, that is on the west, our landscape reached the extreme of bareness, rough rocky pastures, miles of rabbit-warren and seastrand, sward of Atlantic headlands shaven by the salt gale as by a scythe, with here and there a hawthorn bush or still rarer hedge, stretching wildly away to the eastward as though fain to flee altogether, almost the only arboreal things to be found far or near. The wild shore and boundless tossing sea, ebb and flow of the tide, ships, fishermen, wrecks, new lands beyond the sunset,



---

p.33



set, these helped no little to feed and stimulate the childish imagination.


But of all the external things among which I found myself, nothing impressed me so peculiarly as the *Sound*, the Voice, which ceased not day or night; the hum of the Waterfall, rolling continually over its rock ledge into the deep salt pool beneath. In some moods it sounded like ever-flowing Time itself made audible.


The pool below the cataract was one of the chief scenes of the salmon-fishing, so important to the town, and summer idlers had an untiring pleasure in lounging on the high green bank to watch the boats swiftly casting out and slowly hauling in their nets. Angling on the upper waters brought us every year, from April or May till August, a succession of visitors, often English, and we were further and more permanently enlivened by the presence of troops, **Ballyshannon** being an important military post, the gate between Connaught and Ulster. At the beginning of the century it had Infantry, Cavalry, and Artillery Barracks, fully occupied, I think, up to 1815. The Cavalry Barrack had been allowed to fall into ruin, and its black grass-grown walls had a strange and fascinating horror for the boyish mind; but the Infantry Barrack was always more or less occupied, and the marching of the redcoats (especially to and from church), the playing of the bands, and the various bugle-calls at their regular times of the day, made a great impression. The Officers too were an interesting and frequently varying element in society. Officers arriving were sometimes billeted on private houses, and I remember the presence of mysterious military guests in our house more than once, on these terms. These, no doubt, were occasions of emergency, when it was suddenly found expedient to strengthen the garrison on rumour of an intended ‘rising’, or in consequence of some unusual display of lawlessness. I came early to the consciousness that I was living in a discontented and disloyal country; it seemed the natural state of things that the humbler class—which was almost synonymous with Roman Catholic—should hate those above them in the world, and lie in wait for a chance of despoiling them. Yet I never for a moment believed this of any of the *individuals* of this class amongst whom I lived. I used to fancy and sometimes dream frightfully of a swarm of fierce men seizing the town, bursting into the houses, etc.; of soldiers



---

p.34



drawn out in rank with levelled guns, of firing, bloodshed, and all horror.


Once there was something like an approach to realisation. It must have been at a time when our garrison was temporarily withdrawn or reduced to a detachment, that a rude army of **Whiteboys** actually marched through the town, armed with scythes, pikes, and I know not what. I was turned six years old then. I remember being at the corner of our lane, holding somebody's hand or lifted in somebody's arms, and have a most dim yet authentic memory-picture of a dark wild procession of men, crowded closely together, holding and brandishing things over their heads. It streamed past us up the long hill of the Main Street, and I daresay I was taken home before it had passed by, for in the dim picture it is always seen passing on and up interminably, a dark throng with pikes and scythes held aloft. I looked with curiosity unmixed with dread; but it was probably after this that the dread showed itself in dramatic forms in my dreams. I have been told that my Aunt Bess on this day was walking through the Purt (a long straggling street on the south side of the river) when she met the mad looking multitude with their pikes, etc. Someone said, ‘That is Miss Allingham going to visit the poor’ and they opened a way for her to pass through.


No outrage at all, I believe, was done by the ‘Whiteboys’, or whatever they were; and in fact I have never, since I was born, known or heard of any political or secret society offence in our Town or its district. **Ballyshannon** was a sort of island of peace in my day, as it had been for generations, and I hope is carrying on the good tradition. We were far from centres of excitement and agitation; **Dublin** remote, the nearest considerable towns some twenty-five and thirty miles distant, and the scene of our county elections to Parliament (very seldom contested) still further away. We were a Borough (with two members) in old College Green days, but had luckily lost that privilege, which is a real curse to a small town. Newspapers were unknown to the humbler, and rare with the middle classes. All the country gentry and nearly all the well-to-do people were Protestants, having the ascendency naturally belonging to money and education, and their connection with a State-privileged Church was, I imagine, less noticeable; that is, there was little if any political feeling on this head, though plenty of theological aversion and contempt on



---

p.35



both sides; and in any sort of public dispute or collision, Catholics and Protestants (Orangemen, mostly of the smaller farmer class, were those who were apt to show up on such occasions) ranged themselves as by instinct, or chemical affinity, on opposite sides.


Along with other helps to a comparatively tranquil existence, **Ballyshannon** had a most peace-loving and peacemaking Parish Priest in Father John Cummins, whose big figure wrapt in voluminous coats, big stick, good-humoured big face crowned with reddish bob-wig and wide-brimmed hat, was one of the permanent institutions of our social existence throughout my boyhood and youth-hood, whatever curates might come and go. My father had no difficulty in exchanging many a neighbourly greeting and chat with Father Cummins, whose burly person standing on such occasions with legs apart, whose good-humoured brogue and hearty laugh that shook him all over—‘Upon me conshince, Misther Alligham!’— I well remember. He told one day with a big laugh how grateful another Protestant neighbour was on getting back some stolen goods by virtue of the Confessional, saying earnestly—‘I protest, Mr Cummins, this restitution of property is a gr-rand fayture in your religion!’ and my Father too was sometimes advantaged by the same means. Father Cummins was nothing of a theologian, but he was duly proud of his great ancient Church, and used sometimes to ask an opponent with dignity the well-known question—‘Where was *your* Church before Luther? Tell me that, sir!’ He lived in a neat thatched cottage at the top of the town, with an elderly housekeeper, and a boy who drove him to distant parts of the parish in an old-fashioned jaunting-car, the pony, fat and sleek as a mole, being seldom allowed to go at faster pace than a quick walk. The good priest's great dread was of taking cold. He believed in fast-shut doors and windows, huge fires, heaps of bedclothes, and nobody but his housekeeper ever knew how many coats, waistcoats, and other integuments he was accustomed to wear. In diet I believe he was moderate, and he lived to old age without ever making an enemy. His successor, a tallish, dark, lean, shy man, was no less peaceable in life and teaching.


‘The Rector’, as he was always called, but properly the Vicar of **Kilbarron**, at the time when I appeared upon the scene in a very small part, was the Reverend Robert Packenham, brother to



---

p.36



the wealthy lay rector, who took the name of Conolly for his aunt's property and was the chief landowner in our parts and long M.P. for the county.


I was probably about four years old when they began to take me to church on Sundays. The edifice appeared to me spacious, lofty, and venerable. It was cruciform, with round-topped windows, the ground floor filled with high pews. There were three galleries—‘the Singing Gallery’ over the west door; ‘the Soldiers' Gallery’ in the north transept; ‘the Country Gallery’ in the south transept, used mostly by small farmers and their families. The townsfolk and the country gentry had pews in the body of the church; some very poor people sat on benches in the aisle, and, at the other end of the scale, two families had notably large and comfortable pews, the Conollys in the right-hand corner as you came in by the west door, the **Tredennicks**[2](javascript:footNote('E850006-003/note002.html')) of **Camlin** in the left. The Tredennick pew was a place of mystic and luxurious seclusion to my fancy, a sort of imperium in imperio. Its woodwork completely partitioned it off from the aisle, but chance peeps showed a snugly cushioned and carpeted interior, and even a special little fireplace with its special little bright fire on winter Sundays. In later days I knew a high lady who deemed it proper to go regularly to church once a week, but evaded part of the tedium by taking with her a novel or other amusing book, decently veiled in a dark cover. With such a pew as this she could have made herself very comfortable; but if anything of the kind occurred there (which probably never did) I had no suspicions of it.


Essentially, neither service nor sermon had the very slightest interest or meaning for me, but the sense of a solemn stringency of rule and order was deeply impressed, and the smallest infraction, it was felt, might have unimaginable consequences. A child's prayer-book falling from the gallery astounded like an earthquake; and once, I remember, when the congregation suddenly started up in the midst of the service, pew doors were thrown open, and people ran out into the aisles (a lady had fainted)—it was really as if the Day of Judgment had come. Connected with Church and churchyard was a thought, vague, vast, unutterably awful, of that Last Day, with Eternity behind it: yet it was definitely localised too, and it seemed that not only



---

p.37



the Rising but the Judging of our particular dead must be in our own Churchyard.


A terrible thought of Eternity sometimes came, weighing upon me like a nightmare—on and on and on, always beginning and never ending, never ending at all, for ever and ever and ever till the mind, fatigued, fell into a doze as it were and forgot. I suppose this was connected, though not definitely, with the idea of a state of punishment. The suggestion of eternal happiness took no hold upon my imagination; my earliest thought of Heaven pictured it as a Sunday street in summer, with doorsteps swept and the shutters of the shops closed. Later, there was a vague flavour of Church and psalmody.


Our Pew, painted like the rest a yellowish colour supposed to imitate oak, was halfway up the Church, on the right-hand side of the central aisle, and had the distinction of a tall flat Monument of wood (or it seemed tall), painted black in George the Second taste, rising on the wall behind it. Atop was a black urn with faded gold festoons; at each side a pilaster with faded gold flutings; and there was a long inscription in faded gold letters.


It seems to me very curious that, after sitting so many an hour, so many a year, in that Pew, and recollecting numberless little things around me there, I cannot find in my memory one word of that inscription, except ‘SACRED’ in a line by itself at the top, in Old English letters—not even the chief name, which was a lady's (a remote and very slightly interesting relation or connection of ours, she must have been), nor the import of those Roman symbols which so ingeniously disguise a date to modern eyes. The wording no doubt was highly conventional, as nearly as possible meaningless, and felt by the child to be a sort of dull puzzle which after some attempts it was better to avoid. Had it been *verse*, of even moderate quality, it would have fixed itself in my memory; with point, it would have stuck there for ever.


My usual place in the pew (habitude, or customariness, or whatever it may be called, being naturally strong in me) was the left-hand corner next the door, as you went in. Standing on the seat, I could look up and down the aisle, and sometimes rest my arms and head on a little triangular shelf that fitted into the corner. When I had, against the grain, to sit down, I kept looking at the faces of the people near to me in the Pew, and the countenance of a certain half-pay Army Lieutenant, ruddy, swarthy, with



---

p.38



a longish nose somewhat bulbous at the end, holds a very disproportionate place in my memory, because he generally sat in full view. The tedium of the service was also mitigated by the interest which I acquired in watching for the regular recurrence of its various stages, with the attitudes—of sitting, standing, or kneeling—appropriate to each. Certain phrases were greeted as milestones upon the journey; and at the end of the sermon (usually the most trying part of all, and of indefinite length) the words, ‘Now to God the Father’ etc., caused an unfailing gush of inner satisfaction. There was something curious and amusing in the Litany with its responses, but it was mostly meaningless to me, as indeed was the Service as a whole (both at this time and later in life). The mystic phraseology had of course its effect, as any other such would have had, and the regular recurrence and solemn repetition of the performance. The gathering together, too, of neighbours, rich and poor, old and young, as in the presence of the Universal Father and Ruler, has an impressiveness different from anything else in daily life. If it could indeed be done simply and purely ‘in spirit and in truth!’ But here, in our small community, a section only of the neighbours drew together at the set solemn seasons; another section, though animated by the same motives, drew together in different place and manner, drew apart from the former gathering, many of whom came from the same households; and in the very act of worship both sections displayed and emphasised feelings of mutual suspicion, contempt and animosity.


Once or twice I was taken clandestinely to mass by a nurse, on some Saint's Day most likely, and stood or sat for a while just inside the Chapel door. It felt like a strange adventure, with some flavour of horror, but more of repulsiveness, from the poverty of the congregation and the intonation of the priests. I remember arguing with my nurse Kitty Murray (who only died this year, 1883, at the supposed age of ninety-three—but I don't think it was she who took me to the chapel), for the superiority of Protestantism because ‘the Catholics, you see, are poor people;’ to which Kitty replied, ‘It may be different in the next world.’ A good answer, I felt, and attempted no retort; being indeed at no time of my life addicted to argue for argument's sake, or for triumph.


Although very brisk in body and mind, my health from the



---

p.39



first was considered delicate. I was thin and pale, and for several years—between my fifth and eighth, perhaps—there was a swallowing of nauseous doses to be gone through several times a day. But this was nothing to the Surgeon's frequent visits with his horrible lancet, in consequence of a swelling on the middle finger of the right hand (which remains contracted), and even in memory the bitter pain of the repeated cuttings makes me wince. My Aunt Bess used to ‘dress it’, a disagreeable operation for both of us. She was the Maiden Aunt of the family, at this time between forty and fifty, very charitable and helpful from an unwavering sense of duty, and inflexibly ‘low church’ in her religious opinions and practices. She did her duty by me, as by everybody, with firmness, regularity, and a general good sense; what was missing in her ministrations was that soothing personal atmosphere of love and sympathy which does everybody good without effort, and especially children. This blessing I should doubtless have enjoyed from my dear Mother, had her short married life been more fortunate. At my grandmother's, besides my Aunt Bess, lived two younger Aunts, Maryanne and Everina. Aunt Everina glides through my memory little more than a mild pale shadow, straight and slender, and low-voiced. She had by nature a pictorial gift, and painted in water-colour-flowers, landscapes, portraits of friends and neighbours—as well as one might be expected to do who had no training and never saw any examples of good work. Aunt Everina's health was delicate, and she was perhaps about twenty-eight years old when she died.


Aunt Maryanne, the youngest, or youngest but one, of my Grandmother's large family was, both in person and temper, short and brisk with nez retrouss� and lively gray eyes. She was quick and excitable, spoke fast, and a troublesome child would pretty soon feel her hands as well as her tongue. She was a Poetess, and wrote much on local and family subjects, but her simple ambition never even dreamed of actual print, and contented itself with sheets of notepaper, and little stitched books, neatly written out in something like printing letters, and given away to her friends. I have in my desk a ballad of hers on my father's approaching wedding—‘Will's to be married to Maggie’, etc.—O Time!


Aunt Maryanne was a voracious novel-reader. The winter



---

p.40



evenings come clearly before me; my Grandmother in her armchair by the fire, with close cap, knitting incessantly, her snuffbox on a little table, an old cat called ‘Norway’ snoozing on the hearthrug and sometimes jumping into her lap; Aunt Bess also knitting, grave and silent; Aunt Maryanne reading aloud a Waverley Novel. I used to sit with paper and pencil, ‘drawing’ and also listening to the story. At any thrilling crisis ejaculations of interest or excitement were heard, and the end of a chapter often gave rise to comments, always on the incidents and characters, just as though they were real, never on the literary merits of the work or the abilities of the author. Criticism of the latter kind was all but unknown in our circle, and surely its estate was the more gracious.


When I acquired, no one knew how, the art of reading rapidly, and at once applied it to every readable thing that came my way, I used sometimes to find my Aunt's novel in the daytime and take a run into the story in advance of the evening reading. On one or perhaps two occasions when I afterwards sat listening, I was unable to resist the temptation to give a hint of what was coming, whereupon Aunt Maryanne, starting up from her chair, clutched me firmly with both hands and bundled me out of the room—a very justifiable assault. **Scott** of course furnished the staple of the winter evenings' entertainment; but some minor story-tellers contributed to the amusement. I remember Galt's Laurie Todd, and Horace Smith's Brambletye House, with the catchword, ‘Think of that, young man!’


I think the Waverley Novels that most impressed me in those early days were Guy Mannering, The Antiquary, Ivanhoe, Kenilworth, The Talisman, but there were scenes in Waverley, The Fortunes of Nigel, Quentin Durward, The Fair Maid of Perth, The Pirate, The Monastery, vivid as any real experience. In Poetry **Scott** again was first favourite, and the verse-novels of The Lady of the Lake and Marmion.


*Here William Allingham's account of his childhood ends. The following reminiscences of his schooldays are given from two letters, the first written by his brother John in 1904, the second by an old schoolfellow, Mr Robert Crawford, the Engineer:*




---

p.41



> 
> I can recall Willy since the thirties of last century, i.e. since he was seven or eight years old. In 1837 or 1838 he and I occupied the same bedroom in the old Bank House on the Mall. It had one window looking west—a gable window—and off the room was a closet containing a number of books and pamphlets in the Norwegian and English languages. I remember the great storm of January 1839, and the window of our room being blown in, notwithstanding a feather bed being placed against it. Willy, I think, used sometimes to walk in his sleep at that time. He was very agile and expert at all juvenile games. He was then attending Wray's School in Church Lane, then the only school in **Ballyshannon** indifferently attended by Catholics and Protestants. Wray taught Latin—nothing else. Willy left this school in the Spring of 1837 to go to a boarding-school at **Killeshandra**, Co. **Cavan**, kept by one Robert Allen, a commonplace person of the cocksure evangelical type. After a short time there my father got him into the Provincial Bank at **Ballyshannon** (of which he was Manager). This was in 1838, when Willy was fourteen years old: in December 1839 he was moved to the Armagh branch of the Bank—and later to the Strabane and Enniskillen branches in succession.
> 
> 
> 



> 
> He was a particularly bright and clever boy, and conquered the most difficult lessons with a facility that made him an object of envy to his less brilliant comrades. He devoted just sufficient time to his prescribed lessons to enable him to hold his own with Classwork, while he diligently pursued investigations on his own account in a far wider field of learning. As a result he frequently caused surprise to his seniors, by the fixed opinions he held upon many subjects usually supposed to be suited only to the comprehension of intellects of maturity, and by the clear manner in which he expressed his convictions concerning them. He was a great lover of Nature in all her phases, and particularly humane towards dumb animals, of which, however, so far as I know, he never made pets. Sports he abstained from, on principle, considering them cruel.
> 
> 
> 




*Allingham's recollections of boarding-school were by no means happy. He was still delicate in health, and an accident at this time to his sore finger produced severe inflammation of the arm, and necessitated surgical treatment. He was at Killeshandra for a year only; at the age of fourteen his school education was brought abruptly to an end.*


*His father, now married again, had been out of health for some time, and told by a doctor that he could not live very much longer: he determined, therefore, to put William, at once, in the way of earning his own living, and found him a place in the Bank at **Ballyshannon**.


---

p.42




Here the lad began a seven years' service to his uncongenial work. The sudden end to the possibility of all further organised study and education was, to him, a deep disappointment and lasting regret. In December 1839 he was moved to the Armagh branch of the Bank, and here he was, at first, often very lonely and homesick. From Strabane Allingham wrote on 11 May 1841, asking his father to send him ‘Elia, first series, and Shelley poems. I shall return Elia second part and Lamb's Tales. Johnson's Poets are very welcome and a great treat.’ In the summer of 1843, at the age of nineteen, he paid his first visit to London. The following was written to his father at this time.*



> Norfolk Hotel, Surrey St, 
>   
> 
> Strand, 22 July 1843
> My Dear Father
>   
> 
> 
> Here I am in a very quiet place, within twenty yards of the busiest street in London.
> 
> 
> I slept in Oxford, the night before last, and saw most of the city, the Bodleian Library, etc. I have seen no place equal to it, to please my taste. Old churches, colleges and halls at every step, and plenty of old houses with gables to the street and latticed windows.
> 
> 
> I can find my way here capitally. I walked this morning, before breakfast, to St Paul's, round by Newgate St, Holborn, and Drury Lane. A matter of between two and three miles, I should think.
> 
> 
> I write to let you know where I am. Of my journey I will tell you no more at present, except the following facts, which I thought rather droll
>   
> 
> 1st, then, —at Stafford, in the neighbourhood of the great potteries, we had a *horn* vessel to drink from.
> 
> 
> 2ndly, at Birmingham (the World's Toyshop) a large shop had no ‘Chinese Tumblers’.
> 
> 
> 3rdly, at the Angel Hotel, Oxford, the bedroom was supplied with a Cambridge Bible—and lastly, the first tune I heard in London was the Sprig of Shillelagh.
> 
> 
> Yours, my dear father, truly,
>   
>  
> W. Allingham, Junior




*After seven years in the Bank, Allingham obtained, at the age of twenty-two, a post in the Customs. An account of this is given, as follows, in the few remaining pages of this first part of his autobiography.*




---

p.43


1846


Heartsick of more than seven years of bank-clerking, I found a door suddenly opened, not into an ideal region or anything like one, but at least into a roadway of life somewhat less narrow and tedious than that in which I was plodding. My father was offered a place in the Customs for my brother; John was too young for the post; it could not be kept vacant and was offered to me. In the spring or summer of 1846 I gladly took leave for ever of discount ledgers and current accounts, and went to **Belfast** for two months' instruction in the duties of Principal Coast Officer of Customs, a tolerably well-sounding title, but which carried with it a salary of but £80 a year. I put up at a Temperance Hotel in Waring Street, slept soundly (O Youth!) in a small front room in that narrow noisy thoroughfare, trudged daily about the docks and timber yards learning to measure logs, piles of planks, and, more troublesome, ships for tonnage: indoors part of time practised Customs book-keeping, and talked to the clerks about literature and poetry in a way that excited some astonishment, but, on the whole, as I found at parting, a certain degree of curiosity and respect.


I preached Tennyson to them, hitherto an unknown name, and recited bits from Locksley Hall, meeting at first a cold reception, but afterwards better acknowledgment. One of the head clerks came up to me one morning with the greeting, ‘Well, I've read Locksley Hall, and it's a very fine poem!’


I don't recollect being at a theatre in **Belfast**. I went a few times to a music hall, but my spare time was mostly spent in reading and haunting booksellers' shops, where I venture to say I laid out a good deal more than most people in proportion to my income, and managed to catch glimpses of many books which I



---

p.44



could not afford or did not care to buy. From **Belfast** I repaired to the little town of **Donegal**, and entered on my office of Principal Coast Officer of the district, a very large one extending over many miles of coast, the greater part of it wild and rocky and lying exposed to the full violence of Atlantic gales and waves. Visiting wrecks was part of my duty, which sometimes demanded long journeys in stormy weather over rugged hilly roads, on an outside car, with various attendant discomforts which would now seem appalling. But these expeditions on the whole were pleasures, and have left pleasurable memories. They were part of the freer physical life upon which I entered in passing from the Bank to the Customs. Her Majesty's Customs at **Donegal** occupied a narrow little first-floor room in Dillon's Hotel, a goodsized and comfortably kept house, where I also boarded and lodged at moderate annual rate, having a back room where my meals were served to me separately, by particular favour, and the chairs, tables, and sometimes the floor, were piled and littered with books of all sizes, old and new. Here I could sit reading for hours every day with little interruption, stepping across the passage when wanted at my office to receive notice of the arrival of a vessel, or sign her papers when outward-bound, or make out a Light-Bill (so much for each Lighthouse passed on the voyage), or witness the engagement or paying-off of seamen. Outdoors, there came the occasional visiting of vessels, measurement of logs and deals, and ‘breadstuffs’ (chiefly maize) and—by far the most troublesome business, but the most interesting—the examination of the fittings and provisions of Emigrant ships, and the calling over, when ready for sea, of the lists of Passengers, who came forward one by one, men, women, and children, to pass the doctor and myself. There were also visits to coastguard stations, to navy and other Pensioners, and now and again, as I have said, to a Wreck, usually at some distant part of the coast.


I was the only Customs Officer in the district, which suited my mood perfectly, but no doubt helped to foster the feeling of isolation which is so strong in me. My district was officially ‘in the Port of **Sligo**’, to which I sent monthly accounts, and the collector visited me once a quarter, and I was also in some respects under the sub-collector of **Ballyshannon**; but there was seldom any interference. My family name was a guarantee in itself; I discharged my functions intelligently and conscientiously,



---

p.45



as well as with popularity, and the nature of them and of the locus in quo, gave me a scope and freedom of action, and a personal respect everywhere, not usually associated with so humble an official position as mine. I enjoyed my new position on the whole, without analysis, as a great improvement on the Bank; and, for the rest, my inner mind was brimful of love and poetry, and usually, all external things appeared trivial save in their relations to it.


Yet I am reminded by old memoranda that there were sometimes overclouding anxieties, sometimes, but not very frequently, from lack of money, more often from longing for culture, conversation, and opportunity; oftenest from fear of a sudden development of some form of lung disease, the seeds of which I supposed to be sown in my bodily constitution. I can recall few details of my first year at **Donegal**.


I used to go over often to **Ballyshannon** in the evening and return in the morning, or from Saturday to Monday, sleeping at my Father's; generally travelling by the **Derry** and **Sligo** mailcoach, and kept up all my old intimacies with the places and people by the **Erne**.


I had for literary correspondents **Leigh Hunt**, **George Gilfillan**, and **Samuel Ferguson**; and for love-correspondent, F., whose handwriting always sent a thrill through me at the first glance and the fiftieth perusal. What a day it was when one of those letters reached me!—all the more prized for the difficulties that beset their transmission. I loved an Ideal, angelically fine, impossible to hurt or destroy as a dream of Heaven; but it had a very sweet little human core, which (I am thankful) keeps its springflower-like tenderness in my memory. Appropinquity can breed love, it can sometimes sully or kill it. Fate kept us mostly separated in space even while we were one in spirit; our rare meetings were, to me at least, mystically sacred occasions.


*The story of William Allingham's life, in strict autobiographic form, ends at this point. He wrote out, from his notebooks, conversations he had had with interesting men, evidently with the intention of incorporating them in his account, but beyond this date nothing was completed. The story is continued in diary form, the first entry being in June of the following year.*












