

#The Manners and Customs of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Manners and Customs of Ireland
==================================


Author: Fynes Moryson
---------------------


### File Description

Charles Hughestranslated by Charles Hughes Electronic edition compiled by Beatrix Färber , Janet Crawford

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 2. Second draft, revised and corrected.Extent of text: 

7530 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100073Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Oxford, Corpus Christi College Library, MS 94.
**Editions/Translations**2. Fynes Moryson, A History of Ireland from the year 1599 to 1603: with a short narration of the state of the kingdom from the year 1169; to which is added a description of Ireland. 2 vols. Dublin 1735. [A reprint of part 2 and 3, Book 3, chapter 5 of the *Itinerary*.]
3. Henry Morley (ed.), Ireland under Elizabeth and James the First, described by Edmund Spenser, by Sir John Davies, ... and by Fynes Moryson, Carisbrooke Library Series 10, London and New York 1890.
4. Charles Hughes, Shakespeare's Europe. Unpublished Chapters of Fynes Moryson's Itinerary: being a Survey of the Condition of Europe at the end of the Sixteenth Century. With an Introduction and an Account of Fynes Moryson's Career. London: Sherratt & Hughes 1903 [for chapters on Ireland see especially pp 185–260; 285–289; 481–486].
5. Fynes Moryson, An itinerary, containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland & Ireland. 4 vols. Printed at the University Press by Robert Maclehose & Company Ltd. for James Maclehose and Sons, Publishers to the University of Glasgow, 1907–1908. [Reprint of 1617 edition.]
6. Graham Kew (ed.), The Irish sections of Fynes Moryson's unpublished itinerary, Dublin: Irish Manuscripts Commission 1998 [first published in Analecta Hibernica 37 (1995/1996) 1–137].
7. Internet resources at www.archive.org. An electronic text containing an English translation of Fynes Moryson's Itinerary has been made available by the University of Toronto Centre for Classical and Renaissance Literature.
**Further readig: A selection**2. Edward Campion, A historie of Ireland (London 1571; facsimile, ed. M. Hamner, reprinted 1971).
3. Richard Stanihurst, A Treatise containing a Plain and Perfect Description of Ireland (London 1577).
4. Barnaby Rich, New Description of Ireland, London 1610.
5. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
6. John Dymmok, 'A treatice of Ireland. Edited by Richard Butler', Tracts relating to Ireland 2, 1–90, Irish Archaeological Society (Dublin 1843).
7. Luke Gernon, 'A discourse of Ireland, anno 1620'. In: C. L. Falkiner (ed.), Illustrations of Irish history and topography, mainly of the seventeenth century. (London, New York, Bombay 1904) 345–362.
8. William Lithgow, The totall discourse of the rare adventures & painefull peregrinations of long nineteene years travayles from Scotland to the most famous Kingdomes in Europe, Asia and Affrica. Glasgow, 1906.
9. William Lithgow, Rare adventures and painful peregrinations of long nineteen years travayles (1632). Reprint, edited with an introduction by Gilbert Phelps. (London 1974).
10. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." Paris, 1653.]
11. Albert Jouvin, de Rochefort, Description of Ireland after the Restoration. [This is an extract from vol. vi, pp 472–493 of Albert Jouvin, de Rochefort, Le Voyageur d'Europe: où sont les Voyages de France, d'Italie et de Maltre, ... Paris 1672.] The English translation is taken from Francis Grose and Thomas Astle (eds.), Antiquarian Repertory: A Miscellaneous Assemblage of Topography, History, Biography, Customs, and Manners (1775?–)1779; reprinted London 1807–1809 for Edward Jeffery.
12. Thomas Dinely, Observations on a tour through the kingdom of Ireland in 1681. Dublin 1858. Reprinted by E. P. Shirley (ed.) as 'Observations in a voyage through the kingdom of Ireland, 1680', Journal of the Kilkenny and South-East of Ireland Archaeological Society, new ser., 1 (1856–1857), 143–146, 170–188; new ser., 2 (1858–1859), 22–32, 55–56; new ser., 4 (1862–1863), 38–52, 103–109, 320–338; new ser., 5 (1864–1866), 40–48, 268–290, 425–446; new ser., 6 (1867), 73–91, 176–204.
13. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman. Dublin 1846.
14. Charles Smith, The ancient and present state of the county and city of Cork: Containing a natural, civil, ecclesiastical, historical, and topographical description thereof. Dublin: printed for W. Wilson, 1774. Reprinted by the Cork Historical and Archæological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork: Guy & Co., 1893–1894.
15. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. Dublin: Printed for W. Wilson 1773; 1774.
16. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979.
17. Walter Harris, The antient and present state of the County of Down. Containing a chorographical description, with the natural and civil history of the same ... With a survey of the new canal; as also, a new and correct map of the County. Dublin, Printed by A. Reilly, for Edward Exshaw 1744. Reprinted Ballinahinch 1979.
18. P. W. Joyce, A Social History of Ancient Ireland (New York, London, and Bombay: Longmans, Green, & Company. 1903. 2 volumes.
19. P. W. Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe. Dublin: Éamonn de Búrca for Edmund Burke 1995.
20. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history. 3 vols. (London 1885–1890). (A digital copy is available at www.archive.org.)
21. J. C. Whitebrook, Fynes Moryson, Giordano Bruno and William Shakespeare, Notes and Queries 171 (1936) 255–260.
22. Gilbert Waterhouse, Fynes Moryson: traveller, Bulletin, Irish Committee of Historical Sciences, 36 (1945).
23. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
24. F. Walsham, Fynes Moryson and four indentures, Lincolnshire Historian 2:2 (1955) 18–23.
25. L. W. Kenny, Contemporary sources for Essex's lieutenancy in Ireland, 1599, Irish Historical Studies 11:41 (1958/1959) 8–17.
26. Kemp Malone, 'Bonnyclabber', Celtica 5 (1960) 142.
27. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
28. Hiram Morgan, The Battle of Kinsale (Bray 2004).
29. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 310–325 of the volume, being the fourth and last volume, Book 5, chapter 5 of Moryson's *Itinerary*.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text was first edited by Charles Hughes in Shakespeare's Europe, and reprinted in the Illustrations of Irish History by C. Litton Falkiner, from which it is taken. The sections in square brackets were translated by Falkiner. Footnotes by Falkiner are included in note tags.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the chapter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, organisational and personal names and terms are tagged. Words and phrases from languages other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: Tanslation by Charles Hughes and C. Litton Falkiner (see above)

 (1902–1903) #### Use of language


##### Language: [EN] The translation is in English.


##### Language: [GA] A few words are in Irish.


##### Language: [LA] A few words are in Latin.


### Revision History


* (2010-07-19) Beatrix Färber (ed.)

* Conversion script run, header updated; more encoding added; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-10-19) Beatrix Färber (ed.)

* Keywords added, file validated; minor modifications made to header.
* (2007-04-04) Beatrix Färber (ed.)

* File proof-read (2); marked up; file parsed; SGML and HTML files created.
* (2007-03-31) Janet Crawford (ed.)

* file proof-read (1).
* (2007-01-25) Beatrix Färber (ed.)

* Header created with bibliography.
* (2007-01-21) Beatrix Färber (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: T100073


### The Manners and Customs of Ireland: Author: Fynes Moryson


The Manners and Customs of Ireland
----------------------------------




---

p.310


Of **Ireland**: Touching nature and manners, bodies and wits, Manual Arts, Sciences, Universities, Language, Ceremonies, Particularly in Marriages, Child-Bearings, Christenings, and Funerals; and also of their divers Customs, Pastimes, Exercises, Particularly of their Hunting, Hawking, Fowling, Birding and Fishing.
In this chapter I will speak of the mere **Irish**. Only I will say for the **English-Irish** that they may be known by the description of our English at home. But as horses, cows, and sheep transported out of **England** into **Ireland** do each race and breeding decline worse and worse, till in few years they nothing differ from the races and breeds of the Irish horses and cattle, so the posterities of the **English** planted in **Ireland** do each descent grow more and more Irish, in nature, manners and customs, so as we found in the last rebellion divers of the most ancient English families, planted of old in **Ireland**, to be turned as rude and barbarous as any of the mere Irish lords. Partly because the manners and customs of the mere **Irish** give great liberty to all men's lives, and absolute power to great men over the inferiors, both which men naturally affect. Partly because the mere **Irish** of old overtopped the **English-Irish** in number, and nothing is more natural—yea, necessary—than for the less number to accommodate itself to the greater. And especially because the **English** are naturally inclined to apply themselves to the manners and customs of any foreign nations with whom they live and converse, whereas the mere **Irish** by nature have singular and obstinate pertinacity in retaining





---

p.311






their old manners and customs, so as they could never be drawn, by the laws, gentle government, and free conversation of the **English**, to any civility in manners or reformation in religion.


Now to return to the mere **Irish**. The lords, or rather chiefs of countries (for most of them are not lords from any grants of our kings, which English titles indeed they despise), prefix O or Mac before their names in token of greatness, being absolute tyrants over their people, themselves eating upon them and making them feed their kern, or footmen, and their horsemen. Also they, and gentlemen under them, before their names put nicknames, given them from the colour of their hair, from lameness, stuttering, diseases, or villainous inclinations, which they disdain not, being otherwise most impatient of reproach, though indeed they take it rather for a grace to be reputed active in any villainy, especially cruelty and theft. But it is strange how contrary they are to themselves, for in apparel, meat, fashions, and customs they are most base and abject, yet are they by nature proud and disdainful of reproach. In fighting they will run away and turn again to fight, because they think it no shame to run away and to make use of the advantage they have in swift running; yet have they great courage in fighting, and I have seen many of them suffer death with as constant resolution as ever Romans did. To conclude this point, they know not truly what honour is, but according to their knowledge no men more desire it, affecting extremely to be celebrated by their poets, or rather rhymers, and fearing more than death to have a rhyme made in their disgrace and infamy. So as these rhymers—pestilent members in that commonwealth—by animating all sorts by their rhymes to licentious living, to lawless and rebellious actions, are so much regarded by them as they grow very rich, the very women, when they are young and new married, or brought to bed, for fear of rhymes giving them the best apparel and ornaments they have.


The **Irish** are by nature very factious, all of a sept or name living together, and cleaving close one to another in





---

p.312






all quarrels and actions whatsoever, in which kind they willingly suffer great men to eat upon them, and take whatsoever they have, proverbially saying ‘Defend me and spend me’; but this defence must be in all causes, just or unjust, for they are not content to be protected from wrong, except they may be borne out to do wrong.


They are by nature extremely given to idleness. The sea coasts and harbours abound with fish, but the fishermen must be beaten out before they will go to their boats. Theft is not infamous but rather commendable among them, so as the greatest men affect to have the best thieves to attend upon them; and if any man reprove them, they answer that they do as their fathers did, and it is infamy for gentlemen and swordsmen to live by labour and manual trades. Yea, they will not be persuaded that theft displeaseth God, because He gives the prey into their hands, and if He be displeased, they say, yet He is merciful and will pardon them for using means to live. This idleness makes them also slovenly and sluttish in their houses and apparel, so as upon every hill they lie *lousing* themselves, as formerly in the discourse of the Commonwealth.[1](javascript:footNote('T100073/note001.html')) I have remembered four verses, of four beasts that plague **Ireland**, namely, lice upon their bodies, rats in their�houses, wolves in their fields, and swarms of Romish priests tyrannising over their consciences. This idleness also makes them to love liberty above all things, and likewise naturally to delight in music, so as the Irish harpers are excellent, and their solemn music is much liked of strangers; and the women of some parts of **Munster**, as they wear Turkish heads and are thought to have come first out of these parts, so they have pleasant tunes of Moresco dances.


They are by nature very clamorous, upon every small occasion raising the hobou (that is a doleful outcry), which they take from one another's mouth till they put the whole town in tumult. And their complaints to magistrates are commonly strained to the highest points of calamity, sometimes in hyperbolical terms, as many upon small violences





---

p.313






offered them have petitioned to the Lord Deputy for justice against men for murdering them, while they stood before him sound and not so much as wounded.


In the late rebellion we found the **Munster men** to betray the **Earl of Desmond**, their chief leader, into our hands, for their own pardons and rewards of money. But howsoever the state by public proclamation did set a great reward upon the head of **Tyrone** to any should bring his head, and a greater to any should bring him alive, yet the northern men could not be induced by any rewards of money or pardons for their own estates and lives to betray him—no, not when themselves were driven to greatest misery, and he forced to hide his head in the woods without any forces, and only was followed by some few of his most trusty vassals. In like sort by experience we reputed the northern men of better nature and disposition to peace, to civil government, and reformation of religion than the **Munster men**, at that time rebels. For howsoever the northern men followed their lords with all their hearts and powers in rebellious and unlawful actions, yet they did it because they lived by them, and had feeling of their power ready at hand to do them good or hurt, and had formerly no knowledge of the King's power and justice, but far off, and not ready to support and protect them in their obedience, whereas the **Munster men** had long lived happily under the protection of the state and English laws. Yea, when the wars were ended and the English judges went their circuits through all **Ireland**, the northern people more obediently and more joyfully than any other received the English laws and government to protect them from the oppression of great lords and their swordsmen. And howsoever the northern men were generally Papists, yet we considered that they must be so or of no religion, having not formerly been taught any other, whereas the rebels of other parts, by long conversation with the **English** and living among them, had formerly had great opportunity to be well instructed in religion and civil manners.




---

p.314


It is an old saying,




> 
> Rustica gens optima flens, pessima ridens.
> 
> 
> The country clowns are best when they do weep, and worst when they in plenty laugh and sleep.
> 
> 
> 




And this saying may more truly be spoken of the **Irish** than any other nation. For nothing more brings them to obedience than poverty, and heretofore they never had plenty but presently they rushed into rebellion. For particular experience, let them witness who have kept Irish footmen, if ever they could bring any of them on foot again whom once they had set on horseback, and if they have not had better service from them whom they kept most bare in apparel or money, and most subject to correction, than from those they kept most bountifully and used most freely and gently, [2](javascript:footNote('T100073/note002.html')) [*They are by nature superstitious, and given to use witchcrafts. The approved author by **Mr. Camden**, [3](javascript:footNote('T100073/note003.html')) cited in his own words, *says* *they salute the new moon with bended knee, saying to it ‘Leave us as sound as thou findest us.’’’**

**Camden**, Britannia. , 1722; p. 1415.

 He adds incantations they use against wolves, their opinions that some one shall die if they find a black spot upon a bared mutton bone, and their horses shall live long if they give no fire out of the house, and that some ill-luck will fall to their horses if the rider, having eaten eggs, do not wash his hands after them, or be not careful to choose the eggs of equal bigness. That they are much offended if a man commend their cattle, except withal he say God save them, or else spit upon them. That some men's eyes bewitch their horses, and if they prove lame or ill, old women are sought for to say short prayers and use many incantations to recover them. That if a man fall on the ground, he useth to turn thrice about towards his right hand, and to dig up a sod of earth with his sword or knife, to prevent ill-luck.





---

p.315






That they use many like incantations when they go to fight. That women divorced bewitch the men putting them away for the disability of generation, and many diseases against which men use the help of witches. But I will omit many other superstitions and witchcrafts which he there relates.   
[*...*]  
 The same author relates that the Irish were great swearers and forswearers, presuming upon God's mercy, and that to make them keep faith there was no other means but to have them swear before the altar, upon a book opened and laid upon their head, and to swear by some saint or with kissing of a bell, or to swear by the head of the lord of their country which they most feared. Because those lords used to extort cows from them for perjuries, as having therein abused their names.


The bodies of men and women are large for bigness and stature, because they are brought up in liberty and with loose apparel, but generally the very men are observed to have little and ladylike hands and feet, and the greatest part of the women are nasty with foul linen, and have very great *dugs*, some so big as they give their children suck over their shoulders. The women generally are not strait-laced, perhaps for fear to hurt the sweetness of breath, and the greatest part are not laced at all. Also the **Irish** are generally observed to be fruitful in generation, as at **Dublin** in the time of the last war, it was generally known for truth that one of the Segers,[4](javascript:footNote('T100073/note004.html')) while she lodged in the house of Mistress Arglas, bore five children at one birth, and we all know an alderman's wife that bore three at a birth, with many like examples.


For the wits of the Irish, they themselves brag that **Ireland** yields not a natural fool, which brag I have heard divers men confirm, never any to contradict. My honoured lord the late **Earl of **Devonshire**** till his dying day kept an Irishman in fool's apparel, and commonly called his lordship's fool; but we found him to have craft of humouring every man to attain his own ends, and to have nothing of a natural fool. But for the **Irish** generally they are subtle





---

p.316






temporisers, and because they have been used to frequent change of governors, if they cannot attain their own ends, they labour by all shifting devices to delay their adversaries prevailing against them till a new governor be sent, as crafty Davus[5](javascript:footNote('T100073/note005.html')) in the comedy, thinking he had done well to put off his young master's marriage but for one day, hoping that some new impediments might therein arise. They are crafty to observe their governors' humours, and to present to them at their first coming causes of justice formerly determined against them, from whom if they can get (while they are yet unpractised in the affairs) any new decree contrary or differing from the old, they will not cease to make new trouble to their adversaries. Yea many, getting the governor's hand to their petitions, though nothing to their favour, yet have made such use of it with their adversaries at home as if it had been an absolute grant of their requests. If they can fasten upon their governors any bribe (which is always cows), they hold them as slaves for ever. And if they will not be corrupted, but execute justice against them, then are they most clamorous in complaints to the supreme magistrate, or to the State in **England**, and when the inferior governors are called to **Dublin**, or the Lord Deputy recalled into **England**, they fly after them with open throats to load them with false calumnies, especially if these governors happen to be in any disgrace with the state, or have any great enemies at home glad to back their complaints.


[6](javascript:footNote('T100073/note006.html')) *Touching manual arts I have showed that the Irish are most slothful, the swordmen holding it infamy to labour, but none to steal, which may suffice for that point. We read that in the very primitive Church **Ireland** yielded many and learned men called monks, but far differing from those of the Roman Church at this day. Yet I should think they were rather esteemed for holiness than for learning in sciences. For howsoever the Irish, are naturally given to religion (which was holiness in them, but grown to superstition in their





---

p.317






successors), and are also naturally given to a monkish life of ease, yet what learning they had there was gotten among the **Britains** and **Scots**. For I read not of any universities or public schools the Irish had of their own, and their natural disposition to this day makes me think they were not laborious in the study of sciences. In succeeding ages they grew more and more superstitious and ignorant, their priests, monks, and bishops growing generally illiterate, except some few in latter times bred in the universities of the Roman religion, whereof very few or none were of profound learning. And their common lawyers likewise were bred in the Inns of Court in **London**. But at the end of **Tyrone**'s rebellion, the late famous **Queen Elizabeth** having founded a college or university near **Dublin** for education of the Irish, many of whom have therein attained to good reputation of learning, and some few have been reputed in the profession of divinity (for which the said college was chiefly founded) equal to the best and most learned doctors of **England**, as no doubt they want not wit to attain learning when they will be industrious. And since that time (besides the fruits and hopes of this university) the kingdom hath out of **England** been fully furnished with many learned and grave bishops, and as well judges as inferior pleaders of the common law.*


*Touching the Irish language. It is a peculiar language, not derived from any other radical tongue (that ever I could hear, for myself neither have, nor ever sought to have any skill therein); but as the land, as I have showed, hath been peopled by divers nations besides the first inhabitants, so hath the tongue received many new words from them, especially Spanish words from the people coming thence to inhabit the west parts. But all I have said hereof might well be spared, as if no such tongue were in the world I think it would never be missed either for pleasure or necessity.*


*Touching ceremonies of state or of civil actions, the mere **Irish** being barbarous, and loving so to continue, cannot be acquainted with them, which they affect not. For marriage





---

p.318






I will only say of the **English-Irish** that they keep it orderly as in **England**, save that in respect of the law forbidding them to marry with the mere **Irish**, the citizens taking wives within their own walls were grown to be all of kindred one with another, and so forced to marry those of near kindred   
[*...*]  
[7](javascript:footNote('T100073/note007.html'))*


*Touching child-bearing, women within two hours after they are delivered, many times leave their beds to go fop and drink with women coming to visit them; and in our experience a soldier's wife delivered in the camp did the same day, and within few hours after her delivery, march six miles on foot with the army to the next camping place. Some say that commonly the women have little or no pain in child-bearing, and attribute the same to a bone broken when they are tender children; but whatever the cause be, no doubt they have such easy deliverance, and commonly such strange ability of body presently after it, as I never heard any woman in the world to have the like; and not only the mere **Irish**, but most of the **English-Irish** dwelling in the cities. Midwives and neighbours come to help women to be delivered commonly more for fashion than any great need of them; and here is no talk of a month's lying-in, or solemn churching at the end of the month, as with us in **England**. They seldom nurse their own children, especially the wives of lords and gentlemen (as well mere **Irish** as **English-Irish**). For women of good wealth seek with great ambition to nurse them, not for any profit, rather spending much upon them while they live, and giving them when they die sometimes more than to their own children. But they do it only to have the protection and love of the parents whose children they nurse. And old custom is so turned into a second nature with them as they esteem the children they nurse more than their own, holding it a reproach to nurse their own children. Yea, men will forbear their wives' bed for the good of the children they nurse or foster, but





---

p.319






not nursing their own. Yea, the foster-brothers—I mean the children of the nurse and strangers that have sucked her milk—love one another better than natural brothers, and hate them in respect of the other. And by frequent examples we have seen many mourn for their foster-brothers much more than they would have done for their natural brothers; and some to oppose their own brothers to death that they might save their foster-brothers from danger thereof. The worst is that these nurses with their extreme indulgence corrupt the children they foster, nourishing and heartening the boys in all villainy, and the girls in obscenity.*


*In christenings and like rites of religion they use generally the rites of the Roman Church, the which they persist with obstinacy, little care having been taken to instruct them in the reformed doctrine. But in all things they intermix barbarous customs, as when the child is carried to be baptised they tie a little piece of silver in the corner of the cloth wherein the child is wrapped, to be given to the priest, and likewise salt to be put in the child's mouth. And at christenings they have plenty of drink and of flesh meats to entertain the friends invited. Yea, among the very **English-Irish** remaining Papists, the father entertains the guests, though he be a bachelor and have disvirgined the mother, for it is no shame to be or to beget a bastard. Banquets of sweetmeats are unknown to the mere **Irish**, and the nurses are rather beneficial to the children they foster than receive anything of them or their friends (as in the Commonwealth above written I have showed in the abuse of fostering children, both among the mere **Irish** and also among the **English-Irish**).*


*Touching funerals, when they be sick, they never speak to them of making any will, neither care they to have any made, for the wife hath the third of goods, and the children the rest divided amongst them, and the land, after their law of **tanistry**, (which they willingly observe rather than the English) is commonly possessed by the most active and powerful of the sept and kindred, bearing all one *surname*; so as the uncles on the father's side or the mother's many





---

p.320






times invade it, excluding the sons. Neither do they who visit the sick person speak aught to him of good counsel, for his soul's health, which sad discourses they think like to increase his sickness, taking it for a desperate sign of death if the sick person desire to receive the sacrament. But all their speeches tend to mirth and hope of recovery; and the sick person hath about him many lights and great show of company, as if thereby they could keep him from death. Whereof I remember an English gentleman, who, seeing a sick lord of great quality thus surrounded with lights and hundreds of men and women attending in his own and the next chamber, said merrily to a friend: ‘If this man think not better of repentance than he doth, all this light and company cannot keep him from the hands of death and the devil’. And when the sick person draweth to the point of death, the near friends and all the company call and cry out to him, as if they would stay his soul from departing by remembering the goodness of the wife or husband and children, and the wealth and friends to be left behind him, reproaching him with unkindness in forsaking them, and asking whither and to whom he will go to be in better case than he is with them. When the sick person is dead they make a monstrous cry, with shrieking, howling, and clamping of hands; and in like sort they follow the dead body at the burial, in which outcries the nurse, the daughters and the concubines are most vehement. The women especially and children do weekly visit the graves of their dead friends, casting flowers and crosses upon them, with weeping and many prayers for the dead. In like sort, with outcries, they bewail those that die in the war, and in stealths or taking preys, though they think the death of them more happy than any other. The septs of one name carry deadly feud towards the man who kills any of their name, and towards all that are of the same name or sept of him who killed him.*


*Touching divers customs, they seldom eat wild fowl or fish, though they have great plenty of both, because they will not take pains in catching them, and so leave them all for the **English**. They gladly eat raw herbs, as watercresses





---

p.321






and shamrocks, and most commonly eat flesh, many times raw; and if it be roasted or sodd, they seldom eat bread with it or any meat, holding him a churl who hath any bread left after Christmas, save that they keep most of their corn for their horses, whereof they take special care. They drink much **usquebagh**, which is the best aqua vitae[8](javascript:footNote('T100073/note008.html')) in the world, and much sack, but seldom any claret wine. They swallow lumps of butter mixed with oatmeal, and often let their cows blood, eating the congealed blood with butter, and love no meat more than sour milk curdled.[9](javascript:footNote('T100073/note009.html')) In their frequent drinkings and those feasts of flesh, not only the mere **Irish**, but also the old inhabitants of **English-Irish** have the German fashion of putting frolics about the table, as pinching and kissing over the shoulders, and many strange ways, and the manner is to sup where you dine.*


*Generally, or most commonly, the men go bare-headed, except they wear a steel helmet; but they wear long curled hair, which both men and women nourish long and take pride in it, especially if it be yellow. The men wear long and large shirts, coloured with saffron, a preservation against lice, they being seldom or never washed. The men wear short coats and straight trousers, or breeches, and both men and women wear long mantles for the uppermost garment, which the men at night cast into the water, and so upon the ground sleep in them cast over their heads. The women wear many yards of linen upon their heads, as the women do in Turkey; and wear so many bracelets and necklaces, as rather load than adorn. The men, as well mere **Irish** as the old inhabitants of the **English-Irish**, hold it a shame to go abroad or walk with their wives, and much more to ride before them on horseback. They hold it a disgrace to ride upon a mare.  
[*...*]*


*As conquered nations seldom love their conquerors, so in those times **Shane O'Neill**, the great lord of the North, is said to have cursed his people, at his death, if any of them





---

p.322






should build houses or shire towns, to invite the **Englishmen** to live among them. And in most customs they affected to be contrary to the **English**. Myself have heard a worthy old captain, who had served long in **Ireland**, relate some forty customs clean contrary to the **English**, which I have now forgotten and therefore will only instance one or two of them, namely that women took horse on the contrary side to the **Englishmen**, with their faces turned the contrary way, and that the Irish used no harness or traces for horses drawing in the plough or drawing sledges with carriage, but only fastened the plough and the carriage by withes to the tails of the horses (or **garrans**, for so they call them), whereby the tails of them are commonly pulled off, and the very rumps bared. To omit the rest which I cannot remember, we generally observed that not only the women of the mere **Irish**, but also the old **English-Irish**, who could speak English as well as ourselves, yet *dared* not speak it with us if their husbands or their fathers were present. They keep the old calendar, and only the cities have clocks, and keep them as we do in **England**.*


*Touching pastimes. They exceedingly delight in playing at cards and dice, especially at dice; and professed gamesters go about, carrying cards and dice with them,[10](javascript:footNote('T100073/note010.html')) and they will not only play for all the money and clothes they have, but even for the members of their body at a rate of money, suffering themselves to be tied by those members and to be led about till they can free them by paying the rate of money. They delight much in dancing, using no arts of slow measures or lofty galliards, but only country dances, whereof they have some pleasant to behold, as Balrudery, and the Whip of Dunboyne, and they dance about a fire commonly in the midst of a room holding withes in their hands, and by certain strains drawing one another into the fire; and also the matachine dance, with naked swords, which they make to meet in divers comely postures. And this I have seen them often dance before the Lord Deputy in the houses 





---

p.323






of Irish lords; and it seemed to me a dangerous sport to see so many naked swords so near the Lord Deputy and chief commanders of the army in the hands of the Irish **kerne**, who had either lately been or were not unlike to prove rebels.*


*Touching exercises, the activity of their bodies, as well in swift running on foot as in the nimble mounting their horses without stirrups, with the dexterity of using skeans and darts and riding swiftly, shows that they are well breathed in like exercises.*


*Touching hunting, **Ireland** yields some reasonable plenty of fallow deer, as well closed in parks (namely one at **Maynooth**, belonging to the **Earl of **Kildare****, and another in **Munster**, then belonging to the **Earl of **Ormond****, and a third lately made in the north, as I hear, by the **lord of **Belfast****) as also running loose in the woods of the north, of **Ophalia**, of **Leix**, and of **Munster**. And it also yields a few stags or red deer,[11](javascript:footNote('T100073/note011.html')) running loose in the woods bordering upon **Lecale** in the north, and the other woods above-named. And this plenty is the greater because ordinary persons dare not, and great lords of the mere **Irish** will not, hunt them. For the mere **Irish** delight not in the sport, nor care to eat such meats. So as in the time of war, and for all the time I lived there, the English commanders and gentlemen of the army for the most part enjoyed this game running loose in the woods. The **Irish** used to kill both fallow and red deer by shot with the harquebus; and commonly catched his stags by driving them into nets, shouting with a great noise upon the contrary side from the nets, which made them go forward and go into the nets, or by the way stand gazing till they might be shot. They also had an art to catch stags by singing a certain tune upon all sides about them, by which music they fall down and lay as sleeping. Also they catched both fallow and red deer by springes of arms of trees, or young trees half cut and lightly fastened to the ground, upon which while the deer browsed they were caught by the trees, which being loosened from the





---

p.324






ground rose up and many times hoisted and gripped them far from the ground. But of late some of the **English** have brought hounds and greyhounds out of **England** and sometimes used to hunt these deer with dogs. And at the end of the rebellion **Ireland** had great store of hares, but very foggy (?), being not breathed with coursing. The Irish greyhounds are so high that they overbear the hares when they have turned them. But after the wars many of the **English** brought over English greyhounds and hounds to course and hunt them as we do.*


***Ireland** is much annoyed with innumerable wolves,[12](javascript:footNote('T100073/note012.html')) which they labour not to destroy for very idleness, though they have excellent greyhounds bold to fasten on them. So as they not only destroy their cattle, but also the fallow and red deers in the woods, which in time of the rebellion they were observed to hunt very cunningly. And one of our forts of **Munster**, which could not be victualled, being far within the rebels' country, was twice relieved by stags hunted by wolves and falling near it. The **Irish** hold it ominous to meet wolves, and have many enchantments against them. **Sir Richard Bingham**, governor of **Connaught**, was observed to have a great disaster upon the meeting of wolves; and we read that the **Emperor Charles V.**, having met a wolf, did in the same journey break his leg. The **Irish** also and the **English** observed that before the defeat of Blackwater and upon divers like disasters, the wolves were seen to enter the villages and the towns of **Ireland**.*


*Touching hawking, **Ireland** in time of the war had great plenty of partridges and pheasants, so as in **Munster** it was well known that sixty pheasants were served at one feast. And myself living there found this plenty, but thought that the pheasants of **Ireland** were nothing so good meat as the English, or at least I am sure that they were most eaten by the servants attending at the table. They had also plenty of sea-fowl, but birds in the woods and groves were in divers parts rare and few; whereof I heard some yield this reason, that they were scared from them by the frequent shooting of





---

p.325






pieces in the woods and underwoods, where the Irish **kerne** used commonly to lurk and to skirmish with the **English**. No country is more abounding with fish, as well sea fish in the frequent harbours and upon all the coasts, as fresh fish; especially excellent trouts in the frequent rivers and brooks. To conclude, the idleness of the **Irish**, and their having no delight in their meats, yielded to the **English** a plentiful enjoying of these games, as well for the sports as the meats.*












