

#The Literary Life


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Literary Life
=================


Author: Patrick Augustine Sheehan
---------------------------------


### File Description

Electronic edition compiled by Benjamin Hazard

Funded by School of History, University College, Cork and  
 Private donation 1. First draftExtent of text: 10540 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900012-004Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript**2. [Details to follow].
**Canon Sheehan on the Internet**2. http://www.canonsheehanremembered.com.
**Editions**2. Canon P.A. Sheehan, 'The Literary Life,' The Irish Monthly, 37/430 (April 1909) 181–202.
3. Canon P.A. Sheehan, 'The Literary Life,' in Canon P.A. Sheehan, The Literary Life and Other Essays (Dublin 1921) 1–34.
**Literature**2. Herman Joseph Heuser, Canon Sheehan of Doneraile: the story of an Irish parish priest as told chiefly by himself in books, personal memoirs, and letters (New York 1917).
3. Arthur Coussens. P. A. Sheehan, zijn leven en zijn werken (Brugge/Bruges 1923).
4. Michael P. Linehan, Canon Sheehan of Doneraile: Priest, Novelist, Man of Letters (Dublin 1952).
5. Michael Alexander, A History of English Literature (2nd. ed. London 2007).
6. Martin Price, The Restoration and the Eighteenth Century (New York 1973).
7. Harold Bloom and Lionel Trilling, Victorian Prose and Poetry (Oxford 1976).
8. Nicholas Boyle, Goethe: the Poet and the Age (2 vols, Oxford 1992–2000).
9. Frederick Burwick and Paul Douglass (eds.), Dante and Italy in British Romanticism (London 2011).
10. James O'Brien (ed.), The Collected Letters of Canon Sheehan of Doneraile, 1883–1913 (Wells 2013).
11. James O'Brien, Canon Sheehan of Doneraile 1852–1913: Outlines for a Literary Biography (Wells 2013). [Bibliographical references 205–11.]
**The edition used in the digital edition**2. The Literary Life in The Irish Monthly: A Magazine of General Literature, Ed. Matthew Russell SJ. , Dublin, Irish Jesuit Province (April 1909) volume 37number 430page 181–202

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents the edited version. Editorial footnotes are included using *note type="auth" n=""*.


#### Editorial Declaration


##### Correction


The text has been checked and proof-read once.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, the page-break and line-break are marked after the completion of the hyphenated word.


##### Segmentation


div0 = the essay; div1 = the section; page-breaks are marked and numbered.


##### Standard Values


There are no dates.


##### Interpretation


Names of persons and literary works cited by Sheehan are tagged. Places are not tagged.


### Profile Description


Created: By Patrick Augustine Sheehan (1852–1913)
 (1909) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] Some words are in French.


##### Language: [DE] Some words are in German.


##### Language: [IT] Some words are in Italian.


### Revision History


* (2014-01-23) Beatrix Färber (ed.)

* Minor changes made to file header; file parsed and validated.
* (2014-01-22) Benjamin Hazard (ed.)

* Further structural and content mark-up added.
* (2014-01-15) Benjamin Hazard (ed.)

* TEI header created; text proofed (1); structural and content mark-up added.
* (2014-01-10) Benjamin Hazard (data capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E900012-004


### The Literary Life: Author: Patrick Augustine Sheehan




---

p.181


The Literary Life
-----------------

### A lecture delivered before the Cork Literary and Scientific Society on 18 October 1906.[1](javascript:footNote('E900012-004/note001.html'))


In accepting the invitation of this Society to read a paper for its members, I selected this subject — the Literary Life — as one that might be made not only interesting, but useful. Because it is one about which ceaseless interrogations are put from young and old aspirants, the form of question generally touching the feasibility of making a living by literature, or, at least, of attracting, ever so little, the regards of our fellow men. It is found that some of these queries are pathetic; some, unreasonable; some, pitiful; none, for reasons I shall afterwards detail, altogether condemnable. The replies, given readily by those who have failed and those who have succeeded, are pitched in the same sad key of uniformity. With singular unanimity they seem to warn off all aspirants from a dangerous and thorny path. Some of these sad verdicts are familiar to you, like the mournful lines of **Dr. Johnson**: —

> 1. You know what ills the author's life assail —
>   
> Toil, envy, want, the patron, and the jail.
> 




But his successors in modern times, when it is generally presumed an author's life is happier, seem to repeat the same sad threnody.


**George Augustus Sala** was a successful journalist. His last verdict is: ‘Were I a young man, I should certainly not adopt 



---

p.182




journalism as a profession. With very few exceptions the career leads eventually to premature old age and indigence.’


**Grant Allen**, who was simply omniscient, if we are to judge by the multiplicity of subjects that engaged his pen, says that ‘crossing-sweeping is better than literature.’


**Gibbon**, **de Quincey**, **Scott**, **Trollope**, **Thackeray**, may be cited as witnesses to the same effect; and surely the world has always regarded these as the successful few.


To a correspondent who wrote him on the subject **Carlyle** replied, ‘that he had never heard a madder proposal. It was only one degree less foolish than if he were to throw himself from the top of the Monument in the hope of flying.’


And to **Dr. Crozier**, who had come from Canada to London to practise not his profession as doctor but as a lesser light of literature, the same sage replied: — ‘Na, na, that winna do. Ye'd better stick to your profession, young man. It's time enough to think of literature when you've cleared your own mind, and have something to say.’


And, in still more recent times, a writer, whose sad experience lends such pathetic and mournful interest to his words, writes: —


‘Innumerable are the men and women now writing for bread, who have not the least chance of finding in such work a permanent livelihood. They took to writing, because they knew not what else to do; or because the literary calling tempted them by its independence, and its dazzling prizes. They will hang on to the squalid profession, their earnings eked out by begging and borrowing, until it is too late for them to do anything else — and then? With a lifetime of dread experience behind me, I say that he who encourages any young man or woman to look for his living to literature, commits no less than a crime.’


These are sad words, wrung from lips which had tasted disappointment and despair. Are they borne out by facts and experience? Yes! alas! they are only too true. There is no profession, whose borders are strewn with so many wrecks as this of literature; as there is no profession for whose labours honours and rewards come so tardily — very often never come at all, or only come when it is too late. I know you might quote against me such isolated successes as that of **Lord Macaulay**, who got £10,000 for his History of England; **Mr. John Morley** who got a similar sum for his Life of Gladstone; **George Eliot**, who received the same sum for Adam Bede; **Charles Dickens**, dying worth £60,000; **Victor Hugo**, a millionaire; **Marie Corelli**. But what of **Milton** who got five pounds for Paradise Lost; What of **Chatterton**? What of **Goldsmith**? What of **Jane Austen**? What of **Shelley** expatriated? What of **Keats** murdered?



---

p.183




What of **Wordsworth** ridiculed and despised for fifty years, and then crowned with laurels, and honoured with academic degrees, when his countrymen should have done penance in sackcloth and ashes, and atoned for their stupid malevolence by respectful and contrite silence?


And **Coleridge** dependent in his old age on charity; and **Jean Paul Richter** labouring on his immortal works for ten years, whilst an ignorant and heedless public refused him bread for his wife and children. And **Tasso**, **Cowper** and **Comte** in their madhouses; and that vast army of French Parnassiens and Décadents, from **Balzac** down to **Paul Verlaine** and **Stephen Mallarmé**, starving and shivering in the attics of the Quartier Latin, and casting immortal works at the feet of grinding and avaricious publishers and a public which thought that the artists, who had given them so freely out of the opulence of their genius, were not worth the few wretched francs that would help to keep body and soul together. To-day, after the lapse of nearly a century, certain generous and cultivated Americans, of the same race and type that helped to place that beautiful monument to our **Berkeley** down there in the Cathedral at Cloyne, are labouring to erect into a museum the house where **Keats** died in Rome. It is very generous and beautiful; but again a symbol of the tardy recognition the world gives to its immortals!


And what shall we say of the heart-sickness, the disappointment, the despair, that seem to have ever dogged the feet of the great thinkers of the world? History is black with the dread record. Even in our own day I know nothing more pathetic than the futile attempts of the authors of great works to obtain a little recognition; of their futile appeals to publishers and public, to give them just one chance. Think of **Robert Browning's** Bells and Pomegranates, absolutely extinguished for twenty years by one word — Balderdash — written as a careful and comprehensive review by some truculent idiot in Tait's Magazine! And think that the same magazine had absolutely rejected an elaborate review by **John Stuart Mill** on the same poems! Think of Lorna Doone hawked around London for years, until by the chance accident of the marriage of the Marquis of Lorne with a Royal Princess, it caught the ear of the public. Think of **Francis Thompson** a crossing-sweeper in London! Think of the Rubaiyat of **Omar** lying perdu for years, until some intelligent man picked up a frayed copy for twopence in a London bookstall. Think of our own **Mangan**! Oh, yes! We who have inherited the treasures of **Mangan's** genius; we think what an honour we would have esteemed it, had we lived in his time, if we were privileged to give him a night's lodging, or a decent 



---

p.184




cloak. Too late! Such is the inscription posterity, inheriting the immortal works of genius, has to place with sorrow upon the tomb.


Such, in brief, is the history of this sad but glorious fraternity. And we need hardly wonder that those who have had experience of the vicissitudes and changes, and been embittered by the uncertainties and sadness of the literary life, should warn off all young postulants who might be modest or humble enough to plead for advice.


But it may be asked how does it happen, that with all these terrible facts and experiences before their eyes, so many are yet anxious to be enrolled in this brotherhood of pain and sorrow? What is the strange fascination which literature exercises over every one who has come under the spell of great authors? It is quite certain that there are few men or women of education and culture who do not aspire to the glory of seeing their thoughts, sentiments, and aspirations in print. The number of students who go to the Bar, or to medicine, or to business, or to engineering, is limited. The number of young ladies who desire to enter the learned professions, or to earn an independent livelihood as teachers, governesses, or Civil Servants, is limited. The number of literary aspirants is legion.


I think the motives which underlie or create this fascination for letters, may be summed up thus: — 


Admiration for great authors and the desire to imitate them; a passionate love for books, and the ambition to create something similar; the craving for what is believed to be a quiet, uneventful, unimpassioned life; the fancy that a life of literature is absolutely free from care; the rapture of composition; the desire of fame; the passion, so universal, for making money as speedily and as easily as possible.


Some of these methods are noble and honourable; some unwise and unreasonable; some base and dishonourable under certain aspects. We shall dispose of these latter first.


I do not for a moment believe, or aver, that it is either unworthy or dishonouring to write for money or for fame. There is no reason whatever why an author should not seek to exchange his services as poet, novelist, essayist, historian for remuneration similar and equal to that which accrues to the doctor, the barrister, or the commercial speculator. If he wishes to coin his brains, and mint them into gold, there is neither simony nor sacrilege in doing so. The pen of the writer is not more sacred than the scalpel of the doctor or the artist's pencil. Yet there is a certain class of people who seem to think that it is quite a degradation to write for money; and even the legislation 



---

p.185




about copyright, forced from the hands of unwilling statesmen, and but slowly and reluctantly improved in the course of ages, manifestly supposes that an author's work should be regarded as public property, with the right of every one to enter in and take his share. We hear a great deal about the rights of property, especially in land; and any violation of those rights is stigmatised as theft or confiscation.

It is so easy to forget that the first claim or right upon property should be the right of creation or production; and the land is God's creation, and the book is the work of the author. But the idea is that an author, alone of all producers, should be a public benefactor, labouring out of pure philanthropy for men's souls or pleasures, and sacrificing all human and personal rights by reason of his God-given faculty for teaching or pleasing mankind. Slowly and reluctantly the public is losing its grasp on this pleasant theory. The only section that still clings to it is the publishing faculty, who seem to regard the author as a kind of journeyman, who has no rights, only a few attenuated privileges; and who is specially created by God to furnish his publisher with copy that will swell the yearly dividends, and help him to keep his carriage, or his hunting-box in Scotland. And if an author has the presumption to demand his rights, he is generally greeted with the exclamation of surprise that met poor Oliver Twist, when he had the temerity to ask for ‘more.’


But where the degradation certainly comes in is when an author, avaricious of money or ambitious of fame, is prepared to use, or abuse, his talents to please the morbid passions of the multitude. A writer who appeals to passion, sensual or other; who panders to religious prejudice, or turns a sacred talent into a political agency; the author who sets the ‘maiden fancies wallowing in the troughs of Zolaism,’ or perverts the minds, or destroys the principles of the young, should meet with no mercy. Corruptio optimi pessima! And the perversion of a great talent to base and unworthy uses is the unforgivable sin.


So far for the principle. But can an author make money? Is it a lucrative profession? We have already answered that question. For the vast majority of writers, who hope to make a living by it, it is the source of unspeakable disappointment. There is only one safe advice for young people who are smitten by a passion for literature, and that is: Let it be your pleasure, but not your profession. It is ‘an excellent walking-stick; but an exceedingly bad crutch.’


Again, I cannot see why an author should not write for



---

p.186




fame. Fame, or rather the thirst for fame, is ‘the last infirmity of noble minds’; but it is an honourable infirmity. And it sometimes takes a shape that makes it akin to the zeal of an apostle. For there cannot be a doubt that many writers take up their pens, not for gain, sordid or otherwise; not for life-advancement, but purely with the desire of influencing the minds of many unto good — the desire of creating in other souls the high ideas and lofty principles with which they themselves are animated. To wish to have one's name bruited abroad in the press and amongst the public may be a paltry thing, but it is intelligible. To desire to influence the world by the magnetism of great ideas; to desire to form even one link in the electric chain that stretches down through the ages, magnetising generation after generation with thoughts that thrill and words that burn — this, so far from being ignoble, may assume the sacredness of a vocation and an apostleship. ‘Cast forth thy Act, thy Word, into the ever-living, everworking universe; it is a seed grain that cannot die; unnoticed to-day, it will be found flourishing as a Banyan-grove after a thousand years.’


This naturally leads us to consider the higher and more sacred motives that influence so many in their choice of literature as a profession. The first of these I have specified as a love of books and their authors. The highest worship is the worship of imitation. Whosoever sits at the feet of Gamaliel seeks to become like unto Gamaliel. We like to create what we admire; and whoever has a favourite author or authors, dreams of one day becoming a source of light and leading unto others, as these authors are to himself. And behind that passion for imitation is the instinct that seems to pervade the whole universe; — that mysterious and sublime impulse which seems almost like an attribute of the Divinity, imparted in measure to finite beings — the instinct of creation or production. You see it everywhere: in the atom, in the mineral, in the cell, in the plant, in the animal. The same tremendous process that rounds a nebula into a sun, carries the pollen of a flower from plant to plant on the wings of a bee or a butterfly; and the same mysterious instinct that vitalizes a seedling compelled **Michael Angelo** to lie for nights and days on the summit of a scaffold to paint the frescoes on the ceiling of the Sistine Chapel. And it is the same mysterious force which evolved Hamlet and Macbeth that is stirring in the heart and brain of every young boy or girl who takes up a 



---

p.187




sheet of paper for the first time to write the first vapid story or the first immature poem. And vapid though the story may be, and immature the poem, there is, beside the creative instinct that produced it, another instinct even more wonderful, an innate and supersensuous instinct to create only what is perfect and beautiful. This has always seemed to me one of the greatest and most unfathomable mysteries of our existence. So surely as the crystal flakes of snow form and dissolve into facets of the most perfect geometrical proportions; so surely as the bee creates, with unconscious art, the perfect hexagons of his cells; so surely as the bird weaves out of garden refuse his most beautiful nest, and the flower develops its painted perfections; so surely does the instinct of beauty and harmony animate and inspire the youngest novice in the art of literature. And this passion for the beautiful, or this instinct for creating the beautiful, is innate in the human mind, as it is innate in Nature. **Trélat** in his Recherches historiques sur la folie tells us that ‘under the influence of insanity an ignorant person will make perfect Latin verses; a woman will sing Latin hymns and verses entirely unknown to her.’ **Marcé** records the case of a young married woman, of very ordinary intelligence, who, under an attack of mania, wrote letters to her husband, which for the eloquence and passionate energy of their style, might easily be placed beside the most fervent passages in the Nouvelle Heloise. Cases of dementia have been known, in which young men of the most ordinary capacity, and who in their sane moments had not the slightest artistic perceptions, have produced sketches, sometimes with chalks, sometimes with pencils, sometimes with a red-hot iron on a piece of board, which experts refused to believe were not the work of supreme artists; which proves, not only the existence of a sub-consciousness of which we are quite unaware, but also of a latent sense of artistic beauty, which only needs some kind of sudden emotion to be developed into action. Hence I see in the crudest efforts of the pen, nothing but Nature working outwards towards perfection.


But I shall be met at once by the objection that all this instinct, like the blind instincts of Nature, leads but to sad and melancholy waste; that the process of natural selection holds in literature as in everything else; that only the fittest and noblest and strong things survive; and that hence it would be much better for poetic young ladies to knit stockings than to make verses; and for moon-struck young men to take up a spade or a hoe, and let the pen alone. True, there is that terrible and unaccountable waste in Nature as in Art. It was the one thing that troubled the intellectual serenity of **Tennyson**


---

p.188




in his old age, and shook the little Christian faith that he possessed: —

> 1. So careful of the type she seems. But no!
>   
> From scarped cliff and quarried stone
>   
> She cries: A thousand types are gone,
>   
> I care for nothing. All shall go!
> 




It is not the origin of things, but the utter depravity of Nature in sacrificing with criminal and profuse prodigality all that is created with so much pain that forms the cardinal puzzle and problem of existence. If the elm-tree produces 300,000 seeds in a year, and only one seed becomes an elm; if but one seed of 200,000 of the purple orchis reaches maturity, we pronounce Nature a shocking wastrel. But it does not follow that the seedling that fructified was more vigorous and healthful than the thousands that perished. Their environments were different, and they fell under the other instinct of destruction. And I say that it is quite a mistake to suppose that in Literature out of the countless poems, and essays, and dramas, that have been evolved from the creative instinct of the intellect only the best have survived. I do not wish to be misunderstood. I do not affirm that any greater epic than the Iliad, any greater drama than Hamlet or Lear, has gone down the waste-pipes of time into the gulf of oblivion. But I do affirm that to-day countless essays are written, printed, read, and forgotten incomparably greater than the insolent platitudes of **Macaulay**; and that countless poems are hidden and buried away in magazines that far more justly entitle their authors to a niche in the Temple of Fame than the crudities that were written by the poets whom Johnson deemed worthy of a place in his gallery of mediocrities. **Tennyson** used to say that many thousands of lines, quite as precious as those he preserved, went up his chimney in clouds of tobacco-smoke; and I have no doubt that many a fine lyric and sonnet has helped in our days the utilities which he anticipated for his ‘mortal lullabies of pain’ — 

> 1. To bind a book, to line a box,
>   
> Or help to curl a maiden's locks.
> 




What then are we to say? This — that inasmuch as it appears to be the law of Nature to create prodigally, by virtue of the secret and impervious instinct that prompts creation; and that, inasmuch as these creations, again obeying the behests of another secret and imperative law, always round to perfection, even though the vast proportion are doomed to wanton destruction, and perhaps only one solitary specimen 



---

p.189




of Nature's creative power survives; so is it the law of Nature that the young, the hopeful, and the buoyant shall seek to perpetuate themselves in prose and verse; and that we have no more right to check or destroy that instinct than we have to interfere with the mechanical operations that are fortunately placed altogether beyond our control. If these pen-productions are doomed to destruction, well, it is only again the law of Nature, even though we may regret it. If they survive, they remain ‘a thing of beauty, and a joy for ever.’


Besides, in all this there is the eternal law of Chance. The same Chance that places a seedling in the beak of a migratory bird and bids it be carried to some ocean-beaten rock, there to create a luxuriant vegetation, may also discover and reveal some hidden beauty and glory in literature. **Thomas Gray** owes his immortality to one poem; **Blanco White** to one sonnet. There are greater poems than the Elegy, which never have been heard of. There are incomparably greater sonnets unrecognised in the language than the famous sonnet on ‘Night.’ And there is no writer, however humble, who may not stumble on an immortal line, and find a discriminating critic to recognise it. There is a systole and diastole in all human affairs: and the idols of this generation may strew the roads of the next. At one time all Europe went mad over **Byron**; and it was seriously debated in Oxford whether **Byron** or **Shelley** were the greater poet. No one would dream of asking the question now. The time may come when **Shakespeare** will be dethroned: for there is a good deal of lying about **Shakespeare**. And the slaves of to-day may be the kings of to-morrow. 


This leads me quite naturally to the next motive I have particularized as an attraction to the literary life — the rapture of composition!


Now it is quite true that for the most part authors have to whip and spur their brains until the jaded or helpless faculties stir themselves reluctantly to work. Very often authors have to write against time to complete an engagement or to meet the season when books are most in demand. This is the drudgery of literature; and such work, under such circumstances, is mostly poor and transitory. But there come moments in the life of every author — at least, of every author of distinction — when they seem to be lifted above the earth, and to see a sudden opening in the firmament, revealing glimpses of Heaven. Such moments of ecstasy are few and intermittent. They cannot be foreseen or anticipated. They do not come and go with the rhythmic swing of the sea; but capriciously and at unexpected times, flashing sudden lights on the mind, and as quickly snapping 



---

p.190




and extinguishing them. In such moments not only are worlds revealed; but with the inspiration comes also the language fitted to reveal it — the happy expression — the one word out of a million that adapts itself with a precision that no mere Art could discover. I feel quite sure that **Shelley** experienced this when he wrote his immortal Ode to the West Wind, and stumbled upon such lines as: —


> 1. The blue Mediterranean, where he lay
>   
> Lulled by the coil of his crystalline streams
>   
> Beside a pumice isle in Baiae's bay;
> 




and: —



> 1. Thou,
>   
> In whose path the Atlantic's level powers
>   
> Cleave themselves into chasms, while far below
>   
> The sea-blooms and the oozy woods which bear
>   
> The sapless foliage of the Ocean, know
>   
> Thy voice and suddenly grow grey with fear.
> 




No mere cudgelling of brains could ever elicit that line: —
  

‘Beside a pumice isle in Baise's bay,’
  
 
or that expression: —
  


‘The sapless foliage of the Ocean.’
  



And when **Keats** in his immortal sonnet on **Chapman's** Homer wrote: —

> 1. Then felt I like some watcher of the skies
>   
> When a new planet swims into his ken;
>   
> Or like stout Cortez when with eagle eyes
>   
> He stared at the Pacific and all his men
>   
> Looked at each other with a wild surmise
>   
> Silent, upon a peak in Darien,
> 




or in his Ode to a Nightingale, broke into what some consider the two most perfect lines in all English poetry: —

> 1. Charmed magic casements, opening on the foam
>   
> Of perilous seas, in faery lands forlorn,
> 





  
he must have experienced something like the levitation of spiritualists, and floated in the air.


And when Carlyle said to his wife, on the completion of his French Revolution: ‘There! They have not had for many years a book that came so flaming hot from the heart of any man.’ It was his rapture at having perfected an immortal work, and an ecstasy of defiance to a heedless or stupid public.




---

p.191


But, in the life of men of genius, these, alas! are transitory, sudden, intermittent emotions. As a rule, authors, especially of the higher type, are very unhappy mortals. Whether it be the perpetual mental strain producing nervousness and irritability; or whether it be the disappointment of baffled hopes; or whether it be penury, want, or neglect, that shall be alleged as causes, it is quite certain that a literary life is mostly an unhappy one. Sudden raptures mean chronic depression; and the ecstasies of a moment scarcely counterbalance the infelicities of a lifetime. If it had pleased God to give you a brain, the grey cortex of which is so dull and unelastic that no external impression will strike a spark from it, thank God for the favour! Or if you are endowed with such faculties that you can gaze for hours stupidly into the fire; or lean over a village bridge and watch the waters curling beneath; or consume infinite tobacco, whilst engaged in the laudable object of killing man's worst enemy — Time — thank God for it! But if you are dowered with that nervous irritability called genius, throwing out thoughts from the brain as swiftly as the crystal drops are flung from a mill-wheel ah, well, you may know, from time to time, what is meant by the ecstasy and rapture of composition; but you will never know what happiness means in this life. ‘Where thou beholdest Genius,’ says **Goethe**, in Tasso, ‘there thou beholdest, too, the martyr's crown.’[2](javascript:footNote('E900012-004/note002.html'))


Hence, unquestionably, a literary life is for the most part an unhappy life; because, if you have genius, you must suffer the penalty of genius; and, if you have only talent, there are so many cares and worries incidental to the circumstances of men of letters, as to make life exceedingly miserable. Besides the pangs of composition, and the continuous disappointment which a true artist feels at his inability to reveal himself, there is the ever-recurring difficulty of gaining the public ear. Young writers are buoyed up by the hope and the belief that they have only to throw that poem at the world's feet to get back in return the laurel-crown; that they have only to push that novel into print to be acknowledged at once as a new light in literature. You can never convince a young author that the editors of magazines and the publishers of books are a practical body of men, who are by no means fanatically anxious about placing 



---

p.192




the best literature before the public. Nay, that, for the most part, they are mere brokers, who conduct their business on the hardest lines of a Profit and Loss account.


It is not the melody or inspiration of a poem, or the worth of a novel, they consider; but their mercantile value. And if this fact were more distinctly understood it would prevent a good deal of disappointment and heart-burning. For young writers will never understand that all their negotiations are conducted on trade principles, and that it is as unwise for an inexperienced author to negotiate for his books as it would be for the merest amateur to enter into competition with one who has had a lifetime experience of Christie's sales. Hence, the enormous boon of the Authors' Society, London, whose courteous and clever secretary is always ready to enter into correspondence with its members, and give strictly legal and professional advice on the many most difficult questions that concern the publication of books. And if you ever think you have a valuable book to place on the market, and if you want to escape the clutches of some unscrupulous publisher, who will take advantage of your inexperience and carelessness to get you into his power, and make large capital out of your brainwork, giving you back but the veriest minimum of royalties, I would advise you never to sign an agreement without first submitting it to the keen eye of the Secretary of the Authors' Society.


But supposing your book fairly launched, its perils are only beginning. You have to run the gauntlet of the critics. To a young author, again, this seems to be as terrible an ordeal as passing down the files of Sioux or Comanche Indians, each one of whom is thirsting for your scalp. When you are a little older, you will find that criticism is not much more serious than the bye-play of clowns in a circus, when they beat around the ring the victim with bladders slung at the end of long poles. A time comes in the life of every author when he regards critics as comical, rather than formidable, and goes his way unheeding. But there are sensitive souls that yield under the chastisement, and, perhaps after suffering much silent torture, abandon the profession of the pen for ever. **Keats**, perhaps, is the saddest example of a fine spirit hounded to death by savage criticism; because, whatever his biographers may aver, that furious attack of **Gifford** and **Terry** undoubtedly expedited his death. But no doubt there are hundreds who suffer keenly from hostile and unscrupulous criticism; and who have to bear that suffering in silence, because it is a cardinal principle in literature that the most unwise thing in the world for an author is to take public notice of criticism in the way of defending 



---

p.193




himself. Silence is the only safeguard, as it is the only dignified protest against insult and offence.


Again, although there is a good deal of good nature and fraternal feeling, and a sense of camaraderie amongst authors, there is also sometimes ‘war on Parnassus.’ I do not know anything more painful and humiliating than to see a beloved poet or a worshipped author, descend into the arena of vulgar controversy. It is a dethronement of our idols that is akin to loss of faith. Hence, the life of a poet should never be written. The world should be satisfied with the legacy of his immortal works. Hence is **Shakespeare** happy, in that we know practically nothing about his life. It is not pleasant to see our great saints of literature toppling down to our feet in some wretched wordy squabble. I think **Tennyson** acted most wisely in excluding from the collected edition of his poems his terrible and scathing reply to **Lord Lytton** in the New Timon. **Thackeray** is not raised in our esteem by his resentment against **Charlotte Brontë** for his supposed likeness to Rochester. Nor does he come well out of his dispute with **Edmund Yates**, although, as a man, he has left behind him a most noble character for magnanimity and lordly munificence. I remember, after reading **Swinburne's** exchanges of compliments with **Eric Mackay**, about a fulsome poem published by the latter in The World, and which ended in an attorney's letter and a cry for the police, I rubbed my eyes and asked myself: Is this the same man that wrote the noble choruses in Atalanta, and the sublime elegy on the Death of Barry Cornwall? **Mr. Froude**, an unreliable historian, but an accomplished littérateur, did wisely in never answering the fierce onslaughts that were made on him and his works, especially by his brother historian, **Freeman**. But his reputation was not served by his post-mortem revelations, in which he says with acrimony: — 


‘I never resented anything more than that article in the Quarterly. I felt as if I were tied to a post, and a mule was brought up to kick me. Some day I think I shall take my reviewers all round, and give them a piece of my mind. I acknowledge to find real mistakes in the whole work of twelve volumes — about twenty trifling slips, equivalent to i's not dotted, and t's not crossed; and that is all the utmost malignity has discovered. Every one of the rascals, too, has made a dozen blunders of his own while detecting one of mine ... You may have seen **Freeman's** papers in the Contemporary. You will be glad to hear that he is changing his mind on the Eastern question. That I should be on the same side convinces him that he must be wrong.’




---

p.194


I quote this to show how unwise it is for aggrieved authors to lift the veil on their feelings, and compel the small world to ask, how such anger can find a place in celestial minds.


But it proves that the literary life is riot all sunshine. I spoke of the eternal and universal law of reproduction. But there is the counter instinct, alas! also eternal and universal, and only too well developed in the human heart — the instinct of attack and destruction; and this always finds its object in whatever is most fair and beautiful. Weeds have no parasites. These latter find their way to the under leaf of rose and lily.


I think that here, too, may be found a remote reason for the profound pessimism that seems to be a characteristic of all great geniuses. The little we know of **Shakespeare**, his temporal prosperity, and his placid bust, seem to mark him as an exception. But no! The man who wrote Timon and Lear, and the sad words about adversity and ingratitude, took but a sombre view of life and humanity; whilst running through the golden web of his Sonnets is a dark line, denoting the profound depression and melancholy of his character. 


**Milton's** solemn sadness is everywhere in his poems. Wordsworth expresses his convictions in such lines as: — 
  


‘The still, sad music of humanity,’
  


and
  


> 1. The burden and
>   
> The weight of all this unintelligible world.
> 




**Byron** was a misanthrope for ever railing against his kind. **Shelley**, in the lines: —

> 1. Yet, now despair itself is mild
>   
> Even as the winds and waters are,
>   
> I could lie down like a tired child
>   
> And weep away the life of care: 
>   
> Which I have borne, and yet must bear,
> 




typifies the same.


I need not quote **Carlyle** or **Tennyson** — the two saddest souls of modern times; nor **George Eliot**; nor the host of great thinkers, who, having set out on the journey of life with buoyant hopes and aspirations, closed their eyes on this world, like the ancient prophets, with a Woe upon their lips.


But, besides the petty annoyances and grinding cares inseparable from the literary life, there was another cause for their pessimism. It was this: — 


All great thinkers live and move on a high plane of thought. It is only there they can breathe freely. It is only in contact with spirits like themselves they can live harmoniously and 



---

p.195




attain that serenity which comes from ideal companionship. The studies of all great thinkers must range along the highest altitudes of human thought. I cannot remember the name of any illuminative genius who did not drink his inspirations from the fountains of ancient Greek and Hebrew writers; or such among the moderns as were pupils in ancient thought, and, in turn, became masters in their own. I have always thought that the strongest argument in favour of the Baconian theory was, that no man, however indubitable his genius, could have written the plays and sonnets that have come down to us under **Shakespeare's** name who had not the liberal education of **Bacon**. How this habit of intercourse with the gods makes one impatient of mere men. The magnificent ideals that have ever haunted the human mind, and given us our highest proofs of a future immortality by reason of the impossibility of their fulfilment here, are splintered into atoms by contact with life's realities. Hence comes our sublime discontent. You will notice that your first sensation after reading a great book is one of melancholy and dissatisfaction. The ideas, sentiments, expressions, are so far beyond those of ordinary working life that you cannot turn aside from one to the other without an acute sensation and consciousness of the contrast. And the principles are so lofty, so superhuman that it is a positive pain, if once you become imbued with them, to come down and mix in the squalid surroundings of ordinary humanity. It may be spiritual or intellectual pride that is engendered on this high plane intellectual life. But whatever it is, it becomes inevitable. An habitual meditation on the vast problems that underlie human life, and are knit into human destinies — thoughts of immortality, of the littleness of mere man, of the greatness of man's soul, of the splendours of the universe that are invisible to the ordinary traffickers in the street, as the vastness of St. Peter's is to the spider that weaves her web in a corner of the dome — these things do not fit men to understand the average human being, or tolerate with patience the sordid wretchedness of the unregenerate masses. Faust in his midnight study was a perplexed man, because he was always pursuing the phantoms of the Unknown. Had he touched earth, and then gone back to his books and alembics, he would have become a cynic and a pessimist. He remained on the lower levels, enjoyed all the lower pleasures, suffered all the lower pains, and all the disillusion that comes from contact with humanity. You cannot come down from the society of **Plato** without being slightly disgusted with **John Anderson**; nor can you descend from ‘the sacred everlasting calm’ of the immortal spirits of our race 



---

p.196




without suffering irritation at the petty, frivolous, and stupid things that seem to occupy nine-tenths of the time of some of your acquaintance. And when you draw aside and watch this swirling, turbulent tide of humanity, carrying with it the straws and mud and refuse of the world, it is not easy to take a hopeful or sanguine view of the future of the race. It is easy to understand, therefore, why such thinkers fly to the solitude of their own thoughts, or the silent companionship of the immortals; and if they do care to present their views in prose or verse to the world, that these views take a sombre and melancholy setting from ‘the pale cast of thought’ in which they were engendered. I know but one exception to this universal scepticism — the case of **Robert Browning**. He was, apparently, a childish, guileless optimist, ‘believing all things, hoping all things, loving all things.’ But I explain the singular fact by the theory that **Browning**, unlike all his great contemporaries, was a society man. He gave as much time to mortals as to the immortals; and the contrast, therefore, was not so painful or pronounced.


Perhaps you will be surprised, after this enumeration of the many trials and drawbacks in the literary life, when I draw the strange conclusion that I most earnestly recommend it to those whose tastes lead in that direction; but always with the condition that it is regarded not as a profession or means towards an independent livelihood. And I recommend it for a threefold reason: First, as a resource and pleasure in those hours of depression or ennui that come to all; (2), as a refining and exalting influence; (3), as a possible Apostolate.


(1) There is certainly no greater or more lasting mental resource than a taste for letters or the literary life. Music palls upon many; social pleasures are not always available or desirable. But the art of composition, once acquired, is never lost, and never wearies; and you can pursue it without extraneous aid and in that solitude that is so dear to those who try to think deeply. ‘I know no greater pleasure,’ wrote **Jean Paul**, ‘and few more refining, than for a young man to open his portfolio, and walking up and down his room, strive to spoil that virgin page with words that may be immortal.’ And if you are fortunate enough to get into print, so much the better.


It seems to me that Reading Circles or Guilds in our chief towns and cities might help materially, not only the cultivation of literary tastes, but the calling or vocation to a literary life. 



---

p.197




Such Circles exist, and are productive of much good, in all the great cities of America; and are carried on through the summer months in the summer schools at Lake Champlain and elsewhere. At these meetings not only are the great classics discussed and read, but also individual efforts on the part of members are encouraged by being brought forward, and eagerly criticised. It is quite possible that with that sarcastic vein that runs through the Irish temperament, and in the absence of that gentle, serious tone that makes so much for harmony, that a game of Bridge or Bezique might be better adapted to sustain these amenities that go so far to make our social intercourse tolerable. But it would be a decided impulse towards literary production if there could be established in our midst a few little coteries where a young author might be heard before coming in front of the footlights. I am aware that philosophers who have studied the intricacies of human nature think otherwise. **Leopardi** says, that the reading of compositions is ‘a social scourge, a public calamity, and adds a new terror to life’; and he quotes the opinion of a learned friend, who said that if it be true that the Empress Octavia fainted away while **Virgil** was reading to her the sixth canto of his Aeneid) we may be sure that her swoon was caused, not by the poet's pathetic allusion to the fate of Marcellus, but from sheer fatigue and weariness of the poet's reading. And it is no violent stretch of imagination to suppose that in a witty city like this, some young censor might, like **Diogenes** of old, lean over the shoulder of some unhappy reader and exclaim as he saw the blank spaces at the bottom of the page: ‘Courage, my friends, I see land at last!’


But if it is a daring thing to suggest the formation of Reading Guilds in our midst I am about to do a desperate thing in suggesting, as an incentive to a literary life, the establishment of a purely literary journal. We are so deluged with journals and reforms, and methods of reform, that I am sure at the very suggestion you will cast up your eyes and say, ‘Yet another!’ But on the one hand, there cannot be a doubt of the steady decadence, and even extinction, of these literary tastes in our midst, which originated fifty or sixty years ago in the hedge schools, and which, helped by the tone of the public journals, constituted quite an Augustine age in our literature. On the other hand, it is quite useless to look to our schools or educational system for such a revival of tastes as would place us on a level with the cultured classes of other nations. But no one can deny that the literary talent requisite for working successfully a great literary journal is available in Ireland. One Dublin magazine, if it were 



---

p.198




limited to purely literary, scientific, or artistic subjects, would have all the elements of a great literary organ. And a small quarto paper, published some years ago in Dublin, commanded, it was quite clear, the highest literary talent amongst us; but it was steered, from the day it was launched, right on the rocks and shoals of religious and political controversy, and, of course, suffered shipwreck! But I suppose I am a dreamer of dreams, and we shall let it pass.


(2) I hold, in the second place, that a literary life is necessarily a life of refinement and culture. I cannot see how it can be otherwise. I cannot see how any man or woman, living habitually with the prophets and seers of the race, can descend willingly to the lower levels of sense or self-interest. And I again repeat that no man can attain conspicuous literary success, or become a light to his generation, unless he has sat an obedient pupil at the feet of the great masters in his art. I know you may quote against me certain poets and philosophers who preached or sang divinely and lived diabolically. But que voulez-vous? The diva, who at ten o'clock, in yonder theatre, is raising you to the third heavens on the wings of her voice, will sup at twelve on oysters and champagne. You cannot, alas! dissever the human from the divine. But I cannot see how anyone who has been reading, say, the Dialogues of Plato; or who has just finished that chapter, ‘The Everlasting Year,’ in the Third Book of Sartor Resartus, can be greedy at a restaurant or can join in a circle of scandal, or cheat his neighbour at whist. Of course there is the danger of ultra-refinement, of looking down upon ‘the man in the street.’ But this danger is remote, except, as I have said, in the pessimism of great authors. Most others will come down from Olympus with only Infinite Pity in their hearts for poor, sordid, struggling humanity.


(3) Lastly (and I am sure you are as well pleased with the word, as when you hear in Church, ‘One word more, and I have done’), there is the Apostolate of Literature. It is a subject that might be developed not only into a Lecture, but into a Book; and I am acting unwisely in giving it but a paragraph at the end of a paper. But I shall address myself only to one aspect of it.


I feel that I am contravening the opinions of each and every section into which modern Ireland is divided when I say, that in the work of nation-building the chief requisite would be architects of large, liberal ideas, gathered from the world's chief thinkers, and assimilated so perfectly that they would be manifested in firmer judgments, wider speculations, more generous sympathies, and larger toleration than we find in our little 



---

p.199




world of to-day. And I do not know where that knowledge and experience are to be acquired, unless at the feet of ‘the masters of those who know,’ in every age, of every country and clime. And whilst I am very proud of being an ardent propagandist of the Gaelic League, I cannot sympathise with those who think, I am sure honestly and sincerely, that we should only read Irish books, and write on Irish subjects; and who speak with some contempt of Anglo-Irish writers and cosmopolitan patriots. If such ideas had been accepted in other countries, I wonder where the literary glories, nay, the political triumphs of England, France, Germany, Spain, and Italy would be to-day? If **Shakespeare** had not ransacked the world for subjects, where would be Julius Caesar and Coriolanus, Hamlet and Othello, The Merchant of Venice, Romeo and Juliet? If **Milton** had limited his ideas within the British seas, we would not have had Paradise Lost or Samson Agonistes. **Byron**, **Shelley**, and **Keats** would be represented by one sonnet or lyric and an angry diatribe. **Swinburne** would not exist, except in some political harangue. If **Tasso**, **Dante**, **Alfieri,** had followed a similar principle, Italian literature would be almost limited to **Petrarch's** Sonnets. And if the great French tragedians had not gone to antiquity for subjects, the names of **Racine** and **Corneille** would be practically unknown. In a word, you would blot out the world's literature if you only regarded what was purely racial or national in the productions of the great masters of literature, in every age, and country, and clime.


Nor is it reasonable that it should be otherwise. There is a certain fund of original thought stored up in the written archives, the unwritten traditions, and the daily habitudes of every race. And if thought is the parent of thought, and language its vehicle, I think that that nation would soon be starved which would limit itself to the creations of its own children. Even if it be said that home thoughts are the best thoughts, well, they will become more valuable by being appraised by comparison with the ideas of others. But certainly in our days, when we may be on the eve of tremendous changes, I would wish for systems of education, based on broader principles than we now possess; and as that seems almost beyond the horizon of our hopes, I would wish to see literary tastes more widely extended and more liberally developed, to the end that, with larger views and freer sympathies, we might be able to view the present condition of our country, as it were, in the perspective, the true perspective of solid judgment, and unbiassed and unprejudiced sympathies. And as we cannot, as a nation, go outside ourselves without courting self-destruction, the only thing that 



---

p.200




seems possible and feasible is to take our stand, side by side, with the master thinkers of the ages, and try and look at ourselves with their eyes. I think if we did so we should see many things in a different light from that in which they now appear; and that our views of men and their institutions, their laws and habits, their history, and their present political and economic conditions, their relations to each other, and to the world with which they are brought into contact; their social, religious, and political antipathies, narrowed and concentrated in the focus of great cosmic principles would seem to us capable of much emendation; that is, if we were really prepared to emerge from the toils of factions and parties, and walk in the broader way of free and unfettered principle. And as education cannot come down to the masses of the people, and there is no pedagogue system so wide as to embrace a whole nation, nothing seems to remain for us in Ireland but an apostolate of Literature, where books will be our University, and each man a teacher unto himself.


I do not despair of seeing yet in Ireland — in its populous centres, which ought to become luminous points, radiating light all around; and its quiet, country places, where all the surroundings are favourable to peaceful thought and meditation — large circles of thinkers, devoted to literature, and science, and art, and insensibly leading up the masses of the people to their own regions of high thought, and refined and exalted sentiment. I feel sure that outside the storm-belt, the torrid zone of political life, there must be many of both sexes who desire to live more gentle lives in the temperate regions where passion has no place, where there is no intriguing, no statesmanship (as the euphemism has it), no contention, except the academic striving after literary success, or a calm and passionless debate about a point of art, or a subtlety of expression. Such a literary, shall I say ideal, world must not expect recognition. Nothing is recognised in Ireland except what is entangled in the meshes of politics. The last trump of doom would sound before we would think of putting up a monument to such a thinker as **Bishop Berkeley**. It is quite different with other nationalities, who look at things with ‘larger, other eyes’ than ours. The great, generous American people do not ask if a dead poet were a Democrat or a Republican, whether he was enmeshed in the toils of Tammany or other political organisation. They only ask: Was he a Poet? and they recognise his worth accordingly. The great German nation acknowledge as the ‘bright, particular star’ of its firmament, **Goethe**, who was decidedly unpatriotic in our sense of the word. It would seem difficult to



---

p.201




defend the man who was so absolutely indifferent to the fate of his country during the Napoleonic invasion that he was engrossed in fossil-hunting at the very time that the battle of Zena was raging outside the walls of his dwelling. But, because he was the supreme artist and interpreter of his nation, he has obtained the first place in the Temple of Fame, which is so well and honourably crowded with the effigies of artists and men of letters, scientists and politicians, statesmen and orators, in the Fatherland.


I cannot recall just now any public recognition of genius in Ireland — of genius as such, and apart from political services — except that most brilliant and honourable episode in the history of Trinity College, when, on the 15th August, 1835, in the presence of three hundred members of the British Association, and all the Fellows of Trinity, assembled in the dining-hall of the College, a young Professor and Fellow, of twenty-seven years, **William Rowan Hamilton**, was suddenly summoned by the Viceroy and knighted, ‘not,’ as his Excellency said, ‘as conferring a distinction, but as setting the royal and national mark on a distinction already acquired by genius and labour.’ But this is not the point. I am contemplating a condition of things where literature will be pursued for its own sake, and for the effects it must necessarily have on those who are happy to be its votaries. I do not yet despair of seeing a shelf of books in every labourer's cottage in the land. I do not despair of seeing our artisans seeking their evening recreation and their Sunday pleasure in the company of great thinkers and sweet singers. I hope I may see the time when one could say ‘Dante’ or ‘Browning,’ without inducing the dread silence of an earthquake panic in the higher circles of the land; and when one might say ‘Turner’ or ‘Botticelli’ without incurring the suspicion of affectation or pedantry. The day may be remote; when it comes it will usher in a Golden Age, fraught with vast possibilities for the social, religious, and political welfare of Ireland. For our social advancement inasmuch as it may raise the tone of daily life and bring an atmosphere of refinement and gentleness where now there is too much persiflage and frivolity. For our religious wellbeing, — because the deeper we read the stronger becomes our hold on those cardinal dogmas and principles that are common to all Christian creeds. ‘The contemplative Atheist,’ says **Lord Bacon**, ‘is rare. A little philosophy inclineth man's mind to Atheism; but depth in philosophy bringeth men's minds around to religion.’ For our political welfare, — for a commonwealth founded by a people of large knowledge, trained understanding, quickened perceptions, and solid principles, 



---

p.202




that will not sway to every wind of speech, will have elements of stability and permanency, with ‘Freedom slowly broadening down, from precedent to precedent.’


As yet we live by hope: but we must work on, humbly and hopefully straining after an ideal, doing our duty in the narrowest social and parochial surroundings, and trusting that an aggregate of effort will achieve success in more spacious times and more gentle surroundings than it is our lot to experience at present.












