

#The Irish Parliament of James II


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Irish Parliament of James II
================================


Author: Thomas Osborne Davis
----------------------------


### File Description

Electronic edition compiled by Janet Crawford , Beatrix Färber

 2. Second draft.Extent of text: 25380 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2005) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800002-045Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Dublin, National Library of Ireland, MSS G 6 and G 5.
**Editions of this text and other writings by Thomas Davis**2. Charles Gavan Duffy (ed.), Thomas Osborne Davis, The patriot parliament of 1689, with its statutes, roles and proceedings. (1893).
3. Sir Charles Gavan Duffy (ed.), Thomas Davis, the memoirs of an Irish patriot, 1840–1846. (1890).
4. Angela Clifford, Godless colleges and mixed education in Ireland: extracts from speeches and writings of Thomas Wyse, Daniel O'Connell, Thomas Davis, Charles Gavan Duffy, Frank Hugh O'Donnell and others. (Belfast: Athol, 1992).
**Secondary Liteature**2. Arthur Griffith (ed.), Thomas Davis: the thinker & teacher; the essence of his writings in prose and poetry. (Dublin: Gill 1914).
3. William O'Brien, The influence of Thomas Davis: a lecture delivered by William O'Brien, M.P., at the City Hall, Cork, on 5th November 1915. (Cork: Free Press Office, 1915).
4. John P. Prendergast, The Cromwellian Settlement of Ireland. (Dublin 1922).
5. Michael Quigley (ed.), Pictorial record: centenary of Thomas Davis and young Ireland. (Dublin 1945).
6. Joseph Maunsell Hone, Thomas Davis (Famous Irish Lives). (1934).
7. M. J. MacManus (ed.), Thomas Davis and Young Ireland. (Dublin: The Stationery Office, 1945).
8. J. L. Ahern, Thomas Davis and his circle. (Waterford 1945).
9. Michael Tierney, 'Thomas Davis: 1814–1845'. Studies; an Irish quarterly review, 34:135 (1945) 300–310.
10. Theodore William Moody, 'The Thomas Davis centenary lecture in Newry'. An t-Iubhar (=Newry) 1946, 22–6.
11. D. R. Gwynn, O'Connell, Davis and the Colleges Bill (Centenary Series 1). (Oxford and Cork 1948).
12. D. R. Gwynn, 'John E. Pigot and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 145–157.
13. D. R. Gwynn, 'Denny Lane and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 15–28.
14. N. N., Clár cuimhneacháin: comóradh i gcuimhne Thomáis Daibhis, Magh Ealla, 1942. (Baile Átha Cliath [=Dublin] 1942).
15. Christopher Preston, 'Commissioners under the Patriot Parliament, 1689'. Irish Ecclesiastical Record, 5th ser., 74:8 (1950) 141–151.
16. W.B. Yeats, Tribute to Thomas Davis: with an account of the Thomas Davis centenary meeting held in Dublin on November 20th, 1914, including Dr. Mahaffy's prohibition of the "Man called Pearse," and an unpublished protest by "A.E." (Cork 1965).
17. Theodore William Moody, 'Thomas Davis and the Irish nation'. Hermathena, 103 (1966) 5–31.
18. Malcolm Johnston Brown, The politics of Irish literature: from Thomas Davis to W. B. Yeats. (Seattle: University of Washington Press 1973).
19. Eileen Sullivan, Thomas Davis. (Lewisburg, New Jersey: Bucknell University Press 1978).
20. Mary G. Buckley, Thomas Davis: a study in nationalist philosophy. Ph.D Thesis, National University of Ireland, at the Department of Irish History, UCC, 1980.
21. Giulio Giorello, '"A nation once again": Thomas Osborne Davis and the construction of the Irish "popular" tradition'. History of European Ideas, 20:1–3 (1995) 211–217.
22. John Neylon Molony, A soul came into Ireland: Thomas Davis 1814–1845. (Dublin 1995).
23. Robert Somerville-Woodward, 'Two 'views of the Irish language': O'Connell versus Davis'. The History Review: journal of the UCD History Society, 9 (1995) 44–50.
24. John Neylon Molony, 'Thomas Davis: Irish Romantic idealist'. In: Richard Davis; Jennifer Livett; Anne-Maree Whitaker; Peter Moore (eds.), Irish-Australian studies: papers delivered at the eighth Irish-Australian Conference, Hobart July 1995 (Sydney 1996) 52–63.
25. David Alvey, 'Thomas Davis. The conservation of a tradition'. Studies; an Irish quarterly review, 85 (1996) 37–42.
26. Harry White, The keeper's recital: music and cultural history in Ireland, 1770–1970. (Cork 1998).
27. Joseph Langtry; Brian Fay, 'The Davis influence'. In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 30–38.
28. Joseph Langtry, 'Thomas Davis (1814–1845)'. In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 2–7.
29. Jane Ohlmeyer, John Kenyon (eds), The Civil Wars. (Oxford 1998).
30. Patrick Maume, 'Young Ireland, Arthur Griffith, and republican ideology: the question of continuity'. Éire-Ireland, 34:2 (1999) 155–74.
31. Sean Ryder, 'Speaking of '98: Young Ireland and republican memory'. Éire-Ireland, 34:2 (1999) 51–69.
32. Micheál Ó Siochrú, Confederate Ireland 1642–49 (Dublin 1999).
33. Philip O'Regan, Archbishop William King, 1650–1729 and the Constitution in Church and State (Dublin 2000).
34. Micheál Ó Siochrú (ed.), Kingdoms in Crisis: Ireland in the 1640s. (Dublin 2000).
35. Ghislaine Saison, 'L'écriture de l'histoire chez la Jeune Irlande: quelle histoire pour une nation du consensus et de la réconciliation?'. In: Centre de recherche inter-langues angevin, Écriture(s) de l'histoire: Actes du colloque des 2,3 et 4 décembre 1999. (Angers 2001) 435–446.
36. Gerard Kearns, 'Time and some citizenship: nationalism and Thomas Davis'. Bullán: an Irish Studies Review, 5:2 (2001) 23–54.
37. Ghislaine Saison, 'Thomas Davis et la nation irlandaise'. Cercles, 4 (2002), 121–131.
38. Pádraig Lenihan, Confederate Catholics at War 1641–49. (Cork 2001).
39. Nicholas Canny, Making Ireland British 1580–1650. (Oxford 2001).
40. Helen Mulvey, Thomas Davis and Ireland: a biographical study. Washington, D.C., Catholic University of America Press, 2003.
41. Also cf. Walter Harris's History and Antiquities of the City of Dublin. Among other things, this book contains chronicles of Dublin from 1640 to 1704. Available at a private website; http://www.chapters.eiretek.org/books/Harris/contents.htm

Thomas Osborne Davis The Irish Parliament of James II in , Ed. T. W. Rolleston Thomas Davis: Selections from his prose and poetry. The Talbot Press, Dublin and London, ([1910]) page 1–73### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


the whole text.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


the electronic text represents the edited text. Italicized or capitalized sections of the text are tagged emph. Text other than in English is marked.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged qt and may be included in cit tags.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the whole text. div1=the chapter; div2=the act of parliament; div3=the clause. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Personal names and titles of books/journals are tagged, and identified/regularized within the encoding. Some technical terms are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: by Thomas Davis

 (c. 1840) #### Use of language


##### Language: [EN] The whole text is in English.


##### Language: [LA] Some phrases are in Latin.


##### Language: [GA] A word is in Irish.


##### Language: [IT] A phrase is in Italian.


### Revision History


* (2010-04-11) Beatrix Färber (ed.)

* Conversion script run; header updated; new wordcount made; file parsed.
* (2009-07-28) Beatrix Färber (ed.)

* File updated; new wordcount made.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T14:22:42+0100) Peter Flynn (conversion)

* Converted to XML
* (2005-05-10) Beatrix Färber (ed.)

* Bibliography compiled. File parsed. Names and titles marked up and identified; HTML file created.
* (2005-04-07) Beatrix Färber (ed.)

* Header created, more structural mark-up and content markup added.
* (2005-03-31) Janet Crawford, Tipperary (ed.)

* Text proofed (2), some structural markup added.
* (1996) Audrey Murphy (ed.)

* Text proofed (1)
* (1996) Audrey Murphy (ed.)

* text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800002-045


### The Irish Parliament of James II: Author: Thomas Osborne Davis




---

p.3


### The Irish Parliament of James II.

### Preface.


This enquiry is designed to rescue eminent men and worthy acts from calumnies which were founded on the ignorance and falsehoods of the Old Whigs, who never felt secure until they had destroyed the character as well as the liberty of Ireland.


Irish oppression never could rely on mere physical force for any length of time. Our enormous military resources, and the large proportion of ‘fighting men,’ or men who love fighting, among our people, prohibit it. It was ever necessary to divide us by circulating extravagant stories of our crimes and our disasters, in order to poison the wells of brotherly love and patriotism in our hearts, that so many of us might range ourselves under the banner of our oppressor.


Calumny lives chiefly on the past and future; it corrupts history and croaks dark prophecies. Never, from **Tyrconnell**'s rally down to **O' Connell**'s revival of the Emancipation struggle — never, from the summons of the Dungannon Convention to the Corporation Debate on Repeal, has a single bold course been proposed for Ireland, that folly, disorder, and disgrace has not been foreboded. Never has any great deed been done here that the alien Government did not, as soon as the facts became historical, endeavour to blacken the honour of the statesmen, the wisdom of the legislators, or the valour of the soldiers who achieved it.


One of the favourite texts of these apostles of misrule was the Irish Government in **King James**'s time. ‘There's a specimen,’ they said, ‘of what an Irish Government would be — unruly, rash, rapacious, and bloody.’ But the King, Lords, and Commons of 1689, when looked


---

p.4






at honestly, present a sight to make us proud and hopeful for Ireland. Attached as they were to their King, their first act was for Ireland. They declared that the English Parliament had not, and never had, any right to legislate for Ireland, and that none, save the King and Parliament of Ireland, could make laws to bind Ireland.


In 1698, just nine years after, while the acts of this great Senate were fresh, **Molyneux** published his case of Ireland, that case which **Swift** argued, and **Lucas** urged, and **Flood** and **Grattan**, at the head of 70,000 Volunteers, carried, and England ratified against her will. Thus, then, the idea of 1782 is to be found full grown in 1689. The pedigree of our freedom is a century older than we thought, and Ireland has another Parliament to be proud of.


That Parliament, too, established religious equality. It anticipated more than 1782. The voluntary system had no supporters then, and that patriot Senate did the next best thing: they left the tithes of the Protestant People to the Protestant Minister, and of the Catholic People to the Catholic Priest. Pensions not exceeding £200 a year were given to the Catholic Bishops. And no Protestant Prelates were deprived of stipend or honour — they held their incomes, and they sat in the Parliament. They enforced perfect liberty of conscience; nor is there an Act of theirs which could inform one ignorant of Irish faction to what creed the majority belonged. Thus for its moderation and charity this Parliament is an honour and an example to the country.


While on the one hand they restored the estates plundered by the Cromwellians thirty-six years before, and gave compensation to all innocent persons — while they strained every nerve to exclude the English from our trade, and to secure it to the Irish — while they introduced the Statute of Frauds, and many other sound laws, and


---

p.5






thus showed their zeal for the peaceful and permanent welfare of the People, they were not unfit to grapple with the great military crisis. They voted large supplies; they endeavoured to make a war-navy; the leading members allowed nothing but their Parliamentary duties to interfere with their recruiting, arming, and training of troops. They were no timorous pedants, who shook and made homilies when sabres flashed and cannon roared. Our greatest soldiers, **M'Carthy** and **Tyrconnell**, and, indeed, most of the Colonels of the Irish regiments, sat in Lords or Commons; — not that the Crown brought in stipendiary soldiers, but that the Senate were fearless patriots, who were ready to fight as well as to plan for Ireland. Theirs was no qualified preference for freedom if it were lightly won — they did not prefer ‘Bondage with ease to strenuous liberty.’


Let us then add 1689 to our memory; and when a Pantheon or Valhalla is piled up to commemorate the names and guard the effigies of the great and good, the bright and burning genius, the haughty and faithful hearts, and the victorious hands of Ireland, let not the men of that time — that time of glory and misfortune — that time of which Limerick's two sieges typify the clear and dark sides — defiance and defeat of the Saxon in one, trust in the Saxon and ruin on the other — let not the legislators or soldiers of that great epoch be forgotten.


 **Thomas Davis.** July, 1843.


---

p.6


A RETROSPECT
------------


HOW far the Parliament which sat in Dublin in 1689 was right or wrong has been much disputed. As the history of it becomes more accurately and generally known, the grounds of this dispute will be cleared.


Nor is it of trifling interest to determine whether a Parliament, which not only exercised great influence a the time, but furnished the enactors of the **Penal Laws** with excuses, and the achievers of the Revolution of 1782 with principles and a precedent, was the good or evil thing it has been called.


The writers commonly quoted against it are, **King**, **Harris**, **Leland**; those in its favour, **Leslie**, **Curry**, **Plowden**, and **Jones**.[1](javascript:footNote('E800002-045/note001.html')) Of all these writers, **King** and **Lesley** are alone original authorities. **Harris** copies **King**, and **Leland** copies **Harris**, and **Plowden**, **Curry**, and **Jones** rely chiefly on **Lesley**. Neither **Harris**, **Leland**, nor **Curry** adds anything to our knowledge of the time. **King** (notwithstanding, as we shall show hereafter, his disregard of truth) is valuable as a contemporary of high rank; **Lesley**, also a contemporary, and of unblemished character, is still more valuable. **Plowden** is a fair and sagacious commentator; **Jones**, a subtle and suggestive critic on those times.




---

p.7


If, in addition, the reader will consult such authorities as the Letters of **Lord Lieutenant Tyrconnell**[2](javascript:footNote('E800002-045/note002.html')) the Memoirs[3](javascript:footNote('E800002-045/note003.html')) of **James the Second** by himself; Histoire de la Révolution par Mazure;[4](javascript:footNote('E800002-045/note004.html')) and the pamphlets quoted in this publication, and the notes to it, he will be in a fair way towards mastering this difficult question.


After all, that Parliament must be judged by its own conduct. If its acts were unjust, bigoted, and rash, no excuse can save it from condemnation. If, on the other hand, it acted with firmness and loyalty towards its king — if it did much to secure the rights, the prosperity, and the honour of the nation — if, in a country where property had been turned upside down a few years before, it strove to do justice to the many, with the least possible injury to the few — if, in a country torn with religious quarrels, it endeavoured to secure liberty of conscience without alienating the ultra zealous — and, finally, if in a country in imminent danger from a powerful invader and numerous traitors, it was more intent on raising resources and checking treason than would become a parliament sitting in peace and safety, let us, while confessing its fallibility, attend to its difficulties, and do honour to its vigour and intelligence.


Before we mention the composition of the Parliament, it will be right to run over some of the chief dates and facts which brought about the state of things that led to its being summoned. Most Irishmen (ourselves among the number) are only beginners at Irish history, and cannot too often repeat the elements: still the beginning has been made. It is no pedantry which leads one to the English invasion for the tap-root of the transactions of the seventeenth century.


Four hundred years of rapacious war and wild resistance had made each believe all things ill of the other; and

 


---

p.8






when England changed her creed in the sixteenth century it became certain that Ireland would adhere to hers at all risks. Accordingly, the reigns of the latter, and especially of the last of the Tudors, witnessed unceasing war, in which an appetite for conquest was inflamed by bigotry on the English side, while the native, who had been left unaided to defend his home, was now stimulated by foreign counsels, as well as by his own feelings, to guard his altar and his conscience too.


**Jamesthe First** found Ireland half conquered by the sword; he completed the work by treachery, and the fee of five-sixths of Ulster rewarded the ‘energy’ of the British. The proceedings of **Strafford** added large districts in the other provinces to the English possessions. Still, in all these cases, as in the Munster settlement under **Elizabeth**, the bulk of the population remained on the soil. To leave the land was to die. They clung to it amid sufferings too shocking to dwell on;[5](javascript:footNote('E800002-045/note005.html')) they clung to it under such a serfhood as made the rapacity of their conquerors interested in retaining them on the soil. They clung to it from necessity and from love. They multiplied on it with the rapidity of the reckless. Yet they retained hope, the hope of restitution and vengeance. The mad ferocity of **Parsons** and **Borlace** hastened the outbreak of 1641. That insurrection gave back to the native his property and his freedom, but compelled him to fight for it — first, against the loyalists; next, against the traitors; and lastly, against the republicans. After a struggle of ten years, distinguished by the ability of the Council of Kilkenny, and the bravery of **Owen Roe** and his followers, the Irish sunk under the abilities and hosts of **Cromwell**. Those who felt his sway might well have envied the men who conquered and died in the breach of Clonmel, or fell


---

p.9






vanquished or betrayed at Letterkenny and Drogheda. During the insurrection of 1641, the royal government, at once timid and tyrannical, united with the sordid capitalists of London to plunder the Irish of their lands and liberty, if not to exterminate them.[6](javascript:footNote('E800002-045/note006.html')) In order to effect this, a system of unparalleled lying was set afoot against the natives of this kingdom. The violence which naturally attended the sudden resumption of property by an ignorant, excited, and deeply wronged people, was magnified into a national propensity to throat-cutting. Exaggerations the most barefaced were received throughout England. Deaths, which the English-minded Protestant, the **Rev. Mr. Warner**, has ascertained to have been under 12,000 — reckoning deaths from hardships along with those by the sword — were rated in England at 150,000, and by **John Milton** at 616,000.[7](javascript:footNote('E800002-045/note007.html')) No wonder the English nation looked upon us as bloody savages; and no wonder they looked approvingly at the massacres and confiscations of the Lord Protector. But the Irish deemed they were free from crime in resuming by force of arms the land which arms had taken from them; they regarded the bloodshed of '41 as a deplorable result of English oppression; they fought with the hearts of resolved patriots till 1651.


The restoration of the **Stuarts** was hailed as the restoration of their rights. They were woefully disappointed. A compromise was made between the legitimists and the republicans; the former were to resume their rank, the latter to retain their plunder. Ireland was disregarded. The mockery of the Court of Claims restored less than one-third of the Irish lands. While in 1641 the Roman Catholics possessed two-thirds of Ireland, in 1680 they


---

p.10






had but one-fifth.[8](javascript:footNote('E800002-045/note008.html')) Besides, the new possessors were of an opposite creed, and fortified themselves by **Penal Laws**. Under such circumstances the aim of most men would be much the same, namely, to take the first opportunity of regaining their property, their national independence, and religious freedom. With reference to their legislation on the two latter points, doubts may be entertained how much should be complained of; and even those who condemn that on the first, should remember that ‘the re-adjustment of all private rights, after so entire a destruction of their landmarks, could only be effected by the coarse process of general rules.’ [9](javascript:footNote('E800002-045/note009.html'))


Let us now run over a few dates, till we come to the event which gave the Irish this opportunity. On the 6th of February, 1685, **Charles the Second** died in the secret profession of the Roman Catholic faith, and his brother, **James Stuart, Duke of York**, succeeded him.


**James the Second** came to his throne with much of what usually wins popular favour. He united in his person the blood of the Tudor, Plantagenet, and Saxon kings of England, while his Scottish descent came through every king of Scotland, and found its spring in the Irish Dalriad chief, who, embarking from Ulster, overran Albany. In addition, **James** had morals better than those of his rank and time, as much intellect as most kings, and the reputation acquired from his naval administration, graced as it was by sea-fights in which no ship was earlier in action than **James**'s, and by at least one great victory — that over Opdam — fought near Yarmouth, on the 3rd June, 1665.


Yet the difference of his creed from that of his English subjects blew these popular recollections to shivers. 


---

p.11




 



He tried to enforce, first, toleration; and, secondly, perfect religious equality, and intended, as many thought, the destruction of that equality, by substituting a Roman Catholic for a Protestant supremacy; and the means he used for this purpose were such as the English Parliament had pronounced unconstitutional. He impeached the corporate charters by **quo warranto**, brought to trial before judges whom he influenced, as all his predecessors had done. He invaded the customs of the universities, as having a legal right to do so. He suspended the **Penal Laws**, and punished those who disobeyed his liberal but unpopular proclamations. Some noble zealots, the **Russells** and **Sidneys**, crossed his path in vain; but a few bold caballers, the **Danbys**, the **Shaftesburys**, and **Churchills**, by urging him to despotic acts, and the people to resistance, brought on a crisis; when, availing themselves of it, they called in a foreign army and drove out **James**, and swore he had abdicated; expelled the **Prince of Wales**, and falsely called him bastard; made terms with **William**, that he should have the crown and privy purse, and they the actual government; and ended by calling their selfish and hypocritical work, ‘a popular and glorious revolution.’


It is needless to follow up **James**'s quarrel with the university of Oxford, and his unsuccessful prosecution of the seven Bishops on the 29th of June, 1688, who, emboldened by the prospect of a revolution, refused to read his proclamation of indulgence. From the day of their acquittal, **James** was lost. Letters were circulated throughout England [10](javascript:footNote('E800002-045/note010.html')) and Ireland, declaring the young **Prince of Wales** (who was born 10th June) spurious, and containing many other falsehoods, so as to shake men's souls with rumours, and arouse popular prejudices. The army was tampered with; the nobles and clergy were in treaty with Holland. **James** not only refused to retract his


---

p.12






policy till it was too late; but refused, too, the offer of **Louis** to send him French troops.


Similar means had been used by and against him in Ireland. **Tyrconnell**, who had replaced **Clarendon** as Lord Lieutenant in 1686, got in the charters of the corporations, reconstructed the army, and used every means of giving the Roman Catholics that share in the government of this country to which their numbers entitled them. And, on the other hand, the Protestant nobles joined the English conspiracy, and adopted the English plan of false plots and forged letters.


At length, on 4th November, 1688, **Prince William** landed at Torbay with 15,000 veterans. **James** attempted to bear up, but his nearest and dearest, his relatives and his favourites, deserted him in the hour of his need. It seems not excessive to say that there never was a revolution in which so much ingratitude, selfishness, and meanness were displayed. There is not one great genius or untainted character eminent in it. Yet it succeeded. On the 18th of December, **William** entered London; on the 23rd, **James** sailed for France; and in the February following the English convention declared he had abdicated.


These dates are, as **Plowden** remarks, important; for though **James**'s flight, on the 23rd of December, was the legal pretence for insurrection in the summer of 1689, yet negotiations had been going on with Holland through 1687 and 1688,[11](javascript:footNote('E800002-045/note011.html')) and the Northern Irish formed themselves into military corps, and attacked the soldiers of the crown before Enniskillen, on the first week in December; and on the 7th December the gates of Derry were shut in the face of the king's troops, [12](javascript:footNote('E800002-045/note012.html')) facts which should be remembered in judging the loyalty of the two parties.


---

p.13





ORIGIN AND CHARACTER OF THE PARLIAMENT. — THE HOUSE OF LORDS
------------------------------------------------------------


**James** landed at Kinsale, 12th March, 1689, about a month after the election of **William** and **Mary** by the English convention. He entered Dublin in state on the 24th March, accompanied by **D'Avaux**, as Ambassador from France, and a splendid court. His first act was to issue five proclamations — the first, requiring the return and aid of his Irish absentee subjects; the second, urging upon the local authorities the suppression of robberies and violence which had increased in this unsettled state of affairs; the third, encouraging the bringing provisions for his army; the fourth, creating a currency of such metal as he had, conceiving it preferable to a paper currency (a gold or silver currency was out of his power, for of the two millions promised him by France, he only got £150,000); the fifth proclamation summoned a parliament for the 7th May, 1689.


**James** also issued a proclamation promising liberty of conscience, justice and protection [13](javascript:footNote('E800002-045/note013.html')) to all; and, after receiving many congratulatory addresses, set out for Derry to press the blockade. On the 29th April he returned to Dublin. On the 7th May Ireland possessed a complete and independent government. Leaving the castle, over which floated the national flag, **James** proceeded in full procession to the King's Inns, where the Parliament sat, and the Commons having assembled at the bar of the Peers, **James** entered, ‘with Robe and Crown,’ and


---

p.14






addressed the Commons in a speech full of manliness and dignity. At the close of the speech, the Chancellor of Ireland, **Lord Gosworth**, directed the Commons to retire and make choice of a Speaker. In half an hour the Commons returned and presented **Sir Richard Nagle** as their Speaker, a man of great endowments and high character. The Speaker was accepted, and the Houses adjourned.


The peers who sat in this parliament amounted to fifty-four. Among these fifty-four were six dignitaries of the Protestant Church, one duke, ten earls, sixteen viscounts, and twenty-one barons. It contained the oldest families of the country — **O'Brien** and **DeCourcy**, **MacCarty** and **Bermingham**, **De Burgo** and **Maguire**, **Butler** and **Fitzpatrick**. The bishops of Meath, Cork, Ossory, Limerick, and Waterford, and the Protestant names of **Aungier**, **Le Poer**, and **Forbes** sat with the representatives of the great Roman Catholic houses of **Plunket**, **Barnewell**, **Dillon**, and **Nugent**. Nor were some fresher honours wanting; **Talbot** and **Mountcashel** were the darlings of the people, the trust of the soldiery, the themes of bards.


**King**'s impeachment of this parliament is amusing enough. His first charge is, that if the House were full, the majority would have been Protestant. Now, if the majority preferred acting as insurgents under the **Prince of Orange**, to attending to their duties in the Irish house of peers, it was their own fault. Certain it is, the most violent might safely have attended, for the earls of **Granard** and **Longford** and the **bishop of **Meath**** not only attended, but carried on a bold and systematic opposition. And so far was the House from resenting this, that they committed the sheriff of Dublin to prison for billeting an officer at the bishop of Meath's. Yet the bishop had not merely resisted their favourite repeal of the Settlement, but, in doing so, had stigmatized their fathers and some of themselves as murderous rebels.


---

p.15


**King**'s next charge is, that the attainders of many peers were reversed to admit them. Now this is unsupported by evidence against fact, and simply a falsehood. Then he complains of the new creations. They were just five in number; and of these five, two were great legal dignitaries — the **Lord Chancellor** and **Lord Chief Justice** of Ireland; the third was **Colonel MacCarty**, of the princely family of **Desmond**, and a distinguished soldier with a great following; the others, **Brown**, **Lord Kenmare**; and **Bourke**, **Lord Bofin** (son of **Lord Clanricarde**), men of high position in their counties.


**Fitton Lord Gosworth**, occupied the **woolsack**. That he was a man of capacity, if not of character, may be fairly presumed from his party having put him in so important an office in such trying times.[14](javascript:footNote('E800002-045/note014.html')) He certainly had neither faction nor following to bring with him. Nor was he treated by his party below what his rank entitled him to. The appointments in his court were not interfered with: his decrees were not impeached, and in the council he sat above even **Herbert, the Lord Chancellor of England**. Yet, **King** describes this man as ‘detected of forgery,’ one who was brought from gaol to the **woolsack** — one who had not appeared in any court — a stranger to the kingdom, the laws, and the practice and rules of court; — one who made constant needless references to the Masters to disguise his ignorance, and who was brought into power, first, because he was ‘a convert papist, that is, a renegade to his country and his religion;’ and, secondly, because he would enable the Irish to recover their estates by countenancing ‘forgeries and perjuries,’ which last, continues the veracious archbishop, he nearly effected, without putting them to the trouble of repealing the Acts of Settlement. **King** staggers from the assertion that **Fitton** denied justice to Protestants, into saying it was got from him with difficulty.




---

p.16


**Thomas Nugent, Baron Riverstown**, second son of the **Earl of Westmeath**, was chosen chairman of committees. **King**, who is the only authority at present accessible to us, states that **Nugent** had been *out* in 1641, but considering that he did not die till 1715, he must have been a mere boy in '41, if born at all; and, at any rate, as his family, including his grandfather, **Lord Delvin (first Earl of Westmeath)**, and his father, carried arms against the Irish up to 1648, and suffered severely, it is most improbable that he was, as a child, in the opposite ranks.


The Irish had never ceased to agitate against the Acts of Settlement and Explanation. Thus **Nicholas Plunket** had done legal battle against the first, till an express resolution excluded him by name from appearing at the bar of the council. Then **Colonel Talbot (Tyrconnell**) led the opposition effort for their repeal or mild administration. In 1686, **Sir Richard Nagle** went to England, as agent of the Irish, to seek their repeal. But the greatest effort was made in 1688. **Nugent** and **Rice** were sent expressly to London to press the repeal. **Rice** is said to have shown great tact and eloquence, but **Nugent** to have been rash and confused. Certain it is, they were unsuccessful with the council, and were brutally insulted by the London mob, set on by the very decent chiefs of the Williamite party.


Of the eighteen prelates, ten were Englishmen, one Welsh, and only seven Irish. Several had been chaplains to the different lords lieutenant. Eleven out of the eighteen were in England during the session. Of these, some were habitual absentees, such as **Thomas Hackett, bishop of Down**, deprived in 1691 by Williamite commissioners for an absence of twenty years. Others had got leave of absence during '87 and '88. Some, like **Archbishop John Vesey of Tuam**, and **Bishop Richard Tennison of Killala**, fled in good earnest, and accepted lecturerships and cures in London.




---

p.17


There was one man among them who deserves more notice, **Anthony Dopping, lord bishop of Meath**. He was born in Dublin, 28th March, 1643, and died 24th April, 1697. He was educated in St. Patrick's schools, and won his fellowship in T.C.D. in 1662, being only 19 years old. He led the opposition in the parliament of '89 with great vigour and pertinacity. He resisted all the principal measures, and procured great changes in some of them, as appears by The Journal. He had a fearless character and ready tongue. He continued a leader of the Ultras after the **battle of the Boyne**, and quarrelled with the government. **King William** , finding how slowly the Irish war proceeded, had prepared and sent to Ireland a proclamation conceding the demands of the Roman Catholics, granting them perfect religious liberty, right of admission to all offices, and an establishment for their clergy.[15](javascript:footNote('E800002-045/note015.html')) While this was with the printers in Dublin, news came of the danger of Limerick. The proclamation was suppressed by the Lords Justices, who hastened to the camp, ‘to hold the Irish to as hard terms as possible. This they did effectually.’ Still these ‘hard terms’ were too lenient for the Ultras, who roared against the treaty of Limerick, and demanded its abrogation. On the Sunday after the Lords Justices had returned, full of joy at having tricked the Irish into so much harder terms than **William** had directed them to offer, they attended Christ Church, and the **bishop of Meath** preached a sermon, whose whole object was to urge the breaking of the treaty of Limerick, contending (says **Harris**, in his Irish Writers in Ware, p. 215) that ‘peace ought not to be kept with a people so perfidious.’ 


---

p.18






The Justices, and the Williamite or moderate party, were enraged at this. The **bishop of Kildare** was directed to preach in Christ Church on the following Sunday in favour of the treaty; and he obtained the place in the privy council from which the bishop of Meath was expelled; but ultimately the party of the latter triumphed, and enacted the **Penal Laws**.


The list of the Lords Temporal has been made out with great care, from all the authorities accessible.


Ireland had then but two dukes, **Tyrconnell** and **Ormond**. **Ormond** possessed the enormous spoils acquired by his grandfather from the Irish, and was therefore largely interested in the success of the English party. He, of course, did not attend. His huge territory and its regal privileges were taken from him by a special act.


Considering the position he occupied, the materials on the life of **Tyrconnell** are most unsatisfactory. **Richard Talbot** was a cadet of the Irish branch of the **Shrewsbury** family, and numbered in his ancestors the first names in English history. His father was **Sir William Talbot**, a distinguished Irish lawyer, and his brother, **Peter Talbot**, was R.C. Archbishop of Dublin, and was murdered there by tedious imprisonment on a false charge in 1680. He was a lad of sixteen when **Cromwell** sacked Drogheda in September 1649, and he doubtless brought from its bloody ashes no feeling in favour of the Saxon. He was all his life engaged in the service of the Irish and of **James**. He was attached to the Duke of York's suite from the Restoration, and was taken prisoner by the Dutch, on board the Catharine, in the naval action at Solebay, 29th May, 1672. [16](javascript:footNote('E800002-045/note016.html')) After the Acts of Settlement and Explanation were passed, he acted as agent for the Irish Roman Catholics, urging their claims with all the influence his rank,


---

p.19






abilities, and fortune[17](javascript:footNote('E800002-045/note017.html')) could command. His zeal got him into frequent dangers; he was sent to the Tower in 1661 and 1671 for having challenged the **Duke of Ormond**, and the English Commons presented an address in 1671, praying his dismissal from all public employments. He was selected by **James**, both from personal trust and popularity, to communicate with the Irish; and though **Clarendon** was first sent as Lord Lieutenant in '85, **Tyrconnell** had the independent management of the army,[18](javascript:footNote('E800002-045/note018.html')) and replaced **Clarendon** in 1686.


**Sarsfield**, who was at the head of the French party, and most of the great Irish officers, thought him undecided, hardly bold enough, and with a selfish leaning towards England. Of his selfishness we have now a better proof than they had, a proof that might have abated his master's enlogy, given further on. We say might, for possibly **Tyrconnell** was in communication with **James** as to the French offers.


‘It is now ascertained that, doubtful of the king's success in the struggle for restoring popery in England, he had made secret overtures to some of the French agents, for casting off all connection with that kingdom in case of **James**'s death, and, with the aid of **Louis**, placing the crown of Ireland on his own head. **M. Mazure** has brought this remarkable fact to light. **Bonrepos**, a French emissary in England, was authorised by his court to proceed in a *negotiation* with **Tyrconnell** for the separation of the two islands, in case that a Protestant should succeed to the crown of England. He had accordingly a private 


---

p.20






interview with a confidential agent of the Lord Lieutenant at Chester in the month of October, 1687. **Tyrconnell** undertook that in less than a year everything should be prepared.’[19](javascript:footNote('E800002-045/note019.html'))


**Tyrconnell was made Baron Talbotstown, Viscount Baltinglass, and Earl of Tyrconnell in 1686, and Duke and Marquis**, 30th March, 1689.


From his coming to Ireland, he worked hard for his master and his countrymen. He gradually substituted Jacobite soldiers for the Oliverians, who till then filled the ranks. He increased the army largely, and lent the king 3,000 men in '88. Mischief was done to **James**'s cause by this employment of Irish troops in England. He was active in calling in the corporation charters, and was exposed to much calumny on account of it. The means, doubtless, were indefensible (for the change should have been effected by act of Parliament, as it has at length been in our times), but the end was to put the corporations into the hands of the Irish people. And even in those new corporations, one-third of the burgesses were of English descent and Protestant faith; but this moderation is attempted to be shaved away by the Williamites, who insist that most of these Protestants were Quakers, whom they describe as a savage rabble, originally founded by the Jesuits[20](javascript:footNote('E800002-045/note020.html')) — with what injustice we need hardly say. **James** describes him ‘as a man of good abilities and clear courage, and one who for many years had a true attachment to his majesty's person and interest.’[21](javascript:footNote('E800002-045/note021.html'))


**Lord Clanrickarde** represented the **Mac William Uachdar**, one of the two great branches of the **De Burgos**, who


---

p.21






usurped the chieftaincy on the death of the **Earl of Ulster** in the year 1333. His father was the great **Lord Clanrickarde**, who held Connaught in peace and loyalty, from 1641 to 1650; when the troops for which he had negotiated with the **Duke of Lorraine** not arriving, he too yielded to the storm.


**Mac Donnel Lord Antrim**, also the representative of a great house (the **Lord of the Isles**), was equally dependent on his predecessor for notoriety. His elder brother, the **Marquis and Earl of Antrim**, played a notorious and powerful part on the Irish side, in the war, from 1642 Up to 1650. This **Earl Alexander** also commanded an Irish regiment during the same war. He was within the treaty of Limerick, and saved his rank and fortune.


Lords **Longford** and **Granard** were Williamites in fact. This does not follow from their having acted so vigorously in the opposition in 1689, but from their having joined **William** openly the year after. **Lord Granard** had been offered the command of the Williamites of Ulster in 1688, and on his refusal, **Lord Mount Alexander** was appointed.


Among the earls, one naturally looks for the two famous names of **Taaffe** and **Lucan**. But **Taaffe** was then on an embassy to the emperor, and **Patrick Sarsfield** was not made **Earl of Lucan** till after. Indeed his patent is not entered in the rolls, from which 'tis probable he was not titled till after the **battle of the Boyne**.


**Viscount Iveagh** held Drogheda at the **battle of the Boyne**, and was induced to surrender it by **William**'s ruffianly and unmilitary threat of 'no quarter.'


**Lord Clare** was father to the famous **Lord Clare**, whose regiment was the glory of the Irish Brigade, and who was killed at Ramillies in 1706. He was descended from **Connor O'Brian, third earl of Thomond**.


**Lord Mountcashel**, by his rapidity and skill, completely broke the Munster insurgents, and made that province,

 


---

p.22






till then considered the stronghold of the English, **James**'s best help. To him was intrusted the **Bill** repealing the Settlement in the Commons, where he sat as member for the county of Cork till that **Bill** passed the Commons, when he was called to the Upper House as **Lord Mountcashel**.


**Lord Kinsale** represented the famous **John De Courcy, Earl of Ulster**, and had the blood of **Charlemagne** in his veins. He served as Lieutenant-Colonel to **Lord Lucan**. His attainder under **William** was reversed, and he appeared at court, where he enforced the privilege peculiar to his family of remaining covered in the king's presence.


---

p.23





THE HOUSE OF COMMONS
--------------------


THE number of members in the Commons, as the complement was made up under the monstrous charters of **James I.**, **Charles I.**, and **Charles II.**, far outdoing in their unconstitutional nature any of the stretchings of prerogative in the reign of **James II.**, amounted to 300. The number actually returned was 224. Of the deficiencies, no less than 28 were caused by the places being the seats of the war.


The character of this assembly must be chiefly judged by its acts, and we shall presently resume the consideration of them; but there are some things in the composition of the Commons whereby their character has been judged.


They have been denounced by **King**: but before we examine his statements, let us inquire who he was, lest we underrate or overrate his testimony; lest we unjustly require proof, in addition to the witness of a thoroughly pure and wise man; or, what is more dangerous, lest we remain content with the unconfirmed statements of a bigot or knave.


**William King** was the son of **James King**, a miller, who, in order to avoid taking the Solemn League and Covenant, removed from the North of Scotland, and settled in Antrim, where **William** was born, 1st of May, 1650. (See **Harris**'s Ware, Bishops of Derry.) He was educated at Dungannon, was a sizar, 'native',' and schoolmaster in T.C.D., and was ordained in 1673. **Parker, archbishop of Tuam**, gave him a heap of livings, and on being translated to Dublin, procured the Chancellorship.


---

p.24






of St. Patrick's for King in 1679. This he held during the Revolution. He was imprisoned in 1689 on suspicion, but after some months was released, through the influence of **Herbert** and **Tyrconnell**, and notwithstanding **C. J. Nugent** 's opposition. Immediately on his release he wrote his State of the Protestants of Ireland, printed in London, cum privilegio, at the chief Williamite printer's. It was written and published while the war in Ireland was at its height, and when it was sought at any price to check the Jacobite feeling then beginning to revive in England, by running down the conduct of the Irish, **James**'s most formidable supporters. Moreover, **King** had been imprisoned (justly or unjustly) by **James**'s council, and he obtained the bishopric of Derry from **William**, on the 25th of January, 1690 (old style), namely, within thirty-eight weeks before the publication of his book, which was printed cum privilegio, 15th of October, 1691. Whether the bishopric was the wages of the book, or the book revenge for the imprisonment, we shall not say; but surely **King** must have had marvellous virtue to write impartially, in excited and reckless times, for so demoralized a party as the English Whigs, when he wrote of transactions yet incomplete, of which there was a perilous stake not only for him but for his friends, and when, of the parties at issue, one gave him a gaol and the other a mitre.


There is scarcely a section in his book that does not abound with the most superlative charges, put in the coarsest language. All the calumnies as to 1641, which are now confessed to be false, are gospel truths in his book. He never gives an exact authority for any of his graver charges, and his appendix is a valuable reply to his text.


When, in addition to these external probabilites and intrinsic evidences of falsehood, we add that, immediately on its publication, **Lesley** wrote an answer to it, denying its main statements as mere lies, and that his book was 


---

p.25






never replied to, we will not be in a hurry to adopt any statement of **King**'s.


But in order to see the force of this last objection to **King**'s credibility, something must be known of **Lesley**.

 **Charles Lesley**, son of the **bishop of Clogher**, is chiefly known for his very able controversial writings against Deists, Catholics, and Dissenters. He was a law-student till 1680, when he took orders; and in 1687 became chancellor of Connor. When, in 1688, **James** appointed a Roman Catholic sheriff for Monaghan, **Mr. Lesley**, being then sick with gout, had himself carried to the courthouse, and induced the magistrates to commit the sheriff. In fact, it appears from **Harris** ( Life of William, p. 216, and Writers of Ireland, pp. 282-6), that **Lesley** was notorious for his conversions of Roman Catholics, and his stern hostility to **Tyrconnell**'s government. **Lesley** refused to take the oath of supremacy after the Revolution, and thereby lost all chance of promotion in the Church. He was looked on as the head of the nonjurors, and died in March, 1721-2, at Glaslough, universally respected.


Such being **Mr. Lesley**'s character, so able, so upright, so zealously Protestant, he, in 1692, wrote an answer to **King**'s State, in which he accuses **King** of the basest personal hypocrisy and charges him with having in his book written gross, abominable, and notorious falsehoods, and this he proves in several instances, and in many more renders it highly probable. **King** died 8th May, 1729, leaving **Lesley**'s book altogether unreplied to.


Here then was that man — **bishop of Derry** for eleven years and **archbishop of Dublin** for twenty-seven years — remaining silent under a charge of deliberate and interested falsehood, and that charge made by no unworthy man, but by one of his own country, neighbourhood, and creed — by one of acknowledged virtue, high position, and vast abilities.




---

p.26


Nor is this all; **Lesley**'s book was not only unanswered; it was watched and attempted to be stopped, and when published, was instantly ordered to be suppressed, as were all other publications in favour of the Irish or of **King James**.


The reader is now in a position to judge of the credibility of any assertion of **King**'s, when unsupported by other authority.


**King**' gravest charges are in the following passage: — These members of the House of Commons are elected either by freeholders of counties, or the freemen of the corporations; and I have already showed how **king James** wrested these out of the hands of Protestants, and put them into Popish hands in the new constitution of corporations, by which the freemen and freeholders of cities or boroughs, to whom the election of burgesses originally belongs, are excluded, and the election put into the hands of a small number of men named by the king, and removable at his pleasure. The Protestant freeholders, if they had been in the kingdom, were much more than the papist freeholders, but now being gone, though many counties could not make a jury, as appeared at the intended trial of **Mr. Price** and other Protestants at Wicklow, who could not be tried for want of freeholders — yet, not withstanding the paucity of these, they made a shift to return knights of the shire. The common way of election was thus: — The **Earl of Tyrconnell**, together with the writ for election, commonly sent a letter, recomnending the persons he designed should be chosen; the sheriff or mayor being his creature, on receipt of this, called so many of the freeholders of a county or burgesses of a corporation together, as he thought fit, and without making any noise, made the return. It was easier to do this in boroughs — because, by their new charters, the electors were not above twelve or thirteen, and in the greatest cities but twenty-four; and commonly, not half of these in the place. The method of the Sheriff's proceeding was the same; the number of Popish freeholders being very small, sometimes not a dozen in a county, it was easier to give notice to them to appear, so that the Protestants either did not know of the election or durst not appear at it.’’




First let us see about the boroughs. **King**, in his section on the corporations, states in terms that they’’

 (the Protestants) thought it reasonable to keep these (corporate towns) in their own hands, as being the foundation of the legislative power, and therefore secluded papists,’’

 etc. The purport, therefore, of **King**'s objection to the new constitution under **King James**'s charters was the admission of Roman Catholics. Religious equality was sinful in his eyes.




---

p.27


The means used by **James** to change the corporations, namely, bringing quo warrantos in the Exchequer against thern, and employing all the niceties of a confused law to quash them, we have before condemned. In doing so, he had the precedents of the reigns called most constitutional by English historians, and those not old, but during his brother's reign; nor can anyone who has looked into **Brady**'s treatise on Boroughs doubt that there was plenty of 'law' in favour of **James**'s conduct.[22](javascript:footNote('E800002-045/note022.html')) But still public policy and public opinion in England were against these quo warrantos, and in Ireland they were only approved of by those who were to be benefited by them.


But the means being thus improper, the use made by **James** of this power can hardly be complained of. The Roman Catholics were then about 900,000, the Protestants, over 300,000. **James**, it is confessed, allowed one-third of the corporations to be Protestant, though they were little, if at all, more than one-fourth of the population. This will appear no great injustice in our times, although some of these Protestants may, as it has been alleged, have been 'Quakers'.


It must also be remembered that those proceedings were begun not by **James** but by **Charles**; that the corporations were, with some show of law, conceived to have been forfeited during the Irish war, or the Cromwellian rule; and that being offered renewals on terms, they refused; whereupon the quo warrantos were brought and decided before the regular tribunals during the earlier and middle part of **James**'s reign. On the 24th September, 1687, **James** issued his Royal Letter (to be found in **Harris**'s Appendix, pp. 4 to 6), commanding the renewal of the


---

p.28






charters. By these renewals, the first members of the corporations were to be named by the lord lieutenant, but they were afterwards to be elected by the corporations themselves. There certainly are non-obstante and non-resistance clauses ordered to be inserted, in the prerogative spirit of that day, which were justly complained of.


With reference to the number of burgesses, **King**'s statement that the number of electors was usually twelve or thirteen, and in the greatest cities but twenty-four, is untrue. Most of the Irish boroughs were certainly reduced to these numbers under the liberal Hanoverian government, but not so under **James**. The members' names are given in full in **Harris**'s Appendix, and from those it appears that no corporation had so few as twelve electors. Only five, viz. — Dungannon, Ennis, St. Johnstown (in Longford), Belturbet, and Athboy, were as low as thirteen; twenty-three, viz. — Tuam, Kildare, Cavan, Galway, Callan, Newborough, Carlingford, Gowran, Carysfort, Boyle, Roscommon, Athy, Strabane, Middletown, Newry, Philipstown, Banagher, Castlebar, Fethard, Blessington, Charleville, Thomastown, and Baltimore, varied from fourteen to twenty-four; most of the rest varied from thirty to forty. Dublin had seventy-three; Cork, sixty-one; Clonmel, forty-six; Cashel, forty-two; Drogheda, fifty-seven; Kilkenny, sixty-one; Limerick, sixty-five; Waterford, forty-nine; Youghal, forty-six; Wexford, fifty-three, and Derry, sixty-four. This is a striking proof of the little reliance to be placed on ***KING**'s positive statements.


**Harris**, a hostile authority, gives the names and generally the additions of the members of each corporation, and the majority are merchants, respectable traders, engineers, or gentlemen. Moreover, in such towns as our local knowledge extends to, the names are those of the best families, not being zealous Williamites. As to the counties, **King** relies


---

p.29






upon a pamphlet published in London in 1689, setting out great grievances in the title page, and disproving them in the body of the tract.


If many Protestant freeholders had fled to England, who was to blame? — Most assuredly, my **Lord Mount Alexander** and the rest of the right noble and honourable suborners, devisers, and propagators of forged letters and infamous reports, whereby they frightened the Protestants, in order to take advantage of their terror for their own selfish ends. The exposure of these devices by the publication of **Speke**'s Memoirs, by the confessed forgery of the Dromore letter, etc., have thrown the chief blame of the Protestant desertion off the shoulders of those Protestants, off the shoulders, too, of the Irish government, and have brought it crushingly upon the aristocratic cabal, who alone profited by the revoluton, as they alone caused it.


In the absence of other testimony, we must take, with similar allowances, the story of **Tyrconnell** *commonly* sending an unconstitutional letter to influence the election. But how very good these Jacobite sheriffs and mayors were to let **King** into the secret, in 1691, when their destiny was uncertain! That such gossip was current is likely, but for a historian to assert on such authority is scandalous.


**King** asserts that the unrepresented boroughs were about twenty-nine.’’

 Now, there were but eighteen boroughs unrestored; but **King** helps out the falsehood by inserting places — Thurles, Tipperary, Arklow, and Birr — which never had members before or since, by creating a second town of Kells, by transferring St. Johnstown in Longford, which returned members, to St. Johnstown in Donegal, which was a seat of war, and by other tricks equally discreditable to his honesty and intelligence.


The towns unrestored could not have sent members


---

p.30






to **James**'s parliament, and it was apparently doubted whether they ought to have done so to **William**'s in '92.


Against the Commons actually elected the charge is that only six Protestants were elected. In the very section containing the charge it is much qualified by other statements. Thus,’’

 he says, one **Gerard Dillon, Sergeant-at-Law**, a most furious Papist, was Recorder of Dublin, and he stood to be chosen one of the burgesses for the city, but could not prevail, because he had purchased a considerable estate under the Act of Settlement, and they feared lest this might engage him to defend it;’’

 and therefore they chose **Sir Michael Creagh** and **Terence Dermot**, their Senior Aldermen, showing pretty clearly that the good citizens of Dublin set little value on the furious Popery’’ of Prime Sergeant **Dillon**, in comparison with their property plundered by the Act of Settlement.
The election for Trinity College is worthy of notice. We have it set out in flaming paragraphs how horribly the College was used, worse than any other borough, 'Popish Fellows' being intruded. *In the house they placed a Popish garrison, turned the chapel into a magazine, and many of the chambers into prisons for Protestants.’’*

(King, p. 220, Ed. 1744.)

 Yet, miraculous to say, in the heart of this 'Popish garrison,' the turned-out Vice-Provost, Fellows, and Scholars’’ met, and elected two most bold, notable, and Protestant Williamites.
If this election could take place in Dublin, under the very nose of the Government, and in a corporation in which the king had unquestioned control, one will hesitate about the compulsion or exclusion in other places.


Besides **Sir John Meade** and **Mr. Joseph Coghlan**, the members for the College, there were four more Protestants returned, of whose behaviour I can give no account,’’

 says **King**. Pity he does not give the names.


---

p.31


If we were to allow a similar error in **King**'s account of the creed of the elected, that we have proved in his lists of the borough electors, it would raise the number of Protestants in the house to about fourteen.


Allowing then for the Protestants in arms against the Government — out of the country, or within the seat of war — the disproportion between their representatives and the Roman Catholics will lessen greatly.


One thing more is worth noticing in the Commons, and that is a sort of sept representation. Thus we see **O'Neills** in Antrim, Tyrone, and Armagh; **Magennises** in Down; **O'Reilly**s in Cavan; **Martin**s, **Blakes**, **Kirwans**, **Dalys**, **Bourkes** for Connaught; **MacCarthys**, **O'Briens**, **O'Donovans** for Cork and Clare; **Farrells** for Longford; **Graces**, **Purcells**, **Butlers**, **Welshs**, **Fitzgeralds** for Tipperary, Kilkenny, Kildare, etc.; **O'Tooles**, **Byrnes**, and **Eustaces** for Wicklow; **MacMahons** for Monaghan; **Nugents**, **Bellews**, **Talbots**, etc., for North Leinster.


**Sir Richard Nagle**, the Speaker, was the descendant of an old Norman family (said to be the same as the **Nangles**) settled in Cork. His paternal castle, Carrignancurra, is on the edge of a steep rock, over the meadows of the Blackwater, half-a-dozen miles below Mallow. It is now the property of the **Foot family**, and here may still be seen the mouldering ruin where that subtle lawyer first learned to plan. Peacefully now look the long oak-clad cliffs on the happy river.


**Nagle** had obtained a splendid reputation at the Irish Bar. He had been educated among the Jesuits, and designed for a clergyman,’’

 says **King**, but afterwards betook himself to the study of the law, in which he arrived to a good perfection.’’ **Harris**, likewise, calls him an artful lawyer of great parts.’’ **Tyrconnell** valued him rightly, and brought him to England with him in the autumn of 1686. His reputation seems to have been great, for it


---

p.32






seems the lords interested in the Settlement Act, on being informed of **Nagle**'s arrival, were so transported with rage that they would have had him immediately sent out of London.’’
He was knighted, and made attorney-general in 1687; and on **James**'s arrival, March, 1688-9, he was made secretary of state. He is said, we know not how truly, to have drafted the Commons' bill for the repeal of the Settlement.


Let us mention some of the members. — **Nagle**'s colleague in Cork was **Colonel MacCarty , afterwards Lord Mountcashel**. **Miles de Courcy, afterwards Lord Kinsale**. **MacCarty Reagh**, who finally settled in France. His descendant, **Count MacCarty Reagh**, was notable for having one of the finest libraries in Europe, which was sold after the Revolution.


The **Rt. Hon. Simon Lutteral** raised a dragoon regiment for **James**, and afterwards commanded the Queen's regiment of infantry in the Brigade. He was father to **ColonelHenry Lutteral**, accused of having betrayed the passage of the Shannon at Limerick; and though **Harris** throws doubt on this particular act of treason, his correspondence and rewards from **William** seem sufficient proof and confirmation of his guilt.


**Lally of Tullendaly**, member for Tuam, was the representative of the **O'Lallys**, an old Irish sept. His brother, **John Gerard Lally**, settled in France, and married a sister to **Dillon, colonel propriétaire in the Brigade**, and was Colonel commanding in this illustrious regiment. **Sir Gerard** was father to the famous **Count Thomas Lally Tollendal**, who, after having served from the age of twelve to sixty-four in every quarter of the globe, from Barcelona to Dettingen, and from Fontenoy to Pondicherry, was beheaded on the 9th of May, 1766. The **Marquis De Lally Tollendal** , a distinguished lawyer and statesman of the


---

p.33






Bourbonist party, and writer of the life of **Strafford**, and many other works, was a grand-nephew to **James Lally** , the member for Tuam in '89.


**Colonel Roger Mac Elligot** , who commanded **Lord Clancarty**'s regiment (the 12th infantry) in the Brigade, was member for Ardfert.


Limerick. — **Sir John Fitzgerald was col. propr.** of the regiment of Limerick (8th infantry) in the Brigade.


**Oliver O'Gara, member for Tulske, was Lieutenant-Colonel** of the guards under **Colonel Dorrington** .


**Hugh Mac Mahon** , **Gordon O'Nial**'s Lieutenant-Colonel, was member for Monaghan.


The **Right Hon. Nicholas Purcell**, member for Tipperary, was a Privy Councillor early in **James**'s reign. His family were Barons of Loughmoe, and of great consideration in those parts.


The first bill introduced into the Lords was on the 8th of May — that for the recognition of the king — and the same day committees of grievance were appointed.




---

p.34


THE SESSION
-----------


IT is needless for us to track the parliament through the debates of the session, which lasted till the 20th July. The few acts (thirty-five), passed in two months, received full and earnest discussion; committees and counsel were heard on many of them (the Acts for repealing the Settlement in particular), and this parliament refused even to adjourn during any holiday.


We trust our readers will deal like searchers for truth, not like polemics, with these documents, and with the history of these times. But, above all, let them not approach the subject unless it be in a spirit enlightened by philosophy and warmed by charity. Thus studied, this time, which has been the armoury of faction, may become the temple of reconciliation. The descendant of the Williamite ought to sympathise with the urgent patriotism and loyalty of the parliament, rather than dwell on its errors, or on the sufferings which civil war inflicted on his forefathers. The heir of the Jacobite may well be proud of such countrymen as the Inniskilliners and the **Prentice Boys** of Derry. Both must deplore that the falsehoods, corruption, and forgeries of English aristocrats, the imprudence of an English king, and the fickleness of the English people placed the noble cavalry which slew **Schomberg**, and all but beat **William**'s immense masses at the Boyne, in opposition to the stout men of *Butlersbridge* and Cavan. What had not the defenders of Derry and Limerick, the heroes of Athlone, Inniskillen, and Aughrim done, had they cordially joined against the alien? Let the Roman Catholics, crushed by the **Penal Code**, let the Protestants,


---

p.35






impoverished and insulted by England, till, musket in hand and with banners displayed, they forced their rights from her in '82 — let both look narrowly at the causes of those intestine feuds, which have prostrated both in turn before the stranger, and see whether much may not be said for both sides, and whether half of what each calls crime in the other is not his own distrust or his neighbour's ignorance. Knowledge, Charity, and Patriotism are the only powers which can loose this Prometheus-land. Let us seek them daily in our own hearts and conversation.


The Acts and other official documents of **James**'s Parliament were ordered by **William**'s Parliament to be burned, and became extremely scarce. In 1740 they were printed in Dublin by **Ebenezer Rider**, and from that collection we propose to reprint the most important of them, as the best and most solid answer to misrepresentation.


The Parliament which passed those Acts was the first and the last which ever sat in Ireland since the English invasion, possessed of national authority, and complete in all its parts. The king, by law and in fact — the king who, by his Scottish descent, his creed, and his misfortunes, was dear (mistakenly or not) to the majority of the then people of Ireland — presided in person over that Parliament. The peerage consisted of the best blood, Milesian and Norman, of great wealth and of various creeds. The Commons represented the Irish septs, the Danish towns, and the Anglo-Irish counties and boroughs. No Parliament of equal rank, from King to Commons, sat here since; none sat here before or since so national in composition and conduct.


Standing between two dynasties — endangering the one, and almost rescuing the other — acting for a nation entirely unchained then for the first time in 500 years — this Parliament and its Acts ought to possess the very greatest interest for the historian and the patriot.




---

p.36


This was the speech with which his Majesty opened the Session: —


My Lords and Gentlemen, 



THE Exemplary Loyalty which this Nation hath expressed to me, at a time when others of my Subjects undutifully misbehaved themselves to me, or so basely deserted me: And your seconding my Deputy, as you did, in His Firm and Resolute asserting my Right, in preserving this Kingdom for me, and putting it in a Posture of Defence; made me resolve to come to you, and to venture my life with you, in the defence of your Liberties, and my Own Right. And to my great Satisfaction I have not only found you ready to serve me, but that your Courage has equalled your Zeal.’’


I have always been for Liberty of Conscience, and against invading any Man's Property; having still in my Mind that Saying in Holy Writ, Do as you would be done to, for that is the Law and the Prophets.’’


It was this Liberty of Conscience I gave, which my Enemies both Abroad and at Home dreaded; especially when they saw that I was resolved to have it Established by Law in all my Dominions, and made them set themselves up against me, though for different Reasons. Seeing that if I had once settled it, My people (in the Opinion of the One) would have been too happy; and I (in the Opinion of the Other) too great.’’


This Argument was made use of, to persuade their own People to *join* with them, and to many of my Subjects to use me as they have done. But nothing shall ever persuade me to change my Mind as to that; and wheresoever I am the Master, I design (God willing) to Establish it by Law; and have no other Test or Distinction but that of Loyalty. I expect your Concurrence in so Christian a Work, and 


---

p.37






in making Laws against Prophaneness and all Sorts of Debauchery.’’


I shall also most readily consent to the making such Good and Wholesome Laws as may be for the general Good of the Nation, the Improvement of Trade, and the relieving of such as have been injured by the late Acts of Settlement, as far forth as may be consistent with Reason, Justice, and the *Public* Good of my People.’’


And as I shall do my Part to make you Happy and Rich, I make no Doubt of your Assistance; by enabling me to oppose the unjust Designs of my Enemies, and to make this Nation flourish.’’


And to encourage you the more to it, you know with what Ardour and Generosity and Kindness the Most Christian King gave a secure retreat to the Queen, my Son, and Myself, when we were forced out of England, and came to seek for Protection and Safety in his Dominions; how he embraced my Interest, and gave me such Supplies of all Sorts as enabled me to come to you; which, without his obliging Assistance, I could not have done: This he did at a Time when he had so many and so considerable Enemies to deal with: and you see still continues to do.’’


I shall conclude as I have begun, and assure you I am as sensible as you can desire of the signal Loyalty you have expressed to me; and shall make it my chief study (as it always has been) to make you and all my Subjects happy.’’


 These were the Acts of that memorable parliament.
### Chapter I: An Act of Recognition.



### Chapter II: An Act for Annulling and making Void all Patents of Officers for Life, or during good Behaviour.





---

p.38


### Chapter III: An Act declaring, That the Parliament of England cannot bind Ireland [and] against Writs of Error and Appeals, to be brought for Removing Judgments, Decrees, and Sentences given in Ireland, into England.



### Chapter IV: An Act for Repealing the Acts of Settlement, and Explanation, Resolution of Doubts and all Grants, Patents and Certificates, pursuant to them or any of them. [This Act will be dealt with separately in the next chapter.]



### Chapter V: An Act for punishing of persons who bring in counterfeit Coin of foreign Realms being current in this Realm, or counterfeit the same within this Realm, or wash, clip, file, or lighten the same.



### Chapter VI: An Act for taking off all Incapacities on the Natives of this Kingdom.



### Chapter VII: An Act for taking away the Benefits of the Clergy in certain Cases of Felony in this Kingdom for two Years.



### Chapter VIII: An Act to continue two Acts made to prevent Delays in Execution; and to prevent Arrests of Judgments and Superseding Executions.



### Chapter IX: An Act for Repealing a Statute, *Entitled*, An Act for Provision of Ministers in Cities and Corporate Towns, and making the Church of St. Andrews in the Suburbs of [the city of] Dublin Presentative for ever.





---

p.39


### Chapter X: An Act of Supply for his Majesty for the Support of his Army.


[The Act of Supply begins by giving good reasons for the making of it; namely, that the army cost far more than the king's revenue, and that that army was rendered necessary from the invasion of Ireland by the English rebels. It next grants the king £20,000 a month, to be raised by a land-tax, and this sum it distributes on the different counties and counties of towns, according to their abilities. The rebellious counties of Fermanagh and Derry are taxed just as lightly as if they were loyal. The names of the commissioners are, beyond doubt, those of the first men in their respective counties. The rank of the country was as palpably on **James**'s side as was the populace.


The clauses regarding the tenants are remarkably clear and liberal: For as much,’’

 it says, as it would be hard that the tenants should bear any proportion of the said sum, considering that it is very difficult for the tenant to pay his rent in these distracted times,’’ it goes on to provide that the tax shall, in the first instance, be paid by the occupier, but that, where land is let at its value, he shall be ALLOWED THE WHOLE OF THE TAX OUT OF HIS RENT, notwithstanding any contract to the contrary; and that where the land was let at half its value or less, then, and then only, should the tenant pay a share (half) of the tax. Thus not only rack-rented farms, but all let at any rent, no matter how little, over half the value, were free of this tax. Where, in distracted or quiet times, since, has a parliament of landlords in England or Ireland acted with equal liberality?
The £20,000 a month hereby granted was altogether insufficient for the war; and **James**, urged by the military exigency, which did not tolerate the delay of calling a parliament when **Schomberg** threatened the capital, issued


---

p.40






a commission on the 10th April, 1690, to raise £20,000 a month additional; yet so far was even this from meeting his wants, that we find by one of **Tyrconnell**'s letters to the queen (quoted in Thorpe's catalogue for 1836), that in the spring of 1689, **James**'s expenses were £100,000 a month. Those who have censured this additional levy and the brass coinage were jealous of what was done towards fighting the battle of Ireland, or forgot that levies by the crown and alterations of the coin had been practised by every government in Europe.]




---

p.39


### Chapter XI: An Act for Repealing the Act for keeping and celebrating the 23rd of October as an Anniversary Thanksgiving in this Kingdom.



### Chapter XII: An Act for Liberty of Conscience, and Repealing such Acts or Clauses in any Act of Parliament which are inconsistent with the same.



### An Act concerning Tythes and other Ecclesiastical Duties.


*Acts XIII. and XV. provide for the payment of tithes by Protestants to the Protestant Church and by Catholics to the Catholic Church.*


### Chapter XIV: An Act regulating Tythes, and other Ecclesiastical Duties in the Province of Ulster.



### Chapter XVI: An Act for Repealing the Act for real Union and Division of Parishes, and concerning Churches, Free-Schools and Exchanges.



### Chapter XVII: An Act for Relief and Release of poor distressed Prisoners for Debts.





---

p.41


### Chapter XVIII: An Act for the Repealing an Act, *Entitled*, An Act for Confirmation of Letters Patent Granted to his Grace **James Duke of Ormond**.


[The list of estates granted to **Ormond**, under the settlement at the restoration, occupies a page and a half of Cox's Magazine. To reduce him to his hereditary principalities (for they were no less) which he held in 1641, was no great grievance, and that was the object of this Act.]


### Chapter XIX: An Act for Encouragement of Strangers and others to inhabit and plant in the Kingdom of Ireland.



### Chapter XX: An Act for Prevention of Frauds and Perjuries.



### Chapter XXI: An Act for Prohibiting the Importation of English, Scotch, or Welch Coals into this Kingdom.



### Chapter XXII: An Act for ratifying and confirming Deeds and Settlements and last Wills and Testaments of Persons out of Possession.



### Chapter XXIII: An Act for the speedy Recovering of Servants' Wages.



### Chapter XXIV: An Act for Forfeiting and Vesting in His Majesty the Goods of Absentees.



### Chapter XXV: An Act concerning Martial Law.





---

p.42


### Chapter XXVI: An Act for Punishment of Waste committed on Land restorable to old Proprietors.



### Chapter XXVII: An Act to enable his Majesty to regulate the Duties of Foreign Commodities.



### Chapter XXVIII: An Act for the better settling Intestates' Estates.



### Chapter XXIX: An Act for the Advance and Improvement of Trade, and for Encouragement and increase of Shipping, and Navigation.



### Chapter XXX: An Act for the Attainder of Divers Rebels, and for the Preserving the Interest of Loyal Subjects. — (Dealt with in our sixth chapter.)



### Chapter XXXI: An Act for granting and confirming unto the Duke of *Tyrconnell*, Lands and Tenements to the Value of £15,000 per annum.



### Chapter XXX: An Act for the Attainder of *diverse* Rebels, and for the Preserving the Interest of Loyal Subjects. — (Dealt with in our sixth chapter.)



### Chapter XXXII: An Act for securing the Water-Course for the Castle and City of Dublin.



### Chapter XXXIII: An Act for relieving **Dame Anna Anna Sarracourt, alias Duval**, and her Daughter.



### Chapter XXXIV: An Act for securing Iron-works and Land thereunto belonging, on **Sir Henry Waddington**, Knight, at a certain Rate.



### Chapter XXXV: An Act for Reversal of the Attainder of **William Ryan** of Bally Ryan in the County of Tipperary, Esq.; and for restoring him to his Blood, corrupted by the said Attainder.





---

p.43


Repeal of the Act of Settlement
-------------------------------


IT appears from the Journal of the proceedings of the parliament, and from many other authorities, that no act of the Irish Parliament of 1689 received such full consideration as the following. Two bills were brought in for the purpose of repealing the acts of settlement — that into the House of Lords, on May 13, by **Chief Justice Nugent**; that into the House of Commons by **Lord Riverstown** and **Colonel MacCarthy**. Committees sat to inquire into the effects of the bills; many memorials were read and considered; counsel were heard, both generally on the bills and on their effects on individuals; the debates were long, and it was not till after several conferences between the two houses that the act passed. The act was deliberately and maturely considered.


The titles and some of the effects of the acts of settlement are given in the preamble to the following statute. The effect of those acts of settlement had been, in a great degree, to confirm the unprincipled distribution of Irish property, made by **Cromwell**'s government, amongst those who had served it best, or, what meant nearly the same thing, who had most injured the Irish. The acts of settlement gave legality to a revolution which transferred the lands of the natives to military colonists. The repeal of those acts, within 24 years after they passed, and within about 37 years after that revolution took place, cannot excite much surprise. The one-third of their holdings (which the Cromwellian soldiers were obliged by the acts of the settlement to give up) could not have made a fund to reprize those who had been ousted from the entire.


---

p.44






However, the giving up of that one-third was not strictly enforced, and the stock resulting was wasted by commissioners, and distributed as the applicants had interest at court, not as they had title to the lands. Thus, **Lord Ormond** got some *hundred thousand* acres; albeit he had done more substantial injury to the Irish, and to the royalist cause in which they foolishly embarked, than any of the parliamentarians, from **Coote** to **Ireton**. Under such circumstances, we are not exaggerating the effect of the acts of settlement, passed after the Restoration, in saying, that they confirmed by law the Cromwellian robbery. The testimony of all the credible writers of the time goes to the same effect. Indeed, the repeal of the acts of settlement would have been against the interests of the natives, if they had received justice from those acts. This, in itself, is sufficient to prove how much hardship they had caused. The repeal of those acts by the Irish, as soon as they were in power, seems natural, considering how great and how recent was the injury they inflicted. Still, as we said, 24 years had passed since those acts had become law Many persons had got possession of properties under that law, and many of those properties had, doubtless, been sold, leased, subdivided, improved, and incumbered, upon the faith of that law. It might be urged that persons interested by such means in these properties had become so with full knowledge that they had been acquired by violence and injustice, and that the original owners and their families were in existence, ready and resolved to take their first opportunity of regaining their rights. Such reasoning fixes all who had advanced money, made purchases, or become in any wise interested under the acts of settlement, with such injustice and imprudence as to diminish their claim for compensation upon the repeal of those acts. But it only diminished, it did not destroy that claim. All those persons reposed some confidence in the security of the


---

p.45






then existing government; and many of them found a justification for the Cromwellian conquest, in the conduct of the Irish, as the well-sustained falsehoods of the English describe it.


For these reasons, **Chief Justice Keating** prepared a long memorial, which **Lord Forbes, Granard** , presented to the king, during the discussions on the bills, in May, 1689, setting forth the claims of those who came in under the acts of settlement, as incumbrancers, purchasers, tenants, by marriage, etc. This memorial is dishonestly represented by the Whig writers, as directed against the repeal altogether; but any one who reads it (which he can do in the appendix to **Harris**'s life of **William**) will find that it is an argument in favour of the classes described in the last sentence. From the long and careful clauses in the following act, for the reprisal and compensation of those classes, we must infer that **Keating**'s memorial produced its intended effect. However, these clauses require to be carefully examined, to see whether they carry out this principle of compensation fairly and impartially. The character of this parliament for moderation depends greatly on their doings in this respect.


We now come to a second class, the Irish who, having been given the alternative of ‘Hell or Connaught’ (as a certain bishop was of Heaven or Dungarvan), preferred the latter, and were located on the lands of the Connaught people. This class would generally come in for their old holdings in the other provinces, and required no compensation; but the distribution, under this act, of the incumbrances, etc., between them and the owners of their former and present lands, seems lawyer-like and reasonable.


The next great class are the ‘adventurers,’ those who got lands during the Commonwealth, and whose holdings were confirmed by the settlement. Their claim was boldly and ably urged by **Anthony Dopping, bishop 


---

p.46






of Meath**. His speech on the **Repeal Bill** is given in **King**'s appendix, and is worth reading. He bases their claim upon the supposition of the Irish having been bloody rebels, rightly punished by the giving of their lands to their loyal conquerors. His speech gives the genuine opinion of the English at the time. The preamble to the following act, and that to the Commons' bill, give the Irish view of the war. These documents deny that the bulk of the Irish were engaged in the conspiracy of 1641; and the denial is true, although it is also true that more than a ‘few indigent persons’ engaged in it, as is plain from **LordMaguire** 's narrative; and although it might have more become this Irish parliament to proclaim the absolute justice of the rising of 1641, on account of the sufferings of all ranks of Irish, in property and in political and religious rights; while they might have lamented that English atrocities had led to a cruel retaliation, though one infinitely less than it has been represented. However, the parliament, probably from delicacy to the king, based the rights of the Irish upon the peace of 1684, and the Restoration as restoring them to their loyalty, and to the properties possessed in 1641.


Most fair inquirers will allow the justice of this restoration of the Irish; but will lament that the act before us contains no provision for the families of those adventurers, who, however guilty when they came into the country, had been in it for from thirty to forty years, and had time and some citizenship in their favour. There had been sound policy in that too, but it was not done; and though the open hostility of most of those adventurers to the government — though the wants and urgency of the old proprietors, added to a lively recollection of the horrors which thronged about their advent, may be urged in favour of leaving them to work out their own livelihood by hard industry, or to return to England, we cannot be quite


---

p.47






reconciled to the wisdom of the course. Yet, let any one who finds himself eager to condemn the Irish Parliament on this account read over the facts that led to it, namely: the conquest of Leinster before the Reformation; the settlements of Munster and Ulster, under **Elizabeth** and **James**; the governments of **Strafford**, and **Parsons**, and **Borlace**; **Cromwell**'s and **Ireton**'s conquest; the effects of the acts of settlement, and the false-plot reign of **Charles** II.; let them, we say, read these, and be at least moderate in censuring the Parliament of 1689.


The Preamble to the Act of Repeal of the Acts of Settlement and Explanation, etc., as it passed the House of Commons.[23](javascript:footNote('E800002-045/note023.html'))


Whereas the Ambition and Avarice of the Lords Justices ruling over this your Kingdom, in 1641, did engage them to gather a malignant Party and Cabal of the then Privy Council contrary to their sworn Faith and natural Allegiance, in a secret Intelligence and traitorous Combination, with the Puritan Sectaries in the Realm of Great Britain, against their lawful and undoubted Sovereign, his Peace, Crown, and Dignity, the Malice of which made it soon manifest in the Nature and Tendency of their Proceedings; their untimely Prorogations of a loyal unanimous Parliament, and thereby making void, and disappointing the Effects of many seasonable Votes, Bills, and Addresses which, passed into Laws, had certainly secured the Peace and Tranquility of this Kingdom, by binding to his Majesty the Hearts of his Irish Subjects, as well by the *Ties* of Affection and Gratitude, as Duty and Allegiance there. The said Lords Justices traitorously disbanding his Majesty's well assured *Catholic* Forces, when his Person and Monarchy were exposed to the said Rebel Sectaries, then marching in hostile Arms to dispoil


---

p.48






him of his Power, Dominion, and Life; their immediate calling into the Place and Stead of those his Majesty's faithful disbanded Forces, a formidable Body of disciplined Troops allied and confederated in Cause, Nation and Principles with those Rebel Sectaries; their unwarrantable Entertainment of those Troops in this Kingdom, to the draining of his Majesty's Treasury, and Terror of his *Catholic* Subjects, then openly menaced by them the aforesaid Lords Justices with a Massacre and total Extirpation, their bloody Prosecution of that Menace, in the Slaughter of many innocent Persons, thereby *frightening* and compelling others in despair of Protection, from their Government, to unite and take Arms for their necessary Defence, and Preservation of their Lives; their unpardonable Prevarication from his Majesty's Orders to them, in retrenching the Time by him graciously given to his Subjects so compelled into Arms of returning to their Duty; and stinting the General Pardon to such only as had no Freehold Estates to make Forfeitures of; their pernicious Arts in way-laying, exchanging and wickedly depriving all Intercourse by Letters, Expresses, and other Communications and Privity *between* your said Royal Father and his much abused People; their insolent and barbarous Application of Racks and other Engines of Torture to **Sir John Read**, his then Majesty's sworn menial Servant, and that upon their own conscience Suspicions of his being intrusted with the too just Complaints of the persecuted *Catholic* aforesaid; their diabolical Malice and Craft, in essaying by Promises and Threats, to draw from him, the said **Read**, in his Torments, a false and impious Accusation of his Master and Sovereign as being the Author and Promoter of the then Commotion, so manifestly procured, and by themselves industriously spread.


And whereas a late eminent Minister of State, for parallel


---

p.49






Causes and Ends, pursuing the Steps of the aforesaid Lords Justices, hath by his Interest and Power, cherished and supported a Fanatical Republican Party, which heretofore opposed, put to flight, and chased out of this your Kingdom of Ireland, the Royal Authority lodged in his Person, and to transfer the calamitous Consequences of his fatal Conduct from himself, upon your trusty Roman *Catholic* Subjects, to the Breach of *public* Faith solemnly given and proclaimed in the Name of our late Sovereign, interposed *between* them and his late Majesty's general Indulgence and Pardon, and wrought their Exclusion from that Indemnity in their Estates, which by the said *public* Faith is specially provided for, and since hath been extended to the most bloody and execrable Traitors, few only excepted by Name in all your Realms and Dominions. And further, to exclude from all Relief, and even Access of Admittance to Justice, to your said Irish *Catholic* People, and to secure to himself and his Posterity, his vast Share of their Spoils; he the said eminent Minister did against your sacred Brother's Royal Promise and Sanction aforesaid, advise and persuade his late Majesty to give, and accordingly obtained his Royal Assent to two several Acts. The one *entitled*, An Act for the better Execution of his Majesty's gracious Declaration for the Settlement of this Kingdom of Ireland, and Satisfaction of the several Interests of Adventurers, Soldiers, and other his Majesty's Subjects there. Which Act was so passed at a Parliament held in this Kingdom, in the 14th and 15th Years of his Reign. And the other, An Act *entitled*, An Act of Explanation, etc.


Which Act was passed in a Session of the Parliament held in this Kingdom, in the 17th and 18th Years of his Reign, most of the Members thereof being such, as forcibly possessed themselves of the Estates of your Catholic Subjects in this Kingdom, and were convened together


---

p.50






for the sole special Purpose of creating and granting to themselves and their Heirs, the Estates and Inheritances of this your Kingdom of Ireland, upon a scandalous, false Hypothesis, imputing the traitorous Design of some desperate, indigent Persons to seize your Majesty's Castle of Dublin, on the 23rd of October, 1641, to an universal Conspiracy of your *Catholic* Subjects, and applying the Estates and Persons thereby presumed to have forfeited, to the Use and Benefit of that Regicide Army, which brought that Kingdom from its due Subjection and Obedience to his Majesty, under the Peak and Tyranny of a bloody Usurper. An Act unnatural, or rather viperously destroying his late Majesty's gracious Declaration, from whence it had Birth, and its Clauses, Restorations and Uses, inverting the very fundamental Laws, as well of your Majesty's, as all other Christian Governments. An Act limiting and confining the Administration of Justice to a certain Term or Period of Time, and confirming the Patrimony of Innocents unheard, to the most exquisite *Traitors*, that now stand convict on Record; the Assigns and Trustees, even of the then deceased **Oliver Cromwell** himself, for whose Arrears, as General of the Regicide Army, special Provision is made at the Suit of his Pensioners. Now in regard the Acts above mentioned do in a florid and specious Preamble, contrary to the known Truth in Fact, comprehend all your Majesty's Roman *Catholic* Subjects of Ireland, in the Guilt of those few indigent Persons aforesaid, and on that Supposition alone, by the Clause immediately subsequent to that Preamble, vest all their Estates in his late Majesty, as a Royal Trustee, to the principal Use of those who deposed and *murdered* your Royal Father, and their lawful Sovereign. And furthermore, to the Ends that the Articles and Conditions granted in the Year 1648, by Authority from your Majesty's Royal Brother, then lodged in the **Marquess of Ormond**, may be


---

p.51






duly fulfilled and made good to your Majesty's present Irish *Catholic* Subjects, in all their Parts and Intentions, and that the several Properties and Estates in this Kingdom may be settled in their *ancient* Foundations, as they were on the 21st of October, 1641. And that all Persons may acquiesce and *rejoice* under an impartial Distribution of Justice, and sit peaceably down under his own Vine or Patrimony, to the abolishing all Distinction of Parties, Countries and Religions, and settling a perpetual Union and Concord of Duty, Affection, and Loyalty to your Majesty's Person and Government in the Hearts of your Subjects, Be it enacted, etc.


[Here follows the Act of Repeal.]




---

p.52


The Act of Attainder
--------------------



### An Act for the attainder of various rebels, and for preserving

the interests of loyal subjects.


The authenticity of this Act as printed by **Archbishop King** has been questioned, especially by **William Todd Jones** in 1793. But we believe its authenticity cannot be successfully contested. **Lesley**, in his Reply to **King**, makes no attempt to disprove its existence, but, on the contrary, alludes to it and applauds **James** for having opposed it. **King**, however, asserts that the Act was kept a secret; and that the persons attainted, or their friends, could not obtain a copy of it. For this **Jones** answers: —


But the fact (as stated by **King**) is impossible: conceive the absurdity; an act of parliament is smuggled, where? through two houses of lords and commons; of whom were they composed? of catholics crowded with protestants; though **Leland**, upon the authority of **King**, says there were but fourteen real protestants. Well, what did these two houses do? They voted and passed a secret act of attainder of 2,500 protestants, which was to lie-by privately in petto, to be brought forward at a proper time; unknown, unheard of, by all the protestant part of the kingdom, till peace was restored: and that, according to **King**, was to be deemed the proper time for a renewal of war and devastation, by its publication and execution, and the secret was to be closely kept from nearly 3,000 persons by the whole house of commons; by fifty-six peers, including primate **Boyle**, **Barry lord Barrymore**, **Angier lord Longford**, **Forbes, the incomparable lord Granard** (of whom more in my next continuation), **Parsons lord Ross** **Dopping bp. of Meath**, **Otway bp. of Ossory**, **Wetenhal bishop of Cork**, **Digby bishop of Limerick**, **Bermingham lord Athenry**, **St. Lawrence lord Howth**, **Mallon lord Glenmallon** , **Hamilton lord Strabane**, all protestants and many of them presbyterians, or rather puritans. It was kept close from 3,000 persons by all the privy council; by all


---

p.53






the clerks of parliament who engross and tack together bills, it was to be kept an entire secret from all the protestants without doors, by all the protestants within the gates of parliament; and this probable, wise politic expectation was entertained *by those Catholic peers and representatives,* who through the cloud of war, passion, and uncertainty, could exercise the more than human moderation in solemnly prescribing the narrow bounds of thirty-eight years to all enquirers after titles under the revived court of claims: by those peers and representatives, whose patriotism, political knowledge, and comprehensive minds instructed them *to declare the independence of the realm, the freedom of Irish trade, and the inestimable value of a marine* — Good God, that any man, woman I mean, after such *acknowledged, uncontroverted documents* of the wisdom and reach of mind of that parliament, could be induced to credit and to advance the forgeries of a vicar of Bray under a persecuting protestant administration, *for the wicked purpose of calumniating their memory, and defeating the efforts of their posterity for freedom.*’’


A secret conspiracy *by way of statute* against the lives of near three thousand people, appears in itself impracticable and fabulous; but that it should have been agitated *in open parliament*, and in the hearing of the protestant members, and yet expected to have been kept a secret from the protestants, by these protestant members, is childish and ridiculous. — In that parliament sat the venerable **lord Granard**, a protestant, and a constant adherent and companion of **King James** in Ireland — *This excellent nobleman had married a lady of presbyterian principles; was protector of the northern puritans; had humanely secreted their teachers from those severities which in England proved both odious and impolitic; and had gained them an annual pension £500 from government.’’*

 —(Leland, vol. 3, p. 490)

. It was this **lord Granard** to whom the assembled protestants of Ulster, by **colonel Hamilton of Tullymore**, who was sent to Dublin for the sole purpose, unanimously offered the command of their armed association, from their confidence in his protestant principles; but he told Mr. **Hamilton** *that he had lived loyal all his life, and would not depart from it in his old age; and he was resolved that no man should write rebel upon his gravestone.’’ —**Lesley**'s Reply. , pp. 79, 80.*
... Is it then likely that this man would be privy to a general protestant proscription, and not reveal it? — and it is probable that such a *secret conspiracy by way of statute* could pass the houses of commons, and lords, the privy council, and finally the king, and that it never should come to the knowledge of a peer of parliament, a favourite of the court, a resident in Dublin, and every day attendant in his place in the upper house?’’


The intrinsic improbability is well proved here, and would suffice to show **King**'s falsehood as to the secrecy of the act; but if further proof were needed, the authorities which prove the authenticity of the act utterly disprove the secrecy alleged by **King**. The act is well described, in 


---

p.54






the London Gazette of July 1 to 4, 1689, and the names are given in print, in a pamphlet licensed in London, the 2nd day of the year 1690 (March 26th, old style).


**Jones**'s statement as to

 the destruction of all papers relating to that parliament

 having been ordered, under a penalty of £500 and incapacity

 from office, is certain, and we give the clause *below:*


#### The clause for the destruction of the Records of the parliament of 1689, is in an act annulling the attainders and all acts of 1689.


*Be it enacted by the King's most excellent Majesty, by and with the advice and consent of the lords spiritual and temporal and commons in this present Parliament assembled, and by the authority of the same, that all and every the acts, or pretended acts, and the rolls whereon the said acts or pretended acts, and every of them, are recorded or engrossed, and all proceedings of what nature or kind soever had, made, done, or passed by the said persons lately so assembled at Dublin, pretending to be or calling themselves by the name of a Parliament, and also all writs issued in order to the calling of the said pretended Parliament, and returned into any office in this kingdom, and there remaining, and all the journals of the said pretended Parliament, and other books or writings in any wise relating thereunto, or to the holding thereof, shall, by the officers or persons in whose custody the same are, be brought before the lord deputy, or other chief governour or governours of this kingdom for the time being, at such time as the lord deputy, or other chief governour or governours for the time being shall appoint, at the council chamber in Dublin, and there shall be publicly and openly cancelled and utterly destroyed: and in case any officer or person in whose hands or custody the said acts and rolls or proceedings, or any of them, do or shall remain, shall wilfully neglect or refuse to produce the same, to the intent that the same may be cancelled and destroyed, according to the true intent of this act, every such person and officer shall be, and is hereby adjudged and declared to be from thenceforth incapable of any office or employment whatsoever, and shall forfeit and pay the sum of five hundred pounds, one-half thereof to his Majesty, and the other half to such person or persons that shall sue for the same by any action of debt, bill, plaint, or information, in any court of record whatsoever.’’*

 — 7 Will. III. Ir. c. 1.


**It is possible* an outline of some such bill might have been prepared by one of those hot-headed people of whom **James** had too many in his councils either for his safety or for his reputation, and they were chiefly *English*; and that such draft of a bill having been laid before *parliament*, that wise, patriotic and sagacious *body* did ameliorate and reduce it into **the statute for the revival of the court of claims**; a law so unparalleled from its moderation in its review of forfeitures, by going back to ***Cromwell**'s debentures exclusively;* a period of only thirty-eight years anterior to the date of their then sitting.’’*

**Burnet**'s Own times. 


*Such a *draft of a bill*, like our own protestant bill for the castration of Romish priests, *which did pass* here but was cushioned in England,[24](javascript:footNote('E800002-045/note024.html')) or like the threat of a bill for levelling popish chapels, which I myself heard made when I sat in the house of commons, such a draft of a bill, I say, might have been found among the baggage of the **Duke of *Tyrconnell***, of **Sir Richard Nagle**, or of the unfortunate sovereign himself, for **Burnet** acquaints us, that all ***Tyrconnell***'s papers were taken in the camp; and those of  **James** were found in Dublin.’’*

(**Burnet**'s Own Times. , Vol. 2nd, p. 30).

 but this clause was not enacted till 1695, and, therefore, could not have affected the acts of 1689, when **King** wrote in 1690.
Moreover, we cannot find any trace of **Richard Darling**


---

p.55






(who professedly made the **copia vera** for **King**) as clerk in the office of the **Master of the Rolls**, or in any office, in 1690. A **Richard Darling** was appointed secretary to the commissioners for the inspection of forfeitures, by patent dated 1st of June, 5 William III. (1693)


There certainly are grounds for supposing that some great jugglery, either as to the clauses or names in the act, was perpetrated by this well-paid and unscrupulous Williamite. The temptation to fabricate as much of the act (clauses or names) as possible was immense. The want of scruple to commit any fraud is plain upon **King**'s whole book. The likelihood of discovery alone would deter him. Probably every family who had a near relative in the 'list' would be secured to **William**'s interest, and no part of **King**'s work could have helped more than this act to make that book what **Burnet** called it, the best fitted to settle the minds’’

 of the people of England, of any of the books published on the Revolution.
The preamble states truly the rebellion of the northerns to dethrone their legitimate king, and bring in the Prince of Orange; and that the insurgents, though offered


---

p.56






full pardon in repeated proclamations, still continued in rebellion. It enacts that certain persons therein named, who had notoriously *joined* in the said rebellion and *invasion*,’’

 or been slain in rebellion, should be attainted of high treason, and suffer its penalties, *unless before the 10th of August following* (i.e., at least seven weeks from the passing of the act) they came and stood their trial for treason, according to law, when, if otherwise acquitted, the Act should not harm them. The number of persons in this clause vary in the different lists from 1,270 to 1,296.
It cannot be questioned that the persons here *conditionally* attainted were in arms to dethrone the hereditary sovereign, supported, as he was, by a regularly elected parliament, by a large army, by foreign alliances, and by the good-will of five-sixths of the people of Ireland. King he was **de jure** and **de facto**, and they sought to dethrone him, and to put a foreign prince on the throne. If ever there were rebels, they were.


As to their creed, there is no allusion to it. Roman Catholic and Protestant persons occur through the lists with common penalties denounced against both; but neither creed is named in it.


We do not say whether those attainted were right or wrong in their rebellion: but the certainty that they were rebels according to the law, constitution, and custom of this and most other nations, justified the Irish parliament in treating them as such; and should make all who sympathise with *these* rebels pause ere they condemn every other party on whom law or defeat have fixed that name. Yet even this attaint is but *conditional;* the parties had over seven weeks to surrender and take their trial, and the king could, at any time, for over four months after, grant them a pardon both as to persons and property — a pardon which, whether we consider his necessities and policy, his habitual leniency, or the repeated attempts to win back


---

p.57






his rebellious subjects by the offer of free pardon, we believe he would have refused to few. This, too, is certain, that it *has never been even alleged that one single person suffered death under this much talked of Act.* Of the constitutional character of the Act, more presently.


The second article attaints persons who had absented themselves since or shortly before’’

 the 5th November, 1688, unless they return before the 1st of September, that is, in about ten weeks. Staying in England certainly looked like adhesion to the invader, yet the mere difficulty of coming over during the war should surely have been considered.
The third attaint is of persons absent before (some time probably before) 5th November, 1688, unless they return before the 1st October, that is, within about fourteen weeks.


Moreover, a certain number of the persons named in this conditional attaint are excepted from it specially, by a following clause, unless the king should go to England (their usual residence) before 1st October, 1689, and that after his arrival they should neglect to signify their loyalty to the satisfaction of his Majesty.


Yet **Harris** and The List licensed 26th March, 1690, have the audacity to *add* these English residents and make another list of attainted persons, *instead of deducting* them from the list under clause 3.


With similar want of faith, both these writers make out a fifth list of attaints of the persons explicitly not attainted, but whose *rents* are forfeited by sec. 8, so long as they continue absentees. Thus, two out of the five lists, by adding which **Harris** makes up his 2,461 attaints, are not lists of attainders at all, and one of them should be rather deducted from one of the three lists of real attaints. **Harris** has under this exception for English residents 547 names (though printed 647 in totting), and were we to deduct


---

p.58






these and the fifth list of 85 persons, his number of attaints would fall to 1,829; though he himself confesses that there must be some small drawback for persons attainted twice under different descriptions; and though his own totting, without removing either the fourth or fifth list, is only 2,461, yet in his text he says, about 2,600’’

 were attainted.

Yet **Harris** and The List pamphlet, which give the names in schedules, were more likely to misplace the lists than **King**, and he certainly did so in reference to the fourth list.
***King**'s first list, like the rest, contains 1,280 names, his second 455, and his third 197, amounting to 1,932. By deducting the 59 names in list 4, King's list falls to 1,873.*[25](javascript:footNote('E800002-045/note025.html')) Yet even in this many are attainted twice over.


**Harris**'s second list and The List's third list, each of 79 names, should be under title 4, namely, English residents, containing 59 in **King**. **Harris**'s third list of 454 names should be second, namely, Absentees since 5th November, containing in **King** 455, and in The List 480 names. **Harris**'s fourth list of 547, and The List's fourth list of 528 names, should go to No. 3 in **King**, containing only 197 names, viz., of persons absent before 5th November. Without making these corrections, we would have the conditional attaints, under clauses 1, 2, and 3, amount in The List to 1,311, in **Harris** to 1,282, and in **King** to 1,873. But if we make these corrections, **King**'s will remain at 1,873, **Harris**'s rise to 2,218, and The List to 2,209.


It would, we think, puzzle **La Place** to calculate the


---

p.59






probability of any particular name being authentic amid this wilderness of inaccuracies.


The fifth class of 85 persons are, as we said, *not attainted at all*. The 8th section declares them to be absent from nonage, infirmity, etc., and denounces no penalty against their persons, but it being much to the weakening and impoverishing of this Realm, that any of the Rents or Profits of the Lands, Tenements, of Hereditaments thereof should be sent into or spent in any other place beyond the seas, but that the same should be kept and employed within the Realm for the better support and defence thereof,’’

 it vests the properties of these absentees in the King, until such time as these absentees return and apply by petition to the Chancery or Exchequer for their restoration. Harder penalties for absenteeism were enacted repeatedly before, and considering the necessities of Ireland in that awful struggle, this provision seems just, mild, and proper.
By the fourth section, all the goods and properties of *all* the first four classes of absentees were also vested in the King till their return, acquittal, pardon or discharge. By the 5th and 6th sections, remainders and reversions to innocent persons after any estate for lives forfeited by the Act, are saved and preserved, provided (by the 7th section) claims to them are made within 60 days after the first sitting of the Court of Claims under the Act. But remainders in settlements, of which the uses could be changed, or where the lands were ‘plantation’ lands, etc., were not saved. Whether such a Court of Claims ever sat is at least doubtful.


By the 9th and 11th sections, the rights and incumbrances of non-forfeiting persons over the forfeited estates are saved, provided (by section 12) their claims are made, as in case of remainder-men, etc.


The 10th section makes void **Lord Strafford**'s abominable ‘offices’, or confiscations of Connaught, Clare, Limerick,


---

p.60






and Tipperary, and confirms the titles of the right owners, as if these offices had not been found.


The 13th section repeals a private act for conferring vast estates on **Lord Albemarle** out of the forfeitures on the Restoration.


The remaining clauses, except the last, have nothing to do with the Attainders. They are subsidiary to the Act repealing the Acts of Settlement and Explanation. They reprize ancient proprietors, who had bought or taken leases of their own estates from the owners under the Settlement Acts.


The 17th section provides for the completion of the Down or Strafford Survey, and for the reduction of excessive quit rents. In this section the phrase occurs, ‘their Majesties,’ but this is probably a mistake in printing, though a crotchety reasoner might find in it a doubt of the authenticity of the Act.


The 21st and last section provides that any of the persons attainted who shall return to their duty and loyalty’’

 may be pardoned by royal warrant, provided that such pardon be issued before the first day of November next, otherwise the pardon to be of no effect.’’


---

p.61


Conclusion
----------


Let us now run our eyes ever the deeds of the Feis or Parliament of 1689. It came into power at the end of a half century of which the beginning was a civil and religious, social and proprietal persecution, combining all the atrocities to which Ireland had been alternatively subject for four centuries and a half. Of this, the next stage was a partial insurrection, rendered universal by a bloody and rapacious government. The next stage was a war, in which civil and religious quarrels were so fiendishly combined that it could not end while there was any one to fight with; in which the royalist dignitaries were the cruelest foes of the royalist armies and people, and in which the services done by cool and patriot soldiers were rendered useless by factious theologians. The next stage was conquest, slaughter, exile, confiscation, and the repose of solitude or of slavery. The next was a Restoration which gave back its worst prerogatives to the crown, but gave the restorers and royalists only a skirt of their properties. Then came a struggle for proprietal justice and religious toleration, met by an infamous conspiracy of the deceptious aristocracy and the fanatic people of England, to blast the characters of the Irish, and decimate the men; and lastly, a king, who strained his prerogative to do them justice, is driven from England by a Dutchman, supported by blue guards, black guards, and flaming lies, and is forced to throw himself on the generosity and prudence of Ireland.


A faction existed who raised a civil war in every province;


---

p.62






and in every province, save one, it was suppressed; but in that one it continued, and the sails of an invading fleet already flap in the Channel breeze when this parliament is summoned.


How difficult was their position! How could they act as freemen, without appearing ungenerous to a refugee and benefactor king? How guard their nationality, without quarrelling with him or alienating England from him? How could they do that proprietal justice and grant that religious liberty for which the country had been struggling? How check civil war — how sustain a war by the resources of a distracted country? Yet all this the Irish parliament did, and more too; for they established the principal parts of a code needful for the *permanent* liberty and prosperity of Ireland.


Take up the list of acts passed in their session of seventy-two days and run over them. They begin by recognising their lawful king who had thrown himself among them. They pledge themselves to him against his powerful foe. Knowing full well the struggle that was before them, and that lukewarm and malcontent agents might ruin them, they tossed aside those official claims, which in times of peace and safety should be sacred.


But their next act deserves more notice. It must not be forgotten that **Molyneux**'s Case of Ireland, which the parliaments of England and Ireland first burnt, and ended by declaring and enacting as sound law, was published in 1699, just ten years after this parliament of **James**'s. Doubtless the antique rights of the native Irish, the comparative independence of the Pale, the arguments of **Darcy**, the memory of the council of Kilkenny, might suggest to **Molyneux** those principles of independence, which one of his cast of mind would hardly reach by general reasoning. But why go so far back, and to so much less apt precedents? Here, in the parliament of 1689, was a law made declaring


---

p.63






Ireland to be and to have always been a distinct kingdom’’

 from England; always governed by his majesty and his predecessors according to the ancient customs, laws, and statutes thereof, and that the parliament of Ireland, and that *alone*, could make laws to bind this kingdom;’’ and expressly enacting and declaring that no law save such as the Irish parliament might make should bind Ireland. And this act prohibited all English jurisdiction in Ireland, and all appeals to the English peers or to any other court out of Ireland. Is not this the whole argument of **Molyneux**, the hope of **Swift** and **Lucas**, the attempt of **Flood**, the achievement of **Grattan** and the Volunteers? Is not this an epitome of the Protestant patriot attempts, from the Revolution to the Dungannon Convention? Is not this the soul of '82? Surely, if it be, as it is, just to track the stream of liberation back to **Molyneux**, we should not stop there; but when we find that a parliament which sat only ten years before his book was published, which must have been a daily subject of conversation — as it certainly was of written polemics — during those ten years; when we find this upper fountain so obviously streaming into the thought of **Molyneux**, should we not associate the parliament of 1689 with that of 1782, and place **Nagle** and **Rice** and its other ruling spirits along with **Floo**d and **Grattan** in our gratitude?
Moreover, the lords and commons expressly repealed ****Poyning**'s law**, and passed a bill creating Irish Inns of Court, and abolishing the rules for keeping terms in London. But the king rejected these. We are to this day without this benefit which the senate of '89 tried to give us; and the future advocates and judges of Ireland are hauled off to a foreign and dissolute capital to go through an idle and expensive ceremony, term after term, as an essential to being allowed to practise in the courts of this their native kingdom.




---

p.64


The Act (c. 4.) for restoring the ancient gentry to their possessions, we have already canvassed. It were monstrous to suppose the parliament ought to have respected the thirty-eight years' usurpation of savage invaders, and to have overlooked the rights of the national chieftains, the plundered proprietors who lived, and whose families lived, to claim their rights. The care with which purchasers and incumbrancers were to be reprized we have already noticed; yet we cannot but repeat our regret that the bill of the Lords (which left the adventurers of **Cromwell** a moiety of their usurpations) did not pass.


Naturally related to this are the Acts, c. 24, for vesting attainted absentees' goods in the King, and c. 30, attainting a number of insurgents. We have already shown from **King**, that the Whigs had taken good care of the two things forfeited — their chattels, which they had sent to them, without opposition, during the month of March, and their persons, which they put under the guard of the gallant insurgents of Derry and Fermanagh, or in the keeping of **William** and the charity of England. How poorly they were treated then in England may be guessed at by the choice men of the impoverished defenders of Derry having been left without money, aye, or even clothing or food in the streets of London.


We heartily censure this Attainder Act. It was the mistake of the Irish Parliament. It bound up the hearts and interests of those who were named in it, and of their children, in William's success. It could not be enforced: they were absent. It could not be terrible till victory sanctioned it, and then it would be needless and cruel to execute. Yet, let us judge the men rightly. James had been hunted out of England by lies, treachery, bigotry, cabal, and a Dutch invader, for having attempted to grant religious liberty, by his prerogative. Those attainted were, nine out of ten, in arms against him and their country.


---

p.65






They had been repeatedly offered free pardon. Just before the Act was brought in, a free pardon, excepting only ten persons, was offered, yet few of the insurgents came in; and James, instead of forbidding quarter, or hanging his prisoners, or any other of the acts of rigour usual in hereditary governments down to our own time, consented to an Act requiring the chief persons of the insurrection to come, in periods specified, and amply long enough, to stand their trials. Certain it is, as we said before, that though many of these were or became prisoners, none were executed. The Act was a dead letter; and considering the principles of the time, surely the Act was not wonderful.


In order, then, to judge them better, let us see what the other side — the immaculate Whigs, who assailed the Irish — did when they were in power. Of anything previous to the Revolution — of the treachery and blood, by law and without law, under the Plantagenets, Tudors, Stuarts, and the Commonwealth — 'tis needless to speak. But let us see what their neighbours, the Williamites, did.


The Irish Attainder Act was not brought in till the end of June. Now, this is of great value, for the dates of the last papers on Ireland, laid before the English Commons, having been 10th June, 1689, they, on the 20th June, ‘Resolved, that leave be given to bring in a **Bill** to attaint of high treason certain persons who are now in Ireland, or any other parts beyond the seas, adhearing to their Majesties' enemies, and shall not return into England by a certain day.’[26](javascript:footNote('E800002-045/note026.html'))




---

p.66


The very next entry is — A **Bill** for the attainting certain persons of high treason, was read the first time. ‘*Resolved*, that the **Bill** be read a second time.’


Here was a bill to attaint persons beyond seas in another kingdom where **William** had never been acknowledged — where **James** was welcomed by nine men out of ten — from whence, so far from being able to procure evidence or allow defence, they could but by accident get intelligence and reports once in some months. It is not here pretended that the attainted were habitual residents in England. The bill passed the second reading, and was committeed, June 22nd, with an instruction to the committee, That they insert into the bill such other of the persons as were this day *named in the house*, as they shall find cause.’’


Again, on the 24th — *Ordered*, that it be an instruction to the committee, to whom the bill for attainting certain persons is referred, that they prepare and bring in a clause for the immediate seizing the estates of such persons who are or shall be proved to be in arms with the late **King James** in Ireland, or in his service in France.’’

 On the 29th is another instruction to prepare and bring in a clause that the estates of the persons who are now in rebellion (!)


---

p.67






in Ireland be applied to the relief of the Irish Protestants fled into this realm; and also to declare all the proceedings of the pretended parliament and courts of justice, now held in Ireland, to be null and void;’’ the committee to sit de die in diem, till the bill be finished.’’
Up to this time they could not have known that any attainder act had been brought in in Ireland. On the 9th July, **Sergeant Trenchard** reported, That the committee had *proof*’’

 (we shall presently see of what kind) of several other persons being in Ireland in arms with **King James**, and therefore had agreed their names should be inserted in the bill.’’ Ordered, that the bill, so amended, be engrossed.’’ On the 11th July the bill passed, inserting *August*, 1689, instead of August next, and inserting some Christian names.
The bill reached the Lords.


Upon the 24th July a message was sent to the Lords urging the despatch of the bill. On the 2nd August, at a conference, the Lords required to know *on what evidence* the names were introduced as being in Ireland, for, upon their best inquiry, they say they cannot learn some of them have been there — they instanced the **Lord Hunsden**.’’

 On the 3rd of August, Mr. **Sergeant Trenchard** acquaints the house that the names of those who gave evidence at the bar of the house touching the persons who are named in the bill of attainder, being in Ireland, were **Bazill Purefoy** and **William Dalton** ; and those at the committee, to whom the bill was referred, were **William Watts** and **Math. Gun**; four persons, two and two giving the whole evidence for the attainder of those who stood by **King James** in Ireland! This report was handed to the Lords on the 5th August.
On the 20th August the Lords returned the bill, with some amendments, leaving out **Lord Hunsden** and four or


---

p.68






five more, and inserting a few others; and upon this day the parliament was prorogued.


Again, on the 30th October, a bill was ordered to attaint all such persons as were in rebellion against their Majesties. On the 26th November, certain members were ordered to prepare a bill attainting all who had been in arms against **William** and **Mary**, since 14*th February*, 1688-9, or any time since, and all who *have been,* or shall be, *aiding, assisting, or abetting* them. On the 10th December the bill was reported and read a first time, and the committee ordered to bring in a bill for sale of the estates forfeited thereby.


On the 4th April, 1690, another bill was ordered, and was read 22nd April.


Again, on 22nd October, another attainder and confiscation bill was brought and passed the Commons on the 23rd December.


Wearied at length by unsuccessful bills, which the better or more interested feeling of the Lords, or the policy of the King, perpetually defeated, they abandoned any further attainder bills, and merely advertized for money on the forfeited lands in Ireland.


The attainders in *court* might satisfy them. The commissioners of forfeitures, under 10 William III., c. 9, reported to the Commons on the 15th of December, 1699, that the persons outlawed for treason in Ireland since the 13th of February, 1688-9, on account of the late rebellion, were 3,921 in number. It was abominable for **James**'s parliament to attaint conditionally the rebels against the old king, but reasonable for the Whigs to attaint about double the number absolutely, for never having recognized the new king! These 3,921 had properties, says the report, to the amount of 1,060,792 plantation acres, worth £211,623 a year, and worth in money, £2,685,130, besides the several denominations in the said several counties to which no number of acres can be added, by reason of the imperfection


---

p.69






of the surveys not here valued.’’

 Of these 3,921, there were 491 restored under the first commission on the articles of Galway and Limerick; and 792 under the second commission, having joint properties of 233,106 acres, worth £55,763 a year, or £724,923 purchase, leaving 2,638 persons having 827,686 acres, worth £155,859 a year, or £1,960,206. Yet the fees were monstrous, says the commissioners, in these Courts of Claims, £5 being the register's fees for even *entering* a claim. **William** restored property to the amount of 74,733 acres, worth £20,066 per annum, or £260,863 in all, which would leave as absolutely forfeited property 752,953 acres, worth £135,793 a year, and £1,699,343 in all; and even were we to deduct in proportion, which we ought not, as those pardoned were chiefly the very wealthy few, there would remain over 2,400 persons attained by office, after deducting all who carved out their acquittal with shot and sword, and all whom the tenderness or wisdom of the king pardoned.
The commissioners state that £300,000 worth of chattels were seized, not included in the above estimate; nor were 297 houses in Dublin, 26 in Cork, 226 elsewhere, mills, chief rents, £60,000 worth of woods, etc., in it.


Most of these properties had been given away freely by **William**. Amongst his grants they specify all **King James**'s estates, over 95,000 acres, worth £25,995 a year, to **Mrs. Elizabeth Villiers, Countess of Orkney**. She was **William**'s favourite mistress. **James**, to his honour be it spoken, had thrown these estates into the general fund for reprisal of the injured Irish.


Here, then, is certainly not a justification of the Parliament of 1689, in passing the Attainder Act, but evidence from the journals of the English Parliament and the reports of their commissioners, that they tried to do worse than the Irish Parliament (under far greater excuses) are accused of having done, and that the actual amount of punishment


---

p.70






inflicted by the Williamite courts in Ireland far exceeded what the Irish Parliament of 1689 had conditionally threatened.


The next Acts as a class are c. 9, repealing ministers' money act; c. 12, granting perfect liberty of conscience to men of all creeds; c. 13, directing Roman Catholics to pay their tithes to their own priests; c. 14, on Ulster poundage; c. 15, appointing those tithes to the parish priests, and recognising as a Roman Catholic prelate no one but him whom the king under privy signet and sign manual should signify and recognize as such. All these acts went to create religious equality, certainly not the voluntary system; neither party approved of it then; but to make the Protestant support his own minister, and the Roman Catholic his own, without violation of conscience, or a shadow of supremacy. The low salaries (£100 to £200 a year) of the Roman Catholic prelates, and their exclusion from Parliament, were in the same moderate spirit.


Again, this Parliament introduced the Statute of Frauds (which, having been set aside, was not adopted until the 7th William III.); Acts for relief of poor debtors, for the speedy recovery of wages, and for ratifying wills and deeds by persons out of possession.


Chapter 21, forbidding the importation of foreign coals, was designed to render this country independent of English trade. At that time the bogs were larger and the people fewer. Their opinion that this importation which hindered the industry of several poor people and labourers who might have employed themselves’’

 in supplying the cities, etc., with turf, reminds us of **Mr. Laing**'s most able notice in his Norway of the immense employment to men, women, and children, by the cutting of firewood; and what a powerful means this is of doing that which is as important as the production of wealth, the diffusion of it without any great inequality through all classes. Part of


---

p.71






c. 29, encouraging trade, laying heavy import duties on English goods, and giving privileges to Irish ships over foreign, especially over English, was the result of sound, practical patriotism. It was necessary to guard our trade, manufactures, and shipping against the rivalry of a near, rich, and aspiring neighbour, that would crush them in their cradles. It was wise to raise the energies of infant adventure by favour, and not trust it in a reckless competition. The example, too, of all countries which had reared up commerce by their own favour and their neighbours' surrender of trade, would have justified them.
Besides the schools for the Navy under c. 29, c. 16 deals also with schools. We have not the latter Act; but, considering **James**'s known zeal for education, his foundation of the Kilkenny college, and the spirit of the provision in c. 29, we may guess the liberality of the other. One of the most distinguished of our living historians has told us that he remembered having seen evidence that this Act established a school for general (national) education in every parish in Ireland.


C. 10, the Act of Supply; c. 25, Martial Law, and this Act, c. 29, were a code of defence. The supply was proportioned to their abilities: every exertion was made, and all efforts were needed. **Plowden** puts the effect of this c. 29 not ill: — *Although **James** were averse from passing the acts I have already mentioned, he probably encouraged another which passed *for the advance and improvement of trade and for encouragement and increase of shipping and navigation,* which purported to throw open to Ireland a free and immediate trade with all our plantations and colonies; to promote ship-building, by remitting to the owners of Irish-built vessels large proportions of the duties of custom and excise, encourage seamen by exempting them for ten years from taxes, and allowing them the freedom of any city or seaport they should *choose* to reside in, and improve the Irish navy by estalishing free schools for teaching and instructing in the mathematics and the art of navigation, in Dublin, Belfast, Waterford, Cork, Limerick, and Galway. If **James** looked up to any probability of maintaining his ground in Ireland he must have been sensible of the necessity of an Irish navy. No man was better

 


---

p.72






qualified to judge of the utility of such institutions than this prince. He was an able seaman, fond of his profession; and to his industry and talent does the British navy owe many of its best signals and regulations. The firmness, resolution and enterprise which had distinguished him, whilst Duke of York, as a sea officer, abandoned him when king, both in the cabinet and the field.’’*


Thus, then, this Parliament exercised less severity than any of its time; it established liberty of conscience and equality of creeds; it proscribed no man for his religion — the word Protestant does not occur in any Act — (though, while it sat, the Westminster Convention was not only thundering out insults against ‘popery,’ but exciting **William** to persecute it, and laying the foundation of the penal code); it introduced many laws of great practical value in the business of society; it removed the disabilities of the natives, the scars of old fetters; it was generous to the king, yet carried its own opinions out against his where they differed; it, finally — and what should win the remembrance and veneration of Irishmen through all time — it boldly announced our national independence, in words which **Molyneux** shouted on to **Swift**, and **Swift** to **Lucas**Lucas, and **Lucas** to Flood, and Flood and **Grattan** redoubling the cry; Dungannon church rang, and Ireland was again a nation. Yet something it said escaped the hearing or surpassed the vigour of the last century; it said, ‘Irish commerce fostered,’ and it was faintly heard, but it said, ‘an Irish navy to shield our coasts,’ and it said, ‘an Irish army to scathe the invaders,’ and **Grattan** neglected both, and our coast had no guardian, and our desecrated fields knew no avenger.


We have printed the king's speech at the opening of this eventful parliament, the titles of all its Acts, and all the statutes summarized in full detail which we could in any way procure — sufficient, we think, with the scattered notices of the chief members, to make the working of this Parliament plain. We are conscious of many defects in our information and way of treating the subject; but we


---

p.73






commenced by avowing that we were not professors but students of Irish history; trying to come at some clear understanding on a most important part of it, communicating our difficulties and offering our solutions, as they occurred to us, in hopes that some of our countrymen would take up the same study, and do as much or more than we have done, and possibly that one of those accomplished historians, of which Ireland now has a few, would take the helm from us, and guide the ship himself.


We have no reason to suppose that we succeeded in either object; yet we cling to the belief that, owing to us, some few persons will for the future be found who will not allow the calumnies against our noble old Parliament of 1689 to pass uncontradicted. It might have been better, but this is well.


