

#The Irish Crisis


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Irish Crisis
================


Author: Charles Edward Trevelyan
--------------------------------


### File Description

Electronic edition compiled and proof corrections by Beatrix Färber 

Funded by The School of History 1. First draft, revised and corrected.Extent of text: 
43250 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E840001-002Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Further Reading**2. Jenifer Hart, 'Sir Charles Trevelyan at the Treasury', English Historical Review 75:294 (1960) 92–110.
3. F. D. Munsell, 'Charles Edward Trevelyan and Peelite Irish famine policy, 1845–6', Societas 1 (1971) 299–315.
4. Joseph M. Hernon, 'The historian as politican: G.O. Trevelyan as Irish Chief Secretary', Éire-Ireland 8:3 (1973) 3–15.
5. Joseph M. Hernon, 'A Victorian Cromwell: Sir Charles Trevelyan, the famine and the age of improvement', Éire-Ireland 22:3 (1987) 15–29.
6. Pat McGregor, '"Insufficient for the support of a family": wages on the Public Works during the Great Irish Famine', Economic & Social Review 35 (2004) 219–239.
7. Robin F. Haines, Charles Trevelyan and the Great Irish Famine (Dublin 2004).
8. Ciara Boylan, 'Victorian ideologies of improvement: Sir Charles Trevelyan in India and Ireland', in: Tadhg Foley, Maureen O'Connor (eds), Ireland and India: colonies, culture and empire (Dublin 2006).
9. Peter Gray, 'Charles Trevelyan', in: John Crowley, Mike Murphy, William J. Smyth (eds), Atlas of the Great Irish Famine, 1845–52 (Cork 2012) 85–86; 683.
10. Enda Delaney, The curse of reason: the Great Irish Famine (Dublin 2012).
**Internet Availability**2. The text is available in various formats at www.archive.org.
**The edition used in the digital edition**2. The Irish Crisis. Charles Edward Trevelyan First edition [201 pages] Longman, Brown, Green & Longmans London (1848)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 1–201 of the volume.


#### Editorial Declaration


##### Correction


Text proofread once at CELT.


##### Normalization


The electronic text represents the edited text. Some typographical errors have been rectified. The tables in the footnotes on p. 30 and 75 have been omitted, and some text in the footnote on p. 123 has been omitted too. For these, the reader is referred to the PDF versions on www.archive.org.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


The more important personal names, and titles of books and periodicals are tagged. Words and phrases from other languages are tagged.


### Profile Description


Created: By Charles Edward Trevelyan (1848) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [FR] Some words are in French.


### Revision History


* (2015-06) Beatrix Färber (ed.)

* Bibliographic details added. SGML and HTML files created.
* (2015-06) Beatrix Färber (ed.)

* Provisional header created; file parsed.
* (2015-06) Beatrix Färber (ed.)

* File proofed (1); structural and some content encoding added.
* (2015-06) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E840001-002


### The Irish Crisis: Author: Charles Edward Trevelyan




---

p.1


The time has not yet arrived at which any 
man can with confidence say, that he fully 
appreciates the nature and the bearings of 
that great event which will long be inseparably associated with the year just departed. Yet we think that we may render 
some service to the public by attempting 
thus early to review, with the calm temper 
of a future generation, the history of the 
great Irish famine of 1847[1](javascript:footNote('E840001-002/note001.html')). Unless we 
are much deceived, posterity will trace up 
to that famine the commencement of a 
salutary revolution in the habits of a nation 
long singularly unfortunate, and will acknowledge that on this, as on many other 
occasions, Supreme Wisdom has educed 
permanent good out of transient evil.




---

p.2


If, a few months ago, an enlightened man 
had been asked what he thought the most 
discouraging circumstance in the state of 
Ireland, we do not imagine that he would 
have pitched upon Absenteeism, or Protestant bigotry, or Roman Catholic bigotry, or 
Orangeism, or Ribbandism, or the Repeal 
cry, or even the system of threatening 
notices and midday assassinations. These 
things, he would have said, are evils; but 
some of them are curable; and others are 
merely symptomatic. They do not make 
the case desperate. But what hope is there 
for a nation which lives on potatoes?


The consequences of depending upon the 
potato as the principal article of popular 
food, had long been foreseen by thinking 
persons; and the following observations 
extracted from a paper on the native country of the wild potato[2](javascript:footNote('E840001-002/note002.html')), published in the 
 Transactions of the Horticultural Society of 
London for the year 1822, are a fair specimen of the opinions which prevailed on the 
subject previously to the great failure of 
1845. 


‘The increased growth of the potato, not 



---

p.3



 

only in these kingdoms, but almost in every civilised part of the globe, has so added to its importance, that any information respecting it has become valuable. With the exception of wheat 
and rice, it is now certainly the vegetable most 
employed as the food of man; and it is probable 
that the period is at no great distance, when its 
extensive use will even place it before those 
which have hitherto been considered the chief 
staples of life. The effect of the unlimited 
extent to which its cultivation may be carried, 
on the human race, must be a subject of deep 
interest to the political economist. The extension of population will be as unbounded as the 
production of food, which is capable of being 
produced in very small space, and with great 
facility; and the increased number of inhabitants 
of the earth will necessarily induce changes, not 
only in the political systems, but in all the artificial relations of civilised life. How far such 
changes may conduce to or increase the happiness 
of mankind, is very problematical, more especially when it is considered, that since the potato, 
when in cultivation, is very liable to injury from 
casualties of season, and that it is not at present 
known how to keep it in store for use beyond a 
few months, a general failure of the year's crop, 
whenever it shall have become the chief or sole 
support of a country, must inevitably lead to all 
the misery of famine, more dreadful in proportion 
to the numbers exposed to its ravages.’




---

p.4


The important influence which has been 
exercised by this root over the destinies of 
the human race, arises from the fact that it 
yields an unusually abundant produce as 
compared with the extent of ground cultivated, and with the labour, capital, and skill 
bestowed upon its cultivation. The same 
land, which when laid down to corn, will 
maintain a given number of persons, will 
support three times that number when used 
for raising potatoes. ‘A family in the West 
of Ireland, once located on from one to three 
or four acres of land, was provided for; a 
cabin could be raised in a few days without 
the expense of a sixpence; the potatoes, at 
the cost of a very little labour, supplied 
them with a sufficiency of food, with which, 
from habit, they were perfectly content; and 
a pig, or with some, a cow, or donkey, or 
pony, and occasional labour at a very low 
rate of wages, gave them what was necessary 
to pay a rent, and for such clothing and 
other articles as were absolutely necessary, 
and which, with a great proportion, were on 
the lowest scale of human existence. The 
foundation of the whole, however, was the 
possession of the bit of land; it was the 
one, and the only one thing absolutely necessary; the rent consequently was high, and 



---

p.5



 

generally well paid, being the first demand 
on all money received, in order to secure 
that essential tenure; and only what remained became applicable to other objects. Although of the lowest grade, it was an easy 
mode of subsistence, and led to the encouragement of early marriages, large families, 
and a rapidly-increasing population, and at 
the same time afforded the proprietor very 
good return of profit for his land.’[3](javascript:footNote('E840001-002/note003.html'))


The relations of employer and employed, 
which knit together the framework of society, and establish a mutual dependence and 
good-will, have no existence in the potato 
system. The Irish small holder lives in a 
state of isolation, the type of which is to be 
sought for in the islands of the South Sea, 
rather than in the great civilized communities of the ancient world. A fortnight for 
planting, a week or ten days for digging, and 
another fortnight for turf-cutting, suffice for 
his subsistence; and during the rest of the 
year, he is at leisure to follow his own inclinations, without even the safeguard of those 
intellectual tastes and legitimate objects of 
ambition which only imperfectly obviate the 
evils of leisure in the higher ranks of society. 



---

p.6




The excessive competition for land maintained rents at a level which left the Irish 
peasant the bare means of subsistence; and 
poverty, discontent, and idleness, acting on 
his excitable nature, produced that state of 
popular feeling which furnishes the material 
for every description of illegal association 
and misdirected political agitation. That 
agrarian code which is at perpetual war with 
the laws of God and man, is more especially 
the offspring of this state of society, the 
primary object being to secure the possession of the plots of land, which, in the 
absence of wages, are the sole means of subsistence.


There is a gradation even in potatoes. 
Those generally used by the people of Ireland were of the coarsest and most prolific 
kind, called ‘Lumpers,’ or ‘Horse Potatoes,’ from their size, and they were, for the 
most part, cultivated, not in furrows, but in 
the slovenly mode popularly known as ‘lazy 
beds;’ so that the principle of seeking the 
cheapest description of food at the smallest 
expense of labour, was maintained in all its 
force. To the universal dependence on the 
potato, and to the absence of farmers of a 
superior class, it was owing that agriculture 
of every description was carried on in a negligent, 



---

p.7



 

imperfect manner[4](javascript:footNote('E840001-002/note004.html')). The domestic 
habits arising out of this mode of subsistence were of the lowest and most degrading 
kind. The pigs and poultry, which share 
the food of the peasants family, became, in 
course, inmates of the cabin also. The habit 
of exclusively living on this root produced 
an entire ignorance of every other food and 
of the means of preparing it; and there is 


---

p.8




scarcely a woman of the peasant class in the 
West of Ireland, whose culinary art exceeds 
the boiling of a potato. Bread is scarcely 
ever seen, and an oven is unknown.


The first step to improvement was wanting to this state of things. The people 
had no incitement to be industrious to procure comforts which were utterly beyond 
their reach, and which many of them perhaps had never seen. Their ordinary food 
being of the cheapest and commonest description, and having no value in the market, 
it gave them no command of butcher's meat, 
manufactures, colonial produce, or any other 
article of comfort or enjoyment. To those 
who subsist chiefly on corn, other articles of 
equal value are available, which can be substituted for it at their discretion; or if they 
please, they can, by the adoption of a less 
expensive diet, accumulate a small capital by 
which their future condition may be improved and secured; but the only hope for 
those who lived upon potatoes was in some 
great intervention of Providence to bring 
back the potato to its original use and intention as an adjunct, and not as a principal 
article of national food; and by compelling 
the people of Ireland to recur to other more 
nutritious means of aliment, to restore the 



---

p.9




energy and the vast industrial capabilities of 
that country.


A population, whose ordinary food is wheat and beef, and whose ordinary drink 
is porter and ale, can retrench in periods 
of scarcity, and resort to cheaper kinds of 
food, such as barley, oats, rice, and potatoes. 
But those who are habitually and entirely 
fed on potatoes, live upon the extreme 
verge of human subsistence, and when they 
are deprived of their accustomed food, there 
is nothing cheaper to which they can resort. 
They have already reached the lowest point 
in the descending scale, and there is nothing 
beyond but starvation or beggary. Several 
circumstances aggravate the hazard of this 
position. The produce of the potato is 
more precarious than that of wheat or any 
other grain. Besides many other proofs of 
the uncertainty of this crop, there is no 
instance on record of any such failure of the 
crops of corn, as occurred in the case of 
potatoes in 1821, 1845, 1846, and 1847; 
showing that this root can no longer be 
depended upon as a staple article of human 
food. The potato cannot be stored so that 
the scarcity of one year may be alleviated 
by bringing forward the reserves of former 
years, as is always done in corn-feeding 



---

p.10



 

countries. Every year is thus left to provide subsistence for itself. When the crop 
is luxuriant, the surplus must be given to 
the pigs; and when it is deficient, famine 
and disease necessarily prevail. Lastly, the 
bulk of potatoes is such, that they can with 
difficulty be conveyed from place to place 
to supply local deficiencies, and it has often 
happened that severe scarcity has prevailed 
in districts within fifty miles of which potatoes were to be had in abundance. If a 
man use two pounds of meal a-day (which 
is twice the amount of the ration found to 
be sufficient during the late relief operations), a hundredweight of meal will last 
him for fifty-six days; whereas a hundredweight of potatoes will not last more than 
eight days; and when it was proposed to 
provide seed-potatoes for those who had lost 
their stock in the failure of 1845-6, the plan 
was found impracticable, because nearly a 
ton an acre would have been required for 
the purpose.


The potato does not, in fact, last even a 
single year. The old crop becomes unfit for 
use in July, and the new crop, as raised by 
the inferior husbandry of the poor, does not 
come into consumption until September. 
Hence, July and August are called the 


---

p.11




‘meal months,’ from the necessity the 
people are under of living upon meal at 
that period. This is always a season of 
great distress and trial for the poorer peasants; and in the districts in which the 
potato system has been carried to the 
greatest extent, as, for instance, in the 
barony of Erris in the county of Mayo, 
there has been an annual dearth in the summer months for many years past. Every 
now and then a ‘meal year’ occurs, and 
then masses of the population become a 
prey to famine and fever, except so far as 
they may be relieved by charity. 


In 1739 an early and severe frost destroyed the potatoes in the ground, and the 
helplessness and despair of the people 
having led to a great falling off of tillage 
in 1740, the calamity was prolonged to the 
ensuing year, 1741, which was long known 
as the **bliadhain an air**, or year of slaughter. 
The ordinary burial-grounds were not large 
enough to contain those who died by the 
roadside, or who were taken from the deserted cabins. The ‘bloody flux’ and 
‘malignant fever,’ having begun among 
the poor, spread to the rich, and numerous 
individuals occupying prominent positions 
in society, including one of the judges (Mr. 




---

p.12




Baron Wainwright), and the Mayor of 
Limerick (Joseph Roche, Esq.), and many 
others of the corporation, fell victims. Measures were adopted at Dublin on the principle of the English Poor Law, some of 
the most essential provisions of which appear to have been well understood in the 
great towns of Ireland in that day; and 
it was ‘hoped, since such provision is made 
for the poor, the inhabitants of the city will 
discourage all vagrant beggars, and give 
their assistance that they may be sent to 
Bridewell to hard labour, and thereby free 
themselves from a set of idlers who are a 
scandal and a reproach to the nation.’ Soup-kitchens and other modes of relief were established in different parts of the country, 
in which Primate Boulter and the **Society of 
Friends** took the lead; and numerous cargoes of corn were procured on mercantile account from the North American Colonies, 
the arrival of which was looked for with great 
anxiety. In only one point is there any decided difference between what then took place 
in Ireland and the painful events which have 
just occurred, after the lapse of upwards of a 
century. The famine of 1741 was not regarded 
with any active interest either in England or 
in any foreign country, and the subject is 



---

p.13




scarcely alluded to in the literature of the 
day. No measures were adopted either by the 
Executive or the Legislature for the purpose 
of relieving the distress caused by this famine. 
There is no mention of grants or loans; but 
an Act was passed by the Irish Parliament 
in 1741 (15 Geo. II, cap. 8), ‘For the more 
effectual securing the payment of Rents, and 
preventing frauds by Tenants’.[5](javascript:footNote('E840001-002/note005.html'))


The failure of 1822, in the provinces of 
Munster and Connaught, was owing to a 
continued and excessive humidity, which 
caused the potatoes to rot after they had been 
stored in the pits, so that the deficiency 
of food was not discovered till late in the 
season. On the 7th May, 1822, a public 
meeting was held in London which was 
attended by the Archbishop of Canterbury 
and the most eminent persons of the day, 
when a committee of no less than 109 of 
the nobility and gentry was formed, and a 
subscription was entered into, amounting, 
with the aid of a king's letter, to 311,081 l. 
5s. 7d. of which 44,177 l. 9s. was raised in 
Ireland. Many excellent principles were 




---

p.14




laid down for the distribution of this large 
sum; and after reserving what was required 
for immediate relief, the balance, amounting 
to 87,667 l., was granted to various societies 
which had been established for the future and 
permanent benefit of the Irish peasantry.[6](javascript:footNote('E840001-002/note006.html')) A committee also sat at the Mansion House 
at Dublin, which collected 31,260 l. from 
various quarters, independently of the grants 
it received from the London Committee. 
Central Committees were established in each 
county town in the distressed districts, and 
Sub-Committees in each parish. The western portion of Ireland was also divided into 
three districts, to each of which a civil engineer was appointed for the purpose of 
employing the destitute in making roads, 
and the following sums were voted by Parliament for carrying on these and other 
Public Works set on foot with the same 
object of relieving the distress[7](javascript:footNote('E840001-002/note007.html')): 



---

p.15



 

On 24 June, 1822, £100,000, 
  

‘for the employment of the poor in Ireland, and 
other purposes relating thereto as the exigency of 
affairs may require.’
  


On 23 July, 1822, £200,000; 
  

‘to enable His Majesty to take such measures as 
the exigency of affairs may require.’
  


And on the 24 June, 1823, £15,000 was 
voted, 
  


‘to facilitate emigration from the south of Ireland to the Cape of Good Hope.’


In 1831 another failure of the potato 
crop occurred in the counties of Galway, 
Mayo, and Donegal, upon which, another 
meeting was held in the City of London, 
and one committee was established at the 
Mansion House, and another at the West 
End. Great exertions were made to raise 
subscriptions; a bazaar was held at the 



---

p.16




Hanover Square Rooms by many of the 
ladies of the nobility, presided over by the 
Queen in person; and there was a ball at 
Drury Lane Theatre, which was honoured 
by the presence of the King and Queen. 
The whole amount collected was 74,410 l.; 
and besides this 40,000 l. was granted by 
Parliament, part of which was expended on 
relief works, and part in the actual distribution of food. Besides these London Committees, two other Committees were formed 
at Dublin, through one of which (the Mansion House Committee)[8](javascript:footNote('E840001-002/note008.html')) 8,569l. was collected,



---

p.17



 

and through the other (the Sackville Street Committee) 21,526 l.


In each of the years 1835, 1836, and 
1837, the potato crop failed in one or other 
of the districts in the West of Ireland, and 
sums amounting in the aggregate to 7572 l. 
were expended from Civil Contingencies in 
relieving the distress thereby occasioned, to 
which was added the sum of 4,306 l. remaining from the English and Irish subscriptions 
of 1831.


In 1839 another failure occurred; and in 
all the Western and Midland Counties, the 
average price of potatoes in July and August 
was 7d. a stone, and of oatmeal 18s. or 19s. 
a cwt.; the former double, and the latter 
one-third more than the usual price at that 
time of the year. On this occasion Captain 
Chads, R.N. was deputed by the Government



---

p.18




to assist the landlords in employing 
the destitute in constructing roads and other 
useful public works; and it appears from a 
report addressed by him to the Chancellor 
of the Exchequer, dated the 22nd of August, 
1839, that 5,441 l. was expended in this way, 
of which 1840 l. was contributed by the Government, besides 1478 l. disbursed through 
other channels. Towards the conclusion of 
his report Captain Chads made the following 
remarks: — ‘A recurrence of these seasons 
of distress, which have been almost periodical hitherto, must, I fear, be necessarily 
expected, so long as the present condition 
of the poor continues, and whilst they subsist on that species of food, which in a year 
of plenty cannot be stored up for the next, 
which may be one of scarcity. A very great 
alleviation, however, of this evil is most confidently expected from the Poor Law now 
being established. I have conversed on this 
subject with persons of every class of society, 
from one end of the country to the other, 
and it is universally regarded as the promise 
of a great blessing: — to the poor by inducing more provident and industrious habits; 
and by making it the interest of the landlords to give them employment; and to all other classes, comfort and contentment, from 



---

p.19



 

the knowledge that the really distressed are 
provided for, and that the country is generally improving by the extension of employment.’


After this, urgent representations of distress were made in each year to the Irish 
Government and to the Poor Law Commissioners, until the summer of 1842, which 
was more than usually wet and unfavourable 
to vegetation, and it therefore again became 
necessary to have recourse to extensive 
measures of relief. On this occasion 3,44* l. 
was distributed in aid of local subscriptions, 
in 121 separate districts; the aggregate 
sums raised in each case being expended, 
partly in public works on Captain Chads' 
plan, and partly in giving gratuitous relief.[9](javascript:footNote('E840001-002/note009.html'))


Besides the grants above enumerated, 
made for the immediate relief of the Irish 
poor, when failures of the potato crop caused 
unusual distress, large sums of money have 
been advanced or granted from the Imperial 



---

p.20




Treasury from time to time since the Union, 
for various purposes supposed to be conducive to the tranquillity and improvement 
of the country, and to the removal of the 
causes of permanent distress, as will be seen 
from the following specimens taken principally from a return to an order of the House 
of Commons of the 12th February, 1847, 
made on the motion of Mr. John O'Connell.[10](javascript:footNote('E840001-002/note010.html'))


1. Works for Special Purposes under the Act 57 
Geo. III., cap. 34 ... 496,000
2. Do. for the Employment and Relief of the Poor, under the 1 & 2 Wm. IV., cap. 33, and previous Acts ... 1,339,146
3. Grants in aid of Public Works under various 
Acts of Parliament ... 125,000
4. Advanced by the London Loan Commissioners for sundry Works between 1826 and 1833 ... 322,500
5. Do. do. for Poor-Law Union Workhouses ... 1,145,800
6. Kingstown Harbour ... 1,124,580
7. Improvement of the River Shannon ... 533,359
8. Wide Street Commissioners, Dublin ... 267,778
9. Improving Post Roads ... 515,541
10. Gaols and Bridewells ... 713,005
11. Asylums for Lunatic Poor ... 710,850
12. Valuation of Lands and Tenements ... 172,774
13. Royal Dublin Society ... 285,438
14. Farming Society, Dublin ... 87,132
15. Linen Board, Dublin ... 537,656
16. Tithe (Relief of Clergy who did not receive Tithes of 1831) 50,916
17. Tithe Relief (Million Act) ... 918,863
18. Tithe Relief Commissioners (establishing 
Composition for Tithes) ... 279,217


---

p.21

21. Relief of Trade 178,070
22. Boards and Officers of Health (Cholera) ... 196,575
23. Police Purposes (Proclaimed Districts) ... 4,093,871
24. Police Purposes (Constabulary Police) ... 1,748,712



Other causes concurred with the natural 
tendency of every people to have recourse 
to the cheapest description of food, in 
encouraging the growth of a large population 
depending for its subsistence on the potato. 
Ireland was essentially a grazing country 
until the artificial enhancement of prices 
caused by the Acts of the Irish Parliament 
passed in 1783 and 1784, for granting a 
bounty on the exportation, and restricting 
the importation of corn, occasioned an immediate and extraordinary increase of cultivation; and as, owing to the general want 
of capital, it was impossible to find tenants 
for large tillage farms, the stimulus intended 
to act exclusively on agriculture, had a still 
more powerful effect in causing the subdivision of farms. The new occupiers also, 
being, for the most part, exceedingly poor, 
instead of paying their labourers in money, 
allowed them the use of small pieces of 
ground whereon they might erect cabins 
and raise potatoes, and their labour was set 
off, at so much a-day, against the annual 
rent. The plan of dividing and subdividing 
for the purpose of making freeholders, was 



---

p.22




carried to a great extent after 1792, when 
the elective franchise was restored to the 
Roman Catholics; and although the practice 
was far from being general, yet in some 
parts of the country, where particular families made it their object to contest or secure 
the county, it was carried to a very pernicious extent. Another powerful cause is 
that the emoluments of the Roman Catholic 
priesthood, including the bishops, depend 
not only on the extent of the population, but 
also on its continual increase; and if the 
parish priests object to emigration and the 
consolidation of small holdings, and look 
with favour on early marriages, it is only 
what any other body of men, in their circumstances, would equally do. Lastly, the 
small holding and potato system offered the 
inducement of large rents, obtained at the 
smallest possible amount of cost and trouble. 
The embarrassed and improvident landlord, 
and the leaseholder whose only object it was 
to make the most of his short tenure, 
equally found their account in this state of 
things, and the result in both cases was, 
that the farms were covered with hovels and 
miserable cottiers, in order, through them, 
to create profit-rents. When the failure of 
the potato forced all the ‘squatters’ and 



---

p.23



 

‘mock tenants’ into notice, the owner of 
many a neglected estate was surprised by the 
apparition of hundreds of miserable beings, 
who had grown up on his property without 
his knowledge, and now claimed the means 
of support at his hands. The subsistence 
of the tenant was at the minimum; the rent 
was at the maximum; and the interval between the ignorant excitable peasantry and 
the proprietor in chief, was filled only by the 
middleman, whose business it was to exact 
rents and not to employ labourers. The 
base and the capital of the column were 
there, but the shaft was almost entirely 
wanting.


The extent to which the welfare of the 
agricultural population, and through them 
of the rest of the community, is affected 
by the conditions upon which landed property is held, has become fearfully apparent 
during the present social crisis. The dependence for good and evil of workman on 
master manufacturer, of subject on Government, of child on father, is less absolute than that of the Irish peasant upon 
the lord of the soil from which he derives 
his subsistence. This is a subject to which, 
if we would save ourselves and our country, 
it behoves us to give our most earnest and 



---

p.24




careful attention at the present time. We 
cannot give landed proprietors the will and 
disposition (where it is wanting) to fulfil 
the important part they have to perform 
in the scheme of society, but we have it in 
our power to strike off the fetters which at 
present impede every step of their progress 
in the performance of the duty they owe 
to themselves and to those dependent on 
them.


One half of the surface of Ireland is said 
to be let off in perpetuity leases, with derivative and subderivative interests in an 
endless chain, so as to obtain profit-rents 
at each stage; and these leases are often 
open to the additional objection that they 
are unnecessarily burthensome or uncertain 
from the particular mode in which they are 
made; such as ‘leases for lives renewable 
for ever by the insertion of other lives when 
the first-named are dead,’ ‘for three lives 
or thirty-one years,’ and ‘for three lives 
and thirty-one years.’ Many proposals 
have at different times been made for the 
redemption of these various interests; but 
an arbitrary interference with the rights of 
property is to be avoided, and our object 
should rather be to give every prudent 
facility for the voluntary transfer of land 



---

p.25



 

and of the various interests connected with 
it, which must lead, by a safe but certain 
gradation, to that degree of improvement of 
the existing tenures which is necessary for 
the encouragement of agriculture. In the 
flourishing islands of Guernsey arid Jersey, 
corn-rents of fixed amount are charged upon 
the same farm one after another, like the 
coats of an onion; but the lowest holder, 
who is the party really interested in the 
improvement of the property, has every 
requisite security that he will enjoy the 
whole profit of any outlay he may make, 
and the most essential part of the benefit 
of ownership is thus obtained. In Mayo 
and other western counties the old barbarous Irish tenure called **Rundale** (Scotch **runrigg**), still prevails, which stops short of 
the institution of individual property, and 
by making the industrious and thriving responsible for the short-comings of the idle 
and improvident, effectually destroys the 
spring of all improvement. The cessation 
of this antiquated system is an indispensable 
preliminary to any progress being made in 
the localities where it exists; but this improvement may be effected by the landlords 
without any change in the law.


The master evil of the agricultural system 



---

p.26




of Ireland, however, is the law of Entail, 
and the Incumbrances which seldom fail 
to accumulate upon entailed estates. ‘Proprietors of estates,’ observes the author of 
an excellent pamphlet which has recently 
appeared on this subject[11](javascript:footNote('E840001-002/note011.html')), ‘are too often 
but mere nominal owners, without influence 
or power over the persons holding under 
them. Their real condition is often pitiable, 
nor is it possible, in the great majority of 
cases, to retrieve the estates. The burthen 
of debt, or the evils of improvident leases, 
are fastened upon the land in such a manner 
as to convert the owner into a mere annuitant, often glad to obtain from a good 
estate a scanty annuity (after payment of 
the incumbrances thereon and the public 


---

p.27



 

burthens) for his own subsistence. Proprietor and tenant are equally powerless for 
good; and the whole kingdom suffers from 
the disorders which have resulted from this 
state of real property in Ireland.’ And the 
author of another valuable publication on 
the same subject[12](javascript:footNote('E840001-002/note012.html')) observes as follows: ‘The 
evils resulting from settlements and entails 
may be regarded as arising from insecurity 
or uncertainty of tenure; because the possessor of the property is not in reality the 
owner; he cannot deal with it as an owner; 
he is merely a trustee for others; he has 
no interest in its future thorough permanent 
improvement, except so far as he may wish 



---

p.28




to benefit his successors; he can never reap 
the benefit himself; he cannot sell; he 
cannot dispose of a part, even though the 
alienation of a part might greatly enhance 
the value of the remainder; he holds it 
during his lifetime, as his predecessor held 
it, unaltered, unimproved, to transmit it to 
his heir clogged with the same restrictions 
alike injurious to him and to his country. 
This is the case of an unembarrassed landlord.[13](javascript:footNote('E840001-002/note013.html')) But let us suppose, as is unfortunately



---

p.29



 

too often the case, that he has received the estate incumbered under a settlement, with a jointure to the widow of the 
late possessor, and a provision for daughters 
and younger sons. In what difficulties is 
he at once involved! this owner for life of 
a large tract of country with a long rent-roll, 
but in fact a small property! He cannot 
maintain his position in society without 
spending more than his income; debts accumulate; he mortgages his estate, and insures his life for the security of the mortgagee. Of course he cannot afford to lay 
out anything on improvements; on the contrary, though perhaps naturally kind-hearted 
and just, his necessities force him to resort 
to every means of increasing his present 
rental. He looks for the utmost amount; 
he lets to the highest bidder, without regard to character or means of payment. If 
his tenants are without leases, he raises their 
rents. If leases fall in, he cannot afford to 
give the preference to the last occupier. 
Perhaps, with all his exertions, he is unable 



---

p.30



 

to pay the interest or put off his creditors. 
Proceedings are commenced against him, 
and the estate passes during his lifetime 
under the care of the worst possible landlord, a Receiver under the Court of Chancery.’[14](javascript:footNote('E840001-002/note014.html')).




---

p.31


The remedy for this state of things is 
simply the sale of the encumbered estate, or 
of a sufficient portion of it to enable the 
owner to discharge his encumbrances and 
to place him in a position to do his duty 
towards the remainder. This is the master-key to unlock the field of industry in 
Ireland. The seller, in all such cases, 
is incapable of making a proper use of 
the land. The purchaser, on the other 
hand, may safely be assumed to be an 
improver. It is a natural feeling in which 
almost all men indulge, and purchases of 
land are seldom made without a distinct 
view to further profitable investments in 
improvements. ‘To give every prudent 
facility for the transfer by sale of real 
property from man to man, by the adoption of a simple, cheap, and secure system 
of transfer, in lieu of the present barbarous, unsafe, and expensive system, so that 
real property could be bought and sold in 
Ireland with as much freedom and security 
as other property,’[15](javascript:footNote('E840001-002/note015.html')) is, therefore, the object 



---

p.32




at which we ought to aim, and especially 
to encourage the investment of small capitals in the land, it being through the 
instrumentality of small capitalists chiefly 
that the country can be civilized and improved. ‘The purchasers would give extensive and permanent employment to numbers of people around them in carrying 
out that natural desire of man, the improvement of newly-acquired landed property; they would promote industry everywhere; they would greatly increase the value 
of land generally. By their number, all 
property in land would be rendered secure 
against revolutionary violence. The habits 
and example of men who had made money 
by industry, and who might invest their 
savings in land, would place the social system of Ireland on a solid basis. The best 
of the Protestants and Roman Catholics, 
those who had been careful and industrious, 
would be purchasers of land, and all would 
have a common interest in peace and order. 
That surplus population beyond the means 
of present employment, which now oppresses and embarrasses the country, might 
gradually be absorbed, and become a source 
of wealth and strength. Towns would everywhere improve, and new ones might arise 



---

p.33



 

by the extension of the railway system, 
spreading industry and civilization among 
men now sunk in indolence and almost 
barbarism.’[16](javascript:footNote('E840001-002/note016.html'))


All the parties concerned in these transfers 
would be benefited by them. Lands are comparatively valueless to those who have no 
capital to improve them, and they are often 
justly felt to be a burthen and a disgrace, 
because they entail duties which the nominal 
owners have no means of performing. The 
effect on the character and prospects of the 
whole body of landed proprietors would be 
as described in the following passage from 
the author to whom we are already so much 
indebted: ‘When men, however young, act 
under responsibility, they usually proceed 
with caution; if others will think and act 
for them, and provide for their wants, and 
secure them from poverty and danger, their 
own prudential faculties may become dormant; and a man or any class of men so 
protected, are likely to exhibit deficiency in 
the qualities of prudence and good management of their affairs. But owners of land 
would not evince any such deficiency, if once 



---

p.34




they felt that they would be ruined, and their 
families also, if they were not governed by 
the same rules of prudence which other men 
must observe, and which necessarily enter 
into the proper management of all other descriptions of property. The present difficulties of sale of land, and the consequent 
protection afforded to entailed properties, 
are the chief reasons why so many persons 
of the class of proprietors are in difficulties. 
With more liberty, there would be more 
prudence and more attention to estates on 
the part of owners, from which they and the 
country would be great gainers.’[17](javascript:footNote('E840001-002/note017.html'))


The manner in which the interests of the 
public at large are affected, is correctly described in the following passage from the 
other pamphlet: ‘If these premises be correct; if employment with regular wages must 
be found for the peasantry: if capital be necessary, and the parties holding the land do 
not possess sufficient for this purpose; it 
follows, either that Government must continue to supply the capital required, not 
merely by a loan on an emergency, but as 
part of its regular system of action; or else 



---

p.35



 

that the land must pass into the hands of 
those who do possess the means of employing the people — of men who will carry on 
agriculture as a business, and will bring to 
their occupation the capital, the habits of 
business, and the energy and intelligence 
which have raised the commerce and manufactures of this nation to their present preeminence.’[18](javascript:footNote('E840001-002/note018.html'))


Her Majesty's Government being deeply 
impressed with the importance of these 
views, introduced a bill into Parliament in 
the session of 1847, the object of which was 
to enable the owners of encumbered estates 
in Ireland to sell the whole or a portion of 
them, after the circumstances of each estate 
had been investigated by a Master in Chancery with a view to secure the due liquidation of every claim upon it. The sale was 
not to take place without the consent of the 
first incumbrancer, unless the Court of Chancery should consider the produce sufficient 
to pay the principal and all arrears of interest, or unless the owner or some subsequent incumbrancer should undertake to 
pay to the first incumbrancer any deficiency 



---

p.36




which might exist, and give such security 
for the performance of his undertaking as 
the court might direct. This bill passed the 
House of Lords, but was withdrawn in the 
Commons, owing to the opposition of some 
of the Irish proprietors, and to objections 
entertained by the great Insurance Companies, who are the principal lenders on Irish 
mortgages, to having their investments disturbed. The failure of the bill was a national 
misfortune which cannot be too soon remedied.


The Government, however, did what was 
in its power. A system has existed in Ireland since the time of Queen Anne for the 
registration of all deeds affecting landed property; and of late years a similar registration 
has been established of all judgments relating 
to that description of property. The attention of the Lord Lieutenant has been called 
to the practicability of diminishing the delay 
and expense attending transfers of landed 
property, by the adoption of two simple 
practical measures, viz., that when searches 
have been made in the office of the Registrar of Deeds, copies should be recorded in 
the office, as well as given to the parties on 
whose behalf they are made; and that when 





---

p.37




judgments, &c., recorded in the office of the 
Registrar of Judgments have been satisfied, 
notice should be immediately sent to the 
Registrar, in order that such satisfaction 
may be recorded in the books of his office.[19](javascript:footNote('E840001-002/note019.html'))
The consequence of the neglect of the first 
of these obvious precautions was, that, after 
expensive searches had been made in the 
Registry Office, the same searches often had 
to be made again and again, at the same 
expense, at the instance of other parties, 
however limited the transactions might be 
for the security of which these inquiries into 
past transfers and incumbrances were made; 
and the consequence of the neglect of the 
other precaution was, that if, after a search 
had been made through the records deposited in the office of the Registrar of Judgments, to ascertain whether any judgment 
had been passed against the estate, it appeared that any such judgment had been 
given, another search had to be made in the 
courts of law, involving fresh loss of time 
and fresh expense, to ascertain whether it 
had been satisfied.[20](javascript:footNote('E840001-002/note020.html'))




---

p.38


But it is time that we should resume our 
narrative.


The potato disease, which had manifested 
itself in North America in 1844[21](javascript:footNote('E840001-002/note021.html')), first appeared in these islands late in the autumn of 1845. The early crop of potatoes, which 
is generally about one-sixth of the whole, 
and is dug in September and October, escaped; but the late, or what is commonly 
called the ‘people's crop’ and is taken up 
in December and January, was tainted after 
it arrived at an advanced stage of maturity. 
When the disease had once commenced, it 
made steady progress, and it was often found, 
on opening the pits, that the potatoes had 
become a mass of rottenness. Nevertheless, 
this year the attack was partial; and although 
few parts of the country entirely escaped, and 
the destruction of human food was, on the 
whole, very great, a considerable portion of 



---

p.39




the crop, which had been a more than usually 
large one, was saved. The wheat crop was 
a full average; oats and barley were abundant; and of turnips, carrots, and green 
crops, including a plentiful hay harvest, 
there was a more than sufficient supply. 
On the Continent, the rye crops failed partially, and the potato disease was very destructive in Holland, Belgium, France, and the west of Germany.


In the following year (1846) the blight 
in the potatoes took place earlier, and was 
of a much more sweeping and decisive 
kind. ‘On the 27th of last month (July), 
I passed,’ Father Mathew writes in a letter published in the Parliamentary Papers, 
‘from Cork to Dublin, and this doomed 
plant bloomed in all the luxuriance of an 
abundant harvest. Returning on the 3rd 
instant (August), I beheld with sorrow one 
wide waste of putrefying vegetation. In 
many places the wretched people were seated 
on the fences of their decaying gardens, 
wringing their hands, and wailing bitterly 
the destruction that had left them foodless.’ 
The first symptom of the disease was a little 
brown spot on the leaf, and these spots gradually increased in number and size, until 



---

p.40



 

the foliage withered and the stem became 
brittle, and snapped off immediately when 
touched. In less than a week the whole 
process was accomplished.[22](javascript:footNote('E840001-002/note022.html')) The fields assumed a blackened appearance, as if they 
had been burnt up, and the growth of the 
potatoes was arrested when they were not 
larger than a marble or a pigeon's egg. No 
potatoes were pitted this year. In many 
districts where they had been most abundant, full-grown wholesome potatoes were 



---

p.41




not to be procured; and even in London 
and other large towns, they were sold at 
fancy prices, and were consumed as a luxury 
by the wealthy, rice and other substitutes 
being had recourse to by the body of the 
people. The crop of wheat this year was 
barely an average one, while barley and oats, 
and particularly the former, were decidedly 
deficient. On the Continent, the rye and 
potato crops again failed, and prices rose 
early in the season above those ruling in 
England, which caused the shipments from 
the Black Sea, Turkey and Egypt, to be 
sent to France, Italy, and Belgium; and it 
was not till late in the season, that our 
prices rose to a point which turned the 
current of supplies towards England and 
Ireland. The Indian corn crop in the United 
States this year was very abundant, and it 
became a resource of the utmost value to 
this country.


In the third year (1847) the disease had 
nearly exhausted itself. It appeared in 
different parts of the country, but the plants 
generally exerted fresh vigour and outgrew 
it. The result, perhaps, could not have been 
better. The wholesome distrust in the potato 
was maintained, while time was allowed for 



---

p.42




making the alterations which the new state 
of things required. Although the potatoes 
sown in Ireland in the year 1847 were estimated only at one fifth or one sixth of the usual 
quantity, it would have been a serious aggravation of the difficulties and discouragements 
under which that portion of the empire was 
suffering, if the disease had reappeared in its 
unmitigated form. The crops of wheat, 
barley, and oats, in almost every part of 
the United Kingdom, and in most of the 
neighbouring countries on the Continent, 
were this year, to use the epithet generally 
applied to them, magnificent; and it became 
more and more apparent on the brink of 
what a precipice we had been standing, as 
the unusually small remaining stock of old 
corn came to light, and the exhausted and 
embarrassed state to which every description 
of business had been reduced, notwithstanding the advantage of a good harvest, gradually declared itself.


Among the numerous causes which enhanced the difficulty of obtaining adequate 
foreign supplies at moderate rates during 
the most exigent period of the winter of 
1846–7, one of the most embarrassing, was 
the sudden and extraordinary advance in 



---

p.43



 

freights, which occurred simultaneously in 
the ports of the United States of America, 
the Mediterranean, and the Black Sea. 
Vessels were not obtainable in the Black 
Sea and the Danube at less than 18s. and 
22s. per quarter for corn, whereas the usual 
rates are 9s. and 11s.; while in the United 
States, where large shipments of grain, 
flour, and Indian corn, were going forward 
to Europe, the comparatively limited number 
of vessels caused the rates to run up to 9s. 
per barrel for flour, and 16s. and 18s. per 
quarter for Indian corn to British ports, the 
rates usually given being 2s. 6d. to 3s. 6d. 
per barrel of flour, and 8s. and 9s. per quarter 
for Indian corn.


On the 27th January, 1846, **Sir Robert 
Peel** proposed his measure for the relaxation 
of the duties on the importation of foreign 
corn, by which the scale of duties payable 
on wheat was to range from 4s. to 10s. per 
quarter, and Indian corn, which had previously been charged with the same duty as 
barley, was to pay only 1s. a-quarter. This 
was to last till February 1849, when an 
uniform duty of 1s. a-quarter was to be 
charged on every description of grain. The 
bill passed the House of Lords on the 29th 



---

p.44




June, 1846; and **Sir R. 
Peel** announced his 
resignation in the House of Commons on 
the same day.


Immediately on the meeting of Parliament 
in January, 1847, **Lord J. Russell** introduced 
bills to suspend until the 1st September, 
1847, the duties on foreign corn, and the 
restrictions imposed by the Navigation Laws 
on the importation of corn in foreign vessels; 
and he at the same time moved a resolution 
permitting the use of sugar in breweries; 
all which measures received the sanction of 
the Legislature. At the close of the same 
session, the suspension of the Corn and 
Navigation Laws was extended to the 1st 
March, 1848.


On the first appearance of the blight in 
the autumn of 1845, Professors **Kane**, Lindley, and Playfair, were appointed by **Sir Robert 
Peel** to inquire into the nature of it, 
and to suggest the best means of preserving 
the stock of potatoes from its ravages. The 
result showed that the mischief lay beyond 
the knowledge and power of man. Every 
remedy which science or experience could 
dictate was had recourse to, but the potato 
equally melted away under the most opposite 
modes of treatment.




---

p.45


The next step was to order from the 
United States of America 100,000 l. worth of 
Indian corn. It was considered that the 
void caused by the failure of the potato crop 
*might be* filled, with the least disturbance of 
private trade and market prices, by the 
introduction of a new description of popular 
food. Owing to the prohibitory duty, Indian 
corn was unknown as an article of consumption in the United Kingdom.[23](javascript:footNote('E840001-002/note023.html')) Private 



---

p.46




merchants, therefore, could not complain of 
interference with a trade which did not exist, 
nor could prices be raised against the home 
consumer on an article of which no stock 
was to be found in the home market. 
Nevertheless, with a view to avoid as long 
as possible, the doubts and apprehensions 
which must have arisen if the Government 
had appeared as a purchaser in a new class 
of operations, pains were taken to keep the 
transaction secret, and the first cargoes from 
America had been more than a fortnight in 
Cork harbour before it became generally known that such a measure was in progress.




---

p.47


In order to distribute the food so obtained, 
central depôts were established in various 
parts of Ireland, under the direction of officers of the Commissariat, with sub-depôts 
under the charge of the Constabulary and 
Coast Guard; and, when the supplies in the 
local markets were deficient, meal was sold 
from these depôts at reasonable prices to 
Relief Committees, where any existed; and 
where they did not, to the labourers themselves. In the time of the heaviest pressure 
(June and July 1846); one sub-depôt retailed 
20 tons of meal daily, and the issues from 
a single main depôt to its dependencies 
amounted to 233 tons in one week.


The Relief Committees were formed; under 
the superintendence of a Central Commission at Dublin; for the purpose of selling 
food in detail to those who could buy it; and 
of giving it to those who could not; the requisite funds being derived from private subscriptions, added to, in certain proportions, 
by Government donations. The Relief 
Committees also selected the persons to be 
employed on the Relief Works carried on 
under the superintendence of the Board of 
Works.


If the Irish poor had been in the habit of 


---

p.48




buying their food, as is the case in England, 
the object would have been attained when 
a cheap substitute had been provided for the 
potato; but as the labouring class in Ireland 
had hitherto subsisted on potatoes grown by 
themselves, and money-wages were almost 
unknown, it was necessary to adopt some 
means of giving the people a command over 
the new description of food. This was done 
by establishing a system of public works, 
in accordance with the previous practice on 
similar occasions, both in Ireland and in 
other countries.


These works, which consisted principally 
of roads, were undertaken on the application 
of the magistrates and principal cess-payers, 
under the Act 9 & 10 Vic., c. 1, which was 
passed for the purpose, and the expense of 
executing them was defrayed by advances of 
public money, half of which was a grant, and 
half a loan to be repaid by the barony. The 
largest number of persons employed in this 
first season of relief was 97000, in August, 
1846.


The first symptoms of neglected tillage 
appeared in the Spring of 1846, and they 
were worst in those districts in which the 
Relief Works were carried on to the greatest 



---

p.49




extent. The improvements in progress on 
the Shannon and the arterial drainages were 
also impeded by the preference which the 
labourers showed for the Relief Works.


The measures of which we have been 
speaking were brought to a close on the 
15th August, 1846, and they may be considered to have answered their end. The 
scarcity being partial and local, the deficiency 
of one part of the country was supplied from 
the superabundance of others, and the pains 
taken to prevent the people from suffering 
want, led to their being better off than in 
ordinary years. Above all, Ireland was prepared by the course adopted during this 
probationary season of distress, as it may 
be called, to bear better the heavy affliction 
of the succeeding season. No misapplication 
of the funds deserving of notice took place, 
except in the instance of the Relief Works, 
the cause of which was as follows: — The 
landed proprietors of Ireland had long been 
accustomed to rely upon Government loans 
and grants for making improvements of various kinds, and the terms on which the Relief 
Works were to be executed being more advantageous than any which had been open to 
them for many years before, a rush took 



---

p.50




place from all quarters upon this fund, and 
the special object of relieving the people 
from the consequences of the failure of their 
accustomed food, was to a great extent lost 
sight of in the general fear, which in many 
cases was not attempted to be concealed, of 
being deprived of what the persons interested 
called ‘their share of the grant.’ This description of relief, therefore, instead of acting 
as a test of real distress, operated as a bounty 
on applications for public works from a class 
of persons who were at once charged with 
the administration of the relief and were 
interested in the execution of the works. 
The result was that, while the applications 
amounted to 1,289,816 l., the sum actually 
sanctioned and expended was only 476,000 l., 
and great part even of this was merely yielded 
to the distressing appeals pressed on the Lord 
Lieutenant on the plea of urgent local destitution, and of the lamentable consequences 
to be expected from allowing it to remain 
unrelieved. The other expenses connected 
with this season of relief were as follows: — 
Loans on grand jury presentments, 130,000l. 
loss on the purchase and sale of grain, 50,000l. 
given in aid of Relief Committees, 69,845l. 
extra staff of the Board of Works, 7,527l. 



---

p.51



 

thus making the whole sum expended in 
relief to Ireland, up to the 15th August, 
1846, 733,372l., of which 368,000l. was in 
loans, and 365,372l. in grants. The sum 
raised by voluntary subscription through the 
Relief Committees was 98,000l.


The new and more decisive failure of the 
potato crop called for great exertions from 
**Lord John Russell**'s recently formed Government, and the plan resolved upon was 
explained in the Treasury Minute dated the 
31st August, 1846, which was published for 
general information.[24](javascript:footNote('E840001-002/note024.html'))


The system of public works was renewed 
by the Act 9 & 10 Vic., c. 107, which was 
passed without any opposition in either 
House of Parliament. In order to check 
the exorbitant demands which had been 
made during the preceding season, the whole 
of the expense was made a local charge, and 
the advances were directed to be repaid by 
a rate levied according to the Poor Law 
valuation, which makes the landlords liable 
for the whole rate on tenements under 4 l. 
yearly value, and for a proportion, generally 


---

p.52




amounting to one-half, on tenements above 
that value, instead of according to the grand 
jury cess (the basis of the repayments under 
the preceding Act), which lays the whole 
burden upon the occupier. It was also 
determined that the wages given on the 
Relief Works should be somewhat below the 
average rate of wages in the district; that 
the persons employed, should, as far as 
possible, be paid by task or in proportion 
to the work actually done by them; and 
that the Relief Committees, instead of giving 
tickets entitling persons to employment on 
the public works, should furnish lists of 
persons requiring relief, which should be 
carefully revised by the officers of the 
Board of Works; the experience of the preceding season having shown that these precautions were necessary to confine the Relief 
Works to the destitute, and to enforce a 
reasonable quantum of work.


The question which the Government had 
to decide, in regard to the renewal of the 
Commissariat operations, was of the most 
momentous kind. After all that had taken 
place during the last few months, it could 
not be expected that private trade would 
return, as a matter of course, to its accustomed



---

p.53



 

channels. Neither the wholesale 
dealers in towns, nor the retail dealers in 
the rural districts, would lay in even their 
usual stocks of food; still less would they 
make the extraordinary provision required 
to meet the coming emergency, while they 
had before them the prospect of the Government throwing into the market supplies 
of food of unknown extent, which might 
make their outlay so much loss to them. 
The Government could not, therefore, calculate, as it did on the former occasion, on 
finding the private trade, by means of which 
the people are ordinarily supplied with food, 
proceeding as usual, and on being able to 
add more or less, at its discretion, to the 
resources which that trade afforded. Mercantile confidence in this branch of business 
was, for the time, destroyed. The trade was 
paralysed; and if this state of things had 
been suffered to continue, the general expectation of the Government again interfering 
would inevitably have created a necessity for 
that interference, on a scale which it would 
have been quite beyond the power of the 
Government to support.


Under these circumstances it was announced, — 1st. That no orders for supplies 



---

p.54




of food would be sent by the Government to 
foreign countries. 2ndly. That the interference of the Government would be confined to those western districts of Ireland in 
which, owing to the former prevalence of 
potato cultivation, no trade in corn for local 
consumption existed. And 3rdly. That even 
in these districts, the Government depôts 
would not be opened for the sale of food, 
while it could be obtained from private 
dealers at reasonable prices, with reference 
to those which prevailed at the nearest large 
marts. It was also determined to adhere to 
the rule acted upon during the preceding 
season, not to make any purchases in the 
local markets of Ireland, where the appearance of the Government as a buyer 
must have had the effect of keeping up 
prices and encouraging interested representations; and a promise was given that every 
practicable effort would be made to protect 
the supplies of food introduced by private 
traders, both while they were in transit and 
when they were stored for future consumption.


The Relief Committees of the preceding 
season were re-organised; the rules under 
which they had acted were carefully revised; 



---

p.55



 

and inspecting officers were appointed to 
superintend their proceedings, and keep the 
Government informed of the progress of 
events. A large proportion of the people 
of Ireland had been accustomed to grow the 
food they required, each for himself, on his 
own little plot of ground; and the social 
machinery by which, in other countries, the 
necessary supplies of food are collected, 
stored, and distributed, had no existence 
there. Suddenly, without any preparation, 
the people passed from a potato food, which 
they raised themselves, to a grain food, 
which they had to purchase from others, and 
which, in great part, had to be imported 
from abroad; and the country was so entirely 
destitute of the resources applicable to this 
new state of things, that often, even in large 
villages, neither bread nor flour was to be 
procured; and in country districts, the 
people had sometimes to walk twenty miles 
before they could obtain a single stone of 
meal. The main object for which the Relief 
Committees were established, therefore, was 
to provide a temporary substitute for the 
operations of the corn-factor, miller, baker, 
and provision-dealer, and to allow time and 
furnish the example for a sounder and more 



---

p.56




permanent state of things; but they were 
not precluded from giving gratuitous relief 
in cases of more than ordinary destitution. 
The agency of Relief Committees was this 
season almost universally substituted for the 
coast guard and constabulary depôts with 
the object of drawing out the resources of 
the country before the Government depôts 
were had recourse to, of inducing the upper 
and middle classes to exert themselves, and 
of preventing a direct pressure of the mass 
of the people upon the Government depôts, 
which in a time of real famine it would 
have been very difficult to resist.


Such was the plan resolved upon for the 
campaign of 1846–7 against the approaching 
famine, and we shall now show the result 
of the struggle.


It was hoped that a breathing-time would 
have been allowed at the season of harvest, 
to enable the Board of Works to reorganize their establishments on a scale proportioned to the magnitude of the task about 
to devolve on them, and to prepare, through 
their district officers, plans and estimates 
of suitable works for the assistance of the 
baronial sessions. This interval was not 
obtained. The general failure of the potato 



---

p.57



 

crop spread despondency and alarm from 
one end of Ireland to the other, and induced 
every class of persons to throw themselves 
upon the Government for aid. On the 6th 
of September, the Lord Lieutenant ordered 
all the discontinued works under the 9 & 
10 Vic., c. 1, to be recommenced, and sessions were rapidly held in all the southern 
and western counties of Ireland, at which 
roads were presented in the mass, under 
the 9 & 10 Vic., c 107, the cost of which, 
in some cases, much exceeded the annual 
rental of the barony. The resident gentry 
and rate-payers, whose duty it was to ascertain, as far as possible, the probable amount 
of destitution in their neighbourhood, the 
sum required to relieve it, and the works 
upon which that sum could best be expended, 
and who had the necessary local knowledge, 
in almost every case devolved these functions 
upon the Board of Works, who could only 
act on such information as they could obtain 
from naval and military officers and engineers, most of whom were selected from 
among strangers to the district, in order to 
prevent undue influence being used. After 
that, to advance the funds; to select the 
labourers; to superintend the work; to pay 



---

p.58




the people weekly; to enforce proper performance of the labour; if the farm works 
were interrupted, to ascertain the quantity 
of labour required for them; to select and 
draft off the proper persons to perform it; 
to settle the wages to be paid to them by 
the farmers, and see that they were paid; 
to furnish food, not only for all the destitute 
out of doors, but in some measure for the 
paupers in the workhouses, were the duties 
which the Government and its officers were 
called upon to perform. The proprietors 
and associated rate-payers having presented 
indefinitely, said it was the fault of the 
Government and its officers if the people 
were not instantly employed, and these 
officers were blamed, even by persons of 
character and understanding, if they were 
not at once equal to execute the duties 
which in this country are performed in their 
respective districts by thousands of country 
gentlemen, magistrates, guardians, overseers, 
surveyors, &c, resident throughout the 
country, and trained by the experience of 
years to the performance of their various 
functions. The Board of Works became 
the centre of a colossal organization; 5,000 
separate works had to be reported upon; 



---

p.59



 

12,000 subordinate officers had to be superintended. Their letters averaged upwards 
of 800 a-day, and the number received on 
each of the following days was — 
  


January 4th, - 3,104
  
 
February 15th, - 4,900
  
 
April 19th, - 4,340
  
 
May 17th, - - 6,033[25](javascript:footNote('E840001-002/note025.html'))


The strain on the springs of society from 
this monstrous system of centralisation was 
fearful in the extreme. The Government, 
which ought only to mediate between the 
different classes of society, had now to bear 
the immediate pressure of the millions, on 
the sensitive points of wages and food. The 
opposition to task-work was general, and 
the enforcement of it became a trial of 
strength between the Government and the 
multitude. The officers of the Board were 
in numerous instances the objects of murderous attacks, and it became necessary for 



---

p.60




the preservation of the whole community, to 
have recourse to the painful expedient of 
stopping the works whenever cases of insubordination or outrage occurred.


Meanwhile, the number of persons employed on the works was rapidly on the 
increase. The utmost exertions of two sets 
of inspecting officers, one under the Board 
of Works, and the other under **Sir R. Routh**, 
were insufficient to revise the lists; and the 
Lord Lieutenant in vain directed that no 
person rated above 6l. for the Poor Law 
cess, should, except under very special circumstances, be eligible for employment. 
Thousands upon thousands were pressed 
upon the officers of the Board of Works in 
every part of Ireland, and it was impossible 
for those officers to test the accuracy of the 
urgent representations which were made to 
them. The attraction of money wages regularly paid from the public purse, or the 
‘Queen's pay,’ as it was popularly called, 
led to a general abandonment of other descriptions of industry, in order to participate 
in the advantages of the Relief Works. 
Landlords competed with each other in 
getting the names of their tenants placed on 
the lists; farmers dismissed their labourers 



---

p.61




and sent them to the works; the clergy insisted on the claims of the members of 
their respective congregations; the fisheries 
were deserted; and it was often difficult even 
to get a coat patched or a pair of shoes 
mended, to such an extent had the population of the south and west of Ireland turned 
out upon the roads. The average number 
employed in October was 114,000; in November, 285,000; in December, 440,000; 
and in January, 1847, 570,000. It was 
impossible to exact from such multitudes a 
degree of labour which would act as a test of 
destitution. Huddled together in masses, 
they contributed to each other's idleness, 
and there were no means of knowing who 
did a fair proportion of work and who did 
not. The general enforcement of the system 
of task work had justly been considered 
necessary to stimulate the industry of the 
labourers on the Relief Works, but when 
this point had been carried, after a hard 
struggle, the old abuse reappeared in the 
aggravated form of an habitual collusion 
between the labourers and the overseers who 
were appointed to measure their work; so 
that the labourers, if they could be so called, 
were not only as idle as ever, but were enabled



---

p.62




withal to enjoy a rate of wages which 
ought only to have been the reward of superior industry.


The plan of the Labour Rate Act (9 & 10 
Vic.,. r c. 107) was based on the supposition 
that the great majority of the landlords and 
farmers would make those exertions and 
submit to those sacrifices which the magnitude of the crisis demanded, leaving only 
a manageable proportion of the population 
to be supported by the Board of Works; 
and the Act would probably have answered 
its object, if a larger, instead of a smaller 
number of persons than usual had been employed in the cultivation and improvement 
of the land, and the Relief Committees had 
put only those who were really destitute 
upon the lists. Including the families of 
the persons employed, upwards of two millions of people were maintained by the 
Relief Works, but there were other multitudes behind, including often the most 
helpless portion of the community, for 
whom no work could be found. The Relief 
Works did not always furnish a subsistence 
even for those who were employed on them. 
The wages, paid regularly in money, were 
higher than any which had ever been given 



---

p.63



 

for agricultural labour in Ireland, but at 
the existing prices of food they were *insufficient* for the support of a family, melancholy 
proof of which was afforded by daily instances 
of starvation in connexion with the Relief 
Works.[26](javascript:footNote('E840001-002/note026.html')) The fearful extent to which the 
rural population had been thrown for support upon the Board of Works also threatened a disastrous neglect of the ordinary 
tillage. If the people were retained on the 
works, their lands must remain uncultivated;



---

p.64




if they were put off the works, they must starve. A change of system had become inevitable, and when Parliament met 
in the end of January, it was announced 
that the Government intended to put an 
end to the Public Works, and to substitute 
for them another mode of relief, which will 
be hereafter described.


Meanwhile, the pressure on the Relief 
Works was continually on the increase, and 
the persons daily employed, who in January 
had been 570,000, became in February 
708,000, and in March amounted to the 
enormous number of 734,000,[27](javascript:footNote('E840001-002/note027.html')) representing



---

p.65



 

at a moderate estimate of the average 
extent of each family, upwards of three millions of persons. At last, the Government, 
seeing that the time suited for agricultural 
operations was rapidly passing away, and 
that the utmost exertions made on the spot 
had failed in keeping the numbers in check, 
took the matter into its own hands, and directed that on the 20th March, 20 per cent, 
of the persons employed should be struck 
off the lists; after which, successive reductions were ordered, proportioned to the progress made in bringing the new system of 
relief into operation in each district. These 
orders were obeyed, and the crisis passed 
without any disturbance of the public peace 
or any perceptible aggravation of the distress. The necessary labour was returned to 
agriculture, and the foundation was laid of 
the late abundant harvest in Ireland, by 
which the downward progress of that country 
has been mercifully stayed, and new strength 
and spirits have been given for working out 
her regeneration. In the first week in April, 
the persons employed on the Relief Works 
were reduced to 525,000; in the first week 
in May to 419,000; in the first week in 
June to 101,000; and in the week ending 



---

p.66




the 26th June to 28,000. The remaining 
expenditure was limited to a sum of 200,000 l. 
for the month of May, and to the rate of 
100,000 l. a-month for June, July, and the 
first fifteen days of August, when the Act 
expired. These sums were afterwards permitted to be exceeded to a certain extent, 
but the object was attained of putting a curb 
on this monstrous system and of bringing 
it gradually and quietly to a close. Great 
exertions were made, and a heavy expense 
was incurred, to leave the roads and other 
works in progress in a safe and passable state 
as far as they had gone; but their completion 
must depend upon the parties locally interested in them. From the first commencement of the Relief Works in February 1846, 
repeated warnings were given that the object 
was not the works themselves, but the relief 
of the prevailing destitution through the 
employment afforded by them; that the 
works would be closed as soon as they were 
no longer required for that purpose; and 
that if the proprietors desired to complete 
them, they might do so under the ordinary 
system of Government loans made on the 
security of county presentments.[28](javascript:footNote('E840001-002/note028.html'))




---

p.67


This system threw off a shoot, the history 
of which it is necessary to trace. In order 
to impose some limits on what threatened 
to become a gigantic system of permanently 
supporting one portion of the community at 
the expense of the remainder, and of making 
provision out of the taxes for classes of 
undertakings which properly belong to the 
economy of private life, the application of 
the public money under the Labour Rate 
Acts was strictly limited to works of a public 
character, which were not likely to be undertaken except for the purpose of giving relief. 
This condition was generally objected to in 
Ireland; and although no disposition was 
evinced to take advantage of the loans which 
the Government was ready to make under 
the General Improvement and Drainage 
Acts, a great desire was expressed that the 
funds advanced under the Labour Rate Act 
should be employed on what were called 
reproductive works. The Lord Lieutenant, 
having obtained the sanction of the Government, yielded to this general feeling, and 



---

p.68




authorized presentments to be made for the 
drainage and subsoiling of the estates of 
individuals, provided they consented to their 
estates being charged with the repayment of 
the sums advanced. This was the arrangement which acquired so much notoriety under 
the name of ‘Labouchere's Letter’ owing 
to its having been announced by the publication of a letter from Mr. Labouchere, who 
then held the office of Secretary for Ireland, 
to the Board of Works, dated 5th October, 
1846; but the result did not answer the 
expectations which had been formed. The 
aggregate amount presented ‘under the 
Letter’ was 370,607 l., of which presentments were acted on to the gross amount of 
239,476 l. The sum actually expended was 
about 180,000 l.; and the largest number of 
persons at any one time employed was 26,961 
in the month of May, 1847. Some incidental 
good was done by the example of the advantages of thorough draining, and of the proper 
mode of executing it; but, as a remedy for 
the wide-spread calamity, the plan totally 
failed.


Upon this, a two-fold agitation sprang up. 
Some landed proprietors required that their 
liability should be confined to the relief of 



---

p.69



 

the destitute on their own estates; while 
others demanded that, instead of being employed on the roads, the people should be 
paid for working on their own farms. Both 
these movements were steadily resisted by 
the Government. The objection to the first 
was, that if the inhabitants of the pauperised 
districts had been separated from the rest 
in the administration of the measures of 
relief, they must either have starved or have 
become entirely dependent on the Consolidated Fund; while, if the other plan had 
been adopted, the entire cost of carrying on 
the agriculture of the country would have 
been transferred to the Government, without 
its being possible either to test the applications for assistance, or to enforce a proper 
amount of exertion. This last scheme was 
most clamorously urged in the county of 
Clare, and it may be considered as the masterpiece of that system of social economy 
according to which the machine of society 
should be worked backwards, and the Government should be made to support the 
people, instead of the people the Government. The Government was also to provide tools and seed as well as wages, but the 
rent was to be received by the same parties 
as before.




---

p.70


Baronial presentments were authorized for 
the construction of railway earthworks, as 
relief works under the 9 & 10 Vic., c. 107, 
subject to the conditions required for the 
fulfilment of the object of the Act;[29](javascript:footNote('E840001-002/note029.html')) but advantage was taken of this permission only in two baronies of the county of Cork, 
where the Waterford and Limerick Railway 
was aided from this source.


The silver currency which had previously 
sufficed for a people who lived upon potatoes grown by themselves, and paid their 
rent by so many days' labour, fell short of 
what was required to pay the labourers employed on the numerous Relief Works carried on simultaneously in different parts of 
the country, and a large supply was therefore 
distributed, by means of a Government 
steamer, among the principal towns on the 
coast of Ireland. On the cessation of the 
Relief Works, the greater part of this coin 
accumulated in the banks, which were relieved by the transmission of the surplus to 
the Cape of Good Hope to aid in carrying 
on the Caffre war.


In the Commissariat branch of the operations,



---

p.71




every pledge which had been given 
was strictly adhered to, and confidence having been re-established, prodigious efforts 
were made by the mercantile community to 
provide against the approaching scarcity. 
The whole world was ransacked for supplies; 
Indian corn, the taste for which had by this 
time taken root in Ireland, rose to a higher 
price than wheat; and the London and 
Liverpool markets were again and again 
swept by the enterprising operations of the 
Irish dealers, who, from an early period, 
appreciated the full extent of the calamity, 
and acted upon the principle that the gulf 
which had opened in Ireland would swallow 
all that could be thrown into it, and remain 
still unsatisfied. In February 1847, the beneficial effect of these measures began to be 
apparent. On the 24th of that month, Mr. 
N. Cummins, a respectable merchant of Cork, 
wrote as follows to Mr. Trevelyan: 
  


‘From this gloomy picture I turn to the supply 
of food, and am happy to say that in this quarter 
the importations, both direct and from England, 
during the past month, have been very large; 
heavy cargoes of maize continue almost daily to 
arrive, and I feel persuaded that the stocks of 
bread stuffs generally are accumulating here to a 



---

p.72




much larger amount than some of our dealers 
would have it believed. Prices cannot, however, 
be quoted at more than a turn below the extreme 
point yet; they stand as follows, — say Indian 
corn, by retail, 17 l. 15s. and 18 l. per ton; Indian 
meal to 19 l.; oatmeal, 25 l.; wheaten meal, 19 l. 
to 20 l. per ton.’


On the 12th March, the same gentleman 
wrote, —
  


‘Our market for Indian corn seems at length 
quite glutted, the arrivals within the last few days 
having been so extremely numerous, that the trade 
is unable to take off the supply, or indeed to 
find sufficient stowage in the city. Several cargoes for discharge here are at this moment lying 
under demurrage, and I may quote the article 
15s. to 20s. per ton cheaper than a fortnight 
since.’


And on the 19th, — 
  


‘There are at present over 100 sail, containing an aggregate amount of bread stuffs not short of 20,000 tons, afloat in our harbour; and 
maize, which a month since brought freely 18 l. 
per ton, is this day offered in small parcels at 
15 l.’


And on the same day Father Matthew 
wrote to Mr. Trevelyan as follows: —Lb>

‘For the first time since the Lord visited this 



---

p.73




unhappy land with famine, I address you with 
delight. The markets are rapidly falling; Indian 
corn from 16 l. to 15 l. per ton. The vast importations, and the still more vast exportations 
from America, have produced this blessed 
effect.’


On the 26th March, Mr. Cummins states — 
  


‘I have now to report the continuance each 
day of numerous arrivals of food cargoes here; 
the additional number during the present week 
(mostly maize laden) considerably exceeds 100 
sail, several being American ships of large burthen; and although many have proceeded to 
other ports, the number afloat, waiting orders 
or sale, has been fully doubled. I cannot estimate the fleet this day in our harbours at less 
than 250 sail, nor the contents at much under 
50,000 tons. Indian corn may be purchased at 
14 l. by the cargo, and retailed at 15 l. per ton.’


It now began to be perceived that more 
was to be expected from the collective exertions of the merchants of the United 
Kingdom, than from the Admiralty or the 
Commissariat. The whole quantity of corn 
imported into Ireland in the first six months 
of 1847 was 2,849,508 qrs., which was worth, 
at the then current prices, 8,764,943l.; 
and the Irish market was, to use the words 



---

p.74




of the present Lord Lieutenant, ‘freer, 
cheaper, and better supplied, than that of 
any country in Europe where distress prevailed, and where those measures of interference and restriction had been unwisely 
adopted which were successfully resisted 
here.’ The price of Indian corn, which 
in the middle of February had been 19 l. 
a-ton, was reduced at the end of March to 
13 l., and at the end of August to 7 l. 10s. 
a-ton; and such was the quantity of shipping which flocked to the United States on 
the first intelligence of the unusual demand 
for freight, that the rate for the conveyance 
of corn to the United Kingdom, which had 
been as high as 9s. per barrel during the 
winter months, was as low as 4s. 6d. in 
May, and has since fallen to 1s. 9d. It 
may safely be asserted that these results 
would not have been obtained, if the great 
body of our English and Irish merchants 
and shipowners, instead of having free 
scope given to their exertions, had been left 
under the discouraging impression that all 
their calculations might be upset by the 
sudden appearance in the foreign market, 
of Government vessels and Government 
orders for supplies. The noble harbour of 



---

p.75



 


Cork was established as the house of call 
and entrepot for the grain ships bound to 
every part of Western Europe; and the 
merchant being now free either to sell on 
the spot or to re-export, Ireland began to 
enjoy the benefit of her admirable commercial position, by getting the first, and 
largest, and cheapest supply.


Nevertheless, the public establishments 
were not idle. Upwards of 300,000 quarters of corn were purchased from time to 
time to supply the Government depôts on 
the western coast of Ireland, and large stores 



---

p.76




of biscuit and salt meat, which had been 
laid up at the different military stations in 
the year 1843, in anticipation of popular 
disturbances arising out of the repeal movement, were now applied to the relief of the 
people. One of the consequences of the sudden change from a potato to a corn diet, was, 
that the means of grinding were seriously 
deficient. The powerful Admiralty mills at 
Deptford, Portsmouth, Plymouth, and Malta, 
besides two large hired mills, were therefore 
constantly employed in grinding the corn 
bought by the Commissariat, leaving the 
mill-power of Ireland to the private importers of grain into that country; and 
hand-mills, on the principle of the old 
Irish Quern, were made for distribution 
in the most distressed districts; while 
others, constructed on an improved principle, were procured from France. Thirty-four large depôts were established on the 
western side of Ireland, from Dunfanaghy, 
in the most northern part of Donegal, to 
Skibbereen, in the south-west of the county 
of Cork: and the sales were made, as far 
as possible, to the Relief Committees, with 
the double object of drawing forth the resources and activity of the upper classes, 



---

p.77



 

and of preventing an indiscriminate pressure upon the depôts, which it would have 
been difficult to resist. Several ships of war 
were moored in convenient situations and 
used as store-ships. The largest and most 
powerful war-steamers, reinforced, when the 
occasion required it, by sailing vessels, were 
appropriated to the conveyance of the meal 
from the mills in England to the depôts in 
Ireland, and every other available steamer, 
not excepting the Admiralty yacht, was 
employed in making the necessary transfers 
between the depôts, and in conveying the 
supplies which the Relief Committees had 
purchased.


The highest praise to which these great 
operations are entitled, is that they were 
carried through without any sensible disturbance of the ordinary course of trade, 
and that in some important respects they 
even gave new life and development to it. 
The purchases were all made in the home 
market, and care was taken never to give 
the highest current price. The sales were 
made at the wholesale price of the nearest 
large mart, with a reasonable addition for 
the cost of carriage, &c. When supplies 



---

p.78




of food could be obtained elsewhere, the 
depôts were closed. Private merchants, 
therefore, imported largely in the face of 
the Government depôts; while, in the remote western districts, the Commissariat 
acted as pioneers to the ordinary trade, 
and led the way to habits of commercial 
enterprise where before they had no existence.


There was the same general pressure for 
the premature opening of the depôts as for 
the early commencement of Relief Works, 
but in this case it was successfully resisted. 
It was explained that the Government depôts were intended to be a last resource to 
supply the deficiencies of the trade, and not 
to take the place of that trade; and that if 
the depôts were opened while the country 
was still full of the produce of the late harvest, that produce would be exported before 
the spring supplies arrived from America 
and the Black Sea, and the population would 
become entirely dependent upon the depôts, 
which must, in that case, soon come to a 
discreditable and disastrous stop. Meanwhile, great exertions were made to protect 
the provision trade, and the troops and 



---

p.79



 

constabulary were harassed by continual escorts. The plunder of bakers' shops and 
bread-carts, and the shooting of horses and 
breaking up of roads, to prevent the removal 
of provisions, were matters of daily occurrence; and at Limerick, Galway, and elsewhere, mobs prevented any articles of food 
from leaving the towns, while the country 
people resisted their being carried in. Convoys under military protection proceeded at 
stated intervals from place to place, without 
which nothing in the shape of food could be 
sent with safety.


As many as 1097 Relief Committees were 
established under the superintendence of the 
Commissariat; while 199,470 l.[30](javascript:footNote('E840001-002/note030.html')) was subscribed



---

p.80




by private individuals, and 189,914 l. 
was granted by the Government (making 
together 389,384 l.) in support of their 
operations.


One of the functions of these committees was to provide supplies of food for sale at the current market price; and when the 
rise of prices began to be seriously felt, the 
Government was called upon from every 



---

p.81




part of Ireland to permit the grants of public money made to the committees to be 
employed in reducing the price of provisions 
to that of ordinary years. To this demand 
it was impossible for the Government to 
accede. In 1845–6 the scarcity was confined 
to a few districts of Ireland, while there was 
abundance everywhere else. The question, 
therefore, at that time, was a money one; and 
all that was required to relieve the distress, 
was to purchase a sufficient quantity of food 
elsewhere and to send it into the distressed 
districts. In 1846-7, on the contrary, the 
scarcity was general, extending over all Western Europe, and threatening a famine in 
other quarters besides Ireland. The present 
question, therefore, was not a money, but 
a food question. The entire stock of food 
for the whole United Kingdom was insufficient, and it was only by carefully husbanding it, that it could be made to last till harvest. If provisions had been cheapened out 
of the public purse, consumption would have 



---

p.82




proceeded in a time of severe scarcity, at the 
same rate as in a time of moderate plenty; 
the already insufficient stock of food would 
have been expended with a frightful rapidity, 
and in order to obtain a few weeks of ease, 
we should have had to endure a desolating 
famine. Those Relief Committees which 
attempted to follow this plan speedily exhausted their capital; and private dealers 
(who necessarily lay in their stock at the 
current market price, whatever that may 
be) retired from the competition with public bodies selling food at prices artificially 
reduced by charitable subscriptions and 
grants out of national funds.


The other function of the Relief Committees was to give gratuitous aid in cases 
of extreme destitution, and this was well 
performed by them to the extent of their 
means. As the distress increased, the distribution of cooked food by the establishment of soup-kitchens was found the most 
effectual means of alleviating it. The attention of the committees was therefore generally directed to this object by the Inspecting Officers. Boilers were manufactured and sent to Ireland in great numbers, 
and Government donations were now in 



---

p.83



 

every case made equal in amount to the 
private subscriptions (‘pound for pound’), 
and in cases of more than usual pressure, 
twice or three times that amount was given. 
This mode of giving relief was not found to 
be attended with any serious abuse. The 
committees expended in a great measure 
their own money, which made them more 
careful in seeing that it was laid out with 
the greatest possible advantage and economy; and as the ration of cooked food 
distributed by them was not an object of 
desire to persons in comfortable circumstances, as money wages were, it acted 
in a great degree as a test of destitution. 
The defect of this system of relief was, 
that being voluntary, it could not be relied 
on to meet the necessities of a numerous 
population in a period of great emergency, 
and the difficulty of obtaining private subscriptions was often greatest in the most 
distressed districts. 


The point at which we had arrived, therefore, at the commencement of the year 1847, 
was, that the system of Public Works, 
although recommended by the example of all 
former occasions on which relief had been 
afforded to the people of Ireland in seasons 



---

p.84




of distress, had completely broken down 
under the pressure of this wide-spread calamity; while the other concurrent system, 
which, on the principle of the Poor Law, 
aimed at giving relief, in the most direct 
form, out of funds locally raised, had succeeded to the extent to which it had been 
tried. The works were therefore brought 
to a close in the manner which has been 
already described: and it was determined to 
complete the system of relief by the distribution of food, to give it legal validity, and 
to place it more decidedly on the basis of the 
Poor Law. This was done by the passing 
of the Act 10 Vic., c. 7. A Relief Committee, 
composed of the magistrates, one clergyman 
of each persuasion, the Poor Law guardian, 
and the three highest rate-payers, was constituted in each electoral division,[31](javascript:footNote('E840001-002/note031.html')) the unit 
of Irish Poor Law statistics. A Finance 
Committee, consisting of four gentlemen, 
carefully selected for their weight of character 
and knowledge of business, was formed to 
control the expenditure in each union. Inspecting Officers were appointed, most of 



---

p.85



 

whom had been trained under the Board of 
Works and **Sir R. Routh**; and a Commission 
sitting in Dublin, of which **Sir J. Burgoyne** 
was the head, and the Poor Law Commissioner was one of the members, superintended 
the whole system. The expense was to be 
defrayed by payments made by the guardians out of the produce of the rates; and 
when this fund was insufficient, as it always 
proved to be, it was reinforced by Government loans, to be repaid by rates subsequently 
levied. Free grants were also made in aid of 
the rates in those unions in which the number of destitute poor was largest, compared 
with the means of relieving them, and when 
private subscriptions were raised, donations 
were made to an equal amount.


The check principally relied on, therefore, 
was, that the expenditure should be conducted, either immediately or proximately, 
out of the produce of the rates. No loan was 
to be made to any Board of Guardians until 
the Inspecting Officer had certified that they 
had passed a resolution to make the rate 
upon which it was to be secured, and that, 
to the best of his belief, they were proceeding with all possible dispatch to make 



---

p.86




and levy such rate. This principle, although 
still imperfectly applied, and consequently 
irregular in its action, exercised a pervading 
influence over the working of this system of 
relief. In forming the lists of persons to be 
relieved, and making their demands upon 
the Commissioners, few committees altogether rejected the idea that it was their own 
money which they were spending; and in 
some districts the farmer rate-payers assembled, and insisted on large numbers of persons 
being struck off the lists, who they knew 
were not entitled to relief. The tests applied 
to the actual recipients of relief were, that 
the personal attendance of all parties requiring relief was insisted on, exceptions being 
made in favour of the sick, impotent, and 
children under nine years of age, and that 
the relief was directed to be given only in 
the shape of cooked food, distributed in 
portions declared by the best medical authorities to be sufficient to maintain health and 
strength. The ‘cooked food test’[32](javascript:footNote('E840001-002/note032.html')) was 



---

p.87



 

found particularly efficacious in preventing 
abuse; and the enforcement of it in some 
parts of the country cost a severe struggle. 
Undressed meal might be converted into 
cash by those who did not require it as food; 
and even the most destitute often disposed 
of it for tea, tobacco, or spirits; but stirabout, which becomes sour by keeping, has 
no value in the market, and persons were 
therefore not likely to apply for it, who did 
not want it for their own consumption. 
Attempts were made to apply the labour test 
to this system of relief; but, besides the 
practical difficulty of want of tools and proper 
superintendence, the Commissioners considered that, owing to the absence of any adequate motive, it would ‘lead to a want of exertion on the part of the men which would 
perhaps be more demoralising than relief 
without any work.’ It was therefore left to 
the Relief Committees in large towns and 



---

p.88




other situations favourable to such a mode of 
proceeding, to take their own course upon 
it; and the result was, that some light kinds 
of labour, such as cleaning the streets and 
whitewashing the cabins, were exacted by a 
few of the more zealous and active committees. Relief in aid of wages was strenuously insisted on by many of the Relief 
Committees, and was steadily and successfully resisted by the Commission; but it 
was not considered right, in the administration of a temporary measure, to require 
the surrender of the land held by applicants, 
provided they were proved to be at the time 
in a state of destitution.


This system reached its highest point in 
the month of July, 1847, when out of 2,049 
electoral divisions, into which Ireland is 
divided, 1,826 had been brought under the 
operation of the Act, and 3,020,712 persons 
received separate rations, of whom 2,265,534 
were adults, and 755,178 were children. 
This multitude was again gradually and 
peaceably thrown on its own resources at 
the season of harvest, when new and abundant supplies of food became available, and 
the demand for labour was at its highest 



---

p.89



 

amount. Relief was discontinued to fifty-five 
unions on the 15th August, and the issues 
to the remaining unions entirely ceased on 
the 12th September. The latest date allowed 
by the Act for advances to be made, was 
the 1st October.


This was the second occasion on which 
upwards of three millions of people had been 
fed ‘out of the hands of the magistrate,’ 
but this time it was effectual. The Relief 
Works had been crowded with persons who 
had other means of subsistence, to the exclusion of the really destitute; but a ration 
of cooked food proved less attractive than 
full money wages, and room was thus made 
for the helpless portion of the community. 
The famine was stayed. The ‘affecting and 
heart-rending crowds of destitutes’[33](javascript:footNote('E840001-002/note033.html')) disappeared from the streets; the cadaverous, 
hunger-stricken countenances of the people 
gave place to looks of health; deaths from 
starvation ceased; and cattle-stealing, plundering provisions, and other crimes prompted 
by want of food, were diminished by half in 
the course of a single month. The Commission



---

p.90




closed amidst general applause, and 
‘Resolutions were received from many hundreds of the committees, praising the conduct of the inspecting officers, and frankly 
and honourably expressing their gratitude 
to Government and the Legislature for the 
effective means afforded them for carrying 
out this benevolent operation.’[34](javascript:footNote('E840001-002/note034.html')) This 
enterprise was in truth the ‘grandest 
attempt ever made to grapple with famine 
over a whole country.’[35](javascript:footNote('E840001-002/note035.html')) Organised armies, 
amounting altogether to some hundreds of 
thousands, had been rationed before; but 
neither ancient nor modern history can 
furnish a parallel to the fact that upwards of 
three millions of persons were fed every day 
in the neighbourhood of their own homes, 
by administrative arrangements emanating 
from and controlled by one central office. 


The expense was moderate compared 
with the magnitude of the object. The 
amount at which it was originally estimated 
by the Commissioners was 3,000,000 l.; the 
sum for which Parliament was asked to 



---

p.91



 

provide was 2.200,000 l., and the sum actually 
expended was 1,557,212 l., of which 146,631 l. 
was paid to the Commissariat for meal supplied to the Relief Committees from the 
Government Depôts. The price of meal 
fortunately fell more than one-fifth during 
the progress of these operations, or from 
2 1/2d. a ration, to less than 2d., including all 
expenses of establishment. 


The Finance Committees, which were 
selected bodies, consisting of from two to 
four gentlemen in each union, ‘with rare 
exceptions acted with zeal and intelligence.’[36](javascript:footNote('E840001-002/note036.html')) The Relief Committees, a miscellaneous body 
composed of the foremost persons in each 
petty district, whoever they might be, showed, 
as was to be expected, every variety of good 
and bad conduct. In some cases the three 
highest rate-payers could not read, and even 
themselves established claims to be placed 
on the list of destitute for daily rations. It 
is a fact very honourable to Ireland, that 
among upwards of 2000 local bodies to whom 
advances were made under this Act, there 
is not one to which, so far as the Government is informed, any suspicion of embezzlement attaches.




---

p.92


In order to check the progress of the 
fever, which, as usual, followed in the train 
of famine, the Act 10 Vic., c. 22 was passed, 
by which the Relief Committees were empowered to attend to the proper burial of 
the dead, to provide temporary hospitals, to 
clear away nuisances, and to ventilate and 
cleanse cabins, the necessary funds being 
advanced by the Government in the same 
manner as the advances for providing food. 
These sanitary arrangements were extensively 
acted upon and at moderate expense. On 
the 17th August 326 hospitals and dispensaries had been authorized, with accommodation for more than 23,000 patients, with 
medical officers, nurses, ward-maids, &c. 
The additional expense incurred under this 
Act, was 119,055 l., the whole of which was 
made a free grant to the unions, in aid of 
rates. 


The state of the finances of some of the 
unions was a source of deep anxiety through 
the winter and spring of 1846–7. Rates 
were not collected sufficient to defray the 
current expenses of the workhouses of these 
unions, and the guardians threatened to turn 
the inmates into the street, if assistance 
were not given from the public purse. The 



---

p.93



 

dilemma was a painful and perplexing one. 
There was no reason to doubt the readiness 
of some of the persons who held this language 
to put their threat into execution; while, to 
admit the claim, might bring upon the Government the greater number of the workhouses, in addition to the whole of the outdoor 
relief; in other words, would transfer to national funds a burden intended by law to be 
local, and not likely to be administered with 
economy on any other footing. Important 
aid was, however, given. Large supplies of 
clothing were collected from the stores of 
the army and navy, and sent to Ireland for 
the use of the workhouses. Small sums 
of money, amounting in the aggregate to 
23,503 l., were lent from time to time with 
a sparing hand to assist the guardians in 
providing food and clothing in the most 
pressing and necessitous cases; 4,479 l. was 
expended in providing proper medical inspection and superintendence in localities in 
which great sickness prevailed; and 60,000 l. 
was advanced for the enlargement of the 
workhouses, principally by the erection of 
fever-wards.


The improvement of the Fisheries on the 
western coast of Ireland has always been an 



---

p.94




object much pressed upon the Government. 
In order to give the fishermen a motive for 
exertion, and to set them an example of improved modes of preparing the fish for sale, 
experienced curers were obtained from the 
Fishery Board in Scotland; six stations were 
formed, at which fish are purchased at a fair 
market-price, cured, and sold again for consumption to the highest bidder; and supplies of salt and tackle were provided for sale to the fishermen. This was done without any expense to the public, by means of 
a sum of 5000 l. placed at the disposal of 
the Government out of the balance of the 
subscription for the relief of Irish distress in 
1822.


The plan of making small loans to fishermen to enable them to equip themselves for 
their trade, was not resorted to, because 
experience had proved that the fishermen 
are induced by it to rely upon others, instead 
of themselves, and that they acquire habits 
of chicanery and bad faith in their prolonged struggle to evade the payment of 
the loans. **Sir J. Burgoyne** had authority 
given him by the British Relief Association, 
to apply 500 l. to this object, and he induced the Relief Committee of the Society 



---

p.95



 

of Friends to take up the same cause. ‘I 
have made,’ he states, ‘many inquiries for 
the purpose, but I have always made it a 
point that there should be a decided prospect of any advances being repaid, and here 
the matter hangs. The officers all report 
that they doubt being able to get the money 
back; and I think it so necessary to be firm 
on this point, that I have not made use of 
a penny of the 500 l., and have recommended 
the Friends to reserve their funds also for 
a better mode of expending them.’ Since 
then, the Society of Friends, who are able to 
give a more particular attention to such subjects than it is possible for the Government 
to do, have done much good by assisting 
poor fishermen to redeem their nets and 
other implements of their trade, which they 
had pawned during the season of extreme 
distress; and these excellent people have 
also adopted an admirable plan of providing 
good boats and all requisite gear, with a 
competent person to instruct the native 
fishermen, who are formed into companies 
or partnerships and work out the value of 
the boats, &c, of which they may then 
become the owners. A large supply of 
seamen's jackets and trousers, obtained 



---

p.95




from the Admiralty, was delivered to the 
Society of Friends, for distribution among 
the poor fishermen on the west of Ireland.


From the first failure of the potato crop 
in 1845, the subject of providing seed was 
repeatedly considered, and the conclusion 
invariably arrived at was, that the moment 
it came to be understood that the Government had taken upon itself the responsibility 
of this delicate and peculiar branch of rural 
economy, the painful exertions made by private individuals in every part of Ireland to 
reserve a stock of seed would be relaxed, 
and the quantity consumed as food in consequence of the interference of the Government, would greatly exceed the quantity 
supplied by means of that interference. 
The Government therefore never undertook 
to supply any kind of seed already in extensive use; but Holland was had recourse to 
for flax and rye seed, Scotland for the hardy 
description of barley called bere, and England and the neighbouring Continental countries furnished turnip, carrot, beet-root, and 
other vegetable and green-crop seeds; all of 
which were sent to Ireland for sale at low 
prices, and latterly for gratuitous distribution. More than thirteen tons of turnip seed 



---

p.97



 

belonging to the Government and the British 
Relief Association were distributed in the 
county of Mayo alone[37](javascript:footNote('E840001-002/note037.html')), besides 125 hogsheads of flax seed; by which means, in 
addition to the present supply of food 
obtained, a foundation was laid for an 
improved system of agriculture by a rotation of crops. One of the remedial measures proposed by the Government at the 
commencement of the parliamentary session 
of 1847, was to make loans to landed proprietors to the aggregate amount of 50,000 l. 
to enable them to provide their tenants with 
seed, which loans were to have been repaid 
out of the produce of the crops raised from 
the seed; but nobody availed himself of this 
boon. The objections which exist to the 
Government leaving its province to interfere in the ordinary business of private life, 
were in nothing more clearly demonstrated 


---

p.98




than in what took place in reference to this 
subject. The accidental detention, by contrary winds, of a vessel laden with rye and 
bere seed, called forth expressions of anger 
and disappointment from various parts of 
the west and south of Ireland which had 
depended upon this supply; and the unfounded belief that the Government had 
entered upon a general undertaking to provide seed corn, largely contributed to that 
criminal apathy which was one of the causes 
of large tracts of land being left waste in 
1846–47. On the other hand, it was found, 
when inquiries were made for vegetable seeds 
in the spring of 1847, that every ounce of 
parsnip seed in the London market had been 
already bought up and sent to Ireland; 
which is only one instance among many that 
might be adduced, of the reliance which may 
be placed on private interest and enterprise 
on occasions of this sort.[38](javascript:footNote('E840001-002/note038.html'))




---

p.99


There is still another measure which does 
not the less deserve to be mentioned, because it ended in failure. The Act 9 & 10 
Vic. c. 109, passed at the close of the session 
of 1846, had appropriated a sum of 50,000 l. 



---

p.100




to be granted in aid of public works of 
acknowledged utility, one-half of the expense 
of which was to be provided for by a loan, 
and another portion was to be contributed 
in cash by the persons principally interested 



---

p.101



 

in the works. No application was made to 
participate in the advantage of this arrangement, and the 50,000 l. was therefore transferred in the next session of Parliament to 
the erection of Fishery Piers and other useful 
objects.


The qualities displayed by the officers 
intrusted with the conduct of these great 
operations, will always be regarded as a 
bright spot in the cloud which hangs over 
this disastrous period. The nation had 
never been better served. The administrative ability which enabled **Sir R. Routh** to dispose, without hurry or confusion, of 
masses of business which to most persons 
would have been overwhelming; the stoutness



---

p.102




of heart with which Colonel Jones 
commanded, and ultimately disbanded his 
army of 740,000 able-bodied Irishmen; the 
admirable sagacity displayed by **Sir J. Burgoyne** in coming to a safe practical decision 
upon perplexed social questions, then perhaps for the first time presented to him; 
the remarkable financial ability of Mr. Bromley, the accountant to the Relief Commission; the cordial co-operation of Admiral 
Sir Hugh Pigot and his able secretary, Mr. 
Nicholls, and the valuable assistance rendered in many different ways by Colonel 
Mac Gregor, the head of the Constabulary 
Force, proved that, however great the crisis 
might be, the persons in chief trust were 
equal to it.[39](javascript:footNote('E840001-002/note039.html')) But the most gratifying feature 
of all, was the zeal and unanimity with which 
the large body of Officers employed devoted 
themselves to this labour of love,[40](javascript:footNote('E840001-002/note040.html')) although 



---

p.103



 

they had been suddenly brought together for 
this particular occasion from many different 
branches of the public service, or from the 
retirement of private life. It may truly be 
said of them, that they ‘offered themselves 
willingly among the people;’ and several 
painful casualties from the prevailing fever, 
and the failing health of others, showed 
that the risks and hardships attending this 
service were of no ordinary kind. The 
officers and men belonging to the numerous ships of war employed in the ‘Relief 
Service,’ entered with characteristic spirit 
upon duties which indicated in a more direct 
manner than ever before, that the real object of their noble profession, is, not to 
destroy men's lives, but to save them; and 
it was creditable to their seamanship, as well 
as their humanity, that the dangers and 
hardships attending their incessant employment on the exposed western coasts of Ireland and Scotland during the stormy months 



---

p.104




of winter, did not lead to the loss of a single 
vessel.[41](javascript:footNote('E840001-002/note041.html'))




---

p.105


A slight reference to the exertions which 
had to be made for the single object of conducting and checking the expenditure, will 
give some idea of the magnitude and difficulty of the task which was imposed on the 
officers of the Crown.


In establishing a system of Relief Works, 
intended to bring employment to every 
man's door, it was impossible to avoid 
creating an extensive staff for the superintendence and payment of the labouring 
poor. Very voluminous accounts suddenly 
poured into the Office of Works from all 
parts of Ireland; and as the lives of thousands depended upon the supply of funds, 
is became a duty of the first importance to 
insure their immediate distribution over the 
whole surface of the country. Remittances 
were made to about 600 pay clerks weekly, 
and it was often found necessary to transfer 
from one to the other sums of money upon 
the authority of local officers, whereby an 
intermixture of accounts of a very intricate 
description took place. The weekly accounts sent to the office at Dublin exceeded



---

p.106




20,000, and the pay lists were more 
than a quarter of a million in number, the 
expenditure being at one time at the rate 
of a million a-month. To watch the distribution of such large sums would have been a gigantic task, even for a long-established and well-organized department, but 
for a temporary establishment, composed, 
for the most part, of persons with little, 
if any, previous knowledge of business, the 
duty was one of unprecedented difficulty, 
and it is a matter of surprise that greater 
irregularity was not the consequence.


In the books of the temporary Relief 
Commission, it was found necessary to open 
accounts with more than 2000 bodies intrusted with the expenditure of public 
money; and such was the rapidity of the 
service, that within a period of five months, 
more than 19,000 estimates were received 
in the accountant's office, and acted upon, 
with a like number of accounts, which 
were registered for examination, and more 
than 17,000 letters were received and 
answered. The pecuniary transactions of 
this Commission were not with public 
officers, but with ephemeral bodies composed of persons generally unused to business,



---

p.107



 

and almost irresponsible; but the 
utmost good faith prevailed; and by requiring an immediate account, with vouchers, 
every fortnight, of the disbursement of the 
previous amount remitted, with the balance remaining on hand, before a further 
supply was sent down, the best control 
upon the expenditure was established, and 
the result has been the great saving (more 
than half a million) effected, while scarcely 
an instance of misappropriation has occurred. It has also been admitted in many 
parts of Ireland, that these accounts, and 
the instructions for their preparation, have 
induced habits of business that never before 
existed, while at the same time they have 
urged the Stamp Laws into more active 
operation. 


The prompt examination and audit of 
the accounts of the Board of Works, the 
Commissariat, and the Relief Commission, was provided for by the deputation 
of experienced persons from the offices in 
London, under whose superintendence the 
whole of the expenditure has been subjected to a searching local revision, and 
wherever any symptom of malversation has 
appeared, the matter has been probed to the 
bottom.




---

p.108


It has been a popular argument in Ireland, 
that as the calamity was an imperial one, the 
whole amount expended in relieving it ought 
to be defrayed out of the Public Revenue. 
There can be no doubt that the deplorable 
consequences of this great calamity extended 
to the empire at large, but the disease was 
strictly local, and the cure was to be obtained 
only by the application of local remedies. 
If England and Scotland, and great part of 
the north and east of Ireland had stood 
alone, the pressure would have been severe, 
but there would have been no call for assistance from national funds. The west and 
south of Ireland was the peccant part. The 
owners and holders of land in those districts 
had permitted or encouraged the growth of 
the excessive population which depended 
upon the precarious potato, and they alone 
had it in their power to restore society to 
a safe and healthy state. If all were interested in saving the starving people, they 
were far more so, because it included their 
own salvation from the desperate struggles 
of surrounding multitudes phrenzied with 
hunger. The economical administration of 
the relief could only be provided for by 
making it, in part at least, a local charge. 



---

p.109



 

In the invariable contemplation of the law, 
the classes represented by the rate payers 
have to bear the whole burden of their own 
poor; the majority of the British community did so bear it throughout this year of 
distress; and, besides fulfilling their own 
duties, they placed in the hands of the 
minority the means of performing theirs, 
requiring them to repay only one half.


A special objection has been raised to the 
repayment of the advances for the Relief 
Works, on the ground that their cost exceeds that for which they could now be 
constructed. The answer to this is, that 
these works were undertaken solely for the 
purpose of giving employment in a great and 
pressing emergency, when it was impossible 
for them to be executed with the same care 
and economy as in ordinary times;[42](javascript:footNote('E840001-002/note042.html')) that the 
counties are therefore chargeable with them, 
not as works, but as relief; and that if they 
had cost either half as much, or twice as 
much as they did, the liability would have 



---

p.110




been the same. But when it is remembered that the expensive character of the 
works was in a great degree owing to the 
Board of Works not having received from 
the Presentment Sessions and the Relief 
Committees that assistance in keeping down 
the expenditure, which it was the duty of 
those bodies to have rendered, both by 
making a proper selection of the works to 
be undertaken, and by confining their recommendations for employment on them to 
those persons who were really destitute, it is 
a matter of surprise that any answer has been 
rendered necessary.


We should probably have heard less of 
these repayments if it had been generally 
known what their real amount is. The sum 
expended under the first Relief Works Act 
(9 & 10 Vic. c. 1) was 476,000 l., one half of 
which was grant, and the other half is to be 
repaid[43](javascript:footNote('E840001-002/note043.html')) by twenty half-yearly instalments, amounting on an average, including interest, to about 12,500 l. each. The expenditure 
under the second Act (9 & 10 Vic. c. 107) 
was about 4,850,000 l., half of which was 
remitted, and the other half is repayable 




---

p.111




by twenty half-yearly instalments of 145,500 l. 
each, including interest. The annual addition 
made to the Rates by the repayments under 
the two Acts relating to the Relief Works 
is therefore about 316,000 l.;[44](javascript:footNote('E840001-002/note044.html')) while, by an 
Act passed on the 28th August, 1846, the 
Rates were relieved from an annual payment 
of 192,000 l., being the remaining half of the 
expense of the Constabulary, the other half 
of which was already defrayed out of national funds. The additional charge upon 
the Rates, therefore, amounts only to 124,000 l. 
a-year for ten years, or 1,240,000 l. in all. 
The sum advanced under the 9 & 10 Vic. c. 
2, on the security of grand jury presentments, was 130,000 l., which will have to 
be repaid in various periods extending from 
three to ten years; but the expenditure 
under this Act was merely in anticipation 
of the usual repairs of the public roads, 
the cost of which is in ordinary years 
raised within the year without any advance. 
Lastly, the sum expended in the distribution of food under the 10 Vic. c. 7, and in 



---

p.112




medical relief under the 10 Vic. c. 22, was 
1,676,268 l., of which 961,739 l. is to be 
repaid, and the remaining 714,529 l. is a free 
grant. The first-mentioned Act included 
a fund for making grants as well as loans, 
and the demands for repayment have been 
adjusted as nearly as possible according to 
the circumstances of each district. In some 
of the western unions, where the amount of 
destitution bears the largest proportion to 
the means of the rate-payers, and, owing to 
the extent to which the potato was formerly 
cultivated, a painful period of transition has 
yet to be endured, only a small part of the 
sum expended is required to be repaid;[45](javascript:footNote('E840001-002/note045.html'))


---

p.113



 

while in other unions where the return of 
low prices has restored society to its ordinary 
state, grants have been confined to those 
cases in which the expenditure has exceeded 
a rating of three shillings in the pound on 
the valuation. 


All the claims of the Exchequer, arising 
out of the Relief operations of 1846 and 
1847 have now been described, and it must 
be borne in mind that the several localities 
received full value for what they have to 
pay. They were saved from a prolonged 
and horrible state of famine, pestilence, and 
anarchy, which was the main consideration; 
and they had, besides, the incidental advantage of the labour bestowed upon the Roads 
and other public works, especially in the 
poor and wild districts of the West, where 
lines of road have been opened with the 
aid of the relief grants and loans, which, 
although much wanted, could not have been 
undertaken for years to come without such 
assistance. The rest of the expenditure, 
including the large donations made to Relief 
Committees previously to the passing of the 
Act 10 Vic. c. 7, the cost of the staff of the 
Board of Works and of the Relief Commission, the Commissariat staff, and the heavy 



---

p.114




naval expenditure, has been defrayed out of 
the public purse; without any demand for 
repayment.


Hitherto our narrative has been confined 
to what was done by the Government, but 
the voluntary exertions of private individuals 
contributed their full share towards this 
unprecedented act of public charity.


It is highly to the honour of our countrymen in India, that the first combined movement in any part of the British empire was made by them. On the arrival of the news 
of the first failure of the potato crop in the 
Autumn of 1845, a meeting, presided over 
by Sir John Peter Grant, was held at Calcutta, on the 2nd of January, 1846, for the 
purpose of concerting measures to raise a 
fund for the relief of the expected distress; 
and a committee, consisting of the Duke of 
Leinster, the Protestant and Roman Catholic 
Archbishops of Dublin, and six other persons, was solicited to act in Ireland as Trustees for the distribution of such sums as 
might be subscribed. This example was 
followed at Madras and Bombay, and the 
result was that a sum of 13,920 l., contributed as follows, was placed at the disposal 
of the committee: 



---

p.115



 

Bengal: 8,200
  

Bombay: 2,976
  

Madras: 1,150
  

Ceylon: 718
  

Hong Kong, 18th Royal Irish: 82
  

Mobile, U. S.: 192
  

Toronto, C. W.: 300
  

England, including 200 l. from **Lord John Russell**: 302
  

£13,920.


The whole of this sum was distributed 
between the 24th of April and the 21st of 
December, 1846, and was entirely independent of the large subscriptions from different 
parts of British India subsequently added to 
the funds of other societies. More than 
2000 letters were received by the Trustees 
of the Indian Relief Fund; and by a strict 
attention to economy, they were enabled to 
distribute 13,920 l. at an expense of 180 l.


In the United Kingdom, the Society of 
Friends were, as usual, first in the field of 
benevolent action. When the renewed and 
more alarming failure of the potato crop in 
the autumn of 1846 showed the necessity 
for serious exertion, a subscription was 
opened by them in London in the month 



---

p.116




of November in that year; members of the 
Society were sent on a deputation to Ireland, and those who resided there aided by 
their personal exertions and local knowledge. On the 6th January, 1847, a committee, of which Mr. Jones Loyd was chairman, and Mr. Thomas Baring and Baron 
Rothschild were members, invited contributions under the designation of the ‘British 
Association for the Relief of extreme Distress in Ireland and the Highlands and 
Islands of Scotland.’ On the 13th of 
January, 1847, a Queen's Letter was issued 
with the same object, and the 24th of 
March was appointed by proclamation, for 
a General Fast and Humiliation before 
Almighty God, ‘in behalf of ourselves and 
of our brethren, who in many parts of this 
United Kingdom are suffering extreme famine and sickness.’ A painful and tender 
sympathy pervaded every class of society. From the Queen on her throne to the convicts in the hulks, expenses were curtailed, and privations were endured, in order to 
swell the Irish subscription. The fast was 
observed with unusual solemnity, and the 
London season of this year was remarkable 
for the absence of gaiety and expensive 



---

p.117



 

entertainments. The vibration was felt 
through every nerve of the British Empire. The remotest stations in India, the 
most recent settlements in the backwoods 
of Canada, contributed their quota, and 
652 l. was subscribed by the British residing in the city of Mexico, at a time when 
their trade was cut off, and their personal 
safety compromised by the war with the 
United States. The sum collected under 
the Queen's letter was 171,533 l. The 
amount separately contributed through the 
British Association was 263,251 l.[46](javascript:footNote('E840001-002/note046.html')); and this 



---

p.118




aggregate amount of 434,784 l., was divided 
in the proportion of five-sixths to Ireland 
and one-sixth to Scotland. But besides 



---

p.119




this great stream of charity, there were a 
thousand other channels which it is impossible to trace, and of the aggregate result 



---

p.120




of which no estimate can be formed. There 
were separate committees which raised and 
sent over large sums of money. There 
were ladies' associations without end to 
collect small weekly subscriptions and make 



---

p.121



 

up clothes to send to Ireland. The opera, 
the fancy bazaar, the fashionable ball rendered tribute; and, above all, there were the private efforts of numberless individuals, each acting for himself and choosing his 



---

p.122




own almoners, of which no record exists 
except on High. Upon application being 
made to the managers of the Provincial 
Bank of Ireland to permit English charitable remittances to pass without the usual 
charge, it turned out that they had been in 
the habit of doing so for a considerable 
time, and that the amount sent through 
that one channel, in the six months ending 
on the 4th March, 1847, exceeded 20,000 l. 
In the contemplation of this great calamity, 
the people of the United States of America 
forgot their separate nationality, and remembered only that they were sprung from the 
same origin as ourselves. The sympathy 
there was earnest and universal, and the 
manifestations of it most generous and 
munificent. The contributions from this 
land of plenty consisted principally of Indian corn and other kinds of provisions, 
and the cargoes were, for the most part, 
consigned to the Society of Friends, whose 
quiet, patient, practical exertions, commanded universal confidence. The freight 
and charges on the supplies of food and 
clothing sent to Ireland by charitable societies and individuals, as well from the 
United States and Canada on the one side, 



---

p.123



 

as from England on the other, were paid 
by the Government, to an amount exceeding 50,000 l.[47](javascript:footNote('E840001-002/note047.html'))

; all customs dues were remitted, and the meal and other articles were to a great extent taken charge of by 



---

p.124




the officers of the Commissariat, and held 
by them at the disposal of the parties to 
whom they had been consigned for distribution;



---

p.125



 

by which means the necessary harmony was preserved between the operations 
of the Government and those of the private 
associations, and the bounty of the subscribers reached the destitute persons for whom 
it was intended, with as small a deduction 
as possible for incidental expenses. Thus, 
when the British Association was desirous 
of giving the cultivators on the Western 
Coast of Ireland an opportunity of purchasing seed at a low market price at the close 
of the sowing season of 1847, five large 
steamers were collected by the Government, 
which were loaded in a remarkably short 
space of time, with oats and other seed 
provided by the Association, and were sent 
forth, each to its appointed section of the 
Western Coast; so that every harbour accessible to a steamer, from Kinsale to Londonderry, was looked into, and what remained unsold was left in the Government 
depôts for subsequent sale or gratuitous 
distribution. On the other hand, the 
Government received much assistance and 
support from the operations of these benevolent societies, and they were especially 
useful in bridging over the fearful interval 
between the system of relief by work and 



---

p.126




relief by food. Several gentlemen, with a 
noble self-devotion, volunteered their services to the British Association, among 
whom **Lord Robert Clinton**, **Lord James 
Butler**,  **Count Strzelecki**, and Mr. Higgins, 
were distinguished by their zeal and ability, 
and by the fortitude with which, for months 
together, they endured the pain and risk 
attending the immediate contact with hunger and disease.


A large committee, with the Marquis of 
Kildare at its head, was formed in Dublin 
under the name of the ‘General Central 
Relief Committee for all Ireland’ the contributions received by which amounted to 
upwards of 50,000 l., independently of 
10,000 l. in cash and an equal value in food, 
entrusted to this committee from the sum 
raised by the Queen's Letter. British North 
America contributed through this medium 
the munificent sum of 12,463 l., including 
5,873 l. from Montreal; 1571 l. from Quebec; 
and 3,472 l. from Toronto. The United 
States gave 5,852 l., of which 3,199 l. was 
from New Orleans. British India 5,674 l.; 
the Cape of Good Hope 2,900 l.; Australia 
2,282 l.; South America 772 l.; the Military 
386 l.; Scotland, France, Germany, Italy, 



---

p.127



 

Belgium, Gibraltar, the Channel Islands, 
West Indies, the Ionian Islands, &c., 
2,168 l.; Ireland, independently of local subscriptions, which were very considerable, 
9,888 l.; and England, over and above the 
20,000 l. remitted from the produce of the 
Queen's Letter, 8,886 l.


Subscriptions were received to a smaller 
amount, but from an earlier period of the 
distress, by another committee established in 
Dublin under the name of the ‘Irish Relief 
Association for the Destitute Peasantry,’ 
which was announced to be a reorganization 
of the Association formed during the period 
of famine in the West of Ireland in 1831. 
The list of patrons commenced with the 
names of the Archbishop of Dublin and the 
Duke of Manchester; and, independently of 
some cargoes of corn, flour, &c., from 
Canada and the United States, the funds 
placed at their disposal amounted to nearly 
42,000 l., among the contributions to which, 
the following were conspicuous: — England, 
17,782 l.; Ireland, 6,151 l.; France, 1,390 l.; 
Italy, including 1,481 l. from Rome, 2,708 l.; 
British North America, 2,821 l. (1,165 l. of 
this being from Quebec); United States, 
847 l.; India, 5,947 l., of which the large proportion



---

p.128




of 4,981 l. was from Madras; West 
Indies, 1,043 l.; Australia, 2,314 l.; and from 
the officers and men of various regiments, 
and the pensioners and constabulary, 508 l.


But the most considerable of the Dublin 
Charitable Committees was that composed 
of members of the Society of Friends, of 
which **Mr. Joseph Bewley** and **Mr. Jonathan Pim** were the Secretaries. The contributions placed at their disposal since the 
3rd of December, 1846, in money and provisions, have been to the amount of upwards 
of 168,000 l., of which no less than 108,651 l. 
is the estimated value of provisions (7,935 
tons) consigned to them from the United 
States of America. Of the subscriptions in 
money, 35,393 l. was remitted by the London 
Committee of the Society of Friends; 8,494 l. 
by members of the Society and others in 
Dublin; and the large sum of 15,567 l. by 
persons residing in the United States. The 
provisions received from America were as 
follows: — 
1. From New York, 4,496 tons, estimated value 58,299 l. 15s.
2. From Philadelphia, 1,870.25 tons, estimated value 24,948 l. 18s.
3. From New Orleans, 349 tons, estimated value 7,538 l. 5s.


---

p.129

6. From Newark. N. J., 316.75 tons, estimated value 5,141 l.
7. From Baltimore, 316.5 tons, estimated value 3,913 l. 10s.
8. From Richmond, V., 252.5 tons, estimated value 3,486 l. 15s.
9. From Charleston, 169 tons, estimated value 2,362 l.
10. From Alexandria, V., 102 tons, estimated value 1,422 l.
11. From sundry other Ports, Unites States, America, 117 tons, estimated value 1,518 l.



And in addition to these large donations of 
money and food, consignments of clothing 
were received from England and America, 
to the estimated value of from 5,000 l. to 
10,000 l.


The ladies of Ireland exerted themselves 
with characteristic zeal and benevolence, to 
alleviate the sufferings of their country-people, and to promote their moral advancement, by awakening and encouraging a spirit 
of independent exertion, and fostering habits 
of industry and self-reliance. The **Ladies Relief Association for Ireland** in the management of which the Honourable Mrs. 
Newcombe takes the principal part, and the 
objects of which are ‘to encourage industry among the female peasantry of Ireland, to contribute towards providing nourishment 



---

p.130




for the sick, and to procure clothing for the 
destitute’, raised 11,465 l. previously to the 
1st of August, 1847, of which 3,043 l. was 
derived from the proceeds of a Fancy Bazaar 
in London, and of this sum 2,500 l. was 
appropriated to the relief of families whose 
husbands or fathers ‘have been removed 
while performing their painfully laborious 
duties.’ The **Ladies' Industrial Society 
for the Encouragement of Remunerative 
Labour among the Peasantry of Ireland**, of 
which Mrs. Lloyd is the active promoter, 
more particularly aims at encouraging the 
manufacture of those articles which are 
likely to find a ready sale in the trade; for 
which purpose, instruction is given in the 
best and most practicable descriptions of 
remunerative labour; patterns, models, and 
implements are furnished, and a sale is 
provided for the produce, through the 
intervention of a mercantile agency in 
Dublin. Numerous benevolent persons 
adopted the same course in various parts of 
Ireland, sometimes in connection with these 
societies, and sometimes using their own 
means, with such aid as was sent to them 
by their private friends. Mr. Gildea, the 
Rector of Newport, and the ladies of his 



---

p.131



 

family, revived the manufacture of coarse 
linen at that place, and they have employed 
between 500 and 600 females since the beginning of January, in the execution of 
orders sent them by charitable persons.[48](javascript:footNote('E840001-002/note048.html'))
The ladies of the Presentation Convent at 
Galway gave every day a good meal of porridge to upwards of 600 starving children 
who attended their schools. The ladies of 
the Owen more Relief Committee raised and 
expended in various works of charity, 2,427 l., 
exclusive of grants of the British Association 
and of the Government, to five parochial 
kitchens superintended by them. Want of 
space alone prevents us from alluding to 
many other similar instances.


In the autumn and winter of 1846 efforts 
were made to induce the Government to 
take an active part in assisting emigration 



---

p.132




by an apportionment of the expense of 
passage and outfit between the public, the 
landlords, and the emigrants themselves; 
but, on a full consideration of the subject, it appeared that the emigration about 
to take place in the ensuing season to 
Canada and the United States, without any 
assistance from the public, was likely to be 
quite as large as those countries could properly absorb, and that the consequence of 
the interference of the Government would 
be that the movement would be carried 
beyond those limits which were consistent 
with safety, and that a burthen would be 
transferred to the taxpayers of the United 
Kingdom. which would otherwise be borne 
by those to whom it properly belonged, 
owing to their interests being more immediately concerned. It is also a point of 
primary importance, that those persons 
should emigrate, who, from age, health, 
character, and circumstances, are best able 
to contend with the hardships and difficulties of a settler's life, and it was considered 
that this object would be most fully attained if the emigration were entirely voluntary. The true test of fitness in this case 
is the possession, on the part of each individual




---

p.133



 

concerned, of the will and ability 
to emigrate; and the probability of helpless 
multitudes being sent forth, who, both for 
their own sakes and for that of the colony, 
ought to have remained at home, is increased in proportion as other motives and 
other interests besides those of the emigrant 
himself influence his act of expatriation. 
For these reasons Her Majesty's Ministers 
determined to confine themselves to taking 
increased securities for the safety of the 
emigrants during their voyage, and their 
early and satisfactory settlement after their 
arrival abroad. Additional emigration agents 
were appointed to Liverpool and to different Irish ports; the annual vote in aid 
of colonial funds for the relief of sick 
and destitute emigrants from the United 
Kingdom, was increased from 1000 l. to 
10,000 l.; provision was made for giving assistance in the case of emigrant ships being 
driven back by stress of weather, and the 
Governor-General of Canada was informed 
that Her Majesty's Government would be 
prepared to defray its fair share of any further expense that might have to be incurred 
in giving the Emigrants necessary relief, 



---

p.134




or in forwarding them to places where they 
might obtain employment.[49](javascript:footNote('E840001-002/note049.html'))


Early in the year 1847 the roads to the 
Irish sea-ports were thronged with families 
hastening to escape the evils which impended over their native land. The complaint in Ireland, at the time, was, that those 
who went belonged to the best and most 
substantial class of the agricultural population. The complaint afterwards in Canada was that those who came were the 
helpless and destitute. The fact was, that 
the emigrants generally belonged to that 
class of small holders, who, being somewhat above the level of the prevailing 
destitution, had sufficient resources left to 
enable them to make the effort required 
to effect their removal to a foreign land; 
and the steps taken by them to convert their 
property into an available form, had for 
months before been the subject of observation. Large remittances, estimated to 
amount to 200,000 l. in the year ending 


---

p.135



on the 30th March, 1847, were also made 
by the Irish emigrants settled in the United 
States and the British North American 
provinces, to enable their relations in Ireland to follow them.[50](javascript:footNote('E840001-002/note050.html')) The emigration of 



---

p.136




1846 from the United Kingdom, which 
was the largest ever known up to that 
time, amounted to 129,851 persons; the 
emigration of the first three quarters of 1847 was 240,461; and almost the whole of 
it was from Ireland to Canada and the 
United States.[51](javascript:footNote('E840001-002/note051.html'))




---

p.137


Even this does not represent the full 
extent of the outpouring of the population 
of Ireland which took place in this eventful 
year. From the 13th January to the 1st 
November, 278,005[52](javascript:footNote('E840001-002/note052.html')) immigrants arrived at 
Liverpool from Ireland, of whom only 
122,981 sailed from that port to foreign 
countries. The conflux of this mixed multitude was formidable both to the health and 
resources of the inhabitants of Liverpool; 
but they nobly faced the danger, and exerted 



---

p.138




themselves to meet the emergency with the 
vigour it required. The portion of the town 
occupied by the Irish was divided into thirteen districts, in each of which a relief station 
was opened, and twenty-four additional relieving officers were appointed, under the 
superintendence of two inspectors. The 
number of persons relieved daily amounted 
for some time to upwards of 10,000. The 
district medical officers were increased from 
six to twenty-one, and extensive premises 
were hired or constructed for the purpose 
of being used as temporary fever hospitals. 
All this was done at the expense of the 
inhabitants, and the only assistance given 
by the Government was, that when the fever 
increased to an alarming extent, quarantine 
ships were stationed in the Mersey to receive 
the infected. Nineteen relieving officers died 
at Liverpool alone of fever caught in the 
execution of their duties. The influx of 
poor Irish by way of Glasgow, Ardrossan, 
Port Patrick, Fleetwood, the Welsh ports, 
Bristol, Plymouth, Southampton, and London itself, was also very large; and quarantine arrangements had to be made in the Clyde similar to those at Liverpool.




---

p.139


Some relief was obtained by the passing 
of the Act 10 & 11 Vic. c. 33, ‘to amend the 
Laws relating to the Removal of Poor Persons from England and Scotland;’ and 4,583 
paupers who had become chargeable to the 
Liverpool parochial funds, or who applied to 
be removed, were sent back to their own 
districts in Ireland, at a cost of 1,322 l., 
between the 19th July, when the Act came 
into operation, and the 31st October. Previously to this, there was very little crime 
among these poor people, not even in petty 
thefts; but it soon appeared that they preferred being sent to prison to being sent 
back to Ireland. In the year ending 30th 
September, 1846, 398 natives of Ireland 
were committed to the borough prison at 
Liverpool for begging, pilfering about the 
docks, &c. In the year ending 30th September, 1847, 888 were so committed. In 
the month of October 1846, 80 were committed; in the same month of 1847, 142. 
This pauper immigration passed inland to 
all the large towns of this island, as far as 
London and Edinburgh; and the following 
statement of the number of Roman Catholic 
clergymen who died of the Irish fever caught 
in attending the sick since March 1847, may 



---

p.140




be taken as an index of the relative pressure[53](javascript:footNote('E840001-002/note053.html')) —
  

Lancashire,
  
 
Rev. Peter Nightingale, resident priest of St. 
Anthony's, Great Homer Street, Liverpool.
  
 
William Parker, senior resident priest of St. 
Patrick's, Park Lane, Liverpool.
  
 
Richard Grayston, resident priest of St. 
Patrick's, Park Lane, Liverpool.
  
 
James Haggar, resident priest of St. Patrick's, Park Lane, Liverpool.
  
 
Thomas Kelly, D.D., resident priest of St. 
Joseph's, Grosvenor Street, Liverpool.
  

John F. Whitaker, removed from Manchester to succeed Dr. Kelly at St. Joseph's, where he died.
  
 
J. F. Appleton, D.D., senior resident priest 
of St. Peter's, Seel Street, Liverpool.
  



---

p.141




John A. Gilbert, resident priest of St. 
Mary's, Edmund Street, Liverpool. 
  

William V. Dale, resident priest of St. 
Mary's, Edmund Street, Liverpool.
  
 
Robert Gillow, resident priest of St. Nicholas's, Copperas Hill, Liverpool.
  
 
John Hearne, senior priest of St. John's, 
Wigan.
  
 
Robert Johnson, resident priest of St. John's, 
Wigan.
  
 
John Dowdall, resident priest in Bolton.
  
 
Cheshire.
  
 
Michael Power, resident priest of St. Mary's, 
Duckinfield.
  
 
Yorkshire.
  


Thomas Billington, Vicar-General of Yorkshire district, and senior resident priest of St. Mary's, York.
  
 
Henry Walmsley, senior resident priest of 
St. Ann's, Leeds.
  

Richard Wilson, resident priest of St. Anne's, Leeds.
  
 
Edward Metcalfe, successor to Rev. R. Wilson at St. Anne's, Leeds.
  
 
Joseph Curr, Secretary to Bishop Briggs, 
with whom he resided at Fulford House 
near York. He volunteered his services 
after the death of Mr. Metcalfe, and in 



---

p.142




the course of a few weeks died at St. 
Anne's, Leeds.
  
 
J. Coppinger. Removed from Hull to supply the vacancies caused by the above deaths, and very shortly after his removal 
died at St. Anne's, Leeds.
  
 

Durham.
  

Joseph Dugdale, resident priest of St. 
Mary's, Stockton.
  
 

Northumberland.
  
 
James Standen, senior resident priest of St. 
Andrew's, Newcastle-on-Tyne.
  
 
Right Rev. Dr. Riddell, Vicar Apostolic of the 
Northern District and Bishop of Longo. 
After the death of Mr. Standen, Bishop 
Riddell undertook to attend to the visitation of the sick in person. He very soon caught the fever and died at Newcastle.
  
 

Staffordshire. 
  

Rev. James Kennedy, resident priest at Newcastle-under-Lyne.
  
 

Gloucestershire. 
  


P. Hartley, resident priest of St. Peter's, Gloucester.
  
 

Wales. 
  

Edward Mulcahy, resident priest of St. 
Mary's, Bangor, North Wales.
  



---

p.143



 

M. Carroll, resident priest at Merthyr 
Tydvil, South Wales.
  
 
Scotland.
  

Richard Sinnott, Stranraer, Greenock.
  
 
J. Bremner, Abbey Parish, Paisley. 
  

W. Walsh, Old Monkland.


The pestilence, which all the precautions 
practicable on land could not overcome, 
broke out, as was to be expected, with 
increased virulence on board the emigrant 
ships. A new law was passed at Boston in 
Massachusetts, empowering the local authorities to demand a bond of 1000 dollars from 
the masters of emigrant ships for each passenger apparently indigent, that he should 
not become chargeable to the State or to the 
city for ten years, the effect of which was to 
divert the stream of emigration to a greater 
extent than usual to Canada and New 
Brunswick. The deaths on the voyage to 
Canada increased from 5 in every 1000 
persons embarked, to about 60, or to twelve 
times their previous rate; and so many more 
arrived sick, that the proportion of deaths 
in quarantine to the numbers embarked, 
increased from 1 1/3 to about 40 in the 1000, 
besides still larger numbers who died at 
Quebec, Montreal, and elsewhere in the 



---

p.144




interior.[54](javascript:footNote('E840001-002/note054.html')) A Medical Board was appointed; 
large supplies of provisions were dispatched 
to the quarantine station; tents sufficient 
for the reception of 10,000 persons were 
issued from the Ordnance stores, and the 
labours of the Commissariat in this war 



---

p.145



 

against famine and pestilence, were carried 
on at the same time on both sides of the 
Atlantic; but the utmost exertions and the 
most liberal expenditure could not prevent a 
fearful amount of suffering amongst the emigrants, and a painful spread of disease to the 
resident population.


We are well aware that among men of 
talents and of benevolent dispositions, there 
is a wide difference on the important question of emigration; and in what follows 
on this subject, we wish to be understood, 
not as committing ourselves to particular 
opinions, but merely as making a statement, in pursuance of the historical character of this review, of what we believe to 
have been the views which guided the resolutions of the Government. 


There is no subject of which a merely 
one-sided view is more commonly taken 
than that of Emigration. The evils arising from the crowded state of the population, and the facility with which large 
numbers of persons may be transferred to 
other countries, are naturally uppermost in 
the minds of landlords and ratepayers; but 
Her Majesty's Government, to which the 
well-being of the British population in every 



---

p.146




quarter of the globe is confided, must have 
an equal regard to the interests of the emigrant and of the colonial community of 
which he may become a member. It is a 
great mistake to suppose that even Canada 
and the United States have an unlimited 
capacity of absorbing a new population. 
The labour market in the settled districts 
is always so nearly full, that a small addition to the persons in search of employment makes a sensible difference; while the 
clearing of new land requires the possession 
of resources,[55](javascript:footNote('E840001-002/note055.html')) and a power of sustained 
exertion not ordinarily belonging to the 
newly-arrived Irish emigrant. In this, as 
well as in the other operations by which 
society is formed or sustained, there is a 
natural process which cannot with impunity 
be departed from. A movement is continually going on towards the backwoods on 
the part of the young and enterprising portion of the settled population, and of such 
of the former emigrants as have acquired 



---

p.147



 

means and experience; and the room thus 
made is occupied by persons recently arrived from Europe, who have only their 
labour to depend upon. The conquest of 
the wilderness requires more than the ordinary share of energy and perseverance, 
and every attempt that has yet been made 
to turn Paupers into Backwoodsmen by 
administrative measures, has ended in signal 
failure. As long as they were rationed, they 
held together in a feeble, helpless state; 
and when the issue of rations ceased, they 
generally returned to the settled parts of the 
country. Our recent experience of the 
effects of a similar state of dependence in 
Ireland, offers no encouragement to renew 
the experiment in a distant country, where 
the difficulties are so much greater, and a 
disastrous result would be so much less 
capable of being retrieved.


It must also be observed, that from an 
early period of the present distress, two 
modes of meeting the calamity presented 
themselves, which have since acquired greater 
distinctness in people's minds, and have been 
acted upon in a more and more systematic 
manner. The first of these was to stimulate 
the industry of the people, to augment the 



---

p.148




productive powers of the soil, and to promote the establishment of new industrial 
occupations, so as to cause the land once 
more to support its population, and to substitute a higher standard of subsistence, and 
a higher tone of popular character, for those 
which prevailed before. This plan aimed 
at accomplishing the object without the 
pain or risk of wholesale expatriation; and 
the result proposed by it was to increase 
the strength and prosperity of the country 
and the happiness of the people, by enabling the present population to maintain 
itself comfortably at home by the exercise 
of its industry. The Government adopted 
this plan from the first, and has since promoted its success by every means in its 
power. The other plan was to relieve the 
mother-country by transferring large masses 
of people to the Colonies; and great efforts 
were made to obtain the command of public 
funds to assist in paying the expense of this 
emigration.


The main point, therefore, is, that by 
taking an active part in assisting emigration, 
the Government would throw their weight 
into the scale with the last of these two 
plans. They would assist it by their means; 



---

p.149



 

and, what is of far more consequence, they 
would countenance it by their authority: 
and in the same degree, they would discourage and relax the efforts of those who 
are exerting themselves to carry out the 
opposite plan. In order to appreciate the 
full ultimate effect of such an interposition, 
it must be remembered that the solution of 
the great difficulty by means of emigration 
carried out on the scale and in the manner 
proposed, offers to the promoters of it the 
attraction of accomplishing their object by 
a cheap and summary process; while the 
other remedy, of enabling the population to 
live comfortably at home, can be arrived at 
only by an expensive, laborious, and protracted course of exertion: and it therefore 
behoves the Government, which holds the 
balance between contending parties, to take 
care to which side it lends its influence on 
a social question of this description.


Those who have purchased or inherited 
estates in which a redundant population has 
been permitted or encouraged to grow up, 
may with propriety assist some of their people 
to emigrate, provided they take care to prevent their being left destitute on their arrival 
in their new country. The expense of assisting



---

p.150




emigration under such circumstances 
properly falls on the proprietor. A surplus 
population, whether it be owing to the fault 
or to the misfortune of the proprietor or his 
predecessors, must, like barrenness, or the 
absence of improvements, be regarded as 
one of the disadvantages contingent on the 
possession of the estate; and he who enjoys 
the profits and advantages of the estate, must 
also submit to the less desirable conditions 
connected with it. So long as emigration is 
conducted only at the expense of the proprietor, it is not likely to be carried to an 
injurious or dangerous extent, and it will 
press so heavily on his resources, as to leave 
the motives to exertion of a different kind 
unimpaired. Emigration is open to objection only when the natural checks and correctives have been neutralized by the interposition of the Government, or other public 
bodies. It then becomes the interest and 
policy of the landed proprietor to make no 
exertion to maintain his people at home, to 
produce a general impression that no such 
exertion could be successfully made, and to 
increase by every possible means the pressure upon those parties who, having the command of public funds, are expected to give 



---

p.151



 

their assistance; and the responsibility of 
the consequences, whatever they may be, 
becomes transferred from the individual proprietors, to the Government or public body 
which countenances and promotes their proceedings.


Three things had become apparent before 
the close of the year 1846: the first was, 
that if these gigantic efforts were much longer 
continued, they must exhaust and disorganize 
society throughout the United Kingdom, and 
reduce all classes of people in Ireland to a 
state of helpless dependence; the second 
was, that provision ought to be made for 
the relief of extreme destitution in some 
less objectionable mode than that which had 
been adopted, for want of a better, under the 
pressure of an alarming emergency; and the 
third was, that great efforts and great sacrifices were required to provide another and a better subsistence for the large population 
which had hitherto depended upon the potato. Upon these principles the plan of the 
Government for the season of 1847-8, and 
for all after time, was based.


Much the larger portion of the machinery 
of a good Poor Law had been set up in 
Ireland by the Irish Poor Relief Act (1 & 2 



---

p.152




Vic. c. 56), which was passed in the year 
1838. The island had been divided into 
unions, which were generally so arranged as 
to secure easy communication with the central station; and these had been subdivided 
into electoral districts, each of which appointed its own guardian, and was chargeable only with its own poor, like our 
parishes. A commodious workhouse had 
also been built in each union by advances 
from the Exchequer,[56](javascript:footNote('E840001-002/note056.html')) and rates had been 
established for its support. No relief could, 
however, be given outside the workhouses, 
and when these buildings once became filled 
with widows and children, aged and sick, 
and others who might with equal safety and 
more humanity have been supported at their 
own homes, they ceased to be either a 
medium of relief or a test of destitution to 
the other destitute poor of the union. To 
remedy this and other defects of the existing 
system, three Acts of Parliament were passed 
in the Session of 1847,[57](javascript:footNote('E840001-002/note057.html')) the principal provisions of which were as follows: Destitute 



---

p.153



 

persons who are either permanently or temporarily disabled from labour, and destitute 
widows having two or more legitimate children dependent upon them, may be relieved 
either in or out of the workhouse, at the 
discretion of the guardians. If, owing to 
want of room, or to the prevalence of fever 
or any infectious disorder, adequate relief 
cannot be afforded in a workhouse to persons not belonging to either of the above-mentioned classes, the Poor Law Commissioners may authorize the guardians to give 
them outdoor relief in food only; the Commissioners' order for which purpose can only 
be made for a period of two months, but, if 
necessary, it can be renewed from time to 
time. Relieving officers and medical officers 
for affording medical relief out of the workhouse are to be appointed; and in cases of 
sudden and urgent necessity, the relieving 



---

p.154




officers are to give ‘immediate and temporary relief in food, lodging, medicine, or 
medical attendance’ until the next meeting 
of the guardians. After the 1st November, 
1847, no person is to be relieved either in 
or out of a workhouse, who is in the occupation of more than a quarter of an acre of 
land. No person is to be deemed to have 
been resident in an electoral division so as 
to make it chargeable with the expense of 
relieving him, who shall not during the three 
years before his application for relief have 
occupied some tenement within it, or have 
usually slept within it for thirty calendar 
months. All magistrates residing in the 
union are to be ex-officio guardians, provided 
their number does not exceed that of elected 
guardians. Greater facilities are given for 
dissolving Boards of Guardians, in case they 
do not duly and effectually discharge their 
duty according to the intention of the several 
Acts in force. Public beggars and persons 
going from one district to another for the 
purpose, of obtaining relief are rendered 
liable to one month's imprisonment with 
hard labour; and an independent Poor Law 
establishment is constituted for Ireland, consisting of three Commissioners (two of whom 


---

p.155



 

are to be the Secretary and Under-Secretary 
for Ireland for the time being), an Assistant 
Commissioner and Secretary, and as many 
Inspectors as may be required.


The principle of a comprehensive Poor 
Law and of the abolition of mendicancy, 
having thus been established, the efforts of 
the Government were earnestly directed to 
the removal of the difficulties likely to impede its satisfactory working. The repayment of the first instalment due on account 
of the advances for the Relief Works of the 
winter and spring of 1846-7 (9 & 10 Vic. c. 
107), was postponed until after the Spring 
Assizes of 1848, and it was announced that 
no demand would be made until after the 1st 
January, 1848, for the repayment of the 
advances under the temporary Relief Act, 
when the rates levied previously to that date 
for the current expenses of the permanent 
Poor Law equalled or exceeded 3s. in the 
pound, and that even when rates had been 
struck for the purpose of repaying the 
advances, they might, if necessary, be applied to defraying those current expenses. By these arrangements the demands for 
repayment between the Summer Assizes of 
1847 and the Spring Assizes of 1848 were 



---

p.156




limited to the second instalment for the 
Relief Works and repairs of Grand Jury 
Roads of 1846 (9 Vic. c. 1 and 2), amounting only to 27,000 l. for the whole of Ireland; 
and after providing for this and for the expense of the gaols and other ordinary local 
demands, all the rates levied from the produce of the abundant harvest of 1847 became 
applicable to the relief of the people under 
the Poor Law, then for the first time coming 
into full operation. The Guardians were at 
the same time earnestly recommended by 
the Poor Law Commissioners to strike rates 
sufficient to meet the exigencies of the 
coming winter, and to be strict in the levy 
of them. They were advised to guard against 
the necessity of giving out-door relief to the 
able-bodied, by providing for disabled persons, widows, school-children, and fever patients out of the workhouse; and five Boards 
of Guardians which had obstinately persisted 
in not doing their duty, were dissolved, and 
paid Guardians were appointed in their 
place. Ireland had now had a year and a 
half's experience of the administration of 
relief on a great scale and in different ways, 
and the objects to be aimed at and the 
abuses to be avoided had become generally 



---

p.157



 

known. ‘The very evil itself’, the Relief 
Commissioners observe in their Sixth 
Monthly Report, ‘has been attended with 
a salutary reaction, and the whole country 
seems, by this experience, to have been 
made sensible that it is only by the most 
rigid and thoroughly controlled principles of 
affording relief by any public arrangement, 
that society can be protected from a state of 
almost universal pauperisation, and that the 
charge of a more benevolent alleviation of 
distress than what is absolutely necessary for 
the bare support of the thoroughly destitute, 
must and ought to be left to the exertions 
and voluntary distribution of the charitable 
and humane, which it is hoped will always 
be largely afforded.’ During the week 
ended Saturday the 14th August, 1847, 
there were above 20,000 persons on the relief lists of the electoral division which comprises the northern half of the city of Dublin; and as the operations under the Temporary Relief Act terminated in that union 
on the 15th, the guardians, on the 16th, 
had to deal with the apparent necessity of 
having to provide relief for above 20,000 
persons. On the morning of that day, however, owing to previous arrangements, they 



---

p.158




had room in the workhouse of their union 
for 400 individuals; and by offering workhouse relief to applicants, aided by some 
assistance from the Mendicity Institution, 
the guardians were enabled in the course of 
six days to reduce the number on the relief 
lists to about 3000 persons. This is only 
one instance among many that might be 
adduced, of the practical value of the experience that has been acquired in Ireland 
of the true principles of Poor Law management.


A principle of great power has thus been 
introduced into the social system of Ireland, 
which must be productive of many important consequences, besides those which directly flow from it. **Mr. Drummond**'s 
apophthegm, that ‘property has its duties as 
well as its rights,’ having now received the 
sanction of law, it can never hereafter be a 
matter of indifference to a landed proprietor, 
what the condition of the people on his 
estate is. The day has gone by for letting 
things take their course, and landlords and 
farmers have the plain alternative placed 
before them of supporting the people in 
idleness or in profitable labour. Hitherto 
the duties of Irish landlords had been, as 



---

p.159



 

jurists would say, of imperfect obligation. 
In other words, their performance depended 
upon conscience, benevolence, and a more 
enlightened and far-seeing view of personal 
interest than belongs to the generality of 
men; the consequence of which has been 
a remarkable difference in the conduct of 
Irish landlords: and while some have made 
all the sacrifices and exertions which their 
position required, others have been guilty 
of that entire abandonment of duty which 
has brought reproach upon their order. For 
the future this cannot be. The necessity of 
self-preservation, and the knowledge that 
rents can be saved from the encroachments 
of poor-rates, only in proportion as the poor 
are cared for and profitably employed, will 
secure a fair average good conduct on the 
part of landed proprietors, as in England, 
and more favourable circumstances will induce improved habits. The poor-rate is an 
absentee tax of the best description; because, besides bringing non-resident proprietors under contribution, it gives them 
powerful motives either to reside on their 
estates or to take care that they are managed, 
in their absence, with a proper regard to the 



---

p.160




welfare of the poor.[58](javascript:footNote('E840001-002/note058.html')) Lastly, the performance of duty supposes the enjoyment of 
equivalent rights. When rich and poor are 



---

p.161



 

at one again, the repudiating farmer will find 
the position of his landlord too strong to 
allow of his taking his present license, and 



---

p.162




it will then be fearlessly asserted that the 
converse of **Mr. Drummond**'s maxim is also 
true, and that ‘Property has its rights as 
well as its duties.’ For the first time in the 
history of Ireland, the poor man has become 
sensibly alive to the idea that the law is his 
friend, and the exhortation of the parish 
priest of Dingle to his flock in September 
1847? indicates an epoch in the progress of 
society in Ireland: — ‘Heretofore landlords 
have had agents who collected their rents, 
and they supported them. The grand jury 
had agents to collect the county-cess, and 



---

p.163



 

they supported them. Now, for the first 
time, the poor man has an agent to collect 
*his* rent. That agent is the poor-rate collector, and he should be supported by the 
poor.’ Time must, however, be allowed for 
the gradual working of this feeling, before 
its full effects can be seen.


Those who object to the existing Poor 
Law are bound to point out a more certain 
and less objectionable mode of relieving the 
destitute and securing the regular employment of the poor. The principle of the 
Poor Law is, that rate after rate should be 
levied *for the preservation of life,* until the 
landowners and farmers either enable the 
people to support themselves by honest industry, or dispose of their property to those 
who can and will perform this indispensable 
duty.


The fearful problem to be solved in Ireland, stated in its simplest form, is this. A 
large population subsisting on potatoes which 
they raised for themselves, has been deprived 
of that resource, and how are they now to 
be supported? The obvious answer is, by 
growing something else. But that cannot 
be, because the small patches of land which 
maintained a family when laid down to potatoes,



---

p.164




 are insufficient for the purpose when 
laid down to corn or any other kind of 
produce; and corn cultivation requires capital and skill, and combined labour, which 
the cotter and conacre tenants do not possess. The position occupied by these classes 
is no longer tenable, and it is necessary for 
them either to become substantial farmers, 
or to live by the wages of their labour. 
They must still depend for their subsistence 
upon agriculture, but upon agriculture conducted according to new and very improved 
conditions. Both the kind of food and the 
means of procuring it have changed. The 
people will henceforth principally live upon 
grain, either imported from abroad or grown 
in the country, which they will purchase out 
of their wages; and corn and cattle will be 
exported, as the piece-goods of Manchester 
are, to provide the fund out of which the 
community will be maintained under the 
several heads of wages, profits, and rents. 
It is in vain that the granary of the merchant and the homestead of the farmer are 
filled to overflowing, if the mass of the 
people have not the means of purchasing, 
and it has therefore become of the highest 
consequence that the resources which are 



---

p.165



 

most available for the payment of wages 
should be cultivated to the utmost. The 
Poor Law cannot alone bear the whole weight 
of the existing pauperism of Ireland; and its 
unproductive expenditure, however indispensable, must be supported by adequate 
industrial efforts, in order to prevent all 
classes of society from being involved in one 
common ruin. Before this crisis occurred, 
**Sir Robert Kane** had proved in theory, and 
many good farmers in practice, that a much 
larger produce might be raised, and a much 
larger population might be supported from 
the soil of Ireland than heretofore; and this 
view has since been confirmed by numerous 
surveys conducted under the superintendence 
of the Board of Works, which have disclosed 
an extensive and varied field for the investment of capital, upon which the whole unemployed population of Ireland might be 
employed with much advantage to all parties 
concerned. The great resource of Ireland 
consists in the cultivation of her soil, the 
improvement of her cattle, the extension of 
her fisheries; and while there are large tracts 
of flooded land to be reclaimed, and still 
larger tracts of half-cultivated land to be 
brought to a higher state of productiveness, 



---

p.166




it would be a misdirection of capital to 
employ it in the less profitable manufactures 
of cotton and wool. Ireland is benefited to 
a greater extent than many parts of Scotland 
and England are, by the markets and the 
means of employment which Manchester 
and Glasgow afford; but her own staple 
manufacture is corn.


The Treasury was authorized by the 1 
& 2 Win. IV, c. 33, passed in 1831, to lend 
money to private individuals for the improvement of their estates, provided the value of 
the estate was increased 10 per cent, and 
repayment was made in three years; and by 
the first Act of the Session of 1846 the 
period of repayment was extended to twenty 
years. This power was however very sparingly acted on. Grave objections existed 
to the State becoming a general creditor 
throughout the country, and the operations 
of private capitalists were likely to be deranged and suspended by the interference 
of such a competitor. A rate of interest 
(5 per cent.) higher than the market rate 
for money lent on mortgage, was therefore 
charged, and the result was, that only three 
persons took out loans under this arrangement, one of whom was the late Lord Bessborough.



---

p.167



 

At the close of the Session of 
1846, the Act 9 & 10 Vic. c. 101, was passed, 
by which 1,000,000 l. was authorized to be 
lent for drainage in Ireland, and repayment 
was to be made in equal half-yearly instalments, spread over twenty-two years, including interest at 3 1/2 per cent.; but this Act 
could not be worked, so far as Ireland was 
concerned, partly owing to a legal opinion 
that tenants for life were not eligible for 
loans under it, and partly because the works 
must be executed to a certain extent before 
the money could be advanced. Upon this 
the Treasury issued a Minute dated the 1st, 
and a letter dated the 15th December, 
1846,[59](javascript:footNote('E840001-002/note059.html')) offering to lend money for the general 
improvement of estates, including drainage, 
on a footing which combined the advantages 
of the previous Acts with the indulgent mode 
of repayment introduced by the last; and 
in the following session the Act 10 & 11 
Vic. c. 32 was passed, by which all the 
existing legislation on the subject was consolidated, and loans[60](javascript:footNote('E840001-002/note060.html')) were authorized to be 



---

p.168




made in Ireland to the extent of 1 ,500,000 l., 
on the principle that the improvements on 
each estate are to be executed by the proprietor, and that the interference of the 
officers of the Government is to be confined to ascertaining, in the first instance, 
that the proposed improvements are likely 
to be of such a permanent and productive 
character as would justify the cost of them 
being made a charge upon the estate, with 
priority over other incumbrances, and, afterwards, to inspecting the works from time to 
time, so as to secure the proper application 
of the sums advanced to the purposes for 
which they were intended. No advance can 
be made under this Act unless the increased 
annual value to be given to the land by 
the proposed improvement shall equal the 



---

p.169



 

amount to be charged on it; and a difficulty having arisen from the circumstance 
that the full benefit to be derived from 
draining is attained in different soils at different periods after the completion of the 
drains, it was declared by a Treasury Minute 
dated the 15th June, 1847, that it is not 
necessary that each portion of land improved 
should yield, in the first and in every subsequent year, an additional rent equal to 6 1/2 per cent, per annum on the outlay beyond 
the present rent; but that the general result 
of the improvement of the lands on which 
the rent-charge is to be secured, will, one 
year with another, from the period when the 
full benefit of the improvement may be 
supposed to have accrued, be such as to 
produce an increased annual value to the 
above extent; taking care, of course, that 
the rent-charge is fixed upon lands amply 
sufficient to secure the repayment to the 
Government of the sums so charged. These 
directions had particular reference to the 
circumstances of the poverty-stricken districts in the West of Ireland, where it is 
peculiarly desirable to increase the food 
grown on the spot, and to provide the means 
of employment for the people in the productive



---

p.170




avocations of agriculture; and every 
practicable facility and preference is therefore given to the landed proprietors in those 
districts, which is not inconsistent with 
justice to other parties. It was determined 
by the same Minute, in pursuance of the 
course taken by Parliament with respect to 
the loans for drainage in England and Scotland, that the loans to be made to any one 
landed proprietor should not, under ordinary 
circumstances, exceed, in the aggregate, the 
sum of 12,000 l.; but if, in any particular 
case, owing to the extent of the property to 
be improved, or other causes, it should be 
advisable to enlarge this limit, the Lords of 
the Treasury will be prepared to authorize 
such additional sum as may appear to be 
proper, not exceeding, however, an aggregate 
amount to the same proprietor, of 20,000 l. 


In taking its line on this subject, the 
Government had to choose between employing the agency of the landed proprietors and 
that of public officers; and after much consideration and some experience, the final 
decision was in favour of the former alternative, as above described.


By following this course, all the existing 
relations of society were preserved and 



---

p.171




strengthened; the landed proprietors were 
held to their responsibility for the wellbeing of the people residing on their estates, 
and they were assisted to the extent of the 
loan fund placed by Parliament at the disposal of the Government. The proprietor 
or his agent has the strongest interest in 
seeing that the work is well done, and can 
exercise the most effectual superintendence 
over it; and as the people are invited to 
exert themselves under the eye of their 
natural employers, the healthy relation of 
master and labourer becomes established 
throughout the country. It has not, as yet, 
been usual in Ireland, for the landlord to 
undertake to make the more expensive and 
permanent improvements, as is the case in 
England, but it may be hoped that an 
impulse will be given to this wholesome 
practice by the loans to proprietors under 
the Land Improvement Act. The landlord 
will be encouraged to proceed in a course 
of improvement which he finds by experience to be profitable to him; he will be 
likely to make further investments on land 
which has been reclaimed or improved by 
him, and he will be especially careful to 



---

p.172




prevent it from being subdivided into small 
holdings.[61](javascript:footNote('E840001-002/note061.html'))


The other plan of reclaiming waste lands 
by the direct agency of the Government did 
not survive the objections made to it on the 
score of its interference with the rights of 
private property. The land must be obtained before it could be improved, and was 
it to be left to the discretion of Commissioners to take any bog-land they pleased 
at a valuation; to single out, for instance, a 


---

p.173




tract of unreclaimed land in the centre of an 
estate? Some firm land also must be annexed to each allotment for the erection of 
the farm buildings, and to obtain soil for the 
improvement of the bog, and this would 
have given a still wider and more arbitrary 
discretion to the Commissioners. The compulsory powers had therefore to be given up; 
and without them the plan could not be 
worked.


But there are other objections to this plan 
which have a much deeper root. The first 
result of the Government undertaking to 
reclaim the waste lands of Ireland would be 
that the mass of the people would throw 
themselves on these works, as they did 
upon the roads, taking it for granted that 
the means of payment were inexhaustible, 
and that less labour would be exacted 
than in employment offered with a view to 
private profit. The landlords and farmers 
would consider that, as the Government 
had undertaken to employ the people and 
improve the soil, they were themselves absolved from responsibility, and they would 
refer all the persons who applied to them 
for employment, to the Government works, 



---

p.174




as has been so often done on former occasions. The single agency of the Government would be substituted for the exertions 
of the whole body of the landowners acting 
in concert with their tenants and dependants; and instead of landed proprietors 
and farmers laying out their own money for 
their own benefit, with all the care and 
economy which this supposes, we should 
have hundreds of public officers, of various 
grades and characters, expending public 
money, for the supposed benefit of the 
public, in a business totally foreign to the 
proper functions of Government, and without a possibility of effectual superintendence; the inevitable consequence of which 
would be, bad work, idle habits, and profuse and wasteful expenditure. Lastly, 
when the land had been reclaimed, whatever care might be taken to dispose of it 
in farms of reasonable size, however durable 
might be the interest granted, or whatever 
legal restrictions might be attempted to be 
imposed, the old process of the subdivision 
of the land, and the multiplication of the 
persons subsisting upon it, would run its 
course. Nothing can supply the place of 



---

p.175



 

the watchful supervision exercised by a 
proprietor, for the protection of his own 
interests, in such a case.


A peasant proprietary may succeed to a 
certain extent,[62](javascript:footNote('E840001-002/note062.html')) where there is a foundation 
of steadiness of character, and a habit of 
prudence, and a spring of pride, and a value 
for independence and comfort; but we fear 
that all these words merely show the vain 
nature of schemes of peasant proprietorship 
for Ireland. The small holders of Belgium,[63](javascript:footNote('E840001-002/note063.html')) with all their industry and frugality, 



---

p.176




have, during this calamitous period, been 
the most distressed population in Europe 
next to Ireland. Their own resources were 
too small to carry them through a season 
of dearth, and they had no employers to 
assist them. In India, society is based on a 
system of small holdings, and there is no 
country in which destructive famines have 
been so common. In Ireland itself, the 
greatest over-population, and consequently 
the greatest distress, prevailed in those districts in which, owing to the existence of 
long leases, the landlords had no power to 
prevent the subdivision of the land. Mere 
security of tenure is of no avail, without the 



---

p.177




capital, and skill, and habits of life, and, 
above all, the wholesome moral qualities 
required to turn this advantage to good 
account. During the late season of dearth, 
food was dearer in the long peninsula which 
stretches to the south-west of England, than 
it was in Ireland, and the poor had no 
resource analogous to the farming stock of 
the Irish small holder; but the Devonshire 
and Somersetshire labourer lives by wages 
paid by persons richer than himself; and 
though severely pinched, he had enough for 
daily bread, with some assistance from charitable aid, which was generally afforded 
throughout the west of England, during the 
late season of distress, either by parochial 
subscriptions or by allowances from the 
unions. The south-west of England is the 
least favourable specimen which Great 
Britain affords of the system of society 
based upon wages, because the nourishing 
manufactures which formerly existed in that 
quarter have disappeared before the superior 
natural advantages of the North, and wages 
are consequently very low.[64](javascript:footNote('E840001-002/note064.html')) In every other 



---

p.178




part of this island the contrast is more 
decidedly to the disadvantage of the small 
holdings; and in Northumberland, which 
is a county of large farms, there may be said 
to be no poor. Whether the good order, 
the physical well-being, or the moral and 
intellectual progress of rural society, be considered, the best model is that in which the 
educated and enlightened proprietor, the 
substantial farmer, and the industrious labourer on regular wages, each performs his 
appropriate part.


The works required for deepening and 
straightening the course of many of the 
rivers are of peculiar importance to Ireland; 
because until the outfalls have been cleared, 
the landowners cannot enter upon the detailed or thorough drainage of their respective 
estates. In such cases the necessity of 
working upon the lands of different proprietors calls for the active interposition of 
the Board of Works, who make the preliminary



---

p.179



 

survey, execute the work, and afterwards apportion the charge, according to the 
benefit derived by each person interested. 
The funds for carrying on these improvements had been chiefly obtained by the issue 
of debentures under the authority of the 
Acts of Parliament relating to the subject; 
but, under existing circumstances, loans 
were not to be expected from private individuals at a moderate rate of interest; and the 
ordinary loan fund of the Board of Works 
amounting to 60,000 l. a-year, was therefore 
reinforced with 120,000 l., transferred to it 
from the London Loan Commissioners, and 
250,000 l. issued from the Consolidated Fund; 
making altogether a sum of 430,000 l. placed 
at the disposal of the Board of Works, between the 1st April, 1847, and the 1st April, 
1848, to be advanced by them for works of 
utility in Ireland, but principally for drainage 
of the above-mentioned description.


Next to agricultural improvements, well-selected public works perhaps offer the 
greatest resource in the present unhappy 
circumstances of Ireland. It is a mistake 
to suppose that opening a good road may 
not be the most reproductive work in many 
districts; and the construction of railroads 



---

p.180




on the great lines of communication, does 
for the whole country what new roads do for 
particular districts, facilitating and stimulating every description of production, and 
agriculture more than all, binding society 
together by a closer intercourse and interchange of good offices, and rapidly diffusing 
through the remote provinces the advantages 
enjoyed by the more favoured parts of the 
country.


The objection to Lord George Bentinck's 
plan for assisting Irish railways was, that 
while it was inadequate as a measure of 
relief, it was too large and indiscriminate 
when viewed as a measure for the promotion of public works. Private enterprise 
would have been overlaid; the bad lines 
would have been benefited at the expense of 
the good; the public credit would have 
been lowered; the available stock of national 
capital would have suffered an additional 
drain which it could ill afford; and after 
all, the object of relieving the existing distress would not have been attained. The 
famine was then at its height, and it could 
not be stayed by any measure short of distributing food to the multitude. After allowing for the largest number of persons who 



---

p.181



 

could be employed on railways, millions 
must still have starved, if other more effectual steps had not been taken; and the 
sums advanced to the Railway Companies, 
large as they would have been, would not 
have perceptibly diminished the expense of 
feeding a whole nation.[65](javascript:footNote('E840001-002/note065.html')) When this primary 
object had been attained, and all the funds 
had been raised by loan which the state of 
Ireland required, the Government was then 
in a position to consider what assistance 



---

p.182




could be given to railroads in common with 
other works of public utility; and 620,000 l. 
was voted by Parliament to be lent to Railways which were legally able to borrow, 
owing to their having paid up half their 
capital, and could undertake to expend within 
a certain fixed time, another sum of their 
own equal to that advanced to them. By 
the aid thus given, the great South-Western 
Railway of Ireland will be enabled to employ 
a large number of men throughout the winter, and the important object of opening 
the communication between Dublin, Cork, 
and Limerick, will be accomplished at a 
much earlier period than would otherwise 
have been the case.


The other works in progress in Ireland 
with the aid of grants or loans from Parliament, are as follows: the Shannon navigation, which has been in operation for several 
years; the construction of new floating 
docks and markets at Limerick; works at 
Hawlbowline, with a view to render that 
place more useful as a naval station; four 
great works of combined navigation and 
drainage; the construction of three new colleges, and of several prisons and lunatic asylums; and the repair and construction of 



---

p.183



 

fishery piers, for which 50,000 l. was voted 
in the session of 1846, and a further sum of 
40,000 l. in the session of 1847.


Having thus furnished as clear a sketch 
as the variety and complexity of the incidents would allow, of this remarkable crisis 
in our national affairs, when the events of 
many years were crowded into two short 
seasons, and a foundation was laid for social 
changes of the highest importance, it may 
be asked, what fruits have yet appeared of 
this portentous seed-time, and what the 
experience is which we have purchased at 
so heavy a cost?


First, it has been proved to demonstration, that local distress cannot be relieved 
out of national funds without great abuses 
and evils, tending, by a direct and rapid 
process, to an entire disorganisation of 
society. This is, in effect, to expose the 
common stock to a general scramble. All 
are interested in getting as much as they 
can. It is nobody's concern to put a check 
on the expenditure. If the poor man prefers idling on relief works or being rationed 
with his wife and children, to hard labour; 
if the farmer discharges his labourers and 



---

p.184




makes the state of things a plea for not 
paying rates or rent; if the landed proprietor joins in the common cry, hoping to 
obtain some present advantage, and trusting 
to the chance of escaping future repayments, 
it is not the men, but the system, which is 
in fault. Ireland is not the only country 
which would have been thrown off its balance 
by the attraction of ‘public money’ à discrétion. This false principle eats like a 
canker into the moral health and physical 
prosperity of the people. All classes ‘make 
a poor mouth,’ as it is expressively called 
in Ireland. They conceal their advantages, 
exaggerate their difficulties, and relax their 
exertions. The cotter does not sow his 
holding, the proprietor does not employ his 
poor in improving his estate, because by 
doing so they would disentitle themselves 
to their ‘share of the relief.’ The common 
wealth suffers both by the lavish consumption and the diminished production, and 
the bees of the hive, however they may 
redouble their exertions, must soon sink 
under the accumulated burden. The officers 
of Government, overborne by numbers, and 
unable to test the interested representations 
pressed upon them from all quarters, cannot 


---

p.185



 

exercise their usual watchful care over the 
expenditure of the public money. Those 
persons who have the will to do their duty, 
have not the power. Those who have the 
power, have not the will. There is only one 
way in which the relief of the destitute ever 
has been, or ever will be, conducted consistently with the general welfare, and that 
is by *making it a local charge.* Those who 
know how to discriminate between the different claims for relief, then become actuated 
by a powerful motive to use that knowledge 
aright. They are spending *their own money.* 
At the same time, those who have the means 
of employing the people in reproductive 
works, have the strongest inducement given 
them to do so. The struggle now is to keep 
the poor off the rates, and if their labour 
only replaces the cost of their food, it is 
cheaper than having to maintain them in 
perfect idleness.


Another point which has been established 
by the result of these extensive experiments 
in the science, if it may be so called, of relieving the destitute, is that two things ought 
to be carefully separated which are often 
confounded. Improvement is always a good 
thing, and relief is occasionally a necessary 



---

p.186




thing, but the mixture of the two is almost 
always bad; and when it is attempted on a 
large scale without proper means of keeping 
it in check, it is likely to affect in a very injurious manner the ordinary motives and 
processes by which the business of society 
is carried on. Relief, taken by itself, offers, 
if it is properly administered, no motive to 
misrepresent the condition of the people; 
and being burdensome to the higher, and 
distasteful to the lower classes, it is capable 
of being carefully tested and subjected to 
effectual controul. But when relief is connected with profitable improvements and 
full wages, the most influential persons in 
each locality become at once interested in 
establishing a case in favour of it, and the 
higher are always ready to join with the 
lower classes in pressing forward *relief 
works* on a plea of urgent general distress, 
which it may be impossible to analyse and 
difficult to resist. Relief ought to be confined as much as possible to the infirm and 
helpless. Wages, by means of which improvements are carried on, should be given 
by preference to the able-bodied and vigorous. Relief ought to be on the lowest scale 
necessary for subsistence. Wages should be 



---

p.187



 

sufficiently liberal to secure the best exertions of the labourer. Relief should be 
made so unattractive as to furnish no motive 
to ask for it, except in the absence of every 
other means of subsistence. Improvements 
should be encouraged and urged forward by 
every practicable means, both as regards the 
parties undertaking them, and those by 
whom they are executed. If labour is connected with relief, it should only be as a test 
of the destitution of the applicant, and of 
his being consequently entitled to a bare 
subsistence, in the same way as confinement 
in a workhouse is also a test; and the true 
way to make relief conducive to improvement, is to give the rich no choice between 
maintaining the able-bodied labourers as 
paupers, or employing them on full wages 
on profitable works, and to take care that 
the poor have no reason to prefer living on 
public alms, to the active exercise of their 
industry in their own behalf.


Among all our discouragements, there are 
not wanting many and sure grounds of hope 
for the future. The best sign of all is, that 
the case of Ireland is at last understood. 
Irish affairs are no longer a craft and mystery. The abyss has been fathomed. The 



---

p.188




famine has acted with a force which nothing 
could resist, and has exposed to view the 
real state of the country, so that he who runs 
may read. We have gained, both by what 
has been unlearned and by what has been 
learned during the last two years: and the 
result is, that the great majority of people, 
both in Ireland and England, are now 
agreed upon the course which ought to be 
pursued, in order to arrive at the wished-for 
end. The attention of the two countries has 
also been so long directed to the same subject, that a new reciprocity of interest and 
feeling has been established, and the public 
opinion of each has begun to act upon the 
other with a force which was never felt 
before.


The Irish have been disabused of one of 
the strangest delusions which ever paralysed 
the energies of a naturally intelligent and 
energetic people. Those who knew the 
country best, were aware of the habitual 
dependence of the upper classes upon the 
Government; and it was a common saying 
of former days, that an Irish gentleman 
could not even marry his daughter without 
going to the Castle for assistance. The 
vulgar idea was, that when difficulties occurred,




---

p.189



 

every personal obligation was discharged 
by ‘bringing the matter under the consideration of the Government;’ and if, in 
addition to this, ‘a handsome support’ was 
promised, it seldom meant more than helping 
to spend any public money that might be 
forthcoming. But it was reserved for that 
potent solvent, the Famine, to discover to 
the full extent, this element of the national 
character. To pass with safety through this 
great crisis, required that every man, from 
the highest nobleman to the meanest peasant, should exert himself to the utmost of 
his means and ability; instead of which, the 
entire unassisted burden of employing all 
the unemployed labourers of Ireland, of 
improving all the unimproved land of Ireland, and feeding all the destitute persons in 
Ireland, was heaped upon a Board consisting of five gentlemen, sitting in an office in 
Dublin. The example of the gentry was 
followed with customary exaggeration by 
the lower orders, and throughout extensive 
districts, the cultivation of the land was suspended in the spring of 1847 until it should 
be seen what ‘encouragement’ the Government would give, or, as it was sometimes 
ingenuously expressed, ‘We expect the 



---

p.190




Government will till the ground.’ It is 
also a fact that the people in some parts 
of the West of Ireland neglected to a great 
extent to lay in their usual winter stock of 
turf in 1847, owing to the prevalence of a 
popular impression that the Queen would 
supply them with coals. Ireland has awakened from this dream by the occurrence of 
the most frightful calamities, and it has at 
last begun to be understood that the proper 
business of a Government, is to enable private individuals of every rank and profession in life, to carry on their several occupations with freedom and safety, and not 
itself to undertake the business of the landowner, merchant, money-lender, or any 
other function of social life. Reason is now 
able to make herself heard, and there has 
not been wanting many a warning and encouraging voice from Ireland herself, declaring — ‘The prosperity of Ireland is only to 
be attained by your own strong arms. We 
are able to help ourselves. We will no 
longer be dependent on the precarious 
assistance received from other lands. We 
will never rest until every sod in Ireland 
brings forth abundantly— till every inch of 
ground is in its highest and fullest state of 



---

p.191



 

bearing. In a short time we shall have 
among us more industry and exertion, less 
politics and more ploughing, less argument 
and more action, less debating and more 
doing.’[66](javascript:footNote('E840001-002/note066.html'))


The uniting power of a common misfortune has also been felt throughout the British 
Empire. Those who had never before exchanged words or looks of kindness, met to 
co-operate in this great work of charity, and 
good men recognised each other's merits 
under the distinctions by which they had 
been previously separated. The Protestant 
and Roman Catholic clergy vied with each 
other in their exertions for the famishing 
and fever-stricken people, and in numerous 
instances their lives became a sacrifice to 
the discharge of their exhausting, harassing 
and dangerous duties. To the priests all 
were indebted for the readiness with which 
they made their influence over their flocks 
subservient to the cause of order; and the 
minister of religion was frequently summoned 
to the aid of the public officer when all other 
means of restraining the excited multitude 


---

p.192




had failed.[67](javascript:footNote('E840001-002/note067.html')) The political dissensions which 
had distracted Ireland for centuries became 
suddenly allayed. The famine was too 
strong even for the mighty demagogue, that 
great mixed character to whom Ireland owes 
so much good and so much evil. People 
of every shade of political opinion acted 
together, not always in an enlightened manner, hut always cordially and earnestly, in 
making the social maladies of Ireland, and 
the means of healing them, the paramount 
object. In the hour of her utmost need, 
Ireland became sensible of an union of feeling and interest with the rest of the empire, 
which would have moved hearts less susceptible of every generous and grateful emotion 



---

p.193



 

than those of her sons and daughters.[68](javascript:footNote('E840001-002/note068.html')) 

Although the public efforts in her behalf 
were without parallel in ancient and modern 
history, and the private subscriptions were 
the largest ever raised for a charitable object, 
they were less remarkable than the absorbing interest with which her misfortunes were 
regarded for months together both in Parliament and in society, to the exclusion of 
almost every other topic. It will also never 
be forgotten that these efforts and these 
sacrifices were made at a time when England 



---

p.194




was herself suffering under a severe scarcity 
of food, aggravated by the failure of the 
cotton crop, and by the pecuniary exhaustion 
consequent upon the vast expenditure for 
the construction of railways. Even in such 
a state of things, though serious injury was 
done to all her interests by the Irish Loan, 
and though the pressure upon the labouring 
classes was greatly increased by the wholesale purchase of their food, that it might be 
given without cost to the starving Irish, yet 
every sacrifice was submitted to without a 
murmur by the great body of the people.


Although the process by which long-established habits are changed, and society 
is reconstructed on a new basis, must 
necessarily be slow, there are not wanting 
signs that we are advancing by sure steps 
towards the desired end. The cultivation of 
corn has to a great extent been substituted 
for that of the potato; the people have become accustomed to a better description of 
food than the potato;[69](javascript:footNote('E840001-002/note069.html')) conacre, and the 



---

p.195



 

excessive competition for land, have ceased 
to exist; the small holdings, which have 
become deserted, owing to death, or emigration, or the mere inability of the holders 


---

p.196



 

to obtain a subsistence from them in the 
absence of the potato, have, to a considerable extent, been consolidated with the adjoining farms; and the middlemen, whose 
occupation depends upon the existence of a 
numerous small tenantry, have begun to disappear. The large quantity of land left uncultivated in some of the western districts is 
a painful but decisive proof of the extent to 
which this change is taking place. The 
class of offences connected with the holding 
of land, which was the most difficult to deal 
with, because agrarian crimes were supported 
by the sympathy and approbation of the 
body of the people, and were generally the 
result of secret illegal associations, fell off 
in a remarkable degree;[70](javascript:footNote('E840001-002/note070.html')) and although *offences* against other kinds of property increased, owing to the general distress, the 
usual difficulty was not experienced in obtaining convictions. The much-desired 



---

p.197



 

change in the ownership of land appears 
also to have commenced; and when great 
estates are brought to the hammer now, 
instead of being sold, as formerly, *en masse,* 
they are broken up into lots,[71](javascript:footNote('E840001-002/note071.html')) which opens 



---

p.198




the door to a middle class, more likely to 
become resident and improving proprietors 
than their predecessors, and better able to 
maintain the stability of property and of our 
political institutions, because they are themselves sprung from the people. The most 
wholesome symptom of all, however, is that 
a general impression prevails, that the plan 
of depending on external assistance has been 
tried to the utmost and has failed; that 
people have grown worse under it instead of 
better; and that the experiment ought now 
to be made of what independent exertion 
will do. This feeling has been much strengthened by the necessity which has been imposed upon the upper classes through the 
Poor Law, of caring for the condition of the 
people; and the attention of the country 
gentlemen has in many districts been seriously directed to the means of supporting 
them in a manner which will be alike beneficial to the employer and the employed.


The poet **Spenser** commences his View of 
the state of Ireland by these discouraging 
observations: ‘Marry, so there have been 



---

p.199



 

divers good plots devised, and wise counsels 
cast already about reformation of that realm, 
but they say it is the fatal destiny of that 
land, that no purposes whatsoever which are 
meant for her good, will prosper or take good 
effect; which, whether it proceed from the 
very genius of the soil, or influence of the 
stars, or that Almighty God hath not yet 
appointed the time of her reformation, or 
that he reserveth her in this inquiet state 
still for some secret scourge, which shall by 
her come into England, it is hard to be 
known, but yet much to be feared.’ Our 
humble but sincere conviction is, that the 
appointed time of Ireland's regeneration is 
at last come. For several centuries we were 
in a state of open warfare with the native 
Irish, who were treated as foreign enemies, 
and were not admitted to the privileges and 
civilising influences of English law, even 
when they most desired it. To this succeeded a long period of mixed religious and 
civil persecution,[72](javascript:footNote('E840001-002/note072.html')) when the Irish were 



---

p.200




treated as the professors of a hostile faith, 
and had inflicted on them irritating and 
degrading penalties, of which exclusion from 
Parliament and from civil and military office 
was one of the least; the general characteristics of this epoch of Irish management 
being that the Protestant minority were 
governed by corruption, and the Roman 
Catholic majority by intimidation. During 
all this time England reaped as she sowed: 
and as she kept the people in a chronic 
state of exasperation against herself, none of 
her ‘good plots and wise counsels’ for their 
benefit succeeded; for there was no want of 
good intention, and the fault was principally 
in the mistaken opinions of the age, which 
led to persecution in other countries besides 



---

p.201




Ireland. Now, thank God, we are in 
a different position; and although many 
waves of disturbance must pass over us 
before that troubled sea can entirely subside, 
and time must be allowed for morbid habits 
to give place to a more healthy action, England and Ireland are, with one great exception, subject to equal laws; and, so far as 
the maladies of Ireland are traceable to political causes, nearly every practicable remedy 
has been applied. The deep and inveterate 
root of social evil remained, and this has 
been laid bare by a direct stroke of an all-wise and all-merciful Providence, as if this 
part of the case were beyond the unassisted 
power of man. Innumerable had been the 
specifics which the wit of man had devised; 
but even the idea of the sharp but effectual, 
remedy by which the cure is likely to be 
effected had never occurred to any one. 
God grant that the generation to which this 
great opportunity has been offered, may 
rightly perform its part, and that we may 
not relax our efforts until Ireland fully participates in the social health and physical 
prosperity of Great Britain, which will be 
the true consummation of their union.












