

#The Familiar


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Familiar
============


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 2. Second draftExtent of text: 16200 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2006) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E870000-002Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions**2. Joseph Sheridan Le Fanu, In a Glass Darkly, London: R. Bentley & Son 1872.
3. Joseph Sheridan Le Fanu, In a Glass Darkly, London: London: Eveleigh Nash & Grayson 1923.
4. Joseph Sheridan Le Fanu, In a Glass Darkly, London: P. Davies, 1929.
5. Joseph Sheridan Le Fanu, In a Glass Darkly, with an introduction by V. S. Pritchett, London: John Lehmann 1947.
6. Joseph Sheridan Le Fanu, In a Glass Darkly, The collected works of Joseph Sheridan Le Fanu, 3 volumes; introduction by Sir Devendra P. Varma, volume 1, New York: Arno Press 1977. [Facsimile reprint of 1872 edition.]
7. Joseph Sheridan Le Fanu, In a Glass Darkly, edited with an introduction and notes by Robert Tracy. World's Classics paperback series, Oxford University Press 1993 [Reprinted as Oxford World's Classics paperback 1999].
8. For an earlier version of this story , see 'The Watcher', in 'Ghost Stories and Tales of Mystery', Dublin 1851.
**Literature**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October–November 1916) 30–33.
8. M. R. James (ed.), Madame Crowl's Ghost and other Tales of Mystery, London: Bell 1923.
9. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
10. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
11. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
12. Michael Sadleir, Dublin University Magazine; its History, Contents and Bibliography, Dublin 1938.
13. Christine Longford, 'Introduction' to 'Uncle Silas', by J. Sheridan Le Fanu, West Drayton 1940, 7–10.
14. V. S. Pritchett, The living novel, London: Chatto and Windus 1946.
15. Arthur H. Nethercot, Coleridge's 'Christabel' and Le Fanu's 'Carmilla', Modern Philology 147 (August 1949) 32–38.
16. Elizabeth Bowen, Collected Impressions, London 1950.
17. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
18. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
19. A. B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
20. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
21. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
22. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
23. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
24. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
25. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
26. Ken Scott, Le Fanu's 'The Room in the Dragon Volant', Lock Haven Review 10 (1968) 78.
27. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
28. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
29. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
30. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
31. E. F. Bleiler, 'Introduction' to J.S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
32. J. C. Beckett, The Anglo-Irish Tradition, London 1976.
33. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London 1977.
34. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Ohio University Press 1978.
35. William Veeder, '*Carmilla*: The Arts of Repression', Texas Studies in Language and Literature 22 (1980): 197–223.
36. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
37. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
38. Harold Orel, 'Rigid Adherence to Facts': Le Fanu's 'In a Glass Darkly', Éire-Ireland, 20.4 (1985) 65–88.
39. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
40. Carol A. Senf, 'Women and Power in *Carmilla*' Gothic, New Series 2 (1987) 25–33.
41. Barbara T. Gates, 'Blue Devils and Green Tea: Le Fanu's Haunted Suicides', Studies in Short Fiction, 24.1 (1987) 15–23.
42. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
43. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
44. Marie Mulvey-Roberts (ed), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
45. Tammis Elise Thomas, 'Masquerade Liberties and Female Power in Le Fanu's *Carmilla*', in: Elton E. Smith and Robert Haas, (eds.), The Haunted Mind: The Supernatural in Victorian Literature. University Press of America, 1999: 39–65.
46. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
47. Robert F. Geary, 'Carmilla and Gothic Legacy: Victorian Transformations of Supernatural Horror', in: Leonard Heldreth and Mary Pharr (eds.), The Blood Is the Life: Vampires in Literature, Popular Press, 1999.
48. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
49. Michael Charlesworth (ed.), The Gothic revival, 1720-1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
50. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
51. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
52. James Walton, Vision and Vacancy: the Fictions of J.S. Le Fanu. Dublin, University College Dublin Press, 2007.
**The edition used in the digital edition**2. In a Glass Darkly. Joseph Sheridan Le Fanu Reprint [1 volume; viii + 471pp] Eveleigh Nash & Grayson LimitedLondon (1923) #### Notes

*The Familiar* is a slightly reworked version of *The Watcher*, published in *Ghost Stories and Tales of Mystery* in 1851.

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 55–118.


#### Editorial Declaration


##### Correction


Text has been proofed once at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors of the hardcopy edition are corrected silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the story; div1=the chapter. Paragraphs are marked. Page-breaks are marked pb n="". Prologue and postscript are contained in unnumbered div elements outside the div0.


##### Interpretation


Words and phrases from languages other than English are marked.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: By J. S. Le Fanu

 Date range: Between 1851 and 1870.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [FR] Some words and phrases are in French.


### Revision History


* (2010-03-26) Beatrix Färber (ed.)

* Header modified, new wordcount made, file re-parsed.
* (2008-08-28) Beatrix Färber (ed.)

* File validated.
* (2008-08-02) Beatrix Färber (ed.)

* Keywords added.
* (2008-07-26) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, addition to bibliography made, content of 'langUsage' revised; minor modifications made to header.
* (2006-09-27) Beatrix Färber (ed.)

* File parsed, SGML and HTML file created.
* (2006-09-26) Beatrix Färber (ed.)

* Header created; bibliography inserted; file proofed (1), structural and content markup added.




---


#### Corpus of Electronic Texts Edition: E870000-002


### The Familiar: Author: Joseph Sheridan Le Fanu




---

p.55


### The Familiar

### Prologue


Out of about two hundred and thirty cases more or less nearly akin to that I have entitled Green Tea, I select the following which I call The Familiar.


To this MS., Doctor Hesselius has, after his wont, attached some sheets of letter-paper, on which are written, in his hand nearly as compact as print, his own remarks upon the case. He says:


‘In point of conscience, no more unexceptionable narrator than the venerable Irish Clergyman who has given me this paper, on Mr. Barton's case, could have been chosen. The statement is, however, medically imperfect. The report of an intelligent physician, who had marked its progress, and attended the patient, from its earlier stages to its close, would have supplied what is wanting to enable me to pronounce with confidence. I 



---

p.56




should have been acquainted with Mr Barton's probable hereditary predispositions; I should have known, possibly by very early indicators, something of a remoter origin of the disease than can now be ascertained.’


‘In a rough way, we may reduce all similar cases to three distinct classes. They are founded on the primary distinction between the subjective and the objective. Of those whose senses are alleged to be subject to supernatural impressions—some are simply visionaries, and propagate the illusions of which they complain from diseased brain or nerves. Others are, unquestionably, infested by, as we term them, spiritual agencies, exterior to themselves. Others, again, owe their sufferings to a mixed condition. The interior sense, it is true, is opened; but it has been and continues open by the action of disease. This form of disease may, in one sense, be compared to the loss of the scarf-skin, and a consequent exposure of surfaces for whose excessive sensitiveness nature has provided a muffling. The loss of this covering is attended by an habitual impassibility, by influences against which we were intended to be guarded. But in the case of the brain, and the nerves immediately connected with its functions and its sensuous impressions, the cerebral circulation undergoes periodically that vibratory disturbance which, I believe, I have satisfactorily examined and demonstrated in my MS. Essay, A. 17. This vibratory disturbance differs, as I there prove, essentially from the congestive disturbance, the phenomena of which are examined in A. 19. It is, when excessive, invariably accompanied by *illusions*.’


‘Had I seen Mr. Barton, and examined him upon



---

p.57




 the points in his case which need elucidation, I should have without difficulty referred those phenomena to their proper disease. My diagnosis is now, necessarily, conjectural.’


Thus writes Doctor Hesselius; and adds a great deal which is of interest only to a scientific physician.


The Narrative of the Rev. Thomas Herbert, which furnishes all that is known of the case will be found in the chapters that follow.




---

p.58


Footsteps
---------


I was a young man at the time, and intimately acquainted with some of the actors in this strange tale; the impression which its incidents made on me, therefore, were deep and lasting. I shall now endeavour, with precision, to relate them all, combining, of course, in the narrative, whatever I have learned from various sources, tending, however imperfectly, to illuminate the darkness which involves its progress and termination.


Somewhere about the year 1794, the younger brother of a certain baronet, whom I shall call Sir James Barton, returned to Dublin. He had served in the navy with some distinction, having commanded one of His Majesty's frigates during the greater part of the American war. Captain Barton was apparently some two or three-and-forty years of age. He was an intelligent and agreeable companion when he pleased it, though generally reserved, and occasionally even moody.


In society, however, he deported himself as a man



---

p.59




 of the world, and a gentleman. He had not contracted any of the noisy brusqueness sometimes acquired at sea; on the contrary, his manners were remarkably easy, quiet, and even polished. He was in person about the middle size, and somewhat strongly formed—his countenance was marked with the lines of thought, and on the whole wore an expression of gravity and melancholy. Being, however, as I have said, a man of perfect breeding, as well as of good family and in affluent circumstances, he had, of course, ready access to the best society of Dublin without the necessity of any other credentials.


In his personal habits Mr. Barton was unexpensive. He occupied lodgings in one of the *then* fashionable streets in the south side of the town—kept but one horse and one servant—and though a reputed free-thinker, yet lived an orderly and moral life—indulging neither in gaming, drinking, nor any other vicious pursuit—living very much to himself, without forming intimacies, or choosing any companions, and appearing to mix in gay society rather for the sake of its bustle and distraction, than for any opportunities it offered of interchanging thought or feeling with its votaries.


Barton was, therefore, pronounced a saving, prudent, unsocial sort of fellow, who bid fair to maintain his celibacy alike against stratagem and assault, and was likely to live to a good old age, die rich, and leave his money to an hospital.


It was now apparent, however, that the nature of Mr Barton's plans had been totally misconceived. A young lady, whom I shall call Miss Montague, was at this time introduced into the gay world by her aunt, the Dowager Lady L——. Miss Montague was



---

p.60




 decidedly pretty and accomplished, and having some natural cleverness and a great deal of gaiety, became for a while a reigning toast.


Her popularity, however, gained her for a time nothing more than that unsubstantial admiration which, however pleasant as an incense to vanity, is by no means necessarily antecedent to matrimony—for, unhappily for the young lady in question, it was an understood thing that, beyond her personal attractions, she had no kind of earthly provision. Such being the state of affairs, it will readily be believed that no little surprise was consequent upon the appearance of Captain Barton as the avowed lover of the penniless Miss Montague.


His suit prospered, as might have been expected, and in a short time it was communicated by old Lady L—— to each of her hundred-and-fifty particular friends in succession, that Captain Barton had actually tendered proposals of marriage, with her approbation, to her niece, Miss Montague, who had, moreover, accepted the offer of his hand, conditionally upon the consent of her father, who was then upon his homeward voyage from India, and expected in two or three weeks at the furthest.


About this consent there could be no doubt—the delay, therefore, was one merely of form—they were looked upon as absolutely engaged, and Lady L——, with a rigour of old-fashioned decorum with which her niece would, no doubt, gladly have dispensed, withdrew her thenceforward from all further participation in the gaieties of the town.


Captain Barton was a constant visitor, as well as a frequent guest at the house, and was permitted all



---

p.61




 the privileges of intimacy which a betrothed suitor is usually accorded. Such was the relation of parties, when the mysterious circumstances which darken this narrative first began to unfold themselves.


Lady L—— resided in a handsome mansion at the north side of Dublin, and Captain Barton's lodgings, as we have already said, were situated at the south. The distance intervening was considerable, and it was Captain Barton's habit generally to walk home without an attendant, as often as he passed the evening with the old lady and her fair charge.


His shortest way in such nocturnal walks lay, for a considerable space, through a line of street which had as yet merely been laid out, and little more than the foundations of the houses constructed.


One night, shortly after his engagement with Miss Montague had commenced, he happened to remain unusually late, in company with her and Lady L——. The conversation had turned upon the evidences of revelation, which he had disputed with the callous scepticism of a confirmed infidel. What were called ‘French principles’ had in those days found their way a good deal into fashionable society, especially that portion of it which professed allegiance to Whiggism, and neither the old lady nor her charge were so perfectly free from the taint as to look upon Mr. Barton's views as any serious objection to the proposed union.


The discussion had degenerated into one upon the supernatural and the marvellous, in which he had pursued precisely the same line of argument and ridicule. In all this, it is but truth to state, Captain Barton was guilty of no affectation—the doctrines



---

p.62




 upon which he insisted, were, in reality, but too truly the basis of his own fixed belief, if so it might be called; and perhaps not the least strange of the many strange circumstances connected with my narrative was the fact that the subject of the fearful influences I am about to describe was himself, from the deliberate conviction of years, an utter disbeliever in what are usually termed preternatural agencies.


It was considerably past midnight when Mr. Barton took his leave and set out upon his solitary walk homeward. He had now reached the lonely road, with its unfinished dwarf walls tracing the foundations of the projected row of houses on either side—the moon was shining mistily, and its imperfect light made the road he trod but additionally dreary—that utter silence which has in it something indefinably exciting reigned there and made the sound of his steps, which alone broke it, unnaturally loud and distinct.


He had proceeded thus some way, when he, on a sudden, heard other footfalls, pattering at a measured pace, and, as it seemed, about two score steps behind him.


The suspicion of being dogged is at all times unpleasant: it is, however, especially so in a spot so lonely: and this suspicion became so strong in the mind of Captain Barton, that he abruptly turned about to confront his pursuer, but, though there was quite sufficient moonlight to disclose any object upon the road he had traversed, no form of any kind was visible there.


The steps he had heard could not have been the reverberation of his own, for he stamped his foot upon



---

p.63




 the ground, and walked briskly up and down, in the vain attempt to awake an echo; though by no means a fanciful person, therefore, he was at last fain to charge the sounds upon his imagination, and treat them as an illusion. Thus satisfying himself he resumed his walk, and before he had proceeded a dozen paces the mysterious footfall was again audible from behind, and this time, as if with the special design of showing that the sounds were not the responses of an echo, the steps sometimes slackened nearly to a halt, and sometimes hurried for six or eight strides to a run, and again abated to a walk.


Captain Barton, as before, turned suddenly round, and with the same result—no object was visible above the deserted level of the road. He walked back over the same ground, determined that, whatever might have been the cause of the sounds which had so disconcerted him, it should not escape his search—the endeavour, however, was unrewarded.


In spite of all his scepticism he felt something like a superstitious fear stealing fast upon him, and with these unwonted and uncomfortable sensations he once more turned and pursued his way. There was no repetition of these haunting sounds until he had reached the point where he had last stopped to retrace his steps—here they were resumed—and with sudden starts of running which threatened to bring the unseen pursuer up to the alarmed pedestrian.


Captain Barton arrested his course as formerly—the unaccountable nature of the occurrence filled him with vague and disagreeable sensations—and yielding to the excitement that was gaining upon him, he shouted sternly, ‘Who goes there?’ The sound of



---

p.64




 one's own voice, thus exerted, in utter solitude, and followed by total silence, has in it something unpleasantly dismaying, and he felt a degree of nervousness which, perhaps, from no cause had he ever known before.


To the very end of this solitary street the steps pursued him—and it required a strong effort of stubborn pride on his part to resist the impulse that prompted him every moment to run for safety at the top of his speed. It was not until he had reached his lodgings, and sate by his own fireside, that he felt sufficiently reassured to rearrange and reconsider in his own mind the occurrences which had so discomposed him. So little a matter, after all, is sufficient to upset the pride of scepticism and vindicate the old simple laws of nature within us.




---

p.65


The Watcher
-----------


Mr. Barton was next morning sitting at a late breakfast, reflecting upon the incidents of the previous night, with more of inquisitiveness than awe, so speedily do gloomy impressions upon the fancy disappear under the cheerful influence of day, when a letter just delivered by the postman was placed upon the table before him.


There was nothing remarkable in the address of this missive, except that it was written in a hand which he did not know—perhaps it was disguised—for the tall narrow characters were sloped backward; and with the self-inflicted suspense which we often see practised in such cases he puzzled over the inscription for a full minute before he broke the seal. When he did so he read the following words, written in the same hand:




> 
> Mr. Barton, late captain of the 'Dolphin,' is warned of DANGER. He will do wisely to avoid —
> 
> 
> 
> ---
> 
> p.66
> 
> 
> 
> 
> Street—[here the locality of his last night's adventure was named]—if he walks there as usual he will meet with something unlucky—let him take warning, once for all, for he has reason to dread
> 
> 
> The Watcher.




Captain Barton read and re-read this strange effusion; in every light and in every direction he turned it over and over; he examined the paper on which it was written, and scrutinized the handwriting once more. Defeated here, he turned to the seal; it was nothing but a patch of wax, upon which the accidental impression of a thumb was imperfectly visible.


There was not the slightest mark, or clue of any kind, to lead him to even a guess as to its possible origin. The writer's object seemed a friendly one, and yet he subscribed himself as one whom he had ‘reason to dread.’ Altogether the letter, its author, and its real purpose were to him an inexplicable puzzle, and one, moreover, unpleasantly suggestive, in his mind, of other associations connected with his last night's adventure.


In obedience to some feeling—perhaps of pride—Mr. Barton did not communicate, even to his intended bride, the occurrences which I have just detailed. Trifling as they might appear, they had in reality most disagreeably affected his imagination, and he cared not to disclose, even to the young lady in question, what she might possibly look upon as evidences of weakness. The letter might very well be but a hoax, and the mysterious footfall but a delusion or a trick. But although he affected to treat the whole



---

p.67




 affair as unworthy of a thought, it yet haunted him pertinaciously, tormenting him with perplexing doubts and depressing him with undefined apprehensions. Certain it is, that for a considerable time afterwards he carefully avoided the street indicated in the letter as the scene of danger.


It was not until about a week after the receipt of the letter which I have transcribed, that anything further occurred to remind Captain Barton of its contents, or to counteract the gradual disappearance from his mind of the disagreeable impressions then received.


He was returning one night, after the interval I have stated, from the theatre, which was then situated in Crow Street, and having there seen Miss Montague and Lady L—— into their carriage he loitered for some time with two or three acquaintances.


With these, however, he parted close to the college, and pursued his way alone. It was now fully one o'clock, and the streets were quite deserted. During the whole of his walk with the companions from whom he had just parted he had been at times painfully aware of the sound of steps, as it seemed, dogging them on their way.


Once or twice he had looked back, in the uneasy anticipation that he was again about to experience the same mysterious annoyances which had so disconcerted him a week before, and earnestly hoping that he might *see* some form to account naturally for the sounds. But the street was deserted—no one was visible.


Proceeding now quite alone upon his homeward way he grew really nervous and uncomfortable, as he



---

p.68




 became sensible, with increased distinctness, of the well-known and now absolutely dreaded sounds.


By the side of the dead wall which bounded the college park, the sounds followed, recommencing almost simultaneously with his own steps. The same unequal pace—sometimes slow, sometimes for a score yards or so, quickened almost to a run—was audible from behind him. Again and again he turned; quickly and stealthily he glanced over his shoulder—almost at every half-dozen steps; but no one was visible.


The irritation of this intangible and unseen pursuit became gradually all but intolerable; and when at last he reached his home his nerves were strung to such a pitch of excitement that he could not rest, and did not attempt even to lie down until after the daylight had broken.


He was awakened by a knock at his chamber-door, and his servant, entering, handed him several letters which had just been received by the penny post. One among them instantly arrested his attention—a single glance at the direction aroused him thoroughly. He at once recognized its character, and read as follows:




> 
> You may as well think, Captain Barton, to escape from your own shadow as from me; do what you may, I will see you as often I please, and you shall see me, for I do not want to hide myself, as you fancy. Do not let it trouble your rest, Captain Barton; for, with a good conscience, what need you fear from the eye of
> 
> 
> The Watcher.






---

p.69


It is scarcely necessary to dwell upon the feelings that accompanied a perusal of this strange communication. Captain Barton was observed to be unusually absent and out of spirits for several days afterwards! But no one divined the cause.


Whatever he might think as to the phantom steps which followed him, there could be no possible illusion about the letters he had received; and, to say the least, their immediate sequence upon the mysterious sounds which had haunted him, was an odd coincidence.


The whole circumstance was, in his own mind, vaguely and instinctively connected with certain passages in his past life, which, of all others, he hated to remember.


It happened, however, that in addition to his own approaching nuptials, Captain Barton had just then—fortunately, perhaps, for himself—some business of an engrossing kind connected with the adjustment of a large and long-litigated claim upon certain properties.


The hurry and excitement of business had its natural effect in gradually dispelling the gloom which had for a time occasionally oppressed him, and in a little while his spirits had entirely recovered their accustomed tone.


During all this time, however, he was, now and then, dismayed by indistinct and half-heard repetitions of the same annoyance, and that in lonely places, in the day-time as well as after nightfall. These renewals of the strange impressions from which he had suffered so much, were, however, desultory and faint, insomuch that often he really



---

p.70




 could not, to his own satisfaction, distinguish between them and the mere suggestions of an excited imagination.


One evening he walked down to the House of Commons with a Member, an acquaintance of his and mine. This was one of the few occasions upon which I have been in company with Captain Barton. As we walked down together, I observed that he became absent and silent, and to a degree that seemed to argue the pressure of some urgent and absorbing anxiety.


I afterwards learned that during the whole of our walk he had heard the well-known footsteps tracking him as we proceeded.


This, however, was the last time he suffered from this phase of the persecution, of which he was already the anxious victim. A new and a very different one was about to be presented.




---

p.71


An Advertisement
----------------


Of the new series of impressions which were afterwards gradually to work out his destiny, I that evening witnessed the fact; and but for its relation to the train of events which followed, the incident would scarcely have been now remembered by me.


As we were walking in at the passage from College Green a man, of whom I remember only that he was short in stature, looked like a foreigner, and wore a kind of fur travelling-cap, walked very rapidly, and, as if under fierce excitement, directly towards us, muttering to himself fast and vehemently the while.


This odd-looking person walked straight toward Barton, who was foremost of the three, and halted, regarding him for a moment or two with a look of maniacal menace and fury; and then turning about as abruptly he walked before us at the same agitated pace and disappeared at a side passage. I do distinctly remember being a good deal shocked at the countenance and bearing of this man, which indeed irresistibly impressed me with an undefined sense of



---

p.72




 danger, such as I have never felt before or since from the presence of anything human; but these sensations were, on my part, far from amounting to anything so disconcerting as to flurry or excite me—I had seen only a singularly evil countenance, agitated, as it seemed, with the excitement of madness.


I was absolutely astonished, however, at the effect of this apparition upon Captain Barton. I knew him to be a man of proud courage and coolness in real danger—a circumstance which made his conduct upon this occasion the more conspicuously odd. He recoiled a step or two as the stranger advanced, and clutched my arm in silence, with what seemed to be a spasm of agony or terror! And then, as the figure disappeared, shoving me roughly back, he followed it for a few paces, stopped in great disorder, and sat down upon a form. I never beheld a countenance more ghastly and haggard.


‘For God's sake, Barton, what is the matter?’ said ——, our companion, really alarmed at his appearance. ‘You're not hurt, are you ?—or unwell? What is it?’


‘What did he say?—I did not hear it—what was it?’ asked Barton, wholly disregarding the question.


‘Nonsense,’ said ——, greatly surprised, ‘who cares what the fellow said ? You are unwell Barton, decidedly unwell; let me call a coach.’


‘Unwell! No—not unwell,’ he said, evidently making an effort to recover his self-possession; ‘but, to say the truth, I am fatigued—a little over-worked—and perhaps over-anxious. You know I have been in Chancery, and the winding-up of a suit is always a



---

p.73




 nervous affair. I have felt uncomfortable all this evening; but I am better now. Come, come—shall we go on?’


‘No, no. Take my advice, Barton, and go home; you really do need rest; you are looking quite ill. I really do insist on your allowing me to see you home,’ replied his friend.


I seconded ——'s advice, the more readily as it was obvious that Barton was not himself disinclined to be persuaded. He left us, declining our offered escort. I was not sufficiently intimate with—to discuss the scene we had both just witnessed. I was, however, convinced from his manner in the few common-place comments and regrets we exchanged, that he was just as little satisfied as I with the extempore plea of illness with which he had accounted for the strange exhibition, and that we were both agreed in suspecting some lurking mystery in the matter.


I called next day at Barton's lodgings to inquire for him, and learned from the servant that he had not left his room since his return the night before; but that he was not seriously indisposed, and hoped to be out in a few days. That evening he sent for Dr. R—— , then in large and fashionable practice in Dublin, and their interview was, it is said, an odd one.


He entered into a detail of his own symptoms in an abstracted and desultory way, which seemed to argue a strange want of interest in his own cure, and, at all events, make it manifest that there was some topic engaging his mind of more engrossing importance than his present ailment. He complained of occasional palpitations and headache.




---

p.74


Doctor R—— asked him, among other questions, whether there was any irritating circumstance or anxiety then occupying his thoughts. This he denied quickly and almost peevishly; and the physician thereupon declared his opinion that there was nothing amiss except some slight derangement of the digestion, for which he accordingly wrote a prescription, and was about to withdraw when Mr. Barton, with the air of a man who recollects a topic which had nearly escaped him, recalled him.


‘I beg your pardon, Doctor, but I really almost forgot; will you permit me to ask you two or three medical questions—rather odd ones, perhaps, but a wager depends upon their solution; you will, I hope, excuse my unreasonableness?’


The physician readily undertook to satisfy the inquirer.


Barton seemed to have some difficulty about opening the proposed interrogatories, for he was silent for a minute, then walked to his book-case, and returned as he had gone; at last he sat down, and said:


‘You'll think them very childish questions, but I can't recover my wager without a decision; so I must put them. I want to know first about lockjaw. If a man actually has had that complaint, and appears to have died of it—so much so, that a physician of average skill pronounces him actually dead—may he, after all, recover?’


The physician smiled, and shook his head.


‘But—but a blunder may be made,’ resumed Barton. ‘Suppose an ignorant pretender to medical skill; may *he* be so deceived by any stage of the



---

p.75




complaint, as to mistake what is only a part of the progress of the disease, for death itself?’


‘No one who had ever seen death,’ answered he, ‘could mistake it in a case of lock-jaw.’


Barton mused for a few minutes. ‘I am going to ask you a question, perhaps, still more childish; but first, tell me, are the regulations of foreign hospitals, such as that of, let us say, Naples, very lax and bungling. May not all kinds of blunders and slips occur in their entries of names, and so forth?’


Doctor R—— professed his incompetence to answer that query.


‘Well, then, Doctor, here is the last of my questions. You will, probably, laugh at it; but it must out nevertheless. Is there any disease, in all the range of human maladies, which would have the effect of perceptibly contracting the stature and the whole frame—causing the man to shrink in all his proportions, and yet to preserve his exact resemblance to himself in every particular—with the one exception, his height and bulk; *any* disease, mark—no matter how rare—how little believed in, generally—which could possibly result in producing such an effect?’


The physician replied with a smile, and a very decided negative.


‘Tell me, then,’ said Barton, abruptly, ‘if a man be in reasonable fear of assault from a lunatic who is at large, can he not procure a warrant for his arrest and detention?’


‘Really, that is more a lawyer's question than one in my way,’ replied Doctor R——; ‘but I believe, on applying to a magistrate, such a course would be directed.’




---

p.76


The physician then took his leave; but, just as he reached the hall-door, remembered that he had left his cane upstairs, and returned. His reappearance was awkward, for a piece of paper, which he recognized as his own prescription, was slowly burning upon the fire, and Barton sitting close by with an expression of settled gloom and dismay.


Doctor R—— had too much tact to observe what presented itself; but he had seen quite enough to assure him that the mind, and not the body, of Captain Barton was in reality the seat of suffering.


A few days afterwards, the following advertisement appeared in the Dublin newspapers:


‘If Sylvester Yelland, formerly a foremast man on board His Majesty's frigate 'Dolphin,' or his nearest of kin, will apply to Mr. Hubert Smith, attorney, at his office, Dame Street, he or they may hear of something greatly to his or their advantage. Admission may be had at any hour up to twelve o'clock at night, should parties desire to avoid observation; and the strictest secrecy, as to all communications intended to be confidential, shall be honourably observed.’ 


The ‘Dolphin,’ as I have mentioned, was the vessel which Captain Barton had commanded; and this circumstance, connected with the extraordinary exertions made by the circulation of hand-bills, etc., as well as by repeated advertisements, to secure for this strange notice the utmost possible publicity, suggested to Dr. R—— the idea that Captain Barton's extreme uneasiness was somehow connected with the individual to whom the advertisement was addressed, and he himself the author of it.




---

p.77


This, however, it is needless to add, was no more than a conjecture. No information, whatsoever, as to the real purpose of the advertisement was divulged by the agent, nor yet any hint as to who his employer might be.




---

p.78


He talks with a Clergyman
-------------------------


Mr. Barton, although he had latterly begun to earn for himself the character of an hypochondriac, was yet very far from deserving it. Though by no means lively, he had yet, naturally, what are termed ‘even spirits,’ and was not subject to undue depressions.


He soon, therefore, began to return to his former habits; and one of the earnest symptoms of this healthier tone of spirits was his appearing at a grand dinner of the Freemasons, of which worthy fraternity he was himself a brother. Barton, who had been at first gloomy and abstracted, drank much more freely than was his wont—possibly with the purpose of dispelling his own secret anxieties—and under the influence of good wine and pleasant company, became gradually (unlike himself) talkative, and even noisy.


It was under this unwonted excitement that he left his company at about half-past ten o'clock; and, as conviviality is a strong incentive to gallantry, it



---

p.79




 occurred to him to proceed forthwith to Lady L——'s, and pass the remainder of the evening with her and his destined bride.


Accordingly, he was soon at —— Street, and chatting gaily with the ladies. It is not to be supposed that Captain Barton had exceeded the limits which propriety prescribes to good fellowship—he had merely taken enough wine to raise his spirits, without, however, in the least degree unsteadying his mind, or affecting his manners.


With this undue elevation of spirits had supervened an entire oblivion or contempt of those undefined apprehensions which had for so long weighed upon his mind, and to a certain extent estranged him from society; but as the night wore away, and his artificial gaiety began to flag, these painful feelings gradually intruded themselves again, and he grew abstracted and anxious as heretofore.


He took his leave at length, with an unpleasant foreboding of some coming mischief, and with a mind haunted with a thousand mysterious apprehensions, such as, even while he acutely felt their pressure, he, nevertheless, inwardly strove or affected to contemn.


It was this proud defiance of what he regarded as his own weakness, which prompted him upon the present occasion to that course which brought about the adventure I am now about to relate.


Mr. Barton might have easily called a coach, but he was conscious that his strong inclination to do so proceeded from no cause other than what he desperately persisted in representing to himself to be his own superstitious tremors.


He might also have returned home by a route



---

p.80




 different from that against which he had been warned by his mysterious correspondent; but for the same reason he dismissed this idea also, and with a dogged and half desperate resolution to force matters to a crisis of some kind, if there were any reality in the causes of his former suffering, and if not, satisfactorily to bring their delusiveness to the proof, he determined to follow precisely the course which he had trodden upon the night so painfully memorable in his own mind as that on which his strange persecution commenced. Though, sooth to say, the pilot who for the first time steers his vessel under the muzzles of a hostile battery, never felt his resolution more severely tasked than did Captain Barton, as he breathlessly pursued this solitary path—a path which, spite of every effort of scepticism and reason, he felt to be infested by some (as respected *him*) malignant being.


He pursued his way steadily and rapidly, scarcely breathing from intensity of suspense; he, however, was troubled by no renewal of the dreaded footsteps, and was beginning to feel a return of confidence, as, more than three-fourths of the way being accomplished with impunity, he approached the long line of twinkling oil lamps which indicated the frequented streets.


This feeling of self-congratulation was, however, but momentary. The report of a musket at some hundred yards behind him, and the whistle of a bullet close to his head, disagreeably and startlingly dispelled it. His first impulse was to retrace his steps in pursuit of the assassin; but the road on either side was, as we have said, embarrassed by the foundations



---

p.81




 of a street, beyond which extended waste fields, full of rubbish and neglected lime and brick-kilns, and all now as utterly silent as though no sound had ever disturbed their dark and unsightly solitude. The futility of, single-handed, attempting, under such circumstances, a search for the murderer, was apparent; especially as no sound, either of retreating steps or any other kind, was audible to direct his pursuit.


With the tumultuous sensations of one whose life has just been exposed to a murderous attempt, and whose escape has been the narrowest possible, Captain Barton turned again; and without, however, quickening his pace actually to a run, hurriedly pursued his way.


He had turned, as I have said, after a pause of a few seconds, and had just commenced his rapid retreat, when on a sudden he met the well-remembered little man in the fur cap. The encounter was but momentary. The figure was walking at the same exaggerated pace, and with the same strange air of menace as before; and as it passed him he thought he heard it say, in a furious whisper, ‘Still alive, still alive!’


The state of Mr. Barton's spirits began now to work a corresponding alteration in his health and looks, and to such a degree that it was impossible that the change should escape general remark.


For some reasons, known but to himself, he took no steps whatsoever to bring the attempt upon his life, which he had so narrowly escaped, under the notice of the authorities; on the contrary, he kept it jealously to himself; and it was not for many weeks after the occurrence that he mentioned it, and then in strict



---

p.82




 confidence, to a gentleman, whom the torments of his mind at last compelled him to consult.


Spite of his blue devils, however, poor Barton, having no satisfactory reason to render to the public for any undue remissness in the attentions exacted by the relation existing between him and Miss Montague, was obliged to exert himself, and present to the world a confident and cheerful bearing.


The true source of his sufferings, and every circumstance connected with him, he guarded with a reserve so jealous, that it seemed dictated by at least a suspicion that the origin of his strange persecution was known to himself, and that it was of a nature which, upon his own account, he could not or dared not disclose.


The mind thus turned in upon itself, and constantly occupied with a haunting anxiety which it dared not reveal or confide to any human breast, became daily more excited, and, of course, more vividly impressible, by a system of attack which operated through the nervous system; and in this state he was destined to sustain, with increasing frequency, the stealthy visitations of that apparition which, from the first, had seemed to possess so terrible a hold upon his imagination.


It was about this time that Captain Barton called upon the then celebrated preacher, Dr. ——, with whom he had a slight acquaintance, and an extraordinary conversation ensued.


The divine was seated in his chambers in college, surrounded with works upon his favourite pursuit, and deep in theology, when Barton was announced.




---

p.83


There was something at once embarrassed and excited in his manner, which, along with his wan and haggard countenance, impressed the student with the unpleasant consciousness that his visitor must have recently suffered terribly indeed, to account for an alteration so striking—almost shocking.


After the usual interchange of polite greeting, and a few common-place remarks, Captain Barton, who obviously perceived the surprise which his visit had excited, and which Doctor —— was unable wholly to conceal, interrupted a brief pause by remarking:


‘This is a strange call, Doctor ——, perhaps scarcely warranted by an acquaintance so slight as mine with you. I should not under ordinary circumstances have ventured to disturb you; but my visit is neither an idle nor impertinent intrusion. I am sure you will not so account it, when I tell you how afflicted I am.’


Doctor —— interrupted him with assurances such as good breeding suggested, and Barton resumed—


‘I am come to task your patience by asking your advice. When I say your patience, I might, indeed, say more; I might have said your humanity—your compassion; for I have been and am a great sufferer.’


‘My dear sir,’ replied the churchman, ‘it will, indeed, afford me infinite gratification if I can give you comfort in any distress of mind! but—you know ——’


‘I know what you would say,’ resumed Barton, quickly; ‘I am an unbeliever, and, therefore, incapable of deriving help from religion; but don't take



---

p.84




that for granted. At least you must not assume that, however unsettled my convictions may be, I do not feel a deep—a very deep—interest in the subject. Circumstances have lately forced it upon my attention in such a way as to compel me to review the whole question in a more candid and teachable spirit, I believe, than I ever studied it in before.’


‘Your difficulties, I take it for granted, refer to the evidences of revelation,’ suggested the clergyman.


‘Why—no—not altogether; in fact, I am ashamed to say I have not considered even my objections sufficiently to state them connectedly; but—but there is one subject on which I feel a peculiar interest.’


He paused again, and Doctor pressed him to proceed.


‘The fact is,’ said Barton, ‘whatever may be my uncertainty as to the authenticity of what we are taught to call revelation, of one fact I am deeply and horribly convinced, that there does exist beyond this a spiritual world—a system whose workings are generally in mercy hidden from us—a system which may be, and which is sometimes, partially and terribly revealed. I am sure—I *know*,’ continued Barton, with increasing excitement, ‘that there is a God—a dreadful God—and that retribution follows guilt, in ways the most mysterious and stupendous—by agencies the most inexplicable and terrific;—there is a spiritual system—great God, how I have been convinced!—a system malignant, and implacable, and omnipotent, under whose persecutions I am, and have been, suffering the torments of the damned!—yes, sir—yes—the fires and frenzy of hell!’




---

p.85


As Barton spoke, his agitation became so vehement that the *divine* was shocked, and even alarmed. The wild and excited rapidity with which he spoke, and, above all, the indefinable horror that stamped his features, afforded a contrast to his ordinary cool and unimpassioned self-possession striking and painful in the last degree.




---

p.86


Mr. Barton states his Case
--------------------------


‘My dear sir,’ said Doctor ——, after a brief pause, ‘I fear you have been very unhappy, indeed; but I venture to predict that the depression under which you labour will be found to originate in purely physical causes, and that with a change of air, and the aid of a few tonics, your spirits will return, and the tone of your mind be once more cheerful and tranquil as heretofore. There was, after all, more truth than we are quite willing to admit in the classic theories which assigned the undue predominance of any one affection of the mind ,to the undue action or torpidity of one or other of our bodily organs. Believe me, that a little attention to diet, exercise, and the other essentials of health, under competent direction, will make you as much yourself as you can wish.’


‘Doctor ——,’ said Barton, with something like a shudder, ‘I *cannot* delude myself with such a hope. I have no hope to cling to but one, and that is, that by some other spiritual agency more potent than that which tortures me, *it* may be combated, and I delivered.



---

p.87




 If this may not be, I am lost—now and for ever lost.’


‘But, Mr. Barton, you must remember,’ urged his companion, ‘that others have suffered as you have done, and ——’


‘No, no, no,’ interrupted he, with irritability—‘no, sir, I am not a credulous—far from a superstitious man. I have been, perhaps, too much the reverse—too sceptical, too slow of belief; but unless I were one whom no amount of evidence could convince, unless I were to contemn the repeated, the *perpetual* evidence of my own senses, I am now—now at last constrained to believe—I have no escape from the conviction—the overwhelming certainty—that I am haunted and dogged, go where I may, by—by a DEMON!’


There was a preternatural energy of horror in Barton's face, as, with its damp and death-like lineaments turned towards his companion, he thus delivered himself.


‘God help you, my poor friend,’ said Dr. ——, much shocked, ‘God help you; for, indeed, you *are* a sufferer, however your sufferings may have been caused.’


‘Ay, ay, God help me,’ echoed Barton, sternly; ‘but *will* He help me—will He help me?’


‘Pray to Him—pray in an humble and trusting spirit,’ said he.


‘Pray, pray,’ echoed he again; ‘I can't pray—I could as easily move a mountain by an effort of my will. I have not belief enough to pray; there is something within me that will not pray. You prescribe impossibilities—literal impossibilities.’




---

p.88


‘You will not find it so, if you will but try,’ said Doctor ——.


‘Try! I *have* tried, and the attempt only fills me with confusion: and, sometimes, terror: I have tried in vain, and more than in vain. The awful, unutterable idea of eternity and infinity oppresses and maddens my brain whenever my mind approaches the contemplation of the Creator: I recoil from the effort scared. I tell you, Doctor ——, if I am to be saved, it must be by other means. The idea of an eternal Creator is to me intolerable—my mind cannot support it.’


‘Say, then, my dear sir,’ urged he, ‘say how you would have me serve you—what you would learn of me—what I can do or say to relieve you?’


‘Listen to me first,’ replied Captain Barton; with a subdued air, and an effort to suppress his excitement, ‘listen to me while I detail the circumstances of the persecution under which my life has become all but intolerable—a persecution which has made me fear *death* and the world beyond the grave as much as I have grown to hate existence.’


Barton then proceeded to relate the circumstances which I have already detailed, and then continued:


‘This has now become habitual—an accustomed thing. I do not mean the actual seeing him in the flesh—thank God, *that* at least is not permitted daily. Thank God, from the ineffable horrors of that visitation I have been mercifully allowed intervals of repose, though none of security; but from the consciousness that a malignant spirit is following and watching me wherever I go, I have never, for a single instant, a temporary respite. I am pursued with



---

p.89




 blasphemies, cries of despair, and appalling hatred. I hear those dreadful sounds called after me as I turn the corners of the streets; they come in the night-time, while I sit in my chamber alone; they haunt me everywhere, charging me with hideous crimes, and—great God!—threatening me with coming vengeance and eternal misery. Hush! do you hear *that*?’ he cried, with a horrible smile of triumph; ‘there—there, will that convince you?’


The clergyman felt a chill of horror steal over him, while, during the wail of a sudden gust of wind, he heard, or fancied he heard, the half-articulate sounds of rage and derision mingling in the sough.


‘Well, what do you think of *that*?’ at length Barton cried, drawing a long breath through his teeth.


‘I heard the wind,’ said Doctor ——. ‘What should I think of it—what is there remarkable about it?’


‘The prince of the powers of the air,’ muttered Barton, with a shudder.


‘Tut, tut! my dear sir,’ said the student, with an effort to reassure himself; for though it was broad daylight there was nevertheless something disagreeably contagious in the nervous excitement under which his visitor so miserably suffered. ‘You must not give way to these wild fancies; you must resist these impulses of the imagination.’


‘Ay, ay; ‘resist the devil and he will flee from thee,’’ said Barton, in the same tone; ‘but *how* resist him? ay, there it is—there is the rub. What—*what* am I to do? what *can* I do?’




---

p.90


‘My dear sir, this *is* fancy,’ said the man of folios; ‘you are your own tormentor.’


‘No, no, sir—fancy has no part in it,’ answered Barton, somewhat sternly. ‘Fancy! was it that made *you*, as well as me, hear, but this moment, those accents of hell? Fancy, indeed! No, no.’


‘But you have seen this person frequently,’ said the ecclesiastic; ‘why have you not accosted or secured him? Is it not a little precipitate, to say no more, to assume, as you have done, the existence of preternatural agency; when, after all, everything may be easily accountable, if only proper means were taken to sift the matter.’


‘There are circumstances connected with this—this *appearance*,’ said Barton, ‘which it is needless to disclose, but which to *me* are proofs of its horrible nature. I know that the being that follows me is not human—I say I *know* this; I could prove it to your own conviction.’ He paused for a minute, and then added, ‘And as to accosting it, I dare not, I could not; when I see it I am powerless; I stand in the gaze of death, in the triumphant presence of infernal power and malignity. My strength, and faculties, and memory, all forsake me. O God, I fear, sir, you know not what you speak of. Mercy, mercy; heaven have pity on me!’


He leaned his elbow on the table, and passed his hand across his eyes, as if to exclude some image of horror, muttering the last words of the sentence he had just concluded again and again.


‘Doctor ——,’ he said, abruptly raising himself, and looking full upon the clergyman with an imploring eye, ‘I know you will do for me whatever may be



---

p.91




 done. You know now fully the circumstances and the nature of my affliction. I tell you I cannot help myself; I cannot hope to escape; I am utterly passive. I conjure you, then, to weigh my case well, and if anything may be done for me by vicarious supplication—by the intercession of the good—or by any aid or influence whatsoever, I implore of you, I adjure you in the name of the Most High, give me the benefit of that influence—deliver me from the body of this death. Strive for me, pity me; I know you will; you cannot refuse this; it is the purpose and object of my visit. Send me away with some hope—however little—some faint hope of ultimate deliverance, and I will nerve myself to endure, from hour to hour, the hideous dream into which my existence has been transformed.’


Doctor —— assured him that all he could do was to pray earnestly for him, and that so much he would not fail to do. They parted with a hurried and melancholy valediction. Barton hastened to the carriage that awaited him at the door, drew down the blinds, and drove away, while Doctor —— returned to his chamber, to ruminate at leisure upon the strange interview which had just interrupted his studies.




---

p.92


Seen Again
----------


It was not to be expected that Captain Barton's changed and eccentric habits should long escape remark and discussion. Various were the theories suggested to account for it. Some attributed the alteration to the pressure of secret pecuniary embarrassments; others to a repugnance to fulfil an engagement into which he was presumed to have too precipitately entered; and others, again, to the supposed incipiency of mental disease, which latter, indeed, was the most plausible, as well as the most generally received, of the hypotheses circulated in the gossip of the day.


From the very commencement of this change, at first so gradual in its advances, Miss Montague had of course been aware of it. The intimacy involved in their peculiar relation, as well as the near interest which it inspired, afforded, in her case, a like opportunity and motive for the successful exercise of that keen and penetrating observation peculiar to her sex.


His visits became, at length, so interrupted, and



---

p.93




 his manner, while they lasted, so abstracted, strange, and agitated, that Lady L——, after hinting her anxiety and her suspicions more than once, at length distinctly stated her anxiety, and pressed for an explanation.


The explanation was given, and although its nature at first relieved the worst solicitudes of the old lady and her niece, yet the circumstances which attended it, and the really dreadful consequences which it obviously indicated, as regarded the spirits, and indeed the reason of the now wretched man, who made the strange declaration, were enough, upon little reflection, to fill their minds with perturbation and alarm.


General Montague, the young lady's father, at length arrived. He had himself slightly known Barton, some ten or twelve years previously, and being aware of his fortune and connexions, was disposed to regard him as an unexceptionable and indeed a most desirable match for his daughter. He laughed at the story of Barton's supernatural visitations, and lost no time in calling upon his intended son-in-law.


‘My dear Barton,’ he continued, gaily, after a little conversation, ‘my sister tells me that you are a victim to blue devils, in quite a new and original shape.’


Barton changed countenance, and sighed profoundly.


‘Come, come; I protest this will never do,’ continued the General; ‘you are more like a man on his way to the gallows than to the altar. These devils have made quite a saint of you.’


Barton made an effort to change the conversation.




---

p.94


‘No, no, it won't do,’ said his visitor laughing; ‘I am resolved to say what I have to say upon this magnificent mock mystery of yours. You must not be angry, but really it is too bad to see you at your time of life absolutely frightened into good behaviour, like a naughty child, by a bugaboo, and as far as I can learn, a very contemptible one. Seriously, I have been a good deal annoyed at what they tell me; but at the same time thoroughly convinced that there is nothing in the matter that may not be cleared up, with a little attention and management, within a week at furthest.’


‘Ah, General, you do not know ——’ he began.


‘Yes, but I do know quite enough to warrant my confidence,’ interrupted the soldier; ‘don't I know that all your annoyance proceeds from the occasional appearance of a certain little man in a cap and greatcoat, with a red vest and a bad face, who follows you about, and pops upon you at corners of lanes, and throws you into ague fits. Now, my dear fellow, I'll make it my business to *catch* this mischievous little mountebank, and either beat him to a jelly with my own hands, or have him whipped through the town, at the cart's tail, before a month passes.’


‘If *you* knew what *I* knew,’ said Barton, with gloomy agitation, ‘you would speak very differently. Don't imagine that I am so weak as to assume, without proof the most overwhelming, the conclusion to which I have been forced—the proofs are here, locked up here.’ As he spoke he tapped upon his breast, and with an anxious sigh continued to walk up and down the room.


‘Well, well, Barton,’ said his visitor, ‘I'll wager



---

p.95




 a rump and a dozen I collar the ghost, and convince even you before many days are over.’


He was running on in the same strain when he was suddenly arrested, and not a little shocked, by observing Barton, who had approached the window, stagger slowly back, like one who had received a stunning blow; his arm extended toward the street—his face and his very lips white as ashes—while he muttered, ‘There—by heaven!—there—there!’


General Montague started mechanically to his feet, and from the window of the drawing-room saw a figure corresponding, as well as his hurry would permit him to discern, with the description of the person whose appearance so persistently disturbed the repose of his friend.


The figure was just turning from the rails of the area upon which it had been leaning, and, without waiting to see more, the old gentleman snatched his cane and hat, and rushed down the stairs and into the street, in the furious hope of securing the person, and punishing the audacity of the mysterious stranger.


He looked round him, but in vain, for any trace of the person he had himself distinctly seen. He ran breathlessly to the nearest corner, expecting to see from thence the retiring figure, but no such form was visible. Back and forward, from crossing to crossing, he ran, at fault, and it was not until the curious gaze and laughing countenances of the passers-by reminded him of the absurdity of his pursuit, that he checked his hurried pace, lowered his walking cane from the menacing altitude which he had mechanically given it, adjusted his hat, and walked composedly back



---

p.96




 again, inwardly vexed and flurried. He found Barton pale and trembling in every joint; they both remained silent, though under emotions very different. At last Barton whispered, ‘You saw it?’


‘*It*—him—some one—you mean—to be sure I did,’ replied Montague, testily. ‘But where is the good or the harm of seeing him? The fellow runs like a lamplighter. I wanted to *catch* him, but he had stolen away before I could reach the hall door. However, it is no great matter; next time, I dare say, I'll do better; and, egad, if I once come within reach of him, I'll introduce his shoulders to the weight of my cane.’


Notwithstanding General Montague's undertakings and exhortations, however, Barton continued to suffer from the self-same unexplained cause; go how, when, or where he would, he was still constantly dogged or confronted by the being who had established over him so horrible an influence.


Nowhere and at no time was he secure against the odious appearance which haunted him with such diabolic perseverance.


His depression, misery, and excitement became more settled and alarming every day, and the mental agonies that ceaselessly *preyed* upon him, began at last so sensibly to affect his health, that Lady L—— and General Montague succeeded, without, indeed, much difficulty, in persuading him to try a short tour on the Continent, in the hope that an entire change of scene would, at all events, have the effect of breaking through the influences of local association, which the more sceptical of his friends assumed to be by no means inoperative in suggesting and perpetuating



---

p.97




 what they conceived to be a mere form of nervous illusion.


General Montague indeed was persuaded that the figure which haunted his intended son-in-law was by no means the creation of his imagination, but, on the contrary, a substantial form of flesh and blood, animated by a resolution, perhaps with some murderous object in perspective, to watch and follow the unfortunate gentleman.


Even this hypothesis was not a very pleasant one; yet it was plain that if Barton could ever be convinced that there was nothing preternatural in the phenomenon which he had hitherto regarded in that light, the affair would lose all its terrors in his eyes, and wholly cease to exercise upon his health and spirits the baleful influence which it had hitherto done. He therefore reasoned, that if the annoyance were actually escaped by mere locomotion and change of scene, it obviously could not have originated in any supernatural agency.




---

p.98


Flight
------


Yielding to their persuasions, Barton left Dublin for England, accompanied by General Montague. They posted rapidly to London, and thence to Dover, whence they took the packet with a fair wind for Calais. The General's confidence in the result of the expedition on Barton's spirits had risen day by day, since their departure from the shores of Ireland; for to the inexpressible relief and delight of the latter, he had not since then so much as even once fancied a repetition of those impressions which had, when at home, drawn him gradually down to the very depths of despair.


This exemption from what he had begun to regard as the inevitable condition of his existence, and the sense of security which began to pervade his mind, were inexpressibly delightful; and in the exultation of what he considered his deliverance, he indulged in a thousand happy anticipations for a future into which so lately he had hardly dared to look; and, in short,



---

p.99




 both he and his companion secretly congratulated themselves upon the termination of that persecution which had been to its immediate victim a source of such unspeakable agony.


It was a beautiful day, and a crowd of idlers stood upon the jetty to receive the packet, and enjoy the bustle of the new arrivals. Montague walked a few paces in advance of his friend, and as he made his way through the crowd, a little man touched his arm and said to him, in a broad provincial patois:


‘Monsieur is walking too fast; he will lose his sick comrade in the throng, for, by my faith, the poor gentleman seems to be fainting.’


Montague turned quickly, and observed that Barton did indeed look deadly pale. He hastened to his side.


‘My dear fellow, are you ill?’ he asked anxiously.


The question was unheeded, and twice repeated, ere Barton stammered — 


‘I saw him—by ——, I saw him!’


‘*Him!*—the wretch—who—where now?—where is he?’ cried Montague, looking around him.


‘I saw him—but he is gone,’ repeated Barton, faintly.


‘But where—where? For God's sake speak,’ urged Montague, vehemently.


‘It is but this moment—*here*,’ said he.


‘But what did he look like—what had he on—what did he wear—quick, quick,’ urged his excited companion, ready to dart among the crowd and collar the delinquent on the spot.


‘He touched your arm—he spoke to you—he pointed to me. God be merciful to me, there is no



---

p.100




 escape,’ said Barton, in the low, subdued tones of despair.


Montague had already bustled away in all the flurry of mingled hope and rage; but though the singular personnel of the stranger who had accosted him was vividly impressed upon his recollection, he failed to discover among the crowd even the slightest resemblance to him.


After a fruitless search, in which he enlisted the services of several of the bystanders, who aided all the more zealously, as they believed he had been robbed, he at length, out of breath and baffled, gave over the attempt.


‘Ah, my friend, it won't do,’ said Barton, with the faint voice and bewildered, ghastly look of one who had been stunned by some mortal shock; ‘there is no use in contending; whatever it is, the dreadful association between me and it is now established—I shall never escape—never!’


‘Nonsense, nonsense, my dear Barton; don't talk so,’ said Montague, with something at once of irritation and dismay; ‘you must not, I say; we'll jockey the scoundrel yet; never mind, I say—never mind.’


It was, however, but labour lost to endeavour henceforward to inspire Barton with one ray of hope; he became desponding.


This intangible and, as it seemed, utterly inadequate influence was fast destroying his energies of intellect, character, and health. His first object was now to return to Ireland, there, as he believed, and now almost hoped, speedily to die.


To Ireland accordingly he came, and one of the first faces he saw upon the shore, was again that of his



---

p.101




 implacable and dreaded attendant. Barton seemed at last to have lost not only all enjoyment and every hope in existence, but all independence of will besides. He now submitted himself passively to the management of the friends most nearly interested in his welfare.


With the apathy of entire despair, he implicitly assented to whatever measures they suggested and advised; and as a last resource, it was determined to remove him to a house of Lady L——'s, in the neighbourhood of Clontarf, where, with the advice of his medical attendant, who persisted in his opinion that the whole train of consequences resulted merely from some nervous derangement, it was resolved that he was to confine himself strictly to the house, and make use only of those apartments which commanded a view of an enclosed yard, the gates of which were to be kept jealously locked.


Those precautions would certainly secure him against the casual appearance of any living form that his excited imagination might possibly confound with the spectre which, as it was contended, his fancy recognized in every figure that bore even a distant or general resemblance to the peculiarities with which his fancy had at first invested it.


A month or six weeks' absolute seclusion under these conditions, it was hoped might, by interrupting the series of these terrible impressions, gradually dispel the predisposing apprehensions, and the associations which had confirmed the supposed disease, and rendered recovery hopeless.


Cheerful society and that of his friends was to be constantly supplied, and on the whole, very sanguine



---

p.102




 expectations were indulged in, that under the treatment thus detailed, the obstinate hypochondria of the patient might at length give way.


Accompanied, therefore, by Lady L——, General Montague and his daughter—his own affianced bride—poor Barton—himself never daring to cherish a hope of his ultimate emancipation from the horrors under which his life was literally wasting away—took possession of the apartments, whose situation protected him against the intrusions from which he shrank with such unutterable terror.


After a little time, a steady persistence in this system began to manifest its results, in a very marked though gradual improvement, alike in the health and spirits of the invalid. Not, indeed, that anything at all approaching complete recovery was yet discernible. On the contrary, to those who had not seen him since the commencement of his strange sufferings, such an alteration would have been apparent as might well have shocked them.


The improvement, however, such as it was, was welcomed with gratitude and delight, especially by the young lady, whom her attachment to him, as well as her now singularly painful position, consequent on his protracted illness, rendered an object scarcely one degree less to be commiserated than himself.


A week passed—a fortnight—a month—and yet there had been no recurrence of the hated visitation. The treatment had, so far forth, been followed by complete success. The chain of associations was broken. The constant pressure upon the overtasked spirits had been removed, and, under these comparatively



---

p.103




 favourable circumstances, the sense of social community with the world about him, and something of human interest, if not of enjoyment, began to reanimate him.


It was about this time that Lady L—— who, like most old ladies of the day, was deep in family receipts, and a great pretender to medical science, dispatched her own maid to the kitchen garden, with a list of herbs, which were there to be carefully culled and brought back to her housekeeper for the purpose stated. The handmaiden, however, returned with her task scarce half completed, and a good deal flurried and alarmed. Her mode of accounting for her precipitate retreat and evident agitation was odd and, to the old lady, startling.




---

p.104


Softened
--------


It appeared that she had repaired to the kitchen garden, pursuant to her mistress's directions, and had there begun to make the specified election among the rank and neglected herbs which crowded one corner of the enclosure; and while engaged in this pleasant labour, she carelessly sang a fragment of an old song, as she said, ‘to keep herself company.’ She was, however, interrupted by an ill-natured laugh; and, looking up, she saw through the old thorn hedge, which surrounded the garden, a singularly ill-looking little man, whose countenance wore the stamp of menace and malignity, standing close to her at the other side of the hawthorn screen.


She described herself as utterly unable to move or speak, while he charged her with a message for Captain Barton; the substance of which she distinctly remembered to have been to the effect, that he, Captain Barton, must come abroad as usual, and show himself to his friends out of doors, or else prepare for a visit in his own chamber.




---

p.105


On concluding this brief message, the stranger had, with a threatening air, got down into the outer ditch, and, seizing the hawthorn stems in his hands, seemed on the point of climbing through the fence—a feat which might have been accomplished without much difficulty.


Without, of course, awaiting this result, the girl—throwing down her treasures of thyme and rosemary—had turned and run, with the swiftness of terror, to the house. Lady L—— commanded her, on pain of instant dismissal, to observe an absolute silence respecting all that passed of the incident which related to Captain Barton; and, at the same time, directed instant search to be made by her men in the garden and the fields adjacent. This measure, however, was as usual, unsuccessful, and, filled with indefinable misgivings, Lady L—— communicated the incident to her brother. The story, however, until long afterwards, went no further, and, of course, it was jealously guarded from Barton, who continued to amend though slowly.


Barton now began to walk occasionally in the court-yard which I have mentioned, and which, being enclosed by a high wall, commanded no view beyond its own extent. Here he, therefore, considered himself perfectly secure: and, but for a careless violation of orders by one of the grooms, he might have enjoyed, at least for some time longer, his much-prized immunity. Opening upon the public road, this yard was entered by a wooden gate, with a wicket in it, and was further defended by an iron gate upon the outside. Strict orders had been given to keep both carefully locked; but, spite of these, it had



---

p.106




 happened that one day, as Barton was slowly pacing this narrow enclosure, in his accustomed walk, and reaching the farther extremity, was turning to retrace his steps, he saw the boarded wicket ajar, and the face of his tormentor immovably looking at him through the iron bars. For a few seconds he stood riveted to the earth—breathless and bloodless—in the fascination of that dreaded gaze, and then fell helplessly insensible upon the pavement.


There he was found a few minutes afterwards, and conveyed to his room—the apartment which he was never afterwards to leave alive. Henceforward a marked and unaccountable change was observable in the tone of his mind. Captain Barton was now no longer the excited and despairing man he had been before; a strange alteration had passed upon him—an unearthly tranquillity reigned in his mind—it was the anticipated stillness of the grave.


‘Montague, my friend, this struggle is nearly ended now,’ he said, tranquilly, but with a look of fixed and fearful awe. ‘I have, at last, some comfort from that world of spirits from which my punishment has come. I now know that my sufferings will soon be over.’


Montague pressed him to speak on.


‘Yes,’ said he, in a softened voice, ‘my punishment is nearly ended. From sorrow, perhaps, I shall never, in time or eternity, escape; but my *agony* is almost over. Comfort has been revealed to me, and what remains of my allotted struggle I will bear with submission—even with hope.’


‘I am glad to hear you speak so tranquilly, my dear Barton,’ said Montague; ‘peace and cheer of



---

p.107




 mind are all you need to make you what you were.’


‘No, no—I never can be that,’ said he mournfully. ‘I am no longer fit for life. I am soon to die. I am to see *him* but once again, and then all is ended.’


‘He said so, then?’ suggested Montague.


‘*He?*—No, no: good tidings could scarcely come through him; and these were good and welcome; and they came so solemnly and sweetly—with unutterable love and melancholy, such as I could not—without saying more than is needful, or fitting, of other long past scenes and persons—fully explain to you.’ As Barton said this he shed tears.


‘Come, come,’ said Montague, mistaking the source of his emotions, ‘you must not give way. What is it, after all, but a pack of dreams and nonsense; or, at worst, the practices of a scheming rascal that enjoys his power of playing upon your nerves, and loves to exert it—a sneaking vagabond that owes you a grudge, and pays it off this way, not daring to try a more manly one.’


‘A grudge, indeed, he owes me—you say rightly,’ said Barton, with a sudden shudder; ‘a grudge as you call it. Oh, my God! when the justice of Heaven permits the Evil one to carry out a scheme of vengeance—when its execution is committed to the lost and terrible victim of sin, who owes his own ruin to the man, the very man, whom he is commissioned to pursue—then, indeed, the torments and terrors of hell are anticipated on earth. But heaven has dealt mercifully with me—hope has opened to me at last; and if death could come without the dreadful sight I am doomed to see, I would gladly close my



---

p.108




 eyes this moment upon the world. But though death is welcome, I shrink with an agony you cannot understand—an actual frenzy of terror—from the last encounter with that—that DEMON, who has drawn me thus to the verge of the chasm, and who is himself to plunge me down. I am to see him again—once more—but under circumstances unutterably more terrific than ever.’


As Barton thus spoke, he trembled so violently that Montague was really alarmed at the extremity of his sudden agitation, and hastened to lead him back to the topic which had before seemed to exert so tranquillizing an effect upon his mind.


‘It was not a dream,’ he said, after a time; ‘I was in a different state—I felt differently and strangely; and yet it was all as real, as clear and vivid, as what I now see and hear—it was a reality.’


‘And what *did* you see and hear?’ urged his companion.


‘When I wakened from the swoon I fell into on seeing *him*,’ said Barton, continuing as if he had not heard the question, ‘it was slowly, very slowly—I was lying by the margin of a broad lake, with misty hills all round, and a soft, melancholy, rose-coloured light illuminated it all. It was unusually sad and lonely, and yet more beautiful than any earthly scene. My head was leaning on the lap of a girl, and she was singing a song, that told, I know not how—whether by words or harmonies—of all my life—all that is past, and all that is still to come; and with the song the old feelings that I thought had perished within me came back, and tears flowed from my eyes—partly for the song and its mysterious beauty, and



---

p.109




 partly for the unearthly sweetness of her voice; and yet I knew the voice—oh! how well; and I was spellbound as I listened and looked at the solitary scene, without stirring, almost without breathing—and, alas! alas! without turning my eyes towards the face that I knew was near me, so sweetly powerful was the enchantment that held me. And so, slowly, the song and scene grew fainter, and fainter, to my senses, till all was dark and still again. And then I awoke to this world, as you saw, comforted, for I knew that I was forgiven much.’ Barton wept again long and bitterly.


From this time, as we have said, the prevailing tone of his mind was one of profound and tranquil melancholy. This, however, was not without its interruptions. He was thoroughly impressed with the conviction that he was to experience another and a final visitation, transcending in horror all he had before experienced. From this anticipated and unknown agony he often shrank in such paroxysms of abject terror and distraction, as filled the whole household with dismay and superstitious panic. Even those among them who affected to discredit the theory of preternatural agency, were often in their secret souls visited during the silence of night with qualms and apprehensions, which they would not have readily confessed; and none of them attempted to dissuade Barton from the resolution on which he now systematically acted, of shutting himself up in his own apartment. The window-blinds of this room were kept jealously down, and his own man was seldom out of his presence, day or night, his bed being placed in the same chamber.




---

p.110


This man was an attached and respectable servant; and his duties, in addition to those ordinarily imposed upon valets, but which Barton's independent habits generally dispensed with, were to attend carefully to the simple precautions by means of which his master hoped to exclude the dreaded intrusion of the ‘Watcher.’ And, in addition to attending to whose arrangements, which amounted merely to guarding against the possibility of his master's being, through any unscreened window or open door, exposed to the dreaded influence, the valet was never to suffer him to be alone—total solitude, even for a minute, had become to him now almost as intolerable as the idea of going abroad into the public ways—it was an instinctive anticipation of what was coming.




---

p.111


Requiescat
----------


It is needless to say, that under these circumstances, no steps were taken toward the fulfilment of that engagement into which he had entered. There was quite disparity enough in point of years, and indeed of habits, between the young lady and Captain Barton to have precluded anything like very vehement or romantic attachment on her part. Though grieved and anxious, therefore, she was very far from being heart-broken.


Miss Montague, however, devoted much of her time to the patient but fruitless attempt to cheer the unhappy invalid. She read to him and conversed with him; but it was apparent that whatever exertions he made, the endeavour to escape from the one ever waking fear that preyed upon him was utterly and miserably unavailing.


Young ladies are much given to the cultivation of pets; and among those who shared the favour of Miss Montague was a fine old owl, which the gardener,



---

p.112




who caught him napping among the ivy of a ruined stable, had dutifully presented to that young lady.


The caprice which regulates such preferences was manifested in the extravagant favour with which this grim and ill-favoured bird was at once distinguished by his mistress; and, trifling as this whimsical circumstance may seem, I am forced to mention it, inasmuch as it is connected, oddly enough, with the concluding scene of the story.


Barton, so far from sharing in this liking for the new favourite, regarded it from the first with an antipathy as violent as it was utterly unaccountable. Its very vicinity was unsupportable to him. He seemed to hate and dread it with a vehemence absolutely laughable, and which, to those who have never witnessed the exhibition of antipathies of this kind, would seem all but incredible.


With these few words of preliminary explanation, I shall proceed to state the particulars of the last scene in this strange series of incidents. It was almost two o'clock one winter's night, and Barton was, as usual at that hour, in his bed; the servant we have mentioned occupied a smaller bed in the same room, and a light was burning. The man was on a sudden aroused by his master, who said:—


‘I can't get it out of my head that that accursed bird has got out somehow, and is lurking in some corner of the room. I have been dreaming about him. Get up, Smith, and look about; search for him. Such hateful dreams!’


The servant rose and examined the chamber, and while engaged in so doing, he heard the well-known sound, more like a long-drawn gasp than a hiss, with



---

p.113




 which these birds from their secret haunts affright the quiet of the night.


This ghostly indication of its proximity—for the sound proceeded from the passage upon which Barton's chamber-door opened—determined the search of the servant, who, opening the door, proceeded a step or two forward for the purpose of driving the bird away. He had, however, hardly entered the lobby, when the door behind him slowly swung to under the impulse, as it seemed, of some gentle current of air; but as immediately over the door there was a kind of window, intended in the day time to aid in lighting the passage, and through which at present the rays of the candle were issuing, the valet could see quite enough for his purpose.


As he advanced he heard his master—who, lying in a well-curtained bed, had not, as it seemed, perceived his exit from the room—call him by name, and direct him to place the candle on the table by his bed. The servant, who was now some way in the long passage, and not liking to raise his voice for the purpose of replying, lest he should startle the sleeping inmates of the house, began to walk hurriedly and softly back again, when, to his amazement, he heard a voice in the interior of the chamber answering calmly, and actually saw, through the window which overtopped the door, that the light was slowly shifting, as if carried across the room in answer to his master's call. Palsied by a feeling akin to terror, yet not unmingled with curiosity, he stood breathless and listening at the threshold, unable to summon resolution to push open the door and enter. Then came a rustling of the curtains, and a sound



---

p.114




 like that of one who in a low voice hushes a child to rest, in the midst of which he heard Barton say, in a tone of stifled horror—‘Oh, God—oh, my God!’ and repeat the same exclamation several times. Then ensued a silence, which again was broken by the same strange soothing sound; and at last there burst forth, in one swelling peal, a yell of agony so appalling and hideous, that, under some impulse of ungovernable horror, the man rushed to the door, and with his whole strength strove to force it open. Whether it was that, in his agitation, he had himself but imperfectly turned the handle, or that the door was really secured upon the inside, he failed to effect an entrance; and as he tugged and pushed, yell after yell rang louder and wilder through the chamber, accompanied all the while by the same hushed sounds. Actually freezing with terror, and scarce knowing what he did, the man turned and ran down the passage, wringing his hands in the extremity of horror and irresolution. At the stair-head he was encountered by General Montague, scared and eager, and just as they met the fearful sounds had ceased.


‘What is it? Who—where is your master?’ said Montague, with the incoherence of extreme agitation. ‘Has anything—for God's sake is anything wrong?’


‘Lord have mercy on us, it's all over,’ said the man, staring wildly towards his master's chamber. ‘He's dead, sir, I'm sure he's dead.’


Without waiting for inquiry or explanation, Montague, closely followed by the servant, hurried to the chamber door, turned the handle, and pushed it open. As the door yielded to his pressure, the ill-omened



---

p.115




 bird of which the servant had been in search, uttering its spectral warning, started suddenly from the far side of the bed, and flying through the doorway close over their heads, and extinguishing, in its passage, the candle which Montague carried, crashed through the skylight that overlooked the lobby and sailed away into the darkness of the outer space.


‘There it is, God bless us,’ whispered the man after a breathless pause.


‘Curse that bird,’ muttered the General, startled by the suddenness of the apparition, and unable to conceal his discomposure.


‘The candle is moved,’ said the man, after another breathless pause, pointing to the candle that still burned in the room; ‘see, they put it by the bed.’


‘Draw the curtains, fellow, and don't stand gaping there,’ whispered Montague, sternly.


The man hesitated.


‘Hold this, then,’ said Montague, impatiently thrusting the candlestick into the servant's hand, and himself advancing to the *bedside*, he drew the curtains apart. The light of the candle, which was still burning at the bedside, fell upon a figure huddled together, and half upright, at the head of the bed. It seemed as though it had slunk back as far as the solid panelling would allow, and the hands were still clutched in the bed-clothes.


‘Barton, Barton, *Barton!*’ cried the General, with a strange mixture of awe and vehemence. He took the candle, and held it so that it shone full upon the face. The features were fixed, stern, and white;



---

p.116




 the jaw was fallen; and the sightless eyes, still open, gazed vacantly forward toward the front of the bed. ‘God Almighty! he's dead,’ muttered the General, as he looked upon this fearful spectacle. They both continued to gaze upon it in silence for a minute or more. ‘And cold, too,’ whispered Montague, withdrawing his hand from that of the dead man.


‘And see, see—may I never have life, sir,’ added the man, after another pause, with a shudder, ‘but there was something else on the bed with him. Look there—look there—see that, sir.’


As the man thus spoke he pointed to a deep indenture, as if caused by a heavy pressure, near the foot of the bed.


Montague was silent.


‘Come, sir, come away, for God's sake,’ whispered the man, drawing close up to him, and holding fast by his arm, while he glanced fearfully round; ‘what good can be done here now—come away, for God's sake!’


At this moment they heard the steps of more than one approaching, and Montague, hastily desiring the servant to arrest their progress, endeavoured to loose the rigid gripe with which the fingers of the dead man were clutched in the bed-clothes, and drew, as well as he was able, the awful figure into a reclining posture; then closing the curtains carefully upon it, he hastened himself to meet those persons that were approaching.


It is needless to follow the personages so slightly connected with this narrative into the events of their *after-life*; it is enough to say, that no clue to the



---

p.117




 solution of these mysterious occurrences was ever after discovered; and so long an interval having now passed since the event which I have just described concluded this strange history, it is scarcely to be expected that time can throw any new lights upon its dark and inexplicable outline. Until the secrets of the earth shall be no longer hidden, therefore, these transactions must remain shrouded in their original obscurity.


The only occurrence in Captain Barton's former life to which reference was ever made, as having any possible *connexion* with the sufferings with which his existence closed, and which he himself seemed to regard as working out a retribution for some grievous sin of his past life, was a circumstance which not for several years after his death was brought to light. The nature of this disclosure was painful to his relatives, and discreditable to his memory.


It appeared that some six years before Captain Barton's final return to Dublin, he had formed, in the town of Plymouth, a guilty attachment, the object of which was the daughter of one of the ship's crew under his command. The father had visited the frailty of his unhappy child with extreme harshness, and even brutality, and it was said that she had died heart-broken. Presuming upon Barton's implication in her guilt, this man had conducted himself toward him with marked insolence; and Barton retaliated this, and what he resented with still more exasperated bitterness—his treatment of the unfortunate girl—by a systematic exercise of those terrible and arbitrary severities which the regulations of the navy placed at



---

p.118




the command of those who are responsible for its discipline. The man had at length made his escape, while the vessel was in port at Naples, but died, as it was said, in an hospital in that town, of the wounds inflicted in one of his recent and sanguinary punishments.


Whether these circumstances in reality bear, or not, upon the occurrences of Barton's after-life, it is, of course, impossible to say. It seems, however, more than probable that they were at least, in his own mind, closely associated with them. But however the truth may be, as to the origin and motives of this mysterious persecution, there can be no doubt that, with respect to the agencies by which it was accomplished, absolute and impenetrable mystery is like to prevail until the day of doom.


### Postscript by the Editor


The preceding narrative is given in the ipsissima verba of the good old clergyman, under whose hand it was delivered to Doctor Hesselius. Notwithstanding the occasional stiffness and redundancy of his sentences, I thought it better to reserve to myself the power of assuring the reader, that in handing to the printer the MS. of a statement so marvellous, the Editor has not altered one letter of the original text—[*Ed. Papers of Dr. Hesselius.*]














