

#The Desmond Survey


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Desmond Survey
==================


Author: unknown
---------------


### File Description

John A. MurphyElectronic edition compiled by Emer Purcell

Additional editing by Emer Purcell

Proof corrections by Emer Purcell

Funded by University College, Cork via the Writers of Ireland Project. 2. Second draft, revised and corrected.Extent of text: 122400 words#### Publication


CELT: Corpus of Electronic Texts: a project of University
College, Cork  
College Road, Cork, Ireland--http://www.ucc.ie/celt

 (2013) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E580000-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

This online edition is based on galley proofs (originally intended for print publication by the Irish Manuscripts Commission) prepared by Professor John A. Murphy. Additional editorial work and preparation of the text for online publication was completed by Emer Purcell. 121 galley proofs were scanned and proofed. Professor Murphy's editorial corrections were then integrated into the text. The footnotes were added and markup and structural analysis were completed. For reference purposes only page numbers were then inserted even though they were not present in the galley proofs. At present, the maps from the Petworth MS, Petworth House Archive, West Sussex Record Office, have been included in this online edition. CELT is grateful Lord Egremont for his kind permission to reproduce these maps.

#### Sources


**Clancarthy Manuscript sources**2. Carew Manuscript 625, Lambeth Palace Library [Manuscript used in this edition. See Introduction for detailed discussion].
3. Petworth Manscript, Petworth House Archive, West Sussex Record Office.
**Peyton and Desmond Survey sources**2. M. 5039. P.R.O.I. (National Archives) Peyton Survey of Co. Limerick.
3. M. 2759. P.R.O.I. (National Archives)Transcript of folios 122-143d of Peyton's Survey made by Tenison Groves.
4. M. 5038. P.R.O.I. (National Archives) Co. Limerick portion of the Desmond Survey of 1856.
5. M. 5037. P.R.O.I. (National Archives) Co. Kerry portion of Desmond Survey. Not included in this edition.
6. Fragment of original Desmond Survey survives in form of two page Latin transcipt. Preserved in the P.R.O.I. (National Archives) Copy also in library of the Royal Society of the Antiquaries of Ireland.
**Clancarthy Survey Primary and secondary sources cited in text**2. S. H. O'Grady (ed.), Pacata Hibernia: or, A history of the wars in Ireland during the reign of Queen Elizabeth, especially within the Province of Munster under the government of Sir George Carew, and compiled by his direction and appointment [II, 335-42.] (London, 1633)
3. Fynes Moryson, An itinerary containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland and Ireland (London, 1617).
4. James Simon, An essay towards an historical account of Irish coins: and of the currency of foregin [sic] monies in Ireland: With an appendix: containing several statutes, proclamations, patents, acts of state, and letters relating to the same (Dublin, 1749).
5. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof (London, 1774).
6. Henry J. Todd (ed), A Catalogue of the Archiepiscopal Manuscripts in the Library of Lambeth Palace (London, 1812).
7. James Hardiman, 'Ancient Irish Deeds and Writings, chiefly relating to Landed Property, from the twelfh to the seventeenth century', Transactions of the Royal Irish Academy 15 (1828) 1-95.
8. John Dymmok, 'A Treaties of Ireland', in: Tracts relating to Ireland, printed for the Irish Archaeological Society Vol. 2 (Dublin, 1843), pp 1-90.
9. John O'Donovan (ed), Leabhar na g-ceart: or, the book of rights, now for the first time edited, with translation and notes (Dublin, 1847).
10. Robert Kane, The industrial resources of Ireland (Dublin, 1844).
11. Journal of the Geological Society of Dublin, 6 (1854) 206-17
12. Annon, 'Ancient Irish Income' in Ulster Journal of Archaeology 4 (1856), pp 241-252.
13. Calendar of the state papers, relating to Ireland: of the reigns of Henry VIII, Edward VI, Mary and Elizabeth, preserved in the State Paper Dept. of Her Majesty's Public Record Office (8 vols London, 1860-1912).
14. Sir John Davies, 'A Discoverie of the State of Ireland' in A collection of Tracts and Treatises illustrative of the natural history, antiquities, and the political and social state of Ireland: at various periods prior to the present century (2 vols, Dublin, 1860) 1, pp 593-714.
15. James Ware's, 'De Hibernia et Antiquitatibus Disquisitiones' in A collection of Tracts and Treatises illustrative of the natural history, antiquities, and the political and social state of Ireland: at various periods prior to the present century (2 vols, Dublin, 1860) 1, pp 149-405.
16. T. D. Hardy & J. S. Brewer (eds), Report to the Right Honourable the Master of the Rolls upon the Carte and Carew papers in the Bodleian and Lambeth Libraries (London 1864).
17. W. Maziere Brady (ed.), The McGillycuddy papers: a selection from the family archives of The McGillycuddy of the Reeks, with an introductory memoir, being a contribution to the history of the County of Kerry (London, 1867).
18. Daniel MacCarthy Glas, The life and letters of Florence MacCarthy Reagh: tanist of Carbery, MacCarthy Mor, with some portion of "The history of the ancient families of the south of Ireland," compiled solely from unpublished documents in Her Majesty's State Paper Office by Daniel MacCarthy (London, 1867).
19. J.S. Brewer & William Bullen (eds), Calendar of the Carew manuscripts: preserved in the Archiepiscopal library at Lambeth ... (6 vols. London 1867-73).
20. Richard Caulfield (ed.), The council book of the Corporation of the city of Cork, from 1609 to 1643, and from 1690 to 1800 (Guildford, Surrey, 1876).
21. General alphabetical index to the townlands and towns, parishes and baronies of Ireland: based on the Census of Ireland for the year 1851. Townland Index (1877 edition).
22. Mary Agnes Hickson, Selections from Old Kerry records: historical and genealogical (London, 1872).
23. Mervyn Archdall, Monasticon hibernicum; or, A history of the abbeys, priories, and other religious houses in Ireland. Edited, with extensive notes, by the Right Rev. Patrick F. Moran. (2 vols, Dublin, 1873-76).
24. Sixth report of the Royal Commission on Historical Manuscripts (London, 1877).
25. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history, (3 vols, London, 1885) 3.
26. Joseph Wright (ed.), The English dialect dictionary (London, 1898-1905).
27. Calendar of the manuscripts of the most Hon. The Marquis of Salisbury (H.M.C. 10 vols) (London, 1899) 8.
28. P. S. Dinneen, Focloir Gaedhilge agus Bearla: an Irish-English dictionary (ITS, Dublin, 1904).
29. C. Litton Falkiner, Illustrations of Irish history and topography, mainly of the seventeenth century (London, 1904).
30. Frederic Seebohm, The Tribal System in Wales (London, 1904).
31. Robert Dunlop, 'Sixteenth Century Maps of Ireland', English Historical Review 20 (1905), 309-337.
32. Nicholas Browne, 'Munster in A.D. 1597', J.C.H.A.S. 12 (1906), 54-68.
33. Dictionary of the Irish language: based mainly on Old and Middle Irish materials/published by the Royal Irish Academy under the editorship of Carl J. S. Marstrander (Dublin, 1913-1976).
34. Samuel Trant MacCarthy, The MacCarthys of Munster: the story of a great Irish sept (Dundalk, 1922).
35. W. F. T. Butler, Gleanings from Irish history (London, 1925).
36. Jeremiah King, County Kerry, past and present: a handbook to the local and family history of the county (Dublin, 1931).
37. Robert C. Simington, The Civil survey, A.D. 1654-1656 (9 vols, Dublin, 1931-1961).
38. Seamus Pender (ed.), A census of Ireland, circa 1659: with supplementary material from the poll money ordinances (1660-1661) (Dublin, 1939).
39. Edward MacLysaght, (ed.), The Kenmare Manuscripts (Dublin, 1942).
40. Pauline Henley, 'Notes on Irish Words in Spenser's Viewe of Ireland, Journal of the Cork Historical and Archaeological Society LVII (1952) pp 121-124.
41. An Seabhac, 'Uí Ráthach. Ainmneacha na mBailte Fearainn sa Bharúntacht', Béaloideas 23 (1954), 3-69.
42. Myles Dillon (ed.), Lebor na cert (ITS 46, London, 1962).
43. John Andrews, Ireland in maps (Dublin, 1961).
44. G. A. Hayes-McCoy, Ulster and other Irish maps, c. 1600 (Dublin, 1964).
45. Irish patent rolls of James I (IMC, Dublin, 1966).
46. R. H. M. Dolley & Gearóid MacNiocaill, 'Some Coin-names in Ceart Ui Neill', Studia Celtica 2 (1967) pp 119-124.
47. R. H. M. Dolley, 'Elizabethan Bungal', British Numismatic Journal 26 (1967).
48. W. J. Smith (ed), Herbert correspondence: the sixteenth and seventeenth century letters of the Herberts of Chirbury, Powis Castle, and Dolguog, formerly at Powis Castle in Montgomeryshire (Cardiff, Dublin, 1968).
49. Eileen McCracken, The Irish woods since Tudor Times: distribution and exploitation (Newtown Abbot, 1971).
**Additional Primary and secondary sources cited in Peyton and Desmond Surveys**2. Edmund Campion, Two histories of Ireland. The one written by Edmund Campion, the other by Meredith Hanmer Dr of Divinity (Dublin, 1633).
3. Charles Smith, The ancient and present state of the county of Kerry, being a natural, civil, ecclesiastical, historical and topographical description thereof (Dublin 1756, repr. 1761; repr. Dublin, 1969).
4. Desiderata curiosa hibernica: or, a select collection of state papers: consisting of royal instructions, directions, dispatches, and letters; to which are added, some historical tracts: the whole illustrating and opening the political systems of the chief governors and government of Ireland, during the reigns of Queen Elizabeth, James the First, and Charles the First, (Dublin, 1772).
5. John O'Donovan (ed. & tr.), Annala Rioghachta Eireann: Annals of the kingdom of Ireland by the Four Masters, from the earliest period to the year 1616. Edited from MSS in the Library of the Royal Irish Academy and of Trinity College Dublin with a translation and copious notes (7 vols, Dublin 1848–51) 3.
6. W. H. Hardinge, 'On Manuscript Mapped Townland Surveys in Ireland', Proc. R.I.A., 8 (1860).
7. Alexander B. Grosart (ed.), The complete works in verse and prose of Edmund Spenser. (London [Private Circulation], 1882).
8. Patrick Power, The place-names of Decies, (London, 1907).
9. W.M. Hennessy, 'Desmond Inquisition of 1584', Kerry Archaeological Magazine, 4 (April 1910), pp. 213-26, and 5 (October 1910), pp. 263-79.
10. The complete peerage of England, Scotland, Ireland, Great Britain and the United Kingdom: extant, extinct, or dormant. By G.E.C; New edition revised and much enlarged, edited by the Hon. Vicary Gibbs (London, 1910-98).
11. Herbert Wood, A guide to the records deposited in the Public Record Office of Ireland, (Dublin, 1919).
12. Sir Henry Lyttleton Lyster Denny, A handbook of county Kerry family history, compiled for the archaeological group of the County Kerry Society (London, 1923).
13. Paul J. O'Flynn, The book of the Galtees and the Golden Vein: a border history of Tipperary, Limerick and Cork, (Dublin, 1926).
14. John Begley, The diocese of Limerick in the sixteenth and seventeenth centuries, (Dublin, 1927).
15. An Seabhac, Triocha-céad Chorca Dhuibhne: i tiomargadh ar a log-ainmneacha agus ar sheanchas a ghabhann leo san mar aon le sloinnte agus ainannencha daoine/ an Seabhac, [pseud.], [Pádraig O'Siochfhradha]. (Baile Átha Cliath: Ar n-a fhoillsiú ag Comhlucht Oideachais na h-Éireann do An Cumann le Béaloideas Éireann, 1938-1939).
16. N.B. White, (ed.), Extents of Irish monastic possessions, 1540-1541: from manuscripts in the Public record office, London, (Dublin, 1943).
17. Theobald Stapleton, The "Catechismus" of Theobald Stapleton. Reproduced at the Ordnance Survey, (Dublin. 1945).
18. James Hogan & N. McN. O'Farrell, (eds), The Walsingham letter-book, or, Register of Ireland, May 1578 to December 1579, (Dublin, 1959).
19. D.A. Binchy, 'The old name of Charleville, Co. Cork', Éigse 10, (1962-63) 211-235.
20. R.J. Hayes, (ed.), Manuscript Sources for the History of Irish Civilization, (Boston, 1965).
21. Liam Ó Buachalla, 'An early fourteenth-century placename list for Anglo-Norman Cork', Dinnseanchas 2.1 (1966) 1-50.
22. Maps and Plans in the Public Record Office, I (British Isles, c. 1410-1860), (London, 1967).
23. William Petty, Hiberniae delineatio [cartographic material]: atlas of Ireland (Newcastle upon Tyne, 1968).
24. Aubrey Gwynn & R. Neville Hadcock (eds), Medieval religious houses: Ireland, (Harlow, 1970).
**General Reading list**2. H.F. Hore & J. Graves (eds), The social state of the southern and eastern counties of Ireland in the 16th century (Dublin, 1870).
3. R. Dunlop, 'The plantation of Munster, 1584-89', English Historical Review, 3 (1888).
4. P. O'Sullivan Beare, Ireland under Elizabeth, ed. M. Byrne (London, 1903).
5. G. O'Brien, The economic history of Ireland in the 17th century (Dublin, 1919).
6. D. B. Quinn, 'A discourse of Ireland (c. 1599): a sidelight on English colonial policy', Proceedings of the Royal Irish Academy, 47 C (1942).
7. D. B. Quinn, 'Ireland and 16th century European expansion', Historical Studies, 1 (1958).
8. D. B. Quinn, 'The Munster Plantation: problems and opportunities', J Cork Hist Archaeol Soc, 71 (1966).
9. J. H. Andrews, 'Geography and government in Elizabethan Ireland', in N. Stephens & R. Glasscock (eds), Irish Geographical Studies (Belfast, 1970).
10. K. Nicholls, Gaelic and Gaelicised Ireland (London, 1972).
11. K. Nicholls, Land, Law and Society in sixteenth-century Ireland (O'Donnell Lecture, 1976).
12. N. P. Canny, The Elizabethan conquest of Ireland (Hassocks, 1976).
13. N. P. Canny, 'The permissive frontier: social control in English settlements in Ireland and Virginia, 1550-1650', in K. R. Andrews et al (eds), The Westward enterprise (Liverpool, 1978).
14. A. J. Sheehan, 'The population of the Plantation of Munster: Quinn reconsidered', J Cork Hist Archaeol Soc, 87 (1982).
15. A. J. Sheehan, 'Official reaction to native land claims in the plantation of Munster', Irish Historical Studies, 92 (1983).
16. Henry A. Jefferies, 'Desmond: the early years & the career of Cormac Mac Carthy', J Cork Hist Archaeol Soc, 88 (1983) 81-99.
17. Henry A. Jefferies, 'Desmond before the Norman invasion: a political study', J Cork Hist Archaeol Soc, 89 (1984) 12-32.
18. Michael MacCarthy-Morrogh, The Munster Plantation: English migration to southern Ireland, 1583-1641 (Oxford, 1986).
19. Brian C. Donovan & David Edwards (eds) British sources for Irish history, 1485-1641: a guide to manuscripts in local, regional and specialised repositories in England, Scotland and Wales (IMC, Dublin, 1997).
20. Hiram Morgan, Political ideology in Ireland, 1541-1641 (Dublin, 1999).
21. Paul MacCotter, 'The cantreds of Desmond', J Cork Hist Archaeol Soc, 105 (2000) 49-68.
22. Patrick J. Duffy, David Edwards, & Elizabeth FitzPatrick (eds), Gaelic Ireland, c.1250-c.1650: land, lordship, and settlement (Dublin, 2001).
23. David Edwards, (eds), Regions and rulers in Ireland, 1100-1650: Essays for Kenneth Nicholls (Dublin, 2004).
24. Anthony M. McCormack, 'The social and economic consequences of the Desmond rebellion of 1579-83' Irish Historical Studies, 133 (2004) 1-15.
25. Anthony M. McCormack, The Earldom of Desmond, 1463-1583: the decline and crisis of a feudal lordship (Dublin, 2005).
26. David Edwards, Pádraig Lenihan & Clodagh Tait, (eds), Age of atrocity: violence and political conflict in early modern Ireland (Dublin, 2007).
27. Paul MacCotter, Medieval Ireland: territorial, political and economic divisions (Dublin, 2008).
**The edition used in the digital edition**2. The Desmond Survey. John A. Murphy (ed), Unpublished ()

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


Online edition is based on galley proofs of text prepared by John A. Murphy.


#### Editorial Declaration


##### Correction


Text has been checked and proofread twice.


##### Normalization


The electronic text is based on the galley proofs. Editorial corrections to the galley proofs by John A. Murphy have been integrated into the text.


##### Hyphenation


When a hyphenated word (hard or soft) crosses a line break, the break is marked after the completion of the hyphenated word. There are no instances of hyphenated words crossing a page break.


##### Interpretation


Names of persons (given names), places and group names are not tagged. Index of Personal and Place-names and Subject Index to the Clancarthy Survey have been included.


#### Canonical References


This text uses the DIV1 element to represent the Section. ### Profile Description


Created: By one or more unknown authors. Date range: 1580-1600.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Some words are in Irish.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] Some words are in French.


##### Language: [ON] One term is Old Norse.


### Revision History


* (2013-07-17) Beatrix Färber (ed.)

* Suggestion made by Brian Hodkinson added to footnote 738.
* (2013-01-21) Beatrix Färber (ed.)

* Error in paragraph numbering reported by Brian Hodkinson corrected.
* (2012-05-14) Beatrix Färber (ed.)

* More typos reported by Janet Crawford corrected.
* (2012-03-14) Beatrix Färber (ed.)

* More typos reported by Janet Crawford corrected.
* (2012-02-16) Beatrix Färber (ed.)

* Typos on p. 35, 359 and 397 corrected, as reported by Janet Crawford.
* (2009-06-12) Emer Purcell (ed.)

* Additions to bibliography and minor changes to header.
* (2009-04-30) Beatrix Färber (ed.)

* Maps integrated; final SGML and HTML versions created.
* (2009-04-29) Emer Purcell (ed.)

* Note statement added to header and page breaks inserted.
* (2009-04-24) Beatrix Färber (ed.)

* File parsed; minor changes to header and file made; new SGML and HTML versions created.
* (2009-04-22) Emer Purcell (ed.)

* Minor changes to markup.
* (2009-04-15) Emer Purcell (ed.)

* Additional markup, manuscript sources and bibliographical material added.
* (2009-04-08) Emer Purcell (ed.)

* Additional markup added.
* (2008-04-06) Beatrix Färber (ed.)

* File parsed. File structure modified. SGML and HTML file created.
* (2008-04-06) Beatrix Färber (ed.)

* Peyton and Desmond Survey added to Clancarthy Survey.
* (2009-04-02) Emer Purcell (ed.)

* Header created for Peyton and Desmond Survey.
* (2009-04-02) Emer Purcell (ed.)

* Minor changes to structural markup and apparatus.
* (2009-03-30) Emer Purcell (ed.)

* Structural markup and apparatus added.
* (2009-02-01) Emer Purcell (ed.)

* File proofed (1); editorial corrections integrated.
* (2009-01-15) Emer Purcell (ed.)

* File proofed (1).
* (2008-11-01) Emer Purcell (text capture)

* Peyton and Desmond Survey captured by scanning.
* (2008-11-19) Beatrix Färber (ed.)

* File parsed. File structure modified. SGML and HTML file created.
* (2008-11-05) Emer Purcell (ed.)

* Header created.
* (2008-10-15) Emer Purcell (ed.)

* Minor changes to structural markup and apparatus.
* (2008-07-15) Emer Purcell (ed.)

* Structural markup and apparatus added.
* (2008-04-01) Emer Purcell (ed.)

* File proofed (1); editorial corrections integrated.
* (2008-02-15) Emer Purcell (ed.)

* File proofed (1).
* (2008-01-05) Emer Purcell (text capture)

* File captured by scanning.




---


#### Corpus of Electronic Texts Edition: E580000-001


### The Desmond Survey: Author: unknown




---

p.1





|  |  |
| --- | --- |
| bar. | barony |
| B.M. (now B.L.) | British Museum (now British Library) |
| B.S.D. | Books of Survey and Distribution |
| Cal. Carew MSS | Calendar of the Carew Manuscripts Preserved in the Archiepiscopal Library at Lambeth |
| Cal.Pat.Rolls | Calendar of Patent Rolls |
| Cal.S.P.Ire. | Calendar of the State Papers relating to Ireland |
| E.D.D. | English Dialect Dictionary |
| H.M.C. | Historical Manuscripts Commission |
| J.C.H.A.S. | Journal of the Cork Historical and Archaeological Society |
| mod. | modern |
| O.E.D. | Oxford English Dictionary |
| par. | parish |
| P.R.I. Rep. D.K.I [etc.] | First [etc.] Report of the Deputy Keeper of the Public Records in Ireland |
| R.I.A. | Royal Irish Academy |
| td. | townland |
| U.J.A. | Ulster Journal of Archaeology |






The term ‘Desmond’ Surveys has been commonly used to describe two quite distinct sixteenth-century surveys. This loose designation, originating in different senses of the word ‘Desmond’, has resulted 
in some confusion. In fact, the two sets of surveys arose from separate historical circumstances, were made at different times and concern different though adjacent territories. The surveys which are known as the Desmond and Peyton Surveys were undertaken by commissioners appointed in 1584 to inquire into the lands 
forfeited as a result of the Desmond rebellion. In 1598 a survey of the lands in the *country* of Desmond [1](javascript:footNote('E580000-001/note001.html')) was undertaken as a stage in dealing with the situation arising from the death in l596, without 
male issue, of Domhnall MacCarthy Mór, first earl of Clancarthy. For the sake of clarity it is proposed to refer hereinafter to this latter survey as the Clancarthy Survey, retaining the description 
‘Desmond’ for the earlier surveys of the lands of the earl of Desmond.


Introduction to the Clancarthy Survey
-------------------------------------


The text edited below is that of portion of Carew Manuscript 625, preserved among the Carew collection at Lambeth Palace Library. The various collections of manuscripts at Lambeth 
have long been known by distinctive names, and Codices Manuscripti 
Carewani, nos. 596-638 of the Lambeth 



---

p.2




volumes, comprise the collections (relating mainly to Irish affairs)[2](javascript:footNote('E580000-001/note002.html')) of Sir George Carew, 
president of Munster (1600-03) under Elizabeth I, who died earl of Totnes in 1629. Carew had antiquarian tastes and had a deep interest in Irish history. Like so many public officials of the sixteenth and seventeenth centuries, he made a large collection of documents and it is probable that he intended to write a history of Ireland or at least an account of the wars in Munster. However, it was Sir Thomas Stafford, to whom Carew bequeathed the collection, who carried out that project in his Pacata Hibernia.[3](javascript:footNote('E580000-001/note003.html'))


How most of the Carew collection came to be preserved at Lambeth has been a much discussed subject[4](javascript:footNote('E580000-001/note004.html')). but hardly concerns us directly here. Manuscript 625, which has been inspected by the 
editor at Lambeth, is a well preserved folio volume measuring 8" by 12" by 1½". It has a modern binding of leather and is stamped with the letter Q and the Carew shield of arms. Carew himself, it appears, had devised a curious numeration of his volumes in three alphabets (A, AA, AAA, B, BB, BBB, etc., the letters I and U not being used). Thus, of Carew's total collection (manuscript and printed) of seventy-two volumes, most of which are at Lambeth, the forty-sixth item was designated Q in his original enumeration, and
later became Volume 625 in the Lambeth Palace Library Volume Z in Carew's numbering (now Lambeth volume 636) comprises an index to volumes A-X.[5](javascript:footNote('E580000-001/note005.html'))


In his catalogue of the Lambeth manuscripts, M. R. James remarks that the Carew manuscripts were fully calendared as State Papers and consequently did not need to be described by him.[6](javascript:footNote('E580000-001/note006.html')) 
In fact, as Butler points out,[7](javascript:footNote('E580000-001/note007.html')) the Clancarthy Survey in manuscript 625 finds no mention in the Calendar of the Carew Mansucripts. This is all the more curious in view of the awareness shown by the calendar's editors[8](javascript:footNote('E580000-001/note008.html')) of the great interest of the Carew material to Irish historians and antiquarians, a number of whom, from the mid-nineteenth century onwards, consulted the survey at Lambeth. Thus, it is referred to by an anonymous writer on ‘Ancient Irish Income’ in the Ulster Journal of Archaeology for 1856.[9](javascript:footNote('E580000-001/note009.html')) W. M. Brady in his edition of the McGillycuddy Papers (London 1867) published a greatly garbled paragraph or so from the manuscript.[10](javascript:footNote('E580000-001/note010.html')) In the same year Daniel MacCarthy Glas published his Life and Letters of Florence MacCarthy Reagh, an important but badly arranged book, at once reflecting enormous industry and singular lack of skill in a combination characteristic of Irish research historians of the period. The author described the information provided in the survey as ‘most curious as remains of a civilisation dating before the period of acknowledged history’. It is clear that MacCarthy appreciated the interest and value of the survey but considered it ‘far too voluminous’ to reproduce.[11](javascript:footNote('E580000-001/note011.html')) A similar 
reference to the ‘great length’ of the survey is made by Mary A. Hickson in her Old Kerry Records. Miss Hickson (who evinced particular interest in the maps accompanying the survey) gives what purport to be direct quotations from the manuscript but what are in fact her own free adaptations.[12](javascript:footNote('E580000-001/note012.html')) A later writer on 
MacCarthy family history, Judge S. Trant MacCarthy, also consulted the survey and made knowledgeable comments on some of the place-names.[13](javascript:footNote('E580000-001/note013.html')) But it was William F. T. Butler who first drew attention to the great historical significance of the survey (‘of its value, as well as that of the maps which accompany it, it is almost impossible to speak too highly’) and who expressed surprise that it had never been published or even calendared.[14](javascript:footNote('E580000-001/note014.html')) Butler's extended commentary on the survey is important, though he had difficulty in reading the manuscript and gave some defective renderings of place-names.[15](javascript:footNote('E580000-001/note015.html')) But he rightly emphasized the value of a document which throws an important light on the political and social structure of a great native chieftainship, part of the Gaelic polity going down before the Tudor attack. Professor Myles Dillon has remarked of the survey that, as an account of the rents and privileges enjoyed by the Lord of Desmond at the end of the sixteenth century, ‘it is later by four hundred years than the Book of Rights but it is apparently an exact record and of great value as such.’[16](javascript:footNote('E580000-001/note016.html')) There are other reasons why the survey should be published. It describes the location and extent of the lands of the chief families in south Kerry and south-west Cork. It contains material of importance for the study of place-names and its interest is further enhanced by the details furnished on fisheries, mines and forests. There is also information on contemporary prices of livestock and foodstuffs, on contemporary currency and coinage and on traditional units of weights, measures and land areas.




---

p.3


### *Historical Background*


The historical background to the survey may be noted briefly here.[17](javascript:footNote('E580000-001/note017.html')) In 1565, as a check against Desmond Geraldine's power, Domhnall MacCarthy Mór, lord of Desmond, was created earl of ‘Clancar’ or Clancarthy. Though he participated briefly in the first Geraldine revolt in 1569, sharing the general sense of land insecurity, his subsequent role was generally that of a spectator while the Geraldines, his neighbours and traditional enemies, were being overthrown.[18](javascript:footNote('E580000-001/note018.html')) Yet the suppression of the Desmond rebellion brought the undertakers to his doorstep and these Elizabethan adventurers soon realized that their own security demanded a satisfactory land settlement in the adjoining Gaelic lordship.


Domhnall's son and heir, the baron of Valentia, died in 1585,[19](javascript:footNote('E580000-001/note019.html')) he had no close male legitimate relatives, so that the future of the MacCarthy demesne lands was now bound up with the person of his daughter Ellen, his only surviving legitimate child. The authorities in Munster were naturally concerned that Ellen should make a fitting match. The ambitious Sir Valentine Browne, who secured a mortgage on some of the MacCarthy demesne lands by lending money to the unthrifty earl, [20](javascript:footNote('E580000-001/note020.html')) negotiated with Domhnall for a marriage between Ellen and his son, Nicholas Browne. The projected alliance with an upstart planter family was strenuously 
opposed by the countess of Clancarthy as well as by the leaders of the septs. They expressed their opposition to Sir William Herbert who suggested to Sir Thomas Norreys, vice-president of Munster, that he should consider offering for Ellen's hand, Herbert promising to use his influence to secure not only the queen's consent, but also a grant-of succession for Norreys to the earl's lands. But Norreys, ‘after some paines taken, he in the ende mysliked of it, being as it seemed, otherwise disposed to bestowe himself.’[21](javascript:footNote('E580000-001/note021.html')) Events now took a surprising turn and one which greatly disconcerted the English authorities. In May 1588 Ellen suddenly and secretly married the redoubtable Finín (Florence) MacCarthy Riabhach, tanist of 
Carbery, ‘the most dangerous man of all the Irish nation’.[22](javascript:footNote('E580000-001/note022.html')) Like the Brownes, Florence had also secured a mortgage on some of the earl's demesnes. Herbert urged that steps be taken to counter ‘Florence McCarte's dryft, to joyne in himsealfe Desmond and Carberie, and so to erect againe the greatnes and tyranny of the McCarties’. The problem was complicated by the emergence of a party within the MacCarthy territory which opposed at once Florence's ambitions and the extension of the English interest. The principal members of this group were Sir Owen O'Sullivan of Beara and the able Domhnall MacCarthy, the earl's bastard son, ‘whom that countrey doth much favor and would fayne have to be MeCartie’.[23](javascript:footNote('E580000-001/note023.html'))


The neighbouring undertakers may have had their bitter disagreements such as that which arose between Sir William Herbert on the one hand and the Brownes, the Springs and the Dennys on the other, [24](javascript:footNote('E580000-001/note024.html')) but all had their designs on the MacCarthy lands and they made the usual convenient planters' identification between their own ambitions and the interests of the Crown. Sir William Herbert who desired to have 6,000 akers in the countye of Desmonde after the Earl of Glincarr's death[25](javascript:footNote('E580000-001/note025.html')) made a report to Burghley on the position in Desmond and recommended that ‘it is of great consequence and importance unto our inhabitation here that the Earl's estate be not enlarged, to the end that after his decease English gentlemen may be there planted   
[*...*]  
’[26](javascript:footNote('E580000-001/note026.html')) This advice accorded with the fundamental principle of Elizabethan policy as expressed by Sir Henry Sidney: ‘the dissipation of the great lordships: to distribute the lands, if among English, the better: if not, yet that they be dissipated’.[27](javascript:footNote('E580000-001/note027.html'))


The conflicting claims to, and interests in, the MacCarthy lands were brought to the forefront by the death of the earl towards the end of 1596. The planters urged that Florence's claims to ‘the landes 



---

p.4




and honor’ be rejected and that the country ‘be divided amongst gentlemen of good sort and condition’.[28](javascript:footNote('E580000-001/note028.html')) But the critical political situation brought about by the Tyrone rebellion precluded such a simple and brutal solution by the crown.[29](javascript:footNote('E580000-001/note029.html')) Nicholas Browne, whose particular concern was to enforce his title to the lands mortgaged to his father, submitted a memorandum to the lord treasurer in 1597 on the situation in Munster, with particular reference to the position in Desmond.[30](javascript:footNote('E580000-001/note030.html')) This included a list of the various septs in the lordship with a comment on their traditional loyalties or otherwise ‘to the howse of McCartie’. This general analysis is similar to the overall arrangement of the survey and there are also resemblances of phraseology, so that Browne may 
have been the author of, or at least a principal source of information for the survey, possibly helping with the final draft.[31](javascript:footNote('E580000-001/note031.html'))


### *Purpose of the Survey*


On 1 July 1597 the survey was ordered to be made. The English Privy Council directed that the commissioners of survey (these included the president of Munster) should proceed along certain lines of inquiry. They were to report on the extent and value of the earl's demesne lands; the various tributes traditionally due to him; the castles, islands and havens in his possession which might be kept by the crown; the extent of the mortgaged lands; the lands claimed by the dowager countess and the lands which might be given at a rent to the bastard Domhnall. Finally the survey was to list the English planters who were already in Desmond together with the rents and services they paid to the crown. The Irish council was to ‘add such other articles as may seem good to them whereby the country may be distributed to English people’.[32](javascript:footNote('E580000-001/note032.html')) The survey, 
then, was carried out with an eventual eye to partial plantation. A comparison of the above instructions with the text of the survey will show that the terms of reference were fairly closely observed.


### *Date*


There is no date on the survey itself but it is possible to assign a date to it within certain limits. As we have seen, it was commissioned in July 1597. From a letter of Sir Roger Wilbraham, solicitor-general, to Sir Robert Cecil on 25 May 1598, commenting on the claims of Domhnall MacCarthy, it would appear that Wilbraham had been studying the survey for some time.[33](javascript:footNote('E580000-001/note033.html')) However this may have been only a draft or a portion of the report, for a royal warrant of 13 August 1598 mentions that ‘the said survey may not (as is doubted) be speedily effected’.[34](javascript:footNote('E580000-001/note034.html')) On 16 March 1599 the lord lieutenant and council gave their decision on the claims of Florence MacCarthy and Nicholas Browne. It is clear from this and from a petition by Florence of the same date that the survey had been completed well before that.[35](javascript:footNote('E580000-001/note035.html')) On the whole, it is reasonable to conclude that the material for the survey was gathered between the autumn of 1597 and the spring of 1598 (it has no hint of the turbulence in Munster in the latter part of 1598) but that it was not given formal shape until late in 1598. It may be said here that the survey did not in itself provide a solution to the various problems concerning the succession to the earl's demesnes, and there were protracted legal disputes for well over a generation afterwards.[36](javascript:footNote('E580000-001/note036.html'))


### *Description of Manuscript*


In his catalogue of the Lambeth Palace manuscripts, Todd[37](javascript:footNote('E580000-001/note037.html')) lists 
the contents of volume 625. The list is based on the table of contents which prefaces the volume itself and which is headed ‘The Principall 
Matters Contayned in this Booke.’ Above this heading, at the top right-hand corner of the folio, is the unmistakable signature 
*Gr Carew* over the date 1617, presumably the year in which the volume was compiled from disparate material. It comprises a 
copy of a letter from Elizabeth ‘concerninge sterlinge pay’ (1582); an account of wages due to the lord deputy and the army (1587-88); 
the survey; a discussion of James I's claims to Longford, Leitrim and other areas, as well as a project for their plantation; 
and finally, ‘a booke of the armes of certain sundrie noblemen and gentlemen of Irland   
[*...*]  
’




---

p.5


The volume has a confusing double foliation (recto only) throughout. A top right-hand foliation begins with the introductory table of contents and continues in sequence, blank folios being numbered. The bottom left-hand foliation begins with the first item in the volume, which is on folio 1 verso (bottom left hand) or folio 7 verso (top right hand). It is proposed to use the bottom left-hand foliation for reference. It is the foliation to which the contents table refers and the figures appear to be more contemporary with the script of the text than those of the top right-hand corners.


The Clancarthy Survey, published here for the first time, extends from folio 19 verso to folio 39 recto inclusive. A prefatory note (folio 19 verso) is followed by a general map in colour of Kerry and Desmond (folio 20 recto). Then comes (folio 21 recto and verso) a detailed list of the earl's demesnes (including those in his 
possession at his death as well as those mortgaged or disposed to others) and of his various fishings with their present distribution.[38](javascript:footNote('E580000-001/note038.html')) Next, there is a note on lands claimed by the earl (folio 22 recto) and the definition of various terms relating to traditional rents and services (folio 22 recto and verso). After a coloured map of Glanerought barony comes the main body of the survey, consisting of the detailed returns of the rents and services traditionally payable by the various septs in Desmond to the earl of Clancarthy, as well as some general observations on the lands surveyed. The septs are grouped under three main headings: the septs friendly to MacCarthy Mór (folios 25 recto to 28 recto), those traditionally hostile to him (folios 28 verso to 34 verso) and the O'Sullivan septs, usually aligned against him (folios 34 verso to 38 verso). In the case of each sept, its lands are named in successive paragraphs, the money value of the services and dues relating to specific lands is stated, and an annual total sum given for all the lands. Four other coloured maps are folded in at appropriate points. After the main body of the survey comes (38 verso and 39 recto) a description of rents due from various church lands to the earl as well as a note on a tribute from the lords of Duhallow. The survey is completed (folio 39 verso) by a grand total of the money value of all the rents and services.


### *Printed Text*


The lay-out of the manuscript has been modified in the printed text. In the manuscript, extensive use is made of margins to show different divisions of the subject matter. Thus an outer left-hand margin is used to indicate each of the three main groups referred to above, the heading being placed outside the margin at an appropriate point. Sub-headings along inner left-hand margins denote the different septs within each main group. Each group of lands within a sept has a right-hand bracketing outside which is placed the money value of the rents and services for that particular group of lands. Since such an arrangement would be inconvenient to reproduce, the ‘vertical’ marginal headings of the manuscript have been replaced by ordinary ‘horizontal’ headings in the printed text. Similarly the money totals outside the right-hand bracketings of the manuscript are simply placed in a separate line in the printed text. The original paragraphing has, of course, been retained. The editor has italicised headings for the sake of clarity.


With the exceptions subsequently mentioned, the printed text is a faithful reproduction of the manuscript. Contractions whose meaning is certain have been silently extended. Thus *wth, wch* are printed as *with*, *which*, respectively; *pl*, *plo*, *pt*, *pcells*, *porcon* become *ploughland* (or *plowland* ), *part*, *parcells*, *portion* . Fortunately there are few doubtful contractions in the manuscript: indeed, though there were occasional reading difficulties, the manuscript was found 
to have very little undecipherable matter. Abbreviations which would find approval in modern usage have been retained— *str*, *viz.*, *li.s.d.*, for example. There is very little punctuation in the manuscript and it has been thought safer to follow suit in this regard, except where modern usage would require the insertion of full stops after abbreviations, as in *wh. gr.* (white groats). In money totals, the figure 1 occurring 



---

p.6




in the manuscript has been replaced by the small roman numeral i (i *d*, i white groat). The spelling of the original (for example, initial *v* and internal *u* ) has been retained, as well as the usage of capitals and lower case. It should be noted, however, that the manuscript uses a special, large clear script for proper names (as well as a rather ornate script for the headings) and that this has not been reproduced in the printed text. Where scribal errors are corrected in the text, they are mentioned in the footnotes which also draw attention to any other peculiarities in the manuscript, square brackets enclosing letters or words indicate obvious omissions by the scribe. Finally, reference in introduction, notes and indices to different parts of the text is to sections numbered by the editor in order to facilitate indexing.


### *The Petworth Manuscript*


In the sixth Reportof the Historical Manuscripts Commission (1877), p. 309a, there is mentioned as item 89 of the manuscripts of Lord Leconfield, Petworth House, Sussex: ‘Folio 16th century: A general survey of all such lands as are conteyned within the county of Desmond as well of such as wear the Earl of Clancarty's own demesnes as of all other lands belonging to the lords and others the freeholders of the said country (22 pp. + 4 maps done by hand).’ On investigation, this manuscript was discovered to be another copy of the Clancarthy Survey. It is still preserved at Petworth House, Sussex. Written on paper and bound in vellum it is in good condition. Unfortunately, nothing has been discovered about its history. The Petworth manuscript (referred to subsequently as 'Petworth") may possibly have been copied from Carew Manuscript 625, but a comparison of the two texts suggests that both Carew and Petworth were independently copied from another manuscript. Erroneous forms of some place-names in Carew[39](javascript:footNote('E580000-001/note039.html')) But the Petworth spelling seems to be slightly more modern (e.g., internal *v* for *u*, general dropping of superfluous final *e* ) as does the letter formation (the modern form of *w* ). The hand, which seems to be later than Carew, is very regular, and this impression of ‘ruled’ regularity is strengthened by the orderly lines of writing and the straightness of the side brackets. Petworth is also somewhat better punctuated and is a much cleaner copy, with no erasures at all. It may be of interest to set down here, side by side, the opening paragraph from the two manuscripts:


Carew MS 625
  
 
A General Suruay of all such
  

landes as are conteyned wthin
  

the Country of Desmond as wel
  

of such as were the Earle of
  

Clancarties owne demeanes as
  

of all other landes belonging
  

to the Lords and others the
  

freholders of the said Country
  
 
w'th what dewties rentes and
  
 
Chiefryes are customablye to be
  

payd to the said earle out of the
  

same, taken vpon the recport
  

[sic] of the Sergeantes and officers
  

of the of the saide Contrye
  



Pentworth 89
  

A generall survey of all such
  

lands as ar conteyned within the
  

Country of Desmound as well of
  

such as wear the Earl of Clancartyes
  
 
owne Demeanes as of
  

all other lands belonging to
  



---

p.7




the Lords and others the freholders
  

of the said Country,
  

wth what Dutyes rentes and
  

Cheifryes are coustomably to be
  

paid to the said Earl out of the
  
 
same, taken vpon the report of
  

the sariauntes and officers of the
  

said Country.
  



Petworth is spaced more generously and its material per folio is only about three-quarters that of Carew. Whereas paragraphs in Carew are concluded at the end of folios, Petworth occasionally runs on in mid-sentence to the top of the next folio.


It is difficult to refer to particular pages of the Petworth manuscript since it is not foliated at all and there are some blank pages. An introductory page (verso only) is followed by eleven folios, recto and verso, i.e., twenty-three[40](javascript:footNote('E580000-001/note040.html')) pages of manuscript in all, with one or two blank pages interspersed. Unfortunately some three folios of material[41](javascript:footNote('E580000-001/note041.html')) are missing from the manuscript. Since the sequence of maps is the same as in Carew (the first four in each case being those of Kerry, Glanerought, Dariry and Magunihy) it is 



---

p.8




clear that the missing Petworth section included the maps of Dunkerron and Iveragh baronies. The lacuna was probably there when the manuscript was being bound as there are no indications that the missing folios and maps were subsequently extracted.


### *The Maps in Carew Manuscript 625*


The maps are bound in at different places in the survey which they are intended to supplement as well as to illustrate. Since the complex assessment of the various rents and services was on different portions of lands, not on people, it was of importance for the purposes of the survey to show the location of the lands and the geographical distribution of the various septs.[42](javascript:footNote('E580000-001/note042.html')) All the six maps in Carew Manuscript 625 would appear to be in the same hand (which seems to be identical with that of the manuscript) although occasionally a later hand has added more names, e.g., in the general map of Kerry, the later form ‘Valentia’ (corruption of Bél Inse) has been written under the original ‘Dariry’.[43](javascript:footNote('E580000-001/note043.html')) We may take it that the surveying for the maps was carried out at the time the information for the report was being collected. Though the map-maker may well have got help from earlier maps, these maps reproduced below were obviously made specially for the survey.


The late sixteenth century is a period of exceptional interest in the history of cartography.[44](javascript:footNote('E580000-001/note044.html')) More advanced techniques were being used, even though the kind of competence typified by Petty was still a long way off. The maps in the survey exhibit that combination of picture, survey and map characteristic of the period. In general it may be said that, considering the remoteness and difficulty of the area surveyed, these maps are extremely good. Our cartographer may not have had Bartlett's expertise or sophistication, but he gives us much more information about late sixteenth-century Kerry than Bartlett does about Ulster in the same period.[45](javascript:footNote('E580000-001/note045.html')) We cannot be sure what surveying methods and implements were used: possibly a compass, perhaps only a system of simple triangulation. The latter was practised since the early part of the sixteenth century but it is very doubtful whether our cartographer used the plane table which came into general use only about 1590. But accurate visual observation compensated in large measure for the lack of technical knowledge and equipment.


The general map of Kerry and Desmond[46](javascript:footNote('E580000-001/note046.html')) was intended as background reference for the five barony maps, the purpose of which, as has been said above, was to illustrate the place-names in the text and to show the extent of the different lands of the free-holders, distinguished by letters or numbers as well as by the use of different colours.[47](javascript:footNote('E580000-001/note047.html')) After nearly four centuries, the colours (varying shades of yellow, green and red) are still remarkably vivid and the lettering surprisingly clear.[48](javascript:footNote('E580000-001/note048.html')) Churches, abbeys and castles are represented by stylized drawings. Particularly important churches and abbeys are given a special symbol—e.g., Kilmore in the Dariry map (this map is of special interest, with its large scale, it clear pictorial symbols and its particularly fresh colouring). Castles like Dunkerron and Castleisland are shown as ringed around by a rectangular or circular fort. Unroofed buildings probably indicate a derelict state at the time of mapping. Wooded areas are represented pictorially while mountains are shown in pictorial elevation or perspective, a series of inverted *V* s which are intended to convey the impression of height. As Kerry is exceptionally mountainous, these curved lines are everywhere.


We have referred to the keen eye of the cartographer. The Skelligs are drawn impressionistically, just as they appear to a mainland observer—towering rocks jutting out of the sea, though shown perhaps too near the coast. The Kerry coastline is drawn with reasonable accuracy but the location of islands is sometimes erroneous (e.g. in Ballinskelligs bay). The island of Valentia is badly orientated in the four maps in which it is shown, and the drawing of the baronies is frequently rough-and-ready. Barony boundaries, however, were not well defined at the time.[49](javascript:footNote('E580000-001/note049.html'))


Some other features of the maps call for a brief comment. The conventional compass directions (top of map to north, etc.) are not observed, and the elaborate compass roses found in other maps of the same period are lacking.[50](javascript:footNote('E580000-001/note050.html')) Indeed, artistic embellishment in general is at a minimum. With the exception of the general map of Kerry and Desmond, each of the maps is circular in shape and this must be regarded as a survival of the archaic method of drawing the world, and portions thereof, in a circular frame. It should also be noted that the original maps are of varying size, the Dariry map being drawn within a comparatively small circle and the Dunkerron map being by far the largest. None of the mans attempts to show a scale and there are no initials or signatures to indicate authorship.


### *Petworth Maps*


The four surviving maps (Kerry and Desmond; Glanerought; Magunihy, and Dariry) in the Petworth manuscript closely resemble their counterparts in Carew Manuscript 625. The Petworth maps are also coloured. They lack, however, the additions in a later hand which are so obvious in the Carew maps and to which reference has already been made. It is of interest that when Dunlop was making his catalogue of sixteenth-century maps he noted the reference in the sixth Report of the Historical Manuscripts Commission to the Petworth maps.[51](javascript:footNote('E580000-001/note051.html')) However, it is clear that he did not inspect these maps and he seems to have known nothing of the existence of the Carew maps.


### *Hickson Maps*


While the maps reproduced in the present volume have never before been published, mention must be made of the maps of Glanerought, Dariry and Iveragh which appear as an appendix to Hickson's Old Kerry Records.[52](javascript:footNote('E580000-001/note052.html')) Miss Hickson states that her maps ‘have been taken’ from the Carew maps. This must be interpreted to mean free adaptations and in no sense copies or reproductions. The lines of division in the originals have been greatly over-simplified, the keys to the maps have been transposed and considerable liberties taken with captions and titles. Moreover, the draughtsman was obviously unfamiliar with the script of the originals so that many words were badly garbled in transcription. Some of the misreadings are quite inexplicable and would have been obviated by a consultation of a modern map of Kerry. The Hickson maps, then, are of no historical value.


### *Currency and Coinage in the Survey*


The references to currency and coinage occurring throughout the text, as well as in the Desmond and Peyton Surveys, (‘half face money’, ‘old money’, ‘sterling’, ‘legal money of England’) call for some comment.[53](javascript:footNote('E580000-001/note053.html')) The background here is the successive debasement of the Irish coinage begun by 



---

p.9




Henry VIII and continued by his successors. Elizabeth I partially restored the standard for Irish silver coins in 1561 but lightened the weights. There was a somewhat similar development in English silver coinage during the Tudor period.


‘Old money’ or ‘half face money’ almost certainly refers to the English silver issues of Henry VIII struck on the sterling standard of 92.5 per cent pure silver. These coins carried the king's head in profile as distinct from the later issues of the same on a debased standard, where the portrait was full face or nearly so. As only half the face could be seen when struck in profile, the term ‘half face’ was a convenient one for distinguishing the profile issue from the later, or full face, issue. But there were, in fact, two English issues of silver on the sterling standard of Henry VIII. In the first (1509-26), they were based on a penny weighing 12 grains. In the second (1526-44), sometimes called the Wolsey coinage, the silver issues were based on a penny of 10 2/3 grains weight. It is this latter issue which is referred to in the survey as ‘half face’ or ‘old money’.


The term ‘legal money of England’ refers to the standard in force in England at the date of the survey, which was the sterling standard restored by Elizabeth in 1561.[54](javascript:footNote('E580000-001/note054.html')) The silver coinage in this restored sterling standard was, however, based on a penny weighing 8 grains. Therefore the bullion ratio of the ‘old money’ to the Elizabethan standard money (‘legal money of England’) was 10 2/3 to 8, i.e., 32 to 24, or 4 to 3. In other words, one-third would have to be added to any quantity of this Elizabethan English money to make it equal in bullion value to the same quantity of ‘old’ or ‘half face’ money of Henry VIII.[55](javascript:footNote('E580000-001/note055.html')) We may assume that where ‘old money’ or ‘half-face money’ is not specifically mentioned, a money reference relates to the then existing currency in the sterling standard at 8 grains to the penny.


The white groat is continually used in the monetary calculations in the survey. These groats are probably the debased Irish issues struck by Elizabeth in 1558 and possibly other debased issues struck before that by Mary (1554) and Philip and Mary (1555-58). All of these had only a 25 per cent silver content. The proclamations or orders defining these have not been discovered but the general average weights were about 8 grains to the penny for Mary, 12 grains to the penny for Philip and Mary, and 12 grains for Elizabeth. This would give a silver content varying from about 2½ to 3 grains per penny. Simon in his Irish Coins[56](javascript:footNote('E580000-001/note056.html')) states that the 1558 silver was recoined from English base issues. The English penny at 8 grains sterling would have roughly 7½ grains of silver and the bullion ratio of it to the Irish base penny would be roughly three to one (7½ to 2½), the tendency being to value the debased coinage at the lowest standard. This would reduce the value of the Irish base groat (nominally 4*d* ) to 1[frac13] pence ([frac13] of 4*d* ) in terms of the restored coinage of sterling standard of Elizabeth: in other words, 3 white groats would be equal to 4*d* in new sterling money. This is precisely the value of the white groat that one establishes by calculation from internal evidence in the survey.


What has been said may be illustrated from a passage in the survey where reference is made to a ‘cuddy or refection of a sopper 
and breakefast for the earle of Clancartie   
[*...*]  
 or els in lieu thereof five markes old money which amountcth to iiij*li* viij*s* viij*d* ij w[hite] g[roats].’[57](javascript:footNote('E580000-001/note057.html')) Since a mark was two-thirds of a pound,[58](javascript:footNote('E580000-001/note058.html')) five marks ‘old money’ was five times 13*s* 4*d*, or £3 6*s* 8*d* in ‘old money’. To get the equivalent of this sum in Elizabethan standard money, one-third (or £1 2*s* 2 2/3*d* ) has to be added. Thus we get £4 8*s* l0 2/3*d*, or £4 8*s* 8*d* and 2 white groats (worth 1 1/3*d* each). This may seem a strange method of keeping accounts but the white groat was in plentiful supply and had to be fitted into monetary calculations.[59](javascript:footNote('E580000-001/note059.html'))


All the calculations in the survey, as well as the individual and group tots, have been thoroughly checked and it has been found that, with very few exceptions, the scribal accounting is accurate. Such arithmetical anomalies as do occur are dealt with in footnotes to the text. The gross total at the end is a correct tot of the group totals given throughout the survey.




---

p.10


### *Land Measures*


It is not proposed to discuss the questions which the survey raises concerning Irish land measures, except to point out that the document affords further evidence of the irregularity of these measures.[60](javascript:footNote('E580000-001/note060.html')) Units of measurement varied from district to district: thus one late sixteenth-century source speaks of ‘every quarter containing three plowlands’ in the Muskerry district of mid-Cork[61](javascript:footNote('E580000-001/note061.html')) while another comments, with respect to the carl of Clancarthy's demesnes, that some quarters contain ‘four ploughlands, some three ploughlands and some five ploughlands as the country manner is variable’.[62](javascript:footNote('E580000-001/note062.html')) An even wider variation than this emerges from a study of the survey. By statement or implication, it informs us that the number of ploughlands to a quarter in different parts of Magunihy and Dunkcrron baronies ranged from something less than four to six.[63](javascript:footNote('E580000-001/note063.html'))


### *Definition of Services*


It may not be out of place to comment briefly on the list of
 interesting definitions of services which appear in the survey,
 sections 13-25. A peculiar feature of these terms is that many
 of them (*garemsloaeg*, *gallogoloh*, *kearnty*, *rout*
 and *musteroun* ) do not occur
 subsequently in the text. Some of the terms will be readily
 recognized by students of the political and
 military structure of Gaelic (and indeed Old English) society in the period before its collapse while others are relatively unfamiliar and even etymologically obscure.


1. garemsloaeg:
  
 
gairm sluag, ‘calling up of troops’. This is the well-known 
'rising out".
2. sorren:
  

sorthan, soirthean, ‘maintenance’, ‘free quarterage’. The general meaning would appear to be that of a tax or rent in victuals, etc.. extracted from vassals
 or inferiors.[64](javascript:footNote('E580000-001/note064.html')) Two other defintions of the term may be given here. Carew himself described it as ‘a kind of allowance over and besides the Bonnaghy, which the Galioglas expect [?] upon the poor people by way of spending-money, viz. 2*s* 8*d* . for a day and night; to be divided between three spears, for their meat, drink and lodgings’.[65](javascript:footNote('E580000-001/note065.html')) Where it occurs in a list of exactions by the earl of Desmond, it is given as meaning ‘a charge set upon the freeholders' lands for a number of galloglasses for certain days in a quarter.’[66](javascript:footNote('E580000-001/note066.html')). A comparison with the survey definition suggests that the term had no one specific meaning.
3. sorrenmore:
  

sorthan mór, ‘great sorren’.
4. cuddy:
  

cuid oidhche, ‘night's portion’. The ordinary meaning of this well-known term is a night's refection for the lord and his retinue.[67](javascript:footNote('E580000-001/note067.html')) The survey definition does not mention ‘night’ at all, but subsequently in the text it is equated with ‘a refection of a sopper and breakefast’.[68](javascript:footNote('E580000-001/note068.html')) Miss Henley notes a phonetically more correct form, cuddeehih, in B.L. Add. MS 22022.[69](javascript:footNote('E580000-001/note069.html')) The surnames Cuddihy, Quiddihy possibly derive from the term.
5. dowgollo:
  
 
The first syllable here is clearly dubh in the sense of ‘heavy’ or ‘oppressive’ (as in the familiar dubh-chíos). The etymology of the second clement is obscure. It may perhaps derive from (1) colla, a plural form of colainn, ‘flesh’, ‘carcase’, or (2) colludh, vb., ‘to ruin’; coll, n., ‘loss’, ‘ruin’. On the other hand the scribe's note that the term ‘signifieth Blacke rent’ suggests a corrupt form of dubh-ghabal, gabal meaning ‘tax’ or ‘tribute’.[70](javascript:footNote('E580000-001/note070.html')) See Exchequer Inquisitions (Kerry) Elizabeth William III, P.R.O.I., IA-48-89. p. 103: ‘. . .ut de nigro redditu anglic'dict' Black rent et Hibernice dict Dowgolie . . ..’
6. gallogobh:
  

i.e., gall-óglaigh, ‘galloglasses’. Robert Cowley in a letter to Cromwell in 1537 notes that ‘gallo-ghlaghes are noan other but as a kind of sowchynners, that servcth for their wages and 



---

p.11




not for love ne affection.’[71](javascript:footNote('E580000-001/note071.html')) This mercenary aspect is not mentioned at all in the survey definition where the distinguishing mark of these soldiers appears to be the fact that they carried axes.[72](javascript:footNote('E580000-001/note072.html'))
7. kearnty:
  

ceithearn tighe, ‘household troop’. The Middle Irish cethern has the meanings (1) a troop or company of foot-soldiers, and (2) a mercenary soldier, or, in familiar anglicized form, ‘kern’ or ‘kerne’. The meaning given in the survey, ‘light footmen’, is the usual one. The surname Kearney may possibly derive from this term.[73](javascript:footNote('E580000-001/note073.html'))
8. rout:
  

Etymology obscure. None of the various meanings of the word in the Oxford English Dictionary or the English Dialect Dictionary seems to be appropriate. Perhaps the term is connected with rout, ‘some kind of horse’ ( O.E.D.). Less likely is the use of ‘rout’ in the sense of ‘a long round of visits or calls’ ( E.D.D.) or ‘to gather together’ ( O.E.D.).
9. musteroun:
  
The survey definition accords with that in the state papers, ‘an impost on a tenant for the sustenance of the lord's builders’,[74](javascript:footNote('E580000-001/note074.html')) and with the meaning given for Musterroon in the list of the earl of Desmond's exactions, ‘a charge set upon the country to help the Earl in his works with cappells, garrans and men at his own will’.[75](javascript:footNote('E580000-001/note075.html')) The derivation of the term is less certain. The normal meaning of ‘muster’ does not seem to be relevant here, except perhaps in the sense of a gathering (of workmen). Dinneen renders the Irish mustrún as ‘a person of consequence locally’. He also refers to the Norman-French mustron, ‘right of service attached to land held’. This would certainly seem suitable but Dinneen's derivation cannot be verified from Early French dictionaries.[76](javascript:footNote('E580000-001/note076.html'))
10. canebeg:
  
cáin bheag, ‘a petty tax’. A common feature of thefiscal organization of a Gaelic lordship was the imposition of a small land-tax for the benefit of the lord's wife. It is perhaps the most frequently mentioned tribute in this survey. A similar tax, cíos or fiacha baintiarnain ('lady's rent'), in terms of gold or silver, is mentioned in the early fourteenth-century Suim Tigearnais Meic na Mara.[77](javascript:footNote('E580000-001/note077.html')) In a note dated June 1587 describing the organization of the O'Sullivan Beare lordship, it is stated that ‘the standing rent due to O'Sullivan out or upon his country is but 40*l.*, and that itself was ever allotted to the lady for the time being towards her idle expenses  
[*...*]  
’[78](javascript:footNote('E580000-001/note078.html')) In Welsh society a tribute of food and drink was likewise payable to the chieftain's wife.[79](javascript:footNote('E580000-001/note079.html'))
11. quirren:
  

Probably coirín, dim. of coire, ‘pot’, ‘cauldron’,meaning a small container of some sort.[80](javascript:footNote('E580000-001/note080.html')) The scribe defines it as ‘a measure of a pottle or fower pounde’. A ‘pottle’ is an obsolete liquid capacity measure equivalent to four pints.[81](javascript:footNote('E580000-001/note081.html'))
12. sroan:
  

Almost certainly srón, ‘nose’, as a synonym for an individual, more unusual, but no less rational, than the similar use of ‘poll’, ‘head’, ‘hand’ or ‘body’. Here it is an expression for a man's ration. Elsewhere it is a term for a poll-tax: almsa as cech sróin o Fermit Muighi, ‘a nose-tax from Fermoy’; cf. Old Norse nef-gildi, ‘nose tax’.[82](javascript:footNote('E580000-001/note082.html'))



### *Place-names*


About 240 place-names are mentioned in the survey, most of them being townland names. Other denominations also occur, some of which are now obsolete. Though Butler identifies a number of place-names, his Gleanings does not substantiate his claim that he was ‘able to find most of these townlands on the modern six-inch Ordnance maps’.[83](javascript:footNote('E580000-001/note083.html'))


---

p.12




Equally without substance is his assertion that 
S.T. MacCarthy ‘gives identifications of nearly all the townlands mentioned in the Survey’.[84](javascript:footNote('E580000-001/note084.html')) In fact, MacCarthy deals with only a handful of names.[85](javascript:footNote('E580000-001/note085.html'))


The names, of course, are of great interest and invite comparison with later forms—those, for example, in the Books of Survey and Distribution. Elizabethan renderings of Irish place-names are commonly regarded as barbarous, yet many of the names occurring in the survey are a good deal less mangled than seventeenth-century forms, and not a few are phonetically nearer to their Gaelic originals than their modern equivalents. Considerable time has been spent in investigating the place-names, the great majority of which have been identified on the six-inch Ordnance Survey maps: the exigencies of time did not permit further study of the remainder. The sensible remarks of another editor are pertinent here, and indeed they apply to all editorial work of this nature: ‘  
[*...*]  
 but a great many points that the editor would like to be able to explain and to understand more fully himself remain obscure. This is due simply to the fact that the task of searching for the answers to all these questions would have turned the volume into a life's work. At the same time, inability to explain everything that needs to be explained has not seemed to the editor to be a sound reason for refraining from giving what information he can.’[86](javascript:footNote('E580000-001/note086.html'))


All identified place-names are indexed under the modern spelling as given in the Townland Index (1877 edition). The versions found in the text are given in the index in their appropriate alphabetical position. Names which raise a particular point of interest are referred to in footnotes to the text. It should be understood that identifications given are modern equivalents of the name-*forms* occurring in the survey: the location or extent of any sixteenth-century denomination may be different from its present-day counterpart.


I should like to express my thanks to the archbishop of Canterbury and the trustees of Lambeth Palace Library for permission to inspect Carew Manuscript 625 and to publish the relevant folios, and also to Mr. Wyndham, owner of the Petworth manuscript, for permission to have it microfilmed for my use. I am also obliged to Professor Myles Dillon who kindly lent me his transcript of folios 22 recto-39 verso of Carew Manuscript 625.


John A. Murphy


---

p.13


THE CLANCARTHY SURVEY FROM CAREW MS 625
---------------------------------------


¶1] {MS folio 19 verso}A generall Suruay of all such landes as are conteyned within the Country of Desmond as wel of such as were the Earle of Clancarties owne demeanes as of all other landes belonging to the Lords and others the freholders of the said Country with what dewties rentes and Cheifryes are customablye to be payed to the said earle out of the same, taken upon the report[87](javascript:footNote('E580000-001/note087.html')) of the Sergeantes and officers of the saide Contrye.


¶2] Desmound is a parcel of the Countie of Kerry and is deuided into three Baronies and an half vz Magonny, Iuragha Dounkerran and the half baronye of Glanoroghto. In the Northe side yt is bounded by the river of the Mang which doth deuide Desmound from the rest of Kerry. The South part doth bound with certayne mountaynes of Bear and Bantry beginninge from Killmallockoshista[88](javascript:footNote('E580000-001/note088.html')) and continuinge to O Leary and O donouans landes in the countie of Corke. The last part doth bound with the countie of Corcke in the mountayne of Sleughlogher and are deuided by the head of the ryver of the Black Water. The rest of Desmound is bounded with the mayne Ocean sea.


*Here follows the general map of Kerry and Desmond* {MS folio 20 recto}, ![Map of Kerry and Desmond](http://www.ucc.ie/celt/images/Survey/KerryDesmond.jpg)


{MS folio 20 verso blank}.


¶3] {MS folio 21 recto}


The Earle of Clancartv his demeans whereof[89](javascript:footNote('E580000-001/note089.html')) 
Part he died ceassed of vz.[90](javascript:footNote('E580000-001/note090.html'))


The Castle of the Pallice[91](javascript:footNote('E580000-001/note091.html')) and Twogh grenoght[92](javascript:footNote('E580000-001/note092.html')) with these parcells followinge belonginge to them nowe in the occupation of the Countesse of Clancartye and others vz.


Lismorgan[93](javascript:footNote('E580000-001/note093.html')) Ahane
  

Coulmucky
  

Kippaghdellig
  

Gartinro
  

Loghaneycurrane
  

Farren—Cormocke these parcells conteyne seauen plowlandes 
  

Rosnecarten two plowlandes 
  

Dromkerry a plowlande 
  

Cloneysty a plowlande 
  

Keamcry a plowlande 
  

Killowran three plowlandes 
  

Kilclokeran[94](javascript:footNote('E580000-001/note094.html')) a plowlande 
  

Kippahylin a plowlande 
  

Downkinan a plowlande 
  

Crohane a plowlande 
  

Aglasydonnin three plowlande 
  

Ahado three plowlandes 
  

Ballihare a plowlande 
  

Muckennagh two plowlands 
  

Lahard a plowlande.


¶4] *Part in Florence mac Cartye his possession[95](javascript:footNote('E580000-001/note095.html')) vz* .


The Castle of the Logh with these sixe plowlandes vz. Erelahbeg and Mockrush[96](javascript:footNote('E580000-001/note096.html')) a plowland 
  

Ardogh a plowlande
  

Kilcloher a plowlande
  

Knockenour et Ballinshine a plowland
  

Carrickyphrean et Carehennane a plowland
  

Gortyninebrian and Dromyrourck a plowlande.
  



¶5] *Part morgaged unto Sir Valentine Browne vz* .


The Castle of Ballicarbry conteyninge one quarter Killelantir[97](javascript:footNote('E580000-001/note097.html')) halfe a quarter Killantere[98](javascript:footNote('E580000-001/note098.html')) halfe a quarter Comegognacaple[99](javascript:footNote('E580000-001/note099.html')) conteyninge half a quarter.


¶6] {MS folio 21 verso}*Part he disposed to his sonne Donell mac Carty vz.*


These are parcells of the landes of the Pallice vz.
  
 
Coshglanouragh a quarter
  

Balllincarrig a quarter
  

Gortneclohe a plowlande
  

Ballitrasneh a plowlande
  

Anahile a plowlande
  

These are parcells of the lands of Castlelogh vz.
  

Kilegy and Canfaned conteyninge three plowlands
  

These are parcells of the landes of Ballicarbry vz.
  

Caheen a quarter
  

Clohanlinoghan half a quarter
  

Fermonyharnett[100](javascript:footNote('E580000-001/note100.html'))
 di.[101](javascript:footNote('E580000-001/note101.html')) quarter Ballihernyyrrah lyinge in the lland of Dariry conteyninge half a quarter.




---

p.14


¶7] *Part morgaged to Mr. Denny and Mr. Humherton vz.*


Kilbeg in the Island of Dariry with all other his interest to the landes in the said lland and Customes and duties within the riuer and hauen of Bealinche[102](javascript:footNote('E580000-001/note102.html')).


¶8] *Part he disposed to his base brother Donogh McCarty vz.*


Tiraa conteyninge a quarter of lande beinge parcell of the landes belonginge[103](javascript:footNote('E580000-001/note103.html')) to the Castle of Ballicarbry.


¶9] *Fishings belonging to the earles castles[104](javascript:footNote('E580000-001/note104.html'))
ffishinge belonging to the castle of Pallice vz.*


Part of the fishinge of Loghlene


Part of the fishinge of the riuer of the Laune


Part of the fishinges of Loghcare which are all in the possession of the Countesse of Clancarty.


¶10] *ffishing belonginge to the castle of the Logh vz.*


Part of the fishing of Loglene


Part of the fishinge of the river of the Fliske[105](javascript:footNote('E580000-001/note105.html')) in Florence McCarties possession.


¶11] *ffishinge belonging to the castle of Ballicarbry vz.*


The fishinge in the hauen of Valencia in William Humberston and Thomas Denny gentlemens possession.


The fishinge in the hauen of Begennis[106](javascript:footNote('E580000-001/note106.html')) in Nicholas Brownes possession.


The fishinge in part of the Golin[107](javascript:footNote('E580000-001/note107.html')) and of the river of the Fartah possest by Donel McCarthy.


The fishinge of the Corrane and the ware[108](javascript:footNote('E580000-001/note108.html')) possessed by one James Meaugh[109](javascript:footNote('E580000-001/note109.html')) of Corcke Merchant by vertue of a morgage from the
earle of Clancartye.


¶12] {MS folio 22 recto}


*Landes clamed by the earle of Clancartye* [110](javascript:footNote('E580000-001/note110.html'))


Lateif, Bolus, Ballimacgilleneulan Killelelig conteyninge two quarters with all other the landes of Macgilleneulan[111](javascript:footNote('E580000-001/note111.html')) in Glanurcan[112](javascript:footNote('E580000-001/note112.html')) or els where possessed[113](javascript:footNote('E580000-001/note113.html')) passed to the earle of Clancar by an Irishe deed.


The Castle and landes of Mashanaglashy in Muskry in the Countie of Corcke an ancyent mannor belonging to MacCarty more which he reserued when he gave the rest of Muskry to his sonne, to the end that is it shold happen in processe of tyme his sonnes successors should not yeild him signorye and obedience, that then he might vse that place as a ffort or ward house from whence he might punish and annoye such of that countrye as should rise and rebel against him and his successors, beinge MacCarty moores.


The Landes of Carrowcormock in Dowalla in the countie of Corke an[114](javascript:footNote('E580000-001/note114.html')) ancyent mannor of Mac Carty moores reserued to the like vse that Mashanaglashy was etc.[115](javascript:footNote('E580000-001/note115.html'))


¶13] A note of such kinde[116](javascript:footNote('E580000-001/note116.html')) of Rentes and duties as the Llordes and 
ffreholders in Desmound did customablie use to paye to the earle of Clancarty.


¶14] *Garemsloaeg* is a risinge vpon a warninge given of all the able men of the countrye euerye man to be furnished with sufficient weapon and three dayes victuals and for euery defalt to be fyned at a choyce cowe or[117](javascript:footNote('E580000-001/note117.html')) xx*s* old money but such of the countrye as were his enemies would neyther pay nor yeald to any such fyne or risinge.




---

p.15


¶15] *Sorren* is a nightes meat vpon any such landes as the earle of Clancarty passeth through with his forces and companies and was an vncertayne charge and therefore not valued for the freeholders would not yeald to give any thinge in lieu thereof.


¶16] *Sorrenmore* is a certayne charge of meat which if the earle would not come in place for[118](javascript:footNote('E580000-001/note118.html')) to spende yt yet there was a certayne knowne quantitie and number of quirrens of butter and Sroans of oatmeale paid yearelie therefor[119](javascript:footNote('E580000-001/note119.html')) and every parcell of land was charged with his owne porcion which hath bene used tyme out of 
mynde.


¶17] *Cuddy* is a meales meat or a refection certaynelie knowne and is to be spent eyther at the freeholders house if the earle of Clancarty listed, or to be sent home to his house in certyne proportions of flesh, ag[120](javascript:footNote('E580000-001/note120.html')) aquavitae, ale, hony, flower or els in lieu thereof at the freeholders choyce iij *li* viij *s* viij *d*


¶18] {MS folio 22 verso}*Dowgollo* was a certayne rent for dogges meate and hunsmen[121](javascript:footNote('E580000-001/note121.html')) among the mountaynes of Desmound, and the lower countryes paid yt for horsemeat and dogges meat this rent of Dowgollo signifieth Blacke rent and all the freholders crye out upon yt, as imposed upon them by extorcion and stronge hande.


¶19] *Gallogoloh* were a certayne companye of foote soldiers beringe axes with whome the earle wold charge the country whensoever he would make warrs against the prince or the earle of Desmound or any other stronge Lord his neyghbor.


¶20] *Kearnty* a companye of light footmen that vpon like occasion the earle would charge the countrye with.


¶21] *Rout* a cesse for horsemeat[122](javascript:footNote('E580000-001/note122.html')) for the earles or his wiues owne horses vpon the barony of Magonny.


¶22] *Musteroun* a charge of workemen put in upon the earles owne tennauntes both for their wages and victualls, for any worke or buildinge he would vndertake.


¶23] *Canebeg* was a smal spending that the earls wife had out of divers quarters in the countrye, and yt was knowne certayne what every quarter was charged with.


¶24] A *Quirren* of butter is a measure of a pottle or fower pounde.


¶25] A *Sroan* of oatmeale is a gallon and a half of oatenflower made of burnt oates and because that in the payment of the Sorren the quirren of butter and Sroan of meale are of like number I do value the quirren and sroan at vi*d* str though in tymes past they were rated at iiij*d* str the quirren and a white groat the Sroan *Folios 23 recto and verso, 24 recto and verso are blank. Then follows the folded and unnumbered map of ‘Glanoroghto’.*


![Map of Glanoroghto](http://www.ucc.ie/celt/images/Survey/Glanoroghto.jpg)


¶26] {MS folio 25 recto}


*These are freholders of the sept of the Mac Carties descended from 
Mac Cartie Mores house and were his frendes.[123](javascript:footNote('E580000-001/note123.html')) 
Mac Finins landes.*


The quarter of Ardtully lyinge in the halfe baronye of Glanoroghto paied yearlie to the earle of Clancarty for a rent called Dowgoll at iiij *s* and iij beaues val.[124](javascript:footNote('E580000-001/note124.html')) per annum at xl *s* and for a rent cald Canebeg val. per annum xvi *d* ij whit groates et val. in toto per annum at . . . xlv*s* iiii*d* ii wh.gr.[125](javascript:footNote('E580000-001/note125.html'))


¶27] The quarter of Oghtocrossy and Barnestoig lyinge in the half baronye of Glanoroghto paid yearelie to the earle of Clancarty for a rent called Dowgollo at iiij *s* str. and iij beaues val. per annum xl str. and for Canebeg at xvi *d* ij whit groates et val. in toto perannum. . . xlv *s* iiij *d* ij wh.gr.


¶28] The two quarters of Clanloghlen lyinge in the halfe baronye of Glanoroghto payed yearlye to the earle of Clancarty for Dowgollo at viiij*s* str. and vi beaues val per annum at iiij*li* str. and for 



---

p.16




Canebeg at iii*s* i wh. gr. str. et val. in toto per annum . . . iiij*li* xi*s* i. wh. gr.


¶29] The quarter of Glanly lying in the halfe baronye of Glanoroghto 
paied yearelie to the Earle of Clancarty for Dowgollo at iiij *s* str. 
and iij beaues et[126](javascript:footNote('E580000-001/note126.html')) val. per annum xl*s* str. and for Canebeg at xvi*d*
ij wh. gr. str. et val. in toto per annum
. . . xlv*s* iij*d* ij wh. [gr.]


¶30] The quarter of the Creggy lying in the halfe barony of
Glanoroghto paid yearlie to the earle of Clancarty for Dowgollo
at iiij *s* str. and iij beaues val. per annum at xl *s* and tor Caneneg 
at xvi *d* ij wh. gr. str. et val. in toto per annum at
. . . xlv *s* iiiij *d* ij wh. gr.


¶31] The quarter of Renurroune[127](javascript:footNote('E580000-001/note127.html')) lyinge in the baronye of Iuragha 
was fre land not payinge any thinge to the earle of Clancarty but 
sute and service to his Court and rysing foorth agaynst his enemies
. . . Nihil.


¶32] The quarter of lande of Ballidouny, Coulgarruf Carecrehon 
Knocknefarnet[128](javascript:footNote('E580000-001/note128.html'))Ballispellane Cline and Tullagh conteyninge sixe 
plowlandes lyinge in the barony of Magonny is fre land paying 
nothing but sute and service to the Lords courte and risinges
. . . Nihil.


¶33] The sixe first quarters lyinge in the halfe baronye of Glanoroghto did giue an vncertayne Sorren to the earles companyes when they passed through these landes into the countryes of Bear or Bantry or into the countye of Corcke. {MS folio 25 verso} There are goodlie-timber woods in those landes lyinge in the halfe baronye of Glanoroghto fit for shipp timber, pipe,[129](javascript:footNote('E580000-001/note129.html')) staues and Clapboord[130](javascript:footNote('E580000-001/note130.html')) and lye neere the portable riuer of Canmarra.[131](javascript:footNote('E580000-001/note131.html'))


There belonges also to these landes certayne fishinges 
upon the riuer of Roghto.


There is thought to be a Myne of tynne or lead vpon these landes.[132](javascript:footNote('E580000-001/note132.html')) 
There breedes upon the woodes of these landes an Eyry or two of Goshaukes.[133](javascript:footNote('E580000-001/note133.html'))


Some of all such rent as is dewe out of these landes is . . . xiii *li* xiii *s* iiij *d*


¶34] *Clan Donell Funs Landes*


The quarter of the Datireouioil[134](javascript:footNote('E580000-001/note134.html')) lyinge in the baronye of Iuragha doth paye yearlie for a certen Sorren at xl quirrens of butter and xl sroans of oten meal which valued at vi *d* str. the Quirren and Sroan val. per annum at xx *s* . also for Dowgollo at iiij *s* for Canebeg at xvi *d* ij wh. gr. et val. per annum


. . . xxv *s* iiij *d* ij. wh. [gr.].


¶35] The quarter of Lacarrow garruf and Lacarrow bristy lyinge 
in the barony of Iuragha doth yearelie pay for Sorren xltie quirrens 
of butter, xltie sroans of oatenmeal val. per annum xx*s* for Dowgollo 
iiij*s* for Canebeg xvi*d* str. ij. wh. gr. et val. per annum in toto.


. . . xxv*s* iiij*d* ij wh. [gr.].


¶36] The quarter of Lismorogho and Carrownecorre[135](javascript:footNote('E580000-001/note135.html')) lyinge in 
the barony of Iuragha doth pay yearelie for Sorren xltie quirrens 
of butter xltie sroans of oatmeal val. per annum xx*s* str. for Dowgollo 
iiij*s* for Canebeg xvi*d* ij. wh. gr. str. et val. in toto per annum.


. . . xxv*s* iiij*d* ij wh. [gr.].


¶37] The quarter of Ballinehow and Kilognauin lyinge in the 
baronye of Iuragha doth pay yearelie for Sorren xltie quirrens of 
butter and xltie sroans of oatmeal val. per annum xx*s* str. for Dowgollo 
iiij*s* str. for Canebeg xvi*d* ij wh: gr: str. et val. in toto per annum


. . . xxv *s* iiij *d* ij [wh. gr.].


¶38] The plowland of Listry lying in the baronie of Magonny payeth 
yearelie a beaf val xiij *s* iiij *d* a hog val. v *s* for Dowgollo xij quirrens 
of butter and xij sroans of oates at xij *d* le score at ij *s* str. and in money 
for Dowgollo viij *d* ii wh: gr: et val. in toto per annum


. . . xxvii *s* ij [wh. gr.].




---

p.17


¶39] {MS folio 26 recto} The plowlande of Killinromano lying in the baronye of Magonny payeth the third part of a beaf yearele et val. iiij *s* iiij *d* i wh: gr: str. the third part of an hog at xx *d* and in money vi *s* viij *d* also for Dowgollo at ix *s* i wh. gr. et val. per annum in toto.


. . . xxi *s* viij *d* ij wh. gr.


¶40] The plowlande of the Phaah[136](javascript:footNote('E580000-001/note136.html')) lyinge in the baronye of Magonny payeth yearelie iiij beaues et val. per annum


. . . liij *s* iiij *d* .


¶41] The quarter of Ballinemah[137](javascript:footNote('E580000-001/note137.html')) conteyning fiue plowlandes lying in the baronie of Magonny payeth yearlie a beafe val. xiii *s* iiij *d* str. also an hog val. v *s* and for the rent of Dowgollo for fiue plowlandes at ix *s* i wh. gr. the plowlande at xlv *s* iiij *d* ij wh. gr. et vas. per annum . . . iij *li* iij *s* viij *d* ij wh. gr.


¶42] The two plowlande of Gortneclohe[138](javascript:footNote('E580000-001/note138.html')) lyinge in the baronye of Magonny paye yearelie two third partes of a beafe val. xiii *s* iiij *d* str.[139](javascript:footNote('E580000-001/note139.html'))
viij *s* viij *d* str. two thir[140](javascript:footNote('E580000-001/note140.html')) partes of an hog iij *s* iiij *d* str. and for Dowgollo for two plowlands xviij *s* ij wh. gr. et vas. per annum . . . xxx *s* ij wh. gr.


¶43] The plowlande of Ardmelod in the Baronie of Magonny is fre land owing sute and seruice to the Lords court with risinge


. . . Nihil


Somma totalis annualis Redituum terre de Clandonellin


. . . xiiij *li* xv *s* viij *d* 1 wh. gr.[141](javascript:footNote('E580000-001/note141.html'))


¶44] Those landes that lye in the baronie of Iuragha haue part of the fishings vpon the riuer of the Fartagh.


Those other landes that lye in the baronye of Magonny haue some fishinge upon the riuer of the Guissidine


Those landes that ley in the baronie of Magonny were bounde to drawe with garrans[142](javascript:footNote('E580000-001/note142.html')) the earle of Clancarties wine from the abbey of 
Killagha to the Garriduff in the Pallice, they were also bound to thatch the earle of Clancarties house in the Garriduff but no where els.


¶45] *Slughte ninerudris land* [143](javascript:footNote('E580000-001/note143.html'))


The quarter of Kileuterco[144](javascript:footNote('E580000-001/note144.html')) in the baronie of Iluragha payeth yearlie 
iij beaues val. xl *s* for Dowgollo iiij *s* str. for Canebeg xvi *d* ij wh. gr. str. 
for a certayn Sorren xltie quirrens of butter and xltie sroans of oatmeal xx *s* str. et val. per annum in toto


. . . iij*li* v *s* iiij *d* ij wh. gr.


¶46] [{MS folio 26 verso} The quarter of Dromkereh lyinge in the 
baronie of Iuragha payeth yearlie iij beaues vas. at xl *s* str. for 
Dowgollo iiij *s* str. for Canebeg xvi *d* ij wh. gr. str. for a certayne Sorren 
xltie quirrens of butter and xltie sroans of otemeal val. xx*s* str. et 
val. in toto per annum


. . . iij*li* v*s* iiij*d* ij wh. gr.


¶47] The halfe quarter of Canburren and the half quarter of 
Termonirrah[145](javascript:footNote('E580000-001/note145.html')) paye yearlie iij beaues et val. xl*s* str. and for Dowgollo at iiij*s* str. for Canebeg xvi*d* ij wh. gr. str. for a certayne Sorren xltie quirrens of butter and xltie sroans of oatemeal val. xx*s* str. et val. per annum


. . . iij*li* v*s* iiij *d* ij wh. gr.


Somma totallis annualis redituum
 harum terrarum val.


. . . ix *li* xvi *s* viij *d*




---

p.18


¶48] These landes haue certayne fishinges and Ilandes upon Lochleigh and in the riuer of the Finne.[146](javascript:footNote('E580000-001/note146.html'))


¶49] *Slught Donell bric[147](javascript:footNote('E580000-001/note147.html')) alias Mac tege ne toughs[148](javascript:footNote('E580000-001/note148.html')) land vz*.


The baronie[149](javascript:footNote('E580000-001/note149.html')) quarter of Seskenan[150](javascript:footNote('E580000-001/note150.html')) lyinge in the baronie of Yuragha doth paye yearelie iij beaues val. xl *s* str. for Dowgollo iiij *s* str. for Canebeg xvi *d* ij wh. gr. et val. per annum


. . . xlv*s* iiij*d* ij wh. gr.


¶50] The quarter of Coremore[151](javascript:footNote('E580000-001/note151.html')) and Ballihernymore beinge in the Ilande of Dariry alias Bealinche lying in the barony of Iuragha payeth yearlie iii beaues vas. xl *s* str. for Dowgollo iiij *s* str. for 
Canebeg xvi *d* ij wh. gr. et val. in toto per annum


. . . xlv *s* iiij *d* ij w.g.


¶51] The half quarter of Glanlim in the Iland of Dariry lying in the baronie of Iuragha payeth yearelie a beafe and an halfe val. xx *s* str. for Dowgollo ij *s* str. for Canebeg viij *d* i wh. gr. str. et val. per annum.


. . . xxij *s* iiij *d* ij w.g.[152](javascript:footNote('E580000-001/note152.html'))


¶52] The quarter of Cho[153](javascript:footNote('E580000-001/note153.html')) Clohanmaccuin and Comeegognacaple lyinge in the baronie of Iuragha payeth yearle iij beaues val. at xl *s* str. for Dowgollo iiij *s* str. for Canebeg xvi *d* ij wh. gr. str. et val. per annum


. . .xlv *s* iiij *d* ij wh. gr.


Somma totallis annuallis redituum harum terrarum val.


. . .vij *li* xix *s* iiij *d* wh. gr.[154](javascript:footNote('E580000-001/note154.html'))


*Here follows the map of the ‘Iland of Dariry’ ({MS folio 27 recto})* ![Map of Iland and Dariry](http://www.ucc.ie/celt/images/Survey/Dariry.jpg)


{MS folio 27 blank}


¶53] {MS folio 28 recto}*Slught Finn Duffs lands of Ardcanagh*


The quarter of Knockhornoght[155](javascript:footNote('E580000-001/note155.html')) conteyninge fiue plowlands lying in the baronie of Magonny payeth yearlie xij quirrens of butter and xij sroans of oatemeal out of euerie plouland val. at vi *s* le plowland et in toto xxx *s* also viij *d* ij wh. gr. a plowland et val. in toto iiij *s* iiij *d* i. wh. gr. str. and fortie sheafes of oates in a plowland 
et val. in toto[156](javascript:footNote('E580000-001/note156.html')) x *s* all which val. per annum


. . . xl iiij *s* iiij *d* i. wh. gr.


¶54] The two ploulands of Ardcanaght are fre land lyinge by North the riuer of the Mang vpon the which yt hath some fishinges and is charged with a Cheifry to the earle of Desmound


. . . Nihil


Somme[157](javascript:footNote('E580000-001/note157.html')) tot[158](javascript:footNote('E580000-001/note158.html')) anualis reddituum harum terrarum val. . . . xl iiij *s* iiij *d* i. wh. gr.


¶55] *Slught Niddins land Vz.*


The quarter of Niddin lyinge in the halfe baronie Glanoroghto paieth yearlie iij beaues val. xl*s*, and for Dowgollo iiij*s* str. for Canebeg xvi*d* ij wh. gr. str. besides a share of a Sorren with Gortagas[159](javascript:footNote('E580000-001/note159.html')) et val.


. . . xlv*s* iiij*d* ij wh. gr.


¶56] The quarter of Killasserah[160](javascript:footNote('E580000-001/note160.html')) lying in the half baronie of Glanoroghto payeth yearelie iij beaues val. xl *s* and for Dowgollo iiij *s* for Canebeg xvi *d* ij wh. gr. besides a share of a Sorren with Gortagas et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


Somma tot[161](javascript:footNote('E580000-001/note161.html')) annualis reddituum harum terrarum val.


. . . iiij *li* xi *s* 1 wh. gr.




---

p.19


¶57] These landes haue reasonable good woodes vpon them and some fishinges vpon the riuer of Roghto.


¶58] *Clan tege Rettaghs[162](javascript:footNote('E580000-001/note162.html')) land vz.*


The quarter of Dromdagour lying in the baronie[163](javascript:footNote('E580000-001/note163.html')) half baronie of Glanoroghto payeth yearelie iij beaues val. xl *s* str. and for Dowgollo iiij *s* for Canebeg xvi *d* ij wh. gr. str.[164](javascript:footNote('E580000-001/note164.html')) payeth with Gortagas et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


Somma totalis annualis reddituum harum terrarum val.


. . . xlv *s* iiij *d* ij wh. gr.


¶59] *These ar freholders of the septes of the Mac Carties and others for the most part descended out of Mac Carties house and were his ancient ennemies*[165](javascript:footNote('E580000-001/note165.html'))


{MS folio 28 verso}
*Slughte Cormock of Dounguills landes* [166](javascript:footNote('E580000-001/note166.html'))


The quarter of Kilurly lyinge in the baronie of Iuragha paies yearlie iij beaues at xl *s* str. for Dowgollo iiij *s* str. for Canebeg xvi *d* ij wh: gr. et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


¶60] The quarter of Kippah and Srowgrene lyinge in the baronie of Iuragha paies yearelie iij beaues val. xl *s* str. for Dowgollo iiij *s* str, for Canebeg xvi *d* ij. wh. gr. et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


¶61] The quarter of Corebeg[167](javascript:footNote('E580000-001/note167.html')) et Brinemikane[168](javascript:footNote('E580000-001/note168.html')) in the Iland of Dariry in the baronie of Yuragha payes yearelie iii beaues val. xl *s* for Dowgollo iiij *s* for Canebeg xvi *d* ij wh. gr. et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


¶62] The quarter and half of Coul Finne[169](javascript:footNote('E580000-001/note169.html')) and Feuhma in the Iland of Dariry in the baronie of Yuragha pay yerlie iiij beaues di[170](javascript:footNote('E580000-001/note170.html')) iij *li* str. for Dowgollo vi *s* for Canebeg iij *s* i wh. gr. et val. per annum


. . . iij *li* ix *s* i wh. gr.


¶63] These landes pay an uncertayne Sorren to the earle of Clancarty when he shal passe through their landes. Part of the fishinges of the riuer of Fartagh and ils the hauen of Bealinche[171](javascript:footNote('E580000-001/note171.html')) belongs to them.


¶64] The two quarters and a halfe of Dounguil 1 plowland Lismac-finin 1 plowland Corbally 1 plowland Ballyberane one plowland Dromen 1 plowland Anglont 1 plowland Dromanahin[172](javascript:footNote('E580000-001/note172.html')) 1 plowland Doweh[173](javascript:footNote('E580000-001/note173.html')) ij plowlands lyinge in the baronie of Magonny do paye yearelie vij beaues and a halfe v *li* and for Dowgollo out of the Doweh ij*s* et val. per annum


. . . v*li* ij*s*.


¶65] The halfe quarter of Kilmore lyinge in the baronie of Magonny paies yearelie xxiiij quirrens of butter and xxiiij sroans of otenmeale val. xij *s* and fowre score sheafes of oates val iiij *s* str. and money viij *d* ij wh. gr. et val. per annum


. . . xvi*s* viij*d* ij w. g.




---

p.20


Somma totalis annualis reddituum harum terrarum val. at


. . . xvi*li* iiij*s* viij*d.*


¶66] These landes lyinge in the baronie of Magonny haue good salmon fishings vpon the riuer of the Careh and the Logh Careh and also vpon the riuer of the Laune.


{MS folio 29 recto and verso, blank}


*[Here follows the folded-in map of ‘Magonny’ with the MS folio number 30 and in addition in the top left hand corner the figure 4 (the fourth map?)]*


{MS folio number 30}![Map of magonny](http://www.ucc.ie/celt/images/Survey/Magonny.jpg)


¶67] {MS folio 31 recto} *Clan Dermondes landes*


The quarter of Gortagas lyinge in the halfe baronie of Glanoroghto paies yearelie iij beaues val. at xl *s* str. for Dowgollo iiij *s* for Canebeg xvi *d* ij wh. gr. et val. per annum


. . . xlv *s* iiij *d* ij wh. gr.


¶68] The quarter of Coremore[174](javascript:footNote('E580000-001/note174.html')) lyinge in the halfe baronie of Glanoroghto paies yearelie iij beaues val. xl *s* str. for Dowgollo iiij *s* for Canebeg xvi*d* ij wh. gr. et val. per annum


. . . xlv*s* iiij*d* ij wh. gr.


¶69] The quarter of Balligriffin[175](javascript:footNote('E580000-001/note175.html')) in the halfe baronie of Glanoroghto paies yearlie iij beaues val. xl*s* for Dowgollo iiij*s* for Canebeg xvi*d* ij wh. gr. 


. . . xlv *s* iiij *d* ij wh. gr.


¶70] The quarter of Kilmichell[176](javascript:footNote('E580000-001/note176.html')) and Killinne in the halfe baronie of Glanoroghto paies yearlie iij beaues xl *s* str for Dowgollo iiij *s* for Canebeg xvi *d* ij w. g.


¶71] These landes did beare there[177](javascript:footNote('E580000-001/note177.html')) porcion of an vncertayne Sorren when the earle of Clancartie passed through the countrye.


Part of the fishinges of the Roghto and of the riuer of Canmarra belongs to them. There are goodlie timber woodes vpon them.


¶72] [178](javascript:footNote('E580000-001/note178.html')) The quarter of Kilmacowen[179](javascript:footNote('E580000-001/note179.html'))
lyinge in Bear in the Countie of Corcke paies yearelie for Dowgollo iiij*s* and part of an[180](javascript:footNote('E580000-001/note180.html')) vncertayne Sorren et val. per annum.


. . . iiij *s* .


¶73] The quarter of Nyinche lying in Bear in the countie of Corckk paies yearelie for Dowgollo iiij *s* and part of an vncertaine Sorren et val. per annum


. . . iiij*s* .


¶74] The quarter of Ballicastlane lying in Bear in the countie of Corcke paies yearlie for Dowgollo iiij *s* and part of an vncertayne Sorren et val.


. . . iiij*s*.


¶75] The quarter of Derikiuin[181](javascript:footNote('E580000-001/note181.html')) lyinge in Bear in the countie of Corcke paies yearelie for Dowgollo at iiij *s* and part of an vncertayne Sorren


. . . iiij*s* .


¶76] These landes lye commodiouslie for fishinge vpon Bearhauen


Somma totalis anualis reddituum harum terrarum val.


. . . ix*li* xviii*s* ij wh. gr.




---

p.21


¶77] {MS folio 31 verso} *Clan Donell Roes Land*


The landes of Clandonell ro amounto[182](javascript:footNote('E580000-001/note182.html')) viij quarters di.[183](javascript:footNote('E580000-001/note183.html')) lyinge in the baronie of Bantry in the countie of Corcke paies yearlie xxtie ounces of siluer at ij*s* ij wh. gr. str. le ounce et val. per annum


. . . xliiij*s* iiij wh. gr.


¶78] These landes did yeald two vncertaine Sorrens when the earle did[184](javascript:footNote('E580000-001/note184.html')) of Clancartie did passe to and fro among them.


These landes are fallen to her Majestie and are part of the vndertakers lande[185](javascript:footNote('E580000-001/note185.html'))


Somma totalis anualis reddituum harum terrarum val.


. . . xliiii *s* iiij wh. gr.


¶79] *Slught Owen More of Coshmangs lande*


The seauen quarters in Muskryloger[186](javascript:footNote('E580000-001/note186.html')) vz Gortnegan Senaghro Gortderg Rahmore Kilcoan Duffcarrig Lisnegan ar lying in the baronie of Magonny and pay for Dowgollo iiij *s* a quarter and were otherewise free from all charges et vat. per annum


. . . xxviii *s* .


¶80] The two quarters of Baslekan Taur and Laugher lyinge in the 
baronie of Yuragha pay yearlie for Dowgollo viii *s* str. and ar otherwise fre vat. per annum


. . . x*s*, viii*d* [187](javascript:footNote('E580000-001/note187.html'))


¶81] These two quarters lyinge in Yuragha ioyne upon the riuer of the 
Corrane and with the hauen of Ballinskellig.


¶82] [188](javascript:footNote('E580000-001/note188.html')) The rest of the landes of Coshmang which are ten quarters 
and a half of chargeable landes and a thirde part ar[189](javascript:footNote('E580000-001/note189.html')) lyinge in the baronie of Magonny and did paye yearlie a Cuddy or refection of a sopper and breakefast for the earle of Clancartie and his companie, or els in lieu thereof fiue markes old money which amounteth to iiij *li* viij *s* viij *d* ij w. g. also for a Sorren clx quirrens of butter and clx sroans of oatmeale vat. iiij *s* for Dowgollo after the rate of xij quirrens and xij sroans to the plowland ther[190](javascript:footNote('E580000-001/note190.html')) being xltie plowlandes yt riseth to cccclxxx quirrens of butter and cccclxxx sroans of oatmeal val. xij *li* str. also Viij *d* ij wh. gr. in euerie plowland of xltie val. xxxv *s* iiij *d* [191](javascript:footNote('E580000-001/note191.html')) str. also xltie sheaves of oates out of euerie plowland of xl plowlands at xij *d* le score val. iiij *li* so that all the rent of thes [192](javascript:footNote('E580000-001/note192.html')) landes chargeable val. per annum


. . . xxvj *li* iiij *s* ij wh. gr.


{MS folio 32 recto blank}
*[Then follows the map of ‘Yvragha’, folded in, numbered 33 and (when spread out) occupying a space corresponding to {MS folio 32 verso} and {MS folio 33 recto}*


{MS folio 33 verso blank}
¶83] {MS folio 34 recto}The two quarters of Ne farrennecareh[193](javascript:footNote('E580000-001/note193.html')) lyinge in the baronie of Magonny are altogether fre from the earl of Clancarty and do yearlie pay to the abbay of Killala[194](javascript:footNote('E580000-001/note194.html')) at xl*s* . These landes ly upon the riuer of the Mang on the North side hauing some fishing[195](javascript:footNote('E580000-001/note195.html')) There are two quarters di.[196](javascript:footNote('E580000-001/note196.html')) dispersed among the other landes which were fre landes and bore no imposition


Somma totalis anualis reddituum harum terrarum val.


. . . xxviii*li* ij*s* viij*d* ii w. g.


¶84] The landes are fallen to her Majastie by the attaindre of the freholders and are part of the vndertakers landes.




---

p.22


¶85] *Odonogho Moors land vz* .


The landes[197](javascript:footNote('E580000-001/note197.html')) of Onaught Odonogho conteyninge a xi quarters and an half which amount to xlv plowlandes lying in the baronie of Magonny paid yearlie a Cuddy or refection or in lieu thereof fiue markes half face val. iiij*li* viij*s* viij*d* wh. gr. str. also for Dowgollo xij quirrens of butter and xij sroans[198](javascript:footNote('E580000-001/note198.html')) of oatmeal out of euerie plowlande in xlv which amounteth to a[199](javascript:footNote('E580000-001/note199.html')) dxl quirrens of butter and to a[200](javascript:footNote('E580000-001/note200.html')) dxl sroans of oatmeal val. xiij*li* x*s*, also viij*d* ij wh. gr. out 
of euery plowland val. xls also fortie sheaues of oates out of euery plowland of xlv val. iiij*l* x*s* et val. per annum


. . . xxiiij*li* viij*s* viij*d* ij wh.gr.


¶86] These landes ar fallen to her Majestie by the attaindre of the ffreholders and ar part of the undertakers landes.


There ar diuers diue[201](javascript:footNote('E580000-001/note201.html')) timber woodes upon these landes but no meanes to make commoditie of them by reason that they lie in such remote mountaines.


There belonges part of the fishinge of the Laun and of Loghlene unto these landes and also part of the riuer of the Flisk[202](javascript:footNote('E580000-001/note202.html')) and divers others smal brookes and Loghes[203](javascript:footNote('E580000-001/note203.html')).


Also the Glans of Barenesna which are remote and vnaccessable but with much paines in time of feare.


Somma totalis anualis reddituum harum terrarum val. 


. . . xxiiij *li* viij *s* viij *d* ij wh. gr.


¶87] {MS folio 34 verso} *Odonogho Glanflisks lands*


The landes of Glanslisk[204](javascript:footNote('E580000-001/note204.html')) amounting to fiue quarters of land which conteines xxtie plowlands lyinge in the baronie of Magonny doth 
paie yearlie xxvi*s* viij*d* str.[205](javascript:footNote('E580000-001/note205.html')) and iiij barrens of bear[206](javascript:footNote('E580000-001/note206.html')) or ale val. xiij *s* 
iiij *d* str. et val. per annum at


. . . xl*s*.


¶88] There are excellent Ashen trees for pikes in this land, an Eyrye or two of Goshauks[207](javascript:footNote('E580000-001/note207.html')) and diuers fishinges upon the Flisk


Somma totalis anualis reddituum harum terrarum val. at


. . . xl*s*


¶89] *Slught Murris lands*


The quarter of Killine[208](javascript:footNote('E580000-001/note208.html')) Kiluenan Bealamalah Ballinprior and Bealamalagh beg conteyninge iiij ploulandes and a half[209](javascript:footNote('E580000-001/note209.html')) lyinge in the baronie of Magonny paid yearlie xi *s* i wh. g: a plowland which out of iiij plowlands amounteth to xliiij*s* iiij wh. gr. also xij quirren of butter and xij sroans a plouland which amounteth to xlviij quirrens and xlviij sroans val. xxiiij*s* xltie> sheaues of oates a plowland 
val. viij *s*, also in money in euery plowland viij *d* ij wh. gr. val. iij *s* iiij*d* ij wh.gr. et val. per annum


. . . iiij*li* .


¶90] There belonges to these landes certaine fishinges of Salmon and pearl[210](javascript:footNote('E580000-001/note210.html')) vpon the Laune.


Somma totalis anualis redituum harum terrarum val. at. . . iiij*li* .


¶91] *These are the septes of the O Suliuans and were commonlie at warre with the earle of Clancar and alwayes sought his weakninge.[211](javascript:footNote('E580000-001/note211.html')) O Sulliuan Moores lands* [212](javascript:footNote('E580000-001/note212.html'))


These eigh[213](javascript:footNote('E580000-001/note213.html')) quarters and an half vz. Dromed Kilmackerin, Carrowclanloghlen, Canneh Malen Come[214](javascript:footNote('E580000-001/note214.html')) Kilemelagh[215](javascript:footNote('E580000-001/note215.html')) Killonchaa and Ardcoste lying in the baronie of Yuragha pay yearelie for a 



---

p.23




Sorrenmore 
ccxl quirrens of butter and ccxl sroans of oatmeal val. vi *li* str. and for Dowgollo iiij *s* a a[216](javascript:footNote('E580000-001/note216.html')) quarter val. xxxiiij *s* et val. per annum


. . . vii*li* xiiij *s*


¶92] These iij quarters and half vz Dounkerran[217](javascript:footNote('E580000-001/note217.html')) Gortewollin Cappagh ro et Cappaghnecoshe lyinge in the baronie of Dounkerran paye yearlie for Dowgollo xiiij *s* for Canebeg v*s* iiij*d* 1 wh. g[218](javascript:footNote('E580000-001/note218.html')) besides an[219](javascript:footNote('E580000-001/note219.html')) vncertayne Sorren et val


. . . xix*s* iiij *d* i wh. gr.


{MS folio 35 recto blank}


*[Then follows the map of Dounkerran, folded in, numbered 36 and (when spread out) occupying a space corresponding to {MS folio 35 verso} and {MS folio 36 recto}*.


{MS folio 36 verso blank}


¶93] {MS folio 37 recto}The two quarters of Slught mac Cragh lying in the baronie of Downkerran paye yearelie for Dowgollo viij *s* and for Canebeg iij *s* i wh. gr. et val. per annum at


. . . xi*s* i wh. gr.


¶94] The quarter of the Lackin et Dromcuineh[220](javascript:footNote('E580000-001/note220.html')) in the baronie of Downkerran pay yearlie for Dowgollo iiij *s* and for Canebeg xvi *d* 
ij wh gr et val. per annum at


. . . v*s* iiij *d* ij wh. gr.


¶95] The quarter of Coulmagort lying in the baronie of Downkerran paies yearlie a Cuddy or a refection or in lieu thereof fiue markes 
halface[221](javascript:footNote('E580000-001/note221.html')) which commeth to iiij *li* viii *s* viij *d* et val. p. an.[222](javascript:footNote('E580000-001/note222.html')) ij wh.gr. et val.


. . . iiij *li* viii *s* viij *d* ij w g.


¶96] The landes and Castle of Dounlo lying in the baronie of Dounkerran paies yearlie a Sorren of cxx quirrens of butter and 
cxx sroans of oatmeal et val. at


. . . iii*li* .


¶97] The fiue quarters of Dounlo lyinge in the baronie of Dounkerran paies yearlie lxxij quirrens of butter and lxxij sroans the quarter 
which amounteth to ccclx quirrens of butter and to ccclx sroans of oatmeale val. ix *li* str. also lxvij sheaues of oates out of euerie 
ploulande and iiij plowlands to the quarter amounteth to cclxviij sheaues in the quarter so that fiue quarters pay one thousand cccxltie
sheaues of oates et val. iij *li* vij *s* also out of euery quarter in money iiij *s* iiij *d* 1 wh. gr et val. xvij *s* viii *d* i wh. gr.[223](javascript:footNote('E580000-001/note223.html')) str. et val. per annum


. . . xiij*li* iiij*s* viij*d* 1 w g.


¶98] The two quarters of Glancare[224](javascript:footNote('E580000-001/note224.html')) lying in the baronie of Dounkerran paies yearlie iiij *s* a quarter of Dowgollo et val. per annum


. . . viij*s* .


¶99] The iiij quarters of Glanuehe lyinge in the baronie of Dounkerran payes yearelie for Dowgollo iiij *s* a quarter et val. xvi *s* and for Canebeg viii *d* ij wh: gr. a quarter et val. iij *s* iiij *d* ij w. g. et val. per annum at


. . . xix*s* iiij*d* ij wh. gr.


¶100] The two quarters of Lateif Bolus Ballimacgilleneulan[225](javascript:footNote('E580000-001/note225.html')) and 
Killelelig lyinge in the baronie of Yuragha pay yearelie for Dowgollo iiij *s* a quarter val.[226](javascript:footNote('E580000-001/note226.html')) also for Canebeg viii *d* ij w. g. a quarter val. xx *d* i wh: gr. et val. per annum


. . . ix*s* viij *d* i wh. gr.




---

p.24


¶101] These two last quarters ly neare the hauen of Bealinche and haue some part of the fishinges thereaboates.


The landes of Dounlo haue diuers fishinges vpon the riuer of the Laurie and there is oftentimes pearle[227](javascript:footNote('E580000-001/note227.html')) gathered.{MS folio 37 verso} The landes of Dounkerran and Cappahnecoshe lye vpon the riuer et hauen of Canmarra and haue diners good fishinges therein as also at Sleunecollo good tymber. The eight quarters of Dromed etc. haue good fishinges vpon the riuer Finne.[228](javascript:footNote('E580000-001/note228.html'))


Somma totalis annualis reddituum harum terrarum val. at


. . . xxxij*li* i*s* i wh. gr.


¶102] *Mac Gillecuddehs Lands*


The Castle and iiij plowlands of Bodomesmin lying in the baronie of Dounkerran payes yearlie iiij beaues et val. per annum


. . . liij *s* iiij *d* .


¶103] The landes of Slughtmacrury in Twogh Clanihe being xij plowlands and an half lying in the barome of Dounkerran paye 
yearlie for Dowgollo xviij quirrens of butter and xviij sroans of oatmeale a plowland which amounteth in the whole unto ccxxv 
quirrens of butter and to ccxxv sroans of oatmeal et val. v *li*, xij *s* vi *d* str 
also lx sheaues of oates out of a plowland which amounteth to vij cl sheaues et val. xxxvij*s* vi*d* str also for a cuddy or refection viij quirrens of butter and viij sroans of oatmeale on a plowland which amounteth to c quirrens of butter and c sroans of oatmeal et val. l*s* 
str also vpon Coulro[229](javascript:footNote('E580000-001/note229.html')) besides a share in al other duties in money xl *s* i. wh.g. also viij *d* ij wh. gr. vpon euerie plowland val. xi *s* i wh: gr. 
et val. per annum at


. . . xi *li* ij ij wh. gr.


¶104] [230](javascript:footNote('E580000-001/note230.html'))The quarter of Careogerrane lying in the half baronie of Glanoroghto paied yearlie to the earle of Clancarty xviij beaues. these landes lye vpon the riuer Roghto et val. per annum


. . . xij *li* .


¶105] The fiue quarters vz. Lomanah Caredonelmore, Darah, Coed et Bracarah Cappaghrush et Goulan lying in the baronie of 
Dounkerran pay yearlie for a Dowgollo iiij *s* the quarter et val. xx *s* 
for Canebeg in the quarter xvi *d* ij w.g. val. vij *s* viij *d* i wh: gr. with 
an vncertaine Sorren et val. per annum xxvij[231](javascript:footNote('E580000-001/note231.html'))


. . . xxvij *s* viij *d* i wh. gr.


Somma totalis anualis reddituum harum terrarum val at


. . . xxvij *li* iij *s* iiij *d* .


¶106] The landes of B[232](javascript:footNote('E580000-001/note232.html'))Bodomismin[233](javascript:footNote('E580000-001/note233.html')) and Slughtmcrury [234](javascript:footNote('E580000-001/note234.html')) lye neare 
the riuer of the Laurie and haue fishinges therein: the fiue quarters of Lomanah etc. called commonlie Bordonine[235](javascript:footNote('E580000-001/note235.html')) lye vpon the baye of Dounkerran and haue good fishing there.


¶107] {MS folio 38 recto}*Mac Crehons Landes*


The two plowlandes of Kilcrinery and the half plouland of Laharren lyinge in the baronie of Magonny pay yearelie for a Cuddy or refection a beaf val. xiij *s* iiij *d* a hog val. v *s* in money viij *s*, for Dowgollo xxx quirrens of butter and xxxtie sroans of oatmeal a plowland which amounteth to lxxv quirrens of butter and lxxv sroans of oatmeal et val. xxxvij *s* vi *d* and xltie sheaues of otes a plowland which amounteth to C sheaues et val. v *s* str et val. per annum


. . . iii *li* viij *s* x *d* .




---

p.25


¶108] These fiue quarters and half vz. Letter Rinecarah Kilkeuerah, Dagarran[236](javascript:footNote('E580000-001/note236.html')) et Rineardogh, Da[237](javascript:footNote('E580000-001/note237.html')) Kilcomanan et Derin, Ballimanah 
et Killoeh lying in the baronie of Yuragha do yearlie pay for a Cuddy or refection iiij *li* viij *s* viij *d* and in money iiij *s* iiij *d* i. wh. gr., and for Dowgollo of iiij *s* a quarter val. xxij *s* . also vpon a parcel of lande called Caresiuin for a Canebeg xvi *d* ij wh. gr. et val.


. . . v *li* xvi *s* viij *d* .


¶109] These landes haue fishinges in the riuers of Dowglas[238](javascript:footNote('E580000-001/note238.html')) Golin and in the hauen of Bealinche


Somma totalis anualis reddituum harum terrarum val. at


. . . ix *li* v *s* vi *d* .


¶110] [239](javascript:footNote('E580000-001/note239.html'))*0 sulliuans Beares Landes*


The Castle of Bearhauen did pay a Cuddy to thearle[240](javascript:footNote('E580000-001/note240.html')) of Clancartie and all his company for two dayes[241](javascript:footNote('E580000-001/note241.html')) and two nightes once in vij years


. . . Nihill.


¶111] Tenne quarters in the countrye of Bear of Oswiliuans landes paid for a Dowgollo iiij*s* a quarter and an vncertaine Sorren et val.


. . .xl *s* .


¶112] These landes lye by Bearhauen and the Dorses where the xcellent[242](javascript:footNote('E580000-001/note242.html')) fishinges are much haunted by the western men of England.


¶113] ffower quarters of MacFinin duffs landes pay for Dowgollo iiij *s* a quarter and part of an vncertayne Sorren. And these landes ly by the bay Dounkerran[243](javascript:footNote('E580000-001/note243.html')) and the hauen of Ahgrom et val. at


. . . xvi *s* .


¶114] {MS folio 38 verso}*Clanlauras Landes*


ffiue quarters in[244](javascript:footNote('E580000-001/note244.html')) Clanlauras[245](javascript:footNote('E580000-001/note245.html')) pay for a Dowgollo iiij *s* a quarter and an vncertaine Sorren et val. per annum


. . .xx *s* .


¶115] The Sept of Clanlauras were bound to guard the earle of Clancarties cariages when he went in any excursion and for that 
the eldest of that Sept had of dewtie the best dish of meat that was sett before the earle when he was at meat during the Journey.


¶116] *0 Linche Landes*


The iij quarters and half of Couleh Kilkateren and Carechim[246](javascript:footNote('E580000-001/note246.html')) 
lying in the baronie of Bear did yearlie paye a Sorren or in lieu thereof xviij ounzes val. ij *s* ij wh. gr. le oz et val. per annum at


. . .xl *s* .


¶117] *O donogans Land*


The two quarters and half of Carrowdonigan,[247](javascript:footNote('E580000-001/note247.html')) Kilmanneh[248](javascript:footNote('E580000-001/note248.html')) et Knocknegourgal[249](javascript:footNote('E580000-001/note249.html'))
lyinge in the baronie of the beare did yeare[250](javascript:footNote('E580000-001/note250.html')) 
pay a Sorren or in lieu thereof xviij ounces val. ij *s* ij wh, gr. le oz 
et val. per annum at


. . . xl *s*


Somma totalis anualis reddituum 
harum terrarum val. at


. . . vij *li* xvi *s* [251](javascript:footNote('E580000-001/note251.html')).




---

p.26


¶118] *The Priory of Ballinskellig* [252](javascript:footNote('E580000-001/note252.html'))


The Priory of Bellinskellig lying in the baronie of Yuragha did pay the earle of Clancartie for his land yearelie a Sorren which was in the Priors choyce to pay or fiue markes halface[253](javascript:footNote('E580000-001/note253.html')) which is val. per annum at


. . . iiij *li* viij *s* viij *d* [254](javascript:footNote('E580000-001/note254.html'))


¶119] *The Priory of Enisfallen*


The Priory of Enisfallen lyinge in the baronie of Magonny did pay yearelie to the earle of Clancartie a Cuddy or refection or fiue 
markes halface money which was ath[255](javascript:footNote('E580000-001/note255.html')) Priors choyce et val. per annum


. . . iiij *li* viij *s* viij *d* .


¶120] *The Archdeaconrie of Ahado*


The Archdeacon of Ahado in the baronie of Magonny did yeald out of his luinges to the earle of Clancartie a Cuddy or refection or 
fiue markes halface money[256](javascript:footNote('E580000-001/note256.html')) yearlie which was at the Archdeacons[257](javascript:footNote('E580000-001/note257.html')) choice et val. per annum


. . . iiij *li* viij *s* viij *d* .


¶121] *The Abbey of Killaha* The Abbey of Killaha[258](javascript:footNote('E580000-001/note258.html')) in the baronie of Magonny did yeald out of his liuinges to the earle of Clancartie a cuddy or refection or in lieu thereof fiue markes halface, at the Abbotes choice et val.


. . . iiij *li* viij *s* viij *d*


¶122] {MS folio 39 recto}*The Abbey of Ahamore* [259](javascript:footNote('E580000-001/note259.html'))


The Abbey of Ahamore lyinge in the baronie of Dounkerran did yeald out of fiue quarters of land a beafe a quarter et val. at


. . . iij *li* vi *s* viij *d* .


¶123] *The Sorrens of Dowalla* [260](javascript:footNote('E580000-001/note260.html'))


The earle of Clancartie had fower Sorrens dewe yearlie in the country of Dowalla in the countie of Cork for the which when the gentlemen of the countrye were vnwillinge the earle should come vnto them especiallie when victualls were scant, they would compound with his officers and send money in lieu thereof to them: the gentlemen vpon whom the said Sorrens were dewe is Mac Donagh Chief Lord of Dowalla O Kalloghan paide another. Mac Auleif paid the third O Keif paid the fourth and none of them were[261](javascript:footNote('E580000-001/note261.html'))
compounded for vnder vi *li* xiij *s* iiij *d* et val. per annum at


. . . xxvj *li* xiiis iiij *d*


Somma totalis of all the sorrens Cuddies et refections vall.


. . . xlvij *li* xiiij *s* viij *d*


[262](javascript:footNote('E580000-001/note262.html'))Somma totalis omnium Reddituum exeunt[263](javascript:footNote('E580000-001/note263.html')) ex supradictis terris annuatim 
val.[264](javascript:footNote('E580000-001/note264.html'))


. . . cclxvj *li* v *s*.


x*d* ij wh. gr.


Introduction to the Desmond Surveys
-----------------------------------


The surveys which are known as the Desmond and Peyton Surveys were undertaken by commissioners appointed in 1584 to inquire into the lands forfeited as a result of the Desmond 



---

p.27




rebellion. These 
initial surveys were completed by 1585-86 and were a necessary part of the preparatory work for the Munster plantation. The Latin originals, preserved in the Public Record Office, Ireland, were 
destroyed in the Four Courts burning in 1922. In his 1919 guide to the P.R.O.I., under the heading 'Court of Exchequer, Revenue Side, Vice-Treasurer's and Auditor General's Offices', Wood notes 
the surveys thus:


*Survey of attainted and escheated lands, Co. Limerick, 1586.*


Survey of Great and Small Limerick by Christopher Peyton and others under commission of 19 June, 26 Eliz. to enquire into (1) the lands forfeited by the earl of Desmond, (2) the lands of other attained [*Sic*] persons, and (3) the lands of religious houses in that county.


*Desmond Survey, 1586*


This is a survey made under commissions of 19 June, 22 Aug., and 24 Aug.,
26 Elizabeth, taken by inquisition, to enquire into the lands and their value
which had been forfeited by reason of the rebellion of Gerald, late Earl of 
Desmond, his brothers John and James, and James Eustace, earl of Baltinglass, 
or by any other way. The lands affected lay in Cos. Limerick, Kerry, Cork, 
Waterford, Tipperary, Dublin and Kilkenny.[265](javascript:footNote('E580000-001/note265.html'))


If we are to judge from the calendars, the originals must have been very voluminous,[266](javascript:footNote('E580000-001/note266.html')) for we know that the arrangement of the material was detailed and elaborate.[267](javascript:footNote('E580000-001/note267.html')) There survived after 1922 
only a number of calendars and a few fragmentary transcripts and most of this surviving material is being presented in this volume. The documents edited consulted or otherise utilized may be listed as follows


¶1] .M. 5039 P.R.O.I. This is a manuscript calendar in English of Christopher Peyton's Survey of Co. Limerick, which in the original was mostly in the contracted Latin with occasional glosses in English and French.[268](javascript:footNote('E580000-001/note268.html')) Traces of the Latin are retained here and there in the calendar, which was made by the late Mr. M. J. McEnery, who was deputy keeper of records and keeper of state papers from 1914 to 1921. Subsequent to 1922 another member of the P.R.O.I. staff, the late Mr. J. J. Hughes, made a scrupulously exact copy of the
McEnery calendar, and this bears the reference number M. 5039 b.


¶2] .M. 2759 P.R.O.I. This is a pencilled transcript of folios 122 to 143d of Peyton's Survey made by the late Tenison Groves (the Dublin antiquarian and genealogist) and presented by him to the P.R.O.I. It relates to the 'toghes' of Gortcoythe, Kyllydye and Kylheylagh: Groves presumably had a specific reason, perhaps arising out of a genealogical enquiry, for transcribing these particular folios. In view of the destruction of the original material and of its survival only in calendar form, this fifty-five page transcript, made only a few years before 1922, is of special importance as a verbatim copy in contracted Latin of portion of Peyton's Survey and as
preserving the lay-out of the original. The reading difficulties presented by a pencilled manuscript in a not very legible hand were obviated by this editor's fortunate discovery that Groves had had his transcript typed and bound and had presented it in January 1919 to the manuscripts room of Trinity College, Dublin.[269](javascript:footNote('E580000-001/note269.html'))


The Groves transcript reproduces the introductory title of the original Peyton Survey:


*The Book or Survey of the Attainted and Eseheated landes in the Countye of 
Lymeriek in the Provinee of Munster within the Realme of Ireland made in 1586 in the XXVIIth year of the Reign of o[ur] Soveraigne Ladye Queene Elizaheth etc. which came into her Majestie's handes by the Erle of Desmonde, John of Desmonde, and James ffitzmorris warre and others their confederates and 
associates.*


*Chr: Peyton 1586)*


Also reproduced is a rough index to the section transcribed, under three headings— *Nomina Villarum* (that is, the place-names), *Nomina Boscar in quibus existit maeremio* and *Nomina Tenencium Comiti Desmon. ptinen tma. libor. qm. Custumar*. There follows, in wording and format,



---

p.28




 a reproduction of folios 122 to 143d, each
successive folio, recto or dorso, being represented by a sheet of the transcript. Headings of the subject matter are marginal and vertical, in the contemporary fashion, rather than horizontal. Thus
the freeholder or tenant whose lands are being described is mentioned in an outer left-hand marginal heading while inner left-hand headings note the particular land denominations as well as descriptions 
of woods or minerals. Right-hand headings give the areas—in acres or quarters—of the lands being described.


We reproduce here folio 122-122d, as it appears in the Groves transcript, and it should be compared with its calendared abstract, section 187 of the printed text.


Matter for folios 114 & 115 (ms f. 122 and f. 122d) to follow


A detailed collation of the whole Groves transcript with the relevant sections of M. 5039 (sections 187-201 of our printed text) confirms what the reader will have gathered from a sample comparison—that the McEnery calendar faithfully abstracts the original Peyton Survey. The considerable repetition of the original is avoided while all essential information is preserved. Name-forms as well as money and land figures are meticulously copied. Occasional explanatory comment is kept to a minimum and is always helpful. At the same time order and clarity are not lost in the process of 
abbreviation. The admirable compression of the calendarist is illustrated by the fact that the information contained in over forty folios (recto and dorso) of the original is covered in some eleven 
foolscap pages of the calendar.


Apart from indicating the format of the destroyed original, the Groves transcript demonstrates the comprehensiveness and reliability of M. 5039 as a calendar of Peyton's Survey. Similarly, we 
are justified in assuming that M. 5038 (see below) is accurate and reliable in the same degree. As far as Co. Limerick is concerned, then, the loss of the original material is by no means irreparable.


¶3] .M. 5038 P.R.O.I. Like M. 5039, this is a manuscript calendar in English of the Co. Limerick portion of the Desmond Survey of 1586, the Latin original of which was destroyed in 1922. Again, the calendarist is M. J. McEnery, and a copy (M. 5038 b) of the calendar was made by J. J. Hughes.


¶4] . M. 5037 P.R.O.I. This is one of about a dozen[270](javascript:footNote('E580000-001/note270.html')) privately copies of a thirty-three page calendar in English of the Co. Kerry portion of the Desmond Survey. Manuscript notes on the P.R.O.I.
copy inform us that the calendar was privately printed for Samuel Murray Hussey[271](javascript:footNote('E580000-001/note271.html')) who gave a copy to James F. Fuller, M.R.I.A.,
who in turn presented it to the P.R.O.I. in January 1923[272](javascript:footNote('E580000-001/note272.html')) (i.e., after
the destruction of the original material). There are also some notes in the handwriting of the late Mgr. Alfred O'Rahilly who in the early 1930s was considering the possibility of a new edition of
Smith's History of Kerry. Rev. Sir H. L. L. Denny, in his Handbook of the County Kerry Family History, Biography etc. (1923), p. 11,
refers to the 'survey of the estates of the sixteenth Earl of Desmond privately printed by Hennessy: copy with notes by S. M. Hussey in possession of Col. E. Nash'. W. M. Hennessy was a well-known
Kerry antiquarian: the whereabouts of Col. Nash's copy and the nature of the 'notes' remain to be investigated.


The 'Kerry Desmond Survey' (if we may conveniently call it that) begins by listing the rents issuing out of the lands of various free tenants in Corkaguiney barony, as well as the money value of 
the obligatory supply of victuals and lodgings to retainers and servants of the earl of Desmond on his periodical visits. Also listed are the earl's custom dues out of imports and exports, fishings and 
shipwrecks. The gross total of the barony's revenue is then given. There follow similar returns for other north Kerry baronies.


From 13 August to 15 October 1927, the Kerryman serialized 
the Kerry Desmond Survey calendar. The series was prefaced by the statement that 'the subjoined is a copy of the translation [Sic] of the Desmond Survey, the original of which perished in the destruction of the Public Record Office, Four Courts, Dublin. It was kindly forwarded to us for publication by Mr. M. J. Byrne, solicitor, Listowel.' Apart from his law practice, the late Matthew J. Byrne was one of a dedicated group of Kerry local historians in the early years of this century. To those interested in the Kerry Desmond 



---

p.29




Survey, it should be pointed out that the Kerryman serialization, though generally identical with M. 5037, leaves out a number of sentences, transposes substantial sections and omits altogether a portion corresponding to pp. 21-5 of M. 5037. A curious feature of both versions is a number of what seem to be superscript numerals for footnotes, possibly as comments on place-names. If these notes did exist, correspondence with the Kerryman, the late Mgr. O'Rahilly and the representatives of the late Mr. Byrne failed to reveal any trace of their whereabouts.[273](javascript:footNote('E580000-001/note273.html'))


¶5] . A fragment of the original Desmond Survey survives in the form of a two-page Latin transcript dealing with the manor of Kilcolman (mod. Kilcolman East, Middle and West: Doneraile 
par. Co. Cork) which is preserved in the P.R.O.I. Certified as authentic in May 1874 by the then assistant deputy keeper of the records, J. J. Digges La Touche, it is described as a portion 'of a 
Record in the Public Record Office of Ireland entitled "Desmond Survey Roll", Auditor General's Department'. There is also a copy in the library of the Royal Society of Antiquaries of Ireland.


Of the documents listed above, M. 5038 and M. 5039 are here edited in full. Despite some duplication and overlapping,[274](javascript:footNote('E580000-001/note274.html')) it 
seemed to the editor that the historical importance of the calendars warranted the publication of both in full, and the commission readily agreed. As for M. 5037, it could be argued that it is already 
available (albeit in a very limited private edition) and that the material it contains may also be found in the Kerryman files. In some respects, however, M. 5037 is an unsatisfactory document—it seems to have been hastily prepared and printed—and a critical 
edition is clearly called for. Its place-names need to be investigated and as far as possible identified,[275](javascript:footNote('E580000-001/note275.html')) and its precise relation to the 
'Desmond Inquisition' established.[276](javascript:footNote('E580000-001/note276.html')) When the present editor had completed some preliminary work on the Kerry Desmond Survey, it became clear to him that to attempt this additional task would be to protract impossibly the publication of this volume, already long overdue. But he cannot sufficiently stress the importance of making available this valuable sixteenth-century source in properly edited form.[277](javascript:footNote('E580000-001/note277.html'))


By a royal commission dated 19 June 1584 Sir Henry Wallop, Sir Valentine Browne, Thomas Jenison,[278](javascript:footNote('E580000-001/note278.html')) Launcelot Alford and Christopher Peyton were appointed 'to inquire by the oaths of good and lawful men' into the lands which were forfeit to the crown as a result of the Desmond rebellion, and to return 'the clear yearly value of the premises and who receives the issues and profits'.[279](javascript:footNote('E580000-001/note279.html')) The new lord deputy, Sir John Perrott, was empowered to appoint additional or substitute commissioners, and by late August 'since Thomas Jenison . . . is aficted with disease so that he is unable to act. . ., Thomas Wyseman and Arthur Robins gents' were added to the original panel.[280](javascript:footNote('E580000-001/note280.html')) As well as the general commission, a special group seems to have been concerned with lands in the counties of Waterford, Limerick, Cork, Kerry and Cross Tipperary. This group comprised Nicholas Walshe, chief 
justice of Munster; John Meagh, second justice of Munster; Thomas Wyseman; James Gowle; Robert Rosier, and Arthur Robins 'and any three of them who shall be named by Henry Wallop and Valentine Browne.'[281](javascript:footNote('E580000-001/note281.html'))


Not until late August 1584 was the final composition of the 'surveyors' determined and the work begun.[282](javascript:footNote('E580000-001/note282.html')) The commissioners could expect favourable conditions: 'a man may now travel the whole country and none to molest him,' wrote the sheriff of Co. Cork, Sir William Stanley, to Walsingham in September 1584.[283](javascript:footNote('E580000-001/note283.html')) 
The work was commenced in Tipperary which however had to be left partially unsurveyed as the earl of Ormonde had seized a considerable portion of the escheated lands which the local people were afraid to point out.[284](javascript:footNote('E580000-001/note284.html')) From Tipperary, the commissioners proceeded into Limerick where Wallop expressed his satisfaction that so much fertile land had become forfeit. In mid-September, the survey party was in north Kerry where much of the land was noted as being good arable and pasture, though not as fertile as 
Limerick. From Dingle the commissioners went northwards, skirting the Shannon estuary and moving back into Limerick by mid-October. They took a well-deserved rest at Askeaton before continuing their labours in Cork and Waterford. From Cork in late November they were forced by weather conditions to return to Dublin, there to complete the survey.




---

p.30


In spite of the 'pacification' of Munster, the journey had not been easy going. Indeed the very devastation of the province (which made a forcible impression on the commissioners) presented its own 
difficulties. The weather was 'extreme foul' and the roads and tracks through woods and over mountain were tedious and dangerous. Alford as well as many of the servants were struck down by fever, old Sir Valentine Browne was nearly drowned on two occasions and his son suffered a broken arm. Several horses were lost in the course of the journey. Provisions were scarce and dear, one hundred persons had to be fed at the commissioners' table and Burghley was being asked for more money. The sullen resentment 
of many of the inhabitants had also to be contended with. Yet the over-all reaction of the surveying party was one of jubilation that such extensive and fertile lands were being found for the crown, 
though this feeling was tempered somewhat by anxiety about Irish claims to land.[285](javascript:footNote('E580000-001/note285.html')) Naturally the surveyors were concerned to secure their own share of the pickings. Wallop was well aware that 'there are many suitors at court for the best things here' and wished to have an estate reserved for himself in the Knockainy-Lough Gur district of Co. Limerick.[286](javascript:footNote('E580000-001/note286.html'))


Norreys, the lord president of Munster, summed up for Burghley: 'The commissioners find the country generally so wasted and dispeopled in all parts that small hope appeareth in many years to inhabit the same and those also which remain very loosely disposed through the licentiousness of rebellion whom of themselves being evil this late enquiry which they see made of their lands hath much worse affected: nevertheless their weakness and last extremity is such that they are altogether unable to do any hurt however evil minds they bear.[287](javascript:footNote('E580000-001/note287.html'))


On 28 November 1584 the commissioners returned to Dublin from Munster[288](javascript:footNote('E580000-001/note288.html')) but almost a year was to pass before the survey was completed. As Dunlop points out,[289](javascript:footNote('E580000-001/note289.html')) delay at this early stage was harmful to the progress of the plantation. In January 1585 Walsingham informed Wallop that the queen would not dispose of any 
of the escheated lands before the survey became available.[290](javascript:footNote('E580000-001/note290.html')) It was early October before Wallop informed Burghley of the delivery of the record of the survey to the lord deputy, Wallop 
admitting that it was roughly and imperfectly done.[291](javascript:footNote('E580000-001/note291.html')) Perrot was not very enthusiastic about the plantation proposals[292](javascript:footNote('E580000-001/note292.html')) and, in a letter to Burghley in April 1586, Wallop defended the commission 
of survey against the lord deputy's criticism. The letter reveals something of the commission's methods of inquiry:


‘His Lordship hath always seemed to make light of our travails that were commissioners for the surveying of the lands in Munster, saying it would come to little or nothing, but now of late to discredit our service the more he hath often spoke it openly, that all we did was by a beggarly sergeant and that without him, we could have done nothing, by whom he meaneth a man, who had been under 
officer for the late Earl of Desmond by that name of a sergeant in Connello, and in some other part of the county of Limerick, the greatest part whereof we had surveyed before he came to us: he was perfect 
and ready to tell us the names of the places and persons who had been in rebellion in all those quarters, where his instructions indeed furthered greatly our travail and the service, but in the counties of Cork, Kerry, Waterford and the Cross of Tipperary he could say nothing. And if he had been as perfect in all them as in the other, yet I hope Her Majesty nor your Lordship will not be 
persuaded or judge that the substance of all our service and travail consisted only upon his report and declaration . . .[293](javascript:footNote('E580000-001/note293.html'))’


Christopher Peyton also reminded Burghley of the difficulties of making a survey of lands belonging to people long since dead and situated where there was no one to tell the name of the place, the 
last owner or the value of the land.[294](javascript:footNote('E580000-001/note294.html')) Solicitor-General Roger Wilbraham was willing to make allowances for a survey 'done by the information of the serjeants for the most part, as I am told by those were in the service, so as it is but conjectural and yet the service of those commissioners very effective, and available to Her Majesty, but error is incident [to] all general services'.[295](javascript:footNote('E580000-001/note295.html')) And Walsingham assured Wallop of his own satisfaction (though this was before the completion of the survey): ‘Touching the survey of the escheated lands in Munster, I do verily think that none of these that have been made heretofore, have been performed with like sincerity and 



---

p.31




sound meaning, towards Her Majesty's profit, for I know that some of the former have been made to serve rather private men's turns than the advantage of the crown . . .’[296](javascript:footNote('E580000-001/note296.html'))


The survey enabled the government to estimate approximately the amount of land at its disposal and so to proceed with the drafting of a provisional scheme for the peopling of Munster. Yet within 
a short time it became clear that the survey was imperfect and incomplete—it frequently refers, for example, to lands not yet surveyed. When Secretary Fenton was sent to Ireland with the 
scheme for re-peopling Munster in November 1585, his instructions were that the original survey was not sufficiently thorough and he was therefore to see to it that the lord deputy and council should 
'appoint meet persons to survey the same as near as may be, according to the plot aforesaid with respect as well as of the goodness as of the quantity of the ground'.[297](javascript:footNote('E580000-001/note297.html')) But by June 1586 Fenton was 
reporting to Burghley that 'no commissioners have been as yet sent from hence [Dublin] into Munster to perfect the survey of the escheated lands and to compound with the intermixtors.'[298](javascript:footNote('E580000-001/note298.html'))


The commissioners who had been appointed in August 1586 'for the dividing and bounding into seignories Her Majesty's attainted, escheated or concealed lands within the Province of 
Munster'[299](javascript:footNote('E580000-001/note299.html')) soon found that 'very many of the offices upon Mr. Treasurer [Wallop] and Sir Valentine Browne's surveys, which should have entitled her Majesty, for want of law skill therein are defective in matter, as not declaring what offence the offenders 
committed—either felony or treason;—or of what estate the offenders were seized either for life or in fee, and such like blemishes to disable the offices, which many of them I doubt are incurable, we thought good to procure here another new commission besides to the persons named to be surveyors in England, to inquire of all attainted and forfeited lands which we did execute and found 
divers offices at Dungarvan and Youghal whilst they measured there and so did dispatch both businesses as near as we could with one charge and labour.[300](javascript:footNote('E580000-001/note300.html'))


Dunlop has remarked on the contrast between the sophisticated paper planning for the Munster plantation and the slipshod nature of the arrangements in practice. The plantation, says Quinn, 'is 
an excellent example of the ideas of a sixteenth century government outrunning its capacity for performance'.[301](javascript:footNote('E580000-001/note301.html')) The Desmond survey 
exemplifies—in its imperfections, in the delay in its completion and in the difficulties to which it subsequently gave rise—the unsatisfactory nature of the arrangements for the plantation as a 
whole. Despite its documentary value, the survey comes within Spenser's general censure: 'Some think that the first plot was not well instituted nor grounded upon sound advertisement and knowledge of the country . . .'[302](javascript:footNote('E580000-001/note302.html'))


Peyton's Survey, dealing with Co. Limerick only, was a separate report[303](javascript:footNote('E580000-001/note303.html')) but arose out of the same general commission[304](javascript:footNote('E580000-001/note304.html')) as the Desmond Survey. Though the introduction to the survey states that it was drawn up by 'Christopher Peyton and other commissioners',[305](javascript:footNote('E580000-001/note305.html')) it is clear that Peyton was the real compiler. His diligence in the work of surveying was commented on by Perrot[306](javascript:footNote('E580000-001/note306.html')) and, as we have seen, Peyton himself wrote to Burghley on the 
difficulty of the task.[307](javascript:footNote('E580000-001/note307.html')) In May 1585 Peyton asked Burghley whether he should remain in Ireland and proceed with other surveys or return to England in July with Sir Valentine Browne.[308](javascript:footNote('E580000-001/note308.html')) As far back as 1581, Peyton had been interested in succeeding the ailing Thomas Jenison as auditor of Ireland.[309](javascript:footNote('E580000-001/note309.html')) Clearly, 'his diligence in the late surveys'[310](javascript:footNote('E580000-001/note310.html')) would help to recommend him to Walsingham and Burghley, so that we may partly attribute the existence of a separate Peyton Survey to personal ambition. When Jenison died, the favour 
Peyton sought was granted, in November 1587 (by which time he had done more work on Munster surveys) and he expressed his thanks to Burghley.[311](javascript:footNote('E580000-001/note311.html')) It is worth noting that Peyton was involved on Perrot's side in the latter's dispute with Wallop.[312](javascript:footNote('E580000-001/note312.html'))


On 28 April 1586 Peyton informed Burghley that he had sent by the bearer a book of survey of all the attainted and escheated lands in the small and great county of Limerick, with an index at the 
beginning of the book.[313](javascript:footNote('E580000-001/note313.html')) It seems then that Peyton's Survey was 
not completed until some six 



---

p.32




months after the Desmond Survey. On 12 July 1586 Peyton asked Burghley to confirm that he had in fact received his previous letters and 'the book I sent unto your Lordship of the great and small county of Limerick whether your Lordship have received them or not and what your Lordship's pleasure is for the rest of the counties. I remain here, I know not how, until I have some direction from your Lordship, either for the survey, or for the auditor's place, or for the treasurer's reckoning.' It is evident from the rest of the letter that Peyton was dissatisfied with his position in the Irish civil service. Like many of his colleagues, he wanted a share in the confiscated lands— 'the preferment of the castle and lands of Mucrus court in the great county of Limerick which he had already begun to inhabit'.[314](javascript:footNote('E580000-001/note314.html'))


The most obvious difference between the Desmond and Peyton Surveys[315](javascript:footNote('E580000-001/note315.html')) was that the latter was confined to the forfeited lands in Co. Limerick whereas the former covered lands in counties Limerick (calendared in M. 5038), Kerry (M. 5037), Cork, 
Waterford, Tipperary, Dublin and Kilkenny. Even in its surviving calendar form, something of the wider scope of the original is retained since M. 5038 mentions a relatively small number of 
manors, lands and tenements, including religious houses, in counties Clare, Cork, Kerry, Tipperary and Waterford.[316](javascript:footNote('E580000-001/note316.html'))


M. 5038 altogether lacks the lengthy prefatory material found in M. 5039. This includes sections on the question of land measurements, the various divisions of Ireland and an annalistic prophecy.[317](javascript:footNote('E580000-001/note317.html')) Another section contains detailed instructions (not found in M. 
5038) for the commissioners of survey[318](javascript:footNote('E580000-001/note318.html')) while Peyton's Survey is 
concluded by an appendix entitled 'The Plot from England for inhabiting and peopling of Mounster'.[319](javascript:footNote('E580000-001/note319.html'))


To a large extent M. 5038 and M. 5039 deal with the same material but do so in different ways. Indeed, they are complementary rather than overlapping. In the case of the lands of Pierce Oge 
Lacy of Bruff, for example, Peyton's Survey gives us details about the 'ruinous castle', the presence of timber, the wasted condition of the lands and the various sub-denominations.[320](javascript:footNote('E580000-001/note320.html')) The Desmond Survey, on the other hand, though naming only the principal 
denomination (Doroglogh: mod. Durraclogh, Ballingarry par.) gives the valuation arrived at by the commissioners in money, victuals and provisions.[321](javascript:footNote('E580000-001/note321.html')) Again, the detailed description of Lough Gur castle in M. 5038 (sect. 388) is not found in M. 5039 
(sects. 21, 22) though the latter specifies the constituent denominations and mentions that Sir George Bourchier was in possession of the manor. Information on the fair at Knockainy in M. 5039 (sect. 16) 
is not found in M. 5038. Contrast also the information on Glenogra in the two surveys (sects. 17, 389). John Oge McRuddery, the White Knight, is mentioned only in passing in M. 5038 (sects. 444, 696): 
his lands in Limerick are detailed in M. 5039 (sects. 321, 323). In general, Peyton's Survey is more detailed with more information on subdenominations and natural features, while rentals and valuations 
are supplied in the Desmond Survey. Identification of place-names is more difficult in M. 5038, as there are lengthy sections without 'toghe' or barony headings where no parish is mentioned.


Finally it may be noted that whereas the original foliation is noted on the margin throughout M. 5038 it stops completely in M. 5039 at section 156 (f. 102d). Again, marginal headings (placenames, woods, etc.) disappear half way through M. 5039 but these are in any case superfluous since they simply repeat (sometimes with different spellings) the names given in the text.


The student of the Munster plantation would do well to take note of some contemporary maps.[322](javascript:footNote('E580000-001/note322.html')) We have no detailed map of preplantation Munster. 'A single draught of Mounster' [?1572] attributed to Robert Lythe is clearly drawn but too general.[323](javascript:footNote('E580000-001/note323.html')) The post-plantation maps are more rewarding. A large scale Munster map of 17 June 1586 shows the attainted lands with the names of the undertakers, but in no great detail.[324](javascript:footNote('E580000-001/note324.html')) An informative if somewhat inaccurate map is that of Co. Limerick in 1587 drawn by Francis Jobson, with a fretwork cartouche enclosing a description of the lands surveyed and the method of survey.[325](javascript:footNote('E580000-001/note325.html')) But perhaps the best—known plantation map is Francis Jobson's 'The Provence of 
Munster', 1589.[326](javascript:footNote('E580000-001/note326.html')) Jobson was one of the four surveyors



---

p.33




 employed in measuring the confiscated lands, the others being Robins, 
Lawson and Whiteacre. On the margin of the map is a letter from Jobson to Burghley in which the cartographer states that he spent nearly three years surveying and measuring the escheated lands in 
Munster, having been appointed by Wallop, Browne and the other commissioners of survey. The map is overcrowded and, in general, in-elegantly executed (indeed Jobson admits its limitations) but is valuable in that it shows the location and size of the seignories. This is the map referred to by W. H. Hardinge in his R.I.A. paper in December 1861. Hardinge was concerned to verify that mapped 
surveys had accompanied the inquisitions and books of surveys, and he regarded the 1589 map as 'a reduction by Jobson from the townland surveys, made in pursuance of the' commission dated 
19 June, 26 Eliz.[327](javascript:footNote('E580000-001/note327.html'))


In conclusion, a word may be said about the historical importance of the Desmond and Peyton Surveys, even in their surviving calendar form. The indicate, for example, the continuity of Gaelic social and territorial organization within what was in name at least an Old English lordship. At the same time, the fiscal and economic structure of that lordship is revealed through the nature of the rents and services payable to the earl of Desmond. The surveys also serve to emphasize and particularize the havoc wrought by the Desmond wars since they refer frequently to devastated lands and ruined buildings. They furnish evidence on the degree of complicity of the various freeholders in the rebellion. As in the case of the Clancarthy Survey, there is much important information of a topographical nature throughout and the surveys are of importance for the study of place-names. Their interest is further enhanced by the details furnished on fisheries, mines and woods, as well as on traditional units of areas, weights and measures and by the information that can be deduced on contemporary prices of livestock and foodstuffs.


In making a detailed return of land ownership and occupation, the commissioners were not only carrying out essential preparatory work for the Munster plantation but unwittingly creating a valuable source for Munster history. Taken together with the maps referred to above, the Elizabethan fiants,[328](javascript:footNote('E580000-001/note328.html')) the various reports on the plantation up to 1622, the Civil Survey,[329](javascript:footNote('E580000-001/note329.html')) the Down Survey parish and barony maps,[330](javascript:footNote('E580000-001/note330.html')) the Books of Survey and Distribution,[331](javascript:footNote('E580000-001/note331.html')) and the 1659 'Census',[332](javascript:footNote('E580000-001/note332.html')) the Desmond and Peyton Surveys will enable us to trace further the great changes in land ownership for these areas 
from the Desmond rebellion to the Williamite confiscation.


My thanks are due to Miss Margaret Griffith, deputy keeper, P.R.O.I., for her readiness in making the calendars available and to Professor Seamus Pender, Diarmuid O Murchadha, and Doncha Ó Conchúir for their suggestions on the identification of certain place-names in counties Waterford, Cork and Kerry respectively.


II The Peyton and Desmond Surveys
---------------------------------


### P.R.O.I. M. 5039

### Peyton's Survey


¶1] Survey of attainted and escheated lands in co. Limerick which came to the hands of Queen Elizabeth by the wars of the Earl of Desmond, John of Desmonde and James ffitz Morris made in 
the year 1586 a.r. xxvii Eliz.[333](javascript:footNote('E580000-001/note333.html'))


¶2] Survey of attainted and escheated lands in the Great and Small County of Limerick divided into three parts viz the Earl of Desmond's lands (Terre comitis), land of divers persons attainted and lands of divers religious houses: all said lands are reduced to quarters or ploughlands set in their right division and allocated to their rightful owners as before the time of the rebellion.


The Survey was compiled by Christopher Peyton and other commissioners appointed by commission hereafter mentioned.




---

p.34


¶1] Survey of attainted and escheated lands in co. Limerick which came to the hands of Queen Elizabeth by the wars of the Earl of Desmond, John of Desmonde and James ffitz Morris made in 
the year 1586 a.r. xxvii Eliz.[334](javascript:footNote('E580000-001/note334.html')) bearing date at Westminster 19 June a.r. xxvi Eliz. Only such lands as belonged to Rebels dead slain in rebellion or executed by martial law are included as such are accounted of the nature of attainted lands. Lands of rebels yet alive, some pardoned and others not, are not included, as they may still expect grace and favor and especially as they have not been attainted.


¶3] There is a great difference in the measures of the Great and Small County adjoining to the judgment formed in their first western journey[335](javascript:footNote('E580000-001/note335.html')) into Mounster in the year 1584 annis xxvi and xxvii Eliz. by Sir Henrie Walloppe knight vice treasurer of Ireland, Sir Valentyne Browne knight and others Her Majesties Commissioners. It was found with great probability that a ploughland contains in some parts of the Great County 80 acres, and in other
parts 120: in Connelo it contains 80 acres, but in Poblebryen,[336](javascript:footNote('E580000-001/note336.html')) Clanwilliam the two Kenryes,[337](javascript:footNote('E580000-001/note337.html')) Cosmaye and mcBryan Ogonaghte
120 acres. In the small county every acre there is equal to 7 acres of the Great County and 20 acres make the ploughland there.


Whatever be the content of the ploughland only arable land is taken into account and neither in the Great or Small County are meadow pasture, woods, bogs, mountains or wastes included in estimating the ploughland.


It is not possible to arrive at greater certainty as to the acres unless 'the Lyne be layde over everie villadge hamlett and parcell' and the matter must be left to further consideration and time.[338](javascript:footNote('E580000-001/note338.html'))


¶4] An Ancient Book of the description of Ireland lately come to my hands (Chr: Peyton?) which touchs the measure of plouglands througout Ireland. 'And because I fynde yt written and sett downe longe agoe I accoumpte of yt a better probabyllytie of a trewthe than anye probable proofe shewed in the said Western Iourney or at anie tyme before or since that I can learn of viz:—


Ireland is 400 miles in length from Knockbrannan in the south, which is north west of Saincte Michellsmounte in Cornewall, unto Saincte Collmans Ilande alias the Curraghe in the north of Ulster which is west of Donfryse in Scotlande; and it is 200 miles in breadth from Dublin, which is south west of Chester, unto Crogh Patricke west of Gallwaye in Connaughte. This is proved by divers charts, so that Ireland should be more than England by 80 miles as on the south it is west of Saincte Michellsmounte which is in the western part of Cornewall and on the north it is west of Donfryse in Scotland.


Ireland is divided into 5 great portions according to the old extent viz. Leynster, Mounster, Connaghte, Mythe and Ulster.


Leynster contains 5 shires Kyllkenny, Wexforde Carlaghe, Kylldare and Dublin.


Mounster contains Ormonde, Desmonde and Thoomonde and 5 shires Waterford, Tipperare, Corcke, Lymericke and Kerry.


Connaghte contains 5 shires and Ulster 5 shires.


The portions above written are of the King's inheritance as lord of Ireland in substance besides the title of the crown that is to say the earldom of Ulster, whole lord of all Connaghte, lord of Mythe, lord of the fourth part of all Leinster and lord of the fourth part of Munster.


The said 5 portions contain 184 canthreds, otherwise called hundreds or baronies viz. Leinster 31, Connaught 30, Munster 70, Meath 18 and Ulster 35.


Ireland contains 5495 towns viz:— Leinster 930, Connaught 900, Munster 2100, Ulster 1050, and Meath 515.


Every canthred contains 160 plouglands, every town contains 8 ploughlands of arable land besides



---

p.35




the pasture of 300 cows and none of them shall anhere to the other.


The sum of the arable ploughlands is 53,080, besides rivers meadows pastures hills and woods.


Every ploughland contains 120 acres each containing 4 roods or perches in breadth and 40 perches in length. Every perch contains 12 feet of Powles feet and there are 3 feet in a yard.


If Ireland were reconciled to the king as England is and inhabited by Englishmen the King ought to have yearly, at 6s. 8d. per plougland, 22l. and 40 marks of common subsidy, the customs havens ports and fishings of old 1000 marks yearly; the rent of the old inheritance of the 5 provinces which was 22000 marks in the old Earl of Marche's days, and all other things as advowsons of churches wards marriages, &c;


¶5] Pythagoras knew that the space where the Olympic games were kept was measured by Hercules who laid down a furlong there of 625 of his own feet. Comparing this with the similar furlongs laid down
by his successors he discovered how much the foot of Hercules was greater than theirs, and computing the entire stature of Hercules from his statues according to his length of foot he knew how much 
the stature of Hercules exceeded that of the others.


¶6] A prophecy concerning the state of Ireland as found by master Walter de Istelep on investigating the Irish Annals in 1317.


Now the Irish had four prophets Moling Breacan Patrick and Colmekyll whose books written in Irish are still extant among the Irish: all speaking of this conquest declare that from frequent conflicts and protracted struggle it shall be sullied by many murders through many future ages but they foretell (compromittunt) complete victory to the English people a very short time before the Day of Judgment; that the island of Ireland from sea to sea shall be totally subdued and built on with castles; that before that the English people shall be many times confounded and weakened by the issues of war in the island as is found in the testimony of Bractan, and that nearly all the English in Ireland will be confounded by a certain King who shall come out of the desert mountains of Patrick and break down a certain castle in the woods of Ophelay on a Sunday night [yet], by their assertion, they will always hold the eastern shore of the island withoug interruption.


¶7] Ireland contains 180 canthreds thus divided


Leinster contains 31 canthreds 930 towns.
  

Connaught contains 21 [339](javascript:footNote('E580000-001/note339.html')) canthreds 900 towns.
  

Munster contains 70 canthreds containing 2100 towns.
  

Ulster contains 35 canthreds containing 1050 towns.
  

Meath contains 18 canthreds 515 towns.
  

Sum of the towns in Ireland 5495.
  



Every canthred contains 30 villates, every villate can sustain 300 cows in pasture and the cows are divided into 4 herds so that none of them can approach the other: [the remainder of][340](javascript:footNote('E580000-001/note340.html'))Every vill will sustain 8 ploughs. This is the description of Ireland as the old books describe the land.


*Ireland.*


The province of Momonia or Mounster consists of the following divisions


*Sowthe Mounster containing*


Countie Kyrrey beinge the County palatine belonging to the Earl of Desmond and Desmonde alias Desmowe in the county of Kyrrey called Desmoo.


*Northe Mounster containing*


County Clare and is called Tomond alias Tomow of late annexed to the government of Conno accompted as no parcell of Munster[341](javascript:footNote('E580000-001/note341.html')) in Irish Tomow.




---

p.36


*Mydle Mounster containing*


Great and small county of Limerick, county Waterford and most of the County Cork in Irish called Mowmeanaugh.


*West Mounster containing*


County Corck and part of Co. Kerry from Castlemaign to the Shannon wherein is Dowalls in co. Corck and Clanmorris in co. Kerry.


*East Mounster containing*


Co. Tipperary and Crosse Tipperary[342](javascript:footNote('E580000-001/note342.html')) being the county Palantine[343](javascript:footNote('E580000-001/note343.html')) of the Lorde of Ormonde in Irish called Ormow.


¶8] Names of the countries wherein lie the lands of attainted persons in co. Limerick viz:— Great County, Small County, Clanwilliam, Poblebryen, Connelo, Kenrey moore, Cossetle Reo, Cosmaye, Kenry Lurragh,[344](javascript:footNote('E580000-001/note344.html')) Gonaght mcBryen, Woney Omulryan, OBryen Arrey, Clenlesse[345](javascript:footNote('E580000-001/note345.html')) with an index thereto.


Table of Contents; Index of towns; Index of woods containing timber; Index of religious houses concealed in co. Limerick; Index of tenants free as well as customary of the Earl of Desmond; Index of divers traitors attainted with the contents of the lands held by them.


Sum of the lands of the Earl of Desmond and all other traitors attainted in the Great and small County of Limerick 585[346](javascript:footNote('E580000-001/note346.html')) quarters, 15 acres, 1 rood.


¶9] {MS folio 1}Extent of all and singular the honors lordships manors castles lands &c in Munster which came to the hand of Queen Elizabeth as well by reason of the attainder of James ffitz Gerralde otherwise called James ffitz Garrett late Earl of Desmond as of divers other persons attainted and convicted by virtue of an act of parliament held on [*...*] [347](javascript:footNote('E580000-001/note347.html')) at the town of [*...*][348](javascript:footNote('E580000-001/note348.html')) in the county of the city of Dublin a. r. xxviii Eliz. 158—;[349](javascript:footNote('E580000-001/note349.html')) and of divers other lands escheated there concealed from the Queen; made by Sir Henry Walloppe, knight, Sir Valentine Browne knight, Thomas lenyson Lancillott Alforde and Christopher Peyton esquires the commissioners mentioned in the following commission and by virtue thereof:—


Queen Elizabeth appoints &c as in Desmond Survey f1. d.[350](javascript:footNote('E580000-001/note350.html'))


By authority of said Commission and as directed therein, Thomas Wyseman and Arthur Robyns gents were appointed commissioners in addition to said five commissioners by letters patent under the Great Seal of Ireland bearing date 24 Aug, a. r. xxvi. Eliz as follows


Queen Elizabeth recites &c as in Desmond Survey f2.d.s[351](javascript:footNote('E580000-001/note351.html'))


¶10] *May 27 1584* Instructions[352](javascript:footNote('E580000-001/note352.html')) for Sir Henrye Walloppe knight, under treasurer, and treasurer of Wars in Ireland, Sir Valentine Browne knight and the rest of the Commissioners appointed to survey the lands of such as have been in rebellion within the last four years in Ireland and have no lawful pardons for their lands.


Imprimis to enquire who were the occupiers of any lands reputed to have belonged to rebels and what estate they have whether by lease or at will.


Item what parishes towns baronies and shires they lie in.


Item what profits of victuals, money rents, corporal services or otherwise they yielded, what was the value of the victuals or services yearly, in what way the tenants commonly were burthened with coynie and Lyverie, Cossherie, Cuddye or such exactions and what ordinary charge they had yearly or quarterly of Galloglasse.


Item to inquire by estimation the quantity of the lands occupied, in ploughlands or acres and in cases doubtful of estimation to measure the tillage meadow and pasture: how much was used for tillage pasture and feeding and how much was accounted waste and bog.




---

p.37


Item how many ploughs the tenants used, how many servants and garrans they used for the ploughs, how much corn grew therefrom in common years, of what kinds, how did they sell any spare corn and for what price.


Item how many cattle and beasts of all kinds were maintained in time of peace as horses mares, studderie, kyne, sheep, hogs, goats and the like.


Item what woods[353](javascript:footNote('E580000-001/note353.html')) of timber and other underwoods are on said lands and how near they lie to any sea port or navigable river.


Item what minerals are on said lands, whether they have been proved and what was the result.


Item how many people the tenants commonly kept in their households with meat and drink.


Item to describe the situation of the lands, and the castles or houses of strength with their lands, how they abut and bound, and upon whose lands; and to consult what castles or houses of strength 
should be reserved to the Queen either in respect of their situations for the government of the country and those to be in the custody of constables with reservation of victuals for the maintenance of 
the guard.


Item if the castles or houses be decayed to inquire how long they have been so and by whom and by what means they have been decayed or defaced and whether it is necessary to have them repaired and with what charge they may be made tenantable against soldiers.


Item to inquire of all Liberties and Royalties belonging to said castles seignories or manors, the services due by any other to same, and how such liberties have been granted; and although all liberties 
commonly are by misusage in subject's hands hurtful to the common weal yet to inquire whether the Queen may not do well to revive liberties of leets or law days without continuing the power to return writs or have the goods of felons or wrecks or the like.


Item to inquire what patronage of college parsonage or vicarage belonged to any rebel with the value thereof and who are incumbents or otherwise how the profits thereof are bestowed or used.


Item to measure the demesnes in the actual occupation of the rebels themselves and in their own manurance without taking yearly rents or profits therefrom; to reduce the acres to ploughlands according to the custom of the country; to value the acres rat [*...*][354](javascript:footNote('E580000-001/note354.html')) according to the local perch, since the measure of the perch is different in different places and so causes a difference in the quantity of acres and ploughlands, great consideration is necessary in valuing the lands to assess yearly rents.


Item to consider where the Queen grants the lands to her good subjects with reservation of rents, for years or three lives, or in special fee tail, it is to be remembered that for the first 5 or 7 years the rents should be small but to increase somewhat more at 10 or 14 years.


Item to inquire who have occupied and takes the profits of lands escheated to the Queen by the rebellion, and by what warranty the profits have been taken; if any had a custodiam thereof to require production of same and to enter it on the survey so that Her Majesty may receive what is due, and to do the like to those who have intruded so that they may be charged with the receipt of the profits.


W Burghley:
  
 
E: Lyncoln
  

C: Howarde
  

Jamys Crofte
  

Chr: Hatton
  

Fra: Wallsingham.
  



¶11] *Small County of Limerick: table of contents.*


This table gives the pages on which are to be found the lands of the following persons viz:—




---

p.38


The Earl of Desmond attainted; John Brown of Any, John Supple of Kylmucko,[355](javascript:footNote('E580000-001/note355.html')) John Bradaghe Cahissy of Kyldirry in Poblebrian, and Thomas Browne of Kylkylane; all slain in rebellion; James mc Garrott duffe of Cloghe boddy viller executed by Captain 
Norris at Fenner; Garrott Balluffe ffitzPhillippe mcEdmunde of Farren Henrie Roe executed in rebellion by John of Desmonde; and William ffox of Ballygrenan who died in rebellion.


*Small County of Limerick*.


¶12] {MS folio 7}*Lands and possessions of Gerald alias Gerrott late Earl of Desmond, attainted.*


*The Barony alias Manor of Anye[356](javascript:footNote('E580000-001/note356.html')) in Small County of Limerick*.


*Free rents*[357](javascript:footNote('E580000-001/note357.html'))


Head rents issuing yearly as follows Ballimollen l0*s*, Bally Roche 
alias Annahe in Rochtaghe in Poblebryan 6*s.* 8*d.*, and Carmonoge in co. [*...*][358](javascript:footNote('E580000-001/note358.html')) 2*s.* 11*d.*, in all 19*s.* 7*d.*


¶13] *Demesne lands of Anye*.


The site of the manor of Anye with the demesne lands thereto belonging called the Earl's free land in Any containing by estimation 3 quarters 3 acres of arable land: of these lands the parcels are the
vill of Kylmcdonnoduffe, the vill of Cleystenes within the burgage land of Any, and a vill adjacent thereto called— [*...*] [359](javascript:footNote('E580000-001/note359.html')) situated similarly in said burgage land. The vill and land of aid premises are now or were lately in the tenure or occupation of Sir George Bourchier Knt and contain 3 quarters 3 acres


¶14] *Gortneclone*


Gortneclone in Any parish parcel of the Earl's chargeable[360](javascript:footNote('E580000-001/note360.html')) lands, and parcel of 23 quarters in Small County which are wont to be charged 3*l* . rent for every [carucate][361](javascript:footNote('E580000-001/note361.html')) besides coynye and lyuerie: similarly in the occupation of Sir George Bourchier, knight and contain by estimation 1 quarter


{MS folio 7d}*Burgeses Landes*


The burgesses lands in Anye parcel, chargeable and in the occupation of Sir George Bourchier knight as aforesaid. Ballinbrowe is parcel therof and the premises contain 2 quarters.


¶15] *Ballycarowny*


The vill and land of Ballycarowynge in the parish of Hospitall Any, Small County containing late[362](javascript:footNote('E580000-001/note362.html')) in the tenure or occupation of Thomas
Browne Constable of Any now in the tenure of Sir George Bourchier Knight and containing ½ quarter of the great measure.


*Ballynamoye*


The vill and land of Ballynamoye situate near Ballycarownye aforesaid and of the like parish tenure extent and measure.


¶16] *profits of the fair in Anye*


A Fair belonging to the manor or barony of Any held yearly in the town of Any on the first and second days in August nad worth yearly


{MS folio 8} for every cow or horse sold there during the fair or the day before or the day after 4*d.* "halfas";[363](javascript:footNote('E580000-001/note363.html'))


for every vessel tun or barrel of wine or beer, Huskobagh or aqua vita sold on the fair days 3 measures called quarts;


for the profits of stalls cellars or upper storeys at the allocation of the said Earl or his assigns for every stall cellar or upper storey during the time of the fair 12*d.*




---

p.39


The tenth part of all merchandize sold there during said two days.


Memorandum. This Barony is manured and inhabited.


Sum of the Barony of Anye 6 quarters 3 acres.


¶17] {MS folio 8d}*The Manor or Barony of Glannogree in the Small County of Limerick.*


Headrents issuing yearly from the free tenants of the Barony:—none


*Demesne lands of Glannogre*


The site of the manor of Glannogre late in the tenure or 



---

p.40




occupation
of Sir George Bourchier knight and containing 4 carucates or
quarters.


*Creans*


The vill and lands of Creans in the parish of Creans parcel of the manor of Glannogre and parcel of the 23 carucates called the Earl's chargeable lands with 2*l.* rent per carucate besides coyney and lyverey now or late in the tenure or occupation of said Sir George Bourchier and containing 2 quarters.


Wood or underwood there called Kylcrean woodes belonging to said manor or barony and now or late in the tenure or occupation of said Sir George Bourchier.


Memorandum this barony is inhabited.


Sum of the barony of Glanogre 6 quarters.


¶18] {MS folio 9} *The manor or barony of ffedamonr[364](javascript:footNote('E580000-001/note364.html')) in the Small County of Limerick*


*Head rents*


Head rents issuing from the old building and half a carucate of land of the lands of John mc Danegeloge yearly 1*l.*


Like rents issuing from the other half carucate of land of the lands of John mcTeige Igrudey yearly 1*l.* Total 2*l.*


*Demesne lands*


The site of the manor of ffedamoore with the castle and appurtenances being demesne lands of said manor and called the Earl's freeland in iffeadamoore now or lately in the tenure or occupation of Sir 
George Bourchier, knt. and containing 2 carucates or quarters.


¶19] *Balliee*


The vill and land of Balliee portion of the Earl's chargeable lands charged yearly with 2*l.* head rent and 2*l.* for another rent in all 4*l*: said land now or lately in the tenure or occupation of Sir George Bourcher Knight contains 1 carucate or quarter.


*Fannungstown*


The vill and land of Fanningstowne in the parish of ffedamoore parcel of the chargeable lands in Small County charged with like rents in same occupation and of the same extent as Balliee.


¶20] {MS folio 9d}*Tannctcloghe The olde Stone*


The vill and land called The Olde Stone in ffedamoore alias "the ould Buildinge" formerly in the tenure or occupation of John mcTeigue Ygrady parcel of the Earl's chargeable land in like tenure as Balliee and containing half a quarter.


*Coallick*


The vill and land of Coallick in the parish of fedamoore now or late in the tenure or occupation of John mcMorris of Ballynarde parcel of the Earl's chargeable lands now or late in the tenure or occupation of Sir George Bourchier and containing 1 quarter.


The nomination or presentation of Fedamore is in the election of the earl for a payment of 5*l.* halfas paid by the rector.


Memorandum this barony is not inhabited and lies waste.


Sum of the barony of Fedamoore 5½ quarters


¶21] {MS folio 10}*The manor of Loughgier[365](javascript:footNote('E580000-001/note365.html')) in the Small County of Limerick*.


Head rents isuing yearly from the lands of free tenants in said manor:—none


*Loughgier*


The site of the manor of Loughgier with free tenants in said manor:—none


The site of the manor of Loughgier with the castle and demesne lands belonging thereto in the parish of Graunsha of the Lough ([*...*])[366](javascript:footNote('E580000-001/note366.html')) now or late in the tenure or possession of Sir Geo. Bourchier and containing of arable land 3 quarters.


*Granshede Loue*


The vill castle and land of Graunshe of the Lough in said parish in like tenure.


¶22] *Castellanedroyde.*


The vill castle and land of Castellanedroyde in like parish and tenure and parcel of the demesne lands of Loughgier


*Knockelough.*


A parcel of land called Knockeloghe in like parish and tenure and parcel of the demesne lands of Loughgier.


{MS folio l0}*d.**Ballycullen*


The vill and land of Ballycullen in like parish and tenure, parcel of the demesne lands as aforesaid and containing 1 carucate or quarter.


Sum of the manor of Loghgier with the demesne lands 4 quarters of great measure.


¶23] *Lands that are parcels of the 23 quarters of land in the Small 
County of Lymerick called the Earl's chargeable land.*


*Ballinrollye*


The vill and land of Ballynrollye in the possession of [*...*][367](javascript:footNote('E580000-001/note367.html')) Rollye containing 2 quarters 6 acres of land, chargeable land at the rate of 2*l.* halfas per carucate besides conyneye lyuerye and other charges:— 2 quarters 6 acres.


{MS folio 11}*Boggodesstowne*.


The vill and land of Ballinvogodick alias Boggodstowne in the possession of [*...*][368](javascript:footNote('E580000-001/note368.html')) Boggod containing 2 carucates 4 acres chargeable as aforesaid: 2 quarters 4 acres


*Ballyhywarde*


The vill and land of Ballyhywarde in the possession of [*...*][369](javascript:footNote('E580000-001/note369.html'))
London containing 2 quarters of land chargeable as aforesaid.


¶24] *Ballygorman*


The vill castle and land of Ballygorman alias Gormanstowne in the country of Poblebuskagh alias Foxes Country and parish of Iwergerrye (Uregare), now or late in the tenure of [*...*][370](javascript:footNote('E580000-001/note370.html')) Buske, and chargeable as aforesaid.




---

p.41


{MS folio 11d}*Bulligudden Buske*


The vill castle and land of Bulligudden Buske in the country and parish aforesaid now or late in the tenure or occupation of [*...*][371](javascript:footNote('E580000-001/note371.html')) Buske and chargeable as aforesaid.


*Gariskowlebin*


The vill and land of Garriskowlebin in the country parish and tenure as aforesaid and chargeable as aforesaid.


*Owergar*


The vill and land of Owerrgarr in the country aforesaid, chargeable as aforesaid and now or late in the tenure or occupation of Daivd Buske.


The four denominations Ballygorman to Owerrgarr contain in all 3 quarters.


¶25] {MS folio 12}*Ballynemonymore*


The vill castle and land of Ballynemonymore in the parish of Hospital Anye and in the possession of Edward mcRicharde containing 1½ carucates and 3 acres great measure or in all 33 acres chargeable as aforesaid: now or late in the tenure or occupation of Garratt Roe mcRichard:— 1 quarter 13 acres.


*Ballynemonybegg*


The vill and land of Ballynemonybegg with 2 castles in said parish and in the possession of John Browne late of Anye containing 18 acres, great measure chargeable as aforesaid: now or late in the tenure or occupation of Kattelline en Dermods of Knockmony:— 18 acres


{MS folio 12d}*Ballenskulligg*


The vill and land of Ballynskowligg with 2 castles in the parish of Anye in the possession of Edward Skowle of Ballynskowligg containing ½ quarter and 2 acres of great measure equivalent to 12 acres of great measure chargeable as aforesaid:— 12 acres.


*Ballyhuhbarde*


The vill and land of Ballyhubbarde with a ruinous castle in the parish of Kylkyllan in the possession of Edmund moyle mcRichard of Ballyhubbarde of same extent as Ballynskowligg and chargeable 
as aforesaid:— 12 acres.


¶26] {MS folio 13}*Kylkyllane*


The vill and land of Kylkyllane with a castle in said parish in the possession of Thomas Browne of Anye containing 1½ quarters and 2 acres great measure equivalent to 32 acres of great measure and chargeable as aforesaid:— 32 acres.


*Ballyncolllyroo*


The vill and land of Ballyncollyroo with an old and ruinous castle in the parish of Knockesawno in the possession of John Supple of Kylmucko containing ½ quarter or 10 acres great measure and 
chargeable as aforesaid:—10 acres.


{MS folio 13d}*Camus*


The vill and land of Camus in the parish of Krean in the possession of the Earl of Desmond containing 1 quarter 5 acres or 25 acres great measure, and chargeable as aforesaid:— 25 acres.


Sum of said lands parcel of said 23 carucates:— 16½ quarters.


¶27] {MS folio 14}*Certain free lands of said Earl of Desmond 
chargeable in the Small County of Limerick*




---

p.42


*Kyllfrushe*


The vill and land of Kyllfrushe in the parish of Kylfrushe in the possession of Sheron alias Geoffrey of Kyllfrushe containing ½ quarter of land great measure, parcel of the Earl's chargeable land in Small County but not regarded as portion of the 23 carucates aforesaid: subject to a similar yearly rent of 2*l.* per [*...*][372](javascript:footNote('E580000-001/note372.html')) besides coynie, Lyverie and other charges:— 10 acres.


*Rathmoore*


The vill and land of Rathmoore with a castle situate in the parish of Monaster nenoghe in Small County in the possession of Maurice Shehan[373](javascript:footNote('E580000-001/note373.html')) gent containing 2 quarters great measure demised to him by the Earl of Desmond at a yearly rent of a pepper corn as is said besides coynie Lyverie and other charges at the pleasure of said Earl:— 2 quarters.


{MS folio 14d}*Carrigkightell*


The vill and land of Karrigkightell with a ruinous castle situate in the parish of Anye and containing 1 quarter great measure:— 1 quarter.


¶28] *Correlishe*


The vill and land of Correlishe situate in the parish of Kreas[374](javascript:footNote('E580000-001/note374.html')) containing ½ carucate great measure:— ½ quarter.


*Droomebegg*


The vill and land Droomebegg in the parish of Kreans,[375](javascript:footNote('E580000-001/note375.html')) ½ carucate great measure now or lately in the tenure or occupation of John mcSawerley, harper:— ½ quarter.


*Kaheragyllymoore*


The vill and land of Kaheragyllymoore with a ruinous castle in the parish of Anye now or late in the tenure or occupation of Stephen White of Lymerick, 1 carucate great measure:— 1 quarter.


{MS folio 15}*Ballintravesye*


The town and land of Ballintravesy in the parish of Glanogre now or late in the tenure or occupation of the Countess of Desmond ½ carucate, great measure:—½ quarter.


¶29] *Knockcromwell*


The vill and land of Cromwelloknowing alias Knockcromwell in the parish of Kylshyley, 1 carucate, great measure:— 1 quarter.


*Cloghindullordy*


The vill and land of Cloghindullordy in the parish of Kylfekan now or late in the tenure or occupation of Maurice Shehan, 2 carucates great measure:[376](javascript:footNote('E580000-001/note376.html')) 2 quarters.


*Kylmallock*


A Rent called Colpe money belonging to the Earl of Desmond in Kylmallock to be received from the inhabitants and answered for yearly in the account of the sovereign (sufferanus) there viz:— 4*d.* halface for every milch cow (vacca sine[377](javascript:footNote('E580000-001/note377.html')) le mylche cowe) or horse (caballo sine[378](javascript:footNote('E580000-001/note378.html')) le garron) every quarter of a year which is worth yearly [*...*].[379](javascript:footNote('E580000-001/note379.html'))


¶30] {MS folio 15d}*Tenement in Kilmallock.*


A tenement in Kylmallock near Castellane Larrvalley[380](javascript:footNote('E580000-001/note380.html')) in a certain place in the centre of the town at the east end of the street, and a castle in the center of the street and town now or lately in the 
tenure or occupation of John Wall.


Sum, 9 quarters.




---

p.43


*Baneoge*


The vill and land of Baneoge near the country of Poblebryan, parcel of the Earl's freeland and lying in the parish of Kyllffeakan: this parish lies in the great County of Limerick but the vill of 
Baneoge lies in Small County. It contains ½ quarter now or late in the tenure or occupation of John OKahysse late constable of the Earl in his castle of Glenogre.


Memorandum:— this parcel lies waste.


Sum of Baneoge ½ quarter.


¶31] {MS folio 16}*Rents of free tenants in the Small County of Limerick belonging to said Earl of Desmond.*


*The lands of Willima mcShane mcMorris of Ballynarde*.


*Coynie and Lyuerye*


Annual Coynie and Lyverie payable by said William to the Earl of Desmond from his lands of Ballynarde in the parish of Ballynumrahar[381](javascript:footNote('E580000-001/note381.html')) as is said in Small County now or late in the tenure or occupation of said William. The vill and lands containing 1 carucate great measure, were charged yearly without intermission with Coynie and Lyverie as often as the said Earl of Desmond went or returned through the country with certain horses, horsemen and horseboys to the number of 4 or 6 horses, 4 or 6 horsemen, and 8 or 12 horseboys sometimes more sometimes less at the pleasure 
of the Earl of Desmond as long as he should be or remain in the Small County or Great County or Lymerick.


¶32] {MS folio 16d}*The lands of William ne Boyle mcGarrett begg Marescall.*


*Coynie and Lyverye*


Annual Coynie and Lyverie similarly payable by said William ne Boyle from a moiety of the vill and lands of Rahan in the parish of Rahan now or late in the tenure or occupation of said William and containing ½ carucate, great measure. The coynie and Lyverie in this case are from 6 or 8 horses, 6 or 8 horsemen, and 12 or 16 horseboys more or less as in the case of William mcShane mcMorris


{MS folio 17}Like Annual Coynie and Lyverie payable by said William ne Boyle in respect of a moiety of the lands of RathJourdan in the parish of Kylkyllane now or late in his tenure or occupation and containing 1 carucate great measure. In this case they are for 6 or 8 horses, 6 or 8 horsemen, and 12 or 16 horseboys in all respects as before.


{MS folio 17d}Memorandum. The moiety of the towns of Rahan and Rath Jourdan are here charged to the Earl of Desmond with Coynie Lyverie galloglasse and Kearntie which galloglas and 
Kearntie the Earl sometimes took instead of Coynie and Lyverie. If he sent not his horsemen he sent of his galloglas or of his Kearne.


Sum of the lands and possessions of the Earl of Desmond in said Small County of Lymerick [*...*].[382](javascript:footNote('E580000-001/note382.html'))


¶33] {MS folio 18}*Lands and possessions of divers traitors in the Small County of Lymerick who were slain in rebellion, who were executed, or who died in rebellion*.


*Land of John Browne of Knockmonye slain in rebellion*.


*Eanoghe O Murtell.*


The vill and lands of Eanoghe O Murtell near Loughgir in the parish of Hospital Anye now or late in the tenure or occupation of Katherine ne Dermodo his wife and the mother of Thomas Springe, gent. containing ½ carucate great measure:— ½ quarter.


*Knockmnonye*


The vill and lands of Knockmonye with a castle in like parish, enure or occupation containing 1 quarter, great measure:— 1 quarter.




---

p.44


{MS folio 18d}*Wantyre*


The parcel of land called Wanetyre parcel of the lands belonging to Knockemoone in said parish tenure or occupation containing ½ quarter, great measure:— ½ quarter.


Memorandum:— these lands are inhabited and well manured.


Sum of the lands of John Brown in Small County: 2 quarters.


¶34] {MS folio 19}*Lands of John Supple of Kyllmuckoo who was 
slain in rebellion.*


*Ballincollyroo*.


The vill and land of Ballincolleroo in the parish of Knockesawnaghe (as is said), parcel of said 23 carucates called the Earl's chargeable land in small county which is charged at the rate of 21. halface 
rent per carucate besides Coynie and Lyverie and other charges, now or late in the tenure or occupation of Philip Suppell and containing ½ carucate:— ½ quarter.


Memorandum:— the town of Ballincolleroo is inhabited and manured.


Sum of the lands of John Supple in Small County:— ½ quarter.


¶35] {MS folio 19d}*Lands of John Bradaghe Cahissy who was slain in rebellion*.


*Rahan*


A portion or moiety of the vill of Rahan alias Rahen with a castle in the parish of Rahan Fenn (as is said) now or late in the tenure or occupation of William ne Boyle mcGarrett begg containing ½ carucate great measure (besides the other part of the vill charged with cossherie aforesaid):— ½ quarter.


Memorandum:— the town of Rahan is inhabited.


Sum of the lands of John Bradaghe Cahissie in Small County:— ½ quarter.


Memorandum:— the other moiety of the town and lands of Rahan is in the possession of William ne Boyle mcGarrott begg marescal and is charged to the Earl of Desmond with Coynie Lyverie Galloglasse and Kearnetie formerly charged in Small County amongst the Earl's lands in the title of Coynie and Lyverie.


¶36] {MS folio 20}*Lands of James mcGarrott duffe Marescal executed at Browrye by Captain Norris.*


*Rath Jourdan*


A portion or moiety of the vill and lands of Rath Jordan in the parish of Kylkyllane now or late in the tenure or occupation of William ne Boyle mcGarrott begg of Rahan containing ½ quarter 
great measure:— ½ quarter.


*Cloghwycl en villor.*


Part of the vill castle and land of Clogh wyd en vyller in the parish of Rahan (as is said) now or late in the tenure or occupation of James mcGarrott Duffe, Marescal and containing ½ quarter 
great measure:— ½ quarter.


Memorandum:— the towns of Rath Jourdan and Cloghwyden villor were equally divided between James mcGarrott duffe and William ne Boyle: Rath Jourdan is inhabited the other is waste.


Sum of the lands of James mcGarrott duffe Marescal in Small County:—1 quarter.


{MS folio 20d}Memorandum the other moiety of the town and lands of Rath Jourdan as in the possession of William ne Boyle mcGarrott begg Marescal and is charged &c as in the memorandum concerning Rahan.


¶37] *Lands of William Fox of Ballygrenan who died in rebellion*.




---

p.45


*Ballygrenan*


The vill and lands of Ballygrenan with a castle situate in the country of Poblebuskaghe alias Foxes Country in the parish of Owergare late in the tenure of Patrick Fox and now or late in the tenure or 
occupation of George Thornton, gent, marshal of Munster, containing 1 quarter, great measure:— 1 quarter.


Memorandum:— the said town and lands of Ballygrenan are manured and inhabited.


Sum of the lands of William Fox in Small County:— 1 quarter.


¶38] {MS folio 21}*Lands of Garrott Balluffe ffitz Phillippe ffitz Edmunde of Boherboye executed in rebellion by John of Desmond.*


*Farrenhenryroo*


The vill and lands of Farrenhenryro in the parish of Towargare (as is said) now or late in the tenure or occupation of John de Lacy of Aneylack in Cosmaye containing 1 quarter, great measure:—
1 quarter.


*Boherboye*


The vill and lands of Boherboye near Henry roo aforesaid in said parish now or late in the tenure or occupation of said Garrott Balluffe and containing ½ quarter, great measure:— ½ quarter.


Memorandum:— Farrenhenryroo is inhabited but Boherboye lies waste as is said.


Sum of the lands of said Garot Balluffe ffitz Phillip ffitz Edmunde aforesaid in Small County:— 1½ quarter. {MS folios 21d to 23d blank}


*Great County of Lymerick*.


¶39] {MS folio 24}*Clanwilliam*.


*Lands and possessions of Gerald alias Gerrott late Earl of Desmond, 
attainted.*


*Corballye*


The vill and lands of Corballye with a ruinous castle near the walls of Limerick in the parish of "the city of the County of Limerick[383](javascript:footNote('E580000-001/note383.html')) (as is said) and within the bounds of the country called Clanwilliam now or late in the tenure or occupation of Patrick Kreaghe of Limerick, merchant and containing 1 quarter.


*Woods*


There are divers underwoods belonging to said lands but no timber.


Memorandum:— this quarter of land is manured and inhabited.


*Temple ne Mownagh*


A parcel of land in Temple ne Mounaghe near Limerick in the parish of Temple Ne mounaghe, Clanwilliam now or late in the tenure or occupation of the Earl of Desmond, and containing 10 acres.


There are divers underwoods belonging to said lands but no timber.


Memorandum:— this parcell lies waste.


{MS folio 24d}Memorandum:— the country of Clanwilliam has 120 acres to the quarter or ploughland.


Sum of the lands of the Earl of Desmond called the Earl's freeland in Clanwilliam 1 quarter 10 acres.


¶40] {MS folio 25}*Rents of free tenants, in Clanwilliam belonging to the Earl of Desmond.*




---

p.46


*Lands of William oge O Hurley,[384](javascript:footNote('E580000-001/note384.html')) Donnell mc Anna and others in the toghe of Oryley,[385](javascript:footNote('E580000-001/note385.html')) Clanwilliam*.


*Sorraen*


Certain yearly Sorraen due to said Earl by said William, Donnell and other inhabitants and occupiers of the togh of Oryle, Clanwilliam as well free as customary tenants for 100 Galloglas twice a year viz meat drink and lodging for 2 days and 2 nights going and 2 days and 2 nights returning.


This parcel of Clanwilliam called the toghe of Oryle contains 7 quarters viz Lyckadowne 3 quarters, Kyltorogg 2 quarters, the lands of Edmund mcShane I quarter, and Boherenlloyde 1 quarter:— 7 quarters.


{MS folio 25d}Memorandum:— this toghe of Oryle is inhabited.


*Sesse Malone*


A certain yearly Sesse called Sesse Mallone due to said Earl, from said inhabitants in respect of said toghe of Oryley, Clanwilliam, for the number of 2 horses 2 horsemen and 8 horseboys sometimes 
more sometimes less at the pleasure of said Earl as long and as often as the same Earl should [*...*][386](javascript:footNote('E580000-001/note386.html')) in the County of Limerick:— this parcel contains 7 quarters.


¶41] {MS folio 26}*Lands off William Bourck, baron of Castell Connell, lord of Clanwilliam and other tenants there*.


*Bonaght*


A certain yearly Bonnaghte due and payable to said Earl of Desmond by said lord of Clanwilliam, baron of Castell Connell and other inhabitants of Clanwilliam as well free as customary tenants for 
Bonaght of 100 Galloglas for one quarter of a year viz for 84 days yearly. The country contains 120 quarters viz the part called Clanwilliam 80 and the other part called Nestermoy, Clanwilliam, 40 quarters in all 120 quarters.


Memorandum:— this country of Clanwilliam is manured and inhabited. The charge of this Bonaghte in money paid to the Galloglas (if they would have money) was one white "groate" [387](javascript:footNote('E580000-001/note387.html')) a meal: 22*s.* 2 white groats a day, for 84 days, which came yearly to 93*l.* 6*s.* 8*d.*


Note the just quarter of 91 days is to be charged as the ofher is 7 days less.


{MS folio 26d}*Sesse Malone*


A certain yearly Sesse called Sesse Malone due and payable to said Earl from said inhabitants in respect of Clanwilliam for 8, 12, 16 or 20 horses and horsemen and 16, 24, 32 or 40 horseboys sometimes more sometimes less at the pleasure of the Earl as long and as often as the said Earl should go or return in the County of Limerick. And the country of Clanwilliam which is liable to such Sesse called Sesse Malone (besides Cossherie) contains 120 quarters.


Memorandum:— the Country of Clanwilliam aforesaid is manured and inhabited.


Sum of the Sorraen Bonaghte and Sesse Malone in Clanwilliam


[388](javascript:footNote('E580000-001/note388.html'))
{MS folio 27}Sum of the lands of the Earl of Desmond and[389](javascript:footNote('E580000-001/note389.html')) Clanwilliam.[390](javascript:footNote('E580000-001/note390.html')){MS folio 274. blank}


¶42] {MS folio 28}*Poblebryan*


Lands and possessions of Gerald alias Gerrott late Earl of Desmond attainted.




---

p.47


*Cloghytacka*


A portion of the vill of Cloghytacka[391](javascript:footNote('E580000-001/note391.html')) with a well built castle in the 
parish of Corkemoore in the country called Poblebryen and in the great County of Limerick containing 2 carucates of land now or late in the tenure or occupation of David Rowley and the Countess of Desmond, besides the residue of Cloghytacka aforesaid which belongs to the Duffes of Carrigogonell:— 2 quarters.


*Woods*


Divers underwoods called Kyllcloghetacka alias Coghetacka woods belong to said two quarters but there is no timeber in them.


*fishing*


A certain Salmon fishing on the river Maye belongs to said vill of Cloghytacka where it extends along said lands.


Memorandum:— this parcel of Cloghetacka aforesaid is manured and inhabited by a man belonging to Sir William Standley.


¶43] *Ballyregan*


The vill and land of Ballyregan with a castle, in the parish of Ballykaell now or late in the tenure or occupation of Fowlke Mounslo gent and containing 1 carucate:— 1 quarter.


{MS folio 28d}*Woods*


There are divers underwood's called Kyllballyregan alias Bally Regan woods belonging to said vill but there is no timber in them.


Memorandum:— Ballyregan aforesaid is manured and inhabited.


*Ballinvealaghe*


The vill and land of Ballynvealaghe with a castle in the parish of Kyllffeakan now or late in the tenure or occupation of William O Kahissy bishop of Limerick containing 1 carucate:— 1 quarter.
There are certain underwoods called Kyllballyvealaghe but there is no timber in them.


Memorandum:— Ballyvealaghe is inhabited and manured.


¶44] *Clareyny*


Portion of the vill of Clareyny[392](javascript:footNote('E580000-001/note392.html')) in the parish of Kyllkydye, Poblebrien, containing 20 acres beyond the lands which belong to the Earl of Desmond being a third of said vill: the other two parts or 
residue of said vill belong to the Duffs of Carriggonnell contain 40 acres now or late in the tenure or occupation of said Brian Duffe, gent:— 20 acres


{MS folio 29}Memorandum:— the parcel of land called Clareyny aforesaid is inhabited and manured.


¶45] *Morrenett*


Portion of the vill and lands in Morrenet alias Monrenett in the parish of Morrenett ffenn, containing 2 quarters beyond the land which belongs to the Earl of Desmond now or late in the tenure 
or occupation of Donnogho alias Denis O Kahissy chancellor of the city of the County of Limerick; beyond the parcel of land and vill of Carriggonnell in Morrynett belonging to the Duffes, 6 carucates or quarters there belonging to the Bishop of Lymerick, and 4 quarters there belonging to Pierce Laughtas which altogether contain [*...*] [393](javascript:footNote('E580000-001/note393.html')) quarters lying in Morrenett beyond the 2 quarters of the Earl of Desmond:— 2 quarters


Memorandum:— the said 4 quarters of Pierce Laughtas are chargeable to the Bishop of Lymerick: the Earl's said 2 quarters are free of all cess and duty and contain more in quantity than the 
4 quarters.


Memorandum:— the Earl's said 2 quarters are manured and inhabited by Mahownde Gowe a tenant of Donnoho Cassye.




---

p.48


¶46] *Ballymologe*


The vill and land of Ballymolloge with a ruinous castle in the parish of Clareyny in Corkemore, Poblebryan, Great County of Limerick containing 1 quarter.


{MS folio 29d}*Kyllboye*


The vill and land of Kyllboye similarly situated now or late in the tenure or occupation of the Countess of Desmond and containing 1 quarter.


Memorandum:— the said 2 several townships of Ballymologe and Kyllboy lie waste 4 miles from Lymerick.


¶47] *Inche*


A parcel of land called Inche in the parish of Killydye,[394](javascript:footNote('E580000-001/note394.html')) Corkemore, as aforesaid now or late in the tenure or occupation of the Countess of Desmond:— or the inhabitants of the vill of Corkemore adjacent and containing 5 acres.


Memorandum:— said parcel called Inche lies waste.


{MS folio 30}*Boherowen.*


A parcel of land called the vill of Boherowen similarly situated now or late in the tenure or occupation of David Rowley of Cloghetacka and containing 20 acres.


Memorandum:— said parcel of Boherowen lies waste 4 miles from Lymerick.


Sum of the Earl of Desmond's free land in Poblebryan. 8 quarters 45 acres


Memorandum:— the country of Poblebryan has 120 acres to the quarter.


¶48] *Rents of free tenants in Pohlehrvan aforesaid belonging to said 
Earl of Desmond.*


*Lands of Brian Duffe and the Duffes of Carriggonnell.*


*Cosherye*


A certain yearly Cossherie payable to the Earl of Desmond by the Duffes of Carriggonnell issuing from the castle and lands of Carriggonnell {MS folio 30d} in the parish of Monrenet in Poblebryan, Great County of Lymerick now or late in the tenure or occupation of Brian Duffe, gent, and containing 4 quarters.


said castle and lands were constantly and yearly charged with Cossherie to the said Earl as often as he should come or return by the country for 2 days and 2 nights at Christmas once a year; and if he did not do so the said Duffes paid him 100 shillings halface:— 4 quarters.


Memorandum:— the castle and lands of Carriggonnell are manured and inhabited at the present time.


¶49] {MS folio 31}*Cossherye*


Like yearly Cossherie due and payable to the Earl of Desmond by the chief lord of the Duffes of Carriggonnell and the lord of Poblebryen called the chief lord of the country of Poblebryan and 
the occupiers of the lands of the country of Poblebryan and Corkemore in Poblebrian as well free as customary tenants for the number of 200 men footmen and horsemen for 2 days and 2 nights at Christmas, once a year sometimes sometimes less. Which charge for Galloglas Kerne and horsemen was assessed 2 parts on the country of Poblebryen and the remaining part on the parcel called Corkemore in Poblebryen. Poblebryan contains 30 quarters and Corkemore 17 quarters:— 47 quarters.


Memorandum:— said 2 days and 2 nights are for coming and going and tarrying but 2 nights.




---

p.49


A yearly Sesse called Sesse Malone similarly payable to said Earl by the chief lord and occupiers aforesaid for 20, 30 and 40 horses and horsemen and {MS folio 30d} 20, 40, 60 and 80 horseboys sometimes more sometimes less yearly and constantly payable by the tenants and inhabitants at the pleasure of the Earl of Desmond as long and as often as he wished, and as long and as often as he 
went and came through the great or small county of Limerick. Two parts of this cess was charged on Poblebryan containing 30 quarters and the other part on Corkemore (Poblebryen) containing 17 quarters.


Memorandum:— Poblebryen and Corkemore are for the most part inhabited but a portion lies waste.


Sum of the Cossherie and Sess Malone in Poblebryan [*...*][395](javascript:footNote('E580000-001/note395.html')){MS folio 32}
Sum of the lands of the Earl of Desmond in Poblebryan[*...*].[396](javascript:footNote('E580000-001/note396.html'))


{MS folio 32d and 33 blank}


¶50] Table goes here (see folio 170) James McGarrott[397](javascript:footNote('E580000-001/note397.html'))


¶51] {MS folio 36}*Great County of Limerick*.


List of Toghes[398](javascript:footNote('E580000-001/note398.html')) or Canthreds with the number of quarters they contain viz:—


Browrye, 14, Clonhennery 23, Gortculligan 36½, Tawnaghe 11, Olybane 21, Croghe 20, Nantenan 20, Asketten 28, Dunmoylyn 23, Shanned 20, Meaghan 25, Gortcoythe 15, Farrensesserogh 18, Drynan (½ Toghe) 10 and Glancarrobry (½ Toghe) 10, Kyllydye (½ Toghe) 7½ and Kylhylaghe (½ Toghe) 5, Ogallahowr (½ Toghe) 12 and Lysmakerrey (½ Toghe) 10.


Sum of said Canthreds called the 16 Toaghes in Connelowe: 324 quarters.


{MS folio 36d blank}


¶52] {MS folio 37}*Toghe of Browrye*.


*Lands of the Earl of Desmond in this Toghe in Connellove, Great County of Limerick*.


*Ballynaught*


The vill and lands of Ballynaughte in the parish of Browrye containing 2 quarters each having 80 acres only now or late in the tenure or occupation of George Thornton, marshal:— 2 quarters.


Memorandum:— Ballynaughte is inhabited and lies hard by Kylmallock.


*Shanneclone*


The vill and lands of Shanneclone in said parish containing ½ quarter:— ½ quarter.


Memorandum:— this land lies waste and is 1½ miles from Kylmallock.


*Ballygillycroghe*


The vill and lands of Ballygyllecrogh in said parish, containing ½ quarter:— ½ quarter.


{MS folio 37d}Memorandum:— the ½ quarter of Ballygyllycroghe 
lies waste and is 3 miles from Kylmallocke: the "chiefest" relief the town has for firing.


Sum of the Earl's lands in the Toghe of Browrye: 3 quarters.


¶53] *The Earl's chargeable lands in the possession of Eadye Lacye, surviving, within this toghe*


*Browre woghter*


The vill and lands of Browre woghter in English High Browrye with a castle well built situate in the parish of Browre woghter and.




---

p.50


*Browre yeaghter*


the vill and lands of Browre yeaghter in English lowe or neither Browrye with three castles situate in said parish: both denominations now or late in the tenure or occupation of Eady Lacye and containing 1 quarter.


{MS folio 38}Memorandum:—this quarter is inhabited and lies on the river of Maye whereon is built a water mill 2 miles from Kylmallock.


*Bohermore*


A parcel of land called Bohermore in the parish of Browrye now or late in the tenure or occupation of Eadye Lacye and containing 1 quarter:— 1 quarter.


Memorandum:— this quarter lies waste 1½ miles distant from Kylmallocke.


*the Garrows*


A parcel of land called the Garrowes in the parish of Browre woghter: like tenure extent and memorandum as in case of Bohermore.


{MS folio 38d}*Lyshena Konno*


The vill and lands of Lyshena Konno: like parish, tenure, and extent as Bohermore.


Memorandum:— this quarter lies waste and is very well wooded: it adjoins the river Maye and is 2 miles distant from Kylmallock.


Sum of the lands in possession of Eadye Lacye of Browrye 4 quarters.


¶54] *The Earl's chargeable lands in this Toghe in possession of 
Richard mcThomas[399](javascript:footNote('E580000-001/note399.html')) of Pallice slain in rebellion*.


*Garreffoyn*


The vill and land of Garreffoyne with a ruinous castle in the parish of Browrye woghter now or late in the tenure or occupation of Richard mcThomas of Pallice and containing 2 quarters:— 2 quarters.


{MS folio 39}*woods*


The parcel of wood there called Kyllgarrefoyne or Garrefoyne woods, parcel of said 2 quarters: no extent given for woods.


These 2 quarters lie waste and are well wooded:— they are situate 3 miles from Kylmallock.


*Ballyntubbred*


The vill and lands of Ballyntubbred in said parish containing 1 quarter.


*woods*


The parcel of wood there called Kyllballynetubbred or Ballynetubbred woods parcel of said vill now or late in the tenure or occupation of Richard mcThomas of Pallice.


Memorandum:— this quarter lies waste, well wooded, 3 miles from Kylmallock.


{MS folio 39d}*Cloneferty*


The vill and lands of Clonefertye: same parish and tenure as Garreffoyne aforesaid: containing 1 quarter.


*woods*


There are there divers underwoods called Cloneferty woods but no timber.


Memorandum:— this quarter lies waste 3 miles from Kylmallock.


Sum of the lands of Richard mcThomas in the Toghe of Browrye: 4 quarters.


¶55] *The Earl's chargeable lands in this Toghe in the possession of
James mcMorris Oge Lacye, surviving*.




---

p.51


{MS folio 40}*Ballyfowken*


The vill and lands of Ballyfowken in the parish of Browrye woghter now or late in the tenure or occupation of said James mcMorris and containing 1 quarter.


*Woods*


There are there divers underwoods called Ballyfowken or Kyllballyfowken in which there is timber viz Ash Trees.


Memorandum:— this quarter lies waste 3 miles from Kylmallock.


*Ballynowrane*


The vill and lands of Ballynowran: like parish, tenure, extent as Ballyfowken.


*Woods*


There are there divers underwoods called Ballynowrane woods in which there is timber viz Ash trees.


Memorandum:— this quarter lies waste 3 miles from Kylmallock.


{MS folio 40d}*Palmerstowne*


The vill and lands of Palmerstowne or Ballynalmor: like parish, tenure, and extent as Ballyfowken.


*Woods*


There are there woods called Palmerstowne woods in which there is timber viz Ash trees.


Memorandum:— this quarter lies waste 3 miles distant from Kylmallock.


Sum of the lands of James mcMorris oge Lacye aforesaid 3 quarters.


Sum total of Browrye Toghe:— 14 quarters.


¶56] {MS folio 41}*Toghe of Clonhennerye*.


The Earl's chargeable lands in this Toghe in possession of John mcKeanery, surviving.


*Ballyncastellane*


The vill and lands of Ballincastelane with a ruinous castle in Corkemohur in the parish of Ballincastelane Corkemohur now or late in the tenure or occupation of said John.


*Woods*


There are divers woods and underwoods there in which woods there is timber viz oak and ash.


Memorandum:— this land lies waste, 8 miles from Kylmallock and 14 from Limerick.


*Gortincappaquin*.


The vill and lands of Gortincappaquin: in like parish and tenure as Ballincastelane.


*Woods*


There are there the woods called Gortincappaquin woods alias Kyllgortincappaquin.


Memorandum:— Gortincappaquin lies waste.


{MS folio 41d}*Beallaghanulley*


The vill and lands of Beallaghannulley in like parish and tenure as Ballincastelane


*Woods*


There are divers woods called Beallaghanulley woods in which there is timber:— oak and Ash.




---

p.52


*Royalties*


There is in Beallaghnulley woods an "ayrie" of goshawks.[400](javascript:footNote('E580000-001/note400.html'))


Memorandum:— Beallaghanulley is inhabited and manured.


¶57] *Gortroo*


The vill and lands of Gortroo: in like parish and tenure as Ballincastelane.


*Woods*


There are divers woods called Bellaghroo in which there is timber:— oak and ash.


Memorandum:—Gortroo lies waste.


{MS folio 42}*Cappanenanta*


The vill and lands of Cappanenanta in like parish and tenure as Ballincastelane.


*Woods*


There are divers woods called Cappanenanta woods in which there is timber:— oak and ash.


Memorandum:— Cappanenanta lies waste.


*Cappagh neaghan*


The vill and lands of Cappagh neaghan in like parish and tenure as Ballincastelane.


*Woods*


There are divers woods called Cappagh neaghan woods in which there is timber: oak and ash.


Memorandum:— this parcel of Cappagh neaghan lies waste.


{MS folio 42d}*Dyryallen*


The vill and lands of Dyrreallen in like parish and tenure as Ballincastelane.


*Woods*


There are divers woods called Dyrreallen woods in which there is timber: oak and ash.


Memorandum:— Dyrreallen lies waste.


Sum of the lands of John mcKennerey in the Toghe of Clonhennery: 5½ quarters.


¶58] *The Earl's chargeable land in this Toghe in the possession of Edmund mcManus mc Shehee slain in rebellion*.


{MS folio 43}*Gragnekerrelaghe*


The vill and lands of Gragnekerrelagh in said parish now or late in the tenure or occupation of said Edmund and containing 1 quarter.


*Woods*


There are divers woods called Gragnekerrelagh woods in which there is timber: oak and ash.


Memorandum:— this quarter lies waste, 6 miles from Kilmallock.


Sum of the lands of Edmund mcManus mc Shehie in Corkemohur in said toghe : 1 quarter.


¶59] *The Earl's chargeable land in this loghe in possession of Richard
mcThomas of Pallice, slain in rebellion*.


*Kyllehallagh*


The vill and lands of Kyllehallaghe in the parish of Ballynecastellane Corkemohur now or late in the tenure or occupation of said Richard mcThomas and containing ½ quarter.




---

p.53


*Woods*


There are divers woods these called Kyllehallaghe woods in which there is timber.


{MS folio 43d}Memorandum:— this parcel lies 6 miles from Kylmallock and is waste.


Sum of the lands of Richard mcThomas of Pallice in Corkemohur: ½ quarter


¶60] *The Earl's chargeable land in this Toghe in the possession of Thomas mcHughe mcManeraghe, surviving*.


*Kylwarren ne maning*


The vill and lands of Kyllwarrenmaning in the parish of Ballincastellane, Corkmohur in the country of Poblemynter Gwyrren in said Toghe now or late in the tenure or occupation of Thomas mcHughe mcManeroghe of Kyllwarrennemaning and containing 1 quarter.


*Woods*


There are divers woods there called Kyllwarrenmanig woods in which there is timber.


Memorandum: this quarter of land is inhabited and lies 7 miles from Kylmallock and 16 from Limerick.


{MS folio 44}*Molloharde*


The vill and lands of Molloharde in said parish, country, toghe and tenure and containing 1 quarter.


*Woods*


There are divers woods called Mallaharde woods in which there is timber.


Memorandum:— this quarter of land lies waste and is distant 7 miles from Kyllmallock and 16 from Limerick.


¶61] *Gurtenry nehelagh*


The vill and lands of Gurtenrynnehelagh in said parish, country, toghe and tenure, and containing 1 quarter.


{MS folio 44d}*Woods*


There are divers woods called Gurtenrynnehelagh woods in which there is timber.


Memorandum:— Gurtenrynnehelagh lies waste it is distant 7 miles from Kylmallock and 16 from Limerick.


*Ballymcclonohan*


The vill and lands of Ballymcclonohan in said parish, country, toghe and tenure, and containing 27 acres.


*woods*


There are divers woods called Ballymcclonohan woods in which there is timber.


Memorandum:— Ballymcclonohan lies waste.


Sum of the lands of Thomas mcHugh mcManneragh in this toghe: 3 quarters 27 acres


¶62] {MS folio 45}*The Earl's chargeable lands in this Toghe late in the possession of Richard mcThomas of Pallice slain in rebellion*.


*Clonekripp*


The vill and lands of Clonekripp in said parish, in the country called Poblemynterquillan in the toghe of Clonehennerey aforesaid now or late in the tenure or occupation of said Richard mcThomas.




---

p.54


*woods*


There are there divers woods called Clonkrypp woods in which there is timber.


*Clone Connenerey*.


The vill and lands of Clone Connenerey in like parish, country, toghe and tenure.


*woods*


There are these divers woods called Clone Connenerey woods in which there is timber.


¶63] {MS folio 45d}*Ballyferrode*


The vill and lands of Ballyferrode in like parish, country, toghe, and tenure.


*woods*


There are divers woods there called Ballyferrode woods in which there is timber.


*Ballymarten*


The vill and lands of Ballymarten in like parish, country, toghe and tenure.


{MS folio 46}*woods*


There are divers woods there called Ballymarten woods in which there is timber.


*Modulleheye*


The vill and lands of Modulleheye in like parish country, toghe and tenure.


*woods*


There are divers woods there called Mulleheye woods in which there is timber.


The joint extent of these denominations, Clonekripp to Modulleheye inclusive is 4 ½ quarters.


Sum of the lands of Richard mcThomas in Poblemynterquyllan in this toghe is 41 quarters.


¶64] {MS folio 46d}*The Earl's chargeable lands late in possession of Mahowne mcDavy O'Quyllane*.


*Abehyne*


The vill and lands of Abehyne in said parish, country and Toghe, late in the tenure, or occupation of said Mahowne and containing 1 carucate or quarter.


*woods*


There are divers woods there called Abehyne woods in which there is timber.


The vill and lands of Kyllmyde in said parish country, toghe and tenure containing 52 acres.


There are divers woods there called Kylmydye woods in which there is timber.


{MS folio 47}Sum of the lands of said Mahownde in Poble mynter quillan 
1 quarter 52 acres


¶65] *The Earls chargeable lands in Poblemynterguillan in said Toghe*.


*Carrowgar rowe*


The vill and lands of Carrowgarrowe or the Short quarter in said parish country and Toghe; late in the tenure or occupation of the Earl of Desmond and containing 1 quarter.


*woods*


There are woods there called Balliwrely woods and Garrenemene woods in which there is timber
Sum of the lands of the Earl in Poblemynter quillan: 1 quarter.


¶66] {MS folio 47d}*The Earl's chargeable lands late in possession of Teige mcPhillippe O Kaell, surviving*.




---

p.55


*Ballinwreley*


The vill and lands of Ballinwreley with a castle well built in said parish country & toghe, now or late in tenure or occupation of said Teige, and containing ½ quarter.


*woods*


There are woods there called Barrinwreley[401](javascript:footNote('E580000-001/note401.html')) woods in which there is timber.


Sum of the lands of Teige mcPhillippe O Kaell in Poblemynterquillan: ½ quarter.


¶67] *The Earl's chargeable lands late in the possession of Richard
Onownane, surviving*.


{MS folio 48d}*Kyllrye*


The vill and lands of Kyllrye in said parish and Toghe, in the country called Muskerynownan;[402](javascript:footNote('E580000-001/note402.html')) late in the tenure of occupation of said
Richard Onownan of Muskerynownan serjeant of John ffitz Edmunde of Clone[403](javascript:footNote('E580000-001/note403.html')) co. Cork and containing 1½ quarters.


*woods*


There are divers woods there called Killrye woods in which there is timber.


Memorandum:— Kyllrye aforesaid lies waste.


*Knockakreywygg*.


The vill and lands of Knockakreywyg in said parish, toghe, country and tenure, containing ½ quarter.


*woods*


There are divers woods there called Knockakreywyg woods in which there is timber.


{MS folio 48d}Memorandum:— Knockakreywyg aforesaid lies waste.


*Droome Colloghan*


The vill and lands of Droome Colloghan in said parish country toghe and tenure containing ½ quarter.


*woods*


There are divers woods there called Droome Colloghan in which there is timber.


Memorandum:— Droome Colloghan aforesaid lies waste.


¶68] *Cowleboye*


The vill and lands of Cowleboye in said parish country and toghe; now or late in the tenure of John ffitz Edmund of Clone co. Cork and containing 1 quarter.


{MS folio 49}*woods*


There are various woods called Cowleboye woods in which there is timber.


Memorandum:— Cowleboye aforesaid lies waste.


*Gurtene garrey*


The vill and lands of Gurtenegarrey in said parish, country, toghe and tenure, containing ½ quarter.


*woods*


There are woods there called Gurtenegarrey woods in which there is timber.


Memorandum: Gurtenegarrey aforesaid lies waste.




---

p.56


*Aharraghe*


The vill and lands of Aharraghe in said parish, country, toghe and tenure; containing ½ quarter.


{MS folio 49d}*woods*


There are divers parcels of wood there called Aharraghe woods in which there is no timber.


Memorandum:— Aharraghe aforesaid lies waste.


*Ahadaghe*


The vill and lands of Ahadaghe in said parish, country, toghe and tenure, containing ½ quarter.


*woods*


There are divers woods there called Ahadaghe woods in which there is timber.


Memorandum: Ahadaghe aforesaid lies waste.


Sum of the lands of Richard Onownan in Muskery nownan aforesaid: 5 quarters.


Sum total of the Toghe of Clonehennerey 23 quarters.


¶69] *Toghe of Tawnaghe*.


{MS folio 50}*The Earl's chargeable lands in this Toghe in Trean 
Meane*.


*Meane*


The vill castle and lands of Meane[404](javascript:footNote('E580000-001/note404.html')) in the parish of Mahownaghe, country of Trean Meane and said Toghe of Tawnaghe.


*Knockan ne vean*.


A parcel of land called Knockan ne vean in said parish, country and toghe.


*Cowle le loske*


A parcel of land called Cowle le loske in said parish, country and toghe.


¶70] {MS folio 50d}*Garrane Meane*


A parcel of land called Garrane Meane in said parish, county and toghe.


*Kyllclone kleagh*


The vill and lands called Kyllclonekleaghe in said parish, country and toghe.


*Klonekurvane*


The vill and lands of Clonekurvane in said parish country and toghe.


{MS folio 51}*woods*
There are divers parcels of wood called Meane woods in which there is timber.


Memorandum: the aforesaid lands lie waste


Sum of the lands of the Earl of Desmond in Trean Meane: 2 quarters.


¶71] *The Earl's chargeable land late in possession of Thomas Cam,
lord of Clenlesse who died under protection*.




---

p.57


*Nohonagh*


The vill and land of Nohonaghe in said parish country and Toghe containing 1 quarter.


{MS folio 51d}*Clonefernaghe*


The vill and land of Clonefernaghe in said parish country and toghe, containing 1 quarter.


There are parcels of wood there called Nohanagh woods and Clonefernaghe woods in which there is timber.


Sum of the lands of Thomas Cam, lord of Clenlesse in Trean Meane 2 quarters.


¶72] *Groman moore*


The vill and land of Groman Moore in the parish of Aglassnegroman[405](javascript:footNote('E580000-001/note405.html')) in the country of Treanfaltaghe in said toghe and containing 40 acres.


*Groman ne modagh*.


A parcel of land called Groman ne Modaghe in said parish country and toghe containing 40 acres.


{MS folio 52}*Aglassne groman*


The vill and land of Aglassnegroman in said parish country and toghe containing 40 acres.


¶73] *Awylke*


The vill and land of Awylke in said parish country and toghe containing 40 acres.


*Clonlomenotagh*


The vill and land of Clonelomenoghtaghe in said parish country and toghe containing 20 acres.


{MS folio 53}*Gurten on Yeltane*.


The vill and land of Gurten on Yeltane in said parish country and toghe containing 20 acres.


*Gurten on Yeltane*


A parcel of land called Clonemoore in said parish country and toghe containing 40 acres.


There are divers woods containing timber


Memorandum: said parcels of land lie waste


Sum of the lands of Thomas Cam, lord of Clenlesse in Trean faltaghe: 3 quarters.


¶74] *The Earl's chargeable lands late in the possession of Phillipp 
mcGibbon who is surviving but without pardon or protection*.


*Clonesherin*


The vill and land of Clonesherin in the parish of Mahownaghe country of Trean Tawnaghe and toghe of Tawnaghe containing 30 acres.


{MS folio 53d}*Monelenagh*


The vill and land of Monelenaghe similarly situated: 30 acres.


*Ballymollen*


The vill and land of Ballymollen similarly situated: 15 acres.


*Ballynekylley*


The vill and land of Ballynekylley similarly situated: 40 acres.


¶75] *Lyskyllyn Gortskeaghe Gurtenlinugh Ballinekylley.*


*Two currghes.*


The vill and land of Lyskyllyn similarly situated: 100 acres.


{MS folio 54}*Clonedyne and Clonfert*


The vill and land of Clonedehyne alias Clonedigan similarly situated: 20 acres.


*Ballynuskeye*


The vill and land of Ballynuskeye similarly situated: 20 acres.


{MS folio 54d}*Kylredare and Ballikillin*


The vill and land of Kyllreader similarly situated: 30 acres.




---

p.58


¶76] *Dyngan more and Dyngan beg*


The vill and land of Dyngan similarly situated: 20 acres.


*Ballynbrannyg*


The vill and land of Ballinbrannygg alias Welshestowne similarly situated: 15 acres.


{MS folio 55}*woods*


There are divers parcels of wood and underwood there in which there is timber viz:— Kyllclonsherin, Kyllmonelenagh, Kyllballymollen, Kyllballynekylley, Kylllyskyllyn, Kyllclonedehyne, 
Kyllballynuskey, Dyrrenkyllreder and Kylldyngan.


{MS folio 55d}*Royalties*


There is an "Ayrie of Goshawks[406](javascript:footNote('E580000-001/note406.html')) at Kyllclonesherin.


Sum of the lands of Phillipp Gibbon in Trean Tawnagh. 4 quarters.


Memorandum: the said 4 quarters in Trean Tawnagh lie waste.


Sum total of the Toghe of Tawnaghe 11 quarters.


*Toghe of Gortcolligon*.


¶77] {MS folio 56}*The Earl's chargeable land in this toghe formerly in possession of London of Cowlerush, executed by the Earl for felony*.


*Cowlerushe* 


The vill and land of Cowlerushe in the parish of Ballingarry.[407](javascript:footNote('E580000-001/note407.html'))


*Shanecloghe*


A parcel of land called Shanecloghe OCowlerushe otherwise the old Stone in Cowlerushe similarly situated.


*mill*


There is there a water mill called Moollyn cowlerushe or the water mill of Cowlerushe waste and ruinous. Said premises contain 2½ quarters.


*woods*


There is a parcel of wood there called Kyllkolrush in which there is timber.


Memorandum: the said 2½ quarters lie waste.


Sum of the lands of London of Cowlerushe in said toghe 2½ quarters.


¶78] {MS folio 56d}*The Earl's chargeable land in this toghe late in the of Thomas mcPhillipp of Ballinlyne, surviving*.


*Ballynlyne*


The vill and land of Ballynline[408](javascript:footNote('E580000-001/note408.html')) in Ballingarry parish containing 1 quarter.


*Dorrelesse*


The vill and land of Dorrelesse: like situation and extent.




---

p.59


*Kyllmore*


The vill and land of Kyllmore: like situation and extent.


*woods*


There are there divers woods and underwoods called Kyllballynlyne, Kylldorrelesse and Curragh ne Kyllmoore in which there is timber.


{MS folio 57}Memorandum: these lands of Thomas mcPhillippe all lie waste.


Sum of the lands of said Thomas mcPhillipp in Toghe Gortcolligon 3 quarters.


¶79] *The Earl's chargeable land in this Toghe late in possession of 
John Supple of Kyllmucko slain in rebellion*.


*Grannagh*


The vill and land of Grannaghe in Ballingarry parish containing 1 quarter


*Kyllatell*


The vill and land of Kyllatell: like situation and extent.


{MS folio 57d}*Lysdowane*


The vill and land of Lysdowane: like situation and extent.


*mill*


A water mill there, belonging to said quarter, lying in Kyllmuckoo.


*Killyought*


The vill and land of Kyllyought: like situation and extent as Grannaghe.


{MS folio 58}*Ballyvologe*


The vill and land of Ballyvologe: like situation and extent.


*Ballyconyllagh*


The vill and land of Ballyconyllagh: like situation and extent.


¶80] *Ballinhahagh*


The vill and land of Ballinhahagh: like situation and containing ½ quarter.


{MS folio 58d}*Ballywohyll*


The vill and land of Ballywohyll: like situation and containing ½ quarter.


*Ballyroo*


The vill and land of Ballyroo: like situation and containing 20 acres.


*Ballyferis*


The vill and land of Ballyferis: like situation and containing 20 acres.


*Kyllbegg*


The vill and land of Kyllbegg: like situation and containing 29 acres.


These premises Ballyroo, Ballyferis and Kyllbegg contain 1 quarter *which probably includes Lyssbane containing 11 acres.*[409](javascript:footNote('E580000-001/note409.html'))


{MS folio 59}There are, two parcels of land called Curragh ne Grana and Curragh ne Lysdan in both of which there is timber.


Memorandum:— these parcels aforesaid lie waste.


Sum of the lands of John Supple of Kyllmucko in said Toghe: 9 quarters




---

p.60


¶81] *The Earl's chargeable land in said Toghe late in possession of 
Richard mcThomas of Lysemoto, surviving*.


*Lysemoto Boddestoke*


The vill and land of Lysemoto in Ballingarrey Parish and the vill and land with the castle of Boddeskoke[410](javascript:footNote('E580000-001/note410.html')) in same parish, both together containing 1 quarter.


{MS folio 59d}*mill*


A water mill there in Boddestoke aforesaid. The vill and land of Gortnefohee in Ballingarry parish containing ½ quarter.


*woods*


There are 3 parcels of wood viz Kyllbodestocke, Lyssemoto woods and Kyllgortnefohe woods in which there is timber.


Memorandum: these parcels aforesaid lie waste


Sum of the lands of said Richard mcThomas in Toghe Gortcollegan 1½ quarters.


¶82] {MS folio 60}*The Earl's chargeable land in said Toghe late in the possession of David ffitz John roe Lacy of Ballygrynan who died in rebellion*.


*Ballygrynan*


The vill and land of Ballygrynan in Ballingarry parish containing 1 quarter.


*woods*


There are divers woods and underwoods there called Ballygrenan woods in which there is timber.


Memorandum: this quarter of land lies waste.


Sum of the lands of said David ffitz John roe Lacey aforesaid: 1 quarter.


¶83] *The Earl's chargeable land in said Toghe late in the possession
of Garrett Balluffe of Gragencurran who died in rebellion*.


*Gragen Curragh*


The vill and land of Gragencurragh in Ballingarry parish containing 1 quarter.


{MS folio 60d}*woods*


A parcel of wood and underwood called Curragh Gragencurraghe in which there is timber.


Memorandum: this quarter lies waste.


Sum of the lands of Garrott Balluffe in Gragencurra: 1 quarter.


¶84] *The Earl's chargeable land in said toghe late in possession of
John Lacy of Ballingarry, surviving*.


*Kyllmake nerle*


The vill and land of Kyllmackenerle in Ballingarry parish containing 1 quarter.


*Ballygylletagle*


The vill and land of Ballygylletagle: same situation and extent.


{MS folio 61}*woods*


Certain wood and underwood called Kyllballygyllytagle in which there is timber.


*Ballyneale*


The vill and land of Ballyneale: same situation and containing 53 1/3 acres.


*woods*


A parcel of wood and underwood belonging thereto called Parkballyneale in which there is timber.




---

p.61


*Cappakane*


The vill and land of Cappakane: similar situation and extent as Ballyneale.


{MS folio 61d}*Kyllvohoge*


The vill and land of Kyllvohoge: similar situation and extent.


¶85] *Kyllmehele*


The vill and land of Kyllmehele: similar situation and extent.


memorandum:— this parcel lies waste.


{MS folio 62}*Cloneregan*


The vill and land of Cloneregan: like situation and extent.


memorandum: this parcel in Cloneregan is inhabited.


*Ballingarrey Rylane*. Mill


The vill and land of Ballingarrey with a castle: like situation and extent: and a parcel thereof called Ryllane on which Ballingarrey castle is built together with a garden or orchard: and another 
parcel thereof being a water mill called Ballyngarre mylne belonging to said castle of Ballingarrey built on {MS folio 62d} Rylane as aforesaid.


Memorandum: said parcel of 53[frac13] acres in Ballingarry Rylane and the mill there is manured and inhabited.


Sum of the lands of John Lacey of Ballingarrey aforesaid 6 quarters


¶86] *The Earl's chargeable lands in this toghe belonging to himself*.


*Ballyellane*


The vill and land of Ballyellane in the parish of Ballingarry containing 1 quarter.


*Ballynasse*


The vill and land of Ballynasse alias Wastowne: like situation and extent.


{MS folio 63}*Ballyworroh*


The vill and land of Ballyworrogho: like situation containing ½ quarter.


*Farren tancklen*


The vill and land of Farrentancklen:[411](javascript:footNote('E580000-001/note411.html')) like situation and extent as Ballyworrogho.


*Furrentegen*


The vill and land of Farrentegen, and


*Shraden rudderey*


a parcel called Shradenrudderye alias the Knight's Street in Ballingarry with divers waste pieces of old buildings and with the crofts gardens and appurtenances belonging thereto: situate in Ballingarry parish and together containing ½ quarter.


{MS folio 63d}*Molend Rudderye*


A parcel called Mollyn rudderye alias the Knight's "mylne" in Ballingarry aforesaid.


Memorandum: these parcels containing 3½ quarters lie waste.


Sum of the lands of the Earl of Desmond in Toghe Gortculligon: 3½ quarters.




---

p.62


¶87] *The Earl's chargeable lands in this Toghe late in the possession 
of Pierce oge Lacye of Brooffe, surviving*.


*Dorrocloghe*


The vill and land of Dorrocloghe with a ruinous castle in Ballingarry parish containing 2 carucates or quarters.


{MS folio 64}*Motoghe*


The vill and land of Motoghe: like situation and containing 1 quarter.


*Kyllmokedun*


A parcel of land called Kyllkomedan: like situation and extent.


*Ballyn Rankeye*


A parcel of land callen Ballen Rankeye: like situation and extent.


*woods*


There are certain parcels of land called Kyllglantanna netonnaha and Kyllglannedunnacloghe in which there is timber.


Memorandum: these parcels aforesaid lie waste.


Sum of the lands of Pierce oge Lacye of Brooffe in Toghe Gortcullygan 5 quarters.


¶88] {MS folio 64d}*The Earl's chargeable land in this toghe late in the possession of John Leo of Lyskanned, surviving*.


*Lyskanned*


The vill and land of Lyskanned in the parish of Ballingarrey containing 1 quarter.


Certain wood and underwood belonging thereto called Kyllyskanned in which there is timber.


memorandum: this quarter lies waste.


Sum of the land of John Leo of Lyskanned in said Toghe: 1 quarter.


¶89] *The Earls chargeable land late in the possession of Rorie
mcShehie of Ballyeleynan, surviving*.


*Ballinrogye*


The vill and land of Ballinrogye with a castle in said parish and toghe containing 1 quarter.


Memorandum: this quarter is manured and inhabited.


Sum of the lands of Rorie mcShehie in said Toghe of Gortculligon: 1 quarter.


¶90] {MS folio 65}*The Earl's chargeable land in said Toghe late in the possession of David Encorig[412](javascript:footNote('E580000-001/note412.html')) lord of the Great woode called Kyllmore[413](javascript:footNote('E580000-001/note413.html')) who died in rebellion*.


*Clonellare*


The vill and land of Clonellarre in said parish and Toghe containing ½ quarter.


*Ballykeavan*


A moiety of the vill of Ballykeavan: like situation and extent.


*woods*


Certain wood and underwood called Kyllglan Bally Keavan in which there is timber.


Memorandum: these parcels lie waste.


Sum of the lands of David Encorig aforesaid in Toghe Gortcullcgon: 1 quarter.




---

p.63


¶91] {MS folio 65d}*The Earl's chargeable land in said Toghe late in the possession of James ogo Nashe of Asketten, surriving*.


*Ballykeavan*


A moiety of the vill and land of Ballykeavan: like situation and extent as above moiety.


*woods*


Certain wood and underwood called Kyllglanballykeavan in which there is timber.


Memorandum: this parcel lies waste.


Sum of the lands of said James oge Nashe in Toghe Gortculligon : ½ quarter.


¶92] *The Earl's chargeable land in this Toghe late in the possession 
of Richard[414](javascript:footNote('E580000-001/note414.html')) ffitzWilliam slain in rebellion*.


*Ballynehahaghe*


The vill and land of Ballynehahaghe in said parish and Toghe containing ½ quarter.


*woods*


Certain wood and underwood called Kylleysscappalassawre in which there is timber


{MS folio 66}*Royalties*


There is a stone quarry there.


memorandum: said parcel of land lies waste


Sum of the lands of Richard ffitz William in Toghe Gortculligon: ½ quarter.


Sum of the Toghe of Gortculligon: 36 ½ quarters.


¶93] *Toghe of Olybane.*


{MS folio 66d}*The Earl's chargeable land in this Toghe late in 
the possession of Owin mc Brian slain in rebellion*.


*Carrowe moore*


The vill and land of Carrowmoore otherwise called the great quarter in the parish of Kyllcolman[415](javascript:footNote('E580000-001/note415.html')) containing 1 quarter.


*woods*


Certain wood and underwood called Kyllcarrowemoore in which there is timber.


Memorandum: this parcel lies waste.


Sum of the lands of Owin mcBrian in this Toghe: 1 quarter.


¶94] *The Earl's chargeable land in this toghe late in the possession
of Henry ffitz James, surviving*.


*Gortnekrehye*


The vill and land of Gortnekrehye in said parish containing 2 quarters


*woods*


Certain wood and underwood called Kyllgortnekrehye in which there is timber.


{MS folio 67}Memorandum: this parcel lies waste.


Sum of the lands of Henry ffitz James in said Toghe 2 quarters.


¶95] *The Earl's chargeable land in this Toghe late in the possession
of Gerald ffitzWilliam of Clonekahaghe, surviving*.




---

p.64


*Bally hahell*


The vill and land of Ballyhahell in said parish containing 1 quarter.


*woods*


Certain wood and underwood called Kyllballyhahell in which there is timber.


memorandum: this parcel lies waste.


Sum of the lands of said Gerald in the Toghe of Olybane: 1 quarter.


¶96] *The Earl's chargeable land in this Toghe late in the possession
of John Supple of Kyllmucko slain in rebellion*.


*Ballymocky more*


The vill and land of Ballymockymore in said parish containing ½ quarter.


*Ballymuckybegg*


The vill and land of Ballymuckybeg; like situation and extent.


{MS folio 67d}*woods*


Certain woods and underwoods there called Kyllballymuckye and Curragh ne mannogh in which there is timber.


Memorandum: these parcels lie waste.


Sum of the lands of John Supple in said Toghe: 1 quarter.


¶97] *The Earl's chargeable land in said Toghe late in possession of
David en Corig lord of the Great wood who died in rebellion*.


*Downe berran*


The vill and lands of Downeberran in said parish containing ½ quarter.


{MS folio 67}*Underwoods*


There are certain underwoods but there is no timber.


Memorandum: said parcel lies waste.


Sum of the lands of David en Corig lord of Kyllmoore in said Toghe of Olybane: ½ quarter.


¶98] *The Earl's chargeable land in this Toghe late in the possession
of John Lacey of Ballingarrey*.


*Bealldorrod*


The vill and land of Bealldorrod in said parish containing ½ quarter.


*woods*


Certain wood and underwood there called Kyllbealldoerod in which there is timber.


Memorandum: this parcel lies waste.


Sum of the lands of John Lacey aforesaid in said Toghe of Olybane ½ quarter.


¶99] {MS folio 67d}*The Earl's chargeable land in this Toghe late in possession of Nicholas ffitzWilliam, receiver general, slain in rebellion*.


*Ballyea*


The vill and land of Ballyea in said parish containing 1 quarter.




---

p.65


*Ballynlahaghe*


The vill and land of Ballynlahaghe: like situation and extent.


*Kyllcollman*


The vill and land of Kyllcollman: like situation and containing ½ quarter.


*Ballyhaell*


The vill and land of Ballyhaell: like situation and containing ½ quarter.


{MS folio 68}*There are divers woods and underwoods called
Kyllolebane in and belonging to these four vills.*


*Swytrasse*


The vill and land of Swytrasse: like situation and containing 1 quarter.


*Ardebegh laghe*


The vill and land of Ardebeghlaghe alias Ardebehallaghe in the parish of Rathkeall, containing 1 quarter.


*Royalties*


There is a quarry for "Myllstones" within the land of Ballyea


Memorandum: these parcels lie waste.


Sum of the lands of Nicholas ffitzWilliam receiver general, in the Toghe of Olybane 5 quarters.


¶100] {MS folio 68d}*The Earl's chargeable land in this Toghe late in the possession of Richard oge White, surviving*.


*Logheill*


The vill and land of Logheill in the parish of Rathkeally containing 1 quarter.


*Underwoods*


There are divers parcels of underwood there but no timber.


Memorandum: this quarter lies waste.


Sum of the land of Richard oge White in Toghe of Olybane: 1 quarter.


¶101] *The Earl's chargeable lands in this Toghe late in the possession 
of Rorie McShehie, surviving*.


*Ballyalenan*


The vill and land of Ballyalenan with a castle in the parish of Kyllcollman containing 1 quarter


{MS folio 69}*Curranegehee*


A parcel of this quarter is called Curra ne gehee otherwise the wood of the Spears


memorandum:— these lands are inhabited and manured.


*Ballynmynter*


The vill and land of Ballynmynterroerke in the parish of Rathkealye containing 2 quarters.


*wood*


Certain woods and underwoods there called Bellatyvolloke in which there is timber.


Memorandum:— this parcel called Ballymynter roerke lies waste.


Sum of the lands of Rorie mcShehie in the Toghe of Olybane: 3 quarters.


¶102] {MS folio 69d}*The Earl's chargeable lands in this Toghe late in the possession of Richard Rydall who died in rebellion*.




---

p.66


*Rahennahan*


The vill and land of Rahennahan in the parish of Rathkeally containing 1 quarter.


*wood*


There are divers woods and underwoods called Rahennahan woods in which there is timber.


Memorandum: this quarter lies waste.


Sum of the land of Richard Rydall in the Toghe of Olybane 1 quarter.


¶103] *The Earl's chargeable land in this Toghe late in the possession 
of Maurice ffitz Edmunde, surviving*.


*Rathkealye*


A parcel of the vill and land of Rathkealye in the parish of Rathkealye containing 1 quarter 30 acres.


There are no woods or underwoods.


{MS folio 70}Memorandum: it is doubtful whether this parcel of
land is waste or otherwise.


Sum of the lands of Maruice ffitz Edmunde in Toghe Olybane: 1 quarter 30 acres


¶104] *The Earl's chargeable land in this Toghe late in the possession 
of Patrick Woolffe slain in rebellion*.


*Rathkeale*


Part or parcel of the vill and land of Rathkeale in Rathkeale parish containing 50 acres.


memorandum: this parcel of land is inhabited.


The vill and land of Ballywilliam with 2 orchards, like situation containing 2 quarters.


*wood*


There are divers woods and underwoods called Droomen Ballywilliam in which there is timber.


Memorandum: this parcel of land lies waste.


Sum of the lands of Patrick WoolfFe in the Toghe of Olybane: 2½ quarters 10 acres.


¶105] {MS folio 70d}*The Earl's chargeable land in this Toghe being lands of the Earl himself*.


*Droomearde*


The vill and lands of Droomearde: like situation containing 1 quarter.


*woods* 


There are divers woods and underwoods there called Dromearde woods in which there is timber.


Memorandum: this quarter lies waste overgrown with woods.


Sum of the lands of the Earl of Desmond in the Toghe Olybane: 1 quarter


Sum total of the Toghe of Olybane 21 quarters


¶106] {MS folio 71}*Toghe of Croghe*


The Earl's chargeable lands in this Toghe late in possession of Thomas mcRedmond roe Wall of Boherbradagh who died before the rebellion without heir.


*Kylltennan*


The vill and land of Kylltennan in the parish of Croghe containing 1½ quarters.


There are divers woods and underwoods there called Kyltennan woods in which there is timber


Memorandum: this parcel of land lies waste.


Sum of the lands of Thomas mc Redmonde roe Wall in said Toghe of Croghe ½ quarter.




---

p.67


¶107] *The Earl's chargeable lands in this Toghe late in possession 
of Ulligg Faltaghe alias Wall, slain in rebellion*.


*Kylltennan lee*


The vill and land of Kylltennan lee in said parish containing 1½ quarters.


*woods*


There are divers woods and underwoods were called Kylltennan lee woods in which there is timber.


{MS folio 71d}Memorandum: Kylltennan lee lies waste.


Sum of the lands of Uligg Wall alias Faltaghe in said Toghe: 1½ quarters.


¶108] *The Earl's chargeable land in this Toghe late in the possession of Thomas mc Rudderye who was executed at Limerick*.


*Croghnemore*


The vill and land of Croghnemoregez[416](javascript:footNote('E580000-001/note416.html')) in said parish containing 2½ quarters.


*Dyrrene Gawogg*


A parcel of land called Dyrrenegawogg similarly situated. This is a portion of the previous 2½ quarters


{MS folio 72}*Ballingowle*


The vill and land of Ballingowle with a ruinous castle similarly situated containing 1 quarter.


*Deriskilloghe*


A parcel of land and wood called Derriskylloghe: like situation and containing 1½ quarters.


*Cloghtredboye*


The vill and land of Cloghkotred boy with a castle: like situation and containing 1 quarter.


*Lysnemuckye*


The vill and land of Lysnemuckye: like situation and containing 1 quarter.


{MS folio 72d}*Ballyogoughlan*.


The vill and land of Ballyogoughlan: like situation and extent.


*Ballyaducke*


The vill and land of Ballyaducke: like situation and extent.


*woods*


There are certain woods there called Kyllvargy.


Memorandum: these lands are well wooded but lie waste.


Sum of the lands of Thomas mcRudderey called Knight of the valley in this toghe 8 quarters.


¶109] {MS folio 73}*The Earl's chargeable land in this Toghe late in the possession of Pierce Purcell of Crogh*.


*Shanecourte*


The vill and land of Shanecourte alias Oldcourt with a castle in said parish containing: 1 quarter.


*Garrocloen moore*


The vill and land of Garrocloenmore: like situation containing ½ quarter.




---

p.68


*Garrocloenbegg*


The vill and land of Garrocloenbegg: like situation and extent.


*Ballyolyne*


The vill and land of Ballyolyne: like situation and extent.


{MS folio 73d}*Gareballye*


The vill and land of Gareballye alias the Short town: like situation and extent.


*Ballygussan*


The vill and land of Ballygussan: like situation containing 60 acres.


*Bally Yeaghan*


The vill and land of Ballyyeaghan:like situation containing ½ quarter


*Enagh roo*


The vill and land of Enagh roo: like situation containing 1 quarter.


{MS folio 74}*woods*


There are certain parcels of wood and underwood there called Kyllpursell in which there is timber: there are other parcels called Kylladame in which there is timber.


Memorandum: these lands are very well wooded but lie waste.


Sum of the lands of Pierce Pursell of Croghe in said Toghe: 5 quarters 20 acres.


¶110] *The Earl's chargeable land in this Toghe late in the possession
of Maurice mcEdmonde Sarcell, surviving*.


*Omogan moore*


The vill and land of Omogan moore with a castle in Croghe parish containing 1 quarter.


*Omogan begg*


The vill and land of Omogan begg: like situation containing 60 acres.


{MS folio 74d}*Garran*


The vill and land of Garran: like situation, containing ½ quarter.


*Clonemore*


The vill and land of Clonemore: like situation and extent.


*Ballynemucka*


The vill and land of Ballynemucka: like situation and extent.


*woods*


There are divers woods and underwoods there called Parck Omogan in which there is timber.


Memorandum: these parcels of land lie waste.


Sum of the lands of Maurice mcEdmund Sarcell in this Toghe: 3 quarters 20 acres.


¶111] {MS folio 75}*The Earl's chargeable land in this Toghe late in the possession of'Edmund mcMorris Hubbert, surviving*.


*Balywyryg*


The vill and land of Ballynwyryg in Croghe parish containing 1 quarter.




---

p.69


*woods*


There are divers woods and underwoods there called Ballinwyryg woods in which there is timber.


Memorandum: this quarter lies waste.


Sum of the lands of Edmund mcMorris Hubert in this Toghe: 1 quarter


Sum total of the Toghe of Croghe 20 quarters


¶112] {MS folio 75d}*Toghe of Nantenan. The Earl's chargeable land in this Toghe late in possession of Richard London of Callowe, surviving*.


*Ardgowlebeg*


The vill and land of Ardegowlebegg with a ruinous castle in the parish of Nantenan and containing 1 quarter.


*Ballynegurran*


The vill and land of Ballynegurran: like situation, containing 2 quarters.


*Doheill moore*


The vill and land of Doheillmore: like situation, containing 1 quarter.


*Doheill begg*


The vill and land of Doheill begg: like situation and extent


{MS folio 76}*Callowe*


The vill and land of Callowe with a ruinous castle: like situation, containing 1 quarter 20 acres.


*Ballyperce*


The vill and land of Ballyperce: like situation and containing ½ quarter.


¶113] *Ballyhonnyck*


The vill and land of Ballyhonnycke: like situation and containing 20 acres.


*Ballyhebyn*


The vill and land of Ballyhebyn: like situation and extent.


{MS folio 76d}*Ballyworyshyn*


The vill and land of Ballyworyshyn: like situation.


*Ilanballyworyshen*


There is an island there called Ilan ballyworyshen


*Loghballyworyshen*


and a Lough called Loghballyworishen. The premises contain 20 acres.


*Ballintetrahalycke*


The vill and land of Ballentetrahalick: like situation and extent.


{MS folio 77}*Nagragaghe*


The vill and land of Nagragaghe: like situation, containing ½ quarter


*woods*


There are divers parcels of wood and underwood and in Ardegowlebeg there is timber.


Memorandum: all these parcels lie waste.


Sum of the land of Richard London of Callowe in said Toghe: 8 quarters 20 acres.




---

p.70


¶114] *The Earl's chargeable land in this Toghe late in possession of
Mahownde boye mcTirrelaghe mcDonnogho, surviving*.


*Ballyn vearick*


The vill and land of Ballynvearyck in said parish of Nantenan containing 20 acres.


{MS folio 77d}Memorandum: it is doubtful whether it is inhabited or not.


Sum of the land of Mahownde boye in said Toghe of Nantenan: 20 acres.


¶115] *The Earl's chargeable land late in possession of Tyrrelaghe 
mc Bryan, surviving*.


*Curreyne sleddye*


The vill and land of Curreynesleddye in the parish of Nantenan in Cowgonormotingaghe[417](javascript:footNote('E580000-001/note417.html')) and containing 1 1/3 quarters.


*woods*


There are certain woods and underwoods there called Bellaghnecullenaghe in which there is timber.


Memorandum: it is doubtful whether this parcel is inhabited or lies waste.


Sum of the land of Tyrrelaghe mcBryan in the Toghe of Nantenan 1 1/3 quarters.


¶116] {MS folio 78}*The Earl's chargeable land in this Toghe late in possession of Bryan mc Donnogh, surviving*.


*Dyrreye*


The vill and land of Dyrreye: like situation and extent.


*woods*


There are divers woods and underwoods there called Kyllderrey yeaghtagh alias Dyrrey woods in which there is timber.


Sum of the lands of Bryan mcDonnogh in Nantenan Toghe: 1 1/3 quarters.


¶117] *The Earl's chargeable land in this Toghe in possession of the 
Earl himself*.


*Bologlasse*


The vill and land of Bologlasse: like situation and extent.


Memorandum: this parcel of land lies waste: thereon are divers woods and underwoods called Bolloglasse woods wherein is much timber.


Sum of the land of the Earl of Desmond in Nantenan Toghe: 1 1/3 quarters.


¶118] {MS folio 78d}*The Earl's chargeable land in this Toghe late in possession of William oge Englande, surviving*.


*Ballyvackgoke*


The vill and land of Ballyvockgoke in Nantenan parish containing ½ quarter.


*woods*


There are divers woods and underwoods called Ballyvockgoke in which there is timber.


Memorandum: it is doubtful whether this land is inhabited or lies waste.


Sum of the land of William oge Englande in Nantenan Toghe: ½ quarter.


¶119] *The Earl's chargeable land in this Toghe late in possession of
Muarice Lee called the Earl's physician, surviving*.




---

p.71


*Ardegowle moore*


The vill and land of Ardegowlemoore with a castle built up in Nantenan parish, containing 2 quarters.


*Mill*


A water mill there built on the river Dylebegg[418](javascript:footNote('E580000-001/note418.html'))


{MS folio 79}*woods*


There are divers underwoods belonging to Ardegowlemoore but no timber.


Memorandum: these 2 quarters are manured and inhabited.


Sum of the lands of Maurice Lee called the Earl's Doctor in said Toghe: 2 quarters.


¶120] *The Earl's chargeable land in this Toghe late in possession of
Richard Wall, surviving*.


*Cloghkatred*


The vill and land of Cloghkatred in the parish of Rathkealy containing 2 quarters.


*woods*


There are divers woods and underwoods there called Cloghkatred in which there is timber.


There is in the vill of Cloghkatred a mine of metal still unknown but supposed to be gold or silver.


Sum of the land of Richard Wall in said Toghe: 2 quarters.


¶121] {MS folio 79d}*The Earl's chargeable land in this Toghe late in possession of John Lacey of Ballyngarry surviving*.


*Inchemoore*


The land and vill of Inchmoore[419](javascript:footNote('E580000-001/note419.html')) in the parish of Nantenan containing ½ quarter.


*woods*


There are divers woods and underwoods called Inchmoore woods in which there is timber.


Memorandum: this parcel of land lies waste.


Sum of the lands of John Lacey in this Toghe ½ quarter.


¶122] *The Earl's chargeable land in this Toghe late in possession of 
Maurice mcEdmond Hubbert of Rathkealy surviving*.


*Rathkeale*


The vill and land of Rathkeale with a castle in the parish of Rathkealy containing 2½ quarters.


*Woods*


There are divers woods and underwoods in which there is timber.


Memorandum: this parcel of land is inhabited.


Sum of the land of Maurice 2½ quarters mcEdmunde Hubert, aforesaid


{MS folio 80}Sum total of the Toghe of Nantenan 20 quarters.


¶123] *Toghe of Asketten. The Earl's chargeable land in this Toghe late in possession of Richard[420](javascript:footNote('E580000-001/note420.html')) ffitz William, slain in rebellion.*


*Athlyne*


The vill and land of Athlyne in Clonelty parish country of Treanmoreyneye containing 1 quarter.


*Ballin Browne*


The vill and land of Ballenbrowne alias Brownestowne: like situation and extent.




---

p.72


*wood*


There are divers woods and underwoods there called Kyllcroye[421](javascript:footNote('E580000-001/note421.html')) 
alias harde woode in which there is timber.


Memorandum: these 2 quarters lie waste.


Sum of the lands of Nicholas ffitz William in said Toghe: 2 quarters.


¶124] {MS folio 80d}*The Earl's chargeable land in this Toghe late in possession of Owen mcEdmunde mcShehee slain in rebellion*.


*Kyllgullobon*


The vill and land of Kyllgullobon: like situation and extent.


*woods*


There are divers woods and underwoods called Parke Kylgulbane in which there is timber.


*Kylltanna*


The vill and land of Kylltanna: like situation and extent.


memorandum: the said lands all lie waste.


Sum of the lands of Owen mcEdmunde mcShehee in the Toghe of Asketten.: 2 quarters.


¶125] {MS folio 81}*The Earl's chargeable land in this Toghe late in possession of Rorie mcShehee, surviving*.


*Knockadyrrey*


The vill and land of Knockadyrrey: like situation and extent.


*Ballinboscarye*


The vill and land of Ballynboscarye: like situation and extent.


*Lyslegustye*


The vill and land of Lyslegustye: like situation and extent.


*Ballycollman*


The vill and land of Ballycolman: like situation and containing ½ quarter.


{MS folio 81d}Memorandum: said parcels are thought to lie waste.


*Ballybegg mcThomas*


The vill and land of Ballybegg mcThomas: like situation, containing 13 acres.


*Carraghan*


The vill and land of Carraghan: like situation and extent.


*woods*


There are divers woods there called Dyrrey-Knocke dirrey woods but no timber.


Sum of the lands of Rorye mcShehee in the Toghe of Asketten: 3 ½ quarters 26 acres.


¶126] {MS folio 82}*The Earl's chargeable land in this Toghe late in possession of Robert oge Cusshen, slain in rebellion*.


*Lyscorrp*


The vill and land of Lyscorro: like situation and




---

p.73


*Ardefynnan*


the vill and land of Ardefynnan: like situation. The two denominations contain 1 quarter.


*woods*


There is a parcel of wood belonging to Lyscorro called Omolane elowrone in which there is timber.


*Ballyrobuck*


The vill and land of Ballyrobucke: like situation containing ½ quarter.


*woods*


There are divers woods and underwoods belonging to said lands and parcel of Bollaroo belongs to them.


Memorandum: the said parcels of land all lie waste.


Sum of the lands of Robert oge Quisshen in Asketten Toghe 1½ quarters.


¶127] {MS folio 82d}*The Earl's chargeable land in this Toghe late in possession of Garrott duffe mcDavid oge Crone, surviving*.


*Rathbriley*


The vill and lands of Rathbriley: like situation containing ½ quarter


*Lysenuskeye*


The vill and land of Lysenuskeye: like situation and extent.


{MS folio 83}*Ballybeg mcdegon*


The vill and land of Ballybegg mcdegon: like situation, containing 54 acres


*woods*


There are certain woods and underwoods, all containing timber viz Kyllrathbryle, Kylllysenuskeye and Kyll ballybegg mcdegon.


Memorandum: these parcels all lie waste.


Sum of the lands of Garrott duffe mcDavid oge Crone aforesaid 1½ quarters 14 acres


¶128] *The Earl's chargeable land in this Toghe late in possession of Rorie mcShehee, surviving*.


*Cloghena ralta*


The vill and land of Cloghenaralta with a castle in the parish of Cloghenaralta and containing 2 quarters


*woods*


Certain woods and underwoods there called Kyllkowle in which there is timber.


{MS folio 83d}Memorandum: said castle town and lands of Cloghenarulta belong to David Encorig but are in pawn with Rorye mcShehee.


*Ballynrydealye*


The vill and land of Ballynrydealye[422](javascript:footNote('E580000-001/note422.html')) in said parish containing 1 quarter.


*Toneyarraghe*


The vill and land of Toneyarraghe: like situation and extent.


*woods*


Certain woods and underwoods there called Kylltoneyerraghe in which there is no timber.




---

p.74


Memorandum: it is doubtful whether these 4 quarters do all lie waste.


Sum of the lands of Rorie mcShehee in said parish of Clqghenarulta: 4 quarters


¶129] {MS folio 83d}*The Earl's chargeable land in this Toghe in possession of the Earl himself*.


*Moynerley*


The vill and land of Moynerley in the parish Asketten containing 4 carucates or quarters.


*woods*


Certain woods and underwoods there called Moynerley woods which have no timber.


memorandum: part of these 4 quarters is inhabited, the other part lies waste.


Sum of the lands of the Earl of Desmond in Moynerley in this Toghe: 4 quarters


¶130] *The Earl's chargeable land in this Toghe late in possession of 
Thomas Englande, surviving: parcel of the 9 carucates called "dooble[423](javascript:footNote('E580000-001/note423.html')) 
quarters in the parish of Asketten*.


*Bally Englande*


The vill and land of Bally Englande alias Englandestowne in the parish of Asketten, parcel of the 9 carucates aforesaid, containing 1 quarter.


{MS folio 84d}*wood*


A parcel of land and wood called Kyllmoore Bally Englande alias the Great wood of Bally England, situate as aforesaid, in which there is timber.


memorandum: this quarter is inhabited.


Sum of the lands of Thomas Englande parcel of the dooble quarters: 1 quarter.


¶131] *The Earl's chargeable land in this Toghe [in his own possession][424](javascript:footNote('E580000-001/note424.html')) parcel of the 9 carucates called "dooble quarters.*"


*Ballyne quilleye*


The vill and land of Ballynequilleye alias Woodestowne in Asketten parish, parcel of said 9 carucates and containing ½ quarter.


*Gortsethan*


The vill and land of Gortfethan: like situation and extent.


{MS folio 85}*Ballytomen*


The vill and land of Ballytomen: like situation and extent.


*Clonelogh*


The vill and land of Cloneloghe: like situation and containing 20 acres.


*underwoods*


There are divers underwoods containing no timber.


Memorandum: these lands are in the occupation of Captain Bartlet, inhabited and fed up by his tenants of Asketten.


Sum of the lands of the Earl of Desmond in said 9 carucates called the doble quarters ½ quarter 20 acres.


¶132] {MS folio 85d}*The Earl's chargeable land in this Toghe parcel of the said 9 carucates called the "dooble[425](javascript:footNote('E580000-001/note425.html')) quarters late in possession of Moriertaghe mcMurroghe,[426](javascript:footNote('E580000-001/note426.html')) surviving*.




---

p.75


*Courtbrowno*


The vill and land of Courtebrowno alias Brownescourte with a castle in Asketten parish parcel of said 9 carucates and containing 2½ quarters.


*woods*


There are divers underwoods called Ilan Ewoghull[427](javascript:footNote('E580000-001/note427.html')) alias "the boyes Iland," but no timber.


memorandum: part of the 2½ quarters is inhabited and part lies waste.


Sum of the lands of Moriertagh in said 9 carucates called the dooble quarters ½ quarters.


¶133] *The Earl's chargeable land in this Toghe parcel of said 9 carucates called "dooble" quarters late in possession of Richard Nashe, surviving*.


*Ballynasse*


The vill and land of Ballynasse alias ({MS folio 86}) Nashestowne in Asketten 
parish, parcel of said 9 carucates, containing ½ quarter.


*Shane dyrrey*


The vill and land of Shannedyrrey: like situation.and containing 20 acres.


*woods*


Divers parcels of underwood called Dyrrey Shandyrrey in which there is no timber.


memorandum: these parcels of land lie waste.


Sum of the lands of Richard Nashe in said 9 carucates called the dooble quarters ½ quarter 20 acres.


¶134] *The Earl's chargeable land in this Toghe parcel of said 9 
carucates called the dooble quarters late in possession of James Nashe*.


{MS folio 86d}*Ballyne karra*


The vill and land of Ballynekarra in the parish of Asketten, parcel of said 9 carucates, containing 1 quarter.


*Ilan en gore*


An island belonging thereto called Ilan en gore[428](javascript:footNote('E580000-001/note428.html')) alias "goates Ilande" containing divers woods and underwoods in which there
is timber.


*woods*


Certain other woods and underwoods called Garran Ballynekarra in which there is no timber.


Memorandum: this quarter is inhabited and manured.


Sum of the lands of James Nashe in said 9 carucates called dooble quarters 1 quarter.


¶135] *The Earl's chargeable land in this Toghe parcels of the burgage 
lands of Asketten which are also parcel of said 9 carucates called the "dooble quarters" in possession of divers burgesses who are surviving*.


*Ballymoore*


The vill and land of Ballymoore in the parish of Asketten being the burgage lands aforesaid situated and in the tenure aforesaid containing 2 quarters subdivided into these subdenominations viz:—


*Tanglont. . .  
[*...*]  
 Lehesseragh Colbane*


{MS folio 87d, 88}Tanglont[429](javascript:footNote('E580000-001/note429.html')) 4 acres, Lahesseragh[430](javascript:footNote('E580000-001/note430.html')) Rahyn 20 acres, Lehesseragh Lynarde ½ quarter, Lehesseragh de Raboher 20 acres, Lehesseragh Mannagh 20 acres, Lehesseragh Lacey ½ 



---

p.76




quarter, Lehesseragh Colbane 20 acres; all of which are described as if distinct denominations.


*Woods*


No woods or underwoods in Ballymoore.


Memorandum: said lands in Ballymoore are all manured: there are no free lands of the burgesses, all are chargeable: therefore all chief rents are extinguished and the lands are to be charged.


Sum of the lands belonging to the burgesses of Asketten parcel of the 9 carucates called dooble quarters 2 quarters 4 acres.


Sum total of the Toghe of Asketten 28 quarters 4 acres.


¶136] {MS folio 88d}*Half Toghe of Lysmakerreye.
The Earl's chargeable land in this half Toghe late in possession of 
John Lacey of Balllingarrey, surviving*.


*Tullagh*


The vill and land of Tullaghe in the parish of Lysmackerrey containing 1½ quarters.


*Ballenmollen* 


The vill and land of Ballenmollen: like situation and extent.


*Conygar*


The vill and land of Conygar: like situation and containing ½ quarter.


*Creave yeragh*


A parcel of land called Creaveyeragh:[431](javascript:footNote('E580000-001/note431.html')) like situation and containing 
1 quarter


{MS folio 89}*Woods*


Divers woods and underwoods called Kyllnekreaveyeragh in which there is timber.


Memorandum: all these lands lie waste and Creaveyearaghe was always waste and never inhabited


Sum of the land of John Lacey in said half Toghe of Lysmackerrey: 4½ quarters.


¶137] *The Earl's chargeable land in said half Toghe late in possession 
of James roe Lacye executed at Limerick in the rebellion of James, ffitz Morris.*


*Lysmack erreye*


The vill and land of Lysmakerreye with a castle in said parish containing ½ quarter


*Laghbane*


The vill and land of Laghbane: like situation and containing 1 quarter


{MS folio 89d}*Creavehurragh*


A parcel of land called Creavehurragh:[432](javascript:footNote('E580000-001/note432.html')) like situation and extent.


*woods*


Woods there called Feahe ne curra lea in which there is timber.


Memorandum: these lands all lie waste and Creavehurragh was always waste and never inhabited.


Sum of the land of James reogh Lacye in said half Toghe: 2½ quarters.


¶138] *The Earl's chargeable land in this half Toghe late in possession of Edmund oge Lacye of Ballynecloghy slain in rebellion*.


*Ballynecloghye*


The vill and land of Ballynecloghy, with a castle built thereon and an orchard, situate in said parish and containing 1 quarter.




---

p.77


{MS folio 90}*Garrin farson*


The vill and land of Garrynfarson alias the parson's garden: like situation and containing 1 quarter.


*woods*


Woods and underwoods there called Feahe ne curry lea in which there is timber.


Memorandum: these lands of said Edmund are inhabited.


Sum of the lands of said Edmund oge Lacye of Ballynecloghy: 1½ quarters.


¶139] *The Earl's chargeable land in this half Toghe late in possession 
of James oge Nashe, surviving*.


*Ballycollen*


The vill and land of Ballycollen with a castle built thereon, situate in said parish and containing ½ quarter.


*Bally Ellynan*


The vill and land of Ballyellynan: like situation and containing 1 quarter.


{MS folio 90d}*woods*


Divers woods and underwoods in which there is no timber.


Memorandum: these lands all lie waste


Sum of the land of James oge Nashe in said half Toghe: 1 quarters.


Sum of the half Toghe of Lysmckerry 10 quarters.


¶140] {MS folio 90d}*Half Toghe of Drynans.*


The Earl's chargeable land in this half Toghe late in possession of Rorye mcShehee, surviving.


*Ballynekyll vradron*


A parcel of land called Ballnekyllvradron situate in the vill and parish of Kyllvradron and containing 32 acres


*Ballnegragewer*


A parcel of land called Ballnegragewer: like situation and extent.


*Ballnedyrrey*


A parcel of land called Ballnedrrey: like situation and extent.


{MS folio 91d}


*Ballballylyne*


A parcel of land called Ballballylyne: like situation and extent.


*Ballynite*


The vill and land of Ballynite: like situation and containing 1 quarter 27 acres.


*Kyllbruherughe*


The vill and land of Kyllbraheraghe: like situation and containing 48 acres


{MS folio 92}*Cloneyelgod*


The vill and land of Cloneyelgod: like situation and containing 5 acres.


*Cultomen*


A parcel of the vill of Cultomen: like situation and containing 1 quarter.




---

p.78


*woods*


There are divers underwoods but no timber.


Memorandum: it is doubtful whether all these lie waste: it is thought some are manured.


Sum of the lands of Rorye mcShehee in said half Toghe of Drynan: 5 quarters


¶141] *The Earl's chargeable land in this half Toghe late in possession of 
Ullig Wall alias ffaltugh of Dunmoylin*.


*Bullyes tyne*


The vill and land of Ballyestyne in said parish and half Toghe containing 1 quarter 27


*woods*


There are divers underwoods but no timber.


{MS folio 92d}Memorandum: this land is inhabited and manured.


Sum of the land of Ulligg Wall in said half Toghe of Drynan: 1 quarter 27 acres


¶142] *The Earl's chargeable fund in this half Toghe late in possession of Dermodo mcKnougho mcShehee surviving[433](javascript:footNote('E580000-001/note433.html')) slain in rebellion*


*Rathna gorro*


The vill and land of Rathnagorro in said parish and half Toghe containing 53 acres woods


There are divers underwoods but no timber.


Memorandum: it is doubtful whether the lands lie waste or not: it is thought they are manured.


Sum of the lands of said Dermodo in said half Toghe of Drynan: 53 acres


¶143] *The Earl's chargeable land in this half Toghe late in possession 
of David en corrigg, lord of'the "greate woode", who died in rebellion*.


{MS folio 93}*Ballyany*


The vill and land of Ballyanye in said parish and half Toghe containing 1 quarter 27 acres.


Divers woods and underwoods called Feeballyan in which there is timber.


memorandum: this parcel lies waste.


Sum of the lands of said David en Corrigg in this half Toghe 1 quarter 27 acres.


¶144] *The Earl's chargeable land in this half Toghe late in possession 
of Garrott Roe slain in rebellion*.


*Cultomen*


A parcel of the vill of Cultomen in said parish and half Toghe containing 1 quarter.


*woods*


Divers underwoods but no timber.


memorandum: these lands lie waste.


Sum of the land of Garrott Roe in said half Toghe: 1 quarter.


¶145] {MS folio 93d}*The Earl's chargeable land in this half Togh late in possession of Thomas cam lord of Clenlesse who died without pardon, under protection*.




---

p.79


*Arloman*


The vill and land of Arloman in said parish and half Toghe containing 53 acres.


Divers woods and underwoods called Kyllarloman in which there is timber, and certain others called Bellaballygwoll[434](javascript:footNote('E580000-001/note434.html')) alias the Bellagh of the coals in which there also is timber.


Memorandum: this parcel of land lies waste.


Sum of the lands of Thomas Cam in said half Toghe: 53 acres.


Sum total of the half Toghe of Drynan 10 quarters.


¶146] {MS folio 94}*Toghe of Dunmoylyn.*.


*The Earl's chargeable land in this Toghe late in possession of Ulligg 
Wall alias ffaltagh of Dunmoylyn, slain in rebellion*.


*Dunmoylyn*


The vill and land of Dunmoylyn with a castle in the parish and Toghe of Dunmoylyn containing 1 quarter.


*woods*


No woods or underwoods belonging thereto


The vill and land of Monemoell with a castle built thereon: like situation and extent.


*Woods*


There are certain woods and underwoods belonging to this quarter all of which contain timber and whose names are Kyllglansharrowen, Kyllbarneye, Kyllbreagh, Kyllbellakannig and Knockeffalintig.


{MS folio 94d}*Downecahe west*


The vill and land of Downcahe west: like situation and extent.


*Downecahe est*


The vill and land of Downecahe Est: like situation and extent.


*Ballintlabbye*


The vill and land of Ballintlabbye in the parishes of Dunmoylyn and Shannagowle in said Toghe containing 1 quarter.


*Rathcrogan*


The vill and land of Rathcrogan in the parish and Toghe of Dunmoylyn containing 1 quarter.


{MS folio 95}*Carrenmoore*


The vill and land of Carrenmoore: like situation and containing 1½ quarters.


*Carrenbegg*The vill and land of Carrenbegg: like situation and containing 
½ quarter.


*Lysbeane*


The vill and land of Lysbeane: like situation and containing 27 acres.


{MS folio 95d}*Rathfferra*


The vill and land of Rathferra: like situation and contain ½ quarter.


*Teeremoore*


The vill and land of Teeremoore: like situation and extent.




---

p.80


*woods*


Neither wood nor underwood in these 9 parcels.


memorandum: these lands of Ulligg are all inhabited and manured for the most part by Ollyver Stephensonne.[435](javascript:footNote('E580000-001/note435.html'))


Sum of the lands of Ulligg Wall alias ffaltaghe in said Toghe 9 quarters 27 acres.


¶147] *The Earl's chargeable land in said Toghe late in possession of
Conoghor oge Okonno, surviving*.


*Ballinver nelig*


The vill and land of Ballinverneligg in the parish and Toghe of Dunmoylyn containing 27 acres.


{MS folio 96}*Lysmacken*


The vill and land of Lysmacken: like situation and extent. There are no woods or underwoods there as is said.




---

p.81


Memorandum: this parcel of land lies waste.


Sum of the land of Connoghor oge Okonno in said Toghe of Dunmoylyn 54 acres.


¶148] *The Earl's chargeable land in this Toghe late in possession of
Edmund mcPhillipp of Morreregan deceased without heir as is said.*


*Morreregan*


The vill and land of Morreregan with a castle in the parish of Morreregan in said Toghe containing 3 quarters 27 acres


*woods*


Certain woods and underwoods there called Kyllmorreregan in which there is timber


*Fishing*


A fishing in the Shannon belongs to Morreregan


memorandum: this land lies waste.


Sum of the land of Edmund mcPhillipp in said Toghe of Dunmoylyn 3 quarters 27 acres.


¶149] {MS folio 96d}*The Earl's chargeable land in this Toghe late in possession of Donnell mcclankeye of Bally Roberte, surviving*.


*Cloneclare*


The vill and land of Cloneclare in the parish of Bally Robert and Toghe of Dunmoylyn containing 1 quarter.


*Bwolymoore*


The vill and land of Bwolymoore: like situation and extent.


*woods*


There are divers underwoods called Kankylley belonging to said lands in which there is no timber.


Memorandum: it is thought these lands are inhabited and the free land called Bally Roberte is manured by Mr Wingfield.


Sum of the land of Donell mcClankey in said Toghe: 2 quarters.


¶150] {MS folio 97}*The Earl's chargeable land in this Toghe in the possession of the Earl himself*.


*Foynes*


The vill island and land of ffoynes,[436](javascript:footNote('E580000-001/note436.html')) with a castle, in the parish of Bally Robarte in the Toghe of Dunmoylyn containing 54 acres.


*woods*


A parcel of wood called Kyllfoyne in which there is timber.


*Durenyshe*


The vill and land of Durenyshe: like situation and containing 27 acres


*woods*


no woods or underwoods on this land as is said.


Memorandum: this quarter is no parcel of the manor of Corgragg.


{MS folio 97d}*Corgrag*


The vill and land of Corgragg with a castle;


*Grannagh*


the vill and land of Grannaghe; and


*Belldirrig verro*


the vill and land of Belldyrrigverro parcel of the lands belonging to the castle of Corgragg. These three denominations are situate as aforesaid and jointly contain 3 quarters.


{MS folio 98}*Mine*


There is a stone quarry there.


*Fishings*


There is a fishing on the Shannan and a certain weir called Corhullen in Corgragg.


*woods*


No woods or underwoods.


¶151] *Leathe*


The vill and land of Leathe: like situation and containing 1 quarter.


Memorandum: the quarter called Leathe lies waste.


*Ballylawras*


The vill and land of Ballylawras: like situation and extent.


*woods*


No woods or underwoods.


{MS folio 98d}Memorandum: the quarter called Ballylawras lies 
waste.


Memorandum: the manor of Corgragg contains 7 quarters; 5 of these viz Ballylawras, Leathe, Belldyrrigverra, Granna and Corgragg are chargeable: the other 2 are charged among the Earl's 
free land, and the castle is built on the chargeable land.


Sum of the land of the Earl of Desmond in the Toghe of Dunmoyly 6 quarters.


¶152] *The Earl's chargeable land in this Toghe late in possession of 
Edmund London and Richard London, surviving*.


*Kyllcosgrane*


The vill and land of Kyllcosgrane[437](javascript:footNote('E580000-001/note437.html')) in the parish of Kylvoylan in the Toghe of Dunmoylyn containing 1 quarter.




---

p.82


*woods*


no wood or underwoods.


memorandum: this quarter lies waste.


Sum of the lands of Edmund and Richard London in Dunmoylyn Toghe 1 quarter.


{MS folio 99} Sum total of the Toghe of Dunmoylin 23 quarters.


¶153] *Toghe of Shanned.*


*The Earl's chargeable land in this Toghe in possession of the Earl
himself*.


*Shanned*


The vill castle[438](javascript:footNote('E580000-001/note438.html')) and land of Shanned in the parish of Kyllmoylan and said Toghe consisting of the following subdenominations viz:— Carrownecloghy, Gawer on Slelogher,[439](javascript:footNote('E580000-001/note439.html')) Knocklaboskor on Slelogher, Kullenaghe on Slelogher, and three parcels of land 
called Duranes otherwise called the three Raughts or three intrenched Rundells; which subdenominations in toto contain 4 quarters.


{MS folio 100}*Ballyhaell*


The vill and land of Ballyhaell[440](javascript:footNote('E580000-001/note440.html')) on Slelogher parcel of the manor of Shannid situate in the parish and Toghe aforesaid containing 1 quarter.


*Ballycormack*


The vill and land of Ballycormacke in said parish and Toghe containing 27 acres.


*woods.*


There are divers woods and underwoods in which there is timber on lands belonging to said manor viz: Kyllnekullenaghe on Kyllenaghe, and Bellaghnebingye on Ballyhaell.


Memorandum: these parcels of land lie waste.


Sum of the lands of the Earl of Desmond belonging to Shanned Manor in said Toghe 7 quarters 27 acres.


¶154] {MS folio 100d}*Knocknegorna*.


The vill and land of Knocknegorna on Slelogher in the parish of "Kyllmoylan in Temple Clee" in this Toghe containing 2 quarters.


*woods*


There is there a parcel of wood called Tworintogeley in which there is timber; and another wood called Clanknocknegorna.


*mines*


On this part of the mountain of Slelogher a certain iron mine of Ironstone.


memorandum: this parcel of land lies waste.


Sum of the lands of the Earl of Desmond called chargeable land in this Toghe. 9 quarters 27 acres.


¶155] *The Earl's chargeable land in this Toghe in possession of 
Morrogho mcKeaghan*.[441](javascript:footNote('E580000-001/note441.html'))


*Clonelaharde*{MS folio 101}


*Clonecoman to Laskylltofte*


A parcel of land called Clonelaharde on the mountain of Slelogher 
in the parish of Kyllmoylan in this Toghe containing 1 quarter 
and consisting of the following subdenominations viz:— 
Clonecoman, Classroo, Laskylltofte.




---

p.83


{MS folio 101d}*woods*


There are divers parcels of wood belonging to the quarter of Clonalaharde viz a parcel of wood called Glenbane in which there is timber and an eyry of Goshawkes; a part of the wood of Barney 
in which there is timber, the other part belongs to the lands of Monnemoyell quarter in the Toghe of Dunmoylyn which belong to, Ulligg Wall; and four parcels of wood, in which there is timber, called Laskylltofte, Kyllneclassroo, KyllClonecoman and Kylleynye.


*Royalties*


An eyry of Goshawks on the wood of Glenbane.


memorandum: these parcels of land all lie waste.


Sum of the lands of Morrogho mcKeaghan in Shanned Toghe: 1 quarter.


{MS folio 102}*The Earl's chargeable land in this Toghe late in 
session of Murrogho mcTyrrelaghe mcTeige*.


*Crag mcTeige, Bondnnyn Ballyknockane Molaharde*


The vill and land of Crag mcTeige in the parish of Monasterie negollagh in this Toghe; the land called Bonannyn similarly situated; the vill and land of Ballyknockane similarly situated; and the land of Mollaharde similarly situated: these four denominations jointly contain 4 quarters.


{MS folio 102d}[442](javascript:footNote('E580000-001/note442.html'))*woods*


A parcel of wood called Kyllnecraggy in which there is timber; and 3 parcels of wood in which there is timber, belonging to said four quarters and called Bellacronan, Kyllmolloharde and Kyllvomanyn.


memorandum: said 4 quarters of land lie waste.


¶157] *Fynnor*


The vill and land of Fynnor on the mountain of Slelogher in the parish of Kyllmoylan containing 1 quarter.


*woods*


A parcel of wood called Kyllfynnar, belonging to said quarter, in which there is timber.


memorandum: the quarter of Fynnor lies waste.


*Beallneglar*


The vill and land of Beallneglarr on the mountain of Slelogher, parish of Kyllvoylan and said Toghe.


*woods*


A parcel of wood there called Kyllbeallneglan[443](javascript:footNote('E580000-001/note443.html')) belonging to Beallneglar in which there is timber.


*Cloneclohere*


The vill and land of Cloneclohere: like situation.


*woods*


A parcel of woods called Kyllclonecloher in which there is timber.


*Clonekedegan.*


The vill and land of Clonekedegan: like situation.


*woods*


A parcel of wood called Kyllclonekedegan in which there is timber. These three denominations jointly contain 2 quarters




---

p.84


memorandum: said 2 quarters lie waste.


Sum of the land of Morrogho mcTyrrelaghe mcTeige in this Toghe: 7 quarters.


¶158] *The Earl's chargeable land in this Toghe late in possession of 
Tirrelagh mac Moriertagh, surviving*.


*Ballyogwyn*


The vill and land of Ballyogwyn in the parish of Kyllmoylan containing 27 acres


*Ballynokylly*


The vill and land of Ballynokyllye: like situation and extent.


*woods*


Two parcels of wood called Kyllballynokyllye and Kyllogwynn in both of which there is timber.


Memorandum: these parcels lie waste.


Sum of the land of Tirrelaghe mcmoriertaghe in this Toghe: 54 acres.


¶159] *The Earl's chargeable land in this Toghe late in possession of
Monaster negella*.


*Downesahell*


A parcell of land called Downesahell in the parish of Monasternegellagh[444](javascript:footNote('E580000-001/note444.html'))
containing 1 quarter.


*Carrowe Monaster negelley.*


A parcel of land called Carrowe monaster negella otherwise called Monaster negella quarter: like
situation and extent.


Memorandum: these 2 quarters belonging to said Monastery are parcels of the Earl's chargeable land in said Toghe.


Memorandum: said 2 quarters are manured and inhabited.


Sum of the lands belonging to Monaster negellaghe in said Toghe 2 quarters


Sum total of the Toghe of Shanned 20 quarters.


¶160] *Towlowglasse*


*The Earl's chargeable land in this half Toghe late in possession of 
Thomas mcRudderye otherwise called the Knight of the valley*.


*Towlowglasse*


The vill and land of Towlowglass in the parish of Kyllfarise alias Kyllfargiesey in said half Toghe containing 1 quarter.


*woods*


A parcel of wood there called Kylltolloglasse in which there is timber.


*Keynarde*


The vill and land of Keynarde: like situation and extent.


*woods*


A parcel of wood there called Kyllkeynarde in which there is timber


The vill and land of Ballycollan: like situation and extent.




---

p.85


*woods*


Certain wood and underwood there called Kyllballycullen in which there is timber.


*Ballykoughlan*


The vill and land of Ballykoughlane: like situation and extent.


*woods*


A parcel of wood there called Kyllballykoughlane in which there is timber.


¶161] *Meanes alias Menus*


The vill and land of Meanes alias Menus: like situation and containing 2 quarters.


*woods*


A parcel of wood there called Kyllmeanes in which there is timber


*Tannacowrte*


The vill and land of Tannacowrte: like situation and containing 1 quarter.


*woods*


Certain wood and underwood there called Kyllshana courte in which there is timber.


*Ballyne modaaghe*


The vill and land of Balline modagh: like situation and extent.


*woods*


A parcel of wood there called Kyllballynemodagh in which there is timber.


The vill and land of Ballynegalte:[445](javascript:footNote('E580000-001/note445.html')) like situation and extent.


*woods* 


A parcel of wood there called Kyllballynegalte in which there is timber.


memorandum: the aforesaid parcels are inhabited.


Sum of the land of Thomas mcRudderey called Knight of the valley in said half Toghe 9 quarters.


Memorandum: these 9 quarters are supposed to be inhabited by Captain Collum[446](javascript:footNote('E580000-001/note446.html'))


¶162] *The Earl's chargeable land in this half Toghe late in possession of Kahell mcDermodo I Knoughor of Cargefoyle slain in rebellion*.


*Ballygonnoho*


The vill and land of Ballygonnoho: like situation and containing 1 quarter


*woods*


There is a parcel of wood there called Bellanecullana in which there is timber.


memorandum: this quarter of land lies waste.


Sum of the land of Kahilly mcDermodo I Knoughor in said half Toghe: 1 quarter.


Sum total of the half Toghe of Glancorbry 10 quarters.


¶163] *Toghe of Farrensesseragh*.


*The Earl's chargeable land in this Toghe late in possession of Pierce Wall of Ballyegney, executed at Limerick*.


*Ballyegny*


The vill and land of Ballyegny with a castle situate in Clonehagh in the parish of Rathkealye in this Toghe, with an orchard adjacent to the castle, all the premises containing 1 quarter




---

p.86


*woods*


A parcel of wood there called Kyllballyegny in which there is underwood but no timber.


*Corgragg*


The vill and land of Corgragg:[447](javascript:footNote('E580000-001/note447.html')) like situation and containing ½ quarter.


*woods*


A parcel of wood there called Kyllcorgragg in which there is no timber.


Memorandum: these lands are inhabited and manured.


Sum of the land of Pierce Wall in the Toghe of ffarrensesseragh 1½ quarters.


¶164] *The Earl's chargeable land in this Toghe late in possession of 
Morrice mc Shane Wall, surviving*.


*Ballynuskeye*


The vill and land of Ballynuskeye: like situation and containing ½ quarter.


*woods*


A parcel of wood there called Kyllballynuskeye in which there is no timber.


memorandum: this land lies waste.


Sum of the land of Maurice m` Shane mcShane[448](javascript:footNote('E580000-001/note448.html')) in this Toghe 2 quarter.


¶165] *The Earl's chargeable land in this Toghe late in possession of David en corrigg lord of the Greate woode*.


*Kyllcohan*


The vill and land of Kyllcohan in the parish of Rathkealye containing 1 quarter.


*Dealus*


The will and land of Dealus in Clonehagh in the parish of Rathkealy containing ½ quarter.


Divers woods and underwoods growing on said carucates called Bellakyllcohan in which there is timber.


memorandum: the said parcel of land lies waste.


Sum of the land of David en Corig in said Toghe: 2 quarters.


¶166] *The Earl's chargeable land in this Toghe late in possession of 
Thomas Cam lord of Clenlesse who died in rebellion*.


*Lysnekylley*


The vill and land of Lysnekylleye, with a castle situate in Clonehaghe and containing 1 quarter.


*Garran*


The vill and land of Garran in Clonehagh in the parish of Rathkealy containing 1 quarter.


*Ballin Kenrye*


The vill and land of Ballinkenrye: like situation and extent.


*Rareough moore*


The vill and land of Rareoughmore: like situation containing 1½ quarters.




---

p.87


*Lysgaddye*


The vill and land of Lysgaddye in Kyllskannell in the parish of Rathkealye containing, ½ carucate or quarter.


Divers parcels of underwood but no timber.


memorandum: these 5 quarters are inhabited and manured.


Sum of the land of Thomas Cam lord of Clenelesse in this Toghe 5 quarters.


¶167] *The Earl's chargeable land in this Toghe late in possession of 
David oge Hubhert of Bally Robin, surviving*.


*Bally Robyn*


The vill and land of Bally Robyn in the parish of Castellno alias Newcastle containing ½ quarter.


Divers underwoods but no timber.


memorandum: this parcel of land lies waste.


Sum of the land of David oge Hubbert in this Toghe: ½ quarter.


¶168] *The Earl's chargeable land in this Toghe late in possession of 
Richard oge White, surviving*.


*Rareoghbegg*


The vill and land of Rareoghbegg in the parish of Rathkealy in Clonehagh containing ½ quarter.


*Ragonan*


The vill and land of Ragonan: like situation and extent.


*woods*


Divers underwoods there but no timber.


Memorandum: these parcels lie waste.


Sum of the land of Richard oge white in this Toghe: 1 quarter.


¶169] *The Earl's chargeable land in this Toghe late in possession of 
Richard Rydall who died without pardon after the rebellion, and without heir as is said.*


The vill and land of Carrowbegg Rydeal in the parish of Rathkealy
containing 20 acres.


*woods*


Certain woods but no timber


Memorandum: this parcel lies waste.


Sum of the lands of Richard Rydall in this Toghe: 20 acres.


¶170] *The Earl's chargeable land in this Toghe in possession of the 
Earl himself*.


*Lyscarroghe*


The vill and land of Lyscarroghe in the parish of Kyllskannell containing ½ carucate or quarter.


*Clonebrowne*


The vill and land of Clonebrowne: like situation and extent.


*Garreymoore to Garranboy*


The several vills and lands of Garreymoore, Parke Clonegwillen, Kullonowran, and Garranboye, are all similarly situated and jointly contain 3 quarters.


*woods*


Divers underwoods growing on said 4 quarters.




---

p.88


memorandum: these 4 quarters lie waste.


*Carrowbegg molog*


A parcel of land called Carrowbegg mologg in the parish of Rathkealy containing 20 acres.


*woods*


A parcel of woods there called Parke Clonegwillen.


memorandum: this parcel of land lies waste.


Sum of the land of the Earl of Desmond in this Toghe 4 quarters 20 acres.


¶171] *The Earl's chargeable land in this Toghe late in possession of
Rory mcShehee surviving*.


*Kyllahen*


The vill and land of Kyllahen in the parish of Kyllskannell containing 1 quarter


*RathmcCandon*


The vill and land of RathmcCandon: like situation and extent.


*Ballyloyney*


The vill and land of Ballyloyney crow or late in the tenure or occupation of Morrogho mcShehee: like situation and extent.


*woods*


Divers parcels of underwood but no timber.


Memorandum: it is thought, but not certainly known, that this land is inhabited and manured: Ballyloyney is inhabited.


Sum of the land of Rorie mcShehee in this Toghe of Farrensesseraghe 3 quarters.


Sum total of the Toghe of Farrensesseroghe 18 quarters


¶172] *Toghe of Meaghan*.


*The Earl's chargeable land in the lower half of this Toghe late in 
possession of Pierce Wall of Balliegny executed at Limerick*.


*Lysbane*


The vill and land of Lysbane in the parish of Raronan on the mountain of Slelogher infra dimidium toghe yeaghtraghe (within the lower half of this toghe) now or late in the tenure or occupation of Olliver Stephenson and containing 1 quarter.


*Ballyloddan*


The vill and land of Ballyloddan: like situation, tenure and extent.


*Dedanes*


The vill and land of Dedanes called the two townes of the Dedanes: like situation and extent: now or late in the tenure or occupation of Henry[449](javascript:footNote('E580000-001/note449.html')) Allen cousin of Olliver Stephenson.


*woods*


Divers underwoods belonging to said 3 quarters in which there is no timber.


*Mines*


A certain iron mine of iron stone.


Memorandum: the 3 quarters are inhabited


Sum of the land of Piece Wall of Balliegny in the Toghe of Meaghan 3 quarters




---

p.89


¶173] *The Earl's chargeable land in said lower half Toghe late in 
possession of Maurice mcShane of Lyskordane, surviving*.


*Lyskordan*


The vill and land of Lyskordan: like situation as Lysbane and containing 1 quarter.


*Woods*


Divers underwoods there but no timber as is said.


*Mines*


An iron mine of iron stone.


Sum of the land of Maurice mcShane in the Toghe of Meaghan 1 quarter.


¶174] *The Earl's chargeable land in said lower half Toghe late in 
possession of Dermodo mcKnoughor mcShehee slain in rebellion*.


*BallymcKerry*


The vill and land of Ballmackerrye: like situation as Lysbane and containing 1 quarter.


*woods*


Divers underwoods belonging to this quarter but no timber.


*Mines*


An iron mine of iron stone.


memorandum: this land lies waste.


Sum of the land of Dermodo mcKonnoghor mcShehee in this Toghe 1 quarter.


¶175] *The Earl's chargeable land in said lower half Toghe late in 
possession of Garrott mcMorris Hubert, surviving*.


*Ballywoghan*


The vill and land of Ballywoghan, with a castle like situation as Lysbane and containing 1 quarter.


*Carrow blogh*


A parcel of land called Carrowblogh: tike situation and containing 54 acres: *in outer column 1 quarters*[450](javascript:footNote('E580000-001/note450.html')).


*woods*


Divers underwoods there but no timber.


*Mines*


An iron mine there of ironstone.


Sum of the land of Garrott mcMorrice in this Toghe: 1 quarter 54 acres


¶176] *The Earl's chargeable land in said lower half Toghe late in 
possession of Edmund mcMorrice Hubbert, surviving*.


*Ballyhylaghe*


The vill and land of Ballyhylaghe: like situation as Lysbane and containing 1 quarter


*woods*


Divers underwoods there but no timber


memorandum: this land lies waste.




---

p.90


*Raronan Carrowbloye*


The vill and land of Raronan: like situation and extent,


*woods*


Divers underwoods there but no timber.


Memorandum: this land lies waste.


*Ballygowan*


The vill and land of Ballygowan; like situation and extent.


*woods*


A parcel of wood there called Karroweballygowan in which there is timber.


*Ballymollin*


The vill and land of Ballymollin: like situation and containing 27 acres.


*woods*


Divers underwoods there but no timber.


Memorandum: this land lies waste.


*Canmoy*


The vill and land of Canmoye: like situation and containing 1 quarter.


*woods*


Divers underwoods there but no timber.


Memorandum: this land lies waste.


*Mines*


An iron mine there of iron stone.


Sum of the land of Edmund mcMorrice Hubberte in this Toghe 4 quarters 27 acres.


¶177] *The Earl's chargeable land in said lower half Toghe late in 
possession of David encorigg lord of the "Greate wood" who died in rebellion*.


*Ballylondyrryg*


The vill and land of Ballylondyrrig: like situation as Lysbane and containing 1 quarter.


*woods*


A parcel of wood called Lackballylondyrrigg, parcel of the lands of this quarter, in which there is timber.


*mines*


An iron mine there of iron stone.


Memorandum: these lands lie waste.


Sum of the land of David en corigg lord of the "greate woode" in said Toghe 1 quarter.


Sum total of Yeaghtragh Meaghan alias the lower part of the Toghe of Meaghan 12 quarters 27 acres.


¶178] *The Earl's chargeable land in Woughtro Meaghan alias the upper part of the Toghe of Meaghan late in possession of Morrogho mcBryan alias mcTirrelagh, lord of the Grannagh who died in rebellion*.




---

p.91


*Ruskagh*


The vill and land of Ruskaghe in the Grannagh on the mountain of Slelogher in the parish of Ardaghe containing 1 quarter of which


*Lyssen Emoyken to Lyssen Illean*


the subdenominations are Lysen Emoykan, Banemoore, Lyssen Effooke, and Lyssean Illean each containing 20 acres.


*woods*


Certain woods on each subdenomination there have both timber and underwood viz Shrahan Cam, Crosbohur, Laghill cappa Blongye, and Glanedonno.


*mines*


Each subdenomination is an iron mine of iron stone.


Croghnemullogh in the parish of Castellno and in possession of John O Knoghor Conner contains 1 quarter


**[This entry appears to have been inserted at a later date. It occurs 
at foot of   
[*...*]  
[451](javascript:footNote('E580000-001/note451.html'))115, and so comes between Banemoore and Lyssen Effooke in above condensed form]*.


¶179] *Droomen*


The vill and land of Droomen in said upper part of the Toghe of Meaghan in the Grannagh in the parish of Castellno alias Newcastle and on the mountain of Slelogher containing 1 quarter of which 
the subdenominations are


*Dromen mcTirrelaghe to Gortocullen*


Dromen mcTirrelaghe, Ballynekrye, Glasscloen, and Gortocullen, each containing 20 acres


Memorandum: said subdenominations lie waste.


*woods*


On every subdenomination there are woods containing timber and underwood viz Kyllegwhyn, Dromen Ranhy, and Dromen Guynyn.


*Mines*


On each subdenomination is an iron mine of iron stone.


Memorandum: said subdenomination lie waste.


*Bally Inge*


The vill and land of Bally Inge: like situation as Droomen and containing 1 quarter.


*woods*


A wood on Bally Inge called Glanbally Inge has timber and underwood.


*Mines*


On Bally Inge is an iron mine of iron stone.


¶180] *Ballyloghan*


The vill and land of Bally Loghan: like situation as Ruskagh and containing ½ quarter.




---

p.92


*woods*


A wood there called Bane Edderaglan has timber and underwood


*Mines*


There is an iron mine there of iron stone.


*Downegone woollye*


The vill and land of Downegonewoollye: like situation as Droomen and containing 1 quarter.


*Ballyknockane*


The vill and land of Ballyknockane: like situation and containing 20 acres.


*woods*


On said two parcels there is timber and underwood.


*Mines*


There is an iron mine there of iron stone.


*Gortreoghe*


A parcel of land called Gortreoghe: like situation and containing 20 acres.


*woods*


Glandownegonewell has both timber and underwood.


*Mines*


There is a mine there of iron stone.


Memorandum: these parcels of land lie waste.


Sum of the land of Morrogho mcBryan a alias mcTirrelaghe lord of the Grannaghe in the Toghe of Meaghan: 4½ quarters


¶181] *The Earl's chargeable land in said upper part of the Toghe of 
Meaghan late in possession of Brian mcDonogho of Dyrrey, surviving*.


*Ballynenaghe*


The vill and land of Ballynenaghe in the Grannagh on Slelogher mountain in the parish of Castellno alias Newcastle in said upper part of this Toghe and containing 1 quarter.


*woods*


Timber and underwood are growing on Ballynenaghe


*Mines*


There is an iron mine there of iron stone.


*Astaregh*


The vill and land of Astareghe: like situation and extent.


*woods*


On said parcel is a wood called Glanestary in which there is timber and underwood.


*Mines*


There is an iron mine there of iron stone.


Memorandum: this parcel of land lies waste.


*Lysnebrannagh*


The vill and land of Lysnebrannaghe: like situation and containing ½ quarter.




---

p.93


*woods*


On Lysnebrannaghe there is wood and underwood but no timber


*Mines*


There is an iron mine there of iron stone.


Memorandum: this parcel of land lies waste.


Sum of the land of Brian mcDonnogho in said Toghe beyond Croghnemullo 2 ½ quarters


¶182] *The Earl's chargeable land in said upper part of this Toghe late 
in possession of John O Konnor, surviving one of the Earl's serjeants or under receivers.*


*Corroclas*


The vill and land of Corroclas: like situation and extent as Astareghe


*woods*


There are 3 parcels of wood called Kyllcooroclas, Kyllnedromendarrey,[452](javascript:footNote('E580000-001/note452.html')) and Kyllmonyntoppwygg in which there is timber and
underwood.


*Mines*


There is an iron mine there of iron stone.


Memorandum: this parcel of land lies waste.


Sum of the land of John O Konnore in this Toghe: 1 quarter.


¶183] *The Earl's chargeable land in said upper part of this Taghe late 
in possession of Murrogho mac Edmund oge mcShehee, surviving, and Tirrelaghe mcEdmunde oge mcShehee executed at Dublin*.


*Ballyferris*


The vill and land of Ballyferris alias Pierces towne: like situation as Astareghe and containing ½ quarter.


*woods*


Kyllpierce alias Pierce's wood has timber and underwood.


*Mines*


There is an iron mine there of iron stone.


*Glannegowen*


The vill and land of Glannegowen: like situation and extent.


*Woods*


Kyllglannegowen has timber and underwood


*Mines*


There is an iron mine there of iron stone.


Memorandum: the said land lies waste.


Sum of the land of Tirrilaghe mcEdmunde oge mcShehee and Murrugho mcEdmunde oge 1 quarter
mcShehee in the Toghe of Meaghan


¶184] *The Earl's chargeable land in said upper part of this Toghe 
late in possession of Donnell mcNeale of Doacatten, surviving*.




---

p.94


*Doacatten*


The vill and land of Doacatten situate near the Grannaghe on the mountain of Slelogher and parish Castellno alias Newcastle containing ½ quarter


*woods*


Kylldoacatten wood has timber.


*Mines*


There is an iron mine of iron stone.


Memorandum: this parcel of land lies waste.


Sum of the land of Donnell mcNeale of Doucatten in the Toghe of Meaghan ½ quarter.


¶185] *The Earl's chargeable land in said upper part of this Toghe late 
in possession of James Wall of Cloneskreaghan who died in rebellion*.


*Garrane Kevan*


The vill and land of Garranekevan: like situation as Astareghe and containing 1 quarter.


*Woods*


Divers underwoods but no timber.


*Mines*


There is an iron mine there of iron stone.


Memorandum: this parcel of land lies waste.


Sum of the land of James Wall in the Toghe of Meaghan ½ quarter.


¶186] *The Earl's chargeable land in said upper part of this Toghe in 
possession of the Earl himself*.


*Templeclee*


The vill and land of Temple Clee in the Grannaghe on the mountain of Slelogher in Raronan parish containing 1 quarter.


*Corbally*


The vill and land of Corballye: like situation and extent.


*Glanygourte*


The vill and land of Glanygourte: like situation and extent.


*woods*


There are divers woods belonging to the 3 quarters of Templecle, all of which have timber and whose names are Curraghduffe, Curragh adohane, Monegorme, Shrone Mane, and Kyllknaffe.


*Mines*


There is an iron mine of iron stone on said 3 quarters of Temple Clee extending on Slelogher mountain.


*Fishing*


In part of said lands there is a Salmon fishing on the river Gayley.


Sum of the land of the Earl of Desmond in said upper part of this Toghe: 3 quarters.


Woghtro Meaghan, or the upper part of the Toghe of Meaghan contains: 13 quarters.


Yeaghtragh Meaghan, or the neathre part of the Toghe of Meaghan contains: 12 quarters.


Memorandum: all the premises lie waste.




---

p.95


Sum total of the Toghe of Meaghan 25 quarters.


The extent originally given as 26 quarters 27 acres, is corrected to 25 quarters; and there is a note "there want 2 quarters unnamed but the Toghe conteyneth 25 quarters.[453](javascript:footNote('E580000-001/note453.html'))


¶187] (*122*)[454](javascript:footNote('E580000-001/note454.html'))*Toghe of Gortcoyth.*


*The Earl's chargeable land in this Toghe late in possession of 
Tirrelagh mcEdmund oge mcShehee executed at Dublin*.


*Ardene craghe*


The vill and land of Ardnecraghe near Castellno alias Newcastle in the parish of Monagh Adare (Monagay) but on no part of Slelogher mountain and containing 1 quarter which is divided


*Treanlyssen Ine to Treanwoghtrogh*


into the subdenominations of Treanlyssen Ine, Trean Manna, and (*122d*) Treanwoghtrogh, each containing 26 2/3 acres


*woods*


There are divers woods and underwoods in which there is timber viz Kylltrean lyssen Ine, Kylltrean Manna, and Kylltreanwoghtrogh.


Memorandum: said parcels of land all lie waste.


Sum of the land of Tyrrelaghe mcEdmunde oge mcShehee in this Toghe 1 quarter.


¶188] (*123*)*The Earl's chargeable land in this Toghe late in possession of Morrogho mcEdmund oge mcShehee, surviving*.


*Garreduffe*


The vill and land of Garreduffe in said Toghe on the mountain of Slelogher and parish of Monaghe Adare containing 1 quarter.


*woods*


Divers woods in which there is timber viz:— Carraghe negre[455](javascript:footNote('E580000-001/note455.html')) called the wood of the wild "studds", Belladuffe, Glanleigh, and Glankeell.


*mines*


On said land on the mountain of Slelogher is an iron mine of iron stone.


Memorandum: this quarter of land lies waste.


Sum of the land of Morrogho mcEdmunde oge mcShehee in this Toghe 1 quarter.


¶189] (*123d*) *The Earl's chargeable land in this Toghe late in possession of Gerald mac Thomas of Kyllffynney slain in rebellion*.


*Rathkaell*


Two of the three parts of the vill of Rathkaell situate in the wood of Nohoragh on the mountain of Slelogher in the parish of Monaghe Adare and containing 53 2/3 acres.


*Woods*


There are divers underwoods belonging to said lands in which there is timber.


Two third parts of Nohoroghe wood, and two third parts of Beallacarta woods, both of which have timber.


*Mines*


There is an iron mine of iron stone on the part of Rathkaell which lies on Slelogher mountain.




---

p.96


Memorandum: the said parcel of land lies waste.


Sum of the land of Gerald mcThomas of Kyllfynny in this Toghe: 53 2/3 acres


¶190] *The Earl's chargeable land in this Toghe late in possession of 
Edmund Gankogh, surviving*.


(*124*)*Rathekaell*


One third part of the vill of Rathkaell on the mountain of Slealogher in the parish of Monagh Adare containing 27 1/3 acres.


*woods*


Divers underwoods and woods in which there is timber.


One [third][456](javascript:footNote('E580000-001/note456.html')) part of Nohorrogh wood in which there is timber, and two parcels of wood and underwood called Beallacarta wood, and Curryn ne bo backye or the wood of the lame cow, in both of which there is timber


*Mines*


There is an iron mine there of iron stone.


Memorandum: said parcel of land lies waste.


Sum of the land of Edmund Gankogh in said Toghe: 27 1/3 acres.


¶191] *[The Earl's chargeable land in this Toghe in possession of the Earl himself]*[457](javascript:footNote('E580000-001/note457.html'))


(*124d.*) *Droome taresna*


A parcel of land called Droometaresna in Temple glantan on that part of the mountain of Slevelogher called Sleveglantan and containing 1 quarter


*Templeglantan*


The vill and land of Templeglantan on the part of the mountain of Slevelogher called Sleveglantan,[458](javascript:footNote('E580000-001/note458.html')) and containing 1 quarter.


*Knockbrackmoynetredale*


A parcel of land called Knockebrackmoynetredala situate like Templeglantan, and the following parcels situate like Droometaresna viz


*Gorteawrohanna to Cloneheyrye,*


Gorteawrohanna, (*125*) Kylleyndroomelarra, Moynetorym, Knocknedohee, 
(*125d*) Tullygolyne, Knockroyne, Kyllequolleye, (*126*) Knockneskeighe,[459](javascript:footNote('E580000-001/note459.html')) Seskenmoore, Seskenbegg, (*126d*) Lagh ne Cowntis alias "halfe the ladies lande", and Cloneheyrye: these denominations appear to contain 3 quarters as all the denominations, Droometaresna to Cloneheyrye contain 5 quarters.


*woods*


There are divers parcels of wood and underwood in all of which there is timber viz Bellabehee alias Birchewood, Lackholgolyne, Glangortwrohanna, (*127*) Carrownegall, Moregorum[460](javascript:footNote('E580000-001/note460.html')) Knocknedoghe, Lacken Kyll Cullen, Dyrreyknockneskeighe, and Ulloghan.


*Mines*


There is on every parcel of said land so far as it lies on Slelogher mountain an iron mine of iron stone.


*Fishings*


There belongs to said 5 carucates or quarters a salmon fishing on the river Ulloghan,[461](javascript:footNote('E580000-001/note461.html')) and also another salmon fishing on the river
Eaghan.[462](javascript:footNote('E580000-001/note462.html'))




---

p.97


Memorandum: these lands all lie waste.


Sum of the land of the Earl of Desmond in Sleveglantan in Gortcoythe Toghe 5 quarters


¶192] *The Earl's chargeable land in this Toghe in possession of the Earl himself*


Several vills and lands situate in Templeglantan on the part of the mountain of Slevelogher called Sleaveglantan in the parish of Monagh Adare viz


(*127d*) *Ballymorrogho to Farrenegonynct.*


Ballymorrogho, Ballycarrowell, Gortavallig, (*128*) Towlerymoore, 
Gortetyrreye, Ballykyllknydane, (*l28d*) Ballykyllnecappa Arda, 
and ffarren ne Gonyna alias the "Connyes pounde"[463](javascript:footNote('E580000-001/note463.html')) all jointly containing 2 quarters.


*woods*


Divers parcels of wood and underwood in all of which there is timber viz Glanskeigh, Glanmaggin, Carrogh ne gonyna, and, Glan ne Cappa arda


*mines*


There is on every part of said lands far as it lies on Slevelogher mountain an iron mine of iron stone.


(*129*) Memorandum: these parcels all lie waste.


Their Sum is 2 quarters


¶193] *The Earl's chargeable land in this Toghe now or late in possession of 
himself or others.*


*Glannowhym*


The vill and castle Glanpowhym on part of the mountain of Slevelogher in the parishes of Moneagh Adare and Kyllydye containing 20 acres


Divers parcels of land in Glannowhym on that part of the mountain of Slelogher called Glannowhym in said parishes, now or late in the tenure or occupation of Tyrrelaghe mcEdmunde oge mcShehee viz


*Culloghboye to Gortenowlorte*


Cullog boye, Cloghehaghe, and (*129d*) Gortenowlorte each containing 20 acres.


Divers parcels of land in Glanmoore on that part of the mountain of Slevelogher called Glannowhym now or late in possession of said Tyrrelagh viz


*Gortenowre to Nekylltye*


Gortenowre, (130) Gortneclona, and ne Kylltye situate in the parishes of Monaghe Adare and Kyllydye each containing 20 acres; and


*Nekyllynaghe*


ne Kyllynagh in the parish of Monaghe Adare also containing 20 acres.


¶194] *Divers parcels of land in that part of the mountain of Slevelogher 
Called Glannowhym in said parishes of Monagh Adare and Kyllydye, now or late in the tenure of said Tyrrelagh viz*


(*130d*) *Crackeneye to Banekyllke* Cracknye, Ballykenyne, Clonekurvane, (*131*) Banekyllkye alias "Hens bane"; each containing 20 acres;


*Camus*


Camus containing 40 acres (besides 40 acres charged above among the free lands of the Earl of Desmond and similarly called Camus);


*Ballynvogan*


Ballynvogan containing 40 acres; and




---

p.98


(*131d*) *Rathneconerey to Nurrana*


Rathneconnerey, Gurten Egarreye, Ballynvyckary alias vicar's towne, and (*132*) Nurrana, each containing 20 acres.


*woods*


Divers parcels of wood in all of which there is timber viz: Encowragh, Bellahwade, Glanmore Glannowhym, Kurragh en Ahyn Shehee, and Curragh Egubgan.


There are also belonging to said 5 quarters divers woods and underwoods in which there is timber.


*mines*


There is on every part of said land so far as it extends on Slevelogher mountain an iron mine of iron stone.


(*132d*) Memorandum: these parcels of land all lie waste


Sum of the land of the Earl of Desmond in Glannowhym in Gortcoythe Toghe: 5 quarters.


Sum of the land of the Earl in the Toghe of Gortcoyth: 12 quarters.


Sum total of the Toghe of Gortcoythe 15 quarters


¶195] *Half Toghe of Killydye.*


*The Earl's chargeable land in this half Toghe in possession of the Earl himself*.


*Gorte Eanaghet*.


A parcel of land called (*133*) Gorte Eanaghet in Dowell in Glannowhym 
on part of the mountain of Slevelogher in the parishes of Killydye and Moneagh Adare containing 20 acres.


Divers parcels of land on that part of the mountain of Slelogher called Glannowhym in said parishes viz


*Droom Roe dowell to Tyreogallo*


Droom Roo dowell containing 40 acres; and Ballylownogan and (*133d*) Tyreogallo containing 20 acres each.


*woods*


There are 3 parcels of wood in which there is timber viz Glandowell, Kyllballylonagan and Kylltyreogallo; and there are divers woods and underwoods belonging to said lands whose names are not
yet known.


*Mines*


There is on said 100 acres an iron mine of iron stone.


Memorandum: the parcels of land aforesaid lie waste.


Sum of the Earl's land in Glannowhym in the Toghe of Kyllydye aforesaid 1 quarter 20 acres.


¶196] *The Earl's chargeable land in this half Toghe in possession of 
the Earl himself or his constable at Newcastle*.


(*134*)*Croghean*


The vill and land of Croghean in Kyllydye parish containing of arable land ½ quarter.


*woods*


There is a parcel of wood there called Kyllcroghan in which there is timber; and divers other woods and underwoods whose names are not yet known.


Memorandum: this parcel of land lies waste.




---

p.99


*Kyntogher*


The vill and land of Kyntogher in the parishes of Kyllydye and Moneagh Adare containing ½ quarter.


Divers lands in said parishes now or late in the tenure or occupation of David oge mcDavy mcMorris Hubbert constable of Castellmo viz


*Ballyregan to Ballyclowan*


the vill and land of Ballyregan containing 60 acres, and the several parcels called (*134d*) Gortmoynan, Ballyowen, Ballygwoyle, (*135*)
Ballymackasse,[464](javascript:footNote('E580000-001/note464.html')) Cullynagh, Ballykurke, (*135d*) Ballyshane alias Johnstowne, and Ballyclowan, containing 20 acres each; in all 220 acres


*Ballymcraneth to Ballyconno*


Divers parcels in said parishes viz Ballymcraneth, Cream (*l36*) 
Rahanna, Ballynehowe, and Ballyconno containing 20 acres, each; in all 100 acres.


¶197] **Divers parcels of wood in which there is timber viz:*


(*136d*) *Woods*


Kyllkyntogher, Kyllballyregan, Bellagdrantan, Curraghballyowen, Cloneballygowle, Curragh ne ladderye, Droomenecullenagh, Cyllballykyrke, Kyllballyshane, Kyllballyclonan,[465](javascript:footNote('E580000-001/note465.html')) Kyllbally mc ranet, Kyllkrean, Bellagurteskannell, Kyllrahana, Kyllballyiehowe, and Kyllballyconnow.


There are divers other woods and underwoods belonging to said lands whose names are not yet known.


(*137*)** Memorandum: said lands all lie waste.


Sum: 4½ quarters corrected to 5 quarters.


Memorandum in French:[466](javascript:footNote('E580000-001/note466.html')) these 4½ quarters (arpines) were wont to be in possession of the constable of Newcastle and never the less 
they do not belong to the castle.


(*137d*)Memorandum: the said lands all lie waste.


Sum of the land of the Earl of Desmond in the said half Toghe 6 quarters 20 acres.


**Memorandum and sum entered here in accordance with practice throughout the book: in the original they occur at*


¶198] *The Earl's chargeable land in said half Toghe late in possession of Thomas cam, lord of Clenlesse, who died in rebellion*.


*Fyneglas*


A parcel of land called Finneglas in said parishes containing 60 acres; and 2 other parcels called


*Monro Bally Gale*.


Monroo, and Bally Gale alias Daylies towne similarly situated each containing 20 acres.


*Woods* 


A parcel of wood and underwood called Beelaghnegrussan (*138*) in 
which there is timber; and divers parcels of wood in which there is timber viz:— Glananurlare, Askaghnemonaroy, and Curraghallygall.


*Eyry of hawks*


An eyry of Goshawkes on Glananurlare




---

p.100


Memorandum: the said lands all lie waste.


Sum of the land of Thomas cam, lord of Clenlesse in the half Toghe of Killydye 1 quarter 20 acres.


Sum total of the Toghe of Killydy 7½ quarters.


¶199] *Half Toghe of Kyllheylagh*.[467](javascript:footNote('E580000-001/note467.html'))
*The Earl's chargeable land in this half Toghe late in possession of Thomas Cam, lord of Clenlesse who died in rebellion*.


Divers parcels of land in the parish of Monaghe Adare on that part of the mountain of Slevelogher called Sieve ne Clenles viz.


*Kyllheylaghe to Clonefeakan,*


(*138d*) Kyllheylaghe, Gortnehynnono, Lyssduff, (*l39*) Ballyeroughan, Gortnecloghye, Larreydroma, Nehoultye, (*139d*) Cappa woughtra, Cappa Yeaghtra, Clone Cannon, (*140*) Gortrobin, Banemoore, Cloneskahaghe, (*140d*) Lysnefallaghe and Clonefeakan, each of which contains 20 acres, except Cappa Yeaghtra which has
30 acres and Clone Cannon which has 10.


To said 3 quarters and 60 acres of land belong divers parcels of wood in all of which there is timber viz: Lackbally eroughan, (*141*) Bellagurten ne meele, Knockne Corkye alias "Oates hill", Glandavoure, Glan ne Cappa, Lysballencannana, Curraghe Clone Cannon, Kyll Lysnefallagh, Kyllclone Cannon, Curragh Clonefeakan, and Droomeballyvallor. There are divers other woods and underwoods belonging to said lands whose names are not yet known.


*Mines*


There is an iron mine there of iron stone.


Memorandum: the said lands all lie waste.


Sum of the lands of Thomas cam, lord of Clenlesse in said half Toghe 3 quarters 60 acres


¶200] *The Earl's chargeable land in said half Toghe late in possession of Gerald mcThomas of Kyllfynney slain in rebellion*.


*Ballintubbred to Fanleghan*


Divers lands in the parish of Moneagh Adare viz the vill and land 
of (*141d*) Ballintubbred, and the lands of Cappa Goughlane, Gortedoyne Gortegarreye,[468](javascript:footNote('E580000-001/note468.html')) and (*142*) Fanleghan: each denomination contains 20 acres or 100 acres in all: two third parts of every denomination now or late in the tenure or occupation of said Gerald ffitz Thomas in all 67 acres.


*woods*


There are divers parcels of wood in all of which there is timber viz Kyllballintubbred, Kyllshanegarreye, Kyll Cappagoughlane, Kyll Gortedoyne, Kyll Gortegarrey, and Kyllfanleghan: two third parts of these woods belonging to said two third part aforesaid similarly in the tenure or occupation of said Gerald ffitz Thomas. There are divers other woods and underwoods belonging to said two third 
parts of said carucate and 20 acres of land whose names are not yet known.


Memorandum: these lands lie waste.


Sum of the land of Gerald flitz Thomas of Kyllffynney in said half Toghe 67 acres


¶201] *The Earl's chargeable land in said half Toghe late in possession 
of Edmund Gankogh, surviving*.


*Ballintubbred to Fanleghan*


Divers lands in said parish viz the vill and land of (*142d*) Ballintubbred, and the lands of Cappa Goughlane, Gortedoyne, Gortegurrey and (*143*) Fanleghan; each containing 20 acres as aforesaid or 100 acres in all: one third part of every denomination now or late in the tenure or occupation of said Edmund Gankoghe in 
all 33 acres.




---

p.101


*woods*


Divers parcels of wood in all of which there is timber as aforesaid viz Kyllballyntubberd, Kyllshanegarrey, Kyll Cappa Goughlane, Kyllgortedirrey, Kyll Gortegarrye, and Kyllfanleghan: a third part part of each of these woods belong to said third part of above lands now or late in the tenure or occupation of said Edmund Gankoghe. There are divers other woods and underwoods belonging to said third part of said carucate and 20 acres of land whose names are not yet known.


Memorandum: these parcels all lie waste.


Sum of the land of Edmund Gankoghe in said half Toghe 33 acres.


(*143d*) Sum total of the half Toghe of Kyllheylagh 5 quarters.


¶202] *Half Toghe of Ogallawhoore*.[469](javascript:footNote('E580000-001/note469.html')).


*The Earl's chargeable land in this half Toghe in possession of the 
Earl himself*.


*Graunsha*


The vill and land of Graunsha in the parish of Graunsha near Newcastell alias Castleno containing 3 quarters and consisting of


*Moyne Graunshe to Lyskeryne*


these subdenominations viz Moyne Graunshe and Inchendroyde, 1½ quarters, and Lysnelyen and Lyskeryne, 1½ quarters.


*Lysnesellagh, Garreymoore*


Two parcels of land in the vill of Clonegwillen in the said parish viz: Lysnesellagh containing 1 quarter, and Garreymoore Clonogwillen containing quarter.


*woods*


Divers parcels of wood in which there is timber viz Bardne narren, Garraen Inshendraed, Barrie Ballinvoscherey, and Kylllysnealy.


Memorandum: these parcels of land lie waste.


Sum of the land of the Earl of Desmond in the half Toghe of Ogallowhoore: 4½ quarters.


¶203] *The Earl's chargeable land in this half Toghe late in possession 
of Rorye mcShehee, surviving*.


The vill and land of Bohergaell in said parish containing 1 quarter.


*woods*


A parcel of wood in which there is timber called Lackenbohergall.


Memorandum: this quarter lies waste.


Sum of the land of Rorye mcShehee in the half Toghe of Ogallawhoore: 1 quarter


¶204] *The Earl's chargeable land in this half Toghe late in possession 
of Redmond mcThomas mcRedmund Ro Wall slain in rebellion*.


*Ardryne*


The vill and land of Ardryne in said parish containing 1 quarter


*woods*


A wood called Paryck Ardryne alias Ardrytie Parck in which there is timber.




---

p.102


Memorandum: this quarter lies waste.


Sum of the land of Thomas mcRedmund[470](javascript:footNote('E580000-001/note470.html'))


Ro Wall in the half Toghe of Ogallawhoore: 1 quarter


¶205] *The Earl's chargeable land in this half Toghe late in possession 
of Richard mcThomas of Pallice*.


*Carrowgarrow*.


The vill and land of Carrowgarrowe in said parish containing 60 acres


*woods*


A part of the wood of Ballinuosher aforesaid in which there is timber.


Memorandum: this parcel of land lies waste.


Sum of the land of Richard mcThomas in said half Toghe: 60 acres


¶206] *The Earl's chargeable land in this half Toghe late in possession 
of Robert oge Quisshen*.


*Egallawhoore*


The vill and land of Egallawhoore in said parish containing 1 quarter.


*Ballymorishen*


A parcel of land called Ballymoryshen in said parish containing 20 acres.


Memorandum: said parcels of land lie waste.


Sum of the land of Robert oge 1½[471](javascript:footNote('E580000-001/note471.html')) quarters Quisshen in said half Toghe


¶207] *The Earl's chargeable land in this half Toghe late in possession 
of James Wall of Cloneskrehan who died in rebellion*.


*Cloneskreghan*


The vill and land of Cloneskreghan in said parish containing these subdemoninations viz:—


*Garreycloneskreghan to Gortclare*


Garreycloneskrehan alias Cloneskrehan garden with an orchard, and Ballylynnan, both in the vill of Cloneskreghan; Monemulloge, and Gorteclare: each subdenomination contains 20 acres in all 80 acres


Memorandum: this land lies waste.


Sum 1 quarter.


*Droomeon*


The vill and land of Droomeon Cloneskreghan in said parish containing 1 quarter consisting of the


*Clonemoore, Garrenmoore*


subdenominations of Clonemoore ne dromon in Cloneskreghan, and Garrenmoore ne droomon in Cloneskreghan, each of which contains 40 acres.


Memorandum: this quarter of land lies waste.


Sum 1 quarter.


¶208] *Downegehemore to Ballingowne*


Three vills and lands in Cloneskreghan in said parish, viz: Downegehemoore, Downegehebegg, and Ballingowne, each of which contains ½ quarter, or jointly[472](javascript:footNote('E580000-001/note472.html')) ½ quarters.




---

p.103


*woods*


Divers parcels of wood in all of which there is timber viz: Locknegarragh, Glandaraghe, Garrenmoore, Coy Edufe, and Kyllballygowen.


Memorandum: these lands lie waste.


Sum of the land of James Wall in the half Toghe of Ogallawhoore: 3½ quarters.


Sum total of the half Toghe of Ogallawhoore 12 quarters.


Sum of all the Sixteen Canhrews or Toghes in Connelo: 324 quarters 6 acres.


¶209] *The force and strength the Earl of Desmond had out of Connelo 
at all tithes ready at his need.*


*Bonybeg*


Memorandum: said 324 quarters and 6 acres were charged with Bonnybegg of 224 Galloglasse a company that remained at one place all the year round so as to be ready at an hour's warning viz: 112 Galloglasse and 112 boys meat and drink at the country's charge.


*Bonybur*


Also said lands were charged[473](javascript:footNote('E580000-001/note473.html')) Bonnyburr of 200 Galloglasse coming forth of any foreign country who never rested in any one place but one quarter of the year viz 100 Galloglasse and 100 boys meat and drink for the time at the country's charge


The residue of the Country of Connelo, being not chargeable to the Bonnyburr or Bonnybegg, but called the ffreelands, were charged with a Rysinge of 400 footmen and 40 horsemen, every 
horseman having 2 horses and 3 boys at all times and as often as the Earl would call for them or had need to employ them; which Rysinges all the Country of Connelo should furnish, as well the freelands as the chargeable.[474](javascript:footNote('E580000-001/note474.html'))


¶210] *The Manor of Asketton*.[475](javascript:footNote('E580000-001/note475.html'))


*Head rent*
Divers rents of free as well as customary tenants of the Earl of Desmond, called chiefrye, belonging to said manor and amounting yearly to 10½ marks ancient money called halface viz from nine quarters in Asketten called the nine double quarters, parcel of the Toghe of Asketten 9 marks; and from divers tenements in Asketten and the Eele fishings in the river Dyle ½ marks. They are put as nothing in the charge here because said nine quarters are charged by the quarter in the Toghe of Asketten; and the tenements with said fishings are built and situate on demesne lands of this manor 
as parcel of 6½ quarters, 2 acres, 2½ roods hereunder recited and charged similarly by the quarter. Hence here in the head rent they are charged as nothing


*Site of Manor*


The site of the manor and castle of Asketten situate in the parish of Asketten. The castle is a strong one[476](javascript:footNote('E580000-001/note476.html')) built on a small island in the river Dyle with divers buildings belonging thereto constructed with stone walls: the premises now or late in the tenure or occupation of Captain Bartlett, gent contain 2 roods.


¶211] *Moyrtenen Alone to Mollenmoore*


Divers parcels of land and a mill belonging to said manor and castle, parcels of the demesne lands of said manor called the Earl's free land situate in the vill and parish of Asketten and now or late 
in the tenure or occupation of Captain Bartlett viz: Moynen en alorte 2 acres, Moynerley without the lands adjacent to the castle ½ quarter, Kyll rahen 1 quarter, Cappalinta alias Cappalinloge 
1/4 quarter or 20 acres, Cappalinmotinge 1/4 quarter or 20 acres, Ardenegan alias Ardnegowne ½ quarter Inshyrorke[477](javascript:footNote('E580000-001/note477.html')) ½ quarter, Grgnes Lowtherey ½ quarter, Cragmoore 3 quarters; a water mill called Mollenmoore (besides another water mill called Mollenbegg belonging to the House of the Friars of Asketten) ½ rood.




---

p.104


*Woods*


No woods or underwoods on the demesne lands of Asketten manor.


Woods belonging to the manor are particularly specified in the Toghe of Asketten as belonging to the Earl's chargeable lands in the Toghes: of these lands [he assigned][478](javascript:footNote('E580000-001/note478.html')) at his pleasure for his own best advantage or for the easement of the castle.


¶212] *Fishings*


A fishing lying around the castle and island in the Dyle aforesaid consisting of four parts viz Lyn en Assa,[479](javascript:footNote('E580000-001/note479.html')) Lyn en monen, en Lyn en Allorte, and en poole ne Cally, parcels of the demesne lands of said manor called the Earl's free land in Asketten and now or late in the tenure or occupation of Captain Bartlett.


A salmon fishing belonging to said manor and castle called Corre en Earl whynred,[480](javascript:footNote('E580000-001/note480.html')) or the Earl's weir or salmon leap under the Bridge, built on the river Dyle near said castle: parcel, situation and tenure as the parcels of Moynen en alone, &c.


Divers other fishings belonging to said manor and castle called the Earl's weirs for Eels, built on said river Dyle and touching 16 or 20 parcels of the demesne lands called the Earl's free land 
aforesaid: they are situate within the vill metes and bounds of Asketten and are in the tenure aforesaid.


There are two other salmon fishings called Salmon leaps in the vill of Asketten: of these one called Corr in Numrare[481](javascript:footNote('E580000-001/note481.html')) alias the 
Friars' weir belongs to the House of the Friars of Asketten and is charged hereafter among the lands of Religious houses that have come to the Queen's hand by act of parliament. The other called Corr Edy oge Lacey Laressetanna alias the Weir of Edmund oge Lacey near the Shannon belonging to said Edmund oge Lacey is charged hereafter among the lands of attainted persons as it came to the Queen's hand by the attainder of said Edmund who was slain in rebellion. Hence here they are charged as nil.


Memorandum: the said demesnes of the manor of Asketten are manured and inhabited.


¶213] Sum of the manor of Asketten 6½ quarters 2 acres 2½rood.


Besides land in the Sixteen Toghes of Connello charged among the Earl's chargeable lands sometimes belonging to one manor and sometimes to another at the Earl's will viz: Moynerley 4 quarters,
Englandstowne 1 quarter, Ballyquilley ½ quarters, Gortesethan ½ quarter, Ballytomen ½ quarter, Clonelogh 20 acres, Cowtrebrown alias Brownescourte there 2½ quarters, Ballynasse ½ quarter, Shanedyrrey 20 acres, BallyneCaheragh 1 quarter, and Ballymoore 
2 quarters all situate in the Toghe of Asketten; and Bolloglasse 1 quarter and a third of a quarter or 27 acres situate in the Toghe of Nantenan.


Sum of the lands of the Manor of Asketten in the Toghes specified: 14 quarters 27 acres.


¶214] *The Manor of Castellno*.


*Head rent*.


Divers rents of free as well as customary tenants of the Earl of Desmond, called chiefrie, belonging to said manor amounting yearly to 13 marks ancient money, halface, viz: from 8½ quarters in the Granaghe in the Toghe of Meaghan 8½ marks; and from 15 parcels in the Toghe of Killydye containing 4½ quarters, 4½ marks in all 13 marks. They are put as nothing in the charge here because said 13 quarters are charged by the quarter in the Toghe of Meaghan and half Toghe of Kyllydye. Hence here in the head rent they are charged as nothing.


*Site of manor*


The site of the manor and castle of Castelno alias Newcastle, which is built near the river Ewgarro[482](javascript:footNote('E580000-001/note482.html')) which runs into the river Deele and so on to the Shannon, with divers yards gardens and orchards, situate in the vill and parish of Castellno and containing 7 acres.




---

p.105


Of these one parcel called Owlorde[483](javascript:footNote('E580000-001/note483.html')) or the great orchard contains 4 acres, another called Gardenmoore or the great garden contains 1 rood, and other waste buildings and land contain 2 acres 3 roods: in all 7 acres.


¶215] Divers parcels of land &c. belonging to said manor and castle parcels of the demesne lands of'said manor called the Earl's free land situate in the vill and parish of Castellno or the vill and parish of Monaghe Adare, and nor or late in the tenure or occupation of David oge Hubbart late constable of the castle of Castellno, viz:—


*Dowaley to En Parrick*


Dowalley ½ quarter, Srade y Gurran being a street or waste parcel with tenements and gardens, Farren Merlen 20 acres, Clashymarla, Clashnaglogh, Ballyn Robert Roo 20 acres, LLohaduff 20 acres, 
Gorty Glegan, Tullagh Alym, Fearentynna, the vill and land of En Parrick[484](javascript:footNote('E580000-001/note484.html')) or the park 20 acres, all which premises are in the vill and parish of Castellno;


*Rahenne Aughe to Fatten mc y Gower*


Rahenne Aughe, Monegarruffe 20 acres, Kyllyhealim 1 quarter, Gort Icollham 20 acres, Gort Icollyffera ½ quarter, Garrynaleakyn, Garrynabynne, and Farren mcy Gower, which last mentioned 
premises are all in the vill and parish of Monaghe Adare.


Sum of entire premises (with or without extent) 4½ quarters.


¶216] *Kyllruddane*


Divers other parcels similar to and in the like tenure as the parcels aforesaid, named and situated as follows: namely the vill and land of Kyllruddane and divers parcels of land in said vill of 
Kyllruddane viz:


*Ballylahiff to Garranluffa*


Ballylahiff, Kyllcuiffyn, Leaghphan, Fyremore, Fyrebegg, Lyshcubbig, Ballynacally, Lyshnacally, and Garranluffa ½ quarter: of these lands the parcels of Kyllcuiffyn, Ballynacally, Lyshnacally 
and Garranluffa are in the parish of Ardaghe, but the other lands are in the parish of Castellno:


Sum of the lands in Kyllruddane (with or without extent) 4½ quarters.


¶217] *Shrade Gower*


A street in Newcastell called Shradegower[485](javascript:footNote('E580000-001/note485.html')) with a tenement yard, orchard, and 8 gardens and with certain lands adjacent to the tenement. Said premises belong to said manor and castle, are parcel of the demesne lands called the Earl's free land as aforesaid, are situate in the parish of Monaghe Adare, now or late in the tenure of Edmund mcEgowre and contain 10 acres.


*Molten mcEgowre*


A water mill called Molten mcEgower built on a part or parcel of said street belonging, situate and in the tenure of said Edmund as aforesaid.


*Shrade netona*


Another street called Shrade netona with a tenement and two gardens and certain lands to the tenement belonging and adjacent.


Said premises belong to the manor and castle aforesaid are parcel of the demesne lands as aforesaid, are situate in the parish of Castellno: now or late in the tenure or occupation of Edmund oge Gygheheyne and contain 10 acres.


*Eanagh*


A parcel of land called Eanagh belonging to the manor and castle aforesaid, parcel of the demesne lands as aforesaid situate in the parish of Castellno and containing 9 acres. *Probably in the Earl's possession as tenure not given*.[486](javascript:footNote('E580000-001/note486.html'))




---

p.106


¶218] *Gort Owrane*


A parcel of land called Gortowrane similar in all respects to Eanagh except that it is situate in the parish of Monaghe Adare and contains 5 acres.


*Mollyn a cloghey*


A water mill called Mollyn A Cloghey alias the castle mill belonging to the manor and castle aforesaid, parcel of the demesne lands of the manor as aforesaid, situate in the parish of Castellno and now or late in the tenure or occupation of David oge Hubbert late constable of said Castle.


*Monemoore*


A piece of pasture or parcel of land called Monemoore belonging to said manor, parcel of the demesne lands of the manor as aforesaid situate in the parish of Monaghe Adare and in the tenure of said 
David oge Hubbert.


*Garden y Lackagla*


A street called Garden y Lackagh with a tenement and 6 gardens, belonging to said manor and castle, parcel of the demesne lands of the manor as aforesaid, situate in the parish of Castellno and 
now or late in the tenure or occupation of Adarrey O Dowre.


*Garden ne bynney*


Another street called Garden ne hvnnev with a tenement and 6 gardens, similar in all respects to Garden y Lackagh except that it is in the parish of Monaghe Adare and now or late in the tenure
or occupation of Ea mcDonnogho.


¶219] *Woods*


There are divers woods and underwoods belonging to said manor, growing on the 9½ quarters and 1 acre of its demesne lands, (besides those formerly belonging to said castle and manor which are 
specified in the half Toghe of Kyllydye, and Toghe of Farrensessereghe,) and are all parcels of said demesne lands viz En Parricke of Castellno alias the park of Newcastell in which there is timber 
(oak and ash); and Garraenffarraen, Garranluffagh in Kyllruddan, Garran I Kevan in Kyllruddan, Garraendowaley,[487](javascript:footNote('E580000-001/note487.html')) Garranbally 
Robert roo Mongandowallybegg,[488](javascript:footNote('E580000-001/note488.html')) and Boherbraddagh, in which last mentioned woods there is no timber.


Memorandum: the several demesne lands and the parcels above specified all lie waste.


Sum of the manor of Castellno 9½ quarters l acre.


¶220] Besides lands in the sixteen Toghes of Connelo charged among the Earl's chargeable lands sometimes belonging to one manor, sometimes to another at the Earl's will viz:— Kintogher 40 acres, BallyRegan 60 acres, and the following denominations each containing 20 acres viz Gortmoynan, Ballyowen, Ballygowell, Bally mcKysse, Cullynagh, Ballykurke, Ballyshane, Ballyolowan,[489](javascript:footNote('E580000-001/note489.html'))
BallymcRaneth, Cream, Rahanna, Ballynehowe, and Ballykonno which denominations[490](javascript:footNote('E580000-001/note490.html')) are all situate in the half Toghe of Killydye.


Also BallyRobin in the Toghe of ffarrensesseragh containing 40 acres.


Sum of the land belonging to the manor of Castelno in the Toghes before specified: 4½ quarters.


¶221] *The manor of Corgragg*.


*Head rents*


Chiefrie or chief rents of any free or customary tenants of the Earl of Desmond as parcel of said manor: none.




---

p.107


*Site*


Site of the castle of Corgragg situate in the Toghe of Dunmoylan on the Earl's chargeable land: hence here nothing is set down as the said castle is built and specified in the Toghes aforesaid.


*Ballinpherson, Ballvn Guyell ne Cragge*


Premises belonging to the manor and castle of Corgragg parcels of the demesne lands of said manor called the Earl's free land, situate in the parish of Bally Robert, and now or late in the tenure 
or occupation of John mcClankey, constable of the castle of Corgragg viz:— A parcel of land called Ballinpherson alias Parsonestowne containing ½ quarter; and the vill and land of 
Ballyguyell ne Craggeye with the appurtenances adjacent to the castle and the land of Corgragg, both containing 1 quarter.


*Clone en Garrey*


A parcel of land called Clone en Garrey belonging to the manor and castle as aforesaid, parcel of the free land and situate as aforesaid now or late in the tenure or occupation of Donneley O Swyllevan 
and containing ½ quarter.


¶222] *Woods*


There are no woods or underwoods growing on the demesne lands of the manor of Corgrag. There are no woods belonging to the manor of Corgragg particularly specified in the Toghe of Dunmoylyn, which belong to the Earl's chargeable land in the Toghes, from such quarters as he pleased.


Memorandum: the demesnes of said manor are supposed to be manured by Donnell O Sullyvan.


Sum of the manor of Corgragg 2 quarters.


Besides lands in the Sixteen Toghes of Connelo charged among the Earl's chargeable lands sometimes belonging to one manor and sometimes to another at the Earl's will viz. Grannagh and Belldyrrigverra 3 quarters, Leathe 80 acres, and BallyLawras 80 acres; all which last mentioned lands are in the Toghe of Dunmoylin.


Sum of the land belonging to the manor of Corgragg in the Toghes charged 5 quarters.


¶223] *The Manor of Matrascourte*.[491](javascript:footNote('E580000-001/note491.html'))


*Head rents.*


Chiefrie or chief rents of any free or customary tenants of the Earl of Desmond as parcel of said manor of Matrascourte: none


*Site*


Site of the manor and ruinous castle of Matrascourte alias Courtematrask, built on a parcel of land called Nekreaghe near the river Deele with an orchard and 19 gardens near said site, parcel of the demesne lands of said manor called the Earl's free land situate in the parish of Rathkealye now or late in the tenure or occupation of Nicholas ffitz William and containing 1 quarter 20 acres.


Divers other parcels belonging to said manor parcel of the demesne lands as aforesaid situate in the vill and parish of Rathkealye and in the tenure of said Nicholas ffitz William as aforesaid viz:


*Cortne [gworra] to Gortennymeresson*


A parcel called Gortnegworra upon which another castle called Castell Matrask was formerley built, situate in said parish 2 furlongs distant from the former Castle, near the river Deele which flows
into the Shannon, and containing 20 acres; Gortnegerra 32 acres, Gortna nyrum 20 acres, Mullaghe Moore 20 acres, Mullaghe begg 20 acres, Rath y Garvan 10 acres, Gortystyarde 10 acres, Glanenaboleye 17 acres, Rahyhyda 5 acres, Garra gortmore 2½ acres, Garragortbegg 2½ acres, Gorta Tylygh 5 acres, Gortnafoyneshone 8 acres, Ballinamillagh 20 acres, Gortgillibart 10 acres, Nehynshey 10 acres, Inchinmatraske[492](javascript:footNote('E580000-001/note492.html')) 3 acres, and Gortennymeresson 5 acres.




---

p.108


¶224] *Cloynemore, Gortkrea*


Two similar parcels now or late in the tenure or occupation of John Konnowe viz:— Cloynemore 36 acres, and Gortkrea 4 acres.


Divers other similar parcels now or late in the tenure or occupation of said Nicholas ffitz William whose extents are not specified viz: Reaskmore, Monyn y Styard, and Kowle Reask.


*Mollen a Matraske*


A water mill called Mollen a Matraske on the land of Gortnagworro aforesaid, belonging to said manor, parcel of the demesne lands of the manor as aforesaid and in the tenure of said Nicholas flitz
William as aforesaid.


*Fishing*


To said water mill belongs a certain fishing on the river Deele with a "weare" called a "weare" for eels parcel of said demesne lands and now or late in the tenure of said Nicholas ffitz William


There are no woods or underwoods growing on the demesne lands of said manor.


Woods belonging to the manor of Matrascourte are particularly specified in the Toghe of Olybane on the quarter of land called Dromearde parcel of the Earl's chargeable land as therein.


Sum of the manor of Matrascourte 4½ quarters.


¶225] Besides lands in the Sixteen Toghes of Connelo charged among the Earl's chargeable lands sometimes belonging to one manor and sometimes to another at the Earl's will, viz:— Droomearde in the Toghe of Olybane 1 quarter, and Carrobegg mologhe in the Toghe of Farrensesseragh 20 acres.


Sum of the lands belonging to the manor of Matrascourte in the Toghes specified 
1 quarter 20 acres.


Memorandum: said manor of Matrascourte lies waste.


¶226] *The Manor of Portrynarde*


*Head rents*


Chiefre or chief rents of any free or customary tenants of the Earl of Desmond as parcel of said manor of Portrynarde: none.


*Portrynarde*


Site of the manor and castle of Portrynarde[493](javascript:footNote('E580000-001/note493.html')) alias the Fort of the three Enemies[494](javascript:footNote('E580000-001/note494.html')) built near the river Deele (Recte Feale) on a parcel of the 
land of Ballemahyne with certain yards and gardens adjacent thereto situate on the mountain of Sleveloger in the parish of Monaster ne feally now or late in the tenure or occupation of mcTirrelaghe mcEdmund oge mcShehee the Earl of Desmond's captain of Galloglasse and constable of the castle and manor aforesaid.


Divers vills and lands belonging to said manor parcels of the demesne lands thereof called the Earl's free land in the tenure or occupation of said Tirrelaghe mcEdmund viz.


*Ballymahyne to Cosheowally*


Ballymahyne in the parish of Monaster ne ffealy 1½ quarters; Athee alias Athdee in the parish of Temple clew 1 quarter; Moyemore 1 quarter; and the following denominations all in the parish of 
Monaster ne faly of Temple clea viz Knockydullane ½ quarter, Knocknehanagh ½ quarter, Knockynorman ½ quarter, Knock Iharryne 20 acres, Tworyn na gleraghe 20 acres, Na Stange 20 
acres, Cosheowally 20 acres.




---

p.109


*Mollen Efforte*.


A water mill Mollen Effourte[495](javascript:footNote('E580000-001/note495.html')) built on a parcel of land called Ballymahyne near the river Glash[496](javascript:footNote('E580000-001/note496.html')) Ballymahyne which runs towards the Fealle, situate in the parish of Monaster ne feallye, belonging to said manor, parcel of the demesne lands of the manor as aforesaid
and now or late in the tenure or occupation of said Tirrelaghe mcEdmund oge mcShehee.


*Fishing*


A salmon fishing in the river ffeale two miles long and more.


*woods*


Divers woods and underwoods belong to this manor: in one of them called Athdee woods there is timber.


*mines*


An iron mine of iron stone is on the lands lying on the mountain of Slelogher.


Memorandum: said manor of Portrynarde lies waste.


Sum of the manor of Portrynarde 5 quarters.


¶227] *Aghnenasse Island*


*Aghenasse*


Aghnesse alias Athenesse Island [*...*][497](javascript:footNote('E580000-001/note497.html')) miles in length and [*...*][498](javascript:footNote('E580000-001/note498.html')) miles in breadth, surrounded by the river Shannon and situate in the parish of Monaster Negellagh; it contains 3 quarters of land now or late in the tenure or occupation of the Countess of Desmond for the sole use of the "Studdes" and contains the following
denominations all portions of said island and parcels of the Earl's free land viz


*Keaharrow na Kylley to Powell y Meola*


Keaharrownakylley[499](javascript:footNote('E580000-001/note499.html')) 1 quarter, Fannamoore 1 quarter, Grenan en Aghnesse 40 acres, and Powell y Meola[500](javascript:footNote('E580000-001/note500.html')) 40 acres.


*Fishing*


To said island belongs a Salmon fishing on the river Shannon within the bay called Cone Aghenesse alias the bay of Aghnesse[501](javascript:footNote('E580000-001/note501.html'))


Divers woods and underwoods called KyllAghnesse in which there is timber belong to the island of Aghnesse


Memorandum: this island lies waste.


Sum of the land of Aghnes Island 3 quarters.


Deduction: there is a yearly rent of twenty shillings ancient money halface payable from this island 20*s.* to the Abbey or Monaster of Negellaghe Balance [*...*][502](javascript:footNote('E580000-001/note502.html'))


Memorandum: the Earl and Countess were in possession of this island 3 years before he went into rebellion. They did not pay this rent as the Earl's brother, John of Desmond, was in possession of 
the Abbey and did not demand it. However so much rent was due to the Abbey out of said island, and the Earl was content to be charged therewith.


¶228] *Dyrren Maymore, and Garrey en Tynnegg*


*Dirren Muyntore*


A vill called Dirren may moore in the parish of Temple Clee situate on the mountain of Slevelogher parcel of the Earl's land called the Earl's free land and containing ½ quarter.




---

p.110


*mines*


There is an iron mine on this land as far as it extends over the mountain.


*wood*


There are woods and underwoods, in which there is timber, growing on these lands on the mountain.


*Garren en Tynneg*


A vill and Island called Garren en tynneg island situate in the parish and on the mountain aforesaid, parcel of the Earls free land as aforesaid and containing 2 quarter.


*mines*


There is an iron mine on this land so far as it extends over the mountain.


*woods*


There are woods or underwoods, in which there is timber, growing on these lands, on the mountain.


*Fishing*


There is a Salmon fishing on the river Gayley[503](javascript:footNote('E580000-001/note503.html')) which surrounds the island.


Memorandum: said ½ quarter of Garrey en Tynneg lies waste.


Sum of the land of Dyrren Maymoore and Garrey en Tynneg aforesaid: 1 quarter.


¶229] *The parcel of Braseno*.


Divers vills and lands belonging to Kylldromehylren alias Braseno called the "Rymers" town in co. Kerry. said premises are situate in the parish of Monaghe Adare co. Limerick, are parcels of the Earl's land called the Earl's free land now or late in the tenure or occupation of Donnell mcAwley, rymor, viz:—


*Kaherlawerry*


Kaherlawerry containing 1½ quarters:


*Knockwoolekerre*


Knockwoolekerre


*Knockeradermodo*


and Knockeradermodo,[504](javascript:footNote('E580000-001/note504.html')) both lying on the mountain of Slevelogher in Templeglantan each containing ½ quarter.


*Woods*


Divers woods and underwoods, in which there is no timber, growing on said lands of Knockamony[505](javascript:footNote('E580000-001/note505.html')) and Kaherlawerr.


*mines*


There is an iron mine of the lands of Knockmony[506](javascript:footNote('E580000-001/note506.html')) and the other 
lands so far as they extend over the mountain.


*Fishing*


A salmon fishing in the river Fealle so far as the lands extend near the river.


Memorandum: said 3 quarters of land lie waste.


Sum of the land belonging to Braseno in Connelo, Great County of Limerick 3 quarters.


Besides 16 quarters in co. Kerry 8 of which are free and called the Earl's free land; the other 8 quarters are called Farren dollo Trogh en Ackmy or the Earl's chargeable land in the Troghkahede 
or Canthred of Enackmy in Co. Kyrry as there more fully appears.




---

p.111


¶230] *Kyllcoyneley*.


The vill and land of Kyllcoyneleye on that part of the mountain of Slevelogher called Sleveglantan parcel of the Earl's land called the Earl's free land in Templeglantan in the parish of Monagh
Adare now or late in the tenure or occupation of Donnell Odaley, rymor and containing 1 quarter.


*woods*


Certain woods and underwoods there in which there is timber, called Lackenkyllcoynleye and Beall Anegall.


*Fishing*


A Salmon fishing on the river Fealle.


Sum of the land belonging to Kyllcoyneleye: 1 quarter.


¶231] *Glannowhym*.


Divers parcels of land in Glannowhym near Slevelogher parcels of the Earl's lands called the Earl's free land in Glannowhym in the parish of Monaghe Adare now or late in the tenure or occupation
of Tirrelagh mc Edmund oge mc Shehee viz:—


*Glannowhym to Gorte Reighleyn*


Mynisreoo 20 acres, Garden Camus 40 acres, Lysurloen 20 acres, Cappacoyneley[507](javascript:footNote('E580000-001/note507.html')) 10 acres, Gortenduf3'e 10 acres, Gorte Reighleyn 20 acres.


Divers woods and underwoods, in all of which there is timber, belonging to said lands viz:— Knocknegeraghe or Sheepes' Hill wood, Glanskeigh, enduffe and Keillgort Reighlen.


Sum of the land belonging to the Earl of Desmond in Glannowhym: 1 quarter 20[508](javascript:footNote('E580000-001/note508.html')) acres


¶232] *Beabus, Clannanoore &c*.


*Beahus*


The vill and land of Beabus parcel of the Earl's land called the Earl's free land in the parish of Cloneshere en Temple now or late in the tenure or occupation of Konnoghor O Hogane and containing
60 acres.


*Woods*


Divers underwoods called Kyllbeabus but no timber.


Memorandum: this parcel called Beabus lies waste.


*Glanna Nowre*.


The vill and land of Glanna Noore, like parcel situation and tenure, containing 40 acres.


*Woods*


Divers underwoods called Kyllglannoore but no timber.


*Clonshere*


The vill castle and land of Rowermoore like parcel and situation now or late in the tenure or occupation of [the Earl himself][509](javascript:footNote('E580000-001/note509.html')) and
containing 40 acres


*Rowerbegg*


A parcel of land called Rowerbegg within the vill of Rowermoore, like parcel, situation and tenure as Beabus and containing 20 acres.




---

p.112


¶233] *woods*


Divers underwoods belonging to the lands of Rowermoore and Rowerbegg, called KyllRower, but no timber.


*Cloneslterehogg*


The vill and land of Clonesherebegg, like parcel situation and tenure as Beabus and containing 40 acres.


*woods*


Certain woods belong to Clonesherebegg, but not timber.


Memorandum: these parcels of land lie waste.


The vill and land of Ballyonourty alias Bally ordurtye parcel of the Earl's land called the Earl's free land in the parish of Asketten (besides the said lands in Asketten parcel of the manor of Asketten) now or late in the tenure or occupation of John mc Clankey called Breehuff an Erle in English the Earl's judge and containing 1 quarter.


*woods*


No woods or underwoods belong to Ballyonourtye.


*Shannegowle*


The vill and land of Shannegowle parcel of the Earl's land called the Earl's free land lying in the parish of Shannagowle now or late in the tenure or occupation of Shane mc Richarde mc Shehee and 
containing 1 quarter.


No woods or underwoods belong to the lands of Shannegowle.


Memorandum: these 4½ quarters of land lie waste.


Sum of the land in Beabus Glannenowre and other lands: 4½ quarters.


¶234] {MS folio 180d}*Poble Clonererey and Crossbullog in Ardagh*


*Cappa poble clonererey*


The vill and land of Cappa Poble Clonererey alias Cappa mc Poble Clonererey, parcel of the Earl's land called the Earl's free land lying in Poble Clonereyrey called Teige mc Morierto's country alias ClanMahoundes country in the parish of Laughoill now or late in the tenure or occupation of John mc Clankey called Brehuff an Earle or the Earl's judge and containing 1 quarter.


*woods*


Divers woods and underwoods belonging to Cappa poble clonererey in which there is timber


*Crossebullog*


The vill castle and land of Crosbullog (and a parcel of land within said vill called


*Farren y bullog*


Farren y bullog) parcel of the Earl's land called the Earl's free land lying in the parish of Ardaghe, parcel of the Toghe of Ardaghe one of the church Toghes alias one of the Eight Toghes of Callowe now or late in the tenure or occupation of David oge mc David mc Morrice Hubbert and containing 1½ quarters.


*woods*


There are no woods or underwoods belonging to said lands of Crosbullog and Farren y bullog.


¶235] Memorandum: the whole Toghe of Ardaghe one of the eight Toghes of Callowe or Church Toghes in Connelo contains 4½ quarters, for the most part in the Queen's hand (except Farren 
I meneterigg 60 acres, Farren Inytygg[510](javascript:footNote('E580000-001/note510.html')) or White's lands 20 acres, and Farren I Cowlagh 10 acres, in all 90 acres).




---

p.113


These 90 acres are chargeable with Sorohen only and hereafter are charged under the title of Sorahan Coyny and Lyverie.


The residue consisting of 3 quarters 30 acres are charged formerly and hereafter as follows viz: on the Earl of Desmond 1½ quarters; Thomas mc Rudderye, Knight of the valley, 1½ quarters; Farren en altyg[511](javascript:footNote('E580000-001/note511.html')) alias Wale's land 10 acres; Farren I dullard alias Dullard's land, one of the burgesses lands in Ardaghe, 20 acres; in all 3 
quarters 30 acres as above.


¶236] Over and besides this there is a parcel of land in Ardaghe called Farren ne geragh, parcel of the free land of the Knight of the valley and containing 10 acres; but this is no parcel of the 4½ quarters aforesaid.


Likewise the residue of the 8 Church Toghes alias the 8 Toghes of Callowe viz: Clonecrawe 1 quarter, Kyllagh holyeghan 5 quarters, Kyllskannell 1½ Craghmacmahony alias Clanmahownde 2 quarters, 
Tongwylley 4½ quarters, Cappa Temple 1 quarter, Pobleneskaghe 4 quarters, and Ardaghe 4½ quarters are for the most part charged with Sorahen, hereunder in the Title of Sorrahen Coynye and Lyverye, due to the Earl of Desmond; excepting such lands as fall into the Queen's hands by the attainders of those slain in rebellion which are charged hereunder on every particular person.


Sum of the lands in Poble clonererey and Crossbullog: 2½ quarters.


Memorandum: the lands called Cappa Poble Clonererey lie waste.


¶237] *Eight Toghes of Callow alias the Churche Toghes*


Toghe of Clonekrew or Killclonekrewe 1½ quarters.
  

Toghe of Kyllaghholieghan: 5 quarters.
  
 
Toghe of Killskannell: 1½ quarters.
  

Toghe of Cragmahowne alias Clanmahowne, 2 quarters.
  

Toghe of Tomegelye,: 4½ quarters.
  

Toghe of Cappatemple,: 1 quarters.
  

Toghe of Pobleneskeaghe,: 4½ quarters.
  

Toghe of Ardaghe,: 4½quarters.
  



Sum 20 quarters and 4½ quarters.


¶238] *Courte Brake*


The vill castle and land of Courte Brake parcel of the Earl's lands called the Earl's free land near the city of Limerick and within the liberties and bounds thereof; now or late in the tenure or occupation of John Comen of Limerick, merchant, and containing ½ quarter.


*Woods*


No woods or underwoods belong to the lands of Courtebrake: there are some shrubs which are worth nothing.


*Fishing*


A fishing on the river Shannon with the weir belonging thereto called Corro Courte brake alias the "weare of Courte brak,[512](javascript:footNote('E580000-001/note512.html')) totally in ruin [and worth][513](javascript:footNote('E580000-001/note513.html')) nothing.


Memorandum: this parcel sometimes belonging to Monasterie Donnogo Carbry otherwise called Monasterie Woghtro in Lymerick was given to said monastery by the Earl of Desmond, and is therefore charged here among the Earl's free lands.


Sum of the land in Courte Brake aforesaid: ½ quarter


Sum of the Earl's lands in the Great County of Lymerick: 373 quarters 27 acres




---

p.114


¶239] *Rents of the Free tenants or the Earl of Desmond in Connelo*.


*Lands of Eadye Lacye of Browrye, surviving*.


Divers vills of said Eadye Lacey, parcel of his free land in Connelo, viz: Ballynmyhynny[514](javascript:footNote('E580000-001/note514.html')) 1 quarter, Tanckardstowne ½ quarter, Ballinlye ½ quarter, and Ballingortrowe ½ quarter, in all 2 ½ quarters, were not charged to the Earl with any rent, or Sorrahen Coynye or Lyverie, as is said. Hence here there is no charge on said lands which 
are set down at nothing.


¶240] *Lands of Phillip mc Gibbon of Muhownagh surviving: now belonging to James mc Thomas mc an Erle[515](javascript:footNote('E580000-001/note515.html')) of Conesye*.


*Cesse Mcrlowne*


Divers free vills and lands of said Phillipp viz:— the vills[516](javascript:footNote('E580000-001/note516.html')) of Mohan Mahownagh, Cowlebane Mahownagh, Shanra, and Korra Mahowna, jointly containing 2 quarters and 5 acres; Ballynekyllye ½ quarter; Lyskyllen 1 quarter 20 acres; and Ballymollin 15 acres: containing altogether 4 carucates which were yearly and continuously charged to the Earl of Desmond with Cesse Molowne or horse cess, worth yearly 10*s.* for every quarter of the 4 quarters.


Memorandum: these 4 quarters of free lands were lately bought by James mcThomas of Conesye in Cosbryde, nephew to the Earl of Desmond


¶241] *Lands of Henry ffitz James of Gortnekra, surviving*.


The Toghe of Clonecrawe in the parish of Clonecrawe now or late in the tenure or occupation of said Henry and containing 1 quarter.


*Sorrahen*


This Toghe is one of the 9 Toghes of Callowe or the 8 church Toghes and is charged yearly with Sorrahen to the Earl of Desmond due and customary as his ancient inheritance viz for 12 Galloglasse
2 days and 2 nights, every quarter of the year, amounting to 96 Galloglasse for one day and night which is yearly worth 1*l.* the carucate on said quarter.


Memorandum on charge for Sorrahen. Generally in all countries if the Galloglasse came not to take Sorrahen, or would fast and refuse their meat taking money instead, the charge was 1 white groat a meal. Also the Earl's serjeant had this prerogative, by virtue of his office, to appoint the Galloglasse in another place and put the money in his own purse.


Memorandum: this quarter in Clone Crawe Toghe lies waste.


¶242] *Lands formerly belonging to the Abbey of Kensam in the county of Kent, England.*


The Toghe of Kyllaholyan in the parish of Kyllaholyan together with the vill and land of Farrey Econnaghe now or late in the tenure or occupation of [*...*][517](javascript:footNote('E580000-001/note517.html')) and containing 5 carucates.


*Sorrahen*


This Toghe is one of the Toghes of Callow like Clonecrawe aforesaid, and is chargeable with same amount for Sorrahen, viz 96 Galloglasse for one day and one night yearly, which is here valued at 4*s.* the carucate on said 5 quarters.


¶243] *Lands of Maurice Meneter, deceased.*


A parcel of land called Menetera or Meneter's land in the parish of Ardaghe, now or late in the tenure or occupation of [*...*][518](javascript:footNote('E580000-001/note518.html')) and containing 60 acre.


This land is parcel of the Toghe of Ardaghe one of the 8 Toghes of Callowe or Church Toghes, and is chargeable yearly with Sorrahen, Coyney, and Lyverye, to the Earl of Desmond due and customary as of his ancient inheritance, viz 24 Galloglas for two days and two nights every quarter of the year, amounting to 192 Galloglas for one day and one night. This is charged rateably on the entire Toghe of Ardaghe which contains 4 ½ quarters. Hence for 60 acres there is a charge of 15*s.* at the rate of 5*s.* for every 20 acres or fourth part of a quarter


Memorandum: said parcel of land lies waste.




---

p.115


¶244] *Land of Richard oge white one of the burgesses of Ardaghe, surviving*.


A parcel of land called Farren e Nytig alias white's land in the parish of Ardaghe now or late in the tenure or occupation of [*...*] [519](javascript:footNote('E580000-001/note519.html')) and containing 20 acres.


*Sorrahen Covnye & Lyvery*


This land is parcel of the Toghe of Ardagh and charged with Sorrahen, Coynie and Lyverie in all respects as in case of Menetera aforesaid. The yearly charge is 5*s.* for the 20 acres.


Memorandum: This parcel lies waste.


¶245] *Land of Edmund ffitz Morrice Herbert, surviving*.


A parcel of land called Farren y Cowlagh in the parish of Ardagh now or late in the tenure or occupation of [*...*][520](javascript:footNote('E580000-001/note520.html')) and containing 10 acres.


*Sorrahen Coyny & Lyverye*.


This land is parcel of the Toghe of Ardagh and charged with Sorrahen, Coynye and Lyverie in all respects as in case of Menetera aforesaid. The yearly charge is 2*s.* 6*d.* for 10 acres.


Memorandum: this parcel of land lies waste.


¶246] *Land of Richard Lyston of Kyllskannell, surviving*.


*Sorrahen Coynie and Lyverie*.


The vill and land of Kyllskannell containing 1½ quarters called the Toghe of Kyllskannell which is one of the 8 Toghes of Callowe alias church Toghes and is chargeable yearly with Sorrahen Coynye and Lyverie to the Earl of Desmond due and belonging as of his ancient inheritance viz 12 Galloglas for two days and two nights every quarter of a year amounting to 96 galloglas for one day and 
one night which are charged on this Toghe yearly at the rate of 13*s.* 4*d.* per quarter on said 1½ quarters.


Memorandum: said 1½ quarters lie waste.


¶247] *Land of Tirrelaghe mc Moryertaghe, surviving.*


The vill and land of Dyzarte with a castle in the parish of Monaster Negellagh now or late in the tenure or occupation of Tirrelagh mcMoryertaghe and Donnell mcClanke and containing 1 carucate.


*Sorrahen*


This carucate is parcel of the Toghe of Cragg Clan Mahownde one of the 8 Toghes of Callowe alias Church Toghes yearly charged with Sorrahen to the Earl of Desmond due and customary as of his ancient inheritance viz. 12 Galloglas for two days and two nights every quarter of the year amounting to 96 Galloglas for one day and one night which are charged rateably on said Toghe of Cragg Clan Mohownde, which contains 2 quarters, at the rate of 20*s.* per carucate yearly on the aforesaid carucate or quarter.


Memorandum: this quarter of land is manured and inhabited.


*Sorrahen*


The vill and land of Cragg in the like situation, tenure, Toghe, and subject to Sorrahen in like manner, viz at the rate 20*s.* per carucate yearly on this the other carucate or quarter of Cragg clan Mahownde Toghe. Like memorandum.


¶248] *Lands of Tirrelaghe Mantaghe, surviving*.


The vill and land of Ballynvoher in the parish of Egalasserosse, in that part of Kenryemore called Yeaghrosse, now or late in the tenure or occupation of Tirrelaghe oge mc Kenedy.




---

p.116


*Sorrahen Coynie and Lyverie*.


Said vill and land are chargeable yearly with Sorahen Coynie and Lyverie to the Earl of Desmond due as of his ancient inheritance viz for 8 Galloglas two days and two nights every quarter of the year amounting to 64 galloglas for one day and one night; and for 4 horses and 8 horseboys two days and two nights every quarter of the year amounting to 64 horseboys and 32 horses for one day and one night: the whole is worth yearly 20*s.* for the quarter.


Memorandum: this quarter is manured and inhabited.


¶249] *Land of Edmund mc David mc Rudderye, surviving.*


The vill and land of Ballygylleghan and the vill and land of Kyllwyrry in the parish of Kyllkurnan in Kenryemore now or late in the tenure or occupation of said Edmund and containing 4 quarters.


*Kentduffe, Sorrahen, Sesse Malone, Coynie*


Said vill and land are chargeable yearly with a certain cess called Kentduffe on Currogh cu-Shannon[521](javascript:footNote('E580000-001/note521.html')) in English the Earl's cess from the weir to the river Shannon, to the Earl of Desmond due and belonging as of his ancient inheritance viz: 400 Kearne Galloglas and footmen for two days and two nights after Christmas, and two days and two nights after Easter amounting to 1600 persons for one day and one night; and for 40 horsemen 80 horses and 160 horseboys similarly for two days and two nights after Christmas, and two days and two nights after Easter, amounting to the number of 160 horsemen, 320 horses and 640 horseboys for one day and one night:— amounting in all to 2400 persons, and 320 horses yearly


This is charged rateably on the inhabitants of Kenry Nurragh[522](javascript:footNote('E580000-001/note522.html')) containing 20 quarters and the inhabitants of Kenrye More containing 40 quarters. Here there is charged for said vills of Ballygyllyghan and Kyllwyrry[523](javascript:footNote('E580000-001/note523.html')) at the rate of 26*s.* 8*d.* yearly per carucate on said 4 quarters.


Memorandum: the said townships of; Ballygellaghan and Kyllwyrry are manured and inhabited.


¶250] *Land of Philip mc Gibbon*


*Coshery*


A yearly cossherie payable to the Earl of Desmond by said Philip out of his free lands in Mahownagh in the parish of Mahownaghe containing 4 quarters viz the castle and land of Mahownagh 50 acres, Cowlebane 10 acres, Enkurragh 15 acres, Shean Rath [*...*][524](javascript:footNote('E580000-001/note524.html')) acres, Ballnekylley 2 quarter, Ballygarilla alias Ballygowrte 20 acres, Lyskyllen 1 quarter 20 acres, Farren en Mollen alias Ballynmollen in English Milltowne 15 acres, Gortnacroghe[525](javascript:footNote('E580000-001/note525.html')) 10 acres, Gurtyn[526](javascript:footNote('E580000-001/note526.html')) 10 acres, Kowlemyskyshe 10 acres.


This is chargeable for two days and two nights once a year after Christmas for persons to the number of 100, 200, and more.


Memorandum: these 4 quarters of land lie waste.


Memorandum: this man Phillipp mcGibbon lives unprotected and unpardoned: Thomas mc Gibbon his son and heir was slain in rebellion.


¶251] *Land of John ffitz Edmund Cullin of Fynneter's Castle, surviving*.


The vill and land of Ballinfyneter with a castle[527](javascript:footNote('E580000-001/note527.html')) in the parish of 
Ballynekylley[528](javascript:footNote('E580000-001/note528.html')) containing 2 quarters now or late in the tenure or 
occupation of John mc Edmund en Cullen.


*Sorrahen and Sesse Malone*


This vill and land are parcel of the Toghe of Pobleneskaghe one of the 8 Toghes of Callowe or church Toghes chargeable yearly with Sorrahen and Sesse Malone to the Earl of Desmond due and belonging as of his ancient inheritance viz for 60 Galloglas two days and two nights every quarter 



---

p.117




of the year, amounting to 480 Galloglas for one day and one night charged rateably on the Toghe of Pobleneskaghe which contains 10 quarters.


For the 2 quarters here at the rate of 5 Smulkans[529](javascript:footNote('E580000-001/note529.html')) commonly 
called Smulkins a meal the yearly amount is 21*s.* 4*d.*


Memorandum: these 2 quarters are manured and inhabited.


¶252] *Sorraen and Sesse Malone*


The vill and land of Bally en maing with a castle: like situation, extent, tenure and Toghe as Ballinfyneter: and chargeable with Sorrahen and Sesse Malone in same way 21*s.* 4*d.* yearly.


Memorandum: these 2 quarters are manured and inhabited


*Sorraen crud Sesse Malone*


The vill and land of Ballynortaghe: like situation extent, tenure and Toghe as Ballinfyneter: and chargeable with Sorrahen and Sesse Malone in same way 21*s.* 4*d.* yearly.


Memorandum: these 2 quarters lie waste.


*Sorraen and Sesse Malone*


The vill and land of Garran Arde: like situation, extent, tenure and Toghe as Ballinfyneter: and chargeable with Sorrahen and Sesse Malone in same way, 21*s.* 4*d.* yearly.


Memorandum: these 2 quarters lie waste.


*Sorraen and Sesse Malone*


The vill and land of Loggnecloghe:[530](javascript:footNote('E580000-001/note530.html')) like situation, extent, tenure, 
and Toghe as Ballinfyneter: and chargeable with Sorrahen and Sesse Malone in same way 21*s.* 4*d.* yearly.


Memorandum: these 2 quarters lie waste.


Memorandum: this Toghe of Poble Neskaghe was charged with Malone alias Sesse Malone a cess of horsemen as often as the Earl came into co. Limerick, limited to a certain number viz 4 horsemen and their horses; each horseman had a chief horse and a hackney, every horse and hackney had 2 boys; and some one horse had 4 boys, and some had 8 boys to a horse.


¶253] *Land of Edmund London of Kyllkosgrave surviving*.


A yearly rent issuing from Kyllcosgrave vill castle and land situate in the parish of Kyllmoyla and containing 1 quarter now or late in the tenure or occupation of [*...*][531](javascript:footNote('E580000-001/note531.html'))


*Chieffrie Coyny and Lyverie*


Said premises containing 1 quarter are charged to the Earl of Desmond with 26*s.* 8*d.* halface yearly equal to 1*l.* 15*s.* 6½*d.* English sterling money. (There is also another quarter late in the possession of [*...*][532](javascript:footNote('E580000-001/note532.html'))
London around the castle of Kyllcosgrave, called the Earl's chargeable land which is charged above in Dunmoylan Toghe.)


Note the quarter from which said rent issued was[533](javascript:footNote('E580000-001/note533.html')) wont to be charged with Coynye and Lyverye which are here valued but only with the above sum for Chieffrie.


Memorandum: this quarter of land lies waste.


¶254] *Land of Redmund mc Gerald, surviving*.


The vill and land of Brohill with a castle in the parish of Clonekoghera[534](javascript:footNote('E580000-001/note534.html')) alias Clonetoken containing 4 quarters now or late in the tenure or occupation of said Redmund. Said land is parcel of the Toghe of Brohill which contains 16 quarters viz said 4 quarters and 6 others in the county of Limerick and 6 quarters not in co. Limerick; and these lands are not regarded as any of the 8 Toghes of Callowe or Church Toghes, or of the 16 Toghes in Connelo called the Earl's land in Connelo.




---

p.118


*Sorraen and Sesse Malone*


They are chargeable yearly with Sorrahen and Sesse Malone to the Earl of Desmond due and belonging as of his ancient inheritance viz 60 Galloglas for two days and two nights every quarter of the year amounting to 480 Galloglas for one day and one night charged rateably on the sixteen quarters of Brohill aforesaid: or for said 4 quarters, at the rate of 5 smulkins a meale, to 1*l.* 6*s.* 8*d.* yearly.


Memorandum: said 4 quarters are manured and inhabited.


Memorandum: Cesse Malone is a charge of horsement at the Earl's pleasure of 8, 6, or 4 at the least charged upon this fourth part of said Toghe: (besides the sorrahene above charged.) The Sesse Malone was to be equally cessed on the entire Toghe.


¶255] *Sorraen and Sesse Malone*.


The vill and land of Clonekoera alias Clonetoken: like situation, tenure and Toghe as Brohill, and chargeable with sorrahen and Sesse Malone in same way. As said vill and land contain 2 quarters


Memorandum: said 2 quarters are manured and inhabited


The vill and land of Ballysallaghe: like situation, extent and tenure as Brohill; and chargeable with Sorrahen for 60 Galloglas for the times and at the rate for Brohill amounting yearly to 40*s.* for the 6 quarters of Arden Earle.


Memorandum: said 4 quarters are manured and inhabited


The vill and land of Arden Earle in the parish of Brohill near Connelo co. Limerick containing 6 quarters: tenure and Toghe same as Brohill and chargeable with Sorraen for 60 galloglas for the times and at the rate for Brohill amounting yearly to 40*s.* for the 6 quarters of Arden Earle.


Memorandum: these 6 quarters are inhabited and manured.


Sum of the Toghe of Brohull, 16 quarters.


Memorandum: this Toghe of Brohull besides the Sorrahen above charged was also charged with Malowne alias Sesse Malone which is a cess of horsemen as often as the Earl came into the country of Connelo, or the counties of Limerick or Cork, limited to no certain number but commonly charged with 4 horsemen their horses hackneys and boys which were 8 horses and hackneys and 2 boys at least to a horse: sometimes there were 4 boys and sometimes 8 boys to one horse.


¶256] *Land of Maurice mc Edmund Huhhert, surviving*.


A yearly head rent of 1*l.* 18*s.* 5*d.* issuing from the lands of said Maurice mcEdmund of Rathkealye containing 33 tenements and 33 gardens in the parish of Rathkealye. (Besides a garden parcel of the Abbey of Rathkealye called Garrsynewar[535](javascript:footNote('E580000-001/note535.html')) containing ½ acre worth yearly 18*d.*; 3 gardens and 3 tenements parcel of the 
lands of Nicholas Ritz William worth yearly 13*d.*; 4 gardens and 4 tenements parcel of the lands of Patrick Woolffe worth yearly 4*s.*


The entire premises yield yearly to the Earl of Desmond in right of his ancient inheritance 45*s.* halface.)


*Chiefrie Coynio and Lyverie*.
Said 33 tenements and gardens and other premises charged with chieffrie Coynye and Lyverie are in the hands and possession of divers burgesses there viz mcMorryshin, Lyston, mcWilliam Whym, Gwanogh, en Portrey[536](javascript:footNote('E580000-001/note536.html')) alias John oge Norr, Thomas Cam of Clenlesse and other burgesses.


Here charge is made for said 33 gardens and tenements now or late in the tenure or occupation of Dermod oge Olyre of Muskerrye for said head rent only.


Memorandum: said 33 tenements and gardens are manured and inhabited.




---

p.119


Item: here charge only is made for the rent of the lands of Maurice mcEdmund Hubbert. The rents of Nicholas Fitz William and Patrick Woollffe's lands are not here charged since on account of their attainders they are placed with the attainted lands. The rent of 18*d.* for Garreynevar is not here charged because it comes from the Abbey of Rathkeale which is in her majesty's hand and is charged hereafter among the possessions of the Abbey under the title of Church Lands


¶257] *Land of Donnell mc Clankey, surviving*.


*Chiefrie in Ballyrobert*


A certain head rent issuing from the castle and lands of Ballyrobert free lands of said Donnell and containing 1 quarter of land in the parish of Ballyrobert, Connelo now or late in the tenure or occupation of Richard Wingfield at a yearly rent of 6*s.* 8*d.* halface payable to the Earl of Desmond for said quarter of land.


Memorandum: this quarter of land is inhabited and manured.


*Cosherie in BallyRobert*


A Cossherie yearly due to said Earl from said quarter of land in Ballyrober for two days and two nights twice a year viz after Christmas and after Easter: to last for four days and four nights, to the number of 100 persons and more.


Memorandum: these parcels are inhabited.


Memorandum: if the Earl or the Countess came not his officers might take it on his behalf as it lay in their way to or fro, for dispatch of the Earl's business.


¶258] *Land of the Bishop of Limerick*.


*Cosherye*


A Cossherie payable to the Earl of Desmond by the Bishop issuing from the lands of the bishoprick and payable at Limerick city, Cloneshere en Castellan[537](javascript:footNote('E580000-001/note537.html')) or elsewhere at the Earl's pleasure: to the number of 100 persons and more once a year for two days and two nights after Christmas worth yearly [*...*][538](javascript:footNote('E580000-001/note538.html'))


Memorandum: this parcel of land is inhabited and manured


¶259] *Land of the Chancellor, Limerick*.


*Cosherie*


A like yearly Cossherie issuing from the "Chancery" lands payable at Castellan ne Courte in like manner and worth yearly [*...*][539](javascript:footNote('E580000-001/note539.html'))


Memorandum: this parcel of land lies waste.


¶260] *Land of Garrott mc Morris called Farenagh Lymerick*.


A like yearly Cossherie payable by the Dean of Limerick issuing from said lands and payable at the Benefice of Ardaghe, in the Toghe of Ardaghe one of the 8 Toghes of Callowe, in like manner and worth yearly [*...*][540](javascript:footNote('E580000-001/note540.html'))


Memorandum: this land lies waste


¶261] *Land of the precentor alias the Canter, Limerick*.


*Cossherye*


A like yearly Cosherie payable by the precentor Limerick issuing from the precentor's land [and chargeable][541](javascript:footNote('E580000-001/note541.html')) on the benefice of Nantenan and other lands Connelo now or late in the tenure or occupation of Maurice mcPhillippe mcEdmund John de Wall and others: said cosherie is of like amount, payable at the time aforesaid and worth yearly [*...*][542](javascript:footNote('E580000-001/note542.html'))


Memorandum: this land lies waste.




---

p.120


¶262] *Land of the Parson of Asketten*.


*Cosherye*


A like yearly Cossherie payable by the Rector of Asketten issuing from the lands of the rectory of Asketten in the parish of Asketten, Connelo now or late in the tenure or occupation of Ulligg Lucey:[543](javascript:footNote('E580000-001/note543.html')) said cossherie is of the like amount, payable at the time aforesaid and worth yearly [*...*][544](javascript:footNote('E580000-001/note544.html'))


¶263] *Land of the Vicar of Asketten*.


A certain yearly Coynye and Lyverie payable to the Earl of Desmond by said vicar issuing from the benifice called the vicarage of Asketten in the parish of Asketten, Connelo now or late in the tenure or occupation of Maurice oge mcPerson. Said vicarage and premises were charged yearly with Coynye and Lyverie of two horses and horsemen and four horseboys sometimes more sometimes less at the Earl's pleasure as often[545](javascript:footNote('E580000-001/note545.html')) and as long as the Earl of Desmond remained in Connelo.


Memorandum: this land is manured and inhabited.


The donation of the vicarage of Asketten belongs to the Bishop of Limerick: hte donation of the rectory of Asketten belongs to the late monastery of Kensam in England.


¶264] *Land of the parsonage of Ballingarry parcel of the possession of the Abbey of Kensam, England.*


A certain yearly Cosherie payable to the Earl of Desmond by the rector of Ballingarreye issuing from the rectory lands in the parish of Ballingarrey, Connelo now or late in the tenure or occupation of Ulligg Lacey, Jordan Roche and others: to the number of 100 persons and more for two days and two nights once a year after Christmas worth yearly [*...*][546](javascript:footNote('E580000-001/note546.html'))


¶265] *Land of the vicarage of Ballingarrey*.


A certain yearly Coyney and Lyverie payable to the Earl of Desmond by the vicar of Ballingarrey out of the lands belonging to said vicarage in the parish of Ballingarrey Connelo, now or late in the tenure or occupation of [*...*][547](javascript:footNote('E580000-001/note547.html')) Roche vicar there. Said vicarage was charged yearly with Coynye and Lyverie of two horses and horsemen and four horseboys sometimes more sometimes less at the Earl's pleasure as often and as long as he remained in Connelo.


Memorandum: said vicarage and parsonage of Ballingarrey are inhabited and manured.


The donation of the vicarage of Ballingarrey belongs to the Bishop of Limerick: the donation of the rectory there belongs to the late monastery of Kensam in England.


¶266] *Land of the parson of Newcastell alias Castellno in Connolo*.


A like yearly Coynye and Lyverie payable by the rector of Castle no alias Newcastell out of the lands belonging to the parsonage of Newcastell in the parish of Neweastell now or late in the tenure or occupation of John mcDonnell, of Castellno. Like coynye and Lyvery as Ballingarrey vicarage.


To said Rectory belongs a Street in Newcastell called Banze en p*e*[548](javascript:footNote('E580000-001/note548.html'))rson with other tenements and gardens now or late in the tenure or occupation of Donnell O Foreman parson of Newcastle and containing ½ acre.


Also a parcel of land called Gortnehagglas situate near Newcastle parish church containing 10 acres now or late in the tenure or occupation of said parson.


¶267] Also a moiety of the tithes of 7 guarters of land in the Toghe of Meaghan, the Earl's chargeable land of all tithes of corn, hay, wool honey milk & viz from lands in the possession of James Wall of Garrynekevan, Murrogho mc Edmund oge, Murrogho mc Bryan Bryan mc Donnogho, John OConnowe, Donnell mc Neale mc Kyllmartin and others.




---

p.121


And there also belongs to said rectory a moiety of the tithes of 5½ quarters of demesne land in Newcastell parcel of the demesne lands of the said manor of Castellno called the Earl's free land, of all tithes of corn, wool, hay honey and milk now or late in the tenure or occupation of the constable of Newcastell.


Memorandum: said parsonage of Newcastle lies waste.


The donation of the rectory of Newcastell belongs to the late Earl of Desmond


¶268] *Land of the vicarage of Castellno alias Newcastell.*


A like yearly Coynye and Lyvery payable by the vicar of Castellno out of the vicarage lands in the parish of Castellno, Connelo now or late in the tenure or occupation of Dermodo OConnowe. Like coynye and Lyvery as Newcastle parsonage. To said vicarage belong certain tenements called Balliawicarie[549](javascript:footNote('E580000-001/note549.html')) near the Parcke of Newcastell containing ½ acre; the lands of Ballinvicarie containing 10 acres; the remaining moiety of the tithes of 7 quarters of land in the Toghe of Meaghan, the Earl's chargeable land, of all tithes of corn, hay, 
wool, honey, milk, &c.; A moiety of the tithes of 5½ quarters of the demesne land of Castellno manor, called the Earl's free land, of all tithes of corn, wool, hay, honey and milk.


Memorandum: said vicarage of Newcastell lies waste.


The donation of the vicarage of Newcastell belongs to the late Earl of Desmond.


¶269] *Land of the parsonage of Moneaghe Adare*.


A like yearly Coynye and Lyverie payable by the rector of Moneaghe Adare issuing from the lands of the parsonage of Moneaghe Adare in Connelo now or late in the tenure or occupation of Edmund mc Morrice mc Edmunde of Rathkealye. Double the Coyney and Lyverie of Ballmgarrey vicarage.


Memorandum: said parsonage of Moneaghe Adare lies waste.


To said rectory belong two third parts of a parcel of land of 20 acres called Carrowe ffarssen or parson's quarter viz 13 1/3 acres now or late in the tenure or occupation of the parson.


Memorandum: said parsonage of Moneaghe Adare lies waste.


Also two third parts of a certain Shradie alias the Street of Monagh Adare with certain tenements and gardens containing ½ acre.


¶270] Also two third parts of the tithes of Temple Glantan [*...*][550](javascript:footNote('E580000-001/note550.html')) the Toghe of Gortcoythe and the half Toghe of Kyllhylaghe in Connelo, being the Earl's chargeable land of all tithes of corn hay, wooll, honey, milk, &c.


Also two third parts of the tithes of certain lands in Newcastell viz Shradiegower, Garrynebynney, Rahennena, Kyllhelan, Gortycowlyfera and Gortickhollan being the Earl's free land and parcel of the demesne lands of Newcastell manor, of all tithes of corn, hay, wool, honey, milk, &c.


The donation of this benefice called the parsonage of Monaghe of Adare belongs to the late Earl of Desmond.


¶271] *Land of the vicarage of Moneagh Adare*.


A like yearly Coynye and Lyverie paid by the vicar of Moneagh Adare issuing from the land of the vicarage in the parish of Moneagh Adare, Connelo now or late in the tenure or occupation of Edwarde Ruchbarde. Like Coynye and Lyverie as Ballingarrey vicarage.


Memorandum: said vicarage lies waste.


To said vicarage belongs one third part of a certain Shradie alias the Street of Moneaghe Adare with certain tenements and gardens containing 1 rood.




---

p.122


Also one third part of a parcel of land of 20 acres called Carrot-ffarrssen alias Parsone's quarter in Monagh Adare, viz 6 2/3 acres.


¶272] Also one third part of the tithes of Temple Glantan, the Toghe of Gortcoythe and the half Toghe of Kyllhylagh in Connelo, being the Earl's chargeable land, of all tithes of corn, hay, wool, honey milk, &c.


Also ne[551](javascript:footNote('E580000-001/note551.html')) third part of the tithes of certain lands in Newcastle viz Shreadie gower, Garrynebynney, Rahennena, Kyllhelan, Gortycowlyfera, and Gortickhollan, being the Earl's free land and parcel of the demesne lands of Newcastell manor, of all tithes of corn, hay, wool, honey, milk &c.


The donation of the vicarage of Monagh Adare belongs to the Earl of Desmond.


¶273] *Land of the parsonage of Mahownaghe*.


A like yearly Coynye and Lyverie payable by the rector issuing from the lands of the parsonage in the parish of Mahownaghe Connelo, now or late in the tenure or occupation of Edmund mc Morrice of Kahehmoell. The yearly amount for Coynye and Lyverie is for three horses and horsemen, and Six horseboys: in other respects the Coynye and Lyverie are as aforesaid.


Memorandum: this parcel of land lies waste.


To said Rectory belong two third parts of a certain Shradie called the Street in Mahownaghe with certain tenements and five gardens containing ½ acre.


Also two third parts of a parcel of land containing 20 acres called Farrenhagglas[552](javascript:footNote('E580000-001/note552.html')) and situate in Mahownaghe parish viz 13 1/3 acres.


Also two third parts of all the tithes of the Toghe of Tawnaghe and Aglasse ne Groman being the Earl's chargeable land and free and chargeable land of divers persons in said Toghe, of all tithes of corn, hay, wool, honey, milk, &c.


The donation of this benefice called the parsonage of Mahownaghe belongs to the late Earl of Desmond.


¶274] *Land of the vicarage off Mahownaghe*.


A like yearly Coynye and Lyverie issuing from the vicarage lands in the parish of Mahownaghe now or late in the tenure or occupation of Donnell mc Konnoghor. The yearly amount for Coynye and Lyverie is one horse and horseman, and two horseboys: in other respects as aforesaid.


Memorandum: this land of the vicarage of Mahownaghe lies waste.


To said vicarage belongs one third part of Shradie in Mahownaghe called the street of Mahownaghe with certain tenements and three gardens containing 1 rood.


Also one third part of a parcel of land containing 20 acres called Farrenhagglas in Mahownaghe: viz 6 2/3 acres.


Also one third part of the tithes of the Toghe of Tawnaghe and Agglasse ne groman being the Earl's chargeable land and free and chargeable land of divers persons in said Toghe, of all tithes of corn, hay, wool, honey, milk &c.


The donation of this benefice called the vicarage of Mahownaghe belongs to the late Earl of Desmond.


¶275] *Lands of the parsonage of Croghe in Connelo*


A like yearly Coynie and Lyverie payable by the vicar of Ballincastellane in Corkemore issuing from the lands of the vicarage in the parish of Ballincastellane and Toghe of Cloehennerey now or late in the tenure or occupation of Laughlen mcKee mcPayne. The yearly amount for Coynie and Livery is for two horses and horsemen and four horseboys with other incidents as aforesaid.




---

p.123


Memorandum: the land belonging to this vacarage lies waste.


The donation of this benefice called the vicarage of Ballincastellane Corkemore belongs to the Bishop of Limerick


¶276] *Lands of the parsonage of Croghe in Connelo*.


A like yearly Coynie and Lyverie payable by the rector of Crogh issuing from the lands of the parsonage in the paris Croghe now or late in the tenure or occupation of Maurice mc Edmund of Rathkealy. The yearly amount for Coynye and Lyverie is for three horses and horsemen, and Six horseboys with other incidents as aforesaid.


Memorandum: the lands of Croghe parsonage lie waste.


To said Rectory belong two third parts of the castle of Castell ffersen or Parson's Castle with eight gardens in Croghe parish containing ½ acre.


Also two third parts of a parcel of land containing 20 acres called Farrenhagglas or church land in said parish: viz 13 1/3 acres.


¶277] Also all the tithes of 16 quarters in the Toghe of Croghe being the Earl's chargeable land viz Croghnomoregeez 2½ quarters; Kylltennan 3 quarters; lands in possession of Pier Pursell 5 quarters 20 acres; lands in possession of Maurice mcEdmunde Sarsffield 3 quarters 20 acres; lands in possession of Edmund mcMaurice 2 quarters; in all 16 quarters: all the tithes of corn, hay, wool, honey, milk &c.


Also like tithes of all other lands called free lands in possession of divers sub-tenants of the Earl of Desmond in the Toghe of Croghe.


The donation of this benefice called the parsonage of Croghe belongs to the late Earl of Desmond.


¶278] *Lands of the vicarage of Croghe*.


A like yearly Coynye and Lyverie payable by the vicar of Croghe issuing from the lands of the vicarage in the parish of Croghe now or late in the tenure or occupation of Edmund Hubbert. The yearly amount for Coynye and Lyverie is for a horse and horseman, and two horseboys, with other incidents as aforesaid.


Memorandum: the lands of the vicarage of Croghe lie waste.


To said vicarage belongs one third of the castle of Castell Farsen or Parson's Castle with four gardens in Crogh parish containing 1 rood.


Also one third part of a parcel of land containing 20 acres called Farren hagglas or church land in said parish viz. 6 2/3 acres.


Also all the tithes of 4 quarters in the Toghe of Croghe viz. Ballynegowe 1 quarter, Lyssenenmucky 1 quarter, Ballyaduck 1 quarter, and Ballyogoghlan 1 quarter: all the tithes of corn, hay, wool, honey, milk, &c.


The donation of this benefice called the vicarage of Croghe belongs to the late Earl of Desmond.


¶279] *Lands of Derrnodo mc Shane mc Shehee of Garrenneboye*.


A like yearly coynie and Lyverie payable by said Dermodo issuing from the lands of Garrynoboano in the parish of Beallana neashe in the country of Cosseclereogh near Kyllmallock and containing 2 quarters. The yearly amount for Coynie and Lyverie is for 4 or 6 horses, 4 or 6 horsemen, and 8 or 12 horseboys with other incidents as aforesaid and worth yearly for the 2 quarters [*...*][553](javascript:footNote('E580000-001/note553.html')).


Memorandum: this parcel of Garrynoboano in Cosseclereogh lies waste.


¶280] *Lands of Edmund mc Ruddereye of Glangibbon*.


A like yearly Coynie and Lyverie payable by said Edmund issusing from the vill and lands of 



---

p.124




Ballydonanto in the parish of Bealla Naneas in Cosseclereogh aforesaid now or late in the tenure or occupation of Maurice mcDavid and containing 2 quarters. Like coynie and Lyverie as Garrynoboano whenever the Earl of Desmond came or went through this country, with other incidents as aforesaid.


Memorandum: the town and lands of Ballydonante near Kyllmallock are manured and inhabited.


¶281] *Lands off Thomas O Hurley of Knocklyney*.


A like yearly coynye and Lyverie due and payable by said Thomas issuing from the vill and lands of Knockloyney in the parish of Bealla Naneashe in Cosseclereogh aforesaid now or late in the tenure or occupation of Ony ne velaghlen and containing 2 quarters. Like amount of Coynye and Lyverie and like incidents as Ballydonanto.


Memorandum: said town and lands of Knockleyney near Kyllmallock are manured and inhabited.


Sum of the rents of said free tenants [*...*].[554](javascript:footNote('E580000-001/note554.html'))


Sum total of all the lands and possessions of said Earl of Desmond in the Great County aforesaid [*...*].[555](javascript:footNote('E580000-001/note555.html'))


Sum total of the lands and possessions of the Earl of Desmond in the Small and Great County of Lymerick: 430½ quarters 5 acres


¶282] *Lands of divers attainted persons in the Great County of Lymerick*.


*Lands of John Supple of Kyllmucko*


The vill castle and lands of Craggan near Kyllmallock in the parish of [*...*],[556](javascript:footNote('E580000-001/note556.html')) Cosmaye now or late in the tenure or occupation
of Phillipp Suppell brother of said John Suppell and containing 3 quarters.


Memorandum: these 3 quarters are inhabited.


The vill and land of Ballinnewhollo in Adare parish, Cosmaye free lands of said John now or late in his tenure or occupation and containing ½ quarter.


A parcel of land in Cosmaye called Gortecallow: like parish free lands and tenure; and containing 10 acres.


Memorandum: said land of Gortecallow is inhabited and said land of Ballynewhollo lies waste.


The vill and land of Gorteneghe in the parish of Ballingarry, Connelo[557](javascript:footNote('E580000-001/note557.html')) like free lands, tenure and extent.


*woods*


To said 10 acres of Gorteneghe belong divers woods and underwoods in which there is timber honey and wax.


Memorandum: this parcel of land lies waste.


The vill and land of Gurtencaleboy in the parish of Ballynekylley, Connelo: like free lands and tenure and containing ½ quarter.


Memorandum: this 2 quarter lies waste.


The vill and lands of Ballinknockan in the parish of Kyllmucko, Connelo: like free lands tenure and extent.


Memorandum: this half quarter lies waste.


¶283] Three tenements in *Kyllocia*[558](javascript:footNote('E580000-001/note558.html')) alias Kyllmallock with their gardens within the walls of said town, containing 1 rood; and land for said tenements in the fields of the town containing 5 acres.




---

p.125


A piece of land called Clonrobuck in the parish of Ballinnekylley and country of Pobleneskaghe one of the 8 Toghes of Callowe or church Toghes: free lands of said John Suppell now or late in his tenure or occupation and containing 10 acres.


Memorandum: this parcel of land lies waste.


A parcel of land called Tovergyle within the vill of Ballyffynneter alias Fynnenstowne: like free lands in said parish, Toghe and tenure and containing 5 acres.


Memorandum: this parcel of land lies waste.


A certain yearly Refection due and payable to said John Supple by William oge Mahownde issuing from the vill and lands of Ballynvawnaght in Ballynekyllye parish Connelo, of a cow called a Marte or Beeffe, a hog, a hogshead of (servicium) ale or beer, 2 gallons of aqua vitae, 1 bushel of wheat meal containing 3 barrels, each barrel containing 30 gallons: all worth yearly [*...*].[559](javascript:footNote('E580000-001/note559.html'))


Memorandum: this land lies waste.


Another piece of land called Craggmortyll in Adare, Cosmaye now or late in the tenure or occupation of said John Suppell and containing 10 acres.


Memorandum: this parcel of land lies waste.


Sum of the lands of John Suppell of Kyllmucko in the Great County aforesaid [*...*].[560](javascript:footNote('E580000-001/note560.html'))


¶284] *Lands of John Braclaghe Okahytssy*.


The vill and land of Kylldyrry with a ruinous Castle in the parish of [*...*],[561](javascript:footNote('E580000-001/note561.html')) Poblebryen, now or late in the tenure or occupation
of Maurice Shehan and containing 1 quarter.


Memorandum: this quarter of land is inhabited.


A parcel of land in Raphin alias Rathyn, in the parish of Crean koeraghe, Poblebryen now or late in the tenure or occupation of said John Bradaghe Okahyssy and containing 20 acres.


Memorandum: this parcel of land lies waste.


A part of the vill of Clonanaghe in the parish of [*...*][562](javascript:footNote('E580000-001/note562.html')) Poblebryen containing ½ quarter.


Memorandum: said ½ quarter called Clonanaghe is manured and inhabited.


Sum of the lands of John Bradaghe Okahyssy in the Great County of Lymerick 1 ½ quarters 20 acres.


¶285] *Lands of Brian Roo of Lackyn Grenan*.[563](javascript:footNote('E580000-001/note563.html')) 


The vill and land of Lackingrenan in the parish of Ballykahan, Poblebryen now or late in the tenure or occupation of Maurice Shehan; gent, and containing 1 carucate or quarter.


Memorandum: this quarter of land is inhabited.


The vill and land of Kaherduffebrian Roo: like situation, tenure, and extent.


Memorandum: this quarter of land lies waste.


Sum of the lands of Brian Roo in said Great County: 2 quarters.


¶286] *Lands of Thomas mc Rudderye of the Glan otherwise called Knighte of the vallye*.


A part of the vill[564](javascript:footNote('E580000-001/note564.html')) of Ardcanny in the parish of Ardcanny and country of Kenryhurragh free lands of said Thomas now or late in his tenure or occupation and containing 1 quarter.


The vill castle and land of Roynkyrk[565](javascript:footNote('E580000-001/note565.html')) in said parish and country: like free land, tenure and extent.


The vill and land of Clooran and part of the vill and lands of Kylldymma in the parish of Kylldymma in said country: like free land and tenure and containing 2 quarters.




---

p.126


Memorandum: these 4 quarters of land lie waste.


Sum of the lands of Thomas mcRudderye knight of the valley in co. Limerick: 4 quarters.


¶287] The vill castle and land of Pallice[566](javascript:footNote('E580000-001/note566.html')) mc William whym[567](javascript:footNote('E580000-001/note567.html')) in the parish of Ardcanny in said country now or late in the tenure or occupation of Garrott mc Thomas mc William Cam one of the sub-tenants of said Thomas mc Rudderye. These lands are called Farren dollo Ruddery[568](javascript:footNote('E580000-001/note568.html')) alias the chargeable land of the Knight of the valley of Kenry Hurraghe; and they are chargeable with a yearly rent of Shragh and Marte, besides Cosherie, Coynye and Lyverie worth yearly [*...*].[569](javascript:footNote('E580000-001/note569.html'))


Memorandum: this parcel of land is inhabited.


The vill castle and land of Beolane: like situation, tenure, Farren dollo Ruddery, &c as Pallice mc William whym.


Memorandum: said town and lands of Beolane are inhabited.


Part of the vill and land of Kylldymma in the parish of Killdymma ffenn: like country, tenure, Farren dollo Ruddery, &c as Pallice mc William whym.


Memorandum: said town and lands of Kylldymma lie waste.


These lands of Pallice mc William whym, Beolane and Kylldymma jointly contain 4 quarters.


¶288] The vill castle and lands of Courte mc Reynoyde in the parish of Kylldymma: like country, Farren dollo Ruddery &c. as Pallice mc William whym; now or late in the tenure or occupation of Garrott mc Gibbon mc Reynold one of the sub-tenants of Thomas mc Ruddery and containing 2 quarters.


Memorandum: said town castle and lands are inhabited.


The vill and land of Ederrcloghan in the parish of Kylldymma: like country, Farren dollo Ruddery, &c, as Pallice mc William whym; now or late in the tenure or occupation of Garrott mc Gibbon mc Reynold one of the sub-tenants of Thomas mc Ruddery.


Memorandum: this parcel of land is manured and inhabited.


¶289] The vill and land of Kyllyshoroth in the parish of Ardcanny: like country, Farren dollo Ruddery &c as Pallice mc William whym, now or late in the tenure or occupation of Edmund oge mc Edmund mc Garrott one of the sub-tenants of Thomas mc Rudderye.


Memorandum: this parcel of land is inhabited.


¶290] The vill and land of Enghkorogh[570](javascript:footNote('E580000-001/note570.html')) or the Weare in the parish of the White Abbey of Adare: like country, Farren dollo Ruddery &c. as Pallice mc William whym: now or late in the tenure or occupation of John mc William mc Korro one of the sub-tenants of Thomas mc Rudderye.


Memorandum: this parcel of land is inhabited.


The vill and land of Droomemoghurr in the parish of Kylldymma: like country, Farren dollo Ruddery, &c as Pallice mc William whym.


Memorandum: this parcel of land is inhabited.


Said denominations of Ederrcloghan, Kyllyshoroth, Enghkorogh, and Droomemoghurr jointly contain 10 quarters.


¶291] The residue of the vills and lands of Kenryhurraghe aforesaid and of the country of Kenryehurraghe in the possession of Thomas mc Rudderye or any of his sub-tenants not specified herein and containing 20 carucates more or less, totally belongs to the Queen by the attainder of said Thomas mc Rudderye, lord of the country, and the Earl of Desmond. They were formerly lands and possessions of the Earl of Desmond for the reservation of royal service.




---

p.127


*woods*


There are certain woods and underwoods there in which there is timber, viz Kyllkenry and Bellagh ne Cranney.


*Fishing*


A fishing on the river Shannon belongs to the inhabitants of the country so far as it extends along the country.


A fishing on the lands of the inhabitants on both sides of the river Maye similarly belongs, to the inhabitants of the country.


¶292] Memorandum: within the country of Kenrye hurragh is the town of Ballykoollen in the parish of [*...*][571](javascript:footNote('E580000-001/note571.html')) containing 4 ½ 
quarters, over and above 20 quarters belonging to the Knight of the valley, in the tenure and occupation of Pierce Pursell. This town of Ballykoollen is free of all rents, Shragh and Marte; and of all Sess Cossherie, Coynie and Lyverie to the Earl or the Knight of the valley.


Memorandum: the tenants of the country of Kenryhurragh owe suit of court and service at the court of the manor of Ballyncastellane in Kerry alias Kerry more.


Memorandum: said country of Kenrye hurraghe was formerly the possession of the Earls of Desmond and given to one of their sons who was made Knight of the valley reserving to the Earls of Desmond 5*l.* halface yearly besides Sesse and Service.


Sum of said lands in the Country of Kenryhurragh: 20 quarters.


¶293] *Kerry More*.


The country called Kerry alias Kerry more in the Great county of Lymerick which belongs to said Thomas mc Rudderye and is chargeable yearly at his pleasure with divers rents of Shragh, Marte, Chifferie, Cossherie, Coynie and Lyyerie. Said country late in the tenure or occupation of Captain Bartlett contains the 40 quarters following viz.


The vill castle and lands of Ballincastellane commonly called the manor of Ballyncastellane in the parish of Kyllkurnan in Kerry more, parcel of the demesne lands of said manor and called the Knight's free land: now or late in the tenure or occupation of Edmund mc Thomas mc Rudderye.


The vill and lands of Kyllkurnan:[572](javascript:footNote('E580000-001/note572.html')) like situation and parcel as aforesaid: now or late in the tenure or occupation of Thomas mc Rudderye, Knight of the valley otherwise mc Ruddery of the Glann.


The vill and lands of Ilan more Ruddery:[573](javascript:footNote('E580000-001/note573.html')) like situation parcel and tenure as Kyllkurnan.


These denominations of Ballincastellane, Kyllkurnan, and Ilan more Ruddery jointly contain 4 quarters.


Memorandum: said town of Kyllkurnan is inhabited and manured; and the town and lands of Ilan more lie waste.


¶294] The vill and land of Ballygeorge alias Georgestowne: like situation, parcel and tenure as Kyllkurnan and containing 1 quarter.


Memorandum: this quarter of land lies waste.


*mill*


There belongs to said will of Ballygeorge a water mill now ruinous called Mollyn Ballygeorge built on the river Ballygeorge.


The vill and land of Kyllbryde: like situation parcel and tenure as Kyllkurnan and containing 2 quarters.


In this denomination the parcel is called ffarren syer[574](javascript:footNote('E580000-001/note574.html')) Ruddery in English the Knight's free land.




---

p.128


The vill and land of Ballyno[575](javascript:footNote('E580000-001/note575.html')) in Kyllkurnan parish, Kenrymore now or late in the tenure or occupation of Edmund oge mc Edmunde mc David one of the sub-tenants of Thomas mc Ruddery said lands are ffarren dollo Ruddery alias the Knight of the valley's chargeable land in Kerry more viz with the yearly rents of Shragh and Marte besides Cossherie, Coynie Lyverie and the like: they contain 2 quarters and are of the yearly value of [*...*].[576](javascript:footNote('E580000-001/note576.html'))


The vill and land of Ballynemony: like situation: ffarren dollo Ruddery with incidents as aforesaid. They are lands now or late in the tenure or occupation of John mc Morris mc Rudderye a sub-tenant as aforesaid: they contain 1 quarter and are of the yearly value of [*...*].[577](javascript:footNote('E580000-001/note577.html'))


Memorandum: this quarter of land lies waste.


The vill and land of Garren bellaghno: like situation, ffarren dollo Rudderye, tenure extent and value as Ballynemony.


Memorandum: this quarter lies waste.


¶295] The vill and land of Ballykahan: like situation and ffarren dollo Rudderye, and now or late in the tenure or occupation of Thomas mc Rudderye alias mc Rudderye of the Glann.


Memorandum: this parcel of land lies waste.


The vill and land of Mournan: like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and lands of Clonogwyllen: Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and land of Ballyhonuck bane alias Johnstowne: like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and land of Ballynowgoole: like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


¶296] The vill and land of Ballyvaduk: like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and land of Kyllahaunssaen: like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and land of Lystrumloghan:[578](javascript:footNote('E580000-001/note578.html')) like Ballykahan in all respects.


Memorandum: this parcel of land lies waste.


The vill and land of Granarde: like Ballykahan in all respects except that the premises are now or late in the tenure or occupation of Edmund mc David mc Ruddery one of the sub-tenants of Thomas mc Rudderye.


Memorandum: this parcel of land lies waste.


The vill and land of Hurrough alias Nehurraghe: like Ballykahan in all respects except that the premises are now or late in the tenure or occupation of Donnogho mc Teige ne Currogh one of the sub-tenants of Thomas mc Rudderye.


Memorandum: this parcel of land lies waste.


¶297] The said denominations of Ballykahan, Mournan, Clonogwyllen, Ballyshonuckbane, Ballynowgoole, Ballyvaduk, Kyllahaunssaen, Lystrumloghan, Granarde, and Hurrough alias Nehurraghe, jointly contain 13 quarters.




---

p.129


¶298] The vill castle and lands of Beaghagh commonly called the manor of Beaghagh in the parish of Kyllkurnan in that parcel of Kenrye more called Yeaghrosse now or late in the tenure or occupation of Thomas mc Ruddery alias mc Ruddery of the Glan, parcel of the demesne lands of Beaghagh manor and called the Knights free land: they contain 4 quarters.


Memorandum: said castle and part of the lands about the castle are manured: the rest lie waste.


The vill and land of Aglasserosse:[579](javascript:footNote('E580000-001/note579.html')) like situation and tenure as Beaghagh but these lands are ffarren dollo Rudderye with like incidents as Ballyno aforesaid and they contain 2 quarters.


Memorandum: these 2 quarters lie waste.


The vill and land of Ballynecourte: like situation, tenure, and ffarren dollo Rudderye as Aglasserosse: these lands contain 3 quarters.


Memorandum: these 3 quarters lie waste.


The vill and land of Ballyestine situate in the parish of Egolassorosse:[580](javascript:footNote('E580000-001/note580.html')) otherwise like situation, tenure, and ffarren dollo Rudderye as Aglasserosse: these lands contain 1 quarter.


Memorandum: this quarter is inhabited.


¶299] *The vill and land of Ballykannanig: similar in situation, tenure, &c and extent to Ballyestine*.


Memorandum: this quarter of land is inhabited.


*woods*


There are certain woods and underwoods there in which there is timber, viz Kyllkenry, Kyllnekorro, Kyllnecurrogh, Kyllballygagh Kyllbryde, and Kyllbellaghno; and there are underwoods there called Kyllbellaghcraghneff in which there is no timber.


¶300] *Fishing*


A certain fishing on the Shannon belongs to Kenrymore and its inhabitants so far as the river extends along this country.


The donation of the parsonage of Kyllcurnan belongs to mc Rudderye of the Glan.


The donation of the vicarage of Kyllcurnan belongs to the Bishop of Limerick.


The donation of the parsonage of Egalasserosse belongs to the late Abbey of Kensam in England.


The donation of the vicarage of Egalasserosse belongs to the Bishop of Limerick.


¶301] Memorandum: said country of Kenrymore contains the townships of Ballygellahan and Kyllwyrry in Kyllkurnan parish containing 4 quarters; and Ballynvoher in Yeaghrosse containing 1 quarter. These are chargeable not to the Knight of the valley but to the Earl of Desmond and are charged hereinbefore under the title of Sorrahen Coynye and Lyverie.


Memorandum: the tenants of Kenrymore owe Suit and Service at the Court of the manor of Ballincastellane.


Memorandum: the country of Kenrymore formerly belonged to the Earls of Desmond but was given to one of the sons who was made Knight of the valley with reservation of all royalties and Cess.


Sum of said lands in the country of Kenrymore, 35 quarters


¶302] The site of the manor of Glancorbry with the demesne lands thereof in the parish of Kyllfaryse, Connelo called ffarren Syer Ruddery of the Glann or the Knight's free land in Glancorbrye. The premises contain 10½ quarters and so are a moiety of the Toghe of Glancorbrye which contains 20½ quarters.


¶303] These 10½ quarters now or late in the tenure or occupation of Captain Colham consist of the following denominations viz. the vill castle and land of Cloghglan ½ quarters; the vill and land of 



---

p.130




Skartyone to said site and castle belonging 1 quarter; the vill and land of Kyllehallaghe similarly belonging 1 quarter; the vill and land of Knockdolloboye similarly belonging 1 quarter with memorandum that it is inhabited; similarly to Knockdolloboye the several quarters of Philliane, Cromyglan, Clonesillagh with the mountain or parcel of land called Kyllyen tieg dowrey, Tullaghleigh, Rahanna,[581](javascript:footNote('E580000-001/note581.html')) and Kurraghagaddy containing 6 quarters.


¶304] *woods*


There are divers woods and underwoods belonging to the said site castle and manor of Glancorbry, in which there is timber, viz:— Kyllskartyone, Kyllkyllehallagh, Kyllkockdolloboye, Bellaghneclasseganny, Kyllcromyglan, Kyllclonesellagh, Kylltullaghleigh, Kylleneigh, Kyllrahanna and Kyllcurraghagaddye.


¶305] *Fishing*


There is a fishing on the river of Shannon.


*Hawks*


There is an aerie of Hawks called "Goshawcks" in the wood of Kylleyney.


There is an iron mine of Iron stone on the lands of Tullagh Leigh, and Kylleyneigh which are on the mountain of Slevelogher.


Sum of said lands in Glancorbry 10½ quarters.


¶306] Besides 10 quarters in the half Toghe of Glancorbry, Connelo, late in the possession of Thomas mc Rudderye of the Glan, parcel of the Earl of Desmond's chargeable land in Connelo already charged amon[582](javascript:footNote('E580000-001/note582.html')) the Earl's lands viz[583](javascript:footNote('E580000-001/note583.html')) Tulloghglass, Keynarde Ballycullan, Ballycoghlane, Meanes, Ballygonnoghowe, Tannacourte Ballynemoddaghe, and Ballynegalte;[584](javascript:footNote('E580000-001/note584.html')) each of these denominations containing 1 quarter except Meanes which contains 2 quarters.


¶307] A piece or parcel of land called Rerageen Rudderye[585](javascript:footNote('E580000-001/note585.html')) in the parish of Ardage,[586](javascript:footNote('E580000-001/note586.html')) Connello now or late in the tenure or occupation of Gerald mc David and John mc Morrice mc Rudderye


These lands are called the land of the Knight of the valley in Ardagh, parcel of the Toghe of Ardaghe one of the 8 Toghes of Callowe or church toghes: they are charged to the Earl of Desmond with Sorrahen, Coynie and Lyverie but are not included under that title because owing to the attainder of said Thomas mc Rudderye they are chargeable here: they contain 1½ quarters.


Memorandum: this parcel of land lies waste.


A piece or parcel of land called ffarrennegeyry[587](javascript:footNote('E580000-001/note587.html')) alias Tullogh's land situate in said parish of Ardaghe and in the tenure of said Gerald and John. This parcel is portion of Thomas mc Ruddery's free land in Ardaghe and contains 10 acres.


Memorandum: this parcel of land lies waste.


¶308] *Manor of Cappa*.


The vill castle and land of Cappa[588](javascript:footNote('E580000-001/note588.html')) situate in the parish of 
Kyllnecappa, Connelo, and parcel of the Toghe of Cappa one of the 8 Toghes of Callowe called church toghes.[589](javascript:footNote('E580000-001/note589.html')) said premises now or late in the tenure or occupation of said Thomas mc Ruddery of the Glan and containing 1 quarter.


Memorandum: this quarter of land lies waste


The vill and land of Kyllnecappa: like situation tenure and extent as Cappa, and described as parcel of Cappa manor.


Memorandum: this quarter of land lies waste.


The vill and land of Cragbegg: like Kyllnecappa in every respect.


Memorandum: this quarter of land lies waste.




---

p.131


Certain woods and underwoods, in which there is timber, belonging to Cappa manor viz. Currogha londoneg[590](javascript:footNote('E580000-001/note590.html')) and Kyllcragbegg.


Sum of the manor of Cappa aforesaid with certain lands of Ardaghe 4½ quarters 10 acres.


¶309] Besides 8 quarters of land parcel of the manor of Cappa, parcel of the chargeable land of the Earl of Desmond in the Toghe of Croghe, and which are charged already in the Toghe of Croghe, Earl's lands, viz: Croghnomoregez 2½ quarters, Clohokotrydeboy 1½ quarters, Ballingowle 1 quarter, Lysnemockey 1 quarter, Ballyogoghlane 1 quarter, and Balliaduck 1 quarter: in all 8 quarters.


¶310] A yearly rent issuing from the Toghe vill and lands of Oryrey in the parish of Monestery Evin alias the White Abbey in Adare and situate in Cosmay between Kenrymore and Connello. It contains 2 quarters of land now or late in the tenure or occupation of Teige mc Dermodo netoghe being his own lands but chargeable to said mc Rudderye of Glan with Sraghe, Marte Coyney, Lyverey, and other similar charges at mc Rudderye's pleasure. There is also due and payable to the Earl of Desmond by said Teige in respect of same lands like charges of Coyney and Lyvery for 8 galloglas 2 days and 2 nights, every quarter of a year amounting 64 persons for 1 day and 1 night and worth yearly [*...*].[591](javascript:footNote('E580000-001/note591.html')).


*woods*


Certain wood and underwood called Kylnetoghe in which there is timber.


Memorandum: one of the quarters is inhabited and the other lies waste.


Sum of the lands and possessions of Thomas mc Ruddery of the Glan in the Great County of Lymerick: 72 quarters 10 acres.


¶311] *Clanwilliam.*


*Lands of John Browne of Knockmonye.*.


The vill castle and land of Rathtewer[592](javascript:footNote('E580000-001/note592.html')) in the parish of Lymerick in Clanwilliam now or late in the tenure or occupation of said John Browne; containing 2 carucates or quarters worth yearly [*...*].[593](javascript:footNote('E580000-001/note593.html'))


Memorandum: a third part of said vill and land formerly belonged to FitzSimonds and was subject to a yearly rent of 1*l.* payable to the mayor bailiffs and inhabitants of Limerick city. John Browne bought said third part so that the vill of Rathtewer aforesaid totally belongs to him.


Memorandum: said town and land lies waste but is inhabited.


Sum of the land and possessions of John Browne in the Great County of Limerick: 2 quarters.


¶312] *Cosmaye*


*Lands of Walter Leo of Dunkipp*.


The vill castle and land of Downekippe in the parish of Nenoghe, Cosmaye, now or late in the tenure or occupation of Maurice Shehan, gent containing 1½ carucates or quarters worth yearly [*...*].[594](javascript:footNote('E580000-001/note594.html'))


*Fishing*


A fishing on the river Canmocke[595](javascript:footNote('E580000-001/note595.html')) belonging to said vill and lands so far as the river extends beside them.


Memorandum: the half quarter of said land of the town of Dunkippe is inhabited: the other quarter lies waste.


Sum of the lands and possessions of Walter Leo in the Great County of Lymerick 1½ quarters.




---

p.132


¶313] *Clanwilliam*.


*Land of Ullig mc Thomas Bourck*.


A parcel of land in Lysmollande in the parish of Kaherkanlishe, Clanwilliam now or late in the tenure or occupation of said Ullig and containing 15 acres.


Memorandum: this parcel is inhabited.


Sure of the lands and possessions of said Ulligg in the Great County of Lymerick 15 acres.


¶314] *Connelo*.


*Land of Edmund Dullarde*.


A parcel of land called ffarrendoularde alias Dowlardslande in the parish of Ardagh, parcel of the toghe of Ardage, one of the 8 toghes of Callowe or church toghes; now or late in the tenure or occupation of said Edmund and containing 20 acres.


Another parcel of land called Droom en Doullarde like situation; now or late in the tenure or occupation of Thomas mc Rudderye, called Knight of the valley who has it in mortgage; and containing 20 acres.


Memorandum: this half quarter of land lies waste.


Sum of the lands and possessions of said Edmund in Connelo, Great County of Lymerick ½ quarter.


¶315] *Land of Garrot mc James mc Edmunde of Tomgyllye*.


The vill castle and land of Tomgilly alias Tomegylye in the parish of Tomegyllye, Connelo; now or late in the tenure or occupation of said Garrott, containing 4½ quarters.


*Fishing*


There is a fishing on the river Shannon there.


A parcel of land called Greinshe Ilan:[596](javascript:footNote('E580000-001/note596.html')) like situation and tenure containing 20 acres.


Memorandum: Tomegyllye and Greinshe Ilan lie waste: they are situate in one of the 8 Toghs of Callowe or church toghes viz Tomegyllye.


Sum of the land and possessions of said Garrott in the Great County aforesaid 4½ quarters 20 acres.


¶316] *Land of Nicholas ffitz William, receiver-general of the Earl of Desmond.*


A tenement and parcel of land called Gardin nashe in the vill and parish of Rathkealy on the side of Rathkealye bridge, parcel of the free lands of said Nicholas, now or late in the tenure or occupation of John Okonnowe, containing ½ acre and worth yearly [*...*].[597](javascript:footNote('E580000-001/note597.html'))


Another tenement and parcel of land called Gardin ne whoan[598](javascript:footNote('E580000-001/note598.html')) alias the "backehowse garden. like Garden Nashe in every respect except that they only contain ½ rood.


Another tenement and parcel of land called Gardin Matrask [599](javascript:footNote('E580000-001/note599.html')) like Gardin Nashe in every respect except that they are on the west side of the bridge[600](javascript:footNote('E580000-001/note600.html')) and only contain ½ rood.


Memorandum: said 3 tenements and 3 *roods*[601](javascript:footNote('E580000-001/note601.html')) are inhabited by Dermode oge Olyre.


¶317] The vill and land of Ballywollan alias Ballvwoollhane[602](javascript:footNote('E580000-001/note602.html')) in the parish of Clonettye Connello now or late in the tenure or occupation of said Nicholas containing ½ quarter of the yearly value of [*...*].[603](javascript:footNote('E580000-001/note603.html'))


*woods*


Certain woods and underwoods there called Kyllballywolhan in which there is timber and abundance of honey.


Memorandum: this half quarter of land lies waste.




---

p.133


The vill and land of Garrenglossick in the parish of Rathekenly,[604](javascript:footNote('E580000-001/note604.html')) Connello: like tenure and containing 20 acres worth yearly [*...*].[605](javascript:footNote('E580000-001/note605.html'))


*woods*


Certain woods and underwoods called Kylgarrenglossick in which there is timber.


Memorandum: the town and lands of Garrenglossock lie waste.


¶318] The vill and lands of Cappa Edmunde: like situation, tenure and extent as Garrenglossick.


*woods*


Certain woods there called Kyllcappa edmund in which there is timber.


Memorandum: the town and lands of Cappa Edmunde lie waste.


The vill and land of ffarrenne caheraghe in the parish of Askeatin: like tenure and extent as Garrenglossick.


*woods*


Certain woods there called Kyllcahere in which there is timber.


Memorandum: the said town and lands of fferrenneCaheraghe lie waste.


¶319] The vill and land of Ballyralaghe[606](javascript:footNote('E580000-001/note606.html')) in the parish of Graunshe. Connolo, now or late in the tenure or occupation of Rorey mc Shehie containing ½ quarter and worth yearly [*...*].[607](javascript:footNote('E580000-001/note607.html'))


Certain woods and underwoods there called Garren Ballyrala but there is no timber in them.


Memorandum: this half quarter lies waste.


Sum of the lands and possessions of Nicholas fitzWilliam in the Great County of Lymerick 1 quarter 60 acres.


¶320] Besides 7½ quarters charged among the lands of the Earl of Desmond viz:— Ballye 1 quarter, Ballynullahagh 1 quarter, Kylcolman ½ quarter, Ardbeoghlo 1 quarter, in the Toghe of Olybane; Athlyne 1 quarter, Ballynebrowing 1 quarter in the Toghe of Asketten; and Ballynehagh ½ quarter in the Toghe of 
Gortculligan.


¶321] *Land of John Oge mc Rudderye of Ballinvestelige, called the White Knight*.


*Cossetlereogh*


The castle and land of Courterudderye with certain yards gardens and orchards adjacent to the castle, near the walls of Kylmallock on the north side said premises situate in the parish of Kylmallock, Cossetlereogh, Great County of Limerick now or late in the tenure or occupation of John Verdon of Kilmallock contain ½ quarter.


Memorandum: said lands are manured and inhabited.


*mills*


A water mill called Mollen Court Ruddery near Kylmallock adjacent to said castle, built on the river[608](javascript:footNote('E580000-001/note608.html')) flowing from Mannagh moore towards Killmallock in said tenure and worth yearly [*...*].[609](javascript:footNote('E580000-001/note609.html'))


A third part of another water mill called Mollen Kylmallock or Kylmallock mill built on the river of Kylmallock: it belongs to said castle of Courte Rudderye and is now ruinous.


Memorandum: the mill called Mollen Courte Rudderye is inhabited.


A parcel of land called Kerowgarrow belonging to said castle: like situation and tenure and containing ½ quarter.


Memorandum: this half quarter is inhabited.




---

p.134


¶322] Divers parcels in Cossetlereo called ffarren dollo Rudderye or the White Knight's chargeable land charged with Shreagh, Marte, Coyney and Lyverey and other like charges at the pleasure of said Ruddery fann[610](javascript:footNote('E580000-001/note610.html')) called the White Knight, viz:— the castle vill and lands of Knockloynye in the parish of Bellaneneashe now or late in the tenure or occupation of Ony neave Laghlen and Maurice Mc Kaa, containing 2 quarters.


Memorandum: one quarter is inhabited and the other not.


The vill castle and land of Ardiskeaghe alias Ardeske in the parish of Kyllbiggeley now or late in the tenure or occupation of John Garrett of Ardeskeaghe and containing 2 quarters.


Memorandum: the town and lands of Ardeskeaghe lie waste.


The castle and kind of Ballydonnounte in the parish of Emmelye as is said now or late in the tenure or occupation of Edmond mc Rudderye and containing 2 quarters.


Memorandum: the town and lands of Ballydonnomounte are inhabited.


¶323] The vill castle and lands of Ballingreney in the parish of Bellaghea neashe now or late in the tenure or occupation of [*...*].[611](javascript:footNote('E580000-001/note611.html')) and containing 1½ quarters.


Memorandum: the town and lands of Ballingreney lie waste.


The vill castle and lands of Ballin James: like Ballingrency in every respect.


Memorandum: the town and lands of Ballin James lie waste and uninhabited.


The vill castle and lands of Raynewytaghe: like Ballingreney in every respect, except the extent is only ½ quarter.


Memorandum: the town and lands of Raynewytagh lie waste and uninhabited.


Sum of the lands and possessions of John Oge mc Ruddery called the White Knight in the Great County aforesaid 10½ quarters.


¶324] *Connelo*.


*Land of Robert Oge Quisshen*.


A moiety of the vill and land of Ballyworishen alias Ballymorrishen in English Morristowne in the parish of Graunsha and half "toaghe" of Ogallowher,[612](javascript:footNote('E580000-001/note612.html')) Connelo, now or late in the tenure or occupation of John Ocanbane and containing 20 acres, said lands are called farren sere[613](javascript:footNote('E580000-001/note613.html')) Robert oge.


Besides the other moiety of like situation and extent charged among the chargeable lands of the Earl of Desmond in said half "toaghe".


*Fishing*


A Fishing for eels on the river Deell.[614](javascript:footNote('E580000-001/note614.html'))


Sum of the lands and possessions of Robert oge Quisshen in said Great County 20 acres.


¶325] *Land of Richard mc Thomas of Pallice*.


The castle and lands of Pallice in the parish of Ballincastlan, Toghe of Clonehenerye, Connelo now or late in the tenure or occupation of Richard mc Thomas: these lands are called ffarren Sere mc Thomas in English "mc Thomas his" free land and contain 3 quarters.


*woods*


Certain woods and underwoods there called Dromroe in which there is timber.




---

p.135


There is there an "Eyrie of Gosshauk".[615](javascript:footNote('E580000-001/note615.html'))


*Donations*


The presentation of the benefices of Raroran called the parsonage and vicarage of Raroran belong to said Richard mc Thomas.


Memorandum: the town and lands of Pallice lie waste.


Sum of the lands and possessions of Richard mcThomas in the Great County of Limerick: 3 quarters.


¶326] *Land of Gerrald mc Thomas of Kyllffynnay*.


The vill castle and land of Kyllfynney near Kylmallock in the parish of Ballynekylly Connelo, now or late in the tenure or occupation of said Gerald and containing 1 quarter.


*woods*


Certain woods and underwoods called Kyllkyllthynney in which there is timber.


The vill and land of Ballynekyllye in said parish, Connelo now or late in the tenure or occupation of Edmund mc Thomas oge of Kyltynneye and containing 1 quarter.


*woods*


Certain woods and underwoods there called Kylballynekylley in which there is timber.


The vill and land of Scartenegeraghe like situation and extent as Ballynekyllye, now or late in the tenure or occupation of Edmunde Gankoghe mc Morris mc Thomas.


Certain woods and underwoods there called Kylscartenegeraghe in which there is timber.


Memorandum: said three quarters of land all lie waste.


Sum of the lands and possessions of said Gerald mc Thomas in Co. Lymerick: 3 quarters.


¶327] *Gonoghte mc Bryan*.


*Land of Donnogho moele mc William mc Bryan*.


The vill and land of Dromelare in the parish of Grean Ogonoght and Country of Gonnoghte mc Bryan, Great County of Limerick now or late in the tenure or occupation of said Donnogho and containing 2 quarters.


Certain woods and underwoods there called Kyldromelare in which there is timber.


A certain Salmon fishing on the river Moelkaerde.[616](javascript:footNote('E580000-001/note616.html'))


Memorandum: said two quarters lie waste and uninhabited.


Sum of the lands and possessions of said Donnogho of Dromlare in Co. Limerick 2 quarters.


¶328] *Obrian Arrey*.


*Land of Morierthaghe Mergaghe*.


The vill and land of Kyllduffe in the parish of Kyllduffe, Toghe of Asgrenan, in the Country of Obrian Arrey alias mc Obryan Arrey's Country in the Great County of Limerick now or late in the tenure or occupation of said Moriertagh and containing 1 carucate or quarter.


*woods*


Certain woods and underwoods there called Bellagh ne Kylledoye in which there is timber.


Memorandum: the said quarter of land lies waste.


Sum of the lands and possessions of said Moriertagh in the Great County of Lymerick 1 quarter.




---

p.136


¶329] *Connelo*


*Land of Owin mc Edmunde of Ballino*.


The vill castle and land of Ballino alias Newtowne in the parish of Cloynelty, Connelo, free land of said Owin now or late in his tenure or occupation and containing 1½ carucates or quarters.


*woods*


Certain woods and underwoods there called Kyllballyno in which there is timber.


Memorandum: these 1½ quarters of land lie waste.


Sum of the lands and possessions of said Owin of Ballino in the Great County of Lymerick 1½ quarters.


¶330] *Clenlesse*.


*Land of Thomas mc Shane mc Edmunde otherwise called Thomas.*


Cam late of Gortnetobred, lord of Clenlesse.[617](javascript:footNote('E580000-001/note617.html'))


Divers lands and tenements in the parish of Kyllydye in the country of Clonlesse, Connelo called ffarren Sier Thomas or the free land of the lord of Clonlesse now or late in the tenure or occupation of said Thomas viz The vill castle and land of Kyllydye and the parcels of land called Moinydy, Kyllenvoher, Bellaghnegressan, and Torreyn I vicary containing in all 3 quarters.[618](javascript:footNote('E580000-001/note618.html'))


*woods.*


Certain woods and underwoods there in which there is timber viz Kyllmoinydy, Kyllkyllydy, Kyllkyllenvoher, Kyllbellaghnegressan, and Kyll Torreyn I vicary.


Memorandum: said three quarters of land lie waste.


¶331] The vill and land of Clenoghe: like situation free land and tenure and containing ½ quarter.


Memorandum: said half quarter lies waste.


Certain woods and underwoods there called Curragh Clenoghe in which there is timber.


The vill and land of Culshonnekyn: like situation, free land, tenure and extent as Clenoghe.


*woods*


Certain woods and underwoods there called Kyllculshoinekyn in which there is timber.


Memorandum: this half quarter lies waste.


The vill and land of Leaughmoore: like situation free land, tenure, and extent as Clenoghe.


*woods*


Certain woods and underwoods there called Kyll leaughmore in which there is timber.


Memorandum: this half quarter lies waste.


¶332] The vill and land of Leaughbegg: like situation, free land, tenure, and extent as Clenoghe.


*woods*


Certain woods and underwoods there called Kyll leaughbegg in which there is timber.


Memorandum: this half quarter lies waste.


The vill and land of Kyllconeroo: like situation, free land and tenure as Clenoghe and containing 1 quarter.




---

p.137


*woods*


Certain woods and underwoods there called Kyllkyllkonroo in which there is timber.


Memorandum: this half[619](javascript:footNote('E580000-001/note619.html')) quarter lies waste.


The vill and land of Ballyntubber: like situation free land, and tenure as Clenoghe and containing ½ quarter.


*woods*


Certain woods and underwoods there called Kyllballintubber in which there is timber.


¶333] Divers vills and lands viz: Gortnetubbred, Kyllmighell Kyllynallata, and Rossne Rylan, situate in the parish of Kyllmigheele in the country of Clenlesse, Connelo: like free land and tenure as Clenoghe and containing 3 quarters.


*woods*


Certain woods and underwoods there called Kyllnemona and Kyllkyllynallata in which there is timber.


Memorandum: these 3 quarters are inhabited.


¶334] The vill and land of Ballymackerry[620](javascript:footNote('E580000-001/note620.html')) in the parish of Kyllhylaghe, Monaghe Adare in the country of Clenlesse, Conello: like free land and tenure as Clenoghe and containing 1 quarter, 20 acres.


*woods*


Certain woods and underwoods there called Glannanurlane[621](javascript:footNote('E580000-001/note621.html')) and Lackenadarreraghe in which there is timber.


*aerie*


On the woods of Glannanurlane there is an aerie of hawks called Goshawks.


Memorandum: this parcel of land in Ballymackerry lies waste.


A parcel of land called Dromedewyn in the parish of Kyllhylaghe on a part of the mountain of Slevelogher called Clenlesse in Connelo: like free land and tenure as Clenoghe and containing ½ quarter.


*woods*


Certain woods and underwoods called Glandroomedewen in which there is timber.


*mine*


On the land of Dromedewyn so far as it extends over the mountain there is an iron mine of iron stone.


Memorandum: this parcel in Dromedewyn lies waste.


¶335] *Farrensesserogh*.


The vill and land of Cowlecappa in the parish of Clonehaugh and Toghe of Farrensesserogh Connello: like free land and tenure as Clenoghe and containing 2 acres.


Besides 5 quarters in said Toghe parcel of the Earl's chargeable land and charged among them there; 5 quarters in the Toghe of Tawnagh, 3 quarters 6 acres in the half Toghe of Kyllhylaghe, and 1 quarter 2 acres in the half Toghe of Killydye, [like chargeable land similarly charged[622](javascript:footNote('E580000-001/note622.html')) they amount to 15 quarters called Farren, dollo en Erle as there appears.


Memorandum: said parcel of land lies waste.


*woods*


Certain woods and underwoods there called Kyllcowlecappa in which there is timber.




---

p.138


¶336] To the said lord of Clenlesse belong divers head rents issuing from divers lands viz:—


Pobleneskaghe belonging to John mcEdmund Cullen; the vill and land of Kyllffeakin in Poblebryen belonging to Edmund mc Philip; Kylldyrrye in Poblebryen belonging to John Bradaghe Okahissy, Lyssynmoto in the Toghe of Gortculligan belonging to Richard mc Thomas Reoghe; Clonkaghe in Connelo belonging to Gerald mc William mc Thomas; Monotterye in co. Waterford belonging to Maurice mc William; and the vill of Ballyffoyle in co. Waterforde belonging to said Maurice mc William.


Sum of the lands and possessions of Thomas cam, lord of Clenles in the Great County of Lymerick: 11 ½ quarters.


¶337] *Gonoght mc Brian*.


*Land of Knonogher Ohowan mc Bryan Ogonawghte*.


The vill castle and land of Ballynity in the parish of Grean Ogonaughte in the country of Gonoght mc Brian and great County of Limerick now or late in the tenure or ccupation of Elena ne Cormocke mother of said Knoghorowhoon and containing 3 quarters.


Memorandum: said town and lands of Ballynitie are inhabited.


The vill castle and land of Cloghdalton: like situation and tenure as Ballvnity and containing 2 quarters.


Memorandum: these 2 quarters are manured.


Divers vills and lands &c: like situation as Ballynity now or late in the tenure or occupation of Tirelaghe mc Bryan of Gonoughte mc Brian, viz:— the vills and lands of Knockowleye, Ballyvylode, Aryvergy, Gortyglanny, and a parcel of the vill and lands of Bohermore, each denomination containing 1 quarter, in all 5 quarters.


Memoranda: to each denomination there is a memorandum that it lies waste.


Sum of the lands of Knogher Owhoon mcBryan Ogonoghte in Gonoght mcBrian 1 quarters.


¶338] *Connelo*


*Land of Ullige a Wale of Dunmoylyn*.


Divers vills and lands &c called ffarren Syer Ullig Wale or Ullig Wale's free land now or late in the tenure or occupation of Olliver Stephenson viz in the parish of Kyllcolman and Toghc of Dunmoylyn, Connelo, the vill and land of Kyllcollman containing ½ quarter, the vill and lahd of Corballye 2 acres, a parcel of land in Lysnegog na kera 1 acres, and a parcel of land called Glancharwell on the mountain of Slevelogher, 2 acres.


Memoranda: after each denomination except Glancharwell is a memorandum that it is inhabited; and after Glancharwell is a memorandum that it lies waste.


¶339] The vill and land of Banoge in the parish and Toghe of Dunmoylin: like free land and tenure as aforesaid and containing ½ quarter.


Memoranda: this half quarter is inhabited, and in Poblebryen is another village called Banoge land of the Earl of Desmond.


The vill castle and land of Ciarranboye in the parish of Cloneshere en temple. Connelo: like land and tenure as aforesaid and containing 1 acres.


Memorandum: this parcel is inhabited.


The vill and land of Gortnegrower in the parish of Cloneshere en temple. Connelo: like free land and tenure as aforesaid and containing 2 acres.


Memorandum: this parcel is inhabited.




---

p.139


¶340] A parcel of land called Gortevylley in the parish of Ardaghe parcel of the Toghe of Ardaghe one of hte 8 Toghes of Callowe called the Church Toghes in Connelo: like free land and tenure as aforesaid and containing 1 acres.


Memorandum: this parcel of land lies waste.


Certain woods and underwoods in which there is timber viz:— Kyllgarranboye, Kyllgortnegrower, and Kyllglansharwell.


Sum of lands and possessions of Ullig Wale in the Great County, Limerick 2 quarters 1 acres.


¶341] Besides 10 5/6 of land called ffarren dollo en Erle or the Earl's chargeable and already charged as follows viz: the vill of Dunmoylyn 1 quarter, the vill of Monemoyell 1 quarter.


Downecha west 1 quarter, Downecha east 1 quarter, Ballyntlabby 1 quarter, Rathcrogan 1 guarter, Carrenmoore 1½ quarters, Carrenbegg ½ quarter, Teermore 1 quarter, Rathfferra ½ quarter and Lysbane 27 acres, already charged in the Toghe of Dumoylyn; and a moiety of the vill of Kylltennan called Kylltennan Leigh 1½ 
quarters already charged in the Toghe of Croghe.


¶342] *Land of Pierce de Wale late of Ballyegny*.


The vill castle and land of Ballyegnymore in the parish of Clonehaghe, Connelo, now or late in the tenure or occupation of said Pierce and late in the tenure of Henry Allen: containing 12 acres.


Memoranda: said town of Ballyegnymore is inhabited.


Pierce Wale and Maurice mc Gibbon Wale were joint tenants both of their free lands and chargeable lands, two third parts belonging to Pierce and one third part to Maurice.


Sum of the lands and possessions of said Pierce in the Great County of Lymerick 12 acres.


¶343] *Lands of Redmund mc Thomas Thomas Roo Wale*.


The vill and land of Boherbradagh in the parish of Clonesheraghe en temple, in Connelo, near Kylltennan now or late in the tenure or occupation of said Redmund and containing ½ quarter.


Memorandum: this half quarter lies waste.


A parcel of land called Cloneshere in Temple: like situation tenure and extent as Boherbradagh.


These lands are called Farren Syer Redmund mc Thomas in Connelo.


Memorandum: this half quarter lies waste.


*woods*


Certain woods and underwoods called Kyllboherbradaghe in which there is timber, and Kyllclonshere in which there is no timber.


¶344] *Cosmaye*.


Two tenements within the vill of Adare in the parish of Monaster Eean alias the White abbey of Adare in Cosmaye, Great County, now or late in the tenure or occupation of said Redmund, called ffarren Syer Redmundi roe and containing 1 acres.


Memorandum: this parcel of land lies waste.


Sum of the lands and possessions of said Redmun in Cosmaye: 1 quarter 1 acres.


Besides 2½ quarters charged among the chargeable land of the Earl of Desmond viz Kylltennan 1½ quarters in the Toghe of Croghe and Ardryne 1 quarter in the half Toghe of Ogallawhoore.




---

p.140


¶345] *Cossetlereogh*.


*Lands of James Fant of Ballyany*.


The vill and land of Bally Anye in the parish of Kyllmallock, Cossetlereogh, now or late in the tenure or occupation of John Fant one of the servants of George Thorneton, marshal of Munster, and containing 1 quarter.


Memorandum: this quarter of land is inhabited.


Certain lands called ffarren in Nanta or "Fantes landes": like situation and tenure and containing ½ quarter.


Memorandum: this half quarter is inhabited.


Divers tenements and gardens in Kyllmallock now or late in the tenure or occupation of Pierce Creaghe.


Sum of the lands and possessions of said James Fant of Bally Anye 1½ quarters


¶346] *Connelo*.


*Lands of Patrick Woolffe*.


The vill and land of Inneskoysshe in the parish of Temple Treynode[623](javascript:footNote('E580000-001/note623.html')) within the town of Rathkealy, Connelo, now or late in the tenure or occupation of said Patrick and containing 6 acres.


Memorandum: this parcel of land lies waste.


Eight houses or tenements with 8 gardens in said parish and town on the east and west sides of the bridge, four gardens on one side and four on the other, like tenure as aforesaid and containing 1 acre.


*Cossetlereogh*.


Two tenements with 2 gardens on the north side of Kyllmallock, Cossetlereogh, late in the tenure or occupation of [*...*][624](javascript:footNote('E580000-001/note624.html')) Meaghe and containing 1 rood.


Sum of the lands and possessions of Patrick Woolffe in the Great County, Lymerick: 61 acres 1 rood.


¶347] *Wony O Molryan*.


*Land of Teige O Mulryan*


the vill castle and land of Beale Ruffhyn in the parish of Monasterie wony in Wony O Molrian, Great County of Lymerick now or late in the to or occupation of said Teige and containing 3 quarters.


*woods*


Certain woods and underwoods called Kyllbeal Ruffhyn in which there is timber.


Memorandum: these 3 quarters lies waste.


Sum of the lands of said Teige in the Great County of Limerick: 3 quarters.


¶348] *Poblebrien*.


*Lands of Mahownde Begg Obryan and Moryertaghe Obryan*.


Two parts of the vill of Tyrvoo in the parish of Morrynett, Poblebrien, in the Great County of Limerick now or late in the tenure or occupation of Donell Obryan of Tyrrevoo: said vill and land belonged to Teige mc Knogher Okoneg after whose death they descended to his three sons equally and as the entire contains 1½ quarters the two parts contain 1 quarter.


Memorandum: the town and land of Tyrvoo are manured and inhabited.


Sum of the lands of said Mahownde begg and Moriertaghe Obrya: 1 quarter.


¶349] *Lands of moell [625](javascript:footNote('E580000-001/note625.html')) Obryan.*


A parcel of the land of Kyllmartyn: like situation as Tyrvoo, now or late in the tenure or occupation of Brian duffe of Carrigg Ogonell and containing ½ quarter.




---

p.141


Memorandum: this half quarter is inhabited.


Sum of the lands of said Murrogho moell Obryan: ½ quarter.


¶350] *Lands of Murrogho mc Murriertogh Obryan, lord Tanyst of Poblebryen*.


The vill castle and land of Clogheakeatyn: like situation as Tyrvoo, now or late in the tenure or occupation of said Murrogho and containing 1 quarter.


Memorandum: this quarter is inhabited by Teige mc Donnogho 1 Bryan, Bryan duffe's brothel.


The vill castle and land of Ballykahel[626](javascript:footNote('E580000-001/note626.html')) in the parish of Crean Koheragh, Poblebryen, Great County of Lymerick, now or late in the tenure or occupation of said Murrogho and containing 2 quarters.


Memorandum: these 2 quarters are inhabited by Robert Bryckley, merchant of Limerick.


The vill and land of Droomeloghan: like situation and tenure as Ballykahell and containing 1 quarter.


Memorandum: this quarter is inhabited by Teige Obryan, Murrogho mc Murriertoghe's brother.


Sum of the lands of Murrogho mc Morriertagh in said Great County: 4 quarters.


¶351] *Connelo*.


*Lands of David Encorigg lord of Kyllmore otherwise called the lord of the Great Wood.*


The vill and land of Ryne in the parish of Kyllskannell one of the 8 Toghes: of Callowe or Church Toghes in Connelo now or late in the tenure or occupation of Rorye mc Shehee who had these premises in mortgage and containing ½ quarter.


*rabbit warren*


A rabbit warren belongs to the vill of Ryne called Conigery Ryne.


Memorandum: this half quarter is inhabited.


A parcel of land called Tyrewena in the parish of Ballingarry near the Toghe of Gortculligan, Connelo: like tenure and extent as Ryne.


Memorandum: this half quarter lies waste.


Certain woods and underwoods tlibre called Kylltyrewena in which there is timber.


A parcel of land called Clonenemolte: like situation and tenure as Ryne and containing 1 acres.


*rabbit warren*


A rabbit warren called Cunigre Clone Molte belongs to the vill of Clone nemolte.


Memorandum: this parcel of land lies waste.


A parcel of land called Ilan More Cloenarullta [627](javascript:footNote('E580000-001/note627.html')) in the parish of Rathkealy near the Toghe of Asketten, Connelo, now or late in the tenure or occupation of said Rorie mc Shehee and containing 1 acres.


Memorandum: this parcel of land lies waste.


Sum of the lands and possessions of said David Encorigg in the Great County, Lymerick: 1 quarter 2 acres.


¶352] *Clanwilliam*.


*Lands of Ulli Backaghe [628](javascript:footNote('E580000-001/note628.html')) mc Thomas of Clasheowny*.




---

p.142


A parcel of land called Clasheowpy in the parish of Bally Nembrare[629](javascript:footNote('E580000-001/note629.html')) in Clanwilliam Great County, now or late in the tenure or occupation of Ullig Burck and containing 12 acres.


Memorandum: this parcel is inhabited.


Sum of the lands of Ullig Backaghe in the Great County, Lymerick 12 acres.


¶353] *Lands of Geoffrey boye mc Thibauld de Bourck*.


The vill castle and land of Towaryn in the parish of Kaherkenlyshe (as is said), Clanwilliam now or late in the tenure or occupation of Owin mc Clanohy alias Clankey and containing 1 quarter.


Memorandum: this quarter of land is inhabited.


A parcel of land called Ballywalyshe alias Walshestovne in said parish of Kaherkenlishe now or late in the tenure or occupation of said Geoffrey and containing ½ quarter.


Memorandum: this half quarter of land is inhabited.


Sum of the lands of said Geoffrey boye in the Great County, Lymerick ½ quarter.


¶354] *Cosmaye*.


*Land of Edmund London of Collrushe*.


The vill and land of Kyllsyskan in the parish of Ayelackagh, Cosmaye, now or late in the tenure or occupation of said Edmund and containing 2 acres.


Memorandum: this land of Kyllsyskan lies waste.


Sum of the lands of said Edmund London in the Great County, Lymerick: 2 acres.


¶355] *Clanwilliam*.


*Lands of Walter bane flitz William otherwise called Walter bane*.


The vill castle and land of Castelano Trylan or the new castle of Trylan near Limerick city, in Clanwilliam, beside Nestermoy, now or late in the tenure or occupation of said Walter and containing 2 quarters.


*Fishing*


A certain Salmon fishing on the river Moelkarde.[630](javascript:footNote('E580000-001/note630.html'))


Memorandum: these two quarters inhabited.


Sum of the lands and possessions of said Walter in the Great County, Limerick: 2 quarters.


¶356] *Cossetlereogh*.


*Lands of William Meagh late of Kyllmallock*.


Two tenements with certain gardens in "St Jones Streete" Kyllmallock, Cossetlereo, Great County, now or late in the tenure or occupation of [*...*][631](javascript:footNote('E580000-001/note631.html')).


Sum of the lands and possessions [*...*][632](javascript:footNote('E580000-001/note632.html')) of said William in said Great County: 2 quarters.


¶357] *Connelo*.


*Lands of Gerald Balluffe [633](javascript:footNote('E580000-001/note633.html')) ffitz Phillppe mc Edmunde*.


The vill and land of Ballinfryorye in the parish of Aeylacka, Connelo, now or late in the tenure or occupation of said Gerald and containing ½ quarter.


Memorandum: this half quarter lies waste.


*fishing*


certain Salmon fishing in the river of May[634](javascript:footNote('E580000-001/note634.html'))




---

p.143


Certain woods and underwoods called KyllBallinfryorie in which there is timber.


Sum of the lands and possessions of said Gerald in the Great County of Lymerick: ½ quarter.


¶358] *Lands of William mc Shane Supple of Kyllmucko executed at Lymerick*.


The vill and land of Graogenowrane [635](javascript:footNote('E580000-001/note635.html')) in the parish of Ballingarry, 
Connelo near the Toghe of Gortcullygan: said lands called William Suppell's free land are of the gift of his mother Elianor Lacey, now or late in the tenure or occupation of [*...*][636](javascript:footNote('E580000-001/note636.html')) and contain ½ quarter.


*woods*


Certain woods and underwoods there called Kyllnegraggey in which there is timber.


Sum of the lands and possessions of said William in said County: ½ quarter.


Sum of the Lords of the Earls of Desmond and all other the said traitors attested [637](javascript:footNote('E580000-001/note637.html')) in the Great and Small Counties of Lymerick.


¶359] *Great County of Lymerick*.


*Lands belonging to divers Religious Houses.*


*Connelo*.


*Lands and possessions of the Guardian or House of Friars in Asketten called the Friars of Asketten*.


The site of the House [638](javascript:footNote('E580000-001/note638.html')) *of* Religious persons in Asketten called the Begging Friars in Asketten built on the river of Deele which flows to the Shannon with certain roofed buildings belonging thereto situate in the parish of Asketten now or late in the tenure or occupation of Captain Bartlet and containing ½ acre.


A street called Ullard begg Numrare [639](javascript:footNote('E580000-001/note639.html')) or the street or small orchard of the Friars with certain tenements and buildings thereon situate in said parish, like tenure and extent.


A parcel of land called Garran Numrare or the Friars' Garden situate in said parish: like tenure and extent.


A parcel of land called Clone[640](javascript:footNote('E580000-001/note640.html')) Numrare or the Friars' land on the north side of said Abbey or House in said parish: like tenure and containing 12 acres.


A water mill called Mollin begg belonging to said Abbey and situate in the vill and parish of Asketten on same side of the river as the Abbey; beside another water mill there belonging to the Earl of Desmond.


*Fishing*


A fishing weir commonly called Corra Numrare[641](javascript:footNote('E580000-001/note641.html')) or the Friars' weir on the river of Deele in Asketten. Tithes of fish called "tythe ffysshe" of another weir belonging to the Earl of Desmond called Corr en Erle [642](javascript:footNote('E580000-001/note642.html')) or the Earl's weir which is built near the north side of Asketten bridge viz for fish caught in the tydes during one day and two nights every week, that is between the 12th hour on Saturday and the 6th or 7th hour on the Monday next ensuing for ever.


Sum of the lands and possessions of the Abbey aforesaid in said County [*...*][643](javascript:footNote('E580000-001/note643.html'))


Memorandum: said House of Asketien called the Friary is inhabited.


*s*the Housed of Religious persons in Asketten called the Begging Friars in Askettem built on the river of Deele which flows to the Shannon with certain roofed buildings be.


¶360] *Lands and possessions of the Monastery or Priory of Rathkeale in the Great County of Lymerick*.




---

p.144


The site of said priory, divers houses totally ruined and in decay, a castle called Castellan Can ne Monastery[644](javascript:footNote('E580000-001/note644.html')) or the castle of the head of the Abbey, and divers gardens to the number of twenty and upwards (one of which is called Garren ne varr[645](javascript:footNote('E580000-001/note645.html')) or the mens' garden another Garren Pryorie or the prior's garden) and other feedings pasture and gardens containing 3 acres. Said premises lying in the parish of Temple Trenode in Rathkeale now or late in the tenure or occupation of :[*...*][646](javascript:footNote('E580000-001/note646.html')) acres.


A parcel of land called Clonerahin in said parish: tenure as aforesaid and containing 1 acres.


A parcel of land called Curraduffe: like situation tenure and extent as Clonerahin.


A parcel of land called Necowleyn: like situation tenure and extent as Clonerahin.


A parcel of land called Bancagh Spyddell: like situation tenure and extent as Clonerahin.


A parcel of land called Drumrannane Gannana in the parish and Toghe of Ardaghe one of the 8 Toghes of Callowe in Connelo: like tenure and extent as Clonerahin.


A parcel of land called ffarren ne Ganana in the parish and Toghe of Nantenan one of the Earl's 16 Toghes like tenure and extent as Clonerahin.


Memorandum: said parcels of Drum Ranna ne gannana and ffarren ne Gannana are very bad ground: they were ever more waste and the priors never reaped commodity by them.


Sum of the lands and possessions of the late Monastery of Rathkeale[647](javascript:footNote('E580000-001/note647.html')) 63 acres.


¶361] *Limerick City*


*Lands and possessions of the late Monastery of Donnoho Carbry*.


The site of the last Monastery of Donnoho Carbry, otherwise called Monaster woghtro [648](javascript:footNote('E580000-001/note648.html')) with certain yards, orchards and gardens in Limerick city which contain by estimation 30 or 40 small gardens some of which lie near Ilan Ree of the King's Island[649](javascript:footNote('E580000-001/note649.html')) with certain ruinous tenements and waste places to said gardens formerly belonging: said premises now or late in the tenure or occupation of John Commin of Limerick merchant are of the yearly value of 20*s.*


Memorandum. there is a parcel of land called Courtebrack [650](javascript:footNote('E580000-001/note650.html'))
which was given to this monastery by the Earl of Desmond: said parcel is charged among the Earl's lands but it was always in possession of those of the monastery and never severed from them.


Sum of the lands and possessions of the Monastery of Donnoho Carbry alias Monaster Woghtro [*...*][651](javascript:footNote('E580000-001/note651.html'))


¶362] *Lands and possessions of the late House of Friars of Ballyn Brahur[652](javascript:footNote('E580000-001/note652.html')) alias Bally Numrare in Clanwilliam*.


The site and house of the late friars of Ballinbraher or Bally Numrare in the parish of Bally Numrare, Clanwilliam with divers buildings and gardens now or late in the tenure or occupation of [*...*][653](javascript:footNote('E580000-001/note653.html')) and containing ½ acre.


Divers tenements and gardens within the vill of Bally Numraher, Clanwilliam, now or late in the tenure or occupation of Richard Wingfield, gent and containing 1½ acres.


Certain lands in the vill and fields of Ballynumrare aforesaid: like tenure and containing ½ quarter.


The vill and land of Towryn alias Towrane situate in said parish in Clanwilliam: like tenure and containing ½ quarter.


A water mill called Mollin Numrare or the friars "Mylne" with a tenement and two gardens in the vill and parish of Bally Numrare in Connelo[654](javascript:footNote('E580000-001/note654.html')) now or late in the tenure or occupation of James Golde and containing [*...*][655](javascript:footNote('E580000-001/note655.html')).


*Fishing*


A fishing for Salmon and eels on the river Canmuck[656](javascript:footNote('E580000-001/note656.html')) said mill and friars belonging.




---

p.145


*Tithes in Ballyrowan*


Tithes of grain hay wool milk and honey from the two vills or villates called the two Ballyrowans in the parish of Bally Numrare, Clanwilliam now or late in the tenure or occupation of said Richard Wingfield, gent and containing 2 quarters.


Memorandum: said religious house and land in Bally Numrare with the mill are manured and inhabited. They are 6 miles distant both from Kyllmallock and Lymerick.


Sum of the lands of the late house of Friars of Bally Numrare in Clanwilliam 1 quarter 2 acres.


¶363] *Cossetlereo*.


*Lands and possessions, of the late House of Friars called Braher duffe alias the Black Friars in Ballynegall.*


The site and late House of said Friars situate in Ballynegall in the parish of Ballynegall, Cossetlereo, in the Great County of Lymerick with divers buildings totally ruined and certain yards or gardens now or late in the tenure or occupation of [*...*][657](javascript:footNote('E580000-001/note657.html')) and containing ½ acre.


Certain land called Farren ne Monaster in the fields of Ballynegall aforesaid: like tenure and containing ½ quarter.


Certain tenements and gardens comprising the residue of the vill of Ballynegall: like tenure and containing 1½ acres.


Memorandum: the town and lands of Ballynegall and said religious House all lie waste.


Sum of the lands of the late House of Friars of Ballynegall[658](javascript:footNote('E580000-001/note658.html'))½ quarter 2 acres.


¶364] *Limerick*.


*Lands and ossessions of the late Relieious House called Monaster ne Callowe duffe or the Black Abbey in Lymerick*.


The site and late Religious House of said Abbey, situate in the parish of Temple Moyrry[659](javascript:footNote('E580000-001/note659.html')) or Our "Ladies" parish,[660](javascript:footNote('E580000-001/note660.html')) within the walls of Limerick, with divers buildings, yards orchards and gardens now or late in the tenure or occupation of Murrugho mc Dermodo I Bryan, baron of Inchequoyne in Thoomond and containing ½ acre.


Tithes of grain hay wool milk and honey from divers vills lying dispersed in the country of Thoomonde in the province of Connaughte with certain vills and lands belonging thereto hitherto unknown now or late in the tenure or occupation of said Murrogho, Baron of Inchequoyne.


Memorandum: said site of the said Religious House with the tithes, towns and lands in Thoomonde are inhabited and manured.


Sum of the lands and possessions of [*...*][661](javascript:footNote('E580000-001/note661.html')) the late Monaster ne Callow duffe, Lymerick.


Sum of the lands and possessions of the said Religious Houses: 2½ quarters 2 roods.


Sum total of said lands 592 ½ quarters, 15 acres, 3 roods.


¶365] *The Plot from England for inhabiting and peopling of Mounster*.


Copy of grant under the Great Seal of England by Queen Elizabeth dated 27 June a.r. xxviij Eliz.


Her Majesty reciting that a great part of Mounster had been wasted and depopulated by the rebellion of the Earl of Desmond and his confederates; that she is anxious to have said province repeopled with civil loyal and dutiful subjects who shall live according to the true and sincere religion of God, and to encourage her subjects of England who have proffered their service at their own adventures and charges to accomplish this purpose; and that she has agreed to grant to such of her subjects as 



---

p.146




shall so adventure and 
be charged with the repeopling of Mounster or any part thereof all the honors castles and lands which through said rebellion, escheat, &c have come to her hands, or have been concealed or unjustly detained from her, according to the following articles:


¶366] Asserts first that the premises be divided into manors or seignories containing 12,000, 8,000, 6,000, and 4,000 acres according to the annexed plot, and, that same be fully peopled by the undertakers before Michaelmas 1593; and grants them an estate of fee farm to them and their heirs for ever to be held by fealty only in free socage and not in chief nor by knight service viz the lands in Cork and Waterford of her manor or castle of Carrigh Grogane co. Cork, and the lands in Limerick Kerry and Tipperary of her 
manor of Limerick, yielding for three years next ensuing Michaelmas 1590 for every entire seignory of 12,000 acres the following yearly rents viz, in Cork, Tipperary and Waterford 33*l.* 6*s.* 8*d.* in Limerick excepting Conologh 62*l.* 10*s.* in Conolough 75*l.* in Kerry and Desmond 100*l.* and rateably for the inferior seignories in the 
respective districts, said rents to be current English money; and from Michaelmas 1593 yielding double the rents reserved in every case and also, on the death or alienation of every head undertaker his best living beast as a heriot, and on the death of every head undertaker relief according to the Common law of England between common persons usual:


¶367] that the premises be discharged of all charges leases and custodiams hitherto granted by the Queen and that they and the inhabitants thereof be discharged and disburthened hereafter of all manner of ceases, exactions, cuttings, reliefs refections coyn, Lyvery, Kerne, Kerntie, Coshery, cuddie, Gyllity gyllycon and other impositions, to be imposed by the Deputy or other her minister other than subsidies granted in parliament after Michealmas 1593; but if it appear on proper evidence that rents greater 
than the rents aforesaid were formerly payable out of any lands concealed or unjustly detained in such cases the rents and services aforesaid shall be increased accordingly:


that bogs barren heaths and waster moutains not belonging to any ploughland shall pass without rent to the undertakers as wastes to be used with the rented ground within the signory but when same have been improved to feeding or tillage they shall be liable to a yearly rent of ½ d English money for every English acre so improved:


that rents and services payable to her by persons of Irish birth in respect of lands and tenements situate within the precinct of any seignory shall be granted in fee farm to the undertaker of such seignory who shall yield for said seignory the rents and services so payable by persons of Irish brith as well as the rents and services reserved according to the rate aforesaid:


¶368] that for five years from Michaelmas 1590 undertakes may export to any country in amity with the Crown of England all commodities growing on these lands without paying custom subidy tonnage or poundage and corn or victuals, similarly growing, to England or Wales without paying custom except in case of prohibition through dearth:


that nobody shall be permitted to be an undertaker for himself for more than 12,000 acres:


that the English planted in Mounster shall not make any estate of any of the premises to meer Irish not descended of English ancestor and name or permit them to have the use or occupation of any part thereof; nor shall theyh impair the principal demesnes may be divided into parts for the several habitations of the undertaker but according to the plot, a seignory of 12,000 acres may be divided inot 2 or 3 seignories, a seignory of 8,000 acres into 2 seignories, 2 seignories of 6,000 acres each may be united and then divided into 3 seignories a seignory in no case to be less than 4,000 acres and to be arranged according to the plot, that such as shall have an entire seignory of 12,000 acres shall have liberty to empark 600 acres thereof to be employed for deer and the breeding of horses and the other seignories rateably in that proportion and that same 
shall be ground of free warren:


that those in any society undertaking as aforesaid shall be planted together without interruption or intermixture of others, and lands left unpeopled shall lie together and not dispersed;




---

p.147


¶369] that the chief persons and heads of every family first planted within said seignories or colonies shall be of English parents, and that heirs female inheritable to any of the premises shall only marry persons of English parents or descendents of the patentees or English now to be planted there; and that no mere Irish be maintained 
or permitted in any family there:


that after Michaelmas 1590 every farmer and freeholder ordained according to the plot shall have ready one gelding or horse for a light horseman and a man meetly furnished to serve as a horseman, a principal undertaker of a seignory of 12000 acres three horsemen with geldings fit and furnished for service and six footmen with furniture of armour and weapon and so rateably for the other seignories; every copyholder having 100 acres shall similarly have furniture for one footman:


that for 7 years next ensuing none of the inhabitants of such seignories or colonies be forced to travel out of Munster for any service, and after that time not abovev l0 horsemen and 20 footmen from a seignory of 12000 acres and so rateably for other seignories and these not to travel more than 30 miles out of Munster unless in case of foreign invasion, and in case of such invasion not above 10 horsemen and 20 footmen from a seignory of 12000 acres and so rateably for other seignories and then to be on the Queen's pay; and that none be required to serve in or near Munster but when need shall require and then not to serve at their own charge not more than 28 days in one year:


¶370] that colonists or parents who shall establish their children as colonists for 7 years next ensuing shall be freed from undertakings to serve in England with horse and armor except in case of foreign invasion or rebellion and except such as they are legally bound to maintain over and above what they must maintain in Munster:


that for 7 years next ensuing they shall be defended by garrisons at the Queen's charge unless in the meantime it be thought fit by thie Queen or desired by the colonists to have them removed, and that their captains shall be sympathetic with this plantation that said gentlemen and their families may for their own use import from England into Munster such commodities as they shall require whether prohibited or not without paying custom, subsidy, tonnage; poundage or any other duty, and that commissioners be appointed to see this properly executed.


¶371] that Commissioners shall be appointed to decide any controversies concerning these lands that may arise between the colonists or be pretended by the Irish or others; and for default thereof such controversies shall be decided by the English Council.


that some of the principal undertakers be joined in Commission with the President of Munster by direction of the Lords of the Council in England or the Governor and Council in Ireland.


that no patentee have entertainment or wages as a soldier, to continue and reside there, without licence:


¶372] that Sr. Christofer Hatton [662](javascript:footNote('E580000-001/note662.html')) Edward Fytton [663](javascript:footNote('E580000-001/note663.html')) and Sr. Rowland Stanley Knights and the gentlemen undertakers of Cheshere and Lancaster their associates shall have assigned to them lands in the Great and Small County of Limerick (except Conyloghe) and in Tipperary and Waterford except so much in Waterford as is hereafter assigned to the undertakers for Cork:


that Sr. Walter Ralegh, [664](javascript:footNote('E580000-001/note664.html')) Sr. John Stowell and Sr. John Clifton, Knights and the gentlemen undertakers of Devon Somerset and Dorset and their associates shall have assigned to them lands in Cork, and so much land in Lysfyny and near adjoining thereto in Waterford as shall not exceed two seignories of 12000 acres each:


¶373] that Sr. Valentine Browne [665](javascript:footNote('E580000-001/note665.html')) [*...*][666](javascript:footNote('E580000-001/note666.html')) and the gentlemen undertakers associated with them shall have assigned to them lands in Kerry and Desmond and the adjoining territories.


that Sr. William Courtney Knight[667](javascript:footNote('E580000-001/note667.html')) Edwarde Ounton and Henry Owghtred [668](javascript:footNote('E580000-001/note668.html')) esquires and their associates shall have lands assigned to them in Conologh parcel of the Great County of Limerick:


that if any of the lands be evicted from the undertakers by reason of any grants or estates made by former owners the rent shall be abated rateably during such eviction:




---

p.148


that commissions shall be awarded to suitable persons to apportion the seignories having due regard to said plot; and to rate and apportion the rent according to the goodness of the soil; provided always so much rent be reserved on the whole in each case as hereinbefore set down:


that the acres herein mentioned shall beat the rate of 16½ feet to the pearch or pole or lugge after the measure of England:


that the undertakers may grant estates of such lands as are limited for freeholders in fee-simple or fee-tail to be hel of themselves of same seignory by such rents as the undertakers shall reserve:


And that the undertakers may keep courts baron within the seignories as the lords of manors in England may do.


Dated at Westminster 27 June a.r. xxviij. Eliz.


¶374] *The plot for peopling Munster in Ireland referred to in above grant and attached thereto*.


The gentleman undertaking to have a seignory must people the same in seven years with families as follows viz:—
  


A seignory of 12000 acres to have in demesne 2,100 acres, 6 farmers with 400 acres each, 6 freeholders with 300 acres each, 42 copyholders with 100 acres each, and the residue, 1500 acres, apportioned for inferior tenures in smaller lots on which at least 36 families must be settled:


A seignory of 8000 acres to have in demesne 1,400 acres, 4 farmers, 4 freeholders, and 28 copyholders with acres as aforesaid, and the residue 1000 acres apportioned as before with at least 24 families settled thereon:


A seignory of 6000 acres to have in demesne 1,050 acres, 3 farmers 3 freeholders, 21 copyholders a residue of 750 acres apportioned, with at least 18 families settled thereon, as before:


A seignory of 4000 acres to have in demesne 700 acres, 2 farmers, 2 freeholders, 14 copyholders, a residue of 500 acres apportioned with at least 12 families settled thereon as before:


When said numbers have been supplied as aforesaid any surplus may be disposed of among the different classes or otherwise at the pleasure of each undertaker.


### Desmond Survey


P.R.O.I. M. 5038


¶375] {MS folio 1}Honors lordships Manors castles lands &c coming to Queen Elizabeth as well through escheat by reason of the rebellion of Gerald late Earl of Desmond and other traitors congregated with him, in the province of Munster, as by forfeiture, conviction surrender of estates or otherwise belonging to the Queen, found by divers inquisitions taken by virtue of the Commission of Sir John Perrott, Knight, Lord Deputy dated 22 Aug. a.r. xxvj Eliz. as follows.


Queen Elizabeth appoints cholas Walshe, chief justice of Munster, John Meagh Second justice of Munster, Thomas Wyseman, James Gowle, Robert Rosier and Arthur Robins esquires, and any three of them who shall be named by Henry Walloppe and Valentine Browne, to enquire by the oaths of good and lawful men and other ways in the counties of Waterford Limerick, Cork Kerrie and the Cross of Tipperary or elsewhere concerning all and singular honors castles lordships manors lands and tenements belonging to the Queen by reason of attainders escheats forfeitures &c Acts of parliament &c and lands concealed or unjustly detained from the Queen, and to return an Inquisition thereof under seals by them or any three of them to the Deputy or Governor and Council of Ireland or the Barons of the Exchequer, with this Commission. Witness Sir John Perrott, Knight, deputy general at Dublin 22 Aug. a.r. xxvj. ( [*...*][669](javascript:footNote('E580000-001/note669.html'))).




---

p.149


¶376] Values and extents of all and singular the honors lordships manors castles lands &c in Ireland coming to Queen Elizabeth as well through escheat by reason of the rebellion of Gerald Garret late Earl of Desmond, James Eustace late Viscount of Ballenglasse, John of Desmond and James of Desmond brother of said Earl or others who congregated with them, as by forfeitures convictions surrenders of Estates, Acts of parliament &c or otherwise belonging to the Queen viewed and surveyed by virtue of a Commission under the Great Seal of England of 19 June a.r. xxvi Eliz as follows:


¶377] {MS folio 1d}Queen Elizabeth appoints Sir Henry Wallopp, Knight, Sir Valentine Browne, Knight, Thomas Geneson, Launcelot 
Allforde and Christopher Payton, five four or three of them, of whom any of them except Payton was to be one to inquire by the oaths of good and lawful men and other ways what honors castles, lordships, manors lands &c in Ireland have come to the Queen by reason of the rebellion of Gerald Garrett late Earl of Desmond, James Eustace, late Viscount of Baltinglasse, John of Desmonde and James of Desmonde, brothers of said Earl, or others congregated with them, or by reason of attainders escheats, forfeitures,
convictions surrenders of Estates Acts of parliament or otherwise, or which have been concealed taken away or unjustly detained; the clear yearly value of the premises and who receives the issues and profits: She similarly appoints them to survey all ancient possessions and revenues in Ireland to her or her progenitors or predecessors in right of her Crown of Ireland from ancient times belonging as well as the said honors, castles manors &c; and in order that her revenue in Ireland from henceforth may be more carefully managed governed she similarly appoints and authorises them to execute all things concerning her possession and revenues in Ireland which shall be notified to them by any six of the Privy Council of England in writing and signed with their names: provided that if the commissioners or any of them shall not be able to perform said service, or if their number be insufficient for the purpose, then the Deputy or Governor-General of Ireland with the advice of said Henry Walloppe and Valentine Browne or either of them shall nominate others to supply such defect, and by letters patent under the Great Seal of Ireland shall empower them to act with the said Commissioners in the same capacity; sheriffs and other officers are to be assisting in all things by executing {MS folio 2} venire facias &c so that the requisition certificate and survey taken and made may be had before the Deputy Governor of Ireland and the Barons of the Exchequer under their seals and this commission shall be then remitted there.


Witness the Queen at Westminster on 19 June a.r. xxvj Eliz ( [*...*][670](javascript:footNote('E580000-001/note670.html'))).


¶378] By authority of said Commission and as directed therein. by letters patent under the Great Seal of Ireland under 24 Aug. a.r. xxvj Eliz. Thomas Wyseman and Arthur Robins gents. were apppointed commisioners in addition to said five commissioners, said letters patent being as follows.


Queen Elizabeth recites the letters patent of the {MS folio 2d} 19 June a.r. xxvj, with its clause for appointment of new or additional Commissioners; and since Thomas Ienizon thereby appointed Commissioner; is afflicted with disease so that he is unable to act in execution of said Commission, Thomas Wyseman and Arthur Robins, gents are now appointed Commissioners to act with the remaining Commissioners appointed by the letters patent of 19 June aforesaid.


Witness the Deputy-General at Dublin on 24 Aug. a.r. xxvj Eliz ([*...*][671](javascript:footNote('E580000-001/note671.html'))).


¶379] {MS folio 3}By authority of said Commissioners the said Sir Henry Wallopp and Sr. Valentine Browne knights, Launcelot, Allforde and Christopher Payton esquires, and Thomas Wyseman and Arthur Robins, gents have viewed surveyed and extended[672](javascript:footNote('E580000-001/note672.html')) all and singular the lands, lordships, manors, castles, tenements lands possessions and hereditaments hereafter in his "book" mentioned which have come to Queen Elizabeth, in the province of Munster and elsewhere in Ireland as well by escheat through the rebellion of Gerald Garrett late Earl of Desmond, James Eustace late Viscount of Balltinglas John of Desmonde and James of Desmonde brothers of said Earl, or any persons who assembled with them as through forfeitures convictions surrenders of estates, Acts of parliament or belonging to the Queen in any other way viz:—




---

p.150


¶380] *County of Limerick*.


*Manor of Awny alias Avnye with the borough (burg.)ur, there in the Small (minor) County of Limerick*.


Rents of divers free tenants yearly payable to said late Earl beyond the services and other charges similarly due to him as declared below, viz:— for the land and Burgages of the late burgesses of the late borough of Any containing 3 carucates at 2*l.* per carucate, beyond the value of a burgage there with certain lands to the quantity of a carucate containing 60 acres called Cleistaines parcel of said 3 carucates, lately the possession of John and Thomas Browne attainted of high treason by which attainder the rent of said burgage and 60 acres is extinguished because the premises have come to the hand of the Queen and are charged herein among 
the possessions of said John and Thomas; lawful money of England payable by equal portions at the feasts of Easter and Michaelmas by equal portions [*...*] 5*l.*


¶381] Like free rents viz. for the lands of Fox called "Foxes Landes" 6*l.*; Baggot [673](javascript:footNote('E580000-001/note673.html')) towne alias Ballingewood 4*l.* 8*s.*;; Ballincowly Rwo alias Ballincollen 1*l.*; Dondons' lands 4*l.*; Rowlestowne 4*l.* 12*s.*; the vill called Ballymonemore 3*l.* 6*s.*; Ballyhibberd 1*l.* 4*s.*; Ballyhewarde 4*l.*; and Ballinsconley 1*l.* 4*s.*: in all {MS folio 3d} (beyond rents for lands called Killan alias Kylkellane Cames and Ballymoneybeg possession of John and Thomas Browne as aforesaid, and similarly charge herein lawful money of England payable as aforesaid [*...*] 29*l.* 14*s.*


¶382] Divers other rents of tenants in co. Limerick who owed to the said late Earl suit of said court at his Manor of Awny and the several rents following viz:—the vill of Kilphrus 1*l.* Balliemonieny Ballinnagh alias Ballynearownagh 16*s.* 8*d.*; Cloughviller alias Cloughbuddinviller l0*s.*; Ballinrosey alias Ballinroche 6*s.* 8*d.*; the two Sculles in the parish of Hospital 1*l.* 3*s.* 4*d.*; Ballenmollen alias the Mullen 1*l.*; Killderry in Populbryan (this is cancelled as John O Kahisshie possessor thereof was attainted whereby said parcel of the land of Kylderry came to the Queen's hand and is 
charged hereafter as aforesaid; Ballinvolinbegg l0*s.*; Ballynearwny alias Ballincarrowne 16*s.* 8*d.*; Carrion otherwise Carnon oge 3*s.* 11*d.*; total 6*l.* 7*s.* 3*d.*


¶383] And further all the tenants as well within the manor of Awny as elsewhere within the Small County of Limerick who were accustomed to pay any rent to the late Earl there were obliged by their tenure to supply said Earl in his kitchen with fat cows at the rate of 6*s.* 8*d.* per cow; and with carriage of baggage, wood and other necessaries for his lodging as long as he remained in the Small County: for which customs and services and all other charges (except suit of court and like services) the commissioners assess the lands as follows viz. the land of James Foxe called Castelly [*...*][674](javascript:footNote('E580000-001/note674.html')) and the vills of Ballygowrman Sallygedden Foxe[675](javascript:footNote('E580000-001/note675.html')) half a ploughland, Buskagh, and the castle and town of Ballygrynan 1*l.* in money, and 3 fat cows to be delivered yearly on 1st May; Baggostowne similarly 10*s.* and 2 cows; Ballyngowly Rwo similarly 2*s.* 6*d.* and 1 cow; Dondons land similarly 12*s.* and 2 cows; Rowleistowne similarly 10*s.* and 2 cows; Ballemonemore 8*s.* and 1 cow; Ballyhuberd 2*s.* 6d. and 1 cow; Ballyheward 10 s and 2 cows; the land of said borough 10*s.* and 2 cows; Ballinscownelie 2*s.* 6*d.* and 1 cow; Kilphrus 1 cow; the vills of Ballenemony, Ballynagh alias Ballyncarrownagh 1 cow; Cloughviller alias Cloughbuddynviller 3*s.* 4*d.*; Ballinrosie alias Ballynroch 1*s.* 4*d.*; two vills called the "Twoo Skulles[676](javascript:footNote('E580000-001/note676.html')) the parish of the Hospital of Awny aforesaid 5*s.* and 1 cow;


¶384] {MS folio 4}Ballyncullen alias the Mullens 5*s.* and 1 cowes; Kilderrie in Populbrian cancelled here because John O Kashie, possessor thereof was attainted whereby said parcel came to the Queen's hand and is charged elsewhere herein; Ballynvolnybegg 1 cow; Ballyncarwny alias Ballyncarrowne 3*s.* 4*d.* and 1 cow; Carnon alias Carnon oge 1*s.* 1*d.*; 3 carucates of land lately belonging to the burgesses of Awny aforesaid, beyond 60 acres there called Cleistaines hereafter charged among the lands of attainted persons, 8 cows; the premises are worth in toto, in English money payable yearly by equal portions at Easter and Michaelmas yearly 5*l.* 4*s.* 7*d.*, and in cows called "ffat marts" (to be delivered yearly on 1 st May within 8 miles of the[677](javascript:footNote('E580000-001/note677.html')) from where the lands 



---

p.151




charged with same are situate) 31 cows or their value at the rate of 13*s.* 4*d.* English money for every cow or mart at the election of the Queen by lord deputy or other governor. And so the premises are worth in toto yearly 11*l.* 11*s.* 10*d.* and 31 cows.


¶385] A castle[678](javascript:footNote('E580000-001/note678.html')) there ruinous within except its stone walls with a large area or inclosure called in English "a Balne" surrounded with a stony wall a dovecote within the precincts of the bawn (the wall and dovecote being in great decay): and there is situate near the foot of Knockawne mountain a parcel of the demesne lands of this manor, on the eastern side of the mountain and near the Comock river which runs between said demesne lands towards the north, worth yearly in English money 13*s.* 4*d.*


¶386] Demesne lands belonging to same manor for the most part very fertile for arable lands, meadow, feeding and pasture contain 4 carucates and 3 acres of land whereof 3 carucates and 3 acres lie together around said castle, and the other carucate called Gorthin Clone alias Gorthneclonogh lies in the parish of Awny whose rectory is impropriate and belongs to the preceptory or Hospital of Awny parcel of the possessions of said Queen in co. Limerick. The[679](javascript:footNote('E580000-001/note679.html')) are valued and extended by said commissioners in English money payable yearly at the feasts of Easter and Michaelmas by equal portions to 6*l.* 16*s.* 4*d.* further in victuals and provisions 12 fat cows yearly between fits of Michaelmas, and All Saints, valued at 8*l.* at 13*s.* 4*d.* per cow; 24 pecks of wheat at 16 gallons per peck valued at 4*l.* at 3*s.* 4*d.* per peck; 24 pecks of barley malt at {MS folio 4d} 20 gallons the peck valued at 4*l.* sterling at 3*s.* 4*d.* the peck; 48 pecks of "Otenmalt", like measure valued at 4*l.* at 1*s.* 8*d.* per peck, the corn is to be delivered yearly between 15 Nov. and 25 Mar. following, and cows and corn are to be delivered within 8 miles of said demesne lands: if said victuals and provisions are not delivered in their several species in form aforesaid (the election of which will be in the power of the Queen by her Deputy Governor, or Officers of Ireland for the time being) then they shall be valued in lawful English money and paid as aforesaid and so the premises are worth yearly in toto 6*l.* 16*s.* 4*d.* 12 cows, 24 pecks of wheat, 24 pecks of barley malt 48 pecks of Otenmalt.


¶387] A water mill on the river Comocke near said castle on the east side thereof now in the tenure or occupation of [*...*][680](javascript:footNote('E580000-001/note680.html'))
worth yearly in lawful English money 1*l.* 13*s.* 4*d.*


A fair held there yearly on 1st and 2nd August with amercements for bloodsheds and affrays valued yearly in like money at 13*s.* 4*d.*


Yearly value of said manor reserved as well in English sterling money as in victuals and provisions


56*l.* 2*s.* 2*d.*


43 cows.
  

24 pecks of wheat,
  
 
24 pecks of barley malt,
  

48 pecks of oaten malt


Memorandum.— near said castle is a place where the Burg alias a burrough towne was lately situate: it was waste long before the rebellion of the late earl except one house or peel in which Maughan mc Teig one of the burgesses lives. There were 12 burgesses in said borough to whom belong the 3 carucates of land mentioned at the beginning of the manor.


Note. [*...*][681](javascript:footNote('E580000-001/note681.html')) is patron of the vicarage of the parish of Awny.


There are no woods or underwoods growing on said lands.


¶388] *Loghgur with Ballencullen and other their appurtenances in Small county (minor comitatus) co. Lim*.


{MS folio 5}[682](javascript:footNote('E580000-001/note682.html')) A large and very fine castle in good condition and repair which was a chief house of the late Earl with an iron door at the entrance and very strongly situated at the foot of a round 



---

p.152




mountain (one part of which is stony) towards the east: the castle and mountain shut in a fishery otherwise called a lough, full of river fish: the castle contains 9 sleeping rooms (cubicul') and 2 reception rooms (loci easeament'): a barbican of stone surrounds it having a small round tower built at every corner for defense. There are 2 entrances to the castle one on the east side by a narrow causeway and 2 gates, the other on the south-west of the castle where there is another small castle or peel with a draw bridge (pons abstrahend') and there within the said island as parcel thereof and near the castle on the north side are an orchard and garden. To the same castle belong divers other buildings or cottages with gardens adjacent and belonging to them built near said castle where dwell divers tenants who [*...*][683](javascript:footNote('E580000-001/note683.html')) the lands following. The castle with the site thereof, the fishery or Lough and the Grange of Loghie which lies on the east side of the castle and was wont to render yearly to the late Monastery of Nenowgh 13*s.* 4*d.* Ballecullen on the eastern side of said castle and Killogh on the south contain 4 carucates of land 
situate in three several parishes viz:— one part in the parish of Awny the tithes of which belong to the precieptory or hospital of Awny, a second part in the parish of Nenowghe which abbey and preceptory are parcel of the possessions of the Queen, the third part is situate in the parish of Tollowebrackett and the tithes thereof belong to the rectory there of which the Bishop of Limerick is patron; and so the premises are valued by the said Commissioners in lawful English money, and provisions to be rendered yearly on the days manner and form specified for the demesne lands of Awny viz:—


6*l.* 13*s.* 4*d.* money,
  
 
12 cows, 
  

24 pecks of wheat, 
  

24 pecks of barley malt,
  
 
48 pecks of oaten malt
  
.


¶389] *Glenogre with Creans and other their appurtenances in Small County co. Lim*.


A castle very ruinous there without room or roof, and an enclosure or balne whose walls are in great decay so that the castle is not defensible. There is near the castle an empty house having only one solar' or story habitable. It is situate on exceedingly fertile level land. Adjacent and belonging to said castle are divers demesne lands of divers kinds the best and most fertile of their kind containing 4 carucates of land which are valued in lawful-money and provisions to be delivered as aforesaid viz:— 6*l.* 13*s.* 4*d.* money, 12 cows, 20 pecks of wheat, 20 pecks of barley malt and 40 pecks of oaten malt. {MS folio 5d}A water mill now in very great decay and therefore valued by said commissioners in lawful English money payable yearly at said feasts only at 10*s.* sterling.


The vill or villate called Creans which before the rebellion had buildings now altogether devastated (the walls of an old chapel only being left.[684](javascript:footNote('E580000-001/note684.html')) This vill with its lands which ire very fertile adjoins the demesne lands of Glanogre castle and was member thereof: it contains with 200 acres by estimation of underwood (subboscus) about 12 years old 2 carucates of land valued yearly as aforesaid by the commissioners and to be rendered on the days. and in form aforesaid, viz:— 3*l.* 6*s.* 8*d.* money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; 24 pecks of oaten malt.


Yearly value of Glanogre and Creans reserved in sterling English money victuals and provisions viz


10*l.* 10*s.* 4*d.* money
  
 
18 cows; 
  

32 pecks of wheat;
  
 
32 pecks of barley malt;
  
 
64 pecks of oaten malt.
  



¶390] *Fedamore barony situate in Small County, co. Limerick*.


The castle and vill of Ballica containing 1 carucate; an old castle in Feadamore with lands belonging thereto containing half a carucate late in the tenure of John mc Daviegelogh, and there is 



---

p.153




another half carucate there in the tenure of John y Gradye; the castle villate and land of C[685](javascript:footNote('E580000-001/note685.html'))oalick containing 1 carucate; the castle villate and land of Fanyngstowne alias Ballynanying containing 2 carucates. The premises amount in toto to 5 quarters and are valued and extended by said Commissioners in Sterling English money payable yearly at the feasts of Easter and Michaelmas by equal portions and in provisions to be delivered yearly as in case of the manor of Awny viz:


13*l.* 6*s.* 8*d.* money;
  

15 cows;
  

20 pecks of wheat;
  

20 pecks of barley malt;
  

40 pecks of oaten malt
  
.


¶391] *Rathmore with its appurtenances in the parish of Nenogh, Small County, Co. Limerick*.


{MS folio 6}A large castle there ruinous in some parts with a barbican round the north side, and with an inclosure shut in by a stone wall in great decay. There are in the castle divers other necessary places or rooms (cubicul'.) strongly built for defence, and at the entrance of the castle is an iron door. Two carucates of land in the parish of Nenogh belong to said castle, and their tithes belong to the late monastery of Nenowgh parcel of the Queen's possessions in Small County. All which premises were granted by the late Earl of Desmond and the Countess Elinor his wife by indenture of 25 Jan. 1571 to Maurice Sheighan for a term of 99 years rendering yearly therefor 
to the Earl and his heirs one grain of pepper.


¶392] *Knockgromell and Karrigkettell in the Small County, Co. Limerick*.


A small low (humilis) castle or peel called Knockgromell to which adjoins and belongs a carucate of land containing by estimation 640 acres of very fertile land late in the tenure of John mc Shane mc Ynerle lying in Ballilogh parish the tithes of which Thomas Earl of Ormonde receives in right of the hereditaments of his abbey of Atthassell.


Another small castle or peel called KarrigKettell on the top of a mountain to which adjoins and belongs half a carucate containing 200 acres of the very best land situate in Kiltyly parish, Small County, the tithes of which belong to the preceptory or Hospital of Awny aforesaid.


There are no woods on these lands which are valued by said commissioners by the year in lawful money of England and provisions to be paid and delivered yearly on the days and in the form specified for the demesne lands of Awny aforesaid viz:


4*l.* money;
  
 
5 cows; 
  

12 pecks of wheat;
  

12 pecks of barley malt;
  

24 pecks of oaten malt
  
.


¶393] *Divers other castles lands and possessions of said late Earl within the great as well as the Small County of Limerick*.


The villate of Ballintravesie near Faningstowne late in the tenure Donogho Bane, containing with underwoods pasture and bogg half a carucate which is valued and extended by said Commissioners yearly in money and provisions as aforesaid to be delivered as aforesaid at, 1*l.* money; 2 cows; 2 pecks of wheat; 2 pecks of barley malt; 4 pecks of oaten malt.


¶394] {MS folio 6d}The villate of Ballyhouctie within two miles of Killmallocke, called the Countess Landes containing 2 carucates where there are no woods underwoods nor castles therefore they are valued .by the Commissioners yearly in money and provisions as aforesaid to be delivered as aforesaid at 3*l.* 6*s.* 8*d.* money; 4 cows; 8 pecks of wheat; 8 pecks of barley malt; and 16 pecks of oaten malt.




---

p.154


¶395] The vill of Ballymahur alias Ballynnahin containing 1 carucate valued by the Commissioners yearly in money and provisions as aforesaid to be delivered as specified for manor of Awny, at 1*l.* 13*s.* 4*d.* money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of oaten malt.


¶396] The Castle and vill of Cahir a Gillimo containing half a carucate valued yearly as aforesaid in money and provisions to be delivered as aforesaid at 1 l, money; 2 cows; 2 pecks of wheat; 2 pecks of barley malt and 4 pecks of oaten malt.


¶397] A tenement in the centre (medium) o Kilmallock near and on the east side of the castle called Lavery[686](javascript:footNote('E580000-001/note686.html')) in the occupation of John Wale who paid no rent therefor but was accustomed to bring and supply the late Earl of Desmond with wood and fuel from the Earl's woods and underwoods near Kilmallock as long as the Earl was remaining in said town: it is valued by the Commissioners yearly in lawful English money payable at Easter and Michaelmas by equal portions at 10*s.*


¶398] {MS folio 7}A chief house lately the abbey or priory commonly called the Blacke Abby of ffryers within the walls, Limerick: this with certain tenements, gardens, orchards yards and lands adjacent and belonging thereto was valued at 5*l.* English yearly.


¶399] An old castle without the wall but within the franchise of Limerick city called Courtebracke and the villate of Courtebracke containing 100 acres of arable land meadow underwoods bogs &c belonging to said Abbey and valued by the year at 1*s.* 4*d.* by the acre at 6*l.* 13*s.* 4*d.* payable as aforesaid and so in toto the premises are valued at 11*l.* 13*s.* 4*d.* sterling.


¶400] Another castle called Corbally near the wall and within the franchise of Limerick city: it is ruinous and badly situated in the lowest portion of a bog parcel of the lands adjacent to and belonging to said castle within half a stadium of Limerick on the north east and half a furlong of the great river of Shanon on the south. A villate 
called Corbally adjoins said castle and contains of arable land meadow pasture and marsh 220 acres. These are valued yearly in English lawful money payable as aforesaid at 8*l.* 6*s.* 8*d.*


¶401] A Custom called the Colpe or Colpis due to said late Earl within the town of Kyllmallock and collected quarterly from the inhabitants: the collector to be appointed by the Sovereign for the time being. In respect of this was received 1*d.* English for every beast viz cow, garon or otherwise being 4*d.* yearly for every beast; from every person accustomed to bring wood [*...*][687](javascript:footNote('E580000-001/note687.html')) to said town for sale a "horselode" of wood every quarter. The Commissioners estimate the number of beasts continuously in said town and its franchise at 1500 which brings in 25*l.* and from the horse loads of wood there is received 1*l.* 13*s.* 4*d.* English lawful [*...*][688](javascript:footNote('E580000-001/note688.html')) payable yearly as aforesaid amounting to 26*l.* 13*s.* 4*d.*


¶402] {MS folio 7d}The Castle and Vill of Ballyrepan aforesaid late in the tenure of Thomas Burgatt in the parish of Ballichahell, Pobulbryan containing a quarter of land valued in money and provisions to be rendered as aforesaid at 2*l.* 13*s.* 4*d.* money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt and 8 pecks of oaten malt.


A third part of the vill of Clarrenny in the parish of Corkamore valued in English lawful money yearly payable as aforesaid at 2*l.* 4*s.* 4*d.*


¶403] The Castle and villate of Ballinvially alias Ballinveallagh containing 1 quarter valued by said Commissioners in money and provisions to be rendered as aforesaid at 2*l.* 13*s.* 4*d.* money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt and 8 pecks of oaten malt.


¶404] A third part of the[689](javascript:footNote('E580000-001/note689.html')) and castle of Morenet[690](javascript:footNote('E580000-001/note690.html')) and Cloghologdick (beyond 6 quarters of land there belonging to the Bishop of Limerick) containing 3 quarters 2 now or lately in the tenure of [*...*][691](javascript:footNote('E580000-001/note691.html')) Brinckelo and the other now or lately in that of Peirce Loftes; valued as aforesaid in money and provisions as aforesaid to be rendered as aforesaid at 5*l.* money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt and 24 pecks of oaten malt.




---

p.155


¶405] The vill and land of Ballynourtie containing a carucate of land or "ploweland[692](javascript:footNote('E580000-001/note692.html')) valued as aforesaid in money and provisions to be rendered as aforesaid viz 1*l.* 13*s.* 4*d.* money; 2 cows; 4 peeks of barley malt; 4 pecks of wheat;, 8 pecks of oaten malt.


¶406] The vill and land of Ballyuolog alias Ballymoleogo et Kilbuy, in the parish of Corkamore containing 2 carucates of land valued as aforesaid in money and provisions to be rendered as aforesaid viz. 3*l.* 6*s.* 8*d.* money; 4 cows; 8 pecks of barley malt; 8 pecks of wheat; and 16 pecks of oaten malt.


¶407] {MS folio 8}Castle and land of Cloughytackie in the parish of Corkamore containing 2 quarters valued as aforesaid in money and provisions to be rendered as aforesaid viz 5*l.* 6*s.* 8*d.* money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt and 16 pecks of oaten malt.


¶408] The villate and land of Bannoge containing 1 quarter valued as aforesaid in money and provisions to be rendered as aforesaid viz 1*l.* 13*s.* 4*d.* money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶409] The vill and land of Drombegg and a garden containing half a carucate of land valued as aforesaid in money and provisions to be rendered as aforesaid viz 2*l.* money; and 2 cows.


¶410] The castle and vill of Inshe containing half a carucate valued as aforesaid in money &c to be rendered as aforesaid viz. 2*l.* money; 
2 cows.


¶411] The castle and vill of Cloughdullourdie containing a quarter of land valued as aforesaid in money &c to be rendered as aforesaid viz. 2*l.* 13*s.* 4*d.* money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶412] The broken castle of Ballynacortie in Arlo now or lately in the tenure of Peirce Grace containing half a quarter valued as aforesaid in money and provisions as aforesaid to be delivered as aforesaid viz. nothing because charged in Co. Tipperary.


¶413] {MS folio 8d}The villate and land called Ballelough and Ballenekenenough late in the tenure of John Browne containing 3 carucates which because waste are only valued as aforesaid in money and provisions to be rendered as aforesaid viz 5*l.* money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; 24 pecks of oaten malt.


¶414] A small low and broken castle or peel called Cullenoghwonagh near Co. Tipperary to which adjoin 4 quarters of land extremely fertile in the parish of Cullenoghwonagh acquired by the late Earl of Desmond from four brothers called Bourghes valued as aforesaid only at 1*l.* 13*s.* 4*d.* per quarter because the premises [693](javascript:footNote('E580000-001/note693.html')) in controversy and waste long before the rebellion and still remain so. They are valued as aforesaid in money and provisions to be rendered as aforesaid viz 6*l.* 13*s.* 4*d.* money; 8 cows; 16 pecks of wheat; 16 pecks of barley malt and 32 pecks of oaten malt.


Sum of the yearly value of the said castles lands and possessions of said Earl lying as well in the great as the small county of Limerick.


107*l.* 1*s.* money;
  

57 cows;
  

92 pecks of wheat;
  

92 pecks of barley malt;
  

184 pecks of oaten malt
  
.


¶415] *The manor of Asketton alias Asketing in the country of Connelo alias Ogonyll, Co. Limerick*.


{MS folio 9}Divers rents of free tenants in Offagus viz villate Nicholaii 1*l.* 2*s.*; Old town (veter villa) 1*l.* 2*s.* 2*d.* Total English money payable as aforesaid 2*l.* 2*s.* [694](javascript:footNote('E580000-001/note694.html')) 2*d.*


¶416] Divers small farms in Asketon parish viz Walshe's land (Terra Valens') 15*s.*; Cathir 13*s.* 4*d.*; Serjeantcy there 2*l.*; Mill 2*l.*; divers tenements in Asketon 15*s.* 8*d.*; Kildonel in parish of Clonchagh 6*d.*; total English payable yearly as aforesaid 6*l.* 4*s.* 6*d.*




---

p.156


¶417] A Salmon fishery belonging to said manor and castle of Asketin in the Deil river enclosing said castle and garden in 3 "pooles" viz lyn en assa, lyn en monyn, and lyn en Allerte: estimated as aforesaid at the clear yearly value in English money payable as aforesaid of 13*l.* 6*s.* 8*d.*


¶418] A very fine castle formerly a chief house of the late Earl of Desmond in good condition and repair because Sir William Pelham, knight, lord justice of Ireland particularly at the time of last rebellion remained there and repaired those parts burned by the Earl when he entered into said rebellion. Said castle is situate in a 
small island on a rock and is surrounded on all sides by a river flowing from South to North to the Shanon which is a mile distant and a skiff of 12 tuns burden can come to the castle bridge at springtide[695](javascript:footNote('E580000-001/note695.html')) The castle contains 2 several "coortes", 1 balne, and divers strong buildings placed around in scattered fashion viz a large hall, a great chamber, 3 cellars, a kitchen and other necessary places and bedrooms, two of which have iron doors a triangular garden (in which is a fish pond) on the south side of the castle. All the premises are enclosed by a stone wall and valued as aforesaid in {MS folio 9d} sterling money at 2*l.*


¶419] Demesne lands belonging to said manor and castle viz Kippaghhelinloge, Kippaghlingmoting containing ½ quarter of land; Insherooke ½ quarter; Moynerley ½ quarter; Kielrahen ½ quarter; Arderregan ½ quarter; Craigmore 3 quarters; Gragnesloughtherie alias Gragenabroge ½ quarter; which parcels are in 
Asketon parish and contain in toto 6½ quarters of land.


¶420] There are also divers other parcels of land formerly in the hands of said Earl of Desmond which were lately accepted as parcels of the Toghe or Canthred of Asketon viz. Moyeinirrla alias Moyana containing 4 quarters; Ballytomen ½ quarter; Clonilogha 20 acres; Ballynakilly 20 acres and Ballemore with a parcel called Leesseragh en Lacye late in the tenure of John Lacye ½ quarter; Sessheragh Lynarde late in the tenure of Leonard Nashe ½ quarter; Lehessherag Idir da Bohir late in tenure of Leonard Nashe 20 acres; Lehessheragh yrahin late in the tenure of Leonard Nashe 20 acres; Lekeharwemeanagh late in tenure of said Leonard Nashe and Robert O Farrella ½ quarter; which parcels contain in toto 2½ quarters: And all the said parcels contain in toto of arable land meadow pasture bogs furze underwood and waste (beyond large 
trees oak ash and the like) 13½ quarters: of these 4 quarters lying scattered around the castle are the more fertile for arable land meadow and pasture and they are valued at the rate of 6*l.* 13*s.* 4*d.* per quarter at 26*l.* 13*s.* 4*d.*; the other 9½ quarters parcel of the demesne lands of Asketon manor are replete with underwood and are valued 
at the rate of 4*l.* 13*s.* 4*d.* per quarter at 44*l.* 6*s.* 8*d.*


The entire premises are worth in sterling English money payable as aforesaid yearly 94*l.* 13*s.* 4*d.*


¶421] {MS folio 10}Memorandum within a furlong of said Castle is a water mill of which only the stone walls remain as the late Earl at the time of his entry into rebellion wasted and burned it, and it must be valued when it shall be rebuilt.


On the south of the castle is an island called "Gotes Islande" containing 30 acres full of great underwood of 30, 40, 50 and 60 years.


The said castle with the demesne lands aforesaid lie within the precinct called the parish of Asketon: there is no church except an old chapel of which the walls only are left which belongs to the parish of Ballingarry of which the rectory is impropriate and belongs to the Queen in right of the abbey of Kensam in England.


¶422] *The manor of Shaned alias Shannett with its members viz Corgragg Foynes and other lands in Connelo alias Ogonyll co. Limerick*.


Rents of divers free tenants who hold freely of said manor viz from Tulligh [*...*][696](javascript:footNote('E580000-001/note696.html')) (belonging to John Lacy of Ballingarry,[697](javascript:footNote('E580000-001/note697.html')) situate in Lismakerry parish, 2*s.*; from Ballirig there 1*l.* 4*s.*; total money as aforesaid to be paid as aforesaid 1*l.* 6*s.*




---

p.157


¶423] Like free rents from following vills and villates viz:— from the lands of James Wale called Downegehee and Ballyngowne in the parish of Grannshagh in the half tough of Ogallyhowre 1*s.* 3*d.*; the lands of Peirce Wale in Ballieghim in the parish of Rathekealie in the Toghe of Farrensesseragh 1*l.* 6*s.* 8*d.*; lands of Robert oge Cusshen called Egallahowre in parish of Granshagh, half Toghe of Ogalrahowre 6*s.* 8*d*: in all 1*l.* 14*s.* 7*d.* cancelled here because James and Peirce Wale and Robert Oge Cusshen were attainted whereby said lands have come to the Queen's hand and {MS folio 10d} are charged elsewhere in this book and therefore are here valued at nothing.


¶424] Divers customary lands of said Earl called chargeable lands late parcel of the Toghe of Shaned, viz:— Cloenlagharde in Kylmeylan parish in the tenure of Morogho mcKeaghan containing these parcels viz. Kill Cloine Comayn, En Classe Rowe, En Leasignelteagh, Kiell Eany glann ban, Boha Bworagh and Boh ha Swinson, amounting to a quarter of land for which the occupiers render yearly as aforesaid in money as aforesaid payable as aforesaid 2*l.* 11*s.* 8*d.* in money and 13 hours, each hour at the rate of 1*s.* 8*d.*, also a fat cow to be delivered yearly on 1st May; 2 other parcels of customary lands in the tenure of the Prior of Negelagh one called Monasterie de Negelagh and the other Downesahell, both containing 
2 quarters for which the occupiers rendered as aforesaid 4 marks lawful money of England on 2 fat cows on 1st May: these premises are now valued by the said commissioners yearly in sterling money payable at said feasts, in good fat cows to be delivered between Michaelmas and feast of All Saints and in grain to be delivered between 15 Nov. and 25 March following. And if the victuals and provisions (which are to be delivered within 8 miles of said lands) are not delivered as specified aforesaid they are valued by the commissioners as follows viz every cow at 13*s.* 4*d.*, every peck of wheat containing 16 gallons the peck at 3*s.* 4*d.*, every peck of barley malt at 20 gallons the peck similarly valued at 3*s.* 4*d.*, and every peck of oaten malt of same measure at 1*s.* 8*d.*; and so in toto yearly 5*l.* money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶425] Divers small farms whose names and rents are as follows viz. Land of Morris 14*s.*; Inshenegerath 6*s.* ; hand mills in Shaned 15*s.*; Sergeantcy there 2*l.*; water mill of the new Grange there 15*s.*; land 
of the reapers of Shaned 6*s.* 8*d.*; old orchard there 2*s.* 2*d.*; In all yearly in money as aforesaid to be paid as aforesaid 4*l.* 18*s.* l0*d.*


¶426] {MS folio 11}Two old and ruinous castles one situate on the top of a very lofty mountain and surrounded by a barbican which nearly fell 
with the castle, the other is situate on the north west of same mountain at the foot thereof, built in quadrilateral form, 50 feet in length without the walls and 30 feet in breadth: in this castle or peel were five several places or rooms (cubicul') in two upper floors (solar') or stories and the roof entirely broken down. Near and on the east 
side of this castle is a chapel lately built of which only the walls now remain. The demesne lands are divers parcels in the vill of Shaned and parish of Killmeylan called Dooraghnas, Gortemokeran, Knockannecroyeth, Shangannagh, Gawre, Ballyloman alias Gortloman, Small park, Cullenagh wood, and Monecrinagh; all which contain 5 quarters of arable land meadow and pasture.


¶427] together with another castle called Currickye and Shanyclone containing 1 quarter in the parish of Killmeylane, the villate of Ballycormacke there containing 26 acres; villate of Ballyhahell there containing 1 quarter; villate of Knockenegornagh and Bellaghdroome in Stewlogher there containing 2 quarters; Craig mcTeig Clonelty alias Clonety and Fynnor with the appurtenances viz En Mullagh, Cragge, Movanina[698](javascript:footNote('E580000-001/note698.html')) Ballyknockan, Mollagharde, Fynnor alias Fynur, Tullagharton Bealneglar, Shanecloyne, Shannekyn, Cloen[699](javascript:footNote('E580000-001/note699.html')) Ecohora and Cloen Ecadegan containing in toto 7 quarters; Ballyogwyn and Ballynokylly containing two parts of a quarter of land divided into 3 parts.


¶428] All the premises lie in Kyllmeylan parish and contain in toto 7 quarters of arable land meadow and pasture with their appurrenances {MS folio 11d} viz bogs furze under woods and other wastes. Of these 5 quarters lie around the castle aforesaid are fertile for arable land meadow and pasture, are valued by the Commissioners as aforesaid at the yearly rate of 4 marks per quarter in English sterling money, and in victuals and provisions to be delivered as aforesaid as follows viz. 



---

p.158




from every quarter 3 cows large and fat, 4 pecks of wheat, 4 pecks of barley malt and 8 pecks of oaten malt of the several measures aforesaid. The remaining 12 quarters are 
more sterile, and abounding in underwoods about 12 years old and they are valued as aforesaid in money at 10*s.* per quarter and in victuals and provisions as aforesaid at the following rate viz for every quarter 2 cows good and fat, 3 pecks of wheat, 3 pecks of barley malt and 6 pecks of oatenmalt of like measures. If the said victuals and provisions are not received in their several species (the election will be in the power of the Queen by her lord Deputy of Ireland &c) then they are valued by said Commissioners as follows viz. for every cow 13*s.* 4*d.*, every peck of wheat 3*s.* 4 d, every peck of barley malt 3*s.* 4 d, and very peck of oaten malt 1*s.* 8*d.* and as the premises are extended yearly as aforesaid in money and provisions to be delivered as aforesaid at 18*l.* 6*s.* 8*d.* in money; 39 cows; 56 pecks of wheat; 56 pecks of barley malt; 112 pecks of oaten malt.


¶429] Divers other farms belonging to Shaped manor viz a castle with an island called Foynes containing a carucate of land within Bally Roberte parish in the toghe of Donmoylin; a meadow called Grenaughe in same parish containing 5 acres; a piece of land called Duynesh containing 15 acres; a large and very fine castle called Corgragg in Bally Robert parish with a {MS folio 12} fishery and good marsh lands there, parcel of the said toghe of Donmoylin containing 2 quarters 60 acres of land. There are also in same parish and toghe 2 other parcels called Leath and Ballylawras alias Lawrer each of them containing a quarter. And so the premises in all, arable land, 
meadow bogs underwoods and other wastes amount to 6 quarters of these 4 lying near said castle are valued as aforesaid at the rate of 6*l.* 13*s.* 4*d.* per quarter to 26*l.* 13*s.* 4*d*: the remaining 2 quarters very sterile and more remote from said castles are valued as aforesaid at the rate of 3*l.* 6*s.* 8*d.* per quarter to 6*l.* 13*s.* 4*d.* All amounting in money as aforesaid payable as aforesaid to 33*l.* 6*s.* 8*d.*


Total yearly value of Shaped alias Shanett as well in money as victuals and provisions viz


*l.* 18*s.* 2*d.* in money;
  

45 cows;
  

68 pecks of wheat;
  

68 peck of barley malt
  

136 pecks of oaten malt
  
.


¶430] Note: there are no woods or underwoods on any part of the 5 quarters around said 2 castles; but there are dense underwoods twenty years old and more, and trees called doterd trees growing sparsely in Foynes Island. This island is north of Corgragg Castle, within four furlongs thereof, in the great river of Shanon and the water between the island and Corgragg is so deep that a ship of 100 tuns burden can come there at "Lowe water.[700](javascript:footNote('E580000-001/note700.html'))


As well the free and customary tenants as the occupiers of all the carucates aforesaid (except the six carucates of the lands of Corgrag and Foines) formerly had and received common herbage for their beasts and cattle in that part of the great mountain of Slewlogher next adjoining the boundaries of their lands.


The rectory of Bally Robert aforesaid is impropriate and belongs to the Queen in right of the late monastery of Negelagh to which it belonged.


The Bishop of Limerick is patron of the church of Kilmeylan alias Kilveylan aforesaid and disposes of the spiritualities thereof.


¶431] *The Manor of Newcastle with its members in Connelo alias Ogonnyll co. Limerick*.


{MS folio 12d} Divers rents of free tenants who hold freely of the said manor, viz:—for the lands or vill of Robert Roche alias Ballyn 
Roberd Roe 1*s.*; the vill of Gortcormithie alias Gortconykyn in Rathagalway[701](javascript:footNote('E580000-001/note701.html')) 5*s.*; the villate of Killanis in Rathagalwa 3*d.*;, Bellaghmylig alias Belaghneligg in the parish of Ballycastellane, Kokirmohid in the toghe of Clonehennery issuing from the lands of John mcKenry 2*d.* In all in sterling English money payable as aforesaid at the castle of Newcastle 6*s.* 5*d.*




---

p.159


¶432] Like free rent issuing from land of Robert Oge Cusshin called Bohernemebetagh which is not charged here because Robert was attainted of High treason for which attainder the said land came to the Queen's hand and are charged afterwards in this book among the possessions of said Robert but here the value is nil.


¶433] Like free rents of other tenants viz rent of the free tenants of Killidie viz. 1*l.* from the land of John of Thomond (Thotomone); 
6*s.* 8*d.* from land of [*...*][702](javascript:footNote('E580000-001/note702.html'))Harvy; 6*s.* 8*d.* from Gort Richard (de campo Ricardi); 6*d.* issuing from land of Donald O Neal in Obathan; and 1*d.* from Glancoyne: in all, like money at said feasts 1*l.* 13*s.* 11*d.*


¶434] Formerly there belonged to said manor other like free rents issuing from the following lands viz. 2*l.* 13*s.* 4*d.* from Rathkaell late belonging to Gerald mcThomas of Kyllfynny and Kyllcalpyle alias Kyllnecappe lately belonging to said Earl which are not 
charged here as said Gerald mcThomas was attainted of High treason whereby said lands came to the Queen's hand. They are charged afterwards in this book but here their value is set down at nil.


¶435] {MS folio 13} Divers customary lands called chargeable lands of the said Earl belong to this manor together with Shraghe and Mart viz. from Morogho mcEdmond Oge for 2 quarters of land one called Ardnecrogh and the other Garreduff in the parish of Monoghadare parcel of the Toghe of Gortcoith who rendered therefor yearly at said feasts by equal portions in sterling money 4 marks, 8*s.* 11*d.*; 3 fat cows called beoves or marts on the 1st May 
every year. They are valued in money as aforesaid and provisions to be delivered as aforesaid at 3*l.* 6*s.* 8 d, money; 4 cows; 8 pecks of wheat; 8 pecks of barley malt and 16 pecks of oatenmalt.


¶436] Other rents of customary lands called chargeable lands formerly belonged to said manor issuing from the lands following viz: 2 marks and 9*s.* sterling; and 2 marks and 2*s.* halface; and a cow beofe or mart lately paid by Gerald mcThomas and Edmond Gankoth for lands called Rathkaell in Monoghadare parish. They are not charged here because Gerald mcThomas seised of same land was attainted whereby said lands came to the Queen's hand: they are charged elsewhere in this book and therefor are here set down as value nil.


¶437] Divers small farms belonging to the manor of Newcastell viz. lands in Castellnoa Gortdowran 5 acres late in the tenure of John Omakisse 8*s.*; certain cofts[703](javascript:footNote('E580000-001/note703.html')) there 15*s.*; bog (moora) 3*s.*; land of Comeden alias Tunisland 5*s.*; which all amount to 1*l.* 11*s.*


¶438] Lands in the hands of the late Earl there called Donygalyn alias Ballyfarewell 2*l.* 4*s.*; Clonebane belonging to same Earl 14*s.*; which premises are in Rathgallwaye aforesaid and worth in toto 2*l.* 18*s.* Ballyatheren 4*l.* 6*s.* 8*d.*; Ballyhursint 4*l.* 6*s.* 8*d.* in the parish of Castellnoa in Obathan as is said. Similar farms lie in Obathan viz. a hand mill there 2*s.* 8*d.*; serjeantcy there 2*l.*; which premises are worth in toto 10*l.* 16*s.* Like farms lying in Gortcoith called the half Togh of Gortcoith viz Ballyodullwith 4*l.*; Ballyogarwieth 4*l.*; Kill mac sawin 5*l.*; a hand mill in Gortcoyth {MS folio 13d} 15*s.* 6 d;
serjeantcy there 17*s.* 6 d; which premises are worth in toto 14*l.* 13*s.* For certain lands and tenements in Killiddie viz. demesne lands there 4*l.*; lands of burgesses there 8*s.*; crofts-there 1*s.* 8*d.*; old orchard there 1*s.* 8*d.*; land of reapers who are burgesses there 6*s.* 8*d.*; Athguth 4*l.* 10*d.*; Kilkerue 1*l.* 5*s.* 6*d.*; Clonedirdawne 1*l.* 5*s.*;
hand mill of Killidie 15*s.* 5*d.*; serjeantcy there 1*l.* 6*s.* 8*d.*; which premises amount to 13*l.* 11*s.* 5*d.*


The entire yearly amount in money as aforesaid payable as aforesaid is 43*l.* 9*s.* 5*d.*


¶439] A large castle in quadrilateral form formerly a chief house of the late Earl of Desmond in Connelo having a round tower at every angle with divers places and rooms in every tower, at the south west corner is a lofty quadrilateral peel built for defense within the walls. And within the walls were many buildings viz a a great hall, large chamber, very good rooms; a garden in which were two fish ponds .all of which are now ruinous and waste. Without the walls and near thereto are divers orchards and gardens 
containing 3 acres worth yearly with the site of said castle 1*l.* 6*s.* 8*d.*


---

p.160




Demesne lands belonging to the castle and manor situate in Newcastle parish and late in the tenure of David Oge Harbert viz. Eanaghe, Dowally, Feataen in erlyn, Glasshie in arla, Ballynroherdroa, Ceasnagloche, Mohagh duff, Gortliegan, Tullaghalim, Fearontuniagh, Enparricke alias Newcastle park, Kyllyhelin, Gorticolhain, Gorticollyfero, Garrileakin, Garrynabin, F[704](javascript:footNote('E580000-001/note704.html'))royde yguir, Farren mc ygonir, F[705](javascript:footNote('E580000-001/note705.html'))rad y gurran, F[706](javascript:footNote('E580000-001/note706.html'))radnatono containing in all 4½ carucates of land.


¶440] There are 4½ other quarters of land parcells of the demesne, lands of said manor lying in the parish of Monoghadare viz Kylruddane, Gorturane, Gurranlupfagh, Ballylahiff, BallnaCully, Kilcui ffyn, Leach fan, Fyemore, Fiebegg, Lishcubbigg, Ballyrubin, Gortowrani and Lysh na Cally; also divers parcels of demesne lands belonging to said manor in Monoghadare parish lately parcels of the half Toghe of Killidye viz. Kintogher ½ quarter; Ballyregan 60 acres; Gortmoynan 20 acres; Ballyowen 20 acres;
Balliguil 20 acres; Rahanagh 20 acres; Ballyshane 20 acres; Ballycurcke and Gortcomikin {MS folio 14} 20 acres; Ballyclowan 20 acres; Ballymac Isse Leadurhamoore and Rath y Gallavan 20 acres; Ballymac Ranill 20 acres; Crean 20 acres; Callynogh 20 acres; Glannowhim Ballygowne and Ballykene 1 quarter; and Croghan in Kyllidye parish ½ quarter; containing in all 6 quarters.


¶441] Likewise there are in the half Toghe of Gortcoith belonging to said manor and in the hand of said Earl lying in Monoghadare parish divers other parcels of demesne lands viz. Glannowhyn with 20 acres in Kilkellen, 1 quarter called Dowill and 20 acres called Ratheconerie, amounting to 5 quarters; Templeglantan, Droomebarne, Kannegully, Moneclohie and Barrin 1 quarter; Kilcoynelie 1 quarter; Drometrasena 1 quarter; Kyllquolle, Ballycoman and Gortawracaum 1 quarter; Tulligoyline Bellabeha, Seskinleduffie and Knocke Brake 1 quarter; and Ballymorohoo in said parish adjacent to the mountain of Slewlogher containing with the parcels called Killinidan, Killnicappagh, Ballycearule, 
Gortan Bealligg, Gortnacloch and Fearne ne gunynagh, 2 quarters. In all in said half Toghe of Gortcoith 12 quarters.


¶442] And so the demesne lands of said manor amount in all to 27 quarters of arable land meadow and pasture with their appurtenances viz. bog, moor, underwoods and waste (beyond great woods, great trees, oaks, ash trees and the like). Of these 13½ quarters lying around and near the said castle are good and fertile for arable land, meadow and pasture and some of them are repute[707](javascript:footNote('E580000-001/note707.html')) with woods and underwoods of divers kinds and ages; and they 
are valued by the year in money as aforesaid at the rate of 1*l.* per quarter payable as aforesaid, and in victuals and provisions to be delivered as aforesaid viz for every quarter 3 cows good and fat, 4 pecks of wheat, 4 pecks of barley malt and 8 pecks of oaten malt, every peck of wheat containing 16 gallons (lagen[708](javascript:footNote('E580000-001/note708.html')) and every peck of barley and oaten malt containing 20 gallons. And the remaining 13½ quarters are more fertile [709](javascript:footNote('E580000-001/note709.html')) and replete with some underwoods of divers ages and are {MS folio 14d} valued in said money to be paid yearly as aforesaid at the rate of 1*l.* 3*s.* 4*d.* per quarter; and in victuals and provisions viz. for every quarter a cow good and fat, 3 pecks of wheat, 3 pecks of barley malt and 6 pecks of oaten malt of the several measures aforesaid to be delivered yearly within said manor or 8 miles thereof at the appointment of the lord Deputy &c for the time being to the use of the Queen for all services and charges except suit of court and like services viz the cows between the feasts of Michaelmas and All Saints and the corn between 15 Nov. and 25 Mar. yearly. And if the said victuals and provisions are not accepted in their several kinds as aforesaid the election of which will be in the power of the Queen by her lord Deputy &c for the 
time being then they are valued by said commissioners as follows every cow at 13*s.* 4*d.*, every peck of wheat or of barley malt 3*s.* 4*d.*, and every peck of oaten malt at 1*s.* 8*d.* And so the premises in toto are extended yearly at 29*l.* 5s. in money; 53 cows; 94½ pecks of oaten malt.


¶443] Yearly value of the said manor of Newcastle as wellin sterling English money as in victuals and provisions viz.


78*l.* 1*s.* 5*d.* in money;
  

57 cows;
  

102½ pecks of wheat;
  

102½ pecks of barley malt;
  

205 pecks of oaten malt
  
.




---

p.161


Note:— the free and customary tenants as well as the occupiers, of every kind, of said 27 quarters of land had common pasture (herbagium) for their beasts and cattle on the great mountain of Slewlogher aforesaid. And the late Earl of Desmond was patron of said churches of Newecastell and Monoghadare, and the chapel of Templemonagh alias Morechurche of which the churches (templa) are completely wasted except the walls.


¶444] *The Manor of Meane lately acquired from the White Knight by James formerly Earl of Desmond situate in the Small[710](javascript:footNote('E580000-001/note710.html')) County, co. Limerick*.


{MS folio 15} Certain services of divers free tenants holding certain lands freely of same manor which tenants are[711](javascript:footNote('E580000-001/note711.html')) not to be charged with rents called Shraghe and Mart, nor with exactions or impositions called Coyne, Lyvery, Kearntie, Kearne, Cussherie, Cuddie, 
Gillygie, Gillycon, Bonybur &c, but they were charged yearly with "the musteron" in aid of the Earl for fortifications and repairs of castles bridges and other services with horses c [*...*][712](javascript:footNote('E580000-001/note712.html')) (caballi), garrons and labouring men; and with a tax on all the free tenants there alias Sowth for raising money for payment of the debts and other necessaries of the said Earl as often as the late Earl found it necessary; with refections and victuals called Repaste and Awaye, whenever the Earl went through that country: which taxes, refections and repasts have extended in sterling English money and provisions as follows viz. for Cuilbane, Cucurraith, Sheoin 
Raithe, Ballymerkilly [713](javascript:footNote('E580000-001/note713.html')) Ballygynorta alias Ballygarrily, Lishekillen, Fearan an Mullen, Gortnacroghie, Gurtins alias Gortins, Cowlemiskishe containing in all 4 quarters which are extended as aforesaid at the rate of 13*s.* 4*d.* in English money and 2 cows in provisions for each quarter: and so the premises are worth yearly 2*l.* 13*s.* 4*d.* in money and 8 cows.


¶445] Divers customary lands of said Earl called chargeable lands for which the tenants or occupiers were wont to render yearly in English sterling money at Easter and Michaelmas by equal portions the Shraghe viz a rent 4 8*l.* 17*s.* 8*d.* and on 1 st May yearly the 
Mart viz 6½ good and fat cows: viz Philip mc Gibbon for lands in the parish of Mohawnaghe in Tryan Tawnaghe in the Toghe of Tawnaghe namely Moynlean 30 acres, {MS folio 15d} Cloneshericke 30 acres, Dirrio and Killiriedur 30 acres, Ballyinbreaghing ½ quarter, Ballynakilly 20 acres, Lishkillen 60 acres, Gortnescaghe 
½ quarter, Cloyndeihin 20 acres, Beally in Uskie 20 acres, Cloynfeartie 20 acres, Bally en mullen 10 acres; which lands contain in toto 4 quarters of arable land meadow pasture, underwood and other waste extended by said commissioners in English sterling money and money to be delivered as aforesaid viz 6*l.* 13*s.* 4*d.* in money; 8 cows; 16 pecks of wheat; 16 pecks of barley malt; and 32 pecks of oaten malt.


¶446] Formerly there belonged to said manor divers similar customary rents from the lands late of Thomas Cham attainted lying in Treane Moane, and Trean ffaltaghe parcels of the Togh of Tawnaghe in Mahownagh parish; which rents are charged elsewhere in this book among the lands of said Thomas and here in consequence are not set down of any value.


¶447] A castle which was a very fine and ample house before the rebellion in which it was very much cast down and wasted so that to-day nothing remains of it except the stone walls; yearly value 10*s*: 2 quarters of demesne lands lying there in Trean Meane parish of Mohawnaghe in divers parcels viz. Trean Meane parcel of said Toghe of Tawnagh, parish of Mohawnagh lying in the following parcels viz Knockan na vien, Cuilloskie, Kyllclonya,[714](javascript:footNote('E580000-001/note714.html')) Clueogh, Cloincuravan, Garran Meane and Balliguillyn in Cuilymiskie; which 2 quarters of arable land meadow pasture, bog underwood and waste (besides large trees oak, ash, and the like) are valued by the year at the rate of 1*l.* 13*s.* 4*d.* English per quarter payable at Easter and Michaelmas and so amount to 3*l.* 6*s.* 8*d*: {MS folio 16} and further there is payable for every of said quarters the victuals and 
provisions 



---

p.162




following to be delivered yearly within said manor or 8 miles thereof at the appointment of the lord Deputy &c for the time being for all services exactions and demands (except suit of court and like services) viz 2 cows large and fat to be delivered yearly between the feasts of St Michael the archangel and All Saints, 4 pecks of wheat, 4 pecks of barley malt, and 8 pecks of oatenmalt to be delivered yearly between 15 Nov and 25 March: and if said victuals and provisions are not delivered in their proper kinds as aforesaid (the election of which will be in the power of the Queen by the lord Deputy &c) then they are valued by said commissioners as follows every cow 13*s.* 4*d.*, every peek of wheat 3*s.* 4*d.*, every peck of barley malt 3*s.* 4*d.*, every peck of oaten malt 1*s.* 8*d.* And so the premises are valued as aforesaid in Sterling English money victuals and provisions to be delivered yearly as aforesaid at 3*l.* 6*s.* 8*d.* in money; 4 cows; 8 pecks of wheat; 8 pecks of barley malt and 16 pecks of oaten malt.


And so the entire yearly value of said manor reserved as aforesaid is


12*l.* 13*s.* 4*d.* in money;
  
 
20 cows;
  
 
24 pecks of wheat;
  
 
24 pecks of barley malt;
  
 
48 pecks of oaten malt
  
.


¶448] *Manor of Portrynard alias "the fforte of three enemies" in the mountain of Slewlogher co. Limerick*.


{MS folio 16d} A castle built of round form with divers villates in the parishes of Templeclay, monastery ne gelagh (Old Abbey)[715](javascript:footNote('E580000-001/note715.html')) and Monaster nefealye alias nefuylagh (Abbeyfeale)[716](javascript:footNote('E580000-001/note716.html')) lying in these parcels viz. 3 quarters of land called Athdee alias Athea; Knockoweny, and Dirremaymore in Slewlogher; 1½ quarters of same manor Cnockradermodo and Knockesanaugh in Slewlogher parish of Abbeyfeale; containing in all 4½ quarters of arable land meadow pasture bog underwood and other waste (besides large trees oak ash and the like) which 4½ quarters together with grazing in for cattle on the mountain of Slewlogher are valued by said Commissioners yearly in English sterling money payable at Easter and Michaelmas
only at 1*l.* 6*s.* 8*d.* per quarter; and further for every quarter the victuals and provisions following to be delivered yearly within said manor or 8 miles thereof at the appointment of the lord Deputy &c to the Queen's use for all charges exactions and demands
(except suit of court and like services) viz. for every quarter one cow large and fat to be delivered yearly between the feasts of Michaelmas and All Saints; and if the lord Deputy shall not accept or receive said cows, but as so entitled to do shall elect to receive money in lieu of the cows then the premises are worth in toto by the year 6*l.* 6*s.* 8*d.* in money and 4 cows.


A good Salmon fishery in the Phele river is valued yearly by said commissioners in English sterling money payable at the aforesaid feasts by equal portions at 21.


Total yearly value of said manor reserved in money and cows as aforesaid


8*l.* 6*s.* 8*d.* in money
  
 
4 cows
  
.


¶449] {MS folio 17}Memorandum. It is most expedient to locate a sufficient English man or force[717](javascript:footNote('E580000-001/note717.html')) in said Castle of Portrynarde which is very strongly situated upon the great mountain of Slewlogher between Limerick and Kerry. It is a very suitable place to chase and extirpate wicked and lost men who fly there and roam about or conceal themselves when they have committed wicked deeds: and on the contrary it is a most dangerous place to receive protect and nourish rebels traitors and robbers to the offence and terror of good subjects if said castle were in the custody of any evil person or in the
hands of those who assist the rebels and do not punish or pursue wicked men as they ought.




---

p.163


{MS folio 17d blank}


¶450] *The Sixteen Canthreds or Toghes of the late Earl of Desmond in Connelo alias Ogonill co. Limerick*.


{MS folio 18}Divers castles-vills, villates, lands, tenements &c of said late Earl called chargeable lands from every cantred of which were 
delivered yearly to said Earl as rent 40 marks for the Shraghe in money called halface by equal portions at Easter and Michaelmas; and for Mart 20 good fat cows yearly on 1 st. May; also for wages stipend and expenses of soldiers horse and foot otherwise called horsemen galloglas and kerne; and for Coine Liverie, Sorohen Bonebegg, moosteron, Cosshrie, Quiddie, and other services taxes and cuttings for the fortification and repairs of castles bridges and the like, services of the country and uncertain customs as of[718](javascript:footNote('E580000-001/note718.html')) as it pleased the late earl or his officers; amounting yearly (as the commissioners think) to ten times as much in value as the Shraghe and Marte aforesaid are worth yearly.


The names of the tenants and lands and the quantity are declared below viz.


¶451] Edward Lacye of Bruerie is tenant of the vill and castle of Brewerye in the Toghe of Bruerie containing 1 quarter; Bohermore 1 quarter; Garrowes 1 quarter; Lishenaghenkono 1 quarter: all in the parish of Bruery. Every quarter and carucate in this district (patria) have appurtenances consisting of pasture feeding, waste, 
woods, underwoods &c which are not included in the measure although such appurtenances contain the same quantity of land as the quarter or carucate to which they appertain. Every quarter throughout Connelo[719](javascript:footNote('E580000-001/note719.html')) aforesaid contains 80 acres of arable land according to Irish measure which is more clearly declared hereafter in this book among the services: it is computed at 21 feet the perch or pole[720](javascript:footNote('E580000-001/note720.html')) and the commissioners have followed this standard in their surveys throughout Munster province. The premises contain in toto 4 quarters of arable land, meadow pasture, bog, common underwood and other waste (except large trees oak ash and the like for timber and necessaries, provisions, services and all and singular mines and metals of every kind to the Queen and her successors altogether reserved). They are valued by the Commissioners as well for Shragh and Mart before specified as for all others charges exactions taxes customs wages and uncertain demands of every kind before mentioned (except suit of court and similar services) at certain yearly rents and reservations as well in sterling English {MS folio 18d} money as in victuals and provisions to be delivered in the form following viz. for every quarter in money payable yearly by equal portions at Easter and Michaelmas 2*l.* 13*s.* 4*d.* and in victuals and provisions 2 good fat cows to be delivered yearly within 8 miles of the lands from whence they are due between the feasts of Michaelmas and All Saints; 4 pecks of wheat; 4 pecks of barley malt and 8 pecks of oatenmalt; to be delivered yearly between 15 Nov. and 25 Mar. within 8 miles of the lands from which they are due. If the victuals and provisions are not delivered in the several species and manner aforesaid (the election of which will be in the power of the lord Deputy &c) then they are valued in English sterling money as follows viz a cow 13*s.* 4*d.*, a peck of wheat containing 16 gallons (lagen') 3*s.* 4*d.*, a peck of barley malt containing 20 gallons 3*s.* 4*d.*, and a peck of oaten malt containing 20 gallons 1*s.* 8*d.* And so it amounts yearly to 10*l.* 13*s.* 4*d.* in money; 12 cows; 16 pecks of wheat; 16 pecks of barley malt and 32 pecks of oaten malt.


¶452] James Lacye of Ballyfowke is tenant of divers lands in the toghe and parish of Brewerie viz. Ballyfowke 1 quarter; Ballynowran 1 quarter; Ballynalmodo 1 quarter; all containing 3 quarters and extended yearly by said Commissioners in English sterling money and provisions to be rendered as aforesaid: viz 8*l.* in money; 9 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt. John mc Kenry is tenant in the Toghe of Clonehennery in the parish of Ballycastellane of the following 10 parcels viz. Ballaghomylley, the castle of Ballyncastellane, Dirrealyne, Cappaghnea an Cragge, Gortenerooghe, Gurtin, Cappaghquin, Killihallogh and Killrowne alias Kylbowne Cloney and Cappaghranentagh containing 7 quarters of said measure valued yearly by said commissioners in money and provisions as aforesaid to be delivered yearly as aforesaid at 18*l.* 13*s.* 4*d.* in money; 21 cows; 28 pecks of wheat; 28 pecks of barley malt; 56 pecks of oaten malt.




---

p.164


¶453] {MS folio 19} Thomas Mc Hewe is tenant of Pobullmynter guyrrine in said Toghe and parish of Castellane aforesaid containing 3½ quarters like measure which are valued yearly in money and provisions payable as aforesaid at 10*l.* 4*s.* 8*d.* in money; 9 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶454] Philip O Kahill is tenant of Ballynwrelie in the parish and toghe aforesaid containing ½ quarter valued yearly in money payable as aforesaid at 3*l.* 6*s.* 8*d.*


¶455] Mahownd Oquillane is tenant there of Abaheene containing 1 1/3 quarters like measure; valued yearly in money and provisions payable as aforesaid at 4*l.* 17*s.* 8*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of oaten malt.


¶456] Robert ONownain is tenant of Muskerie nownan, known by the several names of Knockhrewee, Dromcollogor Colebuy and Killerie containing 4½ quarters valued in money and provisions as aforesaid to be delivered as aforesaid at 14*l.* in money; 12 cows; 16 pecks of wheat; 16 pecks of barley malt; and 32 pecks of oaten malt.


¶457] John Edward and Richard London are tenants of Kowlerush in the Toghe of Gortculligan parish of Ballingarry containing 2½ quarters; Ballienegurran 2 quarters; Dohaylmore 1 quarter; Dohaylebegg 1 quarter; Callaughe 1 quarter 20 acres; Ballyfort ½ quarter; Ballyhomuc 20 acres; Ballyhebyn 20 acres; Ardgowlebegg 1 quarter; Ballywerishin 20 acres; Ballyntraherdyke 20 acres; {MS folio 19d} and Naggragragh ½ quarter; which are in the toghe and parish of Nantenan and contain in toto 8 quarters 20 acres Kilkosgran in the toghe of Donmoylin, parish of Kylvolan 1 quarter And, so the entire premises containing 11 ½ quarters 20 acres are
valued yearly in money and provisions to be delivered as aforesaid at 18*l.* 15*s.* in money, 30 cows; 40 pecks of wheat; 40 pecks of barley malt; 80 pecks of oaten malt.


¶458] Thomas McPhillippe McEdmonde is tenant in the toghe of Gortculligan and parish of alhngarry aforesaid of Ballyne 1 quarter; Durlus 1 quarter; Kielmore 1 quarter; containing in all 3 quarters valued yearly as aforesaid, to be rendered as aforesaid at 5*l.* in money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶459] John Leo is tenant of Liskaeneedie in the parish and toghe aforesaid containing 1 quarter; valued yearly as aforesaid and to be rendered as aforesaid at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶460] Richard mc Thomas is tenant of Lysmotoo with a castle and containing 1 quarter; Gortnofoe containing ½ quarter; in all 1½ quarter valued as aforesaid, and to be rendered as aforesaid at 5*l.* 6*s.* 8*d.* in money; 4 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶461] John Lacye of Ballingarry is tenant there of 6½ quarters of land called Kylmckynerly 1 quarter; Ballygyelltagell 1 quarter; Ballynele Capkane, Kivohogh and Kylmehele castle {MS folio 20} 3 quarters; Garrestowne ½ quarter; Cloneregan ½ quarter; Kylbegg ½ quarter: Inchemore ½ quarter in the toghe and parish of Nantenan: also of 7 quarters viz. Tullaghe alias Tullaughanson[721](javascript:footNote('E580000-001/note721.html')) 1½ quarters; Ballenmollen 1½ quarters; Conigarr 1½ quarter; Llaghbane 1 quarter;
Creagh 2 quarters; and Garrenfarsan ½ quarter; which lie in the toghe and parish of Lismakery: Bealdorode in Kyllcollman parish ½ quarter which is parcel of Rathekealye in the toghe of Olybane: Encreaff ½ quarter parcel of the toghe of Donmoylin in the parish of Donmoylin: containing in all 15 quarters valued yearly as aforesaid to be delivered as aforesaid at 40*l.* in money; 45 cows; 60 pecks of wheat; 60 pecks of barley malt; and 120 pecks of oaten malt.


¶462] Pierce oge Lacye of Broughe alias Broffe for Doroglogh in the parish of Ballingarry in the toghe of Gortculligan 5 quarters valued yearly as aforesaid to be delivered as aforesaid at 7*l.* 6*s.* 8*d.* in money; 9 cows; 20 pecks of wheat; 20 pecks of barley malt; 40 pecks of oaten malt.


¶463] Rory mc Shehie is tenant of Ballynrogie 1 quarter; Ballyalenan parcel of Rathkealye 1 quarter; and Ballymynteryroerke 2 quarters, in the parishes of Kyllcollman and Rathekealye in the toghe of Olybane; 7 quarters called the Castle of Robert Downedunell[722](javascript:footNote('E580000-001/note722.html'))
alias Downedonell alias 



---

p.165




Clogh an Arulta; Kyllcoole ½ quarter; ffearren a Kills Ballynridealy 1 quarter; ffyhanagowre 1 quarter; Tone Iaghara 1 quarter; Ballyanbosseraye 1 quarter; Lyslyguston 1 quarter; Cnock y dirty 1 quarter; all which, parcels lie in the parishes of Clonelty, {MS folio 20d} Clochan and Cloche an Arulta
and are parcels of the toghe of Asketon.


¶464] The said Rory was wont to pay yearly to said Earl for Shraghe at the feasts of Easter and Michaelmas by equal portions 8*l.* 8*s.* 4*d.* and for mart 7 fat cows on 1 st May. Three quarters parcel of the toghe of farrensesseraghe viz. Kyllaheine 1 quarter, Rathemckandon 1 quarter, and Ballyloyney 1 quarter lying in the parish of Kyllskannell; Bohergall 1 quarter and Ardrean 1 quarter, parcels of the toghe of Ogallyhowre in the parish of Gransha (Grange): Kylordan[723](javascript:footNote('E580000-001/note723.html')) 2 quarters, Ballynytie and Kylkaherowe 2 quarters, and Cultomyn 1 quarter, which are parcels of the toghe of Drynan in the parish of Kyloradran. And so the entire premises are valued yearly, to be delivered as aforesaid, at 56*l.* in money; 63 cows; 84 pecks of wheat; 84 pecks of barley malt; 168 pecks of oaten malt.


¶465] David encorig alias Enhorigg, late lord of Great wood (Kilmore) attainted is tenant of Clonelara and Ballynranky 1 quarter, parcel of the toghe of Gortculligan in the parish of Ballingarry; Downebaren ½ quarter parcel of the toghe of Olybane and of Rathekealye in the parish of Kyllcollman; Ballyany 1 1/3 quarters parcel of the toghe of Drynan in the parish of Kyllvradran; Kylcohan ½ quarter parcel of the toghe of ffarrensesseraghe in the parishes of Clonehaghe and Rathekealye; Ballynlonderig 1 quarter in the toghe of Meaghan in the parish of Raronan. And so the premises contain 4 1/3 quarters: as they are situate in a desert place on the mountains for the most part full of underwood of no value they are valued yearly as aforesaid, to be delivered as aforesaid, at 6*l.* 8*s.* 10½*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶466] James oge Nashe is tenant of Ballykenan[724](javascript:footNote('E580000-001/note724.html')) 1 quarter in the parish of Ballyngarry and toghe of Gortculligan; Ballynacahargh 1 quarter in the parish and toghe of Asketon; {MS folio 21} a castle and
2 quarters of land viz. Ballecollen containing 1 quarter and Ballyelanain the other situate in the parish and toghe of Lysmakerrie: which premises were lately in the possession of Philip Nashe slain in the rebellion of James Fitzmorris containing in toto 4 quarters valued yearly, to be delivered as aforesaid, at 10*l.* 13*s.* 4*d.* in money; 12 cows; 16 pecks of wheat; 16 pecks of barley malt; 32 pecks of
oaten malt.


¶467] David son of John Roa[725](javascript:footNote('E580000-001/note725.html')) tenant of Ballygrenan 1 quarter, parcel of the toghe of Gortculligan in the parish of Ballingarry valued yearly as aforesaid to be delivered as aforesaid, at 2*l.* 13*s.* 4*d.* in money 3 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of oaten malt.


¶468] Richard oge White is tenant of Loghill 1 quarter in the toghe of Olibane parcel of Rathkealy in the parishes of Kyllcollman Clonehagh and Rathkealie; Rereawbegg quarter in the toghe of ffarrensesseragh: in all 1½ quarters valued yearly as aforesaid, to be delivered as aforesaid, at 5*l.* 6*s.* 8*d.* in money; 4 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶469] Richard Rydall is tenant of Rahennaghan 1 quarter in the parish of Rathekealy in the toghe of Oliban; Kerowbegredealigg 20 acres in the parish of Rathekealie and parcel of the toghe of ffarrensesseragh: in all 1 quarter 20 acres valued yearly as aforesaid, to be {MS folio 21d} delivered as aforesaid, at 4*l.* 6*s.* 8*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten.


¶470] Morris fitz Edmond Hubbard is tenant[726](javascript:footNote('E580000-001/note726.html')) Rathgealy 2 quarters in the parish and toghe of Olyban; the castle of Rathgealie. 1½ quarters and 30 acres lying in the parish of Rathekealy and Toghe of Nantenan: in all 3½ quarters 30 acres, valued yearly as aforesaid, to be delivered as aforesaid at 11*l.* 10*s.* in money; 11 cows; 14 pecks of wheat; 14 pecks of barley malt; 28 pecks of oaten malt.


¶471] Henry fitzJames is tenant of Gortnecrehie 2 quarters of sterile land in the toghe of Olibane in the parish of Kyllcollman valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* in money; 4 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.




---

p.166


¶472] Gerald fitzWilliams of Clonecreagh holds Ballyhahill 1 quarter in the toghe of Olybane; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 3*s.* 4*d.* in money; 2 cows; 3 pecks of wheat; 3 pecks of barley malt; 6 pecks of oaten malt.


¶473] Thomas mcRuddery otherwise called the knight of the valley attainted lately held the following parcels which on his attainder {MS folio 22}. being hereditaments of the Earl of Desmond came to his hands and on the attainder of said Earl escheated to the Queen, viz. Croghnomoregezagh 2½ quarters; Clohokotrideboy 1½ quarters; Ballyngowie 1 quarter; Lysnemokie 1 quarter; Ballyoghughlane 1 quarter and Ballyaducke 1 quarter; all containing 8 quarters situate in the toghe and parish of Croughe and valued as aforesaid, to be delivered as aforesaid at 13*l.* 6*s.* 8*d.* in money; 16 cows; 32 pecks of wheat; 32 pecks of barley malt; 64 pecks of oaten malt.


¶474] Peter[727](javascript:footNote('E580000-001/note727.html')) Purcell is tenant of the following parcels in the toghe and parish of Croughe viz Oldecourt 1 quarter 20 acres; Great Garrocloen 30 acres; Little Garrocloen 30 acres; Ballyoline 1 quarter; Garbally 1 quarter; Ballygassane 60 acres; Ballywollen ½ quarter; in all 5 quarters 20 acres valued yearly as aforesaid, to be delivered as aforesaid 15*l.* in money; 15 cows; 20 pecks of wheat; 20 pecks of barley malt, and 40 pecks of oatenmalt.


¶475] Maurice mcEdmonde Sarsfell held divers lands in the toghe and parish of Croughe viz. Omagan containing a castle and 1½ quarters; Omaganbegg 60 acres; Garran ½ quarter; Ballynemukhaf ½ quarter; in all 3 quarters 20 acres, valued yearly as aforesaid, to be delivered as aforesaid, at 9*l.* 13*s.* 4*d.* in money; 9 cows; 12 pecks of wheat; 12 pecks of barley malt; 24 pecks of oaten malt.


¶476] {MS folio 22d}Mahowne boye mcTerrelagh mcDonogho is tenant of a small parcel called Ballynvearig 20 acres of good land in the parish and toghe of Nantenan valued as aforesaid to be delivered as aforesaid at 1*l.* 13*s.* 4*d.* in money.


¶477] Terrelagh mcBrian is tenant of Curroughhien 1 1/3 quarters in the toghe and parish of Nantenan valued as aforesaid to be delivered as aforesaid at 4*l.* 17*s.* 9*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶478] Brian mcDonoghoo of Dirrey is tenant of Dirry 1 1/3 quarters in the toghe and parish of Nantenan: divers parcels in the toghe of Meaghan and parish of Castellnoa viz. Ballynenaughte, Ballynaberne, Clonemore and Gortnaseuf 1 quarter; Astaregh 1 quarter and Lisnebranagh ½ quarter: in all 3 5/6 quarters valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* 15*s.* 6½*d.* in money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶479] William Oge Englande is tenant of Ballyvokooke in the Toghe and parish of Nantenan ½ quarter: valued as aforesaid to be delivered as aforesaid, at 2*l.* in money and 1 cow.


¶480] {MS folio 23}Maurice Lee physician (medicus) is tenant of Ardgoolemore 2 quarters in the toghe and parish of Nantenan
valued yearly as aforesaid to be delivered as aforesaid at 3*l.* 6*s.* 8*d.* in money; 5 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶481] Richard Wale is tenant of Cloughtread 2 quarters in the toghe and parish aforesaid, valued as aforesaid yearly, to be delivered as aforesaid, at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶482] Thomas England is tenant of Englandstown 1½ quarters with a castle in the parish and toghe of Asketon; and Kielmore ½ quarter: in all 2 quarters valued as aforesaid, to be delivered as aforesaid, at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶483] Moriertaughe mcMoroghoo mcShehy is tenant there of Courtbrowning alias Brownstown with a castle there, Cloynemore, Clany Bowghala[728](javascript:footNote('E580000-001/note728.html')) and Knockenaskeagh, in all 2½ quarters valued yearly as aforesaid, to be delivered as aforesaid, at 4*l.* 13*s.* 4*d.* in money; 6 cows; 16 pecks of wheat; 16 pecks of barley malt; 32 pecks of oaten malt.




---

p.167


¶484] Richard Nashe is tenant there of a moiety of the castle and land of Ballynashigg and {MS folio 23d} Shanrudery; and of the other moiety which was in mortgage to the late earl of Desmond: containing 2 quarters valued yearly as aforesaid, to be delivered as aforesaid at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶485] Thomas mcMorrice Person, is tenant of Gortshieghan ½ quarter in the parish and toghe aforesaid; valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* 13*s.* 4*d.*


¶486] Downe Nashe is tenant of Cuillbane 20 acres in the parish and toghe aforesaid; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.*


¶487] Konoghor mcShehy holds Raghnagorrogho ½ quarter and more, in the parish of Kyllvradran and half toghe of Drynan; valued as aforesaid, to be delivered as aforesaid at 2*l.*


¶488] The occupier[729](javascript:footNote('E580000-001/note729.html')) Arlomande which is situate in the parish of Kyllvradran and half toghe of Drynan and contains 2 parts of a quarter divided into 3 parts amounting to 53 acres of sterile land It is valued yearly as aforesaid to be delivered yearly as aforesaid at 13*s.* 4*d.* in money; 1 cow.


¶489] {MS folio 24}Garrett Roe is tenant of Cultomyn 1 quarter of sterile land in the half toghe and parish of Drynan; valued yearly as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money; 2 cows.


¶490] Knoughour O'Connowe is tenant of Ballynverneligg 1/3 quarter, Lysmaken 1/3 quarter: in all ½ quarter and 13 acres in the parish and toghe of Donmoylan valued as aforesaid, to be delivered as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶491] John mcGlanky is tenant of Ballyrobert lying in 2 parcels in the toghe of Donmoylin and parish of Ballyrobert, one called Cloneclare 1 quarter and the other Bwolymoore 1 quarter: in all 2 quarters valued yearly as aforesaid to be delivered as aforesaid, at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶492] Morris mcShane Wale is tenant of Ballymiskey ½ quarter in Clonehagh parish of Rathekealy and toghe of ffarrensesseragh; Liscorden 1 quarter in the parish of Raronan {MS folio 24d} and toghe of Meaghan; in all 1½ quarters valued yearly as aforesaid, to be delivered as aforesaid, at 3*l.* 6*s.* 8*d.* in money; 4 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶493] David oge mcDavye Hubberd is tenant of Ballyroben 1/3 quarter in the parish of Castellnoa and toghe of ffarrensesseragh; valued yearly as aforesaid, to be delivered as aforesaid at 1*l.* 13*s.* 4*d.*


¶494] Richard Lyston of Lystonough is tenant of Skahanough 1 quarter in the parish of Kyllskannell in the toghe of ffarrensesseragh; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶495] Knoughour begge mcKeigh holds BallymcKery 1 quarter in the parish of Raronan and toghe of Meaghan on the mountain of Slelogher; valued yearly as aforesaid, to be rendered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶496] Edward mcMorris Hubbert holds the 4 following parcels viz. Ballyheilogh 1 quarter, Raronan 1 quarter, Ballygowan 1 quarter, Canmoy 1 quarter; and ½ quarter called Ballyngwirig in the parish and toghe of Croughe: {MS folio 25} in all 4½ quarters lying on the great mountain of Slelogher, valued yearly as aforesaid, to be delivered as aforesaid, at 3*l.* 13*s.* 4*d.* in money; and 8 cows.


¶497] Garrett mc Morice Hubbert is tenant of Ballywogane 1 quarter and Carroughblough 1 quarter in the parish of Raronan and toghe of Meaghan, containing in alt 2 quarters valued yearly as aforesaid, to be delivered as aforesaid, at 3*l.* 6*s.* 8*d.* in money; 
4 cows; 8 pecks of wheat; 8 peeks of barley malt; 16 pecks of oaten malt.




---

p.168


¶498] John OConnowe is tenant of Carroclas 1 quarter in the toghe of Meaghan and parish of Castellnoa alias Newcastell; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶499] Morgogho mc Edmonde oge is tenant of Ardnecrogh[730](javascript:footNote('E580000-001/note730.html')) 1 quarter and Garreduff 1 quarter; in the parish of Monoghadare in the toghe of Gortcoyth: 2 quarters valued yearly as aforesaid, to be delivered as aforesaid, at 3l. 6*s.* 8*d.* in money; 4 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of oaten malt.


¶500] Donald mcNeale holds Doacatten ½ quarter in the parish and toghe aforesaid, valued yearly as aforesaid, and payable as aforesaid at 1*l.*


¶501] {MS folio 25d} Sum total of the quarters, yearly value reserved in money and provisions to be paid and delivered as aforesaid viz.


153 quarters 16 acres;
  

354*l.* 6*s.* 2*d.* in money;
  

385 cows;
  

533 pecks of wheat;
  

533 pecks of barley malt;
  

1066 pecks of oaten malt
  
.


Memorandum [731](javascript:footNote('E580000-001/note731.html')) the 153 quarters lying within the 16 canthreds or toghes aforesaid are computed by said commissioners at the rate of 80 acres per quarter, Irish measure. In a district of Connello the measure is as follows: every acre contains 160 poles or perches: every pole or perch contains 16 ells (cubitos) and 16 inches pollices making 25 feet 4 inches.


English measure is computed at 16½ feet to the perch and Irish measure at 21 feet to the perch. A quarter of 80 acres arable land in Connello measure is therefore equal to 116a. 1 r. 27½ p. Irish measure, and 188a. 2r. 13p. English measure: also a like quantity of meadows, pastures, feedings, bogs, common underwoods and waste is included with the arable land but not computed in the acres.


Hence when the arable and other lands are all jointly enumerated every quarter as aforesaid contains 160 acres Connello measure, 232a. 3r. 15p. Irish measure, and 377a. 0r. 26p. English measure.


Arable land.


80 Connello acres of 25f. 4in. to the perch
  
 
= 116a. 1r. 27½p. Irish measure @ 21 feet per perch.
  

= 188a. 2r. 13p. English statute measure @ 16½ feet per perch.


Arable land &c.


Computing the meadows, pastures feedings bogs commons underwood waste &c thrown in with the arable land


80 Connello acres arable land &c @ 25f. 4in. per perch actually represent


232a 3r. 15p. Irish measure @ 21 feet per perch.
  

377a. 0r. 26p. English statute measure @ 16½ feet per perch.


¶502] *Lands and possessions formerly parcels of the 16 canthreds or toghes lying within the country of Connelo which the said late Earl took back into his hands and let at his will.*


{MS folio 26}Divers other castles, vills villates lands tenements and hereditaments, late parcels of the 16 canthreds or toghes of Connello aforesaid which were in the hands of said late Earl at his will viz.


The villate of Ballynaughtie 2 quarters of like measure; Shannacloen ½ quarter; Ballynagillecrogh ½ quarter lying in the parish of Brewery and togh of Bruerie; which remises containing 3 quarters 



---

p.169




are valued by said commissioners as well in English lawful money as in victuals and provisions to be paid and delivered as follows viz for every of said 3 quarters 1*l.* 13*s.* 4*d.* in money payable at the feasts of Easter and Michaelmas yearly by equal portions; and the following provisions viz 2 good fat cows to be delivered yearly without 8 miles of the lands between the feasts of Michaelmas and
All Saints following; 4 pecks of wheat, 4 pecks of barley malt, and 8 pecks of oaten malt, to be delivered yearly between 15 Nov. and 25 Mar. following, and if the victuals and provisions aforesaid are not delivered as specified aforesaid (the election of which will be in the hand of the Queen by her Deputy &c.) then they shall be valued
in lawful English money as follows every cow 13*s.* 4*d.*, every peck of wheat containing 16 gallons (lagen') 3*s.* 4*d.*, every peck of barley malt containing 20 gallons 3*s.* 4*d.*, and every peck of oaten malt of same measure 1*s.* 8*d*: and so the premises are worth yearly 5*l.* in
money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶503] {MS folio 26d}Shortequarter alias Carrowe Gayre containing 1 quarter like measure, and lying in the parish of Ballycastellane in the toghe of Clonehenery; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of oaten malt.


¶504] The knightes Street containing 3½ quarters in the parish of Ballingarry parcel of the canthred or toghe of Gortculligan and known by the following names viz. Ballyelane 1 quarter, Ballynasaig 1 quarter, Ballymorrogha ½ quarter, ffarrintanklin ½ quarter, ffarrintegin Sradenruddery alias Shonruddery and Mullenruddery 
½ quarter; in all with gardens and other premises 3½ quarters; there is there a watermill now waste and very ruinous, called Sergins[732](javascript:footNote('E580000-001/note732.html')) myll worth with the fishery to it belonging 13*s.* 4*d.* And there is there a quarry for mill stones on the top of the mountain called Knockfearyny[733](javascript:footNote('E580000-001/note733.html')) in the parish of Ballingarry worth yearly 10*s.* And so all the premises are valued yearly as aforesaid, to be delivered as aforesaid at 8*l.* in money; 7 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


¶505] Bolloglasse 1 quarter 26 acres in the parish of Nantenan late parcel of the canthred or toghe of Nantenan, valued yearly as aforesaid to be delivered as aforesaid, at 2*l.* 4*s.* 5*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of 
oaten malt.


¶506] {MS folio 27}The vill or place of Moye in irrla alias Moyana 4 quarters late parcel of the toghe or canthred of Asketon in the parish of Asketon with its appurtenances; and with other parcels called Ballynakylly 20 acres, Ballytamen and Clonilogha ½ quarter and 20 acres, and Ballymore 2 quarters all lying in Asketon parish: these premises are not valued here because they are charged elsewhere in this book in the manor of Asketon and here are set down at nothing.


¶507] The entire half toghe or cantred of Tawnaghe in the parish of Mohawnagh which belong as well to the manor and castle of Mollyanagh otherwise called Meane (parcel of the possession of the said late Earl) as to Thomas Cham attainted. These lands are therefore valued among the lands of the manor of Mollyanagh alias Meane, and the lands of Thomas Cham, elsewhere in this book and so are here set down as nothing.


¶508] The villates or lands of Corgrag and ffoynes Lyeth and Ballylowras parcels of the possessions of said late Earl lying within the toghe of Donmoylin containing 6 quarters are charged in this book within the manor of Shaned and so are here set down at nothing.


¶509] The manor and ruinous castle of Clonoguillen in the parish of Kyllskannell late parcel of the toghe or canthred of ffarrensesseragh, 3 like quarters of arable land; Lyscarrough ½ quarter, and Clonebrowne ½ quarter both in said parish and toghe; Kearroghbelogh ½ quarter lying in the parish of Rathkealye in said toghe of ffarrensesseragh; another parcel called Lysnesallagh 1½ quarters lying in the parish of Granshagh (Grange). All which premises containing 6 quarters are valued by the Commissioners as aforesaid, to be delivered as aforesaid, at 10*l.* in money; 12 cows; 24 pecks of wheat; 24 pecks of barley malt; 48 pecks of oaten malt.




---

p.170


¶510] {MS folio 27d}Divers parcels of land lying near and upon the mountain of Slewlogher in the parish of Raronan and country of Connelo, viz:— Templeacle and Cuilnahila 1 quarter, Corbally and Lyshroto 1 quarter, and Glanycorte with its appurtenances viz., Ahadnan, Gornagross, Curragh Duff, Shrone Meane, and Munegorrum containing 1 quarter: these premises were lately parcel of the toghe or cantred of Meaghan, contain in all 3 quarters and are valued yearly as aforesaid, to be delivered aforesaid, at 3*l.* 6*s.* 8*d.* in money; and 4 cows.


¶511] A ruinous castle called Granshagh (Grange) in the parish of Granshagh late parcel of the half toghe of Ogallyhowre, to which castle 3 quarters of land adjoin and belong. They are valued as aforesaid yearly, to be delivered as aforesaid at 5*l.* in money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of oaten malt.


Sum total of the quarters and their yearly rents reserved, payable, and to be delivered as aforesaid viz.


35*l.* 4*s.* 5*d.* in money; 40 cows;
  

68 pecks of wheat;
  

68 pecks of barley malt;
  
 
136 pecks of oaten malt.


¶512] *Lands lying in said Country of Connelo co. Limerick, outside the said 16 cauthreds which the late Earl similarly let at his will.*


{MS folio 28}The place where a borough alias "a Burrowghe towne" called Rathkeale lately was. It was parcel of the toghe of Olyban and situated in a locality most delightful and fertile near the river Dyle. Formerly there were 10 burgesses in the borough to whom belonged many burgages gardens, yards, orchards and very fruitful lands containing by estimation 3 quarters for which they were wont to pay yearly to said late Earl and his predecessors 2*l.* 10*s.* for head or free rent. This borough is now totally wasted and the premises are valued yearly as aforesaid, to be delivered as aforesaid, at 8*l.* in money; 9 cows; 20 pecks of wheat; 20 pecks of barley malt; 40 pecks of oaten malt.


¶513] The Court baron held within Rathkealie and Croughe aforesaid for the 16 canthreds aforesaid; a court "of Pipowders" with the perquisites thereof viz. amercements for bloodsheds affrays and other abuses and misdemeanours committed contrary to the (ordinances for the better state of the country. These are valued, yearly as aforesaid to be delivered as aforesaid, at 3*l.* 6*s.* 8*d.*


¶514] Two fairs belonging to said Earl held yearly within said borough viz for 2 days, on the first and second day of the B.V.M. in Autumn. The profits and customs reserved from same to the Earl were as follows:— for every cow or Garron coming into and being in the fair 4*d.* halface; from every barrel of wine or beer and whiskey (aqua vita[734](javascript:footNote('E580000-001/note734.html'))) 3 quarts, the tenth part of all merchandize sold there 
unless the seller hired a shop or paid for some other place where he sold merchandize and goods. These are valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.*


¶515] {MS folio 28d}The old castle of Dromarde and 1 quarter of land lying in the toghe of Olybane; the site of a castle called Matriscoorte and Courtmatraske and 4½ quarters lying without the 16 toghes aforesaid lately acquired by said Earl of Desmond from Nicholas ffitzWilliams: to these castles adjoin and belong divers parcels in the parish of Rathekealie and country of Connelo: viz Dromard, Clonnemore, Gortneragh, Gortnanyrum, Mulamoore, Mulabegg, Rathigarvan, Gortestywarde, Gortnagorrow; Gortkrea and Monynystyward. They contain in all 5½ quarters valued yearly as aforesaid, to be delivered as aforesaid, at 15*l.* in money; 16 cows; 22 pecks of wheat; 22 pecks of barley malt; and 44 pecks of oaten malt.


¶516] The island called Aghenasse alias Athenas, without the 16 toghes aforesaid, formerly in the possession of Teig Gidowne alias ODonagh and late in the occupation of Terrelagh mcMoriertagh which came to the late Earl by escheat. It is situate in the parish of Monastery Negelagh in divers parcels following viz Keaharrowe na Killy 1 quarter, ffana moore and Grenan 1 quarter; Aghenasse 



---

p.171




and Powell ynierla 1 quarter: containing in all 3 quarters valued yearly as aforesaid, to be delivered as aforesaid, at 4*l.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; and 16 pecks of oaten malt.


¶517] Certain other parcels lying without the said 16 toghes viz. portion in the parish of Monoghadare called Glannowhim containing 120 acres beyond the 7 quarters also called Glannowhim charged in the half toghes of Gortcoith and Killidie; Beabus 60 acres; Glanenoore 40 acres; Clonesherebegg 60 acres in the parish of Clonesheremore; a portion in said parish called Rower containing 60 acres; a portion in Laugill parish called Kappagh Clanrery containing 60 acres; which parcels contain in toto of arable land meadow, pasture, bog underwoods and other waste 5 quarters of good land which are valued yearly as aforesaid to be delivered as aforesaid, at 13*l.* 6*s.* 8*d.* in money; 15 cows; 20 pecks of wheat; 20 pecks of barley malt; and 40 pecks of oaten malt.


¶518] {MS folio 29} Divers farms and rents issuing from the burgages of Ardagh viz. lands of the Bishop of Limerick in the villate of Ardaghe 2*l.* 8*s.*; land of said late Earl called Ballydusgum alias Bullugh[735](javascript:footNote('E580000-001/note735.html')) in the parish of Ardagh 16*s.*; the tenement of Robert Lovell 2*s.*; Ardagh mill in same parish 3*l.* 6*s.* 8*d.*; Kiln and Serjeancy there 
6*s.* 8*d.* In all to be paid as aforesaid yearly 6*l.* 19*s.* 4*d.*


¶519] Killwallane manor with the villate and lands of Ballycoskerowe otherwise Ballynetredynagh late in the occupation of David Encorigge lord of Kilmore (magna silva) who rendered 10*l.* yearly for same as by the account of Gerald fitzJohn now of Lysmoore co. Cork late seneschal and Receiver of said Earl appears. Said lands containing 1 quarter are valued yearly as aforesaid, to be delivered. as aforesaid, at 2*l.* 13*s.* 4*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; 4 pecks of oaten malt.


¶520] The vill of Ballegillnecraggy with Kippagh lying near KnockePatrick taken from the information of Gerald fitzJohn aforesaid containing by estimation 2 quarters. These are valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* 13*s.* 4*d.* in money; 
3 cows; 4 pecks of wheat, 4 pecks of barley malt; 8 pecks of oaten malt.


Sum total of the quarters and yearly rent reserved there on viz


57*l.* 19*s.* 4*d.* in money;
  

52 cows;
  

78 pecks of wheat;
  

78 pecks of barley malt;
  

156 pecks of oaten malt.


{MS folio 29d blank}


¶521] *Rents of free tenants co. Limerick who held their lands of said Earl by certain services hereunder described and extended.*


{MS folio 30}Divers free lands as well within said country of Connelo as elsewhere in co. Lim. which were held of said Earl and not to be charged with rents called Shraghe and mane nor with certain impositions called coine Livery, Kernty, Kerne, Cusshrie, Cuddie, Gillygie Gillicon Bonybur &c; but they were to be charged yearly with Sorohan for wages, stipends, lodgings and victuals of the soldiers called Galloglas Kerne and horsemen, and with Mosteron in aid of said Earl for fortifications and repairs of castles and bridges, and other necessary services with horses (cabull'), Garrons, labouring men; and with a tax of all their free tenants there alias Sowth to 
raise money for payment of the Earl's debts and other necessaries as often as he required it: likewise refections and victuals called Repaste and Away whenever it pleased the Earl to journey through said country. These taxes refections and repasts are valued by the commissioners in rents and reservations to be rendered yearly at the following rate per quarter: formerly they amounted to 5*l.* per quarter at least. However on account of the wasted condition[736](javascript:footNote('E580000-001/note736.html')) the region the quarters following are valued by the commissioners for all the taxes and services aforesaid and all other charges (except suit of court and like services) as follows, yearly, for every quarter as aforesaid according to the quantity of quarters, viz.[737](javascript:footNote('E580000-001/note737.html'))




---

p.172


¶522] The country called Pobulbrien late of the possessions of Bryan Obrien otherwise called Bryan duff of Carryogruett alias Carrigoguynyll in the parish of Moronet to whom and to his heirs male the Queen by letters patent of Feb. a.r..xxvij granted and restored said country of Pobulbryan to be held in capite by knight service yielding to the Queen and her successors a rent of 5*l.* English money formerly payable to said Earl of Desmond and also an increase of rent of 2*s.* reserved by the lord Deputy; services of Bryan and his heirs called Rysings owte with 3 horsemen and 3 footmen well armed whenever it shall be pleasing to the lord Deputy: Hence there is payable 5*l.* 2*s.* beyond these services.


¶523] {MS folio 30d}[738](javascript:footNote('E580000-001/note738.html')) Onownan is free tenant of Castle- [*...*][739](javascript:footNote('E580000-001/note739.html')) 
(Castellum de Lyssine) in the country of Muskerie Onownan and the lands to the castle belonging for which he was wont to pay yearly as aforesaid to the late Earl of Desmond, 5*l.*


¶524] [*...*][740](javascript:footNote('E580000-001/note740.html')) is free tenant of the country of Onhy OMullryan for which he was wont to pay yearly to said Earl as aforesaid 2*l.* 13*s.* 4*d.*


¶525] Rory mcShehy is tenant of Tirwanagh ½ quarter in the parish of Ballingarry; Ballyrallagh ½ quarter in the parish of Graunshagh; Reyne 1 quarter in the parish of Kyllskannell; 60 acres in the parish of Ranasier ffenne; the vills villates and lands of Clowhere, Clowhine, Ballycowlinan, Donberen, Cloughnewroughtagh, Ballchewell, Ballykevan, Tiremony, Ballybreskie, Ballyferalagh, Ballynerigy, and Ballynehallagh, containing 6 quarters:— in all 8½ quarters and 20 acres which are valued yearly by said commissioners at the rate of 6*s.* 8*d.* per quarter payable by equal portions at Easter and Michaelmas; and further for every quarter a cow large and fat to be delivered yearly within 8 miles of the lands between the feasts of Michaelmas and All Saints, and if not delivered in said manner to be valued in English money at 13*s.* 4*d.* per cow. And so the premises are worth yearly 3*l.* 8*s.* 8*d.* in money; and 8 cows.


¶526] Maurice mc Shean of Ballynusky is free tenant of Gortnegrean in the parish of Cloneshepey[741](javascript:footNote('E580000-001/note741.html')) which contains 20 acres and is valued yearly as aforesaid to be delivered as aforesaid at 10*s.*


¶527] {MS folio 31}John mcGanley of Ballyrobert is tenant of Ballyrobert, fenne Ardenneare, Shrowlane in the parish of Ballyroberte; and Ballyodurtie in the parish of Asketon. They contain four quarters and are valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 6*s.* 8*d.* in money; and 4 cows.


¶528] David oge mcDavid Hubberd is free tenant of Knockan en bodie in the parish of Cloneagh, containing 5 acres, valued yearly as aforesaid, to be delivered as aforesaid, at 2s. 6d.


¶529] Edmund oge Morryce Hubbert is tenant of 20 acres of free land called Raharmoell[742](javascript:footNote('E580000-001/note742.html')) in the parish of Raronan valued yearly as aforesaid, to be delivered as aforesaid, at 10*s.*


¶530] Edmund mcMorris oge of Omagan is free tenant of 3 acres called Gortnemokey in the parish of Crough valued yearly as aforesaid to be delivered as aforesaid at 1*s.* 6*d.*


¶531] Richard Wale mcCorish of Clohatrohed is free tenant of Knockanvadd 2 acres, and Inshebustocke 3 acres, in all 5 acres valued yearly as aforesaid to be delivered as aforesaid at 2*s.* 6*d.*


¶532] {MS folio 31d} Gerald fitzWilliams of Clonecaghe is free tenant in the parish there of 2 quarters valued yearly as aforesaid, to be delivered as aforesaid at 13*s.* 4*d.* in money; and 2 cows.


¶533] Terrelagh mc Mahownde of Shannagolo is tenant in same parish of 1 quarter of free land valued yearly as aforesaid, to be delivered as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶534] Teig mcMoriertogh is tenant of Ballynash Publeclonerery and Clanrery 1 quarter of free land; Knocknebully 1 quarter; Lysfrydie 1 quarter: in all 3 quarters lying in the parish of Laughill and valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* in money and 6 cows.




---

p.173


¶535] William mcPhillippe is free tenant of 1 carucate of land called Ballyany in the parish of Ranaseir fenn valued yearly as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money and 2 cows.


¶536] Thomas Hurly is free tenant of Ballynanty 2 carucates; valued yearly as aforesaid, to,be delivered as aforesaid, at 1*l.* 6*s.* 8*d.* in money; and 4 cows.


¶537] {MS folio 32} Edmond ffitz James Gerrott fitz James and Olyver ffitz James, brothers (germani) hold freely a small castle [743](javascript:footNote('E580000-001/note743.html')) called Tomwhilley alias Tomguylle lying near Knockepatrick and containing 3 quarters of land in the parish of Monaster Gilleath in the country of Connelo; valued yearly as aforesaid; to be delivered as aforesaid, at 2*l.* in money and 6 cows.


¶538] John Dondon holds freely the castle and vill of Ballestine containing 3 quarters; the vill of Ballynekellagh 1 quarter. He was a rebel but was pardoned on condition the Queen might dispose of his said 4 quarters which are valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 6*s.* 8*d.* in money; and 4 cows.


¶539] Edus alias Eadye Lacye of Browery was a rebel but was afterwards pardoned by the lords Justices of Ireland under the condition that the Queen by her lord Deputy &c. might dispose of his land as by the charter of 26 May a.r. xxvj appears. He is free tenant of the castle and lands of Bulligidimeaden, Ballynaryhiny, Tanckardstown, Ballynly Ballingortrew and Balleingheillrowy: all containing 3 quarters valued as aforesaid to be delivered as aforesaid, at 2*l.* in money; and 6 cows.


¶540] Thomas mc Philipe mc Edmond is free tenant of Ballyngaddy and a tenement in Kyllmallock valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶541] {MS folio 32d}David mc Philipe is free tenant of 1 carucate in Clonebryne in the parish of Atheleckagh valued as aforesaid, to be delivered as aforesaid viz at nothing here because it lies in the country of Cosmaye in the liberty of the Earl of Kyldare.


¶542] Peter Lacye of Broffe is free tenant of Leshy Cartian oge and Mulan containing 3 quarters which are valued as aforesaid, to be delivered yearly as aforesaid at nothing here for cause in last paragraph.


¶543] John Lacye fitzWilliam[744](javascript:footNote('E580000-001/note744.html')) free tenant of Donemeane, Ballyncurry, Ballenstonebegg, Ballinstonemore, Karrhowriowgh, Ballynehawe, a moiety of Uregara, Tritaersana and Ballynwolle containing in all 3 quarters 80 acres, valued as aforesaid, to be delivered as aforesaid, at 2*l.* 13*s.* 4*d.* in money; and 6 cows.


¶544] Thomas Hurly is free tenant of Knockelongie Ballincarrowny Ballenemony, and parcel of Killfrush containing in all 3 quarters valued as aforesaid, to be delivered yearly as aforesaid, at 2*l.* in money; and 6 cows.


¶545] William ne Bwoly is free tenant of Cloughviller and parcel of Rathiordan, 1 quarter, valued yearly as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶546] {MS folio 33} William mcShane [is free tenant][745](javascript:footNote('E580000-001/note745.html')) of Ballynard, with a castle there, containing a great quarter and situate in the Small county Limerick; valued yearly as aforesaid to be delivered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶547] Garrett gangagh Relly of Ballynemonymoore and Maurice fitz Garrett Relly having a third part of Ballenemonymoore; and Mathew mcTeig and Gillduff mcTeig having a fourth part of said land:— valued as aforesaid, to be delivered yearly as aforesaid; at 10*s.* in money.


¶548] Garrett fitz Thomas is free tenant of Ballynvryny, Ballygibben, certain lands near Kyllmallock, Clankaugh, a burgage in the vill of Ardagh and Ballynskaly: valued yearly as aforesaid to be delivered as aforesaid at 1*l.* 13*s.* 4*d.* in money; and 2 cows.




---

p.174


¶549] Derby mc Shane mc Shehie is free tenant of Carybony alias Garrynebonagh, ½ quarter. valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶550] Maurice fitz Edmond mc Gibbon is free tenant of Clangibbon ‘Clangibbon is a great country, not yet surveyed, and therefore set down here as nought in value’.


¶551] {MS folio 33d} James Foxe late Serjeant of Small County is free tenant of Ballyadam, Ballynemory, Ballytanckarde, Garriskullibine, Ballynchallowe and Elton; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* in money; and 3 cows:— beyond 7*l.* and 3 cows charged in the manor of Awny for his other lands as well free as chargeable.


¶552] John mc William mc Qworowgh is free tenant of certain lands called Engworough in the parish of the "White Abby of Adare" in the country of Kenryherrow, lying for 3 quarters; valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* in money; and 3 cows.


¶553] Gerald mc Thomas is free tenant of the castle of Pallace in Kenryherrowe, containing 4 carucates valued yearly as aforesaid, to be delivered as aforesaid, at 1*l.* 6*s.* 8*d.* in money; and 4 cows.


¶554] Pierce Purcell is free tenant of the castle and land of Ballycullen, 4½ quarters, in the parish of Kyldyma and country of Kenryherrowe; valued yearly as aforesaid to be delivered as aforesaid at 1*l.* 16*s.* 8*d.* in money; and 4 cows.


¶555] William Cham mcRichard mcWilliam is free tenant of the castle and land of Beolane, 2 quarters, in the parish of Ardcaughe[746](javascript:footNote('E580000-001/note746.html')) in said country of Kenryherrowe: valued yearly {MS folio 34} as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶556] Garrett mcGibbon mcRaynode is free tenant of land called Courte mcRaynolde and Eddenreloghan, and two other vills in the parish of Kyldyma in said country; all containing 2 quarters valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* in money; and 3 cows.


¶557] Edmond oge mcEdmonde mc Garrett and Edmond oge mcMorrice [free tenants][747](javascript:footNote('E580000-001/note747.html')) of Killysherowe in the parish of Ardcaughe [748](javascript:footNote('E580000-001/note748.html')) in the country of Kenryherrow 1 quarter; valued yearly as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶558] David Hubbert alias Morrice mcDavye is free tenant of Glannegowine ½ quarter; valued as aforesaid, to be delivered yearly as aforesaid, at nothing here because it is charged within the canthred or toghe of Meaghan.


¶559] Rickard mc Ullig holds freely a moiety of Cowllyhenane: set down as of no value here because it is charged within the 120 quarters of the Country of Clanwilliam.


¶560] William oge Hurly of Lickadowne is free tenant of Boherentead, Ballenevrancke and Lickadowne in toghe Orely which Sir William Drewry knight held for a term of years before said William oge entered into rebellion as is said. {MS folio 34d} And divers other tenants whose names are unknown to the commissioners held freely certain other vills villates and lands parcels of the toghe of Orely amounting in all with the lands of said William oge to 7 quarters. These lands were charged by said late Earl with wages and lodgings (hospitium) for 40 horsemen, 80 "cheife" horses and hackneys, 40 boys and 100 galloglasses, for the space of two days and two nights, fully, twice year instead of these services the lands are assessed by the Commissioners as aforesaid, to be delivered yearly as aforesaid, at 5*l.* in money; and 12 cows.


¶561] The Burgesses of the town of Ardagh were in rebellion and were then seised as of inheritance of certain free lands, and chargeable lands in Ardagh (except the rent due thereout to the Bishop of Limerick). They are set down as of no value here because they are not yet surveyed.


¶562] William mcEdmonde Oge mcShehy is free tenant of Ballinmollin alias Mylltowne, 15 acres, life of the possessions of Philip mcGibbon; valued as aforesaid, to be delivered yearly as aforesaid, at 5*s.*




---

p.175


¶563] Mahowne mcDa is free tenant of Kyllidee, Kyllmeadee and Athebean: set down of no value here because charged already within the toghe of Clonenery.


¶564] Owin mc Edmonde is free tenant of Kyllvolleben: set down of no value here because he was attainted and it is charged within the attainted lands.


¶565] Thomas mc Hewes is free tenant of Kyllmony in vanne: set down of no value here because it is already charged in the toghe of Clonenery.


¶566] {MS folio 35} Gerald mcThomas is free tenant of the castle orchard and the moiety of vill of Rathnesier, 60 acres; valued yearly as aforesaid, to be delivered as aforesaid, at 1*s.* 8*d.* in money; and 1 cow.


¶567] Thomas mcMoriertogh is free tenant of Clonecrenagh 1 quarter; valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8*d.* in money and 1 cow.


¶568] Clanmohowne is free tenant of Ballynvoer 1 quarter in the parish of Asketon; valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶569] Gerald fitz Morris is free tenant of Morenan and Ballynegowly, 1½ quarters. They are valued here because said Gerald is said to have died in rebellion, at the rate of 2*l.* the quarter in money, and in cows, to be paid and delivered as aforesaid viz. 1 l*l.* in money; and 3 cows.


¶570] Walter fitz William otherwise called Walter Bane is free tenant of Newcastle near Limerick, 1 quarter; valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶571] {MS folio 35d} Richard fitz Thomas alias Richarde Ganco is free tenant of Dromhere 1½ quarters; valued yearly as aforesaid; to be delivered as aforesaid, at 18*s.* 4*d.* in money; and 2 cows.


¶572] Guille duff mcDonell Ganco mc Bryan Boye, who died without heir as is said, was free tenant of Castles vills and lands in Corkamoore, in the country of Pobulbrian viz:— the castle and vill of Ballyeghtregh; the castle of Barnarde with the land there; the castle and vill of Ballybegge; the castle and vill of Kyllnekally; the castle and vill of Balleaghera; the castle and vill of Knockrunyn; the castle and vill of Myelleg; the castle and vil of Breskagh; the castle and land of ffenewre; the castle and vill of Carduff; and the castle and vill of Ballybrowne: they contain in all 24 quarters, valued yearly as aforesaid, to be delivered as aforesaid, at 30*l.* in money; and 75 cows.


¶573] Edmund mcDavid mcRuddery is free tenant of the castle and vill of Ballygollyghan alias Ballygleaghan 2 carucates; the castle and vill of Kyllwirry 1 carucate; and Greanard 1 carucate; all lying in the country of Kenry, containing in toto 4 carucates, and valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* 13*s.* 4*d.* in money; and 8 cows.


¶574] {MS folio 36} Edmund mcDavye and Maurice Ykhea are free tenants of the vill and land of Shaneballymore in said country of Kenrye, 2 carucates; valued yearly as aforesaid, to be delivered as aforesaid at 13*s.* 4*d.* in money; and 2 cows.


¶575] John fitz Morrice and Thomas ny Bernize are free tenants of the vill of Ballynemony 1 carucate, in Kenrye aforesaid, valued yearly as aforesaid to be delivered as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.


¶576] Maurice Ikhea is free tenant of Dirgirth ½ carucate in Kenry aforesaid; valued yearly as aforesaid, to be delivered as aforesaid, at 10*s.* in money.


¶577] Edmund oge and David mcPhilipe are free tenants of a moiety of the vill of Ballyno alias Newtowne, 1 carucate; valued as aforesaid at 6*s.* 8*d.* in money; and 1 cow.


¶578] John oge mcShane is free tenant of Ballychahane 1 carucate in Kenry aforesaid; valued yearly as aforesaid, to be delivered as aforesaid, at 16*s.* 8*d.* in money; and 1 cow.


¶579] {MS folio 36d}Thomas mcRichard is free tenant of the vill of Ballyneknockvane 1 carucate in Kenry aforesaid; valued as aforesaid, to be delivered yearly as aforesaid, at 6*s.* 8d. in money; and 1 cow.




---

p.176


¶580] Teig ne Dermodo me[749](javascript:footNote('E580000-001/note749.html')) Tohogh is free tenant of the castle and vill of Tohoride, 2 quarters in the parish of Kyllcurnan and country of Kenry aforesaid; valued yearly as aforesaid, to be delivered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶581] Donogho mc Teig ne Currough is free tenant of the castle and vill of Hurrough alias ne Currough, 2 quarters, in the parish of Kylkurnan and country of Kenry; valued as aforesaid, to be delivered yearly as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶582] Terrelagh mantagh and Terrelagh Clanmahownagh of same family (consanguinitas) hold freely the castle and vill of Ballynbohir, 1 quarter, in the parish of Egalusorisse, in the great Country[750](javascript:footNote('E580000-001/note750.html')) of Limerick; valued as aforesaid, to be delivered as aforesaid at 6*s.* 8*d.* in money; and 1 cow.


¶583] Thomas mcEdmond mcRuddery is free tenant of Clooran, 1 quarter, in the parish of Kyldyma and Country of Kenrycherrowe; valued as aforesaid to be delivered as aforesaid yearly, at 6*s.* 8*d.* 
in money; and 1 cow.


¶584] {MS folio 37}William Bourck of the Country of Clanwilliam was wont to supply from said Country, for the defence of said Earl of Desmond and said country 100 arsoldiers called "Galloglas" yearly for the space of a quarter of a year, as well with stipends and wages as with victuals and lodgings; and furthermore 40 horsemen with horses, "ledd horse", and horseboys for 2 complete days every year: these in the time of the late Earl, before his rebellion are estimated at the sum of 366*l.* 13*s.* 4*d.* yearly.


The said country is about 10 miles in length as well in breadth and contains, besides the lands and vills of the other free tenants therein, the following castles and vitiates belonging to said William Bourck viz:[751](javascript:footNote('E580000-001/note751.html'))— the castle and vill of Ekonnell in the parish of Nestermoy; the castle and vill of Callatroo; the castle and vill of Castellnoo; the vill of Castellane Trylan; the castle and vill of Bellashemon; the castle and vill of Kyllonnan; the castle and vill of Knockwrsometa; the castle and vill of Lysmollan; the castle and vill of Ballyvarra; the castle and vill of Ballynogerd; the castle and vill of Ballywilliam; the castle and vill of Ballynecarreg; the castle and vill of Loddenmoore; the two castles and vills of Carrelles:[752](javascript:footNote('E580000-001/note752.html')) the two castles and vills of Grenans in the parish of Corkenlish; the castle and vill of Dromekyn; the castle and vill of Karkonroeffie; the castle and vill of Karrenlishie; the castle and vill of Knockedanna in the parish of Carrynlisshey; the castle and vill of Knockeneff there; the castle and vill of Kyllkollen; the castle and vill of Ballenwollen; the castle and vill of Shahar; the castle and vill of Cargeffarson; the castle and vill of Colleheynon; the castle and vill of Ballynbrowne and the Castle and vill of Castelknocke in the parish of Corkenlish which belong to Richard Bourck with others 
within said country whose names are unknown to the commissioners amounting in all by estimation to 120 quarters of land.


These by reason of the wasted condition of the country are valued yearly by said commissioners in sterling English money and cows to be paid and delivered as aforesaid and in the manner before specified only at the rate of 1*l.* 10*s.* per quarter: that is 120 quarters, 60*l.* in money; and 180 cows.


¶585] {MS folio 37d}Dermode mcShee and William mcShee are free tenants of the castle and vill of Ballydonon 1 quarter, valued as aforesaid, to be delivered yearly as aforesaid at 6*s.* 8*d.* in money; and 1 cow.


¶586] Garrett mcThomas is free tenant of the castle and vill of Knockeloyney; nothing set down because it is not surveyed.


¶587] Maurice mcShane [is free tenant][753](javascript:footNote('E580000-001/note753.html')) of the castle and vill of Ballynahard, 1 quarter, valued as aforesaid, to be delivered yearly as aforesaid, at 16*s.* 8*d.* in money; and 1 cow.


¶588] William ne Boyle is free tenani of the castle and vill of Rahin, 1 quarter; valued yearly as aforesaid, to be delivered as aforesaid, at 6*s.* 8*d.* in money; and 1 cow.




---

p.177


¶589] Richard mcThomas Roche [is free tenant][754](javascript:footNote('E580000-001/note754.html')) for ½ quarter of land called Lysnevarry; valued yearly as aforesaid, to be delivered
as aforesaid, at 16*s.* 8*d.* in money; and 1 cow.


¶590] {MS folio 38}George Roche of Lymerick for Newcastell and a carucate of land in Kylcowben, valued yearly at 1*l.* English.


¶591] Domynicke White for a carucate of land in Caheryne Glevoyre valued yearly in like money at 1*l.*


¶592] Morogho mcDermott Roe for a carucate of land in Ballynharrowe valued yearly in like money at 1*l.*


¶593] Mahowne Merigath [755](javascript:footNote('E580000-001/note755.html')) for 2 carucates of land in Kylnkally, 
Ballyeghtera and Ballybegg in Cosmaye valued yearly in like money at 2*l.*


¶594] Connor Ballowgh for ½ carucate of land in Clarenny valued yearly in ii a money at 10*s.*


¶595] Donnally ffaghy for 1/4 carucate of land in Maligg valued yearly in like money at 5*s.*


¶596] Tirretagh mcConnoghor for 1/4 carucate of land in Craggbegg valued yearly in like money at 5*s.*


¶597] {MS folio 38d} Tirrelagh oge for 1 ploweland 1/4 carucate of land in Enaghtroche and Elannaware valued yearly in like money payable as aforesaid at 1*l.* 5*s.*


¶598] Kayle Keaghe mcShehie for ½ carucate of land in[756](javascript:footNote('E580000-001/note756.html')) called Garreart in Cosklea[757](javascript:footNote('E580000-001/note757.html')) valued yearly in like money at 10*s.*


¶599] John Olagan of Ardepatrick for ½ carucate of land called Ballenwaste valued yearly in like money at 10*s.*


¶600] John Hurly, Gerald Sr David and Maurice fitz David for 5 acres 1½ carucates in Knocklongy valued yearly in like money at 1*l.* 10*s.*


¶601] Dermott Odea for ½ carucate of land in Kylderahan, 1 quarter in Lacknevantane, ½ carucate in Dromelogan, and 1/4 carucate in Boherowen all valued yearly in like money at 2*l.*


¶602] John Shynan and Giler (Egidius) ne Cassy, widow for 2 parts of a carucate of land, into 3 parts divided, in Ballymcshaneviry in Cosklea[758](javascript:footNote('E580000-001/note758.html')) valued yearly in like money at 6*s.* 8*d.*


¶603] Edmond Leo of Tollerebovoye for 1 carucate of land there and 1 carucate in Rossetemple valued yearly in like money at 2*l.*


¶604] {MS folio 39}Stephen White ffitz Walter of Lymerick, Richarde mc Ulligge and Danek mc Edmonde for 1 quarter and ½ carucate of land valued yearly in like money at 6*s.* 8*d.*


¶605] John Cassy[759](javascript:footNote('E580000-001/note759.html')) for ½ carucate of land in the Rannaghe valued yearly in like money at 10*s.*


¶606] Owin mc Clanoghe for 20 acres in Toryne and 20 acres in Grange valued yearly in like money at 10*s.*


¶607] Teig mcWilliam mcBryan for 1 carucate of land at Kerlege in Gonogh valued yearly in like money at 1*l.*


¶608] McReartagh mcBryan alias McByrne Ogonogh and William mcBryne of Laugherte for 1/4 carucate there, and ½ quarter in Monerea in Gonogh valued yearly in like money at 7*s.* 6*d.*


¶609] Donalld mcMahowne of Portany for 1/4 carucate of land there, valued yearly in like money at 5*s.*


¶610] Maurice Shicky[760](javascript:footNote('E580000-001/note760.html')) of Dune for ½ quarter in Gonoght, valued yearly in like money payable as aforesaid at 5*s.*


¶611] {MS folio 39d}Dermot mcTeig, Tirlagh mcBryan for 1/4 carucate of land in Towaghe Glonnaney valued yearly in like money at 5*s.*




---

p.178


¶612] William mcMelaghlen, and Teig mcMelaghlen for ½ carucate of land in Dune in Gonoghe valued yearly in like money at 10*s.*


¶613] Gohir Olloryne of Clone in Shynaght for ½ carucate of land valued yearly in like money at 2*s.* 6*d.*


¶614] Donoghe Glasse for 1/4 carucate of land in Knockeary valued yearly in like money at 5*s.*


¶615] John O Howrigan of Kallman[761](javascript:footNote('E580000-001/note761.html')) for 1 ½ carucates of land viz. Kallman 100 acres, Garryglasse 24 acres, Knockan in Arder and Krolelynan 23 acres and Kyllomegh 36 acres; valued yearly in like money at 1*l.*


¶616] Richard Bourck of Kaherkynlesshe for 1 carucate of land in Ballywooddecke in Kenry valued yearly in like money at 1*l.*


¶617] Walter Bowy[762](javascript:footNote('E580000-001/note762.html')) of Ballysymon for 1 carucate of land viz. Ballysymon and Garreglasse 44 acres, Ballyryan and the Shrylane 40 acres, Lyslyan and Ballymenock 30 acres, Lyslyan Nyvarre and the Gortin 6 acres; valued yearly in like money at 1*l.*


¶618] {MS folio 40}William fitz Richarde of Lysmolande for ½ carucate of land there, valued yearly in like money at 10*s.*


¶619] Pierce Creaghe of Kyllmallock if free tenant of Cranestowne, ffemyngstowne and Ardefenny, 1 quarter, valued yearly in like money at 1*l.*


¶620] William Keaghe mcGiralde mcDaye for 1 carucate of land in Ballynderity valued yearly in like money at 1*l.*


¶621] Conor Rowe OHernan in Ballyvistalencan 1 ½ quarters valued yearly in like money at 1*l.* 10*s.*


¶622] Connor moyle Obryan for 1 carucate of land in Kylhonkan and 1 carucate in Tirlowe and Cloughitackye; in all 2 carucates valued yearly in like money at 2*l.*


¶623] Teig Obryan mcGyllduff for 1 carucate of land in Attesloyne and Kahirduff; valued yearly in like money at 1*l.*


¶624] Dermott mcTeig for 1 carucate of land in Brose Gease valued yearly in like money at 1*l.*


¶625] {MS folio 40d}Teig Obryan mcDonogho for 1 carucate of land in Garynyadodate and Garrynyncolly valued yearly in like money at 1*l.*


¶626] Pierce Creagh fitzJohn for 6 acres in Rahynaghnere valued yearly in like money at 10*s.*


¶627] William ne Bwryly for ½ carucate of land in Cahirfillowe valued yearly in like money at 10*s.*


Sum of the yearly value of the rents of said free tenants, thus far, in Co. Limerick 440*l.* 15*s.* 10*d.* in money 184*l.* 15*s.* 10*d.* in cows 384.


¶628] *The Eight Toghes of "Cally" otherwise called Church Toghes.*


{MS folio 44} Services or charges called Sorohen for wages, stipend, lodgings, and victuals of soldiers called Galloglas, Kerne and horsemen, which the possessors or tenants and occupiers of lands and possessions within said Toghes rendered yearly to the late Earl of Desmond: the names of tenants canthreds and quantities are 
these viz:—


Henry fitz James for the land of Clonecravo in the parish of Clonecrane, 1 quarter, paid Sorohen viz victuals for 12 Galloglas for the space of 8 complete days yearly, that is for 2 days each quarter of a year. The vituals due from said quarter are valued yearly by the commissioners as aforesaid, to be rendered as aforesaid, at 13*s.* 4*d.* in money; and 2 cows.


¶629] The Togh of Killagholiehan, formerly belonging to the Abbey of Kelles[763](javascript:footNote('E580000-001/note763.html')) for lands called 



---

p.179




Farriheconnagh in the parish of Kyllagholiehan and containing 5 quarters. These rendered Sorohen for 12 Galloglas, for 8 complete days yearly amounting to 10*l.* This is cancelled here because the lands are in the Queen's hand by the suppression or dissolution of said Abbey and therefore the value is set down here as nothing.


¶630] Lands of the Bishop of Limerick called the Toghe of Ardargh alias Ardagh in the parish of Ardagh containin 4½ quarters of the lands of burgesses there, rendered Sorohen for 24 Galloglas for the space of 8 complete days yearly, that is for 2 days each quarter of a year which is valued as aforesaid to be delivered yearly as aforesaid at 3*l.* in money; and 9 cows.


¶631] {MS folio 41d} Richard Lyston for his lands called Killskannel 1½ quarters, in the parish of Kyllskannell and parcel of the Toghe of 
Ardagh rendered Sorohen for 12 galloglas for the space of 8 days yearly amounting yearly as aforesaid to be delivered as aforesaid to 1*l.* in money; and 3 cows.


¶632] Terrelagh mcMorierto de Disart for his lands called Cragclanmahownagh 2 quarters, in the Toghe of Cragmcmahowny alias Clanmahownde rendered Sorohen for 12 galloglas for the space of 8 days yearly, amounting yearly as aforesaid to be delivered as aforesaid to 1*l.* 6*s.* 8*d.* in money; and 4 cows.


¶633] Olyver fitz James, Garrett fitz James and Edmond fitz James, brothers (germani) for the land castle and vill of Tomguille 4½ quarters, being the Toghe of Tomguille, rendered Sorohen for 24 galloglas for the space of 2 days yearly, valued yearly as aforesaid to be delivered as aforesaid at 1*l.* 16*s.* 8*d.* in money; and 4 cows.


¶634] The occupiers of the castle and vill of Kylnecappagh alias Carrenbegg 1 quarter, being the toghe of Cappagh, rendered Sorohen for 12 galloglas for the space of 2 days each quarter of a year amounting yearly to 2*l.* which is cancelled here as Thomas mcRuddery alias "the Knighte of the vally[764](javascript:footNote('E580000-001/note764.html')) late possessor thereof was attainted by reason whereof the premises came to the Queen's hand and are chargeable elsewhere in this book:— here they are not set down of any value.


¶635] {MS folio 42} John fitz Edmonde of ffynetres Castell for the entire Toghe of Pobleneskath alias Popblenescaghe, 4 quarters, lying in the parish of Ballynekyllye rendered Sorohen for 60 galloglas for the space of 8 complete days yearly, valued as aforesaid to be delivered yearly as aforesaid at 2*l.* 13*s.* 4*d.* in money; and 8 cows.


Sum of the rents of the Churche Toaghes aforesaid yearly 30*l.* 10*s.* in money 10*l.* 10*s.* in cows 30.


Sum of the yearly value of the rents of said free tenants in Co. Limerick 471*l.* 5*s.* 10*d.*
in money 195*l.* 5*s.* 10*d.* in cows 414.


¶636] Sum total[765](javascript:footNote('E580000-001/note765.html')) of the yearly value or extent of the said lands of the late Earl of Desmond in the County of Lymerick.


2413*l.* 17*s.* 2*d.*
  
 
in money 1097*l.* 2*s.* 2*d.*
  
 cows 1167
  

wheat 1077½ pecks
  

malt 1077½ pecks
  

oaten malt 2155½ pecks
  
.


H. Wallop
  

Valentyne Browne
  

La. Alford
  

Christopher Peyton
  

Thomas Wyseman
  

Arthur Robyns.
  





---

p.180


{MS folio 42d blank}


¶637] {MS folio 43}*County of Kerry*


Still the revenues, castles, vills, lands and hereditaments of said Gerald Earl of Desmond, attained of High treason in divers baronies or canthreds commonly called Troghekaheds or Troughkeedes, and in the several countries of Desmond and Clanmorris in Co. Kerry.[766](javascript:footNote('E580000-001/note766.html'))


¶638] {MS folio 52d}*The manor of Tarberte with the country of Irraughte I Knokhor in Co. Kerry*.


¶639] {MS folio 53} Certain vills and lands of said Earl lying by themelves and not parcel of any barony or manor viz. Downearde in the parish of Killaughton near Tarberte 1 quarter late in the tenure of William mcBryan; the villate of Dirrenmoymore on Slewlogher mountain near the land of Walter mcWilliam of Garrantenna in the parish of Templeclaye ½ quarter; the vill of Garrentenna in same parish late in the occupation of said Walter mcWilliam ½ quarter; Kyllwearily another parcel the boundary between Limerick and Kerry 1 quarter.


The premises containing 3 quarters are valued yearly as aforesaid at 6*l.* and there are many woods and underwoods of divers kinds of 
the ages of 40, 60, and 80 years growing on the premises near the great river of Shanon containing by estimation 300 acres and valued yearly at.


The entire premises are of the yearly value of 6*l.* beside the woods.


¶640] The manor vill and chief house or mansion of Brasenogh alias Braseno with the lands and tenements in same vill and in a parish of Brasnogh lying on the mountain of Slewlogher partly in Kerry and partly in Connelo co. Limerick lately in the possession of John mcDonnell McAwly. To these belong the parcels of mountain land, arable land pasture, moor, wood, underwood of no value except for fuel and necessaries for husbandry bog and waste as follows viz:— Awbegg 6 quarters; Cleighdagh 2 quarters; Brasenagh and Dirrey 2 quarters; Kaherlavyle 2 quarters; Knockulekerre and Knockemony 2 quarters; Curraghnegale 2 quarters; in all 16 quarters: to said manor belong 3 carucates of land adjacent to the other side of the river of Veale which is the boundary between Limerick and Kerry. The premises in all 19 quarters lying in a barren 
place on the mountain of Slewlogher are only valued as aforesaid at 1*l.* 6*s.* 8*d.* the quarter to 25*l.* 6*s.* 8*d.*


¶641] {MS folio 53d}The proportion of victuals is reserved to the further consideration of the Lord Deputy and Council as the tillage of corn is not so great as in co. Limerick although Beeves and Martes in proportion to the ground are as lardghe[767](javascript:footNote('E580000-001/note767.html')) as in other places: also for collecting money and victuals the Queen shall not need such officers as the late Earl and the allowance for same is also reserved to the Lord Deputy and Council.


¶642] {MS folio 67}Lordships manors castles lands tenements possessions and hereditaments in Ireland which have come to the Queen's hand by escheat by reason of the rebellion of divers persons who, with the late Earl of Desmond or others, traitorously waged war on the Queen and were slain in rebellion or attainted by, judgment of Court and executed: their names quantities and values are given hereunder, viz—


*County of Limerick*:—


¶643] Thomas Browne late of Kylkyllane a rebel slain in war against the Queen as well as the time of his entry into rebellion as death was seised in his demesne as of fee of the lands and possessions following viz the castle an vill of Kylkyllane 1½ carucates 2 acres of land situate in the parish of Kyllkellane and held by the late Earl 
as of the barony of Small County and manor of Awny by the rent of 3*l.* 4*s.* and other Services charges, taxes and cuttings (tallagia) according to the custom of the Country; a moiety of the castle and vill of Camus 1 carucate, in the parish of Crean; the villate and land of Corbally[768](javascript:footNote('E580000-001/note768.html')) near Sleverigee, ½ carucate; and a moiety of a burgage and 30 acres of land called Cleistaines alias Cley James within the borough of Awny. These premises containing 3 quarters 32 acres are valued in lawful money of England to be paid yearly by equal portions at Easter and Michaelmas; and in victuals and provisions to be delivered within 8 miles of said lands viz. good fat cows valued at 13*s.* 4*d.* each, wheat per peck of 16 gallons at 3*s.* 4*d.*, barley malt per 



---

p.181




peck of 20 gallons at 3*s.* 4*d.*, and oaten malt per peck of 20 gallons at 1*s.* 8 d: the cows are to be delivered between the feasts of Michaelmas and All Saints, and the corn between 15 Nov. and 25 Mar. following, and if the victuals and provisions are not delivered in their several species as aforesaid (the election of which will be in the power of the Queen by the Lord Deputy) then they shall 
be valued in money as aforesaid payable yearly as aforesaid. And so the premises are valued yearly at 8*l.* 13*s.* 4*d.* in money; 9 cows, 16 pecks of wheat; 16 pecks of barley malt; and 32 pecks [of oaten malt][769](javascript:footNote('E580000-001/note769.html'))


¶644] John Browne similarly a rebel, slain in rebellion was similarly seised of the possessions and lands following viz. a broken castle in quadrilateral form situate on the top of a small mountain called Knockmunyhy with a garden and yard adjacent thereto and lands belonging to the castle containing 1 carucate valued yearly as aforesaid in money and provisions to be delivered as aforesaid, at 6*l.* 13*s.* 4*d.*; two other small old and broken castles called Ballymonybegg with lands belonging thereto amounting to 140 acres valued yearly as aforesaid in money and provisions to he delivered as aforesaid, at 10*l.*; a moiety of the vill and castle of Camus in the parish of Crean containing 1 carucate valued yearly as aforesaid in money and provisions to be delivered as aforesaid at 6*l.* 13*s.* 4*d.*the tithes of said three castles and the lands adjacent thereto belong to the preceptory of Awny parcel of the Queens possessions; a moiety of a burgage with 30 acres of the measure of the county called Cleistaines alias Cley James lying within the manor and borough of Awny aforesaid valued yearly in money and provisions as aforesaid at 2*l.* 13*s.* 4*d.*; the castle of Rathiverde alias Rathuerd, in good repair having an iron door of entrance, with a "balne", a dovecote within the balne and other buildings, and with 2 parts of 2 carucates into 3 parts divided adjacent to the castle and occupied therewith, which 2 parts contain by estimation 140 acres of said measure, valued yearly as aforesaid at in money and provisions as foresaid 21*l.* 13*s.* 4*d.*; certain lands called Martin, Nenogh with a fair at Martellestowne, containing 20 acres, and lands and fair are valued yearly as aforesaid at 1*l.* And so the premises in toto are valued yearly in money and provisions to be delivered as aforesaid at 20*l.* 13*s.* 4*d.* in money; 21 cows; 28 pecks of wheat; 28 pecks of barley malt; and 56 pecks of oaten malt.


¶645] {MS folio 68}John Supple alias Suppell similarly a rebel slain in rebellion was similarly seised of the possessions and lands following viz the very fine and large castle of Kilmackhwoo quadrilateral in form and containing 9 several places or rooms in some parts ruinous with a great enclosure or "balne" surrounded by a stone wall strongly built for defence: adjoining the castle on the east side is an orchard or yard and on the south side was a water mill now ruinous, with the vills lands and tenements adjacent thereto; and divers other vills lands and tenements received and reputed as "chargeable lands" with rent of Shraghe and Mart, and all charges taxes cuttings and impositions called Coinie liverie Cossherie, Quiddie, Kerntie, Sorohen, Galloglas, and such like as often as it pleased the late Earl to impose them on said lands; said castle and premises are parcels of the canthred or Toghe of Gortculligan in the Country of Connelo and parish of Garreston alias Ballingarry in the parcels hereafter recited viz. the castle of Kylmackwoo with the gardens orchard mill and other necessary buildings and close adjacent thereto 1 quarter; Grenaugh 1 quarter; Killattle 1 quarter; Lystoan 1 quarter; Kyllowghtowe 1 quarter; Ballyvologg 1 quarter; Ballyconylly 1 quarter, Ballyroo with Ballyferris 1 quarter and Balllynhahagh 1 quarter, which parcels contain in toto 9 quarters;


¶646] he was also similarly seised of divers other castles vills tenements and lands lying in divers parcels in Connelo and else where in co. Limerick which were not parcels of any of the Sixteen canthreds or Toghes aforesaid viz. the castle of Ballycollo with the appurtenances ½ quarter; Ballythwohill ½ quarter in the parish of Ballingarry; 1 quarter in the parish of Kyllcollman; Ballymochymore ½ quarter; Ballymochybegg ½ quarter, Ballypera alias Ballyperta 30 acres, Ballyenlor 30 acres, villate of Ballymavnegh 20 acres in the parish of Kyllfynny; vill of Ballynvarnagh 1 quarter;


¶647] Clonefert 20 acres; Clonerobucke 20 acres; Gortnegh 20 acres in Ballyngarry parish; 



---

p.182




Gorinchachelboye alias Gurtencaleboye in the parish of Kyllfynnye[770](javascript:footNote('E580000-001/note770.html')) and Kylmackowe ½ quarter; Gragmortilly with certain tenements in the town of Adare 25 acres; Kylbegg 20 acres; Lystaghe ½ quarter; a parcel in fyntres towne called Towregyh alias Towveregyly 10 acres; 2 parts of the vill of InchKnockane into 3 parts divided, 30 acres; Ballyknockane ½ quarter in the parish of Kyllmackowe;


¶648] {MS folio 68d} Ballymohollo ½ quarter in Cosmaye the country of the Earl of Kyldare; the castle of Craggan 1 ½ quarters in said 
country of Cosmaye; which castles with their appurtenances not being parcels of said Toghes contain in toto 10 quarters 25 acres; he was also similarly seised of Ballymocky 1 quarter, in the parish of Kyllcolman parcel of the canthred or Toghe of Olybane; 3 tenements in the town of Kyllmallock in the tenure of Dermot (Dermicius) mc Donnell and others which with gardens and 18 acres lying within the franchises of Kyllmallock are worth yearly 2*l.* 13*s.* 4*d.* all which premises amount to 20 quarters 25 acres and are valued yearly in money and provisions as aforesaid to be delivered 
as aforesaid, as follows viz for every quarter 2*l.* 13*s.* 4*d.* of like money, 3 cows large and fat, 4 pecks of wheat, 4 pecks of barley malt and 8 pecks of "oten malt" of the measures aforesaid at which rate the yearly rents are 51*l.* 8*s.* 4*d.* in money; 60 cows; 88 pecks of wheat; 88 pecks of barley malt; 176 pecks of "otenmalt".


¶649] Hugh[771](javascript:footNote('E580000-001/note771.html')) Wale alias ffalltaghe a rebel attainted by judgment of High treason, at the times of his entry into rebellion and attainder was similarly seined of the castles vills and lands following which were chargeable lands of the late Earl of Desmond with Shragh and Marte, services for building and repairs of castles, bridges and other charges of the country, being parcels of the canthred or Toghe of Donmoylin viz. the castle of Donmoylin which is a great castle with a large enclosure or "Balne" surrounded with a stone wall strongly built for defense; rise nd with divers buildings adjacent very ruinous, also with gardens, small closes and a water mill similarly in decay, and a watercourse there all worth yearly 1*l.* 6 s 8*d.*; 
lands belonging to same castle in Donmoylin parish 1 quarter, a ruinous castle called Monemoyhell in same parish 1 quarter.


¶650] {MS folio 69} the villates of Downecha west and Downecha east 2 quarters; the villate of Ballyntclaby alias Ballyslabagh 1 quarter in the parishes of Donmoylin and Shanagologh; the vill of Lysbaen 26 ½ acres in the parish of Donmoylin; the vill of Banneoge alias Banouge ½ quarter in the parishes of Donmoylin and Shanagolo; the villates of Rathfearra alias Rawme and Teeremore alias Tirmore 1 quarter in the parish of Donmoylin; Kyltenan alias Kyllsanan leth 1½ quarters in the parish and canthred of Croughe; Ballyestine 26 ½ acres parcel of the canthred or half Toghe of Drynan in the parish of Kyllvradran; the castle of Garrene boye partly ruinous and devastated with half a quarter belonging thereto; three vills called Rathcrogan 1 quarter, Carenmoer 1 ½ quarters and Carrenbegg 
½ quarter, all in the parish of Kyllcollman and containing 3 quarters. The premises besides the castles contain 12 ½ quarters 13 acres which are valued as aforesaid, to be delivered yearly as aforesaid at 23*l.* 6*s.* 4*d.* in money 26 cows; 20 pecks of wheat; 20 pecks of barley malt; and 40 pecks of "oten malt".


Memorandum. The premises were demised to Ollyver Stephenson by lease under the great seal of Ireland dated 27 April 1582 at the rent of 5*l.* 12*s.* 2 ½*d.* Irish, with a proviso to answer any further duties that should be found chargeable on the lands.


¶651] James Wale and Stephen Wale rebels slain in rebellion, at the times of their entry into rebellion and death were similarly seised of the lands following viz Clonskeachan 1 quarter in the parish of Grange (Gransha); Dromon there 1 quarter; Drownegohee there 1 quarter; and Ballygowne alias Ballengowen there ½ quarter: these lands were chargeable lands of said late Earl with Shragh and Marte and all charges, taxes, cuttings and impositions called Coyne, liverie, Cosshrie, Quiddie, Kernty, Sorohen, Galloglas, and such like as often as it pleased the Earl to impose them on the lands; said premises contain 3 ½ quarters and are parcels of the Earl's canthred or Toghe called Ogallyhowre; they were similarly seised of the vill of Garrananekyvan alias Garankethan ½ quarter parcel of the Earl's chargeable lands as above as parcel of his 
canthred or Toghe called Meaghan in the parish of Castellnoa alias "Newcastell"; also of Bowengoeth 1 quarter: 



---

p.183




said premises contain in all 5 quarters and are valued as aforesaid, to be delivered yearly as aforesaid, at 6*l.* in money; 12 cows; 22 pecks of wheat; 22 pecks of barley malt; and 44 pecks of "oten" malt.


¶652] {MS folio 69d}Peter[772](javascript:footNote('E580000-001/note772.html')) Wale late of Balliegny a rebel against the Queen and attainted of High treason by judgment as well at the time of his entry into rebellion as of his attainder was similarly seised of the castles vills and lands following viz. Ballyegny and 10 acres of free land in Clonehagh in the parish of Rathkealy: also of chargeable lands of the Earl as parcel of his canthred of ffarrensesseragh 
in the following parcels viz Ballyegnymore ½ quarter in said parish; Ballyegnybegg ½ quarter, and Carrerag[773](javascript:footNote('E580000-001/note773.html')) there ½ quarter, in all 1½ quarters 10 acres: he was similarly seised of three pieces of land[774](javascript:footNote('E580000-001/note774.html')) in the parish of Kyllcollman one called Lybahanen 1 quarter, another called Ballylodden alias Ballyboddane 1 quarter, and the third called Deadan alias the two Deadans I quarter; which parcels containing 3 quarters were chargeable lands of said Earl 
with Shragh and Marte as parcel of the canthred or Toghe of Meaghan: And so all the premises amounting to 4½ quarters and 10 acres are valued as aforesaid to be delivered as aforesaid at 8*l.* 2*s.* 6*d.* in money; 9 cows; 18 pecks of wheat; 18 pecks of barley
malt; and 36 pecks of "oten" malt.


¶653] Redmond Wall a rebel, slain in rebellion at the times of his entry into rebellion and death was similarly seised of a tenement and lands in the late borough of Adare containing 5 acres; and of a parcel of land in the Vill of Clonesherebegg containing 7 acres; which are similarly valued yearly as aforesaid to be paid as aforesaid at 1*l.*


¶654] Nicholas fitz Williams a rebel slain in rebellion, at said times was similarly seised of the castles vills and lands following viz., of free land:— Ballywollane ½ quarter in the parish of Cloneltie; Garrenglossick 20 acres in the parish of Rathekealy; Cappemudde 20 acres in same parish; and ffarenka alias Cathir 20 acres; in all 1 quarter and 20 acres also he was similarly wised of chargeable lands of said Earl as parcels of the canthred or Toghe of Olibane viz. the Vill of Kylkollman ½ quarter in the parish of Rathkealye; the vill of Switrasse 1 quarter in the parish of Kyllcollman; the villate of Ardebegh hallagh 1 quarter in the parish of Rathkealye; Ballyee 1 quarter parcel of Rathkealye in same parish; Ballynlaghagh 1 quarter parcel of Rathkeahe{MS folio 70} in same parish, and Ballychahell ½ quarter parcel of Rathekealye in the parish of Kyllcollman;


¶655] in all 5 quarters: he was similarly seised of two vills one called Athliny alias Athlyne 1 quarter and the other called Ballynbrowne alias Brownestowne 1 quarter, which 2 quarters are in the parish of Cloneltye and were chargeable lands of said Earl as parcel of his canthred or Toghe of Asketon. All the premises contain 8 ½ quarters and 20 acres and are valued yearly as aforesaid, to be delivered as aforesaid, at 10*l.* 8*s.* 4*d.* in money, 20 cows; 40 pecks of wheat; 40 pecks of barley malt; and 80 pecks of "oten" malt.


¶656] Robert oge Cushen a rebel similarly slain and seised of a parcel of free land called Bohernebetagh 20 acres in the parish of Grange (Grannshagh): he was similarly seised of chargeable lands of said Earl as parcels of his canthred or Toghe of Asketon viz. the vill of Lysuecorye alias Lyshcorro ½ quarter the villate of 
Ardfynain ½ quarter; the vill of Ballynabucke alias Ballerwbugh ½ quarter; all which containing 1 ½ quarters 20 acres lie in the parish of Clonelty: he was similarly seised of divers other chargeable lands of said Earl as parcels of his canthred or ½ Toghe of Ogallyhowre viz Ballymorishin 40 acres, and Ogallahoore 1 quarter, both in the parish of Grange (Graunsha). Said lands amounting in all to 3 quarters 20 acres are valued yearly as aforesaid, to be delivered as aforesaid, at 4*l.* 18*s.* 4*d.* in money; 8 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of "oten" malt.


¶657] Richarde mc Thomas alias mc Thomas of the Pallace in Connelo a rebel similarly slain, was similarly seised of these parcels of free land viz the Vill and castle of Pallace in the parish of Ballincastlane in Connelo which castle a buildings gardens orchards closes and water mill now waste an very ruinous contains 6 acres, and they are here {MS folio 70d} extend at nothing because they are dealt with hereafter; the vill at Pallace 3 quarters: he was similarly seised of chargeable 



---

p.184




lands of said Earl as parcels of the canthred or Toghe of Browerie with Shragh Mart &c viz the vill of Garrefoine 2 quarters, Ballyntubred 1 quarter and Clonefert 1 quarter, which parcels containing 4 quarters are in the parish of Browerie: he was similarly seised of Pobulmynter Guillane chargeable land of said Earl as parcel of the canthred of Clonenrie in the parish of Ballycastellane, and divers other parcels called Modullehe 1 quarter, Ballemarten 1 quarter, Ballyferode 1 quarter, Clonecrippe 1 quarter, Cloneconery ½ quarter, Dromeeroo ½ quarter and Dromonowhryn ½ quarter, which parcels contain 5 quarters:


¶658] he was similarly seised of Ballycolman ½ quarter of land chargeable to said Earl as parcel of the canthred of Asketon, lying in the parish of Cloneltye; Karrowgarre 60 acres of land in the parish of Grange (Graunsha) chargeable to said Earl as parcel of the ½ Toghe of Ogallyhowre: And he was similarly seised of Kahir 
mony with Raghronan containing ½ quarter, and Ballynallmory alias Pallmerstowne containing ½ quarter. All which premises containing 14 quarters 26 acres are valued as aforesaid to be delivered as aforesaid yearly at 23*l.* 12*s.* 5*d.* in money; 30 cows; 56 pecks of wheat; 56 pecks of barley malt; and 112 pecks of "oten" malt.


¶659] Gerald fitz Thomas a rebel similiarly slain was similarly seised of the castle of Kyllfenny which with the gardens yards orchards and other buildings and mill there in the parish of Ballyneklly is now wasted and ruined, however they are here extended at nothing because dealt with afterwards: he was similarly seised of the vill of Kyllfynny alias Kylfenny 1 quarter, Ballynekylly 1 quarter, and Scarthnegerogh 1 quarter, all lying in the parish of Ballynekylly aforesaid and containing 3 quarters for which said Gerald fitz Thomas paid the said late Earl a yearly rent of 1*l.* sterling and a refection: he was similarly wised of 1 quarter of land 
chargeable in manner and form aforesaid called Rathkaell, parcel of the canthred or Toghe of Gortcoyth in the parish of {MS folio 71} Monoghadare; and of the vill of Ballytaberd 1 quarter 20 acres in said parish of Monoghadare chargeable land as parcel of the ½ Toghe of Kylheilagh. The premises containing in toto 5 quarters 
20 acres of land are valued as aforesaid, to be delivered yearly as aforesaid, at 10*l.* 5s. in money; 9 cows; 20 pecks of wheat; 20 pecks of barley malt; and 40 pecks of "oten" malt.


¶660] Walter Lewe a rebel similarly slain was similarly seised of the castle and vill of Downekeepe in the parish of Nenawgh which is broken and ruinous, with the gardens, water mill, and small crofts adjacent it contains 4 acres worth yearly 13*s.* 4 d .; the vill of Downekeepe aforesaid 1 carucate: the premises are valued as aforesaid, to be delivered as aforesaid yearly, at 3*l.* 6*s.* 8*d.* in money; 3 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of "oten" malt.


¶661] John Okahisse a rebel similarly slain was similarly seised of the castle and vill of Kylderry in the country of Pobulbryan, which castle is very ruinous but with the gardens and crofts adjacent it is of the yearly value which hereafter appears, the vill of Kylderry aforesaid contains 1 carucate; the vill and site of the old and very 
ruinous castle of Rahin ½ carucate; a third part of the vill of Clonany in Cosmaye containing by estimation 40 acres. The premises contain in toto 2 quarters which are valued yearly as aforesaid, to be delivered as aforesaid, at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; 16 pecks of "oten" malt.


¶662] Eugene alias Owen mcEdmond oge mcShehy and Owin mcBryan rebels similarly slain in rebellion were similarly seised of the castle of Ballynoa alias the Newetowne in the parish of Cloneltye which castle with the gardens and divers crofts and enclosures adjacent to it is of the yearly value which hereafter appears; the vill at Ballynoa 1½ quarters: they were similarly seised of a parcel of chargeable land called Karrowemore 1 quarter situate in Kyllcolman parish and parcel of the Toghe of Olybane; 
and of two other parcels one called {MS folio 71d} Kyllgullubon 1 quarter and the other called Kilteanna 1 quarter parcels of the Toghe of Asketon in said parish of Clontie. The premises contain in toto 4½ quarters and are valued as aforesaid to be delivered yearly as aforesaid at 7*l.* 10*s*. in money; 9 cows; 18 pecks of wheat; 18 pecks of barley malt; and 30 pecks of "oten" malt.




---

p.185


¶663] Donogho moyle mcWilliam a rebel similarly slain was similarly seised of the vill tenement and land of Dromelare ½ carucate; a parcel of land in Cosmaye containing by estimation 20 acres. The premises contain in toto ½ quarter and 20 acres which are valued as aforesaid, to be delivered yearly as aforesaid at 18*s.* 4*d.* in money; 2 cows; 3 pecks of wheat; 3 pecks of barley malt; 6 pecks of "oten" malt.


¶664] Moriertagh mcBryan and Morrogho moyle OBrien, rebels similarly slain were similarly seised of a carucate called Thirvo near Cariogonell in Pobulbryan and half a carucate in said country called Kyllmaclyn. The premises are valued as aforesaid to be delivered as aforesaid, at 2*l.* 16*s.* 8*d.* in money; 4 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of "oten" meal.


¶665] Ullig Backaghe mcThomas a rebel similarly slain was similarly seised of certain lands in Clashony in Clanwilliam which are extended yearly in sterling money payable as aforesaid at 8*s.*


¶666] Edward oge Lacye a rebel, slain in rebellion in the church of Knockepatricke at the times of his entry into rebellion and death was similarly seised of the castle vill land and tenement of Ballynecloghy parcel of the half Toghe of Lismakery in Connelo, the castle is broken and ruinous and the adjacent garden and crofts waste but altogether they are of the yearly value of 1*l.* 6*s.* 8*d.*; and the said vill land and tenement lying in the parish of Lysmackerye contain 1½ quarters: they are valued as aforesaid to be delivered as aforesaid, at 3*l.* 6*s.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; and 16 pecks of "oten" malt.


¶667] {MS folio 72}Gerald Duff son of James fitz David oge Crone a rebel, slain in rebellion was similarly seised of 2 quarters in Tryan 
morrina in Clonelty parish called Rathphrile, Lysaniskye Ballybegg mcy deagan and Ballybegg in mc Thomas held of the said Earl as of his manor of Asketon rendering yearly 1*l.* 12*s.* for Shragh and 12 cows for mane; 20 acres of free land in Cowlebane in said parish; and 1 quarter of chargeable land called Graegencurry in the Toghe of Gortculligan in Ballingarry parish. The premises amounting in all to 3 quarters 20 acres are valued yearly as aforesaid to be delivered as aforesaid at 4*l.* 18*s.* 4*d.* in money; 8 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of "oten" malt.


¶668] Patrick Woolphe a rebel slain in rebellion was similarly seised of the castle vill and land of Ballywilliam 2 quarters in the parish of Rathekealye in the canthred or Togh of Olyban in Connelo; 8 gardens and certain other parcels of land called Gortnemonymor Nehacrye and ffarryneglanne containing 50 acres; another piece of land called Eneskoysh 60 acres. The premises amount to 2½ quarters 10 acres and are valued yeaNy as aforesaid, to be delivered as aforesaid at 3*l.* 2*s.* 6*d.* in money; 6 cows; 12 pecks of wheat; 12 pecks of barley malt; and 24 pecks of "oten" malt.


¶669] Thadeus (Teig) O Mulryan a rebel slain in rebellion was similarly seised of Bialruhim in Owny alias Omhy Omulryan containing by estimation 3 carucates valued as aforesaid, to be delivered yearly as aforesaid at 3*l.* 13*s.* 4*d.* in money; 8 cows; 12 pecks of 
wheat; 12 pecks of barley malt; and 24 pecks of "oten" malt.


¶670] Gerald fitz Edmonde a rebel slain in rebellion was similarly seised of Glanehagilshy with a castle in Clangibbon co. Limerick containing 1 carucate, valued as aforesaid, to be delivered as aforesaid at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barly malt; and 8 pecks of "oten" malt.


¶671] {MS folio 72d}Bryan Roo a rebel slain in rebellion was similarly seised of the vill of Kahirduff ½ carucate; the vill of Lakingrenan 
otherwise Lakeregrene ½ carucate: in all 1 quarter valued as aforesaid to be delivered as aforesaid at 1*l.* 13*s.* 4*d.* in money; 2 cows; 4 pecks of wheat; 4 pecks of barley malt; 8 pecks of "oten" malt.


¶672] Cormac (Cormacius) oge OHallynan a rebel slain in rebellion was similarly seised of the vill of Boheroyne ½ carucate, valued as aforesaid to be delivered as aforesaid, at 10*s.* in money; and 3 cows.


¶673] James Reoghe Lacye a rebel captured in rebellion and hanged was similarly seised of the castle vill land and tenement of Lysmakery near the land of Asketon, 1 carucate, valued yearly as aforesaid, to be delivered as 



---

p.186




aforesaid at 1*l.* 13*s.* 4*d.* in money; 
2 cows; 4 pecks of wheat; 4 pecks of barley malt; and 8 pecks of "oten" malt.


¶674] Gerald Balluff[775](javascript:footNote('E580000-001/note775.html')) a rebel captured in rebellion and executed was similarly seised of the villate of Ballynfryorye ½ carucate; three other parcels viz Boherboye containing by estimation 10 acres, Ferranhaynryro ½ carucate, and Graegh enharrowe containing by 
estimation ½ carucate. The premises containing in all 1½ quarters 10 acres are valued yearly as aforesaid, to be delivered as aforesaid, at 2*l.* 12 *rend="ital">s.* 6*d.* in money; 3 cows; 7 pecks of wheat; 7 pecks of barley malt; 14 pecks of "oten" malt.


¶675] James ffant of ffantstowne was attainted of murder and executed at Kyllmallock, at the times the murder was perpetrated and he was attainted he was similarly seised of the vills and lands following viz Fantstowne 2 carucates near Kyllmallock; the villate of Ballecollen now in the possession of Rory (Roric') mcShehy 1 carucate; amounting in all to 3½ quarters as was found by inquisition taken before Thomas Wyseman, James Golde, Attorney {MS folio 73} for the province of Munster, Robert Rosier and Arthur Robins, esquires, commissioners, at Kyllmallock on 26 Oct. 1584 a.r. xxvj Eliz. inter alia as follows:— the jurors say on their oath that James ffant formerly of ffantstowne gent, assaulted Patrick ffant and murdered him at Glassaie[776](javascript:footNote('E580000-001/note776.html'))s gate in Kyllmallock, for which murder he was attainted and executed at Kyllmallock; at the times the murder was perpetrated and of his attainder he was seised of the vill and land of Fantstowne 2 carucates, but they know not from whom he held them; that at the time of his attainder he was seised of Ballecollen 1 carucate now in possession of Rory (Roric') mcShehy but they know not its value.


The 3 carucates are valued yearly as aforesaid to be delivered as foresaid, at 2*l.* 3*s.* 4*d.* in money; 2 cows; 5 pecks of wheat; 5 pecks of barley malt; and 10 pecks of "oten" malt.


¶676] William Meaghe murdered John Meaghe and was executed; at the times the murder was perpetrated and he was executed he as similarly seised of 2 tenements and a garden in "St Johns Streate" in or near Kilmallock valued yearly as aforesaid, to be delivered as aforesaid, at 6*s.* 8*d.*


¶677] The son and heir of Thomas Wale a rebel who died in rebellion at the times of his entry into rebellion and death was similarly seised of the vill of Boherbrodagh and 3 quarters 60 acres of land in the parish of Clandchere; and of Kyltennan 1½ quarters in the parish of Crogh, chargeable land, parcel of the canthred or Toghe 
of Croghe. The premises are valued yearly as aforesaid, to be delivered as aforesaid, at 3*l.* 13*s.* 4*d.* in money; 11 cows; 20 pecks of wheat; 20 pecks of barley malt; and 40 pecks of "oten" malt.


¶678] Thomas Cham late of Clenliske a rebel who died in rebellion at the times of his entry into rebellion and death was similarly seised of divers castles vills villates and free lands viz. the castle and vill of Kyllydey alias Kyllydye 3 quarters; Kyllynbocherr 20 acres; Clenogh ½ quarter; Bellagh ne Grossane 20 acres; Cullshonekyn 
½ quarter; Leaughmore {MS folio 73d} ½ quarter; Leaughbegg ½ quarter; Kylhonnrogh ½ quarter; and Ballymckerry 1 quarter 20 acres; which premises lie in the parish of Kyllidye and contain 7 quarters 20 acres: the castle vill and land of Gortnetuberd 4 quarters in.


¶679] the parish of Kyllmihen alias Kyllmighen: divers other castles vills villates and lands in certain canthreds or Toghes in Connelo chargeable lands with Shraghe and Marte and all other taxes due to the late Earl of Desmonde and levied and collected for him whenever he pleased viz Treanmeane as parcel of the Toghe of Tawnaghe, two parcels, of which one called Enfevhanagh contains 1 quarter, and the other Clonefearna 1 quarter; Trean faltagh 3 quarters lying in the same Toghe in parcels called Eaqulishna Groman, 
Cromanmoore, Cromanbegg, Cromannaghbodagh, Aghanbuilig, Cloinlomonaghta, Iniskin and Cloinemoore; which denominations of Treanmeane and Treanfalltagh lie in.


¶680] the parish of Mahownagh and contain together 5 quarters; and as parcel of the canthred or Toghe of farrensesseragh viz the old castle of Lisnekylly with the appurtenances in Clonehagh 1 quarter, Garran there 1 



---

p.187




quarter, Ballynkenry there 1 quarter, Dealus there ½ quarter, Rareaughmore there 1½ quarters, Lisgaddie 
there ½ quarter, and Rahagonan there ½ quarter, which denominations lie in the parishes of Rathekealye and Kyllskannell and contain together 6 quarters; and as parcel of the half Toghe of Kylliddye, the vills of Fineglas and Gortnecloghie 1 quarter and 20 acres in the parish of Kylliddye;


¶681] and as parcels of the half Toghe of Kyllhyhgh lying in divers parcels in the parish of Monoghadare, viz the vill of Kylheilagh 1 quarter, Dromballyvallder 60 acres, Cappa 60 acres, Clonskaha 1 quarter, and Lisnefollo 20 acres, which denominations contain together 3 quarters 60 acres; And a parcel called Arlomande situate in the parish of Kyllvadran as parcel of the half of Toghe of Drynan containing a third part of a quarter into three parts divided, namely 26½ acres; and he was similarly seised of 3 other parcels one called Rayrenagh another Rosuerye and the third Kylchouesragh containing together by estimation 1½ quarters. The entire premises amounting to 29 quarters 6½ acres are valued yearly as aforesaid to be delivered as aforesaid (at the rate of 5*l.* per quarter) at 43*l.* 14*s.* 9½*d.* in money; 55 cows; 130 pecks of wheat; 130 pecks of barley malt; and 260 pecks of "oten" malt.


¶682] {MS folio 74} Moriertaghe Merigaghe a rebel slain in rebellion was similarly seised of the castle vill and land of Kyllduff 1½ carucate 
now in the custody of Thomas Browne and valued yearly as aforesaid to be delivered as aforesaid at 3*l.* 6*s.* 8*d.*


¶683] Kynedy mcBryan late of Ballanitye and Conoghor mcBrian otherwise called Kwoghor in Cwonagha mcBryan, slain in rebellion, were similarly seised of divers castles, vills, villates and lands following viz Ballanitye alias Whitestowne in the parish of Tamplebredan, Cloghdallton alias Clohendallton in the parish of Woolye, Cloghplallordy alias Cloghenflordy in same parish lying in the country of Cwonaghe; 1 quarter of land in Knockewly; Ballyvilloyde, Aryvregy, Gortiglay, and other lands in Bohermore; 
which premises contain in toto by estimation 8 carucates.


¶684] In the inquisition taken at Kilmallock on 11 Sep a.r. xxvj Eliz ([*...*][777](javascript:footNote('E580000-001/note777.html'))) before Nicholas Welshe esquire chief justice of Munster, John Meagh second justice of Munster and other commissioners there is contained inter alia as follows:—


And they say that Tirrelagh mcBrian late lord of Cwonaghe being seised in his demesne as of fee of the castle vills and lands of Ballanity, Cloghdallten, Cloghplallord, 1 quarter of land in Knockowlye, Ballyvilloyde, Arrivregye, Gortiglanye, and other lands in Bohermore by deed bearing date 20 April 1575 enfeofed said Kynedye mc Bryan of the premises to hold to him his heirs and assigns to the use of his [778](javascript:footNote('E580000-001/note778.html')) Elena ny Cormock her heirs and assigns in 
mortgage; that said Kynedye mcBryan being seised of the premises to the use aforesaid by his deed of fee simple bearing date 25 Sep. 1578 enfeofed his brother (germanus) Barnaby mcBryan of the premises to hold to him and his heirs to the use of the said Elena her heirs and assigns in form aforesaid; they say that Elena caused said Kynedye to make said estate and feofment to said Barnaby when they saw Kynedye fallen~mto evil counsels; that Barnaby at the date of the feofment was 21 years of age and no more and that 
Kynedye was then under age because he has 3 brothers and 1 sister viz Barnaby, Donogho Mahowne and Elen, Barnaby the eldest had not then exceeded the age of 21 years and Kynedye was the youngest of them all; that Kynedye afterwards entered into rebellion and was slain therein.


The premises are valued yearly as aforesaid, to be delivered as aforesaid, at 21*l.* 6*s.* 8*d.* in money; 24 cows; 32 pecks of wheat; 32 pecks of barley malt; and 64 pecks of "oten" malt.


¶685] {MS folio 74d}Thomas mcRudderye otherwise called "the Knighte of the vally", attainted of High treason and executed at Limerick, was similarly seised of divers castles, vills, villates and lands hereafter specified[779](javascript:footNote('E580000-001/note779.html')) viz the castle vill and land of Glancorobrye 20½ carucates; the castle vill and land of Castelltowne 3 carucates; the castle and vill of Kyppagh alias Cappagh 1½ quarters; Kylnecappagh ½ quarter; Craggbegg ½ quarter; the castle and vill of Behiz 3 carucates; the vill of Kylbride 2 carucates; the vill of Arlomane and Cloneogullen 2 carucates; the vill of Ballylongirth 1 



---

p.188




carucate; the vill of Fahigh ½ quarter; the vill of Clohirr and 2 carucates; the vill or villate of Mowirth 1 carucate; the vill of Balligan ½ carucate; Drologhan I carucate;


¶686] he was similarly seised of 2 waste water mills one at the castle of Glancorobine alias the Knighte of the valley's Castle and the other at the vill of Castelltowne aforesaid: the premises are situate in Kenrye and elsewhere in co. Limerick and were found for the Queen by inquisition taken at Limerick on 12 Mar 1572. And further it is found on this survey that the said late Thomas mc Ruddery alias the Knighte of the vallye had divers other castles vills and lands in the country of Kenry and elsewhere in co. Limerick which have been hitherto concealed and detained from the Queen viz. the castle and vill of Beahagh alias Enbeogh and Yearosse 9 quarters lying in the parish of Kyllkurnan; the castle and vill of Ballihaghan 1 carucate in same parish; the castle and vill of Mournan there 1 carucate; the vill of Balleshunckeban alias Johnstowne in 
same parish 1 carucate.


¶687] the castle and vill of Ballynowgoole there 2 carucates; the castles and vills of Yland more Ruddery and Ballygeorge alias Georgestowne there 4 quarters; the castle and will of Lystrumloghan there 1 carucate; the castle and vill of Garrenballaghonoo 1 carucate in Kylkurnan parish; the castle and will of Roynekirkye in the parish of Ardecaugh and country of Kenryherrowe containing 1 carucate which premises amount in all to 60 carucates according to the computation of the country there.


¶688] The said country of Kenrye and others aforesaid was wont to supply for the defence of the late Earl and his country 1000 armed foot soldiers called Galloglas, 1000 soldiers light footmen called Kerne, and 500 horsemen with victuals and quarters as well for soldiers as horses for the space of 4 days every year viz 2 days after Christmas and 2 days after. Easter, and longer if he pleased. These charges are computed of the yearly value of 666*l.* 13*s.* 4*d.* at least; however in consideration of the desolation and devastation of the country and that the said castles are ruinous and partly broken the 
entire {MS folio 75} mises are valued and extended as follows viz the castle Glancorobrye with the waste water mill there, and 20½ quarters of land adjacent to the castle, being more sterile at 1*l.* in money, 2 cows, 2 pecks of wheat, 2 necks of barley malt, and 4 pecks of "oten" malt for every quarter yearly; a fishing in the river[780](javascript:footNote('E580000-001/note780.html')) flowing near the castle at 3*s.* 4*d.* yearly; 39½ quarters belonging to the castle of Castelltowne aforesaid 1*l.* 13*s.* 4*d.* in money, 2 cows, 4 pecks of wheat, 4 pecks of barley malt, and 8 pecks of "oten" malt for every quarter yearly;


¶689] and further there were divers free tenants kyho paid rent yearly to the said Thomas mcRuddery viz Edmond mcDavid and Maurice Ykhea for the vill of Shaneballymore 10*s.*; John fitz Morris and Thomas ny Berniz for the vill of Ballynymony 10*s.*; Morris Ykhea for the vill of Digirth 5*s.*; Gerald mcMorris for the vill of Ballyngowle 10*s.*; Edmund oge and David mcPhilipe for Ballynoa alia the Newetowne 10*s.*; John oge mcShane for the vill of Ballychahane 10s.; Thomas mcRicharde for t vill of Ballyneknockvane 10*s.* and for the vill of Beolane 10*s.* In all yearly:— cancelled here because the tenant held the premises of the said Earl of Desmond by the major rents of Shraghe and Marte and other services, and therefore the major rents of Shraghe and marte are charged on the several persons among the free tenant of the great Country of Limerick as there appears. And so the premises are valued yearly as aforesaid, to be delivered as aforesaid, at 87*l.* in money; 120 cows; 199 pecks of wheat; 199 pecks of barley malt; and 398 pecks of "oten" malt.


¶690] {MS folio 75d} Morrogho mcBryan lord of Granoghe, alias mcTirrelaghe rebel attainted of High treason was similarly seised of the castles vills villates and lands following in Granogh viz. Ruskeghmore ½ quarter, Ruskeghbeg ½ quarter, Droome mcTirrelagh 1 quarter in the parish of Castellnoa; also of Ballyeng 1 quarter, Ballyloghan ½ quarter, Downegonewith and Lysdowne 1 quarter, lying in the parish of Castellnoa in the Toghe of Meaghan. The premises contain 
in all 4½ quarters which are valued yearly as aforesaid to be delivered as aforesaid at 5*l.* 10*s.* in money; 6 cows; 11 pecks of wheat; 11 pecks of barley malt; and 22 pecks of "oten" malt.


¶691] Edmund mcPhilipe a rebel slain in rebellion was similarly seised of Morraregan 3½ quarters in the parish of Morraregan and Toghe of Donmoylin valued yearly as aforesaid to be delivered as aforesaid at 5*l.* 6*s.* 8*d.* in money; 6 cows; 8 pecks of wheat; 8 pecks of barley malt; and 16 pecks of "oten" malt.




---

p.189


¶692] Ulicke fitz Thomas Bourgh a rebel slain in rebellion was similarly seised of 9 acres of land, Irish measure, in Lysmolande and divers other lands there: no value is assigned because they are not yet surveyed.


¶693] Morogho mcEdmonde oge mcShehie a rebel attainted of High treason was similarly seised of ½ quarter of land called Ballyferris, and another ½ quarter called Glannegoen in the parish of Castellnoa in Toghe of Meaghan: a quarter in all valued yearly as aforesaid to be delivered as aforesaid, at 1*l.* in money; 2 cows; 2 pecks of wheat; 2 pecks of barley malt; and 4 pecks of "oten" malt.


¶694] Sum of the yearly value or extent of said Traitor's lands in co. Limerick. 1128*l.* 2*s.* 5 ½*d.* in money 385*l.* 5*s.* 9 ½*d.*
  

in cows 494
  

in wheat 827 pecks
  

in barley malt 827 pecks
  

in oten malt 1654 pecks
  
.


H. Wallop
  

Valentyne Browne
  

La. Alford
  
 
Thomas Wyseman
  
 
Christofer Peyton
  

Arthur Robyns
  
.


¶695] {MS folio 80}Lands and possessions of the late Sir John of Desmonde knight and others traitors and rebels attainted of High treason in co. Cork. viz[781](javascript:footNote('E580000-001/note781.html'))


¶696] {MS folio 87d}Lands and possessions of the late Mahowne mcMoroghoe attainted in co. Cork. The castle town and land of Kylbehenny within and near the country called Clangybbon alias the Whyte Knightes cuntrye as well within the city of Cork as the city of Waterford containing by estimation 6 carucates of arable land meadow pasture underwood bog and waste extended at 4*l.* 13*s.* 4*d.* per quarter, to 28*l.*


There are divers timber woods of whose yearly value they are altogether ignorant pending a better examination.


And so the castle and premises are valued yearly as aforesaid, to be delivered as aforesaid at 28*l.*


¶697] {MS folio 88} Lands and possessions late of David Gybbon alias David Encorig, Lorde of the Greate Woode attainted. The castle called Castellnikyllygh alias Castellanykillye in the Toaghe of Kylmore alias the great woode in the parish of Shanedrome which castle with the vills lands &c belonging thereto contains 12 quarters and these at the rate of 4*l.* 13*s.* 4*d.* for every quarter of land as well 
arable as pasture meadow underwood bog and waste are valued yearly in lawful money of England at 56*l.*


¶698] Divers villates lands and tenements there in said country of Kylmore belonging to said castle and parcels and members thereof, situate in the parish of Shanedrome viz. Cowlynaghe 1 quarter, Douraghclonebro alias Couraghclonebro 1 quarter, Shanedroome 1 quarter, Garrenboy 1 quarter, Coellynagh 1 quarter, Ardagh 1 quarter, ffaydane 1 quarter, Kyldownadawen alias Ballynownane 1 quarter, Kowlemerycke 1 quarter, Nigarvan 1 quarter, Ballyntredynogh 1 quarter, amounting in all to 1 l quarters of like land 
worth yearly at 4*l.* per quarter 44*l.*


¶699] Divers other parcels lying in the County Cork as well as in the County Lymericke viz:— Kylvallynvallyshe[782](javascript:footNote('E580000-001/note782.html')) quarter, ffarrenwaterine 1 quarter, Parcke Cowlen ½ quarter, Ballysallagh ½ quarter, a moiety of Ballygrana ½ quarter and Kyllolaughtaugh ½ quarter; making of like lands 4 quarters which at the rate of 3*l.* 6*s.* 8*d.* yearly are worth 13*l.* 6*s.* 8*d.*




---

p.190


As tenant of the late Earl of Desmond as parcel of the canthreds or Toaghes in Connilogh of Ballygrynane in the parish of Ballingarry parcel of the Toaghe of Gortculligan 1 quarter which is of the clear yearly value of 4*l.*


¶700] Divers woods and underwoods in Kylmore aforesaid lie as well in Co. Corke as in Co. Lymericke, but they are far from any river and are not fit for timber. These woods and {MS folio 88d} under woods are about 8 miles in length and 3 miles in breadth but at present the are not saleable and therefore here. their value is set down at.


There are two "Eyries of Gossehawckes" which are to be reserved for the use of the Queen.


The entire premises are valued yearly as aforesaid, to be paid as aforesaid, at 113*l.* 6*s.* 8*d.*


¶701] Memorandum that the canthred or Toaghe of Kylmore before it came to the Queen's hand by attainder was charged to the Earle of Desmonde with Sorahen 2 days and 2 nights per quarter for 240 Galloglasse and as many boys if they brought any not changed among the Earl's lands because the whole country falls to Her Majesty, and here is charged only by the "plougheland."


¶702] {MS folio 92} No survey has yet been made of the following lands in co. Cork belonging to David Gybbon viz. Rahyn Ballymcrory, BallyBrown, Ballynokan, Kylbraher, Kylcolmar[783](javascript:footNote('E580000-001/note783.html')) Karrowglas, Kyltevyny, Ballynetyboret, Kylmygawragh, Ballykylegh, Garrineglanny, Currogbogg, Bolade, and Cloghnarrowly.


[784](javascript:footNote('E580000-001/note784.html'))
¶703] {MS folio 97} Memorandum that Sir John Perrott, knight, lord at Deputy, delivered to the Commissioners for further consideration the exemplification of an ancient deed[785](javascript:footNote('E580000-001/note785.html')) of which the tenor is a certain follows:— Queen Elizabeth has inspected the tenor of a certain record had, before the barons of the Exchequer {MS folio 97d} in Trinity term a.r. iij & iv Philip and Mary the tenor of which is as follows:— Memorandum that John Copinger serjeant of James 
Earl of Desmond on 27 June sought to have a certain deed inrolled the tenor of which is as follows:— Maurice son of Thomas [786](javascript:footNote('E580000-001/note786.html')) Earl
of Desmond, lord of Deysa, Ogonyll and the liberty of Kerry (Kerrigia) has granted to his son Gerauld all his messuages, lands meadows rents and services as well in lordship as demesne in the countries of Kerry Limerick, Cork, Tipperary and Waterford viz. the manors of Island, Dromoltaynwy and Dromaltaine beg alias Cogiriache, manor of Nowin, Curinyanache and Tyrnignos, Cloghirbruyn, Taulatt, Cayllbalylahyf, the vill of Dagill, Rahynibno, Kyllingleraghe, Monynyry, Ballymeolin, Kylorglyn, Dunloy, Swyllmygort, Ballyduny, Dunkyerayne, Glansyn alias Ornottedaryry, Ballycarbry.


¶704] Lochlayach, Dromcaer, in co. Kerry; Seannyd, Newcastle, Askeatyny, Moliannache in co. Limerick; Dungarvan Kepachlynroys, Ballydwayne, Ballymighchayne, Athblyard, Gortschenboyghe, Clasmor, Ballysusayne Rathonynan, Achmethan, Tylaghenan, Ballymighehan Kippachcoyne, Ballycurty, in co. Waterforord;[787](javascript:footNote('E580000-001/note787.html')) the manor of Iocally, the manor of Insycon, the lands of Ymokyllde, 
Cnokmurny, Newtown of Olyehayn[788](javascript:footNote('E580000-001/note788.html')) with other parts of Kenealtalin, Corculay, Egbeache, Eclery, Bearry and Oseste in co. Cork; the manor of Cluoynmila, Kyltilayn Guntyn intyny, Pobulonell alias Oneyoyne and Kyllieacayll in co. Tipperary; to hold to Gerald and the heirs male of his body lawfully begotten, remainder to Nicholas brother of said Gerald and the heirs male of his body lawfully begotten, like remainders. to John and Maurice brothers of said Gerald, Sir Thomas son of John, Knight, nephew of grantor, reversion to grantor and his right heirs Grantor and his heirs will warrant.


Witnesses David de Rupe, Gregory le Walshe, Thomas de Capella, Philip Stanton, Lawrence Apilgard, Robert Scurlogis. Dated at Cnokmurny 16 Jan. a.r. xvj Ed. III. ([*...*][789](javascript:footNote('E580000-001/note789.html')))




---

p.191


{MS folio 98} Exemplified by these presents Witness Sir Luke Dillon Knt, chief baron of the Exchequer at Dublin 13 May a.r. xviij Eliz. ([*...*] [790](javascript:footNote('E580000-001/note790.html')))


¶705] {MS folio 98d} Morogh Obrien late attainted of High treason was seised in his demesne as of .fee of the manor of Downcrogh alias Downgrotte[791](javascript:footNote('E580000-001/note791.html')) in the country of Arloghe alias Aharloughe in co. Tipperary viz of the rents services and other charges of the tenants as well free as customary of Downgrott aforesaid; of William mcClonedonnell mcWilliam for Drome OMarkegg; of William mcOny mac Richarde for Barrennegourry and Kealloghe in Arloughe aforesaid; of Edmond Odunta corba alias Corobery Odurty for Clonybegg[792](javascript:footNote('E580000-001/note792.html')) there; of Kennedy mcMairtogh for Tenrushe; of Murroghe mcTeige for Kylvry in Aherlo aforesaid; and for divers lands and tenements of said manor of Downgrott scattered in divers places in the district: he was also seised of the site of the manor castle vill and land of Downgrott with divers woods and underwoods belonging to the manor called Downgrott Woodes; and of the rents of Donoughe En tanaghta from the vill and lands of Galbally in said district of Aharlo; and further of perquisites of courts and other casualties, fishings "Ayerez of Gushawkes[793](javascript:footNote('E580000-001/note793.html')) and other royalties to said manor yearly incident and belonging.


These premises owing to non-attendance of officers and other persons, and non-production of rolls of court are not surveyed but are respited until better search has been made whether they are in the county of Tipperary or county of Limerick about which there is doubt, they are estimated of the yearly value of 100 marks at least as is said.[794](javascript:footNote('E580000-001/note794.html'))


¶706] {MS folio 100}*Divers religious houses as well priories or monasteries as house of friars, with lands rectories tithes fisheries 
&c thereto belonging in Munster and elsewhere concealed and detained from the Queen viz: in co. Limerick*.


The late house of the Franciscan friars of Asketon, co. Limerick. The site and house of the late Friars of Asketon near the river Deyl on the east side. The church there is totally wasted except the walls, and the buildings are in some parts ruinous. These with the churchyard, cottages, small gardens and crofts thereto belonging are of the yearly value of 2*l.*


Twelve acres lying in several crofts at 1*s.* 4*d.* per acre are worth yearly 16*s.*


In said river is a fishing of salmon, eels, and other fish belonging to said house worth yearly 10*s.*


And the entire premises are worth yearly 3*l.* 6*s.*


¶707] The late house of the Franciscan friars of Kyllshane in the parish of Ballingarry co. Lim.


The site and house of said friars are situate on a small mountain[795](javascript:footNote('E580000-001/note795.html')) within Ballyngarry parish near a small water-course the east side of the mountain. The church and buildings are in some parts ruinous and with certain gardens and small closes adjacent to the house are of the yearly value of 1*l.* 13*s.* 4*d.*


A water mill belonging to said house situate on the watercourse and at the foot of the mountain is worth yearly 10*s.*


To same house belongs divers lands, with {MS folio 100d} ten acres of low underwood of the age of 16 years, situate in the parish of Clonkath alias Clounkath one mile distant from Garrestowne alias Ballyngarry aforesaid on the west, called Kyllnemona alias Kyllnemonye estimated at half a carucate and of the yearly value 
of 2*l.*


And the entire premises are valued yearly as aforesaid, to be paid as aforesaid, at 4*l.* 3*s.* 4*d.*


¶708] The late house of Franciscan friars of Ballyniebraher, Co. Limerick.


The site and house of said friars in the parish of Kahir y wally co. Limerick distant 2 miles from Limerick on the South east, and half a carucate of land called Towehroine alias Toweghraine belonging and adjacent to said house.


The premises are valued yearly as aforesaid to be paid as aforesaid at 2*l.* 6*s.* 8*d.*




---

p.192


¶709] A house of a superstitious sect otherwise called a Termon, called Arde patricke Co. Limerick.


There is within 3 miles of Kyllmallock a Termon called Arde-patricke in which there is a house or manse (mansis) inhabited by Maurice Longean who is priest and custos there.


Divers lands belonging to said house are not yet surveyed and the entire premises for yearly value as aforesaid, to be delivered as aforesaid, are here set down as of no value because they have not been surveyed.


¶710] Lands called Sainct Patrickes Landes concealed from the Queen.


The vill and land of Kyllshiely in the small County of Limerick containing by estimation 1 quarter land now or late in the tenure or occupation of [*...*][796](javascript:footNote('E580000-001/note796.html')) called "St Patrickes Clarck" valued yearly as aforesaid at [*...*][797](javascript:footNote('E580000-001/note797.html'))


¶711] {MS folio 101} Late order or Sect of Religious men called Termons in co. Clare.


*Iniscatty*[798](javascript:footNote('E580000-001/note798.html'))


There is in the great river of Shanon an Island called Enneskea formerly chief church and house of the order or sect of St. Seanan in co. Clare. In this church are superstitious priests who maintain divers pilgrims and travellers to the images and idols of St. Patrick and like hypocrites and false saints. The chief governor of the order 
is called a corbe and his seat is in said island of Enneske; which is not valued at anything, as it was granted by the Queen to the mayor and [*...*][799](javascript:footNote('E580000-001/note799.html')) of Limerick as is said.


¶712] Divers other houses belong to this sect in the counties of Limerick and Kerry: they are called Termons alias sanctuaries and there is a priest incumbent to each of them having a manse allotted to him for his use and lands granted to him to the amount of 120 acres great measure as is said. These are their names as supplied to the commissioners on making the survey viz:—


The Termon or sanctuary called Knockepatricke containing a temple and a small house built on the west side of the temple, both in ruin and decay both in roof and tiles. To this belongs the diabolical pilgrimage to Patrick alias St Patricke situate with the church on the highest point of the very lofty mountain[800](javascript:footNote('E580000-001/note800.html')) of Knockepatricke in the parish of Bally Roberte in the country of Connelo. This termon, with 140 acres of land lying around and adjacent to the church, is of the yearly value of 4*l.* 13*s.* 4*d.*


There belongs to same [*...*][801](javascript:footNote('E580000-001/note801.html')) of a certain mine of coals called Seacole[802](javascript:footNote('E580000-001/note802.html')) within said land, but the coals have not been yet tested, of the yearly value of 13*s.* 4*d.*


There was also there a yearly fair held for the space of 2 days commencing on St.Patrick's day in Autumn of the yearly value of [*...*].[803](javascript:footNote('E580000-001/note803.html'))


And so the termon of Knockepatrick aforesaid is, in toto, worth yearly of like money 5*l.* 6*s.* 8*d.*


¶713] The Termon or Sanctuary of Ballywaloghan][804](javascript:footNote('E580000-001/note804.html')). There is in co. Limerick another Termon or Sanctuary upon which there is now no building having land Ballywologhan situate near the land of Glancorobry {MS folio 101} called the Glan alias the Glyn lately belonging to Thomas mcRuddery commonly called the "Knighte of the vallye" attainted, in he country of Connello: it abuts on one side to the river Kyllwearelye[805](javascript:footNote('E580000-001/note805.html')) which is the boundary between Kerry and Limerick, and on a other adjoins the Shanon Sea. The said Tarmon contains, on view and measurement of same 140 acres which is worth yearly 2*l.* 6*s.* 8*d.*


And so there is payable yearly as foresaid in respect of Enneske and the following Termons 7*l.* 13 s 4*d.*


¶714] The religious house or Termon of Weste Shannova[806](javascript:footNote('E580000-001/note806.html')) within 2 miles of Tarbert Castle, Co. Kerry. There belongs to the church of Ennesky another Termon sanctuary with the vill or villate called 



---

p.193




Weste Shannova. In this Termon was a principal priest called a Custos (the last of the order there still lives and is called Cahell oge) with 12 other priests. This custos lives at Kyllrushe in the country of Korkervarsken Earagh in Toomonde co. Clare. To same Termon belong other vills and villates viz Ballynesaggarte, Gortynnetagell, Karoogaroof and Ballyniknock containing in all by estimation 2½ carucates, valued yearly as aforesaid to be paid as aforesaid at 6*l.* 13*s.* 4*d.*


¶715] [807](javascript:footNote('E580000-001/note807.html'))The religious house or cell of Nefelaughe in Slewlogher in the counties of Limerick and Kerry belonging to the late Monastery of Nenoghe co. Limerick.


The site and religious house still standing but in decay for want of repair are situate on the north of Brasnough on Slewlogher mountain near the castle of Portrenard other "the fforte of the three enemyes" in the parish of Nefelagh. The precinct of said house with church, churchyard, and the gardens and crofts thereto belonging contains by estimation 10 acres of the yearly, value of 1*l.* 3*s.* 4*d.*


{MS folio 102} To said house belong 4 quarters of land in Slewlogher mountain of the yearly value of 5*l.* 6*s.* 8*d.*; a very good salmon fishery on the river Pheale adjoining said house of the yearly value of 1*l.*


And the entire premises are valued yearly as aforesaid, to be paid as aforesaid at 7*l.* 10*s.*


¶716] {MS folio 104d}Lands belonging to the Abbey of Oyhny alias Wony lying in co. Kerry.


These lands[808](javascript:footNote('E580000-001/note808.html')) are in the vill of Dromanagh[809](javascript:footNote('E580000-001/note809.html')) containing [*...*][810](javascript:footNote('E580000-001/note810.html')) Ballynelekan [*...*][811](javascript:footNote('E580000-001/note811.html')) Kappaghffaghy[812](javascript:footNote('E580000-001/note812.html')) [*...*][813](javascript:footNote('E580000-001/note813.html')) Cloresheragh [*...*][814](javascript:footNote('E580000-001/note814.html')) and Ballyadoine[815](javascript:footNote('E580000-001/note815.html')).


Not set down of any value because they have not been surveyed.


### Index of Persons and Places in Clancarthy Survey (Only)

Every attempt has been made to identify the place-names and the editor has acted on the principle that a faulty suggesion is better than none at all. Identifications given are modern equivalents of the name forms occurring in the text: the location and extent of any sixteenth-century denomination may be different from its present-day counterpart. Variants found in the text are given in their appropriate alphabetical position, with reference to the forms under which they are indexed. Unless otherwise indicated, all names are in Co. Kerry. All references are to numbered sections of the text. See Introduction, second last paragraph. Where identification is established or suggested, a parish reference in round brackets appears after the name form.
A


1. ABBEY ISLAND (Kilcoman par.), 122n
2. AGHADOE, AHADO (par.), archdeacon of, 120; arch deaconry of, 120; par. of, 3
3. AGHAMORE, AHAMORE, abbey of (Abbey Island in Kilcolman par.), 122, 122n
4. AGLASYDONNIN, see Aglish
5. AGLISH, AGLASYDONNIN (Aglish par.), 3
6. AHADO, see Aghadoe
7. AHAMORE, see Aghamore
8. AHANE (Kilbonane par.), 3
9. AHGROM, see Ardgroom
10. ANAHILE, see Annaghilymore
11. ANGLONT (Killorglin par.), 64
12. ANNAGHILYMORE, ANAHILE (Aghadoe par.), 6
13. ARDAGH, ARDOGH (Killarney par.), 4
14. ARDCANAGH, see Ardcanaght
15. ARDCANAGHT,ARDCANAGH (Killgarrylander par.), 53, 54


---

p.194

18. ARDCOST, ARDCOSTE (Ki11emlagh par.), 91
19. ARDCOSTE, see Ardcost
20. ARDGROOM, AHGROM (Beara bar., Co. Cork), haven of, 13
21. ARDMEELODE, ARDMELOD (Kilcolman par.), 43
22. ARDMELOD, see Ardmeelode
23. ARDOGH, see Ardagh
24. ARDTULLY (Kilgarvan per.), 26



B


1. BALLEGRIFFIN, see Ballygriffin
2. BALLICARBRY, see Ballycarbery
3. BALLICASTLANE, see Castletownbearehaven
4. BALLIDOUNY, see Ballydowny
5. BALLIESPILLANE, see Ballyspillane
6. BALLIGRIFFIN, see Ballygriffin
7. BALLIHARE, see Ballyhar
8. BALLIHERNYMORE, see Ballyhearny
9. BALLIHERNYYRRAH, see Ballyhearny East
10. BALLIMACGILLENEULAN, see Ballynabloun
11. BALLIMANAH, see Ballymanagh
12. BALLINCARRIG, see Ballynacarrig
13. BALLINEHOW, see Ballynahow
14. BALLINEMAH, see Ballymalis
15. BALLINPRIOR = ? Ballymacprior, q.v.
16. BALLINSHINE (?) (prob. Killarney par.), 4
17. BALLINSKELLIGS, BALLINSKELLIG, BELLINSKELLIG (Prior par.), haven of, 81; prior of 118; priory of, 118
18. BALLITRASNEH, see Ballytrasna
19. BALLMEMAH, see Ballymalis
20. BALLYBERANE, see Ballicarbry, castle and lands of (Caher par.) 5, 6, 8, 11
21. BALLYDONEGAN, CARROW-DONIGAN, (Kilnamanagh par., Beara bar., Co. Cork), 117, 117n
22. BALLYDOWNY, BALLIDOUNY Aghadoe par.), 32
23. BALLYGRIFFIN, BALLEGRIFFIN, BALLIGRIFFIN (Kenmare par.), 69, 69n
24. BALLYHAR BALLIHARE (Kilcredane par.), 3
25. BALLYHEARNY, BALLIHERNY-MORE (Valentia Is. par.), 50
26. BALLYHEARNY EAST, BALLIHERNYYRRAH (Valentia Is. par.), 50
27. BALLYMACPRIOR (Killorglin par.) = ? Ballinprior, 89
28. BALLYMALIS, BALLINEMAH, BALLMEMAH, BEALAM-ALAGHBEG, BELAMALAH (Kilbonane par.), 41, 41n, 89
29. BALLYMANAGH, BALLIMANAH Valentia Is. par.), 108
30. BALLYNABLOUN,BALLIMAC-GILLENEULAN (Killemlagh par.), 12, 12n, 100
31. BALLYNACARRIG, BALLINCARRIG (Aglish par.), 6
32. BALLYNAHOW, BALLINEHOW (Killinane par.), 37
33. BALLYSPILLANE, BALLIESPILLANE (Killfarney par.), 32
34. BALLYTRASNA, BALLITRASNEH (Aglish par.), 6
35. BALLYVIRRANE, BALLYBERANE (Kilcolman par.), 64
36. BANTRY, Co Cork, barony of, 77; country of, 33, 72n; mountains of, 2
37. BARENESNA,see Barnasna
38. BARLEYMOUNT, KNOCK-HORNOGHT (Aglish par.), 53, 53n
39. BARNASNA, BARENESNA (Killarney par.), 86
40. BARNASTOOKA, BARNESTOIG (Kilgarvan par.), 27
41. BARNESTOIG, see Barnastooka


---

p.195

44. BASLEKAN, see Baslickane
45. BASLICKANE, BASLEKAN (Kilcrohane par.), 80
46. BEALAMALAGHBEG, see Ballymalis
47. BEALAMALAH, see Ballymalis
48. BEALINCHE, see Valentia
49. BEAR, BEARA, BEARE (bar. Co. Cork), 72, 72n, 73, 74, 75, 75n; barony of, 116, 116n, 117, 117n; country of, 33, 111; island, 75n;: 
 muntains of, 2; see also O'Sullivan
50. BEAREHAUEN, BEARHAUEN (Bear bar., Co. Cork), castle of, 110; fishings in, 76, 112
51. BEARHAUEN, see Bearehaven
52. BEGENNIS, see Beginish
53. BEGINISH, BEGINNIS (Caher par.), fishing in haven of, 11, 11n
54. BELLINSKELLIG, see Ballinskelligs
55. BLACKWATER, River, 2
56. BODOMESMEN, BODOMESMIN, BODOMISMIN (prob. Knockane par.), castle of 102; fishings of, in river Laune, 106, 106n
57. BOLUS (Killemlagh par.), 12, 100
58. BORD EOGHAIN FHINN, BORDONINE (Sneem to Caherdaniel district), 106, 106n
59. BRACARAH, see Brackaharagh
60. BRACKAHARAGH, BRACARAH (Kilcrohane par.), 105
61. BRAY, see Brinemikane
62. BRINEMIKANE (prob = Bray, Valentia Is. par), 61, 61n
63. BROWNE, Nicholas, his account of Munster in 1597, 49n; fishings in possession of, 11. Sir Valentine, lands mortgaged to, 5
64. BURGHLEY, Lord, 90n



C


1. CARER, CARECRHON (Aghadoe par.), 32
2. CARER, CAREOGERRANE (Kilgarvan par.}, 104
3. CAHERCWYN, see Caherkeen
4. CAHERDANIEL, CAREDONEL-MORE (Kilcrohane par.), 105
5. CAHEREN, see Carhan
6. CAHERKEEN, CAHERCWYN, CARECHIM (Kilcatherine par., Bear bar., Co. Cork), 116, 116n
7. CAHERNANE, CAREHENNANE, (Killarney par.), 4
8. CAHERSIVEEN, CARESIUIN (Caber par.), 108
9. CANBURREN, see Canburrin
10. CANBURRIN, CANBURREN (Caber par.), 47
11. CANFANED (?) (Castlelogh district of Killarney par.), 6
12. CANMARRA, see Kenmare River
13. CANNEH, see Kineigh
14. CAPPAGH, KIPPAH (Killinane par.), 60
15. CAPPAGHNECOSHE, see Cappanacush
16. CAPPAGHRO, see Capparoe
17. CAPPAGHRUSH (?) (Kilcrohane par.), 105
18. CAPPAHNECOSHE, see Cappanacush
19. CAPPANACUSH, CAPPAGHNECOSHE, CAPPAHNECOSHE (Templenoe par.) 92, 101
20. CAPPAROE, CAPPAGHRO (Templenoe par.), 92
21. CARAGH, CAREH, LOGHCARE, Lough or Lake, 9, 66, 98n; river, 66, 98n
22. CARECHIM, see Caherkeen
23. CARECREHON, see Caher
24. CAREDONELMORE, see Caherdaniel
25. CAREH, see Caragh


---

p.196

28. CAREHENNANE, see Cahernane
29. CAREOGERRANE, see Caber
30. CARESIUIN, see Cahersiveen
31. CARHAN, CAHEREN (Caber par.), 6
32. CARRANE, see Currane
33. CARRICKYPHREAN, see Carrigafreaghane
34. CARRIGAFREAGHANE, CARRICKYPHREAN (Killarney par.), 4
35. CARROWCLANLOGHLEN, see Cloonaghlin
36. CARROWCORMOCK (?)(Duhallow bar., Co. Cork), 12
37. CARROWDONIGAN, see Ballydonegan
38. CARROWNECORRE, prob = COARS (Killinane Par.), q.v.
39. CASTLELOGH, see Castlelough
40. CASTLELOUGH, CASTLELOGH, CASTLE OF THE LOGH (Killarney par.), 4; lands of, 6; fishings belonging to, 10
41. CASTLEQUIN, CLOHANMACCUIN (Caber par.), 52, 52n
42. CASTLETOWNBEAREHAVEN, BALLICASTLANE, 74
43. CLANCAR, see Clancarthy
44. CLANCARTHY, CLANCAR, CLANCARTIE, CLANCARTY, CLANCARTYE, earl of, l, 11 n, 12, 15, 16, 17, 19, 20, 21, 26, 27, 28, 29, 30, 31, 63, 72n, 78n, 104, 118, 119, 120, 121; at meat, 115; carriages of, 115; companies of, 33; cuddies paid unto, 82, 110; demesnes of, 3-8; duties payable to, 1, 13; fishings belonging to his castles, 9 11; journey of, 115; lands claimed by, 12; lands free from, 83; passing through lands, 71, 78; septs of: O'Sullivans commonly at war with, 91; sorrens of Duhallow due to, 123; tenants of, 22; weakening sought by O Sullivan septs, 91; wine of, 44; wife 
of earl, or countess, 3, 23; fishings in possession of, 9; her horses, 21; see also MacCarthy
45. CLANDERMONDE, lands of, 67-76
46. CLANDONELL ROE, lands of, 77-8
47. CLAN DONNELL FUN, lands of, 34-43
48. CLANLAURAS: lands of, 114-15; eldest of Sept, 115
49. CLANLOGHLEN (? Kilgarvan district), 28
50. CLAN TEGE KETTAGH, lands of, 58
51. CLARKE, Alexander, 78n
52. CLEENY, CLINE (Aghadoe par.), 32
53. CLINE, see Cleeny
54. CLOGHANELINAGHAN, CLOHANLINOGHAN (Caher par.), 6
55. CLOHANLINOGHAN, see Cloghanelinaghan
56. CLOHANMACCUIN, see Castlequin
57. CLONEYSTY, see Cluonisty
58. CLOONAGHLIN, CARROWCLANLOGHLEN (Dromod par.), 91
59. CLUONISTY, CLONEYSTY (Aghadoe par.), 3
60. COAD, COED (Kilbonane par.), 105
61. COARHABEG, COREBEG (Valentia Island par.), 61
62. COARHA MORE, COREMORE (Valentia Island par.), 50
63. COARS, CARROWNECORRE (Killinane par.), 36, 36n
64. COED, see Coad
65. COME, see Coom
66. COMEEGOGNACAPLE, COMEGOGNACAPLE, see Kimego
67. COOL E. and W., COUL (Valentia Island par.), 62
68. COOLCLOGHER, KILCLOHER (Killarney par.), 4
69. COOLGARRIV, COULGARRUF (Aghadoe par.), 32
70. COOLMAGORT, COULMAGORT (Knockane par.), 95
71. COOLROE, COULRO (Knockane par.), 103, 103n


---

p.197

74. COOM, COME (Prior par.), 91, 91n
75. CORBALLY (Killorglin par.), 64
76. CORCK, CORCKE, see Cork
77. COREBEG, see Coarhabeg
78. COREMORE, see Coarhamore
79. COREMORE (?) (prob. Kenmare par.), 68, 68
80. CORK, CORCK, CORCKE, merchant from city of, 11, 11n; county of, 2, 12, 33, 72, 73, 74, 75, 77, 123
81. CORMOCK OF DOUNGUILL, Slughte, 59
82. CORRANE, see Currane
83. COSHGLANOURAGH (?) (Pallis district of Killarney), 6
84. COSHMANG, lands in, 79-84, 85n; explanation of, 82n
85. COUL, see Cool E. and W.
86. COULAGH, COULEH, COWLAGH (Kilcatherine par., Bear bar., Co. Cork), 116, 116n
87. COULEH, see Coulagh
88. COULGARRUF, see Coolgarriv
89. COULMAGORT, see Coolmagort
90. COULMUCKY (?) (Pallis district, Aghadoe/Kilbonane par.), 3
91. COULRO, see Coolroe
92. COWLAGH, see Coulagh
93. CREGGEEN, CREGGY (Kilgarvan par.), 30
94. CREGGY, see Cregeen
95. CROHANE (Aghadoe par.), 3
96. CULLEENY, KILLINE (Kilbonane par.), 89, 89n
97. CURRANE, CARRANE, CORRANE, Lough (LOCHLEIGH, LOUGH LEEAGH), 11n, 48; river, 11, 11n, 81
98. CURRANS (par.), 83n



D


1. DAGARRAN, see Garranearagh, Garranebane
2. DA KILCOMANAN, see Kilcoman
3. DARAH, see Derrynane
4. DARIRY, see Valentia
5. DARRYNANE, DARAH (Kilcrohane par.), 105
6. DATIREOMOIL, DATIREOUIOIL, see Teeromoyle
7. DENNY, Thomas, lands mortgaged to, 7; fisliings in possession of, 11
8. DERIKIUIN, see Derrycreeveen
9. DERIN, see Derreen
10. DERREEN, DERIN, (Caher par.), 108
11. DERRIKYVYNE, see Derrycreeveen
12. DERRYCREEN, DERIKIUIN, DERRIKYVYNE, DERRYKIVINE, (Killaconenagh par., Bear bar., Co. Cork), 75, 75n
13. DERRYKIVINE, see Derrycreeveen
14. DESMOND, DESMOUND, country of, 1; divisions of, 2; earl of, 19, 54; lords and freeholders in, 13; mountains of, 18; sheriff of, 11n
15. DONELL BRIC, Slughte, 49, 49n
16. DOOAGHS, DOWEH (Killorglin par.), 64, 64n
17. DOOCARRIG, DUFFCARRIG (Kilcummin par.), 79
18. DOONKINANE, DOWNKINAN (Aglish par.), 3
19. DORSES, see DURSEY
20. DOUGLAS, DOWGLAS, river, fishings on, 109, 109n
21. DOUNGUIL, DOUNGUILL, see Dungeel


---

p.198

24. DOUNKERRAN, see Dunkerron
25. DOUNLO, see Dunloe
26. DOWALLA, see Duhallow
27. DOWEH, see Dooaghs
28. DOWGLAS, see Douglas
29. DOWNKERRAN, see DUnkerron
30. DOWNKINAN, see Doonkinane
31. DROMANAHIN, see Dunmaniheen
32. DROMCUINEH, see Dromcunnia
33. DROMCUNNIA, DROMCUINEH (Templenoe par.), 94, 94n
34. DROMDAGOUR (?) (prob. Kenmare par.), 58
35. DROMED, see Dromod
36. DROMEN, see Dromin
37. DROMIN, DROMEN (Killorglin par.), 64
38. DROMKEARE, DROMKEREH (Dromid par.), 46,
39. DROMKEREH, see Dromkeare
40. DROMKERRY (Kilbonane par.), 3
41. DROMOD, DROMED (Dromod par.), 91, 101
42. DROMYROURK, DROMOURCK (Killarney par.), 4
43. DUFFCARRIG, see Doocarrig
44. DUHALLOW, DOWALLA (bar., Co. Cork), 12, 12n, 123
45. DUNGEEL, DOUNGUIL, DOUNGUILL (Killorglin par.), lands of Slughte Cormock of, 59-65; ploughland in, 64
46. DUNKERRON, DOUNKERRAN, DOWNKERRAN, bar. of, 2, 92-99, 102, 103, 105, 122; bay of, 33n, 106, 113; castle of (Templenoe par.) 92n; lands of (Templenoe par.), 92, 101
47. DUNLOE, DOUNLO (Knockane par.), 3n; castle of, 96; lands of, 96, 101; quarters of, 97
48. DUNMANIHEEN, DROMANAHIN (Killorglin par.), 64, 64n
49. DURSEY, DORSES (Bear bar., Co. Cork), excellent fishings of, 112



E


1. EIGHTERCUA, KILEUTERCO (Kilcrohane par.), 45, 45n
2. ELIZABETH I ('her majesty'), lands forfeit to, 78, 84, 86
3. ENGLAND, fishermen from west of, 112
4. ENISFALLEN, see Inisfallen
5. EOGHANACHT, see O Donoghue
6. ERELAGH, ERELAHBEG, see Muckross



F


1. FAHA, E. and W. PHAAH (Kilbonane par.), 40, 40n
2. FARREN-CORMOCKE, see Farrencormuck
3. FARRENCORMUCK, FARREN-CORMOCKE (Aghadoe par.), 3
4. FARTAGH, FARTAH, see Ferta
5. FEAGHMAAN, FEUHMA (Valentia Island par.), 62
6. FENTON, Edward, 3n, 90n
7. FERMONYHARNETT, see Termonyharnett
8. FERTA, FARTAGH, FARTAH, river 11, 44, 63
9. FEUHMA, see Feaghmaan
10. FINNE, see Inny and Tinnies
11. FINNIN DUFF, Slught, 53
12. FLESK, FLISK, FLISKE, River, 10, l0n, 86, 86n, 88





G


1. GARRENEARAGH and GARRANEBANE = DAGARRAN (adjoining tds. in Caher par.) 108, 108n


---

p.199

4. GARRIDUFF (?) (Pallis district, prop. Aghadoe par.), 44
5. GARTINRO, see Gortroe
6. GLANBEHY, GLANUEHE (par.), 98n, 99
7. GLANCARE, see Glencar
8. GLANEROUGHT, GLANOROGHTO, half barony of, 2, 26 30, 33, 55, 56, 58, 67-70, 104; mining in, 33n
9. GLANFLISK, see Glenflesk
10. GLANLEAM, GLANLIM (Valentia Island par.), 51
11. GLANLIM, see Glanleam
12. GLANLY (?) (prob. Kilgarvan par.), 29
13. GLANUEHE, see Glanbehy
14. GLANURCAN, see Gleann Orcáin
15. GLEANN ORCÁIN, GLANURCAN (western part of Killemlagh par.), 12, 12n
16. GLENCAR, GLANCARE (southern part of Glanbehy par.), 98, 98n
17. GLENFLESK, GLANFLISK (Killaha par.), lands of, 87, 87n
18. GÓILÍN, AN(GOLIN, River), 11, 11n, 109
19. GOILIN, see Góilín
20. GORTAGASS, GORTAGAS (Kenmare par.), 55, 55n, 56, 58, 67
21. GORTAMULLIN, GORTEWOLLIN (Templenoe par.), 92
22. GORTDERG, see Gortderrig
23. GORTDERRIG, GORTDERG (Kilcummin par.), 79
24. GORTEWOLLIN, see Gortamullin
25. GORTNAGANE, GORTNEGAN (Kilcummin par.), 79
26. GORTNECLOHE, see Rockfield
27. GORTNEGAN, see Gortnagane
28. GORTROE, GARTINRO (Aghadoe par.), 3
29. GORTYNINEBRIAN (?) (Killarney par.), 4
30. GOULAN, see Gowlanes
31. GOWLANES, GOULAN (Kilcrohane par.), 105
32. GRENAGH, TWOGH GRENOGHT (Aghadoe par.), 3, 3n
33. GUISSIDINE, see Gweestin
34. GWEESTIN, GUISSIDINE, River, 44



H


1. HEADFORT, LISNEGAN (Aghadoe par.), 79
2. HERBERT, Sir William, 12n, 33n, 123n
3. HUMBERSTON, HUMBERTON, William, lands mortgaged to, 7; fishings in possession of, 11



I


1. INCHES, NYINCHE (Kilcatherine par. Bear bar., Co. Cork), 73
2. INNISFALLEN, ENISFALLEN (Aghadoe par., island in), priory of, 119
3. INNY, FINNE, River, 48, 48n, 101, l0ln
4. IRRELAGH, see Muckross
5. IURAGHA, see Iveragh
6. IVERAGH, IURAGHA, YURAHA, bar. of, 2, 31, 34-37, 44-46, 49-52, 59, 60, 62, 80-81, 91, 100, 108, 118



K


1. KEAMCRY, see Keankerry
2. KEANKERRY, KEAMCRY (Aghadoe par.), 3
3. KENMARE, mining in district of, 33n


---

p.200

6. KENMARE, CANMARRA, river and haven of, 33, 33n, 71, 101
7. KENMARE and KENMARE OLD, prob. = NIDDIN (tds. in Kenmare par.), 55
8. KERRY, county of, 2
9. KILBEG (Valentia Island par.), 7
10. KILBONANE, KILVENAN (Kilbonane par.), 89
11. KILCATHERINE, KILCATTYEREN, KILKATEREN (td. in Kilcatherine par. Bear bar., Co. Cork) 116, 116n
12. KILCLOGHERANE, KILCLOHERAN, KILCLOKERAN (Kilbonane par.), 3, 3n
13. KILCLOHER, see Coolclogher
14. KILCLOHERAN, see Kilclogherane
15. KILCLOKERAN, see Kilclogherane
16. KILCOAN, see Kilquane
17. KILCOLMAN, KILLAGHA, KILLAHA, KILLALA (Kilcolman par.), abbey of, 44, 83, 83n, 121; abbot of, 121
18. KILCOMAN, DA KILCOMANAN (Caher par.), 108, 108n
19. KILCRINERY (?) (Kilbonane par.), 107
20. KILEGY, see Killegy
21. KILEMELAGH, see Killeenleagh
22. KILEUTERCO, see Eightercua
23. KILKATEREN, see Kilcatherine
24. KILKEAVERAGH, KILKEUERAH (Killemlagh par.), 108
25. KILLAGHA, see Kilcolman
26. KILLAHA, see Kilcolman
27. KILLALA, see Kilcolman
28. KILLARNEY, 3n, 90n
29. KILLASSERA, KILSARA (?) (prob. Kenmare par.), 56, 56n
30. KILLEENLEAGH, KILEMELAGH (Dromod par.), 91, 91n
31. KILLEGY, KILEGY (Killarney par.), 6
32. KILLELAN EAST, KILLELANTIR (Caher par.), 5, 5n
33. KILLELAN WEST, KILLELANTERE (Caher par.), 5, 5n
34. KILLELANTERE, see Killelan West
35. KILLELANTIR, see Killelan East
36. KILLELELIG, see Killoluaig
37. KILLINE, see Culleeny
38. KILLINNE (?) (poss. = Killowen in Kenmare par.), 70
39. KILLINROMANO, see Kilnarovanagh
40. KILLMEANACH, see Kilnamanach
41. KILLOE, KILLOEH (Caher par.), 108
42. KILLOEH, see Killoe
43. KILLOGNAVEEN, KILOGNAUIN (Killinane par.), 37
44. KILLOLUAIG, KILLELELIG (Killemlagh par.), 12, 100
45. KILLONCHAA, see Killonecaha
46. KILLONECAHA, KILLONCHAA (Killemlagh par.), 91
47. KILLOWRAN (?) (Pallis district of Killarney), 3
48. KILLURLY, KILURLY (Killinane par.), 59
49. KILMACKERIN, see Kilmackerrin
50. KILMACKERRIN, KILMACKERIN (Dromod par.), 91
51. KILMACKOWEN, KILMACOWEN (Upper valley of Eyeries river, Bear bar., Co. Cork), 72
52. KILMACOWEN, see Kilmackowen
53. KILMAKILLOGUE, KILMALLOCKOSHISTA (Tuosist par.), 2, 2n
54. KILMALLOCKOSHISTA, see Kilmakillogue


---

p.201

57. KILMANNEH, see Kilnamanagh
58. KILMICHEL, KILMICHIL (?) (prob. Kenmare par.), 70, 70n
59. KILMORE (?) (Pallis district of Killarney), 65
60. KILNAMANAGH, KILMANNEH, KILLMEANACH (par. of, Bear bar., Co. Cork), 117, 117n
61. KILNAROVANAGH, KILLINROMANO (Kilbonane par.), 39
62. KILOGNAUIN, see Killognaveen
63. KILQUANE, KILCOAN (Kilcummin par.), 79
64. KILSARA, see Killasserah
65. KILURLY, see Killurly
66. KILVENAN, see Kilbonane
67. KIMEGO E. and W., COMEEGOGNACAPLE, COMEGOGNACAPLE (Caher par.), 5, 5n, 52
68. KINEIGH, CANNEH (Dromod par.), 91
69. KIPPAGHDELLIG (?) (Pallis district of Killarney), 3
70. KIPPAGH, see Cappagh
71. KIPPAHYLIN (?) (Pallis district of Kilarney), 3
72. KNOCKASARNET, KNOCKEFARNET, KNOCKNESARNET (Aghadoe par.), 32, 32n
73. KNOCKENOUR (?) (Castlelough district of Killarney), 4
74. KNOCKGOUR, KNOCKNEGOURGAL (not td. name in Beara peninsula, Co. Cork), 117, 117n
75. KNOCKHORNOGHT, see Barleymount
76. KNOCKNEFARNET, see Knockasarnet



M


1. MACAULIFFE, MAC AULEIF, MACAUNLIEF, 123, 123n
2. MACCARTHY, MACCARTIE, MACCARTY, MACCARTYE, freeholders inimical to sept of, 59;
3. —,MÓR, MOORE, MORE, 12, 12n; freeholders descended from the house of, 26
4. —, Donel, Donell, son of earl of Clancarthy, 6, 11
5. —, Donogh, brother of earl of Clancarthy, 8
6. —, Florence, son-in-law of earl of Clancarthy, 4, 10,
See also Clancarthy
7. MAC CRAGH, Slught, 93
8. MAC CREHON, lands of, 107
9. MAC DONOGH, 123, 123n
10. MAC FINN, lands of, 26
11. MAC FINN DUFF, lands of, 113
12. MAC GILLECUDDEH, see Gillicuddy
13. MACGILLENEULAN, lands of, see Ballynabloun
14. MACGILLICUDDY, MAC GILLECUDDEH, lands of, 102
15. MACRURY, Slught, 103, 106, 106n
16. MAC TEGE NE TOUGH, 49, 49n
17. MAGONNY, see Maguinihy
18. MAGUNIHY, MAGONNY, barony of, 2, 21, 32, 38-44, 53, 64-6, 79, 82, 83, 85, 87, 89, 107, 119-121
19. MAINE, MANG, River, 2, 54, 83, 83n
20. MAJESTY, MAJESTIE, Her, see Elizabeth I
21. MALEN, see Maulin
22. MANG, see Maine
23. MASHANAGLASHY, see Mashanaglass
24. MASHANAGLASS, MASHANAGLASHY (Aghinagh par., Muskerry East bar., Co. Cork), castle and lands of, 12


---

p.202

27. MAULIN, MALEN (Dromod par.), 91
28. MEAGH, MEAUGH, MYAGHE, James, 11, 11n
29. MEAUGH, see Meagh
30. MOCKRUSH, see Muckross
31. MOLAHIFFE (par. in Magunihy bar.), 83n
32. MUCKENNAGH (?), 3
33. MUCKROSS, MOCKRUSH, ERELAGH, ERELAHBEG, OIRBHEALACH, IRRELAGH (Killarney par.), 4, 4n
34. MUNSTER, tracts on, 12n, 49n, 123n
35. MURRIS, Slught, 89
36. MUSKERRY, MUSKRY (bar. of, Co. Cork), 12
37. MUSKRYLOGHER (Sliabh Luachra area on Cork Kerry border), 79, 79n
38. MYAGHE, see Meagh



N


1. NEFARRENNECAREH (?) (Currans/Molahiffe par.), 83, 83n
2. NIDDIN, see Kenmare, Kenmare Old
3. NIDDIN, Slught, 55
4. NINERUDRIS, Slughte, 45
5. NYINCHE, see Inches



O


1. O CALLAGHAN, O KALLOGHAN, 123, 123n
2. O DONOGAN, land of, 117
3. O DONOGHO, see Onaught
4. O DONOGHO GLENFLESK, lands of, 87-8O
5. O DONOGHO MÓR, lands of, 85-6
6. O DONOVAN, lands of, 2
7. OGHTOCROSSY (?) (Kilgarvan par.), 27
8. O KALLOGHAN, see O Callaghan
9. O KEEFFE, O KEIF, 123, 123n
10. O LEARY, lands of, 2
11. O LINCHE, lands of, 116
12. ONAUGHT (EOGHANACHT) O DONOGHO, lands of, 85
13. ORMOND, Thomas Butler, 10th Earl of, 3n
14. ORMOND'S Island (Kenmare River), 33n
15. O SULLIVAN, O SULIUAN, OSULLIUAN, OSWILIUAN,
16. —, sept of. 91-117
17. —, Beare, 72n; lands of, 110-12
18. —, Mór, 92n;lands of, 91-101
19. OWEN MORE OF COSHMANG, Slught, 79



P


1. PALLICE, see Pallis
2. PALLIS, PALLICE (Aghadoe par.), 3, 3n, 6, 9, 44
3. PELHAM, Sir William, 3n
4. PETTY, Sir William, 33n
5. PHAAH, see Faha



R


1. RAHMORE, see Rathmore
2. RATHMORE, RAHMORE (Kilcummin par.), 79
3. REENARD, RINEARDOGH (Caher par.), 108


---

p.203

6. REENCAHERAGH, RINECARAH (Killemlagh par.), 108
7. RENURROIJNE, see Rinneen
8. RINEARDOGH, see Reenard
9. RINECARAH,see Reencaheragh
10. RINNEEN (prob. = Renurroune) (Kilcrohane par.), 31, 31n
11. ROCKFIELD, GORTNECLOHE (Kilbonane par.), 6, 42, 42n
12. ROGHTO, see Roughty
13. ROSNACARTAN, ROSNECARTEN (Kilbonane par.), 3
14. ROSSMORE Island (Kenmare River), 33n
15. ROUGHTY, ROGHTO, River, 33, 57, 71, 104



S


1. ST. LEGER, Sir Warham, 90n
2. SENAGHRO, see Shinnagh
3. SESKENAN, see Sheskenane
4. SHESKENANE, SESKENAN (Upper Inny district, Dromod par.), 49, 49n
5. SHINNAGH, SENAGHRO (Nohovaldaly par.), 79
6. SLEUGHLOGHER, see Sliabh Luachra
7. SLEUNECOLLO (?) (poss. Templenoe par.), 101
8. SLIABH LUACHRA, SLEUGHLOGHER (mountain-moor land on Cork, Kerry, Limerick border), 2
9. SROWGRENE, see Srugreena
10. SRUGREENA, SROWGRENE (Killinane par.), 60



T


1. TARMONYHARNET, see Termons
2. TAUR, see Toor
3. TEERAHA, TIRAA (Kilinane par.), 8
4. TEEROMOYLE, DATIREOMOIL, TIREMOILTOIG, TIREOMOILEAS, (Killinane par.), 34, 34n
5. TERMONIRRAH, see Termons
6. TERMONS, TARMONYHARNET, TERMONIRRAH, TERMONYHARNETT (Dromod par.), 6, 6n, 47, 47n
7. TERMONYHARNETT, see Termons
8. TINNE, see Tinnies
9. TINNIES, TINNE, FINNE (Valentia Island par.), 62, 62n
10. TIRAA, see Teeraha
11. TIREOMOILEAS, see Teeromoyle
12. TIREMOILTOIG, see Teeromoyle
13. TOOR, TAUR (Kilcrohane par.), 80
14. TUATH Ó SIOSTA, TUOSIST (par. in Glanerought bar.), 2n
15. TULLA, see Tullig
16. TULLIG, TULLAGH (Killarney par.), 32
17. TWOGH CLANIHE (?) (Killorglin/Knockane ps.), 103
18. TWOGH GRENOGHT, see Grenagh



V


1. VALENCIA, see Valentia
2. VALENTIA, VALENCIA, BEALINCHE, DARIRY, haven of, 7, 7n, 11, 63, 101, 109; island of, 6, 7, 50, 51, 61, 62; see also Beginish and Góilín



W


1. WALSINGHAM, Sir FrancIs, 3n, 33n





---

p.204


Y


1. YURAGHA, see Iveriagh



### INDEX OF SUBJECTS

### A


1. ABBEYS, Aghamore, 122, 122n; Killagha, 44, 83, 83n, 121
2. ABBOT, of Killogha, 121
3. ALE, 17, 87
4. AQUAVITAE, 17
5. ARCHDEACON, ARCHDEACONRY, of Aghadoe, 120
6. ASH TREES, 88
7. ATTAINDER, of freeholders, 84, 86
8. AXES, 19



B


1. BARRELS, of beer or ale, 87
2. BEEF, BEEVES, 26-30, 38-42, 45-7, 49-52, 55-56, 58-62, 64, 67-70, 102, 104, 107, 122
3. BEER, 87
4. BLACK RENT, 18
5. BREAKFAST, 82
6. BUTTER, quirrens of, 16, 24-25, 34-38, 45-47, 53, 65, 82, 85, 89, 91, 96-97, 103, 107



C


1. CANEBEG, 23, 26-30, 34-7, 45-47, 49-52, 55-56, 58-62, 67-70, 92-94, 99-100, 105, 108
2. CARRIAGES, of Earl of Clancarthy, 115
3. CASTLES, Ballycarbery, 5, 8; Bearehaven, 110; Bodomesmen, 102; Castlelough, 4, 10; Dunkerron, 92n; Dunloe, 96; Mashanaglass, 12; Pallis, 3, 3n, 9
4. CHIEFRIES, 1, 54
5. CLAPBOARD, 33, 33n
6. COMPANY, of Earl of Clancarthy, 82, 110
7. COUNTESS, 3; see also Clancarthy
8. COURT, of Earl of Clancarthy, 31, 32, 43
9. Cow, 14
10. CUDDY, CUDDIES, 17, 82, 85, 95, 103, 107 108, 110, 119-121, 123
11. CUSTOMS, in Valentia, 7



D


1. DEED, an Irish, 12
2. DEMESNES, of Earl of Clancarthy, 1, 3-8
3. DOWGOLLO, 18, 26-30, 34 39, 41-42, 45-47, 49-52, 55-56, 58-62, 64, 67-70, 72-75, 79-80, 82, 85, 91-94, 98-100, 103, 105, 107, 108, 111, 113-114
4. DUTIES, in Valentia, 7; payable to Earl of Clancarthy, 1, 13



E


1. EARL, see Clancarthy and Desmond
2. EYRIE, see Goshawks



F


1. FISHINGS, Ballycarbery, 11; Bearehaven, 76, 112; Beginish, 11; Cappanacush, 101; Caragh Lake and River, 9, 66; Castlelough, 10; Currane River, 11; Douglas River, 109; Dunkerron, 101, 106; Dursey, 112; Ferta River, 11, 44, 63; Flesk River, 10, 86, 88; Góilín, 11, 109; Gweestin River, 44; Inny River, 48, 101; Kenmare River, 71, 101; Laune, River, 9, 66, 86, 90, 101, 106; Lough Leeagh, 48; Lough Leane, 9, 10, 86; Maine River, 54, 83; Pallis, 9; Roughty River, 33, 5 7, 71; Valentia, 11, 63, 1.01, 109; weir on Currane River, 11


---

p.205

4. FLESH, 17
5. FLOUR, I7
6. FOOTMEN, LIGHT, 20
7. FOOT-SOLDIERS, 19
8. FREEHOLDERS, 1, 13, 15, 17, 26, 59, 84, 86
9. FREE LAND, 31, 32, 43, 54, 83



G


1. GALLOGOLOH, see Gallowglasses
2. GALLON (Measure), 25
3. GALLOWGLASSES, 12n, 19
4. GAREMSLOAEG, 14
5. GARRANS, 44, 44n
6. GENTLEMEN, of Dulhallow, 123
7. GLENS, of Barnasn 86
8. GOSHAWKS, eyrie of 33, 33n, 88



H


1. HALF FACE (money), 85, 95, 118 121
2. HOG, 38-39, 41-42, 107
3. HONEY, 17
4. HORSEMEAT, 18, 21
5. HORSES, 21
6. HOUSE, of Earl of Clancarthy, 44
7. HUNTSMEN, 18



I


1. IRON, in Glanerought, 33n
2. ISLAND, in Lough Leeagh, 48; see also Innisfallen, Valentia etc.



K


1. KEARNTY, 2O



L


1. LEAD, mine of, 33, 33n
2. LIVINGS, of Abbot of Killagha, 121; of archdeacon of Aghadoe, 120
3. LORDS, of Desmond, 1, 13; of Duhallow, 123



M


1. MANOR, of Carrowcormock, 12; of Mashanaglass, 12
2. MARKS (money), 82, 85, 95, 118, 119, 120, 121
3. MEAL, 17; sroan of, 25
4. MEAT, 15, 16, 17; best dish of, 115; dog meat, 18; horsemeat, 18
5. MINE, of tin or lead, 33, 33n
6. MONEY, old, 14, 82; see also half face and marks
7. MOUNTAINS, Bantry, Bear, 2; Desmond, 18; Sleulogher, 2; remote, in Magunihy, 86
8. MUSTEROUN, 22





---

p.206


O


1. OATENFLOUR, 25
2. OATMEAL, sroans of, 16, 25, 34-38, 45-47, 53, 65, 82, 85, 91, 96, 97, 103, 107
3. OATS, burnt, 254; sheaves of, 38, 53, 65, 82, 85, 89, 97, 103, 107
4. OCEAN, bounding Desmond, 2
5. OFFICERS, of Desmond, 1; of Earl of Clancarthy, 123
6. OUNCES, of silver, 77, 116, 117



P


1. PEARL, 90, 90n, 101
2. PIKES, 88
3. PIPE, 33
4. POTTLE, 24
5. POUND (weight), 24
6. PRINCE, THE, 19
7. PRIOR, PRIORY, of Ballinskelligs, 118; of Innisfallen, 119



Q


1. Quirrens, see Butter



R


1. REFECTION, 17, 82, 95, 103, 107, 108, 119 121, 123
2. RENTS, payable to the Earl of Clancarthy, 1, 13
3. RENT, BLACK, 18
4. RIVERS, Blackwater, 2; Caragh, 66, 98n; Douglas, 109; Ferta, 11, 44, 63; Flesk, 10, l0n, 86, 86n, 88; Gweestin, 44; Inny, 48, 48n, 101, 101n; Kenmare, 33, 33n, 71, 101; Laune, 9, 66, 86, 90, 101, 106; Maine, 2, 54, 83, 83n; Roughty, 33, 57, 71, 104
5. ROUT, 21



S


1. SALMON, on Caragh Lake and River, 66; on Laune River, 66, 90
2. SERIEANTS, of Desmond, 1
3. SHEAVES, see Oats
4. SILVER, see Ounces
5. SORREN, 15, 25, 33-37, 45-47, 55-56, 63, 71-75, 78, 82, 92, 96, 105, 111, 113, 114, 116-118, 123
6. SORRENMORE, 16, 91
7. SROANS, see Oatmeal
8. STAVES, 33
9. SUIT AND SERVICE, 31, 32, 43
10. SUPPER, 82



T


1. TENANTS, of Earl of Clancarthy, 22
2. THATCHING, of Earl of Clancarthy's house, 44
3. TIMBER, 33, 101
4. TIMBER WOODS, 33, 71, 86
5. TIN, mine of, 33, 33n
6. TREES, ash, 88



U


1. UNDERTAKERS, lands of, 78, 84, 86



V


1. VICTUALS, 14, 22, 123





---

p.207


W


1. WAGES, 22
2. WEIR, on River Currane, 11, 11n
3. WESTERN MEN, of England, 112
4. WINE, of Earl of Clancarthy, 44
5. WOODS, 33, 57, 71, 86
6. WORKMEN, 22















