

#The Description of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Description of Ireland
==========================


Author: Fynes Moryson
---------------------


### File Description

Charles Hughestranslated by Charles Hughes Electronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The President's Strategic Fund via the Writers of Ireland II Project. 3. Third draft, with further bibliographical details.Extent of text: 
10600 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2007) (2010) (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100071Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Oxford, Corpus Christi College Library, MS 94.
**Editions/Translations**2. Fynes Moryson, A history of Ireland from the year 1599 to 1603: with a short narration of the state of the kingdom from the year 1169; to which is added a description of Ireland (2 vols, Dublin 1735). A reprint of part 2 and 3, Book 3, chapter 5 of the *Itinerary*, the *Description* is at the end of volume 2.
3. Henry Morley (ed.), Ireland under Elizabeth and James the first, described by Edmund Spenser, by Sir John Davies, ... and by Fynes Moryson [Carisbrooke Library Series 10] (London & New York 1890).
4. Charles Hughes, Shakespeare's Europe. Unpublished chapters of Fynes Moryson's Itinerary: being a survey of the condition of Europe at the end of the sixteenth century. With an Introduction and an account of Fynes Moryson's career (London 1903). For chapters on Ireland, see especially 185–260, 285–289, 481–486.
5. Fynes Moryson, An itinerary, containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland & Ireland [Reprint of 1617 edition] (4 vols, Glasgow 1907–1908).
6. Graham Kew (ed.), The Irish sections of Fynes Moryson's unpublished Itinerary (Dublin 1998) [first published in Analecta Hibernica 37 (1995/1996) 1–137].
7. See www.archive.org for the complete work made available by the University of Toronto Centre for Classical and Renaissance Literature.
**Selected further reading (**2. Edward Campion, A historie of Ireland (London 1571; facsimile, ed. M. Hamner, repr. 1971).
3. Richard Stanihurst, A treatise containing a plain and perfect description of Ireland (London 1577).
4. William Camden, Britannia, trans. Philemon Holland (London 1610). For a full critical edition in Latin and English, see http://www.philological.bham.ac.uk/cambrit/
5. Barnaby Rich, A new description of Ireland (London 1610).
6. John Davies, A discoverie of the true causes why Ireland was never entirely subdued, nor brought under obedience of the crowne of England, until the beginning of his Majestie's happie raigne (London 1612; repr. 1969).
7. Thomas Stafford, Pacata Hibernia: or, A history of the wars in Ireland during the reign of Queen Elizabeth, especially within the province of Munster under the government of Sir George Carew, and compiled by his direction and appointment (London 1633, repr. 2 vols; Dublin 1896).
8. Charles Smith, The ancient and present state of the county and city of Cork: Containing a natural, civil, ecclesiastical, historical, and topographical description thereof (Dublin 1774). Reprinted by the Cork Historical and Archæological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. ed. Robert Day & W.A. Copinger. (Cork 1893–1894).
9. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof (Dublin 1773; 1774).
10. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774; repr. Dublin & Cork 1979).
11. Philip O'Sullivan Beare, 'Briefe relation of Ireland, and the diversity of Irish in the same,' ed. James Hardiman, in The Complete Catholic Directory, Almanack and Registry for the Year of our Lord 1841, vol. 1 (Dublin 1841) 362–373. With an introduction by Benjamin Hazard. (Online at CELT).
12. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. James Hardiman (Dublin 1846).
13. Thomas Dinely, 'Observations on a tour through the kingdom of Ireland in 1681,' in Journal of the Kilkenny & South-East of Ireland Archæological Society, 2nd ser., 4 (1856–57) 143–46, 170–88; 5 (1858–59) 22–32, 55–56; 7 (1862–63) 38–52, 103–109, 320–38; 8 (1864–66) 40–48, 268–90; 425–46; 9 (1867) 73–91, 176–204.
14. James Spedding (ed.), The letters and life of Francis Bacon (7 vols, 1861–1874), vol. 2.
15. P. W. Joyce, The origin and history of Irish names of places (facs. of original edition in 3 vols, 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe (repr. Dublin 1995).
16. Louis Prosper Gachard & Charles Piot, Collection des voyages des souverains des Pays-Bas (4 vols, Brussels, 1874–1882) vol. 3, 1881. This book includes an account of the visit made to Kinsale by Archduke Ferdinand I in 1518. See pp 276–296. This extract is available online at CELT with an English translation.
17. Charles Haliday, The Scandinavian kingdom of Dublin (Dublin 1882).
18. Richard Bagwell, Ireland under the Tudors: with a succinct account of the earlier history (3 vols, London 1885–1890).
19. Richard Pococke, A tour in Ireland in 1752; ed. by George T. Stokes, as 'Bishop Pococke's tour in Ireland in 1752' (Dublin & London 1891). (Online at CELT).
20. Geoffrey Keating, The history of Ireland (Foras Feasa ar Éirinn), eds. David Comyn & Patrick Dinneen (London 1902–1914). (Online at CELT).
21. P. W. Joyce, A social history of Ancient Ireland. 2 volumes (New York, London & Bombay 1903).
22. Adolphus William Ward, 'An Elizabethan traveller (Fynes Moryson),' in Collected papers, 3 (1921) 198–230.
23. J. C. Whitebrook, 'Fynes Moryson, Giordano Bruno and William Shakespeare', Notes & Queries, 171 (1936) 255–260.
24. Boies Penrose, Urbane travelers, 1591-1635 (Philadelphia PA & London 1942).
25. Gilbert Waterhouse, 'Fynes Moryson: traveller,' Bulletin, Irish Committee of Historical Sciences, 36 (1945).
26. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
27. F. Walsham, 'Fynes Moryson and four indentures,' Lincolnshire Historian 2/2 (1955) 18–23.
28. L. W. Kenny, 'Contemporary sources for Essex's lieutenancy in Ireland, 1599,' Irish Historical Studies, 11/41 (1958–1959) 8–17.
29. William Lithgow, The rare adventures and painful peregrinations of William Lithgow (1632), ed. with an Introduction by Gilbert Phelps (London 1974). (Extract online at CELT).
30. Joseph Canning, 'A stranger in County Armagh,' in 'Before I Forget...': Journal of the Poyntzpass & District Local History Society, 5 (1991) 7–18.
31. Andrew Hadfield & John McVeagh (eds.), Strangers to that land: British perceptions of Ireland from the reformation to the famine [Ulster Editions & Monographs 5] (Gerards Cross 1994).
32. Antoni Maczak, Travel in early modern Europe, trans. Ursula Phillips (Cambridge 1995).
33. Edward Thompson, 'Elizabethan economic analysis: Fynes Moryson's account of the economics of Europe,' in History of Economic Ideas, 3/1 (1995) 1–25.
34. John McVeagh (ed.), Irish travel writing. A bibliography (Dublin 1996).
35. Brian Lockey, 'Conquest and English legal identity in Renaissance Ireland,' in Journal of the History of Ideas, 65/4 (2004) 543–558.
36. Hiram Morgan (ed.), The Battle of Kinsale (Bray 2004).
37. Edward Thompson, 'Moryson, Fynes (1565/6–1630), traveller and writer,' in Brian Harrison et al. (eds.), Oxford Dictionary of National Biography (60 vols, Oxford 2004) [online at www.oxforddnb.com].
38. David Holeton, 'Fynes Moryson's Itinerary: a sixteenth century English traveller's observations on Bohemia, its reformation, and its liturgy,' in Zdenek V. David (ed.), The Bohemian reformation and religious practice, 5/2 (Prague 2005) 379–412.
39. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
40. Stephan Schmuck, ''Familiar strangers': dissimulation, tolerance and faith in early Anglo-Ottoman travel,' in Isabel Karremann, Cornel Zwierlein, Inga Mai Groote (eds.), Forgetting faith? Negotiating confessional conflict in early modern Europe [Pluralisierung & Autorität, 29] (Berlin 2012) 241–260.
41. Ruth Hegarty, 'Ulster on the eve of the Plantation,' in The Bann Disc: Journal of the Coleraine Historical Society, 19 (2013) 41–51.
**The edition used in the digital edition**2. Illustrations of Irish History and Topography, mainly of the seventeenth century. C. Litton Falkiner (ed), First edition [xvii + 426 pages] Longmans Green, and Co.London, New York, Bombay (1904)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 212–232 of the volume. C. Litton Falkiner's Introduction is included.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text was first edited by Charles Hughes in Shakespeare's Europe, and reprinted in the Illustrations of Irish History by C. Litton Falkiner, from which it is taken. Some passages not printed by Hughes are supplied by Falkiner. and marked sup resp="CLF". Footnotes by Falkiner are included in note tags.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the chapter; div2=the sub-section; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, personal and organisation names, and terms are tagged. Words and phrases from languages other than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: Translation by Charles Hughes and C. L. Falkiner
 Date range: 1902–1903.#### Use of language


##### Language: [EN] The editor has modernized Fynes Moryson's Elizabethan idiom.


##### Language: [GA] A few words are in Irish.


##### Language: [LA] A few words are in Latin.


##### Language: [GR] A word (proper name) is in Greek.


##### Language: [CY] A word (proper name) is in Welsh.


### Revision History


* (2014-07-15) Benjamin Hazard (ed.)

* Bibliography updated.
* (2010-07-15) Beatrix Färber (ed.)

* Conversion script run, header updated; additions to bibliographic details made; more content encoding added; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-09-05) Beatrix Färber (ed.)

* File validated, keywords added.
* (2008-07-27) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, title elements streamlined, content of 'langUsage' revised; minor modifications made to header.
* (2007-01-12) Beatrix Färber (ed.)

* Second proofing finished; SGML and HTML files created.
* (2006-12-18) Beatrix Färber (ed.)

* Bibliography compiled; second file proofing begun.
* (2006-12-16) Beatrix Färber (ed.)

* Header created; file proof-read (1); structural and content markup applied.
* (2006-12-15) Beatrix Färber (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: T100071


### The Description of Ireland: Author: Fynes Moryson




---

p.211


### The Itinerary of Fynes Moryson


Although it is close upon three centuries since the first publication of the larger portion of the important work known as **Fynes Moryson**'s Itinerary, it is only quite recently that the full scope of **Moryson**'s undertaking has been properly understood. The publication by **Mr. Charles Hughes**, as lately as 1903, in a work entitled Shakespeare's Europe, [1](javascript:footNote('T100071/note001.html')) of the large section of the Itinerary, which had so long remained in manuscript in the library of Corpus Christi College, **Oxford**, has for the first time rendered it possible to appreciate the full extent and value of **Moryson**'s labours as a social historian of his own times. No single portion of **Moryson**'s remarkable survey of the manners, customs, and institutions of the various countries and kingdoms of Europe at the opening of the seventeenth century is more valuable than the chapters devoted to **Ireland**. The Description of Ireland which forms the fifth chapter of the third book of Part III of the original Itinerary, is well known and has been more than once reprinted.[2](javascript:footNote('T100071/note002.html')) But the account of the Commonwealth of Ireland which forms the fifth chapter of the second book of the long unpublished fourth part and the chapter on Manners and Customs (Book V. chapter v.) were unknown until their publication by **Mr. Hughes**. Other references to **Ireland** in the Itinerary besides those printed in this volume occur in the chapter which treats Of



---

p.212



the Turks, French, English, Scottish, and Irish Apparel (Part III. Book IV. chapter v.), and in that on The Journey through England, Scotland, and Ireland (Part I. Book III. chapter v.). The latter contains many interesting sidelights on the conditions of travelling in the three kingdoms three hundred years ago. While the Description will always remain valuable as a picture of Irish life and manners by a traveller whose large comparative knowledge of the Europe of his day gives a special importance to his observations, **Moryson**'s notes on the Commonwealth have a unique interest for the light they throw on the political institutions of **Ireland**, as seen by one who had been actively engaged in Irish affairs, and had enjoyed peculiar opportunities of studying the administrative system of the Irish government at a very important crisis in Irish history. A like praise can hardly be accorded to the observations touching religion in Ireland (Book III. chapter vi.). **Moryson**'s views on this head are as acutely controversial and as inevitably uncharitable as might be expected; and it has not appeared expedient to print them here.


No one can have had greater facilities than were possessed by **Fynes Moryson** for understanding the machinery of the Irish executive in all its parts as it existed at the close of Elizabeth's reign. For not only was he placed, as secretary to **Mountjoy** during the whole period of that Viceroy's active career in **Ireland**, in the closest possible contact with the central executive, but he had ample means of information regarding the local instruments of government in the provinces. His brother, **Sir Richard Moryson**, who came to **Ireland** in the army of **Essex** in 1599, held important appointments there for close on thirty years. From 1609 to 1628 **Sir Richard** held the considerable office of Vice-President of **Munster**, and he was visited at **Cork** by the historian in 1613. Thus the faculty of precise observation which gives so much value to **Fynes Moryson**'s narrative, even where his notes represent no more than the rapid but acute deductions of a passing traveller, has, in the case of his account of **Ireland**, the enhanced interest which comes of the writer's intimate knowledge of the social and political state of the country.


Often as it has been printed, **Fynes Moryson**'s Description of Ireland is an indispensable introduction to any collection of contemporary works on seventeenth century **Ireland**, and as such it is once more printed here. The chapters on the Commonwealth and on manners and customs are reproduced because, although so recently published, the Irish sections of Part IV. of the Itinerary are scattered at wide distances through **Mr. Hughes**'s substantial



---

p.213



volume;[3](javascript:footNote('T100071/note003.html')) and, forming only a relatively small portion of the whole, have scarcely attracted the attention they deserve.


The extracts from Shakespeare's Europe are included in this volume with the cordially expressed assent of **Mr. Charles Hughes**, and of the owners of the copyright in that work, Messrs. Sherratt & Hughes, publishers, of Manchester and London. Some passages not printed by **Mr. Hughes**, which appear to throw useful light on the social condition of **Ireland** at the time when **Moryson** wrote, are now published for the first time by the kind permission of the President and Fellows of Corpus Christi College, Oxford.




---

p.214


The Description of Ireland
--------------------------


The longitude of **Ireland** extends four degrees, from the meridian of eleven degrees and a half to that of fifteen and a half, and the latitude extends also four degrees, from the parallel of fifty-four degrees to that of fifty-eight degrees. In the geographical description I will follow **Cambden** as formerly.[4](javascript:footNote('T100071/note004.html'))


This famous island in the Virginian sea is by old writers called **Ierna**, **Inverna**, and **Iris**, by the old inhabitants **Erin**, by the old Britains **Yuerdhen**, by the **English** at this day **Ireland**, and by the Irish Bards at this day **Banno**, in which sense of the Irish word, **Avicen** calls it the Holy Island; besides, **Plutarch** of old called it **Ogygia**, and after him **Isidore** named it **Scotia**.[5](javascript:footNote('T100071/note005.html')) This **Ireland**, according to the inhabitants, is divided into two parts, the wild Irish, and the **English-Irish**, living in the English pale. But of the old kingdoms, five in number, it is divided into five parts.


1. The first is by the **Irish** called **Mowne**, by the **English** **Munster**, and is subdivided into six counties—of **Kerry**, of **Limerick**, of **Cork**, of **Tipperary**, of the **Holy Cross**, and of **Waterford**—to which the seventh county of **Desmond** is now added. The **Gangavi**, a Scythian people, coming into **Spain**, and from thence into **Ireland**, inhabited the county of **Kerry**, full of woody mountains, in which the Earls of Desmond had the dignity of palatines, having their house in **Trailes**, a little town now almost uninhabited. Not far thence lies



---

p.215


**St. Mary Wic**, vulgarly called **Smerwick**, where the **Lord Arthur Gray, being Lord Deputy**, happily overthrew the aiding troops sent to the Earl of Desmond from the Pope and the King of **Spain**. On the south side of **Kerry** lies the county of **Desmond**, of old inhabited by three kinds of people, the **Luceni** (being Spaniards), the **Velabri** (so called of their seat upon the sea-waters or marshes), and the **Iberni**, called the upper Irish, inhabiting about **Beer-haven** and **Baltimore**, two havens well known by the plentiful fishing of herrings, and the late invasion of the Spaniards in the year 1601. Next to these is the county of **MacCarty-More**, of Irish race, whom, as enemy to the FitzGeralds, Queen Elizabeth made Earl of Glencar in the year 1566. For of the FitzGeralds, of the family of the Earls of Kildare, the Earls of Desmond descended, who, being by birth English, and created earls by King Edward III., became hateful rebels in our time. The third county hath the name of the City **Cork**, consisting almost all of one long street,[6](javascript:footNote('T100071/note006.html')) but well known and frequented, which is so compassed with rebellious neighbours, as they of old not daring to marry their daughters to them, the custom grew, and continues to this day, that by mutual marriages one with another all the citizens are of kin in some degree of affinity. Not far thence is **Yoghal**, having a safe haven, near which the Viscounts of Barry, of English race, are seated. In the fourth county of **Tipperary** nothing is memorable, but that it is a palatinate. The little town **Holy Cross**, in the county of the same name, hath many great privileges. The sixth county hath the name of the City **Limerick**, the seat of a bishop, wherein is a strong castle built by King John. Not far thence is **Awne**,[7](javascript:footNote('T100071/note007.html')) the seat of a bishop, and the Lower Ossory, giving the title of an earl to the Butlers, and the town **Thurles**, giving them also the title of viscount. And there is **Cassiles**,[8](javascript:footNote('T100071/note008.html')) now a poor city, but the seat of an archbishop. The seventh county hath the name of the



---

p.216



City **Waterford**, which the **Irish** call **Porthlargi**, of the commodious haven, a rich and well-inhabited city, esteemed the second to **Dublin**. And because the inhabitants long faithfully helped the **English** in subduing **Ireland** our kings gave them excessive privileges; but they, rashly failing in their obedience at King James's coming to the crown, could not in long time obtain the confirmation of their old Charter.[9](javascript:footNote('T100071/note009.html'))


2. **Leinster**, the second part of **Ireland**, is fertile, and yields plenty of corn, and hath a most temperate mild air, being divided into ten counties of **Catherlough**, **Kilkenny**, **Wexford**, **Dublin**, **Kildare**, the **King's County**, the **Queen's County**, the counties of **Longford**, of **Ferns**,[10](javascript:footNote('T100071/note010.html')) and of **Wicklow**. The **Cariondi** of old inhabited **Catherlogh** (or **Carlow**) County, and they also inhabited great part of **Kilkenny**, of **Upper Ossory**, and of **Ormond**, which have nothing memorable but the Earls of Ormond, of the great family of the Butlers, inferior to no earl in **Ireland** (not to speak of Fitzpatrick, Baron of Upper Ossory). It is ridiculous which some Irish (who will be believed as men of credit) report of men in these parts yearly turned into wolves, except the abundance of melancholy humour transports them to imagine that they are so transformed.[11](javascript:footNote('T100071/note011.html')) **Kilkenny** giving name to the second county is a pleasant town, the chief of the towns within land, memorable for the civility of the inhabitants, for the husbandman's labour, and the pleasant orchards. I pass over the walled town **Thomastown**, and the ancient city **Rheban**, now a poor village with a castle, yet of old giving the title of baronet. I pass over the village and strong castle of **Leighlin**, with the country adjoining, usurped by the sept of the **Cavanaghs**, now surnamed **O'Moors**. Also I omit **Ross**,[12](javascript:footNote('T100071/note012.html')) of old a large city, at this day of no moment. The third



---

p.217



county of **Wexford** (called by the **Irish** County **Reogh**) was of old inhabited by the **Menapii**, where, at the town called **Banna**, the **English** made their first descent into **Ireland**, and upon that coast are very dangerous flats in the sea, which they vulgarly call grounds. The City **Weshford**, **Weisford**, or **Wexford**, is the chief of the county, not great, but deserving praise for their faithfulness towards the **English**, and frequently inhabited by men of English race. The **Cauci** (a sea-bordering nation of Germany) and the **Menapii** aforesaid, of old inhabited the territories now possessed by the **O'Moors** and **O'Birns**; also they inhabited the fourth county of **Kildare**, a fruitful soil, having the chief town of the same name, greatly honoured in the infancy of the Church by St. Bridget. King Edward II. created the **Giralds** Earls of **Kildare**. The **Eblani** of old inhabited the territory of **Dublin**, the fifth county, having a fertile soil and rich pastures, but wanting wood, so as they burn turf, or sea-coal brought out of **England**. The City **Dublin**, called **Divelin** by the **English**, and **Balacleigh**[13](javascript:footNote('T100071/note013.html')) (as seated upon hurdles) by the **Irish**, is the chief city of the kingdom, and seat of justice, fairly built, frequently inhabited, and adorned with a strong castle, fifteen churches, an episcopal seat, and a fair college (an happy foundation of an university laid in our age), and endowed with many privileges, but the haven is barred and made less commodious by those hills of sands. The adjoining promontory, **Hoth-head**, gives the title of a baron to the family of **St. Laurence**; and towards the north lies **Fingal**, a little territory, as it were the garner of the kingdom, which is environed by the sea and great rivers, and this situation hath defended it from the incursion of rebels in former civil wars. I omit the King's and Queen's Counties (namely, **Ophaly** and **Leax**) inhabited by the **O'Connors** and **O'Moors**, as likewise the counties of **Longford**, **Ferns**, and **Wicklow**, as less affording memorable things.




---

p.218


3. The third part of **Ireland** is **Midia** or **Media**, called by the **English** **Meath**, in our fathers' memory divided into **Eastmeath** and **Westmeath**. In **Eastmeath** is **Drogheda**, vulgarly called **Tredagh**, a fair and well-inhabited town. **Trim** is a little town upon the confines of **Ulster**, having a stately castle, but now much ruinated, and it is more notable for being the ancient (as it were) barony of the **Lacies**. **Westmeath** hath the town **Delvin**, giving the title of baron to the English family of the **Nugents**, and **Westmeath** is also inhabited by many great Irish septs, as the **O'Maddens**, the **Magoghigans**, **O'Malaghlans**, and **MacCoghlans**, which seem barbarous names. **Shanon** is a great river in a long course, making many and great lakes (as the large lake or **Lough Regith**), and yields plentiful fishing, as do the frequent rivers and all the seas of **Ireland**. Upon this river lies the town **Athlone**, having a very fair bridge of stone (the work of **Sir Henry Sidney, Lord Deputy**[14](javascript:footNote('T100071/note014.html'))), and a strong fair castle.


4. **Connaught** is the fourth part of **Ireland**, a fruitful province, but having many bogs and thick woods, and it is divided into six counties, of **Clare**, of **Leitrim**, of **Galway**, of **Roscommon**, of **Mayo** and of **Sligo**. The county of **Clare** or **Thomond** hath his Earls of Thomond, of the family of the **O'Brenes**, the old kings of **Connaught**, and **Tuam** is the seat of an archbishop; only part, but the greatest, of this county was called **Clare**, of **Thomas Clare, Earl of **Gloucester****.[15](javascript:footNote('T100071/note015.html')) The adjoining territory, **Clan Richard** (the land of Richard's sons), hath his earls called Clanrickard of the land, but being of the English family **de Burgo, vulgarly Burke**, and both these earls were first created by Henry VIII. In the same territory is the Barony **Atterith**, belonging to the barons of the English family **Bermingham**, of old very warlike, but their posterity have degenerated to 



---

p.219



the Irish barbarism. The City **Galway**, giving name to the county, lying upon the sea, is frequently inhabited with civil people, and fairly built. The northern part of **Connaught** is inhabited by these Irish septs, **O'Connor**, **O'Rourke**, and **MacDiermod**. Upon the western coast lies the island **Arran**, famous for the fabulous long life of the inhabitants.


**Ulster**, the fifth part of **Ireland**, is a large province, woody, fenny, in some parts fertile, in other parts barren, but in all parts green and pleasant to behold, and exceedingly stored with cattle. The next part to the **Pale** and to **England** is divided into three counties—**Lowth**, **Down**, and **Antrim**; the rest contains seven counties—**Monaghan**, **Tyrone**, **Armagh**, **Coleraine**, **Donnegal**, **Fermannagh**, and **Cavan**. **Lowth** is inhabited by English-Irish (**Down** and **Antrim** being contained under the same name), and the barons thereof be of the **Bermingham**'s family, and remain loving to the **English**. **Monaghan** was inhabited by the English family **Fitzursi**, and these are become degenerate and barbarous, and in the sense of that name are in the Irish tongue called **MacMahon**, that is the sons of Bears. I forbear to speak of **Tyrone**, and the earl thereof, infamous for his rebellion, which I have at large handled in this work. **Armagh** is the seat of an archbishop, and the metropolitan city of the whole island, but in time of the rebellion was altogether ruinated. The other counties have not many memorable things, therefore it shall suffice to speak of them briefly. The neck of land called **Lecaile** is a pleasant little territory, fertile, and abounding with fish and all things for food, and therein is **Down**, at this time a ruined town, but the seat of a bishop, and famous for the burial of St. Patrick, St. Bridget,[16](javascript:footNote('T100071/note016.html')) and St. Columb. The town of **Carrickfergus** is well known by the safe haven. The river **Bann**, running through the **Lake Evagh** into the sea, is famous for the fishing of salmons, the water being most clear, wherein the salmons much delight. The great families (or septs) of **Ulster** are thus named: **O'Neal**, **O'Donnel** (whereof the chief was lately created



---

p.220



Earl of Tirconnel), **O'Buil**, **MacGwire**, **O'Kain**, **O'Dogherty**, **MacMahown**, **MacGennis**, **MacSurleigh**, &c. The **lake Erne** compassed with thick woods hath such plenty of fish as the fishermen fear the breaking of their nets rather than want of fish. Towards the north, in the midst of vast woods (and as I think) in the county **Donnegal** is a lake, and therein an island, in which is a cave, famous for the apparition of spirits, which the inhabitants call **Ellanvi frugadory**—that is, the island of Purgatory—and they call it St. Patrick's Purgatory, fabling that he obtained of God by prayer that the **Irish** seeing the pains of the damned might more carefully avoid sin.[17](javascript:footNote('T100071/note017.html'))


The situation.—The land of **Ireland** is uneven, mountainous, soft, watery, woody, and open to winds and floods of rain, and so fenny as it hath bogs on the very tops of mountains, not bearing man or beast, but dangerous to pass, and such bogs are frequent over all **Ireland**. Our mariners observe the sailing into **Ireland** to be more dangerous, not only because many tides meeting makes the sea apt to swell upon any storm, but especially because they ever find the coast of **Ireland** covered with mists, whereas the coast of **England** is commonly clear and to be seen far off. The air of **Ireland** is unapt to ripen seeds, yet (as **Mela** witnesseth) the earth is luxurious in yielding fair and sweet herbs. **Ireland** is little troubled with thunders, lightnings, or earthquakes, yet (I know not upon what presage) in the year 1601, and in the month of November almost ended, at the siege of **Kinsale** and a few days before the famous battle, in which the rebels were happily overthrown, we did nightly hear and see great thunderings and lightnings, not without some astonishment what they should presage. The fields are not only most apt to feed cattle, but yield also great increase of corn. I will freely say that I observed



---

p.221



the winter's cold to be far more mild than it is in **England**, so as the Irish pastures are more green, and so likewise the gardens all winter time, but that in summer, by reason of the cloudy air and watery soil, the heat of the sun hath not such power to ripen corn and fruits, so as their harvest is much later than in **England**. Also I observed that the best sorts of flowers and fruits are much rarer in **Ireland** than in **England**, which notwithstanding is more to be attributed to the inhabitants than to the air. For **Ireland** being oft troubled with rebellions, and the rebels not only being idle themselves, but in natural malice destroying the labours of other men, and cutting up the very trees of fruit for the same cause, or else to burn them: for these reasons the inhabitants take less pleasure to till their grounds or plant trees, content to live for the day in continual fear of like mischief. Yet is not **Ireland** altogether destitute of these flowers and fruits, wherewith the county of **Kilkenny** seems to abound more than any other part: and the said humidity of air and land making the fruits for food more raw and moist; hereupon the inhabitants and strangers are troubled with looseness of body, the country disease. Yet for the rawness they have an excellent remedy by their **Aqua Vitae**, vulgarly called **Usquebagh**, which binds the belly, and drieth up moisture more than our **Aqua Vitae**, yet inflameth not so much. Also inhabitants as well as strangers are troubled there with an ague which they call the Irish ague, and they who are sick thereof, upon a received custom, do not use the help of the physician, but give themselves to the keeping of Irish women, who starve the ague, giving the sick man no meat, who takes nothing but milk and some vulgarly known remedies at their hand.


The fertility and traffic.—**Ireland**, after much blood spilt in the civil wars, became less populous, and as well great lords of countries as other inferior gentlemen laboured more to get new possessions for inheritance, than by husbandry and peopling of their old lands to increase their revenues; so as I then observed much grass (wherewith the island so much abounds) to have perished without use, and either to



---

p.222



have rotted, or in the next spring time to be burnt, lest it should hinder the coming of new grass; this plenty of grass makes the **Irish** have infinite multitudes of cattle, and in the heat of the last rebellion the very vagabond rebels had great multitudes of cows, which they still (like the nomades) drove with them whithersoever themselves were driven, and fought for them as for their altars and families. By this abundance of cattle the **Irish** have a frequent though somewhat poor traffic for their hides, the cattle being in general very little, and only the men and the greyhounds of great stature. Neither can the cattle possibly be great since they eat only by day, and then are brought at evening within the **bawns** of castles,[18](javascript:footNote('T100071/note018.html')) where they stand or lie all night in a dirty yard without so much as a lock of hay, whereof they make little for sluggishness, and their little they altogether keep for their horses; and they are brought in by nights for fear of thieves, the **Irish** using almost no other kind of theft, or else for fear of wolves, the destruction whereof being neglected by the inhabitants, oppressed with greater mischiefs, they are so much grown in number as sometimes in winter nights they will come to prey in villages and the suburbs of the cities.[19](javascript:footNote('T100071/note019.html')) The Earl of Ormond in **Munster**, and the Earl of Kildare in **Leinster**, had each of them a small park inclosed for fallow deer, and I have not seen any other park in **Ireland**, nor have heard that they had any other at that time, yet in many woods they have many red deer loosely scattered,[20](javascript:footNote('T100071/note020.html')) which seem more plentiful, because



---

p.223



the inhabitants used not then to hunt them, but only the governors and commanders had them sometimes killed with the piece. They have also about **Ophalia** and **Wexford**, and in some parts of **Munster**, some fallow deer scattered in the woods; yet in the time of the war I did never see any venison served at the table, but only in the houses of the said earls and of the English commanders. **Ireland** hath great plenty of birds and fowls, but by reason of their natural sloth they had little delight or skill in birding or fowling. But **Ireland** hath neither singing nightingale nor chattering pie,[21](javascript:footNote('T100071/note021.html')) nor undermining mole, nor black crow, but only crows of mingled colour such as we call **Royston crows**. They have such plenty of pheasants as I have known sixty served at one feast, and abound much more with rails, but partridges are somewhat rare. There be very many eagles, and great plenty of hares, conies, hawks, called **goss-hawks**, much esteemed with us, and also of bees, as well in hives at home as in hollow trees abroad and in caves of the earth. They abound in flocks of sheep which they shear twice in the year, but their wool is coarse, and merchants may not export it, forbidden by a law made on behalf of the poor,[22](javascript:footNote('T100071/note022.html')) that they may be nourished by working it into cloth, namely rugs (whereof the best are made at **Waterford**), and mantles are generally worn by men and women and exported in great quantity. **Ireland** yields much flax, which the inhabitants work into yarn, and export the same in great quantity; and of old they had such plenty of linen cloth as the old Irish used to wear thirty or forty ells in a shirt all gathered and wrinkled, and washed in saffron because they never put them off till they were worn out. Their horses, called hobbies, are much commended for their ambling pace and beauty; but **Ireland** yields few horses good for service in war, and the said hobbies are much inferior to our geldings in strength to endure long journeys, and being bred in the fenny, soft ground of **Ireland** are soon lamed when



---

p.224



they are brought into **England**. The hawks of **Ireland**, called **goss-hawks**, are (as I said) much esteemed in **England**, and they are sought out by money and all means to be transported thither.[23](javascript:footNote('T100071/note023.html')) **Ireland** yields excellent marble near **Dublin**, **Kilkenny**, and **Cork**; and I am of their opinion who dare venture all they are worth that the mountains would yield abundance of metals if this public good were not hindered by the inhabitants' barbarousness, making them apt to seditions, and so unwilling to enrich their prince and country, and by their slothfulness, which is so singular as they hold it baseness to labour, and by their poverty not able to bear the charge of such works; besides that the wiser sort think their poverty best for the public good, making them peaceable, as nothing makes them sooner kick against authority than riches. **Ireland** hath in all parts pleasant rivers, safe and long havens, and no less frequent lakes of great circuit, yielding great plenty of fish; and the sea on all sides yields like plenty of excellent fish, as salmon, oysters (which are preferred before the English), and shell-fishes, with all other kinds of sea-fish, so as the **Irish** might in all parts have abundance of excellent sea and fresh-water fish, if the fishermen were not so possessed with the natural fault of slothfulness, as no hope of gain, scarcely the fear of authority, can in many places make them come out of their houses and put to sea. Hence it is that in many places they use **Scots** for fishermen, and they, together with the **English**, make profit of the inhabitants' sluggishness; and no doubt if the **Irish** were industrious in fishing, they might export salted and dried fish with great gain. In time of peace the **Irish** transport good quantity of corn; yet they may not transport it without license, lest upon any sudden rebellion the King's forces and his good subjects should want corn. **Ulster** and the western parts of **Munster** yield vast woods,[24](javascript:footNote('T100071/note024.html')) in which the rebels, cutting up trees and casting them on heaps, used to stop the passages, and therein, as also upon



---

p.225



fenny and boggy places, to fight with the **English**. But I confess myself to have been deceived in the common fame that all **Ireland** is woody, having found in my long journey from **Armagh** to **Kinsale** few or no woods by the way, excepting the great woods of **Ophalia** and some low shrubby places which they call Glins; also I did observe many boggy and fenny places whereof great part might be dried by good and painful husbandry. I may not omit the opinion commonly received that the earth of **Ireland** will not suffer a snake or venomous beast to live, and that the Irish wood transported for building is free of spiders and their webs;[25](javascript:footNote('T100071/note025.html')) myself have seen some (but very few) spiders, which the inhabitants deny to have any poison, but I have heard some English of good credit affirm by experience the contrary. The Irish having in most parts great woods, or low shrubs and thickets, do use the same for fire, but in other parts they burn turf and sea-coals brought out of **England**. They export great quantity of wood to make barrels, called pipe-staves, and make great gain thereby. They are not permitted to build great ships of war, but they have small ships, in some sorts armed to resist pirates, for transporting of commodities into **Spain** and **France**, yet no great number of them; therefore since the **Irish** have small skill in navigation, as I cannot praise them for this art, so I am confident that the nation, being bold and warlike, would no doubt prove brave seamen if they shall practise navigation, and could possibly be industrious therein. I freely profess that **Ireland** in general would yield abundance of all things to civil and industrious inhabitants; and when it lay wasted by the late rebellion, I did see it after the coming of the **Lord Mountjoy** daily more and more to flourish, and, in short time after the rebellion appeased, like the new spring to put on the wonted beauty.


The diet.—Touching the Irish diet, some lords and knights, and gentlemen of the **English-Irish**, and all the English there abiding, having competent means, use the English diet, but some more, some less cleanly, few or none curiously, and



---

p.226



no doubt they have as great, and for their part greater, plenty than the **English**, of flesh, fowl, fish, and all things for food, if they will use like art of cookery. Always I except the fruits, venison, and some dainties proper to **England**, and rare in **Ireland**. And we must conceive that venison and fowl seem to be more plentiful in **Ireland**, because they neither so generally affect dainty food, nor so diligently search it as the **English** do.[26](javascript:footNote('T100071/note026.html')) Many of the **English-Irish** have by little and little been infected with the Irish filthiness, and that in the very cities, excepting **Dublin**, and some of the better sort in **Waterford**, where the **English**, continually lodging in their houses, they more retain the English diet. The **English-Irish** after our manner serve to the table joints of flesh cut after our fashion, with geese, pullets, pigs, and like roasted meats, but their ordinary food for the common sort is of white meats, and they eat cakes of oats for bread, and drink not English beer made of malt and hops, but ale. At **Cork** I have seen with these eyes young maids, stark naked, grinding of corn with certain stones to make cakes thereof, and striking off into the tub of meal such reliques thereof as stuck on their belly, thighs, and more unseemly parts. And for the cheese or butter commonly made by the **English-Irish** an Englishman would not touch it with his lips, though he were half-starved; yet many English inhabitants make very good of both kinds. In cities they have such bread as ours, but of a sharp savour, and some mingled with anice-seeds and baked like cakes, and that only in the houses of the better sort.


At **Dublin** and in some other cities they have taverns,[27](javascript:footNote('T100071/note027.html')) wherein Spanish and French wines are sold, but more commonly the merchants sell them by pints and quarts in their own cellars. The Irish **aqua vitae**,[28](javascript:footNote('T100071/note028.html')) commonly called



---

p.227


**usquebagh**, is held the best in the world of that kind, which is made also in **England**, but nothing so good as that which is brought out of **Ireland**. And the **usquebagh** is preferred before our **aqua vitae**, because the mingling of raisins, fennel-seed, and other things mitigating the heat, and making the taste pleasant, makes it less inflame, and yet refresh the weak stomach with moderate heat and a good relish. These drinks the **English-Irish** drink largely, and in many families (especially at feasts) both men and women use excess therein. And since I have in part seen, and often heard from other experience, that some gentlewomen are so free in this excess, as they would kneeling upon the knee and otherwise garausse health after health with men; not to speak of the wives of Irish lords or to refer it to the due place, who often drink till they be drunken, or, at least, till they void urine in full assemblies of men. I cannot (though unwillingly) but note the Irish women more especially with this fault, which I have observed in no other part to be a woman's vice, but only in **Bohemia**. Yet so, as accusing them, I mean not to excuse the men, and will also confess that I have seen virgins, as well gentlewomen as citizens, commanded by their mothers to retire after they had in curtesy pledged one or two healths. In cities passengers may have feather beds, soft and good, but most commonly lousy, especially in the highways, whether that came by their being forced to lodge common soldiers or from the nasty filthiness of the nation in general. For even in the best city and at **Cork** I have observed that my own and other Englishmen's chambers hired of the citizens were scarce swept once in the week,



---

p.228



and the dust then laid in a corner was perhaps cast out once in a month or two. I did never see any public inns with signs hanged out among the **English** or **English-Irish**, but the officers of cities and villages appoint lodgings to the passengers, and perhaps in each city they shall find one or two houses where they will dress meat, and these be commonly houses of **Englishmen**, seldom of the **Irish**, so as these houses having no signs hung out a passenger cannot challenge right to be entertained in them, but must have it of courtesy, or by entreaty.


The wild and (as I may say) mere Irish, inhabiting many and large provinces, are barbarous and most filthy in their diet. They scum the seething pot with a handful of straw, and strain their milk taken from the cow through a like handful of straw, none of the cleanest, and so cleanse, or rather more defile, the pot and milk. They devour great morsels of beef unsalted, and they eat commonly swine's flesh, seldom mutton; and all these pieces of flesh, as also the entrails of beasts unwashed, they seethe in a hollow tree lapped in a raw cow's hide and so set over the fire, and therewith swallow whole lumps of filthy butter. Yea (which is more contrary to nature), they will feed on horses dying of themselves, not only upon small want of flesh, but even for pleasure. For I remember an accident in the army when the **Lord Mountjoy, the Lord Deputy**, riding to take the air out of the camp, found the buttocks of dead horses cut off, and suspecting that some soldiers had eaten that flesh out of necessity, being defrauded of the victuals allowed them, commanded the men to be searched out, among whom a common soldier, and that of the **English-Irish**, not of the mere Irish, being brought to the **Lord Deputy**, and asked why he had eaten the flesh of dead horses, thus freely answered, ‘Your lordship may please to eat pheasant and partridge, and much good do it you, that best likes your taste; and I hope it is lawful for me without offence to eat this flesh that likes me better than beef.’ Whereupon the **Lord Deputy**, perceiving himself to be deceived, and further understanding that he had received his ordinary victuals



---

p.229



(the detaining whereof he suspected, and purposed to punish for example), gave the soldier a piece of gold to drink in **usquebagh** for better digestion, and so dismissed him.


The foresaid wild Irish do not thresh their oats, but burn them from the straw, and so make cakes thereof, yet they seldom eat this bread, much less any better kind, especially in the time of war, whereof a Bohemian baron complained, who, having seen the courts of **England** and **Scotland**, would needs out of his curiosity return through **Ireland** in the heat of the rebellion; and having letters from the King of Scots to the Irish lords then in rebellion, first landed among them in the furthest north, where for eight days' space he had found no bread, not so much as a cake of oats, till he came to eat with the **Earl of **Tyrone****, and after obtaining the **Lord Deputy**'s pass to come into our army, related this their want of bread to us for a miracle, who nothing wondered thereat. Yea, the wild Irish in time of greatest peace impute covetousness and base birth to him that hath any corn after Christmas, as it were a point of nobility to consume all within those festival days. They willingly eat the herb shamrock, being of a sharp taste, which, as they run and are chased to and fro, they snatch like beasts out of the ditches.


Neither have they any beer made of malt and hops, nor yet any ale—no, not the chief lords, except it be very rarely; but they drink milk like nectar, warmed with a stone first cast into the fire, or else beef-broth mingled with milk. But when they come to any market town to sell a cow or a horse they never return home till they have drunk the price in Spanish wine (which they call the King of Spain's daughter), or in Irish **usquebagh**, and till they have outslept two or three days' drunkenness. And not only the common sort, but even the lords and their wives; the more they want this drink at home, the more they swallow it when they come to it, till they be as drunk as beggars.


Many of these wild Irish eat no flesh, but that which dies of disease or otherwise of itself, neither can it scape them for stinking. They desire no broth, nor have any use



---

p.230



of a spoon. They can neither seethe artichokes nor eat them when they are sodden. It is strange and ridiculous, but most true, that some of our carriage horses falling into their hands, when they found soap and starch carried for the use of our laundresses, they thinking them to be some dainty meats did eat them greedily, and when they stuck in their teeth cursed bitterly the gluttony of us English churls, for so they term us. They feed most on white meats, and esteem for a great dainty sour curds, vulgarly called by them **Bonaclabbe**.[29](javascript:footNote('T100071/note029.html')) And for this cause they watchfully keep their cows, and fight for them as for their religion and life; and when they are almost starved, yet they will not kill a cow, except it be old and yield no milk. Yet will they upon hunger in time of war open a vein of the cow and drink the blood, but in no case kill or much weaken it. A man would think these men to be **Scythians**, who let their horses blood under the ears, and for nourishment drink their blood, and, indeed (as I have formerly said) some of the **Irish** are of the race of **Scythians**, coming into **Spain**, and from thence into **Ireland**. The wild Irish (as I said) seldom kill a cow to eat, and if perhaps they kill one for that purpose, they distribute it all to be devoured at one time; for they approve not the orderly eating at meals, but so they may eat enough when they are hungry they care not to fast long. And I have known some of these Irish footmen serving in **England** (where they are nothing less than sparing in the food of their families) to lay meat aside for many meals to devour it all at one time.


These wild Irish, as soon as their cows have calved, take the calves from them, and thereof feed some with milk to rear for breed; some of the rest they slay, and seethe them in a filthy poke, and so eat them, being nothing but froth, and send them for a present one to another. But the greatest part of these calves they cast out to be eaten by crows and wolves, that themselves may have more abundance of milk.



---

p.231



And the calves being taken away, the cows are so mad among them, as they will give no milk till the skin of the calf be stuffed and set before them, that they may smell the odour of their own bellies. Yea, when these cows thus madly deny their milk the women wash their hands in cows' dung, and so gently stroke their dugs, yea, put their hands into the cow's tail, and with their mouths blow into their tails, that with this manner (as it were) of enchantment they may draw milk from them. Yea, these cows seem as rebellious to their owners as the people are to their kings, for many times they will not be milked, but of some one old woman only, and of no other.


These wild Irish never set any candles upon tables. What do I speak of tables? since, indeed, they have no tables, but set their meat upon a bundle of grass, and use the same grass for napkins to wipe their hands. But I mean that they do not set candles upon any high place to give light to the house, but place a great candle made of reeds and butter upon the floor in the midst of a great room; and in like sort the chief men in their houses make fires in the midst of the room, the smoke whereof goeth out at a hole in the top thereof. An Italian friar coming of old into **Ireland**, and seeing at **Armagh** this their diet and nakedness of the women is said to have cried out:


> 1. Civitas Armachana, civitas vana,
>   
> Carnes crudae, mulieres nudae.
> 



> 1. Vain Armagh City, I did thee pity,
>   
> Thy meat's rawness, and women's nakedness.
> 




I trust no man expects among these gallants any beds, much less feather beds and sheets, who like the nomads removing their dwellings, according to the commodity of pastures for their cows, sleep under the canopy of heaven, or in a poor house of clay, or in a cabin made of the boughs of trees, and covered with turf, for such are the dwellings of the very lords among them. And in such places they make a fire in the midst of the room, and round about it they sleep upon the ground, without straw or other thing under them, lying all in a circle about the fire with their



---

p.232



feet towards it. And their bodies being naked, they cover their heads and upper parts with their mantles, which they first make very wet, steeping them in water of purpose, for they find that when their bodies have once warmed the wet mantles the smoke of them keeps their bodies in temperate heat all the night following. And this manner of lodging, not only the mere Irish lords and their followers use, but even some of the English-Irish lords and their followers, when, after the old but tyrannical and prohibited manner, vulgarly called coshering,[30](javascript:footNote('T100071/note030.html')) they go (as it were) on progress, to live upon their tenants, till they have consumed all the victuals that the poor men have or can get. To conclude, not only in lodging passengers not at all or most rudely, but even in their inhospitality towards them, these wild Irish are not much unlike to wild beasts, in whose caves a beast passing that way might perhaps find meat, but not without danger to be ill entertained, perhaps devoured of his insatiable host.














