

#The Aran Isles: or, A report of the excursion of the Ethnological section of the British association from Dublin to the western islands of Aran, in September, 1857


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Aran Isles: or, A report of the excursion of the Ethnological section of the British association from Dublin to the western islands of Aran, in September, 1857
===================================================================================================================================================================


Author: Martin Haverty
----------------------


### File Description

Electronic edition compiled and proof corrections by Beatrix Färber 

Additional proof corrections by Rebecca Daly

Funded by School of History, UCC 1. First draft.Extent of text: 
17750 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2018) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E850007-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

This is "a revised and extended version of the Report of the Aran excursion proceedings, originally published in the Freeman's journal." A hardcopy is available in the NLI and TCD Library, but not in the Boole Library, UCC. The book is available online at the Hathi Trust. CELT is grateful to volunteer Rebecca Daly for her help with proof-reading.

#### Sources


**Works mentioned in this report**2. The Battle of Moytura. For bibliographic details please refer to CELT file G300010, Cath Maige Tuired: The Second Battle of Mag Tuired, edited by Elizabeth A. Gray.
3. Roderic O'Flaherty, Ogygia seu, Rerum Hibernicarum chronologia: Ex pervetustis monumentis fideliter inter se collatis eruta, atque e sacris ac prophanis literis primarum orbis gentium tam genealogicis, quam chronologicis sufflaminata praesidiis. (...) (London 1685). (An English translation by the Reverend James Hely was published in Dublin 1793).
4. Roderic O'Flaherty, A chorographical description of West or H-Iar Connaught: written A.D. 1684, ed. James Hardiman (Dublin 1846).
5. John Colgan, Acta Sanctorum Hiberniae (Leuven (=Louvain) 1645).
6. The Annals of the Four Masters. For bibliographic details please refer to CELT file G100005D (Irish) and T100005D (English).
7. Giraldus Cambrensis, Topographia Hibernica, 1188: J. F. Dimock (ed.), Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera (London 1867).
8. Samuel Ferguson, "Clonmacnoise, Clare, and Arran", Dublin University Magazine XLI (1853) part 1, January 79–95; part 2, April 492–505.
9. On Sir Samuel Ferguson, see also Mary Catherine Ferguson (ed), Sir Samuel Ferguson in the Ireland of his day, (Edinburgh and London 1896).
10. Charles C. Babington, "On the Firbolgic Forts on the South Isles of Aran, Ireland", Archaeologia Cambrensis, vol. iv, ser. iii, January, 1858, 96–103.
11. George Petrie, The ecclesiastical architecture of Ireland: anterior to the Anglo-Norman invasion, comprising an essay on the origin and uses of the round towers of Ireland (Dublin 1845).
12. Richard Kirwan, "On the Primitive State of the Globe and Its Subsequent Catastrophe", Transactions of the Royal Irish Academy
vol. 6 (1797) 233–308 (available online on JSTOR.org at https://www.jstor.org/stable/30077059).
13. John T. O'Flaherty, "A Sketch of the History and Antiquities of the Southern Islands of Aran, Lying off the West Coast of Ireland; with Observations on the Religion of the Celtic Nations, Pagan Monuments of the Early Irish, Druidic Rites, &c.", Transactions of the Royal Irish Academy, vol. 14 (1825) 79–139 (available online on JSTOR.org at https://www.jstor.org/stable/30079121).
**The edition used in the digital edition**2. The Aran Isles or a report of the excursion of the technological section of the British Association from Dublin to the western Isles of Aran in September 1857. Martin Haverty First edition [45 pages] Printed for the excursionists, at the University press, by M. H. Gill Dublin (1859)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 1–45. The complete pdf file of the printed text is available at https://babel.hathitrust.org/cgi/pt?id=mdp.39015028727058;view=1up;seq=9.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT. A small number of typos in the printed text were corrected using corr sic. 


##### Normalization


Normalization has not been necessary. The spelling of some Irish terms and place-names varies in the report; this has been left intact. There are two illustrations omitted from p.21 of the the electronic edition. For these, the reader is referred to https://babel.hathitrust.org/cgi/pt?id=mdp.39015028727058;view=1up;seq=9.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word. This is also the case where a tagged name or term crosses a page-break. 


##### Segmentation


div0=the book; div1=the chapter; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


The more important personal names, and titles of books and periodicals are tagged. Words, and phrases from other languages than English are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: By Martin Haverty
 (1859) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] A number of phrases, names and terms are in Irish.


##### Language: [FR] One phrase and a short speech are in French.


##### Language: [LA] One word and a quote are in Latin.


##### Language: [IT] One word is in Italian.


### Revision History


* (2018-07-18) Beatrix Färber (ed.)

* Header created; bibliographic details compiled; file parsed and validated, wordcount made, SGML and HTML files created.
* (2018-07-17) Beatrix Färber (ed.)

* File proofed and errors corrected; more structural and content markup applied.
* (2018-07-09) Rebecca Daly (ed.)

* File proofed (1) and errors recorded.
* (2018-03) Beatrix Färber (ed.)

* File proofing (1) and markup begun.
* (2017-11-09) Beatrix Färber (ed.)

* File captured.




---


#### Corpus of Electronic Texts Edition: E850007-001


### The Aran Isles: or, A report of the excursion of the Ethnological section of the British association from Dublin to the western islands of Aran, in September, 1857: Author: Martin Haverty




---

p.3


ETHNOLOGICAL EXCURSION TO THE ARAN ISLES.
-----------------------------------------


The Members and Associates of the **Ethnological Section** of the **British Association**, who had been enrolled for the Excursion to the Western Islands of Aran, assembled with punctuality at the Broadstone Terminus of the Midland Great Western Railway at an early hour on the morning of Thursday, September 3, 1857. With them were many other Members of the Association, who had obtained tickets for other excursions in the West; and the whole company occupied a long train of first-class carriages, which had most generously been placed specially at the disposal of the Association by the Railway Directors.


The Aran Excursion, however, is that with which alone we are here concerned. Owing to many circumstances, it was necessary to limit the number of this party. It was found that more than seventy could not be accommodated with tickets, and several gentlemen who had been most urgent in their application were unavoidably excluded. The Excursion was projected and organized, and was now to be conducted by W. R. Wilde, Esq., Secretary of Foreign Correspondence to the **Royal Irish Academy**, to whose talents, learning, and indefatigable zeal, — and, we must say, enthusiasm, — we have been so much indebted for the elucidation and development of our national antiquities.




---

p.4


The project had excited a good deal of public interest. It was a great opportunity turned admirably to account; and if much was expected from it, the sequel, we are happy to say, will show that these anticipations have been realized, and that the Aran Excursion has, in truth, been the most memorable and the most important exploration of Irish historical monuments that has ever yet taken place. The train started at 7 o'clock, and arrived in **Galway**, without any incident worth description, about 11 o'clock. Here a large number separated into various parties, for the purpose of visiting **Lough Corrib**, and the wild scenery of **Joyce Country** and **Connemara**; while the Aran excursionists, who may, strictly speaking, be still called the **Ethnological Section**, after partaking of a cold breakfast at Kilroy's Hotel, and taking a hasty glance at some objects of interest in the ancient ‘City of the Tribes,’ proceeded to the Trinity House steam yacht, Vestal, Captain Evans, which lay inside the flood-gates of the new docks, waiting for high water to start on her voyage. How this fine boat was obtained for the occasion, and how everything else connected with this remarkable expedition was brought about, will appear in the course of the transactions which we have here to record. It is material to add that the weather, which had been doubtful for a while, now brightened up, and promised a glorious day. Thus far, everything went on most happily. The arrangements were perfect. The Excursionists were in the best spirits; and it was evident that a keen anticipation of something of more than ordinary interest had been excited in the breasts of all.[1](javascript:footNote('E850007-001/note001.html')) At half-past 1 o'clock the Vestal, with her learned and distinguished freight, left the quays of **Galway**, and, after a few minutes' delay near **Mutton Island**, to put Mr. Halloran, the pilot, on shore, she proceeded, with a slight breeze from the west, on her course through the centre of the bay, towards those not yet visible points in the Atlantic which, a thousand years ago, were well known in the quaint Latin of the time as ‘Insulae in oceano occidentali positae cognomento **Arann**’.




---

p.5


Our party of ethnologists were, as we have said, seventy in number, comprising —
1. Rev. Dr. Mac Donnell, Provost of Trinity College, Dublin, Chairman.
2. Charles C. Babington, St. John's College, Cambridge.
3. F. de Burggraff, French Consul, Dublin.
4. Francis W. Brady, Dublin.
5. Captain Brownrigg, Dublin.
6. F. W. Burton, Munich.
7. L. F. Byrne, Blackrock.
8. John A. Byrne, M.D., Dublin.
9. General Colomb, Dublin.
10. Pierce Creagh, Dublin.
11. Professor E. Curry, Dublin.
12. Sir Thomas Dancer, Naas.
13. J. F. Duncan, M.D., Dublin.
14. George Ellis, M.D., Dublin.
15. Stephen N. Elrington, Dublin.
16. Samuel Ferguson, Dublin.
17. Thos. Fitzpatrick, M.D., Dublin.
18. Charles H. Foot, Dublin.
19. Richard H. Frith, C.E., Dublin.
20. A. E. Gayer, Q.C., LL.D., Dublin.
21. John T. Gilbert, Sec., Irish Arch, and Celtic Society, Dublin.
22. M. Goodbody.
23. John Grattan, Belfast.
24. Rev. C. Graves, F.T.C.D., Dublin. (see https://en.wikipedia.org/wiki/Charles\_Graves\_(bishop))
25. Rev. Richard Graves.
26. Martin Haverty, Askeaton.
27. Thomas Hayden, M. D., Dublin.
28. Charles H. Hemphill, Dublin.
29. Rev. J.H. Jellett, F.T.C.D., Dublin.
30. Charles B. Johnston, Dublin.
31. C. Croker King, M. D., Galway.
32. Cathcart Lees, M. D., Dublin.
33. John Lentaigne, D. L., Dublin.
34. Joseph Lister, Edinburgh.
35. L. Litton, Dublin.
36. Acheson Lyle, M. C., Dublin.
37. George Macdona, Dublin.
38. H. H. G. Mac Donnell, Dublin.
39. Captain R. Maguire, R. N., of the late Arctic Expedition.
40. William Millen, Belfast.
41. J. M. Mitchell, Sec. Foreign Cor., Antiquarian Soc. of Scotland.
42. Wm. D. Moore, M. D., Dublin.
43. Park Neville, C. E., Dublin.
44. John O'Donovan, LL.D., Dublin.
45. W. J. O'Donovan, London.
46. Thomas O'Hagan, Q.C., Dublin.
47. Captain Percy, Dublin.
48. George Petrie, LL. D., Dublin.
49. William Robinson, Dublin.
50. Professor J.Y. Simpson, Edinburgh.
51. Dr. Norton Shaw, Secretary, Geographical Society, London.
52. Aquilla Smith, M. D., Dublin.
53. R. Mackay Smith, Edinburgh.
54. Huband Smith, Dublin.
55. William Stokes, M. D., Dublin.
56. Whitley Stokes, London.
57. Rev. John W. Stubbs, F.T.C.D., Dublin.
58. Thomas H. Thompson, Dublin.
59. H. P. Truell, Wicklow.
60. Robert Truell, Wicklow.
61. Jolliffe Tuffnell, F.R.C.S.I., Dublin.
62. Henry Wilson, Dublin.
63. W. R. Wilde, Director of the Excursion.
64. Andrew Armstrong, Secretary.





---

p.6


Leaving **Galway** and its fine modern railway structures — so strongly contrasted with its mediaeval castles and dingy, ancient walls — behind us, and the low, wooded peninsula of **Maree**, or the ancient **Madrigia**, where terminated the Eskers, or ridges of sandy hills that extend across Ireland from Dublin, and separated the island into its first Milesian divisions of **Leath Mogha** on the south, and **Leath Cuinn** on the north — leaving those places so often mentioned in Irish history far behind, we passed on the right the white cliffs of **Barna**, and then by the gloomy highland bogs of **Iar-Connaught**, to which soon succeeded the rugged coasts of **Cashla Bay**, and the craggy isles of **Lettermore** and **Lettermullin**, with the light blue masses of the **Joyce Country Mountains**, and the clustered pinnacles at **Benabeola**, or the **Twelve Pins**, traced against the azure background in the far distance; and on the left the limestone hills of **Burren**, forming, every few minutes, as we glided rapidly over the bay, new and beautiful combinations, varied, in the lights and shadows of a hazy sunshine, by the deep inlets of **New Quay** and **Ballyvaughan**, and the majestic promontory of **Black Head**. While thus advancing towards our destination, it may be well to tell, in a few words, something of the history of those Islands of strange interest — **Aran-na-neev**, or **Aran of the Saints** — whither we are journeying, that the reader may be the better able to enter into the spirit of our pilgrimage.


HISTORY OF ARAN
---------------


Every one is familiar with the form, on the map, of the three south islands of Aran, which run in a N.W. and S.E. direction across the mouth of **Galway Bay**, between **Connemara** on the north-west, and the county of **Clare** on the south-east. They are supposed to have been, at some stage of the world's history, connected with each other, and with the mainland on either side; and the Irish name for the Bay of **Galway** — **Loch Lurgan** — would seem to support that hypothesis; but, as several arms of the sea around the Irish coast are called loughs, as **Lough Swilly**, **Lough Foyle**, **Belfast Lough**, **Lough Strangford**, **Lough Goramon** (Wexford Haven), &c., there is no reason to think that **Lough Lurgan**, rather than any of the others, was ever a body of fresh water. It 


---

p.7



is stated in the old chronicles to have been one of the two lakes which Partholan's colony found in Ireland on arriving here 200 years after the Flood. The largest of the three islands is probably the only one to which the name of **Aran** was originally applied; supposing the derivation of the name suggested by an ancient writer, **Augustin Magraiden**, to be the true one, namely, that **Ara** signifies a ‘a kidney’ in Irish, such being the shape of the large island. The derivation is a fanciful one, but no better has yet been discovered by Irish scholars. The names of the three islands in Irish are — **Ara Mor**, or Great Aran; **Inis Maan**, or Middle Island; and **Inisheer**, or Eastern Island. The nearest point of the large island is about 28 miles from the quays of **Galway**. The large island is 9 miles long; the middle one 3 miles; and the smallest 2 ½ miles. They are all composed of carboniferous limestone, with some peculiarities of formation which we shall have occasion hereafter to notice. At the last Census they contained 3333 inhabitants, and out of a total area of 11,288 acres which they contain, little more than 700 are productive.


The earliest reference to the pre-Christian history of **Aran** is to be found in the accounts of the battle of **Moyturey**, in which the Firbolgs, having been defeated by the Tuatha-de-Dananns, were driven for refuge into **Aran**, and other islands on the Irish coast, as well as into the western islands of Scotland. It seems doubtful whether the **Aran** mentioned on that occasion be the island of the same name on the coast of **Donegal**, or those in the **Bay of Galway**; although the fact that the route took place in the direction of **Sligo**, and that some of the Firbolgs certainly retired into the Scottish islands, renders the former the more probable supposition. Still, **Dr. O'Donovan** asserts that there is no positive authority on the subject, and that it is extremely probable that the Firbolgs did retire into our southern **Aran Isles** after their defeat on the occasion in question, and that some of the military remains now visible on the island must be attributed even to that period — namely, to a time considerably more than a thousand years before the birth of Christ. If, however, there be any doubt on this point, there is none whatever as to the second period at which we find the Firbolgs mentioned in connexion with these islands; and that is about the first century of the 


---

p.8



Christian era, when Ængus, Conchovar,[2](javascript:footNote('E850007-001/note002.html')) and Mil, the three sons of Uamore, with their numerous sept, being driven from the islands of Scotland by the Crithnians or Picts, came into Ireland, the country of their ancestors, and settled for a while in Leinster; but being obliged to relinquish the land they held there, owing to the exorbitant rent exacted for it by Cairbre, the King of Tara, they crossed the Shannon into Connaught, where a great part of the population was still composed of their own ancient race, and where they were well received by the celebrated Queen Maeve, who granted to them the **Islands of Aran**. Here they immediately fortified themselves in great stone duns, that must at that time have been impregnable, and the remains of which are objects of our curiosity and wonder at the present day. The names of the three brothers are still preserved in connexion with the topography of the Islands. The ancient fort on the great island, of which our early antiquaries had some imperfect knowledge, and which occupies the most interesting position on the brow of the loftiest precipice of all the islands, being called Dun Ængus; the great fort of the middle island, superior in strength and preservation to the former, bearing the name of **Dun Connor**, or Conchovar; and the name of Mil being associated with the low strand of **Port Murvey**, which forms the hollow or indentation of the ‘Kidney,’ and was formerly known as **Muirveagh Mil**, or the Sea-Plain of Mil. These particulars are mentioned in **O'Flaherty**'s Iar-Connaught and Ogygia; and more in detail in an Irish manuscript tract on the Firbolgs, by **Mac Firbis**, who refers to much older authorities on the subject.


We now arrive at a period of the history of **Aran** possessing an interest of a different kind, but also full of attraction for the antiquary, namely, that of the introduction of Christianity, and the foundation of the first monastic institution there by St. Endeus, in the sixth century. This holy personage, whose name is written indifferently Endeus, or Enda, in the old Latin Lives of the Saints, and is pronounced Eaney, or Ena (with the Spanish liquid �), in the spoken Irish, was of the royal house of Oriel, a 


---

p.9



territory which included the present counties of **Louth**, **Armagh**, and **Monaghan**. He was converted by his sister, St. Fanchea, a nun, and repaired for religious education to Italy, where he became the founder or head of a large monastery; and, returning to Ireland after many years, with a numerous body of his monks, he obtained, at the solicitation of St. Ailbe, the first Bishop of Cashel, from Aengus, the first Christian King of Munster, the **Aran Island**, which would thus appear to have passed from the jurisdiction of the kings of Connaught to that of the kings of Munster since the days of Maeve. St. Endeus found **Aran** occupied by a few Pagans, out of **Corcomroe**, in **Clare**, who were probably of the Firbolg race, as **Professor Curry** says that a sept of the Firbolgs can be traced for a long time in that part of **Thomond**.[3](javascript:footNote('E850007-001/note003.html')) The Pagans fled in their curraghs, without waiting to hear the word of God; and the Saint, in process of time, founded no fewer than ten religious establishments in the island.[4](javascript:footNote('E850007-001/note004.html')) **Ara Mor** soon became celebrated among all the anchorites of western Europe, and was divided into two parishes, over the eastern one of which St. Endeus himself presided, while the other was governed by the most eminent of his disciples, St. Brecanus, or Brecan (pronounced Breccaun), who was the son of Eochy-Ball-Dearg, Prince of Thomond, and was the founder of the old diocese of **Ardbraccan** in **Meath**. The names of several other holy persons are also preserved in connexion with the religious antiquities of the island, as St. Benan, or Benignus, St. Cronan, St. Caradoc, a Briton; St. Mac Duagh, St. Mac Longius, St. Esserninus or Nehemias, St. Brendan of Clonfert, the famous navigator, who visited St. Endeus in one of his great Atlantic voyages, and started from **Aran** on his supposed voyage of discovery to America; St. Kiaran of Clonmacnois, SS. Fursey, Brendan of Birr, Conal, and Berchann, who are believed to have been the holy persons after whom one of the churches was called **Tempull an Cheathruir Aluin**, or the Church of the Four Beautiful Saints, and several others. In



---

p.10



fact, **Aran** became a great school of asceticism and sanctity, where many hundreds of holy men from other parts of Ireland, and from foreign countries, constantly resorted to study the sacred Scriptures, and to learn and practise the rigid austerities of a hermit's life. An ancient writer states, that in one small cemetery here the bodies of 120 saints repose, and that ‘there are more saints buried in **Aran** than are known to any but God alone.’ In fact, relics, as sacred as those which the Catholic pilgrim travels to venerate in other countries, here lie neglected and forgotten under moss and brambles on our own deserted shores.


**Giraldus Cambrensis** had heard some strange stories about **Aran**, and inserted them in that medley of absurdities and calumnies which he called the Topography of Ireland. About his time (the thirteenth century) we find that these islands were in the possession of the *O'Briens* of Tromra, in Thomond; and in subsequent ages they were a source of frequent warfare between that sept and the O'Flaherties of West Connaught. Ultimately, in the reign of Elizabeth, **Sir Murrough O'Flaherty** succeeded in expelling the O'Briens, and gaining possession of the Great Island; but the Queen declared both parties traitors, and seized **Aran** as her own.


About 1645, when Colgan was editing at Louvain, in his Acta Sanctorum Hiberniae, the life of St. Endeus, from a manuscript compiled by **Augustin Magraidin**, in the fourteenth century, from some authority which appears to have been as old as the days of Paganism, he obtained from Dr. **Malachy O'Kealy, Archbishop of Tuam**, a list of all the principal churches in that archdiocese, from which he extracted the names of those then to be found in the **Aran Islands**. From that list it appears that there were then thirteen churches in the Great Island, two in the Middle Island, and three in Inisheer; and as these are said to have been the ‘principal’ churches, it is probable that there were others of lesser note, or which had then been suffered to go into decay. Not many years after the compilation of that list, the work of destroying the monasteries of **Aran** — commenced, no doubt, some time before — was carried into complete effect; and Cromwell's soldiers, being in occupation of the island, demolished the great parish church of St. Endeus, with others which stood near it, for the purpose of using the materials to rebuild and extend the fort or 


---

p.11



citadel of **Arkin**, the possession of which gave them the command of the entrance to **Galway Bay**. This fort was considered to be of so much importance in 1585, that all the patents for land in Iar-Connaught were granted to be held as ‘of the Queen's manor or castle of Arkyne’; and it was a formidable obstruction to the trade of **Galway**, whenever that town did not stand well in the estimation of the English garrison in **Aran**.


From even this brief outline of the history of **Aran** the reader will be enabled to form some idea of what the antiquary may expect to find upon its almost undisturbed surface, and of the different kinds of feeling with which different classes of tourists may visit its shores — whether as religious pilgrims, who would almost kiss the rocks where so much sanctity has dwelt, or as enthusiastic lovers of antiquity, in search of pre-historic monuments and cyclopean churches — whether, in fact, they come to visit **Aran** of the Firbolgs or **Aran** of the Saints.


THE LANDING
-----------


After a voyage of about three hours, the Vestal cast anchor in a small bay, at one side of which, to the right, is the neat and important village of **Kilronan**, and at the other, but nearer to the head of the bay, that of **Killeany**. The ship's boats having been lowered, the excursionists, with their aid and that of the coastguard boat, which had put off from the island, were landed at **Killeany**, close under all that remains of Cromwell's old castle of **Arkin**. The inhabitants of the village had crowded to the shore, and their picturesque appearance, while collected in groups, the men in their costume of fishermen, and the women and girls wearing the characteristic red petticoats, and, for the most part, red or blue bodices, made the effect very striking in the eyes of strangers. All the houses in the village, as well as in the island generally, had been recently whitewashed, and the people looked comparatively clean and comfortable, although the poor fishing village of **Killeany**, to which scarcely any land is attached, is the most wretched in the entire island.


**Mr. Wilde**'s duties as cicerone now commenced, and, piping all hands with a small whistle, the shrill sound of which will be 


---

p.12



associated with many an interesting reminiscence in the memory of the **Aran** excursionists, he explained in a few words the origin and character of the old walls of **Arkin**; and, observing that they were only a Saxon, and comparatively modern innovation, he sprang over a neighbouring wall, and away went the whole bevy of ethnologists, old and young, learned doctors, reverend divines, eloquent men of law, profound science scholars, artists, naturalists, enthusiastic archaeologists, and all, over innumerable walls which intersect the surface of the island everywhere, dividing the arable portions of it into small patches of two or three perches each. These walls were rudely built of single stones, and came tumbling down at every touch; yet away went the savans surmounting every obstacle, and anon clambering up the sides of the rocky hill, to the utter amazement of the poor natives, who looked like people that had passively abandoned their island to invaders. In a few minutes **Mr. Wilde** came to a halt, about half way up the hill, and announced that they had arrived at the Round Tower. At this moment the excursionists were still strewed in a long train from the landing-place to the point of interest, struggling as well as they could to ascend among rocks, briars, and stone walls; but at length they arrived, and found themselves collected round the base of a real Round Tower, at present only a few feet high, but which, at a comparatively recent period, rose to a considerable elevation. It was impossible to compare the masonry of the well-dressed and neatly fitted blocks of which it was composed with the rude, uncemented walls of the old Pagan fortresses, of which we saw so many during our exploration of these islands, without feeling the absurdity of attributing to it anything like the antiquity which unquestionably belonged to the latter. The circumference of the base is about 49 feet, and the height at present is only some 4 or 5 feet. From the Round Tower we continued to ascend over rocks, unmingled with the least vegetation, until at the highest point of this, the eastern end of **Ara Mor**, we came to the beautiful cyclopean Oratory of St. Benan or Benignus. Here **Dr. Petrie**, at the invitation of **Mr. Wilde**, proceeded to give the audience, now collected about him, a brief explanation. He directed their attention, 


---

p.13



in the first place, to the fine scene spread out at their feet. Below them, in the deep valley, once lay the parish church of Teampull Mor Enda, surrounded by a group of other churches, among which was one dedicated to the Blessed Virgin. These, however, had all been removed to construct the Elizabethan and Cromwellian fort which we have mentioned, and not even a trace of their foundations was now to be seen. Far off to the east, on the sandy beach, appeared the walls of the small **Teglach Enda**, which was the mortuary chapel of a small cemetery, in which St. Endeus himself and 127 others are said to have been interred, and in which, according to tradition, none but saints were buried. Straw Island was seen beyond, and a good deal to the right the shores of **Inis Maan**. In the centre of the bay which swept round to the left lay the graceful form of the Vestal, buoyant on the green, transparent sea, — as beautiful a model of a steam yacht as could well be conceived, — with the standards of the Trinity House floating from her mast-heads and her stern flagstaff, numerous small curraghs plying between her and the shore. At a distance of fourteen or fifteen miles to the north was spread out the rough coast of **Connemara**, with its blue mountains in the back ground. Altogether it was a scene from which it was not easy to withdraw the eyes, even of antiquaries, to fix them on the humble little oratory round which we were assembled. **Dr. Petrie** then expressed his opinion that this building was an undoubted sixth century church, and one of the most interesting in the island. It stands nearly north and south, contrary to the usual rule, and its walls are composed of huge stones, one of which was nearly sufficient to form the western side of the building. The gables taper to a great height, and there is no doubt that the roof was formed of overlapping stones. A little in front of the oratory are the ruins of St. Benan's humble hermitage, sunk partly in the rock, and formerly roofed with stone; and at a short distance are the remains of a dilapidated cashel, or group of small stone houses, or cloghauns, in which, probably, the monks resided. **Dr. Petrie** observed that, when he was in the island, thirty-five years ago, the Round Tower they had just visited was much higher than at present; and he then met an old islander who remembered when it was 82 feet in height.




---

p.14


From this point the party proceeded over the interminable sharp rocks to the south-western or Atlantic shore of the island, occasionally meeting granite boulders, or Connemara stones, as they are called, on their way; and here on the steep ocean cliff they entered the ancient Firbolgic fortress of **Doo Caher**, or the Black Fort, the principal features of which were explained to them by **Mr. Wilde**. The wall of the Dun, which was in some places about 20 feet high, was of enormous thickness, and of the rudest cyclopean masonry, and extended across the neck of a peninsula, the remaining sides of which, being terrific precipices, were amply defended against attack. In front of the wall was a chevaux de frise of sharp stones, placed erect in the fissures of the rocks; and in the interior of the Dun were the confused ruins of several cloghauns, which **Mr. Wilde** stated had been very much dilapidated since the period of his former visit, ten years before, but that he fortunately possessed a drawing of one of the most remarkable. The walls, as the name of the Dun indicates, have a blackened appearance, and **Dr. O'Donovan** expressed his belief that this building is probably a thousand years older than Dun Ængus, and that it belonged to about the earliest people who occupied the country.[5](javascript:footNote('E850007-001/note005.html'))


From **Doo Caher** the party recrossed the island to **Kilronan**, the principal village, and which boasts the luxury of a hotel; and having gone on board the Vestal to have tea, the greater number again disembarked, and spent the night in the village, where they were accommodated with excellent beds in the Atlantic Hotel, at the Coast-guard station, and in the houses of the islanders.




---

p.15


SECOND DAY
----------


### THE SEVEN CHURCHES


After breakfast the vessel was got under weigh, and conveyed the tourists round the north-eastern side of the island, landing them on the beach of **Glenaghaun**, not far from **Teampull Brecain**, or the Seven Churches, near the north-western extremity of the Great Island. This beach presents at low water some exceedingly curious features in its formation. Like the rest of the island, it is of solid limestone, the horizontal strata being, as in many other parts of the island, broken by vertical fissures into thin, sharp layers, almost resembling enormous hatchets placed side by side, with their sharp edges uppermost. Again, the broader ledges are eaten, apparently by the agency of small marine animals, into large basins filled with the water of the last tide; and the bottom and sides of these basins, below the waterline, are perforated like honeycombs with innumerable round cavities, all occupied by young **Echini marini** embedded in the substance of the rock, while the sea anemone and other strange productions of the deep are deposited wherever it is possible in the interstices. It was not without some difficulty that **Mr. Wilde** was able to get the stragglers of his party away from these marvels of natural history, and to collect them in the small rocky glen in which stand the interesting walls of **Teampull Brecain**, and **Teampull a Phuill**, or the Church of the Hollow, the only remains now left of the Seven Churches that were, in remote ages, clustered in this secluded spot. **Dr. Petrie**, at the request of **Mr. Wilde**, favoured the party with some particulars about St. Brecan's Church, within which they were assembled. St. Brecan, its founder, was the same who founded the episcopal church of Ardbraccan, in**Meath**, and was the grandson of Carthen Finn, who was baptized by St. Patrick, and was the first Christian Prince of Thomond, and son of Achy Balldearg, also the prince or chieftain of the same territory. The grave of St. Brecan was opened about sixty years ago, and was subsequently reopened in the presence 


---

p.16



of the parish priest, and of Mr. O'Flaherty, the magistrate, for the inspection of **Dr. Petrie**, who found in it a well-shaped skull, which he believed to have been that of the saint, and which was immediately and carefully restored to its resting-place, and also the cross, or headstone of St. Brecan, which was afterwards taken away by some person not now known. Several inscribed stones have been found about this ancient church, one of which bears the words ‘VII ROMANI’, ‘the seven Romans’. An interesting Irish inscription, on a raised scroll, on the inner side of the west gable, was discovered by **Mr. Wilde** on his former visit to **Aran**, but, as it is imperfect, the antiquaries who now examined it could not agree in their versions of its supposed meaning, except that it begins by requesting a prayer for some one whose name is partly defaced. The church consists of a chancel and choir, the latter of which is much more modern than the former, and may belong to the twelfth century — its circular choir arch and lancet east window being exquisite pieces of masonry, while the chancel is built in a rude style, with cyclopean windows.


Around this church are traces of several monastic buildings, and a finely engraved terminal cross; and about two hundred yards to the north is the foundation of a small square castle of the sixteenth or seventeenth century, which, judging from the thickness of the walls, must have been of enormous strength. It is called ‘Sean Caislean’, or the ‘Old Castle’. On ascending from the glen, amid some steep rocks, we come to a small, oblong enclosure, called an **aherla**, which word, as **Dr. O'Donovan** thinks, means a tomb, and is applied to one or two other remains on the island; and close by this relic are two richly carved crosses, the fragments of which were discovered and put together, the first by **Mr. Wilde**, and the second by **S. Ferguson, Esq.**, some years since. The circumstance is thus alluded to by the latter gentleman in some interesting papers on **Aran**, which he published in the University Magazine for February *(recte January)* and April, 1853: — ‘In the neighbourhood of the Seven Churches they preserve a grateful recollection of the interest taken in the preservation of their antiquities by **Mr. Wilde**, during a visit to those islands several years ago. At his instance (or rather, we 



---

p.17



should say, under his direction, and in a great measure with his own hands), the fragments of a richly sculptured stone cross, which had long lain scattered in different directions about the ruins, were brought together, adapted to one another, and laid in their places on a smooth, flat rock, forming part of the threshing-floor of Martin O'Flaherty, the guardian of the ruins. The fragments have been surrounded with a low wall of dry stone to keep off the trespass of cattle, and are an object of much respect, and the source of very grateful feeling towards their restorer. I also succeeded in collecting from various quarters of the ruins, and surrounding stone wall fences, the fragments of another cross of greater dimensions, but ruder workmanship, which is now laid side by side with that restored by **Dr. Wilde**. On one side is a sculpture of the Crucifixion, of extremely barbarous design; the other is carved with knots and patterns of interlaced work of the usual kind.’ Each of these crosses was broken into some twelve or thirteen pieces. They are long and narrow, and the arms scarcely project from the sides.


DUN ONAGHT
----------


From the Seven Churches the party followed **Mr. Wilde**, in the best way they could, across the fields of riven rocks to **Dun Onaght** (Eoghanacht), one of the old Firbolgic forts, so called from the name of the townland, the original name being lost; and here the indefatigable leader, having piped his party together, directed their attention to the truly magnificent panorama which they enjoyed from that elevated position. The whole coast of **Connemara** was visible, with **Golin Head** in the foreground, and the grand outline of the **Twelve Pins** beyond; while on the extreme right the bold promontory of **Black Head** arose in one dark mass from the ocean. The fort in which they were then assembled was a nearly perfect one, though the want of a historic name deprived it of the interest which others on the islands enjoyed. It is nearly round, its longest diameter in the inside being about 94 feet. The walls are of regularly shaped, but unhewn, masses of limestone, put together without cement; and they are built against each other in three distinct layers, so that if the outer 


---

p.18



face were demolished by an enemy, a second and a third equally perfect face would present itself. In some parts there were buttresses, and other indications of repair; and in the interior flights of steps to ascend to the platform and parapets above. The date of this and of the other like structures in **Aran** is clearly pre-Christian and pre-historic; but the work of dilapidation has been carried on at such a rate by idle boys for several years past, that there is reason to fear that antiquaries at some future time will have few specimens of them left to ground their conjectures upon. Mr. Thompson, the agent to the property, here addressed the people on the necessity of preserving this and the other memorials on the island from dilapidation. **Dr. O'Donovan** being asked his opinion on the subject, said he considered this fort relatively modern when compared with that of **Duv Caher**, which they had seen the day before; yet when he said modern, he meant that they should go back about 2000 years for the origin of the most recent of them!


From **Dun Onaght** the party crossed the island to the great cliffs on the ocean side, at one of which an exciting exhibition was prepared, which few of the party can ever expect to witness again. We had all heard how the inhabitants of **Aran**, and the **Hebrides**, and some other places, descend the dizzy ocean cliffs by means of ropes, in search of sea-fowls' eggs, and of the birds themselves for the sake of the feathers; and here our ethnologists were to be treated to a view of the appalling feat performed in the most perfect manner. Fifteen or twenty of the hardy islanders had brought their ropes, and when we had assembled at a point which might be called the horn of a crescent-shaped cliff, the rope was fastened round the middle of an old man, upwards of sixty years on the island, who boldly let himself over, whilst a dozen of his comrades payed out the rope from above. When he got down some few yards, this active and fearless old man, striking the rock with his foot, holding the rope with one hand, and preserving his balance with the other, flew, as it were, outwards and downwards, his feet constantly moving like paddles in the air; and as the oscillations of the rope, which grew longer and longer as he descended, brought him towards the cliff, in imminent danger of being dashed to pieces, he struck out again with a bold 


---

p.19



 and graceful movement, until at last, becoming smaller to our eyes as he descended, he reached the bottom. He took off the rope, which was then hauled up, when another and younger man, and after him a third who was a mere lad, performed the same perilous feat in a manner precisely similar. The old man then assumed the rope again, and was swung outwards by his companions below, and during the first long vibration of the living pendulum ascended about fifty feet. The process of striking the cliff was repeated each time he approached it on the ascent, until arriving within thirty feet of the brow of the precipice, he literally commenced to run up the face of it, his body projecting horizontally, supported and raised by the men above; and thus he reached the summit again. Within a few minutes the other men were also brought up in safety, amid the applause of all who beheld the exciting and novel exhibition. It should be added that, with the experienced men who performed those feats, there was really no danger to be apprehended.


DUN ÆNGUS
---------


The name of this fort is pronounced ‘Dun Eanees’ in Irish; but the tradition of the name has been almost lost on the island, where it is usually called the Great Dun. It is built on the brow of an overhanging precipice, the loftiest in the three islands, being 302 feet above the surges at its caverned base. These great precipices are composed of four enormous strata of limestone, each about seventy feet thick, and piled one above the other like the stones of some fabulous cyclopean building, one of the upper strata projecting fearfully over the black abyss beneath it. It is necessary to retire to some of the lower cliffs on either side in order to see this great precipice in all its terrific grandeur; and but few heads are steady enough to venture on a peep down the yawning gulf itself. The walls of **Dun Ængus** are built in a horse-shoe form on the summit of the cliff, at which they terminated on either side.[6](javascript:footNote('E850007-001/note006.html'))




---

p.20


There are three enclosures or semicircles, one outside the other, the innermost wall being by much the thickest; and outside the second wall is a chevaux-de-frise, composed of erect slender stones, securely fastened in the rock, and so close to each other that it is impossible to make one's way through them without much time and caution. These must have presented a formidable obstacle to a foe when the walls within were well manned by desperate defenders. None of the **Aran** forts seem to have suffered so much from dilapidation as **Dun Ængus**; and it is difficult even now, in many parts, to ascertain its dimensions. The innermost enclosure or keep measures 150 feet from north to south, and 140 feet along the edge of the cliff from east to west. The wall which enclosed this space was, as in the other duns, composed of three distinct coatings, the aggregate thickness of which, as far as can be ascertained in their present ruinous state, was 12 feet 9 inches. The doorway which led into this keep measures only about five feet in height, and rather less than 3 feet 6 inches in width.


This was our culminating point of interest — the chief end and object of our pilgrimage. To have seen this would have amply repaid any of the party for the whole fatigue and trouble of the expedition. This was the **Dun Ængus**, whose name is always associated with that of **Aran**, which it has immortalized in the mind of the archaeologist more than all the other remains of antiquity with which the island abounds. This was the Acropolis of **Aran**, — the Palace-fortress of the days of Queen Maeve, — the venerable ruin which **Dr. Petrie**, in his evidence before a Government Commission in 1843, described as ‘the most magnificent barbaric monument now extant in Europe.’ We can here only describe its dimensions, its remote antiquity, its site on the beetling brow of the precipice, its walls, now reduced to little more than crumbling piles of loose stones; but the indescribable feelings of sadness, and awe, and enthusiasm, which the place itself inspired, cannot be conveyed to the reader by any words of ours.




---

p.21


The accompanying illustration affords some idea of the appearance of the fort upon the land-side, with the triple wall, the outer circumvallation, and the chevaux-de-frise. It is taken from a drawing made in 1847 by Mr. Cheyne for **Mr. Wilde**, who had it engraved for Mr. Babington's paper on the Firbolg Forts on the South Isles of Aran, published in the Archaeologia Cambrensis for January, 1858. 
 


THE BANQUET IN DUN ÆNGUS
------------------------


Dinner-hour having arrived, and all our company being assembled within the great Firbolgic fort of **Dun Ængus**, which was most judiciously selected by **Mr. Wilde** as our banquetting-hall on the occasion, and order being, with some difficulty, restored in the ranks of the hungry savans, it was proposed, to the great joy of all, that the repast should commence without further delay. The stewards commenced their duties; the hampers were unpacked; and the company were arranged in a spacious circle on the grass in the centre of the fort, separated from the overhanging brow of the terrific precipice by a wide, low ledge of limestone, which formed a sort of table, upon which a part of the viands were laid: the waves of the great Atlantic breaking all the while on


---

p.22



the rocks below, yet, at such a distance beneath us that their roaring only sounded like the gentlest murmurs.


It was a glorious day, the sun being almost too warm, notwithstanding the ocean breeze which fanned us, and groups of the islanders looked on from the crumbling ruins around. With such scenery and such associations, cold would have been the bosom which did not feel a spark of enthusiasm within it. An abundant dinner, in serving which both the stewards and some of the Vestal's crew exerted themselves in a most praiseworthy manner, and which was washed down with some excellent sherry, left nothing wanting to give effect to the impressions of the scene. The repast being disposed of, the party assembled on the grass near the platform of level rock which has been already mentioned, and, on the motion of **Mr. Wilde** — The Provost of Trinity College was called on to preside, and took his seat on the rock. **Dr. Petrie** said that, before their proceedings were further entered on, he wished to propose the health of a ‘fine old Irish gentleman’ whom he saw among them — ‘Mr. O'Flaherty, the magistrate of the Island,’ whose generous hospitality he had enjoyed during a long visit to **Aran** five-and-thirty years ago. Mr. O'Flaherty's health was cordially drank, and that venerable gentleman, who had witnessed nearly eighty summers, and who had traversed the rocks of **Aran** that day with almost the steps of a young man, returned thanks, and wished them all a hearty welcome. **Mr. Wilde** then came forward, and, addressing the President, said — ‘Mr. Provost, — As we are still an **Ethnological Section** of the **British Association**, I have now to move that you should take the Chair of this our crowning meeting within the cyclopean walls of this ancient fort, where I feel so much satisfaction in congratulating all around me on having met under so glorious a sky, on so serene a day, and with such an expansive view of the mighty Atlantic heaving so calmly 300 feet below the everlasting seat you have now taken. I especially, Sir, congratulate you on thus bringing to a close, amidst scenes so wonderful as that we behold 


---

p.23



around us at this tranquil moment, and so deeply interesting to the hearts of all who look back with the feelings of Irishmen into the far-off fortunes of his race, and rejoice to gather from such evidences all that can be rationally conjectured of the pre-historic times of his ancestors. Members and Associates of the **Ethnological Section** of the **British Association**, I congratulate you that we are here assembled to-day; and I think it right to say a few words from this spot to explain why I have brought you here, how I have brought you here, and whom we have brought here. In a consultation at the Provost's, as early as the month of November last, I was asked to what part of our island, as presenting the most interesting features for their consideration, I could organize an expedition for this Section of the **British Association**. Many localities were suggested — our land abounds in them — offering objects of great attraction; but I said that to my mind, if its accomplishment were possible, an excursion to these Islands was pre-eminently to be preferred. Though much is on record respecting them, the realities have been hitherto known to comparatively but few capable of appreciating their deep interest; and I felt that if I could but see here such a body of men as that which now surrounds me, I should have fulfilled a cherished aspiration of my own, and have afforded to them a source of vast present pleasure, and much profit in their future studies of ethnological lore, by developing the rich resources of the West. Gentlemen, for that it was I brought you here. Call to mind what you saw yesterday — what you have seen to-day — and, above all, contemplate all that surrounds you now, and let every reflecting mind, expanding to the vast fields of speculation now opened before us, whisper within itself, It was well for me to have come here.’


‘Now, Gentlemen, as to how we came here. In the first instance, I applied to the Irish Government, in full confidence of receiving every assistance which could be given, and which I felt ought to have been given, and there I at first had expectations, which were ultimately disappointed. The Lord Lieutenant did apply to the Admiralty for a steamer, the first requisite for our journey, and the Admiralty refused it. In this dilemma a subscription was suggested to charter a steamer for our purpose, and our Chairman, with that well-known generosity for which he is 


---

p.24



distinguished, offered to head the list with a very handsome sum, if this course should be decided on. I proceeded to **Liverpool** in the hope of chartering the Tubal Cain, but she could not be got in time. While this was under consideration, powerful and influential friends were at work in other quarters, and to none of these do we owe deeper gratitude than to the Lord Chief Baron, who made a personal application to Lord Stanley of Alderley, and the result of that application was success. To the influence of his high position, his enlarged and comprehensive intellect, his gentle, kindly nature, and his devotion to the interests of science, we are indebted for this trilogy of history, antiquity, and pleasure. Had his Lordship not succeeded, I had in contemplation an excursion to the Boyne: there we could have seen the kingly sepulchres of Ireland's earliest race, while here we trace their last retreating steps, as, driven westward, they entrenched themselves on the brink of these stupendous cliffs — raised this and the other cyclopean forts which we have seen, and in this more especially have they left the evidence of their skill and power, as well as desperation and resolve. Here, with their faces to the foe, and their backs to yon yawning gulf, 300 feet above the surging sea, was the last stand of the ancient Firbolgs who fled to these islands and erected these stupendous monuments, when driven from the mainland after the battles at **Moyturedh**, centuries before our Christian era.’


‘Had we visited the Boyne, it is due to the Directors of the Drogheda Railway to say, they had offered us every facility we could have required, by special and free trains, for our conveyance; and Mr. Maguire, a large landed proprietor in the neighbourhood, would have permitted one of the ancient tumuli on his property to be explored in our presence. When you think of the facility with which we have gotten hither, you will readily see the numberless obligations we are under, and the many persons to whom we must owe our thanks. First in order, to the Midland Great Western Railway, who, beside the extensive liberality with which they granted the distribution of free tickets and two special trains, authorized me, through Mr. James Perry, to whom personally we are under great obligation in this matter — to obtain from the Railway Hotel everything or anything it contained 


---

p.25



which I might think necessary to our comfort and convenience, including a large supply of bedding to be used, if requisite, for whatever sleeping accommodation the steamer afforded. Sir Duncan M'Gregor issued orders to the Constabulary, and Captain Clarke to the Water-guard, to render us all the assistance we required at their hands. The Fishing Company placed their staff at my disposal. The Ballast Board of Dublin did the same; and further, they postponed their intended tour of inspection to the lighthouses, in order that we might have the use of the steamer they should, according to their arrangements, have been on board of this very day. Professor Croker kindly acted as our agent in **Galway**, and mainly assisted in the commissariat department. To each and all these bodies and individuals we render sincere thanks, and, though last in order, not least in estimation, come the Islanders. To the proprietresses of the Island, the Misses Digby, we are indebted for the most cordial welcome they could offer, and the most liberal mode in which they could tender it; from the moment we set foot upon these rocks to the moment we leave them, their purpose is that we incur no charge, collectively or individually; that all necessaries and conveniences, lodgings for the large number of persons the steamer cannot accommodate, boats, ponies, carriers, — all are placed at our disposal, and all the expense is to be at their cost. I am at all sides met by expressions of astonishment as to how ample this accommodation has been — how cheerfully, how courteously it has been rendered — how kindly, and, at the same time, how unobtrusively, and evidently independently, it is offered; and while I thank them in the name of all, I congratulate them on all we see, and on much that is known only to myself and a few around me, who will bear witness with me to the very remarkable improvement which is so evident to those who remember the condition of these Islands a few years since. It is true that ten years ago I followed on the footsteps of a fearful famine; but I remember what was the state of things here before that visitation, and the improvement in all things is delightful to observe; and I congratulate Mr. Thompson, the agent of the ladies who own this Island, most heartily on a state of things which must have reference to 


---

p.26



 his management and influence — what that kindly influence is, Gentlemen, we have seen every step we have trodden.’


‘To prepare for our reception, I sent down Mr. Eager more than a week ago, and he has received every possible facility in executing his task, from every one connected with the Island. All these appliances for the complete success of our expedition make up a sum of means placed at our command which no money could have procured.’


‘I regret much that I could not accede to all the applications to accompany us. There were many whom I would have gladly seen here who gave me their names after the prescribed list was necessarily closed. Some I would willingly have seen join us in **Galway**, when the extent of our means became more certain, but this could not have been, in justice to others, who were excluded by fears of the want of these means in Dublin. We are seventy persons; all has gone well; but I own that at moments I trembled at the responsibility of providing, as we have fortunately been enabled to do, for so large a party; and had it not been for the labour of my friend Mr. Armstrong, I should have good reason, too. He, by his business-like habits and executive perseverance, so arranged all needful details, that no confusion has befallen; everything has been in its proper place, at the proper time, and nothing has failed in the arrangements which he directed. To the gentlemen of the red-tape department we are also indebted — the stewards, we may call them, of the expedition, who each carry, as you see, a corkscrew, attached by a piece of red tape — they have redeemed the title from some of its obloquy. Their office of circumlocution, with that exhilarating sound which accompanied it, has afforded somewhat more cheering influence than is ordinarily dispensed at that labyrinth in Downing-street.’


‘So much, Gentlemen, as to how we came; — now as to whom we have brought. We have presiding over us the Rev. Dr. Mac Donnell, Provost of Trinity College, without whom our party would have wanted its most appropriate and honoured head. Sir, I thank you for your presence and presidency here, *adding another* to the many proofs on record, and in my own personal remembrance,


---

p.27



of your earnest interest in all that tends to the progress of knowledge and refinement, crowned as it has lately been by your reception of the **British Association**; and I rejoice to see the venerated head of that ancient seat of learning in our land seated here on this rock, encouraging, by the interest he evinces in ethnological research, the rising generation of that University to preserve and to enlarge the sphere of our knowledge of the condition and destiny of that race who passed from earth ere history began. **Dr. Petrie** is here, the pioneer of philosophic antiquarian research in Ireland, the far-famed author of the History of the Round Towers and the Ecclesiastical Architecture of Ireland. Fortunate for us it is that he has put on record and illustrated so much so thoroughly, and so beautifully, much which, as he hastold you in describing the ruins on this Island, has been doomed to partial destruction within these few years past, and more which now would have no existence but for his truth-telling pencil. We have **Dr. O'Donovan** here, who has done so much to advance our knowledge of these Islands. I deeply regret that the pressing importance of other matters should have caused the suspension of the publication of his notes on these Islands to the Ordnance Survey. These manuscripts are now in the **Royal Irish Academy**; they are most valuable, and I may say that for most of what I have myself learned of the subjects on which they treat, beyond what I have acquired by my own personal observation, I am indebted to my friend, **Dr. O'Donovan**. It is much to be regretted that these letters are not before the public. We have here **Eugene Curry**, the chief brehon and lexicographer of Ireland at the present day — the true, the genuine Irishman, to whom the people, the history, and the language of his country are the breath of life. Let not his great erudition pass away without leaving the amplest record. Oh! let not his memory, when it shall be all we have amongst us of **Eugene Curry**, dearly as it will be cherished, and long as it will be hallowed in the Irish heart, outlive his learning — use him while you have him — publish his Dictionary.’


‘I regret that I cannot say we have **Dr. Todd** amongst us; he regrets it too, as he has expressed in a letter to me, which, 


---

p.28



however, I will not detain you by reading. We have **Dr. Graves** here, the Ogham decipherer, and **Samuel Ferguson**, who, to his valuable contributions to the science of the antiquary, has so happily blended the popular fascination of the poet. **Gilbert** is here, the historian of Dublin. Frederick William Burton is here, whose pencil has so exquisitely portrayed the living generation of the islands, and whose present visit, we may hope, will tell its own tale in his own happy way. I see here Dr. Shaw, the Secretary of the Geographical Society; Mr. Mitchell, Secretary for Foreign Correspondence of the Antiquarian Society of Scotland; and my jolly as well as erudite friend, Dr. Simpson, of Edinburgh celebrity. We have my friend Colonel Colomb. We have **William Stokes** here, whom I introduce, not as a doctor, but as an Irishman, whose cultivated and refined mind so fully appreciates all that is good and grand in nature, and whose liberal and warm heart throbs in responsive pulse with all that is good and great in his fellow-man. I am happy also to see here amongst us the Consul of France, the representative of that great country which has ever been foremost in encouraging art and science, and preserving the monuments of its national antiquities. He belongs to the same race as ourselves. There are many others here I need not name, without whom we should not have been so complete nor so happy as we are.’


‘Now, why have I brought you here, and more particularly to the spot where I stand at this moment to address you? It is because, after all you have seen, I believe I now point to the stronghold prepared as the last standing-place of the Firbolg aborigines of Ireland, here to fight their last battle if driven to the western surge, or, as I have already pointed out to you, to take a fearful and eternal departure from the rocks they had contested foot by foot. Of that race we have no written knowledge. We can but make our conjectures by such light as recorded history has afforded us, reading it, comparing, and referring it to what they have left us in these litanies of stone. Here, perhaps, the sentinel on **Dun Ængus**, two thousand years ago, casting his glance on a summer eve over that vast expanse of Atlantic water that now rolls between us and America, brought 


---

p.29



up in fancy on the western horizon that far-famed island of O'Brazil, the tradition of which still lingers among these peasants now grouped around us. It has been one of my fondest hopes to render **Aran** an object of attraction, and an opposition shop, if I may so say, to **Iona**. Should I succeed in doing so, I shall feel myself amply repaid. And with reference to these stones, allow me to say a few words to the islanders. It is much to be deplored that these vast buildings are so rapidly going to destruction, not by the slow hand of time, for to time they almost bid defiance. The destruction we lament has been recent, and has befallen them from the hands of those who should preserve, not destroy them, as they have done in the pursuit of rabbits. Now, let me earnestly appeal to you, Islanders — will you not after this day, when you have seen that the interest felt in these old buildings brings so many strangers to your Island — and some, I tell you, have come many hundred miles — refrain from (for the paltry advantage of catching a few rabbits) bringing these walls to the state we see so many parts of them in? In an interested view of the matter you will be the gainers — strangers, in visiting the island, cause occupation and yield profit to many of you; and do not, for your own sake, destroy the things which bring strangers to visit you. Remember, above all, that these were the works of your own kindred, long, long dead; that they tell a history of them which you should be proud of, and that there is no other history of them but these walls, which are in your keeping. You have a great right to be proud of them; they are grand monuments of the brave men your forefathers were, and of how they laboured and how they fought to defend the land they left to you and to your children. Do you defend them in peace as they built and defended them in war, and let your children's children see strangers coming to honour them, as we have done to-day.’


Mr. C. C. Babington, of Cambridge, said he hardly knew how to present himself to the Meeting, but, as an English member of the Association, he felt bound to express the gratification which he had enjoyed. He wished to call their attention to the fact that the ancient buildings in these **Islands of Aran**, with all their singular 


---

p.30




interest, were scarcely known beyond the Channel. He had heard of **Aran**, it was true, but the peculiar grandeur of its antiquities was utterly unknown to him; it was only as a naturalist that he had any acquaintance with the Islands. He trusted that the present visit would have the effect of causing more care to be taken of the forts and other remains. He begged to move the thanks of the Meeting to **Mr. Wilde**, without whose unparalleled exertions their trip never would have taken place, or, if it did, would have been comparatively unprofitable.


Dr. Norton Shaw, as another English member, felt extreme pleasure in seconding the motion. He had read the works of **Mr. Wilde** with profit and pleasure, but the information and gratification which he derived from his efforts on the present occasion would leave an impression which should never be effaced..


Dr. Simpson, of Edinburgh, came forward amidst much cheering, and said: — ‘As two English gentlemen have already addressed you, my Scotch friends seem to think that one of their own countrymen should say something, and I rise with much pleasure for the purpose of doing so. Allied as we Scotchmen more especially are to Ireland — descended, in fact, as we are from Irishmen — we naturally feel a particular interest in the object of this excursion. We Scotch antiquarians feel that if we are ever to study the antiquities of our country, it is through the medium of the antiquities of Ireland we must learn to understand and appreciate them; and we, therefore, feel how deeply indebted we are to **Dr. Petrie**, to **Dr. Graves**, and to other distinguished men whom I see around me, for the light which their learned studies have thrown upon that subject. We acknowledge with pleasure and gratitude the advantage which we have derived from their works. On a former occasion I had the pleasure of visiting the **Boyne**, with its singular and colossal tombs of the ancient kings of Ireland, in company with **Mr. Wilde**, and I was so delighted with that visit, and felt so much the value of the information which I received from him, that the moment I ascertained that this excursion was to take place under his direction, I resolved that I should be one of the party. I have not been disappointed, and I feel that for the gratification which we all enjoy we are mainly indebted 


---

p.31



to the information and indefatigable exertions of **Mr. Wilde**. I have, therefore, great pleasure in adding my voice to the general expression of thanks to **Mr. Wilde**.’


The motion having been carried with acclamation, **Mr. Wilde** again came forward, and, amidst loud and continued cheering, briefly returned thanks. **Dr. Graves, F.T.C.D.**, then said: — ‘Mr. Provost, and Gentlemen, I rise for the purpose of making a proposition which I feel is likely to be received with favour by the assembled Members of the **Ethnological Section** of the **British Association**. It appears to me we shall not fully carry into effect the design of this excursion, unless we place on record a complete and scientific Report of what we have just seen and done under the able guidance of **Mr. Wilde**. In doing this we shall establish a most appropriate memorial, testifying our gratitude to him for the efforts which he has made in bringing us to this place, and we shall, at the same time, promote the interests of archaeological and ethnological science. I, therefore, move that we take the necessary steps to secure the publication of a work illustrating the ancient monuments of the **Aran Islands**. We do this as a recognition of the excellent judgment with which **Mr. Wilde** planned this expedition, and of the indomitable perseverance with which he carried his plan into effect, despite of the many difficulties which he had to encounter. And we feel sure that such a memorial will be a most enduring one, lasting as long as the taste for archaeological studies — especially the study of our native antiquities — continues to exist in Ireland.’


Professor Jellett begged to second the suggestion of **Dr. Graves**. He was personally aware of all the difficulties which **Mr. Wilde** had to surmount in bringing about this expedition, and was a witness of the indomitable perseverance and unceasing efforts by which they had been overcome; and he, therefore, knew better, perhaps, than any one there, how well **Mr. Wilde** merited their gratitude. **Dr. Stokes** agreed fully with the observations which had been made about **Mr. Wilde**; and he also thought that the second in command should not be forgotten. He, therefore, begged to 


---

p.32



 
move their cordial thanks to Mr. Armstrong for his successful exertions to make them all happy. At the same time he would take that opportunity to remark that this was the only country of Europe in which no public steps were taken to preserve their ancient remains from decay and destruction. He would, therefore, suggest that before they separated — considering the assemblage there present as a part and parcel of the **British Association** — some course should be adopted with a view of bringing the subject under the attention of Government, and that for that purpose a Committee should be then and there formed to prepare a Report on the state of their historic monuments, for presentation at the next Meeting of the Association. Mr. O'Hagan, Q. C., seconded both the vote of thanks to Mr. Armstrong and the other excellent motion of **Dr. Stokes**, which he hoped to see regularly acted on. He was not an archaeologist himself, but in his professional capacity he had an *opportunity* of seeing some of the most valuable materials for Irish history crumbling away under the dome of the Four Courts; and he believed he was right in saying that no people were more incuriosi of their national antiquities than the Irish.


**Dr. Petrie** stated that, when he had been there in the year 1822, the walls of **Dun Ængus** were much higher, especially the inner walls, which appeared to have fallen almost altogether into a heap of ruins. All the remains in the island appeared to be going rapidly into a state of dilapidation; but, fortunately for the ecclesiastical remains, they owed their preservation to the reverence of the people for what appertained to religion.


Mr. Armstrong acknowledged the compliment which had been paid to him.


The following gentlemen, with power to add to their number, were appointed to act as a Committee to carry out the suggestion of **Dr. Stokes** in reporting on the state of our historical monuments, viz.: — The Provost, **Dr. Todd**, **Dr. Graves**, **Dr. Petrie**, **Dr. O'Donovan**, **Mr. Wilde**, **Dr. Stokes**, and **Mr. Gilbert**. 


**Mr. Wilde** said their special thanks were due to the Lord Chief Baron, to Lord Stanley of Alderley, to the Directors of the Midland Great Western Railway Company, and to the Misses 


---

p.33



Digby, for their trip, and for the many and various appliances by which it had been facilitated.


Votes of thanks to each of these were accordingly put, and loudly cheered.


Mr. Thompson acknowledged the compliment which had been paid to the Misses Digby and to himself.


M. de Burggraff, Consul of France, came forward, and spoke in the following appropriate terms in his native language: — ‘M. le Président, Messieurs, avant de quitter **Dun Ængus** je vous demande la permission d'ajouter quelques paroles aux discours que vous venez d'entendre. J'ai besoin de remercier le Docteur Wilde de son aimable invitation, et vous, Messieurs, de la cordiale réception que vous m'avez donnée. Je ne suis pas un homme de science. Je n'avais donc d'autre titre pour être invité à me joindre à votre excursion que votre sympathie pour la France, et je vous en remercie sincèrement. Le Docteur Wilde a parlé de la protection, des encouragemens, que sa majesté l'Empereur Napoléon III. accorde chaque jour aux lettres, aux arts, et aux sciences. Ces marques *d'intérêt*, vous le savez, ne sont pas limitées aux Français seulement; et si vous voulez bien visiter un jour la France, nous serous heureux et fiers de vous y recevoir.’


Captain Maguire, R.N., begged to make one observation, and it was, that if they did not get a steamer from the Admiralty, why, they did get one from the Trinity House; so that, after all, if one department of the Government did not confer the favour, another did. He would propose three cheers for the captain, officers, and crew of the Vestal, and for the coast-guard men.


The call was cordially responded to. Dr. Simpson having been voted to the second chair, Mr. Mitchell moved the thanks of the Meeting to the Provost, who briefly replied, and at the same time expressed the sympathy which he felt in the general objects of the Meeting.


**Professor Eugene Curry**, being loudly called on, then came forward to deliver a speech in Irish to the islanders, who, being invited by the Provost and other gentlemen, gathered round in large numbers, and mingled with the company. He described the party of gentlemen who visited their island on that occasion, 


---

p.34



 and who were assembled within those ancient walls, as comprising many most distinguished men, who had come not alone from Dublin and various other parts of Ireland, but from England and Scotland, to see that island, so celebrated in times of old, and which contained so many objects of the deepest interest. There were gentlemen there in the midst of them with true Irish hearts, and who loved everything that belonged to their dear old country — gentlemen of great learning, who devoted their time for many a year to study and to write about Ireland [cries in Irish of ‘Musha, they're welcome’]. They had been told by other gentlemen how wrong it was for them to destroy their ancient walls for the sake of hunting rabbits. It was little a few rabbit-skins were worth, and little did they know the damage which they committed in searching for them. Mr. Curry appealed to them, in the names of their own great St. Enda and St. Brecan, whom they venerated, and whose ancient holy faith they still preserved, to respect and preserve the ancient remains of which their island boasted. Mr. Curry's command of the language was such that he was able to address his Irish audience in their own Connaught idiom with as much facility as he would have done in that of his native Munster; although the peculiarities in pronunciation, 
&c., of the spoken language in the two provinces constitute a very marked dialectic distinction. His words appeared deeply to affect the poor people, who frequently and warmly applauded him.


**Dr. O'Donovan** followed, describing the state in which he had found the ruins twenty years ago, and the great dilapidation that had since taken place. He also briefly addressed the islanders in Irish.


Paddy Mullin, the Guide, was then called on, and made a short speech in Irish, very much to the purpose. He reminded his fellow-islanders that for the sake of their honour as well as their interest, they should endeavour to preserve their ruins.


A musician, with a bagpipes, then played some merry tunes, and the banquet of **Dun Ængus** terminated with an Irish jig, in which the French Consul joined con amore. 




---

p.35


Thus finished a Meeting of the **Ethnological Section** of the **British Association** as memorable as any in the records of that Society, and from which the old Firbolgic fort within which it was held will probably derive as much celebrity as from the chief of the Clann Ua More, whose name it bears. On returning to the north side, at Port Murvey, where the fine ruins of Teampull Mic Duach were visited, the party were entertained with a well-contested race between nine curraghs, each rowed by three men.


TEAMPULL MIC DUACH
------------------


The ruins of this church, which stand in the rich plain of Port Murvey, near Mr. O'Flaherty's house, are in fine preservation, and present a beautiful specimen of the cyclopean masonry of the sixth century. Some of the stones are ten feet long, and about 1 foot 8 inches in thickness. There are windows of extreme antiquity, with lintels formed of two leaning stones; and although the beautiful semicircular eastern window is of a more recent date, there is a stone leaning against the east gable, with a rudely cut opening which seems to have been the head of the more ancient window. The small narrow doorway, shaped like the entrance to an Egyptian tomb, is a remarkable feature in the building, which was described in Dr. O'Kealy's list, a little more than two hundred years ago, as a ‘handsome church’ dedicated to St. Colman Mac Duach, the same saint who founded the diocese of **Kilmacduagh**. Near it are a holy well and several remains of antiquity.


The Vestal having now resumed her freight, returned to her anchorage off **Kilronan**.


THIRD DAY
---------


This morning (September 5th) the Vestal, after firing a salute, weighed anchor from **Kilronan**; and having landed her excursionists for a couple of hours in the Middle Island, to visit the Fort of **Dun Conor**, 
&c., she passed through the **Foul Sound**, and with a brisk gale from the N. W. proceeded towards the coast of **Clare**, cruising under the cliffs of **Moher**.




---

p.36


INISH MAAN
----------


The Middle Island contains only a few Christian and Pagan antiquities, but these are of extreme interest. Landing at the east side, on a beach presenting the same remarkable appearance as that of **Glenaghaun**, we first arrive at the very ancient little Church or Oratory of St. Cananagh. It is situated near the beach, among the chaotic fragments of a tumbled-down precipice; many of the cubic masses of rocks which have fallen in confusion around being each much larger than the church itself. In size and masonry this Oratory resembles that of St. Benan. The doorway, composed of large stones, one of which forms the lintel, is only from 19 to 20 inches wide, and the roof had been evidently formed of overlapping stones. There is a holy well close by, and a saint's bed or grave with three small round stones, like some which are frequently found on these tombs, upon it; while a large flat stone with a hole in the centre stands as a headstone. The St. Cananagh to whom this church is dedicated was, according to tradition, a St. Gregory, and some will have it that he was Pope Gregory the Great. The name is also preserved in Gregory's Sound, which separates the large from the middle Island, and in the Church of Gregory or Cananagh in **Connemara**.[7](javascript:footNote('E850007-001/note007.html'))


The principal Pagan antiquity on the Middle Island is the great fort of **Dun Conor**, or Conchovar, which is of more solid masonry than **Dun Ængus**, and has escaped the ravages of time and dilapidation much better. **Mr. Wilde** having collected his party in the interior, explained the character of the fort, and read to them some extracts from **Dr. O'Donovan**'s notes on **Aran** made for the Ordnance Memoir. This fort is oval in shape, the long diameter of the interior being 227 feet, and the shortest diameter 115 feet. On one side the steep precipice on which it stands rendered any outer circumvallation unnecessary, but the remainder is surrounded by a strong outer wall, and the passage to the entrance 


---

p.37



leads through a square enclosure like an advanced work, that must have added greatly to its defensibility. The walls, where not broken down, vary from 17 feet to 20 feet in height; there were two flights of steps to the parapets; and in the interior are a great number of ruined cloghauns. On the subject of these cloghauns **Dr. O'Donovan** made some interesting observations. He said they were used as habitations to a comparatively late period. Some of the islanders still built small houses for domestic purposes in the same style; and he was informed that in a neighbouring village on that island there was a family still living in a cloghaun or stone-roofed house. He said it often required some examination of the stones and of the mosses on them to enable one to distinguish between the old and the modern cloghauns.


On this island are also the ruins of a church dedicated to the Blessed Virgin, and of another, very rudely built, and now nearly destroyed, called the Church of the Seven Kings' Sons. Near the latter are the **aharla**, or grave, and the holy well of the Virgin, St. Kenerga.


While the party were collected within the Fort of **Dun Conor**, and the Provost occupied the chair, a vote of thanks was passed by acclamation to ‘Martin Haverty, Esq., the Reporter of the Proceedings of the Excursion.’


INISHEER
--------


As the Vestal passed through the Foul Sound, which separates **Inish Maan** from **Inisheer**, the excursionists had an opportunity of seeing on the latter the old castle of the Clann Teige O'Brien, of **Aran**. It is remarkable that a regular contract was once entered into between this clan and the merchants of **Galway**, by which the former bound themselves to protect the commerce of the latter from pirates for a certain stipulated number of butts of wine, &c.; and we understand that the original of this singular document is still in the possession of S. Roche, Esq., of Ryehill, county of **Galway**, the direct descendant of the O'Briens of **Aran**. This island, on which we had not time to land, contains several very precious remains of antiquity, the principal of them being the beautiful Abbey of St. Kevin of **Aran**, and his bed or grave. 




---

p.38


But in this sketch of our proceedings we have not attempted to describe any of the objects of interest which the Section under **Mr. Wilde**'s guidance did not actually explore; and among the things thus passed over, merely from want of time to visit them, were some other Firbolgic Cahers or Cashels, some dilapidated cloghauns, some cromleacs and pillar-stones, and some monastic remains of very great antiquity.


THE RETURN
----------


After a delightful trip to the cliffs of Moher, as far as the Hag's Head, at the entrance to **Liscanor Bay**, the head of the Vestal was turned homeward, and running close under the coast of **Clare** until we had doubled the bold promontory of **Black Head**, we made a prosperous voyage to **Galway**, where we landed in time to enjoy our dinner previous to the starting of the special train for Dublin.


It is only right to state that during the whole time we were on board the Vestal, Captain Evans, with the officers and men, did everything that was in their power, or that could be desired, to render their passengers comfortable, and to consult for their convenience, even in the minutest particular. A resolution to this effect was adopted at a meeting of the excursionists on board the steamer; and a letter, signed in the name of all, was addressed to the Trinity House, to give both officers and men the credit which they so well deserved.


Everything coincided to render the memorable excursion to the **Aran Isles** happy and successful. Its pleasurable and instructive impressions will long be cherished by those who had the happiness to participate in it; its advantages to **Aran** itself will be still more durable; and we may safely pronounce that **Mr. Wilde**'s admirable project for opening up to the world the antiquarian and ethnological treasures of these interesting islands has been crowned with a glorious success.[8](javascript:footNote('E850007-001/note008.html'))




---

p.39


PROGRAMME AND ITINERARY OF THE ETHNOLOGICAL EXCURSION TO THE WESTERN ISLES OF ARAN
----------------------------------------------------------------------------------


Director. — W. R. WILDE, ESQ., M.R.I.A.
  

Secretary: — ANDREW ARMSTRONG, ESQ.
A special train will start at a quarter before 7 a. m., from the Broadstone Terminus, upon Thursday, 3rd September. Excursionists must provide themselves with railway tickets, which can be procured gratis at the general Reception-room, and also with special tickets for the **Aran** Excursion from the Secretary, Mr. Armstrong, at 16 ½, D'Olier-street. The excursionists must assemble at the Railway-station at half-past 6, as it will be impossible to admit any person after a quarter to 7. The train will arrive in **Galway** at 11 o'clock, when luncheon will be provided, immediately after which the steamer will start for its destination, weather permitting. The **Western Aran Isles**, so called from the kidney-shape of the largest, are situated at the entrance of **Galway Bay**, between the coast of **Connemara** upon the north, and the county of **Clare** upon the southeast, and occupy a position between 53 degrees 10" north latitude, and 9 degrees 50" west longitude. They are about thirty miles from **Galway Harbour**, and consist of: — 
1. **Inishmore**, or the Great Island, about nine miles long, and averaging a mile and a half in breadth, which contains 7525 statute acres, and had in 1851 a population of 2312.
2. **Inishmaan**, or the Middle Island, divided from the former by **Gregory's Sound**, is something more than three miles long, and about a mile and a half broad, and contains 2252 acres, and 503 inhabitants. It is divided by the **Foul Sound** from the smallest of the group, called **Inisheer**, or the South Island, which is separated by the |**South Sound** from the high cliffs upon the north-western coast of **Clare**. It is two and a half miles 


---

p.40



long, by one and a half broad at the widest portion; its area is 1004 acres, and its population in 1851 was 581. Total population of the Barony of **Aran**, 3333.



The geological formation of the **Aran Islands**, according to the published map of Dr. Griffith, is the upper subdivision of the Carboniferous Limestone. Many of the beds contain fossils of the highest interest and great perfection. The drift is worthy of study, as it contains large rolled fragments of rocks derived from the adjoining coast of **Galway**, with which are scattered granite boulders, denominated by the peasantry ‘Connemara stones’. The limestone rock forms in some places tables 60 feet in length. Of the entire area of the **Aran Isles**, amounting to 11,288 acres, only 742 were under crops, of which 692 were sown with potatoes in 1855. The principal produce of the islands is cattle, calves, sheep, and pigs, the two former of which are reared upon the fine grass which grows between the interstices of the rocks. All the fuel, consisting of turf, is procured from the neighbouring coast of **Connemara**. These islands command magnificent views of the Atlantic, the entire range of the **Connemara Mountains**, **Black Head**, the cliffs of **Moher**, county of **Clare**, parts of **Kerry**, 
&c.


OBJECTS OF INTEREST.
  

The Western **Islands of Aran** contain the greatest number of Pagan and early Christian monuments — military, domestic, ecclesiastical, and sepulchral — which can be found within the same area in Europe. The military consist of DUNS or Forts, generally circular, some of which include several acres in extent; their walls, of dry masonry and cyclopean architecture, are usually 16 feet thick, and from 15 to 20 high. They are all referable to Pagan, and some of them to pre-historic times; and are believed to have been erected by the Firbolg aborigines of Ireland, who sought a refuge here after the battle of **Moytura**, fought many centuries before the general Christian era. These stupendous barbaric monuments afford the best exposition of early military architecture at present known, and are only equalled by some of those in Greece. There are also castles erected during the fifteenth and sixteenth centuries. Within and around these Duns, as well as scattered throughout the island, may be seen numbers of **Cloghauns**, or stone-roofed dwellings of the primitive inhabitants. The sepulchral remains 


---

p.41



consist of cromlechs, tumuli, peaks or pillar-stones, sculptured crosses, tombs, and wayside monuments. The ecclesiastical objects of interest consist of rude cashels and hermits' cells, **aharlas** or sacred enclosures, saints' beds, holy wells, **bullauns**, or baptismal stones, the remains of a Round Tower, several groups of monastic architectural antiquities, and churches of a very early period, which have well entitled the largest of these isles to be called Ara-na-Naomh, or **Aran** of the Saints, from the number of Christian Fathers who resided thereon and erected these structures, or those preceding them, between the fifth and thirteenth centuries.


FIRST DAY. — The special train provided by the Midland Great Western Railway Company will arrive in **Galway** at 11 o'clock, when the Claddagh fishermen will convey the party to the Vestal steamer, which has been placed at the disposal of the Director of the Excursion by the Board of Trade, on the application of Chief Baron Pigot to Lord Stanley of Alderley; the Dublin Ballast Board having kindly postponed their tour of inspection to the Irish Lighthouses, which had been arranged for the 5th inst.


Weather permitting, the Vestal will make **Aranmore** before 3 o'clock, and, coasting alongside the northern side of the island, land the tourists at the beech of **Glenaghaun**, when the following objects of interest will be visited. The ruins of **Sean Chaislean**, or the old castle, a square tower composed of immense stones, 35 feet long, by 28 broad, the walls 9 feet thick. In its vicinity may be seen one of the granite boulders elevated upon a stalk of limestone, similar to the stones seen on glaciers.


The group of ecclesiastical ruins, locally known as the ‘Seven Churches’, placed in a beautiful valley, through which a small stream runs, and consisting of **Teampull Brecain**, the Church of St. Brecan, the patron saint of this portion of the island; **Teampull a Phoill**, or the Church of the Hollow; the remains of a monastery, and a portion of the general wall of the enclosure, together with the tomb, bed, and well of St. Brecan; **Tober-an-Spiritneeve**, and the remains of two beautifully sculptured crosses discovered and restored by **Mr. Wilde** in 1848, one of which is now preserved beside the Aharla, or sacred enclosure; also **Ballaun-a-Collagh**, a prayer-well to the north of the ruins. **Dun Onagh**, or **Eoghanacht**, so called from the townland in which it is placed, is a circular fort, remarkably well built, and commanding 


---

p.42



an extensive prospect of the north side of the island, as well as of **Black Head** and the **Connemara** coast. Its internal diameter is 92 feet; it consists of three walls, the middle being built against the external, and together measuring 15 feet in thickness, and 16 in height. Upon the inner side are four sets of steps leading towards the top, like those in **Staigue Fort** in the county of **Kerry**.


**Dun Ængus**, acknowledged to be the greatest barbaric monument of its kind which has yet been described, stands upon the ridge of the southern cliffs, 300 feet above the sea; and although now of a horse-shoe shape, appears to have been originally oval, but the falling away of the cliff has produced its present form. What remains of the fort is 142 feet in width, and 150 feet in length; it consists of three walls, the inner and outer being evidently superadded to support the centre, either in consequence of its decay or because of its insufficiency as a means of defence. Taken together, the wall of this fort is 13 feet thick, and averages 18 in height. There were originally two doorways; that on the northern side has been built up by the inner wall; the north-eastern doorway is 3 feet 4 inches in width at top, and somewhat wider at bottom; its roof is formed of large flagstones raised one above another. There is also a passage or chamber in the inner wall on the north-western side. Around this great Dun there is an extern wall, including a space of several acres; and in some parts, particularly towards the west, two other walls exist, where the ground sloping off gradually rendered the fortress more easy of access. A chevaux de frise of sharp upright stones, jammed into the surface-rocks, renders the approach in some places almost impossible. The sea front of **Dun Ængus**, measured between the walls of the outer enclosure, is about 1150 feet. This great monument, like many other Duns upon these islands, has been much dilapidated by persons hunting rabbits. The name of **Dun Ængus** is derived from Ængus (chief of the Firbolg Clann Huamor), who, with Conchovar his brother, was granted these islands by *Maeve*, Queen of Connaught, shortly before the general Christian era. The Ecclesiastical Ruins at **Kilmurvy** exhibit the best specimens of cyclopean masonry, in which hewn stones and mortar were employed, of any of the structures in the island. They consist of **Teampull Mhic-Duagh**, a little **damhliag**, divided into nave and choir, with a most remarkable cyclopean doorway; **Teampull Beg**, or the small Church of Saint Mac Duagh, together with the holy well of **Tober-Mhic-Duagh**, 


---

p.43



and the walls of the ancient monastic enclosure. **Farran-na-gann**, the ‘Field of the Heads’, or battle-ground of the O'Briens, is on the beach at **Portmurry**.


The party will here re-embark, and proceed to **Kilronan**, the principal village on the island, where there is a harbour and quay, and where accommodation has been procured for the excursionists.


SECOND DAY. — The following objects will be visited, weather permitting : — **Dubh-Chathair**, the Black Fortress or City, situated on a cliff like **Dun Ængus**, upon the southern face of the island, and about two miles distant from **Kilronan**. Within and around it are the remains of a great number of **Cloghauns**, or the stone-roofed houses of the aborigines, showing in their ruins all the remains of an ancient Firbolgic city. The massive walls of this fort are further defended by a stone chevaux-de-frise.


**Killeany**, about a mile distant from **Dubh-Chathair**, was originally the place of most note in the island, and is called after the patron saint and first Christian colonizer of **Aranmore**, St. Eney or Endeus, who arrived here about the end of the fifth century. On the summit of the hill rising behind the modern village, and commanding one of the finest prospects from the island, stands **Teampull Benain**, the Church of St. Benignus, the gem of early Irish churches, being only 10 feet 10 inches long in the clear, and 6 feet 10 inches broad; the original height of the north-eastern gable being about 17 feet. In its vicinity are the remains of a rude cashel, containing several small chambers, probably hermits' cells, and also some rude cloghauns. In the valley beneath stands the butt of a Round Tower, and beside it St. Eney's well, a stone altar, and several other objects of like interest. Upon the sea face of the village stand the ruins of **Arkin Castle**, a fortress originally erected in the time of Elizabeth, and afterwards enlarged and occupied by Cromwell's soldiers, to whom is attributed the destruction of many of the ruins in this locality. The excursionists will then return by water to **Kilronan**, and, should time permit, visit some or all of the following ruins: — **Oghill Fort**, one of the finest Duns in the island, placed beside the Lighthouse, and 400 feet above the sea-level; the ecclesiastical ruins in the neighbourhood of the village of **Cowragh**, consisting of the Church of the Four Comely Saints, **Teampull-an-Cheathrair-alainn**, with their graves, pillar-stones, and holy wells, &c., the Cromlech, or **Leabha Diarmuda agus Grainne**; 


---

p.44



and, in returning by the northern shore, will visit the ruins around St. Soorney's Church, **Teampull Soorney**, and subsequently the churches and crosses of St. Kieran, in the neighbourhood of the great Connaught monastery, **Mainister Connaughtagh**. **Teampull Chiarain** is one of the most beautiful ruins upon the island, and its eastern window one of the most perfect specimens of church architecture of its class now in Ireland. The party will again rest at **Kilronan** on Friday night.


THIRD DAY. — The steamer will take the excursionists to **Inishmaan** or the Middle Island, in order to visit **Dun Conchobhair**, or **Dun Connor**, one of the most remarkable examples of military architecture in the Aran group. It is an oval fort, standing on the edge of a steep cliff in the centre of the island, and is 227 feet long by 115 broad. Upon the eastern side it is surrounded by a strong external wall, the gateway of which is placed in a square fort, 51 feet by 73, and 15 feet high. In the vicinity of **Dun Connor** are the ruins of several churches, saints' beds, and holy wells, &c.


Should time and weather permit, the steamer will land the excursionists at **Portnakilla**, to visit St. Gobnet's Church, and **Furmina Castle**, which stands in the centre of an ancient dun. This castle was the stronghold of Clann Teige, a sept of the O'Briens who long possessed the islands.


The steamer will then return to **Galway** in time for a special train, which will start at half-past 6 o'clock on the evening of Saturday, the 5th.


The possibility of carrying out the foregoing arrangements will greatly depend on the state of the weather, tide, &c., but every possible means have been taken to insure success.


Many details of the objects referred to in the foregoing list may be found in **Dr. Petrie**'s work on the Ecclesiastical Architecture and Round Towers of Ireland; **Dr. O'Donovan**'s MSS. Letters to the Ordnance Survey, now in the Library of the **Royal Irish Academy**, in which the history of the Islands, with minute descriptions and measurements of all the Pagan and Christian remains, are given; **O'Flaherty**'s Iar-Connaught, edited for the **Archaeological Society** by the late **Mr. Hardiman**; A Sketch of the History and Antiquities of Aran, by **John T. O'Flaherty**, published in the Transactions of the Royal Irish Academy, vol. xiv; An Excursion in Clare and 


---

p.45



Aran, by**Samuel Ferguson, Esq.**, published in the University Magazine for 1853; and in the Notes taken by the Director of this Excursion, during a visit to the islands some years ago, when all localities of interest were investigated, and drawings and plans made of them for him by **Mr. C. Cheyne** and **Mr. Du Noyer**.


  
1, Merrion-square, North, Dublin


September 1, 1857.
THE END.











