

#Song of Dermot and the Earl


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Song of Dermot and the Earl
===========================


Author: [unknown]
-----------------


### File Description

translated by Goddard Henry Orpen

Electronic edition compiled by Emer Purcell

second draft enlarged by Beatrix Färber

Funded by University College Cork 2. Second draft.Proof corrections by Emer Purcell and Beatrix Färber

Extent of text: 32,500 words#### Publication


CELT: Corpus of Electronic Texts: a project of University

College Cork.  
College Road, Cork, Ireland.

 (2009) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T250001-001Availability [RESTRICTED] 
Available for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. London, Lambeth Palace, MS Carew 596. (This is the only MS copy of the poem. It is acephalous, has some lacunae, and ends imperfect; for a description of the MS see Orpen, 1892 (cited below) xi-xii and Conlon, 1992 (cited below) vii-xi).
**Editions**- Denis J. Conlon, The song of Dermot and Earl Richard Fitzgilbert: Le chansun de Dermot e li quens Ricard fiz Gilbert, Studien und Dokumente zur Geschichte der romanischen Literaturen, herausgegeben von Hans-Joachim Lope, volume 24 (Frankfurt/Main: Peter Lang 1992). Edition with an introduction, bibliography, chronological table, literal translation, brief notes (223–231), index locorum, index nominum, and glossary (243–54).- Francisque Michel, The conquest of Ireland (London: Pickering 1837). Text without translation but with some glossatorial notes and an introduction by Thomas Wright that is of little value.4. Goddard Henry Orpen, The song of Dermot and the Earl: an Old French poem from the Carew manuscript no. 596 in the archiepiscopal library at Lambeth Palace (Oxford: Clarendon Press 1892). Diplomatic edition with a preface, introduction, chronological table, two genealogical tables (of Mac Murchada and the descendants of Nesta), a facsimile of folio 7ra (i.e. page 13) of the manuscript, a literal translation, an apparatus, copious historical notes (254–321), a heavily annotated coloured map of Meath and Leinster, and index locorum, an index nominum, and a glossary (339–355). Two extracts from Orpen's edition (lines 266–95, 346–69) are reprinted

with Orpen's translation in Seamus Deane (ed), The Field Day anthology of Irish writing i (Derry 1991) 149–150.
5. Evelyn Mullally, The deeds of the Normans in Ireland: La geste des Engleis en yrlande: a new edition of the chronicle formerly known as The Song of Dermot and the Earl. (Dublin: Four Courts, 2002).
**Translations**2. Denis J. Conlon (cited above).
3. Goddard Henry Orpen (cited above).
4. Evelyn Mullally (cited above).
**Sources, comment on the text, and secondary literature**2. Alexander Bell, 'Notes on "The Song of Dermot" 'The Modern Language Review 68.2 (Apr. 1973) 283–291.
3. Alan Bliss and Joseph Long, Literature in Norman French and English to 1534, in Art Cosgrove (ed), A New History of Ireland ii (Oxford: Clarendon Press 1987) 708–736.
4. Eric St John Brooks, Machtalewi, a Leinster chieftain, J Roy Soc Antiq Ire 7 (1941) 53–55.
5. Michael J. de Courcy Dodd, Correspondence on the historical criticism of the Song of Dermot and the Earl, Ir Hist Stud 1 (1938) 294–96.
6. Marie-Therese Flanagan, Mac Dalbaig, a Leinster chieftain, J Roy Soc Antiq Ire 111 (1981) 5–13.
7. Marie-Therese Flanagan, Irish Society, Anglo-Norman Settlers, Angevin kingship (Oxford: Clarendon Press 1989).
8. Felix Liebermann, 'Song of Dermot and the Earl', English Historical Review 8 (1893) 129–33.
9. Joseph Long, Dermot and the Earl: who wrote The Song?, Proc Roy Ir Acad (C) 75 (1975) 263–72.
10. Evelyn Mullally, 'Hiberno-Norman literature and its public'. In Bradley, John (ed.), Settlement and society in medieval Ireland: studies presented to F.X. Martin, OSA (Kilkenny: Boethius Press, 1988) 327–43.
11. Evelyn Mullally, 'Mélanges. La colonisation de l'Irlande au xiie s. d'apres une chronique Anglo-Normande', Cahiers de civilisation médiévale 37 (1994) 365–370.
12. Evelyn Mullally, 'The phantom army of 1169: an Anglo-Norman view', Éigse 31 (1998) 89–101.
13. John Francis O'Doherty, Laurentius von Dublin und das irische Normannentum (Munich 1933).
14. John Francis O'Doherty, Rome and the Anglo-Norman invasion of Ireland, Ir Ecclesiast Rec 42 (1933) 131–45.
15. John Francis O'Doherty, St Laurence O'Toole and the Anglo-Norman invasion, Ir Ecclesiast Rec 50 (1937) 449–77, 600–25, 51 (1938) 131–46.
16. John Francis O'Doherty, A historical criticism of the Song of Dermot and the Earl, Ir Hist Stud 1 (1938) 4–20.
17. Goddard Henry Orpen, Ireland under the Normans, 1169–1333 (4 vols, Oxford: Clarendon Press 1911–20, repr. Oxford: Clarendon Press 1968).
18. Emer Purcell, 'The expulsion of the Ostmen, 1169–71: the documentary evidence', Peritia 17–18 (2003/2004) 276–294.
19. W. Ann, Trindade, 'Fiction and history in the song of Dermot and the Earl', Parergon: Bulletin of the Australian and New Zealand Association for Medieval and Renaissance Studies 8:1 (1990) 123–130.
20. George T. Stokes, Ireland and the Anglo-Norman Church. A History of Ireland and Irish Christianity from the Anglo-Norman Conquest to the Dawn of the Reformation (London 1889).
21. Brendan Bradshaw, Review of reprint of G. H. Orpen, 'Ireland under the Normans', Irish Economic and Social History 23 (2006).
**The edition used in the digital edition**2. The song of Dermot and the Earl. Goddard Henry Orpen (ed), First edition [frontispiece (facsimile of folio 7ra) + xliii + 355pp] Clarendon PressOxford (1892)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The editorial preface and introduction are retained. Notes to the text, indexes and glossary have been omitted.


#### Editorial Declaration


##### Correction


Text has been checked, proof-read twice. This text is complex, textually and historically, and there are many unresolved problems. Textual and bibliographical corrections and suggestions are welcome and will be credited to the scholars who make them.


##### Normalization


All editorial corrections and emendations have been tagged.


##### Quotation


There are no quotation marks in the manuscript. Quotation marks in the edition have been retained.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, the page-break and line-break are marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the poem. Metrical lines are numbered every five lines. Verses are numbered and tagged in this edition. pb n="" marks Orpen's pagination.


##### Interpretation


Place names have been tagged.


#### Canonical References


The *n* attribute of each text in this corpus carries a unique identifying number for the whole text.


 The title of the text is held as the first *head* element within each text.


 *div0* is reserved for the whole text (whether in one volume or many).


The numbered lines provide a canonical reference.


### Profile Description


Created: Translation by Henry Goddard Orpen. 

 (1891) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] Some words are in Anglo-French.


##### Language: [LA] Some words in the introduction are in Latin.


##### Language: [GA] Some place-names are in Irish.


### Revision History


* (2011-02-24) Beatrix Färber (ed.)

* Addition to bibliography made.
* (2009-10-16) Beatrix Färber (ed.)

* File parsed; new SGML and HTML versions created.
* (2009-10-15) Beatrix Färber (ed.)

* File proofed (2); place-names encoded; editor's preface and introduction captured & proofed (1), bringing up the wordcount by 12,000 words; structural and content encoding applied.
* (2009-10-13) Beatrix Färber (ed.)

* Minor changes made to header; file parsed; lineation added.
* (2009-07-30) Emer Purcell (ed.)

* Bibliography added to header.
* (2009-07-20) Emer Purcell (ed.)

* Header constructed (based on that of the French text), structural and in-depth mark-up completed and revised.
* (2009-06-30) Emer Purcell (ed.)

* Text proofed (1); further in-depth mark-up added.
* (2009-05-30) Emer Purcell (ed.)

* Text proofed (1); structural and part of the in-depth markup entered.
* (2009-04-30) Emer Purcell (file capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: T250001-001


### Song of Dermot and the Earl: Author: [unknown]




---

p.v


### PREFACE


To trace the small beginnings of a movement big with consequences has always had a peculiar fascination for the human mind. Not since the day when St. Patrick preached his first sermon in Dichu's barn has there been any event of greater importance to Ireland than the coming of the Normans to her shores. The importance of this event was not duly recognised at the time by the Irish annalists any more than it was perceived by the Irish chieftains. The notices in relation to it in the Irish Annals are consequently few and meagre in the extreme. Hence modern historians in telling the story of how the English first got a foothold in Ireland have had to rely almost exclusively on the writings of **Giraldus Cambrensis**, and on the few scattered notices of the general chroniclers of English affairs. **Giraldus**, though not an eye-witness of the events, had, no doubt, exceptional opportunities of learning the facts, and he has left us an account which, though not free from prejudices and partialities, will compare favourably in its scope and character with any similar recital of the age. Still **Giraldus** was not an 





---

p.vi




Irishman; he did not know the country well, and had to take a great deal on not very trustworthy hearsay. There was, however, an Irishman who was a participator in the events, and though his account has not come down to us at first hand, there is every reason to believe that it is faithfully retailed to us by the writer of the old French rhymes contained in this volume. This Irishman was Morice Regan, Dermot McMurrough's *latimer* or secretary, and he was no doubt an eye-witness of much that the Anglo-Norman rhymer tells on his authority. The first leaf of the MS. in which these rhymes are preserved is unfortunately wanting, 

and no original or early title for the poem has come down to us. To judge by the contents of the existing fragment, however, the poem may possibly have been called ‘La Chanson Dermot’ or ‘La Chanson Dermot e le Conte’, and, for the sake of having a distinctive title and one suitable for reference, I have ventured to call it ‘The Song of Dermot and the Earl.’


Though the existence of this MS. has long been known and an edition of the French text was published in 1837, it has never been translated, nor annotated in any useful way. Writers in general have been acquainted with its contents only through the medium of a very inaccurate Summary or Abstract in English made by **Sir George Carew** in the time of James I, or rather through a still more inaccurate reproduction of this Summary printed in the eighteenth century, and consequently they have never had a fair opportunity of 





---

p.vii






estimating the historical value of the MS. or of properly utilizing its contents. Mr. Freeman, in writing his history of the Norman Conquest of England, has shown to what valuable use as authorities the rhymed Chronicles of **Wace** and **Benoit de St. Maur** may be put in skilful hands. The future historian of the Norman Invasion of Ireland may perhaps be able to utilize this little poem in an analogous way.


Apart from its value as a material of history, an Anglo-Norman text written in Ireland, as there is every reason to suppose this was, is sufficiently rare to justify its study from the point of view of language alone. In England at one time it seemed as if the French language was about to gain the upper hand, at any rate as the language of literature and of the educated classes, but this can never have been the case in Ireland, where French was spoken only by some of the leaders and early settlers in the twelfth and thirteenth centuries and by a few friars and monks educated in France. All the more precious then is one of the very few Irish examples of Anglo-Norman rhymes saved from the wreck of the past.


I have to express my obligations to His Grace the Archbishop of Canterbury for permission to transcribe the manuscript and to have a reproduction made of one of its pages, and to Mr. S. W. Kershaw, F.S.A., the Librarian at Lambeth Palace, for his courtesy to me during my frequent visits to the library. I also desire to thank Mr. F. York Powell of Christ Church, Oxford, 





---

p.viii




for suggestions and advice readily given throughout the preparation of this little book, and to express the hope that, whatever may be amiss in any of its departments—historical, topographical or linguistic— the student of this eventful period of Irish history, for whom especially the book is written, may find in it—in **O'Huidhrin**'s phrase—‘an addition of knowledge on sacred Erin.’


GODDARD H. ORPEN.
  
December 1891.




---

p.xi


### INTRODUCTION


*Description of the MS.* There is only one MS. copy of this poem or chronicle known to exist. It is preserved among the Carew MSS. at Lambeth Palace Library, where it is numbered 596. It is unfortunately only a fragment. Some lines, probably not very many, are wanting at its commencement, which is in the nature of an exordium, but as the narrative closes abruptly it is impossible to say how much is lost at the end. The present copy is undoubtedly a transcript, and, according to **M. Francisque Michel**, is in a fourteenth-century hand. According to the best opinion I can form, however, the handwriting might with more likelihood be placed in the last quarter of the thirteenth century. As a collotype reproduction of a page of the MS. is published with this text, palaeographers can judge of its date for themselves. At least one line has been omitted in this transcript after lines 424, 487, 1802, and 2863, and there is reason to believe that a still larger omission occurs after line 2993 (see Notes). The MS. is written on vellum in double columns of 37 or 38 lines to the column, and 46 pages remain. The double columns are 8.5 inches in height by 6.5 inches in width. Lines 1940–1978 are by a different hand from that by which the rest was written. The lines are normally octosyllabic rhymed couplets with an additional post-tonic syllable in the feminine endings, but the atonic syllable of the first foot is often wanting, and many of the lines, in their present form at least, show other irregularities. The separate paragraphs into which the poem is divided are headed by 





---

p.xii




large capitals (sometimes omitted) in red or green paint, and after the first page a space is left between the initial letters and the rest of the lines. These initial letters themselves are ornamented with a dash of red paint. At the top of the first page have been added the words ‘Fragmentum Historiae Hiberniae Gal. carmine.’ At the foot of page i there is the letter T, at the foot of page 17 the letter V, and at the foot of page 39 the letter W. These letters appear to correspond with the 'gatherings,' or bundles of the skins as arranged for binding, and perhaps indicate that our MS. was at one time bound up with others. They are, however, subsequent in date to the MS., though, I think, older than the pagination, which was probably added in **Sir George Carew**'s time. The existing leaves appear to be arranged as follows:—the first 16 pages form 4 double leaves, sewn in the middle between pp. 8 and 9. The 9th leaf (pp. 17–18) is a single one, and the short end turns up between pp. 38 and 39, where, however, there is no lacuna in the MS. It may originally have been a double leaf turning up at the commencement and containing the opening lines, with perhaps an illuminated letter or picture. The fact that this leaf contains the subscribed letter V on p. 17, seems, no doubt, to indicate that it was the first, and not the last, leaf of a gathering; but, as before remarked, this lettering is not coeval with the MS., and may have been added after the opening leaf had been cut off and when the single leaf, as at present, formed the first leaf of the next gathering. In fact the lettering was very probably coeval with the heading ‘Fragmentum Historiae’, &c. already mentioned. The next 20 pages (19–38) are formed by 5 double leaves, sewn in the middle between pp. 28 and 29, and the last 8 pages (39–46) appear to be single leaves. From this it seems probable, (1) that the gatherings consisted normally of 5 double leaves each; (2) that one single leaf, originally forming with pp. 17–18 a double leaf, has been lost at the commencement; (3) that at 





---

p.xiii




least 4 leaves completing the present single leaves have been lost at the end.


Bound up at present with the vellum MS. and following it on paper are certain fragments of Anglo-Irish Annals in Latin, an Abstract in English of the French text made by or under the direction of **Sir George Carew**, and certain lists of names mentioned in the text and in other documents contained in the volume or in the Expugnatio Hibernica of **Giraldus**, all of which are described in the Calendar of Carew MSS. Another copy of **Carew**'s Abstract is preserved in the Clarendon Collection in the British Museum (Ayscough 4792). It has on the outer skin the signature 'Mathew Plunckett.' There is also a copy in the Library of Trinity College, Dublin.


*Previous works in relation to the MS.* **Carew**'s Abstract of the Chronicle was printed in 1747 by **Walter Harris** in his Hibernica, and again in 1770; but it is only fair to say that many of the blunders and absurdities which disfigure this production are due to the editor or printer and are not to be found in the original Abstract, though it, too, shows a misunderstanding of many passages and contains several imperfections and blemishes. For many years Irish historians had before them nothing but **Harris**'s blundering production, and consequently the Chronicle did not receive the attention at their hands that it deserved. In 1837, however, the French text, edited by **M. Francisque Michel**, was published by **William Pickering**, and this edition, though by no means free from errors, was a great boon to those who could read the language in which the poem is written. A few glossarial notes were added, but no translation was attempted. There is indeed an introduction to **Michel**'s text, written by **Mr. Thomas Wright**, which purports to incorporate the substance of the story told here with the materials supplied by **Giraldus** and other authorities; but owing to the writer's ignorance on the subject of Irish topography and nomenclature, as well as to an occasional misunderstanding 





---

p.xiv




of the text with which he was dealing, very little was really added to what was already known on the subject.


*Use to which the MS. has been put.* I can find no mention of this MS. earlier than **Carew**'s time, nor do I think that it was used in any of the earlier accounts of 'the conquest,' to which, as **Campion** says of his own Chronicle, **Gerald of Wales** was ‘the onely Author that ministred some indifferent furniture.’ ‘Mauritus Regan’ is noticed by **Ware** among the writers of Ireland in the 12th century. This book of **Ware**'s, De Scriptoribus Hiberniae, was published in 1639, and in his De Hibernia et Antiquitatibus ejus Disquisitiones, first published in 1654, he made some use of **Carew**'s Abstract of this poem, especially in the passage on the distribution of the lands granted by Henry II to **Earl Richard** and to **Hugh de Lacy** (pp. 233–237). A similar passage occurs in **Ware**'s note to **Spenser**'s View of the State of Ireland (Reprint 1809), where he says that **Carew**'s ‘Translation’ was communicated to him by **Archbishop Ussher**. This book was first published in 1633, but I cannot find the note in that edition. **Sir Richard Cox** collected materials for his Hibernia Anglicana, published in 1689, from the Lambeth Library, and made considerable use of this poem as represented by **Carew**'s Abstract, the mistakes of which he reproduces; and so with subsequent writers, such as **Lyttelton**, **Leland**, **O'Halloran**, **Gordon**, **Moore**, &c.; they seem to have known ‘Regan,’ as they call their authority, only through **Harris**'s incorrect reproduction thereof; and similarly, even long after the appearance of **Michel**'s text, writers, such as **Gerald Supple**, **Martin Haverty** and others, have known only the English version, until **Miss Katherine Norgate**, in her Angevin Kings, and **Professor G. T. Stokes**, in his Lectures on Ireland and the Anglo-Norman Church, made a more critical use of portions of the text, though not without occasionally misunderstanding it.




---

p.xv


*The present Edition.* In the present edition, I have aimed, in the first place, at producing a thoroughly trustworthy transcript of the MS. With this object I have carefully collated **Michel**'s text with the MS. at Lambeth, and have found and corrected a considerable number of positive misreadings. I have also adhered to the original more closely than **M. Michel** aimed at doing. The text is, in fact, printed as nearly as possible as it has come down to us, except that the contractions have been expanded—the letters supplied being, however, printed in italics—and marks of punctuation have been added. In many cases a single word is divided in the MS., generally, but not always, according to its component parts; and, on the other hand, two or more words are often run into one. These peculiar word-divisions, where clearly marked, have been reproduced, and, where likely to deceive, noted. In some cases, as, for instance, in ll. 15, 2321, and 2860, they have been unintentionally reproduced by **M. Michel** and have misled commentators. Even the apparently arbitrary use of u and v has been followed. This may be thought to have been a superfluous labour, but graphic peculiarities of this kind are among the data which may enable palaeographers to fix the date and even the place of composition of a MS., and as this chronicle is preserved in a single MS. it is all the more important to have a transcript of it which, short of a facsimile, will as nearly as possible supply the place of the original should any accident happen to it. A literal line for line translation is printed side by side with the text, and this, together with the footnotes, will, it is hoped, obviate any difficulty to which the reproduction of the faults and peculiarities of the MS. might otherwise give rise. This method of translation gives no scope for reproducing the swing and spirit of the original, but in all translations something must be sacrificed, and I have thought that for students of history and of language it is impossible to adhere too closely to the text at whatever 





---

p.xvi




sacrifice of form. I should add that the MS. has no accents (except where noted), but the letter i (which also stands for j) is marked by a fine stroke like an acute accent. These marks seem to have been added after the text was written—at least they are in a somewhat lighter ink—and in several cases they have been omitted. It is noteworthy, too, that the letter z seems, in many cases at least, to have been an addition, for which however space was left. The Notes which follow the text in the present edition are mainly concerned with the identification of places, territories, tribes, and persons mentioned in the poem, and with references to the statements of **Giraldus** and of the Irish annalists and English chroniclers which corroborate, supplement, or are at variance with, the statements contained in the poem. At the end are added Indexes of the names of the persons and of the places mentioned in the poem, and a Glossary of the more unusual words and forms found in the text. I have also constructed a Map of Leinster and Meath, showing the positions of the principal territories and places, so far as they have been ascertained, at the time of the Anglo-Norman invasion. With a few exceptions drawn from other sources, these names are all to be found in the topographical poems of **O'Dubhagain** and **O'Huidhrin**, which are believed to have been written in the years 1372 and 1420 respectively, and which give an account of the tribes and territories of Ireland prior to the English occupation. With regard to those names which appear in the text I have, where it seemed necessary, placed them in brackets underneath the corresponding Irish names. In locating the places mentioned in the topographical poems I must express my great obligations to the writings of the late **Dr. John O'Donovan**, without whose masterly elucidations of Irish topography I should never have attempted to construct this map. Frequent references throughout the notes will also be found to the Journal of the Kilkenny Archaeological Society, now the Royal Society of Antiquaries 





---

p.xvii




of Ireland, a publication which only requires a good comprehensive Index to make it extremely useful to writers on Irish history and antiquities.


*Author of the Poem.* As to the author of the poem and the date of its composition nothing is known beyond what can be gleaned from the poem itself. It is not even known where **Carew** got the MS. It has been much too broadly ascribed to **Morice Regan**. **Carew** himself appears to have been the first to give currency to this misconception. The MS. is bound up with a couple of outer plies of vellum, added to protect it, and one of these contains, in **Carew**'s handwriting, on the upper left-hand comer, the signature, ‘**G. Carew**’, and the date ‘1617.’ Underneath is the following title and description:—
  


> 
> This old frenche ffragment wants bothe beginninge and endinge. Neverthelesse in the first tenne Lynes it appears that this storie was written by one called **Maurice Regan** (sometymes mentioned in this discourse) who was servant and interpreter unto Dermond M'Moroghe kinge of Leinster and put into frenche meeter by one of his familiar acquaintance. It endeth abruptlie at the winninge of Limericke which was not full 3 yeares after Robert fitz Stephen his first arrivall in Irland.[1](javascript:footNote('T250001-001/note001.html'))
> 
> 
> 




A note to the same effect heads **Carew**'s abstract of the poem, on the margin of which, opposite the name **Maurice Regan**, is written ‘this **Maurice Regan** was the author of this Historie.’


**Carew** evidently drew this conclusion from the opening lines of the poem, which must be examined with some care. Now these opening lines have been repeatedly wrongly transcribed and wrongly interpreted. As printed in **Harris**'s Hibernica they are pure gibberish, and the translation is 





---

p.xviii




of course wrong. These mistakes are, in the main, due to **Harris** and not to **Carew**, who does not translate the passage, nor in the Lambeth copy of **Carew**'s Abstract is it transcribed. Lines 4–8 run thus in **Harris**'s version:—
  


> 1. Maurice Regan was the man,
>   
> Who face to face indited to me
>   
> These actions of the king,
>   
> And of himself showed me this history.
> 




**Wright**, in his introductory essay to **Michel**'s edition, prints the correct text of the first eleven lines (except that he puts *latinier* for *latimer*) side by side with **Harris**'s gibberish, which he wrongly attributes to **Carew**, and then gives his own literal translation; but, curiously enough, he seems to fall into precisely the same error as that which he attributes to **Harris**, namely, ‘that Regan had written the history.’ Wright's version of these four lines is as follows:—
  


> 1. Maurice Regan was he,
>   
> I spoke mouth to mouth with him,
>   
> Who endited this history,
>   
> [Who] shewed me the history of him.
> 




Now **Wright** has mistaken parla (the 3rd person) for parlai (the 1st), thus apparently making Regan the subject of endita and by rendering this latter word ‘endited’ he has certainly done little to correct **Harris**'s error.[2](javascript:footNote('T250001-001/note002.html'))


The translation now offered, which makes **Regan** the subject of parla, and takes the words lui ki cest(e) iest(e) endita as referring to the anonymous writer of the geste, with whom **Regan** spake face to face, still leaves room for 





---

p.xix




a certain amount of doubt as to the making of the poem that has come down to us and as to **Regan**'s exact contribution thereto. Apart for the moment from ll. 5 and 6, it seems clear from ll. 2 and 7 that the writer who speaks of himself in the 1st person derived his account directly from **Morice Regan**. Standing by itself l. 7 might mean no more than l. 2, but there are repeated references throughout the poem to la chanson, la geste, lestorie, and lescrit, as the authority for particular statements[3](javascript:footNote('T250001-001/note003.html')), and from these references taken in connection with the opening lines we must, I think, conclude that **Morice Regan** supplied the writer with a written chronicle of the events which had already been put into metre, so to deserve the name of a chanson. **Morice Regan**, Dermot's faithful latimer, may have himself kept such a chronicle, and our rhymer appears not to have been the first to translate and versify the materials. In dealing with a fragmentary passage such as that before us, there is an inevitable risk of misapprehension; but I am inclined to think that the words lui ki cest(e) iest(e) endita (ll. 5 and 6) refer, not to the person intended by the words moi and me in ll. 2 and 7, but to the writer of this pre-existing geste, chanson, or estorie. This supposition will, at any rate, account for the change from the 1st to the 3rd person. That our writer did not rely solely on the written materials 





---

p.xx




supplied to him may be inferred from the fact that he repeatedly quotes as his authority common report, or the 

statement of old people[4](javascript:footNote('T250001-001/note004.html')) while such phrases as cum il me fud endite l. 177, solum le dist de mun cuntur l. 407, cum il me fud cunte l. 2241, seem to point to some particular informant, perhaps **Morice Regan** himself.


*Date of the Poem.* As to the date of the poem we have first of all the statement that our author met **Morice Regan** in the flesh, and as the latter was employed on an important embassy 

to Wales in 1168, and was sent to summon Dublin to surrender in 1170, we can hardly place his birth later than about 1147. Supposing he was eighty years of age when he told the story to the writer we get 1227 as an outside date. Looking at the contents of the Chronicle we find that the narrative is brought regularly down in this fragment only to 1175 or 1176, but there are two allusions pointing to a much later date. First with regard to **archbishop Laurence O'Toole**, it is stated in l. 1844 Que Seint Laurence pus ert clame. Now, though he died on the 14th November 1180, he was not canonized until the 11th December 1225, and prior to his canonization he could hardly have been called Saint Laurence.[5](javascript:footNote('T250001-001/note005.html')) Lines 





---

p.xxi




1843–4 have, however, the appearance of being a subsequent addition or interpolation, and there are not wanting indications that the original text has been altered in this passage (see foot-note to text, ll. 1837–42); but, however this may be, from another allusion we cannot place the composition of the poem, in its present form at least, earlier than the beginning of the 13th century. I refer to the passage (ll. 3040–3057) where **Philip de Prendergast**, the son of Maurice, is described and is stated to have married the daughter (Maud) of **Robert de Quency**, and to have long held the constableship of Leinster (cf. ll. 2823–6). The sketch of Philip's character, I may remark, is very graphic and reads like a description from personal observation.[6](javascript:footNote('T250001-001/note006.html')) Now we know from this poem that **Maud de Quency** was born in 1172 or 1173 (cf. ll. 2744, 2807, 2819), and therefore she could hardly have been married to **Philip de Prendergast** before 1190. In another way we get an outside limit to the date of this marriage. On an inquisition in A. D. 1251 as to the lands and heirs of Gerald or **Gerard de Prendergast**, son of Philip by **Maud de Quency**, it was found that by his first wife, sister to **Theobald Pincerna**, Gerald left one surviving daughter who married **John de Cogan** and left an only son then aged eight years.[7](javascript:footNote('T250001-001/note007.html')) This grandson of Gerald was therefore born in 1243. His mother, Gerald's daughter, must have been born not later than about 1223, and Gerald himself not later than about 1200. So **Philip de Prendergast** must have married **Maud de Quency** between 1190 and 1199, probably near the earlier date. Now he apparently obtained the constableship in right of his wife, and the poem says he held it for a long time. We can fix Philip's death as having 





---

p.xxii




occurred between 1227 and 1231[8](javascript:footNote('T250001-001/note008.html')) and though the poem does not speak of him as having been dead, the statement that he held the constableship plus longement (or mult longement, which is, perhaps, the correct reading) could not have been made very much before 1225, or, at any rate, not until after the commencement of the 13th century. On the other hand, if we are to suppose that **Morice Regan** supplied the writer with materials shortly before the poem was written, we cannot place its date very long after 1225. Accordingly we must fix upon some time very soon after 1225, or assuming the allusion to St. Laurence to be an interpolation, some time earlier in the 13th century, as the probable date of the poem in its present form. So much for the immediate original of the transcript which has come down to us. Can we determine anything about the pre-existing geste or estorie with which **Morice Regan** supplied our author? Now it is a remarkable fact that, with the exception of these two allusions to the canonized **Laurence O'Toole** and to **Philip de Prendergast**, the former of which was probably an interpolation, there is nothing in the poem, so far as I have observed, pointing to a later date than 1177, unless, perhaps, the commonplace expressions referring to the statements of old people. Indeed even the reference to **Miles de Cogan** as ‘afterwards lord of Mount Brandon’ (ll. 1652–5)—a place included in the grant to him made at the Council of Oxford in 1177—is introduced in a somewhat forced manner suggestive of subsequent interpolation. The grant to **Miles de Cogan** and **Robert Fitz-Stephen** of the kingdom of Cork would more 





---

p.xxiii




naturally have been mentioned, had it already taken place, along with the elaborate account of the subinfeudation of Leinster and Meath. At any rate, we might have expected that changes in the grants there mentioned, as for instance the substitution in 1181 of lands in Leix for the lands in Kildare given to Meiler, would have been noticed had they already taken place. The account of the attack on Slane Castle (ll. 3184–3201), which is mentioned out of the chronological order, seems also to have been an afterthought. Certainly ll. 3202–7 read as if they were written to follow immediately after the account of the subinfeudation of Leinster and Meath. A similar inference may be drawn from l. 2341, where it is said that **Richard de Cogan** made his famous sortie from Dublin ‘par la dute del Occident’. The word ‘dute’ is obscure, but it is sufficiently clear that the western gate is intended. Now the ‘porta occidentalis’ is mentioned in a grant made by the citizens of Dublin in 1185 when **John de Curci** was Justiciar and preserved in the Register of the Abbey of St. Thomas, Dublin; and from a subsequent grant it appears that this gate, or more probably a new gate erected on its site, was afterwards known as the ‘Porta Nova’[9](javascript:footNote('T250001-001/note009.html')). **Mr. J. T. Gilbert**, in his History of Dublin (vol. 1, p. 237), says, ‘the date of the erection of the New-gate has not been ascertained, but from the charter of the Hospital of St. John it appears to have been standing in 1188.’ If I am right then in supposing that it replaced the Porta Occidentalis, it must have been erected between 1185 and 1188. Now had this New Gate been in existence at the time when this account of the Norwegian attack was written it would in all probability have been mentioned. No certain conclusion can be drawn from negative evidence of this kind; still it bears out the impression gained from reading the whole 





---

p.xxiv




poem, viz. that the writer whose date we have approximately fixed as soon afler the year 1225, or perhaps a little earlier in the 13th century, did not add much to the pre-existing geste or chanson supplied to him by **Morice Regan**; that this pre-existing poem was written long before 1225 and probably soon after **Strongbow**'s death in 1176, with which event it may well have ended; and consequently that the account we have before us, whenever it was written, is substantially a reproduction of the account of a contemporary writer. There is yet another important consideration which seems to support the above view. It is difficult to suppose that anybody writing in the first half of the 13th century on the subject of the Anglo-Norman invasion of Ireland should have been unacquainted with the works of **Giraldus** on the same subject; and yet while in the main our author and **Giraldus** corroborate one another, they do not always narrate the same events, and even when they do there is just such difference of treatment and divergence in details as might have been expected in writers who derived their information from distinct sources. The fact that both writers connect the rape of Dervorgil with Dermot's expulsion and ignore or slur over the lapse of fourteen years between the two events might at first sight seem to show that the later writer borrowed from the earlier; but the Annals of Clonmacnoise, under the year 1166, also affirm this connection, Which was evidently the popular view of the matter, and, as pointed out in the note to line 27, the popular view was not far wrong. On the whole I think there is no ground for concluding that this poem was in any respect derived from the Expugnatio. It seems to me to be an entirely independent authority for the facts it records, while the absence of any distinct reliance on the Expugnatio confirms the view that our poem is in substance the work of a writer who wrote before the Expugnatio was published.


*History of the MS.* As I have said, it is not known where 





---

p.xxv


**Carew** got the MS. The following considerations seem, however, to point to a probable answer to this question. As already mentioned, the covering skin of the MS. has upon it under **Carew**'s autograph the date 1617. At first sight it seems natural to conclude that this was the date of **Carew**'s acquisition of the MS., but an examination of all the **Carew** MSS. at Lambeth will show that this date appears on fourteen of them, and as it also appears on the first volume of the original Catalogue made by **Carew** and now preserved at Lambeth, the hypothesis suggests itself that this date merely denotes the period when the MSS. bearing it were catalogued. But this hypothesis will not account for all the facts, as some, at any rate, of the volumes apparently catalogued in 1617 are expressly stated to have been compiled at an earlier date.[10](javascript:footNote('T250001-001/note010.html')) On the other hand, of the books dated 1617, No. 597, Pelham's Letter Book, is stated by Mr. Brewer to have been acquired in this year,[11](javascript:footNote('T250001-001/note011.html')) and No. 599, the Book of Pedigrees, is stated in the heading to have been copied in the year 1617. On the whole I think it probable that **Carew** did receive a considerable accession of MSS. in this year, comprising, besides those already mentioned, the following vellum MSS., viz. Bray's Conquest of Ireland and perhaps the Old French Poem on the Deposition of Richard II now bound up with the former (No. 598), the works of **Giraldus** relating to Ireland (No. 622), and the Essay, to be presently described, by **James Yonge** (No. 633). This accession of MSS. may have induced **Carew** to commence his catalogue and to group his papers then existing in a loose state into the other volumes bearing the date in question. The mere fact that he has placed our MS. in the forefront of his catalogue, marking it A, suggests that its acquisition was the immediate cause of the making of the catalogue. Mr. Brewer, the able editor of the Calendar of the Carew MSS., 





---

p.xxvi




has made no attempt to trace the history of the MSS., nor even to set forth the order in which the volumes were obtained or compiled. He gives however, as an Appendix to the Introduction to vol. 2 of the Calendar, a list of all the Carew MSS., equating the old letter marks, consisting of the single, double, and triple alphabets, affixed by **Carew**, with the present numbering; and a comparison of this list with the contents of the MSS. themselves will show that all the MSS. dated 1617 are included in the single letter notation and in the first two volumes of the double letter notation, whereas those volumes, which, from their containing documents of later date, can be shown to have been compiled after 1617, are all, except XX, now No. 635, included in the triple letter notation. I conclude that in 1617, when the catalogue was commenced, the library consisted of all those books marked with a single letter and all those marked with a double letter up to TT, which was compiled in 1611. The volume marked VV, now No. 632, contains documents relating to Waterford, which, as will be presently shown, were probably copied in this year, but the volume may not have been completed until subsequently. Vol. WW is missing. Vol. XX, now No. 635, contains documents of date subsequent to 1617, as do nearly all of those marked with a triple letter which are still to be found. It therefore seems probable that our first impression was correct, and that the date 1617 on our MS. indicates the date of its acquisition by **Carew**. Now on the 21st February in this year, 1617, instructions were sent to the **Earl of Thomond, Lord President of Munster**, and **Sir William Jones, Lord Chief Justice of Ireland**, to seize into the king's hands the liberties of the city of Waterford and to demand all the charters and evidences belonging to the corporation, and among other things ‘such plate, jewells, and other treasure as remayneth in the custoddie of any of them for the publique use and behoofe of that toune.’ On the 5th March following, these commissioners





---

p.xxvii




report that they had carried out their instructions and had received thirteen of the city charters and had locked them up together with other things ‘in a chest of theires [i.e. the corporation's] in the Arundell Towre where all theire writinges are.’[12](javascript:footNote('T250001-001/note012.html')) Now in vol. 632 of the Carew MSS.[13](javascript:footNote('T250001-001/note013.html')) there are copies of a number of charters, grants and other documents touching Waterford, including some letters from Henry VII to the mayor and citizens about **Perkin Warbeck**, and it seems clear that these were among the documents seized in March 1617, and that **Carew** was enabled to take copies of them. If the four vellum MSS. bearing the date 1617 had been among the writings in that chest in the Arundell Tower it is certain that **Carew**, who 

was an ardent collector of historical documents relating to Ireland, would have made every effort to retain them, and the date 1617, affixed to each of them by **Carew** beneath his autograph, suggests that this was the occasion of their acquisition.


There is, however, some further evidence indicating the person through whom **Carew** may have got the MSS. **Donough O'Brian, Earl of Thomond**, who, as already mentioned, was chief of the Commission appointed to seize the liberties of Waterford, was a friend of **Carew**, who describes him in the year 1611 (Car. Cal. p. 147) as ‘an extraordinary well-deserving lord’, and in 1617 he occupied **Carew**'s former position of Lord President of Munster. Now it appears from the heading to the Book of Pedigrees, 





---

p.xxviii




Car. MS. 599, that this book, containing the ‘descentes of ye meere Irishe families’ and ‘formed by sondry collections of ye Earl of Thomond’, was copied for **Carew** in the year 1617.[14](javascript:footNote('T250001-001/note014.html')) Here we have direct evidence of one MS. coming from the **Earl of Thomond** in the year 1617, and, taken in connection with what has been already stated, this fact strengthens the supposition that this Commissioner, having seized a number of charters and other writings at Waterford in this year, gave **Carew** the opportunity of copying the former and of acquiring the vellum MSS. dated by him 1617, including our Old French Poem. That the corporation of Waterford should have had the custody of this MS. at this time is not improbable or without parallel. The Harleian MS. 913, which was in part at any rate the work of **Frere Michel Kyldare**, and which contains the Anglo-Norman poem on the building of the walls of Ross, written in the year 1265, was at one time in the possession of **George Wyse**, bailiff of Waterford in 1566 and mayor in 1571, and appears to have been known in 1608 as the Book of Rosse or Waterford.[15](javascript:footNote('T250001-001/note015.html')) It has been suggested that this book had previously been preserved in the Benedictine Abbey of St. John near Waterford, as a grant of this Abbey was made to **William Wyse**, possibly the father of **George Wyse**, in the year 1536. With regard to our MS., however, I am more inclined to associate it with the Dominican Friary of St. Saviour, known as the Blackfriars, afterwards the Courthouse, at Waterford. This friary was founded by the citizens in 1226, and at its dissolution on the 2nd April, 1541, it is said to have contained among other things ‘a library’[16](javascript:footNote('T250001-001/note016.html')). It was granted to **James White** in 1542, probably the **James White** who was 





---

p.xxix




mayor of Waterford in that year. This **James White** had a special commission as Justice of Wexford in 1538, and from letters of his to Crumwell[17](javascript:footNote('T250001-001/note017.html')) it is evident that he was an ardent reformer and upholder of Henry's claims.


Now in the 13th century there was a distinguished alumnus of this coenobium known as Gotofrid, or, as he calls himself, ‘**Jofroi de Watreford** de I'ordene az freres precheors le mendre.’ From his writings, three of which at least have come down to us, it is inferred that he was acquainted with Greek, Latin, Arabic and French, and that he had travelled in the East and lived for a long period in France. He is mentioned among the Scriptores Ordinis Praedicatorum[18](javascript:footNote('T250001-001/note018.html')) but the best account of his works is to be found in an article by **M. Victor le Clerc**, in the Histoire Litteraire de la France[19](javascript:footNote('T250001-001/note019.html')). He translated into French, (i) the book of the Trojan war by the pseudonymous Dares the Phrygian, (2) the History of the Romans by Eutropius, and (3) the Secretum Secretorum, an apocryphal treatise of Aristotle.[20](javascript:footNote('T250001-001/note020.html')) This last work is 





---

p.xxx




addressed to a patron, ‘a nobles bers prouz et sages’, whose name unfortunately does not appear. It is far from being a literal translation, but contains ‘many good words, not less profitable, borrowed from other works of authority.’ It ends quite in the Irish manner:—‘ceus qui cest liure liront prient por frere Iofroi de Watreford et por seruais copale qui cest trauail empristrent & par layde dedeu lont achief menei. & ausi le liure dares le frigien de la gerre detroi. & ausi le liure de’ [word erased, read etropius] ‘du regne des romains. Cest liure est fini.’[21](javascript:footNote('T250001-001/note021.html')) The MS. containing these three works along with other writings is ascribed to the 13th century. It formerly belonged to the Bibliothèque de Colbert, and passed from it to the Bibliothèque Royale, and is now in the Bibliothèque Nationale of Paris, where it is numbered 1822.


It would certainly be rash to conclude that Jofroi was the writer of our Poem. Indeed, judging from the excerpts from his writings printed in the above-mentioned works, his language is much purer French than that of our text, and is free from some of its dialectical peculiarities. As, however, both MSS. are probably transcripts, and our text has certainly been corrupted, no conclusive argument can be drawn from the exact forms of words used. At any rate, the fact that a monk of the Blackfriars of Waterford in the 13th century could write so freely in French as Jofroi did, and was ready to apply his pen to translating purely secular works, shows at least that there were Dominicans there who understood and valued books of the class to which our MS. belongs, and that there is nothing improbable in the supposition that the transcript which has come down to us was made for them and was preserved for three centuries in their 





---

p.xxxi




library, and indeed never left Waterford until the year 1617. Furthermore, from a doggerel couplet scribbled in an early hand at the end of **James Yonge**'s Essay, Car. MS. 633, which we have already seen reason to suppose was obtained at the same time and place as our MS., there are express grounds for associating that MS. with the Dominicans. This couplet, written three times in a small professional hand, runs as follows:—
  


> 1. Gratia nulla perit nisi gratia blakmonachorum
>   
> Est et semper erit litill thanke in fine laborum.
> 





A somewhat similar sentiment is expressed on the preceding page under the roughly drawn figure of a man in an 

early Tudor dress:—
  


> 1. Farewell adue I must nedes goo hens
>   
> My labour is lost I gett no pens.
> 




This MS. is also remarkable from another point of view, for it proves that Jofroi's translation of the Secreta Secretorum was known in Waterford in the beginning of the 15th century. Like Jofroi's work, it purports to be a translation of this apocryphal treatise of Aristotle, though this fact is not noted in the Calendar of Carew Papers. Another and perhaps earlier version of the same work is preserved in the Bodleian Library, and is stated by **Mr. J. T. Gilbert** to be ‘the earliest known composition of any length written in English by an Anglo-Irish author.’ It is dedicated to ‘Yow nobyll and gracious lorde Jamys de Botiller, Erle of Ormonde, lieutenant of our lege lorde kynge henry the fyfte in Irlande,’ (A. D. 1419–22); and a comparison of its preface with that of Jofroi will alone show that **Yonge** had Jofroi's translation before him.[22](javascript:footNote('T250001-001/note022.html'))




---

p.xxxii


*Historical value of the Chronicle.* Though, owing to the want of a good working edition of this poem or chronicle, historians have not fully availed themselves of its materials, yet its historical importance has often been noted. Thus **Harris** in his preface to Hibernica says:—‘Whoever writes the History of Ireland during the English Period must make this Piece the main Basis of his Account; and the Defects of our Author must be supplied from **Cambrensis**.’ Again, **Mr. Dimock**, the editor of the Topographia and Expugnatio Hibernica of **Giraldus** in the Rolls Series, speaking of this poem, which he frequently cites, says:—‘There is every reason to accept it as simple prosaic truth, according to the writer's best belief and information, put into simple rhyme; and in rhyme though it be, its history, I have not a doubt, is far more accurately true than **Giraldus**'s poetical prose. Sometimes it gives a strong general confirmation to **Giraldus**'s narration, but the particulars often are very different. Its heroes are not always the same as the heroes of **Giraldus**; 

and while it has nothing of some events related by him, it dwells, on the other hand, on other events and persons passed over by him in silence.’[23](javascript:footNote('T250001-001/note023.html'))




---

p.xxxiii


The **Rev. G. T. Stokes**, Professor of Ecclesiastical History in the University of Dublin, has, indeed, drawn on some 

of the materials supplied by this chronicle in his earlier Lectures on ‘Ireland and the Anglo-Norman Church’, and has ably shown to what valuable use they may be put. He too bears witness to the accuracy and truth of the poem, and says (p. 72):—‘The more carefully you study this Anglo-Norman poem, the more thoroughly you will trust it. It is evidently based on original documents. It fixes dates, Church festivals, mentions the precise periods during which the armies reposed, the roads they took, the rivers they crossed, and many other topographical details which have escaped the notice of the editor, Mr. Wright.’


The critical judgment as to the value of our poem by such writers as **Mr. Dimock** and **Professor Stokes**, who have studied the original text, far outweighs the adverse opinions of Lord Lyttelton, Mr. Moore, and even of **Dr. O' Donovan**, who were acquainted only with the inaccurate printed copy of **Carew**'s faulty Abstract.


The chronicle is written from the point of view of Dermot and his allies. Indeed had the writer not told us so himself we should have concluded that his information was mainly derived from a devoted follower of Dermot. The very absence, however, of any sort of moral condemnation for anything done, except for treachery towards Dermot which is always committed à tort and the simplicity and directness of the narrative render it probable that it is a truthful account of what came within the writer's sources of information. His knowledge of Irish topography and Irish nomenclature 





---

p.xxxiv




compares favourably with that of **Giraldus**. The orthographic rather than phonetic forms adopted for some of the Irish 

names, such as Hathcleyth (l. 2210) for **Ath-Cliath**, Hachedur (l. 1012) for **Achadh-ur**, Kinelogin (l. 3258) for **Cinel-eoghan**, together with the use of the word ‘langport’ (Ir. longphort) for camp, seem to show that the writer had an Irishman at his elbow; while the frequent employment of the tags and commonplaces of the trouvères proves his acquaintance with the rhymed chronicles and chansons de geste of the time. I have already remarked that the narrative appears to be quite independent of the works of **Giraldus**. The writer's freedom from the family bias of the Geraldine has probably enabled him to make a juster estimate of the relative merits of the invaders. We hear at least as much of the prowess of **Earl Richard** and of the de Cogans as we do of that of the Geraldines, and much is said in these pages of the probity and valour of **Maurice de Prendergast**, while **Giraldus** merely records his landing. Incidental allusions the accuracy of which can be verified—such as the mention of **Robert Harding** of Bristol and his monastery of St. Austin's (ll. 232, 302), the references to the Steine and Howe at Dublin (ll. 2269 and 2321) and to the names of the city gates (ll. 2333 and 2341), the mention of Henry's place of embarkation in Wales, La Croiz (2590), and of Raymond's home, Karreu, (l. 2860)—prove the correctness and the independence of our 

author's information.


*Language and versification.* With reference to language and versification, the poem, as **M. Michel** says, is faulty in style and very corrupt in its language. At the same time there are many indications that the poem as originally written was much freer from blemishes than the transcript that has come down to us. Again and again it will be found that a line, the metre of which is faulty, can be set right by some obvious grammatical correction. I have not in general thought it necessary to suggest such changes in the footnotes.




---

p.xxxv


While in many cases to make the requisite alteration is sufficiently easy, to do this exhaustively, so as to make all the lines metrically and grammatically correct, would involve a reconstruction of the text which, with only a single MS. to go upon, would often be extremely problematical. In the case of Anglo-Norman texts written in England (or Ireland) it cannot be assumed that the lines were originally either faultless in metre or strictly grammatical in form, and it is well known that in England by the beginning of the 13th century the old rules of declension were rapidly falling into decay. Where, however, the reading of the MS. leaves the sense obscure, and in some other cases where it seemed useful, I have suggested corrections in the footnotes and adopted them in the translation.


With respect to the rhymes, which in general, with a few obvious corrections, seem accurate enough, it may be useful to make the following remarks:—
  




In apparent derogation of the rule that *e* proceeding from the Latin *a* only rhymes with an *e* of similar origin, we have the rhymes pe (pedem): naufre 1953: meyne 2385: lesse 2876, and pes: heistez 1096; muiller: per (parem) 2833: guerrer (guerrier) 3062; fer (ferum): herberger 2941: lesser 2986, &c. These examples, however, all come within the recognised exception that when the Latin *e* open, tonic, free (to adapt the convenient terminology of French phonetics) does not become the diphthong *ie* it rhymes with *e=a*. The rhymes fiez: fublez 596–7, feiz: turnez 2673–4, and feez: citez 3010–11 are explained by treating fiez (which we should read in each case) as proceeding from *vicem* + the suffix *-atam*.


Instances of silent consonants before *s* or *z* are—poestifz (elsewhere written poestis): Henriz 242–3; nefs: arives 469; gentilz (elsewhere gentis): pris 1003; detrefs (elsewhere detres): escriez 2363; Mechins: tramis 2162: amis 3355; meins (*mensem* elsewhere meis): reis 309: conqueis 2972; pirs (*pejus* perhaps read pis): pais 2530: enemis 3183; volt (elsewhere 





---

p.xxxvi




vout: out 319. Careless rhymes are:—souders: armez 1897: aprestez 3380, but: poigners 3366; Dermod usually rhymes with vout, out, and the impfs. in -out of the 1st conj., but: Weyseford 1392; trestute: buche 3268–9 is a suspicious rhyme. In the following there is neither rhyme nor assonance:—demure (or demore): Leynistere 74–5; paumer: traitur 182–3, unless we suppose a form palmor; chevaler: partir 392–3, unless we suppose the verb assimilated to the first conjugation.


It may also be noted that the nasal *-um=-ons: un (on)* e.g. accomplerum: reisun 144–5, lisum: barun 1064–5. Similarly champ: garant 674–5, champ(e): blanc 2447–8. The rhyme meins (minus): anciens 2677–8, might seem to point to a form, ancieins but we have elsewhere anciens: quens. The diphthong *ui* is sometimes reduced to *u:*—thus we have not only nuit: brut 1312–13, and: dedut 808–9, where we might read bruit and deduit but also nuiz: venuz 1981–2, and nuit: jut 2137–8.


As in Norman texts, generally, we have *ei* usually retained for *oi*. Again, *ie* is generally reduced to *e*, and the past part, fern, in *ee* has lost the post-tonic *e*.


The impfs. of the 1st conj. are regularly in *-out*, but we have exceptionally ameit 53, and pleideit 2104; but this last is perhaps from the form pleidir, cf. Bozon, Société des Anciens Textes Français. Gloss. Conversely we have se pleniout 100 from se pleindre. There are indeed some instances of verbs in *-eir, -re* and *-ir* having been assimilated, at least in the infinitive, to the first conj.


Thus we have saver 622, aver (:feffer 435: mester 2731), poer as a verbal subst. 44; tener 776, 2838; ver=veeir 476; assente 

(for assenti 2371, cf. Bozon Société des Anciens Textes Français where the verb is assimilated to the 1st conj.; tollet 218, but elsewhere tolir 2708. There are however indications that this assimilation had proceeded much further when the present transcript was made than at the date of the original composition. Thus the rhymes asailler: mentir 1032–3, asailer: partir 1574–5; 





---

p.xxxvii




asaillerent: defendirent 3192–3, show that the occasional reduction of asaillir to the 1st conjugation was the work of the copyist. The same may, I think, be said of the rhymes adurez: tapez 714–15, as elsewhere we have the form aduriz in rhyme, and syverent: virent 546–7.


*Literary Qualities.* As to the literary qualities of our poem, great allowances have to be made for the corrupt form in which the text has come down to us, and of course poetry in the sense of imaginative art is not to be looked for. Still this fragment seems to stand somewhere between the chanson de geste proper and the mere rhymed chronicle. It deals with heroes, though the heroes were real and, perhaps, contemporary men, and the cause for which they fought was not a noble one. We have constantly presented to our view the handful of mail-clad Norman knights and well-armed followers pitted against hordes of undisciplined and ill-armed ‘traitors’, and the conflicts between them form so many graphic battle-pictures. The repulse of the attack on Raymond's camp with the remorseless executions that follow; the desperate sortie of the 600 from the siege of Dublin, and the dispersion of O'Conor's enormous host, ‘like wandering cattle’, the furious attempt by John the Wode and the Northmen to recover their city, and their final discomfiture, are all told with simplicity and vigour. There is a touch of real chivalry in the conduct of **Maurice de Prendergast** when he braves the wrath of his comrades and crosses swords with his allies rather than permit an act of base treachery to a foe whom he has sworn to protect; and there is a stroke of something like humour in the advice of **Miles de Cogan** to the Irish chieftain to watch the battle from afar and join in with the victors.




---

p.3


An Old French Poem
------------------

1. [*gap: text acephalous/extent: unknown*]  
By his own interpreter
  
Who told to me the history of him,
  
Of which I here make record.
  
This man was Morice Regan,
  
5] Face to face he spake to him
  
Who related this geste:
  
The history of him he showed me.
  
This Morice was interpreter
  
To King Dermot, who loved him much.
  
10] Here I shall leave off about the bachelor,
  
About King Dermot I will tell you.
2. In **Ireland**, at this day,
  
There was no more worthy king:
  
Very rich and powerful he was;
  
15] He loved the generous, he hated the mean.


---

p.5


He by his power
  
Had taken and conquered
  
O'Neil and **Meath** in his war;
  
Hostages he brought to **Leinster**:
  
20] He brought with him O'Carroll,
  
The son of the king of **Uriel**.
3. Now in **Leath-Cuinn** there was a king,
  
O'Rourke he was called in Irish,
  
In **Tirbrun**, the barren, he dwelt,
  
25] A waste and woody land.
  
But O'Rourke, the rich king,
  
Had a beautiful wife at this time,
  
The daughter of King Melaghlin
  
To whom **Meath** was suject.
  
30] Melaghlin was lord of **Meath**;
  
Whoever would tell you the truth,
  
She was of the stock
  
Of the good old Melaghlin;
  
He was sprung from the lineage
  
35] Of Melaghlin of the bold heart,
  
The son of Coleman, the rich king,
  
Who was so well-bred and courteous.
  
About Melaghlin I will leave off,
  
About King Dermot I will tell.
4. 40] Dermot, king of **Leinster**,
  
Whom this lady loved so much,
  
Made pretence to her of loving,


---

p.7


While he did not love her at all,
  
But only wished to the utmost of his power
  
45] To avenge, if he could, the great shame
  
Which the men of **Leath-Cuinn** wrought of old
  
On the men of **Leath-Mogha** in his territory.
  
King Dermot often sent word
  
To the lady whom he so loved—
  
50] By letter and by messenger,
  
Often did the king send word
  
That she was altogether, in truth,
  
The thing in the world that he most loved;
  
Thus he besought her very often
  
55] For her true love covertly.
  
And the lady sent him word
  
By a secret messenger
  
That she would do all his will:
  
To the king who is so renowned
  
60] She returns answer again,
  
Both by word of mouth and by letter,
  
That he should come for her in such manner
  
With all the host of **Leinster**
  
And by force and by war
  
65] Should carry her away with him from the land;
  
That she would let King Dermot know
  
In what place he should take her
  
Where she should be in concealment,
  
That he might freely carry her off:


---

p.9


70] In what place, in short, she should be
  
Where he might freely carry her off.
5. The king summoned speedily
  
All his men throughout **Leinster**,
  
To come to him without delay
  
75] From **Ossory** and from **Leinster**;
  
And he let them all know
  
That he wished to go against **Leath-Cuinn**,
  
To avenge, if he could, the shame
  
Which these men wrought of yore;
  
80] The shame which they had wrought of yore
  
In **Leath-Mogha**, in his territory.
6. Promptly they came
  
At the king's command.
  
When all were assembled,
  
85] Against **Leath-Cuinn** they turned straightway;
  
Night and day they marched forward
  
Rich and poor, small and great.
  
Why should I go on telling you more?
  
Into Tirbrun came the valiant king.
  
90] Now the lady had sent word
  
To King Dermot where she was,
  
That he should come with his men
  
And promptly carry her off
  
King Dermot immediately
  
95] Came marching to the place
  
Where the lady had sent word.
  
That she would be ready.


---

p.11


In this way Dermot the king
  
Carried off the lady at this time.
7. 100] O Rourke bitterly complained
  
For his wife whom he had lost;
  
While he offered very fierce battle
  
To the men of **Leinster**.
  
But, my lords, King Dermot
  
105] Then brought the lady away with him,
  
Nor ever ceased marching
  
From thence to the midst of **Hy Kinsellagh**.
  
And the lady for a good long time
  
Was there, as people say:
  
110] At **Ferns** she was placed for her abode,
  
As people say, in this manner.
8. O Rourke, much grieving,
  
To **Connaught** went in all haste.
  
To the king of **Connaught** he relates all;
  
115] Bitterly he complains of the shame,
  
How the king of **Leinster**
  
Came upon him in such manner,
  
Took his wife by force from him,
  
And placed her at **Ferns** for her abode.
  
120] To the king of **Connaught** of the outrage
  
Bitterly he complains, and of the injury;
  
Very earnestly he besought him
  
To make ready for him
  
Some of his household and of his men
  
125] So that he could avenge his shame.


---

p.13

11. The king of **Connaught** sent word
  
To the king of **Ossory**, in the first place,
  
That he should not fail their king
  
But should come to their aid.
  
130] And these men fully promised him
  
That they would make him king in that territory
  
If they could cast out of it
  
King Dermot who was so bold.
  
And this man immediately revolted
  
135] Against his lord, King Dermot;
  
And Melaghlin, the traitor,
  
Abandoned his lord;
  
And Mac Torkil of **Dublin**
  
Abandoned his lord at this moment.
  
140] There joined in the treason
  
Murrough O'Brien, an evil rebel,
  
Whom the dogs devoured,
  
As the song will tell you
  
As soon as we shall complete it for you
  
145] Further on in your story.
12. When Dermot the noble king,
  
Who was of so much worth,
  
Saw that they had failed him
  
Gossips, kinsmen, and friends,
  
150] One day King Dermot took horse
  
And brought with him some of his men,
  
And went to seek the rebel O'Brien;


---

p.15


He wished to parley with him in secret.
  
O'Brien, however, kept avoiding the king:
  
155] With him he would not, either much or little,
  
Parley or counsel aught
  
Nor assistance give his lord.
13. When king Dermot saw this
  
That he could not parley with the rebel,
  
160] The king immediately turned back
  
Straight to the city of **Ferns**.
  
At **Ferns** the king abode
  
At an abbey that was there
  
Of Saint Mary the Queen,
  
165] Glorious lady and Virgin.
14. Then the king devised
  
A trick that he would play;
  
How he might find the rebel
  
And by cunning speak to him.
  
170] To the Abbot the king sent word,
  
That he should lend him a cope,
  
A cope for a canon
  
Or for a priest or for a monk.
15. To Knoth then the king goes
  
175] This time with the cope.
  
At a dun of his he found him,
  
As it was related to me.
  
The king put on the cope
  
Which trailed down to his feet,


---

p.17


180] So that one could not but take him
  
For a Monk Regular.
16. When the Palmer had come
  
Before the traitor's house,
  
The rebel, when he saw the king, straightway
  
185] Hurried off towards the forest;
  
For the wicked traitor
  
Did not wish to recognise him as his lord.
  
The rebel then shouts
  
In a loud and strong voice:—
  
190] 'Wicked king, what do you seek?
  
Be off with you at my bidding;
  
And if you do not do so speedily
  
I shall have you strung up to the wind.'
17. When the king heard him,
  
195] He was full of grief and wrath.
  
The king was in great distress
  
For the saying of the traitor
  
Who had so menaced him
  
And would string him up to the wind.
  
200] The rich king returned
  
Who was so liberal and courteous,
  
Since the traitor revolted
  
Against his rightful lord.
  
All his men failed him
  
205] Both of **Leinster** and of **Ossory**.


---

p.19

20. When Dermot the king perceived
  
That he was betrayed at this time:—
  
His own men failed him
  
So completely was he betrayed—
  
210] And that they wished to take him
  
To hand him over and sell him to O'Rourke,
  
While the king of **Connaught** on the other hand
  
Should make a great destruction of him—
  
Why should I delay you
  
215] From your geste at all?
21. His people by the strong hand
  
Have cast out King Dermot,
  
Have wrested the whole kingdom from him
  
And have driven him from **Ireland**.
  
When the king was exiled
  
220] He took ship at **Corkeran**;
  
When the king was abandoned
  
At **Corkeran** he took ship;
  
At **Corkeran** he put to sea,
  
225] Auliffe O'Kinad he brought with him,
  
With him the rich king brought
  
And more than sixty three.
22. The rich king had the wind
  
Fine and fair to his desire:
  
230] His ships had a very fair breeze;
  
At **Bristol** they take the shore.
  
At the house of Robert Harding,


---

p.21


Near to **St Austin's**,
  
King Dermot abode
  
235] With as many men as he had.
  
According to common report,
  
The queen was there also.
23. When the king had stayed
  
*At **Bristol*** as long as he pleased,
  
240] He had his knights summoned,
  
He resolved to go to **Normandy**
  
To hold parley with King Henry
  
Of **England**, the powerful.
  
For the king of **England**
  
245] Was, my lords, at that time
  
In **Normandy** on account of his war,
  
On account of the war with the French.
  
So much did Dermot accomplish
  
By his journeyings and so far go
  
250] That he landed in **Normandy**,
  
According to the old people.
  
It is well, my lords, that I should tell you
  
How Dermot goes through **Normandy**:
  
To seek King Henry then he goes
  
255] Up and down, forwards and back;
  
He sent messages and made enquiries
  
Until he found King Henry;
  
At a city he found him
  
Of which he was called lord.


---

p.23


260] King Dermot, as soon as he could,
  
Went indeed towards the court:
  
Towards the court step by step
  
He went away very quickly
  
To hold parley with the English king,
  
265] Who was so rich and so bold.
24. When Dermot, the valiant king,
  
Before King Henry
  
Had come at this time,
  
Before the English king,
  
270] Very courteously he saluted him
  
Fairly and finely before his men:
  
'May God who dwells on high
  
Guard and save you, King Henry,
  
And give you also
  
275] Heart and courage and will
  
To avenge my shame and my misfortune
  
That my own people have brought upon me!>
  
Hear, noble king Henry,
  
Whence I was born, of what country.
  
280] Of **Ireland** I was born a lord,
  
In **Ireland** acknowledged king;
  
But wrongfully my own people
  
Have cast me out of my kingdom.
  
To you I come to make plaint, good sire,
  
285] In the presence of the barons of your empire.
  
Your liege-man I shall become
  
Henceforth all the days of my life,


---

p.25


On condition that you be my helper
  
So that I do not lose at all
  
290] You I shall acknowledge as sire and lord,
  
In the presence of your barons and earls.'
  
Then the king promised him,
  
The powerful king of **England**,
  
That willingly would he help him
  
295] As soon as he should be able.
25. King Henry said, in the first place,
  
That he should set about returning home.
  
He crossed the sea to **England**,
  
And went to stay at **Bristol**.
  
300] Then King Henry sent word
  
By letter and by messenger
  
To Robert Harding, as he held him dear,
  
That he should provide for the king whatever he might need,
  
For him and for all his men,
  
305] In every respect according to his wish.
  
Honourably he executed for him
  
All his commands.
  
At **Bristol** the king abode
  
A fortnight or a month, I know not which.
  
310] Whatever the king would order
  
Robert supplied to him in plenty.
  
But the king of **England**
  
For Dermot, according to the lay,
  
Did nothing in truth
  
315] Beyond the promise, as people say.


---

p.27


When King Dermot saw
  
That he could get no aid
  
From King Henry as he had promised him,
  
He would not stay there any longer.
  
320] King Dermot then, you must know,
  
Goes everywhere seeking aid:
  
Aid everywhere he seeks
  
In **Wales** and in **England**.
  
So far did he ask for aid
  
325] Up and down in this kingdom
  
That he had an interview,
  
So says the geste, with Earl Richard.
  
He was a brave earl,
  
Courteous, generous, and lavish.
  
330] Very earnestly the king.
  
Besought him, very courteously,
  
To give him some succour,
  
Or that he himself should come
  
To conquer his kingdom,
  
335] From which he had been wrongfully cast out.
  
To the earl he told plainly
  
How he had been betrayed by his people:
  
How his people had betrayed him
  
And driven him out and put him to flight.
  
340] His daughter he offered him to wife,
  
The thing in the world that he most loved:
  
That he would let him lave her to wife,
  
And would give **Leinster** to him,
  
On condition that he would aid him
  
345] So that he should he able to subdue it.


---

p.29

28. The earl at this time was a bachelor,
  
He had neither spouse nor wife.
  
When he hears from King Dermot
  
That he was willing to give him his daughter
  
350] On condition that he would come with him
  
And subdue his land for him,
  
The earl replies before his men:—
  
'Rich king, hearken unto me.
  
Here I assure you loyally
  
355] That I shall assuredly come to you;
  
But I should wish in these matters
  
To crave licence of the English king,
  
For he is the lord
  
Of my landed estate;
  
360] Wherefore I cannot go from his territory
  
Without obtaining licence in this way.'
  
The king assured the earl
  
That lie would give him his daughter
  
When he should come to his aid
  
365] To **Ireland** with his barons.
  
When they had concluded this accord,
  
The king turned straight towards **Wales**,
  
And never ceased journeying there
  
Until he came to **St. Davids**.
29. 370] There the king abode
  
Two or three days, I know not which,
  
In order to equip his ships,
  
for he wished to cross over to **Ireland**.


---

p.31


But before King Dermot
  
375] Crossed over the salt sea,
  
He spake to a king in **Wales**
  
Who was very brave and courteous.
  
This man was called Rhys,
  
And was acknowledged King of **Wales**.
  
380] At this time King Rhys
  
Had a knight of great renown.
  
The king kept him in prison,
  
Robert the son of Stephen was his name.
  
In his prison he was keeping him,
  
385] He wished him to submit.
  
I know not how the king took him.
  
In a castle in his country.
  
Concerning him I will not here relate
  
How he was taken nor in what way;
  
390] But the rich King Dermot
  
Then besought King Rhys
  
As much as he could on behalf of the knight
  
That he might be able to depart freely.
  
Not to tell you an untruth
  
395] I know not if he was liberated then:
  
At the request of the rich king,
  
If he was liberated at that time;
  
But afterwards the knight
  
To **Ireland** came to aid the king.
  
400] Then King Dermot returns.
  
To **St. Davids** as soon as he could.
  
To **Ireland** then he crossed


---

p.33


With as many men as he had.
  
But Dermot, the noble king,
  
405] Did not bring with his warriors.
  
Any Englishmen on this occasion,
  
According to the account of my informant,
  
Except one Richard, as I have heard say,
  
A knight of **Pembrokeshire**,
  
410] Richard the son of Godibert,
  
A knight he was of good parts,
  
Together with knights, archers and serjeants,
  
But I know not up to what number.
  
For they were not long
  
415] In **Ireland**, these men;
  
For they were hardly able to do any good there
  
To the king in the land,
  
Because they were only a few men
  
Who crossed over in haste.
30. 420] King Dermot then sent word
  
By letter and by messenger,
  
He sent over Morice Regan,
  
His own interpreter.
  
To **Wales** this man crossed over—
  
  
[*gap: extent: one or more lines*]  

  
425] The letters of King Dermot
  
Which the king sent in all directions.
  
To earls, barons, knights,
  
Squires, serjeants, common soldiers,
  
Horse-men and foot,
  
430] In all directions the king sent word:—


---

p.35


'Whoever shall wish for land or pence,
  
Horses, armour, or chargers,
  
Gold and silver, I shall give them
  
Very ample pay;
  
435] Whoever shall wish for soil or sod
  
Richly shall I enfeoff them.'
  
He would also give them sufficient
  
Farm-stock and a handsome fief.
  
When the letters were read,
  
440] And the people understood them,
  
Then Robert the son of Stephen
  
Got himself ready the first;
  
He wished to cross over to **Ireland**
  
In order to aid King Dermot.
  
445] Brave knights of great renown
  
He brought with him, nine or ten.
  
One was Meiler the son of Henry,
  
Who was very powerful;
  
And Miles came there also
  
450] The son of the bishop of **St. Davids**.
  
Knights came there and barons
  
Whose names for the most part I do not know.
  
There crossed over a baron
  
With seven companions,
  
455] Maurice de Prendergast was his name,
  
As the song tells us.
  
Hervey too, in truth, crossed over,
  
He was of Mount-Maurice.
  
About three hundred crossed over


---

p.37


460] Knights and common folk besides.
  
At **Bannow** they landed
  
With all their men.
  
When they had landed
  
And had all disembarked,
  
465] They made their men encamp
  
On the sea-shore.
  
The English folk sent word
  
To King Dermot by messenger
  
That at **Bannow** with three ships
  
470] They had at that time landed,
  
And that the king should speedily
  
Come there without delay.
  
King Dermot by the direct road
  
Towards **Bannow**, next morning,
  
475] Set out very joyfully
  
To see the English folk.
  
When the king had come
  
To **Bannow** to his liegemen,
  
One by one he kissed them
  
480] And courteously saluted them.
  
That night they tarried
  
On the shore where they were;
  
But the king on the morrow
  
Towards **Wexford** directly
  
485] Went immediately, i'faith,
  
To attack the town.


---

p.39


In full force he attacked the city.
  
  
[*gap: lacuna in MS/extent: 1 line*]  

  
The enemy in order to protect themselves
  
Defended themselves from without.
  
490] At this attack the rich king
  
Lost eighteen of his English;
  
While the traitors at this time
  
Lost of their men only three.
  
All day while it was light
  
495] The attack thus lasted
  
Until it became late
  
And the men departed.
  
The men of Dermot the renowned
  
To their tents returned.
31. 500] But next day, the first thing,
  
To King Dermot by messenger
  
The traitors announced
  
That they would give him hostages,
  
Would do him homage and fealty
  
505] In the presence of his baronage,
  
That with him they would be night and day
  
As with their lawful lord.
  
The king graciously accepted
  
This offer in the presence of his men.
  
510] By the advice of his English,
  
The noble king accepted the offer.
  
Thence King Dermot set out
  
Towards **Ferns**, as soon as he could,


---

p.41


In order to heal his wounded
  
515] And to rest his barons.
  
Three weeks King Dermot
  
Abode in the city:
  
Three weeks he abode
  
Close by the city of **Ferns**.
  
520] Then the king summoned
  
Robert and Maurice, first of all,
  
To come at once to confer with him
  
Speedily, without delay.
  
When the barons were come
  
525] And Dermot had greeted them
  
And brought them to the council,
  
He related all to them
  
How the Irish of **Ossory**
  
Greatly dreaded the English:
32. 530] 'Lords Barons,' so said the king,
  
'The Irish greatly dread you;
  
Wherefore, brave Knights,
  
With your advice in the first place,
  
I wish to go to **Ossory**
  
535] To defeat my enemies.'
  
The barons replied to him
  
That never would they be left behind,
  
Nor would they in any way leave
  
The traitors nor cease to seek for them
  
540] Until they had found them


---

p.43


And defeated them in open field.
  
Before the host advanced,
  
Three thousand fighting men
  
Made peace with King Dermot
  
545] Through dread of the English.
33. When the barons saw this
  
That so many men followed theirs,
  
Against the king of **Ossory**
  
They marched with the assembled host.
  
550] Consider it not, my lords, as trivial:
  
Bear with me a little while I tell you
  
How the king of **Leinster**
  
With the men whom he had so bold
  
Wished to enter the country
  
555] Where all his enemies were.
  
His enemies are in front,
  
Full five thousand fighting men,
  
Whom the king of **Ossory**
  
Had in his company.
  
560] Mac Donnchadh, the traitor,
  
Who was lord of **Ossory**,
  
Had thrown up before him
  
Three trenches wide and deep:
  
Before hint, within a pass,
  
565] Three trenches rapidly
  
Had the rebel thrown up


---

p.45


And erected a stockade on top.
  
There he offered battle
  
To King Dermot, without fail, that day.
  
570] There the fight took place
  
From morning until eventide
  
Between the rebel king of **Ossory**
  
And the English with great animosity.
  
But the English in the end
  
575] By force and by energy
  
Hurled the traitors thence,
  
By force and by strength.
  
But many men were wounded there,
  
Both killed and disabled,
  
580] Ere the stockade was won
  
Or forcibly wrested from them.
34. When King Dermot saw this
  
That by the might of the English
  
The pass was won in this way
  
585] With his men of **Leinster**,
  
He was full of confidence.
  
The rich King Dermot at that time
  
Wasted the land with fire
  
In order to destroy the rebel;
  
590] He sought for spoil everywhere
  
Up and down throughout the territory;
  
As much as he could find
  
Of the spoil he brought away with him.
  
Then the king marched in a different way


---

p.47


595] In order to seek the rebel Mac Donnchadh
  
Than he did at that time
  
When he put on the cope,
  
When he wished to parley and advise
  
With the rebel O'Brien, the evil one.
35. 600] When the noble King Dermot
  
Wished to return to his own country,
  
Then the king called
  
The three renowned barons:
  
Robert he called by name
  
605] And Maurice, the baron,
  
And Hervey de Mont-Maurice
  
He caused also to be called.
  
These were at that time
  
Chieftains of the English.
36. 610] 'Lords,' quoth he, 'listen to me
  
For the love of God and hearken:
  
Draw up your men in ranks,
  
For well you know how to advise them.'
  
The barons thereupon carried out
  
615] For the king all his command:
  
Speedily they carried out
  
All the king's command.
  
All the men of **Hy Kinsellagh**
  
They entrusted to Donnell Kavanagh.


---

p.49


620] He was son of the King
  
Of **Leinster**, as I trow.
  
Whoever would wish to know the truth,
  
He was the foremost in the van;
  
While King Dermot himself
  
625] Remained with the English;
  
For in them King Dermot
  
Trusted absolutely.
  
Well armed were they, without doubt,
  
And well skilled in battle.
  
630] Now Donnell Kavanagh, in the first place,
  
Was about to cross through a pass
  
Where Dermot had formerly been
  
On three occasions defeated.
  
Wherefore the Irish dreaded
  
635] Lest they should be for the fourth time
  
Discomfited and defeated.
  
They therefore turned to flight,
  
So that with Donnell, the king's son,
  
640] There remained but forty-three.
  
Mac Donnchadh of **Ossory**
  
Soon rallies towards him his men:
  
He rallies his men speedily
  
To discomfit the Englishmen.
37. Know, Lords Barons,
  
645] That the English at this time
  
Had descended into a valley,
  
Both horse and foot soldiers.


---

p.51


For it happened that they were obliged
  
To pass through the middle of this valley.
  
650] Wherefore the English dreaded
  
The Irishmen at this time
  
Lest they should rush upon them
  
Without delay, at this moment.
  
For the English, as I hear,
  
655] Were hardly more than three hundred
  
At that time with the king,
  
And of the Irish, forty-three;
  
While their opponents, of a truth,
  
Were one thousand seven hundred.
  
660] Wherefore it is not to be wondered at
  
If the brave knights
  
Dreaded these people
  
Who were swift as the wind.
38. Then spake a baron:—
  
665] Maurice de Prendergast was his name—
  
'Lords Barons all,
  
Let us pass through this valley promptly
  
So that we may be on the mountain
  
On the hard field, and on the open ground.
  
670] For most of us are well armed,
  
Bold vassals and combatants,
  
While the traitors are quite naked,
  
They wear neither hauberks nor breast-plates;
  
Wherefore if we turn to hard ground


---

p.53


675] They shall have no protection from death.
  
We shall strike manfully,
  
And each together
  
And all united shall strike,
  
Footmen and horse,
  
680] Against the men of **Ossory**
  
Who will be opposed to us.
  
Because if they are overthrown
  
We shall be for ever dreaded,
  
And because there is no escaping
  
685] Either life or death here.'
  
This was the first pitched battle
  
That was fought, without doubt,
  
Between the English barons
  
And the Irish of **Ossory**.
  
690] And the Irish with great impetuosity
  
Followed the Englishmen.
39. Then Maurice exclaimed:—
  
'Robert Smith, come forward.
  
I shall tell you what to do, friend:
  
695] You shall have fifty archers;
  
In this thicket, of a truth,
  
You shall make an ambuscade for them,
  
Until you shall be passed.
  
The Irish who are behind,
  
700] When these men shall have passed,


---

p.55


If they dash on boldly,
  
You shall make an attack on them behind,
  
And we shall come to your aid.'
  
And Robert replies to the baron:—
  
705] 'Sire, with the blessing of God!'
  
Then they went into ambush,
  
The forty men well armed.
40. Lo! with great animosity
  
All the pride of **Ossory**
  
710] Came pursuing them
  
And eager for the battle.
  
So much did these men exert themselves
  
That they passed the ambuscade
  
Where the forty veterans
  
715] Were concealed in the thicket.
41. When the former had passed
  
By estimation they were two thousand,
  
And the forty archers
  
Did not dare to show themselves;
  
720] Because they were so few men
  
They lay hid without stirring.
42. Then had Dermot, the rich king,
  
Great fear for the English
  
Lest they should be overthrown
  
725] And brought to shame by the Irish.


---

p.57


And the rich King Dermot
  
Called Maurice to him,
  
Very courteouslyhe besought him
  
To take care of these men:
  
730] To take care of his friends
  
Who were left behind.
  
Then the baron replied:—
  
'Sire, at your command.
  
Willingly shall I aid them
  
735] And direct all my efforts thereto.'
43. Maurice turns aside here
  
Draws the rein of Blanchard;
  
And the Irish of **Ossory**
  
Followed the English men
  
740] Until they came into the plain,
  
To the hard open country.
  
Then they drew up their men in ranks
  
And very skilfully marshalled them.
  
Then Maurice shouted
  
745] And invoked Saint David.
  
The son of Stephen turned,
  
And Meiler, the renowned,
  
And Miles the son of David,
  
And Hervey de Mont Maurice,
  
750] And the barons, knights,
  
Squires, serjeants, and youths,
  
Against the Irish turned
  
And invoked St David.
  
And the traitors on their knees


---

p.59


755] Awaited the barons
  
Thus in such a way
  
That there was not at that time
  
A lance-length of ground
  
Between Dermot and the Irish.
  
760] When the English by their valour
  
Had grappled with the enemy
  
The Irish went away discomfited
  
On that day from bad to worse.
  
As I heard it, the truth can be told.
  
765] One of the best was Meiler;
  
In the battle that day
  
There was none better than he.
44. When the Irish saw this
  
Whom King Dermot brought
  
770] And who had earlier in the day
  
Fled in fear to the woods,
  
They returned speedily
  
To their lord, these men:
  
They joined in the combat
  
775] At the command of their lord.
  
You must not regard it as folly:
  
Eleven score of heads that day
  
Were brought to the king in the night,
  
On the **Barrow** where he lay,


---

p.61


780] Of his mortal enemies
  
Who were slain on the battle-field,
  
Besides the killed and wounded
  
Who were borne away from the field.
45. When these were discomfited
  
785] On the field they were left.
  
To Dermot, the rich king,
  
And to the English knights
  
Then spake a baron,
  
Robert the son of Stephen was his name:—
  
790] 'Hearken unto me, valiant king,
  
What I counsel with the will of God:
  
That to-night you remain in this place,
  
Since God has given you the grace
  
That you have, Sire, by the grace of God,
  
795] Discomfited your enemies.
  
As soon as day shall appear
  
We shall go to seek the traitor,
  
Nor shall I ever stop before
  
That we go pursuing him.'
46. 800] The king replies plainly
  
That this is not at all his pleasure:
  
'Rather we shall go to **Leighlin**
  
At our ease along the direct road;
  
Thus we shall carry our wounded
  
805] Who lie hurt on the battle-field.'
  
He turned to the city


---

p.63


Which was called **Leighlin**.
  
There they tarried for the night
  
To their great joy and pleasure:
  
810] By the **Barrow** they tarried
  
And lodged for the night.
47. On the morrow the rich king
  
Departed with his liege-men:
  
Towards **Ferns** they turned;
  
815] With them they carry their wounded.
  
When they came to the city,
  
Then they severally went their ways.
  
To their hostels to lodge
  
The knights returned.
  
820] They sent everywhere for physicians
  
To heal the sick:
  
To heal their wounded
  
They sent everywhere for physicians.
48. While the noble King Dermot
  
825] Abode in the city,
  
From all the country round about
  
His enemies cane to him
  
To crave mercy of the king
  
For having before completely betrayed him.
  
830] And through the dread they had
  
Of the English who were with him
  
They gave many hostages
  
To King Dermot, who was so bold.


---

p.65


And very many made peace
  
835] Through dread of the English.
  
The greater part of **Leinster**
  
Made peace in this manner,
  
Mac Donnchadh did not come in,
  
Who was king of **Ossory**;
  
840] Nor the traitor Mac Kelan,
  
Who was king of **Offelan**;
  
Nor Mac Torkil the traitor,
  
Who was lord of **Dublin**;
  
For they were in such dread of the king
  
845] That they did not dare to make peace.
  
Then the king speedily
  
Summoned his men front all sides;
  
Against Mac Kelan he wished to go
  
To shame and disgrace him.
  
850] Then the king summoned
  
The three noble barons
  
To come at once to speak to him,
  
Speedily, without delay.
  
Robert Maurice and Hervey
  
855] Promptly came to him.
  
The king then told them
  
And by word of mouth described to them
  
That he would go to **Offelan**
  
Against the traitor Mac Kelan,
  
860] And that they should equip themselves
  
To guard the person of the king.
  
They replied courteously:
  
'Sire, at your command.'


---

p.67

51. When they were ready
  
865] And had drawn up their men in ranks,
  
As King Dermot himself was unwilling
  
To separate from the English,
  
Donnell Kavanagh in close array
  
Led the van.
  
870] So much did they exert themselves
  
That they entered **Offelan**,
  
Plundered the whole country,
  
And defeated Mac Kelan;
  
The spoil they carried off,
  
875] And conquered and harried the people.
52. To **Ferns** then they turned
  
In pride and power:
  
Towards **Ferns** the king turned
  
With great pride and pomp.
  
880] At **Ferns** the noble king
  
Stayed for eight whole days,
  
And the brave English barons
  
Were all the time with the king.
53. When the eighth day was passed
  
885] Then the king summoned
  
His men throughout **Hy Kinsellagh**;
  
He wished to march to Glendalough,
  
He would plunder O'Toole
  
For having disdained to parley with him.


---

p.69


890] When the host was assembled,
  
Towards Glendalough they marched;
  
And the king commanded
  
Barons, knights and followers
  
That all should be ready
  
895] And equipped for battle.
  
Then they exclaimed:
  
'Noble king, march forward!
  
Avenge yourself, puissant king,
  
On your mortal enemies.
  
900] Noble king, march forward!
  
You shall be well avenged;
  
For never shall we fail you
  
So long as we shall live.'
54. Then King Dermot marches
  
905] Towards Glendalough as fast as he could.
  
When the king had come
  
With his friends and comrades,
  
Then he had the spoil taken
  
Without receiving or giving a blow.
  
910] He set about returning home,
  
Safe and sound, without hindrance;
  
And the English also
  
Returned quite safely.
  
The king returned home
  
915] With his men full of joy,
  
To **Ferns** came the barons
  
With all their companions.


---

p.71

57. At **Ferns** the king abode
  
As long as he pleased at that time.
  
920] His men he summoned from all sides
  
To come to **Ferns** to parley with him:
  
Rich and poor, in the same way,
  
All to come together.
  
The men of **Wexford** came
  
925] At the king's command.
  
At **Ferns** was the host assembled
  
With arms furnished and prepared.
  
Then the king summoned
  
Robert and Maurice, first of all,
  
930] Hervey and the baron Meiler,
  
And all the other knights.
  
The king took them into counsel:
  
'Hear, Sir knights,
  
Wherefore I summoned you here.
  
935] To **Ossory** I wish to go
  
To confound the rebel
  
Who has already done me high treason,
  
To protect my land from the traitor
  
That lie may never reign over *it*,
  
940] If I can*not* avenge myself on him
  
I shall have nothing but grief.'
  
Then the barons said to him:
  
'Sire, with God's blessing!'
58. Then the king summoned
  
945] Donnell Kavanagh, first of all—
  
That he should place himself at the head in the van
  
With five thousand fighting men,


---

p.73


And then immediately afterwards
  
These men of **Wexford**;
  
While the rich king himself
  
950] Remained with his English.
  
Through the midst of the land in this order
  
Marched the king of **Leinster**.
  
Into **Forth** he came
  
955] And descended to a river.
  
That night they took their hostels
  
Upon Mac Burtin up and down.
  
The men of **Wexford**, you must know,
  
Wrongfully hated the king.
  
960] Owing to their own treachery
  
Which they did of yore to their lord,
  
The traitors dreaded
  
The noble king night and day;
  
Wherefore they lodged by themselves
  
965] And night and day dreaded the king.
  
In this way the noble king,
  
Who was so gallant and courageous,
  
Lay by the river of Mac Burtin,
  
And all his host was there too.
59. 970] A Phantasm came upon them in the night,
  
Which each one took for true.
  
A vast and marvellous host
  
Through the midst of the huts suddenly
  
Came upon then, well armed
  
975] With hauberks and with banded bucklers.
  
Those in the huts then sallied forth


---

p.75


To defend themselves.
  
A knight of the English host,
  
Randolf Fitz Ralph I heard hint named—
  
980] That night to keep armed watch
  
Randolf the barn stood outside.
  
The knight began greatly
  
To wonder at this host;
  
They thought that they were betrayed
  
985] By their mortal enemies.
60. This man shouted loud and clear:—
  
'St. David! Barons, Knights!'
  
Then he drew his brand of steel.
  
First of all, one of his companions,
  
990] By a blow on the helmet,
  
By force, he brought him to his knees;
  
For he thought quite certainly
  
That he belonged to the other side.
  
Most of them thought
  
995] That they were the traitors
  
Of the city of **Wexford**,
  
Who were *really* far off.
  
This phantasm then departed,
  
As I tell you;
  
1000] It passed by the camp
  
To the men of **Wexford**.


---

p.77


These thought that they were being entrapped
  
By Dermot, the noble king.
  
But on the morrow they speedily
  
1005] Drew up their men in ranks,
  
By the rich king's command,
  
As they were the day before.
  
Against the king of **Ossory**
  
Went the king with great eagerness.
  
1010] Mac Donnchadh quietly
  
Summoned all his men
  
To the pass of **Achadh-ur**
  
To come without gainsaying.
  
A trench he then bade them throw up
  
1015] High and wide, steep and deep;
  
And then at the back strengthen it with stakes,
  
And in front with hurdles,
  
In order to dispute the passage
  
With King Dermot of the bold heart.
61. 1020] The king marched night and day
  
Until he came near to **Achadh-ur**.
  
By a river of great vehemence
  
The warriors encamped,
  
And the English of great worth
  
1025] Encamped round about.
  
On the morrow they crossed the river
  
Without a battle and without a contest:
  
On the morrow they cross, beyond a doubt,
  
Without a contest and without a battle.


---

p.79

64. 1030] These men of **Wexford**
  
Commenced the attack:
  
They began to attack the stockade.
  
For three whole days, i' faith,
  
Somewhat half-heartedly these men
  
1035] Attacked the traitors.
  
The stockade could not be carried
  
By their attack in any way,
  
Until the English men
  
On the third day, as I hear,
  
1040] Carried the stockade against them
  
And put these men to flight.
  
They fled as far as **Tubbrid**
  
Through the midst of the territory of **Wenenath**,
  
And from thence as far as 'Bertun'
  
1045] Fled the rebel king.
  
But Dermot, the puissant king,
  
Went so far following the traitor—
  
So far did he pursue the traitor
  
That he sent him on this wandering,
  
1050] Since he could not make a stand
  
Against King Dermot.
  
Then Dermot, the renowned king,
  
Laid waste the rebel's land,
  
And carried off a great spoil with him
  
1055] To the city of **Ferns**.


---

p.81

67. Dermot, the potent king,
  
Had subdued his country,
  
Had defeated and discomfited
  
Most of his enemies;
  
1060] Through the English he was exalted
  
With great pride and haughtiness.
  
By the advice of his people
  
He wished to retain, as I hear,
  
The soldiers of Maurice, the baron,
  
1065] According to the geste that we are reading.
68. This man departed from King Dermot;
  
Full two hundred he brought away with him:
  
Of the English, in truth,
  
Maurice brought away full two hundred.
  
1070] Towards **Wexford** he set out,
  
He wished to cross the sea to **Wales**.
  
Then the king sent word
  
To **Wexford** by messenger:
  
All the master mariners
  
1075] He made obstruct Maurice
  
So that he could not cross the sea
  
Nor return to his own country.
69. When Maurice learnt the news,
  
He was in great trouble.
  
1080] He feared at this time
  
That the traitors of **Wexford**
  
Would fall upon him


---

p.83


By the counsel of the king, wrongfully.
  
But Maurice speedily
  
1085] So parleyed with these men
  
Of **Wexford** city
  
That they turned against the king.
  
Maurice did not delay at all:
  
He sent word to the king of **Ossory**
  
1090] That he would come to him, without deceit,
  
To serve him, if he wished it;
  
For he had parted on bad terms
  
From King Dermot whom he had served.
  
When MacDonnchadh heard
  
1095] That Maurice would come to him,
  
He was rejoiced at the news
  
And leaped to his feet with joy.
  
To the baron he straightway sent word
  
That he should certainly come to him;
  
1100] Pay he would give him
  
Very rich and ample.
  
Then the baron departed,
  
He and all his companions;
  
Towards the town of **Timolin**
  
1105] They took the direct road.
  
But King Dermot's son,
  
Donnell Kavanagh, to the best of his power,
  
Attacked the baron on that day
  
With full five hundred companions.
  
1110] A great conflict they had
  
Maurice's men on that day;


---

p.85


But by force and by valour
  
They came to **Timolin**.
  
For three days accordingly
  
1115] Maurice abode there with his followers.
  
Often did the king of **Ossory**
  
Send a message to these men
  
That he would come on the third day
  
Without any further gainsaying.
  
1120] The king came there, of a truth,
  
The third day without delay:
  
Thither came the king of **Ossory**,
  
Mac Donnchadh, with his company;
  
And thereupon the king
  
1125] Assumed a friendly manner towards Maurice.
  
Maurice and all his men
  
Saluted the king courteously.
  
The king and his chief men
  
Made oath to the English:
  
1130] To the English they swore, in short,
  
On altar and on shrine,
  
That they would never betray them
  
As long as they should be with them.
70. Donnchadh accordingly brought away
  
1135] Maurice and all his followers:
  
Into **Ossory** the king brought
  
Maurice and his company;
  
While Robert remained with Dermot
  
With as many men as he had,
  
1140] And Hervey just in the same way
  
With his force and his men.


---

p.87

73. Mac Donnchadh day and night
  
Harried Dermot's territory:
  
With the aid of Maurice and his followers
  
1145] He then laid waste the territory of the king.
  
There the baron received
  
The name of Maurice of **Ossory**:
  
Thus the Irish of this country
  
Always called him,
  
1150] In that he had come to **Ossory**
  
And remained with the king.
74. About Maurice I shall here stop;
  
About a baron I wish to tell,
  
The son of Gerald: Maurice was his name.
  
1155] The baron had landed:
  
He landed at **Wexford**
  
With a goodly force and many followers;
  
In order to aid King Dermot
  
He had landed at **Wexford**.
75. 1160] Then the baron sent word
  
To the king that he had landed.
  
Dermot heard the news,
  
For a long time none so good had come to him.
  
The king, with prick of spur,
  
1165] To meet the baron
  
Set out straight to the harbour,
  
To the coast of **Wexford**.


---

p.89


When the rich king saw him,
  
He straightway said to him:—
  
'Be very welcome, baron,
  
1170] Son of Gerald, Maurice by name.'
  
The latter then replies:—
  
'God bless you, valiant king!'
  
To **Ferns** they depart joyfully
  
1175] The king and Maurice as well.
76. Now the king of **Ossory**
  
At this time had gone to **Leix**
  
Against the lord of that territory
  
To prevent his making war on him.
  
1180] O'More was the name of the lord
  
Who held **Leix** at that day.
  
Mac Donnchadh with his English
  
Was about to harry all **Leix**,
  
When O'More, its lord,
  
1185] With Mac Donnchadh fixed a day:
  
A day he fixed for him there,
  
He would give hostages of his country.
  
Not more than three or four days
  
Would be delay the king there.
  
1190] He would give five or six hostages
  
The noblest of his territory.
  
The king granted this to him,
  
And abode there for three days.


---

p.91


O'More speedily sent word
  
1195] To King Dermot that these men
  
By force and by war
  
Had entered into his territory,
  
And that he should come there promptly
  
To give him speedy succour.
77. 1200] Dermot, king of **Leinster**,
  
To Robert and to Fitz Gerald
  
All that O'More had announced
  
Told to the two barons;
  
And they then said to the king:—
  
1205] 'Speedily and without any respite
  
Get your men equipped.
  
There is reason, Sire, for no delay.'
  
The king then had it proclaimed aloud
  
That all who could bear arms
  
1210] Should follow him at once.
  
The king then mounts horse.
  
The three barons likewise
  
Followed the king with their men,
  
Nor did they stop from there to **Leix**,
  
1215] Where the king of **Ossory** was.
  
Now the king of **Ossory**
  
Lay in a flowery moor,
  
While King Dermot
  
Came against him, and the son of Gerald;
  
1220] But he knew not, of a truth,


---

p.93


That men were coming against him.
  
So while the King Mac Donnchadh
  
And Maurice of **Ossory**
  
Lay in a moor
  
1225] Which was very beautiful and extensive,
  
Maurice de Prendergast, at length,
  
Thought one morning
  
That O'More, the lord of **Leix**,
  
Was going to betray King Mac Donnchadh,
  
1230] If he could in any way
  
Obtain a force out of **Leinster**.
78. Then lo! there comes a scout
  
To the king of **Ossory**;
  
He told him that King Dermot
  
1235] With as large a force as he could
  
Was bringing the son of Stephen with him
  
And Maurice the son of Gerald,
  
And that full three hundred English
  
Had come with him to **Leix**,
  
1240] Besides all the other men
  
Who came by tenure.
  
Then commenced to speak
  
Maurice de Prendergast first:—
  
'Let us go, lord king.
  
1245] Too many Englishmen follow us,
  
And we have only a few men;
  
Wherefore let us go in close array.
  
If they approach us at all,
  
Well shall we be able to defend ourselves.'


---

p.95

81. 1250] Then the king went away
  
From the territory of O'More of **Leix**
  
By the advice of his friend
  
Maurice, of whom you have heard.
82. Speedily King Dermot,
  
1255] To whom **Leinster** belongs,
  
Together with Robert and Maurice
  
Followed then these men;
  
But they did not come up with them;
  
For they had crossed the pass,
  
1260] Mac Donnchadh of **Ossory**
  
And Maurice in whom he trusts.
  
Then Dermot, the puissant king,
  
To **Ferns** went in all haste:
  
To **Ferns** he returned;
  
1265] Hostages he brought with him:
  
Hostages he brought at this time
  
From O'More the lord of **Leix**.
83. Mac Donnchadh with his company
  
Returned to **Ossory**.
  
1270] Then they separated
  
Safe and sound in their country.
  
And the men of **Ossory**
  
Were much discontented
  
That they had to hire soldiers
  
1275] And to give their pay to the English.
  
The traitors accordingly began to plot,
  
One behind, another in front;


---

p.97


They resolve to betray Maurice
  
And to part his treasure among them:
  
1280] For their gold and silver
  
They resolved to murder these men.
  
Thus they had plotted
  
Treachery all in secret.
84. Accordingly they came before the king,
  
1285] Young and old, bald and hairy:
  
'Hear us, king, good lord!
  
Maurice we wish, at length, to put to death;
  
We have a sufficiently good peace;
  
Of them we have no further need.'
  
1290] And the king replied:—
  
'Please God and his might
  
That they may never be betrayed by me,
  
Murdered, killed, disgraced, or taken!'
85. To the king came the baron,
  
1295] Knowing nothing of the treachery
  
Then indeed he demanded
  
Of the king free licence
  
That he might return home to his country.
  
The king, be sure, with much regret
  
1300] Gave leave to the knight
  
To return to his country;
  
But the king besought him much


---

p.99


To remain with him still.
  
Maurice replied to the king:—
  
1305] 'The English wish to cross over:
  
They wish to cross the high sea
  
To visit their friends.'
  
Then the king departed,
  
According to the geste which you now hear;
  
1310] To **Fertakerach** he went, I think,
  
While the English at **Kilkenny**
  
Remained that night
  
With great joy and in great commotion;
  
While all the wicked traitors
  
1315] Of that territory round about
  
Went to plash the passes
  
Through which they had to pass.
  
But as God willed it
  
That Maurice should be forewarned
  
1320] Of the great crime
  
That these men of **Ossory** did,
  
The baron caused to be summoned
  
All his companions to him.
86. When they were assembled,
  
And Maurice told them
  
How the men of **Ossory**
  
By their great treachery
  
Had contrived an ambuscade for them
  
With two thousand men well armed:
  
1330] How the Irish are in front of them


---

p.101


With two thousand fighting men
  
'In a strong place in order to obstruct us
  
That we cannot pass that way.
  
Take counsel, Sir barons,
  
1335] Concerning this affair how we shall act.'
  
They all replied:—
  
'Let the counsel rest with you.'
  
To their hostels they returned
  
Where they were before lodged.
  
1340] Very quietly they kept themselves,
  
As though they knew nothing about it.
  
Then Maurice of **Ossory**
  
To the Seneschal of Mac Donnchadh—
  
To the Seneschal sent word
  
1345] That for half a year or a quarter
  
He was willing to remain with the king,
  
As they had previously been.
  
Speedily the king sent word
  
That he would come to parley with the English.
  
1350] When was spread and published
  
The news throughout the country,
  
That Maurice had remained
  
With the king of that country,
  
The traitors returned home
  
1355] From the pass where they were in ambush.
87. In the night when they were asleep
  
Maurice then sent word
  
By a private page
  
That all the barons should take horse,


---

p.103


1360] Archers, squires, and sergeants,
  
Both small and great.
  
Those who wished to cross over
  
Soon equipped themselves:
  
They got themselves ready
  
1365] Nor would they delay any longer.
  
Towards the sea they turned
  
To cross to their own countries.
  
To the city of **Waterford**,
  
As fate led them,
  
1370] The knights came
  
Safe and sound and none missing.
  
There the barons stayed
  
With all their companions.
  
But there they were hindered
  
1375] Through a man who was wounded:—
  
For a foot-soldier
  
Had wounded a citizen,
  
Who afterwards died of the wound.
  
Nor did they consider it as sport
  
1380] The citizens of the city
  
Of **Waterford**, as I have mentioned.
  
There they were arrested
  
All the illustrious barons;
  
But by the counsel of their lord
  
1385] Maurice, who was their pleader,
  
And by his good sense and tact,
  
Maurice enabled them all to cross over.
  
In **Wales** they all landed
  
Safe and sound, joyous and glad.


---

p.105


1390] About these men we shall here leave off,
  
About King Dermot we shall tell you.
88. I wish to tell of King Dermot
  
How he delivered **Wexford**
  
To a noble baron,
  
1395] The son of Stephen, Robert the baron.
  
And Maurice the son of Gerald
  
Fortified himself at Carrick,
  
By the permission and by the desire
  
Of Dermot, the potent king.
  
1400] Then soon afterwards
  
Earl Richard sent over
  
Some of his men to **Ireland**,
  
With nine or ten of his barons.
  
The first was Raymond le Gros,
  
1405] A bold and daring knight.
  
At **Dundonuil** they landed
  
Where they then constructed a fort
  
By the permission of the rich king
  
Dermot, who was so courteous.
  
1410] There Raymond le Gros remained
  
With his knights and barons.
  
Then he plundered the territory,
  
Took and killed the cows.
  
But the men of **Waterford**
  
1415] And of **Ossory** likewise
  
Assembled their hosts;


---

p.107


Against **Dundonuil** they resolved to go
  
In order to attack the fort.
  
They think surely to shame the English.
  
1420] Donnell O'Phelan of the **Decies**,
  
And O'Ryan of **Odrone**,
  
And all the Irish of the country
  
Surrounded the fort.
  
By estimation the Irish were
  
1425] As many as three or four thousand;
  
Raymond and his men
  
Were not more than a hundred.
  
They drove the cows into the fort
  
By the counsel of Raymond.
  
1430] The men of **Waterford**
  
Came very fiercely
  
To demolish the fort;
  
They think to disgrace the English.
89. Raymond speaks to his men:—
  
1435] 'Sir barons, hearken to me.
  
You see your enemies coming
  
Who have resolved to attack you.
  
It is more honourable for you here
  
Than within to be killed or taken.
  
1440] Come now, do you all arm yourselves,
  
Knights, sergeants, and archers;
  
Thus shall we place ourselves in open field
  
In the name of the Almighty Father.'
  
The knights and the barons,


---

p.109


1445] By the advice of Raymond le Gros,
  
Resolved to sally from the gates
  
In order to charge the Irish.
  
The cows were scared
  
At the men who were armed;
  
1450] And owing to the tumult that they made
  
The cows all in front
  
By force and by strength
  
Sallied forth at the gate.
  
This was the first company
  
1455] That sallied from the fort, I trow.
  
Upon the Irish they rushed
  
In a short space, in a few moments.
  
The Irish could not stand against them:
  
They were forced to separate;
  
1460] And Raymond with his English
  
Threw himself amid the Irish.
  
Wherefore they were divided,
  
The Irish were discomfited,
  
So that the last company
  
1465] Fled away through this fright.
  
There they were discomfited
  
All the Irish of this district.
  
On the field a thousand were left
  
Vanquished, killed, wounded, or taken.
  
1470] By the force and by the strength
  
That the good Jesus created against them
  
And through dread and through fear
  
They were enfeebled that day.


---

p.111


Of the Irish there were taken
  
1475] Quite as many as seventy.
  
But the noble knights
  
Had them beheaded.
  
To a wench they gave
  
An axe of tempered steel,
  
1480] And she beheaded them all
  
And then threw their bodies over the cliff,
  
Because she had that day
  
Lost her lover in the combat.
  
1485] Alice of Abervenny was her name
  
Who served the Irish thus.
  
In order to disgrace the Irish
  
The knights did this.
  
And the Irish of the district
  
1490] Were discomfited in this way.
  
To their country they returned
  
Outdone and discomfited:
  
To their country they returned
  
Discomfited and outdone.
90. At **Dundonuil** remained Raymond
  
1495] He and all his companions,
  
And Hervey de Mont Maurice
  
And Walter Bluet likewise.
  
They kept very much to themselves,
  
As against these lrishmen.


---

p.113

93. 1500] According to the statement of the old people,
  
Very soon afterwards Earl Richard
  
Landed at **Waterford**.
  
Full fifteen hundred men he brought with him.
  
On the eve of St. Bartholomew
  
1505] Did the earl land.
  
The most powerful persons in the city
  
Were called Ragnald and Sidroc.
  
On St. Bartholomew's day,
  
Earl Richard, the prudent,
  
1510] Took by assault and won
  
The city of **Waterford**.
  
But there were many killed there
  
Of the citizens of **Waterford**
  
Before that it was won
  
1515] Or taken by assault against them.
94. When the earl by his power
  
Had taken the city,
  
The earl immediately sent word
  
To King Dermot by messenger
  
1520] That he had come to **Waterford**
  
And had won the city,
  
That the rich king should come to him
  
And should bring his English.
  
King Dermot speedily
  
1525] Came there, be sure, right royally.
  
The king in his company
  
Brought there many of his barons,
  
And his daughter he brought there;


---

p.115


To the noble earl he gave her.
  
1530] The earl honourably
  
Wedded her in the presence of the people.
  
King Dermot then gave
  
To the earl, who was so renowned—
  
**Leinster** he gave to him
  
1535] With his daughter, whom he so much loved,
  
Provided only that he should have the lordship
  
Of **Leinster** during his life.
  
And the earl granted
  
To the king all his desire.
  
1540] Then they turned aside
  
The king and Earl Richard.
  
Raymond le Gros joined them.
  
A bold and daring knight,
  
And Maurice de Prendergast
  
1545] Likewise, as I hear;
  
For with the earl, of a truth,
  
He had returned, as people say.
  
By the advice of the earl
  
The warrior had returned.
  
1550] At this council in sooth
  
Was Meiler the son of Henry,
  
And many a brave knight
  
Whose names I cannot mention.
  
There all the brave knights
  
1555] Proceeded to advise
  
That they should go straight to **Dublin**
  
And should assault the city.
  
Then the king departed


---

p.117


Towards **Ferns** with his English.
  
1560] He caused his men to be summoned
  
Everywhere and in great force.
  
When they were all assembled,
  
Towards **Waterford** they set out directly.
  
Earl Richard then gave
  
1565] The city in charge of his men:
  
In **Waterford** he then left
  
A portion of his followers.
  
Then they turned towards **Dublin**
  
The king and the renowned earl.
95. 1570] Now all the pride of **Ireland**
  
Was at **Clondalkin** in a moor,
  
And the king of **Connaught**
  
Was at **Clondalkin** at this time.
  
In order to attack the English
  
1575] He divided his troops.
  
They plashed the passes everywhere
  
In order to obstruct the English,
  
So that in fact they should not come
  
To **Dublin** without hostility.
  
1580] And king Dermot was warned
  
By a scout whom he had sent
  
That the Irish were in front
  
About 30,000 strong.
  
King Dermot sent to ask
  
1585] The earl to come to parley with him.
  
The earl speedily
  
Came promptly to the king.


---

p.119

98. 'Sir Earl,' thus spake the king,
  
'Hearken to me at this time:
  
1590] Draw up your men in ranks
  
And marshal your sergeants.
  
We shall now go by the mountain
  
On the hard field and on the open ground;
  
For the woods are plashed
  
1595] And the roads trenched across,
  
And all our enemies of **Ireland**
  
Are before us in a moor.'
99. The earl then summoned
  
All the brave knights.
  
1600] Miles came to him, first of all,
  
A noble and brave warrior:
  
Miles had the name de Cogan
  
And his body was bold and burly.
  
He was at the head in front
  
1605] With seven hundred English soldiers;
  
And Donnell Kavanagh likewise
  
Remained with these men.
  
And then afterwards Raymond le Gros
  
With about eight hundred companions.
  
1610] In the third company the rich king
  
With about a thousand Irish.
  
And Richard, the courteous earl,
  
Had with him three thousand English.
  
In this company there were about
  
1615] Four thousand vassals, I trow.


---

p.121


In the rear-guard the king
  
Had the Irish drawn up in ranks.
  
They were all well armed,
  
The renowned English barons.
  
1620] By the mountain did the king
  
Guide the English host that day.
  
Without a battle and without a contest
  
They arrived at the city.
  
Moreover the city was that day
  
1625] Taken beyond gainsaying:
  
The day of St. Matthew the Apostle
  
The city of **Dublin** was burning.
100. When the Irish saw this
  
That King Dermot was come
  
1630] And the earl also
  
With all his English troops,
  
And that the illustrious liege barons
  
Had surrounded the city,
  
The king of **Connaught** went away
  
1635] Without a word at this time,
  
And the Irish from this district
  
To their country departed.
  
Hasculf MacTorkil, the deceiver,
  
Remained in the city that day,
  
1640] In order to defend the city
  
Of which he was acknowledged
  
Sire, lord, and defender,
  
Through all the country.


---

p.123


Outside the walls of the city
  
1645] Was the king encamped;
  
While Richard, the good earl,
  
Who was lord of the English,
  
Remained with his English
  
And with King Dermot himself.
  
1650] Nearest to the city
  
Was Miles encamped,
  
The good Miles de Cogan
  
Who was afterwards lord of **Mount Brandon**,
  
Which is the wildest spot,
  
1655] Mountain or plain, in the world.
  
Now Dermot, the noble king,
  
Despatched Morice Regan,
  
And by Morice proclaimed
  
To the citizens of the city
  
1660] That without delay, without any respite,
  
They should surrender without gainsaying:
  
Without any further gainsaying
  
They should surrender themselves to their lord.
  
Thirty hostages demanded
  
1665] King Dermot of the city.
  
But those within, i'faith,
  
Could not separate among themselves
  
The hostages of the city
  
Who should be delivered to the king.
  
1670] Hasculf accordingly made answer
  
To Dermot, the renowned king,
  
That on the morrow speedily
  
He would perform all his command.


---

p.125

103. It greatly vexed the baron,
  
1675] The good Miles de Cogan,
  
That the parley lasted so long
  
Between the king and all his people.
  
Miles shouted all at once
  
'Barons, knights, A Cogan!'
  
1680] Without the king's command
  
And without the earl's either,
  
He attacked the city.
  
The baron Miles with his followers
  
With audacity and with great fury
  
1685] Then set upon the city.
  
The baron Miles, the renowned,
  
By main force took the city.
  
Before that Dermot knew it that day
  
Or Richard the good earl,
  
1690] Had Miles, the strong-limbed baron,
  
Actually entered into **Dublin**,
  
Had already conquered the city,
  
And put MacTorkil to flight.
  
And the men of **Dublin**
  
1695] Fled away by the sea;
  
But many remained there
  
Who were killed in the city.
  
Much renown acquired that day
  
Miles who was of such worth;
  
1700] And the renowned barons
  
Found much wealth:
  
In the city they found


---

p.127


Much treasure and other wealth.
  
Thereupon there came
  
1705] The king and the earl riding quickly:
  
To the city they came
  
The king and the earl together.
  
And Miles, the renowned baron,
  
To the earl gave up the city:
  
1710] The city Miles gave up,
  
And the earl thereupon received it.
  
Much provision they found
  
And good victuals in great plenty.
  
The earl then abode
  
1715] While he pleased in the city;
  
And the king returned
  
To **Ferns** in his own country.
  
But on the festival of St. Remy,
  
When August was over,
  
1720] Soon after Michaelmas,
  
Richard, the noble earl,
  
To Miles delivered, you must know,
  
The wardship of the city.
  
To **Waterford** he set out
  
1725] The earl and his ample suite.
  
There the earl abode
  
So long as it pleased him.
  
At **Ferns** then tarried
  
King Dermot during this winter.
  
1730] The king, who was so noble,
  
Lies buried at **Ferns**.


---

p.129

106. All the Irish of the country
  
1735] Revolted against the earl.
  
Of the Irish at this time
  
There remained with him only three:
  
Donnell Kavanagh, in the first place,
  
Who was brother to his wife,
  
1740] O'Reilly of **Tirbrun**,
  
And thirdly Auliffe O'Garvy;
  
While the Irish of **Hy Kinsellagh**,
  
Who were with King Murtough,
  
They then stirred up a great war
  
1745] Against the earl of **Leinster**.
  
And the rich king of **Connaught**
  
Summoned to him
  
The Irish of all **Ireland**
  
In order to lay siege to **Dublin**.
  
1750] They came on the day
  
That their lord had appointed for them.
  
When they were assembled
  
They were sixty thousand strong.
  
At **Castleknock**, at this time,
  
1755] Was the rich king of **Connaught**;
  
And MacDunlevy of **Ulster**
  
Planted his standard at **Clontarf**;
  
And O'Brien of **Munster**
  
Was at **Kilmainham** with his brave men;


---

p.131


1760] And Murtough, as I hear,
  
Was near **Dalkey** with his men.
107. The earl, you must know, at this time
  
Was within the city, of a truth.
  
The son of Stephen promptly sent
  
1765] Some of his men to the earl:
  
In order to aid and succour him
  
He sent men to him at this crisis.
108. When Robert had sent
  
About thirty-six of his men
  
1770] To aid the earl Richard,
  
Who was *the subject of such anxiety*,
  
The traitors without any delay
  
Fell upon Robert.
  
In the town of **Wexford**
  
1775] They wrongfully slew his men:
  
His men they utterly betrayed,
  
Killed, cut to pieces, and brought to shame.
  
Within a castle on the **Slaney**,
  
According to what the geste here tells,
  
1780] The traitors took Robert
  
And put him in prison at **Begerin**:
  
Five knights, in short,
  
They imprisoned in **Begerin**.
  
And there came Donnell Kavanagh
  
1785] And the Irish of **Hy Kinsellagh**:
  
To **Dublin** he came


---

p.133


To the noble earl at this juncture.
  
With him came O'Reilly,
  
And Auliffe also.
  
1790] To the earl they told all,
  
How Robert was imprisoned,
  
And how his men were slain,
  
Discomfited, and treacherously killed.
  
The earl thereupon replies:—
  
1795] 'Donnell, let it not appear,
  
Let it not appear, my friend,
  
That our men are brought to shame.'
109. The earl then summoned
  
The the lord councillors
  
1800] To come to him at once to advise
  
Speedily, without delaying.
  
There came Robert de Quency,
  
  
[*gap: lacuna in MS/extent: 1-2 lines*]  

  
And Walter de Riddlesford came,
  
A brave and noble warrior;
  
1805] Maurice de Prendergast also
  
Came, as I hear;
  
And there came the good Miles,
  
Under heaven there was no better baron;
  
And Meiler the son of Henry,
  
1810] And Miles the son of David,
  
And Richard de Marreis came there,
  
Noble and courteous knights;
  
And Walter Bluet came there;


---

p.135


Knights barons as many as twenty:
  
1815] All the barons of great worth
  
Came to their lord.
  
When the renowned barons
  
Were assembled in council,
  
The earl sought counsel
  
1820] Of all his kinsfolk and friends.
110. 'My lords,' thus spake the valiant earl,
  
'May God of Heaven protect us!
  
You see, my lords, your enemies
  
Who have now besieged you here.
  
1825] We shall have hardly anything to eat
  
Before the fortnight is out:
  
(For the measure of corn
  
Was sold for a silver mark,
  
And for a measure of barley
  
1830] One got at that time half a mark:)
  
Wherefore, Sir Knights,
  
Let us send a message to the king.'
  
Then the renowned earl
  
Sent a message to the king
  
1835] That he would become his man
  
And would hold **Leinster** of him.
111. 'Come now, free-born lords,
  
To the king of **Connaught** two vassals
  
By your counsel we shall despatch,
  
1840] And we shall send the archbishop,


---

p.137


That I shall be willing to do fealty to him,
  
And will hold **Leinster** of him.'
  
An archbishop they sent,
  
Who was afterwards called St. Laurence.
  
1845] The archbishop they then sent
  
And Maurice de Prendergast with him.
  
To the king they accordingly announced
  
The message of the earl.
112. Thereupon the king said to them
  
1850] Without taking time or respite:
  
He answered to the messenger
  
That he would by no means do this;
  
No more than **Waterford**
  
**Dublin** and **Wexford** alone
  
1855] Would he leave to Earl Richard
  
Of all **Ireland** as his share;
  
Not a whit more would he give
  
To the earl or to his followers.
  
The messengers turned back
  
1860] To the city of **Dublin**:
  
The messengers returned
  
Speedily without delaying.
  
Aloud they tell their message
  
In the hearing of all the barons:
  
1865] To the earl they told completely
  
The reply of the haughty king:—
  
That he would not give him more land
  
In the whole of **Leinster**,


---

p.139


Except only the three cities
  
1870] Which I have already named to you;
  
And if this did not meet his pleasure
  
They would attack the city;
  
If he would not accept this offer
  
The king would hear no more,
  
1875] For on the morrow, so said the king,
  
The English would be attacked.
113. When the earl had heard
  
What the archbishop related,
  
Then the earl caused to be summoned
  
1880] Miles de Cogan the light of limb:
  
'Make all your men arm, barons,
  
Sally forth in the foremost van;
  
In the name of the Almighty Father
  
In the foremost van sally forth.'
  
1885] About forty horsemen
  
Are with Miles before in the front,
  
Sixty archers and one hundred sergeants
  
Had Miles under his orders.
  
And then next, Raymond le Gros
  
1890] With forty companions,
  
And he had one hundred fighting-men
  
And three-score archers.
  
And then next, the good earl
  
With forty fighting-men
  
1895] With one hundred hardy sergeants
  
And three-score archers.
  
Very well armed they were


---

p.141


Horsemen, sergeants, and hired soldiers.
  
When the earl had sallied forth
  
1900] With his friends and his comrades,
  
Miles placed himself at the head in the van
  
With two hundred fighting vassals;
  
And then next Raymond le Gros
  
With about two hundred companions;
  
1905] In the third company the noble earl
  
With two hundred hardy vassals.
  
Donnell Kavanagh, of a truth,
  
Auliffe O'Garvy likewise,
  
And O'Reilly of **Tirbrun**,
  
1910] Of whom you have already heard,
  
Were in the van with Miles,
  
As the Song tells us.
  
But the Irish of the district
  
Knew nought of this affair:
  
1915] Of the barons thus armed,
  
And equipped for battle.
114. Miles de Cogan very quickly
  
By the direct road towards **Finglas**
  
Towards their stockades thereupon
  
1920] Set out at a rapid pace.
  
When Miles had drawn near
  
To where the Irish were encamped,
  
'A Cogan!' he shouted aloud,
  
'Strike, in the name of the Cross!
  
1925] Strike, barons, nor delay at all,


---

p.143


In the name of Jesus the son of Mary!
  
Strike, noble knights,
  
At your mortal enemies!'
  
The renowned liege barons
  
1930] At their huts and cabins
  
Attacked the Irish
  
And fell upon their tents;
  
And the Irish unarmed
  
Fled through the moors:
  
1935] Throughout the country they fled away
  
Like scattered cattle.
115. Raymond le Gros also
  
Oft invoked St. David,
  
And went pursuing the Irish
  
1940] To work his will upon them;
  
And Richard the good earl
  
Did so well that day,
  
So well did the earl do,
  
That all were astonished;
  
1945] And Meiler the son of Henry,
  
Who was of such renown,
  
Bore himself so bravely
  
That men wondered.
  
A hundred and more were slain
  
1950] While bathing where they were beset,
  
And more than one thousand five hundred
  
Of these men were slain,
  
While of the English there was wounded
  
Only one foot-sergeant.


---

p.145


1955] The field remained that day
  
With Richard, the good earl,
  
And the Irish departed
  
Discomfited and outdone:
  
As God willed, at that time,
  
1960] The field remained with our English.
  
So much provision did they find,
  
Corn, meal, and bacon,
  
That for a year in the city
  
They had victuals in abundance,
  
1965] To the city with his men
  
The earl went very joyfully.
116. Earl Richard, light of limb,
  
Makes preparations for his journey.
  
To **Wexford** he resolved to go
  
1970] To set free the baron.
  
The baron the son of Stephen
  
The traitors hold in prison:
  
The traitors of **Wexford** hold him, in short,
  
Imprisoned in **Begerin**.
  
1975] The wardship of **Dublin** he gave
  
To the good Miles the warrior.
  
Then the earl proceeded
  
Towards **Wexford** night and day.
  
So much did the earl accomplish


---

p.147


1980] By his day's marches, and so far go,
  
For so many nights and so many days
  
That he tame to **Odrone**.
  
Now the Irish of the district
  
Were assembled at the pass:
  
1985] To meet the earl Richard
  
At one side they were assembled:
  
To attack the English
  
Were the Irish assembled.
  
The earl Richard with his men
  
1990] Through the midst of the pass in safety
  
Thought surely to advance,
  
When an obstacle met him.
  
The rebel king of **Odrone**,
  
O'Ryan was his name,
  
1995] Shouted out loudly:
  
'To your destruction, Englishmen, have you come!'
  
He rallied his men to him,
  
And attacked the English sharply;
  
And the English, of a truth,
  
2000] Manfully defended themselves.
  
But Meiler, the son of Henry
  
Carried the prize that day:
  
In the battle, knew in sooth,
  
There was no better than the son of Henry.
  
2005] And much renowned that day
  
Was Nichol, a cowled monk;
  
For with an arrow he slew that day
  
The lord of **Odrone**:
  
By an arrow, as I tell you,
  
2010] Was O'Ryan slain that day.


---

p.149


And Meiler, the strong-limbed baron,
  
Was stunned by a blow
  
Of a stone in this fight,
  
So that he reeled to the ground.
  
2015] But when O'Ryan was slain
  
The Irish separated.
  
This wood was afterwards named
  
And called the earl's pass,
  
Because the earl was attacked there
  
2020] By his enemies.
117. Thence the earl turned
  
Towards **Wexford** city
  
To liberate the imprisoned Robert,
  
Of whom I have before told you.
  
2025] But the perfidious traitors
  
Would not deliver him up to the earl.
  
To **Begerin** they fled
  
And **Wexford** they set on fire.
  
For the sea ran entirely
  
2030] All around Begerin;
  
Werefore the noble earl,
  
Could not, i' faith, get at them.
118. Then the earl set out
  
Towards **Waterford** with his followers.
  
2035] To the king of **Limerick** he sent word
  
By his sealed letters


---

p.151


That he should come to **Ossory**
  
With all his baronage
  
Against MacDonnchadh the king
  
2040] Who held sway in **Ossory**.
  
For the king of **Limerick** had
  
A daughter of the rich king Dermot;
  
A daughter of Dermot on the other hand
  
Earl Richard had to wife;
  
2045] So that they had to wife two sisters
  
King O'Brien and the earl.
  
He came in great force
  
Into **Ossory** with his men.
  
Earl Richard, the good earl,
  
2050] Went to meet O'Brien that day
  
To Idough with his brave men,
  
To meet the king of **Munster**,
  
Where there were about two thousand men
  
Of the noble earl and King O'Brien.
  
2055] MacDonnchadh sent a messenger
  
To the earl to tell him
  
That he would of his own accord come
  
To the earl, to whom he would redress
  
The outrage and the wrong
  
2060] With which the barons had upraided him.
  
To the earl he would come, in short, to parley,
  
On condition that he could freely return,
  
Provided that Maurice the baron
  
Of Prendergast, as we tell in our song,
  
2065] Should take him by the hand upon his faith.


---

p.153


To safe-conduct the rich king,
  
And Maurice at once
  
To the earl speedily
  
Went; the noble baron
  
2070] Obtained from the earl peace for the king.
  
The earl replied to him:—
  
'Maurice, you do wrong to fear;
  
Make the king come to me;
  
When it shall please him he can depart.'
  
2075] And Maurice, as I trow,
  
From each baron individually
  
Exacted an oath
  
That he might bring him securely,
  
And that in safety he could depart
  
2080] Whenever it should please him.
  
And Maurice, the vassal,
  
Then mounted his horse,
  
And straightway departed
  
To meet the king with all speed.
  
2085] To the court he then brought him
  
Before the earl in safety.
119. The earl then accused him—
  
As did all the renowned barons,—
  
MacDonnchadh of **Ossory**,
  
2090] Of his great treachery:
  
In what manner he had betrayed
  
The good Dermot, the noble king.
  
King O'Brien counsels
  
The noble earl, the warrior,


---

p.155


2095] That he should have the traitor seized
  
And should have him consigned to infamy;
  
And the barons, i'faith,
  
Were all willing to consent thereto.
  
And King O'Brien of **Munster**
  
2100] Sent his men through the land:
  
Made his men go everywhere
  
To plunder the land,
  
While MacDonnchadh was
  
Before the earl and was pleading.
120. 2105] When Maurice, the baron,
  
Was warned of this treachery,
  
He sent word to his men everywhere
  
That they should arm themselves quickly.
  
Then Maurice exclaimed:
  
2110] 'Barons, what are you meditating?
  
Ye have broken your oaths,
  
Towards me ye are forsworn.'
  
To his followers Maurice said:
  
'To horse, illustrious cavaliers!'
  
2115] Maurice by his sword sware
  
That there was no vassal so bold
  
As on the king that day
  
Should lay a hand to his dishonour
  
But, right or wrong,
  
2120] Should have his head struck in two.
  
And Richard, the valiant earl,
  
To the baron Maurice thereupon


---

p.157


Gave up MacDonnchadh,
  
And delivered him by the hand.
  
2125] Then the baron mounts horse,
  
He and all his companions;
  
The king they brought at length
  
To the woods in safety.
  
They met O'Brien's men
  
2130] Who had spoiled the land,
  
And Maurice then slew
  
Nine or ten of these men;
  
And by force and by valour
  
From his lord's court
  
2135] Did Maurice and his followers
  
Bring the king to the wood that day.
  
And Maurice de Prendergast lay
  
With MacDonnchadh that night,
  
But next day in the morning
  
2140] Maurice returned
  
To the court of his lord
  
Who was of so great worth.
  
The barons blamed Maurice
  
For having brought the king to the wood,
  
2145] In that he was the mortal enemy
  
Of Richard the good and lawful earl;
  
For this king by his war
  
Cast out Dermot from **Leinster**.
  
And Maurice folded his glove
  
2150] And gave it to his lord as a pledge


---

p.159


That he would redress in his court
  
Whatever transgression he had committed.
  
And the renowned English vassals
  
Went sufficient security for him.
121. 2155] When they had finished this pleading
  
King O'Brien goes to **Limerick**.
  
The earl then set out
  
Straight to the city of **Ferns**.
  
Eight days he abode there,
  
2160] The noble earl and his baronage.
  
Then the earl sent in all directions
  
Squires, sergeants, and attendants;
  
Murtough O'Brien they go to seek
  
Up and down throughout the land.
  
2165] So well did they seek him through the country
  
That they found him, in truth, and took him.
  
Straight to the city of **Ferns**
  
They then led the rebel O'Brien
  
To the earl they then delivered him,
  
2170] O'Brien the convicted traitor.
  
Because the rebel had betrayed
  
Dermot his rightful lord,
  
The earl had him beheaded
  
And his body then thrown to the hounds.
  
2175] The dogs wholly devoured him
  
And ate up his flesh.
  
And one of his sons Donnell Kavanagh


---

p.161


Had taken and brought to the earl.
  
At **Ferns** they were both put to death
  
2180] In the presence of the people of that district.
  
The Irish king of **Hy Kinsellagh**
  
Then made peace with the earl;
  
This was the rebel Murtough
  
Who was then king of **Hy Kinsellagh**.
  
2185] The earl then granted to him
  
The kingdom of **Hy Kinsellagh**;
  
The pleas of **Leinster** he entrusted
  
To Donnell Kavanagh, the son of Dermot.
  
These two were called kings
  
2190] Of the Irish of the country.
  
In **Ireland** there were several kings,
  
As elsewhere there were earls;
  
But whoever holds **Meath** and **Leinster**
  
And **Desmond** and **Munster**
  
2195] And **Connaught** and **Ulster**,
  
Which the six brothers formerly held,
  
Those who hold these are head-kings
  
Of **Ireland**, according to the Irish.
122. When the earl had appeased
  
2200] The Irish of the country,
  
Then the English king sent
  
To the earl to announce
  
That, without delay, without gainsaying,
  
Without taking time or respite,
  
2205] The earl should come speedily
  
To speak to him at once.
  
And the earl at this juncture


---

p.163


To Miles gave the custody of **Dublin**:
  
A city much renowned,
  
2210] Which was formerly called **Ath-Cliath**.
  
And the custody of the city of **Waterford**,
  
Which was called **Port-Lairge**,
  
The noble Earl Richard gave :
  
To Gilbert de Boisrohard.
  
2215] The earl then got ready,
  
He resolved to cross over to **England**;
  
The noble earl resolved to cross over
  
To speak to King Henry:
  
To King Henry Curt-Mantel,
  
2220] Who was his rightful lord,
  
His ships he then equipped
  
To traverse the waves.
  
He resolved to cross the high seas,
  
He will go to speak to the English king.
  
2225] So much did the earl hasten
  
That he soon crossed the sea.
  
In **Wales** he landed,
  
The earl who was so much dreaded.
123. Earl Richard at this time
  
2230] At Pembroke found the rich king.
  
The noble earl of great worth
  
Into the presence of his lord,
  
With his friends and his comrades
  
Into the presence of his lord came.


---

p.165


2235] The noble earl saluted him
  
In the name of the Son of the King of Majesty
  
And the king graciously
  
Made answer to Earl Richard.
  
The king thereupon replied:
  
2240] 'May God Almighty bless you!'
124. Now, as it was told to me,
  
The earl was somewhat embroiled:
  
The noble earl of great worth
  
Was embroiled with his lord.
  
2245] Through the lies of people
  
And through evil instigation
  
Was Richard, the noble earl,
  
Somewhat embroilled with King Henry.
  
Nevertheless the rich king
  
2250] Towards the earl assumed a friendly manner.
  
The rich king at this time
  
Made no show of anger;
  
But King Henry, who was the empress' son,
  
Honoured him much.
  
2255] Then while the warrior
  
Remained with his lord,
  
Lo! a rebel thereupon
  
To **Dublin** came sailing.
  
Below **Dublin** he landed,
  
2260] Hasculf MacTorkil with a hundred ships.
  
He brought many men with him:
  
About twenty thousand he got ready.


---

p.167


From the Isles they came and from **Man**;
  
And from **Norway** came John.
  
2265] A brave man, John the Wode,
  
MacTorkil brought with him.
  
He was nephew of the rich king
  
Of **Norway**, according to the Irish.
  
At the **Steine** they landed,
  
2270] Hasculf and John the Wode.
  
Outside **Dublin** city
  
Were these men encamped.
  
In order to attack the city
  
They disembarked their men.
  
2275] The good Miles armed himself,
  
He and all his companions.
  
The noble man resolved to defend himself
  
So long as he could have defence:
  
With the aid of Almighty God
  
2280] He resolved to defend himself against these men.
  
Then behold! a king
  
Of this country, an Irishman,
  
Gilmoholmock was his name,
  
He was at peace with the good Miles;
  
2285] With Miles he came to parley,
  
To ask counsel of the baron.
  
For Miles of the bold heart
  
Held hostages of this king,
  
That he would hold with the earl
  
2290] Loyally night and day.
  
The good Miles said to the king:


---

p.169


'Hearken, Sire, a moment.
  
I shall deliver up your hostages to you
  
Safe and sound and all complete:
  
2295] You shall have your hostages on condition
  
That you do what I tell you,
  
On condition that you aid
  
Neither us nor them at all,
  
But that you stand to one side of us
  
2300] And watch the battle
  
From the side with your men,
  
So that you may see clearly
  
The contest and the battle
  
Between us and them, without fail.
  
2305] And if God grants it to us
  
That these men be discomfited,
  
Then that you aid us with your force
  
To overthrow them;
  
And if we be recreant
  
2310] That you aid their men in all things
  
To cut us to pieces and slay us
  
And hand our men over to destruction.'
  
The king granted this to him,
  
Pledged his faith and sware
  
2315] That all that Miles said to him
  
The king would do without any delay.
125. Gilmoholmock thereupon
  
Outside the city instantly
  
Posted himself, in truth, the king


---

p.171


2320] With the men of his district.
  
On the summit of the **Howe** over the **Stein**,
  
In a plain, outside the city,
  
To watch the contest
  
They were assembled:
  
2325] To watch the combat
  
Gilmoholmock posted himself that day;
  
In an open place, of a truth,
  
He posted himself with his followers.
126. Lo! John the Wode
  
2330] Towards **Dublin** with serrid ranks,
  
Towards the city with his men,
  
Against the eastern gate,
  
Towards St. Mary's gate,
  
They then attacked the city.
  
2335] Now Miles, with the undaunted mien,
  
Had a brother, a brave baron.
  
Richard was his name,
  
Brother he was to good Miles.
  
He armed himself well,
  
2340] With him about thirty horsemen.
  
Through the western entrance
  
They issued quite secretly,
  
So that none knew of it,
  
Not a single one except his brother.
  
2345] And Miles marshalled his men,
  
He wished to defend the city,
  
The sergeants he made go in front


---

p.173


To hurl their lances and shoot their arrows.
  
These men close to the walls
  
2350] In order to defend the battlements
  
Thereupon turned,
  
Both archers and sergeants.
  
And Miles, who was so daring,
  
With all his knights of worth
  
2355] Were mounted on their horses
  
With arms furnished and prepared.
  
John's men with great fury
  
Then fell upon the city,
  
And the English of great worth
  
2360] Defended themselves well that day.
  
And Richard came
  
Before that they were perceived,
  
Upon the guard that was behind;
  
Loudly he shouted.
  
2365] Richard thereupon shouts:
  
'Strike, valiant knights!'
  
And the barons with great force
  
Threw themselves into the throng.
  
Very great was the contest
  
2370] And the hue and cry.
  
And John then scented
  
The noise of those behind and the shouting;
  
From the city he departed,
  
He wished to succour his friends
  
2375] Who were left behind,


---

p.175


Nine or ten thousand, I know not which.
  
They departed from the city,
  
This John and his followers,
  
To succour their men behind
  
2380] That they should not be outdone.
  
And Miles, the renowned,
  
Made a sortie from the city:
  
Made a sortie with his men,
  
With about three hundred armed vassals
  
2385] Besides all his other followers,
  
Archers, sergeants and foot-soldiers.
  
Before Miles made his sortie
  
Five hundred were laid low;
  
And these five hundred were wounded
  
2390] So that they shall never be healed.
127. When Miles came up
  
And the strong-limbed English vassals,
  
Miles then shouted out:
  
'Strike, renowned barons!
  
2395] Strike, vassals, speedily,
  
Spare not these men!'
128. When Miles was on the field,
  
He and all his companions,
  
Very much emboldened were
  
2400] The hardy English vassals:
  
As God Almighty willed it,
  
By his power which is so great,
  
According to the statement of the history,


---

p.177


To the English he gave the victory.
  
2405] But of the English on that day
  
Was Richard the flower of all.
  
A very severe punishment there was
  
Of these men near the sea.
  
Thereupon they fled,
  
2410] Both small and great,
  
From this great hue that they had brought on,
  
Hasculf and John the Wode.
129. When Gilmoholmock, you must know, the king
  
Saw the Northmen take to flight,
  
2415] Both those from the Isles and those from **Man**,
  
The followers of Hasculf and of John,
  
And the king perceived for certain
  
That they were discomfited,
  
To his feet the king leaped,
  
2420] And with a loud voice shouted:
  
'Up now, brave sirs!
  
Let us aid the free-born English
  
Up now, quickly! we shall aid
  
Good Richard and Miles.'
  
2425] And the Irish thereupon
  
Went in all directions slaying:
  
Slaying they went in all directions
  
With their javelins and their darts
  
These men who had come
  
2430] With Hasculf, the old hoary-head.
  
And these went away discomfited


---

p.179


To the woods and moors and wastes.
  
Why should I say more?
  
Fifteen hundred to their destruction
  
2435] Were left on that day,
  
Dead and miserably hacked.
  
Indeed, some people say
  
Two thousand brave warriors
  
Were, in truth, left that day
  
2440] Who were previously slain on the battle-field.
130. Now this John the Wode
  
Was a very renowned warrior;
  
For this John in the contest
  
With a well-tempered axe
  
2445] Struck a knight that day
  
Whose thigh he chopped off:
  
With his axe of hard iron
  
He chopped the thigh off to the ground.
  
He slew that day about
  
2450] Nine or ten of our English.
  
But the good Miles de Cogan
  
Killed the aforesaid John.
  
And Richard that day, without fail,
  
Took Hasculf prisoner in the battle.
  
2455] And the fields and the wastes
  
Were covered with the slain.
  
Know all for certain, without fail,
  
There was in the battle that day


---

p.181


Great destruction, in short,
  
2460] And ruin at the hands of the English.
131. A goodly treasure the English gained
  
Of silver and gold;
  
And Miles and his followers
  
Returned to **Dublin**.
  
2465] When they came to the city
  
They then beheaded Hasculf;
  
On account of his outrageous conduct
  
They rightfully beheaded him:
  
On account of his insolence and mad sayings,
  
2470] After Richard had taken him prisoner,
  
They speedily beheaded him,
  
In the presence of the sea-folk.
  
The Northmen fled away
  
Over mountain and plain;
  
2475] To the ships they turned their skiffs,
  
They fully thought to cross the sea;
  
But the English are behind them
  
To dispute their ships with them.
  
If you had been there on that day,
  
2480] Of the men of Hasculf the traitor
  
You would have seen five hundred plunge
  
Into the depths of the sea.
  
Thus, of a truth, were
  
The sea-folk discomfited.
  
2485] The English by the aid of God
  
Had that day won the field.
  
Their enemies were scattered,


---

p.183


Killed, wounded, and discomfited.
  
To their country, of a truth,
  
2490] Of these Northmen
  
There returned only two thousand
  
To claim their rights.
  
Here we shall leave the story
  
Of the good Richard and of Miles;
  
2495] Of the English king we shall tell you,
  
Of Henry with the stern aspect.
132. As soon as the king came to the sea
  
At Pembrokeshire, in order to cross over,
  
Lo! then at the harbour
  
2500] Twelve traitors from **Wexford**
  
Came to land in a boat
  
At **Pembroke** close under the castle.
  
As soon as they had landed,
  
Towards the castle they turned;
  
2505] The caitiffs wanted to speak
  
To king Henry Curt-Mantel.
  
So far did the traitors go
  
That they entered the palace
  
Into the presence of King Henry,
  
2510] Who was the son of the empress,
  
And they saluted him aloud
  
In the name of God the Father Almighty.
  
The rich king straightway
  
Replied to them graciously,
  
2515] That they were welcome,
  
His well wishers and his friends.


---

p.185

135. 'Hold it not, lord, as folly,'
  
Thus spake the traitors unto him,
  
'If we shall say to you—be it known to you all—
  
2520] Why we have come to you.
  
We have taken your rebellious vassal,
  
Robert Fitz Stephen is his name,
  
Who was guilty of perfidy towards you of yore,
  
Often of great evil and treachery;
  
2525] Many times has he waged war against you.
  
In **Wales** and in **England**;
  
To **Ireland** he came with a ship,
  
He wished to hand us over to destruction,
  
He wished to destroy our country,
  
2530] Often did he put us from bad to worse.
  
In a castle we took him,
  
In a strong prison we have placed him;
  
To thee we shall give him up, noble king,
  
Who art lord of the English,
  
2535] And do you, noble renowned king,
  
Do your pleasure in this matter.'
  
The king replied to them:
  
'On this condition be ye welcome,
  
That you hand over this man to me
  
2540] And then ye will see what I shall do with him.'
  
And they assured the king
  
And promised truly and swore
  
That, as soon as they had crossed the sea,
  
To king Henry, who was so stern,


---

p.187


2545] They would at length hand over Robert
  
And all the other knights
  
As many as they had in prison
  
And in their possession.
136. Now, my lords, I will tell you
  
2550] Why the king, who was so well-bred,
  
Showed such great wrath
  
Against the renowned baron Robert;
  
For, of a truth, the king,
  
To whom **England** belongs,
  
2555] Loved the baron much
  
Whom these men held in prison;
  
Wherefore the king feared
  
That the perfidious traitors
  
Would murder the good Robert
  
2560] Or bring him to shame and dishonour;
  
Wherefore the king made pretence
  
Of anger and of great wrath
  
That he had for the baron,
  
For fear of the treachery
  
2565] Which these knaves might do
  
Against Robert, the warrior.
137. The king accordingly thanked
  
The traitors for their loyalty,
  
In that they had taken his enemy
  
2570] And put him in gyves and fetters,


---

p.189


And in that they had promised him
  
To deliver up Robert to him.
  
Then the traitors took
  
Their leave of King Henry
  
2575] And went away to their hostel
  
The chief one in the city.
  
There they waited for the wind,
  
The king and they in the same way.
138. Hear, my lords, concerning King Henry,
  
2580] Who was the son of the empress,
  
How he resolved to cross the sea
  
And to conquer **Ireland**
  
Entirely through the recommendation
  
Of the noble earl, according to the people.
  
2585] King Henry then crossed over
  
To **Ireland** with his ships.
  
The king then brought with him
  
Four hundred armed knights.
  
King Henry when he took ship
  
2590] Put to sea at the **Cross**:
  
At **Pembrokeshire** at this time
  
The rich king put to sea.
  
With him the noble earl crossed over,
  
According to the statement of the old people.
  
2595] At **Waterford** the noble king
  
Landed with four thousand English,
  
On All Hallows' Day, of a truth,
  
If the geste does not deceive us;


---

p.191


Before the feast of St. Martin
  
2600] The king at length came to **Ireland**.
  
With the king there crossed over
  
Vassals of good kindred.
  
William the son of Audeline
  
Came with him on this occasion,
139. 2605] Also Humphrey de Bohun,
  
And the baron Hugh de Lacy.
  
With the king himself there came
  
The son of Bernard, Robert, I trow;
  
A renowned baron came,
  
2610] Bertram de Verdun he was called;
  
Earls and barons of great worth
  
Came in numbers with Henry.
140. The earl of his own free will
  
Surrendered the city to the king:
  
2615] To the king he surrendered **Waterford**
  
Of his own will and agreement.
  
Homage for **Leinster**
  
He did to the king of **England**:
  
The earl of great worth
  
2620] Did homage to his lord.
  
The rich king granted to him
  
**Leinster** in fee.
  
King Henry, the gallant,
  
To the Baron Robert the son of Bernard—
  
2625] The custody of the city of **Waterford**
  
He then gave to the son of Bernard.


---

p.193

143. When the king had landed
  
At **Waterford** in safety,
  
Lo! the traitors,
  
2630] Who were lords of **Wexford**,
  
Brought the son of Stephen
  
Into his presence in chains.
  
In the city of **Waterford**
  
To the king himself they delivered him up.
  
2635] The king received the body
  
In the presence of his barons and earls.
  
There the noble king accused him
  
Of whatever transgression he had done
  
Towards him, who was his lord,
  
2640] In the presence of the traitors.
  
The son of Stephen folded his glove,
  
And straightway offered it to the king:
  
For whatever he should be able to accuse him of
  
Robert would be willing to give redress
  
2645] In his court very willingly
  
On the guaranty of all his peers.
  
French, Flemmings and Normans
  
Went sufficient bail for him at once.
  
From **Waterford** King Henry
  
2650] Set out with his marquises,
  
To **Dublin** with his men
  
He went without delay.
  
Richard, the noble and valiant earl,
  
Straightway surrendered the city to him.


---

p.195


2655] **Dublin** King Henry gave
  
To the custody of Hugh de Lacy,
  
And he afterwards guarded the city
  
By the command of the king.
  
And the king of **England**
  
2660] Thence turned towards **Munster**,
  
To the city of **Cashel**
  
Went the king with his splendid following,
  
Where at that time was the seat
  
Of the archbishopric of **Munster**.
  
2665] From **Cashel** the puissant king
  
Went on to **Lismore**.
  
King Henry Curt Mantel
  
At **Lismore** wished to fortify
  
A castle: so wished King Henry,
  
2670] Who was the empress' son.
  
I know not why, but nevertheless
  
At this time he put it off.
144. Towards **Leinster** the English king
  
Set out at this time:
  
2675] Towards **Leinster**, the rich,
  
He went with his chivalry.
  
Eighteen weeks, nor more nor less,
  
According to what the old people say,
  
The duke of **Normandy** remained
  
2680] In **Ireland** with his baronage.


---

p.197


Of **Normandy** at this time
  
The rich king was duke;
  
Of **Gascony** and of **Brittany**
  
Of **Poitou**, of **Anjou**, and of **Maine**,
  
2685] Was King Henry called
  
Lord, according to the old people.
  
In **Ireland** was the king
  
About a fortnight and four months.
  
In the land up and down
  
2690] Marched the noble king.
  
Victuals were very dear
  
Throughout all **Leinster**,
  
For no provisions came to them
  
From any other region.
  
2695] At **Dublin** was King Henry,
  
And at **Kildare** the noble earl.
  
There the earl abode
  
With as many men as he had.
  
While the renowned king
  
2700] Was in the city of **Dublin**,
  
Lo! a messenger in haste
  
Came in haste from **England**.
  
Lo! a messenger
  
Came to announce to the king
  
2705] That Henry, his eldest son,
  
Had in truth revolted against him,
  
And that he sought to deprive him wholly
  
Of the lordship of **Normandy**.


---

p.199

147. Then the king summoned
  
2710] Hugh de Lacy, first of all,
  
And his earls and his vassals
  
And his free-born barons.
  
The rich king then gave
  
The custody of the city of **Dublin**
  
2715] And of the castle and the keep
  
To the baron Hugh de Lacy,
  
And **Waterford**, on the other hand,
  
To the baron Robert the son of Bernard.
  
The son of Stephen at this juncture
  
2720] Was left at **Dublin**,
  
And Meiler the son of Henry
  
And Miles the son of David;
  
With Hugh these were left
  
By the command of King Henry.
148. 2725] Before that, at this juncture,
  
The king left **Dublin**,
  
To Hugh de Lacy he granted
  
All **Meath** in fee
  
**Meath** the warrior granted
  
2730] For fifty knights
  
Whose service the baron should let him have
  
Whenever he should have need of it.
  
To one John he granted **Ulster**,
  
If he could conquer it by force;
  
2735] John de Courcy was his name,
  
Who afterwards suffered many a trouble there.
  
Then the king went away to the port,


---

p.201


Towards the city of **Wexford**;
  
He made all the master mariners
  
2740] Get ready his ships.
  
But Richard the renowned earl
  
Went to the city of **Ferns**.
  
There he married his daughter;
  
To Robert de Quency he gave her.
  
2745] There the marriage took place
  
In the presence of all the baronage.
  
To Robert de Quency he gave her,
  
And all the Duffry also,
  
The constableship of **Leinster**,
  
2750] And the standard and the banner.
  
Here I shall leave off about the earl
  
And return to my subject;
  
I would wish, my lords,—know in sooth—
  
To speak of the rich King Henry.
149. 2755] The king tarried by the sea
  
At **Wexford** in order to cross over.
  
The noble king then crossed over
  
And landed at **Porth'stinian**.
  
With him crossed over the good Milo
  
2760] And many a vassal and many a baron.
  
At half a league from **St. Davids**
  
King Henry landed;
  
And the king towards **Normandy**
  
Went with his great nobles
  
2765] In order to make war against a son of his


---

p.203


Who wished to despoil him.
  
War had the rich king
  
With the French in **Normandy**.
  
In **Ireland** remained
  
2270] The noble earl with his friends.
  
At **Kildare** he stayed
  
With all the forces he had.
  
Often he entered **Offaly**
  
2775] In order to plunder O'Dempsey.
  
O'Dempsey was then called
  
Lord and defender of **Offaly**.
150. The earl entered **Offaly**
  
With all his chivalry
  
In order to spoil and plunder
  
2780] O'Dempsey, who was so bold,
  
In that he did not deign to parley with the earl,
  
Nor would deliver hostages to him.
  
O'Dempsey then, i'faith,
  
Would not make peace with the earl.
  
2785] O'Dempsey with his men
  
Very bravely, of a truth,
  
Contended against the earl,
  
To whom **Leinster** belongs.
151. When the earl with his followers
  
2790] Had entered **Offaly**,
  
He then plundered the territory
  
And sought for cattle in wood and plain.


---

p.205


When he had collected
  
The spoil from all the district,
  
2795] To **Kildare** returned
  
The renowned English barons.
  
The earl was ahead in front
  
With a thousand fighting men;
  
The constable remained behind
  
2800] With the rear-guard.
  
Right at the exit from the pass
  
He fell upon them very quickly,
  
O'Dempsey fell upon them,
  
And the Irish of **Offaly**.
  
2805] All the Irish of the district
  
Attacked the rear-guard.
  
That day, in short, was slain
  
The noble Robert de Quency,
  
Who held the standard and the pennon
  
2810] Of the region of **Leinster**,
  
And to whom the earl had given
  
The constableship in heritage.
  
Greatly was he regretted, know in sooth,
  
The baron Robert de Quency,
  
2815] And in very great grief
  
For his death was his good lord.
152. When this Robert was slain
  
They buried him honourably.
  
Robert, who was so noble,
  
2820] Had indeed a daughter


---

p.207


By his wife, of a truth,
  
According to the old people;
  
And she was afterwards given to a baron,
  
Philip de Prendergast was his name,
  
2825] The son of Maurice of **Ossory**,
  
Who afterwards lived in **Hy Kinsellagh**.
  
Concerning this Philip I shall leave off,
  
Of the noble earl I wish to speak,
  
And of a brave knight,
  
2830] Raymond le Gros I heard him called,—
  
How this baron of great worth
  
Besought the earl for his sister,
  
That he should give her to him to wife
  
And as his friend and consort
  
2835] With all the constableship
  
Of **Leinster**, the rich,
  
Until the infant should be of an age
  
To be able to hold her inheritance,
  
The daughter of Robert de Quency,
  
2840] Of whom you have already heard,
  
Or until she should be given
  
And married to some man
  
Who could direct the banner
  
And the standard of **Leinster**.
153. 2845] The noble earl replied
  
That he was not advised
  
To grant the petition
  
Which the baron had made of him.


---

p.209


Then Raymond departed
  
2850] He and all his companions;
  
He took leave of the earl
  
Very suddenly in evil humour;
  
To **Wales**, in short, he then crossed over
  
Through the anger that he felt
  
2855] For the earl, in that he had refused
  
The request he had made.
  
Thus in such manner
  
Raymond departed from the country.
  
He crossed over the sea to **Wales**,
  
2860] To **Carew Castle** he went to dwell.
  
Concerning Raymond le Gros I shall here leave off
  
About the English king I shall tell you,
  
How he sent by messenger—
  
  
[*gap: extent: probably one line*]  

  
He announced to the earl
  
2865] In **Ireland** by messenger
  
That he should come to his aid
  
Speedily in **Normandy**,
  
For he was in great perplexity
  
To govern his territory
  
2870] And to protect his country
  
Against the young king his son.
  
And the earl of great worth,
  
In order to aid his lord
  
Crossed the sea to **Normandy**
  
2875] And brought a number of knights.


---

p.211


In **Ireland** he left
  
Knights serjeants and foot soldiers
  
In order to conquer the land,
  
So that the light-footed people of that country,
  
2880] Who were all his enemies,
  
Should not be able to annoy him.
154. When the noble earl
  
Had come into the presence
  
Of King Henry Curt-Mantel
  
2885] Very joyful was the king.
  
Then the king delivered to him
  
The city of **Gisors** in custody;
  
And the earl with great courtesy
  
Replied to his lord
  
2890] That willingly, i'faith,
  
As long as it should be his pleasure—
  
He would, in fact, guard the city
  
As long as the noble king should please.
  
Such good service did the earl perform
  
2895] For his lord, King Henry,
  
That the king, without pretence,
  
Was well pleased with his service.
155. The rich king, at his request
  
To return to **Ireland**,
  
2900] Gave leave to the warrior
  
To return to **Ireland**.


---

p.213


The king, quit-claimed **Wexford**
  
To the earl at this time;
  
He gave him the custody of the coast
  
2905] Both **Waterford** and **Dublin**.
  
Then the king caused to be summoned
  
All the noble knights,
  
As many as he had at **Waterford**,
  
At **Dublin** and at **Wexford**,
  
2910] To come to him
  
Speedily at his command.
  
The noble earl, know in sooth,
  
In such manner departed;
  
Then he put to sea
  
2915] And towards **Ireland** sails:
  
The noble earl, the warrior,
  
Sails over the high sea.
  
By sea he ran
  
Until he came to **Dublin**.
  
2920] Then earl Richard sent word
  
To the baron Robert the son of Bernard,
  
And to all the liege barons
  
Who acknowledged themselves the king's men
  
Of the city of **Waterford**,
  
2925] To knights, barons, and followers,
  
And to each baron separately,
  
That by the king's command
  
All should cross the sea
  
To aid the king in **Normandy**.
  
2930] And the earl again
  
Sent to **Wexford** by letter,


---

p.215


Sent word to the barons similarly
  
On the part of the king Curt-Mantel,
  
That they should cross over without delay
  
2935] To succour the king in **Normandy**.
  
The son of Stephen also
  
Crossed the sea to King Henry,
  
And Maurice of **Ossory**,
  
Who afterwards lived in **Hy Kinsellagh**.
  
2940] And Hugh de Lacy, who was so bold,
  
In order to plant his lands,
  
Set out to **Meath**
  
With many a renowned vassal.
  
Of this Hugh I will say no more,
  
2945] Of the liege barons I will give you an account.
156. When the barons had crossed over
  
Straight to **Druidston Chins**,
  
Towards **London** they turned direct
  
With all their men.
  
2950] At this time there was, you must know, a great war
  
Throughout all **England**;
  
For the rich king of **Scotland**
  
Was at war with the English king,
  
And the earl of **Leicester** then,
  
2955] According to the statement of the old people,
  
Had revolted against his lord
  
And had brought over Flemings.


---

p.217


He thought by their war
  
To ravage all **England**,
  
2960] While the son of the Empress
  
Warred against his son in **Normandy**.
  
Now the vassals and barons
  
Of the region of **England**
  
Encountered the Flemings
  
2965] At the city of **St. Edmunds**.
  
There they were discomfited
  
And the earl of **Leicester** taken.
  
They were discomfited in this manner
  
By the aid of **Leinster**,
  
2970] And by the might of the Irish
  
The field remained with the English.
  
And in his turn within that month
  
The king was taken and conquered.
  
And the barons of **Ireland**,
  
2975] Who were in this brawl,
  
All passed over to **Normandy**
  
And told the news to the king,
  
How the Flemings were slain
  
And the king of **Scotland** taken.
157. 2980] 'Ha!' said the king, 'Praise thee, God,
  
Who art Father and Creator,
  
For having done me this favour
  
That my traitors are taken!'
158. Hear, my lords, valiant barons,
  
2985] May God of Heaven protect you!
  
Concerning the English king I shall leave off,


---

p.219


Who was so very noble and brave,
  
Of the noble earl I will speak
  
And of his reverses treat:
  
2990] How the noble earl
  
Throughout **Ireland** up and down
  
Marched, you must know, with his bold men,
  
Throughout all **Leinster**.
  
  
[*gap: lacuna in MS/extent: unknown*]  

  
Then the earl dispatched
  
2995] A certain interpreter of his,
  
To Raymond le Gros he sent word
  
That he should come at once to parley with him,
  
That the noble earl
  
Would give him his sister to wife.
  
3000] Then Raymond equipped himself,
  
With many a brave vassal.
  
At **Wexford** they landed,
  
According to the history, with three ships.
159. Then Raymond to Gros sent
  
3005] To the earl by a lad,
  
Who told him all the facts:
  
How Raymond had landed,
  
And that the earl should speedily
  
Declare his will to the baron.
  
3010] The noble earl at this time


---

p.221


Was at the city of **Waterford**;
  
To Raymond he sent word
  
That he would do all his will;
  
He sent back word also
  
3015] That to the Isle of **Inis-Teimhne**
  
To meet him in parley
  
Raymond should come with his men.
  
Accordingly Raymond got ready,
  
He and all his companions,
  
3020] To the isle he went
  
As the earl had directed;
  
And the earl also
  
Came there with a very fine suite.
160. The noble earl of great worth
  
3025] Brought there his sister then.
  
There they held a parley,
  
The earl and the strong-limbed baron,
  
About marrying his sister;
  
To Raymond le Gros he will give her.
  
3030] Thence they set out straightway
  
To **Wexford** fighting their way.
  
There the earl brought his sister,
  
To Raymond le Gros he then gave her,
  
Together with the standard and the banner
  
3035] Of all **Leinster**,
  
Until the infant should be of age
  
To be able to hold her inheritance,
  
The daughter of Robert de Quency
  
Of whom you have already heard.


---

p.223

163. 3040] But afterwards a vassal took her,
  
Philip, a free-born baron,
  
De Prendergast he was called,
  
An illustrious liege baron.
  
This man was such, know ye all,
  
3045] That in the morning he was peevish and irritable,
  
But after eating, generous and good tempered,
  
Courteous and liberal to all.
  
As soon as he had put on his cloak
  
He was every day swoln with anger;
  
3050] But once he had dined in the morning
  
Then was not a merrier soul under heaven.
  
This man for a long time
  
Held the constableship, according to the people,
  
Very renowned he was,
  
3055] And loved by everybody,
  
Very courageous too he was,
  
And of very great prowess.
  
Concerning him I will not here relate,
  
To my subject I will return.
  
3060] I will tell you my lords of a noble baron,
  
Of Raymond le Gros I wish to speak,
  
How the warrior earl
  
Gave him his sister to wife,
  
The **Forth** the earl gave him
  
3065] In marriage with his sister;
  
Afterwards he gave him, you must know,
  
All **Odrone** in fee,


---

p.225


And Glascarrig also
  
On the sea towards the east.
  
3070] He gave **Obarthy** on the sea,
  
To Hervey de Mont Maurice.
  
To Maurice de Prendergast
  
The valiant earl Richard
  
Had already given **Fernegenal**
  
3075] And in his council confirmed it
  
Before the renowned earl
  
Had landed in **Ireland**;
  
Ten fiefs he gave him on this condition
  
For the service of ten knights.
  
3080] In **Fernegenal** he dwelt altogether
  
So that Maurice had him for next neighbour.
  
I know not how but Robert Fitz Godibert
  
Held it afterwards, you must know.
  
**Carbury** he gave to the good Meiler
  
3085] Who was such a noble lord.
  
The earl Richard next gave
  
To Maurice the son of Gerald—
  
The **Naas** the good earl gave
  
To the son of Gerald with all the honour:
  
3090] This is the land of **Offelan**
  
Which belonged to the traitor MacKelan.
  
He gave him too **Wicklow**,
  
Between **Bray** and **Arklow**:
  
This was the land of **Killmantain**
  
3095] Between **Ath-cliath** and **Loch Garman**
  
Twenty fiefs in **Omurethy**
  
The noble earl in the same way


---

p.227


Gave to the warrior
  
Walter de Riddlesford;
  
3100] To John de Clahull the marshalship
  
Of **Leinster**, the rich,
  
With all the land, know in sooth,
  
Between **Oboy and** **Leighlin**;
  
To Robert de Birmingham
  
3105] **Offaly** to the west of **Offelan**.
  
To Adam de Hereford likewise
  
He gave a rich fief.
  
And to Miles the son of David,
  
Who was so intimate with him,
  
3110] **Owerk** in **Ossory**
  
He gave him as his share.
  
To Thomas the Fleming he gave
  
**Ardrie**, in the presence of his baronage.
  
**Offelimy** on the sea
  
3115] The earl gave to a knight:
  
To Gilbert de Boisrohard
  
The earl gave it as his share.
  
The noble earl, who was so bold,
  
Gave fifteen fiefs on the sea
  
3120] To a brave knight,
  
Reinaud I heard him called.
  
The Earl Richard the son of Gilbert
  
Gave **Narragh** to one Robert.
  
Who was afterwards indeed killed
  
3125] In **Connaught** by his enemies.
  
In such manner the renowned earl


---

p.229


Divided and gave his land.
  
Concerning the noble earl I shall here leave off,
  
Of Hugh de Lacy I shall tell you,
  
3130] How he enfeoffed his barons,
  
Knights, serjeants, and retainers.
164. **Castle Knock**, in the first place, he gave
  
To Hugh Tyrrell, whom he loved so much;
  
And **Castle Brack**, according to the writing,
  
3135] To baron William le Petit,
  
**Magheradernon** likewise
  
And the land of **Rathkenny**;
  
The cantred of **Ardnorcher** then
  
To Meiler, who was of great worth,
  
3140] Gave Hugh de Lacy—
  
To the good Meiler Fitz Henry;
  
To Gilbert de Nangle, moreover,
  
He gave the whole of **Morgallion**;
  
To Jocelin he gave the **Navan**,
  
3145] And the land of **Ardbraccan**,
  
(The one was son, the other father,
  
According to the statement of the mother);
  
To Richard Tuite likewise
  
He gave a rich fief;
  
3150] **Rathwire** he gave moreover
  
To the baron Robert de Lacy;
  
To Richard de la Chapelle
  
He gave good and fine land;
  
To Geoffrey de Constantine **Kilbixi** (?)


---

p.231


3155] Near to **Rathconarty**;
  
And **Skreen** he then gave by charter:
  
To Adam de Phepoe he gave it;
  
To Gilbert de Nugent,
  
And likewise to William de Musset,
  
3160] He gave lands and honours,
  
In the presence of barons and vavassours;
  
And to the baron Hugh de Hussey
  
He then gave fair lands;
  
To Adam Dullard likewise
  
3165] The land of '**Rathenuarthi**'.
  
To one Thomas de Craville
  
He gave in heritage
  
**Emlagh Beccon** in quiet enjoyment,
  
At the north east of **Kells**,
  
3170] **Laraghcalyn** likewise,
  
And **Shanonagh**, according to the people,
  
Gave Hugh de Lacy,
  
Know in sooth, to this Thomas.
  
**Crandone** (?) then to a baron,
  
3175] Richard the Fleming was his name—
  
Twenty fiefs he gave him of a truth,
  
If the geste does not deceive you.
  
A fortress this man erected
  
In order to harass his enemies,
  
3180] Knights and a goodly force he kept there
  
Archers, serjeants, likewise.
  
In order to destroy his enemies;
  
Often he brought them from bad to worse.
  
But afterwards there came against him O'Carroll,


---

p.233


3185] Who was king of **Uriel**,
  
And the rebel MacDunlevy
  
Of the region of **Ulster**;
  
O'Rourke was there, also,
  
And the king Melaghlin.
  
3190] Full twenty thousand at this time
  
Of the Irish came upon them.
  
Very fiercely they attacked them,
  
And the barons defended themselves
  
So long as they could have
  
3195] Defence in the fortress;
  
But the Irish from all sides
  
Hurled their javelins and their darts.
  
The fortress indeed they destroyed
  
And slew the garrison within;
  
3200] But many were previously slain
  
Of the Irish of the northern districts.
  
In such manner, know ye all,
  
Was the country planted
  
With castles and with cities,
  
3205] With keeps and with strongholds.
  
Thus well rooted were
  
The noble renowned vassals.
  
And the earl had already conquered
  
His enemies of **Leinster**:
  
3210] For he had with him Murtough,
  
And next Donnell Kavanagh,
  
Mac Donachadh and Mac Dalwy,


---

p.235


O'More and O'Dempsey,
  
O'Duvegan the hoary old man,
  
3215] Likewise O'Brien of the **Duffry**,
  
Gilmoholmock and MacKelan,
  
And O'Lorcan of **Obarthy**;
  
And all the hostages of renown,
  
The noblest of **Leinster**,
  
3220] The earl, you must know, had with him,
  
According to the ancient custom.
  
Then Hugh de Lacy
  
Fortified a house at **Trim**,
  
And threw a trench around it,
  
3225] And then enclosed it with a stockade.
  
Within the house he then placed
  
Brave knights of great worth;
  
Then he entrusted the castle
  
To the wardenship of Hugh Tyrrel;
  
3230] To the harbour he went in order to cross
  
The high seas to **England**.
  
But when the king of **Connaught** heard it—
  
He who was king at this epoch—
  
That Hugh had fortified a castle,
  
3235] He was enraged at the tidings;
  
His host he summoned to him,
  
He will go to attack the castle.
165. All at once O'Connor,
  
The proud king of **Connaught**,
  
3240] Led with him O'Flaherty,


---

p.237


Mac Dermot and Mac Geraghty,
  
O'Kelly, king of Hy Many,
  
O'Hart (?) and O'Finaghty,(?)
  
O'Carbery and O'Flannagan,
  
3245] And then next O'Monaghan,
  
O'Dowd and O'Monaghan,
  
O'Shaughnessy of '**Poltilethban**';
  
King Melaghlin went also,
  
And his neighbour king O'Rourke,
  
3250] O'Malory (?) of the Kinel O'Neill,
  
And likewise Mac Dunlevy;
  
King O'Carroll went also,
  
And Mac Tierney(?), who was so base,
  
Mac Scelling and Mac Artan,
  
3255] And the rebel Mac Garaghan;
  
Mackelan likewise
  
Went with all his men;
  
O'Neill, the king of the Kinel Owen,
  
Brought with him three thousand Irish.
  
3260] The Northerners were assembled,
  
And all the kings of **Leath-Cuinn**,
  
Towards Trim they set out marching
  
To demolish the castle.
  
And the baron Hugh Tyrrell
  
3265] Sent to the earl
  
A page at full speed
  
On a very swift horse,
  
And he told the earl
  
All the tidings by word of mouth:


---

p.239


3270] How the Northerners were assembled
  
And all the kings of **Leath-Cuinn**
  
To throw down the keep
  
The castle and the stockade.
  
'Through me the baron sends you word—
  
3275] Old Hugh Tyrrell of Trim—
  
That you aid him in every way,
  
And succour him with your force.'
  
And the earl promised him
  
By word of mouth that he would aid him.
166. 3280] He caused all his men to be summoned
  
Throughout **Leinster** speedily.
  
When they were all assembled,
  
Old and young, ruddy and fair,
  
Towards **Trim** they resolved to march
  
3285] To encounter the Northerners.
  
But before the noble earl
  
Arrived with his men,
  
Hugh had of a truth
  
Utterly abandoned his charge,
  
3290] Because he was not in sufficient force
  
Within the castle nor without
  
To offer fight or combat
  
Without the help of the earl.
  
When the English were gone
  
3295] And had abandoned their house,
  
The Irish arrived at **Trim**.
  
Their numbers I shall by no means tell,
  
How many they were nor what thousands,


---

p.241


For I should be thought to be lying.
  
3300] The rampart they threw completely down
  
And levelled it even with the ground,
  
But first of all they put
  
The house to flames.
167. When they had accomplished their work
  
3305] They retreated altogether:
  
They made a show of returning
  
To their country, the wicked tyrants.
  
And the earl, who was so bold,
  
To **Trim** resolved to hasten
  
3310] To protect the house,
  
If he could arrive in time.
  
To **Trim** the earl went with all speed
  
And with him many a valiant vassal.
  
But when the earl had arrived,
  
3315] By the river he then alighted;
  
For he found there standing
  
Neither house nor cabin, big or little,
  
Within which he could take his ease
  
And lodge for that night.
168. 3320] Then the earl made proclamation
  
And commanded throughout the host,
  
That all should straightway mount.
  
Then he threw himself on his horse
  
And set off on the straight road
  
3325] Pursuing at a great pace.


---

p.243


So much did the earl exert himself
  
That he came up with the rear;
  
He charged them speedily
  
Without any pause;
  
3330] And the Irish who had no armour
  
Then scattered themselves
  
By sevens and eights, by threes and fours,
  
So that they did not hold together.
  
And the earl then slew
  
3335] Of these men seven score and ten.
  
Then, you must know, he made a retreat
  
To **Dublin** with great confidence,
  
And Hugh Tyrrell went to **Trim**
  
And re-fortified his fortress;
  
3340] After that he guarded it with great honour
  
Until the arrival of his lord.
  
And the earl throughout **Leinster**
  
Went marching back and forwards,
  
Until he resolved
  
3345] That he would at length march
  
Against King Donnell O'Brien
  
With the advice of his English.
  
His host he summons, all at once,
  
The strongest of **Leinster**,
  
3350] That all should be in attendance,
  
Old and young, small and great.
  
At the banner and the pennon
  
Of the constable Raymond le Gros.


---

p.245

171. My lords, may God befriend you!
  
3355] Knights, serjeants, and attendants,
  
I will tell you of a knight,
  
Raymond le Gros I heard him called,
  
A valiant baron he was,
  
A vassal daring and victorious,
  
3360] Very rich and powerful he was,
  
And the most puissant of his peers.
  
Constable is Raymond
  
Of the province of **Leinster**.
  
Knights he retained and a goodly force
  
3365] By the earl's command,
  
Knights he had and common soldiers,
  
Archers, serjeants, and fighting-men,
  
To put to shame and outlawry
  
The Irish enemies of the king.
172. 3370] Hearken, my lords and worthy folk,
  
If ye would hear now plainly:
  
Of a knight I will tell you,
  
A baron, a noble warrior,
  
Of the constable Raymond le Gros,
  
3375] How he summons his host from all quarters
  
Up and down throughout the land,
  
Through **Meath** and through **Leinster**,
  
All the esquirehood
  
Well armed and well equipped,
  
3380] Knights, serjeants, and common soldiers,
  
With army equipped and ready;


---

p.247


To meet Raymond in **Ossory**
  
The baronage should come,
  
And he will have them guided forward
  
3385] Against King O'Brien, who was so bold.
  
The Irish king of **Ossory**
  
Will go in their company,
  
And he will truly lead the host, so he said,
  
And guide it against King O'Brien,
  
3390] As far as the city of **Limerick**
  
He will guide it in safety.
  
Why should I go on telling you more,
  
Either more or less, little or much?
  
When the host had assembled,
  
3395] Towards **Munster** they then turned;
  
And the king of **Ossory**
  
Guides them forward in the van:
  
Towards **Munster** he guided them,
  
Against King O'Brien he brought this host.
173. 3400] But Raymond, according to the people,
  
Did not trust him entirely
  
Before that he had assured him,
  
Pledged his faith and sworn,
  
That he would never commit any deceit
  
3405] Nor treason nor treachery of any kind
  
Against him or his men henceforward.
  
And the king at once
  
Said to him then in the presence of all:


---

p.249


'You will be wrong to doubt it;
  
3410] Nay, I will guide you quite right,
  
And I shall pledge you my word.'
174. When the king had said this,
  
They march forward, without gainsaying,
  
They march all night and the next day,
  
3415] Now in woods, now in the open,
  
Until they came to a renowned city
  
Which was named **Limerick**.
  
This city was surrounded
  
By a river, a wall, and a dyke,
  
3420] So that no man could pass over
  
Without a ship or a bridge,
  
Neither in winter nor in summer,
  
Except by a difficult ford.
  
There passed over first that day
  
3425] The baron Meiler the son of Henry.
  
Wherefore it was well said:
  
'We shall call it Meiler's ford';
  
For when the host of **Leinster**
  
Came to **Limerick** in this way,
  
3430] To the river they came
  
So that they were going to return without more;
  
When a knight of **St. David's**
  
Who was brought up in this land,
  
Meiler the son of Henry was his name,
  
3435] With a loud voice raises a cry:
  
The son of Henry, the baron Meiler,
  
Began to call aloud:


---

p.251


To the front he went shouting,
  
'Pass over, knights: why do ye tarry?'
  
3440] Into the river he straightway threw himself,
  
And his white horse bears him across.
  
When the knight had crossed over
  
'St. David!' he shouted loud and clear.
  
For he was his lord
  
3445] Under the Lord God the Creator.
  
And the knight with great affection
  
Invoked St. David night and day,
  
That he might aid him
  
In doing deeds of valour;
  
3450] That he should give him strength, and praise, and renown
  
Against all his enemies.
  
Often he invoked St. David,
  
That he should not leave him in forgetfulness,
  
But give him might and vigour
  
3455] In the midst of his enemies that day.
175. After him there crossed over
  
Many barons and knights well armed.
  
Before they had all crossed over
  
Many were drowned that day.
  
  
[*gap: text breaks off imperfect/extent: unknown*]










