

#Mr. Aubrey de Vere's New Volume: A Study


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Mr. Aubrey de Vere's New Volume: A Study
========================================


Author: Patrick Augustine Sheehan
---------------------------------


### File Description

Electronic edition compiled by Benjamin Hazard

Funded by School of History, University College, Cork 1. First draftExtent of text: 7983 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E890000-023Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript**2. [Details to follow].
**Canon Sheehan on the Internet**2. http://www.canonsheehanremembered.com.
**Editions**2. Canon P.A. Sheehan, 'Mr. Aubrey de Vere's New Volume: A Study,' The Irish Monthly, 22/249 (March 1894) 126–138.
3. Canon P.A. Sheehan, 'Mr. Aubrey de Vere's New Volume: A Study,' in Early Essays and Lectures (London 1906) 191–205.
**Literature**2. Aubrey de Vere, Mediaeval records and sonnets (London 1893).
3. Matthew Russell (ed.), 'Unpublished letters of Aubrey de Vere,' The Irish Monthly, 39 (1911) 421–429, 506–510, 557–566; 40 (1912) 35–41, 100–106; 42 (1914) 620–628; 43 (1915) 213–223.
4. Herman Joseph Heuser, Canon Sheehan of Doneraile: the story of an Irish parish priest as told chiefly by himself in books, personal memoirs, and letters (New York 1917).
5. Arthur Coussens, P.A. Sheehan, zijn leven en zijn werken (Brugge/Bruges 1923).
6. Dante Alghieri, La Divina Commedia. Testo critico della Societa Dantesca Italiana, riveduto, col commento scartazziano rifatto da Giuseppe da Vandelli (21st ed. Milan 1928).
7. Christopher Dawson, Progress and religion: an historical inquiry (London 1929; repr. Washington DC 2001).
8. Ramon Menéndez Pidal (ed.), El Cid Campeador. Poema de Mio Cid (Madrid 1929).
9. M. P. Reilly, Aubrey de Vere: Victorian observer (Dublin 1836).
10. Michael P. Linehan, Canon Sheehan of Doneraile: priest, novelist, man of letters (Dublin 1952).
11. Owen Chadwick, From Bossuet to Newman (Cambridge 1957).
12. E. R. Norman, The Catholic Church and Ireland in the age of rebellion, 1859–1873 (Ithaca 1965).
13. Seamus Crowley, 'Doneraile Park: an historical note,' Mallow Field Club Journal, 1 (1983) 109–125.
14. Owen Chadwick, The spirit of the Oxford Movement: Tractarian essays (Cambridge 1992).
15. David Newsome, The Convert Cardinals: John Henry Newman and Henry Edward Manning (London 1993).
16. Declan Kiberd, Inventing Ireland: the literature of the modern nation (London 1995).
17. Rodney Stenning Edgecombe, Two poets of the Oxford Movement: John Keble and John Henry Newman (London 1996).
18. Patrick Cronin, Aubrey de Vere: the bard of Curragh Chase: a portrait of his life and writings (Askeaton 1997).
19. Alan Deremond, Historia de la literatura española, vol. 1, La Edad Media (Barcelona 1991) 65–101.
20. Paula Kane, Separatism and subculture: Boston Catholicism, 1900–1920 (Chapel Hill, NC 2001).
21. Thomas Byrne, 'Tennyson at Kilkee and other Munster tours, 1842–1878,' Old Limerick Journal (Winter 2002) 63–72.
22. Anthony Esolen (ed. & trans.), The Divine Comedy of Dante Alighieri: Inferno, Purgatory, Paradise; with illustrations by Gustave Doré (3 vols, New York 2002–2005).
23. Colin Barr, Paul Cullen, John Henry Newman and the Catholic University of Ireland, 1845–1865 (Notre Dame, IN 2003).
24. Robert Welch, 'Vere, Aubrey Thomas de (1814–1902), poet,' Oxford Dictionary of National Biography (60 vols, Oxford 2004) vol. 56, 283–284.
25. Dermot Fenlon, 'Edward Caswall, Newman and the people of Catholic Ireland,' in Howard Clarke and J.R.S. Phillips (eds), Ireland, England and the continent in the Middle Ages and beyond: essays in memory of a turbulent friar, F. X. Martin, O.S.A. (Dublin 2006) 307–324.
26. Angelo Bottone, The philosophical habit of mind: rhetoric and person in John Henry Newman's Dublin writings — Zeta Series in Christian theology (Bucharest 2010).
27. Tom Kelley and Linde Lunney, 'De Vere, Aubrey Thomas (1814–1902), poet and author,' Dictionary of Irish biography (9 vols, Cambridge 2009) vol. 3, 222–224.
28. Rafael Ramos, 'El Cid y Fernán González en las Navas de Tolosa,' in Lara Vilà (ed.), Estudios sobre la tradición épica occidental. Edad Media y Renacimiento (Madrid 2011) 53–63.
29. Matthew Campbell, Irish poetry under the Union, 1801–1924 (Cambridge 2013).
30. James O'Brien (ed.), The Collected Letters of Canon Sheehan of Doneraile, 1883–1913 (Wells 2013).
31. James O'Brien, Canon Sheehan of Doneraile 1852–1913: outlines for a literary biography (Wells 2013). [Bibliographical references 205–211].
32. Jeffrey Barbeau, Sara Coleridge: her life and thought (London 2014).
33. Paul Shrimpton, The 'Making of Men.' The Idea and reality of Newman's university in Oxford and Dublin (Leominster 2014).
34. Gabriel Doherty (ed.), Revisiting Canon Sheehan of Doneraile 1852–1913: author, activist, priest (Wells 2014).
35. 'Hunt and De Vere Family of Currahchase, County Limerick,' Catalogue of Family Papers (1755–1888), Limerick Archive, 1–7 [accessible online at http://www.limerick.ie/].
**The edition used in the digital edition**2. , Mr. Aubrey de Vere's New Volume: A Study in The Irish Monthly: A Magazine of General Literature, Ed. Matthew Russell SJ. , Dublin , Irish Jesuit Province (March 1894) volume 22 number 249page 126–138

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic text represents the edited version. Editorial footnotes are included using *note type="auth" n=""*.


#### Editorial Declaration


##### Correction


Text has been checked and proof-read twice.


##### Normalization


The electronic text represents the edited text.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, the page-break and line-break are marked after the completion of the hyphenated word.


##### Segmentation


div0 = the essay; page-breaks are marked and numbered. Metrical lines, line-breaks and verses are marked and numbered.


##### Standard Values


There are no dates.


##### Interpretation


Names of persons and places are not tagged.


### Profile Description


Created: By Patrick Augustine Sheehan (1852–1913)
 (March 1894) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some text is in Latin.


##### Language: [FR] Some text is in French.


##### Language: [IT] Some text is in Italian.


### Revision History


* (2015-07-13) Beatrix Färber (ed.)

* Item added to bibliographic details. Wordcount revised.
* (2015-01-08) Beatrix Färber (ed.)

* Header, Introduction and text proofed and checked; more encoding applied; file parsed and validated. SGML and HTML files created.
* (2015-01-06) Benjamin Hazard (ed.)

* Introduction completed.
* (2014-12-22) Benjamin Hazard (ed.)

* Further proofreading; mark-up added to annotations.
* (2014-12-15) Benjamin Hazard (ed.)

* Header updated.
* (2014-12-08) Benjamin Hazard (ed.)

* TEI header constructed; bibliography compiled; further structural and content mark-up added.
* (2014-04-07) Benjamin Hazard (ed.)

* First proofing; structural and content mark-up added.
* (2014-01-24) Benjamin Hazard (file capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E890000-023


### Mr. Aubrey de Vere's New Volume: A Study: Author: Patrick Augustine Sheehan


### Mr. Aubrey de Vere's New Volume: A Study

### Introduction


The new volume referred to here by Canon Sheehan is Aubrey de Vere's Mediaeval records and sonnets published in 1893.[1](javascript:footNote('E890000-023/note001.html')) Sheehan regarded De Vere as a worthy candidate to succeed Wordsworth and Tennyson as Poet Laureate.[2](javascript:footNote('E890000-023/note002.html')) Aubrey de Vere was one of eight siblings: five boys and three girls. The third son, he was born at Curragh Chase on 10 January 1814.[3](javascript:footNote('E890000-023/note003.html')) The De Vere estate in Co. Limerick, located thirty-six miles north-west from Doneraile, Co. Cork, compares well with that of the Castletowns at Doneraile and both families were on friendly terms with Canon Sheehan.[4](javascript:footNote('E890000-023/note004.html'))


De Vere's father approved of the political ideals of Daniel O'Connell and several members of the De Vere family later converted to Catholicism. Aubrey de Vere began writing poetry before studies in metaphysics and theology at Trinity College Dublin where his father hoped he would enter holy orders as a Church of Ireland clergyman.[5](javascript:footNote('E890000-023/note005.html')) After graduating in 1837, De Vere regularly visited England and became acquainted with a wide literary circle. At Oxford he met John Henry Newman in 1838 and, through the Cambridge Apostles Club a year later, James Spedding, who edited the works of Francis Bacon. In 1841, De Vere met Wordsworth and remained a loyal follower. In London he became close friends with Sara Coleridge, Samuel Taylor Coleridge's daughter, where he also met Thomas and Jane Carlyle. At De Vere's invitation, Tennyson visited Ireland in 1842.[6](javascript:footNote('E890000-023/note006.html'))


In early 1846, De Vere returned to Curragh Chase from Scotland. The suffering he witnessed during the Great Famine made a profound impression on him.[7](javascript:footNote('E890000-023/note007.html')) He and his brothers — Vere, Stephen, William and Horace — assisted in the famine relief schemes. As a result, Aubrey de Vere made a study of political economy and agriculture. At the end of the 1840s, seeing no improvement in conditions for the poor, he recorded his concerns that famine could return again.[8](javascript:footNote('E890000-023/note008.html'))


Already drawn to Catholicism, De Vere made a pilgrimage to Rome in the autumn of 1851 with Fr. Henry Manning.[9](javascript:footNote('E890000-023/note009.html')) On 15 November, De Vere sent Sara Coleridge news that he had been received into the Catholic Church at Avignon.[10](javascript:footNote('E890000-023/note010.html')) His decision was not without its difficulties and Carlyle was among those to voice their disapproval.


Four years later, noting the advantage of selecting someone from Trinity College Dublin, Newman appointed De Vere to the chair of political and social science at the newly-founded Catholic University of Ireland.[11](javascript:footNote('E890000-023/note011.html')) De Vere got to know Newman well and compared him in character to Edmund Burke. Attendance at the university was lower than expected and De Vere stepped down in 1853. He subsequently published the lectures he had prepared in Essays, chiefly literary and ethical (London 1889).[12](javascript:footNote('E890000-023/note012.html'))


The transition in De Vere's writing is best understood in the context of the Oxford Movement which advocated a return to lost Christian traditions and their acceptance in Anglican thought and practice.[13](javascript:footNote('E890000-023/note013.html')) Canon Sheehan equated De Vere's philosophy with Malebranche, a Cartesian, and the development of ontologism by thinkers such as Fran[cedil ]ois Fénelon, Jacques-Bénigne Bossuet, Sigismond Gerdil and Joseph Gratry.[14](javascript:footNote('E890000-023/note014.html')) These ideas, according to Chadwick, resonated with the changing expression of Christian identity in the late nineteenth century.[15](javascript:footNote('E890000-023/note015.html'))


Along with Sheehan's writings, works by De Vere became popular with American readers whose literary tastes included Belloc, Chesterton, Meynell, Newman, Patmore, Vaughan and Wiseman.[16](javascript:footNote('E890000-023/note016.html'))


While paying tribute to Arthurian legend, to ‘the most mirthful and human-hearted’ Geoffrey Chaucer, and to Shakespeare, Burke, Browning and Tennyson — the best of English-language literature in De Vere's view — his 1893 volume rests on themes from European history and culture.[17](javascript:footNote('E890000-023/note017.html')) Here, for instance, we find Dante's Beatrice, the art of Giotto and Fra Angelico of Fiesole, the German mystic, Gertrude the Great, and the astronomer Copernicus. On the reconciliation of science with religion, Sheehan commented: ‘then as now, science was supposed to be in conflict with faith, and their revelations to be mutually contradictory’. Understanding that science offers a world of discovery, a believing member of the Church recognises that true peace is found in the will of God.


Sheehan referred to De Vere's extracts from the legends of El Cid expecting that many would enjoy reading of these deeds for the first time.[18](javascript:footNote('E890000-023/note018.html')) Tales such as the twelfth-century Spanish epic were otherwise neglected in De Vere's time.[19](javascript:footNote('E890000-023/note019.html')) He was further inspired by the earliest literature from Ireland and brought to print Inisfail: a lyrical chronicle of Ireland in 1861. Two decades later De Vere published The Foray of Queen Maeve, derived from Professor Brian O'Looney's translation of Táin Bó Cuailnge. De Vere also offered his support to Lady Gregory in her earliest endeavours to found the Irish Literary Theatre.[20](javascript:footNote('E890000-023/note020.html'))


Canon Sheehan's essay lends support to the views of Douglas Hyde by noting the belief that ‘the delay will not be long’ before a revolution in Irish public opinion.[21](javascript:footNote('E890000-023/note021.html')) Sheehan asked whether De Vere could have reached people more through prose but recognised the potential for teaching readers to identify with the Christian heritage of Europe. Aubrey de Vere died on 21 January 1902 and is buried at St Mary's graveyard in Askeaton, Co. Limerick.


Benjamin Hazard


---

p.126


Our appreciation of Mr. Aubrey de Vere's poetry depends in great measure on the mood in which we approach him. If we have been touched by the glamour that hangs around our highly decorated, introspective modern verse, probably we shall be just a little disappointed at lines that appeal more to sense than sound. But if we have passed the initial surprise and intoxication that touch sensitive minds by analysis and self-questionings conveyed in words many-jointed, and strung together from the Greek, it is very likely we shall find a repose and a harmony in Mr. de Vere's poems, that strike us as more in accordance with the canons of true poetry than all the artificialities by which younger poets strive to be original in these latter days.


In the subjects Mr. de Vere has chosen he has always preferred studies of Nature and of men to idle self-questionings. If he chooses to leave the world an autobiography, and few would be more interesting, we shall never be able to trace his mental growth



---

p.127




and experiences through the long series of beautiful poems he has given to the world. There is not a trace of egoism in them all. He has completely obliterated self. In this he has followed the example of his master, Wordsworth; and if so keen a critic as Matthew Arnold can say of the latter, ‘Wordsworth and Byron stand out by themselves. I place Wordsworth above Byron on the whole. When the year 1900 is turned, and our nation comes to recount her poetic glories in the century which has just then ended, the first names with her will be these,’ we may attribute the fact to Wordsworth's love of nature; and we may add, that if Ireland has to make a similar estimate of her singers, she will have little hesitation in naming Mr. de Vere the first Catholic poet of the century, not only to our nation, but to the world.


In the little volume now before us, Mr. de Vere goes back to mediaeval times for those themes, Catholic and chivalrous, in which he takes such delight. He has done in poetry for the Middle Ages what Mrs. Jameson has done in prose. He has taken legends or historical deeds, and made a beautiful framework for them in graceful and sonorous verse. He has taken even disputed and controverted subjects; and boldly assuming the Catholic view, has made them additionally attractive to Catholic readers by presenting them in a much pleasanter form than we are accustomed to in ordinary histories. These mediaeval poems may be divided into what are purely historical or epic, one or two that may be called lyrical, and a few dramatic studies, which, with the sonnets, form the most interesting features of the volume. It was a bold attempt on the part of Mr. de Vere to try and interest modern readers in the fate and fortunes of the Cid. The old heroic romances of chivalry are hardly esteemed in our day as they were fifty years ago. The world is now not much interested in the battlefields of the past. Knights sans peur et sans reproche are too mythical to our hard century to be easily believed in; and historians of the destructive school of criticism have been so busy in demolishing all our cherished ideas of the chivalry and heroism of the Middle Ages, that it is difficult to excite and retain the attention of readers for great national legends, even though already enshrined in the epics of the world. Nevertheless, Mr. de Vere has been so judicious in his selections of the legends of the Cid, and has put them so attractively, that many will read for the first time and with pleasure of the deeds of this Spanish Bayard.[22](javascript:footNote('E890000-023/note022.html'))


---

p.128



And then, as we shall hereafter note more fully, Mr. de Vere has taken in many cases the Catholic, as distinct from the national, view of our hero, and thus made the central figure more generally interesting, whilst adding to the picturesqueness of the details. Here are lines that remind us of Arthur and Excalibur: —


> 1. Three days we rode o'er hill and dale; the fourth,
>   
> The daylight slowly dying o'er the moor,
>   
> A shrill voice reached us from the neighbouring fen,
>   
> A drowning man's. Down leaped our Cid to earth;
>   
> And, ere another's foot had left the stirrup,
>   
> Forth from the water drew him; held him next
>   
> On his own horse before him. ‘'Twas a Leper;’
>   
> The knights stared round them! when they supped that eve.
>   
> He placed that Leper at his side. The knights
>   
> Forth strode. At night one bed received them both.
>   
> Sirs, learn the marvel! As Rodrigo slept,
>   
> Betwixt his shoulders twain that Leper blew
>   
> Breath of strong virtue, piercing to his heart.
>   
> A cry was heard — the Cid's — the knights rushed in
>   
> Sworded; they searched the room; they searched the house;
>   
> The Cid slept well; but Leper none was found.
> 




Who was this? and what was the reward for a deed which, to use the author's words, speaking of Father Damien, preaches the doctrines of the Incarnation and the Resurrection more powerfully than the most eloquent treatises? 


> 1. Thy Brother-Man am I,
>   
> In Heaven thy Patron, though the least in Heaven,
>   
> Lazarus, thy brother, who unhonoured lay,
>   
> At Dives' gate. Today thou honourest Me:
>   
> Therefore thy Jesus this to Thee accords
>   
> That whenso'er in time of peril or pain;
>   
> Or dread temptations dealing with the soul;
>   
> Again that strong breath blows upon thy heart,
>   
> Nor Angel's breath, that Breath shall be, nor man's,
>   
> But Breath immortal arming thy resolve,
>   
> So long as Humbleness and Love are Thine,
>   
> With strength as though the total Hosts of Heaven
>   
> Leaned on Thy single sword. The work Thou workest
>   
> That hour shall prosper. Moor and Christian, both,
>   
> Shall for Thee and Thy death be glorified.
> 




With such a prayer and prophecy, Rodrigo passed from victory to victory, always brave, always merciful, invincible in battle and illustrious in peace. In the four Idylls of this brave knight which our author gives us, and which certainly sustain their interest to the 



---

p.129



end, there must be of necessity many passages which are rhetorical rather than poetic. Yet the rhetoric is always of a high and sustained character; and it breaks by rapid transitions into poetry, which remind us of many well-known passages in our author's legends of St. Patrick and of the Saxon saints. These passages are most frequent and most marked in the fourteen pages marked 'The Cid of Valencia'. Eloquent and beautiful lines abound in these pages. For instance: —


> 1. The moon was drowned
>   
> In plunging storm of hail and rain and snow;
>   
> Emerging thence it stared on wandering floods
>   
> From sea and river, and the mountain walls
>   
> Whose torrents, glimpsed but when the lightning flared,
>   
> Thundered far off.
> 




And this might have come from the Inferno: —


> 1. Yea, as the blind they groped about the streets,
>   
> Or staggered on like drunkards; neither knew
>   
> Each man the face of neighbour or of friend,
>   
> But gazed at him and passed; at other times
>   
> Old enemies clasped hands but spake no word;
>   
> And some flung forth their arms like swimmer spent
>   
> That sinks in black seas lost.
> 




Some curious analogues in modern verse suggest themselves to our mind in reading such lines as those — resemblances that never occurred before to us in reading Mr. de Vere's poems. At one moment we think we are reading a passage from Klopstock's Messiah, then there are lines that suggest long-forgotten pages in that well-nigh forgotten poem Festus, and again we are irresistibly reminded of certain turns of thought and expression in the Bishop of Derry's beautiful poems. But the idiomatism, to use an expressive Greek word, of Mr. de Vere is unmistakable. We think we would recognise it under a French or Italian translation.


Before passing to the higher studies, there is just one little poem, modest and humble like the subject of it, but on which we dwell and linger with more pleasure than on more ambitious and eloquent themes. Perhaps it is for memory's sake; for there is a very clear recollection in our minds of having seen this little poem in leaflet form many years ago in the hands of an old Franciscan Tertiary from Limerick, and of having kept it as a treasure, and read it and re-read it until it became creased and frayed with use, and 



---

p.130



discoloured by age. And there was just a slight thrill of pleasure in seeing this old acquaintance enshrined permanently in this volume, and in knowing that we should not lose it again. It is called St. Francis and Perfect Joy; and whoever possesses this volume and knows anything of ‘dear St. Francis,’ will have this poem well marked when perhaps statelier verses are still in a state of virginal whiteness. The opening stanza runs thus; and whoever reads it will read it to the end: —


> 1. Blessed St. Francis in the winter time
>   
> When half the Umbrian vales were white with snow,
>   
> And all the northward vine-stems rough with rime,
>   
> Walked from Perugia down. His steps were slow,
>   
> Made slow by thought; yet swift at times, for love
>   
> Showered o'er his musings, fired them from above.
> 




If Mr. de Vere would repent of his resolution to make this volume his last, and give us such beautiful metrical renderings of the whole of the Fioretti as this, one reader at least would bless him, and placing it side by side with the May Carols would think he had two books of devotion which probably he would open much oftener than many elaborate works of high spirituality that lie upon his shelves.


Very devotional, too, and very poetical are four hymns developed from the writings of St. Gertrude. They deal with high and sacred subjects; and, perhaps, for this reason, and partly from their abstract nature, it is possible they will not be so widely read as the lines on St. Francis. But for those who love to dwell in spirit on the inaccessible heights, and who aspire after what is sublime as well as holy, these four hymns of praise will be welcome reading. One can imagine how St. Augustine would have prized them — the great saint who has written so many beautiful things of God in a kindred spirit and with equal sublimity. It is a great gift to be able to translate into rhythmic measures the prayers of the saints, and to add the graces of poetry to the loftiness of such aspirations as these: —


> 1. Height inaccessible of Sovran Power;
>   
> Unfathomed depth of wisdom hid and sealed;
>   
> Limitless breadth of all-embracing love;
>   
> None but Thyself can yield Thee worthy praise;
>   
> Thou alone canst know Thyself. Our Hymns
>   
> Are as a little breeze that dies.
> 






---

p.131


Or these lines to the Humanity of Christ: —


> 1. Jesus, Thou son of God, true God, true Man!
>   
> A voice from earth would join the choirs that sing
>   
> The sweet refreshment of Thy heavenly rest;
>   
> That clear, sabbatical, and mystic clime,
>   
> Whereby Thy deified Humanity,
>   
> Its suffering past, is equally embraced,
>   
> The embowering sunset of its endless peace.
>   
> And that vivific fragrance evermore
>   
> Breathed from that underlying Eden vast,
>   
> The Bosom of the Eternal Trinity.
> 




But we are of opinion that the two most interesting poems in the volume are those entitled: The Higher Purgatory and the Death of Copernicus. It is in this kind of work that our author's genius manifests itself fully. He is here in his own natural element. Dealing with mediaeval records, blank, bare facts, there is a sense of effort and labour, as of one who tries to raise an airy structure out of gross and too solid materials. But here Mr. de Vere passes into the abstract — the region of pure imagination; and it is not difficult to see that here he is quite at home, for the two elements are present that suit his genius — religion pure and simple; and high and abstract conceptions such as would have delighted a dialectician in the ages of scholastic philosophy. It is at least curious that that prince of modern dialecticians, Cardinal Newman, should have chosen Purgatory, too, as a theme for his longest poem. The subject has a singular fascination for men of high thought; whilst the mystery and vagueness of that strange world poised between heaven and hell, and inhabited by that blessed but unhappy people who have seen God, and lost Him for a while, give free place to imaginations that are speedily fascinated by whatever appertains to the interests of immortal souls. Our author reminds us that the whole gist and matter of this poem are taken from a treatise on Purgatory by St. Catherine of Genoa; and that we must not be surprised at recognising two familiar ideas that have already found place in the Dream of Gerontius. The poem is in blank verse, whose metres are not quite regular, here and there a redundant syllable being noticed; and as the form of a poem has a great deal to say to its artistic excellence, we are glad to find the long lines relieved and broken by pauses and questions that make the whole much easier and pleasanter reading.



---

p.132



> 1. What land is that —
>   
> That land, majestic, mystic, wondrous, blest,
>   
> Yet heart-subduing too, and soul o'er-awing.
>   
> Where passion riots not, where love earth-soiled
>   
> Divinely blighted, withering to the root,
>   
> Leaves room for heavenly love?
> 



This idea is developed through many lines, and then comes the second suggestion: —


> 1. What clime is that
>   
> Still as the Church's Holy Saturday?
> 



whose peace and serenity after the gloom of Lent and before the exultation of Easter Sunday are finely pictured; and this is the conclusion:


> 1. Deepest that rest
>   
> Man knows on earth: yet deeper theirs the souls
>   
> That breathe that cleansing clime. They sinned on earth;
>   
> They sin no more. In them that buried sin
>   
> Severed from circumstance of time and place
>   
> Sleeps like a sheathed sword. Their will with God's
>   
> At last — now first — is one. Such unity
>   
> Alone could breed such rest.
> 


Then the final question,

> 1. What grief is that
>   
> Which, teaching man his primal greatness, shames
>   
> His joy foregone in pleasures wed to dust?
> 



And as the sorrow of our first father was swallowed up in love, so is the grief of the holy souls steeped, though not extinguished, in that perfect love which surrounds them. And we should say these were the best lines in the poem: —


> 1. Life veils from us love's greatness:
>   
> Life veils not less the greatness of high grief:
>   
> We are but trivial lovers all our life —
>   
> We are but trivial mourners. Thanks to God
>   
> Who grants us at life's close one Sovereign love.
>   
> One grief, the cure for all.
> 




Our author here has an interlude — a pause to consider the analogy between the soul's first glimpse of the Beatific Vision at its birth, and its fuller, though still momentary glance at the face of God, at the moment of death. The effect of the first is, that eternal craving after God of which St. Augustine spoke, et cor nostrum inquietum est donec requiescat in te. Thence also come ‘those 



---

p.133




winged ideas which are creation's essence;" ideas of the Good, the True, the Fair, the Just, the Pure, the Infinite,’ that form man's panoply of armour against the evils and temptations of life, and bring him scatheless and victorious before the face of God. We fear that Mr. de Vere here rather closely approaches that system of philosophy which originated with Malebranche, and which, adopted and developed by Gioberti, became known as Ontologism. Or, perhaps, we should rather say that this beautiful conception belongs to that milder system, which was favoured by Fénelon, Bossuet and Gerdil, and which traces the origin of universal ideas back to our first ideas of God. We merely allude to this matter, not to introduce a metaphysical discussion into these pages, but rather to point out an error which has been frequently made, even by those to whom Catholic literature might be supposed to have been familiar. Quite lately, in one of the many laudatory reviews which have appeared about a certain rising poet, the remark was made, that he was seeking subjects in the as yet untried fields of Catholic philosophy. Now, every reader knows, or ought to know, that for forty years the poet whom we are now reviewing has been taking subject after subject, not only from Catholic philosophy, but from Catholic theology; that his mind appears to be saturated with the lofty ideas that belong to these kindred sciences, that he has achieved his greatest successes exactly in these great departments of human knowledge, and that, unlike the fabled Antaeus, he has never lost strength but when he touched the earth — that is, worldly and ephemeral subjects. In his Legends he opens up a mine of theological subjects; in his May Carols he is perpetually in the society of the first Catholic thinkers and scientists; and even in his shorter poems he not only affects spiritual subjects, but enshrines the driest maxims of scholastic philosophy in lines that form musical apophthegms of themselves. How wise he has been in these selections we may hereafter see; but it is either a curious ignorance of contemporary poetry, or a still more curious forgetfulness, that attributes to a new poet, the attribute of pioneering all future Catholic singers into the fruitful regions of the purely Catholic sciences.


To return. Mr. de Vere, after discussing this delicate question of the origin of ideas, next turns to a still more complex and debatable problem, the Mystery of Pain, not with a view of reconciling the existence of sorrow with the existence of One, 



---

p.134



supremely good; but with a view of showing how great joy is consistent with great suffering — in a word, the meaning of the Beatitude: ‘Blessed are the mourners.’ He puts it pithily: —


> 1. The discipline of earthly pain suffices
>   
> To unfilm pure eyes to mysteries of grace
>   
> Withheld from worldly sight. Austerer pain
>   
> Unfilms them to the mysteries of glory:
>   
> Not servile pain, not selfish; greater pain
>   
> Born of a greater love.
> 




Then follows a description of what we might call the purification and elevation of a soul to a higher level of sanctity: and the education of all its faculties and their fullest development until they become proportioned to that spiritual universe which is man's destined heritage. Finally, the extinction of self-love — the complete divestment of the soul of all its selfish instincts, and the absolute subordination of all its faculties to the supreme will to which it is driven by irresistible impulse. Then these folds which sin and self-love have wound around the slumbering soul during life having dropped aside, and only its pure ethereal essence remaining, the final moment comes when it is admitted to the Beatific Vision. ‘Man's eyes are opened: man beholds his God.’


Altogether this poem is a very fine piece of spiritual writing. The subject was difficult in itself, and difficult of treatment, because it had already passed through the hands of Dante and Cardinal Newman, not to speak of lesser lights. And our author leaves the subject to future Catholic poets, its interest increased rather than diminished, and its importance very much enhanced by the light his pen has thrown upon the complex subjects that are connected with this Catholic dogma. In the Death of Copernicus our author grapples with a much more serious and difficult question. The great astronomer is debating on his death-bed whether he shall give to the world, or withhold, the work that, out of respect for the faith of the weak, he had hidden for thirty-six years. In the minds of the ignorant and the unthinking, then as now, science was supposed to be in conflict with faith, and their revelations to be mutually contradictory. The dying scientist soliloquizes that both revelations, proceeding from the same source, must of necessity be in agreement; but men's minds, warped by pride, and exalting their own poor discoveries, must perchance place in direct conflict teachings that 



---

p.135



come from the same Divine source. But he remembers how patient and lowly were his own thoughts during the progress of his discoveries; and he recalls his nightly vigils, from the Minster Tower at Warnia — vigils which so numbed his feet that he could scarcely ascend the altar steps in the morning, and his hands that he could hardly hold the chalice at the Mass. Yet he prayed: —


> 1. If, my God,
>   
> Thou seest my pride subdue my faculties,
>   
> Place me a witless one among those witless
>   
> That beg beneath church porches.
> 



But this night he must make his election — to fling his book abroad on the trackless deep, or to cast it on the still wider sea of men's minds. But he is scrupulous about the faith of others: and memories throng back upon his mind of doubts and difficulties that were suggested to him years ago by the timid and by the impious. The first was a youth, daring, yet afraid to utter that great objection against the Advent of Christ, which is the first to suggest itself to inquiring minds.


> 1. Mankind will learn
>   
> This sphere is not God's ocean, but one drop
>   
> Showered from its spray. Came God from heaven for that?
>   
> Speak no more words!
> 



It was but a passing word of a passing mood, and that youth held the Faith; but ‘moods have murdered souls.’ But what is the sublime answer? — 


> 1. This earth too small,
>   
> For Love Divine! Is God not Infinite?
>   
> If so, His Love is infinite. Too small!
>   
> One famished babe meets pity more from man
>   
> Oft than an army slain! Too small for Love!
>   
> Was earth too small to be by God created?
>   
> Why then too small to be redeemed?
> 2. The sense
>   
> Sees greatness only in the sensuous greatness;
>   
> Science in that sees little; Faith sees nought;
>   
> The small, the vast, are tricks of earthly vision
>   
> To God, that Omnipresent All-in-Each;
>   
> Nothing is small, is far.
> 



The second sceptic is different, —


> 1. A zealot barbed with jibe and scoff still launched
>   
> At priests and kings and holy womanhood.
> 




---

p.136




He puts his objection thus: —


> 1. A God, a God incarnate but for man,
>   
> That reasoning beast — and all yon glittering orbs
>   
> In cold obstruction left!
> 




Amongst our lengthened quotations, this the reply must be the last; but we cannot omit it: —


> 1. They that know not of a God
>   
> How know they that the stars have habitants?
>   
> 'Tis Faith and Hope that spread delighted hands
>   
> To such belief! no formal proof attests it.
>   
> Concede them peopled; can the sophist prove
>   
> Their habitants are fallen? That too admitted,
>   
> Who told him that redeeming foot divine
>   
> Ne'er trod those spheres? That flesh assumption granted,
>   
> What then? Is not the universe a whole?
>   
> Doth not the sunbeam, herald from the sun,
>   
> Gladden the violet's bosom? Moons uplift
>   
> The tides; remotest stars lead home the lost;
>   
> Judaea was one country, one alone;
>   
> Not less Who died there died for all. The Cross
>   
> Brought help to buried nations; time opposed
>   
> No bar to love; why then should space oppose one?
>   
> We know not what time is nor what is space;
>   
> Why dream that bonds like theirs can bind the unbounded!
>   
> If earth be small, likelier it seems that love
>   
> Compassionate most and condescending most
>   
> To sorrow's nadir depths, should choose that earth
>   
> For love's chief triumph, missioning thence her gift
>   
> Even to the utmost Zenith!
> 




We should hardly have given such extensive quotations, but to remark that here our author seems to have abandoned a very fascinating theory of a certain school of theologians, that sin was not the sole cause of the Incarnation, but that this great event in the history of the world would have taken place, if man had never sinned, in order that God might unite Himself thus more perfectly to His Creation. That this had been a favourite idea of Mr. de Vere's is quite evident from that splendid preface to the May Carols, which we commend to our readers, theological and otherwise, as an example of how beautifully Catholic philosophy and theology can be rendered by a poet. We shall not do our author the injustice of quoting it fragmentarily here, but merely refer our readers to it, and give the following sentences from an advocate of that sublime conception, the Oratorian, Malebranche, to elucidate



---

p.137



our meaning. ‘Though man had never sinned,’ he says, ‘a Divine Person would not have failed to unite Himself to the universe, to sanctify it, to draw it from its profane condition, to render it divine, to give it an infinite dignity, so that God, who can only act for His own glory, should receive a glory perfectly correspondent to His action. Could not the Word unite Himself to the work of God, without becoming incarnate? He was made man; could He not have made Himself of Angelic nature? It is true that, in making Himself man, He unites Himself at the same time to two substances, and that by this union He sanctifies all nature. For this reason, I know not if sin has been the sole cause of the Incarnation of the Son of God.’[23](javascript:footNote('E890000-023/note023.html')) To this sublime speculation, which Mr. de Vere embodied so beautifully in the prose of his preface, and in that exquisite carol, Caro factum est, he now, in the verses we have quoted above, adds the almost equally sublime speculation of another and later school of French theologians. This may be expressed by Fr. Gratry's theory that the words of our Divine Lord: — ‘I have other sheep who are not of this fold; these, too, I must bring into My fold, and there shall be one sheepfold and one Shepherd,’ may be possibly applied to the inhabited worlds of the universe.


It seems impossible to write about poetry of this high class without being tempted into a disquisition on theology. We have left ourselves, therefore, barely space to say that this sublime poem branches at once into a splendid forecast of the future of the Church, especially the conflict and reconciliation between Religion and Science. If these fine ideas had been put into eloquent prose, of which our author is quite the master, probably they would reach a larger number of readers. But for the many who will read them in this form, they will have the additional advantage of communicating knowledge in its most attractive guise.


Of the other poems, the pages devoted to ‘Joan of Arc’ and her marvellous history will take additional interest from the fact of her coming beatification. The volume closes with sonnets unvaried in form, but touching quite a variety of subjects and persons. Probably the purely poetic reader will turn to them first; and if he be a student of this most difficult, but most artistic form of poetry, he will be able to make a satisfactory comparison



---

p.138



between Mr. de Vere and all the many masters of the sonnet that have written in our century. Those on Catholic art and its masterpieces have had the greatest attraction for ourselves.


And this suggests a reflection with which we will close this paper. The two great Italian artists who seem to have a special fascination for even Protestant tourists are Giotto and Fra Angelico of Fiesole.[24](javascript:footNote('E890000-023/note024.html')) Yet they are the two artists who painted exclusively Christian and Catholic subjects. The crucifixions of the latter with all their boundless variety of imagery and detail are never-failing subjects of interest for exalted minds. And if ever the question should arise, has Mr. de Vere lost or gained by his exclusive devotion to religion? I think we might find the answer here. It is quite true that it is easier to write on secular than on religious subjects. It is much easier to compose a sonnet on the "Venus Anadyomene" than on the Madonna. And such writing would unquestionably be more popular in our days. Yet we make bold to say that if Mr. de Vere's works are now too high, too severe, too ascetic, or too exalted for the multitude, they will owe their permanent place in English literature (for such a place we can promise them) to this very fact, that they are Christian poetry and transcendently religious. For if ever (and many believe the delay will not be long) a revolution shall take place in public opinion, especially Irish public opinion, and that the educated classes in Ireland, rising far above the conventional ideas they have borrowed from English imitations and English intercourse, shall reject the Neo-Paganism of this century with all its tawdry finery and affected art, and a new taste be born for science that shall be Christian and art that shall be supersensual and moral, then we may be assured that in Mr. de Vere's work will be recognised in their fulness the true constituents of legitimate poetry, the pleasure of art and the profit of instruction; and in Mr. de Vere himself a rare combination of the qualities of teacher and singer to his age and race.


P.A. SHEEHAN









