

#History of the Commercial and Financial Relations between England and Ireland from the Period of the Restoration


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


History of the Commercial and Financial Relations between England and Ireland from the Period of the Restoration
================================================================================================================


Author: Alice Effie Murray
--------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber , Janet Crawford 

Funded by University College, Cork, via the President's Strategic Fund and  
Writers of Ireland Project 3. Third draft, with added bibliographical detailExtent of text: 157620 words#### Publication


CELT: Corpus of Electronic Texts: a Project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2006) (2010) (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900040Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Selected reading**2. Note: The author has compiled an extensive bibliography and index on pp. 445–467 and 469–486 of her work. This has in part been reproduced here.
3. A. E. Murray, 'After Limerick'. In: Studies in Irish history, 1649–1775. Being a course of lectures delivered before the Irish Literary Society of London, ed. O'Brien, R.B. (Dublin 1903), 289–352.
4. Maxine Berg, The first women economic historians, Economic History Review, XLV, 2 (1992), 308–329: 316f. (Thanks are due to Dr Andy Bielenberg for drawing my attention to this article.)
**Printed works mentioned in the text**2. Sir James Ware, The Historie of Ireland. (1633).
3. Gerard Boate, Ireland's Naturall History. (London 1652). Reprinted Dublin 1755 (the edition used by Murray.) Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan. (New York 2006).
4. William Smith, An Essay for the Recovery of Trade. (London 1661).
5. Sir William Petty, A Treatise of Taxes: Shewing the nature and measures of crown-lands, assessements ... etc. With several intersperst discourses and digressions concerning warres, the Church ... etc. the same being frequently applied to the present state and affairs of Ireland. (London 1662).
6. Roger Coke, A Discourse of Trade in two Parts. (London 1670).
7. Roger Coke, A Treatise wherein is demonstrated that the Church and State of England are in equal Danger with the Trade of it. (London 1671).
8. An Essay upon the Advancement of Trade in Ireland. (Dublin 1673).
9. Roger Coke, England's Improvement by Foreign Trade. (London 1675).
10. Roger Coke, How the Navigation of England may be Increased. (London 1675).
11. [Andrew Marvell], A Letter from a Gentleman in Ireland to his Brother in England relating to the Concerns of Ireland in the Matter of Trade. (London 1677).
12. John Collins, A Plea for the bringing in of Irish Cattel and keeping out of Fish caught by Foreigners. (London 1680).
13. Sir William Temple, An Essay upon the Advancement of Trade in Ireland, in: Miscellanea. (London 1680).
14. Sir William Petty, A discourse of taxes and contributions: shewing the nature and measures of crown-lands, assesments, customs, poll-moneys, lotteries, benevolence, penalties, monopolies, offices, tythes, hearth, excise, etc. with several intersperst discourses and digressions ... the same being frequently applied to the state and affairs of Ireland, and is now thought seasonable for the present affairs of England: humbly recommended to the present Parliament. (London 1689).
15. Sir Richard Cox, Hibernica Anglicana: History of Ireland from the English Conquest thereof to this present Time. (London 1689-90).
16. The Linnen and Woollen Manufactory discoursed with the nature of companies and trade in general: and particularly that of the companys for the linnen manufactory of England and Ireland: with some reflections how the trade of Ireland hath formerly, and may now, affect England. (London 1691).
17. William King, State of the Protestants of Ireland. (London 1691).
18. Sir William Petty, The Political Anatomy of Ireland. (London 1691).
19. Sir Josiah Child, Discourse on Trade. (London 1694).
20. An Answer to a Letter from a Gentleman in the Country to a Member of the House of Commons: on the votes of the 14th. Instant. Relating to the trade of Ireland. (Dublin 1698).
21. John Hovell, A Discourse of the Woollen Manufactury of Ireland and the Consequences of prohibiting its Exportation. (Dublin 1698).
22. Sir Francis Brewster, A Discourse concerning Ireland and the different Interests thereof. (London 1697/98).
23. Simon Clement, The Interest of England as it stands with relation to the Trade of Ireland considered. (London 1698).
24. William Molyneux, The Case of Ireland being bound by Acts of Parliament in England (1698, reprinted London 1770, with a new preface).
25. Sir William Petty, Several Essays in Political Arithmetic. (London 1699).
26. The Case of several Merchants trading to Ireland as well as the poor Linnen Weavers in the said Kingdom. (London 169?; reprinted 1705.)
27. John Cary, Some Considerations relating to the carrying on of the Linen Manufacture in the Kingdom of Ireland by a Joint Stock (London 1704).
28. Sir John Davies, A Discovery of the true Causes why Ireland was never entirely subdued. (London 1705).
29. Sir James Ware, Antiquities and History of Ireland (London 1705).
30. The case of the woollen manufacturers of Great Britain, and of the poor they imploy, in relation to a trade with France. [Petitions and Addresses to Parliament. II. Single Petitions and Addresses. 1713] (London 1713).
31. Daniel Defoe, A General History of Trade. Especially Considered as it affects the British Commerce. (London 1713).
32. William Wagstaffe, The State and Condition of our Taxes; or a proposal for a tax upon Funds. ... By a Freeholder . (Dublin 1714).
33. Considerations on the Duties laid in Ireland on Wool brought to England humbly submitted to the Parliament. (London 1715?/1721?).
34. Reasons humbly offered against laying a further Duty on Yarn imported from Ireland, (London 1718).
35. Jonathan Swift, A Proposal for the Universal Use of Irish Manufactures. (Dublin 1720).
36. Francis Seymour, Remarks on the Scheme for Supplying the City of Dublin with Coals from Co, Tyrone in a Letter by Francis Seymour to Thomas Burgh. (Dublin 1720) (Belfast 1729? according to COPAC).
37. [Aonon], The Case of the Printing of Linnen in Great Britain: as it particularly relates to the Printing of Linnens made in Scotland and in Ireland. (London 1720?).
38. Robert Lord Molesworth, Some Considerations on the Promotion of Agriculture. (Dublin 1723).
39. Sir Michael Creagh, Remarks upon Mr Wood's Coyn and Proceedings. (Dublin 1724).
40. Jonathan Swift, A Short View of the State of Ireland. (1728). (Online at CELT in file E700001-015).
41. [Sir John Browne,] Seasonable Remarks on Trade, with Some Reflections on the Advantages which might accrue to Great Britain by a proper Regulation of the Trade of Ireland. (1728).
42. Sir John Browne, An Essay on Trade in General and that of Ireland in particular, by the Author of "Seasonable Remarks". (Dublin 1728).
43. Daniel Defoe, Plan of English Commerce. (London 1728).
44. M. B. Draper, A Letter to the People of Ireland. (Dublin 1729).
45. Arthur Dobbs, An Essay on the Trade and Improvement of Ireland. (Dublin 1729), in: A Collection of the Tracts and Treatises illustrative of the Natural History, Antiquities and the Political and Social State of Ireland) Dublin 1860. Vol. II, 321-528).
46. Jonathan Swift, A Collection of Tracts concerning the Present State of Ireland. (1729).
47. Jonathan Swift, Drapier Letters. (Dublin 1729) [First edition 1725].
48. Thomas Prior, A List of the Absentees of Ireland, and the Yearly Value of their Estates and Incomes spent Abroad. With Observations on the present State and Condition of that Kingdom. (London 1729).
49. Joshua Gee, The Trade and Navigation of Great Britain considered. (1729).
50. Jonathan Swift, A modest Proposal for preventing the Children of Poor People from being a Burthen to their Parents or Country, and for making them Beneficial to the Publick. (Dublin 1729).
51. Some Thoughts on the Woollen Manufacture of England. (London 1731).
52. Benjamin Ward, The State of the Woollen Manufactures considered: the Reasons of its Declension assigned, and a Method to retrieve it. (London 1731).
53. The Advantages which may arise to the People of Ireland by Raising of Flax and Flax-seed considered, drawn up and published by the direction of the Dublin Society. (Dublin 1732).
54. Robert Ross, Some Considerations on the Improvement of the Linen Manufacture in Ireland, particularly with relation to the Raising and Dressing of Flax and Flax-Seed. (Dublin 1735).
55. Fynes Moryson, An History of Ireland from the year 1599 to 1603. (Dublin 1735).
56. [Anon.], The Case of the British and Irish Manufacture of Linnens, Threads, and Tapes fairly stated; in Answer to the Impartial Considerer. (London 1736/1738(?))
57. An Argument upon the Woollen Manufacture of Great Britain, plainly demonstrating that Ireland must be speedily employed therein. (1737).
58. Some Thoughts on the Tillage of Ireland ... to which is prefixed a Letter to the Printer from Dr. Swift ... recommending the following Treatise. (London 1737).
59. Samuel Madden, Reflections and Resolutions proper for the Gentlemen of Ireland. (Dublin 1738).
60. The Earl of Strafforde's Letters and Despatches. (London 1739).
61. Samuel Webber, A short Account of the State of our Woollen Manufacturies, from the Peace of Ryswick to this Time. (London 1739).
62. Four Letters, originally written in French, relating to the Kingdom of Ireland. (Dublin 1739).
63. Samuel Webber, The Consequences of Trade as to the Wealth and Strength of any Nation. (London 1740).
64. John London, Some Considerations on the Importance of the Woollen Manufactures. (London 1740).
65. The Groans of Ireland in a Letter to a Member of Parliament. (Dublin 1741).
66. Dissertation on the Enlargement of Tillage. (Dublin 1741).
67. Joshua Gee, An Impartial Enquiry into the Importance and Present State of the Woollen Manufactories of Great Britain. (London 1742).
68. John Smith, The Grasiers Advocate, or Free Thoughts of Wool and the Woollen Trade. (London 1742).
69. Thurloe, Collection of State Papers. 7 vols. Edited by Thomas Birch. (London 1742).
70. An Enquiry how far it might be expedient to permit the Importation of Irish Cattle. With several Judgements of Sir William Temple and Mr. Locke in reference thereto. (London 1743).
71. Charles Smith, Antient and Present State of the County and City of Waterford. (Dublin 1746).
72. Joseph Smith, Memoirs of Wool. (London 1747).
73. Thomas Prior, An Essay to encourage and extend the Linen-Manufacture in Ireland by Premiums and other Means. (Dublin 1749).
74. Matthew Decker, An Essay on the Causes of the Decline of the Foreign Trade, consequently in the Lands of Britain, and on the Means to restore both. (Dublin 1749).
75. Charles Smith, Antient and Present State of the County and City of Cork. (Dublin 1750).
76. Charles Smith, Antient and Present State of the County of Kerry. (Dublin 1750).
77. [Anon.], Considerations on the woollen and other manufactures of Great-Britain : intended as a supplement to Mr. Gee's discourse on the trade and navigation of this kingdom : and divided into three parts. Part 1 Containing general remarks on the danger with which the woollen manufacturers of Great Britain are threatened by... as also, on the running of English and Irish woo l... By Mr. D--- (London 1751).
78. J. G., An Appeal to Facts; regarding the Home Trade and Inland manufactures of Great Britain and Ireland. (London 1751).
79. George Berkeley, The Querist, containing several Queries Proposed to the Consideration of the Public. (Dublin 1752). In: A Collection of the Tracts and Treatises illustrative of the Natural History, Antiquities and the Political and Social State of Ireland. Dublin 1861. Vol. II, 143-202).
80. Richard Parrott, Reflections on various subjects relating to arts and commerce : particularly, the consequences of admitting foreign artists on easier terms. (London 1752).
81. Gorges Edmond Howard, A short Account of His Majesty's hereditary Revenue in the Kingdom of Ireland. (Dublin 1753).
82. Gerard Boate, Natural History of Ireland. In three Parts. By Dr. G. Boate, T. Molyneux, and Others. (Dublin 1755).
83. Edmund Burke, An Account of the European Settlements in America. (London 1757).
84. Considerations on the revenues of Ireland: Shewing, the right, justice, and necessity, of now applying the duties granted there for guarding of the seas, to naval services ... (London, printed for M. Cooper, 1757).
85. Robert Stephenson, An inquiry into the State and Progress of the Linen Manufacture of Ireland, in which will be found Remarks on the principal Transactions of the Trustees of the Linen Board. (Dublin 1757).
86. An Essay on the Antient and Modern State of Ireland. (Dublin 1759).
87. Richard Cox, The present State of His Majesty's Revenue (in Ireland) compared with that of some late Years. (1762).
88. Edmund Spenser, View of the State of Ireland. (Dublin 1763).
89. Alexander McAulay, Enquiry into the Legality of Pensions on the Irish Establishment. (Dublin 1763).
90. John Bush, Hibernia Curiosa, a letter from a gentleman in Dublin, to his friend at Dover in Kent: giving a general view of the manners, customs, dispositions, &c. of the inhabitants of Ireland [...] collected in a tour through the kingdom in the year 1764, ornamented with a map of the city of Dublin and several copper plates. (Dublin 1769).
91. Thoughts English and Irish on the Pension List of Ireland. (London, printed for George Kearsly, 1770).
92. Charles D'Avenant, The Political and Commercial Works of Charles D'Avenant relating to the Trade and Revenue of England, the Plantation Trade, the East India Trade, and the African Trade. Collected and revised by Sir C. Whitworth. (London 1771).
93. John Dalrymple, Memoirs of Great Britain and Ireland. (Dublin 1771).
94. John Lodge, Desiderata Curiosa Hibernica: or, a select collection of state papers and historical tracts, ... illustrating the political systems of the Government of Ireland during the reigns of Elizabeth, James I. and Charles I. (Dublin 1772).
95. John Curry, Observations on the Popery Laws. (London 1772).
96. Thomas Leland, The History of Ireland from the Invasion of Henry II. (London 1773).
97. Lord George Macartney, An Account of Ireland in 1773. (London 1773).
98. William Cavendish, Letters which passed in Great Britain relative to the Absentee Tax. By William Cavendish, fifth Duke of Devonshire. (Dublin 1773).
99. William Crawford, A History of Ireland from the Earliest Period to the Present Time. 
(Dublin 1773).
100. Observations on the Report from the Committee appointed to enquire into the State of the Linnen Trade in Great Britain and Ireland. (London 1774?)
101. [Anon.], A Letter to the People of Ireland on the Subject of Fisheries. (Dublin 1775).
102. Richard Twiss, A Tour in Ireland in 1775. (London 1776).
103. Adam Smith, An Inquiry into the Nature and Causes of the Wealth of Nations (London 1776).
104. [Thomas Campbell], A Philosophical Survey of the South of Ireland in a Series of Letters to John Watkinson. (London 1777).
105. John Gray, A Comparative View of the Public Burdens of Great Britain and Ireland. (London 1778).
106. William Knox, Considerations on the State of Ireland. (Dublin 1778).
107. Henry Flood, A Letter to the People of Ireland on the Expediency and Necessity of the Present Associations in Ireland in Favour of Our Own Manufactures. (Dublin 1779).
108. John Hely Hutchinson, Commercial Restraints of Ireland. (Dublin 1779).
109. Sir James Caldwell, Enquiry into the Restrictions on the Trade of Ireland. (Dublin 1779).
110. Thoughts on the Inexpediency of Continuing the Irish Woollen Warehouse as a Retail Shop. (Dublin Society) (Dublin 1779).
111. Frederic Jebb, Guatimozin's letters on the present state of Ireland, and the right of binding it by British acts of Parliament, etc. (London 1779).
112. Thomas Stanley, Impartial Thoughts on a Free Trade to Ireland: in a letter to the Right Hon. Frederick, Lord North (London 1779).
113. [Thomas Campbell], A view of the present state of Ireland, containing observations ... intended for the consideration of Parliament, on the approaching enlargement of the trade of that kingdom: to which is added, A sketch of some of the principal political characters in the Irish House of Commons ... (London 1780).
114. Philip Luckombe, A Tour through Ireland wherein the present State of that Kingdom is considered. (London 1780; first published London 1748).
115. Arthur Young, A Tour in Ireland, with General Observations on the Present State of that Kingdom made in the years 1776, 1777, and 1778, and brought down to the end of 1779. London, 1780. (A version is available online at CELT.)
116. [Anon.], Thoughts on the establishment of new manufactures in Ireland, occasioned by the late freedoms we have obtained: With an account of the Manchester manufactury, established by Mr. Brooke. Written by a friend of his in the county of Kildare. (Dublin 1783).
117. William Crawford, A History of Ireland from the Earliest Period to the Present Time. (Dublin 1773).
118. Precedents and Abstracts from the Journals of the Trustees (of the Linen and Hempen Manufactures) to the Twenty-fifth of March, 1737. (Dublin 1784).
119. Josiah Tucker, Reflections on the Present Matters in Dispute between Great Britain and Ireland. (London 1785).
120. William Burton Conyngham [compiler], Extracts relative to the Fisheries on the North West Coast of Ireland. (London 1785). [By the British Parliament, House of Commons]
121. John Sheffield, Observations on the Manufactures, Trade, and Present State of Ireland. (London 1785).
122. George Rose, The Proposed System of Trade with Ireland explained. (London 1785).
123. A Reply to the Treasury Pamphlet entitled "The Proposed System of Trade with Ireland explained." 
(London 1785).
124. An Answer to the Reply to the supposed Treasury Pamphlet (entitled "The Proposed System of Trade with Ireland explained"). (London 1785).
125. [Anon], Iron Trade: England and Ireland. (London? 1785?)
126. James Laffan, Political Arithmetic of the Population, Commerce, and Manufactures of Ireland. (Dublin 1785).
127. Woodfall's Debates in the Irish House of Commons, August, 1785. Dublin, 1785.
128. The Speech of the Right Hon. C. J. F. (Fox) in the House of Commons on the Irish Resolutions, May 12th, 1785. London, 1785.
129. Mr. Fox's Reply to Mr. Pitt upon Reporting the Fourth Proposition of the Irish System, May 31st, 1785. (London 1785).
130. Mr. Pitt's Reply to Mr. Orde, being a correct Abstract of the Speeches of those Gentlemen as delivered in the different Senates of Great Britain and Ireland on the Subject of the New Commercial Regulations between 
the two Countries. (Dublin 1785).
131. [Anon.], A Candid Review of Mr. Pitt's Twenty Resolutions addressed to the People of Ireland. (London 1785.)
132. Sir Lucius O'Brien, The Resolutions of England and Ireland relative to Commercial Intercourse between the two Kingdoms. (Dublin 1785).
133. George Chalmers, A Short View of the Proposals lately made for the Final Adjustment of the Commercial System between Great Britain and Ireland. (London 1785).
134. Henry Redmond Morres, Viscount Mountmorris, Impartial Reflections upon the Question of Equalising the Duties upon the Trade between Great Britain and Ireland. (London 1785).
135. The Resolutions of England and Ireland relative to a Commercial Intercourse between the two Kingdoms, containing: I. The Eleven Resolutions of the House of Commons of Ireland; II. Resolutions of the Commons (England); III. A Bill for Finally Regulating the Intercourse and Commerce. (London 1785).
136. The Present Politics of Ireland, consisting of: I. The Right Hon. Mr. Hutchinson's Letter to his Constituents at Cork; II. Parliamentary Discussions of the Irish Arrangements by Messrs. Conolly, Grattan, and Flood against them, Fitzgibbon, Mason and Hutchinson for them; III. Mr. Laffan's Observations on the Relative Situation of Great Britain and Ireland. With notes thereon by an English Editor. (London 1786).
137. [Anon.], Considerations on the Political and Commercial Circumstances of Great Britain and Ireland. (London 1787).
138. Sir Henry Cavendish, A Statement of the Public Accounts of Ireland. (London 1791).
139. R. V. Clarendon, A Sketch of the Revenue and Finances of Ireland: and of the appropriated Funds, Loans and Debt of the Nation from their Commencement; the whole illustrated with charts. (London 1791).
140. Henry Redmond Morres, Viscount Mountmorris, The History of the Principal Transactions of the Irish Parliament from 1634–1666. (London 1792).
141. Samuel Crumpe, An Essay on the Best Means of Providing Employment for the People. (London 1793).
142. T. D., Ireland's Mirror: exhibiting a Picture of her present State, with a glimpse of her future Prospects. Also, cursory Observations on the alarming Measures now going forward (Dublin 1795).
143. James Mullala, View of Irish Affairs since the Revolution of 1688. (Dublin 1795).
144. Denis O'Bryen, A View of the Present State of Ireland, with an account of the Origin and Progress of the Disturbances in that country: and a narrative of Facts, addressed to the People of England. By an Observer. (London 1797).
145. Report of Debates in the House of Commons in Ireland, Session 1796–7. (Dublin 1797).
146. Denis Taaffe, The Probability, Causes, and Consequences of an Union between Great Britain and Ireland Discussed. (Dublin 1798).
147. Thomas Wallace, An Essay on the Manufactures of Ireland: in which is considered, to what Manufactures her natural Advantages are best suited; and what are the best Means of Improving such Manufactures. (Dublin 1798).
148. A View of the Present State of Ireland. (London 1799)
149. [Irish Bar], A Report of the Debate of the Irish Bar ... on the Subject of an Union of the Legislatures of Great Britain and Ireland. (Dublin 1799).
150. Proceedings at a Meeting of the Gentlemen, Clergy, and Freeholders of the County of Dublin, on Friday, January 4th, 1799, to take into consideration the Measure of a Legislative Union between this Country 
and Great Britain. (Dublin 1799).
151. The Commercial System of Ireland Reviewed, and the Question of Union discussed. (Dublin 1799).
152. Speech of the Right Hon. John Foster delivered 11th April, 1799. (Dublin 1799).
153. Observations on that part of the Speaker (J. F.)'s Speech (on the Union) which relates to Trade. (Dublin 1799).
154. Robert Stweart, second Marq. of Londonderry, The speech of ... lord viscount Castlereagh, upon delivering to the House of commons of Ireland ... the lord lieutenant's message on the subject of an incorporating union with Great Britain. February 5th, 1800. (Dublin 1800).
155. Speech of the Right Honorable John Foster, Speaker of the House of Commons of Ireland, delivered in Committee on Monday, 17th February, 1800. (Dublin 1800).
156. A Report of the Debate in the House of Commons of Ireland on Wednesday and Thursday, the 15th and 16th of January, 1800, on an Amendment to the Address moved by Sir Laurence Parsons, Baronet, on the Subject of an Union. (Dublin 1800).
157. A Report of the Debate in the House of Commons of Ireland, on Wednesday and Thursday, the 5th and 6th of February, 1800, on delivering a Message from His Majesty on an Union. (Dublin 1800).
158. The Speech of the Right Hon. John, Earl of Clare, Lord High Chancellor of Ireland, in the House of Lords of Ireland, on a Motion made by him on Monday, February 10th, 1800 (in favour of an Union). (Dublin 1800).
159. G. T. Stokes (ed), Pococke's Tour in Ireland in 1752. (Dublin 1891).
160. Statistical Surveys of Twenty Irish Counties, published by Order of the Dublin Society. (Dublin 1802–12).
161. Francis Plowden, Historical Review of the State of Ireland. (London 1803).
162. Sir John Sinclair, The History of the Public Revenue of the British Empire. Vol. III. (Third Edition. London 1803–1804).
163. Thomas Newenham, A Statistical and Historical Enquiry into the Progress and Magnitude of the Population of Ireland. (London 1805).
164. David Macpherson, Annals of Commerce, Manufactures, Fisheries, and Navigation. (London 1805).
165. (W. S.) Hathaway (ed), The Speeches of William Pitt in the House of Commons. (London 1806).
166. William James McNeven, Pieces of Irish History. (New York 1807).
167. Francis Plowden, The History of Ireland from its Invasion under Henry II. to the Union with 
Great Britain. (London 1809).
168. Thomas Newenham, View of the Natural, Political, and Commercial Circumstances of Ireland. (London 1809).
169. Horace Walpole, Memoirs of the Reign of King George the Second. (London 1846).
170. Isaac Butt, A Voice from Ireland; or, the Famine in the Land. What has been done and what is to be done. (Dublin 1847).
171. William Thomas Thornton, A Plea for Peasant Proprietors, with the Outlines of a Plan for their Establishment in Ireland. (London 1848).
172. Robert Stweart, second Marq. of Londonderry, Memoir and Correspondence of Viscount Castlereagh, second Marquis of Londonderry. (London 1848-53).
173. Thomas Carte, The Life of James, Duke of Ormonde. With an Appendix and Collection of Letters. (Oxford 1851). [First published 1735, entitled 'History of the Life of James, Duke of Ormonde', reprinted London 1747].
174. George Thomas Keppel, Earl of Albemarle, Memoirs of the Marquis of Rockingham and his Contemporaries. (London 1852).
175. Sir Jonah Barrington, Rise and fall of the Irish Nation. (Dublin 1853).
176. Sir George Nicholls, History of the Irish Poor Law. (London 1856).
177. Horace Walpole, Journal of the Reign of King George the Third from the Year 1771 to 1783. (London 1859).
178. John Ramsay MacCulloch (ed), A Select Collection of scarce and Valuable Tracts on Commerce. (London 1859).
179. Charles Ross (ed), Correspondence of Charles, first Marquis Cornwallis. (London 1859).
180. Debt and Taxation of Ireland (reprinted from the Irish Quarterly Review for January, 1860) (Dublin and London 1860).
181. Goldwin Smith, Irish History and Irish Character. (Oxford 1861).
182. William Eden, first Baron Auckland, The Journal and Correspondence of William, Lord Auckland. Edited by the Bishop of Bath and Wells. (London 1861-62).
183. Samuel Smiles, The Huguenots; their Settlements, Churches, Industries in England and Ireland. (London 1867).
184. James Godkin, Ireland and her Churches. (London 1867).
185. Isaac Butt, The Irish People and the Irish Land. (Dublin 1867).
186. Life, Letters, and Speeches of Lord Plunket, with a Preface by Lord Brougham. (London 1867).
187. William John Fitzpatrick, Curious Family History; or, Ireland before the Union. (Dublin 1869).
188. John Nicholas Murphy, Ireland;: Industrial. Political and Social. (London 1870).
189. James Roderick O'Flanagan, The Lives of the Lord Chancellors and Keepers of the Great Seal of Ireland, from the earliest times to the reign of Queen Victoria. (London 1870).
190. William Edward Hartpole Lecky, Leaders of Public Opinion in Ireland. New edition, revised and enlarged. (London 1871).
191. John Elliott Cairnes, Political Essays. (London 1873).
192. Edmund Burke, Letters, Speeches, and Tracts on Irish Affairs. Edited by Matthew Arnold. (London 1881).
193. William Anderson O'Connor, History of the Irish People. (Manchester 1882).
194. Stephen Dowell, A History of Taxation and Taxes in England. (London 1884).
195. Bowles Daly, Ireland in the Days of Dean Swift. (London 1887).
196. [Various authors], Two Centuries of Irish History, 1691–1870. With Introduction by James Bryce, M.P. (London 1888).
197. Bowles Daly, Glimpses of Irish Industries. (Dublin 1889).
198. Thomas Dunbar Ingram, A History of the Legislative Union of Great Britain and Ireland. (London 1890).
199. The Industries of Ireland. Part I, Belfast and towns of the North, the provinces of Ulster and Connaught: business men and mercantile interests, wealth and growth: historical, statistical, biographical: illustrated. (London 1891).
200. Thorold Rogers, The Industrial and Commercial History of England. (London 1892).
201. William Cunningham, The Growth of English Industry and Commerce. (Cambridge 1892).
202. William Edward Hartpole Lecky, History of England in the Eighteenth Century. (London 1892).
203. William Edward Hartpole Lecky, History of Ireland in the Eighteenth Century. (London 1892).
204. Thomas Wrigley Grimshaw, Facts and Figures about Ireland. (Dublin and London 1893).
205. Edmond George Petty Fitzmaurice, Life of Sir William Petty. (London 1895).
206. Charles Francis Bastable, Public Finance. (London 1895).
207. Rev. Father T. A. Finlay, Agricultural Co-operation in Ireland. Economic Journal, Vol. VI. 1896.
208. C. F. Bastable, Ireland's Place in the Financial System of the United Kingdom. Economic Journal, Vol. VI. 1896.
209. The Over-Taxation of Ireland: a Record of the City and County Meetings; the Declarations of Public Bodies, Chambers of Commerce, Political Conventions, and British Statesmen on the financial relations between Great Britain and Ireland. Reprinted from the Freeman's Journal. (Dublin 1897).
210. The Over-Taxation of Ireland. Speech delivered by the Hon. Edward Blake, M.P., in the House of Commons 29th March, 1897. (Dublin 1897).
211. R. Clancy, The Financial Grievance of Ireland.Nineteenth Century. (December 1897).
212. Thomas Lough, England's Wealth and Ireland's Poverty. (London 1897).
213. Adolph Heinrich Gotthelf Wagner, Grundlagen der politischen Ökonomie. 1. Theil: Grundlagen der Volkswirthschaft. (Leipzig 1882).
214. James Carty (comp. and ed.), 'Ireland: from the flight of the earls to Grattan's parliament (1607–1782): a documentary record (Dublin 1949).
215. Thomas Carte, Life of James, duke of Ormond (London 1736).
**The edition used in the digital edition**2. A History of the Commercial and Financial Relations between England and Ireland from the Period of the Restoration. Alice Effie Murray Second edition 1907 [9 + 486 pp. 1–438 text; 439–444 appendices; 445–467 bibliography; 469–486 index.] P.S. KingLondon (1907) (First published 1903; reprinted New York: Burt Franklin 1970) . Studies in economics and political science. , No. 13#### Notes

Note on the author: Alice Effie Murray, born 1877 in West Bengal, India, and attended Girton College, Cambridge, at a time when Cambridge University did not confer degrees to women. (This policy continued until 1922.) A. E. Murray was awarded a research studentship at the London School of Economics. She was the first woman to receive a degree from LSE, that of D Sc. Econ., in 1902–03. When she married, she changed her surname to Radice, and it is thought that she published no more. She died in 1951. (This information is taken from Maxine Berg, 'The first women economic historians', Economic History Review, XLV, 2 (1992), 308–329: 316f., and was kindly provided to CELT by Dr Andy Bielenberg.)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition represents the preface (pp 5–9), main body (1–438) and appendix 1 (439–444) of the text. All footnotes are included and tagged *note type="auth" n=*. They are included in the wordcount above.


#### Editorial Declaration


##### Correction


The text has been proof-read twice.


##### Normalization


The electronic text represents the edited text. Text in Latin, French and German is marked as such. Normal CELT conventions have been applied in regard to spelling. Obvious errors are corrected, and marked corr. Some spelling peculiarites are regularized using the reg tag. The original is given in the orig attribute of the SGML/XML file. In the tables, the hard copy edition uses fractions which have been converted into decimal values.


##### Quotation


Direct speech and quotations have not been tagged. This is envisaged at a future date.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the monograph; div1=the chapter; page-breaks are marked pb n="".


##### Interpretation


A selection of personal names, with their roles in society, are tagged.


#### Canonical References


This text uses the DIV1 element to represent the Chapter. ### Profile Description


Created: Date range: 1899-1902.#### Use of language


##### Language: [EN] Text is in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [FR] Some words and phrases are in French.


##### Language: [DE] A book title is in German.


### Revision History


* (2017-02-02) Beatrix Färber (ed.)

* Markup of personal names refined and addition made to bibliography.
* (2014-04-04) Beatrix Färber (ed.)

* More personal names identified; file re-parsed; new SGML and HTML files created.
* (2014-03-20) Beatrix Färber (ed.)

* Book titles mentioned in footnotes encoded. Footnotes renumbered, tagging of personal names completely revised and improved; bibliographic references checked and added.
* (2010-04-10) Beatrix Färber (ed.)

* Conversion script run; header updated; new wordcount made; file parsed.
* (2008-08-29) Beatrix Färber (ed.)

* File validated.
* (2008-07-30) Ruth Murphy (ed.)

* Keywords added.
* (2008-07-19) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, 'creation' tags inserted, content of 'langUsage' revised; minor modifications made to header.
* (2006-07-25) Beatrix Färber (ed.)

* File parsed; appendix proofed, tables integrated and marked up; names and organsations marked up; header constructed.
* (2006-07) Michelle O'Halloran (ed.)

* Pages 372–386 proofed (1) and marked up.
* (2006-06) Beatrix Färber (ed.)

* Header created; whole text proofed (1; 2) and marked up; second proofing of pp. 187–231; 264–295; 372–386; tables marked up; footnotes integrated.
* (2006-06) Janet Crawford (ed.)

* Pages 187–231; 264–295 proofed (1) and marked up.
* (2006-05) Beatrix Färber (text capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E900040


### History of the Commercial and Financial Relations between England and Ireland from the Period of the Restoration: Author: Alice Effie Murray




---

p.5


### Preface


Miss Murray's History of the Commercial and Financial Relations between England and Ireland is the result of her investigations since her election to a research studentship at the London School of Economics. The statutes of the University of London provide that students of other approved Universities who have passed the examinations required for a degree may present themselves for the doctorate after a period of not less than two years spent in research as ‘Internal Students’ of the University, and Miss Murray's distinguished career at Girton College, Cambridge, was an admirable qualification both for the grant of this privilege and for the special work which she selected as the subject of her thesis. She was one of the two women students who were the first to obtain the doctorate in the Faculty of Economics and Political Science. I am the more pleased to contribute a preface to her work because I have long believed that the difficulties of Ireland are due to economic rather than religious or political causes, though in times past, at any rate, the reaction of the latter on the economic development of Ireland



---

p.6



and its relations with England has certainly been unfavourable in its effects. I therefore welcome every attempt to set forth in an impartial manner the main features of Irish economic history, whether or not I agree with the opinions of the author. There is scarcely any subject of which we are more ignorant or the study of which is more likely to correct extravagant views of British genius in the sphere of economic statesmanship.


The fact that Miss Murray's work won the approval of two such high authorities on the subject of it as Sir Robert Giffen and Prof. C. F. Bastable is sufficient evidence of its value. She has not only made use of the available materials, both books and documents, which are in print, but she has incorporated the results of much original research amongst English and Irish manuscript sources. Most of the difficulties, of an economic character, in the financial relations between England and Ireland arise from the differences of economic structure and organisation between the two countries. If Ireland were a highly-organised, populous, manufacturing country, the present fiscal system would probably work out no worse than it does in the urban districts of Great Britain. But whatever be the virtues or the demerits of that system, it was certainly not framed with any reference to the economic conditions which prevail in Ireland. In order to 



---

p.7



 
explain the present position, Miss Murray has reviewed the Irish economic policy of the British Government, and its effects, since the middle of the 17th century.


A purely ‘national’ policy, that is a policy directed solely to the development of Ireland considered as a separate entity, has never been possible, and is never likely to be possible. But, historically speaking, there were two lines of development, either of which would probably have been more favourable to Ireland than the one actually followed. It is not unusual to attribute the restraints on Irish trade, described by Miss Murray, to the mercantile system. That is no doubt true in the sense that the expedients adopted in the case of Ireland fall into line, so far as their general features are concerned, with other wellknown measures of the mercantilist r�gime. But it will be seen from Miss Murray's history that Ireland was in a less favourable position than that of an English colony. If Ireland could have been treated as a colony in the earlier period reviewed by Miss Murray it would have occupied no unworthy place in the general scheme of British policy, and would no doubt have attained considerable wealth and prosperity. The second course favourable to Irish development would have been to adopt, from the first, a policy of consolidation with England. That neither of these courses was followed was



---

p.8



due, no doubt, partly to religious and political causes into which I need not enter, but far more to the narrow conception of national interests which then, and in more recent times, dominated English economic policy. If Irish development could have been promoted pari passu with that of England, and Great Britain and Ireland gradually welded together in a real economic union, there can be no doubt that the industrial and commercial position of the United Kingdom would have been far more secure than it is at the present time. The Free Trade movement, favourable as it was to the growth of English manufactures, was based upon even a narrower conception of English interests than that of the mercantile system, and Ireland has fallen farther and farther behind England. Ireland is, in fact, recognised as a standing exception to the economic generalisations which we so freely apply to England, and when we discuss the probable effects of a change in British policy we rarely if ever take account of Ireland, unless, of course, we happen to be politicians. This economic estrangement and relative decline of Ireland must necessarily be a source of weakness to the United Kingdom. It practically means that the Union is merely political, and therefore unstable. Moreover, the differences between England and Ireland are of such an organic character that financial comparisons based upon



---

p.9



such abstractions as ‘taxable capacity’ cannot fail to be misleading. It is time that we abandoned the financial ideals of the 18th century and endeavoured to solve the economic problems of the United Kingdom by substituting the study of the concrete conditions of its constituent parts for the pursuit of abstract principles which have no relation to any particular country. The financial relations of a country are merely the reflex of its economic and commercial system, and the problem we have to solve in the case of Ireland is in reality how to bring that country into the current of the life and movement of the other parts of the United Kingdom and the Empire at large.


W. A. S. HEWINS.
September 30th, 1903.


---

p.1


Introductory
------------


Ireland Past and Present — Object of the Monograph — Early Commercial
Relations between England and Ireland — The Mercantile
System and its peculiar Rearing on Ireland — Estimate of English
Policy.
There is no country in the civilised world with such a melancholy history as Ireland. From the time when she first enters as a tangible factor into English history until the closing years of the eighteenth century the prevailing note is one of gloom. The one bright spot in the darkness is the brief period of legislative independence. Then Ireland suddenly becomes a nation; then she has statesmen, and heroes, and patriots; then for the first time there seems to be a chance of Roman Catholics and Protestants sinking their differences and becoming one in their love of Ireland and their love of liberty. But it was not to be. Nothing can be more sad than to study the dark and terrible events, the intrigues and deceits, the religious hatreds deliberately stirred up, the savage ferocity of both races and both religions — all the disastrous sequence of events that led almost inevitably to the Legislative Union.


And, since the Union, has the condition of Ireland become more hopeful? Have the links which bind her to Great Britain become stronger? Has the national character improved? Unfortunately, one at least of these questions



---

p.2



must be answered in the negative. The Union has proved but a union of legislatures — not one of hearts, nor even one of interests. It is often asked why this should be so; but, like many things in history, it is capable of a simple explanation, and is the result of the operation of definite causes. The chief point to be noticed is that the Union was carried against the wishes of the majority of the Irish people. But even this great weakness of the Union might have been remedied, and the Union itself made acceptable to the bulk of the people, if Catholic emancipation had been immediately granted. The British Ministry either could not or would not fulfil the virtual promise they had made, and after the Union, as before, Ireland remained wretched and disaffected. When Catholic emancipation at last came it came too late; the gift had lost its grace, and was powerless to remove the terrible bitterness that religious persecution had caused.


It is the standing tragedy of Irish history that England has always made her concessions too late, and not until she has been forced to do so. It was a misfortune for both countries that Ireland continued to be treated as a dependency after the Union. The Church of the small minority remained the Established Church, all the remedies called for by the economic miseries of the country were refused, practical justice was denied, and the people were embittered and alienated by severe coercion Acts. What wonder then that the Union, instead of becoming more acceptable to the people, came to be more and more hated by them?


It is, of course, true that all this is now over. Since 1870, as Irishmen admit, Great Britain has, generally speaking, tried to do her best. She has acted towards Ireland according to her lights, and she has effected many and great improvements. And yet the result has not been to draw Ireland more closely to England. It may be that sufficient time has not elapsed to soften bitter resentments; it may be that from every point of view the Union was a



---

p.3



mistake. It was certainly carried at the wrong time and by very questionable methods. It has not proved advantageous to Ireland; for it has destroyed the patriotism of the upper classes, alienated them from the people, and thrown the country into the hands of political agitators and demagogues. And at the same time it has not been beneficial to Great Britain. Whether the repeal of the Act of Union at the present day would be even less beneficial it is impossible to say. Every year that has elapsed since the Union has made its repeal more difficult, and yet, in the opinion of some, more inevitable.


Economically speaking, the interests of England and Ireland have never been further apart than at the present time. It is this divergence of economic interests which now keeps the two countries in many ways so separate. The sentiment of Irish nationality is no doubt strong, and the temperament of the people is such that an Irish farmer or peasant will willingly give up material interests for the sake of political ideals. Still, it is poverty that is at the root of the present troubles, the real reason why political agitation is so successful. The absence of strong material bonds between England and Ireland is the reason why Ireland, in spite of the confident prophecies of the supporters of the Union, has not greatly prospered from her closer connection with Great Britain. At first sight, indeed, it might appear that the economic condition of the Irish people has not substantially improved during the last hundred years. The great provision trade of the eighteenth century has decayed, and only quite recently has there arisen a prospect of its revival. Free Trade, which gave cheap bread to English artisans, and an enormous impetus to the commercial prosperity of the country, only brought ruin to Irish industries and agriculture. Irish manufacturing industry still concentrates itself in the north, hardly spreading beyond certain districts; emigration has been draining Ireland of her population for more than half a century; the class of absentees is



---

p.4



far larger than it was before the Union. The great commercial expansion of the nineteenth century has conferred little benefit on Ireland; it has merely resulted in an increase of taxation to support a trade in which she has little share. And yet it is untrue to say that Ireland, materially speaking, has gone back or has even stood still during the last century. Her progress has indeed been slow, slower than in any other civilised country in Europe. But there has been some rise in the standard of comfort of all classes of the community. Just now there is something of an industrial revival taking place, while the co-operative movement is conferring great benefits on Irish agriculture. It is only necessary to go to Ireland to-day and contrast the condition of the people with that which **Arthur Young** describes in his Tour in 1776, in order to realise that there are elements of prosperity in the country.


The object of the present sketch is to give a plain historical account of the commercial and financial relations between England and Ireland from the period of the Restoration; to show how these relations have powerfully reacted on the history of the two countries and on their political life; to explain how the commercial policy of England affected the economic condition of Ireland, and, by throwing the mass of the people on the land, aggravated the later agrarian troubles; to set forth how this same commercial policy, combined with the Penal Laws, caused a grievous deterioration of the national character, to which even the present poverty and backwardness of Ireland may be traced. Few attempts have been made to estimate at all accurately the effect of the restrictions placed by England on Irish trade and commerce. From a historical point of view such an estimate is important. From the point of view of the practical man it may prove to be of even great importance; for the effects of those commercial restrictions are still with us, and may be seen partly in the actual condition of the



---

p.5



people, partly in their heritage of hatred to the law, and suspicion of England.


An investigation of the early financial relations between England and Ireland will reveal the liberality of the latter country towards the needs of the Empire, while it sets forth in its full light the extraordinary corruption practised by the Government in Ireland. Since the Union the financial relations of the two countries have from time to time created much discussion. There has been some confusion of thought on the subject, owing to the fact that the problem may be considered from two points of view. The taxation of Ireland may be regarded as a whole; that is to say, Ireland may be taken as a geographical entity, and the proportion of taxation borne by her contrasted with that borne by Great Britain. Or the question may be considered as one of individuals and classes rather than of countries, and the amount of taxes paid by the individual Irishman may be compared with those paid by the individual Englishman. Then *the* ***Financial* Relations Commission** of 1894–96 regarded Ireland as a geographical entity, and, owing to the circumstances under which it was appointed, it was quite justified in doing so. At the same time, it ought to be remembered that all attempts to estimate the income of Great Britain and Ireland and their relative taxable capacities must necessarily be only approximate. From various causes, which will be noticed later, the statistical data on which discussions as to the over-taxation of Ireland are based are often too speculative to admit of being used as a basis for conclusive agreement. Eventually, indeed, the whole question must spread itself over a much wider field, and one practically left untouched by the Commission — that of the incidence of taxation as between the various districts and the various classes of a community. Ireland is only one example, although one of the most important, of the results of our present system of taxation.




---

p.6


The Restoration is the period taken for the commencement of this sketch, for with it begins a new phase of English commercial policy. Previous to the Restoration there had been little commercial jealousy felt towards Ireland. All the laws with regard to trade treated Ireland precisely the same as England. Until the Cattle and Navigation Acts of 1663 there was no Act on the Statute Roll for laying a single restraint on the trade and manufactures of Ireland, or for imposing any duty on the manufactured products of Ireland when imported into England.


The commercial Statutes of Edward III. with regard to the importation of woollen cloth[1](javascript:footNote('E900040/note001.html')) and of Gascony wines,[2](javascript:footNote('E900040/note002.html')) and in respect of the regulation of the staples,[3](javascript:footNote('E900040/note003.html')) placed Ireland on exactly the same footing as England. Irish merchants were allowed to bring their merchandise to the staple in England without paying any but the Irish Customs,[4](javascript:footNote('E900040/note004.html')) while all merchants, whether aliens or denizens, were allowed to import goods of all kinds into Ireland without any increase of dues.[5](javascript:footNote('E900040/note005.html'))


The same principle runs through the commercial Statutes of subsequent reigns. In the fifth year of Richard II. the first attempt towards a Navigation Act was made.[6](javascript:footNote('E900040/note006.html')) The King's subjects were forbidden to carry forth or bring into the realm any merchandises except in ships of the King's allegiance. This definition, of course, included Irish ships.


From this time until the reign of Edward IV. no English Statute relating to trade or commerce mentions Ireland, but, as nothing is ever said to the contrary, we may conclude that she was treated in all ways similarly to England. The commercial treaty, however, made by



---

p.7



England with the Duke of Brittany included Ireland, woollen cloths being particularly mentioned, and in a later treaty, made between Henry VII. and the Netherlands, Ireland is mentioned by name.[7](javascript:footNote('E900040/note007.html')) In the reign of Edward IV. we again come across a commercial Statute which includes Ireland.[8](javascript:footNote('E900040/note008.html')) It declares that ‘all wares and chaffres made and wrought in the land of Ireland and Wales may be bought and sold in this realm of England as they were wont before the making of this Statute,’ in spite of the complaints made by English artisans that they were being impoverished by reason of divers commodities and wares being brought into England ready wrought.


In later reigns this policy of treating Ireland similarly to England in all matters of industry and commerce was continued. The Navigation Acts of Henry VII. made no attempt to differentiate between English and Irish ships. In the reign of Elizabeth a Statute was passed forbidding live rams, lambs, and sheep to be carried out of England, Wales, or Ireland,[9](javascript:footNote('E900040/note009.html')) while another Statute which forbade the stretching of woollen cloths included Ireland in the prohibition.[10](javascript:footNote('E900040/note010.html')) In the reign of James I. there is an important Statute which shows that the Irish were allowed to trade freely to foreign countries.[11](javascript:footNote('E900040/note011.html')) The Statute abolishes the charters given to some English merchants to trade to Spain and Portugal, and refuses to give them a charter to trade to France, on the ground that if it were given the people of England would not be able to trade freely with foreign countries like the people of Ireland and Scotland. In the reign of Charles II. several English Statutes gave encouragement to the Irish woollen manufacture,[12](javascript:footNote('E900040/note012.html'))


---

p.8



while the first Navigation Act of the same reign drew no distinction between English and Irish ships.[13](javascript:footNote('E900040/note013.html')) It was the great Navigation Act of 1663[14](javascript:footNote('E900040/note014.html')) that began the restrictive policy towards Irish industry and commerce, a policy which held its own until the Irish volunteer movement of 1779 in favour of free trade.


Before the middle of the seventeenth century Ireland was indeed too backward a country to inspire a feeling of jealousy. Hatred there was on the part of England, but it was a contemptuous hatred. Until the reign of Charles I. it never entered into the mind of an Englishman that Ireland could in any way rival his own country. But Charles's reign opened a new phase of Irish history. It was then that Englishmen first learned to fear Ireland, and that the seed was sown of that idea which was to bear fruit later — the idea that Ireland must be kept weak and distracted, that she must not be allowed to grow wealthy or become united, lest she should be used by the Crown as an instrument of Royal aggrandisement. But from the beginning of the Civil Wars until after the Restoration, Ireland had plainly no chance of becoming either rich or united. Wars, massacres, famine, and pestilence, as well as the policy of **Cromwell** in depopulating the country of the Catholics, had reduced the numbers of the people by one third. The whole trade and manufactures of Ireland had been destroyed. The linen industry which had been encouraged by **Strafford** had decayed; the cattle and live stock in the country was not sufficient to supply the wants of the people. But after the peace Ireland soon improved rapidly, and England began in consequence to look with jealous eyes upon her sister country.


It must be remembered that the mercantile system did not attain its full development in Europe until the latter half of the seventeenth century. One of the tendencies of this system was an undue exaltation of foreign trade over domestic, and of manufacturing industry over agricultural.




---

p.9


In consequence the exports of a country were held to be an index of its prosperity, and great importance was attached to the importation of raw materials and the exportation of manufactured goods. Now, just at the time when these beliefs were everywhere forming in men's minds, every powerful European country was establishing colonies. Portugal, Spain, France, Holland, all had the start of England, and it was only in the period subsequent to the Restoration that English colonisation began in the New World on anything like a large scale, and that Ireland and Scotland came to be looked upon in the same light as the new possessions in America. Once colonies existed there had to be some sort of theory as to the economic relations which should prevail between them and the Mother Country. The theory which was adopted more or less by every European country was the absolute subserviency of the colonies to the mother countries. They were simply looked upon as estates to be worked for the advantage of their possessors, and statesmen regarded the colonial trade as a means of enlarging the public revenue. The object of the mercantilists was to make the Mother Country powerful, and the best means to this end was to make her wealthy through commerce and industry. The establishment of colonies had opened a great and new field for the enlargement of commerce, and each nation working for its own power competed with every other in the economic as well as in the political field. The wars of the eighteenth century were the result of this struggle for predominance in trade and industry. In every country the Government put itself at the head of the new national economic interest. Industry had to be regulated in order to secure foreign markets by goodness and cheapness of wares. High import duties were imposed, no longer for revenue purposes, but in the interests of national production. Every nation did its best to exclude foreign competition in the home market, and to procure raw materials from abroad to work into



---

p.10



manufactured goods at home. The position of colonies and dependencies under such a system was self-evident. They must not trade with foreign countries, but only with the Mother Country. They must not supply her with manufactured goods, but only with precious metals and raw products. In so far indeed as the trade and industry of the colonies did not interfere with that of the Mother Country, it was to be encouraged as contributing to the general wealth; but directly the interests of the colonies conflicted with those of the Mother Country they must be put on one side. In general these interests did conflict, and the colonies suffered.


If we look at the mercantile system from the point of view of the chief European countries, we must acknowledge that it led them on the whole into the path of general economic development. It is plain that the efforts of the State to further trade and industry were attended with some success, although it is impossible to measure their exact effects. And at the same time the current doctrine was the product of the practical activities of the age, and Governments and people adopted those theoretic tendencies which we know as mercantilism by force of contemporary circumstances.


Later on, when the mercantile system had done its work, instead of being discarded as useless, it was retained with some of its main features distorted, and by that time capable of working great harm. The spirit of trade monopoly became more intense, business jealousies were stronger than ever, while the economic development attained by the colonies made them more and more unwilling to remain in their position of commercial subordination. In England especially the whole mercantile system was strained to breaking point, and the attainment of independence by the American colonies, together with the effect of the American War upon Ireland, led to a change in British commercial policy and the gradual growth of the idea of free trade.



---

p.11



Now, it was Ireland that suffered most of all from the mercantile policy of England. As far as actual commercial restriction went, America and Scotland suffered a good deal; but their trade and industry were not hampered and discouraged to the same extent as those of Ireland. This arose from the peculiar jealousy felt towards Ireland by England owing to the fact that the former was a Roman Catholic country. But this feeling of jealousy was caused by political rather than religious motives. England hated Roman Catholicism because it seemed to be fraught with danger to the State. There was always a fear haunting the English legislature that Ireland might support the Pretender, or might enable the King to override the Constitution. This general motive for interfering with Irish trade and industry was reinforced by special and more direct reasons; while Ireland's peculiar situation, geographical, industrial, and political, made her liable to be greatly affected by English commercial policy. Things were different in Scotland and the American colonies. Scotland had an independent Parliament which made itself so troublesome that England was glad to effect the union, and so her commercial restrictions were short lived. America had huge internal resources which no amount of restrictive Statutes could altogether counteract, while the fact that her economic development mainly proceeded on lines different from those along which the Mother Country would naturally develop shielded her to some extent from the jealous fears of English traders. In any case the American colonies were too distant from the Mother Country for their trade to be much injured; and, as a matter of fact, it is doubtful whether they suffered to any considerable extent at the hands of England. But in Ireland matters were otherwise. The unfortunate island lay near to the English coast, and her industrial resources were at this time[15](javascript:footNote('E900040/note015.html')) very similar to those of England. Nearly



---

p.12



every occupation which could be successfully pursued in Ireland seemed to be one also suited to England, and therefore one in which the English Government and people would brook no competition. Just because Ireland's economic resources were so similar to those of England, the theories and ideas of the time prevented her from developing them. At the same time, the weakness of her Parliament hindered her from pursuing a policy of retaliation by laying heavy duties on the importation of English goods. The Irish Parliament had no means of making itself troublesome like the Scotch, for it had become practically dependent on England. Although it was allowed to originate heads of Bills, all such Bills had to go up to the English Privy Council, and if the Privy Council altered them, as it generally did, the Irish Parliament had either to accept the alteration or reject the measures altogether. The strength of the Irish legislature was also greatly weakened by the exclusion of the Catholics from the franchise. It was an alien rule in the midst of an alien population, for it consisted only of representatives of the ruling caste. At the same time, the English Parliament itself did not scruple to pass laws affecting Ireland, although the legality of such laws was doubtful. For more than a century after the Restoration Ireland was like clay in the hands of the potter. It was not until a new national spirit rose up, affecting all sections and classes of the population, that she took her destinies into her own hands and asserted her position as a distinct kingdom. Such were the general and special causes which made Ireland feel keenly the practical results of the commercial ideas of the age. But the consequent poverty and backwardness of the country were intensified by religious persecution. The penal laws sunk the mass of the people in a depth of poverty and ignorance scarcely ever surpassed in history and drove their natural leaders into exile. Indeed, the whole policy of England, whether political, commercial, or religious, aimed at keeping Ireland poor,



---

p.13



divided, and humiliated. Little wonder indeed that she suffered in a way America and Scotland never did. It is, of course, impossible to judge the conduct of England towards Ireland from a modern standpoint; it can only be judged in the light of the prevailing theories and ideas of the time. The age was intensely materialistic; it was a time of the crudest nationalism, and one in which everything was done in the interests of classes and individuals; it was a period when religious toleration was still regarded as impracticable. In placing restrictions on Irish commerce and trade, England was only following the example of every European country that possessed dependencies; and in spite of constitutional theories, Ireland was in practice merely an English dependency. Again, in persecuting the Irish Catholics, England was but acting according to the religious ideas of the time; and it is only fair to add that, unlike France and Spain, she had peculiar political reasons for her conduct. All this may be acknowledged, but the fact remains that in the case of Ireland everything was exaggerated. Irish trade and industry were even discouraged, no doubt from political motives, in the interests of Scotland and the American colonies. In fact, whenever the cake was not large enough to go round, it was always Ireland that had first to go without a slice. And as regards religious persecution, it would be difficult to find in the annals of the religious history of Europe as demoralising a code of laws as the Irish penal code. On the Continent persecution may have been more ferocious: but in Ireland, where the motive for persecution was political rather than religious, the penal laws were more subtly degrading and more demoralising to the character of a people than the bloodthirsty enactments in France or Spain against the Protestants. For over a century the Irish people were ground down by laws which **Edmund Burke** described as ‘a machine of wise and elaborate contrivance, and as well fitted for the oppression, impoverishment and degradation of a people and the debasement in



---

p.14



them of human nature itself, as ever proceeded from the perverted ingenuity of man."’[16](javascript:footNote('E900040/note016.html'))


No account of the commercial relations between England and Ireland would be complete unless account were taken at the same time of this penal code. The laws aimed at the coercion of an entire nation, and so could never be strictly enforced; but their prosecution was sufficiently severe to bring into prominence some bad qualities of the Irish character. They also discouraged thrift and industry, and by driving the Catholic gentry from the country, set a gulf between peasants and landlords and checked the development of a national spirit. English writers of the sixteenth and seventeenth centuries were continually noting the richness of the material resources of Ireland, her beautiful harbours, the multitude of her lakes and rivers, the extraordinary fertility of her soil.[17](javascript:footNote('E900040/note017.html')) What is more surprising to the modern Englishman, they also mention the industry of her people and their capacity for work, their great bodily strength and hardiness, their intelligence and love of knowledge.[18](javascript:footNote('E900040/note018.html')) That the rich resources of Ireland, both in her land and in the characteristics of her people, have produced little fruit, and have merely resulted in the Ireland of the present day, is due to causes long at work, the effects of which time alone may soften. Indeed, if we consider that it is only within the last thirty years that the economic grievances of Ireland have begun to be redressed and that any genuine effort has been made to improve the condition of the people and to develop the national resources, we can hardly expect



---

p.15



that things should yet be much better than they are. But even in the dreary annals of the Irish people during the nineteenth century a certain progress can be traced. At the present day there are signs that for Ireland, economically speaking, the worst is over, and that in the future she may have a real chance of progressing, however slowly, in the path of general economic development.




---

p.16


The Cromwellian Settlement — The Restoration Policy — State of Trade and Industry — Economic Condition of the People — England and Ireland contrasted.
At the conclusion of the Cromwellian Wars Ireland was little better than a wilderness. The country had been comparatively prosperous under the early Stuarts, but since then the Rebellion had taken place, and **Cromwell** had swept like a scourge over the face of the land. Thousands of young men, boys and girls had been sent off as slaves to the Barbadoes and Jamaica.[19](javascript:footNote('E900040/note019.html')) All those who had not constantly supported the Parliament had been forced to give up their estates to Cromwell's soldiers and adventurers and to migrate to new lands in Connaught. There they could hardly keep themselves alive, deprived as they were of their tenants who had been retained on the old lands to work for the new masters, too poor to obtain the necessary implements for cultivating the soil, and unable to acquire live or dead stock. They were mostly Irish or Anglo-Irish, but some were Englishmen who had recently settled, but who had been loyal to Charles. The Irish soldiers who had served against the Parliament, and who were practically all Catholics, were sent by **Cromwell** into exile to the number of 40,000 ‘to fill,’ as **Dalrymple** says, ‘all the armies of Europe with complaints of his cruelty and admiration of their own valour.’[20](javascript:footNote('E900040/note020.html')) Thus the Irish had no armed force, they were



---

p.17



treated as aliens in their own country, they were robbed of the small estates which former plantations had left them, and the peasantry were treated as slaves by the conquerors. The whole native population was in a condition of the greatest misery. The Cromwellian confiscations were practically universal, and they were devised so as to give the greatest possible shock to property. The Irish Catholics had certainly a clear right to restoration from Charles II., for many of them had never rebelled against their Sovereign, and of those who had taken up arms, most had submitted to the King in 1648, and had continued to support his cause. But Charles made little effort to improve their condition. His position, of course, was a difficult one, for Cromwell's soldiers and adventurers were actually in possession, and the end of it all was that they were confirmed in their lands. The settlement was conducted by the advice and management of the **Duke of **Ormonde****, **Sir Charles Coote**, and **Lord Broghill**. Commissioners were sent to the King to press upon him a scheme for a new Parliament in which Catholics should be excluded, and by which all Protestants should be confirmed in their estates.[21](javascript:footNote('E900040/note021.html')) The Parliament was called and, by means of enforcing the oaths of supremacy and allegiance, succeeded in practically excluding the Catholics. At the same time the harsh laws made by **Cromwell** against them were re-enacted. All Irish Catholics were forbidden to go from one province to another; those who had been the owners of large estates were imprisoned, and their letters to and from Dublin were intercepted; meetings of the Catholic gentry were prohibited. The aim of these measures was, of course, to prevent the Catholics from combining to petition the King for their relief or from sending messengers to England with the same object. Rumours of Popish plots were circulated in order to frighten the English Parliament into an attitude of



---

p.18



hostility to the Catholics. The consequence of this policy was a proclamation issued shortly afterwards by the King for apprehending all Irish ‘rebels,’ and commanding that adventurers, soldiers, and others who were occupiers of any lands should not be disturbed in their possessions, but should be regarded as the rightful owners until legally evicted or until the King with the advice of his Parliament should take further action in the matter. The Irish Catholics were excluded from the general indemnity, and a feeble attempt to ameliorate the position of Protestant loyalists failed through want of funds. The **Duke of **Ormonde**** resumed the government of Ireland, and the Acts of Settlement and Explanation were drawn up and passed. Under these Acts, the greater part of the land of Ireland was given up to a crew of motley adventurers, civil and military, almost to the exclusion of the older inhabitants of the island. The Cromwellian Settlement was thus perpetuated, and the foundation was laid of that deep and lasting division between landlord and tenant which has been so great a cause of the political and social evils of Ireland.


It is clear that under such circumstances trade and industry were necessarily at a standstill. Under James I. the revenue of the Crown in Ireland had been doubled, shipping had increased, and exports and imports had grown considerably.[22](javascript:footNote('E900040/note022.html')) During the reign of Charles I. the prosperity of the country had continued,[23](javascript:footNote('E900040/note023.html')) and **Strafford** had done his best to develop its resources by setting up a linen industry with the aid of Protestant refugees from France and Holland. Commerce was in no way restricted, and **Boate** tells us that Waterford and Limerick were ‘towns of traffic,’ while the inhabitants of Galway ‘do greatly trade with other countries, especially to Spain, from whence they used to fetch great stores of wine and 


---

p.19



other wares every year.’[24](javascript:footNote('E900040/note024.html')) But after the Civil War there was little commerce, and the linen industry was as if it never existed. The native woollen manufacture had decayed, and as late as 1672 **Petty** writes that ‘the clothing trade is not arrived to what it was before the late Rebellion, and the art of making the excellent, thick, spongy, warm coverlets seems to be lost and not yet recovered.’[25](javascript:footNote('E900040/note025.html')) The cattle and live stock of Ireland, which in 1641 had been worth £4,000,000, was in 1652 only worth £500,000, so that after the Cromwellian Settlement Ireland had even to import provisions from Wales.[26](javascript:footNote('E900040/note026.html')) Fortunately, this condition of things did not last long, for in the years immediately succeeding the Restoration Ireland recovered to a great extent from the effects of the wars, and although the struggle with the Netherlands prevented the country from trading with the Continent, the new settlers soon began to trade in cattle, sheep, and their products to England.


We can get some idea of the economic condition of the mass of the Irish people soon after the Restoration from the writings of **Sir William Petty**, but otherwise little trustworthy material on the subject exists. **Petty** estimated the total population of Ireland in 1672 as about 1,100,000, 780,000 of whom were ‘fit for trade.’ He found that nearly one-eighth of this working population were engaged in tillage, over one-sixth in cattle and sheep rearing, and nearly one-tenth in the making up of wool.[27](javascript:footNote('E900040/note027.html')) This woollen manufacture, however, must have been chiefly a domestic industry, for at this time there were practically no manufactures exported from Ireland, the staple trade being that of provisions. Few commodities were imported, with the exception of tobacco, as the Irish villages were more



---

p.20



or less self-sufficing and made for themselves everything they needed. **Petty** thought that the ordinary Irish peasant did not spend even one-fifth of his income on articles not produced by his own family, ‘which condition and state of things cannot beget trade.’[28](javascript:footNote('E900040/note028.html'))


Of the estimated population of 1,100,00, 800,000 were Irish and 300,000 English or Scotch.[29](javascript:footNote('E900040/note029.html')) Six out of every eight of the Irish lived in a state of abject poverty, for the English and Scotch Protestants possessed three-quarters of the land, five-sixths of the housing, and two-thirds of what foreign trade there was.[30](javascript:footNote('E900040/note030.html')) Six-eighths of the Catholics lived in vermin-haunted cabins with neither chimney, door, stairs, nor window. Their food was chiefly milk and potatoes, but they also ate bread, eggs, and rancid butter. Meat was rarely eaten, in spite of its abundance and cheapness, but the people sometimes killed a hen or a rabbit for food. Those on the coast lived largely on shell fish.[31](javascript:footNote('E900040/note031.html')) The one luxury of all persons was tobacco, and **Petty** estimated that two-sevenths of a man's whole expenditure in food went in purchasing this article. Fuel cost nothing, for turf could be got for the mere trouble of carting it, and in this the Irish peasant had the advantage of the English labourer. In another way, too, he was better off, for he was always well and warmly clothed. In England a labourer wore a cotton smock over his breeches, but the Irish peasant was never without his thick coat and waistcoat of frieze; his breeches were also of frieze and he wore woollen stockings and a woollen cap or hat.[32](javascript:footNote('E900040/note032.html')) This was due to the cheapness of wool, for Ireland was prohibited from exporting her wool, and there was no large woollen industry to take up the surplus material. In consequence the Irish peasants were clothed better than the poor of any other European country.


At the Restoration Ireland possessed little trade or



---

p.21



industry, but she had many of the requisites for a thriving industrial nation in the shape of natural products and geographical situation. The soil of England was not so good for pasture farming as that of Ireland, while in many parts of Ireland good wheat, barley, and oats could be raised. The contrast in economic conditions between England and Ireland was not nearly so great in the seventeenth century as it became in later times. Broadly speaking, England was an agricultural country like Ireland, for agriculture employed the greater part of her population. But during the two preceding centuries her industrial life had been slowly developing. At this time she was in full possession of her great woollen trade, for although Cromwell's policy as Protector had interrupted the trade in Norwich stuffs to Spain, it soon revived and prospered greatly for some time in spite of complaints of foreign competition. The immigration of Huguenot refugees had already done something to promote some of England's minor industries, although the most important immigrations had not yet taken place. The shipping trade of the country was beginning to grow and the Navigation Acts were soon to transfer the carrying trade from the Dutch to the English. New methods of agriculture were being introduced, and in spite of the pressure of taxation during the war, pauperism seems to have decreased.[33](javascript:footNote('E900040/note033.html')) Of course the Civil Wars had caused great distress; the propertied classes had been hit and manufactures had been affected. Cromwell's policy in quarrelling with Spain had temporarily injured trade. For several years after the Restoration there was a series of bad harvests, and for one or two years wheat rose to famine prices.[34](javascript:footNote('E900040/note034.html')) Rents were everywhere low, and it was this fact that caused so much talk about national decay and which soon led to complaints



---

p.22



concerning the importation of Irish cattle. The war with the Netherlands prevented the country from taking advantage of the conditions of civil peace. But all this was merely temporary, and the standard of comfort among all classes was progressing. The condition of the labourer was better than it had been at the beginning of the century; domestic industries were extending, thus causing a rise in family earnings, and the rise of wages which had taken place during the wars continued when peace was restored. The political and social conditions prevailing in England were more favourable to material progress than those which existed in Ireland. The English people were united and chiefly of one religion. England was not like Ireland, a country governed by a small class hostile to the original inhabitants and differing from them in race, language, and religion. The division in Ireland between conquerors and conquered was bound to hamper industrial development. But many English and Scotch had settled in the country, and if England for the next century had pursued the policy of fostering the interests of the new settlers in every direction, the economic history of Ireland would be less melancholy reading than it actually is. Ireland had every prospect of developing a great woollen manufacture like England, and she was possessed of many potential sources of wealth in her splendid waterways, in the fertility of her soil, and in her geographical position. The progress made in the years succeeding the Restoration shows the recuperative strength of the country, and although England also progressed, it was thought by contemporaries that the advance made by Ireland in material wealth was during this period greater than that made by any other European country.




---

p.23


The Restoration and its Commercial Policy.
------------------------------------------


Irish Export Trade in Live Stock-Growing Apprehensions and Jealousy in England — First Act against Irish Cattle — Remonstrances of Ormonde — Effects of the Act — Further Jealousies in England — Final Act against the Importation of Irish Cattle, Sheep, Swine, and their Products — Immediate Distress in Ireland — Ultimate Effects of the Act — The Navigation Acts of Charles II. and their Effects — Efforts of the Irish Parliament and Ormonde to Promote Trade and Industry — English Duties on Irish Manufactures — Growing Prosperity of Ireland till the Revolution.
We have seen that in the years directly succeeding the establishment of peace Ireland began to recover rapidly from the effects of the war. **Henry Cromwell** seems to have governed wisely, and at the time of the Restoration of Charles II. there were already certain signs of returning prosperity. A large export trade in live stock had been established. The breeding of cattle and sheep was an industry eminently suited to a country possessed of little agricultural skill, in which the chief part of the land was owned by alien landlords, afraid to employ large numbers of the native Irish on their estates. Years before **Edmund Spenser** had noticed the fitness of the soil of Ireland for pasture farming and cattle breeding, and even in his time the Irish owned a large quantity of live stock.[35](javascript:footNote('E900040/note035.html')) Later, in 1620, one hundred thousand head of cattle had been exported from Ireland to England, forty to fifty shillings a head being paid for them.[36](javascript:footNote('E900040/note036.html')) The trade had, of course, practically



---

p.24



ceased to exist during the Cromwellian Wars, but now it was increasing by leaps and bounds, chiefly owing to the fact that many of Cromwell's soldiers and adventurers who had been granted lands in Ireland had become sheep and cattle breeders on a large scale. In 1663 there was exported from Ireland one third more of oxen, sheep, butter, and beef than in 1641,[37](javascript:footNote('E900040/note037.html')) and that in spite of the high duties imposed in Ireland on the exportation of live stock. Sheep and oxen had to pay on shipment a duty of three shillings and fourpence per head,[38](javascript:footNote('E900040/note038.html')) while that on horses was still heavier.


At this time Irish cattle farmers devoted themselves merely to breeding live stock, and made little attempt at fattening. It is true that a certain amount of beef, mutton, pork, and butter was exported from Ireland, but Irish butter was carelessly made and badly packed, while Irish meat was poor. This was because the animals were killed young in order to avoid the trouble and expense of fattening them. The export trade in live stock was so flourishing that it seemed scarcely worth while to spend money in fattening in order to procure good meat and dairy produce for sale abroad.


For the time the country flourished under this condition of things, but the new prosperity was destined to be but short lived. Three years after the Restoration the English breeders began to raise an outcry against the growing importation of Irish cattle. For the last three years on an average sixty-one thousand head of cattle had been brought over every year from Ireland.[39](javascript:footNote('E900040/note039.html')) The breeders complained that land in Ireland was so plentiful and cheap that cattle and sheep could be bred practically for nothing, and that in consequence English cattle, which could only be bred at great expense, were being undersold.




---

p.25


Irish competition was bringing down the prices of live stock in England, and this fall of prices was the cause of the present decline in rents. So it was argued, and the result of these arguments was a rather tentative attempt by an English Act of Parliament to prohibit the importation of Irish cattle into England between July 1st and December 20th in any year, under penalty of a heavy money forfeiture.[40](javascript:footNote('E900040/note040.html')) Scotch cattle were included in the Act, but in less severe terms, and it was evidently aimed chiefly at the Irish cattle breeders. The Bill met with practically no opposition in either House. The Earl of Anglesea had been sent over from Ireland by the Lord Lieutenant to protest against the measure; but he arrived too late to influence the decision, and the Bill rapidly became law.


**Ormonde** had done all he could to prevent this Bill from being passed. He had tried to influence the King against it, and had pointed out the little trade possessed by Ireland and the impoverished condition of the country by reason of the recent wars. But the King was powerless to resist any measure which his Parliament was really determined to bring about, and could therefore do nothing to help the Lord Lieutenant. After the Act was passed **Ormonde** devoted his energies to obtain its repeal or at least to prevent a worse thing from happening to Ireland. Some time before he had appointed a Council of Trade to encourage the industry and commerce of the country. This Council he now ordered to draw up a report on the effects of the recent Act. On November 4th, 1664, the report was sent up.[41](javascript:footNote('E900040/note041.html')) It seemed that there had been a total cessation of the export of cattle and sheep for the last few months. There was great discontent in the country. Tenants were giving up their leases; the customs were beginning to fall; the expenses of the civil and military lists could not be defrayed. This stoppage in the



---

p.26



export of cattle and sheep meant practically a universal cessation of trade, for live stock was the staple commodity for exportation. The exportation of salted beef was not profitable to the country, because the poverty of the people necessitated the cattle being killed too young. Also Ireland had no ships in which to export her beef. The Council prophesied that the rents of lands in Ireland would decline and the trade of England with Ireland would suffer, as Ireland would soon become too poor to purchase English commodities.


**Ormonde** and his Council confirmed the conclusions of the Council of Trade as to the great and sudden poverty of the country and the scarcity of money. Cattle, they said, were a drug in the market, and there was not enough money to pay the husbandmen their wages, so that tillage also was stopped. The measure was defeating all the attempts which were being made to make Ireland pay her own way and not be a burden to England. For tenants could not pay their rents to their landlords, nor in consequence the landlords to the king, nor could either tenants or landlords pay the public taxes. Also by the decrease of trade the King would lose his customs and excise. **Ormonde** also foresaw that the prohibition of their cattle might force the Irish to trade with other nations for those articles which they used to get from England in return for their cattle. Ireland might then grow rich without England and might set up manufactures of her own to England's hurt. The prophecies of Ormonde showed a foresight on his part which his contemporaries seemed to lack. But although he saw clearly that England would suffer from her unjust measure, he did not foresee that Ireland, in spite of the temporary distress she was suffering and was still to suffer, would eventually gain rather than lose by the prohibition. But after all it was little wonder that **Ormonde**, and indeed all thoughtful men in Ireland, should have regarded the Cattle Act as destructive of Irish prosperity. There



---

p.27



were practically no manufactures in the country, and cattle was the best native commodity. The difficulties of transportation prevented live cattle and sheep from being sold anywhere but in England and Scotland, while their produce, hides, tallow, and flesh, could not be sold at this time in France and Holland as formerly because of the war. Irish beef too was very inferior to English, and it did not seem possible that it could compete with the latter in foreign markets at the conclusion of the war. The only raw material which Ireland could have exported in large quantities, wool and woolfels, was prohibited from being sent anywhere but to England, and only there on payment of a heavy fee. And so it seemed unlikely that Ireland would be able to compensate herself for the loss of her cattle trade.


There is no doubt that the Cattle Act of 1663 produced great and real distress in Ireland. Between July and December the penalty for importing large cattle into England was forty shillings a head; for sheep it was ten shillings. These penalties equalled the value of the animals, and so were equal to a prohibition. The country was altogether in a very miserable condition, and **Ormonde** reported that he could not answer for the quiet of the people if the Act were not repealed.


But in spite of the distress in Ireland, which was in itself a convincing proof of the effectiveness of the Act, the English breeders were not satisfied. The breeders of the northern counties sent up a petition to the Parliament which met at Oxford in October, 1665, complaining that they could not sell their cattle except at ruinous prices, that the great fall in rents would drain the country of its resources, and praying for an Act to prevent altogether the importation of live stock from Ireland.[42](javascript:footNote('E900040/note042.html')) It is certainly true that rents in England were everywhere falling, but this fall cannot possibly be attributed to the competition of the Irish cattle breeders. The war with Holland, the



---

p.28



plague, and the great drought of the last few summers, were quite sufficient in themselves to account for the fall of rents, which at that time meant more or less the impoverishment of the kingdom. Land was then the great source of taxation, and so a fall in rents meant a decay in the sources of taxation. Those members of Parliament, therefore, who believed the arguments of the English cattle breeders were nothing loath to accede to their wish for protection against Irish competition, while many of those who saw the absurdity of the arguments were willing to support any Act which would impoverish the great Irish landowners, because of their jealousy of the **Duke of **Ormonde****. The result of all these complaints and jealousies was a Bill brought at once into Parliament prohibiting absolutely the importation of large cattle, sheep, and swine, and also of beef, pork, and bacon, from Ireland or any part beyond the seas. The Bill passed the Commons with some difficulty, but it was thrown out by the Lords. For the time being the matter had to be dropped. There was open discontent in Ireland, and even the Members of the Irish Parliament plucked up courage to resent the interference of England with their trade, for when granting the last four of the twenty-four subsidies they had granted since the Restoration, they provided, by an express clause, that, in case the prohibition of transporting cattle into England was not taken off before December 25th, 1666, the levying of the last two subsidies should be suspended.[43](javascript:footNote('E900040/note043.html')) **Ormonde** again came forward, and once more laid before the King all the arguments he had before used against restricting the Irish cattle trade. But although Charles openly expressed his dislike of the measure, he was too much in need of money to be able to resist his Parliament. And so the Bill against Irish live stock and meat was again brought forward in the following session, on September 21st, 1666.[44](javascript:footNote('E900040/note044.html')) There was a good deal



---

p.29



of opposition to the Bill. Various Members protested against it as being injurious to the interests of their particular counties. They pointed out that the land in many English counties was too good for merely breeding purposes; it was particularly well suited for fattening cattle, and as it was chiefly Irish lean cattle which were fattened on these lands, any law prohibiting the importation of Irish lean cattle would ruin the prosperity of all the fattening lands in the kingdom. But the jealousy felt towards Ireland by the great majority of the Commons proved too strong to be removed by arguments. The Bill went rapidly through its three readings, and a month later was read in the House of Lords. It was at once evident that the majority of the Lords were determined to pass it. There was, however, some opposition from those lords whose jealousy of Ireland and the **Duke of **Ormonde**** combined was not great enough to obscure their reasoning powers. Some of these lords urged that Parliament might just as reasonably take away the trade of anyone county in England because it produced some inconvenience to that of another county more in the favour of Government. Norfolk, Suffolk, Kent, and other counties would lose as much by the Act as the northern counties would gain by it. Another interesting point urged in the Lords against the Bill was that if it were passed, Ireland would be just as much entitled to desire the King to restrain the trade of England. These arguments show that Ireland was still regarded as a more or less co-ordinate part of the King's dominions, and that the later conception of her strictly subordinate position had not yet generally appeared. The debates on the Bill lasted some time. They were extremely animated, and often went on from early in the morning until four in the afternoon, at that time a very late hour for a sitting to terminate.[45](javascript:footNote('E900040/note045.html')) **Buckingham** and 
**Ashley** headed the supporters of the Bill. It was the latter who disclosed that there were other reasons for passing the measure besides



---

p.30



a wish to encourage the breeding of cattle in England, for he urged that if the Bill were not passed, all the rents in Ireland would rise in a vast proportion and all the rents in England would fall as much, so that in a year or two the **Duke of **Ormonde**** would have a greater revenue than the Earl of Northumberland.[46](javascript:footNote('E900040/note046.html')) Many of the lords were extremely jealous of the large Irish estates owned by **Ormonde**, and **Ashley**'s argument did something to prevail upon them to vote for the Bill. The **Duke of **Buckingham**** declared that whoever opposed the Bill had either an Irish interest or an Irish understanding,[47](javascript:footNote('E900040/note047.html')) which so enraged the **Earl of **Ossory****, **Ormonde**'s eldest son, that he sent the Duke a challenge. Indeed, the debates were very disorderly. No parliamentary rules were adhered to, and the Commons, to add to the agitation, kept on sending messages begging the Lords to hasten the matter. One thing, however, rather delayed the passing of the Bill in the Lords; this was that certain clauses of the Act appeared to be derogatory to the King's dignity. Some alterations were therefore made in order to allow the King the prerogative of his dispensing power, and with these amendments the Bill was sent down to the Commons. But the Commons rejected the amendments altogether, and voted that they would adhere to their own Bill without departing from a word of it, except with reference to Scotland. Scotland had been included in the Act, for a good deal of Scotch cattle had been imported into the northern counties. Now the Commons, by agreeing to exclude Scotland from the terms of the Bill, showed their hands, and made clear that reasons besides those connected with the Cattle Bill were influencing their conduct. Indeed, the whole basis of the Bill was destroyed, for if the importation of Irish cattle had been injurious to the interests of England, that of Scotch cattle must have had a similar effect. But Scotland was not an object of



---

p.31



jealousy, like Ireland, and the **Duke of **Ormonde**** owned no Scotch estates. Scotland had only been included in the Bill in order to give an appearance of impartiality to the measure. The Bill was aimed primarily at the Irish cattle breeders, and through them at the Duke of Ormonde.


Meanwhile, the various conferences between the Lords and Commons came to no satisfactory issue. The Commons firmly refused to allow the King any dispensing power with reference to the Act, and it is probable that the whole Bill might have fallen through if the King had not been secretly persuaded not only to consent to the Bill, but also to persuade the Lords to give up their amendments in favour of his prerogative. The Lords at last agreed, and the Bill was passed and received the Royal consent on November 3rd, 1666.


This Act laid down that all great cattle, sheep, and swine, and also all beef, pork, and bacon imported into England from Ireland, except for necessary provisions, should be forfeited, the importation of either fat or lean cattle being unnecessary, destructive of the welfare of the kingdom, and a ‘public nuisance.’[48](javascript:footNote('E900040/note048.html')) The Act was strengthened by subsequent Statutes, which extended the prohibition to Irish mutton, lamb, butter, and cheese.[49](javascript:footNote('E900040/note049.html')) Thus Ireland was not only deprived of her staple trade in live stock to England, but also of any possible future increase in her provision trade with England.


This Cattle Act of 1666 naturally greatly increased the existing distress in Ireland. The Irish trade in cattle and animal produce to England had literally been three-quarters of the whole trade of the country.[50](javascript:footNote('E900040/note050.html')) In any case the measure must have produced great distress; but the war made this distress much more acute. Farmers found themselves with live stock on their hands which they



---

p.32



could not sell. Horses which used to be sold for thirty shillings a head were now sold thankfully as dog's meat, while oxen which had been sold for fifty shillings a head were now sold for ten shillings. A year later matters had become much worse, for in 1667 the Scotch, who had hitherto allowed Irish cattle to be imported on payment of a duty of half-a-crown a head, followed the example of England and forbade their importation altogether.[51](javascript:footNote('E900040/note051.html')) For a short time the Irish carried on a clandestine trade with England, glad as they were to dispose of their cattle on almost any terms. But the trade was too risky and had soon to be given up. An attempt was then made to export Irish cattle to Rotterdam; but this too was found to be unprofitable, for owing to the expenses of transportation, the Dutch could supply themselves cheaper from Holstein, and so were unwilling to give the Irish merchants such a price as would cover the expenses of freight and insurance. So nothing could be done in this direction to tide over the period of acute distress. The debt of the country to England had also greatly increased, for in order to pay this debt, Ireland had now to ship such goods as she was able to other countries, obtain goods wanted by England, and sell them in England for money to meet the various claims.[52](javascript:footNote('E900040/note052.html')) It may therefore easily be imagined that there was real and universal distress in Ireland during the years immediately succeeding the second Cattle Act.


But this distress was only temporary, and as it soon turned out, the interference of England with the Irish cattle trade was to prove really beneficial to Ireland, while it inflicted certain immediate injuries on England which were felt acutely at the time. Almost at once England suffered from her ill-judged interference. The price of meat rose immediately, and even before the end



---

p.33



of the session of Parliament on February 6th of the year following that in which the Act was passed, rates of wages had gone up in proportion to the increase in the price of provisions.[53](javascript:footNote('E900040/note053.html')) Those landlords who had pasture for fattening now found themselves at the mercy of the Welsh and Scotch cattle breeders and forced to give fancy prices for their lean cattle, so that they lost the large profit they used to get when they bought their lean cattle at cheap prices from the Irish breeder.[54](javascript:footNote('E900040/note054.html')) Rents too showed no signs of rising, and altogether England gained nothing, even at first, from the distress of her sister country. In the long run she was to suffer very much from her unwise legislation.


It has been seen that previous to the Cattle Acts Ireland had driven such a thriving trade in young bullocks with England during the five summer months of the year, that very few cows had been bred for milk and few oxen for slaughter. The consequence of this was that Irish hides were thin, small and lank, while Irish tallow was bad in quality and quickly consumed. Little butter was exported, and the trade in beef for foreign export was very small, for as the flesh was young and only grass fed, it was too light and moist for preservation.[55](javascript:footNote('E900040/note055.html')) But with the passing of the Cattle Acts all this was bound to change. The difficulties of transporting live stock were too great to allow of them being exported to foreign countries even after the conclusion of the war. All that the Irish could do was to turn their attention to fattening their cattle. The cattle breeders, instead of only breeding young bullocks, fattened their live stock in order to procure good meat and dairy produce for foreign exportation. Irish merchants became more careful as regarded the quality of the provisions they exported. Irish beef, instead of being



---

p.34



thought poor and bad in quality, soon became in great demand abroad; in 1669 some Dutch merchants stated that it fetched nearly as much in the Dutch market as the English, while Irish butter sold for more than English butter because of its superior richness of quality.[56](javascript:footNote('E900040/note056.html')) Ireland indeed soon began to rival England in all branches of the provision trade with foreign countries, especially in those of butter, hides, and tallow. French Flanders, Spain, and Portugal had all formerly been supplied with butter by England, but after 1670 we begin to hear of continual complaints on the part of English merchants that they cannot sell their butter profitably because of Irish competition.[57](javascript:footNote('E900040/note057.html')) The sale of English beef in foreign markets also suffered. Before the Cattle Acts the young Irish cattle had served for English consumption, so that the older and better English cattle could be kept for foreign export. Now, the English had to consume their own superior beef, while the Irish, by devoting themselves to fattening their cattle, were soon able to send abroad as good a quality of beef as the English provision merchants. Irish beef too was so plentiful, and so little of it, comparatively speaking, was consumed at home, that it could be sold abroad at ridiculously low prices. In Holland and Zealand, for example, Irish beef was selling in 1675 at a penny a pound.[58](javascript:footNote('E900040/note058.html')) The Irish could also sell to foreigners wool, hides, tallow, and fish at half the price the English could afford to do.[59](javascript:footNote('E900040/note059.html')) This was of course due to the low value of land in Ireland, where an acre could be bought for four shillings as against forty shillings in England. It was also connected with the low price of living and the consequent cheapness of labour.



---

p.35



But not only had the Irish begun to rival the English in the provision trade with foreign countries, they had also begun to compete in the same trade with the plantations. In the fifteen years following the Cattle Acts Ireland began to furnish the English plantations with butter, cheese, and salted beef.[60](javascript:footNote('E900040/note060.html')) She also supplied foreign plantations, especially the French West Indies, with salted provisions of all kinds.[61](javascript:footNote('E900040/note061.html')) And so during this period England saw part of her provision trade with her own plantations, as well as with foreign countries and their plantations, taken from her by the Irish. This of course kept down the price of provisions at home,[62](javascript:footNote('E900040/note062.html')) after the first effects of the Cattle Acts in raising the price of meat had worked themselves out. Naturally the low price of provisions in England proved injurious not only to the graziers and dairy farmers, but also to those cattle breeders who had hoped to gain so much by the Acts.


Thus one of the most important permanent results of the Cattle Acts was to give Ireland a comparatively large provision trade with foreign countries and English and foreign plantations. The establishment of this trade led directly to an increase in Irish shipping,[63](javascript:footNote('E900040/note063.html')) and even as early as 1670 **Sir Joshua Child** noticed that the cities and port towns of Ireland had greatly increased in building and shipping.[64](javascript:footNote('E900040/note064.html')) In 1680 we read that for the last five years there were seldom less than twenty Irish ships at Dunkirk laden with beef, quantities of butter, tallow, hides, leather, and some wool.[65](javascript:footNote('E900040/note065.html')) Irish ships were also seen at Ostend, Nantes, and La Rochelle, laden with provisions.[66](javascript:footNote('E900040/note066.html')) At the



---

p.36



same time all these places had ceased to import from England any provisions except corn.[67](javascript:footNote('E900040/note067.html'))


The establishment of this new Irish trade in provisions led to another interesting result, and one which Ormonde and other sensible men had foreseen; this was a decrease, though seemingly only a temporary one, in the quantity of English goods exported to Ireland. A falling off in the amount of trade between the two countries was noticed almost immediately. The importation of English goods had not been a necessity to Ireland, nor had it even been an advantage.[68](javascript:footNote('E900040/note068.html')) Nevertheless before the Cattle Acts were passed, three-quarters of the Irish foreign trade was with England, for Irish cattle exported to England purchased all the commodities which Ireland needed. These commodities were beer, hops, hats, stockings, cloths and stuffs of all sorts, dyeing stuffs, hides, fruit, sugar, and tobacco.[69](javascript:footNote('E900040/note069.html')) It was soon found that the trade with Ireland in hops, beer, and all sorts of woollen stuffs was rapidly diminishing, while the English exportation to Ireland of foreign corn was also decreasing.[70](javascript:footNote('E900040/note070.html')) Before 1663 Ireland had, on an average, imported English manufactures and produce to the amount of £210,000 a year, but from that time the quantity of English goods imported steadily decreased until in 1675 it had fallen to less than £20,000 a year.[71](javascript:footNote('E900040/note071.html')) At the same time, instead of importing foreign commodities by way of England, Ireland was able to buy them direct with her provisions, and by 1672 only one-quarter of Ireland's foreign trade was with England.[72](javascript:footNote('E900040/note072.html'))


---

p.37



The consequence of this temporary decrease in trade between England and Ireland was an immediate loss to the former in the way of navigation. Above one hundred ships and a proportionate number of sailors had been employed in bringing over cattle, while a large number of English ships and mariners had been employed in the trade for the return of Irish cattle.[73](javascript:footNote('E900040/note073.html')) There were now many complaints that numbers of sailors were without employment, and the pamphleteers of the period are full of gloomy forebodings of the decay of the English navy through want of merchantmen. No doubt all these fears were somewhat exaggerated by contemporaries, but it cannot be denied that as long as Ireland's foreign trade remained unrestricted, the Irish did trade with foreign countries instead of solely with England, and that there was a considerable decrease in the amount of English shipping employed in the Irish trade.


And in various other ways England suffered from the effects of the new trade which she had so inadvertently given to Ireland. The low price of Irish provisions led to foreign ships taking in their victuals in Irish ports instead of in English as before, and the English began to lose their name of supplying cheaper victuals than any other nation in Europe. It was even said that the Dutch and French could victual their ships cheaper in Ireland than the English could victual their ships in England.[74](javascript:footNote('E900040/note074.html')) The result was that English ships themselves soon began to take in most of their provisions in Ireland, or at least obtained Irish provisions from Spain and other countries.[75](javascript:footNote('E900040/note075.html')) England therefore lost part of the trade in victualling her own ships as well as those of foreigners, and the only result of the Cattle Acts was that England had to go over to Ireland for some of her provisions instead of allowing Irish provisions to be brought over to her. Although the



---

p.38



prices of English provisions had fallen low enough to inflict considerable injury on English farmers, they could not fall as low as those of Irish provisions without absolutely ruining the breeders and graziers. Before the Cattle Acts England had had provisions at moderate prices combined with a flourishing export trade. Now her export trade had fallen off, and the lower price of food was injurious to the large agricultural interest. Breeding lands were also increasing at the expense of fattening, and tillage and horse breeding were decaying. This was a misfortune, for the exportation of horses was much more lucrative than that of cattle.[76](javascript:footNote('E900040/note076.html'))


But perhaps the most important result of the Cattle Acts was that the Irish breeders, instead of only breeding or principally breeding large cattle, began to breed sheep in great numbers.[77](javascript:footNote('E900040/note077.html')) An Act of Parliament had shortly before made it felony to export wool anywhere but to England, and confiscation to export it to England except raw. But although the export of wool to foreign countries was denied to the Irish, they soon began to drive a thriving trade with England in raw wool, after the increasing number of their sheep had lowered the price of their wool. From this time till the Revolution, we read of a great and increasing exportation of Irish wool to England. Though wool could not be exported to England without a licence and the payment of a fee of two shillings a stone, and though the Irish merchant had all the expenses of freight, factorage and market charges, he was yet able to undersell the English woollen merchant in the latter's own market.[78](javascript:footNote('E900040/note078.html')) The importation of huge quantities of cheap Irish wool dragged down the price of English. Only a few English counties had been able to complain of the cheapness of



---

p.39



Irish cattle. Now practically every county in England suffered from the low price of Irish wool. England had at that time really enough wool for her own use, and so gradually as the price of wool, both English and Irish, continued to decrease, two important things happened. One was that the Irish woollen merchants, finding the price of wool in the English markets too low even for them, began a clandestine exportation of wool to foreign countries. This, however, was not as yet done on a large scale. The other and more important result was that the Irish, finding the export of their wool unprofitable, began to work it up themselves, and greatly increased their woollen manufacture, hitherto carried on a small scale. The successful establishment of an Irish woollen manufacture in the years preceding the Revolution was the direct result of the prohibition of Irish cattle, and later on was to lead to perhaps the greatest commercial injustice ever inflicted by England on her sister country. The Cattle Acts, by a natural sequence of events, led to the destruction, ten years after the Revolution, of the Irish foreign trade in woollen goods.


It was not long before the evil consequences of the Cattle Acts were seen by many men in England as well as Ireland. There was a considerable decline in the customs revenue, for the customs previously paid on the importation of Irish live stock into England had amounted on an average to £32,000 a year.[79](javascript:footNote('E900040/note079.html')) Numerous pamphlets were written during the reigns of Charles II. and James II. urging the repeal of the Acts. It was pointed out that as English commodities were not essential to the people of Ireland, it was in the interests of England to encourage the importation of Irish cattle in order to keep the Irish as customers. It was also urged that if cattle were admitted into England, less wool would be grown in Ireland, and that it was this growing importation of Irish



---

p.40



wool which would in time ruin the wool and cloth trade of England.[80](javascript:footNote('E900040/note080.html')) The arguments contained in the pamphlets are often exceedingly curious, especially when we reflect that many of them were urged a long time after the passing of the Act of 1666, when its effects had fully worked themselves out and when it would have been well-nigh impossible to change the current of Irish commerce. The Irish had definitely turned their attention to fattening cattle for their provision trade, and to breeding sheep in order to supply themselves and the English with wool. They had commenced a thriving trade in provisions with foreign countries and the plantations, and even if the Cattle Acts had been repealed, and they had once more been allowed to export their cattle and provisions to England, they would surely have continued at the same time their trade with foreign countries. The only result would have been to give Ireland an extra market for her produce. Of course the repeal of the Acts would have been a wise measure for England, but it is doubtful whether she could ever have gone back to the position she had occupied before the Acts, the position of the importer of lean cattle, which she could fatten up for her own export trade. It is doubtful, too, whether the repeal of the Acts, even after a lapse of only ten or fifteen years, would have led to a decrease in sheep breeding, for the Irish woollen manufacture had already begun to establish itself, and with its gradual extension a further impetus would be given to the growth of wool, even though only a small fraction of Irish wool might be consumed within the country. The soil of Ireland, too, was particularly suited for pasture farming. This could be seen from the richness of Irish butter and the good quality of Irish wool. In fifteen years the Cattle Acts had done their work. They had turned Ireland from a country of cattle breeders into a country with a large provision trade, into a wool-growing 



---

p.41



country, and one in which a woollen manufacture was rapidly establishing itself. In return England had lost some part of her trade with Ireland, she found herself rivalled in foreign markets and in her own plantations by Irish goods, while a huge importation of Irish wool dragged down the price of her wool and impaired the prosperity of her wool growers. Certainly the first serious attempt on the part of England to restrict Irish commerce was fraught with disasters to herself.


It was fortunate for Ireland that at the time when the Cattle Acts were passed her trade with the English plantations was subject to little restriction, or rather, that she was not in a position to be seriously injured by the small restrictions which existed. The great Navigation Act of 1660[81](javascript:footNote('E900040/note081.html')) had excluded the Irish in no way from building ships or manning them, and in everything concerning the plantation trade had treated the Irish simply as English subjects. The thirteenth clause of the Act provided that the ‘enumerated’ commodities might be shipped from the colonies to Ireland as well as to England. In the next great Navigation Act, that of 1663,[82](javascript:footNote('E900040/note082.html')) Ireland was not mentioned by name, but as she was not expressly excluded from the privileges of English subjects she continued to carry on her trade with the plantations as before. It was this direct trade with the plantations which probably helped to tide Ireland over the period of distress incident on the prohibition of her cattle. It is true that this same Act laid down that no commodities of the growth of Europe were to be exported to the plantations except those laden or shipped in England, Wales, or the town of Berwick-on-Tweed. But this did not injure Ireland at all, because horses, servants, and victuals from Scotland and Ireland were excepted and allowed to be exported direct to the plantations. Ireland as yet had practically no manufactured goods for foreign export, so for some time she remained unaffected by the Act of 1663. For 



---

p.42



several years she carried on a thriving trade with the English as well as foreign plantations, exporting her horses and provisions direct and receiving in return all the commodities she wanted.


But this free trade with the English plantations did not last long. The growing prosperity of Ireland again aroused the jealousy of England, and the new ideas with regard to the position of colonies and dependencies were now beginning to be definitely formulated. The interference with the exportation of Irish cattle and the refusal of England to import Irish provisions had only resulted in giving Ireland a thriving provision trade with foreign countries and the plantations. Ireland was beginning to undersell England in the English plantations, a thing not to be endured. The plantations were regarded as the exclusive property of the Mother Country, and Ireland was held to have no more part or lot in them, and no more entitled to derive benefit from them, than if she were a foreign country. For though in respect to Ireland's trade with herself, England treated Ireland like a plantation, in respect to Ireland's trade with the American colonies, the Irish were to be treated no better than foreigners. This new conception of the Irish as being altogether outside the privileges of English subjects had been hinted at in the Navigation Act of 1663, but it was not until seven years later that it was further revealed in the Acts of 1670 and 1671.[83](javascript:footNote('E900040/note083.html')) These Acts expressly prohibited a large number of commodities, enumerated in the first Act, from being carried to Ireland from the plantations unless first landed in England. The most important of these commodities were cotton, wool, fustic or other dyeing wood, ginger, indigoes, sugars, and tobacco; also coffee, cocoanuts, whalefins, raw silks, hides, skins, and pot or pearl ashes from America.[84](javascript:footNote('E900040/note084.html')) As these enumerated commodities practically 



---

p.43



included all commodities exported from the plantations, Ireland was now unable to import any plantation goods direct in return for her provisions. This meant great inconvenience and expense to Irish merchants, for they had to incur all the extra freight, insurance, and warehouse charges and port fees incident on transporting their plantation commodities from England to Ireland. It therefore put a check to the increase of Irish shipping, for Irish merchants soon began to find it more convenient to get plantation goods straight from England through English merchants than to import them themselves by a circuitous and extremely expensive route. Further, as Irish merchants could not directly import plantation goods in return for their provisions, they began after a time to cease exporting so many provisions to the English plantations, and began exporting them to foreign plantations instead. Later on this export trade of Ireland, especially to the French West Indies, led to great complaints on the part of England, that the colonies of foreign countries could get their provisions cheaper than their own plantations. But this and other effects had hardly time to work themselves out during the reigns of Charles II. and his brother. It was not until after the Revolution, when the Navigation Laws became more strict and more severely interpreted, that the whole significance of Ireland's exclusion from the colonial trade began to be apparent. Real and great injuries were to be inflicted on Ireland by the Navigation Acts and the peculiar interpretation given to them. In proportion to the growth of her trade and industry these injuries came to be more and more felt, and Ireland found herself permanently shut off from many possibilities of commercial progress.


But it was not merely Irish trade with the West that was subject to restrictions. At this time the English



---

p.44



trade with the East Indies was already in the hands of an exclusive company trading through the port of London. Ireland was therefore cut off from a free and direct trade with the East Indies. This meant that she was unable to import East India goods from the place of their growth; she was also forbidden to import certain of these commodities from any place but England.[85](javascript:footNote('E900040/note085.html')) As time went on, Ireland was to find her foreign trade more and more restricted by the establishment in England of these exclusive companies, maintained by English capital and trading through some English port.


Although the commercial policy of the Restoration period was unfavourable to Ireland as regards her trade with England and the plantations, it did not interfere with her foreign trade. And this is why Ireland, until after the Revolution, when England began to interfere in every branch of Irish trade, kept fairly prosperous, although her growing commercial prosperity was to some extent checked by the later Navigation Acts of Charles II. The **Duke of **Ormonde**** did a great deal to increase the wealth of the kingdom. As soon as he found that all his efforts to prevent the passing of the Cattle Acts had failed, he set himself to improve the existing resources of Ireland and to establish native manufactures. The Irish Parliament, too, did something to encourage industry. In 1661 it had appointed a committee on trade to consider how Irish trade might be best advanced,[86](javascript:footNote('E900040/note086.html')) and in 1662 its Bill ‘for encouraging Protestant strangers and others to inhabit and plant in the kingdom of Ireland’[87](javascript:footNote('E900040/note087.html')) had some effect in promoting the woollen and linen manufactures. Many of the French refugees who landed in England were sent over to Ireland at the expense of Government, and received letters of naturalisation from the Irish



---

p.45



Parliament. But it was **Ormonde** who did most in this direction. He planted French colonies at Dublin, Cork, Waterford, Kilkenny, Lisburn, and Portarlington, and at all these places the refugees established glove-making, lace-making, silk-weaving, and the woollen and linen manufactures.[88](javascript:footNote('E900040/note088.html')) In many other ways Ormonde did much to promote native industries, and he also did something to improve the foreign trade of the country. Early in 1667, when the distress in Ireland was acute — for the war had led to a compulsory stoppage of commercial intercourse with foreign parts — Ormonde and his Council sent up a petition to the King. In this petition they begged leave to be allowed to trade freely with foreign countries in spite of the war, and asked for authorisation to forbid the importation of such commodities as would drain the country of its coin. In answer to this petition the King ordered that all restraints on the exportation of Irish commodities to foreign parts should be taken off, and that the Lord Lieutenant and his Council should issue a proclamation to this effect. Nothing, however, was to be done which might prejudice the charters of the East India Company, the Turkey Company, or the Canary Company. The Irish were also allowed to retaliate on the Scotch, who had just forbidden the importation of Irish cattle, beef, and corn.[89](javascript:footNote('E900040/note089.html')) A proclamation was accordingly issued on April 1st by **Ormonde**, that free trade was to be allowed between Ireland and all foreign countries whether at peace or war with the King, and that until further orders should be given, Scotch linen and woollen manufactures, stockings, and gloves, were not to be imported into Ireland, as they drew money out of the country and hindered the progress of Irish manufactures.[90](javascript:footNote('E900040/note090.html')) The exportation of wool from Ireland had not been



---

p.46



mentioned in the King's answer to the petition. But neither was it particularly granted, and as the existing law made the exportation of wool to any place but England felony, Ormonde was afraid to allow its exportation to foreign countries until he had made further enquiries on the matter. He therefore excluded wool from his proclamation and refused to give leave for its exportation unless the King should send a special letter saying it was his intention to include wool in the general freedom given to Irish exportation. But as no such letter ever came, the exportation of wool, except to England, continued to be a capital offence.


Now, until the Restoration, Ireland had generally been allowed to export her raw wool to any part of the world. But in 1660 an Act was passed which laid down that no raw wool should be exported from England, Ireland, Wales, or the town of Berwick-on-Tweed into Scotland or into any place outside His Majesty's dominions on pain of forfeiture of ship and cargo and confiscation of the goods and chattels of the master.[91](javascript:footNote('E900040/note091.html')) Two years later such exportation was made felony.[92](javascript:footNote('E900040/note092.html')) In this respect, of course, Ireland was merely treated like England and Wales, and the object of the Act may have been to increase the woollen manufacture in Ireland as well as in England. But the chief object was undoubtedly to secure a sufficiency of raw material for England's woollen industry, for Ireland was allowed to export wool to England on the granting of a special license by the Lord Lieutenant. Later on, when Irish wool flooded the English markets, England was afraid to prohibit its importation for fear that such a policy might lead to a large clandestine export of wool to foreign parts, or to an increase in the Irish woollen manufacture.


But although England had no objections to receiving the raw material for her staple manufacture from Ireland,



---

p.47



she had an objection to receiving Irish manufactures. The period of the Restoration begins the period of those prohibitory duties on Irish manufactures imported into England which was to last till the Union. The freedom which Ireland had hitherto enjoyed to import into England all her manufactures of wool, silk, gold and silver lace, and hats, was stopped by the Act of 1660, which granted the subsidy of tonnage and poundage.[93](javascript:footNote('E900040/note093.html')) In the Book of Rates which accompanied the Act woollen cloths were rated at £8 10s. the yard, and therefore liable to a duty of 8s. 6d. per yard. Other woollen fabrics were rated in proportion. Silk, gold and silver lace, and hats were rated so high as almost to stop their importation. In no case was any reservation made in favour of Ireland.


But this did not touch the Irish foreign trade in manufactured goods, and so Ormonde's efforts to promote Irish industry and foreign trade met with considerable success. He seems to have had the interests of the country at heart, and continually referred to his Council of Trade for advice in industrial and commercial matters. In 1675 this Council made certain interesting recommendations for furthering the trade of Ireland. It advised the repeal of the Cattle Acts, and recommended that Irish ships should be allowed to convey goods from America to Ireland without first landing them in England. It also strongly advised the nobility and officials of Ireland to discountenance the use of all foreign commodities which might be made in Ireland, and it suggested that corporations should be instituted for the internal navigation of the kingdom, and societies established for the promotion of manufactures, especially those of woollen, linen, and leather.[94](javascript:footNote('E900040/note094.html')) But it was not likely that Ormonde and his Council of Trade would be listened to in England, and so they had to promote Irish trade and industry as best they



---

p.48



could with the existing restrictions. Their success was undoubted, for in spite of the great temporary distress due to the Cattle Acts, Ireland continued to progress till the Revolution. Rents doubled, lands improved, trade began to flourish, the population in the towns increased, and the King's revenue advanced proportionately.[95](javascript:footNote('E900040/note095.html')) Contemporaries, indeed, were of the opinion that Ireland was improving more rapidly than any other country in Europe. The Cattle Acts had been productive of no permanent injury, and Ireland was not as yet in a sufficiently advanced economic condition to feel the Navigation Laws at all seriously, while her foreign trade remained unrestricted. She was able to export her provisions to the plantations, and both her provisions and her manufactures to foreign countries and foreign plantations. But with the outbreak of the Revolution all this changed. Ireland was once more to go through a period of civil war, followed by wholesale confiscations. Even after the peace, when the country began to settle down and take up the broken threads of its prosperity, the restrictive policy of England took away Ireland's chance of becoming an industrial nation, while the horrible penal laws crushed the life and spirit out of her people.




---

p.49


The Revolution and the Period of Restriction.
---------------------------------------------


Ireland after the Revolution — Peculiar Reasons for Restrictive Policy adopted towards Ireland — Destruction of the Irish Foreign Trade in Woollen Goods — Effects of the Measure.
From one point of view the Revolution may be regarded as the final conquest of Ireland by the English. It was, from the standpoint of the Irish, not so much a struggle between two dynasties or between loyalists and rebels, as the last desperate fight between two hostile races and religions. Legally speaking, the Irish were supporting their rightful sovereign; practically, they were striking a blow for national freedom. But the English conquest was complete, and once more Ireland was compelled to yield to the superior force of England.


Now this final conquest of Ireland gave to England a unique opportunity. It was in her power to bring Irish civilisation to a level with her own, to unite into one people the two races of English and Irish, to develop the wealth of Ireland, and make her people loyal supporters of the Empire. Perhaps such a policy on the part of England was too much to expect at such a time of bigotry and race hatred, when all the most evil passions in men's natures had just been awakened. Certainly it was not the policy pursued by England, and again the chance was lost of drawing the two kingdoms more closely together in sympathy and interest.


The condition of Ireland after the Revolution was miserable in the extreme. All the evils of oppression and tyranny which had existed in the country after the 



---

p.50



Cromwellian wars sprang into life in an intensified form. The Articles of Limerick, which had held out some hope of treating the native Catholics fairly, were violated. Most of the Roman Catholic gentry who had kept their estates after the Act of Settlement, or who had been reinstated by James II., were dispossessed, while the few who were allowed to retain their lands were stripped of all political and many civil rights, and left in every way at the mercy of their Protestant enemies. Much of the best blood and the most energetic spirits of the nation went into voluntary exile. After the capitulation of Limerick, fourteen thousand Catholics emigrated to serve in the armies of France, Spain, and Austria.[96](javascript:footNote('E900040/note096.html')) Between the Revolution and the peace of Aix-la-Chapelle there was scarcely a siege or a battle in Europe in which Irish troops did not take a part, and there was hardly a Catholic country in which Irishmen did not hold high posts. Those native Irish or Anglo-Irish Catholics who remained in their country could hardly feel much loyalty to the English Crown. To them, smarting with indignation at the loss of their lands, embittered by years of savage warfare, the English Crown could seem nothing more than a shadowy supporter of the English colonists, who had now the unhappy country at their mercy. There were, in fact, two nations in Ireland, one with all the wealth and political power, the other poor and humiliated, without rights or privileges, or freedom of conscience. For the next three-quarters of a century the history of Ireland was to be little more than a history of religious persecution, political corruption, and commercial and industrial restrictions. But the whole policy of England towards Ireland in the years following the Revolution has often been mis-stated and exaggerated. The severe restraints placed on Irish trade and industry have frequently been represented as the result of sheer spiteful malignancy, and with no real



---

p.51



reasons to justify them. Now this is a mistake, and the attitude of England towards Ireland can only be understood by looking at the position of England, and the difficulties and dangers with which she was confronted. At this time England was engaged in a great military struggle with France, and it was of the utmost importance that her available sources of revenue should not be impaired. Ireland and the colonies were countries of comparatively small industrial development, and to English politicians it did not seem particularly harsh to endeavour to direct their trade and industry into those channels in which they could not interfere with the existing industries in the Mother Country. Industries were being fostered in England to get wealth; this wealth was needed to fight France and the forces of Catholicism. If English industries dwindled and decayed, how should England stand up as the champion of freedom and Protestantism? But there were peculiar reasons for interfering in Ireland. It was not so much jealousy of Ireland as jealousy and fear of the English Crown which influenced the English legislature and English statesmen in their policy. Experience seemed to show that Irish prosperity was dangerous to English liberty. Under **Strafford**, in the reign of Charles I., and under Ormonde, in the reign of James II., something had been done to develop the existing resources of Ireland, and each time the king had been able to raise forces and supplies in the country with which he had tried to stamp out the constitutional rights of England. The difficulty was that Ireland was a separate kingdom, and that the English Parliament had no direct authority over her. It was this absence of direct authority which made England so nervously anxious to restrict Irish resources in all those directions in which they might even indirectly interfere with the growth of English power.


But there was another complication, and this was that there were two elements in Ireland; the one, as seemed to
contemporaries, orderly and in harmony with English ideas



---

p.52



and sentiments, the other turbulent and disorderly, alien in religion, and with differing ideas and sentiments. In this latter division were placed all those who had been deprived of their lands through various excuses, or who had taken part in the troubles of 1641 and 1689. They were not all native Irish, but they were practically all Papists, and so they came to be differentiated off as the Irish and Papish interest as distinguished from the Protestant interest, against which England had no general feeling of jealousy. English feeling towards these native Irish was one of hatred to their religion, and a consequent fear and dislike of their prosperity. So English statesmen set themselves to hunt down and persecute all those who professed the religion of their forefathers, because this religion seemed to them fraught with all sorts of political dangers, and to be an element of treason and disaffection. It was not so much because they were Irish as because they were Papists that England looked upon the old inhabitants of the country with hatred and distrust. And it is only necessary to think of the history of Europe during the years directly succeeding the English Revolution in order to understand this hatred and distrust of Roman Catholicism.


But the English colonists in Ireland were Protestants, and as much attached to the new dynasty and the new
order of things as were the English in England. And so England felt no real jealousy of them as a whole. Englishmen were, however, anxious that no section or party whatsoever in Ireland should be able to injure the existing resources of England, as this would strengthen Ireland at England's expense, and so be a constant source of danger. In so far as the trade and industry of the Protestant interest in Ireland proceeded on different lines from that of England, it was to be encouraged rather than discouraged. The task which English statesmen professedly set themselves after the Revolution was to foster the Protestant interest in Ireland in all those directions in 



---

p.53



which it did not interfere with the wealth and power of England.


These views of contemporary Englishmen give a simple explanation of the reasons which induced England to interfere with the Irish woollen manufacture. With her accustomed capacity for recuperation Ireland began, industrially speaking, to recover extremely rapidly from the effects of the Revolutionary War, as she had before done from those of the Cromwellian War.[97](javascript:footNote('E900040/note097.html')) In the years 1696, 1697 and 1698, exports and imports increased greatly, and it was said that this was chiefly due to the growth of an Irish woollen manufacture.[98](javascript:footNote('E900040/note098.html')) Certain it is, at any rate, that the woollen manufacture started forward with extreme rapidity after the Revolution. There seems to have been some emigration of weavers to Ireland during these years, for owing to the cheapness of living and labour in Ireland, and the low taxes, it seemed altogether a more profitable country in which to pursue a trade than England. At the beginning of 1697 the West of England clothiers sent up various petitions to Parliament alleging the decay of their trade and the increase of the woollen manufacture in Ireland. The ‘Merchants, Clothiers, and Fullers, and divers other Trades’ of Tiverton stated ‘that during the late Rebellion in Ireland, many of the poor of that kingdom fled into the West of England, where they were put to work in the woollen manufacture and learned that trade; and since the reduction of Ireland endeavours are used to set up those manufactures there.’[99](javascript:footNote('E900040/note099.html')) The woollen manufacturers of Taunton asserted that they were being undersold abroad by at least 20 *per cent* by the Irish, ‘by reason of the great growth of the woollen manufactory in Ireland; the great demands they have for the same from Holland, New England, and other parts, which used



---

p.54



to be supplied by England; the vast numbers of our workmen who go hither; the cheapness of wool and provisions there, and the decay of trade here.’[100](javascript:footNote('E900040/note100.html')) The makers of surges at Ashburton in Devon also presented a petition to Parliament in which they set forth that their manufacture, which was the main support of the inhabitants of the place, ‘lies under great discouragements, by reason that trade is set up in Ireland.’[101](javascript:footNote('E900040/note101.html')) All these manufacturers were extremely apprehensive lest labour should continue to be attracted away from them by the superior attractions of Ireland, and demanded such countervailing duties as would serve to neutralise the advantages of the Irish, and put the two countries on equal terms. And, indeed, there did seem some reason to fear that the West of England clothing trade was rapidly being transferred to Dublin.


For the time being the matter was referred by Parliament to the Commissioners of Trade and Plantations, and early in 1698 the report of the Commission was sent up to the Lords Justices in Ireland, setting forth the impossibility of Ireland continuing to progress in her woollen manufacture without injuring that of England. They advised that the Irish manufacture should be checked by prohibiting the exportation of all sorts of woollen stuffs from Ireland to any parts whatsoever, except that of frieze to England. In order to make this prohibition more effective, they recommended the imposition of heavy duties on oil when imported into Ireland, on *teasels* whether grown in the country or imported, on all the utensils employed in the manufacture and those used by worsted combers, and on all woollen stuffs, except frieze, before taken off the loom. The Commissioners also recommended that Irish wool should be exported to certain English ports free of duty, that the prohibition



---

p.55



of the woollen manufacture should be gradual, and that another industry should be encouraged in Ireland to take its place.[102](javascript:footNote('E900040/note102.html')) For the time being they proposed that a duty of 43 1/2 *per cent* should be imposed in Ireland on the exportation of broadcloth, and other duties calculated in the same way on the exportation of all other stuffs made or mixed with wool.[103](javascript:footNote('E900040/note103.html')) They seem to think that these duties would merely put Ireland on an equality with England in foreign markets.


The result of this representation of the Commissioners of Trade to the Lords Justices was not long in appearing. Shortly before, on January 3rd, 1698, a Bill in writing had been sent to the Irish House of Commons ‘for laying an additional duty on all woollen manufactures exported out of this kingdom, the passing of which in this Session his Majesty recommends to you, as what may be of great advantage for the preservation of the trade of this kingdom.’[104](javascript:footNote('E900040/note104.html')) This Bill had been received and read, but the Irish Commons were not particularly anxious to proceed in the matter, and nothing further had been done. But the agitation in England against the Irish woollen manufacture was now increasing, and the report of the Commissioners had made the English Parliament anxious to proceed in the matter. In the following June, both Lords and Commons presented an address to the king regarding the suppression of the woollen manufacture in Ireland and the encouragement of the linen in its place.[105](javascript:footNote('E900040/note105.html')) William replied that he would do all in his power to discourage the woollen trade in Ireland and encourage the linen manufacture; and here we have the essence of English policy towards Ireland, to promote the trade of Ireland on lines different from those along which the trade of England was developing. The linen



---

p.56



industry had attained some small degree of importance in Ireland, and the country seemed peculiarly suited for the growth of flax and the bleaching of linens. On the other hand, England had only a very small linen manufacture, and in 1698 the Commissioners of Trade and Plantations reported that it was making no progress. But the woollen manufacture was England's staple industry, and it seemed perfectly just and right to contemporaries that she should be left to reap the full benefits of it without rivalry from Ireland, while Ireland should be encouraged to devote herself to a manufacture which as yet did not seem necessary to the wealth of England.


On these lines the negotiations with the Irish legislature proceeded. At the commencement of the session of Parliament in September, 1698, the Lords Justices, in their speech before the Irish Houses, mentioned a Bill which had been transmitted from England for the encouragement of the linen and hempen manufacture. They stated that the ‘settlement of this manufacture will contribute much to people the country, and will be found much more advantageous to this kingdom than the woollen manufacture, which, being the settled staple trade of England, from whence all foreign markets are supplied, can never be encouraged here for that purpose; whereas the linen and hempen manufacture will not only be encouraged as consistent with the trade of England, but will render the trade of this kingdom both useful and necessary to England.’[106](javascript:footNote('E900040/note106.html')) The matter, indeed, was more or less of the nature of a compact. If Ireland would give up her woollen manufacture, England would allow her the linen manufacture and would even encourage her in it every way; at any rate the Irish linen trade would be subject to no interference. How far this virtual agreement was kept will be seen later, but at the time England was probably sincere enough, and the Irish



---

p.57




Parliament was bribed in this way to pass a measure which began the ruin of the staple industry of the country. For there is no doubt that at this time the Irish woollen manufacture was on a much larger scale than the linen, and that it was an industry for which the whole of Ireland was particularly well suited, whereas the linen manufacture was only suited to a small part of the country.


On October 24th the Irish Committee of Ways and Means resolved: ‘That it is the opinion of this Committee that an additional duty be imposed on old and new drapery of the manufacture of this kingdom that should be exported from the same, friezes only excepted.’[107](javascript:footNote('E900040/note107.html')) The House agreed, but it was one thing to agree to a resolution for imposing duties and another to impose them. At any rate the Irish Commons delayed and delayed until the Lords Justices, who despaired of ever passing the measure themselves, sent up to the House a second Bill for laying additional duties on all woollen manufactures exported.[108](javascript:footNote('E900040/note108.html')) The Bill went through its three readings with little opposition, for the Irish Parliament was powerless to make an effectual resistance now that its methods of obstructive delay had been baffled. Eventually the Bill passed by a majority of sixty-four.[109](javascript:footNote('E900040/note109.html')) This Act of 1698[110](javascript:footNote('E900040/note110.html')) imposed an additional duty of 4s for every 20s. in value on broadcloth exported out of Ireland, and 2s. for every 20s. in value on all manufactures of new drapery, friezes only excepted, to be imposed from the 25th of March, 1699, to the 25th of June, 1702.


It is possible that when these duties were imposed they were not meant to be prohibitory, but rather countervailing, their object being to place Ireland in the same position as England as regards advantages for carrying on the manufacture. If this is the case there must have been most extraordinary ignorance concerning the industrial



---

p.58



condition of Ireland, and a most extraordinary misconception as to the peculiar manufacturing advantages possessed by Ireland. It has been mentioned how the Commissioners of Trade and Plantations actually recommended 43 1/2 *per cent* as a duty proper to be placed on the export of old drapery from Ireland, and this seemingly after going into the matter and even after examining the Irish woollen manufacturers. This duty of 43 1/2 *per cent* was regarded by them as a mere countervailing duty, and not as a heavier tax which ‘would in effect amount to an absolute prohibition of the exportation of that sort of cloth from Ireland, which we humbly conceive can never be intended by that Bill.’[111](javascript:footNote('E900040/note111.html')) Such a statement shows the ignorance of the ruling class of Englishmen in all things that concerned Ireland, and it was very often this ignorance more than any real jealousy which did such harm to the country. It is hardly necessary to speculate on what would have been the effect of an export duty of 43 1/2 *per cent* when we know that the duties actually imposed of 20 *per cent* on the old drapery and 10 *per cent* on the new, though probably meant to be merely countervailing, really proved to be prohibitory. After all, the Irish woollen manufacture, in spite of the rapid progress it was making, was but an infant industry, and very different from the robust manufacture of England. What England was aiming at was that Ireland should not be in a position to rival her own staple manufacture. There was the old dread of the lands of Ireland rising in value and those of England falling, and in consequence the old fear lest the hereditary revenue of Ireland should rise at the expense of the revenue of England, and give to the English Crown supplies independent of the English Parliament.[112](javascript:footNote('E900040/note112.html')) It was also feared that if Ireland were allowed to establish a large woollen manufacture, she would use up all her wool and cease exporting any to



---

p.59



England.[113](javascript:footNote('E900040/note113.html')) But the direct and immediate reason of the Act of 1698 was to prevent an Irish industry from interfering with an established trade in England. The great fear was that if nothing were done the Irish would in time so increase their woollen manufacture as to carry on a large and successful trade with foreign countries; and one pamphleteer went so far as to say that it would be ‘more advantageous to England by the one half to buy these goods and throw them into the sea than to suffer Ireland to sell cheaper than we can in foreign markets.’[114](javascript:footNote('E900040/note114.html'))


But the Irish Act of 1698 proved to be merely a preliminary step in the process of crushing out Irish competition in the woollen trade. The notion of countervailing duties suddenly seems to vanish, and we see that what England really wanted was to shut Ireland off completely and finally from foreign markets, and that she believed nothing short of an actual prohibition would do this. The consequence was that in 1699 the English Parliament passed its first great Act restricting Ireland's trade with foreign countries, an Act passed not by means of the Irish Parliament, but directly by the English legislature. The legality of the measure was extremely doubtful, but Ireland was scarcely in a position to fight for constitutional theories. This Act[115](javascript:footNote('E900040/note115.html')) prohibited perpetually from the 20th of June, 1699, the exportation from Ireland of all goods made or mixed with wool, except to England with the license of the Commissioners of the Revenue. The duties, equal to a prohibition, which had been imposed by an English Act of 1660[116](javascript:footNote('E900040/note116.html')) on the importation of Irish woollens into England, were retained. The whole policy of England was therefore directed at deliberately destroying the Irish woollen manufacture. It will be seen in another chapter how far this policy succeeded; here it will be sufficient to notice



---

p.60



the direct effects of the measure on the trade and industry of the two countries.


Even from the avowed standpoint of England the destruction of the Irish foreign trade in woollen goods proved to be a mistake. The Irish, deprived of their export trade in manufactured woollens, and only able to export their wool to England, and that on payment of a heavy fee, began a large clandestine export of wool to foreign countries. This clandestine export had been going on for some years on a small scale, and two severe laws of William III. had tried to put a stop to it.[117](javascript:footNote('E900040/note117.html')) But now that Irish wool could not be used up profitably as before in making articles for foreign markets, there was a large amount of surplus wool which had to be sent somewhere. It soon became increasingly unprofitable to send such great quantities of wool to England, and so it was smuggled abroad. From 1712 to 1719 an enormous quantity of combed Irish wool was exported to France, the export being winked at by the customs officers.[118](javascript:footNote('E900040/note118.html')) It was packed very closely in barrels, and a little butter or beef placed at the top. During these years the price of English wool continued to fall, and this seems to have been partly the result of a certain decay in the English foreign trade in woollen stuffs, owing to the fact that the French were enabled by means of Irish wool to manufacture their own cloths. In 1719 English wool was only £7 or £7 10s. a pack, about £5 per pack less than the average price at the close of the preceding century. In the same year the plague stopped all intercourse with France; Irish wools ceased to be smuggled, and in consequence the price of wool in England rose to £11 or £12 a pack, owing to a great increase in the exportation of woollen goods. After the plague, when intercourse with France was renewed, English wool again sunk to £7 or £7 10s. a pack, until in



---

p.61



1739 it was only £4 10s. to £5 a pack. This great fall in price was owing to the fact that the French woollen manufacture had revived by means of a renewed clandestine exportation of Irish wool.[119](javascript:footNote('E900040/note119.html')) It was thought that at this time France obtained yearly three hundred thousand packs of wool from Ireland.[120](javascript:footNote('E900040/note120.html')) At the same time Irish wool was smuggled to Leyden and its neighbourhood by whole shiploadings.[121](javascript:footNote('E900040/note121.html'))


But another important result was produced by the interference with the Irish woollen trade. This was the emigration of Irish weavers to France, Holland, Spain, and Portugal. The Protestant weavers settled in France, where they were welcomed and protected by Louis XIV. in spite of the Revocation of the Edict of Nantes, and also in Holland, while the Catholic weavers started flourishing industries in Spain and Portugal. In all these countries Irish weavers did something towards establishing woollen manufactures, while their presence abroad naturally encouraged the smuggling of Irish wool to Europe. Certainly, from the beginning of the eighteenth century, for at least forty years, we hear of continual complaints that the English had lost the monopoly of the woollen trade, and that other European countries, especially France, were underselling them in foreign markets.[122](javascript:footNote('E900040/note122.html')) This was all put down to the exportation of Irish wool and the emigration of Irish artisans, and there must have been considerable truth in this statement. Irish wool was very like English, and a mixture of either Irish or English was necessary for making ordinary broadcloth. The French could make coarse cloths with their own wool, and very fine ones with Spanish wool, but for medium cloth, which was in greatest demand, they needed a mixture of Irish or 



---

p.62



English.[123](javascript:footNote('E900040/note123.html')) Soon after the Peace of Ryswick the French woollen manufacture began to progress, and the demand in France for English woollen goods was proportionally lessened until the outbreak of the succeeding war, which led to a temporary decline in French industry.[124](javascript:footNote('E900040/note124.html')) But about 1739 we hear of many complaints concerning the decay of the English woollen manufacture. It was said that before the Peace of Ryswick, Spanish and Dutch merchants used to come to the English manufacturers to buy with ready money all the goods that could be spared, and that the English could even afford to refuse their offers, keeping their goods for sale at home. Forty years later, on the contrary, the English manufacturers were often forced to let their goods lie for a year or two in Blakewell Hall, getting moth-eaten and at a great expense of house rent, factorage, and discount charges, for want of a market.[125](javascript:footNote('E900040/note125.html')) In 1729 we hear that the French have in great part engrossed the woollen trade in Turkey and the Mediterranean, formerly monopolised by the English; that the Germans can partly supply themselves with their own manufactures, while the Spaniards can clothe their army and court in their own stuffs.[126](javascript:footNote('E900040/note126.html')) In 1740 it was said that France, not England, now supplied Spain with those woollen stuffs which she did not make for herself.[127](javascript:footNote('E900040/note127.html'))


This foreign competition in her staple trade naturally reacted on the policy of England, and made her more anxious than ever to destroy the Irish woollen manufacture, in order to secure for herself a sufficient and cheap supply of the raw material. But the French, Dutch, and Spanish could all afford to give much more for Irish wool than the English merchants. This was because the price



---

p.63



of labour and living was dearer in England than on the Continent, and also because the fall in the price of English woollen goods due to the growing foreign competition forced the English manufacturers to give less than ever for the wool they imported. This fall in the price of Irish wool was therefore very far from securing to England a plentiful supply of the raw material necessary for her staple manufacture. What it did was to give to foreign nations Irish wool cheaper than ever, and at the same time to drag down the price of English wool to the level of Irish, to the great disadvantage of the English wool growers. The truth was that all these phenomena were reacting on one another. The restrictions on the Irish woollen manufacture resulted in a clandestine exportation of Irish wool to foreign countries, and in the emigration of Irish weavers; these were some of the causes which led to the successful establishment abroad of woollen industries which began to rival that of England; this foreign competition led directly to a decay in the English woollen manufacture; this produced a fall in the price of wool in England, whether English or Irish; this fall in the price of wool resulted not only in an increase in the clandestine exportation of Irish wool, but also to a large smuggling trade in English wool, for the English wool growers could now get a better price abroad than at home for their wool; this increase in the amount of English and Irish wool obtained by foreigners enabled them to make still further progress in their woollen manufactures; and this growth of foreign competition led to a further decay in the English manufacture. Each of these causes, in fact, reacted on every other cause.


In the existing state of the woollen manufacture, even all the wool that was produced in England could not be worked up profitably at home. It is therefore not surprising that large quantities of English wool were smuggled abroad, where wool of the particular kind grown in England and Ireland was in great demand.




---

p.64


The question of freight had also something to say to the clandestine exportation of Irish wool. Unless a far better price could be got in England than in foreign countries, it did not pay Irish merchants to export their wool to such staple towns as Norwich or Colchester, for the freight from Ireland to these towns was far more than the freight from Ireland to the Dutch ports.[128](javascript:footNote('E900040/note128.html')) If there had been a great demand for Irish wool in the western coast towns of England the matter would have been different, but after the first few years of the eighteenth century there was a great falling off in the amount of Irish wool demanded by the West of England clothiers. Indeed, one of the remedies that we hear constantly suggested for stopping the smuggling of Irish wool was an increase in the woollen manufacture of the West of England and Wales, in order to avoid the expenses of land carriage for the Irish merchants.


There were also special reasons why the French and Dutch could give a good price for English or Irish wool. Only one pack of English or Irish wool was needed to work up three or four packs of foreign wool;[129](javascript:footNote('E900040/note129.html')) and as this foreign wool was said to be two-thirds cheaper than English or Irish wool[130](javascript:footNote('E900040/note130.html')), it can easily be seen that the wool growers in England or Ireland could get a better price from foreign manufacturers than they could from English. The Dutch and French obtained large quantities of long and middling wool from England or Ireland, and mixing it with very cheap French, Polonia, or other foreign wool, made great quantities of coarse cloths, druggets, and stuffs which they exported to Spain, Portugal, Germany, and Turkey. These goods they were naturally able to sell a good deal cheaper than the English manufacturers, who made the same stuffs entirely with the much more expensive English or Irish wool. At the same time the French



---

p.65



and Dutch manufacturers were able to sell the fine broad cloth, on the manufacture of which the English had hitherto so justly prided themselves, just as cheaply as the English, by mixing the finest English or Irish wool with Spanish. All other goods they were able to sell at a much lower price. It was therefore little wonder that England should find herself confronted with rivals in her staple trade. This alleged decay of the English woollen manufacture was no doubt a little exaggerated by contemporaries. The fact that the woollen trade had been the principal trade of the country so long made any falling off in the amount exported appear an enormous misfortune. Still, there was certainly some decay, or at any rate comparative decay, in the industry during the first half of the eighteenth century, and this decay was greatly felt because those manufactures which were in later years to become so important, had not yet established themselves on a large scale. During the seventeenth century England had virtually monopolised the woollen trade in foreign countries; now she found that competitors were springing up everywhere. That she often found this competition acting to her own disadvantage is proved by the great and continued fall in the price of English wool during the first forty years of the eighteenth century, and by the growing quantities of English and Irish wool smuggled abroad. If the prosperity of the English woollen industry had continued, a great part of the Irish wool which was smuggled to foreign countries would have gone to England, while there would have been very little exportation of English wool. The clothing trade of the West of England seems to have suffered most. In 1742 there was scarcely anything left of the once flourishing woollen industry of this part of the kingdom.[131](javascript:footNote('E900040/note131.html')) In the southern and eastern counties, from whence large quantities of wool were smuggled abroad, there was a great decrease in the output of woollen goods. Only in the north, where the cheapest



---

p.66



goods were made, did the quantity of manufactured woollens maintain itself.[132](javascript:footNote('E900040/note132.html')) The most gloomy pictures are drawn at this time by various pamphleteers concerning the state of England.[133](javascript:footNote('E900040/note133.html')) The rents of all houses in cities were said to be falling; also the rents of estates. Specie was scarce, the numbers of poor were increasing, once flourishing towns had now decayed, and those left were being beggared by parish rates. The cause of this universal poverty was put down by all contemporary Englishmen to the decay of the woollen manufacture in England and its growth in France and other countries. And the idea that this was chiefly due to the interference with the Irish woollen trade seems to have been in the main sound, although it must be remembered that there were other causes at work which helped the growth of the woollen manufacture on the Continent.


The prohibition placed on the exportation of woollen manufactures from Ireland had still another effect injurious to England. This was an immediate decrease in the amount of woollen goods exported to Ireland. This may be accounted for partly by the use in Ireland of such articles of home manufacture as had previously been exported, and partly by the shock given to business and credit through the fresh restrictions placed on Irish trade. In 1700, before the effects of the prohibition had had time to work themselves out, a large quantity of English woollens had been exported to Ireland, but in 1706 this exportation had fallen off by about one-half.





[134](javascript:footNote('E900040/note134.html'))| Year | Old Drapery Yards | Old Drapery Value £ | New Drapery Yards | New Drapery Value £ |
| 1700 | 12,119 | 9,014 | 24,522 | 2,043 |
| 1706 | 5,114 | 4,135 | 15,308 | 1,913 |








---

p.67


Some years after 1706 this exportation gradually increased, owing to the rapid growth of the population of Ireland, until in 1714 Ireland imported as large a quantity of woollen manufactures as she had done before the prohibition. But the effects of the prohibition probably continued to act. We have the testimony of **Archbishop King, then Bishop of **Derry****, that the first effects of the Woollen Acts were to induce Ireland to manufacture for her own use more of her wool than she had hitherto done. ‘Even our women,’ he writes, ‘have fallen into it, and if this humour continue we shall not be much at a loss what to do with our wool, nor will England sell much more cloth by it.’[135](javascript:footNote('E900040/note135.html')) But, unfortunately, this humour did not continue, for in **Swift**'s time it was the universal complaint among patriotic Irishmen that the gentry and ladies of Ireland preferred foreign manufactures to those of their own country. It was only the poverty of Ireland which prevented her from importing large quantities of woollen cloth from England all through the eighteenth century. But by perpetuating through her policy the poverty of Ireland, England indirectly impaired her own trade with that country.


And so the first direct interference of England with the foreign trade of her sister country proved injurious to herself for a considerable period. The effects which gradually proceeded from this interference proved that it was impossible for England to engross the woollen trade, and that if she arbitrarily excluded Ireland from it, she would only find it wrested from her by foreigners. What she succeeded in doing was to injure her own trade and weaken the Protestant interest in Ireland.


There were many men who had partly foreseen these results when the Woollen Acts were passed and who had been loud in their complaints of the folly and injustice of the measure, and they were followed in their views by



---

p.68



writers of the next century. **Archbishop King** gives us in some of his letters a good idea of the dangers which, according to his opinion and that of many of his contemporaries, might be expected to arise to England from this interference with Irish trade. He had done his best to stir up opposition in Ireland against the measure, because he thought that it would be ruinous to both kingdoms, ‘particularly’ he writes ‘to the Protestant English interest of Ireland; that it tends to alienate the affections of the King's subjects from his Majesty, and to discourage them from his Majesty, and to discourage them from a vigorous prosecution of popery, whereby Ireland might be effectually secured to England without danger of rebellion.’[136](javascript:footNote('E900040/note136.html')) King also objected on principle to any direct interference with Ireland by the English legislature. In another letter he laments that he makes no progress in organising opposition to the new Woollen Bill, for in his opinion it seemed ‘not only destructive to us   
[*...*]  
 by our present suffering, but likewise by the example, for if the Parliament of England make laws for us at this rate they may likewise tax us and so beggar us when they please.’[137](javascript:footNote('E900040/note137.html')) But there was a curious apathy felt in Ireland on the matter. King tells us that the city of Dublin was afraid to interfere, that the Commons were headed by the Speaker, ‘who seems to be in the interest that endeavours to depress Ireland,’ while the Irish peasants were even overjoyed at the idea of the Bill, ‘for they reckon that the lands will generally be tenanted by them, they being most numerous, if the gentlemen be obliged to throw up their flocks.’ The principal losers, King points out, would be the English gentlemen and tradesmen, but these could not be induced to oppose the Woollen Bill, because ‘they are yet so devoted to England and have such hopes of returning to it that they seem rather desirous to enlarge than lessen the power of the Parliament of



---

p.69



England.’[138](javascript:footNote('E900040/note138.html')) As for the reasons which England alleged made it necessary to interfere with the Irish woollen industry, they were, according to King's opinion, absurd.[139](javascript:footNote('E900040/note139.html')) He emphasised the irony of forbidding Ireland to manufacture her wool simply because of the cheapness of living and labour in the country and the low price of the materials for manufacture, while he rightly thought that it was rather to the advantage of England than otherwise that English Protestant families should settle in Ireland and work up the resources of the country.


But even in England there was no lack of sane opinion on the subject. As the years went on many English pamphleteers blamed the policy of the English Parliament and condemned it as unwise and injurious to the interests of their country.[140](javascript:footNote('E900040/note140.html')) One of these pamphleteers agrees with the views of **Archbishop King** when he points out the dangers which will arise to England if she insists on hampering Irish trade.[141](javascript:footNote('E900040/note141.html')) The affections of the Irish must be alienated, and in consequence Ireland will have to be governed by force. He also points out, with a foresight which subsequent events justified, that ‘no kind of manufacture or branch of trade will flourish where any is prohibited; for men are never satisfied but that the power which has abolished one may deprive them of any other.’ In consequence he and many others advised that the Irish should be once more allowed to export their woollen manufactures. This, it was said, would really be to the advantage of England, for the Irish, through the abundance of their wool and the cheapness of their labour,



---

p.70



would be able to undersell foreigners in foreign markets. Once the Irish gained by their manufacture they would cease supplying foreigners with wool, and so England would gain by seeing her foreign rivals ousted from the trade. If England could not rival foreigners herself surely it would be wise to allow Ireland to do so.


But if England's interference with the Irish woollen trade proved injurious to herself, it proved much more injurious to Ireland. The disadvantages to English trade were after all but temporary, although they spread over a considerable period of time. Later on other industries arose just as beneficial and important as the woollen industry had been, and as competition adjusted itself it was found that certain kinds of British cloth would always be in demand in foreign markets. But the commercial injuries inflicted on Ireland proved permanent. The Irish woollen manufacture, indeed, was by no means destroyed, and after a few years a considerable quantity of Irish cloth and stuffs made or mixed with wool were used at home. There was also a small clandestine exportation of Irish woollen stuffs abroad. This was, however, very insignificant, and England was perfectly successful in her efforts to abolish all chance of Irish rivalry in foreign markets.


For fifty years after the Irish and English Woollen Acts of 1698 and 1699 the poverty of Ireland was extreme. We may see this from the writings of such men as **Archbishop King**, **Swift**, Bishops **Boulter** and **Berkeley**, and **Skelton**, no less than from the brief and convincing entries in the Irish Commons Journals. Everywhere we come across the opinion that the direct cause of this terrible poverty was English interference with Irish trade, more especially with the woollen trade. In 1703 the condition of the country seems to have been pitiable. On November 23rd the Irish Commons sent up a petition to the Queen setting forth in pathetic terms the great poverty and distress into which the country had fallen, ‘by the



---

p.71



almost total loss of trade and decay of our manufactures.’ They represented that the linen trade could not be increased enough in a short time in order to employ all the hands out of work through the recent prohibition, unless it was encouraged in some way by England. They therefore petitioned that they should be allowed to trade freely in their linen cloth with foreign countries, and to export all kinds of linens direct to the plantations, for in spite of all that had been promised, nothing had as yet been done to encourage the Irish linen industry.[142](javascript:footNote('E900040/note142.html')) From this time to the death of Queen Anne the poverty of the country increased rather than diminished. This may be seen from the speeches during the various parliamentary sessions and from the inability of Parliament to grant any but very small supplies to the Crown. The condition of the mass of the people could hardly have been worse. In 1706 **Archbishop King** wrote: ‘The poverty and discouragement of this country are so many that people think themselves happy if they can live, but for anything of curiosity or learning their hearts are dead to it.’[143](javascript:footNote('E900040/note143.html')) After the death of the Queen matters were for a long time little better. In 1720 King tells us that all classes and sections of the people were in distress: ‘Those that are here cannot get their rents from their tenants, the merchants have no trade, shopkeepers need charity, and the cry of the whole people is loud for bread. God knows what will be the consequence; many are starved, and I am afraid many more will.’[144](javascript:footNote('E900040/note144.html')) Even as late as 1731 the Speaker's speech at the bar of the Irish House of Lords mentions ‘the difficulties under which this exhausted kingdom unfortunately lies by the decay of trade, the scarcity of money and the unusual poverty of the country.’[145](javascript:footNote('E900040/note145.html')) There were many causes bringing about this state of things,



---

p.72



but one of the most important was the restriction on the Irish woollen trade. It gave a tremendous shock to the general industry of the country, and when other industrial and trade restraints were added by England one after another, Ireland had little chance of maintaining any industrial life at all. It was only in the latter half of the eighteenth century that the growth of a linen manufacture led to a comparative increase in the wealth of Ireland and enabled the Irish Parliament to make its efforts to support England in her wars.


It seems improbable that the prohibition of the exportation of woollen goods from Ireland led to any considerable decrease in the amount of wool grown in the country. The clandestine exportation of wool to foreign parts was much too profitable a trade to be given up, and until the period subsequent to 1740 there was no diminution in the quantity of wool smuggled abroad. The decrease in the exportation of Irish wool after 1740 was chiefly due to a British Act of 1739,[146](javascript:footNote('E900040/note146.html')) which took off the duties on woollen and bay yarn exported from certain ports in Ireland to certain ports in Great Britain, excepting worsted yarn of two or more threads. The object of this Act was to benefit the English woollen manufacturers, but it gave the first real check to the running of Irish wool.[147](javascript:footNote('E900040/note147.html')) From this time until nearly the end of the century there was a large exportation of woollen and bay yarn from Ireland to Great Britain.[148](javascript:footNote('E900040/note148.html')) With the growth, too, of population, more wool was now used in the Irish home manufacture than had been the case in the preceding century, and until the last quarter of the eighteenth century the area of land under tillage increased only very slightly.


But in 1779, when the Irish were once more allowed to export their woollen manufactures, it was found that



---

p.73



although the quantity of wool in the country had probably not decreased very greatly, the quality of it had certainly deteriorated. It will be seen in a later chapter how this deterioration was but the inevitable result of limiting the manufacture to home uses, and how, because of the prohibition of eighty years before, the possibility of the Irish establishing a flourishing woollen manufacture in 1779 was far smaller than it had been in 1698. The country was not so well suited to the industry; foreign markets did not offer the old advantages; there was little established skill among Irish weavers. Ireland had to begin the commercial and industrial race too late; she had been handicapped too heavily in the past to meet with success in the present.




---

p.74


The Period of Restriction (continued)
-------------------------------------


The Navigation Laws and their Effects—Further Restrictions on Irish Trade and Industry: (a) The Cotton Manufacture; (b) The Glass Manufacture; (c) The Brewing Industry; (d) The Sugar Industry; (e) The Fish Curing Industry—Encouragement given to Ireland to Export Unmanufactured Iron to Great Britain— Irish Foreign Trade in Provisions Unrestricted—Irish Trade still further Hampered by Establishment of Exclusive British Companies Trading to the East and other Parts—Practical Aims of English Statesmen as Exemplified in their Commercial Policy towards Ireland—General Effects of English Policy on the Economic Condition of the Irish People.
The severe restrictions placed by England on the Irish woollen manufacture proved perhaps more injurious to Ireland than any one of the other numerous restraints laid on Irish manufactures and commerce. But when we take all these other restraints together they form an appalling summary of restrictive legislation, and enable us to realise why Ireland remained so far behind other countries in the path of industrial development. It must, of course, be remembered that English interference with Irish trade injured the Irish Protestants far more than the Irish Catholics, for at this time the latter had but a small share in the general trade and industry of the country. The different trades were in the hands of exclusive Protestant corporations, and although the provision trade was conducted to some extent by Catholics, its chief profits went to the great landowners, the majority of whom were Protestants. During the eighteenth century this condition of things gradually altered, and the Catholics, owing to various causes, began to engross a great part of the trade and industry of Ireland. But for



---

p.75



the time being English interference with Irish manufactures and commerce was directly injurious to the Protestant rather than to the Papist interest, and thus, even from her own standpoint, England acted unwisely. She threw away the chance of establishing a flourishing Protestant State on the basis of an impoverished Catholic population, a State which in time might have given leaders to the people and led them on in the path of English culture and civilisation. For the sake of a few temporary gains, England lost the opportunity of making Ireland a wealthy and loyal country.


The Navigation Laws and the harsh interpretation placed on them inflicted severe injury on the colonial trade of Ireland and checked the development of Irish shipping and commerce for ninety years after the Revolution. Previous to the reign of James II., Ireland had not suffered to any great extent by the interference with her trade to the plantations. Victuals were still her staple export, and she was allowed to send them direct to the English colonies and settlements. But as time went on and the woollen and other manufactures sprang up in Ireland, the country began to feel the disastrous consequences of the Acts. No Irish manufactures, with the later exception of some kinds of linens, could be exported to the plantations without being first landed in England, while none of those plantation articles which the Irish needed could be imported without the added expenses due to the extra voyage from England to Ireland. With regard to the plantation trade, Ireland was in fact treated like a foreign country, and in certain respects she received more severe treatment than the American colonies. To take one example, an Act in the reign of Charles II. had allowed plantation produce to be shipped from one plantation to another,[149](javascript:footNote('E900040/note149.html')) but this Act was never extended to Ireland.


The importation of English colonial produce by way of England was so expensive, that Irish merchants soon



---

p.76



found it cheaper to import foreign plantation produce by way of France or Portugal. The freight charges between France and Ireland were little more than those between England and Ireland, while the commodities of foreign plantations were cheaper than those of the English colonies. By insisting on her plantation sugars being first landed in Great Britain, England only gained duties of 8d. per cwt. on sugars and 6s. 4d. per ton on molasses; but the Irish merchant, through greater freight charges, loss of time, and increased risk, found it cheaper to get his sugars straight from France and pay foreign duty.[150](javascript:footNote('E900040/note150.html')) Thus Ireland traded directly with the French ports for such articles as brandy and sugar, importing on an average by the middle of the eighteenth century about £14,000 worth of these articles every year.[151](javascript:footNote('E900040/note151.html')) In return the French had cheap Irish provisions, and it was alleged that this was the reason they were able to undersell the British in the European sugar trade, especially as the French colonies were allowed to refine their own sugars. Before 1779, Ireland imported on an average about £100,000 worth every year from foreign countries of such commodities as were produced in the British plantations.[152](javascript:footNote('E900040/note152.html'))


How far British commerce and shipping were really increased by the action of the Navigation Laws is a matter concerning which there are many different opinions, and one on which circumstances make it practically impossible to speak authoritatively. But it seems probable that in so far as these laws were aimed at excluding foreign nations from the carrying trade, they were in the long run and for a time successful in promoting British commerce. In so far, however, as they aimed at excluding Ireland and the plantations from the carrying trade, they were unwise and did not really further British interests.



---

p.77



Ireland's peculiar position and circumstances, indeed, resulted in the Navigation Laws injuring her rather than Great Britain. England may have suffered to a small extent from the loss of Irish custom, and Irish custom may have done something to increase the prosperity of foreign countries and their colonies at England's expense. But these injuries were exaggerated by contemporaries and loomed larger than they deserved in their imaginations, while the laws certainly had the effect of increasing Britain's carrying trade at the expense of that of Ireland. Yet in the long run, although Ireland was the chief sufferer from these commercial restrictions, England was weakened by them just as she was weakened by all other restraints placed on Irish trade and industry. She suffered not so much from immediate injuries, however important they may have appeared at the time, but from the general impoverishment of Ireland due to her own legislation. England would have gained enormously from a rich and contented Ireland; she suffered proportionately from a poor and discontented one.


Later on Ireland's prosperity might have increased in many ways had she been allowed a direct trade with the plantations. For example, if she could have obtained rum and sugar cheap from the colonies she might have distilled her own spirits from the sugar and made use of rum instead of French brandy. She could also have improved some of her home-made liqueurs and made some progress in the sugar-refining industry. For although Ireland could import foreign plantation sugars from Europe at a lower charge than she could by way of England those produced in British plantations, these sugars were naturally by no means cheap by reason of the additional expenses of the carriage from Europe to Ireland.


But as far as Ireland was concerned, the most important result of the Navigation Laws was the check they gave to the growth of Irish shipping. During the reign of Charles II. the amount of Irish shipping had been



---

p.78



gradually increasing. But at the end of his reign the consequences of the laws were beginning to make themselves felt, and after the Revolution the shipping of Ireland ceased to develop in proportion to the growth of her population and the increase of her trade. In 1698, indeed, it was said that Ireland had scarcely any shipping at all. Dublin had not one ship, Belfast and Cork had only a few small ships, while as for large ships there was not one in the whole kingdom.[153](javascript:footNote('E900040/note153.html')) The Dutch and French seem to have generally fetched the provisions they wanted from Irish ports, bringing in return the brandies, sugars, and other commodities demanded by Ireland. Irish merchants simply sent their provisions to England in English ships, as it was not worth their while to sail direct to the plantations when they were forced to bring their return cargo by way of England. Later on we hear of the ‘shameful deficiency’ of shipping in Ireland, and it was said that the country had fewer ships in proportion to its population than even the American colonies.[154](javascript:footNote('E900040/note154.html')) Between 1723 and 1772 Irish tonnage decreased by one-fourth, although the Irish trade required 110,000 more tons in 1772 than in 1723. During these fifty years the tonnage of British ships employed in this trade more than doubled, for in 1723 Great Britain possessed about two-thirds of the Irish carrying trade, while in 1772 she monopolised seven-eighths of it[155](javascript:footNote('E900040/note155.html'))


In this way were Irish resources wasted during the eighteenth century. ‘The conveniency of ports and harbours,’ said Swift, ‘which Nature has bestowed so liberally upon this kingdom, is of no more use to us than
a beautiful prospect to a man shut up in a dungeon.’[156](javascript:footNote('E900040/note156.html'))


---

p.79



But the restrictions placed on Irish trade and industry in the eighteenth century did not end with the Navigation Acts. Restraints were laid on every industry which might possibly compete with the corresponding British industry, and England tried to secure Irish raw materials exclusively for herself by forbidding Ireland to export such materials to foreign parts or by discouraging their manufacture at home. At the same time England did her best to exclude all Irish manufactures from her own markets by imposing on them more or less prohibitory duties. England only wanted raw material from Ireland, and with the single exception of the linen manufacture which it was convenient to encourage up to a certain point, discouraged the importation of all Irish manufactures, while taking care that the Irish markets should be kept open to all British goods at low rates of duty.


At the beginning of the eighteenth century the cotton manufacture existed on a small scale in England, and on a still smaller scale in Ireland. In the latter country it was discouraged as much as possible by various English Acts, which laid import duties amounting to 25 *per cent* on all Irish manufactures made or mixed with cotton when imported into England.[157](javascript:footNote('E900040/note157.html')) Another English Act in the reign of George I., which imposed penalties on any one wearing or using cotton goods in Great Britain unless made in that country,[158](javascript:footNote('E900040/note158.html')) had of course the effect of absolutely excluding Irish cottons from the British market, while the Navigation Laws prevented their exportation to the plantations. Under these conditions the manufacture could hardly progress, especially as British cotton goods were only subject to a duty of 10 *per cent* on their importation into Ireland. The result was that British cottons were imported in large quantities, and with the rapid development of the Manchester cotton industry, British merchants were able to undersell Irish cotton manufacturers



---

p.80



in the Irish market by means of their established skill, large capitals, and extended credit.[159](javascript:footNote('E900040/note159.html')) It was impossible for the Irish either to start a foreign export trade in cotton goods or to develop their home manufacture under such circumstances.


But a much more severe policy was pursued with regard to the Irish glass industry. Ireland had started this manufacture immediately after the Revolution. **Boate** tells us that several glass houses were set up by the English colonists in Ireland, the principal one being in the market town of Birr, in Queen's County. From this place Dublin was furnished with ‘all sorts of window and drinking glasses, and such other as are commonly in use.’[160](javascript:footNote('E900040/note160.html')) The sand necessary for the manufacture had to be got from England, but the ashes and clay for the pots could be obtained in Ireland. The industry made a good deal of progress during the years it existed free from restrictions, but a sudden stop was put to its development by an Act in the nineteenth year of George II,[161](javascript:footNote('E900040/note161.html')) which prohibited Ireland from exporting her glass to any country whatever. Nine years before[162](javascript:footNote('E900040/note162.html')) Ireland had been forbidden to import any glass not of British manufacture, so Great Britain destroyed the Irish export trade in glass while securing for her own glass the monopoly of the Irish market. She seems at this time to have been extremely anxious to develop her glass manufacture, but the industry made very little progress during the greater part of the eighteenth century, and not much benefit appears to have resulted from the interference with the Irish trade. Still British manufacturers were able to flood the Irish market with their glass, as they had to pay on importation only the small duty of 10 *per cent* Irish glass manufacturers were naturally soon undersold in their own markets



---

p.81



as their industry greatly declined owing to the prohibition on the export trade.


But for the Act of 19 George II., it is quite possible that Ireland might have competed successfully with Great Britain in the manufacture of glass. She was quite as favourably situated as regards the raw material necessary for making ordinary glass,[163](javascript:footNote('E900040/note163.html')) and much more favourably placed for the manufacture of Crown glass, for its principal ingredient, kelp, was produced in Ireland in large quantities. In 1785 it was stated before the Committee of the Privy Council, that practically all the kelp used in the English Crown glass manufacture was supplied by Ireland.[164](javascript:footNote('E900040/note164.html')) The glass industry had only been started in England after the Revolution, and it was conducted on quite a small scale in the reign of George II.,[165](javascript:footNote('E900040/note165.html')) so it was possible for Ireland to have established a flourishing glass manufacture without the usual fear of being crushed by British competition. This possibility is shown by the great rapidity with which the industry progressed in Ireland after the trade concessions of 1780.


British policy towards the Irish cotton manufacture is easy enough to understand, because the cotton industry was making extraordinary progress in England during the first half of the eighteenth century, and it did not seem wise to encourage possible rivals. But there was not the same justification with regard to the restrictions on the Irish glass manufacture, and here British policy seems to have been prompted solely by a spirit of commercial jealousy which had no practical cause for its existence. The same feeling of jealousy was shown by the way in which Irish silk manufactures were absolutely excluded from the British market, for Irish tabinets and lustrings 



---

p.82



were never even made in England, and Irish silk handkerchiefs were of a different kind to those made by English
merchants. Irish gloves were also excluded for fear their superior quality would be injurious to the home sale of British gloves.[166](javascript:footNote('E900040/note166.html'))


It has been seen that in her commercial policy towards Ireland, Great Britain aimed not only at excluding Irish goods from her own markets, but also at securing for herself the monopoly of sale in the Irish market. She fulfilled both of these aims in her dealings with the Irish glass manufacture, but the objects of her commercial policy were even more clearly exhibited in the case of the Irish brewing industry. The British exported large quantities of beer to Ireland on payment of the usual duty of 10 *per cent*, while they prevented the Irish from exporting their beer to Great Britain by means of a duty equal to a prohibition.[167](javascript:footNote('E900040/note167.html')) They also sent malt in great quantities to Ireland, and *forbade* its importation from that country. But in still another way England took care that Irish breweries should never compete with British, and that British beer should always find a market in Ireland. Hops could not very well be cultivated by Irish farmers, as they were too uncertain a crop for the small capitalist who engaged in farming. Therefore the British Act which laid down that no hops should be imported into Ireland except from Great Britain[168](javascript:footNote('E900040/note168.html')) left Ireland at the mercy of the British hop growers for one of the necessaries of life. The price of British hops was naturally very high in Ireland in the absence of all competition, and the Irish brewers had to pay much more for their hops than they would have paid had they imported them also from other countries.[169](javascript:footNote('E900040/note169.html')) At first this Act gave a



---

p.83



drawback on the excise of 1d. per pound on all hops exported to Ireland. But an Act in the reign of George I.[170](javascript:footNote('E900040/note170.html')) took away this drawback with the evident intention of raising a revenue for Great Britain on the consumption of Ireland, as the Irish had no choice but to pay the price which the British hop growers demanded. Even hops of the growth of the British plantations could not be imported into Ireland though first landed in Great Britain. For some time there were doubts on this point, but two Acts of George II. made it clear that all hops imported into Ireland must not only be shipped direct from Great Britain but must also be of British growth.[171](javascript:footNote('E900040/note171.html')) These hops, on importation into Ireland, were subjected by the same Acts to a duty of 1 1/2d. per pound over and above all other duties, customs and subsidies which had been settled and made perpetual in the first year of George II.[172](javascript:footNote('E900040/note172.html')) As British hop growers possessed the monopoly of the Irish market this extra duty naturally fell altogether on the Irish consumers.


In other ways Irish manufacturers were left at the mercy of Great Britain for their raw materials, and forced to pay higher prices than they need have done under more favourable circumstances. We have already seen how the Irish sugar refining industry suffered in this way. In the interests of the British sugar colonies, Ireland was forbidden to import sugars or molasses from the colonies of other powers, and in the interests of British agents, she was forbidden to import them straight from the British plantations. Two-and-a-half *per cent* commission was charged by English agents on sugar sent from the plantations to Ireland when unladen and re-shipped in England. The importation of rock salt into Ireland was restricted by an Act in Anne's reign[173](javascript:footNote('E900040/note173.html')) which laid for thirty years an additional duty of 9s. on every ton of rock salt exported



---

p.84



from Great Britain to Ireland; nor was Ireland allowed to export her salt to Great Britain.[174](javascript:footNote('E900040/note174.html'))


This duty on the exportation of British rock salt to Ireland was disadvantageous to the Irish fisheries, for it was difficult to get a plentiful and cheap supply from any other country. But these fisheries were not hampered by any direct restrictions. An Act of Charles II.[175](javascript:footNote('E900040/note175.html')) had confined the Greenland and Newfoundland fisheries to the inhabitants of England, Wales, and the town of Berwick-on-Tweed, navigating as directed by the Act of Navigation, victualling in England, Wales, or Berwick, and proceeding from these places on their voyage. A later Act[176](javascript:footNote('E900040/note176.html')) had vested all the rights of these fisheries in an exclusive company, but in the reign of Anne both fisheries were thrown open to any of her Majesty's subjects.[177](javascript:footNote('E900040/note177.html')) So from this time Ireland began to derive some profit from her deep sea fisheries. There was also very good fishing round the Irish coasts. In connection with these local fisheries there is a curious incident that well shows the extraordinary jealousy with which any possible Irish competition was regarded by the English people. In 1698, two petitions were sent up from Folkestone and Aldborough, stating that the inhabitants of these places suffered greatly ‘by the Irish catching herrings at Waterford and Wexford and sending them to the Straits, and thereby forestalling and ruining petitioners' markets,’ and therefore praying relief.[178](javascript:footNote('E900040/note178.html')) The motion in the English House of Commons in favour of the petitioners was fortunately rejected, but that such a petition should not only be presented, but should also be discussed seriously in Parliament, shows what a spirit of commercial prejudice and jealousy existed at that time.



---

p.85



Only one Irish industry besides the linen manufacture did England encourage in any way. It was to her interest to allow Ireland to engage in certain processes in the iron manufacture, as she required at this time more bar iron than she could produce herself. An English Act passed in the eighth year of William III. took off the duties on bar iron unwrought, and iron slit and hammered into rods, when imported from Ireland, but all other iron manufactures were subject on importation to prohibitory duties,[179](javascript:footNote('E900040/note179.html')) as English manufacturers wished to get bar iron cheap from the American colonies and Ireland, while retaining the subsequent processes of the industry in their own hands. This partial encouragement to the Irish iron industry proved disastrous to the country, for it led to the wasteful consumption of timber for smelting purposes. Irish timber, too, was liable to scarcely any duty on its importation into Great Britain, so that by the middle of the eighteenth century the iron trade of Ireland had nearly altogether disappeared owing to the impossibility of obtaining sufficient timber for smelting. In earlier times English policy had aimed at destroying the forests of Ireland for political reasons; now the encouragement of iron smelting in the country and of the exportation of Irish timber to Great Britain completed this destruction of the forests. The Irish Parliament tried to improve matters by imposing duties on all iron goods exported to any country but Great Britain;[180](javascript:footNote('E900040/note180.html')) but as the greatest amount of Irish bar iron went to Great Britain, this attempt naturally proved abortive.


If it had not been for her large provision trade, Ireland would indeed have fared badly during this long period of industrial and commercial restrictions. No restraint was placed by Great Britain on the exportation of Irish Provisions to foreign countries, nor was their direct



---

p.86



exportation to the English colonies forbidden. The effect of the Navigation Laws was indeed to check this direct trade in provisions with the colonies, but vast quantities of beef, butter, hides, and tallow were sent to the plantations by way of England, while an extremely thriving trade was carried on with foreign countries. The refusal of England to import Irish provisions was far more injurious to herself than it was to Ireland. In 1759, owing to the high price of provisions at home, she began to realise this fact, and an Act was passed allowing Irish hogs, lambs, tallow, and grease to be imported into Great Britain duty free for a limited time.[181](javascript:footNote('E900040/note181.html')) The provisions of this statute were extended by subsequent Acts until the free trade concessions of 1779 and 1780.[182](javascript:footNote('E900040/note182.html')) Another Act in the reign of George III. allowed the free importation of raw hides and skins from Ireland.[183](javascript:footNote('E900040/note183.html')) These Acts were passed with the avowed object of benefiting England, and with no intention of relieving Irish trade.


The provision trade was the great staple trade of Ireland all through the eighteenth century. In the latter half of the century, however, the linen industry, by means of many bounties and other encouragements, made considerable progress, and did much to relieve the poverty of the northern districts of Ireland. But with the exception of the provision trade, the linen industry, and the lowest processes of the iron manufacture, Irish commerce and industry were fettered in every direction. In most cases this was the effect of direct legislation on the part of England, or was carried out by Acts of the Irish Parliament at the bidding of England. In other cases it was simply due to the existence of close British companies with exclusive privileges of trading to certain parts of the world from certain British ports. The existence of these



---

p.87



companies shut Ireland off from commercial intercourse with a great part of the world, and forced her to pay high for many of the goods she imported. By an Act of 1719,[184](javascript:footNote('E900040/note184.html')) Ireland was forbidden to import any Indian, Chinese, or Persian wrought silks unless first shipped in Great Britain, and two years later another Act[185](javascript:footNote('E900040/note185.html')) prohibited the importation into Ireland of any commodity or manufacture of India, China, or Persia, unless shipped from Great Britain. It is clear that the organisation of British trade by means of exclusive trading companies must have been injurious to Ireland by checking absolutely her commercial progress in certain directions. Ireland could not have established successful trading companies of her own; the ill-success of the Scotch Darien Company, although backed by the power of an independent Parliament, is enough to show the impossibility of this. It was the attempt of the Darien Company to compete with English companies that more than anything else made England determined to procure a legislative union with the Scotch. Where Scotland failed it was not likely that Ireland would succeed.


Throughout the whole of this mercantile period, one great aim of English statesmen seems to stand out supreme and may be traced all through the commercial relations with Ireland as well as with other countries; this was the encouragement of home manufactures. Now in order to encourage these home manufactures a particular industrial and commercial policy appeared to be necessary. First of all it was very important to secure a plentiful supply of raw material; hence the prohibition on the exportation of Irish wool to foreign parts, and the permission given to Ireland to export bar iron unwrought and iron slit and hammered into rods into Great Britain. The second point in the policy of encouraging manufactures was the prohibition of the importation of finished goods into the



---

p.88



English markets; in the case of Ireland, this may be seen in the general refusal to import Irish manufactures. The third point in this policy was the encouragement of the consumption of English manufactures, both at home and abroad; this was another reason why Irish manufactures were not admitted, and it was also the reason why the Irish foreign trade in manufactured woollens and glass was destroyed, and why England was so anxious to secure a monopoly of sale in the Irish markets.


This desire of English statesmen to promote the manufactures of their country led directly to the Navigation Acts, and shut Ireland off from a direct trade in her manufactured goods with the English plantations. It also shut the Irish off from trade with the East, as the establishment of close trading companies seemed to contemporaries the best way by which British markets might be extended in those parts. Now the principle that colonies should send their raw materials to England and receive in return all their manufactured goods, was more injurious to Ireland than to the American colonies. England did not possess the raw material produced by her colonies, and so the latter could always command a good price for their commodities in the English market. But in Ireland, the soil, climate, and at this time the products also, were much the same as in England. Ireland could have supplied herself with manufactures for which she possessed the raw material in a way the colonies could not. But as a result of English commercial policy she had to send England raw material, for which she could not get a fair price, as it was produced by England as well as by herself.


Of the whole body of Irish Protestants it was the Ulster Presbyterians who suffered most of all from the commercial legislation of England. The restraints placed on their trade and industry were one of the chief causes which led to the large emigration of Protestants from the north of Ireland to America and the West Indies. Protestant artisans and merchants found their foreign trade either



---

p.89



denied to them altogether or rendered absolutely unprofitable by English legislation, while the poverty of the country prevented the development of a large home market for their goods. In consequence, during the first thirty years of the eighteenth century, there was a great and continuous emigration of Protestant families, chiefly from Ulster. In 1718 **Archbishop King** tells us that ‘many hundreds of families are gone out of this kingdom to **Cape Breton** this and the last years, and many more are on the wing. The reasons they give are landlords raising the land so on them that they are not able to live, the great discouragement put on Ireland by the Parliament of England, the cramping their trade, the landlords living in England, whereby the circulation of money is stopped, and there is a want of Government to protect and govern the country, and, lastly, the preferring Popish tenants to them, who live more frugally and meanly than they can do, are able to give greater rents, by which means the bulk of the land of Ireland is soon like to be in the hands of Papists.’[186](javascript:footNote('E900040/note186.html')) Between 1725 and 1728, 4,200 men, women, and children were shipped off to the **West Indies** alone, over 300 of them going in the summer of 1728.[187](javascript:footNote('E900040/note187.html')) There had been three successive bad harvests, and, in consequence, distress everywhere. The scarcity and high price of corn chiefly affected Ulster, where the people were possessed of a higher standard of comfort, and so helped forward the tide of emigration, which proceeded mainly from the north, and only from among the Protestants. Large numbers also emigrated to the American colonies; they generally landed in **Pennsylvania**, and from there many of them migrated to **Virginia**, **Maryland**, and **North Carolina**.[188](javascript:footNote('E900040/note188.html')) The majority of these seem to have been Presbyterians.




---

p.90


The Irish Protestant gentry were much alarmed at this general exodus from the north, for they realised the danger that would ensue to the Protestant interest if the Catholics increased at the expense of the Protestants. The Catholic peasants had at this time a great dislike to emigration. ‘No Papists stir,’ says King, ‘except young men that go abroad to be trained to arms with intention to return with the Pretender.’[189](javascript:footNote('E900040/note189.html')) The Catholics were now five times as numerous as the Protestants; they married earlier, and their standard of comfort was very low. They had already increased since the Revolution at a much more rapid rate than the Protestants, who were not content to subsist on potatoes, and demanded better conditions of living. It is, therefore, little wonder that English policy was looked upon with dislike by thoughtful men in Ireland, for England, by refusing to allow the Irish Protestants to grow rich in their own country, was driving them by thousands into exile.


There was, of course, another motive, and, perhaps, a still more powerful one, in urging the Ulster Presbyterians to leave their country and seek refuge in America. Only one form of the Protestant religion was allowed free exercise in Ireland, and that was the episcopalian form of worship of the Established Church of England. The Irish Dissenters were shut off from all political rights. In the Anti-Popery Bill of 1704 the Sacramental Test was inserted, and this of course excluded the Dissenters from municipal office. In 1713 the provisions of the Schism Act were extended to Ireland, and so no Dissenter could be a schoolmaster, while the Toleration Act, which was passed in England in 1789, allowing freedom of worship to Dissenters, was never extended to Ireland. The Presbyterians formed the bulk of the Ulster settlers, they were the most thrifty and industrious of the Protestants, and, had they been allowed, might have done much to increase the material wealth of Ireland, and would have formed an



---

p.91



element of stability in the country. But the short-sighted policy of England shut them out from all civil and municipal offices, and hampered their trade and industry in all directions. It is little wonder that so many of the Ulster Presbyterians felt that Ireland was no place for them. Even from the most narrow point of view, English policy was mistaken, for by it she drove the most energetic and enterprising of the Protestants into exile, she prevented the growth of a class which might have done something to draw England and Ireland more closely together, she split the Protestant body by refusing to tolerate any but one form of Protestantism, and she made the Presbyterians hate English rule. It was these men from Ulster, who settled principally in Pennsylvania and the New England States, as well as in the Southern colonies, who later on proved to be the very life and soul of the American struggle for independence. It was the Presbyterians who remained at home that played the chief part in the struggle with England for a free trade and a free Parliament.


The emigration of Protestants from Ireland did much to transfer part of the trade and industry of the country to the Catholics. King is very emphatic in stating that the Woollen Acts greatly weakened the Protestant interest in Ireland by driving out of the kingdom ‘almost all manufacturers, and thrown the manufacture of woollen almost entirely into Papists' hands, and in truth the greatest part of the trade of the kingdom.’[190](javascript:footNote('E900040/note190.html')) There were also other causes at work bringing about this new state of things. The laws which incapacitated Catholics from purchasing land, taking long or beneficial leases, or lending money on real securities, forced many of the Catholic farmers to leave the land and take to trade. About the second quarter of the eighteenth century we see the rise of a small class of Catholic tradesmen in the towns, many of them comparatively wealthy. The Protestants were



---

p.92



extremely indignant at this intrusion of the Papists in their trades, and levied a seemingly illegal impost called ‘quarterage’ on all Catholic traders. This impost was much resented at the beginning of the reign of George III., and, in 1767, **Lucas** introduced a Bill into the Irish House of Commons for establishing and defining the privileges of Catholic merchants.[191](javascript:footNote('E900040/note191.html')) But although the Bill passed both Houses of Parliament, it was quashed by the Privy Council, and so nothing further was done in the matter. The Catholics, however, do not appear to have been much injured by the impost levied upon them; certainly, as time went on, Catholic traders seem to have gathered a great part of the wealth of the country into their hands. It was not until the middle of the eighteenth century that the growth of the linen manufacture checked the emigration of the Irish Protestants by enabling them to make some sort of profit by manufacturing industry. The large Irish provision trade, however, was nearly entirely conducted by Catholics.


But the well-to-do Catholic traders formed a very small proportion of the total Catholic population; below them were the mass of the Irish peasants ignorant and poverty stricken, hardly able to keep body and soul together. English commercial policy did not directly injure the poorer class of Catholics, but by checking the industrial development of Ireland it injured them indirectly by compelling them to remain entirely on the land and closing all means of escape. At the same time various causes, which will be mentioned in a later chapter[192](javascript:footNote('E900040/note192.html')) prevented the people from gaining any but a bare and precarious living from the land. The only persons in Ireland who were comparatively prosperous were the great graziers and a small middle class in the towns engaged in trade. The poverty of the country is noticed by every contemporary pamphlet which deals with Ireland, whether written by Irishmen or



---

p.93



Englishmen, for the first three-quarters of the eighteenth century. We have already seen what piteous accounts **Archbishop King** gives us of the terrible misery he saw all around him. ‘The misery of the people here is very great,’ he writes on one occasion, ‘the beggars innumerable and increasing every day by the restraint on their industry by your English laws and the tyranny of landlords ... one-half of the people of Ireland eat neither bread or flesh for one half of the year, nor wear shoes or stockings; your hogs in England and Essex calves lie and live better than they.’[193](javascript:footNote('E900040/note193.html')) Some years later, in one of the frequent years of scarcity, we are told that the Irish poor ‘are sunk in the lowest depths of misery and poverty; their houses dunghills, their victuals the blood of their cattle, or the herbs of the field.’[194](javascript:footNote('E900040/note194.html')) In 1764 the description given to us by **Bush** in his Hibernia Curiosa shows that the economic condition of the Irish peasants had not improved since earlier in the century. After they had paid the demands of their landlords, the parish priest, and their own priest, ‘the poor wretches have hardly the skin of a potato left them to subsist on.’ These people lived in cabins without chimneys, and built of such bad material that the rain made its way through everywhere. **Primate Boulter** thought that the tenant had hardly more than one-third of the profits he made from his farm for his own share, and too often but one-fourth or one-fifth part, as the tenant's share was charged with tithe.[195](javascript:footNote('E900040/note195.html'))


There is no doubt that the penal laws were one great cause of the poverty which was universal in Ireland during this period of restriction. They discouraged thrift, and made the mass of the people contented with a very low standard of comfort, while at the same time they altered the national character very much for the worse. The penal 



---

p.94



laws led indirectly to a great decay of trade and industry. It was just because of the existence of the penal code that the commercial restrictions fell so heavily upon the country. Foreign trade was hampered by England, but this would not have mattered nearly so much had the population of Ireland only been progressive and prosperous, and so able to create a large home demand. But no home manufactures could really thrive in a country where the bulk of the people were sunk in a depth of poverty which has seldom been equalled and probably never surpassed in any European nation. It is only when we take English commercial and financial policy in conjunction with the policy of persecuting the Irish Catholics that we can get a clear idea of all the causes at work during the eighteenth century preventing the development of an Irish nation, and leaving the Irish people in such depths of misery and barbarism.




---

p.95


The Irish Woollen Industry
--------------------------


The Irish Woollen Industry previous to the Restoration—From the Restoration to the Revolution—After the Revolution—Maintenance of the Industry after the Acts of 1698 and 1699—Obstacles to the Progress of the Manufacture after the Concessions of 1779.
In considering the severe restrictions placed by England on the Irish woollen manufacture, two questions naturally rise to our minds: one, to what extent had this industry really developed in Ireland before the Acts of 1698 and 1699; the other, how far did it manage to maintain itself after these Acts. By finding an answer to the first of these questions we may get some insight into the real injury inflicted on Ireland by the prohibition of her foreign trade in woollen goods, while by looking into the other we may see whether Ireland showed herself fitted for the industry by managing to develop it to some extent in face of such immense disadvantages. We may thus get some solution of the problem whether Ireland could have developed a large woollen manufacture had she been untrammelled by English commercial policy.


It is hardly necessary to emphasise the peculiar fitness of Ireland for wool growing. The first thing that seemed to strike Englishmen of the sixteenth and seventeenth centuries when they visited Ireland was the excellence of the soil for cattle and sheep grazing. **Boate** noticed that good grass grew on the highest cliffs along the coast,[196](javascript:footNote('E900040/note196.html')) and although the soil could produce good corn, ‘nevertheless hath it a more natural fitness for grass, the which in most 



---

p.96



places it produceth very good and plentiful of itself or with little help.’[197](javascript:footNote('E900040/note197.html')) The consequence was that there were huge flocks of sheep in the country during the reigns of Elizabeth and James I., and up to the time of the Rebellion.[198](javascript:footNote('E900040/note198.html')) There must have been a large domestic manufacture of native wool during this period, for the Irish of both sexes, and of all ranks, clothed themselves from head to foot in their rough native cloth. Wool was not allowed to be exported, and so was worked up at home. In Elizabeth's reign the long woollen mantle was the habitual covering of the Irish, both men and women; underneath was generally worn a linen smock or shirt.[199](javascript:footNote('E900040/note199.html')) Later on, the men wore breeches and short coats made of coarse cloth of different colours, coarse woollen stockings, woollen caps or hats, and over all the same, a large mantle of frieze.[200](javascript:footNote('E900040/note200.html')) The number of woollen garments worn by women and children also increased, and altogether the amount of wool necessary to make the garments of one individual must have been considerable. This native cloth was, no doubt, very rough and coarse. It was made by the women in their own homes, and the greater part of it was used by the people themselves. Some was, however, exported from very early times. In the reign of James I. we are told that the Irish exported frieze in great quantities, and that many of the rugs made at Waterford were also sent to other countries.[201](javascript:footNote('E900040/note201.html')) Yarn, too, was spun in large amounts for foreign exportation. In an English Act of Parliament passed in 1543[202](javascript:footNote('E900040/note202.html')) prohibiting the importation of Irish wool into England, woollen yarn is enumerated as among the principal branches of Irish trade, while in a 



---

p.97



later Act of 1571[203](javascript:footNote('E900040/note203.html')) it is stated that Irish merchants had been exporters of this article for more than one hundred years. At this time it was thought good policy to encourage the Irish woollen manufacture. This was done both by English Acts of Parliament from the reign of Edward III. to that of Charles II., and also by many Irish Statutes passed with the approval of the English Privy Council.[204](javascript:footNote('E900040/note204.html')) In consequence the industry made some progress, and in 1636 **Strafford** noticed that there were ‘some small beginnings towards a clothing trade’ in the country .[205](javascript:footNote('E900040/note205.html')) He did not, however, follow the old policy of encouraging the woollen industry in Ireland; on the contrary, he proposed to discourage this clothing trade as much as possible, for if the Irish continued to manufacture their own wool ‘it might be feared they might beat us out of the trade itself by underselling us, which they were able to do.’[206](javascript:footNote('E900040/note206.html')) **Strafford**, therefore, began the later policy of encouraging a linen manufacture in Ireland while discouraging the woollen. At the time his efforts were marked with some success, but the Rebellion destroyed the beginnings of his linen industry, and his scheme was not again taken up until the end of the century. The mere fact that **Strafford** anticipated possible Irish rivalry in the woollen trade shows that he thought the country peculiarly suited for the manufacture, and that he looked forward to its speedy development.


At the Restoration Irish wool could not be exported even to England, and after the effects of the Cattle Acts had worked themselves out in increasing the number of sheep in the country, there was such a quantity of wool in Ireland that this prohibition was felt to be a real grievance. Although the mass of the Irish people only



---

p.98



used native cloth, for the duty laid on broad cloths and stuffs exported from England was too high to admit of their importation in any large quantities, all the wool in the country could not be worked up, and in 1661 we hear the first complaint of a clandestine exportation of Irish wool to France and Holland.[207](javascript:footNote('E900040/note207.html')) In the same year the Committee on Trade in the Irish House of Commons reported that the restraint on exporting wool into England was an obstruction of trade, bearing in mind the great quantity of wool in Ireland which was not all needed in the home manufacture. They resolved that wool was an article of trade, and as such should be exported freely, and they appointed a committee to desire the Lords Justices to allow the exportation of wool to England.[208](javascript:footNote('E900040/note208.html')) This request of the Irish Commons,[209](javascript:footNote('E900040/note209.html')) together with a further petition that the duty on English stuffs exported to Ireland might be lowered,[210](javascript:footNote('E900040/note210.html')) seems to show that the Irish woollen industry was very inconsiderable. We have, however, to think of the huge amount of wool which even at this time existed in the country, and also of the *highly developed* state of the English woollen manufacture. The Irish manufacture was, of course, crude and rough, and on a very limited scale compared with that of England; the better sorts of cloth were probably not made at all, and it would certainly be a very long time before Ireland would be able to work up all her own wool. **Petty**, however, estimated that nearly three times as much wool was used in the home manufacture as was exported,[211](javascript:footNote('E900040/note211.html')) while it must be remembered that at this time England still found her own stock of wool sufficient for her large industry. The great and *rapidly increasing* quantities of wool in Ireland at least show that the
 


---

p.99



progress of the manufacture was probable, and that only time and encouragement was needed to develop it. An Act passed by the Irish Parliament in 1666, ‘for the true making of all sorts of cloth called the Old Drapery and the New Drapery, and the true searching and sealing thereof by His Majesty's aulnager within the kingdom,’[212](javascript:footNote('E900040/note212.html')) is evidence that the industry was progressing, and under the administration of Ormonde it certainly made rapid strides. Ormonde was extremely anxious that the Irish should work up their own wool into all sorts of cloth for home consumption, and thus do away with the necessity of importing the better and finer kinds. **Sir Peter Pett**, who presented a memorial to the Duke concerning the establishment of a woollen manufacture, recommended that fine worsted stockings and Norwich stuffs should be made in the country. He thought that in time this manufacture might be so improved as to be used in foreign trade, and he observed that as Ireland lay more conveniently to Spain than England, the Irish might eventually procure for themselves the chief part of the woollen trade with that country. Ormonde therefore introduced into Ireland Protestant refugees who were skilled in the industry, and established colonies of them in different places to carry on the manufacture. By this means a woollen manufacture was set up at Clonmel. It was carried on by five hundred Walloon families, to whom Ormonde gave land and houses on long and easy leases.[213](javascript:footNote('E900040/note213.html')) At Cork the woollen manufacture was begun by **James Fontaine**, a Huguenot refugee. He was the pastor of the French congregation in the town, but finding he could not live on the small subscriptions collected for him, he began a manufacture of broad cloth.[214](javascript:footNote('E900040/note214.html')) Under Ormonde's encouragement this manufacture progressed, and began to



---

p.100



include different kinds of woollen cloth and ginghams. About the same time some French refugees settled at Waterford to make druggets and such like articles,[215](javascript:footNote('E900040/note215.html')) so that the country gained considerably from this foreign immigration. But the English woollen manufacturers also did something to increase the industry. We are told in an interesting letter written in 1677 by an Irish gentleman to his brother in England[216](javascript:footNote('E900040/note216.html')) that just before the Acts were passed prohibiting the exportation of Irish cattle, some West of England clothiers, ‘finding their trade decaying and themselves very poor,’ emigrated to Ireland, tempted by the cheapness of wool and of living and the seemingly thriving state of the country. They started a manufacture in Dublin which was ‘growing daily.’ About the same time sixty Dutch families came over from England and set up a manufacture in Limerick; but this decayed at the outbreak of the Dutch wars, and was not again revived on any large scale. A few years later, however, some English clothiers came over to Ireland and established various manufactures in the neighbourhoods of Cork and Kinsale, which a few years later had become ‘fairly considerable,’ while about 1675 certain London merchants started another woollen manufacture at Clonmel. The writer of this letter adds that a few other small attempts had been made to develop the Irish woollen industry, and exclaims indignantly that ‘it were more allowable to plant poison than manufactures with us.’ He does his best, however, to emphasise the limited scale on which the industry was carried on, and declares that, ‘modestly speaking, the whole quantity of what we work up in Ireland amounts not to the half of what any one clothing county in England works up.’ At the same time he seems to believe in the possibilities of the manufacture, and advocates its encouragement in order



---

p.101



to increase the King's revenue, people the country, raise the rents of land, and ‘wear off the barbarity of the common Irish.’ On the whole, evidence seems to show that although the Irish woollen manufacture was on a small scale compared with that of England, yet it was larger than is generally thought, while it certainly made some progress from the Restoration to the end of the century. During the reign of Charles II. the Irish consumption of English woollen goods decreased steadily.[217](javascript:footNote('E900040/note217.html')) The Irish Parliament had altered its policy of trying to obtain English woollens cheap for Irish consumption, and now tried to foster the native manufacture by laying import duties on English cloth, stuffs, stockings, and hats, while at the same time it discouraged the exportation of Irish wool.[218](javascript:footNote('E900040/note218.html')) During these years there was a great rise in the Irish revenue, and this was generally attributed by both English and Irish to the progress of the woollen manufacture, ‘which continually furnished poor spinners and combers with daily money to smoke and drink; so that in all the towns where the said manufactures were, the inland excise advanced incredibly.’[219](javascript:footNote('E900040/note219.html')) The policy of the Irish Parliament in discouraging the importation of English woollen goods was certainly thought by contemporaries to be instrumental in the development of the Irish manufacture. The author of Britannia Languens was especially strong on this point. He says that ‘since the late Irish Acts, the Irish have set up a considerable woollen manufacture of their own, for frieze and stuffs and now make good cloth,’ while the English importation of woollens into Ireland had



---

p.102



steadily diminished.[220](javascript:footNote('E900040/note220.html')) Irish frieze, too, was imported in large quantities into England and Scotland,[221](javascript:footNote('E900040/note221.html')) as the demand for it was very great. The complaint, however, that Ireland was importing very much less of English woollen manufactures seems to have been a little exaggerated. At any rate, the statements on this point vary greatly, and although it is certain that there was a steady falling off in Irish consumption, no satisfactory figures can be obtained of the exact decrease in this branch of trade.


It was after the Revolution that the Irish woollen manufacture began to make really rapid strides. The resolution in the Irish House of Commons in 1695, for regulating the manufacture,[222](javascript:footNote('E900040/note222.html')) and the resolutions of the Committee of Supply in the same session,[223](javascript:footNote('E900040/note223.html')) seem to imply a considerable progress in the industry. Dutch and Spanish merchants were now exporting Irish woollen stuffs from Ireland, and also great quantities of ‘sheep's grey and white frieze’ and stockings from Cork, Youghal, Waterford, and Dublin.[224](javascript:footNote('E900040/note224.html')) English woollen merchants were buying Irish woollen goods, exclusive of stockings and friezes, for sale abroad, owing to their superior cheapness over English,[225](javascript:footNote('E900040/note225.html')) and the Irish were supplying the English plantations clandestinely with cloths and stockings.[226](javascript:footNote('E900040/note226.html')) In 1698, it was stated that the woollen manufacture was giving work to twelve thousand Protestant families in Dublin and thirty thousand over the rest of the country.[227](javascript:footNote('E900040/note227.html')) The Papists, too, were beginning to flock into the trade, as may be seen from a petition presented to the Irish House



---

p.103



of Commons in 1698 from the Protestant woollen manufacturers of Ireland.[228](javascript:footNote('E900040/note228.html')) This petition set forth that in 1692 the Papists in the manufacture were few, but during the last six years they had got one-third part of the industry into their own hands, and had left such callings as they were bred to ‘and have set up and followed the manufacture.’ There must therefore have been large numbers of Irish employed in the trade besides the forty-two thousand Protestant families mentioned above. There was indeed no reason why the Irish woollen manufacture should not progress. It was now fairly started, and time would give the necessary skill and capital for extending it on a large scale. Irish wool was capable of any increase, and was equal to the best Northamptonshire or Leicestershire wool.


But if evidence shows that the woollen industry was making rapid progress in Ireland, and seemed eminently suited to the country, it also shows that the jealous fears of England were exaggerated and premature. Only friezes were exported from Ireland in any considerable amount, so that the English prohibitory Act was gratuitously oppressive. In 1687, the year of the largest exportations from Ireland, the total value of woollen manufactures exported did not exceed 70,5211 l. 14s., and of that sum the value of friezes amounted to 56,485 l. 10s., and that of coarse stockings to 2,520 l. 18s., while the whole value of both old and new draperies only amounted to 11,514 l. 10s.[229](javascript:footNote('E900040/note229.html')) As friezes were not made in England, English woollen manufacturers could not be injured by their exportation to foreign markets. As time went on, however, the Irish exportation of both old and new drapery would, of course, have progressed, and it was of this presumably that the English were thinking when they destroyed the Irish foreign trade in manufactured woollens. The following



---

p.104



table shows the amount of woollen goods exported from Ireland to all parts of the world in various years from 1685 to 1698:—





[230](javascript:footNote('E900040/note230.html'))| Year | Old Drapery Pcs. | new Drapery Pcs. | Frieze Yards | Hats No. | Rugs No. | Stockings Pairs |
| 1685 | 32 | 224 | 444,381 |  |  |  |
| 1687 | 103 | 11,360 | 1,129,716 |  |  |  |
| 1696 | 34.75 | 4,413 | 104,167 |  |  |  |
| 1698 | 281.25 | 23,285.5 | 666,901 | 4,470 | 458 | 9,509 |






The amounts exported are not large, but they show that the trade was progressing. Ireland still imported a good deal more old drapery than she exported, but in 1698 she exported more new drapery than she imported.[231](javascript:footNote('E900040/note231.html')) A great variety of woollen stuffs were manufactured in the country, as may be seen from an Act passed by the Irish House of Commons in 1705 forbidding the stretching of certain cloths and stuffs.[232](javascript:footNote('E900040/note232.html')) This Act mentions, among other stuffs, broad cloths, half cloths, druggets, simple serges, cloth serges, flannels, cloth and worsted druggets, druggets mixed with silk, cotton, or linen yarn, ratteens, kersies, friezes, narrow bays, paragons, farandines, camblets, worsted stuffs, and worsted stockings.


There was, then, a fairly thriving woollen manufacture in Ireland on a small scale during the last years of the seventeenth century, and the fact that the prohibition placed by England on the exportation of Irish woollen goods did not destroy the industry, goes some way to prove that the woollen manufacture might have become a source of wealth to the country, and that an immense



---

p.105



injury was inflicted on Ireland by English interference with this branch of trade.


The consequences of the Act of 1699 were not long in showing themselves. Scattered through the Irish Commons Journals we find various notices of petitions sent up by the woollen clothiers and weavers of Dublin and other places setting forth the great decay of their trade and praying relief.[233](javascript:footNote('E900040/note233.html')) From 1698 to 1710 there was a steady fall in the value of exports due to the absence of an exportation of woollen goods to foreign parts.[234](javascript:footNote('E900040/note234.html')) The fall may have been to some extent compensated by an increase in the clandestine exportation of raw wool, but of course this would not be mentioned in the Custom House Books. Practically no woollen manufactures except friezes and coarse stockings were sent to England on account of the prohibitory import duties. The exportation of woollen manufactures to foreign parts did not, however, entirely cease, for in 1739 we hear of a clandestine trade in stuffs to Lisbon, in which the Irish were said to undersell both France and England.[235](javascript:footNote('E900040/note235.html')) An Act in the first year of Anne[236](javascript:footNote('E900040/note236.html')) allowed the Irish to export the necessary clothing for certain Irish regiments stationed at the Leeward Islands, but this concession did not last long, for two years later another Act[237](javascript:footNote('E900040/note237.html')) forbade any woollen manufacture whatever to be exported from Ireland to the plantations unless taken on board in Great Britain. The drawbacks allowed on the re-exportation of Irish woollens from Great Britain were too small to make it profitable for Irish merchants to send their woollen goods to the plantations by way of England. Nor could Ireland for some time reap any legitimate profit by combing wool or spinning



---

p.106



woollen yarn for foreign markets. The exportation from Ireland of mattresses or beds stuffed with combed wool or wool fit for combing was forbidden,[238](javascript:footNote('E900040/note238.html')) while bay yarn and woollen yarn could not be exported at all to foreign parts, and only to England on payment of a heavy duty.[239](javascript:footNote('E900040/note239.html')) Great quantities of combed wool were, however, smuggled to France,[240](javascript:footNote('E900040/note240.html')) and after the duty on the importation of Irish woollen and bay yarn into Great Britain was removed in 1739,[241](javascript:footNote('E900040/note241.html')) Ireland was able to obtain some profit from the lowest processes of the *manufacture*. There was doubtless, too, some clandestine exportation of yarn to France, for quantities were spun in the western ports of Ireland, and French ships were constantly cruising round this part of the coast ready to take a share in any smuggling trade.[242](javascript:footNote('E900040/note242.html')) But the permission to export yarn to Great Britain duty free probably saved the Irish woollen manufacture from further destruction by rendering it more profitable to keep up a large stock of wool in the country than it otherwise would have been.


All during the eighteenth century there was great anxiety on the part of patriotic Irishmen to increase the home consumption of Irish woollen stuffs. The Dublin Society did something to encourage the manufacture. Improved processes were introduced, and in the latter half of the century the industry revived to some extent. In a valuable pamphlet of 1759,[243](javascript:footNote('E900040/note243.html')) we are told that the woollen manufacture in Dublin included, ‘superfine, refine and middling cloths, serges, druggets, drabs, ratteens, narrow goods of all sorts, calimancoes, everlastings, German serges, stuffs and camblets, poplins   
[*...*]  
 all very well finished and some to the utmost nicety; as



---

p.107



are also velvets plain and flowered   
[*...*]  
 hair and worsted shags.’ The writer adds that ‘it is with real satisfaction that I have lately seen some pieces of superfine cloth of home manufacture equal to any imported.’ For some time after this there are few notices of the manufacture, but in 1775, if we are to judge from **Arthur Young**'s remarks in his Tour in Ireland, it was flourishing on a small scale in various parts of the country. In the county of Cork about three-quarters of the wool produced was exported as yarn, but the remaining quarter was worked up into stuffs for home use. Serges, camblets, ratteens, friezes, druggets, and narrow cloths were made. The manufacturers, interviewed by Young, were certain that if they were allowed to export their woollen goods, they would drive a thriving trade.[244](javascript:footNote('E900040/note244.html')) Most of the serges made in this county were sent to Dublin by land carriage, then to the north of Ireland, from whence they were smuggled into England by way of Scotland.[245](javascript:footNote('E900040/note245.html')) Carrick was a large manufacturing town for woollens. Formerly ratteens had chiefly been made, but in **Young**'s time broad cloth was the principal manufacture, altogether for home consumption. The manufacture was said to be progressing, and seemed to **Young** in a flourishing enough condition; it employed between three and four thousand persons in Carrick and its neighbourhood.[246](javascript:footNote('E900040/note246.html')) There was also a manufacture of worsted stockings extending some eight or ten miles round Cork, which supplied the needs of the district, and also sent large quantities of stockings to the northern counties.[247](javascript:footNote('E900040/note247.html')) In Cork itself, there was a manufacture for army clothing, for the Irish were now allowed to export clothing to their troops in America. For Ireland, this manufacture was fairly considerable; it paid 40 l. a week in wages. The manager told **Young** that many fabrics in which the French



---

p.108



were underselling the English could be worked up in Ireland far more cheaply than in France. He was quite sure he could make broad cloths one to one and a half yards wide at 3s. to 3s. 6d. per yard for the Levant trade; friezes, twenty-four to twenty-seven inches wide, at 10d. to 13d. per yard, now supplied by *Carcassonne*, in Languedoc; flannels, twenty-seven to thirty-six inches wide, at 7d. to 14d. per yard, and serges, twenty-seven to thirty-six inches wide, at 7d. to 12d. per yard.[248](javascript:footNote('E900040/note248.html')) All these stuffs, except broad cloths, could be made with coarse wool, of which there were quantities in the country, while labour was very cheap.


At this time very little wool was being smuggled from Ireland, as the price was high enough to sell it profitably at home. **Arthur Young** thought that for the last twenty years none at all had been smuggled, not even from Kerry.[249](javascript:footNote('E900040/note249.html')) This was, of course, owing to the thriving export trade in woollen and bay yarn to Great Britain. According to Young, there was little decrease in the quantity of wool grown in the country, and at Ballynasloe Fair, which took place every July, an average of £20,000 worth of wool was sold every year.[250](javascript:footNote('E900040/note250.html')) **Young** thought that the Irish sheep were on an average better than the English, and that the weight of the fleece was nearly equal.[251](javascript:footNote('E900040/note251.html'))


During the whole of this period Ireland managed to supply the greater part of her own needs in woollen goods. Except in the years of distress from 1776 to 1779, only very small quantities of both old and new drapery were imported into the country. The gentry probably used English cloths because of their superior quality, but the mass of the people clothed themselves in the coarser stuffs made at home. As their foreign trade was prohibited, there was little inducement for Irish manufacturers to



---

p.109



make the finer and better kinds of cloth. There was little demand for such stuffs in Ireland, because of the great poverty of the bulk of the people, and what demand there was could be met by English manufacturers, who had easy access to the Irish markets, and who could always rival the Irish manufacturers as far as the superior sorts of cloth were concerned. So the Irish manufacturers naturally devoted themselves to making coarse stuffs, such as were used by the majority of the people. Their skill inevitably declined, the profits of the manufacture were small, and so it increased little in extent; and as the greater part of the wool grown in the country was intended for combing purposes or for merely spinning into coarse yarn, its quality naturally deteriorated. At the end of 1779, when Ireland was once more allowed to export her woollen manufactures, she found herself in a far less advantageous position than she had been eighty years before. Large woollen manufactures had now been established in all the chief European countries; Great Britain had certain branches of the trade firmly in her hands; Irish wool was only capable of being made up into the coarsest stuffs; there was little skill and little capital in the country. It was because of all this that the Irish woollen manufacture, after the first burst forward due to the removal of the trade restrictions, progressed less steadily during the last twenty years of the eighteenth century than any other of the more important Irish industries.


When we consider that during this time English woollen goods of all kinds were allowed into Ireland on payment of duties of only 10 *per cent* ad valorem, and that the poverty of the country prevented the growth of a large home demand for any but the very coarsest stuffs; when we also consider that restrictions on the exportation of any article must discourage its manufacture for home purposes, we are able to realise the full extent of the injury inflicted on Ireland by English interference in her woollen trade. The history of the industry shows that



---

p.110



England was altogether successful in preventing Ireland from rivaling her manufactures in foreign markets, for the clandestine trade in woollen stuffs to Spain and Portugal was short lived. But it also shows us that England did not succeed in supplying the consumption of the Irish in woollen goods, for after the Woollen Acts, as before, Ireland continued to meet the greater part of her own wants. That this was the case, in spite of all the disadvantages under which Ireland laboured in her commercial relations with Great Britain, goes some way to prove how successfully the industry might have established itself had it been unhampered by restrictions. At the end of the seventeenth century Ireland had the same advantages as England as regards a good and plentiful supply of the raw material for the manufacture, while she had a real superiority in cheapness of living, and therefore of labour. The industry was making rapid strides; the necessary skill and capital would come in time; there was no reason why in the near future Ireland should not have competed successfully with England in certain branches of the manufacture. By the English Act of 1699 the material prosperity of Ireland received a great blow. The injury inflicted was not one of principle, of abstract injustice; it was a real and practical and immediate injury. A flourishing woollen manufacture might have changed the whole face of the country; it might have done much to make Ireland prosperous and contented, and it would have been of immense advantage to England. But the eighty years of restriction did their work well; they took away for ever Ireland's chance of becoming rich through a large woollen manufacture, as England had done; and this was all the more easily accomplished because of the peculiar circumstances and condition of Ireland, her poverty and dependence. We can see now how short sighted English policy was. Unfortunately, it is far easier to destroy manufactures than to establish them, and so Ireland still suffers from the commercial policy of the eighteenth century*.*


The Irish Linen Industry
------------------------


Early History of the Industry—Attempts of **Strafford** to Promote it — Efforts of the Duke of Ormonde and the Irish Parliament — Slow Progress of the Manufacture — The "Compact" of 1698 — **Crommelin** and the Industry — Settlement of Protestant Linen Weavers in the North and at Waterford — English Legislation in Favour of the Industry — Vigorous Action of the Irish Parliament — Establishment of the Linen Board — Extension of **Crommelin**'s Patent — General Progress of the Manufacture during the First Half of the Eighteenth Century — The Irish Sail Cloth Manufacture and Repressive British Legislation — British Bounties on British and Irish Linens — Further Bounties on British Linens only — General Progress of the Industry during the Latter Half of the Century — Progress of the English and Scotch Linen Manufactures — Hindrances to the Development of the Linen Manufacture in Ireland — Its Great Progress in spite of many Difficulties.
The history of the Irish linen industry is in many ways peculiarly interesting. It gives us the one solitary instance of an Irish manufacture meeting with a good deal of encouragement at the hands of English statesmen, and developing steadily and fairly continuously for nearly two centuries, until at the present day its products are known and used in every civilised country in Europe. The industry was by no means a spontaneous growth. Ever since the time of **Strafford** it had been thought good policy to promote the manufacture of linen in Ireland, and after the destruction of the Irish foreign trade in woollen goods this same policy seemed the only way by which the prosperity of the country could be furthered. Fortunately for Ireland, the encouragement of the industry up to a certain point was not contrary to British interests, and the Irish Parliament, by means of bounties and rewards of



---

p.112



every kind, managed to develop the manufacture in a remarkable way. It is true that this development was often checked and hampered through the jealous fears of English and Scotch manufacturers, especially when, in the latter half of the eighteenth century, the linen manufactures in both England and Scotland increased greatly; still there was enough encouragement to enable the Irish industry to develop satisfactorily on certain lines, and no district in Great Britain has ever been able to equal Ireland in the manufacture of the finest sorts of linen. It was only after the restrictions placed by England on the Irish woollen trade that the linen manufacture assumed any importance in Ireland. But linen-making was practised in the country from the very earliest times. It existed in the thirteenth century, and in the fifteenth we hear of linen cloth being exported to England.[252](javascript:footNote('E900040/note252.html')) In the sixteenth century we have various notices of the industry. **Edmund Spenser** mentions that in his time all Irishmen wore shirts made of linen, often consisting of thirty to forty ells in length, while the women wore turbans of the same material.[253](javascript:footNote('E900040/note253.html')) These must have been native manufactures, as no linen was then imported from England. Earlier, in an Act of Parliament passed in 1542,[254](javascript:footNote('E900040/note254.html')) linen yarn is mentioned with woollen as among the principal branches of trade in Ireland; while in a later Act of 1571[255](javascript:footNote('E900040/note255.html')) it is stated that Irish merchants had been exporters of this article for more than a century. The Irish must have exported their linen to foreign countries as well as to England, for **Guicciardini** enumerates coarse linens among the articles exported from Ireland to Antwerp.[256](javascript:footNote('E900040/note256.html')) There was certainly a great deal of flax grown in the country at this time, and in the reign of



---

p.113



James I. we are again told that the Irish worked this flax into yarn and exported it in ‘great quantity.’[257](javascript:footNote('E900040/note257.html')) It was **Strafford** who first saw the possibility of establishing in Ireland an important linen industry which might supplant the manufacture of woollens. In all matters relating to Irish industry he wished to enrich England as well as Ireland. ‘We must not only endeavour to enrich them’ (the Irish), he wrote to the King, ‘but make sure still to hold them dependent on the Crown, and not able to subsist without us.’ He therefore wished the Irish to import all their clothing, salt, and victuals from England, ‘in order to strengthen bonds with England and improve the King's revenue.’[258](javascript:footNote('E900040/note258.html')) But as any progress in Irish wealth would also of itself increase the King's revenue, **Strafford** set himself to promote an industry which might at one and the same time enrich Ireland and be useful to England. There was at this time no fear of injuring English interests by encouraging the Irish linen industry; on the contrary, it was believed that England would greatly gain, for she might import linen from Ireland instead of spending large sums in obtaining it from foreign countries. **Strafford** noticed that Irish women were all brought up to spin, and that the soil of the country was good for growing flax. In 1636 he writes to the King that he is setting up a manufacture of linen cloth in Ireland, and relates how he has sent for £100 worth of flax-seed from Holland, and for skilled workmen from the Low Countries; how he has already established six or seven looms; and how, in his opinion, the Irish can undersell France or Holland by as much as 20 *per cent*[259](javascript:footNote('E900040/note259.html')) **Strafford**'s efforts met at the time with some success. He introduced better methods of cultivating flax, and he proved the sincerity of his purpose by investing part of his private fortune in the new undertaking. But the



---

p.114



Civil Wars practically destroyed all that he had done, and prevented for the time being any new development.


After the Restoration, when the country began to settle down under the administration of the Duke of Ormonde, **Strafford**'s ideas were taken up, and a new attempt was made to establish the linen manufacture on a satisfactory basis. The Duke sent intelligent messengers to the Low Countries to see how the manufacture was carried on there, and to make contracts with Flemish workmen. He got **Sir William Temple**, then English ambassador at Brussels, to send over five hundred **Brabant** families skilled in the industry, while he imported other skilled workmen from **La Rochelle**, the **Island of Rho**, and from **Jersey**.[260](javascript:footNote('E900040/note260.html')) Ormonde was seconded in his efforts by the Irish Parliament, who appointed a Committee of Trade to take into consideration how the manufacture of linen cloth might be encouraged in the kingdom.[261](javascript:footNote('E900040/note261.html')) At this time Irish linen was not admitted into England, and the Irish Parliament in its turn now placed an excise and custom of twelve shillings for every hundred ells of English and foreign linens imported. During the next ten years some progress was made in the industry, and when Ormonde returned to England in 1669 he left behind him two flourishing linen manufactures—one at **Chappel Izod**, near Dublin, and another at **Carrick**. At **Chappel Izod** there were said to be three hundred hands working at the manufacture of sail cloth, cordage, linen cloth, and diaper of Irish yarn. At **Carrick** the industry was on a smaller scale, but the Duke had done his best to encourage it by giving one-half of the houses and five hundred acres of land to the workmen at two-thirds of the rent for the space of thirty-one years.[262](javascript:footNote('E900040/note262.html')) Contemporary writers, both English and Irish, insisted that all the industry required was encouragement, for it was peculiarly suited to the people and the climate of



---

p.115



Ireland. **Sir William Temple** was especially emphatic on this point. ‘No women,’ he said, ‘are apter to spin it well than the Irish, who, labouring little in any kind with their hands, have their fingers more supple and softer than other women of the poor condition among us.’ He was anxious to promote the linen manufacture in Ireland, ‘so as to beat down the trade both of France and Holland, and draw much of the money which goes from England to those parts upon this occasion into the hands of His Majesty's subjects of Ireland without crossing any interest of trade in England, ’[263](javascript:footNote('E900040/note263.html')) reasons characteristic of the age in which he lived. The Irish Parliament was also convinced of the wisdom of fostering the linen industry, and as early as 1672 voted a certain sum of money to be applied for the encouragement of the manufacture of fine linen.[264](javascript:footNote('E900040/note264.html')) But in spite of the combined efforts of Ormonde and the Irish Parliament, the linen manufacture continued to exist on a small scale. Yarn was not spun in any considerable quantity except in the north, and Irish yarn was rarely capable of being made into the better sorts of linen for exportation.[265](javascript:footNote('E900040/note265.html')) At any rate, whatever trade there was disappeared almost entirely during the Revolutionary War. Even in 1698, when the country had more or less recovered from the effects of the war, the linen trade could have been of little value as compared with the woollen, for two years later the whole export of linens only amounted in value to £14,112,[266](javascript:footNote('E900040/note266.html')) while the amount of linen cloth used in the country was very much less than the quantity of woollen stuffs consumed. In 1699 England, in fact, substituted a possible trade in the place of an established and flourishing one. But even if the linen trade had been as advanced as the woollen, its encouragement



---

p.116



could hardly be regarded as a compensation for the policy adopted towards the woollen industry, because, as we have seen, ever since the time of **Strafford**, England had steadily encouraged the manufacture of hemp and flax in Ireland. England therefore was merely continuing her old policy, and was giving nothing new in exchange for the Irish foreign trade in woollen goods. She secured herself for ever against all possible Irish competition in the woollen trade, and for the time being she promoted her own interests by encouraging the linen industry in Ireland. English manufacturers were now anxious to establish the Irish linen trade securely in order to decrease the number of people making worsted and woollen yarn which was sent to England and undersold the English makers, and to force Ireland to supply England with linen yarn for the making of fustians.[267](javascript:footNote('E900040/note267.html'))


In spite of all the promises of the Lords Justices to the Irish Parliament in 1698, no new encouragement was given to the Irish linen industry until after the lapse of seven years. We have seen that during these years the poverty of Ireland was extreme, but a few seeds of prosperity were being sown by the immigration of many Protestant traders and manufacturers. Already in 1697 William III. had invited **Louis Crommelin**, a Huguenot refugee, to come over to Ireland and superintend the linen manufacture. **Crommelin**'s family had carried on the industry in France for more than four hundred years, and he himself had been head of an extensive linen manufacture in Picardy. In 1698 he came over to Ireland and fixed on Lisburn, ten miles south-west of Belfast, as the best place for establishing his new manufacture. The King appointed him ‘Overseer of the Royal Linen Manufactory of Ireland,’ and in 1699 granted him a patent. **Crommelin** was also given £800 a year for ten years as interest on £10,000 advanced by him for starting the



---

p.117



business, an annuity of £200 for life, and £120 a year for his assistants.[268](javascript:footNote('E900040/note268.html')) These assistants had to watch over the cultivation of the flax and visit the bleaching yards to see if the linen was properly finished off. In his turn **Crommelin** agreed to advance sums of money without interest to workmen and their families coming from abroad to enable them to embark on the industry, and also to English and Irish workmen destitute of means and anxious to work at the trade. Once **Crommelin** had started his linen industry at Lisburn, he invited over Protestant artisans from France and the Low Countries. As a result, a great settlement of artisans was made at Lisburn. The town had been burnt in the Civil Wars, but the establishment of a linen manufacture by **Crommelin** and his Protestants soon made it one of the most prosperous towns in Ireland. **Crommelin** did much to improve the industry. He imported a thousand looms and spinning wheels from Holland, and gave a premium of £5 for every loom at work. He also introduced improvements of his own, and before long finer linen was produced in the north of Ireland than had ever before been made in the King's dominions.


The linen industry was not absolutely confined to the north. Many Protestant refugees settled at Waterford, where they were warmly welcomed by the Mayor and Corporation. The local authorities were extremely anxious to encourage Huguenot refugees skilled in the arts to settle in their town, and ordered in 1693 that ‘the city and liberties do provide habitations for fifty families of the French Protestants to drive a trade of linen manufacture, they bringing with them a stock of money and materials for their subsistence until flax can be sown and produced on the lands adjacent; and that the freedom of the city be given to them gratis.’[269](javascript:footNote('E900040/note269.html')) But with the exception



---

p.118



of Waterford most of the Huguenot refugees naturally settled in the north, where they found religious sympathisers among the Scotch Presbyterians, and the linen manufacture in its new form was for some time little known outside Ulster. In spite of all that foreign immigration was doing to foster the industry, it was soon found that it was impossible for the Irish to acquire dexterity in the trade in a few years, and the Irish Parliament petitioned again and again for some substantial encouragement on the part of England. But England for the time did nothing, and many men in Ireland began to be anxious lest the linen manufacture should share the fate of the woollen. Three-quarters of all the linen yarn spun in the country was sent to England to be worked up there because a greater profit could be obtained in this way than if the yarn were made into cloth and then sold. ‘This transportation of yarn,’ wrote **Archbishop King**, ‘must therefore be stopped before we can expect any improvement of that manufacture, and quaere, will England permit it? Shall we not have as many petitions on that account from the linen weavers as now from the clothiers or herring fisheries; there is a Lancaster in England as well as a Yarmouth or Worcester.’[270](javascript:footNote('E900040/note270.html')) The English demand for linen yarn was a hindrance to the development of the industry, and many other difficulties had to be encountered. The importation of flax seed had proved to be very expensive, and the crops were always liable to failure through unsound seed. The culture of flax, too, was unprofitable, and no farmer would undertake the work solely on his own initiative. The moist air of Ireland was no doubt suitable for the growth of flax, but the country as a whole was not so peculiarly suited for the industry as was thought. In the woollen trade Ireland worked up the raw material she possessed; in the linen she had to depend for her material on foreign countries.




---

p.119


Just before the passing of the Woollen Acts an English Act of Parliament[271](javascript:footNote('E900040/note271.html')) had allowed Ireland to export direct to England any sorts of hemp and flax and thread yarn, and all kinds of linens duty free, but the English ports in Asia, Africa and America were still shut against all Irish linens. At last, in 1705, the English legislature gave its first new encouragement to the Irish linen trade by permitting Ireland to export coarse white and brown linens to the colonies.[272](javascript:footNote('E900040/note272.html')) But shortly after this the Irish found that their linen manufacture was by no means to be encouraged in the same degree as the manufactures in England and Scotland. Since the Union with Scotland there had been suspicions in Ireland that this would be the case, for the Scotch were very anxious to foster their linen industry. King in 1706 expressed the prevailing fears on the subject. ‘The woollen manufacture,’ he wrote, ‘was taken from us because England resolved to have it to themselves, and sure Scotland rivals us much more in our linen, and quaere whether they may not expect to be gratified in it; how can they fail to obtain their desires where they have a vote and we none to oppose them!’[273](javascript:footNote('E900040/note273.html')) Ten years later these suspicions were verified, for in the third year of George I. the permission which had been given to Ireland to export certain of her cheap linens to the plantations was renewed under the condition that British linens should be allowed into Ireland free of duty. At the same time Irish coloured linens when imported into Great Britain were subject to a duty equal to a prohibition.[274](javascript:footNote('E900040/note274.html')) So now the small duty which the Irish Parliament had hitherto exacted upon British as well as foreign linens imported had to be given up, while Irish merchants had to submit to the total exclusion of a large and important class of their linens from the British



---

p.120



markets. Ireland was not in a position to retaliate upon Great Britain by imposing prohibitive duties on British manufactures.


The permission to export white and brown linens to the plantations did not benefit Ireland much, for the Navigation Acts prevented her bringing anything directly in return. But something further was done for the Irish industry two years later when a British Act of Parliament[275](javascript:footNote('E900040/note275.html')) gave a bounty of 1d. per yard on the exportation of sail cloth from Ireland of the value of 10d. and under 1s. 2d. per yard. This bounty, however, was of short duration, as the British soon developed a sail cloth manufacture of their own, and no further bounty was granted to the Irish hempen or linen manufactures until 1743, when the regular system of bounties on the exportation from Great Britain of both British and Irish linens of a certain quality was begun.


During this first half of the eighteenth century the linen industry was encouraged by the Irish rather than by the British Parliament. From the fourth year of Anne to the nineteenth of George II. the Irish Parliament passed no less than fourteen Acts[276](javascript:footNote('E900040/note276.html')) for the advancement of the manufacture, and chiefly through these efforts the industry began to flourish. During Anne's reign an additional duty of 6d. per yard was placed on all linens imported,[277](javascript:footNote('E900040/note277.html')) and the proceeds went to form a fund for the granting of premiums to farmers for the cultivation of flax. But in 1717, as we have seen, all duties on the importation of British linens had to cease[278](javascript:footNote('E900040/note278.html')) and the additional duty was from this time only levied on foreign linens imported, and in consequence yielded very little. Subsequent statutes expressly exempted British cambrics and lawns, linens painted or stained in Britain, and British towelling from



---

p.121



all duties imposed on similar articles imported from foreign countries.[279](javascript:footNote('E900040/note279.html')) It was not in the power of the Irish Parliament to exclude British competition, but in every other way it did its best to promote the growing industry. In 1711 the Linen Board was set up to encourage and supervise the manufacture. The Board met every year, in the White Linen Hall in Dublin, and until its dissolution in 1728, was entrusted with the disposal of the Parliamentary grants, which varied from £10,000 to £33,000 a year. It was to this Board that **Crommelin** applied for a renewal of his patent and a substantial provision of £500 a year for life.[280](javascript:footNote('E900040/note280.html')) Some difficulty seems to have been felt as to the possibility of raising even this comparatively small sum, and a letter from one of the Lords Justices complains that Ireland was too poor to raise the money, and suggests that instead the patent should be extended for a still longer period.[281](javascript:footNote('E900040/note281.html')) But there was much difference of opinion about this proposed extension of the patent. In return for the extension **Crommelin** had promised to establish a new linen manufacture at Kilkenny, but no sooner was this plan known of extending the industry to Leinster than a fierce opposition arose. It was feared that if the linen industry was established on too large a scale in Ireland, Irish linens would altogether replace Dutch in England, and Holland would in consequence no longer purchase English woollen manufactures. **Davenant** was of this opinion,[282](javascript:footNote('E900040/note282.html')) and the English Commissioners of Customs opposed the scheme of the Linen Board on the same grounds. We get a characteristic statement of these objections from a letter in the Departmental Correspondence in the Irish Record Office from G. Doddington to J. Dawson. It is said that ‘by encouraging and paying rewards to such persons as make fine linen in Ireland the 



---

p.122



Flemings and Hollanders are provoked to discourage the woollen manufacture of Britain.’ The Lord High Treasurer advised that if the patent to **Crommelin** was extended it should at least be under the restriction that no linen except of the coarsest kind should be made. Only after a very long struggle was this suggestion successfully opposed by the Linen Board, and at last **Crommelin** managed to secure the extension of his patent and a grant of £500 a year for life.


But although much was now being done by the Irish Parliament and the Linen Board to develop the industry, the progress of the manufacture was comparatively slow during the first half of the eighteenth century. This was owing to the general want of capital, the ignorance and poverty of the people, and the neglect of Grand Juries.[283](javascript:footNote('E900040/note283.html')) Complaints were made that the law which required the Grand Juries in every county to give premiums to the women who had made the three best pieces of cloth was of no avail, because the young jurymen always insisted on giving the premiums to the three prettiest girls.[284](javascript:footNote('E900040/note284.html')) At Waterford the manufacture established by the Protestant refugees made little progress, and an attempt which was made in 1736 to set up a linen manufacture in Tipperary proved unsuccessful.[285](javascript:footNote('E900040/note285.html')) Altogether many difficulties and checks had to be met and overcome.


Still, the linen manufacture had now become the staple manufacturing industry of Ireland. It has been seen that in 1700 the manufacture was very inconsiderable; but as soon after as 1727 it was calculated that linen actually amounted to one-third of the total Irish exports. For the year ending Lady Day, 1727, the value of linen cloth exported from Ireland amounted to £238,444, having



---

p.123



increased by £234,332 since 1701, while for the same year the value of linen yarn exported came to £103,726.[286](javascript:footNote('E900040/note286.html')) The linen manufacture at Belfast was increasing by leaps and bounds, and in 1757 the town possessed no less than three hundred and thirty-nine linen looms.[287](javascript:footNote('E900040/note287.html')) By 1732 the industry had made some progress in Leinster and Connaught.[288](javascript:footNote('E900040/note288.html')) In the County of Cork there was a spinning school at Killeigh for the encouragement of the manufacture,[289](javascript:footNote('E900040/note289.html')) and at Innishannon there was a flourishing linen industry possessed of sixty-six looms. All the cloth made at this factory was carefully viewed, and it was certified that for ‘goodness, breadth, strength, and colour, the linen made here equals any other manufactured in Ireland.’[290](javascript:footNote('E900040/note290.html')) At Douglas, in the same county, there was a manufacture of sail cloth, said to be the largest in the kingdom.[291](javascript:footNote('E900040/note291.html')) It had been started in 1726, when forty looms had been erected. Since then many additions had been made, until in 1750 one hundred looms were at work. Two hundred and fifty persons were employed in hackling, warping, and weaving, and five hundred as spinners. This meant a weekly expenditure of £60 for labour only, a fairly considerable amount when one thinks of the industrial condition of the country at that time. During the two years ending Christmas, 1747, this factory at Douglas manufactured 172,116 yards of sail cloth, worth from 14d. to 20d. per yard. In the year 1746, as much as 9,348 yards of sail cloth and canvas were exported to Great Britain, where it was in great demand,[292](javascript:footNote('E900040/note292.html')) and in the same year the Irish Parliament tried to develop the



---

p.124



manufacture still further by granting bounties on the exportation of all sail cloth from Ireland—2d. per yard on cloth of the value of 10d. and under 14d. per yard, and 4d. per yard on cloth above 14d. per yard in value.[293](javascript:footNote('E900040/note293.html')) From 1747 to 1750 inclusive, while this bounty remained uncounteracted, there was exported from Ireland to Great Britain 96,241 yards of sail cloth on an average each year.[294](javascript:footNote('E900040/note294.html')) It was stated that ‘by this the British manufacture of sail cloth was greatly injured and depressed,’ and in consequence in 1750 the British Parliament retaliated by imposing duties equivalent to the Irish bounties on all Irish sail cloth and canvas imported into Great Britain.[295](javascript:footNote('E900040/note295.html')) Nothing remained for the Irish Parliament but to take off its bounties, and as soon as this was done the British duties ceased also. It was now seen that Great Britain was not prepared to give Ireland equal advantages with herself in the manufacture of hemp, although it had always been understood by the Irish Parliament that the linen and hempen manufactures should be coupled together. Indeed the two had been mentioned as one in the speech of the Lords justices in 1697, but since then Great Britain had developed a sail cloth manufacture of her own,[296](javascript:footNote('E900040/note296.html')) and was not prepared to allow Irish competition. But this Act of 1751 did something worse than refuse to allow Ireland to develop her sail cloth industry in her own way: it also began the destruction of the flourishing hempen manufacture of Ireland by granting bounties on all kinds of British hempen manufactures exported to the plantations, to Ireland, or to foreign countries. It was also laid down by another clause in the Act that there should be added to the bounty on the sail cloth and canvas exported to Ireland as much more as at any time Ireland might



---

p.125



impose as a duty on the importation of these articles. Ireland was thus not only prohibited from granting bounties on her own hempen manufactures: she was also forced to admit British bounty-fed sail cloth and canvas duty free. The consequences soon showed themselves, although the Irish industry made a good struggle. From 1751 to 1754 the average yearly export of Irish sail cloth and canvas to Great Britain decreased to 25,895.5 yards, while Great Britain exported to Ireland 7,561.75 yards on an average each year. From 1754 to 1760, the Irish exportation to Great Britain increased to 48,358 yards on an average each year, but the British exportation to Ireland increased at a far greater rate, the yearly average being 24,514.75 yards.[297](javascript:footNote('E900040/note297.html')) From this time British manufacturers were able to flood the Irish market with their goods, and the Irish hempen manufacture rapidly decayed, until in 1779 Ireland could not even supply her own needs. It was stated in a report sent up to the Lord Lieutenant in this year that the policy of England had ‘nearly annihilated the hempen manufacture of Ireland, greatly to the prejudice of England and to the advantage of the Russians, Dutch, and Germans, who have imported greater quantities into England.’[298](javascript:footNote('E900040/note298.html')) Even Ireland's trade in the raw material received a blow by a British Act granting bounties on the importation of American hemp. This Act naturally had the effect of prohibiting the importation of Irish hemp into Great Britain, and checking its growth in a country well fitted for it.[299](javascript:footNote('E900040/note299.html'))


It was only certain kinds of Irish linens which received encouragement from the British legislature. The system of bounties on the exportation of both British and Irish linens from Great Britain only applied, with a trifling exception under George III., to certain sorts of cheap



---

p.126



plain linens under 1s 6d. per yard in value. All other kinds of linens were only entitled to a bounty if of British manufacture. The first of these Bounty Acts was passed in 1743,[300](javascript:footNote('E900040/note300.html')) when an additional duty was laid on foreign cambrics imported of 1s. 5d. for every half piece, and 2s. 10d. for every whole piece. Out of this additional duty there was allowed a bounty of 1d. for every yard of British or Irish linen exported, worth from 6d. to 12d. per yard. Three years later another Act[301](javascript:footNote('E900040/note301.html')) granted a further bounty of 0.5d. per yard on linen exported of the value of 5d. and not exceeding 12d. per yard, and of 1.5d. a yard on linen of the value of 12d. to 1s. 6d. per yard, as this previous Act had given no bounty to linen of this price. None of these bounties extended to linens striped, chequered, painted, or printed, or made into buckrams or filletings. Under George III., the bounties were continued, but another bounty of 1.5d. per yard was given on the exportation of British and Irish diapers, huckabacks, and sheetings, when over 1s. 6d. a yard in value, and therefore not entitled to the old bounty.[302](javascript:footNote('E900040/note302.html'))


So far British and Irish linens were on the same footing as regards bounties on their exportation from Great Britain, but in the tenth year of George III. a bounty was given on British linens which did not extend to Irish. An Act[303](javascript:footNote('E900040/note303.html')) of this year granted a bounty on British linens checked and striped exported out of Great Britain to Africa, America, Spain, Portugal,*Gibraltar*, Minorca, or the East Indies, and this at a time when Ireland was forbidden to give bounties on the exportation of her sail cloth. This new bounty enabled Great Britain to monopolise the trade in checked and striped linens, as she had before done in that of sail cloth.


But even in the article of coarse linens Ireland was at



---

p.127



a disadvantage, for the bounties, although nominally the same for both countries, operated strongly in favour of Great Britain. The Irish manufacturers, who exported their linens to British ports with the idea of re-exporting them and obtaining the bounty, had to undergo an expense of 7 *per cent* for freight, insurance, factorage, and loss of time incurred, so that barely 0.75d. per yard remained to them of the premium.[304](javascript:footNote('E900040/note304.html')) The English and Scotch, on the other hand, lost either nothing or comparatively little of the whole bounty of 1.5d. granted on the exportation of the linens. Still, even with these disadvantages, the Irish linen manufacture increased enormously during the second half of the eighteenth century. Between 1745 and 1771 the exportation from Great Britain of Irish linens entitled to bounty increased from 101,928 yards to 3,450,224 yards, this increase being powerfully aided by the duties levied on the importation of foreign linens.[305](javascript:footNote('E900040/note305.html')) During the same years the general exportation of Irish linen cloth to all parts trebled, while a steady decrease took place in the amount of foreign linens imported into Great Britain.[306](javascript:footNote('E900040/note306.html')) It is interesting to notice in this connection that four-fifths of the whole quantity of Irish linens imported into Great Britain were consumed there, only one-fifth being reexported, and therefore entitled to bounty.[307](javascript:footNote('E900040/note307.html')) But the existence of the bounties certainly stimulated the Irish trade, and very little linen was sent by Ireland to foreign countries. In 1773 the total quantity of Irish linens imported into Great Britain amounted in value to £17,876,617.[308](javascript:footNote('E900040/note308.html'))




---

p.128


Total Quantities of British and Irish Linens entitled to Bounty exported from Great Britain from the commencement of the Bounties in 1743 until January, 1771.


(Compiled from figures given in the Irish Commons Journals.)




| Year ended | British Linens: Yards | Irish Linens: Yards |
| --- | --- | --- |
| Lady Day to Christmas 1743 | 52,779 | 40,907 |
| Christmas 1744 | 49,521 | 28,255 |
| Christmas 1745 | 56,240 | 101,928 |
| Christmas 1746 | 175,928 | 695,002 |
| Christmas 1747 | 238,014 | 595,277 |
| Christmas 1748 | 330,747 | 723,663 |
| Christmas 1749 | 414,834 | 965,897 |
| Christmas 1750 | 588,874 | 742,032 |
| Christmas 1751 | 527,976 | 854,490 |
| Christmas 1752 | 437,277 | 968,319 |
| Christmas 1753 | 641,510 | 1,039,967 |
| Christmas 1754 | 1,382,796 | 843,973 |
| Christmas 1755 | 41,367 | 51,040 |
| Christmas 1756 | 394,746 | 719,135 |
| Christmas 1757 | 1,016,754 | 2,005,575 |
| Christmas 1758 | 1,942,667 | 2,171,109 |
| Christmas 1759 | 1,693,087 | 1,956,572 |
| Christmas 1760 | 1,413,602 | 2,352,538 |
| Christmas 1761 | 1,272,985 | 1,819,329 |
| Christmas 1762 | 1,762,643 | 2,930,476 |
| Christmas 1763 | 2,308,310 | 2,588,564 |
| Christmas 1764 | 2,134,733 | 1,858,780 |
| Christmas 1765 | 2,995,933 | 1,633,670 |
| Christmas 1766 | 2,236,086 | 1,770,634 |
| Christmas 1767 | 2,444,181 | 2,227,124 |
| Christmas 1768 | 2,687,457 | 2,270,160 |
| Christmas 1769 | 3,056,950 | 1,855,159 |
| Christmas 1770 | 3,210,506 | 2,797,482 |
| January 1771 | 4,411,040 | 3,450,224 |








---

p.129





| Year ended 25th March | Linen Cloth: Yards | Linen Cloth: Value £ | Linen Yarn: Cwts | Linen Yarn: Value £ |
| --- | --- | --- | --- | --- |
| 1710 | 1,688,574 | 105,537 | 7,975 | 47,852 |
| 1711 | 1,254,815 | 78,425 | 7,321 | 43,928 |
| 1712 | 1,376,122 | 86,007 | 11,802 | 47,496 |
| 1713 | 1,819,816 | 113,738 | 11,802 | 70,815 |
| 1714 | 2,188,272 | 155,002 | 15,078 | 158,326 |
| 1715 | 2,153,120 | 107,656 | 13,931 | 146,283 |
| 1716 | 2,188,105 | 109,405 | 10,747 | 112,847 |
| 1717 | 2,437,265 | 132,018 | 18,052 | 189,555 |
| 1718 | 2,247,375 | 121,732 | 14,050 | 147,527 |
| 1719 | 2,359,352 | 127,798 | 15,070 | 158,239 |
| 1720 | 2,437,984 | 121,899 | 89,722 | 94,334 |
| 1721 | 2,520,701 | 126,035 | 14,696 | 88,178 |
| 1722 | 3,419,994 | 170,995 | 14,754 | 88,524 |
| 1723 | 4,378,545 | 218,927 | 15,672 | 94,637 |
| 1724 | 3,879,170 | 193,958 | 14,594 | 87,564 |
| 1725 | 3,864,987 | 193,249 | 13,701 | 82,207 |
| 1726 | 4,368,395 | 218,419 | 17,507 | 105,042 |
| 1727 | 4,768,889 | 238,444 | 17,287 | 103,726 |
| 1728 | 4,692,764 | 234,638 | 11,450 | 62,975 |
| 1729 | 3,927,918 | 196,395 | 11,855 | 65,206 |
| 1730 | 4,136,203 | 206,810 | 10,088 | 55,485 |
| 1731 | 3,775,830 | 220,256 | 13,746 | 84,194 |
| 1732 | 3,792,551 | 237,034 | 15,343 | 92,061 |
| 1733 | 4,777,076 | 298,567 | 13,357 | 82,372 |
| 1734 | 5,451,758 | 340,734 | 18,122 | 108,733 |
| 1735 | 6,821,439 | 426,339 | 15,900 | 95,405 |
| 1736 | 6,508,151 | 406,759 | 14,743 | 88,463 |
| 1737 | 6,138,785 | 409,252 | 14,695 | 88,173 |
| 1738 | 5,175,744 | 345,049 | 15,045 | 95,674 |
| 1739 | 5,962,316 | 397,487 | 18,200 | 109,202 |
| 1740 | 6,627,771 | 441,851 | 18,542 | 111,256 |
| 1741 | 7,207,741 | 480,516 | 21,656 | 129,941 |
| 1742 | 7,074,168 | 471,611 | 16,330 | 97,984 |
| 1743 | 6,058,041 | 403,869 | 14,169 | 85,016 |
| p.130 |
| 1744 | 6,124,892 | 459,366 | 18,011 | 108,066 |
| 1745 | 7,171,963 | 537,807 | 22,036 | 132,398 |
| 1746 | 6,836,667 | 512,750 | 27,741 | 166,451 |
| 1747 | 9,633,884 | 722,541 | 28,910 | 173,464 |
| 1748 | 8,692,671 | 543,291 | 19,418 | 116,508 |
| 1749 | 9,504,339 | 594,021 | 21,694 | 130,165 |
| 1750 | 11,200,460 | 653,360 | 22,373 | 134,238 |
| 1751 | 12,891,318 | 751,993 | 23,748 | 142,459 |
| 1752 | 10,656,003 | 621,600 | 23,407 | 140,442 |
| 1753 | 10,411,787 | 694,119 | 23,238 | 139,428 |
| 1754 | 12,090,903 | 806,060 | 22,594 | 135,567 |
| 1755 | 13,379,733 | 891,982 | 27,948 | 167,692 |
| 1756 | 11,944,328 | 796,288 | 26,997 | 161,982 |
| 1757 | 15,508,709 | 1,033,913 | 31,078 | 186,473 |
| 1758 | 14,982,557 | 998,837 | 31,995 | 191,970 |
| 1759 | 14,093,431 | 939,562 | 27,571 | 165,426 |
| 1760 | 13,375,456 | 891,697 | 31,042 | 186,254 |
| 1761 | 12,048,881 | 803,258 | 39,699 | 238,198 |
| 1762 | 15,559,676 | 1,037,311 | 35,950 | 215,702 |
| 1763 | 16,013,105 | 1,067,540 | — | — |
| 1764 | 15,101,081 | 1,006,738 | 31,715 | 192,292 |
| 1765 | 14,355,205 | 957,013 | 26,127 | 156,762 |
| 1766 | 17,892,102 | 1,192,806 | 35,018 | 210,109 |
| 1767 | 20,148,170 | 1,344,211 | 30,274 | 181,648 |
| 1768 | 18,490,019 | 1,232,667 | 32,590 | 195,542 |
| 1769 | 17,790,705 | 1,186,047 | 37,037 | 222,223 |
| 1770 | 20,560,754 | 1,370,716 | 33,417 | 200,502 |
| 1771 | 25,376,808 | 1,691,787 | 34,166 | 204,996 |
| 1772 | 20,599,178 | — | 32,441 | — |
| 1773 | 18,450,700 | — | 28,078 | — |
| 1774 | 16,916,674 | — | 29,174 | — |
| 1775 | 20,205,087 | — | 30,598 | — |
| 1776 | 20,502,587 | — | 36,152 | — |
| 1777 | 19,714,638 | — | 29,698 | — |
| 1778 | 21,945,729 | — | 28,108 | — |
| 1779 | 18,836,042 | — | 35,673 | — |








---

p.131


But although the Irish linen manufacture made immense progress during this period, it did not increase so rapidly as the manufacture in England and Scotland. The system of bounties forced forward an extensive manufacture in Great Britain, and even in the case of those coarse linens which received the same bounty as the Irish, the British exportation from 1761 to 1771 increased at a steadier and more rapid rate than the Irish exportation. In Scotland alone the output of linens rose during this period more rapidly than in Ireland, for between 1727 and 1783 the amount of linen manufactured in Scotland increased from two to nineteen million yards.[309](javascript:footNote('E900040/note309.html')) This was natural enough, as Scotch linens were, of course, entitled to the same privileges as English, while Irish linens, as we have seen, only came in for a small share of encouragement.


It must be acknowledged that the virtual agreement made by the English Government in 1698 to encourage in every way the Irish linen and hempen manufactures, or at least to refrain from hindering their development, was not fulfilled. Ireland had been given a discretionary power to protect and promote her linen industry in whatever way seemed best to her, but she was not allowed to use this power in certain directions for fear of hindering British interests. In the case of bounties given on the exportation of linens from Great Britain, Ireland came comparatively badly off, partly because of the expenses of transportation, which were necessarily entailed, partly because the bounties only applied to a small class of Irish linens as against a far larger class of British. As regards the linen trade to the plantations, Ireland had no advantage over foreign countries, for a drawback amounting to nearly the whole of the duty laid on foreign linens imported into Great Britain was given on their re-exportation to the plantations.[310](javascript:footNote('E900040/note310.html')) In consequence the British



---

p.132



manufacturers imported plain cheap linens from foreign countries, painted or printed them, and exported them in their new condition to the plantations.[311](javascript:footNote('E900040/note311.html')) The prohibitive duties laid on Irish linens, checked, striped, painted, or dyed, when imported into Great Britain,[312](javascript:footNote('E900040/note312.html')) and the bounties given in the tenth year of George III. on the exportation of British linens of the same kind, certainly hindered the development of the Irish linen manufacture. Printed linens were in great demand among the lower classes in Great Britain, and we are told in 1779 that ‘they have been gaining ground for many years on the plain linen manufacture both in the home and foreign consumption, which appears by the exports from England and Scotland, and, therefore, the discouragement of the articles in Ireland has given a severe check to our linen manufacture.’[313](javascript:footNote('E900040/note313.html')) It must be remembered that until 1778 all printed and fancy linens were excluded from the plantations markets; but, of course, the bounties given on the exportation of the same class of linens of British manufacture to the colonies would in any case have prevented the Irish from reaping advantages from any such export trade.


When the first bounties on the exportation of Irish linens from Great Britain were granted, Parliament had imposed an import duty of nearly 30 *per cent* on foreign linens, and it was this duty which had done so much to encourage the Irish manufacture. Unfortunately it had only been imposed on Dutch linens, as the importation of Russian and German linens was thought to be too small to be taken into account. The heavy duty on Dutch linens caused a decay in the Dutch trade, but the Germans and Russians, who were crippled by no such duty, began,



---

p.133



as time went on, to import large quantities of their linens into Great Britain. Parliament, instead of increasing the duties on German and Russian linens to the amount paid by the Dutch, left them at the old rate.[314](javascript:footNote('E900040/note314.html')) Instead of 30 *per cent* the duty only amounted to 8 *per cent* or 10 *per cent*, and a drawback of the whole amount was given on re-exportation. German and Russian linens, if stamped, did not forfeit this drawback, while Irish linens, if stamped, received no drawback. The result was that towards the last quarter of the eighteenth century an increasing quantity of plain foreign linens were imported by British manufacturers for the purposes of printing and staining, and, finally, for re-exportation. In the years immediately before the repeal of the commercial restrictions there were signs of distress in the Irish linen industry. The Irish Parliament had been giving large premiums in support of the manufacture[315](javascript:footNote('E900040/note315.html')) but in spite of all the encouragement given to the growth of flax and the raising of flax seed a large sum had annually to be paid for imported seed. In 1779 it was calculated that nearly all the seed sown was imported, and that it cost the country between £70,000 and £80,000 yearly.[316](javascript:footNote('E900040/note316.html')) Flax-farming had become a losing trade, and farmers found they could not make a profit even when given premiums. The linen manufacture could never be as profitable to the Irish as their woollen manufacture might well have become. In the linen industry Ireland was subject to much foreign competition, from which she would have been comparatively secure in the woollen. **Arthur Young** compared the profits arising from both these industries, and came to the interesting conclusion that if the whole



---

p.134



province of Ulster were under sheep the amount that could be obtained from bay yarn spun from their fleeces would be more than the whole value of the linen manufactures exported and consumed at home.[317](javascript:footNote('E900040/note317.html'))


But the linen industry has certainly been of lasting benefit to Ireland. In spite of temporary distresses and British and foreign competition it continued to develop steadily all through the eighteenth century. The distress in the trade in 1778 and 1779 was, as we shall see later, due to peculiar causes, and with the removal of the trade restrictions all branches of the manufacture made enormous progress. The proud position which the Irish linen industry holds at the present day is a witness to the industrial capacities of the Irish people, and goes some way to show how other industries might have flourished in Ireland had they only met with a little encouragement. Although the Irish linen manufacture did meet with encouragement, it was fostered far less than the linen manufactures in England and Scotland, and that it should have held its own in the face of many difficulties and hindrances was something of an achievement. The only drawback was that it gradually came to be more and more confined to Ulster, and it is probable that the immunities conferred on Protestant weavers by the Irish Parliament had something to say to this. The poverty of Ireland also made it difficult to extend the industry all over the country. Wool was always there, but flax seed had to be imported at great expense. When we take into account all the conditions of the Ireland of the eighteenth century, conditions economic, religious, and political, it is more a matter of surprise that the manufacture should have succeeded so well than that it should have been confined to a comparatively small portion of the country.


Irish Agriculture
-----------------


Increase of Pasture Lands at the Expense of Tillage — Reasons for this — The Irish Provision Trade during the Eighteenth Century — Condition of the Peasantry — Early Efforts of the Irish Parliament to Promote Tillage — Decline of the English Corn Trade and Rise of the Irish — Foster's Corn Laws of 1784 and their Effects — Further Decline of the English Corn Trade and the Rapid Growth of a Great Export Trade in Corn from Ireland — Evils Resulting from the too great Encouragement given to Tillage in Ireland due to the Peculiar Conditions of the Country.
During the greater part of the eighteenth century there was a tendency in Ireland to turn large tracts of land into pasture. Side by side with the increase of pasture there took place a decrease in the amount of land under tillage. There were many reasons why grazing and dairy farms should have increased during this period at the expense of arable farms. Pasture farming required little skill, and so was particularly suited to a country like Ireland of small economic development; it required little capital, and so was suitable to a poor country, while the action of the penal laws, by prohibiting the majority of the Irish people from investing their money in land and from taking up profitable tenures, was bound to result in an increase of pasture at the expense of tillage. It was profitable enough for Catholic farmers to lease large tracts of land on short terms, but it would not have been worth their while to make the necessary improvements in the land incident to the cultivation of corn. The whole feeling of insecurity which prevailed in Ireland during a large part of the eighteenth century was also bound to result in a preponderance of grazing lands over arable. The resolution of



---

p.136



 

the Irish House of Commons in 1735, excepting pasture lands from tithes, worked in the same direction. This exception was resolved upon at the instigation of England in the interests of the English woollen manufacture, and as a result the great graziers, whether Catholic or Protestant, became nearly free of tithes, while practically the whole burden was thrown upon the poorer tillers of the soil.


The Irish provision trade of the eighteenth century was certainly a source of wealth to the country, or rather to certain sections and classes in the country. The greater part of the total exports of Ireland consisted of live stock, meat, skins, and dairy produce. Irish beef was admitted freely everywhere but to England, and there was an enormous exportation of Irish butter, hides, tallow, pork, and bacon to foreign parts and the plantations. In 1759 Irish live stock were once more allowed to be imported into England,[318](javascript:footNote('E900040/note318.html')) while in the early part of the reign of George III. three British Acts allowed the importation from Ireland of salted beef, bacon, and butter.[319](javascript:footNote('E900040/note319.html')) All this made the Irish provision trade increasingly profitable. At the same time the English Corn Laws acted as a direct discouragement to the cultivation of corn in Ireland. At this time a bounty was given in England on the exportation of corn when the price ranged below 48s. the quarter,[320](javascript:footNote('E900040/note320.html')) and during a great part of the eighteenth century English corn was treated as a commodity to be grown for export. This policy gave a great encouragement to English landowners to invest money in the land, and for some time an enormous quantity of all kinds of corn was exported. England exported her bounty-fed corn to Ireland as well as elsewhere; indeed, from 1742 to 1764 eight-ninths of the corn imported into Ireland came from Great Britain.[321](javascript:footNote('E900040/note321.html')) This continuous importation of comparatively cheap corn



---

p.137



took away any inducement that the Irish farmer may still have felt to grow corn in any large quantity to meet the home demand. At the same time the English corn laws prohibited the importation of any corn into England unless the price was at or over 48s. the quarter. As English prices scarcely ever ranged anything like as high between the years 1715 and 1765, the English markets were closed to Irish corn, so that the Irish farmer had also no inducement to grow corn for exportation to Great Britain. The profitable nature of the provision trade, combined with the little profit to be obtained from growing corn, is sufficient to account for the decay of tillage during the eighteenth century. But when we look at the peculiar conditions prevailing in Ireland, conditions which must infallibly have led to an increase of pasture lands, we can easily see how absolutely inevitable was this decay of tillage.


In the reign of James I. we know that the Irish exported a good quantity of corn, although a licence was necessary for its exportation at all times.[322](javascript:footNote('E900040/note322.html')) The amount of corn grown in the country seems, however, to have greatly decreased all during the seventeenth century, no doubt owing to the great insecurity which prevailed. At the same time the quality of the corn grown deteriorated considerably, for it was soon found that it was not large, firm, or dry enough a grain to be suitable for exportation. After the Cromwellian Wars, the soldiers and adventurers who were given lands in Ireland took to cattle raising rather than corn growing, while the result of the English Cattle Acts in forcing the Irish to fatten their own cattle led to a flourishing provision trade between Ireland and foreign countries and the plantations. Thus the preponderance of pasture lands over arable, established by Cromwell's soldiers and adventurers as a matter of necessity, was perpetuated in the country owing to the large



---

p.138



profit to be obtained from raising meat and dairy produce for foreign markets. After the Revolution a great part of the land was already under pasture. The restrictions placed on the Irish woollen trade produced little change owing to the want of capital, the action of the penal laws, and the profitable smuggling trade in wool to France and other countries. In those few cases where the sheepwalks in Ireland were lessened, the vacant lands were not ploughed and turned into arable; they were made into cattle and dairy farms.[323](javascript:footNote('E900040/note323.html')) During this period of the penal laws the well-to-do Catholic farmers, being excluded from taking up profitable tenures, gave up tillage and took to pasture farming.[324](javascript:footNote('E900040/note324.html')) They neither drained nor enclosed their farms nor built good houses. Grazing brought quick returns, and so suited them. Pasturage was the one defence of the Papist landlords against informers, so it was natural enough that they should have avoided improvements of every kind, and should have devoted themselves to getting as much as possible out of the land during their short tenures. But the result was that the ‘sculoag’ race in Ireland died out and that agriculture everywhere declined. The law which prevented Catholics from lending money in mortgages on land acted disastrously on the whole country, for it prevented capital from being applied to the land. By the middle of the eighteenth century a fairly large class of wealthy Catholic merchants had grown up through the prosperity of the provision trade, who might have lent their money to landlords for the improvement or reclaiming of waste lands. But the penal laws prevented this possible improvement of the lands of Ireland, and thus led to many evils which might have been avoided. From the commencement of the eighteenth century the



---

p.139



Irish provision trade increased greatly. Irish meat and dairy produce soon became famous for their cheapness and quality. **Boate** tells us that Irish beef and mutton ‘in sweetness and savouriness doth surpass the meat of England itself, although England in this particular doth surpass almost all the countries of the world.’[325](javascript:footNote('E900040/note325.html')) The quantity of beef, butter, tallow, and hides exported from Ireland was generally thought to be greater than that of any other country in Europe,[326](javascript:footNote('E900040/note326.html')) but for the first half of the century no satisfactory figures exist as to the exportation of these articles. Under these conditions the prosperity of Cork and other southern towns increased enormously. In the early part of the century Cork was about the same size as Bristol,[327](javascript:footNote('E900040/note327.html')) and her exports of beef and butter were greater than that of any town in Ireland or Great Britain. In 1748 it was said that this city exported her provisions to every part of the known world,[328](javascript:footNote('E900040/note328.html')) and more especially to Holland, Flanders, France, Spain, and Portugal. During the first half of the century on an average there were generally slaughtered in Cork 100,000 bullocks and cows from August to Christmas in every year.[329](javascript:footNote('E900040/note329.html')) The town continued to prosper all during the century. In 1779 Cork was held to be the second city in Ireland, on account of its great provision trade, for except in the article of linen, all its exports were larger than those of Dublin.[330](javascript:footNote('E900040/note330.html')) In 1760, nineteen years before, its population had been no less than 60,000. Other towns and districts in the south of Ireland grew prosperous by means of the provision trade. An immense number of sheep and bullocks were bred in



---

p.140



Connaught, especially in the counties of Clare and Galway.[331](javascript:footNote('E900040/note331.html')) Waterford exported great quantities of beef and butter,[332](javascript:footNote('E900040/note332.html')) while Limerick traded largely in these articles. During the first half of the century provisions remained at absurdly low prices in Ireland. In 1739 we read that good beef was one penny the pound, and other butcher's meat in proportion; butter was 3d. a pound, candles 3 1/2d. a pound; a turkey could be got for 1s., and a goose for 10d .[333](javascript:footNote('E900040/note333.html')) Between 1758, however, and 1770 the price of Irish provisions increased by about 40 *per cent*[334](javascript:footNote('E900040/note334.html')) This must have been due in great part to the new market for Irish provisions in British ports, as well as to the greatly increasing demand for them in foreign markets. During this time we can see from the statistics of exports from Ireland kept in the Irish Custom House Books, what large amounts of provisions of all kinds were exported from the country.[335](javascript:footNote('E900040/note335.html')) Bacon, beef, butter, bullocks and cows, calveskins, candles, cheese, hides, hops, pork, tongues, and tallow were exported in large quantities to practically every place with which it was worth while to trade. The breeding and fattening of all kinds of live stock became increasingly profitable. Enormous tracts of pasture land were held by single persons, many of whom were Papists. We hear continued complaints during the period on the part of Protestants that the Catholics were engrossing the profits of the provision trade. In Munster and Connaught many single persons of the Catholic persuasion held from two thousand to ten thousand acres of land in their own hands.[336](javascript:footNote('E900040/note336.html')) The profits of the provision trade went to the great landowners, Catholic and Protestant, and to



---

p.141



a horde of middlemen. It greatly increased the exports of Ireland and brought wealth into the country; but the wealth remained undistributed, and the peasantry suffered rather than gained by the conditions under which the staple trade of the country was carried on.


It is evident that many evils attended the progress of the trade in provisions. Few tenants were needed on the large grazing and dairy farms, and the result of the continual turning of land into pasture was the gradual eviction of numbers of the peasants. The landlord got his rent without trouble and the grazier profited by the depopulation, but the peasantry starved. The mass of the Irish people became cottiers, because they could not gain a livelihood as agricultural labourers, while the commercial restrictions to which the country was subjected tied them down in all their misery to the land and closed all means of escape. This state of things was noticed soon after the beginning of the eighteenth century. **Archbishop King** tells us that one of the great causes of Irish poverty was ‘the great flock of masters who ingross their land, and, making more of it that way than tenants can pay, will not allow them any place in the earth, but force them to barren places and mountains, where they are miserably starved, or oblige them to pay greater rents for worse lands than it is possible for them to pay.’ As for the profits of the trade, ‘none have it but the landlords and a few merchants, the rest being fed like beasts, while those few engross the fat of the land.’[337](javascript:footNote('E900040/note337.html')) A little later **Primate Boulter** wrote that a traveller in many counties might go ten or fifteen miles without seeing a house or a field of corn.[338](javascript:footNote('E900040/note338.html')) Whole villages were sometimes turned adrift,[339](javascript:footNote('E900040/note339.html')) and we are told that in travelling from Dublin to Dundalk through a county esteemed the most fruitful in the kingdom, a man would see no improvements



---

p.142



of any kind, no houses fit for gentlemen, no farmers' houses, few fields of corn, nothing but a ‘bare face of Nature,’ with a few wretched cottages scattered about, three or four miles apart.[340](javascript:footNote('E900040/note340.html')) The evictions which took place in 1761 were especially numerous, and were the immediate and direct cause of the rise of the Whiteboy movement; they were the effect of an increased demand for Irish cattle and beef, owing to a plague among the cattle in England and on the Continent.


A decrease in the amount of corn grown in Ireland naturally went on side by side with the increasing prosperity of pasture and dairy farming. Even as early as 1720 corn was very dear in Ireland, and large quantities were imported from London.[341](javascript:footNote('E900040/note341.html')) **King** tells us that this was due to the ‘Popish farmers,’ who monopolised their grain and would not sell it at reasonable prices to the Protestant bakers. The latter therefore made an agreement with the farmers in England to furnish them with wheat throughout the year; ‘the ill-usage they meet with from the farmers puts them on this: all the great farmers near Dublin being Papists, they first furnished the Popish bakers with the best of their grain, and either let the few Protestants of that trade have none or the refuse.’*Note reference missing.*[342](javascript:footNote('E900040/note342.html'))


Whether **King** was right or not as to the special reasons for the large importation of corn in this year, it is evident that owing to the rapidly decreasing amount of corn grown in the country, prices were bound to rise, and it was naturally becoming more profitable for Irish bakers to import the bounty-fed English corn at moderate prices instead of buying dear Irish corn. Just at this time Irish landlords were everywhere forbidding the tenants to plough, as they wished to have all their land free for grazing purposes. ‘Of late,’ **King** writes in 1720, ‘the



---

p.143



 
plough is everywhere laid aside, and generally in the late leases the landlords have obliged the tenants not to plough; one consequence of which is that all manner of grain has been dearer in Dublin than in London, and several times at double the price, insomuch that we had out of England last year 100,000 barrels of wheat from 20s. to 24s. the barrel; the land that formerly was ploughed is now turned into grazing for bullocks and dry cattle.’[343](javascript:footNote('E900040/note343.html')) Most of the leases in the counties of Dublin, Wicklow, Kildare, Carlow, Meath, and Kilkenny were subject to these restrictions on ploughing, so it was little wonder that the amount of corn grown in the country steadily decreased while its price rose. In the time of **Primate Boulter** it was impossible to raise enough corn in Ireland to supply the wants of the people, even though the mass of the Irish lived on potatoes and consumed no bread at all.


About 1725 this decrease of tillage was so great that the Irish Parliament at last took alarm, and two years later, during a time of famine and general distress, a Bill was brought into Parliament for the compulsory tillage of five out of every 100 acres under cultivation. The English Government were with some difficulty induced to consent to this Bill, and it passed the House.[344](javascript:footNote('E900040/note344.html')) Unfortunately it was soon found that the law was a dead letter and could not be enforced,[345](javascript:footNote('E900040/note345.html')) and the famines of 1741 and 1742 were worse than those of 1727 and 1728.[346](javascript:footNote('E900040/note346.html')) The Dublin Society, which was founded in 1731, now tried to do something for Irish agriculture. It gave premiums for agricultural improvements and set up model farms; it popularised new agricultural methods and issued continual directions and explanations to farmers concerning new processes. But these efforts could hardly be successful under economic



---

p.144



and social conditions which placed such an enormous premium on pasture farming. In times of distress the Irish Parliament continued to pass tentative measures with a view to promote tillage, but these schemes were generally rendered useless by a Government which would allow of nothing that might even indirectly injure the English landed interest, while little help was given in the matter by the Irish landlords, who always had an inclination for pasture farming as affording the quickest returns. No Irish farmer had the smallest encouragement to grow corn. He was discouraged by the English Corn Laws, which laid heavy duties on the importation of corn into Great Britain, by the want of bounties in Ireland on the exportation of corn, by the influx of corn from England occasioned by the English bounties, and by the fact that potatoes, not bread, was increasingly becoming the food of the mass of the people.[347](javascript:footNote('E900040/note347.html')) It is true that a few small bounties were given by the Irish Parliament on the exportation of corn, but they were very insignificant, while no attempt was made to prevent the importation of foreign corn. The first bounties of this kind were given by the Irish Parliament in 1708,[348](javascript:footNote('E900040/note348.html')) when a bounty of 1s. 6d. the quarter was granted on wheat exported when the price was at or under 14s. Bounties were also granted on the exportation of barley and malt when the price was under a certain sum the quarter. But these efforts were perfectly useless, and could have no effect in face of the large bounties given in England at this time on the exportation of all kinds of grain. These bounties were 5s. the quarter on wheat exported at or under 48s., and proportionate bounties on rye and malt when the prices were at or under certain sums. In England, except in famine years, wheat was always under 48s. during this 



---

p.145




period, whereas in Ireland wheat was scarcely ever as low as 14s.[349](javascript:footNote('E900040/note349.html')) It was absurd to suppose that in the existing state of Irish agriculture Irish wheat could ever be sold at 20s. a quarter less in price than English wheat. And in any case these early bounties on the exportation of corn from Ireland were bound to be inefficacious, because they were not combined as in England with high duties on the importation of corn.


In 1756 the Irish corn bounties granted in 1708 were slightly augmented.[350](javascript:footNote('E900040/note350.html')) This augmentation seems, however, to have been fallacious owing to an alteration in the Irish system of weights and measures,[351](javascript:footNote('E900040/note351.html')) while as yet no duties were levied on corn imported into the country. But in 1758 the Irish Parliament made its first real effort to promote tillage. In this year the first bounties were granted on the inland carriage of corn to Dublin, and this seems to have certainly had a small effect in checking the influx of British corn into Ireland. The imports of English corn into Dublin continued, however, to greatly exceed the exports of Irish corn, and so, nine years later, in 1767, a small bounty was given by the Irish Parliament on the carriage of Irish corn coastways to Dublin.[352](javascript:footNote('E900040/note352.html')) This was a wise measure, and combined with the bounties on the inland carriage, had some effect in promoting tillage, although this effect was of course very gradual. Until 1772, in spite of these efforts, Ireland continued to import far more corn than she exported; it was not until after that year that the tide turned and that Ireland began to export more corn than she imported.


This change in the corn trade between England and Ireland may have been partly due to an increase of bounties on the export of Irish corn which took place in 



---

p.146



1773,[353](javascript:footNote('E900040/note353.html')) but it was probably much more due to a decline in the English corn trade. From 1715 to 1765, or perhaps a little later, Great Britain had been able to grow corn for foreign exportation. But between the years 1766 and 1773 a change began, and the importation of corn into the country began to exceed its exportation.[354](javascript:footNote('E900040/note354.html')) This change seems to have been mainly caused by an increase of population, for from about 1760 the people of Great Britain increased very rapidly. From 1715 to 1762 the range of prices of British corn had been very low, generally about 36s. the quarter. But afterwards, the increasing demand at home, owing to the growth of population, began to tell, and the average price from 1763 to 1792 was about 48s. the quarter;[355](javascript:footNote('E900040/note355.html')) and this was the price at which bounties on the exportation of corn ceased and at which importation was allowed to begin. There was an extraordinary drop in the amount of corn imported into Ireland after the year 1772, and from that time Ireland began to export corn in considerable quantities, although it was not until after 1784 that a great export trade in Irish corn sprang up.[356](javascript:footNote('E900040/note356.html')) Part of this export went to Great Britain in those years when the price of British corn was particularly high, but prior to 1784 most of it went abroad.


It was not, indeed, till the period subsequent to 1784 that Ireland began to be an arable rather than a pasture country. Before that date, although Ireland exported considerable quantities of corn, she was still obliged to import a certain amount; but after that date it was quite possible for the Irish people to have supplied all their wants and at the same time to have exported a large surplus abroad. The Irish Corn Laws of 1784, generally



---

p.147



 
called **Foster**'s Corn Laws, certainly proved an effective measure, and did much to turn Ireland into an arable country. These laws[357](javascript:footNote('E900040/note357.html')) prohibited the exportation of wheat when its price was at 30s. the quarter, of rye when at 25s., of barley when at 14s. 6d., and of oats when at 11s., and gave bounties on the exportation of all these different kinds of grain when their prices ranged below the above-mentioned sums. They also imposed a duty of 10s. on every barrel of wheat imported when the price was under 30s. at the place of import, 10s. on every barrel of rye when the price was under 26s., and 5s. on every barrel of oats when the price was under 11s. When the prices were above all these mentioned, a duty of 2d. only was placed on every barrel of grain imported. An exception, however, was made in favour of grain imported into Dublin from Great Britain, as only a duty of 2d. the barrel was levied on British grain when the prices at Dublin were at lower rates than those at which the importation of foreign grain was allowed to begin; wheat had to be under 30s. and not less than 27s., rye under 26s. and not less than 23s., barley under 14s. 6d. and not less than 13s. 6d., and oats under 11s. and not less than 10s. A considerable advantage was thus given to British grain, but as England was now exporting less and less grain of any kind into Ireland, and as bounties were still given on the carriage of Irish corn both coastways and by land to Dublin, little competition from Great Britain was feared. The Act of 1784 also granted bounties on the importation of Irish oats and oatmeal into Ulster whenever the exportation of these food stuffs from that province should be forbidden.


The great extension of tillage, which was in great part due to the Irish Corn Laws, led to an increased division of labour, to higher wages, and to a rise in the rent of land. How far the increase of tillage led to a decrease of pasture is a little difficult to decide. Eventually it seems



---

p.148



to have done so, but the result was not immediately noticeable. **Newenham**, writing in 1809, says that the extension of tillage due to the Corn Laws of 1784 was not made at the expense of pasture, and, indeed, that for some time the quantity of pasture land even increased owing to the cultivation of waste lands.[358](javascript:footNote('E900040/note358.html')) Certainly, if we look at the statistics of the exportation of provisions from Ireland after 1784 we see no decrease in the amount exported as a whole.[359](javascript:footNote('E900040/note359.html')) Although there was a slight falling off in the export of beef,[360](javascript:footNote('E900040/note360.html')) this was more than balanced by a considerable increase in the exportation of butter and a very large increase in that of pork and bacon,[361](javascript:footNote('E900040/note361.html')) and of live bullocks, cows, and hogs. The great growth in the exportation of corn from Ireland in the years immediately succeeding the Corn Acts was not coincident with a falling off in the exportation of live stock, meat, or dairy produce. At the same time, it is true that large pasture lands were sometimes broken up into small arable farms even in the period prior to the Union, although a good deal of hitherto waste land was now enclosed for tillage. The truth was that the removal of restrictions on the commerce of Ireland in 1780 gave an impetus to all branches of trade, even to those which had not directly suffered from English commercial policy. The new condition of things stimulated the trade in meat and dairy produce as well as in everything else, so that more was obtained from a certain area of pasture land than before. From 1785 to 1795 the prosperity of Ireland was unusual, and although 



---

p.149



there may have been even during these early years some decline in the total amount of land under pasture,[362](javascript:footNote('E900040/note362.html')) this led to no falling off in the quantities of live stock, meat, and dairy produce exported from Ireland. Indeed, until the Union these quantities increased, while for twenty years after the Union there was very little falling off.


All contemporaries were of the opinion that the Corn Laws of 1784 proved extremely beneficial to Ireland. From this time until the period subsequent to the Union we hear of little acute distress even in the poorest rural districts. Corn mills sprang up everywhere, and the corn trade increased enormously. Side by side with this great growth in the exportation of corn from Ireland there was a steady diminution in the amount of grain imported into the country, except in one or two years of scarcity.[363](javascript:footNote('E900040/note363.html')) Of course, it must not be supposed that the great growth of the Irish corn trade was altogether due to **Foster**'s Corn Laws. We have already seen that a considerable increase in the exportation of corn from Ireland began as early as 1773, just about the time when England had definitely ceased to be a corn-exporting country and had become a corn-importing one. This process, was, however, at first gradual, and it was not until after 1784 that England began to import corn in very large quantities. For some time no advantage was given to Ireland as against other countries in the corn trade with Great Britain, but the new trade gave her an opportunity of which she was now in a position to avail herself, for the price of corn in England rose so rapidly that the British markets became permanently open to the importation of corn at low duties. The French wars increased prices in Great Britain to nearly famine rate, and the profits of Irish farming rose greatly. Ireland was so close to the English coast that she could export her corn there at comparatively little cost, 



---

p.150



while the Irish bounties stimulated the trade. Foster's Act was passed just at the time when, owing to circumstances in Great Britain, Ireland had an opportunity of establishing a flourishing trade in corn. The Act turned Irish agriculture into the profitable direction indicated by the new economic conditions, and increased the already great encouragement to export corn to Great Britain. During the last few years of the eighteenth century the ports of Great Britain were open to wheat from Ireland at 2s. the quarter cheaper than from foreign countries in return for the preference given to the importation into Ireland of British corn over foreign, and from this time till the repeal of the English Corn Laws in 1846 Ireland drove a very thriving trade with Great Britain in wheat and grain of all kinds.


But the Irish Corn Laws of 1784 led indirectly to certain evils. In the long run the bounties granted on the exportation of corn, combined with the already great inducement given to the Irish corn trade through the new conditions in England, led to an excessive subdivision of farms and to the ruinous system of partnership leases. This was of course due to the fact that there was so little capital in Ireland that it was practically impossible to find tenants capable of cultivating and occupying large tillage farms. This tendency to subdivide farms was emphasised by the existing custom of **gavelkind** which hitherto had acted in a harmless manner owing to the circumstances of the country. It was also emphasised by the legislation of the last years of the eighteenth century which, by removing the Roman Catholic disabilities in regard to property and extending to Catholics the 40s. franchise, led the landlords to greatly increase the number of holdings. This turning of the land into very small farms gave a great encouragement to the growth of population. The new occupiers of arable land were very poor, and so they wanted to buy as much cheap labour as possible. They therefore allotted small pieces of ground to



---

p.151



the peasantry on which to build cabins and raise potatoes. Once a sufficient supply of cheap labour had been obtained in this way it was found impossible to check the stimulus which had been given to the growth of population, for new habits and customs had by this time been formed conducive to the increase of the peasant class. During the first half of the nineteenth century the amount of pasture land in Ireland decreased steadily, for the economic circumstances of the time enabled the landlords to exact exorbitant rents for very small pieces of ground. On the whole, although the Corn Laws of 1784 seemed at the time productive of much good, as matters afterwards turned out they offered almost too great a stimulus to arable cultivation, bearing in mind the important fact that the great mass of the people were dependent on agriculture and that there was little industrial life in the country. The resulting evils were due to peculiar conditions prevailing in Ireland—to the custom of **gavelkind** and to the small amount of capital possessed by the whole people. The Corn Laws, acting on the special circumstances in which Ireland found herself, certainly led in the long run to an excessive subdivision of farms, to bad modes of cultivation, yielding quick returns, and to a disastrous increase in the population of the country. Past events and conditions had thrown the Irish peasantry so entirely on the land that there was little escape for them from the miserable situation in which they were placed. It was now more especially that the full evils due to the absence of industrial life among the great majority of the Irish people began to appear in their true light.




---

p.152





| Year ended 25th March | Wheat exported: Qtrs | Other corn exported: Qtrs | Wheat imported: Qtrs | Other corn imported: Qtrs |
| --- | --- | --- | --- | --- |
| 1764 | 24 | 9,063 | 25,763 | 32,269 |
| 1765 | 270 | 22,113 | 10,529 | 49,722 |
| 1766 | 175 | 10,830 | 14,130 | 41,679 |
| 1767 | — | 313 | 39,456 | 34,824 |
| 1768 | 1,813 | 26,632 | 11,802 | 7,023 |
| 1769 | 7,211 | 64,090 | 2,199 | 5,332 |
| 1770 | 51 | 19,171 | 43,532 | 36,310 |
| 1771 | — | 4,595 | 53,448 | 59,796 |
| 1772 | 847 | 3,425 | 12,163 | 23,560 |
| 1773 | 2,187 | 21,724 | 2,861 | 7,454 |
| 1774 | 811 | 65,835 | 4,104 | 1,004 |
| 1775 | 3,675 | 48,763 | 3,235 | 1,770 |
| 1776 | 14,171 | 107,893 | 7,547 | 8,663 |
| 1777 | 16,207 | 99,829 | 3,457 | 49,795 |
| 1778 | 11,616 | 65,349 | 2,477 | 37,895 |
| 1779 | 3,917 | 36,599 | 10,569 | 33,317 |
| 1780 | 9,508 | 98,685 | 1,476 | 22,839 |
| 1781 | 43,977 | 58,685 | 833 | 63,821 |
| 1782 | 43,901 | 93,040 | 590 | 51,611 |
| 1783 | 3,482 | 42,612 | 523 | 24,665 |
| 1784 | 324 | 19,946 | 49,206 | 3,865 |
| 1785 | 18,478 | 80,227 | 37,626 | 27,611 |
| 1786 | 143,341 | 272,233 | 856 | 18,813 |
|  | Barrels | Barrels | Barrels | Barrels |
| 1787 | 62,118 | 527,170 | 647 | 1,274 |
| 1788 | 50,157 | 336,741 | 593 | 4,655 |
| 1789 | 218,737 | 367,904 | 115 | 1,366 |
| 1790 | 148,166 | 597,225 | 479 | 1,762 |
| 1791 | 153,769 | 718,425 | 10 | 1,967 |
| 1792 | 119,781 | 632,975 | 1,212 | 4,459 |
| 1793 | 92,700 | 640,047 | 5,525 | 27,252 |
| 1794 | 36,701 | 558,360 | 4,731 | 1,294 |
| 1795 | 31,231 | 646,690 | 96,294 | 2,174 |
| 1796 | — | 157,065 | 13 | 1,934 |
| 1797 | 15 | 648,621 | 55 | 8,171 |
| 1798 | 67,526 | 610,761 | 611 | 2,121 |
| 1799 | 46,325 | 649,134 | 85 | 4,536 |
| 1800 | 345 | 159,277 | 18,588 | 46,355 |






Early Financial Relations between England and Ireland
-----------------------------------------------------


Control of the Irish Parliament over Finance—Irish Finances at the End of the Seventeenth Century — Irish Finances during the Eighteenth Century — Contribution of Ireland towards Imperial Needs: (a) the Military Establishment; (b) the Pension List — Financial Abuses and administrative Corruption — Efforts of the Irish Parliament to check Absenteeism — Success of the Irish Parliament in establishing a modified Control over Finance — Estimate of English Financial Policy.
During the seventeenth and eighteenth centuries the Irish Parliament had little direct control over Irish finance. The hereditary revenue which formed by far the larger part of the total receipts of the Irish Government was by common law the property of the Crown and beyond the direct control of Parliament. It had grown chiefly out of the confiscations made after the Rebellion of 1641 and rested on the legislation of Charles II. It consisted of such items as Crown rents, quit rents, hearth money, customs, excise, and licenses for selling ale, beer, and strong waters, and was vested for ever in the King and his successors.


It was this peculiarity of Irish finance which made it so difficult for the Irish Parliament to cure the numerous financial abuses under which the country groaned. This was especially the case until the beginning of the eighteenth century, for up to that time the hereditary revenue of the kingdom was sufficient for all civil and military purposes and even furnished a considerable surplus, which was annually remitted to the King.[364](javascript:footNote('E900040/note364.html')) But



---

p.154



during the reign of Anne new wants arose and the hereditary revenue was found to be insufficient to support the establishments. Fresh taxes had to be granted, it became necessary to summon frequent Parliaments, and the Irish legislature began in consequence to acquire some sort of modified control over the finances of the country. As time went on and this control increased, Parliament grew more bold and began to attack the corrupt financial practices of the Government. But the power of the purse possessed by the Irish Parliament never became really complete, and after 1782 this want of complete financial control was bitterly resented. After the Restoration much hardship was inflicted on Ireland by the system of farming out the revenue. The Irish revenue was often farmed out for nearly twice the sum that was received by the Treasury; in consequence the farmers of the customs made huge profits, the people paid double their legitimate taxes, and the Treasury gained nothing. In 1669, for example, the estimated expenditure on the Irish civil and military establishments amounted to £170,000, and the taxes necessary to defray these expenses were farmed out for the sum of £219,500.[365](javascript:footNote('E900040/note365.html')) In 1672 Lord Ranelagh agreed to receive and issue the whole revenue for five years. This gentleman actually undertook to defray the growing charges and all arrears due to the establishments and other debts owing from the King in Ireland, and over and above to pay the King £80,000 a year.[366](javascript:footNote('E900040/note366.html')) At the same time, we may be sure that he did not lose sight of his own interests. In 1676 the Irish revenue was again farmed out, this time for £240,000, raised in 1678 to £300,000. From this time, however, the system of farming ceased. Charles' successors were not quite so impecunious as their predecessor, and commissioners were appointed for the management of the Irish revenue. 



---

p.155



But in spite of this system of farming out the revenue under Charles II., Irish finances were in a fairly prosperous state during his reign, and they continued to remain so until nearly the end of the century. In 1681 the hereditary revenue amounted to £600,000 for the year, while there was practically no debt. The Revolution, of course, gave a shock to the credit of the country, but once Ireland had recovered from the effects of the war, trade and industry soon began to flourish, and the revenue increased rapidly as a result. But from the beginning of the eighteenth century things changed. The impoverishment of the country through the commercial policy of England led to an immediate diminution in the revenue. As early as 1702 there were complaints of the want of specie in the country. The Bishop of Derry writes, ‘We have no money at all, nor like to have any without some vent for our commodities.’[367](javascript:footNote('E900040/note367.html')) From 1700 the revenue sunk rapidly. In that year the total revenue had amounted to £505,149. Five years later it was only £335,505, and in 1715 still only amounted to £342,222.[368](javascript:footNote('E900040/note368.html')) This decrease in the revenue was almost entirely due to a diminution in the yield from customs and excise, and this diminution in its turn coincides almost exactly with the prohibition placed by England on the exportation of Irish woollens. In 1700 the customs and excise yielded £458,150. In 1703 this yield had decreased to £276,964, and in 1705 it amounted only to £324,418; in 1710 to £314,908, and in 1715 to £333,776.[369](javascript:footNote('E900040/note369.html')) Not until the year 1725 did the customs and excise yield as much as in 1700, and the total revenue in consequence increased to £636,461. The Irish revenue was at this time nearly altogether dependent on the yield from the customs and excise. When this yield dropped off, not only by reason of a total cessation of the exportation



---

p.156



of all woollen stuffs from Ireland, but also through a decrease of all exports and imports because of the shock given to trade and the want of employment in the country, it was inevitable that the revenue should diminish also. The increase in the yield from customs and excise, and consequently in the revenue from about 1720 was not, however, due to an increase in the exportation of raw or manufactured products. We know that neither the exports of linen nor those of provisions and live stock were as yet very large, while **Archbishop King** tells us in 1717 that the revenue was gradually beginning to recover by means of larger importations ‘but little or no exportation.’[370](javascript:footNote('E900040/note370.html')) These increasing importations were no doubt balanced by the large and growing sums of money that had to be annually transmitted to absentee landlords, sinecurists and pensioners, both civil and military, living in England. Certainly the Irish Government found itself in continual financial difficulties during the early part of the eighteenth century. The long series of wars began to affect Ireland as well as England. The war of the Spanish Succession was entered into before Ireland had recovered from the effects of the preceding struggle. A large sum of money had therefore to be borrowed to defray expenses. Further, in 1715, the Government had to borrow £50,000 from the Irish Parliament for the purpose of taking military measures to crush out the rebellion in Scotland and secure the new Dynasty.[371](javascript:footNote('E900040/note371.html')) But after peace was made, the debt went on increasing simply through want of resources and the sheer inability of Ireland to support her establishments. The country soon became thoroughly exhausted. **Archbishop King**, writing in the February of 1717 to the Archbishop of Canterbury, says: ‘We are poor to the utmost degree in Ireland. Our Lord Lieutenant the night before he went issued orders for the payment of near fifty thousand pounds



---

p.157



 
and did not leave fifteen in the Treasury to pay it, and we have every day new additions to our establishment, £3,000 per annum to one for thirty-two years, which in all makes £96,000, the fifth part of the current coin of Ireland.’ The consequence was that the national debt, which had hitherto been very inconsiderable, now became an important feature in the national finances. The small debt of rather over £16,000 which had existed at the beginning of 1715 was increased by midsummer, 1717, to nearly £92,000.[372](javascript:footNote('E900040/note372.html')) That this should have been considered a very large debt by the Irish Parliament shows how very poor the country was. During the following years, until the debt was paid off, there was much distress in Ireland, for new duties had to be imposed by Parliament to pay off both interest and principal. By 1721 the debt was reduced to £66,000, but the Commons, after emphasising the decay of trade and the impoverished state of the country, petitioned the King in their address to the Throne to give such directions as would prevent the increase of the debt.[373](javascript:footNote('E900040/note373.html')) But by August of the following year the condition of the finances was very bad. There were only five shillings left in the Treasury, and the arrears due to the establishment amounted to more than £200,000.[374](javascript:footNote('E900040/note374.html')) In the parliamentary session of 1725 it was found that the debt had doubled in the last four years, and **Archbishop King** tells us of the ‘great arrears due to the establishment, above three hundred thousand pounds, and new funds are expected, but where they will be got God knows except we flea the people and sell their skins.’[375](javascript:footNote('E900040/note375.html')) In 1729 Lord Carteret remarked in his address to the Irish House of Commons, that the revenue had fallen short in spite of the success in the linen trade, and that still larger arrears were owing to the establishments.[376](javascript:footNote('E900040/note376.html')) In 1731 there



---

p.158



was an even greater deficiency of revenue; the debt had enormously increased and now stood at £330,000.[377](javascript:footNote('E900040/note377.html')) Resolutions concerning the decay of trade and the scarcity of money fill the Journals of the House during these years. On the accession of George I., in 1727, further duties equal to about one-third of the hereditary revenue, were granted by the Irish Parliament in support of the establishments. This new taxation combined with the duties levied for paying off the debt apparently burdened the country. However, by exercising the strictest economy, the debt was finally paid off by 1754, in spite of heavy additions which had been made to it by the expenses of the war which ended with the peace of Aix-la-Chapelle. But fresh money had soon to be borrowed, for the ordinary revenue of Ireland was not equal to the new demands made by England to support the expenses of the Seven Years' War. At the peace of Paris in 1763 the Irish debt amounted to as much as £520,000, the largest ever contracted in the country. Instead of diminishing in the succeeding years of peace, the debt continued to increase, and by 1773 it had risen to £1,757,000, including funded and annuity debt.[378](javascript:footNote('E900040/note378.html')) The truth is, that the Irish revenue was no longer equal to the expenses of the Government. While the revenue of Great Britain had been increasing by leaps and bounds, that of Ireland had remained fairly stationary. Between 1727 and 1773 no new taxes were imposed in Ireland for the public service of Government. The loan duties were not granted in support of the establishments, but were appropriated to the payment of the interest and the liquidation of the national debt; while the additional duties imposed during these years were appropriated to the encouragement of tillage and various branches of trade and manufactures.[379](javascript:footNote('E900040/note379.html')) Between 1701 and 1759 the British revenue increased by about 



---

p.159



 
40 *per cent*, while during practically the same period the Irish revenue increased by only 5 *per cent* Although the Irish system of taxation followed the same lines as the English, it had not developed alongside of it. The new taxes levied in Great Britain during the latter half of the eighteenth century were never applied to Ireland. The Land Tax has never existed in Ireland, and the excise and custom duties were always very light.[380](javascript:footNote('E900040/note380.html')) Intoxicating drinks were hardly taxed at all, and this was a misfortune for the country, as no check was put on drunkenness. **Arthur Young** tells us that a man could get drunk on whiskey for 2d. and that ‘other spirits, wines, and tobacco are also very well able to bear much heavier taxes than they labour under at present.’[381](javascript:footNote('E900040/note381.html'))


Nevertheless, it is difficult to decide whether Ireland was, on the whole, lightly or heavily taxed during the eighteenth century. If we look at the total sums raised, they certainly appear small compared to the size and population of the country, and side by side with the huge sums paid by British taxpayers. But other considerations have to be taken into account. The poverty of Ireland was extremely great during nearly the whole of this period, and if we look at the small industrial resources of the country, resources reduced to their most insignificant compass by the commercial policy of England, we have to admit that the Irish people paid almost as much in taxes as could reasonably have been got from them. It is often said that Great Britain alone bore the whole burden of the expanding Empire. Even if such a statement were true, it must be remembered that until the last twenty years of the eighteenth century, Ireland was almost entirely excluded from the trading benefits which the colonial expansion had conferred on the people of Great



---

p.160



Britain. But although Ireland may have directly contributed little to the needs of the Empire, she indirectly contributed a great deal through the large military establishment she had at all times to keep up, in readiness to help England in her wars, and through an enormous pension list, of which only a very small part was given to persons resident in Ireland. At the same time, the vicious custom of keeping nearly all remunerative offices in the Government, Church, and Army in the hands of Englishmen who hardly ever set foot in the country acted as a huge tax on the Irish people. A great part of the money paid by Ireland went to uses which corrupted and degraded the country. The financial abuses of the eighteenth century in the shape of pensions to the kings' favourites, and sinecure offices of all kinds, not only ground down the people by unnecessary taxes, or taxes that might have been spent in useful purposes, but also perverted the morals of the upper class of Irishmen.


There were thus two ways in which Ireland contributed to the general needs of the Empire—by her military establishment, and by her pension list. After the Restoration Ireland contributed no ships to the Imperial navy. Under **Strafford** part of the public revenues of the country had been constantly spent in furnishing ships for the defence of the Irish coast.[382](javascript:footNote('E900040/note382.html')) But when, after the Restoration, the Irish Parliament made a perpetual grant for the support of an Irish navy, the grant was never permitted to be applied. At this time England greatly feared any increase in the power of Ireland, and the idea of an Irish navy was particularly obnoxious to her. The fund was, therefore, reappropriated to the increase of the army.


At the Restoration the Irish army was not large. It consisted of eighty-eight old and fourteen new companies of foot, and a regiment of guards—altogether about 6,400 men. In 1678, however, it was thought that Ireland did



---

p.161



 
not pay her full share towards the support of the general military establishment, and the army was increased by the
Duke of Ormonde to 9,120 foot and 1,464 horse.[383](javascript:footNote('E900040/note383.html')) At the same time Ireland was made to contribute £36,000 a year for shipping to secure the Irish coast, and £44,000 a year for the maintenance of Tangier.[384](javascript:footNote('E900040/note384.html')) This increase of the military list and the necessity of supporting two new establishments fell heavily on the country, and when soon after a further £18,000 a year had to be raised for the maintenance of Tangier, the Irish revenue was strained to its utmost. It says a great deal for the general condition of the country that under these circumstances no debt was incurred. In 1678, out of a revenue of £300,000 Ireland paid £97,000 for naval services and the keeping of Tangier, almost one-third of her total revenue. At the same time she kept nearly as many men on her military establishment as she did during the first part of the eighteenth century, when she had not the other expenses and when her revenue was larger.


Until the end of the reign of William III. the regiments sent out of Ireland for foreign service were paid by England, as once out of Ireland they were deemed to be off the establishment. But in 1701 three regiments sent from Ireland to the West Indies were, for the first time, paid by Ireland, England merely making up the small difference between their pay and that of the English troops. In the war of the Spanish Succession, however, England paid the Irish regiments sent to Flanders, Spain, and Portugal, because of the great poverty of Ireland at that time.[385](javascript:footNote('E900040/note385.html')) This was the last occasion on which England supported Irish troops serving abroad. From this time Ireland always paid her own troops, whether on active service or merely stationed abroad in times of peace; but until the



---

p.162



death of George II. England continued to pay the difference, when there was any, between their pay and that of the British regiments.[386](javascript:footNote('E900040/note386.html')) During the second half of the eighteenth century the expenses of the Irish military establishment necessarily increased greatly. In 1759, during the struggle between England and France in North America, Ireland raised six new regiments and a troop of horse.[387](javascript:footNote('E900040/note387.html')) A specific vote of credit for £150,000 was given by Parliament, and afterwards provided for in the Loan Bill of that session.[388](javascript:footNote('E900040/note388.html')) A little later a second vote of credit was given for £300,000,[389](javascript:footNote('E900040/note389.html')) and the interest on Government stock was raised by 1 *per cent*. In little more than a year there was paid out of the Treasury for military purposes rather more than £703,957.[390](javascript:footNote('E900040/note390.html')) These fresh expenses, brought upon Ireland by the war, produced some distress. Three large banks in the country stopped payment, and the remaining three did practically no business; paper stopped circulating, and no bank would discount even first class bills[391](javascript:footNote('E900040/note391.html')) In 1761 the rupture with Spain increased the expenses of the military establishment, and the Irish Commons agreed to provide five new battalions, and a fresh vote of credit was passed with unanimity.[392](javascript:footNote('E900040/note392.html')) For the next two years Ireland kept in pay an army of 24,000 men, 8,000 of whom were sent to fight abroad, 16,000 remaining at home for defence. At the same time Ireland sent 33,000 recruits to fill up gaps which had been made in British regiments, while she spent over £600,000 in Germany for the support of the war.[393](javascript:footNote('E900040/note393.html')) After the Peace of Paris, in 1763, the new regiments were disbanded, and the number of men reduced to the 



---

p.163



peace footing of 12,000. The number of regiments, however, was increased, and consequently the number of officers, additions being made at the same time to their pay. There were now forty-two regiments on the establishment instead of only thirty, although the number of men remained the same. All this caused an additional expenditure of £15,000 a year. The annual expense of the staff of general officers now amounted to £12,000, while in England at this time it only came to £11,000.[394](javascript:footNote('E900040/note394.html')) The cost of maintenance of the Irish army was very extravagant; it had been created by an English Act of Parliament, and the absence of an Irish Mutiny Bill made it impossible for the Irish Commons to obtain any real control over its management.


In 1767 the king decided that Ireland must bear an augmentation of her military establishment. But in spite of the prosperity of the victualling trade and the growth of the exports of linen, the debt had increased in the four years of peace by as much as £60,797;[395](javascript:footNote('E900040/note395.html')) the revenue was still below the expenditure, and all this in a time of unusual commercial prosperity. After investigating the matter, the Lord Lieutenant and Council decided that the country could only bear an increase of 2,000 men to its peace establishment of 12,000. But their representations were useless, and the Irish army was raised to 15,235 men.[396](javascript:footNote('E900040/note396.html')) It was, however, agreed that 12,000 of this number were always to remain in Ireland, except in the cases of rebellion or an invasion of Great Britain. The number of officers was to be diminished, and also the number of general officers who were absentees. At the same time the Irish battalions were to be assimilated to the British, thus reducing their cost.


But in spite of some actual reforms, this addition to the



---

p.164



Irish army involved an increased charge during the first year of £54,118.[397](javascript:footNote('E900040/note397.html')) Later on this new expense increased, for during the nine years from 1769 to 1778, when it was discontinued, the whole additional charge came to £620,824. These expenses, combined with the rapidly swelling pension list, led to a period of considerable financial distress in Ireland. From 1769 the revenue steadily decreased for some years; in 1770 it was very low, and £100,000 had to be borrowed in order to provide for the troops. Public credit was at its lowest, and great commercial distress, due to circumstances connected with the war, made the condition of the country miserable in the extreme. Nevertheless the Irish Commons managed to help England in her hopeless struggle with the American Colonies. In 1774 the king asked Ireland for 4,000 men out of her home establishment of 12,000, at the same time offering to replace them by an equal number of foreign troops to be paid by Great Britain. There was a certain amount of discontent at this request, for the Irish Act of Parliament of 1769 had laid down that none of the men on the home establishment could be sent abroad on active service. But the exigencies of England were so great that the loyalty of the Commons prevailed, and the 4,000 soldiers were sent to America. But Ireland refused the offer of foreign troops, and for a few years paid half the expense of her regiments in America.[398](javascript:footNote('E900040/note398.html')) In every war of the eighteenth century, except that of the Spanish Succession, Irish regiments, paid by the Irish Treasury, formed a large part of the British forces. The cost of the Irish military establishment was in times of peace generally three times as much as that of the civil establishment, while in times of war the proportion was very much greater. During the 



---

p.165



greater part of the eighteenth century the permanent military establishment of Ireland was larger in proportion to the Irish population than that of Great Britain in proportion to the British population.[399](javascript:footNote('E900040/note399.html'))


But Ireland contributed in yet another way to the support of the Empire; this was by means of her pension list. Pensions were given by the king out of the whole proceeds of the hereditary revenue. This, as a matter of fact, was illegal, for many of the taxes under the head of the hereditary revenue had been granted for specific purposes. For example, the Act establishing the excise lays down that it is ‘for and towards the constant Pay of the Army, and for defraying the Public Charges in the Defence and Preservation of the Realm.’[400](javascript:footNote('E900040/note400.html')) In other cases the Acts had clauses declaring that no pensions should be granted out of the revenues arising from the Acts. Thus the Acts granting hearth money, quit-rents, and licences on ale, beer, and strong waters all had barring clauses to this effect.[401](javascript:footNote('E900040/note401.html')) In fact, the only revenue left by law in Ireland at the absolute disposal of the Crown amounted to about £15,000 a year.[402](javascript:footNote('E900040/note402.html')) It was only this amount that the king had a legal right to dispose of in pensions. But little attention was paid to legality, and as the various duties comprising the hereditary revenue had been granted in perpetuity, the Irish Commons could do nothing in the matter. The Act establishing the excise was perverted so as to include pensions in the category of public services. As to the rest, Government argued that the king had an uncontrolled right to charge the money brought into the Treasury with pensions, for the barring clauses in the statutes granting hearth money, quit-rents, and licences could affect the money only before it was brought into the 



---

p.166



Treasury; once the money was in the Treasury, it became part of the aggregate fund to be used indiscriminately for the support of the Government. In England there was no instance of the Crown granting any pensions for a number of years or lives on the produce of funds raised and granted by means of a statute law for specific purposes. But in Ireland the theory of the Government was accepted and acted upon all during the eighteenth century, in spite of the spasmodic protests of the Irish Commons. The whole of the hereditary revenue became thus burdened with pensions.


These pensions were of three kinds: civil, French and military. There was little abuse connected with the military pensions, and they formed a very small part of the total pension charge. The French pensions were granted chiefly to French refugee Protestants of rank who had fled to England or Ireland. During the early part of the century the charge under this head was often very heavy, and was the cause of much complaint. At the same time, many Frenchmen had pensions on the ordinary civil and military lists. **Archbishop King**, writing in 1715, thought that ‘above one half of the military pensions are to people of that nation, and above one fifth of the civil; besides this, the article of French Pensions is almost equal to all the rest: if we add to this those in half pay and in the army, I believe one ninth of the whole may be their share.’[403](javascript:footNote('E900040/note403.html')) In 1705 there had been some attempt to make these French pensioners of some use by employing them in active service abroad. On December 4th, 1705, the Lords Justices of Ireland wrote to the Duke of Ormonde stating that they had acquainted the French agent with the Queen's pleasure concerning the employment abroad of the French pensioners. ‘We are of opinion,’ they wrote, ‘that employing them upon this occasion will very much conduce to her Majesty's service in this conjuncture, 



---

p.167



and besides the advantage they will reap by it in giving them hereafter a pretence of having served, it will be a means to ease this establishment in part of that charge.’[404](javascript:footNote('E900040/note404.html')) The French pensioners objected that they had no commissions and were not entitled to bear them, not being naturalised subjects of the king; this want of commissions, they said, would expose them to ill-treatment by the enemy in case they were taken prisoners. Besides which, they thought their pensions too small to support them on foreign service.[405](javascript:footNote('E900040/note405.html')) These objections were taken into account and a small allowance granted to the pensioners, in addition to their pensions. The Lords Justices considered it very reasonable that ‘men who have received an allowance from the Crown for so many years together should go upon service when there is occasion.’[406](javascript:footNote('E900040/note406.html')) But when the matter was settled, it was found that the majority of the French pensioners were totally unfit for active service; while, as regards those who were sent, there were continual difficulties as to the position they should occupy in the regiments. The Irish soldiers resented being officered by Frenchmen, and after a short time the pensioners were recalled. No subsequent attempt was made to employ them in active service.


Luckily, about 1738 the French pensions began to decrease rapidly in amount, and from this time we have little mention of them. It was in connection with the ordinary pensions on the Irish civil establishment that the greatest abuses occurred. Very few of the pensioners lived in Ireland at all. The vast majority of them were Englishmen who lived in England; some were foreigners, some Irishmen residing habitually in England. Whenever the king wished to give a pension to some particularly scandalous person, he granted it on the Irish establishment,



---

p.168



well knowing the Irish Parliament could do little, while the English Commons might not have allowed the funds they voted to be used for such purposes.


Still, the Irish Commons did occasionally make a bold stand against the rapidly swelling pension list. In 1701 they struck off pensions to the amount of £16,000, chiefly French, and on several occasions it is certain that some of the most scandalous pensions were withheld for fear of the outspoken criticism


 of the Irish legislature. In the ten years between 1705 and 1715 the pensions on the civil establishment — exclusive of French — increased from a little over £8,000 to nearly £22,000[407](javascript:footNote('E900040/note407.html')) **Archbishop King**'s letters are full of indignation at this state of things. Some very large sums were already given to persons of both sexes high up in the king's favour, and this abuse was destined to become very much worse as time went on. **King** writes, ‘It is preposterous that £5,000 pension should be allowed a nobleman, nay a lady, for services that, though very obliging to the person that gave the pension, yet were not proper to be alleged as motives in the grant.’[408](javascript:footNote('E900040/note408.html')) Very often a pension was attached to an office, and thus put permanently on the establishment. This was the case as regards the office of the keeper of the records in Birmingham Tower. **King** tells us that these records were not worth £100 to the kingdom, and that the salary for the office was only £10 a year. But when Mr. Addison became Secretary to the Lord Lieutenant he obtained this office together with a yearly pension of £500. Later on he sold it, and the pension as well as the office went to an Englishman living in England, and thus there was no hope of ever getting it off the establishment. ‘I could instance in two or three more,’ **King** writes in 1722, ‘and of a truth we never had nor heard of so lavish a management as this has been since his Majesty came to the Crown, and, which is yet more mischievous, 'tis whispered



---

p.169



that the Ministry is against these exorbitant pensions, but they are forced to comply with the king or turn out.’[409](javascript:footNote('E900040/note409.html')) Early in the following year the archbishop writes that, amongst other pensions, there has just been added to the establishment ‘a pension of £1,200 to the **Countess of Walsingham** and one of £1,200 to the **Countess of Lippic**, which makes an addition in one year of £14,400.’[410](javascript:footNote('E900040/note410.html'))


From 1725 to 1759 the pension list steadily increased. In 1751 the **Countess of Yarmouth** was given an annual pension on the Irish establishment of £4,000, which continued for over twenty years. From this time, too, we may constantly see on the pension list names of Germans like the **Baron de Steinberg**, **Rudolf de Spork**, and **Herman Hobourg**. In 1759 a pension of £5,000 a year for life was given to the **Princess of Hesse**. The Irish Commons remonstrated against many of these pensions. In 1756 especially, they did their best to remedy the grievance by appointing a committee to look into the whole matter. Parliament was at this time particularly annoyed because a pension of £800 a year which had just lapsed through the death of its possessor, the **Queen Dowager of Prussia**, had through the influence of the **Duke of Bedford** immediately been given to **Lady Betty Waldegrave**.[411](javascript:footNote('E900040/note411.html')) The committee resolved that such pensions were an injury to the Crown and to the public, and the House desired the Lord Lieutenant to lay their resolution before the king. The Lord Lieutenant agreed, but the king did nothing to reduce the list. Indeed matters grew worse and worse. From 1759 to the Union, the Irish pension list increased far more rapidly than it had done in the preceding half century. Between 1760 and 1770 this was especially the case. In those ten years the amount of pensions on the



---

p.170



civil establishment — exclusive of French — increased from over £54,000 to £85,000. But the amount of pensions was not the worst injury; the chief grievance lay in the distribution of the pension-money. Huge sums were given to persons who happened to be in the king's favour, while the widows and orphans of Irishmen who had served their country received only the smallest pittance. George III. was particularly guilty in this respect. In 1763 a pension of £1,000 was granted on the Irish establishment to M. de Verois, the Sardinian ambassador who had negotiated the peace lately concluded with France. The result was a stormy debate in the Irish House, and an attempt to address the king on the matter. But through the influence of the Government the motion for an address was thrown out by a large majority.[412](javascript:footNote('E900040/note412.html')) In this rejected address, which was drawn up by the patriotic minority of the Commons, it was resolved that such pensions as the one just given to the Sardinian ambassador, were ‘one great cause of the heavy debt which oppresses the kingdom, and which we can scarce ever hope to discharge, deprived as we are of those resources from trade with which the other parts of his Majesty's domains are blessed.’[413](javascript:footNote('E900040/note413.html')) During the next month this address was again moved, and again thrown out, so that once more the Commons failed in a direct attempt to oppose the financial policy of the Crown. George III. continued to grant Irish pensions to all his favourites to whom he dared not grant pensions on the British establishment. **Lady Kilmansegg** had a pension of £750, afterwards raised to £1,250; for a great many years, a person called Christian Shroder[414](javascript:footNote('E900040/note414.html')) had one of £2,000 for about twenty years, while the Countess of Bellamont received



---

p.171



one of £1,500. Many large pensions were given to Germans. Augustus Shutz had a pension of £1,200, while **Ferdinand, Duke of **Brunswick****, was given one of £4,000, afterwards raised to £6,700. Others were given to Englishmen of high birth; **Lord Bathurst** received a pension of £2,000, the **Duke of **Gloucester**** one of £3,000, the **Duke of Cumberland** one of £3,000, and the **Earl of **Cholmondelly**** one of £3,700. The **Princess Amelia** had a pension on the Irish establishment of £1,000 for life; in 1764 the huge pension of £5,000 was given to the **Princess Augusta** also for life; while in 1774 **Caroline Matilda, Queen of **Denmark****, received a yearly pension of £3,000 during the king's pleasure, and this just as she was about to be banished from England. And it is worthy of remark, that while women like the **Countess of **Yarmouth**** or the **Queen of **Denmark**** received these large pensions on the Irish establishment, **Catherine Talbot**, the wife of an Irishman who died in action, was only given £50 a year by the Government.


A further scandal in the matter was that very often a pension annexed to an office was continued after the owner was promoted to another place, and therefore could not, or would not, fulfil the duties formerly attached to his pension. But the financial grievances of Ireland did not stop with the pension list. The country was still further drained of its resources by the vicious custom of giving nearly all profitable offices in the Government, Church, and Army to Englishmen who generally lived in England, and did little to discharge the duties of their offices. Nearly all civil and military salaries went to persons who hardly ever set foot in Ireland. From the very beginning of the eighteenth century complaints were loud on this score. In 1702 **Archbishop King**, then Bishop of Derry, complains of ‘all employments being in deputation. The Government, Chancery, Master of the Rolls, Clerk of the Council, Registrar of the Chancery, Protonotaries, Remembrancers, etc., by which the subject is oppressed,



---

p.172



and the money sent away.’[415](javascript:footNote('E900040/note415.html')) Later on, in 1715, he writes of the vast numbers of absentee officers of all sorts: ‘I understand preliminary that there are above 200 of the army absent, and sometimes a regiment is headed by a lieutenant, all superior officers being in England.’[416](javascript:footNote('E900040/note416.html')) An immense number of Irish offices were given to English politicians, most of them absolute sinecures. **Swift** tells us in his Drapier Letters,[417](javascript:footNote('E900040/note417.html')) that Lord Berkley was Master of the Rolls, Lord Palmerston First Remembrancer with a salary of £2,000 a year; Doddington was Clerk of the Pells with a salary of £2,500 a year; Lord Burlington held the office of Hereditary High Treasurer, while Mr. Arden received a salary of £9,000 for undertaking the office of Under Treasurer. None of these persons ever went to Ireland or gave any sort of return for the large salaries they got out of the Irish establishment. In 1725 **King** writes that ‘the people of this kingdom are in effect excluded from the Church, from the Revenue, from the Bench, from the Army, and all considerable offices, all which are in effect maintained by the public money, or that of the kingdom.’. In consequence gentlemen were in great distress as to what to do with their sons, ‘all those ways for providing for them being shut up against them; as an instance of this they observe that about seventeen thousand per annum has been given to gentlemen of England, and not five hundred (pounds) to all in Ireland, and that pittance has been disposed of by interest made there in Britain without regard to the Irish claims.’[418](javascript:footNote('E900040/note418.html')) In 1766 we find an additional salary of £600 a year given to Lord Viscount Jocelyn and Robert Jocelyn his son, and their survivors, as searchers of the port of Galway.[419](javascript:footNote('E900040/note419.html')) This office was a sinecure and involved no duties.



---

p.173



All this was a real grievance to Ireland, and as regards the Irish Church matters were no better. Every Lord Primate during the eighteenth century was an Englishman; out of the eighteen Archbishops of Dublin and Cashel during this century, ten were Englishmen, while all the most lucrative bishoprics and benefices were given to Englishmen as a matter of course.[420](javascript:footNote('E900040/note420.html')) In 1725 we have complaints from **Archbishop King** that the bishops sent from England made a point of giving everything in their power to their English friends and relations. ‘The Bishop of Derry,’ he writes, ‘since his translation to that see has given about £2,000 in benefices to his English friends and relations; Lord Primate hath had two livings void since his translation, one he has given, of about £200 per annum, to one of the ‘Walton’ Blacks[421](javascript:footNote('E900040/note421.html')) whom he since ordained priest, and the other to one Mr. Blennerhasset, whom they commonly call an Hottentot   
[*...*]  
 the Bishop of Waterford has not only given all livings of value in his gift to his brothers and relations, but likewise his vicar-generalship and registry, though none of them reside in the kingdom.’[422](javascript:footNote('E900040/note422.html'))


This scandalous state of affairs, which raised the indignation of an honest churchman like **King**, was the natural result of giving most of the high offices in the Church to Englishmen. Many people thought that this policy was necessary to the peace of Ireland, in order to secure a preponderance of English influence in the House of Lords. Primate Boulter was of this opinion, for he writes in 1726, that unless some person ‘be not now brought over from England to the Bench, there will be thirteen Irish to nine English bishops here, which we think will be a dangerous situation.’[423](javascript:footNote('E900040/note423.html')) There is a curious



---

p.174



letter in the Irish Record Office which well shows how the fattest bishoprics were kept as a matter of course for Englishmen. The bishopric of Ossory had fallen vacant in August, 1730, and the Lords Justices of Ireland wrote from England to the Lord Lieutenant about the appointment to the see. ‘Though that bishopric,’ they remark, ‘lies in a fine country, yet as it is valued only from £1,000 to £1,200 per annum, we apprehend that no bishop in this kingdom will desire a translation thither.’ They therefore recommend that some Irishman should be appointed instead.[424](javascript:footNote('E900040/note424.html')) The whole administration was in fact corrupt to the core. The age, it is true, was a corrupt one, and England under Walpole was nearly as bad as Ireland under her Lord Lieutenants. But in the last half of the eighteenth century matters began to improve in England, whereas the Irish administration was as corrupt at the end of the century as at the beginning. In England various laws and institutions neutralised some of the evils resulting from the great influence of the Crown and ministers, but in Ireland there was no force strong enough to cope with the Executive. And the kind of corruption practised by the Irish Government fell very heavily upon the country. In England lucrative positions obtained by corrupt practices at least fell to Englishmen, but in Ireland such offices were rarely given to Irishmen. Irish Protestants in fact were shut out from all higher employments to nearly as great an extent as the Irish Catholics. England had lost sight of her old idea of fostering the Irish Protestant interest, and governed Ireland only with a view to the material interests of Englishmen. As Irish trade and commerce were restricted to suit the interests of English merchants, so Irish finances were manipulated in order to put as much as possible into English pockets. The administration of Ireland was conducted without the faintest regard for the well-being of her people; the sole



---

p.175



idea was to drain the resources of the country for the pecuniary profit of Englishmen. And it seems undoubtedly the case that the Irish establishments were out of all proportion to the resources or needs of the country. They were practically beyond the control of both the Irish and the British legislatures, and formed a great field of lucrative patronage altogether at the disposal of the English ministers. ‘As to Governments,’ wrote **Archbishop King**, ‘I have been told that their case is generally this. There is a salary allowed commonly for them to be paid out of the Treasury, and when anyone aimeth at one of them he applieth to some courtier, covenants to let him have the salary, and he is to live on what he can exact and rapery from the people.’[425](javascript:footNote('E900040/note425.html'))


The great evil of widespread absenteeism, which has been already mentioned, followed as a matter of course. During the first half of the eighteenth century the higher offices seem to have been generally in deputation, and matters only slightly improved later on. Until the Viceroyalty of **Lord Townshend** the Lord Lieutenants were always absent from Ireland for more than half and sometimes four-fifths of their term of office. They were always Englishmen, and although from the time of **Lord Townshend** they spent the larger part of their official term in Ireland, they continued to spend much time in England until well after the Union. The Chief Secretary and all the great officials were always Englishmen, and were often absent in England, and until the appointment of Fitzgibbon in 1789 every Chancellor was also an Englishman.[426](javascript:footNote('E900040/note426.html')) We have already seen how a host of civil and military officials and holders of sinecures and honorary posts of all kinds drew money from Ireland and rarely set foot in the country. This evil was very great all during the eighteenth century, and formed a just ground of



---

p.176



complaint. The Irish Parliament was continually trying to lessen the grievance by imposing a tax on the pensions, salaries, and profits of employments of all absentee officers and persons, but their efforts were generally rendered virtually useless by the interference of the king, who thought that this action of the Commons encroached on his prerogative.


The first attempt of the Irish Parliament to get back a little of the money of which the country was being drained was made in 1727. The second Money Bill of that year obliged all persons holding offices and employments in Ireland and residing in England to pay a tax of four shillings in the pound; but unfortunately a clause was added stating that the tax need not be paid by any person who produced a proper certificate to show that he was obliged to attend directly upon the king, the queen, or their royal children."[427](javascript:footNote('E900040/note427.html')) Naturally the tax was successfully evaded, for the absentees had merely to procure any place of honour about court and produce a certificate saying they were employed in the king's service.[428](javascript:footNote('E900040/note428.html')) Dorset, writing to the Lords Justices in 1730 concerning two pensions, each of £1,000, to be granted to Mr. Lawman and Herman Hobourgs, gives orders according to the king's directions, that ‘they shall not in respect of the said pensions be charged with the late tax of four shillings in the pound.’[429](javascript:footNote('E900040/note429.html')) As the king could exempt any person by his sign manual from the payment of the tax, it was little wonder that this first attempt of the Irish Commons towards an absentee tax should have produced little result. The highest amount yielded by the tax was £8,720 in the year ended Lady Day, 1730; but from then the yield rapidly decreased until in 1753, when the tax was discontinued, the whole amount produced was only £2,110.[430](javascript:footNote('E900040/note430.html'))


---

p.177




from 1753 to 1757 the finances of the country were in a comparatively prosperous condition, and in consequence there was no attempt to reimpose the absentee tax. But after 1757 the expenses of the war with France began to reduce Irish finances to a very bad state, while the pension list was now swelling rapidly. The money obtained by the new Act establishing tonnage and poundage was used for corrupt purposes instead of ‘for the better guarding and defending of the sea,’ as was laid down by the Act.[431](javascript:footNote('E900040/note431.html')) From 1757 to 1777 the civil list nearly doubled, the pension list nearly doubled, and the national debt increased to over £1,000,000. It was under these circumstances, when new funds were badly needed, that the Irish Parliament, in 1769, imposed a second absentee tax of four shillings in the pound on all salaries, pensions, and profits of employment of persons residing in England and drawing their money from Ireland. Previous attempts to reimpose the tax had been defeated through English influence, and now in 1770 strenuous efforts were made in England to do away with this new absentee tax. The tax would naturally fall on many of the leading members of the Rockingham section of the Opposition, and they resolved to resist it through their influence with the Ministry. Five of the leading Whig peers signed a remonstrance against the tax and sent it to **North**.[432](javascript:footNote('E900040/note432.html')) They were supported by **Burke**, who thought the measure unwise and tending to separate the interests of England and Ireland[433](javascript:footNote('E900040/note433.html')) Many people of large property joined the ranks of the Opposition, and in consequence the Viceroy determined to do his best to repeal the tax. Many of the Members in the Irish House of Commons disliked the tax because they feared it might lead to a depreciation in the value of land in Ireland. In spite of all efforts, however,



---

p.178



the tax does not seem to have been repealed until the following year, as receipts under this head are entered in the years 1769, 1770, and 1771 in the Vice-Treasurer's accounts. The largest amount obtained from the tax during these years was £16,699 in 1769, and the smallest amount £9,974 in 1771. This second absentee tax thus yielded considerably more than the first had done.


In 1773 the condition of Irish finances was very serious. It was estimated that the arrears upon the establishment by the following Christmas would amount to £300,000. Just at this time the King imposed the heavy pension of £3,000 on the Irish establishment for the Queen of Denmark. It was evident that further taxation was essential, and Harcourt, then Lord Lieutenant, proposed that the plan of an absentee tax should be revived, but that this time it should be only two shillings in the pound, and should only be imposed on the rents of absentee proprietors. The English Government agreed to accept the measure if it were passed in Ireland, on the condition that the hereditary revenue was relieved of some of the heavy burdens which had been thrown on it, and especially from the existing premium of the carriage of corn to Dublin. In 1774 the Act imposing the tax was passed, and at the same time the Irish Commons carried out their part of the bargain by passing a resolution that whenever the bounty on the inland carriage of corn exceeded £35,000 in the year, Parliament should impose fresh taxes to make good the excess.[434](javascript:footNote('E900040/note434.html')) This absentee tax was imposed for some years, and then dropped; but it was revived after 1782 by the Independent Parliament. Until 1792 this last tax yielded a fairly considerable sum, and seems to have been much less frequently evaded than the previous absentee taxes. In the year ended Lady Day, 1790, it yielded as much as £63,089, but in all the other years the amount raised varied from about £14,000 to about £15,000 per annum.




---

p.179


It was a great misfortune for Ireland during the eighteenth century that the Irish Parliament was so dependent on England. It was, in fact, simply an institution for registering the edicts of the English Privy Council. The system of government by a weak Parliament and powerful Ministers, with the whole force of patronage at their disposal, could have resulted in nothing but financial corruption and abuses. In England, where the House of Commons was really powerful, it was hard enough to resist the influence of the Crown and Ministers; in Ireland it was impossible. Very often, indeed, the Irish Commons made a good fight, and on a few occasions they managed to make themselves so tiresome that the Government thought it wiser policy to retire from their
position. But as a rule the direct efforts of the Irish Commons to thwart the Government were unsuccessful. Their attempt to dispose of the surpluses of the hereditary revenue in payment of the national debt without the King's consent failed completely; the King managed to assert his prerogative and established his own right as to the disposal of all surpluses.[435](javascript:footNote('E900040/note435.html')) As the Commons found they could not interfere directly as to the disposal of the hereditary revenue, they determined to encroach on it as much as possible and so leave the Crown more at the mercy of Parliament for its supplies; and in order to do this they began to use up the surplus of the whole revenue before it passed into the Treasury. In 1757 the finances of the country were comparatively prosperous, and the Commons managed to dispose of some of the surplus revenues in local improvements. Money was given towards the erection of the new buildings of Trinity College and for the improvement of internal navigation and roads; bounties were given to fisheries and agriculture, subsidies to the Dublin Society, the Protestant Charter Schools, and the county infirmaries. Although 



---

p.180



this assistance to public works and industries seems to have been prompted to some extent by political motives, it did great good in a country so backward in all kinds of industrial enterprise as was Ireland at that day. But the Commons did not content themselves with devising new forms of expenditure, thus restricting the amount of funds at the disposal of the Government; they even began to encroach upon the hereditary revenue itself. In 1754 they used a large part of the additional duties, formerly imposed in aid of the hereditary revenue, for the purpose of encouraging inland navigation, collieries, and manufactures.[436](javascript:footNote('E900040/note436.html')) Later on, in 1757, Parliament threw the whole amount of the bounty on the inland carriage of corn to Dublin on the hereditary revenue.[437](javascript:footNote('E900040/note437.html')) This was done by seizing the revenue when on its way into the Treasury and making the bounty payable by the collector of the Port of Dublin before he had accounted for his receipts*.* The bounty was a first charge on the revenue and in 1773 amounted to £50,000 a year.[438](javascript:footNote('E900040/note438.html')) The expense of collecting and managing the taxes was also placed on the hereditary revenue, and in these ways the Irish Commons managed to get some sort of indirect control over the finances of the country. They succeeded in paring down the hereditary revenue to such an extent that Government became more and more dependent on them for its supplies, and all this without actually touching the King's prerogative. As the Irish Parliament could not interfere directly in all financial matters, like the British House of Commons, it had to content itself with interfering indirectly whenever it seemed possible to obtain an advantage, and it is certain that many of the terrible abuses of expenditure by the Government would have been very much more widespread had it not been for this policy of the Irish Commons. It is hardly necessary to observe that the



---

p.181



Members of the Irish House of Commons were not always impelled merely by patriotism; they were animated by a sense of the humiliation of their position and by a growing resentment at their lack of financial control. Later on, as the direct result of English misrule, the feeling of patriotism was to come, but for a considerable part of the eighteenth century the Irish Parliament worked more for its own power than in the interests of its country. Still, this did not prevent the Commons from doing good work as regards the attainment of a modified and indirect control over finance.


Theoretically indeed the greater part of the revenues of Ireland still remained beyond the control of Parliament, but in practice the Irish Commons managed by means of their policy of encroaching on the hereditary revenue to obtain more of the power of the purse. It must, however, be regretted that in their zeal to circumvent Government, they often lost sight of the fact that it was in their power to effect one financial reform of great urgency, namely, an amendment in the system of collecting and managing the revenue. There was gross fraud and peculation as regards this matter, and the cost of collection and management was very much heavier in Ireland than in England. In 1778, for example, the gross revenue of Great Britain was collected for 7 1/2 *per cent*, while that of Ireland cost no less than 17 1/3 *per cent*.[439](javascript:footNote('E900040/note439.html')) There is some suspicion that the Irish Parliament did not desire reform in this matter because it knew that any improvement would simply set free a fresh sum of money to be used in corruption by the Government. If this were the case, the Irish Parliament was certainly short-sighted in its methods of controlling finance; but after all, the peculiarly weak position it occupied and the great difficulties with which it was confronted must be remembered. In their desperate effort to maintain some 



---

p.182



sort of independence the Irish Commons could hardly be expected to have pursued a really statesman-like policy. Towards the last quarter of the eighteenth century Irish finances progressed from bad to worse. The rupture with the American colonies and the following war dealt a great blow at the limited trade of the country. The pension list for 1778 exceeded the entire civil list for 1757, while part of the money due to military contingencies was not expended upon military purposes at all, but was used as a kind of inferior pension list for persons of both sexes.[440](javascript:footNote('E900040/note440.html')) The financial and administrative grievances of the Irish people combined with the severe restrictions placed on their trade and commerce had in 1779 brought Ireland into such an appalling condition that many sensible people in England at last began to realise that if the country were not to remain a permanent burden on England something must be done to improve Irish resources. The anonymous author of a Letter to the People of Ireland, written in 1779, gives in a few words the causes which had brought Ireland into this state of bankruptcy:—


‘It is true that a pension list is a cause, a prodigal succession of administrations is a cause, and an exorbitant military establishment is a cause; but the fundamental cause of our distress is that, being burthened by a pension list and drained by an army, we are disabled by restrictions: the internal system of government is one grievance, the external policy of England is a greater grievance.’[441](javascript:footNote('E900040/note441.html')) The peculiar financial policy of England towards Ireland during the eighteenth century was due to very much the same general theoretical ideas as those which influenced her commercial policy. The interests of England were on all occasions regarded as paramount; those of Ireland were of no account whatsoever. Only, in the financial relations between the two countries the special and practical



---

p.183



motives which influenced England were more sordid and petty than those which induced her to restrict Irish trade and industry. There was, of course, the broad idea at work that a dependency should be administered solely to the advantage of the Mother Country, and at the same time peculiar political conditions put Ireland altogether at the mercy of England. But in the matter of trade England occasionally showed that she was not altogether unwilling to foster the Protestant interest in such directions as did not interfere with English trade. It was otherwise in the matter of finance and administration. The interests of the Irish Protestants were put on one side almost as completely as the interests of the Irish Catholics, which no one expected to be considered.[442](javascript:footNote('E900040/note442.html')) And it is quite idle to say vaguely, as is so often done, that Ireland was taxed lightly during the eighteenth century. The financial grievances of Ireland were not connected with the amount of money raised in taxes; they were connected with the way in which this money was expended. We have, in fact, to look beyond the actual money raised, and into the whole system of Irish administration and expenditure, if we wish to determine whether the Irish people were lightly or heavily burdened during this period. And in any case we are forced to come to the conclusion that the greater part of the Irish revenues were directly expended in the interests of England and individual Englishmen.


The whole administrative and financial policy of England was more short-sighted than her commercial policy, and at the same time it had not the same important reasons to justify it. In consequence it was resented bitterly by the Irish Protestant gentry. The members



---

p.184



of this class were not all directly touched by the restrictions placed on Irish trade and commerce; but they were all touched by the fact that they could not get profitable employments for themselves or their sons, while they objected strongly to seeing the taxes they paid going into the pockets of kings' favourites and disreputable persons of both sexes. It was this misguided policy on the part of England that did so much to foster the new national spirit among the Irish Protestant gentry — a spirit voiced for the first time by **Molyneux**, taken up in his narrow and satirical way by **Swift**, and continued by **Lucas**,[443](javascript:footNote('E900040/note443.html')) until in the last quarter of the eighteenth century, patriotic Protestants were nearly as completely alienated from England as were their Catholic fellow-subjects. Through community of suffering, Irish Protestants and Catholics began to be drawn more closely together. Towards the end of the century we see a disinclination on the part of the Protestants to enforce the penal laws, and it must not be forgotten that it was an Irish Protestant Parliament which took the first steps towards alleviating the condition of the Catholics. The sentiment of Irish nationality which proved itself strong enough to sink the religious feud of centuries and to extort one concession after another from England was not born, as in other countries, of common traditions and a common history, but was the direct result of English policy. For one short period the whole Irish people, regardless of race and religion, were to unite against the oppression and spoliation of England.




---

p.185





| Year ended | Civil Pensions £ | French Pensions £ | Military Pensions £ | Total Pension Charge £ | Total Revenue £ | Percentage of Pension to Total Revenue |
| --- | --- | --- | --- | --- | --- | --- |
| 25th March, 1678 | 11,743 | None | None entered | 11,743 | 300,000 | 3.91 |
| 24th June, *1689* | 9,705 | None | None entered | 9,705 | — | — |
| December 1700 | 4,709 | 28,717 | 1.147 | 34,573 | 505,149 | 6.85 |
| December 1705 | 8,226 | 20,952 | 2,540 | 31,718 | 335,505 | 9.45 |
| December 1715 | 21,921 | 13,366 | 7,462 | 42,749 | 342,222 | 12.49 |
| December 1725 | 28,762 | 5,395 | 3,291 | 37,448 | 636,461 | 5.88 |
| December 1730 | 37,786 | 16,613 | 2,252 | 56,651 | 671,394 | 8.43 |
| 25th March 1734 | 35,569 | 8,394 | 2,079 | 46,042 | 485,672 | 9.49 |
| 25th March 1738 | 39,063 | 9,365 | 1,747 | 50,175 | 560,909 | 8.94 |
| 25th March 1741 | 41,229 | None entered | 1,747 | 42,976 | 521,352 | 8.24 |
| 25th March 1745 | 43,234 | 4,158 | 1,747 | 49,139 | 583,090 | 8.42 |
| 25th March 1748 | 47,573 | 3,419 | 1,304 | 52,296 | 653,482 | 8.00 |
| 25th March 1751 | 46,349 | 1,639 | 532 | 48,520 | 1,075,407 | 4.51 |
| 25th March 1752 | 46,960 | 1,468 | 532 | 48,960 | 894,206 | 5.47 |
| 25th March 1753 | 47,269 | 1,319 | 532 | 49,120 | 1,013,126 | 4.84 |
| 25th March 1754 | 49,508 | 1,293 | 832 | 51,633 | 1,091,350 | 4.73 |
| 25th March 1755 | 39,304 | 1,356 | 919 | 41,579 | 1,086,132 | 3.82 |
| 25th March 1756 | 42,243 | None entered | 1,719 | 43,962 | 1,316,970 | 3.33 |
| 25th March 1757 | 48,903 | 1,043 | 1,998 | 51,944 | 1,060,574 | 4.89 |
| 25th March 1758 | 53,213 | None entered | 2,180 | 55,393 | 1,133,679 | 4.88 |
| 25th March 1759 | 59,496 | 920 | 2,080 | 62,496 | 828,758 | 7.54 |
| 25th March 1760 | 54,133 | 853 | 2,121 | 57,107 | 849,756 | 6.72 |
| 25th March 1761 | 59,383 | None entered | 2,215 | 61,598 | 1,106,540 | 5.56 |
| p.186 |
| 25th March 1762 | 67,747 | 1,276 | 3,215 | 72,238 | 894,539 | 8.07 |
| 25th March 1763 | 70,277 | 862 | 2,193 | 73,332 | 1,269,626 | 5.77 |
| 25th March 1764 | 71,482 | 902 | 3,130 | 75,514 | 1,569,584 | 4.81 |
| 25th March 1765 | 82,252 | 1,002 | 3,193 | 86,447 | 1,722,624 | 5.01 |
| 25th March 1766 | 81,739 | 666 | 2,876 | 85,281 | 1,911,371 | 4.46 |
| 25th March 1767 | 79,181 | 911 | 3,533 | 83,625 | 1,786,450 | 4,68 |
| 25th March 1768 | 84,982 | 811 | 3,686 | 89,479 | 1,609,239 | 5.56 |
| 25th March 1769 | 83,563 | 795 | 3,592 | 87,950 | 1,789,403 | 4.95 |
| 25th March 1770 | 85,671 | 717 | 4,169 | 90,557 | 1,227,331 | 7.37 |
| 25th March 1771 | 80,200 | None entered | 4,085 | 84,285 | 1,566,837 | 5.37 |
| 25th March 1772 | 83,665 | 683 | 5,222 | 89,570 | 1,071,662 | 8.35 |
| 25th March 1773 | 82,606 | None entered | 6,472 | 89,078 | 1,242,813 | 7.16 |
| 25th March 1775 | 86,435 | 683 | 5,532 | 92,650 | 1,540,089 | 6.01 |
| 25th March 1777 | 92,239 | 614 | 6,284 | 99,137 | 1,562,702 | 6.34 |
| 25th March 1779 | 90,131 | 718 | 6,180 | 97,029 | 1,589,246 | 6.09 |
| 25th March 1781 | 84,793 | 616 | 6,129 | 91,538 | 1,783,574 | 5.13 |
| 25th March 1783 | 92,154 | 538 | 6,068 | 98,760 | 1,138,293 | 8.67 |
| 25th March 1785 | 92,308 | 531 | 4,907 | 97,746 | 1,279,503 | 7.63 |
| 25th March 1787 | 98,598 | None entered | 6,471 | 105,069 | 1,409,659 | 7.45 |
| 25th March 1789 | 105,739 | 514 | 6,456 | 112,709 | 1,576,538 | 7.14 |
| 25th March 1790 | 102,860 | 350 | 6,772 | 109,982 | 1,583,226 | 6.94 |
| 25th March 1791 | 103,351 | 259 | 7,720 | 111,330 | 1,638,883 | 6.79 |
| 25th March 1792 | 109,788 | 459 | None entered | 110,247 | 1,687,038 | 7.53 |
| 25th March 1793 | 115,344 | 459 | 8,778 | 124,581 | 1,626,941 | 7.67 |
| 25th March 1795 | 125,892 | None entered | None entered | 125,892 | 1,907,740 | 6.59 |
| 25th March 1797 | 116,527 | 259 | 5,591 | 122,377 | 1,934,911 | 6.32 |
| 25th March 1799 | 108,589 | 259 | None entered | 108,848 | 2,524,668 | 4.30 |








---

p.187


[444](javascript:footNote('E900040/note444.html'))The American War and Free Trade
-------------------------------


Effect of American War upon Ireland — Poverty of the Country during the Years preceding the War — Commercial and Financial Distress produced by the War — Early Efforts in Ireland to obtain an Enlargement of Trade — Proposals of the British Parliament in 1778 in favour of Irish Trade — Indignation in Great Britain and substantial Modification of the Proposals — Act of 1778 — Disappointment in Ireland — Beginning of violent Agitation for Free Trade aggravated by the existing Distress — The Volunteer Movement — Non-importation Associations — Position of the Irish Government — Debates in the British Parliament in 1779 on the Subject of the Repeal of the Commercial Restrictions — Reports ordered to be drawn up concerning the State of Ireland — Substance of these Reports — **Grattan** and the Patriotic Party in the Irish Parliament — Irish Commons' Address to the King on the Necessity of Free Trade — Excitement and Disturbances in Dublin
— Enthusiastic Debate in the Irish Commons — Government Convinced of the Necessity of yielding — Hasty Repeal of the principal Commercial Restrictions by the Acts of 20 Geo. III. cc. 10 & 18 — Enthusiasm in Ireland — No Finality in the Concessions.
We have seen how during the last half of the eighteenth century a sentiment of Irish nationality had gradually been awakened. This sentiment had shown itself in the struggle of the Irish Commons to assert their political independence and financial control. Very slowly a patriotic party had been growing up in the Irish Parliament, and from 1775 **Henry Grattan** took the leadership of this party and led the whole nation in its fight for a free trade and a free Parliament. The agitation for free trade began simultaneously with the outbreak of the American War. At first it was confined to the Irish



---

p.188




Protestants, but the Catholics soon threw in their lot with their fellow-countrymen, and in 1779 England found herself confronted for the first time in her history by a united Ireland. The American War of Independence put the idea into the minds of Irishmen that the power of England might be successfully defied, and they determined to take advantage of the troubles in America to force England to remove those trade restrictions which had existed for over a century. The most enthusiastic of all classes in Ireland in the new national struggle were the Presbyterians from Ulster, the men who had always so bitterly resented English interference. The emigration from the north of Ireland to America which had been going on all through the century had formed many links between the American colonies and Ulster. Irish Protestants had often friends and relations fighting on the side of the colonists, and so it was but natural that a certain amount of sympathy should have been felt for the rebels. New feelings of liberty which had hitherto lain more or less dormant were aroused in Ireland as the war proceeded, and the germs were sown of those ideas which afterwards resulted in the independent Parliament of 1782.


But this agitation for free trade, intensified as it was by the actual effects of the American war on the commerce and finance of Ireland, rested on a solid practical basis. In 1778 and 1779 the distress in Ireland was so universal and the poverty of nearly all classes so appalling, that Great Britain was almost confronted with the alternative of removing the restrictions on Irish trade or herself supporting the Irish civil and military establishments. Many causes had been at work bringing about this state of things. From 1769 the poverty of Ireland had been increasing, the revenue had been declining, and the country had been getting into debt.[445](javascript:footNote('E900040/note445.html')) The augmentation



---

p.189




of the home military establishment was a cause of distress,[446](javascript:footNote('E900040/note446.html')) and side by side with the decreasing revenue the pension list had been swelling. In 1770 there was so much commercial distress, due to an embargo imposed by the English Privy Council on the exportation of provisions from Ireland, that the Lord Lieutenant suggested that a certain amount of relief should be given to Irish trade to tide over the present difficulties. He proposed that Ireland might be allowed to export to Spain and Portugal a kind of coarse woollen cloth made frequently in Ireland, but never manufactured in Great Britain; that she might be allowed to export soap and candles to Great Britain on payment of duties equal to the excise which those articles paid in that country; that the very heavy duty imposed on checked linens sent from Ireland to Great Britain might be abolished, and that the same encouragement might be given to the manufacture of printed linens in Ireland as in Great Britain.[447](javascript:footNote('E900040/note447.html')) But these suggestions proved futile and nothing further was attempted in this way until six years later, when the distress caused by the American war made some sort of relief imperative.


The American non-importation agreement of 1775, immediately followed by the war, closed the chief market for Irish linens, and in consequence the demand for that article fell so low that during the next year a number of bankruptcies took place.[448](javascript:footNote('E900040/note448.html')) Just at this time the embargoes laid by England on Irish ports led to a stoppage of the provision trade. The linen trade and the provision trade were practically the only trades possessed by Ireland, and the simultaneous check given to both naturally produced universal distress among the agricultural, manufacturing, and trading classes. By the



---

p.190




Order in Council of January 21st no provisions of any kind could be exported from any Irish port, except beef, pork, butter, and bacon to Great Britain, and from thence to any part of the British dominions with the exception of the revolted colonies, and also to any ships or vessels in the King's service, provided that the owners of the provisions gave securities as to the proper destination of their goods.[449](javascript:footNote('E900040/note449.html')) In the following October this embargo was re-enacted, as there had been some evasion in the matter, and it was further ordered that the provision ships sailing to Great Britain should be under convoy.[450](javascript:footNote('E900040/note450.html')) These embargoes of 1776 produced great misery in the country. Every class was affected—the peasantry and farmers, the provision merchants and the landed gentry. Numbers of Limerick merchants were ruined, for as they had to send all their provisions in the first instance to the ports of Great Britain the markets there became overstocked. At first the provisions were sold at prices ruinous to the Irish merchants; later on they could not be sold at all in spite of the daily advertisement of public auctions. In November the inhabitants of Cork sent up a petition to the Lord Lieutenant representing that the existing embargo was particularly injurious to the southern parts of the kingdom, and praying that they might be allowed to export their provisions to neutral ports and also to send them to Great Britain without convoy.[451](javascript:footNote('E900040/note451.html')) It was often very difficult to procure a convoy, and in consequence ships laden with provisions for Great Britain had sometimes to wait weeks or months before they could start. But the English Ministry replied that the exigencies of public affairs were too great to allow of the desired relief being given; and in order partly to compensate for this refusal to modify the embargoes a few small favours were conferred



---

p.191




upon Ireland before the end of the year. Bounties were granted on Irish as well as British ships employed in the Newfoundland fisheries,[452](javascript:footNote('E900040/note452.html')) Ireland was permitted to furnish clothing to her troops when stationed out of Ireland,[453](javascript:footNote('E900040/note453.html')) the exportation of rape seed from Ireland to Great Britain was allowed under certain limitations,[454](javascript:footNote('E900040/note454.html')) and a small bounty was granted by Great Britain on the importation of flax into Ireland.[455](javascript:footNote('E900040/note455.html')) The permission to furnish her troops with clothing was something of a boon to Ireland, and she at once availed herself of it; but the distress of the time was too widespread for any small measure to be of much use, and from this moment the open agitation for a free trade began.


During the next year matters progressed from bad to worse, and fresh petitions for relief flowed up from southern Ireland. The merchants of Cork sent up two petitions, one to the Irish House of Commons, the other to the Lord Lieutenant, praying for a removal or suspension of the embargo. They stated that the extensive provision trade which they had carried on for years with Spain, Portugal, and Holland, had not only ceased for the time being, but was in danger of being lost permanently, for Russia, Sweden, and Denmark were now supplying those countries with provisions, and thus ‘new enemies to our commerce are raised and our own commodities are rendered useless and unprofitable.’ Quantities of small beef not suited for the use of Government or of the sugar colonies were produced in the country. Hitherto this beef had been sent to foreign countries, but now it could not be exported anywhere and remained on the merchants' hands. At the same time there were very much larger quantities of salted beef and pork in Cork and its neighbourhood than would possibly be demanded for the needs of the British fleet and armies during the remainder of the



---

p.192




season.[456](javascript:footNote('E900040/note456.html')) All over Ireland landlords were apprehensive lest they should not be able to get for their cattle the prices they had paid for them when laid in to fatten. Indeed at the great fairs, where large numbers of fat cattle used to be sold, the sales during the year had been so inconsiderable that the country gentlemen found great difficulty in obtaining their rents from the graziers who occupied their lands.[457](javascript:footNote('E900040/note457.html')) The Lord Lieutenant proposed, in order to modify this existing distress, either that the embargo should be removed for a short time so as to allow the present large stock of provisions to be cleared off, or that it should be limited to provisions of a superior quality in order that the inferior kinds which were not taken by British contractors, but which the French were always willing to buy, might be exported. **Buckingham** thought that the adoption of either of these alternatives might tend to quiet the minds of the people, and would be a boon to the landed as well as to the commercial interests of the country.[458](javascript:footNote('E900040/note458.html')) But Weymouth wrote back that Government could do nothing in the matter,[459](javascript:footNote('E900040/note459.html')) and during the next year, 1778, the embargoes were more severely enforced and the distress among all classes increased.


By an Order in Council dated 29th May, 1778, it was commanded that no provisions should be exported from Ireland even when laden on British ships and going to Great Britain until further orders, and at the same time a general embargo was placed on all ships in Irish ports. The whole body of Irish graziers was now at the mercy of a few speculators at Cork, and for nearly a month there was a total stoppage in the provision trade. Fortunately, on the 20th of June, an Order in Council was transmitted to **Buckingham** allowing provisions to be exported in ships sailing under convoy to the British dominions and fleet, 



---

p.193




but not to Great Britain.[460](javascript:footNote('E900040/note460.html')) The general embargo was also taken off all vessels coasting from port to port in Ireland and on those employed in the linen trade with Great Britain.[461](javascript:footNote('E900040/note461.html')) In the following August ships laden with spun worsted or yarn were allowed to sail from Cork to Great Britain,[462](javascript:footNote('E900040/note462.html')) and a little later butter was permitted to be exported from Ireland to Great Britain.[463](javascript:footNote('E900040/note463.html')) It was not, however, until the end of the year that the general embargo on all ships in Irish ports was taken off, while the general exportation of provisions to foreign countries was still prohibited, and even to Great Britain with the exception of butter. The refusal to allow Irish merchants to export their provisions to England was, of course, done in the interests of British contractors and merchants, and was extremely arbitrary and unjust. It was fortunate for the Irish that they were, after a short time, allowed to export their butter to Great Britain, but there were quantities of coarse butter in Ireland unfit for the English markets and which had formerly been shipped to Germany, Holland, and Portugal. All this butter had now to remain on the farmers' hands.[464](javascript:footNote('E900040/note464.html')) The financial consequences of this commercial distress were soon apparent. In 1778 the Irish Government was nearly bankrupt and new troops were being raised which had to be provided for in some way out of the Irish revenue. In April the Lord Lieutenant wrote to Weymouth that for some time no subscriptions had been received by Government on account of a loan which had been started with a view of providing funds for the payment of the troops, that only £90 could be got for each share of £100, and that the subscriptions to the new Tontine only amounted to £10,000. In order, therefore,



---

p.194




to provide for the military services, Government had been forced not only to stop all payments from the Treasury that could possibly be postponed, but also to borrow £20,000 at interest from the principal Dublin bankers. But this sum, **Buckingham** wrote, had been exhausted almost directly, and as there was ‘a general distress for money throughout all ranks in the city, no balance in the Treasury and scarcely any in the hands of the several collectors, and the receipt of His Majesty's revenue having fallen lower than has been known for many years, there neither is nor can I expect there will be a fund arising or that can be created in this kingdom to answer these large demands which, if not discharged, will put a stop to our military operations.’[465](javascript:footNote('E900040/note465.html')) The financial situation of the Government was, in fact, hopeless, and **Buckingham** as a last resource asked the British Ministry for a loan of £50,000 on the credit of the Tontine.[466](javascript:footNote('E900040/note466.html')) On May 16th, having received no answer to his solicitations for financial help, **Buckingham** sent over his Deputy Vice-Treasurer to England with a letter to **Lord North** asking him in what way and on what terms money could be borrowed in England for the use of the Irish Government.[467](javascript:footNote('E900040/note467.html')) The Dublin bankers to whom he had made an application for a further loan of £20,000 had answered that the public distress put it out of their power to give any financial assistance to Government, and therefore, as the Treasury was absolutely empty, the movement of the troops had to be stopped for the time being.[468](javascript:footNote('E900040/note468.html')) At last, at the beginning of June, the Bank of England agreed to advance 50,000 guineas for six months to the Irish Government on the security of debentures for the Government loan in Ireland,[469](javascript:footNote('E900040/note469.html')) and at the same time the rate of



---

p.195




interest on the Irish Tontine was raised from 63 *per cent* to 74 *per cent* in the hopes of inducing subscriptions.


It was little wonder that under such circumstances men's thoughts began to turn towards a practical remedy for the prevailing evils—a remedy which might check the source from which they sprang, and not merely tide them over for the time being by means of temporary assistance. As early as the February of 1778 **Grattan** made his first motion in the Irish Commons for an address to the King on the state of the nation. He stated at length the financial situation, and how during the last twenty years the whole charge of the civil list and also of the pension list had nearly doubled. He complained of the number of additional salaries in the nature of pensions annexed to lesser offices, mostly sinecures, or at any rate quite insignificant in their nature, and the growing practice of annexing large salaries to obsolete offices. This motion of **Grattan** produced a long debate, but it was finally lost by 143 to 66 votes, as the Commons thought that the matter ought to be proceeded with more gradually. But shortly after, on March 20th, the Lord Lieutenant wrote to Weymouth that in his opinion the present would be a proper time for relieving Irish trade, for an enlargement of commerce had now become an absolute necessity if the country were to support itself at all.[470](javascript:footNote('E900040/note470.html')) The inhabitants of the King's County sent up a spirited address to the King, in which they lamented the restrictions laid on the commerce of the kingdom, and they expressed the hope that at the conclusion of the war some means might be found to settle trade and commerce on a plan of mutual advantage to Great Britain and Ireland.[471](javascript:footNote('E900040/note471.html')) But already the matter was being taken up in the British Parliament by the Opposition. On April 2nd Lord Nugent moved in the Commons that the House should resolve itself into a committee to 


---

p.196




take into consideration the several Acts of Parliament relating to the trade and commerce of Ireland. The motion was supported by **Burke**, and was agreed to with little opposition.[472](javascript:footNote('E900040/note472.html')) Accordingly on April 7th the House went into committee, and the next day the report was sent up. It was proposed that all goods might be exported from Ireland to the British plantations in British ships, with the exception of wool and woollen manufactures; that all goods of the growth and manufacture of the British settlements and plantations should be exported direct to Ireland, tobacco only excepted; that glass might be exported from Ireland to any place but Great Britain; that the prohibitory duty imposed in Great Britain on the importation of Irish cotton yarn should be repealed; and finally that Irish sail cloth and cordage might be admitted into Great Britain duty free.[473](javascript:footNote('E900040/note473.html')) But no sooner had these proposals been read in the House than storms of indignation broke out all over the country, and petitions against the proposed Bill flowed in from all the large manufacturing towns in England and Scotland. There was great opposition to the admission of Irish sail cloth and cordage into Great Britain. The burgesses of Wigan, in the County Palatine of Lancaster, feared that they might not be able to obtain a sufficient supply of cheap Irish yarn; the inhabitants of Preston, Stockport, Manchester, and other places in Lancashire, as well as the people of many towns and villages in the counties of Dorset and Somerset, all represented the injury that would result to their linen trade if any new advantage were given to Ireland in the manufacture.[474](javascript:footNote('E900040/note474.html')) The makers of glass in the neighbourhood of Stourbridge and Dudley, in Worcester and Stafford, set forth how their trade was charged with heavy duties laid on the raw material, the drawback given



---

p.197




on goods exported not counterbalancing such charges, and gave as their opinion that if the Act forbidding the exportation of Irish glass were repealed, the Irish would be able to undersell them in foreign markets.[475](javascript:footNote('E900040/note475.html')) Other towns, again, petitioned against the direct trade between Ireland and the plantations. The manufacturers of brass and iron in the borough of Walsall thought that if such a free trade were allowed, it would deprive ‘great numbers of manufacturers in this kingdom of the means of maintaining themselves and numerous families, or otherwise cause such emigrations of manufacturers from this country to Ireland   
[*...*]  
 as will enable that kingdom in a few years to rival the manufacturers of England.’[476](javascript:footNote('E900040/note476.html')) The makers of gloves in Worcester also apprehended the ruin of their industry if the Irish were allowed to export gloves direct to the colonies.[477](javascript:footNote('E900040/note477.html')) The tallow-chandlers and soap-boilers of Liverpool stated that their export trade to the West Indies would be ruined if the Irish were permitted to compete with them there.[478](javascript:footNote('E900040/note478.html')) Many gentlemen and traders in the County Palatine of Lancaster petitioned against the resolutions as ‘detrimental to the revenue, commercial interests, and navigation of Great Britain.’ The Merchant Adventurers of Bristol petitioned against all the resolutions without exception, saying that ‘a torrent of mischiefs unthought of and unforeseen’ would be poured in upon the kingdom if they were passed.[479](javascript:footNote('E900040/note479.html')) In all these cases the old arguments about the cheapness of living and labour in Ireland and the lowness of the taxes were brought forward, and the old fears that had existed at the end of the previous century about successful Irish competition again came to the front. It was insisted over and over again that if the proposed relief were given to Irish trade, English workmen would be thrown out of employment, and the capital of English manufacturers would be 



---

p.198



 
rendered useless because English goods would certainly be undersold everywhere by Irish goods. The petition sent up from Glasgow against the resolutions was very representative of these beliefs and fears.[480](javascript:footNote('E900040/note480.html')) The petitioners insisted that they wished well to their Irish fellow-subjects, but they could not go so far as to agree to be reduced from an affluent to an indigent state. If the proposed Bill were passed, the natural advantages of Ireland were such as to establish there many of those manufactures by means of which Great Britain had become rich. ‘By the loss of those manufactures, and the consequent decrease of our population, not only will the landed interest suffer exceedingly, but the national reputation must also sink from the inability of the remaining people to pay those taxes which are so essentially necessary for the support of Government.’ They further pointed out that the commercial privileges of Great Britain ought only to be extended to those parts of the Empire ‘where the people pay taxes in proportion to those levied upon the inhabitants of Great Britain.’ They therefore prayed not only that the present Bill should not become law, but that ‘no indulgences which may be detrimental to the commerce and manufacture of Great Britain may be allowed, until by bearing their proportionate share of the national expense, the people of Ireland shall become in justice and sound policy entitled to an unlimited freedom in commerce and manufactures.’


It was thus seen that every town in England and Scotland was touched, or thought it was touched, by any alteration in the commercial relations between Great Britain and Ireland.[481](javascript:footNote('E900040/note481.html')) The fears of the manufacturing and trading interests were too much for the British Parliament, and in consequence **North** reduced the proposed measures to an attenuated form. Vessels built in Ireland were henceforth to be regarded as British built, 


---

p.199




and to receive the bounties given in the Newfoundland and South Sea fisheries. Permission was given to Ireland to export several of the enumerated articles direct to the plantations, but woollens, cottons, glass, hops, hats, coal, and gunpowder were excepted absolutely, and also iron and iron wares, until the Irish Parliament should have imposed certain prescribed duties on their exportation. At the same time, Ireland was forbidden to import any goods direct from the plantations. Irish cotton spun yarn, however, was allowed to be imported into Great Britain duty free, and a small encouragement was given to the cultivation of tobacco and hemp in Ireland. But it was laid down in this Act that all manufactures allowed to be exported from Ireland should be liable to the same duties and drawbacks as those placed upon similar articles of British make on their exportation from Great Britain.[482](javascript:footNote('E900040/note482.html')) But in Ireland expectations had risen too high for this Bill of 1778 to have a really salutary effect. Resentment was felt at the unreasoning prejudice shown by the British manufacturing interest, and from this time the agitation of the Irish people for a free trade began to assume a violent form. The Irish Protestants now realised that the matter lay with them; they determined to take advantage of the difficulties of Great Britain, and to press energetically for relief at a time when it would be almost dangerous for England to refuse it.


Increased commercial distress aggravated the situation. Nothing short of an absolute freedom of trade could have remedied this state of things, and even then the beneficial result would have been slow. But the relief measures of 1778 were absurdly insignificant under the circumstances, and although the Lord Lieutenant wrote that he was relieved from ‘the most alarming apprehensions of tumult’ by the passing of the Bill, this effect was short-lived, and in a few months the Irish Government was to feel 


---

p.200




itself powerless in face of a growing popular organisation in favour of unrestricted trade. During the months of June and July in this year numerous petitions for relief were sent up from artisans and traders in different parts of the country to the Irish House of Commons. The distress was especially acute in Dublin. The woollen drapers and the master clothiers of the city pointed out the distressed state of their industry and the want of employment of many thousands of artisans, and they suggested that the people of Ireland should be encouraged to consume only their own manufactures.[483](javascript:footNote('E900040/note483.html')) The petitions from the journeymen linen and cotton weavers show the decayed state of the most flourishing industry possessed by Ireland. There were 757 linen and cotton looms lying idle[484](javascript:footNote('E900040/note484.html')), while as regards those workmen who were employed, many would soon be out of work, and were working now only at odd jobs; there were also quantities of goods on hand which could not be sold.[485](javascript:footNote('E900040/note485.html')) Want of funds made it impossible for Parliament to grant any substantial relief, and indeed the British Government was soon forced to take upon itself the expense of supporting the Irish regiments then fighting in America.[486](javascript:footNote('E900040/note486.html')) This gave relief to the Irish Government, but it could produce little effect upon the country. Matters proceeded from bad to worse, and in 1779 the crisis came.


As the American War had proceeded Ireland had gradually been denuded of troops. The country was left almost defenceless, and early in 1779 volunteer corps began to be formed all over Ireland for purposes of defence against possible invasion. In April, 1778, a Bill had been passed and sanctioned in Council for establishing an Irish militia, as the condition of the northern counties appeared dangerous to Government.[487](javascript:footNote('E900040/note487.html')) But want of funds had prevented the provisions of the Bill from being carried into



---

p.201




effect, and as Government could not defend the country the people had to do so themselves. In the May of 1779 news came that the French meditated an attack at some point on the northern coast. The inhabitants of Belfast and Carrickfergus applied for assistance to Government, but as only sixty troopers could be sent to them, they formed themselves into three armed companies.[488](javascript:footNote('E900040/note488.html')) This volunteer movement spread rapidly over the whole of Ulster, and the example set by Ulster was quickly followed by the three other provinces. Government gave no encouragement to the movement, but it was not possible to offer any opposition in the existing state of public affairs, when at any moment the assistance of every individual towards the defence of the State might be of supreme importance.[489](javascript:footNote('E900040/note489.html')) This was **Buckingham**'s point of view, and he wrote to Weymouth, who seemed to dislike his attitude, that without the present volunteer force ‘the camp could not have been formed, or the interior country must have been abandoned to riots and confusion, and many parts of the coast left defenceless.’[490](javascript:footNote('E900040/note490.html')) In May the numbers of the volunteers were 8,000, but by the end of the year they actually numbered 40,000. At first all were not armed, as **Buckingham** refused to give up the militia arms; but as time went on and the numbers of the volunteers increased, the Lord Lieutenant found himself forced by circumstances to distribute arms to these corps. The volunteers were at this time all loyal in the extreme, and declared themselves willing to shed their last drop of blood in defence of their King and country. Their loyalty placed **Buckingham** in an awkward position. He could hardly refuse the offers of military service which flowed in from large bodies of gentry in all parts of the kingdom, and yet once the volunteer corps had been formed, Government, in spite of their loyalty, found itself 



---

p.202



in a dangerous situation. With 40,000 armed men in the country, all enthusiastically loyal, but all determined to obtain free trade, the position of Government was bound to become weaker and weaker.


But side by side with the formation of these volunteer corps another kind of volunteer association had been establishing itself all over Ireland. These were the famous non-importation leagues. They began early in 1779, and were the direct result of the failure of **Lord North**'s proposals of the preceding year. Agreements not to import English goods were not without precedent. In the sessions of 1703, 1705, and 1707 the Irish Commons resolved that it would greatly benefit the kingdom if the people used none other but the manufactures of their country, and they had agreed to set an example themselves in this way.[491](javascript:footNote('E900040/note491.html')) But these and other earlier agreements had been *short-lived*, and had been confined to certain parts of Ireland. It was only now that the Irish people showed themselves capable of concerted action in pursuit of a common object, notwithstanding the material injury involved. They particularly wished to shut out those British manufactures which had been the cause of the ruin of their own industries. They were successful in their aims because their agreements took place at a time when they could succeed, when the entire nation was stirred up by great ambitions and so was capable of a united self-sacrifice. The movement was materially assisted by the Irish press and by the leaders of the Opposition in Parliament. Everywhere resolutions sanctioning the principle of the non-importation leagues were drawn up by such men as **Grattan**, **Flood**, **Charlemont**, **Farnham**, and **Newenham**. Galway was the first town to actually adopt a non-importation agreement, but the first large meeting on the matter was held in Dublin on April 26th, when it was unanimously resolved that, owing



---

p.203




to the present stagnation of trade and general emigration, and the total failure of all petitions to the Crown, ‘we will not, directly or indirectly, import or use any goods or wares, the product or manufacture of Great Britain, which can be produced or manufactured in this kingdom, until an enlightened policy   
[*...*]  
 shall appear to actuate the inhabitants of certain manufacturing towns there, who have taken so active a part in opposing the regulations proposed in favour of the trade of Ireland, and that they shall appear to entertain sentiments of respect and affection for their fellow-subjects of this kingdom.’[492](javascript:footNote('E900040/note492.html')) **Buckingham** was much alarmed at these resolutions, for the whole body of citizens, both Protestants and Catholics, had been present at the meeting, and he immediately sent for the Mayor to question him on the subject. But all the Mayor would say was that original resolutions far more extreme in their nature had been drawn up by the Common Council of the city, but that they had been modified to their present form by himself and the Board of Aldermen. It thus appeared that the municipal authorities were in favour of the resolutions which had been passed, and the feeling of the whole city was so strong that the Lord Lieutenant's Council advised him to move no further in the matter, as this ‘would have no other effect than making the disagreeable disposition worse.’[493](javascript:footNote('E900040/note493.html')) And now the ladies of Dublin, fired by the example of the men, determined not to be left behind in patriotism. Twelve ladies began the movement by forming themselves into an association for the encouragement of the manufactures of Ireland. They resolved ‘that we will not wear any article that is not the product or manufacture of this country, and that we will not permit the addresses of any of the other sex who are not equally zealous in the cause of this country.’[494](javascript:footNote('E900040/note494.html')) This association was the



---

p.204




beginning of a movement which quickly spread among all Irish women, and which was thought by contemporaries to be one most important reason of the extraordinary success of the non-importation agreements.


By the middle of the year non-importation leagues had been established in nearly every county in Ireland. The volunteers set the example of using Irish manufactures by clothing themselves in materials of home production, and they also passed resolutions at their meetings approving of the principle of the leagues and promising their support.[495](javascript:footNote('E900040/note495.html')) The Grand Jury and many of the resident gentlemen in the counties of Cavan, Carlow, Kilkenny, Queen's, and Meath passed resolutions that in consequence of the oppressive commercial restrictions and the new injuries which had been inflicted on Ireland by the recent and present embargoes, they would not use or import any British goods, but would consume their own manufactures, and that this resolution should be in force as long as Ireland remained restricted in her commerce.[496](javascript:footNote('E900040/note496.html')) Many really influential men placed their signatures to these documents, and numerous county meetings in other parts of Ireland adopted the non-importation agreements until they extended practically throughout the kingdom. But the agreements were not only adopted, they were also kept. The transactions of all traders were rigorously observed, and any merchant who happened to import British goods had his name printed in the Dublin newspapers and was held up to execration as a traitor to Ireland.[497](javascript:footNote('E900040/note497.html')) The consequence was that the few merchants who at first had the temerity to continue their importation of British goods soon ceased to do so, as it was difficult to find anyone willing to purchase from them, more especially as concealment of such purchases was impossible. At first the English manufacturers tried to



---

p.205




neutralise the non-importation agreements by attempting to flood the Irish country towns with woollen manufactures and other articles at cost price, for during the course of the war these goods had accumulated on their hands. But they soon gave up the attempt, finding that it only involved them in loss.


**Buckingham** seems to have had an idea of counteracting the non-importation associations by various means, but the general feeling against any interference ran so high that even its discussion was rejected by the Council. All the Lord Lieutenant could do was to try and reassure the British Ministry by writing to Weymouth that in his opinion the associations were only temporary, and would dwindle to nothing if only something in the way of substantial commercial indulgence were granted to the country.[498](javascript:footNote('E900040/note498.html')) The Irish Government, indeed, was beginning to realise that there would be trouble in Ireland if Great Britain did not speedily grant some freedom of trade to the Irish. At the end of April **Buckingham** wrote to Weymouth that the discontent of the kingdom was increasing, and that altogether the general appearance of affairs was very serious.[499](javascript:footNote('E900040/note499.html')) In the following June he expressed his opinion that nothing short of permission to export coarse woollen goods would give general satisfaction.[500](javascript:footNote('E900040/note500.html')) It is possible that the Lord Lieutenant's opinion had some weight with the British Ministry. They do not seem to have been unwilling to give some small relief to Ireland, and after pressure from the Opposition would have done so in the preceding year had it not been for the commercial jealousy the matter had aroused in Great Britain. But now the existence of thousands of armed volunteers in Ireland made the Government nervous, while the non-importation agreements fell very heavily on British merchants, and made them less anxious to keep



---

p.206




Ireland shut out from commercial privileges. From the beginning of the year new efforts were made in the British Parliament by individual members of the Opposition to take into consideration the trade of Ireland. On February 15th there was a debate in the House of Commons on the subject. **Lord Newenham** advocated the cause of Ireland, emphasised her distress, and asked leave to bring in a Bill granting her a free import trade from the West India Islands. But, meantime, he moved that the House should form itself into a committee to consider the matter.[501](javascript:footNote('E900040/note501.html')) He was supported by **Burke** and **Nugent**, but the motion was opposed on the score that no complaints had come regularly from Ireland to the British Parliament. It was said that the present Irish distress was temporary, and merely proceeded from the war. On the other hand, it was pointed out that England was only injuring herself by persisting in her old policy, for Ireland was her best consumer and the British exportation to Ireland, which generally amounted in value to £2,100,000 a year, had declined in the preceding year to £595,000, and was probably continuing to decline in an even greater proportion. At the same time, the Irish revenue had naturally been falling, for there had been an extraordinary decrease in the receipts from Customs in the Port of Dublin.[502](javascript:footNote('E900040/note502.html')) The result was that England had to support Irish troops serving abroad, while the Irish Government was continually applying to the British Ministry for financial aid. The danger which might arise to England from such a large number of armed men in Ireland was also insisted upon, and eventually it was resolved that the House should form itself into the committee proposed by **Lord Newenham**.[503](javascript:footNote('E900040/note503.html')) But nothing came of this committee, and the next move was made on May 11th, by the **Marquis of **Rockingham****, in the House of Lords. He proposed that 



---

p.207



the House should take into consideration the distressed state of Ireland, and should present an address to the King requesting that he would graciously consider the matter and would direct his Ministers to prepare and lay before Parliament such particulars relative to the trade and manufactures of Ireland as might enable Parliament to take measures to promote the common strength, wealth, and commerce of His Majesty's subjects. After some opposition the motion was carried.[504](javascript:footNote('E900040/note504.html')) Next day the address was presented, and the King answered that he ‘would give directions accordingly.’[505](javascript:footNote('E900040/note505.html')) On June 2nd Lord Shelbourne took the matter up also in the Lords, and said that the resolutions which had been carried in the House were too vague and indefinite, and he proposed that the Lords should present a second address to the King requesting that His Majesty should order to be laid before the House an account of such measures as had been taken in consequence of the preceding address and the King's answer, and that the King would be pleased to summon the Parliament of Ireland in order that its complaints might be heard.[506](javascript:footNote('E900040/note506.html')) **Lord Shelbourne** did not actually move this proposal, but merely left it on the table for the consideration of the Ministers. On the same day the **Earl of **Upper Ossory**** in the Commons moved a vote of censure on the Ministers for neglecting to relieve the kingdom of Ireland, but this motion was rejected. It is noticeable that not more than one-half of the Commons were present on this occasion, so little was the interest taken in Irish affairs even at this critical period. **Shelbourne** and **Ossory** were Irish landlords and naturally feared for the safety of their property if the agitation in Ireland should become more violent. They also belonged to the Opposition and acted to a great extent from party motives. It was the pressure of the Opposition combined with the alarming



---

p.208




state of affairs in Ireland, which finally induced the British Ministry to adopt a conciliatory policy.


**Rockingham**'s address to the King in May produced an interesting result. **Weymouth** wrote to **Buckingham** to prepare papers on the state of Ireland for the information of His Majesty's Ministers, and the Lord Lieutenant at once directed certain high officials and other influential and intelligent persons in Ireland to draw up reports on the condition of the country, the causes which had brought about the present poverty, and the means by which such poverty might be relieved. The result of these directions was a series of most interesting papers from **Hussey Burgh** (the Prime Serjeant), 
from **Hely Hutchinson** (the Provost), from the Commissioners of the Revenue, from the Lord Chancellor, from **Chief Justice Annaly**, from the **Speaker Perry**, from **Foster**, and from **Sir Lucius O'Brien**.[507](javascript:footNote('E900040/note507.html')) All these men were practically agreed concerning the causes of Irish poverty and the necessity of repealing some of the restrictions on the trade of Ireland if she were not to become a permanent burden on the British taxpayers. They also emphasised the advantage such a policy would be to England, and ridiculed the idea of the possibility of Ireland ever rivalling England in any branch of trade whatsoever. The English must always have an advantage in commerce and industry through their large capital, extended credit, and established skill. It was because of these advantages that the Scotch woollen manufacture, in spite of the fact that it shared in all the privileges of the English, had hitherto been confined to the lower branches, while much of the trade of the American colonies was carried on with English capital. All the reports agreed that the commercial restrictions which had fettered the trade of Ireland since the Revolution were one of the great permanent causes of Irish poverty, or rather, why Ireland found herself unable to
 


---

p.209




rally from the present temporary distress, and why she was so keenly affected by it. The second great cause, they thought, was the numerous financial abuses in the shape of pensions and sinecure salaries which had existed during the whole century. These were the permanent causes of Irish poverty, and no measure which did not strike at them could ever be really effectual in relieving Ireland. But the British Parliament had nothing directly to do with the financial abuses of Government; its work was to repeal the commercial restrictions. As to the lately increased distress in Ireland, that was due to circumstances connected with the present war, to the loss of the chief market for Irish linen, to the cessation of a clandestine trade in woollen goods to the American colonies, and above all to the embargoes which had checked the provision trade, on which so much of the prosperity of the kingdom unfortunately depended. **Hely Hutchinson**'s report is especially interesting, giving us as it does a vivid picture of the condition of Ireland. He tells us of the low value of land, the fall in rents, the difficulty of collecting them, the fall in the price of wool of seven or eight shillings the stone, the fall in the price of all kinds of grain; he points out the scarcity of money, the ruined national credit, and the necessity of the Treasury stopping payments to a large amount and borrowing a considerable sum in England on a mortgage of debentures. In the year ending Lady Day, 1779, there had been a decrease of £337,416 in the sums received into the Treasury from the revenue collectors. Bankruptcies were occurring every day among all classes of the people; there were numbers of beggars to be seen everywhere, and thousands of persons were without employment. During the last two years a large debt had been contracted; there was no sinking fund; the loan duties were deficient to pay the interest and annuities; the hereditary revenue and additional duties were totally inadequate to support the establishments, and large arrears had consequently



---

p.210




been incurred. From the beginning of 1778 until June, 1779, England had remitted £485,000 to Ireland for buying shares in the Irish Tontine, and in loans to the Treasury and to individuals in Ireland. But none of this financial aid could be productive of any permanent relief, for it did not strike at the root of the evils. Indeed, according to the opinion of **Hely Hutchinson** and of every other thoughtful man in Ireland, the repeal of the Acts restricting Irish trade had now become an absolute necessity. **Hussey Burgh** thought that the poverty of Ireland was so extreme that it was a matter of serious doubt whether she could any longer support her establishments, and whether she must not resort to England to defray the cost of her internal defence.


Events in Ireland soon forced the British Government to see the necessity of conceding the Irish demands. On October 12th, 1779, the Irish Parliament met. **Henry Grattan** was now foremost among the leaders of the patriotic party. During the four years in which he had sat in Parliament it had been his great aim to create an Irish nation, to unite Protestants and Catholics, to end the race and religious feud of centuries. It was he who had championed the cause of the Catholics in 1778, when the first step had been taken towards the repeal of the penal code. Now he was to be the champion of the entire nation in its demand for commercial freedom.


When Parliament met the address from the Throne proved vague and unsatisfactory. The usual indefinite promises were made, but nothing seemed settled, and the Commons were convinced of the vacillating policy of the Ministry. **Grattan** at once moved an amendment to the address to the King regarding the demand for free trade, stating in emphatic terms that the only way to relieve the kingdom, and render it capable of assisting England, was ‘to open its ports for the exportation of all its manufactures.’ **Grattan**'s amendment produced a long debate, in which he was supported by **Daly**, **Yelverton**,



---

p.211


**Flood**, **Conally**, **Sir Robert Newenham**, **Sir Henry Cavendish**, and other notable members. Some of these men went so far as to deny the right of England to fetter Irish trade by her own Acts of Parliament. But the Government had a large army of supporters, and it was determined to defeat **Grattan**'s amendment if possible, as his great influence was particularly disliked. Government was assisted in its efforts by many members who thought that the wording of the amendment was too emphatic, and eventually another amendment, proposed by **Flood** and **Hussey Burgh**, was proposed and carried in its place, Declaring ‘that it is not by temporary expedients, but by a free trade alone, that this nation is now to be saved from impending ruin.’[508](javascript:footNote('E900040/note508.html')) The House then went in a body to present the address to the Lord Lieutenant. Crowds of people were collected in the streets, and the Dublin volunteers were drawn up under the command of the **Duke of **Leinster****. The air resounded with cheers, and the Commons felt that it was indeed their privilege to represent the desires of the whole capital, if not of the entire nation.


But the King's answer was vague, and might have meant anything. The excitement, both in Parliament and all over the country, was intense. Everywhere violent speeches were made, and ‘a free trade’ was now the watchword of the nation. On November 4th the Dublin volunteers assembled in College Green and paraded round the statue of William III., whom they regarded as the founder of constitutional freedom. The artillery, commanded by **James Napper Tandy**, hung labels on the necks of their cannon, with the inscription, ‘Free Trade, or a speedy Revolution!’ On the sides of the pedestal of the statue were written the following inscriptions:—‘Relief to Ireland: A Short Money Bill’; ‘A Free Trade’, or — ‘The Volunteers: quinquaginta millia juncta, parati pro patria mori.’ Two cannons



---

p.212




with the inscription ‘Free Trade or This’ stood before the front of the statue. Similar placards appeared all over Dublin; the people assembled in thousands, and mixed freely with the volunteers; the expression of men's faces was one of enthusiasm, defiance, and determination. Government could be in no doubt as to the state of popular feeling.


On November 8th **Buckingham** wrote that unless the expectations of the kingdom were speedily answered, ‘almost every species of disorder may be apprehended.’[509](javascript:footNote('E900040/note509.html')) A week later he wrote an account to Weymouth of some further disturbances which had taken place in Dublin.[510](javascript:footNote('E900040/note510.html')) Early in the morning of November 15th a mob had assembled before the Attorney-General's house in Harcourt Place, and, finding the Attorney-General gone to the Four Courts, some stopped to break all his windows and doors, while others went to the Courts and demanded that he should be given up to them. Fortunately the Attorney-General managed to escape, and the mob then collected before the Parliament House, and as each member arrived he was forced to get out of his chair or coach and take an oath ‘to vote for the good of Ireland, for a Free Trade and a Short Money Bill.’ In consequence of this, some troops were at once sent for, and arrived shortly after three o'clock. The Lord Mayor was in the House, and he was persuaded to go out and speak to the people. But when he appeared some of the mob drew their cutlasses and swore they would kill him if he dared to take the command of the military, and that they would never disperse until the troops were drawn off. Eventually the soldiers were ordered off to Kildare Street, on the pretext that some of the mob meditated an attack on the house of Sir **Henry Cavendish**. But no attempt of the kind was made, and the crowd peaceably dispersed at four o'clock, when the House adjourned. The violent feeling displayed against



---

p.213




the Attorney-General was due to the opposition he had made in Parliament against the proposed associations not to re-elect such members as might vote for new taxes before an extension of trade was obtained. The mob on this occasion seems to have consisted only of the lowest section of the populace.


It was in the midst of all this excitement that **Grattan** moved in the Commons, on November 24th, ‘that at this time it would be inexpedient to grant new taxes.’ The resolution was carried against the Government by a majority of 123. The next day the House went into Committee of Supply, and the patriotic party moved that the appropriated duties should be granted for six months only. A memorable debate followed, of which **Hussey Burgh** was the hero. One of the Government supporters spoke of the necessity of preserving peace at any cost. **Hussey Burgh** sprang to his feet. ‘Peace!’ he cried; ‘talk not to me of peace. Ireland is not in a state of peace; it is smothered war. England has sown her laws like dragons' teeth, and they have sprung up like armed men.’ The effect of this outburst was marvellous. The House resounded with cheers, in which the people crowding the galleries joined. There was a scene of the wildest enthusiasm, and when the resolution was put to the vote it was carried by a majority of 38.[511](javascript:footNote('E900040/note511.html'))


The battle was won. **Buckingham** represented to **Lord Worth** that substantial concessions were absolutely necessary in face of the feeling which prevailed all over the country. On December 6th the Opposition in the British House of Commons proposed a vote of censure on His Majesty's Ministers for suffering the discontents in Ireland ‘to rise to such a height as evidently to endanger a dissolution of the constitutional connection between the two kingdoms.’[512](javascript:footNote('E900040/note512.html')) A few days later **North** introduced into Parliament his resolutions for the relief of Ireland. 



---

p.214




There were three principal ones. The first allowed the free exportation of Irish wool and woollen manufactures; the second allowed the free exportation of Irish glass and glass manufactures; the third allowed freedom of trade with the British plantations under certain conditions, the basis of which was to be ‘an equality of taxes and customs upon an equal and unrestrained trade.’ **North** also proposed that the Irish should be permitted to become members of the Turkey Company, and to carry on a direct trade with the Levant Seas; that foreign hops might be imported into Ireland; and that the Act which prohibited the importation of gold and silver coin into Ireland should be repealed. The debates on the three principal resolutions took place on December 13th. The Bills allowing the free exportation of wool and woollen manufactures and glass passed at once almost unanimously and with scarcely any discussion, and received the royal assent as early as December 21st.[513](javascript:footNote('E900040/note513.html')) On January 24th of the next year the Bill allowing a free trade between Ireland and the plantations was passed, and on March 21st the Bill allowing the importation of foreign hops into Ireland, for taking off the drawback on hops exported from Great Britain to Ireland, and for allowing a free trade between Ireland and the Levant Seas was also passed.[514](javascript:footNote('E900040/note514.html')) And so, suddenly, with little debate and practically no opposition, the British Parliament relieved the trade of Ireland in all the most important points. Parliament yielded to force of circumstances, for Great Britain's hands were completely tied by the American war. There was little opposition in the country, although the measures went much further than those proposed the previous year, which had raised such a commotion. It seems probable that the Irish non-importation agreements had something to say to this change of front on the part of the British manufacturing interest, and perhaps also the common



---

p.215




sense of the British people made them realise that their day of complete commercial monopoly had gone for ever.


The free trade Bills were received in Ireland with the greatest enthusiasm. The Irish Parliament showed its gratitude by promptly passing a Bill granting drawbacks on goods imported from foreign countries when re-exported to the British colonies in America or the West Indies, or to the British settlements on the coast of Africa, and also placing the Irish trade with America and the West Indies on the same footing as the British trade with those countries.[515](javascript:footNote('E900040/note515.html')) New taxes were also granted, and for a short time harmony reigned between the Opposition and Government.


In the struggle for free trade Ireland treated Great Britain with as little consideration as Great Britain had treated her in the past. She took advantage of the difficulties which confronted England, for she knew well that nothing but sheer force and necessity would break through the jealousies and fears of the manufacturing and trading interests in England and Scotland. The Irish Parliament and the Irish volunteers played the chief parts in the drama, and indeed had it not been for the existence of a large body of armed men in Ireland, it is probable that Great Britain would still have vacillated and continued her doles to keep the Irish Government from bankruptcy instead of striking at the source of the evils. There was no real desire in Great Britain to substantially relieve Irish trade until 1779, when the volunteers were arming and the non-importation agreements were being formed, and when the Lord Lieutenant emphasised the danger of the situation unless something was done. Great Britain's need was Ireland's opportunity, and so she won her free trade.


But Ireland was not content, and could not be content,



---

p.216




with free trade. She wanted a free Parliament in order to secure the permanence of that free trade. The struggle was not finished yet; perhaps the most notable part was still to be played. Of that part **Grattan** was the hero, and the volunteers supplied the needful coercion for obtaining all he claimed.




---

p.217


After Free Trade.
-----------------


Renewed Unrest in Ireland—Agitation for Legislative Independence—Volunteer Meeting at Dungannon—Change in British Policy—**Grattan**'s Declaration of Irish Rights Embodied in Address to the King, April 16th, 1782—Repeal of British Declaratory Act of 6 Geo. I.—Dissatisfaction in Ireland—British Act Renouncing Explicitly all Legislative and Judicial Supremacy over Ireland—New Phase in Commercial Relations between Great Britain and Ireland—Distress in Ireland and Demand for Protective Duties against British Manufactures—Reasons for this Demand to be found in the still existing Commercial Inequality between the two Countries—Commercial Policy of the Irish Parliament—Renewal of the Non-Importation Agreements.
At the end of 1779 **Buckingham** wrote to Hillsborough: ‘The satisfaction of Ireland seems final and complete.’[516](javascript:footNote('E900040/note516.html')) But this harmony between Government and people on which the Lord Lieutenant congratulated himself did not last long, for no sooner was free trade actually obtained than the Irish people began asking themselves how they could best render this free trade permanent and secure. The laws of 1779 and 1780, which gave relief to Ireland, asserted in themselves the absolute supremacy of the British legislature. Its Acts of concession were in fact declaratory of its own power. Throughout the length and breadth of Ireland it was believed that the repeal of the restrictive trade laws had been done on the principle of expediency, and therefore that England might again withdraw the grant when her necessities were over. In **Grattan**'s words, it was felt that the free trade which had been granted to Ireland was a ‘trade de facto, and not de jure; a licence to trade under the Parliament of England, 



---

p.218




not a free trade under the charters of Ireland   
[*...*]  
 to maintain which Ireland must continue in a state of armed preparation, dreading the approach of a general peace, and attributing all she holds dear to the calamitous condition of the British arms in every quarter of the globe.’[517](javascript:footNote('E900040/note517.html')) The political and commercial questions were indeed indissolubly associated, for it was inevitable that Irish patriots should be haunted with the idea that what the British Parliament had done it could undo, and that the only way to make the commerce of Ireland really secure was to put it under the sole protection of an independent Irish legislature.


The policy of England emphasised this feeling. At the beginning of 1780 the British Government was anxious for the Lord Lieutenant to place an embargo on the exportation from Cork of all Irish provisions. But **Buckingham** represented that the measure would create much political discontent, and might even be ‘productive of dangerous violence.’[518](javascript:footNote('E900040/note518.html')) He proposed that if Government anticipated any benefit to the enemy from the exportation of Irish provisions, it should purchase them for the use of the British army and navy. This proposal, however, was not acted upon, and eventually the idea of the embargo dropped. But it had seemed to show the dangers to which the new free trade might be liable. A few months later there was further discontent in Ireland, because the English Privy Council reduced a protective duty which the Irish Parliament proposed to impose on refined sugars imported into the country.[519](javascript:footNote('E900040/note519.html')) This measure was believed to be disastrous to the refining interest, and a large patriotic minority in the Commons became more and more resolved to put out of the reach of the British 



---

p.219




Parliament the power of interfering with Irish commerce. Only a free Parliament would be a sure forerunner of commercial liberty.


On April 19th, 1780, **Grattan** moved for the first time his Declaration of Irish Rights. A very long debate followed, which lasted till 6.30 the next morning.[520](javascript:footNote('E900040/note520.html')) But in spite of **Grattan**'s extraordinary eloquence and enthusiasm, his statesmanlike insight into the constitutional questions involved, and the fact that he was supported by some of the most able and sincere men in the House, Government proved too strong for him, and his motion was negatived by a majority of 34.


But meanwhile the feeling of the Irish nation was with **Grattan**. The volunteers now began to take a prominent part in the agitation. On July 13th, 1780, 2,700 of the Ulster contingent assembled at Belfast and presented an address to **Lord Charlemont**, then Commander-in-Chief, in which they stated that only the King, Lords and Commons of Ireland had power to bind Ireland.[521](javascript:footNote('E900040/note521.html')) There were now about 80,000 volunteers under arms, and volunteer meetings all over the country followed the example of the North and passed resolutions asserting the independence of the Irish Parliament. There was a growing dislike on the part of Irish juries to recognise the validity of British Statutes which had not been made law by the Irish legislature on all matters which concerned the trade of Ireland. An instance of this occurred in Kerry in 1781, where a smuggling vessel laden with rum from the West Indies, was seized by the customs officers, it being still illegal by virtue of a British Act to import rum direct from the West Indies. But when the case was tried it was found that the jury refused to find a verdict against the ship, on the ground that there was no Irish Act prohibitive of the trade; indeed, they even found



---

p.220




damages against the revenue officers for illegal arrest.[522](javascript:footNote('E900040/note522.html')) The commercial difficulties with Portugal increased the growing suspicion of England. It was found that the free trade granted to Ireland was not doing her much good, for the war confined her trade to a few countries, and the chief of these, Portugal, now refused to receive Irish manufactures.[523](javascript:footNote('E900040/note523.html')) The matter aroused great indignation in the Irish Parliament. It was suspected that the British Ministry were not doing their utmost in favour of Ireland in the negotiations which were proceeding with the Portuguese Government, for, as Portugal was at this time on the most friendly terms with Great Britain, sufficient pressure should have induced her to remove her prohibition on the importation of Irish goods[524](javascript:footNote('E900040/note524.html')) But the affair dragged on and on. Efforts to address the Crown on the matter of pressing the negotiations were defeated by Government, and the feeling became still more prevalent that as long as England legislated for Ireland in all commercial matters, so long would Ireland be liable to such insults as she was now receiving from Portugal.


During the year 1781 discontent in Ireland increased, and the huge army of volunteers began to alarm the Government. Their organisation and discipline had made great progress, and when **Lord Carlisle**, the new Viceroy, met Parliament in October he found the volunteers a most formidable body, and the whole country in a state of commotion concerning legislative independence.[525](javascript:footNote('E900040/note525.html')) The people seemed united, and the Lord Lieutenant expressed a hope that Ireland would not be mentioned in any new Bills to be passed that year in the British Parliament, as such a policy might be highly dangerous under the present circumstances. He added that it was quite unnecessary for Great Britain to include Ireland in her laws, for ‘every



---

p.221




regulation or restriction which Great Britain may think fit to subject herself to, and which she may consider as equally incumbent on Ireland, will be cheerfully adopted by this country and effectually executed by Irish law.’[526](javascript:footNote('E900040/note526.html'))


On February 22nd, 1782, **Grattan** again moved his Declaration of Irish Rights. The Attorney-General opposed the motion, and suggested that it should be adjourned till the following August. He managed to get a majority to support him by declaring that **Grattan**'s proposal was ‘hazardous to the properties in this country held under English Acts of Parliament,’[527](javascript:footNote('E900040/note527.html')) and the motion was lost by sixty-nine votes. But in his very interesting account of this debate **Carlisle** wrote that throughout its whole course ‘the principle of Ireland not being bound by Acts of the British legislature, was most strenuously supported by every man who spoke on either side, even by those the most zealous in support of the measures of Government.’ He thought that there was no reason to anticipate a change in this attitude, for every rank and order in the nation was full of the idea of the independence of the Irish Parliament, and it was extremely doubtful whether any lawyer would now advise his clients to bring a cause to issue upon the validity of a British Act in Ireland, or whether any jury would be found to give a verdict upon the same foundation. ‘Should any Act,’ Carlisle added, ‘hereafter pass in Great Britain with the apparent tendency of binding this kingdom, I should apprehend the most serious difficulties and embarrassment to His Majesty's Government.’[528](javascript:footNote('E900040/note528.html'))


The famous meeting at Dungannon in this same month of February, where delegates from the whole body of Ulster volunteers assembled, caused further excitement in Ireland, and made the situation of Government still more difficult.



---

p.222




One hundred and forty-three delegates came together at this meeting. It was held in the parish church, and the proceedings were so quiet and orderly that it was impossible for Government to interfere, even had it dared. The most important resolution passed was one declaring ‘that a claim of any body of men other than the King, Lords, and Commons of Ireland to make laws to bind this kingdom is unconstitutional, illegal, and a grievance.’ It was also resolved ‘that the ports of this country are by right open to all foreign countries not at war with the King, and that any burden thereupon or obstruction thereto, save only by the Parliament of Ireland, are unconstitutional, illegal, and a grievance.’ Other resolutions concerning a sessional Mutiny Bill and the independence of the judges were passed, and finally one that was very remarkable, coming as it did from an intensely Protestant body. The meeting resolved, with only two dissentient voices, ‘that we hold the right of private judgment in matters of religion to be equally sacred in others as in ourselves. Resolved, therefore, that, as men and as Irishmen, as Christians and as Protestants, we rejoice in the relaxation of the penal laws against our Roman Catholic fellow-subjects, and that we conceive the measure to be fraught with the happiest consequences to the union and prosperity of the inhabitants of Ireland.’[529](javascript:footNote('E900040/note529.html')) Thus the Dungannon resolutions included everything necessary to the progress of Ireland; legislative freedom, parliamentary control over the army, religious equality, freedom of trade. All Ireland adopted these resolutions, and meetings were held in every county by freeholders and grand juries formally accepting them.[530](javascript:footNote('E900040/note530.html'))


From this time the Lord Lieutenant gave up all hope of defeating the new ideas of legislative independence. In March he wrote to the British Government that the policy of Great Britain had greatly aggravated the situation. 
 


---

p.223



‘The actual exercise of the British Parliament over Ireland,’ he wrote, ‘was utterly and totally Impracticable long before I arrived in this *kingdom*,’ for no revenue officers or magistrates dared enforce an English law. Even the mere recollection of the British claim was an object of jealous uneasiness, ‘but might perhaps have gradually been weakened if four or five Acts had not passed in the last session of the British Parliament which (whether inadvertently or otherwise I am not informed) named Ireland.’[531](javascript:footNote('E900040/note531.html')) A little later Carlisle pressed the matter still further. ‘It is beyond a doubt,’ he wrote, ‘that the practicability of governing Ireland by English laws is become utterly visionary. It is with me equally beyond a doubt that Ireland may be well and happily governed by its own laws. It is, however, by no means clear that if the present moment is neglected this country will not be driven into a state of confusion, the end of which no man can foresee or limit.’[532](javascript:footNote('E900040/note532.html')) Carlisle recommended that an important Irish Bill, which had just been transmitted to England, should be returned without any material alteration, and he even ventured to suggest ‘that it may deserve the serious consideration of the Ministers   
[*...*]  
 whether the repeal of the 6 Geo. I.[533](javascript:footNote('E900040/note533.html')) might not be a measure equally becoming and wise.’ On every other point **Grattan** could be opposed, but in view of the state of public feeling even the most loyal friends of Government could not be expected to offer a resistance to the motion declaratory of Irish Rights, which was to be again taken up on April 16th.[534](javascript:footNote('E900040/note534.html')) Some of the gentry had already been deprived of their commands in the volunteer corps because of their support of Government, and it was Carlisle's serious opinion that if the first day of the next meeting of Parliament did not quiet the minds of the



---

p.224




people on the all-important point, ‘hardly a friend of Government will have any prospect of holding his seat for a county or popular corporation; and, what is more immediately interesting, they will also lose their present salutary influence over the armed associations.’[535](javascript:footNote('E900040/note535.html'))


Fortunately, when the Irish Parliament met on April 16th circumstances had changed, and Great Britain was no longer opposed to a policy of conciliation. Much had happened during the last month. The Dungannon Resolutions had been adopted everywhere, Great Britain had been finally defeated in America, and a total change had taken place in the British Ministry, **Fox** being appointed instead of **North**. The **Duke of **Portland**** came over as Viceroy, with Fitzpatrick as his secretary, with orders to adopt a policy of conciliation. The whole policy of Government suddenly changed; the members of the Irish Parliament ceased to be persuaded to oppose **Grattan**, and Government decided to yield to popular opinion. On the first day of the session the Secretary of State delivered a message in the Commons from the Lord Lieutenant, stating that he was commanded by the King to recommend to the House to take into their most serious consideration the discontents and jealousies prevailing among his loyal subjects of Ireland, ‘in order to arrive at such a final adjustment as might give mutual satisfaction to the kingdoms of Great Britain and Ireland.’ The restraining hand of Government being thus removed, **Grattan**'s success was a foregone conclusion. He moved his original motion as an amendment to the address to the King. ‘To assure his Majesty,’ it ran, ‘that his subjects of Ireland are a free people. That the Crown of Ireland is an Imperial Crown inseparably annexed to the Crown of Great Britain, on which connection the interests and happiness of both nations depend. But that the kingdom of Ireland is a distinct kingdom, with a Parliament of her own, the sole



---

p.225




legislature thereof. That there is no body of men competent to make laws to bind this nation except the King, Lords, and Commons of Ireland, nor any other Parliament which hath any authority or power of any sort whatsoever in this country, save only the Parliament of Ireland. To assure His Majesty that we humbly conceive that in this right the very essence of our liberties exists, a right which we, on the part of all the people of Ireland, do claim as their birthright, and which we cannot yield but with our lives.’[536](javascript:footNote('E900040/note536.html')) This amendment was carried without a single negative voice[537](javascript:footNote('E900040/note537.html')), and the enthusiasm in the country was so great that the new Viceroy wrote that he thought it was his duty to state shortly what he conceived would be the result of refusing or delaying to gratify the wishes of the Irish people. ‘I must declare it to be my opinion,’ he solemnly wrote, ‘that in either case *there would be an end of all government.*’[538](javascript:footNote('E900040/note538.html')) It was no longer the Parliament of Ireland, Portland warned the British Government, which had to be managed; it was the whole country. ‘The Church, the law, the army, the merchant, the tradesman, the manufacturer, the farmer, the labourer, the Catholic, the Dissenter, the Protestant, all sects, all sorts and descriptions of men   
[*...*]  
 unanimously and most audibly call upon Great Britain for a full and unequivocal satisfaction.’[539](javascript:footNote('E900040/note539.html')) The representations of the Viceroy destroyed what little resistance was still left in England, and on May 4th, when the debate on the Irish claims took place, **Fox** at once proposed the repeal of the declaratory Act of 6 Geo. I., which laid down the dependence of the Irish Parliament. There was little opposition, and on May 27th the Duke of Portland informed the Irish Parliament that the declaratory Act had been repealed.




---

p.226


But the simple repeal of the 6 Geo. I. failed to settle matters satisfactorily. **Grattan** was content, but a large party in the country, headed by **Flood**, was still dissatisfied. It was thought that Great Britain might go back from her word, and might still try to bind Ireland unless the British Parliament passed an Act explicitly stating that it had no power over Ireland. The Irish Parliament had been dependent upon England long before the declaratory Act was passed; it might therefore remain in its dependent position after the repeal of the Act. Unfortunately, just at this time England was not sufficiently guarded in the wording of her Acts, and two English trade laws were drawn up in such a way—probably through mere carelessness—as to include Ireland. For example, an Act was passed in England on June 4th to allow the importation of sugars from St. Christopher's, Nevis and Montserrat ‘into any of the ports of His Majesty's dominions.’ Ireland was not mentioned by name, but it was thought that she must be included, as the Act mentioned all the King's dominions.[540](javascript:footNote('E900040/note540.html')) This increased the suspicion that England did not mean to give Ireland complete legislative independence, and made the Irish determined to get a formal renunciation of power from England. **Lord Abingdon**'s motion in the British Parliament brought matters to a head. He moved for leave to bring in a Bill declaring the right of the Parliament of Great Britain to regulate and control the external commerce and foreign trade of Ireland, and repealing any legislation which withdrew any portion of the commerce of Ireland from its control. It is true that this Bill was never introduced, but it had a bad effect on the minds of the Irish people, and increased their already existing suspicions of England. There was an idea prevalent that Great Britain might attempt to distinguish between external and internal independence, so that Irish trade would



---

p.227




never be safe from interference until the British Parliament actually denied its own right to meddle with it. There was no hope of quieting the country until this was done, and on December 20th Government, pressed on all sides, at last promised to bring in a Bill to settle the matter. On January 22nd, 1783, the Bill was brought in and passed by the British Parliament, renouncing explicitly all legislative and judicial supremacy over Ireland. It was the short-lived charter of Irish legislative independence.[541](javascript:footNote('E900040/note541.html'))


From this time until the Union the commercial relations between Great Britain and Ireland were on quite a new basis. England ceased to have any power over Irish commerce, and Ireland was now able, if she liked, to follow England's example and prohibit English goods from entering her ports, or at least impose very heavy duties upon them.


The legislative settlement quieted for a time the agitation in the country, and very soon Ireland began to benefit from the trade concessions of 1779 and 1780. At first, however, the progress was slow. The refusal of Portugal to take Irish linen and woollen goods produced some distress, for large quantities had immediately been sent there only to find they were refused admittance. It was not until May, 1782, that Portugal at last allowed Irish manufactures to be imported[542](javascript:footNote('E900040/note542.html')), but in the following year this concession was again withdrawn, and a fresh prohibition was placed by Portugal on the importation of Irish camblets, broad and narrow stuffs, flannels, and bays,[543](javascript:footNote('E900040/note543.html')) and it was some time before the Portuguese Government could be induced to reverse its decision. In 1783 there seems to have been a good deal of distress in Dublin and some other parts of the country. There had been a bad harvest in England and Scotland, and in consequence



---

p.228




there was an enormous demand in those countries for corn, and very large prices were offered. This was a temptation to Irish farmers to send their grain away instead of selling it at home, and as the Irish harvest, particularly of oats, the food of the poorest classes, had also been defective, the prices of all kinds of grain rose enormously. It was not possible for grain to be imported from the Continent, for the superior prices offered in Great Britain drew all the surplus of grain there, and the Lord Lieutenant was obliged to issue a proclamation forbidding grain to be exported from Ireland.[544](javascript:footNote('E900040/note544.html')) This prevented the existing supply of grain from decreasing, but the high prices were sufficient to bring great distress upon the poorer classes. There was also a general want of employment during this year, and every manufacturing interest began to clamour loudly for protective duties. It was said that Great Britain and France and all other free countries had raised themselves to commercial prosperity in this way, and why should not Ireland follow their example? Nothing but protective duties, it was thought, could put Irish manufacturers on an equality with British manufacturers, and effectually counterbalance all the advantages possessed by them.


As a matter of fact there was a good deal of reason in these demands for protective duties. The trade concessions of 1779 and 1780, great and important though they were, had nevertheless not put Ireland on terms of equality with Great Britain in all matters of commerce. No British goods were prohibited from being brought into Ireland, and on none were heavy duties placed. Even in those cases where comparatively heavy duties were laid on articles which could be produced in Great Britain, an exception was nearly always made in favour of Great Britain. With very few exceptions Ireland at this time imposed a 10 *per cent* on all articles imported, and a 5 per 


---

p.229


*cent* duty on all articles exported. The Irish Parliament still regarded the customs as a means of raising revenue, not of affording protection.


Very different was the treatment which Ireland received at the hands of Great Britain. Many Irish goods were prohibited by law from being brought into Great Britain at all; these were wrought silks, silk stockings, silk gloves and mittens, leather gloves, lace, fringe, and embroidery, and copper and brass work. At the same time the importation from Ireland of the following articles was practically prohibited by the imposition of extremely heavy duties varying from 30 to 60 *per cent*: all kinds of woollen cloth, all kinds of stuffs mixed with wool, refined sugars, beer, hops, all cotton manufactures, manufactures of linen and cotton mixed, printed linens, cotton stockings, thread stockings, leather manufactures, tallow candles, starch and soap.[545](javascript:footNote('E900040/note545.html')) The consequence was that the British markets were practically shut against all Irish goods except provisions and plain linen cloth, which were admitted duty free. It was noticed at the time that in spite of the low duties paid on the importation of British goods into Ireland, the revenue obtained from them was far more than that obtained from duties on Irish goods imported into Great Britain.[546](javascript:footNote('E900040/note546.html')) This proves that the British import duties were practically prohibitory. The Irish merchant had little capital or credit, and even under the most favourable circumstances he could hardly have competed with the British merchants in their own markets. But under the conditions prevailing, it was impossible for him to attempt to compete. The following table[547](javascript:footNote('E900040/note547.html')) gives the duties payable on certain articles imported into Great



---

p.230




Britain and Ireland respectively, and shows the great disadvantages under which Ireland laboured in her commercial
relations with Great Britain.





[548](javascript:footNote('E900040/note548.html'))| Articles | Import duties payable in England £ s. d. | Import duties payable in Ireland (Brit. money) £ s. d. |
| Old Drapery, per yard | 2 0 6.4 | 0 0 5.5 |
| New Drapery | 0 5 11.5 | 0 0 1.95 |
| Mixed Linen and Cotton Goods, for every £100 value | 29 25 10 | 9 18 5.4 |
| Printed Linens, for every £100 value | 65 10 10 | 9 18 5.4 |
| Leather Manufactures, for every £100 value | 65 10 10 | 9 18 5.4 |
| Checks, for every £100 value | 35 15 0 | — |
| Refined Sugar, per cwt. | 5 6 9.95 | 1 13 11.8 |
| Starch, per cwt. | 4 12 1.85 | 0 6 5.6 |






Besides being shut out from the British markets, the Irish merchant, although he could now trade directly with the plantations, was not allowed to export plantation produce to great Britain. It was feared that if such an export trade were permitted, the natural advantages of Ireland would enable her to become the emporium for plantation goods and thus transfer to her a great part of Britain's carrying trade. Ireland was also not allowed to trade directly with the territories included in the East India Company's charter, but had to take all East Indian, Persian, and Chinese goods through the medium of Great Britain. Irish subjects, too, were not allowed to trade with the territories between the Cape of Good Hope and the Straits of Magellan, like British subjects.


Thus there was no real commercial equality between the two countries. The old narrow commercial spirit



---

p.231




was by no means dead in England, nor had the new idea of freedom of trade yet come to the front. It is, of course, extremely doubtful whether Ireland would have gained much at this time from the opening of the British markets to her manufactures, for she was not yet sufficiently advanced, industrially speaking, to compete with British manufacturers in their own markets. The re-export trade in plantation goods might have benefited her to some degree, though certainly not to the extent feared by Great Britain, while Ireland was not yet in a position to trade profitably to the East on her own account. But the Irish had gained so much within the last few years that they resented not having gained all, and it seemed really unjust that British merchants should be able to import all their goods into Ireland on payment of low duties, while Irish manufacturers were excluded from the British markets. It was insisted that if Great Britain thought it necessary to protect herself from a poor country like Ireland, where industries were but in their infancy, surely it was absolutely necessary for Ireland to protect her infant and struggling industries from the vigorous competition of the British. Added to this sense of injustice there was for a short time a certain amount of poverty and distress in some parts of the country and a good deal of want of employment in Dublin.[549](javascript:footNote('E900040/note549.html')) Therefore, the clamour that now arose for protective duties is perfectly comprehensible under the circumstances that existed.


The demand for protective duties had begun as early as 1780 on the part of the sugar refiners and the woollen and linen manufacturers,[550](javascript:footNote('E900040/note550.html')) but at the end of 1783 it was much more insistent and widespread. In October a petition of the workers employed in the broadcloth manufacture was presented and read before the Irish House of Commons, complaining of the way in which they were being



---

p.232



undersold by English woollen merchants, and of the small duties levied on the importation of woollen manufactures, and petitioning for protective duties similar to those imposed by Great Britain.[551](javascript:footNote('E900040/note551.html')) A similar petition was soon afterwards sent up by the worsted weavers of the county and city of Dublin on behalf of themselves and the other worsted weavers of Ireland,[552](javascript:footNote('E900040/note552.html')) and the Mayor, Sheriffs, commons, and citizens of Dublin presented a petition for preventing the exportation of the raw material for the manufacture.[553](javascript:footNote('E900040/note553.html')) Petitions for protective duties were sent up by many other trades, notably by the wire manufacturers of Dublin[554](javascript:footNote('E900040/note554.html')) and by the journeymen hatters,[555](javascript:footNote('E900040/note555.html')) and the feeling ran so high that in March, 1784, a committee of the House of Commons was appointed to enquire into the state of the trade and manufactures of Ireland, and to consider the expediency of granting bounties on the sale of Irish manufactures. Little was said about the possibility of protective duties, and the Lord Lieutenant wrote that he was not apprehensive of Parliament imposing such duties, as ‘the considerate men of this country are too sensible of the loss which Ireland would sustain by provoking England to retaliation.’ He thought, however, that the British Government should in justice either allow the present Irish duties on British manufactures to be somewhat raised, or assure Ireland that the prohibitory duties on Irish manufactures would be lowered in Great Britain. It was his opinion that this latter alternative might be adopted without any risk to the English manufacturers from Irish competition.[556](javascript:footNote('E900040/note556.html')) But **North** replied that the Lord Lieutenant's suggestion was impossible and that Great Britain ought to be left her few advantages in trade because of her heavy taxation due to the fact 



---

p.233



that the chief weight of supporting the Empire fell on her.[557](javascript:footNote('E900040/note557.html')) In April the matter of protective duties was definitely taken up in the Irish House of Commons by Mr Gardiner. He said that the interference of Parliament was necessary to remove the difficulties under which Irish industries laboured, and he proposed that an additional duty of 2s. 6d. a yard should be levied upon old drapery imported into Ireland. He declared that the disagreement on the subject was simply one of degree, for some of the existing duties, such as those on beer, refined sugar, corn, and flour were really protective in their nature, so that Parliament would not be adopting any new principle by accepting his proposal.[558](javascript:footNote('E900040/note558.html')) But the feeling of the House was against Gardiner. Foster pointed out that the matter was to a great extent one of expediency and that in this instance protective duties would only serve to irritate England without doing any good to Ireland. Many other Members feared that if England's hostility were aroused she might refuse to import Irish linens, and as Irish linens were excluded from the chief markets of the Continent by means of heavy duties, this would be most injurious to Ireland's staple manufacture.[559](javascript:footNote('E900040/note559.html')) Gardiner's proposal was therefore negatived by 123 to 37 votes, and he made no attempt to renew it.


The rejection by the Irish Parliament of the proposed protective duties on the importation of woollen cloth gave rise to considerable disturbances in Dublin. There were outrages and riots which had to be suppressed by the military. Members of Parliament who supported the Government were insulted, the press was seditious, and non-importation agreements began to be renewed in the capital. On April 22nd a public meeting of the citizens



---

p.234



of Dublin was held at the Tholsel, and it was resolved to re-enact the non-importation agreement as long as any restrictions remained on Irish trade, and as long as the Irish manufacturers supplied their goods at reasonable prices.[560](javascript:footNote('E900040/note560.html')) Tradesmen and artisans who imported English goods were ill treated, and the lowest section of the Dublin populace took the opportunity to make themselves as troublesome as possible. ‘Their resentment,’ wrote **Rutland**, ‘is not now confined to persons importing English goods, but is let loose upon any persons whose conduct crosses their immediate private interests; and accordingly several have suffered from working at low wages, for assisting at branches of manufacture to which they are not regularly bred, and from having come in from the country to work in Dublin when combinations among the journeymen had prevented the master manufacturers from carrying on their business.’[561](javascript:footNote('E900040/note561.html')) But these riots and disturbances only lasted a few months and they were practically confined to Dublin. They were chiefly caused by the scarcity of grain and potatoes and by a certain want of employment, and with the growing prosperity of the country quiet was soon restored. The non-importation agreements, however, continued during this and the next year, and although they did not this time spread beyond Dublin, they caused much loss to British manufacturers and were one of the reasons which made **Pitt** anxious for a new commercial settlement with Ireland.


The policy of the Irish Parliament during the next year did much to quiet the minds of the people. Although the Commons had refused to impose duties to protect the Irish woollen manufacture, they placed additional duties on refined sugars, beer, wire, and printed calicoes, now with no exception in favour of England.[562](javascript:footNote('E900040/note562.html')) Bounties were also



---

p.235



granted by the Irish Parliament on the exportation of refined sugars, on corn and flour imported under certain conditions, on the carriage of corn and flour to Dublin, inland and coastways, on fishing vessels, on cured fish exported, on Irish coals brought to Dublin, and on wrought silks exported.[563](javascript:footNote('E900040/note563.html')) Most of the import duties, however, remained comparatively low, and except in the cases which have just been mentioned, those additional duties which were imposed were not extended to articles of British growth and manufacture. On the whole Ireland treated Great Britain generously. The duty of 10s. the barrel laid upon all herrings imported did not extend to British herrings; Great Britain was excepted from the additional duties levied on the importation of paper, linens, and thread; Irish Acts laid down that no hops could be imported into the kingdom except from Great Britain or the British colonies in America; and glass, gold and silver lace, cambric and lawns could only be imported into Ireland if of British manufacture.[564](javascript:footNote('E900040/note564.html')) But in spite of the moderation of the Irish Parliament in its new-found freedom, public feeling in Great Britain was very nervous at the commercial independence of Ireland. In 1785 **Fox** admitted that it was only with great reluctance and under pressure of an overwhelming necessity that he had consented three years before to the abandonment of the British right of commercial legislation for the whole Empire, and the British Government was becoming more and more anxious to conclude some sort of commercial treaty with Ireland. The Irish Parliament was no less anxious for a measure which might quiet the minds of the people, and in 1785 **Pitt** brought forward his Commercial Propositions, by which he hoped to settle the matter of commercial relations with Ireland once for all.




---

p.236


The Commercial Propositions of 1785.
------------------------------------


Reasons for a new commercial Adjustment—History of the Commercial
Propositions—The Eleven Propositions—Agitation in Great
Britain—**Pitt**'s Twenty Propositions—Their Reception in Ireland
—Abandonment of the Scheme.
IT has been seen that in spite of the great trade concessions of 1779 and 1780, Ireland had not as yet any real equality of trade with Great Britain. Irish ports were open to all British produce and manufactures, while the ports of Great Britain were closed against Ireland in nearly all those articles of commerce which Ireland freely admitted. These were all articles the produce of the British colonies in Asia, Africa, and America, and certain articles the growth or manufacture of both Great Britain and Ireland. The first were excluded by means of a particular interpretation of the Navigation Acts, the second by means of actual prohibitions or prohibitory duties.


The agreements in Ireland not to purchase or consume any British produce or manufactures greatly alarmed British traders, and although now confined to Dublin, seem to have inflicted on them a considerable amount of harm. One London factor's export trade fell from £30,000 to £5,000 a year.[565](javascript:footNote('E900040/note565.html')) Calicoes and printed cottons suffered greatly, the Manchester fustian trade from the port of Chester was ruined,[566](javascript:footNote('E900040/note566.html')) the exportation of superfine and second cloths from Wiltshire nearly ceased[567](javascript:footNote('E900040/note567.html')) and the 



---

p.237



exportation of silk manufactures decreased.[568](javascript:footNote('E900040/note568.html')) No doubt Irish consumers suffered also from the renewed formation of these non-importation agreements, but the distress which prevailed among certain classes of artisans at this time was the cause rather than the consequence of the leagues. The Irish people were willing to inflict upon themselves some temporary suffering in order to end the inequality which existed in their commercial relations with Great Britain. They realised that their infant manufactures could never permanently establish themselves as long as British merchants with large capitals and extensive trade connections were able to pour their goods into the country while secure in their own markets from all Irish rivalry. The riots that we read of at this time in Dublin[569](javascript:footNote('E900040/note569.html')) were chiefly owing to a bad harvest and commercial depression, although the political agitation concerning the reform of Parliament had something to say to them.


Thus there were two causes which led to a desire for a new commercial adjustment between the two countries. One, which influenced Ireland, was the complaints of the Irish manufacturers based on the differences of import duties in favour of England. The other was the action of the non-importation leagues, which was proving very injurious to British trade and which influenced the British people in favour of a new commercial settlement. At the same time, it was seen in England that the prevailing practice of smuggling Irish goods into Britain was largely due to the enormous duties on their importation. Although the importation of salt from Ireland was prohibited, vast quantities were smuggled into the western parts of Great Britain.[570](javascript:footNote('E900040/note570.html')) There was also a brisk trade in soap and candles, although they too were forbidden to be imported from



---

p.238



Ireland. A witness before the Council of Trade appointed in 1784 reported that ‘great quantities are certainly smuggled into all the western counties of England and Wales and from thence by inland navigation into other counties.’[571](javascript:footNote('E900040/note571.html')) It was thought that if an equalisation of duties took place this contraband trade would cease.


The commercial resolutions seem to have originated in England. As early as March, 1784, **Pitt** was in communication with **Mr. Orde, the Irish Secretary of State**, on the subject of a readjustment of the commercial relations between the two countries.[572](javascript:footNote('E900040/note572.html')) An address sent up by the Irish House of Commons to the King on May 13th of the same year expressing the hope that a plan might be made for a more liberal arrangement of commercial intercourse between Great Britain and Ireland[573](javascript:footNote('E900040/note573.html')) gave a further stimulus to the matter, and convinced **Pitt** that some sort of scheme might be satisfactorily settled. He commissioned **Orde** to make inquiries on all points connected with a final commercial adjustment, and in his correspondence with the Lord Lieutenant we see how a plan was gradually shaping itself in his mind. On October 7th he wrote: ‘I own to you the line to which my mind at present inclines   
[*...*]  
 is to give Ireland an almost unlimited communication of commercial advantages, if we can receive in return some security that her strength and riches will be our benefit, and that she will contribute from time to time in their increasing proportions to the common exigencies of the Empire.’[574](javascript:footNote('E900040/note574.html')) Here we see the idea to which **Pitt** clung so tenaciously of ‘community of burdens’ with
‘community of benefits.’[575](javascript:footNote('E900040/note575.html')) He seems to have been sincere in desiring to give Ireland an equal participation in commerce, and it was only when British prejudice proved too



---

p.239



strong for him that he reduced this ‘equal participation’ to a mere shadow, while still insisting, curiously enough, that he was not departing from his general principle of equality.


There was much difficulty concerning the amount and method of contribution which Ireland should make in return for her new commercial benefits.[576](javascript:footNote('E900040/note576.html')) The Lord Lieutenant warned **Pitt** to go delicately in the matter, for anything approaching the idea of a tribute would be bitterly resented by the Irish people. **Foster**[577](javascript:footNote('E900040/note577.html')) and **Beresford** thought that it would be better to leave the amount and method of contribution indefinite and trust to the liberality of Ireland, which after all, they said, had never failed Great Britain. Even **Orde** hesitated about making the contribution a condition of the scheme. But here **Pitt** stood firm. Great Britain would never consent, he said, to complete the system of equal commerce with Ireland unless some return was definitely and permanently secured to her. And now for the first time he stated the theory which afterwards aroused such indignation in Ireland, the theory that the return made by Ireland ‘ought to be proportioned not merely to what we have now to give   
[*...*]  
 but to all that has been given since the first concessions from the year 1778 downwards.’[578](javascript:footNote('E900040/note578.html')) Ireland, in fact, was now to pay for what had been given to her five years before as a free gift. We can hardly be surprised that the Irish people saw the matter in a different light.


At the same time, **Pitt** did not demand any immediate equivalent for all the advantages Ireland had or was about to receive. What he wanted was a certainty that if the extended commerce of Ireland increased her wealth, the surplus of the revenue which remained after defraying the same proportion of Irish expenses should go to relieve Great Britain. This plan left no room for increased



---

p.240



expenditure in Ireland herself, and no security that the Irish contribution should be in proportion to the resources of the country. **Pitt** insisted that the settlement should be final. **Rutland** had pressed for this as the only way to quiet Ireland.[579](javascript:footNote('E900040/note579.html')) But the Lord Lieutenant feared that **Pitt**'s scheme for an obligatory contribution from the Irish would be difficult to carry. He wrote to **Pitt** that there would be no opposition as regards the commercial points proposed if only ‘some mode and time of contribution (accommodated in any manner to the temper of Ireland) can be fixed. Without this the difficulty is infinite.’[580](javascript:footNote('E900040/note580.html')) He pointed out that Ireland already contributed in many ways of her own free will to the support of the Empire, but that the present proposition was the first instance of an obligatory contribution, ‘and I am much afraid of the effect it may have, not only on that account, but as it may probably extend to that which has heretofore been voluntarily continued; and that occasion may be taken to diminish the one so as to take off the effect of the other.’ In any case the new contribution from Ireland would be very small, and **Rutland** thought that it was a matter of doubt whether it was worth Great Britain's while to stir up strife in Ireland by exacting it.[581](javascript:footNote('E900040/note581.html')) But if the British Government insisted upon making the obligatory contribution a condition of the commercial adjustment, it might be more easily carried in Ireland if provision were made that the contribution should be applied to the support of the fleet in Irish stations, and thus spent in the country. **Rutland** pointed out that this would make no pecuniary difference to Great Britain, while it was the only chance of getting the scheme adopted in its entirety in Ireland.[582](javascript:footNote('E900040/note582.html')) But **Sydney** wrote back that the King's ministers thought that ‘the supply



---

p.241



given should be sent to this country to be employed for the purposes of the general defence.’ He said, however, that if the Lord Lieutenant found it really necessary he might inform the Irish Parliament that there was no objection to declaring in a new clause that the contribution from Ireland should be used ‘in purchasing goods, the produce or manufacture of Ireland, for the use of the Navy, such as stores or provisions.’[583](javascript:footNote('E900040/note583.html'))


The whole scheme, however, progressed, and early in 1785 was completed. It had been discussed in the British Cabinet at the end of the previous year, and on January 6th an official messenger was despatched to Ireland to communicate the unanimous decision of the Cabinet on the matter. In a letter written on the same day to **Rutland**, **Pitt** says that the communication contained the substance of a system from which it would be impossible to depart.[584](javascript:footNote('E900040/note584.html')) The Irish Government, he thought, should have no difficulty in persuading Parliament to accept the resolution with regard to the proposed contribution, as the scheme gave complete equality of trade to Ireland.


**Pitt** certainly anticipated little resistance to his measure. He thought that it would be difficult for ‘malice and faction to find any topics calculated to catch the mind of the public if the nature of the measure is fairly stated.’[585](javascript:footNote('E900040/note585.html')) He acknowledged the justice of Ireland's claim to have her foreign trade unfettered, but he held to the old opinion that she could have no claim to the colony trade beyond what Great Britain chose to give her. The colonies were British, not Irish, for they had been established by means of the men and money of the Mother Country. Ireland had no claim either to a direct trade with them or to a re-export trade in colonial produce to Great Britain. She ought, therefore, **Pitt** argued, to pay for such favours



---

p.242



granted to her by Great Britain, especially as they were a deviation from the almost uniform policy of all nations with regard to the trade of their colonies.


The development of the scheme now passed into the hands of the Irish Government and legislature. **Orde** put the measure into its final form, and on February 7th, 1785, brought ten resolutions embodying **Pitt**'s scheme before the Irish Parliament. **Pitt** was now pledged to these resolutions. He had promised **Rutland** and **Orde** to press the measures through the British Parliament if they could be first got through the Irish Houses. The resolutions were therefore voted upon in the Irish Parliament under the supposition that they were bound up with the good faith of the British Minister.


On the whole the resolutions were favourable to Ireland. Foreign and colonial goods were to pass between Great Britain and Ireland without any increase of duty, and dutiable goods of Great Britain and Ireland were to pass from one country to the other at the same rates of duty. The quantum of duty not drawn back on re-export was to be the same in both countries. Bounties were to be abolished on all goods (except food-stuffs) exported from one country to the other. There was to be no prohibition in either country on the exportation, use, or sale of any article the growth, product, or manufacture of the other. The duties on all articles when different in the two countries were to be reduced in the kingdom in which they were the highest to the amount payable in the other. Finally the tenth resolution laid down that when the hereditary revenue in Ireland should exceed a given sum (at this time it amounted to £650,000) the surplus was to be appropriated in support of the naval forces of the Empire in such manner as the Parliament of Ireland should direct.[586](javascript:footNote('E900040/note586.html'))Ir. Parl. Reg., IV., 116–125.


After these ten resolutions had been read and an order



---

p.243



had been given that they should be printed, the House of Commons resolved itself into a committee to consider the subject. There was a good deal of opposition to the tenth proposition. **Grattan** gave a rather unwilling consent to the first nine, but he altogether took exception to the tenth, on the ground that it would be easy for a Minister so to manipulate the revenue as to produce a large surplus, even though the country might be sunk in debt and poverty at the time. The sum to be contributed was too indefinite, and might rise to an amount out of all proportion to the just contribution of the country. He therefore proposed that no surplus of revenue should accrue to the general expenses of the Empire unless the revenue of the kingdom equalled the expenditure. **Grattan** thought that this would result in greater economy because it would make both the British and the Irish Ministers interested in the cause of economy. The plan would also put an end to debt, while at the same time it would decide the great question of 1753.[587](javascript:footNote('E900040/note587.html')) **Grattan** also proposed that no contribution should be made unless the hereditary revenue exceeded the sum of £656,000.


**Grattan**'s proposals were accepted. The tenth proposition was withdrawn and in its place a new one was put, which stated the expediency of equalising the revenue and expenditure of the kingdom in order to prevent an accumulation of national debt. An eleventh proposition was then added, which provided that whatever surplus the hereditary revenue produced ‘over and above the sum of £656,000 in each year of peace wherein the annual revenue shall equal the annual expense, should be appropriated towards the support of the naval force of the Empire in such manner as the Parliament of this kingdom shall direct.’[588](javascript:footNote('E900040/note588.html')) On February 12th the report from the committee was brought up and the resolutions severally read and



---

p.244



passed, although not without some opposition. **Flood** objected to the third proposition, which precluded all prohibitions on import, from which Ireland might gain, but did not preclude prohibitions on export, from which Ireland was at present suffering. This would enable Great Britain to continue her prohibition on the export of wool. The fourth proposition debarred Ireland from ever adopting protective duties, for the Irish duties, the lowest existing, were to be the port duties of both kingdoms.[589](javascript:footNote('E900040/note589.html')) **Flood** pointed out that these had been found too low to protect Irish industries, and that numerous applications had been made for their increase.


But **Flood**'s efforts were unsuccessful; for although he was supported by a few Members in the House, and although various hostile petitions were sent up by manufacturers who wanted protective duties, the feeling of Parliament was in favour of the resolutions now **Grattan**'s amendment had been accepted, and they passed by a large majority. At the same time the Irish Parliament, in a spirit of generosity and gratitude towards England, voted new taxes to the amount of £140,000 for the year.[590](javascript:footNote('E900040/note590.html')) They did this in order to show the British Government that they had no intention of keeping down the hereditary revenue so as to evade the contribution. But it was made on the strict understanding that the propositions would be accepted in Great Britain. The Irish Parliament relied on the good faith of **Pitt**, who, besides his assurance to the Irish Government, had promised **Foster** that he would get the scheme through the British Houses without any material alteration.[591](javascript:footNote('E900040/note591.html')) **Rutland** seemed satisfied, and wrote to **Sydney** that although in the tenth proposition he had not been able to abide by the strict letter of the Minister's despatch, he had attended ‘in the fullest manner to the spirit of it,’ and that in his opinion the 



---

p.245



object was obtained ‘completely and explicitly and strictly guarded against misconceptions or perversions.’[592](javascript:footNote('E900040/note592.html')) The resolutions now passed to England, and **Pitt** introduced them in the House of Commons in committee on February 22nd in a conciliatory speech.[593](javascript:footNote('E900040/note593.html')) His object was evidently to convince the House that by the measure little advantage was being given to Ireland that had not already been given to her during the administration of **Fox** and **North**, that Ireland could never be in a position to rival Great Britain, and that the chief object of the scheme was to make Ireland now pay for all the favours she had received from England in the past as well as in the present. He thought, however, that the present propositions were founded on justice and expediency. There were, he said, only two possible systems of commercial intercourse between countries situated relatively to each other like Great Britain and Ireland. The one, which made the smaller country completely subservient to the interests of the other, had been tried; it had been a hard and unjust system, and it had been as impolitic as it had been oppressive. But the system was now exploded. Still, although Ireland could do as she liked as regarded her foreign trade, and was at liberty to trade direct with the British colonies, the actual commercial intercourse between Great Britain and Ireland themselves remained unchanged. The alternative system of commercial intercourse had therefore to be tried. This was a participation and community of benefits and a system of equality and fairness, which, without tending to aggrandise the one or depress the other, should seek as its object the aggregate interests of the Empire. **Pitt** was anxious to place the two countries in a situation of commercial equality in which there would be a community of benefits side by side with a community of burdens.




---

p.246


It was unfortunate, **Pitt** lamented, that during the administrations of **North** and **Fox** so much should have been given to Ireland without receiving from her anything in return. His object now was to give Ireland the very little that was still kept from her, and to ask in return a payment on the part of that country for all the benefits received by her five years ago added to the few trifling benefits now to be given.


**Pitt** then went on to impress upon the House the insignificant nature of the advantages which would accrue to Ireland by the new scheme. He believed himself that the permission to export colonial produce to Great Britain would be of little use to the Irish people. All that the concession amounted to was that Ireland should have the privilege of bringing to Britain circuitously what Britain herself was able to bring directly. The circuitous route could hardly be cheaper than the direct route. The freight from the West Indies to Ireland was not very much cheaper than it was to England, and added to it there would be the freight from Ireland to Great Britain, and this had been calculated as one-quarter of the original freight. There would also be double insurance, double commission, double port duties, double fees. It was difficult to believe that under such circumstances Irish merchants could become serious rivals in the British markets.


As to the second great principle of the measure, the equalisation of duties, **Pitt** did not think that Great Britain would suffer. Ireland imposed as a rule a ten *per cent* duty on all British goods imported. Even with this duty British merchants rivalled Irish in their own markets and with their own goods. It was not therefore likely that when the British duties were lowered to the level of the Irish, Irish merchants would undersell the British in the latter's own markets. And besides, any advantage Ireland would gain from low internal taxes would be neutralised by port duties equal to the 



---

p.247



 
difference of the internal duty levied in Great Britain, being added in that country on the equalising principle.


**Pitt** then passed on to his most important point, the return which should be made by Ireland for the advantages given to her. It could not be expected that a specific sum should at once be set aside for defraying the general expenses of the Empire. But the proposal that the Irish contribution should be the surplus of the hereditary revenue was a just one; for in proportion to the benefits Ireland would reap from the concessions of 1779 and 1780 and the present ones, the hereditary revenue must rise, as four-fifths of the whole was raised from customs, excise, and hearth money, all of which must necessarily increase with the growth of commerce. **Pitt** wished the surplus to be irrevocably applied to the general expenses of the Empire, and this, he was afraid, the eleventh proposition did not imply. But as this condition was an absolutely necessary one, he would not call upon the committee to pledge itself to this particular proposition until the Parliament of Ireland should have reconsidered the matter and explained itself more fully. Although he did not doubt the sincerity of the Members of the Irish Parliament, he did not think that in a subject of such moment to Great Britain he could leave anything even to their liberality.


**Pitt** concluded his speech by moving the following resolution: ‘That in the opinion of this committee it is highly important to the general interests of the Empire that the commercial intercourse between Great Britain and Ireland shall be finally adjusted, and that Ireland should be admitted to a permanent and irrevocable participation in the commercial advantages of this country, when the Parliament of Ireland shall permanently secure an aid out of the surplus of the hereditary revenue of that kingdom towards defraying the expense of protecting the general commerce of the Empire in time of peace.’


But in spite of the ingenuity of **Pitt**'s speech, and



---

p.248



indeed of the real truth of everything he said, his arguments were useless against the mass of prejudice and the spirit of commercial monopoly which still held their own in Great Britain. Everywhere there was a storm of opposition. Within the House, **Fox** and **North** denounced the resolutions as destructive of British commerce; outside, the whole country seethed with indignation at the idea of Ireland being admitted to commercial equality. Every manufacturing centre in the kingdom sent up hostile petitions; one, sent from Lancashire, was signed by eighty thousand names. Sixty-two petitions from different parts of the country followed. In London Wedgewood organised the ‘Chamber of Manufactures in England and Scotland,’ consisting of delegates from the chief manufacturing centres, to protest against the resolutions.[594](javascript:footNote('E900040/note594.html')) Their arguments naturally turned on the low taxes and the low price of labour in Ireland,[595](javascript:footNote('E900040/note595.html')) and they declared ‘that a real Union with Ireland under one legislature would take away every difficulty,’ and was the only remedy for all evils and the one solution of all commercial questions. This declaration is noticeable as being one of the first of the many suggestions which were soon to follow for a legislative union between Great Britain and Ireland. Its ruling motive was commercial jealousy and a wish to make the Irish people pay the same taxes as the British. In an anonymous letter amongst the Chatham MSS.[596](javascript:footNote('E900040/note596.html')) we get a characteristic statement of the growing wish to impose the British system of taxation upon Ireland. ‘The richer part of the Irish,’ it runs, ‘can afford to pay our taxes and the poorer sort would be little affected by them; for what tax can reach in any material degree those who live upon butter, milk, and 



---

p.249




potatoes of their own planting? Or if they were affected it would not be probably more than what would oblige them to work an hour more in the week; and at any rate it might be better for the nation that this indolent people did not exist.’


**Pitt** did not hurry the matter and for twelve weeks the House heard witnesses against the propositions. In its present form it was clear that the scheme would never pass and **Pitt** withdrew it, intending to remodel it and make it more acceptable to the nation.


In the meantime the report of the Committee on Trade and Plantations was completed and sent up.[597](javascript:footNote('E900040/note597.html')) This committee had been appointed the previous January by an Order in Council, which referred to it the question of reducing British duties to the level of Irish. It had taken much evidence and most of the manufacturers who had been brought up as witnesses before it were not, in spite of the outcry in the country, particularly hostile to the scheme. The Norwich woollen manufacturers stated that they did not fear the rivalry of Ireland if an equalisation of duties took place, in spite of the cheap wages of Irish spinners. Since the Irish ports had been opened, Irish merchants had not rivalled them in foreign markets, except perhaps in Portugal, as regards coarse stuffs. Irish wool was not as good as English for the ordinary manufacture, while it was unfitted for the finer and more valuable branches. As long as Ireland was prohibited from granting bounties on export, neither the Norwich manufacturers nor the London merchants were adverse to the plan of equalising the duties in the two countries,[598](javascript:footNote('E900040/note598.html')) and they were extremely anxious to bring an end to the Irish non-importation agreements. The iron manufacturers also showed themselves more or less favourable to the scheme, for they witnessed before the Commission that they would



---

p.250



not fear the competition of the Irish in case of an equalisation of duties as long as the duties on bar iron were the same on importation into each country.[599](javascript:footNote('E900040/note599.html'))


As a result of the evidence brought before them, the Committee of Council on Trade proposed: ‘That the two kingdoms agree on certain moderate duties to be imposed on the importation of goods, the growth and manufacture of the other; such as will secure a due preference in the home market for the like articles of its own growth and manufacture; and yet leave to the sister kingdom advantages, though not equal to its own, yet superior to those granted to any foreign country,’ and it added that ‘the duties now payable on British goods imported into Ireland seem, by their moderation, as well adapted to answer this purpose as any that could be devised.’[600](javascript:footNote('E900040/note600.html')) The committee considered that these duties if imposed on Irish goods imported into Great Britain would give the British ‘a sufficient preference in the home market’ and would amount in general to 10 *per cent* besides the expenses of freight, commission, etc., from Ireland. In addition to the duties, the great capitals, and the established skill and credit of English merchants must give them an immense start and enable them to hold their own against all Irish rivalry.


But the committee's report was scarcely listened to. Pamphlets were written denouncing its conclusions and hinting that unfair means had been taken to procure evidence in favour of the new measures. The House of Commons practically took no notice either of the committee or of its conclusions. The opposition in the country precluded all possibility of bringing about a measure which should be fair to Ireland. It was said that if the resolutions were passed Ireland might introduce foreign liquor into Great Britain under false pretences, that she might give bounties to goods exported to the colonies, for this was not




---

p.251



forbidden in the scheme, and so rival England in the colonial market, and even that she might become the mart for colonial produce. England would also lose the monopoly of the East India trade, for as Ireland was given an equal power with Great Britain to trade to Asia, the renewal of the Company's charter would depend upon her consent. The colonies too might suffer from the arrangement, for Ireland was not made to lay any permanent high duties on the produce of foreign colonies. She might, therefore, at any time take off her present high duties and admit foreign colonial produce at the expense of British. It was also feared that if the rates of duty were equalised between the two countries Ireland would cease exporting to Great Britain such raw goods as yarn, kelp, tallow, or unmanufactured iron, and instead would export all these articles in their manufactured state. There were even people who believed that under a system of equal duties the Irish would soon be able to undersell the British in the silk manufacture, the cotton manufacture, the manufacture of new drapery, in the iron manufacture, and in the articles of soap and candles.[601](javascript:footNote('E900040/note601.html')) Such suppositions were, of course, absurd to all who knew anything at all about the condition of Ireland. And with regard to the re-export trade there was only one advantage which Ireland might have gained: if Irish merchants after landing their colonial cargo in Ireland found that the British market for any particular article was more promising than the Irish, they might re-export that article to Great Britain.[602](javascript:footNote('E900040/note602.html')) All this time an argument was going on between the British Ministry and the Lord Lieutenant of Ireland concerning the exact nature of the tenth and eleventh propositions. **Sydney** complained of the precarious nature




---

p.252



of the arrangement, and said that the compact could not be finally closed until ‘the reservation of the surplus should be put out of the reach of future contingencies.’[603](javascript:footNote('E900040/note603.html'))


**Rutland** denied that the tenth and eleventh propositions stood upon a precarious footing. He pointed out that new taxes to the amount of £140,000 had just been granted by the Irish Parliament, and this would amply cover the expected deficiency in the revenue, so that the Irish contribution would begin at once. None of the taxes imposed were such as could possibly lower the hereditary revenue, and in case they fell short in their yield Parliament had passed a vote of credit of £50,000 to make good any such deficiency. At the same time, any measure which put a complete stop to the non-importation agreements would cause a rise in the produce of the hereditary revenue by means of the free introduction of British goods. ‘Upon the whole,’ wrote the Lord Lieutenant, ‘I do not think His Majesty's servants will have cause to complain that the interests of Great Britain respecting the contribution have not been attended to in the most ample and guarded manner.’[604](javascript:footNote('E900040/note604.html')) But at this point in the argument between the two Governments, the opposition in Great Britain made clear that the tenth and eleventh propositions were not the only ones which would have to be altered. No arguments could prevail against the jealous fears of the trading and manufacturing interests, and **Pitt**, as we have seen, was forced to abandon his position and remodel the whole scheme, taking into account every prejudice of the British trader. The Irish Parliament was given no opportunity of revising its decision on the contribution point and many of the resolutions were altered to the detriment of Ireland.


On May 12th **Pitt** once more brought forward the Commercial Propositions, now increased from eleven to



---

p.253



twenty. A few of the new clauses were unimportant and merely related to fishing, patents, and copyrights, but others radically altered the whole scheme. If they had been carried out, they would have placed Ireland in a more disadvantageous commercial position, while at the same time they would have made the Irish Parliament absolutely dependent on the British in all matters of commercial legislation. **Orde** wrote from Ireland that he was most alarmed at the present aspect of proceedings in England, ‘where you seem to think that the system cannot succeed unless you may be able to prove that the trade and manufactures of Great Britain cannot suffer in any article, and that, of course, you make a favour to Ireland of what is neither valuable nor interesting to you; and unless at the same time you can also hold out a compensation for this nothing so productive and permanent that every risk is to be run to bind this country to it.’ He solemnly warned the Government that they were not likely to accomplish their object if they pushed too far upon the feelings and pride of Ireland in matters where British interests were not endangered.[605](javascript:footNote('E900040/note605.html'))


The Twenty Propositions followed in the lines of the original eleven in decreeing that trade was to be as free as possible between the two countries, except as to the export of corn and flour, and of wool from Great Britain. But they stipulated that the Irish Parliament should enact all laws which had been made or which might be made by the British legislature respecting navigation and colonial trade. They struck a blow at the foreign trade of Ireland by commanding the Irish Parliament to enact all laws made in Great Britain prohibiting or imposing duties on goods imported from foreign colonies as well as British. They again interfered with the foreign trade of a country which Great Britain herself had acknowledged to be independent by stipulating that the British Parliament alone was to 



---

p.254




fix the duties not only on goods exported from Ireland to the British colonies in America and the West Indies but even on some of those exported to the United States of America. Ireland was forbidden to import into England arrack, rum, foreign brandy and strong waters which did not come from the British West Indies. Further, as long as Great Britain should choose to give an exclusive charter to a company dealing with the East Indies through the port of London, such as the East India Company, Ireland was to be precluded from carrying on any trade with any part of the world, whether English or foreign, from beyond the Cape of Good Hope to the Straits of Magellan or from importing any goods of the growth, produce, or manufacture of India, China, or Persia except through Great Britain. Finally, the stipulation that no surplus of revenue should be contributed by Ireland in time of peace unless the revenue balanced the expenditure was struck out, and all security that the Irish contribution should be kept within just proportions was done away with.


In the British House of Commons the Opposition took the opportunity to attack the Government. **Fox**, **Burke**, **Sheridan**, and **Eden** all spoke against the new resolutions, but **Fox** was the most vehement in his criticism.[606](javascript:footNote('E900040/note606.html')) He objected to the whole Twenty Propositions as being entirely different to the original eleven. He reprobated the policy of the Government in Ireland in attacking the liberty of the press and the right of public meeting; ‘and now,’ he said, ‘Ministers are desirous of avoiding the consequences of imprudent insult by imprudent concession.’ The sixteenth proposition was a surrender of the East India Company's charter to Ireland, and he would never consent to ask leave of Ireland to renew it. As for the fourth proposition,[607](javascript:footNote('E900040/note607.html')) it directly threatened the prosperity of



---

p.255



the most important British manufactures, besides being an attack on the liberty and independence of the Irish Parliament. The whole scheme was ‘a commutation of English commerce for Irish slavery   
[*...*]  
 Ireland makes an absolute surrender of what is her chief pride — I mean the independence of her Parliament — for a participation the advantages of which Great Britain can always defeat by her resumed power over the Parliament of Ireland. I will not,’ **Fox** concluded, ‘barter English commerce for Irish liberty; that is not the price I would pay, nor is this the thing I would purchase.’


But **Fox**'s fine, if somewhat illogical, speech and the efforts of other Members of the Opposition were unsuccessful.[608](javascript:footNote('E900040/note608.html')) **Pitt** was determined this time to carry his scheme, and hurried the Bill through the House. The manufacturing and trading interests were more or less conciliated, and there was little opposition in the country. At the same time, the feeling of Parliament was in favour of the measure, and on May 30th the Twenty Propositions were again read and passed by a large majority.[609](javascript:footNote('E900040/note609.html'))


But they were to meet with a different reception in Ireland. It has been seen that the chief point with regard to the propositions was that in all laws concerning navigation, the trade with the British colonies, the trade with foreign plantations, and part of the trade with the United States of America, the right of legislation was transferred from the Irish to the British legislature. It was because the resolutions touched their cherished Constitution that the members of the Irish Parliament resisted them so vehemently.


On August 12th **Orde** asked leave of the Irish House of Commons to bring in a Bill based on the Twenty Propositions, and entitled ‘A Bill for effectuating the intercourse and commerce between Great Britain and Ireland on permanent and equitable principles for the mutual benefit 



---

p.256



of both countries.’ His speech[610](javascript:footNote('E900040/note610.html')) was plausible, and every seeming advantage which Ireland might draw from the proposed arrangements was insisted upon, while all the disadvantages were slurred over. His chief points were that the Twenty Propositions were based on the original eleven already consented to by the House; that the two schemes agreed in their general principles, though not in all matters of detail; and that those modifications which had been made were necessary for the acceptance of the scheme in Great Britain. But these modifications were immaterial, while the advantages which would accrue to Ireland if the plan were accepted were great. The Irish sail-cloth manufacture was to be encouraged, the prohibitions on the exportation of rock-salt and bark from Great Britain to Ireland were withdrawn, while British coal was to be exempt from all duty on its exportation to Ireland. **Orde**'s speech on the Twenty Propositions was the precise opposite of **Pitt**'s speech in the British Parliament on the subject of the Eleven Propositions, when greater advantages were proposed to be given to Ireland. **Pitt** had pointed out that most of the advantages to be given to Ireland were already hers. He had ridiculed the idea that Ireland could ever become the mart of Europe for colonial produce; he had argued the improbability of Irish merchants ever rivalling British; he had pointed out that Irish labour was only cheaper than British in the inferior processes. But **Orde**, although his private correspondence shows us that he disliked the Bill, was bound to carry it through to the best of his ability, and so his speech had to be very different to that of **Pitt**. **Orde** tried to impress on the House that by the proposed arrangement Great Britain was making many new sacrifices to Ireland; he told them that Ireland might become an emporium of trade, and that even Great Britain might supply herself with colonial and foreign produce from her



---

p.257




market; he emphasised the preferable commercial situation of Ireland, the cheapness of living and labour, and the low rate of taxation; and he even affirmed that if the propositions were accepted, it would be open to Ireland in the near future to rival Britain herself in commerce and industry.


But the ingenious arguments of **Orde** and his supporters on the Treasury benches were of no avail against the enthusiastic onslaught of **Grattan**, rising to defend the Constitution that he loved, and the careful and detailed exposition of **Flood**, who, taking the propositions one by one, proved that they were in absolute disagreement with the original eleven, and that in nearly every case under consideration Ireland would be in a more disadvantageous position if the Bill were passed.[611](javascript:footNote('E900040/note611.html')) **Flood** pointed out that the second proposition declared that upon the performance of the condition of tribute a full participation of commerce should be given to Ireland. This declaration was falsified by subsequent propositions, which added condition to condition until there were twenty-three in all, and also by subsequent clauses of restriction which showed that Ireland's commercial freedom was to be restricted rather than extended. Ireland was excluded from trade with about one-quarter of the globe, to the most part of which England had no title; the interference with the Irish trade in foreign spirits was bound to injure the trade of the country with France, Spain, Portugal, and America; Ireland's new trade in candles to the West Indies would be ruined; and, most important of all, the independence of the Irish legislature was practically abolished. The proposition which retained all qualified prohibitions existing in British or Irish statutes was unfair, because there were many such prohibitions in British statutes, but none to the prejudice of Great Britain




---

p.258



in the Irish Statute Book. Another result of this same proposition would be that Ireland would have to give up all her bounties, for any bounty granted by Ireland was to be taken into account in the countervailing duty imposed by Great Britain. By means of this principle of countervailing duties Great Britain had found a way by which she could have higher protective duties than Ireland without seeming to have them.[612](javascript:footNote('E900040/note612.html')) Great Britain, too, was to keep her law forbidding the export of raw wool, while Ireland, by clause 14, was prevented from prohibiting or laying duties upon woollen or linen yarn, hides, and all other raw materials which Great Britain required from her in order to work up British manufactures. Clause 7 of the original resolution had, on the other hand, implied that Ireland might take such a step if England adhered to any prohibition not reciprocal. In other ways the propositions had been altered to the disadvantage of Ireland. The original propositions had made the grant to the Navy conditional; that is to say, in time of war the specific surplus was to be given, but in time of peace the contribution was to be conditional upon the revenue balancing the expenditure. The new propositions, on the other hand, established that at no time should Ireland give less than the specified surplus, while in war she might be liable to further demands. The application of the grant was also required to be made perpetual by one Act, whereas the original propositions had conceived the application as a right to be exercised by the Irish Parliament from time to time as circumstances might demand. If a commercial treaty founded on the Twenty Propositions were passed, Ireland might find herself in a very dangerous position. She would be completely at the mercy of the British Parliament in many matters of external legislation, and would have to 




---

p.259



submit to see her custom duties raised or lowered according to the needs or desires of Great Britain.


**Flood**, in fact, objected to the propositions in their entirety. He objected to any definite contribution being made by Ireland to imperial needs, as savouring of the nature of a tribute. It was absurd, he said, for Great Britain to say to Ireland, ‘You support no marine; all the burden falls on me,’ when, over a hundred years ago, Ireland had made a perpetual grant for the support of an Irish navy. England had never allowed this grant to be applied, but had disappropriated the fund and applied it to an overgrown land army, the use of which Great Britain had always had without any expense to herself. **Flood** also was not at all anxious for the establishment of a free trade with Great Britain, for such a free trade would for ever prevent Ireland from improving her manufactures by protective duties. Thus the advantages which the large capitals of English merchants had already given them in the Irish markets would be permanently secured. As for the plantation trade, it was unfair to make it an element in a new bargain, as it had already been granted by **North** in 1779 and 1780.


But although **Flood**'s speech was clear, and in some ways convincing, it was **Grattan** rather than he who, by the sheer force of his enthusiasm, and by his irrefutable logic, gave the great blow to Government by reducing their majority to a mere shadow. **Grattan** had supported the original propositions because he believed that on the whole they would benefit Ireland, and because he knew that Ireland must give as well as take. Ireland could not expect any scheme more advantageous to herself to be passed by the British Parliament, and so **Grattan** agreed even to those clauses which **Flood** had thought so injurious to the interests of the country. But when the British Government returned the propositions, altered in most of their fundamental points, rather restricting than extending the trade of Ireland as a whole, and only throwing open



---

p.260



the British markets at the expense of Ireland's foreign trade; when a scheme was presented to the Irish Parliament obliging it to register the edicts of the British legislature, then the whole spirit of **Grattan** rose in revolt, and he determined to devote all his energies in defence of the Constitution.


The speech[613](javascript:footNote('E900040/note613.html')) of **Grattan** on this occasion was one of his very best. The Duke of **Rutland**, writing afterwards to **Pitt**, described it as ‘a display of the most beautiful eloquence perhaps ever heard,’[614](javascript:footNote('E900040/note614.html')) and, indeed, its effect on the House was almost miraculous. At the same time, it was characterised, as nearly all **Grattan**'s speeches were, by a clearness, a logic, an absolute mastery of facts, which left nothing to be desired, and which reduced his opponents to a state of bewilderment. **Grattan** struck with all his might at the clause which restricted the Irish trade to the East. A monopoly was to be given by Ireland to the present or to any future East India Company during its existence. ‘It has been said that the Irishman in this is in the same situation as the Englishman, but there is this difference—the difference between having and not having the trade.’ There was to be no limitation of time, no trade for Ireland as long as Great Britain should choose to keep such a chartered company. In the matter of colonial produce Ireland was also to give a monopoly to British plantations. Before she had done so only in certain articles, and then with a power of selection, and only as long as she chose to conform to certain conditions. It was one thing to exclude foreign produce by means of temporary laws made in the Irish Parliament; it was quite another to agree to do so for ever, and to give to the British in the West, as well as in the East, an eternal monopoly for their plantation produce, in the regulating and taxing of which Ireland had no share. It was also noticeable that nearly every



---

p.261



article in the British plantations could be got cheaper elsewhere. As for the assertion that under the scheme Great Britain would bear equal burdens with Ireland in the matter of duties, that was worth nothing, for when two countries were so different from one another as Great Britain and Ireland, an equality in burdens must lead in each to contrary results. ‘But from this consideration of commerce a question much more high, much more deep—the invaluable question of Constitution—arises, in which the idea of protecting duties and all that detail vanish   
[*...*]  
 the question is no less than that which three years ago fired and exalted the Irish nation—the independency of the Irish Parliament.’ **Grattan** held the whole scheme to be ‘nothing less than an intolerance of the parliamentary Constitution of Ireland, a declaration that the full and free external legislation of the Irish Parliament is incompatible with the British Empire.   
[*...*]  
 It is an union, an incipient and a creeping union; a virtual union establishing one will in the general concerns of commerce and navigation, and reposing that will in the Parliament of Great Britain; an union where our Parliament preserves its existence after it has lost its authority, and our people are to pay for a parliamentary establishment without any proportion of parliamentary representation.   
[*...*]  
 If any body of men,’ **Grattan** concluded, ‘are justified in thinking that the Irish Constitution is incompatible with the British Empire, perish the Empire! live the Constitution!’


Perhaps it was hardly wonderful that from the point of view of a Lord Lieutenant this speech of **Grattan** should have been regarded as ‘seditious and inflammatory to a degree hardly credible.’[615](javascript:footNote('E900040/note615.html')) But then no Viceroy sent from England could possibly enter into the feelings of a man who had played the chief part in establishing the new free Constitution of Ireland, and who, in his own words on a later occasion, was watching over it in its cradle, and who



---

p.262



was, alas! destined to accompany it to its grave. But for the moment **Grattan**'s triumph was complete. His words were greeted with outbursts of applause from the galleries, which were crowded to overflowing, and from the Members, as many of them rose in their seats and cheered. The cheers within the House were taken up outside, where the Dublin populace were assembled, awaiting the fate of the measure they detested. The speech had confirmed the hesitating suspicions of the Commons that their independence was being violated, and, that once done, the defeat of the propositions was easy. When the House divided on the question as to whether **Mr. Orde**'s Bill should be brought in, there was only a majority of nineteen in favour of Government.[616](javascript:footNote('E900040/note616.html')) Such a majority was equivalent to a defeat, and **Orde** found, on canvassing the House, that he could not count on even a bare majority if the Bill were brought in, for many of the persons who had voted for the previous motion could not be prevailed upon to promise to vote for the Bill itself. There was nothing to be done but to drop the whole matter, and **Pitt** wrote to **Rutland** that, ‘with so doubtful a majority, and with so much industry to raise a spirit of opposition without doors, this is not the moment for pressing further.’[617](javascript:footNote('E900040/note617.html')) The Government dared not risk an absolute defeat by bringing in the Bill.


The enthusiasm of the Irish people at the defeat of the measure was unbounded. The Dublin populace vented their feelings in public illuminations, the non-importation leagues were removed for a short time, Government became unpopular, and the military had to be posted in the streets.


From this time the idea of a legislative union with Ireland began to gain ground in Great Britain. **Pitt** was disgusted by the failure of his scheme. He was determined



---

p.263



that Ireland should not injure British trade by non-importation agreements, and already he had begun to think of the possibility of a union. Subsequent events during the next fifteen years made the Legislative Union not only possible, but, from an English point of view, inevitable.




---

p.264


Progress of Irish Trade and Industry from 1780 to the Union.
------------------------------------------------------------


General Prosperity of the Period — The Woollen Manufacture — The Glass Manufacture — The Cotton Manufacture — The Linen Manufacture — The Silk Manufacture — — The Sugar Refining Industry — The Brewing and Distilling Industries — Efforts to develop Irish Coal — fields and Iron-works — Irish Fisheries — The East India Trade — General View.
The distress which existed in Ireland in the years directly succeeding the repeal of the commercial restrictions was by no means universal or widespread. It seems to have been more or less confined to the artisans of Dublin and its neighbourhood, and was local rather than general in its character. So much had been expected from the grant of free trade, that there was corresponding disappointment when this free trade did not at once bring the prosperity which had been anticipated, and there is no doubt that this feeling of disappointment led to an exaggerated view of the distress which did exist among certain of the manufacturing population of the capital. Certainly the acute commercial suffering of the years from 1776 to 1780 disappeared permanently, and official records show that Irish trade and manufactures sprang up with vitality and rapidity. Broadly speaking, the country began to prosper from as early as 1780; this was stated as an acknowledged fact by the Irish Chancellor of the Exchequer, and was given by him as his reason for lowering the Government rate of interest from 6 per cent. to 5 per cent. Credit indeed recovered almost at once, and we hear nothing more of the difficulty of borrowing 



---

p.265




money or of raising funds by means of fresh taxation. The Irish Commons did much to foster this new prosperity. They could not spend huge sums of money like England in promoting trade and manufactures, but the sums they did spend were wisely allotted. The industrial aspect of Ireland rapidly changed. Ruined factories sprang into life and new ones were built; the old cornmills which had ceased working so long were everywhere busy; the population of the towns began to increase; the standard of living among the artisan class rose; and even the condition of the peasantry changed slightly for the better. Dublin, instead of being sunk in decay, assumed the appearance of a thriving town. Commercial prosperity, combined with the new independent position of the Irish Parliament, brought with it other advantages. Absentees began to return to their country, attracted by the brilliant life of the Irish capital. Dublin became a home of arts and learning. Magnificent public buildings sprang up. The Dublin Society was given liberal grants by the legislature to enable it to encourage Irish manufactures and agriculture. Parliament took the repair of the streets from the hands of a corrupt Corporation; the principal streets were enlarged, and a great new bridge built. At the same time the popular party in the House of Commons took up the cause of the poor. The conditions of prison life were bettered; the criminal law was revised, and, probably for the first time in modern history, free public baths for the poor were established. In fact, the independent Irish legislature set itself to promote the material prosperity of the country in every possible way, and there is no doubt that its efforts had much to say to the really surprising commercial progress which was made from 1780 until the years immediately preceding the Union. The Irish fisheries became the envy and admiration of Great Britain, and agriculture, as we have already seen, increased rapidly. Various manufactures in Ireland began to thrive; the manufacture of hats,



---

p.266




of boots and shoes,[618](javascript:footNote('E900040/note618.html')) of candles and soap,[619](javascript:footNote('E900040/note619.html')) of blankets and carpets, of woollens, of printed cottons and fustians, of tabinets and of glass, all sprang into importance, while the linen manufacture, which had decayed during the American War, quickly revived, and in ten years the exports of various kinds of linen doubled.


All this progress was made whilst Irish manufactures, with the one exception of certain kinds of linens, were denied admittance to the British market, and whilst Irish ports were open to all British goods. The majority of the Members of the Irish Parliament never evinced the slightest wish to retaliate on England by imposing heavy duties on British goods, and it must be remembered that they were at liberty to do so had they wished. In 1790, when applications were made by persons engaged in the leather trade in Great Britain to limit by high duties the exportation of bark to Ireland,[620](javascript:footNote('E900040/note620.html')) Lord Westmoreland, then Lord Lieutenant, opposed the scheme and spoke in high terms of the conduct of Ireland in commercial matters since the failure of the Commercial Propositions. He said that he had never found any desire on the part of responsible men in Ireland to snatch at any commercial advantage for their country at the expense of Great Britain, and that in all matters relative to the trade of the Empire, he had ever found the Irish Parliament ready and willing to meet the wishes of Government.[621](javascript:footNote('E900040/note621.html')) Such words from a Lord Lieutenant are indeed the best proof of the moderation of the Irish legislature in its relations with Great Britain. This moderation is all the more to



---

p.267




be admired on account of the pressure brought to bear on Parliament by the Irish manufacturing interest for protection against British manufactures. But Parliament had no wish to stir up fresh strife, and moreover many of the Members were afraid that if high duties were imposed on British goods England would cease to import Irish linens. This would probably not have injured Ireland to the extent supposed, as there was such a large and growing demand for her linens from America and the plantations. But the Irish Parliament was always nervously anxious not to lose English custom, and it preferred to accept the commercial inequality which existed rather than provoke England to possible retaliation. Indeed, Irish free trade was a mockery as far as England was concerned, and it is because of this fact that the progress of Ireland in trade and manufactures in the years succeeding 1780 is rather surprising.


The Irish woollen manufacturers had anticipated much benefit from the Bill allowing the free exportation of their goods from Ireland. It was the restriction on the woollen trade which had always been resented so bitterly, and the free trade in woollens was coveted more than a free trade in any other article. Immediately there was a boom in the industry. Although the restraints on the export trade were not taken off until December 23rd, 1779, already on January 10th of the following year an entry was made at the Dublin Custom House of 1,300 yards of serge for a foreign market.[622](javascript:footNote('E900040/note622.html')) At the same time, it must be remembered that there had probably been some clandestine exportation of woollen stuffs from Ireland to America before the war.


In the year ended Lady Day, 1780, the number of yards of woollen goods exported from Ireland was 9,377, but in the year ended Lady Day, 1785, this amount had



---

p.268




actually risen to 876,236 3/4. The greater part of this export consisted of materials of new drapery, but the exportation of old drapery and flannels also progressed; little frieze was exported, as most was consumed at home. These woollen goods were nearly all sent to the plantations or to foreign countries, as it was utterly unprofitable to export them to Great Britain, on account of the high duties imposed on their importation. But the amount exported in 1785 could not be maintained. The manufacturers seem to have overreached themselves, and something of a reaction set in, with the exception of flannels. In 1786 the amount of old and new drapery exported fell greatly, but from that year to 1792 it kept up fairly well, and the whole woollen industry was in a prosperous enough condition. After 1792, however, the quantity of new drapery exported began to sink, although that of old drapery and flannels maintained itself for a few years longer. From 1798 to the Union the general export of Ireland fell considerably, owing to the disturbances caused by the Rebellion, and to the universal uneasiness among the business and manufacturing population on account of the approaching legislative Union with Great Britain. The woollen manufacture shared in this general decline of trade, and from 1798 till the Union the exportation of all kinds of woollen stuffs declined. It continued to decline at a rapid rate from the Union till 1823, from which date we possess no separate records of Irish exports and imports.


On the whole, after the first impetus given to it by the removal of the trade restrictions, the Irish foreign trade in woollen manufactures did not progress to the same extent as the foreign trade in other articles. In 1793 a petition before the House of Commons stated that four years previously 2,000 looms had been employed in Dublin and its vicinity, but now no more than 500 were at work.[623](javascript:footNote('E900040/note623.html')) It




---

p.269





| Year ended 25th March | New Drapery: Yards | Old Drapery: Yards | Flannels: Yards | Frieze: Yards | Woollen and Worsted Stockings: Doz. pairs |
| --- | --- | --- | --- | --- | --- |
| 1780 | 8,653 | 494 | 230 |  —  | 127 |
| 1781 | 286,859 | 3,740 | 27,049 | 1,779 | 1,441 |
| 1782 | 336,607.5 | 4,633 | 8,641 | 800 | 277.25 |
| 1783 | 538,061 | 40,589 | 11,416 | 784 | 652 |
| 1784 | 666,298 | 35,329 | 49,382 | 4,174 | 2,201 |
| 1785 | 770,031.75 | 34,249.75 | 60,542.5 | 11,412.75 | 34,276 |
| 1786 | 349,628 | 10,435 | 64,216 | 11,809.5 | 16,959 |
| 1787 | 206,849 | 15,329 | 17,251 | 3,000 | 4,292 |
| 1788 | 315,111 | 7,747 | 61,003 | 4,092 | 7,745 |
| 1789 | 363,196 | 7,833 | 55,015 | 553 | 2,233 |
| 1790 | 352,022 | 8,312 | 64,297 | 183 | 7,601 |
| 1791 | 320,491 | 15,085.75 | 60,850 |  —  | 6,413 |
| 1792 | 384,396 | 18,669 | 65,484.5 | 148 | 5,501 |
| 1793 | 140,294 | 19,489 | 53,033 | 495 | 13,700 |
| 1794 | 206,547 | 21,237 | 86,276 | 413 | 8,361 |
| 1795 | 105,283 | 22,739 | 63,967 | 1,376 | 11,896 |
| 1796 | 174,036 | 128,630 | 96,685 | 117 | 33,548 |
| 1797 | 149,760 | 16,839 | 33,857 | 2,027 | 28,159 |
| 1798 | 94,420 | 1,150 | 3,090 |  —  | 2,071 |
| 1799 | 61,844 | 2,753 | 1,074 |  —  | 1,440 |
| 1800 | 33,288 | 2,196 | 17,352 | 60 | 10,720 |






must, of course, be remembered, that 1793 was a year of trade depression, but the decline in the foreign trade in woollen goods had already set in, and after this year the falling off in the amount exported was very rapid in spite of the general revival in trade. The price of raw wool in Ireland was extremely high, and several years




---

p.270





| Year ended 25th March | New Drapery: Yards | Old Drapery: Yards | Flannels: Yards | Frieze: Yards | Woollen and Worsted Stockings: Doz. pairs |
| --- | --- | --- | --- | --- | --- |
| 1780 | 2,472 |  —  |  —  |  —  | 122 |
| 1781 | 44,047 | 2,399 | 11,303 | 1,195 | 1.434 |
| 1782 | 30,429 | 3,860 | 3,913 | 800 | 274.25 |
| 1783 | 125,226 | 24,588 | 5,609 | 784 | 638.5 |
| 1784 | 258,141.5 | 28,450 | 36,067 | 2,738 | 2,038 |
| 1785 | 242,995.5 | 31,411.25 | 58,495.5 | 11,412.75 | Not entered separately |






| Year ended 25th March | New Drapery: Yards | Old Drapery: Yards | Flannels: Yards | Frieze: Yards | Woollen and Worsted Stockings: Doz. pairs |
| --- | --- | --- | --- | --- | --- |
| 1780 | 5,889 | 494 | 190 |  —  | 5 |
| 1781 | 240,712 | 1,292 | 15,746 | 554 | 7 |
| 1782 | 306,178 | 772 | 4,728 |  —  | 3 |
| 1783 | 511,394 | 38,796 | 9,672 |  —  | 13.5 |
| 1784 | 406,006 | 6,879 | 13,315 | 1,436 | 152 |
| 1785 | 524,976 | 2,838.5 | 1,347 |  —  | Not entered separately |








---

p.271





| Year ended 25th March | New Drapery: Yards | Old Drapery: Yards |
| --- | --- | --- |
| 1780 | 159,428 | 64,346 |
| 1781 | 433,198 | 326,578 |
| 1782 | 547,342.5 | 362,830.5 |
| 1783 | 420,415 | 371,871.5 |
| 1784 | 323,217 | 351,844 |
| 1785 | 140,620 | 156,772.5 |
| 1786 | 251,365 | 315,097 |
| 1787 | 380,708 | 488,415 |
| 1788 | 560,748 | 650,717 |
| 1789 | 518,150 | 647,626.5 |
| 1790 | 504,551.5 | 653,898.75 |
| 1791 | 562,282.5 | 775,060.75 |
| 1792 | 471,227.5 | 808,363.25 |
| 1793 | 372,024 | 815,140 |
| 1794 | 229,943 | 421,227 |
| 1795 | 411,219 | 734,213 |
| 1796 | 539,538 | 1,121,539 |
| 1797 | 483,966 | 1,175,339 |
| 1798 | 253,957 | 836,073 |
| 1799 | 667,417 | 1,269,857 |
| 1800 | 1,264,994 | 2,233,975 |






before 1793 various petitions had complained of its scarcity.[624](javascript:footNote('E900040/note624.html')) The wool produced in the country had deteriorated; this was inevitable, as the restrictions which had prevailed throughout the century on the exportation of woollen manufactures had resulted in wool being grown either for combing purposes or for the manufacture of rough stuffs such as were used by the majority of the people, and Irish wool had in consequence become very 



---

p.272




coarse.[625](javascript:footNote('E900040/note625.html')) In the seventeenth century Ireland had grown good clothing wool, but in 1785 Lord Sheffield tells us that only three counties furnished any quantity of wool, even coarse, suitable for clothing, while the whole amount produced bore no proportion to the quantity of cloth consumed in the country.[626](javascript:footNote('E900040/note626.html')) It was thought that the number of sheep in Ireland had decreased, and that the Irish had not enough wool to supply their own market.[627](javascript:footNote('E900040/note627.html')) These statements, however, seem to have been exaggerated, and they were disputed by many persons. **Laffan**, especially, thought that there was enough wool in Ireland for the whole internal consumption.[628](javascript:footNote('E900040/note628.html')) He makes an elaborate calculation, taking as his basis the population of the island, which he estimates with approximate accuracy as 2,475,000 persons, together with the amount of wool needed to clothe each person and the quantity of woollen cloth imported. For example, the amount of new drapery imported into Ireland for the year 1783 was only 420,415 yards.[629](javascript:footNote('E900040/note629.html')) This would be barely sufficient for a waistcoat and a pair of breeches for 100,000 persons. For the same year the quantity of old drapery imported was still less, only 371,871 yards[630](javascript:footNote('E900040/note630.html')), and this amount would give the same 100,000 persons rather over three yards each for a coat. As for the remaining 2,375,000 men, women, and children, they must be clothed in the native manufacture. It is a well-known fact that the Irish peasant of that time was always clothed entirely in woollen garments, and **Laffan** was of opinion that a stone



---

p.273




of wool was necessary to provide an ordinary labourer with coat, waistcoat, breeches, hat, and two pairs of stockings. After **Laffan** wrote, indeed, the importation of old drapery into Ireland steadily increased, and this was partly due to the growing wealth and population of the country, and partly to the increasing difficulty of manufacturing in Ireland the finer kinds of cloth. There is not the slightest doubt that whether Irish wool had decreased in quantity or not, it had deteriorated in quality, and could not be worked up into the fine broadcloth which was made in England from English wool. And so in those branches of the woollen industry in which moderately fine wool was needed, Irish manufacturers had to import their wool from Spain, as England still prohibited the exportation of her wool to any part whatsoever. This was an added expense in the manufacture of Irish broadcloth. Great encouragement, indeed, was given to this branch of the trade by the Irish Parliament, and the Dublin Society had some time previously established a woollen warehouse in the capital, to which they gave the benefit of the retail trade in fine cloth, paying all the costs of house-rent and storage and only allowing ready money to be paid by purchasers. But in spite of these and other encouragements the importation of Spanish wool did not increase very greatly.[631](javascript:footNote('E900040/note631.html')) Even in those branches of the English woollen manufacture in which the very fine Spanish wool was needed, Ireland was at a disadvantage, for the finest English wool could nearly always be mixed with the Spanish; Spanish wool, too, could be imported into England at a slightly lower rate than into Ireland, while the materials for dyeing were cheaper in Great Britain. It was, therefore, in the manufacture of these rougher and coarser kinds of cloth, commonly known as new drapery, that Ireland made the chief advance, and in 1785 there were complaints from English woollen
 


---

p.274




manufacturers that the Irish were beginning to rival them in foreign markets in this branch of the trade. From 1783 to 1787 there was a decrease in the amount of new drapery exported from England to Ireland, and even from 1787 to the Union the quantity of new drapery imported was always less than that of old drapery.


Certainly, putting aside the merely temporary growth of an export trade in woollen stuffs and the failure to manufacture in any quantity the better kinds of cloth, there was an increase in the Irish woollen manufacture as a whole after the removal of the trade restrictions; this increase, it has already been pointed out, was in the direction of manufacturing the coarser kinds of cloths and stuffs, which had been made in the country all through the century. The real effect of the repeal of the restrictions on the Irish woollen industry was not so much a growth of an export trade or an improvement in the quality of cloth manufactured as an increase in those branches of the manufacture which the Irish had more or less always pursued. The whole industry was naturally stimulated and some industrial enterprise was awakened. Several Irish manufacturers made journeys to England to inspect the woollen factories in the western counties and in Yorkshire, and in this way they gained some knowledge of new machines and new processes. These new machines and methods were introduced into the Dublin factories, and also into a new factory which had been set up in County Wicklow, about thirty miles from the capital. This new factory met with some success; besides the machines imported from England, English workmen and their families were induced to come over.[632](javascript:footNote('E900040/note632.html'))


But there can be no doubt that the admission of English woollen manufactures at very low duties into the Irish market did much to discourage the progress of the Irish industry. Old and new drapery imported into




---

p.275




Ireland from foreign countries were subject to duties equal to a prohibition,[633](javascript:footNote('E900040/note633.html')) but English woollens could be brought into the country on payment of the small duties of 51/2d. a yard on old drapery and under 2d. a yard on new.[634](javascript:footNote('E900040/note634.html')) English broadcloth was far superior to any that could be made in Ireland, and it was also cheaper. It was even found that the English manufacturers could undersell the Irish in their own markets in articles manufactured with Irish yarn, in spite of all the extra expenses of freight and insurance, etc., incident on conveying their goods from England. In consequence, Irish manufacturers clamoured for protective duties against English woollen goods in favour of the Irish trade. It was felt that in spite of the revival in the industry which had taken place, the manufacture could never thoroughly prosper as long as prohibitory duties kept Irish goods from the English market while English manufacturers were permitted to compete successfully with them at home. The Irish traders demanded that they should be put on an equal footing with the English, and they insisted that this could be done only by laying ‘such duties on the importation of woollens as might serve to balance the great capitals of the English, the low price of their wool, and their great exactness in furnishing goods.’[635](javascript:footNote('E900040/note635.html')) There was little spirit of hostility to England. The truth was that Ireland was now in a position to take up a policy of protection just as Great Britain would soon be in a position to take up a policy of free trade. The two countries were at different stages of commercial development, and this was clearly realised by Irish manufacturers. But the idea that their manufacture was hampered by being kept out of the English markets was in reality a false one, for it would have been impossible for Irish manufacturers to have competed successfully with English manufacturers in



---

p.276




the English markets in any branch of the trade. On the other hand, if the Irish Parliament had consented to impose heavy duties on the importation of English woollen goods, the home market for the Irish industry might have been extended, and some encouragement would have existed for the manufacture of the finer and better kinds of cloth.


It is improbable, however, that any possible protective policy could have developed the Irish foreign trade in woollen manufactures to any great extent. That it progressed as much as it did in the face of extraordinary difficulties is a matter of surprise. The revival was considerable while it lasted, but it did not last long. The truth was that the Irish had been excluded so long from the foreign trade that it was impossible for them to begin again at the point where they had left off in 1698. Like the Dutch two centuries before, Ireland having once lost her foreign trade could not permanently regain it. The home trade, however, increased. The amount of woollen goods consumed within the country rose greatly after 1780, and the quantity of both old and new drapery imported during these years did not increase in proportion. At the same time, the exportation of Irish raw wool, yarn, and worsted decreased rapidly.[636](javascript:footNote('E900040/note636.html')) On the whole, there is no reason to doubt that this decrease was mainly due to an increase in the Irish woollen manufacture, chiefly for home uses, although a small part of it may have been the result of a decline in sheep breeding, owing to the growth of tillage. But this decrease of sheep breeding did not manifest itself in any marked degree until after the Union.


The glass manufacture probably made more progress during this period than any other Irish industry. Immediately after the withdrawal of the trade restrictions two glass factories were erected in Cork, one for making bottle and window glasses of all kinds, the other for making all



---

p.277




sorts of plate g1ass.[637](javascript:footNote('E900040/note637.html')) Very soon the glass manufactured at these factories was held to be equal to any made in Europe, while other glass made at Waterford equalled, if not excelled, the same kind made in Great Britain, in spite of the established skill of the British manufacturers.[638](javascript:footNote('E900040/note638.html')) In 1786 the importation into Ireland of all glass except of the manufacture of Great Britain was forbidden,[639](javascript:footNote('E900040/note639.html')) and the new policy adopted in Great Britain of taxing glass while in the process of manufacture left the field clearer for Ireland. During this period a fair amount of glass was exported, the greater part of it being sent to the British settlements and the American States. Before 1782 Ireland had imported all her flint glass from England, but now she not only supplied by far the larger part of her own consumption, but also exported some to America.[640](javascript:footNote('E900040/note640.html')) Even though some of the materials for the manufacture had to be imported from England, and although wages in this industry were higher in Ireland than in England, Irish glass was sold 10 per cent. cheaper than British, and this must be chiefly put down to the duties levied in Great Britain on glass when in the process of manufacture. These duties placed Ireland more or less on an equality with Great Britain in the industry, for they prevented the English glass manufacturers from flooding Ireland with their goods like the woollen and other manufacturers did, and they enabled the Irish to compete with the British in foreign and colonial markets.


Next to the glass industry, the Irish cotton manufacture seems to have made the most progress after the repeal of the commercial restrictions. As early as 1783 the Lord Lieutenant wrote that the printing of cottons had been brought to great perfection in Ireland, and he was




---

p.278





[641](javascript:footNote('E900040/note641.html'))| Year ended 25th March | Ware: £ | Drinking glasses: no. | Cases: no. | Bottles: no. | Vials: no. |
| 1782 | 35 |  —  |  —  |  —  |  —  |
| 1783 | 172 | 9,910 |  —  |  —  |  —  |
| 1784 | 424 | 20,736 | 5 | 532 |  —  |
| 1785 | 770,031.75 | 34,249.75 | 60,542.5 | 11,412.75 | 34,276 |
| 1786 | 593 | 1,680 |  —  | 2,802 |  —  |
| 1787 | 717 | 672 |  —  | 1,320 |  —  |
| 1788 | 220 | 2,136 |  —  | 444 |  —  |
| 1789 | 713 | 8,480 |  —  |  —  | 17,280 |
| 1790 | 768 | 25,236 |  —  | 162 | 10,656 |
| 1791 | 320,491 | 15,085.75 | 60,850 |  —  | 6,413 |
| 1792 | 3,225 | 65,308 | 50.5 | 332 | 19,584 |
| 1793 | 4,197 | 31,234 | 21 | 1,200 |  —  |
| 1794 | 2,065 | 175,157 |  —  | 1,240 | 24,480 |
| 1795 | 5,751 | 139,386 | 9 | 2,676 |  —  |
| 1796 | 5,617 | 234,651 |  —  | 21,961 |  —  |
| 1797 | 8,765 | 589,078 | 66 | 6,121 |  —  |
| 1798 | 2,890 | 61,611 |  —  | 2,855 |  —  |
| 1799 | 2,674 | 58,160 |  —  | 10,455 |  —  |
| 1800 | 3,392 | 48,522 |  —  | 10,543 |  —  |






therefore anxious that the Portuguese should be induced to allow their plain cottons to be sent to the country and to be returned printed to Portugal.[642](javascript:footNote('E900040/note642.html')) In 1784 the Manchester cotton manufacturers attributed the great decrease in their trade with Ireland not only to the non-importation agreements which were then in existence, but also to the fact that the Irish were beginning to make for themselves such articles as fustians, cottons, and calicoes.[643](javascript:footNote('E900040/note643.html')) This progress



---

p.279




was mainly due to the efforts of Robert Brooke, who was the first person to establish the cotton manufacture in Ireland on a large scale and to introduce up-to-date methods and machinery. At his cotton factories at Prosperous, Brooke employed nearly 7,000 persons, while he took as apprentices a large number of children and young people.[644](javascript:footNote('E900040/note644.html')) For a little time he found it difficult to sell his cottons owing to the competition of the Manchester manufacturers and the half-hearted co-operation of the Dublin retailers.[645](javascript:footNote('E900040/note645.html')) Luckily, his goods were staple articles, and at the close of the war fortune came to him. In 1783, three years after Brooke started his enterprise, several Irish merchants, who believed in the possibilities of the manufacture, bought from him a quantity of goods and shipped them to America. From that time the manufacture took a favourable turn; merchants made considerable purchases for the American market; a promising trade was opened up with the Portuguese, and there was some prospect of a trade to Ostend. This success naturally alarmed the Manchester merchants, and the English cotton manufacturers began flooding the Irish markets with their goods, selling them at reduced prices, in order to crush out the new industry. But these attempts do not appear to have succeeded, for there continued to be a general decrease in the amount of English cotton goods exported to Ireland. In the case of printed cottons and calicoes this decrease was especially noticeable, and it was also great in the article of fustians. Mr. Harper, in his evidence before the Committee on Irish Manufactures in 1784, said that cotton printing in Ireland was as good as in England, and that Irish printed cottons were even being smuggled into England.[646](javascript:footNote('E900040/note646.html')) American



---

p.280




importers stated that Irish corduroys were equal to the best British.[647](javascript:footNote('E900040/note647.html')) Altogether, the prospects of the industry were hopeful.


There was a good deal of enterprise connected with the manufacture. The best machinery was imported from England. Besides Brooke's large factory at Prosperous, there were in a few years cotton factories at Slane, Balbriggan, and Finglass in County Dublin.[648](javascript:footNote('E900040/note648.html')) Several English manufacturers set up other factories in County Waterford.[649](javascript:footNote('E900040/note649.html')) Parliament gave a bounty of 88 per cent. on the exportation of fustians, and the Irish Linen Board subsidised Robert Brooke and made loans to manufacturers.[650](javascript:footNote('E900040/note650.html'))


In 1793, owing to the general stagnation of trade, several cotton manufacturers in Ireland failed. English merchants took the opportunity of pouring their goods into the country at prices less than the prime cost. During the next year several Irish manufacturers sent up petitions to Parliament stating that this action of the Manchester merchants threatened to annihilate their industry and praying for protective duties.[651](javascript:footNote('E900040/note651.html')) The cotton manufacture was now well established in Ireland, and its success seemed necessary to the prosperity of the country. The non-importation agreements had ceased, and after some pressure Parliament at last went back from its policy of refusing to impose high duties on British goods and laid heavy duties on all cottons imported into Ireland, British not excepted. These duties were not so high as those levied in Great Britain on the importation of cottons, but
 


---

p.281




they were very heavy. Duties from 40 to 50 per cent. ad valorem were levied on plain calicoes, and 35 per cent. on plain muslins, while the duties were at a slightly lower rate on coloured, worked, or figured cottons. This protective policy stimulated the industry. There was now a large cotton manufacture at Belfast, and during the closing years of the century the whole cotton industry became so prosperous that it threatened to rival the linen manufacture, and many linen weavers began to take to cotton weaving. At the time of the Union the cotton industry ranked next to the linen in value, and there were in existence thirteen cotton mills capable of working up 500,000 pounds of cotton, while much capital was invested in the industry.[652](javascript:footNote('E900040/note652.html')) Fustians were still imported from England, but the whole consumption of Ireland in calicoes and muslins was supplied by herself. The home trade in cotton goods was very much greater than the foreign trade.


All this time the linen manufacture continued to develop satisfactorily. The exports of plain linen cloth increased enormously from 1780 to 1796, the comparative fall during the last four years of the century being, of course, due to the general condition of the country. A thriving trade in coloured linens to the American States and the British plantations was opened up. Nearly all the coloured linen exported was sent to these places, for it was still excluded from the British markets by duties equal to a prohibition, whilst most of the Continental nations imposed heavy duties on the importation of these articles. A fair amount of cambric and lawn was also sent to America and the plantations, and at the beginning of the war with France it seemed likely that a demand might arise in Great Britain. As a result the manufacturers increased their output, but in 1794 an Act[653](javascript:footNote('E900040/note653.html')) was passed in Great Britain allowing French cambric and lawn to be imported by way



---

p.282




of the Austrian Netherlands. This caused some distress in the Irish industry, for merchants found themselves with stock on their hands of which they could not dispose.[654](javascript:footNote('E900040/note654.html')) Fortunately the Act only lasted two years, and the distress in the trade was merely temporary. Thread stockings and a considerable amount of mixed linen, silk and cotton goods were also exported. The Irish foreign trade in linen goods was now far superior to that of Scotland, in spite of the encouragement which the latter country had received for nearly a century. In the article of plain linen cloth alone Ireland exported well over 469 million yards, as against 23 million exported from Scotland.[655](javascript:footNote('E900040/note655.html'))


Some progress was made in the silk industry, but little was exported, only a few pounds of manufactured and thrown silk and a few pairs of silk stockings every year. It was difficult for Ireland to compete in the trade, for she could not get her raw silk cheap like England, who had the monopoly of East India silk. Ireland took her raw silk chiefly from England, and thus the materials for the manufacture cost her more. It was in the manufacture of tabinets and poplins and other mixed goods that the Irish excelled. During this period there was a flourishing tabinet manufacture in Dublin and its neighbourhood, which gave employment to a considerable number of persons. Some quantity was exported, but never to any great amount; the greater part was consumed at home.


The sugar-refining industry was a subject of much agitation during these years. In 1780 it was agreed that Ireland should have a free trade to the colonies on condition that all colonial commodities should be imported into and exported from Ireland subject to the same duties under which they were imported into and exported from Great Britain. Sugar was one of these commodities. The duty payable in Great Britain on the




---

p.283





| Year ended 25th March | Plain Linen: Yards | Coloured Linen: Yards | Cambric and Lawn: Yards | Mixed Goods: £ |
| --- | --- | --- | --- | --- |
| 1780 | 18,746,902 | 7,319 | 21 | 145 |
| 1781 | 14,947,265 | 111,295 | 404 | 414 |
| 1782 | 24,970,303 | 74,422 | 16 | 1,148 |
| 1783 | 16,039,705 | 160,127 | 1,975 | 8,319 |
| 1784 | 24,961,898 | 347,098 | 5,734 | not entered |
| 1785 | 26,677,647 | 226,186 | 3,686 | 9,382 |
| 1786 | 28,168,666 | 359,731 | 1,052 | 4,443 |
| 1787 | 30,728,728 | 264,421 | 3,745 | 5,216 |
| 1788 | 35,487,691 | 157,723 | 4,876 | 7,345 |
| 1789 | 29,344,633 | 104,598 | 2,739 | 4,616 |
| 1790 | 37,322,125 | 144,088 | 5,877 | 14,522 |
| 1791 | 39,718,706 | 116,037 | 8,475 | 9,628 |
| 1792 | 45,581,667 | 108,703 | 11,270 | 16,998 |
| 1793 | 43,312,057 | 123,862 | 2,712 | 14,339 |
| 1794 | 43,257,764 | 108,058 | 3,306 | 19,379 |
| 1795 | 42,780,840 | 282,501 | 7,325 | 45,115 |
| 1796 | 52,895,841 | 715,341 | 5,726 | 25,563 |
| 1797 | 36,559,746 | 483,715 | 14,034 | 12,619 |
| 1798 | 33,497,171 | 189,885 | 6,949 | 14,546 |
| 1799 | 38,466,289 | 356,740 | 3,903 | 5,345 |
| 1800 | 35,676,908 | 213,142 | 13,242 | 10,940 |






importation of raw sugar was 7s. 2 1/2d. per cwt., and in Ireland 1s. 8d.; it was therefore necessary to add 5s. 6 1/2d. per cwt. to the Irish duty.[656](javascript:footNote('E900040/note656.html')) This addition was made, and in consequence the prices of refined sugar in Ireland rose. But there were at once demands for a duty on English refined sugars, because the bounty given in Great Britain on the exportation of refined sugars was 2s. 6d. per cwt. more than the duty paid on the importation of raw sugar. This was, of course, equal to a premium of 2s. 6d., and



---

p.284




was believed to have enabled the British refiners to undersell Irish refiners in the Irish markets. The latter therefore sent up a petition to Parliament praying for such a duty on the importation of refined sugars as would secure
to them an advantage in their own markets.[657](javascript:footNote('E900040/note657.html')) The petitioners were supported in the House of Commons by **Flood** and **Grattan**, and for a long time there were lengthy debates on the subject. Very heavy duties were at first proposed by the popular party, but Government managed to reduce their proposals to a more moderate figure. Eventually it was decided — in 1786 — that all refined sugars coming from Great Britain or the British colonies were to pay additional duties; refined sugars in loaves, not being bastards, were subject to a duty of £1 16s. 9 1/2d. per cwt., on bastards the duty was 18s. 4d. per cwt., while other refined sugars were rated in proportion.[658](javascript:footNote('E900040/note658.html')) At first there was a good deal of discontent in Dublin, for the new duties combined with the original ones did not amount to anything like the import duty on refined sugars levied in Great Britain.[659](javascript:footNote('E900040/note659.html')) Meetings were held by the sugar refiners expressing their dislike of the action of Government, and there was some idea of establishing an association not to import British sugars. The idea, however, fell through, owing to a want of agreement among the parties interested, and after a time the agitation died down. This was probably due to the increasing prosperity of the Irish sugar-refining industry, for as far as can be judged from the entries in the Commons Journals it did make considerable progress from this time till the Union. Irish refiners were, however, at a disadvantage compared with British, for the duty on the importation of refined sugars was about one-third less in Ireland than in Great Britain, while the British refiners had the further advantage of a large bounty on the exportation of their sugars, 



---

p.285



which more than neutralised the import duty on raw sugars.


The condition of the Irish brewing industry attracted attention during this period.[660](javascript:footNote('E900040/note660.html')) The Irish Government and Parliament were both anxious, chiefly upon moral grounds, to promote brewing at the expense of distilling. In 1791 the Lord Lieutenant wrote that ‘a number of very respectable persons, reflecting upon the great mischiefs to society which was daily felt from the immoderate use of spirituous liquors,’ had solicited the assistance of Government to remedy the evil. The chief measure suggested for remedying the abuse was the encouragement of breweries and the discouragement of distilleries. It was said that the bounty of 1s. per barrel granted upon British beer exported to Ireland prevented any progress being made in the Irish brewing industry, and Westmoreland recommended either that this bounty should be removed or that a higher duty should be imposed on the importation of British beer. The discouragement of the distilling industry was to be effected by an additional duty upon home-made spirits, and by a stricter execution of the laws against private distilling. It was thought that the country gentry would not be against this scheme, ‘especially if they can be convinced that, malt liquor being substituted for spirits, the consumption of the produce of their lands, and consequently their rents, will not be diminished.’[661](javascript:footNote('E900040/note661.html')) The suggested duty on British beer imported does not seem to have been imposed, for the British Ministry wrote that the bounty paid on the exportation of beer to Ireland, as well as to other countries,



---

p.286




only took place under certain conditions, and was balanced by the excise duties paid on malt and hops used in brewing the beer, as such duties were not drawn back on the exportation of the finished product.[662](javascript:footNote('E900040/note662.html')) The excise duty on beer in Ireland was, however, lowered by the Irish Parliament, and an additional duty of 6d. per gallon was laid upon home-made spirits. This additional duty necessitated a higher duty on imported spirits, and further duties of 8d. per gallon on rum and 10d. per gallon on brandy and other foreign spirits was levied.[663](javascript:footNote('E900040/note663.html')) The result of the change in duties was that a barrel of malt distilled paid almost 4s. more than a barrel of malt brewed, and in proportion to the strength of the beer its relative advantage over spirits increased.[664](javascript:footNote('E900040/note664.html')) The restraint on the immoderate use of spirits was also assisted by the regulation of licences,[665](javascript:footNote('E900040/note665.html')), and the brewing industry was encouraged still further by the admission of foreign hops into Ireland at an additional duty of 1d. per pound above the duty payable on British hops,[666](javascript:footNote('E900040/note666.html')) when the price of hops was £9 sterling per cwt.[667](javascript:footNote('E900040/note667.html')) The Lord Lieutenant's Secretary wrote that he hoped that this would prevent foreign hops from interfering with British, except in times of scarcity.[668](javascript:footNote('E900040/note668.html')) As a result of these new regulations the recent decline in the Irish brewing industry was checked, and the output of beer and porter has continued to increase up to the present day. The progress of the brewing industry was not, however, coincident with a decline in the Irish distilling industry, in spite of the new taxation. Small distilleries disappeared, but the large ones increased their output, and the total amount of spirits distilled steadily rose. In 1780 the total produce of the distilleries was 1,227,651 gallons.



---

p.287




This had increased to 3,497,596 gallons in 1792, just as the new policy of encouraging the breweries was being adopted; but in 1798 the total amount of spirits distilled increased to 4,783,954 gallons.[669](javascript:footNote('E900040/note669.html')) Of course, it must be remembered that illicit distillation was probably more widespread in the earlier years, and this would not be included in the official figures. With the growth of large distilleries and the disappearance of the numerous small ones, which had formerly existed, illicit distillation became more risky, and consequently decreased. The excise duty paid on spirits in Ireland was, however, very much lower than that levied in Great Britain.


Some efforts were made to develop the mineral resources of Ireland. The Irish coalfields had been economically of little importance, and had merely yielded a small supply for home consumption. From 1783 onwards various plans were set on foot for increasing the supply. Witnesses stated before the House of Commons that 10,000 tons of Kilkenny coal were sold annually in Dublin, and that if this coal were reduced in price by means of increased facilities for land transit, its consumption would be increased tenfold, as Kilkenny coal was as good as any produced in England for furnaces and for kitchen purposes. It was said that 20 cwt. of Kilkenny coal would last as long as 36 cwt. of the best Whitehaven, and that the coals of the Lough Allen collieries were equal in quality to the best Whitehaven. These optimistic witnesses insisted that the whole kingdom might easily be supplied from the Kilkenny and Lough Allen collieries, so that ‘the manufactures of Birmingham and Sheffield might be established in Ireland.’[670](javascript:footNote('E900040/note670.html')) There were also great quantities of ironstone at the Arigna ironworks, in the county of Leitrim, which could be raised at 2s. 6d. per ton.[671](javascript:footNote('E900040/note671.html')) But whether these statements were accurate or not,



---

p.288




little success attended the efforts which were made to develop the coalfields and ironworks of Ireland. It was difficult to raise sufficient capital, and the expenses of land carriage were so great that it was cheaper for Dublin merchants to obtain their coal from England. Only a small part of the consumption of the country continued to be supplied by the Irish coalfields. After the Union various spasmodic efforts were made to raise larger supplies of coal in Ireland; but again the difficulties of transit proved too great, and some of the mines were abandoned as unprofitable early in the nineteenth century. In more recent years, however, there has been some increase in the output of Irish coal. For the past few years there have been twenty-four mines at work in the different coalfields employing one thousand persons and raising annually 125,000 tons.[672](javascript:footNote('E900040/note672.html')) This figure appears very small when compared with the 30,000,000 tons produced annually by Scotland, but there is no doubt that greater transit facilities from the mines to the main lines of railway might do much to increase the local use of Irish coal and encourage the industry.


The efforts of the Irish Parliament to develop Irish resources in another direction met with greater success. Irish fisheries now sprang into importance by means of a careful system of bounties and a wise system of inspection of all fish exported. In 1778 only forty fishing vessels had existed in Ireland, but in 1781 there were 333 fishing vessels eligible for bounty. In the following year this number had increased to 700, while there were three large ships of 200 tons each too large to receive the bounty, and many other vessels which carried less than the requisite number of tons.[673](javascript:footNote('E900040/note673.html')). In this year — 1782 — the idea was started of exporting Irish herrings to the West Indies in bulk. The experiment was tried, the fish sold at



---

p.289




Barbadoes at half the market price, and a clear profit was made of £200 upon a vessel of sixty tons after all expenses of wages and freight, etc., had been defrayed.[674](javascript:footNote('E900040/note674.html')) Whether this policy of giving bounties on fishing vessels would have permanently placed the Irish fishing industry on a secure basis is difficult to say, and it cannot but compare unfavourably with the modern policy of developing fishing by means of increasing transit facilities. The Irish Parliament followed the ordinary policy of the time, and the bounties which it gave seem to have been better organised than those which were granted in Great Britain. Much of the success which attended the development of the Irish fisheries was, however, due to the thorough system of inspection before exportation which was applied to the fishing as well as to other industries. The Irish Parliament was anxious to secure a good reputation in foreign markets for Irish goods. British witnesses testified that Irish herrings were sought after more than their own because of the unimpeachable character of all Irish fish.[675](javascript:footNote('E900040/note675.html')) Often the West India fleet leaving the Clyde would go to Cork to ship Irish herrings. Irish fishermen went to different parts of Scotland to teach the people fish curing, while others went further afield and established a ‘great fishery on the banks of Newfoundland,’ which, in 1785, ‘increases daily.’[676](javascript:footNote('E900040/note676.html')) So high stood the name of Irish fishermen for honesty of dealing that their herrings sold 14 1/2 per cent. cheaper than the Scotch, and they were never charged with the frauds and tricks which had nearly destroyed the sale of British herrings in European markets.[677](javascript:footNote('E900040/note677.html')) The same system of inspection which was applied in Ireland to fish was also applied to beef and pork, and the English Inspector-General of exports and



---

p.290




imports stated that, in his belief, Ireland was in no small degree indebted to this regulation for the superior quality and character of her meat and the higher price which it fetched in every part of the world.[678](javascript:footNote('E900040/note678.html'))


The East India trade was the subject of much discussion during this period both within Parliament and outside. As the Commercial Propositions had failed, Ireland was at liberty to trade direct to the East on her own account. There was a great deal of disagreement as to whether this direct trade was commercially possible. In a report sent up to **Pitt** on the subject it was stated that it was probably impossible for Ireland to export any goods to the East upon equal terms with England. Bullion could not be sent at all, and woollens, jewellery, and all other manufactures required in the trade could be supplied cheaper by English merchants. The want of credit and capital would greatly hamper Irish traders, and, in fact, ‘the same causes which have prevented the foreign companies who have small possessions in India from succeeding in competition with the British East India Company will for ever operate against an Irish trade to the East Indies.’[679](javascript:footNote('E900040/note679.html')) But a party in the Irish Parliament was anxious to preserve to Ireland the right of trading to the East, because even though a direct trade might not be profitable all at once, a new trade through different channels might in the future arise within the countries contained in the East India Company's charter, in which it might be possible for Irish merchants to engage with some prospect of success. It was argued that a beginning had to be made, and that England had not built up her trade to the East all in a day. Time would give the necessary credit and capital to Irish merchants. But the



---

p.291




majority of the Irish Commons were afraid of rousing the hostility of England by starting a direct trade between Ireland and the East, and they began to co-operate with Government in order to arrive at some satisfactory settlement, while leaving the monopoly of the East India trade in the hands of the Company. **Mr. Beresford** and **Sir John Parnell**, two of the Government's supporters in the Commons, were requested to draw up a memorandum concerning the legitimate demands of Ireland in regard to the trade, and in May, 1793, the report was sent up.[680](javascript:footNote('E900040/note680.html')) It was pointed out that Ireland lay under great disadvantages, because none of the Company's ships touched at her ports and all East India commodities came to her burdened with the extra expense due to their carriage from England, while Irish goods had first to be sent to England before they were taken by the Company. It was therefore suggested that the goods of Ireland should be carried out to India upon the same terms and with the same advantages as those of Great Britain, and therefore that one of the Company's ships should touch at Cork once every year to carry out such goods. In return for the monopoly of Irish consumption the East India Company should either supply that consumption direct from India, or should arrange their prices so that the increased expense due to the carriage from England to Ireland should not fall upon Irish consumers. Ships, the property of Irish subjects, should be entitled to the same liberty of navigating the seas from beyond the Cape of Good Hope to the Straits of Magellan as was allowed to ships the property of British subjects. In return for all this it was suggested that the Irish Parliament should give up all idea of trading to the East as long as the East India Company existed, and should agree to confirm the Company's charter for any term of years that England might grant it.



---

p.292




So far Ireland had not contravened the Company's charter, and by a clause in the Revenue Bill she had annually prohibited since 1782 the importation of tea except from England.


Most of the suggestions of **Mr. Beresford** and **Sir John Parnell** were accepted by Government, and on June 20th **Major Hobart, the Chief Secretary**, moved for leave in the Irish House of Commons to bring in a Bill ‘for regulating the trade of Ireland to and from the East Indies under certain conditions, and provisions for a time to be therein limited.’ He emphasised the advantages which would arise to the commercial interest of the Empire, and pointed out that under the Bill the people of Ireland would be placed in the same position as the people of Great Britain, for the East India Company would be bound to send annually to Cork a ship of 800 tons to take on board such articles of Irish manufacture as might be exported from hence to the East.[681](javascript:footNote('E900040/note681.html')) The Bill passed two readings, and on July 4th there was a debate on the subject in the Commons before the House resolved itself into a committee. **Grattan**, at last, gave an unwilling consent, the committee agreed to the measure, and the Bill passed its Third Reading on July 11th. Westmoreland wrote that the Bill had passed ‘with a degree of liberality which I must say does very great honour to the House of Commons.’[682](javascript:footNote('E900040/note682.html')) The new construction which had been given to the Navigation Acts, and which had resulted in allowing Ireland to re-export West Indian goods to Great Britain, was the chief cause of the alacrity with which the Irish Commons acceded to the wishes of Government. Two of the most important commercial questions which had agitated the two countries in 1785 were thus settled, and Westmoreland wrote that



---

p.293




the remaining points ought to admit of easy adjustment. He advised that the commercial intercourse between Great Britain and Ireland should be established upon clear and permanent principles, as this would do away with the clamour for protective duties, and would prevent the clashing of drawbacks and bounties.[683](javascript:footNote('E900040/note683.html')) Hobart wrote triumphantly that he hoped the conduct of the Irish Parliament would prove to the British Ministry that he was right when he urged the expediency ‘of treating Ireland with liberality, and for once conferring a favour without letting it appear to have been extorted.’[684](javascript:footNote('E900040/note684.html'))


A study of the commercial and industrial history of Ireland during those twenty years from 1780 to the Union certainly shows that material progress was being made, and that the Irish were beginning to evince a spirit of industrial enterprise. Of course many checks and drawbacks had to be encountered, and it was difficult for Ireland to compete successfully with those other nations which had such a long industrial start. The effects of the commercial restrictions could not but remain in the country, even after the restrictions themselves had been removed. This is why the foreign trade in woollen goods could not keep at the high level it had attained in 1785; it was one of the chief reasons why Irish manufacturers were possessed of such little capital and Irish artisans of such little skill; and it was the main reason why in later years Irish industries dwindled and decayed under the stress of British and foreign competition brought about by the new policy of free trade. But that so much progress was made in spite of the still existing commercial inequality with Great Britain says something for the elasticity of the country and for the new spirit of enterprise which commercial and political freedom had awakened among the Irish people. From 1704 to 1782 the general export of Ireland increased from one to thirty-two, but in fourteen



---

p.294




years, from 1782 to 1796, it rose from thirty-two to eighty-eight.[685](javascript:footNote('E900040/note685.html')) We hear little of the old complaint of want of employment in the towns, except during two or three years of localised distress, for the growing manufactures kept all hands at work. At the same time, there is some reason to believe that the condition of the peasantry changed slightly for the better. The extension of tillage made their position less precarious, and it was not until after the Union that the evils due to the too sudden increase of arable farming began to appear. The famines, which had occurred so frequently all through the century, disappeared for the time being, and the new national feeling did something to establish more humane sentiments towards the peasantry. The class of resident landlords was larger than it had been since the beginning of the century, and especially during the volunteer movement Irish landlords wished to appear at the head of a prosperous tenantry. On the whole this short period of legislative independence in Ireland was by far the most prosperous period which the country had ever experienced. The Irish Parliament included among its Members many brilliant and capable men, who knew by what means they might best promote the prosperity of their country. The pity was that they had only a short twenty years in which to work, and that when the Union took place the industrial life of the Irish people was not fully or firmly enough established to benefit by the new connection. From a material point of view the Union achieved nothing for Ireland, simply because the two countries were too different in their economic life to allow of both reaping equal benefit from the operation of the same commercial system. Almost directly after the Union there began a decline in Irish trade and industry, slow at first, but afterwards very rapid, a decline which only quite recently has begun to be arrested. It is indeed doubtful whether, even at the



---

p.295




present day, Ireland is much richer than she was in the years before the Union. Her population is a little less, the percentage of the population employed wholly or partially in manufacturing industry is less, there is a greater gulf fixed between agricultural and industrial pursuits, so that the mass of the people are thrown far more entirely upon the land. On the other hand, the material condition of the Irish poor has certainly improved in recent years, although this improvement is by no means commensurate with the progress which has been made amongst the lowest working classes in Great Britain.




---

p.296


Irish Finances from 1782 to the Union
-------------------------------------


Improvement in Irish Finances from 1782 to 1793 — Financial Policy of the Irish Parliament — The Responsibility, Pension, and Place Bills of 1793 — The French War and increased Military Expenditure — Continued Prosperity of Ireland — Outbreak of the Rebellion and further military Expenditure — Universal Distress — Irish Expenditure from 1793 to 1797 — Irish Expenditure from 1797 to 1801 — Increase of Irish National Debt — Commercial and financial Distress after 1797 due to the Rebellion combined with the
increasing Cost of the French War.
During the first eleven years of legislative independence the expenditure of Ireland kept fairly level, averaging about one and a quarter millions per annum. In the three years 1787, 1790, and 1793 there was a small surplus of revenue over expenditure, and in the other years the deficit was insignificant.[686](javascript:footNote('E900040/note686.html')) In 1783 the deficit had been much larger, but it was successfully reduced through the efforts of the Opposition party in the Irish House of Commons, and for the next ten years the condition of the finances was flourishing. The equilibrium maintained between revenue and expenditure during these years says a good deal for the financial policy of Parliament, when we remember that just at this time new sums were being spent in encouraging trade and manufactures, and in developing the natural resources of Ireland. But directly after the grant of legislative independence **Grattan** and other Members of the Opposition succeeded in inducing Parliament to grant additional duties, estimated to produce £14,000[687](javascript:footNote('E900040/note687.html')) a year, in 



---

p.297



order to do away with a deficit which for some time past had been steadily increasing. These new duties, combined with a policy of strict economy on the part of Parliament, practically restored equilibrium, and from 1785 to 1794, when the cost of the French War began to be felt, the annual deficit was never higher than £89,434 (British), and was generally very much less, while in 1790 there was an actual excess of revenue over expenditure amounting to £85,397 (British).


No economy was effected by the Irish Parliament at the expense of England; on the contrary, generosity and loyalty were shown. In May, 1782, **Grattan** proposed a vote of £100,000, to be obtained by loan, for the purpose of raising 20,000 sailors for the Royal Navy.[688](javascript:footNote('E900040/note688.html')) Curiously enough, although the proposal was accepted by the great majority of the House of Commons, it was found later, on an inquiry by a committee appointed for the purpose, that not more than one-half of the sum voted was actually spent and that only 7,000 men had been raised.[689](javascript:footNote('E900040/note689.html')) A further offer, however, of aid to England soon followed. An Act[690](javascript:footNote('E900040/note690.html')) was passed allowing the temporary withdrawal to England of 5,000 out of the 12,000 men on the Irish military establishment ordered by the Irish Act of 1769 to be always retained in Ireland. But only partial advantage was taken of this offer also, and it was in consequence not renewed.


In November, 1783, a party in the Irish House of Commons, headed by **Flood**, made a vigorous attempt to reduce the number of troops maintained by Ireland. But **Grattan** opposed any reduction of the military establishment. He pointed out that the rising trade of Ireland was being protected by the British Navy, and that the Irish payment of about £70,000 a year to maintain Irish troops to serve abroad was not a dear purchase ‘for partaking that which has cost England so many millions.’



---

p.298


**Grattan** managed to carry his point and **Flood**'s motion was accordingly negatived.[691](javascript:footNote('E900040/note691.html'))


It has been seen in the account given of the Commercial Propositions how anxious **Pitt** was to secure from Ireland some fixed contribution to the general expenses of the Empire, such contribution to be applied either to the support of the Imperial navy or to the reduction of the British debt.[692](javascript:footNote('E900040/note692.html')) The Irish Parliament had shown itself quite willing to make some settled contribution, conditional on an equilibrium between revenue and expenditure in years of peace, but unconditional in time of war. But the jealousy of the British manufacturing interest had forced **Pitt** to modify the propositions, greatly to the disadvantage of Ireland, and in consequence they had been thrown out by the Irish Parliament chiefly on constitutional grounds. With the abandonment of the scheme all idea of securing from Ireland a fixed money contribution to Imperial expenses fell to the ground and was never again renewed in its original form. And so until the commencement of the war with France Ireland merely continued to maintain her military establishment of 15,000 men, 3,000 of whom were liable to serve abroad according to the Act of 1769, as her permanent fixed contribution to Imperial needs.


From 1785 to 1793 the Opposition party in the Irish House of Commons, headed by **Grattan**, devoted their attention to securing some sort of administrative reform. For some time **Grattan** had supported the administration, in the hopes of effecting the desired reforms through the influence of Government. But when it became clear that Government was opposed to all reform, and that pensions were being granted and offices created for the express purpose of obtaining parliamentary influence, he again threw in his lot with the Opposition. In 1790 the number



---

p.299



of placemen and pensioners in Parliament was declared to be equal to one-half of the whole efficient body.[693](javascript:footNote('E900040/note693.html')) The pensions on the Irish establishment, exclusive of military, were in 1789 £105,739[694](javascript:footNote('E900040/note694.html')), and it was said that fresh pensions to the amount of £16,000 had been granted since March, 1784, besides additional salaries to sinecure offices in the hands of Members of Parliament, while during the same period the whole civil list had increased by £31,000.[695](javascript:footNote('E900040/note695.html')) There had also been a rise in the amount of the military pensions, and the cost of collecting the revenue had increased since Lady Day, 1784, by £105,000.[696](javascript:footNote('E900040/note696.html')) The large additional salaries to sinecure or utterly insignificant offices were granted in order that the names of the recipients should not appear in the pension lists, so that a sort of inferior and corrupt pension list existed. What **Grattan** and his party wanted was to check this extravagance and corruption on the part of Government by means of legislation. They wished for a Pension Bill limiting the amount which could be granted in pensions: for a Bill to disfranchise the revenue and Custom House officers, as had been done long ago in England, and they also desired to pass a Bill giving additional guarantees for a proper expenditure of different branches of the revenue. The Opposition also did their best to procure an enquiry into the cost of collecting the revenue, for this cost had risen between 1758 and 1783 from £81,000 to £157,000, or from 13 *per cent* to 16 *per cent* of the whole revenue.[697](javascript:footNote('E900040/note697.html')) But Government resisted all these proposals with great energy, and it was not till 1793 that the Irish Parliament
 


---

p.300



managed to pass its three great measures for limiting the powers of the executive. A Responsibility Bill was passed, bringing the signatories of money warrants under the control of Parliament. The hereditary revenue was now voted annually; the King could no longer dispose of the money alone, and a fixed civil list was granted to him which was never to be more than £145,000, exclusive of the pension list.[698](javascript:footNote('E900040/note698.html')) At the same time a Pension Bill made the whole amount of pensions reducible to £80,000[699](javascript:footNote('E900040/note699.html')) and excluded from Parliament all future pensioners at will or for years; no single pension of more than £12,000 a year was to be granted except to members of the Royal family, or on an address from both Houses of Parliament.[700](javascript:footNote('E900040/note700.html')) It was thought that all this would effect a saving of about £30,000 a year. Finally in this same year a Place Bill excluded from Parliament revenue officers, placemen, and pensioners; all members who accepted offices under Government were to vacate their seats, although they might be re-elected, and every Member of Parliament before he took his seat was to swear that he did not hold any pension or office which might incapacitate him from sitting.[701](javascript:footNote('E900040/note701.html')) The cost of collecting the revenue was also diminished and the surplus was to be applied to national objects. At the same time great relief was given to the poorest classes in Ireland by exempting from the hearth tax all houses possessed of only one hearth.[702](javascript:footNote('E900040/note702.html'))


The Pension and Responsibility Bills put Irish finances for the first time theoretically under the control of the Irish Parliament and also increased the real financial power of the Commons. But the Place Bill, from which so much was hoped, achieved nothing, for it was perverted by Government to corrupt uses. In a country where the



---

p.301



Parliament was really popularly elected it would have been safe enough to insert a clause in a Place Bill providing that Members of Parliament obliged to vacate their seats through accepting offices under Government might be re-elected by their constituencies, but in Ireland it was quite another thing; a great number of Irish boroughs were at the complete disposal of the Ministers, and the new Bill merely gave Government facilities for vacating seats and changing the whole composition of the House without a dissolution.[703](javascript:footNote('E900040/note703.html')) The Bill was really to the advantage of Government, and the Lord Lieutenant had clearly seen this in 1789, when the proposal had first been brought forward. Writing to **Sydney**, he says that the principle of vacating by pension or otherwise seats of Members of Parliament would be a manifest advantage to the Crown, and that if the Opposition had realised all that their proposal might mean they would never have brought it forward. ‘The King's Government,’ he writes, ‘will be essentially strengthened by it.’[704](javascript:footNote('E900040/note704.html')) Even that part of the proposed Bill which limited the amount of the pension list was not looked upon with disfavour by **Buckingham** himself, because it recognised clearly for the first time the exclusive right of the Crown to grant pensions without parliamentary control, even though an Act of the legislature might limit the amount which could thus be granted. Accordingly the whole Bill was allowed to pass the Commons, but eventually the Government resolved to throw it out in the Lords on the ground that ‘the violent and dangerous combination existing against Government could only be ultimately destroyed by a considerable increase in the charge in the civil pension list.’[705](javascript:footNote('E900040/note705.html')) The Regency question had just been agitating Parliament, and **Buckingham** thought that there



---

p.302



was at that time ‘very little hope of uniting to a systematic support those whose seats depend upon popular elections.’[706](javascript:footNote('E900040/note706.html')) The actual enactment of the Bill in 1793 may at first have purified the Irish Parliament in some slight degree, but there is no doubt that later on the Bill was perverted to corrupt uses, and it was through their power of changing borough Members without appealing to the constituencies by a dissolution which enabled the Irish Government to carry the Union.


In the financial year 1792–93 the condition of Irish finances seems to have been good. When the Chancellor of the Exchequer made his annual statement to Parliament in February, 1792, he stated that the unfunded debt was decreasing, and that the country was experiencing that improvement in the finances which he had expected, and in the hope of which he had deferred any application to Parliament for an extraordinary supply to discharge arrears. He said that the revenue for the half-year ending in September, 1792, exceeded the yield for the corresponding term in the preceding year by £53,000, and that he thought he was justified in foretelling an additional increase in the revenue for the next year.[707](javascript:footNote('E900040/note707.html')) The increase of revenue foretold by **Sir John Parnell** took place, but in 1793 the war with France began, and the even course of Irish finances changed. At the opening of the parliamentary session after the commencement of the war the Lord Lieutenant, in delivering the Royal message, said that the King ‘relied with confidence on the firm and effectual support of the Irish House of Commons and on the zealous exertions of a brave and loyal people in prosecuting a just and necessary war.’[708](javascript:footNote('E900040/note708.html')) A speedy and practical answer was given to this message, for a Bill was at once passed raising the Irish military establishment from 15,000 to 20,000 men and directing the enrolment



---

p.303



for four years of a militia force of 16,000 men. Two years later another appeal on the part of Government met also with an adequate response. The new **Viceroy, Lord Fitzwilliam**, stated in his speech at the opening of the session that the King believed so firmly in the loyalty of Parliament that he thought it unnecessary to press them in any particular manner for a sufficient provision under the ‘present awful situation of affairs.’[709](javascript:footNote('E900040/note709.html')) The address of the Commons in answer to the Lord Lieutenant's speech is extremely interesting, for it bears substantial testimony to the growing prosperity of the country even in this time of war.[710](javascript:footNote('E900040/note710.html')) The whole force of regulars and militia combined was raised to 40,000 men, and a vote of credit of £20,000 moved by **Grattan** for the Royal Navy was carried without any stipulation,[711](javascript:footNote('E900040/note711.html')) and their ability to make such adequate provision for the war was put down by the Commons to the flourishing condition of the commerce and revenue of the kingdom. During the financial debates of this session all parties agreed that the prosperity of Ireland during the last ten years had been unparalleled, and that in spite of the war this prosperity was continuing. Mr. Cuffe, one of the Government's supporters, asked, ‘What is the state of Ireland at this moment?’ ‘A state,’ he answers, ‘of unexampled prosperity. The landlord gets his rent to the hour. The tenant finds money for the purchase of his land the moment he brings it into the market; and the manufacturer finds employment and payment to his satisfaction. Ireland has the Constitution of England without its debt.’[712](javascript:footNote('E900040/note712.html'))


But this prosperous state of things could not last. The strain of the war began to tell. England herself was suffering from it, but in Ireland the financial burden soon became even heavier in proportion to the resources of the country; for added to the expenses of the war with France



---

p.304



there was now the necessity of large military preparations at home to maintain the Government and repress the growing disorders. Credit began to fail and industry was soon paralysed by the anarchy that reigned in many parts of the country. After 1796 Parliament found it no longer possible to exempt the very poor from taxation, and besides the hearth tax, the salt and leather taxes now fell very heavily upon them.[713](javascript:footNote('E900040/note713.html')) When a great and growing necessity imposed heavy taxes on the poor it was little wonder that the injustice of exempting the great absentee proprietors from taxation should be bitterly resented. An absentee tax was therefore proposed, but the measure was vigorously opposed in England and the Irish Government managed to defeat the proposal by 104 votes to 40.[714](javascript:footNote('E900040/note714.html')) It was soon found impossible to obtain sufficient supplies from taxation, and Government had to raise nearly four millions by loan. They issued 5 *per cent* £100 debentures at 63, and managed with some difficulty to obtain a loan of one and a half millions from England.[715](javascript:footNote('E900040/note715.html')) Credit had nearly collapsed, and the Lord Lieutenant wrote to **Pitt** that the Bank of Ireland was unable to meet the engagements into which it had entered with Government and even called for a partial repayment of the loan it had made.[716](javascript:footNote('E900040/note716.html')) Merchants were withdrawing their deposits from the Bank, and all over the country distress soon became universal. Some manufactures indeed showed a marvellous vitality, and agriculture prospered through the high prices which prevailed. But these high food prices brought suffering to the poor, and in 1797 there were 37,000 persons in Dublin alone in a state of destitution.[717](javascript:footNote('E900040/note717.html'))


From 1797 Ireland had to reckon with the Rebellion as



---

p.305



well as with the French War. Further military demands on her were made, and the entire cost of the great numbers of English troops sent to Ireland was borne by that country. The Irish Yeomanry was established, and the maintenance of this force formed another heavy charge. The supplies granted by the Irish Parliament were unprecedented in their amount, and were given with a unanimity and zeal which attested the loyalty of the Commons.


In consequence of the French War, and later on of the Rebellion also, the expenditure of Ireland increased enormously after 1793. It has been seen that from 1782 to 1793 the Irish revenue and expenditure fairly balanced each other, and that expenditure did not materially increase. But from 1793 to the Union expenditure increased at a very rapid rate. This increase was chiefly under the head of military services, and the total expenditure for the year ended Lady Day, 1800, was as much as five times greater than that for the year ended Lady Day 1793.[718](javascript:footNote('E900040/note718.html'))


From 1782–83 to 1792–93 the sum expended annually on military services amounted on an average to £585,000 (British). From 1793 to 1797 the increased military expenditure due to the French War raised this amount greatly, and in the year ended Lady Day, 1797, the large sum of £2,032,000 (British) was spent on military services alone. In 1797 the cost of the Yeomanry force, established to suppress the disorders in Ireland, first appears in the public accounts, so from this year till the Union a further increase in Irish military expenditure took place, an increase caused, not by the French War alone, but also by the Rebellion. In the year ended Lady Day, 1800, £4,596,762 (British) was spent on military services. If the military expenditure during these seven years, 1793–94 to 1799–1800 had been at the normal rate of £585,000 per annum mentioned above, it would only have amounted 



---

p.306



for the whole period to £4,095,000 (British). Actually it amounted to £18,050,941 (British), thus exceeding the normal amount by about fourteen millions. A further expenditure was made on military services in the three-quarters of a year from Lady Day, 1800, to January 5th, 1801, of over £2,500,000 (British), so that roughly speaking during the seven and three-quarter years since the commencement of the war with France over sixteen millions (British) was spent by Ireland on military services in connection with the war and the Rebellion.


Under these circumstances the Irish national debt rose from an insignificant amount to a very large sum. On Lady Day, 1783, the aggregate amount of the Irish funded and unfunded debt had only amounted in British currency to £1,917,784, and this amount had only increased by £334,983 (British) by Lady Day, 1793. But from that date it naturally began to grow enormously, and on January 5th, 1801, the aggregate Irish debt stood at £ 28,551,157 (British), or over £26,500,000 more than it had been eighteen years before.[719](javascript:footNote('E900040/note719.html')) Nearly the whole of this increase took place in the last eight years of the period, and was directly due to the expenses of the French War and the Irish Rebellion.


It was, therefore, little wonder that the condition of Irish finances just before the Union was held to be appalling, and the financial difficulties under which Ireland laboured were seized upon by **Lord Castlereagh** in order to press for a legislative Union with Great Britain. He even underestimated the revenue of the country in order to prove his case that bankruptcy was inevitable if a Union did not take place. It is as well to emphasise the fact that the commercial and financial distress which existed in Ireland during the last four years of the eighteenth century was due to the



---

p.307



specific causes which have been mentioned. There was little decline in the prosperity of the country until the end of 1796, and this though an expensive war was being carried on. **Castlereagh** himself acknowledged that during the first three years of the war with France, Ireland had been regularly improving in commerce and revenue, even though eight millions had been taken from her circulating capital at different periods.[720](javascript:footNote('E900040/note720.html')) Naturally, however, it was impossible for this improvement to continue when the Irish disturbances broke out. Credit was bound to collapse and industry to be dislocated, and we can only be surprised that the statistics of exports and imports do not show even a greater fall than is actually the case and that so considerable a revenue was raised from the country.




---

p.308


The Union
---------


History of the Idea of a Legislative Union Between England and Ireland — Change of Feeling after the American War *—* The Union made easy by the Rebellion — Commencement of the Union Proposals in 1798 — Progress of the Measure in the British and Irish Parliaments in 1779 — **Foster**'s Speech against the Union — Debates on the Union Proposals in the Irish Parliament in 1800 — Lord Castlereagh's Principal Explanation of the Commercial and Financial Arrangements, Feb. 5th — **Foster**'s Answer, Feb. 27th — **Grattan**'s Speech against the Committal of the Union Bill, May 26th — Success of Government — Progress of the Union Proposals in the Irish House of Lords — Protest of Twenty Dissentient Peers on the Financial Arrangements — Union Resolutions finally passed by both Irish Houses — Passed by British Parliament — Embodied in a Bill by Irish Parliament — Final Efforts of the Opposition in the Irish House of Commons — Their Address to the King on the Financial Arrangements negatived — Final Passing of the Bill by both Parliaments — The Commercial Arrangements of the Treaty of Union — The Financial Arrangements — Criticism of (a) the Commercial Arrangements, (b) the Financial Arrangements.
The idea of a legislative union between England and Ireland was by no means new, for it had been entertained by various men in both countries from very early times. **Molyneux** tells us that there are traces of barons, prelates, and citizens being summoned from Ireland to serve in the English Parliaments in the reigns of Edward I. and Edward III.,[721](javascript:footNote('E900040/note721.html')) and during the Commonwealth, when the great scheme of parliamentary reform was carried out, Ireland and Scotland were incorporated with England, and sent thirty representatives each to the Protectorate Parliaments of 1654 and 1657. But **Cromwell**'s grand 



---

p.309



scheme of a United Kingdom disappeared with him, and after the Restoration Ireland and Scotland resumed their own local legislatures.


But the idea of union between England and Ireland by no means died out. **Petty** advocated it continually.[722](javascript:footNote('E900040/note722.html')) He thought that the union of the legislatures was the only means by which Ireland might be rid of those commercial restrictions which were beginning to hamper her material progress, and also that such a union might do much to weld the two countries more closely together. When **Petty** wrote, the restraints placed by England on Irish trade were comparatively slight, and in the reigns of William III. and Anne, when these restraints began to touch every branch of Irish trade and industry, there were in consequence far weightier reasons why Ireland should have thankfully received a policy of union. It seems to have been the restrictions placed on the Irish woollen trade that chiefly inspired **Molyneux** to write his famous treatise on the independence of the Irish Parliament. One passage of this treatise is particularly interesting, for it shows that **Molyneux**, like so many of his contemporaries, would have welcomed a union. He says that if it may be concluded from the fact of Irish members having been summoned to the Parliament of Edward III. ‘that the Parliament of England may bind Ireland, it must also be allowed that the people of Ireland ought to have their representatives in the Parliament of England; and this I believe we should be willing enough to embrace, but this is a happiness we can hardly hope for.’[723](javascript:footNote('E900040/note723.html'))


Soon after **Molyneux** wrote there began those *political* and commercial disputes between England and Scotland which made the English Government determined to



---

p.310



procure a union. The Scotch Union was carried mainly by corruption, but it is doubtful whether it could have been carried even by this means if solid commercial benefits had not been offered to Scotland in return for the surrender of her legislature. At this time Ireland was nothing loath to give up her separate Parliament on the same conditions. On October 20th, 1703, when the negotiations for the union with Scotland were proceeding, the Irish Commons sent up an address to the Queen petitioning for a legislative union,[724](javascript:footNote('E900040/note724.html')) and a few days later the Lords assented to resolutions embodying the same request.[725](javascript:footNote('E900040/note725.html')) Four years after, in 1707, the Irish House of Commons, in their address to the Queen congratulating her on the completion of the Union with Scotland, expressed a hope that God might put it into her heart to add still greater strength and lustre to her Crown by a yet more comprehensive union.[726](javascript:footNote('E900040/note726.html')) Men like **Archbishop King** and **Bishop Nicholson** were not adverse to the measure, for the commercial benefits which Ireland would reap were considerable, and very probably, if England had wished, union with Ireland might have taken place without any difficulty. Ireland had even more to gain than Scotland from union with England, and the strong national feeling which prevailed in Scotland, and which later on was to prevail in Ireland, had not yet sprung into life. The Catholics were miserable and downtrodden, the Protestants looked to England as their natural protector, and there was no affection felt by the mass of the people, whether Catholic or Protestant, for the local legislature. But at that time England had no wish for union with Ireland; the spirit of commercial monopoly reigned supreme, and the advances of the Irish Parliament were coldly received.


During the next three-quarters of a century various



---

p.311



writers still advocated the idea of a legislative union between the two countries — **Bishop Berkeley**, **Dobbs**, and **Madden** in Ireland, and **Sir Matthew Decker**, **Postlethwayt**, **Child**, and **Josiah Tucker** in England. Then just before Ireland was granted free trade, **Adam Smith**, in his Wealth of Nations, announced as his opinion that ‘without an Union with Great Britain, the inhabitants of Ireland are not likely for many ages to consider themselves as one people.’[727](javascript:footNote('E900040/note727.html')) He wished Ireland to share the burden of the British National Debt, but he thought that any increase of taxation this might necessitate would be more than balanced by the commercial freedom which would be permanently secured to the Irish people.


But the American War, followed by the repeal of the commercial restrictions and the establishment of parliamentary independence, changed the whole current of feeling in Ireland with regard to the idea of union with England. **Adam Smith**'s statement was for the time being falsified, and the Irish for the first time began ‘to consider themselves as one people.’ A national feeling sprang up among both Protestants and Catholics, and the national legislature at last became representative of the national feeling. The idea of Irish unity, and the sentiment of independence having once awakened, any scheme which would involve interference with their Parliament became most obnoxious to the Irish people. England had lost long ago the favourable moment for achieving a union. She had then much to give Ireland in exchange for her Parliament. Now she had comparatively little, for the principal restraints on Irish commercial development had been removed, while the Irish Parliament after 1782 was a very different affair from the Irish Parliament at the beginning of the century. Ireland had now before her a free field for commercial development, and the existence of an independent legislature naturally increased the sacrifice involved in union with England.




---

p.312


On the other hand, England was becoming increasingly anxious for the measure. The English Government had been practically forced into granting independence to the Irish Parliament, but from the day when this independence was granted English statesmen began to advocate union with Ireland. To the Englishmen of that day there seemed naturally enough something peculiarly dangerous to English interests in the existing political relations with Ireland. The tie of a common Executive appeared too slight, and no doubt it was possible for Ireland to have made herself troublesome had she wished. The failure of the Commercial Propositions of 1785 was unfortunate, for they would have placed the commercial intercourse between the two countries on a permanent basis, and settled Ireland's contribution towards the defence of the Empire, thus removing two causes which seemed to make a union imperative from an English point of view. There is no doubt that the failure of the Propositions, together with the independent attitude adopted by the Irish Parliament towards the Regency question, made the English Government more anxious to procure union with Ireland, and from this time we begin to hear much about the possibility of the measure. There were many men in England who now thought that the bond between the two countries was most precarious, and could not be permanent. The policy of the Irish Parliament in repealing so much of the penal code seemed to weaken this bond still more. The Irish Act of 1793, which extended the franchise to a large and impoverished Catholic democracy, tripled the electorate, changed the whole political aspect of things in Ireland, and made to English minds the existence of an independent Irish legislature much more dangerous. It seemed to be, so to speak, the thin edge of the wedge, and it was thought that if the Catholics were admitted to complete political power a Catholic policy must in the nature of things become in the *ascendant*. Then the Protestant establishment must fall, the landlords would be ruined, and a



---

p.313



political and social revolution would take place, leading perhaps to the downfall of the Empire. The Catholics might then claim a Catholic king, and would probably become hostile to England and side with her enemies.[728](javascript:footNote('E900040/note728.html')) The only way to avert all this, it was said, was to bring about a speedy union. Once the Union was completed, the immediate emancipation of the Catholics, if indeed such an emancipation must be granted, would not materially matter, for they would form a small minority in the Imperial Parliament. The possibility of Catholic emancipation in an independent Ireland was, in fact, the root of the problem. It was this that made England fear that Ireland might soon slip out of her grasp, and which made her determined to procure a legislative union, in order to do away once for all with the possibility of total separation.


But if we turn to Ireland we find a different feeling on the matter. ‘Talk to an Irishman of an union with England,’ it was said by an Englishman as early as 1775, ‘and he almost takes fire — ‘What! bereave us of our Parliament and then overrate us with taxes!’’[729](javascript:footNote('E900040/note729.html')) ‘If a candidate for any county,’ says the same writer, ‘were supposed capable of favouring such a destructive scheme it would be sufficient to defeat his election.’[730](javascript:footNote('E900040/note730.html')) Such was the feeling at the commencement of the American War, and this sentiment of hatred to the idea of union became stronger and stronger as time went on.




---

p.314


**Harcourt**, when Lord Lieutenant, advised the British Ministry not to proceed in the matter of union until public opinion in Ireland had been prepared for the measure,[731](javascript:footNote('E900040/note731.html')) and in 1780 **Buckingham** wrote to **Hillsborough**: ‘Let me earnestly recommend to you not to utter the word 'Union' in a whisper or to let it drop from your pen. The present temper will not bear it.’[732](javascript:footNote('E900040/note732.html')) Up to the time of the Rebellion all sections of Irishmen were agreed in wishing to preserve the constitutional arrangement of 1782. **Grattan** and other patriots who desired to gradually emancipate the Catholics altogether were perfectly loyal to the English connection, and they did not fear the possibility of separation between the two countries when this complete emancipation took place.


But the Rebellion did much to destroy this harmony of ideas among Irishmen. The **Society of United Irishmen** was the expression of the democratic and republican idea of the age. It was one of the results of that great wave of enthusiastic republicanism which sprang from the events of the French Revolution, and it was in consequence thoroughly repugnant to the feelings and sentiments of the majority of the Irish Protestant gentry. The disturbances in Ireland were, therefore, fatal to the recently awakened spirit of national unity, and as a result the idea of union came to be rather less obnoxious to some of the Irish Protestants. The inevitable result of the Rebellion was the division of classes and the dissensions of sects. The disturbances in the country made some of the country gentlemen ask themselves whether the Protestant establishment would not be safer under the closer protection of Great Britain, and thus England by means of much judicious persuasion was able to win over to her side some of those who dreaded a new insurrection of **United Irishmen**. There was certainly a feeling among some of the Irish Protestants that the patriotic party in 



---

p.315



Parliament had gone too far in their policy of emancipating the Catholics, and that the ascendancy of the Protestants in the country would soon be at an end without the powerful protection of England. But this feeling was by no means widespread, even when the horrors of the Rebellion were paralysing the country; and when the prospect of union was first definitely announced it was received with a storm of hostility by both Protestants and Catholics. It seems, however, true to say, that if the Rebellion had never taken place it is doubtful whether the Union could have been carried by any means whatsoever.


It was in the summer of 1798, when the Rebellion was being crushed out, that the Pitt-Portland Cabinet first made up its mind that an attempt might be made towards the abolition of the Irish legislature with some prospect of success. By September the leading points of the measure of Union were already under consideration,[733](javascript:footNote('E900040/note733.html')) and a little later the Irish Lord Chancellor, **Lord Clare**, **Beresford**, and the **Speaker Foster** went over to England to assist in the deliberations. The two former were in favour of a union, but the latter was bitterly opposed to it, and for the third time in his extremely able career he represented the popular opinion. Soon the principal articles of the Union resolutions were transmitted from England to Lord Cornwallis, now Lord Lieutenant, and the latter was authorised to pledge England to the scheme.[734](javascript:footNote('E900040/note734.html')) **Cornwallis** had been hopeful of success, but in December he was forced to admit that public hostility to the Union was increasing daily, and that he had been too sanguine about the Catholics. On the 12th of the month he wrote to **Major-General Ross**: ‘Their dispositions are so completely alienated from the British Government that I believe they would even be tempted to join with their 



---

p.316



bitterest enemies, the Protestants of Ireland,[735](javascript:footNote('E900040/note735.html')) if they thought that the measure would lead to a total separation of the two countries.’[736](javascript:footNote('E900040/note736.html')) Just at this time a meeting of the Irish Bar was held, and it was nearly unanimously resolved that the proposals for a union were highly dangerous and improper and ought not to be pressed forward by the British Government when an army of 40,000 men was in the country.[737](javascript:footNote('E900040/note737.html')) Indignation meetings were held in Dublin and in various towns and places in the Queen's and King's counties, in Westmeath, Meath, Carlow, Louth, and Clare, and there is no doubt that at this time opposition to the Union prevailed all over Ireland. Irish manufacturers had no wish for a free trade to be established with Great Britain, for they realised that while such a policy would not enable them to compete with British manufactures in British markets, their own markets would promptly be flooded with cheap British goods. The whole of Dublin was especially opposed to the Union, for it was feared that the removal of the Parliament would reduce the material prosperity and importance of the capital and would increase absenteeism. It was also felt by everyone that union with England would mean somehow or other heavier taxation for the Irish people. The Catholics were very hostile, for as yet they had not been bribed by hints of possible emancipation; the Orangemen were violent in their opposition; and the majority of the moderate Protestants were anxious to preserve their beloved Constitution of 1782.


On January 22nd, 1799, the Lord Lieutenant in his speech to the Irish House of Commons hinted for the first time at the possibility of a union. He said nothing definite, but the debates that followed in both Houses were all on the subject of the Union, as **Lord Castlereagh**,



---

p.317



Chief Secretary to the Lord Lieutenant, announced that it was the intention of Government to bring forward the measure. In the Lords the voting was in favour of Government, but in the Commons matters were different and the debates were long and bitter. An address to the King was moved containing an approval of the idea of Union. It was vigorously opposed. **Plunket**, an Ulsterman, spoke with force and eloquence against the Government, and he totally denied the competence of Parliament to change the Constitution, much less to abolish it without a fresh election.[738](javascript:footNote('E900040/note738.html')) Many other Members spoke against the address and eventually on a division being taken to expunge the Union paragraph from the address, it was found that the National party had 111 votes as against 106 for Government. The debates had been almost entirely concerned with the constitutional aspect of the question, and little was said on either commercial or financial points.


Meanwhile, the project of Union had been definitely announced in the British Parliament by **Pitt** in a message from the King.[739](javascript:footNote('E900040/note739.html')) **Pitt** tried to show that the settlement of 1782 had not been final, and he emphasised the dangers which might befall the Empire if Ireland kept her independent Parliament. He denied that the object of the Union was to bring Ireland under the burden of the British national debt or that its result would be an increase in Irish taxation. The debts of the two countries were to be kept separate and the ordinary expenses of the United Kingdom in peace or war were to be defrayed by the two countries in fixed proportions. It was quite possible for Parliament, **Pitt** said, to fix for a certain number of years the proportion by which the contribution of Ireland to the expenses of the Empire should be regulated, in such a way as to secure that the



---

p.318



contribution paid by Ireland would not be greater than ‘the necessary amount of its own present expenses as a separate kingdom.’ After the period fixed the proportion of the respective contributions from time to time might be made to depend on the comparative produce in each kingdom of such general taxes as might be thought to afford the best criterion of their respective wealth. **Pitt** hoped, however, that in time it might be practicable so to equalise and assimilate the system of internal taxation in each country ‘as to make all rules of specific proportion unnecessary, and to secure that Ireland shall never be taxed but in proportion as we tax ourselves.’ Accordingly he proposed in his financial resolution that the charge arising from the payment of the interest or sinking fund due on account of the pre-Union debt in either kingdom should be separately met by Great Britain and Ireland respectively; that for a number of years, to be afterwards fixed, the future ordinary expenses of the United Kingdom in peace or war should be defrayed by Great Britain and Ireland jointly according to such proportions as should be established by the respective Parliaments previous to the Union; and that after the expiration of the time so fixed, the proportion should not be liable to be changed except according to such rules and principles as should have been determined previous to the Union. Three weeks' discussion followed. There was a good deal of opposition to the whole scheme on constitutional and commercial grounds, but little was said as to the financial points. Eventually **Pitt**'s several resolutions were carried, and an address in favour of a union was presented by Parliament to the King.


But the opposition displayed by the Irish Parliament made it necessary to move cautiously, and for the next year Government busied itself with gaining supporters. The subject of Union was, however, revived from time to time during the session, and the Speaker (**Foster**) delivered a speech during the Regency debate, in which he examined



---

p.319



closely the probable effect of the Union on the material prosperity of Ireland.[740](javascript:footNote('E900040/note740.html')) He believed that the Union would lead to a great increase of taxation, and would therefore be fatal to the growing wealth of the country; and he declared that it was useless to say that Parliament would depend on the articles of Union it framed to secure the purse and trade of Ireland, for the very doctrine of the omnipotence of Parliament, which would enable it to carry the Union against the evident wishes of the country, would of necessity reduce its articles to waste paper. The United Parliament would have power to alter or abrogate any article of the Union; to abolish bounties, to amalgamate debts, or to increase taxation, and the minority of a hundred Irish Members would be powerless to resist. **Foster** also dwelt on the great material progress which had been made by Ireland since the establishment of the free Parliament of 1782, and he showed that Ireland had every chance before her of commercial and industrial development, for the exclusion of Irish manufactures from the British markets did not really injure Irish trade. Ireland had, in fact, little now to fear from the commercial hostility of Great Britain, and, with an unrestricted foreign trade and a free Parliament, the country was bound to progress in the path of material prosperity. **Foster**'s arguments produced some effect, but Parliament was now adjourned by the Viceroy, and when it met again, at the beginning of 1800, many new Members were present in place of those who had been bribed by Parliament to retire. The new Place Bill had come to the aid of Government by putting it in their power to vacate the seats of Members of Parliament, and to introduce new Members without a general appeal to the constituencies.


The Union resolutions had now arrived at a definite shape, and on February 5th **Lord Castlereagh** made a long speech, in which he explained the proposed articles, and 



---

p.320



particularly dwelt on the commercial and financial arrangements.[741](javascript:footNote('E900040/note741.html')) He stated that the commercial article (article 6) placed the subjects and products of either country on an equal footing as to encouragements, bounties, and treaties. The whole idea of the arrangement was to open the commercial intercourse between Great Britain and Ireland as much as possible, and **Castlereagh** lamented that the two countries could not be completely made one on account of an inequality of burdens, which resulted in unequal excises, and which, therefore, necessitated separate treasuries. But Ireland would certainly gain greatly from the measure, even more than she would have gained, commercially speaking, from the Propositions of 1785. By those Propositions Great Britain retained a duty of 1s. 6d. per ton on coal exported to Ireland, but this was given up by the articles of Union. Again, by the Treaty of 1785, the export of British wool remained prohibited, but by the Union arrangements it was conceded. The Irish *sailcloth* manufacture would benefit from a free entry into England, and from a cessation of the bounties now given on British *sailcloth* exported to Ireland. As for the idea that Irish manufactures would suffer from the removal of the protective duties, **Castlereagh** thought that it was worth nothing; the only Irish manufacture which might suffer from a policy of free trade was the cotton manufacture, and this was to receive special protection, for the existing duties of 40 to 50 *per cent* on the importation of cotton goods were to be retained for a period of seven years, at the end of which time they were to be gradually reduced to the level of 10 *per cent* ad valorem within a period of twenty years. This concession had been granted by the British Government because the import duties on cotton goods were the solitary instance of a prohibitory duty in Ireland.[742](javascript:footNote('E900040/note742.html'))


---

p.321


**Lord Castlereagh** then went on to speak of the financial arrangements which were embodied in article 7 of the Treaty. He said the principle of the arrangement was that neither country was to have anything to do with the past debt of the other, but, as to the future, the two countries were to unite in regard to their expenses according to their respective abilities. The inequality of the debts in Great Britain and Ireland necessitated the pre-Union debts being kept distinct, and rendered indiscriminate taxation impossible. **Castlereagh** then spoke of the criterion by means of which he had arrived at the respective resources of Great Britain and Ireland in order to fix the relative proportions of their contributions. The first standard he had taken as a basis for comparison was the average annual values of the total exports and imports in Great Britain and Ireland respectively for the years 1796, 1797, and 1798, and these values he had found to bear the proportion of nearly 7 to 1. He had then taken the values of the principal dutiable commodities — malt, beer, spirits, wine, tobacco, tea, and sugar — consumed in the two countries respectively during the same three years, and these he had found to bear the proportion of 7 7/8 to 1. The mean of these two proportions was 7 1/2 to 1, and **Lord Castlereagh** therefore proposed that Great Britain should contribute 15/17 and Ireland 2/17 of the whole general expenses of the Empire — i.e., that the proportion of Ireland should be 2 to 15, or 12 *per cent* of the whole.


**Lord Castlereagh** then explained the financial provisions in more detail; and first he examined whether the ratio of 7 1/2 to 1, which he had deduced, would correspond with the ratio of past expenditure, exclusive of debt charge, of Great Britain and Ireland. He took a single year of peace (1791–92) and found that the proportion of expenditure for Great Britain and Ireland respectively was 5 3/4 to 1. He then took the average expenditures of the two countries for seven years from the commencement of the war, and



---

p.322



found that the proportion of expenditure for Great Britain and Ireland respectively was annually 9 to 1. **Castlereagh** took these very arbitrary proportions of 5 3/4 to 1 in peace and 9 to 1 in war, and argued that ‘as, upon the experience of the past century, it is found that there are three years of peace to two of war, if we form our calculations upon this proportion, the past expenses of Great Britain and Ireland may be considered in the ratio of 7 3/4 to 1.’ In the year of peace taken by **Castlereagh** he put Great Britain's expenditure at seven and a half millions, and that of Ireland at one and a half, altogether nine millions for the United Kingdom.[743](javascript:footNote('E900040/note743.html')) But if the Union had existed in that year, and the total charge had been borne by the two countries in the ratio of 2 to 15, Ireland's share, according to **Castlereagh**, would have been £441,000 less than her expenditure, as a separate kingdom, amounted to during that year.


**Lord Castlereagh** then emphasised the fact that Ireland would not be called upon to bear any part of the British National Debt, and said that the ninth section of the financial article gave Ireland a share in whatever sum might be produced from the territorial revenues in India. This would amount to about £58,000 a year out of the revenue paid by the East India Company, and was an exceptionally generous provision. He also pointed out that the proportion which had been established of two for Ireland and fifteen for Great Britain was only to last twenty years, and would then be revised by the Imperial Parliament, so that Ireland had the utmost possible security that she could never be taxed beyond the measure of her comparative ability. When, however, the separate debts of the two kingdoms should be either discharged or should be in proportion to their respective contributions, the taxation of Ireland might be assimilated with that of Great Britain, so that the whole expenses of the Empire should be defrayed by common taxes in the two 



---

p.323



countries. **Lord Castlereagh** tried to show that a system of common taxation under such conditions would not impose upon Ireland a heavier burden than she would otherwise be called upon to bear. The United Parliament would always be able to make abatements in Ireland, as the British Parliament had continually done in Scotland, if from local circumstances the high duty could not be levied without pressing unduly on the poorer classes or rendering the revenue unproductive.


Some of the rather hypothetical statements made by **Lord Castlereagh** evoked much hostile criticism; Government, however, proved too strong for the Opposition and the Union resolutions were accepted by a majority of forty-three. But on February 17th, 1800, the resolutions were considered in committee and now **Lord Castlereagh**'s commercial and financial proposals were at last taken up and considered in detail by **Foster**.[744](javascript:footNote('E900040/note744.html')) It was **Foster**'s opinion that Ireland would gain little, commercially speaking, from the Union. It was impossible for Irish merchants to compete with British in the British markets, and it was probable that the reduction of the duties on manufactured goods imported into Ireland would cause a decay among those Irish manufactures which were but in their infancy. The reduction of these duties would also fall heavily upon the revenue; for besides taking away £32,000 a year of protective duties, the Union would do away with £44,000 a year paid on the exportation from Ireland of live cattle, hides, tallow, butter, beef, pork, and linen yarn. The removal of the export duty on hides would injure the tanning trade, and all Irish merchants were agreed that the duties on tallow, butter, meat, and linen yarn did not hamper their trade, while it was certainly true that there had been an enormous expansion in the exportation of all these goods in recent years. The removal of the duties would, of course, be 



---

p.324



advantageous to England, who would get the goods cheaper, but it would be unfavourable to Ireland, for fresh taxes would have to be raised in their place in order to fill the gap in the revenue. **Foster** also feared that the abolition of the tax on the exportation of live cattle, which in 1793 had so wisely been raised from 1s. 6d. to 6s. per head, would encourage this exportation and thus cause a decline in the provision trade and in agriculture.


But **Foster**'s criticism of the financial articles was far more important and is full of interest. He insisted that the criterion which **Lord Castlereagh** had taken as his basis for comparing the respective resources of Great Britain and Ireland was really worthless and could establish nothing. For one thing, in comparing the imports and exports of the two countries, the Chief Secretary had omitted to calculate the tonnage of the shipping belonging to each kingdom; thus he paid no attention as to which country received the profits of the carriage, although this contributed a material part of the total value. Again, in comparing the consumption of dutiable commodities in Great Britain and Ireland, both salt and stamps had been excluded from the list of articles. **Foster** declared that in 1799 the gross duties on salt were in Great Britain £800,000 and in Ireland £90,000, or in the proportion of nine for Great Britain and one for Ireland. Similarly the gross amount of the stamp duties in the same year was £2,000,000 in Great Britain and in Ireland £137,000, or in the proportion of fifteen for Great Britain and one for Ireland, while the Post Office receipts in the two countries, which **Lord Castlereagh** had also omitted from his calculations, showed the proportion of ten for Great Britain and one for Ireland. A consideration of these points must inevitably alter the whole proportion in favour of Ireland. Under the proposed proportional contribution it was impossible to believe with **Lord Castlereagh** that the taxation of Ireland would not only be subject to no increase but would actually be diminished. The argument 



---

p.325



was, in fact, absurd. The aggregate expenses of the Empire could not decrease, for the war was still going on and no one knew exactly how long it would last. Therefore, if Ireland were to pay less, Great Britain must pay more; Great Britain would then go bankrupt and Ireland would fall with her. But no sane man could believe that England would voluntarily take upon herself the burden of extra taxation in order to bring about a measure of Union for which Ireland had not asked. The truth was that the idea that under the Union arrangements Ireland would save annually in time of peace had been arrived at in an extremely arbitrary manner. It had been arrived at by placing the peace establishment of Ireland at £1,500,000. This was much too high; for the last peace establishment, just before the war, when much was being spent in developing the resources of the country, had only been £1,012,000, and it had proved amply sufficient. But **Lord Castlereagh** was trying to prove that the revenue of Ireland was not equal to her expenditure, and that nothing but a legislative Union would save the country from bankruptcy, and he had therefore over-estimated the peace establishment. At the same time, he had under-estimated the Irish revenue. **Foster** estimated it for the year 1798–99 at £2,638,000; out of this sum debt charges would amount to £1,400,000, thus leaving £1,238,000 for the peace establishment, which would be amply sufficient. Of course, if the war continued, Ireland's expenses would increase, but they would increase, **Foster** insisted, at a far less rapid rate than under a Union. It was also probable that the Irish revenue would increase, as his estimate of the revenue was taken from a year of rebellion and invasion; this, however, had been left out of account by **Lord Castlereagh**. Irish finances were not at all so desperate as they were made out to be, and the Irish debt during the war had increased far less rapidly than the British debt, in spite of the fact that the whole cost of the Rebellion was falling on Ireland. In the six years ended January 5th, 1799, Great Britain



---

p.326



had increased her debt by £186,000,000, while Ireland had only increased hers by £14,000,000. The liabilities of the two kingdoms had therefore been augmented by £200,000,000. But if the Union arrangements had been in force during these six years Ireland's share (i.e., 2/17 of these joint liabilities would have been £23,530,000 instead of only £14,000,000. Therefore, if the Union had taken place in 1793, Ireland's debt would have increased nine and a half millions more than it actually had done. **Foster** maintained — and subsequent events proved that his ideas were just — that the Union, instead of reducing the taxation of Ireland, would increase that taxation by about two and a half millions a year. Thus both the phantoms of increased taxation and bankruptcy without the Union vanished, while the probability was that with the Union both would take place. In another way the Chief Secretary's arguments were curious. Ireland was to get the supposed favourable proportion of 2/17 because of the comparative greatness of the British debt,[745](javascript:footNote('E900040/note745.html')) but when Ireland, say, should have doubled her debt to £50,000,000 and Great Britain should have decreased hers to £340,000,000, this benefit was to be taken away, because the debts of the two countries would then be to each other in the proportion of their respective contributions to Imperial expenditure. Ireland could not bear equal taxation with Great Britain at present, but after she has doubled her debt and Great Britain has decreased hers, Ireland will be richer and able to bear heavier taxation. But the double debt must lead to double taxes to meet the debt charge, and at the same time Ireland must endure the full burden of indiscriminate taxation with Great Britain.


But **Foster**'s speech produced no effect on the division list, and Government procured a majority of forty-three for the consideration of the Union proposals. From this time the success of the measure was practically certain.




---

p.327


On February 24th the resolution as to the relative contribution of the two countries was debated. **Lord Castlereagh** did his best to answer **Foster**'s prophecies as to the probable financial effects of the Union, and he maintained that Ireland would in the next five years, taken in the proportion of two of war and three of peace, save under the Union arrangements nearly ten millions. **Sir John Parnell** supported **Foster** in stating that the proportion that Ireland was called upon to bear was too great for her capacities, and he, therefore, proposed as an amendment that the Irish contribution should be 2/20 instead of 2/17. But this amendment was negatived and Government again secured a majority.


In the following debates the Union resolutions were fought over one by one, but as usual the constitutional aspect of the question took up most attention, and little time was given to the important financial arrangements. On May 26th **Grattan** made his famous speech against the Committal of the Union Bill, and in particular he challenged **Lord Castlereagh**'s statements in defence of the financial resolutions.[746](javascript:footNote('E900040/note746.html')) He said that the idea of a Union rested on two false principles — first, that the revenue of the kingdom would not increase; and secondly, that its expenses were bound to grow. But if the Irish revenue did not increase, what was to become of the material prosperity promised to result from the Union? On the other hand, if the revenue did increase, what was to become of **Lord Castlereagh**'s argument as to impending bankruptcy? **Grattan** then showed, as **Foster** had done, that the present revenue would leave a margin on normal peace expenditure after the debt charge had been met, but that this margin had disappeared in **Lord Castlereagh**'s statement because he had arbitrarily estimated the peace establishment of Ireland at £1,500,000 instead of a little over £1,000,000. No



---

p.328



reasons had been given for anticipating this increase in peace expenditure, but if it was to be the result of an enlargement of the military force in the kingdom, what then became of the tranquillising effects promised to result from the Union? **Grattan** declared that he considered that **Lord Castlereagh**'s calculations as to the proper proportion Ireland should contribute were founded upon worthless data, and that it was probable that Ireland had been over-rated in contribution as she had been over-charged in establishments. As a result of this speech the Government majority fell from forty-five to thirty-seven on a second division on that night, but this was the last great effort made by the National party in the Commons to preserve the National legislature.


In the Irish House of Lords the Government met with less opposition. The most memorable speech in the debates was made on February 10th, by **LordClare**,[747](javascript:footNote('E900040/note747.html')) who energetically advocated a Union as the only way to keep down rebellion, and therefore the only way to keep the country from becoming bankrupt through the expense of maintaining a large military force such as existed at present. On this occasion Government obtained a majority of forty-nine, and the various Union resolutions passed through their final stages with little difficulty. But at the last stage of all a protest by twenty dissentient Peers was entered upon the Journals of the House, directed chiefly against the financial arrangements. It declared that the contribution of 2/17 was more than Ireland was able to bear, and that the criterion adopted by **Lord Castlereagh** for ascertaining the resources of the two countries was quite insufficient. Other criteria should have been taken, such as the balance of trade in each country, which would show the proportion of 22 for Great Britain and 1 for Ireland, or the current cash in circulation in both 



---

p.329



kingdoms, which would show the proportion of 12 to 1. It should also be borne in mind that large sums of money were continually flowing into Great Britain, while Ireland received no money, and annually remitted about two millions to the British Government or to individuals in Britain. Also, money could be raised in Great Britain with great facility, while there was much difficulty in raising any in Ireland, and this fact clearly showed the wealth of one country and the poverty of the other. ‘Under these circumstances,’ the protest concluded, ‘it appears to us that if this kingdom should take upon herself irrevocably the payment of two-seventeenths of such expenses, she will not have means to perform her engagements unless by charging her landed property with 12s. or 13s. in the pound; it must end in the drawing from her her last guinea, in totally annihilating her trade for want of capital, in rendering the taxes unproductive, and consequently in finally putting her into a state of bankruptcy. We think ourselves called upon to protest against a measure so ruinous to the country, and to place the responsibility for its consequences upon such persons as have brought forward and supported it.’[748](javascript:footNote('E900040/note748.html'))


On March 27th the Irish Houses agreed to an address to the King containing the terms proposed by them for a Union between the two kingdoms. This address was communicated by the King to the British Parliament on April 2nd, and three weeks later **Pitt** delivered a long speech, in which he spoke at length on the financial arrangements.[749](javascript:footNote('E900040/note749.html')) He said that it was impossible at present to identify the financial systems of the two countries on account of the different proportions of debt, the different stages of civilisation and commerce, and the different wealth of the two kingdoms. It had therefore been determined to fix a just proportion to be paid by Ireland in order to do away with all suspicion of unduly burdening



---

p.330



her. But he insisted that the object of the financial arrangements was ‘to effect the gradual abolition of all distinction in finance and revenue between the two countries, and to accelerate the time when both countries form but one fund and pay one uniform proportion of taxes throughout each.’ This assimilation of the financial systems might be brought about when the ‘real value’ of the debts of Great Britain and Ireland were alike, and then ‘it will remain in the discretion of the United Parliament to abolish all distinctions of quotas and contributions, and to fix one rate of taxation throughout the United Kingdom subject merely to such local abatements as from circumstances may be necessary.’


The Union arrangements were speedily accepted by the British Parliament and sent back to Ireland, where they were at once embodied in a Bill by the Irish Parliament. On May 21st the Bill was brought in, and it was read for the second time on the 26th. It was on this day that **Grattan** made his second speech against the financial measures, and this time he based his objections on the unintelligible and conflicting nature of the papers before the House on the basis of which the Irish contribution had been calculated.[750](javascript:footNote('E900040/note750.html')) In the case of tea, tobacco, sugar, and other articles not produced in the country the value of the goods consumed was returned at one-third and sometimes one-half more than the value of the same kind of goods imported, and no explanation was given of this extraordinary difference. The value of British exports and imports was understated by about six millions, while that of Irish exports and imports was overstated by about two millions, and a proper correction of these mistakes would make the proportion between Great Britain and Ireland 79 to 8 respectively. ‘Colour it as you will,’ **Grattan** concluded, ‘Ireland will pay more than she is able.’ On this same night of May 26th the Union Bill was



---

p.331



committed by a majority of forty-five, and feeling that further resistance was useless the leaders of the Opposition in the Commons, wishing to inscribe their last protest on the Journals of their House, moved a lengthy address to the King on June 6th, which forcibly summarises all the arguments used by the National party against the financial resolutions.[751](javascript:footNote('E900040/note751.html'))


In this address the minority complained of the methods used by Government in calculating the proportion to be contributed by Ireland, that no satisfactory papers had been laid before them, and that no committees had been appointed to investigate the matter. They therefore protested against any arrangement of taxation concerning which they had been given no satisfactory documents, or been allowed to make any proper enquiries to guide their judgment, and in which no consideration had been paid to the different legal interest of money in the two kingdoms, to the relative quantity of shipping possessed and used by them, to their export trade in foreign articles or the extent of their manufacture for home consumption, to the relative balance of trade, or to the great influx of money into Great Britain, and the great efflux of money from Ireland. They considered that if a just enquiry had been made ‘it would have appeared that this proportion for Ireland is not only unjust, but far beyond what it will be in her power to discharge.’


This address was thrown out by a majority of fifty-eight, and on June 7th the Union Bill was read for the third time in the Commons, and was then sent to the Lords, where it quickly passed through its three readings, though not without a further protest being entered on the Journals by the dissentient Peers. The Bill was then sent to Westminster, where it passed both Houses of Parliament, and received the Royal assent on August 1st, 1800.[752](javascript:footNote('E900040/note752.html'))


The commercial arrangements of the Union were



---

p.332



embodied in article 6 of the Treaty. All prohibitions and bounties in both Great Britain and Ireland were to cease, and a perfectly free exportation from one country to the other was to be established, corn only excepted. The goods of each country were to be imported into the other free of duty, with the exception of eighteen articles on which certain duties were to be placed, generally 10 *per cent* ad valorem; these were apparel, wrought brass, wrought copper, cabinet ware, coaches, cotton, glass, haberdashery, hats, hardware, gold and silver lace, millinery, stained paper, pottery, saddlery, silk manufactures and stockings. A drawback was to be given in those cases where a countervailing duty was taken, and the articles to be charged with a countervailing duty were in Great Britain — beer, bricks and tiles, candles, soap, cordage, printed cottons, cider, glass, leather, stained paper, silk, spirits, starch, refined sugar, sweets and tobacco; and in Ireland — beer, glass, leather, stained paper, silk, spirits, refined sugar, sweets, and tobacco. Salt and hops on importation into Ireland were to be charged with the duties now payable, and the Irish import duty on coals was also to be retained. There was to be no duty on foreign or colonial goods passing through either country to the other. Goods of either country were to be exported from the other subject to the same charges as if exported directly. The foreign and colonial trade of the two countries was to remain as before. The financial arrangements were more complicated and were embodied in article 7 of the Treaty. The wording is not clear, but the principal points of the article are as follows: — 
1. Each country was separately to defray the expenses arising out of the payment on the interest or sinking fund for the reduction of the principal of its own pre-Union debt.
2. (1) For the next twenty years the ordinary expenses of the United Kingdom in peace or war should be defrayed by Great Britain and Ireland jointly according 



---

p.333



to the proportion of 15 to 2; that is, Great Britain was to defray 15/17 or 88.24 *per cent*, and Ireland 2/17, or 11.76 *per cent* of the whole expenditure.
 (2) At the end of twenty years, unless Parliament had determined that the joint expenditure of the United Kingdom was to be indiscriminately defrayed by equal taxes in both countries, the respective contributions of Great Britain and Ireland were to be fixed in such proportions as would seem just and suited to the respective resources of the two countries.
3. Irish revenues were to constitute a consolidated fund on which the payments for Ireland's pre-Union debt was to be a first charge; the remainder of the revenue was to go to meet Ireland's share of the joint expenditure.
4. The respective contributions of Great Britain and Ireland were to be raised by such taxes in each country as Parliament might think fit to impose, but no article in Ireland was to be taxed at a heavier rate than in England.
5. If, after Ireland had defrayed the charge for her pre-Union debt and her proportional contribution to the expenses of the United Kingdom, there remained a surplus of her revenue, such surplus could be applied in any one of the following ways — viz., (a) in remission of taxation, (b) for local purposes, (c) in making good a deficiency of Irish revenue in time of peace, (d) in building up a reserve fund not exceeding five millions to relieve the Irish contribution in time of war.
6. [753](javascript:footNote('E900040/note753.html')) All debt incurred by Parliament after the Union for the service of the United Kingdom was to be regarded as a joint debt, and the charge of it was to be borne by the two countries in the proportion of their respective contributions.
7. If in the future the separate debts of Great Britain and Ireland should be liquidated, or if their values should be to one another in the proportion of their respective contributions to Imperial expenditure, Parliament might, if it thought fit, declare that all future expenses of the 



---

p.334



United Kingdom should be defrayed indiscriminately by equal taxes imposed on the same articles in each country
subject only to such exemptions and abatements in favour of Ireland as circumstances seemed to necessitate.



These financial provisions were not favourable to Ireland, but even commercially speaking, Ireland stood to
gain little from the Union. Seventy different kinds of Irish manufactures were affected by the clause of the commercial article forbidding import duties higher than 10 *per cent* ad valorem. The duty on silk stockings, to take one instance, was reduced from 4s. 8d. per pair to 1s. or 1s. 6d., and this would naturally increase the disadvantage under which the Irish silk manufacture laboured. Another clause of the article ordered that hops, salt, and coal were for ever to continue subject to the present duties on importation into Ireland. So in the future if Great Britain abolished her excise duty on beer, Ireland would not be able to lower her import duty on hops, and thus British beer, which would come into Ireland duty free, would have a preference over Irish. The duty on salt imported into Ireland had been raised in the last two years from 1s. a ton on rock salt to £3, a duty between 400 and 500 *per cent* ad valorem; but it had been laid down that this duty was to continue only for two years, and so it was unjust to Ireland and was also injurious to her fisheries that it should be made permanent. Coals, again, had hitherto been exported from Great Britain at a duty of 9d. per ton; this duty was to cease, but the Irish import duty on coal was to be made perpetual, and that at a time when all coasting duties in England and Scotland had been abolished. Dublin, especially, would suffer from this arrangement for the duty there on coals imported was 1s. 8 4/5d. per ton, while that in the rest of Ireland was only 9d. This was because a local duty of 1s. per ton existed in Dublin for the internal improvement of the city; this local duty was blended by the Union arrangements with the general duty



---

p.335



on the article, and its perpetual continuance was thus enforced. All this shows how little Irish affairs were understood in England. Injustice was probably not intended as regards the perpetual duties on hops, salt, and coal imported into Ireland, but their unjust effects are undoubted. The Union arrangements too, left the Irish breweries absolutely unprotected, allowing only a countervailing duty if the Irish excise on beer continued. None of the commercial terms of the Union gave any preference to Irish goods over foreign as the Commercial Propositions had done, and so even Irish linens were to have no security against the rivalry of foreign linens in the British markets. At the same time, the opening of the British markets to Irish manufactures could benefit Ireland little. Almost all the articles on the importation of which Great Britain had hitherto imposed very heavy duties could be worked up more cheaply by herself, and it was not possible for the Irish merchants to export these articles with any profit to England. It is true that the clause forbidding either country to lay prohibitions on the exportation of its goods to the other would enable Ireland to purchase British wool. But it would not benefit the Irish sailcloth manufacture to such an extent as **Lord Castlereagh** appeared to think, for Great Britain had discontinued her bounties on the exportation of sailcloth to Ireland in 1797, and for some time Irish sailcloth had been entering into Great Britain free of duty.[754](javascript:footNote('E900040/note754.html')) But it was, of course, of advantage to Ireland that in future England should not be able to give bounties or to place prohibitions on the exportation of her goods to that country.


There were no regulations concerning the corn trade in the commercial article, and it was feared at the time that when the existing bounties on the exportation of corn to Great Britain were taken off and also the conditional prohibitions on importation, Irish agriculture would lose



---

p.336



all that it had recently gained. But these fears proved groundless. England had ceased to be a corn-exporting country, and soon she was to cease to be even a large corn-growing country. Conditions in England, more especially during the war, were such as to give a perfectly sufficient premium on the importation of Irish corn, and the export trade in cereals to Great Britain was the one Irish trade which prospered greatly after the Union and which continued to prosper until the repeal of the corn laws.


But Great Britain and Ireland were too dissimilar in economic conditions to have the same commercial system, and this had been practically realised by **Lord Castlereagh** when he advocated the retention of the Irish protective duties on the importation of cotton goods. Irish manufacturers were bitterly opposed to the Union because they thought that under its arrangements of free trade between Great Britain and Ireland, Irish commerce would be ruined, and Irish industries would decline.[755](javascript:footNote('E900040/note755.html')) And it is certainly true that Ireland, unlike England, was not in a position to profit through free trade, and therefore she was not in a position to profit, commercially speaking, from the Union. The commercial advantages conferred on Scotland by her Union with England were often cited at this time in order to prove that benefits would likewise be conferred on Ireland. But the cases were not analogous. For one thing, it was many years before Scotch trade and industry began to progress even in a slight degree, and Ireland's material progress during the eighteenth century seems to have been as great as that of Scotland. But what is far more important, for nearly a century after the Union with Scotland, Scotch trade and industry were fostered and encouraged by bounties and protective duties. Scotland had entered into a Union when the ideas of protection reigned supreme in England, and her infant industries received the policy of protection necessary to



---

p.337



their firm establishment. But now, when Ireland was united to Great Britain, the new idea of free trade was coming to the front, and by surrendering her separate Parliament Ireland lost all chance of artificially fostering her native industries. Free trade under certain conditions cannot be an advantage. It could not be an advantage to a poor country like Ireland, in which industries were in their infancy, and which existed side by side in the closest commercial intercourse with a rich country where industries had long flourished.


The commercial arrangements of the Treaty of Union were, however, conceived in the main in a liberal spirit, for what **Pitt** wanted was to make intercourse as free as possible between the two countries. As regards the financial arrangements, there also seems no doubt that **Pitt** meant to do the fair thing by Ireland.[756](javascript:footNote('E900040/note756.html')) But the whole Union scheme of finance was founded upon a fallacious basis; the arrangements were mistaken in themselves, and time was to prove that they were unjust in their effects.


The standards taken by **Lord Castlereagh** as the basis for his comparison of the respective resources of Great Britain and Ireland could have established nothing. It was unfair to take the three years preceding 1799 as a basis for comparison, for the presence of a large military force in Ireland naturally caused a great increase in the consumption of dutiable articles in that country. Moreover, in the comparison of the respective resources of the two countries certain sources of revenue were omitted, such as stamp duties, post-office receipts, and the salt tax, all of which would have shown a smaller proportion for Ireland. Again, **Lord Castlereagh**'s actual estimate of 



---

p.338



Irish exports and imports was afterwards proved to be inaccurate. He computed their annual average value as nearly eleven millions, whereas the official statistics presented to Parliament in 1834 only made out the average in this period to be eight and a quarter millions.[757](javascript:footNote('E900040/note757.html')) But, putting aside all inaccuracies and misstatements, it is impossible to believe that any approximate estimate of the comparative resources of the two countries could have been obtained by merely comparing their respective exports and imports or their consumption of dutiable commodities. This was especially true of two countries like Great Britain and Ireland, whose economic conditions were so dissimilar, and whose populations differed in habits and customs.


In estimating the proportion of Imperial expenditure which Ireland should bear, **Lord Castlereagh** had tested his conclusions by examining whether the ratio of 7 1/2 to 1 which he had established would correspond with the ratio of past expenditure, exclusive of debt charge, of Great Britain and Ireland. He excluded all debt charges because the pre-Union debts were to be kept distinct, but this exclusion had the effect of rendering his reasoning fallacious. In such a calculation as **Lord Castlereagh** was attempting debt charges should certainly have been included both in time of war and in time of peace, for war necessitates borrowing, while in years of peace the debt charge incurred in time of war must be redeemed. If the debt charges of the two countries had been included in the estimate of their expenditures, the average annual British expenditure during the seven years of war taken by **Lord Castlereagh** was £43,034,000, and that of Ireland £3,089,501, so that the expenditure of Great Britain was to that of Ireland during this period not 9 to 1, as was calculated, but 14 to 1. Again, including debt charges in the single year of peace immediately preceding the war,



---

p.339



taken by **Lord Castlereagh**, the expenditure of Great Britain was £19,251,563, and that of Ireland £1,395,950, thus giving a proportion, not of 5 3/4 to 1, as was calculated, but of nearly 14 to 1 also.[758](javascript:footNote('E900040/note758.html')) So by leaving out debt charges in an estimate of the peace and war expenditures of Great Britain and Ireland, the proportion of Irish to British expenditure was falsely raised. **Lord Castlereagh** did not compare the total expenditures of the two countries; he compared only selected parts of their expenditure. At the same time, a calculation of the peace expenditure of a country based on the figures of a single year was bound to be worthless, while it was unjust to Ireland to estimate her average annual war expenditure from the expenditure period which included not only a foreign war, but also an invasion of Ireland and an actual rebellion.


The clause in the financial article providing that indiscriminate taxation might be imposed when the British and Irish debts should become to one another in the ratio of their respective contributions to Imperial expenditure was, as **Foster** had pointed out, exceedingly curious. An increase in the indebtedness of Ireland must lead to increased taxes. How, then, would Ireland be better able to bear equal taxation with Great Britain than at the time of the Union? But the explanation is that neither **Pitt** nor **Castlereagh** thought for a moment that in the future the ratio existing between the British and Irish debts would be raised by an enormous increase in the Irish debt, while at the same time a small increase took place in the British debt. What they both expected was that the British debt would decrease by the system of liquidation, while the Irish debt would at least not increase; then that the scale of British taxes would rapidly descend to the level of Irish, and consequently that indiscriminate taxation might be adopted without fear of injuring 



---

p.340



Ireland.[759](javascript:footNote('E900040/note759.html')) Neither **Pitt** nor **Castlereagh** looked forward to fifteen years of almost continuous war. But the long war with France vitiated all their calculations and estimates. The miscalculations made by the framers of the Act of Union were chiefly due to their failure to see the future increase in the expenditure of the United Kingdom, and for this failure they can, of course, hardly be blamed. But we have seen that the calculations themselves were inaccurate and founded upon fallacious reasonings, so that even if a long war had not followed, it is almost certain that Ireland would still have found herself overburdened. As it was, however, the huge expenses caused by the war exaggerated and intensified to a high degree the injustice to Ireland which would have in any case existed. But it must be remembered that the same facilities for applying statistical tests as to the respective resources of the two countries did not exist at the time of the Union as they do now, though even at the present day these statistical tests are insufficient. To our modern ideas the standards taken by **Lord Castlereagh** as the basis for his comparison seem, to say the least of them, inconclusive, and we are surprised that his methods should have been so inaccurate and his ideas so fallacious. But there is no reason to believe that he purposely misstated his facts, although it was a misfortune that he did not give more satisfactory papers concerning them to the Irish Parliament. The figures used by **Lord Castlereagh** were never submitted to examination, nor are they supported by any available documents. As for **Pitt**, his sincerity is undoubted, and it is probable that, had he lived to see the enormous increase in the Irish debt side by side with a considerable increase in the British debt, he would never have attempted to subject Ireland under such conditions to the burden of equal taxation with



---

p.341



Great Britain, even though the debts of the two countries had become to one another in the ratio of their respective contributions. But he evinced short-sightedness in not fixing a maximum limit to the total taxation of Ireland in order to guard her from too great a pressure in the event of a large and prolonged increase of expenditure. The possibility of the continuance of the war should surely have been taken into account.




---

p.342


The Economic Condition of Ireland during the Nineteenth Century
---------------------------------------------------------------


General Survey — Irish Commerce and Industry — Economic Condition of the Irish People from the Union to the Famine — Their Condition since the Famine.
The economic history of Ireland during the nineteenth century divides itself naturally into two periods, the famine of 1846 and 1847 forming the dividing line. Prior to the famine the population steadily increased and the conditions of life among the mass of the people grew from bad to worse. Just when the poverty and misery of the Irish people had reached the height so graphically described to us in the report of the **Devon Commission**, the failure of the potato crop, on which the majority of the population entirely depended for their mere existence, led to thousands of deaths by starvation and the commencement of the period of emigration which is still continuing. The net result of this process of emigration combined with the ravages during the famine has been a decrease in the population from eight millions to under four and a half. The greatest diminution took place from the famine to the middle of the sixties; the rate of decrease then diminished, and in 1877 there was even a slight rise in the numbers of the people. But the decade 1881–91 showed a large increase of diminution, which, however, has fallen in the last decade 1891–1901.[760](javascript:footNote('E900040/note760.html')) For a long time after the famine 



---

p.343



the condition of the Irish peasants did not improve, but by 1885 the earnings of agricultural labourers, which forty years before had averaged from 2s. 6d. to 3s. a week, had increased to 6s. or 7s. a week, this increase taking place almost entirely during the last part of the period. Since 1885 the rates of labour have slightly risen and now average from 7s. to 9s. a week. The last twenty years have also witnessed the interference of the State between landlord and tenant in Ireland in order to secure to the Irish peasant safety of tenure, security from an unfair increase of rent, and better conditions of living. On one side there has been a legislative regulation of rent and restriction of the landlord's power, on the other an effort on the part of the State to replace the relation of landlord and tenant by the establishment of an occupying ownership. The result of this action of the State has on the whole been to improve the economic position of the mass of the Irish people through the reduction of rents and the opportunity of undivided ownership, although the policy of regulating rents has been attended with certain undesirable consequences. But though something has been accomplished since 1880, material improvement has only been comparative, and at present the condition of the labourers and smaller occupiers constitutes the most serious problem in Ireland.


The last twenty years of the nineteenth century have been for Ireland years of economic strain, for the pressure of foreign competition has necessitated a transformation in the most important Irish industries and has deprived them of the old advantages in the English market which they used to possess. The whole effects of free trade in widening the English market took many years to work themselves out, and did not fully appear until about 1880, when the pressure of competition greatly increased the fall of wholesale prices which had been going on for some time, and led to much distress among Irish farmers. Events during the last half of the nineteenth century have resulted in a great increase of pasture lands and a decrease of arable, 



---

p.344



so that Irish agriculture has in this respect been drifting back to the position it occupied before Foster's Corn Laws of 1782 and the transformation in the English corn trade. The repeal of the English Corn Laws in 1846 gave the first check to the growth of Irish grain and the export trade in cereals, but the full effects of the new policy did not appear until in later years the cultivation of the vast corn fields of America and Eastern Europe, combined with the increasing expenses of transportation, led to such a fall in prices that the Irish corn-grower found it more and more impossible to compete with foreign grain merchants in the English market. At the present day oats and barley are the only two arable crops grown to a large extent in Ireland, and the stability of the acreage under barley is no doubt due to the brewing industry. The breeding of live stock, the bacon-curing industry, and the various dairy industries are the most important occupations of the Irish people; their recent reorganisation is leading to splendid developments, so that in course of time it is possible that Irish
provisions will take their old place in the English market. Side by side with this change in the staple industry of agriculture there has been a transformation in the manufacturing industry of the country. Industrial life is not so widely distributed now in Ireland as it was at the beginning of the nineteenth century. The Industrial Revolution produced the same changes in Ireland as in England by depriving the people of their domestic industries and concentrating manufacturing industry in the towns. Only in Ireland the change has not been so thorough, for the Irish peasant women have continued to spin and weave a great part of their own clothing, and there has not been a marked tendency to leave the rural districts for the towns within Ireland. On the other hand, free trade, which has resulted in developing to such a great extent the manufactures of Britain, has done much to decrease the industrial life of Ireland. No doubt the exports of linen, porter, and whiskey at the present day are worth more in money



---

p.345



value than the whole amount of manufactures exported prior to the Union, but industrial life is spread over a much smaller area now than it was then, a smaller percentage of the population is employed in industrial pursuits, the many minor industries which flourished before the Union disappeared in the latter half of the nineteenth century, the smaller towns sank into decay, and Irish manufacturing industry became confined within strict limits. Quite recently there has been a reaction, and the industrial revival which is now taking place in Ireland and which bids fair to be successful, tends to re-establish industrial life among the Irish peasants in their own homes rather than to follow the example of England, and still further emphasise the division between town and country.


There is little material for estimating the industrial condition of Ireland in the period subsequent to the Union, more especially after 1826, when the British and Irish customs were amalgamated and separate accounts of trade between the two countries ceased to be kept. The Imperial Parliament seems to have felt little interest in the infant manufactures of Ireland, and the new policy of laissez faire held State interference in industry to be foolish and even dangerous. We miss the discussions concerning Irish industries which used to take place so frequently in the Irish Parliament and the brief accounts of their progress which were entered in the Commons Journals. Fortunately for the first twenty-three years of the century we have official figures of Irish exports and imports,[761](javascript:footNote('E900040/note761.html')) and these figures show that the trade of the country was on the whole progressing, although the rate of progress was very much slower than in the years preceding the Union. Also the progress that was made was not uniform; there was advance in some directions and decline in others. The most noticeable decline in 



---

p.346



exports was that of manufactured woollens. We have seen that there had been a decrease in the exportation of these articles just before the Union, but that this must be partly accounted for by the general disturbed condition of the country. After the Union, however, the export trade instead of reviving continued to decrease and was at all times very fluctuating.[762](javascript:footNote('E900040/note762.html')) At the same time the importation of woollen cloth into the country increased considerably, and this seems to have been due partly to the large growth in the population of Ireland, partly to the further decay in the Irish manufacture of all but the coarsest stuffs. The mass of the Irish people continued, however, for some time to supply most of their own wants in the way of frieze, flannels, and other coarse materials, but from 1820, when the protective duties were withdrawn, a further decline took place in the Irish woollen industry, due to the inability of the small manufacturers to compete with English capitalists and also to the application of machinery to spinning and weaving. We are told that during the first years of the century twelve fairs used to be held every year at Rathdrum, in County Wicklow, and 1,200 pieces of flannel on an average offered for sale at a single fair. But after 1820 the trade began to decline, and in 1830 the Flannel Hall had to be closed and the fairs stopped.[763](javascript:footNote('E900040/note763.html')) A weaver from County Roscommon stated before the **Poor Enquiry Commission** of 1835 that eighteen years before he could earn 2s. or 2s. 6d. every day in the year by weaving woollens or linens. For five or six years these wages had continued, but about 1822 or 1823 they had begun to drop. All the weavers in his neighbourhood who were able to turn their hands to something else had done so, only the old men who were fit for no other work keeping to the trade. Now 8d. a day was the most that could be earned. No friezes or flannels had been made at



---

p.347



all during the last two years.[764](javascript:footNote('E900040/note764.html')) In Roscrea, County Tipperary, the Commission found that the woollen weavers had been without employment for the last four or five years. The manufacture of serges and coarse flannels and stuffs had all declined since the removal of the 10 *per cent* protective duties, for the small local industry could not withstand British competition now its slight advantage had been taken away. One manufacturer stated that at one time he used to employ 1,000 persons, the women spinning worsted and the men carding and weaving the wool. The men had earned 1s. 8d. a day at weaving and 1s. 4d. at carding and the women 1 1/2d. at spinning. But now one-third of his weavers had been forced to emigrate to England and he could give no work to those who remained behind.[765](javascript:footNote('E900040/note765.html')) It was difficult, if not impossible, for a small Irish manufacturer with little capital to erect the new expensive machinery which British capitalists were beginning to use and which was resulting in such a cheapening of production. As the era of the development in mechanism advanced, Irish manufacturers, more especially the woollen manufacturers, found that they had not the material resources necessary to meet it, and the ruin of the woollen industry was more complete than that which had resulted from the repressive legislation of nearly a century and a half before. This ruin, however, was the indirect result of that very legislation, for the period of freedom from 1780 to the Union was too brief to allow of an accumulation of capital and increase of skill without which it was impossible for Irish manufacturers to compete with British. After the Union conditions were, from various causes, less favourable to the development of those Irish industries which were not already firmly established, and when the removal of the 10 *per cent* protective duties took place Irish manufacturers lost the trifling advantage



---

p.348



which this duty had given them in the home market. But the erection of new machinery put the finishing touch to the ruin of the Irish woollen industry by rendering it impossible to carry on the manufacture without a considerable amount of capital. It is only since about 1870 that the industry has shown some signs of recuperative power. From 1874 to 1889 the number of power looms employed in the industry increased from 307 to 925.[766](javascript:footNote('E900040/note766.html')) Since 1889 the factory industry has held its own, the total number of hands employed being at the present day 3,323.[767](javascript:footNote('E900040/note767.html')) Irish tweeds are famous for their durability and good workmanship, and the demand for them is increasing. The home-weaving industry is, however, much more important than the factory industry, and since 1893 a considerable quantity of home-spun cloth has been exported from County Donegal to foreign markets.


The application of machinery naturally led to a temporary decline in other Irish trades. From the Union to 1823 the exports of linen did not increase. In the article of plain linen cloth the export was fairly well maintained, but the quantities of coloured linen, cambric, and lawns sent abroad decreased.[768](javascript:footNote('E900040/note768.html')) This is the first period in the history of the Irish linen industry in which the exportation of linens did not increase, and this fact must be attributed to some extent to the rivalry of the cotton manufacture. In 1800 it appeared in evidence before Parliament that the cotton industry employed 27,000 persons within a circuit of ten miles, comprehending Belfast and Lisburn.[769](javascript:footNote('E900040/note769.html')) The progress that was being made was chiefly due to the introduction of water mills for spinning twist. Very much higher wages were paid than in the linen manufacture, and much more advanced



---

p.349



methods were used. Instead of the weaver buying his yarn and selling it in a manufactured state, the yarn was given to the weaver by the master manufacturer, who paid him so much the piece for his labour, or it was woven on looms erected within buildings belonging to the manufacturer. While linen yarn was still being spun by hand, cotton yarn was being spun by machinery. In Antrim linen looms were rapidly exchanging for cotton looms. As early as 1801 the cotton industry was also flourishing in the counties of Louth and Wicklow. At Stratford, in Wicklow, the wages of the cotton operatives were particularly high; male weavers of fancy cottons could earn as much as two guineas a week, ordinary weavers about 30s.; while women could earn 6s. or 7s. a week by weaving, wages being paid by the piece.[770](javascript:footNote('E900040/note770.html')) Besides calicoes and cottons a large amount of muslin was manufactured, sufficient indeed to meet all the home demand and yet to afford some surplus for exportation.[771](javascript:footNote('E900040/note771.html')) A good muslin weaver could earn 18s. to 20s. a week, or double the wage of a linen weaver,[772](javascript:footNote('E900040/note772.html')) and as any linen weaver could easily learn to weave muslin it is not surprising that many persons left the linen industry to work at the cotton. Velveteens and corduroys were also made in large quantities, and for the first quarter of the nineteenth century the cotton manufacture bid fair to become the staple industry of Ireland. There was a slight decline in the manufacture about 1816, when the system of bounties and import duties began to cease, but the industry revived and enjoyed a further period of prosperity until the years directly following 1825, when the firm establishment of the system of spinning flax by machinery led to a revival in the linen industry. This new **wet spinning** process,



---

p.350



which was introduced into Ulster between 1825 and 1830, enabled much finer linen to be made. In 1825 Scotch and English machine-spun yarns imported into Ireland began to supersede the Irish hand-spun article, and thus the Irish were forced to adapt themselves to the new conditions, and began to adopt the system of spinning linen yarn by machinery. The adoption of machinery had been hindered by the cheapness of hand spinning in Ireland, for a woman would spin from morning to night for 2d. a day, and the yarn she spun was finer than the yarn spun by the older machines. Now, however, it way found that the new machinery could spin even finer yarn than the most skilful hand spinner, while the output could be enormously increased. The linen manufacturers of Ulster were always men possessed of a certain amount of capital, in spite of the depression in the trade due to the rivalry of the cotton manufacture, and so they were able to reorganise their industry on modern lines. From this time also efforts to promote the growth of flax in Ireland ceased, as the Irish manufacturers found it more profitable to import the cheap foreign flax. Side by side with the new development in the linen industry due to the application of machinery, there proceeded a rapid decline in the cotton manufacture. This decline is very puzzling. It has generally been attributed to the cessation of the large protective duties, but these duties ceased nearly ten years before the decline commenced. The decay of the industry coincides with the new development of the linen manufacture, just as its growth at the beginning of the century seemed to lead to a decline in that manufacture. The sewed muslin trade of Ulster alone continued to progress, and until 1865 it gave employment to 300,000 persons.[773](javascript:footNote('E900040/note773.html')) From that time, however, it rapidly declined, the decline being seemingly due to changes of fashion.



---

p.351



Now the cotton manufacture has practically ceased to exist in Ireland.


The only other export trade of much importance was that in manufactured glass. This industry had progressed almost more than any other after the repeal of the commercial restrictions, and after the Union the exports of different kinds of glass continued to increase.[774](javascript:footNote('E900040/note774.html')) There are, however, few notices of the trade during the nineteenth century, and after 1823, when the accounts of exports cease, we have no means of estimating its importance, nor have we any record of the causes which eventually brought about its decay. The repeal of the excise on glass in Great Britain in 1845[775](javascript:footNote('E900040/note775.html')) may have done something to bring about a decline in the Irish glass industry by removing the special disadvantages under which British glass manufacturers had laboured for over half a century, and placing the manufacture in the two countries on terms of equality. The industrial history of Ireland during the nineteenth century shows how impossible it was for Irish manufacturers to compete with British once the two countries were commercially united, and all custom duties on articles going from one country to the other gradually abolished. It also shows the advisability of a country possessed of little industrial development fostering and protecting its infant manufactures until they are firmly established in order to prevent them being crushed out of existence by the competition of other countries. But union with Great Britain necessitated the application of the new free trade principles to Ireland just at the time when Irish industries should have met with encouragement and protection.


The Irish silk manufacture had never been large or particularly prosperous, and it had been completely paralysed during the Rebellion. After the Union the



---

p.352



revival of the industry was hindered by trade combinations of the weavers, who demanded higher wages than the master manufacturers could possibly give. In 1809 the Berlin Decrees, by raising the price of raw silk to an enormous height, threw many of the Dublin silk weavers out of employment. The 10 *per cent* import duty on foreign and British silks never benefited the Irish industry on account of the heavy import duties levied on raw silk for revenue purposes, only portions of which were drawn back on the exportation of the finished article;[776](javascript:footNote('E900040/note776.html')) and the result of the depression in the trade was the emigration of many Irish weavers to Macclesfield and Manchester, where higher wages could be obtained.[777](javascript:footNote('E900040/note777.html')) In 1821, when the protective duties expired and the drawback on the exportation of home-manufactured goods was taken off, Ireland was inundated with cheap English silks. The establishment of steam communication between Great Britain and Ireland enabled English manufacturers to export their goods at less cost to Ireland, and the ruin of the Irish silk industry was completed. The Dublin silk weavers seem to have been a turbulent set of men, and always refused to meet their employers half-way. They appear to have been skilled workmen, and were welcomed as weavers at Macclesfield and Manchester. We are told that in 1840 there were more Irish than English weavers in the former place.[778](javascript:footNote('E900040/note778.html'))


The poplin manufacture of Dublin continued, however, to enjoy a certain amount of prosperity at various times. It was at its best at the beginning of the nineteenth century, but for a long time after it was subject to much fluctuation on account of changes in fashion. But in the early sixties fashion seems to have veered round again in 



---

p.353



favour of the material, for from that year the poplin trade increased. In 1862 there were two factories in Dublin employing only 134 persons, but in 1868 as many as 440 were employed.[779](javascript:footNote('E900040/note779.html')) Poplin was exported to the United States and to the Continent,[780](javascript:footNote('E900040/note780.html')) and at the present day considerable amounts are sent to England and the Continent, as well as to Asia, America, and Australia.[781](javascript:footNote('E900040/note781.html')) The industry, however, cannot be said to be thriving. Poplin is everlasting in wear, but in these days of rapid changes of fashion ladies do not want stuffs that never wear out, and the poplin industry also suffers from the fact that the material cannot be so variously treated in the matter of pattern and ornament as silk. Poplin making, however, is a manufacture in which Ireland leads the world, for the peculiar beauty of colouring and texture of the Dublin fabrics has never been approached in any other country.


As regards all those other minor industries about which we hear so much before the Union, they seem to have rapidly disappeared, crushed out of existence by British and foreign competition, and handicapped, as all Irish industries are in this era of coal and steam, by the absence of any large available supply of minerals in the country. The numerous country towns which before the Union and for some years after had employed many people in their various local industries, had dwindled and decayed by the middle of the nineteenth century, and the report of the **Devon Commission** just before the famine shows us that the mass of the Irish people were more dependent upon the land than they had ever been before, even in the days of repressive commercial legislation.


An enquiry into the economic condition of the Irish agricultural population during the first half of the nineteenth century shows a gradual deterioration in their standard of comfort. It is probable that just before and



---

p.354



just after the Union the poorer class of Irish agriculturists were better provided with the necessaries for subsistence than they have ever been until the last twenty years. It is easy for us to get a rough idea of their material condition at the beginning of the century. The statistical surveys of twenty Irish counties, written by order of the Dublin Society, **Newenham**'s statistical surveys, and **Wakefield**'s comprehensive Account of Ireland, written in 1812, give us a detailed account of the life of the Irish peasants, their relations with their landlords, their manner of living, and the way in which they were able to eke out their scanty wage in order to obtain the necessary means of subsistence for themselves and their families. The accounts show that the majority of the Irish people were still miserably poor, but if we compare their condition at the time of the Union with their later condition, as shown to us in the Reports of the **Poor Enquiry Commission** of 1835 and the **Devon Commission** of 1845, just before the potato famine, we have to acknowledge that, materially speaking, they retrogressed rather than progressed during the first half of the nineteenth century. In 1845 we notice one great change in the diet of the ordinary labourer; he can no longer afford much milk with his potatoes. The family earnings had dwindled through the decay of the ancient cottage industries of spinning and weaving due to the application of machinery, the population had grown enormously, the earlier system of subdividing farms had increased the number of very small holdings, while the later policy of consolidation on the part of the landlords had led to the dispossession of numbers of small holders and converted them into mere agricultural labourers, renting a cabin and a potato garden from their employers. Then came the famine, changing the face of Ireland and rendering necessary a reconstitution of the whole social order. Since then the country has been depleted of the strongest and most spirited of its young men and women, once fertile lands



---

p.355



have gone out of cultivation, and only since about 1880 has there been any marked improvement in the condition of the Irish people who have remained in Ireland.


At the beginning of the nineteenth century the population of Ireland seems to have numbered about four-and-a-half millions. There are, of course, no absolutely reliable returns; the estimates depend on data such as the returns made of houses for the collection of hearth money. **Wakefield** tells us that in 1791 there were 701,102 houses in Ireland. Of these, 112,556 were exempt from the hearth tax of 2s. as being inhabited by paupers; 21,866 were exempt as being newly built, and for 15,052 houses the returns were imperfect. Of the remaining 552,628 houses, 483,990 had only one hearth, while there were only 36,437 possessed of more than two hearths.[782](javascript:footNote('E900040/note782.html')) If we add together the houses inhabited by paupers and those with only one hearth, we see that 85 *per cent* of the houses in Ireland were of the poorest description. Such a statement, however, does not imply the same amount or degree of poverty as it would at the present day. House accommodation in Ireland among all classes was very much worse a century ago in proportion to their wealth, and occupants of one-hearth houses were not necessarily very poor, for they sometimes occupied as much as forty acres of arable land. But making all allowances of this kind, there must have been a great amount of acute poverty in Ireland, and probably ten years later, just after the Union, a period for which no returns are extant, the number of one-hearth houses had increased owing to the operation of the Catholic 40s. elective franchise.


There were three classes of labourers in Ireland — the cottier, the bound labourer, and the out labourer. The cottier was the most fortunate. He was bound to work for his employer all the year round, and his employer was supposed to give him work when he wanted it. His



---

p.356



wages were generally 5d. a day in winter and 7d. a day in summer, but in the better parts of the northern counties they were often 6d. in winter and 8d. in summer. The cottier would get a cabin and half an acre of potato ground for a rent of about 30s., and grass and hay for a cow for about 2 *l*. He had generally the run of a pig and calf, and sometimes of a lamb. Sometimes more land would be given and less wages. The potato was the chief means of subsistence for the cottier and his family. In fact, his comfort was more or less in proportion to the value of his potato garden, for on its produce he and his family lived. The potatoes also supported the pig, and the pig was the chief means of paying the rent. The cow provided milk for the family and a certain amount of butter, which was sold to help to meet the rent. If a cottier received his proper wages, if his potato garden produced a plentiful crop, and if he had a wife who could eke out the family earnings by spinning and weaving, as was generally the case, he was able to exist in some degree of comfort, for there would always be a sufficiency of food and clothing for himself and his family. Of course, in those years when the potato crop was bad or actually failed, the result was practical starvation for a cottier family; and if a cottier had a cruel or dishonest employer, who cut down his wages and allotted him a plot of bad grass for his cow, his life would be a hard one.[783](javascript:footNote('E900040/note783.html')) But in general the cottier could get along fairly well. The bound labourer was less well off. He had to work every day for his employer, but had not a house or other advantages from him, and so had to buy everything himself at market price, which seems to have been generally more expensive. His wages, however, were higher — 8d. a day for the winter half year and 10d. for the summer. The condition of the out labourer was bad. He was bound to no master, but simply obtained work where he could get it. His wages, indeed, were



---

p.357



high — in spring and summer 10d. to 1s. a day, and for the harvest week he sometimes obtained as much as 15s. or 18s.; but his employment was precarious, and he seldom got any work at all during the winter months. Of course, the condition of the labouring classes differed in various parts of the country. In Ulster the cottagers' cabins were better, and the diet of the people was more varied than in the other provinces. Besides the usual potatoes and milk, they had oatmeal, with perhaps a little butter in the summer, and an occasional bit of bacon.[784](javascript:footNote('E900040/note784.html')) In Leinster conditions were not so good. Potatoes and milk were the universal food, and bacon only appeared on Gregory Days and at Christmas and Easter. Going down to the South, we find conditions slightly worse, for milk was less plentiful. On the coast, however, the people were able to eke out their supplies with fish and seaweed. In Connaught the poverty was great in certain districts, and here milk was often an unattainable luxury. Roughly speaking, wages were much the same all over Ireland, the average for the whole year being 6d. a day for the cottier class. Employment was fairly continuous except for the out labourer, with his higher wages; but rents had risen, for a wretched cabin and an acre of ground in which to plant potatoes was held from 50s. to 55s. a year.[785](javascript:footNote('E900040/note785.html'))


Fortunately the labourer's wife and daughters could generally help to meet this increased rent by dressing and spinning flax in some parts of the country, and by knitting and weaving woollen stuffs in other parts, all this, of course, being in addition to the ordinary clothing of the family. A large amount of flax was now grown by small occupiers — **Wakefield** estimates it at 20,000 acres[786](javascript:footNote('E900040/note786.html')) — who rented an acre of flax land, and grew and spun their own flax, selling it in the form of yarn.




---

p.358


The relations which existed between landlord and tenant are too familiar to need much discussion. The landlords never expended anything on buildings or repairs; they recognised no obligations on their part towards their tenants, and it was this fact which made the rents they demanded really higher than their actual money amounts. There was no security of tenure, nor any means by which the extortionate demands of the landlords might be resisted. All this naturally prevented the Irish peasant from exerting himself to better his condition; but, on the other hand, actual subsistence cost the people little. Except in bad seasons, potatoes and milk, and often oatmeal, could always be had; all the clothing was made at home, and it was rare for a man to be without either a cow or a pig.


Above the labourers were the farmers, and the more well-to-do seem to have been prosperous enough. Their housing, indeed, was wretched, but they were making large profits from the war prices for their corn and other provisions. But at the close of the war, when prices fell, there was great distress in Ireland. The extension of the 40s. franchise to Catholics, combined with the new conditions affecting agriculture, had gradually been producing evil results. Landlords realised the importance of procuring a numerous following of tenantry, and the tendency towards subdivision and subletting was emphasised. Under the influence of war prices agriculture progressed, and there was a great demand for labour. Land rose in value, and as the prices for provisions raised the profits of the occupier, he was able to pay a higher rent to the mesne lessee. In consequence lessees made large profits by subletting, and a new class of intermediate proprietors sprang up. In this way many small holdings came into existence. Methods of cultivation became worse and worse, and the soil deteriorated through bad tillage. When peace came the fall in the prices of agricultural produce prevented people from paying their inflated rents. The 



---

p.359



sub-tenants could not pay the middlemen, and the middlemen were just as incapable as their tenants from meeting their engagements. All became impoverished. The middleman parted with his interest, or underlet the little land which he had hitherto kept in his own hands; he and his family were soon ruined. In many cases the landlords were obliged to look to the actual occupiers for their rents. They grew afraid lest they should have a pauper population on their hands, and began to consolidate their farms. It was supposed that consolidation would lead to better methods of cultivation, to a greater certainty of crops, to better buildings, and an improvement in agricultural produce. Unfortunately it had to be combined with what is known as the **clearance system**. Numbers of tenants were evicted, and the distress was terrible. In 1829 the Act destroying the political status of the 40s. freeholder gave a further impetus to the consolidation of farms, and the consequent eviction of tenants. It was the increase of mendicancy and want of employment due to this new policy that led to so many parliamentary enquiries into the state of the poorer classes in Ireland. In 1823 the Select Committee appointed to make an enquiry into the condition of the Irish labouring poor described the condition of the people in the distressed districts as ‘wretched and calamitous to the greatest degree.’[787](javascript:footNote('E900040/note787.html')) This distress they attributed to want of employment, and another Select Committee appointed the following year stated that even those labourers who were tolerably well employed would not earn more than 4d. or 5d. a day, one day with another.[788](javascript:footNote('E900040/note788.html')) In 1830 a Select Committee appointed to make a similar enquiry stated that one-fourth to one-fifth of the Irish population were without employment. They spoke of the ‘misery and



---

p.360



suffering which no language can possibly describe, and which it is necessary to witness in order fully to estimate.’[789](javascript:footNote('E900040/note789.html'))


From this time the distress of the agricultural population of Ireland increased so greatly that Government began to meditate upon the advisability of extending the Poor Law to that country. In 1833 Commissioners were appointed to make an extensive enquiry into the condition of the Irish poor, the causes of the existing distress, and the means by which it might be remedied. The Commissioners reported in July, 1835, and from their report and the evidence taken by them we get a vivid idea of the condition of Ireland.


The Commissioners give an amusing account of the way in which they were assailed by the theories of persons who had ‘no means of forming a sound judgment’ concerning the poverty of Ireland. Some people attributed the state of the country to the use of ardent spirits, others to trade combinations, others still put down all evils to the existing connection between landlord and tenant, while pawnbroking, a redundant population, absence of capital, peculiar religious tenets, political excitement, want of education, maladministration of justice, state of prison discipline, want of manufactures and inland navigation, were all mentioned as the primary causes of the present poverty. Loan funds, emigration, the repression of political excitement, the introduction of manufactures, the extension of inland navigation, and the reclamation of waste lands, were accordingly proposed as the principal means by which the improvement of Ireland might be effected.[790](javascript:footNote('E900040/note790.html')) The Commissioners themselves made few practical suggestions, but the evidence they took shows us how greatly the condition of the Irish cottier had deteriorated during the last twenty years.




---

p.361


The agricultural families in Ireland numbered two-thirds of the total number of families in the population, while in Great Britain they only numbered one-fourth. At the same time there were in Ireland five agricultural labourers for every two that there were for the same quantity of land in Great Britain. ‘In whole districts,’ we are told, ‘scarcely one of that class of substantial capitalist farmers so universal in England can be found. The small resident gentry are but few, and the substantial tradesman is not to be met at intervals of two or three miles, as in England; for there are but few towns of sufficient trade to create such a class.’[791](javascript:footNote('E900040/note791.html')) So the Commissioners practically confined themselves to obtaining evidence as to the condition of the agricultural labouring class. Everywhere it was agreed that the wages of the poor ‘do not afford half-provision for their youth, much less a support for their old age.’[792](javascript:footNote('E900040/note792.html')) Even in Ulster, which was by far the most prosperous of the four provinces, on account of a better system of land tenure and the employment given by the linen manufacture, comfort was only comparative. The agricultural labourer earned his 1s. to 1s. 4d. a day on an average only three days in the week. From December to March hardly any employment could be obtained at all, but this was the time when the potato crops were dug up, and the labourer and his family could subsist on these potatoes till the spring. The hardest time in the year was from May or June till August, when the labourer was again out of work and his stock of potatoes exhausted. During these months he was often forced to go harvesting in England, leaving his wife and children to support themselves as best they could. Throughout the rural districts of Ulster the people were suffering from the withdrawal of the linen manufacture to the towns. The County of Donegal seems to have suffered most from this new



---

p.362



concentration of the manufacture in the towns.[793](javascript:footNote('E900040/note793.html')) Hitherto the Donegal peasants had chiefly supported themselves by spinning flax and weaving linen cloth in their own homes, for they were able to get but a scanty living from the soil. Now they were sunk in the utmost distress, and the Commissioners bore witness to the universal destitution. In Leinster labourers could only get employment during the six months of spring and autumn, and 10d. a day was the most that was earned in the best season. In the summer, when there were no potatoes and no work could be obtained, the labourers and their families existed on weeds. In Munster conditions were much the same, only slightly worse. The agricultural population was larger, and the demand for land was keener and the rents higher. The rent for an acre of con-acre for potatoes would sometimes be as much as £10 if the ground was prepared, and it generally took a man 250 days of the year to work out the rent of his cabin and potato ground. But often the landlord demanded the rent in cash, and the labourer was forced to raise the necessary sum by the sale of his pig and the wages he obtained harvesting in England. If the labourer failed to obtain work in England, as was often the case, his condition was pitiable in the extreme, and the Commissioners reported that death by starvation was common. The Kerry landlords were the worst in the country, and they rack-rented the farmers to such an extent that the latter were little better off than the labourers. Tenants of from one to ten acres were only nominally superior in their material position to labourers, and they were continually sinking to the status of labourers through being dispossessed of their holdings. But in Connaught the prevailing misery was terrible. Nearly all the farms were held by men too poor to employ any outside help, and labourers only got work about one day in four, and for this work the wages were 4d. or 5d. a day, except during 



---

p.363



the harvest week, when a man could earn 1s. 3d. a day. The Connaught labourers sometimes hired land for potatoes from their neighbours, or sometimes they took possession of a portion of the waste ground, which they were allowed to hold rent free until they had reclaimed it, and so made it fit to bear rent. When their potatoes were planted they were often forced to leave their homes and beg in some neighbouring district. Even in Connaught, however, there was a great dislike to begging, and the peasantry were ashamed to be seen by their neighbours supporting themselves in this way. It was rare for any of them to go harvesting in England, for they could not manage to raise the few shillings necessary for the journey. The small occupiers were nearly as destitute, and when their neighbours did not assist them they often died of starvation, as nothing would induce them to beg. There was no season of the year in which the Connaught peasants were sufficiently supplied with food. Their diet was simply inferior potatoes called ‘lumpers’ eaten dry, and the small farmers were often forced to bleed the one cow they possessed when their stock of potatoes was exhausted.


Thus wages of labour and conditions of living varied slightly in different parts of Ireland, the poverty of the people getting more extreme as the southern and western districts were approached. Taking the country as a whole, the average daily wage was 8d. in summer and 6d. in winter, and the Commissioners agreed that, keeping in view the scarcity of employment, 5d. a day all the year round, or 2s. 6d. a week, was as much as the average man could expect.[794](javascript:footNote('E900040/note794.html')) With his miserable income of 2s. 6d. a week at the most a man would generally have to pay a rent of £2 for a small cabin, with no ground, and another £4 for half an acre of potato ground. The produce of the potato patch maintained the labourer, his family, and his



---

p.364



pig for most of the year, and the sale of his pig helped to pay the rent. It was unusual for a labourer to possess a cow or a calf, as he had done thirty years before, and so he lost the profit from the sale of his butter, while he could no longer give his children milk. Rents had gone up enormously since the beginning of the century. Then £2 to £2 10s. had been the average rent for an acre of ground; now it averaged from £6 to £8, according to whether the land had been prepared or not, and sometimes, as in Kerry, it touched £10. For the small farmer, as well as for the labourer, dry potatoes was the ordinary diet, for if he kept a cow he was compelled to sell the milk as the only way of making up his rent. We are told that it was a good Sunday's dinner for one of these small holders if he could get himself a salt herring on Saturday night,[795](javascript:footNote('E900040/note795.html')) and, with all this poverty, grown-up married children managed to support their old parents when past work, and, as it was everywhere testified, invariably treated them with kindness and consideration.[796](javascript:footNote('E900040/note796.html')) The decay of subsidiary employment by domestic manufactures had caused much of the distress which existed. At the beginning of the century an agricultural family could earn a considerable addition to its income by spinning woollen or linen yarn, and even making the yarn into cloth. Now the decline of the woollen industry, and the revolution in the manufacture of linen, had hit these small spinners and weavers severely. Flax ceased to be grown much except for home use, and men who had supported themselves partly by weaving were forced to depend entirely on their wages as agricultural labourers. The towns in Ulster, especially Belfast, were the only places where the people had some sort of comfort. In Belfast there were twenty mills for spinning linen yarn, employing 7,000 persons, and several factories for weaving linen cloth, employing 1,000 persons. There were also



---

p.365



various manufactures of minor importance. Spinners earned £1 a week, and linen weavers 8s. to 12s., these wages being nearly as high as those earned by linen workers in England.[797](javascript:footNote('E900040/note797.html')) But the once flourishing Dublin manufactures had decayed, and in Cork and Limerick there was little employment, and fearful destitution. We are told that the people in these towns were worse off than the occupants of the famous cellars in Liverpool, and the census of 1841 stated that one million families, or not much less than five-sixths of the total Irish population, were living in mud huts or in single rooms of large houses.[798](javascript:footNote('E900040/note798.html'))


The chief result of the Report of the Poor Enquiry Commissioners of 1835 was the extension, three years later, of the Poor Law to Ireland. The immediate consequence was to cause great distress among the landlord class. In some places the rates were 20s. in the pound, and for two years no rents could be paid, as the poor rates absorbed the whole of the farmer's surplus produce.[799](javascript:footNote('E900040/note799.html')) Numbers of evictions took place, and even before the famine emigration to America had begun. It was because of this dreadful condition of things that the Commission, generally known as the **Devon Commission**, was appointed to enquire into ‘the State and Practice in respect to the Occupation of Land in Ireland,’ and to suggest remedies to mitigate the present suffering. The Commissioners made their final report in 1845, and this report is our chief evidence for the condition of the Irish people just before the famine. The statements of the **Devon Commission** regarding the economic condition of the Irish agricultural population show that the agricultural labourer was substantially in the same position as he had been ten years before, according to the Report of the Commissioners of 1835, but that the larger occupiers and the landlords were in a more 



---

p.366



distressed situation on account of the operation of the poor rates. The Commissioners reported ‘that the agricultural labourer of Ireland continues to suffer the greatest privations and hardships; that he continues to depend upon casual and precarious employment for subsistence; that he is still badly fed, badly clothed, and badly paid for his labour.’[800](javascript:footNote('E900040/note800.html')) In many districts his only food was the potato, his only drink water; his cabin seldom afforded any protection against the weather, a bed or blanket was a rare luxury, and in nearly all cases the pig was his only property. ‘When we consider this state of things, and the large proportion of the population which comes under the designation of agricultural labourers, we have to repeat that the patient endurance which they exhibit is deserving of high recommendation, and entitles them to the best attention of Government and of Parliament.   
[*...*]  
 Up to this period any improvement that may have taken place is attributable almost entirely to the habits of temperance in which they have so generally persevered, and not, we grieve to say, to any increased demand for their labour.’[801](javascript:footNote('E900040/note801.html')) The average rate of wages had slightly gone up, and was now 8d. a day in winter and 10d. in summer,[802](javascript:footNote('E900040/note802.html')) but employment was even more precarious, and the average weekly income of 2s. 6d. of ten years ago was probably not exceeded. There were increasing numbers of people with very small farms, sometimes only consisting of one acre, but three or four being the usual amount. A man with three or four acres worked his own ground, and sold the produce to meet his rent. He took a rood or half a rood of con-acre from his neighbours, for which he paid £5 or £6 if unprepared, and £8 if prepared. On that ground he



---

p.367



planted the potatoes on which he and his family and pig lived. The sale of the pig went towards the rent, and occasionally another piece of ground was rented, on which flax was grown for the market.[803](javascript:footNote('E900040/note803.html'))The condition of the whole class of farmers seemed to be deteriorating, and they were continually in the hands of the local money lenders, who charged 4s. or 5s. in the pound for a loan of fifteen months.[804](javascript:footNote('E900040/note804.html'))


Just as the pauperism in Ireland had reached a height at which all attempts to grapple with it seemed unavailing, the famine came, to solve in its terrible fashion the problem which confronted the kingdom by sweeping away thousands by starvation, and commencing a rapid depopulation of the country by emigration. Since the famine the possible failure of the potato crops has haunted the Irish people, and it was the awful fear of starvation that led to the enormous emigration in the decade succeeding the famine. Since then the numbers of Irish emigrants have fluctuated, being partly determined by conditions in Ireland and partly by conditions in the United States; but, fortunately, at the present day the mass of the people have ceased to be entirely dependent on the potato, for in some districts Indian meal is now the staple food. The institution of the system of "spraying" potatoes by the **Congested Districts Board** is doing much to secure greater stability of the potato crops, and this, combined with the reorganisation of agriculture by means of the system of co-operation, and the revival of the old domestic industries, may do something to check the flow of emigration, which all acknowledge has long since passed the point of advantage.


It was a long time before the rural population of Ireland made any advance in material progress. It was inevitable that the depression of agriculture which followed the repeal of the Corn Laws, but which became more severe



---

p.368



in the seventies, should fall with greater severity upon Ireland than it did upon Great Britain. It has, of course, produced the same effect in both countries, that is to say, it has drained the population from the rural districts to the towns. Only in England the drain has been merely to the English towns, whereas in Ireland the rural population have emigrated to the towns in America and the colonies. It was always open to the English or Scotch agriculturist to take up some industrial pursuit in his own country, but few Irishmen could hope to find employment as artisans in Irish towns, and the alternative to starvation was emigration. Thus in England there has been an enormous and unprecedented increase in the urban population all over the country, while in Ireland, with the exception of Belfast, the increase, when it has taken place, has been very small.[805](javascript:footNote('E900040/note805.html')) But taking Ireland as a whole, there has been a rise in the standard of living of the people, more especially in recent years. House accommodation has improved, and mud cabins are no longer a usual sight even in the poorest districts; the clothing of the people is better; the wages of agricultural labourers *have* more than doubled during the last sixty years; employment is less precarious; methods of agriculture have improved; there is a growing spirit of self-help among all sections of the population. Among the upper classes there has been a decided growth of wealth, and the amount of income assessed to income tax in Ireland increased 25 *per cent* between 1853 and 1890, even though during that period incomes between £100 and £150 ceased to be assessed. During the last few years further abatements and exemptions in the income tax, together with the purchase of small holdings by their occupiers, have probably been reasons why the *net* assessment to the tax in Ireland has not shown a further increase. Statistics of railway and banking returns, the activity of the building trades, and 



---

p.369



the profits of companies are not absolute proofs of the increasing prosperity of Ireland, but they are at least definite indications of a certain material improvement, and other less definite indications point in the same direction. At present what is wanted more than anything else is the development of transit facilities; for excessive railway rates are doing much to hamper the industrial progress of the country, and an improvement of Ireland's magnificent waterways would greatly benefit agriculture by giving the small farmer a cheap route for his produce.


There are various signs that the agricultural depression which has produced such distress in Ireland during the nineteenth century has reached its lowest point, and that in the near future we may look for some return of prosperity. For some time after the famine Irish provisions, such as meat, bacon, and butter, obtained high prices in the British market. But in the seventies a great expansion took place in the importation of foreign agricultural produce into Great Britain, and the Irish trade in meat and dairy produce began to suffer no less than the trade in cereals, which for some time had been declining. About 1880 the pressure on Irish agriculture reached a serious point. Irish meat was displaced in England by American meat, Irish butter by Danish butter, Irish poultry by French poultry, and Irish flour by flour from various countries, and all these foreign articles even found their way into the Irish market. Ulster, too, soon ceased to grow its own flax, as foreign flax could be obtained so cheaply. To meet all this foreign competition Irish industries have been transformed. The bacon-curing industry has become a capitalist one, mainly carried on in a few large seaport towns, and the system of **co-operation** has been applied to the manufacture of dairy produce with notable effect. Under the system of **co-operative agriculture** it may be possible to establish a prosperous peasant proprietary able to hold its own against foreign competition. Side by side with the success of the



---

p.370


**co-operative movement** there have been parliamentary enactments giving facilities for land purchase or the creation of peasant proprietors. For the first time in his history the material prospects of the Irish peasant are hopeful, although serious problems await solution, and past conditions make future progress necessarily slow.




---

p.371


Financial Relations between England and Ireland during the Nineteenth Century.
------------------------------------------------------------------------------


From the Union to 1817 — Amalgamation of the Exchequers and Commencement of System of indiscriminate Taxation between Great Britain and Ireland — From 1817 to 1853 — After 1853 — Increasing Expenditure on Irish Services — Fiscal Reforms of the Century and their Effect on Great Britain and Ireland respectively.
The great and unprecedented war expenditure from 1801 to 1815 upset all the calculations of **Pitt** and **Castlereagh** as to the amount of Irish contribution to Imperial expenditure, and rendered the financial arrangement of the Treaty of Union one which the resources of Ireland were totally inadequate to bear. The actual provisions of the financial article of the Treaty as regards the mode of adjusting the accounts between the two countries seem to have been interpreted in a favourable way by the various parliamentary committees, while in the actual settlement of the accounts there was no desire to treat Ireland otherwise than fairly. But events which British statesmen had not foreseen crushed Ireland under a weight of taxation and justified the opinions and prophecies of **Grattan**, **Foster**, and other Irishmen. **Pitt** acted as if he believed the French War would not last long, and consequently that the joint expenditure of the United Kingdom would decrease and the debt charges of Great Britain diminish. But as **Grattan** said in 1819, "The truth is, the necessary and inevitable expenses of the war were beyond all possibility of calculation and foresight, and Ireland was not able to follow you."[806](javascript:footNote('E900040/note806.html'))




---

p.372


We have seen that in the years immediately preceding the Union the total Irish expenditure under the independent Parliament had been greatly swollen by the cost of the French War and the Irish rebellion. It is interesting to take the fifteen years before the Union, three of which were years of war alone and four years of war and rebellion combined, and compare the total expenditure during these years with the total Irish expenditure during the fifteen years following the Union, fourteen of which were years of war. In the first period Irish expenditure was £41,000,000 — a small enough sum according to modern ideas if we take the circumstances of the time into account, but a huge amount in the eyes of the Irish Parliament. But in the second period we leave small figures behind us, for from 1801 to 1816 the total expenditure of Ireland amounted to £148,000,000, or more than three and a half times the sum expended during the previous fifteen years.[807](javascript:footNote('E900040/note807.html')) Of this £148,000,000 Ireland raised in taxes £78,000,000, or £47,000,000 more than she had raised by this means during the fifteen years preceding the Union; the remainder she obtained by borrowing, so that only 49 *per cent* of the whole Irish expenditure was met by taxation, whereas during the same period Great Britain raised by taxation 71 *per cent* of her enormous expenditure. Thus, in spite of the greatest efforts, the total revenues, exclusive of borrowing, raised by Ireland during these years were less than half the amount of the expenditure which she was supposed to meet. It is interesting to notice that in 1815, the year when the Irish revenue reached its highest point, and when the increase of Ireland's net product from taxation was, as compared with the year 1800, no less than 128 *per cent*, a greater ratio of increase than Great Britain produced in any similar period, this increased revenue was only 38 *per cent* of the whole Irish 



---

p.373



 

expenditure, or less than the percentage of previous years.[808](javascript:footNote('E900040/note808.html'))


The inability of Ireland to raise a larger sum by taxation led to a huge increase in her national debt. Between the years 1801 and 1817, while the total British debt less than doubled itself, the Irish debt almost quadrupled, having grown from £32,215,223 to £112,634,773, as against an increase in the British debt from £489,127,057 to £737,422,469.[809](javascript:footNote('E900040/note809.html')) Parliament realised that it was inexpedient from an economic point of view to raise Irish taxation even within measurable distance of British, as such an increase of taxation would diminish the yield. Indeed, there was reason to believe that the point at which the limit of Irish taxation was reached had been already overstepped, as during certain years subsequent to the Union some of the taxes had shown a decreasing yield. The taxes of 1801 produced £400,000 less than those of 1800; the year 1802 showed a deficiency, as compared with 1801, of a similar amount; and in the two years 1804 and 1811 the produce of the taxes fell short of their estimated yields by large amounts,[810](javascript:footNote('E900040/note810.html')) and this took place although the duties on spirits, tobacco, tea, and malt had been doubled. As Irish revenue could not be increased to a sufficient extent by taxation, the only way of defraying expenses was by borrowing. Loans could be raised less expensively upon the credit of Great Britain than upon that of Ireland, so that after the Union it was the natural inclination, apart from all reasons of necessity, to defray exceptional expenditure by borrowing, whereas before the Union the Irish Parliament had borrowed as little as possible, and only in the last resort. As a result of the complete exhaustion of Ireland during the war, the 



---

p.374



 

power of raising money on Irish credit nearly came to an end. By far the greater part of the Irish loan had to be raised in Great Britain, and in 1815 it was thought impossible to obtain in Ireland even £1,000,000l. by way of public loan.


The fact that Ireland was able to meet only a small part of her whole expenditure by taxation shows that her relative ability to contribute to Imperial expenditure did not increase in the same proportion as that of Great Britain, and that whether the proportion of two–seventeenths was fair or not at the time of the Union, as events turned out, it proved to be far too large during the succeeding years.


During these fifteen years subsequent to the Union the whole Irish revenue was raised by means of customs, excise, stamp duties, and non-tax revenue; there was no direct tax in the nature of income tax such as existed in Great Britain. The rise of revenue was due partly, and chiefly, to the augmentation of existing duties, but also to some increase in the consumption of dutiable commodities. In 1812 the total revenue raised in Ireland amounted to £5,696,841; of this a little over £1,000,000 was produced by stamps and non-tax revenue, and the whole balance was rased in nearly equal proportions by customs and excise.[811](javascript:footNote('E900040/note811.html')) Between 1801 and 1812 the duty per gallon on home-made spirits in Ireland was gradually increased from 2s. 4 1/2d. to 5s. 1 1/4d. During the same period the rates of duty on brandy and rum were raised from 8s. 7 1/2d. and 6s. 8 3/4d. to 12s. 7 1/2d. and 10s. 3 1/2d. per gallon respectively. In 1801 superior teas had paid 35 *per cent* ad valorem, and cheap teas 20 *per cent*; but in 1812 the duty on all teas stood at 96 per cent. The malt duty was raised from 1s. 6 1/4d. to 2s. 6 3/4d., an additional duty of 2s. 8d. per cwt. was placed on sugar in 1801, and another additional duty of 3s. 6d. in 1806, while the duty on tobacco 



---

p.375



 

increased from 1s. to 3s. 2d. in the pound.[812](javascript:footNote('E900040/note812.html')) Thus there was a large increase in Irish indirect taxation during this period, an increase which fell with crushing weight on the large numbers of poor. But the official values of exports and imports from Ireland during the same years show that trade had expanded, and that the Irish consumption of spirits, tobacco, tea, and sugar had slightly increased owing to growth of population, that of wine alone showing a diminution. This small increase of consumption helped forward the rise of the revenue.


The exemption of Ireland from the income tax was a boon to the Irish tax-payer at a time when the rate in Great Britain was 2s. in the pound on all incomes over £150. Ireland was also exempt from the land tax and the inhabited house tax; she was not required to pay excise duties charged in Great Britain on certain articles, such as beer, bricks, candles, calicoes, glass, hops, salt and soap; while other articles, such as spirits, tea, tobacco, wine, and foreign salt, paid lower rates in Ireland than in Great Britain. Except during the earlier years of this period, Ireland was always in arrears with her contribution, but no great pressure was brought to bear on her to make up these arrears, no interest was charged on them, and just before the amalgamation of the Exchequers in 1817 £2,000,000 was wiped off the Irish account. Great Britain treated Ireland with consideration in all matters of finance during the sixteen years subsequent to the Union. The financial arrangements which had been made by the Treaty of Union seem to have been carried out in a way that was as little oppressive as possible to Ireland, and we have  **Lord Plunket**'s testimony to the justice and impartiality with which Irish interests were safeguarded by the Imperial Parliament.[813](javascript:footNote('E900040/note813.html')) By 1815 Englishmen realised that the war had affected the financial arrangements of the Union in such a way that the Irish revenue 

 


---

p.376



 

could only defray half of the Irish expenditure, while the consequent growth of the Irish debt had been out of all proportion to the resources or abilities of the country. The appalling financial condition to which Ireland was reduced was not at all due to the interpretation of the Act of Union: it was due to the actual financial arrangements of the Act. Even the close of the war, which brought such relief to the industrial population of Great Britain by the fall of prices, only seemed to increase the distress in Ireland. In that country no revival of trade followed the war; on the contrary, peace came as a calamity to the mass of the people, for the profits which they had made from the war prices for their provisions now came to an end. Something had to be done to relieve the country, and it was the fact that Ireland was on the verge of bankruptcy that led to the amalgamation of the Exchequers in 1817 and the abolition of the system of proportional contribution.


The Parliamentary Committee which sat in 1815 to enquire into the debt charges of Great Britain and Ireland devoted much of its report to the state of the Irish debt, and the question how far Parliament would be justified in consolidating the Exchequers according to the provision laid down in the seventh article of the Act of Union.[814](javascript:footNote('E900040/note814.html')) The report stated the actual values of the Irish and British debts, and estimated that their proportions were about 2s. to 12 1/2d., or a larger proportion for Ireland than that of her contribution to Imperial expenditure. But the majority of the members of the committee held that Parliament would be interpreting the financial article of the Treaty of Union in its proper spirit if it abolished the systems of separate Exchequers and proportional contributions. They thought that on the whole it was expedient that the debts and expenditures of the two countries should be consolidated in order to 



---

p.377



 

relieve the existing burden on Ireland, and unanimously resolved that although many of the war taxes levied in Great Britain had not been extended to Ireland, yet the country had advanced in permanent taxation at a far more rapid rate than Great Britain. The committee concluded its report by recommending a financial as well as a legislative Union between the two countries, and it did this with the declared intention of relieving Ireland and rendering her resources more productive. Government was thus forced to take some decided action, and in the May of 1816 the Chancellor of the Exchequer moved in Parliament his resolutions for the consolidation of the British and Irish Exchequers.[815](javascript:footNote('E900040/note815.html')) He emphasised the great efforts which Ireland had made to meet her proportion of contribution, and how signally she had failed in her attempt, and he pointed out that the condition of Ireland was such that the contemplated extension to that country of British taxes would only about make up the existing deficiency in the Irish revenue, and would certainly do nothing to relieve Great Britain. The resolutions which were moved included indiscriminate taxation between the two countries, subject, however, ‘to such particular exemptions and abatements in favour of Ireland   
[*...*]  
 as circumstances may appear from time to time to demand.’ [816](javascript:footNote('E900040/note816.html'))


The resolutions were agreed to, and a Bill was brought in for consolidating the debts and public revenues of the two kingdoms and became law in the following July. This Act [817](javascript:footNote('E900040/note817.html')) provided that all revenues in Great Britain and Ireland were, from and after January 5th, 1817, to constitute one general fund, called the ‘Consolidated Fund of the United Kingdom’; and that fund was to be charged with and indiscriminately applied to (1) the service of the British and Irish debts, (2) the civil list, 
 


---

p.378



 
(3) all other services previously charged on the separate consolidated funds of the two kingdoms, and (4) supply services of the United Kingdom generally.


The actual result of the consolidation of the Exchequers was to stop the impending bankruptcy of Ireland, and place her in a comparatively solvent position. At the time of the consolidation Ireland had to meet separate charges to the amount of £6,500,000, and she was liable to contribute to the joint expenditure of the United Kingdom £4,700,000. Her total liabilities were, therefore, £11,200,000, and as her revenue for the year was only £5,560,000, she had a deficit of £5,640,000.[818](javascript:footNote('E900040/note818.html')) If the consolidation had not taken place, this deficit must have been met by additional borrowing; but under the new arrangements, although Ireland paid over her whole revenue to the Imperial Exchequer, she was from this time relieved from the necessity of piling up new liabilities on account of her annually recurring deficits. To put it in another way, under the Union arrangements the proportions of the respective contributions of Great Britain and Ireland to Imperial expenditure were 7s. 1/2d. to 1, but under the arrangement of 1817 Ireland simply paid over her whole revenue, which amounted to rather more than £5,500,000, while Great Britain became liable for the remaining £83,753,000 of Imperial expenditure. Thus the actual proportions under the new arrangements were fifteen for Great Britain to one for Ireland, or Ireland only paid half the amount that had been fixed by the Act of Union as her fair share. And it is important to notice that in spite of this tremendous decrease in Irish liabilities, Ireland continued as before to pay as much as she was able to raise, so that there was no relief from taxation. The country was saved from bankruptcy, but no relief could be given to individual taxpayers. Since the amalgamation of the British and Irish Exchequers, Great 
 


---

p.379




Britain has been content to take what she can get from Ireland, and has herself become responsible for the capital liabilities as well as the administrative expenses of her poorer partner. Ireland has never again been called upon to pay any fixed contribution to Imperial expenditure, but has simply paid a sum representing the difference between her own local expenditure and her total true revenue.


The pressing question in 1817 was the amalgamation of the Exchequers in order to save Ireland from bankruptcy. The unification of taxation was regarded as expedient, but for some years little was done in this way. But from this time we have to cease regarding Ireland as a separate country for fiscal purposes, for she becomes an integral part of the United Kingdom fiscally as well as legislatively, except for such exemptions and abatements from the general taxation as Parliament might allow her on account of her comparative poverty. Once the Exchequers were consolidated it was no longer necessary to levy customs and excise duties in the country where the dutiable article was consumed. Section 8 of article 6 of the Act of Union had provided that all duties charged on the importation of foreign or colonial goods into either country should, on their export to the other, be either drawn back or the amount, if any should be retained, placed to the credit of the country to which they were exported, so long as the expenditure of the United Kingdom was defrayed by Great Britain and Ireland by proportional contributions. But when, in 1817, the systems of separate Exchequers and proportional contributions disappeared, there was no reason why these fiscal regulations should be continued, and in 1826 new regulations were accordingly framed. All payment and repayment of duties in the cross-Channel trade were to cease, except in the case of articles subject to different rates of duty, and since the year 1826 accounts of the quantities of articles shipped from Great Britain to 



---

p.380




Ireland, and from Ireland to Great Britain, have not been kept. Another fiscal reform followed the amalgamation of the Exchequers. We have seen that after the Union certain duties had been retained both in Great Britain and Ireland with the view of protecting the manufactures of one country from the effects of natural or acquired advantages in the other. These duties had been fixed by the Act of Union at 10 *per cent*, to continue for the space
of twenty years. They remained actually in force until 1820, but an Act of that year [819](javascript:footNote('E900040/note819.html')) only temporarily continued them and provided for their gradual reduction and their final extinction in 1840. This Act, however, was never carried out, and in 1824 all the 10 *per cent* duties were abolished.[820](javascript:footNote('E900040/note820.html'))


The Act which consolidated the Exchequers did not in itself provide for a unification of taxation between Great Britain and Ireland; but the resolutions of the Chancellor of the Exchequer passed by Parliament in 1816 had included such a unification, while article 7 of the Treaty of Union distinctly laid down that a system of indiscriminate taxation might be adopted on the amalgamation of the British and Irish debts if Parliament thought such a policy expedient. At no period indeed since 1817 has absolutely indiscriminate taxation existed, for even at the present day certain taxes paid in Great Britain do not extend to Ireland, and so the clause of Article 7 of the Treaty of Union providing for exemptions and abatements in favour of Ireland has never been altogether ignored. From 1817 to 1853 comparatively little was done in the way of raising Irish taxation to the level of British, because although British statesmen regarded complete fiscal Union as the ideal to be aimed at, they had a distinct grasp of what was possible and what was not possible in the matter of Irish taxation, and therefore realised the uselessness of raising it beyond a certain



---

p.381




point. For varying periods after 1817 the stamp duties and the duties on various articles of consumption were lower in Ireland than in Great Britain, while the income tax, which was removed in Great Britain at the close of the war, was re-imposed in that country eleven years before its extension to Ireland. The rates of some duties were, however, assimilated at different dates between 1817 and 1853. In 1819 the tobacco duties in Ireland were raised to the same rates as those prevailing in Great Britain. This was a heavy addition to the taxation of the mass of the people, for the duty on unmanufactured tobacco was raised from 1s. to 3s. the pound, and that on manufactured tobacco and cigars from 1s. to 16s. In subsequent years these duties were raised still higher in accordance with the increase of the rates in Great Britain. The tea duties were levied at the same rates in both countries from 1817, but the stamp duties continued to be lower in Ireland for many years, and in this case assimilation did not take place till 1842.[821](javascript:footNote('E900040/note821.html')) In 1817 the duties on home-made spirits in Ireland were not much more than half those levied on spirits in Great Britain.[822](javascript:footNote('E900040/note822.html')) In the course of the next few years this difference increased, but in 1825 the reduction of the duties in England caused it to become less marked. The Chancellors of the Exchequer were afraid to raise the Irish spirit duties because of possible smuggling and illicit distillation; and although in 1842 **Peel** raised the rate by 1s. the gallon, he was forced to abandon this additional duty in the following year. From that time until 1853 the rates of the spirit duties in Ireland were only about one-third of those prevailing in England, for it was not until after 1853 that **Gladstone** commenced the policy of assimilating the rates of duty on home-made spirits in both countries.


Thus, with the exception of the heavy tobacco duties



---

p.382



 
comparatively small additions were made to Irish taxation prior to 1853. On the other hand, it must be noticed that the great remissions of taxation which took place in Great Britain in 1824 and 1825, and again from 1839 onwards, applied to those taxes which either did not extend to Ireland at all, or which only affected or benefited her in a slight degree.[823](javascript:footNote('E900040/note823.html')) The beer duty, which produced £3,000,000 in 1829, was repealed in 1830; the duty on printed cottons, which produced the same amount, was abolished in 1831, the duty on candles in 1832, that on starch in 1834, while in 1833 half of the soap duty was removed. These financial reforms were undertaken in the interests of British industry and did not affect Ireland. Nor did many of the subsequent fiscal reforms have any bearing on Irish taxation. In 1845, 450 items were taken off the British tariff, all duties on export were repealed, and also the British excise on glass, which had acted in favour of the Irish glass industry. In 1853 the remaining duty on soap was repealed, and in 1850 and 1862 the duties on bricks and hops were abolished. But the largest remissions of taxation in Great Britain were made on the importation of food stuffs. In 1846 most of the duties on foreign corn, on the importation of live animals and of most dead meats were abolished. The duties on butter and cheese were reduced in the same year and abolished finally in 1860, while the small remaining duty of 1s. a quarter on corn, grain, and flour was repealed in 1869. The repeal of these duties naturally affected Ireland, but it was not the boon which it was to the people of Great Britain, and could bring little relief from taxation to the inhabitants of an agricultural country. As regards all the other remissions of taxation, they applied nearly altogether to Great Britain alone. In consequence, in spite of the conciliatory policy adopted



---

p.383




towards Ireland in this period from 1817 to 1853, we see only a very small decrease in the amount of taxation per head in that country side by side with a large fall in the amount of taxation per head in Great Britain. In 1820 British Imperial taxation stood at £3 10s. per head of the population; in 1850 it had decreased to £2 7s. 8d. In Ireland, on the other hand, Imperial taxation, which had stood at 14s. 5d. per head in 1820, had only fallen to 13s. 11d. in 1850, [824](javascript:footNote('E900040/note824.html')) so that, while taxation per head in Great Britain decreased by one-third, the diminution in Ireland was hardly noticeable.


The small benefit which Ireland reaped from the fiscal reforms of the first half of the nineteenth century was simply due to the economic conditions which prevailed in the country. But although the advantages which she gained from the new financial policy were insignificant compared to the advantages conferred on the people of Great Britain, taxation per head did decrease slightly in spite of the large additions to the tobacco duties, and this is particularly interesting because such a decrease of taxation does not occur again; on the contrary, as far as can be seen from rather inadequate figures, taxation per head in Ireland has risen steadily from 1853 to the present day. The period from 1817 to 1853 was, financially speaking, a favourable enough one for Ireland. Unfortunately, any benefit which might have been conferred on her was rendered impossible by the terrible potato famine of 1846–47, when two millions of the Irish people were swept away by death or emigration. Just as the country was thoroughly exhausted from the effects of the famine, the whole financial policy adopted towards Ireland changed, and Irish taxation began to be rapidly assimilated
to British at a time when great prosperity had come to Great Britain and the reverse to Ireland. The repeal of the corn laws had stimulated the commercial prosperity



---

p.384



 
of Britain; large cities were expanding, railways were developing, and the foreign trade of the country was increasing by leaps and bounds. But Ireland had just passed through the awful ordeal of the famine; her population had suddenly diminished by one-fourth, there had been a universal decline in Irish manufactures, the repeal of the British corn laws had begun the destruction of the Irish export trade in cereals, and the extension of the Poor Law system to Ireland had greatly increased the local rates. Just as the famine subsided the effects of free trade began to take effect. Naturally the Irish people imported the cheap inferior food and clothes which began to be thrust in upon them. Wheat-growing decayed; local industries were destroyed by the competition of large manufacturing towns in Great Britain; every class of Irish producer saw ruin staring him in the face, while landlords and farmers were further impoverished by the huge poor rates, which sometimes reached 20s. in the pound. The misery and poverty of the country could hardly have been greater, and to us at the present day it seems extraordinary that just at this inopportune time Government should have thought fit to go back from the conciliatory fiscal policy which had existed since 1817.


The new system was begun by **Gladstone** when Chancellor of the Exchequer. In his speech in 1853 recommending the extension of the income tax to Ireland,[825](javascript:footNote('E900040/note825.html')) he said that in his opinion the time was come for Ireland to support this tax, and he argued that it could not hurt the country, as it would fall solely on the richer classes. The fact that it was these classes which were at present subject to poor rates far heavier in their burden than those prevailing in Great Britain was not mentioned, and it was this rather specious argument that induced Parliament to agree to the measure. As a set-off to the new imposition **Gladstone** wiped off the Irish debt, called the **consolidated annuities**, which had been incurred for poor




---

p.385




relief during the famine. This relief was equivalent to about £240,000 a year, but the new income tax in Ireland yielded, even in the first year, £460,000. In 1842, when £5,500,000 had been imposed on Great Britain by the re-imposition of the income tax, a relief of £12,000,000 had been given by the removal of the corn duties and other taxes which had been burdensome to manufacturing industry. Compared with the compensation formerly given to Great Britain, the compensation given to Ireland for the imposition of the tax was small. The Irish **consolidated annuities** would have been paid off in a certain number of years, and the charges for them would therefore have ceased, while the income tax has entered into the system of permanent Irish taxation. At the same time the Irish famine debt really represented expenditure for Imperial purposes; it only applied to certain parts of Ireland, and so was no justification for the imposition of the income tax over the whole country, and finally the abandonment of the Irish liability to the debt was in any case only a matter of justice and humane policy. The
additional yield from the income tax in Ireland [826](javascript:footNote('E900040/note826.html')) enabled **Gladstone** to carry out further reforms in the way of reducing taxes on necessaries and the materials for manufacture, reforms which, like the previous ones of **Peel**, were calculated to benefit the inhabitants of a manufacturing country but could have little effect on the people of agricultural Ireland.


The imposition of the income tax was not the only additional taxation laid on Ireland in 1853. In that year **Gladstone** began increasing the spirit duties in the country, with the view to eventually assimilating the Irish and British rates. The rate was first raised from 2s. 8d. to 3s. 4d. per gallon, and **Gladstone** denied that it was amongst the ‘rights of man’ that the Irishman should be



---

p.386




able to get intoxicated more cheaply than the Englishman.[827](javascript:footNote('E900040/note827.html')) This additional rate yielded even more than had been estimated, and in the next year Gladstone imposed, without opposition, another additional 8d. in the gallon, thus bringing the Irish rate up to 4s. per gallon.[828](javascript:footNote('E900040/note828.html')) This second increase of duty did not bring about any decrease of consumption, and in 1855 the rate was raised to 6s. 2d. per gallon.[829](javascript:footNote('E900040/note829.html')) Three years later **Disraeli** increased the duty to 8s. per gallon, thus completely assimilating the Irish duty with the English and Scotch.[830](javascript:footNote('E900040/note830.html')) There was little opposition to this policy, even from Ireland, and no serious attempt has ever been made to revert to the old system of differential treatment in the case of the spirit duties; the discussion has turned on the injustice of not taxing the alcohol in beer in the same proportion as the alcohol in spirits.


The greatest increase in the permanent taxation of Ireland took place between 1853 and 1860, an increase which the **Financial Relations Commission** of 1894–96 estimated at 2 1/4 millions per annum. Excluding non-tax revenue, the taxation per head in Ireland rose from 13s. 11d. In 1849–50 to £1 5s. 4d. in 1859–60, this rise being due to the simultaneous increase of taxation and decrease of population; while in Great Britain, although the Crimean War had added to the expenditure, taxation per head only increased from £2 7s. 8d. to £2 10s., and in 1869–70 sunk to £2 5s. 9d.[831](javascript:footNote('E900040/note831.html')) Since 1860 the chief additions made to the payments of the Irish people have been in the region of local taxation, and owing to the great decline in population the revenue of Ireland has remained fairly stationary until the last two years, when a considerable increase has taken place owing to the imposition of additional taxation all



---

p.387



over the United Kingdom. In 1893–94 the total net Irish revenue, excluding non-tax revenue, was £6,644,000, about the same amount as the annual tax revenue since 1865; but in 1901–02 it was £8,712,000, an increase of £2,068,000. This increase, however, was but small compared with the increase that took place in the British revenues during the same period. Taking the whole of the United Kingdom, the total tax revenue in the year 1893–94 was £82,439,000; in 1901–02 it was £130,000,000, an increase of £47,760,000.[832](javascript:footNote('E900040/note832.html')) Thus the Irish increase was only 4.33 *per cent* of the total increase of the United Kingdom, or less than the 5 *per cent* which the **Financial Relations Commission** of 1894–96 stated was the taxable capacity of Ireland as compared with the taxable capacity of Great Britain. It therefore appears that the Irish contribution to the whole expenditure of the United Kingdom shows a smaller proportion at the present time than in 1896, when the Financial Commission completed its report. This is due partly to a decrease of population in Ireland, which keeps the revenue from rising further, side by side with a large increase of population in the United Kingdom, which forms a powerful factor in the rise of the British revenue, and partly to certain changes and additions in taxation, which have resulted in a heavier burden being placed on Great Britain and a lighter one on Ireland. For some years after 1893 the income tax produced less for each penny in Ireland than it did in the years before 1893, while in Great Britain every year showed a higher yield than the preceding year. The falling off of the yield per penny in the income tax in Ireland was partly owing to the purchase by tenants of estates which, when divided up among small holders, paid no income tax, but chiefly to the extension of the system of abatements and exemptions in the income tax, which naturally had a greater
effect on the yield of a poor country like Ireland than on



---

p.388



the yield in Great Britain. The recent tax on coal has added to the taxation of Great Britain, but does not touch Ireland; and last year in regard to the tax on corn the Chancellor of the Exchequer agreed to halve the new tax on maize, as the Irish members succeeded in convincing him of the great burden this duty would impose on the poorest classes in Ireland. But in spite of all this the last three years have added greatly to the financial burden of Ireland, for the increased taxation has been taken from a still declining population, among whom material improvement is at best very small. Increases in indirect taxation must always fall very heavily on the Irish poor, and the very poor form a large part of the population of Ireland.


The central point in Irish finance has been, and still is, the declining population of the country. It is the enormous increase in the population of Great Britain which has been one subsidiary cause of the great increase of the revenue of the United Kingdom. In Ireland the revenue showed no upward tendency between 1860 and 1896, for any increases of taxation that were made were counteracted by a decrease of the population from 5,821,000, to 4,571,000. This decrease has been chiefly owing to emigration, but also to a decreasing birth and marriage rate; and it has continued steadily since 1896, although rather less rapidly. This steady decline of the Irish population is, however, chiefly important in connection with local taxation, and is the main cause of the terrible pressure of the rates in the western and southern districts of Ireland.


One of the most interesting features of the financial relations between Great Britain and Ireland during the last three-quarters of the nineteenth century is the great increase which has taken place in the expenditure on Irish services relatively to the expenditure on British services. Excluding the expenses of collecting the taxes and managing the postal services, which may be regarded as properly Imperial, the increased charge of civil government



---

p.389



in Ireland is still more marked. In 1819–20 the civil government charges in Great Britain, with a population of 13,765,000, were £1,113,000, or 1s. 7d. per head of the population; in Ireland, with a population of 6,802,000, they were £618,000, or 1s. 10d. per head. But in 1892–93 these charges in Great Britain, with a population of 33,469,000, were £19,103,000, or 11s.5d. per head; while in Ireland, with a population of 4,638,000, they amounted to £4,544,000, or 19s. 7d. per head.[833](javascript:footNote('E900040/note833.html')) Since 1893 the expenditure on Irish services has continued to increase. In 1893–94 the cost of civil government and collection of revenue amounted to £5,603,000, but in 1901–oz it had risen to £7,214,000, an increase of £1,611,000.[834](javascript:footNote('E900040/note834.html')) In consequence less and less of the Irish revenue has been available for purposes other than Irish, and it is a surprising fact that in spite of the large increase which took place in the Irish revenue after 1853 the net contribution of Ireland to charges other than Irish was actually less in 1894 than in 1850.[835](javascript:footNote('E900040/note835.html')) In 1901–02, notwithstanding the rise in the Irish revenue, only £605,000 more was contributed to purposes other than Irish than in 1893–94.


The reasons for this huge expenditure on Irish services lies in the political and social condition of Ireland and the fact that the government is really not conducted on a peace footing. A large number of soldiers is always kept in the country — their cost is reckoned as ‘Irish services’ — while the **Royal Irish Constabulary** is in reality a standing army and the most expensive police force in the world. **Mr. Lough** estimates that in 1895 the cost of the Irish constabulary was 6s. 7d. per head of the Irish population, and that there was one policeman for every 257 people. In 



---

p.390



Scotland, on the other hand, there was in the same year about one policeman for every 1,000 persons, and the cost of the police force was only 2s. 3d. per head of the Scotch population.[836](javascript:footNote('E900040/note836.html')) Since 1895, however, the cost of the Irish constabulary does not appear to have increased, but the diminution of population has resulted in a slightly higher cost per head of the inhabitants of Ireland. The cost of the Irish Civil Service is also very high; the Local Government Board, the Board of Works, the Superior Court, Prisons and Law Charges, all cost a great deal considering the resources and population of the country. But the increase in the expenditure on Irish services which has taken place within the last few years has not been due to the growing cost of government. A large additional sum of money, over one-and-a-half millions, has been expended in the first place in increased grants for the purposes of the **Local Government Board** in connection with the establishment of local government in Ireland; it has also been spent in further grants for education, but it has chiefly been expended in additional grants to local authorities, which in 1901–02 amounted to £1,021,000, as compared with £569,000 in 1893–94. The grant for agricultural rates in Ireland and the establishment of the **Board of Agriculture and Technical Instruction** cost a large sum of money, and all this increased expenditure has been to the direct benefit of Ireland, and as such must be regarded as a set-off to actual taxation. The financial situation of Ireland has changed for the better during the last few years, because Government realises more than formerly that the peculiar economic condition of the country entitles the Irish people to peculiar consideration in matters of finance.


The great revolution in fiscal policy, already touched upon, which was commenced by Huskisson in 1824 and carried on to a far greater extent during a long period of



---

p.391




thirty years, beginning with the accession of **Sir Robert Peel** to office in 1841, has naturally produced different effects in the two countries of Great Britain and Ireland. During the first part of the nineteenth century the greatest burden on the industry of Great Britain arose from the operation of the Corn Laws. The laws were certainly a great grievance to the working classes, and they acted as a check on commercial expansion. At the same time they no longer succeeded, as before, in keeping up a sufficient food supply for the whole population, the real motive of the originators of the system, and so were completely condemned. The repeal of the Corn Laws in 1846 was a tremendous boon to the manufacturing population of Great Britain, for from that time they have been able to obtain a cheap and plentiful food supply. Other financial reforms have also benefited them greatly, and have freed British industry and commerce from everything that could possibly hamper them. The general effect of this new financial policy was to abolish the excise and custom duties upon the raw materials of manufacturing industry and upon food stuffs. The whole change effected during this period was from a fiscal system, in which revenue was derived from a great number of excise and custom duties, pressing heavily and at many points upon the chief imported articles of consumption, and upon raw materials for manufacture, to one in which revenue is derived partly from direct taxation and partly from heavy excise and custom duties on a very small number of imported articles of general consumption and on home-made alcoholic drinks. It is undeniable that this change in fiscal policy has been extremely advantageous to the people of Great Britain, because the great majority of the British population depend, not upon agriculture, but upon industry and commerce. But in Ireland the matter is otherwise. The mass of the Irish people are dependent on agriculture, and have been dependent upon it all through the century. As consumers they may have slightly gained by the abolition



---

p.392




of the duties on food stuffs, but as producers, nearly altogether dependent upon agriculture, they have lost in a far greater degree. The untaxed supply of foreign corn, live stock, meat, dairy produce, and other food stuffs led to cheap prices in the British markets, and severe foreign competition caused a decline in Irish agriculture. After the complete introduction of free trade policy by the repeal of the Corn Laws the taxation of Ireland was largely increased by the imposition of the income tax and the enhancement of the spirit duties, changes effected partly to facilitate remissions of taxation in Great Britain and to abolish hindrances to manufacturing industries in which the Irish people had little share.


At the present day Ireland is quite able to support her own population from the corn and meat she produces and at the same time to export a considerable surplus. On the other hand, the Irish population consumes, in proportion to its wealth, a large amount of tea, tobacco, and spirits, and a small amount of beer. Looking at the matter dispassionately, it must be acknowledged that our present fiscal system, which raises practically no revenue from foreign food stuffs,[837](javascript:footNote('E900040/note837.html')) but does raise a very large revenue from spirits, tea and tobacco, is hardly advantageous to the people of Ireland, however beneficial it may be to the inhabitants of England. In the eighteenth century Ireland suffered from the protective policy of England; in the nineteenth she has suffered from the free trade policy of the United Kingdom. The fiscal situation of Ireland is the inevitable result of the contrast in economic conditions between herself and Great Britain. In matters of taxation, as well as in other matters, the interests of the greatest number have to be consulted, and in the United Kingdom the greatest number belong to the urban and manufacturing classes.




---

p.393


It would probably be impossible to devise a system of taxation which would be equally beneficial to the inhabitants of urban and rural districts, but there are signs of a growing idea that the inequality of advantage to Ireland arising from a different incidence of taxation to that which takes place in Great Britain does entitle her to special consideration in fiscal matters. A system of taxation which has been devised in the interests of a manufacturing country cannot be suited to the inhabitants of a poor agricultural country, where economic conditions and habits of living are in many ways so different. The phenomena which we see in the present financial relations of Great Britain and Ireland must be seen in the fiscal relations of any two countries or districts, one manufacturing and the other agricultural, subject to the same financial system. For example, Prussia is at present confronted with the difficult problem of giving equal benefits in her customs system to the inhabitants of her manufacturing and agricultural districts, while in Austria-Hungary harmony is only maintained by the method of compromise; thus Austria allows the free importation of Hungarian food stuffs, and Hungary in return permits Austrian manufactures to be imported duty free while both the manufactures and food stuffs of foreign countries are taxed on importation into all parts of the empire. But nothing exactly analogous to the financial relations between Great Britain and Ireland can be found in the fiscal relations of two practically independent countries like Austria and Hungary, or even in a federal State like the United States of America, where only common expenses are defrayed out of the central Treasury. Nor can an exact analogy be found in the financial relations of the different districts of a unitary State like Prussia, although a consideration of Prussia's present tariff difficulties shows that the financial phenomena existing in Ireland are by no means so unique as is sometimes supposed.




---

p.394


The Irish Financial Problem
---------------------------


Discussions concerning the Financial Condition of Ireland — The Select Committee of 1864 — The **Financial Relations Commission** of 1894–96 — Summary of its Final Report — Criticism of the Report — The Real Problem.
The financial treatment of Ireland by the Imperial Parliament has been discussed at some length and at various times since the amalgamation of the British and Irish Exchequers in 1817. But the subject was not seriously discussed as a whole before 1864. In that year, after some opposition from **Mr. Gladstone**, then Chancellor of the Exchequer, a Committee of Enquiry was appointed whose instructions were to enquire how far the taxation of Ireland was in accordance with the provisions of the Treaty of Union or just in reference to the resources of the country. The Committee found no difficulty in disposing of the allegations which had been made concerning the violation of the financial article of the Treaty, but when it came to a consideration as to whether the taxation of Ireland was just in reference to her resources it did little but emphasise the impossibility of coming to any valid conclusion on the matter on account of the absence of accounts of trade between Great Britain and Ireland. The Committee did, indeed, bring forward other tests in order to measure the respective resources of the two countries, such as the amount of tonnage used in both the foreign and coasting trades of each country, the property assessed to the income tax in each country, the deposits in savings banks, gross railway receipts, and payments on account of death duties, all of which gave a 



---

p.395



smaller proportion for Ireland than the Union ratio of British and Irish exports and imports; but it insisted that these tests were simply indications of these resources, and must not be taken as infallible guides. On the whole the Committee came to the conclusion that the distress from which Ireland was suffering was not due to pressure of taxation, but rather to bad seasons. It did not think that the existing system of taxation interfered with the industrial development of the country or that it was called upon to recommend any relief to Ireland which would be at the expense of British tax-payers. As regarded further additional expenditure in Ireland, the Committee stated as its opinion that more harm than good was done in this way, at any rate as regards unproductive expenditure. Its suggestions were, in fact, limited to advocating the advance of public money to Ireland for improving land and furthering arterial drainage.


The conclusions of the Select Committee of 1864 invited no action, and the only result of its report was that some further impetus was given to the system of public loans in Ireland. The subject of Irish taxation was taken up from time to time in Parliament by the Irish representatives, but no further practical steps were taken by Government in the matter until the appointment of the Royal Commission of 1894 to enquire into the past and present financial relations between Great Britain and Ireland and their relative taxable capacities. The Commissioners were ordered to report upon what principles of comparison, and by the application of what specific standards, the relative capacity of Great Britain and Ireland to bear taxation might be most equitably determined; what, so far as could be ascertained, was the true proportion under the principles and specific standards so determined between the taxable capacities of Great Britain and Ireland; and what amount of Imperial contribution it was equitable that Ireland should contribute.


The **Financial Relations Commission**, which made its



---

p.396



final report in 1896, was not so cautious in its statements as the Select Committee of 1864, nor were its conclusions in any way negative. The majority of the Commissioners agreed that Ireland was overtaxed, although there was considerable difference of opinion as to the extent of this overtaxation. It will be necessary to summarise briefly the views and conclusions of the majority of the Commissioners.


The main principle upon which the relative taxable capacities of Great Britain and Ireland may be best determined was agreed to be that of a comparison of the aggregate money incomes possessed by the people of each country; but in fixing the proportion account was taken of the comparative progress and consequent increase in taxable capacity in each country. Some of the Commissioners were also of opinion that the comparison of the annual wealth of the two countries should be based, not on gross income, but on the surplus, after deducting from gross income an allowance for subsistence for each population. **Sir Robert Giffen** was of this opinion, and calculated that this yearly allowance for subsistence should be £12 per head of the population in both countries.


The principal specific standard applied in order to estimate the proportion of the gross annual income of each country was derived from the net assessment to the income tax, attention being paid to the relative conditions which prevailed in the two countries as regards wages and other unassessed incomes. It was found that the net assessment to the income tax showed as between Ireland and Great Britain a proportion of 1 to 21. The Irish proportion of income from wages and from income otherwise unassessed was held by all to be not more, and was thought by some to be considerably less, than the Irish proportion of income actually assessed. At the same time it was pointed out that Irish land was more strictly assessed than British, that no adjustment of the figures had been



---

p.397



made in Ireland since the great fall in the value of land, that the assessments in Great Britain under Schedule D. were known to be too low, that a large element of foreign income is not included in Great Britain in the income-tax assessments, and that in Ireland there is an economic drain from absentees. It was also observed that broadly speaking Ireland had made little material progress since the seventies, and that she was probably less prosperous than she had been ten years before the Union. So while the prosperity of Great Britain had been increasing by leaps and bounds that of Ireland had remained practically stationary. It was therefore argued by many of the Commissioners that a readjustment of the proportion of 1 to 21 already obtained should be made in favour of Ireland, because Great Britain's taxable capacity must in any case increase in a more rapid proportion than that of Ireland. The assessment to the death duties was taken as another specific standard of comparison for estimating the annual incomes of the two countries, and this gave the proportion of 1 for Ireland to 17 for Great Britain. Other minor tests were taken which gave various proportions, a few under that of 1 to 17, but the majority considerably over. The Commissioners, however, were anxious not to seem to favour Ireland at the expense of Great Britain, and the majority of them therefore decided that they would be in no danger of exaggerating if they estimated the true proportion of the taxable capacity of Ireland to that of Great Britain to be as 1 to 20. the Financial Relations Returns of 1893–94 the proportion which the ‘true’[838](javascript:footNote('E900040/note838.html')) revenue of Ireland bore to the ‘true’ revenue of Great Britain was as 1 to 13. Ireland, therefore, bore 1/12th part of the whole expenditure of the United Kingdom, while according to her taxable capacity she should at the lowest computation only bear 



---

p.398



1/21st part. So Ireland contributed every year over 2 3/4 millions more than her just proportion. But some of the Commissioners thought that the proportion of 1 to 20 was too high for Ireland, and that a deduction should be made for subsistence for each population before comparing the respective incomes of the two countries. A proportion of the whole income of the United Kingdom, having regard to its population, was set aside, and this allowance was distributed between the populations of Great Britain and Ireland in the proportion which they bore to each other.[839](javascript:footNote('E900040/note839.html')) Taking the lowest estimate of British income in 1896 at £1,400,000,000, and the maximum estimate of Irish income at £76,000,000, and adding these sums together, they took one-fourth of the total as the allowance for subsistence for the whole of the United Kingdom. Of the £369,000,000 so allowed they allotted 7/8ths to Great Britain and 1/8th to Ireland, and deducting from the incomes of the two countries the amount so obtained, they found that the surpluses were in the proportion of 36 to 1. The proportion for Ireland and Great Britain respectively was therefore not 1 to 20, but 1 to 36.


The Commission went at length into the subject of Irish taxation since the Union, and found that it had grown from 14s. 5d. per head of the population in 1819–20 to £1 8s. 10d. in 1893, while the taxation of Great Britain had decreased during the same period from £3 10s. 3d. per head to £2 4s. 10d. The population of Ireland had fallen from 8,000,000 in 1841 to 4,500,000 in 1896, and was therefore less than at the time of the Union; and side by side with the decreasing population the whole taxation of the country had increased from £4,750,000 in 1819–20 to nearly £7,000,000 in 1896. It was said that the 



---

p.399



 
disadvantageous position occupied by Ireland was chiefly due to the system of taxation in force in the United Kingdom, which selects a few articles for high rates of duty, letting the remaining articles go free. The Irish national drink, whiskey, is taxed at a much higher rate than the English national drink, beer; while the Irish have always consumed large quantities of tea and tobacco in proportion to their wealth, a state of things natural enough in a poor country which cannot afford to consume much nourishing food. It was therefore agreed that, financially speaking, Ireland had gained nothing from the Union, and might have lost much. The population of Ireland was larger at the Union than in 1896, agriculture was more profitable, for the repeal of the Corn Laws had not yet impoverished the Irish agriculturist, the Irish foreign trade was larger, there were more manufactures in the country, and therefore the income of Ireland could not have been less at the Union than it was ninety years later. But under an Irish Parliament, in a year of peace, taxation was a little over £1,000,000; in a year of war and rebellion it only reached £2,500,000. In the war times after the Union Irish taxation rose to £4,500,000 per annum, and in 1896, after a long period of almost continuous peace, it stood at nearly £7,000,000. It was emphasised that these increases of taxation had been taken from an income which only improved slightly in the first half of the century, but which fell very considerably in the second half.


The Commissioners strenuously opposed the view often put forward, that as this whole increase of Irish taxation was spent in Ireland, that country could not complain of her high rates of taxation. They thought this view unjustifiable, for by the Treaty of Union the whole Irish revenue was regarded as a contribution towards the expenditure of the United Kingdom, and there could, therefore, be no separation of Irish expenditure into charges for Irish purposes and charges for Imperial



---

p.400



purposes. How far the extra grants and free loans by the State for Irish purposes should be regarded as a set-off to taxation was a question which the Commission found difficult to determine, and one on which there was little agreement. It was, however, pointed out that the money from which State loans had been made was raised in Great Britain and the interest paid to persons living in Great Britain, which placed Ireland at a disadvantage. At the same time the interest on loans was higher in Ireland than in Great Britain, and local authorities were often compelled to borrow from the Local Loans Fund at 3 1/2 *per cent*, although they could borrow cheaper themselves.


Finally, the Commission recommended four different ways by which Ireland might be given relief from taxation: (1) The general fiscal system of the United Kingdom might be altered so as to press more heavily on Great Britain and less heavily on Ireland; or (2) a return might be made to the system of abatements and exemptions in favour of Ireland; or (3) a certain sum might be deducted from the public revenue every year and handed over to Ireland for special purposes in that country; or (4) Ireland might be allowed to manage her own local finances, contributing any surplus of her revenue that might exist to Imperial expenditure — this with or without legislative autonomy. As regards these four ways of relieving Ireland the members of the Commission differed widely. The majority of them, however, were in favour of allocating a fixed annual sum as compensation to Ireland, subject, of course, to periodical revision.


There is no doubt that this Commission of 1894–96 made out a strong case for Ireland, and the fact that it was composed of many eminent men is apt to make a student chary of criticising its conclusions. But in any matter involving changes in taxation or an alteration in an existing system of taxation, great precision is the first requisite, and it must be acknowledged that this precision 



---

p.401



has not been attained by the Commissioners so far as regards their enquiry into the respective taxable capacities of Great Britain and Ireland, an enquiry upon which all their conclusions must depend. In statistical science there is only a small gulf between fact and fiction; and between the figures that are facts and the figures that are fiction there are numerous figures that are partly fact and partly fiction, and that can only be accepted as supplying us with more or less trustworthy indications of tendencies, not as giving us sufficient material for arriving at any practical conclusion. As regards the enquiry which was before the **Financial Relations Commission**, there is little available matter which can be regarded as furnishing us with facts sufficiently precise for coming to a valid and final conclusion. The figures given by the Commission are very valuable in enabling us to realise the economic conditions and tendencies which prevail in Ireland, and they also give sufficient proof that our present system of taxation is on the whole unfavourable to Ireland, and that this fact entitles the country to special consideration in fiscal matters. But when we come to the question as to whether these figures form a sufficient foundation for changes in taxation with a view to lighter pressure on Ireland and heavier pressure on Great Britain, or for a statement that the over-taxation of Ireland may be accurately estimated at a certain sum, we have to acknowledge that more trustworthy evidence must be forthcoming than that which is at present available if we would come to any accurate conclusion on these matters.


The only figures given by the Commission which we are safe in accepting as accurate are those of population and collected revenue. But these figures are naturally of little use in themselves: what we have to do is to get at the relative incomes of Great Britain and Ireland if we wish to compare their taxable capacities. But Great Britain and Ireland have a common system of taxation and absolutely free commercial intercourse, and so the



---

p.402



revenues which are collected in the two countries can give us no basis for coming to any conclusion concerning even the immediate incidence of taxation on commodities. Goods paying duty in one country may be consumed in the other, and therefore the collected revenue must be turned into the ‘true’ revenue, or the revenue derived from commodities actually consumed within each country. The Commission made this adjustment, but the nature of the enquiry is so complicated that we can only accept their figures as giving us more or less approximate estimates, certainly not as giving us an accurate proportion between the revenues derived from indirect taxation in Ireland and those derived from indirect taxation in Great Britain. If we turn from indirect taxation to direct, which at first sight seems less complicated, we find ourselves confronted with similar difficulties, due to the close business and commercial connection prevailing between Great Britain and Ireland. A man often holds property in one country and resides in the other, while there is a large amount of foreign property belonging to people in Ireland as well as in Great Britain which is only assessed in London. In fact, to get at the true figures of the revenue derived from Imperial taxation, so many allowances and conjectures have to be made that the statistical basis of the whole enquiry is much weakened. But if we go further, as indeed we are logically bound to do, and attempt to compare the local rates in Great Britain and Ireland in order to get at the whole fiscal burden on each country, a subject outside the scope of the Commission's enquiries, we find that the difficulties which confront us are almost insuperable. In this case exact returns are impossible, and the whole question is still further complicated because of the nature of local taxation. Local taxation occupies a different position from central taxation, for the greater part of it is either non-tax or expended for productive purposes. It is impossible to compare ‘advantage received’ from local rates in two countries



---

p.403



which differ from each other so widely as Great Britain and Ireland, and in order to compare the burden of local rates this comparison of ‘advantage received’ is necessary. We are forced to the conclusion that the various items of local expenditure cannot be added up in one country to form a total amount, and then compared with the total amount in the other country obtained in the same way. Such a proceeding would give us merely an arithmetical expression which would convey no real meaning until each item had been carefully and minutely examined and analysed, and even then the result would be merely an approximate estimate which would have to be used with the greatest caution. So much for the question of revenue. In the region of expenditure there are also difficulties, for the distinction which must necessarily be drawn between Imperial and local expenditure and the principles upon which such a distinction must be drawn can only be determined in the light of broad financial theories. The Commission showed itself a little illogical on this matter, but at the same time the statistics of revenue and expenditure given by the Commission are perhaps sufficient to furnish us with a working basis from which an enquiry into the respective taxable capacities of Great Britain and Ireland may be started. It is when we come to look into those various elements of the British and Irish revenue which were taken as more exact guides to the relative taxable capacities of the two countries that we realise how insufficient are our existing materials.


The statistics concerning relative income are more important than any other figures furnished by the Commission. Probably no better starting-point for an enquiry into relative income could be found than that furnished by the net assessments to the income tax. But here accuracy is impossible. Possible evasions of the tax are endless, and it is a well-known fact that they vary from schedule to schedule and from individual to individual, so that any attempt to estimate the average amount of 



---

p.404



evasion is futile. Again, the composite nature of the tax adds to the difficulty. The income tax is not a single tax; it is a whole code, or system, of direct taxation, and as the methods of imposition vary so greatly in different schedules, it is impossible to arrive at any accurate basis for comparison. Some incomes, such as the salaries of public officials, are necessarily strictly assessed, and it is probably impossible for large public companies to disguise the amount of their profits. But there is no security that private traders may not evade the tax on a portion of their profits and the payments under the head of Farmers' Profits have been described as a ‘complete farce’.[840](javascript:footNote('E900040/note840.html')) All working class incomes are exempt from the tax and the profits of many small dealers probably go free. Thus in any comparison of the respective incomes of Great Britain and Ireland founded on the basis of the net assessment to the income tax we can only compare rents, salaries, investments, and some classes of profits; we lose sight of the mass of farming income, and altogether of the incomes of the labourers and artisans. In order to remedy the great fault in the comparison, the actual course of business in the two countries should be examined, noting where radical differences occur; and, far more important of all, an investigation should be made into the actual economic condition of every class in Ireland and every class in Great Britain, but more especially the poorer classes, which are exempt from direct taxation. The Commissioners tried to compare the amount of working class incomes in Great Britain and Ireland respectively, but here their enquiry was beset with many difficulties and only a rough approximation was avowedly obtained.


As a matter of fact, all estimates of income based on property are necessarily merely subsidiary. Logically what we ought to compare in estimating the respective incomes of two countries are the necessaries and conveniences



---

p.405



of life which each country annually consumes together with its fresh annual savings. This is what German economists call the ‘real’ method,[841](javascript:footNote('E900040/note841.html')) and theoretically it is the best way of getting at the income of either an individual or a country. **Sir Robert Giffen** made an interesting attempt to estimate the total income of Ireland in this way,[842](javascript:footNote('E900040/note842.html')) but he found himself obliged to make so many allowances and averages that a great part of the foundation of his estimate was cut away. **Dr. Grimshaw** stated in his evidence before the Commission[843](javascript:footNote('E900040/note843.html')) that he could not undertake to estimate Irish income by **Sir Robert Giffen**'s method, because he thought that estimates so obtained would probably be fallacious. All he does after giving his figures relating to Irish manufactures, shipping returns, banks, post office savings, railway receipts, house accommodation, etc., is to state cautiously that in his opinion all these tests showed increased wealth, but that it was impossible to say how much better off was the average Irishman than fifty years ago. Indeed, all attempts to estimate by a money measure the whole mass of commodities and services which come into use during the year are apt to be very conjectural. The necessity of using prices complicates the question and brings in an element of uncertainty, while the broad averages which must necessarily be taken may be misleading, as a fractional difference in one of the premises may lead to a considerable difference in the conclusion. It is also difficult to get at exact figures. For example, Irish agricultural statistics are known to be defective, and so estimates of agricultural produce have to be accepted with the greatest caution.[844](javascript:footNote('E900040/note844.html')) The police who collect agricultural



---

p.406



statistics in Ireland can only do so by getting their information from the farmers. But it is obviously impossible for them to interview every farmer, and so they have to take much of their information on hearsay. Even as regards the amount of acres under one crop, and the numbers of live stock kept by each individual farmer, accuracy of computation is not obtained, while as regards estimates of produce farmers themselves find it difficult to measure the probable yield of their crops, and police constables who merely go round looking at the crops can form nothing but a general opinion whether the crops look good or bad. Statistics obtained in this casual way by the Irish constabulary can hardly be made the foundation for reasoning by statesmen or statisticians. In order to estimate a farmer's income on this "real " method as distinct from the ‘personal’ or property method, it would be necessary to know not only the amount of his produce but also the exact quantity which he sells at each price, besides the total value or use of all the bye-products. Such a determination of the price of each different kind of produce would be a matter of great difficulty, and a small difference in the estimate of the price of any one article might lead to a considerable difference in the broad average which must be used to express its money value. We would also have to divide the farmer's stock into capital and income: that is to say, determine how much of it he sells or exchanges in the market and how much he keeps for the use of himself and his family. It would, in fact, be necessary to make out a very large number of family budgets, and to obtain an exact family budget is one of the most difficult tasks which the student of economic conditions can set himself. Theoretically the ‘real’ method is the only proper way of arriving at an estimate of income; but practically in regard to the enquiry which lies before us, the most that can be said of this method is that it may be exceedingly suggestive as giving us a rough idea of the economic condition of the people in the country



---

p.407



under consideration. But estimates of income of a country obtained by means of the ‘real’ method cannot in any way be regarded as conclusive or as furnishing material precise enough in its nature to justify any important change in taxation such as some of the Commissioners of 1896 had in their minds.


But if we make attempts to estimate the income of Ireland by means of the ‘real’ method, and not merely from property statistics, we ought to make a similar attempt as regards British income, for in any comparison of the respective incomes of two countries similar methods must be employed in estimating the income of each. But the **Financial Relations Commission** made no attempt to estimate the income of Great Britain in this way, and so even the conjectural estimate of Irish income which was thus obtained is valueless for the comparative purpose with which it was concerned. Thus the value of some of the statistical data brought forward by the Commission is greatly lowered from the point of view of the purpose in hand. The statistics which exist at present concerning British and Irish income are insufficient in order to institute a comparison between their respective taxable capacities. It must be remembered that the units which we are comparing are large, and that Ireland, as well as Great Britain, although to a less extent, is heterogeneous. No one who knows anything of Ireland would dream of looking at east and west from the same point of view, and the north-east must always be regarded as something quite different from the remaining part of the country. We are thus forced to the conclusion that the results obtained by the Commission establishing the over-taxation of Ireland can only be taken as provisional in the absence of further statistical data, and as subject to many corrections.


Now, in order to determine the proper financial position of Ireland, it seems necessary to adopt certain general principles as a foundation for argument, and first of all it



---

p.408



 
must be decided whether Ireland is to be regarded as a fiscal entity or as an integral part of the United Kingdom. The **Financial Relations Commission** adopted the former view, but this was probably the result of the special circumstances under which it was appointed. It was the period of Home Rule agitation, and a Home Rule Bill was about to be passed through the House of Commons. It was therefore thought desirable both by Government and the Opposition that an effort should be made to ascertain what financial arrangements such a Home Rule scheme would involve. Thus the Commissioners enquired into and reported upon the whole question from the point of view of the separate entity theory. According to their opinion their instructions were to ascertain what Ireland ought to contribute to the Imperial Exchequer in case she were given Home Rule, and thereby created a financial entity.


In consequence the conclusions of the Commission can in any case only be applicable in practice if Ireland is regarded as a separate fiscal entity.


The present Irish position, which looks upon Ireland as a fiscal entity, is based upon a certain interpretation of the Act of Union. It is held that the financial article of the Treaty means contribution according to relative means and expenditure as required without reference to limit of contribution. The majority of the Commission accepted this view, which means that although they considered Ireland as a fiscal entity as regards taxation, they considered her as part of the United Kingdom as regards expenditure, an obviously unfair position. It is, however, extremely doubtful whether the Act of Union does require Ireland to be treated at the present day as a separate financial entity. On the whole, present conditions, whatever may be the practical injustice of their results, fulfil literally enough the intentions outwardly designed by the Act. When the Treaty of Union was being drawn up, it was admitted that indiscriminate taxation and a consolidation 



---

p.409



of the Exchequers was desirable, and the chief reason why this was not done was the inequality of the British and Irish debts. Section 8 of article 7 specifically provided for the amalgamation of the Exchequers as soon as the debts of the two countries should be to one another in the ratio of their respective contributions to Imperial expenditure, and also laid down that when this amalgamation had taken place Parliament might, if it thought expedient, abolish the system of proportional contribution and institute a system of indiscriminate taxation. The wording of the article clearly shows that once the consolidation of the Exchequers was accomplished, all arrangements for treating Ireland as a separate fiscal entity, and for fixing the proportions of contribution, should be done away with if Parliament thought fit; there should then be indiscriminate taxation, subject, however, to such abatements and exemptions in favour of Ireland ‘as circumstances may appear from time to time to demand.’ Accordingly, when the Exchequers were consolidated in 1817, many exemptions and abatements were retained in favour of Ireland owing to her acknowledged poverty; it was only after 1853 that these exemptions and abatements dwindled down to their present position. It is, however, important to notice that they still exist, and their existence shows that the economic condition of Ireland is held to be such as to entitle her to special consideration in financial matters. But this is quite different from regarding her as a fiscal entity. If financial injustice to Ireland exists at present, it lies not at all in the violation of the financial terms of the Treaty of Union; it is a result of the Treaty itself, which did not sufficiently safeguard Irish interests, and it is also a result of a misinterpretation of the spirit of the Treaty. The economic conditions prevailing in Ireland are even more dissimilar now to those prevailing in Great Britain than they were at the time of the Union; but the exemptions and abatements which **Pitt** thought so necessary on account of the dissimilarity of these economic



---

p.410



conditions, and provision for which he inserted in the financial article, have dwindled down greatly, and those insignificant ones that do exist benefit the well-to-do and not the poor of Ireland.


At the same time, bearing carefully in mind the true position of Ireland as an integral part of the United Kingdom, it is legitimate enough to regard Great Britain and Ireland as two separate units for the purpose of financial comparison, just as it would be to take two separate classes in the community and work out the different incidence of taxation on these classes. But if we regard Ireland as a unit for purposes of taxation, we must in all fairness regard her as a unit for purposes of expenditure. This the **Financial Relations Commission** did not do, a logical blunder which makes it still more necessary to accept their conclusions with caution. The Commissioners say that the public expenditure of the whole United Kingdom concerns the whole United Kingdom; that we must logically regard it as expended for the equal advantage of all, and that it is impossible to debit anything that the Central Government spends to the different parts.[845](javascript:footNote('E900040/note845.html')) They regard all expenditure as the public expenditure of the United Kingdom, except expenditure that is merely local; and the boundary-line between Imperial and local taxation they fix according to the division of duties between central and local authorities. But this division is surely arbitrary, and seems to confuse the administrative and financial aspects of the case in question, for the expenditure on a service may be Imperial, and yet the service may be locally administered, or a service may be maintained from local funds, but imperially administered.[846](javascript:footNote('E900040/note846.html')) If we regard Ireland and Great Britain, or Ireland, England, and Scotland as financial units simply for the purpose of more convenient financial enquiry, we should try and arrive at some sound



---

p.411



principle by which we can assign proportions of total outlay to the separate parts, distinguishing between English, Scotch, and Irish services and services which are altogether Imperial. The clearest principle is no doubt that of ‘advantage received’ — although this advantage is difficult, if not impossible, to measure as regards many services — while expenditure that appears equally to the advantage of all three parts should be regarded as Imperial. It must, of course, be noticed that additional expenditure taking place in one of the three units need not necessarily be to the advantage of that unit, and this consideration is especially important in the case of Ireland. Take the case of the large number of troops stationed in Ireland. In so far as this is due to cheaper cost of living, as it partly seems to be, it certainly should not be debited against Ireland. No unnecessary expenditure, such as the high cost of the Irish Civil Service, should be placed against Ireland's account, and the extra cost of police, due to political and social conditions, ought to be regarded as Imperial expenditure, for Great Britain is even more interested in the peace and quiet of Ireland than is Ireland herself. On the other hand, extra expenditure due to economic conditions, such as the loss on the Irish Postal Service, may in strictness be placed to the Irish account, while such expenditure as that recently incurred for the establishment of local government in Ireland, or the establishment of the new **Department of Agriculture and Technical Instruction** for Ireland, must certainly be debited to that country. But every item of expenditure in Ireland should be minutely examined and analysed, in order to see what is strictly Irish and what may be regarded as Imperial. The results of such a minute enquiry, if indeed it could be satisfactorily carried out, might be in favour of the contention as to the unfair financial treatment of Ireland, or it might be the reverse. But it is certainly unfair to take, as the Commission did, only the revenue side of Ireland's relation to the United Kingdom. In a comparison which



---

p.412



regards Ireland as a financial unit, the expenditure side of the Irish relation to the United Kingdom should also be taken into account. We are perfectly entitled to distinguish between Irish revenue and expenditure on the one hand, and Imperial revenue and expenditure on the other, for purposes of financial comparison; only the classification we adopt must be a precise and proper one, and the difficulties of such a classification are enormous.


There has been little discussion among economists as to the principles which should govern the incidence of taxation as between different countries making up a larger whole. This is because, in most cases under consideration, some sort of a federal system exists, and the question is simplified by the fact that only common expenses are paid out of the common treasury, the determination of these common expenses being rendered easy by the political constitution of the Federal State, while the proportion contributed by each separate part does not appear to be fixed according to any specific standards, but seems to be the result of some system of compromise. But in a unitary State local divisions are held to be of little importance in matters of finance, and there is no financial intermediary between the State and the individual. And so we come to the position of the ordinary Englishman of the present day, who insists that a common fiscal system in two united countries like Great Britain and Ireland must lead to an equality of burden, and that as each individual Irishman only pays in Ireland that amount of taxes which he would pay if he lived in England, Ireland cannot be overtaxed as compared with Great Britain.[847](javascript:footNote('E900040/note847.html'))


---

p.413



But this point of view is apt to be fallacious when we are considering two countries so economically distinct as England and Ireland, and in which the proportions that the poor bear to the rich are so different. In a unitary State which possesses more or less uniformity of conditions one fiscal system will produce more or less similar results, but it may lead to a fallacy to neglect the due adjustment of the burden of taxation in regard to the territorial divisions of a unitary State such as our own, where heterogeneity rather than uniformity of conditions prevails. We thus lose sight of the fact that under our present fiscal system a poor territorial division, in which agriculture is the chief industry, situated side by side with a rich territorial division which depends chiefly on manufacturing industry, may in practice be unfairly treated under an identical system of taxation.


Of course there is a valuable element of truth in thus emphasising the fact that in a unitary State the State deals directly with the individual in all matters of taxation, for ultimately all taxation must fall on persons. If Ireland is overtaxed it must be because some persons or classes in Ireland pay more than their fair share, and so we come to the really important point in all financial questions, and that is, the real incidence of taxation on individuals. On the whole it seems more profitable as regards the enquiry with which we are concerned to look at the matter from this point of view. We have seen that it is legitimate to distinguish between the territorial divisions of a unitary State for the purpose of financial comparison, and that this separation into separate parts may be useful in enabling us to realise the fallacy of assuming that a similar fiscal system operating in these different parts must lead to precisely similar results. But here Ireland is no peculiar case, for the problem would work out something similarly 



---

p.414



were we to separate off certain poor rural districts in England, Wales, or Scotland, and institute an enquiry concerning their taxable capacity and actual burden of taxation. A clearer idea of the actual financial situation of Ireland seems to be attainable if we abandon the idea of treating Ireland as a fiscal unit, and regard her as an integral part of the United Kingdom for all purposes of taxation; and thus meet on their own ground those persons who state that Ireland cannot be overtaxed because she is subject to the same system of taxation as Great Britain.


If we consider Ireland not as a separate entity but as one country with Great Britain for purposes of taxation and expenditure, then all endeavours to determine proportionate charges and expenditure appear irrelevant. What we have to look at is the incidence of taxation on the individual in whatever part of the United Kingdom he may reside. We thus avoid many difficulties and complications and much weakness of statistical data, and our proper enquiry resolves itself into the question whether our present fiscal system is fair in both countries as between rich and poor, bearing in mind the much greater proportion of poor to rich in Ireland. Such an enquiry is more efficacious than any other in locating the actual financial burden under which Ireland labours. All economists are agreed that a man's capacity to contribute to taxation should form the measure of his contribution, and that capacity is in some way related to income. At this point, however, agreement ceases, for some are of the opinion that a man's whole income without making any deduction should be the criterion of his capacity, while others believe that taxation should in justice not be levied on the whole income but on the surplus which remains after the defraying the bare necessaries of life. It is, of course, impossible to take anything from a person who possesses merely a bare subsistence minimum, and allow him at the same time to



---

p.415



continue to exist. But the difficult question is how far this subsistence minimum has to be exempted when the individual has a larger income, and at what amount of yearly income should an exemption for a minimum of subsistence cease. There is no agreement on these points, nor is there any concerning the difficult problem as to what standard of living should be assigned in order to arrive at the proper amount of subsistence minimum. When we are dealing with individuals inhabiting different countries or districts where economic conditions and habits of living vary, these problems become more difficult. The standard of living must differ in different districts, and especially in different countries like Great Britain and Ireland; it is always more or less elastic, and it is difficult to convert it into a hard and fast point. Theoretically, indeed, it seems far more just that capacity should be measured by surplus income and not by total income, but the difficulties of practical application are very great. It is difficult enough to get at income without hoping to arrive at even an approximate conclusion as regards surplus income. And as precision in such an enquiry is above all things needful, it seems more practicable to take a man's total income as the measure of his taxable capacity.


Looking at the matter, therefore, in this light, it may be well to look at the incidence of our present system of taxation on individuals in Ireland. There certainly seems no case for Ireland in the region of direct taxation. The income tax and the death duties do not appear to press more heavily on the Irish than on the British population, while a slight relief is given to Ireland by the non-imposition of certain small taxes.[848](javascript:footNote('E900040/note848.html')) But the case of indirect 



---

p.416




taxation is different. It was found by the **Financial Relations Commission** in 1896 that the direct taxes in Ireland yielded 1/20 of the total receipts of the United Kingdom, but that the indirect taxes yielded 1/9. Even if we make all allowances for mistakes which may or may not have existed in arriving at these proportions, the discrepancy which appears between the two yields is far too great. The high rates of taxation on tea, tobacco, and spirits brings about this large Irish contribution from indirect taxation, and they place a heavy burden on the poor, who form such a large portion of the whole Irish population.


The question, then, is not one of the over-taxation of Ireland as a whole. The upper and middle-class Irishman and the Irish well-to-do farmer and artisan have no grievance. The pressure is on the lowest section of the agricultural population and on the unskilled labourers. We thus simplify the problem and find that the question is one of classes rather than of countries. The case is not one of Ireland versus Great Britain but of the unskilled labourer and very small tenant farmer, whether he be found in Ireland or in Great Britain. In Great Britain a labourer with 10s. to 15s. a week, and in Ireland a labourer with 7s. to 9s. a week, will pay as much in indirect taxes as the skilled artisan or tradesman with £1 10s. to £2 a week. But in Ireland there is a huge class with the small income of unskilled labourers, and the income of unskilled labour is on the average two-thirds of what it is in Great Britain, while in Great Britain this class is small compared to the whole population.


In Ireland the people who live from the land, working their holdings as owners or tenants merely with their own labour, number, with their families, about two million persons out of an entire population of under four and a half millions.[849](javascript:footNote('E900040/note849.html')) The average holder in this class has a 



---

p.417



holding valued for taxation purposes at £6 to £7, and it is from him that the largest amount of taxes come. On the average the income of these small farmers, with the application of their own labour to their farms, seems to be about £35 a year. This would work out at £7 a year for the maintenance of each member of a family of five, a smaller amount than the annual cost of feeding and clothing a pauper in an Irish workhouse. This estimate is, of course, only approximate, and incomes range over and below the average. But it is an undoubted fact, for proof of which absolutely accurate figures are not necessary, that our present system of taxation, which raises such a large amount from the necessary consumption of the mass of the people, presses more heavily on the Irish poor than on the British poor, simply because their poverty is greater, and because the poor in Ireland form a very much larger total of the population than the poor in Great Britain. A certain system of direct and indirect taxation combined may bring about a roughly just proportion between the upper, middle, and working classes, but when, as in our present fiscal system, indirect taxation is limited to a few commodities consumed in comparatively greater proportions by the poor, it presses unfairly on the lowest section of the working classes. And as this lowest section numbers such a large part of the population of Ireland, that country is the most important example of this injustice, although it also exists in Great Britain.


What is needed to remedy the injustice is the readjustment of such taxation as exceeds its proper amount. The present system of Imperial grants, subsidies, and doles to Ireland gives no direct relief to the Irish labourer with his income, say, of £30 a year for a family of four or five, and paying 5s. or 6s., or sometimes even 8s. in the pound in local rates. Such a policy gives indirectly with one hand to take away directly with the other. If the Irish labourer is overtaxed the proper remedy is to relieve him



---

p.418



directly of the over-taxation by a lower scale of duties on necessaries of consumption. We have, of course, to differentiate between the various taxed commodities. Tea has certainly the best claim to relief. No one nowadays would care to assert that tea is a luxury; tea has in fact become a necessity, and this is illustrated by the fact that the recent additions to the rates of duty on this article have not decreased its consumption. Those who before consumed superior qualities may, of course, consume inferior qualities, but those who, like the very poor, consume the cheapest tea that is to be had are not able to retrench on their consumption, simply because tea is the cheapest drink they can get, and it is more especially necessary to those who can afford little nourishing food. To the Irish peasant who lives on potatoes or Indian meal, with bread, bacon, and milk only on a few occasions in the year, tea is almost a necessary of existence. There is a good deal to be said for a substantial reduction in the duty on tea whenever the exigencies of Government allow them to make further abatements in the present heavy taxation. Tobacco stands on rather a different footing, but there seems something to be said for a reduction of taxation on the inferior sorts, for as the tax now stands it presses inequitably on the poor. The spirit duties are, of course, not wholly fiscal, and it may be noticed that the consumption in Ireland of porter is increasing at the expense of whiskey. There used to be an idea that all the evils attendant on drinking arose from spirits, and that spirits should accordingly be taxed more heavily than beer in order to induce people to drink beer instead of whiskey. This theory is now exploded, and although it cannot be said that a heavy tax on liquor constitutes a legitimate grievance, it may be argued that there is a distinct grievance in not taxing all kinds of intoxicants equally in proportion to their strength. The whiskey drinkers all over the United Kingdom have a grievance against the beer drinkers, and the fact that the



---

p.419



 
majority of Irishmen prefer spirits, and the majority of Englishmen beer, imposes on the Irish a heavier burden of taxation. It does not in the least alter the argument to say, as our Chancellors of the Exchequer are so fond of doing, that it is always open to a man to drink beer instead of whiskey. If the present tax on beer were doubled and the tax on tobacco abolished, the poor in Great Britain would pay no more in taxation, while Ireland would get a substantial relief. It seems improbable that the consumption of beer would be materially lessened by this policy.


It thus appears that the so-called Irish financial problem is not a problem belonging to Ireland exclusively. It is one which concerns the whole of the United Kingdom and which involves a readjustment of the incidence of taxation. There is no case for special and separate treatment of Ireland in this respect, because if taxation, as it affects individuals, is rectified all over the United Kingdom, the main financial injury under which Ireland labours must perforce be remedied, although it does not follow from this that the fiscal system suited to Great Britain is one suited in the same degree to Ireland. But when persons say that at present Ireland cannot be overtaxed because she is under the same fiscal system as Great Britain, they forget that indirect taxation is different in its nature from direct, and that the economic condition of Ireland is very different from that of England. Still, apart from all discussions as to the over-taxation of Ireland, there is quite enough reason for the relief of the poorer classes in that country, as well as in the rest of the United Kingdom, by the reduction of the tea and sugar duties and the abatement of the duty on the inferior sorts of tobacco.[850](javascript:footNote('E900040/note850.html'))
If we regard Ireland as an integral part of the United



---

p.420



Kingdom all additional expenditure on Ireland comes to be merely a question of redistribution between central and local finance. And thus the so-called Irish problem leads us up to another question which is important for Great Britain as well as for Ireland, and that is a due balance between Imperial and local finance. The present dole system to local bodies is, to say the least of it, unscientific; and it is to be hoped that some better method may be found of relieving poorer districts all over the United Kingdom. Ireland is here again but one example of a question which concerns the whole kingdom, although, perhaps, the most important example, on account of her decreasing population. Since 1860 Irish local taxation has steadily increased, while the population of the country has steadily decreased, so that rates per head have gone up enormously. Evidence was given before the Financial Relations Commission in 1895 that in some of the impoverished south-western districts of Ireland a man renting his holding at £6 a year had sometimes to pay 8s. in the pound in local rates,[851](javascript:footNote('E900040/note851.html')) while 5s. and 6s. were common amounts. Since the Irish Local Government Act of 1898 rates have shown no tendency to decrease, on account of the growing expenditure for the housing of the working classes, and for other purposes no less urgent. There is the same problem of high rates combined with poverty in many localities in Great Britain, and some change in our system of local taxation is necessary if we would relieve the pressure on all poorer districts. Such relief would be felt, more especially in Ireland, where the pressure of the rates constitutes a serious drawback to material progress.


Thus two things are needful in order to relieve Ireland from the existing burden of taxation, just the two things which were outside the scope of the enquiries of the **Financial Relations Commission**. The first is some change in the fiscal system of the United Kingdom, so



---

p.421



 

that taxation will press less heavily on the very poor, and, secondly, some reform in the existing system of local taxation. If these changes are regarded as impracticable Ireland should be relieved indirectly — and this is a larger question than a purely financial one — by developing the resources of the country in every direction so as to improve the position of the Irish peasant and enable him to bear the increasing pressure of taxation. The **Congested Districts Board**, the **Irish Agricultural Organization Society**, and the new **Department of Agriculture and Technical Instruction** are all going the right way to work to improve the position of the Irish poor by trying to abolish those causes which hamper their material progress, by developing the agricultural and home manufacturing industries of Ireland, and by fostering that spirit of self-help which is above all necessary for the improvement of the country. Now that the Land Bill is passed an opportunity will be given to the Irish peasantry by a really statesmanlike policy to improve their material position, an opportunity unique in the history of the relations between England and Ireland. The efforts which have been made in recent years by Government to foster the development of Ireland in various directions have met with some success, and must be regarded as indirectly giving financial relief to the Irish people.




---

p.422


Economic Conditions and Prospects in Ireland to-day
---------------------------------------------------


General Survey — Agricultural Co-operation — Rural Industries — Fisheries — Hope for the Future
During the last twelve or thirteen years notable changes have taken place in the economic condition of Ireland. In 1890 **Mr. Horace Plunkett** set definitely to work to preach in Ireland the doctrine of agricultural co-operation and those scientific methods of agriculture which had enabled other countries to monopolise the English markets in food-stuffs. In 1891 the **Congested Districts Board** was established in order to better the conditions of life prevailing among the inhabitants of the poorest districts in western Ireland. In 1896 came the Recess Committee's Report, and finally, in the Session of 1899, the Chief Secretary for Ireland, **Mr. Gerald Balfour**, introduced and carried through Parliament a Bill for the establishment of a **Department of Agriculture and Technical Instruction** for Ireland, which embodied the principal features of the Report but at the same time adapted them to the new conditions created by the Irish Local Government Act of 1898. The consequence of all this has been a remarkable development, more especially in the last six years, of the agricultural and industrial life of Ireland. The **Congested Districts Board** has done splendid work: improving and enlarging holdings, improving live stock and methods of cultivation, establishing the fishing industry on a secure and self-supporting basis, and developing other suitable industries, such as spinning, weaving, lace making, and 



---

p.423



basket work. The **Irish Agricultural Organization Society** has been doing much the same work over a wider area, and the co-operative system is now fairly established in the country. The creamery branch of the movement is proving a pre-eminent success, and has already improved Ireland's position upon the English butter market. Other branches, such as the sale of bacon, pigs, and of eggs and poultry, are also meeting with success, and the agricultural banks, which have been established in considerable numbers on the Raiffeisen principles, are placing capital at the disposal of the small farmer and labourer on easy terms. The task of the **Department of Agriculture and Technical Instruction** is to do throughout the whole of Ireland what is being done in certain poor districts by the **Congested Districts Board**, and arrangements have been made to prevent any overlapping in the work of the Department and the Board. Even during the few years of its existence the **Department of Agriculture** has done good work, and perhaps not the least interesting result of this work was the splendid section of exhibits brought together for the Cork Exhibition last year. Some of the exhibits gave examples of industries already started in Ireland, of others capable of imitation, and of others still which, whether capable of imitation or not, are at least full of suggestion and instruction for Irish industrial pioneers. On the whole, it may be said that the efforts now being made in Ireland, whether by private enterprise or by means of State help, may eventually go some way to change Ireland from a country of poverty and hopelessness into one possessed of a certain amount of material comfort. The new **Land Act** gives to a large section of the Irish people a further chance of ameliorating their economic condition, and may be the cause of abolishing much of that chronic discontent which now hampers economic progress. The industrial revival has not only a material side to it; it has a moral side also, for its task is to awaken a spirit of self-help and to do away with that terrible inertia the favourite



---

p.424




maxim of which is the familiar ‘Sure, it will do!’ The essence of the co-operative system is the creation of harmony between classes hitherto divided by political opinions and religious creeds, and the union of all Irishmen in the pursuit of one common object — the benefit of Ireland.


It is, of course, a matter of serious doubt whether Ireland by any healthy process of development can ever become a great industrial nation in the accepted meaning of the term. Her peculiar history has hampered her industrial progress, and it is not likely that she will ever become the serious rival of countries like England, Germany, or the United States. But then it is beginning to be a matter also of serious doubt whether industrialism as it exists in these countries is healthy at all. Ireland is free from those problems which agitate us in England and which result from the establishment of huge working populations in large towns; and the development of many large towns in Ireland seems at present neither possible nor desirable. But the continuous stream of emigration shows that in Ireland as well as in Great Britain the desire, or rather the necessity, for town life is a factor which must be taken into account. Emigration is the most serious danger to the economic development of Ireland and the only way in which it can be checked is by increasing the numbers and resources of the smaller Irish towns or by increasing the amenities and comforts of rural life through the promotion of cottage industries. Ireland is starting her industries just at a time when the experience of England warns her what to avoid, and she can therefore steer clear of those forms of industry in which unhealthy or underpaid labour is inevitable. The basis upon which Irish industries can best thrive seems to be that of co-operation, the kind of co-operation which has proved so successful in Irish agriculture, and which is now being applied to some minor industries. The successful establishment in England of the co-operative system



---

p.425



has been hindered by the existence of many peculiar conditions and traditions; but over the greater part of Ireland industrial life is practically non-existent, and there is, therefore, more chance of establishing industries on a strictly ethical basis. It is difficult to prophesy as to the lines along which Irish industrial development will proceed, for although the absence of coal and heavy minerals in Ireland renders the country not particularly suited for the factory system as established in England, the use of water power may in the future be made to subserve the uses to which power in other forms is applied. Ireland also possesses potential riches in her clays, while the adaptation and development of electricity may lead to changes in the methods of industry all over the world. But for the present, at any rate, Irish industrial development mainly lies in the direction of minor industries, and especially of cottage industries. In a country like Ireland, where the inhabitants subsist chiefly through farming, the establishment of cottage industries subsidiary to agriculture is of immense importance. The application of machinery to agriculture and its reorganisation on co-operative lines have set free much surplus labour of the farming classes in general and of the Irish peasant women in particular. What is wanted more than anything else to improve the condition of the mass of the Irish people is the successful establishment of such rural industries as may occupy the spare time of the farmers and their wives and daughters, and make all the difference between moderate comfort and acute poverty. Land is no use to a pauper, and the sense of undivided ownership does not of itself make a man prosperous. The creation in the near future of a peasant proprietary over the length and breadth of Ireland is practically certain, but this alone would be of little permanent benefit to the Irish people were it not for the fact that the present reorganisation of agricultural industry on co-operative lines and the revival and creation of minor industries to supplement agriculture may



---

p.426



enable this peasant proprietary to exist in some sort of material comfort, and keep itself free from the old curse of the money-lender.


 The co-operative movement in Ireland is altogether different from the co-operative movement in England. In England it began among the artisans in the towns; in Ireland it began among the agricultural population. In England at the present day it is distributive; in Ireland it is productive. When **Mr. Horace Plunkett** started the movement in Ireland he thought of following on English lines, and therefore set up a co-operative store in County Meath on the English model. But very soon he came to the conclusion that the establishment of co-operative stores would in itself be of little benefit to the country, and that co-operation could only work for good in its effects upon agriculture as the national industry. A recent invention had changed butter-making from a home to a factory industry, and this transformation in the dairying industry presented a good opportunity for the first experiment in agricultural co-operation. There was no idea of joint ownership or joint management of farming lands; the idea was merely associations of farmers for the improvement of every branch of agricultural industry. **Mr. Plunkett** had naturally immense difficulties to cope with, for none in England, and only a few in Ireland, believed in the possible success of his scheme. But **Mr. Plunkett** had confidence in the intelligence of the Irish farmers, and he was sure of their honesty and business capacity. Events proved that he was right, and that those who believed Irish farmers to be incapable of organisation and combination were wrong. In the autumn of 1889 a large meeting of farmers was held in County Limerick to discuss the scheme of a Co-operative Dairy Society, and in 1890 the task of introducing co-operative methods into Irish agriculture was definitely begun. It started with the dairying districts of Munster. In spite of their many advantages, these districts had been beaten by the Danes,



---

p.427



 
and Danish butter had taken the place of Irish in the English market. Curiously enough, it was not until **Mr. Plunkett** and his friends had definitely thought out the idea of co-operation, as applied to agriculture, that it was discovered that the success of Danish butter was due to the application of co-operative principles, for these principles had led to improved methods in the creamery system and to the perfected machinery and expert skill applied to the manufacture of creamery butter. The discovery made the Irish pioneers more sure of success, and the first co-operative creamery, founded and registered in 1890, was felt to be the beginning of a national economic movement. The members of the society contributed the capital necessary for the buildings and plant, each member taking a number of £1 shares, according to the number of cows kept by him for dairy purposes. On this capital 5 *per cent* dividends were to be paid out of profits, and the rest of the profits was to be divided among the members in proportion to the quantity of milk which each had supplied to the creamery. By 1894 there were in existence thirty-three co-operative creameries established on these lines, and in this year ‘auxiliaries’, as they were called, began to be formed. These are societies which separate the milk from the cream, and send the latter to be churned at a central creamery. Last year there were in existence 193 central creameries, and 77 auxiliaries.[852](javascript:footNote('E900040/note852.html')) An enormous quantity of butter is turned out, and a good profit made. At the end of 1900 the total membership of these dairy societies amounted to 26,577, and there was £120,485 invested by Irish farmers in this branch of their industry.[853](javascript:footNote('E900040/note853.html')) The average yield of butter from the milk has greatly increased, and Irish butter is beginning to regain its old position in the market. The new creamery system does not only benefit the farmer — it also benefits the labourer by giving him an opportunity of becoming a cow-owner.



---

p.428



A labourer can send his milk to the neighbouring auxiliary, and gets for it a much better price than he formerly obtained from the local dealer. The gain per cow on the old butter-making methods is generally estimated at 30s. per annum.[854](javascript:footNote('E900040/note854.html')) Above all, the creamery system frees the small occupiers and labourers from the tyranny of the retail shopkeepers. Before the co-operative movement sprang into existence a man was forced to buy his groceries at extravagant prices from the local shopkeeper, giving perhaps one-third more for a pound of tea than its proper price simply because the shopkeeper was the only available purchaser for his milk, butter, or eggs. Now a man sends his milk to a creamery and his eggs to a co-operative poultry depot, and he need not purchase from the local dealer if the latter's prices are unreasonable. The new system places the small farmers and labourers on terms of equality with the substantial farmer, for the creamery will give them as much per gallon for milk of the same quality as it does to the big man, will extract as much butter for every gallon of their milk, and will sell the butter for them at a fixed price according to its quality.[855](javascript:footNote('E900040/note855.html'))


After the creameries had begun to put their butter on the market they commenced marketing it themselves, and in 1892 several of the local societies federated themselves into a selling society, with a head office at Limerick, and offices and stores in Manchester. At first there were disasters; the society became involved in lawsuits, contracted bad debts, and in the first year lost all its capital. But the scheme was persevered in with great tenacity, and eventually proved successful. In three years the society had made good its early losses, and is now established on a sound financial basis.



---

p.429




Before the end of 1894 a number of ‘agricultural societies’ had been founded; last year they numbered 111, and their chief function is the cheapening of production by the purchase of good seed and of implements and general farming requisites. They also make it their business to improve live stock, and in some cases these agricultural societies affiliate themselves to an agency society and effect the sale of their agricultural produce and the purchase of their implements through its offices. The agency society sells for the affiliated societies not only butter, but eggs, poultry, and any other farm produce that can be profitably disposed of. An important branch of business has recently been developed by the agricultural societies: this is the sale of bacon pigs. The societies send their pigs direct to the curers, receiving payment for each pig according to its weight and quality. The curer allows a commission of 1s. to the society for every pig sent to him, and this commission is an important item in the society's funds. The system has been found to work well, and members of the societies in the most remote districts get better prices for their pigs than in the days when they were dependent on individual bargaining.


There are also a number of co-operative poultry societies,[856](javascript:footNote('E900040/note856.html')) whose business is to improve the breeds of poultry, to teach scientific methods of fattening and rearing poultry, and to improve the methods of placing poultry and eggs on the market. The **Department of Agriculture** employs poultry experts, who give technical instruction to the members of the societies, and especially teach them the Danish method of grading and packing eggs for export. Besides the poultry societies proper, many of the dairy and agricultural societies have taken the business up. The Irish export trade in eggs has had to encounter many difficulties, but it is bound to prosper



---

p.430



eventually under the present system on account of the real excellence of Irish eggs.


Besides the societies for the production, sale, and purchase of agricultural produce, there are seventy-eight miscellaneous societies, which carry on various rural industries, from flax-scutching to the making of lace on co-operative lines. There are twenty-three co-operative societies of lace-workers, which are supplied with designs by a lace depot in Dublin. The depot also takes their lace and sells it, and after defraying all expenses gives to each society of workers a bonus in proportion to the value of the lace it has supplied. Sales of lace are also carried on in London by the Irish Industries Association. The co-operative needlework society at Dalkey turns out particularly beautiful ecclesiastical embroidery, and in many other minor industries the co-operative system is spreading. Lastly, there are eighty-seven agricultural banks, which exist for the sole purpose of creating funds to be lent out to their members. No loan is made until the committee of the particular bank is convinced that the purpose to which it is to be applied is a productive one, and that the borrower is certain to repay it. Loans are, therefore, made on the character of the borrowers. As the banks are registered with unlimited liability every member — and every borrower is a member — becomes interested in the repayment of every loan. There have been no cases of failure to pay, and even cases of unpunctual repayment are rare, although thousands of loans have been made to very small men. The system has spread over the whole of Ireland, but flourishes best and does most good in the poorest districts. The Irish agriculturist, whether occupier or labourer, instead of borrowing to spend, now borrows to make; he can tide over a bad season, he is rendered independent of the money-lender, and he is given by his fellows a chance of becoming a producer of wealth. The good economic and social effects of the system of co-operation, whether applied to agriculture,



---

p.431



to minor industries, or to banking, can hardly be exaggerated. Public spirit is the great thing needful in Ireland, and wherever a co-operative bank, a creamery, or a poultry society is formed, a blow is given to that inherent feeling of suspicion which is so characteristic of the Irishman, and a growing spirit of self-reliance begins to remove the old idea that all initiative must come from the State. Their history has naturally taught the Irish people to attribute their industrial shortcomings to the action of the State, and, therefore, anything which shows them that their material progress is now to a great extent dependent on their own efforts is invaluable.


But besides the reorganisation and revival in agriculture there has also been a real revival in rural industries. This progress is quite recent, and is, to a large extent, the work of the Congested Districts Board, assisted by private persons, while now the task has been taken up by the new **Department of Agriculture and Technical Instruction**. The woollen hand-weaving industry is the most important. We have seen how it existed in Ireland from time immemorial, but how after the early part of the nineteenth century it sank into decay. But the progress recently made has been great. The industry flourishes all along the western coast, from Donegal to Kerry, where the people generally weave their own stuffs and dye them with those lichens and plants which the Irish peasant has always known how to use. In these western counties there is mountain grazing for sheep, and much labour running to waste in the winter months, while the peasantry have an inherited taste for weaving. As a rule, home-spun cloth is merely produced for local use, although it is finding its way more and more into the Dublin and London markets, and there has begun to be a considerable demand amongst ladies for Irish homespuns owing to their delicious softness and great durability. In South Donegal, however, great quantities of handwoven cloth is produced for sale outside the district, and



---

p.432



the manufacture is conducted on strictly business lines. Hand-made cloth goes every month from the fairs of Ardara and Carrick to many of the chief towns of Europe and America, and at present the demand is good and prices high. The industry was brought to its prosperous condition chiefly through the efforts of the **Congested Districts Board**, who, in 1893, introduced new looms in place of the antiquated ones then in use, receiving payment for them by instalments, provided instruction for their use, and for a short time gave a bonus on work of exceptionally good quality. The special arrangements for instruction and bonus-giving have now been discontinued and the industry thrives without outside assistance. The Board is now extending the use of the new looms into the more southern counties, and a school of instruction has been opened at Leenane, in Connemara. All over County Galway a soft durable white flannel is made. It is worn by the children in its natural state, but the women dye it red, dark blue, and black for their own use. Some of the flannel may be seen in the drapers' shops in Galway, but little is as yet sold outside the county. In Kerry, strong home-spuns are woven, but they have not the richness of colouring possessed by the Donegal and Galway stuffs. It is thought that only instruction and encouragement is needed to enable the people of Galway, Mayo, and Kerry to reap the same profit from weaving as the Donegal peasants.[857](javascript:footNote('E900040/note857.html')) At present, there certainly seems to be a future before hand-made stuffs. Just now the Irish lace-making industry is in a prosperous condition. There is a keen demand in the United Kingdom for hand-made lace, and although the majority of people must always content themselves with the machine-made article on account of its cheapness, there will always be a certain number of persons who can afford to indulge their taste for beauty. Twenty years ago, the Irish lace-making industry had sunk to a low position. 



---

p.433




The lace made was coarse, and the designs bad and unoriginal, while the industry had altogether lost touch with the requirements of fashion. But since 1883 various private persons have taken the matter up, and they, as well as the **Congested Districts Board** and the **Department of Agriculture**, keep the convent schools, where the lace is chiefly made, acquainted with new designs and new fashions. The **Royal Dublin Society** does much to stimulate the industry by its annual exhibition of lace among other art industries at *Ballsbridge* as well as by the prizes it offers to makers of the most beautiful pieces of lace. The Irish lace-making industry must, however, always depend on outside aid, for the convent schools are far from the centres of industry, and the peasant girls who work in their own homes are no more able than the nuns to acquaint themselves with the needs of the market. In no industry is it so necessary to be constantly changing designs and patterns, and a lace collar, cape, coat, or overskirt, however beautiful the execution and design may be, cannot be sold unless it is made in the shape and style demanded by the fashion of the time. In the congested districts the Board can always take care that this assistance is given to the lace workers; and, no doubt, in other parts of Ireland, as the numbers of co-operative societies increase, it will be more easy for the workers to get the exact designs that are wanted and to take care that these designs are constantly changed. In these days of a revival in the taste for beauty in dress and decoration, a future should lie before the Irish art industries and especially before the lace-making industry.


Hand weaving and lace-making are the principal rural industries of Ireland; but there are many others, some of which are carried on in the workers' own homes and others in village workshops. The chief of these are hand knitting, hand embroidery, carpet-making, basket-making, iron-work, stained glass, wood-carving, stone and marble carving, bookbinding and leather-work, metal repousse



---

p.434



work, cabinet-making, porcelain, and silver and goldsmiths' work. Nothing approaching the excellence of Irish hand embroidery is to be found anywhere in Great Britain, and it is not rivalled in beauty even by the embroideries of France or Belgium. The hand-tufted carpet industry in Ireland is one of growing importance. It was introduced a few years ago into Killybegs, County Donegal, by a Scotch firm, and there are now 300 workers employed at this place and at Kilcar, also in County Donegal. The carpets are made entirely by hand, in large, airy workshops, as the looms could, of course, not be got inside the ordinary small cottage. They are exquisite in design and colour, and are rapidly establishing themselves in the London market. Other art and cottage industries are carried on with more or less success, but are still on a comparatively small scale. At Fivemiletown, in County Tyrone, there are various flourishing cottage industries in the way of embroidery and metalwork. Basket-work is carried on as a cottage industry in several places in the west and south of Ireland; at Letterfrack, in Connemara, the industry is especially flourishing. There is no doubt that one great way to improve the condition of agricultural Ireland is the development of these cottage and art industries. With the exception of the home-spun woollen industry and the lace-making industry they are still on a small scale, but taken in the bulk they give a good deal of subsidiary employment, and there is reason to believe that before long they will increase greatly.


Another way in which the resources of Ireland are being developed is in the promotion of sea fisheries. This also has been the work of the **Congested Districts Board**, for the Irish fisheries lie along the coasts of many of the congested districts. The Board started operations in 1893, in Galway Bay, where transit facilities were comparatively favourable. Boats were provided, and seven Arklow crews who were accustomed to deep-sea fishing were hired to come and fish for mackerel off the Aran



---

p.435




Islands in April and May. The Galway fishermen did not believe in the possibility of catching mackerel in the spring, for they had only availed themselves of the autumn mackerel fishery. But the Board brought a steamer to help the Arklow men, and provided boats, nets, a cargo of ice, and boxes in which to pack the fish. At last, after several days of disappointment, the fish came; the Galwaymen were convinced, and from that time were glad to avail themselves of the Board's help. The Board still supplies boats, by means of loans repayable by the fishermen in half-yearly instalments, but otherwise the mackerel fishery off the Aran Islands stands on a self-supporting basis. The Board no longer acts as the sole buyer, and private traders send their steamers and agents to purchase fish. Up to last year private traders were only allowed to use the Board's curing stations on the condition that the price they paid for the fish did not go below a certain minimum sum, but this year the Board is no longer to interfere in the matter of price, and the fishermen will be left to the competition of the open market.[858](javascript:footNote('E900040/note858.html')) The same methods have been applied by the Board to the development of the fishing industry in other parts of western Ireland. A new mackerel fishery has been opened in *Blacksod Bay*; there is an important herring fishery off the coast of Donegal, where the take, unfortunately, fluctuates, but has sometimes been very large; and the conger, skate, and cod fishery at Aran is progressing. Up to 1900 the mackerel fishery on the south coast of Ireland was flourishing, but in that year mackerel suddenly returned to the American coasts, and the price of Irish mackerel fell enormously. The result has been a decline in the trade, and for the present there seems little prospect of its revival. England supplies her own mackerel, and there is little chance of finding a market 



---

p.436



for Irish mackerel on the Continent owing to the Customs duties on imported fish.


One of the most important parts of the work of the Board is the instruction given in net-making, barrel-making, and boat-building. There are cooperages at two centres in Donegal, where a large number of barrels are turned out, and others in Cork and Kerry, while large fishing vessels are built on the coasts of Connemara and Donegal. It is hardly necessary to point out how important is this work of the Board in developing the Irish fishing industry, and in developing it, too, on such practical lines as to make it eventually altogether self-supporting. In some of the places where the industry is being developed a comparatively large population lives on barren ground, supporting itself by annual emigration to England or Scotland in harvest-time. The holdings of these people are their homes, to which they return when they have made enough money to support themselves for the year; they are not and cannot be their means of livelihood. But the development of the fisheries means that these people can earn enough to support themselves at home without seeking work elsewhere. It is to be hoped that a place like Achill Island, where the conditions of living are about as bad as they can be, may in time be converted by the Board into a fishing centre. Irishmen in the past have never been great deep-sea fishermen, and have contented themselves with fishing near the coast, except for the short period at the end of the eighteenth century when the Irish Parliament began to develop deep-sea fishing. But the prosperity of the Irish fishing industry was short-lived, and disappeared in the early part of the following century. Until the advent of the **Congested Districts Board** Irish boats were totally unfit for deep-sea fishing. But now the men on the western coast are taking to the industry well, and only time and the splendidly practical methods of the Board are necessary for its development.




---

p.437


The economic progress of Ireland seems to be bound up with the development of the great national industry of agriculture and with the promotion of the Irish fisheries, and of various rural industries as supplementing agriculture. The north-east of Ireland, the districts surrounding Belfast and other large towns, presents a different kind of economic development, and one that is akin to that proceeding in England, while Dublin, with its professional and business population, stands on a plane by itself. But these towns and districts form but a small part of Ireland, and in them the exclusively Irish problem does not appear. Broadly speaking, Ireland is an agricultural country, and therefore anything which has for its object the improvement of the condition of the Irish people must be directed towards the furtherance of the national industry or towards enabling those persons dependent on agriculture to supplement their agricultural earnings by profits arising from fishing and from cottage and art industries. In agriculture machine labour is taking the place of manual labour, and many agricultural processes can be better carried on in factories than in the farmers' homes. No individual farmer can afford to supply himself with the new expensive plant which is now required, and the one solution of the problem in Ireland is co-operation, which enables farmers, working together, to get the best plant going. In England matters are different, for there the farms are large and the farmer is a capitalist. But in Ireland the majority of the farms are small, many very small, and a system of peasant proprietorship will gradually be created. Under present economic conditions a peasant proprietor taken by himself is doomed to failure, but a peasant proprietary acting together on co-operative principles may meet with success. Organisation for a common object and mutual help is all that is needed in order to raise the peasant owner from an isolated position to a competitive level from which he can carry on his industry on the most advanced lines. If the new **Irish Land Act** had been passed twenty or thirty 



---

p.438



years ago, it could have resulted in nothing but bitter disappointment and failure; the new peasant owner would have come under the influence of the money-lender and the last state of things would have been worse than the first. Now the Bill becomes law there is at least a good chance of it working successfully, simply because the Irish agriculturist is slowly being raised to a better material condition.


At present what is urgently needed is to put a stop to the disastrous emigration which each year robs Ireland of her best and strongest men and women. There is no doubt that the settlement of the land question may do much to check this emigration, just because present economic conditions in Ireland render possible the establishment of a peasant proprietary possessed of some degree of material comfort. It is poverty that has all along been the chief cause of Irish emigration. Once ameliorate the condition of the people and they will become less anxious to leave their country, industrial development will proceed, and the grievance of local taxation will diminish. The revival and creation of cottage industries must make rural life more varied and cheerful, and the system of co-operation can in itself increase the amenities of social intercourse. The resources of Ireland, in fact, should be developed along those lines which most naturally present themselves. We should give up the idea of turning Ireland into an industrial nation in the present meaning of the term; we should take her as she is, an agricultural nation, and the fourth meat-producing country in the world, and endeavour to develop her great industry of agriculture, and side by side with that to promote all those minor industries the great value of which is to give subsidiary employment to the rural population. This is what both private enterprise and State-aided enterprise are now doing in Ireland, and certainly at no period in the past has the future of the mass of the Irish people appeared more hopeful.


Appendix 1
----------




---

p.439


### Appendix A: (See Chapter IV., p. 69.) Bishop of Derry to Mr. Annesly,
June 15th, 1689. (King MSS., Vol. I., folio 243. TCD)


‘  
[*...*]  
it seems a little odde that the cheapness of neccessarys for life & goodness of materialls for making all manner of cloth should be made an argument against allowing us to make any, which to me sounds as if one should say to his child you have a good stomach and here is plenty of meal and very good therefore you shall not eat a bit. I do not apprehend why the inviting over English familys to settle in Ireland at this Juncture should be made a reason against us, the waste lands of Ireland must be peopled from some place and quere whether it be safer for England to suffer a few of their people that are willing come, and useless to England or miserable in it, to come here, or to let Ireland be peopled with French and Scotch, England must either let those come that are willing to come, which will increase ye the generall stock of English, or send armys to keep ye country for them, who mairy Irish and whose children will increase the Enemys of England as they have done all a long lastly whereas it is said that the lands of Ireland are generally proper for the linnen manufacture, the truth is quite otherwise   
[*...*]  
 but the best way is to let this matter alone till England be whipt with its own rode as it was prohibiting Irish Cattel and assure yourself these breaches on Ireland by ye parlement of England will one day come home them as much as that act has.’


Appendix 2
----------




---

p.440


### Appendix B: Table I. Provisions exported from Ireland 1764–1800





| Year ended Lady Day | Bacon (hams): *No.* | Bacon (flitches): No. | Beef (barrels): No. | Beef (carcasses): No. |
| --- | --- | --- | --- | --- |
| 1764 |  —  |  —  | 218,220 | 19 |
| 1765 |  —  |  —  | 199,999 | 82 |
| 1766 |  —  | 9,640 | 190,409 | 53 |
| 1767 |  —  | 5,778 | 173,484 | 70 |
| 1768 |  —  | 21,275 | 209,847 | 111 |
| 1769 |  —  | 8,156 | 205,368 | 23 |
| 1770 |  —  | 6,500 | 208,269 | 55 |
| 1771 |  —  | 15,573 | 201,010 | 17 |
| 1772 |  —  | 14,142 | 200,829 | 13 |
| 1773 |  —  | 19,256 | 215,191 | 37 |
| 1774 |  —  | 26,100 | 187,494 | 218 |
| 1775 |  —  | 32,644 | 192,452 | 10 |
| 1776 |  —  | 24,502 | 203,685 | 9 |
| 1777 | 241 | 11,462 | 168,578 | 110 |
| 1778 | 578 | 15,992 | 190,695 | 42 |
| 1779 | 391 | 11,792 | 138,918 | 31 |
| 1780 | 203 | 1,723 | 187,754 | 16 |
| 1781 | 183 | 172 | 190,501 | 12 |
| 1782 | 228 | 239 | 155,582 | 6 |
| 1783 | 713 | 6,337 | 212,018 | 12 |
| 1784 | 1,007 | 33,255 | 126,531 | 8 |
| 1785 | 720 | 35,485 | 136,650 | 166 |
| 1786 | 639 | 30,310 | 158,388 | 78 |
| 1787 | 469 | 16,525 | 153,649 | 75 |
| 1788 | 491 | 29,587 | 130,857 | 546 |
| 1789 | 695 | 33,791 | 120,192 | 25 |
| 1790 | 1,836 | 56,494 | 126,993 | 14 |
| 1791 | 1,328 | 60,735 | 120,506 | 78 |
| 1792 | 1,156 | 62,490 | 135,219 | 54 |
| 1793 | 1,127 | 74,400 | 102,333 | 4 |
| 1794 | 643 | 77,996 | 135,238 |  —  |
| 1795 | 752 | 63,808 | 124,607 | 14 |
| 1796 | 1,091 | 125,085 | 122,155 | 0.5 |
| 1797 | 1,314 | 92,086 | 110,141 | 20 |
| 1798 | 1,698 | 52,941 | 108,346 |  —  |
| 1799 | 1,647 | 68,653 | 153,578 | 4 |
| 1800 | 1,049 | 123,183 | 149,856 |  —  |









| Year ended Lady Day | Butter: Cwt. | Bullocks and Cows: No. | Calves Skins: No. | Candles: Cwt. | Cheese: Cwt. | Tanned Hides: No. | Untanned Hides: No. | Hogs: No. | Pork: Barrels | Tongues: Dozen | Tallow: Cwt. |
| --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- | --- |
| 1764 | 257,976 | 155 | 12,074 | 8,895 | 3,466 |  —  |  —  |  —  | 35,006 | 6,121 | 50,501 |
| 1765 | 301,109 | 396 | 14,668 | 5,564 | 3,927 | 44,469 | 61,866 | 140 | 44,361 | 5,391 | 52,706 |
| 1766 | 271,946 | 1,364 | 20,224 | 3,293 | 3,840 | 45,754 | 76,100 | 481 | 50,155 |  —  | 46,543 |
| 1767 | 257,047 | 857 | 20,794 | 2,862 | 3,541 | 46,606 | 65,289 |  —  | 34,995 | 3,255 | 51,071 |
| 1768 | 304,623 | 2,578 | 19,555 | 4,222 | 4,113 | 42,054 | 82,095 | 22 | 43,041 | 5,036 | 51,662 |
| 1769 | 315,153 | 1,676 | 21,410 | 3,428 | 2,686 | 23,994 | 89,062 | 442 | 40,039 | 4,902 | 49,089 |
| 1770 | 262,717 | 1,250 | 19,255 | 1,730 | 1,815 | 28,187 | 102,943 | 416 | 43,947 | 4,198 | 48,260 |
| 1771 | 238,800 | 666 | 17,934 | 2,170 | 1,996 | 41,073 | 98,686 | 76 | 42,519 | 4,372 | 46,842 |
| 1772 | 288,475 | 456 | 26,015 | 2,430 | 2,406 | 65,643 | 90,323 | 90 | 44,713 | 5,252 | 44,981 |
| 1773 | 272,399 | 591 | 18,136 | 2,183 | 2,101 | 57,836 | 62,142 | 135 | 51,112 | 5,010 | 39,920 |
| 1774 | 270,096 | 2,477 | 17,148 | 2,024 | 2,575 | 41,238 | 67,044 | 882 | 52,328 | 4,348 | 41,350 |
| 1775 | 264,140 | 6,625 | 23,803 | 2,234 | 1,953 | 56,890 | 79,892 | 680 | 50,367 | 4,620 | 42,295 |
| 1776 | 272,411 | 6,924 | 19,745 | 3,155 | 2,229 | 37,277 | 71,297 | 1,148 | 72,714 | 5,607 | 50,549 |
| 1777 | 264,181 | 4,198 | 18,457 | 1,764 | 1,597 | 26,953 | 57,438 | 1,358 | 72,931 | 4,663 | 48,502 |
| 1778 | 258,144 | 3,716 | 16,601 | 938 | 1,561 |  —  |  —  | 874 | 77,612 | 4,676 | 38,450 |
| 1779 | 227,829 | 3,960 | 17,625 | 1,827 | 753 | 11,728 | 44,095 | 285 | 70,066 | 3,315 | 41,384 |
| 1780 | 244,184 | 4,838 | 17,908 | 5,611 | 960 | 13,182 | 68,777 | 169 | 96,554 | 5,114 | 54,592 |
| 1781 | 264,210 | 2,298 | 24,303 | 7,175 | 1,423 | 3,657 | 92,381 | 45 | 106,282 | 5,007 | 39,678 |
| 1782 | 234,058 | 165 | 20,303 | 7,072 | 2,175 | 3,499 | 60,771 | None | 84,910 | 5,067 | 38,275 |
| 1783 | 249,485 | 400 | 22,510 | 9,560 | 2,329 | 10,488 | 58,079 | 642 | 112,369 | 6,371 | 34,420 |
| 1784 | 257,417 | 6,836 | 15,876 | 10,402 | 1,504 | 7,170 | 47,284 | 1,937 | 52,912 | 3,943 | 17,806 |
| 1785 | 282,802 | 22,241 | 28,954 | 5,038 | 1,312 | 19,623 | 57,293 | 2,811 | 58,445 | 3,806 | 21,240 |
| 1786 | 243,007 | 19,315 | 19,756 | 3,504 | 963 | 29,800 | 79,581 | 1,895 | 74,761 | 4,342 | 18,284 |
| 1787 | 330,866 | 16,175 | 23,606 | 3,599 | 850 | 31,106 | 69,804 | 1,294 | 101,859 | 4,289 | 22,898 |
| 1788 | 341,599 | 17,699 | 17,616 | 3,796 | 965 | 24,255 | 69,741 | 3,363 | 111,046 | 3,430 | 13,218 |
| 1789 | 314,876 | 16,501 | 23,005 | 3,529 | 370 | 15,347 | 49,035 | 6,362 | 93,336 | 3,526 | 13,128 |
| 1790 | 300,669 | 24,070 | 25,226 | 3,028 | 293 | 1,626 | 73,134 | 7,330 | 100,266 | 3,571 | 16,717 |
| 1791 | 295,875 | 30,132 | 17,750 | 4,063 | 187 | 4,178 | 70,240 | 5,814 | 95,467 | 3,360 | 18,624 |
| 1792 | 323,872 | 24,351 | 16,979 | 5,985 | 193 | 325[859](javascript:footNote('E900040/note859.html')) | 63,750 | 6,465 | 81,823 | 3,481 | 16,221 |
| 1793 | 311,960 | 21,820 | 22,841 | 4,482 | 129 | 197 | 57,857 | 5,425 | 119,012 | 3,322 | 9,522 |
| 1794 | 271,027 | 809 | 12,653 | 271,027 | 282 | 163 | 35,030 | 1,528 | 149,453 | 3,436 | 6,944 |
| 1795 | 276,403 | 5,160 | 12,626 | 5,992 | 233 | 4,000 | 38,546 | 1,051 | 129,922 | 4,327 | 14,352 |
| 1796 | 315,255 | 10,524 | 23,590 | 5,408 | 524 | 1,134 | 60,618 | 2,649 | 128,266 | 3,605 | 12,651 |
| 1797 | 322,218 | 36,311 | 21,855 | 5,032 | 441 | 278 | 55,488 | 9,402 | 142,294 | 2,437 | 11,854 |
| 1798 | 315,894 | 30,670 | 21,699 | 5,540 | 504 | 134 | 48,614 | 6,733 | 168,436 | 4,312 | 12,725 |
| 1799 | 262,764 | 9,331 | 19,014 | 7,828 | 177 | 3 | 79,509 | 2,577 | 139,268 | 4,672 | 13,839 |
| 1800 | 263,289 | 2,534 | 12,291 | 10,992 | 134 | 20 | 51,833 | 2,949 | 114,744 | 4,615 | 5,536 |








---

p.441





| Year ended Lady Day | Wheat exported: Barrels | Other corn exported: Barrels | Wheat imported: Barrels | Other corn imported: Barrels |
| --- | --- | --- | --- | --- |
| 1801 |  —  |  —  | 42,994 | 2.670 |
| 1802 |  —  | 202 | 17,849 | 3,771 |
| 1803 | 168,397 | 494,421 | 8,551 | 2,648 |
| 1804 | 101,901 | 428,553 | 5,374 | 15,008 |
| 1805 | 152,828 | 397,342 | 456 | 183,216 |
| 1806 | 134,871 | 385,161 | 1,283 | 2,265 |
| 1807 | 153,214 | 488,396 | 1,211 | 29,250 |
| 1808 | 68,003 | 800,357 | 9,145 | 1,968 |
| 1809 | 79,189 | 1,001,708 | 18,254 | 6,802 |
| 1810 | 137,157 | 1,135,102 | 12,197 | 7,810 |
| 1811 | 192,981 | 837,601 | 6,155 | 32,941 |
| 1812 | 363,063 | 753,786 | 3,016 | 64,095 |
| 1813 | 334,886 | 1,058,325 | 5,232 | 20,098 |
| 1814 | 327,763 | 1,603,003 | 3,363 | 29,204 |
| 1815 | 351,332 | 1,098,606 | 1,984 | 59,796 |
| 1816 | 338,801 | 1,092,994 | 3,335 | 7,680 |
| 1817 | 197,019 | 1,313,510 | 14,869 | 4,527 |
| 1818 | 90,538 | 1,068,764 | 65,502 | 119,140 |
| 1819 | 161,666 | 1,696,723 | 30,737 | 69,528 |
| 1820 | 224,725 | 1,296,313 | 5,107 | 6,073 |
| 1821 |  —  | 1,722,774 |  —  | 555 |
| 1822 | 776,775 | 1,948,717 | 110 | 493 |
| 1823 | 631,877 | 895,860 |  —  | 871 |









| Year ended March 25th | New Drapery: Yards | Old Drapery: Yards | Flannel: Yards | Frieze: Yards | Stockings: Pairs |
| --- | --- | --- | --- | --- | --- |
| 1801 | 5,301 | 550 | 2,000 |  —  | 9,940 |
| 1802 | 15,998 | 3,268 | 2,764 | 1,287 | 15,047 |
| 1803 | 27,563 | 1,726 | 1,478 | 1,890 | 7,267 |
| 1804 | 4,863 | 1,570 | 1,923 | 1,513 | 13,065 |
| 1805 | 21,635 | 938 | 2,322 | 267 | 69,110 |
| 1806 | 20,069 | 668 | 853 |  —  | 2,436 |
| 1807 | 28,067 | 1,663 | 2,050 | 146 | 2,850 |
| 1808 | 5,469 | 2,889 | 3,054 |  —  | 2,436 |
| p.442 |
| 1809 | 14,447 | 659 | 432 |  —  | 768 |
| 1810 | 1,442 | 1,032 | 4,616 |  —  | 9,951 |
| 1811 | 4,632 | 2,906 | 6,855 | 240 | 13,008 |
| 1812 | 863 | 6,596 | 1,148 | 100 | 7,800 |
| 1813 | 18,320 | 5,921 | 1,416 |  —  | 7,822 |
| 1814 | 31 | 401 | 1,753 | 1,715 | 9,182 |
| 1815 | 8,395 | 1,060 | 550 |  —  | 9,627 |
| 1816 | 9,733 | 10,121 | 8,828 |  —  | 34,863 |
| 1817 | 2,342 | 3,152 | 4,058 |  —  | 29,694 |
| 1818 | 2,874 | 2,382 | 704 |  —  | 23,662 |
| 1819 | 12,084 | 1,957 | 790 |  —  | 15,734 |
| 1820 | 33,142 | 786 | 60 |  —  | 3,678 |
| 1821 | 2,763 | 780 | 507 |  —  | 6,958 |
| 1822 | 1,092 | 929 | 64 |  —  | 12,300 |









| Year ended Jan 5th. | Plain Linen: Yards | Coloured Linen: Yards | Cambric and Lawn: Yards |
| --- | --- | --- | --- |
| 1802 | 37,767,077 | 142,853 | 1,672 |
| 1803 | 35,491,131 | 120,879 | 1,117 |
| 1804 | 37,432,365 | 137,489 | 71 |
| 1805 | 42,988,621 | 127,091 | 260 |
| 1806 | 43,534,971 | 148,562 |  —  |
| 1807 | 39,049,727 | 111,294 | 1,764 |
| 1808 | 40,901,442 | 152,424 | 837 |
| 1809 | 43,904,382 | 82,014 |  —  |
| 1810 | 37,061,859 | 103,180 | 1,360 |
| 1811 | 36,846,971 | 49,300 | 874 |
| 1812 | 31,392,845 | 32,626 | 1,416 |
| 1813 | 35,787,671 | 48,737 | 891 |
| 1814 | 38,994,381 | 28,661 | 45 |
| 1815 | 42,964,064 | 2,204 | 211 |
| 1816 | 43,383,732 | 7,688 |  —  |
| 1817 | 45,617,854 | 100,992 | 3 |
| 1818 | 56,084,495 | 119,855 | 96 |
| 1819 | 50,805,586 | 86,039 | 130 |
| 1820 | 37,464,279 | 18,345 |  —  |
| 1821 | 43,507,928 | 55,293 | 144 |
| 1822 | 49,414,775 | 34,031 | 6 |
| 1823 | 46,464,363 | 81,581 | 10,701 |









| Year ended Jan 5th. | Muslins: Yards | Cottons: £ | Plain Calicoes: Yards | Coloured Calicoes: Yards |
| --- | --- | --- | --- | --- |
| 1802 | 1,256 | None entered | None entered | None entered |
| 1803 | 948 | " | " | " |
| 1804 | 893 | " | " | " |
| 1805 | 20,004 | " | " | " |
| 1806 | 8,956 | " | " | " |
| 1807 | 31,149 | " | " | " |
| 1808 | 4,255 | " | " | " |
| 1809 | 193,236 | " | " | " |
| 1810 | 34,998 | " | " | " |
| 1811 | 56,631 | " | " | " |
| 1812 | 8,944 | " | " | " |
| 1813 | 130,306 | " | " | " |
| 1814 | 99,141 | " | " | " |
| 1815 | 57,640 | " | " | " |
| 1816 | 113,416 | 18,741 | 622,959 | 552,085 |
| 1817 | 191,896 | 15,138 | 416,650 | 1,092,696 |
| 1818 | 75,237 | 24,254 | 200,476 | 272,576 |
| 1819 | 60,467 | 8,630 | 47,663 | 263,754 |
| 1820 | 59,270 | 226 | 42,594 | 490,964 |
| 1821 | 176,846 | 2,701 | 84,569 | 514,334 |
| 1822 | 204,851 | 2,838 | 37,151 | 669,629 |
| 1823 | 253,533 | 6,918 | 197,084 | 673,109 |









| Year ended 25th March | Ware: £ | Drinking glasses: No. | Bottles: Doz. |
| --- | --- | --- | --- |
| 1801 | 6,718 | 226,312 | 6,020 |
| 1802 | 6,524 | 308,027 | 19,661 |
| 1803 | 4,261 | 173,998 | 42,894 |
| 1804 | 9,073 | 64,456 | 19,442 |
| 1805 | 7,902 | 115,740 | 14,447 |
| p.444 |
| 1806 | 7,735 | 131,024 | 22,665 |
| 1807 | 9,076 | 111,248 | 15,421 |
| 1808 | 10,389 | 36,832 | 8,006 |
| 1809 | 5,410 | 1,008 | 9,676 |
| 1810 | 16,124 | 377,198 | 15,236 |
| 1811 | 15,882 | 136,164 | 16,774 |
| 1812 | 4,196 | 4,800 | 8,319 |
| 1813 | 8,672 |  —  | 11,534 |
| 1814 | 8,918 | 1,954 | 4,549 |
| 1815 | 7,774 | 577 | 6,215 |
| 1816 | 27,962 | 4,320 | 8,683 |
| 1817 | 21,991 | 1,600 | 4,386 |
| 1818 | 20,651 |  —  | 8,596 |
| 1819 | 9,692 |  —  | 4,317 |
| 1820 | 11,128 |  —  | 5,373 |
| 1821 | 7,200 |  —  | 4,490 |
| 1822 | 6,099 |  —  | 6,644 |
| 1823 | 10,844 |  —  | 5,118 |


















