

#Ghost Stories of the Tiled House


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Ghost Stories of the Tiled House
================================


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 1. First draftExtent of text: 6700 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland.

 (2008) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E860000-005Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

*Ghost Stories of the Tiled House* was first published in 1861 in the *Dublin University Magazine*, as part of *The House in the Church-yard*.

#### Sources


**Editions**2. Joseph Sheridan Le Fanu, Madam Crowl's Ghost and other Tales of Mystery, collected and edited by M.R. James, London: G. Bell & Sons Limited, 1923.
3. Joseph Sheridan Le Fanu, Ghost Stories of the Tiled House, The collected works of Joseph Sheridan Le Fanu, 3 volumes; introduction by Sir Devendra P. Varma, New York: Arno Press 1977. [Facsimile reprint of 1871 edition.]
**Further reading**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October-November 1916) 30–33.
8. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
9. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
10. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
11. V.S. Pritchett, The living novel, London: Chatto and Windus 1946.
12. Elizabeth Bowen, Collected Impressions, London 1950.
13. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
14. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
15. A.B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
16. Peter Penzoldt, The Supernatural in Fiction, New York: Humanities Press 1952.
17. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
18. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
19. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
20. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
21. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
22. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
23. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
24. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
25. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
26. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
27. E.F. Beiler, 'Introduction' to J.S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
28. J.C. Beckett, The Anglo-Irish Tradition, London 1976.
29. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London: Faber 1977.
30. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Athens, Ohio: Ohio University Press 1978.
31. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
32. Joseph Browne, 'Ghosts and Ghouls and Le Fanu', Canadian Journal of Irish Studies 8 (1982) 5-15.
33. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
34. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
35. Jolanta Nalecz-Wojtczak, 'Joseph Sheridan Le Fanu and New Dimensions for the English Ghost Story', in: Wolfgang Zach and Heinz Kosok (eds.), Literary Interrelations: Ireland, England and the World, vol. 2, Tübingen: Günter Narr 1987.
36. Victor Sage, Horror Fiction in the Protestant Tradition, London: Macmillan 1988.
37. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
38. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
39. Marie Mulvey-Roberts (ed.), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
40. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
41. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
42. Michael Charlesworth (ed.), The Gothic revival, 1720–1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
43. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
44. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
45. James Walton, Vision and Vacancy: the Fictions of J. S. Le Fanu. Dublin, University College Dublin Press, 2007.
**The edition used in the digital edition**2. Best Ghost Stories of J. S. Le Fanu. Joseph Sheridan Le Fanu E. F. Bleiler (ed), Reprint [1 volume; xi + 467pp] Dover Publications, Inc. New York (1964)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 397–407.


#### Editorial Declaration


##### Correction


Text has been proofed twice at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors of the hardcopy edition are corrected silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from other languages are marked.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: 1861#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some phrases are in Latin.


### Revision History


* (2008-02-18) Beatrix Färber (ed)

* File proofed (2); file parsed; SGML and HTML file created.
* (2008-02-16) Beatrix Färber (ed)

* Header created; file proofed (1), structural and content markup added.
* (2008-02-16) Beatrix Färber (capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: E860000-005


### Ghost Stories of the Tiled House: Author: Joseph Sheridan Le Fanu




---

p.397


Ghost Stories of the Tiled House
--------------------------------


Old Sally always attended her young mistress while she prepared for bed—not that Lilias required help, for she had the spirit of neatness and a joyous, gentle alacrity, and only troubled the good old creature enough to prevent her thinking herself grown old and useless.


Sally, in her quiet way, was garrulous, and she had all sorts of old-world tales of wonder and adventure, to which Lilias often went pleasantly to sleep; for there was no danger while old Sally sat knitting there by the fire, and the sound of the rector's mounting upon his chairs, as was his wont, and taking down and putting up his books in the study beneath, though muffled and faint, gave evidence that that good and loving influence was awake and busy.


Old Sally was telling her young mistress, who sometimes listened with a smile, and sometimes lost a good five minutes together of her gentle prattle, how the young gentleman, Mr. Mervyn, had taken that awful old haunted habitation, the Tiled House ‘beyant at Ballyfermot,’ and was going to stay there, and wondered no one had told him of the mysterious dangers of that desolate mansion.


It stood by a lonely bend of the narrow road. Lilias had often looked upon the short, straight, grass-grown avenue with an awful curiosity at the old house which she had learned in childhood to fear as the abode of shadowy tenants and unearthly dangers.


‘There are people, Sally, nowadays, who call themselves free-thinkers, and don't believe in anything—even in ghosts,’ said Lilias.


‘A then the place he's stopping in now, Miss Lily, 'ill soon cure him of free-thinking, if the half they say about it's true,’ answered Sally.




---

p.398


‘But I don't say, mind, *he*'s a free-thinker, for I don't know any thing of Mr. Mervyn; but if he be not, he must be very brave, or very good, indeed. I know, Sally, I should be horribly afraid, indeed, to sleep in it myself,’ answered Lilias, with a cosey little shudder, as the aërial image of the old house for a moment stood before her, with its peculiar malign, sacred, and skulking aspect, as if it had drawn back in shame and guilt among the melancholy old elms and tall hemlock and nettles.


‘And now, Sally, I'm safe in bed. Stir the fire, my old darling.’ For although it was the first week in May, the night was frosty. ‘And tell me all about the Tiled House again, and frighten me out of my wits.’


So good old Sally, whose faith in such matters was a religion, went off over the well-known ground in a gentle little amble—sometimes subsiding into a walk as she approached some special horror, and pulling up altogether—that is to say, suspending her knitting, and looking with a mysterious nod at her young mistress in the four-poster, or lowering her voice to a sort of whisper when the crisis came.


So she told her how when the neighbours hired the orchard that ran up to the windows at the back of the house, the dogs they kept there used to howl so wildly and wolfishly all night among the trees, and prowl under the walls of the house so dejectedly, that they were fain to open the door and let them in at last; and, indeed, small need was there for dogs; for no one, young or old, dared go near the orchard after night-fall. No, the golden pippins that peeped so splendid through the leaves in the western rays of evening, and made the mouths of the Ballyfermot schoolboys water, glowed undisturbed in the morning sunbeams, and secure in the mysterious tutelage of the night smiled coyly on their predatory longings. And this was no fanciful reserve and avoidance. Mick Daly, when he had the orchard, used to sleep in the loft over the kitchen; and he swore that within five or six weeks, while he lodged there, he twice saw the same thing, and that was a lady in a hood and a loose dress, her head drooping, and her finger on her lip, walking in silence among the crooked stems, with a little child by the hand, who ran smiling and skipping beside her. And the Widow Cresswell once met them at night-fall, on the path through the orchard to the back-door, and she did not know what it was until she saw the men looking at one another as she told it.


‘It's often she told it to me,’ said old Sally; ‘and how she came on them all of a sudden at the turn of the path, just by the thick clump of alder trees; and how she stopped, thinking it was some



---

p.399



 lady that had a right to be there; and how they went by as swift as the shadow of a cloud, though she only seemed to be walking slow enough, and the little child pulling by her arm, this way and that way, and took no notice of her, nor even raised her head, though she stopped and courtesied. And old Clinton, don't you remember old Clinton, Miss Lily?’


‘I think I do, the old man who limped, and wore the old black wig?’


‘Yes, indeed, acushla, so he did. See how well she remembers! That was by a kick of one of the earl's horses—he was groom then,’ resumed Sally. ‘He used to be troubled with hearing the very sounds his master used to make to bring him and old Oliver to the door, when he came back late. It was only on very dark nights when there was no moon. They used to hear all on a sudden, the whimpering and scraping of dogs at the hall door, and the sound of the whistle, and the light stroke across the window with the lash of the whip, just like as if the earl himself—may his poor soul find rest—was there. First the wind 'id stop, like you'd be holding your breath, then came these sounds they knew so well, and when they made no sign of stirring or opening the door, the wind 'id begin again with such a hoo-hoo-o-o-high, you'd think it was laughing, and crying, and hooting all at once.’


Here old Sally resumed her knitting, suspended for a moment, as if she were listening to the wind outside the haunted precincts of the Tiled House; and she took up her parable again.


‘The very night he met his death in London, old Oliver, the butler, was listening to Clinton—for Clinton was a scholar—reading the letter that came to him through the post that day, telling him to get things ready, for his troubles were nearly over, and he expected to be with them again in a few days, and maybe almost as soon as the letter; and sure enough, while he was reading, there came a frightful rattle to the window, like some one all in a tremble, trying to shake it open, and the earl's voice, as they both conceited, cries from outside, ‘Let me in, let me in, let me in!’ ‘It's him,’ says the butler. ‘'Tis so, bedad,’ says Clinton, and they both looked at the windy, and at one another—and then back again—overjoyed and frightened all at onst. Old Oliver was bad with the rheumatiz in his knee, and went lame like. So away goes Clinton to the hall-door, and he calls, who's there? and no answer. Maybe, says Clinton, to himself, 'tis what he's rid round to the back-door; so to the back-door with him, and there he shouts again—and no answer, and not a sound outside—and he began to feel quare, and to the hall door with him back again. ‘Who's there? 



---

p.400



do you hear, who's there?’ he shouts, and receiving no answer still. ‘I'll open the door at any rate,’ says he, ‘maybe it's what he's made his escape,’ for they knew all about his troubles, ‘and wants to get in without noise,’ so praying all the time—for his mind misgave him, it might not be all right—he shifts the bars and unlocks the door; but neither man, woman, nor child, nor horse, nor any living shape was standing there, only something or another slipt into the house close by his leg; it might be a dog, or something that way, he could not tell, for he only seen it for a moment with the corner of his eye, and it went in just like as if it belonged to the place. He could not see which way it went, up or down, but the house was never a happy one, or a quiet house after; and Clinton bangs the hall-door, and he took a sort of a turn and a trembling, and back with him to Oliver, the butler, looking as white as the blank leaf of his master's letter that was fluttering between his finger and thumb. ‘What is it? *what* is it?’ says the butler, catching his crutch like a waypon, fastening his eyes on Clinton's white face, and growing almost as pale himself. ‘The master's dead,’ says Clinton—and so he was, signs on it.’


‘After the turn she got by what she seen in the orchard, when she came to know the truth of what it was, Jinny Cresswell, you may be sure, did not stay there an hour longer than she could help; and she began to take notice of things she did not mind before—such as when she went into the big bed-room over the hall that the lord used to sleep in, whenever she went in at one door the other door used to be pulled to very quick, as if some one avoiding her was getting out in haste; but the thing that frightened her most was just this—that sometimes she used to find a long, straight mark from the head to the foot of her bed, as if 'twas made by something heavy lying there, and the place where it was used to feel warm—as if—whoever it was—they only left it as she came into the room.’


‘But the worst of all was poor Kitty Haplin, the young woman that died of what she seen. Her mother said it was how she was kept awake all the night with the walking about of some one in the next room, tumbling about boxes and pulling over drawers and talking and sighing to himself, and she, poor thing, wishing to go asleep and wondering who it could be, when in he comes, a fine man, in a sort of loose silk morning-dress, an' no wig, but a velvet cap on, and to the windy with him quiet and aisy, and she makes a turn in the bed to let him know there was some one there, thinking he'd go away, but instead of that, over he comes to the side of the bed, looking very bad, and says something to her—but his speech was thick and queer, like a dummy's that id be trying to 



---

p.401



spake—and she grew very frightened, and says she, ‘I ask your honour's pardon, Sir, but I can't hear you right,’ and with that he stretches up his neck nigh out of his cravat, turning his face up towards the ceiling, and—grace between us and harm!—his throat was cut across like another mouth, wide open, laughing at her; she seen no more, but dropped in a dead faint in the bed, and back to her mother with her in the morning, and she never swallied bit or sup more, only she just sat by the fire holding her mother's hand, crying and trembling, and peepin' over her shoulder, and starting with every sound, till she took the fever and died, poor thing, not five weeks after.’—


And so on, and on, and on flowed the stream of old Sally's narrative, while Lilias dropped into dreamless sleep, and then the story-teller stole away to her own tidy bed-room and innocent slumbers.


I'm sure she believed every word she related, for old Sally was veracious. But all this was worth just so much as such talk commonly is—marvels, fabulae, what our ancestors called winter's tales—which gathered details from every narrator and dilated in the act of narration. Still it was not quite for nothing that the house was held to be haunted. Under all this smoke there smouldered just a little spark of truth—an authenticated mystery, for the solution of which some of my readers may possibly suggest a theory, though I confess I can't.


Miss Rebecca Chattesworth, in a letter dated late in the autumn of 1753, gives a minute and curious relation of occurrences in the Tiled House, which, it is plain, although at starting she protests against all such fooleries, she has heard with a peculiar sort of interest, and relates it certainly with an awful sort of particularity.


I was for printing the entire letter, which is really very singular as well as characteristic. But my publisher meets me with his *veto*; and I believe he is right. The worthy old lady's letter *is*, perhaps, too long; and I must rest content with a few hungry notes of its tenor.


That year, and somewhere about the 24th October, there broke out a strange dispute between Mr. Alderman Harper, of High Street, Dublin, and my Lord Castlemallard, who, in virtue of his cousinship to the young heir's mother, had undertaken for him the management of the tiny estate on which the Tiled or Tyled House—for I find it spelt both ways—stood.




---

p.402


This Alderman Harper had agreed for a lease of the house for his daughter, who was married to a gentleman named Prosser. He furnished it and put up hangings, and otherwise went to considerable expense. Mr. and Mrs. Prosser came there some time in June, and after having parted with a good many servants in the interval, she made up her mind that she could not live in the house, and her father waited on Lord Castlemallard and told him plainly that he would not take out the lease because the house was subjected to annoyances which he could not explain. In plain terms, he said it was haunted, and that no servants would live there more than a few weeks, and that after what his son-in-law's family had suffered there, not only should he be excused from taking a lease of it, but that the house itself ought to be pulled down as a nuisance and the habitual haunt of something worse than human malefactors.


Lord Castlemallard filed a bill in the Equity side of the Exchequer to compel Mr. Alderman Harper to perform his contract, by taking out the lease. But the Alderman drew an answer, supported by no less than seven long affidavits, copies of all which were furnished to his lordship, and with the desired effect; for rather than compel him to place them upon the file of the court, his lordship struck, and consented to release him.


I am sorry the cause did not proceed at least far enough to place upon the records of the court the very authentic and unaccountable story which Miss Rebecca relates.


The annoyances described did not begin till the end of August, when, one evening, Mrs. Prosser, quite alone, was sitting in the twilight at the back parlour window, which was open, looking out into the orchard, and plainly saw a hand stealthily placed upon the stone window-sill outside, as if by some one beneath the window, at her right side, intending to climb up. There was nothing but the hand, which was rather short, but handsomely formed, and white and plump, laid on the edge of the window-sill; and it was not a very young hand, but one aged, somewhere about forty, as she conjectured. It was only a few weeks before that the horrible robbery at Clondalkin had taken place, and the lady fancied that the hand was that of one of the miscreants who was now about to scale the windows of the Tiled House. She uttered a loud scream and an ejaculation of terror, and at the same moment the hand was quietly withdrawn.


Search was made in the orchard, but no indications of any person's having been under the window, beneath which, ranged along the wall, stood a great column of flower-pots, which it seemed must have prevented any one's coming within reach of it.




---

p.403


The same night there came a hasty tapping, every now and then, at the window of the kitchen. The women grew frightened, and the servant-man, taking firearms with him, opened the back-door, but discovered nothing. As he shut it, however, he said, ‘a thump came on it,’ and a pressure as of somebody striving to force his way in, which frightened *him*; and though the tapping went on upon the kitchen window panes, he made no further explorations.


About six o'clock on the Saturday evening following, the cook, ‘an honest, sober woman, now aged nigh sixty years,’ being alone in the kitchen, saw, on looking up, it is supposed, the same fat but aristocratic-looking hand laid with its palm against the glass, near the side of the window, and this time moving slowly up and down, pressed all the while against the glass, as if feeling carefully for some inequality in its surface. She cried out, and said something like a prayer, on seeing it. But it was not withdrawn for several seconds after.


After this, for a great many nights, there came at first a low, and afterwards an angry rapping, as it seemed with a set of clenched knuckles at the back-door. And the servant-man would not open it, but called to know who was there; and there came no answer, only a sound as if the palm of the hand was placed against it, and drawn slowly from side to side with a sort of soft, groping motion.


All this time, sitting in the back parlour, which, for the time, they used as a drawing-room, Mr. and Mrs. Prosser were disturbed by rappings at the window, sometimes very low and furtive, like a clandestine signal, and at others sudden and so loud as to threaten the breaking of the pane.


This was all at the back of the house, which looked upon the orchard, as you know. But on a Tuesday night, at about half-past nine, there came precisely the same rapping at the hall-door, and went on, to the great annoyance of the master and terror of his wife, at intervals, for nearly two hours.


After this, for several days and nights, they had no annoyance whatsoever, and began to think that nuisance had expended itself. But on the night of the 13th September, Jane Easterbrook, an English maid, having gone into the pantry for the small silver bowl in which her mistress's posset was served, happening to look up at the little window of only four panes, observed through an auger-hole which was drilled through the window-frame, for the admission of a bolt to secure the shutter, a white pudgy finger—first the tip, and then the two first joints introduced, and turned about this way and that, crooked against the inside, as if in search of a fastening which its owner designed to push aside. When the



---

p.404



 maid got back into the kitchen we are told ‘she fell into ‘a swounde,’ and was all the next day very weak.’


Mr. Prosser being, I've heard, a hard-headed and conceited sort of fellow, scouted the ghost, and sneered at the fears of his family. He was privately of opinion that the whole affair was a practical joke or a fraud, and waited an opportunity of catching the rogue flagrante delicto. He did not long keep this theory to himself, but let it out by degrees with no stint of oaths and threats, believing that some domestic traitor held the thread of the conspiracy.


Indeed it was time something were done; for not only his servants, but good Mrs. Prosser herself, had grown to look unhappy and anxious, and kept at home from the hour of sunset, and would not venture about the house after night-fall, except in couples.


The knocking had ceased for about a week; and one night, Mrs. Prosser being in the nursery, her husband, who was in the parlour, heard it begin very softly at the hall-door. The air was quite still, which favoured his hearing distinctly. This was the first time there had been any disturbance at that side of the house, and the character of the summons also was changed.


Mr. Prosser, leaving the parlour-door open, it seems, went quietly into the hall. The sound was that of beating on the outside of the stout door, softly and regularly, ‘with the flat of the hand.’ He was going to open it suddenly, but changed his mind; and went back very quietly, and on to the head of the kitchen stair, where was a ‘strong closet’ over the pantry, in which he kept his firearms, swords, and canes.


Here he called his man-servant, whom he believed to be honest; and with a pair of loaded pistols in his own coat-pockets, and giving another pair to him, he went as lightly as he could, followed by the man, and with a stout walking-cane in his hand, forward to the door.


Everything went as Mr. Prosser wished. The besieger of his house, so far from taking fright at their approach, grew more impatient; and the sort of patting which had aroused his attention at first, assumed the rhythm and emphasis of a series of double-knocks.


Mr. Prosser, angry, opened the door with his right arm across, cane in hand. Looking, he saw nothing; but his arm was jerked up oddly, as it might be with the hollow of a hand, and something passed under it, with a kind of gentle squeeze. The servant neither saw nor felt anything, and did not know why his master looked back so hastily, cutting with his cane, and shutting the door with so sudden a slam.


From that time Mr. Prosser discontinued his angry talk and



---

p.405



 swearing about it, and seemed nearly as averse from the subject as the rest of his family. He grew, in fact, very uncomfortable, feeling an inward persuasion that when, in answer to the summons, he had opened the hall-door, he had actually given admission to the besieger.


He said nothing to Mrs. Prosser, but went up earlier to his bed-room, ‘where he read a while in his Bible, and said his prayers.’ I hope the particular relation of this circumstance does not indicate its singularity. He lay awake a good while, it appears; and as he supposed, about a quarter past twelve he heard the soft palm of a hand patting on the outside of the bed-room door, and then brushed slowly along it.


Up bounced Mr. Prosser, very much frightened, and locked the door, crying, ‘Who's there?’ but receiving no answer but the same brushing sound of a soft hand drawn over the panels, which he knew only too well.


In the morning the housemaid was terrified by the impression of a hand in the dust of the ‘little parlour’ table, where they had been unpacking delft and other things the day before. The print of the naked foot in the sea-sand did not frighten Robinson Crusoe half so much. They were by this time all nervous, and some of them half crazed, about the hand.


Mr. Prosser went to examine the mark, and made light of it, but, as he swore afterwards, rather to quiet his servants than from any comfortable feeling about it in his own mind; however, he had them all, one by one, into the room, and made each place his or her hand, palm downward, on the same table, thus taking a similar impression from every person in the house, including himself and his wife; and his ‘affidavit’ deposed that the formation of the hand so impressed differed altogether from those of the living inhabitants of the house, and corresponded exactly with that of the hand seen by Mrs. Prosser and by the cook.


Whoever or whatever the owner of that hand might be, they all felt this subtle demonstration to mean that it was declared he was no longer out of doors, but had established himself in the house.


And now Mrs. Prosser began to be troubled with strange and horrible dreams, some of which, as set out in detail, in Aunt Rebecca's long letter, are really very appalling nightmares. But one night, as Mr. Prosser closed his bedchamber door, he was struck somewhat by the utter silence of the room, there being no sound of breathing, which seemed unaccountable to him, as he knew his wife was in bed, and his ears were particularly sharp.


There was a candle burning on a small table at the foot of the 



---

p.406



bed, beside the one he held in one hand, a heavy ledger connected with his father-in-law's business being under his arm. He drew the curtain at the side of the bed, and saw Mrs. Prosser lying, as for a few seconds he mortally feared, dead, her face being motionless, white, and covered with a cold dew; and on the pillow, close beside her head, and just within the curtains, was the same white, fattish hand, the wrist resting on the pillow, and the fingers extended towards her temple with a slow, wavy motion.


Mr. Prosser, with a horrified jerk, pitched the leger right at the curtains behind which the owner of the hand might be supposed to stand. The hand was instantaneously and smoothly snatched away, the curtains made a great wave, and Mr. Prosser got round the bed in time to see the closet-door, which was at the other side, drawn close by the same white, puffy hand, as he believed.


He drew the door open with a fling, and stared in; but the closet was empty, except for the clothes hanging from the pegs on the wall, and the dressing-table and looking-glass facing the windows. He shut it sharply, and locked it, and felt for a minute, he says, ‘as if he were like to lose his wits;’ then, ringing at the bell, he brought the servants, and with much ado they recovered Mrs. Prosser from a sort of ‘trance,’ in which, he says, from her looks, she seemed to have suffered ‘the pains of death;’ and Aunt Rebecca adds, ‘from what she told me of her visions, with her own lips, he might have added, ‘and of hell also.’’


But the occurrence which seems to have determined the crisis was the strange sickness of their eldest child, a little girl aged between two and three years. It lay awake, seemingly in paroxysms of terror, and the doctors who were called in set down the symptoms to incipient water on the brain. Mrs. Prosser used to sit up with the nurse, by the nursery fire, much troubled in mind about the condition of her child.


Its bed was placed sideways along the wall, with its head against the door of a press or cupboard, which, however, did not shut quite close. There was a little valance, about a foot deep, round the top of the child's bed, and this descended within some ten or twelve inches of the pillow on which it lay.


They observed that the little creature was quieter whenever they took it up and held it on their laps. They had just replaced it, as it seemed to have grown quite sleepy and tranquil, but he was not five minutes in its bed when it began to scream in one of his frenzies of terror; at the same moment the nurse for the first time detected, and Mrs. Prosser equally plainly saw, following the direction of her eyes, the real cause of the child's sufferings.




---

p.407


Protruding through the aperture of the press, and shrouded in the shade of the valance, they plainly saw the white fat hand, palm downwards, presented towards the head of the child. The mother uttered a scream, and snatched the child from its little bed, and she and the nurse ran down to the lady's sleeping-room, where Mr. Prosser was in bed, shutting the door as they entered; and they had hardly done so, when a gentle tap came to it from the outside.


There is a great deal more, but this will suffice. The singularity of the narrative seems to me to be this, that it describes the ghost of a hand, and no more. The person to whom that hand belonged never once appeared; nor was it a hand separated from a body, but only a hand so manifested and introduced, that its owner was always, by some crafty accident, hidden from view.


In the year 1819, at a college breakfast, I met a Mr. Prosser—a thin, grave, but rather chatty old gentleman, with very white hair, drawn back into a pigtail—and he told us all, with a concise particularity, a story of his cousin, James Prosser, who, when an infant, had slept for some time in what his mother said was a haunted nursery in an old house near Chapelizod, and who, whenever he was ill, over-fatigued, or in anywise feverish, suffered all through his life as he had done from a time he could scarce remember, from a vision of a certain gentleman, fat and pale, every curl of whose wig, every button and fold of whose laced clothes, and every feature and line of whose sensual, malignant [1](javascript:footNote('E860000-005/note001.html')), and unwholesome face, was as minutely engraven upon his memory as the dress and lineaments of his own father's portrait, which hung before him every day at breakfast, dinner, and supper.


Mr. Prosser mentioned this as an instance of a curiously monotonous, individualized, and persistent nightmare, and hinted the extreme horror and anxiety with which his cousin, of whom he spoke in the past tense as ‘poor Jemmie,’ was at any time induced to mention it.


I hope the reader will pardon me for loitering so long in the Tiled House, but this sort of lore has always had a charm for me; and people, you know, especially old people, will talk of what most interests themselves, too often forgetting that others may have had more than enough of it.














