

#Diary of a Tour in 1732 through parts of England, Wales, Ireland and Scotland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Diary of a Tour in 1732 through parts of England, Wales, Ireland and Scotland
=============================================================================


Author: John Loveday
--------------------


### File Description

John Edward Taylor LovedayElectronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber

Funded by University College, Cork, School of History 1. First draft.Extent of text: 18125 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E730002-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

CELT is indebted to C. J. Woods, formerly of the R.I.A., for drawing our attention to these documents in 2012. I am also grateful to John and Francis Markham, descendants of John Loveday, who maintain the website http://www.johnlovedayofcaversham.co.uk/index.htm, for kindly making material available to me. I would like to thank Henry O'Keeffe for information about Bishopstown (today a Cork City suburb) and the former Bishop's residence there Loveday mentions p. 38.

#### Sources


**Manuscript source**2. The manuscript is in private possession of the Loveday family. In 1969, Pennsylvania State Library acquired over 2000 items from this Library. See http://www.libraries.psu.edu/psul/speccolls/rbm/williamscote.html.
**Edition**2. See below.
**About John Loveday**2. See the article by Sarah Markham s.v. John Loveday, in the Oxford DNB (http://www.oxforddnb.com/view/article/17046).
3. Sarah Markham, John Loveday of Caversham, 1711–1789 (1984).
4. Information about John Loveday's other tours is available at http://www.johnlovedayofcaversham.co.uk/index.htm – and the tours themselves have been prepared in .pdf format, with introduction and personal names index, by Francis and John Markham. They are based on transcriptions by Sarah Markham. (I am grateful to John Markham for making available this material to me for identifying persons mentioned by John Loveday.)
**Internet resources**2. Connacht and Munster Landed Estates Database at NUI Galway: http://landedestates.nuigalway.ie/LandedEstates/jsp/index.jsp
3. Images of old maps of Cork available from Cork City Library: http://www.corkpastandpresent.ie/mapsimages/corkcityinoldmaps/
**Literature (including works mentioned by John Loveday)**2. William Camden, Remaines of a greater worke, concerning Britaine, the inhabitants thereof, their languages, names, surnames, empreses, wise speeches, poësies and epitaphes (London 1605).
3. Thomas Dempster, Menologium Scotorum (...) colligit publicat et inscribit (...) Thomas Dempsterus baro de Muresk (...) typis N. Tebaldini, 1622.
4. Gerard Boate, Ireland's Naturall History (London: Chetham Society 1652.) Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan (New York 2006).
5. Peter Heylyn [Heylin], Cyprianus Anglicus: or, the history of the life and death, of the most reverend and renowned prelate William by divine providence, Lord Archbishop of Canterbury (London 1671).
6. Edmund Borlase, The reduction of Ireland to the crown of England: With the governours since the conquest by King Henry II. Anno MCLXXII. With some passages in their government. A brief account of the rebellion anno Dom. MDCXLI. Also, the original of the University of Dublin, and the Colledge of physicians. (London: Printed by Andr. Clarke for Robert Clavel 1675).
7. John Ray, A collection of English words not generally used: with their significations and original, in two alphabetical catalogues, the one of such as are proper to the northern, the other to the southern counties: with an account of the preparing and refining such metals and minerals as are gotten in England. The second edition, augmented with many hundreds of words, observations, letters, &c. (London: Printed for Christopher Wilkinson, at the Black Boy over against S. Dunstan's church in Fleetstreet, 1691).
8. Sir James Ware, Antiquities and History of Ireland, edited by Walter Harris (London/Dublin 1705).
9. John Ray, A collection of curious travels and voyages in two parts: the first containing Dr. Leonhart Rauwolff's itinerary into the eastern countries, as Syria, Palestine, or the Holy Land, Armenia, Mesopotamia, Assyria, Chaldea, &c., translated from the high Dutch by Nicholas Staphorst: the second taking in many parts of Greece, Asia Minor, Egypt, Arabia Felix, and Petraea, Ethiopia, the Red-Sea, &c., from the observations of Mons. Belon (...) and others (...), 2nd ed. corr. and improved. (London: S. Smith and B. Walford, 1705).
10. Edward Lhuyd, Archaeologia Britannica, giving some account additional to what has hitherto been publish'd, of the languages, histories, and customs of the original inhabitants of Great Britain: from collections and observations in travels through Wales, Cornwal, Bas-Bretagne, Ireland and Scotland; vol. 1: Glossography, (containing, among other things a grammar and a vocabulary of Irish) (Oxford 1707).
11. John Kettlewell, A compleat collection of the works of (...) John Kettlewell. To which is prefix'd the life of the author (London 1719).
12. Jonathan Swift, Miscellaneous Works, comical and diverting: by T[he] R[everend] D[octor] J[onathan] S[wift] D[ean] O[f Saint] P[atrick's] I[n] I[reland], in two parts. I. The Tale of a Tub; with the Fragment, & the Battel of the Books; with considerable additions ... II. Miscellanies in prose and verse, by the supposed author of the first part (London 1720).
13. John Stevens [Stephens], Monasticon Hibernicum; or the monastical History of Ireland (London 1722). [Published anonymously.]
14. Edmund Gibson (ed), Britannia: or a chorographical description of Great Britain and Ireland, together with the adjacent islands. Written in Latin by William Camden, (...) And translated into English, with additions and improvements. (...) (1722).
15. Adam Littleton, Linguae Latinae liber dictionarius quadripartitus: Dr. Adam Littleton's Latin dictionary, in four parts: I. An English-Latin. II. A Latin-classical. III. A Latin-proper. IV. A Latin-barbarous. The fifth edition: improved from the several works of Stephens, Cooper, Holyoke, and a large MS. in three volumes of John Milton, &c. (...) (London 1723).
16. Henry Rowlands, Mona antiqua restaurata: an archaeological discourse on the antiquities, natural and historical, of the Isle of Anglesey, the antient seat of the British druids (Dublin: Robert Owen, 1723).
17. Thomas Sharp, The Necessary Knowledge of the Lord's Supper (1727).
18. Thomas Hearne, Liber Niger Scaccarii, Wilhelmique etiam Worcestrii Annales Rerum Anglicarum (Oxonii [Oxford] 1728).
19. Peter Browne, Procedure, Extent, and Limits of the Human Understanding (1728).
20. Thomas Sharp, Enquiry about the Lawfulness of Eating Blood (London 1733).
21. Peter Browne, Things Divine and Supernatural conceived by Analogy with Things Natural and Human, more briefly referred to as the Divine Analogy (1733).
22. John Ward, The Lives of the Professors of Gresham College: to which is prefixed the Life of the founder, Sir T. Gresham. With an appendix, consisting of Lectures and Letters, by the Professors, with other Papers (London 1740).
23. Walter Harris (ed), Hibernica: or, some antient pieces relating to Ireland (Dublin 1747–1750).
24. George Berkeley, A miscellany, containing several tracts on various subjects (London 1752).
25. J. Noble and J. Keenan, The County of Kildare (Dublin 1752).
26. Samuel Brewster, Collectanea Ecclesiastica: being a collection of very curious treatises in manuscript, relating to the rights of the clergy of the Church of England, and especially of those who are beneficed in London (London:William Russel 1752).
27. Hugh Boulter, Letters written by (...) Hugh Boulter (...) to several ministers of state, edited by A. Philips and G. Faulkner, 2 vols. (1769–70).
28. Thomas Pennant, A Tour in Scotland, and a voyage to the Hebrides, 1772 (Chester 1774).
29. Thomas Pennant, A Tour in Scotland, 1772 (London 1776).
30. Thomas Park (ed), Nugæ Antiquæ: Being a Miscellaneous Collection of Original Papers, in Prose and Verse; Written during the Reigns of Henry VIII. Edward VI. Queen Mary, Elizabeth, and King James, selected by Henry Harington, 2 vols. (London 1804).
31. John Nichols, Literary anecdotes of the eighteenth century: comprizing biographical memoirs of William Bowyer, Printer, F. S. A. and many of his learned friends (. . .), 9 volumes (London 1812–1816).
32. John Nichols, Illustrations of the literary history of the eighteenth century: Consisting of authentic memoirs and original letters of eminent persons; and intended as a sequel to the Literary anecdotes, 8 vols. (London 1817–1858).
33. Samuel Lewis, A Topographical Dictionary of Ireland, comprising the several counties, cities, boroughs, corporate, market, and post towns. Parishes, and villages, with historical and statistical descriptions (...) (London 1837). [Available online at http://www.libraryireland.com/topog/index.php].
34. Henry Cotton, Fasti Ecclesiae Hibernicae: the succession of the prelates and members of the Cathedral bodies of Ireland. 5 volumes (2nd ed., corrected and enlarged [v.1, 1851] (Dublin: Printed for the Author; published by Hodges and Smith, 1848–1860). ["No more of second edition published after volume 1. V. 1: Munster; 2: Leinster; 3: Ulster;4: Connaught; 5: illustrations, corrections, and additions to which are added general indexes to the whole work, by John Ribton Garstin."]
35. M. T. Lewis (ed), Extracts of the journals and correspondence of Miss Berry, 3 vols. (London 1865; repr. 1971).
36. Richard Pococke, A Tour in Ireland in 1752; ed. by George T. Stokes, as 'Bishop Pococke's tour in Ireland in 1752' (Dublin and London 1891). Available online at CELT.
37. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastiscal division thereof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same (. . .) (Dublin 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the MSS. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W. A. Copinger (Cork 1893–1894).
38. T. U. Sadleir, 'Loveday's tour in Kildare in 1732', Kildare Archaeological Society Journal 7 (1912–14) 168–177.
39. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
40. Stanley G. Mendyk, 'Gerard Boate and 'Irelands Naturall History', *Journal of the Royal Society of Antiquaries of Ireland* 115 (1985), 5–12.
41. Peter Harbison (ed), Beranger's views of Ireland, edited with text by Peter Harbison (Dublin: RIA 1991). [Paintings of some of the views described by Loveday].
42. Arlene Hogan, Kilmallock Dominican Priory: an architectural perspective, 1291-1991 (Kilmallock: Kilmallock Historical Society 1991).
43. John McVeagh (ed.), Irish Travel Writing. A Bibliography (Dublin 1996).
44. Anna-Maria Hajba, Historical genealogical architectural notes on some houses of Cork, with line drawings by Michael O'Sullivan and a foreword by Peter Pearson (Whitegate, Co. Clare: 2002). [Information about various of the houses mentioned in the diary, especially Annabel House in Mallow.]
45. C. J. Woods, Travellers' accounts as source-material for Irish historians (Dublin 2009), no. 13.
**The edition used in the digital edition**2. Diary of a Tour in 1732, through parts of England, Wales, Ireland and Scotland, made by John Loveday of Caversham, and now for the first time printed from a manuscript in the possession of his great-grandson John Edward Taylor Loveday, with an Introduction and an Itinerary. John Loveday First edition [1 volume; xiv + 227 pp, appendix with itinerary on pp iii-ix.] 75 copies privately printed for the Roxburghe ClubEdinburgh (1890)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages ix–xiv; 27–60 of the volume, including the editor's Introduction and Loveday's sections about Ireland. The entire Tour through Wales, Ireland and Scotland described in the book lasted eighteen weeks. Loveday was accompanied by John Peareth.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


The electronic text represents the edited text. Text supplied by the author is marked sup resp="JL"; his footnotes are retained and numbered in sequence. Loveday was in Ireland again in summer 1733 and added a number of annotations to his 1732 observations. A small number of emendations, notes and text was added at CELT and marked resp="BF". Loveday's spelling and irregular capitalisation has, in the main, been left as it is; however, all his abbreviations, painstakingly rendered in the printed edition, often using superscript letters, have been expanded silently, except for ye. In Welsh place-names, at the beginning of the section made available here, initial LL- has been replaced with Ll- in line with modern usage. Words and phrases in languages other than English are tagged; so are dates. Titles of referenced works, as well as the more important personal and place-names are encoded.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the diary; div1=the individual entry. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Dates are tagged.


#### Canonical References


This text uses the DIV1 element to represent the Entry. ### Profile Description


Created: John Loveday (1711–1789)
 Date range: 30 May to 2 July 1732.#### Use of language


##### Language: [EN] The text is in eighteenth-century English.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] Some words in the notes are in French.


##### Language: [CY] Some words in the notes are in Welsh.


##### Language: [AS] One word is in Anglo-Saxon.


##### Language: [GA] Some Irish words are retained in anglicized spelling.


### Revision History


* (2014-06-30) Beatrix Färber (ed.)

* Final changes and additions made, remaining people identified using John and Francis Markham's personal names index. File re-parsed and validated; SGML and HTML files created.
* (2014-06-26) Beatrix Färber (ed.)

* File proofed (2). More individuals identified and tagged; addition made to notes and bibliographic detail.
* (2014-06-23) Beatrix Färber (ed.)

* Proofing (1), structural and content encoding completed, including dates, references, names of people and places; bibliographic detail added. File parsed and validated.
* (2014-06-12) Beatrix Färber (ed.)

* Header created; file converted to XML; proofing (1) begun.
* (2014-06-12) Beatrix Färber (file capture)

* Introduction captured by scanning.
* (2014-06-11; 2014-06-13) Beatrix Färber (file capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E730002-001


### Diary of a Tour in 1732 through parts of England, Wales, Ireland and Scotland: Author: John Loveday




---

p.ix


### Introduction


 The Diary of a Tour in 1732 is printed word for word and letter for letter from the original manuscript,[1](javascript:footNote('E730002-001/note001.html')) which is in the handwriting of the Author, **John Loveday** of Caversham in the County of Oxford, and Feenes Manor in the County of Berks.


He was born in 1711, and was the only son of Thomas Loveday, of Caversham and Feenes, by his wife Sarah, daughter of William Lethieullier,[2](javascript:footNote('E730002-001/note002.html')) a wealthy Turkey merchant.


He entered Magdalen College, Oxford, as a gentleman commoner, 13th Feb. 1727/8, aged 17 years, taking the degree of B.A. 1731, and of M.A. on the 11th of June 1734. Even as an undergraduate he began to devote himself to philological and archaeological pursuits, and **Hearne**, the celebrated antiquary, mentions him in the Preface to Liber Niger Scaccarii, Wilhelmique etiam Worcestrii Annales Rerum Anglicarum, Oxonii; 1728, as ‘optimae spei juvenis, literarum et literatorum amantissimus.’


**Hearne** was indeed much indebted to our author for valuable assistance, while he was engaged on many of his laborious works; nor did the good offices cease with the antiquary's death, for in 1750 Mr Loveday restored **Hearne**'s monument at Oxford at his own expense.[3](javascript:footNote('E730002-001/note003.html'))




---

p.x


**John Loveday** published nothing in his own name, although his advice and assistance were asked for by many a learned author of the day, and always readily granted.


Grateful acknowledgments of his assistance frequently occur in the Prefaces to books of Antiquarian or Theological Research published between 1730 and 1780. He was also a constant contributor to the pages of The Gentleman's Magazine, under different signatures.


‘Mr Loveday,’ says Crito, writing in 1789,[4](javascript:footNote('E730002-001/note004.html')) ‘possessed a most excellent understanding, which he carefully improved by study, and an unremitting attention to letters, during the course of a long life. He read much, and had well digested, and made his own whatever he read. Hence he had acquired an extraordinary fund of knowledge, particularly with respect to history, antiquities, the original languages of the Sacred Scriptures, and all kinds of philological learning. His merit was so conspicuous and well known, that perhaps few great works have been lately undertaken in these branches of literature concerning which he was not previously consulted.’


‘Indeed he was always ready to communicate useful information in this way, either in conversation or by letters. Hence his friendship and correspondence were solicited by men of the first rank in literature, and he numbered among his intimate acquaintance **Mr Hearne the Antiquary**, Bishop Tanner, Bishop Lowth, **Dr Ward** of Gresham College, Dr Kennicott, Mr James Merrick, Mr Granger,[5](javascript:footNote('E730002-001/note005.html')) and many others equally eminent.’


‘His judgment, both of authors and their work, was just and accurate. If he ever erred, it seemed to arise from excess of



---

p.xi



candour, which perhaps sometimes disposed him to judge more favourably of publications than they appeared to merit. Authors, of whatever rank and reputation, who endeavoured to injure the cause of religion and virtue, he always spoke of with the contempt and abhorrence which they deserved. Nor were his goodness of heart and rectitude of conduct inferior to his natural and acquired abilities. In true piety and fervour of devotion, in the most strict and scrupulous attendance on the solemn offices of the Church and the domestic and private duties of religion, few of the present age have equalled, perhaps none have surpassed him. This spirit, as might be reasonably expected, pervaded his whole conduct, and influenced all his actions. He was himself humble and unassuming, without guile, of the greatest candour, and most amiable simplicity. With respect to others, he was a man of the strictest justice and integrity to all persons, of boundless hospitality to his friends, of munificence and charity to the poor and necessitous, almost without example.’


‘He was one of those few remaining private gentlemen,’ writes the author of the memoir in **Nichols**' Literary Anecdotes,[6](javascript:footNote('E730002-001/note006.html')) ‘who, constantly residing in the country, have made it their object, by their authority, their example, and their beneficence, to promote the good order and comfort of their parishioners. He was a true member of the Church of England, whose institutions and discipline he thoroughly understood, and whose worship he most conscientiously attended till increased infirmities rendered him incapable.’


Miss Berry gives the following account[7](javascript:footNote('E730002-001/note007.html')) of a visit paid to the author at Caversham in 1774, when he was 63 years of age: —
  

‘In 1774 my grandmother took us to visit at Mr Loveday's, at Caversham near Reading, an old Tory country gentleman, who had


---

p.xii



married a cousin of hers, and had two daughters much about our age: with them we formed an intimacy which lasted till their death, thirty or forty years afterwards. The intimacy gave me occasion to learn, in several visits to them afterwards, and when I was able to observe it, the character of Tory country gentlemen of those days, or rather of days before, and the sample I saw was certainly a rare and most respectable one. He saw much of all the clergymen in his neighbourhood. At dinner, the first toast was always Church and King; the second, To the flourishing of the two Universities; the third, To Magdalen, or as he called it, Maudlin College, where he had been educated. But he was, with all this, an elegant and accomplished scholar, and was delighted at finding me apt at recalling to his mind passages of the Roman poets.’


Possessed of an ample patrimony, **John Loveday** indulged his tastes for pictures, books, and antiquities, in a quiet and unostentatious manner. He laid the foundation of the family library which still remains intact at Williamscote, near Banbury, in Oxfordshire, purchasing among other rare books a Caxton's Cordyal in a nearly perfect condition. This book has in his own handwriting on the fly-page, ‘1728. Pretium 6s/8d.’


He passed away at the good old age of 78, much lamented by his friends and neighbours, as the Reading papers of that day and numerous letters testify, having led a gentle and quiet, though by no means an idle or useless life.


He was succeeded by his eldest son, John Loveday, D.C.L., who had married Anne Taylor Loder[8](javascript:footNote('E730002-001/note008.html')) of Williamscote. Dr Loveday subsequently sold the old house at Caversham, and moved the collections of books, coins, pictures, and antiquities to the new home.


The following letter,[9](javascript:footNote('E730002-001/note009.html')) in which allusion is made to the author



---

p.xiii



and his intended tour, was written to Dr Richardson by **Thomas Hearne**: —
  


>   
> Edm. Hall, Oxford,
> 
> 
> May 13. 1732.
> Honoured Sir,
> On the first instant your Son of University College, paid me a guinea by your order (for which I thank you), in full for your copy in small paper of Thomas Otterbourne and John Whethamstede which I am printing in two volumes 8vo.
> 
> 
> But the occasion of my writing now is this. A friend of mine designs in a little time to go into Scotland, and desires to know whether in such a journey it may be safe travelling for two or three persons out of the high roads, if they have a mind to seek antiquities, and go into bye-roads; and particularly, if they have a desire to trace the Pict's Wall from one end to the other. He is a young gentleman that is inquisitive and curious; and being satisfied that most antiquities lye hid in bye-places, he hath a desire of seeing what remains there are at the Pict's Wall, and in some other bye-places; but is willing first of all to be satisfied whether there may be danger in such sort of travelling out of the high roads. My friend put another query to me — viz., Is it best to go by land or water from Edinburgh to St Andrews and Aberdeen? My friend's name is Loveday, and you will find mention of him in ‘Hemingford’, which I suppose you have received before this time. You are as likely a person to inform me as any, and therefore I apply to you in my friend's behalf.
> 
> 
> Your known candour will excuse me, and I hope you will be pleased to answer this request of,
> Sir,
>   
> 
> Your most obliged, &c.
> 
> 
> **Thomas Hearne**.






---

p.xiv


The Itinerary I have compiled from the Text, adding references to the pages.


I cannot conclude the Introduction without expressing my acknowledgments to my dear friend the Vice-President (Rev. W. E. Buckley) for his advice and encouragement during the preparation of this work for the press.
John E. T. Loveday.


---

p.27


Tuesday, 30. —From **Porthaeth-hwy** to **Llangefni**, 6 Miles; to **Bodedern**, 10; to **Caer Gybi**, at Mrs Welche's, 6 Miles. The Road here was chiefly a level, much on a Causey, ye Ground about it but barren for ye most part, & rocky. 3 Churches on ye Right of ye Road had Binsey Steeples, one of 'em was **Bodedern**. A Stone of considerable *height* set up on end, but no Signs of an Inscription on it, stood in a ground to ye left of ye Road, behind **Llangefni**. More Goats to day than I had seen before. **Caer Gybi** is a Market-town, near ye Western Cape of ye Island, which is call'd **Holy-head**, more generally **the Head**; This ye only Mountain, to speak of, in **Anglesey**.


Some of ye ordinary Women in North Wales, wear Stockings without feet, & no Shoes; so do several Boys. The Women All wear black Hats, (Several such We saw in **Shrewsbury**) in ye other parts of their Dress, much superior to ye Sex in South-Wales, for which See my Tour there. They say *big* for great, as ‘a big room’. Their Oath is — *Name of God.*


Wednesday, 31. — About 11 o'th' clock We set sail in ye Grafton Packet-Boat, James Quiltra Master, for **Dublin**, but ye Winds being still, prolong'd ye Voyage, & afforded good Pastime for ye Sailors, who fish'd for Knowdes or Gournets, of which they took quantities, bating for one Fish with part of That they caught before. I was excessively ill all ye time, It is upwards of 20 Leagues over, & We did not land 'till—


Thursday, June 1. — About 1 o'th' Clock in ye Afternoon — at **Dublin** (Ireland, in the Province of **Leinster**, & ye County of **Dublin**) at ye Flying-horse.


Friday, 2. — From **Dublin** to the **Naas**, in ye County of **Kildare**, 12 Miles; to **Kilcullen-bridge**, at ye Crown, 5 Miles. This was a very fine made way, of considerable breadth, only one Turnpike, & That demanded but an half penny a horse. But just out of **Dublin** — the Metropolis — (and 'tis so for a great way on) are Cottages — they call 'em Cabbins [Fr. Cabane, a Cottage, a Thatched House;



---

p.28



and ye Word occurs in other Languages, v. Junius; nay, it occurs in Lhuyd's Irish-English Dictionary thus — ‘Cabán & Cabáin, *A cottage*, — a cabbin.’] — made of Mud, & thatched with Straw, there was a Calf to each Cabbin, great numbers of Poor along ye Road; Even in **Dublin**, ye poorer Boys go without Shoes & Stockings; and as We came into ye Countrey, Men, Women, All in general of ye meaner sort, either had None, or carry'd 'em on their Shoulders, if they were travelling ye Road. Mr Bourk's Park on ye Right hand, before **Naas**. The Assizes are never held at **Kildare**, but alternately at **Naas** & **Athy**. **Naas** is one Street, & has a good Market-house.


Saturday, 3. — From **Kilcullen-bridge** to **Brea**, 11 Miles. The **Liffy** flows under ye bridge at **Kilcullen**. **Brea** is ye Seat (only for a term of years) of my Uncle, Captain Jno. Lethieullier; It was once in ye Ricklesey — his Lady's — Family; an old house, of brick, cover'd with Plaister. By an Union of Parishes It belongs now to **Athy**, not 2 Miles off.


Sunday, Monday, Tuesday, Wednesday, & Thursday, 4, 5, 6, 7,
& 8. —There is only a Chappel in **Athy**, tho' 'tis said there have been 2 Churches; [v. Nugae Antiquae. ii. 155.] It is a compact Town, & not large, upon ye River **Barrow**. We were more than once in **Colonel Nevil**'s Company; his Seat (only for a term of Years from ye Earl of Kildare,) is **Dollards-Town**, half a Mile from **Brea**, & in ye Union of **Athy**; Lieutenant Forth lives with him. Mr Nichxon, Chancellor of ye Exchequer, was at this time with ye Colonel. On Wednesday, We din'd at **Belan**, Colonel [Mr] Stratford's, 3 Miles from **Brea**; He was not in ye Countrey, We were entertain'd by his Sister, Mrs Katherine Spencer, the Wife of Mr Henry Spencer, an half-brother of my Aunt's. This is a most pleasant Seat, his large Plantations of Trees in variety of shady Walks, & in Groves, Several Ponds also well stock'd with Fish, The **Greece** flowing here; but ye chief beauty is ye bold Avenue on both sides ye house, to ye Front between a noble Walk of Trees, of decent Width, & considerable *Height*, so as scarce (take it all together) to be parallel'd: And there is a very



---

p.29



great quantity of Wall-fruit here. There are a great many Seats about this Countrey. Memorand: My Uncle said that **Sir Kenelm Digby** was reported to be ye Father of **Lewis 14. of **France****. Consider, with This, page 581, 582 of W. Hemingford.


Thursday, 8. — From **Brea** to **Caterlogh**, in ye County of **Caterlogh**, 6 Miles; to 
**Leighlin bridge**, at ye Savage's Arms, 5 Miles. We went by Grange Milner, Sir John St. Leger's, a puisnè Judge here; (v. Swift, xxi. 149.) We saw Him at **Brea**, & He gave Us an invitation to dinner; beyond his house, We pass'd over a Ford, which bought Us into ye **Queen's County**; for some time ye Road lay on ye Right of ye **Barrow**, which We cross'd, over a bridge just by **Caterlogh**, & then ye River flow'd on ye Right. This Bridge brought Us into ye County of **Caterlogh**, by contraction (& it is so pronounced) **Carlogh**. The Miles were of ye longest. The bridge at **Leighlin** is over ye **Barrow**.


Friday, 9. — From **Leighlin bridge** to **Kilkenny**, in ye County of **Kilkenny**, at ye Star in Irish Town, 10 Miles out of **Leighlin**, on an higher ground, ye ruins of a Cross. 'Tis a Turnpike Road, part of it on a barren higher Ground, having a pleasant Valley with several Villages, for ye most part on ye left hand. More than One ruinated Church in this Route, The 2nd Turnpike is placed, where ye Counties part. **Kilkenny** is a large Town, fair built of Stone, and by much ye best midland Town in ye Island. 'Tis well water'd by ye **Neor**, commonly call'd ye Neure, Part of ye Walls remaining, ye Gates entire. The Irish Town, which begins at ye bridge just out of ye Gate nearest ye Cathedral, is a distinct Corporacion from ye City, which is govern'd by a Mayor & Alderman, extending it's Jurisdiction also over ye Suburbs. Here is an handsome Town-house. But one Parish Church, St. Mary's in ye City, an ancient Structure; there have been, I'm told, two more Churches; One was St Patrick's, now quite gone; ye other, St John's, joyning to ye Priory of that name; But of this latter I have some doubt, the large Shell indeed of a Church is now remaining there, with a Tower; It has ancient rais'd Monuments.



---

p.30



with Effigies, & Some of modern Date; in ye Close too, are more Monuments but This I take to be ye Priory Church: here are ye Barracks, as also at ye Franciscan Friery, ye Shell of this Church, is standing with it's Tower rais'd on an high Arch; The Enclosure of this house was very large, & ye Inhabitants of **Kilkenny** purchas'd it of ye Crown after ye Suppression. The Tower & very large Shell of ye Black Friers Church is also still remaining. The Castle, a fine building of Stone, has a new Look, It stands on ye left as We entred ye Town, — on ye farther side ye bridge; Entring thro' ye Gate-Way, ye buildings are All fronting You, & on your left hand; Those on ye left are of ye elder Date, Those to ye Front — a bare Shell, but roof'd, built by this **Duke of **Ormond****. The house is kept in good repair by ye **Earl of **Arran****, whose Agent lives in it; ye Goods &c. were torn down and sold upon ye Confiscation, except some perfectly neat Marble Chimney-pieces. The Dining Room is in some decay, it's Chimney-piece of Kilkenny Marble. **Boate** tells Us, at p. 82, of his Natural History of Ireland, that ye Quarry of this Marble is not above a quarter of a Mile distant from ye Town, & that when polish'd ye Marble gets a fine blewish Colour, drawing somewhat towards ye Black. But for ye Castle, — Some Apartmtents below are furnish'd by 
**Lord Arran** (who has not been here, since a School-Boy) with gilt-leather hangings, — Chairs, — a Screen &c. A noble long Gallery above, & of a good-proportion'd Width. In some Rooms — incomparable Tapestry,[10](javascript:footNote('E730002-001/note010.html')) From ye Castle-Leads is a fine Prospect of ye Town & Countrey. In Irish Town, on a gently rising Hill, is ye Cathedral of ye See of[11](javascript:footNote('E730002-001/note011.html')) Ossory,[12](javascript:footNote('E730002-001/note012.html')) for about ye end of Henry ye 2nds 



---

p.31



reign ye See was translated from **Agabo** in Upper-Ossory to this place. The Church here is considerably large; indeed, in **Harris**'s opinion, ye largest in ye kingdom, except ye 2 in Dublin [v. ye English Ware. i. 433] but it wants a good Tower, for That at present is much inferior to ye Tower at **Winchester**. 'Tis built in form of a Cross. At ye South end of ye Cross-Isle, is a very high Stone Beacon.[13](javascript:footNote('E730002-001/note013.html')) The North & South Isles are not flagg'd, except where they make part of ye Cross-Isle, but they are to be done shortly. The Choir has Pews & Galleries in it, one Pew for ye Mayor & Aldermen of **Kilkenny**. Here is an Organ, but no Choir-Service. In a place to ye North of ye Choir are some ancient Monuments of ye Ormond family, which were taken out of ye Church; The Head-dress of a Lady — one of 'em — is something like ye Mitre of ye Jewish High-Priest, another of ye same kind We saw in St John's Priory.[14](javascript:footNote('E730002-001/note014.html')) There are several Monuments in ye Cathedral; One for a Butler, Lord Mountgarret; Some Tombs for Craftsmen have ye Implements of their Trade engrav'd on 'em as a Shuttle &c. on a Weaver's; v. p. 46. A Stone dug up about 2 Years since is in much esteem with ye Inhabitants of Irish-Town; It has on it ye Cross, other Instruments of Christ's Sufferings, ye seamless Coat &c. [vide p. 34.] and is a Tomb-stone for a Burgensis Villae de Iristoune, who dy'd in 1597. Irish-Town is a distinct Corporacion from **Kilkenny**, nay sends two Members to Parliament as well as ye City, & is govern'd by a Portreve & Burgesses; ye Bishop (Lord thereof by immemorial Prescription) has ye nominacion of ye Portreve out of two or more Persons return'd to him, this Corporacion having been founded and endow'd by Bishops of this See. The Government of **Kilkenny** would have, that ye Corporacion of Irish-Town was a late



---

p.32



thing, set up by **Bishop Otway**, (Otway did indeed with great expence defend ye Privileges of this Corporacion against ye City), but This Epitaph is an authentic Evidence on ye side of Irish-Town. Consult **Sir J. Ware**, under ‘John Parry, Bishop of Ossory’. The late Bishop **Sir Thomas Vesey** was much belov'd, He liv'd in an open way upon ye Revenues of his Bishoprick (which by not taking Fines, but raising ye Rents, from 800 £ per Annum He made 1300 £ per Annum) & his large Estate otherwise. Bishop Tenison, threatning to invalidate ye Proceedings of ye Corporacion in ye Vacancy of ye See, lost himself much here, & has nothing near that Sway in ye Government of Irish-Town as his Predecessor had. In ye Cathedral, are also bury'd some of ye Bishops but there are not ye Effigies of any. **Bishop Otway**, who dy'd in 1692-3, is bury'd under a plain Stone in ye Nave, not many paces within ye West Door, which He could scarce be brought to consent to, He thinking himself unworthy to be bury'd, but in ye Cemetery. Some Monuments here are made of ye black Kilkenny Marble. But ye chief Ornament of ye Church, are ye excellently well-turn'd Arches before ye Entrance of ye Choir.[15](javascript:footNote('E730002-001/note015.html')) In ye North part of ye Cross-Isle is a small place with a Communion-Table rail'd in, which they call ye Parish-Church, so constituted (I'm told) by a Bishop who suing some Dissenters for not coming to Church, They objected *their* having no Parish-Church. The only Ecclesiastical Houses are ye Palace, ye Deanary, & ye Chantor's house, tho' there is a Spot of Ground for an house, belonging to each Dignitary. The Dean is call'd Dean of St Canic*e* to whom ye Church is dedicated; ye place worth about 300 £ per Annum. **Mossom** is ye present Dean. The Cemetery has pleasant walks of Trees round it, & to ye West a Terrace; here You have a perfectly pleasant Yiew of ye City, & Countrey about It. In ye two Protestant Churches is sufficient room for all ye Protestant Inhabitants of both Corporacions, for there are here 15 Papists to 5 Protestant, and there has been great talk of a begging-friery set up in ye Town.




---

p.33


Saturday, 10. — From **Kilkenny** to **Knoctopher**, 8 Miles; to **Mulnavat**, 7; to **Waterford**, in ye Province of Munster, & ye County of **Waterford**, at ye Angel, 5 Miles. The Road to **Knoctopher** was over an open healthy Countrey, bare of Inhabitants; This poor scattering place, **Knoctopher**, is govern'd by a Portreve, & sends 2 Members to Parliament. The Tower of it's Church is a Square 'till near ye top ye Angles become Planes, inclining inwards; ye small body of ye Church is new; ye Cross-Isle, of ye same age as ye Tower, in ruins. Beyond This, ye Road went over a mountainy Country, Stony, nothing but Heath & Barrenness, and very thinly inhabited, but then ye Miles were not long. More ruinous Churches to day, & We saw some Goats browzing. We descended to ye Ferry, & crossing ye **Suire**, pronounced Shure, which here is a noble River of handsome Width, & parts ye Counties, We arriv'd at **Waterford**, seated upon ye Banks of it; And close by, It dischargeth itself into that arm of ye Sea, which is known by ye name of **Waterford Haven**. See **Boate**, p. 37.


Sunday, 11. — The Key at **Waterford** is exceeding noble, being in a straight line of great length, ye Stone buildings on it very handsome; nothing more beautiful than this View from ye Water. Here is an handsome Custom-house. The Houses in ye Town are both of Stone and Brick, not answerable to Those on ye Key. The West of **Waterford** is on ye steep side of an hill. The Town-wall is — great part of it — standing, & has Towers in it; two of ye Gates are us'd for Gaols, the Western is a new beautiful Building of stone, out of which are good new Barracks, Those for ye Officers very neat, & sash'd; beyond this Gate is a fine Opening, ye Suburbs in this part being very wide: Indeed ye Suburbs of **Waterford** are considerably large & stragling. The Market-house, with ye Townhouse over it, is another good Stone building, but None more decently elegant than ye School for ye Education of poor Children, founded by Bishop Foy, & built by his Executors in 1708; 'tis of Stone, and Sash'd. The Cathedral is an ancient Structure, ye Shell



---

p.34



of some parts of it only remaining, its Tower clumsy. The Nave is but small, divided from ye Isles by Arches of an uncommon Clumsiness, ye Pillars are much upon a square. The solemn Choir has a Gallery, & Pews in it, as at **Kilkenny**; an handsome Throne; Relievo-Work under ye Stalls; an Organ here, but no Choir-service; tho' (as I understand) ye present Bishop had introduced Choristers; but there being little agreement between **Dean Bolton** & Him, They were dropp'd.[16](javascript:footNote('E730002-001/note016.html')) All ye middle Isle is high. In ye South Isle, & towards ye West is bury'd **Bishop Nathaniel Foy**, who dy'd Dec. 31. 1707, aged 63; **Milles** was his immediate successor, who resides constantly here, — ye Bishoprick worth about 1500 £ per Annum. It has been a Bishop's See ever since 1096, & **Lismore** is annex'd to it. The Presbytery, call'd Trinity-Church, has also it's clumsy Arches, but no floor. It is a Parish Church; tho' as it is not fitted up, ye Parishioners make use of ye Choir; however 'tis in use for burying; of old Monuments here is a recumbent one of a Bishop vested & mitred, Another recumbent in armour of one They call **Strongbow**,[17](javascript:footNote('E730002-001/note017.html')) a Dog at his feet; here is also a Sceleton; Several Tombs of a later Age have on 'em (as I observ'd at **Kilkenny**) ye Cross with other Instruments of Suffering; All Such as These (I'm told) are for Catholics. Rice's Chappel not pav'd, his Sceleton on a rais'd Tomb with Worms &c. crawling about him; round ye Tomb ye figures of ye Apostles &c. The Palace — & Deanery, an handsome Stone-house built not many Years ago — stand in ye Cem*i*tery; ye two other Dignitaries Houses are towards ye Key. The Revenues of ye Deanery between 300 & 400 £ per Annum. West of ye Cathedral is ye extended Brick front with Wings, — of ye Hospital for 10 clergymens Widows, allow'd 10 Pounds apiece yearly, founded by **Bishop Hugh Gore** (**Foy**'s immediate Predecessor), & erected by his Executor in *1692*. The Bishop & Dean fill up ye Vacancies from any part of ye Kingdom; Each Widow has 3 Rooms & 2 Closets. By ye Cathedral generally call'd



---

p.35



Christ-Church is St Olave's Church rebuilding of Stone, with a Cross at ye South end; over ye Door, a Latin Inscription reciting **Bishop Milles**'s Care to have This, St Patrick's, & 5 more Churches rebuilt; an handsome Throne for ye Bishop will be put up here, as there is at St Patrick's, by ye West Gate, where **Milles** comes as often as to his Cathedral; This Stone Church has no Pillars, on ye North side are ye Seats for ye Men, on ye South for ye Women. Round ye Font — ‘Anno Domini 1723 Hoc Est Lavacrum Mentium Hoc Est Sepulchrum Criminum.’ The other Churches are in Ruins: The French Church belong'd to a Franciscan Friery. The Black-friers Church turn'd into ye County Court house, ye Tower still standing. Our Lady's Church, belonging to another Religious house, is a bare Shell & Tower, & has Tombs with ye Cross &c. as above. In **Waterford** are Dissenters of all Denominations, for it is a populous Town; **Camden** reckon'd it for Wealth & Populousness ye 2d City in Ireland, but That was before ye growth of Cork.


Monday, 12. — From **Waterford** to 3 mile bridge; to **Kilmedin**, 2; to **Porthla**, 3; to **Carrick**, in ye County of **Tipperary**, 4; to **Clonmell**, at ye Globe, 8 Miles. The Country at first was heathy, then ye Road over a mountainy barren Countrey, & between Mountains, where It was something stony & rocky, — part of ye Road also in ye Valley. **Killotery Church**, with a Cross at one end — two Miles from **Waterford** — is one of Those rebuilt by **Bishop Milles**. At 3 mile bridge to ye left was **Colonel Crispus**'s house. Beyond **Porthla** to ye left was a Park wall'd in, at ye bottom of which stands a large Seat of ye **Lord Tyrone**'s. The **Suire** was seen to run beautifully sometimes to ye Right of ye Road; We cross'd it over a stone bridge of 10 Arches, carrying us into ye County of **Tipperary**, & ye Town of **Carrick**; before which on t'other side ye bridge is **Carrick Beag** or little Carrick, where to ye left is ye Shell of ye Church &c. of a Franciscan Friery, founded by ye **1st Earl of Ormond**; and there are some houses on ye same side of ye Water. **Carrick** is a good airy little Town, built on ye banks of ye **Suire**, behind which runs-on a



---

p.36



ridge of Hill. The Town has Gates & Walls. The **Duke of **Ormond****'s Castle here is an old thing, now upon a Lease from ye **Earl of Arran**. Good Barracks here for Horse. From hence to **Clonmell**, pronounced Clemell, Mountains run-on both to ye Right & Left; ye Ground heathy as before: a distance before 2 mile bridge (so call'd in respect of **Clonmell**) We lost ye Mountain to ye Right. Part of this day's Ride on a Causey, as usual; two or three ruinated Churches in view. The **Anner** runs under 2 mile bridge. **Clonmell** is a pretty little Town, consisting chiefly of ye Street in which ye handsome stone Town-house stands supported on Arches, — & of That which runs along at right angles from ye front of it. It has Gates & Walks on ye Walls. But one Church here; as to ye living, see Swift, xix. 268. Whilst We were in ye Church-Yard, a Child was attended to it's Grave with ye Irish Howl; it surpris'd Us to see It put in ye ground & cover'd up, without any Burial-Service, ye Company returning home; upon Enquiry, it was ye Child of a Catholic, & ye Protestant Service is never read over Them in this Kingdom. The Presbyterians have a Meeting in part of a Franciscan Friery. This Town is built also on **Suire**'s Banks; ye River, contracted at **Clonmell**, flows to ye South behind which runs on (as at **Carrick**) a ridge of hill. Long Rows of Cabbins make large Suburbs here. This is ye chief Town in ye County.


Tuesday, 13. —From **Clonmell** to 5 mile bridge, to **Clogheen** 3 Miles; to **Ballyporeen** 3; to **Kilworth**, in ye County of **Cork**, 5; to **Cork**, 2; to **Rathcormuck**, 2; to **Cork**, at ye Globe without South Gate, 10 Miles. The Road was on an high ground, Mountains running on to ye left, and every now & then We had a View of Others to ye Right 'till 4 Miles before **Kilworth** — Entring ye County of **Cork**, ye Road went up ye left hand Mountains, & there continu'd almost as far as **Kilworth**, which lay in ye bottom, & It was very rough & stony. After this place, We had pretty well lost ye Mountains, & from hence to **Cork** ye Cabbins began to thicken again. On a Rock to ye Right just before 5 mile bridge, where flows ye **Suire**, are ye ruins of some



---

p.37



ancient building. **Clogheen**, **Kilworth**, **Fermoy**, & **Rathcormuck** (pronounced Recormuck) are all Market-Towns, & ye latter sends Members to Parliament. It is ye River **Ountar** at **Clogheen**. We went over several Bridges in ye last 14 Miles, & descended to **Cork**, entering it thro' ye North Gate. We saw several Goats to day. It was soon in ye morning that we sat out, *[set out]* & late before we got into **Cork**.


Wednesday, 14. — **Cork**, which far exceeds any City in ye Kingdom but **Dublin**, is encompass'd with a Water that also crosses it, so it is only accessible by bridges. And 'tis inclos'd with Walls, ye North & South Gates are large & handsome Stone buildings, Both us'd for Jails; & just out of Each of 'em is a fair stone-arch'd Bridge; over both these bridges ye principal Street of ye City is continu'd to a great length up ye Suburbs; for as soon as You pass either Gate, ye Ground rises very considerably; ye Northern Suburbs are much ye largest, & indeed are remarkably large. In **Camden**'s time This was a little trading Town, and **Boate** (at p. 5, 6.) mentions It as less than **Waterford** & **Limerick**. The Buildings are of Brick & Stone. **Cork** is seated many Miles from ye Sea; it's Key with all ye Docks is very large; It doubles much, it's direct Length in any part not very great. Within ye City & Suburbs are (as I understand) 6 Churches; of which One without ye Walls, & in ye Southern Suburbs, is ye Cathedral, call'd **St Barry's**, more properly **St Finbarry's**, from St Barr or Finbar, their first Bishop. It is a mean & small building, and of great age. The Pillars in ye Nave are large & inelegant, this part of ye Cathedral is a Parish-Church provided with a Pulpit, Font &c. but no Pews; It has been disus'd a long time, so ye Parishioners sit in ye Choir. There was no Monument that I saw for any Bishop in ye whole Church, (tho' Several according to *Sir J. W.* are bury'd here), except in ye Nave — The Tomb-stone of **Dr Edward Synge, Bishop of Cork, Cloyn, & Ross**, who dy'd in 1678, since then ye Bishoprick of **Cloyn** has continu'd separate: Remarkable that This Prelate's Son & Grandson, Both of ye same Christian name, are also Bishops;



---

p.38



And His Elder Brother, **Georg Synge** was Bishop of Cloyn, Both of 'em English men. The low Case of Stalls is plain, an Organ here, but no Choir-Service; ye Choir only is ciel'd. The Chapter-house, us'd also for ye Bishop's Court, is new & sash'd. No Presbytery here, nor one Monument with recumbent Effigies throughout ye Church. The Tower of ye Cathedral is mean enough. The Palace, call'd Bishop's-Court, is a large house; but **Bishop Browne** has built an handsome Palace as well as Church at **Balanaspy**, now call'd **Bishop's Town**, 2 Miles off, where He resides. The Revenues of ye Bishoprick between 1100 & 1200 £ per Annum — of ye Deanery about 100 £ per Annum. The Dean's house, Mr Robert Carleton's, is an handsome pleasant Place. There is a School, & Library over It for ye Church, almost finish'd. **Gille-Abbey**[18](javascript:footNote('E730002-001/note018.html')) Ruins — a Tower &c. — are in these Suburbs, as are also ye Barracks just without ye Gate, two large & good Buildings, opposite to one another; Centinels are planted in every part of ye City. **Christ-Church** in ye prime Street is ye best Church in **Cork**, a late handsome Stone-building, but so slight ye work, that it is already repairing. **St Paul's** is ye newest Church. **St Peter's**, **St Nicholas'**, & **Shandon** are ye other 3. So large a Town without an high Steeple is an odd sight. There is not a Ring of Bells in ye City. The **Tolsey**, with ye Town-house over it, is a large & good Structure of Stone, in ye principal Street; but It is pretty much hid by ye Houses. On ye Key, is a very large, & as handsome, a Custom-house of Brick with 3 Fronts. To ye South of ye Town are Walks. A good number of Chairs attending in **Cork** Streets.


Thursday, 15. — From **Cork** to **Kinsale**, at ye Bear, 10 Miles. The Road was very much up & down Hills, which were rocky. 'Tis Rock all about **Kinsale**; which is fortify'd with old Walls, has ye **Bandon** running on one side, & a high ridge of Hill on ye other, so that ye Town pent-in is of good length, but inconsiderably broad; ye Streets but narrow, & there is very little brick building. The Town far from neat or pretty. The Harbour very commodious. Here is one large 



---

p.39



good Church, but not ciel'd; ye East part repair'd & sash'd, & there are other lesser sash'd Windows about It, within, are Tombs of ye **Southwells**, of which family is ye present **Secretary of State for Ireland**, who has an house in **Kinsale**; here are some Monumental Inscriptions on wooden Tables, hung-up against ye Wall; & there are Others in golden letters under ye Arms in Achievements. Two Regiments are always quarter'd here; One at ye Barracks, ye other at ye New Fort, a Mile off; between which & ye Town is a Village, call'd **The Cove**;[19](javascript:footNote('E730002-001/note019.html')) This Fort is kept in admirable repair, has 4 Batteries, & Several Cannon are mounted; large & convenient Lodging here for ye Soldiers. The **old Fort** nearer ye Town.


Friday, 16. — To **Cork** again, 10 Miles; to **Mallow**, at ye Swan, 12 Miles. Goats in ye Road to **Cork**. We had several Hills to go up & down in ye last 12 Miles. About 2 Miles before **Mallow**, We rode thro' ye large Ruins of **Ballinemony** Preceptory of ye Knights of St John of Jerusalem; ye handsome Church of this place has all sash-Windows. **Mallow** is a considerable large Market-Town, chiefly of one Street, it's Church a late good building. We came to ye Town over a fair stone-arch'd bridge, under which ye **Blackwater**, We had met with this River before. The Barracks are within ye Castle-Inclosure, ye front of this Castle is very large & grand, tho' It be only now a bare Shell. Quaere, whether it was not ye Duke of Ormond's? **Annabel-house**, just out of ye town, belongs to **Clayton**, one of ye King's Pages. There is a Spaw behind ye Town, which is very like That at **Bristol**, being warm; 'tis cover'd-over, & much resorted-to in a Morning.


Saturday, 17. — From **Mallow** to **Two-Pot house**, 2 Miles; to **Ballyhoury mountain**, 4; to **Kilmallock**, in ye County of **Limerick**, 6; to **Bruff**, 3; to **Limerick**, at ye py'd horse, 9 Miles. At **Two-Pot house**, with our Tea We had Toast & Butter made in an uncommon



---

p.40



manner; ye Landlady broil'd ye bread on a Gridiron, then melted some Butter in a Saucepan, which She pour'd on ye grill'd bread. When We descended from ye Mountain, a large Valley receiv'd Us; at a Turnpike, 3 Miles before **Kilmallock**, ye County of **Limerick** begins. **Kilmallock**,[20](javascript:footNote('E730002-001/note020.html')) in **Camden**'s time, Second in this County to **Limerick** only, both for plenty & populousness, is now a Row of ruin'd houses, in which notwithstanding there appears an Air of grandeur, for they are several stories high, & very deep, of a durable handsome Stone, ye Door-Cases &c. all of Stone. **Cromwell** burnt this town, since which It never recover'd Itself to any great degree; And ye **Duke of **Berwick**** compleated it's Desolation by burning What remain'd: It is now a very poor place, but it's Walls are pretty entire & it's Gates. The Friery[21](javascript:footNote('E730002-001/note021.html')) is as noble a Ruin as can be seen; ye Shell only of it's very large Church, — & part of ye Tower, — standing, yet so as that You have ye entire *height*. There is enough still to convince Us that It much exceeded any building We have yet seen in Ireland. The Tower is in ye middle on high Arches. Nothing clumsy throughout ye Whole. Inserted in one of it's Walls is ye following Inscription, each letter a Capital, —[22](javascript:footNote('E730002-001/note022.html'))
  


1642
  

TERTIA LUX CAESOS MEMORAT SEPTEMBRIS IN ANNO
  

QUEM LEGIS HEU NONDUM TRES TENET URNA SENES
  

MARTE NEPOS ERAT RESQUE RUUNT TRIA PIGNORA JUSTO
  

JUS PATRIAE CAUSAM REXQUE FIDESQUE PROBANT
  

INTEGER ATTRITIS REPERITUR CANDOR IN EXTIS
  

VIRGINIS ET VERI PURPURA MARTYRIJ
  

LILIA PURPUREOS INTER SUDANTIA FLUCTUS
  

TRES MERUERE TRIUM NOMINA MARMOR HABE[23](javascript:footNote('E730002-001/note023.html'))
  

FRES:[24](javascript:footNote('E730002-001/note024.html')) GEOR
  

NEP. EDW BURGATE*[in larger capitals]*
  

ALEX
  



---

p.41



Over This, ye Arms cut out in Stone, being 3 Boar's Heads, 9 Cross Croslets, & a Chevron, ranged in this Order —[25](javascript:footNote('E730002-001/note025.html'))


On a rais'd Tomb, nigh This, is ye following Inscription, each Letter a Capital —
  

I H S
  

HIC TUMULUS ERECTUS FUIT
  

IN MEMORIAM ILLIUS STEMMATIS
  

GERALDINORUM QUI
  

VULGO VOCANTUR EQUITES
  

ALBI[26](javascript:footNote('E730002-001/note026.html'))
  

JOHANNES CUM FILIO SUO
  

EDMUNDO ET MAURICIO FILIO
  

PREEFATI[27](javascript:footNote('E730002-001/note027.html')) EDMUNDI
  

ET MULTI ALIJ EJUSDEM FAMILIEE[28](javascript:footNote('E730002-001/note028.html'))
HIC[29](javascript:footNote('E730002-001/note029.html')) TUMULANTAR[30](javascript:footNote('E730002-001/note030.html')) PREEFATAS[31](javascript:footNote('E730002-001/note031.html'))
  


There is no Stop after this last word; it makes no sense here, probably something else was to have been added.


There is an old building without that Gate which leads to **Limerick**, call'd **The White Knight's Castle**. Joining to ye Church are ye Remains of other Building, as one whole Side of Cloister, in which a Room arch'd with Stone, high & long; It has two Chimneys; over it, have been Apartments. There is an old thing, call'd ye Vicar's Castle. The Parish-Church, dedicated to St Peter & St Paul, is most of it in ruins, unroof'd; it's Pillars clumsy, Tombs here; a very small part of it in use at present. Beyond ye Jail, stands ye Shell of a large house, once ye Bishop's Palace, I'm told; ye **Bishop of **Limerick**** has a good Estate about this Town. In **Bruff**, a Market-town,



---

p.42



is an old house of **Sir Standish Hartstongue**'s. We descended to **Limerick**, Our Road to this City from **Kilmallock** was on a Causey; ye Cathedral-Tower is a great addition to ye Prospect of **Limerick**; ye other Churches cannot be seen.


Sunday, 18. — **Limerick** is encompass'd by ye **Shannon**, ye chief River of Ireland, which divides it's Stream, & embraces it. The City is divided into 2 parts, ye English and ye Irish Town. The Walls seem to be of different Ages, on part of 'em a very fine & exceeding wide Walk; Great Vessels, says **Boate**, (p. 11.) may come up to ye very Walls. **Limerick** chiefly consists of one Street, of no great Width, & is for ye most part Stone-building. **St Munchin's**, & **St John's**, ye only Churches besides ye Cathedral; in ye Chancel of ye former, which was heretofore ye Cathedral founded by St Munchin ye 1st Bishop of **Limerick**, is a Monument for **Bishop Smith**'s Lady &c. just South of ye Altar; ye Bishop was bury'd here since, but as yet there is no Epitaph for Him. Smith built an house hard by, which **Bishop Burscough**, his immediate Successor, rents of His Executors; for ye Palace has these many years been leas'd-out, & is now ye Sign of ye 3 Tuns.[32](javascript:footNote('E730002-001/note032.html')) **St Mary's**, ye Cathedral is a large ancient Pile, it's Pillars large & inelegant, as usual here. In ye Choir are Galleries & Pews, ye Pulpit standing at ye upper end before ye Altar. North of ye Altar is a very large & stately Monument erected for an Earl of Thomond & his Lady, His Effigies defaced. Opposite to it, on ye South is ye recumbent Effigies on a rais'd Tomb (which is of much later Date & has an Inscription on it) of **Bishop Cornelius O'Dea**, who resign'd his Bishoprick in 1426, & dy'd in 1434. It is Alabaster, & ye people are continually cutting of it for ye Bloody-Flux. The Hymns only were chanted here both M. & E. A Parish sit in ye Choir, whose Church stood where ye Hospital is now; ye Dean will not suffer Them to contribute anything towards ye repair of ye Cathedral. **Mr Bendon** ye present Dean; his



---

p.43



Revenue, near 400 £ per Annum. Ye Bishop's 1800 £ per Annum. In ye Vestry, which is also us'd for a Chapter-house, is a Latin Inscription in old Irish Capitals, inserted in ye Wall; & there are other gravestones. No Monument for any Bishop but ye abovemention'd, tho' **Ware** informs Us that more were bury'd here. The Bishop of Limerick has also ye Title of Ardfert & Aghadoe. The Vicars Choral have no Houses, but Others have built upon their Ground, & pay 'em ground-rent. There is no Library here now. The Barracks are at ye ruin'd Castle.


Monday, 19. — From **Limerick** to **Cahirconlish**, 5 Miles; to **Pallace**, 4; to **Tipperary**, in ye County of **Tipperary**, 6; to **Goulding**, at ye Swan, 4 Miles. **Tipperary County**, excepting ye more Northern parts of it, is reckoned ye finest in ye Kingdom; and indeed ye large Vales here presented Us with more Barley, Flax, & Potatoes, than We had seen anywhere in Ireland, tho' of ye latter there is in most places Plenty enough. **Tipperary Town** stands in a Valley, a ridge of Mountain running-on by it, It is not incorporated, — the Assizes & Election of Members for ye County, are held at **Clonmell**. **Tipperary** is one Street of Stone, now upon the improving, and more Cabbins are to be taken down to make room for more Stone Houses. The Church here has a Steeple of Brick, tho' It be Itself of Stone; ye East Window is sash'd. **Goulding** is but a Village.


Tuesday, 20. — **Thomastown**, ye Seat of **George Matthew** Esq; is one Mile hence to ye left, in ye Road to **Tipperary**; 'tis suppos'd there are more Improvements in Planting about this Seat than any where else in Ireland; large Plantations of Fir, — and ye Water brought with no small Charge from a great distance: A ridge of Mountain runs-on to ye Garden-Front, Black Gravel in ye Garden-Walks. In ye Afternoon, at **Goulding**, (where ye Weather detain'd Us) We heard a strange Yell; and looking-out, there was a Coffin, a white Sheet spread over it, attended by a good number of people to a Malt-house opposite to our Inn. About 7 o'th' Clock I went into ye



---

p.44



place, every thing was preparing for ye Solemnity; at one end of ye Room was a Table spread with a white Cloth, on it Candles lighted, — and Spriggs of Rosemary, Some stuck in Candlesticks &c. with a Plate of Half-Pence: on one side stood a Stool, on which a Bowl of Tobacco & Pipes; on t'other side ye Table, was ye Coffin on ye ground, ye Lid off, but ye Body cover'd; round about, sat Men, Women, &c. This They call a Wake,[33](javascript:footNote('E730002-001/note033.html')) or Waking a Corps; ye poorer Catholics always do thus, — in their own Cabbins, if large enough; but This of ye Deceas'd not being so commodious, They borrow'd my Landlady's empty Malt-house: They smoke & howl interchangeably all night, sitting by ye Corps; in ye morning I'm told their Priest comes, & performs some ceremonies, & then They carry ye Dead to it's Grave, ye Priest attending to ye Church-Yard Gate. Every one that comes to ye Wake, except very poor, pays his Half-penny; ye expence of ye Candles & Tobacco is defray'd with This. I paid my Penny for intruding, & was offer'd a Pipe of Tobacco. One Woman softly groan'd-out — ahone, ahone, ahone. From **Goulding** to **Cashel**, at ye Crown & Thistle, 2 Miles.


Wednesday, 21. — As **Mr Matthew** was not at home yesterday when We were at his house, and We left ye letter We had to Him, — this morning very early He sent a Servant with a letter, desiring Us to return to **Thomastown**, that He might Himself shew Us ye place. We return'd ye complement for It would have been inconvenient to have gone-back. He had sent his Servant after Us to **Goulding** last night, when We were on ye road to **Cashel**. **Cashel City** is more compact than **Tipperary**, but built of ye same materials. It has Walls & Gates, but is in want of Water. Without ye town, on a rocky & steep hill much expos'd to winds, stands ye once very



---

p.45



strong Castle[34](javascript:footNote('E730002-001/note034.html')) & Cathedral, Both one Building, to be seen many miles about ye Countrey, for from hence You have a view of ye golden Vale, &c. A wall runs round ye top of ye hill. Of ye Cathedral at present ye Choir only is roof'd & in repair, which is indeed long & lofty; ye Stalls &c. plain; They were put up by **Archbishop Palliser**, who was in other particulars a Benefactor to this Fabrick, before His time so ruin'd by ye Wars, as to be unfit for divine Service. And even now, there is not above twice a year any Use made of it, that It is not kept so neat & clean as might be otherwise expected. In a South arch is ye recumbent Effigies of **Bishop Miler Magragh**, who dy'd in 1622; a Monument to ye North for another Bishop They say, but ye Inscription is chizzel'd-out. A stone here with ye figure of a Religious cut on it, his hands join'd in a praying Posture. The very low Tower stands on fine lofty Arches before ye Entrance of ye Choir. **King Cormac**'s Chappel on ye South side of ye Choir has no Timber in or about it; it is evidently older[35](javascript:footNote('E730002-001/note035.html')) than ye Cathedral & Castle; ye truth is that about ye time of ye coming of ye English, **Donald O Brian King of **Limerick****, building a new Church from ye ground, converted this old Church of Cormac into a Chappel. Cormac was King & Bishop of **Cashel**, ye ancient Metropolis of Munster, was slain in 908, & bury'd at **Cashel**. The Vestry is decay'd, & They have no Bell here. The Castle joins on ye West to ye Cathedral. Possibly ye Cathedral & Castle at **Old-Sarum** in **Wiltshire** was much such another Building. Cover'dways still remaining, & a Bog-house with a vaulted room of very great *height*. To ye South is a stone, on which ye defaced figure of St Patrick; & They call ye Cathedral at **Cashel** which is dedicated to St Patrick — **St Patrick's Rock**, or barely ye Rock. The town lies South East from it, thence ye Cathedral has much ye look of That at **Kilkenny**, there being also a Beacon to ye North East of it. 'Tis a Tradition that ye Kings of Munster us'd to be proclaim'd at a Stone in ye ascent to ye Rock, but at present 'tis contested Which of two Stones is It.



---

p.46



There are no Ecclesiastical houses, but ye Palace & Deanery; ye former is a large & handsome new house within ye City, not built in ye same place as ye old Palace, ye remains of which afforded some Materials to ye new building. The present **Archbishop Bolton** lives in a very hospitable open manner. The very ancient See of **Emly** is united to **Cashel**. **Wedderby** *[Wetherby]* is ye Dean, his place worth between 400 & 500 £ per Annum. The Choir is endow'd, whenever It shall be restor'd; for Salaries at this time are paid out to Persons, suppos'd to sing in it. There is a Throne for ye Bishop in St John's, ye only Church in ye town; **Archbishop Palliser** erected this Throne in 1717. Part of ye Church is in ruins, unroof'd; in which part lies bury'd an Arch-Deacon under an handsome Tomb, but **Archbishop Thomas Fulwar** under a plain Tomb; He dy'd March 31. 1667, Aetate 74. In ye Cemetery, another as plain a Tomb for his immediate Successor, **Archbishop Thomas Price**, who dy'd in 1685. Of ye Frier's Abbey (as they call it) — 'twas of Dominicans — is still remaining ye Shells — & Tower built on Arches, Gravestones &c. here. **St. Francis' Abbey** has a Tower on Arches also. In a bottom, West of ye Rock, are ye very large ruins of **Hore-Abbey**, of Cistercians; Tradition will have, that from hence is a subterraneous Passage to ye Cathedral. Some of ye Stones of this Abbey were us'd in building ye present Palace.


From **Cashel** to **Ballysheelan**, 2 Miles; to **Longford-Pass**, in ye Province of **Leinster**, & in ye County of **Kilkenny**, 8; to **Ballyspellan Spaw**, 5; to **Durrow**, at ye George, 5 Miles. This Road on a Level. The Spaw is chalybeate, as I take it; an house built by it, affords room to Gentlemen & Ladies, who spend their time here agreeably for there is a large Dancing-Room and it's Situation is pleasant on ye top of a Mountain. It is at present in great request.


Thursday, 22. — **Colonel [Mr] Flower**'s Seat at **Durrow** was built in 1716 on Arches; 'tis a large & elegant building of a White Stone ye Offices answering regularly to ye Right & Left. It stands on a high ground, ye Walks in ye Woods very much admir'd. The Rooms are



---

p.47



not large, nor is there a grand Stair-case; indeed it is not all finish'd.[36](javascript:footNote('E730002-001/note036.html')) Pictures of ye present Lord Lieutenant, ye Duke of Dorset & his Dutchess, who were entertain'd here by **Flower**; He, according to ye general affected custom of ye Countrey, is call'd Colonel, bec. He has that Title in ye Militia. The Church at **Durrow** is a late Stone building. The **Irkin** runs here, and about a quarter of a Mile off is ye **Neor**, or **Neure**, which parts from ye **Queen's County**.


From **Durrow** to **Barnock-hill**, in ye **Queen's County**, 2 Miles; to **Athy**, in ye County of **Kildare**, 12; to **Brea**, 1 Mile. **Barnock-hill** is a Market-town, and all to day We rode up & down Hill.


Friday, Saturday, Sunday, & Monday, 23, 24, 25, & 26. — On Saturday We rode from **Brea** to **Castle-Dermot**, 4 Miles; to **Burton Hall**, 2 Miles. **Kilkai**, **Mr Dickson**'s, an ancient Castle, is before ye town of **Castle-Dermot**, as You go out from which is ye large Shell & Tower of a Religious house.[37](javascript:footNote('E730002-001/note037.html')) We had seen this **Mr Dickson** at **Colonel Nevil**'s in ye begining of ye Month. **Burton hall**, ye Seat of **Alderman Burton** of Dublin, is a stone house, commanding good Prospects; ye Apartments but small; in ye Hall is a Painting of **Curtius** leaping into ye Gulf; tho' but coarse, yet two of ye figures deserve notice; One man so struck with horror, as not to be able to bear ye Sight, Stretching-out his hand with detestation, & averting his head; an other, in wild amaze, almost stiffens at ye sight, his Eyes all ye while fix'd full upon ye Hero. The Gardens are handsome; ye Water-works, tho' not large, are very pretty; wide shady Walks between Trees; a Park beyond ye Gardens. A Kitchen-Garden & Fruitery to ye front of ye house. We return'd to dinner to **Colonel Nevil**'s, who din'd with Us ye day before, when We had also ye company of Mr Henry Bumbery's Lady, of Mrs Spenser, & 3 of ye Plunkets her Neices, who indeed were with her, when We din'd at



---

p.48


**Belan**, June 7. On ye Sunday, We din'd with **Mr Nesbitt, Minister of **Athy****; **Dr Bradford, Minister of ye Bound-Church in **Dublin****, was there: Afterwards We went to Mr Thompson's, a Clergyman, & School-Master of **Athy**, whose Wife is a Relation of my Aunt's.


Tuesday, 27. — From **Brea** to **Kilcullen**, 10 miles; to the **Naas**, 5; to **Kildroghan**, at ye White Hart, 7 Miles. **Mr Carter**'s Seat at **Kilcullen** is a large Square house of Stone, new & handsome; ye **Liffy** runs by it; 'tis admir'd for it's Situation; according to ye grand way in Ireland, They call it **Castle-Martin**, ye general affectation to call their houses Castles: v. Swift, xvi. 408. Two Miles beyond ye **Naas**, We turn'd-out of ye Dublin Road, passing-by Bishop's-Court, **Lord Duncannon**'s. Just out of **Kildroghan** is much ye grandest house We have seen in Ireland — **Castle-Town**, ***Mr* Connolly**'s, built in 1725, of a bastard Marble dug-up about 15 Miles hence, but being unpolish'd It looks like a fair white Stone; This very lofty & deep house, taking up a great deal of Ground, stands upon Arches, has no less than 13 Windows in front, too many either for Beauty or Strength; on each side wind in a circular manner Stone Cloisters supported on Columns of ye Ionic Order; Butting ye Extremities of ye Cloisters are built of a darker Stone, and something higher than ye Cloisters, — on one side, ye Kitchen & Offices; on t'other, ye Stabling. The Rooms are large & well proportion'd, & as well furnish'd, tho' ye Inside be not finish'd throughout, for ye great Staircase is not yet begun, & some of ye Rooms have no Furniture, as ye long Gallery, proportionably wide. Here is a Length of ye Duke of Wharton, another of ye Duke of Grafton Lord Lieutenant, and his Dutchess, but a remarkably good Length-Painting of Lord-Chancellor West, in his Robes. There are a large number of Prints here, & some antique Seals taken-off in Wax, & put into Glass Picture-Cases. No Tapestry, but What was made at Dublin, ye figures are small, ye Colours very lively. The Garrets, or rather Rooms in ye uppermost Story, are exceeding good Apartments, All wainscotted & well furnish'd, ye Chimney-pieces of ye



---

p.49



Marble ye House is built of, which polish'd gives a grey cast. The **Liffy** flows below ye Fruitery.


Wednesday, 28. — From **Kildroghan** to **Newbridge**, 1 Mile; to **Lucan**, in ye County of **Dublin**, 1; to **Palmerstown**, 3; to **Chapel-Izod**, 1; to **Dublin**, at ye White-Hart in Capel-Street, 2 Miles. At **Chapel-Izod** on ye Left, & to ye North of ye **Liffy**, stands ye Countrey-Palace for ye Government — a brick Building.


Wednesday, Thursday, Friday, & Saturday, 28, 29, 30, July 1. — I call'd upon **Mr Rowlands** of ye Auditor's Office, to know of Him where I might procure his father's Book concerning **Anglesey**.[38](javascript:footNote('E730002-001/note038.html')) Willing to pick-up **Sir James Ware**'s Pieces, I waited upon his Grandson, **Henry Ware**, to be inform'd where I might apply for 'em. This Gentleman lives in **Stephen's-Green**; He may be about 50 Years of age, & is somewhat deaf. He was very obliging to Me, & told me that his Grandfather's Books were very rare to be met-with in Dublin, except upon ye Sale of any particular Study. He has His Book de Scriptoribus with some Additions, which (said He) would be proper to publish in a second Edition. He once had thoughts of publishing all **Sir James**'s Works in one Volume. **Dr Merrick** gave Me a letter to **Dean Percival**, his old Acquaintance in ye University; known to ye Dr also, as ye Dean's Mother marry'd for her Second Husband old Mr Aldworth of **Stanlake** near **Buscomb**. **Dean Percival** is a perfectly well-bred Gentleman, very gay & sprightly, ye best of Company, and of a most obliging Temper; We din'd with Him on ye Friday. He said that **Mr Ware** is a very curious Man, has collected several rare books, medals &c. His Study worth 3000 £. tho' None of it any part of **Sir James**'s — that **Harris**, who marry'd this **Ware**'s Daughter, was a Counsellor at Law, but has left his business, & is now digesting **Ware**'s Books into English, & proposes (by way of addition) to bring down ye History of Ireland to these Times. **Dr Worth** (said **Percival**) is a Physician of great generosity & desert, has carry'd ye Dublin Practise before him these 20 Years; He was of **Merton College**, his Father Provost of Dublin College. **Dublin**,



---

p.50


**Eblana**, is built of Brick; 'tis situate about ye middle of ye length of Ireland. **St Patrick's Cathedral** (out of ye City) **Ware** prefers for it's largeness, beauty, & magnificence to all ye Cathedrals in Ireland. 'Tis built in form of a Cross, a lofty Structure, it's Tower at ye West end, plain, & very high for Ireland,[39](javascript:footNote('E730002-001/note039.html')) so in ye Prospect of Dublin. It makes a good figure, tho' **St Werburgh**'s new and new-fashioned Tower seems to overtop It, That Church standing upon high Ground, whereas This is seated just by ye Butchery, in a low part of Dublin. 'Tis kept in excellent Order. Within, on ye North side of ye West Door is this Inscription (made by **Dean Swift**) in golden letters, over ye figure of a Bishop (inserted in ye Wall) vested and mitred: —
  


> 
> Verba ad marginem lapidis in-sculpta sic se habent.
>   
> 
> Jesus[40](javascript:footNote('E730002-001/note040.html')) est Salvator meus.
>   
> 
> "Praesul Metropolis Michael hic Dubliniensis
>   
> 
> "Marmore tumbatus. Pro me Christum flagitetis.[41](javascript:footNote('E730002-001/note041.html'))
>   
> 
> Vetus hoc monimentum e ruderibus capellae
>   
> 
> Divi Stephani nuper instauratae, erutum; Decanus
>   
> 
> et Capitulum huc transferri curaverunt. A:D: 1730.
>   
> 
> Michael Tregury, Cornubia natus,
>   
> 
> Archiepiscopus Dublin. A.D. 1449; Obiit 12[ordm ]
>   
> 
> die Decembris. A:D. 1471.
>   
> 
> Plura vide-sis apud Jacob. Ware de
>   
> 
> Praesulibus Hyberniae.
> 
> 
> 


In Ware's time this Monument was to be seen near St Stephen's Altar.


In a South Arch of ye Nave is a large & very handsome Marble



---

p.51



Monument for Primate **Narcissus Marsh** — who dy'd November 2. 1713, Aged 75; these three Lines are part of his Epitaph: — 

> 
> Pontanae[42](javascript:footNote('E730002-001/note042.html')) Domicilia duodecim aedificavit,
>   
> 
> Clericorum Viduis, sua imprimis Diaeceseos recipiendis,
>   
> 
> Commodam unicuique Pensionem annuam constituens.
> 
> 
> 


This annual Pension to each Widow is Twenty Pounds. There are 4 high Arches, which seem design'd for a Tower, just within ye Choir, which is very uncommon.[43](javascript:footNote('E730002-001/note043.html')) There are Titles over ye Stalls, — Decanus, on his right hand — Archidiaconus Dublin, then some Prebendaries, ye junior Stall for Cancellarius. The first Stall on ye left hand of ye Choir-Entrance is the Praecentor's, next Archidiaconus Glandelogh, then some Prebendaries, ye junior Stall for Thesaurarius. There are Galleries in ye Choir. Against ye North wall of it, is ye Effigies of **Archbishop Thomas Jones** kneeling, who dy'd in 1619. Under it, ye recumbent Effigies of **Roger Jones, Lord Viscount Ranelagh**. See **Borlase**'s Reduction of Ireland, p. 197. This Monument was ‘Impensis haeredum restauratum. A.D. 1731.’ v. Swift, xviii. 260, 372. Just South of ye Altar is a most grand Monument for ye family of ye Earls of **Cork**; It reaches almost to ye roof of ye Choir, consists of 4 Stories, in Each of which are ye Effigies of One or More, a great number in all; It wants to be new furbish'd up. See p. 268, 269 of **Cyprianus Anglicus**; & **Borlase**, p. 128, 129, 210; & Swift, xvi. 121. The Presbytery is call'd St Stephen's Chappel, and is made use-of by an Episcopal Congregation of French Protestants. The Deanery worth about 600 £ per Annum.[44](javascript:footNote('E730002-001/note044.html')) **Dr Swift** is also Vicar of **Laracor** in **Meath**, worth about 200 £ per Annum (v. **Deane Swift**'s essay on Dr S. p. 115. Approximately p. 52), which He had before He was Dean. He was made Dean in 1713. **Swift** was born in Bride-Street, Dublin; his father was an Attorney, v. **Deane Swift**'s essay on Dr S. p. 15. He was



---

p.52



64[45](javascript:footNote('E730002-001/note045.html')) Years old last St Andrew's day. The Deanery-house is a late good Building of Brick. The Archbishop's Palace, just by, is a large Stone house built at different times, known by ye name of St Sepulcher's. In Ware I find that **Henry de Loundres**, who dy'd Archbishop in 1228, erected ye Collegiate-Church of St Patrick (so It was created from a Parish Church by his immediate Predecessor **John Comin**) into a Cathedral united with ye Cathedral of Christ Church under one Spouse, saving to ye other Church ye preeminence in dignity; in consequence of which, Luke ye immediate Successor of **Henry de Loundres** ordain'd, that ye Election of Archbishop should be made in Christ-Church, where as well ye Prior & Convent of that Church as ye Dean & Chapter of St Patrick's by their joint Suffrages should choose ye Bishop. **Archbishop Richard de Ferings** took a great deal of Pains to reconcile ye differences which arose between ye 2 Churches, Ordaining that ye Archbishops should be consecrated & inthroned in Christ-Church; that Each Church should be call'd Cathedral & Metropolitan, that Christ-Church, as being ye Greater, ye Mother, & Elder Church, should take place in all Church Rights *[rites?]* & Concerns; that ye Cross, Mitre, & Ring of ye Archbishop where-ever he should die, be deposited in Christ-Church; & that ye Body of every Archbishop that dy'd for ye future, be bury'd in either Church by turns, unless He disposed of it otherwise by his Will. This Composition was made in 1300. Was It not that St Patrick's is by This stil'd Metropolitan too, Dr Percival's Conjecture would appear most plausible, that properly It is ye Cathedral to ye See of **Glandilaugh**,[46](javascript:footNote('E730002-001/note046.html')) annex'd to ye Archbishoprick of Dublin. That See was so annex'd in ye time of **Henry de Loundres**, who made St Patrick's a Cathedral. And farther, a contemporary Archbishop says that ye old Church of **Glandilaugh** which stood in ye Mountains, was then, & had been for almost 40 Years past, in desolation, and of a Church become a Den of Thieves



---

p.53



& Robbers; Murders being frequently committed — nay more than in any other place of Ireland — in ye vast Solitude in which It is situate. Now, ye dismal Condition of this Church, & ye dangerous State of ye Country about It, might give occasion to **Henry de Loundres** to make a Cathedral of St Patrick's, constituting It ye See of this newly annex'd Bishoprick. **Narcissus Marshes** public Library, call'd St Sepulchre's, South East of St Patrick's Church is a large brick Building; ye Library kept in admirable Order, The Reverend Mr King, ye Under-Librarian having compos'd a most exact & useful Catalogue; here is ye Picture of ye Founder, Sitting with a book before him, several books on Shelves by him. Mr King was very civil & obliging to Us. **Dean Percival** tells Me, that **Bishop Stillingfleet**'s Books cost ye archbishop 3000 £.[47](javascript:footNote('E730002-001/note047.html')) here are then all **Stillingfleet**'s printed Books, [his MSS. were purchased by ye Earl of Oxford; v. MSS. Harl. 1974, 13.] Tanaquil Faber's Books with some Manuscript Notes of That Critic in 'em, among these, ye Classics by ye most eminent Printers; Distinct from these 2 Studies, as They are from one another, is **Marshes** own private Collection. None of ye Books chain'd. There is a beautiful MS. here of Caesar's Commentaries. The Dean also tells Me that **Marsh** left his Oriental MSS. to ye Bodleian-Library, because That kind of Learning is less cultivated in Ireland, than in any other part almost of Europe. The Cathedral dedicated to ye Holy-Trinity, commonly call'd Christ-Church (says ye same Gentleman, who is one of ye Canons) is a very rich Society. It was originally built by **Sitricus Son of Amlave**, King of ye Danes, & Donatus, who was (say Some) ye first Bishop of Dublin, in ye Year 1038.[48](javascript:footNote('E730002-001/note048.html')) It was not 'till 1152, that ye Irish had Archbishops. Christ-Church is within ye City, has a Tower, is a lofty Structure.[49](javascript:footNote('E730002-001/note049.html')) South in ye Nave is ye recumbent Effigies of **Richard Strongbow, Earl of **Pembroke****, the first & prime Invader of Ireland 1169, & who



---

p.54



dy'd in 1177, having been a great Benefactor to this Fabrick. It was an Abbey of Regular Canons of St Augustine, till by Henry 8. turn'd into a Society of Dean & Prebendaries, ‘ye Charter They now act-upon is of ye 2d Year of James I.’ He is in Armour, has a Shield, lies cross-legg'd; by Him his Son cut off by ye middle, (See **Borlase**, p. 2) [1733. July.] and holding up his Bowels in his hands. The Choir is long, has Galleries & Pews,[50](javascript:footNote('E730002-001/note050.html')) where is ye Lord Lieutenant's Seat, on his Right hand ye Lord Primate's, on his left ye Lord Chancellor's; for since ye new Settlement of this Church by Henry 8. It has been in ye nature of a Royal Chappel, and the Cathedral of St Patrick's is now only look'd upon as Such, says **Stephens** in his Monasticon Hibernicum, p. 5. There are no Titles over ye Stalls. The Bishoprick of **Kildare** not exceeding 300 £ per Annum, This good Deanery is anex'd to it; vide Primate Boulter's Letters i. 139, 141, 143. On ye floor in ye North of ye Choir are ye brass Effigies of a Primate, They say, ye Inscription gone; Q.? whether It be not rather John de St Paul, Archbishop of Dublin, who dy'd in 1362? No Presbytery here. That part of ye North Isle towards ye East is call'd ye Parish-Chappel, dedicated to St Michael or St Mary, (q? Which) & every morning there is Service in it; here is a Monument with a long Latin Inscription for a Loyalist of ye Cadogan family. Trinity-College out of ye City Gates, stands on ye same Spot where All-Saint's Priory of Regular Canons of St Augustine heretofore stood. It consists of 4 Courts with a Yard before 'em. The Front is an extended Brick building, partly sash'd. The 2d & 3d Courts lying in a Line are smaller. The 4th Court has two handsome large sides of Brick, Sash'd; on ye Right hand, a most noble & elegant stone-building of great length, support'd on rustick Arches. The beauty of ye Wings destroy'd by 2 parallel Sides of ye Quadrangle butting against 'em. It is to be a Library, for as yet ye Inside is unfinish'd, the Cases of Shelves very high, above Them a Gallery runs all round.



---

p.55



At ye farther end above, is a room design'd for their Museum of Curiosities, under it below a Repository for MSS. The Hall & Chappel, Both of Stone (as is ye Kitchen) have nothing extraordinary; in ye Ante-Chappel, on a rais'd Tomb ye recumbent Effigies of *[one of]* ye first Provost*[s]*; on ye other side ye Door, to ye left hand, is a Monument for **Provost Dr George Browne**, who dy'd in 1699. The Chymical Laboratory has a very good Apparatus; ye little Room next to it is full of Curiosities, Such as rare herbs pasted on Paper in glass picture-Cases; but These are to be remov'd to ye Museum. Above Stairs, ye Anatomy-School, from ye Cieling hangs ye Sceleton[51](javascript:footNote('E730002-001/note051.html')) of a Man astride ye Sceleton of an horse. Pleasant Outlets behind ye College. The Provost's name is Baldwin. Most of ye Scholars wear Hats, Many their Gowns thrown-over ye Shoulders, ye Batchelor's Gowns are slit-up in ye Sleeve like Those at Cambridge; in farther conformity to which place, their independent Members are stil'd Fellow-Commoners, Pensioners, & Sizers. In ye wide Area before You come to ye College is an Equestrian Statue of King William, erected by ye Citizens; v. Swift, xx. 138, note. Nigh ye College ye Houses of Parliament with ye Court of Requests, Comittee-Rooms &c. begun about 3 Years since, nor yet finish'd; it is a Stone-Building, ye House of Commons under a large Cupola, the Room is a beautiful easy Octogon, of very obtuse Angles; Galleries all round at top. The House of Lords is a Length, & not large.[52](javascript:footNote('E730002-001/note052.html')) The King's Castle on a Rise, consists of two Courts, is chiefly of Brick, & not old; one brick Row of building in ye 2d Court contains ye Auditor's Office, ye Offices of Ordnance, &c. Over ye Liffy are several bridges with Stone Arches; on Essex-Bridge, ye Chief, is an Equestrian Statue of George 1; v. Swift, xxiv. 419. The Linnen-Hall is a brick building. The Custom-house is a very lofty, & in other respects a large, building of Brick. The Royal Hospital of



---

p.56



King Charles II. or (as 'tis commonly call'd) ye Old Man's House, is of ye same nature as Chelsea-College: 'tis a Quadrangle of Stone, cloister'd, ye Windows faced with Brick. Situate high; from ye Tower You have a good view of ye City & Countrey. 400 Men always resident, with 600 Out-Pensioners, make ye Complement of disabled Soldiers, provided-for by this foundation, to be 1000. Each room has 3 beds; 2 Men to a Bed. The Hall or Refectory is as lofty, & every way as well proportion'd a room as can be, adorn'd with 20 Length-Paintings of Benefactors, One of 'em is **Narcissus Marsh**, Standing, Others are **Primate Boyle**, the Earl Coningsby, Sir Cyril Wich, General Earle, &c. Arms of different sorts orderly dispos'd along ye Wall. Over ye Door on ye inside is a well-carv'd Trophy of Musical Instruments. The Chappel in ye same line as ye Hall has a fretwork Cieling admirably perform'd, seldom to be seen more work in so small a Compass; 'tis much ye richest fret-work Roof that I ever saw; ye Altar-piece is good Wood-work. The Poor-house not only sets ye Poor at work, but is also a Receptacle for ye Foundlings of ye City; v. **Harris**'s History of Dublin, p. 439. From ye Road You see ye Barracks, very large Stone buildings of late date, Part cloister'd; They seem to be no small ornament to Dublin. Some of ye City Churches are Sash'd; here is one round Church. Great Ships cannot come up to Dublin, except at high water, because of ye heaps of Sand that at ebb & flow are wash'd into **Liffy**'s Mouth. Piles are continu'd from ye land a great distance into ye Sea, as a direction to Mariners to avoid ye Beds of Sand.


The **White-Hart Inn** in Dublin, like ye Hotels in France, dresses no Meat for ye Guests; We had our Dinners brought Us from a Cook's Shop. At **Cork**, **Limerick**, &c. French Claret stood Us but in 1 s. 6d. a bottle; whereas it is 2 S. at Dublin but not dearer than That anywhere. As for Port Wine, They have none in ye Kingdom. In Ireland, a Shilling-piece goes for 13 pence, a Guinea goes for 23 Shillings English Value, or 23 Twelve-Pences, so that there is but 3 D gain, if You carry ye Irish Change of a Guinea into England, for 21



---

p.57



Shilling-pieces want but 3 pence of 23 Irish Shillings. A Moidore also goes for 30 S. English Value, or 30 Twelve-Pences. A four-Portugal-Guinea Piece (current in England at £3, 12s. 0d.) goes here for four Pounds. There is a great Scarcity of Coin in Ireland,[53](javascript:footNote('E730002-001/note053.html')) nay even in Dublin 'tis very difficult to get a Guinea changed; And This, tho' all kinds of Foreign Coin be current here, both in Gold & Silver, as Silver Ducats, &c. No great quantity of English Half-pence come over ye Channel; of their own Half pence, ye **Raps**, [see concerning **Rappers** in **Ray**'s Observations, p. 100.] of a bad Metal & Sandy, will not go, except at Coffee-houses, where They who give 'em, take 'em again; but They were very commonly offer'd to Us in change. As they have no Poors-Tax, Collections are made every Sunday from Pew to Pew thro' all ye Churches in ye Kingdom; at **Athy** It was after ye Sermon, for then ye Minister went to ye Altar, & ye Collections were made, whilst He was reading ye Sentences in ye Offertory[54](javascript:footNote('E730002-001/note054.html')); after which He proceeded with That Service; at **St Patrick's** in **Waterford**, ye Collections were made in ye second Psalm in ye Morning, as at ye Cathedral in ye last Psalm in ye Evening; at **Limerick Cathedral**, ye Collections were made in ye Psalm before Sermon in ye Morning, & in ye Psalm in ye Evening. See Swift, xv. 402. vi. 75.


In ye Irish Liturgy, after ye Prayer for ye Royal family, or in ye Litany after ‘We humbly beseech thee’, follows a Prayer for ye Government in Ireland, whether It be by a Lord-Lieutenant, or Lords Justices. There is also a Form of Prayer to be us'd on ye day of ye Irish Massacre. There are a good many ruinated Churches in ye Countrey, but few standing & fit for Service: Most have Steeples, Some for one, Some for two Bells. We saw no elegant Steeple, either Tower or Spire thro' all this Route, nor indeed any Spire at all, that could properly be call'd so. The Barracks are often ye finest



---

p.58



Buildings in ye Towns, they find Lodging both for ye Officer & common-Soldier, so that ye Army (far from being thought a Nuisance) is ador'd by ye Tradesmen, as their chief support in many places. The Officers dine at Ordinaries in ye Towns, ye common-Soldiers dress their own Meat in their Lodgings. Even thatch'd Houses are Sash'd in Ireland. You can enter no Town, but thro' a long Street of low mud Cabbins, (and very often not contiguous), most of 'em with Wicker-Doors, see p. 28. Every morning & evening You'll see a troop of women ride into ye Towns upon their little horses with Milk to sell. The men in some places affect—Spaniard like—to walk ye Streets with their great-Coats thrown-over their Shoulders, by way of Cloak. The ordinary Women wear long Nightrails of one kind or other about their Shoulders, Some are of White-Linnen, Some Stained, All Irish Manufacture. Most of the ordinary Men wear a dark frieze, Irish Manufacture also. When we had pass'd **Kilkenny**, ye common people were as observant of Us, as in Wales. The Irish Gentry are an expensive People, they live in ye most open hospitable manner, continually feasting with one another; They are well-bred, obliging, but proud enough; They always praise ye Dishes at their own Tables, & expect that ye Company should spare no words in their commendation. The common-people are notoriously idle; but few of ye meaner Sort (& among these, most Gentlemen's Servants) which are not Romans, most implicitly obedient to their Priests. A poor Girl, whilst We were at **Brea**, went on foot to **Kilkenny**, that She might be at an holy Well there on Midsummer morning, to pray her Sister out of Purgatory, who dy'd about 3 years since.[55](javascript:footNote('E730002-001/note055.html')) Irish Ground is not improv'd as It might be, yet much better than a few Years since. The South runs all upon Sheep-walks; sometimes You see a patch of excellent Corn, but ride many miles on farther, & You may meet-with no more.[56](javascript:footNote('E730002-001/note056.html')) Flax is ye support of Ireland; for



---

p.59



ye Linnen-Manufacture (as I'm told) is vigorously carry'd-on in ye North where They have Flax in abundance. **Bare**, a grain like Barley, (and indeed ye Anglo-Saxon **bepe** is render'd **hordeum**) is common in this Countrey;[57](javascript:footNote('E730002-001/note057.html')) Good farm-houses are not known in ye South for ye Shepherd-Tenants take up with Cabbins. Instead of Quicksets We often saw Furze-Hedges. Improvements is ye fashionable word for Plantations of Trees, even in Hedge-Rows. (See p. 43. T. 20. line 2.[58](javascript:footNote('E730002-001/note058.html'))) In some parts They plow with Oxen. There are no Carts or Waggons here, they have Carrs, which are a kind of Sledges, set on two solid wooden Wheels straked with Iron, & drawn by a single horse; they carry great Burthens, some 600 Weight. They differ from ye Welsh Carriages only in This, as *They* have no Wheels. These carriages are undoubtedly ye Best for preserving ye Road. Kid is as common a Dish here, as in Wales. The Irish & Welsh Harp is alike in shape, but ye former is strung with one row of Wire, ye latter with 3 rows of Cat-gut. The Irish Miles are much longer than ye Welsh; see Primate Boulter's Letters i. 211, 219. In ye Countrey-places You'll meet with Persons, who can talk Old Irish; with Them Sha is Yes — Ne-a is No. Even ye Gentry, when they are speaking to You, will call You *Honey*. They All give ye *ea* the full sound in pronunciation, so *Ear* they call *Air*. *al* They pronounce as *au*, so *caum* for *calm*; *ol* as *oul*, so *tould* for *told*; *e* also, very commonly like *a*, *sevare*, for *severe*.[59](javascript:footNote('E730002-001/note059.html')) Even ye Ladies make use of Expressions, bordering too near upon Swearing. *The Devil of*


---

p.60


*any* is a common Phrase with ye Vulgar, as — *the devil of any Entertainment is there.* So great is ye Pride[60](javascript:footNote('E730002-001/note060.html')) of these common People, that if a woman be of ye same name as some noble Family, She'll retain it in marriage, unless her Husband has as distinguish'd a name; ye Children however go by ye father's name. The great Vermin which at Reading they call Hanover Rats, go here by ye name of Norway Rats. There are now great numbers of Frogs about **Athy**; it is but of late years that Ireland has had any; in ye last edition of **Gibson**'s Camden, p. 1312. 'twas said they had none; they were introduced ('tis said) by Spawn; see ye history of this matter in a note upon Swift, xv. 309: Tatler. No. 236.


Sunday, July 2.— At half-hour after two in ye morning, We left ye Irish Coast in ye same Packet as We came in; being becalm'd for some hours about Noon, we did not reach ye Welsh Shore 'till 10 at night, a Passage of 19 hours & an half. Some Dispatches from ye Castle kept Us in Dublin so long, otherwise We had set sail on friday night; from that time We were kept in hopes of sailing every Tide, so We had pack'd up our Cloaths, & all this while were unfit to see or be seen; for Things could not be got ready 'till ye Sunday morning.














