

#An Irish Version of Gualterus de Dosibus


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


An Irish Version of Gualterus de Dosibus
========================================


Author: Walter de Agilon/Galterius Agilinus
-------------------------------------------


### File Description

Shawn SheahanElectronic edition compiled and proofed by Beatrix Färber

Funded by School of History, University College, Cork 1. First draft.Extent of text: 21190 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://celt.ucc.ie

 (2018) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T600021Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


Copyright for this edition lies with the estate of Shawn Sheahan.


#### Notes

*The original title is An Irish version of Gaulterus de Dosibus. This contains a typo, 'Gaulterus', and has been corrected in the electronic edition to 'Gualterus'.* I am very grateful to Mrs Maureen Crowley, Leap, Co. Cork, a niece of Shawn Sheahan, who donated a copy of the book, for her kind permission to publish this material in electronic form on CELT, and to Professor Aoibheann Nic Dhonnchadha who made it possible. The book can be considered a rare book: a search on Copac shows that within The UK and Northern Ireland it is listed in only seven libraries. (Irish Libraries apart from TCD have not joined COPAC.) My sincere thanks are also due to to Dr Mirko Hanke, Academic Librarian of the Leopoldina in Halle, Germany, for sending me the introduction of Paul Diepgen's Gualteri Agilonis Summa medicinalis (Leipzig 1911). I have not been able to locate a printed Latin edition of the De Dosibus; however for digital images of the Latin manuscript Sheahan consulted, see below under 'Manuscript sources for De dosibus medicinarum', no. 12. The work is regarded as mainly derivative. (See Introduction).

Biographical Note: ‘Shawn Sheahan was born in Ashford, County Limerick, Ireland, on January 21, 1901. Having at the age of fourteen completed his course in the national school he devoted six years to helping on his father's farm; a year to farming among the Gaelic speakers of Ballyferriter, where he became conversant in his native tongue; and a year in Musgrave's School, Newcastlewest, County Limerick, and Ring Gaelic College, County Waterford. Afterwards he became a pharmacist's apprentice for a period of three years. In January, 1927, he came to Washington, D. C, where, in October of that year, he passed the Board of Pharmacy Examination. In September he entered George Washington University as a part-time special student from which he graduated in June, 1934. The following September he entered the Catholic University of America, where he pursued courses in Philology under doctors Geary, Lane, and Fry.’

Green, Trotula, 67, translates the weights and measures given in the Antidotarium Nicolai (see van den Berg, p. 191) as follows ‘A scruple is the weight of twenty grains. Two scruples equal forty grains, and three scruples equal sixty grains. Three scruples collected equal one dram. (...) Eight drams make one ounce. And 108 drams make one pound.’

#### Sources


**MS sources for Irish translations of 'De Dosibus Medicinarum'**- British Library, London, Harley 546, ff1–11. (For details see Standish Hayes O'Grady, Catalogue of the Irish Manuscripts in the British Library, reprint, 2 vols (Dublin: Dublin Institute for Advanced Studies, 1992), 171–177. It is complete. A colophon is added naming Cormac Mac Duinnshléibhe as the translator who put the summary into Irish for Dermot mac Donall O'Lyne, in Cloyne (Co. Cork), in 1459. For sample pages see http://www.bl.uk/manuscripts/FullDisplay.aspx?ref=Harley\_MS\_546.- Trinity College Library, 1326 (H. 3. 7.), ff 1–15b5. It is complete. For details see ISOS Project. *Digital images of this manuscript are available on the ISOS Project, Dublin Institute for Advanced Studies, see: http://www.dias.ie/isos/.*- Trinity College Library, 1436 (E 4.1.) pp 296–310a. It is complete. For details see ISOS Project. *Digital images of this manuscript are available on the ISOS Project, Dublin Institute for Advanced Studies, see: http://www.dias.ie/isos/.*- Trinity College Library, 1436 (H 2 12), no. 13. It is incomplete. For details see ISOS Project. *Digital images of this manuscript are available on the ISOS Project, Dublin Institute for Advanced Studies, see: http://www.dias.ie/isos/.*- Dublin, Royal Irish Academy, MS 445 (24 B 3) (17–28).It is incomplete. For details see ISOS Project. *Digital images of this manuscript are available on the ISOS Project, Dublin Institute for Advanced Studies, see: http://www.dias.ie/isos/.***Manuscript sources for De dosibus medicinarum [incipit: Medicinarum quedam sunt simplices.] See http://www.mirabileweb.it/calma/galterius-agilinus-fl-saec-xiii-med-/2578.**2. Cambridge, King's College 21 [sec. XIII–XIV (1272–1327)], f. 88.
3. Dublin, Marsh's Library Z.4.4.4 [sec. XIV first half], ff. 185ra–192ra.
4. El Escorial, Real Biblioteca de San Lorenzo de El Escorial p.II.5, ff. 74–79.
5. Firenze, Biblioteca Riccardiana 878, ff. 5ra–8vb.
6. Kraków, Biblioteka Jagiellonska 778 [ca. 1425], ff. 59r–64r.
7. Kraków, Biblioteka Jagiellonska 823 [post XIV med.], ff. 98r–101r.
8. Leipzig, Universitätsbibliothek 1166 [sec. XIV first half], ff. 78v–87r.
9. Leipzig, Universitätsbibliothek 1227 [a. 1474], ff. 168r–172r;.
10. London, British Library, Harley 3371 [sec. XV ex.]
11. London, Wellcome Library (olim Wellcome Historical Medical Library) 559 [sec. XV med.], f. 9.
12. München, Universitätsbibliothek, 2576 [a. 1383].
13. München, Bayerische Staatsbibliothek, Clm 325. USED BY SHEAHAN. Provenance Northern Italy. It contains the De Dosibus on ff 79r to 83ra, 238r to 246v. In this manuscript mentioned by Littré, Histoire litt. de France, Walter is called 'Salernus'. Digital images are available at the Digitalisierungszentrum of the Bayerische Staatsbibliothek München (Munich) http://daten.digitale-sammlungen.de/0007/bsb00073571/images/index.html?fip=193.174.98.30&id=00073571&seite=1
14. Paris, Bibliothèque Nationale de France, lat. 14026 [sec. XIV], ff. 89v–90v.
15. Paris, Bibliothèque Nationale de France, lat. 16191 [sec. XIV], ff. 202–207.
16. Paris, Bibliothèque Nationale de France, lat. 6957 [a. 1429], ff. 100v–108.
17. Paris, Bibliothèque Nationale de France, lat. 6964 [a. 1305 Montpellier], ff. 93v–96.
18. Paris, Bibliothèque Nationale de France, lat. 7051 [sec. XIV], ff. 56–62v.
19. Paris, Bibliothèque Nationale de France. Bibliothèque de l'Arsenal 1025 [sec. XIV], ff. 141–144v.
**General background and works by Walter of Agilon (Gualterus Aguilonis**2. Bartholomew Parr, The London Medical Dictionary (Philadelphia 1819).
3. Francesco Puccinotti, Storia della Medicina (Livorno 1855).
4. Salvatore De Renzi, Collectio Salernitana, 5 vols, (Naples 1852–1859).
5. Robley Dunglison, Medical Lexicon: A Dictionary of Medical Science (London 1860).
6. Julius Pfeffer, Das Compendium urinarum des Gualterus Agulinus. Inaugurtal-Dissertation (Berlin 1891) [Nach einer Handschrift der Amploniana].
7. Paul Diepgen (ed) , Gualteri Agilonis Summa medicinalis: nach den Münchener Codices lat. Nr. 325 und 13124 erstmalig ediert mit einer vergleichenden Betrachtung älterer medizinischer Kompendien des Mittelaters (Leipzig: Barth 1911).
8. Heinrich Schipperges, Die frühen Übersetzer der arabischen Medizin in chronologischer
Sicht. Sudhoffs Archiv f. d. Geschichte der Medizin 39 (1955) 53–93.
9. Heinrich Schipperges, Zur Rezeption und Assimilation arabischer Medizin im
frühen Toledo. Sudhoffs Archiv f. d. Geschichte der Medizin 39 (1955) 261–283.
10. Heinrich Schipperges, Die Assimilation der arabischen Medizin durch das lateinische
Mittelalter. Wiesbaden 1964 (= Sudhoffs Archiv, Beiheft 3).
11. Danielle Jacquart and Agostino Paravicini Bagliani (eds), La Collectio Salernitana di Salvatore De Renzi. (Florence 2008).
12. Peter Wyse Jackson, Ireland's Generous Nature. Missouri Botanical Garden Press, 2014.
13. Gian Carlo Garfagnini, Claudio Leonardi, Michael Lapidge (eds), C.A.L.M.A.: Compendium Auctorum Latinorum Medii Aevi: 500–1500. 5 vols. (Florence 2000–2017.)
**A selection of secondary literature (suggestions are welcome)**2. Lynn Thorndike and Francis C. Benjamin (eds), The Herbal of Rufinus (Chicago 1946).
3. Francis Shaw, S. J., 'Irish medical men and philosophers', in: Seven Centuries of Irish Learning, 1000–1700, ed. by Brian Ó Cuív (Cork: Mercier Press 1971).
4. Dietlinde Goltz, Studien zur Geschichte der Mineralnamen in Pharmazie, Chemie und Medizin von den Anfängen bis Paracelsus (Wiesbaden 1972).
5. L. García-Ballester, J. A. Paniagua, M. R. McVaugh (eds), Arnaldi de Villanova Opera medica omnia, Volume 2; Volume 5 (Barcelona 1975).
6. Dietlinde Goltz, Mittelalterliche Pharmazie und Medizin. Dargestellt an Geschichte und Inhalt des Antidotarium Nicolai. Mit einer Druckfassung von 1491 (Stuttgart 1976).
7. Nessa Ní Shéaghda, 'Translations and Adaptations in Irish' (Statutory Lecture 1984, School of Celtic Studies), (Dublin: Institute for Advanced Studies 1984).
8. Tony Hunt, Plant names of Medieval England (Cambridge 1989).
9. A. Bauer, 'Gualtherus Agulinus'. In: Lexikon des Mittelalters, IV, 1989, column 1760.
10. Aoibheann Nic Dhonnchadha, 'Irish medical manuscripts', Irish Pharmacy Journal 69/5 (May 1991) 201–2.
11. Aoibheann Nic Dhonnchadha, 'Irish Pharmaceutical Texts', Irish Pharmacy Journal, 69 (1991), 274f.
12. W. F. Daems, Nomina simplicium medicinarum ex synonimariis Medii Aevi collecta. Semantische Untersuchungen zum Fachwortschatz hoch- und spätmittelalterlicher Drogenkunde (Leiden 1993).
13. Michael Rogers McVaugh, Medicine before the Plague: Practitioners and Their Patients in the Crown of Aragon: 1285–1345, Cambridge Studies in the History of Medicine (Cambridge 1993).
14. Michael Rogers McVaugh, 'Medical Knowledge at the Time of Frederick II', in: Le scienze alla corte di Federico II. Sciences at the Court of Frederick II = Micrologus. Natura, scienze e società medievali. Nature, Sciences and Medieval Societies. Rivista della Società Internazionale per lo Studio del Medio Evo Latino Firenze 2 (1994) 3–17.
15. Margaret R. Schleissner (ed), Manuscript sources of medieval medicine: a book of essays (New York: Garland 1995).
16. Mirko D. Grmek, Bernardino Fantini (eds), Western Medical Thought from Antiquity to the Middle Ages. [Translated from the Italian by Anthony Shuugar.] (Cambridge, Massachussetts: Harvard University Press 1999).
17. Jerry Stannard, Herbs and Herbalism in the Middle Ages and Renaissance; edited by Katherine E. Stannard and Richard Kay. (Aldershot 1999).
18. Jerry Stannard, Pristina medicamenta: ancient and medieval botany; edited by Katherine E. Stannard and Richard Kay. (Aldershot 1999).
19. D. R. Langslow, Medical Latin in the Roman Empire, (Oxford 2000).
20. Fergus Kelly, 'Medicine and Early Irish Law', in: J. B. Lyons (ed), Two thousand years of Irish medicine (Dublin 1999) 15–19. Reprinted in Irish Journal of Medical Science vol. 170 no. 1 (January–March 2001) 73–76.
21. Monica H. Green (ed) and trans, The Trotula: a medieval compendium of women's medicine (Philadelphia: University of Pennsylvania 2001). See especially the Appendix on Compound medicines, pp 193–204.
22. Aoibheann Nic Dhonnchadha, 'Medical writing in Irish', in: J. B. Lyons (ed), Two thousand years of Irish medicine (Dublin 1999) 21–26. Published also in Irish Journal of Medical Science 169/3 (July–September 2000) 217–20.
23. Christopher J. Duffin, 'Lapis Judaicus or the Jews' stone: the folklore of fossil echinoid spines', Proceedings of the Geologists' Association 117:3 (2006) 265–275.
24. Peter E. Pormann and Emilie Savage-Smith, Medieval Islamic Medicine (Washington D.C. 2007).
25. Wolfram Schmitt, Medizinische Lebenskunst: Gesundheitslehre und Gesundheitsregimen im Mittelalter (Berlin 2013).
26. Peter Wyse Jackson , Ireland's generous nature: the past and present uses of wild plants in Ireland (St. Louis, Missouri 2013).
27. NB: A short text by Iohannes Ibn Mesue is in parts very similar to this. See Traducciòn catalana anònima Ms. Paris, BN, Español 508, ff. 57a–61a, inc. 'Practica segons Johan Eben Mesue' (available at sciencia.cat/biblioteca/documents/Parma\_Ferre.pdf
28. Juhani Norri, Dictionary of Medical Vocabulary in English, 1375–1550: Body Parts, Sicknesses, Instruments, and Medicinal Preparations (Oxford 2016).
**Online sources**2. Dictionary of the Irish Language, mainly compiled from Old and Middle Irish materials: eDIL. See http://www.dil.ie/.
3. Francisco Cortés Gabaudan, Jesús Ureña Bracero, Dicciomed.eusal.es. Diccionario médico-biológico, histórico y etimológico. 2004. Universidad de Salamanca. See http://dicciomed.eusal.es/comosecita.php.
4. MIRABILEWEB: Archivio Digitale della cultura medievale (Digital Archive for Medieval Culture) http://www.mirabileweb.it/index.aspx.
5. LOGEION, A Dictionary incorporating several dictionaries of Greek and Latin at the University of Chicago http://logeion.uchicago.edu/.
6. Alcuin Infothek der Scholastik: a database about scholastic authors, their works and reception. Intended as a research tool and hosted at the University of Regensburg (in German) http://www-app.uni-regensburg.de/Fakultaeten/PKGG/Philosophie/Gesch\_Phil/alcuin/index.php.
7. The Jesuatti Book of Remedies, or, Libro de i Secretti con Ricetti. Compiled by Friar Giovanni Andrea of the Order of the Jesuati Friars of Saint Jerome in Lucca, Italy in 1562. Translated and with notes by Stata Norton. Electronic edition published by the Center for Digital Scholarship, University of Kansas Libraries, 2010. Available at ttp://etext.ku.edu/view?docId=jesuatti/jesuatti.xml;brand=jesuatti;route=jesuatti;.
8. Johan Yperman (c. 1260– c. 1331), a Flemish surgeon and the first medical writer in Dutch, wrote a 'Cirurgie' that was edited in 1912 by E.C. van Leersum. Pages 234ff. of this edition contain an explanatory glossary. The work is digitally available at the Digitale Bibliotheek voor de Nederlandse Letteren (http://www.dbnl.org/) see http://www.dbnl.org/tekst/yper003ecvl01\_01/yper003ecvl01\_01\_0204.php
9. The Digitale Bibliotheek voor de Nederlandse Letteren (http://www.dbnl.org/) also has an edition of the Antidotarium Nicolai (including a Middle Dutch version) online. This was edited from Mss 15624-15642 from Brussels, Kon. Bibl. by W.S. van den Berg (Leiden 1917); see http://www.dbnl.org/titels/titel.php?id=\_ant004anti01.
10. Dioscórides Interactivo: the Salamanca Dioscorides (De materia medica), Unversidad de Salamanca. Estudios y Traducción del Dioscórides, Manuscrito de Salamanca. Traducción: Antonio López Eire y Francisco Cortés Gabaudan. Con estudios de Bertha Gutiérrez Rodilla y Maria Concepción Vázquez de Benito. Editor y coordinador Alejandro Esteller. Available at http://dioscorides.usal.es/.
**The edition used in the digital edition**2. An Irish Version of Gualterus de Dosibus. Shawn Sheahan (ed), First edition [1 volume; 185 pages. Preface 9–13; Signs 15 (i.e. variants common to a particular group of manuscripts); Abbreviations 17–19; Specimen pages of the MSS 21–25; Corrections 26; Introduction 27–44, Irish text with facing English translation 46–119, Variants and Notes on Text 121–145; Glossary 147–180; Bibliography 181–183.] Catholic University of America Washington, D. C. (1938)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text represents odd pages 47–119 of the book. Endnotes are in general not retained. The Irish version is available in a separate file, G600021.


#### Editorial Declaration


##### Correction


Text has been checked and proofread once. All corrections and supplied text are tagged. Note: the variant readings have not been provided in the Irish text since their manner of recording, explained by 27 different signs by the editor (15) is rather cumbersome in the edition. Therefore, what is presented here is a reconstruction of the Irish text by the editor, a textus conflatus, including all manuscripts. As the editor remarked (27), the original translation by Cormac Mac Duinnshléibhe is not extant. A number of explanatory footnotes have been added at CELT.


##### Normalization


The electronic text represents the edited text. Where Latin text is cited, it is often misspelled in the manuscript (this occurs rather often in Irish medical tracts) and has been left to stand. Text supplied by the CELT editor is marked sup resp="BF".


##### Quotation


Quotations from written works are rendered q. The citations refer to manuscripts and in the main, have not been identified.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break have been placed on the line on which they start.


##### Segmentation


div0=the whole document; div1=the editor's paragraph. Paragraphs are numbered in line with the printed edition, page-breaks are marked pb n="".


##### Interpretation


Names of persons and titles of works are tagged. So are many terms from medicine, pharmacy and anatomy. Words from Latin and Greek have been tagged as such.


#### Canonical References


This text uses the DIV1 element to represent the paragraph. ### Profile Description


Created: The Latin original was written c. 1240–1250; the Irish translation by 1459; and the English translation by 1938.#### Use of language


##### Language: [EN] The introduction and translation are in English.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [GR] Some words are in Greek.


##### Language: [GA] One quote in the Introduction is in Early Modern Irish.


### Revision History


* (2018-01-17) Beatrix Färber (ed.)

* File proofed (2) online. More encoding applied for medical, botanical and pharmaceutical terms, explanantory footnotes and bibliographic items added; file reparsed.
* (2017-12-06) Beatrix Färber (ed.)

* Introduction written using information from Paul Diepgen's preface. File parsed and validated. SGML and HTML versions created.
* (2017-12-06) Beatrix Färber (ed.)

* TEI header created with bibliographical details.
* (2017-10-10) Beatrix Färber (ed.)

* File encoded in accordance with CELT standards: encoding and numbering of divisions, subdivisions and headings. Limited amount of content encoding applied for personal names, book titles, place names; Latin phrases, Greek words, supplied text, footnotes; minor changes made to spelling.
* (2017-10-09) Beatrix Färber (Capture)

* File captured by scanning. File converted to XML and proofed (1).




---


#### Corpus of Electronic Texts Edition: T600021


### An Irish Version of Gualterus de Dosibus: Author: Walter de Agilon/Galterius Agilinus


### Introduction: Walter of Agilon (fl. 1250) and his works.


Not much is known about this author. His name has many variants: Galterius Agilus or Agilinus, Gualterus (de) Agilis or Agilinus or Agilonis or Agilon or Agulum, Agulinus, Gautier d'Agiles, Gualterus de Afguillo, Valtherus Agilo, Walter de Agilon, Walter of Agilon, Walter Agilo, Walter de Agelon, Walterus Agulinus, Walterus Agulum, Waltherus Medicus, Waltherus Salernitanus have all been used.


In *Alcuin* and MIRABILEWEB we find the following medical tracts, all undated, attributed to him: Compendium urinarum; Contenta urinarum; De contentis urinarum; De dosi medicinarum; De urinis; Febres (=Tractatus de febribus); Glossule super versus Egidii; Liber pulsum (=Liber de pulsibus); Modus iudicandi urinas; Summa medicinalis (=Practica medicinalis). The Compendium urinarum was edited by J. Pfeffer in 1891, and the Summa medicinalis by Diepgen in 1911. For the remaining tracts there are no editions recorded. Even the new focus of popular wisdom, Wikipedia, has as yet (December 2017) no entry on him. So when Diepgen complained, over a hundred years ago, that **Walter of **Agilon**** was neglected this still rings true.


His nationality is uncertain, and Diepgen hinted at a Spanish background, based on the name Aguilon ‘which is very common in that peninsula, and the mentioning of Spanish coins’ (5) in the Summa, though Francesco Puccinotti in Storia della Medicina suggested that he was French. There is in fact a community of Aguilón in Zaragoza, Aragón, which settlement was established by the 12th century at latest, but no research has been done in this respect. (As Michael McVaugh has pointed out (1), due to the existence of a medieval papermill in Xàtiva (Valencia), which was part of the Kingdom of Aragón, there was a ‘remarkable series of royal and municipal records’ made for the crown of Aragón still extant in the archives.) Walter was given the epithet ‘Salernus’ in Clm 325, fol. 36v–38v. He is accepted to have been active between 1240 and 1250, and according to De Renzi ( Collectio Salernitana, I, 293) he may have been a witness in a document written in 1272. Diepgen characterises the De Dosibus as a pharmacological tract in the arabistic manner, written before the Practica medicinalis, as it is cited there. The editors of Arnaldi de Villanova Opera medica omnia call it ‘simply a close paraphrase of Haly Abbas' rules in the Pantegni for compounding medicines’ (29). This may be one of the reasons why it has not attracted more interest.


Diepgen names Walter's Summa as his longest and most important work, as Walter strove to provide a practical guide for treating all illnesses, diseases and ailments, including the most pertinent sections of surgery and obstetrics, at a time when the teaching of the scholastics began to gain ground in the art of healing (6). The Summa shows strong Arabic influence.


However, from an Irish perspective De Dosibus holds a lot of interest, too, firstly for the terminology that has been used, or even created, by Cormac Mac Duinnshléibhe. He participated in shaping and consolidating Irish medical, anatomical, pharmaceutical and botanical terms, being a prolific translator whose works were often copied. But there is quite a number of terms that have not yet made their way into Irish dictionaries. Terminology appearing in Sheahan's glossary on pp 147–178 was not excerpted to add entries in the Royal Irish Academy's Dictionary of the Irish Language (edited between 1913 to 1976, when it was finally published). This is evinced by the fact that De Dosibus does not appear in the sources listed there.


Secondly, it tells us a lot about the reception of medieval medical literature. De Dosibus was just another work that was copied, and copied again, be it in compendia, or in an Irish doctor's vademecum, to be studied in conjunction with similar works. Sometimes digests and extracts of longer works were added to thematically related tracts under the direction of an **ollamh leighis**, or professor of medicine, in a medical school, as Aoibheann Nic Dhonnchadha has observed. There is much more to be explored to find out how the Irish doctors shaped and assimilated the learning gleaned from scholastic teaching on the continent which included both medicine and natural philosophy. Since there were no universities in Ireland at the time, the medical schools had a similar function to universities on the continent and in England. Pupils from the hereditary families of healers would learn their art there for many years, serving the master as his amanuenses, and travelling with him, assisting him on his travels through the country when he was called to patients.


When cataloguing Harley 546, O'Grady stated (177) that the medical tract was written by Cormac himself, based on the colophon on f. 11, col. 2: ‘Táirnic ann sin libhur Galteruis do dosisib na leigheas. Cormac Mac Duinnthshléibi do cuir in thsuim so a nGaeidheilg do Diarmaid mac Domnaill hí Leighin ocus gur fhoghna dosan ocus dá cloind a tarbhaigi do comáin et rel. In cethrumhadh lá do Kl. april do críchnaighedh in forcedal so a Cluain Uamha sa bliadain darb annala don Tigerna in nuimhirsi do bliadnaib 1459.’ This means Cormac translated it, but not that he wrote the manuscript text.


Among the five manuscripts Sheahan used, he found none to be the original. He concluded this from a comparison of the hand with that in London BL Arundel 333, which contains text written by Cormac, according to a colophon on folio 113b. Sheahan's stemma (32) shows the original copy O from which two intermediate copies branch off, X and X1. From X, two intermediate copies Y and Y1 derive. From Y, the existing B (=RIA 445) and H (=TCD 1326) are derived. From Y1, H2 (=TCD 1312) is derived. From X1, two intermediate copies Z and Z1 are descended. From Z, E (=TCD 1436) is derived, and from Z1, Har (=BL Harley 546).


Concerning the language, Sheahan (33) stated ‘the language of the fifteenth century does not differ much from that of the present.’ For a study of the grammatical forms, he referred to Eleanor Knott's Bardic Poems of Tadhg Dall Ó Huiginn (1550-1591) (London 1926) and James A. Geary's doctoral dissertation An Irish version of Innocent III's De contemptu mundi, (Washington D.C. 1931). The latter contains a translation of the Latin text into Irish by William Mac Givney (Maguibhne) completed by 1443.


At Sheahan's time of writing, and before, the perception that the language of the fifteenth century was not much different from that of the ‘present day’ seems to have been common among scholars in the field who were familiar with literature from this transitional period. An infamous example was Osborn Bergin, who deemed even a translation of the Irish Grammatical Tracts unnecessary. However, modern scholarship has abandoned those notions of oligarchic hegemonial knowledge. It is hoped that making available this edition electronically will instead contribute to a more nuanced understanding of Early Modern Irish, certainly in the genre of medical literature where a lot of work still awaits.


Beatrix Färber, School of History, University College Cork.


De Dosibus Medicinarum
----------------------


In nomine Patris et Filii et Spirtus Sancti. Amen.
MEDICINARUM QUEDAM SUNT SIMPLICES quedam composite: .i.e. some medicines are simples, others are composites. For **Avicenna** says that the simples are those with general or local actions, or actions resembling general actions: general actions such as heating, cooling, evacuating, drawing, and the like.


Local actions are truly manifest in **aloe socotrine** relieving cancer; **yarrow** relieving **hemorrhoids**, and **dandelion**, i.e. **scariole** relieving jaundice, and the like. Actions resembling general actions as the medicine which promotes the flow of the **urine**, purges the **abdomen**, and such like. The reason why actions resembling general actions are so called is that they are the actions of things which are of general advantage to the entire body.


Take note that some of the simples are obtained from minerals, others from plants, and others from animals. Simples obtained from minerals: **emerald**, **sapphire**, pearl, and the like are such. Simples indeed obtained from plants: leaves, seeds, roots, stems, blossoms, fruit, and grain are such. Note particularly that it is proper to use the leaves when they begin to have their proper size in full and when they survive in their own shape without change of color and without falling. It is indeed proper to gather the seeds when their size is complete, and when their natural condition and viscidity are seasoned. It is indeed proper to gather the roots when the foliage falls. It is indeed proper to gather the fruit before they fall or before they are ready to fall, when they have reached maturity, because they ought to be gathered in the prime of their strength.


The **simple** obtained from animals: some of it, indeed, is obtained or usually is obtained from parts of animals, more of it from their superfluities, and more of it from their fluids. From


---

p.49



parts: such as the **gall**, **livers**, and parts in general. From the superfluities such as the **urine** and the feces. From the fluids such as the blood, the milk, and the rennet. Note particularly that in choosing the cures derived from animals that it is proper to choose the animals which have healthy strong bodies, healthy members and young age.


A **composite medicine** indeed, as **Avicenna** says is one compounded from **simples** or from other **composite medicines**. For that reason many composites are made from simples and from composites, as is evident from ***theriac***[1](javascript:footNote('T600021/note001.html')) which is made from **simples** and from **composite medicines** for the three things which enter into it are **composite medicines**. For that reason the composite has character from the **simples** and character from the entire form.[2](javascript:footNote('T600021/note002.html'))


Note particularly **Avicenna** or **Constantinus** says in the commencement of his own Antidotarius that the compounding of simples is essential, since for three causes it *(a simple)* does not suffice for curing every disease. The first cause is on account of the nature of the disease. The second cause is on account of the affected members. The third cause is on account of the nature of the simple. For these reasons the old physicians, when constrained by this necessity, made composite medicines from simples so that they might be able to carry out their intention in every single defect, and to compound with perfection and advantage.


The operations of a composite medicine in relation to the nature of the diseases are determined by four conditions or causes. The first of these causes: from the variability of the extent of the **evil complexion**.[3](javascript:footNote('T600021/note003.html')) The second cause: from the extent of the disease. The third cause: from the different qualities of the disease. The fourth cause: from the conflict of the different diseases.




---

p.51


Let the medicines be compounded according to the extent of the diseases of similar and dissimilar **evil complexions**, as is plain when a bad hot or cold complexion of the body is found together with some **quantity** which cannot be changed by a single simple only. For that reason it is necessary to make from different simples, used in the same proportions, a single composite medicine which can combat with the **quantity** of the **evil complexion** of the body. For example, should the body be of an immoderately high temperature of the second **degree**, and should no **contrary** cold simple of the same degree be procured let two simples be procured, i.e. a hot medicine of the **first degree** and a cold medicine of the **third degree**. When these are mixed and compounded in this way they will be cold in the **second degree**.


Because of the extent of the disease, let the medicine be compounded; for when the disease is great and dangerous it is necessary to compound two simples or more, so that when they are compounded the disease is destroyed by them. Because of the varying quality of the disease, let the medicine be compounded, for when the disease has **contrary** forces it is proper to compound the medicine of **contrary** things. For example, as is evident in the case of **phlegmon**[4](javascript:footNote('T600021/note004.html')) for which is suitable a compound medicine such as a **dispersive**, and a **cooling medicine**.


Because of the conflict of the different diseases, let the medicine be compounded, for when any disease has been developed from different items according to nature and **quality** it is necessary to expel it by a medicine which is correspondingly different as regards nature and **quality**. According to **Constantinus**, should ***theriac*** be compounded from numerous simples the reason for it is that it has the power to combat **pestilential diseases** and **deadly poisons**.


The second of the four causes, which cause is based on the affected members: governed by two circumstances let the medicine for this be compounded. First


---

p.53



circumstance concerns the location of the members. The second circumstance concerns their **nobility**.


Let the medicine indeed be compounded in accordance with the remoteness of the location for it is obvious, should the affected part be far away from the **stomach** where the medicine is first received, it is necessary for the medicine to be compounded so that it is not very much weakened by the distance to the extent it would not be possible for it to penetrate as far as the member. For that reason eastern saffron is put into the medicines, since it causes them to penetrate swiftly and easily to the members.


Let the medicine be compounded in accordance with the delicacy of the member for it is obvious as **Galen** says, if there is an **ulcer** on the **liver**, which is a **noble member**, that it is necessary to compound a medicine from **savory dispersives** and from **styptics** so that the virtue of the **noble member** is preserved by the **savory things**, and that the **styptics** might not permit the **substance** of the **noble member** to be dissolved by the **dispersives**.


The third of the four causes, which cause is based on the nature of the simple: let this be realized from eight circumstances. First of these circumstances: offensiveness of the medicine. Second: lowering of its **potency**. Third: to correct its **harmful effect**. Fourth: to strengthen its **virtue**. Fifth: to lower or lessen its **virulence**. Sixth: to preserve its own **quality**. Seventh: the variability of the items by which the action is accomplished. Eighth: the lack of comfort afforded by the simple itself.


As regards the offensiveness of the medicine: let the medicine be compounded so that when its taste is offensive and when it is not possible to take it or retain it in the **stomach** a fragrant and savory medicine is mixed with it to destroy its offensiveness. For that reason **Hippocrates** said to mix **wild carrot** with **black hellebore**, and **Galen** said to mix **anise** with


---

p.55


**scammony**.


To lower high potency of the medicine, let the medicine be compounded when it is too powerful. As for example, **opium** which is cold in the **fourth degree** is compounded, so as to reduce its excessive coldness, with **castoreum** which is hot.


To correct the harmful effect of the medicine: let the medicine be compounded when it is **contrary** to the disease and when it has an evil effect on the member where the disease is located; as for instance **scammony** which harms the **stomach** and **liver**, so that it is necessary to mix **black pepper** and **anise** with it.


To strengthen the medicine: let the medicine be compounded when it is weak as is obvious in the case of **iris** being mixed with ***theriac***, and **acorus**[5](javascript:footNote('T600021/note005.html')) with **agaric**.


To reduce its power: let the medicine be compounded; for when it is too hot, too sour, another medicine is mixed with it which reduces its heat and its piquancy, as is obvious in the case of **gum arabic** which is mixed with *theriac*.


To preserve the virtue of the medicine so that it might not become putrid: let the medicine be compounded for it is necessary for the physician to keep a time record of the medicines over a long period of time. For this reason, so that their virtues might not depart, it is necessary to mix another item with them to preserve their virtues, as is obvious from **opium** which is mixed with other composite medicines.


From the variability of the items by which the action is accomplished: let the medicine be compounded, for when the physician does not find a lone simple **contrary** to the disease another medicine is mixed with it, because, as is evident from the plasters, it is necessary to mix **wax**, **oil** and **pitch** into them, so that they would more easily, or more likely adhere to the member.




---

p.57


The lack of relief through the simple: let the medicine be compounded for when universal relief for the disease is not found in the lone simple it is necessary to compound dissimilar **contrary medicines**, and to make one medicine from them, as is obvious from the wounds for which a healing medicine and a flesh-growing medicine are required to be compounded, such as the medicine compounded from **myrrh**, **incense**, and the likes. So therefore, it is necessary for the rational physicians to make a composite medicine from the simples. It suffices for us what we have said about the simples.


Before we speak of the composite medicines it is necessary first of all to speak of the estimated quantity of the simples which are to be put into the composite medicines, for **Constantinus** says, ‘Since the medicine varies in its qualities, in its efficacy, and in its virtues it is necessary to include a little of some medicines, much of others and of still others a medium quantity.’


There are two principles according to which the dosage of simples used in compounding is regulated; i.e. one concerning the simple, and the other concerning the composite medicine itself.


As regards the simple: let that be subdivided into seven cases. First of these cases the strength or weakness of the virtue of the cure. Second: greatness or littleness of its efficacy. Third: nobility or ignobility of its efficacy. Fourth: combining one medicine with another giving ease, or leaving it by itself. Fifth: location of the affected member. Sixth: evil effect of the simple. Seventh: when an item is compounded into a composite medicine which item diminishes the efficacy of the other item contained therein.


It is thus the dosage is determined: according to the **virtue** of the simple, for should the medicine be too hot such as **euphorbium** is, or too cold such as **opium** is, it is necessary to put a little 


---

p.59



of it into the composite medicine. Should it be weak of heat such as **rhubarb** is, or cold such as **myrobalani citrini** is, it is necessary to include much of it.


Dosage determined by the greatness or littleness of the efficacy: should the medicine possess great efficacy much of it should be put into the compound, as is obvious by putting **iris** with **agaric**. Should its efficacy be little, it is proper to include only a little of it in the remedy.


Dosage determined by the nobility of the efficacy: much more of it should be put into the medicine in that case, than when its efficacy is ignoble. Efficacy of the medicine is called noble when the principal or noble members are strengthened, as in the case of **emerald** in strengthening the heart and **galangal** in strengthening the **stomach**, and **spodium**.[6](javascript:footNote('T600021/note006.html')) in strengthening the **liver**. Therefore, it is necessary to put much of these into the composite medicine.


Dosage determined by combining the efficacies, as is obvious when there is in the medicine a simple which has not properties except along with another medicine, it is proper to put much of that medicine in the compound; such as **violet** which has not properties for **inflammation** of the **liver** except together with **santal** and with **rose**. For that reason it is proper to put much of **santal** and of **rose** along with it.


Dosage of the medicine determined by the location of the member: let it be varied, for should the affected member be remote from the **stomach** it is necessary to put much of the medicine which relieves it into the compound; and should it be close to it let there be little of it put into it.


Dosage of the medicine determined by its evil effects: let it be varied, for should any medicine be equally good at assisting a particular member and at doing harm to other members, it is proper to put little of it in, such as in the case of **camphor** which does good to the **liver** and harm to the brain.




---

p.61


Dosage determined from compounding the medicine: let it be varied, for should *there* be a compound in which there are contrary ingredients, one of which ingredients diminishes the efficacy of the other, it is necessary to put much of the efficacious and little of the harmful medicine into it. These are the conditions for the dosage of the simples which are put into the composites, and it is in accordance with these conditions we prescribe what follows.


Note, that the conditions to be observed are the same in the doses of the simples and in the doses of the composites. Note also that some of the **laxatives** are uncompounded and others are compounded.


The **laxative simples**: indeed some of them such as **scammony** become weak on infusion, others such as **myrobalan** become concentrated, and some others such as **cassia fistola** become refined. For **Constantinus** says that every medicine which purges by its **attractive force** contains matter too poisonous and contrary to nature, so for this reason it is necessary for the physician when he administers it to do everything with reason and to administer it according to the **virtue**, season, appearance, and age; and to administer it in a safe and reasonable way so that the body may not change from its own **complexion** to another worse complexion, and may not die.


As for example if **scammony** were given in too large a quantity, or if it were spoiled, or if given alone, or when compounded with another medicine which heightens its sourness *(géire: intensity)*, or if given in the summer time, it purges actively and drastically, lowers the natural temperature, leads to **syncope**, and constricts the **cardiac valve** *(bel an goile: opening of stomach; **cardia**.)* particularly should it be **phlegmatic humor** which dominates. However, should it be given in a moderate quantity, when itself is in a fairly good condition and corrected by **anise** or by **mastix**, or when boiled into pasty which moderates its sharpness, then it is of benefit if administered to women in. their youth, and to those dominated by


---

p.63



choler; then it is reasonable to administer it. Let the same be understood for the other **laxatives**.


Note particularly that there are some of the simples such as **scammony**, **rhubarb**, and **reuponticum**[7](javascript:footNote('T600021/note007.html')) which purge **choler** by means of their **attractive force**. However, when you desire to administer a medicine of **scammony** do it in this way: take two or three drams of **scammony** and pulverize it, but do not break it too fine such as the other **spices**, for by its subtility and adhesiveness it would penetrate to the **recesses** of the **stomach**, and in this way it would be possible for it to do harm. So administer it in the dose we are prescribing later, when it has been compounded in the manner we have told of already.


Scamonia quidem est sucus cuiusdam volubilis:[8](javascript:footNote('T600021/note008.html')) i.e. **scammony** is the extract of a species of **honeysuckle**, i.e. a herb which grows to the east of the ocean. It is a species of **tithymallus** and its efficacy lasts for thirty years, glecio[9](javascript:footNote('T600021/note009.html')) i.e. choice. This is the most stable species of it, the species which is variegated as it becomes brighter, and which is very brittle or easily broken.


Nature: it is its nature to be hot and dry in the **third degree**. It purges **choler** from the remote members and from affection of the **stomach** and **liver** and from those who have a nervous nature. When being administered let it be corrected with a scruple of **mastix** which has been pulverized and compounded with it. Or if it be a person who has a hot complexion, let the **scammony** along with the powder we have spoken of, be put into a pear or raw apple, the center of which has been hollowed out, let pasty be put around it, and let it be put in an oven or to the fire to roast. Afterwards let it be taken out of the apple, dried in a dark place, and then administered. Because of the speed with which it creates **dysentry**, and stomach-trouble it is not proper for that reason to administer it in affections of the stomach and of the **liver**, unless they should be chronic. If so, let



---

p.65



the species which is best be chosen.


Here is a rule whereby it is not proper to administer a medicine containing **scammony** in case of bad hot complexion of the stomach, **liver**, gall, or **kidneys**. Dosage: its minimum dose one scruple, and its maximum dose two scruples. Note particularly, **Galen** says that the best species of it is the species which comes from **Antioch** and which has a color that tends towards being light. It is the one which is the easiest to break, the one which when broken has a color like glass. Note particularly, whether by itself or with another medicine, that it is proper to administer it in the dose we have spoken of.


Reubarbarum quidem ut quidam dicunt est radix cuiusdam arboris: i.e. **rhubarb** according to some is the root of a tree. It is found resembling a lump. Note particularly that there is a **rhubarb** called barbarum which is found in barbarian countries such as **India** and the countries east of the ocean, and another **rhubarb** called ponticum because it is found on an island called **Pontos**, or because of its pontic[10](javascript:footNote('T600021/note010.html')) taste. And there is another yellow species of it which is mixed with some black and which has firmness, ponticity[11](javascript:footNote('T600021/note011.html')), bitterness and piquancy. Nature: they all have the same nature and they are hot and dry in the **second degree**. They purge **choler** from the stomach and from the **liver** and are for that reason suitable in diseases of the stomach and of the **liver** an example of which is fever. Dosage: it suffices as maximum dose of it by itself or in a **syrup** up to one half ounce; and as minimum dose of it up to two drams.


Reuponticum: hot, dry, and in the **second degree**. It is very similar to **rhubarb**, and is best when it is heavy and round and has distinct veins. It purges **choler** of the stomach and **liver**. However, it does not stain as **rhubarb** does, and is suitable for disease of the stomach and **liver**. Should it be administered with extract of **fennel** it removes


---

p.67


**obstructions** of the **spleen**. When by itself, or with another it suffices as maximum dose of it up to one ounce or one half ounce, or as minimum dose up to two drams.


DICTO DE MEDICINIS SIMPLICIBUS attractivis purgantibus coleram dicendum est de medicinis simplicibus attractivis purgantibus flegma: i.e. having spoken of the **uncompounded attractives** which purge **choler** it is meet that we speak of the attractive simples such as **colocynth**, **turpeth**, **agaric**, **hermodactylus**, **esola**, **euphorbium**, and **white hellebore**, which purge **phlegm**.


**Colocynthis** quidem est pomum cuiusdam arboris et cetera: i.e. **colocynth** is a hollow apple or fruit of a tree which grows in the Orient around **Jerusalem**, and which has as a synonym **cucurbita alaxandrina**. Nature: it is hot in the **third degree** and dry in the **second degree**. Primarily it purges gross dense **phlegmatic humor** from the **joints** with acuteness by its attractive force. Secondarily, it purges **melancholia** from the **brain** . Because of that it is suitable for ailments of the head such as **melancholia**, **epilepsy**, and the likes. Since it causes, when it is administered, great discomfort to the stomach, vomiting, and **syncope**, it is proper for that reason to correct it, before it is administered, by a scruple of pulverized **tragacanth** compounded with it. Let it not be administered in hot weather and let it not be mixed with another powerful **laxative**. Dosage: its maximum dose singly or together with another medicine one dram; and its minimum dose up to one and one half scruples. It is best when it has an abundance of bright uniform pith.


**Turpethum** quedem est radix cue ultra mare reperitar: i.e. **turpeth** is a root found east of the ocean. It is choicest when it is intermediate between thick and thin, when it is bright and gummy at the tops, and easy to break. When placed in the mouth it hurts the tongue. So that it might not



---

p.69



penetrate to the stomach and the **liver** it is proper to correct its **malignancy** by rubbing it first in **oil of rose**[12](javascript:footNote('T600021/note012.html')) and **oil of sweet almonds**. Nature: hot and dry in the **third degree**. It purges **phlegmatic humor** without repugnance on the part of the stomach, intestines, **liver** and loins. Dosage: it suffices as maximum dose, individually or with another medicine, four drams; and as minimum dose, from one to two drams. Let it be compounded with a dram of **sugar** together with a dram of **ginger** so that it does not injure the stomach by its sourness.


**Agaricum** est sicut fungus: i.e. this is what **agaric** is: a thing which is similar to a **fungus**. It is found in **Babylon** and is of two forms, i.e. the male and female. The form of the male is long and not so brittle or so bright as the female form. The feminine form of it is bright, light, fragile, and is knotty on the outside and in the inside. It contains something which resembles hair. The male form is uniform, and not so brittle or so light-colored as the other. This is how it should be chosen: it should be bright, and easily broken. The male form of it is no good. However, **Avicenna** says that both of them are very bad. This is how the statement of **Avicenna** is interpreted; namely, as regards to the land where he actually was, for it was malignant and harmful there. Moreover, according to **Johannes Ibn Mesue** this is a most beneficial medicine since it purges every member of the body in general.


Nature: hot in the **second degree**, and dry in the **third degree**. It purges **phlegm** from the stomach primarily and **melancholia** secondarily; and for that reason is suitable, together with a draught in which **saxifrage**, i.e. **meadow saxifrage**, has been boiled, for quotidian fever caused by natural **phlegm**, and for **dysentry** or *dysuria* caused by **phlegm** . Together with a draught in which **ragwort** is boiled, it promotes the **catamenia** .


Dosage: the maximum amount which it is proper


---

p.71



to administer whether singly or with another medicine is up to four drams and it is proper to administer as its minimum dose from one and one half drams to one dram. Before administering it it is proper to correct it with one dram of extract of **licorice**.


**Helleborus** *quidem* est radix calida: i.e. **hellebore** is a hot root. It is of two species, i.e. a bright species and a dark species. The bright species indeed is the skin of a root which resembles the root of **althea**. It is best when it has a smooth surface, and when it is bright and easily broken. Nature: hot and dry in the middle of the **second degree**. It purges thick **phlegm**, and should it be pulverized and put in the nose it clears the brain by dispelling the superfluities. It rids the stomach of **phlegm** by causing vomiting. The ancients were accustomed to put **hellebore** in their purgatives just as we now are accustomed to use **scammony**.


Dosage: it suffices as the maximum amount of it, singly or with another medicine up to one and one half scruples; and the minimum amount up to one half scruple. Before administering it, its malignancy is corrected by one dram of **origanum** or catnip which has been pulverized and compounded with it.


Esola quidem est frutex: i.e. **esola** is a brush and it is its root which serves as medicine. Nature: hot and dry in the **third degree**. It has the virtue of depleting the **phlegmatic humors** primarily,
and for that reason is useful for every disease caused by **natural phlegm** such as **arthritis**, **podagra**,
**chirogra**, **paralysis**, **iliac**[13](javascript:footNote('T600021/note013.html')), and **leucophlegmansia**.


Note that of the items which purge through their sourness, next after **scammony** **esola** is the best. It is administered in one of the oils because of being too objectionable. For that reason every medicine which purges **phlegm** is made sour by it, or it is
possible to make it sour with **esola**.


Dosage: it suffices as maximum dose of it, singly or with another medicine, one dram; and the


---

p.73



minimum amount, singly, from one to two scruples.


**Euphorbium** quidem est gumme arboris: i.e. **euphorbia** is the **gum of a tree** which grows in **India**, and which exudes **gumminess** in the summer time. When it has coagulated around it, it is changed to **euphorbium** matter.


Nature: hot and dry in the **fourth degree**. It purges **phlegm** primarily, and **melancholia** secondarily. For that reason it relieves all **arthritis**, **podagra**, **chirogra**, **iliac**, **lethargy**, and **epilepsy**. The **pills**
made from it relieve **paralysis**, and should they be mixed with various **spices** they relieve the diseases we have mentioned. It is best when it is bright, fresh, and yellow tending towards green.


Dosage: it suffices as maximum dose of it from one scruple to one half scruple, and the minimum dose of it up to one quarter scruple. For **Avicenna** says that three drams of it kills a person in three days by injuring the **stomach** and **entrails**. It is proper to mitigate its powder with **oil of rose**.


DICTO UT DETERMINATIO DE MEDICINIS **simplicibus attractivis** qui phlegma evacuant, et cetera: i.e. after speaking of the **uncompounded attractives** which deplete **phlegm**, it is right to speak of the **uncompounded attractives** such as **polypodium**, **lapis lazuli**, **lapis armenicus**, **senna**, and **black hellebore** which purge **melancholia**.


**Polypodium** quidem est herba similis filici i.e. **polypodium** is a plant resembling **fern** which grows on **oaks**, rocks, walls and stones. The best specie of it is that which grows on the oaks. Its root is best, and it is good while getting green. According to the Antidotarium it is called a knotty stick of the color of ashes, which becomes darker or redder. It is better growing red rather than yellow, and when it is firm, green, and fresh.


Nature: hot in the **second degree** and dry in the **third degree**. It purges **phlegm** primarily, and **melancholia** secondarily, without hurting or wounding.



---

p.75



Should it be comminuted along with **sugar** it purges the **abdomen** without pain. Note that when it is boiled
it is proper to put along with it some item such as **anise** or **fennel seed** which expels **flatus**, because
**polypodium** releases the humors in excessive flatulence. It is suitable for **quotidian fever**, **iliac**, **alopecia**,
and **arthritis**. Dosage: it suffices as maximum dose of it one ounce; and as minimum dose to one half ounce.


**Lapis Lazuli**: a blue stone, cold and dry in the **second degree**. Its color is very like the color of the heavens, and in it are small particles of the color of gold. It purges a certain **melancholia**, and for that reason is suitable for those having **quotidian
fever**, for those having **hemorrhoids**, for ailments of the **spleen** and is convenient for every
kind of *melancholic* humor. It is bad for the stomach. When washed it promotes **vomiting** without ill effect. Dosage: it suffices as maximum dose of it two scruples; and as minimum dose one scruple. Note
that the method of washing it is to put it into a silver cup or other strong vessel, to crush it with a
**pestle**, in a **mortar** and to mix it with water afterwards until it is made muddy. Then, let it be poured
off, let more water be added to it, and let it be done in this way ten or twenty times. Others say to
wash it thirty times. The sign that it is well washed is when the water is no longer affected.
Note particularly that it is not proper to administer **lapis lazuli** in a draught since it would
sink to the bottom, but to give the draught first, and when it has operated five or six times to administer
along with **syrup of violet** the **lapis lazuli** which
has been washed. The manner in which it then purges **melancholia** is remarkable.


**Lapis Armenicus**: i.e. a stone in which
there is something of the color of **lazuli**. It is smooth to touch. It is called **Lapis Armenicus** for
the reason that it is found in **Armenia**. It has a somewhat bright color and has less gravity than



---

p.77


**lapis lazuli**.


Nature: cold and dry in the **second degree**. It purges **phlegm** more effectively than **lapis lazuli**
does. For that reason it is suitable for **quartan fever**, and for every melancholic disease. **Avicenna**
says it is bad for the **stomach**. However, should it be washed it does not nauseate, should it not be, it does. The dose is the same as for **lapis lazuli**.


**Senna** quidem est herba que intrans marinus partibus crescit: i.e. **senna** is a herb which grows east of the ocean, particularly around **Babylon** and **Arabia**. Nature: hot and dry in the **second degree**. It purges **melancholia** primarily, and **choler** secondarily. For that reason it specifically purges or 
relieves **melancholia**, **epilepsy**, **syncope** and **colicus**.[14](javascript:footNote('T600021/note014.html')) It strengthens the heart, and is suitable for diseases of the **spleen** and **liver**, and for **hemorrhoids** and **quartan fever**. Note that the foliage of the **senna** is better towards the action of the cure than
its blossom. Dosage: it suffices as maximum dose, when administered singly, one ounce; and should it
be given with other **laxatives** from three to four drams.


**Helleborus niger**, et cetera i.e. **black hellebore** is in chips when cut. Its piquancy is more powerful than that of **white hellebore**. The people who cut it are saved from its evil effects in this way: by taking **garlic** and wine. It is best when it is intermediate between young and old, when it has a yellow color, and when it is brittle. Nature: hot and dry in the **second degree**. It 
purges **melancholia**, and is for that reason suitable for **impetigo**, **serpigo**, and leprosy. Dosage: it suffices as maximum dose of it up to one half dram; and as minimum dose up to one half scruple. Before administering it, it is proper to correct it with **origanum** or **catnip**.




---

p.79


DICTO DE MEDICINIS SIMPLICIBUS attractivis, et cetera: i.e. having spoken of the simples which purge by attractive force, it is meet that we speak of the simples which deplete the humors by compression. **Myrobalan** is one. There are five kinds of it:
**citrini**, **chebuli**, **indi**, **emblici**, and **bellerici**.[15](javascript:footNote('T600021/note015.html'))

Nature: all of them are cold and dry in the **third degree**. They are the fruit of different trees. They
are good when gummy, because by their **gumminess** they purge. It is said that the **citrini** are hotter than
the **inndi**, and that the **inndi** are less cold than the **chebuli**. Of them the **citrini** purge most; for that reason it is proper to speak of them first.


**Citrini** solunt **coleram rubiam**: i.e. the
**citrini** purge **choler** primarily; and according to
 **Avicenna**, a little of **phlegm**. For that reason when
administered in water in which **rose** and **myrtle** have been boiled it is suitable for those who have **jaundice**, **tertian fever**, and **dysentery**. However, should it be necessary to cause depletion by **myrobalan**, let it be done in fear and with caution. For that reason it is proper to mix **tragacanth** with it, so 
that it does not aggravate ulcers of the intestines. Dosage, maximum dose of it when given in a draught
for **dysentery**, four drams; and when given for **tertian fever**, one ounce indeed is the maximum amount.


Note particularly as **Avicenna** says that
it is not proper to administer **myrobalani** in **obstructions**
of the **liver** and of the **spleen** because of the **styptic properties** which they possess since
they purge the thinnest portion of the matter and the thickest portion remains. This is converted
into **calculous concretion**, and in this way the **obstructions** are increased.


Note that the dosage of the **myrobalani** is varied according as they are put into draughts or into **pills**. For should they be put into **pills** it is proper to put as much as two drams; and should they be in draughts it is proper to put one and one half ounces.



---

p.81



When they are given in **pills** it is proper to administer them at night, and if as a draught in the morning. **Rhazes** says that it is proper to administer the draughts at night should the weather be warm such as the **dog days** are.


**Chebuli**: they are cold and dry. They
are colder than the **citrini**. Because they are conducive in the least portion towards bitterness, they are the least **laxative** and the most **costive**. Through their properties they purge **choler** and **melancholia**. According to **Constantinus** and **Avicenna** they purge **melancholia** and **phlegm** and they astrict in some way the **flux** of the **stomach**. For that reason they are suitable primarily for **quartan fever**, and secondarily for **tertian fever**; and when roasted and administered with extract of **yarrow** they are suitable
for the **discharge** from **piles, i.e. hemorrhoids**. Since they clear off **choler** they are for that reason suitable for **blindness** and **weakness of eyesight** caused by the nature of the **phlegm**. It is
proper to make a **conditement** of them with **syrup of violets**. Whether administered in draught or in **pills** their dosage is the same as for **myrobalani citrini**.


**Inndi**, likewise, are cold and dry. They are close to **cebuli** in their **operation** and in their **virtues**. They purge **choler** more than **cebuli** do, and for that reason the diseases they relieve and the method of administering them are the same. Dosage: it suffices as maximum dose of them, if administered in draught, from eight to ten drams;
and if in **pills** from two to three drams.


**Emblici**: they are cold and dry, having in their **virtues** and in their **actions** resemblance to 
**chebuli** and to **inndi**. For that reason their character and dosage are the same, and the diseases which they are of use to are the same. So, likewise, of **bellirisi**.


DICTO DE MEDICINIS QUE LAXANT com comprim*e*ndo dicenda est de medicinis que laxant leniendo: i.e.



---

p.83



having spoken of the medicines which deplete by compression it is meet that we speak of the medicines
such as **violet**, **prune**, **cassia fistola**, and **manna** which purge by **lubrication**.[16](javascript:footNote('T600021/note016.html')) 


**Uiola**, i.e. **blossom of the violet**: cold and moist in the **first degree**. It purges **choler** from the **stomach**, **liver**, and **intestines**, for it has moistening, **lubricous**, cooling, and **laxative** effect. For that reason should it be made into a **syrup**; it relieves
**inflammation of the liver** greatly. This **syrup** is suitable, also, for **severe cough**, as it soothes the chest, allays pain and febrility of the body in general and of the head in particular. For that reason
it is suitable for **headache** caused from **choler**, or from **sanguine humor**.


**Pruna**: they are identified as **plums**.[17](javascript:footNote('T600021/note017.html')) Nature: cold at the beginning of the **second degree**, and wet at the end of the **third degree**. The darkest species of them is the best for medicine, especially the species called **damasenica**, called so after a country. *When* they are collected ripe they have the virtue of cooling and lubricating the intestines, and are for that reason suitable for high fevers and for **constipation of the abdomen** when caused by dry or **hot humors**. **Avicenna** says that all confections in which they are operate on, or purge **choler** all the more efficaciously and that they (prunes) purge more readily when wet than dry. They may be
administered in draughts in accordance with the


---

p.85



greatness or littleness of the **choler**. Should it be little let ten of them be given as a dose; and if
great from fifty to one hundred depending on the **costiveness, i.e. the stoppage of the entrails**.


**Cassia fistola** alia est cebula alia innda:
i.e. there is a species of **cassia fistola** called **cebula**, and another species called **innda**. The best
way to procure it is from reeds, and indeed from those which are the most fleshy, the best looking, and the smoothest.


Nature: it is medium between hot and cold, and it is wet. It purges **inflammatory humor** *(i.e. burnt red bile)* from the **stomach** primarily, and **phlegm** secondarily. It lubricates and evacuates the **abdomen** without harm or hurt, so that it is suitable for **pregnant women**. It
clears the **liver**, and for that reason according to **Avicenna** it is suitable for those having **jaundice**,
**headache**, **tertian fever**, and for the severe diseases, and for every disease caused by **choler**. It purges the
remote parts.


Dosage: the minimum dose of it is one half ounce, and the maximum dose up to two ounces.


**Manna** quidem est ros cadens super lapidem aut arborem: i.e. **manna** is ros or a dew which falls, under the appearance of honey, on stones, or trees. It becomes sweet, congeals, and *dries* like gum.


Nature: it is medium between hot and cold. It purges the **abdomen**, wipes out the acuteness of **choler fever** according to quality and is suitable for sufferers from **choler**. The dosage is the same as for **cassia fistola**.


**Tamarindi**, i.e. the bitter dactali. They
are best when soft and fresh and when they have genuine bitterness. They purge **choler** and are suitable
for fevers, especially when it is necessary to lubricate the intestines. The dosage in draughts is the
same as for **cassia fistola** and **manna**.


DETERMINATIO DE MEDICINIS simplicibus laxativis et de dosi earum et cetera: i.e. having spoken of the **laxative simples** and of their doses it is meet to speak of the **laxative and digestive compounds**


---

p.87



and of their doses. Take note that there are four necessary conditions for purging the **evil humor**. Of these conditions the first is: to choose the medicines by which it will be purged. The second condition: to observe the period of the **digestion** of the humor. The third condition: to observe the **quantity** of the humor and of the**evacuation**. The fourth condition: to observe the member where the **evil humor** is located. To continue, I say that it is necessary first for the physician to choose the medicine.
There are two medicines: **digestive** and **laxative**. Because it is proper to administer the **digestive** sooner
than the **laxative**, it is proper for that reason to speak of it first.


Let the digestive be diversified by reason of the diversity of the humor and of the member; for
if the humor is dense it is proper to digest it with a tenuating *(i.e. emollient)* medicine, just as it is evident that it is
proper to digest natural **phlegm** with **simple oxymel**. Should it be dense or highly viscous it is proper to
digest it with a medicine which accelerates it. Should it be natural **melancholia** let it be digested with **oxymel of squill**. Should it be a **hot humor**[18](javascript:footNote('T600021/note018.html')) it is proper to digest it with a **cooling medicine**; for instance, **choler** is digested by **oxysaccharum**. Should
the humors be cold it is proper to digest them with medicine which heats them; for instance, **phlegm** is digested by simple **oxymel**. Note that should the humors which it is desired to digest be a compound it is proper that their digestive be compounded. Should the composition of the humors be of equal proportions, it is proper to compound the digestives in equal proportions
so that there might not be more of one ingredient in it than there would be of another, as is obvious in
the case of **acidic phlegm** and **salty phlegm**.


Let the **digestive**, indeed, be diversified in accordance with the diversity of the members for should
the **phlegmatic humors** accumulate in the head and in the **nerve centers** as is obvious in **paralysis**, **epilepsy**,


---

p.89


**apoplexy** and **hemicrania** *(i.e. migraine)* it is proper to digest them
with a medicine most appropriate for the **brain** and for the **evil humor** dominating there. Therefore, it is proper
to digest with this **oxymel** the **phlegm** which causes **paralysis**: take **acorus**, **maratrum**, **lavender**, **hyssop**,
**polycaria major**, every species of **nasturtium**, **ground ivy**, **betony**, **origanum**, **pennyroyal**, **savory**, **avens**, **marjoram**, **peony**, **garden rue**, **ragwort**, squills, of each item half a fistful; **savin** and **primrose**, of each three
whole fistfuls; honey, two pounds. Let an **oxymel** be
made from them.


Note particularly that it is the same **digestive** by which it is possible to digest the matter in 
**epilepsy** and **apoplexy**, and in **hemicrania** from a cold cause; however, it is proper to put more of **peony**, **rue**, **betony** and ground ivy than of other items towards digesting the matter in **epilepsy**. So too for 
**apoplexy**. It is proper to digest the matter in **hemicrania** by the same digestive. However, it is proper
to insert more of **polycaria major** than of the other items, since the herbs employed in the greatest quantity are the most effective in the compound, and are the most appropriate for the area where the matter is located. For that reason more of these is 
inserted than of the other items.


Should there be in the **respiratory organs** such as the **chest**, **lungs**, and the like an accumulation
of the **phlegmatic humors** without fever, let them be digested with this compound: take **calamint**, **origanum**, **roots of lily**, **iris**,**pennyroyal**, **maidenhair**, of each a fistful; **licorice** which has been cleaned, **maratrum**, and **cottonseed**, of each one ounce; **camomile flowers**, and **mellilotus**, of each one half ounce; **violets** two
ounces; **sugar** two pounds. Let a **syrup** be made from
them.


Should they be **dry humors** which accumulate there, let them be digested by this medicine: take **maidenhair**, **maratrum**, **fennel seed**, **anise**, **endive**,
**scariole**, **fresh hyssop**, **hart's tongue**, **ceterach**,


---

p.91


**maidenhair-spleenwort**, and **adiantos**, of each a fistful; **jujube**, **sebesten**,[19](javascript:footNote('T600021/note019.html')) and **the four cold seeds**[20](javascript:footNote('T600021/note020.html')) which have been cleaned, of each half of one ounce; **sugarcandy**, **penedian-sugar**[21](javascript:footNote('T600021/note021.html')), and **white poppy seed**, of each one ounce; **white tragacanth**, **gumarabic**, and **borage blossoms**, of each four drams; **violet**, two drams; **sugar**, two pounds. Let a **syrup** be made from them.


Should the **choleric humors** accumulate in the **stomach**, liver, or the like, let them be digested by
the following medicine: take **endive**, **scariola**, **liverwort**, **dandelion**, and **chicory**, of each item three
fistfuls; **acorus**, **maidenhair**, **ceterach**, and **maidenhair-spleenwort**,
of each item a fistful; **violets** three ounces; **prunes** fifty; **rose**, **lettuce seed**, **endive seed**;
**white and red sandalwood**, and **spodium**, of each item one ounce; **the four cold seeds**, of each one half ounce;
**barberry**, i.e. the tree, one half ounce; of **borage blossoms** two ounces; of wine of **pomegranate** one half
ounce; of **sugar** two pounds. Let a **syrup** be made from them.


Should they be **phlegmatic humors** which accumulate
in them (stomach, etc.) let them be digested by this medicine: take **eupatorium**, i.e. **mugwort**, and
**sage**, of each ingredient a fistful; **camomile**, **mellilotus**,
**fennel root**, **parsley**, **bruscus**, **asparagus**, **cinquefoil, i.e. five leaved**, **gramen**, i.e. male grass,
**germander**, **bugle**, **iris**, **pes columbe** i.e. a species
of **herb-robert**, **bitter eryngo**, **comfrey**, **bogbean**, **scariole** **maidenhair**, **elecampane**, and **bugloss**, of
each item one and one half fistfuls, **honey** and **sugar** of each one pound; **wine of pomegranate** one half pound. Let a **syrup** be made from them.


Should *natural* **melancholic humor** accumulate in the **spleen**, or in the other members let it be digested by the medicine by which the **phlegmatic humors** in the **liver** and in the **kidneys** are digested. Let there be put into it, however, more of **hart's tongue**, **eupatorium**, the roots of **kapper** *(caper)*, the inner bark of **tamarisk**, and the bark of **ash** and **broom**.




---

p.93


Should there be feverish humors in the **spleen** let them be digested by this medicine: take
extract of **scabious**, extract of **fumitory**, extract of **borage**, of each item two pounds; **scabious**, **fumitory**, 
**daffodil**, fresh **thyme**, **plantain**, **bugloss**, **hound's tongue**, **chicory**, **hart's tongue**, **endive**, and **scariole**,
of each item a fistful; roots of **kapper** *(caper)*, two species of **sticados** rose[22](javascript:footNote('T600021/note022.html')), **endive seed**, **lettuce seed**, of each one half ounce; **violet**, and **borage blossoms**, of each
three ounces; **sugar** two pounds; **wine of pomegranate** one half pound. Let a **syrup** be made from them.


Should **phlegmatic humors** accumulate in the **kidneys**, **bladder**, or in such like members, let them be
digested by this medicine: take **roots of parsley**, **yellow flag**, **filipendula**, and **creta marina** *(i.e. rock samphire, sea holly, or sea fennel)*, of each
item three fistfuls; two species of **pepperwort**, **thistle of the sea and field**, **cinquefoil**, **grass** and
**garden celidonia**, take of each one fistful; **gromwell**, and **fennel seed**, of each item one half ounce; **seeds of parsley**, **yellow flag**, **bruscus**, **asparagus**, and **mallow**, of each item one ounce; **honey** and **sugar**, of
each one pound; **wine of pomegranate** one half pound. Let a **syrup** be made from them.


Should they be **hot humors** which accumulate in the same members let them be digested by the medicine by which the **hot humors** dominating in the members, or in the liver are digested. Let there be put in the medicine, however, more of **roots of parsley**, **cinquefoil**, **asparagus**, **bruscus**, and **fennel**.


Should **phlegmatic humors** accumulate in the **womb**, let them be digested by the medicine by which the phlegmatic humors of the **kidneys** are digested. Let there be inserted, however, more of **ragwort**, **calamint**
**eryngo**, **iris**, **lily** and **betony**.


Should they be **hot humors** which accumulate there let them be digested by the medicine by which the **hot humors** in the **kidneys** are digested. Let there be put into it, however, more of **ragwort**.


Should **phlegmatic humors** accumulate in the



---

p.95


**joints** let them be digested by this medicine: take **extract of yew** one pound; yellow bugle, and **ragwort**, of
each item one fistful, **iris**, **eryngo**, **lily roots**, **acorus**,
 **endive**, **maidenhair**, and **adiantum**, of each item one
half fistful; **camomile flowers**, **mellilotus**, **maratrum**,
**bruscus seed**, and **asparagus**, of each item one ounce; **rose**, **licorice** which has been washed, **lettuce seed**,
of each item one half ounce; **honey** and **sugar** of each one pound. Let a **syrup** be made from them.


Should they be **hot humors** which are present there, let them be digested by a medicine that has been compounded of **endive**, **scariole**, **hart's tongue**, **extract of yew**, **yellow bugle**,[23](javascript:footNote('T600021/note023.html')) **violet**, **camomile flowers**, **mellilotus**, **rose** and **lettuce seed**. Let a **syrup** be made from them. Note particularly that should **complex humors** enter the same members it is proper to digest them with **compound medicines** depending on the diversity of the humors and of the members. This is sufficient now to say in connection with the digestives.


DICTO DE MEDICINIS DIGESTIVIS dicendum est de medicinis laxativis composites: i.e. having spoken of the digestives it is meet to speak of the **compound laxatives**. Note particularly that the **compound laxatives** are diversified according to the diversity of the humors since some of them such as **yera pigra**[24](javascript:footNote('T600021/note024.html')), **benedict**,[25](javascript:footNote('T600021/note025.html')) **blanca**[26](javascript:footNote('T600021/note026.html')), **theodoricon anacardium**[27](javascript:footNote('T600021/note027.html')), **stomaticon laxativum**, **arthetice pills**, **auree pills**, **asafetida pills**, **euphorbium pills**, **sweet electuary**,[28](javascript:footNote('T600021/note028.html')) **cochie pills**, and **paulinum** purge especially **phlegmatic humor**.


There are other medicines such as **catarticum imperiale**, **yera Rufini**, **diasenna**, **triffera sarracenica**, **yera logodion**[29](javascript:footNote('T600021/note029.html')) **teodoricon hyperiston** which
purge **melancholic humor** in particular. There are still other medicines such as electuary of **sugar of
roses**, and **diaprunis** which purge **choler** in particular. Let the medicines be varied according to the diversity of the members. Although **benedicta** and **yera pigra**


---

p.97



have the virtue of purging **phlegmatic humor**. It is **phlegmatic humor** of the **kidneys**, however, which **benedicta** most suitably purges, and for that reason it relieves **nephritis**. **Yera pigra** purges **phlegmatic humor** of the head and for that reason it relieves complaints of the head caused by **phlegmatic humor**.


**benedicta** is so called for the reason that it is blessed by each person who uses it. It is suitable for **gout**, **arthritis**, and **podagra** caused by **phlegmatic humor**; and it clears the **kidneys**, the **loins**, and the **bladder**.


**Yera pigra** is so called for the reason, indeed, that **ιερα** and **sacer** are identical, i.e. blessed;
and that **πικρα** and **amara** are identical, i.e. bitter. 
It is suitable for various complaints of the **head**, **ears**, and **eyes**; it clears the **stomach** and **eyes**. It cures affliction of the **spleen** very effectively and diseases of the **womb** as well.


**Blanca** is so called because blancam and
white thing are the same. This because it purges the **white humors**, i.e. the **phlegmatic humors** . For that reason it is suitable for **cephalalgy** caused by **phlegmatic humor**, for **sore eyes**, for **paralysis**, and for **epilepsy**.


**Theodoricon anacardium** is so called because of the fruit named **anacardium** which enters into it. It purges **phlegmatic humor** of the head effectively, and, in particular, the back portion, and for that reason refreshes the memory. It cures **vertigo**, and is suitable, likewise, for diseases of the **womb** which come from a cold cause.


**Stomaticon laxativum** and **sweet electuary** purge **phlegmatic humors** of the **stomach** specifically. **Arthetica pills** purge **phlegmatic humor** of the **joints** specifically, and for that reason relieve **arthritis**, **chiragra**, and **podagra**. **Auree pills** purge **phlegmatic humor** of the head specifically. They sharpen the **eyesight**


---

p.99



specifically, and are for that reason suitable for complaints of the **eye**. **Fetida pills** purge dense **phlegmatic humor** accumulated in the **joints**, and for that reason relieve **arthritis** and **sciatica**.


Pills made from **euphorbium** purge the **phlegmatic humors** draining from the **head** to the **nerves**. It (**euphorbium**) is for that reason suitable for **paralysis**. How to compound it is learned from
**Avicenna** in his own Antidotarium.


**Cochie pills** purge the humors caused by the **discharge** from the **brain**. They are for that reason suitable for **epilepsy**.


**Paulinum**[30](javascript:footNote('T600021/note030.html')), because of its great virtue, is called the great **antidote**, i.e. the great **composite medicine**.
It relieves effectively fresh cough and chronic cough caused by the flow of the **phlegmatic humor** from the head to the chest. For that reason it relieves chest complaints caused by **phlegmatic humor**. It rids the head, chest and **stomach** of **phlegmatic humor** primarily, and of **melancholia** secondarily. Its dosage is two drams.


Take note that if in the different members with the exception of the genitals, different humors should accumulate in equal proportions, it is proper to compound different medicines in equal proportions; and should they accumulate in different proportions it is proper to compound them in different proportions so that they might contain more of one particular remedy than of the other remedy. Note
also that the **compound remedies** are made bitter by various bitters in order that they may work more powerfully. Addition of the bitters is varied in proportion to the variation of the humors, and of the members; and for that reason the medicine which purges the **phlegmatic humors** of the head should be made bitter by one and one half **scruples** of **colocynth** corrected by one dram of **tragacanth**, or by one and one half **scruples**
of **scammony** which has been corrected by *mastix*, or by


---

p.101


**pasty** as we have said above, or by one dram or more
of **esola**.


DICTO DE MEDICINIS EVACUANTIBUS **phlegma** dicendum est de medicinis evacuantibus **melancolicam**::
i.e. having spoken of the medicines which purge **phlegmatic humor**, it is meet to speak of the medicines 
which purge **melancholia** primarily; and so first of all of **yera Rufini**[31](javascript:footNote('T600021/note031.html')) which purges **melancholia** primarily. For that reason it effectively relieves those who have **elephancy**, **morphew**, or **scabies** caused
by salt or by inflammatory **phlegm**.


Diasene:[32](javascript:footNote('T600021/note032.html')) an **electuary** which purges **phlegmatic humor** accumulating in the **spleen** and in the **heart**. For that reason it specifically relieves **obstructions of the spleen**; relieves those who suffer from **mania**, and those who suffer from **dejection**.


**Triffera sarracenica** is called after the **Saracens**.[33](javascript:footNote('T600021/note033.html')) Or it is called triffera for the reason that it is administered to him who is young. It purges **melancholia** of the **stomach** and liver. Because of that it is suitable for **obstructions of the spleen** and
liver, and for **jaundice** caused by **inflammatory choler**.


**Yera logodion memphitum** is so called since **ιερα** and sacer mean the same, i.e. blessed; since **λογος** and sermo mean the same, i.e. speech; and
since memphitum and impedimentum mean the same, i.e. impediment; for it cures **impediment of the speech** whatsoever its source or origin might be. It purges
specifically **melancholia** of the head, and is suitable for **epilepsy**, vertigo, **hemicrania**, **cephalalgia**, and for **tremor** such as is evident in those who
are supposed to have a demon.


**Imperial cathartic**, i.e. a medicine found for emperors and for other weak people. It purges the **melancholic humors** accumulated in the **kidneys**, and for that reason it relieves those having ***nephritis***. It dispels flatus of the **stomach** and **intestines**, and
is suitable, therefore, for those having **ileac**,


---

p.103



and **syphilis**.


DICTO DE MEDICINIS EVACUANTIBUS phlegma
et melancholiam dicendum est de medicinis evacuantibus coleram: i.e. having spoken of the medicines
which purge **phlegmatic humor**, and **melancholia**, it is meet to speak of the medicines which purge **choler**
such as **diaprunis**, and **electuary** of **sugar of roses**. **Diaprunis** is so called because it contains more of the fruit known as **prunes** than it does of any other ingredient. It purges **choleric humors** of the **stomach** and **liver**, and for that reason it is administered for true **tertian fever**, and **inflammation of the liver**.


**Electuary** of **sugar** of roses is indicated for **inflammatory gout**. It purges the **choleric humors**, and **natural choler**. For that reason it relieves complaints of the **joints** caused by **choler**,
also persons recovering from **tertian fever**. Note particularly that the dosage of these **compound medicines** is varied according to the larger or smaller quantity of **scammony**, and of other potent and
virulent medicines such as **hellebore**, **turpeth**, **agaric**,
**euphorbia**, **colocynth**, **aloes**, and the like which enter into their composition.


Consequently, the dosage of **yera pigra** is three drams, and the dosage of **yera Rufina** two drams for the reason that it contains more of potent and virulent medicines than does **yera pigra**. Therefore, its dosage is smaller.


Dosage of **benedicta** three drams. Dosage of
blancam three drams. Dosage of **pill artetica** *(arhritis pills)* two and
one half drams. Dosage of **pill auree** *(auree pills)* three drams.
Dosage of **pill euphorbia** *(euphorbium pills)* two drams. Dosage of
**theodoricon anacardium** three drams .


DICTO DE DOSI MEDICINARUM evacuancium phlegna dicendum est de dosis medicinarum evacuancium
melancoliam:
i.e. having spoken of the dosage of medicines which purge **phlegmatic humor**, it is meet to
speak of the dosage of the medicines which purge


---

p.105



melancholia, and since we have stated the dosage of **yera Rufini** it is right y for us to state the dosage of the other medicines. Let us consider **diasene** first. Its dosage is one half ounce. Dosage of
**triffera sarracenica** three drams. Dosage of **theodoricon eupheriston**[34](javascript:footNote('T600021/note034.html')) two drams. Dosage of **yera logodion** two and one half drams. Dosage of imperial cathartic one dram.


DICTO DE MEDISINE ET DE DOSI MEDICINARUM
evacuanciam melancolian dicendum est de dosi medicinarum euanciantium colera rubiam: i.e. having spoken of the dosage of the medicines which purge **melancholia**, it is meet to speak of the dosage of the medicines which purge choler, and so first of all of diaprunes. Its dosage is one half ounce. Dosage of **electuary** of **sugar of roses** three ounces. All of these are the maximum doses for the compound medicines.


Be it known unto you that it is proper to make bitter with one dram of **agaric** corrected by one dram of **licorice** the medicines which, like **paulinum**, purge the **phlegmatic humors** of the chest and of the respiratory organs. With one dram of **turpeth**, corrected by one dram of powdered pepper, or by **myrobalan indici**, or **chebula** in accordance with the dosages already mentioned, or by **cassia fistola** or by **esola** in accordance with their dosages, it is proper, indeed, to make bitter the medicines which purge **phlegmatic humors** of the **stomach** and of the liver.


It is proper, indeed, that the **laxatives** which purge the **hot humors** be made bitter with another medicine such as **myrobalani citrini**, **rhubarb**,
 **reuponticum** or by **scammony** which has been corrected,
or by **cassia fistola** or manna, or by **tamarinds** 
together with **scammony**. Should the liver complaint be chronic, however, let not the medicine 
be made bitter by **scammony** *in dropsy*[35](javascript:footNote('T600021/note035.html')) since that destroys the **liver**, but let it be done with **esola**, or **rhubarb**, and let these bitters be put in


---

p.107



the medicines in accordance with the dosages we have already written of.


The **laxatives** which purge the **phlegmatic humors** of the **spleen** are made bitter by two scruples of **lapis lazuli** that have been well washed, or by **lapis Armenicus**, **senna**, **agaric**, or **esola** according
to their individual dosages.


The medicines which purge the **phlegmatic humors** of the **kidneys**, **bladder**, and **womb** are made bitter
by **lapis lyncis**[36](javascript:footNote('T600021/note036.html')) **lapis spongie**[37](javascript:footNote('T600021/note037.html')), **agaric**, **scammony**, **esola**, and Jew-stone i.e. Jewish[38](javascript:footNote('T600021/note038.html')) which has been well
washed. Their quantity, two scruples. Should they be **hot humors** which accumulate in the same members
let them (the medicines) be made bitter by **scammony**, **rhubarb**, **reuponticum**, or **cassia fistola** according to their individual dosage.


Should **phlegmatic humors** accumulate in the **joints**, let the medicines be made bitter by **hermodactylus**, **turpeth**, or **esola** according to their individual dosage. Should they be **hot humors** which are accumulated in them, let the medicines be made bitter by **scammony**, **rhubarb**, **reuponticum**, or **cassia fistola**. Take note that medicines such as **scammony**, **turpeth**, **agaric** and the like, which are very potent and virulent, should be corrected by the aforementioned medicines before mixing them with the **compounds**, according to their individual dosage. Note particularly
it is proper that the dosage of the bitters which enter into the **composite medicines** should be, as it
is said in the treatise on the **simples**.


Note particularly that just as it is proper to observe four conditions when administering the **simples**, i.e. **strength** *(i.e. virtue)*, **age**, **season**, and **habit**, so in the same way it is proper to observe the same conditions when administering the **composite medicines** together with the four **conditions** which it is proper 
to observe when purging the **evil humors**. First of these conditions: the time of the **paroxysm**, i.e. the **access**. Second condition: the **time of digestion**. 


---

p.109



Third condition: the **season of the year**. Fourth condition: the **quantity of the humor** 
which is to be evacuated. It is always proper to purge the humor at the time of the **access** since **Haly** says that should the force be strong and the matter small and light let it be purged with a **gentle medicine** such as **cassia fistola**, and **manna**. For that reason the ancients were accustomed on the day of the **paroxysm**, as is evident in **quartan fever**, to give a **laxative powder** one hour before the **paroxysm**, and by this means a great many were healed.


The **time of digestion**; moreover for only when the matter is digested is it proper to administer the medicine to purge the particular humor, just as **Hippocrates** says, ‘Digesta medicare, et cetera.’ For
that reason **Avicenna** says that there are two things which assist the operation of the medicine, i.e. digestion
of the matter, and **openness of the passages**. The season of the year also since **Avicenna** says that it is proper to observe it as an adjuvant to purging; because at the time when the constellation called **canis major** is rising such as is visible in the summer, or at the time of severe cold such as the winter, **laxatives** are not suitable to take. For that reason **Hippocrates** says; ‘Sub Cane et ante canem, et cetera.’ The medicine is suitable, however, to administer in the spring and autumn. Yet, should purging be necessary,
and the **constitutional vigor** (of the patient) be good, hindrance by anything is not to be considered. For that reason it is possible to cause purging in the summer and in the winter. That is properly done, however, with **mild medicines** such as **cassia fistola**, **manna**, and **tamarinds**.


The fourth condition, the **quantity of the humor** which is to be evacuated: and **Avicenna** says that is twofold, i.e. the **quantity according to measurement**, and the **quantity according to quality**. Quantity according to measurement: such as one ounce,
or one dram. The quantity according to quality:


---

p.111




i.e. the **gradation of the degree**.


It is relative to the quantity of the measurement that **Galen** said in his Megategne, ‘Quantitas eorum quae offeruntur letteris non est determinata’: i.e. ‘the quantity of things administered is not determined by scholarship,’ i.e. by the senses; for neither the
quantity of the measurement of the humor, nor the quantity of the efficacy of the cure is easily determined
by the senses but according to the judgment, or opinion of the physician who is close to being
exact. For that reason **Haly** says: ‘Oportet quod medicus sit bone rememoracionis, velocis solercie sane intellectus, et cetera:’ i.e. it is necessary for the physician to have a good memory, ready wit, sound
understanding, good eyesight, and much balance.[39](javascript:footNote('T600021/note039.html')) **Avicenna** says, however, that the measure of the quantity of the amount is recognized in accordance with the measuring system of the profession, from two circumstances, i.e. from the nature of the member and the extent of the affection, and from the suitability of particular things such as class, age, habits, season, predisposition, calling, strength, and mode of administration.


The quantity of the quality of the **degree**: for should the humor, indeed, be hot it is proper to administer for it a medicine that is **contrary** in quality and **degree**; and should the humor be cold it is proper to administer for it a hot medicine of the **degree** in which it is.


The fifth condition which must be observed in purging the humor: the place where it is located.
Should it be at the **cardiac orifice** it is proper to purge it by **vomiting**, and should it be in the **fundus of the stomach**, or in the **intestines** it is proper to purge it with a **laxative**. And so on for the other places, it being proper to purge them through convenient regions.


Note particularly that some of the medicines are administered as a **solid substance**, and 


---

p.113



others as a **liquid substance**. The medicines administered as a **solid substance** are always in **pills**, or **electuaries**. Should they be in **pills** it is proper to administer them together with wine and a wafer at the
beginning of the night. It is proper to sleep on them since they require a powerful heat to dissolve them, and the heat passes into the **internal members** at night. For that reason **Avicenna** says: ‘Cum aliquis medicinam solutiuam biberit melius est si medicina fuerit fortis ut super eam dormiat:’[40](javascript:footNote('T600021/note040.html')) i.e. when a person drinks a **laxative** it is best for him, should the medicine be strong, to sleep on it before it operates as its efficacy is thus improved. It is best for him, should the medicine be weak, not to sleep on it, since nature would digest it. For this reason it is proper that the medicine administered as a **soft substance**, because of its mildness, should be administered in the morning when sleeping is
finished. However, **Haly** says that, should the **patient** be feeble or weak, or should it be summer time, one should take as a draught before going to bed a medicine which is mildly laxative; that it is not proper to sleep on it after purging, and that, whatever medicine it might be, it is best not to sleep on it when the medicine begins to operate.


Note particularly how **Avicenna** says that it is not proper to administer **pills** when they have become dry, when they are like stones, or when they are soft; but when they commence to dry, and when they yield before the fingers on being pressed.


The **electuary**: it is indeed proper to administer it at midnight between the hour for the **pills** and the hour for the **liquid medicine**, because it is easier to dissolve the **electuary** than the **pills**, and harder than the **liquid medicine**.


Note particularly that there are four species of the **liquid medicine**, for there is one species
called **cholalogue** which purges **choler**, another called **melanagogue** which purges **melancholia**, another called **phlegmagogue** which purges **phlegm**,


---

p.115



and another called **emmenagogue** which purges the **sanguine humor**.


A **cholalogue** is made thus: take **violet blossoms**, *and **borage blossoms**,* of each four ounces; **prunes** fifty; **myrobalani citrini** two and one half ounces; **cassia fistola** when cleaned, **tamarinds**, **rhubarb**, and **manna**, of each item two drams. Let the **rhubarb** and the **myrobalan** be strained.


An **emmenagogue** is made of the same items, with the exception of not containing the **myrobalan** and **rhubarb**; for **Avicenna** says the medicines which purge **choler**, purge **sanguine humor** also.


A **melagogue** is made thus: Take **thyme**, **epitimus**[41](javascript:footNote('T600021/note041.html')), and two species of **sticados**, of each item two drams; **borage blossoms**, and **violets**, of each two ounces; ***Indian myrobalan***, and **chebuli**, of each one ounce; **triffera sarracenica**, one half ounce; and ***lapis lazuli*** when well washed one half ounce. Let the **myrobalan** and **lapis lazuli** be well strained, or as we have already saidd give after manipulating it for five or six times.


**Phlegmagogue** is made thus: Take **anise**, **maratrum**, **ameos**, of each item one ounce; **myrobalan chebuli**, two ounces; and **turpeth**, half of one dram. It is possible, depending on the variation of the member to include **benedicta**, **yera pigra** when made mild, or other items. Let the **myrobalan** and the **turpeth** be strained, however as we have said.


DICTO DE MEDICINIS LAXATIVIS dicendum est de opiatis: i.e. having spoken of the **laxatives** it is meet to speak of the **opiates**. They are called **opiates** because of the **opium** which enters into their **composition**. Note particularly that the **opiates** have three **virtues**, i.e. the virtue of checking the **flux of the humors** which run to an affected part; the virtue of strengthening the part towards which they flow; and the virtue of **consuming the humors**. Note particularly that there are **opiates** which are administered before the **laxative**. Of these


---

p.117


**dyamoron**[42](javascript:footNote('T600021/note042.html')) is an example; for should it be compounded with an item in which has been boiled **rose**, and **licorice** which has been cleaned, it checks the **flux of the humors** to the **muscles** of the **throat**. For that reason it is suitable for **quinsy**.


**Tyriacla**, i.e. the *theriac*[43](javascript:footNote('T600021/note043.html')) Should it be mixed with wine in which **sage** is boiled, and given as
a drink, it prevents poison from penetrating to the **heart**. For that reason it is suitable as an antidote to **poison**.


**Athanasia**[44](javascript:footNote('T600021/note044.html')) : should it be compounded with extract of **plantain**, and administered as a drink it checks the **blood** and regularizes the **pulse**. For that reason it is suitable for **haemorrhage**. The dosage of this **opiate** is one to two drams.


**Aurea Alexandrine**,[45](javascript:footNote('T600021/note045.html')) indeed, is one of the **opiates** administered after the **laxatives**. Let it be administered when it has been compounded with hot water. Let a **gargle**[46](javascript:footNote('T600021/note046.html')) be made from it. It is suitable for all head affections, and for a **flux of rheum** to the eyes, ears, and gums. Should it be administered after another medicine, however, administer it when getting a **bath**. In that way it is suitable for persistent **quotidian fever**.


**Mithridate**[47](javascript:footNote('T600021/note047.html')) and **musa enea**:[48](javascript:footNote('T600021/note048.html')) administer them after the medicine, and before the **access**, and when they have been compounded with tepid wine through which water has been put, and they will consume the humors. For that reason they are suitable, prior to the time of the **access**, said in the manner we have
mentioned, for those who have **quotidian fever**. Following the medicine and prior to the time of
the **access**, it is proper to administer **rubea troches**,[49](javascript:footNote('T600021/note049.html')) and **recuies** when they have been compounded with hot water since they check the **flux** of the **choleric humors** to the location of the **putrefaction**, and consume the matter. For that reason they are suitable
for those who have **tertian fever**.




---

p.119


Should **micleta**[50](javascript:footNote('T600021/note050.html')) along with extract of
**plantain**, or **syrup of myrtle** be given to drink after the medicine, it is suitable for, and relieves
miraculously **hemorrhoids** which are bleeding immoderately.It is excellent for **dysentery** and **lientery**.


This suffices for the doses of the medicines, et cetera.


Finit. Amen











