

#A Jacobite narrative of the war in Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Jacobite narrative of the war in Ireland
==========================================


Author: Unknown
---------------


### File Description

John T. GilbertElectronic edition compiled by Beatrix Färber , Janet Crawford

 2. Second draft.Extent of text: 86744 words#### Publication


CELT: Corpus of Electronic Texts: a project of the History Department, University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2005) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E703001-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Bodleian Library, Oxford, Carte MSS 229. For further details see C. W. Russell and J. P. Prendergast, Report on the Carte Manuscripts in the Bodleian Library, Oxford 1871, p. 63. [This MS is incomplete and comprises vol. 1, consisting of 740 pages.]
3. National Library of Ireland, Dublin, MSS 476–7. [This MS is complete and consists of two volumes. Volume 2 was in possession of the Earl of Fingall, containing pp. 741–1533. This set was complemented by another copy of volume 1, in a smaller format, of 878 pages. Both volumes were acquired by the NLI in 1934.] The Fingall and Carte volumes are in the same hand, but some passages are only contained in the Carte volume.
**Other editions**2. Nicholas Plunket, Derry and the Boyne: a contemporary Catholic account of the siege of Derry, the battle of the Boyne, and the general condition of Ireland in the Jacobite war. Belfast: Belfast Historical and Educational Society, 1990. [132 pp]
**Further reading: a selection**2. An exact journal of the victorious progress of Their Majesties forces under the command of Gen. Ginckle, this summer in Ireland: giving a particular account of the several skirmishes, battles, sieges and surrenders of Athlone, Galloway, Slego, &c. together with the total defeat of the Irish at Agrim and Thomond-Bridge: and lastly of the capitulation and surrender of Limerick. London: Printed for Randolph Taylor near Stationer's Hall, 1691.
3. Walter Harris, The history of the life and reign of William Henry ... king of England, Scotland, France and Ireland. Dublin, 1749.
4. Robert Ashton, The battle of Aughrim: or, the fall of Monsieur St. Ruth. A tragedy. Dublin: printed for W. Davis, 1756.
5. John Graham, A history of the siege of Londonderry and defence of Enniskillen, in 1688 and 1689. 

Dublin: William Curry, Jun. and Co., 1829. 2nd ed.
6. John Michelborne, Ireland preserved, or, The siege of Londonderry and Battle of Aughrim; with lyrical poetry and biographical notes by John Graham. Dublin: Hardy & Walker, 1841. [Contains: Ireland preserv'd, a play written by John Michelborne, published anonymously in 1777; and, The battle of Aughrim, a verse drama by Robert Ashton]
7. C. O'Kelly, Macariae excidium, or the destruction of Cyprus, ed. J. C. O'Callaghan, 1850. [An allegory of the war from the Gaelic Irish point of view.]
8. Thomas Babington Macaulay, History of England, vol. 3 (1855), esp. p. 145. [Uses extensive extracts of the MS made by Sir James Macintosh].
9. History of the Irish Confederation and War in Ireland, vol., vii., 1646–49, pp. 184–210. Dublin: 1891. [Full articles on Treaty, 1648–9, between Charles I. and the Irish (p 11 of 'Jacobite Narrative'.]
10. Henry Mangan. 'The sieges of Derry and Limerick'. Nineteenth Century & After, 50 (1901) 459–78.
11. Demetrius Charles Boulger, The Battle of the Boyne: together with an account based on French and other unpublished records of the war in Ireland (1688–1691) and of the formation of the Irish brigade ... France. London: Seeker, 1911.
12. J. M. Flood, The sieges of Limerick, 1690–91; a narrative based on contemporary sources. Limerick: Limerick Leader, 1944.
13. D. Murtagh, 'Origins of Irish nationalism'. Studies; an Irish quarterly review, 39 (1950) 87–90.
14. J. Jordan, 'Würtemberg at Limerick, 1690'. Studies; an Irish quarterly review, 43 (1954) 219–25.
15. J(ohn) G(erard) Simms, 'The surrender of Limerick, 1691'. Irish Sword, 2:1 (1954) 23–28.
16. J. G. Simms, The Williamite confiscation in Ireland, 1690–1703; London: Faber and Faber, 1956.
17. J. G. Simms, 'Eye-witnesses of the Boyne'. Irish Sword, 6:22 (1963–4) 16–27.
18. J. G. Simms, 'The siege of Derry (1689)'. Irish Sword, 6:25 (1963–4) 221–33.
19. J. G. Simms, The Jacobite Parliament of 1689, Dundalk: Dundalgan, 1966.
20. J. G. Simms, The siege of Derry, Dublin: APCK, 1966.
21. J. G. Simms, 'The Restoration and the Jacobite War (1660–91)'. In: The course of Irish history, eds. T. W. Moody & F. X. Martin (Cork and New York, 1967) 204–16.
22. J. G. Simms, Jacobite Ireland 1685–91, London: Routledge and Kegan Paul, 1969.
23. Michael Hewson, 'Robert Stearne's diary of the Williamite campaign'. An Cosantóir, 33 (1977) 49–53.
24. Sheila Mulloy, 'French eye-witness of the Boyne'. Irish Sword, 15 (1982) 105–111.
25. P. Kelly, '"A light to the blind" the voice of the dispossessed elite in the generation after the defeat at Limerick'. Irish Historical Studies, 24 (1985) 431–62.
26. J. G. Simms, War and politics in Ireland: 1649–1730; edited by D.W. Hayton and Gerard O'Brien. London: Hambledon, 1986
27. Patrick Macrory, The siege of Derry, Oxford: Oxford U.P., 1988
28. Peter McCartney, The siege of Derry, 1689. Derry: Guildhall Press, 1988.
29. D. Murtagh, H. Murtagh, 'The Irish Jacobite army, 1689–91'. Irish Sword, 18 (1990) 32–48.
30. Michael Lloyd, Eamon O'Flaherty, 'A descriptive poem of Limerick in 1690'. Old Limerick Journal, 28 (1990) 34–36.
31. Kevin Hannan, 'The topography of the siege'. Old Limerick Journal, 28 (1990) 37–39.
32. J. G. Simms, 'The siege of Limerick, 1690'. Old Limerick Journal, 28 (1990) 52–56.
33. Laurence Walsh, 'Diary of the siege of Limerick from contemporary sources'. Old Limerick Journal, 28 (1990) 59–71.
34. John Stevens, 'The journal of John Stevens'; introduction by Laurence Walsh. Old Limerick Journal, 28 (1990) 74–88.
35. Pieter Tesch, 'The Dutch at Limerick'. Old Limerick Journal, 28 (1990) 135–143.
36. Robert Murray, 'The Diary of Bonnivert, 1690'. Proceedings of the Royal Irish Academy, 30 (1913) C, 331–341.
37. Jim Kemmy, 'A wayward wild goose: Peter Drake's memoir of the siege'. Old Limerick Journal, 28 (1990) 177–180.
38. Samuel Mullenaux, 'Diary of the siege of Limerick'; introduced by Laurence Walsh. Old Limerick Journal, 28 (1990) 191–200.
39. Kevin Hannan, 'The walls of Limerick'. Old Limerick Journal, 28 (1990) 210–211.
40. Thomas Babington Macaulay, Baron Macaulay. 'The siege of Limerick'. Old Limerick Journal, 28 (1990) 224–227.
41. Breeda Tuite, 'Battle of the Boyne'. Journal of the Old Drogheda Society, 7 (1990) 49–56.
42. James McGuire, 'James II and Ireland, 1685–1690'. In: W.A. Maguire (ed.) Kings in conflict: the revolutionary war in Ireland and its aftermath, 1689–1750 (Belfast: Blackstaff Press, 1990) 45–57.
43. Frank Noonan, The sieges and Treaty of Limerick (1690–1691) The Irish heritage series, 70. Dublin: Eason, 1991.
44. John James Noel McGurk, 'Wild geese: the Irish in European armies (sixteenth to eighteenth centuries)'. In: Patrick O'Sullivan, (ed.), The Irish world wide, vol. 1: patterns of migration (London: Leicester University Press, 1992) 36–62.
45. John Kinross, The Boyne and Aughrim: the war of the two kings. [Gloucestershire]: Windrush Press, 1997.
46. T. G. Fraser, 'The siege: its history and legacy 1688–1889'. In: Gerard O'Brien (ed.) Derry and Londonderry: history and society: interdisciplinary essays on the history of an Irish county (Dublin: Geography Publications, 1999) 379–404.
47. Kenneth Wiggins, Anatomy of a siege: the siege of King John's Castle, Limerick, 1642. Bray: Wordwell, 2000.
48. William Kelly (ed.) The sieges of Derry. Dublin: Four Courts, 2001.
49. Thomas Fraser, 'The siege of Derry'. The Glynns: Journal of the Glens of Antrim Historical Society, 28 (2000) 4–10.
50. Irish Law texts on the Internet; especially "Penal Statutes passed in the reigns of Queen Elizabeth I, William and Mary, King William III, Queen Anne, King George I and II" at the website of the Law School of the University of Minnesota, at http://www.law.umn.edu/irishlaw/.
**The edition used in the digital edition**2. A Jacobite narrative of the war in Ireland. unknownJohn T. Gilbert (ed), Photolithographic facsimile of first edition 1892Shannon University PressShannon (1971)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The text contains the editor's preface (v–xvii), table of contents (1–5), and the author's Narrative (1–192). Some of the documents appended to the printed edition are availabe electronically as separate files.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


the electronic text represents the edited text. Corrigenda are integrated. A few obsolete spellings and usages have been regularized using the reg element. The original is given in the value of the 'orig' attribute. Text supplied by the editor, J.T. Gilbert, is marked sup resp="JTG". In HTML format, both regularized spellings and supplied text are displayed in italics. Words and phrases in languages other than English are tagged; dates are tagged. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged qt and may be included in cit tags.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the text. div1=the section. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Dates are tagged.


#### Canonical References


This text uses the DIV1 element to represent the section. ### Profile Description


Created: by an unknown author (possibly Nicholas Plunket of Dunsoghly)

 (c. 1703?) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some phrases are in Latin.


##### Language: [FR] Some phrases are in French.


##### Language: [GA] One word is in Irish.


##### Language: [IT] One word is in Italian.


### Revision History


* (2010-05-03) Beatrix Färber (ed.)

* Conversion script run, header updated; encoding improved; new wordcount made; file parsed; new SGML and HTML versions created.
* (2008-09-24) Beatrix Färber (ed.)

* Keywords added; file validated.
* (2008-07-20) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, changes to file structure made; 'langUsage' revised.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-04T14:20:38+0100) Peter Flynn (conversion)

* Converted to XML
* (2005-07-11) Beatrix Färber (ed.)

* Header created, file parsed, HTML file created.
* (2005-07-01) Beatrix Färber (ed.)

* File proofed (2), more content markup applied.
* (2005-04) Janet Crawford, Co. Tipperary (ed.)

* First proofing of the text; structural and some content markup applied.
* (2005-04) Beatrix Färber and Benjamin Hazard (text capture)

* Text scanned in.




---


#### Corpus of Electronic Texts Edition: E703001-001


### A Jacobite narrative of the war in Ireland: Author: Unknown




---

p.v


Editor's preface
----------------


Few documents have come down to us from the Irish, whose resistance to England from 1688 to 1691 attracted the attention of Europe. The paucity of contemporary Jacobite writings in connection with the affairs of Ireland is assignable to the results which followed the ill-success of the Irish movements for James II., and to the calamities in which favourers of the house of Stuart were involved through the operation of penal laws. The contemporary books and tracts in relation to Irish affairs from 1688 to 1691, printed at London, were issued under governmental supervision, and as publication was not permitted without official licence, the Jacobites were effectively excluded from the press in Great Britain and Ireland.


The Narrative printed in the present volume is contained in a manuscript of which only two copies are known to exist. These were apparently transcribed about the year 1711, and are in the ordinary style of English writing of that time.


One of the copies has been long in the possession of the Plunkets, earls of Fingall, in the peerage of Ireland. The second copy was, early in the last century, acquired by Thomas Carte, author of the Life of 

 


---

p.vi






James, duke of Ormonde, a History of England and other works. With Carte's collection this manuscript came to the Bodleian library, Oxford, where it is now preserved.


The work is anonymous, and little information has been obtained as to its authorship. According to a late earl of Fingall, family tradition ascribed the production to Nicholas Plunket. He is said to have been an eminent lawyer, member of a branch of the house of Fingall, but of his career no precise details are accessible.


The Plunkets or Plunketts were among the most eminent of the Anglo-Irish Roman-Catholic adherents of Charles I. and his family. The chief houses of the Plunkets were those of which the heads were the earl of Fingall, the barons of Dunsany and Louth. Peter'Plunket, fourth earl of Fingall, was only eight years of age at the accession of James II. in 1685. Christopher Plunket, lord Dunsany, served that king as a captain in the cavalry regiment of Henry Luttrell. Captains, lieutenants and ensigns of the name of Plunket were included in the infantry regiment levied for the same king by Oliver Plunket, lord Louth. In the Light to the Blind are incidentally mentioned sir Nicholas Plunket, member of the supreme council of the Irish Confederation, 1642, and Margaret Plunket, dowager countess of Fingall, one of the witnesses to the birth of prince James Francis Edward Stuart. The Narrative here printed contains references to Walter Plunket, a commissioner of the mint at Dublin for James II; Richard and Christopher Plunket, of the regiment of lord Louth; and brigadier Patrick Plunket, described as a very experienced officer of foreign education,’’

 who served in Limerick during the siege of 1691.


The author of the Narrative may have been connected with Plunket, who, under the pseudonyme of "John Rogers," acted in 1713-14 as a diligent secret agent in England and on the continent in the interest of James Francis Edward Stuart, with whose secretary, David Nairne, he maintained communications in relation to the projected return of that

 


---

p.vii






prince to England as king James III. In one of these despatches, in 1713, Plunket mentioned that he had been educated for some years in Germany; in another he referred to his intercourse with lord Fingall whom he described as no man of great parts, but most zealously honest’’

 to "James III."


The Narrative is the production of an earnest advocate of the Stuart cause and of the rights of the Roman Catholics of Great Britain and Ireland. James II. is throughout styled the king of England, and William III. is designated the prince of Orange. The conduct of the adherents of William III. in Ireland is, in the Narrative, referred to as a revolt against the authority of the lawful monarch.


As elucidatory of the position of the Irish at the accession of James II., there is, in the present volume, prefixed to the Narrative, the author's account of the treatment of Irish royalists under the acts of settlement and explanation, 1661-65.


The Narrative supplies accurate information not elsewhere accessible on affairs of England and Ireland at the period of the Revolution of 1688, and in relation to persons engaged in the civil transactions and military operations of the time. The author was apparently acquainted with individuals who had taken prominent parts in the affairs which he chronicles. Statements and views expressed among the Jacobites on the various events and matters in which they were concerned, are detailed and discussed in the Narrative.


A strong belief in the capacity and integrity of the lord lieutenant, Richard Talbot, duke of Tyrconnell, is expressed by the author. The duke's death, he wrote, pulled down a mighty edifice—a considerable Catholic nation—for there was no other subject left able to support the national cause.’’




Our author was of opinion that if the duke of Tyrconnell had lived, he would not have accepted any offer for the surrender of Limerick, because he expected to retrieve the country by protracting the war. Tyrconnell, we are assured, grounded his

 


---

p.viii






expectation upon the courage of the Irish army, made evident by the battle of Aughrim, and upon the reinforcements he expected to receive from France in the following spring. This estimate of Tyrconnell coincided with that entertained by the Jacobite attorney-general, sir Richard Nagle. On the day of Tyrconnell's decease, Nagle wrote that as the duke appeared always zealous for his country, so his loss at that time was extremely pernicious to the welfare of this poor nation.’’




Sarsfield is censured by our author for having joined the party of officers who dissented from the views of Tyrconnell, when he proposed to make terms with William III. before the siege of Limerick in 1690. Further on, however, he describes and praises the noble feat’’

 achieved by Sarsfield in intercepting the hostile artillery on its way from Dublin to Limerick.


The author of the Narrative explains that he regarded the Irish Catholics as the nation of Ireland,’’

 on the ground of their being the ancient proprietors, and because the other inhabitants of the country were few in proportion, and deemed generally but intruders and newcomers.’’
In view of the remarkable loyalty of the Irish Catholics to the crown, the author argued that if the king secured them fully in their rights, he might never fear rebellion in England or Scotland, because the Irish would be insuperably powerful, as having the kingdom *of Ireland* entirely to themselves by an established possession.’’


Looking forward to the establishment of James III. on the throne of England, the author indicates, as follows, some of the measures to be adopted for the benefit of Ireland under an Irish government: the restoration of the Irish to their estates from which they had been excluded; to make the parliament of Ireland absolute in enacting laws without being obliged to send beforehand the prepared bills, which are destined to pass into acts by the consent of both houses of parliament

 


---

p.ix






for the king's precedent approbation of them, it being sufficient to have the king's assent given unto them by the voice of his deputy after the said bills have passed both the houses; to make the judicature of the nation determine causes without an appeal to the tribunals of England; to give full liberty to merchants to export the product and manufacture of the kingdom, and to import foreign goods without an obligation of touching at any harbour of England; to erect studies of law at Dublin; to put always the viceroydom into the hands of an Irish *Catholic*; to set up a silver and gold mint in the capital city; to confer the principal posts of state and war on the *Catholic* natives; to keep standing an army of eight thousand *Catholic*; to train a *Catholic* militia; to maintain a fleet of 24 warlike ships of the fourth rate; to give the moiety of ecclesiastical livings to the *Catholic* bishops and parish priests during the life of the present Protestant bishops and ministers, and after the death of these, to confer all the said livings on the Roman clergy; to make the great rivers of the kingdom navigable, as far as it is possible; to render the chief ports more deep, and thorough tenable against any attacks from sea; in fine, to drain the multiplicity of bogs, which being effected will support a vast addition of families.’’


Views of the Jacobites of Ireland in relation to the acceptation of William III. as king of Great Britain, appear at page 182 of the Narrative. In connection with this subject the author wrote:


But you'll say: that England, the principal kingdom of the monarchy, ought to be followed by heland in owning or disowning the kings of that monarchy. We answer thus: that the behaviour herein of the people of England is no rule to Ireland; a distinct realm, a different nation, as having a viceroy for governor sent by the king as king of Ireland; also as having discrepant laws; as having a Parliament of her own, so judges and magistrates. Ireland *had* never acknowledged her king to be chosen by the people, but to succeed by birth; nor her king to be deposable by the people upon any cause of quarrel. She knows more righteous things, and scorns to make heretical England her pattern in the point of righteousness. When the lawful king of England dies, Ireland acknowledges immediately the person next in blood, be *Catholic* or Protestant, to be the king of England and her's, whether the people of

 


---

p.x






England consent to it or not, as she did when king Charles the first was dead, whose eldest son, Charles the second, she owned as her true sovereign, and signed that acknowledgment in characters of blood, though at the same time England rejected him, until being weary of her rebellion, she received him at last as her undoubted king. Therefore bring no more England as a prototype of behaviour towards the crown unto Ireland.’’


The Narrative closes with brief notices of the departure to France of the Irish troops and Jacobite officials, and the proclamation in March, 1692, by which William III. declared the war in Ireland to be at an end. At the conclusion of the Narrative the author expresses his opinion that the king or France made a false step’’

 in European politics in not having aided to maintain the Irish war.
In illustration of subjects mentioned in the Narrative, some documents have been appended, which may be noticed as follows:



1. I. The letter addressed by sir Richard Nagle, in 1686, from Coventry, to the earl of Tyrconnell, in relation to the injustice inflicted on the Irish by the act of settlement, and in advocacy of its appeal.
2. II. French official list of Jacobite army in Ireland, 1689. In this document are included the following particulars of most of the regiments: names of colonels, lieutenant-colonels, captains, lieutenants, ensigns, cornets, surgeons, almoners, quarter-masters, together with the numbers of sergeants and effective men in each company. This list, now for the first time printed, extends from page 201 to page 241. It was apparently compiled by a French official. The orthography of the names is in many cases peculiar, and they are here printed as they stand in the original manuscript. In the regiments were comprised French, English, Old Irish, and Anglo-Irish officers, chaplains and surgeons. The lists indicate the vitality of the Irish after the severities to which they had been subjected during the preceding forty years. The names afford evidence that identity of interests had led descendants of com'paratively recent settlers to combine with representatives of the older inhabitants. Of this an illustration is found in the family of the poet


---

p.xi






Edmund Spenser. That writer, by his advocacy of severe measures against the Irish, was regarded by them as an enemy to their race. We find, however, that his grandson, Hugolin Spenser, espoused the Irish cause, and became a lieutenant in the regiment raised in Munster by Dominic Sarsfield, lord Kilmallock, to serve against the army of William III. Hugolin Spenser thus eventually forfeited his right in the estates at Kilcolman, in the county of Cork, which queen Elizabeth had granted to his ancestor.
3. III. List of members of parliament at Dublin, 1689.
4. IV. Extracts from acts of parliament at Dublin, 1689. The first of these acts, asserting the independence of the parliament of Ireland, is in accordance with the principle enunciated many years previously by the supreme council of the Irish Confederates. It is noteworthy that neither Molyneux, in his ‘Case of Ireland being bound by acts of parliament in England,’ nor Grattan, in his motion on the declaration of right, 1782, made any reference to the circumstance that the independence of the parliament of Ireland had been specifically asserted by the Irish Confederates in 1642, and by the parliament at Dublin in 1689. In the preamble to the second act the given reasons for repealing the acts of 'Settlement and Explanation', in relation to which many details appear in the present volume. The preamble to the act of repeal set forth that it was ‘now, high time to put an end to the unspeakable sufferings of the Roman *Catholic*, natives of this realm *of Ireland*, who have eminently manifested their loyalty to his majesty *James II* against the usurper, the prince of Orange, and to remove the unparalleled grievances brought upon them under colour of the said two statutes *of Settlement and Explanation*, which cannot be otherwise redressed than by repealing the said acts and restoring the former proprietors to their ancient right, the compassing whereof is


---

p.xii




much facilitated by his majesty's royal condescension to apply towards the satisfaction and reprisals of honest purchasers under the said acts a great part of the lands and tenements forfeited to him by the late rebellion and treason committed by estated persons within this kingdom, who, contrary to their duty and allegiance, joined with the prince of Orange.’
5. V. Letter, signed by sir Richard Nagle, to the officers and soldiers, subjects of James II., in the army of Schomberg or Schönberg, as an appeal to them to return to the service of their king and country. The writer refers to William III. as a prince without nature towards his father, without honour towards his enemy; an oppressor of his own country, an usurper of yours; unfortunate in war, unfaithful in peace; postponing his oath in the business of Stadholder, to compass his ambition, and the laws of humanity in the death of De Witt, to gratify his revenge.’’


 At the close of the appeal, the author, in refeence to the composition of the forces brought against Ireland, wrote: Multitudes of strangers and foreigners of desperate fortunes and *several* nations ... are contriving your slavery, together with the old invaders of our country, the Danes, who held our ancestors in a war of three hundred years, and their insolence became intolerable to a proverb, till the very women fell upon them with the indignation of so many Judiths.’’ In this and other Jacobite documents the writers ignore the dukedom conferred in England on Schomberg, and designate bim by his previous title of count. The Jacobites described Schomberg as an antiquated and almost effete but still rapacious mercenary in the pay of the prince of Orange. They charged him with having countenanced cruelties and the violation of articles into which he had entered with officers of the Irish army.
- VI. Order for French convoy of artillery in Ireland, 1689, with directions for the march from Cork to Dublin. The concluding part of this document is not forthcoming.



---

p.xiii


- VII. Order, in French, by **general de Lausun**, 1690. In this ordinance **Lausun**, in the name of Louis XIV., prohibits French officers and soldiers in Ireland from taking anything without payment, and expressly forbids them to enter or act offensively in Protestant churches or places of worship.

- VIII. Letters from colonel William Wolseley to sir Robert Southwell, secretary of state to William III. In these communications, dated from the English camp at Mullingar, Wolseley describes his proceedings in pursuing and executing Irish Tories. I am,’’ he writes, well assured that an Irishman is to be taught his duty only by the rod.’’ These people, he says, declared they would die before they would submit to king William's government. I am of opinion,’’ added Wolseley, that fair means will never oblige these people to a true submission to his majesty’’ *William III*

- IX. Contemporary French account of the siege of Limerick, 1690. This document supplies notices of daily occurrences during the siege in August and September. It furnishes many details in connection with the actions of the Irish in Limerick and their assailants. William III. in it, as in the Narrative, is styled the prince of Orange, and the Irish troops are designated the army of the king of England. The writer mentions that four hundred Ulstermen of the regiment of MacMahon, who were not furnished with arms, greatly incommoded the besiegers by casting stones. The total loss of the assailants is set down as five thousand men, among whom were many of their colonels and best officers. The Irish officers and soldiers, adds the account, signalized themselves throughout the entire siege by their bravery and by their extraordinary endurance. They were, we are here told, continuously under arms, and without either the necessaries of life or medical appliances for their sick and wounded.



---

p.xiv


- X. Letter and statement by Hugh (Balldearg) O' Donnel, addressed to comte D'Avaux, minister of Louis XIV. The writer of these documents, Hugh O'Donnel, a colonel in the service of Spain, descended from chiefs of his name in Donegal. He was called in Irish, Balldearg or "of the red spot," and the author of the Narrative mentions that some of the family believed that the true earl of Tyrconnell, marked on his body with such a spot, would come from abroad into Ireland, and do there great matters for his country.’’ In the memoir before us O'Donnel describes the three classes of the people in Ireland and their antecedents. The Catholics of the ancient race of Ulster were, he alleged, the most warlike of the Irish people; and he averred that they were the most oppressed on account of their fidelity to their religion and country. He states his objections to the courses adopted by the administrators of James II. in Ireland, and especially censures them from excluding from posts of honour the representatives of the Irish of the ancient race. O'Donnel, as a direct descendant of the first earl of Tyrconnell, protests against the recent grant which had been made of that title to the viceroy, Richard Talbot. He requests D' Avaux to place at his disposal a suitable proportion of the supplies expected from France,’’ and with them he considered he could oppose effectively the hostile forces in Ireland.

- XI. Prisoners at Ballymore. In this list are given the names of the Irish Jacobite officers made prisoners on the surrender to Ginkel of the garrison at Ballymore, Meath, on the 8th of June, 1691, together with the names of the regiments to which they belonged.

- XII. The battle of Aughrim, July, 1691. The arrangement of the army under the command of Ginkel at this battle is here given as it was published, by authority of that general, at Amsterdam in 1693. This table exhibits the accuracy of the statement in the Narrative, that the better moiety’’ of the army of England brought on this occasion against the Irish was constituted of foreigners. The general was Ginkel,

 


---

p.xv




 

and chief in command under him was the duke of Würtemberg. The former bore testimony to the great bravery evinced by the Irish at Aughrim. The battle, according to Ginkel, was obstinate and close, and on both sides there was horrible carnage’’ Major-general Hugh Mackay, who took an important part in the battle of Aughrim, referred to the fact that the Williamite troops were composed of four or five different nations. A Huguenot officer, who served in the army of William III. against the Irish, mentioned the difficulties which he experienced in managing the military under his command, arising from the circumstance that they were composed of nearly all the nations of Europe. My lieutenant, he wrote, spoke French, and the cornet Flemish and German.’’

- XIII. This description of the battle of Aughrim is from a contemporary Latin poem by a Jacobite on affairs in Ireland, 1688-91. The production, hitherto unpublished, is specially valuable for the information which it supplies in connection with English and Irish Jacobites. In his description of the battle of Aughrim the author notices the acts of Cuconacht Maguire *Guevarrus*, Charles Moore, Ulick Bourke, the youthful lord Galway, brigadier William Barker, an English Jacobite, and others who either fell in the engagement or were taken prisoners. Dean Alexius Stafford, of Wexford, is also mentioned in the poem. He fell,’’ we are told, in the front of the royal regiment as he was encouraging them upon the first charge.’’ The poet's description of the death of general St. Ruth, at the point of victory, and the subsequent action of Sarsfield, corresponds with the statements on these subjects in the Narrative. The allusions in the poem to a mercenary traitor were probably directed against colonel Henry Luttrell. It may be here mentioned that the passages of the Narrative, at pages 149-50 of the present work, in relation to Luttrell, are in the Bodleian manuscript, but they do not appear in the Fingall volume.

- XIV. Letter from sir Richard Nagle. This communication was


---

p.xvi






addressed to Fitzwilliam, lord Merrion, by the Jacobite attorney general, from Limerick, when the army of England was approaching to lay siege to that town in August, 1691. Nagle deplores the death of the viceroy, Tyrconnell, which had just occurred, and mentions the arrangements which had been made for carrying on the government in Ireland for king James.

- XV. This contemporary diary of the siege of Limerick, 1691, was written by colonel Richards, an officer of repute, highly esteemed by William III. It extends from the 25th of August to the 25th of September, at which date the preliminary negotiations for the treaty were in progress. The manuscript of this diary was formerly in the possedsion of the duke of Buckingham, at Stowe, subsequently passed into the Ashburnham collection, and is now in the library of the Royal Irish Academy, Dublin.

- XVI. The treaty of Limerick. The civil and military articles are here given in full, as signed in October, 1691.

- XVII. Letters from Patrick Sarsfield, earl of Lucan. The first of these letters is an application for passports for officers of the Irish army. The second letter is addressed to baron de Ginkel in relation to arrangements for the embarkation of Irish troops for France.

- XVIII. Letter from John Wauchope to George Clarke, secretary at-war. Wauchope, a Scotch Catholic, was major-general in the Jacobite army in Ireland. He possessed the confidence of Tyrconnell and Sarsfield, and took part in the preliminary negotiations at Limerick. To Wauchope's letter is appended a statement of the reasons which induced the French commander at Limerick to consider a capitulation desirable.

- XIX. James II., in this letter, declares himself to be extremely satisfied’’ with the conduct of the Irish officers and soldiers, and expresses his gratification at their decision as to serving him in France.

- XX. Under this document the earl of Lucan certifies that the

 


---

p.xvii






arrangements had been carried out for the conveyance of the Irish forces to France.

- XXI. Ratification of the treaty of Limerick, 1691-2. In this instrument are included some words which had been omitted in the manuscript of the treaty. The circumstances of this omission and the mode of rectification are stated in the documents printed at pages 313-16 of the present volume. Sir Theobald Butler, referred to in these papers, was an eminent lawyer. He acted as a commissioner for the Irish in connection with the treaty. Butler, on behalf of the Catholics of Ireland, pleaded, in 1703, at the bar of the parliament at Dublin against the infringement of the treaty of Limerick, the observance of which had been guaranteed to them in a most solemn manner, on the public faith of the nation. At the end of the volume will be found an official list of the personages who accompanied James II. from France to Ireland in 1688-9, together with the names of the ships on which they embarked. In addition to the reproduction of the engraved portrait of Sarsfield, earl of Lucan, a facsimile of one of his letters has been included in the present volume. Facsimiles are also given from an order by general Lausun, and from letters of sir Richard Nagle and colonel William Wolseley.

Villa Nova, Blackrock, 

Dublin, 20th November, 1891.John T. Gilbert.


---

p.1





| Topic | Page |
| --- | --- |
| Treatment of Irish royalists on the restoration of Charles II. | 1 |
| Position of Charles II. in relation to the Irish | 2 |
| Devices against restoration of Irish royalists | 4 |
| Ancient Irish and old English of Ireland | 5 |
| Cromwellian settlers in Ireland | 6 |
| Charles II. and house of peers in England | 7 |
| Proceedings in parliament, 1660 | 8 |
| Legislative injustice to Irish royalists | 9 |
| Irish nobility and gentry | 10 |
| Treaty, 1648-9, between Charles I. and the Irish | 11 |
| Letter from Louis XIV. to Charles II. on behalf of the Irish | 12 |
| Irish delegates to England | 15 |
| Royal declaration for settlement of Ireland, 1660 | 16 |
| Case of the Irish.—Statements and answers | 20 |
| Conduct of Charles II. | 22 |
| Parliamentarians and regicides | 23 |
| Exile and restoration of Charles II. | 24 |
| Cromwellians in England and Ireland | 25 |
| Edward Hyde, earl of Clarendon, chancellor of England | 26 |
| Disasters to Irish royalists | 27 |
| Associates of chancellor Clarendon | 28 |
| Requirements under act of settlement | 29 |
| Legal devices of Cromwellians | 30 |
| p.2 |
| Cromwellians in parliament, 1661 | 31 |
| Legislation for settlement of Ireland | 32 |
| Court of Claims at Dublin, 1663 | 33 |
| Act of explanation, 1665 | 34 |
| Injustice inflicted on the Irish nation | 35 |
| Position of the Irish, 1688 | 37 |
| Jacobite projects for amelioration of Ireland | 39 |
| Movements in Ireland for prince of Orange | 40 |
| Proceedings at Londonderry and Enniskillen | 41 |
| Affairs in Munster—Bandon—Kinsale | 42 |
| Lord Mountjoy and sir Stephen Rice | 43 |
| Measures of Tyrconnell, governor in Ireland for James II. | 44 |
| Transactions in Ulster—Cladybridge | 45 |
| Arrival of James II. in Ireland, 1688-9 | 46 |
| James II. at Dublin | 47 |
| Resources of the Irish | 48 |
| Jacobite management of civil and military affairs | 49 |
| The Irish at home and abroad | 52 |
| Jacobite privy council and officers of state in Ireland | 52 |
| Dukedom conferred on Tyrconnell | 52 |
| Disbandment of part of Jacobite army | 52 |
| James II. and privy council at Dublin | 54 |
| The nation of Ireland—Classes in Ireland | 55 |
| Cromwellian settlers in Ireland | 56 |
| Acts of settlement and explanation | 57 |
| Reasons for abrogation of those acts | 59 |
| James II. and Londonderry | 62 |
| Political errors of James II. | 63 |
| p.3 |
| Siege of Londonderry | 64 |
| James II. and parliament at Dublin, 1689 | 69 |
| Repeal of acts of settlement and explanation | 69 |
| Acts of Jacobite parliament | 69 |
| French squadron at Bantry | 70 |
| League of Augsburg | 71 |
| Observations on governments | 72 |
| Suggestion on arbitration between states | 73 |
| Conduct of Catholic Princes | 74 |
| Actions at Londonderry | 75 |
| MacCarthy, lord Mountcashel.—Anthony Hamilton  | 81 |
| Engagement Newton-Butler | 82 |
| Mismanagement by officers of James II. | 83 |
| Relief of Londonderry.—Irish losses | 84 |
| Affairs in Scotland | 86 |
| Marshal Schomberg lands in Ireland, 1689 | 87 |
| Movements of James II. and Schomberg | 88 |
| Sligo and Jamestown taken by Sarsfield | 89 |
| James II. at Dublin, 1689 | 89 |
| Preparations by William III. | 90 |
| Views on military operations. | 91 |
| Arrivals in Ireland from France | 92 |
| Departure of Mountcashel, with five regiment for France | 92 |
| Engagement at Cavan | 93 |
| Brigadier Wolseley.—Duke of Berwick | 93 |
| Surrender of Charlemont, 1690 | 93 |
| Camp of James II. at Dundalk | 94 |
| William III lands at Carrickfergus, June 1690 | 95 |
| Engagement near Newry | 96 |
| Movements of James II. and William III. | 97 |
| p.4 |
| Engagement at the Boyne, 1690 | 99 |
| Death of Schomberg | 102 |
| Deaths at the Boyne | 103 |
| James II. returns to France | 104 |
| Movements of William III. in Ireland | 105 |
| Condition of Limerick | 109 |
| Designs of Duke of Tyrconnell | 110 |
| Opposition to Tyrconnell | 111 |
| Considerations in relation to the war in Ireland | 112 |
| Siege of Limerick by William III., 1690 | 113 |
| Convoy intercepted by Sarsfield | 113 |
| Assault on Limerick by William III. | 116 |
| Repulse of William III by the Irish at Limerick | 116 |
| William III. departs from Ireland | 117 |
| Sidney, Porter and Coningsby, lords justices | 117 |
| Mission of Tyrconnell to France | 118 |
| Delegates to France from his opponents | 118 |
| Movements of Sarsfield | 118 |
| Baron de Ginkel, commander-in-chief in Ireland for England | 118 |
| Capture of Cork | 119 |
| Operations against Kinsale | 120 |
| Conclusion of second year of the war in Ireland | 121 |
| Engagement at sea, 1690 | 122 |
| Continental arrangements | 123 |
| Pope Innocent XI. and James II | 124 |
| Observations on papal government | 125 |
| Visit of Tyrconnell to James II. in France | 126 |
| Marquis of St. Ruth appointed marshal-general of Ireland  | 127 |
| Return of Tyrconnell to Ireland, 1691 | 128 |
| St. Ruth arrives in Ireland | 129 |
| p.5 |
| Movements of Ginkel and St. Ruth  | 130 |
| Position of Athlone | 131 |
| Opposition to Tyrconnell | 132 |
| Attack on Athlone | 133 |
| Capture of Athlone | 136 |
| St. Ruth encamps at Aughrim | 137 |
| The Irish army at Aughrim | 138 |
| Battle of Aughrim, July, 1691 | 139 |
| Death of St. Ruth | 143 |
| Observations on movements at Aughrim | 144 |
| Deaths at battle of Aughrim | 147 |
| Tyrconnell at Limerick | 148 |
| Charges against brigadier Henry Luttrell | 149 |
| James II. and Louis XIV. | 150 |
| Balldearg O'Donnel | 151 |
| Irish forces at Limerick | 152 |
| Resoluteness of the Irish army | 153 |
| Siege of Limerick, 1691 | 154 |
| Death of Tyrconnell | 155 |
| Notice of Tyrconnell and his career  | 156 |
| Observations on defence of Limerick, 1691 | 162 |
| Capitulation at Sligo, 1691 | 164 |
| Discourse on treaty of Limerick | 168 |
| Observations on siege of Limerick | 173 |
| Conditions suitable for the Irish | 177 |
| Proceedings in connexion with treaty of Limerick | 178 |
| Conclusion of treaty at Limerick, October, 1691 | 179 |
| First and second articles of the treaty of Limerick | 179 |
| Ireland, a distinct realm and nation | 183 |
| Views on relations between England and Ireland | 184 |








---

p.1


*Treatment of the Irish Royalists after the Restoration of Charles II.—acts of Settlement and Explanation.*
-----------------------------------------------------------------------------------------------------------


IT pleased Almighty God, after a long exile, to bring back Charles the second to the throne of his ancestors. His majesty landed from Holland, at Dover, in England, on the twenty-fifth day of May, 1660, and arrived at his palace of Whitehall, in London, on the twenty-ninth of the same month. There is nothing now to be seen or heard but joys and jubilees throughout the British empire, for the royal physician is come to heal the three bleeding nations, and to give them the life of free-born subjects. The great Justiciary is seated again in his tribunal, to distribute justice amongst the oppressed, which had been banished from the land for twenty years before, so that the loyal people of the three kingdoms may now call themselves happy, because they had suffered much for their prince, who, having been their fellow-sufferer, and now being restored to his power, cannot but share his happiness with them.


The first thing the king did, after his coming to London, for the settlement of his kingdoms, was to go about performing the promise he-had made in his declaration sent into England from Breda, which was to pardon all his subjects except such as the present parliament of England should think fit to leave out of the amnesty, to whose discretion he left the matter.


This parliament was chosen upon an agreement made between general Monk and the little remnant of the old rump parliament, sitting some weeks before the king came into England, by the free election of the people in general. And they sat while the king was in Flanders, and at last voted for the calling home of his majesty, that being the only way (as Monk had judged in his resolution of restoring the king) to end the long distractions of the three realms, caused by the different governments of madmen or fools, who usurped the sovereign authority from time to time. We may reasonably believe that a great many members of this parliament were of the old


---

p.2


{topic Position of Charles II}



leaven; and therefore we charge the king with a remarkable imprudence for leaving the lives and fortunes of his good subjects to the arbitration of such a parliament. And here is the first false step he made in his kingly regency, and the foundation of after calamities, by reason of the unnatural injustice which the said parliament (by virtue of that arbitrary power granted them) did to the only whole-loyal nation of the three. The king, it seems, was amazingly timorous, even at a time when he had all the guilty subjects at his feet, who expected nothing more than their lives, and a preservation of what lawful estates they had. For generally in England they were so weary in killing and destroying one another about what kind of government they should establish for their happiness, that any wise man with a moderate strength might wind them which way he pleased. The king knew who of his people were culpable and who innocent before he left their destinies to the discretionary judgement of an assembly of men taken out of that nation who had made no scruple to murder his royal father, banish himself and his family, destroy the loyalists, and especially the whole *Catholic* people of Ireland, for adhering to the king's interest. His majesty was most certain that his Irish subjects were loyal, upon record made up by himself upon the peace of 1648, which he owned in some measure before this same parliament, as we shall observe beneath. He also understood that there were many loyal families in England and Scotland which had positively stood for himself and his royal father. Why, then, would he leave their dooms to the will, and pleasure of men, amongst whom some, being Cromwellians, might retain their old grudge unto those faithful persons, and particularly keep their former design of ruining the *Catholic* of Ireland, as de facto it afterwards proved so by their concurrence with the Cromwellians of Ireland, to the destruction of the said *Catholic*, as we will let you see in its due place. What the king ought to have done was, to declare to the parliament that there was no need of a pardon to the *Catholic* of Ireland, nor to those families which had borne arms for his father in England and Scotland, and had remained constant in their fidelity to the present restoration, nor to the Scots, who had purged their rebellion


---

p.3


{topic Reference to the Irish by Charles II, 1660}



by receiving the now king into Scotland, and crowning him at Scone the first of January, 1649, that is, 1650, new style, about a year after the death of king Charles the first, nor, in fine, that there was any necessity of a pardon to general Monk and his army, who washed away the stain of their treason by contriving the king's restoration. Afterwards the king should proclaim his pardon to all the rest of his subjects, except such as signalized themselves in rebellion, whom the king himself in general terms should mark out. But if the king would choose to make the business more easy unto him, his majesty should have issued, as the custom is, an universal amnesty, with an exception of celebrated rebels, throughout his dominions, which proceeding every nation of the three would be contented with; and the devil is in it if *Catholic* Ireland would refuse the condition. But now let us see what the parliament did in this mighty affair of a general indemnity. The king, on the third day after his arrival at London, went to the house of lords, and, being seated on his throne, he sent for the house of commons; then before both houses he made a speech, in which he urged them to dispatch the act of indemnity for the quieting of his people. At the end he gave the royal assent to a bill for making that parliament lawful, because it was not called by the king's authority.


The parliament, the next day, took the king's speech into consideration, and began the framing of the bill of oblivion. The king, in eight weeks after, came to the parliament, and in his speech he had this paragraph concerning his Irish subjects, for whom he was particularly zealous in the general pardon to be given, saying thus, on thetwenty-seventh of July, 1660: ‘I hope I need not put you in mind of Ireland, and that they alone shall not be without the benefit of my mercy. They have shown much affection to me abroad, and you will have a care of my honour, and what I have promised to them.’ This was a passionate discourse, and worthy of the king, who therein was grateful1y sensible of the obligations he owed to his best subjects. But how he actually discharged this debt, and how that parliament preserved his honour in concurring to his desire of having the Irish included in the act of oblivion, we shall behold immediately.




---

p.4


{topic Plans against restoration of Irish Loyalists}
This speech of the king in behalf of the Irish gained the hearts of several members in both houses of parliament, as it did the good-will of all honest men who heard of the speech, and especially who had known the gallant fidelity of the Irish *Catholics* towards the king. But, it seems, the old design of ruining the *Catholic* nation of Ireland, at least in their fortunes, was not extinct by the king's oratory for them, nor by their monumental loyalty. Nay, the design was carried on with greater vehemency in the king's face, as if it were because the king appeared for them, or rather because the estates of the Irish were already in the possession of the Cromwellian brethren, and, therefore, by no means must those estates be taken away from them, though the world should cry shame upon the parliament and all their abettors. How this design was compassed, of excluding the Irish from the said general pardon, and, in consequence, from a repossession of their ancient inheritances, we shall here show you. The **lord Broghill (afterwards earl of **Orrery****) and **sir Charles Coote (afterwards made earl of **Mountrath****) being the most stirring men of the Cromwellian Protestants in Ireland, understanding a little before the restoration that king Charles the second would be soon settled in the throne of England:ndash;these two persons, I say, got together a meeting of their brethren, the usurpers of the Irish estates, at Dublin, to consult how they should prevent the restitution of those estates to the Irish proprietors upon the king's accession to the crown. In this consultation they resolved to imprison all the leading *Catholic* of Ireland, to the end those *Catholic* might be no assistance to the king's entrance into England if the English parliament should give resistance, unless his majesty would condescend to hard conditions, as these rebels, **Broghill**, **Coote**, and the rest did expect. Upon this resolution the prisons of Ireland were fined with nobility and gentry. Immediately after, this fanatic cabal sent **sir John Clotworthy**, that famous plunderer, into England, to disperse stories that it would be dangerous for the. new English interest in Ireland (that is, for the usurped possessions of Cromwellian rebels) to have the Irish natives restored to their lands of inheritance. Here, reader, you are to know that these terms, ‘the English interest


---

p.5


{topic Ancient Irish and old English of Ireland}

 

In Ireland must be preserved,’ have been made use of in the reigns of late Protestant kings by English Protestants for this end only, that particular Protestants might have estates of Catholicks in that kingdom, not caring by what injustice they obtain their desires. It was to this purpose that king James the first was induced by a false information to grant the lands of Ultonian peers and gentlemen to English and Scotch Protestants; and it is upon this ground that **Clotworthy** and his fellow-usurpers would now fain persuade the king and the English parliament to settle that Cromwellian scum of England in their illegal possessions of Irish lands, rather than do justice to the loyal nobility and gentry by restoring unto them their birth-rights. On the contrary, the just interest of the crown of England is only preserved in Ireland by maintaining in a high state the true conquerors of that kingdom, who by their blood annexed the Irish crown to the English diadem, for which the kings of England stand for ever indebted unto their bravery. Those victors, being *Catholic*, landed from England in Ireland, under the happy fortune of Henry the second, the English monarch, which is above five hundred years since. Their posterity have continued in the like gallantry and loyalty even to this day, propping the true kings of England, at the hazard of their lives and fortunes, while the upstart Protestants have of late years endeavoured to cast down those crowned heads, and actually prevailed. The *Catholic* noblemen and gentlemen of Ireland now living are, for the greater proportion, the descendants of those old heroes, and showed themselves such to Charles the first and Charles the second, when **Clotworthy**, **Broghill**, **Coote**, and the rest of those little fanatic scabs, demonstrated themselves enemies to the solid English interest, that is, to the crown of England. And as to the more ancient Irish noblemen and gentlemen, since they have been for several generations linked in blood to the old English of Ireland, and are of the same religion, which obliges her professors to fidelity upon pain of damnation, these persons have the same firmness of loyalty and the same interest. So that, if a true king of England, once settled in his throne, did but preserve unto the Irish *Catholic* in general all their birth-rights, he might


---

p.6


{topic Devices of Cromwellian Settlers in Ireland}



never fear a Protestant rebellion in any of his kingdoms, because in those circumstances the Irish would be insuperably powerful, as having the kingdom entirely to themselves by an established possession.


But to resume our interrupted narrative. King Charles the second at this time landed in England, as above mentioned; and thereupon the Irish gentlemen who had been a little before imprisoned in Ireland by the Cromwellian rebels, were set at liberty. However, **Clotworthy** (to improve his project) must needs go on with flinging about lies as fast as he could, and most foolish lies; for he showed counterfeited letters from Ireland, setting forth a new rebellion of the Irish, who were murdering his majesty's Protestant subjects, and violently entering into the possessions of other men; though those Irish were but immediately before delivered from prison, and wholly armless, and under the severe guard of a Cromwellian army. Notwithstanding these truths, this tale, as ridiculous as it was, moved the silly parliament so far, that they presented a proclamation to the king to be signed by him against the Irish; and his majesty as rashly signed it—which was published on the third of June, the fourth day after the king came to London—a fair commencement of his reign. **Sir John Clotworthy**, being encouraged by this success of his first endeavour, and being now assisted by the lord Broghill and other Cromwellian agents, arrived out of Ireland, is resolved to push on his good luck. These new agents brought with them bills for thirty thousand pounds sterling, in order therewith to facilitate the obtention of their aims. They tendered to the king twenty thousand pounds, as a small token of Ireland's affection to his majesty upon his coming home; as if they were the nation, and not a handful of mean strangers come thither the other day; as if they were loving subjects, and not obstinate traitors. They presented also gifts unto the royal brothers, the dukes of York and Gloucester. They gave a splendid treat to the duke of Ormonde, and another, with a gold cup, to general Monk, made duke of Albemarle. But as to **Sir John Clotworthy**, he being now aided by these, his fellow agents, and fearing that a general act of indemnity would be made, he most impudently tendered to the parliament a proviso against including the Irish therein,


---

p.7


{topic Charles II and the House of Peers}



for preventing them to get their estates, in consequence of a pardon. That notorious rebel, not being contented to obtain the grace of being pardoned by the said act his justly forfeited life, but he must also, like an atheist, strive to secure unto himself and his fellow-traitors those lands of the loyal Irish which he and his gang had acquired by rebellion. This is an impudence of which history cannot show a parallel, because it is exhibited in sight of that re-inthroned king, whom **Clotworthy** and his co-usurpers of Irish estates had kept in banishment, abjuring his very title to the crown, and exhibited against those persons whom the said king had owned good subjects by the peace of 1648, and found them such substantially from that time, both at home and abroad, unto his restoration. Here we see that when once a seared conscience reigns in people it brings them to a stupidity in all manner of righteousness, so that to do wrong, even in a great measure, is no more a check on their minds, than on the breast of the worst idolater in the world. But the king (notwithstanding the proclamation issued before against the new insurrection of Ireland, which by this time was proved false) coming to the house of peers in July following, as above said, and having made a speech in favour of the Irish, the parliament thereupon appeared to be moved to extend the act of oblivion to the Irish *Catholic*. This was a terror to the atheistical cabal; yet they will not desist till they obtain their aim. So they address themselves to the duke of Ormonde, and make to him, as it is affirmed, such large offers of compensation, that they gained the man to the destruction of his own country, and to his lasting shame. Upon this, Ormonde took an occasion to form a speech in the house of lords against comprehending the *Catholic* of Ireland in the act of indemnity, saying that the king had taken that business into his own hands. Behold here a marvellous meanness of spirit in a personage illustrious in his extraction. He strikes close friendship with men of a vile race, whose alliance in blood he would highly scorn. He embraces the party of known rebels; he associates *with* them in the blackest villainy; and to crown his baseness, he sells his country for an estate, having 


---

p.8


{topic Proceedings in a Parliament}



before enough to support his quality. Ah! it was not so with those brave heroes of ancient Rome, who preferred the welfare of their country before their parents, before their children, before their lives: Cari sunt parentes, cari liberi, sed omnes omnium caritates una patria complexa est. Ormonde thinks he has raised his grandeur upon a rock. He is grossly mistaken. Unjust acquisitions are never durable: Male parta male dilabuntur.. We see at this day the truth hereof in this, his very case; for his new great estate, which he most wrongfully possessed, to the destruction of many innocent families, is already, even in his immediate successor, almost all consumed, and his male progeny is in a fair way to be extinct. There will be no missing of it, since a better branch is to succeed. On the other side, if the duke of Ormonde had fortunately taken part with justice, and thereby set up his country and kindred, he would have proved the greatest subject of Europe, and that lastingly; for the ancient nobility and gentry of Ireland would have been contented to afford him a share in their lands, as a grateful acknowledgment of his generosity; they would be perpetual admirers of his family and sticklers to his interest. In fine, heaven would bless that high act of justice with the duration of ages. But you will say that Ormonde chose to establish Protestant religion in Ireland upon the ruin of his country. We answer briefly, true religion never does injustice. The apostles, in settling of Christianity, took not away the worldly substance of the Jews and gentiles.


But to revert to the grand business of pardoning the subjects of England, Ireland and Scotland. Both houses of parliament, being, in the greater number, evil-inclined unto the Irish as being *Catholic*, without considering justice, and being influenced by Ormonde's speech, and by the reiterated addresses of the Cromwellian agents, resolved at last to pass the bill of forgiveness, to the exclusion of the best subjects, notwithstanding the king's desire to the contrary; and so it was done, to the everlasting infamy of that Protestant parliament. The bill being thus made ready for the royal assent, the king came to the House of peers, as of custom, and gave his assent thereunto, not injustice to the Irish. Notwithstanding 


---

p.9


{topic Injustice to the Irish}



his own acknowledgment made a few days before of the affection and loyalty of the Irish towards him, and of his promise for rewarding of them; and lastly, notwithstanding his request to the parliament in behalf of his Irish subjects, as before said. So the act of indemnity came out, pardoning all the Protestants of England, of Scotland and of Ireland, who had any way a hand in the destruction of king Charles the first, and in keeping king Charles the second out of his throne, except those Protestants who sat judges over king Charles the first's life, and except the *Catholic* of Ireland. The exceptions were differenced by this, that those judges or regicides then surviving must die for their enormities, but the Irish were not to be questioned for their lives.


This is a strange act of pardoning subjects for rebellion. The *Catholic* of Ireland are left out of the amnesty, yet they are suffered to live, nor is there any clause in the act for taking away their estates. Usually a subject guilty of rebellion is first condemned to the penalty of death, and in consequence thereof his estate falls to the king. But here the Irish subject is tacitly judged guilty of rebellion, yet he is neither pardoned, nor his life taken from him, nor his estate vested in the king, though in the possession of another who is an undoubted rebel, and who had usurped the same from the said Irish subject and his fellow-subject, because the said Irish subject fought for the king against that undoubted rebel and his general. This is a labyrinth in which the parliament of England have involved themselves. I am sure they will never get out of it by showing justice in their act of indemnity, and by demonstrating sense and reason therein, inasmuch as concerns the Irish. Protestants of England and of Ireland being joined in an army under the conduct of Oliver Cromwell, fought on the land of Ireland for the government of England, that had put to death Charles the first, and kept in banishment Charles the second. This is owned. Against whom did they fight in the said Ireland? They fought against the native *Catholic*. Why did they fight against the native *Catholic*? Was it because the said *Catholic* fought against the king? That is nonsense, for in such case the said *Catholic* and the


---

p.10


{topic Conduct of Irish nobility and gentry}



said Protestants would be brethren in the same enterprise. Therefore the Irish *Catholic* must have fought for some end that was ill opposition to the end of the aforementioned Protestants. That end could not be any other than the asserting of the king's rights, since those Protestants took arms for the destruction of the said rights. The case is uncontrollable. How came it then that the parliament of England, being constituted judges between both parties, gave a pardon to one side, though they had fought against the king, and refused a pardon to the other side, though they had fought for the king? We can assign no other reason, in the true meaning, for this partiality, than because the parliament was beforehand resolved, upon certain motives of their own, to commit that notorious injustice, notwithstanding what the world should say against them, as the sinner will offend God for his pleasure, though he knows God threatens damnation unto him for committing that crime. See here a general and supereminent injustice allowed by the Protestant church of England in their representatives, clergy and laity - an injustice that is evidently against the light of nature, so that a pagan, committing the same, could have no excuse for the fact; and, which is more to be admired, not one Protestant in the English monarchy *had* *written* against it as a thing contrary to their religion.


When this act of indemnity was notified to the Irish nobility and gentry, they were amazingly surprised thereat, as being so far from expecting any such treatment, that they rather hoped to be the first subjects in the king's favours. But they behaved themselves hereat like poltroons, not uniting in the common cause, nor helping themselves, as they should do, which is a misfortune frequent to the nation. Whence, we may say of them, gens ad servitutem nata. Calamity overspreads often a great people by the fault of a few amongst them, namely, when some betray the trust reposed on them; and when others become so selfish, as not to contribute the least, either in purse or in personal labour, to the general welfare, not caring a rush whether their country sink or swim, so they be well themselves under any masters; and choosing in the interim to consume their estates most sottishly on 


---

p.11


{topic The Peace of 1648}



their own individual pleasures, rather than preserve them for the relief of their country, or even of their particular kindred. If the Irish at this time had used their due efforts to aid themselves, doubtless God would assist them, as saint Augustine says, Conantes adjuvat, exauditque deprecantes. What should they fear? It was their natural right to petition their supreme magistrate for a redress of grievances, which were so great, that their an was at stake, their fortunes, their honour, the welfare of their wives, of their children, of their nearest kindred, of their country, of their religion, and in some, all that is necessary and comfortable to man in this world. It was a right which sovereign princes cannot touch, nay, they have been made sovereigns to preserve that right unto their subjects, and to which they are to pose their own particular happiness. It was a right which, when violated by government, turns government to former anarchy, and provokes the people to resume their original liberty. Again, what should they fear to represent their oppression to their common father, for they were recorded innocent by beams of the sun. Their king avowed the point, and the most Christian king was ready to confirm it in characters of blood; because he had been mediator in making the peace of 1648 between the king and his Irish subjects. Yea, the request of these subjects was indisputable, and his majesty should not have admitted any demur in the case, but ought to have given orders to put them into possession of their petitioned lands without any form of judicature; because they had as evident right to those lands as they had to the skin that covers their body. Nay, we may set the query, whether in this case there lay any obligation of a good subject on the Irish gentlemen to recur to the king, if by their own power they could drive the usurpers out of the possession of their estates, as some gentlemen of Scotland did to Cromwellian intruders as soon as the king was restored. For why should I not here resume my own, as well as from a manifest robber or thief, without having recourse to the government or to the law? On the other side, those persons against whom the Irish were to complain in their grievances, were a parcel of rascals, were murderers of harmless people in Ireland in the year 1641, were


---

p.12






notorious rebels to the present king, were atheists in their living, were pitiful, mean men in their extraction, and were not to be endured to raise head against their betters and a noble, ancient nation, and against those braves who had honoured the crown of England by embellishing it with the conquest of Ireland. So that these Irish were the men, who ought in true policy to have been supported for the interest of England, as above indicated, and not a few scoundrels, who had contributed to ruin the whole English monarchy. However, the Irish nobility and gentry stirred in some small measure at the hearing of their disaster in England, and so sent a few agents or deputies to the king, in order to obtain a better doom for their country. But they managed their business so sneakingly, that their journey was not worth their while. This is the best construction I can make of their agency. In the meantime, the king of France received from London an account that the *Catholic* of Ireland were excluded from the amnesty general; at which his most Christian majesty Louis the fourteenth was not a little troubled, partly out of compassion to the innocent afflicted, and partly for the affront done him, as being guarantee for the peace of 1648, which he expected that king Charles the second would observe on his side, as the Irish had done on theirs. Upon which that prince was pleased to discharge the duty incumbent on him, and, like himself, to write a letter to the king of England in behalf of the Irish, which he sent by an extraordinary envoy, the marquis of Ruvigny, dated the seventh of September, 1660, and in fourteen weeks after the restoration *of Charles II.*. The letter runs thus: ‘Most high, most excellent, and most mighty prince, our dear and well beloved, good brother and cousin. At the time we got intelligence of the great goodness you show to your subjects, and of the example you give of a mercy altogether extraordinary, by the pardon that you have granted them, excepting a small number of men, against whom the voice of their king's blood and that of his people cries for vengeance from heaven. At the same time we cannot but let you know, that we have been extremely afflicted in understanding that the *Catholic* of Ireland are excluded 


---

p.13


{topic Letter from Louis XIV. to Charles II.}



from this act of oblivion, and by this treatment are put in the number of the most guilty. This news raised our compassion the more towards them, because hitherto we were sure that in all the revolutions which happened in your dominions, and in that almost universal rebellion of your people, there has not been any more constantly adherent to the interest of their lawful princes, even in their greatest adversity, than the *Catholic*, so that they are not thus distinguished to-day, but upon account of their religion. We must also say this in their honour, that not any ere now have been more inclined and more ready to serve and assist their prince, and that they were carried thereunto with so great an ardour, that their zeal for the royal family appeared then as a certain mark of their religion. It is upon this ground that we are become their intercessors with you; for otherwise, if they had failed in the loyalty they owed you, we should be so far from interceding for them, that we would concern ourselves along with you in all the severities that ought to be used towards them, and it should never enter our thoughts to bestir ourselves at this time, as we do, for the *Catholic* of Ireland, though we are bound to it in consequence of the last treaty of peace, concluded with the marquis of Ormonde, the which was granted them through our mediation. But as we are informed that since this peace they have done nothing that may be imputed to them as a failure in their fidelity towards you, we think ourselves the more obliged to conjure you to let them have the benefit thereof, because they have not broken it in the least; and also to beg of you not to suffer that neither the aversion, which an immoderate zeal *had* bred in the minds of some Protestants, nor the unhappy spoils of these poor people, the most faithful of your subjects, may make them criminal of being unfortunate, to whom their lawful princes, as you are, prove not less beloved nor less respected for not being of their belief. We propose to ourselves nothing in this, nor desire anything, but what you may know we daily permit in regard to our subjects of the pretended *reformed* religion. And whereas we have ordered the marquis of Ruvigny to explain unto you more at large our sentiments on this matter, may it please you to give him a favourable audience, and to be above all things


---

p.14






persuaded that in this occasion we aimed no less at your interest than at the justice of the cause, nor less at the sincere friendship we bear you than at the principal motive of this, our present request. And hereupon we beg of God, that he may keep you, most high, most excellent, and most mighty prince, our dear and well-beloved, good brother and cousin, in his holy and worthy protection.’


This letter was delivered by the marquis of Ruvigny to the king, who surely was moved, and could not but think himself to have grossly erred in suffering the act of oblivion to appear without including the Irish *Catholic*. And the envoy was resolved to push on his master's resolutions of seeing the Irish pardoned, and consequently restored to their birth-rights. There was nothing wanting, as the case stood then, to the compassing of the business, but a vigorous concurrence of the Irish nobility and gentry, which being done, it would make the villains shake, and England to boot; for the king of France was in earnest, and his young, warm blood would carry him on violently to the vindication of his honour. But you will say that the *Catholic* of Ireland were not wanting in so just a concurrence with the most Christian king, for they had their agents then at London, by them authorized for that purpose. What do you tell me of such drones to be fit instruments, who could be put off by the fallacious or threatening discourse of every knave that was undermining the nation! When they heard that the French envoy came to England about their business, and that their agents had gained nothing, they should have made a hard shift to transport themselves in bodies to London, and there go, all together, with their petitions in their hands, and with the envoy in the head of them, to the palace of Whitehall; thus in the first place to make those rascally rebels understand, who fooled the king out of his design of doing justice, that they must not expect to trample loyal subjects, and incomparably their betters, under foot, when a king is in Israel, as they had done after banishing him; and thus, secondly, to support his majesty from fearing those traitors, who would render him ridiculous to the world by forcing him to commit such villainy as they themselves had done, and were doing it, and would do it again upon the first occasion. Thus, thirdly,


---

p.15


{topic Inactivity of Irish Agents}



to let his majesty see that the injustice he was going to do was not a small prejudice to two or three private men, but an entire ruin of a whole, great, ancient, noble nation; that he was unnaturally preferring in his favours a pitiful pack of blood-hounds, who had hunted his father to death, and himself out of the throne, and had abjured his very title, and renounced all his family, and this before a people who had, upon their own cost and charge, maintained a war for some years against those rebels, to reinthrone his banished majesty, and who had lost all they had in that very strife; that his majesty was going to take away the sustenance of life from thousands and thousands in their own homes, who had given him bread in his necessity abroad; and was giving that same sustenance to his enemies, who had sent him a-begging from his own house, and from all his vast substance; that, in fine, they begged nothing of the king but what was their own, remitting unto him what recompense he owed them, which it was dubious whether his majesty was able to perform with all his royal revenue. It is in this sense, and in an elevated spirit, the Irish should express themselves, and not to speak like a coward when their world was in jeopardy. They had all right for proceeding thus. They had the law of nature for them, the law of God, the law of nations, and the law of government, which was erected to preserve people, not to destroy them. Yea, the king himself (in all likelihood) would have been better pleased to see the Irish behave themselves resolute in their just pretences, because that behaviour did more sustain his majesty's good intentions for them against enemies, Whom he was fearful to offend.


But what will you have of it? The Irish agents were deceived by some knavish promise made unto them of doing them justice, after an easy submission to threats of courtiers; for, as I was informed, some of them told the marquis of Ruvigny that the Irish nation was satisfied with such a course as the king would take for restoring them to their ancient estates, and that therefore he might spare his further trouble in concerning himself for them; which the envoy observed without more examining of the matter. But, alas! how little satisfactory the king's measures were to the Irish, which he assumed to make them a restitution of their fortunes, we shall see by and by.




---

p.16


{topic Declaration for Settlement of Ireland, 1660}
In this while the interested enemies of the Irish were busy in securing their ends; for they could not be satisfied only with having the *Catholic* of Ireland left out of the amnesty, but they must also obstruct his majesty's further favours, or rather justice towards them. In order to do this effectually, they think it fit to gain the first minister of state, chancellor *Edward* Hyde. This man was of a sordid nature, and therefore he became servant to those knaves for a vast sum of money.


Now, the chancellor of England being their own, and the duke of Ormonde, both chief favourites of the king, this wicked convention proceeds boldly in their barbarous enterprise. They get first by the chancellor's means, the lord Robarts laid aside, who had a commission to be lord deputy of Ireland, because he was a person of known honour and integrity, and in consequence he would not be serviceable to them.


Immediately after, this blessed crew, as the lord Broghill, the earl

of Anglesey, sir John Clotworthy, sir Audley Mervyn, Mr. Steel, Mr. Roberts, and Petty, put their heads together how to frame an instrument that should be the settlement of Ireland, and called ‘the king's gracious declaration’ for the settlement of that kingdom. This instrument was to be presented to the king, for his allowing it as his own, to the end the Irish *Catholic* might be prevented in obtaining any other declaration from his majesty in their favour, as the cabalists feared, though the Irish were excluded from the indemnity.


At last this declaration of the king's, or rather of the atheistical convention, was published on the thirtieth day of November 1660, it being about two months after the marquis of Ruvigny came into England, and six months after his majesty's restoration. At this same time, **Broghill was created earl of **Orrery****; **sir Charles Coote, earl of **Mountrath****, and **sir John Clotworthy, lord viscount of **Massereene****. The earls of Orrery and Mountrath were also made, in conjunction with chancellor *sir Maurice* **Eustace**, the king's lords justices of Ireland. Heavens, can anything in nature be more preposterous than to see king Charles exalting his enemies, and such base enemies, nor was ever king so made a fool of by a few of his subject as this prince! Here you are


---

p.17






to remark a concatenation of misfortunes falling on the Irish through the will and pleasure of their king, who should heap on them a multiplicity of comforts; for their insatiable foes are made in Ireland their governors and judges, and are placed in England at the helm of affairs. Whereby the world sees that it is a thing impossible for the Irish to obtain justice, since all the avenues of right, both in England and Ireland, were shut up to them.


All things going hitherto according to the desires of the black convention, the two lords justices, Orrery and Mountrath, departed from London, to take possession of their government of the kingdom of Ireland, an honour their father's children should little expect, but much less such villains as they were—The lord Massereene, sir Audley Mervyn, and some others were left at court to follow the concerted business, and particularly to draw up private instructions, for the better executing the said declaration of his majesty in Ireland.


Now, let us see what this famous declaration is, which was penned by the enemies of the Irish *Catholic*, and therefore little good is to be expected out of it for the said *Catholic*. The first branch of the declaration confirms the possession of those lands in Ireland to the London adventurers, which Cromwell and the rump parliament gave them in the year 1653, in consideration of their plate and money brought to the treasury at London in the year 1642, in order to be employed in the war of Ireland. This lot of the adventurers amounted to ten counties, a prodigious compensation for a little money.


The second branch secures unto Cromwell's soldiers their proportion of the Irish lands conferred on them by their general and the rump parliament in 1653, to pay them their arrears of three or our years' service in Ireland, though they were well maintained and clothed during that time. But we suppose the general would be generous. Their quota comes to twelve counties. It is no wonder upon that score to see Oliver's soldiers, poor bakers, shoemakers, tailors, and the like artizans, lord it in their coaches throughout the kingdom of Ireland, while the true lords and gentlemen of those lands are going a-foot.


The third branch does satisfy the pretences of those Protestant


---

p.18






officers, who had served king Charles the first in Ireland at any time before the year 1649, of which a great part turned rebels before that year, and in that year at Cromwell's landing. The portion of these officers is four counties, and all the cities and corporations of the whole kingdom.


The fourth branch leaves the transplanted *Catholic* gentlemen in the fruition of those lands which had been given them by Cromwell and the regicide parliament, by way of charity, in the barren county of Clare, and in two like counties in Connaught. There are three counties more remaining in the kingdom. One of them by the declaration was appointed to supply the deficiency of the lots of the adventurers, least they had not enough for their money. Another county was to satisfy incumbrances that lay on the lands made over both on the soldiers and the adventurers. The third county was to reprize such soldiers, adventurers, and 1649 men as were to be removed from the estate belonging to the duke of Ormonde, who was positively to be put in possession thereof. And thus the king's declaration made by the Cromwellian possessors, and their great friends at court, distributed and settled all the lands of Ireland. But you will ask me: was there no provision made for the natives of the kingdom, besides that small pittance given to some of them in three unfertile shires, for their considerable inheritances in the provinces of Leinster and Munster? I answer: that this declaration provides for three sorts of *Catholic* natives: the first is, of those Irish officers who had served under his majesty's ensigns abroad, called, therefore, ensign-men, to the number of five hundred. The second is of article-men, who had received the peace concluded with the marquis of Ormonde, the king's commissioner, in the year 1648, which includes the whole nation. The third sort is of innocents, who had not borne arms before that peace against the king's government in Ireland, or against those general governors who called themselves the king's regents. But the first sort, the ensign-men, and the second, the article-men, are not by the declaration to be restored to their estates until first equal *reprisals* are found for the soldiers, adventurers, or others now in possession, who are to be removed from the lands of the ensign-men and article-men, 


---

p.19






which was a thing impossible to find, the whole kingdom being possessed before by the soldiers, adventurers, 1649 men, and transplanted Irish. And thus the declaration provides for those natives of Ireland, how well every common understanding perceives.


Behold a declaration that is worth our remarks. It is both foolish in a high degree, and unjust even to barbarity. It is strange that such a nonsensical piece could proceed from a man that is endowed with any reason. If the whole be given away, there remains no part of it to be given. If the two and thirty counties of Ireland are entirely conferred on soldiers, adventurers, 1649 men, and transplanted Irish, there rests nothing of Ireland to be granted to the ensign-men and article-men; or to *reprise* the soldier, or any other, that must quit his possession. 'Tis certain king Charles did not peruse this declaration, and examine it, but blindly allowed it; for otherwise he would not suffer it to come out for the honour, even of his judgment, because it was a shame nonpareil to be childishly imposed on by a parcel of loggerheads that had not wit in their knavery.


As to the injustice of the declaration, I ask of the composers of it, whether they believe the immortality of the soul? If they say they do, I am sure their actions give them the lie; for they have done wrongs against the lamp of reason not well expressible, and are eternally resolved to persist in them. Therefore, it is not rational to believe that men would quietly remain in the state of damnation to the last minute of life, if they held the soul to be subject to pain or bliss after the breath parts the body. To have wronged grievously their fellow subjects they cannot deny, and we have proved it sufficiently before, and therefore we may spare our labour to enlarge the proof. That they resolve to continue for ever this their wrong, they do confess it; and have de facto persevered to their dying day in the possession of their ill-gotten estates, without the least proposal of making restitution to the owners of them. And their heirs after them do enjoy the said estates with the same resolution. It will not excuse them before the tribunal of God to say that the king gave them a grant of those lands, and the parliament of Ireland confirmed it, even though they should have no 


---

p.20


{topic Observations of the case of the Irish}



hand in cheating or forcing the king to the same, because whatever is intrinsically evil, as theft, robbery, and other crimes, *which* are against the law of nature, cannot be made lawful by any human law. The case is like to that of the Irish. The king and the world have judged them innocent subjects, but to take away violently the property of innocents, is owned universally to be radically an evil, and against natural equity. 'Tis therefore neither the king's concession nor the parliament's statute can justify the possession of such property. You may see in holy writ, with trembling, what little right the king *had* to force an innocent subject's property from him, by that example of Naboth's vineyard in the third book of kings, and twenty-first chapter. But sure it is incomparably more culpable to deprive a whole nation of all their worldly substance without rhyme or reason, unless it be to please a parcel of villainous robbers and rebels; but of this more beneath.


On the other side, if there be a God to punish vice, and a hell for the place of torture, and an immortality of the soul, then what shall become of these atheistical oppressors of a nation? Woe, woe, woe unto them. But this woe is as lasting as eternity. A hundred thousand millions of years will pass while they are in torments, and yet the torments of the damned shall not end; no, nor after millions of millions more of years. It must therefore be a miserable bargain, to feast and sport here for a few days of life, and afterwards to pay for it in everlasting pangs. This folly God himself upbraided mankind with, when He deigned to converse on earth with His creatures, saying, what *does* it avail man to gain the whole world if he makes shipwreck of his soul?


To turn to the king: we ask, with submission of his majesty, what title *had* he to the disposal of all the lands in Ireland? We know not any, nor he himself can deny it, unless in case of high treason. Yet this high treason must be proved according to the formality which law *had* settled. Now, if the king should ground his title upon forfeitures, as he does not, for he has declared the Irish good subjects, let every person reputed guilty be brought to trial, and if condemned, let him suffer death and the loss of his estate. The Irish nation is contented to abide this method of showing their guilt, or their innocency. But to be condemned 


---

p.21


{topic Statements and Answers}



before a hearing, is against the law of England and Ireland, and against the law of nature, and against all laws whatsoever, as all mankind unanimously avers. And though it were possible that all the noblemen and gentlemen of the kingdom were guilty of rebellion, it *does* not thence follow that all the estates are for ever forfeited to the king; for by settlements precedent to the rebellion the reversions of them come to the sons and heirs of the forfeiting persons. So jointures to widows, so portions to children. For this reason the king could not lawfully make away those estates, without a saving to these innocents. You may talk in the air that his majesty had vast debts to pay unto those soldiers, adventurers, and 1649 officers. We answer, with a supposing that he had, what then? Let him pay his debts out of his own stores; for he must not rob Peter to pay Paul. He had no more right to the estates of Irishmen than the Irish had to his crown, in the circumstances wherein they both were; and they had as firm a title to their estates as his majesty had to the inheritance of the throne*.*


On the other hand the *query* lies, whether the king did really owe anything to those three sorts of men? The adventurers gave their money and plate in the year 1642 upon the English parliament's vote, to enable king Charles the first to carry on the war against the *Catholic* of Ireland, falsely accused by the justices of that kingdom of being in arms against the royal government, which money the said parliament used against the same king in their rebellion in England. In this case, what has king Charles, the son, to do with that debt? You will say, the adventurers laid down the money bona fide for his royal father's use. We answer: let those knaves who received it refund the same; that is, it proveth just that those parliament-men of both houses, who turned that treasure against the king, be now compelled to pay it back out of their particular estates unto the adventurers. At least, England by a general tax should pay it, since the generality of England was engaged for that parliament against the king. In the Interim the money of the adventurers was but little, and therefore we may believe that it was sufficiently recompensed by their possessing such large tracts of Irish land for seven years unto the king's restoration.




---

p.22


{topic Observations on the conduct of Charles II}
As to the soldiers of Cromwell, the devil is in the case if the king is obliged to pay them their arrears, who had run his kingly father to death, himself out of the kingdom, and his loyal subjects to an entire ruin. It appears to me that an overspreading frenzy seized king Charles the second at his restoration, seized the English parliament, the privy council, the favourites, and all those who countenanced the said declaration, by giving vast rewards to the worst rebels, for whom a halter was too good. This action is a shame to Christianity, a scandal to infidels; but 'tis an effect suitable to Protestantcy.


Those officers who had served king Charles the first in his standing army of Ireland at any time before the year 1649, do claim also arrears. For what? They were paid by that king unto the year1642; they had subsistences or lived on the country, for five years more unto the summer of 1647, at which time the marquis of Ormonde gave the king's government into the hands of the English rebellious parliament, so that they were no longer in the king's service, for hardly any of them came over to the Confederate *Catholic* at Kilkenny. Now what should be owing to a handful of an army in five years, after receiving half-pay by their subsistence? If king Charles the second thinks himself bound to pay such an army, who proved rebels to him for five years after, let him pay them out of his own, or let there be a tax levied in a parliamentary way upon the whole kingdom of Ireland, to satisfy that host of five years' loyalty. But methinks they should be obliged to refund the same money for their five years' rebellion, since they are suffered to live by the regal clemency.


Here I cannot forbear speaking still more of my admiration at the behaviour of king Charles the second towards his loyal subjects, and whom he himself acknowledged as such, and could not but acknowledge as such. I will put the best construction on the king's actions. So, I say, that in likelihood he had no value for those Cromwellian mechanics who, after reducing England to the bondage of that heathenish parliament, came into Ireland, and oppressed that kingdom with greater tyranny; which some Protestant writers, in a distracted manner, do call the Protestant conquest of Ireland for the king in the king's absence.




---

p.23


{topic Acts of Parliamentarians and Regicides}
The same they may say of their subduing England and Scotland to the yoke of the rump parliament. The king would have rather they had left it in the possession of the Irish; nor was there need to conquer what was already the king's. However, I set two or three interrogatories to these nonsensical scribblers. Why do they call the king's being in foreign countries for fourteen years an absence, since all the world knows that it was a forcible banishment? Who banished him out of his three kingdoms? Was it not these brave Protestant conquerors of Ireland, in conjunction with their brethren in England? How then can it be understood that these heroes made a conquest of Ireland for the king, since at the same time they deprived the king of Ireland and of England, and Scotland too, nor would give him a foot of land in those kingdoms, nor suffer him to tread on the ground? Nay; they owned upon oath, that the three kingdoms belonged to the people of England, represented in a certain number of ruling men, and finally abjured the king's very title to those realms. Again, was it the king that gave them commission to conquer Ireland, or was it the rump parliament of England? Who were the chief commanders in this conquest? It is acknowledged by both sides, nemine contradicente, that these following were the men: Oliver Cromwell, general, and principal regicide, commissioned by the regicide parliament of England; Ireton, lieutenant-general; *Michael* Jones, the first governor of Dublin for the English parliament; Reynolds, Broghill, Coote, Venables, Hewson, Axtel, and the rest. Against whom did these now named officers fight in Ireland after king Charles the first was beheaded? It is agreed by all parties that they fought against the marquis of Ormonde and the Confederate *Catholic*. For whom was Ormonde then fighting? It is undeniable that he fought for king Charles the second, whose lord lieutenant of Ireland he was, and for whose interest he was general of the Irish *Catholic* army. And when he parted from Ireland in the year 1650, he left the marquis of Clanrickard the king's deputy, who carried on the war against the *abovesaid* Protestant commanders unto the year 1653, when the Irish were forced to lay down arms; at which time a considerable part of them went into foreign


---

p.24


{topic Exile and Restoration of Charles II}



countries, and there served their banished king, who acknowledged their service done in Ireland against the aforesaid Protestant officers to *have* been for his royal rights. In fine, when Ireland was conquered by that Protestant canaille, which happened in 1653, if it was so for the king, why was not the king sent for immediately to enjoy the conquest? The quite contrary succeeded; for the monarchy was immediately made a commonwealth to the exclusion of Charles Stuart, as these conquerors called him, and of all the royal family. A while after, the commonwealth was changed to the monarchy of Oliver Cromwell, not called king, but protector. After his death, his eldest son, Richard Cromwell, enjoyed it for some months. He was put out, and a republic was resumed. So that, after the conquest of Ireland, king Charles the second was kept out of his kingdoms by these conquering Protestants of England, Scotland, and Ireland for seven years, until, in the beginning of the seventh year, general Monk, governor of Scotland for Cromwell and the rump parliament, seeing no end of distractions in England, occasioned by the frequent changes of government, took up a resolution to contrive the bringing home of the king, which he effected, and to which the conquering Protestants of Ireland contributed no more than the people of Constantinople; for they knew nothing for certain of the matter till the king's declaration from Breda arrived in England. And even then they resolved to withstand his entrance with the assistance of the English parliament (supposing the parliament would concur), unless they could obtain from the king their own conditions. In order to this, they imprisoned the Irish gentlemen throughout the kingdom, that they might give no help to his majesty if he should attempt to force his way, rather than condescend to dishonourable terms of restoration, of which matter I spoke above. But the Protestants of Ireland being convinced that the king must soon be in England, they dismissed the Irish prisoners, and betook themselves to their studies of contriving how to hinder the *Catholic* of Ireland to repossess their estates which these Protestants enjoyed by Cromwell's and the rump parliament's grant, as I have just now demonstrated. But I have spent too much breath in ridiculing an impudence that is ridiculous in grain, so I return to king Charles.




---

p.25


{topic Cromwellians in England and Ireland}
This prince, as I said, had in reality no affection for that trash of men on whom he conferred honours and estates which he could not lawfully confer. What was it, then, that made majesty descend beneath the honour of a private gentleman, nay, beneath the honour of an honest tradesman? We cannot assign any other reason for this poverty of spirit than a certain inbred loathing to involve himself in new troubles, which he falsely conceived might be raised by the Cromwellian Protestants of Ireland and their faction in England if he should deny the said Protestants of Ireland their requests, though never so abominable. It seems the king's fear went beyond his reason; for it appears to a thorough considerer of that juncture that the Cromwellian Protestants of Ireland, with what assistance they could get in England, were not to be feared. First, the king getting possession of the throne independently of any positive assistance given by the Protestants of Ireland, altered the case extremely. Secondly, the Cromwellians of Ireland signified nothing as to strength without the help of England. Thirdly, the people of England, being weary with twenty years' troubles, and now tasting of the sweets of peace, would not so suddenly engage themselves in new misfortunes. Fourthly, those Cromwellians, who were settled in England, had means to live on, independent of king Charles's favours, and therefore they had less reason to begin fresh quarrels. Fifthly, the Cromwellians of Ireland were guilty of so black treason that they would be contented with the pardon of their lives if they saw the king assume the air of majesty. Sixthly, the predominant power of England was general Monk and his army, who had brought in the king for this end, that the nation might be settled in quietness, which the king's government alone could procure, as that general was sensible of. Now, where is the reason to believe that general Monk, already made duke of Albemarle, and enjoying other great favours that are not usually conferred by the king on one private Subject, should on a sudden cast away both the public repose, by himself procured at a great hazard, and also his own particular happiness.


The king was further encouraged to do this general injustice to the Irish nation, by both the foolish and villainous counsels of chancellor *Edward* Hyde, who was most highly bribed by the Cromwellians of


---

p.26


{topic Remarks on Chancellor Clarendon}



Ireland. The king had that conceit of the chancellor's wisdom and integrity, that he believed all was gospel which proceeded from him, his majesty not being able to discern between false appearances and truths, through the greenness of his age and the want of experience in the intrigues of profligate courtiers. This statesman, for all his pretended knowledge in the politics, failed in the very foundation of policy, which consists in doing justice at whatsoever rate, according to the received axiom: Ruat coelum, et fiat justitia. And the reason hereof is, because it was justice that brought people into a governable body, that is, independent families seeing in the beginning, as mankind multiplied, that their neighbours were oppressed by the more potent, and that no redress could be had, joined together into a society, making one person, or more, ruler of them, to the end that by the strength of the corporation he might keep peace amongst them, and preserve to everyone his property and liberty against the insults of his fellow-subjects, and of foreign enemies. But when their supreme governor suffers justice to be violated, that is, when he neglects to preserve concord amongst them, and their liberty and property, having power to do otherwise, he dissolves the fabric of the commonwealth, and gives the immediate occasion to the subjects to resume their original freedom, and to destroy his greatness, as it is evident to common reason. At least he gives a provocation to the abused subjects and all honest men to abandon him whenever he is set on by rebellion, or by a foreign war. Our pretended statesman, to the contrary, will have justice give place to conveniency; and, to back his position, he brings an airy argument that the Cromwellians in Ireland are at this time to be feared upon the account of their strength in that kingdom. I have above confuted this bribed saying of his, and do add here that the *Catholic* of Ireland with clubs in their hands would drive those sneaking rebels then extant out of the land, keep but the power of England from them, which is acknowledged by such persons as lived at that time in the realm, and observed one side and the other. It was the potency of England, together with what Cromwellian army there was in Ireland, that kept the Irish in awe since they had laid down arms until the restoration of 


---

p.27


{topic Causes of Reduction of Irish Loyalists}



the king. But if the Irish have from the beginning of the Cromwellian war been true to one another, and had a skilful general at Cromwell's first landing, they might not have feared even the power of England; for the common soldiers of the Cromwellian army were despicable, as being feeble in the body. Their only goodness consisted in firing; to come to sword or pike, they were insignificant against the Irish. What subdued the *Catholic* of Ireland was as *follows*: In the year 1648 they had all the kingdom gained except Dublin and Londonderry, at which time their army got a new general, the marquis of Ormonde, who led the strength of the nation to besiege Dublin, a weak town; yet, either by treachery or by unwarrantable neglect, he lost at that siege, without gaining his end, a very considerable proportion of those royal forces, as abovesaid. From that day to the end of the war, no such numerous troops of the Irish, as we may call an army, were brought to the trial of strength and courage in the field against the Cromwellian host; but their forces were divided all over the kingdom into small bodies, and in that manner they held out the war for four years after the arrival of Oliver Cromwell. In the meanwhile the treachery of some persons, gained by English money, helped on the downfall of the nation; so did great divisions amongst the commanders. From whence we may judge that unskilfulness in leaders, and gold and dissension, will conquer any country.


But to revert to chancellor Hyde, we will spend no more breath in exposing his silly and savage policies. I shall only refer you to the book printed at Louvain, in the year 1668, and called the Earl of Clarendon's settlement and sale of Ireland.


Here behold a minister of state, who, by his office, should study to strengthen the king's interest, and yet, by all the base ways he can think of, he endeavours to destroy it. He renders the king an idiot in making him sign declarations, grants, and orders, that a boy of twelve years' age would be ashamed of, as to point of judgment. He publishes the justice of the nation to be that of cannibals, in getting king-murdering rebels to enjoy peaceably those spoils which they had taken from honest men and loyal subjects, because these fought for their king 


---

p.28


{topic Clarendon and his Associates}



and his rights against those regicides. He has cast such a stain on the face of England by his sold advices in the time of a lawful prince reigning, that all the water of the ocean is not able to wash it away, because England herself *had* not complained against him in this matter, and so tacitly assented to her leader, though she flew in his face for his selling of Dunkirk, a mere trifle in respect of the damages he brought on the king, on the crown of England, and on the whole *Catholic* nation of Ireland, as abovesaid. Upon this occasion I cannot but exclaim against the folly of a man, who of his own accord heaps shame and confusion on himself. This person, from a private lawyer, came to be high chancellor of England, earl of Clarendon, and chief favourite of the king. This was a pitch of prosperity that should content an honest man. But this could not satisfy the chancellor. He must have mountains of money as an addition to his good and honourable fortune, though by the means of signal knavery, which marred all his glory, and all that renders a man of esteem in the world.


The duke of Ormonde trod in his steps, which was a pity, because he was of a right noble family. He had honour enough from the king, and an ancient estate that was sufficient for his quality; but by assisting the Cromwellians ('twas an illustrious employment) in ruining his countrymen and his kindred he got for his reward an estate out of the lands of those ruined persons, four times greater than that of his house; and thus he tarnished the honour of his blood.


The earl of Anglesey, in like manner, for giving his helping hand, obtained a vast patrimony in Ireland. So did the lord Kingston and others. These men, and the like, were the idols of king Charles the second, persons of whom the freest from rebellion had never done the king any service of moment. What a calamity it is to good subjects to have a king who cannot discern between merit and demerit. O God, commiserate your poor creatures that are thus abused on earth; and give the king the spirit of honour, the spirit of conscience, and the spirit of wisdom.


But 'tis time we resume the abovesaid declaration for the settling of Ireland. We say, then, that in the declaration there was a privileged


---

p.29


{topic Qualifications for Innocents}



provision made for the third sort of Irish gentlemen who were to be restored, which was that the 'innocents,' as above described, were to be repossessed of their estates without any previous reprisals. This was a terrible thunderbolt to the soldiers, adventurers, and 1649 men; for many of them would lose their ill-gotten lands if this proviso were executed. Wherefore, to prevent so great a misery, the cabal of London joined their heads together to find out an exposition of this word 'innocent' which should be to their purpose, and not significative as men naturally understand it, and as we interpreted it above. At last they settled the matter like independent kings, and concluded that an Irish *Catholic* must have eleven qualifications to make him 'innocent' in order to regain his estate; and these qualifications must be the rule whereby the commissioners appointed for executing the king's declaration shall judge every Irish *Catholic* to be innocent who will put himself upon his trial of innocency. When these qualifications were composed and considered by the penmen of them, Clotworthy and his comrades, they passed their judgment that not one Irish *Catholic* could be innocent, so that they were sure of their point. I will set down two or three of the rigid qualifications, omitting the rest for brevity's sake. It was not, then, enough for passing 'innocent,' not to have taken arms against the king's government in Ireland or reputed government from the year 1641 to the year 1648, wherein the peace was made, nor to have entered into no confederacy during that space with the *Catholic*, their countrymen, but also this was required, that Irish *Catholic* even dwelling all that time in England, or being with his majesty king Charles the first at Oxford, and serving in his army, should receive no rents from their tenants in Ireland. If they had received any they must be now held nocent, and consequently be kept out of the repossession of their estates. Here is a field opened unto us for expatiating in arguments against the baseness of these pagans; but we must refrain our thoughts, lest we should be too prolix. So we will only observe that these made-tinkers of justice do make it a crime in an Irishman to eat of his own bread for the support of life, even in the state of innocency, that is, when he is actually serving his king, and 


---

p.30


{topic Devices of Cromwellians}



this before the face of that king's son, the present sovereign, and yet the now king will object nothing against those nonsensical brutes. What marvel, then, that the Cromwellian Protestants did what they pleased to the *Catholic* of Ireland, since they dare affront the very king on his throne, and come off scot-free? Could they use a better argument against Irish claimants in the court of Cromwell? I am sure they *dared* not speak more boldly before the tribunal of that usurper; and I have an opinion upon good grounds, that Oliver would not have treated them so well as king Charles the second has done, if the said Oliver had lived to great age; for his design was not to suffer longer possession of the Irish lands in his army than their arrears came to be fully paid.


There is another qualification as ridiculous and as heathenish as this. The rebellious state of England imposed an oath, called an engagement, on all the people of the three kingdoms, under penalty of death. In Ireland a public order was given to Cromwell's soldiers to kill any man they met with on the road who produced not a certificate of his having taken that engagement. It happened sometimes that silly peasants, through carelessness, left at home their tickets after taking the engagement, and therefore, being met on the road by those soldiers, they were inhumanly murdered by them. Now, in our case, whatsoever Irish gentleman took this engagement, though perforce, and to save his life, he must be deemed nocent; and these tyrants, who enforced the same upon him, are not to be questioned for any fault therein. This is fair play, is it not?


But to be infallibly sure of compassing their design, this Cromwellian convention addressed to their endeared chancellor, for the obtaining unto themselves a power of being the king's commissioners to execute that famous declaration for the settlement of Ireland, which was granted. But this commission of the cabal was soon laid aside, because it did scandalize all manner of persons in seeing one of the two contending parties constituted judge of the other. Whereupon the king sent orders to the lords justices of Ireland to call a parliament there for the settling of that kingdom according to the declaration, which was as

 


---

p.31




 {topic Cromwellians in Parliament, 1661}



scandalous to all knowing and indifferent persons, and as unjust to the Irish, as the aforesaid appointment of the London cabal to be commissioners for executing the king's declaration; for this parliament was also a party, and sat judge in the case, as you shall see. The house of commons was made up of all Cromwellians. The house of lords had not any *Catholic* peer, or else very few, those peers being barred from sitting under pretence of former indictments against them. And here is the grand court that was appointed to do the Irish justice. Now, I ask of the world what expectations of right can the Irish in reason have from those judges, who do possess what estates the said Irish claim, from those same judges who came to the enjoyment of the said estates by villainy, and who will tumble back to their first miserable condition if they give up their possessions to the true owners?


Well, let us go on. This noble parliament being convened at Dublin, on the eighth day of May, 1661, a twelvemonth after his majesty's restoration, they proceed to business. At last they made an act, commonly called the act of settlement, which the parliament entitled, an act for explaining his majesty's declaration for the settlement of Ireland. What a clatter is here with Ireland, and not a word of England and Scotland. The king makes no alteration in these two last kingdoms, but leaves the nobility and gentry in statu quo prius, everyone enjoying his own, as before the rebellion. The Cromwellians of England and Scotland do gently surrender what they had taken from the loyalists; but the Cromwellians of Ireland will needs keep what they had snatched from the loyal army, who fought it out for the king under his own appointed general, the marquis of Ormonde, after England and Scotland had been laid in bondage.


These Cromwellians in Ireland may well be impudent in their oppressions, when they have now the same king for them who had been a little before against them for their rebellion; when they have the first minister of state on their side; when the great favourite, the duke of Ormonde, that compatriot, and the flesh and blood of the Irish themselves, is in their interest; when they have their own associates, or rather themselves sitting law-makers in their own behalf; when they

 


---

p. 32


{topic the Act for Settlement of Ireland}



are authorized judges in their own cause; when, in fine, they have England and Scotland countenancing them with their silence, and not affording the least compassion to the unparalleled misery of their sister nation, unhappy Ireland; unhappy under the usurpation of Oliver, and as unhappy under the peaceful reign of her thrice obliged king, Charles the second.


Now let us see what *had* this long wished act of settlement produced. In the first place, it assumes a power of determining all doubtful expressions in the king's declaration, and actually *does* determine them in favour of the Cromwellians, that is, of those who made the said act, and to the disadvantage of the Irish *Catholic*—a good beginning. Secondly, it debars the ensign-men and article-men (except half a score, who are provided for) from recovering their estates without previous reprisals, which is a thing not to be had, as we showed above. Thirdly, it allows no more time for trying of 'innocents' than one year. So that it confirms the king's declaration, and leaves the usurpers in the possession that Cromwell and the bloody rump-parliament had given them; excepting only what few persons the 'innocents' (as many of them as can be judged such in that short allowance of time) and a dozen more proviso-men shall thence remove.


Here is a just act of parliament for you. Have you ever heard of the like? Yet you shall see better of the kind by and by. When this act of settlement came out, the king, upon the request of the Irish agents at London, empowered a few English gentlemen, who had no interest in Ireland, to be his commissioners for the executing the said act of settlement. Sir Richard Rainsford, the first in commission, and his brother commissioners, having received their powers, departed from London, and landed in Dublin a little after Christmas, as I take it, in the year 1662, that is, 1663, new style. The commissioners being arrived, they entered immediately upon business, and the first thing they did was to examine the act; which having done, they judged that not any of the natives could be restored to their estates but those ten men provided for therein, and such others as could prove their innocency before their bench. However, the commissioners must discharge the


---

p.33


{topic The Court of Claims}



trust imposed on them, and so (the day being prefixed for opening the court of claims) they began their session in February, about the end of the half-year of the *year* that was allowed for hearing the claims of the 'innocents'. Eight thousand persons claimed to 'innocency,' against which the Cromwellian possessors of the lands in debate prepared knights of the post to swear the claimants nocent; and de facto these villains did excessive harm, as ruining many a family. This evil will always be lodged in the land until a law shall be made that perjury is death. It is an unequal management of the commonwealth to hang a man for the felonious taking away of a cow or a horse, and not give death to him who, by his false breath, has taken away a great estate, to the utter undoing of a gentleman and his posterity; who in like manner has taken away a man's reputation, and his very life. This licentiousness of swearing falsely against the Irish reigned so openly before this court of claims, that sir Richard Rainsford and the other commissioners became very sensible of it, but could not remedy the contagion.


However, the court went on hearing of the claims unto the month of August, in which space of six months a thousand claimants were heard. The majority of them were declared 'innocent,' notwithstanding the rigid qualifications above mentioned and the force of perjurers. But now the year was ended, which had been limited by the act of settlement for the determining the causes of the claimants to 'innocency.' Wherefore the judges would proceed no further in giving a hearing until a longer time were granted; for which they sent into England to the king, in order to hear the seven thousand that remained unheard. But *Hyde* the first minister of state, the great servitor to the Cromwellians, procured a denial to be given; and so ended the court of claims. At which time the Cromwellian parliament sitting at Dublin, who had made the act of settlement, sent into England a new bill in the month of May, 1664, which the king signed and sealed at Salisbury, in the year following, 1665, on the 25th of July, notwithstanding the great opposition given thereunto for a *year* by reason of its prodigious injustice. This happened at the time of the great mortality in London,


---

p.34


{topic The Act of Explanation, 1665}



which gave occasion to numbers of English moderate men to say, ‘we are justly punished by God for the wrongs done to the Irish.’ This bill was sent back to Dublin, where it passed both houses of parliament, and so came out an act, called the act of explanation , that is, an act of the same parliament, expounding the meaning of the former act of settlement in several branches. This act of explanation confirms the abovesaid refusal of further time to be granted for the hearing of the claims of 'innocents,' and also debars the Irish from the benefit of articles. The words of the act *clause 3* to this purpose are as *follows*: *And it is hereby declared, that no person or persons who, by the qualifications in the said former act, *had* not been adjudged innocent, shall at any time hereafter be reputed innocent, so as to claim any lands or tenements hereby vested, or be admitted to have any benefit or allowance of any future adjudications of innocence, or any benefit of articles whatsoever.’’*

Act of Explanation, clause 3

 However, this act *section 148* provides for fifty-four persons therein named, so far that they shall be restored to their mansion-houses, and to two thousand acres thereunto adjoining, on condition that the adventurers, soldiers, and 1649 men be first reprised, who are to be removed out of their possessions, a thing that could not be done unless the transplanted Irish were deprived of their lands. Yet none of these fifty-four nominees (so they were called), or very few, were restored. There was also a provision made in this act for three or four persons more; and the 1649 men are thereby *clause 36* forbidden to set or let, by way of lease or otherwise, any part of their lots within walled towns and corporations, or at a certain distance to them, unto any Irish *Catholic*, under the penalty of losing what is so let, and of forfeiting as much more. In this same act there is a clause *63*, importing that all provisoes and clauses subject to doubts shall be construed to the advantage of the Protestants; and then the parliament was at an end.
But such lands as had fallen to the lot of the regicides upon the Cromwellian division of Ireland, being by the parliament vested in the king, his majesty gave a grant of them to his brother, the duke of York, to the yearly value of many a thousand pound. Here the king

 


---

p.35




 {topic Injustice inflicted on the Irish nation}



can have no manner of excuse for his injustice to several particular Irishmen, because those lands which he gave to his brother were wholly at his free disposal, without having any cause of fearing the Cromwellian faction, no Protestant at all claiming to them; nor there being any title in his majesty capacitating him to make them away from the Irish proprietors; for the regicides from whom the king derived his right, had no other pretence to those lands than what their service had given them, which service consisted in passing that execrable sentence of death on his royal father; and the king having no title, the duke of York was highly blameable in keeping possession of those estates, whose owners were bleeding in misery. But at his first possessing of them, he was a Protestant, and consequently we could expect no tender conscience from him; and though his royal highness retained those lands for some years even after becoming a *Catholic* (which doubtless occasioned part of his following affliction), yet at last he delivered them up to the proprietors, as we shall see in due time.


Thus at last was Ireland settled within the five first years of the king's restoration; thus the work of iniquity was completed; thus the Cromwellian rebels were established in their usurpations and robberies; thus an innocent nation was excluded from their birth-rights, being, condemned before they were heard; thus, in fine, the greatest injustice was done that mankind from the first day of the creation to the present time *had* seen, and done against the light of nature, so as none of the injurers can pretend to any excuse; for common reason tells us that rebels are not to be rewarded at all for their rebellion; that robbers must not be settled in the possession of their rapines; that vice is not to be encouraged; that no person whatsoever is to be gratified with the property of an innocent; that nobody is to be condemned till he be fully heard in what he can say for himself; that, in fine, he is an enemy to heaven who knowingly detains the goods that justly appertain to another.




---

p.36


{topic Narrative of Irish affairs, 1688-1691} 

As soon as the king *James II.* came up to London on the 26th of November, 1688, from Salisbury, he wrote a letter to the earl of Tyrconnell, lord deputy, alias, viceroy of Ireland, then at Dublin, letting him know how he was betrayed by his army; how he was abandoned by his people of England; and also giving the said lord deputy his orders and instructions what to do for his interest in this juncture. Immediately the earl of Tyrconnell called a council, to which he made a proposal for raising an army to maintain the king's rights. Upon this proposal several arguments passed pro and con. But his excellency was altogether for war, and showed plausible reasons for success, which opinion had the ascendant, and so 'twas decreed to levy forces out of hand, which was soon made known to the *Catholic* people throughout the kingdom. Here let us pause a while, and examine the nature of this enterprise. The *Catholic* of Ireland do undertake a war for the reinthroning their banished king. Why should they do this? since they bad been oppressed by the precedent monarch, for whom they did that which no subjects had ever done, viz., they maintained war on their own cost for several years against their common enemy, Oliver Cromwell, and other regicides and usurpers, till at last they were totally subdued and deprived of all they had in the world. The sad remembrance of the aforesaid oppression (never was the like since the creation) should make the Irish *Catholic* nobility to rejoice rather (according to the dictates of flesh and blood) at the misfortune of an ensuing king of England, especially of *James II.* the immediate successor and brother of their oppressor; which brother at the time of their oppression behaved himself not much better, as far as went his power; at the best he stood neuter; and moreover he received into his possession the estates of several Irish *Catholic* delivered most unjustly unto him by the king, his brother, and by the barbarous parliament of Ireland, as we mentioned above. But *Catholic* religion is one thing, and heresy is another.




---

p.37


{topic Position of the Irish, 1688}
*Catholic* religion obliges us to duty towards our lawful sovereign, though he had often injured us, and though he were of a contrary belief. Whereupon *Catholic* will still be *Catholic*, and so the Irish must lay aside all resentments that thwart their allegiance, and take up arms to discharge their devoirs, although they were to lose their fortunes, and destroy their families again, as their fathers had done for king Charles the second. Yet how are they able to assume this province? Money they have not, and their estates in land have been for thirty years before in possession of Protestants, except some few inheritances, which had been rendered in each province of the kingdom to the right owners iin the reign of the said Charles the second. They also want arms, they want horses, they want other utensils of war. They are ignorant in the military art, as being debarred upon the account of their religion from posts of that mystery of a long time by the government. They are, in fine, destitute of warlike ships and other vessels, which is the most important advantage to an island, either to guard the coasts, or to bring home all necessaries of war, or to transport men for annoying your enemy either by yourself, or in conjunction with a friend and ally. And what is worse than this, they have a most potent enemy to deal with; for they are to stand against wealthy England, hardy Scotland, and the violent Protestants of Ireland. They are to fight veteran forces of *several* nations, which the prince of Orange will send, or bring himself. But the greatest terror of all to the Irish *Catholic* is, that if England should lose an army in the fields of Ireland, she can send another and another, and tons of gold to maintain them; so that Ireland in her present circumstances is in no way a match to the power of England. These are all solid dissuasories to the enterprise of the Irish *Catholic*. But what will you have of it? Although conscience should be free from obligation of rising for their king, because of their inability, yet an exorbitant zeal and natural courage will attempt matters (as often it happens) which reason deems not feasible. To make these noble flames of the *Catholic* take a higher pitch, they are told that the king will come amongst them in person; that France will send arms, will send money, will send experienced officers and trained


---

p.38




 {topic Zeal of the Irish}



soldiers to their assistance. Whereupon the nobility and gentry from all parts of the realm do fly up to Dublin, to attend the pleasure of the government in this affair. The lord deputy observing so gallant an ardour in his majesty's good subjects, gives his commands to the secretaries to draw commissions speedily for the levying of regiments, horse, foot and dragoons. The orders were obeyed, and his excellency began to deliver out his commissions in the month of December, 1688, about a fortnight before the king made his escape out of England. The levies go on amain in cities, towns and in the country. Here you may judge of the greatness of affection which the poor people showed to the royal cause by this, that in the space of two months above fifty thousand enlisted themselves for the war, and each company and troop of the whole number was subsisted upon the cost of every captain for three months, to the undoing of several officers who were not lords of land, nor possessed of any great treasure.


Ah, would to God I were master of a meet talent in setting forth the commendation of this loyalty, of this zeal, of this love, of this compassion to their suffering prince. A mighty monarch the other day (for he was lord of kingdoms), now is expelled his throne most nefariously by his own vassals, by his menial servants, by his favourites, by his confidants, by his own bowels, for no fault, but what he thought was a blessing, and a blessing above that of the crown, that is, the *Catholic* religion, and being thus abandoned by his innumerous people, he can find not any of his to take pity of him, nor take up his quarrel, but those of his subjects who are least able to vindicate his wrongs, and who had been most unrighteously dealt with by *Charles II.,* the immediate predecessor of the present king, though they demonstrated the like fidelity towards the said predecessor in his forlorn case. All we can say in the matter is, that this example of loyalty in Irish *Catholic* is right admirable, and may do good to other princes, though it should not profit their own. Yet their own king in after times, when by providence a restoration is made, may, if he pleases, reap a substantial benefit out of the remembrance of this behaviour of his Irish subjects, and of their *Catholic* fathers in the reigns of Charles the first and

 


---

p.39


{topic Projects for Amelioration of Ireland}



Charles the second; which benefit consists in this: It is an experience above controlment, that the pretended reformed people of England are prone to rebellion; that de facto they have dethroned three kings one after another, of late years; that of the three nations, the *Catholic* people of Ireland have showed themselves most loyal; nay, constantly loyal in the three last revolutions happening under the aforesaid princes; that in this universal rebellion against James the second, they alone stood faithful, except the *Catholic* and some few Protestants in England and Scotland; that, in fine, this loyalty is in them fixed by the principles of their religion. Wherefore, these being all truths, the king of England, for his own security, will make hereafter his Ireland a powerful nation, in order to be a check upon the people of England, and by that terror to prevent their rebellion; or, if it happens, to extinguish it soon. And to render the Irish *Catholic* effectually potent for this end, it will be requisite in the king to restore unto them their ancient estates, which the Protestant usurpers have retained in possession these forty years past; to make the parliament of Ireland absolute in enacting laws without being obliged to send beforehand the prepared bills, which are destined to pass into acts by the consent of both houses of parliament, for the king's precedent approbation of them, it being sufficient to have the king's assent given unto them by the voice of his deputy after the said bills have passed both the houses; to make the judicature of the nation determine causes without an appeal to the tribunals of England; to give full liberty to merchants to export the product and manufacture of the kingdom, and to import foreign goods without an obligation of touching at any harbour of England; to erect studies of law at Dublin; to put always the viceroydom into the hands of an Irish *Catholic*; to set up a silver and gold mint in the capital city; to confer the principal posts of state and war on the *Catholic* natives; to keep standing an army of eight thousand *Catholic*; to train a *Catholic* militia; to maintain a fleet of 24 warlike ships of the fourth rate; to give the moiety of ecclesiastical livings to the *Catholic* bishops and parish priests during the life of the present Protestant bishops and ministers, and after the death of these, to confer


---

p.40




 {topic Narrative of Irish Affairs}



all the said livings on the Roman clergy; to make the great rivers of the kingdom navigable, as far as 'tis possible; to render the chief ports more deep, and thorough tenable against any attacks from sea; in fine, to drain the multiplicity of bogs, which being effected will support a vast addition of families.


{topic Movements in Ireland for William, Prince of Orange}While the *Catholic* of Ireland were busy in raising an army for the king in the months of December, January and February, the Protestants of Ireland were hatching oppositions; for they had resolved before to side with England, and acknowledge the prince of Orange for their king. Of all Protestants within the bounds of the English monarchy, those of Ireland (except a few) had the greatest reason to rise against king James the second (if you will lay aside conscience), because they have been in fear, of a long time, that his majesty would, upon the first opportunity, compel them by new and just laws to restore unto the *Catholic* owners those estates which the said Protestants possessed by the grant of Cromwell, and by the confirmation of that unrighteous parliament which sat at Dublin a little after king Charles the second had been restored. Some of the Protestants by this time actually broke out into rebellion. Others remained in their habitations, till a fair occasion was offered to show themselves bare-faced, which was when marshal Schomberg, the prince of Orange's general, landed in the north of Ireland with an army in the month of August, 1689, and when the next year the prince of Orange himself arrived in the same province *Ulster*, with a numerous host.


The first of Ireland's Protestants who appeared for the prince of Orange were the inhabitants of Londonderry, a city situated on an arm of the sea in the province of Ulster. This town being void of a garrison for some weeks, the lord deputy, Tyrconnell, sent his order to a *Catholic* regiment raised by the earl of Antrim on the first news of Orange's invasion, to march into the same. But the burgesses hearing thereof, and that the king was abandoned by his army and by the people of

 


---

p.41


{topic Enniskillen and Londonderry}



England, did resolutely, about the beginning of December, 1688, shut up their gates against the said regiment, who were forced thereby to get quarters elsewhere. About the same time the viceroy sent two companies to be quartered at Enniskillen, a small inland town in the same province. This also refused entrance to the king's garrison. However, Londonderry in a few days after, by the mediation of the lord Mountjoy, a Protestant, consented to receive six companies of the said Mountjoy's regiment, half Protestants and half *Catholic*, which reception was as good as nothing; for what could three companies of sure loyalists do against three more, and a great body of citizens well armed? Nay, what could the six do against all the inhabitants of that town, and against many other Protestants that might have been called in on a sudden, even supposing the six to be staunch in loyalty? Nevertheless, the lord deputy, at a venture, sent from Dublin, about the end of December, the said six companies under lieutenant-colonel Lundy, a Scotch Protestant. They were admitted into Londonderry, where they had not been long, when the *Catholic* proportion of them found a harsh entertainment. But when the people of Londonderry received an account that the king was fled out of England into France, they turned all the Roman *Catholick* soldiers out of town; and a little after, hearing that the prince of Orange was proclaimed king at London, they also proclaimed him king about the twentieth of February; at which one of the Protestant captains of the six companies, by name William Nettervill, of the house of Dowth, a *Catholic* family, being fixed in his fidelity, quitted the garrison and came to Dublin, who in his road observed the prime Protestants of the north in arms for the prince. Here you see that the high governor of Ireland committed the like impolitic fault by not mistrusting the loyalty of Irish Protestants, as the king had done in England by not *mistrusting* in his Protestant army, in so much that the vice-king by that error lost Ireland, as the king himself had lost England; for Londonderry proved to be the *prima mali labes,’’*

Marcus Junianus Justinus, Epitoma Historiarum Philippicarum, 17, I.5

 the source of that kingdom's loss, as we shall see beneath. Before we go on, I must *inform* the reader that *King,* a Protestant churchman or bishop of this rebellious nest, Londonderry,


---

p.42




 {topic Affairs in Munster}



has set forth a book vindicating the rebellion of Irish Protestants, which I do not repute to deserve a particular answer, because it is confuted in itself, as being *written* by a Protestant of the general revolt; as being composed upon false suppositions; as being aspersed with untruths, which several Irish gentlemen now living can prove home, and may live to see the said book and all the fables written by Protestants of Ireland made one flame. The writer of the above-mentioned book is guide to a flock in the way of virtue. What marvel, then, if the people be rebellious, when the doctrine of rebellion is instilled into them by their pastor? When the blind leads the blind, both will fall into the ditch.
After the defection of those two aforesaid towns, Bandon, in the county of Cork, and in the southern province of Ireland named Munster, rose up against the king's government on the twenty-fourth of February, and in the same year, 1688, old style. The inhabitants of the town turned out some few royal dragoons, and then shut their gates. But lieutenant-general MacCarthy, alias lord viscount of Mountcashel, came speedily thither with a body, and reduced them to quietness by an agreement, and to prevent further trouble, he had the walls of the said town demolished. By this mean the province of Munster was kept from running to arms for the prince of Orange; notwithstanding which, several Protestants of that country made shift to go into England, amongst whom was Mr. Ingoldsby, now a lieutenant-general of the English army in Holland. And others, as sir Thomas Southwell, of Kinsale, in the county of Cork, and many other gentlemen, with their servants, left their homes, and travelled into the province of Connaught, in order to go to Sligo, a garrison-town of the said Connaught, near the borders of Ulster, wherein resided at that time the lord Kingston, a Protestant, to the end that with him they might take measures how to advance the new cause of Orange. As the said sir Thomas Southwell and his considerable party drew near the town of Loughreagh, in the county of Galway, the king's officers, captain Thomas Bourke, with a troop of horse, and captain Daly, with a company of foot, met them on the first of March, 1688, old style. Both sides came to a capitulation,

 


---

p.43




 {topic Lord Mountjoy and Sir Stephen Rice}



by which sir Thomas *Southwell* and his companions were to lose their arms and serviceable horses, and were to be imprisoned at Galway till the lord deputy's orders should be known about remanding them home, or retaining them in confinement.


But the lord deputy *Tyrconnell*, some weeks before this, being troubled at the loss of Londonderry and Enniskillen, the best garrisons of the north, and perceiving all the Protestants of Ulster ready to follow the same resolutions with those two towns, he gets, by a wise and seasonable dissimulation, the above-mentioned lord viscount of Mountjoy, a Protestant of the north, to go in his name to the king at St. Germain's, in France, to demonstrate to his majesty the necessity of yielding Ireland to the prince of Orange; which message Mount joy freely embraced, as believing he could persuade the king to a compliance; and thereby that he might keep the country in the same peaceful condition for the sake of the Protestants therein. This was by his excellency of purpose done to remove the said Mountjoy out of the way, that he might not now take the occasion of heading the considerable numbers of the northern Protestants, who in all likelihood would choose him for their general, as being the best soldier amongst them all, and the most leading Protestant of Ulster. The lord deputy joined with him in commission sir Stephen Rice, a *Catholic*, and lord chief baron or judge of the court of exchequer, to the end his design might be less suspected by the lord Mountjoy. And so both together set forth from Dublin on the tenth of January, 1688, old style, that is 1689, stilo novo. Upon their arrival at St. Germains, the lord of Mountjoy was sent to the Bastile in Paris, where he remained till the war of Ireland was over, and till he was exchanged for lieutenant-general *Richard* Hamilton, in the year 1692, who soon after went to the Spanish Flanders, and there engaged in the prince of Orange's army, as in that of his king, where that very summer *5th August, 1692* he was killed in the battle of Steenkerke, as were the lord Douglas and lieutenant-general *Hugh* Mackay, the best commanders of the English forces.


A little after that the lord Mountjoy and sir Stephen Rice were gone,


---

p.44


{topic Proceedings of Tyrconnell}



the earl of Tyrconnell observing a want of good horses for the king's service in the new-raised army, and thinking it not safe to leave such horses in the hands of Protestants, generally inclined to assist the revolution of England, he sent his orders privately from Dublin to most counties of the kingdom, that the justices of peace and the principal officers of the army should on the same day go to the houses of prime Protestants, and search in their stables and fields for horses fit to serve in the cavalry and in the dragoons, that the king may be better able to rescue his crown out of the hands of the rebels. According to this command the business was effected on the twenty-fourth of February, 1688, old style. What horses so taken were afterwards judged, upon information, not serviceable, the viceroy by proclamation commanded they should be restored to the owners of them.


It was at the end of this business that the deputy, Tyrconnell, receiving certain intelligence that the Protestants of the north were coming into bodies to oppose the king's interest, issued out his orders that so many regiments of the army should march to Ulster (the rest were to follow in due time) to subdue the rebels, and reduce Londonderry and Enniskillen; at the same time publishing a pardon to such of them as should submit within a prefixed term to his majesty's government, only ten principal persons being excepted; amongst whom are the earl of Mountalexander, the lord Blany, the lord Massereene, sir George Rawdon, and the rest.


Several Protestants in that province, upon this proclamation, came in and took protections, yet in a few weeks after, some of them were found killed in the service of the rebels, and their protections in their pockets. At the viceroy's command, the regiments began their march from their respective quarters to the north, about the commencement of the month of March, 1688, old style, 1689, stilo novo, over which expedition lieutenant-general Richard Hamilton, of Nenagh, in the county of Tipperary, and son to *Mary,* the old duke of Ormonde's sister, was appointed commander-in-chief; and colonel Dominick Sheldon, an English *Catholic*, was constituted general of the horse. And now the unlucky war begins, unlucky because ill managed.


And so a body of the army being assembled near Drogheda, about the


---

p.45


{topic Movements in Ulster}



tenth of March, they marched in the straight road to Londonderry, and coming to Loughbrickland, in the county of Down, they met there, as their first opposition, a body of the Ultonian rebels, by descent Scotch and English. These flew away at the sight of the loyal troops. But the loyalists had not proceeded above eight miles, when they came, upon the fourteenth, to an army of about eight thousand men, at Drummore, in the same county, whose general was the earl of Mountalexander, and lieutenant-general sir George Rawdon. The rebels *dared* not fight the king's forces, though these were at present but three thousand and five hundred men, so they ran before them for five miles to the town of Hillsborough, which they passed by, leaving it to its own defence. The royal party seized on it immediately, and so marched on, till they arrived at Portglenone, in the county of Antrim, where colonel William Nugent, a younger son to the late earl of West-Meath, having two hundred foot, and having trajected the river Bann in boats, with thirty or forty of them, beat the guards of the rebels from the pass, notwithstanding their hard firing upon them in the passage. But after he had landed all the two hundred, he routed the rest of those rebels, in all fifteen hundred, under sir George Rawdon part of which body was then foraging hard by.


After this the Irish army went on quietly, till they came to Cladybridge, which had been broken by the rebels. By this time, videlicet, in the beginning of April, the French lieutenants-general, the sieurs Pusignan and Momont, were come up, after landing with the king, of which immediately beneath. The Irish horse was forced to swim, the three lieutenants-general, Hamilton, Pusignan, and Momont leading, where major Nagle was unhappily drowned, and a private trooper. The infantry made a hard shift to get over the bridge, by them after a manner repaired with some pieces of timber. The rebels on the other side of the river, to the number of about seven thousand, under lieutenant-colonel Lundy, fired briskly on the passengers, though to no purpose. But when they saw some of the king's cavalry actually landed, they took to their heels, crying: ‘To Derry, to Derry.’ The Irish pursued them for three miles, yet without any execution. Then


---

p.46


{topic Reception of James II. In Ireland}



general Hamilton commanded a halt, to expect some others of the army to join him. This halt gave opportunity to the rebels to get safe into Londonderry, and hindered the loyal cavalry and dragoons to be in with them *pell-mell*, besides their slaughtering of the runaways in the road, and taking of prisoners, which is looked upon to be the first imprudent management of the northern enterprise, where we will leave that affair for a while.


About the time the army began their march to Ulster, preparations were making at Dublin for the king's reception out of France, before whose arrival monsieur Pointis was sent to Ireland, and there arrived in February, 1688, old style, to notify to the viceroy the king's approach. Upon which his excellency, accompanied with the nobility and gentry of the city, went to Munster to receive his majesty. And so it happened that the king landed at Kinsale on the twelfth of March, 1688, old style, that is 1689, new style; with whom came count D'Avaux, ambassador from *Louis XIV.,* the most Christian king, general de Rosen, lieutenant-general Pusignan, lieutenant-general Momont, monsieur Boisselau; *James Fitzjames,* the duke of Berwick; *William Herbert,* the duke of Powis; *Thomas Cartwright,* the Protestant bishop of Chester, in England; the earl of Melfort, Henry FitzJames, lord grand prior, and several others, French, English, Irish, and Scots, lords, knights, gentlemen, officers, and chaplains. The king arrived that night at the city of Cork; from thence he took his journey straight to Dublin, the capital of the kingdom. All along on the road, the country came to meet his majesty with staunch loyalty, profound respect, and tender love, as if he had been an angel from heaven. All degrees of people, and of both sexes, were of the number, old and young; orations of welcome being made unto him at the entrance of each considerable town, and the young rural maids weaving of dances before him as he travelled. In a word, from Kinsale to Dublin (which is above a hundred long Irish miles) the way was like a great fair, such crowds poured forth from their habitations to wait on his majesty, so that he could not but take comfort amidst his misfortunes at the sight of such excessive fidelity and tenderness for his person in his *Catholic* people of Ireland. This was a


---

p.47




 {topic James II. at Dublin}



different behaviour from that which his majesty found from his subjects in England after the prince of Orange's arrival. And happy would the king be, if he could have preserved unto himself this island *Ireland*, which in a few years would make a prince very powerful, if due care were taken, by reason that it is fertile in soil, notably productive of corn and cattle of all sorts, abounding in fish, marine and *rivers*, admirably situated for a general trade, and endowed with excellent harbours from nature.


But to go on, the king made his entry into Dublin on the 24th of March, being Palm-Sunday that year. He was received by the lord mayor, sir Michael Creagh, and aldermen, in their formalities, by the principals of the city, and by the garrison under arms, while the bells rang, the cannons roared, and the music on stages erected in the streets harmoniously played. And in this manner his majesty was lodged in the royal castle, where the court of the kingdom is usually kept.


The king being arrived at the period of his journey, which he had undertaken all along from St. Germain's in France unto Dublin in Ireland, begins now to enter into his first considerations how to compass the end for which he hither came. The end of those travels was to regain England, his principal kingdom, by the assistance of his Irish *Catholic* subjects. Whether this enterprise could be accomplished in the circumstances wherein the Irish *Catholic* were at that time, I have laid the matter exposed to the judgment of others. But not to dishearten his majesty and his faithful people, I will lean to the affirmative after this manner.


I say then, that if managers of this affair were staunch in wisdom, true to their trust, diligent in the execution, clean in their conscience, and constant in unity, they might recover England by such means as were found in Ireland at the king's arrival. For first, there were at least sixty thousand men of an army, of which a considerable proportion were veterans. The rest in two months' time, by constant exercise, might be made skilful enough in the use of arms. Their cavalry and dragoonry were not to be *despised*. Some regiments of horse and some of dragoons might vie with the best of Europe. Of battering cannon, and

 


---

p.48




 {topic Resources of the Irish}



field pieces they had enough to their purpose in several towns of the realm, as at Kinsale fort, Duncannon fort, at Dublin, Galway, Limerick, and in others. Of small arms they had some store; they had iron and *craftsmen* to form a sufficiency in a short time, as also to cast mortars and bombs, pikes, half-pikes, scythes, spades, pickaxes, and other utensils of war they might have in abundance. Horses and oxen for *draft* abounded. A collection of merchant ships, gabbards and boats might have been timely made out of several ports of the kingdom to transport the army into Scotland, which might march from thence into England. To clothe and feed those forces there was an overflowing plenty in the country; for no land in Europe, for its extent, could show such flocks of sheep and so great stocks of black cattle. Corn was in *excess*. You may be convinced of all this by the vast exportation of slaughtered beef, of wool, of wollen manufacture, and of grain, that was made every year. The city of Cork alone used to slaughter at the least ten thousand bullocks in a season. The county of Tipperary was sufficient to keep the army clothed constantly. The two counties of Roscommon and Mayo, in the province of Connaught, could yearly maintain greater numbers of troops with beef. Half of the county of Meath was able to give bread unto them. The province of Ulster produced linen sufficiently; if not, there might have been a supply had out of the other provinces. What shall I say of the butter, cheese, roots, fish and pork, of which there was abundance? Of all the plentiful product, there could be annually a fair proportion spared for transportation into France, and in exchange necessaries of war might be brought home; for Ireland, at the king's arrival, received no increase of people—it had but the usual store of mouths to consume the growth of the country.


You will object, supposing there was a knack in governing to preserve the kingdom in that plentiful condition, yet how could the king get a sufficiency for his army, having no money to pay for it? I answer, a tax laid on the people by a parliamentary way would bring to his majesty a considerable store in money and in goods; and what should be wanting to enough (if anything thus would be) it might be taken up from the subjects, either on the king's only credit, or on the

 


---

p.49


{topic Management of the State and War}



credit of an act of parliament, which the subjects would not refuse, the kingdom being all in his majesty's possession, except the two small towns of Londonderry and Enniskillen. We have a precedent of this enterprise in the war, which the Confederate *Catholic* of Ireland began for their common defence, in the year 1642, against the Protestants of the said Ireland and their assistants out of Scotland, and against the strength of England,—which war the said *Catholic* continued for eleven years, videlicet, unto the year 1653, upon the treasure of the nation.


This much I have spoken of the state of Ireland, wherein his majesty first saw her. To this if you will add a little aid in money from France, you will make sure work. Half a million of pounds sterling is the sum that could have been borrowed from his most Christian majesty for which three cautionary ports might have been delivered, Limerick, Galway and Cork.


Now, whether those materials found in Ireland at the king's entrance have been afterwards rightly made use of in building the great fabric of regaining England out of the hands of the rebels, I rather leave it to the judgment of others, who were present all along at the management of that war. However, I will humbly deliver my opinion, amongst other men's sentiments, and say that the means found in Ireland at the king's arrival to restore his majesty to the throne of England were not wisely used, which will appear most evident if you will consider attentively the management of the state and war from the beginning to the end. But who was the cause of this great failure? We answer, that several persons both in the state and war were causes thereof. The first was the king himself, because in this critical juncture (supposing him sufficiently skilful in all the points of governing) he left the management of his affairs too much to the skill, care and fidelity of others, not making a due inspection by himself into the behaviour of those his trustees. His majesty was a sincere Christian, suspecting no evil of anybody whom he had not de facto found to be bad, and believing that everyone entrusted by him would prove honest and diligent in discharge of his trust, which made him acquiesce often to the opinion of those who commonly were about his person, and of whose integrity and ability he had a former

 


---

p.50




 

esteem; and this acquiescence proved his destruction; for the opinion savoured either of the traitor or of the ignorant.


The second cause was the want of wisdom or the want of fidelity in some of his counsellors, of whatsoever nation they were. The third was the ignorance or treachery of some great commanders in the army, and of some governors of garrisoned towns. The fourth was the dishonesty or neglect of particular commissaries of the warlike stores and provisions. The fifth cause was in the government, that due care was not taken to see all the products of the earth to go on every year in those tracts of land where there was no war, as they had proceeded in precedent years. The failure in this point soon brought a scarcity in the kingdom of necessaries for the sustenance of the army and people.


The sixth cause in failing to regain England by the sufficient mediums found in Ireland at the king's landing proceeded from this, that his majesty, soon after his arrival at Dublin, did not transport an army into Scotland without heeding the reduction of Londonderry, which might have been done by the middle of May, 1689, and before the prince of Orange could send a fleet from England to stop their trajection; because (besides the reason of the thing being done so early in the season) the passage from the north of Ireland into Scotland is but the sailing of a few hours. There was in Ireland at that time an army of sixty thousand, horse, foot, and dragoons, out of which it was enough to carry over twenty thousand chosen foot, and five thousand horse and dragoons, with provisions for three weeks. This army would make way for themselves through Scotland; would command the stores of the country, and would allure abundance of loyal subjects out of the highlands to join them. They would have penetrated into the north of England by the middle of June, where infallibly they would receive a considerable augmentation of *Catholic* and some Protestants from Northumberland, Westmoreland, Cumberland, Lancashire, Derbyshire and Yorkshire. They could not have been met with by the prince of Orange and his army till they had come to York; at which time the king most certainly would be about fifty thousand strong, all resolute men. Now, I leave it to the judgment of any wise man, whether the


---

p.51






king was not in a condition to carry England before him at that juncture, wherein the prince of Orange's throne was not settled.


In the interim, what do you think Londonderry would do? It is agreeable to reason that the inhabitants thereof, seeing no hopes of any army to come timely to their relief out of England, would soon submit to the royal government of Ireland. This is confirmed by their contrary behaviour at the siege of that town, where they held out obstinately almost to a *starvation*, because they expected to be relieved out of England. So did many Protestants of Ireland at that time rise in arms against the king upon the same expectation. But if they had seen no prospect of succours, they would not have dared oppose what loyal forces were then in that kingdom. From whence you must conclude, that the best means to keep Londonderry in obedience, and likewise to retrieve England, was to send an army into Scotland, as soon as the king arrived in Ireland. On the other side, if Londonderry should prove so mad as to continue in rebellion, notwithstanding all hopes of rescue being taken away, there remained in Ireland more than strength enough to reduce the place by *starvation*, or by formal siege, even after sending for Scotland the above-mentioned twenty-five thousand men. All this is so clear that it is to be admired why the king would stay at all in Ireland, unless so long as he might be gathering his army together with all necessaries, and shipping them off. For his business was not to settle there, since he had the country in his possession, except those two little towns, which could in that his absence give no molestation to the government. But the end of his journey was to recover England by the *help* of Ireland, which he would have compassed in all probability if he had gone into Scotland with an army a little after coming to Dublin, as we showed above, by reason that the rebels of England could not make up in so short a time sufficient strength to overcome his majesty on English ground, he being so fortified with the reinforcements of Scotland and England, as aforesaid.


These now mentioned causes (and others yet undeclared) of not regaining England, and also of losing Ireland, you may more clearly discover in the accounts which are given at the present by word of

 


---

p.52




 {topic Valour of the Irish at home and abroad}



mouth, and in this our narrative. For confirmation of what we now said concerning the causes of the king's failing to compass his design, we will add this, that we have had a solid information that much gold and silver was distributed in the late revolution by the prince of Orange's party amongst several persons (that were employed in the state and war for the king) in order to facilitate the conquest of Ireland by their treachery. And in my opinion it must be so; for otherwise the Irish could not have lost the day, if you will consider the condition in which the nation was at the king's arrival, and that this condition might have been preserved from year to year with good management, if you will consider the violent passion of fighting in the loyal people for their king, tenderly beloved, and for their own all against enemies highly base and ever implacable in their malice to the *Catholic* natives. Evidences of their prevailing courage these natives have given upon some occasions in Ireland; but in the wars between France and the Confederate princes those same men have afforded immortal proof of their transcendent valour where there was no want of wise conduct in the generals, nor bribery intervened. We often attribute the loss of a town or battle to ill-management, yet at the same time that ill-management proceeds from treachery, though we cannot fix the fault upon any certain person or persons, so hard it is to know the secret of designing parties. In the meantime, suspicion is not warrant enough unto conscience for divulging positively the crimes of our neighbours; according to that rule, every man is to be esteemed good till he be proved bad. England *had* been observed of late days to make use of bribing treasure for gaining the proposed ends. This charm France *had* felt in the present wars to her *woeful* experience, which we may remark in the course of our history. But to return to the king.


His majesty, upon his first considerations had in Dublin for the effecting of what he came for, did establish his privy council; so did he other officers of state. He created the earl of Tyrconnell duke of Tyrconnell. Immediately after this, it was resolved in council to break a great part of the new raised army, by reason that the king was judged not able to support so numerous forces; upon which resolution the

 


---

p.53


{topic Management of the State and War}



captain-general, Tyrconnell, was sent into the country to disband some companies out of every foot regiment.


Whether this was a prudent action, it *had* been long since argued pro and con. However, we must here acquaint the reader, that the disbanded captains and subaltern officers were struck to the very heart by this breach; because their uncommon zeal for the cause, and their treasure spent on the subsistence of their respective bands, and their expectation from thence of lasting honour, were all now brought to nothing in their opinion, though the said officers were dismissed with the king's thanks, and promise of preferring them upon the first occasions. After this dismiss, there remained about thirty-five thousand in pay, to serve both in garrisons and in the field. If this standing host was sufficient to be divided for the conquest of England, and for the preservation of Ireland in the absence of the invading forces,—some have affirmed it, others have denied it. The affirmative opinion says, that (upon a supposition that Londonderry be early taken, as it might have been done) twenty-five thousand Irish along with the king, in the end of May, transported into the highlands of Scotland, would in their marches so increase by the accession of loyal subjects, that at the time they were got within England the rebellious party would be too weak to make head against the loyal army, because their usurpation was not yet settled in the land. The ten thousand remaining in Ireland would be sufficient to preserve that kingdom in duty, after being made quiet by the expugnation of Londonderry. It is certain that celerity in resolving and in executing is the best medium to conquer an enemy. These last ages have been very defective in that virtue, which proved often the cause that weak beginnings in rebellion, in heresy, and even in lawful wars, became by delay masters of greater powers, which might by celerity have easily crushed them. There are instances enough of this truth in histories of European nations since the empire of Charles fifth commenced. But this talent of *haste* in managing war appeared more conspicuous in antiquity, wherein Julius Caesar, the Roman general, was so eminent that since his time not one *had* equalled him. Yet I cannot pass by in silence that fine stroke of celerity by which the present king


---

p.54


{topic James II. and Council at Dublin}



of France, Louis the fourteenth, compelled, in the year 1696, the duke of Savoy to a particular peace, and all his confederates to a neutrality in Italy, while the said allies were dreaming that his majesty could not possibly bring an army so early against them from the extremes of Languedoc, where it had been quartered the year before; nor could, with safety to the armies of the Rhine, Flanders, and Catalonia, send so puissant forces over the Alps. And while the confederates were certain in their own thoughts to be some time in May under the walls of Pignerol, in order to take that town from the most Christian monarch before he could be able to relieve the same, that prince was with them at the gates of Turin early in the month of May with such a powerful host, that they had no other remedy for their preservation than to submit to the greater powers.


The next deliberation of the king and council at Dublin, after fixing the Irish army to the aforesaid number was how to maintain the same and the civil administration. The result was, that money should be made of copper, that is to say, a pennyworth of copper coined must pass for half-a-crown in silver; and so it was done.


Three ways there were of subsisting the army: the first by the product of the land; the second by borrowing good money from the king of France; the third by this of brass coin. Very many intelligent persons judged the third way to be the worst, to which sentiment I cleave. And reasons hereof there are many, which, because they are obviously known, and because in all likelihood there will never be an occasion of using the like medium to support people in that kingdom any more, I omit to speak of. As easily as this vile money was had, yet the army was ill paid, which proceeded from bad management. However, that coin did this good, that the poor did not want, and buying and selling was brisk for the first half-year, until the people began to fear the power of England, which began to appear in Ireland by the first army the prince of Orange sent over under the conduct of marshal Schomberg.


The money business being thus settled, the king is undauntedly resolved to render at last that great justice to the nation which had been wanting for forty years before, that is, to restore unto the Irish *Catholic*


---

p.55


{topic The nation of Ireland—Classes in Ireland}



their lands, which had been taken from them by usurpation and by unjust laws, as I showed above. I call the Irish *Catholic* the nation of Ireland, because Protestants therein are deemed generally but intruders and *newcomers*, and who had been at Cromwell's first entrance very insignificant as to their numbers. From that time to the reign of his present majesty, James the second, they have increased so much as to be the tithe of the *Catholic*. These Protestants we may divide into three classes. In the first we range those who are the progeny of *Catholic* ancestors, but who were forcibly bred Protestants, or have turned strays, to temporize, by reason that the heretical government of England *had* been strangely oppressive to the Irish since the reign of queen Elizabeth commenced; Henry the eighth and Edward the sixth not being able to pervert the people; and so they left them as they were. This range of Protestants (which proves exceedingly thin) is of an ancient and noble extraction in the country; and enjoy their estates by a just title derived unto them from their *Catholic* forefathers. In this class we also place those Protestants who have purchased their lands upon a valuable consideration from the Irish proprietors. But their fewness is next to nothing. These two ranges are the only Protestants who enjoy estates in Ireland by a just title. The second class contains those Protestants whose ancestors got ecclesiastical lands from the usurping grants of queen Elizabeth, upon the suppression of the ancient Christianity of the kingdom. These make up no great numbers. They were gentlemen in England, and the children of some of them have been raised to honours since their establishment in Ireland. This second class holdeth also those Scottish and English Protestants who obtained lands of inheritance in the province of Ulster from king James the first, who grounded his grants of the said lands upon false informations. The sires of these Protestants had been gentlemen in their own countries of England and Scotland, and the children of some of them have been created lords in Ireland in later times. These landlords are many in the aforesaid province of Ulster. Their tenants for the most part were Roman *Catholic* until after the battle of the Boyne, in the year 1690, when Scottish men came over into the north,


---

p.56


{topic Cromwellian Settlers in Ireland}



with their families and effects, and settled there, so that they are at this present the greater proportion of the inhabitants of Ulster. To this class we adjoin those few Protestants who got lands in Ireland from king Charles the first, upon most lying accounts sent from thence unto him, as we touched above.


The third class comprehends, in the first place, the issue of Cromwell's army, and of other forces sent into Ireland by the rebellious parliament of England soon after the murder of Charles the first, and on the banishment of Charles the second. As soon as the said Charles the first was beheaded, the regency of England, consisting only of the lower house of parliament, appointed an English army to go for Ireland, and therein to reduce the Confederate *Catholic*, who were opposing the rebellious government of Great Britain and the traitorous Protestants of the said Ireland; over which army Oliver Cromwell was constituted general. But there was a difficulty of making up sufficient forces, especially officers, for that expedition, by reason that the old officers of the parliamentarian army, being weary of war after seven years' fighting against Charles the first (who in the eighth year was put to death) would now sit down at ease, and reap the benefit of their victory over that prince. It was upon this necessity the above-named Oliver Cromwell was forced to take for officers of that host all sorts of ordinary tradesmen, and likely of broken fortunes, amongst whom there was here and there an odd gentleman. After vanquishing the aforesaid *Catholic* by a war of four years, there came an order from England to divide the lands of Ireland to the Cromwellian army for their arrears of pay; secondly, to the judges, who had sentenced king Charles the first to die; thirdly, to the few merchants of London called adventurers; fourthly, to those officers named the 1649 men. This third class of Cromwellian Protestants (though mean and strangers they be) yet is the people that swayeth most over the true natives of the land, and over the ancient nobility and gentry thereof; for 'tis they who are masters of the greatest proportion of the kingdom, and are very many in number. The title of these Protestants, you see, is detestable, especially that of the Cromwellian soldiers and of the regicides. That 

 


---

p.57


{topic Illegality of Acts of Settlement and Explanation}



of the London adventurers either *does* not concern a true king of England so far as to see the money repaid, because the said money was turned against him; or if it *does* concern the king, he should pay it out of his own. And as little is such a king obliged to give land to those officers of Charles the first who had served him at any time before the year 1649 in Ireland, because it is presumed that they were paid their salary during the time they really served him. And though the lent money of the adventurers had been a just debt, yet the principal and interest was likely recompensed by their enjoying the assigned lands for so many years as preceded the restoration of Charles the second; at least the said principal and interest might have been satisfied in a few years more after his majesty's return. In fine, though that debt, and that other pretended one of the said officers of 1649, were truly just, and payable by king Charles the second at his reinthronement, yet the king cannot pay it out of the estates of innocent subjects, such as I proved above the Irish *Catholic* were.


The only thing that gives a colour of right in these lands of the Irish to the said Cromwellian Protestants, is those two acts of parliament above spoken of, called the act of settlement, and the act of explanation, and made at Dublin within the five first years of king Charles' restoration. But these two acts are of no force, as we shall make appear; for the parliament that made them was not legal, as wanting two necessary conditions in the constitution of a parliament or legislators. The first is, the members of the house of Commons were not freeholders of lands, nor freemen of corporations. The second is, they were not representatives of the people of Ireland. They were no freeholders nor freemen, because they did not enjoy by any just title lands of inheritance, nor leases of lands for lives, nor freedoms in towns. This, they themselves cannot deny; for being now under the government of a lawful king, videlicet, Charles the second, they must needs acknowledge that the lands of the Irish *Catholic*, and the freedoms of their cities and towns, which they held unto the chosing of the above-mentioned parliament by the gift only of Oliver Cromwell, a vile usurper, and of the rebellious regency of England, were lands and freedoms forcibly

 


---

p.58






detained by rebellion and usurpation from the *Catholic* owners of them, because these owners had fought against the said Cromwell and that rebellious regency for the aforesaid Charles the second. In sequel of which, the possession of those lands and freedoms so holden forcibly by the gift of such persons as had no right to give them, could not make any title in the Cromwellian donees for the detaining of them, no more than a purse of gold by me possessed at the donation of him who had robbed the same can justify my detainer of it. As to leases of lands for lives, they themselves pretended not to any. Hence it follows that those members of parliament, being no freeholders nor freemen, could not, be law-makers according to the settled constitution of parliaments.


The said members of the house of commons were not representatives of the people of Ireland, because the people of Ireland at that time was the Roman *Catholic*, the natives and the long possessors of the land for several ages, who were in number fifteen to one. Now, it is not credible that the great body of the realm would spontaneously chose a parcel of mean, heterodox and illiterate strangers, who had come among them but the other day, to be their deputies in the management of the greatest of affairs. Much less is it to be believed that all the *Catholic* gentry of Ireland would at their own accord elect their enemies to sit judges whether their estates violently possessed by those judges should be restored unto the *Catholic* proprietors and electors, or should be for ever retained by the violent and unjust possessors. As for the *Catholic* lords, none, or very few of them, sat in the house of peers, wherefore the Irish nation, not being represented by the aforesaid parliament, cannot be concluded by its acts, which is granted by all parties as a first principle.


And though the parliament were legal, yet those, their two acts of settlement and explanation, are not binding, as being made not only against law but also against common reason. So says judge *Henry* Hobart, in the case of Savage and Day, that whatsoever is against natural equity and reason is against law. And if an act of parliament be made against natural equity and reason, that act is void. Judge Coke saith also, in the first part of his Institutes, fol. 97: *Nihil quod est contra 


---

p.59


{topic Reasons for abrogation of Acts of Settlement and Explanation}



rationem est licitum.—nothing is lawful that is against reason.’’*

Coke, Institutes

 Now, that the aforesaid acts of settlement and explanation are such, I believe no man on earth that is in his wits will deny it. For the Pagan, as well as the Christian, knoweth that it is against natural equity and reason, first to condemn a man before he is heard; secondly, for one party to sit judge in his own cause in despite of the other; thirdly, to reward public known vice, as is the taking away your neighbour's substance by no other title than by a strong hand, and by undeniable rebellion; fourthly, to deprive innocent people, publicly owned such, of their proper goods, and to give them to persons who have no manner of right to the same. For all the *Catholic* of Ireland were judged by the king to he good subjects by one way or other, as some by innocency, according to the sense given to it above; some by special merit, demonstrated abroad; and the whole nation by their acceptance of the king's peace in the year 1648, old style. All which the aforesaid parliament did not deny. This being so, that the Irish were free from the guilt of forfeiting their estates, what title had the king unto them? Much less had the London adventurer. If there is money due to him, let him seek for it where he had lent it. Much less the 1649 man. If the king owes him arrears of military stipend, let him get it from the king. Much less the soldier. If Cromwell was obliged, or the rebellious parliament of England, to pay him for service done them, he should demand it from the heirs of Cromwell or that parliament, and not be so impudent as to ask it from the king, against whom he fought; nor to demand it out of the fortunes of those who had maintained a war on their own cost for the king against him, the common enemy. Much less the duke of Ormonde, the earl of Anglesey, the duke of Albemarle, and others of the like predicament in the king's favour. If they had a title to the royal bounty, as I know Albemarle had, they should have received the king's largesses when tendered out of his own stores, and not out of the bread of an honest poor man. They had the reason of a heathen to tell them so much. But it seems their religion opposed that fine reason, and bore it down. In fine, much less had his royal highness the duke of York a pretence to so many estates of good subjects. If


---

p.60






his quality required most ample means to support his greatness, his kingly brother was able to supply him with enough; and princes should put on the nature of the pelican, rather to feed with their own substance the indigent, than to glut themselves and starve the needy.
Now, the reader understands what obligations of justice king James the second had to abrogate the aforesaid acts of settlement and explanation. The only difficulty which appeared in the discharge of the said obligations was how to afford compassion (there was no justice due) to such persons as had purchased some of the Irish lands at considerable rates from the Cromwellian soldier or adventurer, or 1649 man, and who were now to be dispossessed by the abrogation of the act of settlement and of the act of Explanation. These purchasers could not plead any right to the detention of those lands by the said two acts of parliament, because, as you have seen, they are void in law. Neither could they have recourse to equity by having given a valuable consideration for those estates, because there is a prior rule set down to all emptions, videlicet, caveat emptor, which obligeth the buyer to buy nothing but what is the true property of the seller; and if the buyer does otherwise, this rule bars equity to claim a recompense from the true proprietor for money, or any other value given for the thing recovered by him, because equity was in precedence on the true proprietor's side, who therefore can challenge his property (wheresoever he finds it) against all claims of after laws made by man, or against any subsequent equity which riseth from bargains. For it is the voice of mankind that the first proprietor loseth not his property but by his own consent, or by a just forfeiture to the government where he is a subject; or by a lawful conquest, which is effected in a war between two independent states. Now, the Irish gave not their consent that the Cromwellians should seize on their lands. Neither did they forfeit them to their prince, king Charles the second; for he owned them good subjects. Nor did they lose the said lands by a conquest; for it was their fellow-subjects, actually rebelling, who disseised them. If this were not so, I could safely purchase stolen goods, or anything acquired by *unlawful* ways, as by fraud, murder, rebellion, usurpation, and retain them in despite of the true owner and his


---

p.61






children, which the laws of England and Ireland will not admit, nor the laws of God, or of civilized nations.


Neither could the aforesaid purchasers plead in bar to the abrogation of the acts of settlement and explanation, the rule of prescription or long possession; for it enters not this case, because they began both their possession, and continued the same in mala fide. Yea, it was morally impossible but that they must do so, since from the restoration of king Charles the second unto this day, there *had* been a continual discourse throughout the kingdom that the Irish proprietors had been wronged by the act of settlement, which caused several purchasers of lands, besides the price given to Cromwellian possessors, to buy also the title of the *Catholic* proprietors, hoping by this way to secure their purchases against a general restitution, whensoever it should happen; so that when first they bought those lands, they voluntarily ran the risk of them.


And though the purchasers had taken possession with bona fides after the act of explanation came out in the year 1665, and continued so unto the act of abrogation in the year 1689, yet the said purchasers would be still excluded, as not possessing long enough, according to the law of prescription in lands.


As for the improvements made by the purchasers on those lands, neither in them can they be relieved by justice, because all meliorations go along with the soil; so that whosoever is owner of the soil, the same is, ipso facto, owner of the improvements made thereon, to whom the purchaser in mala fide should moreover refund all the profits he had received out of the said soil.


However, the king and his *Catholic* parliament were pleased to take compassion on the purchasers in the act of abrogation, as we shall see beneath, though the most of those purchasers had bought those lands at a vile price.


And now to revert from whence we have taken this excursion, the king, being resolved to restore unto his loyal subjects, the Irish *Catholic*, their *birth-rights*, which his present rebels detained, and their fathers, the rebels of his royal brother and father, had violently possessed, without any title, but by the authority of those two pretended 

 


---

p.62


{topic James II. before Derry}



laws, the aforesaid acts of settlement and explanation, he sends forth his writs to summon the nobility and gentry to meet in a parliament at Dublin, on the seventh of May, 1689.


In the meantime his majesty, being persuaded if he appeared before Londonderry that the rebellious inhabitants thereof would return to their allegiance by being certain that the king was in Ireland, and by concession of pardon, resolved to take a journey thither. Upon which he set forth from Dublin in the beginning of April (against the duke of Tyrconnell's dissuasion), being attended by general de Rosen, by the duke of Berwick and others; and having overtaken his army near Derry, he arrived before the town on the eighth, which is a journey of more than a hundred miles. The king immediately sent in word that he was there. To whom the corporation despatched archdeacon Hamilton and Mr. Nevill, who speedily returned to assure the people that the king was in the kingdom and hard by. Whereupon a treaty for their submission was set on foot. The preliminary was that the army should not come within five miles to the town; the king was contented therewith. But while the treaty was far advanced, it happened that the army, by general de Rosen's order, marched by and close by the king, and in sight of the place, that general being of opinion that the appearance of the army would dare the rebels to a conclusion without more ado. The lieutenant-general Hamilton was of a contrary sentiment, for he would have the army not to appear, lest the rebels might see the weakness thereof in artillery and mortars, their knowledge of which would make them continue in their rebellion, as not fearing the king's power; but while the army kept out of sight, they would suppose that it was well furnished with all utensils of a siege, which opinion was best. The army then appearing before the town, the major part of the heads of the people (who were for holding out against the king) took an occasion from the sight of the army to tell their fellow-citizens and the soldiery that there was no depending upon the king's word, by reason that the preliminary was broken; and by this and other means they gained the garrison and citizens. Upon which they fired from the rampart with a cannon at the army passing by, and killed an officer that was in


---

p.63


{topic Political errors of James II}



his march near the king. Yet if they were sincere in their intentions, they might have their own conditions from his majesty, notwithstanding the approach of the army, which was not done by the king's orders, who could presently remove that eyesore if the rebels would come to a determination. But his majesty perceiving that he was baffled, and his royal dignity affronted, commanded the army to invest the place on the tenth of April; and so he returned soon after, re infecta, to Dublin, leaving lieutenant-general Hamilton to oversee the beleaguer, and, for assistance, the lieutenants-general Pusignan and Momont, and the duke of Berwick and the *messieur* Pointis, and bringing back with him general de Rosen.


You observe here the return Londonderry made the king for all the pains he had taken in travelling so far, in order to gain those rebels with lenity. But 'tis what he always gets from Protestants generally. No experience will make him behave himself towards those traitors as he should do. He spoiled his business in Ireland by his over-great indulgence towards them. He was infatuated with this rotten principle—provoke not your Protestant subjects—the which hindered his majesty from drawing troops sooner out of Ireland into England for the security of his person and government; from making up a *Catholic* army in England; from accepting those forces the most Christian king had offered him. It was this false politic, which prevailed with him to declare that he had no alliance with France; that he did not believe the Dutch had any design upon him, till they were almost landed in England. In fine, 'twas this deceitful suggestion that ruined him entirely by not mistrusting in time the loyalty of those heretics, as it was that which made king Charles the second commit such horrid injustices in leaving the estates of his faithful Irish in the usurped possession of known rebels both to himself and to his royal father, Charles the first.


The king being gone, the army marched to the north and east side of Londonderry, in the county of Tyrone, and in the first place went to take the fort of Culmore, which lies at the mouth of a narrow arm of the sea, three miles distant from the said Londonderry, close by which fort ships go up the channel to the town. This fort was soon taken, on condition


---

p.64


{topic Siege of Derry}



that the rebellious garrison might go into Londonderry, which should not have been granted to rebels, since the king's army with what artillery they had was able to force them to a surrender without any concessions. General Hamilton put a few men into the place with two or three pieces of cannon, to stop any vessel of the enemy from coming to the relief of Londonderry. A little above it on the same side there was a battery of two small guns raised for the same end, called Newfort; and a second battery a little above that, with two pieces, called Charlesfort. Between this last and another on the opposite side, called Grangefort, there was a weak boom drawn across the river. These mediums appear to be enough, if they were substantial and skilfully laid. The first fault in them is, that the boom was not set by the fort of Culmore, which being there would arrest the entering ship for a while, and this while would give opportunity to the fort, as having more guns to discharge several times at the vessel. The second failure was that the cannon were too small and too few in the fortress, and in the other three batteries. The third and principal defect consisted in the managers of this important task, as it shall be seen in the day of trial.


After the taking of this fort, the army marched back and sat down before Derry, on the 20th of April, 1689, being divided into two principal bodies on the county of Tyrone's side. A third small proportion was sent to the other side in the county of Londonderry, where the insignificant battery of mortars was planted. We suppose that a general coming with his army before a town in order to expugn it, makes it his first business to consider by what method he shall compass his design, whether it must be by making a breach in the wall, or by undermining the same, or by a *escalade*, or by reducing the garrison to misery with bombs and fire works, or by famishing it. Londonderry is situated on the banks of a river which mixes thereabouts with the sea, flowing in a narrow channel between two lands. The town is defended on one side with the said river. On the other side it has no outward works of any moment. The wall is thick and well lined with a rampart. However, one part of it may be soon battered with proper cannon. Scaling the walls thereof is practicable; for it was by that way taken in the wars


---

p.65


{topic Observations on Siege of Derry}



of Oliver Cromwell. The circumference of the town is small, and therefore it may be rendered uninhabitable by half a dozen large mortars playing constantly for a week. At the present siege the town may be famished. Of the defendants, but a few were regular soldiers, though there was a considerable number of the townsmen who were skilful in firing, but would do little service with the sword against the besiegers. There were two governors of the place, one Mr. *George* Walker, a minister, the other Major *Henry* Baker.


In opposition to this, the beleaguring host was potent enough as to numbers of men; for in the month of May it was twenty thousand strong, horse, foot and dragoons. How came it then not to be taken? Some say the cause was that the army had no battering pieces, for there was not in the camp above eight cannon, two of which were eighteen-pounders, the rest petty guns. These eight were so separated, that but two were raised in one place. What effect did they produce? Not any worth notice, for they were not discharged at the wall, but now and then over the wall amongst the houses, and sometimes at a sallying party. Of mortars there were but two, one large and the other little. The great mortar was soon rendered unserviceable, insomuch that the sieur Pointis had no sufficient opportunity to show his skill in bombarding the fortress. But why were not all those necessary instruments timely had, since there was at that time gross artillery in other forts of the kingdom, and since mortars might have been cast at Dublin, or, in season, got out of France? If neither was done, why was the beleaguer undertaken, or, at least, why was it continued? Some do answer, that the siege was carried on in order to famish the town. If this was the last resolution (as indeed it proved to be), why were the besiegers exposed from time to time to danger and actual slaughter, first, by having no lines of defence, especially for the greatest part of the duration of the siege; and secondly, by sending the men upon attacks with extraordinary disadvantage, as in day advanced, and against the enemies covered altogether with entrenchments? For that famishment might have been procured by keeping the army at distance, or in good trenches, because the said town could not be relieved with provisions

 


---

p.66


{topic Observations on Management of Irish Affairs}



but by a straight branch of the sea, which was not deep enough to bear a middling vessel at the ebb of the tide. By this we see the taking of the town depended on the stopping of a single ship from coming up the river, which was an easy task; for (besides the means above mentioned) the work would be infallibly done by sinking across the channel a gabbard or two, which medium was proposed to general Hamilton in process of the siege, when three ships came into the river with corn for the king's army. But the general answered he would not have that done, because it would afterwards spoil the commerce of Londonderry, and thereby lessen the royal revenue. It is said that he had for his prohibition the king's authority. But the reason for not sinking the ship was weak, even supposing the opinion to be true; for it is better to suffer a small detriment than a great general calamity, which must needs have followed out of the not taking of that city, as it c1early appears to a prudent considerer, and as, de facto, it evened afterwards. Neither would the commerce have been destroyed by the stoppage of ships at that place, because that bar was but three miles distant from the town, whither the goods might be brought in barges, to the giving a livelihood to many a family by that sort of carriage. We see the like condition of harbours in several emporiums of Europe, where the distance from the ships to the town is much greater. And we are moreover of opinion, that a gabbard or bark, sunk in the channel of Londonderry, may be taken up, and the bottom of that sea cleared, because the place is shallow at low water.


Here we remark that providence did put human means enough into the king's hands, and into those of his faithful people of Ireland, to subdue Londonderry and Enniskillen, and after that achievement to make further progress in the restoration of his majesty. But it seems the king and the great managers of his affairs did not make the right use of those means as aforesaid, and so they lost their aim, and the Irish *Catholic* lost for ever the blessed opportunity of making themselves a happy nation to the end of the world, by reinthroning their banished monarch. Alas! they did not help themselves in this glorious occasion offered by favouring providence, which if they had done, the day was


---

p.67


{topic Sallies from Derry}



their own; for, as St. Augustine says, Deus conantes adjuvat, exauditque deprecantes—God helps the self-helpers, and hears those who pray unto Him.’’

 Moreover, a just cause is not enough to gain the victory, the managers of that cause must be also just; that is, they must be free from sinning during the management. We see the examples hereof in the combats of the Israelites with the Arabians in their journey from Egypt to the land of promise, and in the holy wars of the Christians against the Saracens and Turks in Asia. The Israelites and Christians had a most just cause, yet they lost often to those infidels through sin in specialty. And so it was in the present case; for, besides the neglect committed by the Irish *Catholic* managers of the king's war in Ireland, and by others who had a hand therein, vice reigned amongst them at that very juncture. Stealth in the commonalty was insupportable, which certainly drew down from heaven the greatest vengeance on the nation; and drinking, gaming, swearing, insulting, indevotion, envy, pride, and lasciviousness in many officers of the army, and treachery in some few, as it was suspected, and covetousness and dishonest dealing in several of the civil officers; on which some curious persons reflecting, they passed their judgment, that the king and his loyalists would be losers at last, as it happened. However, in the meantime we must promote the beginning of this unlucky war, which is the ridiculous siege of Londonderry.
The army being posted before the town, as above said, without lines of defence, and without heavy cannon to make a breach in the wall (which was the posture rather of a blockade), the little battery of mortars began to play, to bring down the houses, since there was no possibility in the present circumstances to break the walls; and the mortars had good effect for the time they were in use, for several habitations werd destroyed. But the grand mortar being soon cracked, the damage ceased, and the people of the town had lodgments enough for their repose. In return to this, the garrison could do but little harm with their cannon to the besiegers, by reason that their batteries were all too high mounted, as being placed on the walls.


In this while, a party of the garrison being resolved upon action 


---

p.68


{topic Siege of Derry}



sallied out unperceived about the end of April, and came surprisingly on the two French lieutenants-general, the sieur Pusignan and the sieur Momont, as they were viewing the ground about Penniburn Mill, on the south side of the town. The fight between them was fiery. The said lieutenants-general fought to admiration, and the small detachment of horse that was with them behaved themselves gallantly. But the lord viscount of Galmoy not coming up time enough with a squadron of horse that was the nearest the place of battle, the rebels prevailed with their greater numbers. Some few were slain on both sides; but the loss of the besiegers was considerable in this, that both the lieutenants-general were killed, as also major John Taaffe, a younger son to the late old earl of Carlingford. Here what a misfortune it is to see such great commanders die by the hands of the mechanic rascals. These were the first sacrifices of quality which have been made at that inglorious siege to the royal cause. In some days after this exploit, there happened another sally, but not of that force which the precedent was of. In this occasion captain Maurice Fitzgerald, brother to sir John Fitzgerald, was slain. At the end of these actions the army was ordered to come nearer to the town, though not to the purpose. The earl of Clancarty came up to one of the gates with his regiment, but had no means to break the gate.


You may admire how comes it that this little corporation *had* dared to stand out against the king, since his majesty is in possession of all the kingdom except itself and the borough of Enniskillen. But the reason thereof is, because these rebels have an assurance of relief from England; for they had in the beginning sent *to that point* word that they proclaimed the prince of Orange their king; that for him they held Londonderry, and would hold it; that therefore it concerned the prince to send them succours which, by having that hold in the country, might recover Ireland to his government. In the meantime they had no fear of losing the town by any assaults of the Irish army, by reason it had not sufficient cannon to make a breach in their walls, nor mortars to compel a surrender through want of lodgments. The only distress they feared was famishment, against which they pressed for remedy


---

p.69


{topic Parliament at Dublin, 1689}



from England. In the interim we will leave for a while this unfortunate beleaguer, and step to Dublin, to attend on the session of parliament which the king had summoned to sit on the 7th of May, as we have above mentioned.


The parliament being assembled on the said day, the king came to the house of lords in his royal robes, with the crown on his head (a crown newly made for him in the said Dublin), and from the throne he uttered a speech to both houses, showing the ends he had for calling them together; after which they proceeded to business. The first and principal act this parliament made was an act called the act of repeal by which they abrogated those two above-mentioned acts of settlement and explanation. By this act of repeal the Irish *Catholic* were restored to those lands unjustly possessed to that time by the aforesaid adventurers, Cromwellian soldiers, and the 1649 officers, *which* lands the said Irish *Catholic* or their ancestors had enjoyed in the year 1641, before the 23rd day of October in that same year; in which act there was a provision made for such persons as had purchased land from the said Cromwellian soldiers, 1649 men, or the adventurers. The said purchasers were to be reprised out of the stock of lands which then belonged to several other Protestants, whose ancestors had been proprietors of them since before the year 1641, in the reign of king Charles the first, and upwards; but now the said several Protestants forfeited them by their rebellion against his present majesty. This parliament made other just acts, and beneficial to the king and country during their session, which lasted from the 7th of May, 1689, to the 20th of July immediately following. But one of their acts was irreligious, which left the ecclesiastic lands in possession of the Protestant bishops, it being sufficient to afford a decent livelihood to heretical prelates during their life, after an usurpation of one hundred and twenty years. They only restored the Roman prelacy to such tithes as were annexed to their station. They mended the matter in parochial priests, for they gave possession unto them of all the tithes of *Catholic* people, leaving to ministers the tithes of their own.


Here riseth the question, whether it would not have been a greater

 


---

p.70


{topic French Squadron at Bantry}



wisdom in the king to defer doing this long-expected justice to the Irish *Catholic* until at least the towns of Londonderry and Enniskillen had been reduced to their allegiance. Some affirmed the point, others denied it. The affirmative said that those Irish *Catholic* actually became careless in prosecuting the siege of Londonderry by their eager attention on the parliament, and afterwards on their possessing themselves of their adjudged estates, as they in a while after would prove heedless in going along with his majesty into England to recover that kingdom; because the actual enjoyment of an estate, without hazard to life, makes a man (who had been in misery immediately before) so satisfied with his condition, that with main difficulty will he be brought to endanger his person, though in a noble cause.


The negative answered, that there was army enough at Londonderry to force that fortress and Enniskillen to their loyalty, though at the same time many Irish proprietors attended on the parliament; and were afterwards taken up in getting possession of their decreed estates, insomuch that the failure in expugning those fortresses did not proceed from the paucity of loyal troops, but from ill management of the enterprise, as all the knowing world must own. Neither were the chief officers of the army those gentlemen who expected to be restored to their birth-rights by the parliament then sitting, but such noblemen and gentlemen as had been a long time in possession of their lands, and such as were younger brothers to good families, and such as were strangers, videlicet, French, English, and Scots, which the muster-rolls do indicate. The negative opinion adds, that if the restorable gentlemen had beforehand their estates, they would be more zealous in assisting his majesty, for the end of preserving the gained possession of their lands. And lastly, the truth is, that there would be army more than enough to go into England with the king without the assistance of the new possessors of the recovered patrimonies.


This latter opinion being the more probable, we go on to say that a little before this, videlicet, on the 1st of May *1689*, while the parliament was assembling at Dublin, a grand squadron of French men-of-war, about thirty-six, under the conduct of count de Chateau-Renaud, arrived


---

p.71


{topic Observations on League of Augsburg}



from Brest at Bantry, in the county of Cork, with gentlemen and officers, Irish, English, and French, and with about three thousand Irish soldiers who had been in England the winter before against the invasion of Orange, and with arms, ammunition, and some money for his majesty's use. As soon as the cargo was discharged on land, the French squadron met, without the bay, with about thirty-two English men-of-war, under the conduct of admiral Herbert, and between them both a sharp conflict soon commenced, the English beginning first, though the war was not as yet proclaimed by the prince of Orange. At last the English admiral, seeing the French preparing for boarding, thought it not safe to encounter him after that manner of fighting, upon which he tacked about and sailed away; the rest of his ships followed. The French pursued, but, not overtaking the flyers in the space of some miles, turned off to Brest.


About this time we are to tell that the prince of Orange being established king of England, he entered immediately of himself into the grand confederacy which had been made the last winter between the emperor, the king of Spain, the states of the united Netherlands and the princes of the empire, against the king of France, and this to keep his royal station, and that the people of England might maintain the new government they had set up against the restoration of their banished king, which restoration they believed he would attempt with the first opportunity. England was then happy in her rebellion, because she met with, at that juncture, a powerful aid to support her rebellious victory over her natural sovereign; and had it not been for that lucky fortune happening unto her at that nick of time, she would have been soon compelled to fall on her knees and cry ‘peccavi’, by that most Christian arm which is ordained, without doubt, to scourge rebels and *heretics*. However, the time is not yet passed, as secure as England thinks herself to be.


This great league of Europe had its origin thus:—The duchess of Orleans making it appear to *Louis XIV.* the most Christian king, her brother-in-law, that she had a good title unto some lands in the Palatinate of the Rhine, the king sent to the elector Palatine a demand to restore those lands. The elector disowned any such right in her royal

 


---

p.72


{topic Observations on Governments}



highness of Orleans. Upon which his most Christian majesty ordered an army to march to the Rhine, to do Justice unto his sister. The count Palatine addressed to the emperor, his brother-in-law, for relief, which Caesar could not afford him in that season, for it was about the end of autumn. In which while, and before the winter fully arrived, the French army took Philipsbourg, and two or three towns more on the Rhine. Hereupon his imperial majesty sent to the *Catholic* king, to the states-general of the united provinces, and to the princes of the empire, to join him in a league against the French monarch; to which those princes assented the more willingly, because they have of late years dreaded the power of France. There is an opinion that it would conduce to the repose of Europe that some one prince were a topping potentate, provided he were guided by the principles of honour and conscience, because in such case the fear of him (not only conceived from his peculiar strength but also from his auxiliaries, for a transcendent power is attractive) would prevent rebellion in nations and groundless wars amongst one another, as we see it verified in roytelets, who seldom fall out, but enjoy the comforts of the earth in a profound peace under the cover of the greater sovereigns, while the mighty and equal powers upon slight occasions destroy the comforts of mankind by obstinate wars. But if such a prince be ill inclined, it would be pity he were so powerful, because he is apt to abuse that exceeding might. Yet I do not see where lies the justice for other princes to league against him, in order to bring him upon a level, out of this consideration only, that he is excelling in strength. It appears to me to be no more just than if I did combine with my equal neighbours to lessen one, who by some righteous way has acquired a much greater estate and quality than any other of us. In the name of God, if it be his right, let him enjoy it, and we are bound not to envy his happiness. Since government was set up in the world, the state of levellers *had* ceased both in sovereigns and subjects, as we find in the record of times and in our daily experience. If nations will not endure a superiority of power in any one nation, then they must be always in war; for it is certain that upon the downfall of one surpassing prince, another will soon rise by some 


---

p.73


{topic Suggestion on arbitration between States}



accession or other of power, through birthright, through donation, or through conquest, so impossible it is to keep a balance in the potentates of the earth. I mean not by this to condemn the *Catholic* king and the states-general for leaguing with the emperor against France, because they may have a just warrant for doing it. But I only accuse of injustice any prince in general who takes arms to diminish his neighbour's greatness because he is mighty above his neighbours, without any other just ground. No reason of state can justify such an enterprise. That is only a rule made by lawless pretenders to policy, which will not bear the touchstone of divine justice, that exacts you touch not another's rights unless he first meddles with yours.


This little spark of fire, kindled in the Palatinate of the Rhine for the gaining and defending a few acres of land, raised such a flame through the extent of *several* nations, that before it could be quenched, ten years' labour was spent, an ocean of blood spilt, mountains of treasure consumed, which might have bought twenty times more land than was in dispute; fleets destroyed; cities, towns, and countries ruined; churches profaned; the service of God conculcated; many a brave family extinguished; and thousands impoverished. Yet, in the end the cause of this long, bloody strife was not ended, but left to a peaceable decision. The consideration of these calamities which must ensue upon a war, should make princes extremely timorous in the enterprise, and never to begin till all fair ways of accommodation are first used, and unless the thing in controversy be of transcendent value and of undoubted right. Otherwise, if the title be ambiguous and the claim of no moment, in such case sovereigns ought to understand that God's rational creatures are not their beasts. Nay, sovereigns have been made such by God and his people, to procure temporal happiness unto them, so that supreme rulers are to regard more the comforts of their subjects than their own in particualar.


It were to be wished (and it becomes professors of Christianity) that *Catholic* princes, ere they enter upon war, did leave their difference to the judgment of the first tribunal on earth, in which sits a person to whom all owe veneration, as believing with a faith divine him to be the

 


---

p.74


{topic Observations on conduct of Catholic priests}



deputy of their Lord and Saviour in guiding mankind in the path of salvation. They can have no solid cause of excepting against his judicature, for he is their common father, his court is perfectly knowing in all the laws and in the science of government, and where conscience is a peculiar profession. This good would result out of that compromise, that though one party should not stand to the sentence of the holy arbitrator, yet the war ensuing thereon cannot in all probability be so long, because the very friends of the dissenting prince will mistrust the equity of his cause, and so not easily engage on his side, which renders his undertaking feeble. The other contendant takes heart at the judgment given for him, and other potentates thereat will be more ready to come unto his assistance—all which circumstances must needs abbreviate the calamity of war.


It was into the abovesaid league against the most Christian monarch that the prince of Orange, as king of England, entered, and soon after declared war, videlicet, on the 17th of May, 1689, against France, but could not be any great helper unto the allies till he had put an end to the war of Ireland, which the Irish *Catholic* undertook against his usurpation. This entrance into the great alliance cost England more than is well credible in money, in the loss of merchant ships, of men-of-war, of most precious *merchandise*, of their honour at sea, in the ruin of trade, in the great slaughter of their subjects, and in the impoverishment of families. The people of England flattered themselves at the beginning that their assistance with the confederates would soon turn the scale to the destruction of France. But ignorance and foolish pride humbled them, who are dearly paying for their haughty attempt at this very day and in this year, 1706, so long since the peace of Ryswick *in 1697*, and will be in like manner for some years to come, so prodigious are the debts they had contracted to maintain their beloved confederacy.


Here curiosity *had* made some persons propose the *query*, whether *Catholic* princes could in conscience receive the alliance of England at that juncture. Their reason is, because thereby those princes assisted rebels to keep out their king unjustly dethroned. We will leave the 


---

p.75


{topic Actions at Derry}



solution of the case unto divines, and only say that such their comportment is foreign to the brave principles of honour, which say, countenance not a base action, though you were to reap lucre thereby; insult not the innocent in affliction for any gain; hinder not the growth of God's religion for the greatest temporal grandeur.


This reception which *Catholic* princes gave to the tendered alliance of England, proved a deep wound on the breast of our James the second, who did rather expect that the emperor and the king of Spain would soon condescend to a peace with the Gallic monarch (which they might have had on honorable terms, and so have prevented those horrible destructions which afterwards ensued), that by such a peace they might combine to restore their brother both in dignity and in religion, and thereby teach subjects not to swerve from their duty. But his majesty must take these disappointments with the usual patience, which *had* not an equal, and so goes on with the management of his affairs in Ireland.


'Tis now the time calls our return to the siege of Londonderry, where the Irish army *had* lain a full month without being a jot the nearer to the expugnation of the town, and may be so in their method unto doomsday; for what cares a fortress (having sufficient provisions) for a beleaguering host that *had* neither cannon to batter down the walls, nor mortars to demolish the habitations, nor ladders for scaling, nor any attempt made for undermining? However, the army must do something, to no purpose; and so it happened that the besieged having resolved to take in a piece of ground for some conveniences, at first in the possession of the besiegers, and afterwards by them abandoned, which lay before the north side of the town, and in the middle of which was a windmill, they, the besieged, took their opportunity in night time to fence it from near one of their gates unto the river with an entrenchment about twelve feet high, making therein several spike holes. This work they well manned with firelocks, and planted two or three small pieces of cannon on the windmill. General Hamilton, observing that the rebels made a walking place of this entrenched ground for the preservation of their health, and that they gave annoyance with their cannon from the said mill and with their long *fowling pieces*,


---

p.76


{topic Actions at Derry}



which carried by several yards farther than muskets, and that they made much use of the water which they found in a spring within the aforesaid ground, he took up a resolution to attempt the regaining of that land, to prevent further mischief to his own, and to straiten the enemy. Whereupon he commanded, on the sixth of May, an attack to be made upon the entrenchment by a detached party of the army. They made the attempt, but were repulsed, with the loss of about one hundred and fifty killed, amongst whom was brigadier Ramsey, a Scotch gentleman. Lieutenant-colonel William Talbot, a younger son of the late sir Henry Talbot, of Templeoge, in the county of Dublin, was mortally wounded, and died in a few days after. The lord viscount Nettervil, of Douth, was wounded and taken prisoner, and in a few weeks after died within the town of Loudonderry. Sir Garrett Aylmer, of Balrath, in the county of Meath, was made prisoner; so was captain John Brown, of the Neal, in the county of Mayo. On the side of the rebels there were very few killed, not worth observation.


This repulse was a great vexation to the army, through the loss of so many persons of worth. However, the general resolved again to make the second attempt; and so, in a few days after, he *on the fourth of June* draws out the greatest part of the foot, and orders them to attack the line. A detachment out of all the grenadiers of the army marched a little before under the leading of captain John Plunkett, the youngest son of Mr. Nicholas Plunkett, of Dunsoghly, in the county of Dublin. After them came the line of colonels, with their pikes in hand, at the head of the infantry. Upon the right marched a detachment of horse under the conduct of lieutenant-colonel Edmund Butler, eldest son to the lord viscount of Mountgarrett. It was between seven and nine of the clock in the morning, so that the rebels had time enough to put themselves in a posture of defence. This was giving them fair play. In their march they were exposed to the cannon of the windmill; but by the time they advanced upon the place of taking their carriere, they received anticipately a shower of ball from the entrenchment in long *fowling pieces*, without seeing an enemy; at which discharge several of the king's men were killed. The aforesaid captain John Plunkett



---

p.77






received at the first fire his mortal wound, and being carried off to his tent, he died within an hour after. Notwithstanding this great check which the loyal party got before they came to action, they went on boldly, and attempted to mount the entrenchment; but their endeavors proved all in vain, by reason the work was so high that they had need of ladders to carry it suddenly. Otherwise a small delay would slaughter them all, by reason that the rebels were very numerous  *within*, and, being wholly covered, could not be lessened by the fire of the assailants; for what harm could the assailants do when they could not lay sight on their foes? At the same time the party of horse on the right went to attack the end of the entrenchment by the river, where it was somewhat lower. But coming near they found it not practicable for cavalry. However, the said lieutenant-colonel Edmund Butler, being extraordinarily well mounted, resolved to show the way, if possible. At which, clapping spurs to his charger, he flies over, but was immediately taken prisoner. Cornet Purcell, of Thurles in the county of Tipperary, followed, but his horse was killed, and he leaped back in his armour, and so saved himself. A private man and an old gentleman, Edward Butler, of Tinnahinch, in the county of Carlow attempted and gained the ditch, but he and his horse were both slain. The rest of the troopers, seeing the imminent danger in leaping the entrenchment at a place by this time strongly guarded by the rebels, were come to oppose, and seeing the cannon of the windmill playing on the very pass, they thought it in vain to attempt the point any further, and so retired, having lost some of their men. Upon the conclusion, Irish were forced to retreat, with the loss of at least two hundred men killed, without doing any damage to the defendants. Amongst the slain was lieutenant-colonel Roger Farrel, captain Barnewal, of Archerstown, in the county of Meath, captain Patrick Barnewal, of Kilbrue, in the same county, captain Richard Graims, of the Queen's county, captain Richard Fleming, eldest son to sir John Fleming, of Staholmock, in the county of Meath, and captain William Talbot, of Wexford.


You see here, as you have seen all along, that the tradesmen of Londonderry have more skill in their defence than the great officers of


---

p.78


{topic Observations on Affairs at Derry}



the Irish army in their attacks. What the rebels could do in point of courage on the field, it is unexperienced. In the meantime it was easy for them to save themselves from fire and sword, having such walls and bulwarks for their cover from head to foot; and there being no attempt made by their foes to break down those covers. Now, whether this last attack upon the entrenchment could have been more prudently managed, some have affirmed it, for, they say, an undertaking of that extraordinary danger should have been better timed. It ought to have been done in obscurity and by a surprise. If two detachments of horse and foot were sent, one to each end of the line, a little before day, with two companies of pioneers, these pioneers in less than a quarter of an hour would open a gap of four or five yards wide for horse and foot to enter; which being done, the defendants in half an hour's time would have been all cut to pieces. Their refuge would be to run back to the town; in which juncture the king's troops might very well have the good fortune to pour in along with them, and thereby take the place as often the like fact *had* happened. Others say that three or four pieces of cannon might have brought down beforehand so much of the entrenchment, being newly made, as would make the entrance easy enough for foot. There are those who aver that it was not worth the cost to take the ground, for what annoyance could it give to the besieged? They lived without it more than a month. It afforded them no victuals, the want of which was the only medium of compelling the town to a surrender. As for air and water, they had enough without the comfort of that piece of land. Well, we will grate no longer upon the misfortune of the besiegers in this affair.


The king, overseeing the session of parliament at Dublin, received an account of these disasters, which grieved him and the parliament very much. And it is no wonder, seeing an army fooling their time away, and perishing before a feeble fortress, when in that space of time they might have conquered a kingdom, if they had been in the beginning transported into Scotland or into England. However, his majesty thought it fit to dispatch away for Londonderry Conrade de Rosen, marshal general of Ireland, in order that he might take some course to


---

p.79


{topic Marshal de Rosen at Derry}



reduce that town to devoir. But the marshal had done as well if he had stayed in Dublin; for what could he do to force the place to a yielding, if he brought no battering cannon nor mortars with him? 'Tis true he might save men's lives by not exposing them so often upon idle attempts, yet still that did not facilitate the expugnation of the town; for vast numbers of men were no dread to them as the case stood, but only famine was their enemy, To procure this was to strike the nail in the head.


The sieur de Rosen departed from Dublin, and took along with him some forces as a reinforcement to the army. When he approached to Londonderry, he seized on three or four hundred Protestants, men and women, relations and friends to the people within the town, whom he brought as prisoners, and, at his arrival about the beginning of July, sent them to the gates of the fortress, in order that they might enter the place (from whence they egressed at the commencement of the siege), and live there among their own. His aim herein was to consume more speedily the provisions of the besieged if they entered; or, if they would not be suffered to go in, the general expected to compel a rendition by keeping those dear friends of the garrison a-starving at their gates. This stratagem seems severe unto some in driving back the people into the town, or in exposing them to famishment at the gates, after they had enjoyed by leave of the prior general their liberty for several weeks. The true management was herein, not to have suffered them to come out at all. This would have hastened the giving up of the fort. Neither is the said stratagem always approved of in point of prudence; for there is a difference between soldiers defending a place for their king against another prince or state (as to matter of obstinacy in holding out), and between rebellious citizens maintaining their town against their own king, into whose hands they dread to fall. The first think it enough to do their duty according to the usual manner of garrisons. The latter are apt to go beyond all mean, so sometimes they will choose to see their wives and children perish before their eyes, rather than give themselves up to the power of their sovereign lord and master. As for the particular rebels of the city of Londonderry, this


---

p.80


{topic Affairs at Derry}



plot of Rosen gave them a greater conturbation than anything which had happened to them since the dawn of that beleaguer; for, though hitherto they have remained so resolute in the defence of the town against their king, that in their nourriture they wonderfully suffered, yet now they are extremely moved at the dismal condition of their flesh and blood a-perishing before their gates. In this Herculis bivium they are for a while at a stand what to do. To bring their friends into the town, and so save their lives, the small remnant of those poor comestibles will not hold out till relief comes out of England; to surrender the town through compassion to their near kindred (after defending it for ten weeks before), and at the time of expected comfort, it is a death to themselves, because they hate the king for his religion, and love Orange for his contrary persuasion, and for being an instrument in delivering them from the government of his majesty. At last the rebels did hit upon a medium of freeing them from all these cruciating troubles. They erected a gallows on the rampart, and sent notice immediately to the general that if he did not suffer their people now perishing at the gates to return to the country, and there to shift for themselves, they would hang all the prisoners, of which some were of quality, as you have above observed. This was a blow for blow, and the rebels became quit with his excellency. This commination was followed by a lamentable request from the prisoners themselves to the sieur de Rosen, praying him not to bring so ignominious a death upon them. The general soon resolved not to see innocent and meriting persons suffer. So, on the fourth of July he ordered the people before the gates to retire into the country. At their going off, it is said that some feeble persons of the town went along with them undiscovered. Marshal de Rosen, seeing his project come to nothing, commanded some entrenchments to be cast up for a better preservation of the army, and concluded that famishment was still the only way in the present circumstances to constrain the town to a submission, on which famish ment he attended, believing that the fort of Culmore and the other batteries with the boom would be sufficient to keep off any ship from coming up the river to the town. From this time to the end of the 


---

p.81


{topic Lord Mountcashel—Anthony Hamilton}



siege there was no undertaking on one side or other that is worth our remark. So we will go on and say that on the 15th of June, major-general Kirk came from England to the pool of Culmore with a fleet of thirty ships, between men-of-war, fregates and vessels of carriage, and three regiments, in order to relieve with provisions and men Londonderry, which by this time was reduced to want. Major-general Bohan, a Scotch gentleman in the Irish army, made a proposal of undertaking to burn them, but it was judged not feasible at that juncture. Major-general Kirk, in some days after, ordered three of his ships to attempt the passing of the strait of the fort of Culmore, which they undertook, but were forced back by the fort with great damage to one of them. At this disappointment the town called for a parley about surrendering. General de Rosen consented to it, and commissioners were appointed on both sides to treat of the matter. Wherefore a cessation of hostility being made, the commissioners met at a distance from the town and from the army, and entered into conferences, the news of which being brought to Dublin, there was great rejoicing therein, as believing that the town would now for certain submit to the king. But it soon happened otherwise, for the commissioners not agreeing, hostility was renewed and continued so to the end of July.


In the meantime the lord of Mountcashel was sent with a small flying camp of four thousand foot, dragoons and horse, to take Crum castle, belonging to Mr. Creighton, in the county of Fermanagh, sixteen miles from the town of Enniskillen, in order to make the way more easy for the expugnation of the said Enniskillen, almost surrounded with a deep lake, and haying an earth-work for defence at the entrance on the land side. He could not make himself master of the aforesaid castle for want of cannon large enough, and so turned off, marching towards Enniskillen. He sent before him most of his horse and dragoons under brigadier Anthony Hamilton. The rebels of Enniskillen, having known the design, sent, on the thirtieth of July, brigadier Wolseley with a body of horse and foot to fight Mountcashel. Hamilton was met by the enemy unexpectedly near Newtown-Butler, and attacked, while the lord of Mountcashel was approaching with the 


---

p.82


{topic Engagement at Newtown-Butler}



main body. But after a short dispute, brigadier Hamilton sent the word by captain Lavallin to his men to wheel to the left, as if it were to rejoin Mountcashel. Lavallin delivered it 'to the left about,' as he thought it was, though Hamilton maintained it afterwards that it was as aforesaid; whereupon the men marched off the field and flew away, as did the brigadier. The enemy thereat marched forwards towards Mountcashel, who, understanding that his van was fled, and that thereby he himself became inferior to the enemy, put his body upon a pass, which was a causeway, on each side a morass. He planted at the end of the causeway two or three small pieces of cannon, behind which he set a troop of horse, on each hand his foot and dragoons. The enemies came to the pass, against whom the artillery was discharged, and some of them dropped. At this they drew back and passed through a wood that was at one end of the said morass, and marched unperceived against the rear of the Irish, who, seeing the foe coming surprisingly upon them in that posture, took their retreat towards Derry. The lord of Mountcashel was made prisoner, being wounded in several places. He was brought to Enniskillen, where he remained until about the twentieth of December following, when he made his escape by artifice, and came to Dublin. Thus the loyal party lost the field on the thirtieth of July, with the loss of a small number, amongst whom was major Fraine, a foreign-bred officer. The rebels lost also a few. But how this mistake in delivering the above said word happened (which gave the occasion of that retreating) it *had* been disputed. In three weeks after the action, brigadier Anthony Hamilton and captain Lavallin were brought to a trial before a court-martial in Dublin, wherein general de Rosen sate president. The brigadier was acquitted, and the captain condemned to a military death, though at his execution he protested that he delivered the word as he had received it; and many believed his protestation. He was a gentleman of a good estate in the county of Cork, within twelve miles of that city, and was much regretted by his friends.


About this time the duke of Berwick had a flying camp on the Finwater. Colonel Patrick Sarsfield had another beyond Ballyshany; 


---

p.83




 {topic Mismanagement by Officers of James II}



and colonel Sutherland another towards Enniskillen, against the rebels, who were in parties on the borders of Ulster and Connaught, but there happened no action worth mentioning. It was from these parts that colonel Sarsfield sent to the earl of Melfort (a Scotchman, who was secretary to the king and minister of state) for some horse which he wanted, at least for two troops; but the secretary proved careless in letting him have that supply; at which the colonel complained, for he suffered through the want thereof. There were more complaints made by others of the conduct of the secretary, which turned much to his majesty's damage. 'Tis thus the king becomes a loser in every place through the mismanagement of his officers, or (if I may say it) through their treachery. And it is certain that if the king were lord and master of all the kingdoms of Europe, he would lose them all by the management which was used in Ireland between himself and some of those whom he principally entrusted. General de Rosen was not alien from this opinion; and marshal de Schomberg at his landing in Ulster intimated as much, when he said that the Irish were brave enemies, for they give us time to prepare against them, meaning hereby that there was a great fault committed in not transporting the Irish army into Scotland or England within two or three months after the king's arrival at Dublin, and before the prince of Orange could have a sufficient army in readiness to oppose them; for Schomberg arrived not in Ireland with the English host until the month of August *1689* as we shall immediately observe.


We return now to Londonderry, to put a shameful end to the siege thereof. On the last day of July *1689* one of the ships, called the Dartmouth frigate, which lay in the pool above mentioned for six weeks, under the conduct of major-general Kirk, resolutely undertook to bring provisions up to the people of Derry, who were by this time reduced to a nonplus in famine, as the besiegers remarked by those of the besieged whom they had killed upon a sally, and as it was known by letters, so that in a day or two more the garrison would have infallibly yielded if they were not relieved. The ship then aforesaid took the opportunity on this day of the tide and a fair gale of wind, and so came 


---

p.84


{topic Relief of Derry}



up to the fort of Culmore, and at all hazards ventured to sail by. The fort made some shots at her, but to no purpose. She, being got clear of that fort, arrived before the next battery, which fired also at her, but the ball flew too high. She came to the last battery; this did her no damage. She struck at the boom, which she forced presently, and so went cleverly up to the quay of Londonderry. What shouts of joy the town gave hereat you may easily imagine, and what pangs of heart it gave to the loyal army you may as easily conceive. But it is not so easy to understand how came this ship to pass scot-free by so many batteries, and yet in four or five weeks before, three vessels attempting the same fact were repulsed. The king's soldiers answer that the gunners of the batteries, or some of them, were this morning, the thirty-first of July, drunk with brandy, which caused them to shoot at random. But still there remains a question, whether these officers became inebriated without any evil design, or whether they were made to drink of purpose to render them incapable to perform their duty that day; and whether the English money aboard the fleet in the pool was not working upon them for this effect during the time they lay there on the coast. It must be a heart as hard as the adamant that gold will not make a breach into— *quid non mortalia pectora cogis auri sacra fames!’’*

Publius Virgilius Maro; Aeneïs III 56-57

 Lord, who seest the hearts of people, we leave the judgment of this affair to Thy mercy. In the interim those gunners lost Ireland through their neglect of duty. What compensation they can make for it, we shall be able to understand when they are powerful kings, and not before. However, some will excuse them, and say that their guns were so small and so few that they could not sink a ship in the passage. This makes me reflect on the best advice that was given in this business, which was that a bark or two should be sunk in the channel, and this infallibly would have done the feat and saved the kingdom, for no carelessness or treachery could there have place. Here I cannot but consider on the uncertainty of human attempts; for let a monarch and a hundred thousand of his subjects undertake a mighty business, yet it may be rendered uncompassed by a few of that vast number, either through


---

p.85


{topic Irish Losses at Derry}



neglect of performing their task, or through betraying of their trust. There are instances enough of this in history, both old and modern. If the present war of Ireland can show any, I leave it to the judgment of the reader; yet in the interim I am informed (as I touched before) that the lord Coningsby, treasurer of Ireland for the prince of Orange, giving up his accounts at London, in the year 1692, from the summer of 1690, wherein the battle at the Boyne happened, he brought a bill of many a thousand pound laid out in Ireland on secret services performed there for facilitating the conquest of that kingdom by several persons named that were on the king's side; though I believe that bill did not affect these present cannoneers or those who had a hand in making them neglect their devoir, because the said lord Coningsby entered not upon his employment of treasurer till a year after the siege of Londonderry, nor do these his accounts mount higher.
But to go on: marshal general de Rosen, seeing the town relieved with provisions contrary to expectation, and that there was no other way at present to take it, judged it in vain to remain there any longer, and so he commanded the army to prepare for rising the next day, and for marching back into Leinster, and approaching to Dublin. The army then decamped on the first of August, after lying before the place about fifteen weeks, and after losing about two thousand men from first to last, of which number several were fine gentlemen, and several heads of families, and all noble sacrifices to a most noble cause, and worthy of lasting memory. Their children and their kindred may hereafter reap out of their blood a plentiful harvest of blessings, when Providence shall think fit to put an end to oppression. The army came that night to the town of Lifford, in the county of Donegal, and it might have been sooner at London if it had been transported at the time it sate down before Londonderry. From Lifford the army marched by slow marches till it came near Drogheda, within twenty miles to Dublin, where according to orders it encamped. This of not taking Derry in so long a time, was indeed a heavy stroke of misfortune unto his majesty, which will be soon redoubled; for the king received a certain account, that marshal de Schomberg, 

 


---

p.86


{topic Affairs in Scotland}



general for the prince of Orange, was expected daily to invade Ireland with an army from England, in order to force the kingdom to the obedience of the said prince; whereupon the king commanded that a *Catholic* militia should immediately be made up in every county, and that the flying camps should join the army at Drogheda, that he might be better able to meet the enemy, and fight him. I should think it were better to have kept the army in the north, and to have joined the fierce militia of that country unto it. By so doing, the enemy might have been hindered either to land or to join the rebels of that province who were become numerous; or he might. have been attacked after landing, and before he could be refreshed from the fatigues and sickness of the sea. And if the foe were hindered from landing in Ulster, he could not with safety land in any other province, not having any stronghold therein; nor being sufficient alone to make progress without the adjunction of the armed Protestants, who were in the north. While these things were a-doing in Ireland, the Presbyterian party in the parliament of Scotland prevailed, on the 22nd of July, 1689, to get an act for abolishing episcopacy. Thus the prince of Orange answers the expectations of the episcopal Protestants of England in repairing the Protestant church, which those giddy heads had dreamed that king James impaired. At this same time the lord of Dundee in the Highlands had a body of loyal men for the king, which consisted of six thousand foot, most newly raised, of which there was three hundred Irish, sent from Ireland under colonel Canon. He had also a hundred horse. Against him appeared general Mackay, with four thousand trained foot and four troops of horse and dragoons, Scots and English. Both sides came to an engagement. on the 28th of April, within two miles of the Blair of Athol. The king's party gained the victory, routed and pursued the enemy. But unfortunately, the lord of Dundee being killed in the battle, and his troops not. having a leader of suffieient zeal, and especially of sufficient authority, to continue that little war, they were in a few days after dispersed by the prudent rebels. And, to take a step into England, it happened that in a little while after the siege of Derry was raised, doctor *George* Walker, governor 


---

p.87


{topic Marshal Schomberg lands in Ireland}



of that town, went to London, and thence to Hampton court, where he was graciously received by the prince and princess of Orange, to whom the prince made a present of five thousand pounds on the 29th of August for his service at Londonderry. But to return to Ireland: marshal de Schomberg from Highlake, near Liverpool, landed with ten thousand men, on the thirteenth of August, at Bangor in the province of Ulster; and having refreshed his troops, and being considerably reinforced by the Protestant rebels of that country to near twenty thousand men in all, he resolved to march straight by the seaside, in to the province of Leinster and up to the city of Dublin. But first, he would halt at the town of Carrickfergus, which he invested on the 20th of August. The castle of this place is strong; the governor of it was colonel MacCarty Mór. Schomberg summoned him to yield, but he would not, till on the twenty-seventh he was forced to surrender, for want of powder, on condition that he and his garrison, being his own regiment of foot, and that of colonel Owen MacCarty, should march away to the next Irish quarters with arms and baggagendash;a strange neglect in time of war, when the stores were full of ammunition. After taking Carrickfergus, marshal Schomberg marched forwards, and came to Newry, in the county of Down, on the sixth of September, which he found burned a little before by the duke of Berwick. On the seventh he arrived at Dundalk, in the county of Louth, a small maritime town, where he pitched his camp in a low ground and intrenched, having heard that the king was not far off, and was resolved to meet and fight him. On the eighth, the marshal received from the north the regiments of major-general Kirk, of sir John Ranmer, and brigadier Stuart. The king, hearing that marshal de Schomberg was come as far as Dundalk, gave orders to his army to decamp from Drogheda, and march down to the enemy. A part of the royal forces marched first to Ardee, and thence in a day or two to the bridge of Fane, upon a small river within three miles of Dundalk. Hither the king came on the fifteenth of September with the rest of his army, and enamped. His majesty found the army to be twenty-six thousand strong. Both armies 


---

p.88


{topic Movements of James II. and Schomberg}



lay quiet for a few days without coming to any action of moment. At last the king resolved to try his fortune. Whereupon he drew out his army on the twenty-first of September, and marched in order of battle near unto the enemy, in hopes he would quit his trenches and accept of the challenge. But the marshal *dared* not, as finding the royal troops too numerous for his; and the king would not attack him in his trenches, fearing the victory would prove too dear, though general de Rosen, upon good grounds, was altogether for it, since they could not get the enemy to fight otherwise. And he took the king's refusal to attack the foe so ill, that he resolved not to stay in the kingdom. His opinion was confirmed by several officers, who showed that the attempt was not so dangerous, as it appeared at a distance. At this the king drew back to the town of Ardee, where the army lay encamped, to observe the motions of the enemy, until about the fourth of November. At which time his majesty, seeing no hopes of a battle upon the square, nor the enemy inclined to go off till the Irish army had first decamped, resolved to remain in the field no longer to the prejudice of his troops, the bad weather being at hand; and so he ordered his army to go into winter quarters, while he himself returned to Dublin. Marshal Schomberg, perceiving his enemy gone off the field, immediately rose, which was on the eighth, ninth and tenth of November, after being encamped in an unwholesome place about nine weeks, and afflicted awhile with rainy weather. Whereby it came to pass, that eight thousand of his army died, part in the camp, part in the marching to winter quarters, and part in their quarters and hospitals. The marshal decamping marched to the north, where he quartered his men. Newry, in possession of the rebels, was the line near the sea between both parties that winter, as Cavan, Belturbet and Charlemont in the hands of the loyalists, were the line within the land; so that there remained to the king three provinces of the kingdom, Leinster, Munster and Connaught, and part of the fourth, videlicet, of Ulster. Some have blamed the king's conduct in not forcing Schomberg's entrenchments at Dundalk. They give this reason: the business might 


---

p.89


{topic James II. at Dublin, 1689}



have been done at a moderate loss of men, so you attacked the camp by the sea-side, by which attempt the whole army of Schomberg would probably have been destroyed, considering their inferior numbers, and their weakness through sickness and scarcity of provisions. By this destruction the whole province of Ulster would have been regained, with Londonderry and Enniskillen, which towns would not dare hold out against the king, since their hopes of relief from England were cut off by this stroke; for the prince of Orange had not forces enough in England, out of which to send an effectual army into Ireland, and to man sufficiently the grand fleet for the defence of the kingdom. On the other side, the Irish *Catholic* would be raised in their courage and hopes, and the king could procure by the next spring a strong squadron of men-of-war out of France to convoy his army into England or Scotland, by which trajection he would soon re-inthrone himself. Others have vindicated the king from any error committed by him in not aggressing his enemy plunged in earth, but have passed their opinion, that his majesty or his generals transgressed against prudence in not watching the decampment of the Protestant army, and that then they might have fallen upon them half dead through distempers and lessened by some thousands in their numbers, which onset could have cut off the retreating army without any considerable loss to the loyal troops. About this time of decamping it was that colonel Sarsfield retook Sligo and Jamestown in Connaught from the rebels. The king being come to Dublin sent a request to the most Christian monarch for five or six regiments of old foot, and in exchange of which he would send him as many regiments of his late raised army. For this end, his majesty ordered to make ready for spring to go into France the regiments of the lord viscount Mountcashel; of colonel Daniel O' Bryen of Clare; of colonel Richard Butler of Galmoy; of colonel Robert Fielding; and of colonel Arthur Dillon of Costologh. Over which body 'the said Mountcashel was appointed general. During this winter, 1689, the king and his *Catholic* people of Ireland were cheerful enough, as having not received so great a loss from the army of marshal de Schomberg as they at first apprehended.




---

p.90


{topic Preparations by William III.}
But with all this, his majesty had little or no intelligence of what preparations were a-making in England against Ireland for the next campaign; and therefore he and his loyalists improved not their condition. There was no augmentation of troops made, as there should be, and that considerably; no care taken in exercising the army in their respective quarters; in providing arms and apparel; in fortifying towns, and filling them with ammunition and victuals. This was not the way to secure Ireland and conquer England. Great undertakings require great wisdom, great care, great diligence. Alas! it is no children's play. The council must be staunch in knowledge and loyalty, the civil officers honest in their management; the military commanders must keep themselves from the fooleries of gaming, drinking and whoreing; they must see that their soldiers be expert in the use of arms; be fed, be apparelled, be provided for in their sickness. These are the ways of bringing such high enterprises to a happy end. These gentlemen are eager for the obtaining of higher posts, but they will not take pains to deserve them. The Confederate princes abroad, as the *Catholic* king, the states general, and the rest, having received an account of Schomberg's ill success in Ireland, wrote to the prince of Orange, putting him in mind that, if he did not go himself in person into Ireland, and bring the strength and flower of England with him, the war therein would last long; and consequently his alliance would signify nothing unto them, and thereupon they must be forced to make a disadvantageous peace with the common enemy. This suggestion raised the prince on a resolution to undertake the Irish expedition, and so accordingly he did prepare for the next season. He had already of foreigners in England about eight thousand Danes under the duke of Wirtemberg, who landed at Hull, the 13th of November, 1689. These veterans and other foreign troops, with some English, the prince designed to bring along with him into Ireland at the ensuing spring. In the meantime there happened no winter action of any note between the *Catholic* and Protestant troops on the frontiers of Ulster, except two or three. On the twenty-fourth of November, captain 


---

p.91


{topic Views on Military Operations}

Christopher Plunkett of Lagore, in the lord of Louth's regiment, was sent with his company of grenadiers by major-general Boisseleau from Dundalk to take the above-mentioned Newry, an open town then garrisoned by a few of Schomberg's army. He marched in the night time and by the dawn of the day he made himself master thereof by, the slaughter of a few of the enemies; and as he was going to plunder the place, which was furnished with good store of money, and had horses and black cattle, the captain received an order from the major-general to retire immediately to his quarters. What reason there was for this order we have not been informed, otherwise than that the first design was only but to show to the rebels that the king's frontier garrison was watchful and bold. If this was the true reason it was foolish, for exposing men's lives to no purpose; and at the end, the major-general was in danger to be treated as an enemy by some of the sturdy grenadiers, who hardly could bear such commands. He should have used those fooleries with his beasts, and not with men whose lives are precious to the country. This is a frequent fault in commanding officers, who value the lives of their soldiers not so much as some men do their dogs; and this is a reason why it is a pity that man should be under fellow-man, but that necessity requires it. Hence I infer that great commanders should have as much of conscience as of skill. By this they would be barred from flinging away the estimable breath of men upon every whimsy. And here it is that I offer my sentiment, that the sending abroad of parties at much danger for some small prey, or for cutting off a few of the enemies, or for any such insignificant end, is seldom or never rational. Let the lien be preserved, either for a grand battle, or for a grand siege, or to fight a considerable body, or for an important booty, or to gain or defend a necessary pass, or to cut off the enemy's provision, or, in short, for some other enterprise that is of importance to the whole army. After this business of the Newry, and in January immediately following, brigadier Nugent of Westmeath went with a party to besiege the castle of Kenagh, in the county of Longford, belonging to Sir Thomas Newcomen. The castle was defended by the lady


---

p.92


{topic Arrivals from France—Departure of Irish Regiments}



Newcomen, and some Protestant rebels that took refuge therein. The brigadier expugned it, on conditions advantageous to the besieged, the 13th day of the *abovesaid* month, 1689, old style, but 1690 stilo novo. In the following March, and on the 14th day of the month, a French fleet of forty-one men-of-war, four fire-ships and five flutes arrived at Kinsale from Brest, carrying for the service of the king of England six regiments of foot., viz., of Fimmarcon, of Zurlauben, of Merode, of Lamarche, of Courtasier, and of Forest; making fully six thousand men. Besides this, there were three or four hundred Irish, some English, and some French volunteers, with twenty-two pieces of cannon for the field, three hundred bombs of different sizes, six thousand grenades, a great quantity of ball of all sorts, and of arms and of other necessaries for the king, and for that particular brigade; the general of which was **count de Lauzun**; the lieutenant-general, marquis de Lery. This body was ordered by the king to come to Dublin, where they were quartered till they took the field in May. In exchange of these forces, the above-named Irish regiments, under the conduct of the lord of Mountcashel, were embarked on the same fleet at Cork in the month of April, for France, where they safe arrived. This opportunity for returning was taken by count d'Avaux, the French ambassador, and by general de Rosen, they not approving of the king's method for the preservation of Ireland. But in a month before this there happened a small fight at Cavan, on the frontiers of Ulster, between the loyalists and the rebels. Marsha1 Schomberg, designing to straiten the Irish quarters on the borders of the north, ordered brigadier Wolseley to take a party of Enniskilleners and of English soldiers, and march to Cavan, the head of that county, and fix there. The king, being informed thereof, sent from Dublin his commands to brigadier Nugent, to march to the said Cavan with eight hundred men from the counties of Westmeath and Longford; and at the same time his majesty enjoined the duke of Berwick to march from the county of Dublin with the like quota to the same place, in order to hinder the enemy from gaining ground. Both the royal corps for the 


---

p.93




 {topic Engagement at Cavan—Surrender of Charlemont}



 most part arrived at the open town of Cavan on the l0th of February. They were all foot, except a troop or two of horse. Brigadier Wolseley came to the place on the 11th, in the morning, with seven hundred foot and three hundred horse and dragoons. The duke of Berwick, commander in chief, being alarmed and not well prepared, drew, however, his men out of the town to an open ground, by which he gave an advantage to the enemy, who was come to attack him; for the enemy, seeing that posture, he placed his foot within the hedges and ditches of the avenues of the town, and so took the defensive. The king's forces, being divided into two wings, assaulted the rebels within their fences. The charge being given and maintained smartly, a party of Irish horse broke another of the enemies. But the left wing of the royalists was so overpowered by fighting at such an inequality, that they were forced to retire into a fort that was near them. The right, fighting at the like disadvantage, retreated also thither, by which the rebels gained the field. Of the royal party there were about two hundred killed, amongst whom was brigadier Nugent, much regretted for his bravery. Sowas adjutant Geoghegan, and captain Stritch, and a few other officers. There were ten officers made prisoners, of which were captain William Nettervil, captain Daniel O'Neil, captain O'Bryen, and captain George Macgee. Of the enemies there were slain, major Trahern, captain Armstrong, captain Maio, and near fifty private men, and about sixty wounded. Brigadier Wolseley returned to his own quarters, having first burned the town of Cavan, not being able to keep it, because the castle was in the possession of the Irish.


The month of April being come in the year 1690, marshal Schomberg, like a vigilant general, draws out of winter quarters his army into the field, in order to take the king's fortress, called Charlemont, in the county of Armagh, before the landing of the Prince of Orange and his forces, to the end his highness might find the whole province of Ulster entirely under his obedience at his arrival. The marshal then sat down before Charlemont, about the 22nd of April, which held out three weeks, until the garrison had nothing to eat. Upon which the governor, sir Thady O'Regan, delivered it upon honourable terms, the 14th of May, that the garrison being eight hundred men, should march 

 


---

p.94


{topic Camp of James II. at Dundalk}



away with their arms and baggage. You see, reader, that it was ill management which had lost all 

along whatever part of the country the enemy had gained. It was easy in the winter to send 

provisions into that town for a much longer siege, yet it was not done. You shall meet with more of 

those failures before the war ends. In the meanwhile, I must say that a king is not able alone to 

inspect into every business that comes under his government. 'Tis therefore assistants he must 

have, and these ought to be men of skill and conscience, as we have often said, otherwise the nation 

is destroyed. Whosoever those helpers were, either in advice or in execution, whom his majesty 

made use of in the management of the military affairs, proved either ignorant or dishonest. The 

common report blamed (amongst others) the earl of Melfort, who was secretary, as above said, and 

had the disposal of the warlike stores.


By this time, his majesty commanded that his troops should draw out of their quarters, 

and rendezvous at Dundalk, in order to wait there for the prince of Orange (who was to land in 

Ulster where Schomberg lay) and to give him battle. These troops convened there, but not so many 

as should have met for the design; for too many regiments of foot were left in garrisons, and that to 

no purpose, as it happened afterwards, whereby the king's army, which took the field, proved 

much inferior in numbers to the host of the rebels, though, I own, excellent art might have supplied 

that defect. This was a strange oversight in the king and his generals, not to have brought the 

strength of the kingdom to the field, since the resolution had been taken of putting all upon a battle. 

By this management the king was neither strong in the field, nor strong in towns. For not one 

garrison was of any notable strength in the beginning of the war, nor any care *had* been taken since then to the day of the Boyne (that is a year and a half) to fortify the places.


It would have been better if the king had taken the field sooner and entered into Ulster, 

by which attempt he might have cut off the army of Schomberg, before the prince of Orange could 

land with the rest of his forces. However, his majesty being come to Dundalk on the 16th of June, fixed there his camp, with a resolution to expect the arrival of his enemy and fight him. The ground was naturally fortified, to which


---

p.95


{topic William III. lands at Carrickfergus, 1690}



some works were added. But if the king had proceeded four miles farther to the nigher end of the 

long causeway, that runs through the middle of a great bog, at a place called Four-mile-house, as 

being within four miles to Newry and as many to Dundalk, the moiety of his army, with good 

management, could have stopped the enemy, whereby he would have been forced to take a 

fatiguing march to either of the two passes in the county of Armagh. In the interim, the king might 

be reinforced with ten thousand men of militia from the adjacent counties, and be also before the 

enemy at those passes, as having the lighter army, where his majesty could with more ease defend 

those straights, by which the prince of Orange would have been detained a month in the desolated 

country, to the hazard of famishing his troops; nor was there any other way to pass directly 

into Leinster from the north. His remedy was either to re-embark his army, and land on the coasts 

of Leinster, or to march through the province of Connaught. By that time the campaign would be at 

an end, which would crown the king's affairs. For by the next spring his majesty might have double 

his forces on foot.


But to return: we are to tell you, that the prince of Orange with fair troops embarked at 

Highlake, in Lancashire, on the eleventh of June *1690*, and on the fourteenth he landed at Carrickfergus. He joined immediately marshal Schomberg, by which conjunction there was an army made up of thirty-six thousand chosen men, of which fourteen thousand were horse, mostly veterans, Danes, Germans, French, Dutch, English, Scots, and Irish Protestants, well paid, well clothed, well armed, with a numerous artillery; with the prince of Orange, and in some time before, came prince George of Denmark, the duke of Wirtemberg, general of the Danes, the prince of Hesse-Darmstadt, the lord Douglass, count de Nassau, the duke of Ormonde, baron de Ginkel, count de Solmes, lieutenant-general Mackay, major-general Scravemoer, major-general Talmash, monsieur d'Overkirk, the earl of Oxford, the earl of Portland, the earl of Scarborough, the earl of Manchester, the lord Sidney, and others of quality out of England, all zealots for the cause; which kingdom was left feeble in strength of trained soldiers, for the remainder of the English forces was, for the 


---

p.96


{topic Engagement near Newry}



most part, sent aboard the fleet, in order, with the assistance of the Dutch navy, to secure the coasts 

in the prince's absence. With this fine army the prince of Orange marched to Lough Brickland, on 

the 22nd June, and encamped there, where he had his forces mustered.


On the other side, the king, having received an account that the prince of Orange was landed 

and resolved to march up to Dublin, he sent out of his camp, on the twenty-second of June, a party towards Newry, to take some prisoners, that he might learn the strength of the enemy. The party consisted of four companies of grenadiers, under colonel Fitzgerald, at that time lieutenant-colonel to the lord Bellew, and of sixty horse under colonel Lawrence Dempsy, then lieutenant colonel to the lord of Galmoy. They had orders to remain at the nigher end of the Four-mile pass above-mentioned.


They were not here long, when they discovered between two hundred and three hundred English foot and dragoons, at the other end of the pass, who, it seems, were coming from the Newry towards 

Dundalk, to know the king's strength, and how his army lay. The Irish suffered them to pass the 

causeway and then they poured their shot in amongst them. There was a return made. But the 

English dragoons being more numerous charged the Irish horse with such fierceness, that they 

disordered the troop. Colonel Dempsy suddenly again brought them into order, and returned the 

charge with that violence that they broke their enemies, and in that confusion a party of the Irish 

grenadiers fired in among them, which caused a general flight in the English, of whom there were 

nigh thirty killed, and captain Farlow and another officer were made prisoners. There were about ten 

of the Irish slain, and colonel Dempsy received a mortal wound, of which he died within three days 

after, at Ouldbridge, a village on the Boyne. He was regretted, because he had been a good horse 

officer, who had been a colonel in the king of Portugal's wars.


The Irish party being returned to Dundalk, the king was told by captain Farlow, the 

prisoner, that the army of the prince of Orange was fifty thousand strong. This, I am sure, was an 

exaggeration to oblige the king to fly before his enemy and leave him the country of plenty,


---

p.97


{topic Movements of James and William}



of which Orange stood in need, not having any sustenance but what he brought with him out of 

England, which could not by that time be much. The true list of his army was, as I said above, 

thirty-six thousand effective men or, otherwise, two troops of guards, twenty-three regiments of 

horse, five of dragoons, and forty-six of foot, a few of which the prince left as garrisons in the north. 

'Tis true he had near thrice as many horse as the king; for his majesty had but eight regiments and 

two troops of guards, though a most excellent corps, three regiments of which, viz., of Tyrconnell, 

Galmoy, and Sarsfield, could hardly be matched; the king had also seven of dragoons, and fifty of 

foot, besides the five regiments he had sent to France, in whose place he received six French. Yet, of 

these bodies of men the king had not in the field against the prince, the day of the Boyne, but 

twenty-six thousand, French and all, the rest being in garrisons, and his train of artillery, was not 

above eighteen small pieces, of which twelve belonged to the French brigade. However, this 

information of Farlow, though in itself not credible (considering that both England and Holland, 

Holland being then in war against France, were not then in a condition to spare so great a body, 

nor was England able in so short a time to transport and feed such numbers), yet it had this effect, 

as to make the king believe that the prince was much superior in his troops. Whereupon his 

majesty commanded the camp to rise and return towards Dublin. He repassed the Boyne with his 

army, on Sunday, the twenty-ninth of June, the foot through Drogheda, and the horse through a 

ford of that river at Ouldbridge, before which ford he encamped that night, with his left towards 

the bridge of Slane, and his right to Ramullin, where the king's pavilion was; in which camp he 

remained all the next day, and till Tuesday morning, the first of July. In the interim, the prince of 

Orange marched close after the king from Newry, and came to Dundalk on the twenty-seventh of 

June. On the twenty-ninth he marched a little beyond Ardee, and there encamped that night. On 

the last of June, a Monday morning, he arrived on the other bank of the Boyne, opposite to the 

king's army, and there fixed his camp. That same day, in the afternoon, the prince of Orange, being 

accompanied by


---

p.98


{topic Considerations on movements of James II}



the prince of Denmark and other great officers, went to view the king's camp from the contrary side 

of Ouldbridge. One of the royal cannoneers, perceiving a troop of horse to observe the Irish camp, 

fired that way a small piece, the ball of which slanted upon the right shoulder of the prince of 

Orange, and took away a piece of his coat, and struck off the skin. This was a thunderbolt to the 

saints of rebellion, and it was like to put an end to their holy war.


Here we will consider thus: either the king resolved at his encamping on the banks of the 

Boyne to fight the prince of Orange, in order to keep him beyond the river, the old Rubicon of the 

Pale, and the frontier of the corn country, or he resolved not. If he resolved not, why did he not 

decamp early on Monday morning, before the prince of Orange appeared on the other side of the 

river, or on Monday night, because it is not safe to rise in the face of a more potent enemy? If the 

king resolved to stand his ground, why did he not use the common rules of art military for the 

strengthening of an inferior army against a superior? by which means the inferior *does* gain often 

the point, as we see in the experience of wars. There was at that time but a few narrow passes to be 

fortified on the Boyne, which might have been done in the space of three hours by three hundred 

pioneers.


But you will say, if the king's army had lain entrenched, the prince of Orange would have 

decamped, and marched up by the river to Navan or higher, and there have trajected. We answer 

first: the king might take the same course on his side and be there sooner, as having the more 

expeditious army, and might have entrenched there in like manner. We answer, secondly, that the 

king by these obstructions given to the enemy's passage could have called to his succour fifteen 

thousand resolute men of the *Catholic* militia and volunteers out of the adjacent counties of 

Meath, Dublin and Kildare, some armed with swords, some with half-pikes, some with fire-arms, 

and some with scythes, which with skilful management would likely turn the balance to the king's 

side, considering how propense the people were at that time to fight against a most odious enemy, 

who came to devour their all. But, unfortunately, none of those courses was taken, which makes me 

fear that some one 

 


---

p.99


{topic Engagement at the Boyne, 1690}



or more of the king's counsellors were underhand intent upon the destruction of the nation. 

Otherwise, how is it possible that such gross errors should be committed in the government of the 

army, and in using right ways and means against the attempts of the enemy? The king, 'tis true, 

resolved in the evening, on Monday, to decamp that night, but unhappily, again, that resolution 

was not executed till Tuesday morning, the first of July, about eight of the clock, at which time the army was commanded to march upwards by the river, giving their right flank to the front of the enemy, in order, as 'twas believed, to go to Dublin, to get a better opportunity of defence, or of 

giving battle. Before the army began to move, you must know that there were two regiments of 

foot, the earl of Antrim's and the earl of Clanrickarde's, left at the ford of Ouldbridge, within some 

gardens of the poor inhabitants, without intrenchment or cannon, to stop the enemy a while from 

coming over, till the infantry got clear of the river. At the same time, Sir Neil Oneil, from the left, 

was placed with his regiment of dragoons at the ford of Rosnaree, a little beneath the bridge of Slane 

(the bridge being broken before), to guard that pass. This being so, the army began their march. The 

prince of Orange, seeing them in their motion of going off, ordered his army (and not before) to 

pass the river in two places, principally at the ford of Ouldbridge, and at the ford of Rossnaree. He 

sent lieutenant general Douglass, the earl of Portland, monsieur Overkirk, and count Schomberg, 

the marshal's son, with above ten thousand horse and foot, to pass at Rossnaree, on his right. He 

sent a greater body under marshal Schomberg, the general, to traverse the ford of Ouldbridge, he 

himself following with the rest. The king, observing the prince to attempt a trajection, commanded 

his army to halt and face to the enemy, which they did, and prepared themselves to fight upon the 

passage of the river. But, alas! they were deceived in their expectation, for there was no battle, 

because they were not brought to combat. There was only a skirmish in passing the waters between 

a party of theirs and the whole army of Orange. And because this party did not keep all the hostile 

troops beyond the flood, the king's host must march away, and leave the pass to the foe. If there 

was a settled resolution to fight, why


---

p.100






was not the army led down in two wings to the river, with their field pieces, as they saw the 

enemy's forces divided, and there to stand it out for two or three hours? The hostile cannon could 

not much annoy the Irish, as being mounted upon an over-looking ground, while the Irish artillery 

might play without obstruction in the faces and flanks of the enemies, as they were descending to 

the river and crossing it. I am confident by the knowledge I have of the loyal troops, and of their 

eagerness for fighting that day, if they had been managed, as aforesaid, the prince of Orange would 

not have persisted in traversing the water at such disadvantage, as violent as he was for 

approaching to Dublin. Marshal Schomberg better understood the point, when he made difficulty 

at that juncture to attempt the trajection, as he saw the Irish drawn up for combat. But he was 

overruled by the temerariousness of Orange, which, notwithstanding, did succeed through the non-

resistance of the loyal host, which was occasioned by the ill conduct of generals, as you shall now 

observe. The two great wings of the prince of Orange's army being come to the river, action was 

discovered to begin at four in the afternoon both at the ford of Rossnaree and at the ford of 

Ouldbridge. Whereupon it was ordered that five regiments of Irish foot should be in haste sent to 

reinforce the two before-mentioned regiments at Ouldbridge.


At this time the lord Dungan was commanded down from the right with his regiment of 

dragoons, to give a check unto some advanced troops of the enemies that were ready to gain the 

bank at the upper end of the ford of Ouldbridge, in despite of the fire that was made on them, at 

something too great a distance, by the Irish foot, which were posted near the said ford. The lord 

Dungan having repulsed those troops to the other side of the river, marched back to his station. But 

in his retreat upon a high ground, he was unfortunately slain by a cannon ball. At the same 

juncture, sir Neil Oneil, on the left, with his dragoons, did wonders at Rossnaree, in stopping the 

abovesaid ten thousand men near half-an-hour. But there was no care taken to sustain him, and so 

he was forced to retreat to his line. In this while, the king's army was only spectator of this fierce 

conflict between a few regiments


---

p.101






of their own and the whole hostile camp, which was an unequal match. Whence we may judge that 

it is easy for an host to gain the victory where little or no opposition is given, and that a hundred 

thousand men signify nothing in the field, if they are not brought to the combat. Immediately after 

Dungan's dragoons retired, marshal Schomberg brought down to the ford of Ouldbridge the gross 

of his cavalry, with orders to push on and suffer no check. At this, the seven regiments aforesaid of 

Irish foot, observing they would be soon overpowered, they cried to their own for horse to sustain 

them. In the meanwhile, they made a smart fire at the enemies, and laid them in heaps, as they 

were entering the waters. But their crying for horse was in vain; for they received but one troop, 

which was as good as nothing. At this time, the king remarking from his station, which was at the 

church of Dunore, that the enemy was gaining the passes both on the right and left, sent orders to 

his army to retreat, leaving the conduct to the duke of Tyrconnell, and then he himself went off to 

Dublin, being guarded by some troops of colonel Sarsfield's horse, and by some troops of colonel 

Maxwell's dragoons. As the king departed, the army began their retreat towards the bourg of 

Duleek. The left wing, with the centre, went off first, which left wing was posted over against the 

ford of Rossnaree, the pass being first forced. The French brigade of foot marched in the rear of the 

centre, bringing along with them their cannon, by the help of which they covered the infantry, 

while the horse on the said left gave their assistance. The seven regiments of Irish foot, which 

guarded the great ford of Ouldbridge, not being supported by horse, were also forced to retreat, but 

were in danger to be intercepted by such of the enemy as had traversed first the river before they 

joined their main army, which the duke of Tyrconnell, from the right, perceiving, flew with his 

regiment of horse to their rescue, as did the duke of Berwick with the two troops of guards, as did 

colonel Parker with his regiment of horse, and colonel Sutherland with his. It was Tyrconnell's 

fortune to charge first the blue regiment of foot-guards to the prince of Orange, and he pierced 

through. He presently after engaged the Enniskillen horse, bold troopers. At the same time, the two 

troops of guards and the other


---

p.102


{topic Engagement at the Boyne, 1690—Death of Schomberg}



two regiments of Irish horse, signalized themselves, and were bravely opposed by their enemies. 

This gave opportunity to the king's infantry to get off in safety. 'Twas during these encounters that 

one master Bryen O'Tool, of the guards, discovering his former acquaintance, marshal Schomberg, 

near the village of Ouldbridge, resolved to sacrifice his life to the making him away, upon which 

he, with a few of the guards, and a few of Tyrconnell's horse, made up to him, and O'Tool with his 

pistol shot the marshal dead. But, soon after, fighting like a lion, he was slain. By the time 

Schomberg was killed, the prince of Orange traversed the river with the rest of his army, who near 

the village of Dunore had some small engagement; for the Irish horse, especially the right wing, 

fought, retreating all along, in covering the main body, till they came to Duleek, two miles from the 

Boyne, where, being pressed by the pursuit of the enemy, the Irish army halted, and faced about 

with preparation for a bloody combat, if set upon. But the prince of Orange, observing the king's 

army to make so good a countenance, thought it more prudent to halt and suffer them to march 

away. The heat of this action lasted not above an hour, where you see that it was but a skirmish 

between nine regiments without cannon or entrenchment, and an army of thirty-six thousand 

choice men, for the defending and gaining a few passes, upon a shallow river; and, after the passes 

gained, there happened a running fight between a few regiments of horse with the help of a brigade 

of foot, and all the said army of thirty-six thousand men, for two miles, which shows the retreat was 

admirable, considering the superiority of the enemy and the openness of the ground. The loss on 

either side was not considerable as to the numbers of men, though the king, by that little 

contention, lost the province of Leinster and part of Munster, being open countries. There were 

slain of the loyalists about five hundred men, amongst whom was the earl of Carlingford, a 

volunteer, by whose death his honour and estate descended to his brother, count Taaffe, who was 

then in the emperor's service; the lord *Walter* Dungan, as above said, the only son and child then living to William *Dungan*, earl of Limerick, upon which account he was much regretted; colonel James Dempsey, major Frank Meara, captain


---

p.103


{topic Deaths at the Boyne, 1690}



 Richard Plunkett. Sir Neil Oneil, a brave gentleman, was mortally wounded, of which he died eight days after, in the city of Waterford. Major Thomas Arthur, of Hacketstown, was likewise wounded, and died in a few days. Several other officers were killed, amongst whom were some English gentlemen, *Catholic* and Protestants, that had come out of England to serve his Majesty in the Irish wars. Of these, cornel Kirk and captain Chaplain, Protestants, were killed; and captain James Gibbons, a Protestant, was made prisoner. Lieutenant-general *Richard Hamilton* was also made prisoner, and sent to the Tower of London. Of the enemies there was slain, as above said, marshal de Schomberg a most expert general, as the marshals of France usually are, which was a sensible loss to his own side. This great commander having been dismissed by the most Christian king, because he would not conform to the *Catholic* religion, he came to Holland, where he engaged in the prince of Orange's service, as that prince was preparing to invade England. His body was brought from the Boyne to Dublin, and interred in the cathedral church of that city. Colonel de la Caillemotte: brother to the Marquis of Ruvigny, alias earl of Galway, was mortally wounded, and died in a few days after. The minister, doctor Walker who had been one of the governors of Londonderry against the beleaguer of the Irish, as above mentioned, was here also slain, with some other officers, and about a thousand private men. The tents and the baggage of the Irish for the most part were taken. The army of Orange lay that night upon their arms at Duleek, having left their tents standing beyond the Boyne. The Irish army receiving orders from the duke of Tyrconnell to march unto the city of Limerick, in the province of Munster, they crossed the river Liffey that night at Leixlip and at Chapelizod. The next day they marched forwards to Rathcool, to the Naas, to Castledermot, through Carlow, and through Kilkenny, till they arrived at the said Limerick, in the march of fifteen days. There followed them a great number of gentlemen, who had no military employments, and of the clergy, of farmers and tradesmen, as also of ladies, and inferior women with their children, they having an aversion to stay at home under the arbitrary comportment of an heretical or 


---

p.104




 {topic James II. returns to France}

 



infidel army. The enemy afterwards plundered their houses, took away what cattle they left behind, and seized on their estates and farms. The enemy also committed ('tis a certain truth) some murders in the county of Westmeath and in the King's county. It is well that atheists did no more harm. The king arrived that evening of the skirmish at his castle, in Dublin, where he passed that night, with a heavy heart, in the consideration of his misfortune, which, I suppose, he reputed to be in the loss of the city of Dublin and province of Leinster, rather than in any loss his army sustained. For this loss was nothing, as you have seen, and no fault could be attributed to the army, because the army was not tried, and much of it as were did marvels. In consequence, we are bound to believe that the rest would do as well if they were brought to the test, which they did actually show in their retreat, where their pursuers were ten thousand superior, yet could not hurt them, though the ground was open. Hence we may probably infer that the king's army would have obtained the victory if it had been brought to combat at the Boyne, considering the advantage they had by that river; which inference is confirmed by their behaviour in the first siege of Limerick, and at the after battle of Aughrim, of which beneath. From the whole you may well be convinced that the army was staunch in the fighting part, and that the miscarriage in gaining the end of the war proceeded from the ill management of some of those who had the directive part. Wherefore, we must conclude that the king had no solid reason to quit Ireland upon the loss he sustained at the Boyne in his troops. For the army was rather somewhat stronger at the end of that petty conflict than before, and at its arrival before Limerick it might have been reinforced by ten thousand resolute men at the least, and might have there given battle (as was expected) with the highest probability of victory.


However, the king resolved to go back to France; and so the next morning of the Boyne, being Wednesday, the second of July, his majesty departed from Dublin, being accompanied only by a few gentlemen, and travelled through the county of Wicklow into the county of Wexford, and came to the extremity thereof, viz., to the fort of Duncannon, where he took shipping for France, having found a French man-of-war in 


---

p.105


{topic Movements in Ireland of William III}



that harbour. In his way the king called in at Kinsale, from whence he wrote a letter to the duke of Tyrconnell, whereby he empowered him to assume the administration of the civil and military affairs, and to use his discretion, either to make peace with the prince of Orange, or continue the war. Within a few days after, his majesty landed safe at Brest, and from thence he arrived at St. Germain's, being the messenger of what fortune happened unto him at the Boyne.


The next morning of the skirmish at the Boyne, the prince of Orange sent brigadier La Melloniere, with a thousand horse and dragoons, and a body of foot with eight pieces of cannon, to summon Drogheda, wherein there was thirteen hundred Irish soldiers, and the lord Iveagh, governor thereof, who surrendered the town, on condition that the garrison should march to Athlone without arms. This was a poor defence of a town that gave work enough to Oliver Cromwell to take it in the year 1649. On the fourth day of July, the prince of Orange sent the duke of Ormonde and monsieur d'Overkirke to Dublin with nine troops of horse, to secure the tranquillity of the city. On the fifth he marched his army to Finglas, a pretty village within two miles of Dublin, where he encamped. On the sixth, being Sunday, he made his entry into that city, being attended only by a few of his great officers, and went to the cathedral church to hear a sermon. On the seventh the prince issued a declaration, dated at Finglas, wherein he promises to all farmers and tradesmen his protection of their persons, of their goods and chattels, if they would remain at home and follow their callings. Yet this promise was afterwards ill performed by his officers and soldiers, both in their marches and in their winter-quarters in several places. But the estated gentlemen the prince excluded from his mercy. This was a foolish edict, and the first of this kind, I believe, that ever had been; for commonly a prince, entering into a country in order to conquer it, *does* in the first place encourage the principal persons to submit unto him, and when these are gained, the rest do follow in course. I suppose the prince Orange was persuaded to go against reason in favour of his great officers, who would have the Irish *Catholic* lords of land to be rejected from all expectation of recovering their estates, because the said 


---

p.106






officers were sure in their own conceits that the Irish army would be overcome at last, and because then they might have those lands by the prince's grant. This opinion of the officers was also foolish, because the event of the war is always uncertain, though there be an inequality between both armies, as all understanding persons will allow. Neither could these officers draw any inference for themselves out of the little trial at the Boyne; for their own loss was greater, though but a part of the Irish army fought their whole; and if the rest had been brought to combat, and had fought as their companions did (which we believe they would have done), there would likely have been an end of Orange's usurpation in that kingdom. Besides this, these officers could not be ignorant that the Irish might have a reinforcement by the time they came to Limerick, where they might with greater advantage give the second battle. If their general had been pleased, he might have called to his assistance before the walls of Limerick fifteen thousand good men, by draining the garrisons and by summoning the volunteers. Wherefore it was a great imprudence in the prince of Orange to hazard the conquest of Ireland upon that airy conceit; and, de facto, he soon found his mistake, to his stinging grief, at the walls of Limerick, where his great triumphing army was shamefully baffled by an indifferent proportion of the Irish forces ill defending a most feeble town, as we shall see beneath. The like mistake his officers found in the following year at Aughrim, where they had no title to the victory all the day till a mere chance gave it them in the evening. In fine, they found their mistake at the second siege of Limerick, where the Irish landlords secured unto themselves their estates by their sword.


The prince having refreshed his army, and provided all things necessary for his further expedition, began his march from Finglas towards Limerick on the ninth of July. At his decamping, he sent lieutenant-general Douglass with three regiments of horse, two of dragoons, and ten of foot, with ten field pieces and two small mortars, to take Athlone, on the river Shannon, fifty miles from Dublin, it being the great important pass into the province of Connaught. The lieutenant-general came before the place on the seventeenth of July, and sat 

 


---

p.107




 

 

down on that side of the town which lies in Leinster, and in the county of Westmeath. He immediately summoned the garrison to yield; but the governor, old colonel Richard Grace, knowing his own strength and the enemy's weakness, rejected the summons, upon which Douglass made some effort to take the town unto the twenty-fifth, on which day he marched off, in order to join the prince of Orange in his way to Limerick, after losing above forty men slain, and three hundred men by sickness.


The prince of Orange being arrived with his army at Castledermot, in the county of Kildare, sent from thence brigadier Eppinger, with a thousand horse and dragoons; into the county of Wexford, to secure the maritime town of that name, and head of the shire, and afterwards to oblige the fort of Duncannon to surrender. They found Wexford abandoned, and in it a store of provisions and ammunition; which place might have been easily fortified, so far as to make a smart resist ance against an army of twenty thousand men. General Cromwell could not take it in the year 1649 but by the treachery of the governor of the castle. From hence Eppinger went to Duncannon, which is the second fort of the kingdom, and lies at the mouth of an excellent harbour. It is capable to make a considerable besieging army to pay dearly for the expugnation thereof, and therefore it seems ridiculous that a petty handful of men should presume to frighten it. However, brigadier Eppinger summoned it to yield to the good fortune of th prince of Orange. Upon this, the governor, colonel Michael Bourk, having a smart garrison, made some delay in his resolutions; but at last, considering his scarcity of victuals, as he afterwarc alleged, and the want of sufficient powder, he condescended, on the twenty-sixth of July, to give up the place, on condition that he and his garrison should march to Limerick with arms and baggage.


In the meanwhile the prince of Orange came to Kilkenny with his army in the nineteenth of July. This town is the head of a county. It gave in Cromwell's days some resistance to his forces, but now is abandoned. From hence the prince sent, on the twentieth, count Schomberg with a party of horse to possess Clonmel, a pretty town 


---

p.108






on the river Suir, in the county of Tipperary and province of Munster. It was besieged by Oliver Cromwell, where he lost more men than were lost of his in all the sieges of Ireland. But Schomberg finds the gates open and no garrison therein. On the twenty-first the prince of Orange decamped from Kilkenny and came to the town of Carrick, on the river Suir, where he encamped. The next day he sent major-general Kirk with a party to summon Waterford. This is a city seated on the river Suir, to which the tide arrives, and several miles beyond it, and therefore it makes a handsome harbour. It is the head of a county in the province of Munster, and is a place of great importance. I t might have made with a good garrison a noble defence against a grand army. At this time there were two regiments of foot therein, that of colonel Barrett, governor thereof, and that of colonel Charles Kavanagh. Majorgeneral Kirk having sent in his summons, an answer could not be suddenly given, by reason that there rose a difference between Barrett and Kavanagh about giving up and defending the place. At last it was agreed to surrender the town on condition that the garrison should be conducted with their arms and baggage to Cork, and thereupon it was delivered to Kirk on the twenty-fifth of July. Here the prince of Orange may say, as J ulius Caesar did in his expedition of Zela, *veni, vidi, vici,’’*

Caius Julius Caesar

 so many towns *had* the prince taken without resistance, which, if each of them had given, Orange had been undone; for the war of Ireland would have been prolonged, and consequently the confederacy abroad would have been forced within two years at the farthest to make a peace with France, for want of the assistance of England, which was all employed against the Irish; by which peace all the power of France would fall upon poor England, to her chastisement for her frequent rebellion, and to the dethroning of that unnatural usurper. Here I must own my admiration that gentlemen should take upon them to be governors of towns when they know that they are not able to defend them. They should be so honorable in their dealings, as to tell so much to the prince who employed them, to the end that the nation who depends upon their defence may not be destroyed.
After the taking of Waterford, the prince of Orange went to see it,



---

p.109



{topic Condition of Limerick}

 



and soon returned to his camp at Carrick. Here and at this time the said prince received an account out of England that the French fleet had gained a great victory over the English and Dutch navy in the channel on the thirtieth of June, and that afterwards a body of Frenchmen landed in the west of England and burned some places on the coast. This struck the prince into a huge fright. Upon which, having ordered some troops to be embarked for England, as one of his troops of guards count Schomberg's horse, colonel Matthew's dragoons, brigadier Trelawny's and colonel Hastings' foot, he, on the twenty-seventh July left the army at Carrick with orders to march to Limerick, and he went to Dublin to take shipping there. The prince lay at Chapelizod, a palace of the king's at the west end of the city. But receiving soon a fresh account, that the French at their landing did no great harm, and went aboard again and so off to sea, he altered his mind, and returned to his army on the fourth of August, which he found encamped at Golden bridge, on the Suir, within twenty-two miles of Limerick. In four days after, viz., on the eighth of August lieutenant-general Douglass with his party from Athlone, joined the prince and his army at *Carrickinlish*, within four miles to Limerick.


This is a city situated on the Shannon, the first river of the kingdom, whither the tide mounts from the ocean sixty miles within the land. It was then a weak town, having no outward works but a toy of a palisade before a little part of the wall, nor a rampart within. The wall is of an old standing, and far from being thick. Hither the duke of Tyrconnell and the Irish army were come about three weeks before from the Boyne, A little after their arrival there was a report spread that the Irish would put their back to the walls of Limerick, and there engage in a regular fight with the enemy for the whole kingdom; which report raised the courage of the army, and invited no small number of gentlemen, burgesses and farmers, who flew before the enemy out of Leinster, Munster and Ulster, to approach to Limerick, in order ta share in the glory of that day. There was a strong probability for their prevalence, considering their advantage in the ground, their numbers much increased, and their resolution highly incensed by their loss at the Boyne. 


---

p.110




 {topic Designs of Duke of Tyrconnell}



But the captain-general, the duke of Tyrconnell, took up contrary designs, which he would fain put in execution. His grace had a discretionary power, as I said above, left him by the king, to make peace or contine war, as he should see it most conducing to his majesty's interest and his loyal people's welfare. Upon which he considers thus with himself: at Dublin two years before he was for a war, and was the principal author of raising that great army before mentioned, in order to reinthrone the king. He was then encouraged to it by the assurance of having his majesty soon in Ireland; by the expectation of seeing a sufficiency of money brought from abroad; by the hopes of having reinforcements of trained men out of France; by a strong probability of having thereupon good success, and by other motives. But now, for different reasons, he changes his first opinion. His excellency observed that the great army at first raised was disbanded to almost the moiety; he considered the ill success of the remaining army at Derry; their miscarriage at the Boyne, by which the province of Leinster and the best part of Munster were lost; that the king returned to France; that the French brigade was going away; that the brass money, which hitherto had been the support of the army, was brought to no value; that there were no stores or provisions; that the province of Connaught, which remained unto them, was not able to maintain the army and the vast multitudes of people entered thither from Munster, Leinster and Ulster; that Limerick was a very weak town, yet was their chief defence against the enemy; that if the prince of Orange should be beaten in a pitched battle, England, with the assistance of Holland, would send another army, and another after that, rather than be at the mercy of the king, if he should be restored by the Irish; that the most Christian monarch was not in a state to send them competent aids, by reason that he had so many enemies as kept all his armies at work; that while the *Catholic* army was entire, it was the proper time to get advantageous conditions from the prince of Orange, who would readily grant them to secure his crown; that, in fine, it was not prudence in the abovesaid circumstances and by a strained undertaking to run the fisk of destroying the lives of the people, the expectations of their estates and the hopes of enjoying their religion. Whereupon the duke made this his 


---

p.111


{topic Opposition to Tyrconnell}



mind known to the mixed council of state and war then present at Limerick, and desired their concurrence to make a pacific end of their troubles, leaving to Providence the restoration of their king, since they are not assuredly able to compass it against the powers of England, Holland, Scotland, and the Irish Protestants.


Against this opinion of Tyrconnell there rose an opposition which was sustained with vehemency by a few officers of the army, and namely by major-general Sarsfield, by brigadier Henry Luttrell, by colonel Gordon Oneil, and by others. Zeal for king and country I highly commend—but it should be exhibited with discretion. Over-audacious enterprises are condemned by reason. What these caballing gentlemen can say for continuing the war against the sentiment of the duke, is reduced to these three points, that they have a sufficiency of men, that they have courage enough, and that they will have out of France a consummate general to govern their army, and therefore they will likely have a happy end. The truth of the three premised points I cannot deny; for all their losses hitherto since the beginning of the war are to be attributed to mismanagement, which if for the future they can rectify, I do not doubt but they will carry the day, supposing all other requisites be supplied, of which immediately. For their not taking of Derry proceeded from the want of battering-pieces, of which if the army had a dozen, they might have well made themselves masters of that town in twelve days after trenches opened. The loss of Croom castle fight was caused by mistaking the word that the commanding officer of the Irish gave, by which the strength of the lord Mountcashel's army was drawn from the field. The losing of the battle at Cavan was occasioned by ordering the Irish to attack the enemies within ditches and hedges. The failure at the Boyle sprang from several defects of military management, as it is easily known out of what we have said already. And so of the rest.


But allowing that the Irish arrny is strong and courageous enough, and ruled by a most expert general, is this sufficient to recover Ireland from the hands of so powerful an enemy as we described above. Is not money, the sinew of war, altogether wanting? It is so true, that it 

 


---

p.112


{topic Considerations in relation to the war in Ireland}



was the want of it which chiefly put an end to the Irish war in the year following. And, on the contrary, if there had been enough of it, the Irish army might have been so far augmented from the very provinces of Ireland, which were under the jurisdiction of Orange, that they would have been able to drive the enemy into the sea. Neither was there sufficient provision within the Irish quarters to feed the army and the crowds of people gathered therein from all parts of the realm, the misery of which want they soon felt after the first siege of Limerick. For soldiers have been seen to beg, and officers have not tasted of bread in five weeks; and water *had* been the beverage of the nobler persons. How could it then be expected that men would join the army, when there was neither money nor necessary food to be had? Not any subjects on earth would undertake war for their king at the rate the Irish did.


There was another powerful reason against prolonging the war which we touched above, and which we here repeat. The anti-Tyrconnell faction laid the preservation of Limerick for the foundation of keeping up the war. If it should be taken, all was lost, no body doubting of it. If they could retain the town, they would have time enough to prepare a considerable strength against the next campaign. But now is the *query*: How could the caballists judge it probable that they would preserve with part of their army so very weak a place against a potent triumphing host, that was furiously bent upon finishing the war by the expugnation of that fortress? Certainly their undertaking (on which depended the welfare of the nation) was temerarious after the manner they proceeded. For they should have kept the whole army within and without the city in the county of Clare side, having first made entrenchments at the ford above the town, to hinder the enemy to pass the river, and to cut off the communication between the garrison and their camp, and this to the end that the garrison in the day of a general attack might be sustained by their army.


Notwithstanding these reasons, the factioneers must have their will, and on they will go with the war, relying upon expected provisions out of France and upon French generals, by whose wise management future miscarriages will be prevented. Yet in the mean time I must say 


---

p.113


{topic Commencement of Siege of Limerick by William III., 1690}



that other officers in great trust may mar all if they prove not careful and faithful in the discharge of their duty, though the general be never so knowing and vigilant, as we learn in histories of war, and as we shall see in the present war before it be ended. The duke of Tyrconnell finding that he could not get a concurrence to his design of making a peace with the prince of Orange, he disposed of the army thus: He left about eight thousand men (of which some regi ments were not armed) for the defence of Limerick, the governor whereof he appointed monsieur Boisseleau, and gave him as assistants the duke of Berwick, major-general Dorrington, who was also colonel of the regiment of guards, major-general Sarsfield, brigadier Henry Luttrell, brigadier Wauchop, and brigadier Maxwell. The rest of the forces he sent into the province of Connaught. The cavalry remained a while hard by in the county of Clare, under the command of the duke of Berwick and major-general Sheldon. This being done, the duke of Tyrconnell departed the town, and went to Galway, thirty miles from Limerick, to provide for the shipping off for France the French brigade, who would not stay any longer in Ireland because the king was gone, and they gave the kingdom for lost after the miscarriage at the Boyne, where they struck not a stroke, but what they did in the retreat.


By the time Tyrconnell went off, the prince of Orange invested Limerick, viz., on the 

ninth of August. He sent that same day a summons of surrender to the town, but it was rejected by the governor.


The next morning the prince sent major-general Ginkel and major-gen eral Kirk with a great body of horse over the river into the county of Clare, for the sake of forage and to cut off the communication between the Irish cavalry and the garrison. They passed the Shannon near sir Samuel Foxon's house, two miles above the town, which the Irish might have prevented by making entrenchments and leaving strong guards thereat with a few pieces of cannon. The duke of Berwick, hearing of their trajection, ordered the corn within ten miles of the city to be destroyed, that the enemy might not make use of it. This action proved prejudicial to the Irish in the winter following, by reason it caused a great scarcity of grain. Then the Irish cavalry retreated to the 


---

p.114


{topic Siege of Limerick by William III., 1690}



borders of the next county, viz., of Galway, and the English horse returned that evening to their camp.


The next day, viz., on the eleventh of August, a deserter came from the English army into the town, and informed that there were eight pieces of battering-cannon, with ammunition, provisions, tin-boats, and other necessaries on the road from Dublin coming to the prince of Orange for the siege. Major-general Sarsfield, being desirous to keep off the beleaguer of Limerick for the present season, flew that night to the horse camp, and offered his service towards the intercepting of that great convoy. Uupon which there was given him five hundred horse and dragoons, with which party he hastened over the Shannon into the county of Tipperary, and thence into the county of Limerick, and without any rest marched till he overtook the convoy in two days after, viz., on the thirteenth of August, at night, at a little old castle called Ballineedy, within seven miles of Limerick. He surprised it in the night-time. He bursted the cannon, he burned the provisions and ammunition, destroying everything, and carried off some money, having killed about sixty of the soldiers and wagoners, with no loss of his own. For this action the duke of Tyrconnell recommended Sarsfield to the king's favour, and his majesty thereupon and for other considerations sent a patent into Ireland in five months after, creating him earl of Lucan.


This loss of the artillery struck the prince of Orange into a great fury, because it retarded the siege. However, he got other cannon that served his turn, by reason that the wall was then without rampart, as abovesaid. On the twelfth of August, brigadier Stuart was sent by the prince with a party and four field pieces to take Castle-Connell, a stronghold within three miles of Limerick close to the Shannon. After a few days' siege captain Barnewall, the governor, was forced to yield himself and one hundred and twenty men prisoners of war for want of water.


On the seventeenth the trenches before the town were opened. The chief battery was soon carried within a pistol shot to the south wall of Irishtown. On the twentieth the prince ordered a detachment to attack a small fort of the Irish, called the Stone Fort, in which there were about a hundred men. The action on both sides was brisk; but the assailants 


---

p.115






gained the place, having killed captain Edmund Kelly and the major part of the defendants, and having made a captain and the rest prisoners, with a greater loss on their own side in the slain. Within an hour after, a strong party of foot of the besieged made a sally to regain the fort. The dispute was sharp for a little while, but at last the Irish were forced to retreat at the approach of the enemy's horse, having lost some men, as the English did of theirs; amongst these were captain Needham and captain Lucy.


From the seventeenth to Wednesday, the twenty-seventh of August, the mortars and cannon of the besiegers played furiously. The mortars did not the damage which was expected; but the cannon made a large breach in the wall, whereupon orders were given by the prince of Orange, in the morning of the said twenty-seventh, to the army to prepare for a general attack. Five hundred grenadiers were to begin, who were to be supported by seven regiments of foot, and in like order other bodies were appointed. The garrison was much fatigued by frequent hard duty. 

However, they must reject conditions. But for the more easy and surer defence against the grand attack, which was soon expected, the governor had timely an entrenchment made within the breach from side to side. Behind this work he placed a few pieces of cannon and his battalions. He ordered some companies to stand *within* the breach when attacked. Part of his men, who were on duty the 

day before, he did not call to the action at the beginning, though in the heat thereof they were brought into play. Thus were both sides prepared to gain and defend the town, to finish and continue the war, to acquire and preserve all. If the Irish should be that day overpowered, their all was gone, their religion, their property and liberty, because they had no possibility, after the loss of this town, to make conditions for themselves, and consequently the opposite party would have all.


The consideration of which matter obliges me to think that the Irish commanders hazarded too far the safety of the nation in placing it on their defence of a very weak town without all their forces against so powerful an army; and this without resolving to call for a parley, when they should see a wide breach made in the wall and a numerous host ready to mount it. Such

 


---

p.116


{topic Attack on Limerick by William III. repelled by the Irish}



an obstinate defence is against the usual custom of garrisons, who come to a capitulation when they see their walls down and a powerful enemy prepared to enter the town. I am of opinion that indifferent persons endowed with the military science, observing the besieging army and the breach and the garrison, would lay two to one that the town would be carried by storm; so that I am apt to believe that Providence had a hand in the preservation of Limerick that day for the sake of the loyal people, who suffered so much for justice, to the end that they might not be quite destroyed.


But to go on: the prince of Orange commanded the signal for attacking to be given between three and four of the clock in the afternoon, which being done, his men went on bravely, and after some loss they mounted the breach. The first that did it was captain Farlow, who no sooner gained the honour but he got his death on the place, where the conflict was bloody. However, the assailants by their numbers prevailed and entered the town and the circumference of the entrenchment. 'Twas here the defendants put all their might, and their commanding officers signalized themselves in managing of this last contention wherein their all was at stake.


Whereupon the soldiers were ordered not to fire till the pound was full, as 'twas said, and then they poured in their shot amongst the ingressors, from front, right and left so furiously, that they put the living to a stand, and, seconding seasonably their fire, forced at last the enemies to face about to the breach and fly. The Irish pursued violently, and drove them out of the walls and into their works, making a great slaughter. The whole action continued three hours, with violence on both sides, in which there were killed of the besiegers, soldiers and officers, at least two thousand, besides the wounded; of the besieged, not above 100, amongst whom were captain Lawless and captain Smith of the guards. But captain Patrick Dowdall was slain a few days before in a sally. The next day after this attack there was a cessation for burying the dead.


On Friday, twenty-ninth, the prince of Orange called a council of war, wherein he proposed to make a second attack, which should be undertaken by the second line of the army, that was fresh, and the first

 


---

p.117


{topic William III. departs from Ireland}



line, that had suffered much, should sustain them. But the majority of votes carried it in the negative, which was improved by the Irish Protestants alleging that if the army were foiled in the second assault, the Irish *Catholic* would regain immediately the whole kingdom, and therefore in this doubtful case it was more prudent to proceed slowly in the conquest of the nation than to hazard all at one effort.


This result incensed most highly the prince of Orange, which he testified by his discourse. Whereupon he made an order that the army should decamp within two days and go into winter-quarters. As for himself he would return into England, leaving count de Solmes commander in-chief of the army. He appointed the lord Sidney, sir Charles Porter, and Thomas Coningsby, esquire, lords justices of Ireland. So, having settled his affairs, he went away the next day, being Saturday, the thirtieth of August, for Waterford, being accompanied by prince George of Denmark, the duke of Ormonde, and other persons of quality. From thence he sailed for England on the fifth of September.


On Sunday morning, the last of August, the English army marched off from Limerick with some precipitation, as fearing a pursuit from the Irish. But the Irish garrison were so unfortunate as not to have their cavalry and the rest of their forces near them, which if they had, it is probable that they would have given no small blow to the retreating enemy, being much disheartened at their losses and disappointment before Limerick, which opinion is confirmed by intelligent persons. The English army came to Tipperary, fourteen miles from Limerick, on the sixth of September. From hence they were dispersed into winter-quarters; count de Solmes, the general, took his at Cashel.


The duke of Tyrconnell being at Galway, having received an account of all that had passed at Limerick, rejoiced very much, as did the French brigade, who now would be willing to stay in the kingdom, since they had hopes of retrieving it by the preservation of Limerick; but the fleet being come for them, they *dared* not remain without new orders. Tyrconnell returned to Limerick, to settle affairs there, where he appointed major-general Dorrington governor, because monsieur Boisseleau was to go into France. He ordered the army dispersed up and down to enter into winter-quarters, and the colonels to recruit who had not

 


---

p.118


{topic Mission of Tyrconnell to France}



their regiments complete. He also gave commissions to raise a few regiments of foot for the next 

campaign, being contented to continue the war, seeing he saw some prospect of success, and that he 

could not get a concurrence of the faction in the army to make a peace with the prince of Orange, 

who would now grant better conditions than before the siege of Limerick, yea, most ample articles, 

as fearing the war would be prolonged to the undoing of him, because the confederacy abroad 

might in the interim be forced, not having the assistance of England, to make peace with the king of France, the consequence of which would be the king's restoration. The duke moreover constituted 

the duke of Berwick governor-general of the nation in his absence, because he was going into 

France aboard the fleet that carried the French brigade, to justify his proceedings unto his king, and to beg of the most Christian monarch what aids he could afford. At the same time the cabal 

resolved to send agents in behalf of the nation to St. Germain's, to satisfy the king in their opposing the duke of Tyrconnell's sentiment, and to obtain a French general and other general officers, in hopes to carry on the war with better success. The agents were three: doctor Creagh, the *Catholic* bishop of Cork, colonel Nicholas Purcell, of Loughmoe, and colonel Simon Luttrell, of Luttrellstown. The duke of Tyrconnell, having settled affairs at Limerick, went to Galway, where he embarked along with the French brigade about the twelfth of September. In a little while after, the Irish agents took shipping at Limerick.


After Tyrconnell was gone, major-general Sarsfield, being desirous to get some quarters in 

Leinster, went with a party, about the fourteenth of September, over the bridge of Banagher, to 

besiege the castle of Birr, in the king's county, garrisoned by a company of colonel Tiffin's regiment; but major-general Kirk coming with a greater force to relieve the place, Sarsfield was obliged to march off. 'Twas about the end of this month that count de Solmes was called for into England by the prince of Orange, and baron de Ginkel was made lieutenant-general and commander-in-chief of the English army, who had his quarters at Kilkenny. But before this it was judged to be most conducing to the prince's


---

p.119


{topic Capture of Cork}



affairs in Ireland to, take the city of Cork and the fort of Kinsale in this very season, for which end preparations were made in England. Whereupon the prince of Orange, being arrived in London, 

gave orders that the forces designed for this purpose should be embarked immediately for Ireland 

under the command of the lord Churchill, made earl of Marlborough by the prince. These forces 

were: Marlborough's regiment of fusiliers, that of brigadier Trelawny, that of princess Anne, and 

those of colonel Hastings, of colonel Hales, of sir David Collier, of colonel FitzPatrick, a hundred men of the marquis of Winchester's, created duke of Bolton by the prince, two hundred of the earl of Monmouth's, the two marine regiments of the earl of Torrington, alias admiral Herbert, and of the earl of Pembroke. With this body of men, in a fleet of eighty ships, great and small, my lord Marlborough came on the twenty-first of September into the Cove or bay of Cork. The next day the fleet passed up to the town by the great island on the right and a little insignificant fort on the left, ship by ship, by reason the strait was so small, which fort was soon destroyed by the cannon of the men-of-war as they sailed by. That evening the troops were landed hard by the town, and they invested the same. In a day or two following, major-general Scravemoer and the duke of Wirtemberg joined them from the county of Tipperary, with fifteen hundred horse and four thousand foot, having received orders a little before to that intent. The governor of Cork was colonel Macgillicuddy, who had four thousand men for garrison. He held out to the twenty-eighth 

of September, at which time he was forced to yield the town and the garrison to be prisoners of 

war, for want of powder, which the enemy knew the day before—a strange neglect in business of 

highest consequence, and an usual defect in the management of this war, as I have often mentioned.


The loss of so many men was no small weakening of the Irish army, and the loss of that city was 

very sensible to them, because thereby they lost the great county of Cork, as large as any other two counties in the kingdom; they lost part of the county of Kerry, and part of the county of Limerick, in which tracts of land the greatest part of the king's forces might for that winter subsist.




---

p.120


{topic Operations against Kinsale}
After Cork was thus taken, the garrison was transported into England. But before the English 

fleet quitted the harbour, one of the prime men-of-war was blown up by its own powder, which 

took fire through heedlessness of those whose office it was to look to the ammunition. In this vessel perished, among the rest, some Irish officers, and namely, colonel Charles Kavanagh, of the county of Wexford, and Mr. John Walsh, of Piltown, in the county of Waterford. Some were saved by being flung in shallow water near the shore, amongst whom was colonel Barrett, of the county of Cork, and a young son of colonel Kavanagh's. 'Twas a deplorable disaster. When the fleet arrived in England, the prisoners of the chiefest consideration were put into the tower of London; as the earl of Clancarty, the earl of Tyrone, who died therein, the lord baron of Cahir, and colonel Macgillicuddy, governor of Cork. The number of the slain at this siege was but little on either side.


The English lost the duke of Grafton, natural son to king Charles the second. He was wounded, and died the ninth of October following.


The lord Marlborough, general of this army, after leaving a garrison in the town, marched 

on the second of October to the new fort of Kinsale, ten miles distant from Cork, in the same county.


This fort is the first in the kingdom, and it commands the entrance into a harbour that is one of the best in Europe. It is very strong on the sea-side, but towards the land it proved at that nick of time in one place very weak, having there but an indifferent wall, not lined within with any rampart, nor strengthened without with any works. The place was well stored with provisions and ammunition, but it had only a moderate garrison, the governor whereof was sir Edward Scott. On the third of October, Marlborough, from his camp before the new fort, sent in boats major-general Tetau, with eight hundred men, to storm the old fort on the other side of the harbour of Kinsale, in which fort there were about four hundred and fifty men. On the fourth day, Tetau, with his bombs, set fire to the powder of the garrison, whereby forty were killed. The rest retired to an old castle, and surrendered, prisoners of war, after losing in all two hundred men. Before the new fort the trenches were opened the fifth of October. The governor made a smart resistance,


---

p.121


{topic Conclusion of second year of the War in Ireland}



but seeing a large breach made, and preparations for a general attack, he called for a parley. The 

conditions were agreed upon that the garrison, being about twelve hundred men, should march out 

with arms and baggage, and be conducted to Limerick. Of the besiegers there were slain three 

hundred men. With this action the campaign fully ended on both sides, and the second year of the 

war determined. In winter nothing of moment was done; only a party of the English army 

attempted in the month of January to take a prey of cattle out of the county of Kerry, which 

alarmed some troops of Irish quartered on the frontiers, who, believing the enemy much superior to 

them, burned the little open town of Killarney, belonging to the lord of Kenmare, a *Catholic*, in the county of Kerry, and one or two houses of Protestants, by way of preventing the said enemy to 

garrison them, which conduct of theirs was looked upon to be but mere destruction without any 

advantage, as the Marquis of St. Ruth, their general, afterwards judged with sorrow that they had 

defaced their own country. Whatsoever army is master of the field will take all, of course. In the 

meantime those petty, untenable places cannot obstruct the victory of either one side or other.


But before we put a period to this chapter, we think it not amiss to touch a foreign business, 

because it concerns the king, and which was undertaken to restore his majesty. To tell the said 

business in its due time, we must return back to the month of June in this same year, 1690, in which the thing happened. The most Christian king, understanding that the prince of Orange was going out of England into Ireland, and bringing along with him the strength of England, in so much that England was left almost naked of soldiers, he immediately took up a resolution to transport a 

moderate army, in the absence of the prince, into England, which would soon, with the assistance 

of the loyal party, reduce that kingdom to its obedience. But ere the army could pass over, his most Christian majesty must have first cleared the sea by overpowering the confederate fleets of England and Holland, which was a very hard task. However, the king of France would try it. In order to which he commanded his navy to make ready for a grand battle, and to be better manned than usually, At the same time he ordered an


---

p.122


{topic Engagement at Sea, 1690}



army to be made up out of detachments from his several armies he had then in the field against the 

confederate princes, and to march to the appointed sea-coasts of France, to be embarked in case his 

majesty obtained a victory at sea. Things being thus settled, the French fleet sails out and meets the navy of the allies in the channel. They came all to an engagement on the thirtieth of June, as abovesaid, near Beachy, wherein the fight was for a while very fierce; but the English admiral, the earl of Torrington, observing the enemy to be much superior in fighting men, concluded that it 

was not safe to stand the combat any longer, and so tacked about, making his way to England, 

while the Dutch were left dangerously engaged, who at last took their flight, leaving the mastery of the channel unto the French. Thus, by a regular trial the two great potentates of the ocean became vanquished by a nation that twenty years before was not able to cope with one of them; nor ever would be, for what we know, if the animosity of England, frequently exhibited against the monarch of France, had not given him the occasion of making himself powerful by sea as he was dreadful by land.


The damage the Dutch sustained in this battle consisted in the loss of several ships, and of a great number of their equipage. Amongst the slain was rear-admiral Jan Dick, rear-admiral Brackel, and captain Nordel. Of the English there were killed captain Botham, captain Pomeroy, and two captains of the marine regiments. The French loss was little. The news of this action struck England into a terror, which obliged the princess of Orange, then governing alone in the absence of the prince, to secure suspected persons, as the earls of Lichfield, Ailesbury, and Castlemain, lords Montgomery, Preston and Bellasyse, sir Edmund Hales, sir Robert Thorold, sir Robert Hamilton, sir Theophilus Oglethorp, colonel Sackville, lieutenant-colonel Duncan Abercromy, lieutenant-colonel Richardson, major Soaper and others.


The most Christian king, having made the passage into England as easy as he had desired, 

now waited only for the arrival of his army at the sea-side to transport it. But the allies, being 

before this time informed of that king's designs, they were put to their wits' end how to stop the 

trajection of those forces. They fortunately hit upon the only


---

p.123


{topic Continental Asrrangements}



medium, which was thus: They sent with all possible speed to the duke of Savoy a most charming invitation to come into the league, and immediately to draw out his troops in conjunction with those of the Milanese, and so to march straight into France, to invade that kingdom. This prince, esteeming those advantages 

offered unto him by the allies to be transcendent, he accepts of the conditions, and enters the 

confederacy against the most Christian king, his uncle-in-law, and against the king of England, his 

uncle, in like manner, and a monarch basely dethroned by his subjects for his religion, of which the duke of Savoy deemed himself a zealous professor.


Here behold how this prince of a most ancient, illustrious family lays aside his honour, which 

in that juncture exacted from him an adhesion to his royal uncles, and a compassion for the afflicted condition of a *Catholic* king, inhumanly persecuted by his own vassals, and this for an expected lucre, which could not be great but in his imagination.


The duke of Savoy should have been more knowing in the power of France, and should 

have been convinced that the close neighbourhood of the most Christian monarch could do him 

more good, or more harm, than rebellious England and remote Germany and Spain. We will leave 

his royal highness to try experiments till he *had* found what we have said here to be true.


Great Louis, understanding that the Savoyard was leading into France a confederated host, 

speedily resolved with himself that charity begins at home, and that therefore he must postpone 

the restoration of his exiled cousin german, the king of Great Britain, in order to preserve France, leaving the execution of his design to another opportunity. Whereupon his most Christian majesty, having no other army to oppose the duke of Savoy, sent a countermand to the army he had destined for England, and which as yet was not arrived at the sea-side, to face about and march straight to Savoy against the said confederate army. Thus the best occasion that ever France could have of restoring the uncle was totally destroyed by the nephew, which needs must be an uncommon stroke of sorrow (because unexpected) to both the kings, Louis and James; for which reason it *had* been my admiration that so elevated

 


---

p.124


{topic Pope Innocent XI. and James II.}



a spirit as is that of the Gallick monarch, has taken that abuse so tamely. Nay, to the contrary, he *had* raised the duke of Savoy to such honours, when he could render him a most miserable prince, 

as Savoy *dared* not presume unto. Whether the advantage the king of France proposed unto himself 

out of those favours conferred on the duke will ever turn to an account, we will leave it here 

undiscussed.


In the meantime we cannot omit to mention that 'twas in this same year, 1690, and on the twelfth of August, new style, pope Innocent the eleventh went off the stage of mortality. This great pastor had the comfort to receive James the second of England into his flock; and the king, on the other side, showed a noble zeal in paying to the throne of the church those devoirs that usually are paid by crowned heads. Innocent became also godfather to the prince of Wales; he gave bishops unto England; and sent his nuncio to reside at that court, where none had been seen since an age or two before. So that here was a tie of interest between the pope and the king.


But how it had happened afterwards that the holy father fell out with his royal son even in 

the first year of his dethronement, when his paternal affection should have rather run to the 

assistance of his abused child, it is not a thing publicly known. Yet we may draw some light of the 

cause out of this narrative. When the archbishop and elector of Cologne was dead, videlicet, in the year 1688, the chapter entered upon an election for a successor. The canons were divided in their votes. Some were for prince Clement of Bavaria, second brother to the present elector of that name; others for cardinal Furstenberg, a favourite of the most Christian king. The chapter sent up to Rome the manner of the whole election, that the pope might judge which of the two elected persons was most canonically chosen. His holiness, after examination of the matter, gave a decree for prince Clement; and thereupon sent down his bull of confirmation, with commands to the subjects of Cologne to receive Clement as their prince and bishop.


The king of France, being violent for his friend, cardinal Furstenberg, was highly vexed at his disappointment. However, he resolved off-hand (though unjustly) to sustain the cardinal as elector of

 


---

p.125


{topic Observations on Papal Government}



Cologne, and therefore he offered an army to put him in possession of that city. Another party 

established Clement in Bonn, the usual residence of those electors. The pope, having received an 

account of these distractions, conceived great indignation thereat that any prince, especially a son of the church, should dare thwart him in his own tribunal. Whereupon he transmitted commands to 

his nuncio in Germany, to hire him an army to support Clement in his adjudged rights. The nuncio, not finding any forces with the emperor prepared to the purpose, made an offer to the states of Holland for their army.


The first question that rises here is, whether the states came to an agreement. The second is, 

whether the nuncio (supposing an agree ment made) advanced any money unto them. The third is, in case the states had received any, whether did they give it to the prince of Orange, the constant general of their army. I leave the answers to others, who know best these points. In the interim, I say that the prince of Orange was at this very juncture most busy in preparing for his invasion upon England, in order to dethrone the king by the invitation of the heads of the people, and soon after he actually landed in Torbay. It was from this interfact of the nuncio and states general of the united Netherlands that the vulgar error sprung, which says that the pope sent money to the prince of Orange to invade England—a ridiculous whimsey, and so I leave it.


But as to our purpose. If the most Christian king in these differences with the pope, desired the king of England to become his ally, and if that alliance was made, it appears that from hence king James gave offence to his holiness. This pope was a person that both knew and *dared* defend his prerogative. And happy would it be to the universal church that every governor thereof had the like magnanimity. The greatest flaw (generally speaking) in the sacred government is timidity. In this, I own, it wants a reformation; for when once authority is undervalued, the end of that regency cannot be obtained, but in lieu thereof ensues anarchy and confusion. Nor truly do I see what reasons the sovereign pontiffs may have in being fearful to strain endeavours to keep kings to their Christian devoirs, seeing their sacred 


---

p.126


{topic Visit of Tyrconnell to James II.}



empire is not supported by human policy, and in the arm of flesh, but by a privileged providence of 

the almighty God.


However, let us suppose that the monarch of France demanded the king's alliance against his holiness. Yet I am not easily persuaded that his majesty consented thereunto because the conscience of James was tender, and his veneration for the holy see was more than ordinary. Neither will I lightly believe that Louis the great made any such particular proposal unto James the just, though he might have requested his confederacy against all enemies in general.


I should rather think that the pope's anger proceeded from this, that his Britannick majesty refused to accept of the army the king of France had offered him against the designed invasion, because by that refusal the king lost to himself the kingdom, and to the pontiff the national church of England. Notwithstanding which displeasure I am induced to judge, out of the nature of that pope, that if he had lived some years longer he would have procured an end to the late war of Europe much sooner than it happened, and this in order to get the king of Great Britain restored. He would have dealt more resolutely with the emperor, and the *Catholic* king, in obliging them to an honourable peace, than the following pope, Innocent the twelfth, attempted to do. The only obstacle to the prior pope's good will was the offence the king of France had given him in opposing his judgment for prince Clement of Bavaria; but that offence was taken away by the most Christian monarch's speedy submission, so that Clement was absolutely settled in his electorship.


And since we are abroad, we will continue our discourse of things that concern the king and Ireland, because they happened near the end of this year. The duke of Tyrconnell, being arrived at St. Germain's, acquainted his Britannick majesty with his procedure at Limerick, with which account the king was well satisfied; though he would be more glad that the contrary opinion took effect, because thereby he would be sooner reinthroned. And in token that he was pleased with Tyrconnell's discreet behaviour, he made him soon after knight of the most noble order of the garter, and lord lieutenant of Ireland, so that now Tyrconnell is as great as the king can make him.


The next day after


---

p.127


{topic Appointment of French Commander for Ireland}



coming to St. Germain's, the duke of Tyrconnell went to Versailles to pay his respects to the king *of France*, who received him with great marks of esteem. The duke in the great chamber of presence made his high acknowledgments to his most Christian majesty, for the favours he had done to the Irish nation. The king answered that his country shall still have as much assistance as the present state of his royal affairs can admit; with that the monarch brought the duke into his closet, where they had a private conference for an hour and a half.


In a few weeks after, the Irish deputies above-mentioned, being come to the court of St. Germain's, exhibited to the king *James II.* their reasons for opposing the duke of Tyrconnell at Limerick when he pro posed to make a peace with the prince of Orange. At the same time they begged of his majesty to let them have a French general, and with him they conceived hopes of retrieving the kingdom of Ireland. The king thought it fit to acquiesce to their reasons, since their intentions appeared to be for his good and their country's, and since their undertaking, with such helps as France could then allow them, was not void of probability, especially considering how they foiled the enemy before Limerick. Upon these hopes his majesty procured for them, from his constant great friend, the king of France, both general officers and a fleet of provisions, ammunition, clothes and arms for the army to be sent into Ireland in the foHowing spring. The general was the marquis of St. Ruth, whose patent being drawn was signed by his Britannick majesty, wherein he was constituted marshal-general of Ireland. There were also two lieutenants-general appointed, the marquis d'Usson, and the chevalier de Tessé; also there was made a governor for the city of Limerick, monsieur la Tour.


We are now entering upon the third and last year of the Irish war, which the *Catholic* people of that kingdom had undertaken to vindicate the king's rights against the rebellion of England. Their intention was pure, their zeal ardent, their loyalty without a second, but their management stark naught. Whether treachery of particulars not only of their nation, but of strangers also, was an ingredient in the miscarriage of their enterprise, I dare not positively affirm it, but inasmuch

 


---

p.128


{topic Appointment return of Tyrconnell to Ireland, 1691}



as I spoke of it above. However, it appears that some such thing was in the cause of their failure, as well proceeding from the court as from some in the army, and in the government of towns.


If those traitors (supposing them to be such) did profoundly reflect on themselves, that 

reflection (methinks) should be capable to give them death or distraction; for the treachery of each individual must needs have been greater than what he can possibly make compensation for. But if it proved the cause of the loss of the kingdom, in such case a king is not able to give satisfaction, as 'tis most evident. Woe be unto him that chose to be spectator of his country a-bleeding, of his religion expiring, of thousands of families reduced to miserable extremity, rather than want a purse of gold (though he was in no want) tendered unto him by the enemy, whereby he might better clothe and more daintily feed. He that has sold the honour of an honest man with so much detriment to others, cannot afterwards find the least solid comfort on earth, though for the comforts of earth he had made that brutal bargain. For, on one side he is in scorn and in detestation with those he had betrayed; on the other, he lives in an undervalue with such as his perfidiousness benefited. Here his conscience daily stings him; there the apprehension of too speedy a death gives him too frequent torments. The foreigner passes by, not deeming him worth his salutation. The kinsman is ashamed to own his kindred. And, in fine, everybody ridicules him as a fool, because, without selling his honesty, he had enough to live upon with honour before he turned traitor; and he might have continued that sufficiency in remaining faithful to his trust; and though bis party should have been overcome, yet a person of talents cannot miss to live decently and with credit in the world.


But to go on with our narrative: It happened that in the beginning of this year, 1691, new 

style, and about the fourteenth of January, the duke of Tyrconnell, accompanied by sir Richard Nagle, sir Stephen Rice and others returned out of France into Ireland and landed at Galway, bringing with him a few thousand pounds in silver and gold. From thence he came to Limerick, where he was received with the usual respect that is due to a person in his high station. The viceroy begins to prepare


---

p.129


{topic General St. Ruth arrives in Ireland}



for the approaching campaign, in the expectation of the arrival of the new general. In the meanwhile he disperses a little money amongst the officers of the army to comfort them, and assures the soldiers that a fleet is coming with all necessaries for them, of which the army was in great want all the winter.


When the lord lieutenant arrived, the duke of Berwick resolved for some reasons to go into 

France, and so departed from Limerick about the twenty-fourth of February, *1690-1.* It was about this time that Mr. Mark Bagot, who had been sergeant-at-arms for the king, went from the Irish quarters to Dublin, to do in that city secret service for the loyalists. But, unfortunately, he was taken in woman's apparel, on the twenty-eighth of March, as he was entering into the town, and on the twentieth of May following he was put to death for a spy.


About the beginning of March the duke of Tyrconnell, finding that the brass money hitherto used became of no value, cried it down by proclamation, commanding all persons to bring in by a certain day their several sums, and to tell them to the commissioners of the mint, Mr. Walter Plunkett, Mr. Mamby, and Mr. Francis Rice, and the said commissioners, to certify the quantity of every person unto the lords of the treasury, my lord Gormanston, my lord Merrion, and my lord Riverston, to the end that the subject might not be a loser thereby when it should please God to restore the king.


In the said month of March, about the twentieth day, general St. Ruth arrived at Limerick from Brest, with the above-mentioned lieutenants-general and the governor. At his landing on the quay he was saluted by a discharge of the artillery from the castle. In his proceeding he found the soldiery of the town ranged on each side of the street. The viceroy came to meet him a hundred 

paces from his palace, and gave him the bien-venu into Ireland, and then brought him to dinner. In the evening he was lodged in a house prepared for his residence. Along with St. Ruth came a fleet, bringing arms, clothes for several regiments, powder, ball, a considerable quantity of oats, of meal, of biscuit, of wine and brandy, which caused a plenty in the country. In a few days after, the general began to apply himself to his charge, and 

 


---

p.130


{topic Movements of Ginkel and St. Ruth}



I gave out orders that the army should make ready to take the field, except such battalions as were 

posted for the defence of a few important towns which remained in the possession of the loyal 

party, as Limerick, Galway, Athlone, and Sligo, besides some petty holds.


The month of April being come, baron de Ginkel, general of the prince of Orange's army, 

issued out commands that his troops should quit their quarters and march to the town of 

Mullingar, in the county of Westmeath, within twenty miles to Athlone, there to rendezvous, and 

from thence to begin the campaign. In compliance to which commands, some regiments actually 

arrived thereat on the twenty-seventh of April; the rest were in their march.


On the other side the marquis de St. Ruth sent forth the like orders, that the king's army 

should march out of their quarters to Athlone, and encamp near it, on Connaught side, having 

understood that general Ginkel designed to open the campaign by the siege of Athlone, in order to 

enter into the province of Connaught, hitherto in an entire possession of the Irish; and accordingly 

several regiments of foot came thither in the beginning of May. Their cavalry at the same time was 

marching from all parts.


By the beginning of June the English army was assembled at Mullingar, and on the sixth of the same month they began their march towards Athlone, with intention to take that great pass into Connaught. On the seventh they came to the village of Ballymore, on the road, and in the 

middle between Mullingar and Athlone. There is a fort close by it at the side of a lough, which was 

a little fortified by the Irish the last Winter. Lieutenant-colonel Milo Bourk was now governor 

thereof, in which there were about five hundred soldiers. Ginkel, resolving not to leave this 

untaken, sent a summons that same day to the governor, who refused to comply on good terms; at 

which the general ordered a few pieces to batter the fort, which was brought down to the ground, 

so that the next day, the eighth of June, the garrison was forced to surrender at discretion. They were sent prisoners to Dublin, and from thence all the private men were transported to the island of Lambay, a League from the continent of the county of Dublin. A few men were


---

p.131


{topic Position of Athlone}



killed on both sides. There were found in this little hold only two diminutive pieces of cannon and 

some sheep and cows. This being over, lieutenant-general Douglass, an excellent officer, departed 

from the English camp and went to Scotland, thence to Flanders.


Abuut this same time, the Irish army being fully gathered nigh Athlone, the marquis of St. 

Ruth comes thither from Limerick. The viceroy, Tyrconnell, went thither also, to see how matters 

stood. Athlone lies on the Shannon, which runs through it. On the left of the river is the province of 

Leinster; on the right, that of Connaught. The army was encamped within a mile and a half on 

Connaught side, upon a neck of land between two bogs. To this moiety of the town next the army, 

the only avenue is a causeway made in a morass. At the entrance there was an entrenchment cast 

up the year before, to defend the place against an enemy attacking the town from the side of 

Connaught, which entrenchment faced the Irish army, as it then lay. The duke of Tyrconnell gave 

his advice for demolishing this work, as the case then stood. His reason was, because the garrison 

might then be continually sustained from the king's army that was hard by, and so far as to be able 

to drive the enemy out of the town, though he should have entered, which was undeniably true. It 

was upon this assurance, we believe, and not otherwise, that the marquis of St. Ruth said the baron 

of Ginkel deserved to be hanged for attempting to take Athlone while he was at the head of so great 

an army to defend it, and that he himself deserved to be hanged if he should lose it.


But Tyrconnell's opinion was rejected, I suppose upon a belief that the usual garrison was sufficiently able to hinder the enemy from entering the town, because there was no way for entering but over the bridge, which was broken, or through the river, that was indifferently deep. Notwithstanding this, St. Rut.h's confidence was afterwards frustrated; and the viceroy's sentiment proved the best, and would have proved the preservation of the place if it had been followed. I wish the dissenting from his opinion did not proceed from animosity to his person, which the faction the year precedent at Limerick, or some one or more of the faction, conceived, and it seems there is much of probability in this consideration; for if the cabal had only a true zeal for their king 

 


---

p.132


{topic Opposition to Duke of Tyrconnell}



and country in opposing the judgment of Tyrconnell, as believing their own ways more efficacious to those ends than his, they would not exhibit any disrespect unto him for declaring his opinion how to compass the welfare of the nation; because first, they had no ground to suspect his loyalty; secondly, because he bore the king's person in the government of the kingdom, to whom therefore they owed veneration; and thirdly, because he was above them not only for his quality, long experience and his high station, but moreover for having been owned two years before by the loyal parliament as the pillar of his country. But to trample under foot all these weighty considerations, and to cast a transcendent affront on his person in the face of the army and of the heads of the nation, for no other reason but because he had delivered his opinion concerning the casting down of the abovesaid entrenchment, and because he remained in the camp, where his charge, as being viceroy, obliged him to be in time of war, to observe how the king's affairs proceeded, I say that behaviour of theirs must needs spring from a cankered animosity; for such is the nature of this sort of spleen, as not to regard civility, honour, gratitude, or any other decency.


From whence the rancour rose I will leave it undiscussed, and also whether it had not in some of the faction a worse end than the running down of the duke of Tyrconnell. At least the effect of it (which was the rejecting of Tyrconnell's sentiments) proved fatal to the nation, as we shall remark beneath.


In the meantime, and about the middle of June, while the king's army was expecting the enemy's arrival before Athlone, a message was sent to the duke, and delivered by lieutenant-colonel O'Connor, viz., that if his grace did not withdraw from the camp, he would cut the cords of his pavilion. Here Tyrconnell made a noble conquest of himself, who might that day give the kingdom to the enemy, if he were resolved to vindicate off-hand the indignity cast on the king's authority, and on his own person, for he was able to destroy the Irish army in an hour's time by raising an intestine war in the middle thereof, so great was his interest in that host. He had five regiments of the cavalry for him, he had three or four of the dragoons, and the half of the best foot. The


---

p.133


{topic Attack on Athlone}



greater heads of the nation and the more sensible persons would have stuck to him against a faction that acted by no public authority; for the nation, if called to a voting, would not leave themselves to their management. Here I cannot but admire how it came to pass that the marquis of St. Ruth was induced to connive at this unworthy procedure, the French being so much for venerating authority and quality. But the duke of Tyrconnell, though a man of an elevated spirit, thought it better to smother at present his resentment for the welfare of the king and country, because the time and place were not proper for his vindication without endangering the common cause; though it is believed if he had lived a year longer he would have brought the faction to a condign punishment for the affront offered the king in the person of his lieutenant. Wherefore the duke departs from the camp, leaving them to the providence of God, and returns to Limerick.


By the time his excellency went off, the English army, after taking Ballimore, decamped on the eighteenth June, marching to Athlone, which was invested the nineteenth, on Leinster side. This part of the town was for the most part burned the last year by the Irish; yet at the present they had in it three or four companies of foot, which general Ginkel on the twentieth battered for his first attempt. In the afternoon at five o'clock he made an attack thereon and gained it; a few men were killed on both sides. Of the besiegers, lieutenant-colonel Kirk was slain by a cannon ball, as he was viewing the action from a height.


This part of the town being their own, they raised batteries the next day against the other part, that is on Connaught side. It is destitute of walls and only defended by a castle and the river, over which there runs a stone bridge into the town, the governor whereof was colonel Nicholas Fitzgerald, with a garrison of fifteen hundred men, choice grenadiers and foot. Lieutenant-general d'Usson put himself into it also. On the twenty-second, in the morning, the English batteries began to play against the castle, and in the evening there was made a great breach in the wall. On the twenty-third the whole side of the castle was beaten down, so that it became unserviceable to the besieged.




---

p.134


In a day or two after, what small works were about the castle became so far demolished that there remained no cover to the defendants, except a little behind the said castle. This work being over, the next attempt of the besiegers was how to get possession of the bridge, in order to attack the town thereupon.


The dispute was exceedingly fiery, but on the twenty-seventh the English gained all the arches but the last, which had been broken by the Irish. Now, to repair this was the topping difficulty. However, they carried on their endeavours so far on the twenty-eighth, that they laid beams thereon, and planked part of the beams; yet the same day a detachment of the Irish, with a surpassing audacity, threw down beams and planks, notwithstanding the most terrible fire of the enemy. The next day the besiegers renewed the attempt by the help of fascines, but it proved in vain, for the besieged burned them all.


All endeavours for assaulting the town by the way of the bridge having failed, the baron of Ginkel and the other general officers were at a stand what to do to gain the place, and longer they could not stay before Athlone, by reason that the forage all about for some miles was consumed. To decamp and go to Banagher, to endeavour to pass the Shannon that way, would prove dangerous, because the Irish horse might cut off their provisions, that came to them from Dublin, and only from Dublin. In this perplexity major-general Talmash principally, and seconded by the duke of Wirtemberg, by the majors-general Mackay, Ruvigny, and Tetau, advised to attempt getting into the town through the river in a sort of a ford on their left, and near the bridge.


This resolution was no sooner taken than a deserter traversed the river above the town and came to the Irish camp, letting the general officers know that the enemy would attack the town through the ford the next day. But there was no notice taken of this information, it being judged a thing not practicable. In this same day the Irish garrison was relieved, who had behaved themselves to admiration five days before, during the fury of the siege, and in their place three regiments of foot were sent, two of which, videlicet, of colonel O'Gara and colonel Anthony MacMahon, were but raised the winter before, and had been upon no

 


---

p.135


{topic Attack on Athlone}



service; and consequently they were most unfit to be put upon the defence of a place that was threatened to be assaulted the next day with the last resolutions of a daring army. Whosoever ordered this relief was imprudent or treacherous, notwithstanding that it was judged the enemy would not venture upon so perilous an enterprise. For prudence dictates unto us that in time of danger we must provide for the worst, which danger lasted while the enemy remained before the town. Whether general St. Ruth gave this order, I am not certain. Maybe he left the relieving of the guards to some of the great Irish officers, as believing they were knowing enough for that purpose and faithful enough for their own preservation. Along with this relief came major-general Maxwell for better managing the defence.


The thirtieth of June being come, a deserter or two from the Irish camp swam the river to the English very early in the morning, and told them that the enemy was secure, as believing that the besiegers would be gone, since they had failed so often in their undertakings, and that the garrison of Athlone consisted but of three ordinary regiments, which account encouraged Ginkel in his enterprise. But certainly it must be chiefly the knowledge that he must needs have of the abovesaid entrenchment being not cast down, and consequently that the weak garrison being overpowered by the assailants could not be sustained from the Irish army. Otherwise it was downright madness to attempt the matter, whereupon general Ginkel, having commanded two thousand men to make ready under the conduct of major-general Mackay, he distributed some money amongst the adventurers as a cordial unto them in this perilous assault. So, at six o'clock in 

the morning, captain Sandys and two lieutenants led through the ford, up to the armpits, sixty grenadiers in armour, twenty abreast, followed by a great body.


The garrison fired at them, and the English army fired in amongst the garrison with great and small shot. But amidst this furious storm, the adventurers gained the bank through a breach that had been made in a small work of earth, and speedily pierced into the place, casting before them their grenades, which, bursting, made frightful effects amongst the raw soldiers of the garrison, who had not been used to such squibs.




---

p.136


{topic Capture of Athlone}
Some of the ingressors ran immediately to the end of the bridge and helped their companions on the other side to lay beams and planks on the broken arch; others went to assist the laying of the bridge of boats, by which means the English passed into the town so fast, that in half an hour all was their own, the garrison being forced to yield to numbers and better soldiers, and to retreat to their amy. Immediately the victors manned the entrenchment against the Irish forces that might attempt to come down the causeway, and beat them out of the town. Thus the place was lost, against all expectation, through a ford, which might have been defended with a thousand firelocks by the help of a trench in the bank, maugre the whole army of the enemy; and, as it was, two thousand expert soldiers rightly managed would laugh at the attempt. Here is nothing but a concatenation of errors in all the enterprises of the loyalists, no antecedent experience rendering them wiser; for which there is no excuse, unless they could make out that it is a succession of treachery which mars their efforts.


The marquis de St. Ruth, hearing the town was taken, fell into a sensible grief. However, he ordered some troops to march down, and retrieve the place if it was practicable. But the officers observing that the entrenchment was extraordinarily guarded, and might be supported by the hostile army, they returned to their camp.


In this assault the English lost but a small number of men besides the wounded, who were lieutenant-colonel Columbin, four officers more, and thirty soldiers. Of the Irish a few were slain, amongst whom in this action and in the rest of the siege were colonel MacEligot, colonel Richard Grace of Courtown; [*gap: blank in manuscript*].


There were made prisoners major-general Maxwell, a French adjutant-general, captain Dalton, and two or three other officers, and a few private men.


The loss of Athlone on the thirtieth of June rises up in judgment against the opponents of Tyrconnell in his opinion, which, if followed, would have preserved that town, and in sequel the province of Connaught, as all now do confess. When the news of this misfortune came to the duke of Tyrconnell, then at Limerick, he groaned thereat and redoubled


---

p.137


{topic St. Ruth encamps at Aughrim}



his sorrow that he was so unfortunate as not to be believed when he proposed clear and sure ways of saving his country from a total ruin. However, he must needs again deliver his opinion concerning the operation of the remaining campaign, which is, he would not now lay the kingdom upon a single battle, having heard of such a design, but he would make a defensive and dilatory war in expectation to be superior the next year by succours out of France. In the interim and off-hand (the foot being brought to Limerick) he would send the Irish cavalry over Banagher bridge into the province of Leinster, to bring away from thence great booty, and also recruits from the *Catholic* inhabitants. This enterprise would oblige general Ginkel to send his horse after them, to secure Leinster, from whence he had his sustenance, and his horse being gone, his infantry could not stay behind, as having no towns to cover them, for Athlone could hardly quarter two thousand men, and so Connaught would be still left to the Irish. There was no reason to fear that the Irish horse would be in danger, for, being lighter, they would fatigue the heavy cavalry of the English host, and they had always, upon a necessity, a safe retreat into Limerick.


But general St. Ruth, knowing that he could not well justify his losing of Athlone, at the head of a considerable army, before the king and his own royal master, thought it not fit to pursue the sentiment of Tyrconnell, and so he chose to put the kingdom upon a fair combat, being unalterably resolved to bury his body in Ireland or regain it speedily. Whereupon, observing the strength of his army, he commanded the same to decamp from Athlone in the afternoon of that day *30th June, 1691*, wherein it was taken. He marched towards Limerick and proceeded with small marches, until he came a little beyond the village of Aughrim, twenty miles from Athlone, and thirty from Limerick, in the county of Galway; where, viewing the ground, he judged it convenient for his design, and so fixed there his camp in waiting for the enemy. His army fronted Athlone to the west. Before his front he had a morass, over which foot could come, but not horse. At each end of this morass there was a passage, through which the enemy's horse could come to his right and left flank. That 


---

p.138


{topic The Irish Army at Aughrim}



on the right was a little ford caused by a stream issuing from the morass. That on the left was an old broken causeway, only large enough for two horses to pass it at a time, and was sixty yards long. Beyond this causeway was the castle of Aughrim, on a line, and on the left within forty yards, into which St. Ruth put on that day colonel Walter Bourk and two hundred men. He marshalled his army in two lines. The cavalry on his right were the regiments of the duke of Tyrconnell, of the earl of Abercorn, of colonel Edmund Prendergast, before this of Sutherland, besides dragoons. This wing was to see that the enemy's horse did not break in on the right of the army through the pass of the ford, and through the narrow ground lying between two morasses alter passing the ford; for the English had double the number in cavalry, though the Irish had some advantage in the infantry.


'Twas here lieutenant-general de Tessé and major-general Sarsfield, now earl of Lucan, were posted. The other lieutenant-general, the marquis d'Usson, after the siege of Athlone went to Galway. On the left the marquis of St. Ruth placed the earl of Lucan's regiment of horse, and those of colonel Henry Luttrell, of colonel John Parker, and colonel Nicholas Purcell, with a body of dragoons. The lord of Galmoy, with his regiment, was put behind the second line of the foot, in the nature of a reserve to answer occasions. The conduct of this left wing was given to major-general Sheldon, the first line of which brigadier Henry Luttrell commanded. Their business was to defend the pass of the causeway, near to which, for more security, there were set two regiments of foot.


Close before the first line of the Irish infantry, there were a few old ditches, which were serviceable to them at the first charge of the enemy. The management of the infantry was assigned to major-general Dorrington and to major-general John Hamilton. Thus was the disposition of the army. No doubt St. Ruth showed good skill in choosing ground, and in ranging his host for this fight, where his all and the all of the nation lay at stake. The day before the combat he pronounced some words wherein he manifested his desire that all men would withdraw and reserve themselves for garrisons who were sickly or unable to fight as they should do, because he expected on the morrow to come to an engagement.




---

p.139


{topic Battle of Aughrim}
The day Athlone was taken, the English army and the Protestants of the town made great joy for so unexpected a victory in gaining of which they own to have spent nigh fifty tons of powder, many a ton of stones shot out of mortars, twelve thousand cannon-bullets, and six hundred bombs, which is a great expense. So, having rested here for some days, the army decamped on the tenth of July and marched towards the Irish camp. On the eleventh it came to Ballinasloe, three miles from Aughrim. The next day, being Sunday, it arrived at Aughrim a little after six in the morning, where, having rested a little while, the whole army was drawn up in two lines of battle. The Irish at that juncture were assisting at the sacrifice of Mass, and a little after prepared for meridian repast; but general St. Ruth, observing the enemy arranging in order for fighting, commanded. his men to be marshalled according as we mentioned above.


Both sides being fully prepared, action began a little after eleven, which mostly consisted in the playing of the artillery and in skirmishes for gaining and defending some advanced posts and little passes towards the right of the Irish, and which lasted thus till about six in the evening, when the main bodies deeply engaged. In that while, the English were first repulsed and afterwards they acquired those outward places. I mean, under the word English, the foreigners also, who were the better moiety of the army. Both parties, to give them their due, contended with extraordinary valour, insomuch that their combat was comely, amidst death and wounds, because fought with military skill.


But general Ginkel, not satisfied with the obtention of those little advanced posts, resolved to come closer to the matter, and make himself master of the ford on the right of the enemy, that he might get in that way with his cavalry amongst the Irish foot, which he perceived was somewhat superior, at least upon the account of the ground, and which therefore he seemed to fear most that day. Upon this, he ordered down at two o'clock a great body of horse from his left, to attack the pass of the ford. Here the dispute was rude, because it was for a thing of consequence, wherein the English were first repulsed, until the earl of Portland's regiment of horse, which then arrived in the camp, joined them,


---

p.140






and thereby they pushed the Irish from the ford to the body of their cavalry, which was hard by, where they stood firm their ground all the day in spite of several attempts made on them, because the English horse, even after passing the ford, could not spread, being enclosed on the right and left by the above morasses.


General Ginkel did not like hitherto the countenance of the contention, because he saw no way to weaken the Irish infantry with his horse, if he should generally engage. This consideration put him in a doubt whether he should continue and come to a close fight that day. But it was soon resolved that it was so best. Whereupon he commands his left wing to charge again violently the right of the Irish horse through the ford at five in the afternoon, which they did with great bravery, and as well they were resisted, general St. Ruth taking care to provide timely against danger. He showed himself that day a good general, and did strain a point to recover the loss he had sustained in the miscarriage of Athlone. Between these wings the conflict was fierce. But at the end the English were forced to recoil, not being able to compass their aim.


'Twas at the period of this action, and about six o'clock, the main bodies of foot on both sides came to close fight, and sharp it was. The English charged, and in their advancing the Irish slew numbers from their little old ditches; the English gained them and flew in boldly among the enemies. The Irish returned the charge, and broke and pursued them with great slaughter.


Fresh bodies of English came on again and held the strife a good while in balance. Major-general Dorrington, being herein pressed, sent for the two regiments of foot, which were placed in the beginning of the day to guard the pass on the left. At the same time general Ginkel ordered down four fresh regiments more of foot to reinforce his combatants, which made the contention very sanguinary, till at last the English gave ground and the Irish advanced near the enemy's field of battle.


This repulse was no sooner given than a grand corps comes pouring down on the Irish for the third time. 'Twas now the combat seemed

 


---

p.141






more violent than before, and as if it were the last effort. After an obstinate storm, the English were constrained to retreat. The Irish followed, making use of club musket, whereby the foreigners suffered much. The regiment of guards and the whole royal brigade was particularly noted by the field to have performed uncommon execution. The Irish pursued so far that they gained the enemy's ground and maintained themselves thereon. Colonel Gordon Oneil with his regiment took some of their cannon.


At this, general Ginkel, seeing his centre wholly broken, his left wing to have had no small losses, without being able to have gained their point, that his right wing could not with any safety get over to the left of the Irish, and that the foe was on his field of battle, he became so disturbed in his thoughts that he could not well resolve what to do, unless to take his flight, of which some marks appeared immediately.


On the other side, general St. Ruth, remarking the condition of the enemy and his own success, cried out in his language with joy: ‘Le jour est à nous, mes enfants’: ‘the day is our own, my boys.’ To whom I thus address on this occasion: ‘Great general, you may well say, if God gives you life, nay, an hour of life, you will present a kingdom unto his majesty of Great Britain, as a grateful return for the honour he had done you in making you marshal-general of Ireland. If the powers above shall think fit to suffer your vital thread to be cut on this place, at least you may die with this comfort, that you have left the army entering upon possession of the realm; and if their leaders will not perform so easy a task, as to take absolute possession thereof, the fault is not yours, but theirs alone. ’ And in truth it proved so.


Amidst that confusion of general Ginkel, some of his great officers advised him for his last remedium to attempt once the sending his right wing of horse over the pass of Aughrim castle, notwithstanding the danger thereof. The general took this desperate advice and so ordered it to be executed; upon which the cavalry marched, Ruvigny's regiments being the first.


The marquis of St. Ruth, observing the enemy coming towards the


---

p.142






pass, he gave orders to the left wing of his horse, that had been idle all the day, to go and oppose him, which he knew was easily done, and therefore he continued his joy, as being sure of his point. Here we are to take notice that this long bloody contention is just *ending*; that the victory is so certainly in the hands of the Irish, that nothing can take it away but the gaining of that most perilous pass by the castle of Aughrim; that the defending of it is so easy that a regiment may perform the task. At least, four regiments of horse and four of dragoons might make the passage impossible. This being so, what a pity it is to lose a kingdom at so slight a rate as not to venture a few men! What a pity to bring thus thousands of families into slavery; to suffer religion, the true worship of Almighty God, to be suppressed; to keep, in fine, a mighty monarch in exile! What excuse can the left wing of the king's cavalry make for themselves, if they will not hinder the enemies gaining the said pass and obstruct thereby the ensuing calamities? Their bleeding country requires it, their suffering prince exacts it, and their oppressed kindred implores it and expects it. They have had all the day conspicuous examples of bravery before their eyes, their companions on the right fought like heroes, their foot in the centre threw all down before them like thunderbolts, so that there is nothing wanting to make them all an ever happy nation but the easy concurrence of the cavalry on the left, which in reason, in honour, in friendship and in loyalty cannot be denied. Are there not here some zealots, who opposed the duke of Tyrconnell, because they thought him not zealous enough for his country? Now, therefore, let them show to the world that their zeal was solid and their intention sincere. But alas! these remonstrances will prove in vain, though the great officers of that cavalry must needs have had the same thoughts more or less at that juncture.


So we will proceed and say that general St. Ruth, having sent his command to the horse to march and oppose the enemy at the pass, he himself must needs go along to see them perform their duty, that there may be no failure in the last scene of this bloody tragedy. They moved and the general followed with his guards. But as he was riding down

 


---

p.143


{topic Death of General St. Ruth}



a little hill, a cannon-ball from the other side, directed by the cannoneer amongst the troops that were going to defend the pass, missing all others, struck the marquis of St. Ruth in the head, at which he fell, and at the same time it laid the nation prostrate at his feet. A cursed ball, that carried such a measure of woe! O people of Ireland, you were not, it seems, judged by heaven worthy of those blessings which you expected by undertaking this war, that is, to *re-enthrone* your king, and in sequel to establish your religion, your property and liberty. Your sins, your sins have been the barrier to that felicity.


As soon as the body was down, one of the retinue carried it off, and brought the corpse to the town of Loughreagh, and there interred it privately. His death was immediately made known by a deserter to the enemy, who thereupon advanced in haste to the pass.


Behold this great man gone at the height of his greatness; which shows we must be always mistrustful amidst the smiles of fortune. Let us see what immediate effects produced this death in the field. We find in history that some armies in battle have despaired of victory upon the killing of their general, and so retreated, that others gained the day much the sooner upon the like disaster, because they were carried on with a violent zeal to revenge the death of their leader. But we never have read that an army overcoming all the day, and ending victoriously the combat without any considerable loss on their side, and there being no difficulty to accomplish the petty remnant of the fight, that such an army, I say, gave up the victory of their own accord at the death of their general commander. 'Tis only the Irish army, or more truly a wing of it, at Aughrim, in the province of Connaught and kingdom of Ireland, that began this precedent in the year 1691.


As soon, then, as the marquis de St. Ruth was slain, the guards withdrew from the field. Brigadier Luttrell, who was at the pass with the advanced troops, hearing of it did the like after a small resistance given to the first arrived enemies. Major-general Sheldon with the main body of the left wing followed, making their way to Loughreagh, and thence to Limerick. At the same time the Irish infantry went on thundering, and their cavalry on the right stood firm to their ground,

 


---

p.144


{topic Observations on movements at Aughrim}



being prepared at every moment to encounter bravely, as they had done several times that day; little dreaming that their horse on the left would abandon them, or that the enemy could get any way to snatch the laurels which they had reaped in the field of blood for several hours.


It would be a satisfaction to the nation to know what solid reasons these great officers have for their going off the field, of their own accord, and without any compulsion, at a time when their presence was so necessary that the safety of the realm depended thereon. They say they had this one reason for so doing, because there was no general to command them to oppose the enemy at the pass. To the annulling of this reason, we answer in several ways, thus: First, the end of their being in the army was to serve the king and country upon all occasions in general, and particularly in suppressing the present rebellion. Here was for them a fair occasion to compass that end, and the best that ever they had or ever will have, which was warrant enough for their encountering the foe at that juncture without any special command. For by their fighting on this occasion, no damage could ensue to king, country, or the army, and by not combating, the destruction of all would follow, as it proved in fact. The nicety of martial laws ceases when an inevitable ruin is at hand, unless you do the moment before obstruct it, and when therefore there is no time to get positive orders from higher powers for preventing the same. In such case there is a tacit order always supposed, which order is like to the law of self-preservation, which warrants my opposing the person that invades my life, without my recurring to the magistrate, because such delay would prove my death. Moreover, there comes under this case the law of society, whereby I may without command, and I ought, if able, to preserve the members and head thereof from any imminent danger. This sort of procedure is justified by necessity, which is above the laws politic, insomuch that the laws of war, forbidding the soldier or subordinate officer to assault the enemy without orders from the superior or supreme commander, are dormant in the case of necessity, as was evidently that of defending the pass of Aughrim castle. So we will proceed and say secondly, that the


---

p.145






great officers of the left wing of the Irish cavalry were placed by general St. Ruth on that ground in the beginning of the fight to secure that very pass, to the end that the hostile cavalry might not come over to the endangering of the king's army. This was a particular order to them to watch the enemy's motion and fly to his resistance whenever he attempted to gain the said pass. Thirdly, the general in a few minutes before his death, when he saw the enemy coming towards the pass, gave them fresh and positive orders to march and oppose him, to make the victory complete by frustrating the foe of his last endeavour, and both the king's cavalry and the general himself were actually in their march towards the place. Sure this was warrant enough for their continuing the design, whether the general were present or absent, whether dead or alive. Nay, I should think this order was binding till executed, so that those officers disobeyed the command by turning their back to the foe, and consequently they stand guilty of a breach in military discipline. Fourthly, they were absolutely certain that it was the general's will all along, that all the general officers on the right and in the centre required it, and that the whole army expected it, that the left wing should secure the pass above all things for their safety, and for making sure the day. Was not this a high commanding order? Was it not instruction enough unto them what to do in the case? Certainly it was, and so far that they cannot possibly plead ignorance, nor fear of offending higher powers, or going against the rules of martial discipline. Fifthly, they knew that if they quitted their post, their infantry would be murdered, as exposing them thereby all naked to the fierce assaults of the hostile cavalry at the nick of time, when they were weary conquering and had consumed their ammunition, and consequently lay defenceless. They also knew that if their foot was gone the day was lost, and in sequel the nation was enslaved, their own kindred and families were destroyed, and the king undone. Now, to prevent these calamities was a supreme authority unto them to go and keep the enemy beyond the pass; and for so doing their country would have blessed them, the king would have been redevable unto their prowess, rebellion and usurpation would have been ended, the end of the war would have been obtained, and heaven with blessings would have crowned them.




---

p.146


Neither could they allege for their justification an inability in stopping the foe; for the general knew the contrary. So did the enemy, who all the day, though he was sinking in his centre and on his left, yet *dared* not once for his relief attempt to traverse the causeway, till despair at the end compelled him to try that experiment at all hazards. So reason showed the easiness of the fact without control, and experience confirmed it; for as the right wing made good their ground and guarded the infantry where the enemy had some access unto them, so with more ease might the left (that was also somewhat superior) foil the enemy at a pass through which the access was exceedingly difficult. And, in verity, if the enemy had got the passage, it was expected that the cavalry on the left, now swollen with the success of the army, and inflamed with a desire of sharing in the honour and of putting an end to the happy battle and to their own calamities, would have been match enough for him, and especially reinforced (as they soon might be) with some battalions from the second line of their infantry, which had not toiled near so much as the first line had done all the day. In fine, since the king's cavalry on the left were resolved to retreat, an indispensable obligation lay on them to send warning to their foot to go off with all speed, while they themselves should cover their retreat, which they might have done without any sensible loss, especially assisted by the right wing, as a few regiments of horse brought off the right of their foot at the Boyne by a running fight for two miles.


The necessary result of this discourse is that the commanding officers of the left wing, by abandoning their station without compulsion, nay, without a stroke, were either traitors to their king and country, or, by exposing their foot to a certain murder, they showed a barbarous indifference for the safety of their friends and countrymen; or, in fine, were notorious cowards. And so let them keep their priding cavalry to stop bottles with.


But to proceed. By the time the king's horse went off the field, the enemy's whole right wing arrived at the pass, and, seeing no opposition beyond, they confidently went through, notwithstanding the fire from the castle on the right, which fire was insignificant, for it slew


---

p.147


{topic Deaths at Battle of Aughrim}



but a few in the passage. The reason of it was given, because the men had French pieces, the bore of which was small, and had English ball, which was too large. Here is a new miscarriage through heedlessness as bad as treachery. Why was not this foreseen, and the damage prevented?


As soon as the hostile cavalry was got over, they immediately enveloped the Irish foot, who were surprised at their hard fate while they were mowing the field of honour. They had no other remedy for their preservation than to retreat as fast as they could, making their way to Portumna, and so forward to Limerick. Most of the horse on their right made off likewise. Only the earl of Lucan, with some troops thereof, and the lord of Galmoy, with his regiment, did good service in covering their retreat as prosperously as so small a body could do. This and the arriving night and some morasses brought them off indifferently well. 'Twas their officers respectively that suffered most. In the same evening, late, the castle of Aughrim was taken, and the commander, colonel Bourk, with his major, eleven officers and forty soldiers, were made prisoners. Thus you have seen a victory snatched out of the hands of the victorious. What recompense the commanding officers of the Irish cavalry on the left can make to king and country for the loss of that day, we shall be able to judge when they are emperors in Europe. What punishments in the interim they deserve, we leave it to the judgment of those who are most knowing in art military.


In this long and bloody strife, both on the field of bravery and in the accidental retreat, there were slain of the Irish officers and soldiers about two thousand, and six hundred wounded. The wounded recovered soon almost all, and joined the army at Limerick within six weeks after. Amongst the slain was the great general St. Ruth, worthy of lasting memory. Next after him the noble youth, the lord Bourk, viscount of Galway, son to the potent earl of Clanrickard. He was *dispatched* by foreigners, after quarter given, as 'tis said; brigadier Connel, brigadier William Mansfield Barker, an English gentleman, early killed by a cannon ball; brigadier Henry Mac John O'Neill, colonel Charles Moor, of Kildare, with his lieutenant-colonel and major; colonel David Bourk, colonel Ulick Bourk, colonel Constantine

 


---

p.148


{topic Tyrconnell at Limerick}



MacGuire, colonel James Talbot, of Templeogue; colonel Arthur, colonel Mahony, lieutenant-colonel Morgan, an English gentleman; major Purcel, sir John Everard, of Fethard, in the county of Tipperary; colonel Felix Oneil, and dean Alexius Stafford, Wexford, an undaunted zealot, and a most pious churchman, who fell in the front of the royal regiment as he was encouraging them upon the first charge. There were made prisoners, the lord of Duleek, the lord of Slane, the lord of Boffin, son to the earl of Clanrickard; the lord of Kenmare, Major-general Dorrington, major-general John Hamilton, who died at Dublin soon after of his wounds; brigadier Tuite, colonel Walter Bourk, colonel Gordon Oneil, colonel Thomas Butler, of Kilcash; colonel O'Connel, colonel Edmund Madden, and several others, lieutenant-colonels, majors, captains and subalterns.


On the other side, of the English and foreigners there were killed officers and soldiers above five thousand, besides a great many wounded. Amongst the slain that we could learn, was major-general Holstaple, colonel Herbert, colonel Mongats, major Devenish, major Cornwall, major Fox, and major Colt.


The next day after the battle, the English buried their own and part of the Irish that lay on the ground, where general Ginkel was to fix his camp; the rest they left unburied. In this same day Ginkel sent brigadier Eppinger, with one thousand two hundred horse and dragoons, to take Portumna and Banagher, two passes on the Shannon, which yielded the fourteenth of July, on condition that the garrisons might march away with their arms and baggage.


On the thirteenth of July, in the morning, the viceroy, Tyrconnell, being at Limerick, received the sad news of the king's misfortune at Aughrim, whereby he was struck with a deep wound of sorrow, and the more because the battle was lost so unexpectedly. However, he roused his courage and kept hope alive, resolving to continue the war since he found the excellent magnanimity of the army, and that the loss of that day was not very considerable. Upon which, in the first place, he despatches away into France three expresses, one after the other, the earl of Abercorn, the lord Thomas Howard, of Norfolk, and


---

p.149


{topic Charges against Brigadier Henry Luttrell}



Mr. Doran, his own secretary, that if one or two should fail in the journey, the third might safe arrive at St. Germain's to give the king a true account of the combat at Aughrim. Secondly, he requests by those couriers a reinforcement of trained men out of France at the farthest by the next spring, and in the interim provisions and ammunition for the army; for he did not doubt to preserve Limerick, though he would fain keep off a siege for the rest of the campaign, choosing at the present to stand upon his defence, rather than give another battle, which yet he might do by the help of an advantageous ground, being still superior in foot. Thirdly, he goes out of Limerick on the fourth morning after the battle to receive the cavalry six miles off the town, which he cantoned near Limerick, in the county of Clare, while he was expecting the foot to come in, and then he will enter upon a consultation what is best to be done in this straitness of time.


Within a few days after, the duke of Tyrconnell got brigadier Henry Luttrell to be apprehended, and brought to a trial before a court-martial for corresponding with the enemy; for a letter directed to him by an officer in the English army was intercepted in the trumpeter's hand, who was sent to Limerick, to know if the Irish had made such and such persons prisoners in the day of Aughrim. The letter did import that general Ginkel had full powers from the prince of Orange to give ample conditions to the confederate Catholics if they would make peace. Against this, the prisoner, being on his trial, made defence that the author of that letter and he were in discourse on a privileged day of some late cessation, wherein the question was put, why would not the Irish come to a treaty rather than to continue war with so much misery? and that the prisoner answered to this sense, that such a thing might well be if general Ginkel had a sufficient power. It was hereupon that letter was sent for information. The arguments for and against being ended, the majority of the court gave judgment that the prisoner did not deserve death. Yet the viceroy, who *sat* president that day and voted against the prisoner, would not set him at liberty, but confined him in the castle, where he lay till the peace of Limerick was made. However, this gentleman, in some time after the war was ended, did


---

p.150


{topic James II. and Louis XIV.}



receive a reward from the prince of Orange for services done, and got exemptions from the parliament of Ireland, in penal laws newly made against the Roman Catholics, but whether these services were performed before the peace of Limerick or after, some have called into question, and therefore I will leave it undecided.


While these things were *happening*, the three expresses that were sent for France went on in their voyage; but one of them, the earl of Abercorn, met a Dutch man-of-war near Brest, by whom the ship was taken, and the earl killed in a fight, after escaping death in the bloody field of Aughrim, where he gallantly comported himself with his regiment on the right. He was a person of great bravery, zealous for his country, and most loyal to his prince. He was of the noble family of Hamilton in Scotland, wherein he was earl of Abercorn; and in Ireland, his native soil, baron of Strabane. The like fate the Lord Thomas Howard did meet with, whose son is now duke of Norfolk, a Catholic. The third envoy arrived safe at St. Germain's, where he delivered his accounts of Ireland. The news touched his majesty very sensibly, seeing his affairs grow worse and worse every day; against which the best remedy he had was his usual resignation to the will of God. At the same time he took some comfort at the consideration of the courageous behaviour of his loyal people, and fell into consent with Tyrconnell that matters might be retrieved with some small assistance from France. The king made the whole story known unto the Gallick monarch, who heard it with sufficient sorrow for his royal friend's sake, and yet was pleased that the courage of the Irish did answer his expectation. But his most Christian majesty was not in a condition at the present to send any succours of men to the duke of Tyrconnell, though against the next campaign he might be able to afford them. In the meantime he could supply the Irish army with provisions, ammunition, arms and other necessaries of war; and actually did grant them, and ordered them with all convenient speed to be transported from Brest to Limerick, of which beneath.


General Ginkel, having refreshed his army at Aughrim, decamped on the sixteenth of July, and marched towards Galway, in order to

 


---

p.151


{topic Baldarg O'Donnell}



besiege it, bringing along with him only his field pieces, having left his heavy cannon at Athlone. It seems by this that he presumed on his good fortune that Galway would make little resistance. This town is maritime, and chief of the province of Connaught. It is pretty strong by situation, but might have been made a noble fortress with an indifferent expense, which had been neglected during the war, as other works of moment were. The houses within are built like castles for strength, so that a smart resistance may be given to the enemy even after entering the town; the governor whereof was at that time the lord Dillon, as above said, and to his assistance lieutenant-general d'Usson entered.


On the abovesaid sixteenth day of July, general Ginkel with his army came to Loughreagh, on the seventeenth to Athenree, within eight miles to Galway. On the eighteenth Galway was invested in which there were seven regiments of foot, not full nor well armed. Baldarg O'Donnell was expected there with a thousand men of reinforcement; but he came not, and afterwards made conditions for himself, and took the prince of Orange's side at the end of the war. This gentleman was descended of the family of the old earl of Tyrconnell in Ulster, who was forced to fly into Spain upon a false impeachment in the reign of king James the first, where he was owned earl of Tyrconnell, and his heirs after him. This present O'Donnell was the acknowledged earl at this time, who hearing that his nation was in war for king James the second, came into the kingdom a little after the action at the Boyne, in order to assist his countrymen, though he was suspected by some as not true to the cause. He bore the nickname of Baldarg, or a red place, or a red spot, upon the account that some of the family foolishly believed that the true earl of Tyrconnell, marked on his body with such a spot, would come from abroad into Ireland and do there great matters for his country; and they applied their ridiculous belief impertinently to this man.


On the nineteenth of July, general Ginkel planted a battery against a little new fort which the Irish had made near the town. He took it that same day. Immediately after he raised his batteries against the

 


---

p.152


{topic Irish forces at Limerick}



town. On the twenty-first, the governor, having considered the great declension of the Irish affairs, thought it fit not to hold out the place any longer, and so the same day he called for a parley. The treaty was concluded on the twenty-fourth of July, whereby the garrison got their own demands and the town also for enjoying their estates, the exercise of their religion, and other rights and privileges that are due to free-born subjects. On the twenty-sixth, the marquis d'Usson went to Limerick, so did the lord Dillon, with the garrison, being about two thousand three hundred men, and with six pieces of cannon.


The duke of Tyrconnell had great expectations that Galway would make a long resistance, which would be to his advantage; for thereby he hoped that the campaign would be so far spent, that the besieging of Limerick could not be undertaken in that season. But the town being so speedily lost, gave him a deep wound of sorrow, because it abbreviated too much of his time, wherein he expected succours out of France or a favourable answer to his request as aforesaid. For now the city of Limerick was the only fortress of note he had in possession, which his excellency knew the enemy would besiege immediately. How to keep off this beleaguer, the duke was at a stand for a while; until at last he resolved upon this following stratagem to gain a little time.


The whole Irish army, though scattered in the day of Aughrim fight, yet re-assembled within twelve days, hard by Limerick, in the county of Clare. And those officers thereof who had been violent factioneers against the duke of Tyrconnell do now own their fault, and acknowledge that his grace was all along in the right, though 'twas a submission made too late. However, the lord lieutenant ordered the army to pass from the other side of the river Shannon, through Limerick, and encamp close to the town on the east side. When this was done he issued a proclamation, commanding all men in the Irish quarters from the age of sixteen to sixty to join the army, to fight immediately the enemy; in order to which he made some other preparations. The whole city of Limerick and the army believed that there would be soon a second battle; and they conceived much alacrity thereat, especially 


---

p.153


{topic Observations on Position of the Irish}



after taking notice of an old pretended prophecy, which said that there would be a fight in the place (called Singland) where the army then was fixed, between the Irish and the English, and that the Irish would so overcome them, that the English should be for ever disabled to make head against the Irish.


But the viceroy thought it not fit to give battle without a reinforcement of trained foot to supply the want of horse, though I should side with that opinion which would assent that the Irish host, now resolute to obstinacy ('tis this gives always the day), together with the volunteers and their zeal, and the advantageous situation of the place, was sufficient to get the victory, considering what numbers of the enemies were lost at Aughrim; and what were left to garrison Galway, Athlone and to take Sligo; and the apprehension, that must needs have been struck into the hostile infantry by the remembrance of Aughrim field; it being found often true that superior numbers are vanquished by the help of other advantages. There are many examples, ancient and modern, of this kind; but these few shall here suffice from antiquity drawn: as is that of Alexander the great his army overcoming Darius with six times more forces; Hannibal with lesser multitudes overthrowing the Roman generals, Paulus Aemilius and Terentius Varro; Julius Caesar, with almost half the number, putting the great Pompey to the rout in the field of Pharsalia, where Pompey, hitherto esteemed the greater captain (for none before had conquered so many nations for Rome), managed very ill the battle that day, especially in this point, that he hindered the young, fiery nobility of Rome to give the charge, which, had they done, they would have crushed Caesar's army to morsels, though made up of veterans, their most violent assault with such numbers not being supportable; which crafty Caesar knowing, commanded his army to begin the fight with charging boldly those youthful Hectors, to dash their first swelling courage.


General de Ginkel having taken Galway and garrisoned it, *decamps* from thence on the twenty-eighth of July, with a resolution to lay siege to Limerick in that very season, as being violently desirous to end the war by the present campaign, to please his master, the prince of Orange,


---

p.154


{topic Siege of Limerick, 1691}



who was impatient at the delay. But Ginkel, upon his decamping, received intelligence that the duke of Tyrconnell was ready to present him the second battle at the walls of Limerick on the county of Limerick's side. This made him resolve to answer the challenge, whereupon he marched (for expedition's sake) straight to that part of the river Shannon where Banagher bridge lies, bringing only with him his light pieces of cannon, not having use of his heavy artillery in a field battle. At this place he passed the Shannon into the province of Leinster with his whole army on the third day of August, and came that night to the town of Birr, in the King's county, distant thirty miles from Limerick. From thence he marched to Nenagh, in the county of Tipperary, and arrived there on the sixth. Brigadier Anthony Carrol, governor of this open town and of the castle thereof, quitted it at the approach of the English army, having first set fire to the houses, which was soon after extinguished.


As soon as Tyrconnell got an account that the Protestant army was approaching to Limerick, he gave orders that the Irish host should repass the town and encamp on the other side of the river in the county of Clare, near unto the city. At this time his grace received an answer out of France to his message he had sent immediately after Aughrim fight to the king at St. Germain's. In which answer he finds that a reinforcement cannot be spared in this season, but that a fleet with provisions and all necessaries of war would arrive soon at Limerick.


The baron de Ginkel, being come within a few miles to Limerick, understood that the Irish army repassed the town to the county of Clare, and that all signs of a battle vanished. Whereupon he fixes his camp at Carrickinlish, four miles from Limerick, and there is resolved to remain till his gross cannon comes to him from Athlone, for which he had sent, in order to besiege the said Limerick.


The duke of Tyrconnell, understanding that Ginkel was resolved to lay siege unto the town, though it was late in the season, considering the climate of Ireland, made preparations for a defence; upon which he brings all the infantry of the army into the city, and leaves his horse and dragoons to encamp hard by on the county of Clare side. He settles

 


---

p.155


{topic Death of the Duke of Tyrconnell}



his batteries, he makes some new brigadiers and other officers, and *finishes* several other matters.


And now we come to the last scene of the tragedy, wherein the ruin of Ireland is effected. The viceroy, Tyrconnell, after putting everything in good order for a vigorous defence, was, on a Monday, the tenth of August, invited to dinner by Monsieur d'Usson, the first lieutenant-general. He and the company were very merry; but at night, upon his preparing to go to bed, he found himself indisposed. The next day his malady increased. Remedies were applied, yet to no effect. On the third day, observing his weakness to be great, he settled his worldly affairs, and took care for his conscience. He appointed (by virtue of a power left him in his commission) three persons as lords justices to govern the king's people and manage his royal affairs, who were the lord chancellor, Alexander Fitton, baron of Gosworth; sir Richard Nagle, and Mr. Plowden, an English gentleman. On the following day his excellency grew speechless, and on Friday, the fourteenth, about one of the clock, afternoon, being the fifth day of his sickness, he expired, leaving issue one daughter, the lady Charlotte Talbot. His dukedom was extinct in him, but his earldom of Tyrconnell came to his brother's son, William Talbot, whose son, the lord of Baltinglas, married afterwards, in the year 1702, the duke's daughter.


Thus this great man fell, who in his fall pulled down a mighty edifice, videlicet, a considerable Catholic nation, for there was no other subject left able to support the national cause. This noble personage, by name Richard Talbot, was a younger son of the family of Cartown, in the county of Kildare, whose father was created baronet by king James the first. Young Richard proved to be cornet of horse in the beginning of the Irish wars against Oliver Cromwell and the rebels of England in the year 1649. When that war in 1653 was ended, he went into Spain with the Irish forces that were thither transported, where he became colonel. From thence he came to Flanders upon king Charles the second's service, then in that country an exile. At Brussels he had the happiness to be known to the duke of York, who, approving of his ways, took him into his family, where being a while, colonel Talbot proved so happy as to become favourite to his royal highness.




---

p.156


{topic Notice of Tyrconnell and his Career}
When king Charles the second was restored, several Irish gentlemen applied themselves to the said colonel, that by his means, as being a minion to the king's brother, they might obtain the king's letter to the government of Ireland, in order to repossess themselves of their lands of inheritance, out of which they had been ejected by Cromwell and his fellow rebels. Talbot procured unto them the desired letters, and thereby some of the addressors were restored to their patrimonies. In consideration of which service, the persons so restored did bestow by an antecedent agreement part of the acquired lands on colonel Talbot, who, having money, laid it out on the purchase of some other lands, so that he had now by his own acquisition a plentiful estate.


After the duke of York ascended the throne, his majesty made colonel Talbot earl of Tyrconnell, and lieutenant-general of the Irish army. In the beginning of the third year of the king's reign, the earl of Tyrconnell was created lord deputy of Ireland and captain-general of the army. In which station he showed himself a lover of his country in general, and of his kindred in particular, which was a behaviour contrary to that of the late duke of Ormonde, who proved an enemy to his country and most unkind to his kindred. This is not to be much admired, considering the malignity which heretics have for the orthodox universally. So these must not expect as good effects from a Protestant compatriot and relation as from one of their own religion. There is a great difference between tree and tree.


About the time the king was banished out of England (which was at the end of his fourth year), the lord deputy Tyrconnell with a mighty zeal raised an army in Ireland in order to restore his royal master. The nobility and gentry of the kingdom concurred thereunto most ardently and with veneration towards the person of their general governor, for his showing them so brave an example and so singular affection to his native soil. In four months after, and in the fifth year of his majesty's reign, 1689, when the king arrived at Dublin out of France, he created the earl of Tyrconnell, duke of Tyrconnell, as above said.


But when the king, after the loss at the Boyne, thought fit to fly back into France, and when thereat the Irish greatness became dejected,


---

p.157


{topic Siege of Limerick, 1691}



the grandeur of Tyrconnell was undervalued (as we demonstrated above) by some of those gentlemen who before had respected him as the pillar of the nation and even such the parliament at Dublin in the precedent summer acknowledged him, as before mentioned. This comportment of the said gentlemen *does* indicate that constancy to our devoirs is not common, and at the same time it shows in them an ingratitude to so national a man. Yet some there are who care not a rush whether their country in general flourish, so they be well themselves. Such we call good for nothing, though they were princes in greatness, because they are only indulgent to themselves. And it would prove the greatest happiness in the world to that country if such self-lovers were weeded out of the land, as we cast out of a garden noxious weeds; for what else should be done with them, since they infringe the tacit oath of association which they made to nature at their first coming into the world, viz., that they would with all their power jointly defend the *birth-rights* of one and other and their common parent soil, which is an obligation that all nations for these five thousand years past have thought incumbent on them.


As soon as the duke of Tyrconnell was dead (some said of poison, and there was ground for it), the three fore-mentioned lords justices took upon them the government, who, on the third day of their regence, and the sixteenth of the month, being Sunday, buried at night the body of the late duke in the cathedral church of Limerick, not with that pomp his merits exacted, but with that decency which the present state of affairs admitted.


General de Ginkel, in a few days after Tyrconnell's death, having at last received his weighty artillery, decamps from *Carrickinlish* and marches to Limerick, which he invests on the twenty-fifth of August. At that juncture the sieur Donep, colonel of Danish horse, was killed by a cannon ball from the town. Here we will stop a while to make our observations upon the nature of this siege that is now undertaken. First, how comes it that general Ginkel dares assume the task, seeing the garrison is as numerous as his infantry, and the very men that beat his foot lately in the field of Aughrim, and sure can more easily overcome

 


---

p.158


{topic Siege of Limerick, 1691}



within the breach of a town? It appears to be a mock siege; though that Ginkel gained the town in earnest, and with it a kingdom, he may thank the death of Tyrconnell for it, whose life would have preserved the town and country, as he had laid his measures with France. It may be general Ginkel designed to ride his cavalry into the breach when made. Otherwise how could he propose to himself to take Limerick with so small an army, not being above twenty-two thousand, horse and all, when the prince of Orange the last year, being much superior, could not take it against a garrison that was hardly the moiety of the present? It looks as if the bargain had been already made with Ginkel to give him up the town; for most certainly the garrison was put to no necessity of surrendering, as we shall see more clearly, nor could they be by such weak besieging forces. However, we will go on with our narrative and speak of the matter more beneath. General Ginkel having finished his lines before the town, he plants his grand battery of cannon on the south side of the city, and that of his mortars on the east, at the place called Ireton's fort. The first thing the besiegers did was to try if with that great battery of cannon they could destroy Thoumond Bridge, to cut off the communication of the garrison with the county of Clare, where their cavalry was, and from whence they received their refreshments. But the besiegers could not compass their aim after eight days' trial, in which space they cast into the town plenty of bombs night and day. The houses were much damnified by them, though but few men were killed.


The general seeing no success of moment hitherto, and not daring *to attempt* a breach on that side of the wall where the breach was made the last year by the prince of Orange —because since that time outward works were raised for its defence, which to gain would cost a world of men, and take up too much time for that late season —he resolved to remove his main battery to the north side of the town, or to that part of the city which is called the English town, where he understood the wall to be very weak, as being thin and without a rampart, and void of outward fortifications. The battery being raised did furiously play until it made a breach of forty yards wide. In opposition to this, the


---

p.159






besieged made a strong intrenchment within, from side to side of the said breach, insomuch that they were resolved to stand the attack without fear of being overpowered.


The breach being made, general Ginkel prepares for an attack. Amongst other things he gets ready his floating bridges, in order to pass a branch of the Shannon which ran before the said breach. But before attempting this assault, he thought it necessary to dismount a small battery which the besieged had without the wall on his left flank, as he mounted the breach. To effect this he endeavoured it for three or four days, but could not prevail; upon which he ceased for two or three days from all kind of firing, so that there was a general silence. In the interim we are to tell that few lost their lives on either side, the besiegers not undertaking any matter of danger, nor the besieged making any sallies worth the remark. Of the last there was killed a hopeful young gentleman, a nephew of monsieur La Tour, the governor, by a bomb, being at that time in the same chamber with his uncle. In like manner a gentlewoman was slain before the door of her lodging, after coming *downstairs* to shun the bomb, which appeared to fall on the house, but fell in the middle of the street and there *burst*, a splinter of which struck the lady as aforesaid. A few more of no note received their death in that way. Upon a small sally or two there were lost captain Walter Hore, of Harperstown, in the county of Wexford, and two or three other inferior officers, with a few common soldiers. Of the besiegers, the lord Loftus of Lisburn was killed by a cannon ball on the fifteenth of September, as he was coming out of his tent, which was placed in the trenches. This nobleman was a native of the county of Dublin, in Ireland, and proprietor of Rathfarnham, near the said Dublin, and of a great estate thereunto appertaining, but he was a remarkable zealot for the prince of Orange. His friends got the bullet that had killed him to be gilded, and to be hung over his tomb in the cathedral church of Dublin dedicated to St. Patrick, the apostle of that kingdom, and this to stand a monument of his good affection and fidelity to that usurper. A folly in grain! Besides that lord there was a small number of others slain on the side of the besiegers. During


---

p.160


{topic Siege of Limerick, 1691}



which time general de Ginkel sent brigadier Levison with a party of horse and dragoons to the county of Kerry, which bounds with that of Limerick, in order to subdue the lord Fitzwilliams, viscount of Merrion, and the lord Bourk, baron of Brittas, who commanded parties of new raised horse; as also the lord Butler, baron of Dunboyne, who had a regiment of dragoons in that country. Levison received two reinforcements one after another; the first was of three hundred horse and dragoons, the second of two regiments of infantry. There happened no action of moment between those contrary sides, and that through the fault of the Irish commanders, who joined not their forces into one body, which if they had done, with a moderate reinforcement of the inhabitants, and had taken the advantages of ground which that country afforded, they would have hindered the enemies to come into the plain tracts of Kerry. This much Levison observed, and therefore he thought it necessary to be considerably reinforced before he would venture to go far into the country. However, it happened about the twentieth of September that some troops of Dunboyne's dragoons were posted at a pass, where they were to wait a little while for a reinforcement of *viscount* Merrion's horse, but in the interim brigadier Levison appeared with his body. The Irish dragoons, seeing themselves much inferior to the enemy, quitted their post. A little while after, some troops of the lord Fitzwilliams' horse came to the place, and though they saw the pass abandoned by their own, they stood for a time upon the defence, but having no infantry to send into the morass that intervened, and being galled by Levison's dragoons on foot, who were come into the moor, they were forced to retire, which gave the opportunity to the English of carrying away a great prey of cattle.


To return to Limerick: while it was besieged, as aforesaid, the Irish had a guard of dragoons, consisting of four regiments and of some foot, at a deep ford of the Shannon, a mile above the town, to hinder the enemy from passing over to the county of Clare, and thereby from cutting off the refreshments of the country, which came from thence into the city, as also to bar the foe from coming between the Irish horse encamped at Anaghbeg, about two miles from Limerick and the garrison.




---

p.161


{topic Siege of Limerick, 1691}
General Ginkel, after the long silence of his artillery and after his mature consideration of the danger in attempting an attack on the abovesaid breach, resolved to quit that enterprise and embrace another, which was thus. He is fixed to cross the river Shannon in order to *begird* the town on the other side of the river, in hopes to distress soon the besieged so much as to force them to a speedy surrender; for the general was in haste to go into winter quarters, by reason that his army was suffering, and to finish the war by a happy issue of this siege. Upon this resolution, he gives orders on the sixteenth of September, at ten o'clock in the night, to carry floats and pontoons to the above-described ford, where he intends to pass the river. He commands six hundred workmen to lay the bridge in that place, and a hundred grenadiers to cover them while those men are working. The grenadiers were brought in boats into an island, where they remained undiscovered till it was almost morning; at which time the English were discerned by an Irish dragoon on the contrary bank, who was patrolling. He gave notice of it to brigadier Clifford, who commanded the Irish guards that night; but the brigadier seemed not to give credit to any such account, as not fearing that the enemy would dare undertake so perilous a passage. However, the alarm spreading, one of the colonels of the dragoons, by name Dudley Colclough, of Moyhurry, in the county of Wexford, brought down his regiment to the brigadier's tent in such haste, as some of his men did not stay to saddle their horses. The colonel desired ammunition and orders to obstruct the passage of the enemy. But the brigadier, before colonel Colclough and other officers, neglected so long by his discourses, which no man of sense understood to be pertinent, to perform his charge, that the above-mentioned bridge was finished (which happened about seven of the clock in the morning), and a great body of the English came over. The first that passed was a regiment of dragoons called the royal regiment, then grenadiers and fusiliers, who were supported by four battalions of foot and several squadrons of horse. At which the Irish guards, seeing too plainly their enemies at their nose and themselves too weak to beat them back over the said river, took a sudden resolution to save themselves


---

p.162


{topic Observations on defence of Limerick, 1691}



by flight, which they hardly effected, by reason that the greatest part of their horses were at grass at some distance from the ford, so that a few of their men could not timely arrive at their horses, and therefore were made prisoners. Several saddles and tents were left to the enemy. The Irish cavalry, under the command of their general, Dominick Sheldon (which was encamped a mile off towards Killaloe), hearing of this misfortune, decamped suddenly and marched towards the town of Ennis, in the county of Clare, by which the horse lost communication with Limerick. At the same time the Irish lords justices, or regents and the ladies, and such gentlemen as were not concerned in the army (who had a camp of their own in the county of Clare within a quarter of a mile to the garrison), were forced to run into the town with all speed, which caused a crowd and an inconveniency both to themselves and to the soldiery.


Here rises a question, whether the Irish cavalry should have come down and fought the enemy that was come over? I side with that opinion which says they should have done it; and we give for reason, because they might have come safe and timely enough, and were able, especially in conjunction with their own dragoons, to drive back the foes and to gather as many of them as could pass the bridge by the time that the Irish horse were arrived on the place. Nay, in all probability, the English forces, which had trajected the river, would not have stood to a fight, seeing the hostile cavalry and dragoonry coming all down upon them, for they could not be sufficiently supported from the other side, by reason that the bridge admitted not many in abreast. So that one regiment of Irish dragoons with three companies of firelocks would have stopped their passage on the said bridge, where they might have made a barricade of the enemies to their own people behind. This was a brave occasion for the Irish cavalry to show themselves, for from the beginning of the war to that day they were not brought to a trial, as to the whole body of them. And what should they be any more reserved for? Or for what were they at first raised? Here they would make recompense for all their past inaction, though the fault *had* not been in the men, but in the great officers. For by this


---

p.163






repulsing of the enemy to his own side of the river, the siege would be raised for certain within a day or two, considering what we have said above concerning general Ginkel's not daring to mount the breach he had made in the wall of the English town. But you see by this act of suffering the enemy to cross the Shannon, that the misfortune of the Irish is continued, who lose ground upon every important occasion, not by the bare prowess of the foe (though brave he is), but rather by the neglect, or ignorance or treachery of particular commanders, as it will appear to a thorough considerer. But what brigadier Clifford can say for himself by way of vindication, I do not understand. I suppose his comfort is that he believes he will never be brought to an account of this behaviour by the king.


Here springs another *query*: what should the Irish horse and dragoons have done when they lost the communication of their foot that was within Limerick? Some say that they should have passed the Shannon into Ulster, or rather into the province of Leinster at some convenient place for a retreat into Connaught, if need were. The first report of their march that way would oblige the English horse and dragoons to rise from the siege and to hasten into Leinster to prevent the destruction of that country, and especially of Dublin, from whence the besieging army had all their provisions. Their infantry would not dare stay behind, as fearing their victuals might be cut off and that they might be enveloped by the numerous garrison, by the loyal people of the county of Clare, who would rouse themselves at such a juncture, and by the troops and militia of the county of Kerry, which doubtless upon this opportunity would march in great numbers towards Limerick, as being particularly provoked by the loss of their cattle, which brigadier Levison took from them about this time. I have heard it said that this very enterprise was the design of the Irish cavalry, but the execution was prevented by hearing, a few days after, while they lay encamped near Ennis, that a cessation was made in order to conclude a peace. Yet, others do tell us that the Irish cavalry might with good reason have remained in the county of Galway, upon confidence that their foot would effectually hold out the siege at this time, since a


---

p.164


{topic Capitulation at Sligo, 1691}



smaller garrison held the town the last year against a potenter host with the presence of their horse, though that host might have *begirded* the town on both sides of the river without resistance, so that the Irish horse had no solid cause to fear at present the surrender of Limerick. And this is the truth, to which I adhere against the imaginations of the timorous and the ignorant, and against the sentiment of the treacherous.


But to go on: the English, who had passed the ford and their companions, who remained beyond, observing that the country before them was clear of the enemy, fixed their camps on both sides of the river, and spent four days more in bettering of their bridge, in removing it nearer to the town, in bringing cannon to the banks, and in planting a battery to secure the bridge. At the end of this business, videlicet, on the twenty-first of September, an account was brought to general Ginkel that the English forces had taken the town of Sligo, in the province of Connaught, from the Irish, which was after this manner. On the tenth of the present September *1691*, colonel Michelbourne marched with a detachment of his regiment, with five hundred of the militia of Ulster, with two troops of dragoons of Ginkel's army and with six field-pieces. He encamped at Drumcliefe, about three miles from the said Sligo, of which he sent an account to the old earl of Granard by a party of horse commanded by captain Vaughan. On the eleventh, Michelbourne came within half a mile to the town. On the twelfth, he drew out his men to attack a party of Irish within some slight works, which were at the entrance into the town. After a short dispute the defendants quitted the works and entered into the great fort, having killed an ensign and a few private men of the enemy. On the twelfth the earl of Granard arrived with the troops under his command before the place, who immediately ordered batteries to be raised against the fort. Sir Thadey O'Regan, governor thereof, being persuaded that the enemy had great cannon, and judging it of no advantage unto Limerick, actually besieged, to hold out the fort for a few days, called for a capitulation, which was granted and perfected. The conditions were honourable, upon which the fort was surrendered on the fifteenth of September, and sir Thadey,

 


---

p.165


{topic Siege of Limerick, 1691}



with six hundred men, marched to Limerick, where he arrived at the end of the siege.


Now Limerick only remains in the possession of the loyalists, but that possession will not last long, because they are willing to part with it, and not otherwise, as you may judge by the following discourse, wherein you will find that general Ginkel gave them all the advantage desirable by dividing his little army on both sides of the river, and at the same time he exposed his troops to be cut off, if the garrison and their cavalry abroad would be resolute, so that instead of facilitating the reduction of the place by investing it on both sides with so weak a power, the enemy rendered his attempt wholly impracticable. But to go on: the above-mentioned bridge being perfectly finished and commodiously placed on the river, general Ginkel passed the same into the county of Clare, on the twenty-second of September, with the duke of Wirtemberg and lieutenant-general Scravemoer, bringing with him ten regiments of foot, fourteen small pieces of cannon and all the horse and dragoons of the army, except colonel Coy's regiment of horse, and fifty dragoons out of every regiment, he having left behind major-general Mackay and major-general Talmash, to command the rest of his army for the security of his camp on the county of Limerick side.


In the afternoon of the same day, as the said trajected forces approached to the city, the governor of Limerick sent a small detachment of foot to the number of two hundred men, under colonel Stapelton, deputy-governor, to skirmish with the advanced foot of the enemy, by the help of some little ditches that were near the place. This was a foolish management, for what end could it have? It was not able to hinder so great forces to approach the town, and at the same time it did expose those few Irish to the slaughter. Why rather were not some pieces of cannon raised on the other side of the bridge, or planted on the church-yard, contiguous to Thomond gate, to scour the avenues on the county of Clare side, there being the time of four days for the doing of it? This would prove a positive advantage, as the considerer finds. Nothing of which was done, as if there were no enemy approaching; so that the English forces, especially the foot, could march close to


---

p.166






the wall of that side without danger, for there was no artillery set up on that part of the town but what was on the castle, which was mounted too high for doing harm, except to such as appeared on high ground at a considerable distance. Nor any outward works were made, wherein musketry (being well covered) might keep off for a while the approach of the foe to the slaughtering of a great number, and from whence when overpowered they might safely retreat into the town.


But to proceed: colonel Stapelton, at the approach of the hostile bands, engaged them, and after fighting a while he was overcharged with numbers, which made him retire. Some of his men got into the gate that was on Thomond bridge. He himself, with the rear, was also hastening thither, but a party pursued him so close, that a French town-major, who commanded the gate, pretending a fear that the enemies would pour in with the Irish, shut the said gate against friends and foes, by which it happened that colonel Stapelton, a worthy gentleman, major Purcell, and some other inferior officers, with about eighty private soldiers, were killed on the bridge. Here again was a ridiculous fear; for had two or three thousand of the enemies entered, they would be soon overcome, though there appeared near the gate not above two or three hundred, who lodged themselves that night on the further bank of the river (which *washed* the town-wall) in sandpits and amongst ruinous walls of houses.


Here we must set the *query*: whether this division of the hostile army (that consisted but of twenty thousand men) on each side of the town and of the great river, from whence they could not relieve one another in less time than an hour, did not prove a vast advantage to the Irish garrison, for the garrison, being fourteen thousand foot and two hundred horse (besides many volunteers), was double the number of the enemies, who were left to guard their camp on the county of Limerick side, where their cavalry was not above three hundred horse and five hundred dragoons, and therefore could not the besieged take a fair opportunity to surprise them, or fight them upon a square and gain the victory? Moreover, might not the Irish cavalry in night pass the Shannon at Killaloe, six miles above Limerick, or farther off, and

 


---

p.167






surprise the enemy's bridge at the abovesaid ford, and so cut off the communication between the two camps of general Ginkel? In which case, the hostile camp on Limerick side lay at the discretion of the Irish. All these enterprises were compassable enough. At least an attempt made by the Irish cavalry to pass the Shannon, would oblige the English horse to repass it to cover their infantry on the other side, and to secure their provisions that were brought to them that way. But alas! by this time, zeal was languishing in the Irish patriots. The year before, the earl of Lucan attempted and achieved a noble feat, of which we spoke above. So in the first siege of Limerick, the chief commanders of the garrison behaved themselves with a deal of bravery, and thereby drove the proud foe from their walls. In the beginning of this present siege, one of the Irish brigadiers, a very experienced officer of foreign education, named Patrick Plunkett, would show himself for the good of his country, and engage, by snatching at an opportunity, with a thousand firelocks and five hundred horse, to bring into the town the grand battery of the besiegers that was then on the south side, by which the siege would be raised, the enemy not having time enough to procure other battering pieces, by reason that the season was spent. But the brigadier *dared* not propose the project to the governor and general officers, because he believed that they would look upon it as impracticable, especially being offered by a person whose skill in military affairs they were not well acquainted with.


To advance in our history: the town being now *begirded* on both sides, the garrison beat a parley on the twenty-fourth of September, to which the enemy complied, and so a cessation was made. The news thereof being brought to the Irish cavalry encamped about Ennis, several persons came from thence the next day to the English camp, as the *Catholic* primate of Ireland, the archbishop of Cashel, the earl of Westmeath, the lord Dillon, the lord Galmoy, major-general Sheldon, colonel Purcell, of Loughmoe, and some others, who, having dined with general Ginkel, went thence into Limerick. On the next morning, being the twenty-sixth, the earl of Lucan, brigadier Wauchop and two brigadiers more, went from the town to the English camp, to lay the


---

p.168


{topic Discourse on Treaty of Limerick}



foundation of a treaty, which being done, hostages were exchanged in the afternoon. Those of the besieged were the earl of Westmeath, the lord Iveagh; the lord Lowth, and the lord Trimleston; and those of the besiegers were the lord Cutts, sir David Collier, colonel Tiffin, and colonel Piper.


We are now upon perclosing the war of Ireland, that unfortunate war to the Irish, unfortunate through the fault of some particular persons, though the generality bravely demeaned themselves, or were prepared to do it if brought to a trial. But ere we actually end it, we think fit to form a discourse upon the subject of this treaty for a surrender.


In the first place we put the question, how comes it that the French and Irish commanders within Limerick are so ready to deliver up the town and make peace with their enemies? The answer is: because they cannot hold longer the place, as being invested on both sides, and by reason that they have lost communication with their horse.


We reply first: that this case did not oblige in the last campaign an inferior garrison to yield the town, at that time much weaker, to a potenter army under the prince of Orange; for this prince could have better surrounded the town, as having much more numerous forces, and as finding no opposition to pass the Shannon, by reason that the river was then fordable in several places through the dryness of that summer, and the Irish had no guards on the fords. And de facto a party of the besieging army trajected to the other side, and again repassed. But the truth of it is, the prince of Orange did not judge the investing of Limerick on Thomond side to hasten the surrender of the town. And he is in the right of it, which is our second reply; for of this opinion all precedent generals have been, who had besieged that city, and namely, general Ireton in the days of Cromwell. And they give for reason, because there is no passing into the town from the county of Clare side (supposing a breach to be made in the wall), but through the river or over the bridge. The river on each hand of the bridge is generally not fordable; and the bridge is easily broken and easily defended, because it is narrow, not capable of more than six men

 


---

p.169






in abreast, and is above eighty yards long, on which a discharge of a few firelocks would make a barricade of the bodies of the assailants. Now, in this case what could general Ginkel do for the forcing the garrison to a surrender, if they were resolved to defend themselves, as they were in the precedent summer? He had made, some days before this, a spacious breach in the north wall, and yet he *dared* not once make an attempt to mount it, for the reasons we spoke of above. And here he will find stronger reasons against his ascending any new breach that he can make; for first, when will Ginkel be able to compass it? He must spend three days in bringing his battering-pieces from one side of the river to the other, and in planting of them. He will consume six days more in forming a breach and in preparing to enter it. Here rises the *query*: whether that general would remain so long at an uncertainty of gaining the town? because his army suffered, before he crossed the river, through scarcity of provisions, as it was owned afterwards by some of them, and they expected no supply till they had gone into winter-quarters. Prudence tells us that he should not have done it. Secondly, where will general de Ginkel make a breach in the west wall? It is in vain to do it on either side of Thomond gate, because in that case his men must pass through the river, which was there not fordable. The only place he had to make his breach upon was the said gate, and his only passage into that breach was on the narrow bridge. This project is not compassable, as you shall see; for if he breaks down the wall above and adjoining each side of the gate, he makes a notable barrier to his ingress. If he can carry cleanly away the gate itself, then the entrance is too narrow for his purpose, as not capable of above four men in rank. Neither will we allow him the bridge for his pass; for besides the stoppage of the drawbridge thereon, the garrison could have broken down two or three arches before Ginkel could raise his battery. And if he were so fortunate as to have the bridge entire, yet he had the like misfortune here on his left flank in entering the town upon the said bridge, as he had at the breach of the northern wall. For the garrison had a battery in the island of Limerick, near unto the bridge, which they could immediately


---

p.170






turn against it, though at first raised against the ford, and was not dismountable in that posture, by reason of its lowness. And lastly, if Ginkel's men should enter the gate, what was the sequel thereof? They were immediately impounded; for in the space of a few hours the besieged could have cast up an entrenchment on the right of the ingressors from the king's castle across High-street, and on the left from the churchyard, athwart the same street. The walls of the houses, though demolished by the enemy's cannon, were barricade enough in their front, so that this was a worse pinfold than that of the last summer erected before the breach the prince of Orange had made, out of which his men were driven to the raising of the siege; which is generally the fortune of attacking forces when they cannot spread after coming within the wall. We have read and we see in these days that a moderate, resolute garrison, by the help of barricades within the town, *had* forced a great army to raise the beleaguer after entering the breach, though 'tis not common.


As to that reason of surrendering the town because the garrison lost communication with the cavalry, it is of no moment; for the garrison of Limerick the last year, when besieged by the prince of Orange, was deprived of the horse, and yet preserved the city. Neither is it at all required or practised in the defence of fortresses to have horse, unless a few, and this in some certain towns. The Irish horse being separated from the place, might have more contributed to raise the siege, provided, in that separation, that they entered into the province of Leinster; for in that case the hostile cavalry would be obliged to follow them, as I said before, and their infantry could not in safety stay behind, as it appears to the considerer of the strength of the garrison. These are the two only reasons which were given to the public for surrendering Limerick, and which are proved null; for of provisions and ammunition they had plenty. Moreover, they daily expected a fleet out of France, with all necessaries for man and horse, even to the next campaign. And de facto it arrived at the mouth of the Shannon within sixteen days after the town was delivered to the besiegers; which shows that the most Christian king was altogether for preserving Limerick, and that he doubted not of its baffling the


---

p.171






enemy as it did in the year antecedent. This sending of such considerable stores *does* also indicate that his majesty was for continuing the war of Ireland, and that for this end he would send a reinforcement to the Irish army in spring following, the which the duke of Tyrconnell had requested a little before his death, even for the present season if possible, but could not obtain it for that juncture. The monarch of France had powerful motives for keeping on foot the Irish war; for thereby he could sooner dissolve the hostile confederacy abroad, as retaining the power of England (on which the league much depended) here in Ireland employed, and in sequel thereof that prince would be able to restore sooner the banished king of England, according to the resolution he had most generously made. 'Tis for these reasons that the king of France conceived afterwards great indignation at the surrender of Limerick, because it frustrated his mighty expectations, and was hardly dissuaded from punishing severely monsieur la Tour, the governor, and the two French lieutenant-generals for that rendition.


Behold, then, how tenable Limerick was against the besieging army. What was it, therefore, which moved the chief commanders of the town to give up the place, and to bring the Irish *Catholic* nation under the heavy yoke of an usurped government? We answer, first, that it was not any solid reason or necessity which induced them to this submission, though they had their concealed reasons for doing it, besides their pretended ones, which they published. Hence proceeds our second answer, that it must be a settled resolution (which they had made) that influenced them to determine the war. When this resolution was formed it is not made known unto us, but we believe that it was done since the death of the duke of Tyrconnell. I have received an account from one of the colonels who were with brigadier Clifford in that night when the English passed the Shannon a mile above the town, that he had heard a discourse, some days before that passage, of surrendering Limerick. This being so, we may set the *query*, whether the investing of Limerick on Thomond side had not been a concerted plot of some persons in the Irish army with general de Ginkel, in order to give a pretence to the party on the Irish side for the giving up of the place? The affirmative


---

p.172


{topic Observations on Siege of Limerick}



is more apparent; for general de Ginkel was knowing in his station and therefore he understood at the beginning of the siege which was the best way of taking speedily the town at a season that almost was at an end. As intelligent as he was, and as late as was the season, yet he used not this medium of *begirding* Limerick on the county of Clare side till the twenty-second of September, after lying before the wall about a month, and after making a breach in one part thereof, and, in fine, after not daring to mount it. That general knew also perfectly well that he had not army enough to surround the town effectually against so numerous a garrison, which was as much in number as his infantry, besides some horse and volunteers. He could not but be persuaded that he must make a breach in the wall on the other side of the town; that he must enter it before he could take the place; that still the same danger remained as there was in ascending the breach on the north wall, from which he thought fit to abstain; and lastly, that if he should venture an attack, there was a strong probability that he would be repulsed, seeing a more powerful army in the summer before was frustrated by a weaker garrison. What is it then that induced general de Ginkel, against reason and experience, to divide his host after a month's beleaguer, and with part of it to traject the Shannon and invest Limerick on Thomond side? 'Twas not the potency of his troops, as all skilful persons will admit; for first, his whole army (not above twenty thousand, as I touched before) could not pass the aforesaid ford if Clifford had duly executed his trust with his four regiments of dragoons, some companies of foot, and a small battery of cannon, with an *entrenchment* made at the place of trajection; and secondly, could so experienced a general, after passing the ford, expect to carry the very town, extraordinarily well garrisoned, with the trajected moiety of his army by a breach, to which there was no access but by a very narrow bridge, though kept entire, and which might be easily barricaded without-side of the gate with a hundred materials that were in the town, though no entrenchment should be made within? But surely Ginkel could not dream to frighten with his flying camp that puissant garrison to a rendition by his bare appearing before Thomond-gate without a


---

p.173


{topic Observations on Siege of Limerick}



stroke, without a shot, without a breach in the wall?—that garrison I say, who dared his whole army but a few days before? On the other hand, could it be imagined that such a garrison, a mastering garrison would surrender without a blow to the moiety of their late baffled enemies? If this were done within the jurisdiction of France, I question if one of the commanding officers would escape punishment—at least the governor would pay for it. It is comical to hear the great comanders of Limerick blame Clifford for not defending the pass of the river, and yet they themselves with as much ease do yield the fortress, as if, forsooth, the preservation of the town depended on the defence of that ford. Yet the same ford was open to the prince of Orange the last year, and neither he nor general Ginkel, nor the other generals, found any benefit thereby. They were at that time at loggerheads; but, since, they have found out that appearing before Thomond-gate with six or seven thousand men will oblige an immediate surrender. What would not the prince of Orange have given for this knack in the campaign precedent, especially after he was repulsed at the mounting of the breach he had made? What, likewise, would not general Ireton have bestowed for such a point of skill when he besieged the same town in the year 1650?


Out of the premises we may gather that Ginkel's traversing Clifford's ford, and *begirding* the town on Thomond-side, was done permissu superiorum’’

, in order that those superiors within the city might have a pretext for delivering that fortress, and thereby for concluding the unhappy war. What end they had by that conclusion, I dare not be positive in my opinion. The matter of fact affords a suspicion that some persons concerned in this affair had the *obtaining* of gold for their end. There is an opinion that a few of these great officers were for a peace, because they were tired out in holding war in Ireland after a slavish manner, and for that reason they would fain remove it into a foreign country against the prince of Orange and his allies, where, being in conjunction with the French forces and encouraged by the pay and other comforts of his most Christian majesty, they might better serve their own king in contributing to his speedy restoration. If this consideration


---

p.174






had been delivered to the Irish army before the capitulation was concluded, it is probable it would draw the whole host into France, because it savours of honour and of love to the king. This project would prove effectual if, after landing in France, the army, with a moderate reinforcement of French under the conduct of a marshal, were transported into England. It is true the most Christian king tried this very point in the summer immediately following, when the invading army of Irish, English, and French was encamped on the coast of Havre de Grace, in preparation to be transported as soon as the sea was made clear by admiral Tourville, and by the promised assistance of Mr. Carter, the English rear-admiral; but the enterprise miscarried by Carter's treachery, as we shall see beneath. The further end of this peace was repose, which several officers and some part of the soldiery coveted, because they were weary of that war wherein they had suffered so much through want of provisions and money; which is so certain, that it is to be admired how subjects would willingly endure such misery for their prince. However, a great many officers and the much major part of the soldiery were against the *termination* of the war, because they had an aversion to become subjects to a Protestant usurpation, as knowing the *nonesuch* calamity thereof; and truly they had the best reason on their side. The Irish gentlemen who, upon the peace of Limerick, have remained in their country under the usurped regency, have learned this truth ever since to their woe. It is likely that many of them would have transported themselves into France with the rest of their brethren at the surrender of that city, if they had been perfectly sensible of it at the forming of the articles of pacification.
But that which caused very much the generality of the Irish army to yield to a treaty of surrender and peace was as *follows*: The Irish nobility and the lesser people then at Limerick were a multitude of levellers, there being not anyone in the nature of a directing and swaying head to effect, since Tyrconnell's decease, though some men there were by their stations as governors of the rest. To speak it in clearer terms, there wanted a pater patriae’’

, a father of the country, that is, a man all on fire with zeal to preserve his country, his religion, his


---

p.175






liberty and his king's prerogative, and, at the same time, a man commissioned with the highest power and of an authority amongst all or at least amongst the major part uncontrollable, and who understands both his own and the enemy's present condition and future. Such a person as this in all parts there was none there at that time. Some patriots there were zealous enough, but they either wanted sufficient quality or jurisdiction, or a knowledge of what was best to be done, either to continue war or make a peace; in which state that abridgment of the Irish nation *enclosed* within the walls of that city seemed to be a flock without a shepherd, and therefore 'tis not to be admired if they went astray in making the best choice. The want of this person so described proved the principal cause that the Irish army consented to put a period to the war. If the duke of Tyrconnell were then alive (I utter it with certainty), he would not hearken to any offer of a surrender, because he expected to retrieve the country by spinning out the war. He grounded his expectation upon the courage of the army made evident unto him by the battle of Aughrim, and upon the reinforcement he was to receive out of France in the following spring. It is true there were within Limerick at that time some persons who were superior to the rest by their posts, as was the sieur la Tour, governor of the garrison, and the sieur d'Usson, and the chevalier de Tessé, lieutenants-general, and commanders-in-chief of the army. But these were strangers, and were ignorant of the oppression the Irish lay under from a Protestant government, and therefore from them not any remarkable zeal was expected for holding out the town. And though fear of their own king might have obliged them to defend obstinately the town, yet, being at that distance, they could satisfy his most Christian majesty with some plausible reasons, which would be of no value to a man thoroughly knowing in the condition of Limerick. There were also three lords justices or regents of the Irish nation, who had the power of determining whether war should be continued or a peace be made, viz., chancellor Fitton, sir Richard Nagle, and Mr. Plowden, of all whom I spoke above. These houourable persons had loyalty enough and zeal for the welfare of the *Catholic* people; but whether they had skill


---

p.176






enough to overrule the remonstrances for a surrender which the great officers of the army made, is the question. At least they appeared not to have authority enough for commanding what was best to be done in that declension of the Irish affairs. Wherefore, in those circumstances, a conclusion of war must be embraced. And now that it must be so, let us see what advantageous conditions will the leading men of the Irish make for themselves, and for the nation in general.
You will say: Why should this town presume to make conditions farther than for the inhabitants thereof, according to the custom of besieged garrisons? We answer: This town is not to be compared, as to a treaty of surrender, with other towns, which have no other dependencies than the happiness of their particular dwellers. The epitome of the *Catholic* people of Ireland is within this city, within the body of horse belonging to the garrison, within some towns and villages of the counties of Limerick, Clare, Kerry, Cork, Mayo and Sligo, all which lie under the protection and government of Limerick. 'Tis therefore that Limerick must make provisoes for the nation in general. She is encouraged thereunto by the knowledge of her own strength, which is so great that she can force the enemy to raise his siege, by which the war is prolonged, at least to the end of the next campaign. At the beginning thereof the confederate princes will be compelled, without dispute, to strike a peace with France, as not being able to hold out any longer, through the want of England's army and money, which must be employed in the Irish war. Hence immediately follows the dethronement of Orange and the restoration of the king. General Ginkel understood very well this affair by his granting better conditions to the garrison of Limerick than are given to any besieged town whatsoever, though he gave not so good as might have been extorted from him; which was occasioned by the too easy compliance of the Irish commissioners who were appointed to treat with him.


The conditions which the Irish should have resolved to obtain were three principally: a free exercise of their religion, the temporal liberty of subjects and their properties. These three points they might have gained in their circumstances without being judged too presumptuous


---

p.177


{topic Conditions obtainable by the Irish}



upon an usurped government, under which they were to abase themselves. As to the first point: that they may serve God in chapels and houses, as they did in the reign of king Charles the second, a Protestant prince; that their bishops and prelates, secular and regular, may use their power over their respective flocks; that this state may be continued for ever without molestation from king or parliament either in England or Ireland. The concession of this article is easy to Protestants, for it takes nothing from them which they had before the reign of James the second. They keep still their lands, their tithes, their benefices, and their churches.


For the second: that the *Catholics* may be equally under protection of the law with their fellow-subjects, the Protestants; that they may not be taxed by parliaments but as Protestants are; that the nobility and gentry throughout the kingdom may carry arms and use horses without restriction, and not to be prohibited by any law or order while they behave themselves peaceably. Neither is this condition to be deemed hard upon the Protestant government; for it deprives not Protestants of any employment, civil or military, nor endangers the state, because the number of *Catholic* lords and gentlemen is insignificant as to power against the Protestant government, which is in possession of all the kingdom and its forts, and is guarded by a considerable army, and by the assistance of England and Scotland. It is insignificant, I say, seeing the whole *Catholic* nation of Ireland being seized of all the realm (except Londonderry and Enniskillen), with some assistance from France, did not defend their country against the combined strength of Protestants.


As to the third point: that all *Catholics* whatsoever who were possessed of estates or of any rights in the reign of king Charles the second, may be restored immediately without cost; whether those *Catholics*, at the time of the capitulation, were within the Irish quarters, or in any other part of the kingdom, or in foreign countries. Nor is this article of any difficulty to be granted; for not any Protestant is a loser thereby of anything which he enjoyed in a year precedent. And all these *Catholics* together are but very few estated men in 


---

p.178


{topic Proceedings in relation to Treaty of Limerick}



respect of the Protestants of Ireland; for of eight thousand *Catholic* heirs who claimed to lands of inheritance at the restoration of Charles the second, there was not above five hundred restored, as we have mentioned before.


These three principal articles the Irish commissioners obtained in part, so that their failure was in not getting them entirely, as they might have done, if they had a befitting resolution. Yea, considering the necessity the prince of Orange was in of an army at that juncture to assist his confederates against France, and through that assistance to support his crown, the Irish at Limerick might have gotten much more beneficial conditions. But, alas! misfortune accompanied them in carrying on the war, and misfortune sticks to them in the conclusion.


And now it is time that we reassume the treaty proposed about the rendition of this considerable city. The hostages being exchanged, the Irish government sent their proposals to general Ginkel on the twenty-seventh of September, 1691. One of them, as I was informed, was, that those *Catholic* gentlemen who remained at home within the province of Leinster and elsewhere, after the fight of the Boyne, as not being concerned in the army, and whose estates the prince of Orange had seized upon, should be restored to the said estates. But general de Ginkel would not grant that article, as also some others then offered unto him; upon which Irish commissioners, being appointed to treat face to face, went out of the town, accompanied by some other persons of note, to general de Ginkel's quarters on the twenty-eighth. The commissioners were the earl of Lucan, the lord of Galmoy, colonel Nicholas Purcell, colonel Nicholas Cusack, sir Toby Butler, colonel Garret Dillon and colonel John Brown. These commissioners being arrived, general Ginkel sent immediately for his general officers to be his co-assistants in managing the treaty. All being met, they entered upon the business, wherein they had many a long and vehement debate. At last they came to an agreement, almost complete, in that same day, the twenty-eighth of September. The few difficuties which remained to be settled were put off till the regents of Ireland for the prince of Orange should


---

p.179


{topic Conclusion of Treaty at Limerick, October, 1691}

 



arrive in the camp, who were sent for to sign the treaty along with general de Ginkel, as the Irish commissjoners exacted.


On the first of October, in the evening, the said regents or lords justices, sir Charles Porter and Mr. Thomas Coningsby, arrived. On the next day the Irish commissioners went abroad to treat with the regents and general de Ginkel, and having stayed with them till twelve at night, they absolutely concluded the treaty, which was signed and exchanged on the third of October, 1691; in consequence of which the Irish delivered on the same day unto the English their outward works, their stone-fort and St. John's gate, in that moiety of the city called the Irish town. The English town was reserved for the Irish army until they were ready to march to the city of Cork, to be transported into France.


The articles of agreement for the surrendering of Limerick, and the counties of Limerick, Clare, Kerry, Cork, Sligo and Mayo, unto the subjection of the prince of Orange and of the princess, his consort, are divided into two parts. The first part is concerning the Irish who do remain in the kingdom. The second is concerning the Irish army that is to go to France. The first part contains thirteen articles, which are these in short:—


1. The Roman *Catholics* of this kingdom shall enjoy such privileges in the exercise of their religion as are consistent with the laws of Ireland; or as they did enjoy in the reign of king Charles the second: and their majesties (meaning the prince and princess of Orange, as king and queen of England), as soon as their affairs will permit them to summon a parliament in this kingdom, will endeavour to procure the said Roman *Catholics* such farther security in that particular as may preserve them from any disturbance upon the account of their said religion. This article in seven years after, viz., in the year 1698, was *broken* by a parliament in Ireland, summoned by the prince of Orange; for, instead of strengthening it, according to the purport of that article, the said parliament made a law for banishing in perpetuum the *Catholic* bishops, dignitaries, and regular clergy, which was executed. The parliament grounded their law upon their own interpretation of 

 


---

p.180




 {topic First Article of the Treaty of Limerick, 1691}

 

 

this first article without the consent of the Irish *Catholics*, which in equity they could not do; for a party is never admitted judge, even among pagans, if the other party's right; and whenever a doubt *arises* upon any article of a treaty of peace, the settling of that doubt is usually left either to the mediator or to commissioners appointed from both parties. The parliament flattered their tyrannical inclination by this, that in the days of king Charles the second the prelates and regular clergy were persecuted now and then for a year or two, more or less, upon some whimsy the government of England or Ireland conceived, as in the time of that perjured knave, Titus Oates, or in the like juncture. But this case does not favour the breach of the first article of Limerick's treaty, for the persecution of the *Catholic* bishops and regular clergy, in the reign of Charles the second, lasted but for a short while. But this banishment, though imposed by the parliament without colour, is perpetual. Secondly, the parliament seems ignorant of the nature of a peace; for a peace is in perpetuity, and not left arbitrary to either party to break it or keep it. And of the same duration is every article therein reciprocally granted; for otherwise there would no peace be ever made in the world, because one party would not leave his obtained doom to the discretion of the other, for the taking it away or not, when that other should think fit, and be able. Whence it *follows* that both sides would continue their animosities to extremity, or so far, until they could get an assurance from one and other of living lastingly in mutual friendship, unless some just and unforeseen cause should afterwards rise for the disturbing of the peace.


Now, to apply this to the first article of Limerick's pacification, we say that the concession which the Irish *Catholics* obtained in that article from the prince of Orange, was to enjoy perpetually the exercise of their religion as they enjoyed it in the reign of Charles the second. The indubitable meaning of which is this: The Irish *Catholics* shall be permitted to exercise *forever* without disturbance their religion in chapels and houses, without the splendour of churches, according as they exercised it in the days of king Charles the second. This interpretation is essentially so genuine, that the words, as they did enjoy in the reign


---

p.181


{topic Second Article of the Treaty of Limerick, 1691}

 



of king Charles the second,’’

 cannot possibly, according to the nature of a peace, be referred to time or duration, because the duration of the exercise of their religion was interrupted now and then in the abovesaid reign, and because the duration of a peace is perpetual, as this of Limerick is. You will understand it better by this discourse: We, Irish *Catholics*, do put ourselves under the subjection of the Protestant governments of England and Ireland, on condition that the said governments will suffer us to exercise our religion in what manner and as long as those governments shall think fit. Here I ask of any unbiassed person, whether such an intent ever sprang in the brains of the Irish commissioners, all Roman *Catholics*, and perfectly knowing that those with whom they dealed in this point were professed enemies to their religion, and do snatch by custom at every occasion to suppress the same, as they have practised from the reign of Henry the eighth unto this day? Sure, both parties are equally bound to perpetuity. If the prince of Orange will have the subjection of the Irish perpetual, the Irish must have the exercise of their religion perpetual after the exterior manner they used in Charles the second's days. Wherefore we will go to the second article.
The second is: that all persons within Limerick, and in the counties of Limerick, Clare, Kerry, Cork and Mayo shall be restored to what estates and rights they enjoyed in the reign of king Charles the second; and all persons within the said Limerick and counties who profess any calling, as that of a lawyer, physician, attorney, and the like, shall be permitted to exercise freely those professions. Out of this article are excluded all estated men, and professors of the above said sciences and arts, who were either prisoners of war, or who otherwise were not within the said counties and garrison of Limerick at the time of this capitulation, though these last had borne no employment, civil or military, for king James the second. It was here that the greatest weakness of the Irish Commissioners lay, by not constraining general de Ginkel to grant so easy a point, as I showed above. But I would fain understand by what authority does the prince of Orange (though he were lawful king of England) challenge a right of taking 

 


---

p.182




 



to himself the lands of those gentlemen who had not carried arms against him, nor *sat* in council against his interest? If the rising of the Irish for king James the second be reputed a rebellion to the prince of Orange, as created king of England by the English people, it follows thence that this new-made king, when victorious, cannot punish any subjects but such as he finds rebels. This is a general principle of justice embraced by all Christian nations. But several Irish gentlemen amongst those who were not within the above-mentioned city and counties at the time of making the peace of Limerick, were no rebels, as being neither in army nor in council against king William. It is therefore they cannot justly be punished by the said king, either in their lives or in their fortunes. The minor, or the assumption, is uncontrollable; for those persons were really such as I have described them, and even by the confession of their adversaries. The consequence then is inevitable.


As to those gentlemen who got such civil employments, as are collectors, justices of the peace, and the like, from their lawful king, in the beginning of his reign, and held the same until their king was ejected out of Ireland by another king, whom the people of England had raised, I start the question, whether the said gentlemen can be justly deprived of their inheritances, which they have from birth, by any authority that is righteously inherent in monarchy? If they be reputed rebels, they must first, according to law, be arraigned, and, with the formalities of the said law, be convicted of rebellion; in which case, their lives are first taken away, and, in sequel, their estates, unless they were only tenants for life. But nothing of this is observed in excluding the said gentlemen from their birth-rights.


And now that I speak of rebellion, I set again the *query*: how can the Irish at all be truly deemed rebels to the prince of Orange, by rising for king James the second against the said prince, created king by the people of England? Was not James the second acknowledged the lawful king by the three kingdoms, and as such did he not reign four years? What should then oblige the people of Ireland to disown him, their lawful sovereign, for the rest of his life? They had no grounds 


---

p.183


{topic Ireland a distinct Realm}

 



of quarrel with his majesty, and though they should have been oppressed by him, yet they did not think it just to vindicate their wrongs by his dethronement, as they observed in their comportment towards Charles the second, who had injured them in the highest degree. Neither did the Irish see the people of England so tyrannized by the king, as to have any solid cause of dethroning him, of which above; and of the same sentiment was all Europe, unless we may except the States of Holland, who, perhaps, will not discountenance subjects of other princes to rebel, seeing they had made themselves a republic by rebellion against the crown of Spain, and who have, de facto, assisted the subjects of England to rise against their king by giving a fleet and troops to the prince of Orange for that effect. Wherefore, why should the *Catholics* of Ireland turn savages by destroying their lawful king without rhyme or reason? That is a behaviour more suitable to heretics, who, in likelihood, would become a sort of pagans or atheists in a few ages, if it were not that *Catholics*, or the true believers, do daily advertise them of their errors in worshipping God.


But you'll say that England, the principal kingdom of the monarchy, ought to be followed by Ireland in owning or disowning the kings of that monarchy. We answer thus: that the behaviour herein of the people of England is no rule to Ireland, a distinct realm, a different nation, as having a viceroy for governor sent by the king as king of Ireland; also as having discrepant laws; as having a parliament of her own, so judges and magistrates. Ireland *had* never acknowledged her king to be chosen by the people, but to succeed by birth; nor her king to be deposable by the people upon any cause of quarrel. She knows more righteous things, and scorns to make heretical England her pattern in the point of righteousness. When the lawful king of England dies, Ireland acknowledges immediately the person next in blood, be he Catholic or Protestant, to be the king of England and hers, whether the people of England consent to it or not, as she did when king Charles the first was dead, whose eldest son, Charles the second, she owned as her true sovereign, and signed that acknowledgment

 


---

p.184




 {topic Observations on England and Ireland}

 



in characters of blood, though at the same time England rejected him, until being weary of her rebellion, she received him at last as her undoubted king. Therefore, bring no more England as a prototype of behaviour towards the crown unto Ireland. It is ridiculous in grain; for the people of England, since their fall into heresy, is a nation prone to rebellion through the depravedness of religion; and they have, de facto, deposed three kings in direct succession, Charles the first, Charles the second, and James the second; while the people of Ireland have fought against those rebels in asserting the rights of those same princes. England is a nation without conscience or fear of God, as we proved it above in their demeanour towards their lawful sovereigns and their fellow-subjects, since their unhappy desertion from Rome, while the Irish *Catholics* have showed themselves honest men in giving everyone his due: to Caesar what is Caesar's; to God, what is God's; to fellow-subjects what is theirs, by not invading their lands or their goods, and lastly, in suffering to extremity, because they would not turn knaves with the knaves of England against the Lord's anointed and the good subjects, which, if they had done, they would have kept their estates unto this day, as the other villains of the monarchy did. Moreover, you are to know that England, separated from the lawful king, has no more right in Ireland than has France or Spain, or *had* Ireland in England; so that each nation of the three, viz., English, Scotch, and Irish, is independent of the other two, but all are depending on the king. Hence it is that if the blood royal be extinct, every one of the three nations may choose a distinct government. These independencies are sufficiently proved in books that are obvious, which spares me labour in this place. Wherefore, what authority the people of England challenges or exercises over Ireland is mere usurpation, and is done in a strong hand. If the Irish had been as wise as courageous, they might have often made England pay for her arrogancy, and they are able to do it yet by a fair trial in the field, where neither ignorance in generals nor treachery in officers of great trust have any admittance. There is no difficulty in believing this, if you consider their bravery 


---

p.185


{topic Treaty of Limerick}

 



abroad; it is the same at home, when they are led regularly to the combat.


But to return to the second article of Limerick's capitulation: out of it are also excluded the very infant heirs of those fathers who had served the king against Orange, and died in his service before the said capitulation, or who, being alive, were not within the afore-mentioned counties at the time of making those articles, provided that the said fathers had not been tenants for life of their estates. Thus the innocent children must starve for want of bread, though they be the issue of lords of lands; thus they must be punished, because their fathers were honest men, and sticklers to their lawful prince. Behold a sweet government, set up by the godly people of England! Behold a religion amazingly reformed!


The third article gives the benefit of the second to all Irish merchants of Limerick, and of the other garrisons now in possession of the Irish, and of any other town or place in the counties of Clare or Kerry, that are absent beyond the seas, provided that they have not borne arms against the prince of Orange, since February, 1688, old style, that is 1689, stylo novo: and provided that they return into Ireland within eight months from the date thereof.


The fourth article allows the advantage of the second to particular persons abroad in France, as are colonel Simon Luttrell; captain Rowland White; Mr. Maurice Eustace, of Yeomanstown; and Cheevers, lord of Mount Leinster; provided they come back to their country within the space of eight months.


The fifth grants to those persons comprised in the second and third articles, a pardon of all attainders, outlawries, treasons, misprisions of treason, praemunires, felonies, trespasses, and other crimes and misdemeanours whatsoever, which have been committed by them since the beginning of the reign of king James the second.


The sixth article settles the kingdom by prohibiting lawsuits, and such animosities between private persons on king James's side, comprehended in this capitulation; and others, who were for the prince of Orange, upon the account of taking away from one and other, horses, money, or other goods in the time of the war.




---

p.186


The seventh permits all noblemen and gentlemen within the second and third articles to make use of a sword, of a case of pistols, and of a fusil. This article was broke in the summer following; for they disarmed surprisingly all the *Catholics* of the kingdom when they heard that the king *James II.* came to the coasts of Normandy in order to be transported into England with an army. A parliament, sitting in Dublin in autumn following, made an act that no *Catholic*, included in the treaty of Limerick, shall henceforward carry a sword or fire-arms, unless he be worth a hundred pounds per annum; and that such a qualified man must have special leave in writing from the government for bearing those arms. Since that time but few gentlemen have worn a sword; and those few have been often disarmed in a most rude manner, as if they had ported arms without license, whensoever the government of England dreamed or pretended any danger from the king of France; whereas those Irish gentlemen did expect upon any solid occasion to lose their arms by proclamation, commanding them to deliver them up to such and such ministers of justice, since they had carried them with the good permission of the regency.


The eighth article gives leave to the inhabitants and residents of Limerick and other garrisons of its dependence, to remove their goods from thence without being viewed or searched.


The ninth obliges the *Catholics* contained in this treaty, to make no other oath to the government of England than that of allegiance. This article has been broken since, both in intent and in fact. For two parliaments in Ireland have strained to pass an act that the Irish *Catholics*, even those comprehended in the articles of Limerick, as well as Protestants, shall be *bound* to take an oath against their religion, it being against the pope's spiritual power; and this under the highest penalties. But a party in those parliaments was prevailed upon not to suffer that law to be made. Afterwards, and in this year, 1703, the parliament of England, in the regency of the princess Anne of Denmark, or otherwise queen Anne, have made an act, obliging upon severe punishment all persons in England and Ireland bearing employments, civil and military, and using professions of gaining a livelihood,


---

p.187






as those of lawyers, attorneys, schoolmasters, preachers, solicitors, and others the like, to take the oath of abjuration, whereby they swear that James the third, king of England, now residing at St. Germain's, in France, *had* not any title whatsoever to the crown of Great Britain. Out of this oath are not exempted the Irish Catholic lawyers, attorneys solicitors, and other professors of callings, who are comprised within the treaty of Limerick; which oath, if they refuse, they are ipso facto debarred from exercising their arts and sciences. You see here there is no depending on the solemn faith of our British heretics, though public faith is the greatest tie that is made between man and man, between nation and nation. It is sacred amongst pagans, and, if any side infringe it, the rest looks upon them to be not human. What can mankind do without the observation thereof? There can be no commerce, no peace, and all things must fall into a chaos. The government of England will have the Irish to observe their part of the mutual obligation, and yet the said government will not fulfil their own, which is against natural equity, for all compacts of this kind are reciprocally binding by the law of nature, which law cannot be overruled by human statutes, as it is known to every man who understands exchanging, buying and selling; and therefore I may spare my labour in expatiating through a field of discourses for proving the villainy of the breach of public faith; only I will put these perfidious people in mind of the punishment God inflicted on Israel for three years, and particularly on the family of Saul, in the 21st chapter and second book of Kings, for breaking faith with the Gabaonites.


There are four articles more of civil capitulation, which we will not here insert, leaving the perusal of them to the reader in a book containing at large the treaty of Limerick. The military articles for the transportation of the Irish army into France are excellently well done; whereby all persons whatsoever throughout the kingdom, as well the Irish army as others, may go into France, or into any other foreign country, but the army shall not carry above nine hundred horses out of the realm. The garrison of Limerick is to march out with arms, baggage, drums beating, match lighted at both ends, bullet in mouth, colours flying, six choice, brass guns, two mortar-pieces, and with half 

 


---

p.188




 {topic Proclamation of Peace, October, 1691}

 



the ammunition of the town. The other Irish garrisons of the above-mentioned counties are to march out also with the like honours. For the transportation of the Irish forces into France, general de Ginkel is to furnish fifty ships, each ship of two hundred tons, and twenty more, if need requires, with two *men-of-war*. You may see the rest at large in nineteen articles.


The next day, being the fourth of October, the peace was proclaimed at Limerick, and in the English camp. On the fifth, the Irish cavalry that was encamped at Ennis, came close to the city, the foot-garrison thereof, for the most part, went out and joined them. Here, before the Irish army, it was declared that they had liberty to dispose of themselves as they should think fit, either to go home and live peaceably in the kingdom, or to continue their service unto king James in France, under the banners of the most Christian king; or, in fine, to come under the pay of king William, as now he must be called by his own subjects, the Irish. The invitations made to the Irish soldiers for embracing this side or that side were powerful; but at last the result was thus: all the estated men stayed in the kingdom, in order to enjoy their estates, except the Lord of Galmoy, the earl of Lucan, colonel Garret Dillon, sir Maurice Eustace, of Castlemartin, colonel Gordon O'Neil, colonel Barret, lieutenant-colonel Nugent, of Dardistown, and captain Arthur, of Hacketstown. There were some other lords of lands at that time, prisoners in England, as the earl of Tyrone, the lord baron of Cahir, the earl of Clancarty, the lord baron of Slane, and a few others; besides what were with the king in France, as the earl of Limerick, colonel Dudley Bagnal, of Dunlickny, colonel Simon Luttrell, and a few others.


But the earl of Lucan, the lord of Galmoy, brigadier Patrick Plunkett, colonel Garret Dillon, brigadier Roth, colonel Gordon O'Neil, major-general Sheldon, and some other principal officers, being desirous to follow and serve the king abroad, drew after them about twelve thousand of the army. The third division was the lot of king William, who, by general Ginkel's means, got about five thousand of the Irish host, with some considerable officers, to come under his pay.


Here, we must observe, that this behaviour of the Irish gentlemen


---

p.189


{topic Reflections on the Seceders}

 



who turned to the prince of Orange is base, for they are foes to their country by siding with her enemies. They are slaves in their nature by voluntarily serving usurpers; they are, in some measure, rebels to their king by positively engaging themselves in the service of his dethroner; they betray the cause of their religion in strengthening the party of heretics, who actually use their endeavours to extinguish it at home and abroad. These gentlemen have a fall in the path of honour (which is a pity) by embracing the interest of rebels, after having so bravely fought against them for three years.


What excuse can they have for this dirty action? It was not want which moved them thereunto; for some of them were to regain, by the treaty of Limerick, lands of inheritance and farms. Others were able to take farms for their livelihood; and if they were to have neither land nor farm, yet, being resolved to continue a military life for maintenance, they should, in honour, go with the rest of the army into France, and serve their king under the pay of the Gallick monarch. But the matter is this: These gentlemen despaired that ever the king would be restored, and so were sure that the government of king William was in perpetuum established. Whereupon, they judged it fitter, in those circumstances, to lay aside that nice honour, and to embrace lucre, though sordid, which they proposed to themselves to have in plenty by settled employments in their own country, without being obliged to go to the confederate war abroad; and this, besides enjoying their estates and farms.


This was the paradise which these new Williamites expected to have to themselves and to their heirs. But they found soon, to their sorrow, that all was a dream; for their new master thought it not safe to trust his new servants, and so he sent orders out of England into Ireland, in January following, to disband all the *Catholic* forces, except 1,400 choice men of them, which were to be divided into two battalions, and to be given to Baldarg O'Donnell and colonel Wilson. In a little while after, a second order was sent to break all Irish *Catholics* whatsoever. A third order was sent, in March following, to raise five companies of *Catholics*, a hundred to each company, and 

 


---

p.190


{topic Evacuation of Limerick, 1691}

 



to be sent under the lord of Iveagh to the emperor's service, which was done. They were shipped off in summer, they landed in Holland, and being come into Germany, the emperor sent them into Hungary against the Turk, where all of them (very few excepted) died with the plague and other sicknesses within a year after their arrival.


This disappointment of our gentlemen in their expectations *had* brought them down between hope and despair. For, in the future, when the rightful king is *reenthroned*, it will likely not go well with them; as it will not with such governors of towns as had easily surrendered them to the enemy; so will it not with those *Catholics* who turned Protestants to temporize during the usurpation; nor with those others who have had the common fame of being dishonest in the discharge of their trust, civil or military; nor with those who vilified the king's authority in *condemning* the viceroy Tyrconnell at Limerick, and especially at Athlone, of which above.


All things being prepared for an evacuation of the town *Limerick*, the two regents of Ireland for the prince of Orange, sir Charles Porter and Mr. Thomas Coningsby, departed from the English camp on the seventh of October, and returned to Dublin. On the next day, the Irish gentlemen and others, with their families, who had not been concerned in the army, as also those officers and soldiers who were resolved to stay in Ireland without taking any part under king William, began to leave the city of Limerick towards their respective homes. Likewise, on the same day, a part of the *Catholic* host that was to go for France, marched out of the said city for the harbour of Cork, where they were to embark. The rest followed by intervals. The last division of them quitted the town on the first November. In a fortnight after Limerick was surrendered, the expected French fleet, under count de Chateau-Renaud, arrived about the twentieth of October, at Scattery, in the river of Limerick, being eighteen *men-of-war*, four fire-ships, and twenty ships of burden, bringing victuals, ammunition, money, and all other necessaries of war. In this fleet was colonel Simon Luttrell, who had taken great care for its speedy arrival, though afterwards the arrival proved too late.




---

p.191


{topic Embarkation of Irish troops, 1691}
When this fleet arrived, there was at Limerick, in that moiety thereof which is called the English town, a good body of the Irish soldiers destined for France, who now, with the assistance of the fleet, might retake the other half of the city, and maintain it all winter, if they had a mind to break the peace, and thereby they could renew the war, for none of their army was shipped off as yet, and the English host was gone into winter-quarters. But men of honesty will rather suffer than break their word, which is a doctrine little regarded by the Protestants of England and Ireland.


The French fleet being informed of the surrender of Limerick, returned within a few days to France, with deep resentment at their unexpected disappointment; there went aboard them a part of the Irish soldiers. The most Christian king, hearing of this affair, was in great rage, and was like to punish severely those commanders (as above said) who had the chief hand in giving up the town, until receiving some sort of apology for the fact, his majesty was pleased to smother his passion.


The Irish troops being arrived at Cork, and the transport fleet made ready, the major part of them embarked and sailed away about the beginning of December, for Brest, in France. Another proportion of them departed on the twenty-second of December, with the earl of Lucan and several other officers. They all landed safe. In this voyage went along chancellor Fitton, sir Richard Nagle and Mr. Plowden, who were the late lords justices for the king, as also the *Catholic* lord primate of Ireland, and a few other prelates.


After the surrender of Limerick, the English army marched into winter-quarters on the thirteenth of October, there being left for governor of the town, sir David Collier, with five regiments. General Ginkel came to Dublin, where he was received and entertained by the regency with abundance of joy and honour, and on the sixth of December following, he took shipping at Dublin for England. The greatest part of the English army was in the next spring sent into Flanders, to join the confederate forces against the king of France; and some battalions were transmitted into Savoy, under the conduct of the 

 


---

p.192




 {topic Conclusion of Narrative}

 



marquis de Ruvigny, alias earl of Galway, in order to reinforce the host of the allies in that country. In the ensuing March, and on the twenty-third day, 1692, new style, king William, by proclamation, declared the war of Ireland to be at an end.


Here we cannot omit to tell our opinion, that the king of France made a false step in the politics by letting the Irish war fall, because that war was the best medium in the world for destroying soon the confederacy abroad, by reason that the confederate princes could not prolong the foreign war without the army and money of England, which were employed in the war of Ireland, the sequel of which would be the *reenthronement* of the king, at which juncture the forces of France and England, by sea and land conjoined, would give laws to the earth. 'Tis this consideration that had made some believe that it had been better for the most Christian monarch to have minded, in the first place, the restoration of king James the second, after the peace of Ryswick, than the enthronement of his grandson, the duke of Anjou; for in such case the emperor would not have dared attempt anything, seeing both sea and land, so barricadoed against him, as that there remained no human possibility unto him to come at the throne of Spain.


