

#A Description of Killarney


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


A Description of Killarney
==========================


Author: Dunn (attributed)
-------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by University College, Cork and  
The Writers of Ireland II Project.Proof corrections by Beatrix Färber

 1. First draft, revised and corrected.Extent of text: 
11500 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland —http://www.ucc.ie/celt

 (2009) (2011) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E770001-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

Halkett & Laing assign authorship of this text to Dunn.

#### Sources


**Descriptions of Ireland: A selection**2. Sir William Brereton, 'Carrickfergus visited in 1635'; edited by E. Hawkins. Carrickfergus & District Historical Journal, 4 (1988–89) 11–16.
3. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). [=A translation of portions of 'Les voyages et observations du sieur de la Boullaye Le Gouz ...' Paris, 1653.] (available online at CELT).
4. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman. Dublin 1846.
5. Thomas Dinely, Observations on a Tour through the Kingdom of Ireland in 1681, Dublin 1858. Reprinted in Kilkenny Archaeological Society's Journal, Second Series.
6. Charles Smith, The antient and present state of the county and city of Cork: in four books. I. Containing, the antient names of the territories and inhabitants, with the civil and ecclesiastiscal division therof. II. The topography of the county and city of Cork. III. The civil history of the county. IV. The natural history of the same ... Published with the approbation of the Physico-historical society. Dublin: Printed by A. Reilly for the author, 1750. Reprinted Dublin 1774. Reprinted by the Cork Historical and Archaeological Society, with the addition of numerous original notes, etc., from the mss. of the late Thomas Crofton Croker, F.S.A., and Richard Caulfield, LL.D. Edited by Robert Day and W.A. Copinger. Cork 1893–1894.
7. Richard Pococke, A Tour in Ireland in 1752; ed. by George T. Stokes, as 'Bishop Pococke's tour in Ireland in 1752'; Dublin and London 1891 (available online at CELT).
8. John Mitchell, The present state of Great Britain and North America, with regard to agriculture, population, trade, and manufactures, impartially considered (...). London: printed for T. Becket and P.A. De Hondt, 1767.
9. Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
10. Charles Smith, The ancient and present state of the county and city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1773; 1774).
11. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (London 1777).
12. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom: made in the years 1776, 1777, and 1778. And brought down to the end of 1779. (London, printed by H. Goldney, for T. Cadell and J. Dodsley, 1780; Dublin, printed by George Bonham, for Messrs. Whitestone, Sleater, Sheppard, Williams, Burnet, Wilson Jenkin, Wogan, Vallance, White, Beatty, Byrn, and Burton, 1780. (A later edition is available online at CELT).
13. Sir Richard Colt Hoare, Journal of a Tour in Ireland, AD 1806 (Dublin and London 1807).
14. George Newenham Wright, A Guide to the county of Wicklow (London 1822).
15. James Norris Brewer, The Beauties of Ireland (London 1825-26).
16. Caesar Otway, Sketches in Ireland: descriptive of interesting, and hitherto unnoticed districts, in the north and south (Dublin 1827).
17. Patrick Knight, Erris in the Irish highlands and the Atlantic railway (Dublin and London 1836).
18. Caesar Otway, Sketches in Ireland: descriptive of interesting portions of the counties of Donegal, Cork, and Kerry (Dublin 1839).
19. Caesar Otway, A Tour in Connaught (Dublin 1839).
20. Johann Georg Kohl, Travels in Ireland (London 1844) (available online at CELT).
21. Caesar Otway, Sketches in Erris and Tyrawly (Dublin and London 1845).
22. Sir William Wilde, Lough Corrib, its Shores and Islands (Dublin 1867).
**Secondary literature**2. Pádraig Ó Maidín, Pococke's tour of south and south-west Ireland in 1758. Journal of the Cork Historical & Archaeological Society, 2nd ser., 63 (1958) 73–94; 64 (1959) 35–56; 65 (1960) 130–141.
3. Richard Pococke, Richard Pococke's Irish tours; ed. John McVeigh [=McVeagh]. Dublin: Irish Academic Press 1995.
4. Maureen Hegarty, Dr Richard Pococke's travels in Ireland, England and Wales. Old Kilkenny Review: Journal of the Kilkenny Archaeological Society 3 (1987) 388–398.
5. John McVeagh, "Romantick" Ireland: Pococke's tour of Cork and Kerry, 1758. Éire-Ireland, 25:2 (1990) 69–95.
6. Thomas Carte, The life of James, Duke of Ormond: containing an account of the most remarkable affairs of his time, and particularly of Ireland under his government [...] 6 volumes (Oxford 1851).
7. John McVeagh (ed.), Irish Travel Writing. A Bibliography. (Dublin 1996).
8. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. A Description of Killarney. Dunn (attributed) First edition [67 pages] Printed for W. Watson, J. Potts, S. Watson, W. Whitestone, J. Sheppard, J. Williams, W. Colles, R. Moncrieffe, W. Wilson, T. Walker, C. Jenkin, W. Gilbert, G. Burnet, R. Stewart, W. Spotswood, E. Cross, P. Higly, T. Armitage, L. White, and G. MehainDublin (1776)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pages 3–67. The map on the front page is included.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


For obsolete spellings of personal names and place names, a standardised form is given in the XML encoding, by the value of the reg  attribute within the orig tag. Encoding is subject to revision.


##### Quotation


Direct speech is tagged q. Quotations from written sources are tagged cit and may contain qttags. Where the quotation source is identified, it contains bibl tags.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the section; div2= the subsection; page-breaks are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal names, titles (of books etc) and terms are tagged. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the entry. ### Profile Description


Created: By Mr Dunn 
 (c. 1776) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some quotes from poetry are in Latin.


### Revision History


* (2011-08-03) Beatrix Färber (ed.)

* Additions to bibliography made; file updated and reparsed; new wordcount made; new SGML and HTML files created.
* (2009-02-02) Beatrix Färber (ed.)

* Bibliography compiled; map integrated. SGML and HTML files created.
* (2009-01-25) Beatrix Färber (ed.)

* Whole file re-proofed (2); more content markup applied. Header modified; file parsed.
* (2008-11-15) Beatrix Färber (ed.)

* Provisional header created.
* (2008-11-09) Emer Purcell (data capture/ed.)

* Text typed in to p. 67; proofed (1) and basic structural markup applied.
* (2008-11-06) Beatrix Färber (data capture/ed.)

* Text typed in to p. 31; proofed (1) and basic structural markup applied.




---


#### Corpus of Electronic Texts Edition: E770001-001


### A Description of Killarney: Author: Dunn (attributed)


*Map of Killarney Lakes.*




---

p.3


To convey to the fancy a lively representation of substantial visible forms, is deemed rather the province of that artist who speaks to the eye, than of the mere verbal describer. Yet so limited are the powers of the pencil, that by it, the same object can only be represented, in one moment of its existence, and under a single point of view; whereas description ranges in a wider field, commands the several changes 


---

p.4




which time, in its silent lapse, draws along with it; exhibits things in all the different lights and positions, in which they can be viewed. Discovers new beauties in effects from unravelling their causes, traces under the mouldering ruin, stately temples, domes, and palaces, the monuments of a race of mortals long forgotten; takes in an extent of scenery, which the unassisted eye loses, and the pencil faintly pourtrays, and throws a mysterious veil over every object, by allusions and details drawn from the stores of history and fable:


> 1. There Arthur lies, and there the Runic bard,
>   
> Here fell the hero; these sad hollow antres,
>   
> That grove, did hear his moan.
> 





Resolving these advantages of the descriptive method, over the mere plastic, I wished to prove its excellence by an example; and meeting with a subject altogether engaging, I made the following attempt



---

p.5



to exhibit it in its true colours. I inscribe it to the **Academy of Royal Artists**, as a poor atonement for my presumptuous encroachment upon the province of picture.


I visited **Killarney** in the most favourable seasons for viewing it, when the trees resigning their foliage, were already marked with all the different colourings of decay: and when spring, repairing the winter's ravages, had again cloathed them with renewed verdure: but I preferred the autumnal prospect.


The lake is divided into two great branches, or more properly speaking, there are two distinct lakes, A, B, connected by a winding river.


The northern lake, called also **Lough Lane**, from its receiving a torrent of that name, is by many degrees the larger. It is divided into two branches, the one distinguished by the name of the **Great Lake**, 



---

p.6



and the other called **Turk lake**, C, from a mountain that overhangs it.


The **Great Lake** lies East and West, and from Mr. Herbert's park, to the mouth of the **Lune**, measures about seven English miles. Its breadth, from the neighbourhood of **Reen Point**, to the opposite side, is said to be nearly four.


**Turk lake** is about two miles and a half in length, and three quarters of a mile in breadth, it stretches from East to West, with an inclination to the North and South.


The southern shores of both these lakes are formed by high mountains; those of the **Great Lake** covered with wood, those of the other without wood. The land which bounds them to the North, the East and the West, is either a flat, or only raised from the water by gentle swellings. 'Tis generally diversified by plantations.




---

p.7


I shall first trace out the several bays, banks, and islands, which occur in the lakes, proportioning my detail to the importance of the objects; that passing from particulars to generals, we may, on some good grounds, establish a comprehensive character of the whole, and, with the better relish and judgment, proceed to consider the more remarkable points of view.


The angular mountain **Glynnau**, or **Glauná**, D, stands on the South side of the lake, and has two sides washed by it, for round this mountain the lake takes a turn, and so runs to a narrow point, where it receives the water from the upper or southern lake. This is a very beautiful mountain, covered for a great part of the ascent with forest trees, such as oak, ash, pine, alder, and birch, intermixed with hazel, whitethorn, yew, holley and **arbutus**, all perfectly wild. The forest trees are not very stately, but the yews, holleys, and strawberry-trees, are in great perfection;



---

p.8



and blending their different greens, form a fine mixture. The sides of the mountain, though not uniform, rife with an easy acclivity from the water, and are here and there broken by gullies and streamlets, which is pleasing. The shores are all along indented, and from the angle particularly, there runs a point richly wooded, which forms two bays. The principal inhabitants of this mountain are the red deer, which, among the sequestered thickets, enjoy an undisturbed repose; except on gala day, when O'Donahue makes a sacrifice to the curiosity of the visitors of the lake, or his own passion for the chace, which happens rarely. The music of the dogs and horns, and the shouts of the hunters, posted in great numbes along the ridge of the mountain, are re-echoed from the several parts of it, and produce an effect singularly pleasing. It is from hence the stag generally precipitates himself ino the lake, when hard pressed by his 



---

p.9



pursuers; who studiously reduce him to this necessity, by hemming him in on all sides; and his spirited efforts to prolong existence in an element so unfriendly to him, afford the highest entertainment. This mountain is the propoerty of **Lord Kenmare**.


**Toomith**, or **Tomé**, E, stands to the westward of **Glynnau**, from which it is separated by a torrent, called, in the expressive phrase of the natives, **Screech Stream**. It completes the Southern boundary of the lake, and in its situation, and appearance, much resembles **Glynnau**. The finest cascade in the neighbourhood of **Killarney**, falls from this mountain; which, retaining the name of its ancient possessor, is called **O'Sullivan's Cascade**. While the rains prevail it is amply supplied with water, and exhibits a very beautiful picture. It falls from three great stages, of nearly equal heights, disposed in such a manner, that the course of the stream which supplies it, is hid from



---

p.10



the spectator. The water is so agitated in its course down the mountain, that from the instant it breaks upon the eye, it is one entire sheet of foam; and dashing from stage to stage, enlivens every thing around it, by the reflection of the scattered rays which fall upon it; serving at once to illuminate, and contrast, the shady green trees and shrubs which overhang it. The only spot from which it can be seen to advantage, is from a rock in a channel below; from thence the stages seem to diminish from bottom to top, from twenty four or five feet, to twenty, and from twenty to fifteen or sixteen. The whole scene abounds with the most picturesque beauties, but the minuteness of the objects, and that air of regularity which is diffused over the whole, strikes it out of the class of grandeur and sublimity. At some distance from the cascade, there are two or three rude cottages, inhabited by a set of hardy mountaineers, who probably subsist by



---

p.11



the chace. They generally come down to traffick with strangers, bringing with them nuts, and wild berries; and sometimes cuttings of yew, thorn, and oak, for walking sticks. The only bounties of Heaven they seem to enjoy, are health, and a fine prospect; contentment, if they possess it, is with them an heroic virtue. This mountain belongs to **Mr. Herbert** of **Mucrus**.


Towards the West, the lake washes a very rich and improveable country. The part of which it extends from **Tomé**, to **Dunlow castle**, is called **O'Sullivan's Country**, F; but it is now the property of **Mr. Herbert**. It is no where marked with very striking features; it rises in a swelling slope from the lake, and is here and there diversified by trees, particularly on the banks of the **Lune**. This river is very considerable at its source, being the only outlet from the lake, which receives from the surrounding mountains



---

p.12



several plentiful streams. Winding for a considerable way through a rich valley, it separates **O'Sullivan's Country** from the estate of **Macarthy-more**; and taking a westerly course, discharges itself into the ocean at the distance of seven or eight miles. It is called by the natives *the* **Leaune**.


The estate of **Macarty-more**, G, compleats the western boundary of the lake. The house is well situated upon rising gound near the river; but the improvements are much neglected. In alighting to take a view of the ancient family seat at **Pallice**, I gave the bridle of my horse to a poor boy, who seemed to look for it with a degree of eagerness. From his manner of answering the questions I asked him, I was led to enquire into his situation; and was not a little surprized to find, that though sunk in the most abject poverty, he was, nevertheless, a good classical scholar. He was well acquainted with the best Latin 



---

p.13



poets, had read most over the historians, and was then busy with the orations of **Cicero**. I could not help pitying, at the same time I admired him, and lamenting the hard situation which rendered his knowledge useless; his taste and refinements the sources of continual disgusts and mortifications; and even his habits of study pernicious, as they diverted him from those active employments, which alone could keep him above want and wretchedness. I found, upon further enquiry, that this classcial spirit is very general among the lower people in **Kerry**: a circumstance which gives an air of probability to the romantic accounts of a late Memoir writer,[1](javascript:footNote('E770001-001/note001.html')) concerning the learning and taste of certain northern shepherds.


The lands which lie along the northern shores, H, of the lake, have a very uniform character; they are such as one sees every where, hills and dales tolerably



---

p.14



wooded, and pretty well enclosed; but capable, from their soil, and above all from their situation, of being made very enviable scenes. A neat farm house, built upon a charming neck of land, called by way of eminence **The Point**, and possessed by **Mr. Mahony**, is better adapted to the spot, and raises more pleasing ideas, than if it wore a more gaudy assuming air. The bay, which lies between this neck and **Reen Point**, is one of the largest, and most delightful in the lake; and owes so great a share of its beauty, to the islands, that I can scarce forbear mentioning them. **Reen Point** lies nearly in the middle between the extremities of the lake; and, about an English mile behind it, stands the village of **Killarney**, and **Lord Kenmare**'s house. About half a mile to the East of it, the **Flesk**, a very fine stream, which springs from **Glanflesk**, a mountain some miles distant, falls into the lake. On its eastern bank, close upon the shore, is **Cahiranane**,



---

p.15



the seat of **Mr. Arthur Herbert**, which has nothing remarkable to boast of. This side of the lake ends in a sandy bay, one of the finest I remember to have seen in it. **Lord Kenmare** is the principal proprietor.


We now come to the eastern boundary of the **Great Lake**, which is every where rich in wild beauties. The northern part of it is called **Mucrus**, I; as it stretches southerly, it gets the name of **Camillan**, K, and round the extremity of **Camillan** is the passage to **Turk Lake**. It is impossible to conceive any thing more charming than the shady bays, creeks, and recesses, which the lake here forms. The variety of their shapes, the smoothness of the water, the reflection of the trees with which the banks are fringed, and the fertility of the very rocks which form the points and angles, produce a mixed sensation of surprize and pleasure, which is difficult to describe.




---

p.16


There is a stillness and tranquility in the air of these retrats, that is uncommonly engaging, and sets the imagination to work, to conjure up forms and build castles in every one of them; the accessary ideas give new life to the scene, and the mind returns with additional ardour to contemplate it. In some places you are presented with an abrupt shore, and rocks of unchiselled marble hollowed into caverns; in others, the level beach, covered over with smooth green carpeting, seems to court your approach by a display of internal scenery. Here you meet with a promontory, rising from the lake with the majesty of a Colossus; there stands another, the Parnassus of **Silvanus**, adorned with every chosen shrub in which the God delights: and woe to the dull mortal that hears him not, as he passes, rustle among the thickets; for lo! even now he emerges, and the dispensing fragrance as he ascends, looks down with benign complacency upon 



---

p.17



those happy regions, for which he has rifled the gardens of **Flora**, to rival her once favourite Tempè.
*Deus, ecce Deus!’’*




**Mucrus Abbey** is situated upon an eminence, rising over the lake, near the northern extremity of this range. It is in tolerable preservation, and still serves as a burying-place to the inhabitants of the neighbourhood. A modern hermit, some years ago, pitched upon it as the place of his retirement. He chose an open cell, in one of the upper apartments, for his mansion; and formed a defence for himself against the inclemencies of the weather, from the shattered remains of the tombs and coffins. His vow was not rigldly strict; for he sometimes mixed with the world. He was communicative enough on some subjects, and, as I have heard, tolerably well informed. But at length he sullied the lustre of his character, by indulging in the sordid unmanly vice of private drinking,



---

p.18



oftentimes to intoxication; till finding the veneration he was held in daily diminish, he abandoned a scene where he could no longer appear with credit. He was an Englishman, and, when he left **Killarney**, proposed going to the **Rock of Lisbon**. There is certainly no place better adapted to a recluse than this, especially if he possesses any degree of enthusiasm, as there is none which can compensate the loss of social enjoyments by such a variety of contemplative ones. The greatest curiosity of the abbey is a yew planted in the centre of the building. Its trunk is between seven and eight feet in circumference, and its boughs form a compleat covering to the cloister, which is a square of twelve yards. My **Cicerone**, pointing to a wound in the bark of it, told me with a very grave face, that the wretch who had the hardiness to inflict it, paid the full price of his sacrilege: for that a numbness instantly seized the guilty arm, spread gradually



---

p.19



over his whole frame, and in a few minutes dispatched him. The abbey is too much shut up by trees; it might be so managed, by a delicate hand, as to become a fine object of view, without being entirely dragged from its retreat, and exposed to open day. An objection of the same kind lies against the situation of **Mr. Herbert**'s house, which, in the midst of the most desirable objects enjoys a very limited prospect of the lake, and appears to no advantage itself. The gardens are not dressed with care; and would deserve little notice, were it not for the extraordinary ledges of rocks which run through them. These have not the least covering of earth to defend them, and yet rival the most luxuriant spots in their produce. They are cloathed from one end to the other with shrubs and trees, which seem to draw their juices from the very marble itself, as the crannies and pores, from which they issue, are so scantily provided



---

p.20



with mold, that it is difficult to conceive it sufficient for their nourishment. It is wonderful how pliably they accommodate themselves to the several windings and crevices of the stone, and how artfully their roots are disposed for the reception of every drop of moisture; and their great variety, some of them the most tender, delicate shrubs our climate admits of, still adds to the surprize. The service-tree grows here spontaneously; the vine flourishes; the common fruits are the produce of every cliff; the **arbutus** seems indigenous; the lilack, rose, **laurustinus**, and **cytisus**, require no other culture than that of the pruning knife; every neglected spot in this wilderness of sweets is enamelled with flowers, and fragrant herbs, and plants loaded with blossoms, or berries.


> 1. Dum vagor aspectu, oculosque per omnia duco
>   
> Calcabam, nec opinus, opes.
> 




I observed, almost universally, in the trees springing 



---

p.21



from these rocks, that the part of the trunk contained within the stone was much smaller than the external, sometimes by several inches in the diameter; ——a proof of fertility this, which renders all others superfluous.


From the house at **Mucrus** to the exreme point of **Camillan**, there runs a winding road of near two miles in length, very judiciously calculated to unfold the interior beauties of the Peninsula: (for it is a Peninsula, and as one side encloses the **Great Lake** to the East, the other forms the northern boundary of **Turk Lake**.) Here there is a vast number of those rocks and craggs, vegetating from every pore, differing in shape and situation, and thrown without order into irregular groupes, which afford new landscapes as you advance, and every instant present different combinations and figures. They generally lie at a considerable distance from each other, and are separated



---

p.22



by low marshy swamps, which produce nothing but heath, and the common aquatic shrubs; by which means they have much the appearance of islands. And here I cannot help indulging a conjecture, that the islands in the lake itself have been, at some distant period, situated as these are: and that, by the stoppage or interruption of the great outlet from the lake, or an additional influx into it, the body of water bas been so increased as to insulate the higher grounds; and that the continuance of the cause has rendered the separation permanent. It is certain this conjecture appears more probable, if we consider the near resemblance of many of the islands to the rocks I have just described, and their proximity to the level shores on the north and east sides of the lake, where the water is comparatively shallow. It might be further confirmed by similar instances: and particularly by the instance of **Lough Neagh**, in the 



---

p.23



province of **Ulster**; which has for many years past gained on the land, as is clearly evinced by a late writer. But as I cannot support it by testimony or observation, the only sure grounds to build upon, I give it as a bare probability.


Nearer the point of **Camillan** the surface is less varied by detached heights, and risings, and more uniformly wooded. It is of a very stoney nature, and almost every where covered with a thick moss, which is here ornamental. As the lakes lie on both sides, with their islands and mountains, how greatly might the charms of this spot be enhanced, by introducing them judiciously in different views and situations? which, by the simple management of leading a path from one side to the other, now skirting the bays, and now ascending the heights, might easily be accomplished. And how much might the views from the lakes be improved, by here and there opening up



---

p.24



the bays and recesses, and allowing the eye to penetrate into the more remote scenes, as if by stolen glances? To mutilate nature is inhuman, to aim at excelling her is madness: It is the province of art to withdraw the veil that conceals her beauties, and discover them in all their wildness.


The side of the peninsula, which forms the northern boundary of **Turk lake**, so nearly resembles the other, that what **Ovid** says of the sisters of **Phaëton** is literally true of them: they have the same general air and complexion, though they differ in particular features. The whole Peninsula is the property of **Mr. Herbert** of **Mucrus**, whose estates in this country are very considerable: his ancestors were among the first English settlers; and tho' he generally resides in England, his tenantry seem to enjoy more happiness, than ordinarily falls to the share of the deserted Irish peasant; who, between intrinsic indolence and external



---

p.25



exaction, penurious in the midst of plenty, wanders upon the surface of the most fertile country in the world, a melancholy instance of complicated misery.


The eastern shore of **Turk Lake**, L, is distinguished by no particular beauty I know of: it is formed by the bleak side of **Mangerton**, and separated from **Turk**, the mountain which confines the lake to the South, by the **Devil's Stream**. This stream has its source near the top of the **Mangerton**, which is esteemed the highest ground in Ireland. [2](javascript:footNote('E770001-001/note002.html')) Its source is a vast cavity in the mountain, fed by the discharge of the clouds, which are daily bursting over it. The natives



---

p.26



stile it **the Pit of Hell**, but it is more commonly called **the Devil's Punch-bowl**. It sometimes sends down very impetuous torrents, which sufficiently mark their course by their ravages: to this it probably owes its original name.


**Turk**, M, though not so lofty as **Mangerton**, is a much nobler object. Its outline is free and graceful, rising to a point by easy gradations, and sinking towards the plain in such a manner as to form an irregular cone. The side towards the lake is quite inaccessible, and to the eye below has a wild air of grandeur, occasioned, as I conceive, by the uniformity of its appearance, which prevents no gaudy colourings to divert the mind from contemplating the single idea of its extent. It is entirely without trees, which as it contributes to the above effect, and affords a striking contrast to the shady banks of **Mucrus**, is hardly to be regretted. The river **Lane** rises near the summit, 



---

p.27



and is seen throughout its course, which is a very direct one: it gives its name to the whole lake, anciently called **Loch Lein**.


Between the Peninsula, and the low land which stretches from **Turk**, lie the islands **Brickeen** and **Dinish**, which separte the two northern lakes. They are divided from the shores by very narrow straits: that between **Brickeen**, and the Peninsula, which is the widest, not exceeding twenty yards. Both these islands are richly wooded, and abound with luxuriant **arbutus**; they serve as resting places to the deer, which descend from **Glená**, at the dawn of morning, to feed in the plains and meadows of **Mucrus**; and here too they often shelter themselves, when roused by the hunters, and driven from their more secret haunts on the mountains.


**Dinish** extends to the very mouth of the river which flows from the upper or southern lake; and, by the 



---

p.28



opposition of its sides, distributes the stream into two unequal channels. The river issues from the northern side of the lake, and with all its windings and angles, measures four miles. The eastern bank, N, presents nothing interesting; it is low, craggy, and infertile, scarcely producing a shrub or tree. The high grounds, at some distance, which extend from **Turk** to the southward, though by no means picturesque, are a relief to the prospect. The opposite bank is skirted by the shaggy sides of **Glená**, that runs into the country in this direction for a considerable length: its appearance here is not so varied, as from the lower lake, but is still pleasing; it is terminated to the South by the **Eagle's Nest**.


This remarkable rock, O, presents it principal front to the North, and the river, making an abrupt turn, passes directly under it. It has bold freedom in its general outline which sets at nought description, 



---

p.29



and demands the pencil of **Salvator** to express justly. From the ruggedness of its impending cliffs, which almost overshadow the river, it would be truly aweful, if the trees and shrubs which cover them, did not counteract the effect, by diffusing an air of festivity over the whole, which strips it of its terrors. The parts of it, considered singly, are beautiful: their strange combination produces surprise. The effect of a musket or peterara discharged against this mountain, exceeds every thing I had conceived possible. The report is encreased to a degree almost incredible, and returning upon the earth in reverberated peals, now from the neighbouring, now from the more distant mountains, imperceptibly dying away, and again reviving, till it finally expires in hollow, interrupted murmurs, bears a nearer resemblance to natural bursts of thunder, than any thing artificial. The mountain is inhabited by Eagles, which build 



---

p.30



their nests on the craggs, and inaccessible heights, and are continually hovering round it: like true birds of **Jove**, they seem to have chosen it for their abode, from the allurement of its pealing echoes.


The mountain which runs from the **Eagle's Nest**, to the upper lake, is two miles in length. It is one continued ridge without break, or rising: and from its figure, and inclination, is with singular propriety called the **Great Range**, P. Near the upper end of it is the seat of the musical echo. The spot where it is situated is a hollow bosom in the mountain, covered on all sides with trees. The sounds are reverberated from the several parts of it, and are softened upon every repetition, so as to terminate in the sweetest cadences. A single horn produces a concert, and is multiplied into as many instruments as there are echoes; these mellowing in their tones, from the original note of the leading instrument, to the dying falls of the last repetitions,



---

p.31



and mingling together in a wild, but an harmonious confusion, afford the finest specimen of natural music in the world. The power of the echoes might easily be ascertained by breathing a single note on any instrument, or by the voice; and afterwards, it would be an easy matter, at any period in a passage of music, to determine the number and quality of the sounds, which are employed in expressing it.


The southern lake, which is entered by a narrow pass called **Colman's Eye**, stretches East and West for above a league, but does not any where exceed three quarters of a mile in breadth. It has a different air from the others, being encompassed on all sides by high grounds and mountains.


**Ghirmeen**, Q, one of the most considerable of these, forms a right angle with the **Great Range**, and bounds the lake to the North. It is partially covered with trees, and on the whole has rather a pleasing, 



---

p.32



than a bleak appearance. **Arbutus Bay** is the finest it affords; it derives its name, as well as a great share of its beauty, from an island contiguous to it. The mountain is the property of **Mr. Herbert**.


**McGilly Cuddy's Ricks** take their rise from **Ghirmeen**, and encircling a valley, R, of pretty large compass to the West of the lake, from an extensive amphitheatre. These mountains are very numerous, and, as if Nature meant to exhaust their varieties, are broken into the most irregular, whimsical shapes imaginable. They seem to be quite destitute of planting, and indeed their fertility, at the distance most of them lie, would contribute little to thier beauty. They are plentifully flocked with grouse, or, in the language of the natives, the hen of the heath, notwithstanding the depredations of their joint commoners the Eagles. They furnish the lake with its principal supplies of water, which tumbling down in a 



---

p.33



multiplicity of channels, unites in one stream at bottom, and enriches the valley. The valley owes nothing to culture, though to all appearance capable of it: a few wretched cottagers derive from its borders a penurious subsistence. Its shore is distinguished by one of the those singular rocks already described; to those who see it at a distance, it has the appearance of an island; and by small elevation of the water would actually become one. The whole circuit is now possessed by **Mr. Herbert**; it formerly belonged to the ancient family of **McGilly Cuddy**, whose name it still bears. The mountains are called Ricks, in allusion to their shape, which approaches nearer to a cone than any other regular figure.


The southern boundary of the lake is formed by a range of high mountains. **Cahirnee**, S, which joins the Ricks, is the largest of them, and belongs to **Lord Shelburne**:



---

p.34



it is distinguished by a waterfall, but is no otherwise remarkable. Towards the eastern angle this range terminates in a sloping bank, which forms one side of the Glynn of **Derry Cannihy**. This Glynn, T, gradually contracting as it retires from the lake, loses itself in another, still more extensive, about a mile distant. Its sides are covered with very stately timber, particularly oaks; and it affords a delightful repose to the eye, fatigued with reiterated mountain prospects. The **Kavoge** rolls a considerable stream through the center, which tumbling down a rocky channel where it forms a variety of lesser falls, makes the woods and caverns vocal. The Glynn belongs to **Lord Kenmare**, who is now preparing to disrobe it of its trees, as well as adjoining mountain **Derry-Dimna**. Where the Genius of the lakes, or some more persuasive Divinity, will have power to stay his uplifted



---

p.35



axe, time will determine. The determination, with respect to his Lordship's taste, will be final.


May no future traveller have occasion to quote here the mournful lines of **Virgil**!


> 1. Itur in antiquam silvam, stabula alta ferarum.
>   
> Procumbunt piceae, sonat icta securibus ilex,
>   
> Fraxineaeque trabes; cuneis et sissile robur
>   
> Scinditur: advolvunt ingentes montibus ornos.
> 




**Crom-aglaun**[3](javascript:footNote('E770001-001/note003.html')), which belongs to Lord Kenmare also, confines the lake to the East, U. It extends from 



---

p.36


**Derry-Cannihy** to within a mile of **Turk**, and, though no where lofty, is one of the largest mountains in the neighbourhood. Its sides are covered with a luxurious copse, which reaches down to the water's edge: and its modest height, compared with the aspiring cliffs over-against it, gives it the appearance of a larger hill. The foot of this mountain is washed for a considerable length by a narrow confined bay, lying parallel to the river. This bay has no beauties to boast of; its western side is bleak and barren, and it is quite destitute of islands.


The **Purple Mountain**, though not immediately touching upon the lakes, is an object of curiousity not to be passed over, W. It rises from behind the **Great Range**, in a conical shape, and is strongly characterised by its deep indigo colour. It abounds with a kind of heath, found in no other part of the country, which produces purple berries; but receives its prevailing



---

p.37



 tinct from another herb, used by the natives in dying. This is probably the **Lichenoides saxatile foliis pilosis purpureis**, found by Doctor Smith in an adjoining Barony, though overlooked by him here. It affords shelter to a bird, so little known in **Kerry**, that as yet it has no popular name. This bird, as it was described to me, is somewhat larger than a grouse; its breast red, the rest of its plumage a clear shining black, except the wings and tail, which are interspersed with white feathers. Whether this be of the same species with the heath cock, so common in Scotland under the name of the black game, I know not: I am sure I have heard, that the heath cock of the Highlands delights in the purple-berried heath, and resembles our rara avis in colour.




---

p.38


Section II
----------


I have now given a general sketch of the confines of the lakes, and their most remarkable bays. The islands are no less worthy of notice; though, from their number, situation, and varieties, so difficult to describe, that I despair of conveying any distinct conception of them.


The number of islands in the lower lake exceeds thirty. They are dispersed without order, along the level shores to the East and North; for to the South and West, there is one unbroken sheet of water. A few of them lie unconnected, but the greater number is distributed into two irregular clusters, or archipels, on the opposite sides of the **Ross**, X, Y. This island is the largest in the lake: it lies to the East of **Reen Point**,



---

p.39



about a mile from the village of **Killarney**. A very narrow gut, scarcely navigable for boats, separates it from the shore; and over this there is a bridge thrown, for the conveniency of the castle. The castle stands on the land side of the island, and was formerly a royal residence; being the seat of the Lords of the Lake, who assumed the title of Kings. The family of **O'Donahue** was the last that bore this title: its present representative enjoys a degree of respect from the country-people in right of his ancestors, but their power has been long extinct, and their property is now passed into other hands. The great O'Donahue, the hero of this ancient race, still survives in the praises of his countrymen; who set off his virtues with the colourings of enthusiasm. They represent him like the Demi-gods of old, a contemner of danger, a sworn foe to oppression, a passionate admirer of whatever is great and honourable. The 



---

p.40



severity of his warlike virtues was tempered, say they, by a generous hospitality, which embraced a Friend in every Stranger: The rigour of the Legislator was blended and lost in the endearing condescension of the Friend; the Prince was the Father of his country. His court was the seat of joy and festivity: worth took its place at the boards by inherent birthright, grey hairs received their reverence, distressed innocence had a peculiar plea of admission, for humanity was paramount, and suspicious policy absolutely unknown. He was wise too, and the God sped his councils, for his subjects were happy. Fruitful seasons crowned the year with plenty, and undisturbed tranquility led the way to enjoyment. 'Twas the reign of **Pan** in **Arcadia** nor were the shepherds ungrateful; for every valley resounded with his praises: nor was their patron unpropitious; for death, that extinguished his earthly lamp, seemed to rekindle his love.




---

p.41


And still he reigns to bless them; and to his unseen protection do they hold themselves indebted, for every gift of fortune. Often as the hind returns to his cottage, by the favour of the moon's pale light, are his eyes blessed by the figure of the good old King amidst a train of his attendants; his silver locks floating in the breeze, his limbs invested with a robe of regal dignity, and superbly mounted, like the twin brothers of **Helena**, upon a milk-white courser. Such a vision is considered as the happiest omen of good; it is reported with ecstasy, and listened to with transport: there are no unbelievers; even to hesitate were heresy: and why should we wonder? **O'Donahue** is the **Hercules** and **Quirinus** of this retired people, their San Januario, their Julium Sidus. The ancient tribute of the kings of Munster to this prince, was ten dun horses, ten coats of mail, and ten ships [4](javascript:footNote('E770001-001/note004.html')) This gives us the idea of a powerful chieftain, possessed



---

p.42



of a navy, in those days, truly formidable. The castle, which has a non-resident governor, now serves as a barrack for infantry. From the top of it there is a good view of the island, which appears low and swampy, and rather narrow for its length. It is every where covered with trees, unless where it has been industriously cleared, which is the case around the castle, and from hence to the opposite shores. The winding Peninsula towards **Innisfallen** is particularly pleasant: the bays and creeks are much like those at **Mucrus**, but the happy situation of the surrounding islands gives them many additional beauties.


**Innisfallen** lies at a small distance to the Westward. It is not so extensive as **Ross**, but much more beautiful. Its shape is triangular, and its sides, from promontory to promontory, are hollowed into bays. The soil is exceedingly rich, and the verdure perpetual. The cattle that feed upon it testify to its fertility. Its



---

p.43




 surface is naturally moulded into a variety of sweeps and banks, which are cleared of underwood, and shaded by well-grown trees. Near the north-east promontory are the ruins of an abbey, and what the boatmen call a banqueting house. The abbey is a very paltry building, and was probably rather an occasional retreat for the good Fathers at **Mucrus**, than a seat of a distinct Brotherhood. Such retreats, with all reverence be it spoken, are less agreeable to the Anchorite, than **Caprea** was of old to the Roman Emperor. Whether it is, that the extremes of vice, and the rigours of virtue, equally decline observation; or that affected sanctity, and avowed sensuality, though looking different ways, aim at the same objects; or that a suspension, and perversion of the human powers, produce familiar effects; I leave to the curious to determine. Certainly here might **Virgil** find the realities of his beautiful descriptions, 



---

p.44



> 1. ——Hic laetis otia fundis,
>   
> Speluncae, vivique lacus; hic frigida Tempe,
>   
> Mugitusque boum,—
> 



and, looking upon the distant mountains, he might still subjoin,
  

*Non absunt illic, saltus, ac lustra ferarum.’’*




The Hermit I have before mentioned, frequently shut himself up here; subsisting, as he made the country people believe, upon rats and other vermin: but they were deceived as usual; for the bounty of strangers, who almost daily touched on his island, supplied him with food better suited to his palate, and his private resources made up their deficiencies.


The low island to the Westward is inferior to Innisfallen in every thing but extent. It is called **Brown Island**, from its colour, and **Rabbit Island**, from its being stored with those animals. There are no trees



---

p.45



 upon it, and its only covering is fern: It seems to be placed here as a foil to the others.


The remaining islands of the western cluster, are of a less size, and more contiguous to the shore, than those I have spoken of. **Lamb's Island** is the largest of them: it is finely wooded, and is indeed **Innisfallen** in miniature. **Hern Island** lies South East of Lamb's: it is small, but wooded. O'Donahue's Prison, and **Mouse Island**, complete their cluster; and, tho' naked rocks, are not destitute of beauties: they derive their names, the one, from its resemblance in some views to a house; the other, from its diminutive size.


The islands which compose of the eastern cluster, Y, though smaller, are more numerous. **Garvillan**, or **Rough-Island**, at the east point of **Ross**; and **Alexander's**, nearer the shore; are very little raised from the surface of the water. **O'Donahue's Table** is a 



---

p.46




naked cragg, by gradual dilapidation worn into cavities. The other islands rise boldly to a point, and are counter parts of the vegetating heights at **Mucrus**. They are in general finely fringed with evergreens, which cover their angles and unevenness; and are peopled by distinct tribes of birds, that feed on land in the day, and return at the dusk of evening: The jackdaw, pigeon, hern, eagle, and osprey, have all their separate habitations.


Besides these which lie in irregular groupes, there are several single islets scattered along the shores of **Mucrus**. **Friars Island** is contiguous to the abbey; **Oak Island** more distant; and another, which produces junipers, still farther to the South. **Cannon Island**, a white rock of **Camillan**, is remarkably well situated for shewing the power of the echoes. A gun mounted here, and pointed against **Glená**, must produce a striking effect; for **Turk**, the **Eagle's nest**, and the 



---

p.47



several mountains on the opposite sides of the river, would serve as so many conveyances to transmit the undulations to the upper lake, and multiply the repetitions.


**Brickeen** and **Dinish**, which lie in the mouth of **Turk Lake**, have been already described: the only other island in this lake is **Illanan-Deoul**, the **Devil's Island**: it is lofty, steep, but not wooded.


The upper lake contains eight islands, which are all worthy of notice. The **Oak Islands**, or **Rossburkree**, separated only in winter, are the most considerable; and lie in the south-east part of the lake, opposite the mouth of the river. They are richly covered with timber, but particularly the eastern, which must yield up its oaks at the same time with the adjoining **Glynn**: they are rugged, and uneven, though no where hilly, and stretch away in length.




---

p.48


**Arbutus Island** lies over-against **Rossburkree**, half encompassed by a shady bay. Its shape is pyramidical, and its rocky sides are covered with strawberry trees. In the latter end of October, when I first visited **Killarney**, they were in high beauty; many of their bells and blossoms still remaining, the fruit on some just forming, and on others nearly ripe. The same bough often exhibited all these varities. The ordinary height of the tree is ten, or twelve feet; but I have seen some of happier growth which rose to eighteen or twenty. The blossom is shaped like a goblet, and the fruit nearly spherical: it is at first of a pale yellow, which deepens as it advances to ripeness, and gradually gives place to a rich scarlet. It equals the largest garden strawberry in size, but must be eaten with more caution, for those who are unaccustomed to it, and indulge too freely, are seized with an oppression little less than lethargic: This I take 



---

p.49




upon the credit of the country people, who use it themselves without reserve, generally accompanying it with a hearty draught of water, to qualify its juices. The **elder Pliny** calls this fruit **Unido**, because no more than one berry can be eaten at a time with safety: but **Virgil** makes it the common food of the first inhabitants of the earth, following **Lucretius**, who ranks it with the acorn itself, and tells us that in the earlier ages it grew to an extradinary size, and was found in great abundance.


> 1. Glandiferas inter curabant corpora quercus
>   
> Plerumque; et quae nunc, hiberno tempore, cernis
>   
> Arbuta, paeniceo, fieri matura, colore,
>   
> Plurima, tum tellus, etiam majora, ferebat.
> 


*’’*

Lucretius Liber V




The arbutus was no less esteemed among the ancients for its pleasant shade, than its fruit; as may be discovered from the poets, and particularly from **Horace**,



---

p.50



the admirer, and best judge of whatever is elegant in retirement.


The remaining islands, to the number of five, lie together in a cluster, Z, at the west end of the lake, about half a mile from the shore. They are beautiful in themselves, and are so grouped as to form a delighful assemblage: They are all lofty, all wooded; and the bold broken craggs, and angles, in many places overhanging the lake, seem to forbid the approach of human footsteps, and consecrate them to their native ospreys and eagles. But man has notwithstanding intruded: for in the central one, which is only accessible in one spot, there is a cottage raised under shelter of the rocks, and trees, which is occupied every season. The cottage is composed of timber, interwoven with boughs; and so matted, and covered in, with leaves, and sedge, as to form a comfortable habitation. The gentleman to whom it belongs,



---

p.51



visits it twice a year, for the benefit of shooting and fishing: he sometimes continues for two entire months, as much secluded from the world as an Indian in **Ontario**, or **Mishigan**: He is a man of independent fortune, and, as I have been told, a bachelor.


In traversing his little island, I observed it was carpeted over with a thick covering of decayed leaves, and boughs. I could easily discover the strata of the several past years, by the different degrees of putrefaction, till near the bottom, where the dissolution was more complete, they were cemented into one uniform mass, condensed by the pressure above, and so swoln by the rains and moisture, as not to be at all distinguishable. As the decay was more perfect, the colours declined more perceptibly from the original lighter tints, ending, in the bottom, in as perfect a black, as I ever saw in any of our bogs. The similitude of the contexture, as well as the colour, convinced



---

p.52



me, that the black bogs with which Ireland abounds, have been formed by the same process: a process which is probably forwarded, by the continual moisture, and rains, in a climate, neither burnt up by scorching heats, nor congealed by the rigours of cold.


This inhabited islet is the centre of the groupe; to the South-west of it lie **Stag**, and **Hind**; and McCarthy's, and the **Eagle's Rock**, to the North and North-west.




---

p.53


Section III
-----------


The objects we have just taken a review of, gave me such pleasure in the contemplation, that I cannot help wondering at those, who profess themselves disappointed in them, and affect to decry them: Men should be cautious in admitting preconceptions. If they expect to see something altogether great, and stupendous, in a circuit of ten or twelve miles; the variety of objects, and the narrow limits of the scene, must necessarily disappoint them: for greatness in natural objects requires an unbroken uniformity of appearance, and that uniformity reigning over a wide extended surface. If they look for the aweful and terrible; the happy temperature of the climate, which cloaths even the rocks and precipices with a



---

p.54



rich covering, and overspreads the rugged face of the mountains with luxuriance, is a natural bar to it. But if beauties will content them, in every degree of the scale, from wild magnificence downwards; it is strange to me if they go away unsatisfied. Indeed what can be more beautiful, than the several views of a fine piece of water, studded with islands, encompassed by mountains, resounding with waterfalls, and reflecting, on all sides the umbrageous trees, and evergreens, that adorn its banks? What can be more surprising than the fertility of the rocks, where the trees, too ponderous for their feeble roots, are often bent towards the earth, and flourish thus distorted? What more curious than different species of shrubs springing from the same decayed stock; which, no longer able to push forth leaves itself, serves as a nidus to others? And is there any thing more wonderful than the power of echoes; which not only multiplies



---

p.55



and reiterates the most ordinary sounds, but swells them to the pitch of natural thunder?


To hazard an opinion: the prevailing character of **Killarney** is Variety; the second Beauty; Magnificence is subordinate. Here Beauty, by her magic, and diffusive influence, gives a grace to Variety; whilst Variety furnishes her benefactress with flattering contrasts: United, they present the fancy with the most delightful images, of repose, tranquility, unstudied order, natural wildness, and rural magnificance.


Objects, desirable in themselves, derive new beauties from their position with respect to others: and even such as excite no pleasing emotions when viewed singly, have often an agreeable effect in combination. But these relative beauties, as they result from the harmonious proportion of a number of parts, are entirely lost by an injudicious jumble of them; so 



---

p.56




that to see a multiplicity of objects to advantage, it is necessary to class them with taste, and consider them in those lights and points of view, where they neither run into a perplexing confusion, on the one hand, not a tiresome sameness, on the other.


The most magnificent view of the Great Lake and its environs is that from the Yellow Mountain (1), about two miles to the Northward. The eye passing over a rich valley, meets the lake in the centre, with the **Eagle's Nest**, and the other mountains which stretch to the upper lake, behind it: on the side are **Glená**, **Tomé**, and **McGilly Cuddy's Ricks**, which lose themselves to the Westward; on the other, **Turk**, **Mangerton**, **Glanflesk**, and **the Paps**, in the opposite direction; all together forming a range of more than twenty miles. The waving outline of these mountains is uncommonly beautiful: the lake is happily placed in the centre; and there is a degree



---

p.57



of unstudied regularity in the whole, which, added to the majesty of the single parts, makes a noble, regular, and striking picture.


Aghadoe (2) was of old an episcopal seat, and a place of some consequence: a ruined turret, and the shattered walls of the cathedral are the only vestiges of it remaining. It stands on an eminence to the North of the lake, near the western extremity, and commands a most extensive prospect of its borders, and islands. Innisfallin, and the Western cluster, appear from hence in perfect beauty: the shaggy sides of **Glená**, and **Tomé**, are finely opposed to the level shores; the distant islands, referred to their contiguous banks, have the air of so many promontories; and the stately mountains, **Turk** and **Mangerton**, rising from behind the peninsula of **Mucrus**, complete one of the most beautiful scenes in nature.




---

p.58


**Dunlow Castle** (3), the seat of **Mr. Crosby**, is the best station for viewing the lake from the West. It stands on a perpendicular cliff over the river **Lune**, about a mile from its source, and with the surrouding scenery is a very fine object. From hence the islands are seen in a different, but less pleasing situation; the view is bounded to the right by **Tomé**, and **Glená**; and, taking in the sloping bank, and the village of **Killarney**, to the left, terminates agreeably on **Mucrus**, and the high grounds beyond it: The several doublings, and turns, of the river, that winds through the rich valley beneath, have a pleasing effect: and for a contrast, the bleak sides of the **Ricks**, and the hollow Glynn which divides them from **Tomé**, afford one sufficiently glaring.


The views from the East (4) are very numerous, and beautiful: there is scarce a break, or height, along the Peninsula, that does not present a new face



---

p.59



of things, or a different arrangement of them. The eminence near the abbey, the meadows and gardens at **Mucrus**, and the point of **Camillan**, where **Turk**, **Glená**, and the **Eagle's Nest**, meet the eye at once, must be noted by the most careless observers.


To those who would have a perfect knowledge of the lakes, the top of **Turk** (5) is the best station. From thence they appear as distinctly, as if delineated on canvass; but the minuter beauties are lost by the height of the mountain, and at best, a prospect from such an overtopping eminence, is better calculated for the Ichnographist, than the man of taste and fancy.


From the side of **Mangerton** (6), about one fourth of the common ascent, there is a very commanding prospect of the Great Lake, and the adjacent country, which shews the objects more in the light of perspective than that from **Turk**, at the same time that it 



---

p.60



preserves the natural arrangement of the islands, and the sinuosity of the bays. Here the Peninsula seems to float on the surface of the water like a vast serpent, and, when illuminated by the sun's rays, displays its green spiry length, every where distinct with shinning beauties, in a manner at the same time singular, and pleasing.


From the top of this mountain, ascended by a tedious path of three miles, the prospect is wild, commanding, and in a manner unbounded. On one side lie the lakes, diminished almost in the scale of Shakespear's fancied simpler: On the other, at some distance, the noble river of **Kenmare**, along which the eye passing for near thirty miles reposes at length on the swelling bosom of the **Atlantic**. On all sides save one the country is mountainous; to the East the mountains trend away in an irregular ridge, till obscured and lost in the opaque vapours; to the West, and indeed 



---

p.61



in every other direction, they are thrown together in as tumultuous, and wild assemblage, as if Chaos had been here arrested in his billowy career, and chained to stability by the supreme fiat. The lakes are seen from hence but partially, and in truth appear only as a drop of water, to the vast ocean in view: while the mountains which encompass them, compared with **Mangerton** itself, hide their diminished heads, declining all rivality. Taken together, tho far inferior even to the maritime **Alps** in grandeur and as much to the mountains in **Switzerland**, and the **Esterelles** in **Provence**, in fertility, they exhibit an appearance of nature so uncommon, as must furnish the best informed fancy with new, and picturesque images.


And now, traveller, having satisfied thy curiousity plod thy way downwards; for the clouds begin to marshal, the vapours to accumulate, and soon will the 



---

p.62



scene thou gazest at vanish, and the spot where thou standest become the seat of darkness; unless thou indeed wouldest inhabit the clouds, and *sensibly experience* the palpable Obscure, which thou hast only *read of* in **Milton**.


The most desirable view of the upper lake is from the East, on the cliffs of the **Crom-a glaun**, or **Bolinendra** (7). The islands, and mountains, are seen from hence in a very happy arrangement; and there is a certain air of wildness in the prospect, which borders on the romantic.


These are some of the views from the banks, and eminences, in the neighbourhood of the lakes, that appeared to me the most pleasing. Those from the lake itself, though not so extensive, are no less beautiful; but they are so numerous, and it is so difficult to convey an adequate idea of their nice varities, and 



---

p.63




differences, that I shall barely hint at one or two in the most distinguished classes.


**Turk**, when viewed from the lake below (8), has some pretensions to grandeur: it rises to a respectable height, fills the eye with an unbroken surface of two miles in extent, and is one great and uniform object: but greatness is a relative term, and that degree of it we speak of, is rather calculated to give the mind a certain taste of grandeur, than to satisfy it with a complete idea.


From the river immediately beneath (9), the rugged appearance of the **Eagle's Nest** inspires surprise, and awe; but the sportive hand of Nature has so managed it, that these feelings never border upon that anxious uneasiness which attends the contemplation of objects, properly speaking, terrible.


From the upper lake between **Arbutea**, and **Rossburkree** (10), the western isles are seen at a due distance, 



---

p.64



and appear to great advantage. The eye is confined on each side by two uniform risings, and the background of the picture is occupied by the amphitheatre of mountains which encompasses the western valley. There is a beauty in the islands, a wildness in the mountains, and a magnificence in the air of the whole prospect, which not only amuses the mind, but seems to exalt and expand it, and awakes such sentiments as one feels from a sublime passage in **Homer** or **Milton**.


The effect of many of these views is, in my opinion, much heightened by the hourly revolutions in the face of the heavens. The vast volumes of clouds, which are rolled together from the **Atlantic**, and rest on the summits of the mountains, cloath them with majesty: the different masses of light and shade, traversing the lakes in succession, as the shifting bodies above float across them, exhibit all the varities of



---

p.65



night and day, almost at the same instant: the mists interposing their dull, yet transparent coverings to the view, raise new desires of a fuller, and clearer prospect: and the wandering vapours flitting from cliff to cliff, as if in search of the clouds from which they have been separated, amuse the eye with their varities, and irregular motions.


After all, this happy spot labours under one disadvantage, and one too I am the more averse to mention, since so celebrated a writer as **Doctor Johnson** has thought it sufficient, in the case of **Loch Lomond**, to counterbalance so many natural beauties; and this is no other than the immense rains; which fall here more abundantly, and that even in the best seasons for visiting the lake, than in all other parts of the kingdom. But surely Philosophy will suggest many topics to quiet our complainings on this head. She will tell us, that to expect perfection in things sublunary,




---

p.66



is to wish where we cannot hope: that the cup of Pleasure, even when presented to us by the pure hand of Benevolence, is never without some unpalatable ingredients: that where Nature has provided us with so rich a repast, where she has displayed such enchanting scenery to the eye, and gratuitously accumulated all this variety of enterainment; we ought to enjoy her bounties, in the time, manner, and circumstances she chuses to exhibit them. But if we should further discover, that the limitations she sets to our pleasures, are necessary to our being pleased at all; that what we call a disadvantage is the spring and source of all we admire; that the Hyades are here the handmaids of **Flora**; for that without these perpetual effusions of rain we complain of, the rocks must resign their vegetable inhabitants, the rivers mourn their exhausted urns, and the cascades no longer resound save in the dull ear of Memory; that 




---

p.67




the living lake itself must dwindle into an inconsiderable pool, and the mountains, stript of their honours, become a dreary waste, the abode of gloom and barrenness: In this case, surely, our complaints must be turned to admiration, and our regrets to a grateful acquiescence. Shall we not here exclaim in the spirit of **Homer**!


> 1. With gold-embraided locks, the exulting Seasons
>   
> Received her from the hands of forming Nature;
>   
> And round her silver margin did encircle,
>   
> With never-fading forms, umbrageous hills,
>   
> Sweet vocal vallies, plains enamel'd o'er
>   
> With many a flower.
> 




The End





