

#Ultor De Lacy


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


Ultor De Lacy
=============


Author: Joseph Sheridan Le Fanu
-------------------------------


### File Description

Funded by University College, Cork and  
Writers of Ireland II ProjectElectronic edition compiled by Beatrix Färber

 1. First draftExtent of text: 11000 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland.

 (2006) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E860000-002Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

*Ultor De Lacy* was first published anonymously in the *Dublin University Magazine* in 1861.

#### Sources


**Editions**2. Joseph Sheridan Le Fanu, Madam Crowl's Ghost and other Tales of Mystery, collected and edited by M.R. James, London: G. Bell & Sons Limited, 1923.
3. Joseph Sheridan Le Fanu, The collected works of Joseph Sheridan Le Fanu, 3 volumes; introduction by Sir Devendra P. Varma, New York: Arno Press 1977. [Facsimile reprint of 1871 edition.]
**Further reading**2. W. S. Trench, Realities of Irish Life, London 1869.
3. [Anon.], The late J. Sheridan Le Fanu, Irish Builder 15 (February 1873) 50.
4. [Anon.], Joseph Sheridan Le Fanu, Dublin University Magazine 81 (March 1873) 319–320.
5. William Richard Le Fanu, Seventy Years of Irish Life, London 1893.
6. [Anon.], Memoirs of Father Healy of Little Bray, London 1895.
7. S. M. Ellis, Bibliography of Joseph Sheridan Le Fanu, Irish Book Lover 8 (October-November 1916) 30–33.
8. Thomas Philip Le Fanu, Memoir of the Le Fanu Family, Manchester [1924].
9. Edna Kenton, A Forgotten Creator of Ghosts: Joseph Sheridan Le Fanu. Possible Inspirer of the Brontes, Bookman (July 1929).
10. S. M. Ellis, Wilkie Collins, Le Fanu, and others, London 1931.
11. V.S. Pritchett, The living novel, London: Chatto and Windus 1946.
12. Elizabeth Bowen, Collected Impressions, London 1950.
13. Nelson Browne, Sheridan Le Fanu, English Novelists Series, London 1951.
14. Michael Sadleir, XIX Century Fiction: A Bibliographical Record based on his own Collection, 2 volumes, London 1951.
15. A.B. Wright, The Life and Novels of Joseph Sheridan Le Fanu, unpubl. B.A. thesis, Trinity College, Dublin 1952.
16. Peter Penzoldt, The Supernatural in Fiction, New York: Humanities Press 1952.
17. Walter E. Houghton, The Victorian Frame of Mind 1830–1870, New Haven, London 1957.
18. Walter Allen, The English Novel: a Short Critical History, Harmondsworth 1958.
19. Thomas Flanagan, The Irish Novelists 1800–1850, New York 1959.
20. György Lukács (Georg Lukacs), The historical novel. Translated from the German by Hannah and Stanley Mitchell. Atlantic Highlands, New Jersey: Humanities 1962.
21. Patrick Diskin, Poe, Le Fanu and the Sealed Room Mystery, Notes and Queries (new. ser.) 13 (Sept. 1966) 337–339.
22. Wilbur J. Smith, 'Le Fanu's *Ghost Stories* Dublin 1851, Book Collector 17 (1968) 78.
23. Michael H. Begnal, Joseph Sheridan Le Fanu, Irish Writers Series, Bucknell University Press 1971.
24. Malcolm Brown, The Politics of Irish Literature from Thomas Davis to W. B. Yeats, London 1972.
25. Patrick F. Byrne, Joseph Sheridan Le Fanu: a Centenary Memoir, Dublin Historical Record, 26/3 (June 1973) 80–92.
26. W. J. McCormack, 'Joseph Sheridan Le Fanu and the Fiction of the Anglo-Irish Ascendancy of the Nineteenth Century', unpubl. D. Phil. thesis, University of Ulster 1974.
27. E.F. Beiler, 'Introduction' to J.S. Le Fanu: Ghost Stories and Mysteries, New York 1975, v–ix.
28. J.C. Beckett, The Anglo-Irish Tradition, London 1976.
29. Julia Briggs, Night Visitors: The Rise and Fall of the English Ghost Story, London: Faber 1977.
30. Jack Sullivan, Elegant Nightmares: The English Ghost Story from Le Fanu to Blackwood. Athens, Ohio: Ohio University Press 1978.
31. W. J. McCormack, Sheridan Le Fanu and Victorian England, Oxford, Clarendon Press 1980. [repr. 1997 as 'Sheridan Le Fanu'.]
32. Joseph Browne, 'Ghosts and Ghouls and Le Fanu', Canadian Journal of Irish Studies 8 (1982) 5–15.
33. W. J. McCormack, Dissolute Characters: Irish Literary History through Balzac, Sheridan Le Fanu, Yeats, and Bowen. Manchester University Press, 1983.
34. Ivan Melada, Sheridan Le Fanu, Twayne English Authors Series, Twayne 1987.
35. Jolanta Nalecz-Wojtczak, 'Joseph Sheridan Le Fanu and New Dimensions for the English Ghost Story', in: Wolfgang Zach and Heinz Kosok (eds.), Literary Interrelations: Ireland, England and the World, vol. 2, Tübingen: Günter Narr 1987.
36. Victor Sage, Horror Fiction in the Protestant Tradition, London: Macmillan 1988.
37. Patricia Coughlan, 'Doubles, Shadows, Sedan-Chairs and the Past: The Ghost Stories of J.S. Le Fanu', in: Michael Allen and Angela Wilcox (eds.), Critical Approaches to Anglo-Irish Literature, Gerrards Cross, Bucks. 1989.
38. Gary William Crawford, J. Sheridan Le Fanu: A Bio-Bibliography, Bio-Bibliographies in World Literature Series, Greenwood Press, Westport, CT 1995.
39. Marie Mulvey-Roberts (ed.), The handbook to Gothic literature, Basingstoke, Hampshire: Macmillan 1998.
40. Margot Gayle Backus, The Gothic family romance: heterosexuality, child sacrifice, and the Anglo-Irish colonial order. Durham, North Carolina: Duke University Press, 1999.
41. Victor Sage, 'Resurrecting the Regency: Horror and Eighteenth Century Comedy in Le Fanu's Fiction' in: Ruth Robbins and Julian Wolfreys (eds.), Victorian Gothic: Literature and Cultural Manifestations in the Nineteenth Century. Palgrave Macmillan 2000: 12–30.
42. Michael Charlesworth (ed.), The Gothic revival, 1720–1870: literary sources & documents. 3 Volumes. The Banks, Mountfield, East Sussex, U.K.: Helm Information, 2002.
43. Victor Sage, Le Fanu's Gothic: the rhetoric of darkness. New York: Palgrave Macmillan 2003.
44. Françoise Dupeyron-Lafay, La Paysage dans quelques oeuvres de J. S. Le Fanu, in: Imaginaires: Revue du Centre de Recherche sur l'Imaginaire dans les Littératures de Langue Anglaise 5 (2000) 67–78.
**The edition used in the digital edition**2. Madam Crowl's Ghost and other Mystery Stories. Joseph Sheridan Le Fanu Reprint [1 volume; viii + 277pp] G.Bell & Sons Limited London (1923)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The electronic edition covers pp 200–231.


#### Editorial Declaration


##### Correction


Text has been proofed twice at CELT.


##### Normalization


The electronic text represents the edited text. Obvious typographical errors of the hardcopy edition are corrected silently.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


When a hyphenated word (and subsequent punctuation mark) crosses a line break, the break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the chapter. Page-breaks are marked pb n="".


##### Interpretation


Words and phrases from other languages are marked.


#### Canonical References


This text uses the DIV1 element to represent the story. ### Profile Description


Created: 1870#### Use of language


##### Language: [EN] The text is in English.


##### Language: [GA] Some words are in Irish, but rendered in English spelling.


##### Language: [LA] Some words are in Latin.


##### Language: [FR] Some words are in French.


### Revision History


* (2006-11-24) Beatrix Färber (ed)

* File proofed (2); file parsed, additions to bibliography made; SGML and HTML file created.
* (2006-11-23) Beatrix Färber (ed)

* Header created; bibliography inserted; file proofed (1), structural and content markup added.
* (2006-11-22) Beatrix Färber (capture)

* Text scanned.




---


#### Corpus of Electronic Texts Edition: E860000-002


### Ultor De Lacy: Author: Joseph Sheridan Le Fanu




---

p.200


The Jacobite's Legacy
---------------------


In my youth I heard a great many Irish family traditions, more or less of a supernatural character, some of them very peculiar, and all, to a child at least, highly interesting. One of these I will now relate, though the translation to cold type from oral narrative, with all the aids of animated human voice and countenance, and the appropriate mise-en-scène of the old-fashioned parlour fireside and its listening circle of excited faces, and, outside, the wintry blast and the moan of leafless boughs, with the occasional rattle of the clumsy old window-frame behind shutter and curtain, as the blast swept by, is at best a trying one.


About midway up the romantic glen of Cappercullen, near the point where the counties of Limerick, Clare, and Tipperary converge, upon the then sequestered and forest-bound range of the Slieve-Felim hills, there stood, in the reigns of the two earliest Georges, the picturesque





---

p.201




 and massive remains of one of the finest of the Anglo-Irish castles of Munster—perhaps of Ireland.


It crowned the precipitous edge of the wooded glen, itself half-buried among the wild forest that covered that long and solitary range. There was no human habitation within a circle of many miles, except the half-dozen hovels and the small thatched chapel composing the little village of Murroa, which lay at the foot of the glen among the straggling skirts of the noble forest.


Its remoteness and difficulty of access saved it from demolition. It was worth nobody's while to pull down and remove the ponderous and clumsy oak, much less the masonry or flagged roofing of the pile. Whatever would pay the cost of removal had been long since carried away. The rest was abandoned to time—the destroyer.


The hereditary owners of this noble building and of a wide territory in the contiguous counties I have named, were English—the De Lacys—long naturalized in Ireland. They had acquired at least this portion of their estate in the reign of Henry VIII, and held it, with some vicissitudes, down to the establishment of the revolution in Ireland, when they suffered attainder, and, like other great families of that period, underwent a final eclipse.


The De Lacy of that day retired to France, and held a brief command in the Irish Brigade, interrupted by sickness. He retired, became a poor hanger-on of the Court of St. Germains, and died early in the eighteenth century—as well as I remember, 1705—leaving an only son, hardly twelve years old, called by the strange but significant name of Ultor.


At this point commences the marvellous ingredient of my tale.


When his father was dying, he had him to his bedside, with no one by except his confessor; and having told him,





---

p.202




 first, that on reaching the age of twenty-one, he was to lay claim to a certain small estate in the county of Clare, in Ireland, in right of his mother—the title-deeds of which he gave him—and next, having enjoined him not to marry before the age of thirty, on the ground that earlier marriages destroyed the spirit and the power of enterprise, and would incapacitate him from the accomplishment of his destiny—the restoration of his family—he then went on to open to the child a matter which so terrified him that he cried lamentably, trembling all over, clinging to the priest's gown with one hand and to his father's cold wrist with the other, and imploring him, with screams of horror, to desist from his communication.


But the priest, impressed, no doubt, himself, with its necessity, compelled him to listen. And then his father showed him a small picture, from which also the child turned with shrieks, until similarly constrained to look. They did not let him go until he had carefully conned the features, and was able to tell them, from memory, the colour of the eyes and hair, and the fashion and hues of the dress. Then his father gave him a black box containing this portrait, which was a full-length miniature, about nine inches long, painted very finely in oils, as smooth as enamel, and folded above it a sheet of paper, written over in a careful and very legible hand.


The deeds and this black box constituted the most important legacy bequeathed to his only child by the ruined Jacobite, and he deposited them in the hands of the priest, in trust, till his boy, Ultor, should have attained to an age to understand their value, and to keep them securely.


When this scene was ended, the dying exile's mind, I suppose, was relieved, for he spoke cheerily, and said he believed he would recover; and they soothed the crying





---

p.203




 child, and his father kissed him, and gave him a little silver coin to buy fruit with; and so they sent him off with another boy for a walk, and when he came back his father was dead.


He remained in France under the care of this ecclesiastic until he had attained the age of twenty-one, when he repaired to Ireland, and his title being unaffected by his father's attainder, he easily made good his claim to the small estate in the county of Clare.


There he settled, making a dismal and solitary tour now and then of the vast territories which had once been his father's, and nursing those gloomy and impatient thoughts which befitted the enterprises to which he was devoted.


Occasionally he visited Paris, that common centre of English, Irish, and Scottish disaffection; and there, when a little past thirty, he married the daughter of another ruined Irish house. His bride returned with him to the melancholy seclusion of their Munster residence, where she bore him in succession two daughters—Alice, the elder, dark-eyed and dark-haired, grave and sensible—Una, four years younger, with large blue eyes and long and beautiful golden hair.


Their poor mother was, I believe, naturally a light-hearted, sociable, high-spirited little creature; and her gay and childish nature pined in the isolation and gloom of her lot. At all events she died young, and the children were left to the sole care of their melancholy and embittered father. In process of time the girls grew up, tradition says, beautiful. The elder was designed for a convent, the younger her father hoped to mate as nobly as her high blood and splendid beauty seemed to promise, if only the great game on which he had resolved to stake all succeeded.




---

p.204


The Fairies in the Castle
-------------------------


The Rebellion of '45 came, and Ultor de Lacy was one of the few Irishmen implicated treasonably in that daring and romantic insurrection. Of course there were warrants out against him, but he was not to be found. The young ladies, indeed, remained as heretofore in their father's lonely house in Clare; but whether he had crossed the water or was still in Ireland was for some time unknown, even to them. In due course he was attainted, and his little estate forfeited. It was a miserable catastrophe—a tremendous and beggarly waking up from a life-long dream of returning principality.


In due course the officers of the crown came down to take possession, and it behoved the young ladies to flit. Happily for them the ecclesiastic I have mentioned was not quite so confident as their father, of his winning back the magnificent patrimony of his ancestors; and by his advice the daughters had been secured twenty pounds a year each, under the marriage settlement of their parents, which was all that stood between this proud house and literal destitution.


Late one evening, as some little boys from the village were returning from a ramble through the dark and devious glen of Cappercullen, with their pockets laden with nuts and **frahans**[1](javascript:footNote('E860000-002/note001.html')), to their amazement and even terror they saw a light streaming redly from the narrow window of one of the towers overhanging the precipice among the ivy and the lofty branches, across the glen, already dim in the shadows of the deepening night.




---

p.205


‘Look—look—look—'tis the Phooka's tower!’ was the general cry, in the vernacular Irish, and a universal scamper commenced.


The bed of the glen, strewn with great fragments of rock, among which rose the tall stems of ancient trees, and overgrown with a tangled copse, was at the best no favourable ground for a run. Now it was dark; and, terrible work breaking through brambles and hazels and tumbling over rocks. Little Shaeen Mull Ryan, the last of the panic rout, screaming to his mates to wait for him—saw a whitish figure emerge from the thicket at the base of the stone flight of steps that descended the side of the glen, close by the castle-wall, intercepting his flight, and a discordant male voice shrieked——


‘I have you!’


At the same time the boy, with a cry of terror, tripped and tumbled; and felt himself roughly caught by the arm, and hauled to his feet with a shake.


A wild yell from the child, and a volley of terror and entreaty followed.


‘Who is it, Larry; what's the matter?’ cried a voice, high in air, from the turret window, The words floated down through the trees, clear and sweet as the low notes of a flute.


‘Only a child, my lady; a boy.’


‘Is he hurt?’


‘Are you hurted?’ demanded the whitish man, who held him fast, and repeated the question in Irish; but the child only kept blubbering and crying for mercy, with his hands clasped, and trying to drop on his knees.


Larry's strong old hand held him up. He was hurt, and bleeding from over his eye.


‘Just a trifle hurted, my lady!’


‘Bring him up here.’




---

p.206


Shaeen Mull Ryan gave himself over. He was among ‘the good people’, who he knew would keep him prisoner for ever and a day. There was no good in resisting. He grew bewildered, and yielded himself passively to his fate, and emerged from the glen on the platform above; his captor's knotted old hand still on his arm, and looked round on the tall mysterious trees, and the gray front of the castle, revealed in the imperfect moonlight, as upon the scenery of a dream.


The old man who, with thin wiry legs, walked by his side, in a dingy white coat, and blue facings, and great pewter buttons, with his silver gray hair escaping from under his battered three-cocked hat; and his shrewd puckered resolute face, in which the boy could read no promise of sympathy, showing so white and phantom-like in the moonlight, was, as he thought, the incarnate ideal of a fairy.


This figure led him in silence under the great arched gateway, and across the grass-grown court, to the door in the far angle of the building; and so, in the dark, round and round, up a stone screw stair, and with a short turn into a large room, with a fire of turf and wood, burning on its long unused hearth, over which hung a pot, and about it an old woman with a great wooden spoon was busy. An iron candlestick supported their solitary candle; and about the floor of the room, as well as on the table and chairs, lay a litter of all sorts of things; piles of old faded hangings, boxes, trunks, clothes, pewter-plates, and cups; and I know not what more.


But what instantly engaged the fearful gaze of the boy were the figures of two ladies; red drugget cloaks they had on, like the peasant girls of Munster and Connaught, and the rest of their dress was pretty much in keeping. But they had the grand air, the refined expression and





---

p.207




 beauty, and above all, the serene air of command that belong to people of a higher rank.


The elder, with black hair and full brown eyes, sat writing at the deal table on which the candle stood, and raised her dark gaze to the boy as he came in. The other, with her hood thrown back, beautiful and *riant*, with a flood of wavy golden hair, and great blue eyes, and with something kind, and arch, and strange in her countenance, struck him as the most wonderful beauty he could have imagined.


They questioned the man in a language strange to the child. It was not English, for he had a smattering of that, and the man's story seemed to amuse them. The two young ladies exchanged a glance, and smiled mysteriously. He was more convinced than ever that he was among the good people. The younger stepped gaily forward and said——


‘Do you know who *I* am, my little man? Well, I'm the fairy Una, and this is my palace; and that fairy you see there (pointing to the dark lady, who was looking out something in a box), is my sister and family physician, the Lady Graveairs; and these (glancing at the old man and woman), are some of my courtiers; and I'm considering now what I shall do with *you*, whether I shall send you to-night to Lough Guir, riding on a rush, to make my compliments to the Earl of Desmond in his enchanted castle; or, straight to your bed, two thousand miles under ground, among the gnomes; or to prison in that little corner of the moon you see through the window—with the man-in-the-moon for your gaoler, for thrice three hundred years and a day! There, don't cry. You only see how serious a thing it is for you, little boys, to come so near my castle. Now, for this once, I'll let you go. But, henceforward, any boys I, or my people, may





---

p.208




 find within half a mile round my castle, shall belong to me for life, and never behold their home or their people more.’


And she sang a little air and chased mystically half a dozen steps before him, holding out her cloak with her pretty fingers, and courtesying very low, to his indescribable alarm.


Then, with a little laugh, she said——


‘My little man, we must mend your head.’


And so they washed his scratch, and the elder one applied a plaister to it. And she of the great blue eyes took out of her pocket a little French box of bon-bons and emptied it into his hand, and she said——


‘You need not be afraid to eat these—they are very good—and I'll send my fairy, Blanc-et-bleu, to set you free. Take him (she addressed Larry), and let him go, with a solemn charge.’


The elder, with a grave and affectionate smile, said, looking on the fairy——


‘Brave, dear, wild Una! nothing can ever quell your gaiety of heart.’


And Una kissed her merrily on the cheek.


So the oak door of the room again opened, and Shaeen, with his conductor, descended the stair. He walked with the scared boy in grim silence near half way down the wild hill-side toward Murroa, and then he stopped, and said in Irish——


‘You never saw the fairies before, my fine fellow, and 'tisn't often those who once set eyes on us return to tell it. Whoever comes nearer, night or day, than this stone,’ and he tapped it with the end of his cane, ‘will never see his home again, for we'll keep him till the day of judgment; goodnight, little **gossoon**[2](javascript:footNote('E860000-002/note002.html'))—and away with you.’


So these young ladies, Alice and Una, with two old





---

p.209




 servants, by their father's direction, had taken up their abode in a portion of that side of the old castle which overhung the glen; and with the furniture and hangings they had removed from their late residence, and with the aid of glass in the casements and some other indispensable repairs, and a thorough airing, they made the rooms they had selected just habitable, as a rude and temporary shelter.


The Priest's Adventures in the Glen
-----------------------------------


At first, of course, they saw or heard little of their father. In general, however, they knew that his plan was to procure some employment in France, and to remove them there. Their present strange abode was only an adventure and an episode, and they believed that any day they might receive instructions to commence their journey.


After a little while the pursuit relaxed. The government, I believe, did not care, provided he did not obtrude himself, what became of him, or where he concealed himself. At all events, the local authorities showed no disposition to hunt him down. The young ladies' charges on the little forfeited property were paid without any dispute, and no vexatious inquiries were raised as to what had become of the furniture and other personal property which had been carried away from the forfeited house.


The haunted reputation of the castle—for in those days, in matters of the marvellous, the oldest were children—secured the little family in the seclusion they coveted. Once, or sometimes twice a week, old Laurence, with a





---

p.210




 shaggy little pony, made a secret expedition to the city of Limerick, starting before dawn, and returning under the cover of the night, with his purchases. There was beside an occasional sly moonlit visit from the old parish priest, and a midnight mass in the old castle for the little outlawed congregation.


As the alarm and inquiry subsided, their father made them, now and then, a brief and stealthy visit. At first these were but of a night's duration, and with great precaution; but gradually they were extended and less guarded. Still he was, as the phrase is in Munster, ‘on his keeping.’ He had firearms always by his bed, and had arranged places of concealment in the castle in the event of a surprise. But no attempt nor any disposition to molest him appearing, he grew more at ease, if not more cheerful.


It came, at last, that he would sometimes stay so long as two whole months at a time, and then depart as suddenly and mysteriously as he came. I suppose he had always some promising plot on hand, and his head full of ingenious treason, and lived on the sickly and exciting dietary of hope deferred.


Was there a poetical justice in this, that the little ménage thus secretly established, in the solitary and timeworn pile, should have themselves experienced, but from causes not so easily explicable, those very supernatural perturbations which they had themselves essayed to inspire?


The interruption of the old priest's secret visits was the earliest consequence of the mysterious interference which now began to display itself. One night, having left his cob in care of his old sacristan in the little village, he trudged on foot along the winding pathway, among the gray rocks and ferns that threaded the glen, intending a





---

p.211




 ghostly visit to the fair recluses of the castle, and he lost his way in this strange fashion.


There was moonlight, indeed, but it was little more than quarter-moon, and a long train of funereal clouds were sailing slowly across the sky—so that, faint and wan as it was, the light seldom shone full out, and was often hidden for a minute or two altogether. When he reached the point in the glen where the castle-stairs were wont to be, he could see nothing of them, and above, no trace of the castle-towers. So, puzzled somewhat, he pursued his way up the ravine, wondering how his walk had become so unusually protracted and fatiguing.


At last, sure enough, he saw the castle as plain as could be, and a lonely streak of candle-light issuing from the tower, just as usual, when his visit was expected. But he could not find the stair; and had to clamber among the rocks and copse-wood the best way he could. But when he emerged at top, there was nothing but the bare heath. Then the clouds stole over the moon again, and he moved along with hesitation and difficulty, and once more he saw the outline of the castle against the sky, quite sharp and clear. But this time it proved to be a great battlemented mass of cloud on the horizon. In a few minutes more he was quite close, all of a sudden, to the great front, rising gray and dim in the feeble light, and not till he could have struck it with his good oak ‘wattle’ did he discover it to be only one of those wild, gray frontages of living rock that rise here and there in picturesque tiers along the slopes of those solitary mountains. And so, till dawn, pursuing this mirage of the castle, through pools and among ravines, he wore out a night of miserable misadventure and fatigue.


Another night, riding up the glen, so far as the level way at bottom would allow, and intending to make his





---

p.212




 nag fast at his customary tree, he heard on a sudden a horrid shriek at top of the steep rocks above his head, and something—a gigantic human form, it seemed—came tumbling and bounding headlong down through the rocks, and fell with a fearful impetus just before his horse's hoofs and there lay like a huge palpitating carcass. The horse was scared, as, indeed, was his rider, too, and more so when this apparently lifeless thing sprang up to his legs, and throwing his arms apart to bar their further progress, advanced his white and gigantic face towards them. Then the horse started about, with a snort of terror, nearly unseating the priest, and broke away into a furious and uncontrollable gallop.


I need not recount all the strange and various misadventures which the honest priest sustained in his endeavours to visit the castle, and its isolated tenants. They were enough to wear out his resolution, and frighten him into submission. And so at last these spiritual visits quite ceased; and fearing to awaken inquiry and suspicion, he thought it only prudent to abstain from attempting them in the daytime.


So the young ladies of the castle were more alone than ever. Their father, whose visits were frequently of long duration, had of late ceased altogether to speak of their contemplated departure for France, grew angry at any allusion to it, and they feared, had abandoned the plan altogether.




---

p.213


The Light in the Bell Tower
---------------------------


Shortly after the discontinuance of the priest's visits, old Laurence, one night, to his surprise, saw light issuing from a window in the Bell Tower. It was at first only a tremulous red ray, visible only for a few minutes, which seemed to pass from the room, through whose window it escaped upon the courtyard of the castle, and so to lose itself. This tower and casement were in the angle of the building, exactly confronting that in which the little outlawed family had taken up their quarters.


The whole family were troubled at the appearance of this dull red ray from the chamber in the Bell Tower. Nobody knew what to make of it. But Laurence, who had campaigned in Italy with his old master, the young ladies' grandfather—‘the heavens be his bed this night!’—was resolved to see it out, and took his great horse-pistols with him, and ascended to the corridor leading to the tower. But his search was vain.


This light left a sense of great uneasiness among the inmates, and most certainly it was not pleasant to suspect the establishment of an independent and possibly dangerous lodger or even colony, within the walls of the same old building.


The light very soon appeared again, steadier and somewhat brighter, in the same chamber. Again old Laurence buckled on his armour, swearing ominously to himself, and this time bent in earnest upon conflict. The young ladies watched in thrilling suspense from the great window in *their* stronghold, looking diagonally across the court. But as Laurence, who had entered the massive range of





---

p.214




 buildings opposite, might be supposed to be approaching the chamber from which this ill-omened glare proceeded, it steadily waned, finally disappearing altogether, just a few seconds before his voice was heard shouting from the arched window to know which way the light had gone.


This lighting up of the great chamber of the Bell Tower grew at last to be of frequent and almost continual recurrence. It was, there, long ago, in times of trouble and danger, that the De Lacys of those evil days used to sit in feudal judgment upon captive adversaries, and, as tradition alleged, often gave them no more time for shrift and prayer, than it needed to mount to the battlement of the turret over-head, from which they were forthwith hung by the necks, for a caveat and admonition to all evil disposed persons viewing the same from the country beneath.


Old Laurence observed these mysterious glimmerings with an evil and an anxious eye, and many and various were the stratagems he tried, but in vain, to surprise the audacious intruders. It is, however, I believe, a fact that no phenomenon, no matter how startling at first, if prosecuted with tolerable regularity, and unattended with any new circumstances of terror, will very long continue to excite alarm or even wonder.


So the family came to acquiesce in this mysterious light. No harm accompanied it. Old Laurence, as he smoked his lonely pipe in the grass-grown courtyard, would cast a disturbed glance at it, as it softly glowed out through the darking aperture, and mutter a prayer or an oath. But he had given over the chase as a hopeless business. And Peggy Sullivan, the old dame of all work, when, by chance, for she never willingly looked toward the haunted quarter, she caught the faint reflection of its dull effulgence with the corner of her eye, would sign





---

p.215




 herself with the cross or fumble at her beads, and deeper furrows would gather in her forehead, and her face grow ashen and perturbed. And this was not mended by the levity with which the young ladies, with whom the spectre had lost his influence, familiarity, as usual, breeding contempt, had come to talk, and even to jest, about it.


The Man with the Claret Mark
----------------------------


But as the former excitement flagged, old Peggy Sullivan produced a new one; for she solemnly avowed that she had seen a thin-faced man, with an ugly red mark all over the side of his cheek, looking out of the same window, just at sunset, before the young ladies returned from their evening walk.


This sounded in their ears like an old woman's dream, but still it was an excitement, jocular in the morning, and just, perhaps, a little fearful as night overspread the vast and desolate building, but still, not wholly unpleasant. This little flicker of credulity suddenly, however, blazed up into the full light of conviction.


Old Laurence, who was not given to dreaming, and had a cool, hard head, and an eye like a hawk, saw the same figure, just about the same hour, when the last level gleam of sunset was tinting the summits of the towers and the tops of the tall trees that surrounded them.


He had just entered the court from the great gate, when he heard all at once the hard peculiar twitter of alarm which sparrows make when a cat or a hawk invades





---

p.216




 their safety, rising all round from the thick ivy that overclimbed the wall on his left, and raising his eyes listlessly, he saw, with a sort of shock, a thin, ungainly man, standing with his legs crossed, in the recess of the window from which the light was wont to issue, leaning with his elbows on the stone mullion, and looking down with a sort of sickly sneer, his hollow yellow cheeks being deeply stained on one side with what is called a ‘claret-mark.’


‘I have you at last, you villain!’ cried Larry, in a strange rage and panic: ‘drop down out of that on the grass here, and give yourself up, or I'll shoot you.’


The threat was backed with an oath, and he drew from his coat pocket the long holster pistol he was wont to carry, and covered his man cleverly.


‘I give you while I count ten—one-two-three-four. If you draw back, I'll fire, mind; five-six—you'd better be lively—seven-eight-nine—one chance more; will you come down? Then take it—ten!’


Bang went the pistol. The sinister stranger was hardly fifteen feet removed from him, and Larry was a dead shot. But this time he made a scandalous miss, for the shot knocked a little white dust from the stone wall a full yard at one side; and the fellow never shifted his negligent posture or qualified his sardonic smile during the procedure.


Larry was mortified and angry.


‘You'll not get off this time, my tulip!’ he said with a grin, exchanging the smoking weapon for the loaded pistol in reserve.


‘What are you pistolling, Larry?’ said a familiar voice close by his elbow, and he saw his master, accompanied by a handsome young man in a cloak.


‘That villain, your honour, in the window, there.’




---

p.217


‘Why there's nobody there, Larry,’ said De Lacy, with a laugh, though that was no common indulgence with him.


As Larry gazed, the figure somehow dissolved and broke up without receding. A hanging tuft of yellow and red ivy nodded queerly in place of the face, some broken and discoloured masonry in perspective took up the outline and colouring of the arms and figure, and two imperfect red and yellow lichen streaks carried on the curved tracing of the long spindle shanks. Larry blessed himself, and drew his hand across his damp forehead, over his bewildered eyes, and could not speak for a minute. It was all some devilish trick; he could take his oath he saw every feature in the fellow's face, the lace and buttons of his cloak and doublet, and even his long finger nails and thin yellow fingers that overhung the cross-shaft of the window, where there was now nothing but a rusty stain left.


The young gentleman who had arrived with De Lacy, stayed that night and shared with great apparent relish the homely fare of the family. He was a gay and gallant Frenchman, and the beauty of the younger lady, and her pleasantry and spirit, seemed to make his hours pass but too swiftly, and the moment of parting sad.


When he had departed early in the morning, Ultor De Lacy had a long talk with his elder daughter, while the younger was busy with her early dairy task, for among their retainers this proles generosa reckoned a ‘kind’ little Kerry cow.


He told her that he had visited France since he had been last at Cappercullen, and how good and gracious their sovereign had been, and how he had arranged a noble alliance for her sister Una. The young gentleman was of high blood, and though not rich, had, nevertheless,





---

p.218




 his acres and his nom de terre, besides a captain's rank in the army. He was, in short, the very gentleman with whom they had parted only that morning. On what special business he was now in Ireland there was no necessity that he should speak; but being here he had brought him hither to present him to his daughter, and found that the impression she had made was quite what was desirable.


‘You, you know, dear Alice, are promised to a conventual life. Had it been otherwise—’


He hesitated for a moment.


‘You are right, dear father,’ she said, kissing his hand, ‘I *am* so promised, and no earthly tie or allurement has power to draw me from that holy engagement.’


‘Well,’ he said, returning her caress, ‘I do not mean to urge you upon that point. It must not, however, be until Una's marriage has taken place. That cannot be, for many good reasons, sooner than this time twelve months; we shall then exchange this strange and barbarous abode for Paris, where are many eligible convents, in which are entertained as sisters some of the noblest ladies of France; and there, too, in Una's marriage will be continued, though not the name, at all events the blood, the lineage, and the title which, so sure as justice ultimately governs the course of human events, will be again established, powerful and honoured in this country, the scene of their ancient glory and transitory misfortunes. Meanwhile, we must not mention this engagement to Una. Here she runs no risk of being sought or won; but the mere knowledge that her hand was absolutely pledged, might excite a capricious opposition and repining such as neither I nor you would like to see; therefore be secret.’


The same evening he took Alice with him for a ramble





---

p.219




 round the castle wall, while they talked of grave matters, and he as usual allowed her a dim and doubtful view of some of those cloud-built castles in which he habitually dwelt, and among which his jaded hopes revived.


They were walking upon a pleasant short sward of darkest green, on one side overhung by the gray castle walls, and on the other by the forest trees that here and there closely approached it, when precisely as they turned the angle of the Bell Tower, they were encountered by a person walking directly towards them. The sight of a stranger, with the exception of the one visitor introduced by her father, was in this place so absolutely unprecedented, that Alice was amazed and affrighted to such a degree that for a moment she stood stock-still.


But there was more in this apparition to excite unpleasant emotions, than the mere circumstance of its unexpectedness. The figure was very strange, being that of a tall, lean, ungainly man, dressed in a dingy suit, somewhat of a Spanish fashion, with a brown laced cloak, and faded red stockings. He had long lank legs, long arms, hands, and fingers, and a very long sickly face, with a drooping nose, and a sly, sarcastic leer, and a great purplish stain over-spreading more than half of one cheek.


As he strode past, he touched his cap with his thin, discoloured fingers, and an ugly side glance, and disappeared round the corner. The eyes of father and daughter followed him in silence.


Ultor De Lacy seemed first absolutely terror-stricken, and then suddenly inflamed with ungovernable fury. He dropped his cane on the ground, drew his rapier, and, without wasting a thought on his daughter, pursued.


He just had a glimpse of the retreating figure as it disappeared round the far angle. The plume, and the





---

p.220




 lank hair, the point of the rapier-scabbard, the flutter of the skirt of the cloak, and one red stocking and heel; and this was the last he saw of him.


When Alice reached his side, his drawn sword still in his hand, he was in a state of abject agitation.


‘Thank Heaven, he's gone!’ she exclaimed.


‘He's gone,’ echoed Ultor, with a strange glare.


‘And you are safe,’ she added, clasping his hand.


He sighed a great sigh.


‘And you don't think he's coming back?’


‘He!—who?’


‘The stranger who passed us but now. Do you know him, father?’


‘Yes—and—no, child—I know him not—and yet I know him too well. Would to heaven we could leave this accursed haunt tonight. Cursed be the stupid malice that first provoked this horrible feud, which no sacrifice and misery can appease, and no exorcism can quell or even suspend. The wretch has come from afar with a sure instinct to devour my last hope—to dog us into our last retreat—and to blast with his triumph the very dust and ruins of our house. What ails that stupid priest that he has given over his visits? Are *my* children to be left without mass or confession—the sacraments which *guard* as well as save—because he once loses his way in a mist, or mistakes a streak of foam in the brook for a dead man's face? D—n him!’


‘See, Alice, if he won't come,’ he resumed, ‘you must only *write* your confession to him in full—you and Una. Laurence is trusty, and will carry it—and we'll get the bishop's—or, if need be, the Pope's leave for him to give you absolution. I'll move heaven and earth, but you *shall* have the sacraments, poor children!—and see him. I've been a wild fellow in my youth, and never pretended





---

p.221




 to sanctity; but I know there's but one safe way—and—and—keep you each a bit of this—(he opened a small silver box) —about you while you stay here—fold and sew it up reverently in a bit of the old psaltery parchment and wear it next your hearts—'tis a fragment of the consecrated wafer—and will help, with the saints' protection, to guard you from harm—and be strict in fasts, and constant in prayer—I can do nothing—nor devise any help. The curse has fallen, indeed, on me and mine.’


And Alice, saw, in silence, the tears of despair roll down his pale and agitated face.


This adventure was also a secret, and Una was to hear nothing of it.


Voices
------


Now Una, nobody knew why, began to lose spirit, and to grow pale. Her fun and frolic were quite gone! Even her songs ceased. She was silent with her sister, and loved solitude better. She said she was well, and quite happy, and could in no wise be got to account for the lamentable change that had stolen over her. She had grown odd too, and obstinate in trifles; and strangely reserved and cold.


Alice was very unhappy in consequence. What was the cause of this estrangement—had she offended her, and how? But Una had never before borne resentment for an hour. What could have altered her entire nature so? Could it be the shadow and chill of coming insanity?




---

p.222


Once or twice, when her sister urged her with tears and entreaties to disclose the secret of her changed spirits and demeanour, she seemed to listen with a sort of silent wonder and suspicion, and then she looked for a moment full upon her, and seemed on the very point of revealing all. But the earnest dilated gaze stole downward to the floor, and subsided into an odd wily smile, and she began to whisper to herself, and the smile and the whisper were both a mystery to Alice.


She and Alice slept in the same bedroom—a chamber in a projecting tower—which on their arrival, when poor Una was so merry, they had hung round with old tapestry, and decorated fantastically according to their skill and frolic. One night, as they went to bed, Una said, as if speaking to herself——


‘'Tis my last night in this room—I shall sleep no more with Alice.’


‘And what has poor Alice done, Una, to deserve your strange unkindness?’


Una looked on her curiously, and half frightened, and then the odd smile stole over her face like a gleam of moonlight.


‘My poor Alice, what have you to do with it?’ she whispered.


‘And why do you talk of sleeping no more with me?’ said Alice.


‘Why? Alice dear—no why—no reason—only a knowledge that it must be so, or Una will die.’


‘Die, Una darling!—what can you mean?’


‘Yes, sweet Alice, die, indeed. We must all die some time, you know, or—or undergo a change; and my time is near—very near—unless I sleep apart from you.’


‘Indeed, Una, sweetheart, I think you *are* ill, but not near death.’




---

p.223


‘Una knows what you think, wise Alice—but she's not mad—on the contrary, she's wiser than other folks.’


‘She's sadder and stranger too,’ said Alice, tenderly.


‘Knowledge is sorrow,’ answered Una, and she looked across the room through her golden hair which she was combing—and through the window, beyond which lay the tops of the great trees, and the still foliage of the glen in the misty moonlight.


‘'Tis enough, Alice dear; it must be so. The bed must move hence, or Una's bed will be low enough ere long. See, it shan't be far though, only into that small room.’


She pointed to an inner room or closet opening from that in which they lay. The walls of the building were hugely thick, and there were double doors of oak between the chambers, and Alice thought, with a sigh, how completely separated they were going to be.


However she offered no opposition. The change was made, and the girls for the first time since childhood lay in separate chambers. A few nights afterwards Alice awoke late in the night from a dreadful dream, in which the sinister figure which she and her father had encountered in their ramble round the castle walls, bore a principal part.


When she awoke there were still in her ears the sounds which had mingled in her dream. They were the notes of a deep, ringing, bass voice rising from the glen beneath the castle walls—something between humming and singing—listlessly unequal and intermittent, like the melody of a man whiling away the hours over his work. While she was wondering at this unwonted minstrelsy, there came a silence, and—could she believe her ears?—it certainly was Una's clear low contralto—softly singing a bar or two from the window. Then once more 





---

p.224




silence—and then again the strange manly voice, faintly chaunting from the leafy abyss.


With a strange wild feeling of suspicion and terror, Alice glided to the window. The moon who sees so many things, and keeps all secrets, with her cold impenetrable smile, was high in the sky. But Alice saw the red flicker of a candle from Una's window, and, she thought, the shadow of her head against the deep side wall of its recess. Then this was gone, and there were no more sights or sounds that night.


As they sat at breakfast, the small birds were singing merrily from among the sun-tipped foliage.


‘I love this music,’ said Alice, unusually pale and sad; ‘it comes with the pleasant light of morning. I remember, Una, when *you* used to sing, like those gay birds, in the fresh beams of the morning; that was in the old time, when Una kept no secret from poor Alice.’


‘And Una knows what her sage Alice means; but there are other birds, silent all day long, and, they say, the sweetest too, that love to sing by *night* alone.’


So things went on—the elder girl pained and melancholy—the younger silent, changed, and unaccountable.


A little while after this, very late one night, on awaking, Alice heard a conversation being carried on in her sister's room. There seemed to be no disguise about it. She could not distinguish the words, indeed, the walls being some six feet thick, and two great oak doors intercepting. But Una's clear voice, and the deep bell-like tones of the unknown, made up the dialogue.


Alice sprung from her bed, threw her clothes about her, and tried to enter her sister's room; but the inner door was bolted. The voices ceased to speak as she knocked, and Una opened it, and stood before her in her nightdress, candle in hand.




---

p.225


‘Una—Una, darling, as you hope for peace, tell me who is here?’ cried frightened Alice, with her trembling arms about her neck.


Una drew back, with her large innocent blue eyes fixed full upon her.


‘Come in, Alice,’ she said, coldly.


And in came Alice, with a fearful glance around. There was no hiding place there; a chair, a table, a little bedstead, and two or three pegs in the wall to hang clothes on; a narrow window, with two iron bars across; no hearth or chimney—nothing but bare walls.


Alice looked round in amazement, and her eyes glanced with painful inquiry into those of her sister. Una smiled one of her peculiar sidelong smiles, and said——


‘Strange dreams! I've been dreaming—so has Alice. She hears and sees Una's dreams, and wonders—and well she may.’


And she kissed her sister's cheek with a cold kiss, and lay down in her little bed, her slender hand under her head, and spoke no more.


Alice, not knowing what to think, went back to hers.


About this time Ultor De Lacy returned. He heard his elder daughter's strange narrative with marked uneasiness, and his agitation seemed to grow rather than subside. He enjoined her, however, not to mention it to the old servant, nor in presence of anybody she might chance to see, but only to him and to the priest, if he could be persuaded to resume his duty and return. The trial, however, such as it was, could not endure very long; matters had turned out favourably. The union of his younger daughter might be accomplished within a few months, and in eight or nine weeks they should be on their way to Paris.


A night or two after her father's arrival, Alice, in the





---

p.226




 dead of the night, heard the well-known strange deep voice speaking softly, as it seemed, close to her own window on the outside; and Una's voice, clear and tender, spoke in answer. She hurried to her own casement, and pushed it open, kneeling in the deep embrasure, and looking with a stealthy and affrighted gaze towards her sister's window. As she crossed the floor the voices subsided, and she saw a light withdrawn from within. The moonbeams slanted bright and clear on the whole side of the castle overlooking the glen, and she plainly beheld the shadow of a man projected on the wall as on a screen.


This black shadow recalled with a horrid thrill the outline and fashion of the figure in the Spanish dress. There were the cap and mantle, the rapier, the long thin limbs and sinister angularity. It was so thrown obliquely that the hands reached to the window-sill, and the feet stretched and stretched, longer and longer as she looked, toward the ground, and disappeared in the general darkness; and the rest, with a sudden flicker, shot downwards, as shadows will on the sudden movement of a light, and was lost in one gigantic leap down the castle wall.


‘I do not know whether I dream or wake when I hear and see these sights; but I will ask my father to sit up with me, and we *two* surely cannot be mistaken. May the holy saints keep and guard us!’ And in her terror she buried her head under the bed-clothes, and whispered her prayers for an hour.




---

p.227


Una's Love
----------


‘I have been with Father Denis,’ said De Lacy, next day, ‘and he will come to-morrow; and, thank Heaven! you may both make your confession and hear mass, and my mind will be at rest; and you'll find poor Una happier and more like herself.’


But 'tween cup and lip there's many a slip. The priest was not destined to hear poor Una's shrift. When she bid her sister goodnight she looked on her with her large, cold, wild eyes, till something of her old human affections seemed to gather there, and they slowly filled with tears, which dropped one after the other on her homely dress as she gazed in her sister's face.


Alice, delighted, sprang up, and clasped her arms about her neck. ‘My own darling treasure,'tis all over; you love your poor Alice again, and will be happier than ever.’


But while she held her in her embrace Una's eyes were turned towards the window, and her lips apart, and Alice felt instinctively that her thoughts were already far away.


‘Hark!—listen!—hush!’ and Una, with her delighted gaze fixed, as if she saw far away beyond the castle wall, the trees, the glen, and the night's dark curtain, held her hand raised near her ear, and waved her head slightly in time, as it seemed, to music that reached not Alice's ear, and smiled her strange pleased smile, and then the smile slowly faded away, leaving that sly suspicious light behind it which somehow scared her sister with an uncertain sense of danger; and she sang in tones so sweet and low that it seemed but a reverie of a song, recalling,





---

p.228




 as Alice fancied, the strain to which she had just listened in that

 strange ecstasy, the plaintive and beautiful Irish ballad, shule, shule, shule, aroon, the midnight summons of the outlawed Irish soldier to his darling to follow him.


Alice had slept little the night before. She was now overpowered with fatigue; and leaving her candle burning by her bedside, she fell into a deep sleep. From this she awoke suddenly, and completely, as will sometimes happen without any apparent cause, and she saw Una come into the room. She had a little purse of embroidery—her own work—in her hand; and she stole lightly to the bedside, with her peculiar oblique smile, and evidently thinking that her sister was asleep.


Alice was thrilled with a strange terror, and did not speak or move; and her sister slipped her hand softly under her bolster, and withdrew it. Then Una stood for while by the hearth, and stretched her hand up to the mantelpiece, from which she took a little bit of chalk, and Alice thought she saw her place it in the fingers of a long yellow hand that was stealthily introduced from her own chamber-door to receive it; and Una paused in the dark recess of the door, and smiled over her shoulder toward her sister, and then glided into her room, closing the doors.


Almost freezing with terror, Alice rose and glided after her, and stood in her chamber, screaming——


‘Una, Una, in heaven's name what troubles you?’


But Una seemed to have been sound asleep in her bed, and raised herself with a start, and looking upon her with a peevish surprise, said——


‘What does Alice seek here?’


‘You were in my room, Una, dear; you seem disturbed and troubled.’




---

p.229


‘Dreams, Alice. My dreams crossing your brain; only dreams—dreams. Get you to bed, and sleep.’


And to bed she went, but *not* to sleep. She lay awake more than an hour; and then Una emerged once more from her room. This time she was fully dressed, and had her cloak and thick shoes on, as their rattle on the floor plainly discovered. She had a little bundle tied up in a handkerchief in her hand, and her hood was drawn about her head; and thus equipped, as it seemed, for a journey, she came and stood at the foot of Alice's bed, and stared on her with a look so soulless and terrible that her senses almost forsook her. Then she turned and went back into her own chamber.


She may have returned; but Alice thought not—at least she did not see her. But she lay in great excitement and perturbation; and was terrified, about an hour later, by a knock at her chamber door—not that opening into Una's room, but upon the little passage from the stone screw staircase. She sprang from her bed; but the door was secured on the inside, and she felt relieved. The knock was repeated, and she heard some one laughing softly on the outside.


The morning came at last; that dreadful night was over. But Una! Where was Una?


Alice never saw her more. On the head of her empty bed were traced in chalk the words—Ultor De Lacy, Ultor O'Donnell. And Alice found beneath her own pillow the little purse of embroidery she had seen in Una's hand. It was her little parting token, and bore the simple legend—‘Una's love!’


De Lacy's rage and horror were boundless. He charged the priest, in frantic language, with having exposed his child, by his cowardice and neglect, to the machinations of the Fiend, and raved and blasphemed like a man demented.




---

p.230


It is said that he procured a solemn exorcism to be performed, in the hope of disenthralling and recovering his daughter. Several times, it is alleged, she was seen by the old servants. Once on a sweet summer morning, in the window of the tower, she was perceived combing her beautiful golden tresses, and holding a little mirror in her hand; and first, when she saw herself discovered, she looked affrighted, and then smiled, her slanting, cunning smile. Sometimes, too, in the glen, by moonlight, it was said belated villagers had met her, always startled first, and then smiling, generally singing snatches of old Irish ballads, that seemed to bear a sort of dim resemblance to her melancholy fate. The apparition has long ceased. But it is said that now and again, perhaps once in two or three years, late on a summer night, you may hear—but faint and far away in the recesses of the glen—the sweet, sad notes of Una's voice, singing those plaintive melodies. This, too, of course, in time will cease, and all be forgotten.


Sister Agnes and the Portrait
-----------------------------


When Ultor De Lacy died, his daughter Alice found among his effects a small box, containing a portrait such as I have described. When she looked on it, she recoiled in horror. There, in the plenitude of its sinister peculiarities, was faithfully portrayed the phantom which lived with a vivid and horrible accuracy in her remembrance. Folded in the same box was a brief narrative, stating that, ‘A.D. 1601, in the month of December, Walter De Lacy,





---

p.231




 of Cappercullen, made many prisoners at the ford of Ownhey, or Abington, of Irish and Spanish soldiers, flying from the great overthrow of the rebel powers at Kinsale, and among the number one Roderic O'Donnell, an arch traitor, and near kinsman to that other O'Donnell who led the rebels; who, claiming kindred through his mother to De Lacy, sued for his life with instant and miserable entreaty, and offered great ransom, but was by De Lacy, through great zeal for the queen, as some thought, cruelly put to death. When he went to the tower-top, where was the gallows, finding himself in extremity, and no hope of mercy, he swore that though he could work them no evil before his death, yet that he would devote himself thereafter to blast the greatness of the De Lacys, and never leave them till his work was done. He hath been seen often since, and always for that family perniciously, insomuch that it hath been the custom to show to young children of that lineage the picture of the said O'Donnell, in little, taken among his few valuables, to prevent their being misled by him unawares, so that he should not have his will, who by devilish wiles and hell-born cunning, hath steadfastly sought the ruin of that ancient house, and especially to leave that stemma generosum destitute of issue for the transmission of their pure blood and worshipful name.’


Old Miss Croker, of Ross House, who was near seventy in the year 1821, when she related this story to me, had seen and conversed with Alice De Lacy, a professed nun, under the name of Sister Agnes, in a religious house in King-street, in Dublin, founded by the famous Duchess of Tyrconnell, and had the narrative from her own lips. I thought the tale worth preserving, and have no more to say.














