

#The Travels of Joseph Woods, Architect and Botanist, in 1809


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Travels of Joseph Woods, Architect and Botanist, in 1809
============================================================


Author: Joseph Woods
--------------------


### File Description

Gerard J. Lyne M. E. MitchellElectronic edition compiled and proof-read by Beatrix Färber

Funded by University College, Cork, School of History 1. First draftExtent of text: 33950 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800005-003Availability [RESTRICTED] 
Available with prior consent of the CELT project for purposes of academic research and teaching only.


#### Notes

We are very grateful to Gerard Lyne, formerly Keeper of Manuscripts at the National Library of Ireland, Michael E. Mitchell, Professor emeritus of Botany at NUI Galway, and the Honorary Editor of the *North Munster Antiquarian Journal* for their kind permission to publish this material in electronic form on CELT.

#### Sources


**Manuscript**2. Cambridge, University Library, Bradshaw Add. MS 43 423. According to p. 15, footnote 3, "it consists of a notebook now containing 194 pages of which 8 are blank; pages 133, 151, 183–4 and 187–90 are missing. Two appendixes relating to the botany of Killarney and to Irish architecture are referred to in the MS but these are not present."
**Literature (mainly that referred to in annotations)**2. John Ray, Historia plantarum, vol. II (London 1688).
3. Memoirs of E. Ludlow (...) Commander in Chief of the Forces in Ireland (...), vol. I (Vivay 1698).
4. Charles Smith, Antient and Present State of the County and City of Waterford (Dublin 1746).
5. Charles Smith, Antient and Present State of the County and City of Cork (Dublin 1750).
6. [Dunn (attributed)], A Description of Killarney (Dublin 1776).
7. [Thomas Campbell,] A Philosophical Survey of the South of Ireland, in a series of letters to John Watkinson (Dublin 1778). [Available online at CELT.]
8. Edward Ledwich, The Antiquities of Ireland (Dublin 1790).
9. Alexander Taylor, New Map of Ireland (...) for the use of travellers (Dublin/London 1793).
10. For the comic song 'The Bold Dragoon', beginning 'There was an ancient fair ...', see songsheet/text on digital collections of Duke University at http://library.duke.edu/digitalcollections/songsheets\_bsvg200715/.
11. Walter Wade, Plantae rariores in Hibernia inventae (Dublin 1804).
12. Sir Richard Hoare, Journal of a Tour in Ireland in 1806 (London 1807).
13. Anon., Journal of a Tour in Ireland, London 1806; reprinted Dublin 1980.
14. Nicholas Carlisle, A Topographical Dictionary of Ireland (London 1810).
15. James Townsend Mackay, A systematic catalogue of the rare plants found in Ireland, in Transactions of the Dublin Society 5 (1806).
16. Horatio Townsend, A general and statistical survey of the county of Cork (...) (Dublin 1810).
17. James Hardiman, The History of Galway (Dublin 1820).
18. Thomas Crofton Croker, Researches in the south of Ireland (London 1824) [available online at CELT].
19. Samuel Lewis, A Topographical Dictionary of Ireland, comprising the several counties, cities, boroughs, corporate, market, and post towns. Parishes, and villages, with historical and statistical descriptions (...) (London 1837). [Available online at http://www.libraryireland.com/topog/index.php].
20. James Fraser, Guide Through Ireland (Dublin 1838).
21. A general map of Ireland to accompany the report of the Railway Commissioners shewing the principal physical features and geological structure of the country, (Dublin/London) 1839.
22. Alexander Knox, The Irish watering places, their climate, scenery and accomodations, including analyses of the principal mineral springs, by Dr. R. Kane, and remarks on ..., together with directions for the regimen of invalids, and observations on indigestion, gout, pulmonary consumption, and other diseases of the chest, stomach, and nervous system (Dublin 1845).
23. Lord John Russell (ed.), The Life and Times of Charles James Fox, I, (London 1859).
24. Rev. Henry MacManus, Sketches of the Irish Highlands: descriptive, social and religious. With special reference to Irish Missions in West Connaught since 1840. (London 1863).
25. David Moore and Alexander Goodman More, Contributions towards a Cybele Hibernica (Dublin 1866).
26. [Lydia Fisher], Memoir of W. H. Harvey, M.D., F.R.S., with selections from his journal and correspondence (London 1869).
27. Mary Agnes Hickson, Selections from old Kerry records : historical and genealogical, with introductory memoir, notes, and appendix., ser. II (London 1874).
28. Patrick Weston Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869-1913.] With a new introductory essay on P. W. Joyce by Mainchín Seoighe. (Dublin: Éamonn de Búrca for Edmund Burke 1995).
29. John Swan Sloane, "A History of the Lighthouses of Ireland, with occasional sketches of their various localities", Irish Builder 22 (1880).
30. Edward Hoare, Some Account of the (...) Families of Hore and Hoare with all their branches (...) (London 1883).
31. James Britten and Robert Holland, A dictionary of English Plant-Names (London 1886).
32. James Dowd, "Kilmallock, County Limerick", in JRSAI 19 (1889), 204–215.
33. Thomas Olden, The Church of Ireland (London 1892).
34. James Frost, The history and topography of the County of Clare, from the earliest times to the 18th century (Dublin 1893).
35. J. Coleman, "Notes on Castles of Co. Cork", J. Cork Hist. Archaeol. Soc., 1 (1895), 22–23.
36. Lady Gregory (ed.), Mr. Gregory's letter-box 1813–1830 (London 1898).
37. Thomas Johnson Westropp, "Notes on the lesser castles or "peel towers" of the Co. Clare. With 2 plates", PRIA, 23, C (1899), Ser. 3, Vol. 5, 348–365.
38. Thomas Johnson Westropp, "The Augustinian houses of the County Clare: Clare, Killone and Inchicronan", JRSAI 30 (1900), 118–135.
39. Thomas Johnson Westropp, "Descriptive account of the places visited on the Summer Excursion of the Royal Society of Antiquaries of Ireland", JRSAI 30 (1900), sections I. and II.. 273–306.
40. Thomas Johnson Westropp, "Summer Excursions of the Royal Society of Antiquaries of Ireland, JRSAI 30 (1900), Sections III. and IV., 392–445.
41. Thomas Johnson Westropp, "Notes on Askeaton, County Limerick. Part I.–the history, A.D. 900 to 1579", JRSAI 33 (1903), 25–40; "Part II.–The history after 1579", 153–174; "Eschluen or Eschluona Church, near Limerick (note)", 197–200; "Notes on Askeaton, County Limerick. Part III.–The 'Abbey', 239–254.
42. J. Fahy, "Kilmacduagh and Its Ecclesiastical Monuments", JRSAI 34 (1904), 220–232.
43. Robert Cochrane, "Note on the Round Tower, etc., of Kilmacduagh", JRSAI 34 (1904), 234–238.
44. Thomas Johnson Westropp, "Survey of the Ancient Churches in the County of Limerick. With 9 Plates", in PRIA, 25, C (1904–5), 327–480.
45. Thomas Johnson Westropp, "Antiquities near Miltown Malbay", Journal of the Limerick Field Club 2 (8), (1901–04), 247–256 and 3 (9) (1905), 1–5.
46. Thomas Johnson Westropp, "The Ancient Castles of the County of Limerick (...)", PRIA, 26, C (1906–07), 75–79.
47. William P. Burke, History of Clonmel (Waterford 1907).
48. Thomas Johnson Westropp, "The Principal Ancient Castles of the County Limerick", in JRSAI 37 (1907), 24–40; 153–164.
49. William P. Burke, "Cahir Castle", JRSAI 39 (1909), Series V, vol. 19 Part 3, 272–274.
50. Josephine M. Callwell, Old Irish Life (London 1912).
51. Walter Strickland, A Dictionary of Irish Artists (...), 2 vols. (Dublin 1913).
52. R. J. Kelly, "Dungory Castle, Kinvarra", JRSAI 44, Series VI, vol. 4, Part 2 (1914), 114–131; 49 (1919).
53. Thomas Johnson Westropp, "Appendix 1.–Notes on several forts in Dunkellin and other parts of southern Co. Galway, 167–186: 179–180 [on Dungory Castle].
54. R. J. Kelly, "The old Galway theatres", JRSAI 44 44 (1914), 358–364.
55. G. N. MacNamara, "Bunratty, County Clare. With a study of the castle by Thomas Johnson Westropp", Jn. North Munster Archaeol. Soc., 3 (1913–15), 220–313. (Thomas Johnson Westropp, "The (...) Castle of Bunratty (...)", on 314–327).
56. Thomas Johnson Westropp, "Notes on certain primitive remains (forts and dolmens) in Inagh and Killeimer, Co. Clare", JRSAI 46 (1916) 97–120.
57. Thomas Johnson Westropp, "The promontory forts of Beare and Bantry–Part III, JRSAI 51 (1921), 101–115.
58. J. Coleman, 'The old castles of south-west Cork', Journal of the Cork Historical and Archaeological Society 27 (1922) 63–66.
59. H. G. Leask, "The Collegiate Church of St. Nicholas, Galway", in J. Galway Archaeol. Hist. Soc., 17 (1930), 1–23.
60. Walter Alison Phillips (ed.), History of the Church of Ireland from the earliest times to the present day, vol. III The modern church (London 1933).
61. R. A. S. Macalister, "The History and Antiquities of Inis Cealtra", PRIA 33, C (1933), 93–174.
62. George Dames Burtchaell and Thomas Ulick Sadleir, Alumni Dublinenses: a register of the students, graduates, professors and provosts of Trinity college in the University of Dublin: 1593–1860 (Dublin 1935).
63. C. J. F. McCarthy, "St. Finbar and His Monastery", in Journal of the Cork Historical and Archaeological Society 41 (1936) 85–91.
64. William Petty Lansdowne (sixth marquis of Lansdowne), Glanerought and the Petty-Fitzmaurices (London 1937).
65. James Hornell, British coracles and Irish curraghs, with a note on the quaffah of Iraq (London 1938).
66. G. MacSpealáin, "Notes on Place Names in the City and Liberties of Limerick", MA. Munster Antiq. J., 3 (1942–43), 110.
67. John J. O'Shea, "The Churches of the Church of Ireland in Cork City", in Journal of the Cork Historical and Archaeological Society Ser. 2, 48 (1943) 30–35.
68. John J. O'Shea, "The Non-Conformist communities of Cork city" Ser. 2, 48 (1943) 35–43.
69. R. F. Hewson, "St. Mary's Cathedral, Limerick: its development and growth", North Munster Antiquarian Journal 4 (1944–45) 55–67.
70. Edward MacLysaght (ed), The Kenmare Manuscripts (Dublin 1942). (Reprinted Shannon: Irish University Press 1970).
71. M. Moloney, "Mungret", North Munster Antiquarian Journal, 4 (1944–45) 1–15.
72. Frederick George Hall, The Bank of Ireland 1783–194 (Dublin 1949).
73. D. O'Brien, History of the O'Briens from Brian Boroimhe A.D. 1000 to A.D. 1945. [With plates, including portraits, and genealogical tables.](London 1949).
74. Luba Kaftannikov, "The High Crosses of Kilfenora", North Munster Antiquarian Journal 7:3 (1956) 29–30.
75. M. MacSweeney and J. Reilly, "The Royal Cork Institution Part I: 1803–1826", in Journal of the Cork Historical and Archaeological Society 62 (1957) 22–36.
76. P. Tohall, "The Diamond Fight of 1795 and the Resultant Expulsions", Seanchas Ardmhacha (1958) 17–50.
77. Etienne Rynne, "Was Desmond Castle, Adare, erected on a ringfort", North Munster Antiquarian Journal, 8 (1958–61) 193–202.
78. D. D. C. Pochin Mould, 'The Pilgrimage to Gougane Barra', Journal of the Cork Historical and Archaeological Society 67 (1962) 82–88.
79. G. A. Lee, "Medieval Kilmallock", Jn. North Munster Archaeol. Soc., 9/4 (1962–65) 145–154.
80. Olive C. Goodbody, Guide to Irish Quaker Records 1654–1860 (...) (Dublin 1967).
81. F. M. Hilliard, 'Philip Ronayne, Gent.', J. Kerry Archaeol Hist. Soc., 1 (1968) 41–45.
82. R. Ffolliott, "An 18th Century Abduction", Irish Ancestor, 1 (1969) 69–75.
83. A. Gwynn and R. N. Hadcock, Medieval Religious Houses of Ireland ... (London 1970).
84. Eileen M. McCracken, The Irish woods since Tudor times: distribution and exploration (Newton Abbot 1970).
85. M. Quane, "Kildimo Seminary, Co. Limerick, 1808–1817", North Munster Antiquarian Journal, 15 (1972) 28–33.
86. J. Anthony Gaughan, Listowel and its Vicinity (Cork 1973).
87. Roger Stalley, "Corcomroe Abbey, some observations on its architectural history", JRSAI 105 (1975), 25–46.
88. Thomas Joseph Barrington, Discovering Kerry: its history, heritage and topography (Dublin 1976).
89. Frank Mitchell, The Irish Landscape (London 1976).
90. Patrick Conlan, Franciscan Ireland: the story of seven hundred and fifty years of the Friars Minor in Ireland with notes on all the major sites associated with the friars and a brief description of the other members of the Franciscan family in Ireland (Cork 1978).
91. George Cunningham, Burren Journey (Limerick 1978).
92. Mark Bence-Jones, Burke's guide to country houses, Vol I: Ireland (London 1978).
93. John Hunt, "Heritage in Stone", North Munster Antiquarian Journal 20 (1978) 63–79.
94. P. Hogan, "The migration of Ulster Catholics to Connacht 1795–6", in Seanchas Ardmhacha (1979) 286–301.
95. George Lennox Barrow, The round towers of Ireland: a study and gazetteer (Dublin 1979).
96. Edward Malins and Patrick Bowe, Irish Gardens and Demesnes from 1830 (London 1980).
97. Hugo Read, "The Penroses of Woodhill, Cork: An Account of their Property in the City", Journal of the Cork Historical and Archaeological Society, 85 (1980) 79–98.
98. P. E. Roberts, "Caravats and Shanavests: Whiteboyism and faction fighting in East Munster, 1802–11", in: Samuel Clark and James S. Donnelly Jr (eds), Irish peasants: violence and political unrest 1780–1914 (Manchester 1983) 64–101.
99. David E. Allen, "The Herbaria of Joseph Woods", Watsonia 14 (1983), 273–274.
100. M. Carey, St. Fin Barre's Cathedral (Dublin 1984).
101. C. Lynch, Bunratty Castle (Dublin 1984).
102. W. A. Watts, "Contemporary Accounts of the Killarney Woods 1580–1870", Irish Geograph, 17 (1984), 1–13.
103. W. Colfer, "The Tower of Hook", J. Wexford Hist. Soc. 10 (1984–5), 68–78.
104. Etienne Rynne, Tourist Trail of Old Galway, 3rd edition (Galway 1985).
105. Gerard J. Lyne (ed), 'Rev. Daniel A. Beaufort's tour of Kerry, 1788', Journal of the Kerry Archaeological and Historical Society 18 (1985) 183–214. [Available online at CELT.]
106. C. Adrian Empey, 'The Norman period 1185–1500', in William Nolan and Thomas G. McGrath (eds), Tipperary: history and society (Dublin 1985).
107. Hugh Weir, Historical, Genealogical, Architectural Notes on some Houses of Clare (Whitegate 1986).
108. Angela Fahy, "Residence, workplace and patterns of change: Cork 1787–1863", in P. Butel and L. M. Cullen (eds), Cities and Merchants: French and Irish perspectives on urban development (Dublin 1986).
109. Ray Desmond and Christine Ellwood, Dictionary of British and Irish botanists and horticulturists ... (London 1977, rev. edn 1994).
110. Donal Synnott, Botany in Ireland, in: John Wilson Foster; Helena C. G. Chesney (eds), Nature in Ireland: a scientific and cultural history (Dublin 1997).
111. Helena C. G. Chesney, 'The young lady of the lichens: Ellen Hutchins (1785–1815)', in: Mary Mulvihill, Stars, shells and bluebells: women scientists and pioneers (Dublin 1997) 28–39.
112. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
113. Jane O'Hea O'Keeffe, Voices from the Great Houses (Cork: Mercier Press 2013). Includes a section on the Hutchins family.
114. Robert Wood, The ruins of Balbec, otherwise Heliopolis in Coelosyria (London 1757).
**Joseph Woods (1776–1864): Life and Works**2. See the Oxford DNB, online edition, at http://www.oxforddnb.com/view/article/29935
3. Joseph Woods, "An essay on modern Theories of Taste" [London 1808].
4. Essays of the London Architectural Society, by Edmund Aikin ... Samuel Beazley ... Joseph Woods (London 1808).
5. Joseph Woods, "Synopsis of the British Species of Rosa", Transactions of the Linnean Society 12 (1818), 159–234.
6. Joseph Woods, "On the rocks of Attica", Geological Transactions 1 (1824) 170–72.
7. Joseph Woods, Letters of an Architect from France, Italy, and Greece. 2 vols. (London 1828).
8. Joseph Woods (ed), The antiquities of Athens. Measured and delineated by James Stuart F.R.S. and F.S.A. and Nicholas Revett painters and architects, volume 4 (London).
9. Joseph Woods, "Botanical Excursion in the North of England, Companion to the Botanical Magazine 1 (1835), 288–299. [Available online at http://www.biodiversitylibrary.org].
10. Joseph Woods, "Account of a botanical excursion into Brittany, in a letter addressed to the Editor", Companion to the Botanical Magazine 2 (1836) 263–282. [Available online at http://www.biodiversitylibrary.org].
11. Joseph Woods, Notes on Some of the Schools for the Labouring Classes in Ireland (Lewes 1841).
12. Joseph Woods, "Notes of a botanical excursion in France in the summer of 1843", The Phytologist: a popular botanical miscellany, vol. 1 (1841–1843), December 1843, 785–801; 828–834; 853–865. [Available online at http://www.biodiversitylibrary.org].
13. Joseph Woods, "Note on Carex teretiuscula", The Phytologist: a popular botanical miscellany, vol. 1 (1841–1843) 1140–1141. [Available online at http://www.biodiversitylibrary.org].
14. Joseph Woods, "Botanical Tour in Germany", The Phytologist: a popular botanical miscellany, vol. 2 (1844–1847) 16–20; 33–42; 65–73. [Available online at http://www.biodiversitylibrary.org].
15. Joseph Woods, "Notes of a botanical ramble in the North of Spain", Journal of the Proceedings of the Linnean Society: Botany 2 (1858), 111–125. [Available online at http://www.biodiversitylibrary.org].
16. Joseph Woods, The Tourist's Flora: a descriptive catalogue of the flowering plants and ferns of the British Islands, France, Germany, Switzerland, Italy, and the Italian (London 1850).
17. Joseph Woods, "Some botanical notes made during a tour through a part of Ireland in June and July, 1855, with occasional remarks on scenery, etc., in a letter to the Editor", in Phytologist, n. ser. 1 (1855), 121–7, 156–9, 207–210.
18. Ray Desmond and Christine Ellwood, Dictionary of British and Irish botanists and horticulturists ... (London 1977, rev. edn 1994).
**The edition used in the digital edition**2. **Gerard J. Lyne**, **M. E. Mitchell**, A Scientific Tour through Munster: The Travels of Joseph Woods, Architect and Botanist, in 1809 in North Munster Antiquarian Journal, Ed. . , Limerick, The Thomond Archaeological Society (1985) volume 27 page 15–61

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 15–61 (footnotes pp 46–61). The tour is complemented by Dillwyn's tour through the South of Ireland, available on CELT in files E800005-001 and E800005-002.


#### Editorial Declaration


##### Correction


The text has been checked and proofread twice. All supplied text is tagged. Text supplied by the editors is marked sup resp="GJL".


##### Normalization


The electronic text represents the edited text. Woods' quote 'to spy the nakedness of the land' was previously used by Laurence Sterne in his Sentimental Journey; the words 'the nakedness of the land' go back to the Old Testament, Genesis 42:12, in the King James Bible. The phrase 'Irish Balbeck', echoed by Woods on p. 33 of the edition, was applied to Kilmallock in Campbell's Philosophical Survey of the South of Ireland, p. 213.


Woods' journal has been segmented into entries in chronological order, though he does not give dates for every entry, and it has been synchronised as far as possible with the parallel account by Dillwyn. Occasionally abbreviations in the text (mainly referring to botanical terms) or in the notes have been expanded silently at CELT.


##### Quotation


Direct speech is rendered q.


##### Hyphenation


Soft hyphens are silently removed. Words containing a hard or soft hyphen crossing a page-break or line-break have been placed on the line on which they start.


##### Segmentation


div0= the description; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd. Date values are encoded.


##### Interpretation


Names of people, places and botanical terms are tagged. Titles of books, articles and periodicals, as well as words in other languages than English, are marked.


#### Canonical References


This text uses the DIV1 element to represent the entry. ### Profile Description


Created: By Joseph Woods (1776–1864)
 Date range: 7 July to c. 18 October 1809.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Many botanical terms are in Latin.


##### Language: [GA] Some words are in Irish.


##### Language: [FR] A word in the introduction is in French.


### Revision History


* (2014-09-25) Beatrix Färber (ed.)

* SGML and HTML files created.
* (2014-09-08) Beatrix Färber (ed.)

* File proofed (2); markup checked; bibliographic details added. File parsed and validated.
* (2014-09-04) Beatrix Färber (ed.)

* File proofed (1), structural and content encoding applied, including personal and place names and botanical terms; titles of bibliographical items such as articles, books, periodicals. Footnotes added and encoded.
* (2014-08-14) Beatrix Färber (ed.)

* Text converted to XML; TEI header created.
* (2014-07-03) Beatrix Färber (text capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800005-003


### The Travels of Joseph Woods, Architect and Botanist, in 1809: Author: Joseph Woods




---

p.15


### A Scientific Tour through Munster: The Travels of Joseph Woods, Architect and Botanist, in 1809


Joseph Woods (1776–1864) visited Ireland from July to October 1809. Two fellow naturalists, L. W. Dillwyn and W. E. Leach, accompanied him from Waterford to Killarney where he remained for a time before making his way northwards, through Limerick and Clare, for a brief visit to Connemara, returning by roughly the same route. Woods' narrative contains many interesting observations on local antiquities, topography and natural history together with occasional comments on social conditions.


On July 7, 1809, three British naturalists sailed from Swansea to Checkpoint in Co. Waterford, and, from a diary kept bygone of the group, Lewis Dillwyn,[1](javascript:footNote('E800005-003/note001.html')) we know that it was their intention to travel on to Limerick. Though Dillwyn provides only the surnames of his companions, they have been identified as William Leach[2](javascript:footNote('E800005-003/note002.html')) and Joseph Woods. That the latter also left a record of his visit did not become known until recently, when it was observed that the anonymous author of Bradshaw Add. MS 43 423[3](javascript:footNote('E800005-003/note003.html')) refers to the friends who accompanied him to Ireland in the summer of 1809 as Dillwyn and Leach. The party reached Killarney on July 19 and a week later Woods, for reasons of health, decided to remain there for a time; as a result his companions cut short their visit and returned to Wales on July 31. Woods stayed in the Killarney area until August 23 and then travelled slowly northwards through Tralee and Tarbert to Limerick, where he remained for some ten days before moving into Co. Clare. From Ennis he continued to Lisdoonvarna, via **Milltown Malbay**, and traversed the Burren en route to Kinvara. Following a brief visit to Connemara his return journey, which was equally unhurried, brought him again through Galway, Limerick and Cork to Waterford where, in the latter half of October, he embarked for **Milford Haven**. (See map, Illus. 1) Joseph Woods (Illus. 2) was born of Quaker stock in Stoke Newington, London, on August 24, 1776. He attended a Friends' school in Tottenham where Dillwyn, whose family also belonged to the Society, was a fellow pupil. Woods' formal education appears to have ended at the age of thirteen when he was sent to Folkestone, in the company of Dillwyn, for the benefit of his health. Woods was to take an enduring interest in his physical condition and maintain a careful record of it until his death at the age of eighty-seven.
In 1792 he joined a firm at Dover in order to gain commercial experience, with a view, presumably, to entering his father's export business. Woods proved to have little aptitude 


---

p.16




---

p.17



for trade, however, and soon relinquished the position in favour of Dillwyn. It was at this time that the two men began to pay particular attention to the study of plants.
At the age of twenty-two Woods decided to pursue an interest in design and entered on a period of study with a London architect. He subsequently established his own practice but, in 1816, following an unfortunate structural failure which involved him in costly
litigation, he left England. He spent the next three years on the continent where he gave his time to the study of botany and architecture. His observations in the latter regard were published in 1828 under the title Letters of an Architect from France, Italy and Greece.


On his return to England Woods did not resume practice; instead, being possessed of private means, he devoted himself to his interest in plants. In 1833 he took up residence with his sister in Lewes, and began work on a comprehensive manual of field botany. For this purpose, in addition to excursions in Britain, he revisited the continent in 1836, 1843 and 1844. His book, entitled The Tourist's Flora: A descriptive Catalogue of the Flowering Plants and Ferns of the British Islands, France, Germany, Switzerland, Italy, and the Italian Islands, appeared in 1850; he was engaged in a revision of the work at the time of his death in 1864.
During his years in London, Woods had assisted in the management of a number of schools and this led him to take an interest in the activities of the Irish Board of National Education, established in 1831. He crossed to Dublin on June 5, 1840, and between then
and August 26 visited schools in counties Dublin, Down, 'Derry, Donegal, Sligo, Mayo, Galway, Clare, Limerick, Tipperary, Kilkenny and Wicklow. The observations which he made in the course of this journey were published in the following year.[4](javascript:footNote('E800005-003/note004.html')) At the age of seventy-nine Woods again travelled to Ireland, but on this occasion his energies were devoted to plant collecting in the south-west, and in the account subsequently published[5](javascript:footNote('E800005-003/note005.html')) he refers to the visit of 1809. His narrative of that visit makes it clear that his principal aims were to provide a topographical account of the country travelled, record the occurence of interesting plants and comment on buildings of note.


In his observations on scenery, Woods emphasises the importance of woodland as a component of the visual environment, and in this regard his disenchantment with the Irish countryside is a recurrent theme. At Ennistymon, for example, he remarks ‘Nature has been favourable but the usual complaint occurs of want of wood’and of Connemara he comments ‘Here are rock, mountain and water in great perfection, what a pity that the fourth ingredient of natural landscape should be lacking’. Ideally, however, the landscape should also give evidence of human activity — writing of Kenmare he observes ‘Nature seems to have done everything possible to form some of her loveliest scenes in this valley, it wants nothing but what man can do, more wood and scattered trees and the lines of a more perfect cultivation’. Indeed, on another occasion, he gives it as his opinion that ‘it is not mere wood which gives richness to English landscape but the mixture of wood, cultivation and habitation — the hedge rows, and the trees in them, the sheltered villages and farm houses with their orchards, and the Spire embosomed in Elms or Eughs. There is nothing of all this in the generality of Irish scenery’. In the contemporary conflict of opinion concerning landscape aesthetics, it is clear that Woods had greater partiality for the perspective of **Arthur Young**'s tours than for that of **William Gilpin**'s.


Despite this preoccupation with paysage, Woods does offer some observations on the social conditions then obtaining in Ireland. His commentary is the more valuable because he does not appear to have shared the strong racist and sectarian prejudices of his travelling companion, Dillwyn. He was, for instance, sympathetically disposed towards Catholic emancipation and showed an interest in the material welfare of the population. The fact that his mother's people, a family named Hoare, had Irish connections may have influenced



---

p.19



his attitude. His interest in architecture led him to devote considerable space to accounts of public buildings and gentlemen's seats, in addition to ecclesiastical and other antiquities; though these commentaries have been superseded to an extent, it has nonetheless been decided to retain them here. Further topics touched upon range from a local folk-tale to a description of keening at a funeral. He displays unusual appreciation of the social mechanisms that were already in operation prior to the Famine, and forecasts, albeit not quite accurately, that ‘when the annual produce of the country can increase no longer’ growth in numbers will result in ‘a vast population, starving, ignorant & extremely discontented’.


However, given Woods' opportunities to record his impressions of the people among whom he lived for upwards of three months, it has to be said that his narrative leaves a good deal to be desired. His curiosity in the realm of social customs and conditions is limited, his information is often derivative and his style generally pedestrian. In comparison with Dillwyn, who had an eye — clouded, sadly, by prejudice on occasion — for original detail, Woods appears earnest, well-meaning and rather colourless.


That Woods wrote the account of his visit with a view to publication may reasonably be concluded from the fact that, on a number of occasions, he addresses himself to ‘the reader’ and from his statement ‘I do not presume in this little essay founded on so short a stay in the country to give a complete account even of the small part of the Island which I visited. I only endeavour by my mite of information to add to the little knowledge we possess of the country’. From internal evidence it is clear that the manuscript is no more than a preliminary draft, and it would appear that Woods, for reasons unknown, left it as such.


It should be noted that, as presented here, Woods' manuscript has been pruned to about three-quarters of its original extent by omitting his lengthy scenic descriptions and geological observations together with derivative or inconsequential material; punctuation has been amended in a number of instances, but these nowhere merit editorial comment. The pagination of the manuscript is somewhat ambiguous because two numbering sequences have been employed, one referring apparently to folios, the other to individual pages. The latter system has been adopted here and the original page numbers are incorporated, in square brackets, within the text; the addition of the letter 'A' indicates the repetition of a page number in the original. Editorial deletions are reflected by hiatus of varying extent in the sequence of bracketed numbers. Supplementary notes which occur at the end of the manuscript are inserted at relevant points in the text, with their pagination also in square brackets.


*Acknowledgements*


For their kind assistance, we wish to express our sincere thanks to Mr. T. Collins, The Hardiman Library, University College, Galway; Dr P. De Brún, Dublin Institute for Advanced Studies; Dr D. Dickson, Trinity College, Dublin; Miss G. Douglas, The Linnean Society of London; Mr F. Gillespie, National Library of Ireland; Dr J. T. D. Hall, Edinburgh University Library; Mr K. Hannan, Limerick; Mr M. Joyce, Bruree, Co. Limerick; Dr E. MacLysaght, Tuamgraney, Co. Clare; Mr P. Melvin, Oireachtas Library; Miss M. O'Dwyer, Cork County Library (Midleton Branch); Mr D. Ó Lúanaigh, National Library of Ireland; Mr D. Pyke, Clonmel, and Dr K. Whelan, National Library of Ireland.




---

p.20


The Journal
-----------


While I was quietly waiting at the hospitable mansion of my friend **Mr Rotch** expecting my intended fellow Travellers to breakfast I received a message from Capt. Hawkins requiring my attendance on board the vessel which was to convey us to Ireland and before I could reach **Milford** I had the mortification to see the packet under weigh. Mr Rotch furnished me with a boat and I soon reached them and found my companions Messrs. **Dillwyn** and **Leach** on board [p. 3]


The coldness of the weather drove me down into the cabin where I fell asleep and missed the Smalls*,* a rock about 8 leagues from the coast of **Pembrokeshire** on which a light is kept. The poor light keepers living in a box supported on a few posts in the midst of the ocean whence except in very clear weather no land is visible. On coming up again from the cabin the **Saltees** were in sight and we soon were near enough to remark their striking similarity to the country we had left.


The evening was fine and as the sun gradually disappeared behind the Waterford mountains my imagination was busied with the romantic scenery and the Alpine plants I was to discover in their recesses. After a long period of almost continued rain in [p. 4] **South Wales**, it seemed like a favourable omen to approach the land of clouds on such a delightful evening. The approach of night prevented us from seeing much either of the soil or scenery in the Waterford River. The Light house stands on a tongue of Limestone called **Hook Point**[6](javascript:footNote('E800005-003/note006.html')) — otherwise all seemed to be of the argillaceous rock of which I had seen so much in Wales and was to see so much more in this country.


Three of the largest Rivers in Ireland, the **Suire**, the **Barrow** and the **Nore** unite to form this estuary which preserves down to its mouth the form and character of a river — it is bounded on each side by steep banks which want the variety as well [as] the richness of wood.


It was dark before we reached **Cheek Point** — where is a large dirty uncomfortable inn[7](javascript:footNote('E800005-003/note007.html')) for the reception of the Packet Passengers. We had heard much of the strictness of search of the custom house officers. The searcher however was gone to bed and we were told our luggage must remain locked up for the night. [p. 5] This intelligence determined me to secure a small vallise containing what was necessary for the night and morning. My companions were obliged to apply for theirs and an under searcher undertook to deliver them. ‘We'll take your honour for the contents only just open it for forms sake’. **Dillwyn** mentioned a pair of shoes, which he said were half worn out ‘O we'll trust to your honour implicitly only just let us look at them’.


They are forbidden to take any fees, but after they had examined the remaining baggage in the morning they came to ask for something ‘just for packing up the trunks again’. All this is completely Irish and made us remember if we could have forgotten it that there was sea between us and home. It was with difficulty that one of my companions could be persuaded that the milkiness of the eggs we had at
breakfast was not another peculiarity of this country.


[p. 6] **Waterford** is a large city computed to contain 35,000 inhabitants.[8](javascript:footNote('E800005-003/note008.html')) It is, however, no part of my plan to give long histories of the Cities & Towns of Ireland copied from other books or dictated from Irish Hearsays. I do not presume in this little essay founded on so short a stay in the country to give a complete account even of the small part of the Island which I visited. I only endeavour by my mite of information to add to the little knowledge we possess of the country. **Carlisle** says it had no bridge[9](javascript:footNote('E800005-003/note009.html')) which is a mistake as it has a wooden bridge built I believe by an American of the name of **Cox**.[10](javascript:footNote('E800005-003/note010.html')) [p. 7] We found the Commercial Hotel at **Waterford** a very good inn but were nevertheless so impatient to begin our search after plants and insects that we would willingly have left it the day we arrived, had we been able to engage a chaise & horses soon enough for that



---

p.21



purpose. We procured one to take us the journey the next morning for which we were to pay one guinea per week besides all expenses but with Liberty to discharge it when and where we pleased and moreover to pay the driver 3/9 1/2 i.e. 3/6 English per day. This difference of money[11](javascript:footNote('E800005-003/note011.html')) has often been noticed and tho apparently of easy remedy still remains the same. The Irish in fact reckon by English money but they change the name.


If an Irish shopkeeper were to demand 7/- or 21/- for any article his customer would be at a loss to conceive what could have induced him to fix on such odd sums. An Irishman who prided himself on his correct English pronunciation went into a shop in England and purchased a walking stick the price of which was two and six pence. Without having any reason to suppose that his accent had betrayed him, he threw down half a crown but as he did not leave the shop the master asked him if he wanted anything else — he was waiting for his change. ‘No, Sir. The [p. 8] stick was two & sixpence’, and ‘I gave you 2/8 1/2’. ‘I presume Sir you are from Ireland’. The disappointed Hibernian turned on his heel and left the shop.


Some other peculiarities immediately strike every Englishman on his arrival in this country. The strongly aspirated dialect called the brogue[12](javascript:footNote('E800005-003/note012.html')) — the confusion of will and shall — the want of neatness and finish in almost everything*,* the coarseness of the lower class of females and the convenient car put close to the horse and recovering his dung[13](javascript:footNote('E800005-003/note013.html')).


We left **Waterford** early in the morning of the 9th of July and directed our course to the neighbourhood of the **Monavoullagh mountains**. There is a decent inn at **Newton** where we breakfasted, but proceeded immediately afterwards to **Kilmacthomas** whence we determined to ascend the mountains on foot as our driver informed us the road ‘was not properly navigable nearer to them’. We afterwards repented of this arrangement for except in one spot close by the Village where they are now building a bridge the road was not bad for full 2 English miles and the distance was far greater than we had been taught to expect.


[p. 9] Our botanical harvest was not very rich but unfortunately we were too late in the day to be able to reach the summit of the mountain. All the lower country is under the plough except where its operations are here and there interrupted by a bog. The divisions are formed by stone walls or banks of earth. Every part cultivated but not well cultivated an arrangement altogether devoid of interest to every species of traveller. Amongst the corn we picked up **Spergula pentandra**,[14](javascript:footNote('E800005-003/note014.html')) in the bogs **Pinguicula lusitanica**[15](javascript:footNote('E800005-003/note015.html')) and on the mountains abundance of **Saxifraga umbrosa**,[16](javascript:footNote('E800005-003/note016.html')) at which we felt more pleasure than we probably should have done had we known how very common a plant it is thro great parts of the Country. **Saxifraga stellaris**,[17](javascript:footNote('E800005-003/note017.html')) **Rhodiola rosea**[18](javascript:footNote('E800005-003/note018.html')) and some other common mountain plants and mosses occurred, but the state of my health had rendered the ascent so fatiguing that I was not capable of a very accurate examination.


 [p. 10] The mountains contain several deep hollows some of which are occupied by pools of water. It was in one of these that I botanized but in one without a lake. The views from the elevation we attained were very extensive over a broad featured country whose outline is almost everywhere pleasing but the scene is deplorably naked; it is not mere wood which gives its richness to English Landscape but the mixture of wood, cultivation and of habitation — the hedge rows, and the trees in them, the sheltered villages & farm houses with their orchards, and the Spire embosomed in Elms or Eughs. There is nothing of all this in the generality of Irish scenery. There may be trees in the view but if such as this should happen they are collected into a wood not scattered over the country. There are no hedges — the cottages are not collected into [p. 11] villages but scattered about; forlorn hovels, uniformly without shade. A sum of money was appropriated in the reign of **Queen Anne** for building churches,[19](javascript:footNote('E800005-003/note019.html')) but what were erected are never anything better than little



---

p.22



barns and if there were any in the scene from these mountains they passed undistinguished among the cottages; and there is nothing like a comfortable farm house. The appearance of comfort exhibited in the dwellings of the peasantry is one of the most delightful characters of English scenery. The Irish peasantry seem cheerful & disposed to be content but certainly there is nothing very pleasant in the appearance of their dwellings and I never saw a cottage or Farmhouse in the Country in which I could fancy for a moment I should like to reside.


At about 7 o'clock we got back to **Kilmacthomas** where our Postboy was very unwilling to let us get a dinner as he told us the unsettled state of the country made it unpleasant to be out after dark but I believe his fears magnified the danger and indeed this was the first and last apprehension [p. 12] of the sort that we experienced[20](javascript:footNote('E800005-003/note020.html')). We were too late to see much of the country till we arrived at that town **Dungarvon**.


**Dungarvon** is a small town at the bottom of a deep bay of the same name. There are some remains of a large old church perhaps of the Abbey of Regular canons said by Carlisle to have been founded in the 7th century by a disciple of St. Finbar, but the same author informs us that of this there are no remains.[21](javascript:footNote('E800005-003/note021.html')) The most remarkable circumstance in the remaining fragments is that the West end is pierced with 6 small circular windows instead of one large one[22](javascript:footNote('E800005-003/note022.html')).


On the point opposite the town are ruins which appear to have constituted a castle & an abbey.[23](javascript:footNote('E800005-003/note023.html')) We did not visit them but from several points of the town & Coneygar their union has a picturesque effect.


This town is whimsically celebrated for its fruit and timber[24](javascript:footNote('E800005-003/note024.html')). [p. 13] A long sandy slip of ground called the Conegar[25](javascript:footNote('E800005-003/note025.html')) (a rabbit warren), divides the harbour from the bay. On this according to Smith*'*s History of Waterford[26](javascript:footNote('E800005-003/note026.html')) grows the **Gladiolus communis**.[27](javascript:footNote('E800005-003/note027.html')) It is not often that a botanist is entitled to say positively that a plant does not grow in the place pointed out for it but I think in this case as three of us were employed some hours in traversing a narrow strip of land for a plant which even out of flower would have been very conspicuous. I may safely assert that the plant does not grow there. We did not meet with any other rare plant to reward our labours unless it be a small viola which tho [it] very much resembles the tricolor[28](javascript:footNote('E800005-003/note028.html')) is perhaps a distinct species.


The road from **Dungarvon** to **Youghall** is exceedingly bad. A single hill divides **Dungarvon** from the valley of the **Blackwater** so that one ascent and one descent brings the Traveller to **Clashmore** . The Hill is broad and the Valley narrow, a style of country which accompanied us with little interruption till we reached the mountains in the Western part of the County of **Cork**.


[p. 14] I have often wished for a boundary of distant mountains to the rich vales of **Kent** — here with ground equally well-disposed we have such a boundary but there is no wood and tho almost the whole is an enclosed country no [p. 15] hedges (let alone trees in them), the divisions are mere banks of earth or stone with a little furze at the top or in the language of the country Earth or stone ditches made of furze. No trees either for shelter or fruit about the Villages and farm Houses but all naked and dreary.


[p. 16] In Ireland the idea suggested by the word mountain seems to be mere cultivated land. In **Connemara** (a mountainous country) I was directed to cross a mountain. I engaged my director to accompany me and found the mountain to be a bog, not indeed flat, but of trifling elevation.


[p. 17] At **Clashmore** the **Blackwater** has no breadth of valley and no grandeur of shore — it winds between cultivated hills descending with a steep slope to the waters edge.


**Youghall** is seated on the south side of the Estuary of the **Blackwater** immediately under the bank. I several times have heard it spoken Of as a pretty situation, but I think the Irish are generally fond of these confined scenes. We had been directed to Campbell*'*s Hotel at



---

p.23


**Youghall**, but they refused to take us in as they had not beds enough — a circumstance [p. 18] we afterwards thought very fortunate as the situation of Howards (the **York Hotel**) is much pleasanter, the people more civil and as far as we could Judge the accommodations more comfortable.


[p. 19] The hill above **Youghall** resembles those on the other side of the River. Descending from it we overlook the valley in which **Castle-Martyr** is situated. The hills which bound this are comparatively low and the vale itself has less undulation than that of **Dungarvon**, but the outlines are still pleasing and still naked — as we advance however we find more finishing. The approach to **Killeagh** affords some scenes of great beauty — **Killeagh** itself is a very pretty town or village, well-mixed with trees & might be taken for a small English Town but for the advantage which it possesses of very wide streets.[29](javascript:footNote('E800005-003/note029.html')) This neighbourhood is I think the finest part of the vale which continues very pleasant till we leave it. **Castle Martyr** is a seat of the Earl of Shannon.[30](javascript:footNote('E800005-003/note030.html')) The house is not visible from the road but the grounds appear to be well wooded.


We got to **Middleton**, whose waters flow into the Sea, without crossing any marked elevation.


[p. 20] A little beyond **Middleton** is a gentlemans seat placed on a bleak hill[31](javascript:footNote('E800005-003/note031.html')) while a beautiful little sheltered vale within the domain offers some excellent situations. I have in general seen little to admire in Ireland in the Gentlemans Seats either as to form or situation. The principle of the latter seems to be [to] see & be seen, the former is that of a high square box. I do not mean to give this as a rule without exception but the traveller in Ireland will meet with numerous examples. The first part of the road between **Middleton** and **Cork** is much inferior to that we had past. The latter is exquisitely beautiful — fine woods cover the side of a steep hill down to the water. On the opposite side is a highly embellished island[32](javascript:footNote('E800005-003/note032.html')) and a great extent of cultivated plain bounded by distant hills is exhibited from various parts of the road, but there are no mountains which to me, who had taken my ideas in great [p. 21] measure from the Maps, was rather a disappointment.


The little valley of **Glanmire** particularly pleased us but by the time we reached it it was too dark to see much and as I afterwards visited it more at leisure I shall postpone any description of its scenery.


**Cork** is a large City containing according to the estimate of its citizens 120,000 inhabitants. In 1788 it appears that the houses were 8093 some of them containing 50 inhabitants but the average was estimated at 10 at least.[33](javascript:footNote('E800005-003/note033.html')) Since then the city has increased very much, but when one observes the multitude of little mud cottages in the Suburbs it seems difficult to conceive so many as 10 to an house — it must be acknowledged however that they swarm with inhabitants.


 [p. 22] Some of the streets are very fine with openings gained in rather a singular manner by filling up the docks, or perhaps rather the canals which used to divide **Cork** into several islands & which all served the purpose of docks. There are good houses but no public buildings of much consequence. The cathedral[34](javascript:footNote('E800005-003/note034.html')) is only a modern Church and the Church of the Holy Trinity[35](javascript:footNote('E800005-003/note035.html')) which is larger than the cathedral attracts more notice from a remarkably ill formed spire than from any other circumstance. There are five other parish Churches, a French Church[36](javascript:footNote('E800005-003/note036.html')) and three Roman catholic chapels but none of these are conspicuous buildings and an English traveller feels very sensibly the want of some lofty and important object to attract the eye in a general view of the city. Above the city is a long straight walk planted with trees called the **Mardyke** which is the usual promenade — it runs along a dead flat but is nevertheless pleasant & will probably be more so as the banks of the valley above **Cork** abound with fine situations very capable of improvement and the situations below the town are pretty fully occupied. The banks seem hardly to offer



---

p.24



sufficient room for the country houses of the merchants and Gentlemen of the district of the 
**Lee** below the city and those above are capable of great beauty and ornament. [p. 23] The River **Lee** below **Cork** flows between steep banks — wide apart. That on the north side is the steepest and highest and being covered with fine wood is the great ornament of the place — both sides are woody and adorned,perhaps crowded,with Gentlemen*'*s seats, some of which are very handsome and very well placed. A scientific institution[37](javascript:footNote('E800005-003/note037.html')) has lately been Established in this city. **Mr. Hincks**[38](javascript:footNote('E800005-003/note038.html')) is Secretary pro tempore and professor of Botany*,* chemistry and natural philosophy. It is very far from his wish to take so wide a range but Literature and Science are hardly yet far enough advanced at **Cork** to support a professor in each science. The institution however is increasing & seems likely to increase. I believe all the establishments of this nature in Ireland are not intended for the promotion of pure science but are intended to preside over its application to the common purposes of life including those objects which in London we [p. 24] attribute to several distinct societies. Thus the Cork society may be compared to a sort of aggregation of all our scientific societies — together with the Royal institution & the society for the encouragement of Arts & manufactures[39](javascript:footNote('E800005-003/note039.html')).


It proposes not only to furnish food for the mind but also to teach people their business & to show manufacturers the best & cheapest way of producing their articles. This institution gives lectures on agriculture and farming as well as on botany and natural philosophy. It gives premiums for the culture of hemp & of potatoes, Encourages green crops & red clover & assists the farmers with Seed and directions. The Dublin Institution[40](javascript:footNote('E800005-003/note040.html')) I believe extends also its protection to antiquities & the fine arts but I do not know that the Cork establishment has yet attempted anything of that sort.


[Note, p.182] The Cork Institution has a botanic garden which to judge of the future by what has been already effected promises to do great credit to the Directors. The ground is extensive [and] well situated, tho not having the advantage of any bog or marsh Land. The Directors have taken an additional piece in a bottom to receive the plants which require such circumstances. It is well arranged and well managed as **Mr. Drummond the Chief Gardener**[41](javascript:footNote('E800005-003/note041.html')) seems fully equal to the duties of his Situation, [p. 26] He has found in the neighbourhood of **Cork** rare plants. **Hypericum calycinum**[42](javascript:footNote('E800005-003/note042.html')) grows in several places; we only saw it in one & there the habitat was about to be enclosed in the Garden of a new built house. Mr. D. remembers it before the house was in existence. It is mentioned in Smith's History of Cork[43](javascript:footNote('E800005-003/note043.html')) published in [*...*] and may therefore probably be considered as a naturalised if not an indigenous plant. He has also observed a **dianthus** in the Limestone House quarries which he thinks is **Dianthus plumarius**[44](javascript:footNote('E800005-003/note044.html')) — & one of his men brought him a root of a syngenesious plant with which I am totally unacquainted it has the habit of a **Lapsana** but the seeds are crowned with a Pappus[45](javascript:footNote('E800005-003/note045.html')).


The man pointed out the meadow in which he thought he had gathered it but he did not seem sure and we searched for it a considerable time in vain. **Hypericum dubium**[46](javascript:footNote('E800005-003/note046.html')) is very abundant and we were conducted to the habitats of **Sedum dasyphyllum** & **Sedum Forsterianum**[47](javascript:footNote('E800005-003/note047.html')).


[p. 27] The 13th was occupied on my part in calling on several friends of my Mother*'*s family[48](javascript:footNote('E800005-003/note048.html')) in **Cork** and I endeavoured to learn among them the particulars of the road we proposed pursuing thro' **Clonikilty** & **Skibbereen** to **Bantry** and **Killarney**. The roads we had heard were bad but I was gratified by being told they were certainly passable by a Carriage. A place called **Googan Barra** was also pointed out to me as an object worth notice. It is a lake at the head of the River **Lea** surrounded by high naked mountains. In the lake is an island covered with wood connected by a causeway to the mainland and containing the ruins of a Cathedral dedicated to St. Finbar[49](javascript:footNote('E800005-003/note049.html')).


 [p. 28] A fine spring of water close to the lake is a principal object in one of the most



---

p.25



singular festivals in the Island. At Mid-summer eve the people of the country throng here in vast numbers and as there is no town in the neighbourhood they pitch their tents on the borders of the lake. The first part of the ceremony is to bathe in the well which is done by both sexes, the men naked, the women in flannel dresses. The number is so great that a constant succession of bathers is said to be preserved day and night for four or five days. After bathing in the well they are to bathe again in the Lake. They then pace round the ruins of the Cathedral and visit each Shrine and chapel a certain number of times. At night the ruins, the island, the well and the Shore are illuminated [p. 29] by torches and the concourse of people in this wild and savage Spot is seen in its most striking point of view[50](javascript:footNote('E800005-003/note050.html')). Two Sketches by an Irish artist of no small talents of the name of **Grogan**[51](javascript:footNote('E800005-003/note051.html')) gave me a very favourable impression of the bold and romantic character of the scenery.


On leaving **Cork**, we were unanimously of opinion that the charges at the Inn (**McDowells Hotel**) were the most exorbitant of any we had any of us met with[52](javascript:footNote('E800005-003/note052.html')). It is but justice to say that the accommodations were good, but I had to complain bitterly of the bugs which I almost always escape in England. They are large and numerous in all the inns we had Slept at but I think we saw no more of them after leaving **Cork**[53](javascript:footNote('E800005-003/note053.html')).


[p. 30] The ride to **Bandon** and **Clonikilty** afforded us little amusement. Both these towns are larger than we had expected but their magnitude depends greatly on rows of mud built cottages. The population seems very great and an Englishman is struck with the number of persons idling about the streets in almost all the Irish Towns.


We slept at **Clonikilty**.


The intelligence we obtained of the roads, induced us to prefer the road by **Dunmanway** [p. 31] to **Bantry** rather than that thro **Skibbereen**. The road we took was very rough and rocky — it is very wide & being at this time (after a very dry season) without vegetation, made a very respectable appearance at a distance but disappointed us sadly on a nearer inspection.


All the country from **Cork** to **Dunmanway** presents an undulating surface, rising by gentle swells to a considerable height — not so great however as to exclude Cultivation — it is mostly under Corn, but the want of trees and Hedges makes the Landscape dreary and uninteresting. There are a few woody spots about Gentlemen*'*s houses; otherwise, I believe, there is not a tree in the Country. As we approach the latter place the eye is amused with a range of bold & rocky mountains on which wood is not so much a stranger. Here too, we saw the first bogs of any extent that we observed in our passage thru an island which we had learnt to consider as the very region of bogs. We had passed some small ones, but they seemed to be rapidly diminishing.


The cultivation of Ireland has been advancing within these few years with astonishing rapidity. [p. 32] Is it not possible that it may increase too fast? The increase of cultivation & consequently of consumable produce will be attended with an increase of population. But I confess I think it possible that it may have proceeded too rapidly & that the country will pay severely and perhaps is paying for the quick increase of consumable produce. If care be taken to dispell the ignorance & increase the comforts of the labouring class, the evil I dread will probably be obviated, but if this is not the case there is danger that the habits favourable to a rapid increase of population will continue when the annual produce of the country can increase no longer & that Ireland will be overburdened by a vast population, starving, ignorant & consequently extremely discontented. Nor perhaps ought we to expect any great exertions on the part of the gentlemen of the country on this head — the Irish are generous & spirited but these qualities have hitherto in general found occupation in another direction. The advantages arising from cultivating the soil are much more obvious than those accruing from improving the mind of the people. [Note, pp. 174–76]


Since this



---

p.26



was written the exertions which have been made all over Ireland for the establishment of Lancasterian Schools[54](javascript:footNote('E800005-003/note054.html')) proves that if the patriotism of the Irish was not previously directed to the improvement of the poor it was only because no road appeared open to them. Independently of the education of the poorer classes a great advantage must necessarily arise from the interest which they will see taken by their Superiors in their welfare.


The situation of the lower classes of Irish is in many respects considerably different from that of similar classes in England. They are generally separated by a difference of language & religion & an Englishman feels a degree of pride in English laws and an attachment to them which an Irishman cannot feel; they are to him the laws of a foreign nation, he has felt them in many instances most oppressively so, & he is still perfectly aware that a foreign dominion can alone preserve the present degraded state of his religion. Nor is the effect of the very unjust laws concerning the catholics yet passed away tho the laws themselves have been repealed[55](javascript:footNote('E800005-003/note055.html')). They have left a marked impression on the manner and habits of the people. They have taught the catholic to survey the protestants with hatred & envy. They have taught the protestants (a still more lasting feeling) to view the catholics with a mixture of contempt and abhorrence. For my part I wish that the remaining laws marking the civil distinctions of the two religions should be abolished because I think a man*'*s conduct & not his religious opinions ought alone to determine his fitness for civil employments; because I think these remaining differences tend strongly to keep up the degrading remembrance of those which have been repealed; and because I think they are made the means of alienating the minds of thousands of Irish from this country by a party whose open or secret wish it is to separate the two nations — a party which I believe owes its remaining strength and consistency entirely to the disabilities of the catholics, [p. 32 contd.] When a gentleman improves his own estate the benefit to himself is at least as great and as conspicuous as that to the public. I do not mean to deny that the truest patriotism is very likely to lead a country gentleman into this line of conduct. But it is also the line of his own interest, & politicians have hardly yet been brought to acknowledge that the [p. 33] prosperity of a country is not to be estimated entirely by its wealth or its population but by the individual happiness and Virtue of its inhabitants.


**Dunmanway** is seated among bogs at the foot of the rocky range of mountains before mentioned. At this season of the year the bogs are scenes of active industry and to judge by the peat stacks adjoining the houses, the extent of them is not more than sufficient to supply the neighbourhood with fuel. At the end of the town a chalybeate spring containing from the accounts we had of its effects some purgative salts rises in an old stone quarry[56](javascript:footNote('E800005-003/note056.html')).


The road from hence winds over the hills passing between the more elevated points. After one considerable ascent and descent we observed the ruins of an old castle, a very fine & picturesque object seated in a wild valley among rocky hills[57](javascript:footNote('E800005-003/note057.html')). The second ascent brought us within view of **Bantry Bay** and the magnificent mountains which surround it. **Hungry Hill** carries its flat top to an [p. 34] immense height. **Mount Owen**[58](javascript:footNote('E800005-003/note058.html')) on the Eastern side of the bay is also very lofty but the intervention of lower hills hides every part but its top. At a division of two roads on the long descent from the high land down to **Bantry** our driver amused us very much by his angry conversation with a man who could not give him a direction in English. After some time he let the man pass & determined to go to a cottage at a little distance. In doing this he overtook the man again and we saw them stop two or three times face to face in earnest conversation which neither of them could understand. ‘Not all the Devils in Hell’ said Pat when he returned ‘can get that man to speak a word in English.’


Lower down we passed a pool abounding with **Lobelia Dortmanna**[59](javascript:footNote('E800005-003/note059.html')) & **Nymphaea



---

p.27



alba**[60](javascript:footNote('E800005-003/note060.html')). **Dillwyn** also discovered a small quantity of **Utricularia media**[61](javascript:footNote('E800005-003/note061.html')) not in flower.


**Bantry** is built at the bottom of a hollow at the head of a little cove in **Bantry Bay**. The [p. 35] long island of **Whiddy** stretches itself opposite to the mouth of the cove & separates a large basin from the bay. There are two or three other small coves in the basin and the sinuosities of the shore have a very beautiful effect. The island of **Whiddy** is composed of a low ridge of hills which do not obstruct the view of the distant mountains. It is quite naked. The other shores of the basin do not abound with wood but there is enough in the immediate neighbourhood of **Bantry** to give some appearance of Shelter. **Lord Bantry**'s park is very pleasant; the house ugly, not large, but well placed[62](javascript:footNote('E800005-003/note062.html')).


[p. 37] We walked along the shore in the evening and admired the beauty of the **Medusae** of which we observed two species which neither L*[each]* or myself have ever seen before.


On the morning of the 17th, we breakfasted at **Mr. Hutchins**[63](javascript:footNote('E800005-003/note063.html')) at **Bally Leckie**. **Mr. S. Hutchins**[64](javascript:footNote('E800005-003/note064.html')) politely rode over to **Bantry** to conduct us — the distance is about 3 Irish miles & the ride most delightful, enjoying fine views over the bay. After breakfast Mr H*[utchins]* provided us with a boat and we went to **Whiddy** to examine the rocks for sea plants — which are there very abundant. The shores within the reach of the tides are very steep & rocky and the action of the salt water has produced an inky blackness on the external surface, [p. 38] The rocks form abundance of deep pools which abound with **fuci** & **confervae**[65](javascript:footNote('E800005-003/note065.html')) of several species — with **Actineae**[66](javascript:footNote('E800005-003/note066.html')) and a beautiful **Echinus** whose colour is a uniform rich deep purple[67](javascript:footNote('E800005-003/note067.html')) and with different kinds of rock fish. We returned to **Ballyleckie** to dinner and afterwards examined part of the copious collections of **Miss Hutchins**[68](javascript:footNote('E800005-003/note068.html')). It is rarely that a solitary observer attains great proficiency in the study of natural history, still more rarely does such an observer collect large quantities of Specimens. Nor is it often that we find a lady giving so earnest an application as to be deeply and accurately skilled in the subject. **Miss Hutchins** tho stationed at such a distant outpost of the scientific world is thoroughly and minutely acquainted with the plants of her neighbourhood (and in Cryptogamous plants perhaps no neighbourhood is richer) collects largely and gives most liberally parting even with her last specimen, and taking to herself the uncertainty of gaining any more.


[p. 39] **Ballyleckie** is beautifully situated at the bottom of a deep cove of the bay. There is still wood on its shores but we were told of a considerable quantity of fine timber on its banks which has been cut down within these few years.


The following morning we again breakfasted at **Mr. Hutchins**' and **Dillwyn** and myself were still further enriched from Miss H*[utchins']* herbarium. About one we left it and soon began to ascend the **Priest's Leap**[69](javascript:footNote('E800005-003/note069.html')). **Mr. Hutchins***'* care had provided no less than 15 men to push our carriage up this tremendous ascent, but we left the labours and dangers of the road to pursue our researches among the rocks and hollows of the mountains. Here we first saw **Saxifraga hirsuta**[70](javascript:footNote('E800005-003/note070.html')), but on the whole we were not very successful. **Isoetes lacustris**[71](javascript:footNote('E800005-003/note071.html')) grows in a small pool near the top. I missed my companions and got considerably before them and meeting three men one of whom could speak English I sent [p. 39a] them a message to let them know I was before. The man undertook it with as much alacrity as if he had received a great favour but as I found afterwards, never delivered it.


[p. 40] The character of the scenery at **Kenmare River** is entirely different from that on **Bantry Bay**. A considerable tract of cultivated land slopes with gentle undulations from the mountains to the water*'*s edge. The mountains themselves are less abrupt and less high than those of **Bantry** except two or three distant summits which just appear in the view. Nature seems to have done everything possible to form some of her loveliest scenes in this valley; it wants nothing, but what man can do, more wood and scattered trees and the lines of a more perfect cultivation. The inn is a new building lately erected by **Lord H.



---

p.28



Petty** (now Marquis of Lansdowne)[72](javascript:footNote('E800005-003/note072.html')). It is roomy and convenient and the Landlady civil and attentive. It has since been burnt down[73](javascript:footNote('E800005-003/note073.html')). [p. 40a] From **Nedeen** to **Killarney** are two roads — the one very mountainous but shorter — the other a better and more level road,[74](javascript:footNote('E800005-003/note074.html')) & more beautiful but circuitous. We decided on the latter and found it wind up the Vale of **Nedeen** & pass between the mountains into **Glanflesk**. The first part of the latter is exceedingly pleasant. Fine woods principally of birch extend along the foot of the mountains & occupy the hollows to a considerable height. Further down some noble cliffs ornamented in the same manner form a magnificent [p. 41] object. They are said to have been the haunts of a noted robber[75](javascript:footNote('E800005-003/note075.html')) whose name and story I forget but the idea is characteristic. After this the ride loses its interest *[and]* we seem before reaching **Killarney** to turn our backs upon the mountains. Some very pleasant woody scenes occur before the Entrance of the town & the road bending to the left offers us a view of the ***Tomies*** and ***Mac Gilly Cuddy's Reeks*** which as we first saw them under a slight haze with the sun behind them appeared stupendous mountains indeed.


**Killarney** is near 2 English Miles from the lake. In England the Traveller has sometimes to regret the distance of his lodging from the point he came to visit, but the distance of **Killarney** is a heavy tax on the pleasure of the place. The leisure stroll on its banks is entirely prohibited. Our first excursion was to **Dunloh Castle**[76](javascript:footNote('E800005-003/note076.html')). [p. 42] **Dunloh Castle** is seated on a steep bank rising immediately above the river. About a mile below the lake the bank of the Castle is covered with wood & the meadows which surround it are richly ornamented with fine trees. The River forms some beautiful pools shaded with fine trees.


[p. 43] This evening we discharged our chaise & Driver. The latter seemed much discontented and told us no *gentlemen* would have given him so little. Sometime afterwards the same man drove me from **Waterford** to **Cheek Point** and assured me of the gratitude he felt towards me for having treated him so generously at **Killarney**.


We rose on the 21st intending to spend the day on the lake. We had engaged a boat in the evening but in the morning we were told we could not have one. Thus disappointed we ordered our breakfast at the Inn intending to walk to **Mucruss**. Just as we had finished a boat was offered to us but when we had agreed to take it, the men were [p. 44] dissatisfied with the quantity of beer provided and would not go. We again determined on a walk but this indifference immediately made the quantity of beer sufficient. This is a common case at **Killarney**. The men have a monopoly but are restricted from making an open advantage of it & they consequently will cheat if they can or extort a present — and the whole system is attended with so much inconvenience, that tho doubtless intended for the accommodation of travellers no traveller can visit **Killarney** without wishing **Lord Kenmare** at the devil for his pains. If everyone were at liberty to let out his boat & the pay both for the boat & for the men published the traveller would be less open to imposition. The power which can prohibit all boats from being let would surely be able to effect this — but I do not know [p. 45] whether it would have any ill effects on the fishery of the lake by increasing the number of boats, which it certainly would do.


The walk to **Ross Castle**[77](javascript:footNote('E800005-003/note077.html')) where we take boat is not unpleasant but it is a great deal too long to be enjoyed as a daily walk. We rowed down **Ross Bay** and passed between the Island of **Ross** & **Innisfallen** (pronounced Innizvalen) to the open part of the lake. The longwoods of **Mucruss** stretching at the foot of the **Turk** are very beautiful. **Glenaa**[78](javascript:footNote('E800005-003/note078.html')) was covered merely with copse woods except near the place where we leave the lower lake where a small portion of its old magnificence remained but these were destined to fall before the following May[79](javascript:footNote('E800005-003/note079.html')). **Lord Kenmare** granted a lease of the woods for 13 years which expires at that time. The **Eagles Nest** is a noble object, [p. 46] The lower part is finely



---

p.29



wooded — the nest is immediately beneath an overhanging crag at about one third of its height from the summit.


The water was low and we were obliged to leave our boat to be pushed up the rapids at Old Weir Bridge & at another shallow place above it. We were amused with the echos at the **Eagles Nest**; our performer was a most miserable one, and either himself or his instrument, I know not which but I believe both, was unable to master the tune of God Save the King. **Dillwyn**, who piques himself on his loyalty, insisted upon it but it was in vain to insist on impossibilities. However, he gave us the opportunity of hearing the echos here and in several other places & they are certainly amazingly fine — the whole [p. 47] range of mountains answering like a stretched string when the correspondent note is struck. The effect of the cannon is loud and distinct but far inferior to the beautiful swells and falls of the equally celebrated echo of **Lodore**[80](javascript:footNote('E800005-003/note080.html')) — which again would not have strength to return the finer notes of music.


[p. 50] We ate the Dinner we had brought with us at the cottage on **Ronans island**[81](javascript:footNote('E800005-003/note081.html')). Our Boatman caught some small trout as we ascended the lake but we left them [the] fish to satisfy their appetite as it was Friday & as Roman Catholics [they] would not touch meat.


On the 22nd **Leach** and myself ascended **Gheran Tuel**[82](javascript:footNote('E800005-003/note082.html')) the highest mountain in the Neighbourhood. D*[illwyn]* was not quite well and did not accompany us. We rose at four, but the people about us were not very punctual and we did not set off till past 5. The inn we were at was Coffee*'*s — where there is on the part of Miss Coffee who has the management the greatest attention, civility & desire to oblige. I may add the greatest and most indefatigable activity but there is no method & no order & the inn consequently is not a comfortable one. I do not imagine that the other Inns here are better in this respect. They are probably worse in others & a second visit to **Killarney** would therefore [p. 51] lead me again to Miss Coffey*'*s.


We went on three horses — one for each of us and one for our guide. At the bridge at **Dunloh** our guide took up another man behind him to *show him the way*. We passed near the Castle and bending to the right directed our course towards a deep hollow at the foot of the mountain where we arrived at last rather with our horses than on them for the latter part of our way (road there was none) was so rocky and so boggy that both **Leach** and myself preferred walking. We soon arrived at a Mountain pool of which I could not learn the name[83](javascript:footNote('E800005-003/note083.html')) — it abounds with **Isoetes lacustris** and with a variety of **Potamogeton natans**[84](javascript:footNote('E800005-003/note084.html')) having leaves whose length is about 4 times their width.


[p. 52] A sort of Valley of moderate ascent continues from the pool. In the valley above the pool we gathered **Saxifraga hirsuta** but it does not grow high up the mountain. Higher up we met with **Rhodiola rosea**, **Rumex digynus**[85](javascript:footNote('E800005-003/note085.html')), **Asplenium viride**[86](javascript:footNote('E800005-003/note086.html')), **Cyathea fragilis**[87](javascript:footNote('E800005-003/note087.html')) and **Saxifraga hirta**[88](javascript:footNote('E800005-003/note088.html')) of English Botany which was at first I believe called adscendens by **Mackay**.


**Saxifraga umbrosa**[89](javascript:footNote('E800005-003/note089.html')) is very abundant & grows on the very summit of the mountain.


[p. 55] On Monday the 24th, after an early breakfast, we undertook to ascend **Mangerton** tho the aspect of the morning was very doubtful. We walked along the Mucruss River nearly as far as **Cloghreen**[90](javascript:footNote('E800005-003/note090.html')) and then turned to the left. This road nowhere touches the margin of the lake and is for the most part confined between high walls which exclude all view of it. [p. 56] Like all the mountains in the neighbourhood, **Mangerton** contains several lakes in its bosom. The *[Devil's]* punch bowl[91](javascript:footNote('E800005-003/note091.html')) is seated remarkably high. The only plant at all rare was **Rumex digynus** but the rain came on at the punch bowl and tho I did search the rocks above it yet it was not to the extent I should have wished in finer weather. **Empetrum nigrum**[92](javascript:footNote('E800005-003/note092.html')) and **Lycopodium Alpinum**[93](javascript:footNote('E800005-003/note093.html')) grow on the summit which is boggy. By the time we had descended the rain ceased and we had a delightful walk thro the woods at **Mucruss** down to the quay where Captain White[94](javascript:footNote('E800005-003/note094.html')) had provided a boat to take us to his house at **Ross Island**.




---

p.30


I had left **London** on account of my health but I hardly perceived any amendment during a stay of about a month in **South Wales** and the constant travelling during the time I had been in Ireland was evidently hurtful. I determined therefore if I could meet with a lodgings at all tolerable in this [p. 57] neighbourhood to stay some time at it and leave my companions to return by themselves.


On Tuesday the 25 June therefore, I walked to **Mucruss** to examine one which Miss Coffey had heard of for me and finding it such a one as might do very well for a few weeks I engaged it at 1/2 a [? guinea] [? per] week, the Landlady undertaking to get everything done that I wanted. The house belonged to **Mr. Herbert**'s[95](javascript:footNote('E800005-003/note095.html')) Gardner & was close at the entrance of the grounds, nothing to be seen from the house but a plantation of young firs, but the most delightful scenes within a few yards. On my return I found that L*[each]* and D*[illwyn]* had neither been able to procure a boat for the day or to engage a carriage to take them to **Mill Street** on the following.


On the 26th we walked down to Ross mines[96](javascript:footNote('E800005-003/note096.html')) in order to borrow Capt. White*'*s boat to bring us to O'Sullivan*'*s cascade. The men were drawing up the ore which is embedded in the limestone rock. Some of it is grey but the greatest quantity has the appearance of pyrites some of which contains a very large proportion of copper but not so much as the grey ore.


[p. 58] We first landed at **Innisfallen** a most beautiful island covered with Ash & Eugh *[i.e. yew]* & with Holly and Alder of uncommon size and beauty. We landed at a little quay. **Tomies** was once bare but **Mr. Herbert** has now enriched it with plantations to which every year adds consequence. On the other hand, **Glenaa** was once covered with fine oaks where now there is nothing but brushwood. O'Sullivan*'*s cascade is a beautiful spot but contained very little water.


[p. 59] At about 7 o'clock next morning my companions left me on foot not being able to get any conveyance except that of a car for their baggage. The road they had to go is straight, dusty, enclosed only by stone walls without the least shade. After getting my breakfast I also left **Killarney** to seek my lodgings at **Mucruss**. There I lived like a hermit for three weeks, during which time I traversed a good deal of country in the immediate neighbourhood rapidly gaining health and strength. The weather which till this time had been almost always fine now changed for the worse and during the rest of my stay in Ireland I never experienced two fine days together and seldom even one day without rain.


[p. 78a] The antiquities of this district are not very numerous — **Mucruss Abbey**[97](javascript:footNote('E800005-003/note097.html')) is a pleasing ruin with the characteristic features of the Irish abbey. The eagerness of the common people to have their friends buried within the consecrated walls occasionally produces unpleasant scenes in most of the Irish ruins and in none has this been more noticed than in that at **Mucruss**.


[p. 79a] Two copper mines have been worked at **Killarney**. They furnish a grey ore which is very rich in metal and a yellow *pyrites* which is also rich tho inferior to the former. Some cobalt has also been found. The mine at **Ross** is now worked; that at **Mucruss** has been abandoned in consequence of the water of the lake finding its way in & drowning some of the men. The ore is bedded in the limestone which dips gradually to the South & in both instances the mine follows the *slope* of the limestone under [p. 80a] the bed of the lake.


[p. 83] During my stay at **Mucruss** I only saw one funeral procession & this I was assured was a very moderate one as it was that of a protestant & the Catholics are more attentive to keep the old forms; yet it was numerously attended — the women chanting if the expression may be [Note, p. 177] applied to such a noise. After a child had exhausted itself in the first paroxisms of rage or grief it will frequently continue a sort of measured cry & if any person will conceive this multiplied by perhaps two or three hundred voices he will have no bad idea of an Irish howl. The coffin is not shut up in a hearse but laid on a



---

p.31



sort of car which is not inelegant and a female sitting at each corner, seems lost in the profoundest grief, at intervals leading the oo loo low. This is here called *keening* & according to my information the performers are not paid for their sorrow but do it to be neighbourly. The men never keen except for a near relation.


The women & children in the remoter parts of Ireland seem generally to be ignorant of English or at least to know it so imperfectly as to be unwilling to speak it. The men almost [p. 178] universally understood, but they speak it with hesitation as if it were a foreign tongue & with little of that peculiar accent which marks an Irishman in this country.


[p. 83 contd.] On the 23rd of August on a showery morning having hired a man and Horse to carry my Luggage I quitted **Mucruss**. In spite of the bad weather, I had enjoyed so much pleasure there that I began to feel an affection for the place and its inhabitants. I left it with many good wishes — God send you safe home, God prosper you & send you good luck were the burden of them all. The recommendation to good luck is so constant that one might [p. 84] say that God and good Luck seem to be the deities worshipped by the Irish. After being detained some time at **Killarney** I proceeded on my walk towards **Castlemain**. I had promised myself several sketches on the road but the Showers were so frequent and the clouds hung so heavy on the mountains that I was disappointed. The country is undulating consisting of gravel hills with the rock bursting thro in one or two places without trees and ill cultivated.


**Castlemain** is a miserable place. Miss Coffey told me I should get accommodations and so I did such as they were. The room I was in — at once my sitting room & bedroom — had neither floor or ceiling. It had two windows one 2' 6 [p. 85] by 1' 6 — the other about half of each of these dimensions. I observed to my Landlord that they had a good deal of wet in this part of the country ‘Yes’, he replied ‘it rains here always mostly.’ In the evening I walked a little way along the Dingle road & was overtaken by a man who had the appearance of a farmer & who pressed me much to visit that part of the country assuring me they were all honest people and never had anything to do with rebellions.


[p. 86] 24th. The morning was rather wet but as it seemed clearing I sent my baggage along the road to **Tralee** & procured a guide to conduct me over the mountains. Before I parted my Landlady *strenuously* recommended me to a lodgings at **Tralee** because the inns were so extravagant & to her nephew at **Listowel** who she said was a butcher there and knew the country well. She advised me also to go down to **Ballylongford** and go in a passage boat to **Limerick**, a plan which I afterwards adopted as nearly as circumstances would permit.


A ridge of Mountains apparently forming a branch or rather a continuation of the [p. 87] Dingle mountains under the name of **Slieve Meesh** extends to the north of **Castlemain** & forces the road to **Tralee** to make a considerable bend in order to get round it. I observed in these a rocky hollow to which I ordered my guide to conduct me. In the way I had some noble views over **Dingle Bay** and to the **Iveragh Mountains** but the latter were never entirely clear. The showers were frequent and the ground wet and boggy which together prevented me from sketching. On reaching the cliffs I had observed, I was disappointed in finding their height very trifling, but was afterwards gratified by finding abundance of **Saxifraga palmata**[98](javascript:footNote('E800005-003/note098.html')) tho out of flower. At the summit of my walk I had a last view of the lake of **Killarney**. On the other side was a wide uninteresting country without any [p. 88] bold or beautiful features. The **Shannon** was just visible, but the atmosphere was dull and hazy. In such a mountain as **Slieve Meesh** there is little Botany. I passed thro the manufacturing town of **Blennerville**[99](javascript:footNote('E800005-003/note099.html')) to **Tralee** & remarked with regret that I had turned my back on the beauties of Ireland. There seemed nothing before me to attract the eye or please the imagination. [p. 89] I did not at all admire the look of the lodgings recommended by my



---

p.32



Landlady at **Castlemain** and took up my quarters at the **Crosby Arms** — where however I only obtained a bed on condition it should be but for one night as the races were to begin the next day.


I paid very reasonably for my accommodations at **Tralee**. The morning of the 25th was introduced by heavy showers but with beautifully fine intervals in one of which I set out. Here is nothing either rich or beautiful*,* the views are very extensive but principally over bog or over country cultivated [p. 90] indeed but presenting to the eye of the traveller none of the advantages of cultivation. The road winds over some hills forming the base of a ridge of mountains of little elevation called the **Stacks**. The views extend from the **Killarney mountains** on one side and to those of **Clare** on the other. To the left the ruins of **Abbey Odorney**[100](javascript:footNote('E800005-003/note100.html')) excited some curiosity but having a long day*'*s walk before me I was afraid to go out *[of]* the way to visit them. In the midst of the valley stands a large house[101](javascript:footNote('E800005-003/note101.html')) and not far from it what I took for a summer house; a round temple built on the top of a little hill ‘to spy the nakedness of the land’. It is a bad object — and seems placed in a situation which the Lover of Nature would carefully avoid. It may perhaps be the mausoleum of **Thomas, the first Earl of **Kerry****[102](javascript:footNote('E800005-003/note102.html')). What a difference between what is and what might be in such a country as this if instead of bog *[it]* had trees houses and cultivated lands. The ruins of the abbey of [*...*][103](javascript:footNote('E800005-003/note103.html')) seem considerably [*...*] but they were still farther from [p. 91] me than those at **Odorney**. Beyond it appeared the round tower at **Ratoo**[104](javascript:footNote('E800005-003/note104.html')). On the right of the road near the house of a Mr. Elliott who was killed by the ***White Boys*** is a woody dale — a scarce feature in Ireland since the peculiar form of country we call a dale is rare here as well as wood. At **Listowel** the river **Feal** runs pleasantly between high and woody banks. There is an old castle[105](javascript:footNote('E800005-003/note105.html')) not much in itself, but well situated and of rather a singular form. Fearful of not meeting the packet boat at **Ballylongford** I hurried away from **Listowel** as soon as possible. The Road from this place to **Ballylongford** was for the greater part of the way, over a bog, deep, rich and considerably elevated. The road excellent. ‘Now tell me, Sir’, said my Carrier who had before been grumbling at the roads and lamenting for [p. 92] those at **Mucross**, ‘is not this an elegant road’. The Banks of the **Shannon** where we first see it are very pleasing. Whether the packet boat had sailed or whether as appeared to me rather to be the case there is no such thing as a packet boat I could not distinctly make out. At any rate no boat was going when I got to **Ballylongford** and as I could get no bed at the place I was obliged to proceed to **Tarbert**. This necessity prevented any examination of the ruins at **Lislaghten Abbey**[106](javascript:footNote('E800005-003/note106.html')) which are just by **Ballylongford**. Near **Tarbert** the views over the **Shannon** are particularly fine. **Holy Island** with its round Tower and ruins[107](javascript:footNote('E800005-003/note107.html')) makes a very good object.


I got excellent accommodations at **Tarbert** and there I paid off my carrier — determined to get a boat if I could or if not to try to procure a Chaise to **Limerick**. He had complained sadly on the road of the dearness of provisions but I had given him what he called his breakfast at **Listowel** (consisting of bread & cheese & [p. 93] Porter at past 2 o'clock) and he seemed very well satisfied with his bargain. I gave him a few shillings over. ‘I am very well paid, indeed I am.’ So different is the character of the lower Irish in the country, from what it is when spoilt by the habit of attending at inns and winning their bread by importunity to travellers. From the time I got my lodging at **Mucross** till I reached **Limerick** I never paid any money which was not received with thankfulness & content, tho I paid less than I did in the towns where it was always considered as insufficient.


The morning of the 26*th* was windy with mizzling rain. With some difficulty I got on board a turf boat, unconscious of the risk I ran of not being able to reach **Limerick** that night. I afterwards heard that it was seldom that these boats could [p. 94] reach **Limerick** in a single tide and certainly I must have passed a very uncomfortable night on board one of them.




---

p.33


The **Shannon** from about two miles below **Limerick** to the sea is a very wide irregular river. The Banks are in some places tolerably wooded and adorned with Gentlemen*'*s seats — each sheltered with its own plantations & some of these are of considerable importance both as to extent and the size of the Timber. There are also [p. 95] two or three conspicuous ruins on its shores.


Limestone continues to occupy the valley and lower eminences on both sides of the River above **Limerick** and it is said that to this circumstance the City was indebted for its present name. The old name was [*...*][108](javascript:footNote('E800005-003/note108.html')). Approached from the water **Limerick** seems to consist of lofty warehouses and high brick houses — in fact its chief buildings [p. 96] are good brickhouses for its public edifices are neither large nor numerous.


[p. 97] Having desired my friends to write to me at **Limerick** I felt rather impatient to receive their letters & I was not disappointed.


27th. Being Sunday I went to Meeting and afterwards delivered my letters to **Joseph Harvey**[109](javascript:footNote('E800005-003/note109.html')) who invited me to take up my quarters at his house which I readily accepted. Between the meetings I walked about **Limerick** and up to the top of the Tower of the Cathedral[110](javascript:footNote('E800005-003/note110.html')) — the only one in **Limerick**; whence is a very good view of the City and of the *Fertile* vale of the **Shannon**. There are [p. 98] considerable remains of the town walls and of an old castle,[111](javascript:footNote('E800005-003/note111.html')) and a little way over the bridge on the road to **Quinpool** these objects unite into a very picturesque whole.


The next day my friends introduced me to **Mr. R. Newenham**[112](javascript:footNote('E800005-003/note112.html')) and to **Dr. Vize**[113](javascript:footNote('E800005-003/note113.html')). The former is a man of sense & taste and having a situation in the barrack office which has obliged him to travel about a great deal on the Irish coast he understands the geography of its shores better than any person I have met with. He showed me several drawings by **Grogan** whom I before mentioned as an Irish Artist & some of whose performances I had seen and admired at **Cork**. These drawings increased my respect for his talents. **Dr. Vize** is I believe the only botanist at **Limerick** — he seems well acquainted with the plants of the neighbourhood but has not found time from his professional duties to make any thing like a complete collection.


[p. 99] On Tuesday I botanized under **Dr. Vize**'s direction in the neighbourhood of **Limerick** & returned to Dinner at Mr. Newenham*'*s where out of a party of 20, 15 had the name of Hoare — the name of my mothers family.


I had heard of the falls of the **Shannon** and I rode over to **Castle Connell** to visit them. The name is rather unfortunate as they are merely rapids not impassable by boats but the scenery is delightful — a large and rapid river flowing between banks covered with fine wood — sometimes rocky & perpendicular, sometimes sloping gently from the waters edge — divided in places by woody islands — Gentlemen*'*s seats — the village of **Castle Connell** and the Castle[114](javascript:footNote('E800005-003/note114.html')) erected on a steep rock.


[p. 100] On the 31st August I left **Limerick** for an excursion to **Kilmallock** a place which has been called the **Balbec**[115](javascript:footNote('E800005-003/note115.html')) of Ireland. There are perhaps about 15 or 16 old houses of the same date and all about equally in ruins but many of them partially used by the construction of thatched hovels within the walls. The date on one of the Chimnies is 1648. Part of the town walls are remaining — two gateways, one of which is now the town gaol,[116](javascript:footNote('E800005-003/note116.html')) an Abbey, and a large Church[117](javascript:footNote('E800005-003/note117.html')). The Houses and gateways are called Castles by the inhabitants.


[p. 102] A range of Brown Stone hills crosses the road from **Limerick** to **Kilmallock** at **Loch Gur** — a very pretty piece of water, and the broken rocky hills which bound it, but quite naked. In a well which they were digging at the new infirmary[118](javascript:footNote('E800005-003/note118.html')). I was informed that they had to pass through a considerable thickening of hard rock before they arrived at the Limestone.




---

p.34


After returning to **Limerick** I visited the new Library[119](javascript:footNote('E800005-003/note119.html')) an institution still younger than that at **Cork** but which I am persuaded the spirit of the Irish will not permit to linger in an unformed state.


[p. 103] On the 5th of September I again left **Limerick** to make an excursion westward and set out on the stage for **Ennis**. The road passed thru a pleasant country with fine views over the **Shannon** and **Fergus** and the rich lands which border both rivers. We overtook the funeral just on leaving the town of a Mr. Fitzgerald[120](javascript:footNote('E800005-003/note120.html')) a funeral I lamented much in the course of the day as two or three gentlemen to whom I had letters had left home to attend it. We passed thro' **Newmarket** where we changed horses at an inn most charmingly situated. Beyond this begin those tracts of naked rock which are said to be so abundant in the county of Clare. About Clare there is a great deal of this. It is all limestone. There are patches of green among the worst parts but in some places these are very diminutive. At **Ennis** no Gentlemen to whom I had letters were at home. I therefore amused myself with a walk to **Clare abbey**,[121](javascript:footNote('E800005-003/note121.html')) a pleasing ruin in itself but exciting [p. 104] the usual regret from its Nakedness. I afterwards walked into the Church Yard at **Ennis** where there were two funerals and several people besides crying over the graves of their deceased relatives. This is a common practice. A new funeral recalls or is supposed to recall the emotions of grief for those who had been not long buried. The Church[122](javascript:footNote('E800005-003/note122.html')) has been a large building but a very small part of it is now used for Divine Service*,* the rest is unroofed — the East window is singular & has a very fine effect.


[p. 105] After this walk I called on Mr. Weldon[123](javascript:footNote('E800005-003/note123.html')) to whom I had a letter and by his assistance procured a man and car to carry my baggage and in the morning set off to cross **Mount Callen** to **Miltown**. The road offers extensive views over the vale of **Fergus** but they are naked with only here and there a patch of woods. **Mount Callen** and the whole country round it is covered with a peat bog. There is a pretty strong chalybeate spring on the ascent. Before reaching the top at a very great distance to the North appear the summits of two distant mountains the smaller conical the larger with a flat top at a distance that implied great elevation. [p. 106] These lofty eminences always excite my attention — the rarest plants are found on high mountains or their neighbourhood.


Near the highest part of the road is a druidical altar or as it would be called in **Wales** a **Cromlech** composed of two thick slabs placed on edge parallel to each other and another laid upon them[124](javascript:footNote('E800005-003/note124.html')). I got on the top and had an extensive view in three directions.


The road hence to **Miltown** is all on a peaty soil but most of it very dry. A great quantity of oak and fir is dug up in these bogs not turned black as is frequently the case but preserving at a little distance from the surface the appearance and colour of fresh wood. Some native oak still remains in Ireland but the fir formerly [p. 107] the most abundant seems to be totally extirpated. I was informed that in this neighbourhood the trees uniformly bore marks of fire near the roots — the tradition of the country is that they were burnt in order to destroy the wolves and robbers with which they were infested. The whole shore shows evident traces of having been once covered with a forest extending many miles in all directions tho now trees will not bear the violence of the western winds[125](javascript:footNote('E800005-003/note125.html')).


On the 7th the morning was wet. **Miltown** is a long Irish mile from the shore to which after Breakfast I walked down. It is bordered by sand hills consisting in great measure of broken shells. In one part they are traversed by some old foundations which *[are]* very slight, but not easily accounted for in such a situation[126](javascript:footNote('E800005-003/note126.html')). [p. 108] There is a great deal of the brownstone which is used in the rougher parts of some new buildings but it does not bear the tool so well as the Limestone — which is either brought by sea from the isles of Arran or (as the landing is very bad so that nothing can approach the shore in rough weather) by land from **Kilfenora**. Mr. Morony[127](javascript:footNote('E800005-003/note127.html')) is here building or rather has built a large Hotel



---

p.35



with excellent baths and there are many lodging houses scattered about. The look of the lodgings is not very tempting but the Hotel is well contrived. I confess however that the best accommodations seem to me but poor inducement to spend the Summer in so dreary a situation as **Miltown Malbay**. Mr. Morony has taken a great deal of pains to make trees grow. He plants them under the shelter of a wall but as soon as they reach the top they are [p. 109] cut off by the north west winds — all except the **Tamrisk**[128](javascript:footNote('E800005-003/note128.html')) which flourishes in spite of them but its branches are very brittle. The winds are exceedingly violent and nothing will grow exposed to them*,* not even Currants and gooseberries. Vegetables thrive well — Mr. Morony showed me some **sea kale**[129](javascript:footNote('E800005-003/note129.html')) which he had got from **Mutton Island**[130](javascript:footNote('E800005-003/note130.html')) where it grows wild but it is not found in any other place. Large trees are frequently dug up in the bogs here and the timber as before observed seems very little altered — it is the principal, I believe I might say almost the only, timber to be procured, and is used not only in the cottages but in the hotel above mentioned. Pieces of fir generally squared and not very large are sometimes driven on the shore and now and then a stick of mahogany of considerable value is found. A still better prize is a hogshead of Claret — such a one once fell to Mr. Morony's lot sound and [p. 110] full. It seems to be determined by custom that these drifts belong to the gentleman whose land they first touch and this sometimes is the source of very warm disputes.


On the 8*th* I set off by the road nearest the coast to **Ennistymond**. The solid brownstone gravel covered with bog & some copse wood on the side of one long hill. The road does not come down to the shore till we reach **Laght**[131](javascript:footNote('E800005-003/note131.html')) where the rocks are similar to those at **Milltown**. This village is at the opening of a little valley and enjoys by that mean a more sheltered situation and a pleasanter country than **Milltown** but this indeed is saying no great deal in its favor nor can much be said. I could procure no breakfast at this place and therefore walked on to **Ennistymond** where with some difficulty I obtained what I wanted. **Ennistymond** is seated among little hills with a pretty little river running over its rocky bed. Nature has been favourable but the usual complaint occurs of want of wood. Major O'Brien has [p . 111] a seat[132](javascript:footNote('E800005-003/note132.html')) on a rocky knoll half surrounded by the river — the opposite shore just at that point is covered with wood & there is wood and an orchard on the same side as the house. These may appear trifles but a person who travels much in Ireland will learn to consider them of importance. The house is admirably placed but as usual very ugly. About noon I reached **Kilfenora** situated in a limestone valley imperfectly covered with a bed of rich loam.


**Kilfenora** is a bishops See now united to that of **Killaloe**. It certainly does not look like a rich bishoprick as the town consists only of a few miserable cabins. The Cathedral[133](javascript:footNote('E800005-003/note133.html')) is said to be one of the oldest in Ireland. It has not an atom either of the magnificent or the venerable. The Tower (if it can be called so) is very singular, [p. 112] There are some respectable looking farmhouses in the neighbourhood but they are all in ruins and replaced only by poor cottages. I had a letter from Mr. Morony to Mr. Lysaght, (originally Collesaghta)[134](javascript:footNote('E800005-003/note134.html')) who was good enough to invite me to spend a few days in his house while I looked about the country.


On Saturday I walked to the Castle of **Lemineg**[135](javascript:footNote('E800005-003/note135.html')) an ancient seat of the O'Briens. Like several of the Irish castles it consists of an ancient tower with an addition comparatively recent. The addition is a mere shell — the old tower is still inhabited by some poor families. I had imagined in England that the Irish were much in the habit of sacrificing the younger to aggrandise the eldest son. The County of **Clare** would offer materials of a very different story. It seems always to have been the practice to divide the estates and the [p. 113] event has almost uniformly offered the same illustration of the effect of the practice. A Father may bring up the younger son to some profession or employment and may leave the Elder



---

p.36



in a state to continue the stile and respectability of the family but if he have several sons & divide his property no one can occupy his father*'*s place in society and no one will be content with a lower. Their possessions are soon dissipated and if one more prudent than the rest do not amass instead of dispersing his wealth the estates soon pass into other hands and other names. There is I believe hardly a family in the County which has not experienced vicissitudes of this sort. **Sir Donough O'Brien**,[136](javascript:footNote('E800005-003/note136.html')) the builder of the additional part of this castle, collected an immense property which was divided in this way & of which only a few fragments remain to his descendants. The situation of the castle is neither beautiful nor romantic — among barren looking limestone hills [p. 114] forming the extremity of that singular tract of country called the barony of **Burrin**. There are three crosses[137](javascript:footNote('E800005-003/note137.html')) in the neighbourhood of **Kilfenora** and a few fragments of one or two more castles: within a short distance are some large cromlechs or Druids altars as they are here called but these are said to be larger as well as more numerous in **Burrin**. The most singular remains of antiquity are what are called Danish forts — these are merely thick circular walls of large stones built without cement and perhaps from 50 to 100 feet in diameter. I saw one in **Burrin** which I think exceeded the latter dimension. They are very numerous about **Kilfenora** and in the Barony. I do not know when I have been more puzzled than I was with the first of these that I met with. The large circle caught my attention. I went to it — I walked round it — I got on the top and walked round it there — I went down on the inside which was nearly filled up with rubbish [p. 115] and again returned to examine the out*[side]*. It had no door and its form and arrangement seemed to baffle any attempt to guess at its use. Was it ancient? Was it modern? There were indeed bushes on it but nothing that could determine any considerable antiquity. I have since learned that they are well known and are called Danish forts — why I know not and as for their use and date I am now about as much in a puzzle as ever **Ledwich**[138](javascript:footNote('E800005-003/note138.html')) says.


[p. 116] A little below **Kilfenora** is a large Turlough and there are several smaller ones in the neighbourhood. These are among the singularities of this Country. They are pieces of flat land*,* generally very fine and rich pastures. After continued rain the water rises through some holes or under some rocks on the borders and presently converts them into lakes. After a time the water runs off again generally by the same openings. The subterraneous rivers whose overflowings supply the Turloughs are the only streams in the Limestone country — there is no continued stream of water and no constantly descending valley in which such a stream could run. Mr. Lysaght has cut thro a hill and drained one of these Turloughs at the expense of about £150 and converted a property of £15 per annum into one of about a hundred. Indeed [p. 117] it is impossible to conceive a finer & richer black mould than that of these Turloughs or a closer and more luxuriant herbage. How far this latter might suffer by the draining I cannot tell but I conceive that one advantage is the throwing into one hand what before was common to many — for these Turloughs are mostly commons and they are the only commons I met with in Ireland.


On the 10th about 1/2 past seven I set out to walk to **Doolin** the nearest place on the coast. At a small elevation we left the limestone and soon after had to cross a bog. The road passes by **Lisdoon Varna** where is a good chalybeate spring & considering the accommodations very much frequented. Another spring rises near it which appears by the taste to be aluminous. The peasantry wash their ulcers in it & think they receive great benefit. A number of little shining crystals in the bed of earth in which it is found were pointed [p. 118] out to me as alum but as they were perfectly tasteless I concluded them rather to be gypsum. Both these springs were in a deep ravine whose half naked banks exposed a soil rather earth than rock, of a crumbling shale. Many little Streams about have in like manner worked themselves deep and narrow beds. There is something romantic in the larger



---

p.37



but they want wood — the smaller are so deep and narrow as to be totally inaccessible. I had the good fortune to meet a Mr. Perry at the *Spa* who invited me to breakfast with him — a very acceptable offer as it otherwise seemed doubtful whether I should be able to procure even potatoes and sour milk.


[p. 119] As the shore on the North of **Doolin** is Limestone I was in hopes of being able to observe the junction of the different soils but a space of sand hills intervenes between the ranges of hill and prevented my observation. The cliffs to the South of **Doolin** are the abrupt termination of a range of schistose or rather perhaps of shaly hills[139](javascript:footNote('E800005-003/note139.html')). They are very high, black and perpendicular — the edge of the summit is quite sharp and there can be no doubt that it is the continual action of the sea undermining the base and gaining on the shore which preserves their absolute perpendicularity. They are said to be 1100 feet in height — I think they must be more than half that.[140](javascript:footNote('E800005-003/note140.html')) I was too late for the tide to search for seaweeds on the rocks — but hunted a long while in vain for the **Maiden hair** on the Shore and returned from a long and dreary walk without meeting any botanical recompense.


 [p. 120] Here and at other places along the coast of **Clare** the fishermen use a boat they call the *Corragh* or *naviog*[141](javascript:footNote('E800005-003/note141.html')) & the English Irish a *canoe*. A slight frame of wood gives the shape. The rest is a coarse sort of wicker work covered with a horse skin and secured with woollen yarn. The inhabitants assert that they answer better on these rocky and inhospitable shore than any other make. If by chance they should get a hole some sea weed will stop it up. An Irishman will make shift *any how*. Sure it has done for their fathers before them! They have no keel and are so light that a man may easily carry one on his shoulders.


At a little after 12 on the 11th I took leave of my hospitable entertainers and began my walk thru the barony of **Burrin**. Who has [p. 121] not heard of the Barony of **Burrin** where there is not water enough to drown a man*,* wood to hang him or earth to bury him[142](javascript:footNote('E800005-003/note142.html')) and really this is nearer the truth in a tract of country about 14 miles long and 11 broad (Irish measure) than will readily be conceived by a person who has not seen it or some similar country. It is moreover added to enhance the wonder that the stone walls are transparent — it is the custom of the country to build these walls with stones that shall touch if possible only by the angles and this is said to be done under the notion that the wind passing thro the intervals will not blow them down. Every field is encumbered by stones which in many almost cover the surface so that it certainly is not from any want of materials.


[p. 123] I only observed one **Cromlech** in the way and that not very large, but there are several of the circular ramparts some of a great size. In one of the largest & most perfect the external walls are about 7 feet thick. A cross wall passes thru the centre and one half is again subdivided. I thought that in all of them a similar arrangement might be traced; in many it is very distinct.


A little before reaching ***Corcomroe*** is a small ruin[143](javascript:footNote('E800005-003/note143.html')) rather picturesquely situated on the banks *[of]* [p. 124] what was when I saw it a small lake. It must be remembered however that there is neither tree or bush in the neighbourhood and not very frequent vegetation. The abbey of **Corcomroe**[144](javascript:footNote('E800005-003/note144.html')) is in the same valley but in a still more desolate part. It appears large and I should like to have visited it but I was tired, it was growing late & I was uncertain where I could meet with any sort of accommodation.


Even the valley here is rock with scarcely any covering but straggling patches of the **Dryas octopetala**[145](javascript:footNote('E800005-003/note145.html')) — called here the **Burrin** rose & I think it might almost be called the Burrin grass*,* it constitutes so large a proportion of the whole vegetation. A variety of **Saxifraga hypnoides** or rather perhaps a distinct species,[146](javascript:footNote('E800005-003/note146.html')) is abundant thro most of the district. Yet Mr. Lysaght assured me that great part of the Land of the **Burrin** lets for £2 per acre — its



---

p.38



value depends on affording good winter feed for cattle. I endeavoured in vain to find some sort of lodgings at **Corcomroe**. I therefore proceeded to **Kilvara** *[**Kinvara**]* where bread is sold & where I got a pretty decent bed.


 [p. 125] After breakfasting at **Kilvara** (being still Englishman enough to prefer bread to potatoes when I could get it) I proceeded on my walk. The Northern and Eastern shores of the **Bay of Galway** are neither bold nor woody but they are rocky and very much varied & indented which with the expanse of water produces rather a pleasing effect. On the south the hills of **Burrin** rise almost immediately from it and their pale grey colour perhaps increases their apparent magnitude — yet it certainly is not favourable to the impression of the sublime. Several castles [p. 126] are seen near the coast all of them consisting of a tower, square or nearly so with a gabled roof at the top leaving a gutter allround and a little projection at the Battlement in the middle of each side. The view of that *[at]* **Kilvara**[147](javascript:footNote('E800005-003/note147.html')) may serve for all of them except that few of them are so perfect & very any lower buildings at the base. Indeed, I doubt if these are coeval with the castle. One at **Oranmore**[148](javascript:footNote('E800005-003/note148.html')) is much larger*,* the principal Tower is not square and it has two smaller ones appended to it. The windows are mere loopholes — a modern house has been built against its base.


 [Note, p.178.] The Habitations of the poorer class in the County of **Galway** have I think more appearance of comfort than in most parts of Ireland. They are more collected into villages & the villages have generally a few trees about them, both pleasing circumstances to any Englishman as they remind him of his native country.


 [p. 126, contd.] The City of **Galway** is approached like other Irish towns thro long avenues of mud-walled cottages. It is large, with narrow streets and some uncommonly fine old houses. I had letters to two gentlemen in this city — one was at **Cheltenham**, the other gave me a most friendly reception and invited me to accompany him to **Ross** which would be in my way towards [p. 127] **Connemara**.


A mizzly morning on the 13th kept us in doubt about going from 6 o'clock to 10 when we set off in a Car. The house of Mr. R. Martin at **Ross**[149](javascript:footNote('E800005-003/note149.html')) is situated on the Northern or limestone side of a very long *[lake]* which winds beautifully among rocky hillets some of which near the house are covered with wood. [p. 128] The views up this lake from some parts of the Shore are very beautiful including the high and extended mountain of **Firmnamore** & the conical point of **Shanafolo**.[150](javascript:footNote('E800005-003/note150.html')) I dined & slept at Mr. R. Martin*'*s.


In coming to **Ross** the road offers an extensive view over **Lough Corrib**, the third[151](javascript:footNote('E800005-003/note151.html')) body of freshwater in point of size in Ireland. Its shores are bog or limestone nearly flat except at the Western extremity which penetrates between some slate mountains.[152](javascript:footNote('E800005-003/note152.html'))


Not having made my arrangements the evening before I could not get away from [p. 129] **Ross** till about 12 o'clock accompanied by an excellent guide provided by the kindness of Mr. Martin. The Limestone varying into a black marble with bivalve shells continues to **Oughterard**. There are several natural bridges of Limestone in this part of the Country & the road passes over one of these. My principal object in this part of my excursion was to gather **Erica Dabeoci**[153](javascript:footNote('E800005-003/note153.html')) and **Eriocaulon septanulare**[154](javascript:footNote('E800005-003/note154.html')) and at **Oughterard** I hesitated whether [p. 130] to go to their known habitat towards **Ballynahinch** or direct my course to the tempting hollows of **Firmnamore**. I decided on the first expecting also to have an opportunity of exploring the pins which are said to be the highest mountains in this neighbourhood.


**Oughterard** is a pleasant village built in a Valley of Black marble at the foot of the granite hills. The first 2 miles are over a bog the rock occasionally starting thro the surface. In a part where rather more than usual is exposed I first gathered the beautiful Erica or rather ***Menziesia Dabeoci*** and felt the want of a companion to share my admiration. It grows 



---

p.39



plentifully [p. 131] further on mixed with the Heaths. The rest of the day*'*s journey also the soil is peat, the road running by the side of winding lakes whose beautifully varied line of shore excited no small regret for their nakedness. Here are rock*,* mountain and water in great perfection — what a pity that the fourth ingredient of natural landscape should be wanting. By the roadside in one or two places a marble is found mixed with the granite and as it appeared to me united with it in the same rock — it affords the only lime the country produces beyond **Oughterard**.


In one of these winding lakes I gathered the **Eriocaulon**. It seems to delight in places where the lake has a bottom of soft and rotten peat which renders it very difficult of access. [p. 132] I slept at Lahy[155](javascript:footNote('E800005-003/note155.html')) by the side of a lake[156](javascript:footNote('E800005-003/note156.html')) at the foot of **Shanafolo**.


Friday 15th. Set off to pursue my Journey to **Dericlare** — winding lakes still accompanied the road sometimes on one side sometimes on the other and sometimes on both. As we passed along I observed several settlements of the protestant Irish who were driven from the North in the disturbances preceding the rebellion.[157](javascript:footNote('E800005-003/note157.html')) The habitation is usually so totally free from any look of comfort that a little more or a little less of the forlorn would hardly be noticed by an English eye.


[p. 134] The fine morning exhibited the details of the Mountains before me which in the preceding evening had been entirely lost. The quantity of naked rock is immense. I have no where except in **Burrin** seen any hills so bare of vegetation and there the appearance was produced by the upright faces of the strata whose level surfaces were at least matted over with the **Dryas octopetala** if they had no other vegetation; but here the sloping surface left nothing hid and the hard rock seem [sic] to bid defiance to any decomposition to afford nourishment to plants.


[p. 135] At about 11 o'clock I reached **Dericlare** where I got a breakfast of cake and sour milk. The good woman of the house makes her bread in a potato kettle & that was occupied by a loaf which she was making for a party of Sportsmen who had pitched their tents on an island in a lake at a little distance; & so desirous was she to procure them a good meal that when the loaf was done she could not get it out of the pot. I had to walk to a small collection of huts called a village about 1 1/2 *[miles]* off in order to procure a guide acquainted with these mountains. The clouds descended rapidly and I had hardly set off when we were enveloped in a thick drizzle. Under such circumstances I was obliged to give up the ascent but I walked some distance up a valley called **Glan Hohy**.[158](javascript:footNote('E800005-003/note158.html')) [p. 136] I was told of a silver mine at *[the]* top of one *[of]* the mountains the silver of which splits into thin flakes — undoubtedly mica. Wet and hungry I returned to **Dericlare** where I got some Salmon & Potatoes and a clean bed tho it must be confessed not a very magnificent apartment.


The next morning was as wet as the preceding afternoon had been, so that seeing very little prospect of being able to ascend the pins I began my return to **Galway**. My hostess took the money I gave her without looking at it & expressed her sorrow that she could not afford to entertain strangers without being paid for it. The first part of the way was over a wet bog by no means flat at the head of **Glan Inock**.[159](javascript:footNote('E800005-003/note159.html')) This bog was called a mountain in the instructions given to my guide. **Glan Inoch** is a wild valley containing a considerable lake[160](javascript:footNote('E800005-003/note160.html')) whose [p. 137] islands are covered with wood & embosomed in magnificent mountains. Those to the south are the pins of **Ballynabola**[161](javascript:footNote('E800005-003/note161.html')) on the North are what appear in **Taylor***'*s map[162](javascript:footNote('E800005-003/note162.html')) to be called the **Mamturk mountains** but which if I understood right are known in the country by the name of Maum Crocoloum.[163](javascript:footNote('E800005-003/note163.html')) At the foot of these we stopped at a village (such as I had seen the day before) to enquire our road & entered a hut where there were I suppose a dozen young men. The silence and gravity of the party put me in mind of what we are told of the meetings of the North American Indians. I crossed these mountains by *?* what in **Cumberland** would be called a hawse[164](javascript:footNote('E800005-003/note164.html')).



---

p.40



A long winding descent brought us into **Glan Glosh**[165](javascript:footNote('E800005-003/note165.html')) (the Green Valley). It is wider than **Glan Hohy** and the slopes are less even. It opens into another Valley, **Glan Ross**,[166](javascript:footNote('E800005-003/note166.html')) which stretches if my information be correct from **Lough Corrib** to the sea shore.[167](javascript:footNote('E800005-003/note167.html')) [p. 138] We continued along the valley to **Lough Corrib** the upper extremity of which is quite Landlocked and has the appearance of a small detached lake. One hill on its Northern shore is covered with wood.[168](javascript:footNote('E800005-003/note168.html')) We crossed it in a ferry boat with a large hole in the bottom stopped up by a sod, the fragment of a broken oar on one side & a crooked branch of oak to supply the place of one on the other. We soon got into the road by which we had approached **Dericlare** and slept at a cottage about two miles from **Oughterard**. A conspicuous object in this part of the country is the mountain of **Firmnamore**. The top is flat, of considerable, extent, and it*[s]* hollows retain the latest snow in the year. The country people tell you of a city on the top of it, the marks of whose paved streets are still distinctly visible crossing each other at right angles and the quern stones provided for the inhabitants to grind their corn have long supplied all the wants of the district. The City however was never built. After paving the [p. 139] streets and providing the Hand mills the founder changed his mind and built his city at **Galway**.


17th. The walk to **Ross** was over ground I had traced before. I arrived at Mr. Martins in good time for breakfast and his kindness joined to some fatigue detained me there the rest of the day. I looked on the boggy side of the lake for the **Eriocaulon** as I had before examined the limestone shore for the same purpose but I did not find it[169](javascript:footNote('E800005-003/note169.html')).


18th. I had made my arrangements to set out early this morning from **Ross**, but a soaking rain prevented me. This relaxed at about two o'clock. I observed in my walk the **Erica Daboecia** in small quantity on my way to **Galway** and tho I did not see it within two miles of that City I think it might not improbably be found on some hills stretching towards it a little South of the road. I also examined some lakes in a bog about four miles from **Galway** where the **Eriocaulon** is said to grow but the water was much raised by the rain & the wind [p. 140] was high so that I cannot suppose it was not there merely because I did not find it. In the evening I called on Mr. Brown who was to the play where I followed him. Neither the place[170](javascript:footNote('E800005-003/note170.html')) or the actors gave me any great satisfaction. The boxes were over full and Mr. Brown and his party and some others had consented on that account to occupy the first seats of the gallery as boxes. The Audience was very noisy — clamouring for the Tipperary quick march which they seemed to consider as their national tune & to expect after God Save the King just as the Londoners claim Rule Brittannia. An Englishman will know it better by the first words of a burlesque song ‘O love is the soul of a neat Irishman’. They also called for and at length obtained the bold Dragoon[171](javascript:footNote('E800005-003/note171.html')) tho not intended for the evening*'*s entertainment. Many jokes were bandied about, but with a great deal of noise there was no appearance of ill humour.


In the morning I bespoke a chaise to **Gort** & went to breakfast at [? J] Brown*'*s and then walked down to the Shore. The tide was in & I did not find much among [p. 141] the rejictamenta. The beach is stony with a mixture of sand. The stones are granite (some of them with green waxy veins) and other primitive stones mixed with fragments of the common grey Limestone of the country. Many of the former are very beautiful. Their origin is probably to be sought in **Connemara**. On my return I learnt that no chaise was to be had tho it had been promised me in the morning. I was therefore oblige*[d]* to content myself with repeated promises that it should be ready at five o'clock next morning & in the meantime amused myself with walking about the town with Mr Brown*,* the weather not inviting us to a further excursion. The streets are narrow and dirty but they contain some fine & singular old houses unlike anything I have seen elsewhere. In one of them the old richly ornamented w*[indo]*ws have been modernised with a very happy effect. The Cathedral[172](javascript:footNote('E800005-003/note172.html')) is also a fine



---

p.41



building with some peculiarities of ornament.


 [p. 142] At 5 o'clock on the morning of the 20th I found not the least preparations for my departure and at half past 7 left **Galway** in a **Gort** post Chaise which I was lucky enough to meet with. A thick mizzling rain prevented all view and I could only see that I still continued in a low limestone country. After breakfast it cleared up a little and engaging a boy and horse to carry my Luggage I set off on foot to **Kilmacduagh**. By the time I arrived there the weather was worse than ever and it was in a thick rain that I observed the following particulars.


**Kilmacduagh** is seated at a considerable distance from the **Burrin** mountains. The most conspicuous object is the round tower.[173](javascript:footNote('E800005-003/note173.html')) It is nearly perfect but the point of its conical roof has been broken away. The section of this cone appears to have been an equilateral triangle, the base exactly coinciding with the upper diameter of the tower. Immediately below this are five windows two opposite to each other & 2 in one semicircle and one in the other. Lower down are four other windows at different elevations placed as one might suppose them to be if the tower were occupied by a staircase. [p. 143] All these are pointed but not arched. The door which is very considerably elevated is rounded at [the] top but without an arch.


They reckon 7 churches in this place & perhaps including some small chapels this may have been correct but there are at present the remains of only two worth notice.[174](javascript:footNote('E800005-003/note174.html')) The first is almost close to the tower and would combine well with it in a picture. One of the windows is ornamented with the trefoil and quatrefoil but it has nothing of magnificence internally. The other building is at a little distance of about the same size but remarkable by having semi-circular arches to the windows.


 [p. 144] **Taylor***'*s Map of Ireland had induced me to believe that **Kilmacduagh** was situated immediately at the foot of the **Burrin** mountains and I had flattered myself with the hope of examining their vegetable productions at a considerable distance from my former track and especially of renewing my search for **Potentilla fruticosa**[175](javascript:footNote('E800005-003/note175.html')) but the weather and the distance united to prevent the execution of this plan. There are however one or two Turloughs or pieces of ground of that nature in the neighbourhood where I hunted without success. There are several castles on this road one of which between **Gort** and **Kilmacduagh** appears to be larger and of a different form from the usual Irish Castle.[176](javascript:footNote('E800005-003/note176.html')) I slept at **Crusheen**. At these Irish country inns I have usually found myself very comfortable. The accommodations indeed are sometimes but indifferent but the people are civil and attentive and the best of everything they have is at the traveller*'*s service.


After leaving **Crusheen** the country alters. Small gravelly hills enclose winding sheltered vallies. The shelter however is from the [p. 145] ground not from the wood, of which there is none, but the appearance of nakedness is very much taken off by many well grown hedges. The Abbey at **Quin**[177](javascript:footNote('E800005-003/note177.html')) stands without a tree & the first view of it is of a number of pointed gables (no fewer than 12 remaining perfect) round a lofty square tower. The usual fault of an Irish abbey is the number of gables. The roofs have in no one instance been hipped into one another but wherever there is a change of direction each roof is terminated by a gable. As we approach, some of the gables and part of the height of the tower are hid by the nearer walls and the parts then combine exceedingly well and offer from different points of view very pleasing compositions. The walls are very perfect & exhibit the plan of *[an]* Irish abbey to great advantage with its small and lofty tower, the large chapel opening on the South side of the nave, the vaulted rooms round the cloisters & the chambers [p. 146] above them & the cloisters. **Quin** abbey has also two detached buildings which are not usual appendages & vestiges remain of a wall with four round towers which appear to have been intended for defence.




---

p.42


 [p. 147] From **Quin** I walked to **Newmarket** — the situation of the inn is remarkably pleasant. The **Shannon** is seen at some distance between the stems of some trees and over the tops of others & beyond a range of hills whose varied forms and sweeping lines make a very agreeable boundary to the prospect. Trees*,* rock and meadow occupy the foreground. A little to the left is a small lake in the midst of a rich pasture and beyond it a ruined house half buried in ivy & sheltered by a grove of fine trees exhibiting great beauty & richness of colouring. The accommodations at the inn are very comfortable.


The next morning I got into the stage & returned to **Limerick**.


I had intended in this excursion to have visited **Bunratty castle**[178](javascript:footNote('E800005-003/note178.html')) but the weather & other circumstances prevented me. It looks at a distance like four of the common castles of the country united by walls into a large [p. 148] square. On one side the connecting wall appears to be perforated with a large & lofty arch like that at **Listowell**.


On the 25th of August *recte September* I set off from **Summervill**[179](javascript:footNote('E800005-003/note179.html')) (in company with my friend J. Beale[180](javascript:footNote('E800005-003/note180.html'))) to visit **Adair** and **Asketon**. The situation of the first mentioned place is very pleasant, the soil of the neighbourhood seems very good & it is well cultivated and well wooded. We first visited the **Black abbey**[181](javascript:footNote('E800005-003/note181.html')) which is now undergoing some alterations to fit it for a market house. In one Circumstance it differs from all the others I have seen. The tower occupies the whole width of the nave instead of standing quite within it. Thence we walked to the abbey of St. Francis[182](javascript:footNote('E800005-003/note182.html')) in **Lord Adair**'s park*,* a beautiful ruin but almost overwhelmed with ivy. The south chapel is here open by three arches into the nave and consists [p. 149] in itself of a nave and aile with chapels on the opposite side. The Cloysters are small. The whole is embosomed in trees and makes a very picturesque Object but I cannot help wishing with *Sir* R. Hoare[183](javascript:footNote('E800005-003/note183.html')) that there were less ivy, tho I am very far from agreeing with him in desiring it to be kept neat and trim — the picturesque is destroyed by this smoothness. At a little distance are the ruins of the residence of the once potent Earls of Desmond[184](javascript:footNote('E800005-003/note184.html')). [p. 150] After St. Francis' we visited the **White Abbey**[185](javascript:footNote('E800005-003/note185.html')) which is the most perfect of any in **Adair** but not equal in that respect to either **Quin** or **Askeaton**. It has however more tracery in the windows and more finish externally than either of those or indeed than any I have seen in Ireland. The same observations will apply to this as to that of St. Francis. There is no inequality of ground at **Adair** to make the situation of these abbeys dissimilar — they are all surrounded by wood & covered by ivy — added to which they are nearly of the same size.


From **Adair** we proceeded to **Kildimo** to see a school established by **Samuel Jones**.[186](javascript:footNote('E800005-003/note186.html')) [p. 152] We did not leave Kildimo till about 6 o'clock and it was dark before we reached **Askeaton**.


The next morning was very showery. I however proceeded to the abbey.[187](javascript:footNote('E800005-003/note187.html')) This has no tower so that the distant view is of Gables and nothing else. The chapel which is usually on the south side is here placed in the North and the cloysters are at the South — an arrangement which may perhaps be occasioned by the situation of the building on the rocky and broken banks of the river. When I entered, a venerable looking old man was pacing slowly round the ruined church telling his beads. He took no notice of my entrance or of my sketching the abbey but when he had finished his number of rounds knelt down at the altar & remained immovable for near a quarter of an hour. The cloisters are large and very beautiful but the elegant little pillars of black marble which form the circuit, seem a very inadequate support to the high and continued wall above. [p. 153] Besides the abbey **Askeaton** boasts the ruins of a castle.[188](javascript:footNote('E800005-003/note188.html')) There is not much beauty of detail but it is a fine fragment and well situated.


The country about **Askeaton** has not much to excite the admiration of the traveller. The banks of the river are steep and rocky but not high. The view is naked but the soil is said to be very rich as it is everywhere above the Limestone. We returned to dinner along a



---

p.43



very bad road passing near small ruins on the way. One of them called **Mungrit**,[189](javascript:footNote('E800005-003/note189.html')) near **Limerick**, has a story attached to it. One of our English kings it seems was desirous of ascertaining the state of learning in Ireland and the abbey of **Mungrit** being very celebrated was pitched upon for examination. The Abbot being rather alarmed at this intelligence, dressed up two or three of his most learned monks as peasants & sent them to meet the inspectors on the road. They met, they saluted, they talked latin and they talked greek, till the English scholars, ashamed of being excelled by peasants turned back without venturing to encounter the learning [p. 154] of the monks.


At 1/2 past 5 on the morning of the 28th Sept. I left with regret my friends in **Limerick** to return to **Waterford**. We picture to ourselves in England the Irish as a very hospitable people but we are apt to imagine that a considerable part of that hospitality consists of making their guests drunk, or at least in pressing upon them abundance of wine. I have no doubt that where an inclination of that sort exists, a person will find it very easy to gratify it in Ireland, & that even where reason struggles against inclination the latter will find a powerful advocate in the host. But for my own part I can truly say that I found it no more difficult to avoid intemperance in Ireland than in England but that I experienced a hospitality whose generous object seemed only to be to gratify every wish & to forward me in every object that I had in view. Among the lower classes too an Irishman will assist you without understanding your object, [p. 155] In England they will probably consider you either as a fool or a knave and perhaps not always refrain from corresponding actions.


The road to **Pallis** winds exceedingly, [p. 156] After crossing a range forming the extremity of the ridge of **Sliev na muck** we enter a delightful country watered by the **Sure**, rich, well cultivated, adorned with wood & bounded by fine & well varied mountains. At **Cahir** are some ruins[190](javascript:footNote('E800005-003/note190.html')) which on a passing view had a picturesque appearance. From **Cahir** the river runs almost close under the Waterford mountains & the valley is more confined tho still wide and beautiful. The Waterford mountains are high and well formed but they are heathy not Craggy mountains. I passed thro **Clonmell** and took up my residence at the hospitable mansion of **Sarah Grub**.[191](javascript:footNote('E800005-003/note191.html'))


On the 30th of September my friend **Barclay Clibburn**[192](javascript:footNote('E800005-003/note192.html')) accompanied me on an excursion [p. 157] among the Waterford mountains. At a little distance from **Anner Mills** we crossed the **Suire** by as awkward a bridge as was ever seen, the Arches diminishing from one side of the river to the other without an elevation of the ground to account for it. The road then runs for about 4 miles at the foot of a range of mountains covered with oaks, the rich valley of the **Suire** spreading on the left. When we got among the mountains I found more cultivation & better land than I expected & there are some pretty spots but in general the side from the Valley of the **Suire** to the foot of **Monavoullagh** is very uninteresting and in this instance the fog hanging on the mountain top concealed its outline which on our return I found craggy and picturesque. We ascended **Monavoullagh** on foot under the conduct of *[a]* cottager & left our horses to the care of the servant. There are two or three small lakes surrounded [p. 158] by crags but I thought this side of the mountain less interesting both to the Artist and the Naturalist than the other which I had visited on first coming to Ireland. Meanwhile, I had been rambling among mountain scenery much superior to either and had gathered all the usual plants of the country almost all of which were now out of flower so that perhaps the dish might be as good but my palate was altered. **Hieraceum villosa**,[193](javascript:footNote('E800005-003/note193.html')) **Saxifraga umbrosa** & **Saxifraga stellaris** were all the rare plants I discovered but the season was too far advanced to hope for much.


[p. 159] Among the mountains not far from the foot of **Monavoullagh** we observed a sentinel stationed at a farm house. The tenant had lately taken it over the head of the old occupier. In these cases it is not uncommon for the neighbouring peasantry to assemble



---

p.44



at night and give him warning that he must quit the place, & if he does not do this they proceed to level his fences destroy his crops and perhaps to burn his house. This man had fired at and killed one of the peasants and the **Marquis of **Waterford**** had in consequence thought it necessary to give him a guard to protect him from the revenge of his companions. [p. 160] It seems just as a general principle that when a man has a commodity to dispose of he should bring it to the best market. Yet one is apt to expect a reciprocity of good offices, a mutual protection and support between landlord and tenant which do not exist between the buyer and the seller & which is totally destroyed by the practice of disposing of the land to the best bidder.


[p. 161] I spent some days at **Anner Mills**. On the banks of the river are some of the richest meadows in Ireland shaded by fine trees among which appear the town of **Clonmell** and various detached buildings of a pale grey Limestone. Higher up are hanging woods covering the lower slopes of the mountains.


The new bridge at **Clonmell**[194](javascript:footNote('E800005-003/note194.html')) was not quite completed when I was there. The centering originally designed was found insufficient and some additional timbers had been inserted which very much incommoded the navigation of the river — the river is crossed by one eliptical arch of somewhat more than 100 feet but the curve appeared to me defective. There are two [p. 162] land arches. There are at **Clonmel** a few fragments of the town wall but nothing of much importance.


On Monday afternoon 2nd October I got into the mail to pay a second visit to **Cork**. I observed a beautiful valley & the situations of 2 Gentlemen*'*s seats struck me as particularly fine. **Col. Bagwell***'*s grounds[195](javascript:footNote('E800005-003/note195.html')) occupy a rich flat bottom ornamented with noble trees — the **Suire** winding among them and immediately bounded by a heathy mountain where the union of heath & furze produced the richest colouring imaginable. At **Lord Donoughmore**'s[196](javascript:footNote('E800005-003/note196.html')) [p. 163] a wider and more even valley afforded a scene with not so striking a character. I arrived at **Cork** about 1/2 past 3 in the morning.


My first call was at **Reuben Harvey***'*s, brother to the Gentleman to whom I had been [p. 164] so much indebted at **Limerick**[197](javascript:footNote('E800005-003/note197.html')) & I accepted his invitation to take up my residence with him.


On Wednesday the 4th October I walked to the black rock. I dined with **Mr. Hincks** the Secretary and universal professor of the Cork Institution.


The morning of the 5th was spent in an excursion to **Glanmire**. The views on this (the North) side of the river are incomparably superior to those on the other. The village of **Glanmire** [p. 165] *is* seated on a little creek winding from the river between steep banks covered with fine woods. On the 7th I again visited this beautiful spot in company with Mr. ([? J.]) Harvey and found the pleasure of a delightful ride to the place and stroll afterwards among its woody scenes not a little enhanced by his agreeable society.


[p. 166] On the eighth I went to evergreen with **Mr. Hincks** to revisit the botanic garden and afterwards to **Mr. Penrose**[198](javascript:footNote('E800005-003/note198.html')) *[who]* had been putting up some fusts[199](javascript:footNote('E800005-003/note199.html')) of Columns in a gallery intended to receive plaster casts. They are done in a very economical mode and look exceedingly well; the bases being fixed, a wooden case is made between 2 & 3 feet long not exactly cylindrical but with the proper diminution of the lower part of a column and separating longitudinaly into two parts, this is placed on one of the bases & filled up with fragments of brick, stone, quick lime in Powder and Sand & kept wet as the work goes on. In a few hours this is hard and the case may be taken away and applied upon another base. After all the lower parts are done the case is to be diminished to suit the next part & in Mr. P.'s columns the process is carried no further, but enough is done [p. 167] to shew its aplication to the whole column when this is dry. The surface is to be completed by a thin coat of stucco.




---

p.45


The floor of this room is to be made of Venetian stucco. This according to Mr P.'s receipt is a plaster laid on in two coats. Equal parts of lime which has been slaked for several years, fine sand and pounded bricks are to be well mixed together for the first coat. The second only differs in substituting tiles for bricks & sifting that and the sand very fine. It is to be left smooth with the trowel & while yet soft fragments of marble are thumbed into it. It must be washed from time to time to prevent it from cracking in the drying and when perfectly dry is to be rubbed smooth and covered with Linseed oil. If well done it is expected to have the appearance and the wear of a single slab of marble.


[p. 168] On the 9th my kind friend ([? J.]) Harvey rode over with me to **Blarney Castle**. The situation is good*,* the walls rising immediately from a perpendicular face of Limestone rock. The old castle is a mere tower and the dwelling part which is a comparatively modern addition is bad. Mr Jefferies proposes alterations which would make it one of the most splendid mansions in the country.[200](javascript:footNote('E800005-003/note200.html')) From **Blarney** I rode with Mr Jefferies to **Iniscarron** where the **Lea** runs thro a contracted valley between steep hills which rise almost immediately from its banks. Within a few years this valley was woody and must have been very beautiful. At present it is naked and has not sufficient majesty to make the deficiency pass unfelt. There are however some highly pleasing spots in the neighbourhood but I was unwell & did not receive the pleasure from them which I probably [p. 169] otherwise should have done. I Returned late in the evening to Chipley[201](javascript:footNote('E800005-003/note201.html')) & was too ill to be able the next day to take part in a projected water excursion to the **Cove**. In the evening I got a place in the mail to return to **Clonmell**.


After leaving **Glanmire** the Fermoy road seemed to offer nothing pleasing or interesting and I could hardly regret when night closed it from my view.


In the morning it was I believe sleep and not darkness which disappointed my hopes of seeing **Ardfinnan Castle** and Bridge.[202](javascript:footNote('E800005-003/note202.html')) I had got a slight view of it among the latest shades of the evening in going to **Cork** and was so much pleased that I should like to have seen more.


[p. 170] On the morning of the 12*th* I returned with pleasure to my old quarters at **Anner Mills**.


On Friday I rode over to **Oaklands** the seat of Mr. Sparrow.[203](javascript:footNote('E800005-003/note203.html')) The house occupies a very pleasant situation on a tongue of land between two little vallies backed by higher hills. To the west it has a view of the **Galtees**. The foreground is cultivated meadowland adorned with trees. A horn of the moose Deer — the skull of an animal of the Ox genus and some others of what may be called natural antiquities have been dug up in the grounds and also some fragments of horse furniture, such as is commonly in Ireland attributed to the Danes.[204](javascript:footNote('E800005-003/note204.html')) A Danish fort occupied the site where the house [p. 171] now stands.


On Sunday the 15th I left **Clonmell** and went in the stage to **Waterford**, but a soaking rain all day shut out the prospect.


After a few days stay at **Waterford** at the house of my friend **Richard Jacob***'*s[205](javascript:footNote('E800005-003/note205.html')) during which time I was almost entirely confined by a bad cold, I reembarked in the packet and landed at **Milford** — pleased indeed with the thought of returning home but with no small mixture of regret at leaving a country in many parts so interesting and a people whom with all their faults it is impossible to know and not to love.














