

#The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644
================================================================================


Author: François de La Boullaye de la Gouz
------------------------------------------


### File Description

Thomas Crofton Crokertranslated by Thomas Crofton Croker 

Electronic edition compiled by Beatrix Färber 

Funded by University College, Cork and  
The HEA via PRTLI 4 2. Second draft.Extent of text: 39640 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2010) (2014) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T100076Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

This work is an abridged translation of portions of *Les voyages et observations du sieur de la Boullaye Le Gouz ...*, published at Paris in 1653 and 1657. On the title page, three collaborators are named: Thomas Wright esq., who held a B.A. from Trinity College Cambridge, the Rev. Francis Mahony, and James Roche esq. from Cork. They contributed footnotes and appendix material marked with their initials.

#### Sources


**Literature mentioned by the editor and his contributors**2. Barnaby Rich, New description of Ireland (London 1610).
3. A true relation of divers great defeats given against the Rebels in Ireland by the Earle of Ormond (London 1642) [pamphlet].
4. A plot discovered in Ireland, and prevented without the shedding of blood (London 1644) [pamphlet].
5. Thomas Weaver, Songs and poems of love and drollery (London 1654).
6. John Lynch, Cambrensis eversus (St Malo (?) 1662).
7. R. S., The politician's catechism (London 1662) [pamphlet].
8. Richard Cox, Hibernia Anglicana; or the History of Ireland from the conquest thereof by the English to this present Time. With an introductory discourse touching the ancient state of that kingdom; and a new and exact map of the same, 2 vols. (London: H. Clark and Joseph Watts 1689–90).
9. William Rufus Chetwood, A Tour through Ireland in several entertaining letters: Wherein the present state of that kingdom is consider'd; and the most noted cities, towns, seats, rivers, buildings, &c. are described. Interspersed with observations on the manners, customs, antiquities, curiosities, and natural history of that country. To which is prefix'd, a description of the road from London to Holy-Head. By two English gentlemen. (London 1748).
10. Charles Smith, The ancient and present state of the county and city of Cork, 2 vols. (Dublin 1750).
11. Hugh Reilly, The impartial history of Ireland, or the genuine history of Ireland (London 1754).
12. John Lodge, The peerage of Ireland, 4 volumes (London 1754).
13. Thomas Burke, Hibernia Dominicana: sive historia provinciae Hiberniae Ordinis Praedicatorum [...] Coloniae Agrippinae (=Cologne) 1762.
14. Abbé Jacques (James) MacGeoghegan, Histoire d'Irlande ancienne et moderne, 3 vols. (Paris 1758–62; Amsterdam 1763).
15. John Lodge (ed.), Desiderata Curiosa Hibernica: or a select collection of State Papers (Dublin 1772).
16. Thomas Pennant, A tour in Scotland and voyage to the Hebrides (London 1772).
17. Thomas Leland, History of Ireland (Dublin 1773).
18. Charles Smith, The ancient and present state of the city of Waterford: containing a natural, civil, ecclesiastical, historical and topographical description thereof Dublin, 2nd ed., 1774).
19. George Taylor and Andrew Skinner, Maps of the roads of Ireland surveyed (London 1777; 2nd edition with one extra plate 1782).
20. Joseph Cooper Walker, Memoir on the armour and weapons of the Irish, in: Memoirs of the Irish bards (Dublin 1786).
21. Monasticon Hibernicum: An history of the abbeys, priories and other religious houses in Ireland, Interspersed with memoirs of their several founders and benefactors [...] likewise an account of the manner in which the possessions belonging to these foundations were disposed of, the present state of their ruins (Dublin 1786).
22. John Curry, An historical and critical review of the civil wars in Ireland from the reign of Queen Elizabeth, to the settlement under King William. With the state of the Irish Catholics, from that settlement to the relaxation of the popery laws, in the year 1778 (Dublin 1786; 1810).
23. Edward Ledwich & Francis Grose, Antiquities of Ireland (Dublin 1790).
24. Francis Grose, Grose's Antiquities of Ireland, 2 vols. (London 1791).
25. William Tighe, Statistical survey of the county of Kilkenny (Dublin 1802).
26. Francis Plowden, Historical View of the State of Ireland, 1803.
27. Edmund L. Swift (ed.), The life and acts of saint Patrick the archbishop, primate and apostle of Ireland, now first translated from the original Latin of Jocelin, the Cistercian monk of Furnes, who flourished in the early part of the twelfth century, with the elucidations of David Rothe, Bishop of Ossory (Dublin 1809).
28. Edward Wakefield, An Account of Ireland, statistical and political, 2 volumes (London 1812).
29. John Christian Curwen, Observations on the state of Ireland, principally directed to its agriculture and rural population; in a series of letters, written on a tour through that country. Printed for Baldwin, Cradock, and Joy. 2 vols. (London 1818).
30. [Thomas Walford], The scientific tourist through Ireland: by which the traveller is directed to the principal objects of antiquity, art, science, and the picturesque; arranged by counties, to which is added and introduction to the study of Antiquities of Ireland, &c.—By an Irish gentleman, aided by the communications of several friends (London: T. Booth 1818).
31. Thomas Moore, Memoirs of Captain Rock: the celebrated Irish chieftain, with some account of his ancestors (London 1824).
32. John O'Driscoll, The history of Ireland (London 1827).
33. Isaac D'Israeli, Commentaries on the life and reign of Charles I. 4 vols. (London 1828–30).
34. Patrick Fitzgerald and John James McGregor, The history, topography, and antiquities, of the county and city of Limerick: with a preliminary view of the history, and antiquities of Ireland, 2 volumes (Dublin 1826–27).
35. Christopher Anderson, Historical sketches of the ancient native Ireland; illustrative of their past and present state with regard to literature, education and oral instruction (Edinburgh 1828).
36. Samuel MacSkimin, The history and antiquities of the county of the town of Carrickfergus: from the earliest records to the present time, also a statistical survey of said county. (Belfast 1829).
37. G. N. Wright, Ireland illustrated, in a series of views of cities, towns, public buildings, streets, docks, churches, antiquities, abbeys, towers, castles, seats of the nobility [...]; from original drawings by G. Petrie, W.H. Bartlett, and T.M. Baynes (London: Fisher, Son, and Jackson, 1831).
38. John Ryan, The history and antiquities of the county of Carlow. (Dublin 1833).
39. Thomas Carte, (ed.), The life of James, Duke of Ormond: containing an account of the most remarkable affairs of his time, and particularly of Ireland under his government; with appendix and a collection of letters, serving to verify the most material facts in the said history. 6 vols. Oxford 1851.
40. Giraldus Cambrensis, Topographia Hibernica, 1188: J. F. Dimock (ed.) Topographia Hibernica et expugnatio Hibernica, Rolls Series 21. Vol. 5 of Giraldi Cambrensis Opera (London 1867).
**Selected further reading**2. Fynes Moryson, An itinerary, containing his ten yeeres travell through the twelve dominions of Germany, Bohmerland, Sweitzerland, Netherland, Denmarke, Poland, Italy, Turky, France, England, Scotland & Ireland. 4 vols. Printed at the University Press by Robert Maclehose & Company Ltd. for James Maclehose and Sons, Publishers to the University of Glasgow, 1907–1908. [Reprint of 1617 edition.]
3. William Lithgow, Rare adventures and painful peregrinations of long nineteen years travayles (1632). Reprint, edited with an introduction by Gilbert Phelps (London: The Folio Society 1974).
4. Caesar Litton Falkiner (ed.), Travels of Sir William Brereton in Ireland, 1635, in: Illustrations of Irish History and Topography, mainly of the seventeenth century, 363–407. (Available online at CELT.)
5. The Memoirs of Anne Fanshawe, edited by Herbert C. Fanshawe (London: Bodley Head 1907).
6. Caesar Litton Falkiner (ed.), Description of England and Ireland under the Restoration, by Albert Jouvin, de Rochefort, in: Illustrations of Irish History and Topography, mainly of the seventeenth century, 408–426. (Available online at CELT.)
7. Edmund Borlase, The history of the excrable Irish rebellion: trac'd from many preceding acts, to the grand eruption the 23d of October, 1641. And thence pursued to the act of settlement, MDCLXII (London: Printed for Robert Clavel, in St. Pauls Churchyard, 1680).
8. Thomas Dinely, Observations on a Tour through the Kingdom of Ireland in 1681 (Dublin 1858, reprinted in Kilkenny Archaeological Society's Journal, Second Series, 4 (1856–57) 143–46, 170–88; 5 (1858–59) 22–32, 55–56; 7 (1862–63) 38–52, 103–109, 320–38; 8 (1864–66) 40–48, 268–90; 425–46; 9 (1867) 73–91, 176–204).
9. Edmund Curtis and R. B. McDowell (eds), Orders made and established by the lords [...] at Kilkenny [...] 24th October 1642, in: Irish Historical Documents 1172–1922, 148–58. (Available online at CELT.)
10. Roderic O'Flaherty, A chorographical description of West or h-Iar Connaught, written A.D. 1684; ed. J. Hardiman (Dublin 1846).
11. Charles Smith, Natural and Civil History of Waterford, Dublin 1746.
12. Constantia Maxwell, The stranger in Ireland: from the reign of Elizabeth to the Great Famine (London 1954).
13. P. W. Joyce, The origin and history of Irish names of places. [Facs. of the original edition in 3 volumes published 1869–1913.] With a new introductory essay on P.W. Joyce by Mainchín Seoighe. Dublin: Éamonn de Búrca for Edmund Burke 1995.
14. Jane H. Ohlmeyer (ed.), Ireland from independence to occupation 1641–1660 (Cambridge: Cambridge University Press 1995).
15. John McVeagh (ed.), Irish Travel Writing. A Bibliography (Dublin 1996).
16. Micheál Ó Siochrú, Confederate Ireland 1642–1649: a constitutional and political analysis. (Dublin 1998).
17. C. J. Woods, Travellers' accounts as source material for Irish historians (Dublin 2009).
**The edition used in the digital edition**2. The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. François de La Boullaye de la Gouz Thomas Crofton Croker (ed), First edition [viii + 139 pages] T. and W. Boone, New Bond Street London (1837)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers the Preface and pages 1–139.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The spelling of the printed edition has been retained. Place names have been regularised using pn reg="" with the regularised form given in the reg attribute.


##### Quotation


Direct speech is tagged q. Citations are encoded cit with enclosed qt and bibl elements where possible.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the textgroup; div1=the text (journal and appendix); div2=the chapter of the journal and numbered section of the appendix respectively.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd, and tagged.


##### Interpretation


Place-names, personal names, titles (of books etc) and terms are tagged. The spelling has been left as it is, but where necessary regularisations are given, especially for place names, within the encoding. Words and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV2 element to represent the Chapter/Section. ### Profile Description


Created: English translation by Thomas Crofton Croker
 (c.1836 (translation)) #### Use of language


##### Language: [EN] The translation is in English.


##### Language: [LA] Some words and phrases are in Latin, and terms in Neolatin.


##### Language: [IT] Some words are in Italian.


##### Language: [ES] One word is in Spanish.


##### Language: [GA] Some words and phrases are in Irish.


##### Language: [FR] Some words and phrases are in French.


##### Language: [GR] Some words in Greek.


### Revision History


* (2014-06-17) Beatrix Färber (ed.)

* Header modified; including additon to bibliographic detail; new wordcount made, new SGML and HTML files created.
* (2012-03-05) Beatrix Färber (ed.)

* More content encoding added; file parsed; header modified; new SGML and HTML files created.
* (2010-07-09) Beatrix Färber (ed.)

* Encoding checked and added to; bibliographic details compiled, minor changes and additions to header made, SGML and HTML versions created.
* (2010-07-05) Beatrix Färber (ed.)

* Second proofing and application of more structural and content markup of pp. 127–139; file parsed.
* (2010-07-03) Shane McGovern (ed.)

* Proofing (1) and application of structural and content markup of pp. 127–139.
* (2010-07-01) Beatrix Färber (ed.)

* Proofing (1) and application of structural and content markup of pp. 113–126.
* (2010-06-30) Beatrix Färber (ed.)

* Proofing (1) and application of structural and content markup of pp. 78–112.
* (2010-06-28) Beatrix Färber (ed.)

* Second proofing and application of more structural and content markup of pp. 64–77.
* (2010-06-27) Shane McGovern (ed.)

* Proofing (1) and application of structural markup of pp. 64–77.
* (2010-06-23) Beatrix Färber (ed.)

* Header created; second proofing and application of more structural and content markup to pp. 1–63.
* (2010-05) Shane McGovern (ed.)

* Proofing (1) and application of structural markup of pp. 14–63.
* (2010-04-21) Beatrix Färber (ed.)

* Proofing (1) and application of structural markup started.
* (2010-03-18) Beatrix Färber (data capture)

* Text captured.




---


#### Corpus of Electronic Texts Edition: T100076


### The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644: Author: François de La Boullaye de la Gouz




---

p.12


To
  

I. D'Israeli, Esq.
  

in
  

Remembrance of much attention and
  

kindness received from him many years ago,
  

This little volume, 
  

relative to a period with which his name
  

must be identified in English History,
  

is
  

most gratefully inscribed,
  

by his faithful friend,
  

and obliged humble servant,
  

the Editor.




---

p.v


### Preface


The book from which the following account of **Ireland**, at a most interesting period of its melancholy history, has been translated, was published at **Paris** in 1657, a previous edition having appeared in 1653. The author, who was born in the early part of the seventeenth century, died in **Persia** about 1668, and his extensive travels through the various countries of Europe, and also in the East, together with his short sojourn in **Ireland**, render him above the suspicion of Irish partizanship. Although, like most Frenchmen, he seems to have felt the conviction of the superiority of his own nation, he was a citizen of the world; to him a chief of **Ormuz** and the Marquis of **Ormond** were indifferent, so were **Bagdad** and Bulgruddery—the **Iran** of the East and the **Erin** of the West. We have consequently received at his hands a faithful relation of his adventures in **Ireland**, and of his observations upon that 



---

p.vi



country at a period generally misrepresented: and they therefore merit attention from all who appreciate the value of genuine contemporary narrative. I may add that the remark of a distinguished traveller and critic to me, after reading **M. le Gouz**'s account of his tour in **Ireland**, was, that ‘the writer seems to have been a very honest fellow.’


It may be regretted that our traveller's stay in **Ireland** was so very short, scarcely exceeding two months (from May 15 to July 17, 1644,) but many larger books have been written upon visits of smaller duration, and he may have imbibed some party opinions had he remained longer. Of the sixty-three days which **M. le Gouz** passed in **Ireland**, three were employed in travelling from **Dublin** to **Kilkenny**, and two from **Limerick** to **Cork**; six days more were spent at **Cashel**, and eight at **Cork**, with his friend and companion **Tom Neville**. And of the thirty-one pages devoted by him to the account of his journey and observations upon national manners, &c. eight are consumed by his metaphysical contest with the friars at **Cashel** (which in the translation the reader will find, it is to be hoped, judiciously abridged,) while the account of **Dublin** is despatched in a single page. Nevertheless, the present publication, slender as is **M. le Gouz**'s narrative, 



---

p.vii



and affording small opportunities for any literary superstructure, (similar to that of **Mr. Croker**'s edition of **Bassompiere**'s Embassy) unquestionably deserves notice from one singular circumstance connected with the observations upon it; namely, that any work respecting **Ireland** should be free from party spirit and religious rancour, especially one relative to a period which involves such remarks.


Of my three able and amiable associates in commenting on **M. le Gouz**'s tour, two are Roman Catholics, and the notes and illustrations supplied by the gentlemen whose names appear on the title page, bear their respective initials. The notes marked T, are such comments from the original as were considered worth preserving.—It is therefore with sincere pleasure that I feel myself called upon to submit to the English reader a work which must be esteemed a literary as well as a political curiosity; and I trust is the harbinger of more auspicious times.


Could the spirit of **M. le Gouz**, which appears to have been a benevolent one, behold the present little volume, it might be pleased at the knowledge that his impartial statement has been the means of combining in perfect harmony, observations upon the distracted country which he beheld, from men professing different creeds, and it might apply to itself 



---

p.viii



the words of a poet of that land in which his bones repose:—
  


> 1. With pride I feel that I alone
>   
> Have joined these varied gems in one,
>   
> For they're a wreath of pearl, and I
>   
> The silken cord on which they lie.
> 




The narrative opens, not inappropriately, by the vagaries of a drunken Irish captain. **Horace** recommends an author to enter at once ‘in medias res’ a hint which our Gascon traveller seems to have adopted in describing men and matters in **Ireland**.


T. C. C.
25th January, 1837.
Journal of a Tour in Ireland. A.D. 1644
---------------------------------------




---

p.1


#### 1


The sixth of May *(1644)*, we sailed[1](javascript:footNote('T100076/note001.html')) at ten o'clock at night. Our captain was drunk, and knew not what he did; we had lost our passage two or three times by his fault, for in the mornings the wind being contrary, he used to go to the public-house, and when the wind would chop round, he was then incapable of giving orders to the pilots. This drunkard set sail on a sudden and left many respectable passengers ashore, without giving them any notice, who having lost all hope of his weighing anchor so late, were asleep at their inns.


The next morning we met two French vessels from **Kinseelle** (Kinsale) [2](javascript:footNote('T100076/note002.html')) in **Ireland** bound to **Bristol**. About noon we were chased by a vessel of the Parliament



---

p.2



of forty guns,[3](javascript:footNote('T100076/note003.html')) and experienced much apprehension, for it was rumoured that the Parliamentarians threw into the sea all the Irish and those of their party, owing to the massacre the Irish had made in their country of the English Protestants, by a zeal for religion, and of which the list registered is, according to the calculation of the Protestants, 145,000 persons.[4](javascript:footNote('T100076/note004.html'))


We escaped from them under cover of the night.


On the 14th of the month, a sailor being aloft, cried, ‘chore, chore,’ (shore, shore)[5](javascript:footNote('T100076/note005.html')) we discovered the Coast of **Wachefort**, in the 53rd degree of latitude,[6](javascript:footNote('T100076/note006.html')) and bearing away north, we saw to the west a small castle called **Wiclos** (**Wicklow**),[7](javascript:footNote('T100076/note007.html')) in the latitude 55 degrees 40 minutes.[8](javascript:footNote('T100076/note008.html')) The captain of 



---

p.3



the vessel, instead of consulting the compass to avoid the head of a sand bank, the most dangerous on this coast of **Ireland**, kept in conversation with the pilot uselessly, and after half an hour's sail perceived his error, and began to cry, ‘Lord God have pity on us, we are lost!—have the anchors ready;—furl the sails; we are on the head of the bank.—We are only six feet from it.—The skiff! the skiff!—To the long boat.—The oars!—O God be merciful to us;—by the grace of Jesus Christ, our Lord!—’


We all put our hands to work; and the sailors having taken a rope from the bow of the vessel, fastened it to the skiff and the long boat, and drew us from this danger with much labour and by force of oars.


In the evening, certain vapours rising from the sea, made me believe that it was the land which I saw at the distance of one, two, or three miles. I imagined that I could distinguish trees in great numbers, and even cattle. Looking at this land and wishing to learn its name and what towns it contained, I addressed myself to a Dutch pilot, married in **Doublin**, who undeceived me, and made the following remarks to me. ‘You are not the first who has erred in the supposition of these things; the most expert navigators are often deceived by them. That which to us appears land is only a dense vapour which cannot be raised higher in consequence of the season and the absence of the sun. Those apparent trees and animals are a part of that miasma which 



---

p.4



collects in some places more than in others. When very young, I was on board a Dutch vessel off the coast of **Greenland**, in 61 degrees of latitude, when we perceived an island of this sort. We sounded without touching the bottom. Finding sufficient water, our captain wished to approach nearer; but we were astonished that all at once it disappeared. Having a different direction we met the same appearance again. The captain desiring to know what it was, ordered them to turn half a mile backwards and forwards to observe it, and after having traversed many times without finding any real land, there arose so furious a tempest, that we expected to perish. And a calm afterwards coming on, we asked the captain why he had surveyed this island. He told us that he had heard say, that near the Pole, there are many islands, some floating, some not, that are seen from a distance, and are hard to be approached, which they say is owing to the witches who inhabit them, and destroy by storms the vessels of those who obstinately seek to land upon them;[9](javascript:footNote('T100076/note009.html')) that all he had heard reported and read were but fables, and that he now knew that these floating islands proceeded from the vapours raised, and afterwards attracted by the planets, which vapours the wind dispersed on approaching nearer, and that tempests usually followed these phenomena.’[10](javascript:footNote('T100076/note010.html'))




---

p.5


#### 1


I thanked him for having explained to me this imaginary land, and as I finished speaking, I saw pass a flock of black birds of the size of a thrush, of which one went at the head and another at the tail. These birds formed a kind of battalion, and went against the wind. This same Dutchman told me that when these birds passed during a calm they augured future wind.[11](javascript:footNote('T100076/note011.html'))


The 15th of the month we perceived the coast of **Doublin**, embellished with small castles. We anchored near the city, leaving two large casks on the left hand, which served as marks to avoid the rocks and banks which may be in this place.


The city of **Deulin**, or **Doublin**, is the capital of **Ireland**. It is on the east of the Island; its size equal to that of **Angers**.[12](javascript:footNote('T100076/note012.html')) The quay of the harbour is very fine, but receives only small craft; large vessels remain in the roads, two miles from the city. There is no curiosity except a well which is two or three miles from the city, on the northern coast, which works miracles for the lame and the blind. So say the natives.[13](javascript:footNote('T100076/note013.html')) There are fine buildings in **Doublin**; a college and many churches, amongst which is that of **St. Patrick**, the apostle of the country.




---

p.6


#### 1


In the choir are displayed the arms of the old English knights, with their devices. I went there on Sunday to witness the ceremonial attending on the Viceroy. I saw much that was really magnificent. On leaving the church there marched before him a company of footmen, beating the drum, and with match-locks ready for action. Then followed a company of halberdiers, his body-guards, and sixty gentlemen on foot, with four noblemen well mounted, and the Viceroy in the midst upon a white Barbary horse. I followed the train in order to enter more freely into the castle; but at the door they ordered me to lay down my sword, which I would not do, saying, that being born of a condition to carry it before the king, I would rather not see the castle than part with my arms.[14](javascript:footNote('T100076/note014.html')) A gentleman in the suite of the Viceroy seeing from my gallant bearing that I was a Frenchman, took me by the hand, saying, ‘Strangers shall on this occasion be more favoured than residents.’ And he brought me in. I replied to him that his civility equalled that of the French towards his nation, when they met them in **France**. Being within, I found this castle indifferently strong, without any outworks, and pretty well furnished with guns of cast metal.




---

p.7


#### 2


I left **Doublin** in company with **Tam Neuel** *(Tom Neville)*, an Irishman, and native of **Korq**, and took a passport from the Viceroy of **Ireland**, who was then the **Earl of **Ormond****.[15](javascript:footNote('T100076/note015.html'))


At six miles towards **Limmerik** we found a village called **Fortinguesse** *(Fox and geese)* destroyed by the war. There remained but one house, where was an English garrison. In the evening we arrived at **Racoul** *(Rathcool)*,[16](javascript:footNote('T100076/note016.html')) eighteen 



---

p.8



miles from **Doublin**, where I saw the house of the late **Lord Strafford, Viceroy of **Ireland****, beheaded in London.[17](javascript:footNote('T100076/note017.html')) This castle belongs to his brother,[18](javascript:footNote('T100076/note018.html')) who resides in **Doublin**, and guards it by forty English soldiers. **Racoul** is a large village nearly ruined by the wars.


The second day we dined at **Kilcolin Bridge** *(Kilcullen Bridge)*, where ends the English ground.[19](javascript:footNote('T100076/note019.html')) We swam over a little river[20](javascript:footNote('T100076/note020.html')) with much trouble, carrying our clothes upon our heads; the Irish having broken the bridge [21](javascript:footNote('T100076/note021.html')) during the religious wars. All this country was laid waste,[22](javascript:footNote('T100076/note022.html')) and we found none but 



---

p.9



poor unfortunates on the roads, who sold buttermilk and a little oaten bread. After having passed this river, we came to sleep at **Castle Dairmon** *(Castle Dermot)* a little village under the dominion of the Catholics. It is twelve miles from **Racoul**.[23](javascript:footNote('T100076/note023.html'))


The third day we went to Kinkakoul ( )[24](javascript:footNote('T100076/note024.html')) then to **Balinhoulan** (Ballylaughan), where there is[25](javascript:footNote('T100076/note025.html')) a fine castle, of which the governor was of the English nation, and lately converted to the Catholic 



---

p.10



religion. This village is distant thirteen miles from **Castle d'Airmon**.


The fourth day we arrived at **Kilkinik** *(Kilkenny)*, the Catholic capital, the seat of the Confederation of **Ireland**. This city is the size of **Orleans**,[26](javascript:footNote('T100076/note026.html')) seated on a small river which empties itself into the sea at eighteen miles distance.[27](javascript:footNote('T100076/note027.html')) Its castle [28](javascript:footNote('T100076/note028.html')) is placed on 



---

p.11



 
the river. There are monasteries of Jacobins,[29](javascript:footNote('T100076/note029.html')) of 
Recolets,[30](javascript:footNote('T100076/note030.html')) and a college of Jesuits,[31](javascript:footNote('T100076/note031.html')) who are in great honour among the people.


At the gates of the city they seized upon me and led me to the mayor,[32](javascript:footNote('T100076/note032.html')) who judging by my physiognomy that I was English, told me that I was a spy—that my figure, my speech, and carriage were those of a native of **England**. I maintained that he was 



---

p.12



mistaken, and as politely as I could contradicted him, telling him that I was of the French nation, and a good Catholic; that the passports I had from the King of **England** were proof of what I advanced, that he might read them and inform himself of my profession. He took them rudely enough from my hands, and reading only the superscription in English, ‘Mestre le Gouz his passe’ which signifies the pass of Mounsieur le Gouz, he was confirmed in his error, and said to the company, ‘See, if this name be not English, and if I have not judged rightly that this fellow is a spy. Let the soldiers come and take him to prison; we do not so easily suffer these sort of ramblers; we will soon discover the truth.’ The impertinence of this Lord [33](javascript:footNote('T100076/note033.html')) shocked me: I replied to him, ‘You say I am English without any foundation, but your imagination. Is there no Frenchman here who can judge if the French language is not natural to me, and English strange? As for my name, it is English;[34](javascript:footNote('T100076/note034.html')) and it may be that my ancestors formerly came from **England** to live in **Brittany**, after the invasion of the Saxons, as those of many other French families did.’



---

p.13



He sent in search of an inhabitant, a native of **Caen**, in **Normandy**, who assured him that I was French. I had leave to withdraw; and owing to the Catholic Council which was held in this town the hotels were so full, [35](javascript:footNote('T100076/note035.html')) that if I had not met with a Norman, called Beauregard, I should have been forced to lie in the streets.




---

p.14


#### 3


We left **Kilkinik** (Kilkenny) and arrived at **Kalon** (Callan), six miles on the road. On our arrival, a gentleman, named Edward Comerfort,[36](javascript:footNote('T100076/note036.html')) offered us his castle, where we rested, not being able to refuse so civil a request. The next day we were drenched by extraordinary rain, which obliged us to seek shelter in a castle,[37](javascript:footNote('T100076/note037.html'))where we were well received. The master of the house came to beg us to remain some days there; we could not excuse ourselves. This nobleman was called **Lord Ikerin**,[38](javascript:footNote('T100076/note038.html')) and was general of the cavalry of the Irish Catholics. At



---

p.15



supper a friar from **Spain** brought the conversation from Spanish diet to the religion of that country, and bearing a mortal dislike to the French, my countrymen, he could not refrain from giving vent to his antipathy in my presence, stating, that as we had no Inquisition in **France**, we were but a set of reprobates, and partial to heretics, whom instead of tolerating as we do, we ought rather to exterminate, as the progress of the Catholic faith could not co-exist with this pestilent sect (the Calvinists), whose very name ought to be abhorred by the people. That **Spain** had the advantage of never having been infected with heresy, and hence their monarch was called the Catholic King, and hence also the great preponderance of that power in war.


I felt it my duty thus to reply to this monk, whose zeal appeared to me to be most indiscreet. ‘My reverend father, I am surprised that you, born in **Ireland**, a neutral country, should be so much under the influence of prejudice and womanish imbecility as to prefer **Spain** so unjustly to **France**, a land where religion and valour are equally found, if not in a higher degree. And whatever charms the Inquisition may have for you, and however useful you may think it as a means of purging a country of impiety and preserving religion in its integrity, the French nation is too well informed that faith, which is the basis and foundation of Christianity, cannot be established by persecution. And as to **Spain**, although it may be true as you assert that Huguenots 



---

p.16



never could thrive there, still the Moors and Infidels of Grenada are so mixed up with the population that you can hardly discriminate between them and real Catholics. Appearances often mislead us. The French, to outward semblance, seem free and careless but are in reality excellent Christians, while your Spaniard, with the look of a devotee and an angel, is very often the reverse at heart. As to the prosperous career of His Catholic Majesty's arms, he never will encounter the Most Christian King in fair fight without discomfiture.’


From this castle we came in one day to **Cachel**, a distance of ten miles. This town is an archbishop's see, founded by **St. Patrick**. There are 
two convents, [one of] Dominicans, and [one of] Franciscans.




---

p.17


#### 4


During my stay at **Kachel** the Rev. Father Ryan, prior of the Dominicans, an Irish friar educated in **France**, invited me to dine at his Convent; and as I felt reluctant to accept the good man's offer, he begged earnestly that I would grant him that favour, as he wanted me to render him a service at the monastery. He had in his establishment two members of the order who had gone through their course of studies in **Spain**, and who presumptuously maintained, that the French knew nothing, while **Spain** was the cradle of true theology and sterling philosophy. Now he was glad to have met me to take part with him in vindicating the College studies of **France**, for he candidly confessed, he took pride in the country where he had been educated, and would be glad to humiliate the Salamanca students.[39](javascript:footNote('T100076/note039.html')) I at once consented for the honour of my native land.




---

p.18


#### 4


While at table these two Spanish Dominicans, full of the cant and prejudice of that country, had nothing in their vocabulary of more familiar use than the terms ‘Lutheran,’ ‘Huguenots,’[40](javascript:footNote('T100076/note040.html')) and ‘French 
Blockheads.’ They would hardly let me swallow in quiet my Soupe a l'Iroise[41](javascript:footNote('T100076/note041.html')) Irish mess of potage, but kept up a sort of rambling fire to annoy me: I begged they would let me dine in comfort, and when the repast had terminated, I took the liberty of putting a few questions in my turn, among others the following drawn from the Science of Theology, ( Tract. de Trinitate.)

1. God in his capacity of *Father* hath begotten the 
Son.
  
 God in his capacity of God has begotten nought. Now as it is *by the knowledge* he hath of himself as the *Father* [quâtenus Pater], that he has produced *the Son*, how comes it that *by the same knowledge* which he has of himself *as God [quâtenus Deus]* he has produced nothing?
2. The nature of the Godhead being *infinite*, how can it have become united with the *finite* nature of man in the Christ?


---

p.19

5. The attributes of God being each *boundless and infinite*, how can there be more than one attribute of *that description*?
6. As the *knowledge* and the *will* are the same thing in God, why is the production of the second Person of the Trinity, *the Son*, ascribed more to the one than to the other?
7. Why is not the *Holy Ghost* the *second*and not the *third person*, since the action of the Spirit precedes the engendering of *the Son*?



To these questions I begged them to give a scientific and categorical answer. One of them attempted to reply, but soon got entangled in the meshes I had prepared for him; whereupon I observed that perhaps Theology was not the science in which he particularly excelled, as many and various are the gifts, and one hath prophecy, another the gift of tongues, &c. but perhaps the department of Philosophy was 
more familiar to him, and as there are four distinct parts, viz. *Logic, Metaphysics, Ethics,* and *Physics,* he would perhaps allow me to put a few quaeries drawn from the first part, *Logic.*
1. Why is the convertibility of propositions in the second process[42](javascript:footNote('T100076/note042.html')) of syllogistic argumentation the touch-stone of truth?


---

p.20

4. Why, in the nineteen forms of syllogism, seven give an *affirmative* conclusion, and twelve a *negative*?
5. What is the difference between possibility and contingency in the mode of propositions?



Here I found them as dumb-foundered as before; on which I remarked that Spanish logic was a capital contrivance, since by saying nothing they were sure not to lay themselves open to their adversary.


Passing to the second part, viz. Metaphysics, I asked them how they could prove the spirituality of the soul, the existence of angelic beings, and whether such were created before the world or after? If God has created the world from his knowledge, *his knowledge being part of his essence* is not the world part of *the essence of the Godhead*?


Is not *chaos* eternal as well as God?


Here the same system of obstinate taciturnity was persevered in by my Spanish opponents; so I proceeded, passing by the science of *Ethics,* where, on account of its facility, I supposed they might know something, to that of Physics.


I asked them to how many *principles* do you ascribe the composition of all natural things, and what are the single elements or component parts of the Universe. I do not mean to argue with you in the scholastic style so usual in **Spain**, where authorities and quotations are given for proofs, a system which is of no avail among men who reject your authorities and don't value your quotations; one good fair syllogism is worth a cart load of your Spanish rubbish, 



---

p.21



 
and to that system you must come if you wish to reason with rational people. I recollect arguing with one of your countrymen at the neighbouring town of Kalon on the question in physics, whether a body can be in two places at once, and this Doctor, who had imbibed the method of **Spain**, alleged as an example the real presence and the doctrine of transubstantiation, without observing that he brought forward a most inapposite case, since in these sacramental elements all physical laws are superseded, it being confessedly a miraculous and supernatural presence, not one according to the usual notions of things.


As for your collegiate course, you think you are adepts in physics, when you have employed seven or eight months in transcribing the lectures of your professors, who have themselves transcribed from those who went before them, and you are as far as ever from a knowledge of the essence of bodies, the nature of the animal or vegetable kingdom, of minerals, the causes of the tide's ebb and flow,—of winds,—plants, and trees, about which you are just as wise as Solomon, who knew merely enough to dispute about them. Astronomy, which is so important a branch of science, you are in the habit of discarding and denouncing; you even think it a *profane* and dangerous study, fit for the researches of visionary scatterbrains, and leading strait to witchcraft, whereas it is a principal source of information and utility, and leads us to the knowledge of the Creator, from the contemplation of his works, as St. Paul says in his Epistle to the Romans, 



---

p.22



 
(Rom. i. 20.) and as I am upon the subject, I will give you a few notions and volunteer a lecture for your instruction, for which you may thank this venerable prior Father Ryan, who knows all these matters as well as I do, having studied in **France**, and who is not the worse for not having graduated in **Spain**.


And first, Moses established in Genesis three elements—*Darkness*, the *water*, and the *Spirit of God*—which latter the Levant folk call Alla Rohh, the name which Mahomet gives Christ in the Alcoran.


**Thales of Miletus** maintained that there existed nothing in the commencement but *water* alone.


**Anaximander**, instead of one, holds an infinity of primeval elements: while **Hermes**, tris megistus pontiff, king and philosopher of Egypt, says that 
all originally consisted of *salt, sulphur,* and *mercury,* 
a hint which has been greedily caught up by the sad tribe of dabblers in alchemy, and seekers for the 
philosopher's stone.


**Aristotle** refers all to two things—*form*, giving 
action; and *matter*, suffering the action aforesaid: and this is the veil by which the Stagyrite concealed from the crowd what he communicated to a chosen few.


**Euclid** gives you the *point*, the *line*, and the *figure*.


The Rabbis give—1st, *God*form; 2nd, *matter*; and 
3rd, *spirit*.


**Plato** gives—1st, *God*; 2nd, *his ideas*; and 3rd, *matter*. **Anaximenes** the *air*; **Empedocles** the alliance 



---

p.23



 
and the discord of the four elements, *air, earth, water, fire.* **Zenocrates**, 1st, *God*; 2nd, *matter*; 3rd, *the elements*. **Ramus** has it thus—lst, *power*; 2nd, *an object*; 3rd, *an act*. **Democritus** gives the *plenum* and the *vacuum*. **Parmenides** *hot* and *cold*. **Heraclitus**, *fire*; and **Pythagoras**, *number*. Whereas **Robert Flood**, doctor of Oxford, gives you—1st, *the will of God*; 2nd, *light and darkness*; 3rd, *singraths and anagraths*; 4th, *condensation and rarefaction*.


I spare you the rest, lest I should become tedious (!) but I have said enough to show you that, whoever wishes to pass for learned, must be versed in all these matters, and be able to reconcile all these jarring systems of philosophy.


So here, my Reverend Fathers, I leave you with a final observation—that life is short, and that the 
more we study, the more we are surprised at the extent of our own ignorance![43](javascript:footNote('T100076/note043.html'))




---

p.24


#### 5


We left **Cachel** and breakfasted at Solohoye [44](javascript:footNote('T100076/note044.html'))eight miles on our way, having remained six days at **Cachel**, owing to the Rev. Father Ryan, who took us, with the two Spanish Doctors to visit at many of his friends' houses about the town.


From Solohoye, we arrived at **Limmerick**, the strongest fortress in **Ireland**.[45](javascript:footNote('T100076/note045.html')) It has a castle, and a harbour, where large vessels can anchor; the quay is very fine. The river is called Jones.[46](javascript:footNote('T100076/note046.html')) There is a house of Jesuits, and convents of Dominicans[47](javascript:footNote('T100076/note047.html'))


---

p.25



and Soccolantes.[48](javascript:footNote('T100076/note048.html')) In this city there are great numbers of profligate women; which I could not have believed, on account of the climate.[49](javascript:footNote('T100076/note049.html'))




---

p.26


#### 5


**Tam Neuel** ***Tom Neville*** with whom I had joined in company at **Doublin** to perform this journey, was caught by the artifice of these damsels, who robbed him one night of his money. In the morning he came to throw himself at my feet, saying, ‘O my good French gentleman, until now I have not made myself known to you; I implore you to credit what I assert, and not to abandon me. Know then that I am a native of **Korq** that by travelling in **France**, **Spain**, and **England**, for the last ten or twelve years I had been enabled to accumulate sufficient from my industry in trade, to make an honourable[50](javascript:footNote('T100076/note050.html')) retreat from business; when unfortunately I embarked again in the same pursuits, and having taken ship for **England**, fell into the hands of the Parliamentarians, who took from me all I had. With difficulty was I able to save some rings, by the sale of which I have got as far as this City, and as misfortune never comes alone, I have again been robbed last night of the little remaining to me; so that I have no hope except in your kindness, and though I am distant but three days journey[51](javascript:footNote('T100076/note051.html')) from 



---

p.27



my native place, I find myself in a state of destitution. For the remainder, fear not to trust me, as my father is one of the richest merchants in **Korq**; his dwelling resembles rather a palace than a private house. If you pass that way, you would see how he would receive you; he, and all my relations. You must have seen by my conduct since I have had the honour of being in your company that I am no sharper.’


I told him that he should want nothing to enable him to return to his native place. ‘While I have any money you shall share it with me; we must look on the misfortunes we are visited by from above, as sent for our correction. You ought to have made this reflection, and your first misfortune would have shielded you from your subsequent calamity.’


We left **Limmerik**, and came to breakfast at Chamdelesse [ ] eight miles off. Half a league from this castle is the birth place of Mr. Dulée *(Daly?)*.[52](javascript:footNote('T100076/note052.html')) Doctor of Sorbonne, and Professor in the University of Paris. Many worthy persons made enquiry after him. Then we dined at **Malagué** ***Kilmallock***[53](javascript:footNote('T100076/note053.html')) and slept in a castle; distant sixteen miles from **Limmerik**.




---

p.28


#### 5


The next day we slept at **Castlemagner**,[54](javascript:footNote('T100076/note054.html')) thirteen miles, a small town, whence we went to dine at 
**Mala** ***Mallow***, a considerable fortress,[55](javascript:footNote('T100076/note055.html')) and having performed thirteen miles slept at **Korq** that evening.


Having arrived here, **Tam Neuel** ***Tom Neville*** of whom I have before spoken, led me to his father's house. He knocked at the door, when a well looking man appeared, and demanded what we wanted. **Tam Neuel** desired to know whether **John Neuel** was at home. The man replied, that he knew no such person. **Neuel** insisting that the house belonged to the person for whom he had asked, was told, that it belonged to an English captain, who had it on the seclusion of the Catholics from the town.[56](javascript:footNote('T100076/note056.html')) He was surprised to find events so deplorable had occurred to his family. I sympathised with him, and observed ‘since things were thus, we must seek a lodging, as the night was coming on.’ ‘O Mister Frenchman,’ he said, ‘you cannot 



---

p.29



without injustice refuse to repair to the house, if not of my father, at least of some other relation. I have uncles in the town, where we shall be welcome.’ We found out one of them, and by him were received with all imaginable kindness, and **Neuel** learned that his father had lost in the religious wars more than £10,000 sterling,[57](javascript:footNote('T100076/note057.html')) and had been obliged to fly to the country, to avoid the tyranny of the English Protestants.


I remained eight days in this house in the midst of continual festivity; and on taking leave to pursue my travels, they thanked me for the assistance I had rendered to **Tam Neuel**, and in spite of all I could do, repaid me the money I had furnished for his expenses from **Limerick**.[58](javascript:footNote('T100076/note058.html'))


A mile from **Korq** is a well called by the English Sunday spring, or the fountain of Sunday, which the Irish believe is blessed and cures many ills. I found the water of it extremely cold.[59](javascript:footNote('T100076/note059.html')) Opposite this well to the south of the sea, are the ruins of a monastery founded by Saint Guillabé; there is a cave which extends far under the ground, where they say, that Saint Patrick resorted often for



---

p.30



prayer.[60](javascript:footNote('T100076/note060.html')) In one of the suburbs of **Korq** there is an old tower ten or twelve feet in circumference, and more than one hundred feet high,[61](javascript:footNote('T100076/note061.html')) which they conscientiously believe to have been built by Saint Baril ***Finbarr*** without lime or stone,[62](javascript:footNote('T100076/note062.html')) to prove by this miracle his religion; then it was lopped or half destroyed by the same saint, who jumped from the top to the bottom of it, and imprinted the mark of his foot on a flint stone, where the old women go with great devotion to say their prayers.




---

p.31


#### 6


From *Cork* or Korki [63](javascript:footNote('T100076/note063.html')) I came to **Kingseele**, ten miles distant, a small mercantile town, and ill built. It has an English garrison. From **Kingseele** I came to **Johol**,[64](javascript:footNote('T100076/note064.html')) 
thirty miles, having dined at **Karabé** *Carrigaline*.[65](javascript:footNote('T100076/note065.html'))


At the gate of **Johal**, I was surrounded by twenty English soldiers, who led me forcibly to the captain of the town;[66](javascript:footNote('T100076/note066.html')) he demanded of me who I was, and 



---

p.32



after having shewn him my passports from the King of **England** and from the Viceroy of **Ireland**, I told him that I had travelled from **Bristol** to **Doublin** with Mr. Galoe *Galway*, a merchant of **Johal**. He sent for the person I mentioned, and tired of questioning me, allowed me to depart quietly, being assured that I was not a liar.


**Johal** is well walled, and under the government of the English.[67](javascript:footNote('T100076/note067.html')) Its size is equal to that of St. Denys in **France**. It is a seaport. There are to be seen the remains of two ancient convents, one of Dominicans,[68](javascript:footNote('T100076/note068.html')) and the other of the order of St. 



---

p.33



Francis. [69](javascript:footNote('T100076/note069.html')) At musket-shot from the town there was formerly a convent of nuns on the sea-shore, and there remains of it a tower called the Nunnery, upon which the nuns used to light torches to enable vessels to come into harbour during the night.[70](javascript:footNote('T100076/note070.html'))


In the Dominican convent there was an image of 



---

p.34



the Virgin, formerly held in the greatest reverence in **Ireland**, [71](javascript:footNote('T100076/note071.html')) which arrived there in a miraculous manner. The tide brought a piece of wood on to the sands opposite the town,[72](javascript:footNote('T100076/note072.html')) which several fishermen tried to carry off, the wood being rare in this country, but they could not move it; they harnessed ten horses to it without effect, and the reflux of the tide brought it near the Dominican convent. Two monks raised it on their shoulders and put it in the court-yard of the convent; and the prior had in the night a vision that the image of our Lady was in this piece of wood; which was found there. So say the Catholics, who have still a great devotion towards it; but the Dominicans having been persecuted by the English settlers carried it elsewhere.[73](javascript:footNote('T100076/note073.html'))


From **Johol** I came by sea to **Dongarvan**[74](javascript:footNote('T100076/note074.html'))


---

p.35



a small town, where there is a fine castle of which the Irish were masters. The harbour is very bad, and this year Captain Antonia, a Spaniard, an excellent seaman, lost there a handsome frigate, with which he was chasing the small Parliamentary vessels. I slept at **Casteltames** eight miles from **Dongarvan**, and eighteen from **Johal**.


The next day I came to **Waterfort**, in French the fort of water, a fine town, extremely populous, of the size of Tours. It has a small river which brings shipping within five miles, to a place called Passage, where I crossed the river, and pursued my way to **Wachefort**, in French the washed fort, where I arrived in one day.


This town is very populous, owing to its great commerce. The fortress is a small square, regularly enough fortified and *washed* by the sea. At the foot of this castle are many ruins of old churches, amongst others that of the Holy Trinity, towards which the women have great reverence, and come there in solemn procession. The oldest march first and the others follow, then take three turns round the ruins, make a reverence to the remains, kneel and recommence this ceremony many times. I have noticed them at this devotion three and four hours.


The people of **Wachefort** came principally from **France**,[75](javascript:footNote('T100076/note075.html')) when **Guillaume le Conquereur**, (whom 



---

p.36



 
the English call **William the Conqueror**,) a natural son of the Duke of Normandy, conquered **England**, made himself king of it, and gave the Norman code of laws to the inhabitants.




---

p.37


#### 7


**Ireland** or **Hibernia** has always been called the Island of Saints, owing to the number of great men who have been born there. The natives are known to the English under the name of Iriche, to the French under that of Hibernois, which they take from the Latin, or of Irois, from the English, or Irlandois from the name of the island, because land signifies ground. They call themselves Ayrenake, in their own language, a tongue which you must learn by practice, because they do not write it,[76](javascript:footNote('T100076/note076.html')) they learn Latin in English characters, with which character they also write their own language; and so I have seen a monk write, but in such a way as no one but himself could read it.


**Saint Patrick** was the apostle of this island, who according to the natives blessed the land, and gave his malediction to all venomous things; and it cannot be denied, that the earth and the timber [77](javascript:footNote('T100076/note077.html')) of **Ireland**, being transported, will contain neither serpents, 



---

p.38



worms, spiders, nor rats, as one sees in the west of **England** and in **Scotland**, where all particular persons have their trunks and the boards of their floors of Irish wood; and in all **Ireland** there is not to be found a serpent nor toad.[78](javascript:footNote('T100076/note078.html'))


The Irish of the southern and eastern coasts, follow the customs of the English; those of the north, the Scotch. The others are not very polished, and are called by the English, savages.[79](javascript:footNote('T100076/note079.html')) The English colonists were of the English Church, and the Scotch were Calvinists, but at present they are all Puritans. The native Irish are very good Catholics, 



---

p.39



though knowing little of their religion; those of the Hebrides and of the North acknowledge only Jesus and Saint Colombe *Columkill* but their faith is great in the Church of Rome.[80](javascript:footNote('T100076/note080.html')) Before the English 
revolution, when an Irish gentleman died, his Britannic Majesty became seized of the property and tutellage of the children of the deceased, whom they usually brought up in the English Protestant religion. **Lord Insequin**[81](javascript:footNote('T100076/note081.html')) was educated in this manner, to whom the Irish have given the name of plague or pest of his country.


The Irish gentlemen eat a great deal of meat and butter and but little bread. They drink milk, and beer into which they put laurel leaves,[82](javascript:footNote('T100076/note082.html')) and eat bread baked in the English manner. The poor grind 
barley and peas between two stones[83](javascript:footNote('T100076/note083.html')) and make it into bread, which they cook upon a small iron table 



---

p.40



heated on a tripod; they put into it some oats, and this bread which in the form of cakes they call Haraan,[84](javascript:footNote('T100076/note084.html')) they eat with great draughts of buttermilk. Their beer is very good, and the eau de vie, which they call Brandovin *Brandy* excellent. The butter, the beef, and the mutton, are better than in **England**.


The towns are built in the English fashion, but the houses in the country are in this manner. Two stakes are fixed in the ground, across which is a transverse pole to support two rows of rafters on the two sides, which are covered with leaves and straw. The cabins are of another fashion. There are four walls the height of a man, supporting rafters over which they thatch with straw and leaves. They are without chimneys and make the fire in the middle of the hut, which greatly incommodes those who are not fond of smoke.[85](javascript:footNote('T100076/note085.html')) The castles or houses of the nobility



---

p.41



consist of four walls extremely high, thatched with straw; but to tell the truth they are nothing but square towers without windows, or at least having such small apertures as to give no more light than there is in a prison.[86](javascript:footNote('T100076/note086.html')) They have little furniture, and cover their rooms with rushes, of which they make their beds in summer, and of straw in winter. They put the rushes a foot deep on their floors, and on their windows, and many of them ornament the ceilings with branches.


They are fond of the harp, on which nearly all play,[87](javascript:footNote('T100076/note087.html')) as the English do on the fiddle, the French on the lute, the Italians on the guitar, the Spaniards on the castanets, the Scotch on the bagpipe, the Swiss on the fife, the Germans on the trumpet, the Dutch on the tambourine, and the Turks on the flageolet.[88](javascript:footNote('T100076/note088.html'))




---

p.42


#### 7


The Irish carry a scquine *skein* or Turkish dagger,[89](javascript:footNote('T100076/note089.html')) which they dart very adroitly at fifteen paces 



---

p.43



distance; and have this advantage, that if they remain masters of the field of battle there remains no enemy, and if they are routed, they fly in such a manner that it is impossible to catch them. I have seen an Irishman with ease accomplish twenty-five leagues a day. They march to battle with the bagpipes instead of fifes, but they have few drums, and they use the musket and cannon as we do. They are better soldiers abroad than at home.


The red haired are considered the most handsome in **Ireland**. The women have hanging breasts, and those which are freckled like a trout are esteemed the most beautiful.


The trade of **Ireland** consists in salmon and herrings, which they take in great numbers. You have one hundred and twenty herrings for an English penny, equal to a carolus of **France**, in the fishing time. They import wine and salt from **France**, and sell there strong frize cloths at good prices.


The Irish are fond of strangers, and it costs little to travel amongst them. When a traveller of good address enters their houses with assurance, he has but to draw a box of sinisine[90](javascript:footNote('T100076/note090.html')) or snuff, and offer it to them; then these people receive him with admiration, and give him the best they have to eat. They love the Spaniards as their brothers, the French 



---

p.44



as their friends, the Italians as their allies, the Germans as their relatives, the English and Scotch as their irreconcileable enemies. I was surrounded on my journey from **Kilkinik** to **Cachel** by a detachment of twenty Irish soldiers, and when they learned I was Frankard (it is thus they call us), they did not molest me in the least, but made me offers of service, seeing that I was neither Sazanach *Saxon* nor English.


The Irish, whom the English call savages, have for their head-dress, a little blue bonnet, raised two fingers breadth in front, and behind covering their head and ears. Their doublet has a long body and four skirts; and their breeches are a pantaloon of white frize which they call trowsers. Their shoes which are pointed, they call brogues with a single sole. They often told me of a proverb in English, ‘Airische brogues for Englich dogues’ *Irish brogues for English dogs* ‘the shoes of **Ireland** for the dogs of **England**,’ meaning that their shoes are worth more than the English.[91](javascript:footNote('T100076/note091.html'))


For cloaks they have five or six yards of frize drawn round the neck, the body, and over the head, and they never quit this mantle, either in sleeping, working, or eating. The generality of them have no shirts, and about as many lice as hairs on their 



---

p.45



heads, which they kill before each other without any ceremony.[92](javascript:footNote('T100076/note092.html'))


The northern Irish have for their only dress a breeches, and a covering for the back, without bonnet, shoes or stockings. The women of the north have a double rug, girded round their middle and fastened to the throat. Those bordering on **Scotland** have not more clothing. The girls of **Ireland**, even those living in towns, have for their head-dress only a ribbon, and if married, they have a napkin on the head[93](javascript:footNote('T100076/note093.html')) in the manner of the Egyptians. The body of their gowns comes only to their breasts, and when they are engaged in work, they gird their petticoat with their sash about the abdomen. They wear a hat and mantle very large, of a brown colour [couleur minime][94](javascript:footNote('T100076/note094.html')) of which the cape is of coarse 



---

p.46



woollen frize, in the fashion of the women of Lower Normandy.




---

p.47


#### 8


The seventeenth of July I went to the roads of **Wachefort** to embark on board a pinnace,[95](javascript:footNote('T100076/note095.html')) which I was refused. I went on my knees to the skipper or master, to induce him to receive me on promise of remuneration; after much altercation he told me, that ‘if he met with any Frenchmen he should take me to **France**, if with Biscayans to **Spain**.’ I answered him that which way I went was indifferent to me provided I could get out of **Ireland**. We sailed immediately, but the wind having changed against us, we were obliged to make the mole, and to anchor in the same spot from which we had taken our departure. From thence he sent me ashore again, saying that he would not risk for the passage of an individual, the loss of his cargo; that if he were taken by the French, and that I did not keep his secret, they would declare that his vessel was a lawful prize, having smuggled goods on board. I entreated of him not to leave me in this island, which I had no 



---

p.48



means of quitting, since the natives were in such fear of the Parliamentarians that they dared not put to sea. He remained inexorable, and I was astonished at the ungraciousness of this Irishman, as his countrymen are in general so attentive to strangers. He obliged me to remain in this island, where civil warfare was raging on all sides, and from which the escape appeared to me very difficult, because there was no vessel at **Doublin**, at **Limmerik**, and at **Waterfort**. **Scotland** was out of the question, for there was no security there.


On the same day I went to complain to my intimate friend, **Mr. François Chariot**, an inhabitant of **Wachefort**, who was astonished at the conduct of the skipper, and begged me to have patience until he had seen Mr. Telin *(Teeling)*, the owner of the cargo, who, upon **Chariot** telling him that I came from **Avignon**, a country by no means inimical to the Spaniards, promised him to allow me a passage, and gave him an order, which he carried to the roads, and made me re-embark.


The next morning we sailed to the south, and the fourth day we arrived at **Souling** Isle, called by us Sourlingue where three Salee vessels chased us, and obliged us to run for the coast near **St. Yues** in the south of **Cornual**. We met there a Parliamentary frigate of twenty-four guns, which was to windward of us, and came within cannon shot of our pinnace, in which we had but six men. We should have preferred falling into 



---

p.49



the hands of the Turks than of the Parliamentarians, because with the first we should have been assured of life, and with the others were certain of being killed, on account of the massacre which the Irish had made in their country of the English colonists.[96](javascript:footNote('T100076/note096.html')) We did on this occasion all that human power could effect, and doubled the **Blac hed**[97](javascript:footNote('T100076/note097.html')) fortunately without accident, thinking that we had escaped, as we kept creeping to windward of the Parliamentary frigate; but the tide being against us, we were brought pretty close together, and she neared us within musket shot. Perceiving the English royal colours, we were in doubt whether this was a Parliamentary frigate, and to ascertain it we hoisted at the stem the English flag.


The first cannon shot which they fired at us, went through the middle of our flag. We recommended ourselves to God, and expected assistance only from heaven. We would willingly have run our vessel ashore, but the coast did not allow it. The wind fell, so that we fired several times a small piece of ordnance which we had on the stern; this made us 



---

p.50



advance with the least possible wind, and the Parliamentarians firing from their prow retarded them. They chased us ten leagues, firing incessantly, and left us only under the fort of **Falmoutz**, which fired upon them two vollies of cannon, where **Lord Jermein** *Jermain* and the greater part of the English court, who were waiting for a passage to **France** with her most Serene Majesty the **Queen**, witnessed this unequal engagement, from which we escaped by the providence of God, to whom be the glory, and to me the remembrance of his gracious mercy.


Two miles from **Falmoutz**, there is a little town called **Perrine**, where I went to see some friends with whom I had become acquainted in **England**. I there met Captain Smitz[98](javascript:footNote('T100076/note098.html')) *(Smith)*, who had learned his profession under the late Captain Giron, and who gave me a passage to **France** in his vessel, promising to treat me with all due respect; which offer I accepted, on account of the friendship he bore me.




---

p.51


#### 9


On the morning of Sunday July the 24th, two remberges and three frigates of the English Parliament appeared off **Falmoutz** to prevent her most Serene Majesty from leaving **England**, which vessels separated about ten o'clock, with the view not to alarm us. We deliberated upon sailing at noon, because the Parliamentary vessels were under the impression that we should not dare to sail except at night.


The vessel in which the **Queen** embarked was a Dutch ship mounting forty-six guns, and was the first to sail; she was followed by Captain Smitz's ship, in which I was, and which mounted thirty-eight guns: Then came two heavy English frigates and a Hambourg flutte, loaded with men and baggage. Within cannon-shot of **Falmoutz** the Dutchman hoisted the Dutch flag at the main-mast, as Admiral of the fleet, and gave orders to Captain Smitz to return shot for shot, if the Parliamentarians attacked us. As we continued our voyage the five vessels of the Parliament were descried, one of which hove too upon the Dutchman, and being equally distant from us fired two broadsides; one 



---

p.52



upon the Dutchman, and the other at us, to make us shorten sail. The Dutchman sheered off, and the remberge fired two or three shots at him, which took effect not far from the Captain's cabin which the **Queen** had left to go into the hold. The Dutchman being the swiftest sailer, but not so strongly built for action as the remberge, was not long in escaping. She had alongside her a small craft of the Felloukque cut, the crew of which was composed of six Bas-Bretons with oars, to save the **Queen** in case of a calm or an uncertain engagement. We soon lost sight of them; the two English frigates and the Hambourg flutte made for the pier, and we remained alone harassed by the two remberges and three of the enemy's frigates, firing our guns in our defence according to the order of our Admiral, who had left us in the lurch, and in consequence of the cowardice of the captains of the frigates who had abandoned us.


Captain Smitz seeing that we were over-matched, skilfully hove too between the two remberges in order to stand out to sea, because they are not such good sailers as the other vessels. The Admiral alone followed us with one frigate, and the Vice-Admiral gave chace to our flutte; and one of the frigates returned to London and the other to **Milfort**[99](javascript:footNote('T100076/note099.html')) in **Wales**, to announce the news of the departure of the **Queen**.




---

p.53


#### 9


The night was very clear, and we had the two vessels so near ours, that the guns of the remberge were able to hit the frigate which was on the other side of us. In the morning the wind freshened a little, and we passed them at some distance; but towards noon we again closed. Then Captain Smitz quietly spoke as follows:—‘Harkee, my boys; I have once already been taken by the Parliamentarians, when my vessel was wrecked with Dutch troops on board for the service of His Majesty. I would rather die a thousand times than fall into their hands, because I promised them and swore upon the Gospel never to carry arms against them. Come all of you upon deck, in order to repel them if they should try to board us, for I am determined, after having made all the resistance possible, to set fire to the powder room, and to meet death in this manner. However, gentlemen, you are here eighteen brave cavaliers upon whom I rely. Let us not be dismayed by the struggle.’ Every one then showed himself with a musket and drawn sword to prove to the enemy that we were well manned. This stratagem deterred the frigate from boarding us, and she contented herself with firing at us balls, and chainshot hoping to dismast our vessel. We returned their fire, and cut away many parts of their rigging. After this running fight had lasted two days and two nights, we saw the coast of **Brittany**, and our enemies left us. At the same time our main-sail fell, the great rope being cut in two by a shot; if they 



---

p.54



had not put their helm about, they would have captured us, in consequence of our Captain not having taken the precaution to put chains to hold the yards, either because he had none, or that in the heat of the action it had slipped his memory; as our negligence only struck us after the danger was passed.


Having nearly reached **Conquet**, we put back to sea, on account of a fog which arose on the coast of **Brittany**, which is rendered dangerous by several rocks thereabouts. The following day we arrived at **Conquet**, a small town, where we took on board a pilot for **Brest**, which is seventeen miles distant. The pilot told us that there was no fault to be found with the Dutch captain for not fighting, since the **Queen** had forbidden him. This, however, so *far* from satisfying Captain Smitz made him fly into a passion, and he said thereupon all that anger could express, because the Dutch captain had ordered him to fire shot for shot, and had nevertheless abandoned him surrounded by five vessels.


Being both at **Brest**, her most Serene Majesty made up their quarrel, and reconciled them after a manner, but Captain Smitz never forgot the behaviour of his superior officer.


**Brest** is the depôt of the French Admiralty, where every thing is provided necessary for the equipment of vessels for sea. This place is of the highest importance, being the key of Lower **Brittany**. The harbour is the most capacious, and the finest which I ever saw, after that of **Ormous** I saw in 



---

p.55



this port the famous vessel la Couronne, of upwards of eighty guns, the largest of which were forty pounders. The hull of the vessel was 1636 tons. On the stem were figured the arms of the late Cardinal Richelieu, with these words written, ‘SUBDIDIT OCEANUM.’ He has conquered the ocean. A device which might possibly have come to pass if this Minister had had health equal to his talent, and had been able to govern himself as he governed others.


#### 9


*P.S.—The observation of my valued friend **Mr. D'Israeli**, in the Fifth Volume of his most interesting and important Commentaries on the Life and Reign of Charles I.; when speaking of the secret anecdotes of years 1644 and 1645, and referring to the dispatches of the French resident at London, (Monsieur Melchoir de Sabran,) is as applicable to our traveller's mode of spelling proper names, (which have been preserved as originally printed), as to the value of a narrative relating to a period subject to party representations.*


*Such documents, **Mr. D'Israeli** remarks, ‘are precious, as the personal observations of a foreigner who was intimately acquainted with the busy actors 



---

p.56



of the time. As is usual with the French, the writer could not contrive to write down their names, but by trusting to his own Gallic ear. It required some ingenuity to discover in **Le Comte d'Orgueil, the Earl of **Argyle****; in **Le Comte de la Dredayle, Lord Lauderdale**; **Milord Canouel Lord Kinnoul**; **Colonel Guaiche, Goring**; and it required some time to unmask **Milord Ausbrickto detect Lord Uxbridge.**’*


*Many an English tourist in **Ireland**, however, may be charged with blunders quite as serious as any that can be objected against our French traveller; for instance, **Mr. Curwen, M.P.** in vol. ii. p. 4, of his Tour through Ireland, published about twenty years since, renders **Ballincollig** by *Bally Cobleck*, and translates **Lord Mountcashel** into *Mr. McCassel* &c.
  

C.*




---

p.57




---

p.58


APPENDIX
--------




---

p.59


#### 1


The question asked cannot in the slightest degree impeach our traveller's authenticity. He merely records what he heard, which he guardedly states to be ‘according to the calculation of the Protestants.’ But the **Abbé MacGeoghegan** claims attention in this controversy. *(Histoire d'Irlande, p. 670).

It is impossible to determine with exactness the number of the unfortunate who perished during the twelve years that this barbarous scene lasted, with more or less violence. Protestant authors endeavouring to charge the Catholics with the infamy of this massacre; the extravagant and romantic list produced by **Sir John Temple**, and some other authors of the same stamp, of *three hundred thousand*  Protestants massacred *in a single province* are not only ridiculous, but altogether impossible. **Mr. Hume** draws a frightful picture, and at the same time less faithful, of the massacre which occurred in **Ireland**, 1641. He lays the charge on the Irish alone; all that he says is but a recital of what the republican and fanatic authors had so many times repeated after **Sir John Temple**, and which had been so frequently answered’’*




Now, no such assertion as **Sir John Temple** is here twice represented to have made, and which charge is repeated even to satiety against that historian, can be even inferred from any 



---

p.60



construction of his words. **Sir John Temple** says, that in ‘not full two years after’ the breaking out of the hostilities of 1641, ‘above three hundred thousand British and Protestants [were] cruelly murdered in cold blood, destroyed some way or other [that is, in the course of warfare, by want of food, exposure to the weather, fright, or other causes,] or [mark the *or*] *expelled out of their habitations,*’ These are the precise words of **Sir John Temple**, which Catholic writers have distorted by a sweeping assertion into an actual massacre of the total number, including therein all those who suffered even inconvenience by removal of abode; and thus is **Sir John Temple** popularly stigmatised in **Ireland** as having written ‘as many lies in a manner as lines in his *romantic legend* of the Irish rebellion, on purpose to blacken the people, and exasperate the Republicans of **England** against them, and against the King too, upon the account of the murders he pretends to have been committed.’


This quotation is made from the last edition of The Impartial History of Ireland, or The Genuine History of Ireland, by **Hugh Reily**, of which the reprints of 1782 and 1833 for popular circulation, lie before me. **Hugh Reily**'s impartial history, it should be observed, is nothing more than a political pamphlet, written to prove the justice of resuming the Roman Catholic estates forfeited under **Queen Elizabeth** and **Cromwell**. The writer observes:—‘Before I proceed any further, 'tis necessary to examine what I heartily wish for the credit of both parties could be buried in eternal oblivion, that is, the many outrages and barbarous murders committed on *both sides* during the unhappy war’ [To this I heartily subscribe.] ‘Neither party can be excused, but those to be sure are more to blame who began the tragedy. 'Tis certain,’ 



---

p.61



continues **Hugh Reily**, that ‘each of them has laboured to throw the first scene upon the other; but upon the whole matter, I think, it is very plain, that the Protestants were the first actors upon the stage, *who immediately upon the discovery of the plot in **Dublin***, finding there were not many concerned *in the Northern insurrection* but men of desperate fortunes, and apprehending that few estated natives would willingly engage in a rebellion, took what measures they could to provoke and frighten them into it. [?] In order to which design they sent out several parties, as well in remote places as round about **Dublin**, who murdered a great many without distinction of age or sex; particularly at **Santry**, **Clontarf**, and **Bullock**, all within three or four miles of the city, where they massacred in the beginning of November, 1641, near upon four score of the poor country people; as the garrison of **Carrickfergus** some days before butchered in one night *all the inhabitants of the country called **Island Magee**,* to the number of two or three thousand men, women, and children. The like feats were done by **Lord Broghill, late Earl of **Orrery****, in the counties of **Cork**, **Waterford**, and parts adjacent; by **Sir Charles Coote**, in his expedition into the County of **Wicklow**; by **Captain Peasely Brown** and others, in the county of **Tipperary**; and in fine, because it was a general contrivance by most of the Protestant garrisons of any strength all over the kingdom.’


**Hugh Reily**, after a paragraph upon which there is not space to comment here, thus proceeds:—‘'Tis not yet known how many were thus sacrificed on either side; but too many they were, be they never so few. **Sir John Temple**'s romantic legend, where he draws up his muster roll of two or three hundred thousand of English Protestants massacred in one province, is not only 



---

p.62



incredible, but most ridiculous and absolutely impossible. For (to omit that some hundreds said to have been there slain, were living for many years after, and some of them lived to see the Restoration,) all informed men must own, there was not half that number of Protestants in the whole kingdom in the summer of 1641, as the aforesaid author of the Catholic Apology, an English person of honour, who generously took some pains to examine this aspersion, has proved not only from good reasons, but even from Protestant writers; and concludes upon the whole matter, that all these hundreds of thousands said to have been murdered in the North could not exceed three thousand. And **Sir William Petty**, an Englishman and a Protestant too, who was Clerk to the Usurper's Council, and Surveyor General of the lands in **Ireland**, an ingenious inquisitive person, affirms that upon the exactest scrutiny there were not above thirty-six thousand on both sides killed in the field, or murdered in cold blood during the whole war.’


Now all this, so far as regards **Sir John Temple**'s assertions, is combatting with a shadow which the writer's fancy has conjured up. **Sir William Petty**'s statement is, no doubt, that nearest the truth; but **Sir John Temple**'s authority has been most unfairly assailed, as ‘a romantic legend,’ by those who assert that two or three thousand men, women, and children were ‘butchered’ (here there can be no mistake about the expression) in one night in the island of Magee.


**Mr. MacSkimin**, the ingenious author of the History of Carrickfergus, has investigated the question of the massacre in the island of Magee. with so much research, and has bestowed so much able and cool investigation on the subject, that his statement merits the serious attention of all interested in the 



---

p.63



history of **Ireland**, and who feel that history is no party question.


‘The earliest account,’ says **MacSkimin**, ‘in which the Protestants are charged as being the aggressors in the harbarities of 1641–2, appears in an anonymous pamphlet, entitled The Politician's Catechism by R. S., printed and published in London in 1662; twenty-one years after the events are said to have happened, which it pretends to describe. A short paragraph in this tract has been the basis of all the gross misrepresentations that have been published on this subject. It is as follows:—
  

About the beginning of November, 1641, the English and Scotch forces in **Knockfergus** murdered in one night *all the inhabitants* of the territory of **Island Magee**, in number above *three thousand*, men, women, and children, all innocent persons, in a time when none of the Catholics of that country were in arms or rebellion.’ To this article is added the following note. ‘This was the first massacre committed in **Ireland**, on either side.’ Here we plainly perceive gross mis-statements, it being notorious that the rebellion began on the twenty-third of the previous October, and that the twenty-fourth of that month was marked on the part of the Roman Catholics by all the sanguinary atrocities of the period in question.


‘It is worthy of remark, that the season chosen for the publication of this slanderous and anonymous pamphlet was truly auspicious; the tide was turning fast from Puritanism to Popery; the Roman Catholics were a considerable body at Court, and both the King and the Duke of York had by several acts evinced their partiality for that faith.’


‘Some years after the publication of this pamphlet by R. S., it was bound up as an Appendix to **Lord Clarendon**'s 



---

p.64


History of the Affairs of Ireland, doubtless for the purpose of giving its falsehoods weight and publicity, by their being attached to a work bearing on its title the high authority of his Lordship's name.’


‘Of the slanders thus propagated, the Protestants of that time appear to have been well aware. **Sir Audley Mervin**, speaker of the Irish House of Commons, in addressing the **Duke of **Ormond****, 13th February, 1662, says — ‘The Roman Catholics of this kingdom may get a reputation and credit to those pamphlets which they have dispersed through Europe, that his Majesty's Protestant subjects first fell upon and murdered them.’’


‘The next notice we have observed on the same side is contained in a small work entitled The Genuine History of Ireland, said on its title to be written by **Hugh Reilly** (Dr. Nary) [?], printed in London in 1742. In this tract it is said that the massacre in **Island Magee**, happened early in November, 1641, and that the number of sufferers amounted to between two and three thousand persons; but it is admitted that the rebellion began on 23rd October, 1641.’


‘Incorrect as these accounts are, as to the time and the number murdered, they are nevertheless repeated in a work entitled, A Dialogue on the Rebellion of 1641, published in 1747; and also in a book entitled, Memoirs of Ireland in a letter to Walter Harris, Esq., printed in 1757. A similar statement is also given, on the authority of **Lord Clarendon**, in Desiderata Curiosa Hibernica, printed in **Dublin** in 1772; and likewise by **Dr. Curry**, a Roman Catholic, in his Review of the Civil Wars of Ireland, published in 1775. **Francis Plowden, Esq.** an English Roman Catholic Barrister, also asserts the same in his ponderous



---

p.65


Historical View of the State of Ireland printed in 1803, giving **Lord Clarendon** as his authority; although, in reality, his Lordship's work is a complete refutation of his assertions. A still later work, by an Irish Roman Catholic, contains similar information; he gravely tells his readers, that he will not disgust them with an account of that atrocious massacre, nor set down the terrible vengeance inflicted by the Irish on their sanguinary enemies. This is saying pretty plainly that the Protestants were the aggressors.’


‘It is particularly worthy of remark, that the Remonstrance of the Roman Catholics, presented to the King's Commissioners at Trim, in March, 1642, takes no notice of any murders committed in **Island Magee**; nor is any mention made of them in the Humble Apology, of the Roman Catholics to his Majesty, for their taking up arms; nor yet in the second Remonstrance presented to the King. From their silence on this head we may fairly infer, that had their accounts of the massacre been true, as to time and numbers, it would have formed a chief feature, not only in one of these documents, but in them all.’


‘It is not a little remarkable that Protestant writers should have inadvertently fallen into a portion of the same error, as to numbers, and have ascribed this massacre to the fanaticism of the Scotch Puritan soldiers, when it appears from several historical documents that *no* Scottish troops arrived at **Carrickfergus** till the following April. **Carte**, in his Life of the Duke of Ormond, mentions the massacre as committed by the garrison of **Carrickfergus**, but speaks with uncertainty as to the main points in dispute. **Dr. Leland**, in his History of Ireland, says that thirty families were massacred, but states it to have been committed early in January, 1642, 



---

p.66



‘when the followers of **O'Neill** had almost exhausted their barbarous malice.’ Since the time that **Leland** wrote, the minor Protestant historians appear to have contented themselves with merely quoting from one or the other of those authors.’


‘Some years after the suppression of the rebellion of 1641–2, this massacre, among other matters, attracted the notice of Government, and about 1650, an inquiry concerning it took place. **Bryan Magee, son of Owen**, whose family was among the chief sufferers, deposed, that about the 8th of January, 1641 (1642, according to our present calculation), he was living in his father's house in **Island Magee**, when nine of the family were murdered by twenty persons reputed Scotchmen, and their goods carried off by them. That on the same day, in the house of his next neighbour, **Daniel Magee**, the same Scotchmen (as one who escaped told him) killed **Daniel** and ten other persons; and that they all retired to **Carrickfergus** with prisoners; but that **Colonel Hill** not being in garrison, the Scotchmen took them out of the gate and killed three of them.’


‘**Elizabeth Gormally**, deposed seeing **Bryan Boye Magee**, son of the Magees, followed by drummers of the garrison of **Carrickfergus**, on Monday *after the great murder*, committed about the end of December, and after the breaking out of the rebellion.’


‘**Finlay O'Donnell**, deposed, that it was the report of the country that the chief actors in this horrid business were Scotchmen, who came from the neighbourhood of **Ballymena**. Another deponent also stated the same report, with the name of the leader of the murderers, who it is said was from **Ballymena**. Some of the deponents also gave the sirnames of 



---

p.67



several of the assassins, with the weapons used by them; and relate that one of the ruffians stabbing at a female with a dagger, killed an infant in her arms.’


‘The deposition of **James Mitchel of **Island Magee****, a Dissenter, corresponds exactly, as to the time of the masacre, by stating that it was in the afternoon of Sunday, 8th January.’


‘While,’ continues **Mr. MacSkimin**, ‘we must all deplore this horrid deed, we must also reprobate that malignant spirit which even yet continues to advance such gross exaggerations, which we think is sufficiently apparent even from the general population of the parish at that period. In 1599 **Fynes Moryson** states, that the **Island of Magee** was desolate; and between that time and 1641, there was little tranquillity, Tyrone's rebellion having rendered the greater part of Ulster literally a desert. By the returns of the census of 1819, **Island Magee** then only contained 1931 inhabitants; and by that of 1821, 2300 persons, probably eighteen or twenty times the number of people at the period of the massacre; and we see that some of them were Dissenters, and that a number of Roman Catholics were preserved.’


‘Before taking leave of this subject, it may not be amiss to remark how easily 30 could be altered to 3000, the number in the pamphlet of R. S.; in which pamphlet the small peninsula of **Island Magee** is called a *territory*, a word generally understood to signify a large tract of country, rather than a mere stripe, without either hamlet or village. Judging therefore by the depositions of the survivors, the probability is that *thirty individuals* were not under the number who suffered.’ C.




---

p.68


II
--


‘The belief of moving islands in these seas was very ancient. **Giraldus** tells us of an island on the Irish coast, which suddenly made its appearance one clear day, and which disappeared the moment any one approached it. At length a party went out in pursuit of it, and as they approached within bowshot, one of them struck it with a red-hot arrow, the consequence of which was that it immediately became stationary. The conclusion which **Giraldus** draws from this legend is curious.’— ‘Multis itaque patet argumentis’ says he, ‘phantasmati cuilibet ignem semper inimicissimum.’—**Girald. Camb.** Topog. Hib. lib. ii. c. 12—W.


Milton thus poetically explains the idea entertained by northern voyagers of floating islands.

> 1. . . . that sea-beast
>   
> Leviathan, which God of all his works
>   
> Created hugest that swim th' ocean stream:
>   
> Him haply slumb'ring on the Norway foam
>   
> The pilot of some small night-founder'd skiff
>   
> Deeming some island, oft, as sea-men tell,
>   
> With fixed anchor in his scaly rind
>   
> Moors by bis side under the lee, while night
>   
> Invests the sea, and wished morn delays.
> 


  
M.


**Mr. Hardiman**, in his Irish Minstrelsy, (a work which I regret to find so deeply tinged with the writer's political opinions), has an extremely curious note upon what he calls these ‘Miranda loca’ of former times. In modern days, however, the minute search after the imaginary danger known by the name of 



---

p.69



‘**Aitkins's rock**’, by Captain Vidal, of the Royal Navy, and the delineation of the sub-marine bank which now bears his name, are labours that have in some measure dispelled the mist of enchantment from the navigation of the north-west coast of **Ireland**, and which the survey of Captain Mudge will complete.


**Mr. Hardiman** refers[100](javascript:footNote('T100076/note100.html')) to the unpublished manuscript History of Ireland, in the library of the Royal Irish Academy, where the author states that, ‘the Tuathdedanans coming in upon the Fearbolgs, expelled them into the out islands which lay scattered on the north coasts, and they themselves were served the same measure by the Clanna Milidhes, but what became of the remainder of them I cannot learne, unless they doe inhabitt an iland, which lyeth far att sea, on the west of Connaught, and sometimes is perceived by the inhabitants of the Oulis and Iris. It is also said to be sometime seene from Saint Helen Head, being the farthest west point of land beyond of the haven of Calbeggs (Donegall). Likewise several seamen have discovered it att sea, as they have sailed on the western coasts of **Ireland**; one of whom, named Captain Rich, who lives about **Dublin** of late years, had a view of the land, and was so neere that he discovered a harbour, as he supposed, by two head lands on either sides thereof, but could never make to land, although when he had lost sight thereof in a mist which fell upon him, he held the same course several hours afterwards. This I am bold to insert by the way, because I have heard a relation hereof from many credible persons, and particularly from the said Captain Rich, allsoe in many old mapps (especially mapps of Europe or mapps of the world) you shall find it by the name of *O'Brasile*, under the longitude 03 [ordm ] 00 minutes, and the latitude 50 [ordm ] 20 minutes. So that it 



---

p.70



may be those famous enchanters now inhabitt there, and by their magick skill conceal their iland from forraigners. Yett this is my own conceipt, and would have it taken for no other.’


‘But,’ says **Mr. Hardiman**, ‘the most complete account of this fanciful island is to be found in a letter from a gentleman in **Derry** to his friend in **England**, printed in London in the year 1675. The narrative is so curious, and the pamphlet in which it appeared so scarce, that I am induced to lay it entire before the reader. To those possessing strong imaginative powers, it presents an ample field for romantic fiction.’


‘***O'Brazile**, or the Enchanted Island, being a perfect relation of the late Discovery, and wonderful Dis-inchantment of an Island on the North of lreland, &c.*’ 


> Honoured Cousen,
> I have received yours of the 12th of February, and the printed relation of the certain death of that arch-pirate Captain Cusacke; of whose death all our merchants here in **Ireland** are very glad; especially my cousen Mathew Calhoon, from whom Cusacke took the last vessel; which it seems brought him to his deserved fatal end. And in requital of your news concerning Cusacke, I shall acquaint you with a story no less true; but I believe much more strange and wonderful, concerning the discovery of that long-talk't-of island **O'Brazile**, which (I believe) you have often heard of.
> 
> 
> I know there are in the world many stories and romances concerning inchanted islands, castles, and towers, &c., and that our king's dominions may in nothing be inferiour to any other nation, we have had an inchanted island, upon the north of 
> 
> 
> 
> ---
> 
> p.71
> 
> 
> **Ireland**, long talk't of. And indeed when I went first into the kingdom of **Ireland** to live, and heard those many stories which were common in every man's mouth, concerning the island of **O'Brazile** (as they called it), which multitudes reported often to be seen upon the coast of Ulster, in that kingdom; yet I lookt upon it as a perfect romance, and many times laught the reporters to scorn; though many sober and religious persons would constantly affirm, that in bright days (especially in summer time) they could perfectly see a very large absolute island; but after long looking at it, it would disappear. And sometimes one friend and neighbor would one call another to behold it, until there would be a considerable number together; every one of which would not be persuaded but that they perfectly saw it, and some of them have made towards it with boats; but when they have come to the place where they thought it was, they have found nothing. And many old people in the countrey would tell many old probable stories, how it came first to be inchanted. I confess there were (in those days) two things made me little to wonder.
> 
> 
> 1st. How it came to be inserted into many of our both ancient and modern maps (as you or any man may find it is), by the name of **O'Brazile**.
> 
> 
> 2d. The other is, what moved your cousen (that you know died but within these four or five years at Glasslough), who was a wise man, and a great scholar, to put himself to the charges and trouble (in the late king's time), to take out a [101](javascript:footNote('T100076/note101.html')) patent for it, whensoever it should be gained, certainly he and those that counselled him to it, lookt upon it as some inchanted
> 
> 
> 
> ---
> 
> p.72
> 
> 
> 
> (if any such thing there be) kingdom or island, that in time, might be recovered. And since the happy restoration of his Majesty that now reigns, many reports have been, that it hath been disinchanted or taken, yea, in the time of the sitting of the last parliament in **Dublin** (in the year 1663), one coming out of **Ulster**, assured the House of Commons (whereof he was a Member), that the inchantment was broken, and it gained; but it proved not so, and about two years after, a certain Quaker pretended that he had a revelation from Heaven, that he was the man ordained to take it, with a new ship built by inspiration, &c., and in order thereunto he built a vessell, but what became of him or his enterprize, I never heard, it seems that the full time was not then come. I assure you (dear cousen), I was not then so unwilling to believe it, as now I am certain of it from very good hands, but whether (in the original) it have been a trick of **Rome**, one of the works and mysteries of **Babylon**, I cannot say, neither dare I dispute, but this I am sure of, that the time, or inchantment (or what you please to call it), is now out and the island fully discovered, or taken, and the manner briefly thus —
>   
> 
> There is one Captain John Nisbet, who lived formerly at **Lisneskey**, in the county of **Fermanagh**; this man left **Lisneskey**, seven or eight years since, and came to live at **Killebegs**, in the barony of **Boylagh and Bannagh**, in the county of **Dunnegall**, in **Ulster** (a corporation you know right well). This man, Captain Nisbet, since he came to **Killebegs** hath fraught out several vessels to **France** and **Holland**, &c. with such merchandize as the country afforded. And in September last he fraught out a vessel of about 70 tons, laden with butter, tallow, and hides for **France**, which was to bring 
> 
> 
> 
> ---
> 
> p.73
> 
> 
> 
> back French wines, which vessel being returning, and near the coasts of **Ireland** (as they thought) upon the 2d of this instant, March, 1674, after a most clear and frosty night, in the morning, about the time of sun rising, of a sudden, there fell a most terrible thick mist of fog, upon the sea, round about them, which continued the space of about three hours, and then cleared up again, very bright. But when the mist was vanisht, they found themselves upon a certain coast, close by the shore, and of a sudden also, a very high wind, driving them still nearer to the land. When the master, and the rest with him (who were but eight persons in all), viz. James MacDonnel, the master, Alexander Johnson, skipper, James Ross, carpenter, and five mariners, saw themselves so near an unknown shore, and could not imagine what place it should be, for though they knew most of the shores of **Ireland** and **Scotland**, yet they could not possibly give any guess where they were. Finding themselves therefore so near land, and some little rocks not far off them, the master gave orders to sound what waters they had; and finding it not three fathoms, they thought it was the best course to strike sails and drop an anchor (which accordingly they did), until they might inform themselves where they were. And having cast anchor, they resolved to set four of their eight men ashore, to see if they could learn where they were, and how to get off; which, after they had taken down their boat, they did. The persons that were to goe, were the carpenter, James Ross, and three mariners, who took with them swords and pistols. Presently after landing, they past through a little wood, and within less than an English mile in a most pleasant green valley (wherein were many cattle, horses, and sheep feeding), they saw a very strong-like castle appearing, unto which they repaired, and 
> 
> 
> 
> ---
> 
> p.74
> 
> 
> 
> called thinking to find some that might direct them where they were, and what to do, but after they had long knockt, and saw nor heard any creature (not so much as a dog) answer, they concluded it was some waste place, and therefore left it, and going further up a most pleasant green hill, they saw multitudes of black rabbets, about a mile from the castle; but when they came to the height thereof, look which way they pleased, they could see neither man, woman, child, nor house; at last having ranged two or three hours about the country, and lighting on none to enquire of they returned again to their boat, and told their fellows aboard what success they had had; whereupon their fellows calling for the boat, resolved to come ashore also, all but one mariner; which they did, and dividing themselves into two parts, one part took the right hand shore, and the other the left; both parties wandering up and down, until four of the clock in the afternoon, but neither of them saw any people to enquire of; but much cattle, deer, rabbets, &c., but afar off in the country, they saw great woods, into which they dare not venture; so that both parties returned again to their boat. At last the weather being very cold and drawing towards night, finding abundance of old dry wood, in the side of the above named little wood, near unto the shore, they resolved to make a great fire, against a great old oak, that was fallen down with age; and in order thereto some brought wood, and some others struck fire; and at last, having made a rousing fire, and sitting warming themselves, discoursing and taking tobacco, on a sudden they heard a terrible hideous noise, towards that place, especially where they saw the old castle, and almost all over the island, which did so terrify and amaze them, that they presently left their fire, took their boat, and went all aboard as fast as they could, where they continued 
> 
> 
> 
> ---
> 
> p.75
> 
> 
> 
> in great fear all night, yet neither could nor durst stir out to sea, because when they sounded again, they had not two fathoms of water, and the wind directly against them.
> 
> 
> The next morning, as soon as the sun was risen, they saw a very ancient grave gentleman, and ten men following him bareheaded (as if his servants) coming towards the shore, where the ship lay, and being come close to the water side, the old gentleman calling to the master (in the old Scotch language), who, with the rest stood upon the deck, asked him, from whence they came? whither they were bound? and with what they were laden? The master answered, they were come from **France**, were laden with French wines, with which they were bound to **Killybegs**, in the county of **Dunegall**, in **Ireland**, if it pleased God to give them leave. Then the old gentleman askt them, how they came thither? and whether they knew where they were? or how to get forth? The master told him that before the great fog fell upon them yesterday, they thought they were near the coast of **Ireland**, but where they now were, or how to get off, he knew not in the least. Then the gave gentleman told them, if they would please to come ashore again, they should be courteously entertained, told where they were, well rewarded, and guided to their own coast. Then the master asked whether they should have no wrong or harm done to themselves nor vessel if they came ashore? The old man promised they should not, whereupon the master and the rest seeing no arms with them, resolved six of them should come ashore well armed.
> 
> 
> As soon as they were landed, the old gentleman embraced them one by one; telling them, they were the most happy sight that island had seen some hundred years; that the 
> 
> 
> 
> ---
> 
> p.76
> 
> 
> 
> island was called **O'Brazile**; that his ancestors were sometimes princes of it, telling them also, that he and several persons of quality, by the malicious diabolical art of a great Negromancer, had been tyrannically shut up in the castle they knockt at yesterday, in which several of their progenitors had ended their miserable days: and the whole island a receptacle of furies, made (to mortals) unserviceable and invisible, until now that the cursed time was expired, which (saith he) continued until the last day of the last month, but three or four days since. Being askt why none answered in the castle yesterday when the mariners knockt so long, he answered that though the wicked time was expired, and that now the island was visible, and any might come upon it, yet he and the rest had neither power to answer any that spoke to them, nor free themselves from imprisonment, until fire was kindled upon the island by some good Christian; being askt whether it was now absolutely free, and would never be inchanted again? he told them it was now absolutely free, and should never be troubled again, but all the powers of darkness, when they heard that hideous noise, were finally departed.
> 
> 
> After which words he led them towards the said castle (the chief tower being as it were demolished), where met them, several other grave persons, both men and women, who all embraced the master and the rest, giving them many thanks; then the other two were fetcht out of the vessel, and all nobly feasted and richly rewarded and shewed the glory and riches of the said island, which they say is above sixty miles in length, and above thirty in breath, abounding with horses, cows, sheep, stags, rabbets, but no swine, and all sorts of fowls, and rich mines of silver and gold, but few people, and little or no corn; there have been cities and great towns, but all consumed.
> 
> 
> 
> 
> ---
> 
> p.77
> 
> 
> The men being richly rewarded, were conducted to their vessel, and shewed the way out of the harbour, and directed the way to their own coast; and came the next day, at night to Killybegs, where they acquainted the minister of the town, and many other persons of quality in the country who gave no extraordinary credit to their words at first, until the master and the rest shewed them many of the pieces of gold and silver which were given them there, which were large, and of a most ancient stamp, somewhat rusty, yet pure gold; the master also offering immediately to carry any gentleman to the said island, that desired to know the further truth, whereupon some gentlemen of the country, within three days after, sent out another vessel and the above-named Alexander Johnson, skipper, and some of the former mariners to guide her, to prove whether it were true or not, who brought them to the said island, where they were nobly entertained, and returned, in safety, with several gifts, which were bestowed upon them, as also some further relation of the nature of the countrey. Since then, several godly ministers and others are gone to visit and discourse them (but at the writing hereof I heard nothing of their return), who doubtless will bring a more perfect relation. Dear Cousen, you need not be afraid to relate this, for I assure you, beside the general discourse of the gentlemen of the country, I had it from Captain Nisbet his own mouth (whose the vessel, &c. was), since which several gentlemen have sent an express, with the true relation of it, under their hands and seals, to some eminent persons in **Dublin**.
> 
> 
> Thus not troubling you any further at present, I rest
>   
>  Your most affectionate
>   
> 
> Cousen and Servant,
>   
> 
> 
> 
> W. Hamilton.
>   
> Londonderry,
> 
> March 14, 1674.




---

p.78



> Dear Cousen,
> I think your young cousen Lesly is still in London; if yon can enquire him out, pray shew him this relation: it may be it may concern him, because his father had a patent for it.
> 
> 
> W. H.






---

p.79


III.
----


*> 1. ‘‘Nunquam imprudentibus imber
>   
> Obfuit; aut illum surgentem vallibus imis
>   
> Aëriæ fugere grues; aut bucula coelum
>   
> Suspiciens patulis captavit naribus auras;
>   
> Aut arguta lacus circumvolitavit hirundo;
>   
> Et veterem in limo ranæ cecinere querelam.
>   
> Sæpius et tectis penetralibus extulit ova
>   
> Angustum formica terens iter; et bibit ingens
>   
> Arcus; et e pastu decedens agmine magno
>   
> Corvorum increpuit densis exercitus alis.
>   
> Jam varias pelagi volucres, et quae Asia circum
>   
> Dulcibus in stagnis rimantur prata Caystri,
>   
> Certatim largos humeris infundere rores.
>   
> Nunc caput objectare fretis, nunc currere in undas.
>   
> Et studio incassum videas gestire lavandi.
>   
> Tum cornix plena pluviam vocat improba voce,
>   
> Et sola in sicca secum spatiatur arena.’’
>*

Georgica I. 373–389.




Thus rendered by **Dr. Maginn**.
  


> 1. Those who in weather signs are wise,
>   
> Can guard against approaching rain,
>   
> They note, as it begins to rise
>   
> From vallies low, how upward flies
>   
> In airy tour the soaring crane.
> 
> 
> ---
> 
> p.80
> 
> 
> The heifer, looking to the sky,
>   
> Snuffs the moist air with nostril wide,
>   
> The swallow, with its shrilly cry,
>   
> Soars round and round the lake's still side;
>   
> The frog among the marshes swells
>   
> His long-known note of croaking song.
>   
> The ants from out their inmost cells
>   
> Wearing their narrow path along,
>   
> Draw forth their eggs in busier march;—
>   
> Then deeper drinks the heavenly arch;
>   
> Then as the rooks their food forsake,
>   
> In crowding hosts their flight to take,
>   
> More clamorous is the cry they make:—
>   
> And all the birds that love the deep,
>   
> Or those who, by the Asian plain.
>   
> Near sweet Cäyster's waters sweep
>   
> In search of food, will then in vain
>   
> All in the waters fondly lave,
>   
> And dip their heads beneath the flood;
>   
> Or rapidly across the wave
>   
> In sportive rivalry will scud.
>   
> And loud the boding raven cries,
>   
> As if she would the rains demand.
>   
> And stalks along in solemn wise,
>   
> All lonely on the thirsty sand.
> 






---

p.81


IV.
---


The town of **Angers**, which appears to have been the native place of ***Boullaye* le Gouz**, was not unimportant at this period, and had been a fortified city of some consequence in the wars of Edward III. and Henry VI. and of the Huguenot. The population was about 20,000 souls. **Angers** possessed, before the Revolution, a military school (école militaire), to which, under the tuition of a certain Monsieur de Pignerol, there came a young Irish gentleman, in his seventeenth year, to study the rudiments of war. The pupil subsequently entered as Ensign in the 41st Regiment of Foot, and is now known by his title of **Arthur, Duke of **Wellington****. Well might Frenchmen say, of their noble vanquisher's military tuition, after the final catastrophe at **Waterloo**, what **Dido** is represented to have said apropos of the sword of **Æneas**, with which she immolated herself:
  

*Non hos quæsitum munus in usus.’’*

—Aeneid, 4.


  


See Note VII. for further observations on **M. le Gouz**'s 
estimate of the relative population of Irish and French towns.—R.




---

p.82


V.
--


**Barnabe Ryche**, in the 14th chapter of his Description of Ireland, printed in 1610, treats ‘of the superstitious conceit that is holden of the Irish about certaine Wels.’ He says—‘To the northwards from the city of **Dublin**, they have **S. Dolock's well**; another sanctified place ceremoniously frequented at certain seasons, foolish and ridiculous to be spoken of; so that let the wind blow which way it list, east, west, north, or South, **Dublin** is so seated, that a Papist may go from the high crosse, with a blowne sheat right before the wind either to an idolatrous masse within the towne, or to a superstitious well without the towne.’


‘Near it *[the church of St. Doulach's]* is a holy well, of great celebrity; it is within an octagon inclosure adorned with emblematic fresco paintings; a bath is supplied from the well.’— Grose's Antiquities of Ireland, vol. ii. p. 78. In which work an accurate view of the building erected over the well may be found.—C.




---

p.83


VI.
---


This anecdote is curious from the circumstance of the very nobleman whose vice-regal order our traveller refused to obey, having himself acted a similar part just ten years before. The **Lord Deputy Wentworth (Strafford)** having summoned a Parliament to meet on the 14th July, 1634, at the Castle of **Dublin**, published a Proclamation (to prevent any serious consequences from the animosities which existed among the members) that no one should enter with their swords. All obeyed except the young **Earl of **Ormond****, who told the Usher of the Black Rod, he should have no sword of his except through his body. Being the only Peer who sat that day in defiance of the Proclamation, his conduct so fired the **Lord Deputy**, that the Earl was called upon in the evening to answer for it. Thereupon he produced his Majesty's Writ, calling him to Parliament, Cinctum cum gladio, or per Cincturam gladii. Which answer being unexpected, and finding him likely to prove an untractable companion, it was in deliberation that night, between the **Lord Deputy** and his two friends, **Sir George Ratcliffe** and **Mr. Wandesford**, whether to trample under foot, or to oblige, so daring a young man, who was now also grown so very popular; when the more benign extreme being resolved on, he was taken into favour, and by the **Lord Deputy**, in his letter of the 16th of December, recommended to the King to be called into his Privy Council, to which honour he was accordingly raised in the following month.—C.




---

p.84


VII.
----


**M. Le Gouz** represents **Dublin** as equal to **Angers**, his native place, that is, as containing little more than 20,000 inhabitants, for such was the population of **Angers** in that day; but he makes **Kilkenny** as large as **Orleans**, which then, as 
now, was much more extensive than **Angers**. The inference would be, that **Kilkenny** was a more considerable city than **Dublin**, which certainly was not the fact. **Boate**, a contemporary of **le Gouz**, in his Natural History of Ireland, published a few years after our traveller's visit, classes the Irish cities thus, **Dublin**, **Galway**, **Waterford**, **Limerick**, and **Cork**, in the first line, and **Kilkenny**, **Drogheda**, **Bandon Bridge**, &c. in the second line; of course, far removed from the capital in dimensions. No doubt, while the Supreme Catholic Council sat there, as it then did, the population was increased, and may, possibly, have amounted to 15,000, or more: but **Dublin** still greatly exceeded it, probably four-fold. Of the two French cities, I can speak with more certainty, for I have better data, and from contemporaneous authorities may state, that **Angers** contained about 24,000 souls, and **Orleans** 31,000. The present population of the former is 33,000, of the latter, 40,250. **Mènage**, the Vadius of the Femmes Savantes, and one of the most celebrated men of his day, wrote the history of his native **Angers**. **Orleans** gave birth, with many other learned men, to the Jesuit Pétau [Petavius], and amongst women of renown, to the beautiful Maria Touchet, who justified the 



---

p.85



anagram made for her, ‘Je charme tout.’ She was mistress of Charles IX, and mother of one of Henry IV.'s favourites.
  
R.


Our traveller, elsewhere, compares **Pisa** and **Sienna**, to **Orleans**. So that **Kilkenny**, when the seat of the Irish Confederates, and of a Parliament, was of such extent as to rank with three of the first-rate cities of the Continent. **Pisa**, at that time, was a mighty emporium of trade, and a remarkably well-built city, filled (as it is to the present day, but with no additional monument) by gorgeous structures, civic and ecclesiastical.
  
M.


**Tighe**, in his Statistical Account of Kilkenny, states, that that town, in 1689, contained but 507 houses; in 1777, the number was 2274; in 1788, there was a further increase of upwards of four hundred, viz. 2689; and when he wrote (1802) 
**Kilkenny** contained 2870 inhabited houses.—The prosperity of **Kilkenny**, therefore, appears rapidly to have declined under the Commonwealth, Charles II. and James II.
  
C.




---

p.86


VIII.
-----


It was absolutely necessary that the rebels *this is the name applied by **Dr. Ledwich** to the Confederate Catholics* should have the form of an authority established among them, to make the orders of superiors obeyed, and prevent that confusion and those mischiefs which always attend competition for power, and uncertainty in the right to command; this was done in the general assembly of deputies from all the provinces in the kingdom, which met the 24th of October, 1642, at **Kilkenny**.


The first act, after their meeting, was to protest that they did not mean that assembly to be a parliament, confessing that the calling, proroguing, and dissolving that great body was an inseparable incident to the crown, upon which they would not encroach; but it was only a meeting to consult of an order for their own affairs until His Majesty's wisdom had settled the present troubles. They formed it, however, according to the plan of a parliament, consisting of two houses, in the one of which sat the estate spiritual, composed of bishops and prelates, together with the temporal lords, and in the other, the deputies of the counties and towns, as the estate of the commons, by themselves.


The meeting was at the house of **Mr. Robert Shee**, son of **Sir Richard Shee**, now *1802* Mr. Langford's, in Coal Market; the lords, prelates, and commons all in one room. **Mr. Patrick Darcy** bare-headed upon a stool, representing all 



---

p.87



or some of the Judges and masters of chancery that used to sit in parliament upon wool-sacks. **Mr. Nicholas Plunket** represented the speaker of the house of commons, and both lords and commons addressed their speech to him; the lords had an upper room which served them as a place of recess, for private consultation, and when they had taken their resolutions, this same were delivered to the commons by **Mr. Darcy**. This chamber forms part of a house, now *1802* inhabited by Mr. Tresham, an apothecary, it consisted of one large hall, forty-nine feet by forty-seven, with a dungeon underneath twenty feet square, with which the hall communicated by a trap-door, and stone stairs. Part of the benches with high backs, and the carved oak frame of a table remain. An iron door formerly led out of the dungeon into the yard; the windows have iron bars, and are small and arched. This hall is now subdivided into a kitchen, shop, and three or four rooms. The upper floor is low, with large beams, and above is a modern building.


The clergy, who were not qualified by their titular sees or abbies to sit in the house of lords, met in a house called the convocation, where it was reported among the laity that they only handled matters of tythe, and settling church possessions, in which points so little deference was paid to their debates, and their proceedings were treated with so much contempt by the lay-impropriators and gentlemen, that the provincial of the Augustinians was hissed out of the house for threatening to wipe off the dust from his feet and those of his friars, and to bend his course beyond seas, if the possessions of his order were not restored.


For the rule of their government, they professed to receive **Magna Charta**, and the common and statute law of **England**,



---

p.88



in all points not contrary to the Roman Catholic religion, or inconsistent with the liberty of **Ireland**. Several judicatories were established for the administration of justice, and the regulation of all affairs; each county had its council, consisting of one or two deputies out of each barony and where there was no barony, of twelve persons chosen by the county in general, with powers to decide all matters cognizable by justices of the peace, pleas of the crown, suits for debts and personal actions, and to restore possessions usurped since the war; to name all the county officers, except the high-sheriff, who was to be chosen by the supreme council out of three which the council of the county were to recommend. From these lay an appeal to the provincial councils, which consisted of two deputies out of each county, and were to meet four times a year, or oftener if there was occasion, to examine the judgments of the county councils, to decide all suits like judges of assize, to establish recent possessions, but not to meddle with other suits about lands, except in cases of dower.


From these there lay a further appeal to the supreme council of twenty-four persons, chosen by the general assembly, of which twelve were to be constantly resident in **Kilkenny**, or wherever else they should judge it to be most expedient, with equal voices, but two-thirds to conclude the rest: never fewer than nine to sit in council, and seven to concur in the same opinion; out of these twenty-four, a president was to be named by the assembly, and was to be always one of the twelve resident; and in case of death, sickness, or absence, the other residents out of the twenty-four were to chuse a president.


The council was vested with power over all generals, military officers, and civil magistrates, who were to obey their 



---

p.89



orders, and send duly an account of their actions and proceedings, to determine all matters left undecided by the general assembly, their acts to be of force until rescinded by the next assembly: to command and punish all commanders of forces, magistrates, and all others, of what rank and condition soever; to hear and judge all capital and criminal causes (except titles to lands), and to do all kind of acts for promoting the common cause of the confederacy, and the good of the kingdom, and relating to the support and management of the war.


They used a seal,[102](javascript:footNote('T100076/note102.html')) which is thus described: it had a long cross in the centre, on the right side of it was a crown, and on the left an harp, with a dove above the cross, and a flaming heart under it, and round it was this inscription
  
 

‘Pro Deo, pro Rege et Patria Hibernia unanimis.’


The conduct of the war is no part of our present concern; but we must remark, that the Franciscans, Dominicans, Carmelites, and Jesuits now claimed their ancient possessions, and were generally reinstated; for one of the principal objects of this war was, the re-establishment of those orders, and the Romish hierarchy; that this point was accomplished we learn from a letter written by the confederates in 1644 to the Pope, wherein, among other enumerations of their good fortune,[103](javascript:footNote('T100076/note103.html')) they exultingly observe, *Jam Deus optimus maximus Catholico ritu palam colitur; dum cathedrales pleræque suis antistibus; parochiales parochis; religiosorum multa coenobia propriis gaudent alumnis.’’*

**Ledwich**'s Antiquities of Ireland. 


  
C.




---

p.90


IX.
---


**Daniel O'Daly**, a Dominican friar, was (according to **Dr. Smith**) a native of **Kerry**. On his ordination he assumed the name of Dominick à Rosario, and retained it during his life. He lived for a time in the convent of **Tralee**, but was educated chiefly in **Flanders**; from whence he was invited to **Lisbon**, in the reign of **Philip IV. king of **Spain****, who then possessed **Portugal**, which was governed by the Duchess of Mantua, the king's first cousin. **O'Daly**, being a man of good address, soon became a favourite of that princess, by whose encouragement the new college, called Corpo Santo, was carried on with great success; and when finished, he was made the first rector of it. He afterwards founded a monastery for Irish Dominican nuns at **Lisbon**, called the Convent of Bon Success.


When **Portugal** had thrown off the Spanish yoke, and John, Duke of Braganza, was advanced to the throne, **O'Daly** was appointed confessor to the new queen; and was in such high esteem with the king, that he employed him in many weighty affairs during his reign. In 1655[104](javascript:footNote('T100076/note104.html')) he was sent ambassador to **Lewis XIV.** to treat of a league of affinity between the crowns of **Spain** and **France**. At **Paris** he lived at the convent of St. Honoratus, and would not depart from the rules of the order.




---

p.91


On the death of his king, November 6, 1656, he celebrated the accession of his son and heir, Alphonsus, to the throne of **Portugal**, with great solemnity, at **Paris**; gave public largesses to the people, and had splendid fireworks on the **Seine**. According to the writers of the Dominican Bibliothèque, he was recalled and died the same year, at **Paris**; but it appears from an inscription upon his monument, at **Lisbon**, that he lived until 1662. **Baronius**,[105](javascript:footNote('T100076/note105.html')) who gives him a very high character, extends his life to 1666. He refused the bishoprick of **Goa** and **Braga**, and was afterwards promoted to that of **Conimbria**, but died before the bulls were dispatched from **Rome**. He was censor of the Inquisition, Visitor-general, and Vicar-general of **Portugal**. He died on the 30th of June, 1662 (not 1666, as **Baronius** says), in the 67th year of his age, and was buried in the chapel of his convent, under a monument, on which may be read the following inscription:—
  


‘HIC JACET VENBRABILIS P. M. **Fr. DOMINICUS O'DALY**, HUJUS ET CONVENTUS MONIALIUM BONI SUCCESSUS FUNDATOR; IN VARIIS REGUM LEGATIONIBUS FOELIX, EPISCOPUS CONIMBRICENSIS ELECTUS; VIR VIRTUTE, LITERIS ET RELIGIONE CONSPICUUS. OBIIT ANNO 1662. ÆTAT. 67.’
  


He hath written ‘Initium, incrementum et exitus, familiæ Giraldinorum **Desmoniæ**, comitum palatinorum **Kyerria** in **Hyberniâ**, ac persecutionis hæreticorum descriptio, ex nonnullis fragmentis collecta, ac latinitate donata. Ulyssipone, 1655. 8vo.’


*This treatise gives a history of the families of the Earls of **Desmond**, which he brings from Troy, among the followers 
 


---

p.92



of **Æneas** into **Italy**, and in process of time into **Ireland**. He gives a short account of the actions of those Earls, but chiefly as they have a relation to the Roman cause, by skreening the emissaries of that church (particularly **Saunders**) from the just rewards of their treasons, to which he adds a relation of what he calls the persecution of the Catholics of **Ireland** under **Queen Elizabeth** and King James, which takes up half his book:’’*

Smith's Kerry. , 413, 415.




This small volume is of extreme rarity. A copy was sold in Bindley's sale for twenty guineas. Inferior copies have since been sold by Mr. Thorpe, at eight, ten, and twelve guineas.—(See his most interesting Catalogues.) C.




---

p.93


X.
--


***Lord Orrery**, in a letter to the **Duke of **Ormond****, dated at **Charleville**, the 3rd of April, 1666, takes notice that there was then but one bridge over the **Black Water**, which he says is forty miles navigable for boats. ‘The bridge is at **Mallo**, where there is a castle of good strength, if it had a little reparation, and is one of the greatest passes and thorough fares in this province, and if seized on by any enemy, would in effect divide the country into two parts.’ The repair of this castle was presented by the grand jury of the county; but the judge reserved himself from answering, till he spoke with **Lord Orrery**, the Lord President, and again deferred the affair till he spoke with the Lord Lieutenant, the law only allowing presentments for bridges, causeways, highways, &c. This was when the kingdom was threatened with an invasion from **France**.’’*

Smith's Cork. , i. 327.




The castle is now a picturesque ruin in the grounds of C. D. O. Jephson, Esq., M.P.—C.




---

p.94


XI.
---


The particulars of the exclusion of the Roman Catholic party from **Cork**, by **Lord Inchiquin**, are thus related in a rare tract entitled A plot discovered in Ireland, and prevented without the shedding of blood, London, printed by Jane Coe, 1644.
  


> 
> I know you have heard how my Lord of Inchiquin had put the Irish out of **Cork** in July last, and not without much cause, for there was a most horred, damnable, and bloody plot of conspiracie, invented and practized by the Popish Priests and blood-thirstie Jesuites, and the same of a sudden to be put in execution by the townsmen of **Cork** that were confederates with that bloody and arch-rebell the **Lord of **Muskerrie****, who had prepared an armie in his countrie, neer **Cork**, to be in readinesse at an howre's warning, after he had intelligence from the Popish Priests and others of that faction, to approach toward **Cork** with his armie of rebels, who should have been let into the towne in the night, and for that purpose they had agreed among themselves, to have such townsmen that night to be in the watch, and in the court of guard, as should be in readinesse to seaze upon the magazine, armes, ordnance, powder, and shot, at an instant when the word should have been given, and the rest of their confederates to be likewise readie to let in the rebels at the gate, and so in the dead time of the night to enter into every Englishman's house, with swords, skenes, and pistols, with full resolution 
> 
> 
> 
> ---
> 
> p.95
> 
> 
> 
> to massacre, murther and kill, man, woman, and childe, for which horrible murthers their holy fathers the priests had given to each one that did undertake this bloody designe a free pardon and dispensation, and it pleased God that, in the interim, that this execrable plot of treason was discovered, the priests, that were the chief contrivers of this most damnable plot, were taken, and at the time of their execution confest their mischievous intentions, which extended to the utter extirpation of all the English Protestants in **Mounster**, if God had not in his infinite goodnesse and mercy prevented it.
> 
> 
> For the rest of the townsmen, that had engaged themselves in this inhuman conspiracy, they were so many in number, and being at least six to one of our English, they could not so well be taken, or apprehended, without great danger and much effusion of blood on both sides. But the Governour of **Cork**, and the rest of the chief commanders, for the better prevention of so great a danger, devised a remarkable counter-plot (for the taking and apprehending the town's conspirators rather by policie than by violence), and for that purpose caused **Captain Muschamp**, Governour of the great fort without the south gate of **Cork**, to fain and counterfeit himself to be in drink, and so as it were in a merry humour, invite himself to Master Major (Mayor) his house to dinner; and accordingly he dyned there, and after the Irish fashion was kindly entertained, and diverse cups passed round of sack clarret, and **uscabaugh** in friendly manner to welcome him, and make him to be the more merrily disposed.
> 
> 
> And sitting at dinner, they discourst of diverse matters concerning the present distractions of these times, and diverse propositions were made, and every one gave their opinions 
> according to their own apprehensions; and amongst other 
> 
> 
> 
> ---
> 
> p.96
> 
> 
> 
>  
> 
> discourses, **Captain Muschamp**, seeming to be in a merry humour, did speak these or such like words.
> 
> 
> ‘Well, Master Major, if that it should please God that the parliament in **England** should have the best of it in this warre, and that the parliament ships were in the harbour of **Cork**, if you and the rest would not take the covenant to be true to the King and parliament; I protest I would, with the great ordinance in the fort, beat down all the houses in **Cork** 
> about your eares.’
> 
> 
> With that the Major and the rest of the company rose up in a great fury, and said, that he had spoken treason, and he should answer it, and so they brought him before the Governor, and repeated the words he had spoken; desiring that he might be proceeded against according to law, in such cases provided. Whereupon the Governor gave many thanks to Master Major in shewing himself so good a subject, in discovering such a treason as that was, saying it was time to look about us, when we shall have the chief officers that are put in trust with matters of such concernment, as he was, being governor of the King's fort, should speak such treasonable words, ‘and therefore. Master Major, you shall have my best assistance, and such punishment shall be inflicted upon him as marshall law will permit.’
> 
> 
> So the Major for the present departed, and a marshall court was called, and the counsell of warre met and sat upon his tryall, the businesse examined, the witnesses produced, the words were proved against him, and being found guilty, was condemned by the councell of warre for treason, had his sentence given to be hanged the next day. And at the time appoynted the shierfes, and the greatest part of the city came to see the execution, and the prisoner was brought out of the city well 
> 
> 
> 
> ---
> 
> p.97
> 
> 
> 
> garded, with a considerable company of musqueteers; and when they perceived that the chiefest and most dangerous men of the city were come out of the gates, the word was given, and the prisoner, **Captain Muschamp**, being set at liberty, did command his officers to lay hold on all the chiefest of the citizens, and carry them prisoners to the fort, whereof he was captain and governor, and as soon as they were taken, so the chiefest aldermen and others in the city were taken, and kept prisoners as hostages to secure the English as well within, as without the gates, which were at that instant shut up, and the drawbridge taken up, so that none could come in, nor go out, till all matters were pacified.
> 
> 
> And in the mean time there was a proclamation made, that if the Irish resisted the English, the souldiers should shoot them, and if any English were killed in that broyle, the chiefest of their city should be hanged over their walls; which proclamation did so terrifie the Irish, that they were all glad to be quiet, and so there was no great hurt done, which was much to be admired, that a matter of so dangerous a consequence, should be effected without any further trouble, and the projectors thereof highly to be commended in devising such a stratagem of mercy, in time of such troubles and rebellion, to prevent the shedding of guiltlesse blood.
> 
> 
> 

—C.




---

p.98


XII. (54)
---------


When **Cromwell** was at **Clonmell** (1650), **Richard Magner** *went to pay his court to him; but being represented as a very troublesome person, and one who had been very active in the rebellion, **Cromwell** sent him with a letter to Col. Phaire, the governor of **Cork**, in which was an order to execute the bearer.
  

**Magner**, who suspected foul play, had scarce left **Clonmell** when he opened the letter, read the contents, and sealing it up, instead of proceeding towards **Cork**, turned off to **Mallow**, and delivered it to the officer who commanded there, telling him **Cromwell** had ordered him to carry it to Col. Phaire. This officer had often preyed upon **Magner**'s lands, for which he was resolved to be revenged. The officer, suspecting no deceit, went with the letter, which greatly amazed the governor of **Cork**, who knew him to be an honest man, and immediately sent an express to **Cromwell** for further directions. **Cromwell** being extremely chagrined to be so served, sent orders to let the officer have his liberty, and to apprehend Magner, who took care to get out of his reach.’’*

**Smith**'s Cork. , i. 296.

—C.


---

p.99


#### XII. (59)


**Sunday's Well** is at the side of the high road, and is surrounded by a rude stone building, on a tablet in the wall of which the letters I H S mark its ancient reputation for sanctity. It is shaded over by some fine old ash trees, which render it a picturesque object.


Although savouring strongly of egotism, I cannot resist copying from a Lady's Album, to which I had contributed a sketch of **Sunday's Well**, some verses written on the opposite page by the popular ‘Father Prout’, who, unmasked, appears as one of my associates in commenting on the Tour of **M. le Gouz**.


> 1. In yonder well, there lurks a spell,
>   
> It is a fairy font;
>   
> Croker himself, poetic elf,
>   
> Might fitly write upon't.
> 2. The summer-day, of childhood gay,
>   
> Was spent beside it often;
>   
> I loved its brink—so did I think
>   
> Maginn, MacClise, and Crofton.
> 3. Of early scenes, too oft begins
>   
> The memory to grow fainter;
>   
> Not so with me—Crofton, nor thee,
>   
> ‘The Doctor’, or the Painter.
> 4. There is a trace, time can't efface,
>   
> Nor years of absence dim;
>   
> It is the thought of yon sweet spot,
>   
> Yon fountain's fairy brim.
> 

—C.




---

p.100


XIII.
-----


This ancient round tower stood in the south-west corner of the cathedral churchyard, and was much shaken by the fire from the fort during the siege of **Cork** in 1690. If, as stated by our traveller, the tower was ‘more than one hundred feet high’, and this was probably the case, it is, I am inclined to think, the **Gill Abbey Castle** which **Fitzgerald** says fell down in 1738. (See note 60, p. 30.) The entrance, as is usual in the Irish pillar-tower, appears to have been some feet from the ground. **Smith**, in his History of Cork, mentions that, in 1690, **General Scravenmore**, having passed the river and being quartered at **Gill Abbey**, ‘not far from which stood the steeple of the cathedral church which looked into the fort, detached Lieutenant Horatio Townshend who, getting two files of men to the top of this steeple, killed the governor of the fort, and did other considerable execution. To remove this party, the Irish traversed two guns against the steeple and shook it exceedingly; whereupon the men offered to go down, but the brave Townshend, with invincible courage, commanded those below to take away the ladder, and continued in that post till the fort was surrendered the next day.’ In **Ware**'s Irish Bishops, by **Harris**, published in 1739, it is stated, that ‘in the churchyard (of the cathedral) stands an old steeple, a little detached from the church, which some think was the work of the Ostmen of **Cork**, and first used by them for a watch tower.’ From a Tour through Ireland, by two English Gentlemen, published in 1748, we learn, that 



---

p.101




‘there is an intention of building a new steeple, and raising a noble portico to the west end of the (cathedral) church. But *the tower near it is a mean spiral structure, low and poorly built.*’ This was written after its fall, which, according to a manuscript account, reduced its height to ‘less than forty feet, but standing on elevated ground it seemeth somewhat taller.’


**Dr. Smith**, in his History of Cork, published in 1750, merely observes, that ‘some years ago an ancient round tower stood in the churchyard, a little detached from the church.’


It is like a dream to me, having had the foundation of this round tower (all trace of which is now completely gone) pointed out to me, about the year 1808.—C.




---

p.102


XIV.
----


The steeple and church of St. Finbar were built, or rather rebuilt in the course of the years 1750–60, from the proceeds of a tax of one shilling per ton on all coals imported into **Cork** from **England**. It is singular that this tax (which continues to the present day, and is appopriated to that sort of establishment which in modern political economy can find but little countenance,—foundling hospital) was justified in the Irish House of Commons as a protection to native industry in promoting the cutting of turf in the peat bogs!—M.


I have made many inquiries after the stone bearing the sainted imprint of St. Finbar's foot, but without success for nearly the last thirty years, until this summer [1836] when I was told by an old crone, who I found praying beside a grave in the churchyard of the Cathedral that such a stone had been there ‘beyond all doubt in the ould times, before Orange William came, and that then it changed into the mark of the devil's hoof.’


‘But the mark of the foot or hoof, is in the stone?’ said I, eager for information.


‘Oh without any kind of doubt in life, your honour; and why wouldn't it be there? sure you can see it with your own two sweet looking eyes, and seeing they say is believing, if ye'll go and look at the third grave-stone there, fornenting ye.’


I did so, but saw nothing more than a plain slab-stone elevated upon some brick-work, with a short inscription importing that some one or other, whose name I do not now remember, 



---

p.103




was buried beneath about sixty ox seventy years before; but I perceived no trace of hoof or foot.


‘Harkee, old woman,’ I cried, ‘where is this hoof?’


‘And sure yourself is stan'ing on it,’ she replied; ‘the Virgin herself preserve us from all harm this blessed day, if tisn't come may be to set the other foot there, beside it ye are, for company!’


I jumped down from the grave-stone, and certainly saw a singular fossil remain in the piece of limestone on which I had been standing, not unlike the mark of a cloven foot.


Stones with hollows in them, said to be impressed by the feet and knees of saints, giants, and other famous personages in **Ireland**, are by no means of rare occurrence, and are treated 
by the superstitious peasantry with extraordinary respect. There is a representation of one of these capsular stones (I think called St. Columb's) in the account of Londonderry printed to accompany the Ordnance Survey. In the county of **Tipperary**, about a mile from **Cahir** on the Ardfinnan road, a similar stone with two circular hollows in it, called Clough a Padrigh (Patrick's stone) is an object of much veneration; and at the distance of a mile from **Rahil** towards **Cahir**, a pentacapsular stone occurs, which is termed Clough a vir a vaugher (the stone of the mother of the man), and the marks in which are said to have been produced by the knees, breasts, and head of the Virgin. At **Caher-barrule** in the wild district of **Muskerry** in the county of **Cork**, (a district singularly rich in pillar stones inscribed with Ogham characters,) there is a stone with two hollows in it, at the foot of an upright one, on which is rudely sculptured a cross surrounded by a circle. In the county of **Kerry** also, the stone with two circular hollows in it, known as Clough na Cuddy (Cuthbert's stone) is pointed 



---

p.104



out to the notice of all visitors of **Killarney**, in the demesne of **Lord Kenmare**, with the history of a pious friar's miraculous nap, by whose knees, while at prayer, the indentures were produced. And in the same region of enchantment may be found what are said to be the foot-marks impressed upon the solid rock, in a spot distinguished as ‘Coleman's leap.’


In the classical county of **Kerry**, indeed, these wonderful remains appear to be very abundant. **Dr. Smith** tells us of a rock, ‘situated about five miles from the head of the river **Kenmare**, near a small brook amidst the mountains. On this rock are the impressions of several human feet, some naked, and others with brogues on, and these are of all sizes, from infancy to manhood. The country people imagine the work to be entirely supernatural, and to have been performed by fairies, whose existence the common people of these parts, as well as of most rude countries, firmly believe; but as there is nothing more common than for several kinds of clay to become petrified in time; if it be allowed that this rock might have been once in a soft state the wonder will entirely cease.’ **Smith** adds: ‘In the same manner may be accounted for, such a print of a human foot given us by **D. Behrens** in his natural history of **Hartz Forest**, near the river **Selke**, and that of a horse shoe in a solid rock near the village of **Thal**, both which he takes to be a **lusus naturæ**; although, says he, the inhabitants tell a strange story about the former of a shepherd and a country wench, pretending this footstep was made by a leap the young woman took, to escape from the hands of her troublesome gallant.’


From the popular veneration exhibited towards capsular stones in **Ireland**, I cannot help fancying that such objects must have had, at some remote period, a religious appropriation.



---

p.105



Perhaps they were the rude fonts at which, in the early ages of Christianity, the ceremony of baptism was performed; or like those circles of ponderous stones, and mysteriously balanced rocks, we see in them relics of the gloomy pagan faith which the cheering light of the Gospel has dispelled; for pagan idolatry may still be traced in many Irish superstitions.—C.




---

p.106


XV.
---


Through the kindness of my friend **Mr. James Roche**, I had an opportunity of examining this venerated relic, and I am indebted to **Miss Roche** for a drawing of it. It is a carving of the virgin and child in ivory, scarcely three inches high, now considerably worn by friction, and discoloured from age. A piece of glass, however, at present secures it from further injury, and it is inclosed in an antique silver case, (which has been gilt,) bearing the following inscription: ‘ORATE PRO ANIMA ONORIAE FILIÆ JACOBI DE GERALDINIS QAE ME FIERI FECIT.’ [1617.] The lady by whom this silver shrine for the image of the Virgin was presented to the Dominicans appears therefore to have been, not a Countess of Desmond, as hastily conjectured by **Mr. Roche**, but **Honora the daughter of Sir James of Desmond**, who was killed in 1597 by the sons of **SirWilliam Bourke**, and whose body was hung up at **Kilmallock**. This lady was married to her relative, John Fitz Gerald, Seneschal of Imokilly, and after his death to Sir Edmond, son and heir of Sir John Fitzgerald of Cloyne and Ballymaloe.—C.




---

p.107


XVI.
----


The assertion of our traveller that the Irish is not a written language, appears founded on his having seen a monk who had been probably educated abroad write it in English characters, which however **M. le Gouz** candidly admits he could not understand. So might any one write Greek, which an Englishman ignorant of the language would have the same difficulty in comprehending.


That the Irish is a written language of considerable antiquity no scholar can for a moment doubt, although he may hesitate about the identity of the Phoenician and the Iberno Celtic. It is judiciously observed by **Mr. Anderson** in a little volume entitled Historical Sketches of the Ancient Native Ireland— a work small in size but rich in information relative to the literature, education, and oral instruction of the Irish peasantry, that ‘with regard to the native Irish, such has been the singular fate of their manuscripts,[106](javascript:footNote('T100076/note106.html')) and even such is their present condition, that difficulties almost insuperable present themselves at the threshold of enquiry. Many of these unquestionably perished in the Danish invasions of the ninth and tenth centuries, and that singular species of policy which obtained for centuries after the Anglo-Norman invasion, must account for the loss of many others. Collections of others are, 



---

p.108



it is true, happily still in existence; but whether those of the greatest value are to be found in this kingdom, or on the continent, it is impossible for any one to affirm. The probability is that they are abroad.’


‘I am aware,’ continues **Mr. Anderson**, ‘of the valuable collection in Trinity College, **Dublin**, of that in the Bodleian Library, and the Cottonian manuscripts, as well as the treasure contained in the Chandos collection at Stowe, part of which, in four volumes quarto, with a Latin translation, has been recently printed at the charge of the proprietor, his Grace the Duke of Buckingham.’


Besides these there are various manuscripts in the possession of Irish gentlemen, members of the Iberno-Celtic Society and others, some of which are of considerable antiquity. Of the more modern compositions of the two last centuries, the titular Bishop of Cork *Dr. Murphy* has at least ten thousand pages transcribed. Were, however, the more ancient Irish manuscripts now in the King's library at Copenhagen, or the still larger collection in the Royal Library at Paris examined; were the Spanish manuscripts decyphered, or the stores which are believed to be deposited in the Vatican; it is almost certain that the claims of the Irish to a very early cultivation of letters would be set at rest, and admitted by all.


Ancient records, the very decyphering of which was strangely regarded in former times, as tending to endanger the tranquillity of the kingdom, were not likely to remain long in it, and hence we fully account for the foreign collections; but that, under the influence of the same fear, the laudable and natural desire of translating any part of these by a foreign power, should not have been met and gratified, proves the extent to 



---

p.109



which the dread of Irish composition had gone.[107](javascript:footNote('T100076/note107.html')) At such a period prejudice would consign to oblivion whatever came within its power. Indeed, until the reign of James I. if not later, it seems to have been an object to discover every literary remain of the Old Irish with a view to its being either destroyed or concealed.[108](javascript:footNote('T100076/note108.html'))


At the same time, no individual can even at present distinctly inform us, whether what we have in our possession be of real value or not, or whether these manuscripts are not nearly the only remaining source from which light may be thrown on the ancient history of **Ireland**, and perhaps discover to us some of their ideas respecting other countries as well as their own. The stores even in **Dublin** have never been impartially and thoroughly canvassed, nor does even a complete Catalogue Raisonnée of the collection in Trinity College exist.


I may repeat it, therefore, that the actual state of Irish manuscripts, for these last two hundred years, is one of the most striking illustrations of the power of prejudice as to one branch of our national history to which any historian can point. In the most ancient and curious, which, I presume, must be abroad, historical narration there must be, of whatever value; assertions also, many, in which the writer had no 



---

p.110



motive to falsify, though in various instances he might prove to be mistaken. But what is the amount of information in these numerous written compositions, no man can tell. We have been printing, very properly, ancient and modern Greek in parallel columns; Turkish for the Turk, and struggling hard to decypher the hieroglyphics of Egypt, but the records of one branch of the British population are still to be explored. Of the manuscripts said to be in **Spain**, no one informs us whether they are in the **Escurial**, or at **Salamanca**, **Alcala**, or elsewhere. Of the King's Library at **Copenhagen**, as there has never yet been a printed catalogue, nor the written one completed, what those manuscripts were, which a former Monarch wished to have translated, we are yet to be told. In Paris, by a few these manuscripts may be known to exist. In the **Vatican** they have slumbered since, and from before the days of **Wadding**. Fragments have been translated from a few at home, and if all the rest are of no higher value, we should have the less reason to regret their neglect; but chance specimens from a body of written composition are not like the specimens of most other things.


In our present state there is no judicious man who would hazard more than conjecture, and perhaps add,—before you decide, examine at least, what seem to be the most valuable, and are most valued in different libraries; and before you return your verdict, forget not the relative character of other nations. At present we are prepossessed with unexamined opinions; and the positive assertions of national prejudice, whether for or against the antiquity or value of Irish writing have yet to be met by a positive and candid examination of the writing itself. At all events, there is one evil which has hitherto ‘pursued the antiquities of **Ireland**, 



---

p.111



that the writers in general, who have known her language, have been deficient in critical knowledge; while those who possessed the genuine spirit of criticism have not only been ignorant of her ancient tongue, but despised it.’—C.




---

p.112


XVII.
-----


At the time when **Solinus** wrote, **Ireland**, which was then very little known, had the reputation of being free from snakes—*Illic nullus anguis, avis rara, gens inhospita et bellicosa.’’*

(*Polyhistor,* c. xxii.)

 How such a reputation arose, it is not easy to say: perhaps it might be founded in the superstitious sanctity with which the ancients always clothed the extreme boundaries of the west. In the time of **Bede**, the older simple story was already clothed in legendary array, and that historian asserts that it was not only free from such animals, but that no snake could live there, and that when any such reptiles had been carried over, they died invariably on approaching the shore. He asserts moreover that anything brought from **Ireland** is a sovereign remedy against the bite of all venomous animals, and tells us how in **England** they used for that purpose water, in which had been steeped the scrapings of the leaves of books, which had been brought over from the sister isle. After **Bede**'s time, this fable became one of the most popular that prevailed during the middle ages. **Giraldus** tells us that not only snakes, but toads, and all other venomous reptiles were unable to live in **Ireland**, that more than once such animals had been carried over in boxes and had died immediately after passing the middle of the channel, that wood or leather, or any other Irish commodity steeped in water afforded a remedy not only against the bite of venomous animals, but against poison, and that a little Irish earth sprinkled even on English 



---

p.113



ground immediately drove away all such creatures from the neighbourhood. **Giraldus** gives it as the general belief of his contemporaries that **Ireland** was originally purged of venomous animals by the hand of **St. Patrick**, though he does not disguise his own scepticism on this point. However, we find this rehearsed amongst the miracles of the saint, by his biographer **Jocelin**. From his book (ch. clxix. clxx.) we learn that, before the time of **St. Patrick**, **Ireland** suffered under three insupportable plagues, which rendered the green island quite uninhabitable. First, it was overrun with every species of venomous reptiles; secondly, it was haunted by innumerable sorts of devils and hobgoblins; and, thirdly, the space which was not occupied by those two classes, was peopled by wizards and witches. Against the first of these plagues, **St. Patrick** proceeded somewhat after the manner of the fox, who drives the fleas which haunt him to the end of his tail, and then shakes them all off into the pool. So the saint gathered together all the venomous animals from every corner of the island to the top of a lofty promontory, looking down into the sea, which had previously been named **Cruachan-ailge**, but was afterwards called **Cruach-phadruig**; and from thence, at one blow, he swept them all into the deep. The hobgoblins he drove away by the sign of the cross, the wizards and witches he converted, and **Ireland** was every where after inhabited by christian people.
A history of the 13th century, that of the adventures of **Fulke Fitz-Warine**, makes us acquainted with the spot where the venomous animals, pursued so bitterly by the saint, at last took shelter. **Fulke**, says the story, sailed so long, seeking marvels and adventures, till he had visited the seven islands of the ocean, which are, **Little Britain**, **Ireland**, **Gothland**,



---

p.114


**Norway**, **Denmark**, **Orkany**, and the great ‘Eschavye.’ In Eschavye there dwelleth none but serpents and other foul beasts. And there saw Fulk serpents with horns; and the horns were very sharp; and they have four feet, and fly like birds. One of these serpents assailed Fulk, and struck him with his horn, which transfixed his shield in the middle. Fulk wondered much at the blow, and he was well aware that when the serpent had struck him on the shield, he could not readily withdraw his horn; and Fulk stabbed him through the heart with his sword. There saw Fulk a venomous beast, which had the head of a mastiff, a thick beard like a goat, and ears like a hare; and many other beasts which **St. Patrick** drove out of **Ireland**, and imprisoned them there by the virtue of God; for the good man **St. Patrick** was in high credit with him. And thenceforth no venomous beast inhabits the land of **Ireland**, except lizards without tails—MS. Reg. 12. c. xii. in the British Museum.—W.


**Rothe**, titular bishop of Ossory, in his elucidations observes respecting Jocelin's Life of St Patrick, that ‘it has been delivered to us by our ancestors, that **St. Patrick** possessed the power of expelling serpents; and this was the universal opinion, not only of the people, but of the wisest and most discreet men of our nation, that by the virtue and power of him, our island, was freed from all fenomous creatures. Thus do the Hymns, the Antiphones, and the offices sufficiently prove, the national annals record, the Latin writers declare. In this do foreigners and natives concur; in this do the moderns, one perchance or two excepted, confirm the testimony of the ancients. In this manner do the Greek writers Theodoretus and Euthymius understand the 90th Psalm, of the actual subjection of serpents and wild beasts, which therein is 



---

p.115



promised unto the saints confiding in the Lord; ‘Thou shalt tread upon the lion and the adder, the young lion and the dragon shalt thou trample under thy feet!’’


‘Certainly in those histories of the saints which are composed by classic and authentic writers, many are the relations of this subjection of serpents, and of wild beasts, as exhibited in many holy men; but most eminent and rare is the example which we read in the Acts of the Apostles of the viper that fastened on the hand of St. Paul while he collected twigs for the fire. And to this **Tertullian**, attending and discussing the power given from Christ, of treading on serpents and scorpions, haply insinuateth to us the prerogative communicated unto Paul, that the soil of **Malta** should through his merits be an antidote against all poisons, and that all venomous creatures when thither brought should forthwith lose their power of doing hurt. And very similar hereunto is the prerogative bestowed on **Ireland** through the merits of **St. Patrick**; with this difference, that while in **Malta**, serpents, scorpions, snakes, adders, and other venomous reptiles, retain their life and their motion, and lose only their poisonous power; in **Ireland** they can neither hurt nor exist, inasmuch as not only the soil, but the climate, and the atmosphere unto them are instant death. The spider is found among us, yet it is entirely harmless; the frog is sometimes, but rarely met; (and its extirpation is not remote), and a lizard of many feet and many colours, but in which is not any poison!’


‘The most peculiar and eminent among these wonders,’ says **Mr. Edmund L. Swift**, in observations on Jocelin's Life of St. Patrick, ‘is the exemption of **Ireland** from serpents by the merits of **St. Patrick**;—while geologists, instead of ascribing it to the influence of the saint, impute this happy 



---

p.116



privilege to natural causes, a little poetical and legendary amplification may perhaps account for his share in its real blessing. From the earliest time the Evil Spirit has been symbolized under the form of a serpent. By a serpent were the temptation of Eve, and the fall of man accomplished. Into serpents were the rods of the Magicians changed; and as a serpent did the rod of Aaron swallow them up. Under this form did the idolators of many ages and many nations worship ‘The Mischievous Power’ propitiate his protection or deprecate his enmity. Even to this day, as I am credibly informed, a brazen serpent (like that which was lifted up in the wilderness) has been preserved in the northern parts of **Ireland**, and handed down in one family through a series of ages. Their tradition records it as one of the original objects of the idolatrous worship in this island. It is curiously inscribed with Hieroglyphics, now unintelligible, but which doubtless once excited the fear or the devotion of the Pagan Irish; and though it has long ceased to be worshipped, it is still the object of their Christian superstition. Should any of the neighbourhood be suspected of theft, they are required to attest their innocence on this brazen serpent, on which alone can their purgation be obtained; and so long has this relic of ancient idolatry preserved its influence, that even now would no one dare to violate the still sacred oath.’


‘May I now venture the application? **St. Patrick** expelled the serpents from **Ireland**, and drove them before him into the sea. So says the legend; which divested of its allegory, and restored to the simple truth, tells that—St. Patrick's conversion of **Ireland**, and his extirpation of her serpents, are one and the same act; his introduction, or rather confirmation, of Christianity, and his expulsion from the 



---

p.117



island of the Ophi-Sebia, or serpent-worship, which fled before his preaching. Thus may the imagination, the enthusiasm, and the devotion of our ancestors, which amplified a natural blessing into a spiritual miracle, be rationally explained. Thus, while we resign the legendary laurel from the brows of our saint, we secure to him a more permanent and honourable wreath; and thus, while we ascertain the truth of his existence, we confirm him in his well-deserved dignity—the legitimate apostle of **Ireland**.’


**Dr. Maginn**, in a facetious catalogue of the miracles of **Ireland**'s patron saint, thus accounts for the national dislike of Irishmen ‘to make beasts of themselves’ by drinking water—


> 1. You've heard, I suppose, long ago
>   
> How the snakes in a manner most antic
>   
> He march'd to the County Mayo
>   
> And trundl'd them into th' Atlantic.
>   
> Hence not to use water for drink
>   
> The people of **Ireland** determine;
>   
> With mighty good reason, I think,
>   
> Since St. Patrick has filled it with vermin,
>   
> And vipers and such other stuff.
> 

—C.




---

p.118


XVIII.
------


**Lord Inchiquin** succeeded to his title during his minority, and 19th July, 1628, was granted in ward to **Patrick Fitzmaurice, Esq.** By indenture dated 5th February, 1632, the King demised, during **Lord Inchiquin**'s minority, his estate, which was very large in the Counties of **Limerick** and **Clare**, to **Sir William St. Leger**, whose daughter **Lord Inchiquin** subsequently married. To study war he went into **Italy**, and served in the Spanish army until 1639, when he returned to **Ireland**. On the 2d April, 1640, he was constituted Vice-President of **Munster** under **Sir William St. Leger**, whom he accompanied on the 4th of December, 1641, against the Irish insurgents in the County of **Waterford**. In the early part of the following year he performed various services in the field against the Irish; and on the death of **Sir William St. Leger**, the Lords Justices conferred on him the entire military command of **Munster**, joining the **Earl of Barrymore** in commission with him for the civil government, upon whose death in a few months after, he became solely vested with the civil command.


On the 2nd September, 1642, **Lord Inchiquin**, with a very inferior force, defeated the Irish army under **Lord Mountgarret**, at **Liscarrol**, in the County of **Cork**, with considerable slaughter.




---

p.119


After the cessation with the confederate Irish of the 15th September, 1643, **Lord Inchiquin** sent to the King before the middle of October, two regiments to **Bristol**, and two more in November, which were followed by a fifth in December. Waiting on the King at **Oxford**, his Lordship did not question but that his merits and services would have procured him a grant of the Presidency of **Munster**, for which he was also recommended by **Lord Ormond**, who represented that the investing of him therewith would be much for the advantage of the King's service in those parts. But by an intrigue of the **Earl of **Portland****, who was desirous of obtaining the office, **Lord Inchiquin** was unsuccessful. Feeling that suspicions were entertained of his fidelity, and hearing that **Lord Portland** was coming to take possession of his command, **Lord Inchiquin** resolved not to serve under his rival, nor indeed under any man but the **Marquis of **Ormond****; and unwilling at so critical a period, and from a distinguished station to be reduced to a private and inconsiderable condition, he determined to maintain his power; to break the cessation, and to carry on the war under the direction of the English Parliament.


This is the account given by **Lord Clarendon**; but **Lord Inchiquin** assigned another reason for this his defection, which was the manifest partiality of the King's party to the Irish, particularly at the treaty with their commissioners at **Oxford**, concerning a peace, the ruinous measures they evidently strove to take for their own exaltation, and the destruction of the Protestant party.


**Lord Inchiquin** now became devoted to the English Parliament, and openly declared his resolution on the 17th July, 1644; strongly remonstrating against the cessation. Being joined by **Lord Broghill**, they had under their command a considerable



---

p.120



body of men, and asserting that the Irish had applied to foreign princes for supplies, that they would not make peace on reasonable terms, and intended to surprise all the English garrisons, they drove the Roman Catholic magistrates and inhabitants out of **Cork**, *See page 28, and note XI.*. **Youghall** and **Kinsale**, allowing them to take only such goods as they could carry, and seized their provisions and other effects. This revolt occasioned some severe expostulations 
between **Lord Inchiquin** and the **Marquis of **Ormond****; but to no effect, as **Lord Inchiquin** was determined not to hazard himself or his friends, by re-admitting the excluded inhabitants. For this conduct the Parliament constituted **Inchiquin Lord President of **Munster****, but without sending him supplies, which obliged his lordship to make a temporary cessation with the Irish until the following spring, when **Lord Castlehaven** renewed the war. Notwithstanding that **Lord Inchiquin** had received no support from **England**, he was obliged to take the field with 1000 horse and 1500 foot, in April, 1645; but his operations were confined to the capture of a few castles between **Cork** and **Youghall**, and putting that district under contribution. In 1647 **Lord Inchiquin**, with an increased force, reduced two or three places of strength upon the river **Blackwater**, and after investing **Dungarvan**, that town was surrendered to him on the 10th of May. Want of provisions obliged **Lord Inchiquin** to return to **Cork**; but being reinforced by the Parliament, he proceeded into the County of **Tipperary** in the September following. **Caher** surrendered to him; but **Fethard** and the **Rock of Cashel** his Lordship took by storm, at which latter place he is accused of having given no quarter. ‘So that,’ says **Lord Castlehaven**, ‘within and without the church, there was a 



---

p.121



great massacre, and amongst others more than twenty Priests and religious men were killed;’ among them possibly the Salamanca Students, whom **M. le Gouz** had lectured. *See p. 17.* Unpopular, however, as **Lord Inchiquin** appears to have been in 1644, when he was stiled ‘the pest of his country,’ this act causes his name to be execrated at the present hour in **Ireland**, and appears indelibly impressed on the memory of the Irish peasantry of **Munster**.


On the 13th of November, in the same year [1647], **Inchiquin** obtained an important and decisive victory over the Irish army, commanded by **Lord Taaffe**, at **Knocknenoss**, to the west of **Mallow**, in which more than one-third of the Irish engaged are reported to have been left dead on the field. In this battle fell **Sir Alexander M'Donnell** (Kolkitto), or Mac Allisdrum as he is popularly called in **Ireland**, who, it is said with ‘most of his men, were put to the sword in cold blood; an action which in a great measure tarnished the glory of so complete a victory.’ For this service the Parliament voted 10,000 *l.* to be sent to **Munster**, and a letter of thanks to **Lord Inchiquin** with a present of 1,000 *l.* to his Lordship.


Immediately after this battle, and the delivery of **Dublin** to the commissioners of the Parliament by the **Marquis of **Ormond****, **Lord Inchiquin** perceiving that the monarchy and constitution of **England** were about to be overturned, regretted his having attached himself to the destructive party, and commenced a correspondence with **Ormond** whilst he continued in **England**. In January, 1647–8, **Lord Inchiquin** sent a remonstrance to Parliament, and in the following month made a successful expedition into the Counties of **Waterford** and **Kilkenny**.


‘But his design of promoting the King's service being suspected



---

p.122



by some of his officers, they formed a plot to seize **Cork** and **Youghall**, whilst his lordship was abroad with the army; which conspiracy (though discovered and prevented, and the chief contrivers seized and imprisoned by order of a council of war, and all the officers sworn to stand by him, and be true to one another) discovered his designs too early, and caused the Parliament by their ships, to block up the harbours of **Cork**, **Youghall** and **Kinsale**; of which event he sent immediate notice to the **Marquis of **Ormond****, earnestly pressing his return with a supply of money, if he could, if not, without it, as his presence was absolutely necessary, and would make the King master of the provinces of **Leinster** and **Munster**.’


‘The Marquis being disabled to comply with his request, and soon after flying into **France**, his lordship held a close correspondence with him, and frankly promised to receive him into **Munster** as the King's Lord Lieutenant; that the province and the army should pay him all obedience; and in order to his reception, he would make a cessation with the Irish to bring about a firm conjunction of the whole kingdom to the King. But before the Marquis could arrive to embrace this generous proposal (being detained by the specious promises of **Cardinal Mazarin**), **Cromwell** had got **Philip, Lord Lisle**, son of **Robert, Earl of **Leicester****, to be sent into **Ireland** Lord Lieutenant, with a commission for a limited time; who landed in **Munster** with an intent to destroy the **Lord Inchiquin**'s reputation and command there; but his commission terminating 13th April, 1648, before he could effect it, he left his lordship in the command of the whole English army there, which was a better body of men than the Parliament



---

p.123



had in any other part of the kingdom, and in greater reputation than ever; which army he had preserved with wonderful dexterity, expecting every day the arrival of the Marquis, and every day informing the Parliament of the ill condition he was in, and pressing for a supply of men and money, when he knew they would send neither.’


‘At last the Marquis arrived, and landing at **Cork**, 29th September, 1648, his lordship received him as the King's Lieutenant (having as proposed concluded, May 22, a cessation with the Irish), whereby he became possessed of the whole province of **Munster**. For which signal service, **Lord Inchiquin** (14th April, 1649) was voted a traitor by the Parliament; but by the King's letter from **the Hague**, was appointed President of **Munster**.’


In the June following **Lord Inchiquin**, after a short skirmish with **Colonel Chidley Coote**, in which his lordship exhibited considerable military skill, took **Drogheda**; nearly the whole of the garrison of which town joined **Lord Inchiquin**, and took service in the royal army. He then invested **Dundalk**, which in two days **Colonel Monk (afterwards Duke of Albemarle)** was forced by his soldiers to deliver up; ‘and most of the officers and soldiers engaging in the King's service, he soon took in the garrison of **Newry**, **Narrow-water**, **Greencastle**, **Carlingford**, and **Trim**; and having thus reduced the northern garrisons, returned to the royal camp at **Finglas** with more men than he carried out.’


‘But in the latter end of the year, his forces, seduced by **Cromwell**'s spies, revolted; whereby, finding himself exposed to his enemies, and his life in danger, he embarked 6th December, 1650, with **Lord Ormond**, landed at **Perose**, in 



---

p.124


**Basse-Bretagne**, in **France**; and an act being passed by **Cromwell**'s Parliament, 12th August, 1652, for settling the affairs of **Ireland**, his lordship (among others) was excepted from pardon. From **Basse-Bretagne** he went to **Italy**, and returning to **France**, was made by the French King Lieutenant-General of his army; upon the conquest of **Catalonia** appointed Viceroy thereof; and by patent, bearing date at **Cologne**, 21st October, 1654, his Majesty King Charles II. was pleased to advance him to the dignity of an Earl of the Kingdom of **Ireland**, remainder to his issue male by the title of Earl of Inchiquin, with the creation fee of 20 *l.* a-year, payable out of the Exchequer of **Ireland**.’


‘After this he served in **Spain** and the **Netherlands**, and being ordered to command the troops sent to assist the Portuguese, on their revolt from **Spain**, he, with his eldest son and all his family, were taken by an Algerine corsair, which occasioned the sending of **Count Schomberg** on that service, who extricated his Portuguese Majesty from many troubles. Having ransomed himself and family, he retired into **France**, and surviving his own private troubles and the confusion of the public, lived to see the restoration of the King, with whom he returned to **England**, was restored to his estate by a British act of parliament, which was confirmed by the act of settlement; and in the act of explanation the sum of 8,000 *l.* was ordered to be paid him out of the Treasury, as a mark of his Majesty's favourable and gracious consideration for his losses and sufferings.’


**Lord Inchiquin** had also a discharge of the quit rents imposed by the acts of settlement, and his arrears as a commissioned officer before 5th June, 1649, stated after the rate of 



---

p.125



10*l.* a-day, as Captain-General and Commander-in-Chief of the army in **Munster**, were directed to be satisfied by debentures.


**Lord Inchiquin** died on the 9th September, 1674, and was buried in the Cathedral Church of **Limerick**. It is to be regretted that a complete account of the life of a nobleman so intimately connected with the historical and political events of a most important period of English history has not been written.


‘On whatever side **Inchiquin** commanded,’ says **O'Driscol** in his History of Ireland, ‘he was the scourge of his country. Of one of the noblest and most ancient Irish families, he seemed actuated by a thirst for the blood of his countrymen, hardly to be satiated; wherever he marched, the burnt crops, the ruined cottages of the peasants, the dead and mangled bodies of age and infancy strown upon the way, pointed out the route of the **Lord Inchiquin**.’


‘On taking **Cashel**, he massacred the priests at their altars, and put to death several hundred of the inhabitants; he committed similar deeds of barbarity in other towns. The memory of his murders is still engraven upon the heart of the country, and his name will remain for ever united with that of **Grey** and **Coote** and **Cromwell**, a curse and an anathema in **Ireland**. The peasants of **Clare** and **Limerick** still scare their children with the name of the bloody **Morrough O'Brien**, and tell of the judgment that has descended upon his posterity, that no male child should ever be born to the name of Inchiquin.’


Now, my poor friend **John O'Driscol**, ought not to have repeated this absurd story, (although current among the peasantry



---

p.126



of **Ireland**,) in a political sketch, which professes to be a history of **Ireland**, as it is a matter of notoriety that the Earl of Inchiquin was succeeded in the title by his eldest son William, who died in 1691, Governor of Jamaica; that he was again succeeded by his eldest son, William, who died in 1719; and was succeeded by his eldest son, Willliam, on whose death, in 1777, the title of Inchiquin devolved upon his nephew Morrough—C.




---

p.127


XIX
---


The following account of the Quern, or hand-mill, appeared in the fourth volume of the Dublin Penny Journal[109](javascript:footNote('T100076/note109.html')), (an extremely curious and interesting miscellany, which, for there is a fatality attends every thing Irish, has been recently discontinued). It is there illustrated by prints, showing the appearance of this rude contrivance for grinding corn, and by a section exhibiting its operation. Specimens of the Quern are now very rarely to be met with in **Ireland**, and when found are generally in a mutilated state.


> 
> ‘Passing through a bog in the neighbourhood of Armagh, my attention was attracted by obserying a number of men examining something on one of the banks. On approaching, I found that they had discovered at the bottom of a mud-hole, two circular stones, which I immediately knew to be an ancient Irish hand-mill, commonly called a quern.’
> 
> 
> ‘That this primitive mill was in general use in this island, is evident from the number of perfect and broken portions of it so frequently found in bogs, and in the neighbourhood of ancient raths. That it was in general use over Europe, Asia, and Africa, has been satisfactorily proved by various ancient and modern travellers; but, in particular, by **Dr. Clarke**. When he visited the Greek island of **Cyprus**, he saw, in the house of his guide's father, a quern, which he thus describes:—’
> 
> 
> ‘I observed upon the ground the sort of stones used in grinding corn, called querns in **Scotland**, common also to **Lapland**,
> 
> 
> 
> ---
> 
> p.128
> 
> 
> 
>  
> 
> and in all parts of **Palestine**. These are the primeval mills of the world, and they are still found in all corn countries, where rude and ancient customs have not been liable to those changes introduced by refinement. The employment of grinding with these mills is confined solely to females; and the practice illustrates the observation of our Saviour, alluding to this custom in his prediction concerning the day of judgment, ‘two women shall be grinding at the mill; the one shall be taken, and the other left.’’
> 
> 
> ‘When he visited **Palestine**, he stopped at a village near **Jerusalem**, and saw the quern at work.’ ‘Looking from the window into the court-yard belonging to the house, we beheld two women grinding at the mill in a manner most forcibly illustrating the saying of our Saviour before alluded to. They were preparing flour to make our bread, as it is always customary in the country when strangers arrive. The two women seated on the ground, opposite to each other, held between them two round flat stones, such as are called querns.’
> 
> 
> ‘In the centre of the upper stone was a cavity for pouring in the corn, and by the side of this an upright wooden handle for moving the stone. As the operation began, one of the women with the right hand pushed the handle to the woman opposite, who again sent it to her companion, thus communicating a rotatory and very rapid motion to the upper stone, their left hands being all the while employed in supplying fresh com, as fast as the bran and flour escaped from the sides of the machine.’
> 
> 
> In the **Hebrides**, the quern was in use at a very recent period. **Pennant**, in his account of his voyage there[110](javascript:footNote('T100076/note110.html')) has described the manner in which they are used by the inhabitants. He says, ‘This method is very tedious, for it employs two 
> 
> 
> 
> ---
> 
> p.129
> 
> 
> 
>  
> 
> pair of hands four hours to grind a single bushel of corn. The landlord can oblige his tenants, as in England, to make use of the more expeditious method of grinding by water-mills, and empowers his miller to search out and break any querns he can find, as machines that defraud him of his toll. Many centuries ago, the legislature of **Scotland** endeavoured to discourage these awkward mills, so prejudicial to the landlord who had been at the expense of others. In 1284, in the time of Alexander III, it was provided, that ‘Na man sall presume to grind quheit, maishlock, or rye, in hand-mylne, except he be compelled by storme, or be in lack of mills quhilk soulde grinde the samen; and in this case, gif a man grindes at hand mylnes, he sall gif the threllein measure as milture; gif any man contraveins this our proclamation, he sall tyne his mill perpetuallie.’’
> 
> 
> ‘In many districts in **Ireland**, the quern was in use until very lately, and perhaps it is still in operation in some remote parts of the country. Being ignorant of the manner it was used in our own country, I applied to a friend who had an opportunity of knowing, and I subjoin his statement, which gives a minute description of the mill and manner of grinding, differing very little from the description given by Clarke of the oriental one.’ ‘A prohibition against the use of querns in grinding com, existed to a more recent date than you may imagine. I think it was in the year 1794, Mr. Wm. Acheson, of **Roscagh**, who was then proprietor of Kesh mill, in the county of **Fermanagh**, gave orders to his miller, Stephen Belford, to break all the querns he could find. The only pair I then remember in the neighbourhood, belonged to one Patrick M'Manus of **Rosculbin**, and had been made about forty years before by his uncle, Bryan M'Manus, a cooper, known in the 
> 
> 
> 
> ---
> 
> p.130
> 
> 
> 
>  
> vicinage by the name of Bryan Beg (little Bryan); and when any neighbour would borrow the quern, it was as carefully concealed from Stephen Belford, as an illicit still would now be hidden from an exciseman.’
> 
> 
> ‘The quern was tolerably adapted for grinding corn. The upper stone was about twenty-two inches in diameter, the under surface considerably concaved; the under stone was about an inch narrower, and convexed, so that the two surfaces might coincide, and afford an easy descent for the meal when ground. In the centre of the upper stone was a circular hole, nearly three inches in diameter; across this stone was set a bar of wood, having a hole in its centre about half an inch deep and the same in width, by means of which the upper stone rested in equilibrio upon the punthan (a strong peg, or pivot in the centre of the lower stone), and by the use of little pieces of leather, fitted into the hole in the bar above mentioned, the upper stone could be raised or depressed, so as to make the friction greater or less, as the meal was meant to be coarser or finer. There was also an upright handle about ten inches long set firmly in the upper stone, within about two inches of the edge; and thus was the whole machine fitted for work. The corn was generally dried in an iron pot, over a slow fire, and kept constantly stirred to prevent its burning, and when it arrived at a certain degree of crispness, it was taken out to be ground. Two women generally worked the quern, one sitting facing the other, the quern between them, and each in her turn taking hold of the handle, turned it with a degree of velocity much greater than you, perhaps, imagine. One or other of them ‘fed’ as it was called—that is, put the corn into the large hole (called the eye) in the upper stone, as above described. The feeding required some dexterity in 
> 
> 
> 
> ---
> 
> p.131
> 
> 
> 
> avoiding a blow of the handle in its rotatory motion, and at the same time to drop the corn into the eye without scattering it. The process of shelling was never performed, but the corn and husk ground down together, so that the meal appeared at first very dark and rough, but was afterwards sifted. It required little cookery. The ordinary way of using, was to mix the meal in its raw state with milk, and make it to the consistency of stirabout. This simple mixture was called *a croudie*, and eaten without any other accompaniment. The great drying which the corn underwent, prevented the meal from having that raw taste perceptible in meal made in water-mills. I cannot state with any degree of confidence what quantity could be ground in a given time; but I think two stout women could grind about ten pounds of clean meal in an hour.—C.’
> 
> 
> 






---

p.132


XX
--


‘In an unpublished History of Ireland, written about the year 1636, now remaining in manuscript in the Library of the Royal Irish Academy, **Dublin**, we are told that, ‘The Irish are much addicted to musick generally, and you shall find but very few of their gentry, either man or woman, but can play on the harp; also you shall not find a house of any account, without one or two of those instruments, and they always keep a harper to play for them at their meals, and all other times, as often as they have a desire to recreate themselves, or others which come to their houses, therewith.’’


‘During the troubles after 1641, when a war of destruction was waged against every thing Irish, **Lynch**, in his Cambrensis Eversus, informs us that the harp was broken by soldiers, wherever it could be found, and adds. ‘The memory of its form and materials will be unknown and lost to our immediate posterity.’ The war of 1688, which completed the downfal of the ancient Irish families, also silenced their national instrument. A solitary harp might occasionally be heard emitting mournful sounds over the fallen fortunes of the country, but it was no longer in general use.’—**Hardiman**'s Irish Minstrelsy, i. 183.


In a whimsical account of the adventure of two Cavaliers, who were in the train of the **Marquis of **Ormond****, and made an excursion into the County of **Waterford** to visit the High Sheriff at **Coolfin**, (printed in a rare volume entitled Songs 



---

p.133




and Poems of Love and Drollery by T. W. 1654, one of them is represented as mistaking the hall of their host's dwelling for a stable, until he discovers a harp in the corner.


> 1. Ned, he alights and leads (God bless us all)
>   
> His horse into his Worship's very hall;
>   
> And looking round about, cries in great anger,
>   
> 'Zowns, here's a stable, has no rack nor manger.'
>   
> 'Peace Ned,' (quoth I) 'prithe be not so hasty,
>   
> This room's no stable though it be as nasty;
>   
> I see a harp and chimney too, and dare
>   
> Say there was fire in't before the war;
>   
> So this is no place for a horse you see.'
>   
> ''Tis then for very beasts, I'm sure,' (quoth he).
> 





I am inclined to think that the loss of the Irish harp, as a musical instrument, is not much to be regretted; it was strung with wire, and its tone appears to have been truly described in the Irish Hudibras.

> 1. The Irish harp whose rusty mettle,
>   
> Sounds like the patching of a kettle.
> 




At the period of our traveller's visit there were few houses in **Ireland** without a harp, although probably not a dozen specimens of the instrument could now be found. The harp called Brian Boro's, which was deposited by **Mr. Conyngham** in 1782, in the Museum of Trinity College, **Dublin**, is well known.—In **Mr. Bunting's** Collection of Irish Melodies, a print may be found of a harp made in 1621, which belonged to a branch of the Fitzgerald family, and is or was recently in the possession of Mr. Noah Dalway of **Bellahill** near **Carrickfergus**. The Dublin Penny Journal (iv. 256) contains a representation of a harp of James II.'s time, preserved by Mr. Lenigan of 



---

p.134


**Castle Fogarty** in the County of **Tipperary**. And in **Walker**'s History of the Irish Bards there is an engraving of an Irish harp, made in 1726, by John Kelly, which was in the possession of Mr. Jonathan Hehir of Limerick. Add to these four harps, that of my maternal great-grandfather (the Rev. Charles Bunworth) made, I think, in 1737, which still remains a venerated family relic, and the list of all the existing specimens of the Irish harps which occur at this moment to my memory is completed.—C.




---

p.135


XXI
---


Our traveller more than once hints that if he fell into the hands of the Parliamentarians by the capture of the Irish vessel he was in, certain death awaited him. ‘It was rumoured,’ he observes (page 2), ‘that the Parliamentarians threw into the sea all the Irish and those of their party, owing to the massacre the Irish had made in their country of English Protestants by a zeal for religion.’ And this appears to have had more than mere rumour for its foundation, from the following entry in the record of the proceedings of the Committee of the Admiralty, on the 17th December, 1646.


‘Whereas by an ordinance of both Houses of Parliament dated 24th October, 1644, it is declared that no quarter shalbe hereafter given to any Irishman, nor to any Papist borne in **Ireland** which shalbe taken in hostility against the Parliament, either upon the sea or within this kingdome and it is thereby ordained that all officers and commanders by sea and land shall upon the takeing of every such Irishman or Papist borne in **Ireland** forthwith put every such person to death. For the execution of such ordinance instructions have been issued by this Committee to the Commanders of the Fleete, according to the strict command therein given.’


‘Now upon consideracion of what's presented in severall letters directed from severall persons in the West of England 



---

p.136



to Sir John Northcot, Sir Samuell Rolle, and Sir John Yong, members of the House of Commons, concerning the interruption of Trade by the Irish Frigats, being much increased in number and strength, and the suffringe and dangers of some English that have been by them taken prisoners at sea. In some of which letters was inclosed a letter from one of the said prisoners at **Wexford**, importing that the casting of some Irish over boord that hath been taken at sea by Captain Gilson, hath deprived the said prisoners of hopes of mercy unless the said Ordinance be recalled; the number of the said prisoners at **Wexford** and thereabouts being informed to be about 150. Also the copie of a letter from Jasper Bolor the Maior of **Wexford** conteyning severall scandalous expressions against the parliament, complaints of throwing Irish over bord by Captain Gilson and Captain Plunket, and threats that unles answere be given by the first of February next that no such course shalbe hereafter used, and the said Captain sent over to receive punishment, 168 persons that are prisoners there and in other parts of **Ireland** shall suffer, and those that hereafter fall into theire hands shall receive the same measure. Also a peticion to both houses of Parliament from the wives and freinds of some of the said prisoners praying the Parliament's compassion in procuring the said prisoners release in such way as they shall in theire wisdome thinke fit.’


‘Ordered. That the state of this buisines be reported to both houses with this Committee's desire that they will please to declare theire pleasure therein, and to direct what instructions this Committee shall hereafter give to the Comanders of the Parliaments ships in reference to the said Ordinance.’—C.




---

p.137


### ADDITIONAL NOTES


(16. page 7.)


The Lord Deputy Wentworth thus writes to the Archbishop of Canterbury, on the 27th September, 1637, respecting *Jigginstown*. Stafford's Letters, ii. 105, 6.
  


> 
> *[...]* Next they say I build up to the sky. I acknowledge that were myself only considered in what I build, it were not only to excess, but even to folly, having already houses moderate for my condition in **Yorkshire**. But his Majesty will justify me, that at my last being in England, I acquainted him with a purpose I had to build him a house at **Naas**, it being uncomely his Majesty should not have one here of his own, capable to lodge him with moderate conveniency, (which, in truth, as yet he hath not) in case he might be pleased sometimes hereafter to look upon this kingdom, and that it was necessary in a manner, for the dignity of this place, and the health of his Deputy and family, that there should be one removing house of fresh air, for want whereof, I assure your Lordship, I have felt no small inconvenience since my coming hither; that, when it was built, if liked by his Majesty, it should be his, paying me as it cost, if disliked, a suo damno, I was content to keep it, and smart for my folly. His Majesty seemed to be pleased with all, whereupon I proceeded, and have, in a manner, finished it, and so contrived it for the room of state, and other accommodations, which I have observed in his Majesty's houses, as I had been indeed stark mad ever to have cast it so for a private family.—
> 
> 
> 
> 
> ---
> 
> p.138
> 
> 
> Another frame of wood I have given order to set up in a park I have in the county of **Wicklow**. And gnash the teeth of these gallants never so hard, I will, by God's leave, go on with it, so that I may have a place to take my recreation for a month or two in a year, were it for no other reason than to displease them, by keeping myself, if so please God, a little longer in health. Yet, lest these magnificent structures might be thought those of **Nebuchadnezzar**, the plain truth is, that at the **Naas** with the most may stand in six thousand pounds; that in the Park at twelve hundred. Faith, at worst, methinks, they should not judge it very much for a person of my great Hazienda, to cast away twelve hundred pounds upon his own fancy; and yet, to profess a truth to your Grace, but that I did consider his Majesty might judge it hereafter for his service to visit this kingdom, in that case, foresaw no part able to give him the pleasure of his summer hunting like that Park and country adjacent, and, lastly, that then, at least, I would provide a Lodge that might house him dry from the injuries of the weather, I protest there had not been one timber of it fastened to another. In the mean time, my confidence is my comfort, that if I be made so happy as to see his Majesty on this side, he will give me thanks for them both, and then I am at the height of my ambition, and these my well wishers fairly pounded upon the very place to accuse me, if any thing they have to say unto me.
> 
> 
> 

—C.


(32. page 11.)


Peter Shee was Mayor of **Kilkenny** in 1644.


—C.




---

p.139


(39. page 17.)


‘The first country on the European Continent to which the Native Irish were accustomed to resort for education, was **Spain**, the land in which, according to one impression among themselves, their ancestors once lived; and the earliest foundation of which any authentic account can be given, was **Salamanca**, in **Leon**, once so famous for its University.’


‘At the instance and solicitation of an Irishman, **Thomas White**, from **Clonmell**, **Tipperary**, a college was instituted in 1582, of which **White** was the first rector. Small at first and poor in its origin, it was, however, maintained for many years, till, in the years 1610 and 1614, buildings were erected and a spacious library was formed. It was in this College, about fifty years after this, that **Dr. Andrew Sall** was a professor.’


‘The number of students, however, has never been great. Thus, at the period of the French Revolution, there were thirty-two, and up to the invasion of **Spain** by **France**, in 1807, the number was never above thirty. At present, there are supposed to be only about twelve.’


‘Count Beerhaven, of an Irish family, was a benefactor to this seminary. Peter French, from Galway, educated here, went a Missionary to the Mexican Indians. There he remained for thirty years. He composed a Catechism in the Mexican language, and finally returned to **Ireland**, where he died in 1693.—**Anderson**'s Historical Sketches of the Ancient Native Irish.’ —C.
  

THE END


