

#The Round Towers of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Round Towers of Ireland
===========================


Author: Thomas Osborne Davis
----------------------------


### File Description

T.W. RollestonElectronic edition compiled by Beatrix Färber

proof corrections by Margaret Bonar , Beatrix Färber

 2. Second draft.Extent of text: 6450 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2005) (2010) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E800002-015Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions of this text and/or other writings by Thomas Davis**2. The Transactions of the Royal Irish Academy 1854, vol. 20. Dublin: Hodges & Smith, Grafton Street.
3. Thomas Davis, Essays Literary and Historical, ed. by D. J. O'Donoghue, Dundalk 1914.
4. Sir Charles Gavan Duffy (ed.), Thomas Davis, the memoirs of an Irish patriot, 1840–1846. 1890.
5. Thomas Osborne Davis, Literary and historical essays 1846. Reprinted 1998, Washington, DC: Woodstock Books.
6. Essays of Thomas Davis. New York, Lemma Pub. Corp. 1974, 1914 [Reprint of the 1914 ed. published by W. Tempest, Dundalk, Ireland, under the title 'Essays literary and historical'.]
7. Thomas Davis: essays and poems, with a centenary memoir, 1845–1945. Dublin, M.H. Gill and Son, 1945. [Foreword by an taoiseach, Éamon de Valera.]
8. Angela Clifford, Godless colleges and mixed education in Ireland: extracts from speeches and writings of Thomas Wyse, Daniel O'Connell, Thomas Davis, Charles Gavan Duffy, Frank Hugh O'Donnell and others. Belfast: Athol, 1992.
**Selected further reading**2. Arthur Griffith (ed.), Thomas Davis: the thinker & teacher; the essence of his writings in prose and poetry. Dublin: Gill 1914.
3. William O'Brien, The influence of Thomas Davis: a lecture delivered by William O'Brien, M.P., at the City Hall, Cork, on 5th November 1915. Cork: Free Press Office, 1915.
4. Johannes Schiller, Thomas Osborne Davis, ein irischer Freiheitssänger. Wiener Beiträge zur englischen Philologie, Bd. XLVI. Wien und Leipzig, W. Braumüller, 1915.
5. Michael Quigley (ed.), Pictorial record: centenary of Thomas Davis and young Ireland. Dublin [1945].
6. Joseph Maunsell Hone, Thomas Davis (Famous Irish Lives). 1934.
7. M. J. MacManus (ed.), Thomas Davis and Young Ireland. Dublin: The Stationery Office, 1945.
8. J. L. Ahern, Thomas Davis and his circle. Waterford, 1945.
9. Michael Tierney, 'Thomas Davis: 1814–1845'. Studies; an Irish quarterly review, 34:135 (1945) 300–310.
10. Theodore William Moody, 'The Thomas Davis centenary lecture in Newry'. An t-Iubhar (=Newry) 1946, 22–26.
11. D. R. Gwynn, O'Connell, Davis and the Colleges Bill (Centenary Series 1). Oxford and Cork, 1948.
12. D. R. Gwynn, 'John E. Pigot and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 145–157.
13. D. R. Gwynn, 'Denny Lane and Thomas Davis'. Studies; an Irish quarterly review, 38 (1949) 15–28.
14. N. N., Clár cuimhneacháin: comóradh i gcuimhne Thomáis Daibhis, Magh Ealla, 1942. Baile Átha Cliath (=Dublin) 1942.
15. Christopher Preston, 'Commissioners under the Patriot Parliament, 1689'. Irish Ecclesiastical Record, 5th ser., 74:8 (1950) 141–151.
16. W.B. Yeats, Tribute to Thomas Davis: with an account of the Thomas Davis centenary meeting held in Dublin on November 20th, 1914, including Dr. Mahaffy's prohibition of the 'Man called Pearse,' and an unpublished protest by 'A.E.', Cork 1965.
17. Theodore William Moody, 'Thomas Davis and the Irish nation'. Hermathena, 103 (1966) 5–31.
18. Malcolm Johnston Brown, The politics of Irish literature: from Thomas Davis to W. B. Yeats. Seattle (University of Washington Press) 1973.
19. Eileen Sullivan, Thomas Davis. Lewisburg, New Jersey: Bucknell University Press, 1978.
20. Mary G. Buckley, Thomas Davis: a study in nationalist philosophy. Ph.D. Thesis, National University of Ireland, at the Department of Irish History, UCC, 1980.
21. Giulio Giorello, "A nation once again": Thomas Osborne Davis and the construction of the Irish "popular" tradition. History of European Ideas, 20:1–3 (1995) 211–217.
22. John Neylon Molony, A soul came into Ireland: Thomas Davis 1814–1845. Dublin 1995.
23. Robert Somerville-Woodward, "Two 'views of the Irish language': O'Connell versus Davis." The History Review: journal of the UCD History Society, 9 (1995) 44–50.
24. John Neylon Molony, 'Thomas Davis: Irish Romantic idealist'. In: Richard Davis; Jennifer Livett; Anne-Maree Whitaker; Peter Moore (eds.), Irish-Australian studies: papers delivered at the eighth Irish-Australian Conference, Hobart July 1995 (Sydney 1996) 52–63.
25. David Alvey, 'Thomas Davis. The conservation of a tradition.' Studies; an Irish quarterly review, 85 (1996) 37–42.
26. Harry White, The keeper's recital: music and cultural history in Ireland, 1770–1970. (Cork 1998).
27. Joseph Langtry; Brian Fay,'The Davis influence.' In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 30–38.
28. Joseph Langtry, 'Thomas Davis (1814–1845).' In: Joseph Langtry (ed.), A true Celt: Thomas Davis, The Nation, rebellion and transportation: a series of essays. (Dublin 1998) 2–7.
29. Patrick Maume, 'Young Ireland, Arthur Griffith, and republican ideology: the question of continuity.' Éire-Ireland, 34:2 (1999) 155–74.
30. Sean Ryder, 'Speaking of '98: Young Ireland and republican memory'. Éire-Ireland, 34:2 (1999) 51–69.
31. Ghislaine Saison, 'L'écriture de l'histoire chez la Jeune Irlande: quelle histoire pour une nation du consensus et de la réconciliation?' In: Centre de recherche inter-langues angevin, Écriture(s) de l'histoire: Actes du colloque des 2,3 et 4 décembre 1999. (Angers 2001) 435–446.
32. Gerry Kearns, 'Time and some citizenship: nationalism and Thomas Davis.' Bullán: an Irish Studies Review, 5:2 (2001) 23–54.
33. Helen Mulvey, Thomas Davis and Ireland: a biographical study. Washington, D.C., Catholic University of America Press, 2003.

Thomas Osborne Davis The Round Towers of Ireland in , Ed. T. W. Rolleston Thomas Davis: Selections from his prose and poetry. The Talbot Press, Dublin and London, ([1910]) page 106–119### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


the whole essay.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed.


##### Normalization


the electronic text represents the edited text. Italicized or capitalized sections of the text are tagged emph.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the essay; div1=the essay. Page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Personal names and titles of books, manuscripts and journals are tagged, and identified or regularized within the encoding.


#### Canonical References


This text uses the DIV1 element to represent the essay. ### Profile Description


Created: by Thomas Davis

 (1840s) #### Use of language


##### Language: [EN] The text and footnotes are in English.


##### Language: [IW] One word is in Hebrew.


##### Language: [GA] Many words and terms are in Irish.


##### Language: [LA] Some words are in Latin.


### Revision History


* (2010-04-10) Beatrix Färber (ed.)

* Conversion script run; header updated; encoding of personal names and some terms improved; new wordcount made.
* (2008-07-20) Beatrix Färber (ed.)

* Value of div0 "type" attribute modified, changes to file structure made; 'langUsage' revised.
* (2005-08-25) Julianne Nyhan (ed.)

* Normalised language codes and edited langUsage for XML conversion
* (2005-08-08T10:29:06+0100) Peter Flynn (conversion)

* Converted to XML
* (2005-08-02) Beatrix Färber (ed.)

* File proofed (2), structural and content markup applied to names and titles; header inserted; file parsed. HTML file created.
* (2005-07-29) Margaret Bonar, Dublin (ed.)

* File proofed (1).
* (1996) Audrey Murphy (ed.)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E800002-015


### The Round Towers of Ireland: Author: Thomas Osborne Davis




---

p.106


The Round Towers of Ireland
---------------------------


Accustomed from boyhood to regard these towers as revelations of a gorgeous but otherwise undefined antiquity—dazzled by oriental analogies—finding a refuge in their primeval greatness from the meanness or the misfortunes of our middle ages, we clung to the belief of their Pagan origin.


In fancy we had seen the white-robed Druid tend the holy fire in their lower chambers—had measured with the Tyrian-taught astronomer the length of their shadows—and had almost knelt to the elemental worship with nobles whose robes had the dye of the Levant, and sailors whose cheeks were brown with an Egyptian sun, and soldiers whose bronze arms clashed as the trumpets from the tower-top said that the sun had risen. What wonder that we had resented the attempt to cure us of so sweet a frenzy?


We plead guilty to having opened **Mr. Petrie**'s work strongly bigoted against his conclusion.


On the other hand, we could not forget the authority of the book. Its author we knew was familiar beyond almost any other with the country—had not left one glen unsearched, not one island untrod; had brought with him the information of a life of antiquarian study, a graceful and exact pencil, and feelings equally national and lofty. We knew also that he had the aid of the best Celtic scholars alive in the progress of his work. The long time taken in its preparation ensured maturity; and the honest men 


---

p.107






who had criticised it, and the adventurers who had stolen from it enough to make false reputations, equally testified to its merits.


Yet, we repeat, we jealously watched for flaws in **Mr. Petrie**'s reasoning; exulted as he set down the extracts from his opponents, in the hope that he would fail in answering them, and at last surrendered with a sullen despair.


Looking now more calmly at the discussion, we are grateful to **Mr. Petrie** for having driven away an idle fancy. In its stead he has given us new and unlooked-for trophies, and more solid information on Irish antiquities than any of his predecessors. We may be well content to hand over the Round Towers to Christians of the sixth or the tenth century, when we find that these Christians were really eminent in knowledge as well as piety, had arched churches by the side of these campanilia, gave an alphabet to the Saxons, and hospitality and learning to the students of all western Europe—and the more readily, as we got in exchange proofs of a Pagan race having a Pelasgic architecture, and the arms and ornaments of a powerful and cultivated people.


The volume before us contains two parts of **Mr. Petrie**'s essay. The first part is an examination of the false theories of the origin of these towers. The second is an account not only of what he thinks their real origin, but of every kind of early ecclesiastical structure in Ireland. The third part will contain a historical and descriptive account of every ecclesiastical building in Ireland of a date prior to the Anglo-Norman invasion of which remains now exist. The work is crowded with illustrations drawn with wonderful accuracy, and engraved in a style which proves that **Mr. O'Hanlon**, the engraver, has become so proficient as hardly to have a superior in wood-cutting.




---

p.108


We shall for the present limit ourselves to the first part of the work on the Erroneous theories with respect to the origin and uses of the Round Towers.


The first refutation is of the ‘Theory of the Danish origin of the towers.’


**John Lynch**, in his Cambrensis Eversus, says that the Danes are reported (dicuntur) to have first erected the Round Towers as watch-towers, but that the Christian Irish changed them into clock or bell-towers. **Peter Walsh**[1](javascript:footNote('E800002-015/note001.html')) repeated and exaggerated the statement; and **Ledwich**, the West British antiquary of last century, combined it with lies enough to settle his character, though not that of the towers. The only person, at once explicit and honest, who supported this Danish theory was **Dr. Molyneux**. His arguments are that all stone buildings, and, indeed all evidences of mechanical civilisation, in Ireland were Danish; that some traditions attributed the Round Towers to them; that they had fit models in the monuments of their own country; and that the word by which he says the native Irish call them, viz., **Clogachd**, comes from the Teutonic root, clugga, a bell. These arguments are easily answered.


The Danes, so far from introducing stone architecture, found it flourishing in Ireland, and burned and ruined our finest buildings, and destroyed mechanical and every kind of civilisation wherever their ravages extended—doing thus in Ireland precisely as they did in France and England, as all annals (their own included) testify. Tradition does not describe the towers as Danish watch-towers, but as Christian belfries. The upright stones and the little barrows, not 


---

p.109






twelve feet high, of Denmark, could neither give models nor skill to the Danes. They had much ampler possession of England and Scotland, and permanent possession of Normandy, but never a Round Tower did they erect there; and, finally, the native Irish name for a Round Tower is **cloic-theach**, from **teach**, a house, and **cloc**, the Irish word used for a bell in Irish works before ‘the Germans or Saxons had churches or bells,’ and before the Danes had ever sent a war-ship into our seas.


We pass readily from this ridiculous hypothesis with the remark that the gossip which attributes to the Danes our lofty monumental pyramids and cairns, our Druid altars, our dry stone caisils or keeps, and our **rath**s or fortified enclosures for the homes or cattle of our chiefs, is equally and utterly unfounded; and is partly to be accounted for from the name of power and terror which these barbarians left behind, and partly from ignorant persons confounding them with the most illustrious and civilised of the Irish races—the Danaans.


Theory of the eastern origin of the Round Towers.


Among the middle and upper classes in Ireland the Round Towers are regarded as one of the results of an intimate connection between Ireland and the East, and are spoken of as either—1. Fire Temples; 2. Stations from whence Druid festivals were announced; 3. Sun-dials (gnomons) and astronomical observatories; 4. Buddhist or Phallic temples, or two or more of these uses are attributed to them at the same time.


**Mr. Petrie** states that the theory of the Phoenician or Indo-Scythic origin of these towers was stated for the first time so recently as 1772 by **General Vallancey**, in his Essay on the Antiquity of the Irish Language, and was re-asserted by him in many different and contradictory


---

p.110






forms in his Collectanea de Rebus Hibernicis, published at intervals in the following years.


It may be well to premise who **General Charles Vallancey** was. His family were from Berry, in France; their name Le Brun, called De Valencia, from their estate of that name. **General Vallancey** was born in Flanders, but was educated at Eton College. When a captain in the 12th Royal Infantry he was attached to the engineer department in Ireland, published a book on Field Engineering in 1756, and commenced a survey of Ireland. During this he picked up something of the Irish language, and is said to have studied it under **Morris O'Gorman**, clerk of Mary's Lane Chapel. He died in his house, Lower Mount Street, 18th August, 1812, aged 82 years.


His Collectanea, and his discourses in the Royal Irish Academy, of which he was an original member, spread far and wide his oriental theories. He was an amiable and plausible man, but of little learning, little industry, great boldness, and no scruples; and while he certainly stimulated men's feelings towards Irish antiquities, he has left us a reproducing swarm of falsehood, of which **Mr. Petrie** has happily begun the destruction. Perhaps nothing gave **Vallancey**'s follies more popularity than the opposition of the **Rev. Edward Ledwich**, whose Antiquities of Ireland is a mass of falsehoods, disparaging to the people and the country.


Fire Temples.


**Vallancey**'s first analogy is plausible. The Irish Druids honoured the elements and kept up sacred fires, and at a particular day in the year all the fires in the kingdom were put out, and had to be re-lighted from the Arch-Druid's fire. A similar creed and custom existed among the Parsees or Guebres of Persia, and he takes the resemblance to prove


---

p.111






connection and identity of creed and civilisation. From this he immediately concludes the Round Towers to be Fire Temples. Now there is no evidence that the Irish Pagans had sacred fires, except in open spaces (on the hill- tops), and, therefore, none of course that they had them in towers round or square; but **Vallancey** falls back on the *alleged existence of Round Towers in the East similar to ours, and on etymology.*


Here is a specimen of his etymologies. The Hebrew word gadul signifies *great*, and thence a tower; the Irish name for a round tower, **cloghad**, is from this gadul or *gad*, and **clogh**, a *stone*: and the Druids called every place of worship **cloghad**. To which it is answered—gadul is not *gad*—**clogh**, a *stone*, is not **cloch**, a bell. The Irish word for a Round Tower is **cloich-theach**, or bell-house, and there is no proof that the Druids called any place of worship **cloghad**.


**Vallancey**'s guesses are numerous, and nearly all childish, and we shall quote some finishing specimens, with **Mr. Petrie**'s answers:—



‘This is another characteristic example of **Vallancey**'s mode of quoting authorities: he first makes **O'Brien** say that Cuilceach becomes corruptly Claiceach, and then that the word seems to be corrupted **Clogtheach**. But **O'Brien** does not say that Cuilceach is corruptly Claiceach, nor has he the word Culkak or Claiceach in his book; neither does he say that Cuilceach seems to be a corruption of **Clog-theach**, but states positively that it is so. The following are the passages which **Vallancey** has so misquoted and garbled—’



‘Cuilceach, a steeple, cuilceach Cluan-umba, *Cloyne steeple*—this word is a corruption of **Clog-theach**.’


‘**Cloig-theach**, a steeple, a belfry; corrupte **Cuilg-theach**.’


‘Our author next tells us that another name for the Round Towers is Sibbeit, Sithbeit, and Sithhein, and for this he refers us to **O'Brien**'s and **Shaw**'s Lexicons; but this quotation is equally false with those I have already exposed, for the words Sibheit and Sithbeit are not to be found in either of the works referred to. The word **Siththe** is indeed given in both Lexicons, but explained a city, not a round tower. The word **Sithbhein** is also given in both, but explained a fort, a turret, and the real meaning of the word as still understood in many parts of Ireland is a fairy-hill or hill of the fairies, and is applied to a green round hill crowned by a small sepulchral mound.’


‘He next tells us that Caiceach, the last name he finds for the Round Towers, is supposed by the Glossarists to be compounded of **cai**, a house, and **teach**, a house, an explanation which, he playfully adds, is


---

p.112






tautology with a witness. But where did he find authority for the word Caiceach? I answer, nowhere; and the tautology he speaks of was either a creation or a blunder of his own. It is evident to me that the Glossarist to whom he refers is no other than his favourite **Cormac**; but the latter makes no such blunder, as will appear from the passage which our author obviously refers to—’



‘ Cai i. teach unde dicitur ceard cha i. teach cearda; creas cha i. teach cumang.’



‘Cai, i.e., a house; unde dicitur ceard-cha, i.e., the house of the artificer; creas-cha, i.e., a narrow house.’


The reader has probably now had enough of **Vallancey**'s etymology, but it is right to add that **Mr. Petrie** goes through every hint of such proof given by the General, and disposes of them with greater facility.


The next person disposed of is **Mr. Beauford**, who derives the name of our Round Towers from Tlacht—earth; asserts that the foundations of temples for Vestal fire exist in **Rath-na-Emhain**, and other places (poor devil!)—that the Persian Magi overran the world in the time of the great Constantine, introducing Round Towers in place of the Vestal mounds into Ireland, combining their fire-worship with our Druidism—and that the present towers were built in imitation of the Magian Towers. This is all, as **Mr. Petrie** says, pure fallacy, without a particle of authority; but we should think ‘twelfth’ is a misprint for ‘seventh’ in the early part of **Beauford**'s passage, and, therefore, that the last clause of **Mr. Petrie**'s censure is undeserved.


This **Beauford** is not to be confounded with **Miss Beaufort**. She, too, paganises the towers by aggravating some misstatements of Mason's Parochial Survey; but her errors are not worth notice, except the assertion that the Psalters of Tara and Cashel allege that the towers were for keeping the sacred fire. These Psalters are believed to have perished, and any mention of sacred fires in the glossary of **Cormac McCullenan**, the supposed compiler of the **Psalter of Cashel**, is adverse to their being in towers. He says:—



‘Belltane, i.e., bil tene, i.e., tene bil, i.e., the goodly fire, i.e., two


---

p.113






goodly fires, which the Druids were used to make, with great incantations on them, and they used to bring the cattle between them against the diseases of each year.’


Another MS. says:—



‘Beltaine, i.e., Bel-dine: Bel was the name of an idol, it was on it (i.e. the festival) that a couple of the young of every cattle were exhibited as in the possession of Bel. unde Beldine. Or Beltine, i.e.Bil-tine, i.e., the goodly fire, i.e., two goodly fires, which the Druids were used to make with great incantations, and they were used to drive the cattle between them against the diseases of each year.’


**Mr. Petrie** continues:—



‘It may be remarked that remnants of this ancient custom, in perhaps a modified form, still exist in the May-fires lighted in the streets and suburbs of Dublin, and also in the fires lighted on St. John's Eve in all other parts of Ireland. The **Tinne Eigin** of the Highlands, of which **Dr. Martin** gives the following account, is probably a remnant of it also, but there is no instance of such fires being lighted in towers or houses of any description—’


‘The inhabitants here (**Isle of Skye**) did also make use of a fire called **Tin-Egin** (i.e.), a forced Fire, or Fire of necessity, which they used as an Antidote against the *Plague* or *Murrain* in cattle, and it was performed thus: All the fires in the Parish were extinguish'd, and eighty-one marry'd men, being thought the necessary number for effecting this Design, took two great Planks of Wood. and nine of 'em were employed by turns, who by their repeated Efforts rubb'd one of the Planks against the other until the Heat thereof produced Fire and from this forc'd Fire each Family is supplied with new Fire, which is no sooner kindled than a pot full of water is quickly set on it, and afterwards sprinkled upon the people infected with the Plague, or upon cattle that have the Murrain. And this, they all say, they find successful by experience.’— Description of the Western Islands of Scotland (second edition), p. 113.


‘As authority for **Miss Beaufort**'s second assertion relative to the Tower of Thlachtga, etc., we are referred to the **Psalter of Tara**, by **Comerford** (p. 41), cited in the Parochial Survey (vol. iii., p. 320), and certainly in the latter work we do find a passage in nearly the same words which **Miss Beaufort** uses. But if the lady had herself referred to **Comerford**'s little work, she would have discovered that the author of the article in the Parochial Survey had in reality no authority for his assertions, and had attempted a gross imposition on the credulity of his readers.’


**Mr. D'Alton** relies much on a passage in **Cambrensis**, wherein he says that the fishermen on **Lough Neagh** (a lake certainly formed by an inundation in the first century, A.D. 62) point to such towers under the lake; but this only shows they were considered old in **Cambrensis**'s time (King 


---

p.114






John's), for **Cambrensis** calls them turres ecclesiasticas (a Christian appellation); and the fishermen of every lake have such idle traditions from the tall objects they are familiar with; and the steeples of Antrim, etc., were handy to the Loch *n-Eachach* men.


One of the authorities quoted by all the Paganists is from the Ulster Annals at the year 448. It is—‘Kl. Jenair Anno Domini cccc.xl[ordm ].viii[ordm ]. ingenti terrae motu per loca varia imminente, plurimi urbis auguste muri recenti adhuc reaedificatione constructi, cum l.vii. turribus conruerunt.’ This was made to mean that part of the wall of Armagh, with fifty-seven Round Towers, fell in an earthquake in 448, whereas the passage turns out to be a quotation from **Marcellinus**[2](javascript:footNote('E800002-015/note002.html')) of the fall of part of the defences of Constantinople—Urbis Augustae!


References to towers in Irish annals are quoted by **Mr. D'Alton**; but they turn out to be written about the Cyclopean Forts, or low stone raths, such as we find at Aileach, etc.


Celestial Indexes.


**Dr. Charles O'Connor, of Stowe**, is the chief supporter of the astronomical theory. One of his arguments is founded on the mistaken reading of the word turaghun (which he derives from **tur**, a tower, and **aghan**, or **adhan**, the kindling of flame), instead of **truaghan**, an ascetic. The only other authority of his which we have not noticed is the passage in the Ulster Annals, at the year 995, in which it is said that certain **Fidhnemead** were burned by lightning at Armagh. He translates the word ‘celestial indexes’, and paraphrases it Round Towers, and all because **fiadh** means witness, and **neimhedh**, heavenly or sacred, the real meaning


---

p.115






being ‘holy wood’, or ‘wood of the sanctuary’, from **fidh**, a wood, and **neimhedh**, ‘holy’, as is proved by a pile of *exact* authorities.


**Dr. Lanigan**, in his Ecclesiastical History, and **Moore**, in his General History, repeat the arguments which we have mentioned. They also bring objections against the alleged Christian origin, which we hold over; but it is plain that nothing prevailed more with them than the alleged resemblance of these towers to certain oriental buildings. Assuredly if there were a close likeness between the Irish Round Towers and oriental fire temples of proved antiquity, it would be an argument for identity of use; and though direct testimony from our annals would come in and show that the present towers were built as Christian belfries from the sixth to the tenth centuries, the resemblance would at least indicate that the belfries had been built after the model of Pagan fire towers previously existing here. But ‘rotundos of above thirty feet in diameter’ in Persia, Turkish minarets of the tenth or fourteenth centuries, and undated turrets in India, which **Lord Valentia** thought like our Round Towers, give no *such* resemblance. We shall look anxiously for exact measurements and dates of oriental buildings resembling Round Towers, and weigh the evidence which may be offered to show that there were any Pagan models for the latter in Ireland or in Asia.


**Mr. Windele**, of Cork, besides using all the previously mentioned arguments for the Paganism of these towers, finds another in the supposed resemblance to *The Nurraggis of Sardinia*, which are tombs or temples formed in that island, and attributed to the Phoenicians. But, alas, for the theory, they have turned out to be ‘as broad as they're long.’ A square building, 57 feet in each side, with beehive towers at each angle, and a centre bee-hive tower reaching to 45 or 65 feet high, with stone stairs, is sadly unlike a Round Tower!




---

p.116


The most recent theory is that the Round Towers are *Hero-Monuments*.


**Mr. Windele** and the South Munster Antiquarian Society started this, **Sir William Betham** sanctioned it, and several rash gentlemen dug under towers to prove it. At Cashel, Kinsale, etc., they satisfied themselves that there were no sepulchres or bones ever under the towers, but in some other places they took the rubbish bones casually thrown into the towers, and in two cases the chance underlying of ancient burying-grounds, as proofs of this notion. But **Mr. Petrie** settles for this idea by showing that there is no such use of the Round Towers mentioned in our annals, and also by the following most interesting account of the cemeteries and monuments of all the races of Pagan Irish.—


History of the Cemeteries.


‘A great king of great judgments assumed the sovereignty of Erin, i.e., Cormac, son of Art, son of Conn of the Hundred Battles. Erin was prosperous in his time, because just judgments were distributed throughout it by him, so that no one durst attempt to wound a man in Erin during the short jubilee of seven years; for Cormac had the faith of the one true God, according to the law, for he said that he would not adore stones, or trees, but that he would adore Him who had made them, and who had power over all the elements, i.e., the one powerful God who created the elements. in Him he would believe. And he was the third person who had believed in Erin before the arrival of St. Patrick. Conchobor MacNessa to whom Altus had told concerning the crucifixion of Christ, *was the first*; Morann, the son of Cairbre Cinncait (who was surnamed Mac Main), was the second person; and Cormac was the third; and it is probable that others followed on their track in this belief.’


‘Where Cormac held his court was at Tara, in imitation of the kings who preceded him, until his eye was destroyed by Engus Gaibhuaiphnech the son of Eochaidh Finn Futhairt: but afterwards he resided at Acaill (the hill on which Scrin Colaim Cille is at this day) and at Cenannas (Kells), and at the house of Cletech; for it was not lawful that a king with a *personal* blemish should reside at Tara. In the second year after the injuring of his eye he came by his death at the house of Cletech, the bone of a salmon having stuck in his throat. And he (Cormac) told his people not to bury him at Brugh (because it was a cemetery of Idolaters) for he did not worship the same God as any of those interred at Brugh; but to bury him at Ros-na-righ, with his face to the east. He afterwards died, and his servants of trust held a council, and came to the resolution of burying him at Brugh, the place


---

p.117






where the kings of Tara, his predecessors, were buried. The body of the king was afterwards thrice raised to be carried to Brugh, but the Boyne swelled up thrice, so that they could not come; so that they observed that it was 'violating the judgment of a prince' to break through this testament of the king, and they afterwards dug his grave at Ros-na-righ, as he himself had ordered.’


‘These were the chief cemeteries of Erin before the Faith (i.e. before the introduction of Christianity), viz., Cruachu, Brugh, Tailltin, Luachair, Ailbe, Oenach Ailbe, Oenach Culi, Oenach Colmain, Temhair Erann.’


‘Oenach Cruachan, in the first place, it was there the race of Heremon (i.e., the kings of Tara) were used to bury until the time of Cremhthann, the son of *Lughaidh Riabh nDerg* (who was the first king of them that was interred at Brugh), viz., *Cobhtach* Coelbregh, and Labhraidh Loingsech, and Eocho Fedhlech with his three sons (i.e. the three Fidhemhna—i.e., Bres, Nar, and Lothoe), and Eocho Airemh, *Lughaidh Riabh nDerg*, the six daughters of Eocho Fedhlech (i.e., Medhbh, and Clothru, Muresc, and Drebrin, Mugain, and Ele), and Adill Mac Mada with his seven brothers (i.e., Cet, Anlon, Doche, et ceteri), and all the kings *down* to Cremhthann (these were all buried at Cruachan). Why was it not at Brugh that the kings (of the race of Cobhthach down to Crimthann) were interred? Not difficult; because the two provinces which the race of Heremon possessed were the province of Gailian (i.e., the province of Leinster), and the province of Olnecmacht (i.e., the province of Connaught). In the first place, the province of Gailian was occupied by the race of Labhbraidh Loingsech, and the province of Connaught was the peculiar inheritance of the race of Cobhtach Coelbregh, wherefore it (i.e. the province of Connaught) was given to Medhbh before every other province. (The reason that the government of this land was given to Medhbh is because there was none of the race of Eochaidh fit to receive it but herself, for Lughaidh was not fit for action at the time.) And whenever, therefore, the monarchy of Erin was enjoyed bv any of the descendants of Cobhthach Coelbregh, the province of Connaught was his **ruidles** (i.e., his native principality). And for this reason they were interred at Oenach na Cruachna. But they were interred at Brugh from the time of Crimthann (Niadh-nar) to the time of Loeghaire, the son of Niall, except three persons, namely, Art, the son of Conn, and Cormac, the son of Art, and Niall of the Nine Hostages.’


‘We have already mentioned the cause for which Cormac was not interred there. The reason why Art was not interred there is because he 'believed', the day before the battle of Muccramma was fought, and he predicted the Faith (i.e., that Christianity would prevail in Erin), and he said that his own grave would be at Dumha Dergluachra, where Treoit [Trevet] is at this day, as he mentioned in a poem which he composed—viz., Cain do denna den (i.e., a poem which Art composed, the beginning of which is Cain do denna den, etc.). When his (Art's) body was afterwards carried eastwards to Dumha Dergluachra, if all the men of Erin were drawing it thence, they could not, so that he was interred in that place because there was a Catholic church to be afterwards at the place where he was interred (i.e., Treoit hodie),


---

p.118






because the truth and the Faith had been revealed to him through his regal righteousuess.’


‘Where Niall was interred was at Ochain, whence the hill was called Ochain, i.e., Och Caine, i.e., from the sighing and lamentation which the men of Erin made in lamenting Niall.’


‘Conaire *Mor* was interred at Magh Feci in Bregia (i.e., at Fert Conaire); however, some say that it was Conaire Carpraige was interred there, and not Conaire Mor, and that Conaire Mor was the third king who was interred at Tara—viz., Conaire, Loeghaire and   
[*...*]  
’


‘At Tailltin the kings of Ulster were used to bury—viz., Ollamh Fodhla, with his descendants down to Conchobhar, who wished that he should be carried to a place between Slea and the sea, with his face to the east, on account of the Faith which he had embraced.’


‘The nobles of the Tuatha De Danann were used to bury at Brugh (i.e., the Dagda with his three sons, also Lughaidh and Oe, and Ollam, and Ogma, and Etan, the Poetess, and Corpre, the son of Etan), and Cremhthann followed them because his wife Nar was of the Tuatha *De*, and it was she solicited him that he should adopt Brugh as a burial-place for himself and his descendants, and this was the cause that they did not bury at Cruachan.’


‘The Lagenians (i.e., Cathair with his race and the kings who were before them) were buried at Oenach Ailbhe. The Clann Dedad (i.e. the race of Conaire and Erna) at Temhair Erann, the men of Munster (i.e., the Dergthene) at Oenach Culi, and Oenach Colmain; and the Connacians at Cruachan.’


Anchorite Towers.


Because **Simon Stylites** lived in a domicile, sized ‘scarce two cubits’, on a pillar sixty feet high, and because other anchorites lived on pillars and in cells, **Dean Richardson** suggested that the Irish Round Towers were for hermits; and was supported by **Walter Harris**, **Dr. Milner**, **Dr. King**, etc. The **cloch angcoire**, or hermit's stone, quoted in aid of this fancy, turns out to be a narrow cell; and so much for the hermits!


The confusion of *Tours and Towers* is a stupid pun or a vulgar pronunciation in English; but in Irish gave rise to the antiquarian theory of **Dr. Smith**, who, in his History of Cork, concludes that the Round Towers were penitential prisons, because the Irish word for a penitential round or journey is **turas**!




---

p.119


*The phallic theory* never had any support but poor **Henry O'Brien**'s enthusiastic ignorance and the caricaturing pen of his illustrator.


We have now done with the theories of these towers, which **Mr. Petrie** has shown, past doubt, to be either positively false or quite unproved. His own opinion is that they were used—1, as belfries; 2, as keeps, or houses of shelter for the clergy and their treasures; and 3, as watch-towers and beacons; and into his evidence for this opinion we shall go at a future day, thanking him at present for having displaced a heap of incongruous, though agreeable, fancies, and given us the learned, the most exact, and the most important work ever published on the antiquities of the Ancient Irish Nation.












