

#The Peril of Home Rule


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Peril of Home Rule
======================


Author: Peter Kerr-Smiley
-------------------------


### File Description

Electronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber , Students at the CELT Project

 1. First draftExtent of text: 35550 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E900008-001Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Literature**2. Francis Plowden, An historical review of the state of Ireland from the invasion of that country under Henry II. to its union with Great Britain on the 1st of January, 1801 (London 1803).
3. John Stuart Mill, England and Ireland (London 1868).
4. Home government for Ireland: being a series of articles reprinted from "The Cork examiner", by John Francis Maguire. 1872.
5. Isaac Butt, Address to the people of Ireland. 1873.
6. Isaac Butt, Home government for Ireland. Irish federalism! Its meaning, its objects, and its hopes. (3rd ed. Dublin 1870; 4th ed. Dublin 1874).
7. Against Home Rule: the case for the Union by Arthur J. Balfour; J. Austen Chamberlain ... (et al.) with an introduction by Sir Edward Carson. Dublin: White 1870.
8. Proceedings of the Home Rule Conference held at Dublin on 18th, 19th, 20th and 21st November 1873 ... (Dublin, 1874).
9. H. de F. Montgomery, Correspondence with Mr. Gladstone and notes on the pamphlet, "Gladstone & Burke". 1884.
10. Thomas Maguire. England's duty to Ireland, as plain to a loyal Irish Roman Catholic. 1886.
11. A.V. Dicey. England's Case Against Home Rule (London, 1886), reprinted 1986.
12. J. Middleton. An Englishman's plea for Home Rule. 1886.
13. W. R. Young. Arguments in support of Home Rule. 1893.
14. John E. Redmond. Historical and political addresses 1883–1897. 1898.
15. T.W. Russell. England's opportunity in Ireland. 1902.
16. John Morley, The Life of William Ewart Gladstone. 3 vols. (London 1903).
17. James Bryce, The American Commonwealth. 2 vols. (New York 1910).
18. R. F. Horton, D.D., and Joseph Hocking, Shall Rome Reconquer England? (London 1910).
19. The ABC of home rule in three parts, 1911, Unionist Association of Ireland.
20. Erskine Childers. The framework of Home Rule. 1911.
21. Aspects of Home Rule, selected from the speeches of Arthur Balfour. 1912
22. William O'Brien. Grattan's Home Rule, Gladstone's, and Asquith's: an answer to a boast. 1915.
23. W.E. Gladstone, speech introducing the First Home Rule Bill, 8 April 1886 (Hansard iii vol. 304 1036 ff, reprinted in A.Tilney Bassett Gladstone: Speeches, Descriptive Index and Bibliography (London 1916).
24. T. M. Healy, Letters and leaders of my day (2 vols, London 1928).
25. Godfrey Vincent de Clinton Parmiter. Roger Casement. London: A. Barker, 1936.
26. J. L. Hammond, Gladstone and the Irish Nation (London 1938).
27. Terence de Vere White, The road to excess (Dublin 1946).
28. Hugh Shearman, Anglo-Irish relations. London: Faber, 1948.
29. Gerard Anthony Hayes-McCoy. 'Robert Louis Stevenson and the Irish question'. Studies; an Irish quarterly review, 39 (1950).
30. Harford Montgomery Hyde. Carson: the life of Sir Edward Carson, Lord Carson of Duncairn. London: Heinemann, 1953.
31. Conor Cruise O'Brien, Parnell and his party, 1880–90 (Oxford 1957).
32. Lawrence John McCaffrey. 'Isaac Butt and the Home Rule movement: a study in conservative nationalism'. Review of Politics 22 (1960).
33. Lawrence John McCaffrey, 'Irish Federalism in the 1870's: a study in conservative nationalism', Transactions of the American Philosophical Society, NS, 52 (1962), Part 6.
34. F. S. Leland Lyons, The fall of Parnell, 1890–91 (London 1960).
35. L. P. Curtis, Coercion and conciliation in Ireland, 1880–1892: a study in conservative unionism (Princeton NJ 1963).
36. David Thornley, Isaac Butt and Home Rule (London 1964).
37. A. T. Q. Stewart, The Ulster crisis: resistance to Home Rule, 1912–1914 (London 1967).
38. F. S. Leland Lyons. 'The two faces of home rule'. In Nowlan, Kevin Barry, The Making of 1916: studies in the history of the Rising (Dublin: The Stationery Office, 1969).
39. J. C. Beckett, 'Carson: unionist and rebel', in his Confrontations: studies in Irish history (London 1972).
40. Patrick Buckland, Irish Unionism, 1885–1923: a documentary history (Belfast 1973).
41. Ian Dalton. 'Southern Irish Unionism: a study of Cork Unionists, 1884–1914'. Transactions of the Royal Historical Society, 5th ser., 23 (1973).
42. F. S. Leland Lyons, Charles Stewart Parnell (London 1977).
43. R. A. Cosgrove, 'The relevance of Irish history: the Gladstone-Dicey debate about home rule, 1886–87'. Éire-Ireland, 13:4 (1978).
44. MacDonagh, Oliver. 'The last bill of pains and penalties: the case of Daniel O'Sullivan, 1869'. Irish Historical Studies, 19:74 (1974), 136–55.
45. Robert Fitzroy Foster. 'Parnell and his people: the ascendancy and home rule'. Canadian Journal of Irish Studies, 6 (1980).
46. Owen Dudley Edwards. 'Divided treason and divided loyalties: Roger Casement and others'. Transactions of the Royal Historical Society, 5th ser., 32 (1982)
47. James Loughlin, Gladstone, Home Rule, and the Ulster Question, 1882–93 (Dublin 1986)
48. Alan O'Day, Parnell and the first Home Rule episode 1884–87 (Dublin 1986).
49. William Michael Murphy, The Parnell myth and Irish politics 1891–1956 (New York 1986).
50. Paul Bew, Conflict and conciliation in Ireland, 1890–1910: Parnellites and radical agrarians (Oxford 1987).
51. Gearóid Ó Tuathaigh. 'From United Kingdom to divided island: aspects of the Irish experience, 1850–1922'. In: Thomas Bartlett; Chris Curtin; Riana O'Dwyer; Gearóid Ó Tuathaigh (eds.), Irish studies: a general introduction (Dublin: Gill & Macmillan, 1988) 126–151.
52. Alan O'Day, Irish Home Rule, 1867–1921 (Manchester 1998).
53. Isaac Butt on Rome Rule Hansard 3 (commons), 3rd series, ccxx, 30th June 1874, (ed) A. Mitchell & P. Ó Snodaigh, Irish Political Documents 1869–1916 (Dublin 1989).
54. Gordon Lucy, (ed.). The Ulster covenant: a pictorial history of the 1912 Home Rule crisis. Belfast: Ulster Society, 1989.
55. B. M. Walker. Ulster politics: the formative years, 1868–1886. Belfast, 1990.
56. Alan O'Day. 'Home rule and the historians'. In: David George Boyce; Alan O'Day, (eds.), The making of modern Irish history: revisionism and the revisionist controversy (London and New York: Routledge, 1996).
57. Michael Foy. 'Ulster Unionist propaganda against Home Rule 1912–14'. History Ireland, 4:1 (1996).
58. Derry Kelleher, Home rule as Rome rule: the unspoken unionist and loyalist case (Justice Books, 7). Greystones, County Wicklow: Justice Books, 1997.
59. Margaret O'Callaghan, 'Franchise reform, "first past the post" and the strange case of Unionist Ireland'. Parliamentary History, 16 (1997), 85–106. Publisher: Sutton; Edinburgh University Press.
60. Jeremy Smith. Britain and Ireland: from home rule to independence (Seminar Studies in History). Harlow: Longman, 2000
61. Carla King. 'Defenders of the union: Sir Horace Plunkett'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001),
62. Gary Peatling. British opinion and Irish self-government, 1865–1925: from unionism to liberal Commonwealth. 2001.
63. Alan Megahey, '"God will defend the right": the protestant churches and opposition to home rule'. In Boyce, D. George; O'Day, Alan (ed.), Defenders of the union: a survey of British and Irish unionism since 1801 (London and New York: Routledge, 2001).
64. David Fitzpatrick, 'The Orange Order and the border'. Irish Historical Studies, 33:129 (2002), 52–67.
65. Brian Girvin, From union to union: nationalism, democracy and religion in Ireland – Act of Union to EU. Dublin: Gill & Macmillan, 2002.
66. Thomas C. Kennedy, 'Tory radicalism and the Home Rule crisis, 1910–1914: the case of Lord Willoughby de Broke'. Canadian Journal of History, 37:1 (2002), 23–39.
67. David George Boyce, 'Ireland and British politics, 1900–1939'. In Wrigley, Christopher John (ed.), A companion to early twentieth-century Britain (Blackwell Companions to British History) (Oxford: Blackwell Publishers, 2003), 102–17.
68. Catriona Burness, 'Strange associations': the Irish question and the making of Scottish unionism, 1886–1918. East Linton: Tuckwell, 2003.
69. Dan Jackson, '"Friends of the Union": Liverpool, Ulster, and Home Rule 1910–1914'. Transactions of the Historic Society of Lancashire & Cheshire, 152 (2003), 101–32. Publisher: Historic Society of Lancashire and Cheshire.
70. Gustave de Beaumont, L'Irlande sociale, politique et réligieuse, (Bruxelles: Société Belge de Librairie 1839). Reprinted 1990 (Lille: CERUIL GDR d'Etudes Anglo-Irlandaises du CNRS). An English translation by William Cooke Taylor was published in 1839 and reprinted 2006 by Harvard University Press.
71. David George Boyce, 'Ireland and British politics, 1900-1939', in: Christopher John Wrigley (ed), A companion to early twentieth-century Britain (Blackwell Companions to British History) (Oxford 2003) 102–117.
72. Michael Wheatley, 'These quiet days of peace' : nationalist opinion before the Home Rule crisis, 1909-13', in: David George Boyce and Alan O'Day (eds), Ireland in transition, 1867-1921 (London 2004) 57–75.
73. Cornelius O'Leary and Patrick Maume, Controversial issues in Anglo-Irish relations, 1910-1921 (Dublin 2004).
74. Alan Megahey, 'Irish Protestants feel this betrayal keenly' : Home rule, Rome rule and nonconformity', in: David George Boyce and Roger Swift (eds), Problems and perspectives in Irish history since 1800 (Dublin 2004) 164–179.
75. Ronan Fanning, 'The Home Rule crisis of 1912-14 and the failure of British democracy in Ireland', in: Maurice J. Bric and John Coakley, (eds), From political violence to negotiated settlement: the winding path to peace in twentieth century Ireland (Dublin 2004) 32–48.
76. Jeremy Smith, 'Federalism, devolution and partition : Sir Edward Carson and the search for a compromise on the Third Home Rule Bill, 1913-14', Irish Historical Studies 35:140 496–518.
77. David George Boyce, 'A place apart?: Ulster, Britain and devolution, 1886-1939', in: Wil Griffith, Duncan Tanner, Chris Williams (eds), Debating nationhood and governance in Britain, 1885-1945: perspectives from the 'four nations' (The devolution series) (Manchester 2006) 45–63.
78. John Privilege, Michael Logue and the Catholic Church in Ireland, 1879-1925 (Manchester 2009).
79. Stephen Ball, Dublin Castle and the first Home Rule crisis : the political journal of Sir George Fottrell, 1884-1887 (London 2008).
80. Russell Rees, Ireland 1900-25 (Newtownards 2008).
81. Daniel M. Jackson, Popular opposition to Irish Home Rule in Edwardian Britain (Liverpool 2009).
82. Alan F. Parkinson, Friends in high places : Ulster's resistance to Irish Home Rule, 1912-14 (Belfast 2012).
83. Gordon Lucy, The Ulster Covenant: An Illustrated history of the 1912 Home Rule crisis (Newtownards 2012).
84. James McConnel, The Irish Parliamentary Party and the third Home Rule crisis (Dublin 2013).
**The edition used in the digital edition**2. The Peril of Home Rule. With an Introduction by the Right Hon. Sir Edward Carson K.C., M. P.. Peter Kerr-Smiley (ed), first edition [xi + 144 pp.] Cassell & Company Ltd.London, New York, Toronto and Melbourne (1911)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


This electronic edition comprises pp i–xi of the Preface and 1–143, omitting the Preface and the Index on 144.


#### Editorial Declaration


##### Correction


Text has been proof-read twice and parsed using TEI-Emacs.


##### Normalization


the electronic text represents the edited text..


##### Quotation


Direct speech is tagged q. Quotations from books are tagged qt and included in cit tags, which may also contain a bibl element. 


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (and subsequent punctuation mark) crosses a page-break, this break is marked after the completion of the word (and punctuation mark).


##### Segmentation


div0=the whole text, div1=the chapter. Chapters are numbered; page-breaks are marked pb n=""/.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Names are not tagged. Titles of periodicals, such as newspapers, have been tagged.


#### Canonical References


This text uses the DIV1 element to represent the Chapter. ### Profile Description


Created: by Peter Kerr-Smiley
 (1911) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] Some words are in Latin.


### Revision History


* (2015-06) Beatrix Färber (ed.)

* Introduction and text proofed to end and structurally encoded; light content markup added; header created re-using bibliography of file E900030. File parsed.
* (1998?) Students at CELT (ed.)

* Text proofed to p. 80.
* (1998?) Students at CELT (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E900008-001


### The Peril of Home Rule: Author: Peter Kerr-Smiley




---

p.ix


### Introduction


For the third time within twenty-five years the Radical party, in coalition with the Socialists and Irish Nationalists, are determined, if possible, to break up the United Kingdom and to betray the loyal subjects of the King in Ireland. The efforts made to that end in 1886 and 1893 were frustrated by the electors of Great Britain as soon as the proposals, with their far-reaching and disastrous consequences, were understood by the people.


Since then a new generation has grown up, very few of whom remember the arguments which proved disastrous to the separatist conspiracy, and the present Government are determined that, if they can avoid it, the electors shall never have an opportunity of either understanding or pronouncing an opinion upon the proposals of 1912. But it is the first duty of the Unionist party to try and defeat this policy of tyranny. The aims and the objects are the same now as in 1893, and the disastrous consequences can be even more clearly demonstrated now than then. As


---

p.x



Mr. Balfour truly said, speaking at Ipswich on the 6th January, 1910: ‘I venture to think that while Home Rule had insuperable difficulties in 1886 and 1893, these have been augmented tenfold by the progress of events. Since those things have happened we have lent, or are in the process of lending, between 100 and 200 million sterling of British money. This country has made itself responsible for old-age pensions in Ireland, and we are under an obligation to pay these old-age pensions in Ireland as we are in England. There is a third consideration. The problem of national defence is incomparably more thorny in the year 1910 than it was in the year 1900 or 1890 or 1880. Are we really going to be told that we are to make Ireland practically independent of this country if she so desired it, that we are to separate ourselves from an island which, by the geographical necessities of the case, is predestined to be a part of one kingdom with ourselves?’ And, indeed, he might have added that since 1893 we had the experience of the Boer war, with the disloyal conduct of the Nationalist party, both inside and outside the House of Commons, during its progress.


I feel perfectly confident that now, as in 1893, all that is wanted to defeat Home Rule is that the electors should understand the subject. Much useful


---

p.xi



information as to the history and aims of this movement, and of the benefits the Union has conferred upon Ireland, is to be found in the pages of this little volume, written by an Irishman who represents in Parliament an Ulster constituency, who has lived amongst people who have felt the inestimable advantage of the British connection, and are determined not to be deprived of it without a struggle.


EDWARD CARSON.
  
5, EATON PEACE, W.


November, 1911.


---

p.1


Historical
----------


If we were to accept as an established fact what the Irish Nationalists say about Ireland, we must believe that it was an Island of Saints until the appearance of the English some seven hundred years ago. Unfortunately history does not agree with their description. It shows that from the earliest times the people of Ireland were composed of antagonistic clans split into warring factions, and, in fact, it was only by the infusion of the more solid and peaceful Saxon element that order has been brought out of chaos, and that unrestrained lawlessness has been gradually replaced by more civilised methods. Ireland's history has always been interesting, but rarely peaceable, as is evidenced by the fact that out of two hundred ancient kings of whom we have memorials, not more than thirty of them came to a natural death. The peasants lived in hopeless poverty, in fear of their tyrannical rulers. We are asked to believe that at one time, before the advent of the English,


---

p.2



Ireland was an independent, homogeneous nation governed from one centre, and that it was then a land enjoying peace and plenty. At no period in its history has Ireland been a united country. The Redmondite, the O'Brienite, and the Healyite factions had their counterparts in bygone days, and then as now they tried to compose their differences by physical force. Rival kings were as plentiful in those days as rival leaders are to-day. Fortunately or unfortunately, there was then no organised police force, and the rival factions settled their disputes by force of arms.


From the date of Strongbow's landing in Ireland (1170) as the emissary of Henry II. to carry out the Bull of Hadrian IV. (which gave Henry control of Ireland) until 1542, when Henry VIII. sent over an army to enforce allegiance to him, Ireland enjoyed between three and four hundred years of Home Rule Government, and that period is marked by feuds, plunderings and massacres by marauding bands. For centuries Ireland had refused to acknowledge the ecclesiastical pretensions of Rome, but ultimately she submitted to the Pope, and became a devoted, and in later ages a blind supporter of the Papacy, not only in religion, but in politics also. To this fact is mainly to be attributed a good deal of the friction between England and Ireland since the Reformation. When Protestant England threw off


---

p.3



the power of the Pope Ireland continued her allegiance to Rome, and she was constantly used by the Jesuits and foreign intriguers for the purpose of creating trouble for the Protestant Government of England. The chiefs of the Irish clans were in alliance with Spain and the Pope, and twice during the reign of Elizabeth Spanish expeditions landed in Ireland for the purpose of supporting rebellions against England. These rebellions naturally led to severe repressions, and so the trouble, fomented industriously as it was by foreigners, became more embittered. England was not strong enough to enforce her will on all parts of the country, and the Irish were not strong enough or united enough to drive out the English, and so both parties led a cat and dog life. The early attempts at colonising Ireland did not show much statesmanship. James I. was the first English ruler who devised a scheme of colonisation, which has exercised a lasting influence in Ireland. His plantation of Ulster with settlers drawn chiefly from Scotland was a bold measure of State policy, and has resulted in bringing what was one of the poorest and least favoured provinces to a state of prosperity which compares favourably with the conditions to be found in any other part of the British Isles. King James' colony of Protestants was formed in 1609, and in 1641 a carefully planned insurrection took place, which had for its object the destruction of all Protestants


---

p.4



in Ireland by a general massacre. Thousands of men and women and children were brutally murdered, simply because they were Protestants. Monro with an army of Scots was sent to Ulster to restore order, but he was defeated near Armagh in 1646, and the outrages on Protestants continued with unabated fury.


The task of subduing the Irish and of establishing protection for the Protestant settlers was then entrusted to Cromwell, who, on his landing in Ireland, said: ‘We are come to ask account of innocent blood that hath been shed, and to endeavour to bring to an account all who by appearing in arms shall justify the same.’ Cromwell certainly set about his work in a thorough manner, and the severity of his measures has been the chief theme of Nationalist speeches for many years. Those who condemn him forget that the people against whom he fought had been guilty of terrible atrocities. Cromwell challenged his enemies to give ‘an instance of one man since my coming into Ireland, not in arms, massacred, destroyed, or banished.’ Those who are loudest in their condemnation of Cromwell's campaign always forget that it was occasioned by the massacre of the Protestants in Ireland. They also neglect to mention that at the same period more severe methods were adopted as a common practice by Roman Catholic Governments in Europe towards their Protestant subjects. As Green the


---

p.5



historian points out, the result of Cromwell' campaign was that ‘peace and order were restored and a large incoming of Protestant settlers from England and Scotland brought a new prosperity to a wasted country. Above all, the Legislative Union which had been brought about with Scotland was now carried out with Ireland, and thirty seats were allotted to its representatives in the general Parliament.’ Cromwell held that ‘if then was to be a prosperous, strong, and united kingdom there must be one Parliament, and one Parliament only, exercising authority over the three countries.’ It was a great pity that the union which was devised by Cromwell lasted for such a short time, having been dissolved by Charles II in 1660.


James II., who was an undisguised Romanist, when he saw that the people of England were opposed to him and his policy, thought that the best way of arresting the progress of William III. was to place Ireland in such a position of independence ‘that she might serve as a refuge for his Catholic subjects.’ It is worth noting that James' idea is the one which actuates the overwhelming majority of those who are now agitating for Home Rule. Underlying the whole Home Rule movement is the strong desire to make Ireland an entirely Roman Catholic country, which may be used at a suitable moment as a base for attack upon the Protestantism of England. James II. set about



---

p.6



his work in Ireland with more energy than he had ever displayed in England. A Protestant Lord Lieutenant was dismissed, and the Earl of Tyrconnell, a Roman Catholic, appointed in his place. Protestants were driven out of every position of honour or trust, and their places given to Roman Catholics. Every judge, privy councillor, mayor, or alderman of a borough was required to be a Roman Catholic. A massacre similar to that of 1641 was expected every day, and large numbers of Protestant families fled in terror from the South of Ireland. James' Parliament in Dublin promptly set to work to confiscate by legislative enactment all the property owned by Protestants. In the North the Protestants concentrated at Enniskillen and Londonderry for self-defence. Tyrconnell was enraged at the defiant spirit displayed by the Northern Protestants, and as soon as he had received men and ammunition from France he sent in 1689 a large army to Londonderry to crush them.


The city was defended by a weak wall on which a few old guns were mounted. Tyrconnell's force laughed at the very idea of a few thousand untrained men attempting to hold the city against such a strong besieging army. But what the men inside the walls lacked by way of munitions of war and military skill they more than made up for by courage and a grim determination never to surrender. The governor of the city, Lundy, was a


---

p.7



time-server, and, failing in his attempted betrayal, deserted them. At first they were without leaders, and in addition to the lack of arms and ammunition food was very scarce. ‘But,’ as Macaulay, the historian, writes:*‘Within was that which has often retrieved the fallen fortunes of nations. Betrayed, deserted, disorganised, unprovided with resources, begirt with enemies, the noble city was still no easy conquest. Whatever an inquirer might think of the strength of the ramparts, all that was most intelligent, most courageous, most high-spirited amongst the Englishry of Leinster and of Northern Ulster was crowded behind them. The number of men capable of bearing arms within the walls was seven thousand, and the whole world could not have furnished seven thousand men better qualified to meet a terrible emergency with clear judgment, dauntless valour, and stubborn patience. They were all zealous Protestants, and the Protestantism of the majority was tinged with Puritanism.’’’*

 History of England. , Chap. xii.




Before the fight had gone on many days the Irish and French army saw that there was not much chance of capturing Londonderry by assault, and then it was decided to starve the garrison to death. The invading army drew its lines so tightly around the city that it was impossible to get in fresh supplies of food. The Protestants died of hunger and of the diseases which come from


---

p.8



hunger, but even in the most terrible straits the cry which rose from the lips of the famishing and diminished garrison was ‘No surrender.’ Rosen, the cruel French general, gathered all the Protestants he could find in the surrounding country, and dragged them to the walls of the city in the hope that their pitiable condition would compel the defenders to yield. These poor creatures, thousands of whom were dying from hunger and exposure, regardless of their own sufferings, entreated those inside the city never to surrender. The siege lasted one hundred and five days, and in that time the defenders were reduced from seven thousand fighting men to three thousand. Only two days' food remained in Londonderry when an English ship broke the boom which had been placed across the river by James' army to block the passage. Then James' army quickly retired southward, and its retreat was turned into a panic by the Enniskillen men, who charged and routed an Irish force twice their number. The subsequent defeat of James at the Boyne shattered all his fond hopes of establishing a Roman Catholic kingdom in Ireland, and laid wide and deep the foundations of civil and religious liberty. The men of Ulster, who are the descendants of the same stock as the heroes who dared so much and suffered so much for freedom in the defence of Londonderry, are naturally proud of these great deeds, and it would be surprising if they meekly submitted to have the


---

p.9



old yoke of ecclesiastical tyranny fastened around their necks and the necks of their children. They can never forget that they belong to a race which ‘may be destroyed, but will not easily be subjugated.’ As Macaulay well says: ‘The descendants are justly entitled to celebrate the anniversaries connected with the siege of Londonderry, for a people which takes no pride in the noble achievements of remote ancestors will never achieve anything worthy to be remembered with pride by remote descendants.’


No one who reads history with an open mind will deny that the penal laws which were passed subsequent to the reign of William III. bore heavily upon Roman Catholics, but Home Rulers who harp on the penal laws of long ago generally omit to state that Irish Presbyterians, who are now among the strongest upholders of the Union, were under almost as many disabilities as Roman Catholics. Whatever the grievance of this or that denomination may have been in the past no man is under any disability in Ireland to-day because of the religious opinion he holds. It does not strengthen the arguments for Home Rule to reiterate, as the Nationalists often do, that the Roman Catholics suffered under the rule of Cromwell or of Queen Anne. The important fact to bear in mind is that still greater miseries existed and greater injustices were perpetrated under the Irish Parliament when controlled by Roman Catholics.



---

p.10



It was then simply a case of one religious party oppressing the other when it had the power. But, under the strict and impartial government of the Imperial Parliament, ascendancy of every kind has been shattered, and all Irishmen now occupy an equal position before the law, and they share equally with Englishmen and Scotsmen the great privilege of being partners in the most glorious Empire the world has ever seen. If there is a grievance at all it is with the people of Great Britain, for Ireland is represented in the Imperial Parliament greatly in excess of the number of her population.


The peace, prosperity and good government of Ireland no less than the safety of England demand that there shall be only one supreme and controlling authority in the United Kingdom. Even before Cromwell's day there were great statesmen in England who saw that nothing but mischief and disaster could result from having rival Parliaments in London, Dublin, and Edinburgh. The policy of unification which these far-seeing statesmen advocated for the common good of the whole kingdom has been adopted in later years by almost every leading nation in Europe, to say nothing of the United States, which made such great sacrifices half a century ago rather than allow the country to be separated into two antagonistic parts.


Mr. Lecky, the historian, in a striking passage, says:


---

p.11



‘In the lifetime of those who have attained middle age three great works have been accomplished in the world which far transcend all others in importance, and of which it is probably no exaggeration to say that the memory can never pass while the human race remains upon this planet. One of them, which is connected with the great name of Cavour, was the movement of unification by which the old and illustrious, but weak because divided, States of Italy were drawn together, and fused into one great and prosperous kingdom.
  

Another, which is chiefly connected with the name of Bismarck, was that movement of unification which has made Germany the most powerful nation upon the Continent. The third, which may, I believe one day be thought the most important of the three was due much less to the genius of any statesman than to the patriotism and courage of a great democracy. It was the contest of America with the spirit of secession which had arisen within its borders, and although that spirit was spread over a far larger area than Ireland, although it existed over that area in a far larger proportion of the population than in Ireland and was supported by an immeasurably greater amount of earnestness and self-sacrifice, it has now disappeared, and the present generation of Americans have in all human probability secured for centuries the unity of the great Republic of the West.
  

These great works of consolidation have been the contributions of other nations to the nineteenth century. Shall it be said of English statesmen that


---

p.12



their most prolific and characteristic work has been to introduce the principle of dissolution into the very heart of their Empire?’


History as well as experience points to the folly of setting up separate Governments in three countries which must for a variety of reasons remain one Kingdom, controlled by one common Parliament.




---

p.13


A Subordinate Parliament
------------------------


In trying to cajole British electors into supporting Home Rule, Nationalists are in the habit of stating that all they desire is a subordinate Parliament with strictly limited powers. As will be shown in a subsequent chapter, what they really want is a Parliament absolutely independent of Great Britain. Subordinate Parliaments have the habit of becoming very insubordinate at times as the history of Irish Parliaments shows. At the time of the Wars of the Roses during that period of England's difficulty English authority was challenged in Ireland, the Anglo-Irish and their Parliament taking the side of the White Rose and acknowledging Perkin Warbeck as King of Ireland in rivalry to Henry VII., the lawful King of England. The inevitable result was the passing in 1495 of Poynings' Law, which deprived the Irish Parliament of all legislative initiative and independence. It was thereby declared that no Act could become law in Ireland until it had received the assent of the English Parliament. Naturally the Irish Parliament, which with a brief interval had been absolutely supreme from 1295, chafed under this restriction, and



---

p.14



missed no opportunity of thwarting the English Parliament.


Again, the American Revolution has its object lesson. The employment of the English troops in America, where the colonists were in revolt, and the wars with France, necessitated the withdrawal of the army from Ireland. The men who objected to the restrictions placed on the Irish Legislature considered that now was the time to strike for independence. England was helpless, and she surrendered unconditionally in the hour of her difficulty, and thus what is known as Grattan's Parliament was constituted. By the Constitution of 1782 this Irish Parliament became absolutely free and independent, and there was no limit whatever to its legislative powers. The Irish Parliament and the Parliament of Great Britain had equal and independent powers, and there was no link holding them together save that of the Crown. If the Irish Parliament passed legislation injurious to Great Britain the only remedy was for the Crown to refuse its assent, but in practice this power did not prove of any service, for the Irish Parliament by administrative Acts was able to carry out its own policy in spite of the English Government. The Irish Parliament was able to pursue its own course with regard to trade, commerce, foreign policy, treaties, and other relations with foreign Powers.


The Parliament which the Nationalists demand is an independent Parliament as free from the influence 


---

p.15



and jurisdiction of the Imperial Parliament as are the Parliaments of our great self-governing Colonies. Theoretically, no doubt, the Imperial Parliament reserves the right of sovereignty over the Colonial Parliaments. But that power cannot be used, because the Colonial Parliaments would not brook the interference of the Imperial Parliament, and neither would an Irish Home Rule Parliament, once it was strong enough to resist. It is important, therefore, that the British people should clearly realise that a Home Rule Parliament will not only be supreme in Ireland, but the Irish people, if the principles of Mr. Gladstone's second Home Rule Bill are adhered to, would also have the deciding voice in making and unmaking British Governments. If differences arose between the two Parliaments, as they constantly did during the last Irish Parliament, the Imperial Parliament could only enforce its wishes by force of arms. Any arrangement that is made is bound to give occasion for constant quarrels. There can be no half-way house. Either the Imperial or the Irish Parliament must be supreme in Ireland. The delegation of power to a subordinate Parliament in Ireland has been tried, and it has proved such a complete failure that it is difficult to understand why it should be proposed to try the unfortunate experiment again.


The men who sat in Grattan's Parliament were entirely Protestant, and owing to their origin


---

p.16



their sympathies were naturally favourable towards England, but despite that fact the friction which continually occurred between the two Parliaments was such as to lead many of them to intrigue with foreign countries for the purpose of overthrowing English power in Ireland.
An Irish Parliament to-day would be largely composed of Nationalists who have never tried to hide their hatred of England, and it is folly to imagine that in a time of the Empire's difficulty these men would support a country they hate. How their sympathies are swayed can be best illustrated by their action during the war some years ago between the United States and Spain. Most of the money which has kept the Home Rule agitation alive for many years has come from the United States, and yet when that country was at war with a Roman Catholic nation for the freedom of Cuba, the sympathy of the Irish Nationalists went out towards their Spanish co-religionists, and their principal organ in the newspaper Press expressed the hope that Spain would win. If Great Britain went to war with a Roman Catholic country, and there was an Irish Parliament sitting in Dublin, nothing is surer than that it would use its power for the purpose of assisting its co-religionists, openly or secretly.


During Grattan's Parliament secret emissaries were sent to France to encourage that country to attack England, and on two occasions the French


---

p.17



invaded Ireland. Thanks to a storm rather than to any means of defence the French ships, which carried a formidable army, were scattered in Bantry Bay in the winter of 1796. But two years later the danger was more serious. A large body of troops under the French General Humbert landed at Killala, and after defeating General Lake at Castlebar, won another battle near Sligo, and crossed the Shannon. This force was only defeated by greatly superior numbers under Lord Cornwallis. Had the French landed at a different time they might have succeeded in achieving what is still the avowed aim of the Nationalists — namely, the ‘driving of the English, bag and baggage, out of Ireland.’


No matter from what point of view it is examined, the Irish Parliament was anything but a success. So far as England was concerned, it was a constant menace to her very existence. Revolutionary schemes against England were continually being hatched which might easily have resulted in serious consequences. In Ireland itself there was neither freedom nor good government. Political parties used their position for the purpose of securing lucrative berths for their supporters. Nationalists talk a great deal of nonsense about the prosperity which the country experienced during Grattan's Parliament. This so-called prosperity is nothing more than a legend. Ireland was never in a much worse condition. The murderings, the plunderings, the


---

p.18



outrages, the corruption — all the outward and visible signs of an incompetent Government — shattered confidence. Men's minds were unsettled, and they were unfitted for the more serious and prosaic duties of life. Class was set against class as it would be under a Home Rule Parliament. Whiteboyism and the terrorism of secret societies were rampant, and two or three Coercion Acts were passed each year. The history of that period is one of the darkest Ireland has ever known. By revolutions and their suppression the country was being continually drenched in blood.


The last great tragedy before the Union was due to the formation of a society known as the United Irishmen, founded in 1791 by a revolutionary politician named Wolfe Tone, who was one of the principal agents in the intrigues with France. In the North the movement received some support from Presbyterians, who were discontented with the way in which the affairs of the country were managed. The movement was taken up by the Roman Catholics of the South of Ireland, but when the rebellion broke out in 1798, ostensibly to reform the Government, the Presbyterians were speedily disillusioned by the wholesale massacre of Protestants in those districts where the Roman Catholics were in the majority. A movement which originated in the idea of establishing equality irrespective of religion soon developed into a religious war, and the Government therefore had very little difficulty


---

p.19



in stamping out the rebellion. Pitt, who favoured a Union and wide reforms, saw the great danger of the situation and determined to put an end to an intolerable condition of affairs. It was neither safe for Great Britain nor good for Ireland to have a Parliament which was continually conspiring against England abroad and at home, and had increased the Irish National Debt from £2,444,890 in 1791 to £25,662,540 in 1800, when the Irish Parliament was dissolved. The evils exhibited by the Irish Parliament would be repeated by a Home Rule Parliament such as Mr. Gladstone tried to establish in 1893. The causes which led to civil strife in the past are still active in Ireland, and all the old objections to two Parliaments which influenced Pitt, in his decision that safety for Great Britain and peace for Ireland could only be attained by a Legislative Union between the two countries, are as strong and as unanswerable as ever. In the words of Pitt:
  

‘Within the short period of six years from what is called the independence of the Irish Parliament, the foreign relations of the two countries, the commercial intercourse of the two countries, the sovereign exercise of authority in the two countries were the subject of litigation and dispute, and it was owing more to an accident than any other cause that they did not produce actual alienation and rupture.’


If the people of Great Britain are wise they will not run the same risk a second time; they


---

p.20



will not again incur dangers which may imperil the stability of the Empire and cause civil war in Ireland. Nothing is more probable than that an Irish Parliament would embarrass England at a critical moment and compel her to grant complete independence, which, despite all their honeyed words in Great Britain, is the ultimate aim of the principal Irish movers in the agitation for Home Rule.




---

p.21


The Union
---------


Pitt's political insight showed him that the only way to safeguard the interests of the Empire and promote the interests of Ireland was to unite Great Britain and Ireland under one Parliament. The Irish Parliament had become too corrupt to last; and from its past history there was no hope that it would establish justice, order, and fair play in the land, and so permit the development of industries and prosperity. The Union was necessary for the safety of Great Britain, which at that time was engaged in a struggle for existence. As Lord Rosebery has put it:
  

‘We formed the main object of an enemy who had conquered half Europe. Twice had that enemy invaded Ireland, and it was certain that an invasion of England was only a question of time. In so appalling a crisis a new arrangement had by the admission of all parties to be formed for Ireland. Grattan himself had tacitly given up his own Parliament, for he had withdrawn from it and encouraged the discussion of Irish affairs in the British Legislature. What wonder, then, if from the natural tendency to draw closer and closer yet in


---

p.22



the presence of an overpowering danger men's minds should have turned with rare unanimity to the idea of a Union. . . . What would happen if in war, as on the Regency question, the British Parliament should take one side and the Irish Parliament the other?’


The authors of the Union desired that all ascendancy should be put down at the time the Irish Parliament was dissolved, and it was really owing to the action of men who are much belauded as patriots by the Nationalists of to-day that the reforms were delayed for some years. It is well, however, to emphasise at this stage that there is now no ascendancy in Ireland except the ascendancy of secret societies manipulated in the interests of the Nationalist party.


It is a part of the stock-in-trade of Home of Rule agitators that the Irish Parliament was filched from them by means of corruption. No one will deny that bribes were given to secure a majority for the Union in the Irish Parliament. The leaders of that Parliament lived very largely by corruption, and nothing was more natural than that they should resist any attempt to abolish their office and with it their opportunity of living by corruption. A Cromwell might have dealt differently with the Irish Parliament. Accompanied by a troop of soldiers, he would probably have entered the Parliament House in College Green, and without any ceremony reminded the


---

p.23



members of the evils they had brought upon Ireland, the peril they had caused to England, and ordered them out of the place. Whatever may have been the opinion of a section of that Parliament, there is no doubt that the overwhelming majority of the Irish people were enthusiastically in favour of the Union. The Roman Catholics, whose views were voiced by their bishops, gave to the Union an almost undivided support. A large proportion of the United Irishmen who had taken part in the rebellion of 1798 welcomed the Union because they saw in it an instrument for the removal of their grievances. Whatever, therefore, may be said of the means employed for securing the Union — and they were such as were commonly employed by all political parties in those days — it is an undisputed fact that the compact had the approval of the vast majority of Irishmen. Mr. Redmond and his followers never tire of telling us that the Union has been a failure and that every difficulty which Ireland has experienced since 1801 has been caused by the Government of the Imperial Parliament. When the statement is examined in the light of history it is found to be baseless. The frequent rebellions and the systematic corruption which marked the course of the Irish Parliament had brought the country to the verge of bankruptcy. As has been shown, the National Debt rose at an alarming rate, and the country was not only unsettled, but desperately


---

p.24



poor. The good effects of the Union were felt from the very first. Ireland's credit rose, industries sprang up, and in less than forty years the population almost doubled itself. All these changes were the direct result of settled Government, and they effectively dispose of the unfounded, but oft-repeated, charge that Ireland suffered because of the destruction of her Parliament. Mr. John Redmond asks: ‘What greater test of good Government is to be found than the test of population?’ If he is prepared to accept his own test, then Ireland must have had good Government during the first forty years of the Union. But Mr. Redmond is careful to slip over this period and to base his argument against the Union on causes which have no more to do with the form of Government in Ireland than with the sun-spots. The Imperial Government no doubt made mistakes in the early years of the Union just as it made mistakes in England and Scotland. Owing to political and religious rancour, reforms which Pitt and Castlereagh had intended to carry out were delayed for some years. The delay to Catholic Emancipation served as a pretext in O'Connell's day for the agitation in favour of the repeal of the Union. It was easy for a man of the ability and eloquence of O'Connell to rouse his co-religionists to action, especially when matters affecting their faith were involved. The vigorous agitation which he started resulted in the concession of Catholic Emancipation


---

p.25



 in 1829. Elated by the success of the movement, he sought to have the Union dissolved, but English statesmen of that day had too much experience of an Irish Parliament to tolerate its resuscitation. Wellington, who knew Ireland well, had no doubt that the repeal of the Union would lead to a religious war. Sir Robert Peel, who had served as Chief Secretary for Ireland, declared in 1834 that the repeal of the Union must lead to the dismemberment of the Empire and render Great Britain a fourth-rate power in Europe. In O'Connell's day there was no difference of opinion between the two great political parties as to the evils that would proceed from the dissolution of the Union, and they unitedly resisted the demands for repeal. O'Connell himself during the course of the agitation declared that, provided the Imperial Parliament did justice to Ireland, he was prepared to abandon repeal; his only reason for being a repealer was, what he termed, the injustice of the Government to Ireland. He went even further and said that he would rather see justice done to his countrymen by the Imperial Parliament than by a local legislature.


Mr. Redmond takes a different attitude, for he says he would rather see Ireland badly governed by an Irish Parliament than well governed by the Imperial Parliament. ‘The true ground to take,’ said O'Connell, ‘is Ireland on an equality with Great Britain or no Union.’ Ireland is certainly


---

p.26



on an equality with Great Britain to-day. She has a much larger representation in the House of Commons than she is entitled to by population. If there is a legitimate grievance now regarding the government of the three kingdoms, Ireland has not got it. The legislation of recent years has been marked by generosity towards Ireland, and every possible effort has been made to atone for the omissions of earlier years. Ireland as the poorest partner in the Union is being well treated by Great Britain, and there is no justification whatever for the attacks which the Nationalists have made on British Government in Ireland. Indeed, at times when the Nationalists are charged with being neglectful of the interests of their country, they point to the great concessions which have been gained, and though the majority of the concessions have been secured in spite of the opposition of the Nationalists, they amount to a very considerable number.


There is not a scintilla of proof put forward on behalf of Mr. John Redmond's statement that the Union dealt a deathblow to Irish prosperity. On the contrary, the first forty years of the Union witnessed unparalleled development in Ireland. A few figures will suffice to dispose of Mr. Redmond's ‘deathblow to Irish industry’ argument. At the time of the Union the tonnage of Irish ships was 112,333; in 1845, 631,981; and in 1909, 8,300,576. The statistics giving the value of Irish imports


---

p.27



and exports at different periods show the progress Ireland has made:



| Periods | Value of Imports | Value of Exports |
| --- | --- | --- |
| 1790 | £3,535,588 |  |
| 1790 | £3,535,588 | £4,125,383 |
| 1826 | 7,491,890 | 8,454,918 |
| 1836 | 15,337,097 | 17,394,813 |
| 1904  | 54,209,477 | 50,244,958 |
| 1905 | 55,759,452 | 51,972,708 |
| 1906 | 57,441,152 | 56,616,749 |
| 1907 | 61,579,426 | 59,815,188 |
| 1908 | 59,006,877 | 58,010,891 |
| 1909 | 63,947,155 | 61,728,692 |



 

Since 1904 the total import and export trade of Ireland increased from £104,454,435 to £125,675,847 in 1909.


In view of these figures it requires more than ordinary courage on the part of Mr. John Redmond to write that the tide of prosperity turned at the time of the Union and that ‘it has been on the ebb ever since.’ There are other figures as well as those of imports and exports which point to the steady progress Ireland has made and is making. Going no farther back than 1852, we find that the deposits in the Irish Joint Stock Banks amounted to £10,773,000; in 1885 they had increased to £29,370,000; and in 1911 to £56,011,000.


In 1893, when Mr. Gladstone's last Home Rule Bill was introduced, the deposits and


---

p.28



cash balances in the Irish banks amounted to £34,637,000, so that the increase in the interval amounts to over twenty millions sterling. These figures must surely be taken as evidence of the increasing wealth of the country.


In 1851 there was £1,347,617 in the Trustee Savings Banks. Post Office Savings Banks were not established until 1861. In 1884 the combined deposits in the Trustee and Post Office Savings Banks amounted to £4,343,783. When we come down to the present time we find that marvellous progress has been made.


If we turn to the Post Office Savings Banks we find that the amount deposited in them has increased from £4,155,000 in 1893 to £12,253,000 in 1911. Between 1893 and 1911 the deposits in Trustee Savings Banks have grown from £1,876,000 to £2,857,000. The combined balances in the Post Office and the Trustee Savings Banks amounted in 1911 to £15,110,000.


When all these sums are added together they make a substantial total for a country which is represented by the Nationalists to have been bled white by the Imperial Parliament.


The reduction of Ireland's population, which did not begin until nearly half a century after the Union, was chiefly owing to economic causes. Mr. Joseph Devlin, M.P., a prominent Nationalist, speaking at Draperstown on June 29th, 1911, said:


---

p.29



‘One of the chief causes of the emigration of so many of our young men and women is probably the monotony, the lack of variety or of interest in country life. It is all work and no play, one dreary round from morn till night, without anything novel, either to interest or to amuse. You cannot blame young people for flying from a life like that. The call of patriotism is all very well, but the instinct of human nature is stronger even than patriotism, and if you want these people to remain at home you must make
 home life more attractive for them.’


The failure of the potato crop and the subsequent famine were not due to the action of the Imperial Parliament. Agriculture being practically the only industry, and the land having been subdivided so that the holdings were barely able to support the occupiers in good years, the failure of the principal crop drove thousands of Irishmen to America. This misfortune took place at an interesting period in the history of the United States. The introduction of the steam engine had led to wonderful developments. The United States then, like Canada to-day, was calling for men to open up its vast tracts of virgin soil. Naturally, good wages were paid, and the news of the prosperity of the New World spread through every parish in Ireland. The man who in Ireland had scarcely been able to eke a living out of his patch of land was able to get remunerative work in America, and so he went there and encouraged


---

p.30



his friends to join him, and the stream of emigration went steadily on. An Irish Parliament could not have stopped it unless by preventing ships from calling at Irish ports. In the agricultural districts in England and Scotland the decline of the population has of late been as severe as in Ireland. Those countries, however, by means of their great urban industries, have been able to keep a larger proportion of their people at home. In an agricultural country like Ireland it was natural, in view of the better wages to be earned in industrial employment elsewhere, that emigration should be large. The changes from which Ireland has suffered have been almost general in agricultural countries, and it is unfair, therefore, to attribute it to the Union. Ireland's progress in wealth during the last thirty years has been remarkable, and there can be little doubt that it would have been greater still had it not been for the action of Nationalist agitators, who are reckless of the effects of their agitation upon the agencies at work for the promotion of the material welfare of the country.


When Nationalists talk of the number of Coercion Acts that have been passed, they conveniently ignore the causes which have brought them into operation. As Mr. Gladstone said, ‘crime dogged the steps of the Land League; murder was its weapon, the murder that was not to be denounced.’ The agitators coerced helpless


---

p.31



peasants and terrorised jurors, so that they were afraid to administer justice, but the moment the authorities adopted methods for the vindication of the law and the protection of peaceful citizens, a great howl went up about coercion. No law-abiding man had ever a grievance against any Coercion Act passed since the Union. Lawbreakers no doubt resent any act which restricts their violent methods. When successive Governments adopted effective means for breaking up criminal societies, they were charged with coercion. It ought not to be forgotten that the powers contained in the so-called Coercion Acts to which Nationalists take exception form part of the common law of Scotland. Peaceable law-abiding Scotsmen do not suffer in consequence, and neither do those Irishmen who are prepared to extend the same measure of liberty to others that they demand for themselves.


A common objection on the part of Nationalists to the Union is that the Government of Ireland is costly. The Government is certainly expensive, and this is due to two causes. The first is that the Government does more for Ireland than it does for any other country. In the last twenty-five years a vast volume of remedial legislation has been passed, and naturally every new department established to help the people adds to the cost of Government. If the Board of Education, the Board of Works, the Department of Agriculture,


---

p.32



the Congested Districts Board, and the Land Commission were abolished, it would be possible to save large sums, but no one dares to suggest that the work of these institutions should cease.


The second cause of high expenditure is the police force. It is necessarily large because of the lawless habits which the Nationalist agitators promote among their supporters. It cannot be said that this force exists for the maintenance of the Union, for, strange to say, it is largely required to prevent warring Nationalist factions from annihilating each other. There is an easier way of reducing the expenditure on the administration of the criminal law than by destroying the Union, and that is by obeying the law. Once Nationalists become as law-abiding as Englishmen and Scotsmen, the cost of the police force will be reduced automatically.


No matter what honest test may be applied, the Union will be found to have been a success, and the surest way of helping Ireland is to maintain the rule of the Imperial Parliament, under which fair play and justice are dealt out to every Irishman.




---

p.33


The Home Rule Movement
----------------------


The Home Rule movement has passed through many phases since O'Connell's Repeal agitation, but in one essential it has never differed, and that is in the proposal to establish a Parliament in Dublin, which, while called subordinate, would assuredly become insubordinate, and at an opportune moment cut the connection with Great Britain. O'Connell was too moderate in his views for the Young Irelanders, just as the Federalism of Butt and Shaw was not strong enough for Parnell, who publicly declared he would never rest satisfied until the last link that joined Ireland to England was severed. The object of the Home Rule movement was, by the use of force, to coerce England to break up the Union. It was only when Home Rule was linked to the land agitation that it got a real hold on the bulk of the Roman Catholic people. They wanted to be rid of landlords, and the professional agitators told them that the only way to achieve this end was to support the Home Rule movement. Parnell was a capable leader, and he knew how to utilise the votes of the farmers to drag along


---

p.34



Home Rule. In 1885 his chance came. Mr. Gladstone, who had for years vehemently and eloquently denounced all Home Rule proposals as dangerous to Great Britain and inimical to the best interests of Ireland, appealed to the electors to give him a majority independent of the Nationalist party. The country did not respond to that appeal, and, as readers of his life by Lord Morley can see, it was after anxious hesitation and when he lost the flower of his Cabinet that he lowered the flag to Parnell, and, as is generally the case with people who change their faith, he threw himself with great energy into the struggle. Had Gladstone been in a position to do without the Nationalist vote, it is most improbable that he would ever have pledged his party to Home Rule.


On December 24th, 1885, he wrote: *‘I used every effort to obtain a clear majority at the election, and failed. I am therefore at present a man in chains.’’’*

(Morley's Life of Gladstone. )




The chains soon began to tighten round him, and they are being drawn still closer to-day round Mr. Asquith and his party. In 1886 Mr. Gladstone brought in his first Home Rule Bill, the main outlines of which were as follows:
  

LEGISLATURE.— An Irish Parliament composed of two orders, to sit in Dublin, for the conduct of legislation and the administration of Irish affairs. Irish members to cease to sit at Westminster.


---

p.35



VICEROYALTY.— Lord Lieutenant, with a Privy Council, who would be independent of Great Britain.
  

JUDGES.— If they so desired, to retire on pension. Future Judges to be appointed under the Irish Government, and their salaries charged on the Irish Consolidated Fund. Judges to hold office during good behaviour, and to be removable by joint address from the two orders of the Irish Legislature.
  

IRISH CONSTABULARY.— After two years the Irish Legislature to have power to fix the charge for the whole police and constabulary of Ireland, with a saving of existing rights.
  

CIVIL SERVICE.—To be absolutely under the Irish Legislature. Existing Civil Servants might retire after two years.
  

IMPERIAL CHARGES.— Ireland to contribute one-fifteenth of these charges. Estimated result: Revenue, £8,350,000; charges (including those payable for Army and Navy), £7,946,000; surplus, £404,000.
  

TAXATION.— Powers of taxation, except as to Customs and Excise, to be exercised by the Irish Legislature.
  

RESTRICTIONS.— Irish Legislature not to interfere with the Army or Navy or with foreign or colonial affairs, and not to enact any religious endowment. While unable to alter the fiscal system, it would have had power to levy any internal taxes it pleased.




---

p.36


Mr. Chamberlain and Mr. Trevelyan resigned their seats in the Cabinet as soon as they became aware of the terms of the Bill. Lord Hartington, Mr. Goschen, Lord Northbrook, and Mr. John Bright had previously refused to join the Cabinet because they had knowledge of Mr. Gladstone's intentions. In a letter to Mr. Gladstone (May 13th, 1886) Mr. Bright wrote, in regard to the Home Rule Bill:
  

‘I cannot consent to a measure which is so offensive to the whole Protestant population of Ireland and to the whole of the province of Ulster as far as its loyal and Protestant people are concerned. I cannot agree to exclude them from the protection of the Imperial Parliament.’


Mr. Bright went on to point out that Mr. Gladstone's surrender to the Nationalists ‘will only place more power in their hands to war in greater effect against the unity of the three kingdoms with no increase of good to the Irish people.’


A great many of Mr. Gladstone's political friends, amongst whom were numbered some of the most intellectual men of the period, left him. In Ulster, before his surrender to Mr. Parnell, he had a strong following, but almost to a man they left him the moment he deserted Liberalism and accepted the Home Rule policy. Their attitude in the succeeding years has been the same as Mr. Gladstone's was prior to his surrender after the 1885 election.




---

p.37


Mr. Gladstone's Bill of 1886 was rejected in the House of Commons by 343 to 313 — majority, 30. Ninety-three Liberals voted in the majority. Mr. Gladstone appealed to the country, with the result that the Unionist party was returned with a majority of 110.


In 1892 Mr. Gladstone was returned again to office. In the meantime the Parnellite split had occurred, and Lord Morley thinks it did a great deal of harm to the Liberal party. In his Life of Gladstone he deals at some length with this episode, but for some unexplained reason he does not mention that Parnell was defeated by the power of the priests. Parnell had attained to greater influence over the Irish people than any other leader the country has ever produced, and yet the moment the priests gave the word the men who were formerly his worshippers promptly hounded him to death. In Ireland the Roman Church is still able to dictate whatever terms it pleases to Nationalist leaders.


On February 13th, 1893, Mr. Gladstone laid his second Home Rule Bill before the House of Commons, and its principal features were:
  

PREAMBLE. — ‘Without impairing or restricting the supreme authority of Parliament.’ These were mere words, for the Bill reduced the authority of the Imperial Parliament to a nullity.
  

LEGISLATURE. — Irish Legislature to deal with matters exclusively relating to Ireland or some


---

p.38



part thereof. Eighty Irish members still to sit at Westminster, to vote on Imperial affairs.
  

VICEROYALTY. — Viceroy to have power to veto Bills relating to Ireland on the advice of Irish Privy Council, but subject to the instructions of the Sovereign.
  

JUDGES. — ‘Irremovable’ clauses and a proviso to secure emoluments. Two Exchequer judges to be appointed by the Crown for the purpose, ‘mainly of financial, but generally of business which is Imperial.’ The other judges were to be appointed by the Irish Government.
  

IRISH CONSTABULARY.— Gradual reduction, with ultimate dissolution of the force.
  

CIVIL SERVICE. — Provisions for safeguarding existing interests.
  

IMPERIAL CHARGES. — Irish balance-sheet — revenue, £5,660,000; expenditure, £5,160,000; surplus, £500,000. Provision, Ireland to contribute one-twentieth to the cost of Imperial expenditure. This was afterwards altered to one-twenty-sixth.
  

PROVISO. — Against religious establishments and to assure personal freedom. It was never explained how this proviso could be enforced against a Dublin Parliament.
  

RESTRICTIONS. — Irish Legislature incapable of dealing with anything relating to the Crown, Regency, Viceroyalty, Army and Navy, peace and war, defence) treaties, and foreign relations,


---

p.39



 dignities and titles, laws of treason, law of alienage, external trade and coinage.


The Bill was carried through the House of Commons by a purely Irish majority, but on September 1st, 1893, it was thrown out by the House of Lords on second reading, 41 peers voting for and 419 against — majority, 378. As on the former occasion the country, when appealed to, approved of the rejection of the Home Rule Bill.


Mr. Birrell, the Irish Chief Secretary, has advised the public to study Mr. Gladstone's Home Rule Bill of 1893, which has been taken as a hint that Mr. Asquith is determined to proceed on the same lines as Mr. Gladstone's second effort. Indeed, if Mr. Asquith wished to offer less than Mr. Gladstone Mr. Redmond would not allow him. It is quite true that Mr. Redmond when addressing audiences in England is addicted to the use of mild language, but he has to alter his tone when speaking in Ireland or in the United States. There he has to consider Mr. Patrick Ford and the leaders of the Fenian organisation, and the other extreme men who are behind him; and even if Mr. Redmond was willing, these men would not permit him to accept as a beginning less than Parnell accepted.


It is safe, therefore, to assume that the new Home Rule Bill will be on the lines laid down by Mr. Gladstone. As a new generation has arisen in the meantime, it is necessary to examine some of


---

p.40



the objections to Home Rule and the reasons why Mr. Gladstone's two Bills met with the hostility of the country.


Home Rule will weaken the supremacy of the Imperial Parliament, and this is bound to lead sooner or later to the disintegration of the British Empire. One might, in regard to the proposal to split up the United Kingdom, use the words of Cromwell on the subject, and say:
‘And if so, what do you think the consequences of that would be? Would it not be confusion? Would it not be utter confusion?   
[*...*]  
 If so, what would that produce but an absolute desolation — an absolute desolation to the nation?’


Home Rule by creating lasting confusion at home must impair and ultimately destroy the national strength and the national safety on which the stability of the Empire rests. The colonies, as we have recently seen, do not desire an Imperial Federal Parliament, and why then should a system of federalism be set up in the United Kingdom to please a mere handful of the population. Federalism has not been such a success in the countries where it has been tried to justify its introduction here. Had the circumstances been the same in the United States and Canada as they are in the United Kingdom we may rest assured that the men who drafted the constitutions for those countries would never have introduced Federal Parliaments. Indeed, in the case of Canada, which is so often


---

p.41



quoted by Home Rulers, Sir John MacDonald, the great Canadian statesman, speaking of the Canadian Constitution, said:
‘Now, as regards the comparative advantages of a Legislative and a Federal Union, I have never hesitated to state my own opinions. I have again and again stated in the House that, if practicable, I thought a Legislative Union would be preferable. I have always contended that if we could agree to have one Government and one Parliament legislating for the whole of these it would be the best, the cheapest, the most vigorous, and the strongest system of Government we could adopt.’


It was because of the different systems of law that had grown up in the different provinces that he agreed to a Federal Government for Canada instead of one Parliament for all the Provinces.


An Empire cannot be strengthened by splitting it up at the centre and reducing the power which the Imperial Parliament now wields in the United Kingdom. At the present time the power of the Imperial Parliament in the United Kingdom is supreme in reality as well as in name. The supremacy which it exercises at home is very different from the supremacy it is supposed to possess in the colonies. Every question of government in the United Kingdom is under the control of the Imperial Parliament, and it is just because of this undivided supremacy that the present sense of security prevails. No local majority is allowed


---

p.42



to oppress a local minority. The Imperial Parliament does not claim to exercise the same effective authority in the colonies that it exercises at home. In reality, though not in name, the colonial Parliaments are independent of the Parliament at Westminster, and, what is more, they would not tolerate the interference of the Imperial Parliament. If, therefore, Ireland is to get Colonial Home Rule, Englishmen and Scotsmen must realise that the Irish Parliament and the Irish Parliament alone will legislate for Ireland. It will pass its own laws and administer them in its own way without outside interference. In spite of paper restrictions it will insist upon arranging its own fiscal system in its own way. Should those laws prove inimical to Great Britain or oppressive to the minority in Ireland, there can be no effective remedy, save the abolition of the Irish Parliament and the re-establishment of the Imperial authority by another Act of Union, and this could only be carried out after a civil war.


Mr. Asquith, like Mr. Gladstone, may use fine words about the ‘unimpaired supremacy’ of the Imperial Parliament, but in daily practice these will afford no protection to the minority in Ireland against oppression. In Quebec the Protestants are being oppressed, but the Imperial Parliament has not got the power to relieve their grievances unless by resorting to the 
extreme step of abolishing the Canadian Constitution. Home Rule, therefore, 


---

p.43



is full of danger for the Empire as well as for the loyal minority in Ireland.
If the supremacy of the Imperial Parliament is to be retained in Ireland, then Mr. Asquith must, if he establishes an Irish Parliament, fall back on Poyning's Law, and arrange that every Act passed by the Irish body must first receive the approval of the Parliament at Westminster before it becomes operative. Mr. Gladstone made no such proposal, and if he had it would have been rejected by the Nationalist party. To make the supremacy effective, not only will Mr. Asquith have to insist upon a veto over all legislation, but he will also have to exercise control over the administration of the Irish Government. In other words, it will be impossible to create anything greater than a glorified County Council and at the same time maintain an effective supremacy in the hands of the Imperial Parliament. Mr. Birrell's experience in 1907 is not likely to encourage the Government to attempt a solution of the question a second time by the creation of a Council with very limited powers.


It cannot be made too clear that Parliament if it surrenders its control in Ireland surrenders its supremacy at the same time. Mr. Gladstone's pretended supremacy would have proved a frightful source of trouble between the two Parliaments from the very beginning. The moment the Irish Parliament had commenced a course either of legislation or administration hurtful to the interests of the


---

p.44



English people a demand would have been made for interference. The Irish Government would have resented such a claim. This would have been followed by recriminations, animosity, and probably civil strife.
The local aspect of the question is quite as important as the Imperial one. There are Englishmen who say they desire to see a Home Rule Parliament established in Ireland because they think they would get rid of the Irish question once and for all. Those who adopt this attitude have not given much thought to the Home Rule movement in the past, or applied themselves to thinking out the lines it is likely to take if a Parliament is established in Dublin. Home Rule would not solve the Irish question; it would simply create a new crop of troubles for England, without benefiting Ireland.


Mr. Gladstone found how difficult it was to take a Constitution to pieces when he attempted to frame his Home Rule Bills. The obstruction of the Nationalist members in the House of Commons made him anxious to get rid of them, and so in his Bill of 1886 he decided to exclude them altogether from Westminster. In the 1893 Bill he reversed his former policy and decided to retain them in reduced numbers at Westminster for specified purposes, but he admitted during the discussions on the Bill that the wit of man could not devise a satisfactory scheme for defining their powers in the Imperial Parliament.




---

p.45


With regard to their exclusion from Westminster, Mr. (now Lord) Morley argued in 1886 that the Irish Legislature would require all the brains Ireland had got for doing Irish work, and he proceeded:
  

‘But there is a word to be said about the effect on our own Parliament, and I think the effect of such an arrangement — and I cannot help thinking so till I hear of better arrangements — upon our own Parliament would be worse still. It is very easy to talk about reducing the number of the Irish members; perhaps it would not be so easy to do. It is very easy to talk about letting them take part in some questions and not in others, but it would be very difficult when you come to draw the line in theory between the questions in which they shall take a part and those in which they shall not take a part. But I do not care what precautions you take; I do not care where you draw the line in theory; but you may depend upon it — I predict — that there is no power on earth that can prevent the Irish members in such circumstances from being in the future Parliament what they were in the past, and what to some extent they are in the present — the arbiters and the masters of English policy, of English legislative business, and of the rise and fall of British Administrations. You will have weakened by the withdrawal of able men the Legislature of Dublin, and you will have demoralised the Legislature at Westminster. We know very well what that demoralisation means, for I beg you to mark attentively


---

p.46



the use to which the Irish members would inevitably put their vote — inevitably and naturally. Those who make most of the retention of the Irish members at Westminster are also those who make most of there being what they call a real and effective and a freely and constantly exercised veto at Westminster upon the doings at Dublin. You see the position. A Legislative body in Dublin passes a Bill. The idea is that the Bill is to lie upon the table of the two Houses of Parliament in London for forty days — forty days in the wilderness. What does that mean? It means this, that every question that had been fought out in Ireland would be fought out over again by the Irish members in our Parliament. It means that the House of Lords here would throw out pretty nearly every Bill that was passed at Dublin. What would be the result of that? You would have the present block of our business. You would have all the present irritation and exasperation. English work would not be done; Irish feeling would not be conciliated, but would be exasperated. The whole efforts of the Irish members would be devoted to throwing their weight — I do not blame them for this — first to one party and then to another until they had compelled the removal of these provoking barriers, restrictions, and limitations which ought never to have been set up. I cannot think, for my part I cannot see, how an arrangement of that sort promises well either for the condition of Ireland or for our Parliament. If anybody in my opinion were to move an amendment to our Bill in the House of Commons in such a direction as this, with all these


---

p.47



consequences foreseen, I do not believe such an amendment would find twenty supporters.’


Mr. Morley's arguments against the retention of the Irish members at Westminster in 1886 remain as cogent to-day as when they were uttered, and yet we find that in 1893 Mr. Gladstone and his colleagues threw over their former arguments and agreed to accept the evils which they formerly warned the public against. Lapse of time has not produced a solution of the difficulty. We find Lord Morley writing in his Life of Gladstone:
‘The crucial difficulty was the Irish representation at Westminster. In the first Bill of 1886 the Irish members were to come no more to the Imperial Parliament, except for one or two special purposes. The two alternatives to the policy of exclusion were either inclusion of the Irish members for all purposes, or else their inclusion for Imperial purposes only. In his speech at Swansea in 1887, Mr. Gladstone favoured provisional inclusion, without prejudice to a return to the earlier plan of exclusion if that should be recommended by subsequent experience. In the Bill now introduced (February 13th, 1893) eighty representatives from Ireland were to have seats at Westminster, but they were not to vote upon motions or Bills expressly confined to England or Scotland, and there were other limitations. This plan was soon found to be wholly intolerable to the House of Commons. Exclusion having failed, and inclusion of reduced members for


---

p.48



limited purposes having failed, the only course left open was what was called omnes omnia, or rather the inclusion of eighty Irish members, with power of voting on all purposes. Each of the three courses was open to at least one single but very direct objection. Exclusion, along with the exaction of revenue from Ireland by the Parliament at Westminster, was taxation without representation. Inclusion for all purposes was to allow the Irish to meddle in our affairs, while we were no longer to meddle in theirs. Inclusion for limited purposes still left them invested with the power of turning out a British Government by a vote against it on an Imperial question. Each plan therefore ended in a paradox. There was a fourth paradox — namely, that whenever the British supporters of a Government did not suffice to build up a decisive majority, then the Irish vote descending into one or other scale of the Parliamentary balance might decide who should be our rulers.’


One can hardly wonder that such a staunch supporter of the Liberal Government as Sir W. Robertson Nicoll wrote in the British Weekly in 1906:
  

‘If sentiment could have carried anything it would have carried Home Rule, and at first it seemed as if it might. But by and by arguments were brought out. They were very ably and fully presented when Mr. Gladstone introduced his Bill, and they were not added to in substance. The trouble was that they were not answered. It is very easy to state them briefly. After


---

p.49



Home Rule the Irish members were to be retained in Parliament or they were not. If they were to be retained in Parliament they had full power over Ireland, and they were also in effect the governors of this country, because their votes might often seat or unseat the Ministry. If they were excluded from the British Parliament, then we had taxation without representation, so far as the taxes were Imperial and not local. This was contrary to the whole spirit of British institutions. Further, their exclusion from the Imperial Parliament made very plainly for separation.
  

Again, there was the commanding difficulty of Ulster. A very strong party in Ulster declared they would never submit to Home Rule, and those who knew them knew they would be as good as their word. What had the Home Rule papers to say in reply to this? Nothing; there never was any reply made. There were, it is true, attempts at reply. Thus it was said that Ulster was bluffing, that Ulster would yield, that all Irishmen would join in making Home Rule effective. But this did not go down.
  

Then Mr. Gladstone hinted that special arrangements might be made for Ulster, but everybody saw that a Home Rule scheme such as he drew out omitting Ulster would be so truncated and abortive that no one would wish to see it carried. As for the Irish members, there was an extraordinary suggestion that they should come over to vote on Imperial affairs alone — a suggestion so manifestly ludicrous that it was laughed out of court at once.
  

Mr. Gladstone's schemes were broken down by


---

p.50



arguments of speakers, but even more by the arguments of the Press. He was always hinting that other plans might be found, but in reality he had no better plan than that which he brought forward when he came into the shadow of power to pass an impossible Home Rule Bill.’


Under Mr. Gladstone's first scheme of exclusion Irishmen would have been taxed without any right of representation; while under his second scheme Irishmen would have had a controlling voice in British affairs, but Englishmen would have had no control whatever over the Acts of the Irish Parliament. Proposals so absurd could not stand the test of criticism, and so it may be said of Mr. Gladstone's two Home Rule Bills that they were self-destructive.


Any scheme of Home Rule acceptable to the Nationalists must reserve the real power in Ireland to the Irish Executive, which must have the sole right of administering the law, and in case it refused to give due protection to the minority, as is most probable, there would be no redress. Even under Mr. Birrell's administration minorities in different parts of the country have found their position a very difficult one, but under a Home Rule Government it is probable that the position of these people would become unbearable. It may be that Mr. Birrell out of the kindness of his heart has been gradually training them to bear the greater evils which will assuredly flow from Home Rule.




---

p.51


The men who at present resort to boycotting and moonlighting and other cruel forms of outrage in order to terrorise their opponents would have a much freer hand for mischief under the rule of an Irish Parliament. It requires no stretch of imagination to think of the new Parliament following the example of the Parliament of James II., and by inequitable taxation practically confiscating the property of the minority. The force that would control and direct the policy of a Parliament in Dublin to-day is as intolerant as the force that controlled the Irish Parliament in King James' time.


In order to maintain the authority of the Imperial Parliament under Home Rule it would be necessary to have two Executives operating in Ireland, and nothing is more certain than that they would be continually at war with each other.


In spite of any restrictions that might be embodied in a new Constitution the Irish Parliament would have ample scope for dangerous and oppressive legislation. The whole system of trial by jury could be rearranged in such a way that the people of Ulster would be at the mercy of the people of the South. If the lines of Mr. Gladstone's Bills are followed the new Parliament would have power to pass a law making it a serious offence to criticise the action of the Roman Catholic Church, or even to criticise the action of Parliament itself. Without infringing the written Constitution it would be possible to reduce personal liberty to the merest sham.




---

p.52


In regard to elections, the law could be so changed as to admit clerical influence in its worst form. Electoral districts could be so arranged that Protestant representation would be reduced to a bare minimum. Mr. Redmond's promise that Unionists would be fairly treated under the Local Government Act has not been kept. What reason then have we to suppose that his promises of toleration under a Home Rule Parliament would meet with any different fate. If Mr. Redmond has failed to get his followers to display toleration in regard to local government, it is not too much to assume that there would be no toleration shown towards Unionists once an Irish Parliament was established.


Mr. Dillon, in a speech at Castlerea, County Roscommon, warned those whom he described as ‘the enemies of the people’ that ‘in the time of our power we will remember them.’ In Ireland everyone knows what a threat like this means. The minority do not expect and would not receive fair play under a Home Rule Parliament. Irish Unionists know from experience that paper safeguards would be worthless.
There are a thousand ways in which the Nationalists could help their own friends at the expense of the minority. The Home Rule Constitution might require that the Irish Parliament was not to impose discriminating duties, but that would not prevent it from giving grants to convents and monasteries engaged in trade.




---

p.53


The Ulster linen trade could be ruined by a scheme for supporting and developing industries ecclesiastically controlled. Private property would be at the mercy of men who have never shown much respect for the property of others. There was no provision in Mr. Gladstone's last Bill that would have prevented an Irish Parliament from drilling an armed force to be used at some critical juncture for compelling England to grant complete independence. The Veto of the Lord Lieutenant would have been a sham, for in case of his refusal to give his consent to a Bill the Government would have resigned, and he would have been left without means for carrying on the administration of the affairs of the country.


An appeal by aggrieved individuals to the English Privy Council would have been cumbersome and out of the reach of an ordinary citizen. Supposing Mr. Asquith makes provision for an appeal to the Privy Council how is he going to get its decisions respected in Ireland when those decisions run counter to the opinions of the Irish Government, who will have control of the judiciary and the police force? The decisions of any Court must prove worthless unless that Court has at its command the means of giving effect to them.


The Nationalists would look upon the English Privy Council as an alien body, and they would take a special delight in rendering its decisions


---

p.54



useless. As Professor Dicey once wrote, an Irish Parliament could not repeal a single provision of the Constitution, but it could render the Constitution a nullity.


Home Rule has not even the advantage that it would be final. It must sooner or later lead to separation. Without the unity of the United Kingdom it is impossible to maintain the stability of the Empire. Most of the arguments for Home Rule are based on fallacies. It is stated, for example, that English government has failed in Ireland, and that the present discontent can only be removed by the establishment of a Parliament in Dublin. It is untrue to say that English government has failed. The remedial policy which has been applied by the Unionists during the last quarter of a century has worked a wonderful change in Ireland. Where would an Irish Parliament have found the large sums of money necessary in order to carry out the different schemes inaugurated during these years? As to the discontent which is supposed to prevail, it is largely the work of professional agitators, who get most of their funds from America. The Imperial Parliament has shown itself not only willing, but also able to remove every legitimate grievance in Ireland.


One of Mr. Gladstone's favourite arguments was that Home Rule had proved a success in other countries. He frequently pointed to Norway and
Sweden as a case in point, but since then Norway


---

p.55



has separated from Sweden, and now has a king of its own.


There is no true analogy whatever between the position of Ireland and that of the Colonies. Ireland lies close to the British shores, and Dublin is as easy of access from London as is Edinburgh. The Colonies are thousands of miles away, and it is absurd to say that they can be treated in the same way as Ireland.


As to Federalism in the United States, it was I adopted for the purpose of bringing together under one Government separate communities. The relations between the State Legislatures and the Federal Government are not so satisfactory as to justify the introduction of federalism into the British Constitution. There are many instances in which the separate States have successfully defied the Federal Power.


Unionist Irishmen are asked to trust the Nationalist leaders. This is impossible. We who know their history and who have experienced their intolerance may be pardoned for our lack of confidence.


It is sometimes urged that power brings responsibility, and that the Nationalists would act differently under Home Rule. This is nothing more than prophecy, and this prophecy finds no encouragement in the experience of the American States.


Mr. James Bryce, the British Ambassador to the


---

p.56



United States, and a former Chief Secretary for Ireland, writes in his American Commonwealth — ‘The chief lesson which a study of the more vicious among the State Legislatures teaches is that power does not necessarily bring responsibility in its train . . . The greatness of the scale on which they act and of the material interest they control will do little to inspire them. New York and Pennsylvania are by far the largest and wealthiest States in the Union. These Legislatures are confessedly the worst.’


The rancour and the bitterness which the Nationalists display towards one another provide Unionists with a sufficient warning as to what they may expect under an Irish Parliament. The recent election petitions in North Louth and East Cork show the methods that Nationalists are prepared to adopt in order to crush out their opponents. Corruption and intimidation are two of the commonest weapons used by the Nationalist politicians to secure their ends. Their methods at present may not be as well known to the British public as in Parnell's day, but, as they now operate through a secret society, they are still more subversive of ordinary liberty.


The Unionist minority (if indeed the opponents to Home Rule in Ireland are in a minority) has in all these circumstances an undoubted right to protest against the establishment of a Home Rule Parliament. No nation is justified in legislating


---

p.57



for a section of its people unless that legislation can be proved to be for the common good of the whole people, and there is every reason for believing that Home Rule would ultimately prove as dangerous to the Empire as it would certainly prove to Irish Unionists.




---

p.58


Financial Aspect Of Home Rule
-----------------------------


The Financial aspect of Home Rule is important alike for taxpayers whether in Great Britain or in Ireland. Mr. John Redmond, in a speech which he delivered last May, endeavoured to prove that Home Rule would place no additional burden on British taxpayers. That can only be accomplished by placing burdens on Irishmen which will in a few years' time drive Ireland into bankruptcy. Ireland is the poorest partner, and she would be quite unable to bear the extra taxation Home Rule would entail. At the present time Ireland receives a great deal more out of the Imperial Exchequer than she pays into it, and Nationalists who have some knowledge of business have no hesitation in stating that the financial arrangements made by Mr. Gladstone in his two Bills would in a few years have landed the country in ruin. By the Bill of 1886 it was proposed that Ireland should pay one fifteenth of the Imperial charges. Mr. Gladstone was then immovable on this point, though in his second Bill he reduced the contribution during the committee stages to one-twenty-sixth. Parnell in


---

p.59



1886 had insisted that Ireland should not pay more than one-twentieth of these charges.


Lord Morley writes:*‘Even an hour or two before the Bill was actually unfolded to the House he (Parnell) hurried to the Irish Office in what was for him a rather excited state to make one more appeal to me for his fraction. It is not at all improbable that if the Bill had gone forward into Committee it would have been at the eleventh hour rejected by the Irish on this department of it.’’’*

 (Morley's Life of Gladstone. )




If the financial argument was one of the ‘knottiest points’ in 1886, it must be more difficult now owing to the legislation which has been passed in the interval involving large loans to Ireland as well as annual grants of considerable sums. It is quite impossible, as Mr. Gladstone found, to devise separate financial systems for the two countries without ruining Ireland or robbing England.


All the Customs payable at Irish ports were, under Mr. Gladstone's Bill, to go into the Imperial Exchequer. As they would not have benefited Ireland, there would have been a direct incitement to Irishmen to evade the Customs Duties. They would have argued, naturally enough, that there was no reason why they should impoverish themselves for the benefit of a wealthy country like England; and, with a friendly Government


---

p.60



controlling all the Irish officials, smuggling would have become an easy matter. Home Rulers in England have never explained how they would have met the situation in case there had been a campaign against the payment of all taxes going into the Imperial Exchequer. In such circumstances there would only be two courses open — either forego the taxes or else withdraw Home Rule and re-establish the old power of the Imperial Parliament in Ireland. If the English Government in power was dependent on the Irish vote, Great Britain would probably have to do without the Irish Customs Duties.


The Nationalists want Home Rule not on Colonial terms, but under an arrangement whereby they shall call the tune and England pay the piper. They demand that Ireland shall be divorced from Great Britain, and, in true Hibernian fashion, they make the suggestion that the divorce shall be accompanied by a ‘wedding cheque’ for a substantial amount. A good deal has been written in recent years about the over-taxation of Ireland since the Union. In former years Ireland appears to have paid more into the Imperial Exchequer than she received out of it, but Lord MacDonnell, in an address which he delivered at Belfast on February 23rd, 1911, pointed out that between 1870 and 1900 the total revenue contributed by Ireland to the Treasury amounted to 104 millions, while there was expended upon Ireland during


---

p.61



the same period 120.5 millions. For the ten years since 1900 the Irish contribution is set down at 15 millions, while expenditure upon Ireland during the same period reached 86 millions. These figures show that Ireland has been treated in a generous fashion by England since 1870. It is unreasonable to expect that this generous treatment would be continued if a Home Rule Parliament should be established.


The total Imperial expenditure has increased very considerably since 1885. In that year it amounted to £63,753,000, while in 1910 it had reached the grand total of £90,646,000. If Ireland is asked to pay one-fifteenth, as in Mr. Gladstone's first Bill, her contribution would now be £6,474,714, and immediately bankruptcy would stare her in the face. One-twenty-sixth of these charges would amount to £3,486,384. If we add to this the recent deficit of £2,357,500, we find that the Irish Parliament would have to begin its work by imposing extra taxation to the amount of almost £6,000,000 a year. This would mean bankruptcy in a very short time.


Outside the ranks of those who hope to hold profitable offices, it is very doubtful if there are a thousand individuals in Ireland who are willing to pay an extra shilling a year for the privilege of having a Parliament in Dublin.


From the very outset the question of finance would be a continual bone of contention between


---

p.62



Great Britain and the Irish Parliament. Every increased tax would be attributed to the want of generosity of the British Parliament in the financial arrangement of Home Rule, and men who take little or no interest to-day in the Home Rule agitation, and who are loyal to the British Constitution, would become bitter agitators, animated by the feeling that it was owing to their relations with England that they had to pay increased taxes. This would put a powerful lever in the hands of those who are working for separation.


It is sometimes said that under Home Rule the Nationalist leaders would effect economies that are impossible now. But the way in which these men manage their local affairs affords no justification for such a belief. One finds that local taxation is very much higher in the Nationalist districts than in the Unionist districts, and the explanation is that Nationalists are elected not because of their business ability, but according to the degree of their ‘patriotism’! It is nothing unusual to find the rates in a Southern town double what they are in Ulster. Dublin has become notorious for its high rates and bad government. There is a large salary attaching to the office of Lord Mayor; no Unionist has been allowed to hold the office during the last thirty years, although Dublin Unionists pay at least one-third of the rates. The Nationalists as a rule have shown no capacity for managing business concerns. They have had a


---

p.63



splendid opportunity in the management of the Freeman's Journal of showing how a business concern should be run. The Freeman's Journal is not only the official organ of the Irish party, but it is controlled by Mr. Sexton, who is represented as the wizard of Nationalist finance. Here is what a circular issued to the shareholders of the Freeman's Journal in January last states:
  

‘Within the last few months the ordinary shares (£3 paid) in the Freeman's Journal, Limited, have been dealt in on the Dublin Stock Exchange at the price of 9d. per share, and the preference shares of £5 each at 17s. 6d.’


If this is the best the cream of the Nationalist party can do, what may we expect from the ordinary members? Mr. Redmond has made the point that the cost of government is much higher in Ireland than in Scotland. That is quite true, but it is owing to the fact that the State does so much more for the people in Ireland than for the people in Scotland. Remedial measures such as land reform, agricultural education, and the improvement of the condition of the poor in the congested districts cannot be carried out without the expenditure of money. It is absurd, therefore, to protest against the expenditure which helps the poorer people in Ireland. It may be all right from a political point of view for the Nationalists to charge the British Government with extravagance,


---

p.64



but they have never condescended to show how they would run the country cheaper. If one looks into the finances of Ireland, it will be seen that it is impossible to make any considerable reductions in expenditure without reducing the services which do so much to help the poorest class. If Mr. Redmond abolished all the primary schools, dismissed the policemen, ceased paying old-age pensions, wiped out the Department of Agriculture, and several other departments which have been created for the special benefit of the Irish people, it would be possible to reduce the Irish expenditure to the level of the most economically governed country in the world.


It would be interesting to know in what departments the Nationalists would effect economies. They dare not abolish old-age pensions, which constitute by far the heaviest item in the Irish expenditure. The amount for the present year is £2,408,000. Education costs £1,843,656. The Royal Irish Constabulary, it is true, costs over a million and a quarter, which seems excessive compared with £490,426 for the Scottish police force, but it is not necessary to break up the Union in order to reduce the cost of the police force. All the Nationalists have got to do to accomplish this desirable end is to live peaceable lives. Lawlessness, which is generally fomented by professional agitators, is responsible for the high cost of the police force. Home Rule would


---

p.65



not lead to a reduction of the expenditure on the police. If there were no Unionists in the country at all, it would be necessary to maintain a large police force to keep the rival Nationalist factions from cutting each other's throats. With a hostile Ulster the Nationalists would find that, instead of reducing, they would have to increase the police force. Sensible Nationalists never put forth the argument that the cost of Government would be reduced under Home Rule, for they know it would not. For years the Nationalist agitators have been promising the people a new heaven and a new earth under Home Rule, and these people would insist on getting the promises fulfilled. The party is pledged to the nationalisation of the railways, which would mean the imposition of a heavy burden on the taxpayers.


The truth of the matter is that the finances of the two countries are so closely entwined that they cannot be satisfactorily separated. No financial scheme of Home Rule has yet been put forward that would be just to both countries. It must be remembered that in recent years Ireland has become indebted to Great Britain to the extent of over £100,000,000 for land purchase, and a large sum is still necessary for the same purpose. The moment a dispute took place between the two countries over financial matters nothing would be easier than to start a campaign against the payment of the land purchase instalments. If this


---

p.66



should happen, how could the British Exchequer collect the amounts due?
Even if Ireland was not asked to contribute any part of the Imperial charges, she would still have to increase her taxes, and the result would be that heavy additional burdens would fall on the industries of the country, which are mainly owned by Protestants. Business men in Ireland are under no doubt as to the evils that would follow Home Rule. Every time the question has become acute it has resulted in the depreciation of capital invested in Ireland. The men who control the capital and manage the industries of the country have no confidence in Home Rule.




---

p.67


The Religious Difficulty
------------------------


It is regrettable that in dealing with a question which should be strictly political it becomes necessary to discuss the religious aspect of Home Rule, but this is due to the fact that the Church of Rome predominates in every phase of Irish life. If, then, the religious question is an acute one in Ireland, the fault does not rest with Protestants, who are anxious to live and work on harmonious terms with their Roman Catholic fellow-country men. The cause of the trouble is traceable to the Vatican, which has still a stronger hold on the Irish Roman Catholics than it has on Roman Catholics in any other part of the world. Mr. Redmond recently denied that the priests exercise any undue influence on Irish Nationalists, but anyone who knows Ireland is well aware that the priests are all-powerful among their own people, and that loyalty to the Pope and the Papal policy dominates every other feeling. Mr. Redmond recently gave three instances where he alleged that Irish Nationalists had defied the Pope in political matters, but the Irish Catholic, an influential weekly organ which voices the opinion


---

p.68



of the Church of Rome, promptly replied that Mr. Redmond was in error and that the instructions of the Church had been carried out in every case to which he had referred. It added the significant hint that, rather than have even one prerogative of the Pope curtailed, the Irish Roman Catholics would forego Home Rule for all time. Mr. Redmond made no reply, and for the very good reason that he knows that any Home Rule scheme which proposed to limit the political activities of the Church of Rome would be doomed to destruction. The bishops and priests insist on retaining their supremacy in political as well as in religious affairs. It is difficult for those who live out of Ireland to understand how closely the two are entwined.


Mr. Redmond wishes the public to believe that under Home Rule the Roman Catholic bishops and priests would confine themselves to their religious duties. Archbishop Walsh, who is a much more important personage in Ireland than Mr. Redmond, said on September 15th, 1885:
  

‘In Ireland the line between religion and politics is by no means easy to draw. I have some experience now in critically observing such matters, and I have never known that feat to be accomplished with perfect success.’


Five days later he claimed:


---

p.69



‘As priests, and independent of all human organisations, they have an inalienable and indisputable right to guide their people in this momentous proceeding as in every other proceeding where the interests of Catholicity as well as the interests of Irish nationality are involved.’


In Great Britain clergymen give their individual opinions on political matters for what they are worth, but the Irish priest gives his as a priest who is ‘independent of all human organisations,’ and the people obey his dictates no matter what their character may be. The Freeman's Journal, which is the official organ of the Nationalist party, in an article in its issue of February 18th, 1886, laid down the position which Protestants and Roman Catholics must occupy:
  

‘The one people (the Irish Catholic) is Christian, the other (the Protesant) non-Christian; the one animated by a supernatural principle, the other by a natural. . . . They cannot freely co-exist in the same society. They must be present, but it must not be as equals, but in subjection and domination; not in peace but in conflict. England has been for three centuries the leader of the great apostasy, and is at this day the principal obstacle to the conversion of the world. . . . The Christian idea is absolute, and will brook nothing that is not itself.’


Knowing as they do that these are the real sentiments of the men who are working for the


---

p.70



establishment of a Home Rule Parliament, it is only natural that Irish Protestants should resist a Dublin Parliament to the uttermost. Their fears as to religious intolerance are only too well founded. The late Rev. Dr. Parker, a devoted and enthusiastic follower of Mr. Gladstone, opposed Home Rule in 1892 because he believed it would be ‘high treason against the very genius of Nonconformity’ to hand over Irish Protestants to the rule of Rome. ‘I cannot but think,’ he wrote, ‘that my Nonconformist brethren in Ireland must know their own case better than I know it.’ The appeal which roused Dr. Parker's sympathy was signed by almost every Protestant clergyman in Ireland. Sir William Robertson Nicoll, the editor of the British Weekly, who cannot be described as an ‘Ulster bigot,’ writing in 1907, asked Mr. Stephen Gwynn to ‘tell us of a single instance where a Roman Catholic majority has given justice to a Protestant minority.’ After pointing out how the Nationalists carry religious bias into everyday business, he proceeded:
  

‘Thus it is more clear than ever that Home Rule as the Nationalists conceive it means Rome Rule. We are quite certain that the Nonconformists in this country, properly enlightened, will never hand Ireland over to Rome Rule. . . . Even if they [the English Nonconformists] were to betray their trust the Protestants in Ireland would fight to the death against a tyranny so monstrous that the most enslaved creatures under its


---

p.71



rule have made their protest. Home Rule will not come without the bloodiest of battles, without the last extremity of resistance, and we have to thank Mr. Stephen Gwynn and his like for corroborating Protestant convictions and renewing Protestant determination.’


Irish Protestants know that Sir W. Robertson Nicoll was right when he declared that Home Rule means Rome Rule. No less an authority than Cardinal Manning made a similar statement in 1891.


In an article in the British Weekly in October, 1906, the Editor wrote:
  

‘The politicians would fain get away from the religious question, but they cannot. It will not and cannot be evaded so long as the claims of Rome are what they are. Almost everywhere in the civilised world it is a source of continual perplexity. At the beginning of the twentieth century the Papacy seems to be fighting for its life, desperately, blindly, determinedly.’


‘The armies of the Church are the political danger of every country which is not subservient to their purpose. Rome desires temporal power in order that she may enforce her rule. . . . It is by physical coercion that so-called heretical opinions are to be eradicated, and that conscience, of which God alone is Lord, put in irons. Sometimes one is disposed to think that


---

p.72



violent Protestant controversialists exaggerate. But they do not exaggerate; in fact, it is almost impossible to exaggerate.’


‘Under a Dublin Parliament Ireland would become the most Papal State in Europe, and with the facts of history, as well as those of everyday experience before us, is there the slightest reason for supposing that a Roman Catholic ascendancy would not be established?’


Nonconformists are loud enough in their protestations against the claims of sectarianism in England; it does seem strange that they are prepared to put burdens on the backs of their Irish brethren which they would not for one moment tolerate themselves. Two leaders of Nonconformity, Rev. Dr. Horton and Rev. Joseph Hocking, have published an interesting book entitled Shall Rome Reconquer England? which contains not a few statements that should make their brethren pause before they agree to put Irish Protestants under the heel of the Pope of Rome. In this book we find the following:
  

‘There is in Romanism some subtle and irresistible tendency to retard, and even to ruin, every country which it dominates. . . . 
  

In this respect Romanism is like Mohammedanism or Hinduism, it really grips people and nations. The Roman Church dominates Ireland and the Irish as completely as Islam dominates Morocco. Ireland, with


---

p.73



the exception of Ulster, is the Island of the Saints, and exhibits more perfectly than any other part of Europe the virtue and value of the Papal religion. There the Catholic ideals are realised. . . .’
  

‘The priests control not only the worship but the life of the people. If the Irish peasant desires freedom he emigrates to America. I am told that not only peasants but even priests frequently cross the Atlantic, not for economic or worldly reasons at all, but to escape from the rigid and perfected system of the Roman obedience, which is, as Catholics think, the supreme blessing, and, as Protestants think, the most crushing bane of that lovely and melancholy land.’
  

‘A friend of mine, who is a large employer of labour in Lancashire, asked one of his men in the 1906 election whether he had made up his mind which way he was going to vote. ‘I don't know yet, sir,’ replied the man, ‘we shan't know till Sunday. Father --- will tell us then.’’
  

‘Manning is reported to have said on one occasion, ‘Cromwell is not dead, he is only asleep, and he may awake at any moment.’ Manning never uttered truer words. Not only is Cromwell not dead, but Protestantism is not dead. It may seem at times to be slumbering, but its heart still beats with great mighty throbs which send the lifeblood of liberty throughout the veins of the nation. But it is time we were aroused from our slumber.’
  

‘This I have found in speaking up and down this land; the people respond mightily to the Protestant appeal. If there is indifference, it is from want of


---

p.74



knowledge, not from want of life. What is needed is that the great facts of history shall be made known to them, that the real nature of Rome shall be revealed to them, that the story of our heroic fathers shall be told to them, that the great fundamental truth for which our Reformers fought and died shall be proclaimed to them. Let the people know these things and have no fear, but if Rome finds England ignorant concerning what is most vital to her, it may be that she will find her an easy prey.’


Irish Protestants dread the establishment of a Roman Tyranny in their country, and they earnestly appeal to their Protestant brethren in Great Britain to protect them from it. They feel that the only way to avert this danger is to maintain the present supremacy of the Imperial Parliament. If there was more of the Puritan spirit abroad, of which Dr. Horton and Mr. Hocking write, the danger to Irish Protestants would soon disappear.


Protestants are sometimes told that their fears are groundless and that there is no danger of history repeating itself. It is not necessary to go to Spain in order to get an object lesson in the intolerance of the Vatican. The Province of Quebec provides a warning which cannot be ignored. At the time of the Confederation of Canada the Protestants of Quebec were assured that they had no reason to fear the Roman Church.


---

p.75



Later events have shown that their fears were more than justified. The real ruler of Quebec to-day is undoubtedly the Cardinal in his palace, and the effect of his rule has been to elbow out the Protestant population of the City of Quebec, reducing it in a few years from 17,000 to a little over 4,000. The situation is even worse in the rural districts. The Eastern townships, which at one time occupied a position much like the position Ulster occupies in Ireland, are now at the mercy of the clericals, who control everything, whether religious or secular, throughout the Province of Quebec. It has not been necessary to revert to the old-fashioned methods of persecution in order to drive out the Protestants. As in Ireland, the Protestants of Quebec control most of the industries, and the taxes are so adroitly arranged that they fall heavily upon them.


The Roman Catholic Church has unlimited control of education, and the result is that the primary schools are used chiefly for the purpose of teaching the doctrines of that Church. Protestants in the rural districts who desire to have their children educated in schools that are not controlled by the priests have no option but to leave the province. At the present time one-seventh of the total revenue collected in the Province of Quebec goes to support Roman Catholic institutions.


Mr. William Maxwell, who personally examined


---

p.76



the conditions which exist in Quebec, and published early this year a book embodying the results of his investigation, lets in some light upon the evils that are sure to follow from creating in Ireland a second Quebec. He says:
‘The people of Quebec have put themselves unreservedly in the hands of the Church. Nothing in public or private life is too insignificant to escape the control of their bishops and priests. Their conscience, their education, their politics are controlled and directed by the Church; and the politician, be he Prime Minister of the Dominion or member of the Federal or the Provincial Parliament, who seeks the support of Quebec must first make terms with the Roman Catholic Church.’


‘Let me give an example of this all-pervading power of the Church. Montreal has a population of 400,000, partly British, partly French. It was formerly the capital of Canada, and is still the commercial metropolis. Montreal has no public library and no public hospital. Why? Because the Roman Catholic bishop refused his assent to a public library unless he was permitted to select the books, and refused his assent to a public hospital unless Roman Catholic patients were separated from Protestant patients and put into the charge of Roman Catholic nurses and doctors.’


‘It would be absurd to pretend that this domination is not resented by many French-Canadians who are good Catholics. I have heard them denounce it in unmeasured


---

p.77



 terms and predict the approach of the day when the bond will be shaken off and liberty of speech and of action restored. But these confessions are made with bated breath and in private conversation. Rarely, if ever, are they made in public, for the Church, as the German proverb says, has hands and feet as well as ears.’


‘The Roman Catholic Church in Quebec levies taxes — I mean actually taxes, not voluntary contributions — for the building and maintenance of the churches and the houses of the clergy; it levies a yearly tax for the support of the priest of each parish, and payment of these taxes is enforced by the civil courts. The real estate of the Church is exempted from taxation. When the British took possession of Canada there were only four companies of nuns, numbering in all 150 members, and four male orders, numbering about 100 members. French and Catholic Kings were reluctant to grant charters of incorporation, being of opinion that there were ‘already too many communities and convents in Canada,’ and that any increase was ‘most prejudicial to the interests of the country.’’


‘Since the Confederation of the States of Canada the Quebec Legislature has granted acts of incorporation to no fewer than 40 convents and monastic institutions. There are to-day in the province of Quebec 25 monastic orders with over 3,000 members, and 55 convents with over 10,000 members. Education is controlled by the Roman Catholic bishops and clergy, and no book can be read in the schools that has not received the imprimatur of the Church.’




---

p.78


Those who know Ireland are well aware that a Dublin Parliament, like the Quebec Legislature, would be at the mercy of the priests. If paper safeguards have proved worthless in Quebec, what reason is there for supposing that they would afford any protection to the Protestants in Ireland? Not only have the clerical party placed themselves above the civil law in Quebec, but they have also used their influence in favour of the establishment of a French-Canadian Republic. In the other Canadian provinces where the Roman Catholics are in a minority the priests quietly influence their people, but in Quebec they simply command them, and the very same thing would happen in Ireland. The history of Quebec shows that under a Parliament in Dublin no law would be passed which had not first received the approval of the Roman Church.
Those who have followed the operations of the ‘Ne Temere’ decree know what to expect. The Roman Church declares that when a marriage takes place between a Protestant and a Roman Catholic in a Protestant Church, it is no marriage at all, and that those who contract it are living in open sin. As the M'Cann case has shown, the Roman Church will ruthlessly break up a home and deprive a mother of her husband and children because she refuses to admit that her marriage in a Presbyterian Church is illegal. The only answer of the Nationalists to this cruel proceeding is to


---

p.79



throw mud at the heart-broken woman. They have been implored by their Home Rule friends in Great Britain to denounce the ‘Ne Temere’ decree, but they have not done so, and for the very good reason that the priests maintain that a Roman Catholic husband is bound to desert his Protestant wife unless she agrees to be remarried in a Roman Catholic Church. The silence of the Nationalist party on this matter is the strongest proof, if indeed proof were necessary, that they are subject to the control of the Pope, and that no restrictions on the power of a Dublin Parliament would be admitted which diminished the influence of the Roman Church in any way.
The ‘Ne Temere’, decree appears to be more than even a Liberal like Sir Robert Perks can swallow, for in a pamphlet entitled Nonconformity in Parliament he writes:
  

‘I see that the Catholic Times abuses me in somewhat malevolent language for what I said to the Cardiff Free Churchmen about the recent Papal decree on mixed marriages. Anathema, however, is not argument. I have checked carefully what I said concerning the attitude of the Governments of Germany and Hungary towards that intolerant decree, and I find that I was absolutely correct. Indeed, I might have said much more. For not only does that decree brand with infamy and deny the rites of the Church to any Roman Catholic marrying a Protestant elsewhere than in a Catholic place of worship, cruelly and illegally declaring


---

p.80



the children of such a union to be in the eyes of the Church illegitimate, but the Papal authorities in their interference with personal liberty go much further. This tyrannical decree declares that no Roman Catholic maiden or youth is even allowed to get engaged to be married without the assent of the priest, before whom the parties to any such betrothal are to sign an agreement, and, I suppose, pay a suitable fee to the Church. No wonder that tens of thousands of Roman Catholics leaving Europe for America escape away from the thraldom of such a system. The Catholic Times is evidently not aware that no Roman Catholic priest could to-day celebrate a marriage in any Catholic church in England and Wales without the presence of a civil registrar were it not for the provisions of the Nonconformist Marriage Act of 1898, which is now in operation in hundreds of Roman Catholic churches in Great Britain. It will be interesting to see what provision the Government makes in the forthcoming Home Rule Bill for the protection of the Protestants of Ireland against this new claim of the Roman Catholic Church to interfere with the liberty of the people in making their marriage contracts without the interference of the priests.’


When Mr. Gladstone's Home Rule Bill was before Parliament in 1893 an amendment was proposed by the Unionists to exempt marriage from the legislative authority of the Dublin Parliament, but the amendment was defeated at the instigation of the Nationalists, Mr. John Redmond being one of the thirty-eight members who composed the


---

p.81



majority against it. Let Mr. Asquith propose to place any real restraints on the Church of Rome in Ireland, and he will speedily find his Home Rule Bill rejected as ignominiously as was Mr. Birrell's Irish Council Bill when it was found to contain the modest proposal that primary education should be taken out of the hands of the priests and entrusted to the local authorities. Those who live in Ireland and know the real situation are aware that the Editor of the British Weekly stated a plain fact when he wrote that Home Rule in Ireland would mean Rome Rule.


What The Nationalists Want
--------------------------


There is a good deal of ignorance in Great Britain, especially among the younger generation, as to the true character of the Nationalist aim, and it is largely because of this that Home Rule has received any support from even a section of the British people. The Nationalists naturally spend a good deal of their time in throwing dust in the eyes of the British electors. If they said in Great Britain, as they say in America and in Ireland, that they are striving for the establishment of an independent Parliament, they know their scheme would fail immediately. ‘Power to manage our own affairs’ is a familiar Nationalist phrase, but Mr. Gladstone's last Home Rule Bill would have given them greater power than the management of their ‘own affairs,’ dangerous though this would be. Some Radical politicians labour under the impression that the Nationalists only desire a system of local government similar to that in Great Britain. For the information of such people it may be pointed out that Ireland already enjoys local government almost identical with local government in Great Britain. The 



---

p.83




police force, it is true, is not under the control of the county councils, but few people familiar with the conditions that exist in Ireland would advocate the control of the police by local bodies. Education is not under the local councils, but that is because the Roman Catholic priests refuse to permit laymen any share in the management of the schools. The Nationalist demand, as laid down for many years, is an independent Parliament for Ireland — a Parliament as independent of Great Britain as was Grattan's Parliament in the eighteenth century or as the Colonial Parliaments to-day.


Mr. Patrick Ford is the paymaster of the Nationalist party, and he certainly would not be satisfied with a glorified County Council in Dublin. He wants to have no dealings with Great Britain, and he has said so in language more forcible than polite. ‘Not only would the Irish race the world over,’ he wrote regarding England, ‘rejoice at your fall, but would to-morrow be willing to sacrifice their lives for the immortality of the honour of being the chosen instruments in the work of bringing your Babylon down to hell.’ Again: ‘If any set of Irishmen see their way to successfully attack England by physical force, why let them go ahead and God bless them. If there is any dynamite or lyddite that will blow the British



---

p.84




Empire up into the clouds or down into the bottomless pit, why let it be used forthwith.’


A man like this, who gloated over the Phoenix Park murders and who wrote of Sir Curzon Wyllie's assassin in 1909 as the ‘latest martyr to the English Tyranny,’ would not likely submit for any length of time to the Irish Parliament remaining subordinate to the Imperial Parliament. Complete independence is the keynote of the Irish demand, as the following extracts show:
  


Mr. Parnell, at Cincinnati: 
  
‘When we have undermined English misgovernment we have paved the way for Ireland to take her place among the nations of the earth. And let us not forget that that is the ultimate goal at which all we Irishmen aim. None of us, whether we are in America or in Ireland — or wherever we may be — will be satisfied until we have destroyed the last link which keeps Ireland bound to England.’
  
 The Irish World, March 6, 1880.


At Cork, October 3rd, 1880:
  

‘We have determined to do our utmost to make Ireland great, prosperous, and free — to take the power of governing Ireland out of the hands of the English Parliament and people, and to transfer it into the hands of our own people. Determined as we are to achieve these ends, we believe that we can only achieve them by making the land of Ireland as free as it was when the waters of the Flood left it.’




---

p.85


At Castlebar, November 3rd, 1885:
  

‘Speaking for myself, and I believe for the Irish people and for all my colleagues, I have to declare that we will never accept, either expressly or implied, anything but the full and complete right to arrange our own affairs, and to make our land a nation; to secure for her, free from outside control, the right to direct her own cause among the people of the world.’


At Cork, January, 1885:
  

‘We cannot, under the British Constitution, ask for more than the restitution of Grattan's Parliament. (Renewed cheering.) But no man has the right to fix the boundary to the march of a nation. (Great cheers.) No man has a right to say to his country ‘Thus far shalt thou go and no further,’ and we have never attempted to fix the ‘ne plus ultra’ to the progress of Ireland's nationhood, and we never shall.’
  
Parnell Commission Report, p. 21.


At London, March 17th, 1885:
  

‘We can none of us do more than strive for that which may seem attainable to-day, but we ought at the same time to recollect that we should not impede or hamper the march of our nation, that though our programme may be limited and small it should be such a one as shall not prevent hereafter the fullest realisation of the hopes of Ireland.’


At Dublin:
  

‘I will accept the Home Rule compromise of Gladstone as an instalment of our rights, but I refuse to



---

p.86




say that it is a final settlement of the national question, and I declare that no man shall set a boundary to the onward march of a nation.’


At Ballina, April 20th, 1881:
  

‘It was for these things that I took my coat off in 1880, and it is for these things that I have got my coat off still, and that I intend to keep it off until we have banished traitors and seceders from the Irish ranks, until we have secured once more a united army and a united country, pressing on for the recovery of Irish freedom and Irish legislative independence.’


Mr. W. K. Redmond, at Gorey, August 23rd, 1885:
  

‘They did not desire to have anything more to do with kings and queens, for the only style of government to which Irishmen could look for freedom and prosperity was one which should be democratic and republican.’


Mr. John Redmond, at Dublin, April 23rd, 1889:
  

‘Why are we asked to toast ‘Ireland a Nation’ . . . It is the principle that the sons of Ireland and they alone have the right to rule the destinies of Ireland. Gentlemen, I am prepared to maintain that, more than that no Irish rebel leader in the past asked, and less than that, I am here to maintain, that no Irish leader of the present day can, or ought to accept.’




---

p.87


At Kanturk, November 17th, 1895:
  

‘Ireland for the Irish is our motto, and the consummation of all our hopes and aspirations is, in one word, to drive English rule, sooner or later, bag and baggage from our country.’


At Newry, 1897:
  

‘I remember when Parnell was asked whether he would, on behalf of the United Nationalist nation that he represented, accept as a final settlement the Home Rule compromise proposed by Gladstone. I remember his answer. He said: — ‘I believe in the policy of taking from England anything we can wring from her which will strengthen our arms to go on for more. I will accept the Home Rule compromise of Gladstone as an instalment of our rights, but I refuse to say that it is a final settlement of the national question, and I declare that no man shall set a boundary on the onward march of the nation.’ That is our (Redmondite) motto.’ — Irish Daily Independent, June 17th, 1897.


At Cork, October 23rd, 1901: ‘This United Irish League is not merely an agrarian movement. It is first, last, and all the time a national movement; and those of us who are endeavouring to rouse the farmers of Ireland, as we endeavoured twenty years ago, in the days of the Land League, to rouse them, are doing so, not merely to obtain the removal of their particular grievances, but we believe by rousing them we will be strengthening the national movement and helping us to obtain our end, which is, after all, national independence of Ireland.’




---

p.88


At Worcester, United States, November 14th, 1901:
  

‘What are our motives and objects? First of all, our ultimate goal is the national independence of our country. I say, in its essence, the national movement is the same to-day as it was in the days of Hugh O'Neill, of Owen Roe, of Emmett, or of Wolfe Tone — to overturn the foreign domination in our land and to put Irishmen in charge of their own affairs. The object has always been the same, and if we are working by methods that seem slow and ineffective to a free and an armed people, our critics should remember that people must labour with what they have at hand. Whether the freedom of Ireland is attained by moral suasion or physical force, what difference so long as it is achieved?’


At New Ross, June 23rd, 1907:
  

‘We to-day from this County Wexford send therefore this message to England. We tell her that we Wexfordmen to-day hate their rule just as bitterly as our forefathers did when they shed their blood on this spot. We tell her that we are as much rebels to her rule to-day as our forefathers were in '98.’ — Freeman's Journal, June 24th, 1907.


At New York (interviewed by New York Herald), September, 1908:
  

‘What Ireland wants is Home Rule and a Government of its own, and that is what Ireland is going to have. I hope to see Ireland placed in the scale of



---

p.89




nations much after the fashion of the United States as to Constitution, but it will, of course, be some time before there is actual independence there.’ — Irish Independent, Sept. 26th, 1908.


At Syracuse, U.S.A.: Nationalist
  

‘They ask us to demand more, and I answer in the words of Parnell: ‘Let us get this first and then demand more.’ We do not set a limit on the march of a nation.’ — Irish World, Nov. 9, 1910.


Mr. Joseph Devlin, M.P., at Philadelphia, November, 1908:
  

‘I believe in the separation of Ireland from England until Ireland is as free as the air we breathe.’ — Irish World, Nov. 28, 1908.


At New York, June, 1902:
  

‘Gentlemen, I know there are many men in America who think that the means which we are operating today for the good of Ireland are not sufficiently sharp and decisive. . . . I would suggest to those who have constituted themselves the censors of our movement, would it not be well to give our movement a fair chance to allow us to have as owners the tillers of the land, to have an Irish Parliament that will give our people all authority over the police and the judiciary and all government in the nation, and when equipped with comparative freedom, then would be the time for those who think we should destroy the last link that binds us to England to operate by whatever means



---

p.90




they think best to achieve that great and desirable end? I am quite sure I speak for the United Irish League on this matter.’ — Irish People, June 21st, 1902.


Mr. John Dillon, M.P. :
  

‘I have never hesitated to express my admiration for the men of '67 (the Fenians), and I declare that our movement is, in all its main principles and the great issues upon which it aims, the legitimate successor of that movement.’ — Freeman's Journal, Dec. 9th, 1888.


At Moville:
  

‘I say deliberately that I should never have dedicated my life as I have done to this great struggle if I did not see at the end of this great struggle the crowning and the consummation of our work, a free and independent nation.’ — Freeman's Journal, Dec. 5th, 1904.


At Tipperary:
  

‘That grand meeting in the heart of the great County of Tipperary reminded him of twenty-five years ago, and he took it as a sign of the national revival in Tipperary, as in other counties of Ireland, which will sweep before it all vestiges of English rule in Ireland. They never would have in Ireland a really prosperous and happy land until that rule is swept clean out of it.’ — Cork Examiner (N), Jan. 20th, 1905




---

p.91


Mr. T. P. O'Connor, at Fall River, Massachusetts, October 7th, 1887:
  

‘The Irish Parliamentary party does not intend to lay down their arms, their constitutional weapons, until they have obtained exclusive independence.’


Father Kavanagh, at Enniscorthy, June 10th, 1908:
  

‘Ireland,’ he said, ‘would not accept the position of a dependent or an inferior. Ireland must be a self relying nation, not a mere province to be guided and controlled from outside. (Cheers.) She must be free to develop her resources, intellectual and material. What we asked was comprised in the words, ‘Give us back our own.’ . . . We looked forward to the restoration of our native Parliament; but to satisfy the Irish people the Irish Parliament must in all that concerns Ireland be entirely independent and supreme in its decisions. (Cheers.) If it were not so it would be a mockery of our hopes, and if offered in that form he trusted it would be rejected with the contempt it deserved.’ (Cheers.)


Many more quotations of a similar sort might be given, but these should be sufficient to convince any thoughtful man that the object of the Home Rule agitation is to sweep away every vestige of British rule. Catholic Progress, voicing the ecclesiastical view, was not even content with the prospect of destroying British rule, for it wrote:



---

p.92




‘The woes of Ireland are all due to one single cause — the existence of Protestantism in Ireland. The remedy could only be found in the removal of that which caused the evil, which still continues. Why are the Irish not content? Because being Irish and Catholic they are governed by a public opinion which is English and Protestant. Unless Ireland is governed as a Catholic nation and free scope given to the development of the Catholic Church in Ireland by appropriating to the Catholic religion the funds given to religion, a recurrence of such events as are now taking place cannot be prevented. Would that every Protestant house were swept from the land; then would Ireland recover herself, and outrages would be unknown.’


Home Rule would not settle the Irish question; it would simply be the starting point for a new and more dangerous agitation.


Influential Warnings
--------------------


If the British people are ever reckless enough to establish a Parliament in Ireland, they will not be able to say afterwards that they have not been warned of the dangers it involves. Since the time O'Connell introduced his Repeal movement down to the present day there is scarcely an important leader of public opinion in Great Britain who has not pointed out the evils which are bound to follow from Home Rule. Up to the date of Mr. Gladstone's surrender to Parnell the Liberals were as strong in their denunciations of Home Rule as the Conservatives. Although political exigencies forced Mr. Gladstone to incur the very dangers against which he had been warning the public for years, those dangers are as real now as when the warnings were issued. Nothing has happened since then to weaken the old arguments against Home Rule, and the younger generation which has arisen since the struggles over the last two Home Rule Bills would do well to seriously consider the following weighty statements:
  


Mr. Gladstone, on receiving the freedom of the city of Aberdeen on September 26th, 1871, 93 94


---

p.94




dealt specially with the Home Rule question, and said:
  


‘This United Kingdom, which we have endeavoured to make a united kingdom in heart as well as in law — (applause) — we trust will remain a united kingdom — (loud applause) — and, although as human beings the issues of great events are not in our hands, but are directed by a higher Power, yet we intend and mean, every one of us, both high and low — not those merely who meet in this hall, but those who crowd the streets of your city, and every city from the North to the South of this island — we intend that it shall remain a united kingdom. (Loud applause.)’


‘We are told that it is necessary for Ireland to close her relations with the Parliament of this country, and to have a Parliament of her own. Why is Parliament to be broken up? Has Ireland any great grievances? What is it that Ireland has demanded from the Imperial Parliament, and that the Imperial Parliament has refused? (Cheers.) It will not do to deal with this matter in vague and shadowy assertions. I have looked in vain for the setting forth of any practical scheme of policy which the Imperial Parliament is not equal to deal with, or which it refuses to deal with, and which is to be brought about by Home Rule.’


‘What are the inequalities of England and Ireland? I declare that I know none, except that there are certain taxes still remaining which are levied over Englishmen and Scotchmen, and which are not levied over Irishmen, and likewise that there are certain purposes for which public money is freely and largely given in



---

p.95



Ireland, and for which it is not given in England or Scotland. (Cheers.) That seems to me to be a very feeble case indeed for the argument which has been used, by means of which, as we are told, the fabric of the United Parliament of this country is to be broken.’


‘Can any sensible man, can any rational man, suppose at this time of the day —in this condition of the world — we are going to disintegrate the great capital institutions of this country for the purpose of making ourselves ridiculous in the sight of all mankind, and crippling any power we possess for bestowing benefits through legislation on the country to which we belong?’


‘There is one limit, and one only, to the extension of local government: it is this — nothing can be done by any wise statesman, or right-minded Briton, to weaken or compromise the authority of the Imperial Parliament. The Imperial Parliament must be supreme in these three kingdoms, and nothing that creates a doubt upon that supremacy can be tolerated by any intelligent or patriotic mind. (Cheers.)’


‘I will consent to give to Ireland no privilege, nothing that is not to be given on equal terms to Scotland and to different parts of the kingdom.’ (Cheers.)


Earl Spencer, speaking at Bristol, November 14th, 1881:
  

‘What we have to do is this — We have to tell the Irish that their just grievances always will be redressed, that we will extend to them every privilege and liberty that we Englishmen possess; but we must tell them plainly at the same time that no party in



---

p.96




England, whether Conservative or Liberal, will put up with anarchy; and, what is more, that they are beating the air if they agitate for repeal of the Union. (Cheers.) We hold that the continued union of Ireland with this country is of vital importance to us. We feel like the Americans when the integrity of their country was threatened, and, if necessary, we must shed blood to maintain the strength and salvation of this country.’


At Belfast, June 18th, 1884:
  

‘The deeds of those men to whom I referred will, however, be as futile as they are dastardly. They will not terrify the English nation. The statesmen of the nation, and the nation itself, will face their enemy with a determination not to be beaten, and they will not give up one point or one idea which they consider necessary to maintain the United Parliament of England — (cheers) — and the sovereignty of the Queen. (Cheers.) I say this not only to the English and Scottish nation, but I say it to the Irish nation.’


Mr. John Bright:
  


‘In the year 1872 I wrote a letter to an Irish gentleman, from which I extract a short sentence: ‘To have two legislative assemblies in the United Kingdom would, in my opinion, be an intolerable mischief, and I think no sensible man can wish for two within the limits of the present United Kingdom who does not wish the United Kingdom to become two or more nations entirely separate from each other.’ To



---

p.97




this opinion I still adhere, and, if it be possible, more firmly than before.’ — Election Address, June 24th, 1886.


At Birmingham, July 1st, 1886:
  

‘We are asked to consent to what is really a revolution in Ireland at the bidding of one-twelfth of the population of the United Kingdom.
  

For 40 years I have been the friend of Ireland. Long before any member of the Irish party now in Parliament, or any member of the present Government opened his lips to expose and condemn the wrongs of Ireland, I spoke for her people in the House of Commons and on public platforms in this country. It is because I am still the friend of Ireland that I refuse to give her up to those to whom the recently defeated Bill would have subjected her.’ — Address to Birmingham Electors, June 24th, 1886.
  

‘You are asked to thrust out from the shelter and the justice of the United Parliament the 2,000,000 who would remain with us, who cling to us, who passionately resent the attempt to drive them from the protection of the Parliament of their ancestors. I may express the hope that this stupendous injustice and blunder will fail.’ — Ibid.


Letter to Sir Henry James:
  

‘A policy which would set up in Ireland an ascendancy a hundred times more baneful, a hundred times more harmful than any ascendancy I had fought against in all my long career.’




---

p.98


Earl Grey, the great statesman who carried Reform, speaking on this question of Home Rule in the House of Lords in the session of 1834, said:
  

‘Connected as were these two great Branches of the United Empire (Great Britain and Ireland) by the Legislative Union, the severance of that Union would imply not merely a separation of the Government, but of the people of both countries — the dissevering of that link which could only be destroyed by the agency of the people themselves — the dissolving of all those ties which now connected the two countries. Suppose this to be effected, what would be the consequence? It would be to expose both kingdoms thus weakened to the attacks of foreign enemies; it would be to introduce a state of things which must weaken and lead to the ruin of both countries, but which would more especially be felt by that part of the United Kingdom which it was sought to delude by specious declarations on this question.’


Lord Macaulay:
  

‘The repeal of the Union we regard as fatal to the Empire, and we never will consent to it — never, though the country should be surrounded by dangers as great as those which threatened her when her American colonies and France and Spain and Holland were leagued against her, and when the armed neutrality of the Baltic disputed her maritime rights; never, though another Bonaparte should pitch his camp in sight of Dover Castle; never, till all has been staked



---

p.99




and lost; never, till the four quarters of the world have been convulsed by the last struggle of the great English people for their place among the nations.’ — April 23rd, 1845.


Mr. Disraeli:
  


Lord Beaconsfield, then Mr. Disraeli, in closing the debate in 1874, on Mr. Butt's motion, showed the utter impracticability of an Irish Parliament. He concluded his speech as follows:
  

‘I am opposed to this motion because I think there are involved in it the highest and nearest interests of our country. I am opposed to it for the sake of the Irish people as much as for the sake of the English and the Scotch. I am opposed to it because I wish to see united at an important crisis of the world — a crisis that perhaps is nearer arriving than some of us suppose — because I wish to see a united people welded in one great nationality, and because I feel that if we sanction this policy, if we do not cleanse the Parliamentary bosom of all this ‘perilous stuff,’ we shall bring about the disintegration of the kingdom and the destruction of the Empire.’


Professor Goldwin Smith, who was well known as a strong Radical, wrote from Toronto to the Daily News in 1886 protesting emphatically against a separate Legislature for Ireland. He said:
  

‘You can hardly doubt that an Irish Parliament means separation, the avowed aim of Mr. Parnell, who 



---

p.100




is not a reformer, but a sworn enemy of Great Britain. You may impose limitations, but they will not be worth the paper they are printed on. The agitation for their abolition will commence on the morrow of the capitulation. Nor, depend upon it, will dismemberment stop there. By want of patriotic leadership the spirit of your people is being broken, and they are being prepared to abdicate their greatness. Is it not better to show a little British fortitude and patience before we strike our flag?’


In another letter he wrote:
  


‘The repeal of the Legislative Union and its inevitable sequel, the carving of a hostile Irish Republic out of the flank of the United Kingdom, would, as we believe, be fatal to the power and greatness which are the common heritage of our whole race. We shall bow our heads in shame unutterable, and be unable again to look a foreigner in the face if Mr. Gladstone or anyone else succeed in persuading the nation to commit so foul, so dastardly, and, at the same time, so suicidal a crime as the abandonment of the Loyalists of Ireland’ (1886).


Mr. John Stuart Mill:
  

‘It is my conviction that the separation of Ireland from Great Britain would be most undesirable for both, and that the attempt to hold them together by any form of federal union would be unsatisfactory while it lasted, and would end either in reconquest or in complete separation. For generations it is to be feared that the two nations would be either at war or in a



---

p.101



 

chronic state of precarious and armed peace, each constantly watching a probable enemy so near at hand that in an instant they might be at each other's throat. By this state of their relations it is almost superfluous to say that the poorer of the two countries would suffer most. To England it would be an inconvenience, to Ireland a public calamity, not only in the way of direct burthen, but by the paralysing effect of a general feeling of insecurity upon industrial energy and enterprise. Let it not be supposed that I should regard either an absolute or a qualified separation of the two countries otherwise than as a dishonour to one and a serious misfortune to both.’ (From England and Ireland.)


Mr. Matthew Arnold:
  


In an article entitled The Nadir of Liberalism, in the Nineteenth Century for May, 1886, Mr. Matthew Arnold says of Mr. Gladstone's Irish schemes:
  

‘The project of giving a separate Parliament to Ireland has every fault which a project of State can have. It takes one's breath away to find an English statesman propounding it. With islands so closely and inextricably connected together by nature as these islands of ours, to go back in the at least formal political connection attained, to make the political tie not closer but much laxer, almost to undo it — what statesmanship! And when, estranged from us in feeling as Celtic Ireland unhappily is, we had yet in Ulster a bit of Great Britain, we had a friend there, you propose to merge Ulster in Celtic Ireland! You



---

p.102




propose to efface and expunge your friend! Was there ever such madness heard of?’


Sir Henry Campbell-Bannerman:
  

‘We all desire to extend to Ireland the full benefit of any system of local government which we enjoy ourselves, and give them the control of their own affairs to the same extent as we have of ours. But when we come to the question of giving them a separate Parliament and a separate Government, then, he confessed, he saw great difficulties, and he did not think that was likely to be consented to by any Government whether Whig or Tory, because it would not be consistent with the maintenance of the integrity of the Empire and their duty to the Crown.’ — ( Scotsman, Nov. 13th, 1885.)


Rev. C. H. Spurgeon (1886):
  

Alderman Cory, of Cardiff, a Radical opponent of Mr. Gladstone's Home Rule proposals, received the following letter from Mr. Spurgeon:
  

‘I am altogether at one with you. Especially I feel the wrong proposed to be done to our Ulster brethren. What have they done to be thus cast off? The whole scheme is as full of dangers and absurdities as if it came from a madman, and yet I am sure that Mr. Gladstone believes that he is only doing justice and acting for the good of all. I consider him to be making one of those mistakes which can only be made by great and well-meaning men.’




---

p.103


Karl Blind, the Exile Revolutionist, then resident in England (1886):
  

‘If you wish to break down the strength, to cut the very heart root of your Parliamentary power, which has been gained in so many hard popular struggles, and to open the way for the possibility of intrigues of some future despotically minded ruler or statesman, then by all means establish two legislatures —one for an ‘Irish nation’, so that constant friction shall arise, which may be made use of by an ambitious schemer. If you wish to render an alliance defensive and offensive possible between some foreign Powers, or combination of Powers, hostile to England, and an organised enemy in Ireland, then set up Home Rule for those whose real aim is secession, and as soon as you are in a great difficulty, or a series of difficulties, abroad the enemy will have a splendid opportunity for ‘destroying the last link,’ as Mr. Parnell has fairly warned you beforehand. If you want to get rid of ‘retrenchment’ for ever and to be compelled to militarise your institutions out and out so as to be constantly on your guard against a never-ceasing danger in your closest neighbourhood then let a Parliament come together in College Green, which at the first propitious moment could seize sovereign power and call upon all soldiers of Irish birth to flock to its standards in order to carry out the often-avowed final aims of Mr. Parnell.’


Count Beust, the eminent statesman, who established Dualism in Austria-Hungary (1886):
  



---

p.104




‘Hungary could not exist apart from Austria. Surrounded by Slav States, it would be crushed out of life, swallowed up. Ireland, however, is an island having no neighbour but England. Give it over to the government of a faction which hates the English, and on the first occasion of a difference between England and America or France it will be used as the basis for an attack against England. This danger will become so apparent to the English that their first thought, after having relaxed their hold upon the island, will be that they must reconquer it. The thing will have to be done some day, and, as the ultimate prospects of the Irish question is thus war with the faction that hates England, it is better that the English should brace themselves to cope at once with that faction while they can do so with a certainty of success.’


Lord Hartington (the late Duke of Devonshire), 1887:
  

‘If we look at the speeches and declarations of the leaders of the Separatist party in Ireland before the proposals which were ever made by Mr. Gladstone, if we look at the speeches which even now are made by members of Mr. Parnell's party in America, if we look at the declarations and the opinions of the Irish party in America, which exercise so great an influence on the counsels of the Home Rule party in Ireland, we shall come, I think, to the conclusion that the real object for which they have been striving, the real object for which they are striving now, is not for any limited



---

p.105




system of Home Rule, not for any limited and subordinate parliamentary government such as is offered to them, but for national independence and for complete separation from Great Britain. And, again, gentlemen, if we look at the course of the struggle which is taking place in Ireland itself, if we look at the causes of the resistance to the law which is going on, we shall find that the struggle partakes far more of an agrarian struggle for the possession of the land than for any reform or change in the system of the government of Ireland.’


Mr. J. A. Froude (1893):
  


‘Such respect for law and order as exists in Ireland is entirely due to English authority. Remove it, and the old anarchy will and must return. The Union has enabled Ireland to prosper better than it ever did before. If it has prospered no better it is because we have made Ireland the battle-ground of our own political factions. Mr. Gladstone's proposal of Home Rule is only the latest and worst instance of this. Separation will not result from the passing of Mr. Gladstone's measure, because England cannot and will not allow an independent or hostile power to establish itself so close to us. But if that measure is passed there will be a dangerous and desperate war, in which other countries may take part who would gladly see our power broken.’


Captain Mahan, the great American naval expert, writes:



---

p.106




‘It is impossible for a military man or a statesman with appreciation of military conditions, to look at the map and not perceive that the ambition of the Irish Separatists, realised, would be even more threatening to the national life of Great Britain than the secession of the South was to that of the American Union. It would be deadlier also to Imperial aspirations; for Ireland by geographical position lies across and controls the communications of Great Britain with all the outside world, save only that considerable, but far from preponderant, portion which borders the North Sea and the Baltic. Independent and hostile, it would manacle Great Britain, which at present is, and for years to come must remain, by long odds the most powerful member of the federation, if that take form. The Irish question, therefore, is vitally important, not to Great Britain only, but to the Colonies. The legislative supremacy of the British Parliament, against the assertion of which the American Colonists revolted, and which to-day would be found intolerable in exercise in Canada and Australia, cannot be yielded in the case of an island, where independent action might very well be attended with fatal consequences to its partner. The instrument for such action, in the shape of an independent Parliament, could not safely be trusted even to avowed friends.’


The Land Question
-----------------


One of the most important questions with which we in Ireland have had to deal has been the settlement of the land. For hundreds of years there has been continual strife between the landlord and the tenant in Ireland, with the result that the farmers could not settle down to steady work. In 1835 a start was made in the right direction. Mr. Sharman Crawford, who was then member of Parliament for Dundalk, introduced the first Tenant Right Bill, which proposed that the Irish tenant, in the event of disturbance, should be entitled to compensation for outlay on his land, but the Bill did not pass. In 1843 Sir Robert Peel appointed a Commission known, from its chairman, as the Devon Commission. Its recommendations were on the same lines as those contained in the Bill of 1835 — the recognition of the Ulster custom, or something analogous to it, for the protection of the tenants. Parliament, however, refused to give effect to these recommendations, and the tenant remained at the mercy of the landlord. In many districts such a system of land tenure naturally led to abuses and created bitter feelings



---

p.108



 which even the wiser legislation of later years has not yet entirely eradicated. The Act of 1860 endeavoured to put an end to all ‘customary’ tenures, and declared that the relations between landlord and tenant should be governed solely by contract. It was unjust and unworkable, and made matters worse than ever. Ten years later the great Land Act was passed, which Mr. Gladstone at that time described as final. He adopted the principle of the Ulster custom, and he gave the tenant a pecuniary interest in improvements he had made suitable to his holding. In addition to this, the smaller tenants were to receive compensation for disturbance. The larger tenants were supposed to be well enough able to look after themselves, and were excluded from compensation except for tillage, buildings, and reclaiming of land. Although this measure was considered Radical for those days, no serious opposition was offered to it either in the Commons or the Lords.


Bad seasons and the collapse in prices in the later 'seventies again brought distress and agitation, and in 1881 Mr. Gladstone once more took up the task of settling the Land Question. A Bill was introduced, in the shaping of which Ulster took a great and enlightened part. It established what was known as the ‘three F's’: Fair Rents, Free Sale, Fixity of Tenure. Under this measure judicial leases covering a period of 15 years were compulsorily substituted for tenancies at will,



---

p.109




and a land court set up to fix fair rents. Besides this, the right of the tenant to sell his interest in the holding was recognised and legalised, and he was secured from eviction except for non-payment of rent. Some people would have us believe that we owe this great measure to the Nationalists. But it must not be forgotten that on the occasion when the Bill was down for second reading in the House of Commons, Parnell and his followers walked out of the House. Speaking at Galway on October 1st, 1880, he had stated his views as follows:
  


‘I wish to see the tenant-farmers prosperous, but, large and important as is the class of tenant-farmers, constituting as they do, with their wives and families, the majority of the people of this country, I would not have taken off my coat and gone to this work if I had not known that we were laying the foundation in this movement for the regeneration of our legislative independence.’


This shows that Parnell cared little for the farmers of Ireland, and that he was only using them as pawns in the Home Rule game. So outrageous were the efforts of the Land Leaguers to obstruct the working of the Act that Mr. Gladstone was driven to a system of wholesale arrests, Mr. Parnell and some hundreds of his followers being lodged in Kilmainham Jail. Mr. Parnell did his best to discourage the farmers from taking advantage of



---

p.110




the Act, but the great bulk of them were more interested in Land Reform than in Home Rule, and did not accept his advice. Under the Act of 1881 and subsequent Acts passed by Unionist Governments, the Irish farmers have got reductions in their rents ranging from 40 to 50 per cent.


The policy of hindering Land Reform is still vigorously pursued by the leaders of the United Irish League, who have put an almost absolute stop to land purchase in Ireland, because they fear that, once the land is bought out by the occupiers, agitation will cease and the Home Rule movement suffer in consequence. In order to give the Act of 1881 a fair start, an Arrears Act was passed in the following year, under which arrears to the extent of £2,000,000 were wiped out. This was the last of Mr. Gladstone's Irish Land Legislation, and while we must allow him all credit for the benefits he conferred on the farmers in Ireland, it is well to point out that he was then strongly opposed to Home Rule. It soon became obvious that Mr. Gladstone's Act was only a temporary alleviation but not a permanent solution of the Irish Land Question, and that the only satisfactory settlement of the problem was that provided by the Unionists, who in 1885 passed the first practical measure of land purchase, based on the principle of the ‘Bright Clauses’ of the Church Act of 1869. It was



---

p.111



known as the Ashbourne Act, and under it £5,000,000 was allocated to the Irish farmers for the purchase of their holdings; but it did not take long for this money to run out, and in 1888 a further £5,000,000 was granted —24,000 farmers availing themselves of the benefits under both Acts. It is somewhat strange to find that land purchase, although advocated for a generation by Mill and Bright, has never found favour in the eyes of the modern Home Rule Radicals, and that both the Radical and Nationalist parties opposed the second grant of £5,000,000.


We now come down to 1891, when Mr. Balfour's Act was passed to extend and modify the two Ashbourne Acts, £30,000,000 further being provided for land purchase. The land itself formed the security, and Government Stock was issued which the landlords, who sold, might exchange for Consols. This Act greatly facilitated land purchase all over the country as well as the 40th Clause of the Land Act of 1896, an Act passed by the Unionists under which Second Term rents were fixed. The terms, however, did not prove sufficiently generous to induce the landlords to sell, and a conference of landlords and tenants was held in Dublin in 1902, when terms were agreed upon, which were afterwards embodied in Mr. Wyndham's Act of 1903, which gave the landlord a bonus and induced him to sell on terms which gave the tenants a reduction ranging from 4s.



---

p.112




to 6s. in the £1, the entire purchase-money being wiped out in 68 1/2 years. The success of this Act can be gauged from the fact that in a little over four years sales had been made between landlord and tenant for half the unsold lands in Ireland. From the passing of the Wyndham Act until October 31, 1909, 217,219 holdings were sold, and the amount of purchase-money was £73,642,689. Between August, 1886, and October, 1909, 288,618 farms were sold, and the total amount of the purchase-money guaranteed by the Imperial Parliament was £97,535,287.


The result of this was that over large areas of Ireland order and industry began to supersede idleness and disorder. The farmers lost all interest in the Home Rule movement, and refused to subscribe to its funds. Naturally such a change was regarded with dismay by the Nationalist leaders, who soon availed themselves of the chance to obstruct further land purchase.


In 1909 Mr. Birrell introduced a new Land Purchase Bill at the dictation of Mr. John Dillon and the extreme men of the Nationalist party. The Bill itself increased the amount the tenant had to pay and reduced the amount of the landlord's bonus, thereby putting an almost complete stop to land purchase. This is plainly seen from the fact that the sales under the Wyndham Act averaged £12,000,000 per annum, while the average under



---

p.113




the Birrell Act does not reach £1,000,000 per annum. It cannot be denied that most of the agitation in Ireland during the last hundred years was due to the passionate desire of the Irish farmers to become possessed of their land. Parnell was clever enough to use the land agitation for pushing Home Rule along, but those farmers who have purchased their holdings have really no desire to see an Irish Parliament established. Most of them have ceased contributing to the fund of the United Irish League, and they take a very languid interest in the demands of the professional agitators for Home Rule. In fact, all they desire is to be left alone. Thus when Mr. John Redmond wants money for the Home Rule agitation he has to go to America for it.


Secret Societies
----------------


Since the time of Elizabeth Secret Societies in Ireland have played a large and evil part in the agitations that have been kept up against the English connection. At the present time the secret society which dominates the policy of the Irish Nationalist Party is known as the Ancient Order of Hibernians, and, although it has not always had this title, as the subsequent pages of this chapter will show, it has had a direct and unbroken continuity from the Elizabethan times. In Great Britain the Nationalists have done their best to make this Society appear as a harmless benefit society giving sick relief to its members and assisting them when out of work; but there is no difficulty in proving that its principal object is to drive the English Government out of Ireland. There is no one who has read Irish history who will fail to recoil with horror at the terrible outrages and murders which have been perpetrated by members of this Order in bygone days, and in all the speeches that have been made by its present-day leaders we search in vain for any words of condemnation.




---

p.115


A few years ago it was officially stated that its membership numbered 380,000, and probably by this time its numbers will have increased to 400,000. We have not heard so much about this Order as we have about the Irish Society in America which is known as the Clan-na-gael. The Parnell Commission of 1890 showed the true character of the Clan-na-gael brotherhood, and the finding of the three judges on their inquiry into the connection between the so-called ‘constitutional’ agitation in Ireland and the extreme movement among the Irish in America presents it in its true colours. In the course of their finding the judges said:
  


‘We are of opinion that the evidence proves that the Irish National League of America has been, since the Philadelphia Convention, April 25th, 1883, directed by the Clan-na-gael, a body actively engaged in promoting the use of dynamite for the destruction of life and property in England. It has not, however, been proved that Mr. Parnell or any of the respondents knew that the Clan-na-gael had obtained control over the Irish National League of America, or was collecting money for the Parliamentary Fund, and the circulars of that body, as well as the evidence of Le Caron, show that their operations were secret. But, though it has not been proved that Mr. Parnell and the other respondents knew that the Clan-na-gael controlled the League, or that the Clan-na-gael was collecting money for the Parliamentary Fund, it has been proved



---

p.116




that they invited and obtained the assistance and cooperation of the Physical Force Party in America, including the Clan-na-gael, and in order to obtain that assistance abstained from repudiating or condemning the action of that Party. It has also been proved that the respondents invited the assistance and cooperation, and accepted subscriptions from Patrick Ford, a well-known advocate of crime and the use of dynamite.’


Mr. John Redmond has told us in his speeches of ‘a great unknown power’ waiting for an opportunity which might arise to have recourse, if necessary, to unconstitutional methods to advance the cause of Ireland, but he cannot mean by this the Clan-na-gael, as the Parnell Commission has thrown so much light on it that it is now fairly harmless. The principal Nationalist secret organisation which exists in Ireland to-day is the Ancient Order of Hibernians, sometimes nicknamed the Molly Maguires, and it may be fairly assumed that it is the ‘Unknown Power’ behind the Parliamentary movement. The antecedents of the society do not fill one with respect. Its early history (when it had another name) is one of pillage, murder, and rapine. From its foundation in 1565 by Rory Oge O'More it has undergone many changes in name, but its character has always remained the same. The names it has been known by are the following: —(1) Rapparees, (2) Whiteboys, (3) White Feet,



---

p.117




(4) Black Feet, (5) Defenders, (6) Ribbonmen, (7) Molly Maguires, (8) Lady Clares, (9) Terry Alts, (10) Rockites, (11) The Hibernian Society, (12) Hibernian Sick and Funeral Society, (13) St. Patrick's Fraternal Society.


Rory Oge O'More was captain of an organised band whose duty ostensibly was that of protecting Roman Catholic priests while at Mass. Had this been its true object the society would have started on a creditable basis, but it has been proved that its original members were nothing more or less than a band of lawless brigands whose chief aim was to attack small towns or villages, burn the Protestant houses, and murder and mutilate the inhabitants. This is proved by a letter from Sir Henry Sidney to Sir Francis Walsingham, whose son was a prisoner in the hands of the rebel leader when the English soldiers attacked his house. The letter states:
  

*‘The villainous rebel (Rory Oge O'More) fell upon my most dear nephew, being tied in chains and him most shamefully hacked and hewed with my nephew's own sword, to the effusion of such a quantity of blood as were incredible to be told. He brake his arm with that blunt sword and cut off the little finger of one of his hands, and in sundry parts of his head so wounded him as I myself in his dressing did see his brain moving.’’’*

(Calendar of Carew Papers, 1575, p. 356.)






---

p.118


So much for the founder of the Ancient Order of Hibernians, whose career was one of horrible crime, and yet the Nationalist Party of to-day look upon him as a hero. He died in 1578, and was succeeded by Donald O'Driscoll, who continued to hold sway till he was killed in battle by the English troops. He was succeeded by the son of Rory Oge O'More, who continued the cruel methods of his father, till in 1600 he was slain in a fight with Queen Elizabeth's troops. Not much is heard of the ‘Rapparees’ till the Cromwellian settlement of Ireland took place, when their depredations broke out afresh. It is a strange fact that the Rapparees were then denounced by the Roman Catholic Synod of Ardpatrick as lawless bandits, but at the present time Pope Pius X. is said to be the most powerful friend of the Order, and the ban which until lately existed forbidding priests to become members has now been rescinded, and many of them have since joined the Order. The Order itself is, according to the late Mr. Michael Davitt, the most powerful pro-Celtic organisation in the world. It has branches in many lands, and in America the number of its lodges have reached the total of 6,000. The membership of this Order is divided into two degrees, the first of which has the majority. The oath is not administered nor secrets communicated to members of the first degree. The second degree consists of the initiated, who are bound to one another by



---

p.119




terrible oaths. The following formula was made known by evidence given before the Select Committee on Westmeath Unlawful Combination in 1871, the society at this time being known as Ribbonmen:
  


‘I (A. B.) hereby agree to become a true and loyal member of this Society, and I solemnly swear before Almighty God to be true and loyal to the Brotherhood and to each member of the same, and I will be obedient to my committee and superior officers, and agree to all their articles, laws, rules, and regulations that have been since the commencement and all amendments added thereto, and to perform all duties imposed on me with loyalty, faith, and fidelity, and I swear that neither hopes nor fears, rewards nor punishments shall induce me to give evidence against any brother or brothers for any act or expression of theirs done or made collectively or individually.
  

And in pursuance of this obligation I swear to aid as best I can, with purse and person, any brother or brothers who may be in distress.
  

And I further swear to owe no allegiance to any Protestant or Heretic Sovereign, Ruler, Prince or Potentate, and that I will not regard any oath delivered to me by them or their subjects, be they judge, magistrate, or else, as binding.
  

And I swear to aid as best I can any brother or brothers who may be on trial for any act or expression of theirs before magistrate, judge, jury, or else, and to be ready at all times to aid by every means in my



---

p.120




power to assist in preserving his or their liberation; and if myself a witness to disregard any oath delivered to me on such occasions by judge, magistrate, counsel, lawyer, official, or else, and that I will not regard such oath as binding.
  

And in revenge for the sufferings of our forefathers and protection of our rights I further solemnly swear to aid as best I can in exterminating and extirpating all Protestants and heretics out of Ireland or elsewhere; to hunt, pursue, shoot and destroy all Protestant or heretic landlords, proprietors, or employers. And also to hunt, shoot, pursue, and destroy all landlords or proprietors belonging to the Church of Rome should he or they evict his or their tenants from any house, land, home, or holding of theirs.
  

And I further solemnly swear to aid as best I can in burning down, sacking, and destroying all Protestant or heretic places of worship, and all houses used as such by members of different heretical denominations in this country, and to level the same to the ground.
  

I also solemnly swear to have no intercourse, communion, or trade, neither to buy or sell, barter or exchange, give or take, or have any dealings whatever with the said Protestants or heretics unless on such occasions as cannot be avoided.
  

I also swear to defend the farmer, the poor man, the widow and the orphans of any brother or former brother against the oppression of the landlords and the tyranny of Saxon laws.
  
And I further solemnly swear to do all in my



---

p.121



 

power to procure the independence of Ireland, and aid as best I can in allowing none but Irishmen to possess Irish land and Ireland for the Irish.
  

I solemnly swear to shoot, destroy, hunt and pursue to death any former brother who may turn informer or traitor, or who may refuse to perform any duty ordered by his committee or superior officers, or any duty which may fall by lot or otherwise to execute; and I agree that my person shall be at all times at their service to go wherever required, or do whatever sent, and also to aid by every means in my power any brother or brothers of this Society executing the orders of other committees or officers belonging thereto, though not in my district, and to aid as best I can him or them in the performance of their duty.
  
 And I most solemnly swear to keep all secrets, passwords, signs, orders, or otherwise belonging to this Society, and that I shall never divulge the same by word of mouth or otherwise.’


The form of this Oath will suffice to show what a disloyal, treasonable, and, above all, purely sectarian body of men composed its membership. 


Among the successors of the Rapparees organisation the best known is that of the Whiteboys. It made its appearance in January, 1762, and received the name of Whiteboys on account of the members wearing their shirts over their coats at night for the purpose of disguise. Their chief work was the organising of agrarian outrages for the redress of their grievances, and the barbarism



---

p.122




which they displayed knew no bounds. They hated the landlords and practised the most terrible cruelties towards them. Gordon, in his history of Ireland, describes their methods in the following words:
  

‘Besides other atrocities, these misguided people (Whiteboys) placed men quite naked on horseback, on saddles covered with skins of hedgehogs, and drove them before them in excruciating pain; or left them standing many hours buried to the chin, in holes in the ground, with branches of thorns trodden closely round their bodies.’


Lecky also tells us ‘that the ‘mildest’ punishment was to drag a man out of his bed, often in mid-winter, beat him, and leave him bound and naked in a ditch by the roadside; not infrequently they put a man in a newly dug grave and left him, occasionally with his ears cut off, buried up to his chin in earth, in thorns and furze.’ Their outrages were so horrible and their cruelty so great that they were denounced by the Roman Catholic Archbishop, James Butler, as ‘a gang of wretches heaved out by hell’ and as ‘deluded victims of the devil,’ and he declared that their ‘accumulated enormities call to Heaven for vengeance.’ This society existed till after 1830, when it became known as the Ribbon Society, but in the meantime a branch of the Whiteboys appeared in Ulster under the name of Defenders,



---

p.123



 

whose chief aim and object was to exterminate Presbyterians, and so violent and aggressive did they become that the Presbyterians in self-defence formed themselves into a society known as the Peep o' Day Boys. Plowden, who was a Catholic himself, has said in his Historical Review, that the character of the crimes of the Defenders was of a much darker dye than that of their opponents, and in 1794 he states that the Defenders committed depredations without control and indulged in all sorts of crimes. Lecky states in his history that:
  


‘It ceased to be either a league for mutual protection or a mere system of religious riot. It assumed the usual form of a secret and permanent organisation, held together by oaths, moving under a hidden direction, attracting to itself all kinds of criminals, and making itself the organ of all kinds of discontent.’


One might easily fill a large book with stories of the atrocities committed by the Defenders, whose conduct was as brutal as it was criminal, and who evidently thought that the end justified the means. But, as has always been the case with these illegal societies, they did not succeed in benefiting anyone, not even themselves. So much for the Defenders, who on the eve of the Rebellion of 1798 joined the United Irishmen, and ultimately gained the control of that organisation after most of the Protestants had withdrawn from it disgusted



---

p.124




with the cruelties of the Wexford rebels, who put to death the Protestant ‘heretics’ wholesale, 538 being deliberately murdered in cold blood in that county alone.


About the year 1812 the Ribbonmen became active. Like their predecessors, they continued to organise outrages against Protestants, and so violent did their crimes become that not only was the Government compelled to take special measures against them, but the Society itself was also condemned by the Roman Catholic Bishop, Doyle, who charged it with ‘establishing a reign of terror through the country.’


The Ribbonmen were known by different names, but no matter by what title they went they had only one object in view, and that was to expel the Protestants from Ireland. Bishop Doyle denounced them as ‘making war like the savages of the Desert.’ In a recent history of the Ancient Order of Hibernians the Ribbon organisation is described as ‘a grand and noble Society.’ Those who took the Ribbon oath swore to owe no allegiance to a Protestant Sovereign, to murder all the Protestant landlords, and to destroy all Protestant places of worship. Another form of the Ribbon oath included a clause to ‘wade knee-deep in Orangemen's blood.’


Mr. A. M. Sullivan, a well-known Nationalist, has described the Ribbon Society as ‘a hideous organisation of outrage and murder.’




---

p.125


The late Mr. Michael Davitt declared that the Ancient Order of Hibernians is ‘the trans-Atlantic offspring of Ribbonism in Ireland.’ Ireland has had many secret societies under Nationalist auspices, and their aim may be summed up in one brief sentence — Hatred of England and Hatred of Protestantism.


From the foregoing quotations it is quite clear that, whatever may be the character of the Hibernian Order of to-day, it originated in disloyalty, cruelty, outrage, and crime.


While no one contends that the Hibernians now display the bloodthirsty characteristics of their predecessors, still, the events of the last few years show that their presence makes for sectarian discord in Ireland. Not only that, but their whole weight is used to crush all those who dare to doubt the infallibility of the Nationalist leaders. The Cork Free Press (the organ of Mr. William O'Brien, who was fighting for Home Rule before many of the present generation were born), in an article in its issue of September 13th, 1910, sets out the present character of the Hibernian Order in plain but unmistakable language:
  


‘The most significant feature of Mr. Dillon's speech (at Limerick, September 11th, 1910) was his open championship of the Molly Maguires. Mr. Dillon indulged in the usual rubbish about a Ribbon Society, which was under the ban of the Church, ‘having protected the Faith of our Fatherland.’ He now asks



---

p.126




that the name of an organisation steeped in crime and outrage throughout its whole history should be inscribed as a term of honour on the National banner. This, of course, means that he wants to convert the National movement into an avowedly secret and sectarian one. We tell Mr. Dillon in his own words that no more ‘infamous treachery’ could be perpetrated against the cause of Irish Nationality than to prostitute it to the design of making Molly Maguireism dominant in Irish politics. This detestable secret society may suit Mr. Dillon's purposes, as it provides the machinery for carrying out the outrages on public liberty which took place at Crossmolina and Dundalk. But he has himself confessed that its supremacy in Ireland would make Home Rule impossible except by force of arms. In order to maintain his own evil ascendancy he is prepared to see ruin brought or the Irish cause, and to hand over the country to an intolerable and degrading tyranny. We venture to tell Mr. Dillon that this open treason to Ireland he will never be able to accomplish. Mr. Dillon described it as ‘an infamous falsehood’ that the object of Molly Maguireism is the extermination of the Protestant community in Ireland. We repeat that it is nothing but the simple truth. The fundamental object of the Hibernian Society is to give a preference to its own members first and Catholics afterwards as against Protestants on all occasions. Whether it is a question of custom, office, public contracts, or positions on public boards, Molly Maguires are pledged always to support a Catholic as against a Protestant. If Protestants



---

p.127



 

are to be robbed of their business, if they are to be deprived of public contracts, if they are shut out of every office of honour or emolument, what is this but extermination? This is Molly Maguireism naked and unashamed, and all the strong language Mr. Dillon can muster will not alter the fact. The domination of such a society would make this country a hell. It would light the flames of civil war in our midst and blight every hope of its future prosperity. To imagine that England would ever give Home Rule to a Molly-Maguire-ridden country is sheer lunacy. The fact is that the salvation of the Irish cause depends on the utter overthrow and rooting out of this baneful sectarian organisation.’


These are the words of a Home Ruler, who knows the true aims of the Nationalist party. They show the danger to which Protestants and Unionists would be exposed under a Home Rule Parliament, for to-day the Ancient Order of Hibernians is supreme in the councils of the Irish Party. Its decrees, as Mr. O'Brien clearly shows, would mean ‘extermination of the Protestant community.’ If the English people hand over the Protestants of Ireland to the rule of Secret Societies, they will do so with a full knowledge that it means their extermination. The only hope left to the Protestants would be to meet and overcome their enemies by physical force.


Position Of Ulster
------------------


Mr. John Redmond in a recent article on Home Rule declared that there was ‘no Ulster question.’ He might have as truthfully declared that there was no such thing as matter. From the moment Home Rule was introduced the Protestants of Ulster spoke with no uncertain sound against it. In the days when Mr. Gladstone was denouncing the attempt to break up the Union he had a large and enthusiastic following in Ulster, but the moment he surrendered to Parnell, Ulster Liberals bade him a final good-bye, and combined with their Conservative neighbours for the purpose of combating the attacks on the Legislative Union.


Since 1886 Protestant Home Rulers have been as scarce in Ulster as white blackbirds. As showing the hostility of Protestants to Home Rule, it may be noted that out of a thousand non-episcopal clergymen in Ireland in 1892, only eight were in favour of Home Rule, and of these eight there were some who made reservations. Ulster Protestants, whether episcopal or non-episcopal, were almost to a man opposed to Home Rule in 1886 and 1893, and the feeling of opposition has not



---

p.129




decreased in the interval. The attitude of the Protestants of Ulster is fully endorsed, not only by the Protestants of the other three provinces, but by a large and growing section of influential Roman Catholics, who, having had experience of the lawlessness practised by the Nationalist organisations, do not wish to see more power entrusted to them.


It is sometimes said that Irish Protestants object to Home Rule because they fear it would destroy their ascendancy, but there is no Protestant ascendancy in Ireland to-day. In fact, since the disestablishment of the Church of Ireland in 1869, there has been no religious ascendancy in Ireland. All parties and all denominations stand on an equality. If the Protestants occupy a larger share of the official positions than the Roman Catholics, it is because of their superior education. For the greater part of sixty years the Queen's Colleges in Belfast, Cork, and Galway were banned by the Roman Catholic Hierarchy, so that the majority of the Roman Catholic youth of Ireland did not venture to attend them, and were thus, by the intolerance of their ecclesiastical rulers, deprived of university education. Almost all the Government offices are filled by open competition, and the best educated man selected. The Roman Catholics have no real grievance in this matter.


The people in Ulster know from the lessons of 


---

p.130




history and from the lessons of everyday life, that Home Rule would fill the country with religious rancour and civil strife. They hold, as Mr. Gladstone held for the greater part of his life, that ‘if Ireland were detached from her political connection with this country (Great Britain) and left to her own unaided agencies, it might be that the strife of parties would then burst forth in a form calculated to strike horror through the land.’ Home Rule would mean the dethronement of liberty and the establishment of a tyranny worse than any the country has ever seen. It is a well-known fact that the moment the Home Rule controversy becomes acute, religious differences become more marked. With the disappearance of the danger after the rejection of the Bill of 1893, a more kindly spirit began to spread over the country, and all parties, both the Protestants of the North and the Roman Catholics of the South, co-operated in promoting the material welfare of the people. The reappearance of Home Rule has already checked this beneficent movement, and has done much harm to the best interests of the country. Irish Protestants, the large majority of whom are living in Ulster, constitute about one-third of the Irish population, and they hold that their past history, as well as their present position, entitles them to the sympathy of their brethren in Great Britain. They are constantly abused by the



---

p.131



 

Nationalists because of their loyalty to Great Britain. They are proud of the fact that their forefathers who settled in Ireland three or four hundred years ago, were Scotsmen and Englishmen. They have lived up to the best traditions of those from whom they have sprung. They have given the United Kingdom some of its finest soldiers and statesmen. Wherever the Imperial flag has been planted there Ulstermen have always been ready to defend it. Are we to be told to-day that loyalty is a crime, and that the loyal must submit to be trampled underfoot by the openly disloyal? Englishmen and Scotsmen should remember the sacrifices that Ulstermen have made in order to maintain the unity and the greatness of the United Kingdom, and they should lend them a sympathetic ear when they protest against being cut off from the privileges of British citizens.


Ulstermen know that Mr. Redmond's promised safeguards would not be worth the paper on which they were written. No one in Ireland, whether he be Unionist or Nationalist, seriously imagines that Home Rule would not greatly increase the power of the Church of Rome in Ireland. If Mr. Redmond even tried to thwart the power of that Church he would be speedily driven from public life. No one knows this better than Mr. Redmond, who has had experience of how ruthlessly the Roman Church crushed the Parnellites after the divorce case. Ulstermen are not prepared to submit their 


---

p.132




civil and religious liberties to the Church of Rome, and they know that, no matter what paper guarantees may be given under an Irish Parliament, the Protestants of Ireland would be as effectively under the control of that Church as if they lived in Spain or Quebec, and the experience of Protestants in those two countries are not such as to encourage Protestants in Ulster to submit to a Parliament which would always have as its main object the promotion of the interests of the Church of Rome.


But if there was no religious question whatever, Ulstermen would still be opposed to Home Rule, on the ground that it would have the effect of breaking up an Empire which they have had such a large part in building. Ulstermen know that the surest way of creating prosperity in Ireland is by maintaining the undivided rule of the Imperial Parliament. Ulster possesses no natural advantages over the other three provinces, and yet under the Union Ulster has progressed as satisfactorily as any other part of the United Kingdom. The reason for this is not far to seek. The brain and sinew of the men of Ulster have been applied to the building up of industries. In the other parts of Ireland the Nationalists have been too prone to spend their energy in promoting agitations. If the methods applied in Ulster had been applied to the other districts, we should hear less of poverty and discontent.



---

p.133



The Nationalists are in the habit of harping on the fact that the British Parliament, long ago, destroyed the woollen industry in Ireland, but they forget to add that the men who owned this industry were chiefly Protestants, and that their descendants, without nursing a grievance, put their shoulder to the wheel and created other industries that are now the pride of the country. Ulstermen believe that the social and economic conditions of Ireland make her specially unsuited for Home Rule. The population is divided on the lines of race and religion, and as the Belfast Chamber of Commerce put it in a manifesto issued in 1893, ‘the two parties are filled with distrust and with historical jealousy of each other. The chief economic necessity of the country is the development of manufactures, trade, and commerce; but the vast majority of the population have no appreciation of the conditions under which alone such necessity can be met. They do not seem to know that while a Government can destroy prosperity by destroying security and credit, no Government can create it in the face of insecurity and suspicion.’ It is because of the security given by the Imperial Government that the industries of Ulster have developed so rapidly. If the matter is looked at from a practical point of view it will be seen that Ireland is not capable of supporting a local Parliament. If 



---

p.134




Great Britain were to get local Parliaments on the population basis of Ireland she would be entitled to ten, and if on the basis of valuation, to fifteen or sixteen.


The total rateable valuation of Ireland is a trifle over £15,000,000 while that of England is £203,000,000, Wales £9,000,000, and Scotland £32,000,000.


 The valuation of Lancashire is £25,000,000 and that of the West Riding of Yorkshire £14,000,000, or only a little less than that of Ireland. London and Lancashire have each larger populations than Ireland. The amount of income-tax raised in Ireland last year was £1,825,234; in Great Britain, £58,679,860.


Ireland has very little mineral wealth compared with Great Britain. On the railways in Great Britain 507,903,360 tons of minerals and merchandise were carried in 1910; in Ireland 6,331,362 tons, and of this amount the railways terminating in Belfast carried 43.47 per cent. The total railway receipts of Great Britain last year amounted to £119,451,549 and those of Ireland to £4,402,655; the railways having their termini in Belfast contributing 38.04 per cent. of this amount. The capital of the Irish railways amounts to £44,114,441, while the capital of the Yorkshire and Lancashire is £69,988,806, London and North-Western £125,041,616 and Great Western £98,236,890.




---

p.135


The commercial and manufacturing districts are mainly to be found in Ulster. Under the protection of the Imperial Parliament Ulster has been able to build up her industries, but the larger part of the rest of Ireland has not got the business qualities that are necessary to the building up of industries.


As showing the effect which Home Rule would have on Irish credit, it is only necessary to point out that when Mr. Gladstone introduced his Bill in 1893, Irish securities depreciated to the amount of £5,000,000.


Since Mr. Asquith's pledge to make Home Rule the first item on his programme next year, Irish securities have been steadily declining. All over Protestant Ulster there are thriving industries, and the very existence of these industries depends on the maintenance of security. That security certainly would not exist under Home Rule. The linen industry, for example, is a great source of wealth and employment in Ulster, but what prospect would there be for it under the rule of Mr. Patrick Ford? Here are a few extracts from the Irish World (Mr. Ford's organ) on the Linen Trade of Ulster:
  


‘I was much impressed by an article by John F. Finerty, in which he has the wisdom and courage to declare that the destruction of the linen industry in Belfast was a matter that Irish Nationalists have no cause to deplore.’



---

p.136




‘Belfast is a little Orange den where they combine against the peace and prosperity of Ireland. Every Irish attack on England should include Belfast.’
  


‘It is to Belfast that every enemy and slanderer of Ireland flies when it is deemed politic by the English Cabinet to raise a disturbance and division in Ireland. If the whole place were engulfed in an earthquake Ireland would be stronger, richer, happier, and more tranquil.’)
  
 (February, 1888.)


These words have never been repudiated by any Nationalist leader. They are not the sort of words that the Nationalist agitators would care to use on a British platform, but for all that, we know by experience that their sympathies are with Patrick Ford, rather than with the men who have built up the Ulster Linen Industry. Because Ulstermen have shown that the country can be made prosperous and contented under the Union they are hated by the Nationalists. Ulster is a standing refutation of the charge that Ireland's backwardness is due to the Union. Ulster provides by far the larger part of the Imperial taxes at present raised in Ireland, and if further taxes were needed by an Irish Parliament — and this may be taken as a certainty — the burden would fall on the Ulster industries. Ulstermen would be helpless in an Irish Parliament, and the representatives of the farmers in the South and West would take care that



---

p.137




the extra burden of taxation was shifted on to the shoulders of the industrial classes in the North.


Mr. Birrell says he is anxious to allay the fears and suspicions of the Protestants, but he has not done much during the time he has been Chief Secretary to quiet these fears or remove these suspicions. By his University Act he has handed over higher education in three parts of Ireland to the Roman Catholic Church in total disregard of the great Liberal principle that no denomination should have any privilege in respect of its religious creed. He has also established the principle that public funds shall be used for the purpose of denominational teaching in primary schools. Under Home Rule the Roman Catholic authorities, who claim to be supreme in all educational matters, would take care that Protestant Ulster was forced to pay for the teaching of Roman Catholic doctrines. English Nonconformists object to State money being used for sectarian teaching, but unfortunately many of them are endeavouring to place Irish Protestants under a Roman domination which would use the public taxes for the support of Roman Catholic training. They talk, of course, about safeguards, but Cardinal Logue, the head of the Roman Catholic Church in Ireland, cares nothing for these so-called safeguards. On the passing of the Irish Universities Act, Mr. Birrell declared that the new Universities would be non-sectarian.



---

p.138




Speaking at Dundalk on June 6, 1911, Cardinal Logue said:—
  


‘Unfortunately, here in Ireland, up to the present, our young people were handicapped, and badly handicapped. We might educate them in a school like St. Mary's until they were fitted for any University in Europe, but when they passed out of this they found all the colleges closed against them. Trinity was under the ban of the Irish Church [he means the Roman Catholic Church] since I was a boy, and the Queen's Colleges were looked upon as Godless institutions. But now there is an opportunity for the Catholic laymen of Ireland. They have an opportunity now of receiving a good university education, in which, at least, they will be exposed to no danger. There is no doubt whatever, England never gave us any boon that they did not put a crook in. They always tried to do something to introduce the drop of bitterness into the sweetest cup that ever was. That is precisely what they did in giving us a University. They gave what they hoped to be a Pagan University, but, please God, we will turn it into a Catholic University. (Applause.) They have brought a Mohammedan institution into this country, but turn loose upon it a lot of fine young Irish Catholics, and they will soon make it a Christian institution. That is what we will do with this new University. No matter what obstacles the Nonconformists of England may have inserted in the constitution of the University to keep it from being made Catholic, we will make it Catholic in spite of them.’ (Applause.)




---

p.139


An Irish Parliament would have power to tax Protestant industries out of existence, and to establish a religious ascendancy as intolerant as the one that exists in Quebec to-day. If paper safeguards have been found worthless by the Protestants of Quebec they would be found equally worthless by Irish Protestants.


Ulstermen who realise the aspirations of the Nationalists are prepared to make any sacrifices rather than allow this new ascendancy to be established.


Home Rule would not build up; it would pull down and destroy what it has taken many years of laborious effort to establish. The men who were the authors of the Land League and the Plan of Campaign, and who adopt such brutal methods to-day for crushing out fellow-Nationalists who refuse to accept every detail of their programme, cannot be trusted to treat the loyal minority fairly. The people of Ulster are satisfied with the present position they hold in the Empire, and they are determined to remain citizens of the United Kingdom on equal terms with Englishmen and Scotsmen. They ask for no special privileges for themselves, and they object to their rights being impaired in order that special privileges may be granted to others.


Ulster's progress has taken place under the Union. Belfast was a small and insignificant town at the time the Union was consummated. In 1783 



---

p.140




the population was 13,105, in 1891 it was 255,950, and to-day it is almost 400,000. In 1837 the funds at the command of the three local Banks, which have head offices in Belfast, were £1,488,134; in 1892 the amount was £14,797,285; and at the present time it is £23,776,431.


In 1837 the tonnage of vessels clearing from Belfast was 288,143. In 1892 it had risen to 2,055,637 tons, while last year it was 2,800,285 tons.


Of the Irish contributions to the Customs revenue in 1909 Ulster contributed £2,119,353, as against £911,826 from the other three provinces.


Even as things stand at present Ireland could not afford to pay the extra cost which a local Parliament would entail, but if Ulster were cut off from the rest of the country the remaining three provinces would be in a hopeless financial condition. The arguments used by the Nationalists in favour of an Irish Parliament separated from Great Britain because of the differences of race, religion, and ideals apply with even greater force to Ulster in its relation to the Nationalist parts of Ireland. If, according to the Nationalist theory, Celtic Ireland ought to be divorced from the United Kingdom, then there is no reason whatever why Protestant Ulster — or, indeed, Protestant Ireland — should be forced into a Dublin Parliament. The Irish Parliament would be sure to legislate on lines abhorrent to the minority, and from the very



---

p.141



 

beginning there would be nothing but strife and turmoil. This incompatibility was never more forcibly shown than in the case of the General Council of Irish County Councils, which was established after the passing of the Local Government Act. The object of the Council was to deal with Local Government affairs, but it had not been in existence long before the Nationalists, who were in the majority, commenced to use it for Home Rule purposes, with the result that the representatives of the Unionist Councils were forced to leave it.


Those who imagine that Irish Unionists will accept a Home Rule Parliament after a mere verbal protest are under a serious delusion. In 1893 Unionist Clubs were established and every able-bodied Unionist was enrolled. The first object of the clubs was to defeat Home Rule by constitutional means, and the second was to make the rule of an Irish Parliament unworkable in Ireland. And just as elaborate measures were taken to attain the first object, precautions were taken to give effect to the second. People who are not in earnest do not go to the expense of arming and drilling. Irish Unionists felt that it was wiser to run all the risks of civil war rather than submit to the tyranny of a Dublin Parliament. They felt that the Nationalists unaided could not crush them by force of arms, and they were confident that the British people would never coerce them by employing an



---

p.142




army against them. This policy was not lightly adopted. It was only after the most anxious thought on the part of men who for years had been fighting every form of ascendancy that it was decided to resist a Home Rule Parliament to the death. The Nationalists like to represent it as bluster, but the men who directed the policy of Irish Unionists then, and those who direct it to-day, have not been accustomed to bluster, and it is well Englishmen and Scotsmen should realise that when Irish Unionists declare they will neither obey the laws passed by an Irish Parliament nor pay the taxes levied by it, they mean what they say.


There are no differences among Protestants on this question. Presbyterians, who are chiefly concentrated in Ulster, are just as determined as Episcopalians; and be it remembered that Presbyterians went out from Ulster by thousands in the eighteenth century rather than submit to intolerance, and they furnished the American Colonists with many leaders, who were among the most determined advocates of Independence. A recent writer in the Times says of the Ulster leaders that they are men of ‘high intelligence whose minds have been broadened by education and by the liberalising effects of their world-wide commerce. But unless I greatly misread them, the old Adam is by no means dead in them yet. The character which led their ancestors to resent and to avenge — in the American Rebellion — the wrongs



---

p.143




done the Presbyterians by the Irish Government, with the connivance of the English Government, has come down to them unchanged. Were they to suffer a like injustice they would assuredly brood over their grievances with a sullen anger not less deep and not less constant.’
  

The same writer truly says that:
  

‘The whole Protestant community is unanimous that the most strenuous and determined resistance must be offered to any kind of Home Rule, and quite resolved, with rare exceptions, to push this resistance in case of need beyond legal limits.’


This is no over-statement of the case. Irish Unionists hope that Great Britain in its wisdom will not establish a Parliament in Dublin; but if the worse comes to the worst, then they will confidently defy it, and one thing is certain, that the descendants of the men who held Londonderry, in face of pestilence, fire, and sword, against overwhelming odds, will never submit to be ruled by their hereditary enemies.




