

#The Natural History of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Natural History of Ireland
==============================


Author: Gerard Boate
--------------------


### File Description

Electronic edition compiled by Beatrix Färber

Proof corrections by Beatrix Färber

Funded by University College, Cork and  
School of History 2. Second draft, revised and corrected.Extent of text: 
51075 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland—http://www.ucc.ie/celt

 (2015) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E650002-001Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Notes

#### Sources


**Further reading**2. Barnaby Rich, New Description of Ireland, London 1610.
3. William Camden, Britannia [in Latin] (London 1610). The first translation into English by Philemon Holland was published in 1610. (A full critical edition in Latin and English is available at http://www.philological.bham.ac.uk/cambrit/). A second edition, translated into English, with additions and improvements was published by Dr Edmund Gibson 1722.
4. Thomas Crofton Croker (ed.), The tour of the French traveller M. de La Boullaye Le Gouz in Ireland, A.D. 1644, ed. by T. Crofton Croker, with notes, and illustrative extracts, contributed by James Roche, Francis Mahony, Thomas Wright, and the editor. (London 1837). Available online at CELT. [=A translation of portions of "Les voyages et observations du sieur de la Boullaye Le Gouz ..." (Paris 1653).]
5. Sir Robert Kane, The Industrial Resources of Ireland (Dublin 1844).
6. R. M. Young, Gold Mines in Ulster, Ulster Journal of Archaeology, Second Series, Vol. 3, No. 1 (Oct., 1896), 61.
7. C. Litton Falkiner, Illustrations of Irish history and topography, mainly of the seventeenth century (London, 1904).
8. Ireland under the Commonwealth: being a selection of documents relating to the government of Ireland from 1651–1659, edited by Robert Dunlop. 2 volumes. (Manchester: Manchester University Press. 1913) Volume 1.
9. Geoffrey Taylor, Some Irish Naturalists as Men of Letters, The Irish Monthly 77, 917 (November 1949) 513–518.
10. My Irish Diary, 1669–1670 by William Penn. Edited by Isabel Grubb with an Introduction by Henry J. Cadbury (London: Longmans, Green and Company, 1952).
11. Eville Gorham, Some Early Ideas Concerning the Nature, Origin and Development of Peat Lands, Journal of Ecology
41:2 (August 1953) 257–274.
12. Desmond Clarke, An Outline of the History of Science in Ireland, Studies: An Irish Quarterly Review, 62, no. 247/248 (Autumn/Winter 1973) 287–302.
13. T. C. Barnard, The Hartlib Circle and the Origins of the Dublin Philosophical Society, Irish Historical Studies 19, No. 73 (March 1974) 56–71.
14. Jane H. Ohlmeyer (ed.), Ireland from independence to occupation 1641–1660 (Cambridge: Cambridge University Press 1995).
15. Jane H. Ohlmeyer 'The civil wars in Ireland'. In: John Philipps Kenyon; Jane H. Ohlmeyer (eds.), The civil wars: a military history of England, Scotland, and Ireland 1638–1660 (Oxford: Oxford University Press 1998) 73–102.
16. Micheál Ó Siochrú, Confederate Ireland 1642–1649: a constitutional and political analysis. (Dublin: Four Courts Press 1998).
17. Jane H. Ohlmeyer (ed.). Political thought in seventeenth-century Ireland: kingdom or colony. Cambridge: Cambridge University Press in association with the Folger Institute, Washington, DC, 2000.
18. Pádraig Lenihan, Confederate Catholics at War 1641–49 (Cork: Cork University Press, 2001).
19. Stanley G. Mendyk, Gerard Boate and 'Irelands Naturall History'. Journal of the Royal Society of Antiquaries of Ireland, 115 (1985).
20. James Raven, The business of books: booksellers and the English book trade, 1450–1850, (New Haven (CT) & London: Yale University Press 2007).
**The edition used in the digital edition**2. Gerard Boate's Natural History of Ireland, edited with an introduction, by Thomas E. Jordan. Gerard Boate Reprint of the Dublin 1725 edition, with Introduction and Index [xi + 108 pages (Index on pp. 103-108)] Edwin Mellen Press Lewiston, New York (2006 )

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The present text covers pp 1–102 of the volume.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


Non-standard spellings of personal names and place names are left to stand. The punctuation has been edited silently, and the raised dot replaced by comma or semicolon. Where section numbering is erroneous, this has been corrected silently. Encoding is subject to revision.


##### Quotation


There is no direct speech.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the history; div1=the chapter; div2=the section. paragraphs are marked; page-breaks are marked pb n="".


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Place-names, group and personal names are not tagged. Words, terms, and phrases from other languages are tagged.


#### Canonical References


This text uses the DIV1 element to represent the chapter. ### Profile Description


Created: By Gerard Boate
 (1652) #### Use of language


##### Language: [EN] The text is in English.


##### Language: [LA] A few words are in Latin.


##### Language: [GA] A few terms are in Irish.


##### Language: [NL] A few terms are in Dutch.


##### Language: [FR] A few terms are in French.


### Revision History


* (2015-05-05) Beatrix Färber (ed.)

* Header completed, file proofed (2); file re-parsed; SGML and HTML files created.
* (2015-04-30) Beatrix Färber (ed.)

* File parsed; SGML and HTML files created.
* (2015-04-28) Beatrix Färber (ed.)

* Header created.
* (2015-04) Beatrix Färber

* File proofed (1); basic structural and content markup applied.
* (2015-04) Beatrix Färber (data capture)

* Text captured by scanning.




---


#### Corpus of Electronic Texts Edition: E650002-001


### The Natural History of Ireland: Author: Gerard Boate


Of the situation, shape and greatness of Ireland. It's Division into Provinces and Counties: of the English Pale: The principal Towns of that Nation. Being a true and ample Description of its Situation, Greatness, Shape, and Nature. Of its Hills, Woods, Heaths, Bogs. Of its fruitful Parts and profitable Grounds, with the several ways of Manuring and Improving the same. With its Heads or Promontories, Harbours, Roads and Bays. Of its Springs and Fountains, Brooks, Rivers, Loughs. Of its Metals, Minerals, Freestone, Marble, Sea-coal, Turf, and other Things that are taken out of the Ground. And lastly, of the Nature and Temperature of its Air and Season, and what Diseases it is free from, or subject unto. Conducing to the Advancement of Navigation, Husbandry, and other profitable Arts and Professions.
  
Written by GERARD BOATE, late Doctor of Physick to the State in Ireland.




---

p.1


### Situation of Ireland.


Ireland, by the Irish themselves called Erin, and by their neighbours the Welsh, Yverdon, lieth in the north-west ocean, having on the west side no land nearer than America, or the West Indies, and thereof that part, which above Nova Francia and Canada running northward, hath of the English received the name of New Britain, but of other nations before of Terra Laboratoris. The next land over against it on the south is Galicia, one of the kingdoms of Spain, from which it lieth divided some days sailing. Northwards it hath the Scotish islands, by the geographers called Hebrides or Hebudes; the 


---

p.2



principal of which are Eust, Lewis, Skye, Ila and Mula. On the east side is Great-Britain, and all the three parts of it, to wit part of Scotland, the whole west coast of England, and all Wales.


### Distance betwixt Ireland and several places upon the coast of Great-Britain


The Sea, which parteth Ireland from Great-Britain, being of a very unequal breadth, is more narrow in the north end, less in the south end, but broad in the midst, as it washeth the English coast, being the full length of the two counties of Cumberland and Lancashire, opposite against which are situated in Ireland the counties of Down, Louth, and Dublin. The sea which is inclosed betwixt these counties, and compriseth in its middle the isle of Man, is well near of an equal and uniform breadth every where, not being in any place much broader or much narrower, than it is betwixt the havens of Dublin and Leverpole, the distance betwixt which two is reckoned by the English pilots to be of forty leagues, or sixscore English miles. But Wales in two or three places cometh a great deal nearer to Ireland, and in some as near again. For Holy-head, being the most westerly corner of the northerliest part of Wales, called Anglesey, lieth just half way between Dublin and Leverpole or Chester, being twenty leagues, or threescore miles, from Dublin, and ten or twelve hours sail with a reasonable good wind, which distance is no greater, than what the eye may very well reach, for a man whose sight is but of an ordinary goodness, may at any time in clear weather with ease discern the high and mountainous coast of Wales from the top of the Dublin mountains. And about the same distance, as is betwixt Dublin and Holy-head, is also betwixt St. Davis-head a promontory of Pembrookshire (which shire is situated in the most south west part of Wales) and the Irish promontory in the county of Wexford, which the natives call Cancarne, and the English seamen Tuskard-point. Also the promontory of Carnarvan in Wales, called Brachipult-point, and lying betwixt Holy-head and St. Davis, is well near at the same distance from the next Irish shore, as either of those other Welsh promontories. But between Brachipult-point and St. Davis-head the sea doth much enlarge it self (although nothing so much as betwixt Ireland and England) making a great inlet on the coast of Wales, the which here retireth it self a great way backwards whereas to the contrary the Irish shore, which lieth opposite to it, extendeth it self in an equal manner, without any great bays or inlets.


As for the north part, where Ireland and Scotland are neighbours, there this sea groweth very narrow, insomuch as Galloway, a county in that part of Scotland, is distant with its most westerly shore from the Ardes (a little country and demy-island so named in the most northerly part of the county of Down in Ireland) not above five leagues; which space the open boats, wherein they ordinarily here do pass from the one kingdom into the other, use to sail in three or four hours time and Cantyre, another foreland on the west shore of Scotland, 


---

p.3



more to the north than Galloway, is nearer yet unto Ireland so that in these two places the one nation may perfectly be seen and discerned out of the other at all times, whensoever it is no very dark gloomy weather.


### Shape and Bigness of Ireland.


The shape of this island is longways square, but not fully for to say nothing of several corners and forelands, which run out a great way into the sea, nor of divers great bays and inlets, which the sea maketh here and there, in the three other parts of this island, the fourth part, called Munster, doth greatly alter that figure; for in lieu of stretching it self first from the north to the south, and then from the south to the west, it runneth altogether sloping from the north east to the south west; and there besides it stretchest it self much further into the sea with its western shores, than any other part of Ireland on the same west side.


As for the bigness thereof, questionless it is to be reckon'd among the chief islands of the whole world, and of Europe the principallest of all, except only Great-Britain, the which is more than twice as big for being as long again, as it is broad, it is at the narrowest (which is just in the middle, where Dublin is situated) no less than an hundred miles broad, seeing that Athlone, which lieth just half way betwixt the two seas, is fifty miles distant from Dublin; and in Ulster, where Ireland is at its broadest, it is in most places ten, or twelve, and in some twenty miles broader. In the length, if from the middle of the northern coast one do go directly southward, one shall find it to be about two hundred miles. But if you shape your course more to the east, the length will be found less by some miles, because the coast of Munster runneth so sloping, as we have said before and to the contrary, if one measure the length of Ireland more to the west, it will be found to be a great deal more than two hundred miles. And if the measure were taken not through the inland parts, as now we have framed it, but all along the sea shore, the length would amount to a great deal more than what now we have declared (as well on the east as on the west side) in regard of the inequality of the coast, and of the great bays and forelands, which make it in most places very much run out to the seaward, or into the landward for which same reason the circuit of the whole island, taken alongst the shore, is by far greater, than otherwise the proportion of its length and breadth would seem to require. The miles here mentioned must be understood not of the common English ones, three whereof make one league, or Holland mile, but of the Irish, the which are about one fifth part bigger, so as five Irish miles do amount to about six English.




---

p.4


### Division of Ireland into Provinces and Counties.


THIS island is divided into four principal parts, called provinces, viz. Ulster, Leinster, Connaught, and Munster, of which the first and the last extend themselves from the one sea to the other, Ulster in the north, and Munster in the south. Leinster and Connaught, lying betwixt those two forenamed provinces, have the sea only on one side, Connaught on the west, and Leinster on the east. To these four most writers and records add a fifth, called Meath, but that is really a part of Leinster, and ordinarily now is held to be such. Each of these provinces is again divided into divers counties. Ulster hath eleven, whereof six on the sea side, viz. Fermanagh Donegall alias Tirconnel, Colrain, Antrim, Down, Louth; and five within the land, viz. Cavan, Monaghan, Ardmagh, Nether-Tyrone, and Upper-Tyrone. Leinster comprehendeth likewise eleven counties, Dublin, Wicklow, and Wexford on the sea side, East-Meath, and Catherlogh or Carlo within the land, but with a little nook reaching unto the sea, West-Meath, Kildare, Kilkenny, King's-county, Queen's-county, and Longford altogether within the land. Munster is divided into six counties, two within the land, viz. Tipperary and Limerick, and the other four, Waterford, Cork, Desmond, and Kerry, situated on the sea side, but stretching themselves a great way into the land. In Connaught there be six counties, viz. Clare alias Tomond, Galloway, Mayo, and Slego, situated on the sea, and Roscommon, and Letrim within the land.


### Of the ENGLISH Pale.


THERE is yet another division of Ireland, whereby the whole land is divided into two parts, The English Pale, and the land of the mere Irish. The English Pale comprehendeth only four counties, one whereof is in Ulster, viz. Louth, and the other three in Leinster, to wit Meath, Dublin, and Kildare, the original of which division is this. The English at the first conquest, under the reign of Henry II. having within a little time conquered great part of Ireland, did afterwards, in the space of not very many years, make themselves masters of almost all the rest, having expelled the natives (called the wild Irish, because that in all manner of wildness they may be compared with the most barbarous nations of the earth), into the desart woods and mountains. But afterwards being fallen at odds among themselves, and making several great wars the one upon the other, the Irish thereby got the opportunity to recover now this,


---

p.5



and then that part of Ireland, whereby, and through the degenerating of a great many from time to time, who joining themselves with the Irish, took upon them their wild fashions and their language, the English in length of time came to be much weakened, that at last nothing remained to them of the whole kingdom, worth the speaking of, but the great cities, and the forenamed four counties; to whom the name of Pale was given, because that the authority and government of the kings of England, and the English colonies or plantations, which before had been spread over the whole land, now were reduced to so small a compass, and as it were impaled within the same. And although since the beginning of this present age, and since king James's coming to the crown of England, the whole island was reduced under the obedience and government of the English laws, and replenished with English and Scotish colonies; nevertheless the name of English Pale, which in the old signification was now out of season, remained in use, and is still, even since this last bloody rebellion, wherein the inhabitants of almost all the Pale, although all of them of English descent, have conspired with the native Irish, for to shake off the government of the crown of England, and utterly to extinguish the reformed Religion, with all the professors thereof, and quite to root them out of Ireland.


### Cities and chief towns of Ireland.


THIS island hath in it several cities, among which Dublin is the principal, being the chief city of the whole commonwealth, the residence of the governor, the council of state, all the great officers, the exchequer, judges, and courts of justice; being also adorn'd with an university, the only in all Ireland. It is situated in the province of Leinster, about the middle of the length of Ireland (as already hath been mentioned) not far from the Sea, an inlet whereof maketh a harbour for this city, which harbour, although none of the best of Ireland (whereof in the next chapter but one shall be spoken more at large) is nevertheless frequented with more ships, and hath greater importation of all things, than any other haven in the kingdom, by reason that all sorts of commodities are much more readily and in greater plenty vented here than any where else, what in the city it self, being great and populous, what into the country, for in the time of peace almost all Leinster and Ulster were wont to furnish themselves from Dublin of all kinds of provisions and necessaries, such as were brought in out of foreign countries.


Next to Dublin is Galloway, the head city of the province of Connaught to be reckon'd, as well for bigness and fairness, as for riches; for the streets are wide, and handsomely ordered, the houses for the most part built of free-stone; and the inhabitants much addicted to traffick, do greatly trade into other countries, especially into Spain, from whence they used to fetch great store of wines and other wares every year.


In the third place cometh Waterford, situated in the province of Munster; and in the fourth Limerick, the head city of the said province, both towns


---

p.6



of traffick, situated on goodly havens, and of reasonable bigness and handsomness.


Cork, in the province of Munster, and Londonderry, in the province of Ulster, are less than any of the forementioned, but otherwise handsome places, well built, and very fitly situated for traffick and navigation, as standing upon very good havens.


As for the rest of the towns, Drogheda, Kilkenny, and Bandonbridge are passable and worthy of some regard, both for bigness and handsomness: but Colrain, Knockfergus, Belfast, Dundalk, Wexford, Youghal, and Kinsale are of small moment, the best of all these being hardly comparable to any of those fair market towns, which are to be found in almost all parts of England. And as for Cassel, Rosse, Lismore, Clonmell, and Kilmallock in Munster; Slego and Athlone in Connaught, Mullingar, Trim, Kells, Navan, Athboy, Naas, Carlow, Arklow, and Wicklow in Leinster; Carlingford, Atherdee, and Down in Ulster, all of them walled towns, they are scarce worth the mentioning, because there are few market towns in England, even of the meanest, which are not as good or better, than the best of them all. We could give a more perfect relation of this particular, but because this serveth little to our purpose, and properly doth not concern the natural history, we have thought it best to touch it but briefly.


### Waterford Haven.


THE havens of Ireland are so many in number, and for the most part so fair and large, that in this particular hardly any land in the whole world may be compared with this, as will easily appear by the particular rehearsal thereof, which we are now to make, first of the best and chiefest in this chapter, and of the others in the next. We shall begin with Waterford haven, the which being situated on the confines of Leinster and Munster, runneth some seven or eight miles into the land, not winding or crooked, nor with any great nookes or inlets, but almost in a straight line, (extending in it self north and north by west) and in most parts of an equal breadth, all the way deep and clear, having no rocks or sands, but only two or three little ones, which lying not across nor in the midst, but by the sides, may be shunned very easily. Without the harbour it is eleven and twelve fathoms deep, in the mouth 


---

p.7



seven and more, inwards six fathoms. Within the easterly corner is a good road, in four or five fathoms; and on the other or westerly side, five or six miles from the mouth, is another good road, very commodious as well for them who go forth, as those that will sail upward to Waterford. Upon the east side, about half way the length, lieth a very strong castle called Duncannon, which so commandeth this harbour, as no ships can go up or down against the will of those in the fort without running extreme hazard.


This haven in the end divideth it self into two arms, both a great deal inferior to the principal harbour in breadth and depth, but yet such as are capable of ships of good big port, especially the left, which runneth westward to the city of Waterford, whereof this whole haven beareth the name, being situated some four or five miles from that division, and a little below the place where the river Shure falleth into this harbour. The right arm being the mouth or the river Barrow, and extending it self straight along, goeth up to Ross, (a town in former times famous for trade) the which is much about the same distance from this division, as the division is from the mouth of the harbour.


### Carlingford Haven.


ON the whole coast of Leinster there is not one fair large harbour, so as the next good haven from Waterford northwards is that of Carlingford, which two harbours, in sailing straight along the coast, are above an hundred miles distant.


This haven is some three or four miles long, and nigh of the same breadth, being every where very deep, so as the biggest ships may come there to an anchor, and so inviron'd with high land and mountains on all sides, that the ships do lye defended off all winds; so that this would be one of the best havens of the world, if it were not for the difficulty and danger of the entrance, the mouth being full of rocks, both blind ones and others, betwixt which the passages are very narrow, whereby it cometh that this harbour is very little frequented by any great ships, the rather because there is no traffick at all, nor any good town seated on this haven. For the town of Carlingford, whose name it beareth, is a very poor place, hardly worth the speaking of. About eight miles from the mouth of the harbour is the Newry, a fine little town, until in this late bloody rebellion it was for the greatest part destroyed by the Irish, by which town passeth a little river, called the Newry-water, which discharging it self into the harbour some four or five miles below the Newry, is not portable but of very little barks and boats, and that only when the tide is in.




---

p.8


### Strangford Haven, and that of Knockfergus.


ABOUT thirty miles northwards from Carlingford haven is the haven of Strangford, the which in its entrance is almost as much incumbred with rocks or both kinds, as that of Carlingford. It is some five or six miles long, and beareth north westward, being the mouth of a great lough, called Lough Cone; the which being but two or three miles broad in most places, but some fifteen or sixteen long, doth ebb and flow until the utmost ends of it: so that there goeth a very strong tide in this harbour, which makes the same the unsafer, especially in great storms and high winds, for which there is no great defence here. On this haven, and on the neighbouring lough, there lyeth never a good town, Strangford being more inconsiderable yet than Carlingford.


The next great harbour upon this coast, and about twenty miles more to the North, is that of Knockfergus, being a great wide bay, the which in its mouth, betwixt the southern and the northern point, is no less than ten or twelve miles broad, growing narrower by degrees, the farther it goeth into the land, the which it doth for the space of fifteen miles, as far as to the town of Belfast, where a little river called Lagon (not portable but of small boats) falleth into this harbour. In this bay is a reasonable good road before the town of Knockfergus (seated about nine miles within the land) where it is good anchoring in three fathoms, and three and a half. On the north side of the bay, somewhat near the sea, under a castle called Mouse-hill, is a sand bay, where it is good anchoring for all sorts of ships, as well great as small ones, for the north and north west winds: but bad riding for the south west.


### Sheep Haven, Lough Swilly, and Lough Foyle.


THE three forementioned havens of Carlingford, Strangford, Knockfergus, are all in the province of Ulster, on the east side thereof. The said province hath also three good havens on its northern coast, not very far distant the one from the other. viz. Sheep haven, Lough Swilly, and Lough Foyle. Every one of these is a Lough (which the very name of the second and third sufficiently testifieth) opening it self into the sea, of the which Sheep haven and Lough Swilly altho' they be fair large harbours, as well as Lough Foyle, and that ships may ride there defended off all winds, Lough Swilly being also of sufficient bigness to contain a thousand great vessels, yet they are very little frequented, because there is not any trade nor traffick, nor any good town placed upon or near them.




---

p.9


Lough Foyle is of a great bigness, at least twelve miles long, and in most places five or six miles broad, being almost every where of an equal breadth, except at the two ends, where it groweth narrow, being of an oval figure. For at the mouth, betwixt Magilligan's point and Greencastle, it is hardly a mile and a half broad and at the other end it is much narrower yet, running from thence with a long arm some miles into the country, being liker to a broad river, than to a lough. Upon this arm, three or four miles from the great lough, is the town of Londonderry, in place where that arm turneth and windeth it self in that manner, as it invironeth the town on three sides. It is nothing big, consisting only of two long streets, the which cut one another cross-ways in the midst; but it is very handsome, the streets being broad and well paved, the houses some stories high, and built for the most of freestone, with a handsome church, market place, and key and is inclosed with a thick and very strong wall, being one of the principal fortresses of Ireland. It is but few years old, having been built up from the ground by a company of London adventurers under the reign of king James. Before the mouth of this lough lieth a great sand, called the Touns (upon which it burneth greatly, when the wind bloweth from the sea) but so as a fair broad and deep channel remaineth betwixt the said sand and the west side of the land, where there is at all times fourteen and fifteen fathoms of water, as in the mouth it self some eight or ten. Entring into the lough, there are very great sands on the left hand, from the one end to the other, which are some miles broad from off the land, and of the right hand are some little sands or shelves here, lying close to the land. Betwixt these runneth a broad channel in most parts three and four fathoms deep and in that arm, whereon Londonderry standeth, it is deeper yet, in some places no less than ten or twelve, and before the town four and five fathoms: so as this is one of the best and most commodious harbours of all the land


### Kilbeg and Dunnagall Haven.


THE country of Tirconnel, the which taketh up the whole west side of the province of Ulster, runneth a great way into the sea with its southern part, on the south side of which foreland there are two very fair havens, the one not far from the other, vix. Kilbeg and Dunnagall haven. Kilbeg is a fair round bay, where the greatest ships that go upon the seas, may at all times with their full lading enter and come to an anchor, being distant about twelve miles from Cape de Telling, the outmost or most western point of that forenamed foreland of Tirconnel. The entrance is very narrow, so as unto them who are coming to it, there seemeth to be no opening there, until they are very near, but it is very clean, as well in the mouth, as in the bay it self, and nothing that can hurt the ships either coming in or going forth, being entred, one may anchor where one will, in five, six, seven, eight fathoms, or more.




---

p.10


Three or four miles to the south from Kilbeg is a cape, call'd St. John's point, and six or seven miles eastward from the said cape is Dunnagall haven, wide and deep enough, but in the entrance greatly incumbred with shelves, sands, and rocks, so as great care and circumspection is requisite, to enter or go forth safely. These two havens have their names of villages seated on them, which are very small and no ways considerable.


### Broad-haven, Achill Haven, and Galloway Haven.


THE province of Connaught, extending herself betwixt Ulster and Munster, taketh up the greatest part of the west side of Ireland, it hath also some good ports, as namely Broad-haven, another to the north of Achill head; and a third, situated between the main, and the north and east side of Achill island, in which one may ride in seven and eight fathoms, and be defended off all winds; although it be rather a sound, than an inclosed harbour for the ships which are come into it, need not go forth the same way again, but sailing on betwixt the main and the island, may at the south end of the isle come again to the open sea. These havens are nothing famous, being very seldom resorted unto by any great ships, except such as by tempests and foul weather, or some other accident, are necessitated to shelter themselves in the same.


But the famousest port of this province is that of Galloway, being a very great bay, some miles broad, and many more long, having in the mouth three islands, named the isles of Aran the which lye north and south by the side one of the other, there remaining three channels for to come out of the sea into this bay. One channel runneth betwixt the land and the northern island, called therefore north sound; the second between the same northern island and the middlemost, which channel, being the most usual of the three, is commonly stiled St. Gregory's sound and the third between the southernmost island and the main, named south sound, the channel betwixt the southern and the middlemost island not being passable by reason of the sands and shelves, wherefore the name of false sound hath been given to it.


The whole north side of this bay is very foul with sands and rocks, so as one may not approach the shore in a great way at the end of which sand, and in the innermost part of the bay, lieth a little island, called in English, Mutton-island, and by the Irish, Enis Kerrigh, which hath the same signification; at the east side whereof one may anchor in five or fix fathoms of water; but from thence northwards until the city of Galloway, which is the space of two or three miles, none but little vessels and barks can go, the city standing not on the bay it self, but on a broad water like a river, the which not far above Galloway coming out of a great lake, called Lough Corbes, dischargeth it self into the bay a little above Mutton isle.




---

p.11


### The Havens of Limerick, Smirwick, Dingle-bay, Ventry, and Dingle-Icoush.


THE next great haven on the west side of Ireland, to the south of Galloway, is that of Limerick, which haven divideth the province of Connaught from Munster, being of a huge length, no less than fifty miles: for so far it is from the mouth of the haven until the city of Limerick, to whose walls great vessels may go up, without meeting with any thing else in all that way, save a many little isles, but not any foul places, rocks, or sands. This harbour is nothing else but a great lough (half way its length growing somewhat narrow, but immediately inlarging it self again into a great breadth) whereinto the river Shannon, (upon whose bank Limerick is situated) dischargeth it self a little way below the said city, although the English and the Irish both call it the Shannon all the way until the sea, as it were not a lough into which the river falleth, but the river it self thus inlarged.


Coming out of this harbour, the land on the left hand shooteth a huge way westwards into the sea, on the side of which foreland, ten or twelve miles at this side of the uttermost point (betwixt which and the isle of Blasques passeth the sound of the same name) is the haven of Smirwick, not very great, deep, but clean, and well inclosed.


At the other side of this foreland, and to the northeast from the Blasques, is a fair and very large bay called Dingle-bay, the which goeth very many miles into the land, having in it divers good havens, one whereof, called Ventry, is four or five miles from the found of Blasques eastwards, and three or four miles further is Dingle-Icoush, before the mouth of which harbour, and at the west side of it, lieth a rock, called the Crow, round about which one may sail without danger, it being always above water, but at spring tides, at which time the sea doth overflow it.


### Maire, Bantry, and Beer-haven.


AGAINST the southeast corner of Dingle-bay lieth a great island, called Valentia, betwixt which and the main is a very fair and safe road. And a little way beyond that island goeth in another huge bay, called Maire, which mooteth into the land a great deal farther than Dingle-bay and somewhat farther is a third bay, called Bantry, which equalleth Maire both in breadth and length in both which, as well as in Dingle-bay, there be several good harbours and roads.




---

p.12


Maire hath in the mouth some fifty or five and forty fathoms of water; entring in further, there be six and twenty, twenty, and eighteen, afterwards you come to ten, and to six, and in the innermost parts to three and two fathoms; being throughout very clean, and free from all kind of rocks and sands, except in very few places.


As you enter into Bantry, sideward upon the left hand lieth a reasonable big isle, called the island of Beer haven, betwixt which and the main there goeth in a fair sound, being a great musket shot broad, the which in its whole length, from where it beginneth until the place where it endeth at the further part of the island, being the space of some miles, serveth for a very good and safe port, wherefore also it beareth the name of a haven, being called Beer haven. A good way within the mouth lye some rocks in the midst of the channel, the which at high water are overflown, and you may sail of either side of them and at the other side of this sound, where the same cometh out into the Bantry, there lye two great rocks just in the mouth, betwixt which the ships may pass, as also betwixt the same and the land of either side. All the rest of this harbour or sound is everywhere very clean and clear, and very good anchor ground, ten, twelve, and thirteen fathoms deep.


### Whiddy Haven and Langerf.


IN the innermost of the Bantry lieth an island about three miles long, called Whiddy, betwixt which and the main is a very fair wide bay, (being the uttermost end of the great bay Bantry) where you may everywhere come to an anchor in three, four, five, or six fathoms, in as much or as little water as you will, according as you have a mind to ride near the shore or further from it, being every where clean ground. Ships may enter into this bay or sound in two several places, at both ends of the island. But the entrance at the south end is very dangerous, because that there betwixt the island Whiddy and the main land it is in most places foul and rocky but in the other entrance, at the northern end of the island, is both room and depth enough, it being much broader than that at the south end, and eight and nine fathoms deep, and there is nothing that can do hurt, except only a row of rocks a little musket shot from the shore, the which being covered at high water, do not begin to appear but at half-ebb.


Right against this island, at the other side of Bantry, is a haven called Langerf, in which is every where good anchoring and good ground, only at the one side, on the right hand close to the mouth, lye some foul grounds, the which fall dry at the ebb of a spring tide.


From Beer haven to the northern corner of the island Whiddy, the Bantry tendeth east north east and north east, eighteen or twenty miles in length. Over against Beer haven, in the midst of the fair water, it is deep forty, six and thirty, and thirty fathoms; beyond the island fifteen and sixteen, but further



---

p.13




in, approaching the isle of Whiddy, it is again twenty and five and twenty fathoms deep.


### Downams Bay, Baltimore Bay, and Baltimore Haven.


Next to the Bantry, and only by a narrow neck of land divided from it, is Downams bay, being great and wide (although no ways comparable to any of those three already described) a very commodious road to save ships in, and good anchor ground every where.


The land to the east of this bay shooteth out very far to the seaward, the uttermost point thereof, called Messan-head, being the southernmost cape of all Ireland. For Cape de Clare, being about twenty miles further to the east, and somewhat more southerly, is not on the main, but in an island.


Beyond Messan-head is another bay, far greater than any of those three forenamed, but nothing like the same in shape, nor in the same manner running with a long arm a huge way into the land, but rather approaching to the figure of a half moon. In this bay is Crook haven, School haven, and several other great havens, not only on the main land, but also in some of the islands, whereof there is a great number in this bay. The most easterly of all these islands is Baltimore, the which surpassing all the others in bigness, giveth its name unto the bay.


That part of the bay which lieth betwixt this island and the main, having a narrow entrance, but within of a great largeness, is a marvellous good road, where ships may come to an anchor on either side, and lye defended off all winds. It is five and six fathoms deep on the sides, and six and seven in the midst. In the mouth of the harbour, next to the east side, lieth a blind rock, and in the midst of it another rock, which appeareth at low water. There is nothing else that can do hurt. This haven, being far the principallest of all this bay, hath its name, as well as the bay it self, of the island, being called Baltimore haven. To the north of that island lieth another island, called Spain island, where one may pass betwixt these two islands to the west, and so out of Baltimore haven go into the sea. But only with smaller vessels, because half flood there is not above twelve or thirteen feet of water in all that channel.


### Castle Haven, Rosse Haven, Clandore Haven, with the Havens of Kinsale and Cork.


SOME miles beyond Baltimore bay is Castle haven, where ships may come to an anchor in twelve fathoms of water, being of a reasonable bigness, and very clear and clean, as well in the entrance as within.




---

p.14


Between Castle haven and Kinsale are two other good havens, to wit that of Rosse, and of Clandore, in which there is water enough and very clean ground.


The haven of Kinsale is one of the famousest of all Ireland, ships may sail into it, keeping in the midst of the channel, without any danger either without or in the mouth of the harbour, except a blind rock close to the east point. Within the haven, on the west side, lieth a great shelf, which shooteth a great way off from the land, but leaving a very large passage along by the side of it, in which, as in all the rest of the harbour, it is many fathoms deep. This haven for some miles goeth in N N E, but afterwards turneth westward until the key of Kinsale, where ships may ride in eight or nine fathoms of water, being defended of all winds.


Ten or twelve miles to the east of Kinsale is Cork haven, the which goeth in N NE, being within large and wide, running a great way into the land for the town of Cork, until whose key this haven is very clean and deep, is seated many miles from the sea, and from the mouth of the harbour.


Of the lesser Havens, and the barred Havens of Ireland, also of the Roads and Anchor-places upon the Coast, and in the little Islands near the Coast
----------------------------------------------------------------------------------------------------------------------------------------------------


### Wexford Haven.


AFTER the description of the principal havens of Ireland, we shall come to them of less moment, in which number we put all those, which either in their entrance, or within, have not water enough for the bigger sort of vessels; as likewise those, the which being deep enough, are but very little, and of a small pourprise; and in this description we shall observe the same order as in the former, beginning with Wexford, and so going northward, then west, afterwards southward, and lastly east and north eastward, until we have gone about the whole island.


The haven of Wexford runneth in west and by north, and with her innermost part altogether northward. Just before this haven lye two great shelves of sands by the side one of the other, of which that on the south side is called Haneman's path, and the other north grounds. There goeth a channel betwixt Haneman's path and the land on the south side of the haven, and another betwixt the north side and the north grounds; but this last hath but six


---

p.15



feet of water at full flood, and in the other eight feet with the flood of ordinary tides, and ten at spring tides. The chief channel is that which goeth in betwixt the two sands, being four and five fathoms deep. Besides these sands there is another shelf in the mouth of the harbour it self, which kind of sandy banks lying across in the mouth of harbours and rivers, are usually called Bars; and the havens which have them, barred havens. With a high flood there is about sixteen feet of water. Being past the bar, you have for some way three fathoms of water, three and a half, and four; but afterwards for a great way but ten feet, and ten and a half, with a high flood, although under the castle where the ships come to an anchor, you have four fathoms, and before the town three, but because of the forementioned shallows, no vessels can go to Wexford, that draw more than ten feet of water, but must unlade and lade in a creek near the mouth of the haven on the south side, about three miles from the town, where is water enough, but no shelter for the south west winds, the which do come over the land to this place.


### Dublin Haven.


dublin haven hath a bar in the mouth, upon which at high flood and spring tide there is fifteen and eighteen feet of water, but at the ebbe and nep tide but six. with an ordinary tide you cannot go to the key of dublin with a ship that draws five feet of water, but with a spring tide you may go up with ships that draw seven and eight feet. those that go deeper cannot go nearer dublin than the ringsend, a place three miles distant from the bar, and one from dublin. this haven almost all over falleth dry with the ebbe, as well below ringsend as above it, so as you may go dry foot round about the ships which lye at an anchor there, except in two places, one at the north side, half way betwixt dublin and the bar, and the other at the south side not far from it. in these two little creeks (whereof the one is called the pool of clantarf, and the other poolbeg) it never falleth dry, but the ships which ride at an anchor remain ever afloat, because at low water you have nine or ten feet of water there. This haven, besides its shallowness, hath yet another great incommodity, that the ships have hardly any shelter there for any winds, not only such as come out of the sea, but also those which come off from the land, especially out of the south west, so as with a great south west storm the ships run great hazards to be carried away from their anchors, and driven into the sea; which more than once hath come to pass, and particularly in the beginning of November, An. 1637, when in one night ten or twelve barks had that misfortune befaln them, of the most part whereof never no news hath been heard since.




---

p.16


### The Havens of Drogheda and Dundalk.


 THE haven of Drogheda, or, as the word is pronounced in common use, Tredagh, is very troublesom to be got into, as having not only a bar lying across before its mouth, over the which vessels cannot pass but at high water, but also very narrow in the mouth, this haven not being an arm or bay of the sea, but only a river which keepeth her own bigness until the end, without receiving any notable enlargement of the sea about her mouth, as other rivers use to do. Upon this bar is as much water as upon that of Dublin, and the ships which can pass the bar, may go up to the key of Tredagh, which town is seated about two miles from the mouth of this river, which is called the Boyn.


Sixteen miles to the north of Tredagh standeth Dundalk, where a wide open bay (made by the giving back and retiring of the coast) growing narrow, and receiving a little river, which above Dundalk is but a small brook, maketh a kind of haven, where never is much water, and with the ebb may be passed over a-foot, wherefore, and because there is not any shelter for the winds coming from the sea, nor any usual traffick, this road is very little frequented.


### The Havens of Dundrum, Ardglass, Oldfleet, Belletree, and the Bann.


A FEW miles on this side of Strangford, are the havens of Dundrum and Ardglass, the one not far from the other, both little, and not very deep, but safe, and a little way beyond the northern point of the bay of Knockfergus, is Oldfleet haven, a harbour of the same sort as those two last mentioned.


Port Belletree, six or seven miles to the west of Fair-foreland (the north-easterliest point of Ireland) is as little as any of those three, less defended of the winds, and the ground sharp and foul.


Some miles further is the haven of Colrain, called Bann haven, the which is nothing else but the mouth of the river Bann, the which here falleth into the sea, keeping her own narrowness until the end, in the same manner as we said above of the haven of Tredagh. This river passing through Lough Neagh, the greatest lake of all Ireland (the which receiving several rivers, hath no other outlet into the sea but the Bann) carrieth a mighty deal of water, the which being inclosed in a narrow channel, poureth it self into the sea with great violence for which reason, and because of the narrowness of the mouth, this haven is very hard to enter, having also but little depth, so as vessels which draw eight feet of water, must at least have three quarters of the flood before they can enter.




---

p.17


### Telling Haven, Mackswin's Bay, the Havens of Ballyshannon, Slego, Endrigo, Moy, and Niffadoy.


UPON the west coast of Ulster, about half way between Cape Telling and Kilbeg, is Telling haven, a round bay, with a good sand ground, which will contain about thirty ships: west and southwest winds blow directly into it, but off all other winds one is there defended. Two or three miles eastwards from Kilbeg is Mackswin's bay, where a ship may ride safe without cable and anchor, but the entrance being every where beset with rocks, it is dangerous to go into it. Some miles to the southwest of Dunnagal haven, is Ballyshannon, being the mouth of that short river, by which Lough Earn, one of the greatest Lakes of lreland, dischargeth it self into the sea, which river runneth just on the borders of the two provinces of Ulster and Connaught, dividing the same; this having a bar before it, by reason whereof no bigger vessels than of thirty or forty tunns can enter into it.


Slego and Endrigo are two little harbours, situated near the one to the other, in the north part of Connaught, very much encumbred with rocks and sands in the entrance, but otherwise reasonably deep; for a ship of two hundred tunns may come and ride before the town of Slego.


About half way between the town of Slego and Broad-haven is Moy, being the innermost of a great bay, divided from the rest by a little island somewhat long, the which lieth cross in that manner, that only one channel remaineth, whereby to go out of the great bay into the lesser, or the haven, which channel is twelve foot deep; but in the haven it self, being nothing else but two little creeks, divided asunder by some sands lying betwixt them, it is about fifteen or sixteen foot deep; but in the little channel which passeth into the inmost creek, being nearest to the village Moy, there is but nine foot of water at full flood with an ordinary tide.


Some miles to the southeast of Slime head, (a famous cape in Connaught, and situated about half way the length of that province) is port Niffadoy, a reasonable good harbour, but very dangerous to get into, the sea there round abouts being full of rocks both blind ones and others.


### The Havens of Tralee, Youghal, and Dungarvan: item of Wicklow, Arklow, Malahide, &c.


AT Tralee, half way between Smerwick and the mouth of the haven of Limerick, is a fair haven but none of the biggest.




---

p.18


About the middle way between Cork and Waterford is the haven of Youghall, before the which lieth a bar, not to be passed but at high water.


Twelve miles eastwards from Youghall, is Dungarvan, being a narrow tide-haven, whose mouth is full of rocks, many of which do not appear, and so more dangerous, and at low water it falleth dry, so as one must go into it at high stood, and pass amidst the rocks.


As for the havens of Arklow (where with high water it is but six feet deep), of Wicklow (where at full flood you have but ten feet of water), Malahide, a little to the north of the bay of Dublin, Coledagh haven, and Red haven, the first betwixt Lough Foyle and Lough Swilly, and the other betwixt Lough Swilly and Sheeps haven, Milk haven, not far from Slego; Mablin haven, betwixt Waterford and Wexford, and some others of the same nature: they are so little, that they will hardly serve for other than fisher boats, and therefore scarce merit the name of havens.


### Roads upon the Coast of Ireland, from Waterford to Fair-foreland.


BESIDES this great number of havens in Ireland, there are many good roads, where ships at need may save themselves, and commodiously come to an anchor, not only upon the coast of the main land, but also in the most part of the little islands, which lye round about Ireland.


To begin with those on the main. From the point of Waterford to Carnesore, being the space of about twenty miles, the coast is full of bays, where one may come to an anchor. Under Carnesore ships anchor in six and nine fathoms. In St. Margaret's bay, three miles from Carnesore it is good anchoring in five and six fathoms, sand ground. A little further is the bay of Greenore, where you may anchor as near the land as you will, in six, five, four, or three fathoms.


Some miles from Wexford to the point of Glascarick, from which place to the bay of Dublin, being about fifty miles, the coast is full of inlets, where it is very good anchoring, in good sand ground, especially to the north of Arklow head (in a fair sand hay everywhere in eight, seven, or five fathoms) and between Arklow and Missen head, being the space of six or seven miles.


In the mouth of the bay of Dublin, at this side of the bar, is good anchoring as well on the south side, before the village Dalkee (which place is known by the name of Berton road) as on the north side, round about that great cape, named the head of Hoath.


Between Strangford haven and the bay of Knockfergus are divers good anchoring places, but all that coast is very foul with rocks, and blind rocks. To the north of Knockfergus are divers inlets, where one may come to an anchor, there are some rocks, but they all stand above the water, so as easily they they may be shunned.




---

p.19


### The rest of the Roads upon the Coast of Ireland.


TO THE west of Fair-foreland the coast is flat and clean, so as there ships may anchor every where in eight and nine fathoms. Under the point of Eniston on the west side one may anchor for easterly winds, or to stop the tide.


Between Lough Swilly and Sheep haven is an inlet where ships may come to an anchor; but the ground is somewhat foul.


On the west side of cape Horn ships may ride at anchor for easterly winds: and along the whole coast between cape Horn and the isles of Aran is everywhere good anchor-ground, as also upon the west coast between St. John's point and Dunnagal haven, being the space of five or six miles.


In the sound of Blasques it is good anchoring on the south side of the point for northern and western, and on the north side for the contrary winds.


On both sides of the old head of Kinsale, by the Dutch mariners called cape Velho, ships may anchor as deep or shallow as they will.


There is also a good inlet for to anchor in a few miles beyond the haven of Cork, and on the east side of Ardimore head is a bay, where it is good riding for westerly winds in seven or eight fathoms.


There is also a good anchoring place or two betwixt Dungarvan and the haven of Waterford.


### Roads in the Islands of Saltees, Dalkee, Ireland's Eye, and Lambay.


AS FOR the roads in the islands; about halfway betwixt Waterford haven and Carnesore lie two little islands, a mile or two from the land, call'd Saltees: the southmost whereof, which lieth furthest from the land, is much bigger than the other, ships may pass between these two islands in five, six, and seven fathoms. On the east side of the lesser island is a good road to come to an anchor in seven or eight fathoms, where ships may ride in safety for south west, west, and north west winds and on the north west side of the bigger island ships may anchor in seven, eight, or nine fathoms, the road being defended off south south east, and east south east winds. Close by the south point of Dublin bay lieth a small island, called Dalkee, betwixt which and the main land passeth a sound seven, eight, and nine fathoms deep, in which you may anchor under the island. On the north side of the head of Hoath lyeth another small island, scarce half a mile in compass (wherein, as also in Dalkee, no body inhabiteth, both serving only for to feed cattle) having a decayed chappel on the west side, over against which ships may come to an anchor.




---

p.20


Three or four miles beyond Ireland's Eye lieth the isle of Lambay, belonging to sir William Usher of Dublin, who hath there a fine little castle of freestone, and close by it a village, wherein dwell divers families, of fishers and husbandmen, who plow part of this island, and upon the rest feed cattle and sheep. The whole island, being about three miles in compass, is high land, wherefore it may be seen a great way off. On the north side of this island ships may anchor in twelve and thirteen fathoms for a southerly wind. For a sea-wind the ships must ride on the west side, over against the castle: but that road is not very good, because always in that sound, being about three miles broad, goeth a great sea.


### Roads in the rest of the little Islands about Ireland.


 RIGHT against the promontory of Fair-foreland lieth the island Raghlin, where ships may sail round about, as well at the outside, as betwixt it and the land, according as the wind and tide serve. On the south west side is a fair bay with very fine sand ground, where ships may ride defended off all winds. A little way on this side and to the east of Bann haven lieth Skires Portrush, a rocky island, the which on the south side hath a fair bay, very good sand ground, where ships may anchor in six or seven fathoms, being sheltred off all winds, except the east north east wind, the which along the coast doth directly blow upon it.


There is a good road on the south east side of the isle of Aran, situated on the north west side of lreland and betwixt this island and the main there lye three or four small isles, where ships may anchor in divers places, and be secured off all winds.


There is also a good road for some winds under Eneskie island, the middlemost of the three islands situated betwixt Achill head and Slime head, called Boche, where is good anchoring in four fathoms; under the northernmost island of those three lying in the mouth of the bay of Galloway, under Ennis Morrow, one of the Blasques; under Dorses island, lying betwixt the bays of Maire and Bantry, in the sound which passeth betwixt the same isle and the main land.


Ten or twelve miles to the east of Cork haven lieth an island called Ballycotton, where ships may anchor in five or fix fathoms for westerly and southerly winds. There is also a good road on the east side of Capel island, a little isle, lying three or four miles from the mouth of the haven of Youghall.




---

p.21


Quality and Fashion of the Irish Coast or Shores, Item, A brief Description of the principal Promontories or Heads of Ireland.
------------------------------------------------------------------------------------------------------------------------------


### Of the low and strandy Shores of Ireland.


THE Irish coast is not every where alike; but of several sorts: in some places the land along the sea is low and flat, having a broad sandy strand, with a row of sandy hills, the which doth part the land from the strand, in the same manner as it is upon all the coast of Holland and Flanders (where these kind of hills are called Duynen or Downs) only with this difference, that they are not so large nor high, as in the Low Countries, and that the rows of them take up but a little space in breadth. This kind of strand is in most parts of Fingall (being a portion of the county of Dublin northwards towards Tredagh, and a good way beyond that, and elsewhere.) In other places lye no downs or sandy hills, nor any other heights, betwixt the strand and the land, it being only defended from the overflowing of the sea by an unsensible rising.


### Of the high and hilly Shores of Ireland.


IN other places the land is high and hilly on the sea side; part whereof doth descend by degrees towards the sea, having a strand below, but elsewhere the land is high and steep, being washed underneath by the deep sea, so as ships of great burthen may sail close by it, the which may be observed not only in the heads or capes, the most part whereof are thus fashioned, but in many other places, and in great extents of the coasts. For as concerning the saying of Giraldus, that Ireland every where upon the coast is very low, Est per omnia sui latera marinaque littora terra valde demissa, that is evidently repugnant to the truth. Some of these high shores are bare naked rocks, covered with very little or no earth, so as scarce any thing groweth upon them but dry grass and heath, others are stony within, but have at the top a reasonable deep mould, and all over cloathed with good grass, some of them being so exceeding steep towards the sea side, that it is impossible for man or beast



---

p.22




being come to the further end, to go one step further, without falling down and being lost. So as it hath happened, that cattle and sheep feeding in those places, when they were come to the top, and following the grass, suddenly tumbled down, falling headlong into the sea, or upon the hard sharp rocks standing at the bottom.


### Capes on the east side of Ireland.


THE heads or capes of Ireland are in great number, and many of them very observable, to the great commodity of the sea-faring men. In the south easterliest point of Ireland is the cape of Greenore, five or six miles to the south of the bay of Wexford, being not very high, but steep, and flat at the top and three or four miles to the south west from it is the point of Carnesore.


Betwixt Wexford and Dublin there be five heads: that of Glascarick, which the Dutch mariners call the Blew point, and the Steep point, twelve miles to the north of the bay of Wexford, being of no great height. That of Glaskermen or Arklow being well near at the same distance from the head of Glascarick, as that is from the bar of Wexford. Missen head, some nine or ten miles further to the north. The head of Wicklow, six miles beyond Missen head, being steep and rocky, divided at the top into two little hillocks. And the fifth and last of all, that of Bray, about fifteen miles beyond Wicklow, and five or six miles to the south of the bay of Dublin, being a great and high cape, shooting a good way into the sea, and so steep, that it is ten fathoms deep there close under the land.


On the north side of Dublin bay is the head of Hoath, a great high mountain, three or four miles compass in the bottom; having the sea on all sides, except the west side, where with a long narrow neck it is joined to the land, which neck being low ground, one may from either side see the sea over it, so that afar off it seemeth as is it were an island. This head may be seen a great way off at sea, for even upon the land one may very perfectly see it, not only upon the key of Dublin which is six miles from thence, but nine or ten miles further westward.


Upon all the coast from the head of Hoath to Dundrum, being about the space of 60 miles, is none considerable. But some miles beyond Dundrum, and three or four miles at this side the haven of Ardglass, is St. John's point, a head and foreland which shooteth a good way into the sea.


The next head beyond St. John's, is the point at the north side of the haven of Strangford, which the Dutch mariners by a notable mistake call the point of Ardglass.


All these capes lye on the east side of Ireland, whose utmost point northward is the promontory of Fair-foreland.




---

p.23


### Capes on the north side of Ireland.


ABOUT fifty miles to the west of Fair-foreland, and well near the middle of the north coast, is the head of Eniston, which with the land next adjoyning lieth much more northward, and runneth further out into the sea than any other land upon this coast, being of a great height, so as it may easily be known by any that once have seen it.


Some forty miles more westward beyond this promontory lieth the cape which is known by the name of Horn head, being a hill with two hommocks at the top, in fashion somewhat like unto two horns, from whence it hath received its denomination.


### Capes on the west side of Ireland.


Upon the west side of the Irish coast are four principal heads, viz. Telling head, lying about thirty miles to the south west of the Isles of Aran, the which are situated over against the north westerliest point of Ireland. Achil head, some miles to the south of Broad-haven, being not on the main, but in an island. Slime head, which by the seafaring men is called Twelve-pence, because the land sheweth it self in twelve round hommocks, being situated well near in the middle of the west coast, and Lupis head, which is the northern point of the haven of Limerick.


As for the other heads upon the same west side, namely those three betwixt the haven of Slego and Broad-haven, by the Irish pilots called Can Moyn, Can Killala, and Can Jores, (Can in Irish betokeneth a head in all sorts of significations) Renilira and Clegin, between Achil head, and Slime head (which last the Irish call Can Leme) Brain and Calew, situated to the south of the bay of Galloway; and Can Sanan, being the south point of the bay of Limerick, those are less considerable.


### Heads on the southern coasts of Ireland.


UPON the south west side of Ireland, the principal heads are cape Dorses (situated in an island of the same name, betwixt the two great bays of Maire and Bantry) and Missen head, situated betwixt the bays of Bantry and Baltimore, being the same, in Camden's opinion, which Ptolomy calleth Notium, that is southern, it being the most southerly point of all Ireland.




---

p.24


Upon the south east side is the head of Clare, standing in an island on the east side of the bay of Baltimore; and a great way from thence, the old head of Kinsale, called cape Velho by the Dutch mariners; which head, to those that come sailing along the land afar off, seemeth to be an island, being a point which shooteth a great way into the sea, whose utmost, or most southerly end is very high and steep.


Upon the same side standeth the head of Ardmore, which runneth a great way into the sea from the land on both sides, and because of its height may be seen many miles off.


Of the Sands or Grounds, blind Rocks, and other Rocks in the Irish Sea.
-----------------------------------------------------------------------


### Of the Grounds before the Coast betwixt Dublin and Wexford.


THE sea which invironeth Ireland, is as free from shelves, sands, or grounds, as any in all the world, not alone upon the other sides, where the same is wide and open, far distant from all other lands, but upon the east side where the same is inclosed betwixt Ireland and Great Britain, in which whole space it hath not any other sands than those situated along the coast between Dublin and Wexford. These indeed are of a huge extent, but not turning and winding as most part of the grounds in other places, but in a straight line, NNE, and SSW, being farthest from land with their north end; and as they go southward, so they do come nearer to the land; and near the Tuskard, a rock right against the point of Greenore, in which place they end, they are not much more than two miles distant from the land, whereas the distance betwixt the north end, near the island Dalkee (which island, as before we have shewed, lieth at the entrance of Dublin bay, about threescore miles from the Tuskard) is above eight miles. They are all of a stony ground, in some places but one fathom deep, and a fathom and a half; but in the north end two fathoms and a half, and three fathoms.


Betwixt these grounds and the land lye two or three little sands, besides those which lye in, and before the mouth of the bay of Wexford one betwixt the south end and Greenore; another to the south of the head of Glascarick, a good mile from the land, called Ross and Ram, and a third one mile to the south of Arklow head, called Glaskermen, somewhat more than half a mile from the land, and about two miles long.




---

p.25


### Of the Channel betwixt the land and the forenamed Grounds.


THE channel betwixt the great grounds and the land is very deep all over, so that the biggest vessels may pass through it from Dublin to Wexford, and from Wexford to Dublin, taking care only that they do not come too near the grounds, the which being very steep on the inside (as they are also without, or on the east side, where ships may not come nearer to them than in twenty four and twenty five fathoms, because that in twenty fathoms one is close by them) it is requisite not to go further off from the land, than in seven or eight fathoms, in which depth ships may within a cable's length sail all along the coast, the which here everywhere is very clean, and free from all danger. And even between the land and the forenamed small grounds, Glaskermen and Ross and Ram, the sea is very clean and deep, so as most ships do pass betwixt them and the land, and not about by the outside of them.


These sands in four several places are cut thorough with fair, broad and deep channels, whereof the one is over against the bay of Wexford, the other against Glascarick, being no less than fifteen or sixteen fathoms deep, the third right against Arklow, in which channel it is about seven or eight fathoms deep; and the fourth is directly against Wicklow.


### Blind Rocks upon the Coast of Ireland from the Saltees unto Wicklow.


THERE are some blind rocks in this sea, but lye for the most part close under the land, or near some of the little islands or high rocks, so as they may easily be shunned, the rather because most of them do at low water appear either in part or altogether. To speak a little of these in order: the Saltees, two little islands situated half way between the haven of Waterford and the head of Carnesore (of the which hath been spoken heretofore) have both at the north side some blind rocks, whereof those which lye near the bigger and southernmost island, fall dry at low water. About three miles to the south of the same bigger island lieth a blind rock called Kingmore, of the bigness of a ship, at half ebb it cometh above water, and is so steep, that with the side of a ship one may lye close against it, and have fourteen fathoms of water, so as without any danger one may sail very close by it. To the southeast of the forenamed bigger island doth also lye some blind rocks, called the Furlas, the which may be seen at low water, and ships may pass thro' the midst of them. About half a mile from blackrock (a noted rock whereof shall be spoken anon) lieth a blind rock, called the Barrel, of the which one must take heed very carefully.


---

p.26



A little to the west of Carnesore lieth a small rocky foul, close under the land. Betwixt Carnesore and St. Margaret's bay it is foul and rocky, but the foul grounds do not reach far into the sea.


SSE from St. Margaret's bay lieth a blind rock, called Caliogh, the which at low water falleth dry. From the point of Greenore a riffe of blind rocks and stones runneth almost the length of a mile into the sea, the which at low water falleth dry a good way from the land. At the northside of the head of Arklow lieth a little stony row, the which is shunned very carefully by the ships, not daring to come nearer to it than in five fathoms of water.


### The rest of the blind Rocks upon the Coast of Ireland


JUST to the south of the head of Wicklow, a little way from the land, lieth a rocky sand called Horse shoe; betwixt which and the land ships may sail thorough, if need be but that being full of danger, it is done very seldom, and a little further to the south lieth a little blind rock close by the land, called the Wolf, the which at half ebb cometh above water, betwixt which and the land fishers boats do pass.


The like blind rocks and rocky sands lye upon the coast betwixt Tredagh and Dundalk, as also betwixt Dundalk and Carlingford, in both places close under the land at both the points of the havens of Carlingford and Strangford under St. John's point, situated half way between those two havens: on both sides of those two great rocks, a little way beyond Strangford haven, called Southrock and Northrock between the islands of Copland isles and the land, at the south point of the bay of Knockfergus, round about those great rocks over against Oldfleet, called the Nine Maids, to the west of the little island called Sheeps island betwixt Port Belletree and Skires Portrush, which rocks are called the Chickens, half way betwixt Lough Swilly and Sheep Haven, a mile or two from the land, which rocks the flood doth cover, but at ebb they come above water; and in several other places upon the west coast and the south coast the which it would be tedious all to particularize wherefore we will conclude this rehearsal of the blind rocks with that which to the west of St. John's point (a point situated three or four miles southward from Kilbeg haven) doth lye somewhat more than a mile off from the land, upon which the sea breaketh with great noise, and nevertheless one may freely and without any danger sail between the same and the land.




---

p.27


### Rocks in the Irish Sea, upon the east side and the north Side of the Coast.


THERE be also divers rocks that always stand above water, the which as they are dangerous in the dark night, and in misty weather, so at other times they are rather profitable than hurtful, forasmuch as they serve the sea-faring men for sea marks, and help them to discern the situation and distances of the coasts; wherefore also the most part of them have received peculiar and proper names. The principal of this whole number is the Tuskard, a great black smooth rock, of fashion like unto a ship turned the upside downwards, but as big again, lying south eastwards from the point of Greenore the space of three miles. To the southwest of the Tuskard a great way, and about a mile and a half from the bigger of the Saltees, is the rock Kingbeg. To the north east of the Saltees stand two rocks not far the one from the other, of which the one of its situation is called Northrock, and the southernmost the Tuns. To the east of these two, and about three miles from the point of Carnesore, lieth Blackrock, being clean of all sides, so as ships may freely sail round about it without any fear or danger.


A mile or two to the north of Lambay lieth a great rock called rock Abill, about which ships may sail of all sides.


Two miles beyond the north point of the haven of Strangford are two great rocks, the one called Northrock, and the other, distant two miles from it to the south, Southrock; the Northrock is a number of rocks lying close together, divers whereof are covered at high water. From the end of these two shoot out riffs of foul and rocky ground, but betwixt them goeth a broad, clean, and deep channel, through which all manner of ships, even the biggest, may pass.


Six or seven miles to the north of the bay of Knockfergus, and three miles from the land, are the Nine Maids, being great rocks that lye but a little above the water, or low rocky isles, with a great number of blind rocks about the same, so as ships may come no nearer to them than within five or six miles.


Of the same kind of low rocks, or little rocky islands, are also those who are called Enesterhull islands, being situated before the most northerly point of Ireland, betwixt Lough Foyle and Lough Swilly.


### Rocks in the Irish Sea, upon the western and the southern Coast.


NEAR the islands of Aran upon the north west coast of Ireland, lye several high rocks, called the Stags of Aran, and such other rocks, called the Stags of Broad haven, lye three or four miles from the northern point of Broad haven.




---

p.28


Three miles to the north west of Achil head lieth Blackrock, a great, high and black rock, with several other rocks near unto it.


On the north side and west side of the islands Blasques, lying over against the most westerly point of lreland, are several great rocks, some whereof are called the Horses, and others the Bucks.


Seven or eight leagues to the south of Blasques lye three great rocks, called the Skellighs, the easterliest about three miles, and the westerliest six or seven miles from the land, the which, to those that come from the south, when first they begin to see them, resemble the sails of ships.


Without the head of Dorses lye three other great rocks, whereof the uttermost, or the most westerly, is called the Bull, the middlemost the Cow, and the third the Calf, being clean round about, so as without any danger one may sail between them.


Five or six miles west and by south of the head of Clare lieth a high steep rock alone in the sea, called Fastney, the which at the first appearing looketh like the sail of a ship.


Two or three miles to the east of Baltimore, and a mile or two from the land, lye five or six high steep rocks called the Stags, as those of Aran and Broad haven, to those that come from the east along the land, when first they begin to have them in sight, they resemble some spires or pointed steeples standing together.


Two miles eastwards from the mouth of the haven of Kinsale, lye two great black rocks, the one somewhat farther from the land than the other.


There lye also several rocks near the little islands of Dalkee and Ireland's-eye, the one situated before the north point, and the other before the south point of the bay of Dublin, as heretofore we have shewed. Likewise on both ends of the isle of Lambay, half way betwixt the same island and Tredagh haven, close by the land, near the island Raghlin, near Skires Portrush, and in several other places, but the principal and most considerable are those whereof we have spoken.


Of the Nature of the Irish Sea, and of the Tides which go in it.
----------------------------------------------------------------


### The Irish Sea not so tempestuous as it it is bruited to be


THAT part of the Irish sea which divideth Ireland from Great Britain, is very much defamed both by ancient and modern writers, in regard of its boysterousness and tempestuousness, as if it were more subject to storms and raging weather than any other, and consequently not to be passed



---

p.29




without very great danger: Mare quod Hiberniam et Britanniam interluit, undosum inquietumque, toto in anno non nisi paucis diebus est navigabile That is, 'The sea which passeth betwixt Ireland and Britain, is boysterous and restless, so as but few days in the year ships can go upon it'; saith Solinus with whom Giraldus (who several times went to and fro betwixt England and Ireland) fully agreeth, writing in this manner, Hibernicum mare concurrentibus fluctibus undosissimum, fere semper est inquietum, ita ut vix etiam aestivo tempore paucis diebus se navigantibus tranquillum proebeat. That is, 'The Irish sea being very boisterous through the concourse of the waves, is almost always restless, so as even in the summer time it is hardly for a few days quiet enough to be sailed upon.' Likewise also Camden and Speed give unto this sea the surnames of boysterous and tempestuous. Yea it is a common proverb in England, 'As unquiet as the Irish sea'. Nevertheless it is nothing so bad as they make it, and the words of Stanyhurst, in his annotations upon Giraldus, Mare Hibernicum satis tranquillum est, nisi ventorum vi agitetur, et non solum aestate, sed etiam summa hyeme vectores ultro citroque navigant. 'The Irish sea is quiet enough, except when by high winds it is stirred, so as not only in the summer, but even in the midst of winter people do pass it to and fro,' are altogether true, and confirmed by daily experience. True it is that some ships do perish upon this, but the same happeneth also upon other seas, who are all subject to the disaster of tempests and shipwracks.


### Causes of the Loss of such Ships as perish upon this Sea.


THE common cause of the casting away of ships upon this sea, and upon the east coast of Ireland, is this, that in the long dark winter nights (when this disaster is more frequent than at other times of the year) some furious storm arising, the ships are dash'd against the rocks, against the rocky shores, or against those grounds which extend themselves betwixt the Tuskard and the bay of Dublin, whilst the steermen and pilots by reason of the darkness not being able to discern the land, or any of their wonted marks, do not know which way to steer to shun those dangerous places, and to keep themselves in the open sea.


### Nature of the Ground of the Irish Sea.


THE ground of the Irish sea, as well in the midst, as under the land, is almost every where clear sand, but in some places black and muddy or oozy earth; in very few places rough and sharp; and scarce any where else but in the bay of Wicklow, so hard and stifly compacted, that the anchors can take no hold of it.




---

p.30


### Of the Tides in the Irish Sea.


WHAT concerneth the ebbing and flowing in this sea, which invironeth Ireland upon all the west side it floweth against the land, and the ebb falleth back from it into the sea, the flood from, and the ebb towards the west, for which reason very great tides, as well of ebb as flood go upon all this coast, not only the open shores, but in the bays and inlets (even those which go a great way into the land, as the haven of Limerick) so as those, who have been at Galloway, do assure us, that it doth so mightily ebb and flow there, that at high water great vessels may sail over those rocks, the which with the ebb come above water.


Upon the other side of Ireland it ebbeth and floweth along the land, for upon the north side of Ireland the ebb and flood falleth in the same manner as upon the west side, flowing from, and ebbing towards the west. But upon the east side, from Fair-foreland unto Carlingford, the flood cometh from, and the ebb falleth to the north as upon the rest of this east side, to wit, from Carlingford to Carnesore, it floweth from the south, and ebbeth from the north. For although upon all this side the flood runneth along the land, yet doth it not take its beginning from one and the same, but two contrary points; the which two floods coming the one out of the main sea in the north, and the other out of the main sea in the south, do meet and stop one another before the haven of Carlingford.


From Tuskard and Carnesore as far as to the head of Clare, being the whole southeast coast of Munster, the flood falleth along the coast ENE, and the ebb WSW. But upon the rest of the coast of Munster, beyond the head of Clare westward, which coast lieth W and by S, the flood falleth eastward, and the ebb to the west.


### Strong Tides in the Sounds. Strange Property of the Bay of Wexford in the matter of Tides.


THAT which the sea-faring men do witness, that in the sound of Blasques, of Dalkee, and in that of Lambay, as also in some other narrow channels of this sea, there goeth a very strong tide, as well of the ebb as flood, is no other than may be observed almost everywhere else in places of the like nature.


But it is much to be wondred, what the same do relate of the channel or entrance of the haven of Wexford, to wit, that it ebbeth and floweth there three hours sooner than without in the open sea, so as when it is high water in the


---

p.31




channel of that haven, and upon the bar of the same, the flood doth still for half a tide, or three hours after, strongly run by it to the north, whereby it cometh to pass that the end of Haneman's path (a great sand lying just before the haven of Wexford) is cast up more and more to the north, and that the channel which passeth by the north side of that sand, being the entrance of the haven, is now more to the north than it hath been formerly. And as it floweth three hours longer in the open sea than upon the bar and in the channel of this haven, in the like manner also, the ebb in the sea falleth to the south three hours after that it is low water in the same place, but not so strongly as the flood.


### Some other strange Particulars about the Tides in the Irish Sea, related by Giraldus, but found not to be true.


MORE strange it is what Giraldus writeth of the havens of Wicklow and Arklow, to wit, that in Wicklow haven it ever floweth, when in the sea it ebbeth, and that it ebbeth there when it floweth in the sea. And that in the same river (this haven being nothing else but the mouth of a little river) the water is salt as well when the ebb is at the lowest, as at the flowing and high waters and that to the contrary in that rivulet, which at Arklow dischargeth it self into the sea, the water keepeth its sweetness at all times (never receiving the mixture of any saltness) as well with the flood and high water, as with the ebb. But experience sheweth these things to be repugnant to the truth, as also what he writeth of a rock not far from Arklow, at the one side whereof he saith that it always ebbeth, when it doth flow on the other, and to the contrary. Also that in Milford haven (situated in the southernmost part of Wales, in a manner over against Waterford) and upon the next coasts, it ebbeth and floweth at quite contrary times to what it doth at Dublin, and the coast thereabouts, so that it should begin to ebb in Milford haven, when in the bay of Dublin it beginneth to flow, and to flow in Milford haven when it beginneth to ebb at Dublin: which how untrue it is, all those can witness, who having been in both places, have had the curiosity to observe the times and hours, at what age of the moon forever, wherein it doth begin to ebb and to flow there.




---

p.32


Of the Springs and fountains, item, of the Brooks and Rivulets of Ireland
-------------------------------------------------------------------------


### Of the Springs and fountains.


HAVING sufficiently spoke of the sea wherein Ireland lieth, and of whatsoever belongeth thereunto, we shall now, before we come to treat of the land it self, speak of the waters within the land, first of the springs and brooks, afterwards of the rivers, and lastly of the loughs or lakes.


As for the first, to wit, fountains and springs, Ireland is very full of them every where, not only in the mountainous and hilly parts, but even in the flat and champain countries. Which springs for the most part are all of one and the same fashion, being like unto a small pit full of water up to the brim; at the lower side whereof the water doth run forth, without making any noise or bubling. For that kind of fountains which forcibly burst out of the side of a rock, or spout their water on high, are very rarely to be found in this kingdom. The water of these well-springs is for the most part cool, clear, and pure; free from all strange smell and taste in which properties nevertheless, and in the wholsomness of the water, the same differences are found, and for the same causes, as in other countries. For those which spring out of a gravelly or sandy ground are purer than those that spring out of earth or clay; those that rise out of a stony or rocky ground, cooler than any of the former, those that are exposed to the sun, and freely receive the beams thereof, especially of the morning sun, have lighter and wholsomer water, although less cool than those which are contrarily seated; and so for the rest.


### Spaws and Holy-wells in Ireland.


A FEW years since some fountains have been discovered in Ireland, some of them not far from Dublin, and others in other parts, whose veins running thro' certain minerals, and washing off the vertue of the same, yield a medicinal water,


---

p.33




apt to open the obstructions of man's body, and to cure other accidents thereof, which kind of fountains are commonly called Spaws, a name borrowed of a certain village in the country of Liege, in which there is a spring of that sort, absolutely the principallest, and the most effectual of all those of the same kind, and therefore of very great renown in near and in far countries. Besides these spaws there are also a great number of other fountains throughout the land, called holy wells by the inhabitants, whose water not differing from that of other wells, in smell, taste, or in any other sensible duality, nevertheless is believed to be effectual for the curing of several diseases. But experience doth shew, that those vertues are not found in the springs themselves, but only in the vain imagination of the superstitious people; the which also having dedicated every one of those to some particular saint, do expect the supposed vertue rather from the power of them, than from any natural efficaciousness inherent in the water it self.


### Of the fabulous Fountains of Giraldus Cambrensis.


AS FOR those wonderful springs mentioned by Giraldus Cambrensis, one in Munster, whose water presently maketh them grey that wash their head or beard therewith, one in Ulster, of quite contrary vertue, so that the persons washed therewith never come to be grey; one in Connaught, whose water good and commodious for the drinking, and other uses of men, is hurtful, yea deadly to cattle, sheep, horses, and all other sorts of beasts; and yet another in the same province, the which being on the top of a high hill, far from the sea side, ebbeth and floweth twice a day, in the same manner as the sea, I could not hitherto come to the speech of any, who in our times had seen those fountains, or observed any such thing in them, which maketh me doubt, that that good man hath been deceived herein by his credulity, as in innumerable other things, the which being evidently untrue and fictitious, are by him related for certain truths. As in this matter, who seeth not the idleness of that fiction concerning a certain fountain in Munster, whereof he writeth, that as soon as any body doth touch it, or but look at it, it beginneth presently to rain most heavily over all the province, and continueth so to do, until a certain priest, appointed for that purpose, and who hath never lost his maidenhead, do appease the fountain, in singing a mass in a chappel standing not far from thence, and built expresly for that end, and in besprinkling the same fountain with holy water, and with the milk of a cow of one colour.




---

p.34


### Of the Brooks in Ireland.


No country in the world is fuller of brooks, than Ireland, where the same be numberless and water all the parts of the land on all sides. They take their beginning three several manner of ways. Some have their source of fountains, the which for the most part are very small, not only those who carry the water but of one spring (most of which are rather like unto a gutter, than a brook) but even those into which the water of several fountains doth flow together. Others rise out of bogs, the which besides their own universal wetness being full of springs, and by reason thereof gathering in them more water than they are able to drink in or contain, do necessarily send out the same in convenient places, and so give a beginning unto rivulets and brooks. The third sort take their beginning out of certain small loughs, which brooks ordinarily are of a reasonable bigness, and far surpass the other two sorts, although there do not want some, even of this kind, which are very little. And there is very few of any of these kinds, who come to any notable bigness, as long as they continue to be solitary, and until having received the water of several other brooks, do thereby grow more considerable than they were in their first original.


These brooks, besides the great good they do the land in watering the same, and beside the commodity they afford of drenching the cattle and other beasts, do also greatly serve the inhabitants for another good use, to wit, the grinding of their corn, whereunto the windmills are very little used in Ireland, because they have the convenience through the great number of brooks, to erect watermills in every quarter where it is necessary, which bring a great profit to the owners, being kept and maintained with less cost and labour.


### Of the swelling and overflowing of the brooks.


Some of the brooks do flow in an equal bigness all the year long, without receiving any notable increase or diminishing, but far the major part do change according to the wet or dry seasons of the year, and as many of them as come out of the mountains, or run through hilly countries, swell so excessively, when any great rain doth fall, that they not only overflow the next low grounds, doing many times great damage in them, but also bring the way-faring men into great distress, for it cometh to pass very oft, that a brook, which ordinarily is very shallow and still, riseth so mightily through the multitude of the rain water, which from the next mountains and hills descendeth into it, that a good horse cannot pass without swimming, where at other times a child easily



---

p.35




may wade over; and with that abundance of water is commonly joined so strong and impetuous a current, that man and horse are often carried away with it, to their extreme danger; and whatsoever we say herein of the brooks, is much more to be understood of the rivers, the which otherwise in convenient places or fords may be passed over; wherein the aforesaid danger is greater yet so that few years pass in Ireland, in the which some persons are not drowned in that fashion.


### Strange invention of a man to pass a Brook, greatly risen by the abundance of Rain.


It shall not be improper to insert here a particular observed by a very credible and reverend person, Theophilus Buckwort, bishop of Dromore, the which he hath several times related to my brother and others, being this; The Lagon, a little river or brook, which passeth by the town of Dromore, upon a certain time being greatly risen through a great and lasting rain, and having carried away the wooden bridge, whereby the same used to be passed at that town, a country fellow who was travelling that way, having stayed three days in hope that the water would fall, and seeing that the rain continued, grew impatient of staying longer, and resolved to pass the brook whatever the danger was; but to do it with the less peril, and the more steadiness, he took a great heavy stone upon his shoulders, whose weight giving him some firmness against the violence of the water, he passed the same without harm, and came safe to the other side, to the wonderment of many people, who had been looking on, and given him all for a lost person.


### Of the brooks of Drumcondra and Rathfarnum by Dublin.


OF these dangerous brooks there are two hard by Dublin, both running into the haven some what more than a mile from the city, the one at north side thereof, a little below the village Drumcondra, which is seated upon the highway from Dublin to Drogheda, and the other at the south side, close by the Rings-end. This called Rathfarnum water of the village by which it passeth two miles from the sea, and the same distance from Dublin, is far the worst of the two, as taking its beginning out of those great mountains southwards from Dublin, from whence after any great rain such abundance of water is descending to it, that the same, which at other times is of very little depth, groweth thereby so deep, and exceeding violent, that many persons have lost their lives therein, amongst others Mr. John Usher, father to sir William Usher that now is, who was carried by the current, no body being able to succour him, although



---

p.36




many persons, and of his nearest friends, both a-foot and horseback were by on both the sides. Since that time a stone bridge hath been built over that brook (as over Drumcondra water there hath been one from antient times) upon the way betwixt Dublin and Rings-end, which was hardly well accomplished, when the brook in one of those furious risings quite altered its channel for a good way, so as it did not pass under the bridge as before, but just before the foot of it, letting the same stand upon the dry land, and consequently making it altogether useless: in which perverse course it continued, until per force it was constrained to return to its old channel, and to keep within the same. To go from Dublin to Rathfarnum, one passeth this river upon a wooden bridge; the which although it be high and strong, nevertheless hath several times been quite broke, and carried away through the violence of sudden floods; although at other times, and when that brook doth only carry its ordinary water, a child of five years may easily and without danger wade through it, and a tall man on horseback riding underneath it, not being able to reach it, in the great floods the water many times riseth so high, as that it doth not only touch, but floweth quite over the bridge.


Of the Rivers of Ireland.
-------------------------


### Of the Shannon.


BESIDES the excessive number of brooks wherewith Ireland is water'd, it hath a good many rivers, the which being broader and deeper than the brooks, are consequently navigable, although the major part are not portable of any great ships nor barques, but only of small vessels and boats.


The principallest of all is the Shannon, who taking his original out of Lough Allen, and in his course dividing the province of Connaught from Leinster, and afterwards also from Munster, passeth through two other great loughs, to wit, Lough Ree, whereout she cometh just above Athlone (a mean market town, but adorned with a stately and strong castle, the ordinary residence of the presidents of Connaught) and Lough Dergh, about halfway betwixt Athlone and Limerick, and a little below the said town she dischargeth her self again into another lough, by far the biggest of all, the which extending it self from Limerick unto the sea, and above fifty miles long, it is held by the Irish as well as the English not for a lough, but for the Shannon it self, and consequently called with that name; whereof hath been spoken in the second chapter.




---

p.37


This river is wide and deep every where, so as she would be navigable in her whole length, not only with boats of all sorts, but with reasonable big ships, to the great commodity of them that inhabit near it, were it not for the impediment of a certain rock, some six miles above Limerick, the which standing across in the channel, and the river with great violence falling downwards over it, all communication of navigation betwixt the upper and the lower parts of it thereby absolutely hindred.


Sir Thomas Wentworth, lord Wentworth, and afterwards earl of Strafford, he that in the beginning of this present parliament was beheaded, having been governor of Ireland many years, first in the quality of lord deputy, and afterwards of lord lieutenant, had a design to take away that let, in causing of a new channel to be digged for a little way, whereby the river being made to alter her course, should have avoided that rock; and to that purpose sent certain skilful men thither to view those parts, and carefully to examine whether it were feasible, who made report that it might be done, and would not cost above seven or eight thousand pounds sterling, a sum not very considerable in comparison of the great profit which afterwards would have been reaped from that work; nevertheless it was never taken in hand, the intents of publick utility having been diverted and smothered by those of private profit, as commonly it falleth out.


### The Rivers Suck, Sure, Oure, Broad-water, Barrow and Slane.


THERE are several other rivers in the province of Connaught, but none of them is any ways comparable with the Shannon for length, breadth, or depth, and little to be said of them, but that the Suck, the which falleth into the Shannon a little way below Athlone, is the principallest of all.


The two chief rivers of Munster are Sure and Broadwater, the city of Waterford being situated upon the first of those two, the which close by it dischargeth herself into that arm of the sea which is known by the name of Waterford haven. The other passeth by Lismore, and falleth into the sea by Youghal, where it maketh a tide haven. Next to those two is the river of Cork, and then that of Kinsale, the which is but of small moment, as also are the rest of the rivers of this province.


In Leinster is the Nure or Oure, the Barrow, the Slane, the Liffy, and the Boyn, besides some others of less moment. The Oure and Barrow mingle their waters at the town of Ross, from whence having past a little way together, they discharge themselves into the right arm of the haven of Waterford, and so in a manner do meet the Sure, who falleth into the other arm, for which consideration these three rivers were wont to be called the three sisters, as Giraldus witnesseth. Both the Oure and the Barrow are portable many miles into the country, the Oure only with little boats, and with cots (they call in Ireland cots things like boats, but very unshapely, being nothing but square pieces of timber made hollow) but the



---

p.38



Barrow with good big boats. The Slane falleth into the havens of Wexford, being like unto the Oure for length and bigness.


### Of the Liffy and the Boyn.


THE Liffy is the princess of the Irish rivers, not for her bigness (for not only the Shannon, but the Boyn, Barrow, and several others, do far surpass her therein) but because Dublin, the chief city of all Ireland, is seated upon her bank, a mile below which city, at a place called Rings-end, she loseth herself in a bay of the sea, which is called Dublin haven. With the help of the flood, ships of fifty and threescore tunns can make a shift to come up to the key of Dublin, but when the tide is out, and at the lowest, the smallest boats find hardly water enough to go between Dublin and Rings-end, because the channel being very broad there, the water spreadeth it self too much, and by reason thereof groweth very shallow. But in the city it self, where she is inclosed betwixt the keys on both sides, and from the bridge of Dublin until the bridge of Kilmainham, and a little further, being somewhat more than a mile (in which space she runneth between her own banks) great boats may go upon her at any time. She would be navigable with boats some three or four miles further, but the weres, made in her a little way above the bridge of Kilmainham, do hinder that. This river taketh her beginning in the mountains lying to the south of Dublin, not above ten miles from it, but fetcheth such a compass (bending her coast first to the west, afterwards to the north, and lastly, for seven or eight miles, eastward) that from her original to her mouth is the space of no less than forty or fifty miles.


The Boyn, the river whereon Tredagh is seated, hath her beginning in King's county, close by the original of the Barrow, although the place where the Barrow falleth into the haven of Waterford, is above fourscore miles distant from the mouth of the Boyn. This river is almost of an equal bigness in far the greatest part of her course, and would be portable of good big boats very many miles into the land, if that were not hindred by the weres.


### Of the Bann and Blackwater.


THE principal river in Ulster of those that fall directly into the sea, is the Bann, the which as in her mouth, she is incumbred with several inconveniencies, as we have declared above in the third chapter, so she is portable but a few miles from the sea, because of a certain rock, the which running across the channel from the one bank to the other, stoppeth all manner of passage, not only of bigger vessels and barks, but of the smallest boats, which dare not come near the same rock, because it being somewhat high, and the water from it falling downwards with great violence, it goeth for some space with a mighty current. This rock or cataract, called vulgarly the salmon-leap (for a reason hereafter to be declared) and the fall, because of the falling down of the water, is not above


---

p.39



four miles from the sea, hindring all manner of communication between the same and Lough Neagh, from the which this cataract is distant about three miles: whereas otherwise, if the passage of this river from the sea to the lough were open, ships might by that means go a great way into the land, not only the whole length and breadth of Lough Neagh (which every where is very deep, and navigable even for great ships) but even a good many miles farther (with good big boats) by means of some rivers that fall into it, especially the Blackwater, which is the principallest of them all. For the Bann, although she giveth the name to the river going out of the lough, is not comparable to the Blackwater for breadth nor depth, being rather a brook than a river, the which being very shallow at other times, doth rise so excessively upon the falling of much rain, that it is one of the most dangerous and terrible brooks of all Ireland, in the which therefore from time to time many men and horses have been drowned at the passing of it.


### Of the Lagon and Newry-water, Tide Rivers.


BESIDES the Bann and the Blackwater, there is scarce any other river in Ulster, but that which passing by Strabane and Londonderry, dischargeth itself into Lough Foyle. For the Lagon, heretofore mentioned by us, which by Belfast falleth into the sea, the Newry water, whereof we have spoken in the description of Carlingford haven; and some others of that nature, are properly brooks, and not portable by reason of their own water, but of that which out of the sea floweth into them; as appeareth clearly when the tide is out. For then they are as small, and as little portable in those places, where the boats and bigger vessels do pass at high water, as are they at all times in those places unto which the tide doth never reach which kind of tide rivers or brooks, which only by the coming in of the tide are made navigable for a little way, are to be found in all the provinces of Ireland.


### Of the Cataracts in the Irish Rivers.


BESIDES that the navigable rivers are but rare in Ireland, and that the most part of them are only portable of very small vessels and boats, not of any bigger ships or barks, as appeareth by the former relation, there be very few rivers, who have not some impediment or other in them, whereby it cometh that they are not portable so far as otherwise they would be. These impediments are chiefly three in number, cataracts, weres, and fords; whereof the last two do only concern the lesser rivers. The first, to wit, the cataracts, are incident to the greatest rivers as well as to others, as may appear by what we have said concerning them in the description of the Shannon and the Bann; whereby also fully may be conceived the manner and nature of the said cataracts, so as it is needless here again to delineate them.


Such a cataract or fall there is found in the Liffy, seven miles from Dublin, and about a quarter of a mile above the village and castle of Leslip, the description


---

p.40



of which as holding it not improper for this place, we shall here set down as it came to our hands from those who have observed it very exactly. The said river running thereabouts along a narrow and deep valley, being hemmed in at both sides with high hills of a long continuance, hath a very rocky channel, and besides that the bottom is overspread in several paints with great massy stones, there is in two or three places, at no great distance, a continual rocky bulk reaching from one side to the other, leaving but one or two narrow passages, through which the stream runneth with a very strong current, and a mighty noise, but the third and last bulk, like a cataract hath the channel close to it, a great deal lower (by far more than the other, at least by seven or eight feet) which is the cause that the stream doth not so much run swift here, or passeth with a current through narrow channels, as in the two first bulks, but as soon as it is got over the rock it falleth steep down with great violence, the space of three or four paces in breadth, whereas the remainder of the main channel is altogether stopp'd by the said rock. ln winter and other very rainy seasons, when the water doth increase much, it passeth overall the said rocks smoothly and without noise, where the same is exceeding great, those times, when the Liffy runneth with a small stream.


There is also a cataract in a small tide river in the county of Cork in Munster, the which falleth into the innermost corner of the great bay Bantry, and one in the haven of Ballyshannon, which haven being in effect nothing else but the mouth of Lough Earn, commonly is counted for a river, and called by the name of Trowis.


### Of the Fords in the Rivers of Ireland a second Impediment of their Navigableness.


CONCERNING the fords; it is to be observed, that not every where, where the high-ways meet with great brooks or small rivers, bridges are found for to pass them, but that in very many places one is constrained to ride through the water it self, the which could not be done, if the rivers kept themselves every where inclosed between their banks; wherefore they are not only suffered in such places, to spread themselves abroad, but men help thereto as much as they can, to make the water so much the shallower and consequently the easier to be pass'd, whereby it cometh many times to pass, that a river which above and below the ford is deep enough to be portable of great boats, through the shallowness of the fords lying between, will bear none but of the very smallest; or where otherwise the same would carry small boats is not portable at all, this in most places might easily be remedied, in raising of dikes or artificial banks, where the natural ones failing do minister opportunity unto the rivers for to spread themselves; and making bridges to pass over. Some fords, do not greatly impair the channel of the rivers, but leave the same almost in her full depth, especially in the midst: but the same, as they are more incommodious for the traveller, so they are not very frequent, but in far less number than the others.




---

p.41


### Of the Weres, a third Impediment of the Navigableness of the Rivers in Ireland.


THE weres, a third let of the navigation of the Irish rivers, are thus ordered: they set up very big stones in the river, close together from the one side of the river to the other, leaving only one hole, either in the midst, or near one of the sides, before which hole a basket being laid, they take therein a great quantity of fish, for coming to the weres, and finding their way stopt by the stones, they take their course to that place where they find an opening. These rows of stones do not directly cross the river from the one side to the other, but do go very much sloaping, that the stream with less force may beat against them and the same also do stand but very little above the water, to the end that when the floods come the water may find a ready passage over them, without which they would not be able to subsist against the force thereof, but easily be thrown down and scattered.


Some weres are set up, not so much for the taking of fish, as for mills, that the course of the water thereby being in part stopped in the main channel, may be made to go into some little by-channel, cut expresly for to conveigh the water to the mill; many weres serving for both these uses jointly.


Some rivers have only one of these impediments, as the Shannon and the Bann, each a fall or cataract: the Boyn, weres, having only fords many miles from the sea. The greatest number have weres and fords, and commonly each of them in several places. Some have all three, as the Liffy by name, which hath not only weres and fords in several places, but also a cataract or salmon-leap, as hath been mentioned above.


Of the Lakes or Loughs of Ireland.
----------------------------------


### Of the little Loughs.


LOUGHS there is a very great number in Ireland, especially in the provinces of Ulster and Connaught, we may distinguish them into three several sorts, great, middle sort, and the least. Under this last we comprehend all such whose parts discover it self to the eye all over at one time. This sort of loughs are found in several places of the other provinces, but nothing near so many as in Ulster. Every one of these commonly sends forth a brook, and some more than one, being all of them very deep (the very least



---

p.42




not excepted) and well stored with fish so as they are not only delightful, especially such as are situated in some dale or valley, or environed round about, or on some sides with pleasant little hills (as it falleth out in the greatest part of them) but also commodious and profitable, affording good opportunity to build houses and castles upon their borders, which was done in many places by the English and Scots, who had made several fair plantations, and would have done more, if it had not been hindred by that horrible rebellion of the bloody Irish, in the beginning of which many of them which were already built have been destroyed by those barbarians.


Many of those little loughs have a little island in the midst, which is both commodious and pleasant. Some wherein little islands do float, not keeping long any certain place, but removing to and fro as the force of the wind doth drive them.


### Of the middle sort of Loughs.


THE middle sort of loughs we understand to be such as far exceeding the forementioned in bigness, nevertheless are not to be compared with the biggest sort, of which we shall speak presently; of this kind are Lough Fin and Lough Dirg in the county of Dunnagal in Ulster, Lough Mugney in the county of Monaghan, and Lough Silline in the county of Cavan, both in the same province; Lough Ramore in east Meath besides several others in other counties of Leinster, especially in Queen's county, Longford, and west Meath, having little or nothing worthy of observation.


### Of the great Loughs, and first of those of salt Water


THE great loughs are of two sorts, either of sweet water, as all the former; and some of salt water; these last being such through the mixture of the sea, the which finding an open entrance, and twice a day with the tide fully flowing into them, maketh the water so salt. And it would be no great error to take all those loughs wherein that happeneth, (viz. Lough Cone, in the county of Down, Lough Foyle, in the county of Colrain; Lough Swilly, in Tirconnel, and the lough of Cork) rather for inlets of the sea than for lakes, altho' the inhabitants hold them all to be loughs, and give them the name of loughs: and in this number is also to be put that great lough betwixt Limerick and the sea, through which the Shannon dischargeth it self into the sea; of the which we have already spoke once or twice heretofore.


### Of Lough Earn, Lough Neagh, and the rest of the great Loughs.


AMONGST the great loughs of sweet water, are far the principallest Lough Earn and Lough Neagh, the first of which is situated in the confines of Ulster and Connaught, being in effect two different loughs, joined together only by a short and narrow channel, of which two, that which lieth farthest within


---

p.43



the land, doth extend it self in a manner directly north and south; but the second, which is next to the sea, doth lye east and west; so that both together they have the fashion of a bended elbow, being both very broad in the midst, growing by degrees narrower towards both the ends.


Lough Neagh lyeth in the north easterly part of Ulster, bordering upon the counties of Tyrone, Ardmagh, Down, Antrim, and Colrain, being of a round, or rather somewhat oval figure.


Next in bigness to these two is Lough Corrie, the same on whose nether end the city Galloway is seated. The two loughs thorough which the Shannon passeth, Lough Ree, and Lough Dirg item, Lough Fingarrow in Connaught, betwixt the counties of Mayo and Roscommon.


In the last place, as the least of this sort, are Lough Allen, out of which the Shannon taketh his original, being nine miles long, and three miles broad: Lough Maske, situated betwixt Lough Fingarrow and the lough of Galloway; and Lough Larne, in the county of Kerry in Munster, not far from the upper end of those two famous bays Dingle and Maire. The least of these is some miles long and broad, and many miles in circuit, but the biggest are of so vast a compass, that they are more like a sea than a lough.


### Of the Islands in the Loughs.


MOST of these great loughs are very full of little islands, and above all Lough Earn, in which the same are numberless. In Lough Cone also there is so great a number, that those who inhabit about it, affirm them to be two hundred and threescore. Lough Ree, and Lough Dirg are likewise very full of them, and there is also a good many in Lough Fingarrow, Lough Larne, and Swilly. But Lough Foyle is very free from them, and in the lough of Cork there is not above one or two, as likewise in Lough Neagh, in which they lye near to the sides, leaving the midst altogether free.


Very few of these islands are inhabited or planted; but the most part being plentifully cloathed with very sweet grass, serve for pastures to sheep and other cattle, the which do thrive wonderfully well in them, and the same befalleth also in the middle sort of loughs, amongst which likewise there be very few that have not some of these little islands in them.


In some few of these islands, especially of Lough Earn and Lough Ree, are some dwellings, whereunto persons who love solitariness were wont to retire themselves, and might live there with much contentment, as finding there not only privacy and quietness, with opportunity for studies and contemplations, but there besides great delightfulness in the place it self, with variety of very sweet pastimes in fowling, fishing, planting and gardening. In one of the greatest islands of Lough Earn, sir Henry Spoteswood had a fine seat, with goodly buildings, gardens, orchards, and a pretty little village, with a church and steeple belonging to it, which whether it is in being yet, or destroyed by the barbarians and bloody rebels, I am not informed. In Lough Silline in the county


---

p.44



of Cavan in an island not far from the bank where the river Nanny runneth into it, is a castle built of form four square, which covereth the whole isle, much after the manner of the fort Enniskilling in Lough Earn, and so many more too long to be rehearsed.


### Of Saint Patrick's Purgatory.


ONE of these little islands situated in Lough Dirg (one of the middle sort of loughs) hath been very famous, for the space of some ages, over almost all Christendom; because the world was made to believe, that there was the suburbs of purgatory, into which whoso had the courage to go, and remain there the appointed time, did see and suffer very strange and terrible things: which persuasion having lasted until our times, the matter hath been discovered within these few years, and found to be a meer illusion. This discovery was made during the government of Richard Boyle, earl of Cork, and Adam Loftus, viscount of Ely, and lord chancellor of Ireland which two being lords justices of that kingdom in the last years of king James, and desirous to know the truth of the business, sent some persons of quality to the place, to inquire exactly into the truth of the whole matter. These did find, that that miraculous and fearful cave, descending down to the very purgatory and hell, was nothing else but a little cell, digged or hewn out of the rocky ground, without any windows or holes, so as the door being shut one could not see a jot within it, being of so little depth, that a tall man could but just stand upright in it, and of no greater capacity, than to contain six or seven persons. Now when that any person desirous to go that pilgrimage to purgatory, was come into the island, the friars, some small number whereof made their constant abode there for that purpose, made him watch and fast excessively whereby, and through the recounting of strange and horrible apparitions and fantasms, which he would meet withal in that subterranean pilgrimage, being well prepared, they did shut him up in that little dark hole, and being drawn out again from thence after some hours, altogether astonished and in a maze, he would be a good while before he came again to himself, and afterwards the poor man would tell wonderful stories, as if in very deed he had gone a great way under the ground, and seen and suffered all those things, which his weak imagination, altogether corrupted by the concurrence and sequel of so many causes to weaken the brain, did figure unto him.


To prevent this delusion in future times, the said lords justices caused the friars to depart from thence, their dwelling quite to be demolished, and the hole or cell to be broke open, and altogether exposed to the open air, in which state it hath lain ever since whereby that pilgrimage to purgatory is quite come to nothing, and never hath been undertaken since by any.


To beget the greater reputation to this fictitious purgatory, the people was made to believe, that Saint Patrick, by whom the Irish were converted to the christian faith about four hundred years after the nativity of Christ, had caused


---

p.45



the same, and obtained it of God by his prayers, to convince the unbelievers of the immortality of the soul, and of the torments which after this life are prepared for the wicked persons, wherefore also they gave it the name of Saint Patrick's purgatory. But it is very certain, that nothing of it was known in Ireland during the life of that holy person, nor in a huge while after, it having been devised some ages after his death, when that the general darkness of the times ministred a great opportunity of such like inventions, to those kind of men that knew how to abuse the blind devotion of ignorant and superstitious people to their own profit and filthy lucre.


### Of the Property of Lough Neagh, of turning Wood into Stone.


BEFORE we make an end of this chapter, we must say something of the wonderful property which generally is ascribed to Lough Neagh, of turning wood into stone; whereunto some do add, to double the wonder, that the wood is turned not only into stone, but into iron, and that a branch or pole being stuck into the ground somewhere by the side where it is not too deep, after a certain space of time one shall find that piece of the stick which stuck in the ground, turned into iron, and the middle, as far as it was in the water, into stone; the upper end, which remained above the water, keeping its former nature. But this part of the history I believe to be a fable: for my brother, who hath been several times in places not far distant from that lough, and who of the English thereabouts inhabiting hath enquired this business with singular diligence, doth assure me, that he never could learn any such thing; but that the turning of wood into stone was by everyone believed for certain, as having been tried divers times by several persons: saying moreover to have understood of them, that the water hath this vertue only at the sides, and that not everywhere, but only in some few places, especially about that part where the river Blackwater dischargeth herself into the lough. He could never come to speak with any persons, who themselves had tried this matter; but with several, who affirmed, that to their knowledge it had certainly been done by others of their acquaintance. For further confirmation of this particular (which in it self is credible enough, seeing that in many parts of the world there are found waters indued with that vertue) serveth, that here and there upon the borders of that lough are found little stones of a pretty length, some of them round in their compass, others flat, or flattish, and some angulous, the which being looked on, as well near as from afar off, seem to be nothing else but wood, and by every one are taken for such, until one come to touch and handle them. For then by their coldness, hardness and weight, it appeareth that they are not wood but stone: whereby it may probably be conjectured, that the same formerly having been wood indeed, and so having kept their old shape and fashion, in length of time have been turned in to a stony substance by the vertue of that water, whereto they were fallen through the one accident or other.




---

p.46


Giraldus writeth, to have heard of a well or fountain in the north quarters of Ulster, the which in seven years space turneth into stone the wood cast into it but seeing that no body now a days knoweth of any such well, and that with all my enquiries I could never come to hear any news of it, I will believe, that Giraldus hath been misinformed, and that they have told him that of a well which was proper unto this lough.


Of the Nature and Condition of the Land, both for the outward Shape, and for the internal Qualities and Fruitfulness.
---------------------------------------------------------------------------------------------------------------------


### Distinction of Ireland into champain Lands, Hills, and Mountains


THE lands of this island, as of most all other countries, are of a various kind and fashion: for some parts are goodly plain champain, others are hilly, some mountainous, and others are composed of two of these sorts, or of all three together, and that with great variety, the which also is very great, in those three uncompounded sorts.


### A necessary Observation about the Use of the Words Hill and Mountain.


TO avoid all ambiguity, and make our selves clearly understood in what we have said, and are further to say upon this subject, we think it necessary to forewarn our reader, that we do use the word hill in a narrower signification, than what is given to it in the ordinary use of speech. For whereas all, or most other languages, both those which are now in vulgar use, and those which are only preserved in books, have two several words for to signify those observable heights which appear above the ground, calling the bigger sort by one name, and the lesser sort by another, the English language useth one and the same word for both, calling hills as well the one as the other, without any other distinction, but that sometimes the word small or great is added. Now because this word so indifferently used would cause some confusion in the matter we treat of, that hath made us restrain it to one of the forts, and to call hills only the lesser sort, called in Latin collis, in French colline, In Dutch heuvel, and in Irish knock. As for the other and bigger sort, whose name in the aforesaid four languages is mons, mountain, berg, slew, we call them mountains: which word mountains, although it be good English, yet in common speech it is seldom


---

p.47



made use of in that sense whereunto we apply it, but only to signify a country wholly consisting of those great hills, especially when the soil thereof is lean and unfruitful.


### Of the Mountains of Ireland, and first of the lower sort.


THE difference betwixt hills and mountains consisting in bigness, is of two sorts, for in the number of mountains are counted not only those which lift up themselves very high into the air, so as they may be seen many miles off, but also those, the which take up the more in length and breadth, what is wanting to them in height, ascending slopingly by degrees. The mountainous parts of Ireland do for the most part consist of this second part of mountains, most of them in one quarter being muchwhat of the same height, so as sometimes one shall ride some hours together, through the mountainous country, without meeting with any one mountain that greatly excelleth in height above the rest the which in particular may be observ'd in the mountainous country of the Fewes, betwixt Dundalk and Ardmagh, in that of Mourne, betwixt the Newry and Dundrum (each of these two being above twelve miles long) in all that space which is betwixt Kells, a wall'd town in the county of Eastmeath, and Kilacolly, alias Bailieborrough, in the county of Cavan, which being ten miles long, is almost nothing else but a continuance of hills of no great bigness, all very fruitful land both pasture and arable. In the county of Westmeath, from Lough Crew to Lough Silline, and beyond it, as far as Ballaneach, where Mr. William Fleming had built a fair house and farm ten years before the late detestable massacre and bloody rebellion of the Irish. These hills are for the most part low and small, yet some of a good height and bigness, the ground lean, in many places very stony, in some rocky, not of any one continual rock, but by piecemeals here and there rising and appearing. Yet are these hills in several places wet and moorish, as well in the rocky as other parts. These hills serve only for pasture of sheep. In the major part of the mountainous country of Wicklow, the which beginning five miles to the south of Dublin, doth extend it self above fifty miles in length, and in several other parts.


It hath been observed in many parts of Ireland, but chiefly in the county of Meath, and further northward that upon the top of the great hills and mountains, not only at the side and foot of them, to this day the ground is uneven as if it had been plowed in former times. The inhabitants do affirm, that their forefathers being much given to tillage, contrary to what they are now, used to turn all to plow land. Others say that it was done for want of arable, because the champain was most everywhere beset and overspread with woods, which by degrees are destroyed by the wars. They say further, that in those times, in places where nothing now is to be seen, but great logs of a vast extent, there were thick woods, which they collect from hence, that now and then trees are digged out there being for the most part some yards long, and some of a very great bigness and length.




---

p.48


### Of the higher sort of Mountains in Ireland.


AS FOR those other mountains, the which with an excessive height rise up towards the skies, they are not very common in lreland, and yet some there be, which although not comparable with the Pyrenaei, lying between France and Spain, with the Alpes, which divide Italy from France and Germany, or with other mountains of the like vast height, nevertheless may justly be counted among the lofty mountains. Of this number are the mountains of Carlingford, betwixt Dundalk and Carlingford, the which in a clear day may easily be seen from the mountains to the south of Dublin, the which are more than forty miles distant from them, the mountains about Lough Swilly, in the north parts of Ulster, the which may be seen many miles off in the sea, the Curlews, that sever the counties of Slego and Rosscommon in Connaught, the twelve mountains in the north quarter of the county of Tipperary in Munster, the which far exceeding the rest of the mountains there, are known by the name of the the twelve hills of Phelim ghe Madona, Knock Patrick, in the west part of the county of Limerick, not far from the bay of Limerick, which mountain can be seen by the ships, which are a huge way from the land yet, the mountains of Brandon hills, in the county of Kerry, to the east of the haven of Smerwick, the which are discovered by the sea-faring men, when they are above fifty miles from the land, in the northwest quarter of the county of Waterford, called Slew Boine; that in the mountainous country of Wicklow, which for its fashion's sake is commonly call'd the Sugar-loaf, and may be seen very many miles off, not only by those that are upon the sea, but even into the land.


### Nature of the Ground in Ireland, and of the fruitful Grounds


NEXT to the foregoing division of Ireland taken from the fashion and outward form of the land, cometh to be considered that which consisteth in the nature of the soil or ground, some parts of the country being fruitful, and others barren.


The fertile soil is in some places a blackish earth, in others clay, and in many parts mixt of both together, as likewise there be sundry places, where the ground is mixt of earth and sand, sand and clay, gravel and clay, or earth, but the chalk ground and red earth, which both are very plentiful and common in many parts of England, are no where to be found in lreland.


These grounds differ among themselves in goodness and fatness, not only according to the different nature of the soil whereof they consist, but also according to the depth of the mold or uppermost good crust, and the nature of the ground which lieth next to it underneath for the best and richest soil, if but half a foot or a foot deep, and if lying upon a stiffy clay or hard stone, is not so fertile, as a leaner soil of greater depth, and lying upon sand or gravel, through which the superfluous moisture may descend, and not standing still, as upon


---

p.49



the clay or stone, make cold the roots of the grass, of corn, and so hurt the whole.


There be indeed some countries in Ireland, where the ground underneath being nothing but stone, and the good mold upon it but very thin, it is nevertheless very fruitful in corn, and bringeth sweet grass in great plenty, so as sheep and other cattle do wonderful well thrive there; which kind of land is very common in the county of Galloway, and in some other counties of Connaught, as also in sundry parts of the other provinces. But the reason thereof is in those parts, because the stone whereon the mold doth lye so thinly, is not free-stone, or any such cold material, but lime stone, which doth so warm the ground, and giveth it so much strength, that what it wants in depth, is thereby largely recompensed.


### Causes hindring the Fruitfulness of the Ground, where the Soil otherwise is not bad


EXCEPT in the case now by us declared, neither corn nor grass will grow kindly, where the ground, though otherwise good, is not deep enough, as also where it hath a bad crust underneath, from whence it cometh, that in many places, where the grass doth grow very thick and high, the same nevertheless is so unfit for the food of beasts, that cows and sheep will hardly touch it (especially if they have been kept in better pastures first) except that by extreme famine they be compelled thereto, and that by reason of the coarsness and sourness of the grass, caused by the standing still of the water, the which through the unfitness of the nether crust, finding not a free passage downwards, maketh cold the good mold, and the crop and grass degenerate from its natural goodness.


For the same reason the land in many parts, where otherwise the soil in it self would be fit enough to produce good wheat or barley, will hardly bear any thing else but oats, or rye, and that none of the best: as in other parts, the fault is in the soil it self, and by the leanness thereof it cometh, that nothing else but coarse grass, and the worst kinds of grains will grow there. And unto these causes may be joined another yet, the overshadowing of high and steep mountains and hills, whereby the sides thereof, and the lands lying close under them, being deprived of the free and seasonable access of the sun beams, and so wanting convenient warmness, cannot afford to the things growing thereon such good and well concocted nourishment, as unto the producing of the best and richest sorts of grains and grass is requisite.


### Ireland a very fruitful country, especially for Grass.


THESE defects are not peculiar to Ireland, but common to other countries, and no ways general in it, but only here and there in distant parts; and where they are, they may be amended by the means fit and usual for that purpose, where of by-and-by we shall speak particularly therefore they cannot hinder,


---

p.50




that Ireland should not justly be counted among the fruitfullest countries of the world. And although Orosius, who preferreth it even before England in this particular (‘Hibernia solis coelique tempore magis utilis Britannia’ are his words) goeth too far, yet fully true is the saying of Stanyhurst, in the preface of this Irish chronicle, ‘Cum Hibernia, coeli salubritate, agrorum fertilitate, ubertate frugum, pastionis magnitudine, armentorum gregibus, conferre paucas, anteferre nullas valeas’ That is, ‘With Ireland for wholsomness of air, fruitfulness of lands, great store of corn, abundance of pastures, and numerousness of cattle, few countries may be compared, none preferred’ as also that of Giraldus, ‘Gleba praepingui uberique frugum proventu faelix est terra, et foecunda frugibus arva, pecore montes’ That is ‘This country is happy in very rich ground, and plentiful increase of grains, the fields being fertile in corn, and the mountains full of cattle.’ But although Ireland almost in every part, where the industry of the husbandman applieth it self thereto, bringeth good corn plentifully, nevertheless hath it a more natural aptness for grass, the which in most places it produceth very good and plentiful of it self, or with little help the which also hath been well observed by Giraldus, who of this matter writeth thus ‘Pascuis tamen quam frugibus, gramine quam grano foecundior est insula’ ‘This island is fruitfuller in grass and pastures, than in corn and grains.’ And Buchanan in the second book of his history of Scotland calleth the pasture ground of Ireland ‘pascua fere totius Europae uberrima’ ‘the fruitfullest pasture ground of most all Europe.’


### More of the Plenty and Goodness of the Irish Pastures


The abundance and greatness of the pastures in Ireland doth appear by the numberless number of all sorts of cattle, especially of kine and sheep, wherewith this country in time of peace doth swarm on all sides, whereof in another place shall be spoken more at large and the goodness of the same is hereby sufficiently witnessed, that all kind of cattle doth thrive here as well in Ireland, and give as good milk, butter, and cheese (with good handling) as in any other country.


It is true, that the Irish kine, sheep, and horses, are of a very small size: but that that doth not come by reason of the nourishment and grass, but through other more hidden causes, may easily be demonstrated by the goodly beasts of the forenamed kind, that are brought thither out of England, the which not only in themselves, but in all their breed, do fully keep their first largeness and goodness, without any the least diminution in any respect, so that before this last bloody rebellion the whole land, in all parts where the English did dwell, or had any thing to do, was filled with as goodly beasts, both cows and sheep, as any in England, Holland, or other the best countries of Europe, the greatest part whereof hath been destroyed by those barbarians, the natural inhabitants of Ireland, who not content to have murthered or expelled their English neighbours (upon whom with an unheard and treacherous cruelty they fell in the midst of a deep peace, without any the least provocation) endeavoured quite to extinguish the memory of them, and of all the civility and good things



---

p.51



by them introduced amongst that wild nation, and consequently in most places they did not only demolish the houses built by the English, the gardens and enclosures made by them, the orchards and hedges by them planted, but destroyed whole droves and stocks at once of English cows and sheep, so as they were not able with all their unsatiable gluttony to devour the tenth part thereof, but let the rest lye rotting and stinking in the fields.


The goodness of the pastures in Ireland doth further appear by this, that both beef and mutton there, as well that of the small Irish, as that of the large English breed, in sweetness and savouriness doth surpass the meat of England it self (as all those, who have tried that must confess) although England in this particular doth surpass almost all the countries of the world.


Nevertheless the saying of Pomponius Mela, that the grass here is so rank and sweet, that the cattle do burst, if they be suffered to feed too long, wherefore they be fain every day to drive them betimes out of the pastures, ‘Juverna adeo luxuriosa herbis, non laetis modo, led etiam dulcibus, ut se exigua parte diei pecora impleant, et nisi pabulo prohibeantur, diutius pasta dissiliant’ the which also hath been repeated by Solinus, ‘Hibernia ita pabulosa, ut pecua ibi, nisi interdum a pascuis arceantur, in periculum agat fatias’ that is, ‘Ireland hath such excellent pastures, that cattle there are brought into danger of their lives by over-feeding, except now and then they be driven out of the fields,’ is a mere fable, no ways agreeable to the truth for all kinds of cattle here, as in other countries, are continually left in the pastures day and night; neither do they through their continual feeding ever burst, or come into any danger of bursting.


Of the Several Manners of manuring and enriching the Ground practised in Ireland
--------------------------------------------------------------------------------


### In some part of Ireland the Ground never needs dunging


TO amend the lean and faulty grounds, to enrich both them and the good ones, and to keep both the one and the other in heart, in preserving them from being exhausted, the dunging of the ground is usual in Ireland as in other countries. It is true, that as approved authors assure us, in the island of Zealand, part of the kingdom of Denmark, the natural richness of the ground is such, and so lasting, as it needeth not the succour of any artificial helps, but is very fruitful, and aye preserveth its fertility, without putting the husbandman to the labour and costs of dunging. That likewise there is some



---

p.52



part in the province of Munster in Ireland, where very credible persons have assured me, of their own knowledge, that the land never needeth any dunging; so as the inhabitants thereof never trouble themselves to keep the dung of their beasts, but from time to time fling it into a river which runneth by them. But this happiness and richness of soil as it is very rare over all the world, so in Ireland too, being confined to very narrow bounds, all the rest of the kingdom is necessitated, for the ends aforesaid, to help and improve their lands by dunging, the which they do several manner of ways.


### Of Sheeps Dung


THE commonest sort of manuring the lands in Ireland, is that which is done with the dung of beasts, especially of cows and oxen, and also of horses mixed with a great quantity of straw, and having lain a long while to rot and incorporate well together, whereof, as of a matter every where known and usual, it is needless to speak further. Only thus much seemeth good to us not to pass over in silence, that if sheep here, as in other countries, were housed and kept up in stables for any longtime together, their excrements would make better dung, than that of any other four-footed creatures. For the land on which sheep have fed for two or three years together, or longer, is so greatly enriched thereby, that when it cometh to be plowed, it bringeth a much fairer and plentifuller crop, than if from the beginning it had been made arable, and dunged after the ordinary manner. Wherefore also great sheep-masters may set their land, where the sheep have been feeding some years together, as dear again by the acre, than what at the first they could have got for it of any body.


Wherefore also it is an usual thing in Ireland, as well as in England, to drive the sheep upon the fallow, and to keep them there until all the herbs which may minister any food unto the sheep be by them consumed, which doth the ground a great deal of good, and giveth it heart to bring afterwards the better increase. And the same also helpeth greatly for to make good grass grow upon the arable, when the same is turned into pasture and meadow, a thing ordinarily used in sundry parts of Ireland, and many times necessary for to keep the lands in heart, for ground being plowed, and the sheep driven thither as soon as any herbs grow upon it, they do not only consume the thistles, and other useless herbs, but cause good grass to grow up in lieu thereof, and that speedily. For in all places where their dung lighteth, of the best and sweetest sorts of grass do grow, and that within the first year, which otherwise would not have come in much longer time, and that nothing near so good generally.


### An useful Observation about Cows Dung


THERE is a notable difference betwixt sheeps dung and that of other cattle, in the goodness and richness it self, so in the particular last mentioned by them. For that of oxen and cows is no ways fit for dunging until it is grown old, and


---

p.53



hath lain a soaking with straw a great while; daily experience shewing in Ireland, as in England and other countries, that in those places of the pastures where the fresh cow dung falleth and remaineth, the grass the next year doth grow ranker and higher than in the rest of the same fields, but so soure and unpleasing, that the beasts will not offer to touch it, so as ordinarily you shall see these tufts of grass standing whole and undiminished in the midst of pastures, that every where else are eaten bare and to the very ground. The which as in part it may be imputed to the quantity of the dung, the which being greater than the earth can well digest, and conveniently unite with it self, cannot be turned into so good and sweet nourishment, so doth it also without doubt come in part through the very nature of the dung, the which of it self, and without a long preparation and alteration, is not so fit to nourish the ground, as that of sheep.


### Of Pigeons Dung


PIGEONS dung also is very convenient for the improvement of the ground; and I know some in Ireland, who having tried that, have found a wonderful deal of good in it, incomparably more than in that of any four-footed beasts, and of sheep themselves. But the pigeon houses no where in Ireland being so big as to afford any considerable quantity, and never having heard of any body there who could dung more than an acre or two with all the pigeons dung which had been gathering the space of a whole twelvemonth, it cannot well be reckoned among the common sorts.


### Of Ashes and Mud


BESIDES the dung of beasts there are usual in Ireland, or were before this rebellion, five or six other sorts for to manure and improve the ground, whereof some are as good as the dung consisting of the excrements of beasts, and others do far surpass it. One of these sorts is ashes, and mud another. As for the first, I have understood of Englishmen, who had lived many years in Ireland, and all that while had exercised husbandry, that they had used to gather all their ashes of their hearths, bake-houses, and brew-houses, being wood ashes, and to lay them of a heap somewhere in the open air, from whence at convenient times they would carry them upon their grounds, and there spread them in the same manner as other dung, but nothing near in so great a quantity; wherein they affirmed to have found as much and more good than in any dung of beasts.


And I know several other English, who living in Ireland, did use to take the scouring of their ditches, together with other mud digged out of the bogs, and having let it lye a good while a rotting in great heaps, did afterwards carry it upon their lands In lieu of dung the which they found very good and useful for that purpose.




---

p.54


These two sorts were never yet brought into common use, but only practised by some few persons, especially that of the ashes, although in other countries they have been known long since; so as Pliny, who lived about fifteen hundred years ago, writeth in the ninth chapter of the seventeenth book of his natural history, that in his time in that part of Italy which is situated between the Alpes and the river Po (comprehending those countries which now are known by the names of Piedmont and Lombardy) ashes were more used and commended for the manuring of the grounds, than the dung of beasts.


As concerning the burning of the heath, and other dry herbs standing upon the ground, for to manure the land with the ashes thereof, that not properly belonging to this place, shall be spoke of more at large in some of the ensuing chapters.


### Of Lime


THE English living in Queen's county in Leinster, having seen that in sundry parts of England and Wales, especially in Pembrookshire, lime was used by the inhabitants for the manuring and enriching of their grounds, begun some years since to practise the same, and found themselves so well thereby, that in a short time the use thereof grew very common amongst them, so as many of them ever after used no other kind of dung.


The manner of it was thus. Having first plowed their fields, they carried the lime on them, and laid it in many small heaps, leaving a convenient distance between, in the same manner as useth to be done with the dung of beasts, and having let them lye for some months, they plowed the land again to convey the lime into the ground.


This made it so rich, that in a great while after nothing else needed to be done to it, but to let the land at a certain revolution of time lye fallow, no other manuring at all being requisite for some years after; and all that while the land was very fruitful, more than it could have been made with any ordinary dung, and very free of all sorts of bad herbs and weeds (especially for the first years) bringing corn with much thinner husks than that growing upon other lands.


They found that the lime carried upon the land hot out of the kiln, did more good in all the forementioned particulars, than when they let it grow cold first. And this they could do very easily, because lime stone is very plentiful in that county, especially in the town of Montrath, where there is a whole hill of that stone, of that bigness, that if all the adjacent country did continually fetch it from thence for the forenamed use, it would for ever hold out sufficiently.


The land thus manured and improved by lime, shewed its fruitfulness not only in the following years, but even in the first, except the lime had been laid on in undue proportion, and in greater quantity than was requisite; for in that case the lime burnt the corn, and the first year's crop was thereby spoiled.


In some places where the land was not cold and moist enough to be able to endure mere lime, they mixed the lime with earth digged out of pits, and let



---

p.55



hat stuff lye a mellowing in great heaps for some months together, and afterwards carried it on the land, and manured that therewith.


### A remarkable History concerning the Excellency of Lime for the enriching of the ground


HOW incredibly the land was enriched by this kind of manuring, may be gathered by the ensuing particular, the whole lordship of Montrath was thirty years ago set by one Mr. Downings (whose it was, and who afterwards sold it to sir Charles Coot) for fifty pounds sterling by the year, and nevertheless after a while the farmers surrendred it unto him, complaining that they could not live by it but were quite impoverished, whereas they who farmed it next after them (being people newly come out of England) and gave an hundred and fifty pounds sterling for it, did not only live very freely upon it, yea grew rich and wealthy, but withal did so far forth improve the land, partly indeed with building, planting, hedging, and the like, but chiefly by this kind of manuring, that at the time when this last horrible rebellion broke forth, the same lordship, if it had been to let out then, might have been let for five hundred pounds sterling a year as it hath been assured me by some, who themselves had been farmers of that land.


### Another History, shewing the Efficacy of Lime in this particular


BEFORE we give over this discourse of lime, we shall add to what hath been said already, that in some other parts of Ireland, where this manuring with lime was not used nor known, the vertue of lime in this particular hath been found out by mere chance. For some persons known to me, who lived but a few miles from Dublin, having understood that the crows wherewith they were much plagued, and who did use to make very great spoil of their grains would not touch the corn wherewith the lime was mixed, did cause unslaked lime to be mingled with water, making it as thin as if it had been for the whitening of walls, and very well besprinkled the corn therewith, before it was carried to the fields to be sown, and that after this manner, the corn lying on a heap, one turned it with both hands, whilst another sprinkled on the foresaid stuff, doing so until the whole heap was thoroughly besprinkled, at other times they mingled dry lime with the corn, and afterwards besprinkled the whole heap with fair water through and through, for the same purpose, and hereby they did not only obtain the aforesaid end, of preserving the corn from the crows, but had thereby a fairer and better crop, than ever before their land had produced.


### Of Sea Sand.


LIME is much used in the province of Munster, as in other parts of Ireland, for to manure the ground withal, where the sea sand likewise is greatly used



---

p.56



to the same end, not only in places lying on the sea side, but even ten, twelve, and fifteen miles into the land, whither it was carried in some places by boats, and in others upon carts, the charges being sufficiently recompensed by the profit coming from it. For they used it for the most part only upon very poor land, consisting of cold clay, and that above half a foot deep which land having been three or four times plowed and harrowed (in the same manner as is usual to be done with fallow) the sand is strowed all over very thinly, a little before the sowing time; the which being done, that land bringeth very good corn of all sorts, not only rye and oats, but even barley and wheat, three years one after another; and having lain fallow the fourth year, for many years after it produceth very clean and sweet grass; whereas formerly, and before it was thus manured, it produced nothing but moss, heath, and short low furze: which herbs are fired upon the ground, and the ground stubbed, before it be plowed the first time.


It is not any peculiar sort of sea sand, nor out of any particular places, which is used for this purpose, but that which every where lyeth on the strands. And this manner of manuring the land with sea sand is very common in the two most westerly shires of England, Cornwal and Devonshire, from whence those, who first practised it in Ireland, seem to have learned it.


### Of Brine or Pickle.


THE goodness of the sea sand consisteth chiefly in its saltness, for which reason pickle it self is very good for this purpose: it being very well known to several English dwelling about the Bann and Colrain, that were farmers of the salmon fishing there, who used every year carefully to keep the foul pickle, coming off the salmon at their repacking, and having poured it among the ordinary dung of cattle and straw they did let them lye a good while a mellowing together. Hereby it was greatly strengthened and enriched, so that the land being dunged with it, did bear much better and richer crops than that which was manured only with common dung without the mixture of it.


### Of the Marl in Ireland, and the manner of marling the land there.


MARL is a certain sort of fat and clayish stuff, being as the grease of the earth, it hath from ancient times been greatly used for manuring of land both in France and England, as may appear out of Pliny in the sixth, seventh, and eighth chapters of his seventeenth Book. The same


---

p.57



also is still very usual in sundry parts of England, being of an incomparable goodness the which caused the English, who, out of some of those places where Marl was used, were come to live in Ireland, to make diligent search for it, and that with good success at last; it having been found out by them within these few years, in several places; first in the King's-county, not far from the Shannon, where being of a grey colour, it is digged out of the bogs; and in the city of Wexford, where the use of it was grown very common before this rebellion, especially in the parts lying near the sea; where it stood them in very good stead, the land of it self being nothing fruitful. For although the ground for the most part is a good black earth, yet the same being but one foot deep, and having underneath a crust of stiff yellow clay of half a foot, is thereby greatly impaired in its own goodness. In this depth of a foot and a half next under the clay, lieth the Marl, the which reacheth so far downwards, that yet no where they are come to the bottom of it. It is of a blew colour, and very fat (which as in other ground, so in this, is chiefly perceived when it it is wet) but brittle and dusty when it is dry.


### The Manner, Charges, and Profit of marling the Ground.


THE marl is laid upon the land in heaps, by some before it is plow'd, by others after, many letting it lye several months ere they plow it again, that the rain may equally divide and mix it, the sun, moon, and air mellow and incorporate it with the earth. One thousand cart-loads of this goeth to one English acre or ground; it being very chargeable, for even to those who dig it out of their own ground, so as they are at no other expences but the hire of the labourers, every acre cometh to stand in three pounds sterling. But these great expences are sufficiently recompensed by the great fruitfulness which it causeth, being such, as may seem incredible; for the marled land, even the very first year, fully quitteth all the cost bestow'd on it. There besides it is sufficient once to marl, whereas the ordinary dunging must be renewed oftentimes.


### The Usage of the marled Land, practised by them of the County of Wexford.


The good usage of the marled land, to keep it in heart for ever after, doth consist, in the opinion and practice of some, in letting it lye fallow at convenient times, but the ordinary manner, commonly practised by the inhabitants of the county of Wexford, and counted the best by them, is, that having sowed it five or six years together, with the richest sorts of corn, to wit, wheat and barley (especially that sort which in some parts of England, and generally in Ireland, is peculiarly called bear, being a much richer grain than the ordinary barley) it being afterwards turned to pasture, whereunto it is very fit, forasmuch as it bringeth very sweet grass in great abundance: for the marl is also used on meadows at the first, with very good success, improving the same most wonderfully.




---

p.58


If the marled land be thus used, and by turns kept under corn, and grass, it keeps its fruitfulness forever; where to the contrary, if year after year it [is] bestowed till the heart be drawn out, it's quite spoiled, so as afterwards it is not possible to bring it again to any passable condition by any kind of dunging, or marling. This would ordinarily be done in the space of ten years; for so long together the marled land may be sowed, and bring every year a rich crop of the best corn.


Nevertheless this is not general, but taketh place only in the worser kind of ground, for where the land of it self is better and richer, there after marling, wheat and other corn may be sow'd, not only for ten years together, but longer, for very credible persons have assured me, that some parts of the county of Wexford having born very good corn for thirteen years together, and afterwards being turned to pasture, it was as good and fertile as other marled grounds that had been under corn but five or six years.


### Of the Marl in Connaught.


THE province of Connaught (by what hath been discover'd) is much more plentiful in marl, than Leinster, as in other counties, so in those of Roscommon, Slego, and Galloway, almost in every part of it. It is there of three several colours, some being white as chalk, other grey, and some black, but none blew, as that in the county of Wexford. It lieth nothing deep under the upper-ground, or surface of the earth, commonly not above half a foot, but its own depth is so great that never any body yet digged to the bottom of it.


The land which they intend to marl in this province, is commonly plowed in the beginning of May, and lying five or six weeks (until it be sufficiently dried and mellowed by the sun and wind) they harrow it, and then having brought the marl upon it, five or six weeks after it is plowed again, and a third time about September. After which third plowing they sow it with wheat or barley, whereof they have a very rich crop the next year.


### Property and Usage of the marled Lands in Connaught.


LAND marled in that manner as we have said, may be sowed ten or twelve years together; the first eight or nine with wheat, and bear, or barley, and the remaining three or four years with oats, afterwards the land is turned to pasture, and having served some years in that kind, it may be marled anew, and made as good for corn as at the first.


For the observation of those of the county of Wexford, that land may not be marled more than once, doth not take place in Connaught, where it is an ordinary thing, having some space of years to make it again. I know some gentlemen who have caused some parcels of land to be marled thrice in the space of twenty years, and have found very good profit by it. But whether this be caused by the difference of the ground and Marl (appearing also hereby, that in Connaught


---

p.59



they scarce lay the fourth part of the quantity of Marl on the ground of what they do in the county of Wexford) or by the carelesness or want or experience of those of that county, I am not yet fully inform'd. But thus much is known as well in Connaught as other parts, that those who sow the marled land until it can bear no more, and be quite out of heart, will find it exceeding difficult, if not altogether impossible ever to amend or improve the same again by any means whatsoever.


Of the Heaths and Moors, or Bogs in Ireland.
--------------------------------------------


### Of the moory, or boggy Heaths.


HAVING spoke of the fruitful lands of Ireland, it followeth that we treat of those which are neither fit for the bringing of corn, or feeding of cattle; some being such for want or good soil, and others thro' superfluous moisture.


Of the first sort are those places where the ground consisting of mere rock, sand, or earth, naturally unfruitful hath no good mold at the top sufficient for corn or grass to root, and to draw convenient nourishment out of it, the ground being bare, or over-grown only with moss, heath, furze, brakes, thorns, rushes, and the like.


The places whose ground is bare, are nothing frequent, nor of any great bigness in Ireland, and rather on the sea side than within the land. But the other are very common throughout the whole kingdom, not only in the mountains (many whereof do for the most part consist of nothing else) but also in the hilly quarters, the plain countries, and in many places of great extent, taking up some miles in length and breadth. Most of these wastes in the plain countries and valleys, as also some on the mountains and hills, are moory and boggy, fit for to dig turf out, to the great commodity of the inhabitants, in places where other fuel is wanting. So that these parts of land, although barren and producing no kind of thing for the food of man or beasts, may not be reckoned in the number of those which are altogether unprofitable, being of good use in the parts far distant from the sea, where they can have no sea coals, and where woods are wanting, nor well live. Some of these dry, or red bogs, as commonly they are called (the first, in comparison of those whereof presently shall be spoken, the other, because the earth in them for the most part is reddish, and overgrown with moss of the same colour) are in some parts of a vast extent,


---

p.60



instance that by the Shannon side, beginning hard by Athlone, and following the course of the river down towards Limerick, which being two or three miles broad in most parts, is said to be upwards of fifty miles in length.


### Of the dry Heaths.


THERE are some dry heaths in Ireland, for the most part on the mountains, and very few in the plain countries, to the contrary of England, where, as well as in Netherland, Germany, and other countries, those heaths on plain ground are very common in sundry parts of the land, and many of them of a great extent, having very many miles in compass; and where any such dry heaths are in Ireland, the land for the most part is not altogether barren, but grassy between and at the bottom of the heath, so as the heath being burnt (a thing much used in Ireland both by the English and Irish) the land bringeth reasonable good and sweet grass, fit for sheep to feed on, and with a little extraordinary labour and costs brought to bear corn.


Others of these heaths are grassy, having the grass growing not all over among the heath, but in spaces by it selfe as upon the heath between the town of Kildare and the Liffy, which is famous over all Ireland by the name of the Currough of Kildare, being a hilly ground, at its highest near the said town, from thence towards the Liffy descending by degrees, about three miles long, and two or three broad, divided into rows, of heath and grass, which being of no great breadth, and many in number, do lye by the side one of another throughout the whole earth, each of those rows extending it self in length from the one end of the Currough to the other, the rows of heath are about a stone cast over in some places, in some more, in others less: but those of grass a good deal narrower than the others, being always alike green and dry, in the winter as well as the summer, and cloathed with short grass, but very sweet and good, very convenient: for sheep to feed on, of the which always in time of peace, a very great number is grazing here, the whole Currough being a common.


### Of the wet Bogs.


THE places barren through superfluous moisture, are bogs called by the Irish Moones, whereof Ireland is full. There is three or four different sorts of them, grassy, watry, muddy, and hassocky, as appeareth more largely by the following description. But the English Irish have given the name of bogs, not only to the wet, of which we are now to treat, but as well to the turf moors of all sorts, not excepting the red bog, which in most places is firm enough to bear a man, or unshod nagge going over it, but is not for any great weight. But we shall in the following chapters speak in order of the four sorts of wet bogs, which above we have mentioned, and afterwards in its due place treat of the turf and red moors, as occasion shall require.




---

p.61


### Of the grassy Bogs


THE grassy bogs are all over covered with grass, looking fair and pleasant, as if they were dry ground and goodly meadows, whereby many, who not knowing the nature of those places, and because of the greenness suspecting no evil, go into them to their great trouble, and many times to the extreme danger of their lives, for the earth being very spungy can bear no weight, but as well men as beasts, as soon as they set foot on it do sink to the ground, some knee deep, others to the waste, and many over head and ears: for all or most bogs in Ireland having underneath a hard and firm gravel are not of an equal depth, which in some is only of two or three feet, in others five, six or more, insomuch that those who fall into the deepest places of these bogs, can hardly escape, but for the most part do perish, being pitifully smothered.


Some of these bogs do so dry up in the summer that they may be passed without danger, the which in particular falleth out in the great mountains in Munster in the county of Kerry, called Slew Logher, upon which all kind of cattle do graze the summer long being every where full of good and sweet grass, knee deep in most places, whereof not the tenth part being eaten (for if all the cattle of that province were driven thither and left all the summer upon the place it would hardly be consumed) the rest is spoiled when the wet weather cometh in, and stayeth the rain water from descending, through which the ground rotteth in that manner, that all winter long it is unpassable for men and beasts.


But the deepest bogs are unpassable in the summer as well as in the winter, yet most of them have firm places, in narrow paths, and in some larger parcels; by the means whereof those, unto whom they are known, can cross them from one side to another, where others who are not used to them do not know in what part to set one step; in which nimble trick, called commonly treading of the bogs, most Irish are very expert, as having been trained up in it from their infancy.


The firm places in passing, or but lightly shaking them, tremble for a great way, which hath given them the name of shaking bogs; and where they are but of a small compass, quagmires.


### Of the watry Bogs, and of the miry Bogs


THE watry bogs are likewise clothed with grass, but the water doth not sink altogether into them, as into the former, but remaineth in part standing on the top (in the same manner as in some of the grassy bogs, and in all the low pastures and meadows of Holland) by reason whereof these bogs are not dangerous; for every one at the first sight may easily discern them from the firm ground.




---

p.62


These two sorts are in many parts found apart, and in others mix'd and interlaced, and likewise parcels both of the one and the other are found up and down in the moory heaths and red bogs.


Both these sorts, as well the watry as the green bogs, yield for the most part very good turf, much better than the red bogs, whereof more shall be spoken hereafter.


The miry bogs do consist of mere mud and mire, with very little or no grass upon them. These are commonly of a very small compass, whereas most part of the other two are of a notable extent, and some of several miles in length and breadth.


### Of the hassocky bogs.


HASSOCKY bogs we call those, whose ground being miry and muddy is covered over with water a foot or two deep, in some places more, in others less; so as one would sooner take them for loughs, were it not that they are very thick overspread with little tufts or islets the which consisting of reeds, rushes, high soure grass, and sometimes with little shrubs, for the most part are very small, and have but a few feet in compass; some of them being of the bigness of a reasonable big chamber. These little islets or tufts being so many in number, and spread over all the bog, there remaineth nothing between them but great plashes of water (in regard whereof these bogs might well be called plashy bogs) in some places wider, in others narrower, so as from the one, men may well step or leap to the other; that which those who are expert in it know how to do very nimble, and so to run from one part of the bog to another; for the roots of the rushes, reeds, and other things growing on those tufts, are so interwoven, that they can easily bear a man who lightly treadeth upon them, altho' they have very little earth, and are wondrous spungy, so as they, when the water being drained, the bog is dried round about, may easily be pluck'd from the ground.


The English inhabiting in Ireland have given these tufts the name of hassocks, and this sort of bogs, hassocky bogs: of which bogs Munster and other provinces are not altogether free, but most of them are found in Leinster, especially in King's and Queen's county, where also the other sorts of bogs are very common; whereas otherwise Connaught is generally fuller of bogs than any of the other provinces.




---

p.63


Original of the Bogs in Ireland, and the Manner of draining them practised there by the English Inhabitants
-----------------------------------------------------------------------------------------------------------


### Of the Original of Bogs in this Country.


VERY few of the wet bogs in Ireland are such by any natural property, or primitive constitution, but through the superfluous moisture that in length of time hath been gathered therein, whether it have its original within the place it self, or become thither from without. The first of these two cases taketh place in the most part of the grassy bogs, which ordinarily are occasion'd by springs; the which arising in great number out of same parcel of ground, and finding no issue, do by degrees soak through, and bring it to that rottenness and spunginess, which nevertheless is not a little encreased through the rain water coming to that of the springs. But the two other sorts, viz. the watry and hassocky bogs, are in some places caused by the rain water only, as in others thro' brooks and rivulets running into them, and in some thro' both together; whereunto many times also cometh the cause of the grassy bogs, to wit, the store of springs within the very ground, and all this in places, where or through the situation of them, and by reason of their even plainness or hollowness, or through some other impediment, the water hath no free passage away, but remaineth within them, and so by degrees turneth them into bogs.


### Retchlessness of the Irish, Cause of most of the Bogs. Of Trees found in Bogs.


So that it may easily be comprehended, that whoso could drain the water, and for the future prevent the gathering thereof, might reduce most of the bogs in Ireland to firm land, and preserve them in that condition. But this hath never been known to the Irish, or if it was, they never went about it, but to the contrary let daily more and more of their good land grow boggy through their carelesness, whereby also most of the bogs at first were caused.


This being otherwise evident enough, may further be confirmed by the whole bodies of trees, which ordinarily are found by the turf diggers very deep in the ground, as well of other trees, as of hazels: likewise they meet sometimes with the very nuts themselves in great quantity, the which looking very fair and 



---

p.64



whole at the outside, as if they came but newly from the tree, have kernel within the same, through the great length of time being consumed and turned into filth.


And it is worthy of observation, that trees, and trunks of trees, are in this manner found not only in the wet bogs, but even in the heathy ones or red bogs, as by name in that by the Shannon side, whereof hath been spoken above, in which bog the turf diggers many times do find whole fir trees deep in the ground; whether it be that those trees, being fallen, are by degrees sunk deeper and deeper (the earth of that bog almost every where being very loose and spungy, as it is in all such bogs) or that the earth in length of time be grown over them.


### Draining of the Bogs practised by the English in Ireland.


BUT as the Irish have been extreme careless in this, so the English, introducers of all good things in Ireland (for which that brutish nation from time to time hath rewarded them with unthankfulness, hatred, and envy, and lately with a horrible and bloody conspiracy, tending to their utter destruction) have set their industry at work for to remedy it, and having considered the nature of the bogs, and how possible it was to reduce many of them unto good land, did some years since begin to go about it all over the land, and that with very good success, so as I know gentlemen, who turn'd into firm land three or four hundred acres of bog, and in case that this detestable rebellion had not come between, in a few years there would scarce have been left one acre of bog, of what was in the lands and possession of the English, except only those places whose situation is altogether repugnant to draining, because that the water either through the hollowness of the place, as in the inclosed vallies and deep dales between the hills and mountains, or through the too great evenness and plainness of the ground, not inclining to any one part more than another, cannot be drawn away at all, and except such parcels as needs must have been kept turf, and red bogs who are very unfit for draining, for the trenches being made, the earth on both sides will sink into them again, and choak them up.


### Profit reap'd by the draining of Bogs.


THIS draining of the bogs as it tended not a little to the general good of the whole land, by amending of the air (whereof we shall have occasion to say more in some other place) and otherwise, so it brought great profit unto the authors, for the land or soil of the bogs being in most places good of it self, and there besides greatly enriched by the lying still and the soaking in of the water for the space of so many years, the same being dried through the draining of the water, is found to be very fit either to have corn sowed upon, or to be turn'd into pastures; making also excellent meadows, so as those, who have tried that, do affirm, that the meadows gain'd out of the bogs might be compared with the very best of their other meadows, yea many times surpassed the same in goodness and this took place chiefly in the grassy bogs or shaking bogs, whose


---

p.65



fruitfulness in this particular, and in the plentiful production of very sweet and deep grass, after the draining of the water, was very wonderful; and all this without any other trouble or costs bestowed upon these meadows, than that they dunged them the first year, to warm them the better and the sooner, and more thoroughly to amend the remainders of that coldness and rawness contracted through that long and constant continuance of the water upon them; after which once dunging, afterwards for a good many years nothing else needed to be done to them.


### The Manner of draining the Bogs.


THIS draining of the bogs was performed in the manner following. On that side of the bog, where the ground was somewhat sloping, they cut a broad deep trench, beginning it in the firm ground, and advancing it unto the entrance of the bog, into which trench the water would sink out of the next parts of the bog in great abundance, and that many times so suddenly, as if a great sluice had been opened, so as the labourers were constrained to run out of it with all speed, lest the force of the water should overwhelm and carry them away. Some part of the bog being by this means grown reasonably dry within a short space of time, opportunity thereby was ministred to advance the trench further into the bog; and so by little and little they went on with it until at last they carry'd it quite across the bog, from the one side to the other: and having done this, they made a great many lesser trenches out of the main one, on both sides of the same; the which bringing the water from all the parts of the bog unto the main trench, did in a little while empty the bog of all its superfluous moisture, and turn it into good and firm ground.


### Observation about the Falling and Settling of the Bogs at their Draining.


THE green or grassy bogs, the which having all their moisture and water inwardly, are thereby wonderfully swelled and puft up, use by means of this draining to fall very much, and to grow a great deal lower, and that not only apparently, so that the ground which before the draining was five or six feet high, cometh at last to be not above two or three feet high, but sometimes also suddenly, and within the space of four and twenty, or eight and forty hours; whereas ordinarily that useth to come to pass in greater length of time; and although the ground by falling in this manner, may seem thereby to have been subject to return to its former boggy condition on the least occasion; nevertheless there was no danger of that, as long as the trenches were kept open, and thereby the passage kept free for the water, which from time to time would from all parts of the drained bog be sinking into them. This water, as at the first draining, so ever after, was by the main trench carry'd unto some brook, river, or lough, according as one or other of them was next at hand, and the situation of the land would give opportunity.




---

p.66


Of the Woods in Ireland.
------------------------


### Woods in Ireland are reckon'd among the barren Lands, and the Reason thereof


Amongst the barren parts of Ireland the woods must also be counted, according to the usual division of the lands of that kingdom, whereby reckoning for fruitful only the meadows, arable grounds, and pastures, they count all the rest for barren, comprehending them under these three general heads, bogs, barren mountains, and woods. Which division as it is in the mouth of all them that have any insight into the matters of that land, and do, or have lived there, so it is further confirmed by a number of writings and monuments, both of ancient times, and late ones, in the which it is very common and familiar, as for instance may appear by those several acts, which since this last rebellion of the Irish have been made by the parliament of England in the behalf of the adventurers who have laid out their mony for the reconquering of the revolted parts of that kingdom. For although the land which the woods do take up, is in it self very good in most places, and apt to bear both corn and grass plentifully (whereof more shall be said by and by) yet as long as the woods remain standing, it is unfit not only to be made either arable or meadow (as in it self is most evident) but even for pasture, by reason of the overmuch moisture, the roots of the trees staying the rainwater, so as it hath not the liberty to pass away readily, and their stems and branches hindering the free access of the wind and sun, whereunto cometh in many parts the ground's own watriness, occasioned by springs there arising, and by its situation apt for the gathering and keeping of water, which maketh them for the most part so muddy and boggy, that cattle cannot conveniently feed in them.


### Woods much diminished in Ireland since the first coining in of the English.


IN ancient times, and as long as the land was in the full possession of the Irish themselves, all Ireland was very full of woods on every side, as evidently appeareth by the writings of Ciraldus Cambrensis, who came into Ireland upon the first conquest, in the company of Henry II. king of England, in the year of our


---

p.67



saviour 1171. But the English having settled themselves in the land, did by degrees greatly diminish the woods in all the places where they were masters, partly to deprive the thieves and rogues, who used to lurk in the woods in great numbers, of their refuge and starting-holes, and partly to gain the greater scope of profitable lands. For the trees being cut down, the roots stubbed up, and the land used and tilled according to exigency, the woods in most part of Ireland may be reduced not only to very good pastures, but also to excellent arable and meadow.


Through these two causes it is come to pass in the space of many years, yea of some ages, that a great part of the woods, which the English found in Ireland at their first arrival there, are quite destroyed, so as nothing at all remaineth of them at this time.


### Diminishing of the Woods during the last peace.


AND even since the subduing of the last great rebellion of the Irish before this, under the conduct of the earl of Tirone (overthrown in the last years of Queen Elizabeth by her viceroy sir Charles Blunt, lord Mountjoy, and afterwards earl of Devonshire) and during this last peace of about forty years (the longest that Ireland ever enjoy'd, both before and since the coming in of the English) the remaining woods have very much been diminished, and in sundry places quite destroyed, partly for the reason last mentioned, and partly for the wood and timber itself, not for the ordinary uses of building and firing (the which ever having been a-foot, are not very considerable in regard of what now we speak of) but to make merchandize of, and for the making of charcoal for the iron-works. As for the first, I have not heard that great timber hath ever been used to be sent out of Ireland in any great quantity, nor in any ordinary way of traffick, but only pipe-staves, and the like, of which good store hath been used to be made, and sent out of the land, even in former times, but never in that vast quantity, nor so constantly as of late years, and during the last peace, wherein it was grown one of the ordinary merchantable commodities of the country, so as a mighty trade was driven in them, and whole ship-loads sent into foreign countries yearly, which as it brought great profit to the proprietaries, so the felling of so many thousands of trees every year as were employed that way, did make a great destruction of the woods in tract of time. As for the charcoal, it is incredible what quantity thereof is consumed by one iron-work in a year; and whereas there was never an iron-work in Ireland before, there hath been a very great number of them erected since the last peace in sundry parts of every province, the which to furnish constantly with charcoals, it was necessary from time to time to fell an infinite number of trees, all the loppings and windfals being not sufficient for it in the least manner.


### Great part of Ireland very bare of Woods at this time.


THROUGH the aforefaid causes Ireland hath been made so bare of woods in many parts, that the inhabitants do not only want wood for firing (being


---

p.68



therefore constrained to make shift with turf, or sea-coal, where they are not too far from the sea) but even timber for building, so as they are necessitated to fetch it a good way off, to their great charges, especially in places where it must be brought by land and in some parts you may travel whole days long without seeing any woods or trees except a few about gentlemens houses; as namely from Dublin, and from places that are some miles further to the south of it, to Tredagh, Dundalk, the Newry, and as far as Dromore; in which whole extent of land, being above threescore miles, one doth not come near any woods worth the speaking of, and in some parts thereof you shall not see so much as one tree in many miles. For the great woods which the maps do represent unto us upon the mountains between Dundalk and the Newry, are quite vanished, there being nothing left of them these many years since, but one only tree, standing close by the highway, at the very top of one of the mountains, so as it may be seen a great way off, and therefore serveth travellers for a mark.


### Many great Woods still left in Ireland.


YET notwithstanding the great destruction of the woods in Ireland, occasioned by the aforesaid causes, there are still sundry great woods remaining, and that not only in the other provinces, but even in Leinster it self. For the county of Wicklow, King's-county, and Queen's-county, all three in that province, are throughout full of woods, some whereof are many miles long and broad. And part of the counties of Wexford and Carlow are likewise greatly furnished with them.


In Ulster there be great forests in the county of Dunnagal, and in the north part of Tyrone, in the country called Glankankin. Also in the county of Fermanagh, along Lough Earn; in the county of Antrim, and in the north part of the county of Down; in the two countries called Killultagh and Kilwarlin, besides several other lesser woods in sundry parts of that province. But the county of Louth, and far the greatest part of the counties of Down, Ardmagh, Monaghan, and Cavan all in the same province of Ulster are almost every where bare, not only of woods, but of all sorts of trees, even in places which in the beginning of this present age, in the war with Tyrone, were encumbred with great and thick forests.


In Munster where the English, especially the earl of Cork, have made great havock of the woods during the last peace, there be still sundry great forests remaining in the counties of Kerry, and of Tipperary, and even in the county of Cork, where the greatest destruction thereof hath been made, some great woods are yet remaining, there being also store of scattered woods both in that county, and all the province over.


Connaught is well stored with trees in most parts, but hath very few forests or great woods, except in the counties of Mayo and Slego.




---

p.69


Of the Mines in Ireland, and in particular of the Iron-mines
------------------------------------------------------------


### All the Mines in Ireland discovered by the New-English


THE Old-English in Ireland, that is, those who are come in from the time of the first conquest, until the beginning of queen Elizabeth's reign, have been so plagued with wars from time to time, one while intestine among themselves, and another while with the Irish, that they could scarce ever find the opportunity of seeking for mines, and searching out the metals hidden in the bowels of the earth. And the Irish themselves, as being one of the most barbarous nations of the whole earth, have at all times been so far from seeking out any, that even in these last years, and since the English have begun to discover some, none of them all, great nor small, at any time hath applied himself to that business, or in the least manner furthered it.


So that all the mines which to this day are found out in Ireland, have been discovered at least as for to make any use of them by the New-English, that is, such as are come in during, and since the reign of queen Elizabeth. Several whereof having begun to give their minds to it during the last peace, have in a few years found out a great many iron-mines in sundry parts of the kingdom, and also some of lead and silver, which greatly confirmeth the opinion of many knowing persons, who hold that the mountains of Ireland are full of metals, and that if the same industry and diligence had been used by the inhabitants of that country in former ages, as there hath been since the beginning of the present, many more mines might have been discovered, not only of the same minerals as have been found out hitherto, but of others also, and perhaps even of gold it self.


### Ground to believe that there are Gold-mines in Ireland.


I believe many will think it very unlikely, that there should be any gold-mines in Ireland, but a credible person hath given me to understand, that one of his acquaintance had several times assured him, that out of a certain rivulet in the county of nether-Tyrone, called Miola (the which rising in the mountains Slew-galen, and passing by the village Maharry, falleth into the northwest corner of Lough Neagh, close by the place where the river Bann


---

p.70



cometh out of it) he had gathered about one dram of pure gold, concluding thereby, that in the aforesaid mountains rich gold mines do lye hidden.


For it is an ordinary thing for rivers, which take their original in gold-bearing mountains, to carry gold mixt with their sand, the which may be confirmed by many instances, and to say nothing of several rivers of that kind, mentioned by Strabo, Pliny, and other old geographers and historians, nor of Pactolus and Hermus in Lydia, and Tagus in Spain, whereof all the old poets are full, it is certain, that in our very times several rivers in Germanie, as the Elbe, Schwarts, Sala, and others, do carry gold, and have it mix'd with their sands, out of the which by the industry of man it is collected.


### Three sorts of Iron-mines in Ireland and first of the first sort, Bog-mine.


BUT to let alone uncertain conjectures, and to content our selves with the mines that are already discovered, we will in order speak of them, and begin with the iron-mines. Of them there are three sorts in Ireland, for in some places the oar of the iron is drawn out of moores and bogs, in others it is hewen out of rocks, and in others it is digged out of mountains of which three sorts the first is called bog-mine, the other rock-mine, and the third with several names white-mine, pin-mine, and shel-mine.


The first sort, as we have said, and as the name it self doth shew, is found in low and boggie places, out of the which it is raised with very little charge, as lying not deep at all, commonly on the superficies of the earth, and about a foot in thickness. This oar is very rich of metal, and that very good and tough, nevertheless in the melting it must be mingled with some of the mine or oar of some of the other sorts for else it is too harsh, and keeping the furnace too hot, it melteth too suddenly, and stoppeth the mouth of the furnace, or, to use the workmens own expression choaketh the furnace. Whilest this oar is new, it is of a yellowish colour, and the substance of it somewhat like unto clay, but if you let it lye any long time in the open air, it groweth not only very dry, as the clay useth to do, but moldereth and dissolveth of it self, andl falleth quite to dust or sand, and that of a blackish or black-brown colour.


### Of the second sort of Iron-mine, called Rock-mine.


THE second sort, that which is taken out of rocks, being a hard and meer stony substance, of a dark and rustie colour, doth not lye scattered in several places, but is a piece of the very rock, of the which it is hewen which rock being covered over with earth, is within equally every where of the same substance; so as the whole rock, and every parcel thereof, is oar of iron. This mine, as well as the former is raised with little trouble, for the iron-rock being full of joints, is with pick-axes easily divided and broken into pieces of what bigness one will, which by reason of the same joints, whereof they are full every where, may easily be broke into other lesser pieces, as that is necessary, before they be put into the furnace.




---

p.71


This mine or oar is not altogether so rich as the bog-mine, and yieldeth very brittle iron, hardly fit for any thing else, but to make plow-shares of it (from whence the name of colt-share iron is given unto it) and therefore is seldom melted alone, but mixed with the first of the third sort.


Of this kind hitherto there hath but two mines been discovered in Ireland, the one in Munster, near the town of Tallow, by the earl of Cork's iron works; the other in Leinster, in King's-county, in a place called Desart land, belonging to one serjeant major Piggot, which rock is of so great a compass, that before this rebellion it furnished divers great iron-works, and could have furnished many more, without any notable diminution, seeing the deepest pits that had been yet made in it, were not above two yards deep. The land, under which this rock lieth, is very good and fruitful, as much as any other land thereabouts, the mold being generally two feet and two and a half, and in many places three feet deep.


### Of the third sort of Iron-mine.


THE third sort of Iron-mine is digged out of the mountains, in several parts of the kingdom, in Ulster, in the county of Fermanagh, upon Lough Earn, in the county of Cavan, in a place called Doubally, in a dry mountain, and in the county of nether-Tyrone, by the side of the rivulet Lishan, not far from Lough Neagh, at the foot of the mountains Slew-galen mentioned by us upon another occasion, in the beginning of this chapter; in Leinster, in King's-county, hard by Mountmelick, and in Queen's-county, two miles from Montrath in Connaught, in Tomound or the county of Clare, six miles from Limerick, in the county of Roscommon, by the side of Lough Allen, and in the county of Leitrim, on the east side of the said lough, where the mountains are so full of this metal, that thereof it hath got in Irish the name of Slew Neren, that is, mountains of Iron and in the province of Munster also in sundry places.


This sort is of a whitish or grey colour, like that of ashes, and one needs not take much pains for to find it out, for the mountains which do contain it within themselves, do commonly shew it of their own accord, so as one may see the veins thereof at the very outside in the sides of the mountains, being not very broad, but of great length, and commonly divers in one place, five or six ridges the one above the other, with ridges of earth between them.


These veins or ridges are vulgarly called pins, from whence the mine hath the name of pin-mine; being also called white-mine, because of its whitish colour, and shell-mine, for the following reason, for this stuff or oar being neither loose or soft as earth or clay, neither firm and hard as stone, is of a middle substance between both, somewhat like unto slate, composed of shells or scales, the which do lye one upon another, and may be separated and taken asunder very easily, without any great force or trouble. This stuff is digged out of the ground in lumps of the bigness of a man's head, bigger, or less, according as the vein affordeth opportunity. Within every one of these lumps, when the



---

p.72



mine is very rich and of the best sort (for all the oar of this kind is not of equal goodness, some yielding more and better iron than other) lieth a small kernel, which hath the name of hony-comb given to it, because it is full of little holes, in the same manner as that substance whereof it borroweth its appellation.


The iron coming of this oar is not brittle, as that of the rock-mine, but tough, and in many places as good as any Spanish iron.


### Iron-works erected by the English.


THE English having discovered these mines, endeavoured to improve the same, and to make profit of them, and consequently several iron-works were erected by them in sundry parts of the land, as namely by the earl of Cork in divers places in Munster; by sir Charles Coot in the counties of Roscommon and Letrim, in Connaught, and in Leinster by Montrath, in Queen's-county, by the earl of Londonderry at Ballonakill, in the said county, by the lord chancellor sir Adam Loftus, viscount of Ely, at Mountmelick, in King's-county, by sir John Dunbar in Fermanagh, in Ulster; and another in the same county, by the side of Lough Earn, by sir Leonard Blenerhasset, in the county of Tomond, in Connaught, by some London merchants, besides some other works in other places, whose first erectors have not come to my knowledge.


In imitation of these have also been erected divers iron-works in sundry parts of the sea coast of Ulster and Munster, by persons, who having no mines upon or near their own lands, had the oar brought unto them by sea out of England, the which they found better cheap than if they had caused it to be fetch'd by land from some of the mines within the land. And all this by English, whose industry herein the Irish have been so far from imitating, as since the beginning of this rebellion they have broke down and quite demolished almost all the forementioned iron-works, as well those of the one as of the other sort.


Of the Iron-works; their Fashion, Charges of erecting and maintaining them, and Profit coming of them. With an exact Description of the Manner of melting the Iron in them
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------


### The Fashion of the Iron-works.


THE fashion of the Iron-works, of whose erection we have spoke in the end of the foregoing chapter, is such as followeth. At the end of a great barn standeth a huge furnace, being of the height of a pike and a half, or more, and four-square in figure, but after the manner of a malt-kiln



---

p.73



that is narrow below, and by degrees growing wider towards the top, so as the compass of the mouth or the top is of many fathoms. This mouth is not covered, but open all over; so that the flame, when the furnace is kindled, rising through the same without any hindrance, may be seen a great way off in the night, and in the midst of the darkness maketh a terrible shew to travellers, who do not know what it is.


These ovens are not kindled with wood, nor with sea-coal, but merely with charcoal, whereof therefore they consume a huge quantity, for the furnace being once kindled, is never suffered to go out, but is continually kept a burning from the one end of the year to the other, and the proportion of the coals to the oar is very great, for the mine would not melt without an exceeding hot fire; the which that it may be the more quick and violent, it is continually blown day and night without ceasing by two vast pair of bellows, the which resting upon main pieces of timber, and with their pipes placed into one of the sides of the furnace, are perpetually kept in action by the means of a great wheel, which being driven about by a little brook or water-course, maketh them rise and fall by turns, so that whilst the one pair of bellows doth swell and fill it self with wind, the other doth blow the same forth into the furnace.


### Of the lesser Iron-works, called Bloomeries; Of the Hammer-works, And of the Casting-works.


THERE is another and lesser sort of iron-works, much different from the former, for instead of a furnace they use a hearth therein, altogether of the fashion of a smith's hearth, whereon the oar being laid in a great heap, it is covered over with abundance of charcoal, the which being kindled, is continually blown by bellows that are moved by wheels and water-courses, in the same manner as in the other works.


These works, commonly called bloomeries, are in use, or were so before this rebellion in sundry places of the north parts of Ulster.


Besides these two sorts of works, where the iron-mine is melted, there is a third sort, where the iron after the first melting is hammer'd out into bars, of which we shall have occasion to speak more in the latter end of this present chapter.


There were also in some parts os Ireland yet another kind of iron-works differing from all the former, where the iron was cast into ordnance, pots, small round furnaces, and other things of which works Mr. Christopher Wandsworth, master of the rolls of Ireland, and in his latter days lord deputy of the same kingdom under the earl of Strafford, then lord lieutenant thereof, had one upon his lands by Idough in the county of Carlow; whereof we cannot give the reader any particulars, because we have not yet been informed thereof.


### Conveniences requisite to the erecting of an Iron-work.


IN the erecting of these works men seek to make them as near to the mine as may be, to get the more profit by them, for the greater the distance is, the


---

p.74



greater are the charges in having the oar brought from the mine to the furnace, especially where all must be carried by land, the which doth fall out so in far the most places.


But many times one is necessitated to make the works a good way further from the mine, than otherwise one would, because of the water courses, the which being of very great consequence in the well settling of a work, and absolutely necessary (the wheels being all moved by water) those places must be made choice of, where one may have the conveniency of water-courses. And besides all this, regard must be had to the nearness of the woods, partly by reason of the timber, a great deal whereof is necessary for the erecting of one of these works, and chiefly for the char-coals sake, of which a vast quantity continually is requisite, as before we have shewed.


### The charges of erecting and maintaining an Iron-work.


IT is to be observed, that although there be wood enough upon ones land, and that not very far from the mine, together with the conveniences of water-courses, so as the water needeth not to be brought from very far off, nevertheless the charge is very great, both of erecting and stocking one of the iron-works, and of maintaining it and keeping it afoot, and that by reason of the great number of workmen and labourers of several sorts, which thereunto is requisite; a list of whose names and offices here followeth. Wood-cutters, who fell the timber; sawyers, to saw the timber, carpenters, smiths, masons, and bellow-makers, to erect the iron-works, with all the appurtenances thereof, and to repair them from time to time; water-leaders, or water-course-keepers, to steer the water-courses, and to look to them constantly; basket-makers, to make baskets for to carry the oar and other materials, boat-men, and boat-wrights to make the boats, and to go in them, diggers, who work in the mine, and dig the same; carriers, who carry the oar from the mine; colliers, who make the char-coal, corders, who bring the char-coal to the work, fillers, whose work it is from time to time to put the mine and the coals into the furnace; keepers of the furnace, who look to the main work, rake out the ashes and cinders, and let out the molten metal at convenient times; finers, who look to the works where the iron is hammered, hammerers, whose work is to see the iron hammered out besides several other labourers, who having no particular task, must help to put their hand to every thing, of all which sorts of men sir Charles Coot the elder, that zealous and famous warriour in this present war against the Irish rebels (wherein having done many memorable exploits, he lost his life in the first year thereof) did continually keep at work some five and twenty or six and twenty hundred, at his iron-works, being three in number. Whereby may easily be gathered the greatness of the expences in erecting and maintaining of iron-works, and for all this the owners thereof did greatly gain thereby, ordinarily no less than forty in the hundred per annum.




---

p.75


### Of the profit of the Iron-works instanced in those of Sir Charles Coot by Mountrath.


To speak somewhat more particularly both of the charges and profits of these iron-works, we shall instance the matter in one of the works of the said sir Charles Coot, namely that which he had in the lordship of Mountrath, in Queens-county. At that work the tun (that is twenty hundred weight) of rock-mine at the furnace head came in all to stand in five shillings six pence sterling, and the tun of white-mine, which he had brought him from a place two miles further off in seven shillings. These two were mixed in that proportion, that to one part of rock-mine were taken two parts of white-mine: for if more of the rock-mine had been taken, the iron would not have been so good, and too brittle; and being thus mixed, they yielded one third part of iron, that is to say, of two tuns of white-mine, and one of rock-mine, being mingled and melted together, they had one tun of good iron, such as is called merchants-iron, being not of the first, but second melting, and hammered out into bars, and consequently fit for all kinds of use.


This iron he sent down the river Oure (by others called the Nure) to Rosse and Waterford in that kind of Irish boats which are called cots in that country, being made of one piece of timber, which kind of ill favoured boats (mentioned also by us above) are very common throughout all Ireland, both for to pass rivers in, and to carry goods from one place to another; and not only upon shallow waters, such as the aforenamed river is in the greatest part of its course, but even upon the great rivers and loughs.


At Waterford the iron was put aboard of ships goring for London, where it was sold for sixteen, otherwhiles for seventeen pounds sterling, and sometimes for seventeen and a half; whereas it did not stand sir Charles Coot in more than betwixt ten and eleven pounds sterling, all charges reckoned, as well of digging, melting, fining, as of carrying, boat-hire, and freight, even the custom also comprehended in it.


### Some other particulars about the same subject, of the profit of the Iron-works.


IN most of the other places did a tun of the iron-mine or oar come to stand in five, five and a half, and six shillings sterling at the furnace head, and it was an ordinary thing, as well where they used white-mine, as where they mixed rock-mine with it, to have a tun of good iron out of three tuns of oar in some places, where the mine was richer, they would have a tun of iron out of only two tuns and a half of oar. Nevertheless few of them gained more or as much as sir Charles Coot, because they had not the same convenience of transportation. And he himself did not gain so much by his iron-works in Connaught, as by that near Mountrath, although the mines there afforded a richer oar, and that the tun thereof did cost him but three shillings at the furnace,



---

p.76



because that Lough-Allen, whereunto the same mines and works are contiguous, gave him the opportunity of carrying the oar by water from the mine unto the work, and that in boats of forty tuns.


The earl of Cork whose iron-works being seated in Munster, afforded unto him very good opportunity of sending his iron out of the land by shipping, did in this particular surpass all others, so as he hath gained great treasures thereby and knowing persons, who have had a particular insight into his affairs, do assure me, that he hath profited above one hundred thousand pounds clear gain by his said iron-works.


### The manner of melting the Iron-oar


THE manner of melting the iron, usual in Ireland, is thus. The furnace is not filled to the top, but some space is left empty, and to put new stuff into it they do not stay until the former be quite consumed, but only until it be some what descended, and then they cast into it some charges or basketfuls of coals, and at the top of them the same quantity of mine: and thus they do from time to time, so as the furnace is in a manner always in one and the same estate; where is to be observed, that in most furnaces they add unto the oar and coals some quantity of iron-cinders, and in others of lime-stone, whereby the melting of the iron is greatly furthered, and the furnace made to work more mildly.


Within the barn, at the bottom of the furnace, stand constantly two men, one of each side, the which with long iron hooks, through holes left for the purpose, do every quarter of an hour draw out the unburnt coals, ashes, and cinders, which cinders are great lumps of a firm substance, but brittle, of a blackish colour, shining, but not transparent, being nothing else but the remainder of the iron-oar, after that the iron which was contained in it, is melted out on't.


The iron it self descendeth to the lowest part of the furnace, called the hearth, the which being filled, (so that, if one stayed longer, the iron would begin to swim over through the aforesaid holes) they unstop the hearth, and open the mouth thereof (or the timpas the arts-men call it) taking away a little door, of fashion like unto that of a baker's oven, wherewith the same was shut up very close. The floor of the barn hath a mold of sand upon it, wherein, before they open the furnace, a furrow is made, of sufficient breadth and depth, thro' the whole length of the barn, from the bottom of the furnace until the barn's door, into which furrow, as soon as the furnace is opened, the molten iron runneth very suddenly and forcibly, being to look on like unto a stream or current of fire. It remaineth a long time hot, but doth presently loose its liquidness and redness, turning into a hard and stiff mass, which masses are called sowes by the workmen.




---

p.77


### Of the different Bigness of the Iron Sowes.


THE masses or sowes of iron are not always of one and the same weight and bigness, but there is them of all sizes, from one hundred weight until thirty hundred which difference doth chiefly depend on the different bigness of the furnace and hearth, and partly on the will and discretion of the workmaster or founder, and according as he either stayeth until the hearth be full, or letteth out the iron sooner, but ordinarily they do not use to cast, or to open the hearth, under less than twelve hours, nor to stay much longer than four and twenty.


And here is to be observed, that even in furnaces of the same bigness, yea in the self same furnaces, the same quantity of iron is not always cast in the same space of time, but that varieth both according to the nature of the oar, and according to the different seasons of the year. For within the same compass of time you shall cast a greater quantity of iron out of a rich mine or oar, than out of a lean one; and in the summer time, when the coals come in dry and fresh, than in the winter.


### Of the refining of the Sow-Iron, and the hammering it into Bars.


THE sowes are with teams of oxen drawn to the hammer-works, where being put into the fire again, they melt them into the finery, the finer turning the melted stuff to and fro, till it come to be a solid body, then he carrieth it under the hammer, where it is hammered out into such flat narrow and thin bars, as are to be seen every where: the hammers being huge big ones, and never ceasing from knocking day nor night, as being kept at work by the means of certain wheels, turned about by water-courses in the same manner as the wheels of the bellows.


By means of this second melting, and of that mighty hammering, the iron is freed from a mighty deal of dross and dregs which it kept sticking to it, thorough its whole substance, in the first melting, and so of impure called sow-iron, becometh to be useful, such as is accustomed to be delivered unto merchants, being therefore called merchants-iron; one tun whereof is usually had out of a tun and a half of sow-iron, but if that be of the best sort, and cast of the best oar, two hundred pounds less of it will yield the aforesaid quantity of a tun of merchants-iron.




---

p.78


Of the Mines of Silver and Lead in Ireland and occasionally 
of the pestiferous Damps and Vapours within the Earth
------------------------------------------------------------------------------------------------------------------


### Of the several Mines of Silver and Lead, and in particular that of Tipperary.


MINES of lead and silver in Ireland have to this day been found out, three in number; one in Ulster, in the county of Antrim, very rich, forasmuch as with every thirty pounds of lead it yieldeth a pound of pure silver; another in Connaught, upon the very harbour-mouth of Slego, in in a little demy-island commonly called Conny-island, and a third in Munster. The first two having been discovered but a few years before this present rebellion, were through several impediments never taken in hand yet, wherefore we shall speak only of the third.


This mine standeth in the county of Tipperary, in the barony of upper-Ormond, in the parish of Kilmore, upon the lands of one John Mac Dermot O'Kennedy, not far from the castle of Downallie, twelve miles from Limerick, and threescore from Dublin. The land where the mine is, is mountainous and barren; but the bottoms, and the lands adjoyning, are very good for pasture, and partly arable; of each whereof the miners had part, to the value of twenty pounds sterling per annum, every one. It was found out not above forty years ago, but understood at the first only as a lead-mine, and accordingly given notice of to Donogh earl of Thomond, then lord president of Munster, who made use of some of the lead for to cover the house which he then was building at Bunrattie. But afterwards it hath been found, that with the lead of this mine there was mixed some silver.


### The manner of digging this Mine, the nature of the Oar, and what proportions of Silver and Lead it yields.


THE veins of this mine did commonly rise within three or four spits of the superficies, and they digged deeper as those veins went, digging open pits very far into the ground, many fathoms deep, yea castle-deep; the pits not being steep, but of that fashion as people might go in and out with wheel-barrows, being the only way used by them for to carry out the mine or oar. The water did seldom much offend them, for when either by the falling of much rain, or by the discovering of some spring or water-source, they found them selves



---

p.79



annoyed by it, they did by conduits carry it away to a brook adjoyning, the mountain being so situate, as that might be done easily.


This mine yields two different sorts of oar; of which the one, and that the most in quantity, is of a reddish colour, hard, and glistering, the other is like a marl, something blewish, and more soft than the red, and this was counted the best, producing most silver, whereas the other, or glistering sort, was barren, and went most away into litteridge or dross.


The oar yielded one with another three pound weight of silver out of each tun, but a great quantity of lead, so as that was counted the best profit to the farmer.


Besides the lead and silver the mine produced also some quicksilver, but not any alom, vitriol, or antimony, that I could hear of.


### Profits of this Mine. It hath been destroyed by the Irish Rebels.


THE silver of this mine was very fine, so as the farmers sold it at Dublin for five shillings two pence sterl. the ounce; as for the lead, that they sold on the place for eleven pounds sterl. the tun, and for twelve pounds at the city of Limerick. The king had the sixth part of the silver for his share, and the tenth part of the lead, the rest remaining to the farmers, whose clear profit was estimated to be worth 2000 sterl. yearly.


All the mills, melting-houses, refining-houses, and other workhouses, stood within one quarter of a mile at the furthest from the place where the mine was digged, every one of them having been very conveniently and sufficiently built and accommodated by the officers and substitutes of sir William Russel, sir Basil Brook, and sir George Hamilton, which three persons successively had this mine in farm from the king, but in the beginning of this present rebellion all this hath been destroyed by the Irish under the conduct of Hugh O'Kennedy, brother of John Mac Dermot O'Kennedy, on whose lands the mine was situated which rebels not content to lay waste the mine, and to demolish all the works thereunto belonging, did accompany this their barbarousness with bloody cruelty against the poor workmen, such as were employ'd about the melting and refining of the oar, and in all offices thereunto belonging the which some of them being English, and the rest Dutch (because the Irish having no skill at all in any of those things, had never been employ'd in this mine otherwise than to dig it, and to do other labours) were all put to the sword by them, except a very few, who by flight escaped their hands.


### This Mine free from deadly Vapours, the which otherwise in Ireland are bred within the Earth, as well as in other Countries, as is instanced in a very remarkable History.


I have not heard that any of the miners hath been stifled in this mine, a thing ordinary enough in other countries the reason whereof I conceive to be, because the work was done in wide and open pits, wherein the like noxious vapours 



---

p.80



can neither be so easily engendred, and when they arise find a free passage into the open air, to the contrary of those close and narrow vaults usual in the most part of other mines.


For else that the earth of Ireland is subject, as well as that of other countries, to breed dangerous damps within her self, is undoubted, as evidently appeared in the year sixteen hundred thirty seven, by this following accident.


A maulter living in the suburbs of Dublin in St. Francis-street caused a well to be digged three yards deep, which yielding but little water, and that not very sweet nor clear, resolved to have it made deeper; and enjoyned a servant of his, to work at it at spare times, which he doing, and having digged a yard and half lower, the water of it begun the 24th of August to bubble up in a strange manner, making great noise; which having continued two days, without any notable increase, hardly coming half-way the knees, he went down again into the well, to dig there according to his custom. But having wrought but a little while, and being taken with a sudden giddiness in his head, and faintness at his heart, made haste to get out, and being revived, returned to fetch away his spade and other instruments, but coming to the bottom he fell into a deadly sown, which being seen by those that were present, one of them went down to help him up; unto whom the same accident happened. All the spectators being greatly astonished, and their tumult having drawn on a great concourse of people, the place where the well was being an open yard, looking into the main street, a certain man, newly come to town, and casually passing by that way, not affrighted by the example of those two, had the courage to go down to fetch the former out, but with as ill success as they themselves. The wonder and amazement being hereby increased among the people, there was nevertheless a butcher (a bold robustuous man) who having drunk somewhat liberally, would notwithstanding these sad accidents go in, which at the first not being suffered, and he continuing in his resolution, was at last permitted on condition that he let a strong cord be tied about his waist to pull him out, if he found himself ill, the which to signify he was to hold up his right hand. But being come to the bottom; and suddenly taken with a deadly faintness, that he had neither time nor power to give the appointed sign, falling from the ladder; and being haled out with all possible speed, found to be in a deep trance, but with perfect signs of life: wherefore being carried to his own house, put into his bed, and care taken of him, it was nevertheless twenty four hours before he came to himself.


The dead bodies being drawn out of the well it was filled with earth by order of the magistrate of the said city.


### Relation of an accident like the former happened at London.


THE like accidents have at several times been seen in other countries, whereof we could alledge many instances, but passing by all other we shall make mention of one lately befaln here at London. Without Aldesgate, there is a little court called carpenters-yard, in the midst of which there stood a pump; the


---

p.81



water whereof not being good for to dress meat, was used by the neighbours only for the washing and cleaning of their houses, and the like. But in length of time being grown so thick and muddy that no use could be made o'nt, it was resolv'd that the well, whereout the pump drew its water, should be made clean, to which purpose the pump being taken down, in the latter end of July anno 1644, a labourer was let down with a cord into the well, being little and narrow, to take out the mud by pails full, who as soon as he came to the bottom presently fell stark dead. Those that had let him down, seeing this, and suspecting nothing else, but that a sudden faintness had overcome him, let down another to see what he ailed, and to bring him out. But he sped no better than the first, which when the people perceived, no more went into the well, until three or four hours after, in which middle space of time a great iron pan or plate, heaped up with burning charcoal, had been let down into the well, and several times as the fire did slacken, renewed, that through the heat thereof that mortiferous vapour might be overcome and dispersed, the which accordingly fell out, so that the person who afterwards went down to fetch away the dead bodies, got no hurt at all. A great covered or vaulted gutter, whereby the ordures of the streets are under ground convey'd into the city ditch, passeth under the yard wherein the said well, (damm'd up since this sad accident) did stand, so as it may be probably believed that that deadly infection of the air within the same well had partly been caused through the nearness of the same sewer.


Of the Freestone, Marble, Flints, Slate, and Sea-coals which are found in Ireland.
----------------------------------------------------------------------------------


### Of the Freestone


HAVING in the precedent chapters treated of the metals and minerals, which are found in Ireland, we shall now go on to speak of several other substances, raised out of the ground there, of a less noble nature, but nevertheless profitable and serving for several good uses.


To begin with Freestone, there is two sorts of it, the one being grey or ash-coloured, and the other blew; which both for the most part lying in the uppermost parts of the ground, covered over with very little earth, are raised with small labour and charge, whereas in most other countries it is as much labour to dig freestone as the metals themselves. The blew freestone is not very abundant, and as little in request, as unfit for great buildings; it lying for the most


---

p.82



part in small unshapely pieces; and when they are bigger, commonly broke in the raising and hewing, partly through the unskilfulness of the workmen there, and chiefly because they are exceeding hard, and cannot well endure the iron. The grey freestone which is found very abundantly in most parts of the land is of a contrary nature; and may easily be cut out into stones of all bigness or fashion, wherefore also this sort hath been used by the English, to all the churches, castles, and edifices, which since the conquest have been builded by them; for the Irish themselves, never had the skill nor industry to erect any considerable holdings of freestone, brick, or other the like materials, their dwellings being very poor and contemptible cottages. True it is, that the English at their first coming found several maritime towns in Ireland with stone walls and houses, the churches also, not only in those, but in many other towns being of the same; but built by strangers, who being come out of the northern parts of Germany, and other neighbouring countries, had settled themselves there, inhabiting several parts of the sea coasts, some ages before the English conquest, which people called themselves Oastmans, or easterlings, all those countries of the which they were come being situated to the east of Ireland.


### Certain evil Properties of the Irish Freestone.


THIS sort of grey freestone in Ireland hath a bad quality, that it draweth the moisture of the air continually to it, and so becometh dank and wet both in and out-side, especially in times of much rain. To mend this inconvenience the English did wainscot those walls with oak or other boards, or line them with a thin crust of brick.


### Of the Marble


BESIDES the freestone, which is almost in every part of the land, there is marble found in many places of several sorts, one is red, streaked with white and other colours, such as with a peculiar name is called Porphyry; other black, very curiously streaked with white, and some all of one colour.


The first two sorts are found but in small quantity, especially the second, but the last is very abundant in some places, but most about Kilkenny, where not only many houses are built of the same, but whole streets are paved with it.


### Description of the Marble Quarry at Kilkenny.


THE quarry out of which they have their marble at Kilkenny, is not above a quarter of a mile distant from the town, and belongeth to no body in particular, lying in common for all the townsmen, who at any time may fetch as much out of it, as seemeth good unto them, without paying any thing for it. It is in fashion like unto quarries of freestone, to wit, a wide open pit, whereout stones and pillars of great thickness and heighth may be digg'd. This marble, whilst it is rude, and as it cometh out of the ground, looketh grayish, but


---

p.83



being polished it getteth a fine blewish colour, drawing somewhat towards the black.


### Of the Flint.


ALTHOUGH flints are not digged from under the ground, yet shall we give them a place next to the freestone and marble, because of the affinity which they have with them. They are found in every part of Ireland in great abundance near the sea side, within the land, upon the hills and mountains, and in the rivers, many of which have not only their banks covered with them, but also the bottom of their channels, and that for great spaces together, which as they are of all sizes and fashions, so of very different colours.


### Of the Slate.


IN sundry parts of Ireland slate is found in great abundance, and that nothing deep within the ground, just in the same manner as the freestone, so as it may be raised with little charge and labour; wherefore at all times it hath been much used by the English inhabitants for the covering of their houses and other buildings. Nevertheless some years since in places near the sea, especially at Dublin, that kind of Holland tiles, which by them are called Pannen begun to be used generally, the merchants causing them to be brought in from thence in great abundance, because in Ireland they had neither convenient stuff to make them of, nor workmen skilful in that business: although the common tiles usual in many parts of England and other countries, were made and used in several places within the land.


Besides these there was another kind of covering in use, both for churches and houses, to wit, a certain sort of wooden tiles, vulgarly called Shingles, the which are tight enough at the first, but do not many years continue so, it being necessary to change them often, which thing properly not appertaining to this chapter, we nevertheless for affinity's sake have thought not amiss here to mention.


Some years ago another kind of slate hath been discovered in Ireland, which for the colour's sake is called black-slate, being of a blackish colour, which is come into great esteem, not so much for the ordinary use of covering houses, for which they are no better than common slate, but because it hath been found by experience, very good and medicinal against several diseases, especially to stay all kind of bleeding, and to hinder that after falls and bruises the blood do not congeal within the body.


### Of the Sea-coal.


THE trees and woods having been so much destroyed in Ireland, as heretofore we have shewed, and consequently wood for firing being very dear in great


---

p.84



part of the land, the inhabitants are necessitated to make use of other fuel, viz. of turf, and of sea-coals. Of the turf we shall speak in the next chapter. As for sea-coals, they are the ordinary firing in Dublin and in other places lying near the sea, where the same in time of peace are brought in out of England, Wales, and Scotland, in great abundance, and therefore reasonable cheap; which is the reason, that the less care hath been taken to find out coal mines in Ireland it self, whereas otherwise it is the opinion of persons knowing in these matters, that if diligent search were made for them, in sundry parts of the land good coal mines would be discovered. This opinion is the more probable, because that already one coal mine hath been found out in Ireland, a few years since, by mere hazard, and without having been sought for. The mine is in the province of Leinster, in the county of Carlow, seven miles from Idof, in the same hill where the iron mine was of Mr Christopher Wandsworth, of whom hath been spoken above. In that iron mine, after that for a great while they had drawn iron oar out of it, and that by degrees they were gone deeper, at last in lieu of oar they met with sea coal, so as ever since all the people dwelling in those parts have used it for their firing, finding it very cheap, for the load of an Irish car, drawn by one garron, did stand them, besides the charges of bringing it, in nine pence only, three pence to the digger, and six pence to the owner.


There be coals enough in this mine for to furnish a whole country, nevertheless there is no use made of them further than among the neighbouring inhabitants; because the mine being situated far from rivers, the transportation is too chargeable by land.


These coals are very heavy, and burn with little flame, but lye like charcoal, and continue so the space of seven or eight hours, casting a very great and violent heat.


In the place where this mine standeth, do lye little smith-coals above the ground, dispersed everywhere in great quantity, from whence the smiths dwelling in the parts round about did use to come and fetch them even before the mine was discovered.


Of the Turf, Lime, and Brick, and the Manner of making those things in Ireland, item, Of the Glass made in Ireland
------------------------------------------------------------------------------------------------------------------


### Of the two sorts of Irish Turf.


Turf being very much used throughout all the land (as we have said before) is of two sorts, according to the difference of the bogs out of the which it is taken. That which is taken out of the dry bogs, or 


---

p.85



red bogs, is light, spongy, of a reddish colour, kindleth easily, and burneth very clear, but doth not last.


The other to the contrary, which is raised out of the green or wet bogs, is heavy, firm, black, doth not burn so soon, nor with so great a flame, but lasteth a great while, and maketh a very hot fire, and leaveth foul yellowish ashes.


It is the observation of women, that the linnen which is dried by a fire made of this last sort of turf, getteth a foul colour, be it never so white washed and bleached, and groweth yellowish in that manner as that it can hardly be got out again.


### The Manner of making the Turf


THE first sort of turf costeth but little pains in the making; for being digged, and having lain some days a drying (first spread out thin and single upon the ground, and afterwards piled up in little heaps) it is brought into the barn.


But black turf cannot be made without more trouble. First they mark out convenient places, for only those are fit for it to which some paths do lead, and which in themselves are not too miry, and too deep, but have a firm and sandy ground underneath, within the space of four or five feet, or thereabouts. Having found out such a place, if it be too watry, they make some trenches, into which the water descending out of that part of the bog wherein they intend to work, may by them be carried to some place fit for to receive it, to the end that the bog being thereby grown somewhat dryer and firmer, may the better bear the labourers without sinking too deep into it. Then they fall to the business, dividing it so among the labourers, that one part of them do dig out the earth, or rather the mud (for all the earth whereof this turf is made, is thin and muddy) and by spades-full cast it on a heap, either by the side of the pit, or somewhere within the same, where others stand, who very well work it, turning it to and fro, and then with their shovels fill it into certain wooden trayes, amongst the English in Ireland peculiarly called Lossels; the which being full, another part of the labourers draw the same, with great cords fastened to them, to some dry place within the bog, or by the side thereof, where having poured out the mud, they go back to fetch more, and so go to and fro all day long. On that dry place where the mud is poured forth, sit certain women upon their knees, who mold the mud, using nothing else to it but their hands, between the which taking a part of it, they press them together in that manner, that their hands meeting above, the turf is fashioned flat and broad beneath, growing narrower towards the top, which being done, the turf is let lye upon the ground the space of a week or more, according as the weather is, and being reasonably well dry'd, it is piled up in little heaps, leaving every where empty spaces between, that the air and the wind passing through them, they may dry the sooner.




---

p.86


### The charges of making Turf


IRELAND is full of bogs, that every man almost hath bog enough upon his own land to make turf for his family and for all his tenants; so that the turf doth cost most men no more than the hire of the labourers who are employed about it. Those that begun early in the year, whilst the labourers had but little employment, gave ordinarily, besides meat and drink, three pence sterling a day to every man, and two pence to every woman, four pence a day being the ordinary price, and when it was at the dearest, five pence. Twenty men made in two or three days as much turf as was suffcient for the whole year's firing of a great family, of which number five men did dig and cast up the mud, five wrought it and filled it into the trays, and ten were busied in drawing the trays to the place where the turf was molded by the women; who went so nimbly to work with it, that only two of them were sufficient to keep twenty men at work.


### Of the Lime, and the manner of making it of Lime-stone.


ALL the lime in Ireland is made not of the shels of all sorts of shel-fish, as in Holland, and some other countries, but only of stone; and the grey freestone, whereof we have spoken in the precedent chapter, is very fit for it, especially when it is not newly come out of the quarry, but taken off old buildings. But a peculiar sort of stone properly called lime-stone, is best for it. This stone is of a grey colour, tending to a dark blew, which being broke, a white dust out of it doth fly abroad, and it is very common throughout all Ireland, but especially in the provinces of Munster and Connaught, lying not deep within the ground, but very near to the surface of it, and in many places above ground.


The manner of burning it into lime, usual over all Ireland, is this; in the side of some little heighth they make a great pit, round or square according as convenience is offered, of that bigness as may hold forty or fifty barrels, and of that fashion that being many feet wide at the top, it doth by degrees grow narrower towards the bottom, in the same manner as the furnaces of the iron-works. The inside of this pit they line round about with a wall built of lime and stone, at whose outside near the bottom a hole or door is left, by which to take out the ashes, and above that an iron-gate is laid, which cometh close to the wall round about: upon this they lay a lay of lime-stone (being first knockt asunder with a great iron hammer, and broke into pieces of the bigness of a fist, or thereabouts) and upon that a lay of wood or turf, or a certain sort of sea-coal, the which being wonderful small, and peculiarly called comb, is hardly used for any other purpose. Upon that they lay another of lime-stone, and so by turns, until the whole kiln be filled, ever observing that the outmost


---

p.87



lay be of wood, turf, or comb, and not of lime-stone; which being done, the kiln is set afire until all be burnt.


### Another manner of burning Lime used in Ireland.


THERE is another manner of burning lime used in Ireland, in kilns built altogether above ground, and incomparably bigger than the other, insomuch as to the quantity of three hundred barrels of lime at once is made in them. In these kilns they burn whole stones without breaking them into pieces as the others, and that only with wood (turf or comb not being fit for it) whereof they consume a huge deal, it being necessary from time to time to put new wood into them, to which end three or four men day and night do stand by the kiln to keep the fire from decaying or slackning.


These (called French-kilns, because the use of them was first received from thence) have ever their walls made of lime-stone, the which in the same manner are turned into lime, so as there remaineth nothing standing of these kilns after that the work is accomplished, and the lime taken away.


Now albeit that in these kilns a very great quantity of Lime is made at a time, nevertheless it hath been found by experience, that they are much more unprofitable than the others, because they consume much more firing in proportion, through the continual renewing of the fire, and require the constant labour of several men all the while they are burning, which commonly is the space of three days and nights. For these reasons was the use of these kilns, which never had been very general in Ireland, more and more left off in these last years, and the others almost only made use of; in the which the lime came to stand them, who burnt it, in no more than four pence the barrel at the most, all manner of expences being reckoned, and but three to them who had the best conveniencies.


### Of the Brick


IN every part of Ireland there is found a kind of clay very fit for to make bricks, and all sorts of potters-ware, although the Irish never had the wit or industry to make use of it for either of these two ends; yea they have ever been so far from making any earthen vessels, that even the use thereof hath been very rare amongst them, and to the most part unknown, not only before the coming in of the English, but also since, yea even until these very last times; although a great number of English potters in several parts of the land had set up their trade, so as all kind of earthen ware was very common, and to be had at very easie rates.


And as for the brick, they have been little used in Ireland even among the English themselves for a great while, but of late years they begun to be very common, as well in the country, as in the cities, especially Dublin, where all the new buildings (the which not only in handsomness, but also in number,


---

p.88



do surpass the old) are all made of brick. But that which is made in Ireland for the most part is not so good, as that of other countries, not so much for any unfitness in the clay it self, as for want of handling and preparing it aright, as may easily be conceived by the following description of the manner they use to make it.


### The manner how they make their Brick in Ireland.


THEY dig a great square pit, taking away all the uppermost earth until they come to a good clay (which commonly lyeth one or two spits deep); this they digg up throughout the whole pit, and having broke it very small with the spade, they do by degrees pour a great deal of water amongst it, working and labouring it together with the spade and their feet, till the whole mass become uniform, firm and tough like stiff dough, the which then in wheel-barrows is carried out of the pit to a place where certain long tables are set up, to each of which tables is allotted one man, one woman, and one boy. The woman taketh up the clay by handfulls, from the heap lying upon the ground, and reacheth it unto the man, who thrusteth it into a little wooden form without bottom, strawing now and then some sand upon the table, that the clay may not stick to it and so having given them their due fashion, the boy doth carry them from thence to a place, where he laveth them all upon the ground, not under any covert, but in the open air. After they have lain some days, and are somewhat dryed, they are piled up in small heaps, twenty or thirty in a heap, making the heaps transparent in the same manner, as we have shewed above of the turf, some days after those little piles are made into greater, which are many feet long, and five or six feet high, but not above two feet, or two and a half broad (making the lays transparent, with some empty space between brick and brick, even so as in the small piles) the which at the top are covered over with straw, laying upon the straw broad green sods, to keep off the rain. Having lain so until they be quite dry, they make great ovens or kilns of them, filling them within the same, strawing betwixt them of that small sort of sea-coal, whereof we have spoken heretofore, called comb or coome, and having covered over the kiln with the same clay, whereof the bricks are made, the thickness of two handbroads or thereabouts, they set it afire with wood underneath, and continue the fire until not only all the bricks piled within the kiln, but all the walls quite through, and at the outside as well as at the inside, be perfectly burnt, and turned into good brick, wherein oftentimes, through the unskilfulness or neglect of those who make and fill these kilns, and of those that govern the fire, there is great loss, and that two manner of ways. For sometimes great part of the bricks is found not to be sufficiently nor uniformly burnt, and on the other side it falleth out oftentimes, that great quantities are reduced into one, being burnt, or half-burnt into great unshapely masses or lumps which are good for nothing.




---

p.89


They do commonly burn in those kilns two or three hundred thousand bricks at a time; the which for the most part, all charges being reckoned, come to stand betwixt six and eight shillings sterling the thousand.


### Of the Glass made in Ireland


WE shall conclude this chapter with the glass, there having been several glass-houses set up by the English in Ireland, none in Dublin or other cities, but all of them in the country, amongst which the principal was that of Birre, a market town, otherwise called Parsons-town, after one sir Lawrence Parsons, who having purchased that lordship, built a goodly house upon it; his son William Parsons having succeeded him in the possession of it; which town is situate in Queens-county, about fifty miles to the south-west of Dublin, upon the borders of the two provinces of Leinster and Munster; from this place Dublin was furnished with all sorts of window and drinking glasses, and such other as commonly are in use. One part of the materials, viz. the sand, they had out of England, the other, to wit the ashes, they made in the place of ashtree, and used no other. The chiefest difficulty was, to get the clay for the pots to melt the materials in, this they had out of the north.


Of the Temperature and Qualities of the Air, and Seasons in Ireland, as for Heat, Cold and Moisture
---------------------------------------------------------------------------------------------------


### Of the Cold weather, and the Frosts.


ALTHOUGH the climate of Ireland is somewhat northerly, the land extending it self from the beginning of the one and fiftieth degree of latitude, until the end of the five and fiftieth, nevertheless is the air there very temperate, and nothing subject to violent colds (not only in Munster, Leinster, and Connaught, but even in the most northern part, to wit the province of Ulster) much less than any other land lying in the same height or latitude, yea than many countries of a much more southerly climate.


True it is, that the cold weather doth commonly begin here somewhat soon, namely in the beginning of October, and sometimes in the middle or latter end of September, continuing ordinarily the space of five or six months, until the midst or latter end of March, and sometimes also good part of April; during which whole space of time all such persons as are chilly and cold of nature, and do sit still much, can hardly be any long while without a fire.




---

p.90


But again on the other side, it is very seldom violently cold there, and freezeth but little. There are commonly three, or four frosts in one winter; but they are very short, seldom lasting longer than three or four days together, and withall at their very worst nothing near so violent as in most other countries; so that some all winter long hardly come near a fire once in a day, and that not only in the ordinary cold weather, but even whilst it is a freezing.


Yea many times the cold is so slack even in the midst of the winter-months, that by walking only, or doing some other moderate exercise, you shall find your self as warm, and the air as sweet and pleasant, as if it were in the month of May.


There hath been some winters, wherein it hath frozen ten or twelve days together, so as the Liffie, and other the like rivers were quite frozen, and might be gone upon by men and beasts: but those are altogether extraordinary, and do come very seldom, hardly once in the space of ten or twelve years.


But how mild they ordinarily be, and how little subject to excessive cold, may appear hereby, that all kind of beasts and cattle, as cows, horses, and sheep, do there all winter long remain abroad, and do feed in the fields, where they are left in the night-time as well as in the day, and that many herbs, which in England and Netherland do dye every winter, here continue all the year long.


### Of the warm Weather


AND as the cold in winter is very moderate and tolerable, so is also the heat in summer; the which is seldom so great, even in the hottest times of the year, as to be greatly troublesome. And it falleth out oft enough in the very summer-months, that the weather is more inclinable to cold than to heat, so as one may very well endure to come near a good fire. And this cometh to pass only during the wet weather, for else, and whilst it is fair, it is very warm all summer long, albeit seldom over-hot: and so it is many times also even on the rainy days, whereas for the most part it is very cool in them, and the heat much less than the season doth require.


### Of the Rain and wet Weather


THE rain is very ordinary in Ireland, and it raineth there very much all the year long, in the summer as well as in the winter. Commonly in the spring of the year it is very fair weather, with clear sun-shine from morning till night, for the space of five or six weeks together, with very little or no interruption; which fair weather beginneth commonly in the month of March, some years in the beginning, other years in the midst, and sometimes in the latter end of it. But the same being once past, it raineth atterwards very much all the summer long, so as it is a rare thing to see a whole week pass without it; and many summers it is never dry weather two or three days together. Which inconstancy and wetness of the weather is not only troublesome to men, but also


---

p.91



hurtful to all things growing out of the ground for mans behoof. For the heat never being very great, and there besides often interrupted by the intervention of the foul weather, hath neither time nor strength enough to ripen them so well and so soon, as otherwise it would, whereby it cometh to pass, that as well the fruits of trees, as the corn and grass, here commonly much later do come to perfection, than in the most part of other neighbouring countries. And as the ripeness of the fruits and other increase of the earth is greatly retarded by the abundance of unseasonable rain, so it doth also fall out oftentimes, that the same being come to ripeness, it is difficult to get them in, by reason of the exceeding store of rain which doth come down during the hay-time and the harvest. Wherefore it behoveth one here to be wonderful diligent, and not to lose any part of the fair weather. For else one would run great hazard to sustain great losses, and to have all spoiled. But those that are vigilant and careful, and that lose no occasion at all, do commonly in the end get in their increase well enough, notwithstanding all those great hinderances, so that there be as few years of dearth in Ireland, as in any other country of christendom; and most years there is not only corn enough got for the sustenance of the inhabitants, but a great deal over and above, for the sending out of great quantities of grains into other countries.


### Of the fair weather in the latter end of Autumn. In the foul weather the nights are often fair.


IN the latter end of autumn weather is commonly fair again for some weeks together, in the same manner as in the spring, but not so long; which as it doth serve for to dry up, and to get in the corn and hay, which till then hath remained in the fields, the too much wet having hindered it from being brought away sooner; so it giveth the opportunity of plowing the ground, and sowing the winter-corn, the which otherwise would very hardly be done. For that season being once past, you have very little dry weather the rest of the autumn, and during all winter. And although it doth seldom rain continually for many days together, yet is the wetness very great, and few weeks do pass, wherein are not two or three rainy days. And it is to be observed, that ordinarily it raineth in Ireland much more by day than by night, and that many times when it doth rain two or three days together, the nights between are very clear and fair; the which also many times falleth out in other foul weather, and when all day long the skie is overcast with clouds and mists.


### Some dry Summers in Ireland, but hardly ever any too dry.


BUT although it is ordinarily thus in Ireland, yet the same inconstancy and variableness of years and seasons, which is observed in most other countries, doth also here occur, and that more in regard of the summers and dry weather, than of the winters and cold. For it is marvellous seldom to have there a hard winter and long frost; but summers have been which were full of very dry, and


---

p.92



fair and pleasant weather. But as winters cruelly cold, so likewise over-dry summers do in this island hardly come once in an age; and it is a common saying in Ireland, that the very dryest summers there never hurt the land. For although the corn and grass upon the high and dry grounds may get harm, nevertheless the country in general gets more good than hurt by it. And when any dearths fall out to be in Ireland, they are not caused through immoderate heat and drought, as in most other countries, but through too much wet, as excessive rain.


### Amendment of the wet Air in Ireland how to be expected.


So that the Irish air is greatly defectuous in this part, and too much subject to wet and rainy weather; wherein if it were of somewhat a better temperature, and as free from too much wet, as it is from excessive cold, it would be one of the sweetest and pleasantest in the whole world, and very few countries could be named, that might be compared with Ireland for agreeable temperateness. And although it is unlikely, that any revolution of times will produce any considerable alteration in this (the which indeed in some other countries hath caused wonderful changes) because that those who many ages ago have written of this island, do witness the self same things of it in this particular, as we do find in our time: there is nevertheless great probability that this defect may in part be amended by the industry of men, if the country being once inhabited throughout by a civil nation, care were taken every where to diminish and take away the superfluous and excessive wetness of the ground, in all the watery and boggy places, whereby this too great moistness of the air is greatly increased, and partly also occasion'd.


This opinion is not grounded upon some uncertain speculation, but upon assured experience; for several knowing and credible persons have affirmed to me, that already some years since good beginnings have been seen of it, and that in some parts of the land well inhabited with English, and where great extents of bogs have been drained and reduced to dry land, it hath been found by the observation of some years one after another, that they have had a dryer air, and much less troubled with rain, than in former times.


Herewith agreeth what we read in that famous writer Pliny, in the fourth chapter of the seventeenth book of his natural history, concerning that part of Macedonie, wherein the city Philippi was seated, where the air formerly having been very rainy, was greatly amended by the altering the wetness of the ground: His words are these, ‘Circa Philippos cultura siccata regio, mutavit coeli habitum:’ that is word for word, ‘the country about Philippi being dryed up through tillage, hath altered the quality of the air.’




---

p.93


Of the Dew, Mist, Snow, Hail, Hoar-frost, Thunder and Lightning, Earth-quake and Winds
--------------------------------------------------------------------------------------


### Of the Dew


THE naturalists and geographers do assure us, that it deweth exceedingly in the hot and dry countries, and that the less it useth to rain in a country, the dew doth fall there the more abundantly, whereby it should seem to follow, that in the wet climate it deweth very little, and consequently that in Ireland, where it raineth so very much, the dew must be very scanty. But there is as much dew there, as in other countries that are a great deal hotter and dryer. Only thus much experience doth shew in Ireland (and it may be as well in other countries, whereof I have not yet informed my self) that when it is towards any great rain, little or no dew doth fall, so as in those times going forth early in the morning into the green fields, you will find them altogether dry, and that even in that season, wherein the dew in Ireland, as in other neighbouring countries, useth to fall more abundantly, than in any other time of the year, to wit in the months of May and June: this is a certain sign to the inhabitants, that great rain is to fall suddenly, and commonly after such a dry and dewless night it useth to rain two or three days together. But the preceding rain doth not hinder the dew in that manner, as that which is imminent, and it is found ordinarily, that in a clear night following a rainy day (the which is very ordinary, as we have said in the preceding chapter) the dew cometh down as liberally as if it had not rained the day before.


### Of May-dew, and the manner of gathering and preserving it.


THE English women, and gentlewomen in Ireland, as in England, did use in the beginning of the summer to gather good store of dew, to keep it by them all the year after for several good uses both of physick and otherwise, wherein by experience they have learnt it to be very available. Their manner of collecting and keeping it was this. In the month of May especially, and also in part of the month of June, they would go forth betimes in the morning, and before sun-rising, into a green field, and there either with their hands



---

p.94



strike off the dew from the tops of the herbs into a dish, or else throwing clean linnen cloaths upon the ground, take off the dew from the herbs into them and afterwards wring it out into dishes, and thus they continue their work until they have got a sufficient quantity of dew according to their intentions. That which is gotten from the grass will serve, but they chuse rather to have it from the green corn, especially wheat, if they can have the conveniency to do so, as being persuaded that this dew hath more vertues, and is better for all purposes, than that which hath been collected from the grass or other herbs. The dew thus gathered they put into a glass bottle, and so set it in a place where it may have the warm sun-shine all day long, keeping it there all the summer; after some days rest some dregs and dirt will settle to the bottom, the which when they perceive, they pour off all the clear dew into another vessel, and fling away those setlings. This they do often, because the dew doth not purge it self perfectly in a few days, but by degrees, so as new dregs (severed from the purer parts by the working of the dew, helped on by the sun-beams) do settle again; of the which as often as those good women see any notable quantity, they still pour off the clear dew from them doing thus all summer long, until it be clear to the bottom.


The dew thus thoroughly purified looketh whitish, and keepeth good for a year or two after.


### Of the Mists and Fogs.


WE have shewed how much Ireland is subject to rain, and so it is likewise to dark weather, and overcasting of the air even when it raineth not, which continueth sometimes many days together, especially in winter time.


But as for the fogs and mists, Ireland is no more troubled with them than other regions, especially in the plain country, for in the mountains they are much more frequent, so that oftentimes they are covered with them for a great way the space of some hours together, when at the same time there is none in the neighbouring plain country; and in the high mountains it cometh many times to pass that in a fair day the top thereof for a long time together is covered over with a thick mist, when not only the adjacent country, but even the lower part of those mountains do enjoy a 
clear sun-shine. And sometimes it befalleth the tops as well as the lower parts being free from them, the middle parts are quite covered therewith, as my brother in his travels hath many times observed in several parts, especially upon those high mountains between Dundalk and Carlingford, as well in the midst of the summer, as at other times of the year.


And in many places it is found by experience, that the like fog upon the tops of the mountains is a fore-runner of rain in the next country, whereof all those who have lived any time at Dublin, may have good knowledge. For seldom a mist appeareth upon the top of the Wicklow mountains, situated some five or six miles to the south of Dublin, or of the head of Hoath, without being followed with rain at Dublin and the adjacent parts within 24 hours wherein


---

p.95



is observable, that a fog quite covering those mountains all over is not so sure a sign of rain, as when it is only upon the top, and that those general mists upon the mountains are often seen without any following rain, the which very seldom or never happeneth in the others.


There be two sorts of mists or fogs in Ireland, the one is uniform and constant, quite filling the air of all sides, whereby all manner of prospect is taken away, and continuing after the same fashion, until it vanish by degrees, either ascending up into the air, or falling to the ground, whereof here, as in other countries, the first is commonly followed with rain, and the second with fair weather.


In the other sort are great parcels or flakes of foggy vapours scattered up and down the air, with clear spaces betwixt, the which flakes do not keep one place, but fly to and fro, according as they are driven by the wind, and that sometimes very swiftly, this kind of fog doth arise not only upon the seaside, but also within the land, and upon the mountains oftentimes turning into a general mist.


### Of the Snow, Hail, and Hoar-frost.


FOR the most part there falleth no great store of snow in Ireland, and some years none at all, especially in the plain countries. In the mountains there is commonly greater plenty of snow, than in other parts, so that all kind of cattle, do all winter long remain there abroad, being seldom troubled with very great frost or snow, and do feed in the fields night and day, as we have related more amply above; yet it hath happened that in a winter, one of many, abundance of snow hath faln, instance that of the year 1635, where about the latter end of January and the beginning of February great store of snow did fall to the great damage of the cattle, chiefly in the northern parts (where it did snow most exceedingly) so as the people were put to hard shifts to bring their cattle in safety to their folds and other covered places. One history among the rest by reason of the strangeness of it, I think will not be improper to relate as it hath been asserted to me by very credible persons: A gentleman living about Ballaneah in the county of Cavan, took great pains to save his sheep, yet missed eleven of them, some days after being come forth to course, this man saw from afar off upon a hill, in a hollow place of a rock, part of it being covered with the top hanging over it, something alive and stirring, they thought it had been a hare or a fox, but coming near they found it was the lost sheep, the which had near eaten away all the wool from one anothers back (being destitute of all other food, all round about being covered with deep snow) and which is more wonderful one of them being dead, the rest did eat her flesh, leaving nothing but the bare bones.


It doth also longer continue there, so as it is an ordinary thing in those by Dublin, and all other high mountains throughout the land, to see the snow lying upon the tops of them many days, yea weeks, after that in the nether parts and plain country it is thawed and quite vanished.




---

p.96


It haileth there but seldom, and in thin short showers, the hail-stones also being very little.


As for the hoar-frost, that is as common here as in other countries, and that not only in the coldest months, and during the frost, but even in the spring: so as commonly during all the fair weather of that season, of some weeks together, whereof we have spoke heretofore, every morning all the green herbs of the gardens and fields are quite covered over with it.


### Of the Thunder, Lightning, and earthquakes.


IRELAND is as little subject to thunder and lightning, as any other country in the world, for it is a common thing, to see whole years pass without them, and in those years, wherein any are, one shall seldom have them above once or twice in a summer, and that with so weak noise of the thunder, and so feeble a shining of the lightning, that even the most fearful persons are hardly frightned at all thereby, much less any harm done to men or beasts.


From earthquakes this island is not altogether exempt, but withal they are so seldom, that they hardly come once in an age and it is so long ago since the last of all was, that it is as much as the most aged persons now alive can even remember.


### Of the Winds.


WITH winds it is in this country almost as with rain, Ireland not only having its share in them, as other countries, but being very much subject to them, more than most other parts of the world. For the winds blow very much at all times of the year, especially in the winter months, when also there are many storms, which sometimes do continue several days together.


And it is worth the observation, that not only storm-winds, but others also, do in Ireland much seldomer blow out of the east, than out of the west, especially in the winter; so that commonly there is no need of a wind to be wafted over into England, where to the contrary, those, who out of England will come over into Ireland, very ordinarily are constrained to wait two or three weeks, and sometimes five or six weeks, yea it hath faln out so more than once, that in two whole months, and longer, there hath not been so much east wind, as to carry ships out of England into Ireland, notable instances whereof the history of the first conquest of Ireland, and that of the lord Mountjoy, subduer of Tyrone's rebellion, doth afford.


But in the summer time, and chiefly in the spring, and in the months March, April, and May, one is not so much subject to that incommodity, as in the other times of the year.


And as the west winds are much more common in Ireland, especially upon this coast lying over against Great-Britain, than the east, so likewise the south winds are much more ordinary there, than the north, which two winds there


---

p.97



do seldom blow alone, but for the most part do accompany one of the two other, especially the north wind, the which also doth oftner join it self with the east than with the west wind.


Of the Healthfulness of Ireland, and what Sicknesses it is free from, and subject unto
--------------------------------------------------------------------------------------


### Many old and healthful People in Ireland.


ALTHO' Ireland is obnoxious to excessive wetness, nevertheless it is very wholsome for the habitation of men, as clearly doth appear by that there are as few sickly persons, and as many people live to a great age, as in any of the neighbouring countries for both men and women, setting those aside who through idleness and intemperance do shorten their days, attain here for the most part to a fair age, very many living to be very old, and so pass not only the age of fourscore, but of fourscore and ten; and several there are found at all times, who do very near reach an hundred years, some out-living and passing them. And the most part of those aged persons are in very good disposition, enjoying not only their health, but also the use of their limbs, senses, and understanding, even to their utmost years. Among the women there are several found, who do retain not only their customary purgations, but even their fruitfulness, above the age of fifty years, and some until that of sixty. My brother hath known some, who being above threescore years old, have not only conceived, and brought forth children, but nursed them, and brought them up with their own milk, being wonderful rare and almost unheard of in other countries.


### Ireland free from several Diseases.


IRELAND's healthfulness doth further appear by this particular, that several diseases, very common in other countries, are here very rare, and partly altogether unknown. For the scurvy, an evil so general in all other northerly countries confining upon the sea, is until this day utterly unknown in Ireland. So is the quartan ague, the which is ordinary in England, and in several parts of it doth very much reign at all times.


As for the tertian ague, it was heretofore as little known in Ireland as the quartan: but some years since, I know not through what secret change, it hath


---

p.98




found access into this island, so that at this time some are taken with it, but nothing near so ordinarily as in other countries.


The plague, which so often and so cruelly infecteth England, to say nothing of remoter countries, is wonderfully rare in Ireland, and hardly seen once in an age.


### The Immunity from certain Diseases consisteth in the Air, not in the Bodies of the People


IT is observable concerning the forementioned particular, that this privilege, of being free from several diseases, doth not consist in any peculiar quality of the bodies of men, but proceedeth from some hidden property of the land and the air it self. This is made manifest two manner of ways, first, in that strangers coming into Ireland do partake of this same exemption, and as long as they continue there, are as free of those evils, from which that climate is exempt, as the Irish themselves. Secondly, in that the natives, born and brought up in Ireland, coming into other countries, are found to be subject unto those diseases as well as other people, and I have known several of them, who being come hither into England, have fallen into the quartan ague, and have as long and as badly been troubled with it, as ordinarily any Englishman useth to be.


And credible persons have affirmed unto me the same of Scotland, namely that the quartan ague never having been seen there, the Scotsmen nevertheless in other countries are as obnoxious to it, as people of any other nation.


### The most part of all kind of Diseases are found in Ireland as in other Countries.


TRUE it is, notwithstanding that privilege of being exempt from certain evils, that the most part of diseases and infirmities, whereunto man's body is subject in other countries, are also found in Ireland, as well outward as inward; and in the number of the inward not only the suddain ones, and those that in a few days or weeks come to an end, being called Morbi acuti by the physicians, as namely feavers, casting of blood, apoplexies, and others of that nature; but also those of long continuance, as the falling-sickness, the palsy, all sorts of gout, coughs, the consumption of the lungs, the stone of the kidnies and of the bladder, the cholick, the jaundice, the dropsy, the grief of the spleen, and several sorts of loosenesses, with all which evils it is here as in other countries, some of them being very common here, and others happening but seldom, and in few persons: the more particular relation whereof we will leave for the books of physick, and for those observations, which perhaps my brother some time or other will publish, of what he hath found concerning these matters, in an ample and flourishing practice of eight years, which he hath lived in Dublin.




---

p.99


Of the Diseases reigning in Ireland, and whereunto that Country is particularly subject.
----------------------------------------------------------------------------------------


### Of the Irish Agues


As Ireland is subject to most diseases in common with other countries, so there are some, whereunto it is peculiarly obnoxious, being at all times so rife there, that they may justly be reputed for Ireland's Endemii morbi or reigning diseases, as indeed they are generally reputed for such.


Of this number is a certain sort of malignant feavers, vulgarly in Ireland called Irish agues, because that at all times they are so common in Ireland, as well among the inhabitants and the natives, as among those who are newly come thither from other countries. This feaver commonly accompanied with a great pain in the head and in all the bones, great weakness, drought, loss of all manner of appetite, and want of sleep, and for the most part idleness or raving, and restlesness or tossings, but no very great nor constant heat, is hard to be cured, for those that understand the disease, and seek to overcome it, do it not by purging, which cannot be used at any time without great and present danger, for the fermentation of the humours which causeth the disease, is hereby mightily encreased, and the patient weakned, and hardly with bleeding, which seldom is used with success otherwise than in the very beginning; but with strengthning medicines and good cordials, in which case, and if all necessary prescriptions be well observed, very few persons do lose their lives; except when some extraordinary and pestilent malignity cometh to it, as it befalleth in some years, with so great violence, that notwithstanding all good helps, some are thereby carried to their graves; the same doth ordinarily come to pass, that it proveth deadly, is the sick do sell into unskilful hands, or neglect all help, or do not observe good directions; in which cases many do perish, and others, who come off with their lives through robustuousness of nature, or hidden causes, are forced to keep their beds a long time in extreme weakness, being a great while before they can recover their perfect health and strength.




---

p.100


### Of the Looseness.


THE looseness doth also greatly reign in Ireland, as well among those of the country as among the strangers, wherefore the English inhabitants have given it the name of the country-disease. Many are a great while troubled with it, and yet get no other harm and those that betimes do make use of good medicines, are without any great difficulty cured of it. But they that let the looseness take its course, do commonly after some days get the bleeding with it, whereby the disease doth not only grow much more troublesome and painful, but a great deal harder to be cured, and at last it useth to turn to the bloody flux, the which in some persons, having lasted a great while, leaveth them of it self; but in far the greatest number is very dangerous, and killeth the most part of the sick, except they be carefully assisted with good remedies.


That this disease, as also the other, viz. the malignant feavers, are so rife in Ireland, doth partly come through the peculiar disposition and excessive wetness of the air; but partly also through the errors which people do commit in eating and drinking, and other particulars: as manifestly doth appear by that a very great number, not only of the natives, but also of the strangers coming thither, who take careful heed to themselves in abstaining from hurtful things, never are troubled with either of these infirmities.


### Of the Rickets.


AMONG the reigning diseases of Ireland the rickets also may with good reason be reckon'd, a disease peculiar to young children, and so well known to every body in England, as it is needless to give any description of it, and yet to this day never any physician, either English or of any other nation, made any the least mention of it, no not in those works which are expresly written of all manner of diseases and accidents of little children.


In Ireland this disease is wonderful rife now, but it hath nothing near been so long known there as in England, either through the unskilfulness or neglect of the physicians (the most part whereof in both kingdoms to this day are ignorant not only of the manner how to cure it, but even of the nature and property thereof) or that really it is new there, and never before having been in Ireland, hath got footing in it only within these few years, through some strange revolution or constellation or God's immediate sending, which kind of changes several times have befaln in divers countries, and in Ireland it self we have already shown some such matter in another sickness, namely the tertian ague.


This evil being altogether incurable, when it is gone too far, is hard enough to be cured even in the beginning, except it be very carefully look'd unto, and use made of the best remedies; nevertheless this grief, as well as most others, hath its peculiar medicines, the which being applied betimes, and with convenient care, do with God's blessing for the most part produce the effect desired.




---

p.101


### Of the Leprosy


THE rickets are of late very rife in Ireland, where few years ago unknown; so on the contrary it hath been almost quite freed from another disease, one of the very worst and miserablest in the world, namely the leprosy, which in former times used to be very common there, especially in the province of Munster; the which therefore was filled with hospitals, expresly built for to receive and keep the leprous persons. But many years since Ireland hath been almost quite freed from this horrible and loathsome disease, and as few leprous persons are now found there, as in any other country in the world; so that the hospitals erected for their use, having stood empty a long time, at length are quite decayed and come to nothing. The cause of this change is not so obscure nor unknown, as it is in most other changes of that nature. For that this sickness was so general in Ireland, did not come by any peculiar defect in the land or the air, but merely through the fault and foul gluttony of the inhabitants, in the successive devouring of unwholsome salmons. The common report in Ireland is, that boiled salmons eaten hot out of the kettle in great quantity, bring this disease, and used to be the cause why it was so common and some famous authors have not stuck to relate as much for a truth. But that is a fable, and salmons have not that evil quality, which way soever they be eaten and prepared, but when they are out of season, which is in the latter end of the year, after they have cast their spawn upon which they do not only grow very weak and flaggy, but so unwholsome, that over their whole body they break out in very filthy spots, just like a scald man's head, so as it would loath any man to see them, nevertheless the Irish, a nation extremly barbarous in all the parts of their life, did use to take them in that very season, as well as at any other time of the year, and to eat them in very great abundance, as easily they might, every river and rivulet in most parts being very full of them, and by that means that horrible disease came to be so common amongst them. But the English having once gotten the command of the whole country into their hands, made very severe laws against the taking of salmons in that unwholsome season, and saw them carefully observed, whereby hindring those barbarians against their will to feed on that poisonous meat, they were the cause that that woful sickness, which used so mightily to reign amongst them, hath in time been almost quite abolished: which great benefit, with so many others, that hateful people hath rewarded with seeking utterly to exterminate their benefactors.


### Of the Leaguer Sicknesses.


IN the English armies, which since this bloody rebellion went over into Ireland to fight against that murdering nation, were not only the looseness and the malignant feaver, whereof we have spoken above as of Ireland's reigning diseases, very common, but there besides several other infirmities, viz. violent coughs and of long continuance, stopping of the breath, called in Latin Dispnoea, lameness


---

p.102



 of the thighs or Sciatica, painful stranguries, all which griefs seized on so many persons, that they might well have been taken for sicknesses reigning in that land, as I have many times understood of my brother, who at that time not only dwelling and practising at Dublin, but being physician general of the English forces, had but too much occasion to know that perfectly.


But withal he hath assured me, that those diseases had their original not from any defect of the climate, but of the cold, and other hardships, which the soldiers suffered in their marches; for they many times going to the fields in cold and foul weather, and sometimes marching whole days long, yea several days together, in very dirty and wet ways, where their feet and legs were continually cold and wet, besides that they were sometimes constrained to pass through the water up as high as the knees and waist, and after all that hardship endured in the day-time, to lye in the night upon the wet ground in the open air, this caused the aforenamed diseases, and several others amongst them, in so great number, it being to be wondred at, that many more did not fall into them. And without doubt in any other country of the world, where all the same causes did concur, and where an army endured the like hardship, the same effects, if not worse would follow, so that in this behalf the land it self is not at all to be blamed.














