

#The Miseries and Beauties of Ireland


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Miseries and Beauties of Ireland
====================================


Author: Jonathan Binns
----------------------


### File Description

Electronic edition compiled by Beatrix Färber

Funded by School of History, University College, Cork 1. First draft, revised and corrected.Extent of text: 
165 510 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2016) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: E830001-002Availability 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Editions**2. Jonathan Binns, The Miseries and Beauties of Ireland (London 1837). (Available on www.archive.org).
**Further reading, including authors, books and topics mentioned in the text**2. Gerard Boate, Ireland's Naturall History (London 1652. Reprinted as 'Gerard Boate's natural history of Ireland', edited, with an introduction, by Thomas E. Jordan, New York 2006). Online at CELT.
3. Edmund Borlase, The reduction of Ireland to the crown of England: With the governours since the conquest by King Henry II. Anno MCLXXII. With some passages in their government. A brief account of the rebellion anno Dom. MDCXLI. Also, the original of the University of Dublin, and the Colledge of physicians. (London: Printed by Andr. Clarke for Robert Clavel 1675).
4. Edmund Borlase, The history of the excreable Irish rebellion: trac'd from many preceding acts, to the grand eruption the 23d of October, 1641. And thence pursued to the act of settlement, MDCLXII (London: Printed for Robert Clavel, in St. Pauls Churchyard, 1680).
5. Henry Eeles, Philosophical Essays, in: Letters to the Royal Society (Dublin 1771).
6. Thomas Leland, History of Ireland (Dublin 1773).
7. Charles Smith, The ancient and present state of the county of Kerry (Dublin 1756). Charles Smith, The ancient and present state of the county of Kerry. Containing a natural, civil, ecclesiastical, historical and topographical description thereof. (Dublin 1774. Reprinted Dublin/Cork: Mercier Press 1979).
8. Philip Dormer Stanhope Earl of Chesterfield, Principles of Politeness (London 1775, and many later editions).
9. Arthur Young, A Tour in Ireland, with general observations on the present state of that kingdom in 1776–78. And brought down to the end of 1779 (London and Dublin 1780).
10. Sir John Davies, Historical tracts,by Sir John Davies, attorney general, and speaker of the House of Commons in Ireland; Consisting of I. A discovery of the true cause why Ireland was never brought under obedience of the crown of England. 2. A letter to the earl of Salisbury ... in 1607. 3. A letter to the earl of Salisbury, on the state of Ireland, in 1610, giving an account of the plantation in Ulster. 4. A speech to the Lord-Deputy in 1613, tracing the ancient constitution of Ireland. To which is prefixed a new life of the author, from authentic documents (London 1786).
11. Edward Ledwich and Francis Grose, Antiquities of Ireland (Dublin 1790).
12. John M'Evoy, Statistical survey of the county of Tyrone: with observations on the means of improvement: drawn up in the years 1801, and 1802, for the consideration, and under the direction of the Dublin society (Dublin 1802).
13. James M'Parlan, Statistical survey of the County Leitrim, with observations on the means of improvement: drawn up in the year 1801, for the consideration, and by order of the Dublin Society (Dublin 1802).
14. James M'Parlan, Statistical survey of the County of Mayo, with observations on the means of improvement: drawn up in the year 1801, for the consideration, and by order of the Dublin Society (Dublin 1802).
15. Sir Charles Coote, Statistical survey of the county of Cavan, with observations on the means of improvement (...) for the consideration, and under the direction of the Dublin Society (Dublin 1802).
16. Sir Charles Coote, Survey of the County of Armagh, with observations on the means of improvement, drawn up in the years 1802, and 1803, for the consideration, and under the direction of the Dublin Society (Dublin 1804).
17. Mary Blachford Tighe, Psyche, or the Legend of Love (London 1805).
18. Sir John Carr, The Stranger in Ireland; or, a Tour in the southern and western parts of that country, in the year 1805 (London 1806).
19. Sir Henry Brooke Parnell, A history of the penal laws against the Irish Catholics; from the treaty of Limerick to the Union (Dublin 1808).
20. Francis Plowden, The History of Ireland from its Invasion under Henry II. to the Union with Great Britain (London 1809).
21. John Curry, An historical and critical review of the civil wars in Ireland: from the reign of Queen Elizabeth to the settlement under King William. With the state of the Irish Catholics, from that settlement to the relaxation of the popery laws, in the year 1778. Extracted from parliamentary records, state acts, and other authentic materials. A new and improved edition, edited by Charles O'Conor. (Dublin 1810).
22. John Doubourdieu, Statistical survey of the County of Antrim, with observations on the means of improvement, drawn up for the consideration, and by direction of the Dublin Society (Dublin 1812).
23. Edward Wakefield, An Account of Ireland, statistical and political, 2 volumes ( London 1812).
24. Edward Chichester, Documents illustrative of the oppressions and cruelties of Irish revenue officers (London 1818).
25. R.H. Ryland, The history, topography and antiquities of the county and city of Waterford; with an account of the present state of the peasantry of that part of the South of Ireland. (London 1824).
26. Thomas Warton, The history of English poetry from the close of the eleventh to the commencement of the eighteenth century. Four volumes. New edition (London 1824).
27. George Petrie, 'Account of a human body in a singular costume, found in a high state of preservation in a bog on the lands of Gallagh, in the county of Galway', The Dublin Philosophical Journal, and Scientific Review, 1 1825, 433-435 (for a modern account see http://irisharchaeology.ie/2015/02/gallagh-man-a-bog-body-from-co-galway/).
28. John Ramsay McCulloch, The Principles of Political Economy, with a sketch of the rise and progress of the science (Edinburgh and London 1825).
29. Thomas Crofton Croker, Fairy Legends and Traditions of the South of Ireland (London 1825).
30. John O'Driscoll, The history of Ireland (London 1827).
31. Thomas Keightley, The Fairy Mythology (London 1828).
32. Richard Griffith, Geological and Mining Survey of the Coal Districts of the Counties of Tyrone and Antrim (Dublin 1829).
33. Philip Dixon Hardy, the Northern Tourist Or, Stranger's Guide to the North and North West of Ireland (Dublin 1830).
34. Isaac Weld, Statistical survey of the County of Roscommon, drawn up under directions of the Dublin Society (Dublin 1832).
35. John Ramsay McCulloch, A dictionary practical, theoretical, and commercial, of commerce and commercial navigation (London 1832, 1834).
36. Thomas Moore, A Selection of Irish Melodies (1808–1834).
37. George Newenham Wright Scenes in Ireland: With Historical Illustrations, Legends, and Biographical Notices (London, Dublin and Glasgow, 1834).
38. Henry D. Inglis, Ireland in 1834. A Journey throughout Ireland, during the Spring, Summer, and Autumn of 1834 (London 1835).
39. William Blacker, An essay on the improvement to be made in the cultivation of small farms, by the introduction of green crops and house-feeding the stock thereon. Tenants' edition (Dublin 1835).
40. Mary John Knott, Two Months at Kilkee,a watering place in the County Clare, near the mouth of the Shannon, with an account of a voyage down that river from Limerick to Kilrush, and sketches of objects of interest in the neighbourhood, which will serve as a guide to the coast scenery. (Dublin 1836).
41. William Blacker, The claims of the landed interests to legislative protection considered: with reference to the manner in which the manufacturing, commercial, and agricultural classes, contribute to national wealth and prosperity, and suitable remedies for relieving the distress of the latter suggested: addressed to the most noble Marquess of Chandos and the Committee of the Central Agricultural Society (London 1836).
42. John Ramsay McCulloch, A Statistical Account of the British Empire (London 1837).
43. Jonathan Binns, Corn-Laws superseded by improved agriculture (Lancaster 1839?).
44. George Petrie, The ecclesiastical architecture of Ireland: anterior to the Anglo-Norman invasion, comprising an essay on the origin and uses of the round towers of Ireland (Dublin 1845).
45. Jonathan Binns, Notes on the agriculture of Lancashire, with suggestions for its improvement. 8 vols. (London 1851).
46. Desmond John Clarke, Dublin Society's Statistical Surveys (... ) Paper read before the Bibliographical Society of Ireland (Dublin 1957).
47. Samuel Taylor Coleridge, Fears in Solitude, 1798.
48. Alexander Pope, The Universal Prayer (1738).
**The edition used in the digital edition**2. The Miseries and Beauties of Ireland. Jonathan Binns First edition [xii+418 pages (vol. 1)] Longman London (1837)

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Sampling Declaration


The finished text covers pp 1–418 of volume 1; 1–453 of volume 2; editorial footnotes are included using *note type="auth" n=""*. Images (on pp. 139, 204, 232, 275, 316, 336) have been omitted. The Appendix in vol. 2 has not been reproduced.


#### Editorial Declaration


##### Correction


Text proofread twice at CELT.


##### Normalization


The electronic text represents the edited text. Typographical errors are either marked corr sic="" resp="JB". 
Fractions have been reproduced using /.


##### Quotation


Direct speech has not been tagged.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the volume; div2=the chapter; page-breaks are marked. Lines of verse are marked.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


A small selection of personal names, and group names are tagged. So are titles of books and articles. Words and phrases from other languages are tagged. Words and phrases rendered in Italics are tagged. Where this has come to CELT's attention, it has been noted. 


#### Canonical References


This text uses the DIV2 element to represent the chapter. ### Profile Description


Created: By Jonathan Binns, an assistant agricultural commissioner (1785-1871) who conducted a survey in Ireland between July 1835 and the end of 1836.
 Date range: November to December 1836.#### Use of language


##### Language: [EN] The text is in English.


##### Language: [FR] Some words and phrases are in French.


##### Language: [LA] Some words and phrases are in Latin.


##### Language: [GA] A few words and phrases are in Irish, including those in anglicized spelling.


### Revision History


* (2016-10-07) Beatrix Färber (ed.)

* File reparsed, SGML and HTML versions created.
* (2016-10-06) Beatrix Färber (ed.)

* Volume 2 captured, proofed (2), encoded, and more items added to bibliographical details.
* (2016-09-23) Beatrix Färber (ed.)

* Volume 2 captured, proofed (2), encoded, and more items added to bibliographical details.
* (2016-09-22) Beatrix Färber (ed.)

* More encoding applied; file reparsed.
* (2016-09-21) Beatrix Färber (ed.)

* Header created with bibliographical details
* (2016-09-21) Beatrix Färber (ed.)

* File proofed (1) to p. 99, structural and some content encoding applied.
* (2016-09-01) Beatrix Färber (data capture)

* Pages 1–41 captured.




---


#### Corpus of Electronic Texts Edition: E830001-002


### The Miseries and Beauties of Ireland: Author: Jonathan Binns


Volume 1
--------




---

p.1


Kingston — Dublin — Botanic Gardens at Glasnevin — House of Industry — Rotunda Gardens — Rent of Shops in Dublin — Departure for the Country — Hay-making, and character of Irish labourers — The Scalp — Enniskerry — Powerscourt — Tinehinch — The Dargle — Bray — Cruelty to animals — Hill of Howth — Castle of Howth — Grace O'Malley — Hospitality of the Irish.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


On the 3d of July, 1835, I embarked on board the Post Office packet, from Liverpool, at five in the afternoon. The weather was fine and mild; and at midnight, the moon shone so bright that many parts of the Welsh coast were clearly distinguishable. As the morning dawned, the floating sea-weed and polypi indicated our approach to land; but, unfortunately, the atmosphere was


---

p.2




not sufficiently clear to permit us to enjoy in perfection the first sight of the magnificent Bay of Dublin, justly celebrated as one of the finest in the world. The noble piers of Kingston, constructed of granite abounding in mica, present a splendid appearance when glittering in the sun, and are well calculated to produce upon the mind of a stranger, at the very threshold of the country as it were, a favourable impression of the energy, spirit, and perseverance of the Irish people. The hills of Killiney, and the mountains of Wicklow, visible from the sea, are also of granite, which is used for buildings in the neighbourhood, and of which a large quantity is exported to Liverpool.


Having taken up my abode at Gresham's hotel, Sackville-street, I proceeded to the office of the Commissioners of the Irish Poor Inquiry, and received, from the proper authorities, particular directions in reference to my duties as one of the Assistant Agricultural Commissioners.


So much has been said of Dublin within the last thirty years — so many travellers have described


---

p.3




it in so many different ways, and with such a variety of objects — that I run but little risk of incurring censure by passing it over with a very hasty and superficial notice. Dublin is indeed a fine city; but it is a city of lamentable contrasts. If the stranger be forcibly struck by the number and magnificence of the public buildings, and the general beauty of some of the streets, he is sure to be no less forcibly moved by the very different character of those parts which are termed "the Liberties." Here, narrow streets, houses without windows or doors, and several families crowded together beneath the same roof, present a picture of ruin, disease, poverty, filth, and wretchedness, of which they who have not witnessed it are unable to form a competent idea. Dublin, I have said, is a city of lamentable contrasts: so is London; but the contrasts of Dublin are brought more immediately together than those of the English metropolis. When Dublin presents a scene of the most enlivening gaiety, numbers of miserable beings may be seen lying half naked, and apparently half dead from cold



---

p.3




and hunger, on the parapets and the steps of the houses, their nightly resting places; and the stranger, as he enters the hospitable abode which invites him to partake of the enjoyments and luxuries of life, is almost invariably saluted with the feeble cries and imploring accents of the wretched and the destitute.


The Botanic Gardens, at Glasnevin, about a mile from Dublin, have lately been much improved under the superintendence of Mr. Nevin, who has been trying a series of valuable experiments on the potato and various sorts of grasses, and has also introduced many tasteful decorations. They are well worth visiting. The ground they occupy, consisting of twenty-seven acres and twenty perches, was purchased by the Royal Dublin Society; the gardens, established in 1800, by the last act of the Irish Parliament, have been supported by the general funds of the Society, arising in part from private subscriptions, but principally from an annual parliamentary grant. The Society, instituted in 1731, was supported for eighteen years by private subscription.




---

p.5


Glasnevin has other attractions besides its Botanic Gardens. It was here that Addison, Parnell, Steele, Tickell, Swift, and the celebrated Stella, at different periods resided. The "Drapiers' Letters" were printed in the demesne of Delville, and the author of "Cato," composed several of his choicest pieces here. The fine yew trees in Addison's walk are said to have been planted by the delightful essayist himself.


Dr. Litton, who had accompanied me round the gardens, afterwards conducted me to the House of Industry and the four general hospitals attached. The House of Industry is chiefly supported by parliamentary grants. Since its commencement, 421,148 paupers have been admitted. It was formerly opened for the indiscriminate admission of paupers, whether healthy or infirm, and from all parts of Ireland, but is now restricted to certain diseased and destitute objects from the county and city of Dublin: firstly, aged and infirm paupers; secondly, idiots and incurable lunatics. Such of this class as are inclined to work are encouraged to do so by small premiums;



---

p.6




the males being employed in cultivating the garden, and making oakum, &c.; the females in spinning, washing, and knitting. The system of engaging them in this manner has been found of great utility; and in consequence of the advantage derived from it, several patients have been restored to their friends. The four general hospitals attached to the House of Industry are for fever, and chronic, and surgical patients. The Dispensary affords advice, medicine, flannel, &c, to the sick poor of the north-west district of the city of Dublin, who are not objects of hospital accommodation, and a physician and surgeon attend daily. Rutland Square, (or the Rotunda Gardens), a much frequented resort of pleasure, was opened by Dr. Mosse, the founder of the Lying-in Hospital, for the benefit of that establishment. The gardens, during summer, are made the scene of evening promenade. The interior, which is beautifully undulated and tastefully arranged, is, upon these occasions, illuminated; military bands are in attendance; and the performances of professional singers diversify the


---

p.7



attractions of the place. Though the price of admission is only sixpence, the receipts have been known to amount to as much as £20 a night. The houses around this square are superior buildings, and include the residence of Lord Charlemont, whose father obtained and deserved the distinguished epithets of "great and good."


The rent of shops with houses attached in the best streets of Dublin, varies from one to two hundred pounds a year; some being from three hundred to a thousand pounds fine besides. The decrease of trade in Dublin may be principally attributed to the general change which took place upon the establishment of a steam communication between the Irish capital and this country. Before that event, nearly the whole of Ireland was supplied with English and foreign manufactures *through the Dublin importers,* who of course derived considerable advantages from the business. Now, however, the generality of the country shopkeepers go to England at a trifling expense, and purchase for themselves; but in a greater ratio, it may be observed, than the trade of Dublin 


---

p.8



has decreased from this cause, the country must have benefited.


I left Dublin for the interior on the 6th. The morning was fine, but the prognostications of an agreeable tour were anything but favourable. For a great part of the way, even where the road was so nearly level that it was a point of dispute whether we were ascending or not, Pat's horse declined, or rather was unable to go beyond a walk; for we were placed in that unpleasant dilemma so often experienced by travellers in Ireland, of being dragged by an animal almost entirely exhausted. Objecting to the merciless use of the whip, which in cases of necessity is applied to some lacerated part of the jaded beast, in the barbarous hope of quickening his speed — and yet seeing no prospect of an amended pace — I stepped off the carriage, and tried to soothe my impatience by walking a considerable distance in advance. As we proceeded we had an opportunity of observing a very lazy system of hay-making in use among the Irish. In one field we saw a gang or company of fifteen



---

p.9




or sixteen men working, under charge of two overlookers, and pretending to throw about the swaths of mown grass with clumsy pitchforks. On our passing, they suspended their operations, nor did they resume them whilst we remained in sight. Half the number of women in England would have done the same work, and have done it in a much more efficient manner, than the whole of this company. It is the custom in Ireland for the labourers to be accompanied by an overlooker, with whom, by the way, they spend a great deal of time in idle gossip. From this fact the reader will probably conclude, as I did on first visiting the country, and particularly on this day's excursion, that the Irish are an indolent people; but after visiting nearly every part of the island, and having ascertained what was the real situation of the labourers, I found their want of energy to proceed from the bad system pursued by their employers — from the supply of labourers exceeding the demand — and from the work being always done by the day. All, without respect to the amount of labour actually performed, are



---

p.10




paid alike; accordingly, the stimulus afforded by the expectation of being rewarded proportionably to industry and skill, is withheld. The spiritless inactivity of the Irish labourer may also be attributed to the very small wages he receives, as well as to the inevitable consequence of small wages, the miserable food on which he subsists: in many instances it is barely sufficient to support his wretched life.


Pat informed us that "the Scalp," about twelve miles from Dublin, was a remarkably "illecant place." We knew it possessed celebrity, and to an inhabitant of Lincolnshire or Cambridgeshire it might afford considerable interest; but one in the habit of traversing the wildest and most romantic glens and mountains of Cumberland, Westmoreland, and Lancashire, could find in it little to admire, being merely a passage of the road through an opening in the Wicklow Hills, with some broken rocks and loose stones on each side. On reaching this spot, I began to think that if these were the beauties of Ireland, they were not worth the seeking. We soon, however, arrived at Enniskerry,


---

p.11



a pretty village on the Dargle river, where we left the car and proceeded on foot to Powerscourt. By the advice of a land-agent of the Powerscourt estate, who was accidentally passing by, we selected for our guide a ragged fellow with a black eye, who led us up the hill for three or four miles, to give us a view of Powerscourt. After crossing a pebbly stream, we entered the undulating and woody grounds of the Powerscourt Deer Park. We rambled over their grassy surface in search of the waterfall, till, like many other tourists in pursuit of nature's beauties, we were ready to despair, the distance seeming to lengthen as we proceeded; when, unexpectedly, the splendid cascade, and the romantic little vale into which it falls, suddenly met our view. The fall of the river Glenisloreane is over a precipice about three hundred feet high, with a beautiful combination of rock and wood on the sides of the stupendous mass over which the water flows. Its fall is partially interrupted by ledges of different inclinations, some of which vary considerably from the perpendicular. The grassy


---

p.12




lawn below exhibits the beauty of unassisted nature, its irregular surface being varied with copsewood and enriched with wild fruit and flowers. Whilst enjoying a perfect feast of whortle berries, which, in some degree, compensated for the want of a more substantial repast, we saw other parties regaling themselves with good cheer from their baskets; some seated on rustic benches and others on the ground — their gay summer dresses enlivening the sequestered and beautiful glen, and the rich notes of the bugle mingling with the scarcely less rich melody of the waterfall. A rustic bridge, from which the cascade is seen to great advantage, crosses the torrent a little below the fall. From the deer park we turned to the left, our way lying among meadows and copsewood, along the side of the Dargle river, and on again entering the Powerscourt demesne we passed through fine woods with a stream pursuing a serpentine course, occasionally close to the road. In one of the glades of the wood we suddenly entered a field of fine old cherry trees, their branches bending with ripe


---

p.13




fruit. Having every inducement, from the loneliness of the situation, the heat of the day, and our own increasing hunger and thirst, to share with the birds the enjoyment thus apparently within our reach, we were advancing with this intention, when we discovered, to our surprise, men seated with scales ready to sell the fruit — and we gladly availed ourselves of their services. At the gate leading to Tinehinch our guide abruptly left us, alleging that guides were not allowed to go with visitors through the grounds. On looking round, we observed a number of persons on the road, at a distance, waiting for a guide to the waterfall; having received his remuneration from us, he no doubt saw a prospect of additional profit, and joined another party accordingly. By missing our way to the Dargle, we got a near view of Tinehinch, and indeed approached close to the mansion. Tinehinch is delightfully situated, embosomed in wood, with the Glenisloreane flowing close by. This was the seat of the late Henry Grattan, whose memory is deservedly dear, not to his native country alone, but


---

p.14




to the whole civilized world, as the advocate of political justice — the champion of that liberty of conscience and of those equal rights, civil and religious, which had been so long withheld.


On reaching the banks of the Dargle, we found a happy circle reposing on a knoll high above the river, which commanded views of a succession of wooded brows and slopes, with the winding stream at intervals opening to the view. We scrambled down the steep banks of the wood till obstructed by the ruggedness and abruptness of the impending cliffs which compelled us to retrace our steps. Soon afterwards we reached a huge granite rock which rises precipitously from a frightful depth below: this rock commands a rich view of the valley. The receding banks of the woody slopes are lost in aerial distance. After a long ramble we found the chief beauties of the Dargle, where the river is confined within a chasm of stupendous rocks, overhung with trees. Below this chasm the stream is deep and dark, reposing in a rocky basin,



---

p.15




and reflecting the large granite crags and luxuriant foliage. A ledge of rock on one side of the basin, screened by the branches of trees, forms a cool and shady retreat. Paths and alcoves have been made in these romantic glens by the late proprietor, Lord Powerscourt, and the public have free access except on the Sabbath.


On arriving at the lower Dargle gate our driver was not to be found, and after a walk as far as Bray, in the vain hope of meeting with him, we mounted a car that was on the point of leaving. In addition to those seated before us, we made seven in number, and had to go fourteen miles on heavy roads with only one horse. The willing creature dragged us along for a considerable distance, at the rate of nine miles an hour, but this did not exempt him from the merciless and undeserved torture of the whip, which continued to be applied until the poor beast could trot no longer. This cruel treatment of animals which contribute so greatly to our comforts, is, I am sorry to say, far from uncommon, nor is it discouraged as it ought to be, by those who have



---

p.16




the power, if they chose to exert it, of speedily suppressing the evil. The travellers who do not prevent this abuse are far more to blame than the drivers themselves, who are generally exceedingly ignorant and may plead the brutalizing influence of privation and misery in extenuation of their unfeeling practices. This class of men, as well as the horses committed to their care, suffer incomparably greater hardships in Ireland than they do in England.


The next morning a gentleman accompanied us to the Hill of Howth, which is in a northerly direction from Dublin. Our road lay along the shore of the Bay, which presented no inviting appearances to the botanist; but my friend, a man of science, informed me that it afforded about fifty varieties of shells.


The Hill of Howth is on a peninsula, and is six hundred feet above the level of the sea. The view of the sea from the hill was particularly fine; the extensive and noble Bay of Dublin lay before us; and Ireland's Eye, and other islands, were beautiful objects on the wide expanse of the


---

p.17




Irish Sea, where we could just trace the various vessels hanging like shadows in the horizon. After seeing the lighthouse, we visited the harbours and piers, which are of granite and very substantial. The piers inclose fifty-two acres. These works, the cost of which was upwards of £300,000, are now of but little use, the sand having collected at the mouth of the river. They were intended for a packet station, but the packets now go to Kingston. The first stone was laid so late as 1807. When George the Fourth visited Ireland in 1821, he landed at Howth, and we were shown the stone which bears the footmark of the royal stranger engraved upon it.


The abbey is a venerable and interesting ruin. The Castle of Howth, situated in a flat and unattractive part of the peninsula, belongs to and is inhabited by Lord Howth. Parts of it display great antiquity; several implements of war and utensils of early times are exhibited in the spacious and baronial entrance hall. Lord Howth showed us every civility, and pointed out, among



---

p.18




other things, the two-handed sword with which Sir Tristram, his ancestor, slew the Danes when he conquered them and took possession of the island: it was considered the greatest curiosity of the place. The day being the anniversary of Lord Howth's birth, crowds were assembled to enjoy races, wrestling, and various other amusements; among the rest, a tall smooth pole, well greased or soaped, was erected in the grounds, on the top of which was placed a hat, as a reward for the enterprising man who should reach it. Several battles at intervals added to the scene; and good cheer from the castle crowned the festivities. A story is current respecting a visit to the castle from Grace O'Malley, who, incensed at the gates being shut during the time of dinner, stole the infant son of the lord from a neighbouring cottage where he was at nurse, and only restored him on the condition that they should always be open at dinner time — a stipulation which is said to be faithfully observed to the present day. Many of the Irish consider it a religious duty to keep the door open when at meals, that the passing



---

p.19




stranger may enter and partake. I am happy to add my testimony to that of other travellers in favour of the hospitality and kindness of the Irish in all parts of the country through which I have had an opportunity of travelling: but it is the most remarkable among the poor. In the hundreds of miserable cabins which I entered, a seat, if there was one, was always at my service, and if the inmates did not invite me to share the best they possessed, it was from diffidence alone, for they always seemed gratified if I took a potato from the bowl uninvited. Indeed, I invariably experienced the utmost civility, accompanied with a courtesy of manner which would have done honour to a higher rank of life. The proverbial shrewdness of reply is truly astonishing; and I may here mention, that I do not remember a single instance in which there occurred the slightest reservation in answering my questions, whatever the nature of them might be. On their part the greatest inquisitiveness prevailed. If we met a man in the fields or at his house, and entered into conversation by asking him the way, 



---

p.20




he would immediately inquire the nature of our business; how far we had come; where from; where we were going; where we lived; and whether we were going to do any thing for Ireland — 




---

p.21


Swords — Round Towers — Drogheda — Dundalk — Newry — Postchaise travelling — Hedges of furze — Rathfriland — Hilltown — Lords Downshire, Annesley, and Bangor — Mourne Mountains — 12th of July, and Orange demonstration — Friends' Meetinghouse — Rathfriland — Dresses of the women — Rostrevor — Mountains of Carlingford — Warrenspoint — Kilkeel — An Irish dinner — Cock and Hen Mountains — Peaceable character of the people.
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The Board having now decided upon the routes of the Assistant Commissioners, we left Dublin for the Barony of Iveagh, in the southern part of the county of Down. The first place of any note on our road was the village of Swords, about nine miles north of Dublin. I was here gratified, for the first time, with a sight of one of the pillar or round towers for which Ireland is celebrated. Of the antiquity and objects of these singular structures, of which something will be said in a subsequent part of this work, different writers have given very


---

p.22




different accounts. Drogheda, situated on the Boyne, in the counties of Meath and Louth, and distinguished for its gallant defence against the Irish, under Sir Phelim O'Neill, in 1641, and the cruel siege by Cromwell, in 1649, when he put nearly all the garrison to the sword, was the next object of particular interest. Cromwell's letter to the Hon. Wm. Lenthall, Speaker of the English Parliament, describes a course of barbarous murder and cruelty pursued under the pretext of religion over a party of soldiers who defended a tower till hunger compelled them to surrender. He writes thus: "I believe all the friars but two were knocked on the head promiscuously." The cruelties exercised in Drogheda for five days after the town was taken, exceeded any thing before heard of, yet Parliament applauded the bloody slaughter as an act of mercy and warning to others. Near the Boyne, about two miles from Drogheda, stands the obelisk erected in honour of King William's victory in 1690. The brave Schomberg was here killed by an accidental shot from one of his own men. To the westward, the pillar-tower of


---

p.23




Monasterboise is discerned. This tower, according to Ledwich, is 110 feet high, and 15 feet in circumference, and the walls are 3 feet 6 inches thick. Drogheda is well known for its linen manufacture, and has a population of upwards of 17,000; the houses in the town are of brick, and wear a respectable appearance, but lines of wretched cabins may be seen in the suburbs.


Proceeding northwards, on a flat uninteresting road, the next place of importance is Dundalk, the immediate neighbourhood of which is woody and of great beauty, having the Bay of Dundalk on the right. During the time of the English Pale,[1](javascript:footNote('E830001-002/note001.html')) Dundalk was surrounded by castles and



---

p.24




strongholds of the English barons. Its fortifications were destroyed in 1641.


We travelled by coach as far as Newry, a town of considerable trade, and from which much of the agricultural produce of this part of Ireland is exported. At Newry, also, many emigrants embark to America. To Rathfriland, in the county of Down, we took a post-chaise, a dirty, damp, ill-shapen, rattling vehicle, that produced an insurmountable disrelish for Irish post-chaise travelling; and it was the first and last we ever entered. When we should have started, the landlord and waiters, knowing the inefficient state of both the equipage and its cattle, busied themselves, some at the wheels and others at the horses, in trying to effect a progressive movement. At length they succeeded; but frequent stoppages took place up the hill on leaving the town, and the driver had occasionally to alight and tie up his harness. We passed a few old castles, and the sea was occasionally seen. As we proceeded, I remarked that some of the hedges or fences were of furze, not a continuous line, but straggling, and that others



---

p.25




consisted of a high bank of earth only; whilst some land under crops of wheat was left open to the road. The growing wheat, oats, and barley, appeared good, and we observed some beautiful patches of flax. On reaching Rathfriland, the only inn we could have stopped at was filled with soldiers; we therefore drove to Hilltown, three miles to the south, where we found a most comfortable inn, the Downshire Arms, kept by Mr. Cowan, formerly a favourite servant of the Marquis of Downshire. The inn and village are the property of the Marquis, who has valuable estates in this county. The inns belonging to this nobleman, in various parts of the country, I was informed, are neat, clean, and comfortable, and he selects as conductors men of respectable character who know their business. The Marquis deserves the gratitude of the neighbourhood for his exertions to improve the cottages, and to increase the general comforts of the people. As a proof of the confidence reposed in him, I may state, that though he does not grant leases, the tenant-right or good-will of a small farm, when a tenant


---

p.26



 

leaves it, will fetch £12 or £14 per Irish acre, the new tenant having also to pay the usual rent of £1 per acre for moderate land. The people on his farms are comparatively peaceable, industrious, and happy. Lord Annesley is also spoken of as a good landlord, and adds to his other virtues that of residence. Lord Bangor, another resident landlord, has also the distinction of bearing a similar good character. Sharman Crawford has reduced his rents, and is a good landlord.


The view of the Mourne Mountains, with Hilltown in the foreground, has a very picturesque effect. Amongst these mountains the river Barrow takes its rise, and flows through the county of Armagh to the celebrated Lough Neagh. On arriving at Hilltown, we sent out our notices of the examination which was to take place at Rathfriland. To these notices we attached the great seal, which gave them a wonderful authority in the eyes of the people. The day after our arrival, Sunday, the 12th of July, was the anniversary of the celebrated victory gained by King William "of glorious memory" over the Irish at the battle of the


---

p.27




Boyne; and in order to prevent mischievous consequences from the exultation which the Protestants are in the habit of exhibiting on this noted day, soldiers were posted at different stations in the neighbourhood — one company at Hilltown, another at Rathfriland; and the police had particular orders to suppress any demonstration of political feeling in either party. Capt. Crofton of Hilltown, superintendant of police in that district, found it necessary to disperse a number of people who had met on the banks of the Bann for a sham fight, and he narrowly escaped the attacks of the populace. On my way to the Friends' Meeting-house, I observed, floating on the church steeple, a large orange flag emblazoned with the figure of King William; all was bustle and irritation, the town resembling a disturbed hive of bees. On returning through the town, I found the military occupying that portion of the marketplace which lies between the court-house, the church, and the post-office; the people were very tumultuous — bodies of men rushed violently in and out of the church, preventing the performance 



---

p.28




of religious service, and the soldiers were awfully prepared for action. The minister, fearful of consequences, requested Captain Crofton not to take down the flag till after the congregation had separated; and Captain Crofton, equally apprehensive of disastrous results, declined to interfere unless the clergyman consented to its immediate removal — fearing that the opposite party would assemble in the interim, and that loss of life might ensue; the gaudy banner was accordingly suffered to remain on the steeple, to the annoyance and irritation of the opposite party, and to the entire stoppage of divine service. To suppress such demonstrations of party feeling as the above, is one of the main causes of the demand for military aid in this part of Ireland. Had no orange flag been hoisted, the sabbath would most probably have been passed in peace. Some of the other places of worship had garlands of orange lilies and other orange emblems entwined about the gate-pillars; many of the houses and cottages wore similar indications of the creed of their inhabitants; and even the trees near the road-side



---

p.29



 


were decked with flowers of the obnoxious colour interwoven in the branches. I looked in vain for emblems of the other party.


The Friends' Meeting-house mentioned before, is an unassuming building, at the lower end of the town, with a grave-yard of considerable dimensions planted round with trees. The exterior of the building wore an appearance of neatness, with which the inside did not correspond: its dilapidated condition marked the humble pretensions of the few of this persuasion who remain within its circle.


In passing through the north country afterwards, I observed in many of the gardens clusters of orange lilies, ostentatiously displayed by the road-side. Christianity teaches us to avoid giving offence, and to do unto others as we would have them to do to us. If the mass of the people are to be taught a better system of religion, a better example should be set before them. To vex and persecute those from whose religious faith we differ, is the surest mode of causing them to cling the closer to it, and gives them good reason


---

p.30




to think the worse of us and the religion we profess. Let us rather enter into the feeling described by **the poet**: — 


> 1. Let not this weak, unknowing hand
>   
> Presume thy bolts to throw,
>   
> And deal damnation round the land
>   
> On each I judge thy foe.
> 




Let us rather learn to act upon that kinder system taught by Christianity: — 


> 1. Thus artists melt the sullen ore of lead
>   
> With heaping coals of fire upon its head;
>   
> In the kind warmth the metal learns to glow,
>   
> And, loose from dross, the silver runs below.
> 

 

The fable of the trial of strength between the sun and the wind aptly illustrates this kind and persuasive manner, in preference to a rude and boisterous attack.


Rathfriland and many of the neighbouring villages are built upon regular round hills, and being conspicuous from a great distance, give to the country an inhabited and civilized appearance; disappointment, however, is the consequence of a nearer approach. There are, indeed, few large



---

p.31




towns or villages in Ireland, some parts of which, or whose suburbs, do not contain the most wretched hovels, inhabited by a sallow, squalid, and miserable population, subsisting on bad food and surrounded by filth.


On returning from Rathfriland I observed a multitude of people, who filled the road for a considerable distance. On a nearer approach they proved to be a Catholic congregation leaving their chapel at Hilltown. The white and scarlet dresses of the women, shining brightly in the sun, and backed by the scenery of Hilltown with its noble mountains in the distance, composed a gay and busy picture of indescribable interest. The women are very partial to showy colours, particularly scarlet. Bonnets are never seen, but the caps are very white, with broad borders ornamented with gay ribbons and flowers. It was an imposing scene, and on meeting them I desired Pat to let his horse move slowly, to give me an opportunity of closer inspection. The men had nothing attractive about them, and the dresses of the women, which assumed so splendid an appearance


---

p.32




at a distance, were discovered, when closely viewed, to consist of anything but costly materials.


The neat village of Rostrevor, which I visited on the 13th, is five miles south of Hilltown, and lies in a beautiful verdant vale, close to Carlingford Bay. It is surrounded by high mountains, and possesses the peculiarity of being ornamented with noble trees — an advantage but seldom met with in Ireland. Rostrevor deservedly ranks high in the scale of Irish scenery. The houses have an unusual respectability of appearance, and nothing is seen of the appalling poverty so frequently encountered. The mountains of Carlingford, south of the bay, are upwards of 1900 feet high, and liberally supply the southern part of the county of Down with limestone of good quality, which is brought over the lough in small vessels, carrying eleven tons each. One ton of stone is said to produce five barrels of lime (four bushels to the barrel) and twenty-five to thirty barrels are used to the acre. Some of the farmers fetch the limestone to burn with turf on their farms. They are



---

p.33



aware that, by purchasing it burnt, it would be lighter of carriage, but in a busy season they frequently cannot get the lime, and lose their journey by returning without it; by securing the stone, they can burn it at their leisure.


Warrenspoint, near Rostrevor, is a well-known port, from which great numbers of emigrants embarked, two or three years ago, for America, and where large numbers of cattle and quantities of agricultural produce are regularly shipped for Liverpool. Its name is derived from its being the site of a rabbit-warren.


Along the shore of the Lough, for some distance, lies the road to Kilkeel. The ride exhibits at intervals varieties of mountain and lake scenery, richly interspersed with wood. Mourne Park, the seat of Lord Kilmorey, who is the proprietor of Kilkeel, is seen to the left. At Kilkeel, which is in the direct road from Rostrevor to Newcastle, I walked down to the shore, nearly a mile distant. This coast is remarkable for the singular form of the stones, which are principally granite: they are egg-shaped or elliptical. I



---

p.34




afterwards saw some of them laid in rows in the yards and pleasure-grounds of Tullymore Park, near Newcastle, the seat of Lord Roden.


At the inn we were indulged with a specimen of an Irish dinner. A woman waited at table without shoes or stockings, and, judging from appearances, the necessary act of washing her hands and feet had long been dispensed with; this, added to moderate cooking, considerably abated a good appetite.


The road from Hilltown to Rostrevor is barren and devoid of beauty, with the exception of the view of the Mourne Mountains and the descent into Rostrevor. These mountains, beautiful from any point of view, are truly magnificent when seen from Hilltown. They are all composed of granite. The Eagle Mountain, pre-eminently conspicuous from its bold and indented top, is upwards of 2,000 feet high, and Slieve Donard, near Newcastle, is 2,796 feet above the level of the sea, and is the highest mountain in the county.


The ride to Hilltown by the pass of the Mourne


---

p.35



Mountains, and through what is called the Deer Meadows, affords an opportunity of seeing the various bases of this cluster, and gives a comparatively easy access to their summits, whose white glistening appearance at a distance leads one to suppose that they are interspersed with large masses of white spar. This is peculiarly the case with the Cock and Hen Mountains when seen from Hilltown, but on examination it proves to be the effect of the sun upon the small particles of quartz and felspar decomposed by exposure to the weather. These mountains supply the Kilkeel river, which enters the sea at Kilkeel. Many small sheep pasture upon their slopes, and I observed two cabins with their small plots of potato ground. On my return from Kilkeel I walked alone, late in the evening, over the summits of some of the mountains as far as Hilltown, a distance of several miles, and though the country was then in a disturbed state, met with every civility. I feel confident indeed that I could have gone anywhere in the neighbourhood, day or night, without interruption, and with even less



---

p.36




risk than would be incurred, at the same time, in most parts of England.




---

p.37


Examination of Upper Iveagh — Extent of the Barony — Number of the agricultural labourers — Linen trade — Cause of its depression — Wages — Mode of keeping accounts — Employment of women and children — Pigs — Cottier tenants and landholders — Expenditure of an Irish family — Clothing of the labourers — Food — Usurers — Potatoes — Cottages — Want of fuel — Conacre — Payment of rents — Ejection — Early and improvident marriages — Subdivision of farms — High prices for tenant-right — Small holdings and their advantages — Rotation of crops — English and Scotch farmers — Absenteeism — Tenancy at will — Lord Annesley
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Our public examination respecting the Barony of Upper Iveagh commenced in the Court-house of Rathfriland, on the 14th. We had the attendance of the police in uniform, and many soldiers under arms, whom the authorities thought it desirable to retain in order to preserve the peace; not, however, on our account, but because the Orange party were still parading about the country in cars with banners and music The clergy,


---

p.38




magistrates, and other gentlemen — the tradesmen and farmers, both Protestants and Catholics — and persons of all religious persuasions and politics — gave their evidence candidly and without fear. The kindest feeling appeared to prevail when one person thought it necessary to correct another.


This barony contains 159,038 acres.[2](javascript:footNote('E830001-002/note002.html')) No evidence was obtained on which reliance could be placed, as to the number of agricultural labourers in the parish above sixteen years of age. It was stated to have greatly increased since the year 1831, when the returns were made. Up to that time the linen weavers confined themselves exclusively to their trade; but the linen trade has become so bad, that most of the weavers now work as agricultural labourers whenever they can find employment. It is only when they cannot get employment in the fields, and on wet days, that they work at the loom. The number of labourers for this barony in the population returns amounts to 4,545; to


---

p.39




this, therefore, a considerable addition must be made for the linen weavers who occasionally employ themselves in agricultural work, to which they consider weaving secondary, only pursuing it when they cannot get employment in the fields. The only sensible reason assigned by them for the depression of the linen trade is the very prevalent use of cotton, and the introduction of union linen, a mixture of cotton and linen. It requires a very clever tradesman to make one shilling a day by linen weaving, and even to do this he must labour many extra hours. The general impression was, that employment had of late years decreased; for this several causes were assigned, such as the absence of war, the introduction of machinery of various kinds, and the division of farms into small lots, in consequence of which the farmers for the most part do their own work. In summer, labourers usually get one shilling a day without diet, or eightpence with it; and in winter, tenpence without, or sixpence with diet. At particular periods, such as harvest and turf-cutting, they get something more. The rate 


---

p.40



of wages has latterly decreased; twenty years ago they were 1s. 8d. per day. When corn is shorn by the acre, which is not frequent, they receive 10s. per Irish acre (by corn they mean oats), or 6s. 2d. English. They would prefer taskwork, because they could work several hours earlier and later. Besides, they could then employ their families. All the labourers here agreed, and nobody contradicted them, that the utmost a man could earn, one day with another, did not exceed sixpence a day without diet. From the clearing in of potatoes in November, to the sowing of corn in March, and again till the hay time, they are wholly unemployed. Many of the labourers in this district assemble at the market-house in Rathfriland in the morning, and if they be not called out early to work, they will shortly take anything rather than go home idle! This is especially the case with men advanced beyond the prime of life. "Steady employment," said one of the witnesses, Hamilton Fisher, "is better than a sudden rise of wages; the want of it is the curse of the country, and the cause of distress and irregularity."




---

p.41


By a summons at petty sessions, the labourer can easily recover his wages, if withheld. The charge for a summons is sixpence, and the serving of it sixpence, both of which sums he is repaid; and sometimes he is compensated for the time and trouble he has lost in seeking the debt before he goes to law about it. The labourers, however, are not in general fond of litigation, and but few of them go to law to recover wages. "When a labourer can write," said M'Allunden, "he keeps his accounts in writing; if he can't write, he keeps a tally — that is, a stick split up — one part being kept by the labourer, and the other by the farmer; for every day we put a notch or stroke on the stick; sometimes the farmer does not put a notch on his stick; and at the end, when we are counting up, if the tallies don't agree, he makes us go to a magistrate and take our oath; but if there is one or two days between us, we lose the days, because we don't think it worth while to go to the magistrate about them."


The wives of some of the labourers find employment in flax and hay time, and in the harvest;


---

p.42



but women do not earn much by engagements of this sort. Some can earn by spinning, if they be good spinners and devote their whole time to it, 3 1/2d. a-day; but when a woman has a family to take care of, she cannot earn more than a penny a day. Mary M'Allunden said that "the yarn which she held in her hand cost her in the market 1s. 2d.; she spun it in a week; had five hanks; and would get 4£d. a hank for it; a real good spinner will spin a hank a-day." Thus, according to her statement, her week's wages amounted to 8 1/2d.; but the labourers present all said that their wives did not earn, by spinning, more than a penny a day, and that the factory at Castlewellan had destroyed the spinning business for women. A little girl might get eight shillings in the half-year for herding cattle, but is sure to be sent home in the winter; children do not get anything for hoeing or weeding, except perhaps a penny or their dinner from a farmer. The fact is, the farms in this district are in general so small that the farmers are able to do their own work.




---

p.43


Upon asking what sum could be earned by rearing a pig, one of the witnesses, Davison, said, "I can get a young slip of a pig about six weeks old for 6s. 6d.; in six months it will be worth a pound; we feed it on the refuse of our victuals; if the farmer will not let it run on the grass, we are obliged to buy something for it, because, as it grows up the refuse will not be enough for it." M'Crome said, "I have a pig, and he cost me fourpence a week to buy bran for him." "At that rate," he was asked, "what would you gain by your pig at the end of six months — ""Deuce a hap'orth, sir," was his reply.


A cottier tenant differs from a small landholder in this, that he has only a house and a small garden. Some have a rood of land, which they call *the cot-take;* the rent paid is from £1. 10s. to £3. The cottier has a house, garden, and flax ground; some have a cow and ground for it, and pay for grazing £3. 10s. from May to December. The holding is occupied from year to year, generally at the above rent. If the house has but one small room, the rent



---

p.44



is from £1. 10s. to £2. A cottier is seldom out of debt, and those who give him credit must wait till he gets work. They mostly work out the rent. When an agreement is made that the rent shall be paid in work of a certain number of days, the landlord will sometimes not allow more than one shilling per day, though the current price of wages at the time be 1s. 6d. The work, also, is generally demanded in a busy time, when the labourer could get more elsewhere. "In harvest time last year," said Hugh Hillen, "I could have got nine shillings a-week, but my landlord made me work for six." To avoid this vexatious disappointment, in some cases the cottiers agree to give a day in every week throughout the year.


"If a labourer were employed every day," said M'Crome, "he would have, I suppose, £18 a year; but then he is not employed half his time; he is employed about three days in the week, at a shilling a day; the outside is not more than sixpence a day all the year round. His wife, having four children, could not do more


---

p.45



than keep the house and family clean; she could not make as much as would buy soap to wash the children's clothes. The children gather manure and firing, and also assist in the preparation of the potato garden; and those labourers who are also weavers can make something when farm labour is scarce." The whole of their earnings, however, would not exceed £9. The following was the account given of their expenditure. For half an acre (of Irish measure) ploughed and manured for seeding, £4; (the seed they generally have from the year before — the potatoes used for this purpose being too small for their own eating); seeding, moulding (i. e. earthing up), and digging out, require twenty-eight days' work, viz., £1. 8s., (the weeding and clearing are done by the children), this amounts altogether to £5. 8s. A fair average produce will be four tons of potatoes to the half acre; potatoes average here about 1s. 4d. per cwt., so that the produce of the half acre would be under the expense, amounting only to £5. 6s. 8d. Upon being asked why they preferred paying for the half acre, to buying potatoes in the markets,



---

p.46



apparently a cheaper plan, they assigned as their reasons that the time they laboured at their potato garden was when they had no other employment; besides, if they agreed to pay for the ground in labour (no uncommon practice) they were sure of so many days' work, and had also some small potatoes for the pig. The next item of expense after the ground for potatoes, is what is called the "kitchen," which they use with them — consisting chiefly of buttermilk, at a halfpenny a quart — three quarts a day answering for a man, his wife, and four children. This will amount to £2. 5s. 7d.; soap, at half a pound a week, at 4d. per pound, will be 8s. 8d.; tobacco, 1/2d. a day, 15s. 2d.; and tea and sugar (taken only at Christmas and Easter) 2s. in the year.


Labourers who are Protestants or Presbyterians pay no dues. The Rev. Mr. Poland, P. P., stated "that a labourer's family pay him, upon an average, three shillings a year."


Some of the labourers in this district were badly clothed, but the generality did not appear very destitute. The following, agreed on by all present,


---

p.47



is an account of a labourer's expenditure in clothes, if properly clothed: —

1. Two yards of cloth, at 5s. per yard, 10s.; making, trimming, &c, 5s.; two coats in the year ... £1 10s. 0d.
2. Two pairs of trowsers, at 7s. each ... 0 £ 14s. 0 d.
3. Two waistcoats, at 3s. each, 6s.; two shirts, at 2s. each, 4s.; two pairs of stockings, 3s. 4d.; two neck handkerchiefs, 2s.; hat, 2s. 6d.; total £0 17s. 10d.
4. Two pairs of shoes, 10s.; women's clothes, £1; children's ditto, £1 ... £2 10s. 0d
5. ......*total* £5 11 10
6. The above expenditure for potato ground and provisions, amounts to ... £9 2s. 5d.
7. Clothing £ £5 11s. 10d.
8. Rent of cabin £1 10s. 0d.
9. Total expenditure ... £16 4s. 3d.
10. Total income as above stated ... £9 2s. 6d.
11. Balance against the labourer ... £7 1s. 9d.



It must be remarked, that their calculations for clothing are too high, and are made rather from what they conceive a labourer's clothing ought to be than from what it really is. When the difference between the expenditure and income was shown to them, they stated that it was correct, but said they made up the difference by means of


---

p.48




a pig, and some little spinning, and that occasionally the husband went over at harvest time to England or Scotland, and earned as much as released the potatoes. The labourer spends his unemployed time in gathering manure, mending his clothes, and sometimes in reading. It was stated by M'Crome, that many of them could read. The materials of which the clothing is composed are but rarely manufactured at home; the women scarcely ever make their own clothes — dressmaking being a regular business, and two or three professors of it being scattered up and down through the district.


The principal food of the labourers is potatoes — except at Christmas and Easter they never touch flesh meat. They sometimes have salt herrings, and are never reduced to less than the ordinary number of meals, three in a day. A labourer, his wife, and three or four children, require two or three stones of potatoes per day. In times of distress, it has been usual to get provisions on credit; and in reference to the usurers employed for these purposes (a class of men who have made



---

p.49



considerable fortunes in this part of Ireland), Mr. Cadell, who pronounced them the greatest scoundrels in the world, informed us that their charge at the end of three months would be £1 for the loan of meal or potatoes worth only 12s. "The people," added Mr. Cadell, "were obliged to give bail for the payment, before the provisions were supplied to them, and the bail and the usurer were frequently in league. I have been engaged in a thousand cases against them and defeated them. The assistant barrister at last put them down. The people for the first year felt the loss of them, but now they are more careful of their provisions." The Rev. Mr. Poland thought that in times of temporary distress the usurers might be of some advantage, but it did not appear that any body considered the benefits arising from them to be equal to the positive injury they produced.


From the middle of July to the latter end of August, the potatoes are unfit for use. "All that time," said one of the witnesses, "the potato colloughs" — that is, becomes ropy or gluey. The



---

p.49



interval between the old crop becoming unfit, and the new crop becoming fit for food, is often a season of great distress; and as the potato, the sole food of the peasantry, is produced only from year to year, the failure of even one year's crop is attended by extreme suffering. On these occasions hundreds of the people may be seen going to the sea side to gather dhulimaun, a sea weed growing on the rocks. It was agreed on all hands, that a man could not subsist upon less than one stone of potatoes in the day, and some thought that quantity would be hardly sufficient. Bread is a luxury which they cannot afford. A few years ago, according to the statement of the Rev. Mr. Poland, there were corn mills in the neighbourhood fully employed from the end of September to the end of June, but now they are nearly closed, the small tenantry being obliged to sell their oats soon after harvest. They are obliged indeed to sell even the seed oats, and to buy them at a dear rate again in the sowing time. The cabins, in general from fifteen to eighteen feet long, and from ten to twelve feet wide, are


---

p.51



composed of stones and mud rudely put together. In many cases they consist of but one room, but in some a small portion is screened off for a sleeping apartment. In such cases, the kitchen, or room in which the inmates live during the day, is about two-thirds of the entire cabin. The cabins never possess a second story — the thatch being the only shelter from the weather. In general it is tolerably good, but in some cabins we found it full of holes; in wet weather, the inhabitants are accordingly obliged to remove the bed from one part of the hut to the other. In all cabins the floors are formed of clay; in some cases nothing whatever being done to the ground, which is left in exactly the same state as it was before the house was built. The floors, for the most part, are uneven and full of holes, containing dirty water, through which the pigs and ducks trample; and in many cases they are lower than the ground outside, and admit the rain in wet weather. Most of the cabins have low chimneys, composed of mud and sticks; in some instances an old firkin is made to answer the purpose. Grates, not being required


---

p.52




for turf, are never used. The usual size of the windows is one foot square, though many are not larger than the crown of a hat: some are glazed, others filled with old rags. The cost of erecting a cabin is from five to six pounds. The dwellings of the labourers were better a few years ago; "better," in the words of one of the witnesses, "at the time Buonaparte was afoot."


These rude dwellings are invariably placed as near the bog as they can be, for the advantage of fuel, and the farmer usually selects the poorest parts of the farm to build them on. "If there is a bog," said one of the witnesses, "or a rock, or a swamp, or a fen on the farm, 'tis there he puts the labourer."


The ordinary fuel is turf, and although the bogs, which are similar to our peat mosses, are abundant in this district, fuel is not cheap. A creal or pannier-full, which a man carries on his back, costs fourpence. Small farmers generally take about a rood of the bog, at a rent of from fifteen to twenty-one shillings, underletting small portions of this at a higher price to the labourers.


---

p.53



By a rood of bog is meant, that the taker may cut out of the bank, or dig out of the bog hole, as much turf as he can spread over a rood of ground. Though many suffer in winter from want of fuel, stealing is not common. The children are the chief offenders in this way, pulling the briars out of the fences when turf is scarce. "I have often been obliged," said one witness, "to burn my bed straw, or an old chair or stool, to boil my supper, though I'm surrounded by bog." And another said that he had often been compelled to go to bed without any supper at all, for want of fuel to boil it.


Conacre, here called "rood land," is a small portion prepared by ploughing and manuring, and afterwards let by the farmer to a labourer, at a rent of £8 the Irish acre (equal to £5 the English) for potatoes, and of £2. 10s. a rood (Irish) for flax. The labourer takes it to supply his family with potatoes; the flax is usually sold. All that can afford it, take conacre or rood, but many are not able. From one rood to three roods and a half is mostly taken. The average produce



---

p.54




of an acre of potatoes is eight tons, six of which are fit for human diet, and two for pigs and for seed. One rood of land, highly manured, will produce at the rate of ten tons per Irish acre. The rent is usually paid in money, but sometimes in labour, the ordinary wages of the labourer being allowed. In some instances the days are demanded by the landlord in a busy time. If the produce should not be worth the rent, the labourer, by giving notice, can surrender; but if he neglects to do so, he may be sued for the rent. "I never knew a notice given, or a labourer sued for the rent," said Brace M'Mullen. "We are afraid to give notice, because we might not get the land next year. I had some potatoes myself last year, and though they were not worth digging out, I did not give notice of surrendering for the rent. We would be glad of the power of giving them up when the crop fails." The price of conacre has never been known to be affected here through fear of violence. Some allow the labourers to dig their potatoes and put them in pits in the ground, but not to take them away till the rent is paid. "A considerable neighbouring



---

p.55




proprietor," said the same witness, "will not allow a spade to be put in before payment." If the potatoes are not got up by the first of November, the landlord sometimes turns in his cows, or gives a fortnight's notice of auction, and then sells the crop. Under the present prices of wages and quantity of labour, it is a great service to have the conacre system. The growth of potatoes is increased by it; but the labourers would prefer constant employment from the farmers at five shillings per week. "We cannot tell," observed Hillen, "whether the conacre system increases the population, but some way or other it is good for the poor man."


The peasantry pay the rent of their small holdings, sometimes in money, sometimes in labour, and occasionally in both. An agreement is often made for them to work a certain number of days in the year; these they call *duty days.* The prevalent competition for small holdings often induces the labourer to give more than he can afford. If a farm of five or ten acres were vacant in the barony, there would be hundreds of bidders; and



---

p.56




in case a farm were at liberty, in consequence of the tenant emigrating, or the landlord wishing to get rid of a tenant who could not pay the rent, the landlord allows him, though he has no lease, to sell the occupation of the farm — and such is the anxiety to possess land, that he will get a large sum of money for a small holding. "A man makes money in England or elsewhere," said Morgan, "gives all he has for a little settlement, and will be in difficulties all his life."


Land, when out of lease, is not *canted* (i. e. put up to auction). A valuator is sent out by the landlord, and whatever he values the land at must be paid by the tenant, who is allowed to keep the holding. If he consents to the new rent, which is always sure to be raised, there seems to be, in fact, a customary right to hold on in a family, a right which the practice of the landlord does not interfere with. There is very little ejecting in the barony. Lord Downshire, the principal landlord in the district, is very unwilling to eject. None of the rent is ever excused, not even in a bad season. No tithe or cess of any kind is paid by



---

p.57




the cottier tenant; the farmers pay all; but "if tithe and county cess were taken off," said Morgan, "the landlord would put it on the farmer; at least, I'd be afraid if I hadn't a lease." Very few tenants have good purses. "If I was on my oath," said the same witness, "I don't think there is any man with £10 in my townland; the loss of a cow or two, or of £10, would either ruin a man, or make a man rich that got it; 'twould make a gentleman of him in a manner."


In answer to the question whether men are induced to marry, feeling that their condition could not be worse, Morgan said, "No, faith — they marry when the whim takes them — when the spirit seizes them." "Do you mean whiskey — ""O no, that's but a wee bit of false spirit." "They find themselves," said M'Loughlin, "but doing poorly at their father's house, and they try if they could not do better by themselves. And being of no use in weaving, their parents are more willing to let them go." Labourers often marry from sixteen to twenty years



---

p.58




of age, and where *one* thinks of providing clothes and furniture, *ten* do not. "A boy, before he marries," said John Davidson, "looks out for a good comrade to take care of their money. I was married before I was twenty; my son was married at twenty. Many support their parents — it is common to have their parents living with them." "The women," observed Mr. Bankhead, "are generally careful; poverty compels them to be so; they may in many ways make a man comfortable."


In this district the landlords all exact the rent, and everywhere the Assistant Commissioners heard that land was high. The most remarkable circumstances connected with agriculture in this part of the country are the extreme subdivision of the farms, and the high price given for the possession of them. If a man wants to sell the occupation of a small farm of five or six acres, the usual price under a good landlord, even without a lease, will be ten years' purchase upon the rental, subject, at the same time, to a full rent, as if no such consideration had been paid. This is



---

p.59




the case under two noblemen, large proprietors, who do not disturb the tenants as long as the rent is paid. The Assistant Commissioners inspected several small farms, and found that the prices paid for them were most extraordinary; and were not statements of those prices confirmed in all quarters, they would appear incredible. For one small farm, of four and a half Irish acres of ground, in the parish of Clonduff, sold by Mr. David Lindsay, who holds as middleman under Lord Annesley, the present tenant paid Mr. Lindsay £60: £30 in hand, and the rest in two or three years with interest. The rent of this is £1 per Irish acre for very inferior land. He stated also, that when he got possession, the house was in a very bad state, and that he had to repair it at his own expense. A farm of seven acres, adjoining the last mentioned, had also been sold to another small farmer for £100; the rent of this was also £1 per acre. Such instances are not unusual: this is the common practice and the common price. Upon inquiry how the purchase money could be scraped together, the Assistant Commissioners were told



---

p.60




that very many people go from this district to England, and become small dealers in linen, &c, carrying small quantities of goods through the country; and when, after some years, they have made a little money, they return, and being anxious to settle, they give excessive prices for every little holding. The size of the holdings has of late years been diminishing, fathers dividing them among their families, having nothing else to give them but a bit of land; "in fact, there is no other provision here but a little land." The great subdivision of the holdings has not, however, led to much loss of land, in consequence of the increased number of fences; "on the contrary," said Morgan, "we have both sides of a ditch for feeding the cattle; and whins or furze grow on them, which we bruise for the horses, and it makes excellent food."


Both the quantity and the quality of the produce on the small holdings are improving. "There is five times as much produce," said the same witness, "as there was twenty years ago; if there wasn't the produce, what would we do, and the



---

p.61



population increasing so fast on us — ""The small farmer can afford to manure more in proportion than a large farmer; he has commonly a hole near the house, in which he puts weeds and other things, and he must have every inch of his farm tilled; he can't afford to let any of it be idle." (Cowan.) "If he has not good seed himself," said Morgan, "he gets it in exchange for his own, by a little balance, and he is careful in making his selection from his own crop. A small farmer can produce one-third more than a large farmer; he gives more attention to every part of it." "But," it was asked, "the large farmer has surely more capital in proportion to bring to bear upon it than the small one — ""Yes," was the reply; "but we have more labour at command; we have four or five boys mostly, who can watch and cultivate it. I'll give you an example, sir: there is a man in my townland, of the name of M'Roney, and he produces more out of four acres and a half than many of his neighbours out of ten. The small farmer can better afford the system of claying, which costs a deal of labour, because



---

p.62




he does not value his own labour." By claying is meant digging clay out of the pits, from which they extract great quantities, and spreading it over the surface of the land when exhausted by constant cropping. By this process solidity and strength are afforded. A regular system of cropping may be followed on a small farm. The following is the rotation usually observed: the first year — potatoes, laid on the sod, and covered with dung; the earth is dug out of the trenches along the ridges to cover the potatoes. The second year oats, flax, or wheat, are sown, without any ploughing. The third year, oats and grass seeds, (grass seeds grow remarkably well in flax); in this third year the land is ploughed, and also gets a covering of lime. The fourth and fifth year it lies in grass, for mowing or pasturage at the farmer's option. This is the ordinary rotation through all the fields in the farm. But if the land *has* not sufficient sod to fit it for the "lazy bed" system, then they grow but one crop of oats after the potatoes; in other respects the same course is followed. When the small



---

p.63



farmers require aid, they assist one another — lend horses, and get them in turn. No part of a small holding is ever left untilled. The Rev. John Dubordieu said that the rents of small farms are as well paid as those of large ones. A house and an acre of land are in great demand; they will "cant" it (bid for it) against each other, and get money in England, and give twice as much for it as it is worth. There is no ejecting. "The reason is," said Morgan, "that they make the greatest exertion to pay the rent, because the population is so large, that if a man is cast out of his holding he has no chance of getting in anywhere, and there is nothing else here for him to do. When the population is crowded as it is now, the small farmers employ more labour and produce more food. There is no difficulty in finding a tenant for any farm; the land claims us all." "There is more competition for a small farm than for a large one; there would be twelve purchasers to one for a small farm above what there would be for a large one. If a man were about



---

p.64




to sell a farm of twenty acres (that is, his interest in it), he would divide it into several parts, and get more for it in that way. I don't think the landlords here would prevent him from dividing it. I consider twenty acres a large farm. If I had one hundred acres I'd rather divide it among ten men; they'd pay me more rent." On being asked whether they would not soon exhaust the land, and make it worthless, he replied, "Why, it has been in farms of less than ten acres this long time, and yet it is as good as ever." "But will not the people so multiply upon it when it is so much subdivided, as to require all that grows upon the land for their own food — ""It is the will of Providence to increase the people," was the answer, "and when they become too many they emigrate like bees out of a hive." (Hogan, M'Loughlin, and Morgan).


On being asked whether many farmers had come over from England and Scotland to take large farms, M'Loughlin said that "they'd get the mountains for large farms if they wanted



---

p.65




them."[3](javascript:footNote('E830001-002/note003.html')) In some cases non-subletting clauses have of late been introduced into leases. "But we are never prevented," continued the witness, "from letting a cabin and a garden. Landlords have of late endeavoured to prevent the subdivision of farms by advice and council, but not by force. It is a great deal more difficult now than formerly for a poor man to procure a place for a house, because the farmer is less sure of the rent as the labourer has less employment."


The rent will average about £1. 10s. per Irish acre. "If any leases fell in, or any farms were to be let," according to Morgan, "the rent has been increasing." But it has been mentioned by farmers in the northern part of the barony, that if any leases expired on Mr. Sharman Crawford's property, he does not charge for any land more than 1£l. 5s. per Irish acre. Bradshaw and his brother (substantial farmers of Armacloan) stated that adjoining land of the same quality was



---

p.66




let by other landlords at £2. 10s. an acre. "Rents," says Cowan, "have advanced latterly, but are lower than they were twelve years ago." The farmer relies for the payment of his rent principally on butter, pigs, flax, and lastly on his corn. If the pigs are in good demand, the farmer cares little for the rent."


An absentee is a man residing always or mostly in England; "Aye," said Morgan, "and a man sometimes residing here, but spending his money in England. They live in poverty here that they may have a great sum to spend when they go over. I am sure I don't know how they spend all their money; it must be in some extravagance, and not in any natural way of living. We have no great experience of resident landlords. Our corn, our pigs, and our cattle go in ships, and the money in the post-office; but if we had them residing at home, we would be the better of them; they would build better houses for us, and the estates would be more cultivated."


Tenancy at will is more common than formerly; more than one half the tenants are without



---

p.67



any lease, the landlords not liking to give leases except when the farm is large enough to allow a £10 freehold. The usual lease is for one life, and that too of the landlord's choosing; some, however, give three lives and thirty-one years concurrent. The resident landlords give longer leases than absentees. "To be sure," observed McLoughlin, "we should prefer a long lease; if we're broke, we could sell it far better, and we speculate more into it in draining and ditching and planting." There is no land at present held under the Court of Chancery, and only two townlands under middlemen. The tenantry are better off in general under the chief landlord; but, provided the middleman or his agent be considerate, it is often otherwise. Lord Annesley resides constantly in the barony, and assists his tenants by building good houses and making other improvements.




---

p.68


Examination continued — Course of management in farms — Mode of trying the quality of corn — Red and white clover — Failure of Potato crop — Superstitions connected with it — **Arthur Young** — Black rot — Manures — Milk and Butter — Breed of cattle — Fences and trespasses — Taxation — Roads — Emigration — Pawnbrokers — Spirit shops — Intelligence of the people — Remarks on tenant-right — Bog-land — Description of cabins — Poverty and contentment — Beds — Civility and resignation of the Irish — Stock of small farmers — Flax — Gate-pillars — Tethered pigs — Poor Laws.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The Irish acre is principally used in this district, though the landlords are introducing the English. The barony is mostly under tillage, the usual average of the tillage farms being from three to ten acres. One acre out of every three is devoted to the keeping of the cow, and in a farm of six acres two cows and sometimes a horse are kept. One acre, with a little assistance from clover, was stated to be quite sufficient for one of the cows of this district.




---

p.69


Much more produce is raised now than formerly; and five times as much grain is exported. "I can remember," said Hogan, who seemed about fifty years of age, "when no corn was sold at all to pay the rent; when we used to get three shillings a yard for the web; we get but 1s. 2d. for it now. I well mind Jacky Cowan making from four shillings to 5s. 5d. a day, and now he could not make more than one shilling at the best. If a man had many daughters and a family at that time, they would pay the rent, when spinning and weaving was good." "The produce," said Morgan, "is increased according to the population;" and this seems to be the truth. The pressure arising from a very dense population requires a corresponding exertion, and latterly this exertion has no object to turn to but agriculture.


Two-thirds of a farm are generally appropriated to corn, flax, and potatoes; the sheep are sent to graze the mountains. There is no naked fallow, and the people are very negligent in weeding their crops, which costs them one shilling an Irish acre. The corn is threshed immediately: "If you


---

p.70




were here in November," it was stated, "you'd see many a stack without grain; they are all obliged to pay up the rent of the year at November." They consider the straw in a great degree lost as food for cattle, whereas, if they could meet the rent without threshing the corn, except as the cattle gradually want it, they would conceive it a great benefit. The produce is generally sold in Newry, ten miles distant. The tenant having taken the corn to market, a factor runs an instrument called *a trier* into the sack, and, according to the sample extracted, gives a ticket to the seller to take the corn to a certain store, and there, if the rest of the corn be of the same description, the grain is passed and paid for. If, however, there be any of it worse than the sample, the price is lowered; though, should it so happen that the sample had been taken from the worst part of the sack, and that the rest was of a better quality, the merchant would give no advance.


Clover, vetches, trefoil, and rye-grass, are all sown to a limited extent in this barony — a small



---

p.71




quantity of white clover being sown amongst the red, for the purpose of preventing fermentation in the stomachs of the cattle. Mr. Lindsay has succeeded in growing turnips. Morgan also stated, that having read Mr. Blacker's pamphlet, he was induced to try turnips; that they grew very well with him, and that he found them a better food for his cattle than potatoes. The chief culture, however, is in potatoes, oats, and flax, few new plants having been introduced. There had been great deficiencies in the potato crop for the last three years. The cause is not ascertained. The most judicious persons, according to Murphy, attribute the failure to the succession of mild winters, which causes the plant to grow too early, and thus wastes its vegetative powers. He stated that formerly, if, in digging, a potato happened to be cut with the spade, or otherwise injured, it used to heal again, and was the one usually selected for planting; whereas now, the people carefully set such aside, never planting them, for wherever they have tried them latterly, a failure has ensued. "I don't know why they fail," said



---

p.72




Morgan, "but there is a knowledgeable man near Castlewellan, who says that there is a great multitude of flies coming through the air, which have swords penetrating the potatoes; he says they can be seen through a glass." "Our great Creator," remarked Cowan, "is not pleased with us; he wishes to punish us, and to shew us we are under his scourge." These answers sufficiently prove the great perplexity in which this most important question is involved. Greater care is taken than formerly in selecting the seed, people of the inland districts procuring it from the sea side where the land has been manured with sea weed, and vice versa. Though this change has proved beneficial, they nevertheless very often fail. Formerly they used to cut the seed a fortnight before planting, and threw it aside, and yet it grew very well; now they would not risk the seed for a day.


**Arthur Young** mentions a disease called the black rot as known in Ireland when he wrote his tour in the year 1779: — "In the county of Tyrone, towards Ardmagh and Dungannon, they



---

p.73




will bring limestone fourteen or fifteen miles, burn it, and sprinkle their potato land with it to prevent the black rot." It is a satisfaction to know that a disease similar to that which has lately affected potatoes, and which existed formerly, was either extinguished or worn out, and it may reasonably be hoped that the present disease may not reach so serious an extent as has been anticipated, but like the dreadful malady, the cholera, prove a periodical attack only. A kind of potato called waste reds is mostly cultivated, but they are not good after June. The apple potato is of the best quality, and is used later in the season, but it is longer in ripening. A person in Newcastle preserved his potatoes by depositing them in a pit in the earth six feet deep, watering and turning them occasionally. Produce per statute acre, potatoes 6 tons; oats 15 cwt.; clover 2 tons. Rent from 18s. to 20s.


The manures in general use are lime and dung; the former being brought from Rostrevor, after having been boated across the bay from Carlingford. The farmers burn it with turf. Some idea



---

p.74




of the anxiety to obtain it may be formed from the fact, that in many cases the lime is carted to the distance of twelve Irish miles from Rostrevor, and in the northern parts of the barony persons fetch it from Moira, a distance of seventeen miles. The cost of the lime when laid on the farm, is estimated at from 1s. 6d. to 2s. per barrel of four bushels. Several small farmers stated that they collected more manure in proportion than the large farmers; the gathering of it is a matter of constant interest with every member of the family. The practice of burning land does not prevail to any considerable extent; the landlords are generally opposed to it. It is believed, however, that it would be advantageous to burn the surface of a rough bog.


The quality of the butter is generally considered second rate, being packed from several churnings (a necessary consequence of small holdings). The increase of intercourse with England does not appear to have induced a better mode of saving butter. "When we used to get 1s. 3d. and 



---

p.75



1s. 4d. per lb.," said the witnesses, "we had more reason to be particular." Cheese, of which but little is made, sells at from 2 1/2d. to 3d. per lb. The quantity of milk given by one of the best cows may be considered about twelve quarts a day in summer, and three in winter. A cow will give in the year about 64 lbs. of butter; sometimes, however, soon after calving, she will give 1 lb. per day. The cows are of a small breed; but some improvement has taken place. That in most request is a mixture between the Irish and the Ayrshire; the Ayrshire cross increases the milk without diminishing the natural hardihood of the native cattle. Black bulls, without horns, are preferred by the farmers; their produce, when young, is exported to Scotland, and thence, I presume, afterwards sent to England as Scotch cattle. The value of a good breeding cow is from six to £8; that of a bull, about £6. No cattle are fattened here; they are sent from the mountain grazing to England. Artificial feeding is by no means common, and is increasing very slowly. As there are very few natural meadows, not more



---

p.76




than one-twentieth part of the cattle get hay in winter, though nearly all are housed; their food consists of straw and potatoes. Clover-hay, almost the only kind grown, is given to horses. In the low lands scarcely any sheep are kept. Sometimes a farmer keeps one to go among his cows. The breed is very small, and nearly the same as formerly; the wool, stated to be of a coarse hairy description, weighs from three to six pounds per sheep, and sells at from 8d. to 1s. a pound.


Some of the fences are of stone, others of hawthorn, but the generality are of whins or furze, and are always made by the tenant. Few disputes arise in the low lands from the state of the fences; but in the mountains, where no fences exist, frequent contention results from cattle straying over their limits. The losses, however, from such trespasses are inconsiderable. If a summons be given for trespass, the fine is so much a head; but if much damage be done, and the summons be for the amount of injury, a valuator, generally some farmer in the



---

p.77




neighbourhood, is appointed to ascertain the amount.


Taxation is about one-eighth of the rent; the amount paid yearly as grand jury cess varying from 2s. 6d. to 3s. per Irish acre. A certain sum is laid on each townland according to the number of acres, and the same rate is fixed on bad land as on good. It is collected by two men in each townland, who receive sixpence in every pound. It must be paid six days before each assizes, and levied in two assessments. There is no parish cess now for coffins; there used to be about four years ago, but now two respectable men go about the neighbourhood, and collect whatever they think necessary. No complaint was made against tithe in this barony. In some parts none is demanded from the people, the landlords having undertaken to pay it. In most places it amounts to about one shilling per acre. There is but little voluntary taxation. Some few shopkeepers, who are also farmers, pay towards the support of the dispensaries, but it is not a common practice among them.




---

p.78


The roads are hilly, but in other respects good. It was agreed on all hands that they had improved considerably within the last twenty years. They are now capable of carrying much greater weights than formerly — this, however, is owing as much to the improvement in carriages as to the amendment of the roads themselves. Twenty years ago one horse could draw to market eight or ten cwt. only, he can now take fifteen. "Although," remarked Mahony, "this improvement in conveyance has been of great service to the farmers, I never heard the increase of rent attributed to that cause."


There had been very little emigration this year; the people were not able to go out; the emigrants are chiefly those who are able to pay their way. Some time since people used to sell their little farms and go, but now they are more reluctant to part with their holdings. "It has partly been the case," said Mr. Rowan, "that the substantial farmers have been driven away by the nominal rents promised by the peasantry;" the farmers present did not think so; they said that some



---

p.79




sold their small holdings and went away, because they were sinking, and did not wish to be exposed where they had been better off. On inquiring whether they who had hitherto forborne to do so, would now emigrate if a free passage to America were given, Mr. Rowan stated that "several would, because their privileges were infringed upon, as Protestants." Hogan explained the circumstance thus: — "Until lately," said he, "the Roman Catholics got no leases of land, but the Protestants had good ones; and when their leases were falling in now, the landlords were raising the rents on them, as well as on the Roman Catholics, and may be some of them did not like that and went away." An impression prevails among the people, that when a free passage to America is afforded, they run the risk of a kind of obligation or bondage, and are not set at liberty; if they were assured that upon landing they would be under no restraint, numbers would be glad to go. Young women especially would be anxious to emigrate, because, in consequence of the introduction of spinning machinery,



---

p.80




their employment is entirely at an end. As it is, some of them have lately gone; others go to England and get into service. The reason why more labourers do not emigrate is, that they cannot afford to pay for the passage; they scrape together as much as carries them to England, but cannot raise the means of paying for the long passage. They do not seem disposed to go to Canada, accounts being spread among them that it is already too crowded, but they think favourably of Kentucky. On inquiring whether the emigration of several of the labourers would relieve the rest by causing them to have regular employment, the reply was — "If two hundred and fifty labourers were to go; indeed if all were to go, the farmers could do without them."


There is but one pawnbroker in the parish, and he went there about four or five years ago. There never was one before him. "Some," said Branagan, "pawn a coat as the best thing they have to pawn; sometimes they pawn the blanket and keep the quilt, sometimes the quilt and keep the blanket; sometimes even their tools, if they have



---

p.81



nothing else, which prevents their going to work, but this is very rare. The interest usually charged is one penny per month on a shilling; and if the article remains in only one hour, they are obliged to pay the money, besides one penny for the ticket. There is no other expense, unless you lose the ticket, and then you must pay a shilling for the stop ticket." An affidavit before the magistrates will be sufficient, but then, as one of the witnesses observed, "you must pay sixpence, or may be a shilling, to the clerk for the affidavit, besides a penny for the ticket. Articles are pawned that are worth only one shilling, and even less; I have known a penny to be got on a couple of children's frocks." The value of the article pledged is usually about three times that of the sum given; on a hat worth three shillings, for instance, one shilling is got. Articles of small value are generally redeemed; the regular time in which they can redeem articles is six months, but fourteen days are afterwards granted by the pawnbroker. If not redeemed, they are sold by auction. The balance goes into the


---

p.82




pawnbroker's pocket, the people not supposing that it could be claimed; they never heard of such a thing. The pawnbroker generally sells the unredeemed pledges at his own premises in the town, previously announcing the auction; and if the goods do not bring a large price, so that he can pay himself well, he takes them in again to his house and sells them by private sale. The people are very willing to buy at a pawnbroker's auction, where they think they get bargains, but would be ashamed of wearing a coat so purchased if they knew it belonged to a neighbour.


The number of retail spirit shops in the barony is decreasing, partly in consequence of a temperance society, established in the parish six or seven years ago, and partly, according to the testimony of Branagan, because of the scarcity of money. The poor drink because they fancy that they cannot, in any other way, obtain equal sustenance for an equal sum. Others resort to spirits *literally for the purpose of warming themselves.* Notwithstanding the decrease of the spirit shops in some parts of the barony, there were twenty-seven



---

p.83



of these licensed houses in Rathfriland, the population being only 2000. There were also some smugglers. In Hilltown, where we lodged, there were ten public houses licensed to sell spirits, the total number of houses being only twenty-one; yet the people appeared sober. I do not recollect seeing one drunken man during the fortnight we stayed there. The practice is common in Ireland to unite the business of whiskey seller with that of grocer; and little dirty huts, almost unapproachable in consequence of dunghills, are scattered along the road side, exhibiting a sign of invitation to the traveller to buy whiskey. These places of course hold out a strong temptation to the poor labourer or his wife, when they go to buy a little salt or soap.


In the course of the examination, the respectability, intelligence, and shrewdness of the small farmers of six or ten acres surprised me: they instantly saw the drift of the questions put to them, and answered them without reserve, and I am persuaded, honestly, and to the best of their belief.




---

p.84


The circumstance that would strike an Englishman as most remarkable on first investigating the agriculture of Ireland, is the enormous price given for the tenant-right or good-will of a farm, in addition to a full and sufficient rent. £10 per Irish acre is no unusual price. This cripples the farmer, and keeps him in debt as long as he lives. Nor is the practice confined to farms held under lease; those held from year to year are purchased, and if belonging to a kind landlord fetch nearly as much as those held on lease, though the tenant is liable to be turned off whenever the landlord chooses. Such is the confiding disposition of these people, when the conduct of the landlord, whatever be his politics or religion, is regulated by honourable principles. This confidence in their superiors is one amongst many proofs of the docility of the Irish people, and the ease with which they may be governed. I was anxious to ascertain how these farmers, always poor and in debt, could possibly raise the money to buy the farms. This I never got satisfactorily answered, and I believe they scarcely know. Some go to England



---

p.85



and earn money by trading, shearing, and other work. They borrow the greatest part by becoming sureties for each other; in this they exhibit great kindness. Under this system of paying tenant-right, the landlord has always security for his rent, even supposing the stock to be driven off, because he would take advantage of the property which the tenant had in the farm, and the new tenant always pays the arrears of rent, the balance only being paid to the off-going tenant. It has also naturally induced the tenant to consider that he has a beneficial interest in the farm; the practice, by long usage having assumed the character of a right — so much so, indeed, that in some places, (the county of Donegal, for instance,) a tenant, I am told, sells his interest in his farm in spite of his landlord. A father leaves it by will to his children, or gives it whenever he pleases, and it passes by will like real property. This may account for the peculiar hardships the people feel, and the way in which they prosecute their revenge against the landlord, or his steward, and the incoming tenant. In many parts of Ireland the



---

p.86




difficulty consists not so much in dispossessing the present tenant, as in securing peaceable possession for his successor.


The distance between Rathfriland and Hilltown is from three to four miles. A considerable tract of bog land, which yields excellent fuel, lies between these places. On a fine day, at this season, the bog presents a lively appearance, from the number busily employed upon it. Some work the bog into a pulp, and afterwards spread it on the surface to drain; then it is formed into ribs with the edge of the hand, and when sufficiently solid is cut with a large knife in the lines marked out, and set up to dry. This turf is superior to that merely cut out of the raw bog. Turf is nearly the only fuel used for all purposes.


I visited several of the small farms belonging to the Marquis of Downshire near Hilltown, on the west side of the road leading to Rostrevor, where I found the houses any thing but comfortable: the floor of earth containing little pools of water that had found its way through the roof. In these pools the ducks were paddling, and the



---

p.87



large pigs walked in and out of the cabins at pleasure. Some of the dwellings were without a chimney, the smoke making its escape by holes in the roof and at the door. About eight acres of land were attached to each of these houses on the side of a damp hill. The rent was £4. Some had a cow and horse, but others had neither, not even a pig. Their furniture consisted of a table, and sometimes a chair or a stool or two. Some cabins on the east side of the road, on an estate belonging to Mr. Barrington, are miserable dwellings, but whether a middleman intervenes I do not know. I went into one, twelve feet long by eight wide, the height being short of six feet. This apartment was the only one for a man, his wife, and three children. Two acres of poor land near the mountains were let with this cabin. The rent of the whole was £2. The woman met us at the door, and with a cheerful smile invited us in. She and her children looked healthy and happy, though the husband could not obtain work, and they live on potatoes alone, frequently without even salt. They were not



---

p.88




worth a chair, and the mother sat on the ground. The happy countenance of this woman astonished me; and I feel that if I were to call her *poor* I should do her an injustice. The beds, if they deserve the name, consist of a little straw on a few poles, raised a foot from the floor, with a scanty blanket and some old rags. If a poor family can procure a pennyworth of buttermilk occasionally to be divided amongst six of them they are satisfied; two shillings per annum supply them with tea and sugar, which they only use on particular occasions. These poor Irish have frequently not even potatoes sufficient to satisfy hunger, and are compelled to seek subsistence from the weeds of the field and the sea-weed on the shore. It is not unusual to boil for food the weed called **prasagh**, a sort of sinapis, or what in some parts of England is called ketlock or ranch; and where the hawthorn is allowed to grow, they eat the berry or haws, which they call **skeehony**. Yet their misery is borne with cheerfulness; they are uniformly polite and hospitable, and ever ready to communicate any information which it



---

p.89



may be in their power to supply. Although I have travelled through most of the counties in Ireland, I never yet met with an instance of incivility on entering their cabins, however abruptly; on the contrary, a hearty welcome was always given, my call seemed to excite their gratitude, and good wishes, warmly expressed, constantly attended my departure. The submission of these poor creatures to the hard destiny entailed upon them, is remarkable. Upon one occasion a woman observed to me that "they had hard fare and disappointments, but God prepared the back for the burthen." By way of giving them some little comfort, I frequently remarked, that they and their children were far more healthy than the rich; they would reply — "God so ordered it for the poor." The men sometimes carry their demonstrations of kindness and affection for each other further than is agreeable to an Englishman. At fairs I have seen them embracing each other, but I believe whiskey had a share in the transaction. This practice, once very common, is, however, on the decline.




---

p.90


The women in this part are certainly not of elegant form, being short and broad, with stout legs, probably the effect of hard labour and exposure to the weather. The mention of the word elegant reminds me of the frequent use of it in Ireland; it is introduced upon almost every possible occasion. For instance, the driver of my car, when I asked him if the road over the hills were good, replied, "It is illicant enough." When driving, they are incessantly in action, either crying out to the horse "golaang" or applying the whip, which, fortunately for the poor beast, is a clumsy soft instrument, attributable I hope to a merciful feeling in the driver. The harness is generally tied together with strings and ropes, some of which are sure soon to give way. From a break down of the car, or jingle, as it is aptly called in some parts, you are not likely to suffer much injury, even should it be a fracture of the axletree, or should the wheel come off, or the horse fall, as it is so easy to dismount. They are also very convenient: I have frequently left the vehicle to pick up a plant by the road



---

p.91




side, or a piece of stone on the road, and remounted without the driver's knowledge.


The roads through the county are under the care of a county surveyor at a salary of about £300 per annum, and are kept in repair by a cess upon the county. The traveller is not annoyed as in England by the interruption of toll-bars. About Hilltown the roads are repaired with granite, which, though hard, does not cement; if rain should fall heavily in the night, and the morning following be dry and windy, they are dusty before noon. The fences consist chiefly of furze, which, when in flower, must be excessively gay and beautiful; even in its green state it greatly enriches the appearance of the country. This district is extremely populous, the people consisting chiefly of small farmers, each of whose stock may be said generally to be composed of two cows, together worth £10, a horse worth £5, a plough worth £1. 10s., and a cart worth £5, making a property whose aggregate value may be accordingly estimated at £21. 10s. These, I ought to mention, are the cost prices.




---

p.92


On the 17th of July the ear of the oat was just visible, and the flax particularly beautiful. It is extremely interesting to watch its slender stems of pale green waving gently before the breeze, and its little flower of delicate blue expanding or closing in obedience to the alternate influences of light and gloom.[4](javascript:footNote('E830001-002/note004.html'))


Formerly, when the linen manufacture was in a more flourishing state, several flax mills were in busy operation on the river Ban, below Hilltown. These we found in a state of ruin. Many of the corn mills have shared the same fate, as the farmers could not afford to keep the corn to grind, but were obliged to sell it immediately for the rent.


Not only has almost every mean cottage or farm-house two huge gate-pillars with conical tops built of stone and mortar, whitewashed, and accordingly 


---

p.93



very glaring on a bright day, but the field gates are usually honoured in the same manner. Whether the prevailing adoption of these ungainly structures arises from the likeness they bear to the ancient round towers, or whether their use is occasioned by the scarcity of entire stones and wood, I could not ascertain. Slender iron gates are frequently attached to them, which makes their disproportion appear the greater.


The attention of strangers cannot fail to be arrested by the extraordinary spectacle which some of the clover fields present, of cows, horses, sheep, goats, and pigs, each fastened by a rope or chain to a stake. The pigs have a belt before and behind the shoulders, to which the rope is attached; and such is the force of education (for the Irish pig is domesticated in the family of its owner) that a practice at which an English pig would assuredly rebel, is borne with the most patient unresisting submission. Goats are frequently tied at the road-side, one rope sometimes fastening a couple. This practice of confining cattle within a small circle is not only barbarous


---

p.94




and injurious to them, but wasteful both of food and manure. If the clover were mown and given in the stall, its growth would be more luxuriant, the produce certainly more than double, and the manure, being all saved instead of all wasted, would be preserved and at the farmer's command. This confinement to the stake must be injurious, I repeat, to the animals. They suffer the peltings of the storm at one time, and the scorching rays of the sun at another; are deprived of the luxury of water except once a day, their food is soiled by being trampled on, and they are tantalized with fresh food being within an inch of their mouths, and yet beyond their reach.


Our impression, after finishing the examination at Rathfriland, and inspecting the various farms, cabins, and labourers, was, that but little was required of government beyond a system of poor laws, applicable chiefly to the aged and infirm. The rest might be accomplished by the opulent and influential inhabitants of the neighbourhood, most of whom, I feel persuaded, are sincerely desirous to assist in rescuing their country from



---

p.95



the degradation into which she has fallen. Though cases of extreme suffering doubtless exists this part of the country is far from being in so distressed a condition as we expected to find it.




---

p.96


Tullymore — Educational Schools — Slieve Donard and other Mountains — Geology of the district — Dundrum — Houses buried in sand — Killough — Ardglass — Examination at Strangford — Barony of Lecale — Employment — Marriage — Receipts and Expenditure of a family — Usurers — Potatoes — Spirit Shops — Clothing of the Peasantry — Conacre — Cabins — Tenant-right — Rents increasing — Average extent of farms — Agents' fees — Agriculture of the district — Cholera among pigs — Butter — Sheep and Bulls — Farmers retrograding — Manures — Hedges — Assessment of the Barony — Poisoning of Children — Tithe — Pawnbrokers — Loan Society — Emigration — Farms in the neighbourhood of Ardglass and Strangford.
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Having taken leave of our excellent host and hostess at Hilltown, we mounted a tandem outside car, and pursued the road along the coast northwards to Ardglass, near Downpatrick — the county town — in the Barony of Lecale. Had it not been for the diversified views of the Mourne Mountains, the road would have supplied but little interest till we reached Tullymore, the seat of the Earl of Roden. Tullymore is a short distance



---

p.97



from Newcastle. The grounds are very beautiful, and have the fine Bay of Dundrum and the Irish Channel to the east, and are sheltered by the noble Slieve Donard, the monarch of the Mourne Mountains.


The park, which consists of a delightful alternation of hill and valley, wood and lawn, intersected and diversified by rapid streams, is considerably more indebted to nature than to art for its beautiful and imposing effect. The mansion is far from being a handsome structure; and in many parts of the grounds there are attempts at ornament in the shape of grotesque buildings and other fanciful erections. That, for instance, which appears to be a church at a short distance, proves, on a nearer approach, to be nothing but an imitation of one; yet it is agreeable, notwithstanding their imperfect execution, to witness these innocent endeavours to encourage ornament and taste. Having animadverted upon some portions of Lord Roden's domain, I am bound to observe that the inn and the school-houses display a more enlightened sense of architectural propriety.



---

p.98




Their overhanging roofs, supported by pillars enwreathed with honeysuckle and roses — the small gardens in front, profusely filled with beautiful and fragrant shrubs and flowers — are equal, in my opinion, to anything of the kind in England, and present a gratifying contrast to the surrounding barrenness. They are the oases of the desert. Our stay at Tullymore scarcely admitting of more than a hasty glance, I cannot speak of the educational system pursued in these picturesque schools, as I was not within their walls. This, however, I do not hesitate to say, that he who, under almost *any* circumstances, promotes education in Ireland, confers a benefit which deserves the gratitude of his countrymen, and the cordial thanks of all who desire the intellectual advancement of their race. It is education alone that can make the Irish a prosperous, a happy, and a peaceful people, and qualify them to form a strong and valuable portion of the empire. It is education alone that can lift them above their degrading superstitions. At the same time it would be well if a more enlarged and liberal


---

p.99



principle animated those who minister in sacred things; if both Protestants and Roman Catholics, instead of wrangling about the controverted points of their respective religions, were to sacrifice the speculative subjects on which they differ, for the practical spirit of charity in which they might agree.


The road from Maghera to Dundrum affords a fine view of the sea, Slieve Donard, and Newcastle, the seat of Lord Annesley. This neighbourhood would doubtless supply interesting materials for antiquarian research for several days: and a visit to the summit of Slieve Donard, when the atmosphere is clear, would amply compensate for the labour of ascending. The cave of Donard, who lived in the fifth century, is shown at the top of this hill. Slieve Bingian is 2449 feet high; Slieve Girkin 1340 feet; Slieve Snaven 2370 feet; and Slieve Donard 2796 feet. This district is rich in interest for the geologist, as the mountain range produces magnificent hexagonal crystals of beryl, terminated by a plane; topazes finely crystalized in groups or single specimens;


---

p.100




beautiful specimens of the component parts of granite separately crystalized, viz: — quartz, felspar, and mica; mornite, so called from the mountains; amethyst; pitchstone; epidote; laumonite; albite; adularia; labradorite; tourmaline, frequently termed the electric stone; variolite; a variety of compact felspar; kirwanite, so called in honour of the celebrated Irish chemist; carbonate of magnesia; anhydrous silicate of iron; phosphate and carbonate of lead; rutile; sulphuret of molybdena; yellow ochre and colophonite. The rocks of Down are generally granite, accompanied by chlorite slate, greywacke, clay slate, common flinty slate, whet slate, drawing slate, clay-stone, alluvial marl, and magnesian limestone. For the above information respecting the Mourne Mountains, as well as for a good deal more respecting the geological character of other parts of Ireland, I am indebted to my friend Joshua Abell, of Dublin.


At Dundrum, close to the bay, the Marquis of Downshire, who has extensive property here, has built an excellent inn. While the horses were



---

p.101




feeding we walked to the ruins of Dundrum Castle, situated on a rock not far from the inn and the bay. This castle was erected by the Anglo-Normans, and about 1652 was destroyed by Cromwell, the prince of destructives. It is now the property of the Marquis of Downshire. A large circular tower, and a high wall inclosing an area, still remain. From the top of the tower, which is gained by a rather difficult ascent up a disjointed flight of steps, a very extensive view of the bay and surrounding country is obtained. The gateway, from its massiveness and strength, deserves the notice of the visitor.


The shore appeared destitute of all interest to the botanist or mineralogist. I was afterwards informed by Mr. Riley, a gentleman whom I met at Lord Bangor's, that on the occasion of a great storm, the sand near Dundrum was blown away from the flat land on the shore, and exposed to view a number of houses that had been buried in the sand, time out of mind — the inhabitants being previously ignorant of their existence.


The dwellings of the farmers within view of the



---

p.102




road appeared comfortable, and the crops of wheat looked flourishing and luxuriant. Much more wheat is grown in this district than in Upper Iveagh. We passed through Killough, a small seaport, where considerable quantities of grain are exported. Our road was round the quay of Killough, designed by the late Alexander Nimmo, and built at the expense of Lord Bangor, whose public spirit has contributed largely to the prosperity of this part of the country.


At Ardglass we arrived on the 23rd of July. The first view of this place is exceedingly imposing, exhibiting a high bold coast of very rugged cliffs, with an extensive prospect of the sea and the Isle of Man, about twenty-four miles distant. Ardglass possesses a fine harbour and lighthouse and an extensive new pier. The purity of the air, the clearness and beauty of the sea, the perpetual arrival of company, together with the passing in and out of vessels from the harbour, concurred to produce a scene of great variety and animation, and to make Ardglass a very interesting place. The inn was kept by a Mr. Steptoc



---

p.103




from Surrey, who appeared highly gratified by a visit from Englishmen. He rented ten acres of land with the inn, and paid at the rate of 50s. per acre. The inn belongs to Major Beauclerk, whose agent, Captain Saunders, is a liberal-minded man, and gave us much information.


On the 27th our public examination commenced in the Sessions-house at Ardglass. We had previously called on the neighbouring gentlemen, and seen some of the farms. We afterwards held an examination at Strangford, also in the barony of Lecale.


In the population returns of 1831, the number of agricultural labourers in this barony, (which contains 61,592 acres) is stated to be 1868; and it is supposed that since that time but little variation has taken place. None of the labourers are permanently employed, except those who are engaged by farmers for a half year, at wages of from £3 to £3. 10s. with diet, being not quite *3s.* per week. All the labourers complained that there was not so much employment as formerly. They are willing to work, if work could be obtained. According to



---

p.104




the evidence of Mr. Blarney, the High Constable, they would be glad to get 3s. a week, the year through. In July there is no employment for an agricultural labourer; the potatoes are all moulded; there is but little hay to be made; and nothing can be done to corn until harvest. When the linen trade was flourishing, a labourer could not be got for less than 1s. 8d. a day; and unless bargains were made long before harvest time, no labourers could be obtained. Mechanics receive 2s. and 2s. 6d. a day, and 1s. 6d. if they have diet.


Labourers marry very early — usually from sixteen to twenty, "just when they take the notion," said Blarney; "plenty at sixteen." Farmers' sons marry later. But little provision is made for this important contract. One of the witnesses, a Catholic priest, observed, that "children are a poor man's riches, and that if the labourer can but raise the marriage money, they consider themselves well off. They think of the potatoes *after* the marriage, not *before,* and leave things to chance."




---

p.105


The Rev. Mr. Knox informed us that there was no Dispensary in Ardglass; that Dr. Aikin attempted to establish one, but failed. He was a man of education, but was obliged to keep a grocer's shop in addition to his profession.


Women can earn something in harvest time by shearing corn; and if they are not quite able to keep up with the men, their husbands assist them, and help to make up the deficiency. The universal opinion of those present was, that an industrious labourer's wife, devoting all the time that could be spared from the care of her family to spinning, cannot earn more than a penny a day. For children there is scarcely any employment.


The board and lodging of an old person would be 1s. 8d. per week; say 2d. per day for diet, and 6d. per week for lodging. Mr. Trotter thought that a legal provision would be useful for the old and destitute. Sixpence in the pound on the annual value would be sufficient; it would not be felt, and might be collected with the cess without much additional expense.


In addition to the proceeds of the man's labour,


---

p.106




which may be estimated at about £10. 8s. per annum, there may be £1 or £1. 10s. profit on a pig, and about 10s. for the woman's labour, making a total of from £11. 18s. to £12. 8s. a year. The expense of food for a family is about the the same as in Upper Iveagh. Soap costs a family fourpence or fivepence a week, and tobacco a halfpenny a day, and a penny on Sundays. In this barony a good deal of what is called "kitchen" consists of groceries, in which, if a man keep himself at all sober, he spends from 1s. 3d. to 1s. 6d. a week. The labourers use a good deal of oaten bread; milk they consider dearer than tea, and think the latter the cheapest "kitchen." The principal food is potatoes; they use, however, a good deal of "stirabout," i. e., oatmeal porridge. In summer they get a little fish, but are seldom enabled to procure flesh meat.


In periods of distress the small farmers are often charged double by the usurers. Whenever payment is resisted, and the case goes before the assistant barrister, he always reduces the price to the market price at the time of sale. In order to 


---

p.107



obviate this difficulty, the usurers adopted a system of lending a sovereign to the farmer, and getting his note for it, and then getting the sovereign for ten shillings worth of meal; but the assistant barrister detected this scheme, and only allowed the price of the article.


Both farmers and labourers agreed that potatoes yield a more abundant crop of food per acre than any corn. In a table of the nutritive qualities and produce per acre of the principal kinds of agricultural plants, published in the Third Report of Drummond's Agricultural Museum, is the following comparison between oats and potatoes. Oats on good soil produce, per acre, 17 cwt.; nutritive matter per cent, 75; nutritive matter per acre, 12 cwt. 3 qrs. Produce of potatoes per acre, 12 tons; nutritive matter per cent, 20; nutritive matter per acre, 2 tons 8 cwt.


Spirit shops are rapidly on the increase; but, compared with the "shebeen houses" (unlicensed houses), those which are licensed are only as one to five. Numbers of portable shebeen houses are taken about to every market, fair, or funeral. A few


---

p.108





years ago, one of the witnesses said, it was hard to find two drunken men in the parish; now it would be hard to find two sober ones. "If some stop is not put to the system," said Mr. Smyth, "it will be necessary to have a coroner in every townland." A temperance society, which at first consisted of 180 members, was established at Ardglass; but when we visited the place, its members had dwindled to sixteen.


The sum paid to the priest was stated by the Rev. Mr. Kearney to be about 3s. annually; but if the labourer be very poor, the payment is reduced, or not demanded at all.


The clothing of the peasantry was represented to be very indifferent indeed — one coat serving five or six years. They used to buy their clothes second hand from Bangor; but since the prevalence of the cholera, they are afraid to wear them thus obtained. The following we ascertained to be the annual expenditure of a labourer and his family, supposing them to possess such articles of wearing apparel as he ought to have:—



---

p.109





|  |  |
| --- | --- |
| For the man himself |  £2 3 6 |
| For his wife | 1 0 0 |
| For his children | 1 0 0 |
| Total | 4 3 6 |





The gentry of the country are kind in occasionally supplying clothes to the labourers' families. Here, as in the former barony, the women are unable to make their own clothes. Dress-making is a regular trade. A witness of the name of Munce said, that a coat would serve a man five or six years, as he would only wear it occasionally. They buy them second hand, and patch them till the original colour cannot be discovered. "They are, in fact, of as many colours as the rainbow." One labourer said that he knew a man who had quilted his coat for twenty years, and that it weighed 20 lbs. "Coats," said one of the witnesses, who thought the above too high a calculation, "last after they are done. They sometimes last twenty-five years, and will be a fine coat still. After six years old, and getting some more holidays out of it, he would begin to wear it."




---

p.110


Conacre is a small portion of ground, generally a rood Irish, taken from the farmer by the labourer. In most cases it is manured by the farmer, and the rent is about £2. 2s. When the labourer manures it himself, the rent is £1. In this case he is obliged to put on it twenty-five cart loads of manure; in case he has not sufficient, the farmer allows him for whatever quantity he has. The chief inducement of the labourers to take rood land is, the certainty of having a little stock of potatoes; it is probable that they might not have the money always ready to buy when they wanted them, and they can pay for a rood in labour. Besides, it insures them a certain quantity of labour. Moreover, even if they had the money, it often happens that they cannot get the potatoes to buy, being five or six miles from a market. The rood system frequently provides potatoes at half the price the labourer could get them for in any other way.


The conacre system is common all over the barony. The quantity taken by a family is regulated by the number and quality of hands capable


---

p.111



of supplying the farmer with labour at harvest; half a rood being generally given for each person in the family who is able to work. The rent is usually paid in labour; from forty to fifty days' work, shearing corn and raising potatoes, being the usual price for one rood — the labourer, moreover, having his diet from the farmer during these days. There is a description of conacre for flax — in which case a farmer lets out as much ground as a peck, or a peck and a half, will grow upon. On the whole, the conacre system seems to work quietly and agreeably, both to farmers and labourers. A man sees that he has the means, by this system, of getting some kind of support for his family; it is a kind of certainty to him, and makes him feel less helpless than if he were to buy provisions from day to day out of accidental earnings. The labourer cultivates conacre ground with as much care as if it were his own.


The cabins in this barony are greatly superior to those in Upper Iveagh, though they never possess a second story, nor a ceiling of any sort: "there is nothing," said one of the witnesses,


---

p.112




"between us and the sky, but the thatch and whatever cobwebs are on it." The thatch, however, is generally a good one, composed of wheaten straw, which is very abundant in this barony. The floors, for the most part, are of clay; some, however, are made of lime and the ashes of a smithy; whilst others consist of mud, scraped off the road for the purpose. This is considered a better material than common clay. In wet weather, when strong fires cannot be kept up, the floors and walls are necessarily damp, in consequence of which, sickness prevails, especially among the aged and delicate. All the cabins here have grates; "for 2s. 6d.," said one of the witnesses, "you may buy a grate that would boil a dinner fit for a man of a hundred a year."


The cost of erecting a cabin, if made of good materials, and consisting of two rooms, is about £12. A smaller cabin with only one room, can be erected for £5. The rent of cabins varies from £1. 1s. to £2. 2s.; but there are instances of £3 being paid for cabins of only one room. When a labourer wishes to build a cabin, an acre



---

p.113



of unreclaimed land is leased to him by the farmer, at a rent occasionally four times as high as he himself pays. On this the labourer builds; the farmer sometimes gives him a twenty-one years' lease, or a longer term, if his own tenure admits of it. The little garden attached to the cabin is cultivated with the spade. If the labourer takes a rood of land from the farmer, it is sometimes ploughed without any additional charge, or the labourer compensates the farmer by a certain quantity of labour. There being no bog within a moderate distance, the ordinary fuel throughout the barony is coal from Whitehaven, which costs in summer 13s., and in winter 16s. per ton. Coals are also brought from Scotland; these are lower by 2s. per ton; but the Whitehaven coal, being of better quality, is the cheaper. A farmer of twenty acres will require in the year from four to six tons.


Small farmers pay their rent in money; labourers generally in labour. The competition for small holdings, single acres, &c, causes the


---

p.114




tenantry to bid any thing in order to get in. "If a farm of five or ten acres," said Thomas Rogan, "were vacant in the barony, there would be dozens of bidders for it." This witness occupied a farm of three acres and three roods Irish, for some of which he paid £1. 5s. per acre, and for more of it £3. "If you were going away," he was asked, "what would you expect for the land — ""I don't think I'd leave it under sixty or £70," was his answer. Mr. Trotter, one of the witnesses, had known £170 to be given for a farm of Lord Downshire's, at Ballykanly. The land was six acres, at a rent of £2. 2s. per acre; this value was set upon it, not because it was building ground — it was a common farm. The same witness stated a case where £100 per acre was given for six acres (Irish measure) paying 10s. 6d. an acre rent; this, however, was in the war time.


When the tenant gets a year or two in arrear, the landlord, instead of ejecting him, allows him to sell his "good-will," on condition that so



---

p.115



much of the purchase-money as will clear the arrear be given to himself. Of those thus got rid of, some, said Mr. Gracey, go to America; but the majority repair to towns with the remainder of the money, and set up business — generally a public house. It did not appear from any of the witnesses that a single penny of rents is reduced in case of a hard year; and yet it seemed that the anxiety to obtain land, even at a high rent, increases, as the means of paying the rent diminishes. From all that could be ascertained, the farmers now give every thing towards the rent, except a bare subsistence. "People, in fact, are mad after land, and in the bargains respecting it, the landlord is sure to be on the winning side." It was stated, however, that Lord Bangor, in letting some ground lately, refused the rents that were offered. He sent out his valuator, and though several offered considerably above the valuation, his lordship did not accept of any advance upon it. The witness who furnished this information stated also, that rents in general were increasing; that the average in the vicinity of


---

p.116




Strangford was about 25s. per Irish acre; the cess 4s. per acre; and the tithe, 2s. 6d.[5](javascript:footNote('E830001-002/note005.html'))


The average extent of farms is about twenty acres Irish; there are very few exceeding one hundred acres. The size of the holdings has rather increased than otherwise. According to the statement of Lieutenant Martin, there is only one dairy farm, properly so called, in the barony. Those proprietors who have attempted to enlarge their farms have incurred considerable odium; the farmers would as soon part with their lives as with their farms. When a man is in arrear, the landlord causes him to sell his farm, and is anxious that some adjoining farmers should purchase: this was stated to be the usual course. "I myself," said one of the witnesses, "commenced the world on seven acres, but by hard labour and care I have purchased up to forty-one now." "One of my neighbours," said Mr.



---

p.117



Gracey, "began on nine acres, and by strong industry he has purchased £600 worth of land." All the farmers agreed that if a farm of fifty acres were divided into five farms, more would be produced than if the whole were in the occupation of one man: more care and labour can be devoted to it. There is a wonderful competition for farms of all sizes, of which Captain Saunders gave us an instance. "A tenant of Major Beauclerk's," said he, "some time ago bought ten acres in addition to his own farm of forty, at a very high rate. I told him at the time it would be his ruin, because he had to borrow some of the purchase money; and so it turned out. He came to me the other day, wanting to sell it again, in order to pay up his arrear: and what do you think he was offered for it — A neighbouring tenant offered £200 for his 'good will'; for the ten Irish acres are out of lease. But I refused to permit the bargain to be completed, knowing that it would only break the other man, inasmuch as he also would have to borrow most of the purchase


---

p.118




money. I only consented to the sale on condition that the purchase-money should not exceed £50. The ten acres paid a rent of £2. 2s. an acre."


Lord Bangor informed us that almost all Lecale is held direct from the proprietor in fee, without the intervention of middlemen. The quantity of land held under colleges and endowed charities is very trifling. Lord Bangor further stated, that the chief part of the barony belongs to resident landlords, and that the remainder is under the care of resident agents. "It is usual for the agents' fees," said Captain Saunders, "to be paid by the tenants in addition to the rent;" but "the only fees taken by agents in this barony," said Lord Bangor, "are fees on the execution of leases. It is not usual, when proprietors receive their own rents, to charge agents' fees in addition, nor is it the practice to require compliments on the signing of leases." Much land was out of lease. The old leases were for three lives, or thirty-one years; the present leases are generally for one life, or twenty-one years. They



---

p.119




contain covenants against sub-letting or selling without the landlords' license, but prescribe no particular course of farming.


In respect of the agriculture of the district, we were informed that the produce is more than doubled within the last thirty years. Land being more generally cultivated, more labour is expended on it, and additional skill is brought to the working of it. Better implements are also used. Formerly the ploughs were of wood, but in 1810 the iron plough was introduced, and has been used ever since. There is little or no naked fallow. The produce of the crops is from 25 to 30 cwt. of wheat; from 27 to 32 cwt. of barley and oats, per Irish acre. Clover and rye-grass are grown in considerable quantities; vetches in much greater abundance than formerly. A few rich farmers grow turnips; some are beginning to try a little mangel wurzel. At the time when the potatoes failed, the pigs were affected with a disease which the people called the cholera; whatever the complaint was, great numbers died, of some disease hitherto unknown. If



---

p.120




once attacked, they seldom recovered. After the malady had become in some degree familiar, the pigs, immediately upon being seized, were killed, and sent to Belfast for sale.


The butter produced in the district is generally of the kind called "first quality." The farmers have a pride about their butter, and consider themselves signally disgraced if it be rated lower than first quality. It is packed after several churnings; a practice that does not alter the colour and quality much, if the cows be kept on the same pasture. "The Dutch women," said Captain Brown, "take more pains than we do in scouring the vessels in which their butter is saved." No cheese is made here, except a little for home consumption.


Very few sheep are kept among the farmers. The Irish breed is the predominating one, but latterly it has been considerably improved by the introduction of some English sheep by Mr. Maxwell and Mr. Ford. The breed of cattle has been very much improved by the introduction, on the part of Sir Robert Bateson, of some good bulls.




---

p.121


The farmers were said by Mr. Burnett and other witnesses to be going back; "it would be better to have 5s. a week than to be a farmer now; it was different with us in the war time." And again — "it would be better for the Irish farmer that Buonaparte had never lived, or never died." The agricultural classes were said to be in a state of bankruptcy. The farmers' stock and leases are mostly in mortgage.


The manures in general use are lime, marl, seaweed and dung; in some instances sea-sand is used. Marl is considered a highly beneficial manure, and was stated by Mr. Henry and Mr. Newhill to remain in the ground serviceable for twenty years. The use of marl as a manure was first introduced into this part of Ireland by Judge Ward, Lord Bangor's grandfather, and its effects then were extraordinary. I have known, said Mr, Gracey, ten or twelve successive crops of barley from one marling, without any additional manure; it is chiefly shell marl, and highly calcareous. About twenty-five tons are used upon



---

p.122



the English acre.[6](javascript:footNote('E830001-002/note006.html')) Sea-weed, said Mr. Henry, is the finest possible manure. It is generally spread on the potatoes between the two mouldings; if it were put out immediately on potatoes, and in contact with the seed when planted, it would kill the potato set. Stone and sod ditches, and hedges not only of furze but of hawthorn, are found in the barony. They are made at the tenant's expense, except in a very few instances, when quicksets or thorns are given. When chopped and bruised, and mixed with oats, the young shoots of the furze hedges are found to be valuable food for horses; they are exceedingly nutritious and wholesome, and make their coats glossy.


The soil of this barony is a fertile, friable loam, on a firm subsoil approaching to clay; and in some parts shell marl. Limestone is abundant at Carlingford; at Larne, on the coast of Antrim;


---

p.123




and at Moira, in Lower Iveagh. It is also frequently brought from the Isle of Man.


The baronial assessment is laid according to a valuation made seventy or eighty years ago, and of course is very unequal at the present time. It is also unfair in another respect, viz., that the sum to be levied from each townland is the same on every acre of that townland; so that a poor farm, with rocks and other waste land, pays as much per acre as a good farm without any waste. In most places there is no parish cess: whenever a child is deserted, or a coffin wanting, two respectable inhabitants of the parish go round and collect subscriptions to meet the necessities of the several cases. "Since the closing of the Foundling Hospital in Dublin," said Mr. Gracey, "the desertion of children has almost entirely ceased. The people used to say it was no harm to desert a child, for it would be sent to the college." The women who were intrusted with the children, and made a living by taking them to the hospital, were suspected of administering poison after receiving the money, which was usually



---

p.124



£5. The mortality of the children who even by chance arrived at the hospital was excessive; M'Culloch, in his Principles of Political Economy, states that, in the Foundling Hospital at Dublin, of 12,786 children admitted during the six years ending with 1797, there were no fewer than 12,561 deaths!


Tithe is much higher here than in the barony of Upper Iveagh. Several farmers stated it to amount on their land to 4s. an acre, and on some to as much as five. The roads in this barony are generally good and convenient. The assessment for them amounts to nearly 8d. per acre per annum.


There are only three pawnbrokers in the barony, and they live at Downpatrick; thirteen or fourteen years ago there was not one. People go from all parts of the barony to pawn their clothes, and many cases were mentioned of persons pawning trifling articles for the sole purpose of procuring a glass of whiskey. They pawn "their day or night clothes, hats, teapots, shoes, in short anything from a needle to an anchor, as the saying is."



---

p.125




"Last Saturday evening," said Ellen Watson, the wife of a carman, "I redeemed an article that was in short of five months; I got 7s. 6d. on it, and what do you think they charged me for it — Why, 1s. 2d. for that time. 'Tis no harm to tell that I pawned, for I wanted the 7s. 6d. to make up the price of a pig, and a good pledge never shamed its master." "I don't know," said Ellen Walsh, "what they would not give money on; but this I do know, that they are all three making very great fortunes out of the poor." The people regard the pawnbrokers, notwithstanding the relief they derive from them, with anything but favour. "They consider them," said a witness, "living by the poor. When they're rich, the people are poor; and when they get poor, the people are well off. The shame attached to pledging is diminished; formerly it used to be a bit of a night job, but now we go in the middle of the day. The better class of persons send their servants to do it for them. Oh, if you were up in Robinson's, you'd see silver spoons and candlesticks, and as good as twenty feather beds."


---

p.126




The same witness stated that one of the pawnbrokers kept a public house on one side of his house, and his daughter the pawn-office on the other." "I have passed," said a witness, "out of the one into the other; there is a passage without coming into the street."


The Rev. Mr. Knox thought that the convenience of a loan society would create industry. The people, however, say that if such an institution existed, they should not like the publicity. "To make his wants known," said a witness, "is the last thing a man would do; yet it would be useful, particularly as landlords want their rents earlier than formerly. From spring to harvest a loan would be useful. Men that lend money charge two shillings for a guinea, for one month, and 200 per cent."


Within the last five years emigration has taken place to a very considerable extent. All the labourers that could go, went, and some of the farmers also; such labourers as had capital, did well, but those who had none, suffered. Some took their families, others have sent for them,



---

p.127



and many have had good accounts from their relations in Upper Canada. Inquiry being made whether many in the barony would emigrate if offered a free passage, Mr. Trotter replied that "hundreds would go on such terms; he had himself paid for the passage of three sons of one of his tenants, and they were doing exceedingly well. On different occasions they had sent sums of £8. 10s., and once £20 to their father, and invited him out to them, but he is too old to go. They have twenty-five dollars a month for their labour in Upper Canada." Some of the labourers carry out with them as much as £3. Many young women have gone out, and are prospering; twice as many, we were told, would go, if they had the money. It abounded in 


---

p.128



wallflowers, stocks, and pinks (flowers intimately associated with the scenes and pleasures of childhood), and exhibited the taste of its owner in its luxuriant woodbines twisted round their supporters. All this, which is common enough in England, attracts attention in Ireland from its novelty. I may here mention, that most of the farm-houses have two or three large dogs, which present a most formidable appearance, and are certainly calculated to intimidate the traveller.




---

p.129


Cost of living at Ardglass — Whale-fishing — Dullisk — Institutions of Ardglass — Journey to Strangford — Lord and Lady Bangor — Ancient Castles — Castleward — Portaferry — Temple Cranic — Colonel Nugent's grounds — Shops in Downpatrick — Abbey of Inch Church of Saul — St. Patrick's Wells — Cathedral at Downpatrick St. Patrick's Cross — Superstitious fables — Slieve-na-Griddle — Cromlechs — Assizes at Downpatrick Raths Castlewellan — Stony state of the roads — Newry — Market Hill — Rich Hill — The Retreat — Capabilities and prospects of Ireland — Mr. Blacker's System — Lord Gosford's farms
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Ardglass is rather fashionably attended during the summer months, but is certainly not so much frequented as its situation and beauty would seem to warrant. We saw several carriages arrive with company from the interior; most of them had only one horse, and very few of them four wheels. The cost of living here is reasonable, and the supply of fish good. The immediate neighbourhood boasts the ruins of several ancient


---

p.130



buildings — among the rest, Ardtole Church, supposed to have been founded by St. Patrick. Of this edifice the east gable and part of the side wall remain. They are situated on a green knoll about a mile to the north of Ardglass. Jordan's Castle, opposite the inn, is memorable for the valiant defence made by its owner, Simon Jordan, during a three year's siege, till Lord Mountjoy came to his relief in 1601.


In one of the numerous inlets or sounds formed by the indentures of the rocks, a whale had been entrapped a short time previous to our visiting Ardglass, and the people, concluding that it was dead, fastened it with ropes to a vessel, with the intention of towing it into harbour at the next tide. The animal, however, at the return of the water, revived, and would have carried the vessel and its crew out to sea, had they not instantly cut the ropes and allowed it to escape. On the ledges of the rocks in this sound we discovered a variety of star-fish, sea-hedgehog, and the edible sea-weed, called in some parts of Ireland, dullisk. I thought it by no means unpleasant. It


---

p.131




is common to see the drivers of carts eating it as they go along the road. Nearly the whole district is covered with grain. Large fields of wheat, oats, barley, and potatoes, are passed in succession, without any intermission of pasture, meadow, or fallow. There are scarcely any hedgerow trees; they are only seen occasionally. The pier of Ardglass has lately been extended at the cost of £26,000; it is an excellent piece of workmanship. The harbour is 22 feet deep at low water. The lighthouse, which is now at some distance from the entrance to the harbour, ought to be removed nearer to it, being likely, in its present situation, to mislead mariners. Captain Saunders stated that the harbour-dues were given up to Government on their advancing money on a loan at 4 1/2 per cent, and that the trade of the port had so diminished that not one vessel in twenty came in compared with those of former days. There once were twelve vessels from Belfast, but now only one; the steamers have in part caused this decrease. He spoke of the extravagance of building the Jail and four Hospitals at Downpatrick.



---

p.132





The Jail and Infirmary cost £120,000, which the farmers, who are fast "going down," are ill able to pay. Captain Saunders thought that the four Hospitals ought to have been in different parts of the country, as Downpatrick contains only four or five thousand inhabitants. The bounty on the fishing used to be £3 per ton, but it was misapplied, and was therefore discontinued. The fishery has since fallen off.


From Ardglass we travelled along the coast to Strangford, by Ballyculter and Kilclief, both of them at the entrance of Strangford Lough. The former is a neat village, containing a beautiful School-house and Alms-houses, built and supported at the expense of Lady Bangor. These buildings display good taste, and are very ornamental to the village. Lord Bangor is an excellent landlord, and both he and his lady are very charitable, and take an active part in promoting the education and prosperity of the country.


The most striking object at Kilclief is the ancient Castle, once the See-house of the Bishops of Down. This castle is now used for a storehouse



---

p.133



for grain, being conveniently situated for the shipping of it. The land adjoining is very fertile, and capable of bearing many crops in succession. Our route lay along the side of the Lough, which, when the tide is out, appears a muddy stream. Strangford is beautifully situated on the Lough; the shore is rocky, and commands a fine view of Portaferry opposite, at which place the Lough widens into an extensive sheet of water, formerly called Lough Cane, or Cuan. It is seventeen miles long, and five broad in its widest part; is well supplied with fish, and is said by the inhabitants to contain as many islands as there are days in the year; this number, however, may be reduced to about seventy. The ruins of Walsh's, Audley's, Portaferry, Killyleagh, Comber, and other ancient castles, are all within view of each other near the Lough, and signals might and doubtless have been given from one to another. Here, then, is a feast for those who delight to contemplate the relics of days when men buried themselves within dark walls nine feet thick, and found it necessary to be constantly on the lookout for enemies.




---

p.134


About a mile from Strangford is Castleward, the seat of Lord Bangor, who attended our examination. At Castleward we met at dinner Mr. Blacker, Mr. Fitzroy, and Mr. Riley, a gentleman well acquainted with the antiquities of Ireland. One front of the mansion is Gothic, the other Grecian. The grounds are beautiful, and command a fine view of the Lough and the opposite shore; they are remarkable also for containing some rare objects in the shape of fine oak, elm, and lime trees, of which, indeed, the park presents some noble specimens. Lord Bangor is inducing his tenants to adopt Mr. Blacker's system of alternate green and grain crops, and stall feeding. He has the command of limestone from one of the islands on the Lough, and allows his tenants to get it free of charge.


After the examination at Strangford we took advantage of the ferry to cross the Lough to the neat little town of Portaferry. It was the fair day, and I had an opportunity of seeing great numbers of the inhabitants. The town was crowded with country people; here, the men


---

p.135



were embracing and kissing each other — there, they were fighting; but I am bound to add, that there was not nearly so much of either fighting or drunkenness as I have repeatedly observed on similar occasions in England. Good humour and extreme hilarity seemed to prevail.


I strolled through the town, and ascended the Windmill Hill, which commands an extensive view of the surrounding country — the bay, the South Rock Lighthouse and the ruins of Quintin Castle, similar in character to that of Audley's and others on the opposite side of the Lough; Gray Abbey also, situated on the shore of the Lough, nearly opposite Comber. It was founded in 1192 by Africa, daughter of the king of Man, and wife of John de Courcy, and was peopled by her with Cistercian monks from Cumberland. The Catholic Chapel, a spacious building on the side of the hill, has an appearance of great respectability. This hill affords a good view of the Lough, and the town of Strangford, with its towers and strong walls overgrown with ivy. In the course of my ramble I was agreeably surprised


---

p.136



on discovering that I was in beautiful grounds and shady groves, ornamented with rockwork and alcoves, and containing well-selected stations which commanded the most picturesque views of the castles, the Lough, and its numerous islands. The remains of an old church called Temple Cranic, surrounded by tombs of very ancient date, supplied a subject of peculiar interest.


These beautiful grounds and the mansion within them belong to Colonel Nugent, and are approached from a spacious quay. The old castle, erected by the Savage family, and the grounds attached to it, form part of the domain. The gardener, whom I accidentally met, expressed great anxiety to conduct me through the gardens, but the lateness of the evening prevented my complying with his wishes. He is an Englishman, and has the grounds, I subsequently understood, in most beautiful order. Lovelier and more delightful spots than Strangford and Portaferry, it has seldom been my lot to see.


A gentleman whom I met in my walk informed me that the poor were not distressed, being well


---

p.137



employed. The women, he added, had taken up the embroidery trade, by which some of them could earn 1s. a day; but, from information derived from Lady Bangor, I have reason to fear that this rate of wages is confined to very few instances.


The evening, as I returned, was peculiarly fine; the Lough lay before me smooth as glass, and reflected a brilliant setting sun. The scarlet dresses of the country people, who lined the shores or crossed the lake in crowded boats, greatly enriched the splendid scene, to which an animated boat-race contributed additional interest. At length the moon arose, and the bustle of departed day gradually died away into one of the mildest of nights. Our road homeward to Ardglass lay along the bay of Kilclief.


Having to go to Downpatrick, the county town, for some books, it was with difficulty I found a stationer's shop — the only one in the town. I was obliged to wait till the sale of the stock, then going on, was concluded for the evening. Half a hundred quills sold for 1 d.; a hundred,


---

p.138




of a better quality, for 3d. The auctioneer dwelt a long time upon the sale of a tetotum, which sold for 2d. **Inglis** complains of a scarcity of shops where bacon and bread may be purchased, but I did not observe this deficiency. In the towns which I have visited, the shops appeared to me to comprise nearly an equal proportion of bread or bacon, groceries, spirits, and clothing. Booksellers' and stationers' shops are the least frequently met with: in Downpatrick there are no libraries, or indeed any places where food for the *mind* may be dispensed — the main regard seeming to refer to the sustenance of the body.


From Downpatrick I walked as far as the Abbey of Inch and the Church of Saul, taking in my way Finnabrogue House, the seat of John Warren Maxwell, Esq., who bears a good character in the country, on account of his employing many labourers, and encouraging his tenants in the improvement of their farms. The grounds, which are very beautiful, are rich in copsewood and fine timber, and are entirely undisfigured by the incongruous interpolations of art. The liberty that



---

p.139



reigns here struck me forcibly. The brute, as well as man, has the unrestrained enjoyment of the grounds; and though there are no gates in any part of them (even the lawn and flower-garden lying open as the fields), the most perfect order is maintained. Occasionally I passed a goat or two, browsing on the side of the road. These beautiful and picturesque animals are very tractable, and afford milk to many a poor family, with which they moisten their mess of otherwise dry potatoes. They feed on rocky barren places, and greatly relieve the aspect of these desert spots.


Inch Abbey, which I next visited, is a fine ruin, with ivy mantled walls and tall lancet windows. The grave yard of Inch Church (the wildest and rudest spot for such a purpose I ever saw) is still used by the present owner, Mr. Maxwell. The nettles and other weeds were six or seven feet high, and covered the entire surface. Inch, or Inis Courcy, was founded by Sir John de Courcy, in the hope of making his peace with heaven for having destroyed the Abbey of Erynagh. He



---

p.140




gave it to the monks of the Cistercian order, and dedicated it to the Virgin Mary in 1180. From Inch I walked on to the ruins of Saul Church, passing the Quoile Bridge and Clough Doors. It is said that this was the church where St. Patrick first preached Christianity in Ireland. The remains bespeak great antiquity, and many of the grave-stones that crowd the yard are of singular and curious character. Alone and unobserved, I took a seat in this place of tombs, full of serious thoughts of the past and the future.


As I walked along the road, the country people viewed me with some degree of curiosity, and were undecided whether I was an excise-officer, a soldier, or a priest. Indeed I was frequently mistaken for the last. Falling into conversation with a young man, he proposed to accompany me to the celebrated Struel, or Saint Patrick's wells, about two miles and a half east of Downpatrick. They are supposed to have been consecrated by this Saint, and have the reputation of curing all disorders. Four wells, situated within fifty yards of each other, are all supplied by the



---

p.141



same copious spring. They lie in a triangular field, having a road on two sides of it, and a few mean looking houses by the side of the road. At these houses the visitors procure lodging and refreshment, and tents are erected for their accommodation. Each well is said to possess its peculiar virtues; one for the eyes, the others for the various limbs, and for drinking. The buildings are of stone, and have vaulted roofs. The largest, in which the invalids bathe, is 16 feet by 11. Near the wells are the ruins of an ancient chapel. My companion informed me that at twelve o'clock on Midsummer Eve the water in these wells always overflows the structures which surmount them; and that their virtues are such, that he knew a man last year unable to walk, who, on being carried and put into the well, walked home quite recovered. For a fortnight after Midsummer, he added, the wells are crowded with the blind and the lame, and all sorts of diseased people, on which occasions the covered water-course is obliged to be opened, to make room for them to wash. These wells are also much frequented for 


---

p.142




penitential purposes; and are visited by people not only from all parts of Ireland, but from England and Scotland. It is considered requisite to the success of the mission, that each person should previously visit the burial-place of Saint Patrick at Downpatrick, and be provided with a portion of the soil from his grave.


After dining at Denvir's, a comfortable inn at Downpatrick, from the landlord of which I obtained considerable information on agricultural subjects, I engaged a gig to Ardglass, and while it was preparing, took the opportunity of paying a visit to St. Patrick's grave and cross, as well as to the Cathedral, a recent building, erected upon the site of the old one, which was a fine Gothic ruin in the immediate neighbourhood of one of those monuments of antiquity almost peculiar to Ireland, the pillar towers. These, the old cathedral, and the round tower, stood on a commanding eminence, and were an ornament to the country for miles, but they have been barbarously destroyed, to make way for a building destitute of all pretension to taste or beauty. Yet mortifying



---

p.143



as one cannot but feel the wanton destruction of such venerable antiquities to be, it is consistent enough with what might be expected from a town which does not contain either a library or a bookseller's shop.


St. Patrick's cross, which consists of granite, is a very rude attempt at sculpture, and, in consequence of visitors constantly taking earth from the grave, (for the purpose either of keeping it, or selling it in the country for the cure of diseases) has a considerable declination from the perpendicular. At the request of the good woman who showed me the relics, I took a piece of the cross for my museum, nor could I disoblige her by refusing to carry away a portion of the soil. Extraordinary stories were told to me, of bloody fights for the bodies of St. Patrick and other saints at Saul; and, in order to appease the people, of St. Patrick having thrust his hand through the earth to prove that he was at Downpatrick. These stories they relate with the most perfect gravity and apparent zeal.


In my way to the hill of Slieve-na-Griddle, three


---

p.144



miles from Downpatrick, I observed in a field adjoining the road a Druidical ring, from which a few stones had been removed, for the purpose, probably, of ploughing the ground. Some of those which remained were 4 feet high, and the diameter of the ring was about 30 feet. Slieve-na-Griddle is only 414 feet above the level of the sea, but in Ireland an elevation of half this height claims the dignified title of mountain. Amidst wild flowers and heath I ascended this hill, at the summit of which is a stone altar or cromlech (crumlech or cromleagh), eleven or twelve feet in length, eight feet broad, and fourteen or fifteen inches thick: it rests upon two supporters which have almost entirely sunk below the surface of the ground. Cromlechs are of Pagan origin, and derive their name from crom, god, and leac, a flat or crooked stone. They are invariably in an inclined posture, so that the blood of the victims sacrificed upon them (men and women accused of crime) might more easily run off. The Israelites were commanded not to build their altars either of hewn stones, or stones on which a tool had been used; and the Irish



---

p.145




cromlechs may be presumed to be similar to those originally raised by the Jewish people. About some of the most venerable antiquities of Ireland, however, considerable mystery inevitably hangs; for the Druidical priests, who buried themselves in dark and gloomy caverns, locked up their religion and peculiar mode of worship in the completest mystery, being forbidden to divulge anything to the laity, or to commit to writing any of their precious secrets.


At Downpatrick, on our way from Ardglass to Market Hill, in the county of Armagh, we visited the Courts, the assizes not having terminated. The Court-house is a new building, but inconveniently arranged. The part appropriated to the administration of justice, is small and confined — is boxed off and raised above the rest of the court, as if intended to be secluded from the body of the people — and is occupied by the judge, the jury, the witnesses, and the police. The counsel are not distinguished, as in England, by wigs or gowns; and the witness, whilst giving his evidence, stands on a table in the middle of the 


---

p.146




court. I left the place with an impression that such an appearance of smuggling justice was little calculated to give general satisfaction. To an Englishman, accustomed to see and hear with the most perfect liberty — it was anything but agreeable.


The rath at Downpatrick is a good specimen of the ancient barrows, or, as they are commonly called in Ireland, Danish forts, of which there is great variety of shape and size. They are to be met with both in high and low situations, but principally on the ranges of hills, and command a view of each other. Some have one rampart and fosse, others more than one; and some have outworks. The above rath is not less than three-fourths of a mile in circumference, and is surrounded by three ramparts about 25 or 30 feet broad. In some of these mounts, or raths, caves have been found. The large raths with outworks have probably served for places of defence; some of the smaller ones, particularly those situated on low ground, and having a low and flat space inside, for collecting the cattle of a district in case



---

p.147




of alarm. Those more elevated and conical, without much rampart, have been ascertained to be places of burial, urns and human bones having been discovered in the recesses within them. In the rath at Downpatrick, and others which I have seen in that part of Ireland, I did not observe any appearance of a passage to the interior; but in Kerry and elsewhere they have an entrance or opening like a small arch. A gentleman from the county of Cork, whom I had the pleasure to meet at Cashel, informed me, that in making arrangements for building his house, he found it necessary to remove one of these raths, and discovered within it seventeen stone coffins, which, however, did not contain any remains of human bodies. Moore tells us that the raths or hill fortresses were the dwellings of old Irish chiefs.


On the 6th of August we left Downpatrick, on our way to Market Hill. We passed through Castlewellan, and saw its old ruined castle on the Mount. Castlewellan is the property of Lord Annesley, who has a handsome seat here. The country around is hilly and beautiful, and proves



---

p.148




how much can be effected by planting in a mountainous and barren country, particularly if well supplied with water. In this district the traveller is charged 8d. per Irish mile for a car with one horse; when the luggage is heavy, the charge is 10d., and the driver expects 2d. or 2 1/2d. per mile, if he drive more than one person.


From Castlewellan to Hilltown, about eleven miles, the substratum is granite rock; the soil is wet and shallow. We here entered the flax district; great preparations were in progress — in digging pits, and damming the water for steeping the flax. The ragwort (**senecio jacobea**) is superabundant in this district, occupying nearly the whole surface of the pastures, as the corn marigold (**chrysanthemum segetum**) occupies the corn fields in many parts, to the exclusion of the grain. We were glad to see again our host of Hilltown in passing through, and should have been well pleased to have taken him and his inn along with us; but we merely changed the car, and proceeded towards Market Hill through Newry, within a mile or two of which is a rath



---

p.149



of considerable note. The roads are so thickly scattered with loose stones, as to make it a matter of astonishment that the horses do not fall. Picking off these stones would give some profitable employment to poor boys and girls, who in general have nothing to do. The road sides also are for the most part encumbered with heaps of stones, which render it dangerous for carriages to meet or pass each other. The scarcity of streams of water in this district is unfavourable to manufactories.


We reached Newry on the market-day. The town, which stands on the Newry river, is well built of granite — the chimney of the distillery, where the far-famed whiskey is made, lifts its direful black head high above the rest. High and picturesque mountains surround the vale of Newry in which the town is seated. On the bank of the canal, about two miles distant, there was formerly an ancient cromlech, of Pagan origin, in a state of great perfection, but a considerable part of it has been destroyed by a brewer in Newry, to avail himself of a paltry advantage of the stones for building.


---

p.150




The canal is navigable for small craft from Carlingford Bay, by Newry, to Lough Neagh. Newry is celebrated for its butter and whiskey: its trade and manufactures are in a thriving state.


On reaching Mrs. Stratton's inn in Market Hill, we immediately issued notices of our intended examination at the Court-house.


On the sabbath I attended the Friends' Meeting-house at Rich Hill, a neat village five miles from Market Hill. About forty families, members of the society, attended the meeting, and I was informed that very often sixty other persons, not members, frequented it. For the most part these persons are engaged in agricultural pursuits. I was kindly addressed by several of them, and accepted an invitation to go home with John Allen, the proprietor of a lunatic establishment, which is called the Retreat, after that at York. This valuable institution is near Hawkley, three miles distant from Market Hill and from Armagh. His system of management, which consists of lenient measures calculated to render confinement as little irksome as possible, is on a principle similar to



---

p.151



that adopted at York, which place he visited, in order to qualify himself the better for the discharge of his important duties. The patients are scarcely sensible of restraint; they enjoy the liberty of rambling through the grounds and gardens, and are allowed every variety of amusement consistent with their lamentable condition. By these judicious means, many have been restored to health, and to the society of their friends. His terms vary, according to the state of the patient, from thirty to £60 per annum, for board, washing, and lodging. I found John Allen an enthusiast in gardening and agriculture, both of which he practices on a small scale. In his farm he cultivates all kinds of green food in drills, but his method is laborious and expensive, for want of suitable implements. It is his opinion that the land in Ireland produces three times as much as it did several years ago, and that with a moderate degree of skill the present produce might be greatly increased. My Co-commissioner indeed had often told me that the Irish would swamp the English farmer by growing as much as would



---

p.152




serve both countries. Certainly the soil of such parts of Ireland as I have seen is of excellent quality, fertilized with frequent genial showers. Labour is cheap, and the Irish farmer is content to obtain merely a bare subsistence — not only without luxuries, but without what the English farmer would call indispensable necessaries. When the projected railway shall be made across the island from Dublin to Valentia, or to Westport or Galway, with its various branches, the Irish will have a greater facility of sending their produce to the English market, which cannot fail to be advantageous to them. To what extent it may be injurious to the English farmer remains to be proved; but we ought to consider it on a broad and real basis, regarding Ireland, not as a distinct country, but as an integral portion of the British empire. It will probably be compatible with the welfare of both; and the natural result will be, the establishment of manufactories, and the increased prosperity of Ireland. The Irish will then consume a larger quantity of what their country produces.




---

p.153


The soil about Rich Hill is fertile and deep, and lies upon limestone; the surface undulates gracefully, and is well wooded. Several gentlemen's seats give an appearance of respectability to the neighbourhood. The principal owners are Edmund Bacon, Esq., Sir Thomas Molyneux, and the Earl of Gosford. The Gosford estate near Market Hill contains 20,000 acres and 1500 tenants; not more than sixty or seventy of whom have as much as 20 acres. The system of Mr. Blacker, Lord Gosford's agent, is first to level all the old crooked fences and make straight ones, as a division between each occupier, allotting a square piece of land, consisting of about four statute acres, to each person; and as the tenants were in the last stage of destitution, he found it necessary to provide them with lime and seeds, as a loan, without interest; opening an account with each of them on their first entering upon the farm. A person called *an agriculturist* looks after the agricultural department, weighs out the seeds, and instructs the people in the cultivation of their farms. Upwards of sixty of these agriculturists have been



---

p.154




introduced from Scotland through Mr. Blacker's means, and been distributed amongst gentlemen who have applied to him in various parts of Ireland. Their wages are from thirty-five to £40 per annum, including all allowances.


Mr. Blacker, not being able to attend us himself for a few days, directed the agriculturist, Mr. Bruce, to accompany us on our inspection of Lord Gosford's farms. We soon arrived at Mr. Black's farm; he occupied 14 acres, at a rent of 22s. per acre; the tithe in addition was 1s. 8d., and the county cess 2s. 4d. per acre. He sows a few turnips, and they, along with his other crops, were good. His house, which was very comfortable, contains two looms; these were used when his family were not all occupied on the farm. Some of his cattle were kept up on green food, but they were very dirty. Bruce also kept his own cattle up, and we observed that they were dirty also; on which he remarked that they never cleaned them on Sunday (which happened to be the day before). Black appeared a clever manager; his crops were good, and his land clean,



---

p.155



and Bruce said he was saving money, but he was not an out-and-out green-crop farmer. The next tenant we called upon was an old woman who was attempting the turnip husbandry; she had, however, neglected thinning her few perches of turnips until they had mastered and discouraged her; she burst into tears, and said she had done her best. The poor creature had been carefully picking out a plant or two when she ought to have hoed them down by scores; and like all novices in turnip growing, she thought it a pity to throw the turnips away, and was anxious to let them grow till the thinnings were food for her cow — just as many planters destroy their plantations by allowing trees to crowd and kill each other, in order that the thinnings may be of some value.


We next came to James Lennon, or James O'Neil, of Garvah, who met us near his farm with his hands in his bosom. He was without shoes and stockings; his matted locks informed us that they and a comb were strangers; and his half-witted countenance was altogether calculated to cast ridicule upon the idea of attempting to make such


---

p.156




people successful agriculturists. This poor man farmed seven acres; he had been induced to sow a few turnips (I think fourteen perches); he also had neglected them till they were injured, and the labour of thinning had become increased tenfold. His wife and daughter, the latter a young woman of eighteen, were digging very hard with long spades between the rows, and using their bare feet in forcing down the spade into the clay. They appeared, however, quite cheerful and happy under their fatiguing labour, complaining only of the quantity of manure the turnips had taken, and the fine crop of potatoes they might have had with it. Very many instances of the good nature and perseverance of these half-naked and half-starved people constantly occurred — instances tending to establish the conviction I had previously formed, that when they can place implicit dependence upon their landlord, they are ready and most willing to adopt any system that may be proposed for their advantage.


Another small tenant had obtained from the landlord some wood for a pig-sty, and the agriculturist


---

p.157



having accused him of burning it, the tenant, with the greatest good humour, laughed assent. These tenants build their own houses of clay and straw, or rushes. They make the walls solid, and raise them two feet high at a time with mud and rushes, allowing them ten days to dry between the several layers. The doors and windows are cut out with a spade, and the sides made straight and smooth. These dwellings, including windows, cost the tenant 50s. The landlord frequently finds, in addition, some fir, or poles of other sort of wood, for the roof. They contain two bays or rooms, each 14 feet square. Most of the poor people prefer these thatched mud cabins to a house of stone and slate. A man of the name of Cormack said to us, "I would rather live amongst smoke — it keeps me warm and comfortable." We called on an old man who was having a stone cottage built for him at Lord Gosford's expense; he said, "I would rather live and die in my old cabin; the mud walls are warm; it is the warmest hut in all Ireland. I like the smoke to come round me and warm me in my


---

p.158



cabin. I would rather live comfortably amongst smoke." The agriculturist was evidently mortified at his apparent want of success in teaching these poor creatures his improved husbandry, but their humorous expressions disarmed him of any angry feeling. And these are the men whom the great Earl of Gosford is endeavouring to induce, by better habits and improved agriculture, to raise themselves to a situation of comparative comfort. So far my hopes had been somewhat disappointed; but on further examination, I was fully convinced that the perseverance and skilful exertion of his lordship and Mr. Blacker had overcome obstacles with which common men would not have dared even to contend. Upon hundreds of such men as Lennon, and even worse, did Mr. Blacker commence his benevolent operations. Some of the small farmers who had followed his instructions, told us they were "clearing off their debts and becoming independent;" that previously to his assistance they could not have a cow, but that now they had a cow or two, and supplied themselves with butter and milk, and cured half a side


---

p.159




of bacon. They could make their rent from their butter, and have the rest of the produce for themselves and families.


The following is the course of crops and management that Mr. Blacker recommends: — 1st. Potatoes or turnips. 2d. Flax or wheat, sown with clover and grass seeds for mowing. 3d. Clover, mown. 4th. Oats. The old plan, pursued by many at present, is to have potatoes, wheat, and oats; it is not a barley country, but, when sown, barley takes the place of wheat or flax. The usual produce is, of wheat 17 cwt.; oats 17 cwt.; barley 18 cwt.; tares 17 cwt.; turnips occasionally 40 tons; potatoes 8 1/2 tons. Some of the farmers doubted the advantage of turnips over potatoes. Rape is especially recommended by Mr. Blacker, and is uniformly praised by all who have been induced to give it a fair trial. They found it material to sow the rape as soon as possible after the grain crop comes off; some even remove the grain, as soon as shorn, to another part of the land; then manure the ground, and sow rape immediately; it is ready for cutting



---

p.160



by the 1st of April. A week in August is worth the whole month of October for obtaining an early crop. Clover and tares supply food after rape, from the middle of May to the middle of October. Turnips, or potatoes, and cabbages, with a little hay or straw, constitute the winter food from October till April. By this excellent system the cows are bountifully supplied with a variety of wholesome and succulent food during the whole year. The mildness of the winters in Ireland is favourable to the growth of these plants, and enables the farmers to cut them early. Flax is an excellent nurse for clover, when sown amongst it; one stone of clover seed is sown per acre; the clover frequently produces three good crops during the season, in consequence of the care taken by the farmer or his family to supply a small quantity of ashes or light manure after cutting. Their little stock of hay is made by the shading process, putting it in lap-cock, (that is, wrapping or curling an armful up to resist the wet and admit the air, and resting it on the smallest base possible) as soon as they can, and 



---

p.161




not letting it be much exposed, which is far preferable to allowing its juices to be exhausted by the heat of the sun. Mr. Bruce informed us, that some of the farmers opened the furrows for potatoes and turnips, and deposited the manure in them during the winter; thus allowing the seeds of weeds contained in the manure to vegetate, and be destroyed by harrowing, previously to the potatoes or turnips being sown in the spring following. By this practice the manure was also more decomposed, and mixed with the soil, and the labour performed at a leisure time.


On further examination of farms we met with numerous and most satisfactory proofs of the advantages resulting from Mr. Slacker's endeavours to improve the condition of the people. The following are a few of the instances, as stated by themselves in public.


James Lennon, the tenant previously mentioned, though not a bright specimen, gave the following account of himself. He was formerly tenant to Col. Graham, and when he became Lord



---

p.162




Gosford's tenant four years ago, he owed £15, and had sold every thing he had, except his cat and dog. Lord Gosford having purchased the estate on which Lennon was previously farmer, Lennon gave a note to Mr. Blacker for the arrears, and told him he should be able to pay the debt by means of honest industry. Mr. Bruce, the agriculturist, encouraged him to hope for a loan of money from Mr. Blacker for the purchase of a cow. Mr. Blacker lent him £2; he found the rest himself, and bought a cow for £3. 10s. He lived on potatoes, and was glad to have them; he had one loom left, and hired another, and his two sons weaved and worked hard. Mr. Blacker lent him also 35s. worth of lime, without interest. Three years since he got a loan of £1 to buy a pig with, after having repaid the £2 for the cow; he had likewise paid £10 towards the arrears. He made £5 from the butter of one cow in 1834; she was fed on turnips, clover, and rape, in the house. He still owed £5 of the arrears, and one year's rent; had two good pigs and some flax, and thought he could clear off all his debt in November. He



---

p.163




had six acres of land at a rent of 22s. per acre. Mr. Blacker provides rape and turnip seed gratis; his farm, he said, was in a much better condition than formerly, and he had twice as much manure as he used to have.


*Thomas Grant*, when he became a tenant of Lord Gosford, owed one year's rent, and gave a note for £6, which he since paid off; he had then no cow, but borrowed money to buy one; he paid for the cow, and when I saw him, had two cows and one horse; he purchased 5A. 2R. 1P. of land (that is, the tenant-right) for £30, and had paid all the purchase-money. His success he attributed to growing green crops and stall-feeding his cows; turnips he found a useful but an expensive crop, and never had less than half an acre or three roods. Mr. Blacker does not insist on turnips being sown, but leaves it to the farmer's discretion. He (Grant) would not have come to the property he had attained had it not been for the assistance of Mr. Blacker. By the stall-feeding and green crops he was able to keep more stock, and could have better crops of grain. His land


---

p.164




was light, and he found no crop more profitable than clover, and could keep his ground in much better condition by the use of it.


*James M'Parlane* gave a note for his debt of £10. The benefit derived from Mr. Blacker's system had enabled him to pay it off; he had, however, borrowed money for lime and seeds, but could be clear in November; his ground was formerly poor, but was then in good condition; he could keep three cows in the house for two on the pasture. He possessed six acres of land, and hoped to go on without borrowing.


*John Hogg* contended that three cows might be kept on green food cut for them, where only one could be kept on the same extent of land pastured.


*Mr. Bruce* asserted that one acre served three cows.


*Mr. Black* said, that they are all improved by Blacker and Bruce's assistance; he sowed clover amongst wheat, and it did well.


*Mr. Beck* has generally four cows and one horse on eight acres, and has as much grain as



---

p.165




formerly. Many pursue the new system; to follow it properly, requires a capital equal to £4 per acre.


*Hugh Marshall* has twenty acres; he stall feeds, and thinks it the best; he keeps four cows and two horses.


*Mr. Thompson* of Greyhillan has eleven acres; keeps two cows, one heifer, and one horse; this stock he keeps in the house on one acre and three roods of clover. Formerly, when he had less stock, he devoted three acres and two roods to them. He had, the last year, saved a small stack of hay.


*Mr. Kenovan* said that his cows each gave fourteen quarts of milk per day for three months; and that he had not two perches of waste land on his farm; the change had been more in his favour than if he had managed his farm under the old system, without paying any rent.




---

p.166


Drumbanagher — Colonel Close — Results of Mr. Blacker's system — Mr. Bacon — Dungannon School-lands — Dr. Richardson — Charlemont — Moy — Coal Island — Visit to Dungannon School-lands — Extent — Cabins upon the estate — Rents — Exertions of Mr. Blacker — Lord Charlemont's estates — Francis Quin's farm — Admirable consequences of Mr. Blacker's system — Flax — Examination of Fews — Lord Gosford's school — Draper's Hill — Moyallen — Society of Friends in the neighbourhood.
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


In company with Mr. Blacker we visited Col. Close, who is becoming, under the able advice of that gentleman, a spirited improver. On his estate at Drumbanagher is a magnificent villa of the pure Italian style, in the design of which the architect, Mr. Playfair, of Edinburgh, has displayed consummate skill. It is surrounded by gently sloping ground of great extent, adorned with plantations and stately trees. The terraces and lawns are ornamented with water, and parterres



---

p.167



enriched with the gayest flowers. From this splendid mansion a striking effect is produced. The gentle slope is terminated by a sudden and precipitous descent; and the eye, unconscious of a deep and wide-spreading valley that intervenes, is carried to the richly cultivated land at the foot of the noble mountains that bound the view.


Colonel Close has a large establishment, over which he presides with paternal care. From twenty to thirty servants joined the family at morning and evening prayers. This excellent individual has the good fortune to possess a valuable agent in Mr. Blacker, under whose directions he is adopting the agricultural plan so successfully pursued on the Gosford estate. Several of the tenants I saw: they were confident of success.


Mr. Bacon, of Richhill, who has also adopted Mr. Blacker's system, has a Scotch steward, a Mr. Anderson, who has accomplished much by instructing the tenants. Mr. Bacon gives them premiums for good management. Four years ago there were only three competitors for his premiums; last year they amounted to 295, proving


---

p.168




the rapid march of improvement in a short time. He gives thorn quicksets to the tenants for fences, and sometimes is at the expense of raising new fences, the tenant throwing down the old ones.


Mr. Blacker has introduced his improved system on the Dungannon School-lands in the county of Tyrone, consisting of about 3,000 acres of property, and notorious for the misery and disorderly conduct of the inhabitants. He applied for the agency of this estate, which is an endowment of the School of Dungannon, for the purpose of trying how far the principle he advocated in his Prize Essay on the management of landed property in Ireland, might prove effectual in reclaiming both the land and the inhabitants.


We accompanied Mr. Blacker to these School-lands. On crossing the Blackwater River near Fort Charlemont, on our way, we were not far from the farm of the late Dr. Richardson, of fiorin-grass notoriety, with which few agriculturists of any reading are unacquainted. The Doctor's great partiality for this grass induced him to designate it in his writings *his mistress*.




---

p.169


At Charlemont is a large fort, but only a small force of artillery is stationed at it. The town of Moy, on the north side of the river, is a place of some trade, and is approached by a wide and steep street, on each side of which is a row of fine elms.


Coal Island, through which we passed, can boast of coal pits and a spade manufactory, and has the advantage of a canal from Dungannon to Lough Neagh. By this navigation coals are conveyed from Coal Island, and timber and other articles returned.


Mr. Griffith, in his geological and mining survey of the Tyrone coal district, observes, that the Coal Island coal district is six miles long, from Mullaghmoyle, on the north, to Dungannon on the south. Its average breadth is about two miles, therefore the total extent may be about seven thousand acres. The Coal Island district is in the form of an oval. Its strata rest upon limestone; the dip, in all the places where it is visible, is from the edge towards the centre of the district,



---

p.170



which in this view may be considered as a mineral basin.


The Tyrone coal district (including, in addition to the Coal Island basin, the Annahone coal, of three hundred and twenty acres) is of trifling extent, when compared with the great southern and western coal districts of Ireland, but is superior to them in the thickness and quality of its numerous beds of coal.


In the immediate vicinity of the village of Coal Island, there are seven workable beds of coal, amounting in the aggregate to 34 feet of coal; in a depth, from the surface, of 244 yards 2 feet. The fine clay of the Tyrone district occurs immediately beneath the beds of coal.


The country between the Collieries and Lough Neagh contains white potter's clay, of great superficial extent, and unknown thickness.


On first entering the School-lands at the south end of Lough Neagh, the quality of the soil was good, and the crops were flourishing; but further towards the east is a tract of poor white sand



---

p.171



mixed with bog. The farmers have small parcels allotted them to improve, on which they grow cabbages and turnips; fortunately for the cultivators of this light soil, there is a bank of clay not far distant. Mr. Blacker purposes having a boat to convey the clay more readily across and along the side of the Lough. We passed over the bog to an island called Roskeen, where we found excellent wheat, oats, and green crops. This land is tithe free, and the rent is 23s. per acre.[7](javascript:footNote('E830001-002/note007.html'))


The Dungannon estate contains a large tract of bog, which invariably attracted a number of poor settlers, in consequence of the cheapness of fuel. Before the introduction of the new system, the arable land was occupied in little detached patches. Mr. Blacker began by breaking up the clusters of old mud cabins, and insisting upon each person taking up his residence upon the land allotted to him, in a square holding, averaging



---

p.172



about four acres for each family. The cottiers, or under tenants, were allowed to build on small edges of the bog which were reclaimable, and had a little assistance rendered them. A hundred and fifty comfortable houses have, I believe, been built. The people, no longer crowded together in hamlets, are deprived of some of the causes which formerly led not only to disputes among them, but to the general corruption of their manners; and the magistrates at the sessions have had occasion to remark that fewer cases of disturbance and complaint have come before them since the adoption of the new plan. Some houses are in process of building; others have one bay or room already finished, and are preparing for an additional one; and some of the cottiers have small comfortable looking cabins. The land is evidently undergoing great improvement; cabbages and turnips were growing upon poor sand, and on the poorest bog. This poor sand is let to cottiers at 4s. 9d. to 6s. 9d. per acre, the raw bog at from 2s. to 4s. 6d. per acre, in plots of from 1 1/2 to 3 acres, and they consider it a great favour to possess this



---

p.173




barren land on these terms, and with the assistance of clay and the manure from their stall-feeding, make it worth from 20s. to 25s. per acre. Though at first averse to the alterations made by Mr. Blacker, they are now contented, and look forward confidently to better prospects. I have no doubt, that in a short time this estate, instead of being what it was formerly, distinguished for the misconduct and misery of its inhabitants, will be a pattern of comfort, and peace, and successful cultivation.


It is truly gratifying to observe the improvement extending through the country in consequence of the active exertions of Mr. Blacker, who, persuasive, enterprising, firm, and persevering, is well fitted for the noble task he has undertaken. Indeed, no adequate estimate can be formed of the value of his exertions. After a careful examination of these farms, I am fully convinced of the practicability of managing them on his system, with advantage to the owners, the tenants, and the country. If the plan were generally adopted, it would provide employment


---

p.174





for all the labourers in Ireland, and convert it into a peaceful, prosperous, and happy country.


That low rents and indulgence will not produce the desired effect, may be inferred from the fact that the estates of Lord Charlemont, though let much lower than they might be, and though the arrears incurred upon them are continually remitted, are incomparably worse managed than those of Lord Gosford which adjoin. The farmers, moreover, are less comfortable on the former property; yet Lord Charlemont is accounted one of the best, as he certainly is one of the most indulgent, of Irish landlords.


*Francis Quin*, on the Dungannon School-lands, has 2A. 2R. 5P. of arable ground, two roods of which have been reclaimed since May 1834; he has also 1R. 22P. of water meadow, making in the whole 2A. 3R. 27P. In May 1834 he had the following stock, viz. two cows, one horse and three pigs; in April 1835 he sold one cow and bought an additional horse; in January 1835 he sold one pig, and kept the other two till June; he has a family of ten, which, together with his



---

p.175



stock, has been kept on the produce of the farm, with the exception of 8 cwt. of hay which he purchased, and a small patch of clover for his horse, which cost him 8s. only. Of the numerous farms under Mr. Blacker's management, the last was particularly worthy of attention, and from what I saw I fully believe the tenant's statement. The manure arising from his housefed stock increases the produce wonderfully. This man gets a double crop every year. Immediately on getting up his potatoes, or shearing his crop, he sows winter tares, or rape, on part of his land, and, by manuring it well, is enabled to mow this crop early in spring. His winter tares or rape being mown in April and May, he plants potatoes, or sows tares or turnips, which are followed by barley; clover is sown in the barley; and having a plentiful supply of manure at command, he is enabled to give the clover which he mows, a top dressing between some of the mowings. The result is, three good crops. He plants cabbages in every vacancy, in the furrows, and the hedge-side; and these, with the


---

p.176




addition of turnips, supply the cattle during the winter. The rape is ready by April, and lasts six weeks; next come his winter tares; clover and summer tares which last till turnip time again. His wife and children chiefly manage the farm, he and his horse being employed in carting for hire.


I could not help regretting, when I encountered so much misery during my subsequent journey, that this system was not more generally adopted. If poor laws had been in operation previously to these cottiers being thus settled, they would all undoubtedly have become a burden on the parish; but by the means pursued under Mr. Blacker's plan, they are enabled, not only to provide competently for their families, but to increase the rental of the estate. The Dungannon estate I consider a practical confirmation of every thing Mr. Blacker advances in his "Prize Essay," and a complete proof of the facility with which a surplus population of any district, in which the ordinary bad husbandry has prevailed, may be located on an adjoining reclaim able land, at a trifling expense,



---

p.177



and with manifest advantage to the country. The numerous accounts of extraordinary produce on the farms which I examined, supply conclusive evidence of the utility of the system, and the manner in which it would tend, if extensively practised, to the general prosperity, by affording profitable employment to all the idle hands, and abundance of food and clothing at a cheap rate. By means of Mr. Blacker's plan, a farm of three acres is made to yield as much as one of ten under the old system.


More flax was grown this year than formerly. The steeping was in full operation, and not a single spot in this part of the country was free from the strong effluvia which attends the process, and which at first I felt to be exceedingly offensive. To this unpleasant smell, however, considerations of general advantage soon reconciled me. The flax remains from six to ten days in the stagnant water, in which it is kept down by sods or stones, and ragweed. After being taken out, it is spread on the grass, and frequently turned. If possible, it becomes more putrid and scents the


---

p.178



whole atmosphere. When sufficiently exposed to destroy the woody or worthless part, which may require a fortnight or three weeks, depending on the weather, it is then set up in small sheaves in the field to dry, and afterwards stacked, to be ready for the in-door operation of the farmer at a leisure time. Many small sod buildings, left open at the top to serve as a stove, or, as the farmers term it, a skey, are built by the sides of the fences near the cabins; they are four or five feet in diameter, and have a hurdle of sticks placed across them at a convenient reaching height (four feet, for instance) on which a small quantity of flax is spread to dry upon the hurdle over a turf fire. The next process is beating the flax with a mall, to break it, which process we frequently observed going on in front of the cabins and in the streets of the villages; it is afterwards scutched, the more completely to break the woody parts and get rid of them. This has often latterly been done by machinery (the breaking it, by fluted rollers, and the scutching, by revolving wooden knives), but many still do it by hand; and, in passing through the 



---

p.179




country, it is a source of amusement to see, under a grotesque hovel scarcely large enough to contain them, three or four rosy-faced girls scutching with all their might. This employment appears always accompanied with cheerfulness, and, not unfrequently, with a good-humoured joke for the passer by. The flax was a good crop; and according to the expression used by them, "it would set them on the pig's back," that is, enable them to eat part of their pig instead of selling it. The produce of flax is generally about from thirty to thirty-five stones per acre, which at 10s. is from £15 to £17. 10. per acre, but this is a high price. Some sow seed of their own growth instead of purchasing, but the flax is not of so fine a quality. Flax gives a heavier crop when the seed is not allowed to ripen.


Ireland, from the peculiarity of its climate, appears to be well adapted to the growth of flax. The heat is less scorching than in England, the sun being oftener obscured by clouds; and soft refreshing showers, favourable to luxuriant vegetation, frequently fall. Every encouragement



---

p.180



should be given to the cultivation of flax. It affords abundant employment, both in its growth and its future preparation for the manufacturer — is very profitable — is an excellent nurse for the clover — and occupies the attention of the farmer when he is not engaged with other crops.


Mr. Rennox, steward to Dr. Blacker, in the Newry paper of 1836, gives some directions respecting the growth of flax, which are deserving of notice, not only as regards his judicious remarks, but on account of the great profit derivable from a crop of this valuable plant. I may mention here, on the authority of Mr. Bruce, that when a tenant is poor, and has an acre or two of land, he lets part to grow flax for £5 in hand, to pay his rent with: this is called the "dead horse." Dr. Blacker has let land to grow flax on at £5. 15s. per acre. Mr. Black sows two and a quarter bushels of flax to the acre, and from each bushel sown the produce should be from fourteen to twenty stones — say from thirty-five to fifty stones per acre, at 10s. per stone, which would be from £17. 10s. to £25. This is considered a very



---

p.181




good price. From £5 to £7 per acre is given for flax ground ready for sowing after potatoes.


The examination for the barony of Fews Lower, in the county of Armagh, which contains 33,505 acres, including 3940 acres of water, commenced in the Court-house, in Market-hill, on the 12th of August, when it was stated that the number of labourers in the barony, according to the population return of 1831, was 1713.


In the opinion of the most intelligent persons at the examination, the number of labourers continues nearly the same; and there was a general impression that the linen trade had improved, and that the weavers as a body were better off than they had been for some years. We did not, however, see any reason for acquiescing in this opinion. Under the present system, a few capitalists give out the yarn to be worked by the weavers up and down the country, and pay them wages varying from 8d. to 1s.3d. a day, according to their skill, while the profits of course go to the employer. Formerly, the weavers were able to purchase the yarn themselves; and thus, besides


---

p.182



their wages, enjoyed the profits from the finished linen. In spring and harvest time, including four months, all the labourers are employed; and throughout the rest of the year, about one-fourth, occasionally. Employment has decreased of late years. All the labourers present agreed that "one week with another they got, from year end to year end, about half work" — and all expressed themselves not only willing but desirous to labour, if employment could be obtained. Some of the labourers are dispossessed tenantry. They regretted the change in their condition, and remarked, that "the wee bit of land is a place of refuge. A man may get sick, and if he has the little farm, why he can work on some way or other; but if he is trusting to his day's labour, then better be dead at once." When short of work, they manifest a very kindly feeling towards each other, and are in the habit of rendering mutual assistance when requisite. We were glad to learn that no combinations had existed among the labourers to prevent the employment of strangers, nor had the engagement of 



---

p.183




them been attended by any acts of violence. "It is but justice to say," remarked the Rev. Dr. Blacker, "that they are most humble people."


Here, as in the previous baronies, marriage is contracted at a very early period of life: one of the witnesses told us, that he knew a man, the joint ages of whose father and mother, on the day of their marriage, *did not amount to thirty-one.* A man who has no wife and family, is far less highly esteemed than one who possesses both.


Women are employed for a short time pulling flax, for which they get eightpence a day near towns, and sixpence in the country. They receive also sixpence a day for shearing, in harvest. The wives of labourers can sell nothing but a few eggs or chickens; and some of the farmers will not permit them to keep fowls, for fear of injury being done to their corn fields; what a labourer's wife can make by them is not worth mentioning. She sometimes manages to scrape together a few eggs, and exchanges them for "a bit of soap, or a grain of tea."




---

p.184


On making inquiry as to the expenses of marriages, christenings, wakes, and funerals, we learnt from Barney Halley, who collected for the priest of his district, that a marriage costs from seven to ten shillings, and from that to a pound, besides 3s. 4d. for the license. At a christening, for which there is a gathering, there are five or six quarts of whiskey, and 2s. 6d. for the clergyman. At wakes, for old inhabitants, whiskey and tobacco are supplied; but if the subject be merely a labourer, tobacco alone is used.


A labourer's family, consisting of a man, his wife, and four children, consumes weekly two cwt. of potatoes, value two shillings and sixpence; milk, one shilling; herrings, sixpence; soap and salt, sixpence. Threepence a week, at the least, may be put down for tobacco; many labourers use five-pennyworth. Groceries are used here in very small quantities. Twopence a week was stated as sufficient to cover this department of domestic expenditure. "The labourer is very well off," said a witness, "if he gets *praties* and a drop of milk." "Aye," another added, "and blue milk



---

p.185




too, which, if you threw it against the wall, would not colour it."


The priest receives from the farmers four shillings, and from labourers two shillings a year; one being paid at Christmas and the other at Easter, If they cannot afford this, sixpence is paid. "The priest here is kind." Although there are twenty-five whiskey shops in Market Hill, the population of which is only 1040, it was the general opinion that these pernicious establishments are decreasing. There is certainly but little drunkenness among the labourers. Not many women drink, "but still," said Barney Halley "they don't hate a drop." "If a labourer is cold" said another witness, "a *Johnny*[8](javascript:footNote('E830001-002/note008.html')) won't do him harm; and if he is in a heat, it is not the first thing that will hurt him."


The clothing of the labourers is very bad indeed; "they are ill covered." They buy old second-hand clothes at Armagh and Newry, and wear them several years. The cost of clothing for


---

p.186




a labourer's family, consisting of himself, his wife, and seven children, supposing him to have what is necessary, was estimated at £3. 13s., viz. his own, £1. 13s.; his wife's, £l.; that of the children, £1.


Almost all the cabins contain bedsteads; indeed, two or three years ago, Mrs. Blacker, the lady of the Rev. Dr. Blacker, distributed among the poor of her district between a hundred and fifty and two hundred.[9](javascript:footNote('E830001-002/note009.html')) The father and mother, and a couple of children, usually sleep in the same bed: "heads and thraws." The floors of the cabins are made by digging up the ground, and then trampling it into a solid consistency; "when this is to be done," said *Captin* Atkinson, "they sometimes have a dance for that purpose, hav'nt they Barney — "Yes sir," said Barney, "and many a match comes out of a thing of the sort."


The labourers suffer greatly from the scarcity and dearness of fuel. Turf is mostly used; a cartload



---

p.187




costs from three to four shillings in winter; "but to say the truth," exclaimed Pat Campbell, "we send the children out to collect any thing they can to boil the pot." On being asked whether he would send his children out to take from the farmer's hedges, this witness replied, "aye, and from his turf stack, too; would you have us to go to bed without our supper — Sometimes we have to burn the beds from under us." Another witness assured us that he had not only burned the straw off his bed, but the roof of his pig-sty, and a stool or a chair, adding, "oh, Sir, you don't know what we have to do sometimes for the want of the fire!"


Mendicity is very common in this part of the country, and is not confined to those who are in actual want. We were informed by one of the witnesses, that he knew a beggar who said he could give his daughter £30; another beggar had several sums of money out at interest. In rough weather they frequently stay with the labourers and small farmers for a few days or a week, and amuse the family over the fire, sometimes till



---

p.188




three o'clock in the morning, with news and tales of their adventures. They carry disease from house to house, and corrupt the morals of the children.


The only pawnbroker in the barony lives in Market Hill, and his business must be a thriving one, for "every thing that can be mentioned," said one of the witnesses, "is pawned." Such is the attachment of the people to this ruinous system, that the Rev. Mr. Atkinson was of opinion that if small loans could be obtained, upon the deposit of pledges, as now, but upon more moderate terms, and without the present secrecy, though the institution might be encouraged, many would still frequent the pawn-office. The competition for small holdings is very great, and causes the incoming tenant to bid a price which he is little able to pay. There is, however, in this neighbourhood no connexion whatever, direct or indirect, between crime and the taking of land, or the paying of tithe, or other charges affecting land. No persons, accordingly, need be deterred from investing their capital in farming, or other occupations,



---

p.189



on these grounds; nor could we learn that any had been induced to withdraw themselves and their capital from the vicinity in consequence.


The average size of farms is about eight acres: there are few so large as twenty. Out of fifteen hundred tenants on the Gosford estate, there are not more than sixty or seventy who hold such. The general opinion of those present was decidedly in favour of small holdings, which, in consequence of the adoption of Mr. Slacker's system, are greatly improved of late years — one acre now being worth three formerly. "Small farms, if judiciously conducted, yield comparatively a greater produce than large ones; spade husbandry may be applied advantageously upon them; the farmer is enabled to collect more manure in proportion, in consequence of his family being on the look out for it; and he can keep more stock relatively, and cultivate more cheaply." "No part of the small farmer's land," said one of the witnesses, "is left untilled — not the breadth of your hand can they afford to let be idle." "If I had 100 acres," said Mr. Bruce, "I would divide



---

p.190



it into ten farms, and should get more money for it in that way." Some witnesses were of opinion that thirty, others that forty acres, was the best size for a farm; but all concurred in objecting to the consolidation of holdings. "Under such circumstances," said one of them, "where are the people to go — "


Almost all this barony is held direct from the proprietor in fee, and generally under lease. The chief part is held by a few great landlords, who either reside or visit it occasionally, their agents being resident. The rent is from twenty to 24s. per acre; the tithe 1s. 8d. and the cess 2s. 4d. per acre per annum. The cess, as in other baronies, is extremely unequal. Coals are from 14s. to 26s. per ton, and lime 10d. per barrel of four bushels.


The barony is nearly all under tillage, even in the mountains — not one-sixth of a farm being left for pasture. During the last few years, agriculture has made great advances in the county of Armagh, particularly in the barony of Fews Lower. This advance is mainly attributable to the skill and exertions



---

p.191




of Mr. Blacker, who introduced the system of green crops and stall-feeding — in opposition to the very injurious practice of taking several successive crops of grain. The production of food, under this system, will more than keep pace with the increase of population, and will afford employment for all the labourers who can obtain a small portion of land. On an inspection of various small farms, I ascertained that a man could maintain and employ his family on four or five acres; and pay his rent of £1 per acre from the sale of butter — leaving his grain, potatoes, and other produce, for the subsistence of his family, and for other incidental expenses.


**Red clover** and **Pacey's perennial rye-grass** are almost the only articles of grass-seed sown in the lower parts of the barony. On the moory ground near the mountains, where the land is worth seven or 10s. per acre, what is called "white grass" (**holcus lanatus**) is preferred. The pasture lands in many parts of the barony and country are overrun with rag-weed (**senecio jacobea**), in part attributable to the absence of sheep, who eat it


---

p.192




with avidity when young. This plant is sometimes used for covering the flax while steeping; pig-sties are also thatched, and cows bedded with it; it is also thrown into the dung yard. A much larger quantity of flax than had been known for several years was grown this year, in consequence of the advance in price from eight to twelve or thirteen shillings per stone of sixteen pounds. This increased growth of flax happily provided employment for the labourers and women, during the usually vacant time of the year.


The cattle exhibited at the various fairs were of an inferior description, principally of the old Irish breed. The cows, when in good note or milking, give from 14 to 16 quarts a day, and from 100 to 112 lbs. of butter in the year; they are a flat-ribbed, narrow-backed, slow-growing, and slow-fattening race. The superiority of the produce over some other districts is to be attributed to the full supply of green food which is given to them. The horses, though rather small, are active and useful animals. The breed of pigs has undergone considerable improvement. The



---

p.193



few sheep that are seen are of the Irish breed, with long legs, and flat thin sides. The addition of a few Leicester sheep to the stock of the small farmer, in the proportion of perhaps one to the acre, would be a great acquisition, and another step in the advance of agriculture so happily taking place in this district. They might be netted on the rape or clover, in the manner adopted in England, or be kept in sheds, and eat such parts of cabbages and other plants as give an unpleasant taste to the butter.


Many of the inhabitants of this barony have emigrated, and if a free passage to America were afforded, many more would go. Within the last twelve years numbers of girls have gone as servants; they get six or eight dollars a month in Quebec, St. John's, and Montreal. They embark at Warrens-point, fourteen miles off, and at Belfast, thirty-two miles distant. The Roman Catholics, who outnumber the Protestants, have not emigrated to any considerable extent.


Lord Gosford educates upwards of a hundred children of the neighbourhood. They are Protestants,


---

p.194



Catholics, and Presbyterians, but are instructed by a Protestant master, and use the Protestant bible entire. They are principally his tenants' children, and I did not find that the parents objected. They are permitted to take the bible home with them.


I visited the school, which is a beautiful building, surrounded by a garden, in which roses and other sweet flowers and beautiful shrubs abound. The scholars are taught writing, reading, grammar, and accounts. Some of the boys evinced great quickness in answering the various questions proposed to them. The girls are now generally instructed in needle-work.


Education is making rapid progress here. There were stated to be five hundred scholars now for one formerly. Lord Gosford supplies schooling, pens, ink, &c, free of charge; in other schools, a charge of a penny or twopence a week is made. It was gratifying to meet so many children on their way to and from various schools. The extension of education, which is happily taking place, promises a beneficial change in the habits


---

p.195




and manners of these naturally quick and gifted people.


On the site of his former mansion Lord Gosford is building a baronial residence, under the superintendence of Mr. Hopper, the architect. Though far from being finished, it has already cost about £80,000. The battlements and corbels struck me as being too light, and the arrangement in some parts appeared rather cramped, but the situation is good, and the grounds are well wooded. Many new plantations have been added, but there is not much large timber. Not far from the castle is the Draper's Hill, where Dean Swift took his seat and exchanged wit with the passer by on the road.


Hamilton's Bawn, too, which we passed, not very far from Market Hill, is celebrated in connexion with the Dean of St. Patrick's — the ruins of an old building there, formerly a place of defence, and since used as barracks, being the subject of some of his poems.


At Moyallen, twelve miles north-east of Market Hill, I attended the Friends' Meeting, which consists



---

p.196



of thirty families. The Meeting-house is a clean neat building, very pleasantly situated in the lovely village of Moyallen, in the county of Down. I received some kind invitations, and dined at John Christy's, who has a sequestered and beautiful residence, shaded by fine lime trees, on the banks of the river Bann, which rises near our favourite village of Hilltown.


The country round Moyallen is surprisingly rich and beautiful. The gently rising ground was covered with grain, which, in the brilliancy of its golden hue, as it glittered in the sunshine, surpassed anything I ever saw. It was indeed almost too powerful for the eye. On the 16th of August some of it was ready for harvest, and on the 19th some was cut and carried. The rich verdure of the meadows through which the Bann flows, and the equally rich foliage of the woods upon its banks, formed a strong and delightful contrast to the fields of grain that waved on the sides of this fertile valley. The whole combined to form so truly enchanting a picture, that I irresistibly turned round several times


---

p.197




on leaving it, to gaze once more on the delicious scene.


The soil is excellent, and I enjoyed the novel sight of some rich grazing land. The neatness of the houses in Moyallen, covered with roses and climbing plants, together with the beautiful gardens and shrubberies, carried my thoughts to England. Such objects as these are not very frequently met with on Irish ground.


Many members of the Society of Friends reside in this neighbourhood, and before the change which took place in the manufacture of linen, were engaged extensively and prosperously in that trade. Not only here, but in other parts of Ireland, they are greatly respected, having contributed in an important degree to the social and moral improvement of their respective districts; an effect that is manifested in the neatness of the cottages and houses, and in the orderly and industrious habits of the people. This statement does not proceed from an undue desire to laud a society of which I am myself a member. I merely record a fact which in Ireland is universally



---

p.198



admitted; and I record it to show how much can be accomplished in the way of civilizing the poor and rendering them peaceable and happy, by the force of good example, and the exhibition of a uniformly kind and friendly demeanour.




---

p.199


Armagh — Archbishop's Palace — Fair at Market Hill — Basalt — Slieve Guillien — Belleek — Protestant Schools — Cairn on Slieve Guillien — Cabin near the mountain — Native Irish language — Monaghan — Tydavnet — Mr. Skelton, and cruelties arising out of a distraint — Examination of the barony of Monaghan — Want of Employment — Wages — Employment of women — Priest's dues — Spirit-shops — Sobriety of the people — Clothing of the labourers — Pawnbrokers — Remarks on the Irish people — Disturbance at the Examination — Threatening notices — Resident agents — Mr. Rose's Improvement Fund — Breed of cattle — Manure — County cess — Orchards — Emigration.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


After inspecting, in company with Mr. Blacker, several additional farms belonging to Lord Gosford, we proceeded to Armagh, and visited the ancient cathedral, which stands on the summit of the hill. It was undergoing repair, and receiving embellishment. The tower and spire were temporarily supported on wooden props, while fresh foundations were being laid; and it is extraordinary that they had only shrunk one inch during



---

p.200



the progress of this singular operation. Several curious relics were shewn to us — among the rest, a very ancient stone, with rude figures, representing St. Patrick receiving the keys from St. Peter, sculptured upon it. This cathedral was founded in the year 445 by St. Patrick, the first bishop, and is said to have been originally constructed of willows or wattles, like most of the primitive churches before stone and mortar buildings were in use. History informs us that Armagh was the most celebrated school for learning and theology, and was much resorted to by the Anglo-Saxons. Sir James Ware states the students at one time to have amounted to 7000.


The city stands on the river Callen; its population now is about 9200. The buildings are handsome, and the environs beautiful. The Observatory, Library, and many other public buildings (which I unfortunately had not time to visit) are highly spoken of. In some old parts of the town the streets are narrow, and the houses nothing better than filthy hovels. Beautiful marble, of various colours, and susceptible of a fine


---

p.201



polish, is obtained near Armagh. I was disappointed in my wish to see the Archbishop's Palace, for the grounds are so effectually surrounded by high walls and closed doors, as to prevent the possibility of even a passing glimpse from the public road. Every civility, however, is shewn to strangers, and had I solicited admission, I should have had no difficulty in obtaining it. Within the episcopal domain is an obelisk of marble, 114 feet high, erected by Archbishop Robinson for the purpose of employing the poor. He also built the palace, three churches, and the parish school, and endowed the Observatory at his own expense.


At a fair at Market Hill, held on the 21st of August, we saw a young bull (the best in the fair), a year and a half old, with a cross of long horn, which was priced at £2. 4s! Cows, nearly all of the Irish breed, are valued at from three to £6. Lord Gosford possesses a fine young bull of the Durham breed, which is likely to improve the stock. On Lord Gosford's estate we inspected some Italian rye-grass, the stalks of 


---

p.202



which were four feet long, very succulent and leafy, and likely to be of abundant produce.


In the course of my walk through Lord Gosford's grounds, I was surprised to find a bed of basalt of curious formation; the labourers were breaking it for the roads. The upper strata resembled cannon balls, or soldiers' loaves of various sizes, enveloped in a softer mass of a burned appearance, and seemed to have been in a state of fusion, corroborating the opinion as to the igneous origin of basalt; below them was the more solid rock; and lower still, Mr. Blacker informed me, the stones were similar to the pillars and joints of the Giant's Causeway, which he believed crossed the island here. A man began to clear away the superincumbent matter, for our inspection of that beneath, but we had not time to wait the result. The stone is mixed with trap, resembling large hailstones.


Not having seen what are here termed the mountain-farms, we travelled up the high grounds beyond Belleek, near the Tully Galleon and Fork Hill Mountains, with the intention of examining



---

p.203



several of Lord Gosford's farms in that neighbourhood, as well as some belonging to other proprietors. The famous mountain Slieve Guillien, near Belleek, is too interesting an object to go unnoticed. Belleek, I may observe en passant, is a small town of one street, situated at the base of the mountains, and was once a place of consequence. A large fair was formerly held there, but the "country boys" evinced such a boisterous disposition, and fought so desperately, that it was obliged to be discontinued. Having passed the mountain house and Leslea Chapel, we put up our horse at Mullabran School-house, the master of which appeared a superior man. He informed me that four Protestant schools were established in the neighbourhood, free to all parties, but that the priests objected to the Catholic children attending them. Here we engaged a guide (who, according to custom, professed to know every thing relating to the mountains), and commenced our ascent by a very rugged path — enlivened, however, by innumerable plants of the heather (the flowers of both the


---

p.204


**tetralix** and the **cineria** being perfectly white) and refreshed by the fruit of the bleaberry, which grew there in great abundance.


On gaining the summit of this mountain I was indeed richly rewarded. The cairn which renders it so celebrated, instead of being a mere rude heap of stones, as I had expected to find it, contained a circular chamber, with which a passage under long flat stones communicated; but of what length this passage has originally been, it is difficult now to ascertain, as it is filled up with earth and stones, which obstruct any further progress to what is supposed to be a large apartment. The entrance, which is now filled with rubbish, appears to have been covered with a roof of large stones, capable of supporting a great weight. The cairn of stones, which has covered the chamber, is nearly 40 feet in diameter at the base. A little lower down the hill, and in front of this cairn, is a flat stone supported by many uprights' and has the appearance of a cromlech. The mountain is of primitive formation, and composed of granite argillite. Its summit commands a



---

p.205




most extensive view. Newtown Hamilton, Rathfriland, Rostrevor, the Bay of Dundalk, Castle Blaney, Ravensdale, Jonesborough, Forkhill, and old Barracks, Lough Neagh, Camloch, and several of the Monaghan Lakes, were visible; and the county of Armagh seemed almost one continuous patchwork of corn fields, ripe for the harvest.


The mountain is cultivated as near its summit as food for man will grow; and the potato and corn fields are in some places so steep, and apparently so perpendicular, as to resemble, when viewed from the road, pictures in square frames hanging against the walls of a room. Slieve Guillien, and the lake near the summit, afford fruitful materials for the romantic tales of which the Irish are so passionately fond. On the side of the hill are bold rocky cliffs and caverns, formerly the safe retreat of robbers, who plundered the surrounding country at their pleasure. Of these, Redman O'Hanlan was pre-eminently distinguished for his nightly maraudings, and was long the terror of the neighbourhood.


On returning from Slieve Guillien I visited a


---

p.206



humble cottage in which were a woman and her children; the woman stated that her husband was gone to reap the harvest in the fens of Lincolnshire, from whence she expected he would bring something to pay the rent. She kindly invited me to a potato, which I as willingly accepted; seats, however, there were none. The cabin had neither window nor chimney; a small hole served the purpose of the latter, but the smoke, after filling the cabin, for the most part issued from the door. So sensibly were my eyes affected by this obscure and unusual atmosphere, that I could not for some time see the objects around me. At length, however, I discovered that the room was about 12 feet square; and on inquiring where they slept, a corner of this confined place was pointed out to me, in which I saw a few rags that served as bed-clothes. On the opposite side of the fire was a row of stones, intended to mark out the extent of the heifer's bed. These poor people rent one acre and a half (Irish measure) of mountain land, and a like quantity of bog from Major Barrett (to whom the west side of the mountain belongs)



---

p.207



at a rent of 10s. 6d. per acre. This little farm was lately in the hands of a middleman, to whom they paid at the rate of £1. 11s. 6d. per acre for the mountain land. During my conversation with this poor woman, a large party of women and children, attracted by the novelty of a stranger's appearance, had good-naturedly collected round the cabin, and I had the satisfaction of hearing, for the first time, the Irish language spoken by natives. Some animated discussions were carried on — many of the speakers not knowing a word of English. Notwithstanding the privations which these poor creatures endured, it was delightful to see them as cheerful and as happy as if they were living in the midst of English plenty, and I felt with what truth the **poet** had spoken when he said —


> 1. Still to ourselves in every place consign'd,
>   
> Our own felicity we make or find.
> 




On the 25th of August we left Market Hill, and again passed through Armagh, Pat driving tandem. That part of the county of Monaghan through which we travelled, was very inferior to Armagh,


---

p.208




and contained a considerable quantity of bogland. On our arrival at the county town of Monaghan, we took up our quarters at the Westenra Arras, kept by Mr. Curran, and called, by way of distinction, *the Hotel.* Here we stopped, and found very comfortable accommodation. The Jail, as usual, is an enormous building, and cost £20,000. It is truly horrifying to come within view of these terrible buildings; they are rendered doubly terrific in appearance, from having a sort of iron cage in front, from which are suspended a long iron bar with figures of a death's head and cross-bones, rendered still more conspicuous by being painted black and white.


Tydavnet was decided upon for the place of examination, and a room was obtained in a house occupied by a Mr. Skelton. On entering it I observed a brace of pistols lying on the desk, and found on enquiry that the family durst not either remain in the house or go out of it unarmed. The windows, too, were barricaded with iron bars, and the police were in plentiful attendance, a police station having been appointed



---

p.209



hard by, for the special protection of this family.


In the course of examination the following facts were stated, viz. that Skelton was the land agent of Henry Mitchell, Esq., and that the animosity excited towards him arose out of some proceedings taken by him against a farmer named Woods, who was six years in arrear for a rent of £10 10s. per annum. Skelton offered to give him £10. if he would leave the farm, but the man refused, alleging that *if he did he must beg.* Skelton then lent him money, on his own account, to enable him to put in the next crop, but Woods let it to cottier-tenants who would have taken the produce away, had not Skelton, in order to secure himself, distrained it. The farm was afterwards let to another tenant of the name of Cragill, who had not resided there more than a few months before a party of men came to his house, and beat both him and his wife in a most unmerciful manner. The scoundrels afterwards returned, and beat Cragill so severely that he was left apparently dead, and did not survive more than a fortnight.




---

p.210


During his illness he told Skelton who the men were, and Skelton, as well as his son, had to give evidence against them at the assizes. The men were tried several times. At the third trial they pleaded guilty of manslaughter, though twenty witnesses swore that they had nothing to do with the affair.


One of the Roman Catholic priests present said that when either party, Protestant or Roman Catholic (it mattered not which) considered that they were oppressed and injured, and that justice was refused them, they thought they were acting conscientiously in using every means, even false swearing, to prevent the conviction of the accused.


Skelton afterwards exasperated the people by advertising a reward for mischiefs done in the neighbourhood. His house was accordingly set on fire, and he, his wife, and seven children, very narrowly escaped; his cow was injured, his dog killed, and if his son had not been removed out of the way he would most assuredly have been murdered. Although the magistrates have afforded him every protection, he and his wife live in constant



---

p.211



fear, and consider themselves in imminent danger.


The criminals were Catholics, their victim a Protestant; but Skelton said that religion had nothing to do with the affair: under similar circumstances they had equally abused a Catholic. Notwithstanding the terrific jails, with their deaths' heads and cross-bones, no man dare take a farm in this neighbourhood from which another has been ejected.


Mr. Skelton informed us that a rule exists that any person taking land over another shall be punished. They throw down houses, and send threatening notices. "It is to protect themselves against destitution that the people resort to these crimes." *Barney Conner* said that "it generally arose out of oppression." Mr. Mitchell was a good landlord, but not resident. One of the priests said that Mr. Mitchell himself was a kind man, and that the discontent was the fault of the agents. The priest had told the people they were taking a wrong course.


A magistrate present observed that there have



---

p.212




been parishes in a state of constant disturbance for ten years; that the people are knocked down, and dare not work at the building of Barracks. The priest replied that the evils were exaggerated; this was done to conceal the real cause of complaint.


In this barony the labourers are increasing in number, and scarcely one twentieth of the population have anything to do except working some little spot of land of their own. "If a man had not conacre," said one of the witnesses, "he might wander about to eat haws and blackberries half his time." Being asked how the labourer usually spends his time when unemployed, Michael Phillips said — "Walking about, and dragging sorrow after his heels."


The wages of the country are 10d. a day without diet, or 6d. with; sometimes, in winter, 4d. and diet. Very little money is paid for labour. A horse and car are occasionally lent to bring home turf, and the return is made in labour. "Very little money," said Mr. Wright, "passes between the farmers and labourers."




---

p.213


With regard to the employment of women, one of the witnesses observed, that if a woman had nothing else to do, she might make a penny a day by spinning; but the Rev. Mr. Duffy, P.P., added that "it would take a half year's work to keep the wheel in repair." The Rev. Mr. Mahon, P.P., stated that he had never seen more than three women weaving in his life. To this, Bess Hughes, a labourer's wife, replied — "It is often we lament that we leave the whole burthen of supporting the children on the poor men. There is no work for women, nor for children, till they are old enough to go to service. I have a lump of a chap, and he gets a day now and then at weeding; he gets 3d. for the day, without diet."


The priest's dues here are a shilling at Christmas, and another at Easter; "and if the family are in distress, which is too often the case," said the Rev. Mr. Mahon, "of course I cannot expect anything."


The number of retail spirit-shops has greatly increased. In Monaghan, which formerly contained only twenty, there are now no fewer than



---

p.214



thirty, although the town has undergone but little increase. The magistrates present all stated that drinking had become excessive, most of the cases that came before them arising out of drunken squabbles. Besides the increased number of licensed houses, there are also very many shebeen houses in the country, and they are the source and scene of the greatest immorality. Being in remote and secret places, they are under no control, and young people steal flax and potatoes or meal from their parents, and pledge them in such houses for drink. From my own observations, however, I have been induced to believe that there is less drunkenness in Ireland than in England. One evening twenty-three men were placed against a wall in the yard of the Westenra Arms in Monaghan, in order that the overlooker, after having identified them, might pay to each his shilling for his day's harvest work. They went, one by one, into an adjoining spirit shop; and, concluding that they were going for the purpose of drinking whiskey, I walked to the door to inspect their proceedings, and was agreeably surprised to find


---

p.215




that they merely wanted to examine their money by the light. Not one of the twenty-three got a drop. This minute examination of the money is necessary, I suppose, in Ireland; many of the labourers appear to place no dependence on the honesty of their employers.


The state of the clothing of the labourers in this barony is wretched. One of them informed us that he wore two pairs of shoes and about five shillings worth of clothes in a year; and another stated that he knew a man who had worn a coat thirty-five years, but that he kept constantly patching it. The accommodation of the poor creatures in respect of beds, is equally wretched. Most of the cabins possess something in the shape of bedsteads, but, in very many instances, straw is shaken down as a substitute for bedding. "It would deprive you, gentlemen, of your rest at night," said Alice Kelly, "if you saw the way we are lying." A bedstead frequently contains five or six people. Some of the cabins have two bays or rooms, others only one; the bay is 12 feet square and 7 or 8 feet high; they are built of stone



---

p.216




and mud; the ground on which the house is built is dug up and trampled to form the floor; sometimes lime is mixed with it, but not often — the chimneys are of sticks and clay — "you'll see many an old firkin stuck up for a chimney," said Connolly. The Rev. Mr. Young stated, that most of the windows (which are about a foot square) are without glass; "you may see an old coat or some rag stuffed in the aperture." The cost of erection is from four to five pounds. The rent was thus stated by Connolly — "a day in every week is what myself and my neighbours pay, but we have no rood-land, only a little bit of garden."


There are two pawnbrokers in Monaghan. On the question being put as to whether the people were generally in favour of them, one of the witnesses, Bess Hughes, replied, "Well, I'll tell you; if a person is pressed for a breakfast, and the pawnbroker would not give the money, you'd want the breakfast. At first, some years ago, we used to go in the dusk to the pawnbroker's, but now I would not care if all the people on the



---

p.217



Market-cross saw me; they know it is a weighty pressure makes us do it." The quickness, the humour, the unfailing gaiety of these poor women, who, though they have scarcely a rag to cover them, and cannot with certainty calculate upon a single meal in prospect, seem to take a pleasure in laughing at sorrow, has a tendency, if not to blunt the keen edge of pity, at least to reconcile one's feelings in some degree to the destiny which imposes so light a burden. Ireland is a good school for the humanities; it is a good school, too, for those who take a low, and narrow, and disparaging view of the noble nature we possess.


The accounts given of their circumstances by the labourers residing in Monaghan, prove them to be in a worse condition than the country labourers. Though they get a greater number of days' work, they cannot so easily obtain conacre; their food is accordingly more precarious.


The desire to possess land gives rise to great and violent competition (the labourer being wholly thrown upon the hire of land for a subsistence), and it was the opinion of several present that a


---

p.218



great many outrages, and those of the worst description, are attributable to this cause. In endeavouring to ascertain whether Mr. Skelton, by his treatment of the tenantry, had given occasion for the outrages that had lately occurred, the passions of the contending parties became so violent, each wishing to support his own friends, that the Assistant Commissioners deemed it prudent, for the sake of the peace of the district, to give up the investigation on that subject. Had this step not been taken, a serious disturbance would doubtless have been the consequence. This shocking state of things might be remedied, if owners would reside on their estates, for at least a portion of the year, and pay more attention than they do to the management of their properties. The landlords who do reside, feel no apprehension. Major Richardson, for instance, Mr. Hamilton, and others, are perfectly safe, ride about the country anywhere, unattended, and are treated with marked respect. Here is another proof that the people will only injure those whom they think are desirous to oppress them; and here too is


---

p.219



another strong argument in favour of the application of a system of general education.


The average size of farms was stated to be from eight to ten Irish acres; few above fifty, and none exceeding eighty. The gentlemen are desirous of consolidating the small farms, but they have not yet done anything towards carrying their wishes into effect. From the year 1827 to 1833, no fewer than 230 ejectment decrees were issued, and the ejected tenantry, as in all similar cases, were scattered about the country. Nothing whatever was done for them by the landlords, and of course those who had no means of getting in somewhere, must have suffered extreme privation. The peasantry generally resist ejectment, and the ejected tenantry threaten those who are substituted for them. The following is a copy of a threatening notice handed in by one of the witnesses: — "Take notice, do not offer to proceed any further; stop in time, or if you don't, by the powers above, to heaven or hell, your souls from you we will expel, and send them down to the regions of hell. D—n your souls, go where you


---

p.220




came from, or you will repent it." "To John M'Mahon and John Cush." These are some of the difficulties to which the English farmer is happily a stranger. Not having to lay out the whole of his capital in obtaining possession of a farm, he experiences comparatively little hardship in leaving it for another. When we hear of the Irish violently resenting the conduct of an agent who has ejected them, although we cannot justify the outrages they commit, we ought certainly to regard them with some degree of indulgence, remembering the interest they have in the property by purchase, and seeing that when thus ejected they go homeless, houseless, and pennyless, wanderers and beggars on the face of the earth. If we may not vindicate the savage excesses in which they too frequently indulge, we are bound to consider whether their legalized oppressors do not merit at least a portion of our condemnation.


Almost the whole of this barony is in the hands of proprietors in fee; there are no middlemen. The county of Monaghan is generally the property of absentees, but they have resident agents



---

p.221




who manage the property; and as to any complaint preferred by the tenants, the witnesses observed that it is not attended to by the principal. Farms are not generally held under lease, but it was considered better to have them, as they encourage the farmers to make improvements.


Except in the vicinity of towns, the Irish acre is used. The barony is altogether a tillage district, with the exception of some rough grazing on the mountains, only fit for rearing young dry stock. Clover and vetches are very commonly cultivated, but few turnips and mangel wurzel are yet to be found. Mr. Hazlett, a tenant of Mr. Rose, who bears the highest character as a landlord, and is decidedly one of Ireland's benefactors, informed us that three years ago, that gentleman appointed a committee of his respectable tenants to manage a fund, amounting to £400, for the improvement of his estate. The committee supply good cows at an annual rate of sixteen shillings, to such of the tenants as are unable to purchase them. The cow never becomes the property of the tenant, consequently he cannot be deprived of



---

p.222



her for the payment of his debts. The annual charge of sixteen shillings is to meet the difference between the cows sold and new ones purchased, as a good milker is always supplied in case of a failure. When a cow dies, the loss is sustained by the fund, and a new one is provided, unless the death arises from neglect, in which case a fine is imposed. Pigs are also supplied to the poorer tenants, and the price is re-paid when the farmer sells the pig. The committee furnish the seed of clover, vetches, mangel wurzel, and turnips, to the small tenants, assist them in sowing them, and afterwards give premiums for the best crops. This judicious and praiseworthy plan has induced some of the tenants to adopt the green crop system, of which they gave an encouraging account, declaring that they were much better for it, and could feed more cattle than before. Captain Lewis also stated that on the Rossmore Estate he gave premiums for clover, and that there has in consequence been a wonderfully increasing growth. I was happy to find that there existed a farming society which gives premiums for the best kept


---

p.223




dairies, for ploughing, for the best cattle, and for general improvement. The breed of cattle has accordingly been very much improved. The Devon, Durham, and Hereford, are mixed here in all varieties. I endeavoured to point out to the gentlemen and farmers assembled, the advantage of keeping more sheep, but Mr. Hamilton contended that the land was too light, and that to grow rape, to be eaten off by them, would not answer. The land, he said, was much lighter than in England. They do indeed ornament the grounds of the gentlemen, but I should be glad, I must confess, to see two or three on the small farmer's premises. They might be advantageously kept on the green crops, and it is to be hoped that the farmer would have the use of the wool, should he not be able to taste the mutton.


On the question being asked whether bones, salt, soot, rape-cake, &c, were ever used as manures, an answer was given in the negative, when a voice in the crowd exclaimed, "We are very well off if we have salt with our potatoes, for nine times out of ten we can't get it — not to talk



---

p.224




of manuring land with it." The gaiety and good humour of the people under their numerous privations almost exceeds belief.


The soil of the barony is mostly a good brown loam of sufficient depth, upon a firm subsoil of clay, mixed with limestone, gravel, or sand. In the elevated parts it is of a moory or peaty nature, the subsoil frequently clayey. Monaghan and Glennan, near Glassburgh, supply the barony with limestone; the price of lime at the kilns is 10d. for four bushels. The pasture land, in many parts of the barony, in which their cattle ramble at large, and pick up a scanty subsistence, is excessively weedy, being left to spontaneous production, after years of exhausting grain crops.


The inferiority of the grain in this district is caused principally by the number of weeds which grow up in the crops, and the want of proper machinery for winnowing and skreening the grain. Flax is grown to a great extent, and is most valuable as a source of industry and profit; the quality, however, is not so fine as in the county of Armagh.




---

p.225


The county cess here is very unequal, having been applotted in William and Mary's time. It is generally the same sum per acre, whatever the quality of the land may be. There is no parish cess.


The value of orchards is very much underrated, and the planting of them lamentably neglected. Some of the gentlemen and landlords, as well as the farmers present at the examination, alleged that the farmers have no room for orchards; forgetting, or being ignorant, that an orchard, sheltered with fruit trees and good hedges, produces the earliest and perhaps the most abundant crops of grass of any land of similar extent on a farm. Bees are also rare; they would be a valuable addition to the gardens of the farmers and cottagers.


Within the last few years great numbers of the population have emigrated to America. Many farmers have sold their farms and gone, and several instances were mentioned in which they had been successful. Upon the question being put, whether, if a free passage to America were


---

p.226



offered, many would accept it, there was a general exclamation —" We would all go; there would be more work there than workers."




---

p.227


Monaghan — Tydavnet — Coothill — Rockcurry — Ballymire — Carelessness of Irish drivers — Clones — Pillar Tower — Rath — The Rev. Mr. Bogue — Squares in Monaghan — Top-coats in summer — Singular mode of stopping passengers — Holyhead — Difference between the Welsh and Irish people — Holyhead Lighthouse — Menai Bridge — Bangor — Conway — Return to Ireland — Donaghadee — Bangor — Belfast Lough — Belfast — Effect produced on first seeing Lough Neagh — Fossil wood — Shane's Castle — Ancient burial-ground — Movement of Sluggan Bog — Pillar Tower — Basaltic formation — Superstitions respecting Lough Neagh — Description of the lake — Falsehood of Irish drivers — Magherafelt — Moneymore — Cookstown — Road to Omagh.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The vicinity of Monaghan is highly cultivated, and ornamented with wood and plantation. A little south of the town, Dacre Hamilton, Esq., has a seat and a park-like domain, covered with flocks of good Leicester sheep. On the road to Castle Blayney is Castleshane, the seat of E. Lucas, Esq., M. P. The grounds are very beautiful — 


---

p.228



some fine timber enriches the estate, and a large extent of land about the house has lately been planted.


At Tydavnet is a very ancient grave-yard, the oldest in the county. A church formerly stood in it, but not even the foundations now exist. The ancient Lords of Monaghan, it is said, were buried here. I observed many dates of so late a period as 1700, and one as early as 1591. The earlier ones were effaced by time. In this churchyard we were present at a conference respecting some projected improvements, and were highly gratified by witnessing the friendly terms maintained between the Protestant clergyman and the Catholic priest.


Two miles from Monaghan the Earl of Rosmore has a spacious park, and is building a new castle in the Elizabethan style. Fifteen miles from Monaghan, at Coothill, in the county Cavan, is a Friends' Meeting-house, which I attended on the 30th. It is built within the boundaries of one of the ancient raths. The number of members is only eight, but this small congregation is sometimes


---

p.229



increased by others who belong to different denominations.


The first few miles of the road from Monaghan is over a high and poor district, the soil of which is of a moorish quality, well adapted to the growth of flax, and numerous patches of this valuable plant were met with on our journey. This part of the country is remarkable for the number of its raths, most of them consisting of only one rampart. As we proceeded, we passed through several congregations of Catholics and Protestants, going to or returning from their respective places of worship. The numbers bespoke the existence of a dense population in a poor and apparently remote region. The contrast of the white and scarlet of the women's dresses produced an effect similar to that previously described as having been observed at Hilltown.


On leaving Rockcurry, which is built on rock, we descended into one of the noblest countries I ever beheld. From Lord Cremorne's grounds (through which, by the permission of the noble owner, I drove) we had a fine view of Dawson


---

p.230



Grove and of Bellamount Forest, on the opposite side of Lough Sady.[10](javascript:footNote('E830001-002/note010.html')) These grounds contain some magnificent scenery, expansive lakes, and woodlands, diversified with lawns of picturesque beauty.


Ballymire, near to Clones, is a delightful village, having a stream flowing through it. On this stream stand two mills. In the houses and gardens considerable taste is displayed, chiefly by some ladies who reside here, one of whom was laudably occupied in building a school-house, and establishing a school.


During this journey it was my lot to experience some of the unpleasant effects of the notorious carelessness of the Irish drivers. In going down a hill, in the usual reckless manner, one of the wheels flew off, the driver was violently thrown from his seat, the horse galloped off at full speed, and the car was kicked to pieces. The driver was dragged along the road for some distance, and I



---

p.231



found the poor fellow with a broken arm. Fortunately a surgeon from Clones drove up at this moment, and having procured some flax and wood from a neighbouring cabin, secured the limb.


Clones, which belongs to Sir B. Thomas Leonard, son of Lord Dacre, the former owner, was successively called Cluaneois, Clunes, Clunish, and Cloyne. The market place is adorned by a fine old carved cross, surmounting a flight of steps, and beautifully ornamented with sculptured figures of animals. Here, too, are the ruins of a monastery built in the sixth century, and dedicated to St. Peter and St. Paul. In the graveyard, on the opposite side of the road, the tombstones that lie scattered about are of curious and antique forms, with raised letters in front, and significant carvings on the back. Amongst others, the Scotch thistle frequently appears. In this yard also stands the celebrated Pillar Tower, the top of which has been broken in upon by time. This tower (Sir Charles Coote informs us) contained five stories; the walls are, at the base, four feet thick; at the top, two; and the diameter


---

p.232




inside is ten feet. The entrance is also ten feet from the ground, and is two feet in width. Holes, which appear to have supported joists for the floors, still remain, and Sir C. Coote thinks, from the roughness of them, that they have been made since the tower was built. There is no appearance of any stone staircase. Upon an elevated piece of ground about a stone's throw from this remarkable monument of ancient days, is a very perfect Rath, which commands a view of the whole surrounding country. It is encompassed by three ramparts and an equal number of fosses, in the lowest of which is a fine spring of water. The top is flat, and contains the foundation of a square building.


At the house of the Rev. Mr. Bogue, a Roman Catholic priest, about five miles from Clones, I met the Rev. Mr. M'Mahon, the Rev. Mr. Duffy, also Roman Catholic priests, Dr. Kellet, a Protestant, and other gentlemen. Mr. Bogue prides himself upon his climbing roses and shrubs, which he was pleased to say were in the English fashion. His ornamental garden was indeed a



---

p.233



beautiful specimen of the cottage style, and I felt gratified to find myself walking upon a close mown lawn, surrounded by beds of beautiful and fragrant 
flowers. Our conversation at dinner, among other topics, turned upon the national system of education, the celibacy of Catholic priests, and the influence 
they possess over their flocks, and the difference between some of the English and the Irish customs. Mr Bogue is a fine hearty liberal priest — 
provided a dinner and its *et ceteras* of the first description — and, in the characteristic spirit of an Irish gentleman, is 
proud of possessing the choicest wines and whiskey.


Monaghan, although the capital of the county of Monaghan, is a poor place with very little trade, and contains only about 4000 inhabitants. 
It branches out into triangular spaces, in other towns usually called squares, but here designated *diamonds* — the first, 
second, and third diamond. The church is an ancient building, with an ugly narrow tower, an irregular pentagon,, and the same width from top to bottom. 
Here I visited a hairdresser, the only one in the town, and was dignified 


---

p.234




with the title of "My Lord." Before the operation of hair-cutting began, he begged me to lend him my handkerchief to spread over my shoulders, for he had not yet provided himself with the usual napkins of his profession. He was very grateful for the trifle I gave him.


At Monaghan great numbers of webs of coarse linen cloth, about a yard wide, are sold at from 8d. to 9d. a yard. Although it was now the harvest time, we perceived in the market-place upwards of forty labourers, whose hopes of obtaining employment were disappointed. To an Englishman it is strange to see the men, in the very hottest days of summer, attending market in top-coats and cloaks, a fashion to be accounted for by their having scarcely any other garments. They wear them as "an outside shade."


Seeing footwalks near the town, unprotected against equestrians, I asked the tenant of the toll-house which was close at hand, if people did not escape the toll by going along the path. When he first came they did, he informed me, but he kept fire-arms, and fired at them when attempting



---

p.235




to do so. They accordingly soon became acquainted with him, and he declared that he would shoot any one who attempted to pass that way. Yet this man holds a place of public trust! Perhaps I cannot supply a more emphatic illustration of the state of society in this part of the country.


According to Sir Charles Coote, nearly the whole of the county of Monaghan was escheated to the Crown in the reign of James I. under the pretext that the proprietors were disaffected to the King's government. The lands were afterwards given to British and Scotch adventurers, not a twentieth part being reserved to the Irish, who, full of fear and revenge, retreated to the mountains. The small estates are at present held under grants from the Crown. Cromwell's soldiers came in for a considerable share of the forfeited lands, and many of their posterity now enjoy small tracts, yielding about £20 per annum. The county and town derive their name from Hugh Roe M'Mahown, chief of his name, who was executed as a traitor, and whose lands were confiscated.




---

p.236


Important business requiring my speedy return to England, I left Monaghan on the evening of the 5th of September, and departed from Kingston in a steamer for Holyhead, at nine o'clock the next morning. Not being able to obtain a seat in the coach from the latter place, I availed myself of the opportunity which the disappointment afforded, and sallied out to inspect the "lions" of the neighbourhood. What most immediately and most forcibly struck me was the amazing disparity which a sail of not more than five or six hours had produced in the character and appearance of the people; — on *that* side of the channel, squalid looks, and lamentable destitution, met me at almost every step — on *this*, the plump and rosy faces of a well-clothed population greeted me wherever I went. In Ireland, three or four shillings a week was a very respectable amount for wages; here, the same class of persons earned regularly from twelve to fourteen. As in a dream, I was transported from a land of poverty and misery, to one flowing with milk and honey. Many of the inhabitants of Holyhead cannot



---

p.237



speak a word of English; I had accordingly much difficulty in eliciting the requisite information as to my road.


The Lighthouse stands upon a rock, detached from the main land, but communicating with it by a chain foot-bridge, across a deep chasm of perpendicular rock. The bridge is 110 feet between the pillars, and the distance from high-water to the bridge is 75 feet. The rock consists of clay slate, soft and shining, very much curved, and mixed with veins of quartz. The stairs cut in the rock, in the descent to the bridge, are steep and circuitous. The rugged cliffs are exceedingly dangerous, and small vessels have been lost nearly under the lighthouse, when the light on the summit, as is not unfrequently the case, was enveloped in mist. To remedy this, a short railroad has been constructed, reaching from the base of the lighthouse to the sea, on which a wooden building, or sort of deputy, is ingeniously placed, exhibiting brilliant lights, and is lowered down at discretion by a windlass. This invention has happily been the means of saving several vessels. Many


---

p.238




caverns of curious structure and large dimensions are observable from the lighthouse rock. On ascending the high cliff as I returned, I perceived the mountains of Ireland, opposing their purple masses to the quiet orange tint that lingered for a while upon the evening sky.


From Holyhead to Menai Straits there is nothing particularly worthy of note, except, of course, Telford's excellent Dublin and Holyhead road. The celebrated Bridge at Menai is too well known to require description. It is impossible to convey an adequate impression of the greatness of this stupendous work. Its astonishing height, its gigantic strength, its magnificent massiveness, and yet perfect beauty and gracefulness of appearance, address the heart of the spectator in a language that may be felt, but cannot be interpreted. During the progress of this mighty undertaking, the sense of the responsibility which rested upon him is said to have borne so heavily upon the mind of Telford as actually to make him feel that his reason was endangered, and upon these awful occasions, I have been



---

p.239



informed, his only support and comfort was Prayer.


From Menai Bridge I proceeded to Bangor, and from Bangor to Conway, where the coachman stopped for a few minutes whilst I examined some old houses which I observed up a narrow street. They were genuine Elizabethan, and the exterior proclaimed them to have been of no ordinary rank. I had scarcely time to see more than two or three rooms. The plaster is ornamented with various animals: the royal coat of arms was over the chimney-piece; and the letters E. R. in large characters inclosed within a circle. The rooms were very large, the spacious windows having stone mullions in walls six feet thick. Queen Elizabeth is reported to have held her court occasionally in these ancient buildings, which are now used as alms-houses.


Early in October I returned to Ireland by way of Carlisle, Dumfries, Portpatrick, and Donaghadee. According to tradition, Portpatrick derives its name from being the place from which St. Patrick sailed to Ireland.




---

p.240


At Donaghadee I again set foot on green Juverna. The harbour here was designed by Mr. (now Sir John) Rennie. At the north end of the town are two buildings erected upon a rath, and now used as powder magazines. The sappers and miners having speculated on finding some valuable antiquities in the rath, explored it, and, in consequence of the examination, the buildings gave way, and they lean towards each other at the top in a rather grotesque manner.


We passed through Bangor, a sea-port with a safe and convenient harbour, at which corn and cattle are exported. Viscount Bangor takes his title from this place, and has a seat in the vicinity. There are two cotton mills here, and something like the enterprising spirit of trade was visible.


Belfast Lough is a noble expanse of water, the shores of which are sprinkled for several miles with mansions and villas, surrounded by their respective woods and pleasure grounds, and backed by hills of the whitest limestone. The numerous vessels in the lough bespeak the existence of that which is so rare in Ireland, industry, and activity,



---

p.241



and a prosperous trade. Belfast Lough is celebrated for the landing of William III., in 1690, at the White House; he was joined by Schomberg and his army at Belfast. Of this town, the population of which is about 53,000, little can be said in respect of its buildings, except that the streets are regular, the houses of brick, and the shops above mediocrity. The trade and commerce are rapidly increasing, and the shipping is allowed to be equal to any port in Ireland: vessels of 500 tons can lie at the quay. Belfast has partaken largely of the benefits resulting from the opening of the trade to China and India, and many emigrants find it convenient to embark at its port. The inhabitants of this large town have latterly turned their attention to literary and scientific pursuits, and have established a Museum, Botanical Gardens, and a Historical Society. The secretary to this society, Mr. Maurice Cross, published, in the year 1833, a selection of articles from the Edinburgh Review, in four volumes — a work of permanent value, and demanding a place in every library of more than meagre pretensions.




---

p.242


At Antrim I rose at six in the morning (having arrived there the previous evening), and, attended by a guide, set out for the shore of the celebrated Lough Neagh. In passing under the shade of some ancient pines, an apparently unbounded expanse of water burst suddenly upon the view, and on the first glance I inconsiderately asked, "Is that the sea — "The effect produced by the instantaneous prospect of the lake is truly magical, and I find in **Arthur Young**'s description of the lough that his first impression was similar to mine. "It is of such an extent," says he, "that the eye can see no land over it. It appears like a perfect sea, and the shore is broken sand-banks, which look so much like it, that one can hardly believe the water to be fresh." Along the eastern shore of the lough, the Earl of Mazarine's deerpark extends; and from the banks of the same shore some petrifying springs issue. Fossil wood is frequently met with, and in the neighbouring counties it is sold for whetstones. I collected a few specimens in its early stage of petrifaction, as well as small lumps of clay which had become


---

p.243



transformed into perfect stone. In one place, where the water issued from a high breast of sand intermixed with very thin layers of clay, I discovered concretions of hard stone.[11](javascript:footNote('E830001-002/note011.html'))


Retracing our steps, we crossed the Six-mile river in a boat, and traversed the north end of the lough, as far as Shane's Castle, Lord O'Neill's, renowned in the Irish wars. The castle was burned in the year 1816, and nothing now remains but its tall ruins, which are respected for their antiquity. The grounds are very extensive, consisting, I believe, of 50,000 acres.


Respecting Lord O'Neill's, **Arthur Young** remarks, "I was most agreeably saluted by four men hoeing a field of turnips, as a preparation for grass. These are the first turnip hoes I have seen in Ireland, and I was more pleased than if I had


---

p.244



seen four emperors." He also states that the great improvements made by Mr. O'Neill (which is sixty years ago) in draining, sanding, claying, and in introducing valuable plants and implements, seem to have had little effect on the general agriculture of the country.


Near the castle is an ancient burial-ground, in which I did not observe any gravestone of earlier date than 1680, but many were obliterated. In this yard stands the vault belonging to the O'Neill family, with an inscription over the door as follows: "This vault was built by Shane Mac Brien Mac Phelim Mac Shane Mac Brian Mac Phelim O'Neill, Esq., in the year 1722, for a burial place to himself and family of Clanboy." Great numbers of people walk or ride from Antrim and the neighbourhood on Sundays, to enjoy these beautiful grounds.


On walking along the shores of Lough Neagh, I observed that they were strewed with masses of bog which had been washed down the river into the Lough, from the Sluggan Bog in Lord O'Neill's estate, in the neighbourhood of Randal's Town. 


---

p.245



This bog was undergoing an extraordinary movement when I was at Antrim. According to the account of a person who was present, the first movement was on the 19th of September, and was accompanied by a rumbling noise from beneath, when a part of it suddenly advanced a few perches. It remained thus till the 22nd, when it again suddenly moved forward and choked up the river, which, however, the heavy rains that soon followed, fortunately cleared. The alarm excited by this unusual occurrence was considerable, and the people hastened to remove their furniture, for the bog moved at a rapid rate, and in a body of 15 or 20 feet deep, covering the fields to the extent of 150 acres. The curiosity of all ranks in the neighbourhood was stimulated, and thousands of people, in all sorts of vehicles, and on foot, collected to witness the remarkable phenomenon.


One of the pillar towers stands conspicuous about half a mile from Antrim. It is in a perfect state, ninety-five feet high, and fifty-three in circumference. The wall is nearly three feet in 


---

p.246




thickness, and the door-way, four feet in height, is about twelve from the ground, and fronts the north. A tablet bearing an ancient inscription which is not easily deciphered, is built in the wall seven feet from the ground. The tower is said to have been divided into three stories, with holes in the walls for supporting joists, and near the top are holes corresponding with the cardinal points. This pillar tower is in the grounds of George Jackson Clarke, Esq., to whose good taste the public are indebted for its excellent state of preservation.


My guide informed me that in a quarry on a mountain, three miles to the east of Antrim, a basalt formation, similar to the Giant's Causeway, is to be seen; probably it may be a link of the chain of rocks of the basaltic kind connecting the Giant's Causeway with those of Market Hill. I also observed on the shores of Lough Neagh, as well as on the road near Belfast, basaltic stones, spotted with trap, similar to those noticed at Market Hill. I saw such, too, on the road near Belfast.




---

p.247


I had now been gratified with a sight of both the south and north end of this immense fresh water lake, said to be one of the largest in Europe. Some of the credulous Irish have a tradition that the Isle of Man was formed of the land scooped out of the space now filled by the lough; and in the time of Giraldus (**Moore** tells us) it was believed that the lake had been originally a fountain, by whose sudden overflowing the country was inundated, and a whole region, like the Atlantis of Plato, overwhelmed. He says that the fishermen, in clear weather, used to point out to strangers the tall ecclesiastical towers under the water. **Moore** has made delightful use of this singular tradition in a stanza of one of his melodies.



> 1. On Lough Neagh's bank as the fisherman strays
>   
> When the clear, cold eve 's declining,
>   
> He sees the round towers of other days,
>   
> In the wave beneath him shining;
>   
> Thus shall memory often, in dreams sublime,
>   
> Catch a glimpse of the days that are over;
>   
> Thus, sighing, look through the waves of time
>   
> For the long-faded glories they cover!
> 




Mr. Hardy, in the Northern Tourist, states that while some early writers assert that it suddenly


---

p.248




burst out in the reign of Lugaidh Rhiadberg, in the 15th year of the Christian era, we are informed on the authority of the late Lord Bristol, Bishop of Derry, "that in a monastery on the continent a manuscript existed, which mentions that in the sixth century a violent earthquake had thrown up the rock at Toome, which, by obstructing the discharge of the rivers, had formed this body of water, and that Lough Erne, in Fermanagh, was produced at the same time."


Lough Neagh is stated in old maps to contain 100,000 acres; in one published in 1804, by Sir Charles Coote, in his survey of the county of Armagh, 973,785 acres are mentioned. The shores, generally speaking, are rather flat and bare of wood. It has only two islands, Blackwater Island, and Ram's Island, both situated towards the south end. The latter contains one of the pillar towers. The navigation of Lough Neagh extends from Carlingford Bay, by Warren's Point, Newry, and the Newry Canal, joining the River Ban in the county of Armagh, and thence to the Lough; there is also a navigation



---

p.249



joining the River Lagan, which flows by Lisburn and Belfast. Several other considerable rivers supply the lough, which has one outlet only, by the Lower Bann. This river separates the counties of Antrim and Londonderry, and enters the sea to the eastward of Coleraine. Lord O'Neill built a bridge, consisting of eight arches, over the Lower Bann at Toomeferry. The cost I suppose to have been immense, for travellers pay high — 2s. being charged for a one-horse car. The receipts, I was informed, are £300 per annum. The bridge is certainly a great convenience to the public.


Extreme caution in receiving the information of the Irish drivers is a virtue that all travellers who wish to arrive at the truth must possess. They do not scruple to make the most confident assertions on matters with which they are perfectly unacquainted. I remember that, on first coming in sight of Castle Dawson, and inquiring the nature of the tall building, I was told, without the slightest hesitation, that it was a church. As we drew nearer I expressed my doubts, but was


---

p.250




solemnly assured of the correctness of the statement, my informant having often seen it before. A still nearer approach proved it to be a monumental column; but, on telling him this, he persisted the more stoutly in his account, adding that he had been so often that way, it was impossible he could be mistaken. Again — as we travelled towards Magherafelt (a neat little town with a Free School belonging to the Marquis of Londonderry and Sir Robert Bateson) I noticed the absence of milestones. My driver directly informed me that the old ones had been taken up and the new ones were not yet put down. Once deceived, I had grown suspicious, and at Magherafelt confronted him with the landlord. He betrayed, however, no discomfiture, when both his statements were disproved. To display ignorance is considered by the lower Irish a serious fault, and, as a matter of course, to attempt to conceal it is regarded as a signal virtue.


The streets of Magherafelt are wide and remarkably clean, and the houses well built and white-washed. Contrary to usual custom, the



---

p.251




church is built on low ground, at the bottom of the hill, as if to elude observation. From Magherafelt to Cookstown I enjoyed the novelty of a neat car and a well-conditioned horse that travelled cheerfully without flogging.


Moneymore, not far from Magherafelt, is also a neat white-washed town with wide streets, and stands upon a hill. It belongs to the Draper's Company, and has been much improved by them. It contains two Free Schools, a Dispensary, and News-rooms, though the inhabitants do not exceed 1000.


Cookstown, in the county of Tyrone, consists of one straight street upwards of a mile in length, and 150 or 160 feet wide, having a row of trees in front of the houses on each side. The town, when viewed from one end, has the appearance of an avenue of trees alone. Though the population is nearly 3000, the houses are of a humble description. The land about is fertile, and abounds with limestone: coals also have been raised near the town. Cookstown and the vicinity belong to



---

p.252





Colonel Stewart, whose domain extends for several miles on each side of the town.


From this place to Omagh very little cultivation or improvement is observable. Indeed, during the whole of the way I witnessed only one attempt at superior management, and that was in the case of a very respectable looking man, who was working in his small garden, and had a little patch of clover. It is probable that he had seen Mr. Blacker's pamphlet.




---

p.253


Examination at Omagh — Failure of the linen trade — Drunkenness — Pawnbroking — Condition of the cottiers — Average size of farms — Usual rotation of crops — Emigration — Tenantry of absentees — Agents' fees — Agricultural state of the barony — Sheep — Cars and sleds — Roads — Mendicity and wretchedness of Omagh — Seats in the neighbourhood — Instance of revengeful feeling — Bessy Bell and Mary Gray — Sleds — Singular mode of thrashing — Intoxication — Conviviality of Irish priests — Opinions respecting them — Journey from Omagh to Enniskillen — Superstition respecting thorn trees — Enniskillen — Lough Erne — Number of its islands.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


At Omagh we held our examination in the Court-house, and had a numerous attendance.


The failure of the linen trade has been the means of throwing many of the inhabitants of this barony upon agricultural work, and of causing, accordingly, a surplus supply of labourers, seven or eight hundred of whom (it was stated) would work for what their meat would cost. There is no county in which the poor are worse



---

p.254



off than they are in Tyrone. They evince the strongest anxiety to obtain work, but cannot.


Drunkenness is on the increase here, and prevails to a much greater extent in periods of agricultural distress than at other times. Many unlicensed spirit-houses exist in different parts of the country.


Omagh contains only one pawn-office, a circumstance that may be accounted for from the fact that the labourers have nothing which the pawnbroker would accept. The people are wretchedly clothed here. It was the general desire of the meeting that a bank of some kind should be established, which would advance small loans to the farmers in time of pressure.


The cabins of the cottiers are mere mud hovels, unfit for the residence of human beings. They are built on the worst parts of the farms, and generally consist of but one smoky apartment, without window or chimney. Turf is the ordinary fuel all over the barony, and is abundant and cheap. The cottier is better off than labourers who have no cot-take, because he is certain of


---

p.255




a supply of potatoes if the crop succeeds. But what a miserable certainty! His work for nearly the whole year is valued at the paltry sum of from four to five pounds. Besides paying the rent, it is a very common thing to give duty days, and in some cases both to landlord and agent. "Many of the small farmers," said the Rev. Mr. Stark, "have not drunk a drop of their own cow's milk, nor eaten a bit of their own butter, from year's end to year's end." The character of the cottiers who reside in remote places, on bogs or mountains, is that of a peaceable, humble, well-behaved people.


In the year 1802, Mr. M'Evoy, in the statistical survey of the county of Tyrone, writes as follows: "The poorer class cannot afford to use much butter, being obliged to sell the greater part of it in order to purchase necessaries, such as soap, candles, tobacco, and salt. In summer and autumn milk is chiefly used; the remainder of the season, herrings are the most common food with the poor." From this extract it appears that the poor were much better off in 1802 and previously, than at the present time.




---

p.256


The average size of farms in this barony is from eight to twelve acres. The junction of farms has not been very considerable, though every anxiety exists on the part of the landlords to effect it. "The truth is," said one of the witnesses, "the landlords allowed forty-shilling freeholders to become very numerous, and now they would wish to convert them into £10 freeholders." Here, as elsewhere, the majority of those present concurred in thinking that small holdings produce more in proportion than large ones, and that a small farmer can afford to till his farm better than a large one. The tenants, however, pursue no judicious system of farming, nor is any encouragement given to improvement either by landlords or agents. The only method adopted to recruit exhausted land is to let it rest or lie idle, and leave it to the unassisted care of nature. The usual rotation of crops is as follows: — 1st, potatoes; 2nd, oats; 3rd, flax with clover; 4th, clover; 5th and 6th, oats. Some take four or five crops of oats in succession.


About four years before we visited Omagh,



---

p.257



emigration had taken place on a considerable scale; latterly however, it had declined. The occupiers of farms will not give up their holdings on the condition of having their passage money to America paid for them; "they have found it so hard to obtain a living," said one of the witnesses, "that if they have any means of subsistence at all they will not give it up. They know what they have here, but don't know what they may meet with there." The principal emigration had taken place among the industrious classes — those who had acquired a little money. Though carried on to a considerable extent, it has been by no means sufficient to reduce the competition for labour. To produce this effect, it must be not only great but constant. The witnesses were unanimous in considering that if a free passage to America were offered to those who were not in possession of land, great numbers, including many young women, would gladly avail themselves of the opportunity of emigrating. One of the witnesses shrewdly but superficially observed, that emigration made little difference, adding that


---

p.258





more people are born in one night than emigration carries off in seven years.


The reader will not be surprised to be informed that the tenantry on the estates of absentees are in a much worse condition than those on the estates of resident proprietors. Under absentees, they got no sort of encouragement whatever; how, indeed, as one of the witnesses, Dr. Harkin, asked, can landlords be expected to feel for distresses of which they know nothing — It is customary throughout the country for the tenants to pay, in addition to their rent, one shilling in the pound to the agent, whose fees, by the way, as well as the rent and the duties, are sold, on the occasion of land being disposed of. The tenants are occasionally harassed most grievously by processes for arrears of rent said to be due many years ago — the tenants denying the justice of the demand. Dr. Harkin told us that he had known upwards of three hundred processes served in one day upon the tenants of a nobleman in that neighbourhood. It is usual also in this part of the country for agents to receive money on the signing of leases, the general sum



---

p.259



derived from the small tenantry on these occasions being from five to ten pounds. As much as thirty, or even fifty pounds, has been given for the renewal of a lease. One of the witnesses, Mr. Auchinleck (the agent for the largest estate in the barony) informed us, that when proprietors receive their own rents, they actually receive agents' fees; and, on the signing of leases, duties and money. Rents generally are about 30s. the Irish acre. "My farm," said Robert Crawford, "stands me in a glass of whisky a perch."


The general produce of the barony arises principally from tillage, but in the more elevated parts there is some rough pasturage. The average size of tillage farms is about twelve acres (Irish measure.) The soil is of a light brown colour, of moderate depth, and is considered by the farmers to be unsuitable for wheat. A few of the farmers have the appearance of respectability, and are intelligent men, but the generality of them are in a distressed condition, and are inferior to the farmers of Down and Armagh. The Assistant Commissioners remarked that the tenants are all ignorant


---

p.260




of green crops, and the landlords apparently indifferent as to the cultivation of their estates. If they only pay the rent, the tenants may do what they will with regard to the management of their farms. This was the sentiment expressed by Mr. Auchinleck.


Very few sheep are kept, not more than one to every twenty acres, and those of the Irish breed. A good bull is worth from four to five pounds, and a good breeding cow from four to seven.


The car with the revolving axletree and solid wooden wheels is still in use here, and the sled or slide is not uncommon. It has the appearance of the shafts of a cart, to the end of which are attached two rude pieces of wood which slide upon the ground. Upon this carriage a basket is placed to convey turf, hay, &c These sledges are used on the mountain sides, being lighter to draw up the steep hills, and less subject to be overturned.


Although the roads in every direction were receiving great injury from the accumulation of water and mud upon them, we did not see, during the ten days we were in the barony, half a dozen



---

p.261



men working upon them. Here, then, was a source of employment totally neglected.


The yearly amount paid for grand jury cess is from three to four shillings the Irish acre. The amount of tithe per acre is generally two shillings.


This barony forms no exception to the general rule as to early marriages.


No Englishman could fail to be grievously shocked with the wretchedness exhibited in the streets of Omagh. An aged woman, nearly blind, and reported to be 115 years old, was asking charity in front of the Court-house, and would have fallen down a precipice caused by an alteration in the street, if she had not been rescued by a gentleman near her. Another old woman crawls about the streets with a scanty and imperfect covering to those parts which common decency forbids to be exposed. Friday the beggars consider their legalized day for visiting the town, and they are remarkably industrious and sharp-sighted in the prosecution of their miserable employment. They kept a vigilant look-out for us at every turn,


---

p.262




and if we happened to have no copper they begged for silver. These poor creatures made every exertion to intercept us before we reached the inn door, and I am almost ashamed to add, that when we did reach it before them, we experienced a sort of triumph, for it was impossible to give to all, and we had no principle to guide us in our selection. Our examination day afforded ample opportunity for seeing the different grades of beggars, many of whom are bent down with age and infirmity, and in rags — others, consisting of women with their children, of various ages, all well initiated in the practice of their art — whilst numbers of poor wretches are seen at the doors of the inhabitants, so weak, and blind, and lame, that they have to be assisted by their friends, or guided to the next door by the last contributor.


About three miles from Omagh are the estates of the Earl of Blessington, at present held under the Court of Chancery. Gentlemen's seats are not numerous in this neighbourhood — Lord Belmore, of Castle Coole, Lord Blessington, and Lord



---

p.263





Abercorn, all absentees, being the principal proprietors.


We here witnessed an illustration of the rancorous effects produced by the system of taking farms over the old tenants. A very respectable looking farmer informed us that he occupied his land under the Court of Chancery, and was going to give it up, because the rent was too high, but he intended taking it again at a reduced rent, though he was afraid some of his neighbours might bid for it. On being asked what he would do if another were to take it, he replied, (at the same time striking his breast in a very energetic manner) — "I would stand over him while he was burning in the flames. My father and my grandfather held it before me, and nobody shall take it from me, and snatch the bread from my children's mouths, if I can help it."


At the summit of Bessy Bell, a mountain 2000 feet high, we found a cairn, consisting of a rude and large heap of stones. That it formerly contained an apartment is sufficiently indicated by the large flat stones which form the roof of a subterraneous



---

p.264



passage in the direction of the centre. These stones are now level with the surface of the ground, and are similar to those which cover the passage to the cairn on Slieve Guillien. On the sides of this mountain we observed large blocks of beautiful white and transparent quartz, embedded in clay. The mountain Mary Gray[12](javascript:footNote('E830001-002/note012.html')) is not far from Bessy Bell, and is said to abound with limestone. Baron's Court Park, the residence of Lord Abercorn, Lough Catherine, and the course of the Strule river, are seen from this elevation, in a richly wooded and delightful vale. Towards Gortin the country is mountainous, rocky, and romantic This district abounds in raths, which are sometimes near each other, and are generally very perfect.


On returning, I saw for the first time a sled or slide, a sort of carriage in use here. Being less easily upset in carrying hay or turf than an ordinary


---

p.265



cart, it is frequently used on the sides of the mountains. The cost of a sled is not more than five or six shillings, a sum considerably less than would be required to purchase a car or cart, neither of which many of the small farmers can afford. A sled, however, will only carry four or five cwt. M'Evoy, in his report of the county of Tyrone in 1802, observes thus of the slides — "I am thoroughly convinced of their great utility in mountainous situations; in countries not over mountainous, I am not altogether clear but the slide car should have the preference; it is amazing to find with what celerity a small horse, worth about 40s., with one of these simple vehicles, will get through so much business in a season, in drawing manure, turf, or limestone." The slides have no wheels, but rest and are drawn upon pieces of rails nailed to the end of the shafts. Another practice, viz., that of thrashing their corn upon the roads, is very common in this neighbourhood. After it is thrashed, they convey it up to the edges of the hills, where a number of persons are employed in exposing it to the wind


---

p.266




with uplifted arms, to separate the corn from the chaff. The effect of this process, when seen at evening, the winnowers being upon the edge of the horizon, is curious. A great deal of corn is thrashed during harvest, and we were continually meeting it in carts, cars, and on the backs of donkeys, in its transit to the various markets in Ireland, to be thence conveyed to England.


Agriculture in this part of the country is far from being in a prosperous state, and the trade of begging is pursued with systematic regularity and perseverance. Intoxication is complained of, but though our room faced the market-place, I did not observe one drunken man in Omagh. On the market day I heard the voice of one, and only one, and that was in the evening.


The roads about Omagh are exceedingly dirty and ill managed, the wet being allowed to remain upon them, and in many places to cover their surface. It is strange that with so many people close at hand, to whom employment on almost any terms would be acceptable, no efforts are made to introduce a better order of things.




---

p.267


The bogs in this part of the country are very numerous, but remain almost entirely uncultivated.


On returning from a survey of several farms in the neighbourhood, we found at the house of the Catholic parish priest of Dromore, a plentiful board spread for our refreshment. The curate, who had accompanied us in our walk, and two other Catholic priests, were of the party. Our host had provided abundantly of ham, fowls, ducks, port, sherry, and whisky, all of which were of the very best quality. Indeed, from what I have seen of the Roman Catholic priests in the north of Ireland, I have no hesitation in declaring that they live convivially, and are hospitable to strangers.


Our conversation, amongst a variety of subjects, turned upon religion and general politics. Our host, it appeared, had publicly recommended in his parish, resistance to the payment of tithes; and he declared that he gloried in the act, because he considered the impost against which he had lifted up his voice, an oppressive and unjust one.



---

p.268



Though strong in his language respecting the professors of the "new religion," he was less vehement than might have been expected, and admitted, in the course of the afternoon, that some of his doctrines in reference to Protestants were anti-evangelical. I cannot help suspecting that the Roman Catholic priests of Ulster would be improved by the possession of a little more of the charity that thinketh no evil; and I may be permitted to add my persuasion that very many of them (and their flocks of course) entertain towards those of the opposite faith a deep-rooted and unchristian prejudice. The priests of the south of Ireland are greatly superior, I am told, in education and manners, to those of the north; a fact that may be at least partially accounted for by the preponderance of Catholics in the former, and of Protestants in the latter extremity of the country. In the south too, the Catholic chapels and churches are costly and magnificent edifices, whilst those of the Protestant worship are comparatively lowly and unadorned. The old priests of the south of Ireland received their education in



---

p.269





France or Italy, and are generally polished gentlemen; those of the north are of more humble birth, and are chiefly educated at Maynooth.


The living of the Protestant rector of Dromore, who was from home when we visited the place, is worth, we were told, upwards of £2000 per annum. The land attached to the glebe-house is of the first quality, and of the deepest green. The income of the Catholic rector is £300 a year, of which £100 is given to his curate. About two-thirds of the population of the parish are Roman Catholics.


We left Omagh for Enniskillen in a car with a pair of horses, which in this part of the country are always driven tandem. Our driver, as usual, made a flourish at starting, galloping from one side of the street to the other; and before we had left the main street, we had to stop no less than four times, owing to the loss of his hat, the traces coming loose, and sundry breakages. On reaching carts, our driver called out to the man to lend him a hand to his leader in order to get him past, and in entering to the village of Fintona, first one



---

p.270




and then another proffered assistance, although the street was perfectly clear. The stage to Trillick is 18 miles, but nothing could induce the man to stop halfway to bait his poor and jaded beasts. We afterwards discovered that both these poor brutes were blind, in consequence, it is to be feared, of the brutality of man. Notwithstanding the various stoppages and turnings, we went the eighteen miles in about two hours.


In the course of our journey from Trillick to Enniskillen, our attention was frequently directed to the luxuriant thorns, almost the only trees that had not fallen before the axe and the fire. Here, as in other parts of Ireland, the hawthorn owes its preservation to the peculiar veneration with which it is regarded as the favourite haunt of the fairy-folk. Our driver related an anecdote which exemplified at once his own credulity and the popular attachment to this interesting tree. A farmer had carried away from his field a thorn which the wind had blown down among his corn; about the same time his cow became suddenly ill, ran into the street, and lay down as if in the act



---

p.271




of dying; bleeding, and the usual medicines, were resorted to without effect; and it is probable the poor man would have lost his cow if he had not adopted the advice of an intelligent neighbour, who suggested the propriety of re-conveying the hawthorn to the field, and depositing it in its former situation, as a sort of peace-offering to the offended spirits of the place. This being done, the animal was immediately restored to its accustomed health. Such was the story related by our driver, who not only asserted its truth in general terms, but energetically swore that the miraculous circumstances had come within his own experience. Our incredulity excited his severest indignation.


Enniskillen is built on an island, and consists principally of one rather steep street a mile in length. Large barracks are maintained here, containing a considerable establishment of military. Part of the old walls, and two ancient circular towers with conical tops, are all that remain of the castle of the Maguires, the lords of Fermanagh; these formed the defence against James II. Enniskillen was considered a military position



---

p.272



and the chief pass between the provinces of Connaught and Ulster. A large School-house, the funds of which are said to be £3000 per annum, from land granted by Charles I., *occupies* a conspicuous place on Portora Hill; and on an eminence near the town stands the Infirmary. I was surprised to learn that three newspapers, all of tory or conservative politics, are published in Enniskillen, though the population is only 8000. The town has two distilleries; the trade in general is steady, and the shopkeepers are respectable. Many gentlemen of property reside in the vicinity probably induced to settle there by the extreme beauty of the scenery.


Lough Erne extends from the south east to the north west, across the county of Fermanagh, Enniskillen being situated nearly in the centre, at the point where the lake divides into the upper and the lower water. The northern or lower lake, which is much the more extensive and important, expands at the north end into the form of a rude cross,the arms of which stretch about 12 miles from east to west; but the width of the lake from shore


---

p.273



to shore, in the greatest distance, is not more than four miles. From Enniskillen to the northern extremity is sixteen miles. The lake discharges its waters by way of Belleek, on the north western side of the county of Fermanagh, by a fall of 20 feet amidst precipitous rocks. It next passes Ballyshannon (a town in Donegal, celebrated for its extraordinary salmon-leap), expanding to a great width and with remarkable beauty, and flowing smoothly forward to the fall, which is fourteen feet perpendicular. Here the leaps of the salmon at low water are extraordinary. This fishery is said to produce:£1000 a year.


A short distance from Enniskillen, the upper lake opens out into a sheet of water about three miles in diameter, above which it again contracts. Still further up, the land and water are intermingled in about an equal proportion of islands and lake, the latter assuming the appearance of narrow channels. Lough Erne stretches through the country to near Belturbet, in the county of Cavan, varying from one to two miles in width. The distance from Belleek to Belturbet (according to 


---

p.274




a report to the Geological Society, drawn up by Lieutenant J. Wolfe, R.N.) is about 35 miles, being the greatest length of navigation on any Irish lake. Its whole navigable length, including the estuary at Ballyshannon, is 45 miles. The depth in some parts is upwards of 200 feet. The peculiarities of the shore have suggested the use of a flat-bottomed boat called a cot, with a long slope at each end, which is square. The shape of these boats prevents them from moving rapidly through the water, and in rough weather they are dangerous. According to common report, Lough Erne contains 365 islands; but as the height of the surface of the lake varies to the extent of eight feet, the number (of those that are visible) will greatly depend upon the state of the water. My friend Mr. Robert Harding, the government valuator, informed me that there are in reality about 150 islands, and 50 rocks or sand banks.


I must not omit to mention that Enniskillen is remarkable for containing only one pump! — the water of the lake serving the purposes of both washing and drinking.




---

p.275


Devenish Isle — Pillar Tower — Monastery — Stone coffins — Ely Lodge — Lough Erne — Comparison of this lake with Windermere — Castle Coole — Wild water-fowl — Instance of Irish industry — Belleisle — Examination at Lisbellaw — Wages of farm servants — Spirit-drinking — Clothings — State of the population — Average size of farms — Agents' fees — Objections to a poor law — Inequality of the cess — condition of the people deteriorated since 1799 — Soil of the barony — Cairn on the Topped Mountain — Distant prospect — Interior of a cottage at Ballinamalard — Some remedy for the general destitution absolutely necessary.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Devenish Isle, on Lough Erne, (little more than a mile from Enniskillen) is rich in objects of antiquarian interest. Here are the ruins of an abbey and a monastery, between which stands a pillar-tower, thought by some to be the most beautiful of any of those mysterious buildings. The height has been variously stated at 90, 76, 82 feet, and 82 feet 10 inches, and the circumference from 41 to 48 feet. The differences in the measurements



---

p.276





of the circumference may be accounted for from its being wider at the bottom than the top.


The walls of this remarkable structure are of hewn stone and mortar, and are 3 feet 6 inches thick. In the uppermost story are four windows, corresponding with the cardinal points, and above each is a keystone, ornamented with a sculptured human head. The conical roof is supported by diminishing courses, and finished by a well-shaped capstone. In the inside the tower is smooth, except for projecting rests, presumed to be for the support of floors. Additional interest attaches to this remarkable monument when viewed in connexion with its venerable companions in ruins, particularly the monastery or upper church, with its beautiful little ivy-mantled tower. The basement story is groined, and through the ceiling, which is of limestone, two apertures are worn smooth by the passing of the bell-ropes. The carving of the fluted architraves is very perfect. In a spiral staircase leading to the battlements of the tower is a tablet bearing an ancient inscription, dated 1449, signifying



---

p.277



that Bartholomew O'Flanragan was prior. In another part is a niche, exhibiting the arms probably of the founder. The buildings are composed of a dark limestone found on the borders of the lake. The monastery or abbey is supposed to be of a much earlier date, and has suffered in a greater degree from the effects of time. These religious edifices are said by the Rev. G. N. Wright to have been founded by Lasrean, also called St Molaisse, a native of Carberry near Sligo, previously to the year 567. The day of his decease, the 12th of September, being well attested, was for many years observed as a festival in the island. Each of the buildings formerly possessed a bell, but at the suppression it was directed that they should be carried to Armagh. On this occasion (which is supposed to have been the anniversary of the Saint's death), one of them was conveyed safely over the lake, but the boat containing the other, sunk; — the place where the bell is supposed to lie, is pointed out. A little to the south of the ruins is a stone coffin, the interior assuming the shape of a human body. This



---

p.278





coffin is called Molaisse's bed, and is renowned for the virtue it possesses in the removal of diseases, and for the good fortune conferred upon those whose shapes it happens to suit.


The burial-ground in Devenish Isle is still used as a place of interment. The funeral party embark at the opposite shore in the cots above-mentioned, and incur considerable danger in the passage across. A few years ago seventeen persons were drowned on an expedition of this sort; but an old woman and two men, who clung to the coffin in their extremity, were saved.


Devenish Isle contains 120 acres, a considerable part of it rich grazing land without a tree. The rent, I was informed, is £110 per annum. One solitary cottage, occupied by a herdsman, is the only inhabited building on the island. The sheep are boated across, and the cattle driven through the shallow part of the lake called the Friar's Leap.


I have frequently had occasion to speak of the superstition and credulity of the people. At the monastery here an extravagant tale was related



---

p.279



about the stone with the inscription having being conveyed to the county jail at Enniskillen, but the men not being able to prevent it from falling, were obliged to replace it in its original situation.


From Devenish Isle we proceeded to Ely Lodge, the seat of the Marquis of Ely. This mansion is beautifully situated on one of the islands of Lough Erne, and we saw it to great advantage. The foliage wore the peculiarly rich and yet pensive hues of autumn — and the day, hushed, and calm, and breezeless, was in character with the season. The company of soft and silver clouds that gathered about the sun, and shaded his glory without obscuring it, were reflected within the bosom of the clear and waveless lake.


Lough Erne is allowed to be the Windermere of Ireland, but in extent and in the number and beauty of its islands it far surpasses our Windermere. On the Queen of the English lakes there is no island in the least degree comparable to that on which Ely Lodge is situated, nor am I aware that this, though the largest and most beautiful


---

p.280




I have visited, is the finest. The mountains at the head of Windermere are certainly more striking and picturesque than any scenery Lough Erne can boast, which is generally of a richer and more fertile and luxurious description; but compared with Lough Erne, Windermere is an extensive pond.


Ely Lodge is a plain structure with painted walls, but the park and pleasure grounds are truly beautiful. The mansion is approached over a strait of the lough by a handsome bridge, at the end of which are massive iron gates, well barricaded, and committed to the custody of a porter. Within these gates the road winds gracefully round a hill, on the summit of which the house is situated. The grounds abound with wood — and here and there vistas, of rather too artificial an appearance, afford glimpses of the lake.


In our way to Ely Lodge we passed through the estates of the Rev. Mr. Reed, who is spoken of as a kind landlord, and lets his land at 15s. and 16s. per Irish acre, for which other landlords would get 25s. Here we conversed with a respectable


---

p.281



looking man, who farms less than five acres. He and his wife appeared perfectly happy, and supplied another proof that small farms are not incompatible with prosperity.


A mile and a half to the south east of Enniskillen Lord Belmore has a superb mansion, Castle Coole, considered to be the most splendid piece of architecture of the kind in Ireland. It is built in the Doric and Ionic style, of beautiful Portland stone, highly ornamented, and finished with frieze and entablature. A noble portico, consisting of four columns, and extending to the height of the building, supports a well-proportioned pediment. This splendid and classical edifice, in which beauty and utility are united with admirable skill, was designed by Wyatt about the year 1790, and is said to have cost upwards of £100,000. The site, without being too high for shelter, is sufficiently high to command a magnificent view of the surrounding country. On the summit of a green hill to the east of the house is an ancient rath, whose outer rampart contains a number of thorn trees, apparently some centuries old.




---

p.282


In the domain are several lakes, stocked with wild fowl. On one in particular they are preserved with great care. The water seemed almost covered with bald coots, wild ducks, widgeons, divers, teals, bitterns, wild geese, and swans, all of which, confident of security, allowed us to approach within a short distance, without betraying any symptom of alarm. The grounds contain a good deal of fine timber. Some Spanish chestnut trees in front of the house measure seventeen feet in circumference, five feet from the ground. Here too, I was gratified by seeing numbers of poor men employed; and from the character of their work (which consisted chiefly of filling up hollows, making smooth what nature had made rough, and removing hills where hills were ornamental), I should infer that they were engaged more with a view to their own advantage than to any real benefit that might accrue to Lord Belmore from their labours. His lordship resides at Castle Coole three months in the year.


Many of the tenants from a great distance were attending with their carts, to take away poles of



---

p.283




Scotch, spruce and silver fir, lately cut out of the plantations, and given to them by their landlord for roofing their cabins. A cart-load was not worth above 12s., and was conveyed upwards of thirty miles, the poor fellows being out on their journey two nights and three days, and travelling, both ways, no less a distance than sixty miles for a load of wood which certainly would not last more than six or seven years. Who, with such facts as this before him, can deny that the Irish are industrious and persevering — These men, I was informed, would only expend a few pence on the road, eating nothing but a piece or two of bread. Indeed, they think lightly of difficulty, when a worthy object is to be obtained. Many of them travel several miles for days together, to obtain work, and though often disappointed, still persevere. When they succeed, they only get 10d. or 1s. per day at the most.


Belleisle, the property of the Rev. Gray Porter, is situated on the higher lake, and in addition to its beauty, is remarkable as being the first grant made in Ireland after the confiscation. It contains



---

p.284



upwards of 300 acres, and was originally the property of a Lord Ross, who from this island took the title of Lord Belleisle. It descended by marriage to Sir H. Hardinge, who sold it to the present proprietor. The house, once famed for its hospitality, is now a ruin.


On the 20th and 21st of October we held our examination in the school room of Lisbellaw, a village between five and six miles south-east of Enniskillen, on the border of the barony of Tyrkennedy, and containing about 250 inhabitants.


We ascertained that owing to the declining means of the farmers, employment for labourers had decreased; at the same time, the wages of farm servants were on the rise. This apparent contradiction is explained by the fact of this class of labourers being the most eagerly sought and the most difficult to obtain; for as soon as they can collect a little money, they almost invariably emigrate. The income of a labourer will not enable him to make any provision against casualties.


The same cause which had decreased the employment of labourers, had contributed to render


---

p.285



spirit-drinking less prevalent. "The sale of spirit," said one of the witnesses, "is greater when the money is stirring."


In respect of clothing the labourers were stated to be wretchedly off. The yearly expenditure of a family for clothes was calculated to amount to about £2; but it was added, that many did not spend six shillings during the twelve months, for this purpose. They have no shoes; "some of them, 'tis true, have things on their feet," (to quote the words of the above witness) "to keep them from the stones, but they are of no use." The pawnbroking system is the same as in Monaghan.


Again and again were we informed that the small tenants were in a wretched condition, the entire body of them being in debt, to the amount of at least one year's rent. It was said to be impossible for a man, paying as much as from thirty shillings to two pounds an acre, to live comfortably — as to making money, *that* of course was out of the question. So greatly reduced was the capital of the farmer, and confidence had received


---

p.286



so severe a shock, that it had become more difficult to borrow £5 than it was ten years ago to borrow £50. This change is attributable to high rents and low prices; trade, moreover, is gone, and the looms are standing idle in the farmers' houses. Yet, notwithstanding all these things, it was stated that if a farm of five or ten acres were vacant, there would be as many bidders in the barony as acres on the farm. The question with a bidder is not what the farm is worth, but what offer would be likely to secure it.


The average size of farms is from ten to twelve Irish acres. The rent of the larger ones is £1.10s. per acre; that of the smaller ones from £1, 15s. to £2, and sometimes even more.


The principal proprietors in this barony are two noblemen, but the gentry are numerous. It was stated to be the custom here, and a truly disgraceful custom it is, on the signing of a lease, for the agent, his wife, his sister, or his clerk, to receive a compliment in money, equal to about one year's rent.


The barony consists principally of tillage farms,


---

p.287



about two-thirds of them being under the plough. The rotation is, 1st — potatoes manured; 2d — oats or flax, and afterwards as many crops of oats as can be got; after this "they let it out," that is, the ground is left to nature. Clover, vetches, trefoil, rye-grass, or other artificial grasses, are little, if at all, grown in the barony. Neither turnips nor mangel wurzel have found their way, nor has any improvement taken place in the breed of cattle or sheep.


A great dislike was evinced on the part of the meeting to the objects of the Commission on which we were engaged, lest it should lead to an additional burden in the shape of poor-rate; and all present were strongly opposed to the establishment of a poor law, alleging that if at first it would require only one shilling per acre, it would very soon be 2s. 6d. The poor householder upon whom the burden would fall, is often, they stated, worse off than the travelling mendicant; they accordingly preferred being as they were. "We might help the poor," they said, "for some years, with what the houses would cost; we think we do not miss


---

p.288




what we now give." And on being asked what they conceived it cost them at present in charity, the indignant reply was, "We should be ashamed to keep any account of what we give to the poor." In favour of a poor-law it was remarked, that the absentees would then have to contribute, and that under the present state of things the itinerant beggars, who carry disease and immorality through the country, would be taken care of.


Here, as in other places, complaints were made respecting the inequality of the cess. Some pay ninepence, others 2s. 4d. for the same quality of land. One end of the barony pays twice as much as the other; that which pays the least being the better land.


By comparing the account given in 1779 by **Arthur Young**, with the facts elicited in the course of this examination, it will be evident that the condition of the lower Irish, instead of being improved, is considerably deteriorated since his valuable book was written. "The people," says he, "in the neighbourhood of Castle Caldwell on Lough Erne, increase very fast, and are much more industrious


---

p.289



and in better circumstances than some years previously. Their food, for three-fourths of the year, consists chiefly of potatoes and milk, and during the other quarter, of oatmeal. In the winter they have herrings. They have all a bellyful, whatever it is, and keep cows." — (P. 224, vol. i.) And at p. 231, alluding to Enniskillen, he says, "Some live on potatoes and milk, for they all keep cows, and have flesh meat." At page 241, in reference to Florence Court — "Their food is potatoes, oaten bread, and a bit of beef or bacon in winter. They all keep cows, most of them pigs, and even poultry."


The soil of this barony varies considerably; near to Enniskillen is a rich loam, in some instances on a clayey, and in others, a peaty subsoil — the low moist lands being occupied as meadows and pastures. The grounds of medium elevation are chiefly arable, and consist of a good brown loam upon a moderately retentive subsoil, and, if properly cultivated, are capable of great fertility. The remainder of the barony is of a light brown soil, frequently upon a clayey gravel, or


---

p.290




consists of a moory or peaty soil upon clay. Cornagrade, near Enniskillen, affords good limestone, from which a great part of the barony is supplied.


On returning from Lisbellaw to Enniskillen, we followed the direction of a stream, which flows through the village into Lough Erne. By the brook-side we observed some neat comfortable looking habitations in the English cottage style, white-washed and surrounded by trees and orchards. As we had to pass near the Topped Mountain, we took the opportunity of crossing its summit, from which, although only 909 feet high, nine counties are seen; and Lough Erne, with its numerous islands and inlets, may be distinctly traced. The summit of this hill is remarkable also for a cairn, said to contain the graves of three Danish princesses. This cairn is a large mound of stones, 250 feet in circumference, covered with sods and grass. From this eminence we had the pleasure of recognising the mountains of Bessy Bell and Mary Gray; up the former of which, now nearly forty miles distant, we toiled from



---

p.291




Omagh; to the east, the mountains of Monaghan, forty or fifty miles off — to the south, those of Cavan, and to the north, the mountains of Donegal, and Tyrone, Sleu Culkagh, Knock Ninny, and others in Fermanagh. The domain of Castle Coole lay beneath us like a map.


At Ballinamalard, where we next attended, are several miserable hovels, into one of which I took the liberty of creeping. It was inhabited by a feeble old woman of eighty-five, named Jane Lee, and her daughter. The interior measured nine feet six inches, by eight feet two inches. The furniture consisted of two small four-legged stools, about eight inches high, and seven inches broad; a small pan, and part of a wanded basket, which would scarcely hold together; but out of which the poor old woman was eating her dinner of potatoes. A half-starved cat was mewing most piteously — and in a corner of this desolate apartment, on the clay floor, a quantity of straw lay, with a sort of blanket over it. This served the purpose of a bed, and was obliged to be moved from one side of the hut to the other, to avoid the



---

p.292



rain falling on them, through the scanty roof. In another corner lay a few seeds, or oat husks, from a neighbouring mill; this formed all their supply for the fire. The floor was exceedingly damp, and adjoining the wall was a small trench, or ditch, to hold the water in; from which unusual sort of reservoir it was collected, and thrown out of the cabin. The door, two feet wide, and four feet six inches in height, extended to the eaves. The hut had no chimney; and that which bore the name of window, consisted of a morsel of glass, 4 1/2 inches in diameter, which the kindness of a neighbour had contributed. The old woman had not been able to pay any rent lately, and the landlord accordingly would not be expected to thatch her dilapidated residence. She was, therefore, obliged to get some one to do it, and begged and scraped a little straw together as she could, for the purpose. The walls of this wretched abode were built partly of stone and mud, and partly of sods. Jane Lee had lived in it eleven years, and appeared, as the reader does not require to be informed, in a state of the greatest destitution and 



---

p.293



distress; the daughter was afflicted with illness, the consequence of a severe cold. The widow said she was able in summer to beg a little buttermilk to her potato, but not in winter; she would rather have a piece of a herring than buttermilk, *for it was more tasty.* An expression of what I am sure was genuine gratitude, followed the bestowal of a small sum of money. She had been the mother of three sons, two of whom had perished in the army; the other went to America, and she had never heard of him since.


The cottage which I have attempted to describe, is situated — not on a lonely and uncultivated moor or bog, far beyond the reach of civilization and the comforts of life — but in the midst of a considerable village, and in the vicinity of wealth. The misery, of which it is but a solitary specimen, is not confined to the idle and dissolute, but extends to the industrious and the meritorious. In Ireland indeed, merit loses its value, and industry becomes discouraged and paralysed under the impossibility of being rewarded. Humanity and justice require the application of some effectual remedy



---

p.294



for this acknowledged evil, and it is to hoped that the wisdom of the legislature may speedily supply one. If the subject is beset, as it undoubtedly is, with difficulties of formidable aspect, it should be borne in mind that the sufferings to be relieved are formidable also.




---

p.295


Florence Court — The Claddagh — Crystals — Prices of provisions at Enniskillen — Ploughing by the tail — Middlemen — Cottiers — Large and small farms — Crom Castle — Poisoning of cows — Cavan — Lord Farnham's Schools — Belturbet — Bishop of Kilmore's palace — Church and church-yard — Bishop Bedell — Examination at Ballinaught — The police — Conacre — Competition for farms — Tithe — Leases — Farmers poorer than they were — Rents and cess — Religious persecution — Owen Gray's cottage — Trade of Ballinaught — Market-day at Belturbet — "Staggering Bob" — "Bullockeen" — Barony of Loughtee — Deplorable condition of agriculture — Country between Belturbet and Killykeen — Picturesque scenery — Killykeen Lake — Land of Lakes — Irish waiters — Illicit stills.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Florence Court, the seat of the Earl of Enniskillen, nine or ten miles south-west of that town, is seated at the foot of a fine chain of mountains, and surrounded by extensive grounds, richly wooded. It contains some valuable works by Rembrandt, Rubens, Salvator Rosa, and other eminent masters. The Earl's property in this neighbourhood is said to be worth £14,000 a year. His lordship is an absentee.




---

p.296


The scenery about Florence Court is very beautiful, and near it is a natural curiosity, much visited by strangers. From a large cave, having the appearance of a rude broken arch, the Claddagh, a powerful stream, issues with great force — the several rivulets which supply it being all lost sight of, at or near Cats-pole, and running along a subterraneous passage for about three quarters of a mile. The rocks are of marble, and the entrance to the cave is accordingly called the Marble Arch. The Claddagh falls into the Arney river, east of Lough Nilley, called also Lough Macnean Lower. This Lough is three miles long, and nearly one broad; the cliffs and hills about it are remarkably precipitous, and a wooded rocky island with a cottage upon it, adds greatly to the picturesque effect of the scenery. Upper Lough Macnean, separated from the Lower by a road, is five miles long, and upwards of a mile in width.


Near Lough Erne are the ruins of four ancient castles, similar to Portora Castle, near Enniskillen. The lands adjoining this castle, were granted to



---

p.297



William Cole, Esq., an ancestor of the present Earl of Enniskillen, who, according to certain conditions imposed on obtaining the grant, was to build a house or castle upon them.


The neighbourhood of Enniskillen affords very beautiful specimens of double terminated rock crystals, detached as well as in groups; they are transparent and pure as water.


The price of provisions at Enniskillen was as follows: — Potatoes, from 2d. to 3d. per stone; mutton, 4d. to 6d.; butter, 7 1/2d.; beef, from 3 1/2d. to 5d.; fine salmon-trout, weighing six or 7 lbs., from 2d. to 3d. per lb.


**Arthur Young** gives us the following account of the prices of fish and fowls, when he was at Enniskillen in 1779: — "Wild ducks 3d., and powder and shot; plover, l 1/2d. and do.; woodcocks, 1d. and do.; salmon, 1 1/2d. per lb.; trout, perch, pike, and bream, so plentiful as to have no price; herrings, 3d. to 9d. per hundred; lobsters, 3s. 6d. to 4s. per dozen." He further says, "In 20 years there has been a rise of 2d. per day in labour. In provisions there has been a considerable


---

p.298



rise; 20 per cent. in meal; a plough cost 11s. 4 1/2d.; a sledge car, 2s. 2d.; a poor man's sod cabin £2; his turf for the year, 20s." The average rent of cultivated land he states to be at that time, 10s. per acre, and the county cess, 4d.; and that men received 8d. a day for getting up potatoes, and children 5d. The price of potatoes was 8s. the barrel of 6 cwt., or 2d. per stone. On visiting Florence Court he remarks, "They plough all with horses, except gentlemen, three abreast, and do half an acre a day. Drawing by the tail not done these seven years.[13](javascript:footNote('E830001-002/note013.html')) The price of ploughing, 10s. the acre; of digging the acre, 12s."




---

p.299


The practice of letting large portions of land to middlemen has been very prevalent here, but I trust is gradually getting into disuse. The county surveyor informed me that in a district of Fermanagh with which he was well acquainted, containing 3,500 statute acres, (1,000 of which is bog, unprofitable except for fuel) are 70 tenants, holding directly from the lord of the soil; and under these are 167 tenants, making in all 237 families. The direct tenants hold, on an average, 36 acres of green pasture and arable land from the lord of the soil, and retain 18 acres each in their immediate possession; the remainder they rent. The 167 under-tenants occupy less than 8 acres each, for which they pay such a high rent, that the portion retained by the direct tenants is actually rent-free to them. In many cases the under-tenants pay more than the entire head-rent, to which, if we add the difference in value between the portion kept (always the best of the land), and the part relet, an idea may be formed of the profit on one side, and the wretchedness on the other. It may be asked, why does the under-tenant



---

p.300



promise, and how is he enabled to pay such exorbitant rent? He *promises,* because he cannot get land any cheaper, and he calculates on having potatoes out of the crop to support himself and family, which is no trivial object; and he *pays* the rent, in part by giving to his landlord the whole produce, except the portion his family consume in potatoes, and partly by a share of his earnings in saving the crops of his more fortunate neighbours in England and Scotland. The class called cottiers hold a cabin, the erection of which costs the farmer ten or 12s. They have liberty to cut and save as much turf as serves for the family. In addition to this, the farmer manures a rood of ground, in which the cottier plants potatoes and flax; for this rood of land he gives four days' labour every week (some are obliged to give five days), during which time he is fed by the farmer; so that, for the use of one rood of land, while it is growing one crop, and as much fuel as partially warms his cabin (and this he must cut and save himself), he is obliged to give two-thirds of his year's labour. The remainder of the year,



---

p.301



with the exception of the time employed with his own little crop (which his family might do), he is generally as the Irish term it "idle." This word is invariably used throughout Ireland as synonymous with the lack of employment, not, as in England, with the lack of disposition to work. In reality, therefore, the cottier's whole time is lost, so far as himself is concerned, in cultivating and paying for one rood of land, and having possession of a wretched cabin. A very considerable portion of the wretchedness of the country arises, I am persuaded, from the system adopted by many landlords, of making large farms, by which the poorer classes are turned out, some of them into the wide world to emigrate, or to beg, and others to seek some miserable cabin for shelter, and land that will merely produce as many potatoes as will keep soul and body together, or, as one of the cottiers said, "keep them just winking." For this they must pay an extravagant rent. The system alluded to has operated to a frightful extent since the disfranchisement of the forty-shilling freeholders; and it is well worthy the consideration 



---

p.302




of landlords, whether it would not be better, both as regards the country and their own interests, to have, in certain districts, ten small farmers, each occupying 10 acres, upon 100 acres, than to have one or two farmers of deficient capital, and eight or nine miserable paupers. It has been agreed on all hands, in every barony, that ten small farmers, on ten acres each, produce more food than one farmer occupying 100 acres. That the small farms pay higher rent, is universally acknowledged; if, therefore, producing more food, paying the landlord higher rent, and preserving the country from outrage and pauperism, are advantages — propositions that will not be denied — surely an unanswerable argument is established in their favour.


It is well known that farms are smaller in the north of Ireland — that land lets higher — and that outrage is less frequent. This may be partly attributed to the circumstance of the people having houses and little farms, a sort of home — and to an Irishman, a home, however poor, is dear. These give them a stake in the country, and make



---

p.303





them reluctant to join in any movement that may endanger it.


The small farm system has few advocates, and has been very unfairly judged and decried. By those who do not take the pains to ascertain the difference, small farmers have been considered identical with the under-tenants already described, who are bowed down with wretchedness, owing to the exorbitant profits wrung from them by the middlemen.


On the 27th we left Enniskillen for Cavan, and had the advantage, as we went, of several transient, but lovely glimpses of Upper Lough Erne, our road lying on the eastern side of it. Near the head of the Lake, adjoining the county Cavan, is Crom Castle, the seat of — Creighton, Esq., previously mentioned as one of the best landlords in Ireland. He not only teaches his tenants to improve their farms, but assists them in doing it, and refuses to take more rent than he is persuaded the land is worth, although offered to him. If this system were generally adopted by Irish landlords, the country would soon be in a flourishing condition.




---

p.304


Near the church of Newton Butler on our left, some cows had been lately poisoned with oil of vitriol, an attempt at the same time being made on the farmer's life. The general opinion was, that though his house was stored with fire-arms, he would eventually fall a sacrifice to the malice of his neighbours.


This district of the county of Cavan is impoverished and neglected, many parts being overspread with furze and rushes. The town of Cavan contains nearly 3,000 inhabitants, and belongs to Lord Farnham. It is almost superfluous to state that we found here a Prison and extensive Barracks. The Court-house is a handsome building, and contains an excellent newsroom.


Lord Farnham has a seat in the neighbourhood. His lordship is an agriculturist — grows turnips, and ploughs with oxen. He has, moreover, exhibited great zeal in the establishment of schools for the religious education of the people, and employs what is called "a moral agent," who has the privilege, I was informed, of a house and grounds, and receives £300 per annum for his



---

p.305



services. His duty is to superintend the moral and religious education of the people, and use his exertions for the conversion of the Roman Catholics, and the general prosperity of the Protestant faith. Lord Mandeville also employs a moral agent for the same purposes. Lord Farnham, it is said, attempted the conversion of the poor Catholics in the neighbourhood, by preaching and presents. The presents, it is added, made more proselytes than the preaching; but the Catholics were in distressed circumstances, and could not resist the temptation of relief.


Accompanied by the county surveyor, we travelled into the country for the purpose of giving notice of our intended examination. After crossing, at Butler's Bridge, the Erne, a clear river that flows into the loch, and passing a considerable lake on our left, and on the opposite side of the road, the ruins of an old church, we entered Belturbet, a pleasant town, conveniently situated for tourists, near the head of Lough Erne. Belturbet contains a population of about 2000, and has a considerable trade. A new bridge of three elliptical



---

p.306



arches, from a design by Mr. Armstrong, was in process of building over the Erne. The limestone used in the erection of it, and obtained on the banks of the river, is a splendid specimen of the primitive or mountain limestone.


On the road to Ballinaught, a small town to the southward of Cavan, we pass by the side of the Bishop of Kilmore's domains for a considerable distance. These noble grounds are well watered, beautifully wooded, and abundantly stocked with deer and pure Devon cattle, of deep red colour, and without a spot. The Bishop has lately erected a palace in lieu of the old one, which still exists, and is a capacious building in the Elizabethan style of architecture. It stands on a commanding eminence, and is surrounded by lofty trees. The new palace occupies a lower site, is built in the Grecian Doric style, and covered with Roman cement. It appears too lofty, and in other respects is not well proportioned. The drive from the public road to the house is badly arranged, being tortured into short curves, for which the character of the ground is not fitted. The present


---

p.307



bishop, Dr. Beresford, is an elderly man, and has the character of being kind to the poor.


The church and the grave-yard are in the vicinity of the old palace on the hill. The former has suffered deplorably from the attempts of some rustic Vitruvius to modernize its exterior: fortunately, however, a fine old Saxon door-way has escaped the touch of the spoiler, and, being of hard stone, retains much of its original beauty and sharpness of execution. In the church-yard are many ancient tombstones; but the most noticeable object within its crowded precincts, is the tomb (overgrown with shamrock) of the learned and venerable Bedell, who was consecrated bishop of Kilmore and Ardagh, in the year 1629. The memory of this excellent prelate is piously cherished by men of all parties, as, indeed, it deserves to be. Bishop Bedell caused the Book of Common Prayer to be read in Irish every Sunday in his cathedral, and sought to propagate his own religion, not by adopting hostile measures against those of the opposite faith, but by circulating the Scriptures and useful tracts among the people, and


---

p.308



by the example of a life unremittingly devoted to the purest and the holiest purposes. Bishop Bedell is remarkable, too, for the determined stand which he made against pluralities. In order the more effectually to put an end to a system which the majority of good men have concurred in condemning, he separated the see of Ardagh from that of Kilmore, though he had been at considerable expense in recovering some of its revenues. Since his time, however, they have been re-united. This venerable man died in the 71st year of his age; and, to mark the respect with which his character was regarded, the Irish rebels attended his funeral, and fired a volley over his grave, — exclaiming, in Latin, "Requiescat in pace ultimus Anglorum — May the last of the English rest in peace!" And a Roman Catholic priest, who was present on the occasion, is said to have paid him a tribute of respect and veneration in the following wish: — "O sit anima mea cum Bedello! — May my soul be with that of Bedell!"[14](javascript:footNote('E830001-002/note014.html'))




---

p.309


Our examination at Ballinaught (in the barony of Loughtee Lower, near Cavan) commenced on the 31st of October; and here, before transcribing some of the facts detailed before us, I may be permitted to state, that in issuing our notices, and making the necessary arrangements for the performance of our duties, we invariably found the police extremely obliging, and ready to assist in promoting our plans. This body of men, whom I scarcely ever saw armed, appear remarkably well regulated, and are respected by the poorer classes for their moderation and propriety of conduct; — another proof that, under a conciliatory system of government, the Irish may be successfully managed.


The condition of the day labourers, who are increasing in number, has been gradually deteriorating for the last twenty-five years; in consequence, however, of so many young men emigrating to America, farm servants are more in demand than formerly. As to the wages of labourers, there are some periods of the year in which they get 8d. a day and their diet; but the



---

p.310



usual average may be stated at 8d. in winter, and 10d. in summer, without diet, nor are they employed more than half their time. During the dry days in winter, they have been known to engage themselves for 7£d. a day, without diet. They would consider themselves well off with regular wages of 8d. in winter, and 10d. in summer, without diet. An exceedingly unjust custom prevails here with respect to the payment for *portions* of days. If it should rain before mid-day, the labourer receives no recompense for the time spent by him at his work, though he does not give over till eleven o'clock.


We had abundant opportunities of verifying, by actual inspection of the people in their houses, the concurrent statements of the witnesses as to the wretched condition of the clothing of the labourers; yet, notwithstanding their ragged state, they spend more than a penny a day in smoking, which happily appears to have superseded the pernicious habit of drinking. There is hot one-tenth of the drinking now that there was some years since. Here, as in other baronies, the



---

p.311



labourers marry early, and make no provision. A boy of one of the witnesses married at fifteen; his master lent him the marriage money. He is now twenty-two years old, and has five children.


The labourer is attached to conacre, because it enables him to obtain his potatoes at the least expense. On his own labour he sets no value, inasmuch as he tills the conacre only during those days on which he can get no other employment. In the next place, he secures food during the winter; and, in addition to this, has small potatoes for his pig. The farmers manure and prepare the land for the reception of seed. The labourers then provide the seed and plant it; and afterwards weed and manage the crop. The rent, averaging £9. 9s. per Irish acre, is paid in money or work — sometimes in both. In one shape or other, the Assistant Commissioners met with the conacre system in every part of the province of Ulster. The Tyrone and Fermanagh cottiers are conacre takers, under another name; the cottiers pay their rents altogether in work, and are bound to give certain days in the week to the 


---

p.312





landlord. The system appears to owe its origin to the want of a free circulation of money. The farmer gives land, and the labourer work: it is a reciprocity of commodities, under present circumstances, advantageous to both parties.


The competition for farms of five or ten acres, the average size being from six to eight, is excessive: and for the tenant-right a man will give his last sixpence. The remission of rents is unknown in this part of the country: so also is the forbearance that allows a portion which the tenant is unable to pay, to stand over. The farms are generally tilled by hand labour.


In most parts of the barony, tithe had not been collected for the last three years; but the people were apprehensive that a large demand for the arrears might be made on them; "such a proceeding," said one of the witnesses, "would put the finishing stroke on us." As for the agriculture of the barony, it is, from want of skill and capital, in the worst possible condition; and, as far as the Assistant Commissioners could learn, no landlord, with the exception of Mr.



---

p.313



Creighton, takes the slightest interest in improving it.


Many of the leases in the barony are held in common, twenty or thirty persons joining at a lease; but this most wretched system, as well as that of middlemen, is fortunately declining. The usual covenants of leases are those which oblige the tenant not to set or sell the land, on the penalty of forfeiting his lease. With the exception of a provision against burning the land, they contain no clauses enforcing a particular system of farming, nor any specific regulations for the guidance of the tenant. Some of the proprietors charge duty-money and agent's fees. The land-agent also gets a compliment of from one to four guineas; four guineas, for instance, for a rent of nine. But little money is given here for the goodwill of a farm, without a lease — a circumstance that indicates a less degree of confidence than exists in other counties.


Since the commutation of tithes, and in consequence of it, the produce of grain has considerably increased. Previously, the titheable land, when


---

p.314




in crop, paid 7s. per acre. The farmers are unable to make meal — being obliged to sell the oats immediately, to pay the rent and debts unavoidably contracted before harvest; the mills stand idle — some of them being broken up. Nor can the small farmers afford to retain any of their corn for their own consumption; indeed, they are often obliged to procure provisions on credit in summer. Seven years ago, they lent money; they are now obliged to borrow, if they can.


The rent of land is from £1. 5s. to £2. 15s. per Irish acre; for the mountainous districts, suitable only for pasture, 16s. is paid. The grand jury cess varies from four to six shillings a year per acre; it is considered exceedingly unequal and oppressive, and is bitterly complained of by every body.


The farmers here, as in Fermanagh and Tyrone, complain that although they pay heavily towards the roads, they are much neglected; and I can bear testimony to the justice of their complaint, for never did I travel upon such shocking roads, as in parts of this county, and that of Tyrone. I



---

p.315




do not allude to the coach roads, or those near gentlemen's premises.


The soil of Upper Loughtee is, for the most part, weak and light, upon a greenstone or basaltic rock. In Lower Loughtee it is rather shallow, upon clay and limestone gravel. The usual rotation is very scourging and impoverishing; and when the land has been deprived of its productive powers, it is left to nature and time, till ready for a repetition of the former operations.


Some of the large proprietors, we were informed, had dislodged their Roman Catholic tenantry, *because they were Roman Catholics.* "Twenty families," said a witness, "are under notice to quit to-morrow. In 1826, a hundred and sixty persons were turned out in this parish; some lay in sheds, and outhouses, and road sides; others went to America. But the people, notwithstanding, are peaceably disposed, and have no idea of avenging their injuries." "Nothing," said another witness, "but the greatest oppression will induce the people to commit murder."


*Owen Gray,* one of the witnesses, said that



---

p.316




he farmed, at a rent of £2. 15s. 7d., about 6 acres of poor stony land, considerable part of the surface being rock, on a hill above Ballinaught, called the Deer Park of Belvin, belonging to Major Fleming, and that "he had no peace till it was under the care of the Court of Chancery; before that, they used to be always driving."


We visited, among others, the residence of the last witness. A drawing of it is given on the opposite page; and let me beg the reader, whilst inspecting it, to remember, that it is a correct representation of the dwelling of a man and his wife and their seven children! The whole length inside was 20 feet, the width eight, and the mud and sod walls were 3 1/2 feet high. The principal apartment in the centre was used as a day room. Two small places, entirely dark, one at each end of the house, formed the sleeping apartments. They were five feet six inches wide. The only light that cheered the dwelling of Owen Gray was admitted through the door-way, an aperture nearly four feet high. The whole of the furniture consisted of four old broken stools, about a foot in height; as for a chair, it



---

p.317



was out of the question. Their stock was one pig, and a miserable cat; for they were possessed of neither cow, goat, nor sheep. The children were all but naked; the shoulder and breast only of one boy, nine years old, who came to us outside, were partially covered with a portion of a ragged shirt. Upon my remarking to his mother that they must suffer in winter for want of clothes, she replied, that they were *obliged>* to go without, and were as fond of running out in frost and snow as if they had plenty of clothes, for they were used to it. This, indeed, the colour and deep wrinkles of their legs and feet abundantly testified. Owen Gray and his wife had been blessed with *fifteen* children, "and she had been so fruitful," (to use her own words) "that she had chanced them double three times." Eleven were living. "Bare backs," said the poor woman, "would not fret me, if we had plenty to eat. I would be a proud woman if we had potatoes and a grain of salt in times, but we cannot get the salt itself, nor even the bare potatoes, and we are lost for want of beds. Nine sleep in the two we have, which


---

p.318




are nothing but a bit of straw, covered with an old blanket." The rick yard was furnished with two small ricks or stacks, from which the morsel of grain had been nearly all thrashed out, and the straw piled up again. This dwelling was not particularly selected on account of its meanness. It was the first we came to in the barony; and while I sketched it, my companion visited others which he reported to be, if possible, worse; and I was subsequently told that many in the country were decidedly inferior to Owen Gray's. The Irish women give birth, generally, to a great number of children, many of whom die in infancy, and often from improper food. Potatoes, indeed, compose almost the sole food of all the inmates of an Irish cabin, from the man to the starved kitten.


The trade of Ballinaught has decreased. Formerly, £150 a week used to be spent in the town in the purchase of brown linens, and now there is not so much as £60 expended. The cotton trade in other places has superseded it.


It was the market-day at Belturbet when we arrived there; and the street, filled almost to overflowing —



---

p.319



and the women on the market hill, arrayed in their gayest colours, presented an appearance of singular animation and interest. We found the oats damp, and badly cleaned; from 7d. to 7 1/2 d. per stone was asked for them. The beef was very lean, and dear at the price asked, namely, from 2 1/2d. to 4d. per lb. Apples were supplied in great abundance—"the Croftons," an apple that may be described as partaking equally of the old nonpareil and the golden pippin, being the favorite.


A strange sort of food, unknown to us, is a saleable commodity in this part of the country. It consists of the carcases of calves which are killed immediately on their coming into the world. During the calving season, as many as thirty are brought into the market at Ballinaught, and sold at from 4d. to 7d. per quarter. The flesh is scalded in water, and fried with bacon. The dish, when thus cooked, is called "Staggering Bob," and is represented as very luscious. The labourers, however, are seldom, if ever, favoured with a taste of it.




---

p.320


What is often sold as beef is more usually called "Bullockeen" (a young bullock). It would be burnt in England, as unfit for food. Under the term "Bullockeen," however, the carcases of animals that are too old to be fattened, of lean cattle that die of disease, and of cattle that have been stolen, are comprehended. Eggs were sold at 2 1/2d. per dozen; and it may be a question, I think, whether they are as nutritious as English eggs, the hens being fed on nothing but potatoes. Fine trout, weighing from six to ten pounds a piece, fetch 1 1/2d. and 2d. per lb. In respect of fish the Irish have a great advantage over us; the rivers, lakes, and coasts, abounding in almost every variety, of superior size and flavour.


Our examination at Belturbet, of the barony of Lough tee, (county Cavan), was attended by several magistrates and influential men in the neighbourhood, who evinced a lively interest in the objects we had in view, and politely offered to forward them to the utmost of their powers.


Major Bailey informed us that nowhere in the world could agriculture be in a more deplorable



---

p.321



condition than it is in this part of the country; and his statement, I am convinced, from my own observation, is near the truth. Not the slightest improvement is going on, and the people are in want of even the commonest implements of husbandry. There is scarcely, for instance, a plough in the parish, the land being dug with spades; and the ploughs that do exist, are clumsy wooden things, cobbled up by the farmer himself, as well as he is able, or, if bought, they cannot cost more than seven or eight shillings each. A harrow, having wooden pegs instead of iron teeth, is transferred from one to another; yet, notwithstanding this humiliating state of things, rents are unaccountably rising, and no allowance is ever made for deficient crops. Is it not to be lamented that so fine a district, possessing within itself such admirable resources for the successful prosecution of an enlarged and enlightened system of agriculture, should be so utterly abandoned to ignorance and its inevitable consequences, poverty and degradation?


The land from Belturbet to Killykeen, nearly 


---

p.322




the whole of it Lord Farnham's, forms an exception to the uncultivated condition of the country in general. Thorn trees adorn the hedges, and extensive woods diversify the landscape; and when I state that honeysuckles and roses grow about the farm-houses, it is needless to add that the habitations here have a look of cheerfulness and comfort.


One little inlet on the shore of the lake of Killykeen I shall not soon forget. After descending a bank by a road overhung with trees, whose branches met and screened us from the sun, we came suddenly upon the little creek, whose borders were fringed with reeds and a variety of luxuriant aquatic plants, among which the fish and the water-fowl found a secure and delightful abode. Near this wild and secluded spot, upon the very brink of the lake, is a thatched cottage, tastefully ornamented with rustic wood-work, and deeply embowered in shady trees. The unexpectedness of this lovely retreat — its perfect solitude and stillness — the variety of the surrounding scene, the rich woods, the verdant hills



---

p.323



the calm lake spreading out before it, and lying without a curl upon its waters — contributed to make an impression of exquisite and permanent 
delight. Is it presumption to adopt the language of one of the most deep-souled and understanding of poets?


> 1. Those beauteous forms, 
>   
> Through a long absence, have not been to me
>   
> As is a landscape to a blind man's eye:
>   
> But oft, in lonely rooms, and 'mid the din
>   
> Of towns and cities, I have owed to them,
>   
> In hours of weariness, sensations sweet,
>   
> Felt in the blood, and felt along the heart,
>   
> And passing ev'n into my purer mind
>   
> With tranquil restoration.
> 




On this lake stand the remains of Lough Outee Castle, where Bishop Bedell was confined for refusing to give up some Protestants whom he had sheltered in the rebellion of 1641. Killykeen lake also contains an island called Trinity Island, to which we went in a cot with two rowers. The boat was a very frail one and had no seats; we provided ourselves, however, with two old chairs, and by sitting perfectly still, according to injunctions, and not looking round, we succeeded,



---

p.324



though not without some risk, in reaching the island. We landed at the promontory on which Trinity Abbey stands. This picturesque ruin occupies the centre of a circular grave-yard, surrounded by venerable and venerated old thorns. The yard is still used as a Roman Catholic burying-place. Some of the tombstones have the appearance of great antiquity. The modern ones consist of a species of limestone, which, on my *accidentally* striking it, sent forth a musical sound.


This is indeed the land of lakes. The land and water might have agreed to divide the country between them. The several lakes are connected one with another, their respective waters forming the river Erne, which, as before stated, flows into the extensive Lough of that name. This district would afford abundant amusement to the tourist for a few days, especially if he possesses an amphibious taste.


At Cavan, we took up our residence at the Farnham Arms. The Irish waiters, I may here observe, are very ready to promise, but frequently slow in their performance. Decidedly the best


---

p.325




quality of the chambermaids is good-nature—for the more they are scolded, the more they seem amused. We experienced some inconvenience from the shortness of the beds, and still more from the various bell-ropes pulling one common bell. The waiter, in consequence, had sometimes to go into every room, before he found the right one.


The mountainous parts near Cavan contain several illicit stills. A gentleman told me that the whiskey made at them is very commonly used, and that persons who buy it, frequently attend for the purpose of seeing the process, and ascertaining that the spirit is manufactured from proper materials. It is then conveyed home to the purchaser by night, and hid in a place of security.




---

p.326


Journey from Enniskillen to Sligo — Badness of the roads — Manor Hamilton — Lough Adoon — Sligo — Ravages of the cholera — The Abbey — The Quay — Effect of prohibitory duties on illicit distillation of whiskey — Potheen — A word in behalf of illicit distillers — The Garrogue — Lough Gilly — Hazlewood — A holy well — Church Island — Goat Island — The holy well of Tubernault — Cairns — Wages of labourers — Cabins — Extent of the barony of Carberry — Sobriety of the people — George Waters and his family — Employment — Marriage feasts — Conacre — Singular mode of obtaining employment on Lord Palmerston's estates — Sale of sea-weed — Crime connected with the taking of land — Dislodgement made by Sir R. G. Booth — Disinclination on the part of strangers to invest capital in farms — Early marriages — Middlemen — Absenteeism — Average size of farms — Scotch agriculturists — Breed of cattle — Butter tasters — Sea-weed — Fences — Taxation — Contributions for building a chapel — State of the roads — Bog on Lord Palmerston's estate — Drifting sands — Employment.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Having now completed the examination of the seven baronies entrusted to us, I was anxious to ascertain the state of the country and its agriculture in the west of Ireland. I accordingly took my seat in the coach to Enniskillen, and from Enniskillen proceeded to Sligo by the mail-car. The road was so exceedingly bad in many places,


---

p.327



that instead of holding my cloak about me (for it rained heavily nearly all the way) I was obliged to hold fast by the vehicle, to prevent being pitched off. Those who have travelled between Enniskillen and Sligo, can bear me out in what I say of the road, when I declare it to be almost as bad as a public road *can* be. Several miles in the county of Cavan (the driver told me) had not been mended for twenty years, yet the farmers are paying their road-cess twice a year notwithstanding. This is one of the long-standing abuses of Ireland, which I am glad to say is in progress of removal.


Manor Hamilton, a small market town through which we passed, possesses the ruins of a castle erected in Elizabeth's time; and on one side of the area occupied by these extensive remains, are some miserable huts, certainly not half so good as many English pig-sties. The seat of the Earl of Leitrim is near Manor Hamilton, so also is Cor Castle, a ruin.


As we approach Sligo, the country becomes very interesting. The rocks (which are limestone, abounding in fossil remains) are grouped in very 


---

p.328




bold and grand grey masses; some of them were pointed out as containing caverns of great extent. About eight miles from Sligo, we passed a lake called Lough Adoon, celebrated by trout-fishers for its excellent trout — some of which, caught by a gentleman who stopped at the same inn with me, I had the pleasure of tasting. They much resembled the char of the English Lakes.


Sligo has but few good streets or shops for a town whose population is already upwards of 15,000, and the trade rapidly increasing. In 1832 the cholera made dreadful ravages here; above 2000 of the inhabitants died under its influence; and nearly half the medical men fell martyrs to the disease. Knowing this, I was surprised to see such disgraceful accumulations of filth in some of the streets.


The Abbey is an extensive and beautiful old ruin. It was founded in 1252, and rebuilt in the fifteenth century. The tower rests on a Gothic arch; a considerable part of the cloisters remains; and the east window is a fine specimen of the peculiarly rich and imposing ecclesiastical architecture



---

p.329



of the fifteenth century. The quay of Sligo is a place of great activity, and admits vessels of 200 tons. As many as 60 or 70 vessels may be seen here at once. The chief exports are butter, grain, and beef; the imports, timber, grocery, and cutlery.


At Sligo I met with a retired revenue officer, who had formerly had many encounters with the mountain distillers. From his conversation I had abundant reason to be confirmed in my opinion of the injurious tendency of high prohibitory duties. Even now, greatly reduced as those duties have been since the year 1823, illicit distillation is carried on to an enormous extent; nor will this cease to be the case, whilst the contraband practice receives the sanction of many of the gentry, and the punishment of offenders excites the sympathy of those whom it was designed to admonish and deter. Since the reduction of the duty on whiskey in 1823, from 5s. 6d. to 2s. the wine gallon, the nett amount of revenue received on account of excise duties for home consumption, has been nearly, if not quite, trebled; and a superficial reasoner


---

p.330



might be disposed to conclude that the consumption of spirits in Ireland had increased in the same ratio. This, however, is not the case. The reduction of the duties has substituted, to a considerable degree, legal for illicit distillation — it has rendered that a source of national profit which previously existed without contributing one penny to the treasury of the country. Previously to 1823, the consumption of spirits in Ireland was estimated at *ten* millions of gallons, scarcely *three* millions of which paid duty. It follows, therefore, that seven millions were illegally supplied. In 1830, in consequence of the reduction of duty, the consumption was above *nine* millions of gallons, indicating a probable diminution of contraband practices to a very great extent: whether a still further reduction would be productive of still greater advantages, is a question which I shall content myself with merely proposing here. An idea of some of the evil consequences of the unreduced duties may be gathered from the following passage in Mr. Chichester's valuable pamphlet on the Irish Distillery Laws, published


---

p.331




in 1818. It is stated by Mr. Chichester that "the Irish system seemed to have been formed in order to perpetuate smuggling and anarchy. It has culled both the evils of savage and civilized life, and rejected all the advantages which they contain. The calamities of civilized warfare are, in general, inferior to those produced by the Irish distillery laws: and I doubt whether any nation of modern Europe which is not in a state of actual revolution, can furnish instances of legal cruelty commensurate to those which I have represented." — (pp. 92—107). This passage I take from an article on "Spirits" in M'Culloch's Commercial Dictionary, to which I would respectfully refer the reader for further information on the interesting subject of these remarks.


When carefully made, the potheen is considered purer than the whiskey manufactured at the public distilleries, and the price is about one-third less. A gentleman with whom we had the pleasure of dining, introduced a bottle of what he pronounced the pure potheen. He always attended the still, and watched the whole process of manufacture.



---

p.332




His plan, he informed us, was to get the maker to convey it privately in a sack to his garden, unknown even to the servants, for they are not to be trusted, neither would it be safe to have it in any considerable quantities in the house. It was then buried — and when he wanted a supply for use, he drew a bottle or two at a time *by the aid of a stomach-pump.*


Without attempting to vindicate the manufacturer of illicit whiskey, we may fairly urge in his behalf the peculiarity of his circumstances. Obliged to pay an exorbitant rent, probably to an unpitying and oppressive landlord, he is compelled to resort to any means of raising it that may present themselves; he accordingly converts his produce into liquor, which he knows to be the most profitable form it can assume, as well as the most portable. This last is a weighty consideration to one who lives many miles from a market-town, in the solitude of the mountains.


On one of the finest and freshest of autumnal mornings I embarked on the Garrogue (the Sligo river) in a boat rowed by three lads; the river



---

p.333



gradually widening as we ascended it, and revealing the exquisite scenery of Lough Gilly. At Hazlewood, the seat of Mr. Wynn, we landed in a grove, through which a walk, sometimes descending to the very edge of the water, sometimes piercing the gloom of noble trees, wound with delightful curves. On this property the **arbutus** grows in extraordinary luxuriance, and at this season of the year was seen in its greatest perfection. Clusters of scarlet strawberry-like berries, as large as Siberian crabs — mixed with light and graceful blossoms, formed a rich contrast with the bright foliage of the branches; and when reflected in the clear still water from the rocky islands which are nearly covered with it, contributed to produce an effect of indescribable splendour. The winding walk on which we disembarked, conducts to an artificial rock-house in the grove, so admirably constructed as to bear the appearance of having been a natural rude cavern. The roof consists of rude and curious rocks, and the pavement of a mixture of horses' teeth, and other materials which resemble Mosaic-work.



---

p.334




There is also a shell-house, the walls of which are profusely studded with native and foreign shells, spars, fossils, crystals, and metals.


Not long ago a library was open to the public in the shell-house; but the privilege was ungratefully abused. Shells were stolen — the books injured — and ignoble names scratched on the beautiful spars that adorned the sides of the cavern. The proprietor accordingly found it necessary to remove the library, and to admit strangers into the grounds with some degree of caution.


Not far from the house, which is a good plain building, the proverbial care of woman for all that is weak and defenceless, is displayed in an ingenious contrivance by which the wants of the feathered tribe are supplied, and their little comforts promoted. Small wooden houses, with an entrance at each end, large enough to admit a small bird, are placed on smooth poles, five or six feet high. A few crumbs of bread are laid within, and the little warbler is secure from the attacks of its enemies.




---

p.335


From Hazlewood we proceeded to a holy well up the north-east side of the lake. It is supplied by a copious spring of cold clear water, and was formerly much used for religious purposes. The polish upon the stones in front, seems to indicate that it is still considerably frequented. A station above this Well affords a good view of Lough Gilly and its islands.


We next landed on Church Island, the property of Mr. Wynn. It *possesses* the ruins of an ancient church, and contains nearly 50 statute acres, consisting of a great variety of soil — bog, pasture, arable land, and wood — and has a small farm-house upon it.


From hence we rowed to Goat Island, to collect some of the native **Arbutus**, which grows here abundantly, as well as on Bullock Island or Enniskellagan. On this latter island an old man resides. He is a pensioner of Mr. Wynn, who allows him 2s. a week for past services. This island contains the ruin of a church and nunnery.


We next steered towards the west end of the lake,


---

p.336



passing the Doone's rock, and went to see the holy well of Tubernault, about half a mile from the lake. From beneath the hill and the altar flows a very copious spring of the purest water, surrounded by a wall. The principal altar is built against the stem of an ancient ash — against which, too, leans a crucifix, with beads suspended from it. This symbol is not secured, and has remained in its present position for a long time. The second altar is on the opposite side of the well. **Inglis** says that when he visited the well at Tubernault, he saw eleven devotees, four of whom went from station to station on their knees. I was spared this spectacle.


From the well and altars of Tubernault, I ascended to the cairns, from the eastern one of which, the lake and its numerous islands are commanded. The other affords a view of the town and bay. These cairns are composed of rude stones, principally limestone, some of which exhibit fossil vegetable remains. The top of the cairns is thinly covered with soil and grass. At the summit they are 260 feet in circumference, and


---

p.337



nearly 500 at the base; the height being 30 feet above the hills on which they rest.


Instead of returning to Sligo by the boat, I walked for the purpose of inspecting several cabins. Here I found the usual accompaniments, damp and dirt, and on conversing with some of the small farmers, ascertained that they were miserably poor. They pay from fifty to 60s. per Irish acre for rent, and an extravagant grand-jury cess. The tithe, I learnt, had not been demanded for three years. Lime is plentiful in the neighbourhood, but few are able to purchase it. Mr. Wynn has extensive property near Sligo, said to be worth £17,000 per annum. All agree that his land is let the highest of any about. He employs many labourers, and gives them 8d. per day in winter, and 10d. in summer, without diet. They pay £5 per annum for their cabins and two acres of land; the rent is taken weekly from their wages. At Sligo I met with a gentleman, a land agent from near Enniskillen, who informed me that some of the agents were frequently very oppressive towards the poor farmers, whose cattle


---

p.338




were often impounded for rent, even when the balance for labour was in their favour.


When at home and at work, the labourers are generally clothed very insufficiently; and many of those who possess a good suit, do not wear it except on Sundays and on particular occasions. The women and children, especially the latter, are still worse off than the men. The children indeed are constantly in rags.


None of the cabins visited by the Assistant Commissioners had ceilings; and the dirt and cobwebs that were continually falling from the roof was a serious inconvenience in a district devoted to the making of butter for exportation. Most of the miserable huts contained rude bedsteads, but very frequently no other bedding than straw or hay, and a single quilt or sheet, made of coarse sacking, invariably in a condition of great filth. When the family was a large one, the bedsteads were occupied by the parents and the younger children, the others having nothing but a litter of old hay, which, in the day time, was collected in a heap in a corner, and had, in most



---

p.339



cases, been in use many months. Chimneys are not frequent; more cabins are without them than with them. As for windows, a small pane of glass, kept in its place by mortar or mud, was the usual mode of at once admitting the light, and excluding the wind. In several of the cabins visited, the door had no hinges or fastenings, and was only secured at night by having large stones laid against it; in others, the doors were of wickerwork; and in a few, consisted of mere straw mats suspended from pegs driven into the wall. The little snug woodbine-covered cottage, with its neat plot of garden-ground, which almost every peasant in England may possess if he pleases, is here, as I have observed before, totally unknown.


Sligo is situated in the barony of Carberry, which, in one published account, is stated to contain 51,121 acres, and in another 55,436 acres. In 1831, the labouring population was computed to be 6206, nearly one half of whom were occupied solely in the tillage of their own lands; the other half may at one time be denominated occupiers not employing labourers, and at another,


---

p.340



agricultural labourers. From the evidence of several witnesses in different ranks of life in this barony, we learned, among other things, that the principal landed proprietors in the north of the barony have endeavoured to break up the confined heaps of houses, or villages, as they may be called, and have aided the villagers in building on their respective holdings. This attempt has been attended with manifest improvement, and has removed some of the inducements to idleness which necessarily exist in a crowded community not having much to do. Most of the witnesses spoke favourably of the population, in answer to our inquiries respecting their sobriety, and all of them agreed in stating that it was a rare thing to see a woman drunk. The labouring classes, we were told, are often tempted to drink, from the want of clothing, and from the comfortless condition of their homes.


George Waters, a middle aged man with a wife and four children, was said by most of the witnesses to be one who might be considered to have a fair share of employment through the year. All


---

p.341



the particulars of his statement would occupy too much space, but a few may be given without impropriety. His income arose from breaking stones, labour in the fields, profit on pigs, poultry, potatoes, butter, and his wife's spinning, and amounted to £7. 6s. 6d. a year. His expenditure consisted of the rent of a cabin and rood of ground, £1. 15s.; a rood of conacre, £1. 15s., which was manured and ploughed for him by the farmer; rent of bog, grass for a cow, fee to priest of 1s., baptism of child and churching, 2s. 6d.; candles, soap, tobacco, kitchen, &c, amounting altogether to £6. 12s. 6d. The total clear gain of Waters and his family by labour and other modes, consisted, first, of the potatoes raised from his ground (and all, with the exception of two barrels sold, consumed in his own house); 2dly, in articles, such as soap, candles, &c, amounting to 19s.; and 3dly, of the difference between his income and expenditure, applied to the purchase of clothes, and amounting to 14s. Allowing for himself, his wife, and four children, 2 £ stones of potatoes in the day, at 2d. per stone, their year's food would


---

p.342




be £7.12s. 1d. The entire value of the exertion of a labouring man and his wife may be set down at £9. 5s. 1d., or very nearly 6d. per day, being at the rate of 1d. per day for each member of the family. With respect to clothing, Waters stated that he had purchased but one article (a coat) during the preceding two years, and that remained still unpaid for. Messrs. Lumey and Barber, and other farmers, said that the above might be looked upon as a fair specimen of a labourer's accounts, being rather over than under the mark, as there were many of that class who had not a pig, and were not allowed to keep poultry.


Employment has greatly decreased of late years. Fourteen years ago, said one of the witnesses, he could have got as much work in the fields as would have maintained him and his family without land; now, however, the best thing he had to look to was a penny a barrel for breaking stones. This, he added, did not produce more than thirty shillings a year. Another of the witnesses stated that he had at that moment a strong healthy man working for him at *twopence a day and his diet!*




---

p.343


The expenses of marriages are in general defrayed by the bride's father, and are so excessive as to cause much subsequent distress. The meanest labourer considers himself bound, upon such occasions, to give a feast. Mr. Dodwell told us that "at a man's wedding in Ardtrasma last winter, he never saw such fine eating and drinking ! — the sport began on Friday, and was kept up till the following Wednesday. On the three first days the man entertained his neighbours and friends, and on the three latter they treated him."


The land taken as conacre is either in grass, or stubble, with or without manure. Stubble land without manure has of course the lowest rent, yet for this not less than £4 per Irish acre is paid, a price more than double the average rent paid by the farmer, who further receives the land in such condition that it yields a remunerating crop of grain the following year. The Rev. Mr. Yates, one of the witnesses, stated, that a labourer did not take conacre with a view to profit; his object was, first, that he



---

p.344




might spend his labour in raising his own food; secondly, in order that he might not lose his time in fetching from market daily so heavy an article as potatoes. With these views a great many mechanics are in the habit of renting more or less conacre. The system is general in the barony, and is becoming daily more extended, but not at all in proportion to the demand which exists for it. "If it be ley land" (said Mr. Dodwell), "requiring manure, the price to the renter is from six to £8 per Irish acre." In this barony (Carberry) the conacre chiefly consists of stubble land; there is very little grass land applicable to the purpose. The average rent is £4 (which is paid in money) when the taker provides manure, and in all cases the taker has to find seed.


On the estate of Lord Palmerston, the tenants are numerous, and are anxious to obtain employment in the extensive improvements carried on by his lordship. The overseer finds it impossible to employ all the applicants, and each month he puts the names of a considerable number into a



---

p.345




hat, and those who draw out their own names compose the list of persons to be employed for the next month, at the end of which time the lottery is repeated. The competitions for small holdings is so great that the bidder offers a rent which he knows he cannot pay. If there be a man going to emigrate to America, on account of his rent being too high, he can always find a person to give him money for his farm (meaning the tenant-right), and to promise to pay the high rent besides. "If a farm," said Mr. Dodwell, "of five or ten acres, were vacant in this barony, there would be forty or fifty who would make proposals over each other's heads; they would take their chance of paying the rent; all they want is to get possession of the land."


Mr. Patterson stated, that on the estate of Captain Jones (situated along the sea coast) for which he is agent, the greater number of the tenants pay at least one half year's rent by the sale of the sea-weed, which they collect for manure. His bailiff is always at hand when the weed is fit for delivery, and, after



---

p.346




weighing it, he gives the tenant a ticket for its value, which he produces in part payment of his rent; the bailiff has instructions to give the tenant a few shillings for his present wants. When there is not sufficient employment for the population, the labourer is wholly thrown upon the hire of land for a subsistence, and thus, with the alternative of starvation to himself and family, he is compelled to agree to any terms, in order to obtain it. A considerable proportion of the crimes committed in this barony, is connected, directly or indirectly, with the taking of land; every opposition is made to any change in the arrangement of lands.


On Sir R. G. Booth's estates, a stack of wheat had been lately burned, and several ploughs and other implements broken to pieces. One of the witnesses exclaimed "no wonder, when you turned 120 people out of their lands at Balligilligan."


Mr. Lumey thought that the destitution apprehended, or really brought on, is the cause of the crime; and both Mr. Yates and Mr. Dodwell concurred



---

p.347



in this opinion. The dislodgement alluded to as having been made by Sir R. G. Booth, was admitted by his agent to have been the most extensive that had ever occurred in the barony. Upon this occasion the intention was not to make a large farm, but to increase the domain; and to compass this object, no fewer than 120 families were ejected from the town of Balligilligan. Of those who were thus ejected, a great many took refuge in the cabins of their neighbours, and some still live there as lodgers, and endeavour to obtain a livelihood as day labourers; but they have difficulty in paying for the conacre, which is their chief support. Others have been located by Sir R. G. Booth on inferior land, where he has given them assistance to build houses, and has manured a portion of their new holdings with sea-weed; but, according to the statement of Mr. Dodwell, although these people pay no rent for the land they occupy, they are unable to obtain a subsistence from it, and he considers himself bound, on the part of Sir R. G. Booth, to give a large amount of employment to nearly 60 of the number. Previous


---

p.348



to the ejection of his Balligilligan tenants, Sir R. G. Booth offered a bonus of a guinea for every house pulled down before an appointed day, and four guineas an acre for all manured soil. Of the 120 families dislodged, the larger number entitled themselves to these offers, but only twenty applied the money so received to obtaining a passage to America. The tenants, just alluded to, had received four years' notice of the intentions of their landlord; but the 120 families upon whom notice was served, had increased in the interval to 160, and subdivision had been made in proportion to the increase. The labourers present at the examination declared that their objection to being deprived of their lands would in a great measure subside, if there were such permanent employment as would secure them an equal support.


Sir A. Creighton, Bart., stated, that rents have not been in the least affected by intimidation on the part of the peasantry; they have never combined with a view to lower rents. "I could," said Mr. Dodwell, "mention several instances of individuals having been prevented investing capital


---

p.349



in the united farms of several ejected tenants, through fear of outrages. It has been attempted, but in vain, to introduce experienced farmers, men of money and information. Scotchmen have applied to me for large farms, and I have accepted their offers with pleasure; but before taking possession, they have been frightened at the state of things, and have withdrawn. They had reason to think that they should not be safe."


The generality of the labouring men get married before they are twenty. Mr. Yates, indeed, observed, that he often thought the more destitute a man was, the more likely was he to get married; sometimes it seemed as if he took a wife in desperation, feeling that he couldn't possibly be worse off. We had an opportunity of confirming this suggestion. Seeing a young man, Pat Linahan, with a child in his arms, on the lands of Ballintemple, we asked him how long he had been married: he replied, "about a year and a half," and informed us that when he was married, his portion of land had been completely buried under the sand. For nearly two years he had no means


---

p.350




of supporting a wife, but by picking sea-weed, or gathering shell-fish. He thought that if he had a wife, they would strive to support each other; at any rate, they could not be worse. The day he was married, the sand was six inches deep on the top of his cabin!


There is much moor and waste land in the northern part of the barony of Carberry, but it requires the application of capital, under skilful directions, to make it fit for tillage.


About one-half of the land in this barony is held under middlemen, but the landlords have determined, on the expiration of the leases, not to renew them. "There is no conceivable case," said Mr. Yates, "in which the middlemen can be of advantage to either landlord or tenant, for either *he* must get more than the real value of the land, or the landlord must get less."


No adequate reason was assigned by any of the witnesses for the absenteeism of landlords. "There is a great difference," said Mr. Lumey, "in favour of the tenantry of a resident proprietor, but it is not to be attributed to the money he spends among



---

p.351




them. Lord Palmerston, for instance, who is a non-resident (his official duties compel him to be so), does not draw anything from his estates about Moghalimore, but expends all his rents in making improvements. Yet the tenantry on his lordship's property are extremely wretched."


The average size of tillage farms was stated to be three acres — perhaps rather more. Eighty acres may be taken as the average of the grazing farms — that is, grass land on the sides of the mountains.


Scotch Agriculturists (bailiffs) have been introduced into the neighbourhood by Sir A. Creighton, Mr. Wynne, Major O'Hara, Mr. Cooper, and Mr. Phibbs, and from their instructions benefit will doubtless arise. During the last three years, deficiencies in the potato crops have been frequent, and in some cases the farmer has been obliged to seed his ground three times. If a part of a lot of potatoes fails in the field, the remainder of the lot in the house is at the same time affected with the dry-rot. Those kept through the winter in pits are more likely to succeed than those kept



---

p.352




in the house. Where cuts are planted, the crop is more liable to failure than where the whole potato is used for that purpose, especially if cut some days previously. Some think the old plants are wearing out and want renewing.


The breed of cattle has undergone but little improvement. Those in the hands of the farmers are for the most part Irish; those belonging to the proprietors, and in the immediate neighbourhood of the town of Sligo, are of the Ayrshire breed, or a cross between the Ayrshire and Irish. The Durham breed, or rather what was termed the Durham breed, has been tried, but the preference appears to be given, especially for dairy purposes, to the Ayrshire. The number of cattle fattened is inconsiderable. The supply of hay is very meagre; it is regarded as a valuable privilege to be allowed to cut the coarse grass out of the bottoms of the landlords' plantations, and make it into hay. The best Irish cows give sixteen quarts of milk per day after calving, or ten or twelve quarts per day for two months. From eighty to ninety pounds of butter is the usual



---

p.353



quantity in the year. The making of cheese never enters into the farmer's contemplation.


The butter of the barony belongs to the second and third-rate quality. A butter market is held at Sligo four days in the week; and previously to the purchase of the butter by the merchants, it is tasted by a person appointed by Mr. Wynne, the patentee of the market, and divided by him into six different qualities, the firkins in which it is placed being branded with the respective numbers. The merchants in Sligo, as well as those in London, in purchasing it are guided by the judgment of the taster.


Sea-weed is the manure most in request. Lime is but little used in the greater part of the barony; near Sligo it is burned with Scotch coal, but in the country it is burned with turf. Shell-sand is used for reclaiming coarse land. Mr. Patterson, agent to Col. Jones, stated, that the tenants on the Colonel's estate were permitted to sell the sea-weed, but not to receive the money for it; a driver invariably attended for that purpose, and usually paid the tenant about one-fifth of the 


---

p.354



value, and gave him a ticket for the remainder, to be received in cash by the agent for the payment of rent. Half the rents of these tenants were paid by the sale of sea-weed. The driver claims 6d. from the tenant for every load of weed sold, as a remuneration for his trouble, and also expects a present of potatoes in the course of the year. The sea-weed is generally applied to potatoes, and its influence extends to the next crop. It consists mostly of **fucus vesiculosus** and **fucus serratus**, growing between high and low water, and **familiaria digitata** and **laminaria saccharina** in deeper water. **Tortora marina** is also found amongst the drift. The weed obtained in the summer season is carefully dried, and in that state is kept over till the season of tillage arrives. In the winter it is generally put on the land wet, and is left exposed till the ground is ploughed in the spring, when it has in a great measure melted away. The **fucus nodosus**, before it is applied, is put into heaps to rot. The thick stems of the **laminaria digitata**, which are as large as a man's wrist, and from a foot to a yard long,


---

p.355




are not used as manure, but are cut into pieces, and dried and burned into kelp. Lawrence Egan stated the weight of a load of weed, which he purchased for £1. 3s. 6d., to be 24 cwt. This load was put on a rood and a half of ground; the land ought to have four such loads to the acre. Mr. Dodwell disapproved of the frequent use of the sea-weed, on account of its being a forcer and exhauster.


The fences chiefly consist of dry stone walls, or banks of earth. They are made by the tenants at their own expense; generally speaking, they are thrown down in the winter, and have to be rebuilt in spring: they frequently lead to much litigation. The losses from trespass are considerable: but the witnesses did not appear to think that the amount expended in litigation, added to that arising from the loss of property, would be sufficient to defray the cost of permanent fences. Some idea may be formed of the state of the fences, when it is stated, that hardly a horse, sheep, or pig, can be seen, which has not its legs tied with what is called



---

p.356




a **soogan**, to prevent it from trespassing. The damage is valued by sworn appraisers, appointed by the parish. The very gardens are subject to trespass, but in winter, when trespasses are most common, they have little in them.


Taxation may be estimated at one fifth or one sixth of the rent. The grand-jury cess is not laid according to the value or the rent, but is an acrerate without respect to the value, and is accordingly a very unequal and unfair impost. The amount varies considerably; for the last three years it has averaged more than 4s. an acre Irish. The periods at which it is collected, as well as the manner of collecting it, are causes of great annoyance and distress to the small farmer; it sometimes happens that when the deputy-collector calls for the payment, he takes one of the farmer's beasts, and keeps it till the cess of a whole townland is collected: the owner of the beast is therefore obliged to collect the cess of the townland. Some witnesses stated that they knew townlands which have paid for ten acres more than they are assessed to in the county applotments. The applotters in



---

p.357



the upper part of the barony collected for three or four hundred acres more than that portion of the barony was assessed at, and pocketed the money. If mountain farms are assessed for the county cess, they pay, according to the amount of acres assessed, in the same proportion as arable land does, but they are not assessed in so great a number of acres. In Barnaribbon, for instance, on the east side of Benbulben, a mountain farm of 132 acres is only assessed as 6 acres. The mode of applotting the tithe is by a valuation of the lands, and assessing the sum to be raised according to the valuation. In Drumcliffe there are 10,518 Irish acres valued at £15,559, on which the sum of £780 is raised, being 1s.in the pound: the average price of oats being taken for the year ending November 1821 at 15s. 2 1/2 d. per barrel of 14 stones; the land is valued at £2. 5s. 6d. per acre for the best, and 10s. for moor and mountain.


Contributions for the building of a chapel are obtained in the following manner. A committee is elected, and the members assess each other and the rest of the parishioners according to their


---

p.358




ability — the contributions being adjusted agreeably to this assessment. The Protestants have given some assistance to the building of a new Catholic chapel at Drumcliffe; some contributed £1, others 5s. The entire cost will probably be £500. One hundred pounds were left by a priest, lately deceased, to be applied to that purpose; and it is a diocesan order that a bishop should give £5; every rector, £1; and every curate 10s. for every new chapel built in the diocese. From these two sources £170 had been raised, and £150 in addition in the parish. If a small amount be wanted for the repair of a chapel, it is collected at the door. There are two payments to the priest, 1s. at Easter, and another at Christmas, and at the same time there is also a contribution of 1s.: both of them being voluntary.


The roads to the market-towns are for the most part in good repair, and many cross-roads have been made at the expense of the landlords; the road to Mullaghmore, for instance, cost Lord Palmerston £1,900. Much, however, remains to be done. Some of the farmers in Drumcliffe



---

p.359



have 150 ditches to cross before they can reach the market; the Rosses they cannot traverse for want of roads; and when the tide does not serve, they are unable to convey their produce to market at all. Draining is very little resorted to, except at the expense of some of the proprietors, such as Lord Palmerston, Mr. Wynn, and Sir R. G. Booth. The soil is chiefly of a friable nature, and subject to the bursting out of springs. Part of the ground in the barony is covered with mould, to the depth of four or five inches, upon a retentive and adhesive subsoil; some have worked up and incorporated this with the surface mould, and by these means have increased the soil, and rendered the land quite dry, by allowing the water to drain off at a lower level.


Lord Palmerston possesses a large tract of bog on his estate, which he is extensively engaged in reclaiming. On some portions of it, where it is 30 feet deep, and composed of what is called white bog, the cost has far exceeded the value of the land in its improved condition; and according to Mr. Lynch, his lordship's agent, has in some


---

p.360



cases amounted to £16 and £25 per Irish acre. The work, however, is performed in a very efficient manner. It is first drained, at an expense of from three to £4 per acre; then turned over with the spade, and gravelled to the depth of four inches (within the last 18 months the cost of gravelling has been reduced by means of a railroad); after remaining to settle, 130 barrels of roch lime are applied per acre, at the expense of 10d. per barrel, without the carriage; then the lime, gravel, and four inches of the surface bog, are well mixed together with the spade. If it is not sown with rape, to be fed off with sheep in the spring, it is manured with sea-weed, 40 loads being applied to the acre, each load costing 1s., and the carting of the whole amounting to £1. 4s. per acre; it is then sown with wheat or oats. After one crop has been taken off, it is let to a tenant at a rent of only 12s. 6d. per acre. Lord Palmerston has turned his attention to reclaiming the deep bogs solely; those in which the turf is shallow, are left to be reclaimed by the tenants. To the north of Lissadell, the townlands of 


---

p.361



Ballinadan and Ballintemple, belonging to the bishoprick of Elphin, and those of Ballymalurry and part of Ardtarmon, the property of Sir R. G. Booth, Bart., within the last few years have been entirely covered with drifting sands, to the depth of from one to ten feet. The Assistant Commissioners visited the place, and a more desolate scene cannot well be imagined. All the houses were imbedded as high as the eaves — many of them entirely covered; the roofs being broken in by the superincumbent weight, and the only place of ingress and egress being an aperture at the top. An extent exceeding 500 acres, the greater part of which was fine and cultivated land, had been thus covered. It presented an unvaried surface of white, dry, barren sand. Sixty-four families still continued at Ballintemple; the men mostly earning a livelihood by the sea-side. Five acres capable of tillage still remained to them, although they formerly paid cess for 105, and at the last levy were charged for fifteen to that tax. A few days previous to the visit, an ass and a cow belonging to three persons had been "driven" for 


---

p.362



rent, which is still expected from them. If an attempt be not speedily made to arrest the progress of the sand, it will extend with great rapidity. The Bishop's land being under lease, no exertions of this sort are to be expected on them. On the estate of Lord Palmerston, however, the further progress of the sand has been successfully impeded. Upwards of 200 acres in the townland of Mullaghmore, which had been covered, were planted with bent **arunda arenarea**, at an expense of more than £5 per acre, which may now be done at a little more than £1 per acre. This has effectually stopped the increase of the evil. The sand is now becoming solid, and small spots of white clover are appearing upon it. The bent was at first planted in rows, but was found quite ineffectual, as the wind, when blowing in one direction, swept the sand from the intervals, and the next cross wind broke the bent down. The planting of these tracts with bent would prove a very profitable expenditure of labour and capital. To the poor it would be a great relief, as employment would


---

p.363




be afforded in winter, when they have little occupation on their own account.


Employment has greatly decreased of late years. "Fourteen years ago," said Owen Casey, a labourer, "I could get as much work in the fields as would maintain me and my family without land; but the best thing I have now to look to is a penny a barrel for breaking stones, and that will not bring me in more than 30s. a year." "The fact is," said the Rev. Mr. Yates, "there is not half the employment there used to be; it can't be otherwise, when the population has increased to one and a half souls per acre. In this parish, the number of Irish acres is 10,515, and the population 14,000." Everything, in the opinion of several intelligent witnesses, might be expected from constant employment. It would be of all things most likely to make the people more peaceable, and to render practicable an extensive reduction in the police establishment and other profuse sources of public expenditure, whose burden now weighs heavily upon the farmer, and necessarily disables him



---

p.364



from applying to agricultural purposes as much capital as he would, under less unfavourable circumstances, devote to it. "Not one woman in a hundred," said Mr. Yates, "earns anything by labour in the fields, or in any way, except by spinning on her own account, and this is but trifling. Even when the linen trade was in a flourishing condition, a woman could not earn more than 2 1/2d. a day; and since it has begun to decline she can barely earn one halfpenny."




---

p.365


Journey from Sligo to Ballina — Ballisodare — Public buildings at Ballina — Salmon leap — Rents, and prices of provisions — Lough Conn and Lough Cullen — Lord Lucan's bog — Castlebar — Market-women — Sheep on small farms — Castlebar Lake — Croagh Patrick — Marquis of Sligo — Robinson's Hotel, Westport — Introduction of the linen manufacture by Lord Altamont — Population of Westport — Desire for large farms — Emigration — Leases — Letting in common — Cabins — Size of farms — Agriculture of the district — Sheep shearing — The roads — "Driving" — Potatoes.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


From Sligo to Ballina I travelled by the mail, a conveyance dragged by four miserably poor and incompetent horses, to which the driver, after the most approved fashion of his country, applied the incessant but unavailing stimulus of the whip. Such was the respect evinced by the people whom we met or overtook, for the vehicle by which we travelled, that they manifested the greatest anxiety



---

p.366



to clear the road as we approached, hauling their horses violently out of the way, and running their carts into the ditches on either side of the road, as chance might direct, to give us room. Notwithstanding these laudable attempts, the driver was often at a loss to know on which side he could pass, although ultimately the whole road was left open to him. Even foot passengers often run into the ditches when they see the mail approaching.


Ballisodare, through which we passed, is celebrated for its extensive water corn-mills; here, too, are several fine falls of the river Arrow, or Colloney-water, over a very rocky bed. Marble quarries and lead mines are in the vicinity. The farmers for twenty miles round, bring their corn to the mills at Ballisodare, from whence the meal is exported. Several carts of oats arrived whilst the mail was detained. The factor, without ceremony, ripped open the seams of the poor farmers' sacks in different places, and poked into the oats. The tricks occasionally practised by some of the farmers, render this, I was informed, a necessary precaution.




---

p.367


On arriving at Ballina, on the border of the county of Mayo, the mail was instantly surrounded by thirteen beggars, all of whom supplicated us, in the most pitiful terms, and, as a matter of course, in God's name, for a trifle — and several of them followed us to the inn, and crowded about the windows.


Ballina is an improving town, and contains about 6000 inhabitants. A fine old bridge formerly crossed the river Moy, and has been much noticed by travellers, but it was taken down two or three years ago, and its place supplied by another, which, though less interesting, is more convenient. A spacious quay and another bridge are also in progress. At Ballina a large Roman Catholic chapel has recently been built, but the funds being insufficient to complete the tower, that part of the edifice remains unfinished. Of this structure (so highly praised by **Inglis**) I cannot speak in terms of approval. The architect, I think, might have profited by taking a hint or two from the remains of an old abbey near at hand.


At a short distance from the town, Colonel



---

p.368




Gore is building a splendid mansion in the Elizabethan style. The grounds were not yet laid out, but, under judicious management, they are susceptible of great beauty. Colonel Gore is said to be a good landlord.


The Salmon Leap on the river is a very attractive object. The river is of great breadth, and many deep ledges of limestone rocks, over which the water falls tumultuously, with deafening roar, extend from side to side. The fishery is very productive, and the rent is from £1200 to £1400 per annum. In 1779 it let, according to **Young**, for £250. I was informed that as many as 1030 salmon had been taken at one time. The season for fishing on this river closes on the 12th of August. The Ballina fish are sent to Liverpool and Glasgow.


At Ballina I saw droves of large mules, each mule carrying a woman, seated behind her panniers of turf, waiting for purchasers.


From several intelligent persons whom I met in the evening at the house of a gentleman to whom I had been provided with a letter of introduction,



---

p.369



I learnt that high rents and want of employment are general in that part of the country, that agriculture does not receive the attention which it deserves, and that the condition of the farmers is considerably worse than it was formerly. The labourers suffer for want of food and clothing, many of them having nothing but dry potatoes, and cannot get regular employment. The price of oats was from 6d. to 6 1/2d. per stone; beef and mutton, from 3 1/2 to 4d. per lb.; trout 2 1/2 to 3d.; eels 2d., or if very fine, 2 1/2; potatoes, 2d. per stone. Rent in general is about 20s. per acre, but the quality of land is extremely various. Wages, from 8d. to 10d., without diet. The following is **Arthur Young**'s account of the diet of the poor in this part, from which it will appear that their situation is considerably deteriorated. "The poor," says he, "in general live on potatoes and milk, nine months out of the twelve; the other three, on bread and milk. All of them have one or two cows. Fish is exceedingly plentiful, particularly oysters, which may be had for 1s.a cart load; herrings are a considerable article of


---

p.370




food. In domestic economy, they reckon that the men feed their family by their labour in the fields, and that the women pay the rent by spinning."


In our way to Westport we passed along the side of Lough Conn. This lake is nine miles long, and is connected with Lough Cullen by a narrow strait, crossed by a bridge, over which we passed. These lakes vary in breadth from one to three miles. The shores are rocky, barren, and lonely; here and there, little plots of cultivated ground appear; and in other places the active mountain sheep may be seen threading their way among the bold masses of granite, or leaping securely from peak to peak. Lough Conn can scarcely boast of a tree or a bush. Very different indeed is it from the rich verdant slopes, and the glowing arbutus-islands of Lough Gilly; yet I felt that I could have spent many days with great pleasure in the wild and rocky neighbourhood of this usually disparaged lake. Its shores are much indented, forming themselves into innumerable little bays and creeks, and at no great distance rises the conical Nephin mountain, whose height



---

p.371




is stated in old maps to be 2840 feet. Lough Conn is spangled with several small islands, all of them consisting of granite, combined in masses of curious and picturesque effect — some shooting boldly and perpendicularly from the edge of the water, or darkly overhanging it, and others sloping away gently and sweetly into it. It is generally believed that this lake ebbs and flows. The day before I passed, it had been flowing (the driver told me) from the direction of Lough Cullen, and he suggested the probability of our seeing it return. In this, however, we were disappointed. This belief, I doubt not, arises from the effect of the wind, and at other times the re-action of the current from Lough Cullen, which cannot find sufficient vent. These lakes possess many charms for fishermen, and are celebrated for the Gillaroo trout.


After leaving the lake, the road to Westport passes over a tract of bog land — to travellers in general uninteresting, but to me full of peculiar interest. It belongs to Lord Lucan, who has shewn a most laudable desire to promote the comfort and the happiness of the poor about him.



---

p.372



Upon this bog his lordship has built several neat and convenient cottages of the stone of the neighbourhood, which is granite; and the tenants, who have a lease for seven years of their respective properties, are not only not charged any rent at all during that period, but are actually paid, for the first three years, for the labour they devote to their allotments. The bog is exhibited in a variety of conditions — from being just meered out, to a high state of cultivation, growing potatoes, rape, turnips, and cabbages. Lord Lucan's benevolent plan has been objected to, on the ground of the tenant not having a sufficient interest in the land he cultivates. This may or may not be a valid objection; I shall leave it to be settled by such as can find in their hearts to cavil at an act of noble generosity. To me it appears that Lord Lucan's chief praise is due to his having devised a method of teaching a habit of industry and peace; and great will be his reward, independently of any remote benefits, when he sees those, who (but for his exertions) would have been living a life of idleness, penury, and probably vice, actively employed


---

p.373



in providing the means of a comparatively comfortable subsistence for themselves and their families. Such acts as this of Lord Lucan's are not so much to be estimated in respect of the immediate good they produce, as of the excellent principles they establish as the foundation of permanent advantages.


Castlebar, about nine miles from Lough Conn, consists of one street of nearly a mile in length. A Jail and Jailor's house, which cost £20,000, and extensive Barracks, at a similar cost, have been recently built there. These structures, notwithstanding their claims to admiration, as public buildings, are calculated to excite very different feelings, when contrasted with the wretched cabins amid which they rise, and when it is considered that the funds for their erection were wrung from a poverty-stricken and miserable population. The barracks were raised upon the site of the old castle, whose venerable remains were rudely sacrificed, I suspect, to make way for the modern buildings. In 1798, the French force, under Humbert, possessed themselves of the town, in


---

p.374




which they remained from the 26th of August to the 26th of September. The Earl of Lucan, the owner of the town, has a residence in the suburbs, but it does not possess any particular attractions.


It was market day at Castlebar when I arrived there, and I strolled for a couple of hours among the market people. Great numbers of women, holding a hank or two of yarn of their own spinning, stood in the streets and offered their trifling commodities for sale. Very few of those whom I addressed could speak English; but some of the men about, seeing the disadvantages under which I laboured, very obligingly stepped forward, and offered assistance as interpreters. This sort of politeness is common to the Irish. I ascertained that the women could not earn by spinning more than a penny or twopence a day, and hundreds of them attended the market whose earnings for the whole week did not exceed sixpence or ninepence; yet notwithstanding this inadequate reward of long and hard labour, their honest countenances wore the habitual



---

p.375



impress of cheerfulness and perfect good humour. Scarcely any of the women had shoes, and I felt considerable alarm while threading my way through a dense crowd, lest I should step upon their feet.


The corn and meal were brought into the town by horses, mules, and asses, many of which remained in the market with their loads upon their backs. Oats were selling at 5d. and 6d. per stone. But little wheat is produced in the neighbourhood, nor is barley much grown, except to supply the potheen manufactories in the mountains. Rents are about 20s. an acre; and wages from 6d. to 8d. a day; but if regular work is afforded, 6d., without diet, is the usual amount. Although their agriculture and customs seem better adapted to the last century, yet if we may draw a comparison between their present practises, and the account given by **Arthur Young** in 1779, some improvement has actually taken place. "To Castlebar," says he, "over an indifferent country and a vile stony road; about that town the husbandry is admirable. They have three customs,


---

p.376





which I must begin with; first they harrow by the tail; item the fellow who leads the horses of the plough, walks backward before them the whole day long, and in order to make them advance, strikes them in the face. Item, they burn the corn in the straw, instead of thrashing it."[15](javascript:footNote('E830001-002/note015.html'))


I attached myself for a short time to a man walking to market with a bale of woollen cloth, or flannel, manufactured by himself and his family. His farm consisted of 9 acres, and he kept 10 sheep; one pound of his wool, he stated, was worth from 14d. to 16d. and would make two bandles of flannel — a bandle being four inches short of a yard. The cloth was worth 1s.per



---

p.377



bandle; he therefore got 4 1/2 d. per bandle for the making, or 9d. per lb. profit on the wool. He also spun and wove the wool into frieze for his own coats. The information received from this man confirms the opinion I have previously expressed, that the small farmers would find it profitable to keep a few sheep, which they might tie upon the clover or rape, or secure by nets, as they do in the sheep districts in England. These nets might be made from coarse wool, or inferior flax, or hemp of their own growth; and thus an employment, both interesting and advantageous, would be provided for the winter season. If it be objected that I have previously condemned the practice of confining animals on the land, my reply is this — that the advantage of confining sheep in yards is doubtful, not having been sufficiently tested by experiment. We know it is successful as regards cattle; at the same time, I am not sure that a small farmer or cottier might not keep two or three Leicester sheep to advantage in a small yard, netted or paled off, to be supplied with rape and other food by the wife or children.




---

p.378


On the road to Westport, Castlebar Lake, a fine sheet of water, was on our right for some miles — our way lying through scenery of much variety and beauty. As we descend the hill into the town, the magnificent Bay, including Achill, and Clare, and numerous other islands, opens out grandly before us. Croagh Patrick,[16](javascript:footNote('E830001-002/note016.html')) too, or the Reek (as some call this mountain), is seen from hence in perfection. Croagh Patrick is of conical form, and is abundantly frequented for the purposes of penance: it is still more useful as a landmark at sea. Upon this hill St. Patrick is said to have collected all the venomous reptiles in Ireland, and cast them into the bay: it is accordingly regarded with an astonishing degree of veneration. I frequently heard the driver of the mail, in allusion to the penitential associations of the mountain, say, "If you don't behave, I'll send you round the Reek."


At the harbour and quay I saw only a boat or two, yet the warehouses are extensive, and there



---

p.379



is a considerable export of grain and butter. The imports are timber, salt, iron, and coals. Westport belongs to the Marquis of Sligo, whose annual income is said to be about £25,000. Being Governor of Jamaica when I visited the town, he was necessarily an absentee. The people of Westport have abundant cause to regret his absence; for when resident among them, he contributed, in many respects, and in a very important degree, to the happiness and prosperity of the community which surrounded him. I was told of an incredible number of hired servants who were constantly employed about the house, and was informed that to each of his tradesmen he gave a guinea a week, with permission to follow their trades as usual when he did not require their services. At one of the elections, however, a party was raised against him — his carriage and horses were injured — and he shortly afterwards left the country in disgust. Sincerely is it to be hoped that this electioneering hostility may subside, and its unhappy consequences be suspended; for the presence of a man like the Marquis of Sligo, whose personal example


---

p.380




no less tended to elevate the moral character, than his munificent generosity contributed to promote the physical welfare of the population among which he lived, is a blessing that may safely be pronounced to be of incalculable worth.


The noble Marquis very handsomely presented Mr. Robinson not only with the commodious hotel which bears his name, but with six acres of excellent ground, all rent free. He also furnished the house, and was preparing to fit it up still more extensively and sumptuously, when he left the country. This hotel has been praised, and deservedly praised too, by all travellers. I had not anticipated any thing so comfortable and elegant. The furniture is of the best quality, the plate and glass remarkably beautiful, and the rooms are hung with paintings like a gentleman's house. In front of the hotel is a long flagged walk, and a clean street or mall, planted with trees on both sides, and refreshed by a transparent stream which flows between them. Opposite the house stands a large Catholic chapel, the congregation of which is immense. Mr. Robinson is a highly respectable



---

p.381



and gentlemanly man, and his wife possesses the attractive qualities of attention, kindness, and something more than professional hospitality. Here, as elsewhere, I was sorry to find that the servants bear an indifferent character. Without wishing to impute any impropriety to Mr. or Mrs. Robinson, I must again remark that I believe this to arise from the suspicious manner in which domestics are generally treated. A good master makes a good servant.


Westport House, the seat of the Marquis of Sligo, is a substantial building of Roman architecture, with walled terraces and flighted steps; it is situated in a beautiful and secluded valley, richly adorned with wood and water. In the park stands a rural-looking church, embosomed in trees. When **Arthur Young** visited Westport, Lord Altamont, who then owned this mansion, had made valuable experiments on bog land with great success. He states that Lord Altamont's great-grandfather "found the estate, in 1650, a continued forest. These woods were much more than a century's growth. There is a tradition in the country that


---

p.382




it was depopulated by the plague, and upon that the wood sprung up which formed those forests." Lord Altamont in 1772 brought a superior breed of cattle into the country; he also introduced the linen manufacture; built good houses for this purpose, and let them on reasonable terms. He also gave the people looms; lent them money to buy yarn with; and bought all the goods they could not sell, to the extent of £400 a year. **Arthur Young** further informs us that "the progress of this manufacture has been prodigious, for at first Lord Altamont was the only buyer, whereas for two years past there has not been less than £10,000 a year laid out at this market in linen. Yet with all this increase they do not yet weave a tenth part of the yarn that is spun in the neighbourhood." These were Ireland's golden days; yet we should do a manifest injustice to the present if we neglected to state, that in the contemplated improvement of her rivers, harbours, roads, and agriculture, advantages of a much more extensive and abiding importance are proposed.


The town of Westport contains about 4500 inhabitants,



---

p.383




400 houses, and 53 licensed public-houses or spirit-shops — so that there is rather more than one spirit-shop to every eight houses; In the rest of the barony, with a rural population of nearly 30,000, there are but six licensed houses; a less number than formerly. The increase of the licensed spirit-shops has been considerably checked of late by the refusal of the magistrates to grant licenses; but over the unlicensed houses, which vary in number as the seasons are good or bad, they cannot of course exercise any control. When the oat crop has been plentiful, and the price of grain is proportionately low, a large portion of it is secretly malted and distilled. In this way it yields more than if sold in the market in its raw state; and under these circumstances, the unlicensed houses frequently exceed in number those that are licensed. Notwithstanding these facts, the people are a sober people. It was remarked in evidence, that in most places "they were more hungry than drunk."


Some men who were digging potatoes near the town, informed me that they paid from £2. 10s.



---

p.384




to £3. 10s. per acre for the potato land, and found the manure, seed, and labour: on this plan the potatoes cost them 2d. per stone. The year after, the farmer ploughs the land, and gets a crop of oats from it: the labourers occupy it the ensuing year, and so on alternately; an advantageous system for the farmer, at the expense of the labourer. At the same time, the labourer is glad to make sure of his crop of potatoes at 2d. per stone.


None of the tenants in the barony of Murrisk (in which Westport is situated) hold as many as ten acres of arable land, and the majority do not hold more than four. The desire of the landlords, as appeared from some evidence given before the Assistant Commissioners, was to increase the size of the holdings on their estates; but in consequence of the additional pressure of population, they had but few opportunities of carrying their wishes into effect. Sir S. O'Mally stated, that for his own part, the certainty of causing distress was the only reason that prevented him from promoting a more rapid junction of farms. Up to the period of the disfranchisement of the 40s. freeholders,



---

p.385



the landlords were universally desirous of multiplying the number of their tenants — the fathers being frequently solicited by the agents to divide their land among their children; but since that important measure in 1829, large holdings only were desired. The landlords are accordingly anxious to get rid of the old 40s. freeholders, and to establish £10 franchises in their stead. Most of those who were thus ejected, being possessed of no property of their own, were consequently cast upon the world destitute; the generality of them became beggars, but some were engaged as cottiers and small holders. None of them emigrated, not having the necessary means, and the landlords did not assist them. Several of the witnesses stated, that a very general disposition to emigrate exists among the small tenantry, but that without assistance it cannot of course be gratified; and many of the labourers present declared "that half the country would go if they could: those who stay envy those who have left them behind in misery and want."


No English or Scotch farmers have settled in


---

p.386



this barony; but according to the opinion of all the witnesses, without an exception, there is no reason for supposing that they have been deterred by the apprehension of danger either to their lives or properties. "If there were a fund provided for the support of the ejected tenantry" (I quote the words of Sir S. O'Malley), "their animosity would be altogether removed — the sole ground of their hostility to those who supplant them, being, that they have deprived them of the only means within their power of obtaining a livelihood; if they could get permanent employment they would be satisfied." At least one quarter of the barony consists of unreclaimed but improvable bog land; and the small spots which are every year cultivated by the unassisted and unencouraged efforts of the petty tenants, abundantly shew what could be done if capital were judiciously applied. The insertion, in recent leases, against subletting, and specific penalties, such as forfeiture of the lease and the payment of a double rent, has been tried without effect; indeed, it has been found quite


---

p.387





impossible, on the death of a parent, to prevent the subdivision of his lands among his children.


Strictly speaking, there is only one resident landlord in the barony (Mr. Garvey), and he does not own more than 500 acres. No reason could be assigned by any of the witnesses for the absenteeism of the proprietors in the neighbourhood. Lord Sligo is the only one who has a house in the barony. His lordship occupies about 700 acres, which constitute his domain; he has also a deerpark of great extent, consisting of unreclaimed mountain land, and a large stock farm of the same description. Lord Sligo's leases are for twenty-one years, or one life; Sir S. O'Malley's for two lives. Tenancy at will, or from year to year, is much more common than it was, and is rapidly spreading. The frequent practice of the landlords in the barony is to let in common, and the custom will in some measure explain the absence of any attempt at improvement under this system. The cattle in winter roam over the land where they like; which discourages the sowing of wheat, and the raising of winter food



---

p.388



for the cattle. Any one partner is answerable for the rent of all, and it often happens that the most industrious has to pay for the others, and to depend upon their honesty for reimbursements. The partners have no fixed interest in the common land; they cannot even tell what portion of it they may have next year. The whole farm, including even the cabins, is frequently divided into lots; and it accordingly often happens, that a man changes his habitation and his corn field, his potato patch and his pasture ground, for situations inconveniently remote from each other. This system naturally engenders considerable discord. In respect of the nature of the leasing system, Mr. M'Donnell remarked "that he never knew an instance of a landlord, on the expiration of a lease of land improved by the tenant, taking one farthing less than the tenant had made it worth; accordingly, when the lease is nearly expired, the occupier invariably exhausts the soil, and sometimes even runs the risk of burning it, because he has no chance of a renewal at a fair rent." "There is but one landlord


---

p.389




in all Connaught," said one of the witnesses, "who encourages improvements, by allowing for them according to valuation; the consequence is that his estate is in a superior condition, though he gives no leases."


There does not appear to have been much improvement in the cabins of late years. They have no outhouses except pig-sties, and the pig frequently sleeps in the house. During the cholera season they were whitewashed, but this has since been neglected. The pig sleeps in the cabin as frequently as before, and the floor and roof are in as bad a state as they used to be. The cabin, when repaired at all, is always repaired by the tenant. Many persons are unable to leave their cabins in winter, from want of ordinary clothing; but the very general absence of bedding is more particularly felt than any other want; because the floor being of damp clay, the straw laid upon it becomes rapidly bad and unwholesome.


There is no public common in the barony, and very little woodland, with the exception of what



---

p.390



belongs to the Marquis of Sligo. From half to three-fourths of the barony is mountain and bog, and from two-thirds to three-fourths of the remainder is under tillage. The largest quantity of land held under tillage by one farmer is 10 acres Irish. Five acres are considered a large tillage farm, the average not exceeding three; and part of this, (one-fourth or more), is uncultivated and waste. Besides, the grass for a cow is usually hired on the "mountains" (hilly ground). The general class of farmers hold very small portions of land, not sufficiently large to employ their over-time; and are far from being in as good a condition as constantly employed labourers would be. Yet there is certainly more produce raised now than formerly; if this were not so, the increased population could not exist. Mr. McDonnell stated "that the labouring class — those who actually till the soil — are densely settled together along the coast line of the barony. Here they occupy small portions of land, averaging about three acres a piece. To each holding is attached a piece of contiguous mountain — as much, for a



---

p.391



holding of three acres, as would support a cow scantily during a few months of the year, and two or three sheep; but as many of them have no money to purchase either a cow or sheep with, the land remains unproductive. A three-acre tenant will have something less than an acre of potatoes, which affords no surplus, and about the same quantity of oats. From the latter alone does he expect any profit, which is almost universally applied to the payment of rent. Indeed, if sufficient for that purpose, he deems himself fortunate. The very low price of the worsted yarn which they make, discourages them from attempting to sell it."


From the humidity of the climate, and exposure to the sea blast, the wheat of the district is of bad quality. It is never tried on a naked fallow, but is frequently sown in February. The weeding of corn crops is much neglected, and is done so late as July and August. It did not appear that there were more than six ploughs in the barony; and with the exception of those belonging to Lord Sligo, not a roller is to be



---

p.392



found. The grain is brought to Westport market in sacks, and never sold by sample. None is reserved for the use of the peasantry. Few keep seed till the following spring; but when sowing time comes, they take it on credit, and pass a note for its payment. Clover is usually sown on portions of land containing not more than half a rood; the quantity of turnips and mangel wurzel is not worth mentioning. Within the last three or four years the deficiencies in the potato crop have been frequent; recently the farmers have planted them whole, but this does not always succeed; and it often happens that the produce of the same seed, in the same field, sown on the same day, is very different; that sown in the afternoon fails, while that sown in the morning, with similar attention, succeeds. This tends to confirm an opinion I have formed in regard to these facts, which are by many considered so extraordinary; viz., that seed planted in the morning is deposited and covered before the sun and wind dry the furrows and the manure in which it is placed. Flax is grown



---

p.393



in such small quantities (one or two roods) that it can hardly be said to form a part of the rotation. The best land of the farm is usually selected, to which, being in prime condition, no manure is applied; but after twice digging, a quart of seed to the perch is sown in April. American seed, which this year was preferred, sold at 3 1/2d. per quart. A stone of hackled flax worth 7s. 7d., is stated as the average produce of a gallon of seed sown on 4 perches. There are very few sheep kept in the district of Murrisk. The Marquis of Sligo has a flock of Cheviots on mountain land, and they succeed very well. The mountain farmers keep a small number each, but owing to the extensive robberies which have been committed on this description of stock, they are reducing their flocks: large numbers are stolen, and secretly driven out of the district at night. Great losses are experienced also from foxes and eagles. Plucking wool off the backs of the sheep, too, is another species of robbery far from uncommon; and an exceedingly injurious practice obtains among the farmers, of taking



---

p.394




the lambs from their mothers at night, to enable them to milk the ewes in the morning. The process of shearing the sheep is very irregularly conducted. In October or November they begin shearing half a sheep this month, and the other half the next, in order to raise a small sum of money to meet some pressing exigency. The most usual breed of cattle is the Irish, and that of the worst description. The Marquis of Sligo has, however, located some of the Kiloes, or west Highlands, on some of the mountains, and they are thought well adapted to the district. At the Westport fair (August 6th) I ascertained that the price of a bull of the breed of the country was from eight to £10; that of a cow, from six to £8. There are no dairies in the barony.


The main roads are in good repair, but the crossroads leading to villages are bad. Few carts are accordingly used in the barony. Carts, indeed, as one of the witnesses said, are of no use to the small tenantry, for they can carry to market all the produce they have to sell, in five or six journeys



---

p.395



on their horses' backs. Within the last few years, however, the Marquis of Sligo has made no fewer than 81 English miles of cross-roads, at a cost of £983. The quit-rents due to the crown, and paid to the excise, are levied on the tenant, if not paid by the landlord; and this practice is the source of great and just complaint. Each occupant is answerable not only for the share upon his own land, but for that of the whole townland of which his forms a part; and hence a feeling of great insecurity is created. If the quit-rent be not paid on the very day it is called for, the cattle are "driven," and for every one so driven, half-a-crown a head is charged in addition. This demand, the reader will observe, is over and above the shilling per annum paid by the farmers as an annual and regular composition to the drivers, whether their services are required or not. To compel a man to pay for having his cattle driven to the pound, is surely sufficiently bad and degrading; but to be regularly taxed for the support of one who is perhaps never employed, is humiliating indeed!




---

p.396


The crop of potatoes is frequently late in ripening, and the intervening period between the new and the old crop, is one of great distress. Should the crop of one year fail, extreme want is inevitable. Sir S. O. Malley remarked, that if the peasantry were enabled to use corn as their chief diet, the periodical recurrence of distress would in this country be nearly stopped, as a failure in the grain crops hardly ever takes place. Potatoes, on account of their bulk, cannot be conveyed with profit to a great distance, and it frequently happens that they are dear in one place, when, at a distance of twenty miles, they are cheap.




---

p.397


Departure from Westport — Remarkable change in the country — Agricultural school at Hollymount — Tricks practised by farmers — Tuam Catholic Cathedral — The two Archbishops — The Protestant Cathedral — Galway — Crookanabruky — Tornabruky — Character of the inhabitants — Willow cradles — Presentation Nunnery at Galway — Other Nunneries — Principal landed proprietors in the neighbourhood — Dead Man's Lane — Tragical story — Spanish appearance of Galway — Price of provisions — Catholic priests of Galway.
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Westport and Robinson's hotel I left with regret, and proceeded by coach to Galway. Having an unavoidable engagement in Dublin, I was prevented travelling along the west coast, and the very interesting wilds of Cunnemara. This district is rich in minerals, and is celebrated for its black, green, and veined marbles.


Our road to Galway lay through Hollymount and Tuam. The country reminded me of the



---

p.398





wolds of Yorkshire; it is nearly destitute of wood, the fields are of considerable size, and I observed with pleasure several flocks of good sheep. With the exception of about ten miles, limestone prevails along the whole district from Westport to Galway. This part of Ireland possesses the remarkable singularity of many of the farms being in the occupation of the owners, most of whom are resident.


The neighbourhood of Hollymount abounds with gentlemen's houses; and, with its rich land, green knolls, fertile vallies, and abundant water, forms a pleasing contrast to the dreary aspect of the barren tracts between Castlebar and Lough Conn. The river Robe, which supplies Lough Mask, winds round Hollymount. A year or two ago, an Agricultural School was established near Hollymount; the buildings lie close to the road, between that place and Tuam. The condition of this establishment is, I regret to say, anything but prosperous. The ground about the house is tastelessly arranged, and I fear that at least an equal want of judgment is exhibited in the agricultural



---

p.399



department. The crops appeared weedy, and very little green crop was visible. I saw one patch of cabbages about 20 yards square, and believe there were a few turnips in the distance. In my opinion of the merits of this school I shall be glad to find myself mistaken; but impressed as I am at present, I think the proprietors would do well to apply to Mr. Blacker, of Armagh, for an agriculturist.


According to the account of the Assistant Commissioners, who visited this institution, the farm consists of 94 English acres. Mr. M'Chlery, the agriculturist here, stated, that previously to taking this situation, he was master of a similar establishment at Templemore, for seven years. His agreement for Hollymount was as follows. He was to pay £100 a year rent, and was to receive 40 pupils (30 males and ten females), who were to pay at the rate of £10 a year each, for which he was to provide them board, lodgings, and instruction, and was to have the benefit of their labour. The Assistant Commissioners, who investigated this barony, state, from personal observation,



---

p.400



that the buildings, especially the house, are of a more costly description than is necessary for the purpose. The crops consist of oats on an old bog; wheat, about 10 acres, a very fine crop; potatoes, mangel wurzel, Swedish and white turnips, planted in drills. This account fully confirms the necessarily imperfect opinion I formed in travelling past. The money that ought to have been applied to promote the ends of the institution, has been thrown away upon an ostentatious but useless building; and in the arrangement and execution of the plans, a sad lack of co-operation, on the part of the influential residents of the neighbourhood, is perceptible. I concur with Mr. Blacker in thinking, that until the Irish gentlemen act more in concert for the public good than they do at present, the best method of effectually teaching a knowledge of agriculture, is for the owners of property to provide themselves with experienced bailiffs, who may set a practical example of the improved theories they maintain. Agricultural Schools, on a small scale, and under judicious management, might succeed; but failures such as



---

p.401



that at Hollymount are grievously discouraging, and injurious to the cause they were intended to serve.


One of my fellow coach-passengers entertained us by relating instances of the tricks resorted to by the farmers, in order to deceive the corn-factors. A bottomless churn is put into a sack, and filled with grain of an inferior quality; it is then surrounded and covered with good grain, and drawn out. This, however, is a practice not confined to Ireland; it is sometimes detected in the markets of this country; and many of my readers will doubtless have had occasion to know that the strawberries which the fruiterers in London exhibit on the tops of the pottles, are very unsafe indexes of the quality of those that lie concealed within. My companion also informed us that the farmers, when in want of a little wool to mend their stockings, are in the habit of cutting off from the side of a sheep as much as will serve their purpose, not choosing to trust their wives with the whole fleeces. A patch of calico is sewed over the bare place, as a substitute for the wool.




---

p.402


Tuam has a population of nearly 7,000, and is remarkable for its new Catholic Chapel, or, more properly, its Catholic Cathedral. The funds raised for the erection of this edifice, which is in the richest and most florid style of Gothic architecture, were voluntary contributions, and the labour in building it was supplied gratuitously. Unfortunately I had no time to take a survey of the interior, many parts of which are spoken of as singularly beautiful. "The altar," says one who inspected it, "is entirely of Italian marble, of various descriptions; it was made at Rome, and sent as a present from the Pope, carefully packed in boxes. The workmanship of the whole is exquisite." The steeple has not yet been added. Tuam is the residence of Power le Poer Trench, Protestant Archbishop of the place, and also Bishop of Ardagh; and of Dr. McHale, the Roman Catholic Archbishop of Tuam. The rancorous feeling that subsists between these two dignitaries of conflicting churches, seems to demand from us a charitable interpretation of the bitternesses that prevail among those who enjoy fewer advantages,


---

p.403





and whose obligations are of inferior responsibility.


The Protestant Cathedral here is an old building, of Gothic architecture, and small. It contains nothing particularly attractive. Tuam has been the see of an archbishop ever since the beginning of the sixth century.


The morning after my arrival at Galway (23 miles from Tuam) before daylight had dawned I took a car to Salthill and the village of Tornabruky. The hill of Crookanabruky, which I ascended, commands an excellent view of the extensive and very magnificent bay of Galway, the isles of Arran, and other small islands. In the bay there are upwards of 2,000 fishing boats; the fishermen have chosen the western side of Galway, near the bay, for their residence. They are said to be a singular people, and seldom marry out of their own caste. Cod, haddock, ling, red and grey gurnet, mackarel and lobsters, are found here in great abundance; also some turbot. A fine cod sells at from 8d. to 1s. 6d.; and a turbot from three to 6s. The salmon fishery closes



---

p.404



on the 12th of August; that fish is frequently in great plenty, the price, according to the season, varying from 6d. to 2s. 6d. per lb.


Tornabruky is composed of small thatched cabins on the side of the steep hill of Crookanabruky, and is a curious village. The street is exceedingly abrupt, and serves the double purpose of a road and the bed of a boisterous torrent. The inclosures on the mountain side contain each only a few perches, or at most a rood of ground, and are fenced by the industry of the inhabitants at their own expense. The walls are five or six feet high; yet notwithstanding their great extent, considerable numbers of the stones which previously encumbered the ground are unappropriated, and are piled in tall heaps in the little parrocks. At a short distance the village and the surrounding inclosures resemble a honeycomb; nor is there a tree, hedge, or shrub, visible in the neighbourhood. The people pay at the rate of one-fifth of their rent for cess, and do not know to what purpose it is applied. A man, for instance, paying a rent of £5, would


---

p.405



have to pay £1 for cess: this is a state of things that calls loudly for reform. I saw no turnips, rape, or tares, amongst them; indeed their knowledge of agriculture appeared to be of a low and limited order; but from their inquisitiveness and eager desire to obtain information, they would, I doubt not, cheerfully submit themselves to a systematic course of instruction. In manners, these people are somewhat original and eccentric, but very obliging. The women wear red petticoats and vests, and a short blue cloak that covers part of the head — a dress that is peculiar to the female peasantry of Galway. Few of them wear stockings. The prevailing colours, red and blue, are dull and dirty looking, very different to the bright showy colours so greatly admired and so much in vogue in most parts of Ireland. A large proportion of the drudgery falls upon the country-women, who (probably in consequence) are generally short, square, and inelegant.


On descending from Crookanabruky, we found our horse by the fireside amongst the children,


---

p.406



eating something in the shape of corn, which, however, proved to be nearly all husk, with but little kernel. Indifferent as it was, this constituted the best fodder they could supply. Here I saw an intelligent and very interesting deaf and dumb boy, who invited me, by looks and gestures that could not be misinterpreted, to sit down and observe an infant that lay smiling in its willow cradle. This cradle was neatly made, and had actually cost, when new, no more than *seven-pence* — two of them having been bought at Galway (so the farmer informed me) for the sum of *fourteen-pence*. In England, each would have been sold for six or seven shillings. The low prices obtained for almost everything produced directly by manual labour, are sufficient to discourage industry; but if a railway communication should be established between Galway and Dublin (and it is talked of), an opportunity for the export of their manufactures will be afforded, and a stimulus accordingly applied to their ingenuity and exertions.




---

p.407


From these novel and interesting scenes I hastened to take advantage of the kind offer of a lady in Galway, to accompany me to the Presentation Nunnery. On knocking at the door we were immediately admitted, and politely conducted by one of the Sisters to the several rooms in which the pupils were prosecuting their studies. This admirable establishment consists of twenty nuns and a superintendant, bound together by the benevolent desire of promoting the comfort and the happiness of their fellow-beings, and successfully devoting their best energies to the accomplishment of the projected end. The nuns take four vows — viz., poverty, charity, obedience, and instruction of poor female children. The children are admitted at the age of eight, to the number of from four to six hundred, and irrespectively of religious distinctions — and continue under the vigilant and virtuous care of the sisterhood, until fit to enter upon the active engagements of life. They are educated (gratuitously of course), with reference to the situations of governesses, nursery-maids, ladies'-maids, and


---

p.408





confidential servants, and are sought by families in every part of Ireland. One hundred and eighty of the pupils have a breakfast given to them every day, and two hundred are clothed yearly. The funds arise from the subscriptions of the benevolent, and the sale of the needle-work of the girls, to which is added a grant of £30 from the Board of Education. Some of the pupils are engaged in making lace and tambour-work, the proceeds of which they receive; and it not only provides them with clothing, but greatly assists their parents in the payment of their rents. The children were busily engaged as we passed through the apartments, and appeared clean and healthy. The majority were from eight to twelve years old.


We were presented to the Mother, a venerable lady of eighty years of age. She very kindly accompanied us to some of the apartments, and also to the retired garden of the nunnery; and directed our attention to the burial ground — a small plot, *four yards square, and containing only one solitary grave* — as a sort of negative argument in



---

p.409



favour of the salubrity of the situation, and the regularity of the mode of living pursued in the establishment. This interesting lady appeared religiously devoted to the self-appointed duties she had incurred — was no less eager in soliciting, than frank and prompt in supplying, information — and expressed her anxiety to adopt any improvements that could be suggested in the practical management of the institution. The dress of the nuns was neat and unassuming. During the two or three years of probation, a white veil, thrown over the head, and somewhat resembling a muslin handkerchief, is worn; at the end of this period, the novice either assumes the black veil, and pledges herself to perpetual residence within the walls of the nunnery, or abandons it for the busy world from which she separated herself on first joining the secluded community. From the waist of each of the sisters a large black cross and beads were suspended, and this was the only distinctive symbol of their connexion with the Roman Catholic religion. On entering the institution, the sum of £600 is required to be paid; but if the individual


---

p.410





paying it, does not remain beyond the period of probation, thirty or £40 are detained, in consideration of the term of her residence, and the balance of the original sum is returned to her. I must not conclude my notice of the Presentation Nunnery without remarking, that there are no private rules affecting the children, except such as refer to the domestic concerns of the establishment; and that no attempt is ever made to instil the principles of Catholicism into the minds of the Protestant pupils.


My visit to this nunnery was a profitable one. It taught me to condemn myself for having entertained harsh and uncharitable opinions of the monastic life; it afforded me a practical proof that seclusion does not necessarily imply inactivity, but that an entire withdrawal from what is called the world, is compatible with a diligent and extensive exercise of the spirit of philanthropy.


Galway contains three nunneries besides that which I have been describing. They are, however, totally dissimilar to it — no children being admitted, and no instruction of any kind being



---

p.411



given. A priest, of the name of Peter Daly, lately founded another institution, of the Order of the Sisters of Charity. This Order, which is peculiar to the Roman Catholic Church, and has been truly said to be "at once its highest boast and its greatest ornament," was established by Vincent St. Paul in the year 1629, assisted by a benevolent lady named Le Gres. The duties of the Sisters are to visit and attend upon the sick poor, both in the public hospitals and at their private houses — to administer food and medicine — to supply clothing — and to promote, to the best of their ability, the comforts of the destitute in every possible way — without distinction of sect or creed, and gratuitously. Galway has also a school, which contains from four to six hundred boys, 150 of whom are fed with "stirabout" and milk every morning, and 200 of whom are clothed. The funds arise from subscription. It is in connexion with the National Board of Education, and was founded in the last century by a parish priest who was Catholic Warden of Galway, named Austin Kerwan. I entered the school, but the 


---

p.412





children had not generally assembled; those already there looked pale, and wanted both the cheerfulness and the cleanliness exhibited by the girls in the Presentation Nunnery.


The population of Galway is about 38,000. In the town there were 8000 destitute paupers, and within two miles round, no fewer than 20,000, and this number was stated to be daily increasing. No beggars are allowed to be in the streets; they are relieved by the Mendicity Institution, at an average cost of 8d. per week each. There is also a Dispensary and a Fever Hospital, all supported by private charity. The labourers receive, in the town, 10d. per day without diet, and in the country from 6d. to 8d. without diet, but are employed only half their time. With this load of pauperism crippling its energies, no wonder that Galway should not keep pace with some other towns in wealth and prosperity.


The principal landed proprietors in the county are, Thomas Martin, Esq., (the member for the county), the Marquis of Clanricarde, Lord Dunlow, Lord Clancarty, Sir Thomas Burke, Mr. Dealy of



---

p.413




Dunsandle, Mr. St. George of Tyrone, and Mr. St. George of Headford Castle; Mr. Bellew of Mount Bellew, Mr. Martin of Ballynahuigh Castle, with many others of the Blakes, Browns, Rodkins and Lynches, all Galway names. Property is better divided in Galway than in any other county in Ireland.


In Dead Man's Lane, Lombard-street, a tablet representing a death's head and cross-bones in alto-relievo, is considered, and certainly is, an object of interest. It is about two feet wide, by two feet eight inches in height; and the motto, which is now partially effaced, has been — "Remember deathe, vanite of vanite, and all is but vanite." With this tablet a tragical story is connected. James Lynch Fitz-Stephen, Mayor of Galway in 1493, had brought from Spain a native of that country, named Gomez, with whom his only son, Walter, soon contracted an intimate acquaintance. Walter, who was affianced to a young lady of family and fortune in the neighbourhood, began to suspect that the attentions of Gomez were regarded by his betrothed with a degree of



---

p.414



interest which was scarcely compatible with the relation they bore to each other; these suspicions shortly afterwards receiving the most unequivocal confirmation, he sought to revenge himself by taking the life of his successful friend and rival. Gomez fled to the sea-shore — Lynch overtook him at the water's edge, plunged a poignard in his bosom, and cast his body into the sea. The wretched murderer fled for refuge to an adjoining wood, in which he spent the night, a prey to feelings of the deepest anguish and remorse. Unable to bear the assaults of conscience, he resolved to surrender himself to the law, and on proceeding towards the town for that purpose, encountered his father, accompanied by several officers of justice. He proclaimed himself the assassin: the father, with a heroism that would have done honour to the best ages of Greece and Rome, smothered, as it were, the feelings of a parent, and condemned his son to the ignominious punishment of a murderer. At the execution a rescue was attempted by the relations and friends of the convict; and the father, finding all his efforts fruitless to accomplish



---

p.415



the ends of justice at the accustomed place, resolved himself to perform the sacrifice he had vowed to pay on its altar. He accordingly took his son to a window in his own house, which overlooked the street where the multitude were assembled; secured the end of the rope which was fastened round the neck of the criminal to an iron staple; and after giving him a last and most affectionate embrace, launched him into eternity. The intrepid magistrate expected instant death at the hands of an enraged populace; but the magnanimity of his conduct overawed the people, and they retired quietly and peaceably to their respective dwellings. This event is the subject of a tragedy by the Rev. Edward Groves.[17](javascript:footNote('E830001-002/note017.html'))


I ascended the old walls of the town, remnants of which are preserved. They are ten or twelve feet thick, and thirty feet high. At the extremity of the garden of the Kilroy Hotel, a gentleman has



---

p.416



displayed his good taste by building upon the base of one of the old dilapidated towers, a modern tower of corresponding architecture. From this garden (in which is an ancient stone image, found in the earth, supposed to have been an object of adoration) Terreland Castle, the seat of the Clanricarde family, Sir Valentine Blake's Castle, Dongan House, late Mr. Martin's, and Castle Oran, are seen.


The old streets of the town are narrow, and the curiously carved and singularly shaped doorways exhibit great antiquity. "At every second step," says **Inglis**, "I saw something to recall Spain to my recollection. I found the wide entries and broad stairs of Cadiz and Malaga; the arched gateways, with the outer and inner railing, and the court within. I found the sculptured gateways and grotesque architecture which carried the imagination to the Moorish cities of Granada and Valencia."


Provisions at Galway were cheap; potatoes 1d. to 1 1/2d. per stone; oats 6d. per stone of 14lbs.,


---

p.417



weighing 36lbs. per bushel; wheat (red) 6s.; (white) 7s. per cwt., 58lbs. per bushel; barley 10s. the barrel of 16 stones. Fish is very plentiful. The best Newcastle coals on the quay were from 14s. to 16s. per ton; Scotch, from 12s. to 13s. A dock and canal, intended to communicate with Lough Corrib, are preparing, and will doubtless be found greatly to augment the resources of the district.


The Catholic Priests of Galway were represented to me as a well-informed and gentlemanly set of men; it was added, however, that whilst they do not object to the bible being in the hands of the well-educated Catholics, they would withhold it from the more ignorant of the laity of their communion. This does not, to a Protestant at least, say much in support of the first of the preceding epithets; and if anything could justify an uncharitable feeling towards them, it would be their cruel policy in withholding from those who stand so much in need of solace, the most prolific source of comfort. The scriptures are often the 


---

p.418


*only* fountain of hope possessed by the poor; from the pages of holy writ they learn patience under the sufferings and deprivations of this life, and are taught to look with confidence to a better world beyond the grave.


Volume 1
--------




---

p.1


Examination in the Barony of Kilconnel — Deterioration of marriage-feasts — Premature marriages — The Terrys — Dreadful case of revenge — Sufferings from hunger — Priests' dues — Substitutes for candles — Potatoes, the chief food of the labourers — The cabins of the poorest classes — Improvements at Crith Bog — Inequality of Grand-jury cess — Cattle of the district — Ahascragh Loan Society — Junction of farms — Farms of ten acres — Advice to both landlord and tenant — Meaning of the term "absentee" — Contempt for leases.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


It was stated to the Assistant Commissioners, in their examination in the barony of Kilconnel (situated 18 miles to the eastward of the town of Galway, on the road to Ballinasloe) that the barony, exclusive of bog, contains 26,185 Irish acres, and that few labourers can obtain work for more than


---

p.2




200 days in the year; one hundred at 6d. and the other at 8d. per day; amounting altogether to £5. 16s. 8d. This sum is but nominally gained, as, where land is set above the fair value, on condition of giving labour for rent, the tenant is a loser in proportion. An old man cannot get employed at all. Many of the labourers declared they were fully sensible they did not work so well as those who were better fed.


The regular expenses of marriage are confined to £1. 1s., and 5s. to the Bishop for a dispensation, and 10d. to the clerk. The feast which succeeds the ceremony is always at the cost of the parents of the bride; and on these occasions it is nothing uncommon for a labourer to spend three or four pounds, the savings of years, in the purchase of bread, meat, tobacco, spirits, and lights, to celebrate the marriage of his daughter. During the feast, a collection is made for the benefit of the priest who officiated at the marriage, and all present are anxious to give what they can afford, from a shilling upwards. It is, indeed, a matter of pride to see who will give the most. At christenings,


---

p.3




the priest receives 2s. 6d., the clerk 3d. The wake and funeral of an ordinary labourer are attended by most of those who had been his neighbours or friends. "Now a day," said Ginnessy, one of the witnesses, "there is nothing given out but pipes and tobacco; those who are rich give whiskey, and those who can't afford to give any, are as much ashamed as if they had done something wrong. All that any one gets is a pipe, and may be he smokes it on the side of the road, if the cabin be small. The coffin will cost 7s.; a few gross of pipes will be 10s. more; then there will be six or seven shillings' worth of tobacco and lights, and the winding-sheet will be eight or ten shillings more. Most frequently the priest gets nothing."


Here, as elsewhere, premature marriages are the rule amongst the labouring classes, and not the exception. A very large portion are married before the age of 21, some even as early as 18; and very few turn their attention to making any provision before they contract the important obligation. "What," said Neal, a labourer,



---

p.4




what can a girl or a boy lay by against marriage, except the seed of a rood of potatoes — After I had paid the priest myself, I had nothing to begin housekeeping with but 10s., and may be, if I was young, I should do the same again." The most comfortable, it was stated by Mr. Lynch, are always the least inclined to marriage. On this subject several of the witnesses remarked to the following effect, and indeed in the following words respectively: "Nearly all the cottier tenants are married men, and yet, if they looked in upon themselves, they would be fools to marry. They are then bound to poverty for life, and the latter end of them is to beg." "If I had a blanket to cover her," said Connor, "I would marry the woman I liked, and if I could get potatoes enough to put into my children's mouths, I would be as happy and content as any man, and think myself as happy off as Lord Dunlo." Others declared that if they were turned out that moment to beg, they would marry. "They often say — 'worse than we are we cannot be;' and it's that makes men disturbed and unlawful, when they see themselves



---

p.5



and those that are about them, turned adrift on the world. It's that brings Terrys into the country. They may as well take my life when they take my land; for what's an existence without a place — About three years ago, a man who had a farm, offered the same rent as the man who was put in his place; the Terrys came — they would come from Clare for revenge — and swore the new comer to give up the land. He did not keep his oath, and in a week's time a man came at twelve in the day, and sent into the house for Flanagan. When he came out to him where three or four of his own labourers were standing, the stranger drew out a pistol and shot him. No attempt was made to take the fellow; the fear of the Terrys was too great." Another witnessed observed, "These things never did the people any good in the end; but what could you look for, where one gentleman could turn out 108 families, every one of them from five to seven persons in a family, and pull down their cabins, as I know to have been done in this country not a great while ago. He (the proprietor) was obliged to leave the country; he



---

p.6




died a short time since, and they brought him to his own place and buried him; but the people came at night, and dug up his grave, and put a gallows over it. Men grow careless about themselves and their houses, when they feel that they cannot be worse off than they are. Many a man must lie in bed to have his shirt washed, and some cannot afford to buy soap."


In the parish of Aughrim, the Rev. William Martin stated "that no material alteration had taken place regarding wages;" and added, "I am afraid you would find plenty of men ready to work at 6d. a day all the year round." Mr. Wade said that he gave 5d. a day in winter and summer; and a witness of the name of Lloyd said that he had known labourers to be so hungry as to "give up" two or three times in the course of the day; not having tasted food since their supper the night before. Mr. Bermingham, Lord Clonbrock's agent, stated that the poor people suffer almost more than human nature could be supposed capable of enduring, and that, notwithstanding, they scarcely ever repine. From the great competition


---

p.7



or wages, the lowest amount offered is taken; indeed, the labourers will engage themselves for *any* sum, however low, which is sufficient to support them; and "by support," said a man of the name of Perry, "I mean merely keeping the breath in them, having very few clothes, and of course being utterly unable to lay out anything. That is what we mean by *support*." Fivepence a day is the general amount of wages. "Lord Clonbrock," it was stated, "seeks to encourage self-employment or task-work, on the principle that it is better for the people. He gives to his labourers 8d. per day in summer, and 6d. in winter, without diet in either season. A single man, who works for his food only, is better off than the married man who gets 5d; for the 5d. is eaten before the family go to bed, and none of them can say they had anything to spare."


The better sort of farmers, it appeared, usually give their priest from one shilling to two-and-sixpence at Christmas and Easter: and by such as can get to confession, a shilling is given. The poor people are never required to pay any of these items.




---

p.8


In lieu of candles, which are very rarely seen, rushes, dipped in butter melted, are used. Others make use of splinters of bog fir, which contains a large portion of turpentine, and blazes very freely.


In periods of particular distress, the labourers obtain potatoes on credit, at a great sacrifice. This, indeed, is their only resource; and if a man happens to have no credit, he cannot get them at all. In all cases, they pay high for the accommodation — sometimes as much as 200 per cent. After Garlic Sunday (the first Sunday in August), the potatoes most in use, namely lumpers, acquire an unwholesome quality; those, accordingly, who can afford to do so, cease to live altogether upon them, and substitute oatmeal in some degree, giving their old potatoes to the pigs. But there are many cottiers who have no alternative but to eat the unwholesome food, which, in part at least, accounts for the prevalence of disease towards the close of summer. About the latter end of August (Mr. Hughes, P. P., stated), a large proportion of the new potatoes are fit for consumption; but those which have not been planted, in 



---

p.9




consequence of the inability of the labourers to buy seed, until July, are not fit to dig until Michaelmas. Notwithstanding this, it is by no means uncommon to see the poor digging their crops, not only before their full growth, but when they are absolutely as unwholesome as when too old. Potatoes, if they be of a good kind, may be preserved till October. On being asked if they preferred potatoes to meal and bread, some of the witnesses exclaimed — "Arrah there, Sir, why should we prefer what we feed our pigs on, to better food — Don't you like it better yourself; and why shouldn't we — Never believe them that want to make you think that we'd eat but lumpers, if we could get good bread."


The cabins inhabited by the very poorest, are frequently without windows. Some of the hovels are truly miserable, consisting of walls of loose stones, thatched with thistles and potato stalks. These are inhabited by mendicants or dispossessed tenants from other parts of the country, and are for the most part placed in the hollow of a wide ditch; the tenants paying no rent to the middlemen



---

p.10




on whose ground they stand. One of the tenants, Patrick Flagherty, stated "that the hovel occupied by him, cost him 15s. building."


The cottages recently erected on the estates of Lord Clonbrock, and the other large proprietors, are superior to the generality. Those built on Lord Clonbrock's property are thirty feet long. His lordship provides timber, eave-stones, and iron window-frames, which move on central pivots. The panes of glass cost but 1d. each.


One of the gentlemen present stated "that in some cases landlords have located their cottiers on the verge of bogs, at high rents; and that when these lands have been reclaimed by the exertions of the cottiers, the latter have been further removed into the unreclaimed moor, still at a high rent; and thus the landlord has reaped all the benefit of the poor man's industry."


The improvements at Crith Bog, carried on by Lord Clonbrock, under the care of his benevolent and enterprising agent, Mr. Bermingham, are said by the Rev. Charles Clarke, one of the Assistant Commissioners, to be of great importance.


---

p.11



The expense of draining was stated by Mr. Bermingham not to exceed £2, and the cost of digging and harrowing to be £1. 15s. per acre; the gravelling costs 2s. per ton: two tons at a time being drawn by a horse upon a moveable railroad. The capital expended in forming the main roads and laying the temporary rail, Mr. Bermingham calculates will vary from £600 to £1000. This outlay will allow of 200 Irish acres per annum being reclaimed.


It was stated by one witness, that on forty Irish acres of tillage, allowing a fair quantity of horse power, twenty men would be "constantly employed throughout the year;" by another, that "twelve men, working 200 days each, would be sufficient." A third person thought, "that on a farm of 100 acres, half in tillage and half in grass, fifteen labourers, employed 200 days in the year, and four horses, or two horses and two bullocks, would answer the purpose." On a farm of 90 acres, of which 12 were in oats, 3 in potatoes, and 5 in wheat, one pair of good horses were kept; and the amount paid for labour, at


---

p.12




6d. per day the year round, did not exceed £40, although the cost of cutting turf was included.


The grand-jury cess is a little more than 2s. per Irish acre. Every acre, good or bad, which is assessed, pays the same rate. The uncertainty of the amount, the manner in which it is assessed, and the period at which it is levied, are causes of considerable distress and dissatisfaction to the small landholder: Mr. Seymour, who is appointed to make the assessment for tithe, thinks that when made, it will not exceed 6 1/2d. per acre. Where the Composition Act has been acted on, tithe is assessed much more equally than the county rate.


This district contains no dairy-farms, no more cows being kept than are absolutely necessary to supply the family. Sheep are common; the breed in general use is the Irish, with a considerable cross of the new Leicester. Mr. Taafe, of Roscommon, and another breeder of sheep, frequently procured them from Dishley; and by this cross the breed has been somewhat diminished in size, whatever other good qualities may have been


---

p.13




obtained. If the prevailing predilection for the old mutton could be overcome, further improvement might still arise by getting nearer to the Leicester blood, because it would be accompanied by a quicker return of capital. Every one, holding only a small quantity of land, keeps a few sheep, for the purpose of using the wool in making his clothing; and a considerable portion of the land in this barony is particularly adapted to sheep-farming. The usual breed of cattle is the native Irish, improved by the Leicester; perhaps no breed can be better suited to the present state of the agriculture of the district, than the first cross between the Durham and the Irish. The value of a good bull of the Irish breed is £15; of a cow, from eight to £10. Large grazing farms let at from twenty to thirty shillings per Irish acre.


The small farmers and labourers are so completely destitute of money, that it is utterly impossible for them to commence improvements, or even to do anything to obtain it.


As a proof of the proper application of money advanced to the poor, and their honourable repayment,


---

p.14




I may mention the Ahascragh Loan Society, at a weekly meeting of which the Assistant Commissioners were present. The funds amounted to £720, part borrowed from the county of Galway Trustees, at one per cent, and part from individuals, at six per cent. The sum was disposed of amongst 400 borrowers, and in the two years during which the society had been established, no loss had occurred. This may be in great measure ascribed to the attention and excellent management of the treasurer, the Rev. Henry Hunt. A person taking a loan, pays the interest of 6d. in the pound for twenty weeks; or rather, has that sum deducted at the time of receiving the loan. One shilling in the pound is repaid weekly, which secures the repayment of the whole loan at the end of the twenty weeks. The interest, at 6d. in the pound for twenty weeks, would amount to £6. 10s. per cent per annum; and as the interest is deducted at the time of obtaining the loan, that would raise the interest to £6. 18s. per cent. This calculation is made on the supposition that none of the money be repaid till the end of the term;



---

p.15




but out of every £100 lent one week, £5 is returned the following week, and so on, till in the last week of the twenty, only £5 remains unpaid; — so that £50 is the average sum out of the twenty weeks, and this being taken into consideration, the interest amounts to nearly double the sum which was stated above. It would be exactly double, only that the interest accruing on the interest being paid beforehand is included in the £6. 10s. It will amount to £13. 18s. 5d. per cent.


In reference to the competition in bidding for small farms, and the consequently disproportionate rate of rent, which, however, in a majority of cases, is nothing but nominal, Mr. Bermingham stated, that until this practice ceased, the condition of the labourers could not possibly be improved. "Nothing," added this gentleman, "can more clearly prove what may result from an equitable reduction of rents, than what has recently occurred in the townland of Doon, where Lord Clonbrock has succeeded the former lessee of the crown. Lord Clonbrock has lowered



---

p.16




the rents more than one-third. Formerly, the tenants, oppressed with exorbitant and high rents, used to think they could not pay their landlords except by their labour; they have, however, now refused to accept work in the reclaiming of bog land, declaring they had enough to do on their own grounds. Hopeless of meeting their rents, they formerly neglected the cultivation of their holdings, and grasped at ready-money wages, however low. Their lands are now well tilled, and there are no arrears due, and labourers for the improvements come from other quarters." Although the disposition to junction of farms exists, on the part of the landlords, the system has not been pursued to much extent; the only great alteration of tenantry is on Lord Clonbrock's estate, and this (according to the statement of Mr. Bermingham, and others present) took place, not with a view of making one large farm, but of throwing a number of minute holdings into a certain number of farms of 10 acres each. The change had been effected without having recourse to any harsh measures.




---

p.17


When Lord Clonbrock came into possession, the land was held by about fifty occupants; his lordship not only offered to each a sum of money as a compensation for being ejected, but proposed to furnish them with locations on the unreclaimed part of another estate, together with assistance towards building houses. Several accepted the latter condition; a few emigrated to the colonies, availing themselves of the money received; and four or five of the old occupants still remain. Mr. Bermingham adds, that so far as he can judge, he has every reason to expect that the produce of the farms of 10 acres will far exceed the united produce of the small holdings from which they have been made; he is also led to hope that the occupiers of these 10 acres will no longer seek for labour abroad, but find full occupation at home, which is not the case with farms of the same extent under the old system, and at high rents. Mr. Bermingham further adds that any tenement of two or three acres, is susceptible of all the advantages of a systematic course of husbandry, but in this barony no such attempt has



---

p.18



ever been made. Lord Clonbrock is turning his attention to the formation of an Agricultural School, but nothing has yet been done.


The above observations of so experiened a man as Mr. Bermingham, are worthy of great attention, and go far to prove that by fixing the rents on a practicable scale, not only are the energies of the tenant more industriously exerted, but, no arrears being incurred, more rent is actually paid than when it was nominally nearly double. This, however, though leading the way to improvement, is only half doing what ought to be done. Let the poor tenant be taught that by altering his plan of husbandry he may double his produce, without the application of any additional capital except the labour of himself and family. If his landlord lend him a little assistance at the commencement, so much the better; this assistance he will soon be able to repay, with such interest as every landlord must appreciate; viz., the permanent improvement of his estate; a happy tenantry; increased rents, better paid; and the security and increasing prosperity of the country.




---

p.19


By far the greater part of the barony of Kilconnel is held direct from the proprietors in fee, without the intervention of middlemen. "The lands of Ballyglass," said Mr. Bermingham, "were this day valued by me as Tithe Commissioner. Two hundred acres are on one side of the road, held by Mr. Conally, under the Bishop of Clonfert, at a rent, as I have been informed, of 19s. per Irish acre. The best part has been re-let to solvent tenants, at £1. 10s. per acre; but the Doon Hills, consisting of boggy bottoms, have been let to industrious but poor men, at £1. 5s. an acre — rents disproportioned to the true value of the respective lands. I have, acting conscientiously, valued the entire lands as follows — 80 acres at £1. 10s.; 80 acres at £1; and 40 acres at 10s. All the non-resident proprietors have resident agents; we only give the term *absentee*, at least in an invidious signification, to a proprietor who resides entirely out of Ireland, and has no resident agent. Restrictions to a particular course of husbandry are never thought of; but in general, tenants would sign leases containing any clauses 



---

p.20




whatever, for they never think of reading them." What can be a stronger proof than this of the reckless temper of the farmers — Having nothing to lose, either in possession or in prospect, they regard the restrictions with contempt. Worse they cannot be, and land they must have, on any terms.


Few landlords, except Lord Clonbrock and Lord Clancarty, allow for improvements, or encourage their tenantry.




---

p.21


Cattle fair at Ballinasloe — Lord Clancarty — Rents and wages — Pertinacity of beggars — Athlone — Singular customs of the people — Red bogs — Opinions of Mr. Weld — Iron and coal districts — Seven churches of Cluanmacnois — Sacred relics — Birth-place of Goldsmith — Moate — Return to Dublin — Croghan Hill — Bog of Allen — Splendid sunset — The popular faith in Spirits — A few words on Fairies — Philipstown — Destitution of the people.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


From Galway I travelled by coach to Ballinasloe, a neat town with a very spacious area for the cattle and sheep fairs held from the 5th to the 9th of October. In the year 1812, there were 83,527 sheep, and 9,983 cattle, shewn at this fair: in 1828 the number of sheep was 97,384; that of cattle 11,513; in 1834 there were, of sheep, 62,928, of cattle 8,054: which diminution in the numbers may be accounted for by the facilities afforded for


---

p.22




export by the steam communication with Liverpool and other ports; the cattle, instead of being disposed of to dealers at the fair, being now sent direct to the English market.


The river Suck flows through the town, and joins the Shannon seven or eight miles to the south-east of it. Ballinasloe belongs to Lord Clancarty, who uses every means in his power to improve and beautify the town and neighbourhood. Garbally, his residence, is about a mile from Ballinasloe. One of the best of landlords in this neighbourhood is James Daly, Esq. of Dansandale.


This town has a population of about 5000, and is remarkable for having only one pawnbroker. The farms are from twenty, to two or three hundred acres in size. The average rent of arable ground is 20s. per acre, the cess 3s.; lime at the kiln is 8d. per barrel; oats are 6s. 8d. per barrel of 14 stones; and potatoes 1 1/2d. per stone. Labourers, at busy times, get 5d. and 6d. per day, and a meal of potatoes from their employers; and at other times 4d. Lord Clancarty gives 8d. in 


---

p.23




winter, and 10d. in summer, without diet. Conacre, for which the labourer pays at the rate of from four to £5 per acre, is usual; the farmer finds no manure, but allows the labourer to scraw the surface and burn it to ashes.


At Ballinasloe I experienced considerable inconvenience from the beggars, who flocked about the coach in great numbers, and were so desperately persevering as to prevent us from looking attentively after our luggage. Nay, so extreme was their importunity, that they actually assailed the outside passengers by pulling at their legs! The women did not seem distressed, but might very properly be designated sturdy resolute beggars, for they laughed and asked charity at the same time. From Ballinasloe to Athlone the road lies through the southern part of the county of Roscommon. Athlone is a remarkably interesting town. The castle, built by King John, was an important fortress. The Dutch General, Ginkle, who commanded the English after the defeat of James II. at the battle of the Boyne, succeeded in taking the city in 1691, and as a reward for his


---

p.24




signal services, was created Earl of Athlone. The population is nearly 12,000.


Among the singular customs of the people of Athlone is the following, related in the words of Dr. Strean *(as cited by **Weld**)*. "On the eve of St. Martin, one of the great saints, whose day still continues to form an important epoch in the calendar, the 11th day of November, every family (more particularly in the country part of the parish) kills an animal of some kind or other: those who are rich, a cow or sheep, others a goose or turkey; while the still poorer, who cannot provide an animal of greater value, kill a cock or a hen, and sprinkle the threshold with the blood, and do the same in the four corners of the house. This ceremony is performed, to exclude every kind of evil spirit from the dwelling where the sacrifice is made, till the return of the same day in the following year." Dr. Strean goes on to ask if this does not look like a continuance of the command given to the Jews in the 12th chapter of Exodus; but my readers will excuse me if I decline following him in his interesting and ingenious speculations.




---

p.25


**Dr. Boate**, in his Natural History of Ireland, when treating of the bogs of this district, remarks, "Some of these dry, or red bogs, as commonly they are called, are in some parts of a vast extent; instance that by the Shannon side, beginning hard by Athlone, and following the course of the river down towards Limerick, which, being two or three miles broad in most parts, is said to be upwards of fifty miles in length."


The extent of bogs in Roscommon is stated by **Mr. Weld**, in his Survey of the county, to be 131,057 statute acres; the remaining part of the county, exclusive of water, being only 453,515 acres. Is it not extraordinary that any person should harbour an opinion that there are too many labourers in Ireland, when even in a single county there are 131,000 acres capable of yielding the finest crops, inviting cultivation — 


"Agriculture alone," says **Mr. Weld**, in his interesting survey above alluded to, "appears to offer a sure and stable source of occupation for the people of a county circumstanced like that of Roscommon; and that it would prove


---

p.26



 

beneficial, for a race even far more numerous than is at present spread over the surface, were the improvement of the land pushed to the highest degree of which it is susceptible, cannot admit of a doubt. Scarcely is a field to be seen, the demesnes of the noble and gentlemen alone excepted, where it is not evident that labour might be expended with a profitable result, in fencing, and hedging, and planting, and draining. Roads, likewise, might be improved, with permanent advantage to agriculture and to the people; new communications opened with the Shannon, and quays and harbours established on its banks. To crown all, upwards of 80,000 Irish acres of bogs remain to be improved, which, if roads and a few drains were cut through them as a preliminary measure, and the people, were it practicable, left to themselves, would infallibly be brought under cultivation within the course of a few years, and food be thus afforded not only to the present inhabitants, but for countless generations yet unborn." — (P. 686). And so confident is **Mr. Nimmo** (a gentleman extensively employed



---

p.27




by the Commissioners appointed to inspect Irish bogs) of the practicability of converting the whole of them (in the county of Roscommon at least) into arable land, *and that at an expense which need hardly ever exceed the gross value of one year's crop produced from them,* that he declares himself willing, for a reasonable consideration, to undertake the drainage of any given piece of considerable extent, and the formation of its roads, for the sum of one guinea per acre, and to prepare the same for the reception of *any* crop, for £10 per acre, which is little more than seven years' purchase of the rent it would then afford.


The northern part of the county of Roscommon is fruitful in iron and coal, and is celebrated for the Arigna coal and iron works, near Lough Allen. In **Mr. Griffith**'s report of the coal district, he states that one of the beds near which these works are situated, is three feet thick, and the quality excellent, and extends over five thousand Irish acres, containing 30 millions of tons, affording a supply, for 500 years, for the iron works and domestic purposes. In addition to this three



---

p.28




feet bed, he further states that there are two other beds of 9 inches and 3 feet, but inferior to the former. In the report of Mr. Twig (an English mining surveyor) of the affairs of this company in 1827, with reference to the injudicious expenditure of the establishment, a table is given of the salaries paid to various managers and agents employed at or near the works, amounting to £1739. 9s. 3d. per annum.


The several failures that have occurred at Arigna, where success ought to have been the result, are attributed by **Mr. Griffith**, as stated by him in his evidence before a committee of the House of Commons, to improper management, and the frequent changes in the managers, who were not skilful or experienced men. Iron ore, in Roscommon, and many parts of Ireland, is almost inexhaustible.


To the right, after leaving Athlone, are seen the seven churches of Cluanmacnois with their two pillar towers, situated on the border of King's county, on the eastern bank of the Shannon, where St. Kieran founded an abbey, so early as



---

p.29



 

548. Here the sons of the chief nobility of Ireland received their education. In 830, Felym, King of Cashel, slew many of the monks, and fired the churches; and ten years subsequently, he was proclaimed monarch of all Ireland. The landed property and endowments of this abbey were enormous, and necessarily gave it great power in the country. Several crosses and stones of curious workmanship are still remaining, respecting one of which the **Rev. Mr. Wright** relates that "at this interesting relique, vows are still paid, and prayers continue to be offered; pilgrimages are performed around its hallowed pedestal, and the penitent, with naked foot, still traces the boundary of the holy cemetery. On the 9th of each September, the Patron-day, some thousand persons assemble in this venerable area to observe the festival of St. Kieran. * * * There are the ruins of seven churches still visible within an area of two acres comprised in the ancient cemetery." **Driscoll** states that "the garrison of Athlone pillaged these celebrated churches, carried off the plate and valuable ornaments, broke



---

p.30




the stained windows, defaced the carvings, destroyed the bells and books, and committed every species of outrage. The same proceeding took place in other parts of the country. It was easy indeed to accomplish a reformation of this description, and unfortunately the reformers of Ireland seem always, as in this instance, to have confined their zeal to the reforms which might be effected in stone and mortar, tapestry, gildings, and plate." A visit to this interesting spot, which is only eight or nine miles from Athlone, is easily accomplished by the Shannon. Lough Derg, in the same direction, as well as Lough Ree on the Shannon, ought also to be visited. Pallasmore, the reputed birth-place of **Oliver Goldsmith**, is situated only fifteen or sixteen miles from Athlone, in the south eastern corner of the county of Longford. The village of Lishoy (according to **Inglis**, the identical Auburn) is about three miles from Ballymahon, in the county of Westmeath.


Nine miles east of Athlone, on the southern edge of the county of Westmeath, we passed through the town of Moate, a clean and respectable




---

p.31




looking place, whose population is about 2000, a considerable proportion of which consists of members of the Society of Friends.


The road through Kilbeggan, Tyrrel's Pass, and Maynooth, to Dublin, is most of the way near the Royal Canal. At Dublin I attended a meeting of the Board, in company with my colleague, and instead of being released from the Commission as I had expected, we were directed to take examinations in the barony of Philipstown, in King's county, in the province of Leinster. Although I had been anxious to return home, I was reconciled to this arrangement, from the prospect which it afforded of extending my knowledge of Ireland.


From Dublin to Philipstown the road is uninteresting. On our arrival at the latter place, after issuing notices, and adopting the necessary preliminiaries, we inspected the district and the farms in the neighbourhood. In the course of our survey, we ascended Croghan Hill, a conical elevation, for it scarcely deserves the name of mountain, although it forms an interesting object for thirty miles round, and commands an extensive view of


---

p.32




the surrounding country. It is mentioned by **Spenser** in his Fairy Queene. This hill is remarkable for its verdure, extending even to the top. The soil is a fine rich loam, upon a limestone substratum; ten or twelve acres of the summit would let for 15s. per acre. There is a cairn on the top, and near it a cemetery, still used by the Catholics, about which are a number of upright grave-stones, bearing inscriptions of the date of 1714 and thereabouts. These stones were once, as Sergeant Malone informed us, mistaken by a party of police for a company of rebels coming over the hill. 


From Croghan Hill great numbers of islands, as the natives all them, but more properly *oases,* or elevated spots of land rising from the bog, may be seen; — of these, Knockarin is remarkable, as being a refuge for vagabonds and malefactors. Though encompassed by the Bog of Allen, which in winter or wet weather may be difficult to cross, and, before any drainage was effected, was wholly impassable by ordinary means, they are covered with excellent soil — part of he substratum being



---

p.33



lime, and part sandstone. The Bog of Allen, nearly in the centre of which I was standing, is one vast and level expanse, stretching nearly from the Irish Sea to the Atlantic. **Arthur Young** states that it exceeds eighty miles, and contains 500,000 acres. Here I witnessed a spectacle of inexpressible splendour. The sun was setting in a sky of cloudless and golden beauty — the brown bog, flushed with the bloom of its abundant heather, lay suffused with purple; and the whole space between the arched heavens and the wide-extending morass, was filled with a radiance of purpled gold, the effect of a mutual reflection from the earth on which I stood, and the shadowless sky that stretched above me. Their gorgeous illumination was one of those things which are more frequently met with in the records of poetry, than in the experiences of actual life.


During this walk our guide entertained us with accounts of the popular faith in Spirits — a subject with which the lovers of marvellous mythologies are made familiar through The Irish Fairy Legends, one of the most amusing and interesting



---

p.34




of publications. The Banshee, Lepreghaun, and other fairies of a similar kind, are seen, according to our guide, in the form of little old men and women, eighteen inches high, and lead to money, and stolen goods. Sometimes they betoken evil, but more generally good, and the people strive to obtain and to preserve their favour. "If you keep your eye on Lepreghaun, who is a little fellow in a wig," said our guide, "he leads you to money." "The Irish name for Fairy," says one who is learned in these matters "is *Sia* (Sheea) and Siabhra (Sheefra). We do not know the original meaning of Sia. Sigh (Shee) is also given by **O'Reilly**, and as it signifies spirit, and, adjectively, spiritual, it is probably the true word." The same agreeable writer (**Mr. Keightley**, whose Fairy Mythology contains almost all the learning of which the subject is susceptible) speaks in the following terms of the fairy-folk of Ireland.


"The Fairies of green Erin present few points of dissimilarity to those of England and Scotland. They are of diminutive stature, but do not appear to have any fixed standard of height; perhaps



---

p.35




eighteen inches might with tolerable safety be assigned as their average altitudes. A woman from the county of Kerry lately told us that she saw the fairies when she was a little girl. She said she and some other children were one day returning from school, and they saw the fairies scudding like the wind over a big field on the road side, and tumbling head over heels into a hollow at the end of it, where they disappeared. Some of them were as high as castles, others were little dony things, not half so big as the children themselves.


"In the north of Ireland the proportions of the fairies are very minute, approaching to those of Titania's 'small elves,' as will appear from the following established mode of the fairies of that part of Ireland, making their stolen entrance into the houses of mortals. A fairy, the Diavolo Antonio we may suppose of the party, is selected, who contrives to ascend to the keyhole of the door, carrying with him a piece of thread or twine. With this he descends on the inside, where he fastens it firmly to the floor, or some part of the furniture. Those without then 'haul



---

p.36




taught and belay,' and when it is fast, they prepare to march along this their perilous Al-Sirat, leading to the paradise of pantry or parlour, in this order; — the fairy-piper first steps up, and in measured pace pursues his adventurous route, playing might and main an invigorating elfin-march, or other spirit-stirring air; then one by one the rest of the train mount the cord and follow his steps. Like the old Romans, in their triumphal processions, they pass beneath the lofty arch of the keyhole, and move down along the other side. Lightly, one by one, they then jump down on the floor, to hold their revels or accomplish their thefts."


The Irish fairies, we have seen, are not greatly dissimilar to those of England and Scotland; and these were far from being universally of a grotesque and comical order. In each of the three countries, the fairy-folk may be divided into two classes — the rural elves, inhabiting the woods, fields, mountains, and caverns; and the domestic or house-spirits, called hobgoblins and Robin Goodfellows. Of the former sort are the exquisite



---

p.37



beings of the "Midsummer Night's Dream;" whilst the "lubbar fiend" of Milton's "L' Allegro" belongs to the latter. **Spenser**, as Dr. Johnson has finely observed, "is the first poet who has made the fairies great." He has given them the form and size of human beings, and conferred upon them more than human virtue. Allan Cunningham, in his pleasant traditionary notes to Sir Egerton Brydges' edition of Milton's Comus, says of the *popular fairies —*  "They are an elegant and accomplished race; they dwell in palaces under secluded hills; they frequent, when the summer moon is up, the lonely stream banks; they spread tables sometimes in desert places; and astonish and refresh the benighted and hungry traveller with spiced cakes and perfumed wine; nor do they hesitate to mount their steeds — an elfin race; and, accompanied by music from invisible instruments, ride through the lonely villages at midnight, less to the alarm than the delight of the inhabitants."


If the reader should desire to know more of a race of beings respecting whom some of the 


---

p.38




greatest of poets have written some of their most exquisite poetry, I would refer him (among other things) to **Sir Walter Scott**'s Essay On the Fairies of Popular Superstition —  to the learned and most interesting preface to the last edition of Warton's History of English Poetry (1824) to the work of **Mr. Keightley**, above cited — and to a series of elegant papers in Leigh Hunt's London Journal. Let me now beg him to descend with me from the Croghan Hill, and give me his attention on subjects of a much more common-place, but infinitely more important interest.


Philipstown obtained its name from Philip (husband of Mary, Queen of England), who once visited it; the county (King's county) owes its name to the same event. The town is well built, and was formerly a place of note. It contains a capital Court-house and Prison, a large Catholic chapel, and a small Protestant church. The Grand Canal, on which two passage-boats ply daily between Dublin and the Shannon harbour, adjoins the town. Previously to the Union, Philipstown returned two members to parliament, and was a


---

p.39




place of considerable trade. Lamentably, however, are things changed now. It is robbed of its representatives — the assizes are removed to Tullamoore — its trade has disappeared — many of its houses are in ruins — its shops are falling into decay — and its population, as these signs sufficiently indicate, are poor and wretched. Although surrounded by miles of unreclaimed bog land, its inhabitants wander about the streets in search of employment, and find none. Nor is the desolation confined to the town. In a walk along the bog towards Dublin, we observed the roofless walls of a superb mansion, formerly the residence of Henry Lyons, Esq., one of the representatives of the county.


There are several places which bear the name of Inns or Hotels. We took up our abode at the south end of the town, at an hotel kept by Mrs. Ellis, the post-mistress. Here — after sufficient time to procure tea and coffee from Dublin had elapsed — we lived very comfortably; regaling ourselves in the meantime with excellent cream and eggs, and a joint, occasionally, of good beef


---

p.40




or mutton. The chickens, like the generality of Irish poultry, were half starved.


My bed-room was part of the Barristers' dining-room, in the palmy days of Philipstown: the sitting-room which we occupied, looked out upon the street, and the windows were frequently crowded with miserable women, carrying children upon their backs, and soliciting charity with pitiful lamentations. To relieve all was impossible — and to relieve only a few increased the number of those who begged. Under such distressing circumstances, my consolation was, that I was engaged in preparing a full and honest statement of their wretched condition, with a view to the introduction of legislative measures of relief.




---

p.41


Examination at Philipstown — Want of employment — Idleness of the people — Bedding — "Handy-Down" — Conacre — Deficient payment of rents — Average size of farms — A question as to emigration — General remarks on the state of Ireland, as respects the population and employment — Tenant-right — Non-resident landlords — Agriculture — Wealth of the beggars — The cabin of Barney Mangin — Reckless despair of a farmer — Michael Madden's plot of cultivated bog land — George Rait's farm, and system of agriculture — Remarks on the people near Philipstown — Cruelties connected with the taking of farms — The people of Tipperary — White Boys — Oak Boys — Blackfeet, Whitefeet, Terry Alts, &c., &c.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Our examination began in the Court-house on the 16th of November. Here, as in the other baronies we found a superabundant population — for the most part, as a matter of course, unemployed, and the wages earned by those who were sometimes fortunate enough to get work, varying from 3d. to 7d. a day, sometimes with, and sometimes without, diet. Between potato time and harvest the distress is general, and very great; and in consequence of



---

p.42




it, fevers are prevalent. Many of the witnesses expressed a willingness to work, and declared that it was not the amount of wages they cared so much about, but employment. The children are never employed till fourteen or fifteen years of age, and then victuals is all they get for their labour.


Milk is a luxury here. Sergeant Malone informed us, that many a man who sends his milk to the town, eats his potatoes without any; and he knew one man who had only three pints of milk in the year. The distress is considerably greater than it used to be, and was stated by more than one of the witnesses to be the chief cause of crime and mischief. The jail allowance is 9lbs. of potatoes, one pint of milk, and one pint of buttermilk per day. Young men of from sixteen to thirty years of age (called almost invariably "boys") earn from thirty to forty shillings a year as farmers' servants; and these, though half naked and half starved, are far better off than the mere labourers, who are often in debt, to the amount of nine or ten pounds. Some of the labourers are,



---

p.43




however, naturally idle and averse to work. "If it were advertised," said the Rev. Mr. Hamilton, "that a cricket was to walk across the street, crowds would collect to see it."


The poor people are sadly off for bedding; they can scarcely, in fact, be in a worse condition. A family of six or seven have usually nothing but a blanket and a half to cover them; straw, for the most part, composes their bed — sometimes the bare floor. The clothes which they wear in the day serve them for the night also, for they have no change.


The dress of the labourers is what is called a "Handy Down, or outside shade," which costs 5s., or a soldier's old coat turned. To clothe a labourer in frieze, would cost twenty or thirty shillings a year; some of them possess a frieze coat for Sundays, but the generality (to use the words of a witness) "have not a stitch but what they have on their bones."


Conacre prevails to a considerable extent about Philipstown. Manured land is charged £5 per acre, and, when seeded, £8, and will produce ten



---

p.44



or twelve barrels (of 24 stones) per rood. The high price of conacre is accounted for by the great numbers of applicants for it, and the reason that some small farmers let it, is, that they have not capital enough to sow the whole of their farms. They are in fact so poor, that there is not half a year's rent in the hands of any one of them in the barony. Good wheat was selling for 15s. a barrel (of 20 stones) — from five to seven barrels being the produce of an acre; — yet in the event of a farm becoming vacant, great numbers, who had proved themselves unable to make their own succeed, would bid for it, and lives probably be lost in consequence. The successful competitor knows, that though he lives on "lumpers" alone, he is sure of having a home; hence the opposition to a new comer. A witness told us that he knew a person who had got a guinea for shooting one of these unfortunate tenants.


Rents are seldom paid up — a portion generally remaining due. In bad years, no remission of rent is conceded; and when good years come, all is swallowed up, and the accumulation of capital 



---

p.45



is accordingly prevented. These nominal arrears were stated by a witness named Odlum, a gentleman of considerable property and experience, to present a formidable obstacle to industry — to be, in fact, "a chain round the farmer's neck." It seemed to be a general opinion, that if the tenant were relieved from tithe or cess in form, the landlord would add the amount to the rent. The cess is about one-seventh of the rent, the tithe 1s. 4d. the acre. The former is laid without reference to the quality of the land, and at an inconvenient season.


The farms average from fifteen to thirty acres; some are as small as three. A farm of 100 acres, managed by ten farmers, or, in other words, divided into as many farms, would produce more, it was stated, than if in the hands of one man.


The rent of good arable land is 25s. the acre: the thin land fetches from ten to fifteen shillings; and bog, when improved, from fourteen to fifteen. Previous to the last year, great numbers emigrated, many taking with them their families; yet, in King's county alone, according to Mr. Odlum,



---

p.46




who is well acquainted with it, there is as much bog land as would maintain a million of men; and by devoting three or four acres to a labourer, thus supplying him with a home, and providing a stimulus to industry, the surplus population would be diminished, without recourse being had to so summary a measure as emigration. Indeed, it may reasonably be asked what right we have to send multitudes from their native land, when so many thousands and tens of thousands of acres of reclaimable bog exist — not only capable of cultivation, but capable of repaying it, labour being the only capital required. It is absolute folly not to keep them in the country; and the money that would be spent in carrying them out of it, might be well applied in assisting them to prosecute their improvements.


According to the reports of the Commissioners, there are no fewer than 585,000 labourers in Ireland, who are out of work thirty weeks in the year, and in a state of utter destitution. The bogs and reclaimable land are computed at five millions of acres; therefore, as stated above, three



---

p.47



or four acres might be allotted to each labourer, still leaving a surplus of waste unoccupied land. If a little capital could be advanced (far less in amount than the expense of taking them to America) for supplying them with seed or lime, the labourers would eagerly provide the labour, and pay a high rate of interest for the capital so advanced. But supposing — for it may be thus objected — that the proposed system has a tendency to increase the population in a greater ratio than under the present state of things (a supposition, by the way, which neither history nor facts warrant), there would still remain a considerable extent of unappropriated land; in addition to which, the land now under cultivation, if cultivated to advantage, would bear double the number of labourers that are at present engaged upon it. In the meantime, who can say what demand may not arise for labour in manufactures, mines, and other sources now unknown; sources from which capital is withheld, only because of the distracted state of the country, arising almost exclusively out of the want of employment. If the labourers


---

p.48




were properly and systematically employed, they would, instead of confining themselves to the bare necessaries of life, require conveniences which are at present beyond their reach; their sons, accordingly, would become tailors, shoemakers, carpenters, blacksmiths, machine-makers, shopkeepers — and, in course of time, manufacturers, merchants, &c. Employment being general, the cause of agitation — at least one of the main causes — would be removed, and capital would find a safe investment in every branch of industry. To effect this desirable result, education is lending its powerful aid. To say nothing of the cruelty of obliging emigration, it is, if not a foolish, certainly a very unnecessary alternative, admitting the accuracy of the statements of experienced men in all the baronies examined, that more produce is raised on small farms than on large ones, that more rent is paid, and that the sum spent in assisting a man to emigrate would set him up in a small farm, and fit him to become a producer and contributor to the wealth of Ireland.


The object of manufactures of all kinds is to



---

p.49



produce as much as possible at the least expense; and with the above facts before me, I am unable to see how the country can be benefitted by the practice, now unfortunately too generally adopted, of consolidating small farms. If the small farmers (who are far more tractable than the same class in England) were instructed in agriculture, and a trifling assistance afforded them, the natural consequence of their increased knowledge and capital would be the enlargement of their farms. This would gradually create a demand for the five millions of acres of waste land, and probably for a reduction of some of the extravagantly large farms. To those commencing, small portions of bog and mountain should be allotted — for the purpose not only of stimulating their exertions, but of giving them an interest in maintaining the peace and order of their country. Employment would thus be afforded to their wives and families, an employment infinitely more lucrative and respectable than that of begging; and one of the greatest of Irish nuisances would accordingly be abated. Small farmers, I am persuaded, would augment the 



---

p.49




capital and riches of Ireland; they would certainly contribute to the employment and independence of her people. The more a country advances in knowledge and civilization, the greater is invariably the number of those whom it is capable of maintaining; and all who wish well to their fellow beings, will promote to the utmost of their power the diffusion of education, by which alone, under the blessing of Providence, these vast advantages can be secured.


Two or three pounds per acre is the usual price paid for tenant-right in this barony: and it is common to give seven or eight pounds for a small quantity of land, for the convenience of a home. Scarcely a landlord or agent is resident here; and it was the opinion of those who were competent to form a correct judgment on the subject, that tenants of absentee landlords are considerably worse off than those living under landlords who are resident. The lower orders in particular feel the benefit of resident landlords; and the farmers complain, not only that in the absence of both principal and agent, they receive no thanks for



---

p.51




any improvements they make, but that they are deprived of the advantages to be derived from example and advice. "The landlord and tenant," said Mr. Odlum, whom I have had occasion to mention before, "should be like father and son; the tenant ought to be hung who would not take his landlord on his back, and carry him through."


The land is principally in tillage, is greatly impoverished, and is much more frequently ploughed than formerly. On the borders of Croghan Hill, oats are sown for five or six years in succession; Mr. Morgan and Mr. Scully, two landlords in the neighbourhood, have adopted rape and turnips. The small farmers have often from one to six well-bred sheep, whose wool supplies them with their frieze clothes. The women spin it, and get it woven. The home-made costs 1s. per yard, but when they buy it manufactured they are imposed upon. The wool is worth £1. per stone; that of hoggets, or sheep first shorn, is worth 23s. per stone; the weight of the fleece is from 5 to 6 lbs. From the wetness of the ground, the sheep are subject to the rot. The breed of cattle has improved



---

p.52




of late. A witness of the name of O'Connor has known from £20 to £30 given for superior cows; farmers' cows usually sell at from five to £12. They give ten or twelve quarts of milk a day, after calving; and, if well kept, a hundred pounds of butter in the season.


The beggars in this district are very numerous; they sometimes pass through Philipstown, to the number of three or four hundred a day, are often tipsy, and circulate stories of malicious tendency. They shut up their houses, gamble at cockfights, and occasionally amass, by one means or another, considerable wealth. Mr. Odlum, for instance, knew a beggar who gave his daughter £100. Numbers of the labourers would have no objection to go to a workhouse, but, generally speaking, they would prefer rambling about the country — they get more money by this means than they would in a workhouse, and are of course more at liberty to indulge the propensities which a want of education, idleness, and bad habits, have engendered.


In walking over the bog, we came to a cabin 


---

p.53



occupied by Barney Mangin, the walls of which were cut out of the solid moss. The roof slopes from the front towards the back, which is level with the surface of the moss, as shewn in the end-view annexed. Barney was a miserable, half-starved creature, and lived with his wife and two children in this cabin, paying for it, however, no rent. Window or chimney it had none, and the smoke found its way out at the door, and through the imperfect roof, which consisted of sods and turf. Mangin paid, last year, 20s. for one cwt. of meal on trust, when the market price was only twelve shillings. We visited also Patrick Innis, who has a farm of 40 acres, on an island on the bog, at a rent of 15s. per acre. The soil is six or seven inches deep, on a substratum of stiff clay. He digs in the wheat — that is, he sows it on the surface, and afterwards digs out the furrows to cover it, and has a better crop than if it were harrowed in. The produce is from four to five barrels of wheat, and five barrels of oats per acre. His plough was a very clumsy implement, with a patched wooden mould-board. Innis keeps



---

p.54




five cows; but knows nothing of green crops. He told us that he should be very glad to learn, but had nobody to put him in the way. How valuable to this man, and to thousands such, might one of Blacker's pamphlets on small farms prove! His mother, his wife, and thirteen children, live under his humble roof, and his boys work the farm, and assist in getting turf, of which he sends seven or eight boat-loads in the season to Dublin, by the Grand Canal, which passes close to his farm. The boat-loads are worth seven or £8 each. Tithe he has not paid for the last three years; indeed he declared that he durst not pay it, even if he wished, as his property would be burnt, in the event of his doing so.


About a mile to the south of Philipstown we visited a poor farmer who was employed in winnowing his barley in the wind. Though in rags, he had evidently seen better days. He told us that he had no money, nor indeed had any of the farmers; that the landlords would be obliged to come and manage their farms and hold the plough themselves, as the tenants would soon be destroyed;



---

p.55




and that when he had got home at night, after working hard all day, the only food that awaited his return was a dry potato, or perhaps a herring. He asked us if the looks of the farmers were not sufficient to prove how they lived; and indeed, the blue colour of his countenance, and the attenuated frame of this poor creature, abundantly attested the accuracy of what he was saying. Casting a pitiful look at his rags, he exclaimed, "If I had known what I would have come to, I would have thanked any body to have shot me through the head when I was young." He complained bitterly, among other things, of the unfeeling and arbitrary conduct of the tithe proctors. Far from being an uncommon case of distress, this, I am sorry to say, is but a single instance of general destitution. Some of the wretched sufferers bear their hard destiny with great fortitude;— *this* man's rankled at his heart. Though disposed to labour, and adapted to enterprise, he has no kind landlord to instruct and encourage him; and, hopeless of any remedy for his acute afflictions, he sees nothing



---

p.56




before him but certain destruction, and accordingly gives himself up to bitter despair. Can it be wondered at that men, thus ignorant, degraded, oppressed, and reckless, occasionally disregard the authority of the law, and commit outrages which subject them to its severe inflictions? The wonder would be if they did *not*. The government of a country is greatly responsible for the crimes of the people.


On crossing the bog, we had an opportunity of experiencing the truth of some of the observations in a preceding page. Our attention was attracted by a beautiful green patch in the midst of the brown heather; and, on inquiring, we found it to be a little piece of the waste land which had been cultivated by the industry of Michael Madden. At first, he manured it for potatoes, and had a good crop; he then sowed oats and grass seeds, and had an excellent crop of oats and of hay the following year. Madden said he had derived great advantage from the grass it afterwards produced, in the feeding of his goats. This was done without any outlay of the owner's, and thousands might be



---

p.57




made happy in the same way, if the land-owners would permit the poor famishing wretches to cultivate and improve their bogs, with the locked-up capital-labour. The bright green verdure of this little plot of ground, won from the desert by the exertions of one poor man, was a beautiful sight, and gave rise to gratifying reflections.


We visited the farm of George Rait, which is a large one, a few miles from Philipstown, and belongs to the Hon. William Barrock. Rait and his brother, who also occupies a considerable extent of land, came from Scotland about twenty years ago, and have devoted their time and attention, during the interval, to the prosecution of agriculture, on a system greatly superior to that which generally prevails. The farm contains 1100 acres of good loamy soil, workable in all seasons, with almost a certainty of at least an average crop. The rent is 25s., with a charge for tithe of 1s. 6d., and cess 1s. 66. per acre. The following rotation is adopted — viz., 1st, oats from grass; 2nd, barley, without manure; 3rd, turnips or potatoes, manured; 4th, wheat, sown with equal quantities



---

p.58




of red and white clover, and Pacey's perennial rye-grass. The land is allowed to remain in grass for three years, and the rye-grass to stand for seed; the seed being of more value than the hay. The grass is thrashed, and the seed put up in the middle of a stack well thatched; here. it remains till spring. It is then well dressed, and sold to English seedsmen. The hay, or rather stalks, after the seed is thrashed out, serves for horses and bullocks, and is given along with turnips. The clover seed is sown by a machine which distributes it with much greater equality than it can be done by the hand, and is one of the greatest improvements in agriculture; being simple and cheap, it is within the reach of the small farmer. It consists of a long box with divisions, in which turns a cylinder, having small spoons upon it, the size of which can be adapted, on different cylinders, to the kind of seed and the quantity to be sown. The seed is dropped on an inclined board, nearly reaching to the ground; this board scatters the seed evenly, which is protected from the effect of the wind behind, by a sheet.



---

p.59




This plan of sowing small seeds (so common in Norfolk and some other English counties) I had frequently recommended in Ireland, but had never found it practised, except upon this farm.


George Rait's breeding stock, though not very good, was much superior to Irish stock generally. Many sheep and bullocks were fed on turnips; the feeding cattle were eating turnips, and were allowed to have as many as they pleased. As soon as the potatoes are forked out, and the land harrowed, the cylinder roller is passed over it; this leaves hollows for the wheat, answering the purpose of a drill, and at the same time giving solidity. The wooden Scotch plough, with iron mould board, was used here, but iron ploughs were about to be substituted. The farm servants are allowed a certain quantity of meal and milk, and a room and fire to cook them by. The cost of their victuals was calculated at £10; they have also their lodging provided, and receive £7 in money; the whole cost of each man is therefore £17 a year. Mr. Rait has generally several agricultural pupils, who pay him handsome premiums. 



---

p.60




He informed us that when the Board of Agriculture existed in Ireland, and allowed £4000 a year for premiums, the gentlemen got them all, and the establishment was abandoned in consequence. Several small farmers in the immediate vicinity of George Rait's residence, have evidently profited by his example; but the fact of his improved plans of agriculture having been practised, for a period of twenty years, with but little effect, except within a circuit of three or four miles, affords a lamentable proof of the difficulty of disseminating information on this very interesting and certainly most important subject. In this instance, however, it may be in some degree accounted for by Mr. Rait's farm being so much superior to the generality, as to induce a supposition that it requires a different management from that adopted on the smaller farms.


Before leaving Philipstown let me once more advert to the condition of the people in its neighbourhood. They would work, as I have stated before, for fourpence or sixpence a day, or even less, if they could get it. Their food is of the



---

p.61



poorest description (the coarse potatoes called lumpers) and obtained in quantities barely sufficient to keep the machine of life in languid motion. To use their own words, uttered with great pathos and feeling, — "We are only just kept breathing," — "Our eyes are only just kept open." I have witnessed scenes that would awaken commiseration in the coldest and the hardest heart, and some of these I have endeavoured to describe, faithfully, without the slightest shadow of exaggeration. I have seen young and helpless children, almost naked and without food, exposed to the cruel influences of the weather, in huts which should have afforded them protection; and I have seen old people, afflicted severely by asthmas and rheumatic attacks, lying in hovels without either window or chimney, with nothing for their bed but the bare damp floor, or a thin layer of straw. Can it, I again ask, can it surprise us, when people, habituated to such appalling wretchedness, and instigated by mingled feelings of revenge and despair, commit crimes, at the bare relation of which human nature shudders?



---

p.62




The Irish are a patient, as well as an oppressed people, or they would not have submitted so long to the hardships they endure.


King's county has been the scene of many cruelties. A man taking a farm, from which another has been ejected, will probably find his horses without ears, or otherwise maimed, and his cattle houghed, that is, the sinews of the hinder legs cut. A grave dug near his house, with a note in it, is considered a friendly mode of warning him of his danger. If these do not produce the desired effect, they set fire to his house, or shoot him; and cruelty has been carried to such excess, that whilst the house was burning, the inhabitants have been kept in by monsters armed with pitchforks.


The inhabitants of the adjoining county of Tipperary have been considered the most ferocious, but there was no disturbance at the time I visited it; indeed, I considered myself as safe in any part of the country as in England. It is only under an impression of a sense of deep injury that the people seek revenge.




---

p.63


The White Boys had their origin in Tipperary, and combined in consequence of some inclosures of commons. They then attacked the tithe proctors, and gained such strength as to presume to redress grievances of every description. **Arthur Young** informs us that they were not heard of till 1760, and that no foreign interposition could be blamed for the formation of the association. He states that one of the usual barbarities was, taking people out of their beds, carrying them, in winter, naked on horseback, and burying them up to the chin in a hole filled with briars, not forgetting to cut off one of their ears. The evil existed eight or ten years. The Oak Boys, and Heart of Steel Boys, are said to have had their origin also in the rise of rents, and in the inequality and oppressiveness of the county-cesses.


According to the information of Sergeant Malone, the several designations of Terry Alts, Blackfeet, Whitefeet, Cummins and Daraghs, have arisen out of trifling circumstances attending the first formation of these bodies. "Terry



---

p.64




Alt" was an old soldier, whose name was made use of, without his authority, in some threatening notices. Blackfeet and Whitefeet are said to have originated in a dispute between the owners of two horses — one of which had white, the other black feet. Each collected his own friends, who at length expanded into two political parties. They have private symbols, and their committees are sworn to secrecy. Both concur in their opposition to law and tithe; but, disagreeing on some matters not generally known, variance continues to be perpetuated between them. These parties have faction-fights at fairs; and young men, such as respectable farmers, are their secret leaders. The Cummins and Daraghs, two families on the border of King's county and Tipperary, quarrelled, and each collected a party, which was in the habit of disturbing every market and fair. They too have secret symbols. Most of the nightly depredations and murders proceeded from these parties. The quarrels are chiefly confined to Catholics — religious differences having nothing whatever to do with them. Taking a district of twenty miles



---

p.65




round Philipstown, not more than eight or nine Protestants have been murdered in affrays connected with religion, during the last fourteen years — and no Catholics have been murdered by Protestants. The proportion of the former to the latter is about twenty to one. The Protestants, being few in number, are obliging and quiet.




---

p.66


Edenderry — Protestant opinion of schools — Catholics and Protestants — The Marquis of Downshire's silk-worms — Father Mullens — Mount Mellick — The Ballycommon and Mount Lucas bogs — Hints to the Company for the improvement of waste lands — Lancashire mosses — Departure from Philipstown — Tullamoore — Grand Canal — Banagher — Holy Island in Scariff Bay — Portumna — The Shannon — Killaloe — Limerick — Description of the city — Dr. John Jebb — Estates of the Earl of Dunraven — Carragh.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


On the 15th of November I mounted a car and went to Edenderry, nine miles from Philipstown, on the road to Dublin — a small neat town belonging to the Marquis of Downshire. A considerable portion of the inhabitants are members of the Society of Friends. The Honourable Mr. Cooley has property, worth three or four thousand a year, in the neighbourhood. Here we saw a Protestant school-house, erected and supported by that gentleman; it is attended also by several Catholic children.



---

p.67



The Protestant bible is of course one of the school-books. Mr. Cooley is a good landlord, and makes allowances to his tenants in a bad year; he also supplies them with clover seed. Viscount Halberton, his brother, the proprietor of Carberry castle, has also three or four thousand a year here, and is a good landlord into the bargain; he makes allowances for improvements and draining. A new Government school-house was in course of building; but the friend who kindly drove me about the neighbourhood in his car, informed me that the Protestants would not send their children to it, that they thought schools were already sufficiently numerous, and that the Catholics would accordingly have it all their own way.


The Catholics and Protestants do not appear quite so sociable here as in some other places. A notion seems to prevail, that the former are endeavouring to make proselytes. It was stated moreover, that the Protestants consider the Catholics indifferent about going to chapel, not only on account of being unable to derive any benefit



---

p.68




from the Latin service, but because they otherwise receive no religious instructions from the priest. If they happen (we were told) to arrive at the chapel before the service closes, they think it enough; and in the afternoon they play at football and other games — pretending, at the same time, to have great faith in saints and priests. Such were the stories related to us. My own observations induce me to believe that the Catholics are orderly, regular, and punctual, in their attendance on divine worship; I have frequently seen numerous congregations both going and returning; and whenever I entered the chapel on other days than the Sabbath, I invariably found numbers at their devotions. This certainly does not savour of indifference.


A few years ago, silver mines were partially worked on the property of the Marquis of Downshire, near the old castle. The Marquis also planted a field of mulberry trees near the town, with an intention of raising silk worms, and introducing the silk manufactory. I went to examine the ground, but not a vestige of the trees could be



---

p.69




traced, although the land is of excellent quality. From what I could learn, the soil had not been properly prepared, and the mulberry trees wanted protection from the wind by the previous planting of hardy forest trees. Here, as well as in the county of Down, the Marquis has the character of being a good landlord. It is delightful to see the comfortable cottages he has provided for the poor of Edenderry, with small gardens in front, and shrubs behind, and neatly painted doors and windows. They stand in one of the cross streets of the town, and the tenants pay merely a trifling acknowledgment as rent. His lordship's property may generally be known by the neatness of the buildings, and the taste displayed in the little praiseworthy decorations which give an air of comfort and cheerfulness.


In the course of my walks I passed through the Roman Catholic grave-yard of Killaderry, which contains the tomb of "Father Mullens," of Philipstown. The inscription is "Andrea Mullen, Juvenit, 1818, aged 28." I was informed, at Philipstown, that he was a most benevolent and charitable



---

p.70




man, and sacrificed his own comfort and health to the good of others. He has been often known to strip off his coat and shirt, and give them to those who had none. His death was occasioned by a cold taken in consequence of a charitable act of this sort. His grave is held in great veneration, and is resorted to by the lame and diseased, who frequently lie all night on the ground, under the tombstone, and mix milk, which they bring in a bottle, with the soil of the grave, and drink it. It is supposed to possess a miraculous power of healing and making whole. Many shreds of the garments of those who had visited the tomb, were hung upon small bent sticks at the foot of the grave, in commemoration of their having been cured. In many of the chapel yards, I may observe, garlands of white paper are suspended over the graves of young persons, and left to perish with the weather; and wooden crosses, bearing a written or printed inscription to the following effect, — "Pray for the soul of — —" are commonly met with. In Galway these crosses are very numerous. At Philipstown I saw the mother



---

p.71




of Father Mullens; she, too, is held in profound veneration. After the death of her son, she cut his clothes into small pieces, and disposed of them as relics. The speculation is said to have been a profitable one.


The ride from Philipstown to Mount Mellick in Queen's county (a distance of fourteen miles) is uncommonly dreary — not a tree is to be seen, except a cluster of poor Scotch firs, bent by the unobstructed blast; and much of the land is poor and exhausted, not worth more than 10s. an acre. The roads were excessively bad, and in many places nearly impassable to that most abominable of all conveyances, on bad roads and in stormy weather, an Irish jaunting-car. As we approached Mount Mellick, the appearance of the country improved, and I had the pleasure of seeing one cottage that reminded me of England — it was ornamented with nasturtions and hollyhocks. The Slieve Bloom Mountains to the west of Mount Mellick present interesting outlines, and relieve the monotony of the dreary scene. The population of Mount Mellick is short of 5000, the Protestants and Catholics



---

p.72




being about equally divided. There is a Dispensary, a Protestant and Catholic School, but no public Library, though the Friends have a Book Society. The town is neatly built, and paved with beautiful limestone, or rather dove-coloured marble with white veins — brought, I suppose, from the Slieve Bloom Mountains. Mount Mellick possesses extensive breweries, and is a place of considerable trade. Mr. Power, who attended here as the English Commissioner, remarked to me that the Quakers had contributed to the prosperity of the country, and that he found wherever they had been settled they had uniformly done good, by promoting cleanliness, order, and sobriety.


The Ballycommon and Mount Lucas bogs, near Philipstown, contain nearly 10,000 acres, no part of which exceeds five miles from the town. Nearly half the county is bog. This might be easily cultivated, and rendered very productive, particularly of tares, rape, turnips, and other green crops. It lies sufficiently high for complete drainage, and has a substratum of limestone, gravel, and clay, well fitted to consolidate the surface. The Grand



---

p.73




Canal provides the means of bringing manure from Dublin, and for conveying the produce to market at a cheap rate.


The Incorporation of the Company for the improvement of waste lands, it is hoped, will be of essential use to Ireland. They would do well to commence by draining the bogs, and giving them a cover of clay, marl, or gravel, by means of a moveable railway, and leave the remaining operations to be executed by the small farmers, providing them, in the first instance, with a little manure and proper implements, at the same time opening an account with them on Mr. Blacker's principle. Some bog land in Lancashire, in the enclosure and cultivation of which I was engaged, though certainly not superior to a great portion of the bog of Allen, produces in some seasons as much as 55 bushels of good oats per acre. This peat moss, called bog in Ireland, in those parts where the surface had been dug off for fuel, was let at from 20s. to 25s. per acre. Where the improvement had proceeded no further than the cutting of the main drains, and the tenant had to clay or marl it, and break up



---

p.74




the natural surface, the price for a term of seven or nine years was from 4s. to 5s. per acre per annum; that which had been in cultivation for several years brought a rent of eight or nine shillings. This peat moss is situated in a part of the country where manure is not easily obtained, and the farmers are accordingly in the practice of spreading clay on the surface, then paring the land, and burning the clay and the parings together. Some has undergone the process of burning for forty years, but this is considered injurious, though the land still produces fair crops. The marl and clay lie at various depths of from 6 to 20 feet below the surface. Part of this moss was marled by means of a moveable railway, with small wagons carrying 17 cubic feet of marl, moved by two men each. The sand for the roads was also conveyed by means of the same wagons. One mile of railway, with sixteen wagons all complete for use, cost £400. The moss was too soft for horses to be used for drawing the wagons, even with the Lancashire pattens, and men were substituted, as a matter of necessity; but in Ireland



---

p.75



they would be preferable for other obvious reasons. On Chat Moss near Manchester, where manure, as well as marl, can be had at a reasonable price, the finest crops of potatoes, wheat, oats, and clover, were produced under the judicious and skilful management of my friend Mr. Reed, by reducing the sod, in the first instance, by pulverization, without burning, and the application of marl and manure. In the cultivation of Irish bogs, and other waste land, it would be most desirable to make large plantations; trees will not only prove advantageous for shelter, but in a short time will supply poles for cabins, fences, and railroads. Quick growing wood, such as larch, poplar, alder, willow, Scotch fir, and birch, ought to be intermixed with the more valuable though slower-growing ones, oak, ash, Spanish chesnut, elm, sycamore, and beech. On the drier land, the larch is more valuable as a nurse, and because it supplies a quick return. Wood is extremely scarce in Ireland, and taking into account the congeniality of the soil and climate to its growth, the increasing demand for it, and that so much 



---

p.76




waste land invites the attention of men of capital, it is surprising that planting, which would improve the climate, should not be a more favourite employment amongst the landed proprietors.


On the 25th of November I bade a final farewell to Philipstown, and embarked in the swift boat which plies between Dublin and the Shannon. That evening, however, I proceeded no farther than Tullamoore, a distance of seven miles only, the fare for which was ninepence. The packet was spacious and conveniently fitted up, and drawn by three horses. I alighted at a spacious inn belonging to the Canal Company, and kept by Miss Purcil. The lateness of the day admitted of my seeing but little of the town. The Court-house is on a scale of considerable magnificence. In the centre, six tall Ionic columns support a pediment surmounted by the King's Arms; the floor is approached by a broad flight of steps; the wings are ornamented with elegant pilasters; and the whole building is remarkable for the beauty of its proportions. It is the work of Mr. Murray of Dublin.




---

p.77


The upper streets of Tullamoore are wide, and lined with good houses. The town belongs to Lord Charleville, whose castle is in the immediate vicinity; the grounds surrounding it are said to he highly ornamented. On the banks of the canal are the ruins of Bally Ecouen Castle, and Shragh Castle; the latter erected by Briscoe, one of Queen Elizabeth's officers in 1588. Tullamoore has about 7000 inhabitants, and is a place of considerable trade in grain and linen. It has also a cotton and linen manufactory, two distilleries, two breweries, several water corn-mills, a County Infirmary, and a News-room.


I left Tullamoore for Limerick by the canal horse-boat at two o'clock in the morning. By this canal we pass for a considerable distance over the bog of Allen, some of which near Tullamoore is cultivated, and lets for 25s. per acre. There is an extensive trade in turf, which the numerous long stacks of black turf on the banks evince.


"The Grand Canal," says Mr. Fanning, in his evidence before the Committee of the House of Commons in 1830, "on the line from Dublin to



---

p.78




Shannon harbour, runs through a line of very bad ground; it also runs through bogs, and to a great extent through the bog of Allen. That which was unprofitable ground before the canal was cut, has now become ground of excellent tillage, occupied by very comfortable farmers. The bog that was quite impassable, called wet bog, has now become great part of it pasture land, and there is considerable improvement in other parts. That improvement has been effected by the drainage produced by the canal, and by the facilities afforded for transit by its navigation. The effect on the bogs near Robertstown, was a subsiding of from thirty to thirty-five feet, and that portion of it immediately in the vicinity of Robertstown, originally valued (to the undertakers of the canal) at one farthing per acre, is now let for tillage at from 30s. to 40s. per acre."


At the ancient town of Banagher a stone bridge of eighteen arches crosses the Shannon, which we entered at Shannon Harbour: and three or four miles below the town, and at the point where the Birr river falls into the Shannon, are two towers



---

p.79




and a battery, on the Galway side, erected for the protection of that mighty stream. Here, too, a stake in the river marks the spot at which the provinces of Connaught, Leinster, and Munster, unite.


The Pillar Tower and chapels on Holy Island in Scariff Bay are interesting objects. The tower appears to be of one diameter throughout, and its height is computed at 70 feet. The ruined chapels are said to be seven in number. The island contains about 56 acres, and is remarkable for its fertility and continual verdure.


Portumna is a place of considerable trade, and some of the best land lets for £5 an acre. The Shannon, which here extends into a noble sheet of water, is crossed by a wooden bridge of twelve arches, designed by S. Cox, of Boston in America. As we dashed through its foamy waters, and passed rapidly along its diversified shores and rocky islands, we felt the propriety of the terms applied by **Inglis** to this, the largest of British rivers. It is indeed "a river of billows — a river of dark mementos!" Here, adorned



---

p.80





with verdant pastures and waving woods, and broken into numberless bays and inlets — there, crowded with picturesque ruins, speaking with a voice of awful import to the Present from the Past — its banks present a succession of objects of varied and untiring interest. The weather, though unsettled, was propitious. Sometimes the sky became dark with clouds, and poured down its rain in considerable quantities; at others, the clear blue of the heavens spread sweetly above us, and the sun shone out with gladdening brightness. The thin mists, too, that flew wildly through the air, added grandeur to the gloomy mountains of Tipperary. Greatly as I had heard the Shannon extolled, the reality infinitely exceeded my expectations.


It was evening before we arrived at Killaloe, which is in the county of Clare, on the western bank of the river, and built in a commanding situation. The Shannon is here spanned by a bridge of nineteen arches. There is a fine salmon and eel fishery in the neighbourhood. The cathedral is small, but venerable from its antiquity, having



---

p.81



been built nearly seven hundred years. The bishop has a handsome residence, situated in a rich and beautiful domain, close to the town. Killaloe became a bishopric early in the fifth century.


After encountering considerable annoyance and danger at the rapids, in consequence of a storm that nearly overpowered the horses by which our boat was drawn, we reached Limerick at ten o'clock at night; and in company with two clergymen, who had come to attend an ordination on the following day, I took up my abode at the Clare Hotel. Here we found several other clergymen, brought together on the same business. Limerick is accounted the third city of importance in Ireland, and is indebted for much of its prosperity to the munificent exertions of the Rt. Hon. Spring Rice, Chancellor of the Exchequer. Its population is about 67,000, of whom one half are Protestants.


Limerick, like Edinburgh, consists of the old and new town; in the former, the streets are so narrow that persons may shake hands across them from the projecting upper-stories of the houses,



---

p.82




and so extremely filthy, that the stranger who happens to enter them once, will have no desire to visit them a second time. The abodes of the poor in these districts are distinguished by the most terrible wretchedness, and the poor themselves are reduced to a state of more than ordinary destitution. The new town is well built, and contains some good streets and private houses, and some excellent shops. Limerick bears every appearance of being, as it is, an improving place. A beautiful new bridge, consisting of five arches (of 70 feet span each) and designed by the justly celebrated **Alexander Nimmo**, has been lately built across the Shannon — and a new dock, by which the trade of the city will be very materially augmented, is projected. The exports of Limerick consist principally of grain and butter; the manufactures are woollen, linen, paper, and gloves.


Among the curiosities of the place, the Cathedral lays claim to particular notice. The original cathedral is said to have been founded in the sixth century, by St. Munchin, and was destroyed by the Danes. The present building rises from amidst



---

p.83



old ruined houses, is black and of unsightly exterior, and exhibited, when I saw it, a great number of broken windows. In the new town, among the ornamental grounds which occupy the centre of a spacious square, stands a statue of Mr. Spring Rice, upon a fluted column. For some time I was at a loss to know what the Right Hon. gentleman held in his hand, nor am I sure that if I had not been informed, I should have discovered it to be a hat. With the exception of this awkward appendage, the figure appears to be creditably executed; I say nothing of the gigantic proportions of the statue; for though Mr. Spring Rice is in reality not a large man, it is only charitable to assume that the good people of Limerick may have adopted this peculiar method of expressing the herculean character of his exertions in their behalf.[18](javascript:footNote('E830001-002/note018.html'))


Limerick possesses a Lunatic Asylum, conducted on the best principles, and established on an extensive scale; and a Hospital built at the 



---

p.84




expense of Sir Joseph Barrington, and known by the name of "Barrington's Hospital."


No one who feels any regard for the character of a pious, learned, indefatigable, and peaceable minister of the gospel, can visit Limerick without remembering that it was for some years the residence of Dr. John Jebb, bishop of the diocese. This prelate, whose amiable virtues endeared him to men of all parties, was consecrated Bishop of Limerick in January 1823. By his own parishioners, Romanists and all, says one who venerated his name, the event was hailed with exultation. On his return to Abington, of which place he was the beloved minister, he was met on the borders of the parish by a multitude of the peasantry, who took the horses from his carriage, and drew him in triumph to the glebe. And, there, a still more striking testimonial awaited him. He was presented with an affectionate address from the Roman Catholics of Abington, drawn up by their own pastor, and with his signature at its head.[19](javascript:footNote('E830001-002/note019.html')) And towards the close of



---

p.85



the life of this excellent man, when the announcement of his death was hourly expected, the Roman Catholic Priest of the principal chapel in Limerick addressed his congregation in the following words — "I have fifteen thousand poor," said he, "in my parish; let them, and all of us, pray, falling on our knees, for the good bishop of Limerick. None, before, have done as he has for the poor. Never will they have such another benefactor." And what was the key to the influence acquired by this holy prelate over the minds of all persuasions of Christians, all parties of politicians — Did he conciliate their regard by compromising his own principles, and flattering theirs? No such thing. He maintained his Protestant principles in their integrity, and defended them with energy, upon every occasion that demanded such defence; and some of his political sentiments were diametrically opposed to those of the Catholic population which surrounded him. The secret of his influence was this: — he allowed to others the same right of opinion which he asserted for himself: he viewed the Roman Catholic priesthood



---

p.86




as his brethren, associating with them on terms of affectionate intercourse; he looked with an eye of paternal regard upon the poor, and relieved their distresses with a bounteous hand; he was meek and gentle, charitable and courteous, in his demeanour; and though a titled dignitary of a state-preferred church, he knew that with God there is no respect of persons, and, acting upon this knowledge, he scorned to regulate his feelings or his conduct by the narrow prejudices arising out of merely human institutions. Bedell and Jebb are names that may well propitiate the esteem of the most inveterate opponents of Protestanism.


Among other objects of interest in the neighbourhood of Limerick are the beautiful domains of the Earl of Dunraven; and Carragh, the residence of **Sir Aubrey de Vere**. Within the former are the ruins of the ancient castle of the Earls of Desmond, a name connected with one of the most gallant of England's poets, the unfortunate Earl of Surrey, and the far-famed object of his affection, the lady Geraldine. Carragh is said to be a 


---

p.87




delightful spot, but I had not an opportunity of seeing it. **Sir Aubrey de Vere** is a man of refined taste, and considerable literary reputation.




---

p.88


Tarbert — Noticeable objects on the Shannon — Mount Trenchard — Droves of fattened pigs detained by the storm — View from near Tarbert House — Trade of Tarbert — State of the people in Lower Conello — Cabins, fuel, and clothing — Emigration — Middlemen — Prices of provisions — Blood of calves — Revengeful feelings of the peasantry, connected with the taking of land — Cabins — Conacre — The golden vein — Rent of land about Tarbert — Fuel — Mr. Maxwell Blacker — Lislactin Abbey — Listowel — Catholic devotees — Irish fights — Lixna Castle — Sir William Petty — Abbey O'Dorney — Tralee — The funeral cry — Ballyseedy — James O'Connell's estate — Castle Island — Arrival at Killarney.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


From Limerick I went by steamer down the Shannon as far as Tarbert (situated at the north western corner of the county of Limerick), a distance of thirty-six miles, the fare being three shillings. After leaving the former place, the river gradually expands into a magnificent stream, its banks abounding with modern villas, old castles, and a variety of interesting objects that demand



---

p.89




the constant attention of the stranger. We passed Mount Trenchard, the seat of Mr. Spring Rice, an old-fashioned building of no great beauty, but finely situated; Aghenish Point, formerly a place of security for robbers and smugglers, but battered down by cannon; Patrick's Hill, on which are ruins and a burial-ground; and the romantic village of Glyn, and Glyn Castle, belonging to the Knight of Glyn, Sir John Fitzgerald, whose estate here is said to be worth £4000 per annum. This estate was defended by a former Knight of Glyn against **Sir George Carew** in 1600, and its garrison put to the sword.


Opposite to Askeaton River, the Shannon, on the Clare side, expands into a large lake or bay, into which the waters of the Fergus, after leaving Ennis, and flowing in a southern direction, empty themselves. The bay averages three or four miles in width, and is interspersed with islands. Near Tarbert, the Shannon contracts to about the width of a mile, and forms a very safe anchorage; the building of a pier in this bay was contemplated some time ago.




---

p.90


We landed on the north side of the Shannon amongst a drove of fattened pigs, which had been detained three days in consequence of the storm. They were in a pitiful condition; many of them could not stand, others walked on three legs, and all night long we were disturbed at the inn at Tarbert by the dismal screams of the poor animals, who adopted this vociferous method of lamenting the loss of their warm beds and comfortable meals, and of protesting against the uncivil proceedings of the people who loaded them on their flat carts, tying their legs to each end of the conveyances. The smell, the dirt, and the horrible noise, of this immense herd of swine, formed a sad drawback to the pleasure prepared for us in the romantic scenery of the Shannon.


I lost no time in making myself acquainted with the neighbourhood. I first walked to the church, a small structure on the hill, and afterwards through the town to an eminence near Tarbert House (the delightful residence of Mrs. Leslie), from whence I had a fine view of the lower part of the Shannon, expanding towards the west, and entering the sea




---

p.91




between the counties of Kerry and Clare. From another eminence, many islands are visible; — among these is Iniscattery, containing a Round Tower. I had now seen this great river from Athlone to near its junction with the Atlantic, a distance of 125 miles. For a considerable portion of this distance I was tossed upon its billows amongst wild and rugged mountains; but I had also the pleasure of gliding smoothly on its silvery and glassy waters, and of witnessing its verdant and sunny valleys, its lawns and woods, its ivied castles, and its shadowy and calm retreats.


From Tarbert there is a considerable export of grain, 3,000 stones per day being sent to Limerick, and seven or eight hundred pigs are sent every week, during the season, from Kerry to Limerick, by way of Tarbert. The harbour is very safe, and is well adapted for trade. The population is scarcely 1000.


In the barony of Lower Conello, in which Tarbert is situated, the principal food of the peasantry is potatoes; they sometimes have milk, never meat. Their eggs they sell, to buy soap and tobacco;



---

p.92



they eat herrings in winter, but the quantity a labourer can procure, depends, of course, upon his employment. When work is scarce, they do not obtain more than two meals a day. Here, as in other places, as I have stated before, in seasons of distress the labourer buys potatoes from the small farmer, and pays probably 50 per cent above the market price. When the stock of old potatoes is consumed, the young potatoes are eaten long before they are healthy food; and the consequence is, a prevalence of disease. Crime, in this district, is often, according to the testimony of several witnesses examined by the Assistant Commissioners, the consequence of distress: the people become reckless. Mr. Royal stated before the Assistant Commissioners, that he knew men who had committed petty thefts for the sole purpose of being transported.


According to the testimony of Messrs. Shire, Deely, and others, the cabins in this barony are in a wretched condition; the floors, which are of earth, being full of holes, and, after rain, exceedingly wet. They are, however, improved within



---

p.93



the last ten years, but certainly not within the last five. The poor suffer most severely from the want of fuel and night clothing, such as bedding and blankets. As for fuel, there is but little wood left in the hedges, so generally has it been pilfered in scarce times. The labourers occasionally gather sheep's dung, and burn it.


During the last five years, emigration has been carried on to a considerable extent. About 300 went out of this barony in 1834. They consisted of a few large farmers, many small occupiers, and a great many labourers, and were for the most part good industrious men. "Last year," said one of the witnesses, Mr. Brown, "a considerable number of Palatines emigrated to America. The Palatines were originally German Protestant settlers, brought, I believe, in Queen Anne's time, and planted in villages in different parts of the country, having leases of land granted to them. They continue to this day distinct from the Irish population around them, living principally in their own hamlets, and not intermarrying with their neighbours." It was the opinion of the same


---

p.94




witness, that one-half the labourers in the barony must be sent away, before 10d. per day, throughout the year, would be found for the remainder.


Middlemen are usually more severe on their tenantry than proprietors, and many instances of conspiracies, on the part of under-tenants, against the middlemen, have lately occurred. The disposition to let to middlemen is, however, decreasing; there are very few landlords now who will give leases with power to sublet. "I do not think," said Mr. Brown, "that middlemen could exist in a good state of connexion between landlord and occupier; they are not liked by either. What forms the profit of the middleman, would, of course, if he were removed, go either in rent to the landlord, or in profit to the tenant."


I may here state, in addition to what was said in a foregoing page, that almost all the surface of the mountains, to the extent perhaps of 20,000 acres, is wet, but susceptible of both draining and tillage. Here is another field for the advantageous employment of human labour.


In the parish of St. Mary's, the property of the 



---

p.95




Earl of Limerick, the poor are in a very distressed condition. I was informed that at least two thousand rose every morning, without knowing how or where to get their breakfasts; at a time, too, when provisions were at the lowest price — wheat being 10d. a stone; oats, from 6 1/2d. to 7d.; barley 7d.; potatoes 2d.; the best beef, from 5d. to 6d. per lb.; inferior beef, from l 1/2d. to 2d.; coals were 18s. per ton.


In the barony of Coshlea, in the southern part of the county, a witness of the name of Quinlan stated that he had often known labourers in May, June, and July, obliged to eat nettles, and the weed called **prasagh**; that he knew many labourers who had not more than one meal of potatoes for themselves and families in the twenty-four hours; and that they frequently retire from their work from mere exhaustion. Another witness, Denis Mahony, a butcher, stated that he had often sold a quarter of cattle, which had died of disease, for 5s.; and a policeman deposed, that at one period, when farmers bled their calves, the blood was given to labourers, who, such were



---

p.96




their necessities, boiled it with their other food. This was frequently done. It has often happened that potatoes have been scarce and dear in one district, while they have been abundant and cheap in another, not twenty miles distant: and this has proved a prolific source of disturbances. The farmers who had bought up potatoes in the cheap districts, for the purpose of disposing of them at an increased price in the district where they were scarce, have been waylaid, their property stolen and carried away, and many lives lost in consequence; yet the peasantry, in the very places where these outrages occurred, are considered to be patient, their sufferings being taken into account.


These labourers, said a Mr. Adamson, are constrained to use the cheapest food, in order to accept the lowest wages. Corn food of course can never be introduced amongst the peasantry, so long as rents are raised, and wages depressed, by an unlimited competition for land and for employment. Yet grievous as are the effects of the employment of strangers, no cases of violence have resulted from the practice; though a few may be traced to causes



---

p.97



connected with the taking of land. Houses have been burned, and goods and cattle destroyed, in consequence; but these crimes, said one of the witnesses, upon whose estates some of them had occurred, are generally to be attributed to the destitution to which tenants and their families are reduced, by losing their farms. Indeed, whether reduced to entire destitution or not, the expelled tenants were stated to be likely enough to resort to violent measures; for it is considered so great a hardship to be turned out, under any circumstances, that they would most probably be instigated to revenge, and even assisted in accomplishing it, by their friends and fellow-labourers. It appeared in evidence, that crimes connected with land-hiring are often perpetrated by those who have themselves suffered nothing from the persons they injure. A feeling prevails amongst the peasantry that the ejected tenant should not commit the crime himself, as it is supposed he would be subjected to the penalties of the law, whilst others would be exempt. Several instances of engaging others to commit outrage, have occurred in this



---

p.98




district. It was proved that the murderer of Mr. Millar received 2s. 6d.; another man, who was hanged for shooting a post-boy, confessed that he received 10s. for doing it. Before the year 1822, since which period this part of the country has been quiet, it was generally believed that the smaller landholders were incited to violence by persons of superior rank to themselves; but this could never be legally proved against them. It does not appear that rents are affected by intimidation; but the apprehension of disturbance has considerably prevented the investment of capital in land.


The generality of cabins in the barony of Coshlea, contain no bedding, but straw or heath, and it is usual for several of the same family, sometimes as many as six, to sleep in the same bed. The furniture for the most part consists of a table, a stool, and some seats, called "bosses," made of straw.


The principal reason for taking conacre, or quarter ground (as it is called here), is that the occupier can grow his own food by his own labour,



---

p.99



instead of paying money for it. This mode of growing food for the labouring population prevails throughout the barony, but in no case has the labourer as much ground as will produce potatoes for the whole year. In consequence of a practice, now generally adopted by the farmers, of demanding £1 per quarter in advance, a less quantity is taken. Fifteen hundred stones, per Irish acre, is an average crop; 1920 stones, an abundant one. The rent is paid, partly in money, and partly in work, and, when deficient, it is not unusual for the farmers to seize the crop and sell it, and then prosecute the labourer for any arrears that may still remain. Serious consequences frequently result from attempts, on the part of labourers, to dig potatoes before the rent has been paid. In 1834 a man of the name of Daniel M'Inerney went, under these circumstances, to dig potatoes for one meal; the farmer resisted his doing so, and poor M'Inerney's life fell a sacrifice in the struggle. The majority of the witnesses considered that the conacre system is useful to the labourer, as supplying him with the means of employing the spare time


---

p.100




of himself and his family in growing their food; nor did they think that any great advantage would result from the introduction of money payments of wages.


The people here, like the people in almost every other part of Ireland, are addicted to early marriages — the destitute and the comparatively well provided for, equally so; indeed, when a man gets a quarter of an acre of potato-ground, although obliged to borrow money to pay the preliminary expenses of the wedding, he reckons on having enough to keep a wife. "A man or woman," said one of the witnesses, "who has possession of land, can always command a great choice of spouses." One main inducement to marriage is the prospect of having a person to prepare their meals, and the still more remote prospect of assistance from children, when age comes upon the parents.


In this barony, Coshlea, there is a wide undulating plain of land, of the first quality, bounded on two sides by high mountains. The rich low land is chiefly occupied by dairy farmers, who




---

p.101




plough no more than is necessary to supply the inhabitants with potatoes. The best land supports, during the summer at least, one heavy cow to the Irish acre; and on farms of an average quality, two acres will support a cow, both winter and summer. Most of the rich land is wet, and grows rushes and "flaggers" plentifully, though there is a sufficient fall for the water; and it is matter of surprise that more attention has not been paid to the draining of such superior soil. A part of the district has long been called "the golden vale" (more correctly the "golden vein"). On this great extent of fine pasture, but few beasts are fattened — butter-making being more profitable. The chief part of the grass has been ploughed in its turn within a few years, and the richness of the land produces a good sward immediately, though grass seeds are rarely sown. The course of tillage in the small quantity ploughed, is excessively severe, but any liberties may apparently be taken with the land, without doing it serious injury — such is the richness of the soil. When broken up, two crops of potatoes are taken in



---

p.102




succession, without any manure, and are followed by wheat, and a crop or two, or perhaps three, of oats. The ground is then allowed to rest, and form its own sod. All these crops are said to be heavy, and the oats and barley of good quality, but the wheat is coarse. Ten or twelve pounds per Irish acre, is paid for land for planting potatoes on, for the first and second year, the labourers tilling it themselves. During winter, when the weather is open, the milk cows are kept out in the rich grass land, both night and day. The hardihood of the Irish cow is assigned as the reason for the exclusive use of it, in preference to any English breed; but no breed that is eligible in this country can be unsuitable to the finer land and milder climate of Ireland.


The rent about Tarbert is from 25s. to 30s. per acre. Some good land about Glyn lets for 50s., in farms of from fifty to one hundred acres. The cess is more equal here than in many parts. The churchwardens call a vestry, and appoint thirteen of the parishioners, applotters, to value the land; the tithe-bill being taken as the basis.




---

p.103


No coals are sold here; turf, which is abundant, being exclusively burnt. In my bed-room a large turf fire was piled up on the hearth, just before going to bed, without a fender or guard of any description.


From Tarbert to Tralee I travelled by a car which runs regularly between those places. A great extent of the land near the former town is occupied with grain. About four miles from Tarbert, near Ballylongford, is a large tract of college-property, leased by Mr. Maxwell Blacker, a barrister, and brother to Mr. William Blacker, of whom I have had frequent occasion to speak, and who may justly be designated the poor man's friend. Mr. Maxwell Blacker is a good landlord, and, finding the rents too high, he employed a valuer, and directed him to fix such a price on the farms as the tenants could afford. He pays for any improvements that may be made in draining and building. The cottages have a neat appearance, but the land is in wretched condition, and wants the assistance of his judicious brother.


About four miles to the west of Tarbert is Lislactin



---

p.104




Abbey, founded in 1664. Four miles further, Pierce Mahony, Esq., has a considerable estate, on which he employs a Scotch agriculturist, who is also an engineer. Mr. Mahony allows for building and for lime, applied to the land, and his property exhibits conclusive proof of the wisdom of his arrangements.


In the interval occupied by the changing of the horse at Listowell, I had an opportunity of taking a hasty survey of this neat little town, a great part of the road to which, by the bye, was over a barren and moorish country, but in the vicinity of limestone, and capable of improvement. Listowell contains an ancient castle, which in 1600 was taken by Wilmot; and its garrison, who fought for Lord Kerry, were put to the sword. This was the last castle that held out against Queen Elizabeth.


I walked into the Catholic chapel, where several persons, male and female, were kneeling at their devotions, and appeared so attentively engaged as not to be aware of my approach. The chapel and the castle are situated at the west side of a spacious square, from which the road descends to a handsome



---

p.105



new bridge, of five arches, over the river Feal. The banks of this river afford fine scenery, and an old church in ruins is seen in the distance. Near Listowell the soil is good, and lets for 50s. per acre. The population amounts to 2300.


The Rev. Mr. Sands, the curate of Listowell, whom we overtook on the road and took up, informed us that party fights were very common in that part of Ireland, and very frequently occurred without any particular provocation. A short time ago, fourteen men were killed in one of these fights, and on inquiring of some of the others the cause of their hostilities, they assigned as the reason that their fathers and grandfathers had fought before them! Upon such slight and absurd grounds are contests based, that frequently end in the loss of many lives.


Six or seven miles from Listowell, on the right of the road to Tralee, stand the ruins of Lixna Castle, formerly the princely residence of the Earls of Kerry, and now the property of the Earl of Listowell. On the right is a monument raised in honour of one of the Earls of Kerry, and 


---

p.106




on a neighbouring green eminence stands a mausoleum, belonging to the Marquis of Lansdowne, that being the only part of the estate remaining in the family. The history of **Sir William Petty**, the grandfather of the present illustrious Marquis, who has large estates near Cork, and property in nearly all the Irish counties, exhibits a remarkable instance of the establishment of a noble family from the united efforts of ingenuity and industry in one man. From a small beginning, that individual realized for himself a handsome fortune, and at his death left his family £65,000 per annum in land, above £45,000 in personal effects, and a plan of demonstrable improvement in his estate to produce £4000 per annum in addition. On this road are also seen the ruins of Abbey O'Dorney, a celebrated abbey built in 1154, and near them, Grotto, a fine mansion, belonging, as well as the ruins, to the Ponsonby family. On the left of the road are some quarries of black and variegated marble, and near them, a very humble manufactory of chimney-pieces; the prices being forty or fifty shillings each. **Dr. Smith**, in his History of



---

p.107



Kerry, states that the ingenious **Sir William Petty** was the first person who thought of raising and manufacturing the marbles of Tralee.


The distance from Listowell to Tralee is thirty-six miles, and the fare was only four shillings. Tralee, the county town of Kerry, has a population of 10,000, and is an improving place. There are some excellent streets, and the shops generally are handsome and well stocked. The land about the town is most of it in grass of the finest verdure, and although the limestone rocks appear in many places above the surface, the rent is from three to four pounds an acre. In descending the hill into Tralee, the bay, Kingshead, and the Amethyst Cliff, are seen to great advantage. From the bay, a fine valley or trough extends to the town; and through this valley a canal was in course of being cut, as no vessels, in the absence of such an artificial navigation, could approach within a mile of the town. The gentlemen of the neighbourhood of Tralee are said to be remarkable for their opulence, respectability, and public spirit. The castle here (lately taken down) belonged to the 


---

p.108




Earls of Desmond, and was granted to the Denny family.[20](javascript:footNote('E830001-002/note020.html'))


Here, for the first time, although I had been in Ireland three months, I heard the far-famed Irish funeral cry at a wake. I was passing the house in a car, and as soon as the vehicle stopped at the inn, I returned to the spot. The "keening" was up stairs, above a shoemaker's shop. The shouting — one of the most extraordinary combinations of noises I ever heard — only occurred when any fresh person entered the apartment, and, after a few minutes' duration, was suspended. The intervals between the vociferations were devoted to the discussion of whiskey and tobacco.


From Tralee we travelled due east to Castle Island (formerly called the Castle of the Island of Kerry), about ten miles. Ballyseedy, now occupied by Sir Edward Denny, is a wooded domain to the south of the road, and belongs to the Blennerhasset family; near to Ballyseedy is one of the




---

p.109



ancient square castles. The next object worthy of remark is an estate belonging to James, brother to **Daniel O'Connell**, Esq.; and here the traveller is greeted with comfortable, clean-looking houses, and cottages with gardens and orchards, lately made. Lime is spread on a considerable tract of new land, and the fences are improved. Mr. O'Connell is evidently enabling his tenants to exert their industry to advantage. Not far from this estate is that of John O'Connell, another brother of "The Liberator." About Castle Island the land is flat and fertile: and I may state here, to prevent, on the part of others, a mistake into which the name of the town led me, that its situation bears no resemblance whatever to an island; but its former name is sufficient explanation. The castle, of which extensive ruins exist, was built in 1226, was taken in 1345 from the Earl of Desmond, and, according to the cruel system of warfare pursued in those times, the garrison were put to the sword. The lordship of Castle Island was granted by Queen Elizabeth to the Herbert family.




---

p.110


We were now within twelve or thirteen miles of Killarney, a name with which are associated, all the world over, images and scenes of beauty. The road is uninteresting almost all the way, but this, so far from being a disadvantage, probably gives a keener relish for the delightful scenery that awaits the stranger. About two miles from the town of Killarney, the mountains that encompass these celebrated lakes first burst upon the view. We saw them to great advantage. The evening was remarkably clear; the sun had sunk behind Mac Gillycuddy's Reeks (so called, from an ancient chieftain family in the neighbourhood — still resident there), and their rugged outlines lay softly and yet distinctly traced upon a cloudless twilight of extraordinary tranquillity. This twilight was succeeded by the radiance of a lovely moon, and I enjoyed a ramble by its light among the new and interesting objects that surrounded Killarney.




---

p.111


The Kenmare Arms, Killarney — Plans for exploring the neighbourhood — Ross Castle — Lead and Copper Mines — Scenery on the Lakes of Killarney — The Arbutus — Glena cottage — O'Sullivan's Punch-bowl — Dinis Island — The Eagle's Nest and Crane Mountain — Old Weir Bridge — Islands on the upper lake — O'Donoghue's Horses — Innisfallen — Return in the evening — Comparison of the Irish with the English Lakes — Agriculture of the district — Barony of Iveragh — Food of the labourers — Cowkeeping — Attachment of the tenantry to their native places — Crops — Butter and cheese — Cattle — Taxation — Manure — Cabins — Loan Society — Disadvantages of absenteeism — Lord Headley's property.
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The only company I found at the Kenmare Arms, a very comfortable inn, was an elderly gentleman, whom I took for a clergyman, and a young gentleman from London. The latter, bound on the same errand as myself, agreed to accompany me on the following day in exploring the beauties of the neighbourhood. We accordingly devised a plan of operations for the morrow, and adopting the advice of Mr. Finn, the landlord, engaged a 


---

p.112




boat and four rowers to convey us round the lakes, with which a day, we were told, was sufficient to make us acquainted. The ensuing morning was cloudy and rainy, and I had some difficulty, first in getting my fellow-traveller out of bed, and afterwards in persuading him that the weather was not too stormy to admit of our venturing on the lake.


The lakes are more than a mile from Killarney. We were to embark at Ross Castle; and as my companion, who promised to follow, had not arrived, I beguiled the time by ascending the staircase of the ancient building, and had a view of the lake and several of its islands from the battlements. The castle is a lofty square building, and was formerly the royal residence of the Lords of the Lake, who bore the title of Kings. In 1652 it was defended by Lord Muskerry against an English force commanded by General Ludlow. This castle was the last place that held out against the English Parliament. In sailing by the shores of Ross Island, we passed near the lead and copper mines, supposed to have been worked at a very



---

p.113



early period. They have been abandoned — probably for want of spirit and capital. **Dr. Smith** states that the copper mines were very productive, and that the adjacent mountains abound with iron: he also picked up specimens of ore containing some tin. On this island some of the rude stone implements, called Danish hammers, have been found.


My young friend and I were now seated comfortably in a swift-sailing boat, with four muscular rowers and a helms-man, and abundance of excellent provisions, supplied by our attentive landlord. The waves were somewhat larger, and the motion of the boat was somewhat less steady, than we had expected, but our conductors assured us of safety, and we relied upon their experience and veracity. The day, though probably not such a one as we should have selected, was exactly the sort of day to set off the captivating scenery to the best advantage. The sun shone occasionally through showers of rain (and this, of itself, is one of the loveliest of sights, the small drops turning to gold as he smiles upon them)



---

p.114



and at other times, and even *during* the showers, lighted up, not only the distance, but near objects also, with his brightest and most splendid beams. The day was an alternation of sun and shower — a succession of delicious lights and shadows. Every rock, and lawn, and shrub, glittered with rain-drops, and their minute but perfect mirrors reflected and heightened every variety of colour in the landscape, from the extreme verdure of the **arbutus**, to the bright red of the boughs of the birch. Our course lay between Ross Island and Ennisfallen, across the lower lake; the Tomies and Glena Mountains, in this course, were seen in perfection. The sides of these mountains, which form the west and south-west banks of the lake, are completely clothed with **arbutus**, mingled with birch, for several hundred yards from the shore; and this was the season in which the colour of the **arbutus**, contrasted strongly with the red stems of the birch, is most vivid and beautiful. The profusion of the **arbutus** surprised me; it is as common as the furze or hazel in England, and reaches the size, and assumes



---

p.115



the character, of a large tree, girthing as much as from seven to nine feet. I measured one of seven feet. They who have not seen the lakes of Killarney, can form no adequate idea of the abundance and exquisite loveliness of this plant.[21](javascript:footNote('E830001-002/note021.html'))


Passing Darby's Garden, we entered Glena Cottage, erected by Lord Kenmare, in the Gothic style of architecture, and surrounded by pleasure-grounds elegantly laid out. The cottage, however, does not seem to be sufficiently in keeping with the wild and *natural* look of the scenery about, to merit the ephithet "tasteful." According to my notions, it should have harmonized, instead of contrasting, with the character of the rugged and romantic neighbourhood. Another cottage has been built here by Lord Kenmare, and is devoted, with a praiseworthy liberality, to the accommodation of tourists and visitors. A heavy shower of rain coming on, we had an opportunity of feeling the benefit of his lordship's hospitality,


---

p.116




for we occupied the apartments provided for the reception of strangers, and enjoyed the contents of our basket of provender. Those who fish, may here be regaled with salmon, pierced with arbutus skewers, and roasted over a turf fire; but as we had not time to indulge in fishing, we were obliged to forego that luxury. The Lakes of Killarney contain salmon, trout, char, and flounders, and, if the boatmen are to be believed, there is not a pike in the county of Kerry. The lower lake is four miles and a half long, by two in breadth.


The rain having subsided, we again embarked, passing Dinis Island, through a narrow channel, and then by a deep and sheltered basin, called O'Sullivan's Punch-bowl; all these places are peculiarly beautiful. Nothing perhaps can exceed the exquisite loveliness of the scenery about Dinis Island; and it is pleasant, when visiting it, to be informed, that the admiration of **Sir Walter Scott** was particularly excited by the charming peculiarities of this part of the lake. Dinis Island belongs to Mr. Herbert, who has also shown his



---

p.117



wish to gratify the public, by erecting a cottage upon it for their accommodation.


The middle and lower lake are connected with the upper by a rocky channel, more than two miles in length, and flanked by a long range of rugged mountains, one of which is called the Eagle's Nest, in consequence of being the favourite building-place of that royal bird. This mountain is about 1300 feet in height, and of beautiful outline: it is connected with Crane Mountain, which is apparently much higher. The gracefully sloping sides of these hills are covered with **arbutus** and other luxuriant shrubs, down to the very water's edge; the woody raiment gradually disappearing towards the top — and the summit, grey with rugged rocks, being left quite bare. On entering this romantic channel, a rude bridge (Old Weir Bridge) had to be passed. Usually, the rowers abandon their oars, and drag the boat through by ropes, the opposing current being generally so strong as to render the passage by rowing impracticable. I was not aware of this; and was surprised to observe the men throw off


---

p.118




their jackets, as we approached the bridge, and make an extraordinary exertion, taxing to the full the muscular power they possessed. They were successful; they passed the arch. Through this arch, only ten or twelve feet wide, and another smaller, flows the whole of the water of the upper lake, into the middle and lower lakes. Rowing through this arch, in opposition to the current, is a feat but seldom accomplished, and our rowers were accordingly somewhat elated with their achievement. The Old Weir Bridge has the appearance of great antiquity. The guides are in the habit of directing attention to a large rock, past which we sailed, bearing the name of the Man of War, from its strong resemblance to a vessel of the line.


The passage into the upper lake, not more than thirty feet wide, goes by the name of Coleman's Leap. In returning, visitors usually mistake a narrow passage at Coleman's Eye for the channel connecting the higher and lower lakes, and wagers are often made to depend upon the course taken. I, like the rest of strangers, took the



---

p.119




wrong one. The upper lake is a mile and a half long, and, on an average, nearly a mile in width, is very much indented and irregular, covers an extent of from seven to eight hundred acres, and has numerous rocky islands, no less varied in appearance than in size. Eagle Island, beautiful in every respect; Ronan's Island, commanding a fine view of the lake; M'Carthy's Island, Oak Island, and the Seven Islands, rocky, and fringed with **arbutus** to the water's edge, have all claims to regard for some characteristic peculiarities of beauty. We caught a glimpse, and only a glimpse, for we had not time to make a more careful examination, of the Derricunihy Cascade, rushing down the mountain. Granah, the residence of John O'Connell, is on the border of this lake; and Lake Ville, the seat of his brother James, is about a mile distant. On returning by Old Weir Bridge, we crossed the middle lake, sometimes called Turk Lake, which is two miles in length, and a mile in breadth, at the further or east end; and going under Brikeen Bridge, entered the lower lake, and rowed to the celebrated



---

p.120




island of Innisfallen, passing in our way Mouse Island, so called from its diminutive size, and O'Donaghue's Prison, a steep barren rock, anciently used by a chieftain of that name as a place of security for his prisoners. The reader who is familar with the Irish Melodies of **Moore** (and what reader is not?) will remember a singular tradition connected with this lord of the olden time. O'Donaghue and his White Horses, is a legend once implicitly believed, and even now received with some degree of partiality, if not credulity, by persons who certainly ought to be slow in attaching faith to an impossible but interesting story. For many years after his death, says **Moore**, the spirit of this hero is supposed to have been seen on the morning of May-day, gliding over the lake on his favourite White Horse, to the sound of sweet unearthly music, and preceded by groups of youths and maidens, who flung wreaths of delicate spring flowers in his path. Among other stories connected with this Legend of the Lakes, it is said that there was a young and beautiful girl, whose imagination was so impressed



---

p.121




with the idea of this visionary chieftain, that she fancied herself in love with him, and at last, in a fit of insanity, on a May-morning, threw herself into the lake. The boatmen at Killarney call those waves which come on a windy day, crested with foam, "O'Donaghue's White Horses."


Innisfallen owes the extensive fame it has acquired, partly to its remarkable fertility, partly to the magnificent trees which ornament it, and partly also to its beautiful marble and the remains of its ancient abbey. It is said to excel in fertility any island in Europe; in beauty, it can scarcely be surpassed. In summer it must be exquisite indeed — a little world of silvan seclusion. The hollies and the ashes are of extraordinary magnitude: one of the former, at four feet from the ground, measured fourteen feet in circumference; and an ash, at two feet from the ground, girthed 35 feet. The cattle and sheep, which are fed upon the island in great numbers, are taken care of by a herdsman residing on the spot; who also acts as Cicerone when parties visit the luxuriant solitude. The surface of Innisfallen is rough, and though so




---

p.122



singularly fertile, has the appearance of being in a wild uncultivated state. The Abbey stands near the landing-place; it is in complete ruin, and presents but little to interest the visitor, beyond the contemplations which all ancient ruins are calculated to awaken. There must be something defective in the constitution or educational habits of one who can look upon the shattered productions of man without instruction. The Abbey at Innisfallen was founded by St. Finian in the sixth century. In 1180 it was plundered, and its priests were slain. "According to the Annals of Munster," says **Carr**, in his Stranger in Ireland, "this Abbey and grounds were esteemed a paradise and secure sanctuary, in which the treasures of the whole country were deposited with its clergy." Near the Abbey is an ancient building with a Saxon door-way. The building has, however, been disgracefully modernised. The celebrated Annals of Innisfallen, written here, are preserved, I am told, in Trinity College, Dublin. They are in manuscript, and contain a sketch of the history of the world, from the creation to the year 430, from 



---

p.123




which time to the year 1320, they relate solely to the island.


As we returned, the moon rose brightly over Ross Castle from her throne of clouds, lighting up our path with sparkling beams, and touching the gentle ripples with a silver radiance. Occasionally the rowers chanted in their native language a favourite national song, resting on their dripping oars. Ross Castle, rendered still darker by being thrown into the shade, was our landmark, and formed a romantic finish to the scenery of this most interesting and memorable day.


Having now seen the Lakes of Killarney, I was enabled to draw a comparison for myself between them and the rest of the Irish Lakes, and the celebrated lakes of the north of England. Lough Neagh, the largest of all the Irish lakes, would be altogether uninteresting, were it not for its immense extent, and for the pebbles, the petrifactions, and the plants, that are scattered upon its shores. Lough Erne, the next in size, certainly surpasses Windermere, as a lake; in the neighbourhood of which art and nature are united with



---

p.124




consummate felicity; and Lake Killikeen, and the other Lakes of Cavan, from their number, as well as their variety and beauty, are certainly entitled to take high rank among the lakes of "the Emerald Isle." Lough Gilly, though comparatively unimportant, when considered in reference exclusively to size, is a charming spot, infinitely superior, in my opinion, to Lough Erne. The islands upon it are bolder, the shores are not so flat, and are more variously indented; and the mountains, seen from its bosom, far surpass, in diversity and character of outline, those that encompass the latter lake. Lough Gilly also has a charm in its luxuriant **arbutus**, which Lough Erne cannot pretend to. But the Lakes of Killarney, attractive as many of the others unquestionably are, exceed them all in variety, boldness, and beauty. None of the lakes in Cumberland, Westmorland, or Lancashire, will bear a rigid comparison, in my opinion, with these.


I took sketches of the Eagle's Nest, and Crane Mountains, the Old Weir Bridge, O'Donaghue's Prison, and Mac Gillicuddy's Reeks; but as no



---

p.125




lithographic representation can convey anything like an approach to the sublimity of vast and rugged mountains, or indicate the exquisite brightness and beauty of the **arbutus**, they repose quietly in my portfolio. Yet though imperfect as descriptions to others, they are infallible remembrancers to me; and frequently as I look upon their lines, the Past, with its many enchantments, rises before me, if not quite so vivid as it once was, at least with a milder, and perhaps a more delightful power.


The agriculture of the district around Killarney has little to recommend it. There are no turnips, rape, or clover. The potatoes are planted in beds, by the spade (lime being applied the preceding autumn), and are followed by wheat, oats, or barley. The land is then again manured for potatoes. I was gratified to find that the farmers keep a few sheep, and manufacture their own cloth. They also cultivate some flax, which affords them the enjoyment of spinning at home; it is then sent to be woven. Farmers of sixty or eighty acres keep about twenty cows, and their rent is 


---

p.126




calculated by the number of cows, from £3 to £4 per cow; the meadows and ploughing land being given in.


The Assistant Commissioners state that in the barony of Iveragh, which lies on the coast, to the west of Killarney, and is a mountainous district of poor land, bounded by the sea, and deeply indented by fine bays and inlets, running far in amongst the mountains, the food of the peasantry consists almost entirely of potatoes and salt; all other things being considered superfluities. They eat some fish occasionally, but sell their eggs. If a wife gives eggs to her family, she boasts of it. The labourers, even when employed, get only two meals a day. For the daily consumption of a family consisting of a man, his wife and three or four children, 42 lbs. of potatoes are required to keep them in health and strength; but this was above the average consumed by families of that size. In scarce seasons, it was stated, they would eat the flesh of cattle that die of disease, but they seldom are blessed with the opportunity.




---

p.127


It appears, from the account given of this part of the country by **Dr. Smith**, in his History of Kerry, that the poor were better circumstanced when he wrote in 1756. — "The soil," he observes, "affords them milk, butter, potatoes, with a few oats; and their sheep and cattle which die by the rigour of the winter, supply wool and leather, which they work up into frieze coats and brogues." The new potatoes are not fit for food till the beginning of August, and during the interval that elapses between the consumption of the old ones and the new being ready, the cottages are often deserted by their inmates turning out to beg. Potatoes have been reduced to meal, for the purpose of preserving them, but the experiment was said to have failed. The people, from habit partly, and partly because, to use the words of one of the witnesses, "they like the feeling of fulness which they experience after eating quantities of potatoes," generally prefer them to bread, as a permanent food. "If," said the same witness, "I were to offer a man his choice for one meal, he would say bread; but if for a week, he would rather live on 


---

p.128




potatoes." In the barony of Iveragh there have been no disturbances for thirty years, with the exception of some slight ones in 1821.


Farms, said Mr. Fitzgerald, are usually let in common, amongst a number of small holders; half a dozen, or more, occupying specified quantities of the same farm, and paying separate rents to the landlord, according to the number of cows each is allowed to keep. If one of these tenancies becomes vacant, a new tenant is put in by the landlord, at the same rent as the preceding occupier paid. The new tenant could not well have his rent raised (it being calculated at so much a cow), without raising the rent also of all the old tenants, who hold cow-keepings on the same farm. The tenants agree amongst themselves what land each shall cultivate. The attachment of the tenantry to their native places is extraordinary, in a great number, perhaps in a majority of instances, interfering greatly with the advancement of their interests. It was stated by one witness that "they would rather remain in wretchedness at home, than go, with a prospect of a fair provision,



---

p.129



elsewhere:" and Mr. James O'Connell stated "that in the parish of Dromed he had some tenants whom he was desirous of removing into the adjoining parish, and to land which they knew to be much better than that they were occupying; this desire, however, he was unable to fulfil — the refusal of the tenants arising solely, he believed, from a fond attachment to their native parish."


The greater part of the barony of Iveragh, consisting of about 99,540 statute acres, is mountain, pasture, and wet bog. There are some thousand acres of wet bog. Not one twentieth part of the barony is tilled; much of the rest might be brought into cultivation, but roads would of course be necessary. Within the last twenty years, a good deal of hill and grazing land has been brought into cultivation, and the same process is going on daily. There is at present, according to the evidence of Mr. James O'Connell and others, sufficient uncultivated land in the barony to employ all the labourers for many years. The district does not produce good wheat; summer fallows and the roller are unknown. The 


---

p.130




weeding of potatoes and oats is much neglected, and the ground is very subject to weeds. From inability to buy seed, sowing the land is sometimes omitted. In the spring of 1834 potatoes were dear and scarce, and there were many pieces of ground in the neighbourhood that had been dug and manured, and otherwise prepared for seed, in which potatoes were not set, the people being obliged to consume the potatoes which they intended to set, and being too poor to buy seed at the advanced prices. All their money, indeed, went to buy food; about £4000 was paid in this barony for potatoes for food, last spring.


The butter which is made here, is, for the most part, of third-rate quality. After each churning, it is laid in a heap on a flag, and increased until sufficient is collected to fill a firkin; this, with small farmers, is a work of from two to six weeks. It is not salted till put into the firkin. The principal market is Cork, but a great deal is sold at Tralee and Killarney. As for cheese, but little is made, and very little used in Kerry, or indeed in any part of Ireland.




---

p.131


The Kerry breed of cattle, being particularly hardy, are said to suit the district; they live on steep and hard ground. The value of a good bull is about £2! — the price of a good breeding cow from three to four pounds. Heifers calve at three years old. All cattle are housed in winter. The smallest farmers keep them in their own cabins.


The taxation per acre in this barony is about 10 per cent on the rent; the grand-jury cess has been regularly increasing, being double what it was in 1813. Parish-cess is done away with. Tithes are charged on the rents, and average about 5 per cent. There is no tithe-free property in the barony, except a little glebe land.


Lime is too distant and dear to be commonly used for agricultural purposes: there is none nearer than Killorglin, twenty-eight miles distant. The small farmers carry sea-weed and sea-sand some miles from the shore, on their own backs and on asses, and great pains are taken to collect heath, furze, and fern, to put in the cattle yard for manure. The sea-weed on the shore and rocks is reserved for the neighbouring farmers, but that



---

p.132




growing under the water is free to any one; this they cut with hooks fixed in long poles. In May and June large quantities of sea-sand are driven on shore; and being much more than the owners of the shore want, others are permitted to take it away. The influence of the sea-weed in this district as a manure extends only to one crop.


In the barony of Trughenackmy, a little to the north of Killarney, the average of wages is 6d. a day, with diet; but one of the witnesses examined, a Mr. Husey, stated that in summer, when employment is scarce, many men may be had for no other remuneration than a few potatoes and milk twice a day. The cabins in this barony are generally without pig-sties — the pig, when there is a pig, lives, like one of the children, in the house. The cost of erecting a cabin was stated to be £2. 10s. 6d., reckoning the door and timber at £1. 4s. 6d., and the labour and straw at £1. 6s.


In respect of the system of pawning, one of our rowers said that his jacket was then in pawn; though worth 7s. 6d., he should get only 2s. 6d. The pawnbroker, he added, if the articles sell for



---

p.133




more than they are pawned for, never returns any money. It was agreed on all hands that a Loan Society would be very useful, and productive of much greater good than pawnbrokers.


In this barony, nine-tenths of the whole property are held directly from the proprietors in fee, without the intervention of middlemen. Trinity College has a considerable property near Killarney. The tenants of land held under non-resident landlords, were stated by some of the witnesses here to be in a decidedly worse condition than those who hold land under resident proprietors: "for instance," said Mr. Chute, "if I apply to my landlord's agent for any facility which I may require to improve my farm in any respect, he states that he has no power to grant it me, and refers me to a landlord, living at a distance, who knows but little of the circumstances; he refers me back to the agent, and, between the two, I get nothing done." When proprietors receive their own rents, they do not receive agents' fees in addition; but in signing leases, the agent, or the family of the landlord, often require compliments to be made. Tenants



---

p.134




in common are constantly quarrelling and fighting; the least trifle is a source of disagreement. Lord Headley's property among the mountains is rapidly undergoing cultivation. He gives leases to his tenants, and stipulates to allow them for all the lime which they prove to have laid out on the land, at a rate not exceeding twenty-five per cent on their rents. Clauses of this sort, referring to matters of husbandry, might be inserted in leases with very beneficial effects. To the question whether it would be desirable for the landlord, the tenants, and the public, that the former should be compelled to take all improvements and growing crops at a fair valuation, at the termination of the lease, and that the tenants should be liable to pay damages for proved and wilful neglect of the land — it was answered, that "it would be unjust to the landlord: it would plague him in every way; he would never consent to let land on such terms; he wishes to choose his own time and place for improvements; and he knows when he can afford to make them."




---

p.135


Journey from Killarney to Millstreet — The Cloghreen Mountain — The Paps — Irish funeral procession — Singular defence of absenteeism — The Kerry sheep and pigs — Macroom — The River Lee — Journey to Cork — Cork — Black Rock Castle — Picturesque banks of the Lee — Trade of Cork — Lloyd's Hotel — Kilcolman Castle — Spenser and the Fairie Queene — The meeting between Sir Walter Raleigh and Spenser — Fair-day at Mitchellstown — Wages and Rents — The Kingston caves — The Knockmeledown Mountains — Cave of Oonakareaglisha — Lord Glengall's estates — Ride from Rathcormack.
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


From Killarney to Millstreet, in the county of Cork, I travelled in an open car with the elderly gentleman before mentioned, whom I discovered to be, not a clergyman, but a landowner going to receive the rents of his estates in the county of Tipperary. I found him, notwithstanding the infirmity of deafness with which he was afflicted, an agreeable, communicative companion, and well acquainted with the country through which we passed.




---

p.136


After leaving Killarney, the character of the country for a few miles is very fruitful and pleasing. To the south of the road, the river Flesk passes through a valley of good land, and, receiving the mountain waters for about ten miles east of Killarney, flows into the lower lake near Ross Island. Several old churches and castles adorn and diversify the scenery. The Cloghreen Mountain is an interesting object. It seemed to be a series of immense steps or right angled indentures, ascending as far as the mist, which enveloped the upper part of this and the Killarney range of hills, allowed us to see. The Paps, also, two finely rounded hills meeting at the bases, are seen to the right, having each a cairn at the summit.


Before reaching Millstreet I met a regular Irish funeral procession, the first I had seen. The horse which drew the car containing the coffin, was led by a man. The vehicle had the appearance of a triumphal car. The canopy was painted in gaudy colours, and decorated with curtains; one female mourner sat at the head, and another at the foot of the coffin, venting their real



---

p.137



or fictitious sorrow in loud lamentations. The car was followed by several women on foot, with handkerchiefs in their hands, "keening" as they went along — their faces expressive of agony and grief, which, by the way, the great exertion necessary to effect the discordant wail, would be sufficient to produce. Several cars, and from twenty to thirty horsemen, completed the procession. I did not observe any suits of black, nor is it a general custom to put on mourning in following a corpse to the grave; even in Dublin, funerals are frequently attended by as many as twenty cars, the only persons in mourning being those in the coach immediately following the coffin, and sometimes not even those. The spectacle was new to me and extremely interesting, as the peculiar customs of different countries cannot fail to be; but though interesting, the loud and dismal cries which form an indispensable and prominent part of the ceremony, were productive of a degree of horror which I shall not attempt to describe. They were so thoroughly inconsistent with the silence and the gravity which I have always felt


---

p.138




to be due, not merely to the inanimate relics of man, but to the abstract and solemn idea of death. The "consummate kingliness" of this vast power should not be profaned by the shrill yellings of hired mourners. The custom, however, has the sanction of antiquity to recommend it. "The antiquity of this custom," says **Mr. Wright**, in his Scenes in Ireland, "not only in Ireland, but amongst the Romans, Greeks, and Hebrews, is indisputable. 'The mourners go about the streets,' has an obvious reference to persons analogous to the professional keeners of Ireland. The Romans had their 'praeficae mulieres,' who, 'with dishevelled locks,' led on the melancholy parade of death; and Homer frequently alludes to this ceremony, in describing the last rites of his most conspicuous heroes: — 


> 1. The pious maids their mingled sorrows shed,
>   
> And mourn the living Hector as the dead.
> 



"And again


> 1. Alternately they sing, alternate flow
>   
> The obedient tears, melodious in their woe.
> 




---

p.139



"The funeral oration, or song, was anciently composed by the bard who dwelt in the hall of the chieftains, and contained in its elegiac numbers a catalogue of the virtues of the deceased: 'O why did he die, who had so many sons and fair daughters? O why did he die, who was lord of the hill, and the dale, and the golden valley?' &c.; such wild effusions formerly, and even now, constitute the verbal portion of the elegiac lamentation, called 'The Irish cry.'"


My companion and I parted at Millstreet, where I learned that his name was Hodgson, that he lived at Bantry, and had estates there as well as in Limerick. One advantage attributed by him to absenteeism, struck me as somewhat ingenious: he said that proprietors, by living away from their estates, see the improvements of other countries, and import them to their own districts. This would be a valid defence of absenteeism, provided absenteeism were merely temporary, or that the majority of the absentees, which is certainly not the case, feel the interest ascribed to them by Mr. Hodgson, and exert themselves, as he implied,



---

p.140




in improving the condition of their country and its inhabitants. Some of the bog near Bantry Bay, he told me, let for only fourpence an acre. Bad landlords, he observed, were the means of making bad tenants; the former considering themselves every thing, the tenants nothing. The system (he added) pursued by too many of them, tends directly to the destruction of their tenants, being often actually the cause of their death. A wiser policy — the inculcation of an improved agriculture — would be found to operate as beneficially for the landlord as for the tenant. The property of the one would be augmented — perhaps not always nominally, but invariably in reality; — and both the physical and the moral condition of the other would be ameliorated.


The Kerry sheep are curious-looking animals; many of them having been very lately shorn (though late in December), had no wool except a large tuft on each cheek. I observed sheep in a similar condition on the mountains of Lough Conn, and learnt that it was a common practice in those parts of the country to shear them twice a year. They



---

p.141




are greatly inferior to the breeds on most of the mountains of England and Scotland. It is for the sake of the wool that farmers keep a few sheep: the fleece weighs about 2lb., and sells for 1s. per lb. As we proceeded, we frequently passed droves of fat pigs on their way for embarkation at Cork; some men were driving two or three, others a score or two of these animals. The pigs in Kerry have not been improved, as in most parts of Ireland; they still remain a long-eared, narrow-backed, long-legged race, probably as bad a breed as any in the world. The expense of an Irishman travelling forty or fifty miles with his pigs is a mere trifle: a pennyworth or two of bread, and a draught of buttermilk, is all he requires, by way of food; and as for lodging, he is glad to creep into an outhouse of any kind with his pig, which has long been his cabin-companion. He can make no better use of his time and talents than in accompanying his favourite to Cork. The animal, having been so well tutored at home, is no trouble on the road.


The country around Millstreet is romantic and



---

p.142




pleasant, and, if time had allowed, I should have enjoyed a day's ramble in the vicinity. The road passes through the rugged hills of Carrigugulla, famous alike for slate-quarries, and as the scene of dreadful encounters of the White Boys in 1822 and 1823; and thence through the hills of Muskerry to Macroom on the Shullane river. The population of Macroom is about 2000. Near the town stands an ivied castle, originally erected in the reign of King John, and rebuilt in 1641. It is stated by some to have been the birth-place of **Sir William Penn**. This ancient structure has been degraded by the insertion of modern sash-windows, and other equally preposterous anomalies.


The rent of land in the vicinity of Macroom, is from 15s. to 20s. per acre; the cess 3s.; lime, which is of excellent quality, is from 1s. 2d. to 1s. 8d. per barrel, of rather more than 2 bushels.


About four miles from Macroom we crossed the river Lee which runs through Cork, and is indebted for its waters to the mountains of Muskerry and the lake of Inchegelagh. We afterwards had it



---

p.143




meandering along the valley on our right, through rocky and romantic banks. The machine which conveyed me was a sort of Dennett with very stiff springs, and I was unmercifully worked about with a violent motion which had the effect of repeatedly bringing my knees and my chin in very close neighbourhood. This journey of twenty-four miles (which occupied no less than five long hours and a half) was one of severe suffering to me, both on my own account and on the horse's. As usual, I could not induce the driver to stop, for the purpose of giving the animal a mouthful of anything, not even a drop of water. In the course of conversation he told me that a labourer consumes a pennyworth of tobacco daily — that it is considered an absolute necessary — and that if a man were asked whether he would go without tobacco or bread for twenty-four hours, he would decide to go without the bread.


The country between Macroom and Cork is uneven and rocky, and bog prevails in the valleys. Lime is much used; and by the road-side I observed large depots of finely-veined limestone, a



---

p.144



species of marble used for burning into lime, and brought from a considerable distance. As Cork is approached, the land is richer, and the Lee expands to a great breadth.


I arrived at Lloyd's Hotel in Cork too late to see anything of the city that evening; in the morning, however, I rose early, perambulated the streets in several directions, and walked to the Barracks, situated on an eminence from which an extensive view of the city is commanded. After paying a visit to the marble quarries, I proceeded along the Mardike, a celebrated promenade, a mile in length, lined on both sides with elms, and crossed the river by a ferry to the north-west part of the town. In the street opposite the ferry is an ancient stone well called Sunday's Well. From hence I mounted the hill to Blair's Castle, from the top of which I had an extensive view of the city, the river, and the adjacent scenery. Cork is admirably situated, and is a picturesque city. The banks of the river are formed into gently swelling hills, well wooded, and interspersed with buildings, gardens, lawns, and pleasure grounds. The old part of the city



---

p.145




near the river is flat, but the greater part ascends the steep sides of the hills, and presents an outline somewhat different and infinitely superior to the generality of towns. Amongst the public buildings in Cork, a new Catholic chapel, not completed when I saw it, and the Court-house, claim particular notice. The former of these edifices stands in King-street, and is built in the Grecian style of architecture. Eight Corinthian columns support the pediment and entablature. The Courthouse, situated in Old George-street, and designed by Mr. George Pain, is a splendid building; and so far as external appearance is concerned (and I had no opportunity of inspecting the inside), pleased me better than any public building I had seen in Ireland. It is constructed of beautifully veined limestone, or marble, has a flight of, I think, twelve steps, and a pediment supported by noble columns with Corinthian capitals. Cork now resembles a modern English city; its various canals or streams, formerly open, are covered or diverted, and the ancient abbeys have been demolished without mercy. Instead of being very narrow,



---

p.146




as formerly, the streets are now spacious, and lined with excellent shops.


This splendid city is not without that which every Irish town possesses — its numerous company of wretched cabins; but, unlike the rest of Irish towns, which generally have these miserable dwellings in the suburbs, Cork has collected them in the very centre of her populous community, but in a part through which there is no very public thoroughfare; and it is quite possible that a stranger, unless in search of the abodes of the poor, might miss them altogether, and leave Cork with an impression that it contained proportionably a smaller share of misery than other places. Nay, indeed, a person might reside here for months, and even years, without suspecting that Cork was not, in every part, a peculiarly neat, comfortable, and prosperous city. I, however, forced myself among these narrow filthy streets, and equally filthy habitations, the broken windows and doors of which, together with a variety of other infallible evidences of wretchedness and destitution, too plainly informed me that Cork, though she made



---

p.147




less display of her miseries than some towns which I had visited, was far from being exempt from the appalling horrors of poverty. Begging is practised here without shame; women, both young and old, well-dressed and ragged, are importunate in their solicitations. But what can be said in denunciation of a custom which seems to be *obliged* by the absence of any legal provision for the aged, the infirm, and the deserving needy?


In one of the cars, here, appropriately enough, called "jingles," I visited Black Rock Castle, from whose battlements I had a fine view of the broad river, upon which vessels of various sizes moved to and fro, giving the interest of life and activity to a scene that could not fail to be charming under any circumstances. As far as the eye can reach, the banks of the Lee preserve their picturesqueness, and are studded with mansions of different degrees of pretension and beauty, surrounded with richly wooded parks, or smaller, but scarcely less attractive pleasure-grounds. I counted no fewer than thirty of these mansions. It was indeed a rich and gratifying prospect. On



---

p.148




one hand, Cork, with its vast population, and its river, loaded with commerce — on the other, the infallible signs of wealth and mercantile prosperity, villas and their ornamental environs. So different was the scene from anything I had witnessed in Ireland, that I had some difficulty in persuading myself that I was actually across the channel. The road, nearly all the way to Black Rock Castle, is lined with villas, grounds richly adorned, and hanging gardens, sloping to the river. An extensive Nunnery and a new Church are conspicuous objects on the same road. The Church is built of veined marble, and had a very elegant spire, which, not long after I saw it, was shattered by lightning.


The Quay, which can be reached by vessels of 150 tons burthen, presented a busy and animated scene. Several vessels lay near it, and, in the adjacent warehouses, great activity prevailed. The exports of Cork are, linens, butter, pork, beef, flour, cattle, and eggs — 50 tons of the latter being frequently put on board one steamer at a time, and from 1000 to 1200 pigs exported in one




---

p.149



day. The manufactures are sail-cloth, leather, glass, coarse woollen cloths, and whiskey, for which Cork is famous; there are large distilleries, six or seven miles west of the city. Near the river Lee are also gunpowder-works, belonging to Sir John Tobin of Liverpool. This is the only manufactory of the kind in Ireland. There was formerly a sugar-refining establishment, occupying the place of an Augustine Priory, called Red Abbey, but it has been given up. The flour mills are on a most extensive scale, and the machinery most complete; it is said that although the wheat of the county of Cork is inferior to that of Tipperary, the superiority of the Cork mills produces finer flour. Furniture comprises an article of considerable import. The price of provisions I found to be reasonable; beef from 4 1/2d. to 6d.; mutton 6d.; pork 3 1/2d. per lb.; Turkeys 2s. 6d. each; fowls 11d. a couple; cheese from 10d. to 1s. per lb.; potatoes 3d. per stone.


At Ringabella, near the harbour's mouth, lead mines are worked; and within a quarter of a mile from Cloghnakilty, 24 miles to the south-west of 



---

p.150




Cork, are slate quarries, and mines of copper and manganese. Many ores are said to exist in that part of the county, as well as in Ireland generally, which only require the application of labour and capital to be made abundant sources of profit.


Cork is certainly a splendid city. Its situation, the general picturesqueness of its appearance from a distance, its streets, shops, inhabitants, and trade, surpassed, in my estimation, any other city or town in Ireland, not excepting Dublin. Delighted as I was with what I saw, much yet remained for me to see. Among other things of interest, Cork contains a Royal Literary Institution, with Library, Museum of Minerals, and Agricultural Implements; a Society of Arts, and a well-conducted county Jail. On leaving Lloyd's Hotel, I found at the bottom of my bill an invitation in these words, "Please come again." I have not an opportunity of giving an opinion of the inns in Cork generally; but if Lloyd's may be taken as a favourable specimen of the rest, I should have no hesitation whatever in recommending



---

p.151




any of them. The charges were — for breakfast and bed 1s. 6d. each, and for dinner 2s.


At a short distance from Fermoy, on the right of the road to Cahir, are the ruins of the Carrickabrick Castle, and Cloughleagh Castle in Moor Park estate; the latter of these belongs to Lord Mountcashell.


Between Kilworth and Mitchellstown the land is exceedingly poor, and as badly managed as it is poor. A few miles from the former place, on the left of the road, are the ruins of Kilcolman Castle, celebrated as the residence of Edmund **Edmund Spenser**. This great poet first visited Ireland in the summer of 1580, as Secretary to Lord Grey, on his being appointed Lord Lieutenant; but two years afterwards, Lord Grey being recalled, **Spenser** returned with him to England. In the year 1586, the poet received from Queen Elizabeth a grant of 3028 acres of the forfeited lands of the Earl of Desmond, and returned to Ireland to cultivate them — this being one of the conditions of the grant. He took up his residence at Kilcolman Castle, where he composed several of his poems; among others,



---

p.152


Colin Clout's come home again, which bears the following date — "from my house of Kilcolman, the 27th of December, 1591." The three first books of the Faerie Queene, were completed at this delightful residence. It has been generally supposed that the whole of this great poem was composed here, but this is manifestly an error; for on the 10th of April, 1580, we find him requesting his friend Gabriel Harvey to return it, *with his long-expected judgment on it.* The river Mulla, which flows through the grounds of Kilcolman, is mentioned by **Spenser** in several places. The rebellion of Tyrone, which broke out in 1598, drove him and his family from this picturesque and now classical spot; the house was burnt by the rebels; and, in the confusion incident to a precipitate flight, one of the poet's children, an infant, was left behind, and perished in the flames. **Spenser**, it is well known, died in London soon afterwards, at the age of forty-five.


At Kilcolman Castle, this illustrious man was visited by one of the most distinguished of his contemporaries, **Sir Walter Raleigh**


---

p.153




in Mr. Campbell's biography of the author of the Faerie Queene, relating to this interesting interview, may be inserted here. It puts an obvious reflection in a striking light. "When we conceive Spenser," says Mr. Campbell, "reciting his compositions to Raleigh, in a scene so beautifully appropriate, the mind casts a pleasing retrospect over that influence which the enterprise of the discoverer of Virginia, and the genius of the author of the Fairy Queen, have respectively produced on the fortune and language of England. The fancy might even be pardoned for a momentary superstition, that the Genius of their country hovered, unseen, over their meeting, casting her first look of regard on the poet, that was destined to inspire her future Milton, and the other on the maritime hero, who paved the way for colonizing distant regions of the earth, where the language of England was to be spoken, and the poetry of **Spenser** to be admired."


It was the fair-day at Mitchellstown when we passed through it, and we had an opportunity accordingly of seeing great numbers of the country



---

p.154




people. Here, as elsewhere, their countenances and general conduct indicated the greatest vivacity, cheerfulness, and good humour. The town belongs to the Earl of Kingston, whose castle, of which we caught a glimpse through the trees that surround it, seemed to be a splendid building. It was erected in 1823. The grounds are very beautiful, and the public are liberally allowed free access.


The labourers here, when employed, have sixpence per day and diet. The single men go to Mitchellstown on a Sunday to hire for the week, and get 1s. 6d. or 2s. and diet, per week. For a house and garden they pay from thirty to five-and-thirty shillings; for conacre-ground, £5 per acre. The ready-money price of potatoes is 3d., the credit price 5d. per stone; the price of pork is 2 3/4d. per lb.


Nearly opposite Clogheen are the remarkable Kingston Caves, which were discovered five or six years ago by a labourer who was getting stone on the surface. These caverns are extremely curious; the principal one is reached by a descent



---

p.155



of some difficulty — by creeping, sliding, and passing through some minor and dark caves — and ultimately by the assistance of a ladder. Here the lights, which of course are indispensable on such an expedition, produce a brilliant effect, the whole interior of the cavern being covered with spars and glittering rocks; from the centre rises a huge mass of spar, which ascends towards the top, and joins the sparkling stalactites which depend from the roof. From this inner chamber, several passages, low and dark and narrow, diverge, and conduct to subsidiary recesses of equal brilliancy. There are some cairns about a mile or two from these natural curiosities.


This part of the country, though barren and wild, is rendered interesting by the Knockmeledown Mountains, on the border of the county of Waterford on the right, and the magnificent Galtee Mountains on the left. Shanbally Castle (the property of Lord Lismore), surrounded by noble hills, their slopes ornamented with wood, is seen on a beautiful bank on the right: and near this delightful spot, and not more than


---

p.156





a quarter of a mile from the newly-discovered Kingston Caverns, is the Cave of Oonakareaglisha, or a natural vaulted cavern, 100 feet long, and 70 feet in height. This cave, and the passages that conduct to it, are, like those previously mentioned, abundantly ornamented with sparry stalactites. To the right also are seen the ruins of Burnt Court, the property of Lord Lismore, but anciently belonging to the Everard family. This mansion was destroyed in Cromwell's wars.


The land adjoining the left of the road is moory and badly cultivated; no little green patches of turnips, rape, or clover, greet the eye; no small allotments of land, as in Armagh and Tyrone. The want of these blessings is evident; for although Lord Glengall, who is the owner, and a resident, has built respectable cottages for labourers, they have every appearance of misery; and hoards of ragged children turned out as we passed, and followed our car for a long way, in hopes of obtaining a few half-pence. Under its present culture, the ground barely returns the seed potatoes; if managed according



---

p.157




to Mr. Blacker's plans, it would, I am satisfied, yield treble the produce, and the time of the children would be profitably engaged. The formation, which for some distance from Mitchellstown, is limestone, is here sandstone or grit. After heavy rains, rapid torrents cross the roads, and frequently sweep away the bridges.


The whole of the ride from Rathcormack affords great variety and interest; abounding in gloomy ruins of ancient castles, and in mountains of curious and picturesque appearance.




---

p.158


Approach to Cahir — The Castle — Lord Glengall's cottage at Kilcommon — Cahir — Tipperary — Mr. Bolton, Lord Stanley's agent — Description of his lordship's estates — Peaceable disposition of the people — Lord Stanley's character as a landlord — Produce and prices — Burial of the dead — Outrages — Unwholesome potatoes — "Driving" — Conacre — Withdrawal of capital — Dairy farms — Agriculture of the district — Golden Bridge — Thomastown — Lady Malpeson — Ancient Castles — Arrival at Cashel — Land-agent of Sir John Fitzgerald — Obsequious manners of the tenants — Visit to the ruins.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The immediate approach to Cahir is distinguished by immense barracks, so large, indeed, that I mistook them for the town itself. The most remarkable object on entering the town, is Cahir Castle, the property of Lord Glengall. This ruin is exceedingly interesting, and of great antiquity, having been originally built, I believe, in the year 600, by Conan, king of Thomond, and monarch of Ireland. It rises from the rocky bed


---

p.159




of the river Suire, which flows through his lordship's estate. Its grey towers are wreathed with ivy, and its portcullis and dungeon-keep still remain as mementos of periods of ferocity and bloodshed. A neat cottage, and garden abounding with rhododendrons and other beautiful shrubs, adjoins the castle, and, along with part of the holme land, is occupied by Captain Brogden.


At Kilcommon, about two miles down the river, Lord Glengall has an ornamental cottage, situated on a knoll covered with arbutus, laurels, and a variety of choice shrubs and plants, interspersed with lawns and bowers. This enchanting spot is close to the river, across which I was ferried by an ancient dame. The cottage is very tastefully decorated with ivy, woodbine, and roses, the roof being of the neatest thatch, and the floors inlaid with walnut, intermixed with other woods of various colours. As a display of ingenuity and skilful workmanship,this cottage merits the highest encomiums; but its chief interest is attributable to the extreme beauty of the surrounding country — being planted in an ever verdant valley, watered 



---

p.160




by the Suire, whose banks are celebrated for the variety, as well as the uniform picturesqueness, of the scenery they exhibit. I cannot help thinking that the present cottage obtrudes too distinctly upon the quiet and secluded character of the adjacent country, disturbing the otherwise perfect harmony that prevails in this delightful spot. Probably, something in the shape of a hermitage, hollowed out of the rock, and all but entirely hidden from view by the wild plants about its roof and entrance, would have been least at variance with the sequestered place.


Cahir is a prettily situated town. Some extensive flour mills upon the river are conspicuous objects, and give an air of importance to the place. The people, however, are poor, and the labourers not fully employed. Wages, in harvest and potato time, for about a fortnight, amount to 10d. or 1s. per day, at other times employment is not easily obtained. The best white wheat was selling at 1s. per stone, and oats at 7 3/4d. The produce of an acre of wheat was stated to be 5 1/2 barrels of 20 stones, and of oats 7 barrels.




---

p.161




The rent of the best holme land by the side of the river is 50s., and of the average arable land 20s. per acre.


At Tipperary, the population of which is from seven to eight thousand, I took up my abode at Barry's Hotel, and the next morning proceeded in an old gig, driven by a man with little more than half a coat, to the residence of Mr. Bolton, Lord Stanley's agent at Ballykisteen or Goaterstown, three or four miles from the county town. Mr. Bolton, whom I was fortunate in finding at home, supplied me with a horse, and accompanied me round the estates. The land is of excellent quality, being part of the golden vein of Ireland — a district reaching from Tipperary towards Limerick. The extent of the golden vein is about fourteen miles long, by six or seven wide, and the soil varies in depth. In the particular spot which I examined, and which was stated by Mr. Bolton to be equal to any in fertility, it was fourteen inches deep, and of fine free garden mould, of a dark brown colour, upon a subsoil of lighter coloured loam, mixed with fragments of limestone. In many parts, the same



---

p.162




kind of soil rests upon limestone rock, and is covered with the richest verdure imaginable. The grasses of which it is composed are the **dactylis glomerata**, **festuca pratensis**, **lolium perenne**, and a mixture of **poa**s. The rent is from 30s. to 40s. per acre. Great improvements had taken place on Lord Stanley's estate; by the erection of several new houses of a respectable description, and by the encouragement of the growth of turnips and clover, and the alternate system of corn and green crops. His lordship offers premiums for cattle, drains, hawthorn hedges, clean offices, potatoes in the drill, clover, garden vegetables, and bees. In 1835, the value of the premiums presented, amounted to upwards of £60. The premiums are given either in money or agricultural implements, at the option of the receiver. If implements are taken, 20s. per cent additional is allowed upon the cost prices. Lord Stanley extends his liberality beyond his own farmers; any person, not being a tenant of his, but resident within ten miles of Tipperary, on payment of a small sum, is privileged to become a candidate.



---

p.163




His lordship's estate, on which there are only two or three middlemen, contains 7250 acres, and lets for £6500 per annum. I was much gratified to hear from Mr. Bolton, that the people were docile and easily managed, and that although he was living in the heart of what is considered the most turbulent part of the kingdom, and had occasion to travel at all hours, he had never been disturbed or intimidated, and did not feel the slightest apprehension. This is a strong additional proof, if any further proof were needed, that if a conciliatory policy, in unison with the great principles of Christianity, were uniformly adopted, both by the legislature and by individuals, towards the people of Ireland, disturbances would in a great measure cease to alarm the country, and extensive police and military establishments be rendered unnecessary.


Lord Stanley has the character of a good and kind landlord; some years ago he remitted the rent of several of his tenants, and gave them money to enable them to go to America. He also endeavours to compensate for his unavoidable 


---

p.164




absence during the sitting of Parliament, by residing in Ireland during a considerable part of the recess; this residence he devotes to the improvements of the country, by attending the Agricultural Meeting which he has established — by promulgating, in every practicable way, an improved system of agriculture — and by encouraging cleanliness, morality, and good feeling amongst the people. If all absentees were like Lord Stanley, Ireland would speedily be restored to prosperity and peace.


It is not many years, Mr. Bolton informed me, since some of the farmers considered manure in the light of a nuisance; all, however, have now discovered their mistake, and admit its utility. The produce of grain in this district is equal to that of any land in Ireland; of wheat, it is eight barrels per acre; oats, from ten to twelve. Garden ground near Tipperary lets for eight guineas per acre. Farms of fifty or a hundred acres, six miles from the town, are worth 40s. per acre: arable land, beyond that distance, lets for from 25s. to 30s. per acre. For a plot of bog,



---

p.165




or fuel, seven yards long and three wide, and as deep as the taker pleases, the sum of 20s. is sometimes given. Most of the farms in this county are in the hands of middlemen. Wheat was selling at 10d., oats 7d., and potatoes 2d. per stone. The general price of coal was from 15s. to 20s. per ton; it is sometimes 25s. For the rood-ground, or conacre, when it is manured stubble, the labourer pays five guineas per acre, and eight guineas when it is manured pasture; but when the labourer manures it, he pays from three to four pounds per acre only. These are considered good bargains for the farmers. They are, at the same time, frequently good bargains also for the labourer or taker. For instance, on Lord Stanley's estate, a field of grass land was let for conacre potatoes, by a farmer in 1835, at the rate of £12 the Irish acre. The farmer provided neither manure nor labour; and yet the taker, after paying rent and every expense, cleared £16 per Irish acre.


Many instances of great destitution and misery were related to me. Mr. Bolton mentioned a



---

p.166




distressing circumstance that had come within his own experience a short time before. A poor widow, a Roman Catholic, having lost her son, applied to him for the loan of five shillings to pay the priest for blessing the clay, as she could not bear the idea of burying her son without this benediction. The desired sum was of course willingly supplied, and the poor creature's heart leapt for joy as she exclaimed — "I can now bury my dear son." Poverty is felt to be indeed a terrible power, when it is the means of withholding from the dead the respectful tribute of surviving friends.


Only two outrages, I learnt, had been committed for a considerable time: one was upon Mr. Banner, of Banshaw, a Protestant Rector, whose servant was suspected of assaulting him; the other, upon the person of Mr. White of Goulden, near Cashel, because he had pressed for tithes; several shots were fired in at the window, and he had a narrow escape.


In the examination of the barony of Middlethird, which lies nearly equi-distant from Cahir, Cashel, and Tipperary, it was given in evidence,



---

p.167




that the principal food of the labourers is white potatoes or lumpers, and that in periods of distress, they find the greatest difficulty in procuring provisions on credit. Solvent security is demanded, and one or two days' work is to be given to the person who secures. The labourer is generally obliged to agree to pay double the market price. In this barony, as well as in many others, great injury results from the use of potatoes that are unfit for consumption. The Rev. Mr. Molony had known a great number of deaths in consequence of this unwholesome food. In the last season of scarcity, the distress was so great, that subscriptions, for the purpose of buying oatmeal, were made among the farmers and landlords. The greater landlords being absentees, nothing, except in one instance, was contributed by any of them.


In the month of July it is customary for the "driver" to go round, and take a list of pigs and stock of the tenant. The tenant must account to the landlord for the sale of the pigs, and further give up to the driver the ticket of his corn. It is



---

p.168




usual for the driver to accompany the tenant to market, and, when the corn is sold, to receive the payment instead of the tenant.


Many of the farmers are in the habit of paying their servants by letting them conacre. The average produce of an acre of potatoes is 60 barrels of 21 stones (14 lbs. to the stone), and the greatest usual crop is 80 barrels, without calculating the small potatoes reserved for seed and pigs. When the produce of the conacre is not worth the rent, starvation or begging is the necessary consequence. The labourer is not allowed to surrender his crop in lieu of rent, though he should thereby forfeit seed and labour.


It did not appear that any instances of the withdrawal of capital had occurred in consequence of the dreadful outrages which were detailed; though, according to the testimony of Mr. Clarke, a magistrate, there were several who would be glad to do so, provided they could get what they had expended on their lands. The same gentleman declared, that if he could sell his own property for the capital which he had invested



---

p.169




in it, he would most assuredly leave the country and go to England. Land still sells as it did twenty years ago — from 20 to 25 years' purchase.


In confirmation of the opinion that many of the outrages committed are attributable to want of employment, one of the witnesses stated, that some years ago the parish of Dullymaine Fethard was very much disturbed, but that since a gentleman, who employs from forty to fifty labourers daily, has settled there, it has become one of the most peaceable places in the county.


But few labourers are employed by the dairy farmers. They employ a woman to every ten cows. The quality of the butter is good; it is always packed up after each churning, and is sold at Clonmell. The common Irish cow being considered the most hardy, is the favourite. Stall-feeding is not practiced in the district. Rent has been reduced of late years, to the amount of 20 or 30 per cent; many landlords have made reductions, and those who have not, dare not receive the whole stipulated rent.


A large part of the barony of Middlethird is a



---

p.170



rich loam, lying on a rocky limestone substratum, and is equally adapted to tillage or pasture, but the greater part of it is now under the plough. The quantity of bog or waste land is very inconsiderable. This scarcity and consequently high price for fuel, is severely felt by labourers and farmers in the southern part of the barony. The Bog of Allen extends along the northern edge, and presents an inexhaustible supply of fuel to all the district within reach of it.


The course of cropping is uniformly severe. Potatoes, wheat, and oats, form the series, and it is repeated, if the land will bear it. Potatoes are manured, and perhaps limed; want of manure forms the great deficiency of all farmers, and this chiefly arises from the quantity of ground annually set with potatoes. The farmers state that they employ a man to every eight or ten statute acres ploughed. The warm and moist climate of Tipperary is favourable to the production of a superabundance of luxuriant grass, and causes the meadows and pastures to appear superior in quality to what they probably



---

p.171




are, and the grass may yield proportionally less nutritive matter than that produced in a drier climate. An English farmer would consider the hay here to be very much overgrown. It stands till the top is one uniform dead brown, and is not generally cut till August. Very little labour is bestowed in the throwing it about, or opening it to the air or sun. It is made rather by a series of gentle fermentations than by the sun and air; being put in small stacks in the field, to remain several weeks. From the moist nature of the grass, it is necessary to give the hay more time before it is put together in large quantities, yet great waste is the consequence of these small stacks being left so long in the wet meadows.


Being desirous of reaching Cashel during daylight, I was obliged to leave Mr. Bolton's much sooner than either his hospitality or my own inclination would have suggested. I returned in the same old, rattling, dirty gig in which I went; it was tied together with cords, and conducted by the tattered driver; but the horse now presented the rare disposition of cheerfulness; and the grotesque



---

p.172




appearance of the conveyance, which in some of our English towns would have occasioned more fun and merriment than the richest exhibition of the mountebank, was in Ireland not sufficiently removed from the ordinary course of things to attract attention. We again passed through the town of Tipperary, on our way to Cashel. On Kilfeakle Hill, to the right, is a considerable Rath, in a very commanding situation, close to the road, and, on the left, is an old Roman Catholic chapel and grave-yard. The grave-stones are covered with various devices and emblems of the crucifixion — the ladder, nails, hammer, and other tools.


Near to Golden Bridge, over which we crossed the Suire, is Athassel Abbey. Thomastown, a small village composed of many neat cottages, and gardens, with climbing shrubs in front, pleased me greatly. This village owes most of its advantages to the benevolence of Lady Elizabeth Malpeson (sister to the Earl of Llandaff), whose unceasing attention to the wants and comforts of the poor, entitles her to be ranked among the



---

p.173




most distinguished of the benefactresses of Ireland. She has the satisfaction of residing among a grateful people, who respect and love her. Contiguous to the village is her ladyship's mansion, surrounded by an extensive park, which contains what is certainly a rarity in Ireland, a number of fine trees. The ground is rich and undulating, and contains upwards of 2000 acres. Lady Malpeson is fond of planting and improving the grounds.


Close to the road are the ruins of two ancient castles. Ireland is indeed the land of castles, whose ruined walls but too well correspond with the devastation that man has caused his brother man in this most interesting but harrassed country.


It was night before I arrived at Cashel, but the moon, mingling with a sweet twilight, showed to great advantage the magnificent ruins of the Abbey, the Cathedral, the Pillar Tower, and Chapel, that are piled upon its celebrated rock.


On reaching the inn, I was conducted to an apartment where a gentleman, a land-agent, was receiving rents for Sir John Fitzgerald. He



---

p.174




kindly over-ruled my apology, and insisted upon my remaining in the room. This invitation suited my views precisely, and was in fact a greater favour than he could be aware of. One tenant after another made his appearance, with humble bow and reverential demeanour; — some paid, others only promised to pay, and one or two had actually the courage to declare that the rent was too high. The manners of this agent impressed me with the conviction that he was haughty and tyrannical, and deficient in the milk of human kindness: and, under the sort of treatment which they received at his hands, the tenants were servile and dispirited, crouching and mean. One of them, on entering, said, "You're welcome, your honour, and long may your honour want trouble, your honour." — Another exclaimed, "Please your honour, I'll pay at Candlemas, your honour, please God." One, who prided himself upon prompt payment, said, "Long may your honour live; I hope to see you often." The bailiff attended with great solemnity and importance, and on receiving his several orders, replied, "Yes, please



---

p.175




your honour; I will, please God." I thought of what the venerable Mr. Hodgson had said, that "the landlords were everything, and the tenants nothing."


The business of the agent being concluded, we became better acquainted, and I found him to be an agreeable and affable gentleman. We dined and spent the evening together, and as I had not visited the ruins on the hill, and, having to leave Cashel at two o'clock in the morning, we engaged guides with lights for the purpose of inspecting the interior.


Our way lay through dark passages and cloistered aisles — among Saxon and Norman arches, perfect and ruined, and of every variety of size — and over fragments of sacred architecture, now prostrate on the ground. Cormac's Chapel, so called from the founder, Cormac-Mac-Culinan, King of Munster, and Archbishop of Cashel in the tenth century, is the most ancient of this venerable group of ruins, and is an exceedingly interesting place. Some of the stone-work is elaborately and very beautifully executed, and



---

p.176




exhibits, among other things, grotesque heads and effigies carved out of black marble. Some of the arches, pillars, canopies, and monuments, have been formerly gilt, and parts of the gilding still remain. One large square tower, at the west end of the pile, seemed to be the favourite abode of owls, numbers of which, startled by our presence, forsook their secure abodes amongst the ivy, and filled the air with discordant screams. We did not leave the ruins till after one o'clock; and, before we departed, made our way to the summit of the tower, from which an extensive and beautiful view is commanded. To us, however, it was denied; yet I know not whether the loss of richly cultivated valley land, picturesque mountains, streams, and pleasure-grounds, was not compensated by the indistinct, soft, and silvery landscape we beheld, with its dim and visionary distance.


Donald O'Brien, brother of Morough O'Moore, King of Munster, was the founder of the present Cathedral, A.D. 1169. St. Patrick is said to have founded the first church: it is also said



---

p.177




that the *Lia* Fail, or coronation-stone of the Kings of Munster, was sent from Cashel to Scotland, and thence to Westminster Abbey, and placed under the coronation chair by Edward the first. One side of the rock on which the ruins of Cashel stand, is almost inaccessible.


The Episcopal Palace is said to contain the celebrated Psalter of Cashel, in the Irish tongue, compiled about the year 900, by the previously-mentioned Corinac-Mac-Culinan, King and Archbishop of Cashel.


A short distance from the rock, are the remarkably fine ruins of Hore Abbey. The town (formerly the city) of Cashel lies round one side of this remarkable rock. In 1320 it was inclosed by a wall, and was an important and populous place. The town now contains only 7000 inhabitants, and retains but little of its former importance.




---

p.178


Departure from Cashel — The Garden of Ireland — Urlingford and Johnstown — Round Tower of Fertagh — Castle Durrow — Brockley Park — Athy — Kildare — St. Bridget's perpetual fire — Round Tower of Kildare — Old Kilcullen — Quaker Settlement — Naas — Palmerstown — Bishop's Court — Oughterard Round Tower — Rathcoole — Account of Irish Castles — Return to Dublin — Mr. Petrie's museum of Irish antiquities — Round Towers — Vaults of St. Michan's church — Bodies preserved — Departure from Dublin — Military Road — Lough Bray — Arrival at Roundwood — Anecdote of Sterne — Glendalough and the Seven Churches — Kathleen and St. Kevin — The Conaderry Mountain — The Seven Churches — Singular tradition — St. Kevin's Kitchen — Glenmalure — Lead mines — Vale of Ovoca.
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


After visiting these interesting ruins I left Cashel by mail, being obliged to meet the Board in Dublin on a stated day. The moonlight afforded me a partial view of the country — just sufficient, and only just sufficient, to make me wish that I could have seen more of it. Killough Hill and its Castle, the property of Lord Plunkett, were occasionally discernible on the left, rising out of the vast bog that surrounds them. The extraordinary



---

p.179



fertility of that hill has obtained for it, in the immediate neighbourhood, the name of The Garden of Ireland. It is said to produce a great variety of herbs.


For a considerable distance the road lies over a dreary bog — part of the extensive Bog of Allen. After entering the county of Kilkenny, we passed through Urlingford, a small village containing the ruins of an Augustine convent founded in 1306; and thence through Johnstown, a small post-town of Kilkenny, of about 900 inhabitants. The Round Tower of Fertagh, to the left, appears to be cylindrical, and does not taper upwards, like most of these structures. The height, according to **Ledwich**, is 112 feet; the width 48 feet; and the thickness of the walls, 3 feet 8 inches. The door is ten feet from the ground. From the road, the tower appears to be situated on a plain of some miles of dreary moor.


We passed the domain and fine woods of Lord Ashbrook, of Castle Durrow — the wood extending for three miles — and breakfasted at Stradbally, the country about which place is beautiful, fertile,



---

p.180



and well wooded. Brockley Park, seen on leaving Stradbally, is the property of the Earl of Roden. This is one of the few places in which I could have believed myself in England. The grounds are exceedingly beautiful, with a due admixture of fine wood. Turnips in drills, good pastures grazed by handsome cattle and Leicester sheep, are gratifying sights to the agriculturist travelling through a country in which his favourite art is but seldom seen to advantage. On the left, we passed Mr. Welch's property, on which I had the pleasure of seeing a number of good Durham cattle. On the right some excellent agriculture is exhibited; drilled turnips, and drilled wheat, and hurdles made of hazel, designed for the purpose of confining sheep to eat the turnips.


The town of Athy (in the county of Kildare) stands on the river Barrow, which takes its rise about the bogs of Philipstown, flows through Carlow and Ross, and joins the Suire below Waterford. Athy has the advantage also of the Grand Canal, and passage-boats to Dublin and Waterford. The town, on the left of which stand the 



---

p.181



remains of Woodstock Castle, is the property of the Duke of Leinster, and contains about 5000 inhabitants. About four miles to the left, in an extensive plain of several thousand acres, is seen the town of Kildare, so celebrated for its ruined abbeys, raths, and the nunnery of St. Bridget, founded in the year 500. Within the walls of the nunnery she is said to have established the "perpetual sacred fire," the rite appertaining to which was not finally abolished till the dissolution in the sixteenth century. It still retains the name of the Fire House. The orders of the Grey Friars and White Friars were instituted at Kildare. Several famous princes of Ireland abdicated, and became Abbots of Kildare. The Round Tower in the church-yard, is, according to Leigh, 130 feet high; but **Ledwich** states it to be only 110. The town and suburbs, and the beautiful green slopes of the Curragh of Kildare, present a picturesque appearance from the road. The day was remarkably fine, and I could discern Croghan Hill, near Philipstown, Mount Mellick, and the Slieve Bloom Mountains. The Hill of Allen, from which the Bog of Allen


---

p.182




derives its name, was very conspicuous. On this hill (the ancient Temora) is a cave, said to be the burial-place of Oscar.


Passing through Old Kilcullen, an ancient place, once fortified with a wall and seven gates, one only of which remains, an old grave-yard and one of the round towers attract attention. The tower is only about half its original height.


Three miles north of Old Kilcullen, is the market town of Kilcullen, on the river Liffey. A lease of the abbey and lands was granted to **Spenser** in 1582. On the hills, north of the town, General Dundas defeated the insurgents in 1798, and a green mound on the road side was pointed out to me as the place where the slain were buried. Castle Martin, and several other seats are seen in the neighbourhood.


We passed within a short distance of Ballytore, of which Leigh remarks, "Quakers settled this rural site on the banks of the river Gris; and, as in other Quaker and Moravian settlements in this kingdom, they studied the neat improvement of hedge-row avenues, rising out of well trimmed



---

p.183



quickset hedges, and surrounded their comfortable cottages with fruits and flowers. Here the eloquent **Edmund Burke** acquired the rudiments of learning."


The town of Naas lay in our way; it is on elevated ground, was once fortified with strong castles, and was the residence of the kings of Leinster. Its name implies, "the place of the Elders." In the vicinity of the town is a ruined castle, belonging to the Duke of Leinster. Jigginstown House is also a short distance from Naas; it was built by the Earl of Strafford. This mansion, I have been informed, was upon a splendid scale; the extravagance imputed to the Earl in erecting it, formed one of the charges against him.


Near Johnstown, about sixteen miles from Dublin, is Palmerstown, the ancient family seat of the Earl of Mayo; to the left, and about a mile further, Bishop's Court, a splendid place belonging to Lord Ponsonby. Oughterard Round Tower, which has only 25 feet in height now remaining, is also seen to the left: and a little nearer Dublin is the Hill of Lyons, rising out of a comparatively flat country, 



---

p.184




and necessarily commanding an extensive prospect. This hill is on Lord Cloncurry's estate.


At Rathcoole, in the county of Dublin, a poor town, I observed, as well as in many of the Irish towns, at almost every door a board inscribed with the word "BEDS," in large and distinct characters. The appearance of the houses to which this notification was affixed, was generally such as to justify a doubt whether they could supply even the fraction of a bed to the regular inmates — to say nothing of strangers.


About six miles from Dublin the Tower of Clondalkin rises picturesquely from amidst trees. The height of this tower, which appears to curve inward from the base, is said to be 84 feet. Newlands, Lord Kilwarden's, and the ruins of an old castle, we passed on the right, and reached the Dublin Post-office at two o'clock on the 4th of November.


**Ledwich** thus accounts for the abundance of castles in Ireland — "The colonization of this Isle by English settlers was a scheme steadily pursued for many centuries, and particularly by



---

p.185




the ministers of Queen Elizabeth, who obliged every grantee to construct a castle, fort, or bawn, for the protection of his family and tenants." A bawn is described as a close fast place, and often a fort, from the Teutonic bawen, to construct and secure with branches of trees. "On the escheating of Ulster by the flight of Tyrone and Tyrconnell in 1606, King James, treading in the steps of his predecessors, bound each undertaker to the performance of these conditions. If, for instance, he had 2000 acres, he was expected, within two years, to build a castle with a strong bawn or court about it. If 1500 acres, he was to erect a stone or brick house, with a court or bawn; if less, merely a bawn. Thus Lord Aubigny had 3000 acres; on these he made a strong castle of lime and stone, five stories high, with four round towers for flankers; the body of the castle was fifty feet long, twenty-eight broad, and the roof was slated. Adjoining it was a bawn of lime and stone, eighty feet square, with two flankers fifteen feet high. The castle stood at the junction of five public highways, and kept the neighbouring



---

p.186




country in subjection. William Hamilton had 1000 acres; on these was a bawn of lime and stone eighty feet square, with two round towers for flankers. Within the bawn was a house of lime and stone, thirty-six feet long, and twenty broad. In consequence of these resolutions of Government, there were constructed, in the six escheated northern counties, in the space of a few years, one hundred and seven castles with bawns; nineteen without bawns; and forty-two bawns without either castles or houses. The grantees of escheated land in every other part of the kingdom were bound to build in like manner. Speaking of Lord Strafford's administration **Borlase** observes that 'multitudes of British were brought in and planted even in the most barbarous places; many corporate towns were erected, and some walled towns built; and castles, stone houses, and villages, daily made in every part in great abundance.' By these means castles multiplied prodigiously, there were more in this island than perhaps on an equal surface in any other part of the world. I can reckon the remains of eighty in



---

p.187




Queen's county, and am sure there were more; so that probably there were not less than three or four thousand in the kingdom: the most decisive evidence of the rude manners and bad policy of the times. These castles appear to have been large and well fortified, and so strong as to bear a long siege, and the assault of artillery. Most of them remain, though in ruins. As for the battlemented houses and bawns, increasing civility has levelled most of them. The common square castles, the residence of English undertakers, are by far the most numerous. All these are existing monuments of the infelicity of former ages; when cruel and domestic wars convulsed and desolated the island, leaving little more than one million of miserable beings to occupy this beautiful and fertile country."


At Dublin I obtained my release from the Board, and had an opportunity of making myself more particularly acquainted with some of the details of that interesting city. I was fortunate also in being introduced to several scientific and well-informed persons of different professions, one of



---

p.188




whom, **George Petrie**, Esq., a celebrated artist and antiquary, has imposed upon me a debt of gratitude which I cannot easily discharge. This gentleman, who possesses a valuable museum consisting of numerous specimens of ancient Hiberno-Phoenician weights and money, musical instruments, weapons of war, rings, urns, &c, gained the prize offered by the Dublin Society for the best essay on Round Towers. This essay, I am sorry to say, is not yet published.


According to **Ledwich**, Ireland contains sixty-five of these remarkable structures; but several others, which he has not particularized, might be added to the number. They are from 70 to 130 feet in height, and from 41 to 55 feet in circumference, outside; the thickness of the walls varying from 3 to nearly 5 feet. The doors are generally from 10 to 20 feet from the ground, and cannot be entered without stooping. Volumes have been written upon the subject of these extraordinary enigmas; each writer starting his own favourite conjecture, pursuing it with zealous enthusiasm, and surrounding it with as much learning and ingenuity



---

p.189



as he was able to bring to the investigation of the topic. Hitherto, with the exception of **Mr. Petrie**'s researches, the learning and labour bestowed upon what may be called "The Irish Puzzle," have failed to discover a satisfactory solution. The learned and accomplished author of the prize essay alluded to, is understood to have clearly ascertained that the Round Towers are of Christian origin, and designed for the two-fold purpose of belfries, and towers, in which were deposited the books, sacred vessels, and other property, of the religious communities which erected them. The names of the builders of several are known: they are of various styles of architecture, and of similar workmanship to the adjoining churches; and the date of their erection is ascribed to the period included between the sixth and the twelfth centuries. That of Clones, the most ancient of any, is of the sixth century. The current assertion, that they invariably contain four windows at the top, and that these windows correspond with the cardinal points of the compass, is altogether a mistake; the fact being,



---

p.190




that the number varies from three to eight. The top windows, (for there are occasionally others) are the largest, and are six feet in length. The towers had always floors — frequently possessed double doors — and some of them were capable of containing one hundred and eighty persons. They were sometimes set fire to, and the inmates burnt. The Round Towers at Abernethy and Brechin in Scotland, resemble those of Ireland, and are of corresponding date.


I was desirous, before leaving Dublin, to visit the vaults under St. Michan's Church, situated in Church-street; and, being politely furnished by the Rev. T. R. Shore with a note to the sexton, who has the custody of the keys, I proceeded, in the company of that dignified official, who provided lights, to survey one of the most extraordinary exhibitions that can be presented to the curiosity of a stranger. On each side of the cold and dreary passage along which we walked, vaults are ranged; some of these are securely locked by the owners; of others my companion possessed the keys, and into several we entered. The sight was an astonishing



---

p.191




one. Scarcely could I believe that I walked amongst corpses. The bodies were laid on the floor — some having the bottom of the coffin only, others part of the sides, and some without even a remnant of a coffin about them. The extraordinary state of preservation exhibited in these bodies, excites the ingenuity of the scientific, no less than the curiosity and wonder of the uninitiated. The skin is as firm as parchment, and the form of the features well preserved; the sinews and joints, and the finger and toe nails, are perfect. Bodies deposited here some centuries since, it has been said, are still in so high a state of preservation that their features are discernible, and the skin and bones quite perfect. The floor and walls of these vaults are perfectly dry, and the atmosphere apparently as pure as that of the best ventilated apartment. In one vault are shown the remains of a man at the advanced age of 111. This corpse has been thirty years in its present silent abode, and although there is scarcely a remnant of the coffin, is as completely preserved, with the exception of the hair, as if it had been embalmed. In the 


---

p.192




same vault are to be seen the bodies of two Roman Catholic clergymen, which have lain fifty years there, even more perfect. The bodies of the two ill-fated brothers, the Sheares', who were executed for the part they took in the rebellion of 1798, had been removed, on the very day I visited these silent and solemn abodes, from the vault they had previously occupied, to another vault; and there they rested, one upon the other, their heads lying near them. The jail shells in which they had lain, had crumbled to dust. These ghastly relics, far from producing an unpleasant feeling, were invested with a sort of fearful and riveting interest; and I experienced an emotion somewhat resembling that of regret, when obliged to leave the awful chambers to which they were consigned.


On the 21st of November, 1836, I again left Dublin, and took a car to Roundwood, a distance of about twenty-six miles, the charge for which was 20s. — the driver's fee being usually from a penny to three halfpence an English mile. We took the military road through the centre of the county of Wicklow, over a most dreary district of



---

p.193



bog and moorland. For many miles scarcely a cabin or a house of any sort is to be seen. This road was formed on scientific principles, having a suitable convexity, and being lower at the part adjoining the rising ground, with a small ditch, moreover, which prevents the water from the hill running over the road. This, as well as transverse drains, of sufficient capacity to carry off the water freely during heavy rains, is an important matter to be attended to in the formation of mountain roads.


The **Rev. Mr. Wright** informs us, that the rebellion of 1798 disturbed the industrious habits of the country so materially, that government thought it expedient to erect barracks, and place garrisons in the very centre of the fastnesses of Wicklow, in order to prevent the outlaws from keeping possession, and to hold the mountaineers in awe. The sites chosen were Glencree, Laragh, Glenmalure, and Aughavanagh. The buildings once raised, it became necessary to form modes of approaching, of a more practicable nature than the mountain pathways; to effect this, a regiment of Highland fencibles was directed in 1799 to encamp



---

p.194




on the summit of the mountains, in the chain already mentioned, and perform the required task, of cutting a road, upon very improved principles, from the village of Rathfarnham to the barracks at Aughavanagh. The **Rev. Mr. Wright** further states "that after the completion of this work of utility, beauty, and ingenuity, it was proposed to the Earl of Hardwicke, the then Lord Lieutenant of Ireland, to colonize the mountainous districts through which the road runs, with the hardy and industrious race who executed this great work; and, in all likelihood, it would have been accomplished, but from the difficulty of securing to the improving tenant an equivalent for his labour upon a bishop' s lease."


Passing the little cottage or lodge, and a road that leads to Lough Bray, fifteen miles from Dublin, we ascended the military road for a mile; when, on turning round to halt — no uncommon practice in walking up long and laborious hills — we unexpectedly discerned the Lough, and had to retrace our steps down the hill. We entered the grounds of Mr. Latouche, close by the small neat



---

p.195




lodge previously mentioned, and pursued the side of the lake, till we came to his Gothic cottage, pleasantly situated near the head of the Lough. The beauty of Lough Bray is enhanced, near the head, by the surprise accompanying the discovery of its hidden retreat. Except for evergreens and shrubs that cluster about the house, the character of the scenery is wild, rocky, and bare. There are indeed two lakes here. The lower one is deep, and dark, and covers about sixty-three English acres; over it impends the Eagle's Nest, at the height of some hundred feet.


On approaching the borders of Wicklow, the soil becomes moory, and, proceeding southward, there is scarcely a vestige of cultivation. The subsoil is principally a sandstone gravel and clayey sand, mixed with pieces of quartz of the purest white. At the meeting of four roads beyond Lough Bray, we left this smooth military road, to encounter unexpected difficulties; we took a south-easterly direction, by a road that in many places was merely the bare bog, into which the horse and car sunk, and there 



---

p.196



they must have remained, had we not lent our assistance in extricating them. The difficulty was increased by several rapid rivulets which crossed the road, with as rough and stony beds as could well be imagined. Night, accompanied with mist, snow, and sleet, came on, and we were so long in escaping from this road, that the driver, as well as ourselves, suspected we were at fault. At last, however, to the great satisfaction of all parties, we were set down at the inn at Roundwood. The parlour (in which two gentlemen, who had just arrived, had succeeded in producing a tolerably good turf fire) was the only part of the hotel that exhibited signs of cleanliness. The kitchen, where we at first repaired to take off our dripping cloaks, was a wretchedly uninviting spot. Roundwood is within twenty-five miles of the metropolis, and being situated in a district equally remarkable for its picturesque beauties, its antiquities, and its mineral treasures, might afford a more comfortable and respectable inn. On the road to Roundwood, we passed the east end of Lough


---

p.197




Tay and Luggelaw; but, on account of the dense fog, only the nearer banks of the lake, and a small portion of the lake itself, were visible.


In the morning, we took advantage of the car on which our companions at Roundwood came the preceding day, and at their recommendation retraced their route. Passing through the hamlet of Anamoe, we crossed the river which flows from Lough Dan. It is related of **Lawrence Sterne**, that when a boy, he fell through the mill here, when the wheel was going, and was taken out unhurt. We next passed the barrack of Laragh, to the vale of Glendalough and the Seven Churches. At a small inn, close to the Seven Churches, we put up our car, and took a guide, who hurried us along the north side of the lake, pointing out St. Kevin's bed, in the opposite rocks of the lake, in the Lugduff Mountain.


With the saint's bed an affecting story is connected. Kathleen, a lady of noble birth, had formed a tender attachment to St. Kevin, who withdrew from Luggelaw to avoid her visits. Rambling one day on the mountains in the neighbourhood



---

p.198



of Glendalough, she fell in with his favorite dog Lupa, which led the way to the saint's cell. St. Kevin, according to the story, threw Kathleen into the lake. A beggar woman from one of the cottages, when we were there, pretended to personate the fair and unfortunate lady! St. Kevin was born about the year 498; the see of Glendalough was united with that of Dublin in the reign of King John. We visited a school close by, called St. Kevin's National School, the scholars in which average seventy. There are only twenty-four Protestants. The master has a salary of £10; the mistress one of £6 a year. No jealousy exists between the Catholics and Protestants. They are taught reading, writing, and arithmetic, but much learning cannot be expected when the salaries of the teachers are considered.


The Comaderry Mountain, 1500 feet above the lake, and 2268 above the level of the sea, is seen from the valley on the north side of the lake: the mica was so abundant in the rocks of clay slate, as to give to them the appearance of silver.



---

p.199



Lead mines are extensively worked in the mountains to the northward of the lake. I was informed by a gentleman well acquainted with the works, that the Luganure Mine yielded a profit for the year ending June, 1836, of £ 1,982, on 408 tons. An excellent road, composed of quartz, and glittering with small particles of lead ore, leads to these mines. On the plain in this secluded valley, are scattered monuments of the ecclesiastical greatness of former times — the ruins of the Seven Churches, within a short distance of each other. As clocks, observes the **Rev. G. N. Wright**, were unknown in early times, the hours of labour were regulated by the rising of the lark, and the lying down of the lamb. The early rising of the lark left so little time for rest, as to cause lassitude. St. Kevin's prayer that the lark might never be permitted to warble on the shores of the dark lake, was granted. Moore commemorates this tradition in the well-known song — 

> 1. By that lake whose gloomy shore
>   
> Skylark never warbles o'er.
> 






---

p.200


The valley in which this dark lake is embosomed, is between two and three miles long, being a deep ravine surrounded by impending and gloomy rocks, and heath-covered mountains, except at the eastern end, where the river flows from the lake, and by which access is gained to the romantic valley.


Of the ancient buildings in the vale of Glendalough, St. Kevin's kitchen is the most entire. The roof is of stone, the under part is arched, and a space is left between it and the outer steep and pointed roof, which is lighted by a narrow aperture. Upon the western gable rises a tower, fifty feet high, measured from the ground, having a conical roof of stone. The tall Round Tower of Glendalough stands alone, conspicuous above the rest of the buildings, and, according to **Mr. Wright**, is 110 feet high. Time, it is presumed, has divested it of its conical summit. The four windows at the top correspond with the cardinal points of the compass.


From Glendalough we proceeded to Glenmalure, "The Glen of much Ore," a few miles



---

p.201



prom Glendalough. The glen is several miles in length, flanked by high mountains. The hill at the end of the vista has the appearance of being inaccessible, and seems to oppose all attempts at proceeding. On the south side are the mountains of Drumgoff, Drumkitt, Clonkine, and others; on the north, Carriglinneen, Lugduff, Barnagoneen, Ballynafinchouge, and Ballinabarny.


The Avonbeg, a limpid stream, runs through the centre of the valley, and a waterfall of considerable magnitude flows down the mountain, near the head.


Previous to the rebellion in 1798, Glenmalure was one of the passes by which the favourite haunts of the rebels in Wicklow could be approached, and was a scene of disturbance and bloodshed. The military road terminates near Glenmalure; four large barracks, unsightly enough as buildings, but rendered absolutely hideous by association, are placed near the road, at Glencree, Laragh, Drumgoff, and Aughavanagh. The tranquillity of the country, under a system of conciliatory government, renders them useless, as regards the


---

p.202




purpose for which they were originally erected. They are now, happily, nearly empty, and are, I believe, on sale to any person who can find a use for them.


Extensive lead mines, of which an English gentleman of the name of Hodgson is the proprietor, are situated at the north-east of the glen: the Earl of Essex has the royalty. The level extends to 250 fathoms, the shaft being 90 feet below the audit level. Upwards of 140 hands are frequently employed in the mines, the ore from which is sent to Swansea, to be there smelted. In its raw state it is sold for from £12 to £15 per ton. Coal is obtained from Whitehaven, at a cost of from 18s. to 20s. per ton. Turf is sometimes used for smelting. There are two lead mines in the county of Wicklow; one at Glenmalure, the other at the Seven Churches, before mentioned.


From Glenmalure we soon entered the celebrated vale of Ovoca. The moon had risen before we passed the Meeting of the Waters, to which the beauty of the night invited us to




---

p.203



return, after being set down at the Ovoca inn. We found this inn strikingly superior to the one at Roundwood, and it has attached to it a tasteful and extensive garden, close by the side of the river Ovoca. My chamber looked upon the stream, whose soothing murmurs were interrupted by the clanking of the engines of the copper mines of Cronebane and Ballymurtagh.




---

p.204


The Meeting of the Waters — Castle Howard — The Paradise of Wicklow — The Avondale school — Copper district — The Cronehane Mines — Wages of miners — Diseases to which they are liable — Ballyarthur — Skelton Abbey — Arklow harbour — The Castle — Wooden Bridge Inn — Rustic bower — Croghan Kinshela Mountain, and the Gold Mine — Mocha pebbles — Bones of the Elk — The agriculture of the mining district — Mode of digging potatoes — Malton, Earl Fitzwilliam's seat — Astonishing fountain — Earl Fitzwilliam's attention to agriculture — Barony of Shilelagh, why so called — Tullow — Market-people — Prices of provisions — "Dry Lodgings" — Road from Tullow to Carlow — Lunatic Asylum at Carlow — Roman Catholic Cathedral and College — Withholding the Bible from the people.
-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


In the morning we revisited the Meeting of the Waters, rendered familiar to everybody by Moore's Melody, beginning,


> 1. There is not in the wide world a valley so sweet
>   
> As that vale in whose bosom the bright waters meet;
> 



The Avon and the Avonmore here meet, amidst 
the most delightful scenery — the side of the river 



---

p.205




and the adjacent land, and the undulating hills in the immediate vicinity, being covered with varied foliage; above which rise the towers of Castle Howard, the residence of the late Colonel Howard, brother to the Earl of Wicklow. To this noble mansion we rambled, exploring the various delightful walks, now winding through embosomed brakes, and woods luxuriant in native wildness — and now emerging into the open light, with the loveliest prospect of the Avon and the Avonmore lying before us. If criticism might be hazarded in a scene like this, I should be induced to find fault with the artificial cascades, which, with every advantage of situation, resemble the formal and regular falls of mill-dams. The ornamental cottage in the grounds, also the caves and the grottos, are susceptible, I think, of improvement. This vicinity is the Paradise of Wicklow — perhaps of Ireland — for though others may possess features of wilder and more romantic character, none can be richer in the elements of loveliness and beauty. The river murmurs away through luxuriant evergreens and overhanging



---

p.206




rocks, and is remarkable for the extreme transparency of its water.


We visited the Avondale School, instituted by the Rev. Mr. Webber. In winter, sixty scholars attend: in summer, one hundred. Of these, sixteen are Catholics. Scripture lessons are taught from the Protestant bible for one hour in the day, and the children are examined on them. The payment is from 1s. to 4s. per quarter, according to proficiency. The generality of the Catholics, the master informed us, scruple to send their children.


On the high ground above the Cronebane Mines and Castle Howard, is a large square block of granite; its size and prominent form on the summit of the hill, and its bleached sides, render it a conspicuous object for many miles. This high ground has the most barren surface imaginable, but is rich in mineral productions. The district on both sides the Ovoca abounds in copper; four mines were in course of active working when I visited the country — viz., at Ballygahan, Connery, Cronebane and Ballymurtagh. From Castle M'Adam parish, in



---

p.207



the barony of Arklow, 50,000 tons of copper are annually exported to Swansea, the best being worth six or seven pounds per ton — the small ore fetching three or four pounds. Mr. Hodgson has extensive copper mines here. One of them extends on the south-west side of the Ovoca for 400 yards; another goes 300 yards further, towards the southwest: the dip is about six degrees by the compass south of west. In the mines in this parish, independently of carriers, no fewer than 1000 inhabitants are employed. The Cronebane Mines are on the north-east side of the Ovoca, and were first worked by the Cronebane Company in 1787. This Company was incorporated by act of Parliament in 1798, as the Associated Irish Mine Company, and Mr. Weaver was appointed the manager; they extended into the Connery and Tigrony Mountains, and their level was upwards of 1000 fathoms in length; these mines are now worked by the Messrs. Williams. A small mine to the east is worked by Mr. Salkeld. On the north-east side of the river there are five shafts; the water from the upper one, after being raised, forms a stream,


---

p.208




which, in its descent, works a number of large water-wheels, one of them 50 feet in diameter. These wheels, and their spouts, have a striking appearance; some punctilious sticklers for the exclusively picturesque, would say that they spoil the valley: for my own part, fond as I am of sequestered and undisturbed scenery, I would at any time gladly submit to an interruption, for the sake of finding employment for the poor Irish. Kamack and Company get from 125 to 130 tons per week. The wages of the miners are, on an average, 15s. per week; boys of twelve years old earn 4s. The copper ore costs 23s. per ton, to make it ready for carting away; the average price, when sold, is from £3. 10s. to £4.


Near the Ovoca I observed several cisterns, where the water from the mines, which is impregnated with sulphate of copper, is retained, and the copper is precipitated by the mixture of scrap iron. By this discovery, the water, which formerly was of no value, is a source of considerable profit.


Mr. Nicholson, an intelligent surgeon who attends the mines, informed us that the workmen



---

p.209



are very subject to accidents and disease; the latter arises, partly from the unwholesomeness of the mines, and partly from the potato diet on which, in consequence of their abundant use of whiskey, they are forced mainly to subsist. Some plan for the supply of medical assistance was accordingly rendered necessary, and the men subscribed sixpence a week to raise a fund for that purpose.


In our way to Arklow we passed Ballyarthur, the seat of the Rev. H. Bayley, a truly lovely spot, and alighted at Skelton Abbey, the residence of the Earl of Wicklow, which is seated in the beautiful vale of Ovoca. We walked round the gardens and pleasure-grounds, which abound in arbutus, bay, holly, and other luxuriant trees and shrubs. The Abbey is a square building, richly pinnacled, designed by W. R. Morrison. Skelton has long been the residence of the Howards, who were originally of English extraction. King James, after the battle of the Boyne, rested here, in his flight to Waterford. We passed through the domain, having the mausoleum of the Howard family on a hill to our left, along a flat



---

p.210




and swampy tract of land, and crossed the old bridge of Arklow, consisting of nineteen arches, over the mouth of the Ovoca.


The harbour of Arklow appears extensive, but is reported to be unsafe, in consequence of the number of sand-banks. Upwards of one hundred boats are here engaged in the herring and oyster fishery. We ascended the partially ruined tower o f the Castle, which affords a good view of the town and harbour. The castle anciently belonged to the Earls of Ormond, and was the scene of frequent contests and bloodshed. In 1798, the rebel army, consisting of 20,000 men, were defeated here with great loss, by General Needham, whose force did not exceed 2000.


From Arklow we returned up the west side of the beautiful Ovoca, having Skelton on the right, and the picturesque grounds of Glenart, belonging to the Earl of Carysfort, on our left. This ride, which possesses great beauty, brought us to the Wooden Bridge Inn (so called from a wooden bridge which formerly crossed the river), at the foot of Knock-na-Moel. The 



---

p.211




union of the Ovoca and Aughrim rivers, which takes place here, gives to the place the name of the Second Meeting of the Waters. A winding path up the hill, behind the inn, leads to a rustic bower, from which a delightful prospect down the wooded valley of the Ovoca, with Arklow, its dark castle, and the sea, in the distance, is commanded. This most favoured spot ought by no means to be neglected, as it combines some of the richest and most pleasing landscape scenery.


After a night's rest at this comfortable inn, we set off to explore the Gold Mine, situated under Croghan Kinshela Mountain, about three miles distant. The road lay through a winding valley amongst the hills, the sides of which were almost entirely barren of trees. If planted, this would be a beautiful walk. We continued to ascend the banks of the Gold Mine River, a stream of remarkable clearness, till we reached the workings, which had taken place at the side of the stream. We saw, also, the excavation made by Government in the mountain side, in their search for the precious metal, which is supposed to have



---

p.212




been discovered by accident about the year 1775, and for many years confined to the neighbouring peasantry. In 1796, a piece of gold, weighing about half an ounce, was found. This caused such a degree of infatuation, that Government thought it necessary to station a party of militia on the spot. In about two months, according to **Mr. Wright**'s account, the country people are reported to have obtained, by washing the sands of the stream, no less than 2666 ounces of gold, worth £10,000. Government took the management of the mines, and appointed Mr. Weaver, Mr. Mills, and Mr. King, the Directors, under an act of Parliament. In 1801 the Directors explored the mountain, and although for some time the produce of the mine more than repaid the expense, yet Government, seeing but little encouragement in the prospects before them, abandoned the undertaking. The quantity of gold found by Government is said to be much less than that discovered by the peasantry; the value of it, as stated by Mr. Wright, being only £3675. 7s. 11 1/2d. The late Mr. Hume, of 



---

p.213




Humewood, representative in Parliament for the county of Wicklow, was possessed of a watch made of this gold. "It is generally believed in the adjacent country," continues **Mr. Wright**, "that the native gold was found here centuries ago; and it is an acknowledged fact, that the ancient Irish wore ornaments of gold before this precious metal had been found on the European continent." We were not successful in *our* search, although we groped about a considerable time; nor was it very likely we should find even a small cabinet specimen. The gold is obtained by collecting the sand from the bottom of the stream, and washing it carefully in some vessel; after which process, the gold is easily discovered glittering at the bottom. Our guide said, that if the smallest piece were dropped into the river amongst the sand and gravel, he could readily find it by this method. We purchased a few small specimens of great purity. Mr. Weaver observes, that "there are eleven metallic substances found in the clay slate breast of the Gold Mine Mountain — viz., gold, silver, copper, iron, lead, zinc,


---

p.214




tin, tungsten, manganese, arsenic, and antimony." The county of Wicklow is rich in mineral treasures, which I have reason to believe are very imperfectly explored; the mining operations, too, are pursued to a very limited extent, compared with what they are susceptible of.


On the strand at Wicklow are found very beautiful Mocha pebbles, fit for jewellery; the finest are but little inferior to those brought from the East Indies. In several parts of the county of Wicklow, the bones of the elk have been discovered, but the skeletons were much less complete than that in the collection of the Dublin Society, which was obtained in the county of Limerick. The agriculture in this mining district we found, as it is found in other mining districts, in a backward state. At the same time, the county may be considered in a thriving condition, and, in consequence of the labour required for the several mines, the people are in general well employed, though an agricultural labourer receives only sixpence per day, with diet, and tenpence without.




---

p.215


On leaving the Wooden Bridge Inn for Carlow, the road lay along the north side of Aughrim River for about four miles. After crossing the river near Aughrim, the country became exceedingly uninteresting. We left Kilpipe and Tinehely on our right, and had the Croghan Mountain on our left. The land in this district is indifferently cultivated. There are no green crops of any kind except potatoes; much of the land is in want of draining; and the hedges consist, invariably, of whin or furze. The people were digging potatoes with their long spades. Whilst working, they are nearly in a perpendicular posture; and such is their spirit of curiosity on the appearance of a car or carriage, that labour is instantly suspended, and no more work is done as long as the vehicle remains in view. Clay slate with mica prevails for a great part of the way from the Wooden Bridge Inn.


The estates of Earl Fitzwilliam extend through most part of the barony of Shilelagh; Malton, the noble earl's seat, being occupied by his brother-in-law, Mr. Chaloner. We called here, but



---

p.216




did not find Mr. Chaloner at home. The house, which is far from being beautiful, stands on a commanding eminence, affording a fine view of the neighbouring mountains and valleys. The peculiar whiteness of the garden walks, arising from the broken quartz with which they are covered, particularly attracted our attention. They had the appearance of the whitest marble. Our conductor informed us that a fountain, which, fortunately for his character as a veracious relator, was not playing, "sent up the water quite out of sight!" Both Earl Fitzwilliam and Mr. Chaloner devote great attention to agriculture, and promote improvements by awarding premiums to the tenants, and supporting an **Agricultural Society**. At the meetings of this society, the Earl makes a point of dining with his tenants. The meritorious are encouraged by suitable rewards, and no expense is spared in attempts to stimulate the energies of all in the direction of a superior management of the land allotted to them. Among other sources of benefit, the tenants derive great advantage from his lordship's introduction of cattle from



---

p.217



England, supplied by some of the most eminent breeders. Earl Fitzwilliam's income from his Irish estates is said to be £35,000 a year; of this he generously devotes a considerable share to their improvement, and to the advancement of the interests and comforts of his tenantry. He is justly accounted one of the best landlords in Ireland. Considering the example and encouragement so abundantly afforded, I was surprised to find the agriculture in the barony of Shilelagh in general, in so unpromising a condition. Upon one occasion, the Earl, I was told, presented a farmer with £100, for pursuing a system which his lordship was anxious to promote.


The barony of Shilelagh derives its name from the celebrated oak forests which formerly occupied so much of the district. Great quantities of the timber were exported to foreign countries, for roofing public buildings; part of Westminster Hall is said to be formed of it. At the village of Shilelagh a church has lately been erected on a green hill. The building possesses considerable


---

p.218




beauty, and is surrounded by a few oaks that have survived the general destruction; they add greatly to its picturesque effect.


Having passed over a disgracefully bad and dangerous road, occupied by large heaps of stones, we reached Tullow, twenty-six miles from the Wooden Bridge Inn.


Tullow, a market town of Carlow, contains 2000 inhabitants, and is seated on the river Slaney, which flows by Wexford into St. George's Channel. Near the bridge that crosses the Slaney are the ruins of an Augustine Abbey, the east end of which, though in a tottering condition, still stands. Close to it, within an ancient building, is a well of beautifully clear water, which has doubtless been the holy well. A burial-ground, still used as a place of interment, stretches around the abbey. These ruins with the adjoining grounds, and a considerable part of the town, belong to Robert Doyne, Esq., who for the most part resides in England. Tullow was once a walled town; an old castle, captured by Cromwell, has been pulled down, the materials being



---

p.219




used for the erection of barracks. The Roman Catholic chapel here possesses an elegant spire; the Protestant church, though nothing very remarkable, is a neat building. Several flour-mills on the river seemed to be in active employment.


We walked through the market, and were soon surrounded by about forty labourers, thin, wan, half-starved creatures, anxious for employment, but unable to obtain it. They stated that they were only employed during a part of their time, and that their wages were tenpence a day, without diet. The average of their earnings throughout the year, did not, however, exceed threepence a day; and on my doubting the possibility of their families being supported on that sum, they informed me that occasionally others of the family earned a trifle, but that very frequently they could not get salt to their potatoes, and sometimes were even short of potatoes.


The price of oats was from 13s. 6d. to 14s. per barrel of 14 stones. This grain was very late, and not properly ripened. The crop, moreover, was so deficient, that although the price was nearly



---

p.220




double that of last year, the farmers said that they should be no better paid. Potatoes sold at from 2£d. to 3d. per stone. Beef 4d., mutton 5d., veal from 6d. to 7d., bacon 7d., some beef, very bad, 2 1/2d. per lb. We observed a quantity of disgusting meat offered for sale in dirty cars. It consisted of the tails and back-bones of pigs, the flesh being carefully cut off. Numbers were sold for 6d. each. Several interesting women, the wives of farmers, stood in the higher part of the market-place, some having a few eggs, or a fowl or two, under their cloaks — others a turkey or two, or a small quantity of butter, which people purchase by pennyworths, guessing the weight.


The signs displayed by numbers of low, miserable hovels, are ludicrous enough. "Entertainment," "Good Beds," and "Dry Lodgings," are offered to the traveller by cabins which cannot certainly supply any one of the desiderata they profess to abound in. If, however, damp green walls, roofs of thatch, full of holes, wet clay floors, and abundant dirt, may be considered as sources of entertainment, these houses do no less than



---

p.221




properly represent the capabilities they are possessed of. "Dry Lodgings," I should observe, merely signifies lodging without food.


From Tullow to Carlow better cultivation prevails. Respectable farm-houses are distributed over the face of the country, and the farms are more extensive, containing as much as from 150 to 200 acres, and upwards, each. We passed through about three miles of the estate of the Earl of Besborough, the father of Lord Duncannon. A mile and a half east of Carlow is the extensive domain of Browne Hill, belonging to Mr. Browne, walled round and well wooded. We passed also two important Raths on our left, one of them about two miles from Tullow, the other opposite Browne Hill. The land near Carlow is excellent, and the country is ornamented by gentlemen's seats, rivers, and wood.


To Thomas Haughton, the first Dissenter appointed to the magistracy since the days of Charles the First, I was indebted, on my arrival at Carlow, for much polite and friendly attention. He obligingly accompanied us through the Lunatic



---

p.222



Asylum and County Jail, and not only supplied every information in his power, but introduced us to other sources from which we might obtain what he himself was unable to furnish. The Asylum is a handsome new building of granite, appropriated to the use of the counties of Carlow, Wicklow, Kilkenny, Wexford, and Queen's County, and contained, when we visited it, 125 patients, the annual cost of each being £17. 10s. It is surrounded by fourteen acres of ground, inclosed within a wall. The more healthy of the lunatics are employed in trenching the ground, and had succeeded in making it very productive. The only punishments resorted to in this well-conducted establishment, are the shower-bath and the strait-waistcoat. The diet of the patients is stirabout, made of oatmeal and water, and sometimes of milk; potatoes and soup, and bread and milk. On this diet they get fat. By weaving, and other work, they raise about £70 a year for the institution. The original cost of the Asylum, including the land on which it stands, was £24,000. The salary of the governor is £200 per annum.




---

p.223


The County Jail, also lately erected, is a neat structure, with a large portico of two rows of Ionic columns, each row consisting of eight. The effect of the building disappointed me. The Courts of Justice appeared to me to be small and inconvenient, though I understood that in the neighbourhood they were considered to be of a superior description.


In the morning we visited the Roman Catholic Cathedral, a handsome and spacious Gothic building, after a design by Cobden. This splendid temple contains the tomb of the late learned and pious Dr. Doyle, who spent on the Cathedral the sum of £12,000, the result of voluntary contributions. Dr. Fitzgerald, the superintendant of the adjoining Roman Catholic College, who had also spent a similar sum, similarly obtained, in its improvement, accompanied us through the various parts of that establishment, and was particularly polite and communicative. The library is extensive, and consists of works of History, Theology, Natural Philosophy, the Classics, Church History, the Canon Law, and the Fathers.



---

p.224




The lecture-room is well supplied with philosophical apparatus. The students, of whom there were 140, pay from £27 to £30 per annum. Though all the scholars, at the time of our visit, were Catholics, occasionally Protestants receive their education here. The College was instituted in 1793.


In reply to a question of mine, Dr. Fitzgerald declared that it was a mistake to imagine that the Roman Catholic Priests oppose the diffusion of the Holy Scriptures; the fact was, the people were too poor to pay for them; but if the societies, he added, through whose instrumentality bibles are distributed gratuitously in foreign countries, would bestow part of their funds upon their Roman Catholic brethren, they (the priests) would be thankful to have an opportunity of extending the knowledge of the Word of God among the poor. Considering the ignorance of the people, Dr. Fitzgerald concurred with the majority of the clergy of the church of Rome, in thinking that the scriptures should be expounded by the priesthood; "for instance," said he, "it would be difficult for




---

p.225



an ignorant man to interpret properly such a text as the following — 'God hardened the heart of Pharaoh,' which of course implies, if correctly understood, that God *permitted* the corrupt nature and dispositions of the Egyptian monarch. Pharaoh was accordingly a moral agent." Dr. Fitzgerald very naturally considered the Roman Catholic version of the bible to be fairer and more true to the original than that in use among the majority of Protestant churches.


In the course of our conversation I took the liberty of observing, that if the Roman Catholics were so poor as to be unable to purchase bibles, it seemed a little extraordinary that they could erect such splendid cathedrals and colleges as are to be met with up and down the country. The Doctor answered my objection by remarking that a considerable part of the funds arise from money left by the priests; that according to the Canon Law they cannot apply their property to any private purposes, or will it to their relatives, but are obliged to leave it to charitable objects. In some instances they act in direct contravention of the 


---

p.226



law; the bishop, however, at his visitations, interrogates them respecting the disposition of their property, and, if detected in misappropriation, they are liable to the penalty of suspension. A priest in the parish of Bagnalstown, who died lately, worth £4000, left it all to the bishop, for building schools. Hence the accumulation of Catholic property in various instances, and the building of chapels and schools. During the last thirty years, a sum of £500,000 has been expended by the Roman Catholics in the building of churches. Dr. Fitzgerald further informed me, that it was intended to establish a convent of nuns in Carlow, of the Order of the Sisters of Charity, whose duty would be to visit the sick and attend upon the poor. All the nuns in Ireland, he added, either conducted schools or were usefully employed in the fulfilment of charitable duties. On the subject of tithes, the doctor reverted to the original object of their institution, and contended that as they were designed for the use of those who administered to the spiritual comforts of the people, they were applied in 



---

p.227



opposition to the principle which gave rise to them, in being bestowed upon the clergy of a minority of the population. After the manner, he added emphatically, in which the clergy of the Established Church had persecuted the people with the sword, they never could be tolerated.


Notwithstanding Dr. Fitzgerald's information, it is notorious that the blessings that are ever found to result from a free and unmolested perusal of the bible, are often denied to the poor and unlearned members of the Roman Catholic communion. Except in the company of their priests, or when attending divine worship in their chapels, they are forbidden to consult the written oracles of God; thus being excluded from one of the richest sources of instruction and comfort. Besides, apart from the evil of interdicting the popular use of the scriptures, in a spiritual point of view, the prohibition seems to be objectionable on another ground. It imposes upon those who submit to it, a yoke of mental slavery. As long as a people submit to a dictation of this sort, they are unfit for the successful execution of


---

p.228



great enterprises. But in spite of the interdiction of the priests, the Catholics, I believe, will not be prevented from reading the scriptures. In one place which I visited, I was told by a most respectable gentleman, that such had been the anxiety of several poor Catholic families, in his neighbourhood, to "search the scriptures," in consequence of relations from their children of passages which they had read at the schools of the Board, that, in defiance of the risk they ran, *they had actually obtained bibles;* and Mr. Blacker, at the conclusion of his "Claims of the Landed Interests," gives the following information: — "I have been lately assured, by a Protestant clergyman, that he had it from good authority, that Roman Catholics were now meeting by stealth, at night, to read the scriptures, in a district where popery seemed thoroughly to predominate."




---

p.229


Cloghrennan Abbey — Druidical Cromlech — Agriculture in Carlow — Corn-mills at Milford — Improvements at Carlow — Carlow Castle — "Stone Coal" — Old Leighlin — Religious and Political tolerance a — Kilkenny — Round Tower and Cathedral — The Chair of St. Kieran — Remains of Monasteries — Presentation Nunnery — Kilkenny Castle — Marble quarries and works — Gaiety of Kilkenny in the Hunting season — Thomastown — The Giant's Tomb — Woodstock — New Ross — Dangerous darkness of the town — Dunbrody Abbey — Enniscorthy and Vinegar Hill — Employment, wages, and prices — Education — Ferry Carrig — Wexford — Johnstown — Model School — Grogan Morgan, Esq. — Inhabitants of the barony of Forth — Martin Doyle.
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Along the banks of the canal and river Barrow we walked to Cloghrennan Abbey, the property of Colonel Rochford. This venerable edifice, which was built in the reign of King John, is now used as a lodge and gateway to the more modern mansion; the road to which lies through a park of rich ground, interspersed with fine timber. The grounds and gardens attached to Colonel Rochford's seat are of considerable beauty.




---

p.230


Nature has done much for them, and art has wrought in the very spirit of nature. Retired and shady walks — rivulets, rocks, and verdant banks, clothed with myrtle, bay, and the luxuriant arbutus — combine or contrast their respective charms, to form a spot of enchanting beauty.


Near Browne Hill are the remains of a Druidical Cromlech, which we visited. The stones of which it consists are of granite: the supporters in front, four in number, being from six to seven feet above the ground. One has given way, and the cover accordingly rests on three. The stone which rests upon these supporters, and upon some others behind, is probably the largest known to have formed the flat stone of a Cromlech. The dimensions, as well as I could ascertain them, appeared to be as follows: — the diameter each way twenty feet, and the thickness six; from which it is calculated to weigh one hundred and eighty tons.


There are some spirited and skilful agriculturists in the county of Carlow, amongst whom Robert Leckey, the Secretary to the Carlow Agricultural



---

p.231



cultural Society, is conspicuous; but on going over his farm, as well as in my observation of others in the district, I could not but remark the very limited extent to which the valuable system of summer stall-feeding was pursued. As another instance amongst the many met with everywhere, of the blasting effects of the spirit of Irish party, it was stated, that although the above society had the most auspicious commencement a few years ago, its downfall was anticipated, in consequence of the operation of that pernicious principle.


At Milford, near Carlow, the Messrs. Alexander have made extraordinary improvements in planting, in the construction of new roads, and in the erection of corn-mills, farm houses, and cottages. At the mills, from 40 to 50,000 barrels of wheat, and 40,000 barrels of oats are ground, and 30,000 barrels of malt made yearly: and here, and at the marble quarries of the same proprietors, upwards of 150 labourers, to whom they pay from tenpence to sixteen-pence a day each, are employed. They have also extensive mills at Belfast, at which 75,000 barrels of wheat, principally


---

p.232




or home consumption, are ground in the year.


At Carlow considerable improvements were in progress, and additional ones in contemplation. An extensive and increasing trade is carried on in timber, grain, butter, woollens, coal, and culm. The Barrow rises in the Slieve Bloom Mountains, and is here a fine broad river, affording safe navigation by the sea to Waterford, and northwards, by inland navigation, as far as Athy in Queen's county, from which there is a communication with Dublin by the Grand Canal.


On the banks of the Barrow stand the remains of Carlow Castle — two round towers connected by one side of a quadrangle. Dr. Myddleton, an English physician, obtained a lease of this ancient strong-hold, with a view of converting it into a Lunatic Asylum. In the course, however, of making the necessary alterations, two of the towers and the walls which connected them fell in with a dreadful crash, and put an end to the undertaking.


Carlow has a population of about 10,000, and was anciently inclosed within walls. The limestone



---

p.233



or marble in the vicinity of the town is curiously intermixed with madrepore; beautiful hexagonal crystals of perfectly transparent quartz are frequently found in it.


Carlow is well supplied with what is commonly called "stone-coal," obtained from the extensive mines in the vicinity of Castle Comer, in the county of Kilkenny. It emits neither flame nor smoke, and the fires which were composed of it, appeared to me lifeless and dull, though hot; the price varies from 10d. to 1s. 4d. per cwt., when delivered. These mines supply a great part of the counties of Kilkenny, Carlow, and Queen's county, and occasionally more distant parts; but, in the towns which border on the canals, the parlours of the gentry are generally supplied with English coal, designated "sea-coal." In consequence of the quantity of deleterious gas which it emits, the stone-coal is apt to affect those who are unaccustomed to it, with head-ache; nor is this the only injury it produces. Several instances of suffocation have occurred, in consequence of fires, made


---

p.234




of it, being lighted in bed-rooms that were not sufficiently ventilated.


At a ford in the river Barrow, a short distance from Carlow, there were found, a few years since, a great number of pieces of swords and various weapons, composed of the same mixed metal as the ancient arms usually dug up in Ireland; they are supposed to have been thrown away by a defeated Irish army in its flight, but no notice of such an event occurs in history.


From Carlow we proceeded to Kilkenny, having for some distance the placid Barrow on our right. In our way we visited the ancient and melancholy ruins of Old Leighlin, once a city, but now an inconsiderable village, pleasantly situated on green knolls by the side of a small river. The Abbey here was founded in the year 632 by St. Gobhan. Divine service is performed in a part of the old church, which is kept in repair for that purpose.


About four miles from Leighlin Bridge, which crosses the Barrow, and consists of nine arches, we entered the county of Kilkenny, and passed 



---

p.235




through a tolerably well cultivated district. The condition of the farmers and labourers in this part of the country is said to be decidedly better than in most of the other parts of Leinster; a circumstance mainly attributable to the greater prevalence of resident proprietors, or rather, to the kindliness of feeling subsisting between them and their dependants, arising out of well-established principles of religious and political tolerance. Apart from considerations of duty, and regarded as a mere matter of expediency, mutual forbearance on the two great subjects of politics and religion will be found to be productive of the most advantageous consequences.


Kilkenny (which signifies the Church of Kenny) is said to be the largest inland town in Ireland, and the pleasantest, whether inland or sea-port. It was formerly a place of great strength. The day we spent there was, however, unfavourable — a dense mist overshadowed both town and country, obscuring near, as well as distant objects. So dense indeed was the fog, that the summit of the Round Tower which stands within a few 



---

p.236




yards of the Cathedral, was entirely concealed. We afterwards, however, succeeded in getting a satisfactory view of the upper part of it from the top of that noble structure. It is without the usual conical cap.


**Grose**, in his Antiquities, speaking of Kilkenny, says, "This is a plentiful country, so populous as to be adorned with more towns and castles than any in the kingdom; and though it is mountainous in the south part, is said to have

> 1. Fire without smoke, earth without bog,
>   
> Water without mud, and air without fog,
> 



thus having all the four elements in perfection. It is esteemed a healthful, as well as a pleasant country. It is remarkable for its coal mines, as well as for its marble quarries. Near Ossory are the mountains called Slievebloomey, or Bladen Hills, out of which spring the Suir, the Noer, and the Barrow. They descend in their several channels, but join in one before they fall into the sea. The Noer, or Nuer, divides this county into two parts." It is somewhat extraordinary that



---

p.237



Kilkenny, thus lauded for the clearness of its atmosphere, should be the only place in Ireland in which we were enveloped in fog.


The cathedral is an interesting edifice, and was built in the year 1180. It is cruciform, and extends 226 feet from east to west — the length of the transepts being 123. The pillars, which some barbarian has whitewashed, are of black marble. Many monuments, chiefly in honour of the Butlers and the Ormonds, attract the attention of the visitor, but the most *famous* of all the contents of the place is the Chair of St. Kieran, said to be the first preacher of Christianity in Ireland — St. Patrick having followed him by thirty years. This chair is fixed in the wall — consists of black marble — and wears an excellent polish, for which it is indebted to the curious or the superstitious, who make a point of occupying it.


Kilkenny possesses the remains of three monasteries, all said to have been built by the Earls of Pembroke, and all interesting as relics of ancient power.


We took an opportunity of visiting the Presentation


---

p.238




Nunnery, where five or six hundred young persons receive their education, and were conducted through the establishment by one of the Sisters. The children are instructed in various kinds of needle-work, specimens of which are purchased by visitors for the encouragement of the school. Attached to the Nunnery is one of the most beautiful chapels in Ireland. The ground of the walls and columns is white, richly ornamented with gold and scarlet. The confessional chairs are particularly elegant, and rich in decoration.


Kilkenny Castle, built upon the banks of the river Nore by the Earl of Pembroke, in the twelfth century, on the site of one built by Strongbow, which was destroyed by the Irish twenty-two years before, commands a fine view of the town and neighbouring valley. In the fourteenth century it came into the possession of the Ormond family, who still retain it. The present Marquis is laying out annually large sums of money in rebuilding it. It is flanked by large round towers, one of which, to the right of the entrance, is of considerable antiquity. Seen from



---

p.239



the bridge over the Nore, on the Leighlin road, this venerable building, rising out of the fine wood that surrounds it, with the river winding about its banks, has a noble and picturesque appearance.


The English town of Kilkenny is situated on the west side of the river Nore, — the Irish town on the east. The former is larger, and much better built. The population of both is about 24,000.


Blankets and frieze are manufactured at Kilkenny. There are also several flour-mills on the Nore. A pleasant walk along the river's bank, shaded by trees, leads to the marble quarry, about a mile from the town. Here we collected some specimens of marble, madrepore, and fluor spar. The marble, the demand for which has been considerable, is easily quarried, and is very beautiful — some of it resembling the Italian, veined. A few miles down the river, extensive marble works are carried on by Mr. Collis, who, we were informed, had twenty-four saws in active work. Kilkenny is also famous for its coal, similar to that whose qualities have been previously



---

p.240




described in the account of Carlow. It speedily consumes the iron bars of the grates in which it may be placed. It is a species of anthracite, beautifully glossy, and is sold at 1s. 2d. per cwt.


Labour here is one shilling a day, without diet, but the labourers are employed only half their time.


A celebrated hunt, with fancy-balls and other amusements, takes place at Kilkenny twice a year, for about a week each time. This period is signalized, as our landlord remarked, by hard eating and drinking. The effect of the passion for hunting was observable in the superiority of the horses of the district.


From Kilkenny we had an interesting ride through Thomastown and the village of Innistiogue, to New Ross, passing several ruins and seats in our way — among others, Mount Juliet, the splendid mansion of the Earl of Carrick.


Thomastown stands on the Nore, and abounds in interesting ruins. One of these, a castle, belonged to Thomas Fitz-Anthony, a baron of the time of Henry the Second, and is said to



---

p.241



have given the town the name it bears at present. Among the ruins of the abbey, a large tomb, reputed to be that of an Irish king, and traditionally called The Giant's Tomb, is spoken of by the Guide Books as still in existence, but I searched for it in vain. On a newly-made grave, however, I observed part of a stone, which, from the extraordinary size of a sword sculptured upon it, was, I doubt not, a part of the gigantic tomb alluded to.


At Innistiogue we recrossed the Nore by a bridge of ten arches, near which is a salmon fishery. A short distance below the village, on the southern bank of the river, stands Woodstock, the seat of Mr. and Lady Louisa Tighe. Here the sensitive and fine-souled author of Psyche died. Woodstock is one of the most lovely places in Ireland, abounding in fine timber. On the western bank of the river is a wood, which covers no less than five hundred acres of ground.


New Ross, in the county of Wexford, about six miles from Old Ross, stands on the east bank of the Barrow, which is here a fine wide river,


---

p.242




crossed by a wooden bridge, the work of **Samuel Cox**, an American architect. The quay is spacious, and vessels of four hundred tons burden may be brought up close to it. New Ross has been unfortunate as respects business, but has latterly improved. The trade in timber, wool, grain, and other agricultural produce, has increased very much within the last few years.


After daylight, the town is in perfect darkness; and as the quay lies open to the river, people are occasionally drowned. I had myself the misfortune to experience some of the ill effects of the obscurity that prevails; for in going to dine with a gentleman at the further end of the quay, I came in contact with the shaft of a large hand-barrow, and was so much injured as to be nearly incapable of walking for several days. The streets are also in exceedingly bad repair, and consequently very dirty in wet weather.


It was here, in 1798, when the insurgents attacked the place, that Lord Mountjoy met his death.


From New Ross we drove down to the ruins of


---

p.243




Dunbrody Abbey, a magnificent pile of building, the property of Lord Templemore. It stands about seven miles from New Ross, close to a fine bay of the river Barrow, and Waterford harbour, the retreating shores of which are well wooded and studded with mansions. From Dunbrody Abbey to the domain of Lord Templemore, near Duncannon Fort, the country is bold and open. Mr. Pelham Babington, Lord Templemore's agent, accompanied us over the farm and grounds.


From New Ross to Enniscorthy, a distance of twenty miles, we travelled by coach, through an uninteresting country that would have been entirely bare, had it not been for the gorse or whin hedges of dark green. These hedges, rising one above another in a continuous mass on the gentle slopes, had a *velvety* appearance, and in some degree compensated for the absence of trees.


Enniscorthy, close to which is Vinegar Hill, the scene of dreadful slaughter in the year 1798, retains marks of the injury it sustained when the insurgents had their camp adjoining it. The river Slaney, flowing smoothly through flat green meadows,



---

p.244



divides the town from Vinegar Hill, but was inefficient in protecting it from the fire of the hostile parties. A tower, standing alone in an open space, is all that remains of the ancient church, which was destroyed at that period. The erection of a Market-house has been proposed, and a plan suggested, according to which the tower is to form part of the projected building. The population of Enniscorthy is nearly 6,000; the town belongs to Lord Portsmouth, who derives an income from it of about £10,000 a year. The Castle is kept in repair, and inhabited by one of his agents.


Enniscorthy has improved greatly during the last few years. A considerable trade in grain is carried on by means of the Slaney, which is navigable as far as Wexford; and about seven miles from the town a small manufactory of cotton is established. Besides its Saving Bank, Enniscorthy has a bank that accommodates the farmers by discounting bills so small as £3, with two or three names attached to them — in consequence of which arrangement they are enabled to purchase their



---

p.245



seed. A Temperance Society has also been established here, but without much success. Whiskey drinking, however, is on the decrease. The people, who are great politicians, possess two News-rooms, but are without a public Library. Tithe has not been paid for several years.


To the west of the town, half way between it and Mount Leinster, lead and silver mines were formerly worked; but the quantity of water that prevailed, caused them to be abandoned. A company was about to be formed for the purpose of recommencing operations.


Neither Lord Portsmouth nor his agent, I understand, are in the habit of giving encouragement to agricultural improvements. On Earl Mountnorris's estate, however, an **Agricultural Society** has been established, and there is another at Wexford.


In this neighbourhood, as in other parts of Ireland, the agricultural labourers are employed only about four days a week — their wages being tenpence a day during one-half of the year, and a shilling the other half, without diet. In harvest, 


---

p.246




1s. 4d. without diet, is paid. The price of potatoes was twopence, and oats 1s. per stone; wheat from 33s. to 37s. per barrel of 20 stones; lime 2s. 8d. per barrel of 20 stones; coal 23s. per ton. The produce of wheat is from five to seven barrels per acre. The rent of land, the produce of which is as above, is £3. 3s. close to the town — £1. 5s. at a distance of about a mile and a half; and £1 still further off.


The Roman Catholics here are in the proportion, as respects the Protestants, of about seven to one. Many more children are educated now than formerly, but those of opposite religions do not mix in the schools; which here, as well as in many other places, are altogether abandoned by the Protestant clergy. It is greatly to be regretted, that gentlemen, whose superior education peculiarly qualifies them for cultivating the minds of the more ignorant of their fellow-creatures, should consider it their duty to decline participating in so noble and praiseworthy an object.


From Enniscorthy to Wexford, the ride for



---

p.247



some distance lies along the fertile valley of the Slaney — Enniscorthy and Vinegar Hill remaining in view for a considerable time. The valley is narrow, and composed of diluvial soil; the upper land being of a light and friable nature, well adapted for green crops, of which, however, scarcely any are to be seen. Near Wexford, the River Slaney is crossed at the Wooden Bridge, called Ferry Carrig, 2100 feet in length; and, on a sudden turn on the road, round a romantic rock, on which stands the Castle of Carrig (one of the first military buildings erected in Ireland by the Anglo-Normans), a full and picturesque view of the river is presented. A little below the bridge it expands into an extensive bay: — here, and higher up, the banks are lofty, precipitous, and rocky, and richly adorned with wild and luxuriant evergreens.


On entering Wexford, a stranger cannot fail to be much struck with the singularity of the appearance of the town. The main street is exceedingly long and narrow; so narrow, indeed, as to suggest the idea, when seen from some


---

p.248




distance going along the street, which is irregular, that the houses meet at no great distance, and obstruct further progress. I really do not think that the breadth of this street exceeds five yards: yet Wexford is a considerable place, with a population of eleven thousand. Parallel to the main street is a quay, along which lie a number of vessels; but the bar of sand that stretches across the harbour, prevents any that are above 150 tons burthen from entering with safety. Notwithstanding this, there is a good trade in timber, corn, butter, and coal.


Wexford was one of the earliest English colonies. Its castle was built by Fitz-Stephens in the reign of Henry the Second, who, after receiving homage from most of the princes of Ireland, embarked from this place. Near the main street are the ruins of a church destroyed by Cromwell in 1649. Wexford, though an ancient town, contains but little of interest to the antiquarian.


From the Rev. Mr. Armstrong, whose acquaintance I was fortunate in making at White's Hotel, I obtained a note of introduction to Mr. Shelley,



---

p.249



the master of the Johnstown Model School, established some time ago by Mrs. Morgan, the lady of Grogan Morgan, Esq., of Johnstown Castle, about two miles from Wexford. The schoolhouse is a neat building, surrounded by roses and honeysuckles, with an intermixture of evergreens. The beauty of the spot tempts one to enter it; nor is the curiosity which the exterior excited, disappointed by an inspection of the internal arrangements. Mr. Shelley is a superior man, and well qualified for the honourable office to which he has been appointed. The school appeared well conducted, and many of the boys were quick and intelligent, and seemed to be well grounded in the principles of science. Their studies consist of writing, reading, arithmetic, grammar, and engineering. The main object of this benevolent institution was to qualify young men for the arduous and responsible duties of teaching in various schools throughout the country; nor has the munificence of the accomplished patroness been attended by any drawback of a narrow, exclusive, and partial nature — more than one


---

p.250




half the children being Roman Catholics. They are taught gratuitously, and clothed also. Long may Mrs. Morgan be spared to see the happy consequences of her liberality.


Besides the estates in the neighbourhood of Wexford, Mr. Morgan possesses extensive property in the counties of Kilkenny, Carlow, Waterford, and Cork. His estates in Wexford contain 36,000 acres, whilst those in the other counties amount to not less than 24,000: the annual income of the whole is about £15,000; much of it being in lease — some at a rent of 3s. 6d. per acre. If the estate were out of lease, it would amount to £40,000 per annum. He is also said to have a considerable property in the funds. Mr. Morgan is a young man; hunting is his favourite amusement, and I believe his chief employment in the season. He had been improving and enlarging Johnstown Castle, the interior of which was furnished in splendid style. Though attached, however, to the sports of the field, this wealthy proprietor is far from being unmindful of the responsibilities which devolve



---

p.251




upon him as the possessor of riches in a country of extreme destitution. He presents a laudable example to the neighbouring gentry of the beneficial results of *residency* — promotes the improvement of agriculture, by encouraging those engaged in it in connexion with his own estates — contributing largely to the happiness of his farmers, and augmenting the comfort of those who labour for his benefit. With this view he had built, just before the period of my visit, fourteen new cottages for his labourers. They are remarkably neat and comfortable dwellings, constructed of brick and slate, with ornamental gardens in front, and an acre of ground at the back. The cost of each was £80. On the acre allowed them, the labourers cultivate green crops. I saw winter tares in December, covering the ground, and others were coming up in succession. They had beds of mangel wurzel, cabbages, and turnips, and cultivate potatoes, flax, and grain. Some of them keep two cows upon the acre; and the agriculturist, Richard Pidgeon, told me that he thought he could, after that season, keep three cows on an acre. What an



---

p.252




immense field does this exhibit for profitable labour, and the prosperity of the country!


The inhabitants of the barony of Forth, in which Johnstown Castle is situated, being of Welsh extraction, the Welsh language has generally been spoken, and indeed continues to be so amongst the older people. The people of this barony are considered to be more industrious and provident, and to enjoy a greater degree of general comfort, than those of any other part of Ireland; and I could not help contrasting their fresh, rosy, honest faces, and fine athletic forms, as I met them going to Wexford market, with the sallow, thin faces, and attenuated frames, of the inhabitants of more distressed districts. The Rev. Mr. Hickey, who has done so much for his poor countrymen, under the assumed title of Martin Doyle, resides in this barony. The improved cleanliness, industry, and provident habits in his neighbourhood, are mainly attributable to his excellent advice and persuasion.


In the vicinity of Johnstown Castle, there is scarcely a grain field to be seen; with the exception of the small plots already mentioned, all is 



---

p.253




grass. The whole surface of the district has a covering resembling green velvet, and the furze hedges of darker green give a richer effect to the whole.


The greater part of the road from Wexford to Waterford is uninteresting; in the earlier part, however, we had a fine view of the valley and the river Slaney, and afterwards of Saunder's Court, Carrickburn Mountain, and Vinegar Hill. To the right was Scullabogue, where above two hundred Protestants of both sexes were shut up in a barn by the insurgents, in 1/98, and all consumed by fire. Part of the walls of the building are still standing.




---

p.254


Arrival at Waterford — The quay — Banks of the Suire — The Munster School — The House of Industry — The Mendicity Society — Remarks on the evils of party-spirit — Waterford harbour — Reginald's Tower — Trade of Waterford — Public Buildings — Agricultural Society — Wages and Prices — Geology of the neighbourhood — Pilltown — Mr. Anthony's Museum — Loan Society — The Hon. Miss Ponsonby's Infant School — School on the Besborough estate — Hedge-school — Profits derived from pigs — Poor Laws — Lord Besborough's agricultural improvements — The valley of the Suire — Curraghmore, the Marquis of Waterford's — Unaccommodating exclusiveness of his lordship — The cotton factory at Mayfield — Return to Carrick — Improvement of the place.
--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


After some narrow escapes from random driving and the falling of horses, we were at last set down in the evening at Cummins' Hotel, on the celebrated Quay of Waterford. This quay is a mile in length, and, being well lighted with two rows of lamps, had a brilliant effect as we approached it. The opposite banks of the Suire, which is here not less than a quarter of a mile wide, are very lovely, consisting of gently swelling hills, 



---

p.255




well covered with wood, and studded with villas of various pretensions. The quay of Waterford has been thought to resemble the quay of the Soane at Lyons.


The first public object of interest visited by us was the school for the province of Munster, belonging to the Society of Friends. It is supported by subscription amongst the members of the Society, and contains thirty-six boys and thirteen girls; the tickets for admission being only twelve guineas per annum. The cost of each child to the institution, amounts to £25, but the classes are charged extra. William Allen, a minister in the Society, is the superintendant, at a salary of £120 per annum, and his wife takes charge of the female department. The situation of the school is airy and commodious, and the children appeared remarkably cheerful and healthy; but as it was not a school-day when I visited the institution, I had no means of judging of the plan of education.


The House of Industry, supported by assessment, is a well managed institution. It was



---

p.256




built in the year 1779, and cost £1500. At the end of the year 1835, there were 342 persons in the house, 131 males and 211 females. Of these, forty-seven were lunatics, and twenty-four idiots. When I visited the establishment, the total number had increased, being then 374, of whom 148 were males, and 226 females. Their diet consisted of stirabout and sweet milk, potatoes and buttermilk, and bread, and, on Sundays, meat. The vagrants, however, get no meat on Sunday, nor any sweet milk. The entire expense of each person, including salaries, food, and clothing, is £7. 9s. 8d. per annum. Disorderly females are consigned to the tread-mill, for four minutes at a time, and from five to ten times a day. Solitary confinement also is occasionally adopted as a punishment.


The Mendicity Society, similar in principle to that in Dublin, is, or ought to be, supported by private subscription; the institution is miserably neglected. It contained, when we visited it, 65 women and two men; 45 boys and 23 girls. Thirty-three of the boys were in the school, in



---

p.257



one apartment, and a few of the girls in another. The women were sitting or standing, without any employment, the spinning-wheels being piled up in the room. The master receives a salary of 4s. 6d., and the mistress one of 3s. 6d. per week, and lodgings. The poor all lodge out of the house, and are allowed from 2 1/2d. to 3d. per week, to pay for lodgings. They accordingly club together to take a room, in which several families lie, some on straw, others in the rags which they wear during the day. They look squalid and ill, and have no profitable occupation of any kind. It was indeed a sad thing to see these miserable beings crowded together in a dirty loft, open to the slates, and without a fire — the master and mistress endeavouring to teach the ragged children to spell and read — and the poor old women shivering with cold. It was a terrible scene of desolation and starvation; yet such was the state of a Mendicity Society in one of the most flourishing cities of Ireland! Political and religious party-spirit, which unhappily thwart some of the best endeavours to ameliorate


---

p.258




the condition of the Irish people, have unfortunately been the cause of the neglect from which this excellent institution is suffering.


Here, then, is one, amongst the numerous instances in which the spirit of party, arising from political and religious feeling, blasts the work of charity and benevolence; the sufferers belonging to that class of society, which, though it possesses, in the adjustment of abstract questions, an interest at least equal to that possessed by the more favoured ranks, most assuredly takes a far less prominent and officious part in effecting the desired arrangement. The poor, in fact, suffer for the violent animosities of the rich. Why cannot the gentlemen of Ireland, instead of contending so obstinately for the supremacy of a sect or party, apply themselves, without regard to either, to the attainment of those great ends which concern the advantage of *all?* Sinking the petty distinctions of religion and politics, how much more exalted an object of ambition would it be, to seek for the People of Ireland the laws and institutions which the people of England enjoy; to cease to regard



---

p.259




the terms "Protestant" and "Catholic" as terms of honour and contempt; and to labour for the permanent good and honour of that great family, of which Catholics and Protestants, numerous though they be, form but an inconsiderable proportion.


The harbour of Waterford is very commodious; in some places the river is seventy-two feet deep at low water; opposite the city, it varies from twenty to sixty-five feet; and on the bar, at low water, there are twelve feet of water. Vessels of 800 tons burden may come up to the quay; and cattle are conveniently shipped, by means of a large frame of wood, supported by a barge between the vessel and the shore. Reginald's Tower, supposed to have been erected by a Danish Prince in 1003, stands on the quay. We observed a cannon-ball, said to be one of Cromwell's, half buried in the front wall of this tower. On the old walls of the town several of the ancient towers still remain. My accidental discovery of them afforded me a pleasure unknown to those who feel indifferent to the motives and actions of former ages.




---

p.260


The trade of Waterford consists of grain, pork, and butter; and it is celebrated for its glass works. The river Suire is a considerable width, its north bank, opposite the quay, being abrupt, rocky, and picturesque. Waterford has a population of about 30,000.


The public buildings of this important city are scarcely worthy of remark, and the streets are generally narrow, and by no means clean. The river, its banks, and the quay, certainly constitute the principal attractions of Waterford, and are most deservedly admired. The bridge, designed and built by **Mr. Samuel Cox** of America, consists of American oak, is 832 feet in length, and 40 in breadth, and is supported by stone abutments, and forty sets of oaken piers. The architect recommended the shareholders to case one pier with stone every year, which might easily have been effected, but it was neglected. The building of this structure, including remuneration for the previous ferry, cost £28,000, the money being raised by a Company in 1793, incorporated by Act of Parliament. It has been a good speculation,



---

p.261




the payment of not more than £90 on each debenture being required: a short time ago, they were worth £170. In one year the tolls amounted to £4,500. Waterford has derived great advantage from the steam packets, one of which, intended to be of 600 tons burden, was in process of building on the north side of the river.


An **Agricultural Society** formerly existed here, but, in consequence of the violent state of party feeling, it has been suspended. Within a mile of the city, the rent of land is £5 per acre; within two miles, 50s.: within six, from twenty to 30s. The rent of conacre for old grass land, is £8 per acre; for old ploughed land manured, £6. 10s. The crop, when good, is worth £13. The assessment amounts to 1s. 6d. in the pound, at the rack rent. The wages of labourers are in the town 1s. per day, without diet; masons get 3s. 6d. per day. The prices of meat are as follows: — beef, for prime pieces, 6d. per lb., and from 3d. to 4d. per lb., by the quarter. Mutton 6 1/2 d.; veal from 4d. to 6d.; Staggering Bob 1s. 3d. per quarter. A goose, weighing 2 1/2 lb., 1s. 4d.; turkeys 4s. 6d.



---

p.262




per couple; a good one, weighing 5 lbs., will cost 3s. 6d.; fowls 1s. 3d. per couple; eggs 9d. per dozen; they may be had sometimes for 4 1/2d. Salmon from 6d. to 2s. 6d. per lb.; butter of the first quality generally costs 1s. 6d. for 18 oz.; in winter, sometimes 2s. and 2s. 6d..


The climate in the neighbourhood of Waterford is remarkably mild; in the garden of one of my friends I observed myrtles twelve feet high, fresh and vigorous — also the **salvia fulgens**, a great height, and full of fine scarlet blossoms.


The prevailing rock in the vicinity of Waterford, and indeed throughout the entire county, except where limestone is found, is argillaceous shistus. The summits of the hills are composed of silicious breccia, over which red sandstone occurs. On the sea coast near the harbour of Waterford, the silicious conglomerate, and sandstone, are found interstratifying each other. In the neighbourhood of Waterford the following rocks occur: sienite and hornblende, talkose slate, lydian stone, hornstone and jasper; these are found alternating with flinty slate on the road to 



---

p.263



Annstown; serpentine may be seen resting on a bluish black quartzose rock at Knockhouse.[22](javascript:footNote('E830001-002/note022.html'))


The author from whom the matter of the preceding paragraph is taken, states that the condition of the inhabitants of the county of Waterford, at the close of Elizabeth's reign, is represented in the most dismal language. Those whom the sword had spared, were reduced to the extreme of misery and famine; they were seen creeping from the woods, in search of the vilest food, and endeavouring to prolong a miserable existence by eating carrion, and, in some instances, human flesh. The land itself was become unfruitful; deprived of its cultivators, it resembled a frightful wilderness, and from one extremity of the county to the other, except in towns and cities, scarcely any living creature was to he seen, save wolves and beasts of prey.


By one of Bianconi's cars we travelled to Pilltown to breakfast, having the Suire close to the road-side on our left, and passing the ruins of



---

p.264




Grana Castle. Pilltown is a neat village, belonging to the Earl of Besborough, and wears a more English look than most of the villages in Ireland. On each side of the street stands a row of clean cottages, ornamented with climbing shrubs. Pilltown is creditable to the taste and kindliness of the noble family which owns it.


Mr. Anthony, the landlord of the inn where we stopped, is an antiquarian, and possesses a Museum, which he established in the summer of 1834, and which proves a source of considerable amusement to travellers. It consists of ancient Irish gold, silver, and bronze ornaments, and implements of war. A cabinet of ancient coins, medals, statuary, and gems; and contains the Turkish pistols and cimetar, taken by Lord Byron in the Greek war. These interesting curiosities are of massive silver, gilt, and beautifully chased. Amongst the gold coins is an exceedingly beautiful one of the time of Alexander the Great; and some silver tortoises, struck off in the reign of Phidon, King of Argos, 820 years before the Christian sera: many also of the time of Philip of Macedon and his son Alexander,



---

p.265



Lysimachas and Antiochus. Amongst the gold ornaments are **Fibulae** (ancient brooches), richly set with gems; ancient rings; ring-money, and a collar recently found near Boyle. There is also a fossil bunch of grapes, formerly the property of **Sir Walter Scott**. The sum received from visitors to this museum is devoted by Mr. Anthony to the support of a Fever Hospital at Carrick-on-Suire, the next town; and it has been arranged, that to any sum he may send, the county shall add double the amount of it. Up to the 2d of November, 1836, he had paid in £45 4s.; the hospital accordingly received £135 12s. The museum has cost Mr. Anthony, whose charitable conduct cannot be too highly praised, £700.


Pilltown also contains a charitable Loan Society. Those who avail themselves of its conveniences are required to bring two securities, and the largest sum lent is £3. Generally, however, £2 is the sum obtained, and this is repaid in forty-two weekly instalments of one shilling — leaving two shillings for interest. The clerk is paid sixpence in the pound on the money taken out.




---

p.266


Mr. Anthonys Museum, and the Loan Society, are not, however, the only public establishments which Pilltown, though but a small village, possesses. The Hon. Miss Ponsonby, Lord Duncannon's eldest daughter, supports here an Infant School, in which sixty children, Protestant and Catholic, receive their education. On the Besborough estate also there is a school for boys, the number being generally 105, and more than half of them Roman Catholics. The master belongs to the Church of Rome — the mistress is a Protestant; and, on days devoted exclusively to religious instruction, the children are under the tuition respectively of the teacher to whose religious communion they belong. Major Curry, Lord Besborough's agent, pointed out to me a spot where his attention, some time before, had been arrested by a humming noise, which he soon found to proceed from about a hundred children, collected together in a small spot where they had scarcely room to stand, and assembled for the purpose of obtaining instruction from a master who attended them. They were learning to write, on 



---

p.267




the very coarsest kind of paper, and the only book in use — (it was the only one they possessed) — was Chesterfield's Rules of Politeness. This was called a hedge-school, from the fact, I suppose, of the master, in fine weather, being surrounded by his pupils under the shelter of a hedge. These schools, which are not uncommon, prove the Irish to be (what has often been said of them) anxious to provide themselves with the benefits of education.


The land in this district is good, and the rent of farms of from twenty to five-and-twenty acres, within six or seven miles from Waterford, ranges from thirty to forty shillings per acre, which is well paid. The produce will average eight barrels of wheat.


Pigs constitute an important part of a farmer's stock; one tenant, for instance, on the Earl of Besborough's estate, a short time ago, sold eleven for £78,and one of Lord Donoughmore's tenants, a widow, sold thirty-five for £350. At one establishment in Carrick, between the 1st of November and the 1st of April, no fewer than 150 were daily killed, for six days in the week.




---

p.268


The agriculture of the county is considerably improved. Ten years ago the farmers were accustomed to plough with four people and two horses, but now they generally use the iron swing plough, with a pair of horses and only one man.


Major Curry admitted that Poor Laws are inevitable; at the same time he was of opinion that the administration of them, and the discrimination of proper objects, would be attended with great difficulty. The money, he added, now so liberally bestowed upon mendicants, does not appear to be so much the consequence of real charity, as of a superstitious dread of beggars' curses.


The mansion of Besborough contains some good paintings, and in other respects is said to be well worth visiting. We had, however, no time for inspecting it; besides I thought it more important to examine the agricultural state of the country, and to investigate the physical and moral condition of its people, than to wander through the stately interiors of the seats of noblemen. Lord Besborough had been making extensive improvements in more completely draining a tract of



---

p.269




boggy ground, by straightening and deepening the drains; the uneven surface and softness of the morass rendered the use of oxen necessary in the process of ploughing. His lordship's estate in this neighbourhood, contains about 25,000 acres, and the rental is nearly £16,000 per annum; coupled with the Carlow property, the amount is about £30,000.


From Pilltown to Carrick-on-Suire, in the county of Tipperary, the picturesque and rich valley of the Suire is seen to great advantage. After crossing the bridge, into the county of Waterford, and going leisurely up the long hill on the road towards Portlaw and Mayfield, the scenery was indeed truly beautiful; I think I never saw more verdant fields, or a richer prospect. The town of Carrick — with its fine old castle, its ancient bridge, and the curious square tower of the monastery in Carrick Beg — lay below. In the distance were the mountains of Kilkenny; and in the valleys at their feet, lay the mansions and spreading woods of Castletown and Besborough.


The country afterwards possesses but little interest



---

p.270




till we approach Curraghmore, the magnificent domain of the Marquis of Water ford. This domain is said to contain 4600 acres, and to be one of the largest, as well as one of the most beautiful parks of the United Kingdom. It is traversed by the river Clodagh, whose banks are clothed with timber of the most magnificent description — the Norwegian firs being said by **Inglis**, a competent authority on the point, to equal those on the banks of the Glommen in "old Norway." The gates of the domain being locked (a circumstance that did not much surprise me), I was thwarted in my desire of driving through the park, and was obliged to keep at the outside of the walls, without getting so much as a glimpse of the house, and but little more of the grounds surrounding it. On an eminence to the left of the road is an unfinished tower, intended to have been 120 feet high, and to resemble one of the national pillar towers. It was built by the late Marquis of Waterford, and dedicated to the memory of his eldest son, who was killed in consequence of a fall from his horse.




---

p.271


Although I possessed a letter of introduction to a gentleman at Portlaw, for the purpose of obtaining permission to view these celebrated grounds, it was of no avail. The Marquis, he informed me, previously to leaving the country, had given the strictest orders that no person should be allowed to see his grounds. The character of the Marquis of Waterford has been too frequently before the public to require any comments from me; but I may, perhaps, be permitted to express my regret, that the rashness and fearlessness of personal danger, for which this young nobleman is so extensively distinguished, should be unaccompanied, in his case, by the liberal and generous feelings which usually attend those dangerous qualities. To be a practical illustration of the fable of the dog in the manger, ought to be beneath the ambition, one would suppose, of even the Marquis of Waterford.


Before reaching Curraghmore, we passed a tall stone of granite, standing erect on the right of the road. It was about eight feet high, and



---

p.272



two feet six inches thick. A stone, the situation of which corresponds with that alluded to, is mentioned by **Ryland**, who states, that amongst the country people various traditions prevail respecting the cause of its elevation. At the distance, he adds, of about forty yards within the hedge on the side of the road, there were discovered, in the year 1810, several subterranean chambers. These are supposed (continues the same author) to have been used as hiding places during the various persecutions, disturbances, and civil wars, which have for centuries affected this unhappy country.


In the neighbourhood of the Marquis of Waterford's wide-extending and exclusive domain, a manufacturing establishment, which gives employment, and dispenses happiness, amongst the once destitute population of the district, prefers a strong claim to the attention of the traveller. I allude to the cotton factory established at Mayfield, by David Malcolmson, a member of the Society of Friends, and a man well known and much respected in Ireland. The cotton here goes



---

p.273



through every process of the business, till bleached and made up for sale. These works give constant employment to about 1000 persons, the comfortable appearance of whom and their families may be viewed as an indication of the benefit that would result to the community, were employment more general at all periods. It is a well ascertained fact, that where manufactories are thinly scattered in a country, there the manufacturer has the most difficulty in obtaining a supply of suitable work-people, and of retaining them after they have become useful to him; an extension, therefore, of the manufactures of Ireland, would be alike beneficial to the employer and the employed. The machinery at Mayfield is propelled by steam and water power, and some of the water-wheels are of large dimensions. The price of coals, when I visited the works, was from 20s. to 28s. per ton; in summer they are lower.


No attempt, I was glad to find, had ever been made to injure the mills or machinery, nor had any regular turn-outs, so frequent in England, taken place. The work-people receive wages from the


---

p.274




moment they go into the mill; and schooling, for which they only pay a halfpenny each per week, is provided for the children. Dr. Martin, the physician to the establishment, accompanied me to the school, which is conducted upon the principles of the National Board of Education. It was truly gratifying to witness the extreme quickness of the Irish children; little creatures of seven years old pointed out the different countries on the maps, and their peculiarities, stating the distinctive productions of each; and the older boys read and wrote in a superior manner, and were well versed in mathematics. Both the school-room and factory were clean and airy, and all the children I saw had the appearance of health.


My visit to the cotton factory at Mayfield yielded me much gratification. It is the only establishment of the kind in the south of Ireland; but from what I saw in it I am confirmed in the opinion which I had previously formed, that manufactures, if commenced and conducted on a proper principle, may safely be established in any



---

p.275




part of the island. Mayfield has a Temperance Society, consisting of 485 members, fifty of whom practice total abstinence.


We returned to Carrick by a more level road, nearer the Suire, which affords a view lower down the river. Having two or three hours here before the coach came up, I visited the old castle, which formerly belonged to the Duke of Ormond. Part of the old tower walls remain. At Carrickbeg, on the south side of the Suire, in the county of Waterford, is seen the narrow and very singular tall tower of the Franciscan chapel or monastery founded by the Duke of Ormond in 1336. The foundation of the steeple, says **Ryland**, consists of a single stone, on which the lower part rests, and supports the entire weight of the superstructure.


**Inglis**, and other travellers, speak disparagingly of Carrick, but, in the short time I had an opportunity of seeing the place, I was disposed to think considerable improvement was going on. Fortunately it was the market day, and I had a better chance of forming a correct opinion of the countrypeople, as well as of the town. I saw very few of 



---

p.276




the symptoms of destitution enlarged upon by **Inglis**; the people looked cheerful and active; and I was told that trade was improving. True, I observed the small disgusting bits of meat, and the backs and tails of pigs — but where, in the south of Ireland, do you not see them? These things, not being peculiar to Carrick, have no right to be cited especially against it. Whilst I stayed, a party of gentlemen and engineers were attending a meeting for the improvement of the navigation of the river, which is at present navigable for large sloops as far as Carrick. The population of the town is about 10,000.




---

p.277


Ride from Carrick to Clonmel — Whiskey-drinking in Clonmel — Public buildings — Roads — Corruption in the revenue department — Scarcity of birds in Ireland — Introduction to Mr. Bianconi — Account of that gentleman — His opinion of tithes — Birth-place of Sterne — Ride to Clogheen — From thence to Lismore — Pass in the Knockmeledown Mountains — General Blakeney and Mr. Eeles — Civility of the car-drivers — Approach to Lismore — Woody and picturesque dell — Lismore Castle — Anecdote of James II — Ancient Lismore — The Duke of Devonshire — Visit to an experimental farm belonging to the Duke — Want of employment about Lismore — Geology of the district — Visit to Mount Melleray.
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The ride from Carrick to Clonmel is full of beauty; and that I might the more freely enjoy it, I took my place on the outside of a caravan, resembling an omnibus, which carried twelve inside. My fare was 1s. 6d. for fifteen miles.


The land between Carrick and Clonmel is of excellent quality, and produces from eight to twelve barrels of wheat per acre; the rent being 30s. The labourers are employed only half their



---

p.278




time. The population of Clonmel is about 16,000.


Whiskey drinking prevails to a great extent in Clonmel, and in the opinion of some judicious persons with whom I conversed, had increased in consequence of the reduction of the duty. The inhabitants of the towns drink much more than those of the country; and, accordingly, a labourer earning six or seven shillings a week, may be considered better off than a mechanic who gets twenty. It was the opinion of the same gentlemen, that the police, if properly conducted, might effectually check illicit distillation in every part of Ireland. With the laudable view of abating the nuisance of dram-drinking, a Temperance Society was established in Clonmel, but the violence of political partisanship caused it to be speedily abandoned. Clonmel contains neither a public school nor a public library; indeed, the nobility and gentry seem to care but little for the prosperity of the place, and party-feeling runs so high as to oppose serious obstacles to its improvement.




---

p.279


A considerable portion of the old wall and towers of Clonmel still remain, adjoining the church in Mary-street. The appearance of the church, a fine Gothic building, has been very materially injured by the insertion of ugly modern sash windows. These alterations, by some considered improvements, are, in my opinion, conceived in exceedingly bad taste.


The Jail is a splendid building, and contained, when I visited Clonmel, upwards of four hundred prisoners — charged, for the most part, with minor offences.


According to the opinion of an intelligent gentleman of Clonmel, with whom I had an opportunity of conversing, the grand jury of Wexford are an example to the county as regards their management of the roads, whilst in the county of Tipperary the very reverse is the case. A road, by the way, from Clonmel, through Cashel and Thurles, would be a great convenience. The same gentleman, in allusion to the subject of poor laws, thought that the general opinion was *against* the administration of them by the grand-jury:


---

p.280




for his own part, he should like to see them under the control of a Board of Commissioners *composed of Englishmen.* This gentleman, I should add, was a conservative. He admitted, in the course of conversation, that nothing could exceed the corruption that prevailed, under former governments, in the revenue department. Even men in authority were in the habit of giving the distillers notice of the approach of the officers; and at Thurles, *public* notice was given, by the ringing of the market bell!


In consequence of the scarcity of wood, Ireland does not possess one half the number of birds that are to be met with in England; — among others, the nightingale and the woodpecker are never found, except in the vicinity of Cork, where the latter is occasionally seen; indeed, I saw one there. The golden eagle and the penguin falcon frequent the cliffs on the lakes, five or six miles to the south of Clonmel; and the cinerious shearwater may be occasionally met with on the coast. Some beautiful wavellite, found near Clonmel, was shewn to me. A few years since, some



---

p.281



specimens of wavellite or hydrargillite, probably the most splendid that were ever presented to the eye of the mineralogist, were found near Clonmel. They were of a deep green colour, and were discovered in searching for coal; some of them sold for several pounds each. The colour of the Clonmel wavellite is much superior to that of Germany and Cornwall. In the limestone of Clonmel, the geologist may obtain fine specimens of the cardium Hibernicum, and the other fossils peculiar to this formation.


At Clonmel I had the pleasure of being introduced to **Mr. Bianconi**, to whom Ireland is greatly indebted for his spirited and extensive improvements in the mode of communication by travelling. Mr. Bianconi is an Italian, and was respectably connected. Many reasons have been assigned for his departure from his native country, but the true one, probably, is that given by **Inglis**, who says that he was intrusted by his parents to the care of an individual who was then setting out on a commercial journey to Britain, and was employed by him to carry small 


---

p.282




prints round the country for sale. "It was while trudging, as he was often accustomed,"' continues the same pleasant writer, "between Waterford and Clonmel, that it first occurred to him, how agreeable it would be if any cheap conveyance passed along the road, to carry himself and his burden; and some indistinct project then began to be entertained, respecting the establishment of such a conveyance; but it has been erroneously stated, in some memoirs of Mr. Bianconi, that have from time to time appeared, that he set up a car to assist himself as an itinerant print merchant. Gradually he amassed a little money; but it was not until after he had taken advantage of then existing circumstances, to enter into the bullion trade, and had realized a little capital, that he started his first car. For some little time he met with but indifferent success: but gradually the public began to appreciate the convenience; and at length the success of the first car induced him to start a second, and to persevere, until he has become what he now is, one of the largest proprietors of horses and vehicles in



---

p.283




Europe." This enterprising individual has no fewer than eight hundred horses employed on the road in public cars, throughout all the south, and a considerable part of the west of Ireland. The fares are exceedingly moderate, and the accommodation invariably good. Mr. Bianconi stated to me his conviction that the country, generally, was improving — that the moral condition of the population was becoming gradually elevated — and added his belief, that mills or manufactories might be safely erected even in the very worst part of the island. The penal laws, he remarked, had excited a suspicious disposition in the people, and had been attended with great persecution and suffering. Tithes he spoke of as a great nuisance; when the tithe-collector visited him, he told him he might take the car standing at his door, but peremptorily refused to pay anything.


Clonmel possesses manufactures both in cotton and woollen; and the trade upon the Suire, which is navigable no higher than Clonmel, is principally in corn and flour. Clonmel, I must not omit to mention, is famous as being the birth-place of



---

p.284


**Sterne**. I went to look for the house where he was born, in an obscure part of the town, but much doubt hangs about its identity.


The ride from Clonmel to Clogheen lies, first along the rich valley on the east side of the river Suire, and afterwards on more elevated ground, interspersed with the ruins of ancient castles and churches. About six miles from the former place, after crossing a bridge of fourteen arches over the Suire, we passed through the village of Ardfinane, in the county of Tipperary. Here are the ruins of two castles, one of them in a picturesque situation on a prominent grey limestone rock near the river, commanding the town, the river, and the bridge. This castle was built by King John in 1184, and has both a round and a square tower; it did not escape the battery of Cromwell. After passing the bridge, and winding up the opposite bank, a fine view is to be had of this wide and majestic river, with its verdant valley inclosed within romantic rocks. The land, too, of this district is excellent, and very suitable for green crops; few, however, are to be seen. The fences are merely



---

p.285



mounds of earth, and the country, after leaving the valley, is bare, having scarcely a tree or shrub to break its monotony, until we begin to descend towards Clogheen; the country then becomes beautiful.


From this neat village, seated on the banks of a stream which joins the river Suire, I travelled in the mail-car to Lismore, and was the only passenger. After leaving the town, we ascended for several miles, by a pass through the Knockmeledown Mountains, having Clogheen and the valley of the Suire below, and the rock of Cashel, boldly displayed in the distance. As we advanced up this pass, new beauties opened upon us, not the least of which was Shanbally Castle, with the richly wooded domain of Lord Lismore. From Clogheen, the mountain ground is extremely barren, and continues so till within two or three miles of Lismore. The present improved road is of comparatively easy ascent, and the horse broke trot for only a short distance. On reaching the summit, a splendid view was presented of the Galtee and other mountains, the 



---

p.286



most elevated points being clothed with sheets of snow, whose whiteness, covered with sunshine, contrasted finely with the dark clouds behind. Looking towards Lismore, an extraordinarily bleak and barren prospect lay before us; nothing to be seen but range after range of brown wild moor, stretching out and losing its distinctness in the distance, without either field, or tree, or building, or an animal of any description. I looked in vain for the sort of country in which I had imagined the beautiful and romantic Lismore to be situated.


The mountains above alluded to are thus described by the **Rev. R. H. Ryland**; "Those wild and lonely mountains, enveloped during a great portion of the year in mist and fog, and seldom visited except by the sportsman and summer tourist, were for a long period the retreat of General Blakeney, an eccentric being who 'loved not man, nor woman either.' After a continuance of some years in the gaieties of the world, and while still in the prime of life, this gentleman constructed a dwelling on one of the hills which 



---

p.287



compose this range; and with a single male attendant, for he never admitted females into his residence, retired to live in solitude. He continued in the mountain until his death, and, according to his own wish, was buried near his residence, with his dog and gun." This taste for being buried in mountain solitudes was not peculiar to General Blakeney. The driver pointed out the summit of the highest of the Knockmeledown Mountains (2,700 feet high) where a **Mr. Eeles** was buried, along with his horse and dog. He was placed, according to his own request, in an erect position, with his head downwards. **Ryland** confirms the former part of this information. **Mr. Eeles** published many papers on electricity, and Letters from Lismore.


The Irish car-drivers are so civil, that if a leading question be asked them, and they believe you wish it to be answered in the affirmative, they are certain to agree with you. A snow storm having assailed us in going over these dreary mountains, I inquired of the driver, "if the snow had not come earlier in the season than usual?" 


---

p.288




"By gad," he answered, "it is a grate dale." Of the next driver I asked "if the snow did not generally come sooner than it had this season?" and he also answered in the affirmative. Their language is generally poetical and figurative, to which their emphatic and animated manner of delivery adds considerable effect. As we were ascending this inclined plane, with a vast extent of country exhibited below — "Now," said the driver, "the country looks barren and bare, but it is beautiful when the corn is in its bloom."


As we descended the moor, the dreary monotony became a little relieved by two or three miserable, half-starved sheep, which were endeavouring to pick a scanty morsel of vegetable food, not worth the name of grass, and were far too hungry and too poor to notice the car as it passed close to them. The next evidences of civilization appeared as we approached Lismore, in the shape of several neat cottages, built at intervals at a short distance from the road, and surrounded by small patches of cultivated ground, part of the moory black soil of the mountain. These little



---

p.289




settlements belong to the Duke of Devonshire, and are occupied by those who have been dislodged from more favoured situations, near the Castle of Lismore. The land around them was wet, and not likely to produce potatoes of good quality. A considerable extent of land in this district, belonging also to the Duke, has lately been planted, but it requires draining, and the trees cannot be expected to thrive till this is more effectually accomplished.


We at length dropt suddenly into a woody dell, by the side of a rapid and noisy stream, which rushed through the wood. Our course now lay through woody and rocky scenery of great beauty — the road winding along a narrow and romantic vale, which continued till we reached Lismore, and here and there approaching the brooks that fell in picturesque and pleasant cascades.


I lost no time in visiting the castle. In the first gateway, on entering the purlieus, are two spaces beneath the archway, formerly occupied, as at the Horse Guards in London, by two horsemen. This passed, an avenue of fine trees,



---

p.290




enclosed by high walls, leads to the second gateway, which forms the entrance to the court, or square yard, of the castle. Here I was surprised by the servant, when he opened the door, addressing me by name; I found that he had formerly lived in the town where I reside. Colonel Curry, to whom I carried a note of introduction, obligingly conducted me over the castle, and accompanied me through the pleasure-grounds and gardens. Lismore is indeed an interesting place: far more beautiful than I had anticipated, and perhaps rendered still more so by the dreary country through which we approached it. One thing, and only one, disappointed me. The town encroaches on one side of the castle, and for this I was not prepared — the drawings of Lismore invariably presenting us with its most beautiful aspect — its park, its deep groves, its rocky and varied scenery. The castle stands on the side of a bank, which rises abruptly from the Blackwater River; the towers, indeed, seem to be a portion of the bank, so perfectly is the slope continued by the gradual tapering of the walls



---

p.291




upwards. Except on a very close inspection, the base of the building is concealed from view, by beautiful arbutus, and evergreens of every variety, oaks, and laurels of great luxuriance. Higher up the river is a very beautiful grove, in which walks, cut out of the rugged banks, afford many admirable stations for viewing the Blackwater, in its course to Cappoquin. In the distance lies Belmont, the seat of **Sir Richard Keane**. Here, beneath these romantic pathways, the river expands to a considerable breadth, gliding along serenely in narrow wavy lines, with scarce perceptible motion. The opposite bank is exceedingly rich and beautiful, and was ornamented by the late Dean Scott, in unison with the surrounding landscape. In the valley, and on the sides of the distant hills, are plantations of large extent, belonging to the Duke of Devonshire.


The views from the various windows of the castle, which are raised an extraordinary height above the Blackwater, are surpassingly beautiful. It is told of James II., says **Ryland**, that when he dined at the castle, "the agitated monarch, on



---

p.292



looking out of the window, was so struck at perceiving the vast height at which he stood, and the rapid river running beneath him, that he started back with evident dismay." The interior of the noble structure was rebuilt about twenty years ago, and is elegantly furnished. There are some splendid paintings, and excellent tapestry.


Lismore was once a celebrated city, and ranked amongst the most nourishing places in Ireland. It is celebrated as having been the birth-place of the dramatist **Congreve**; the ingenious and eccentric Henry Eeles (of whom mention is made in a previous page); and of **Robert Boyle**, one of the most distinguished of philosophers. Here, also, Alfred is supposed to have derived much of the knowledge which has since immortalized his name. In the year 636, Lismore was a Bishop's see,and is said to have consisted chiefly of the habitations of the most learned monks, of royal abbots, and of saints and hermits. "Lessmor," says an old writer, "is a famous and Holy City, half of which is an asylum into which no woman dares enter; but it is full of cells and holy monasteries: and religious



---

p.293




men, in great numbers, abide there; and thither holy men flock together from all parts of Ireland: and not only from Ireland, but also from England and Britain, being desirous to remove from thence to Christ." **Ryland** states that "there were many, some say twenty, churches in Lismore, of which the ruins of seven were discernible a few years since; but all the ancient buildings of this ungallant city are now entirely removed, except the Cathedral and the Castle."


The population is now only about 3,000, and there is only one church. The castle was built by King John in the year 1185, on the site of an ancient abbey; it was afterwards taken by the Irish, and was for many years the episcopal residence, until **Miler Magrath, Archbishop of Cashel**, and Bishop of this see, granted it, together with the manor of Lismore, to **Sir Walter Raleigh**, from whom this and other property was purchased by the celebrated **Sir Richard Boyle**, afterwards Earl of Cork. From Youghal, Tallow, Dungarvon, and Lismore, the present Duke of Devonshire derives an income of nearly £40,000



---

p.294




per annum, and the leases are fast dropping in. I have been told that from his Irish property altogether, he receives £60,000 per annum. He has expended large sums of money in improving and beautifying the town and precincts; and evinces the most liberal disposition towards his numerous tenantry. I have pleasure in confirming, as far as my observation extended, the favourable statements made by both **Inglis** and **Ryland** respecting this great proprietor; though there are some in the neighbourhood of Youghal, who, whilst they willingly bear witness to his liberality, are of opinion that it scarcely corresponds with the amazing extent of his Irish revenues.


An experimental farm of 360 acres is kept by the Duke's agent, who has a clever agriculturist in Mr. Ferguson, a Scotchman. The farm buildings are excellent, and the implements and horses well adapted to successful husbandry. I saw 25 acres of very good turnips, well managed, and free from weeds; some of them were manured with bones — but the peculiarity of the season prevented the comparison of bones with other manures, from


---

p.295



being decisive. I was not a little surprised to see a field of oats growing luxuriantly in December; they had been sown late in autumn, at which season, in that climate, they succeed well. Oats generally yield from ten to fourteen barrels per acre; barley ten; and wheat eight barrels. The farms are let upon a corn rent. Land that yields the produce above stated, lets for from 30s. to 35s. per acre. The mountain land may be had at from 5s. to 10s. Lime is cheap, costing from 8 1/2d. to 9d. per barrel; but if the farmer burns it himself, it will be only from 6d. to 7d. Limestone prevails on both sides the river. Coals, at the time I visited the farm, were from 28s. to 30s. per ton — a much higher price than usual. At this farm I saw a complete little thrashing machine, composed of iron; the space which it occupied is but trifling, and it requires only two horses. They walk over the tumbling shaft, which is within the ground. The price of this machine, when set up, is from forty to fifty pounds; it is made by McCarthy of Old Crummock. The turnip harrows, though equal to any in the country, or


---

p.296




perhaps in Scotland, were less effective than they might be. With respect to the several crops produced here, potatoes were stated to be only a moderate crop throughout the country. Clover is sometimes sown in June, after a crop of rye-grass has been mown; the land is then ploughed, and sown with clover. Sometimes rye-grass is sown in the autumn, without clover, after a crop of oats or wheat has been taken off the ground. It is mown in May, and given to horses or cattle in the house. Previously to sowing grain, the land is ploughed with the Scotch plough, and well harrowed; then a small wooden plough, without iron on the mould-board, is used for the purpose of ploughing in the seed. Under this process, the ground, not being left smooth, is less liable to become hard and stiff.


The labourers in the neighbourhood, except those employed by Colonel Curry, are engaged only about one-fourth of their time. "Men come two, three, and even five miles," said Mr. Bible, the innkeeper at Lismore, "and wait about my steps, slapping their feet to keep some warmth



---

p.297



in them. It would break the heart of any gentleman to see them. They come at five and six in the morning, and dozens often go away, wet through and discouraged, after finding no work." Tithe is paid by the Duke's tenants; the rent, indeed, would not be taken without it. With these exceptions, not a farthing of tithe is paid in the neighbourhood.


Opposite the castle is an excellent salmon fishery, at which as many as eight hundred fish are sometimes taken at one time, and sent to England. In the neighbourhood of Lismore, slate quarries have been successfully worked. The bed of roof slate, which is not of any great thickness, (**Ryland** informs us) rests upon a coarse grey slate; above the roof slate is a rock of a silicious nature; higher up is a bed of conglomerate; and above these is sandstone, varying from a fine building material, resembling Portland stone, to a coarse soft rock having the appearance of indurated sand. The river may be considered the boundary of these formations; and the component parts of the hills, in this portion of the county of


---

p.298




Waterford, may generally be classed according to the foregoing description. In some places the silicious slate is wanting, and in others the sandstone is red. The rocks are rich in minerals; iron, lead, and copper ore, are of frequent occurrence, and have, at remote periods, engaged the attention of the proprietors of the soil. Lead ore is found at the Bridge of Lismore.


Being provided, by the kindness of Colonel Curry, not only with a note of introduction to the Rev. Mr. Ryan, the superintendant of the Trappist Settlement at Mount Melleray, but with a horse and servant to convey and accompany me thither, I set off to inspect that interesting and singular establishment. Mount Melleray (a name given by the monks themselves) is situated near Cappoquin, in the midst of a vast tract of barren heath, on the side of the Knockmeledown Mountains, which were covered with snow. The buildings are of immense magnitude, and though certainly striking from the loneliness of their position, and interesting from the associations connected with the history of their inhabitants,



---

p.299



have nothing to recommend them as specimens of architectural beauty. They strongly reminded me of the drawings of the Hospices on the Alps. Mr. Ryan received me with great politeness, and shewed every disposition to communicate information on the subject which had induced me to obtrude upon his privacy. In 1831, it appears, seventy-eight monks, who, during the previous fifteen years, had lived happy and contented under the direction of M. Saulmer, employing themselves in cultivating the barren lands of Brittany, were forcibly expelled from the Monastery of La Trappe of Melleraye — their expulsion being attended with acts of brutal violence, ''accompanied" (to use the words of Mr. Ryan) "by many atrocious circumstances, based upon accusations the most stupid and calumnious." On arriving in Ireland, **Sir Richard Keane** granted them, at a nominal rent, six hundred statute acres of moor and bog land, on a lease of a hundred years. This they instantly began to cultivate; they at the same time began to raise their extensive buildings: and it is a remarkable fact — a 



---

p.300



fact, by the way, which speaks with singular emphasis against the indispensableness of a compulsory church — that though possessed of only *one sixpence* on their arrival at Mount Melleray, they raised, within the short space of three years, a series of structures that would have cost, if paid for at the usual value of work, not less than £ 10,000. They were, however, gratuitously assisted in their stupendous undertakings (for such they may indeed be called), by the people on every side. In a country where tithe has nearly ceased to be collected, a small company of religious men (sixty in number), have succeeded, though pennyless, in converting a wilderness into a fertile place, and in planting in that wilderness an immense and costly habitation. This can only be accounted for by the fact, that the religion they professed was the religion of the people, and that the people honoured and respected them for the virtues that adorned it. The monks of Mount Melleray, when I visited their establishment, had 120 acres under cultivation, yielding fine crops of rye, oats, turnips, and potatoes. Their gardens,



---

p.301



too, abound in every variety of vegetables. They have planted, moreover, 120,000 forest trees; so that in a few years, the face of the country, so lately brown, and bare of beauty, will be covered with verdure. Besides the land granted to the Trappists, **Sir Richard Keane** had 5000 acres of bog, all of which was untenanted and uncultivated: since the settlement of the monks, however, the whole of it has become tenanted, and is now undergoing cultivation. Buildings are springing up on every side, and the barren waste is gradually changing into a fruitful and smiling land.


The Trappists are of the Cistercian order, and their object is to educate the poor, to promote agriculture, and to improve the general condition of the people. They observe the strictest silence — no one being allowed to speak, except to his superior; and live in the most exact conformity to rigid rules. All rise at two o'clock in the morning, both summer and winter, and engage in the exercise of devotion from that hour till six. Seven in the evening is their time for retiring to


---

p.302




rest. The dormitories are very large — the chapel was lighted with tapers, dimly and gloomily. Some of the monks whom I saw, wore woollen dresses, of the natural colour, having large hoods. Before leaving Mount Melleray I partook of the hospitality of the superior, who supplied me with some excellent bread and butter, both of them the produce of the land belonging to the brotherhood. The bread contained a considerable portion of rye. The inmates of Mount Melleray live exclusively on vegetable diet; and never touch wine or fermented liquor, except as medicine.




---

p.303


Journey from Lismore to Tallow — Youghal — Myrtle Grove, Sir Walter Raleigh's — Spot where potatoes were first grown in Ireland — Tobacco — Churchyard of Youghal — Extract from Dr. Smith — The quay — Dispute between the Duke of Devonshire and the Corporation of Youghal — Trade of the town — Schools — Party-spirit — Minerals — Wages and rents — Ardmore Round Tower — Curran — Besborough — The Groves of Blarney — Blarney Castle, and its magic stone — Amethysts near Cork — Bandon — Extraordinary pits near Ross-Carberry — Bantry Bay — The town of Bantry — Coral-sand — Mines — Agriculture of the neighbourhood — Further account of Bantry — Departure for Glengariff.
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


The road from Lismore towards Tallow has a beech hedge on each side, and is superior to most I had met with. The land looked well, and was laid out in square fields; and the farm houses are respectable. This district, it is scarcely necessary to say, belongs to the Duke of Devonshire. The country is his, I believe, as far as the town of Tallow, whose Schools, and Alms-houses, and respectable Inn, all lately erected (the inn being rent



---

p.304




free), testify the advantages of a liberal and benevolent proprietor. Near Tallow are seen the ruins of Lisfining Castle, a fortress of the Earl of Desmond, and, in the distance, the majestic mountains of Knockmeledown. I recognised with pleasure, in the distance, the spire and buildings of Mount Melleray, in solitary wildness amidst the snow.


The land became more sterile as we proceeded; and instead of the furze hedges, met with elsewhere, we had now mere barren banks of earth. This district belongs, I think, to Mr. Smith, who allows the poor to have turf at 11d. per load, they being at the labour of digging and drying it. The cabins here are miserable things. The people of this part of the country speak Irish — many of them not knowing a word of English. They have an unpleasant and uncivilized appearance — many of them at least — arising from the projection of the upper gums. I here saw several instances of the old-fashioned and sociable mode of travelling on pillion; the couples jogged along very comfortably.




---

p.305


A hilly, tedious road, and a jaded horse, rendered the view of Youghal very agreeable; but independently of this, the view of the mouth of the Blackwater, which forms the bay of Youghal, in conjunction with the old Castle and town, and a distant glimpse of the Atlantic, and the Round Tower of Ardmore, had a fine effect, on descending the hill. My introduction here was to a highly respectable member of the Society of Friends, whom I had the pleasure of finding liberal and charitable in his opinions, political and religious. Youghal contains about sixty members of this society, who have a small and neat, though unostentatious Meeting-house.


Not by any means the least interesting object in Youghal is Myrtle Grove, formerly the residence of **Sir Walter Raleigh**, and now occupied by Colonel Fount, who seems to have a pleasure in keeping up the antique appearance of the abode. With the exception of the windows, which have been modernized, this venerable mansion remains pretty nearly as it was in the days of its great but unfortunate possessor: the roof consists of small



---

p.306



red tiles; some portion of the old entrance yet stands; and the interior of the walls, which are six feet thick, is covered with handsome oak wainscotting. In the drawing-room is an oaken mantel-piece, beautifully carved. The house is surrounded by the most luxuriant evergreens. The arbutus, myrtles, and verbena, grow here to a great size. These shrubs, and the geraniums, were all in flower on the 11th of December. The spot where the first potatoes grew in Ireland, was pointed out to me. The person, it is said, who planted them, imagining that the apples which grow on the stalks were the portions to be used, gathered them, but, not liking their taste, neglected the roots; till the ground being afterwards dug, for the purpose of sowing some other grain, potatoes were discovered therein, and to the surprise of the planter greatly increased. From those few potatoes, the produce of those introduced by **Sir Walter Raleigh** from Virginia, the whole country was furnished with seed. Sir Walter introduced also tobacco, which was afterwards cultivated to a considerable extent in Ireland; he brought, at the 



---

p.307



same time, the celebrated **Affane cherry**, from the Canary lsles. Sir Walter received, as stated by **Mr. Ryland**, a grant of 42,000 acres of land in this part of Ireland, at a rent of a hundred marks sterling a year. The old town wall forms one of the garden boundaries.


Another object of considerable interest is the churchyard at Youghal — a steep, undulating bank of considerable elevation, ornamented with trees, and walks tastefully laid out. This picturesque grave-yard, which contains several ancient tombstones, commands extensive views of the surrounding country. The church, a large and massive structure, has been spoilt by the wretched taste displayed in the modern additions. The ancient part, however, in some degree compensates — particularly a large window, which is indeed beautiful. Youghal abounds in ruins — relics of time and turbidence. It suffered severely, we are told, from the wars of the Desmonds in 1579, and was left quite desolate, not a man staying in it, except one poor friar. The Earl of Cork shut himself up in it in the rebellion of



---

p.308




1641, and, suffering great hardship, he died in the castle during those troubles. Youghal was selected by Cromwell for his residence in 1649. When he was in this part of the country, and saw the great improvements made in it by the first Earl of Cork, he said that if there had been such a nobleman in each province of the kingdom, the Irish could never have rebelled.


The large expanded strand of Youghal, says **Dr. Smith**, in his History of Cork, as far as the lowest ebbs uncover it, and probably much further, is no other than a common turf bog covered over with sand and pebbles, from whence not only good turf is dug every season, but also great trees, as fir, hazel, &c, are found. Some years ago, the sand and pebbles were washed away, and discovered great quantities of roots of various trees.[23](javascript:footNote('E830001-002/note023.html')) The same author also mentions, that at Clay Castle, about a mile south-west of the town



---

p.309




of Youghal, is a small promontory composed of a loose sandy clay. The pieces of bank which break off and are washed down by the sea, are by degrees petrified into a very hard firm grit, as solid as any stone. He also states, that the same kind of petrifaction has been observed at Harwich in England. This formation appears to be similar to that which I have elsewhere described as having witnessed at Lough Neagh, and at Conishead Priory in Lancashire, only at the latter places the stone formed is calcareous.


The quay of Youghal, at present in very bad order, might, at a moderate expense, be greatly improved; and a comparatively small outlay of capital, in building houses of accommodation for strangers, might be the source of great advantage to the town, by converting it into a sea-bathing place. The beach is a beautiful one; and, in the immediate neighbourhood, are many eligible sites for building upon. A lighthouse also is much wanted near the entrance to the harbours — not only for vessels coming into it, but for those bound westward.




---

p.310


The town belongs to the Duke of Devonshire, and I was informed that its improvement had been considerably retarded by an unfortunate dispute and law-suit between the Duke and the Corporation — arising out of some question of a political nature. The renewal of leases was refused; and many of the houses, of which the leases had expired, presented a ruinous appearance. After the expenditure of much money, the Corporation gave way. But little, if any, good, however, has attended these unhappy disagreements — both parties having lost much of their former influence, and the borough being now represented independently of either. It does not appear that the Duke is partial to Youghal; for, notwithstanding the adjustment of the differences alluded to, he has done but little, nor does he show a disposition to do much more, for the benefit of the place. In many respects, money might be laid out in profitable speculations; but the occasions are either unnoticed or disregarded. Yet, under all these disadvantages, Youghal is decidedly an improving town. The flour trade



---

p.311



and the timber trade have increased of late; and the prosperity of the place might be still further promoted, by the establishment of a steam-vessel to Liverpool — a project of peculiar moment to the agriculturists — and one that might readily be accomplished, I understand, provided the Duke would take shares to the amount of a few thousand pounds. Although this wealthy nobleman has not done all that the inhabitants of Youghal could have wished, it ought, in justice to him, to be mentioned, that he has built a good inn — given ground, at nominal rents, for some useful public buildings, amongst which are two school-houses — and constantly subscribes to most of the Charities of the town. One large school is attached to the National Board of Education, and, as the Protestant clergy have declined to co-operate, it is left entirely to the control of the Roman Catholics. Another establishment exists, which has been for many years under the Kildare Place Society; it is held in a building which was formerly a barrack, and for which £30 a year is paid to Government;


---

p.312




but as the place is used exclusively for charitable purposes, the rent, which is a paltry one to receive, but a large one to contribute, might be remitted. This establishment consists of a Boys' and Girls' Schools, in distinct buildings, and an Infant School; all well attended to by a committee, annually elected from the subscribers. There is also a repository for enabling the poor to purchase clothing on low terms; and a straw-plat school, and a public Library.


So lamentable has been the effect of party spirit in Youghal, that a benevolent institution, supported by all parties, which supplied coal and meal to the poor, without distinction of sect, was obliged to be abandoned, one of the parties, the Roman Catholics, after a contested election, having withdrawn their accustomed subscriptions. The principal subscribers were Protestants, and the greater part of the relief had been applied to the Roman Catholics. The Protestants, accordingly, established a similar benevolent society, called "The Protestant Relief Society," and restricted its application to the assistance of the



---

p.313




Protestant poor. They divided the town into districts, and to each district appointed a male and a female visitor, whose duty was to visit the poor in their own dwellings, and to bring the particulars of each case before a general meeting of the society. This is decidedly a more humane system than the workhouse plan, and probably more economical; because a man, or any part of his family, who cannot entirely support themselves by employment, are not obliged to give up what they have; and it is found that a very small pittance of relief is sufficient to enable a man to struggle through difficulties, till he gets better employed. On a large scale, however, it is not practicable; even in the small town of Youghal, the violence of party-feeling has injuriously affected its utility.


In the minerals of the district there appears to be a vast source of profitable employment for capital and labour; and an arrangement, I understood, had just been completed with an English Company for beginning to work a rich vein of lead, discovered near the bank of the Blackwater,



---

p.314



about twelve miles up the river, on the estate of Mr. Ussher, of Camphire. Within a few miles of Youghal, both in the Dungarvon Mountains and near Cappoquin, iron ore abounds.


The labourers in the town get from tenpence to a shilling per day, and, in the country, eightpence, without diet. The rent of land within a mile of the town is from £3. to £3. 10s. per acre, and ranges down from that to 30s., further in the country. Land still nearer the mountains lets at from twenty to ten shillings. Potatoes produce about 60 barrels, and wheat, five barrels of twenty stones per acre; barley, eight barrels of sixteen stones; and oats, ten barrels of fourteen stones. In and near the town are the brown-ware potteries.


About five miles from Youghal, stands the Round Tower of Ardmore (which may be seen from elevated parts close to Youghal), composed, according to the statements of some historians, of "cut stones" accurately fitted and cemented together. The height is ninety feet, the diameter, at the base, fifteen. It is divided into four stories, having bands on the outside. Each story contains a



---

p.315




window, and the entrance is sixteen feet from the ground. The Church adjoining the Tower was once a magnificent building.


My journey from Youghal to Cork, a distance of twenty-eight miles, lay through Castle Martyr, the property of the Earl of Shannon, and the beautiful and well-wooded domain of that nobleman. We passed also through Middleton, where **Curran** is said to have received the rudiments of learning. The immediate approach to Cork lies along the shores of the fantastically branching inlets of the sea or harbour, and is exceedingly beautiful. The evening, however, was too far advanced to permit of my seeing its beauties in perfection; besides, I was travelling by a heavy jolting coach, and over bad roads.


I took up my abode for two or three days at Besborough, with a friend who resides in a delightful spot on the side of one of the numerous bays; luxuriant cypresses and evergreens enriching the grounds. My friend kindly accompanied me to the far-famed Blarney, five or six miles from Cork. We took the Mallow road, approaching



---

p.316




Blarney from the eastward, and had to pass over a poor, high country. The celebrated "Groves of Blarney" are indeed beautiful, and I had the pleasure of passing beneath the shade of the long-spreading branches of ancient laurels and yews which compose them; as for the Castle — Blarney Castle — though once a famous fortress, and a noble seat of the Earls of Clancarty, who forfeited a large estate in this county for adhering to King James — it retains but little of its former size or grandeur, being reduced to one massive square tower, the walls of which are matted with long grass, ivy, and wild flowers. Nature has adopted the ruins of man's pomp and strength, and has covered them with a garment of greater beauty than ever they wore in the days of their proudest prosperity. But besides the castle and the groves, this celebrated spot has other attractions. Natural caverns in the rocks lead the way, by steps called the "The Witches' Stairs," to the river; and, on emerging from the obscure passage, the glassy stream, with its quiet accompaniments of wood and crag, bursts suddenly upon the view.




---

p.317


Beautiful as is the scenery that embosoms this ancient ruin, and numerous as are the historical associations connected with it, the distinction it has obtained may be attributed to the prevalence of a strange and ridiculous superstition. "In the highest part of the castle wall," says one who is learned in the fabulous records of Ireland, "a stone is pointed out to visitors, which is supposed to give to whoever kisses it the peculiar privilege of deviating from veracity, with unblushing countenance, whenever it may be convenient. Hence the well-known phrase of "BLARNEY." I indulged my curiosity by ascending the tower to see the magic stone, as well as the surrounding country.


Very fine amethysts, richly coloured, have been found in considerable abundance in a limestone quarry on the Black Rock road, about two miles from Cork; some sufficiently fine to become articles of jewellery. But as the ground on which the quarry is situated, had been for many years the subject of a law-suit, there has not been an opportunity of ascertaining how far the amethyst


---

p.318




veins extended. I collected in the quarry a few small specimens; the crystals are hexagonal prisms, surmounted by hexagonal pyramids. Wavellite has also been found in this vicinity.


From Cork to Bandon, the country is somewhat mountainous for several miles. The Duke of Devonshire has considerable property about the latter place, and nearly the whole of the town belongs to him. The farm houses in the neighbourhood are respectable in appearance, and two, at least, of the resident gentry, Mr. Swanston and Mr. Connor, have contributed not only to the improvement of agriculture, but to the amelioration of the condition of those engaged in it. From Bandon we passed through Clonakilty and Ross-Carberry, formerly called Ross-Alithri (that is, the Field of Pilgrimage.) Ancient writers state that this was once a walled town and a bishop's see, and that the cathedral was founded in the sixth century. There was here, too, a famous university, much resorted to by the inhabitants of the south-west of Ireland. A mile



---

p.319




from the town are two extraordinary pits, eighty yards in depth, into which the sea enters by a subterraneous opening.


Skibbereen, a manufacturing town of nearly 5000 inhabitants, is at the head of Baltimore Harbour. From hence we took a direction almost northerly, and, at a right angle to our road from Cork, across a barren, rocky country, to Bantry, formerly called Ballygobbin, which stands at the head of Bantry Bay, nearly twenty miles in length, and considered to be one of the noblest in the world, and said to be capable of containing all the shipping of Europe. The hills that encircle it are partially wooded, and, in many parts, cultivated to a considerable extent. Parallel with Bantry Bay runs another, Dunmanus Bay, thirteen miles long, and separated from it by a pointed and narrow cape; numerous islands cluster in the distance. Cape Clear, seen from near Bantry, is the most southerly part of Ireland.


At Bantry I found a comfortable inn — an excellent room, well carpeted — and newspapers and books; though, according to general custom, the



---

p.320




entrance and lobby were exceedingly dirty, being without either mats or scrapers. The door, too, was broken.


Bantry is celebrated for its coral-sand, of which I collected a quantity. It is a species of small coral, in branched clusters of from one to two inches in diameter, and of various colours — the small particles being apparently sand — but, when magnified, innumerable minute shells are discovered. This coral-sand is carried as far as twenty miles into the country, and used as manure for heavy land — a purpose which it is said to answer better than any other sort of manure: it is particularly valuable in reclaiming bog-lands. Mr. O'Sullivan, a nephew of Mr. O'Connell, whom I met at the hotel, informed me that it contained from 80 to 85 per cent of lime; from its branched texture I apprehend that it acts also mechanically, and lightens the soil. Fourteen car-loads are used to the acre. Black limestone occurs on the strand, and on the road to Glengariff, but is not much used; lime being obtained from Muskerry, or Macroom, and costing, with the carriage, 



---

p.321



2s. 6d. per barrel; a few years ago it cost 4a. This reduction in price is a consequence of improved roads. Coals, when I was at Bantry, were 24s. a ton, but the usual price is 18s.


On Mr. Hutchinson's property, a mile and a quarter from Bantry, lead ore has been found, but is not worked. The mountains, indeed, are admitted to abound in minerals, and, at the time of my visit, Mr. Bakewell and Captain Powell from Cornwall were engaged in surveying them; with what success I know not, but the most favourable report might reasonably be anticipated. At Beerhaven, on the north side of the bay — one of the points aimed at in the projected railway across the island from Dublin — copper mines are spiritedly worked by Mr. Puxley; and on Lord Audley's property near Ballydehob, thirty miles south of Glengariff, the West Cork Mining Company are engaged in the same interesting process. What an almost boundless source of profitable employment may not the mines alone of Ireland afford to her starving population!


The cattle kept in this mountainous district are


---

p.322




of the small Kerry breed, and are ill-shaped, common-looking animals. The cows, when in full milk, give 12 quarts of milk per day, and 112 lbs. of butter in the season. The keeping of cattle in the house on green food, is unknown here; indeed agriculture and husbandry, in all their departments, are in a somewhat low condition. It is pleasing, however, to record exceptions; and I have satisfaction in stating, that Mr. Shouldham, an English gentleman, devotes much attention and time to the improvement of his land — grows turnips extensively, and other green crops, and feeds a great number of sheep. He is considered, moreover, an excellent magistrate, and bears an unexceptionable private character. The sheep in this district are shorn twice in the year — in May and November; the lambs are shorn in November, and poor, starved, miserable wretches they appear. The sheep are killed at from a year and a half to three years old, and weigh twelve or fifteen pounds per quarter. Here, as in many other parts of Ireland, gorse, or furze hedges prevail. The land produces six bags, or barrels



---

p.323




of wheat, (of twenty stone) per acre, the rent being 30s.


Bantry, considering the decay of its fishery, has improved astonishingly, I was told, within the last ten years. Lord Bantry, the principal proprietor, whose rental is about £12,000 a year, has done, and is still doing, much for the place: yet the population are in a miserable condition, and beggars actually swarm. Men, women, and children, being almost entirely dependent upon fishing for a subsistence, are necessarily reduced to great straits when their precarious source of sustenance, which is often the case, fails. The pilchard fishery was once carried on very profitably at Bantry. These fish were sent to Spain, Portugal, and Italy. Now, I believe, they are rarely caught. Wages are eightpence a day without diet, but the people cannot obtain employment more than half their time. The town possesses a National School, but, as usual, the Protestants withhold their children, and leave the entire management and control of the establishment in the hands of the Catholics; this is the



---

p.324



more singular, because the members of the respective religions, as well as the ministers, mix together in social intercourse, and may be said to be on friendly terms. Bantry has a population of upwards of 4000, and, when I was there, was singularly remarkable for the excessive dirtiness of its streets, its houses, and its people.


I left Bantry on a fine calm morning, when the bay lay like a mirror, reflecting the hills and the sky within its still and bright waters. I had intended taking a boat to Glengariff, a short distance, and should certainly have done so, had not the landlord dissuaded me, advising me to travel by the road. I had no reason to repent having complied with his suggestions; for before I had proceeded very far, a sudden wind sprang up and blew furiously, and, in passing over the mountains, I could see the water, so lately an unruffled plain, torn up and violently agitated by the storm, and covered with wild waves crested with foam. Bantry Bay is a dangerous place: in 1796, a French fleet of twenty-four ships of war was wrecked in or near it. Its rocky and rugged 


---

p.325




shores seem well adapted to the work of destruction.


About a mile and a half on the road to Glengariff, the traveller cannot fail to be struck with a mill and some picturesque waterfalls that dash over rude rocks, and, after forming a copious torrent, fall into a deep and dark channel, inclosed by rocks that open at some distance into Bantry Bay. This rocky chasm is green with holly, and ivy, and other plants, growing luxuriantly out of the several fissures. Further on, on the side of an arm of the bay which wears the appearance of a lake, stands the residence of the Mr. O'Sullivan, whom I met at the inn at Bantry. The road to Glengariff is wild and mountainous, winding alternately among rocks and woods, and over bogs and barren places, and presenting at intervals some very beautiful scenery. On Hungry Hill, for instance, is a celebrated waterfall, said to be one of the largest and highest in Ireland; it may be seen from the road to the left, at a distance of several miles, and is well worth a nearer approach. The mountains here consist 



---

p.326



chiefly of clay slate, and contain several slate quarries. These wild districts, formerly called Vallis Juncosa, according to **Dr. Smith**, were the retreat of the ancient Irish, soon after the arrival of the English, from whence they scarce stirred till the division of the Houses of York and Lancaster obliged many of the latter to quit the country. Dr. Curry, in his Civil Wars of Ireland, states, that in this space, all the Irish, innocent of the rebellion, were required to retire by a certain day, under the penalty of death: and all those found after that time in any other part of the kingdom, man, woman, or child, might be killed by anybody who saw or met them.




---

p.327


Glengariff — Captain White's domain — Agricultural hints — Steep and rugged road to Kenmare — The Marquis of Lansdowne's estates — Eagles — Kenmare — Public buildings — Liberality of the Marquis of Lansdowne — Export and trade of Kenmare — Distressed condition of the cottagers — Advantage of poor-laws to farmers as well as labourers — The "waking" of Michael Sullivan — Road from Kenmare to Darrynane — Dromore Castle — Crookhaven — Raking sea-weed — Extensive and noble prospect — Arrival at Darrynane House — Hospitality of the family — Fast-day — Description of the mansion and grounds — Mr. O'Connell's love of field sports — The Abbey — Sermon in Irish — Devotion of the congregation — Unostentatious character of the priest — Pride of descent — Agriculture and wages — Mines — Mr. O'Connell's estates.
-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


It was my lot to see Glengariff — one of the most picturesque spots in Ireland — at an unfavourable time. In the first place it was winter, and, in the next place, the weather had become uncommonly stormy; so that when I approached the little inn, situated near the top of a narrow creek of the bay, there was but little which seemed to justify the high reputation enjoyed by this sequestred


---

p.328




place. The rocky and woody scenery, the waters of the lake, the quiet coves, and the romantic streams, were obscured by mist and rain; and the buds on the rose trees, which twined about the windows of the inn, were driven by the storm against the glass, and gave a still more dismal effect to a scene already sufficiently desolate. The room to which I was conducted was cold, dark, and dreary; and, after having made several vain attempts to get up a tolerable fire of wet turf, I was forced to pass the time as well as I could in a solitary apartment without one. Having remained here, for the space at least of two or three hours, only half well, my solitude was interrupted by a gentleman of the name of Wright, an engineer and contractor of Skibbereen, with whom I passed the rest of the day most pleasantly. He had endeavoured to pass along the road from Glengariff to Kenmare, but when he arrived at that part where the rocks are nearly perpendicular, the rain and wind became so violent, as to render any further progress impossible. After much consultation as to the best



---

p.329



mode of passing the mountains in the morning, it was ultimately arranged that we should make the attempt together — he, on his part, liberally offering to convey me in his gig — and I, on mine, promising to assist, in case of difficulty.


When I retired to my room, I found the window broken, and was obliged to stuff it, according to the fashion of the country, with some of my clothes. The house contained neither bellows nor warming-pan, and was devoid of some of the very cheapest and most ordinary of luxuries. Such in winter is the hotel of the romantic and delightful Glengariff. I can well fancy that in summer it must be a charming spot, comprehending as it does almost every variety of scenery except the positively sublime; indeed, that it is one of the most attractive of places, we have the concurrent testimony of all who have visited it. The bay abounds in fish, of which we had a supply both to dinner and breakfast.


Close to the inn is the domain of Captain White, Lord Bantry's brother. It is exceedingly beautiful, and says much for the judicious *forbearance* of 


---

p.330




those who have had the arrangement of it, and who, instead of trying to mend nature, have left her almost entirely to herself. Wild woods and glades, valleys full of beauty, and hills that command extensive views, diversify the grounds, which only wanted the brightness of the cheerful arbutus to vie with parks of greater pretension, and more distinguished reputation. I was greatly disappointed with the house; it is a fanciful modern cropped building, with its eaves as if shorn close, and rendered anomalous by an intermixture of castellated architecture.


The scenery from the grounds is of a very superior character, uniting beauty with grandeur. The outlines of the various ranges of mountains were clearly defined; and the bay, with its numerous islands, and great variety of creeks, inlets, and promontories, was displayed in singular loveliness. Hungry Hill, with its abrupt acclivities and towering heights, forms an interesting object in the distance.


The principal proprietors about Glengariff are Lords Bantry, Lansdowne, and Kenmare, and



---

p.331




Mr. White. They are all spoken of as good landlords. Farming societies, I was glad to find, are increasing in that part of the country. It is susceptible of considerable improvement, and although, uneven and rocky, is capable of great fertility. The soil between the rocks is good; and by means of keeping cattle in sheds, cutting their food in the summer, and husbanding the manure, it will vie with those districts commonly looked upon by the superficial observer as more favoured by nature; with the addition of planting, the fertility of the soil would also be increased, and the vicinity of Glengariff become one of surpassing beauty.


About a mile of the road from Glengariff to Kenmare is steeper and more rugged than can well be imagined, and, as a new one was in progress, it had been much neglected. The torrents having washed much of the ground away, had left it in the condition of a series of huge rugged steps. Several persons accompanied us to assist the horse in the arduous ascent, and, in descending on the other side, a rope was fastened to the



---

p.332




wheel of the empty vehicle, as a substitute for a lock. The inclination may be estimated at one in four. The new road, over a part of which we travelled, will be a valuable improvement, the inclination being not more than one in thirty. The usual plan, when a road is out of order, is, for two of the occupiers, or rate-payers, to apply to the magistrates, at the Sessions, for a rate to be laid for the purpose of repairing it: tenders are then delivered; the matter is discussed before the magistrates; and the lowest bidder, provided his securities be approved, is declared the undertaker. A surveyor is appointed to inspect all the roads in the county, and he makes his report, certifying the fulfilment of the contract. The same plan is adopted in the construction of new roads, the applicants providing maps and plans, and submitting them to the inspection of the county surveyor. The new system, said an engineer that I conversed with, has thrown many experienced surveyors out of employment, and many of the contractors offer to do the work at so low a price that they never complete it.




---

p.333


For several miles from Glengariff, the country we passed through was very mountainous, abounding with lakes; and, to the westward, there are said to be upwards of 300 in one short range. Proceeding further, I recognised the bold Mangerton Mountains, and the curiously indented Mac-Gillicuddy's Reeks, above the beautiful lakes of Killarney, which, on my previous journey, I approached from the road on the opposite side. At the summit of the steep and difficult ascent before mentioned, we entered the Marquis of Lansdowne's estates, about five miles from Glengariff, and I was delighted to witness the attempts made on this property, not only to encourage a better system of agriculture and husbandry, but to augment the comforts of the population by the improvement of their dwellings. Neat stone houses, built at the expense of the Marquis, were taking the place of clusters of mean hovels, rudely constructed of mud and thatch; and the tenants are paid for making the fences. The Marquis has also built a school-house in the neighbourhood, and has recently begun to encourage planting.



---

p.334




In these wild and thinly populated districts, eagles abound, and are very destructive among the lambs. A man who assisted us up the steep ascent previously alluded to, said, that on an average he lost six every year. The sheep which we passed wore a miserable, starved look, and the same man (who occupied a small farm on the south side of the mountain) informed us, that in consequence of being shorn in November, they were rendered not worth stealing.


Kenmare is situated at the head of an estuary which runs with a narrow point up to the town, and is about six miles in width at the entrance, and nearly twenty-five miles in length. Vessels of 120 tons burden come close up to the pier, and ships of 500 anchor within a quarter of a mile of it. The pier was lately built, I was told, and cost £1500, half of the expense being paid by the Marquis of Lansdowne, who also promised, with his wonted liberality, to contribute one half of the sum necessary to build a bridge in the neighbourhood, the cost of which was estimated at £6000. A Catholic chapel, and other public buildings, have been likewise



---

p.335



erected at the expense of this munificent nobleman; and such of the cottagers as choose to erect small cabins on his estate, he supplies with timber for the purpose, and £5 towards the expense of building. To those who expend larger sums in constructing better cabins, more is given in proportion: and industry and cleanliness are promoted by premiums awarded to those who keep their cottages in a state of neatness. The Marquis, moreover, has built five schools on his estates, in which both Catholic and Protestant children are instructed, according to the system of the National Board. The proportion of Catholics to Protestants in the neighbourhood, is as forty of the former to one of the latter.


The principal export of Kenmare is grain; the import, iron, coal, and timber. The trade of the town is rapidly increasing. Coals cost from 16s. to 22s. per ton; lime 1s. 2d. per barrel. The wheat crop of the previous year had been deficient, so had potatoes; oats, however, were an average crop. Wheat was selling at from 27s. to 31s. per barrel; oats at 9d., and potatoes at 2 1/2d. per stone.




---

p.336


Notwithstanding the acknowledged improvement of trade and of the country generally, the poor cottagers are in a very distressed condition. The land allotted to them is wet, and, till drained, unsuitable for the cultivation of potatoes; the labourer earns 6d. and sometimes 8d. per day, but is employed scarcely half his time; and many of the small holders, if they had the land for nothing, could not support themselves and families. They are nearly half naked, and are but half fed. This is indeed a wretched state of things — enough to convince the most sceptical of the absolute necessity that exists for the speedy establishment of some system of poor-laws. Nor would the institution of such means be the discharge of a debt of justice to the poor alone; the farmers and the tradesmen would feel it as an important boon, for as many of the large proprietors contribute scarcely anything to the relief of the suffering part of the population, the burden principally falls upon them. It did not appear that any attempt had been made to teach the cottagers a better system of agriculture, or to stimulate 


---

p.337




them to attempt a better system; this, amidst the Marquis's liberality, is a defect much to be regretted. There is but little use in building cottages, unless the inmates have the means of living in them with comfort. If any opinion of mine were likely to meet the attention of the Marquis, and should be fortunate enough to receive his approbation, I would take the liberty of suggesting the propriety of distributing in the neighbourhood, according to the plan recommended so ably by Mr. Blacker, a few agriculturists, under whose experienced superintendance the district would very shortly, I doubt not, display manifest evidences of improvement. The Marquis possesses, in this part of the country, about 42,000 acres of land, the rental of which is about £9,000 per annum. He visits his estates occasionally.


On my way to inspect some of the comfortable looking white-washed cottages on the opposite side of the river, I perceived, from the interest excited among a crowd of people, standing near the water, that some serious accident had happened;


---

p.338




and so indeed it was. On approaching the spot, and making inquiries as to the cause of the assemblage, I learned that the body of a young man, Michael Sullivan, had just been taken out of the river. He had attempted to swim across, the evening before, and was drowned. I crossed by the ferry-boat, which was full of persons going to wake the body, all talking very fluently in Irish; and in a garden or small croft, by the side of which my road lay to the cottages, the corpse of the unfortunate young man was laid, surrounded by friends and relatives, who rent the air with loud strains and dismal lamentations. One female, seated at the head, was fondly stroking the forehead, and smoothing the hair in a most tender and affectionate manner, crying, at the same time, "Ullagore — moveen — ullaloo" — as near as I could understand the somewhat indistinct sounds. Those coming up joined in the cry "ullaloo." It was a most affecting scene. The poor people had collected from the cottages within a considerable distance, and expressed unfeigned sympathy for the bereaved relations of the deceased. One poor old



---

p.339



woman, overcome by the spectacle of grief before her, had fainted, and lay on the ground insensible; but this circumstance, painful as it was, did not in the least interfere with the mourning and lamentation. I received and accepted an invitation to see the body. An inspection of the interior of the cottages, so neat as regarded their outsides, disappointed me: and the land about them was exceedingly poor, and full of large stones. Industry and perseverance would in time render it productive, but the people are unacquainted with the proper method of improving it, neither do they appear to have the means.


Darrynane, the residence of Mr. O'Connell, is distant from Kenmare thirty-one miles, and I was informed by the landlord of the inn at the latter place, and indeed by all that spoke to me on the subject, that I should share, at the residence of the celebrated "Liberator," the hearty welcome which is invariably offered to all who travel the wilds surrounding it. The road from Kenmare to Darrynane is mountainous, — parts of the country being very thinly inhabited, — 


---

p.340




and does not possess a single inn or house of public accommodation; Darrynane, in fact, is the only place of entertainment "for man and horse," and Darrynane is open to all who choose to accept its hospitality. I left Kenmare about ten o'clock in the morning, and had the bay in view nearly the whole way. Not far from Kenmare is Dromore, the residence of Mr. Mahony, who was building, under the superintendence of Messrs. Dean and Notter, architects, a new house of the castellated order. I had occasion to observe, not only in respect of this mansion, but of nearly all those which affect the air of antiquity, that the corbels and battlements are too light and shelly, wanting solidity and strength, and, accordingly, appearing to be, what in truth they are, flimsy *imitations* of a species of architecture, which, fortunately, the altered character of these days renders needless. In consequence of the peculiarity just noticed, much of the picturesqueness and imposing effect of ancient castles, depending greatly upon the bold and massy projections and deep recesses, so finely adapted for



---

p.341



the repose of light and shade, is altogether lost. The site of Dromore Castle is, however, exceedingly favourable, being close to the bay, and, except for the defect before mentioned, possesses boldness and beauty. About three miles further, and about six miles from Kenmare, is Blackwater Bridge, a structure of considerable height, situated in a deep and thickly wooded ravine, through which the river dashes in a copious and noisy stream. The scenery here was remarkably beautiful, even in winter, being enlivened by a variety of exuberant evergreens; and, in the spring and summer of the year, it justifies, I doubt not, the high reputation it has obtained.


At Crookhaven, the next village we came to, are some interesting waterfalls, close adjoining the road. The country for several miles is one almost continuous mass of rock, interspersed with cabins, to which cabbage-gardens are attached. About the doors of these rude habitations may be seen a sheep or two, cattle, and pigs, waiting for a morsel of food — the latter impatiently screaming


---

p.342




at the top of their voices — and the sheep industriously eating the core out of the cabbage stalks. These poor creatures are invariably the images of misery and starvation. Near Crookhaven is the park of Mr. Bland, whose two sons have neat places in the immediate neighbourhood.


At a place called White Strand, the road leads into the bay; and the tide being up at the time we passed along it, the driver seemed to be going out to sea. After passing through the water a short distance, however, he suddenly made a double round the end of the rocks, and regained the road. The people in this district were actively employed in collecting the sea-weed, for the purpose of manure; numbers of men standing up to the middle in the sea, catching the weed with long-toothed and long-shafted rakes, and hauling it ashore, whence it was conveyed in baskets by boys, who carried it on their backs to the land, for their next crop of potatoes. A trifling manufactory of frieze is carried on here, but, generally speaking, work is scarce. Some poor fellows whom I met, said that they could only get two or three weeks' 



---

p.343




work in potato-planting time, at 3s. per week: "they were," they exclaimed, "poor enough," and so indeed they seemed. Copper has been discovered in the mountains, but has not yet been worked.


Old castles abound in the course of the drive from Kenmare; and, from the high moors about two miles before we arrive at the descent to Darrynane, an extensive and noble prospect is commanded. The mighty Atlantic bounds this magnificent view, which includes, among other things worthy of notice, the mouth of the Kenmare river — the islands of Scarriff and Dinish, rising abruptly out of the ocean — the rocks called the Bull, Cow, and Calf, at the extremity of the peninsula which divides Bantry Bay from Kenmare river — and lastly, Darrynane House, and the ruins of Darrynane Abbey, reposing at the foot of the mountains, on the borders of Kenmare River, near the open sea. Having descended the hill, we overtook a company of men, boys, and girls, driving about thirty small horses and mules, laden with panniers of turf; they occupied



---

p.344




the whole breadth of the road for some distance, and, on being asked where they were going, said, "We are taking turf to warm the Liberator."


It was Saturday evening, the 17th of December, when I arrived at Darrynane, and having left my letter of introduction to the proprietor, along with some other papers, in Dublin, I had an opportunity of proving the correctness of the statements which had been made to me at Kenmare respecting the hospitality of the abode. I had, in fact, no other introduction to Darrynane than that I was a stranger and an Englishman, but these were amply sufficient. I was received and treated with the kindest attention, and soon felt myself at home in the house of Mr. O'Connell. At Darrynane I spent the whole of Sunday, and remained there during the night of that day. The family, during my visit, consisted of Maurice O'Connell, John, and Daniel the younger (the Daniel was in Dublin) — two nieces of Mr. O'Connell, who were staying there on a visit, Dr. O'Connell, and Dr. O'Sullivan, the chaplain; Mr. Primrose, the land agent of the estate, and a



---

p.345




magistrate — and several other gentlemen whose names I do not remember. Maurice O'Connell was unfortunately so far from well as to be unable to leave his room.


The day on which I arrived was a fast-day; the table, notwithstanding, was admirably supplied with a variety of fish — and some excellent Kerry mutton, for the use of Protestant strangers. Fourteen different kinds of fish, caught close to the place, are frequently on the table at the same time. The coast abounds with fish; as many as thirty turbot have been caught at one draught..


Darrynane House is an extensive pile of buildings, erected at different periods, and without regard to any particular order of architecture, or any prevailing uniformity of plan. Convenience, and the comfort of his guests, seem to have guided Mr. O'Connell in the enlargement of his mansion. In front of the house, stretches an extensive garden, at the end of which is a fine natural lawn of soft short grass — in spring and summer, the scene of various sports and pleasant recreative



---

p.346




exercises. The sea, which here forms a cove or bay, comes close up to the lawn. The sands of the shore are firm and clean, and the waves of the bay, which struck me as being of a remarkably emerald hue, are interrupted, in their magnificent progress, by a few picturesque rocks. The ruins of the Abbey are at the opposite side of this small bay, a quarter of a mile from Darrynane house. A rookery presents a scene of perpetual animation to the north of the house; and in the same direction are extensive plantations, containing rustic bowers tastefully designed, and winding walks by the side of clear brooks. All these, of course, I saw under considerable disadvantages: but still I saw sufficient to convince me that Darrynane was a lovely spot. The air is peculiarly wholesome, and, during my stay there, a letter was received from Mr. O'Connell, anticipating with pleasure the enjoyments of his native place, and speaking with delight of deriving from its healthy climate a good stock of health to enable him to recommence the tug of war in St. Stephen's. When at Darrynane, hunting is his



---

p.347



favourite exercise; and I was informed that he climbs the rugged mountains after his favourite pack of beagles, with all the untiring activity and buoyancy of youth.


Darrynane was a small abbey of Canons Regular of St. Austin, founded in the seventh century. Nothing now remains of it but the bare walls, the interior space being occupied by gravestones and skulls, of which immense numbers are piled together, bleached by the atmosphere. Within these bare and shattered walls lay the body of Mrs. O'Connell, but it was about to be removed to Dublin.


Learning that I had a wish to hear a sermon in Irish, the priest of the parish invited me to go with him to his chapel, a mile from Darrynane. About two hundred of his congregation attended, and though I did not understand the subject of the discourse, I was much impressed with the devoted manner of the worshippers, not only in this lonely chapel among the wilds of Darrynane, but in every part of Ireland with which I am acquainted. They who sneer at the religion of Roman Catholics, might 



---

p.348




be induced to forego their contempt, if they witnessed the consolation derived by the wretched half-starved Irish from the despised faith of their fathers. As a Protestant, I am led to dissent from many of the doctrines of the Church of Rome; but, having seen the power of those doctrines over the hearts and conduct of their votaries, I am admonished not to mingle my dissent with uncharitable vituperation. The sermon, I afterwards learned, consisted of quotations from the Holy Fathers, and of exhortations to prepare for death, by leading godly lives. Many employed themselves during the continuance of divine service, in counting their beads, but I did not observe any bibles or prayerbooks.


The minister of this congregation was a man of humble pretensions, but industrious and zealous in his calling. In the morning he rose before it was light, having to attend a chapel over the mountains, and, on his return, officiated at that near Darrynane. I accepted his invitation to join him at breakfast. This was a late meal for him; but the priests make it a rule, from which they seldom


---

p.349




or never depart, to take nothing to eat before the duty for the day is finished. The dwelling of this unostentatious minister of the gospel was a very humble cottage or cabin, such as few labourers in England would consent to live in. "The Liberator," I understood him to say, "allows me this little farm of about twenty acres; I receive nothing from my flock except the labour they are inclined to give me upon my farm, when it suits their convenience." The congregation were remarkably clean and respectable looking, and are a stout and healthy people. They believe their ancestors to have been of Spanish origin, and feel some pride in the antiquity of their descent. From this feeling of family pride Mr. O'Connell himself is not quite free; making use of the circumflex over the "O," as an indication of Spanish origin.


The country about Darrynane would be greatly benefitted by the introduction and application of an improved system of agriculture. The farmers seem ignorant of the advantages of cultivating rape, turnips, and mangel wurzel — of mowing


---

p.350





green food for cattle — or of alternate crops of corn and green food. A large part of the countryis composed of mountain. The wages of the labourers were stated at from 6d. to 7d. per day, with diet. The able-bodied men who are employed in the roads, receive 8d. without diet, but they have employment occasionally in fishing.


The mountains in the neighbourhood contain both lead and copper, but no mines are yet worked. Mr. Hartop, an English gentleman, has a royalty in the neighbourhood, and arrangements, I was informed, have been made with him by three Companies, viz., the Irish Mining Company, and two English companies, to open some mines in that part of the country. Kenmare Bay is accounted a safe harbour, and finely sheltered by ridges of mountains; there ought here to be a considerable trade in the export of minerals and agricultural produce.


Mr. O'Connell's ancestors originally had a lease of this district, from the Earl of Cork, and it still continues to be held under lease. The extent of the estate along the coast is about ten miles, the



---

p.351




breadth three: and the profitable interest of Mr. O'Connell is said to be about £800 per annum. His income from land altogether (with an estate of his own at Tralee) is supposed to be £4,000 per annum. Mr. O'Connell is considered a good landlord; but in answer to those who have occasionally, whether from political feeling or sheer ignorance, insinuated otherwise, it may be observed that the majority of his property being in situations so unfavourable to cultivation, and being burthened with so many tenants, it would be next to impossible, even if they lived rent-free, to make them all comfortable. The previous occupier of Darrynane was an uncle of the present proprietor, and, in consequence of his extreme fondness for hunting, obtained the name of "Hunting Cap." Mr. O'Connell's brothers, James and John, have property in Cahirciveen. James is said to have a clear income of £4,000 per annum, in the county of Kerry, and John, whose fortune is also considerable, keeps a pack of hounds near Killarney. When Mr. O'Connell is at Darrynane, he keeps open house, entertaining large parties of gentlemen



---

p.352



men from the surrounding country. In reference to the vast sum which he annually receives from his countrymen, and which has been so fertile a source of detraction and vituperation in some quarters, I was informed by a gentleman in the habit of visiting at Darrynane, that no person who had not passed some time with the distinguished owner, could have an adequate idea of the expenses entailed upon him in consequence of his peculiar position as a public man. "One morning," my informant added, "when I was with him at his house in Merrion-square, his letters and parcels for that morning only, amounted to upwards of £5."




---

p.353


Departure from Darrynane — Ride to Cahirciveen — Kerry pony — Wild Irishman — The Skellig Rocks — Monkish cells — Sea-birds — Magnificent sea-views — Arrival at Cahirciveen — Buildings and trade of the place — Valencia — Inattention of Irish landlords in the winter season — Employment — Birth-place of Mr. O'Connell — Character of Mr. O'Connell's father — Journey to Tralee — The Dingle Bay — Singular appearance of the sea — The Blasques — Lord Headley's estates — Bianconi's cars — Gorgeous sunset — The Bridge of Castlemain — Arrival at Tralee — The Hotel — Principal proprietors — Price of provisions — Education at Tralee — Dr. M'Henry — Improving state of the town — The export trade — Bead manufacturers — Sir Edward Denny's residence — Old castles — Rocky coast — Barnacles — Wretched instances of destitution — Tarbert — Sail down the Shannon — Innis Scattery — Kilrush — Improvement of the town — The Steam Company — Remarks on the advantages of public spirit and energy.
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


On the Monday morning I left Darrynane, mounted on one of the celebrated Kerry ponies, a sluggish stupid animal, with a shaggy coat resembling that of a bear. I had to pay four shillings (the regular price) for my ride to Cahirciveen, a distance of nineteen miles, the road lying all the way over wild and rugged mountains. The owner of the pony set off early in the morning, for the 



---

p.354



double purpose of carrying my carpet-bag and bringing back the pony (an usual custom I believe.) The day was wet, windy, and disagreeable, but my pony heeded not the weather, accustomed as it was to travel the mountain districts, and neither by words nor blows could I succeed in stimulating the sluggish brute to a brisker pace. I discovered that it exactly corresponded with the description given of these animals by **Dr. Smith** in 1756, who says, "the little hobbies of the country are the properest horses to travel through it; and a man must abandon himself entirely to their guidance, which will answer much better, than if one should strive to manage and guide their footsteps; for these creatures are a kind of automata, or machines, which naturally follow the laws of mechanics." When I had accomplished half the journey, and was upon a desolate mountain, a tall, wild-looking man, with long hair floating in the wind, without shoes and stockings, and nearly without clothes, made his appearance, and came running up; but, as he spoke nothing but Irish, I remained ignorant of his wishes or intentions.


---

p.355




He accompanied me the whole of the way, running opposite the pony's head; and by this means inducing the animal to bestir himself. By the use of signs I at length succeeded in making the uncouth stranger understand where I wished to go, and he became useful in inquiring the way for me.


After the heavy driving rains of the morning, the atmosphere fortunately became remarkably clear, and I had an extensive view from the mountainous road I was traversing. The most interesting objects were the Skellig Rocks. The Great Skellig rises in a very extraordinary and abrupt manner out of the Atlantic, at a distance of about twelve miles from the shore. It resembles an irregular and sharply-pointed cone. A little plain of verdant land, elevated about two hundred feet above the level of the sea, was anciently chosen as the site of buildings devoted to religious solitude and devotion; and the time-worn fragments, and the ruins of many monkish cells, still remain to attest the piety and enthusiasm of by-gone days. Two holy wells, several stone crosses, and the ruins of



---

p.356




the cells, are regarded by the inhabitants of these solitary districts with veneration. The ruins are of very early date, and are roofed with stone, but without cement, and are impervious to rain. Upon these rocks Government has built two lighthouses; that upon the great Skellig is elevated 372 feet above the surface of the sea at high water.[24](javascript:footNote('E830001-002/note024.html')) In the erection of these lighthouses, and in making communications by roads across the rocks, the sum of £300,000 is said to have been expended. The islands are a mile apart. The middle Skellig is frequented by numbers of gannets and other seabirds, that breed among the cliffs; and, in consequence of the fishy food these birds live on, says Mr. Wright, "their flesh is permitted to be eaten during Lent." "The feathers," continues the same authority, "afford a handsome remuneration to the nest spoilers; and with these inducements, the rock is visited by numerous bird-parties in spring and summer."


I had a splendid view of Ballynaskellig's Bay,



---

p.357




Scariff and Dinish Islands, and Bolus Head; the beautiful green sea, with its circling waves, appearing, as I passed along, at a great depth below. For several miles previously to reaching Cahirciveen, the Bay of Valencia, Valencia Island, and the bold headlands of rock which diversify and characterize this coast, against which the waves dashed in foamy mountains, lay before me. The pleasure of this mountainous ride is confined, however, to the magnificent sea-views; for the district over which I passed had but little to recommend it to one's interest. The country is thinly peopled, and badly cultivated; the land wants draining and fencing, and not the least symptom of agricultural improvment is discernible.


At the end of five hours I alighted, extremely fatigued, at Cahirciveen, with more real pleasure than I ever before dismounted from any beast, and delivered him to his master, with a determination never, if possible, to ride another rough Kerry pony. The poor creature who had accompanied me as my running footman, though uncivilized



---

p.358




and wild in his appearance, proved most obliging, and when, on arriving at the inn, I gave him a few pence, he testified as much gratitude as if I had bestowed upon him an estate. His eyes sparkled with delight, and he instantly called for whiskey! The inn at Cahirciveen is kept by a Mr. O'Connell; this name is very common in Kerry; and most of those who possess it, claim relationship with him who has reflected such celebrity upon it. Cahirciveen belongs principally to that celebrated individual — that is, he has a lease for ever from the College in Dublin. The town, whose population is about 1500, is in an improving state; fifteen years ago it contained only four slated houses; now there are few thatched ones, and those only cabins in the suburbs. As infallible signs of increasing prosperity, a new chapel has lately been erected by private subscription; an Infirmary also has been recently established; the annual subscription to this institution and to the Dispensary, amounts to £150. Besides these, there are several schools, endowed by private individuals. The exports, consisting



---

p.359



of slate and flags, the latter being sent from Valencia to London, have much increased. Cahirciveen, once famous for smuggling, is beautifully situated on a gentle slope by the side of a river, which runs through a narrow valley between lofty mountains, only a short distance from an extensive and interesting bay surrounded by romantic rocks and caverns, and the ruins of the Castle of Ballycarberry. At the mouth of this bay are Valencia and other islands.


Valencia, which owes its name to the Spanish, has obtained some celebrity on account of being one of the places proposed by Captain Evans, Mr. Vignoles, and other engineers, as the terminus of a railway across the island from Dublin. Most of the island, which is about five miles long, by one wide, belongs to the Knight of Kerry (joint tenant with Mr. O'Connell in the College property). The island is said to be about five miles long; the sea, which runs between it and the main land, being half a mile broad, and sufficiently deep for vessels to sail through at any time of the tide. Cromwell, as stated by Smith, had forts


---

p.360



erected at each end of the island. In Queen Anne's war, this harbour, from the facility it afforded of ingress and egress, was said to be much frequented by French privateers. The Hotel at Cahirciveen contained few of the conveniences or luxuries usually met with in places of entertainment; and indeed I found it to be a regular practice in this part of Ireland, to leave the windows and doors unrepaired, till a convenient season, when the glazier or joiner might happen to travel that way. There is frequently a scarcity of useful furniture, in the shape of bellows, warming-pan, &c. The deficiency of paint I could excuse, but the want of cleanliness is unpardonable. In consequence of the absence of scrapers and mats, the lobbies and rooms are a mass of dirt, which is left to be trodden out as it is trodden in, when the street is the cleaner of the two. The favourite sports of hunting, shooting, and fishing, in these mountainous districts, divert the attention of the masters of the hotels from paying attention to the ordinary concerns of their houses, and, having so rarely any guest in the winter, it is


---

p.361




considered superfluous care. I hope that in the summer season their energies are exerted in proportion to the total absence of them in winter. Several of the cabins opposite to the hotel had a very picturesque appearance, from being clad in a complete suit of green, both walls and thatch. The latter was covered with a luxuriant crop of navelwort, and the walls were richly decked with beautiful green lichen, whose growth was promoted by the moisture of the climate.


The labourers here are employed, on an average, three days in the week throughout the year, and receive, as wages, from 6d. to 8d. per day, without diet. The rent of an acre of land, with a cabin, is £3, and of one rood of land with a house, £2: the labourer builds the cabin, and keeps it in repair. A few of the gentlemen in the neighbourhood have made trifling attempts at green crops, but the system is not much practised. I took a walk to Carhan, about a mile from Cahirciveen, the birth-place of Mr. O'Connell, which curiosity prompted me to visit. Nothing remains of this residence but the walls, from which it would seem



---

p.362





to have belonged to a country squire of some fifty or sixty years ago. The situation of the house is picturesque; it faces the bay, which here assumes the appearance of a lake, and commands a view of the mountains opposite. Near the house, a mountain stream that falls into the bay, is crossed by a rustic bridge; and behind the bridge is some wood, and the ruins of gardens, that have been ornamented with shady walks and terraces. Mr. O'Connell, I was informed, inherited this estate from his father, of whom the landlady said that "he kept an open house, and had good breeding without pride. There was not a more plentiful house in any part of Ireland: he has had as many as sixty-five at dinner, and if he got a houseful of company he would never part with 'em; his hospitality was *rale* nature, not the *stand off* that people have now a days."


Thankful to travel once more over roads on which a wheel-carriage could move, I took my place by the mail-car to Tralee, passing through the estates of the Marquis of Lansdowne and Lord Headley, and Killorglan and Castlemain. Mr.



---

p.363




Charles O'Connell, son-in-law to Mr. O'Connell, has built a house on the right, about a couple of miles from Cahirciveen. From the road, it seems to be a good house in a bad situation, for, at that distance, nothing is to be seen about it but dark and gloomy mountain and bog land. After leaving Cahirciveen, the cottages on the O'Connell property appear clean and comfortable dwellings, and some plantations have been made in the neighbourhood.


From this road the Dingle Bay is seen to great advantage, its peculiarly fine green waters contrasting beautifully with the brown and sombre hue of the surrounding mountains. The scene is one of more than ordinary interest; beneath the high cliffs over whose edge the way lies — and at a depth of from three to four hundred feet — the waves, rendered diminutive by the distance, fret and break against the feet of the unmoving rocks; and the white sea-fowl, floating through the intermediate abyss, have the singular effect of pearls set in emerald. This may sound somewhat fantastic, but it could scarcely fail to strike




---

p.364



any one who should gaze into the fearful depth. Twenty-five miles off are the Blasques, a series of islands, the largest of which is Innismore. These islands are fertile, and contain several curious chapels; they form the most westerly part of Europe. For a considerable extent across this bay, the Castlemain bar, a vast and dangerous sandbank, stretches. Vessels are frequently lost here; ten days before I passed along the road, the "Liverpool" had been wrecked upon the bar. In 1588, the memorable year of the defeat of the Spanish Armada, one of the vessels, containing 503 men, was lost in this bay.


In this part of the country Lord Headley has large possessions. He has planted extensively, and has greatly contributed to give an aspect of civilization and beauty to a district previously barren and unattractive. Lord Headley is an excellent landlord, and a good man. He is in the habit of giving leases, and of assisting his tenants in making improvements.


I travelled by one of Bianconi's cars, and was delighted with the conveyance; something similar —



---

p.365



something at once so cheap, so safe, and so expeditious — might, I think, be established with advantage in this country. A Bianconi, for instance, would be useful in England, for conveying passengers for short distances to the several railways, but particularly for jaunting parties in the neighbourhood of the lakes. The carriage is a light one, the number of horses depending of course upon the number of passengers and the nature of the road. For this journey, (a distance of fifty-five miles), I paid 6s. 6d., and a shilling to the driver.


I think I never witnessed so gorgeous a sunset as I did this day. Upon the top of the sombre Broghall ridge of mountains, a long bank of perfectly grey clouds rested; above these, and extending almost to the zenith, was a suffusion of the deepest crimson: to these rich and delicate colours, the brown hue which prevailed in the foreground and the distance, formed an imposing contrast. The picturesque ravines, with their rivulets and waterfalls, all partook of the glory of this grave and gorgeous radiance.




---

p.366


At Killorglan we crossed the river Laune, the limpid water of the queen of lakes flowing through Castlemain harbour and Dingle Bay into the sea. The bridge here has ten arches. The town is on a steep hill, and has an appearance of antiquity. The bridge of Castlemain, over the river Main, is the most ancient in the country. It formerly had a castle upon it, and divided the property of the chieftains of two districts, the Mores and Desmonds, and each had guards residing upon it alternately. Its present appearance denotes that buildings have been formerly erected upon it..


From Cahirciveen to Killorglan, the face of the country is bog and mountain; near the latter place the land improves. The rocks are generally slate, but near Killorglan the limestone appears, and is seen again at Milltown, where the land is good; but between Milltown and Tralee, it is wet and boggy, and the people are poor. Limestone appears again as we approach Tralee. The inhabitants of this wild district are exceedingly peaceable and orderly, with the exception of occasional cases of sheep-stealing. Some degree of this 


---

p.367




peaceableness may perhaps be attributed to the police-stations, fixed at intervals of a few miles, but principally to the laudable means used for employing the people..


At Tralee I took up my quarters at the Hotel, accounted a good inn. The landlord was gentlemanly, both in appearance and manners, but I found here the same negligence which had disgusted me in other places..


The club-houses were said by a gentleman to whom I had a letter of introduction, to have knocked up the inns, but their lamentable and most disreputable condition may be more properly attributed, I suspect, to the inattention of the innkeepers, who are much fonder of hunting and shooting than of looking after the duties of their calling. If my accounts of some of the Irish inns be found to differ materially from those of writers who have preceded me, the disparity may be accounted for on this ground; most tourists visit Ireland in the summer portions of the year, and find the houses of public accommodation in some measure prepared for their reception; whereas it



---

p.368




was my lot to travel through a considerable part of the country at a time of the year when the absence of company enables the national peculiarities to be more openly exhibited..


The principal proprietors are absentees. Lord Fitzwilliam's income is understood to be £80,000 a year, of which, I was informed, he takes only £34,000 out of the country. Lord Headley resides: Lord Kenmare, a Roman Catholic, has the largest property in Kerry; at present his rental is only £36,000 per annum, but when the leases expire it will amount probably to £100,000. Lord Listowel has an income of £20,000; Lord Ventry,an equal amount: Lord Lansdowne £8000; Mr. Locke £7,000; and Lord Cork £6,000. Kerry (formerly the Kingdom of Kerry) is said to be the greatest absentee county in Ireland, which may in some degree account for there being no **Agricultural Society** in it. Many of the labourers were in a state of great destitution; being employed about two-thirds of their time, at wages averaging eightpence a day, without diet. Provisions here were, however, cheap. Potatoes, which




---

p.369



had been much injured by the wet, sold at 3d. per stone; coals were generally 18s. per ton throughout the year; beef from 2 1/2d. to 4d. per lb.; mutton 4d.; pork 3 1/2d.; fowls 1s., turkeys 4s. 6d. per couple; eggs, three for 2d.; butter 10d. per lb.; milk 1d. per pint; salmon 4d., cod 1d., turbot 5d., and herrings and eels 2d. per lb. Hay, in ordinary years, sells for from £2 to £2. 10s. per ton. In 1836, however, it was £3. 15s. The coral sea-sand, of which I have spoken in a previous chapter, is free to any who choose to gather it, and is considered a valuable manure. Lime at the kiln costs 1s. 6d. per barrel of 2 cwt.; manure in the town, 1s. for 13 cwt. Land, used for farming purposes, four miles from Tralee, lets for from forty to fifty shillings per acre; for prime land near the town, as much as £4 will be given. The population of Tralee is 10,000.


About 2,000 children are educated by the Roman Catholics at Tralee, and they and the Protestant children go to school together — a fact that indicates a friendly and charitable understanding to prevail between the members of the different


---

p.370




churches. Dr. M'Henry, a Catholic priest, built, at his own expense, the school in which the children meet; he built also an alms-house for poor widows. This excellent minister is, as may be supposed, greatly respected by all parties. A few of the National Schools are established in the neighbourhood, and four or five others were in contemplation. Tralee, though an improving place, abounds with pauperism, and is destitute of that which almost every town in Ireland should possess, in the absence of some legislative provision for the poor — a Mendicity Institution. Drunkenness has greatly abated, owing in some measure to the operation of a Temperance Society; and since the establishment of Petty Sessions, litigation, at one time so frequent in this community, has diminished to the extent of at least twothirds of what it was previously. The improvement in the conduct of the people corresponds with this diminution. Indeed, the condition of the people generally, notwithstanding the many distressing cases of destitution met with in the streets, is greatly amended within the last few years, more



---

p.371




especially within the last five. The population during the last ten years has increased 30 per cent. These are cheering signs — cheering *proofs,* perhaps I ought to say. Tralee contains a circulating library on a small scale; the want of a public library is in part supplied by a number of clubs (supported by private subscription) to which libraries are attached. Two newspapers are published in Tralee, one of each party; the liberals, however, are said to compose the majority of the educated and reading classes. Here, as in other places, the idea of manufacturers or machinery being exposed to any danger from the violence of the people, was ridiculed as absurd — "That day," said some of the inhabitants, "is gone by." It appeared certain, on the contrary, that any attempt to establish factories of any sort — or any other means likely to afford employment to the population — would be hailed with thankfulness, and receive a general and cordial support.


The principal export trade of Tralee is in grain, cattle, and pork; they are sent to Cork by land. The harbour is exceedingly bad and dangerous, 



---

p.372



and, at the time of my visit, a ship-canal was in process of cutting from the bay. By some men of intelligence and experience, a railway was considered preferable.


There are two bead-manufacturers here: one of them, James Boan, I visited. This man, some of whose goods I purchased, expressed great desire to know the destination of his articles, and was anxious that I should recommend him when I had an opportunity, so that he might be enabled to realize his hope of changing his present dirty little cabin for a more respectable and a larger shop.


Sir Edward Denny, to whom Tralee mainly belongs, has a residence near the town, and through the domain which environs it he has recently formed a beautiful walk, to which the appropriate name of the Castle Walk (an old castle having stood here) has been assigned. This walk is open, I presume, to the public. At any rate, the gate being open, I took the liberty of walking in and inspecting the place. The day (the 21st of December) was warm and genial — 



---

p.373




the birds were singing as if it were a spring morning — and I was induced to believe that Irish winters were mildness itself.


The castle alluded to in the foregoing paragraph was taken down a short time ago, and out of its materials Denny-street was built. The street certainly does credit to those who projected and designed it; and, considered with a view solely to utility, is infinitely to be preferred to the ancient ruin it has supplanted. At the same time I cannot contemplate, without regret, the destruction of those venerable and generally picturesque structures. The times which rendered them necessary, are doubtless gone for ever; and surely they might be permitted to remain, not merely to delight us by their beauty, but to instruct us, by teaching a lesson of gratitude for the security and peace we possess, and of admiration of those great principles by whose agency alone peace and security have been obtained, or can be secured.


This coast up to Kerry Head, and the Shannon mouth, is rocky, and full of indentures and



---

p.374




caverns, which are frequented by numberless seabirds. In winter, barnacles appear in such numbers as to darken the air; they are principally caught in Tralee Bay, are about the size of a small goose, and in other respects similar to the wild duck. Although birds, they are, as food, (according to the statement of a gentleman at Tralee) accounted fish by the Roman Catholics. Eagles abound all along the Kerry coast, and may frequently be seen soaring amongst the mountains.


Whilst the car (a miserable concern) by which I was to travel to Tarbert, was waiting at the door of the hotel, some of the most wretched objects imaginable surrounded us. One poor creature in particular attracted and merited attention. With scarcely the aspect of a human being, this wretched man was mounted on the shoulders of another; — his body was nearly quite naked, his limbs were shockingly distorted, and he continued to utter the most unhuman sounds. I shudder, even yet, when I remember this deplorable sight. About a dozen others, exhibiting 


---

p.375



various degrees of suffering — lame, old, and wretched, stretched out their withered hands for charity.


During this journey (a distance of only thirty miles, which we were no less than seven hours in performing), the horses must have stopped, resolutely refusing to draw, at least twenty times. At Listowel, where a fair had been held, we were accompanied out of the town by fifty or sixty men and boys, who succeeded, by shouting and flogging, in stimulating the pace of our sluggish and miserable horses. A more uncomfortable ride I never had, and would willingly have stayed at Listowel, had there been accommodation. In the absence of this, I was obliged, though far from well, to proceed to Tarbert, where I arrived at ten o'clock that night. Tarbert, as I have stated before, lies on the south bank of the Shannon, and on the borders of the counties of Limerick and Kerry. Another and more respectable car, I ought to add, travelled the same road; but by some mistake I was directed to the one I went by.


On a former occasion I had sailed down the


---

p.376




Shannon, from Shannon Harbour, in King's county, to Tarbert; the progress of this great river, twelve miles further down, is equally interesting, and presented, among other things worthy of note, a view of Carrig-o-Guncel and Carrig-foile Castles. The latter, seated on an island, was the stronghold of O'Connor of Kerry, and was taken by the troops of Queen Elizabeth in 1580. From this part of the Shannon, the river expands into a large bay, affording a view in a direct line to the Atlantic. The lighthouses of Kilkredane and Rehy Head, elevated upon lofty cliffs, are seen on the Clare side of the river. Here part of the French fleet anchored. At Money Point, on the Clare side of the river, some excellent flag-quarries are extensively worked by the Dublin Steam Company, which owes its prosperity in a great measure to the spirited exertions of Mr. Williams of Liverpool. Flags are sent from hence to London and other places. Proceeding on our way, we sailed close by the island of Innis Scattery, which contains the ruins of seven churches, and a conspicuous Round Tower, useful as a land-mark. From the



---

p.377



hotel of Kilrush, there is an excellent view of the tower, the diameter of which is the same throughout, and the height 120 feet. It retains its conical top, and has a rent, supposed to be caused by lightning, extending the whole length. The island of Innis Scattery contains 98 acres; a hundred years ago it contained 100 acres, but two have been washed away during the interval. The rental is £100 per annum. This island was granted by Queen Elizabeth, to the Mayor and Corporation of Limerick, and their successors.


Kilrush belongs to Crofton Moore Vandeleur, Esq., of Kilrush House, who is lord of the manor. His property extends about twelve miles along the Shannon side, east of Kilrush, and, westward on the road to Kilkee, about five miles; and his income is said to be about £15,500 per annum. He is a young man, and is an excellent landlord, giving encouragement by granting longer leases, and ground for building on, and is ready to join any Company that may be established for the benefit of the country. Within the last five years, the town and neighbourhood have undergone an



---

p.378



astonishing improvement, mainly attributable to the establishment of the steam navigation. The trade of the place is rapidly increasing; several stores are building; branches of the National and Agricultural Banks have been established; a patent *slip* has been constructed; and the Steam Company are about to extend the pier 200 feet. These are unequivocal signs of increased prosperity. Nor are advantages resulting from these changes confined to the town. The agricultural interest is benefited to a very considerable extent, by the opening of the trade of Kilrush: the farmers, for instance, who formerly were obliged to take 2d. or 3d. a stone less than the Limerick prices, now sell their grain within a farthing of those prices. As in most cases when extensive alterations for the public advantage are contemplated, the Company had at first to contend with formidable opposition; but they succeeded in buying up the other boats on the river, and prudently employed their captains in the steam-boats. This politic line of conduct at length prevailed, and they now ply twelve steam-vessels on the river, besides a number



---

p.379



of lumber-boats. Acting in the same public-spirited manner, they sent down two cars to Kilrush, to run between that place and Kilkee as public conveyances.


It was highly gratifying to witness the animation that prevailed in Kilrush, — the neatness of the little shops, the flagged pathway, and the absence of accumulated dirt, so prominent and offensive a peculiarity of most small towns in Ireland. The people about Kilrush (whose population is 5000) are handsome, and appear considerably more intelligent than in many other places. The whole town, indeed, presented abundant proofs of the advantages that result from a spirited and enlightened policy, which, whilst it largely benefits the community, extending its influence wider and wider, like the increasing circles of agitated water, is the occasion of corresponding profit to the enterprising individuals who may have advocated its adoption. Truly despicable, on the other hand, is the low and narrow policy, entertained too often both by individuals and companies, which would postpone 


---

p.380




the interests of the many to the good of the few, frustrating designs of incalculable importance, for the purpose of preserving some private, and, most probably, injurious monopoly. That which conduces to the general prosperity of trade, and promotes the permanent benefit of the great majority of the inhabitants of a town or district, must, in the end at least, if not directly, contribute proportionately to the interest of individuals: yet, as if this doctrine were a false one, or as if, though true, it was regarded with contempt, we constantly see the proprietors of Sailing Vessels oppose themselves to Steam; Turnpike-Road Trustees and Canal Companies to Railways; and the proprietors of Coaches to Omnibuses, and all other means of public convenience that may seem to militate against their "own peculiar."




---

p.381


Kilkee — Bog wood — Used instead of candles — Geology of the neighbourhood — Loss of "The Intrinsic" — Account of the shipwreck — Mr. Deane, the inventor of the new diving apparatus — Description of it — The Carrigheen moss — Clearness and beauty of the sea — Attractions of Kilkee and the neighbourhood — Ancient Rath — Belief in Fairies — Education thirty years since — Curraghs, or canoes — Farms and rents — Prices of produce — Wages of labourers — Early marriages — Advice to travellers — Miltown Malbay — The Hotel — The Spanish Armada — Principal proprietors in the neighbourhood of Miltown Malbay — Population and rents — Bright and beautiful morning — Birchfield, Mr. O'Brien's — The Cliffs of Moher — Extensive view — Inn at Lahinch — Interview with Thomas Steele at Ennis — The Jail — The Abbey — Return to Dublin — Sir William Betham — His researches on the subject of the ancient ring-money — Body of a man found in a bog — Conclusion.
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------


Kilkee, a well-frequented bathing-place, is nine miles distant from Kilrush; the charge made by the Public Company for going there is only 1s.; whilst those having private cars charge five. The Company, besides what it has done in the *direct* sphere of its operations, has also assisted in making and improving the roads in the neighbourhood.


In going to Kilkee, some bogs are crossed,



---

p.382




which contain an extraordinary quantity of wood — the stumps of large trees remaining above ground, as numerous and as close together, and most of them in the same position as in the days when they were portions of an extensive forest. They nearly all belong to the pine species, and the wood is so thoroughly impregnated with turpentine, that the shreds burn most brilliantly, and are substituted for candles. They are occasionally twisted into ropes. This wood makes an excessively hot fire, and kindles in a much shorter time than any other combustible in use; the roots are chiefly applied to this purpose — the stem, which is too valuable, being used for building. When the wood is of length sufficient for this purpose, it is uniformly found lying horizontally. Ray, in his Synopsis, states that the Scotch fir, or "pitch fir," was formerly a native of the mountainous parts of Kerry, and that most of the bog-timber found in Ireland was of this description. Turf, to the value of £10,000 annually, is said to be sent to Limerick from the neighbouring bogs.




---

p.383


Immediately on my arrival at Kilkee, I commenced a ramble along the shore, and amongst the cliffs of this romantic spot. The village lies round a little bay of the sea, inclosed by high and rugged rocks, which form a grand amphitheatre. In a storm, the sea exerts such extraordinary power on this coast, that immense pieces of rock, of many tons weight, that lie fifty or sixty feet above the usual tides, are forced from their beds by the action of the waters, and cast violently into the bay. On the south side of the bay, the rock is in regular layers, with a slight inclination. "The strata," says Mr. Ainsworth, "consists of alternating beds of clay slate and ampelite, and of extremely compact quartzose rock, without cement, and scarcely any fissures of stratification." Crystals of quartz are found among the interstices of the rocks, called the Diamond Rocks; similar formations are produced along the coast of Kerry, and in the limestone of Carlow, as before stated.


Between Bishop's Island, a short distance from the shore, and the Diamond Rock, — in a very



---

p.384




small gulf surrounded with rugged perpendicular rocks, 150 feet in height, — "the Intrinsic," of Liverpool, was lost. The particulars of this lamentable occurrence, which took place in the January of 1836, have been feelingly detailed by Mary John Knott, in her interesting narrative of Two Months at Kilkee. My readers will not quarrel with me for extracting a few passages. The coast-guard, attended by their officer and a number of the inhabitants of Kilkee, having flocked to render any assistance which might be in their power, "they saw the supposed captain with his speaking trumpet, calling to them in vain, but nothing could be heard from the roaring of the breakers, which, after dashing with tremendous violence upwards of 100 feet high against the perpendicular cliffs, rushed back to sea, carrying the unhappy vessel with them, until it was stopped by the anchors. During this indescribably awful period, a lady came up from the cabin, and looking round at the towering cliffs and dreadful breakers, sunk on her knees in the attitude of prayer, but was soon obliged to


---

p.385




go below by the waves, which washed two of the crew overboard, but who, after astonishing exertion in the water, regained their sinking vessel, which, carrying a cargo of 500 tons, was at one moment lifted so high, that the people on the cliffs over the Diamond Rocks, thought she would be thrown up amongst them: the next minute she was engulphed in a valley of foam. As all human efforts were now unavailing, whilst the tempest blew with such violence that the agonized beholders could scarcely keep their feet, the kind hearted natives, seeing the awful termination at hand, did all that remained in their power, by kneeling down and praying for their poor fellow creatures about to be swallowed up in the mighty deep. The crew soon after went down to the cabin, no doubt to prepare for the awful change that awaited them — after which they were seen no more. The vessel at length disappeared in a huge wave, and, after a short time, her shattered frame rose once more, when the next enormous breaker (to use the words of a spectator) shattered it into a thousand



---

p.386



pieces, and rolling it over and over, carried most part of it, and the light part of the cargo, out to sea. A few minutes after the Intrinsic went down, a gull, hovering over the spot, was seen to descend and pick up something out of the water. The bird then rose to a great height, and let go what the wind wafted ashore, and which proved to be *a lady's glove.* None of the bodies of the poor sufferers were seen except one, which was observed floating near the Bath House, on the north side of the bay. Two men incautiously rushed out to bring it in, when, awful to relate, they were both carried off by the breakers and drowned. The Intrinsic was bound from Liverpool to New Orleans, with materials for railways. They were out fourteen days from Liverpool, and having sailed round the north of Ireland, were driven by a succession of storms upon the coast."


**Mr. Deane**, the inventor of the new diving apparatus, was engaged by the Underwriters to recover part of the cargo, and had succeeded as well as the stormy weather would permit. His task was a difficult one, and if he received only 


---

p.387




half the value of what he rescued (such, I was informed, being the agreement) he would be inadequately remunerated for the risk and exertion he had undergone. Being overtaken in a snow storm, I took shelter under the side of his small vessel, which had been cast on shore, and was undergoing repair. A pretty correct idea of its diminutive size may be formed from the fact that he and twenty men were engaged in preparing to haul it down the nearly level sand into the water. **Mr. Deane** favoured me with a sight of his apparatus, consisting of a helmet that rests upon the shoulders, with lenses in front, and an opening at the back, in which is inserted a pipe that conveys the air over the head to the face. An airpump, worked by four men, is fixed in the deck of the vessel, and supplies the air to the diver by means of a pipe. He descends by a rope or ladder (according to the situation he may be in), to the bottom of which weights are attached, and is clothed in flannel, in addition to his usual dress. He also puts on an India-rubber dress, with leaden soles to the feet; thus he is entirely invested with



---

p.388




a covering impervious to the water. Signals are made by means of cords, and are well understood between the diver and his men. A confidential person on deck, frequently repeats signals, and, if the diver should omit to answer any of them, he is immediately drawn up. From the great clearness of the water on this coast, he can see to a distance of fifty feet distinctly, a much greater distance than he has observed elsewhere. **Mr. Deane** stated that he had never, in the course of his perilous vocation, been molested by any large fish, but that in one place on the coast of England the great conger-eels swam by him perfectly harmless. He always, however, adopts the precaution of taking down with him a large knife, for the purpose of defence in case of attack.


A great variety of curious sea-weed, and other marine plants, are found about the rocks of Kilkee; the most important of these is the **Carrigheen moss**, which grows in great abundance, and is collected by the natives and bleached on the coast. It is used as an article of diet for invalids, both in Ireland and England, and is said



---

p.389




to be as nutritious as isinglass. In the cavities of these rocks also, and within the reach of the tide, a beautiful small pink-coloured coral grows. The sea here is as clear as it is possible for water to be, and of the same exquisite emerald hue which I noticed at Darrynane, and some other places along the coast. This most delicate and beautiful tint is seen to the greatest advantage just at the moment the wave is curling over and breaking into foam, the bright and lively colour being contrasted sweetly with the pure white of the dashing spray. It has been said by a thoughtful and elegant writer, that a breaking wave is one of the loveliest things in nature: and they who have stood upon the cliffs of Kilkee, watching the curling of its emerald waters, will readily admit the truth of the assertion.


A party of friends might pass a few of the summer months very delightfully at Kilkee. It is an interesting place, and is surrounded by as interesting a neighbourhood. The coast of Clare, on each side of it, from Cape Lean as far as Galway Bay, abounds with curious caverns, stupendous



---

p.390



rocks, ranges of picturesque and romantic cliffs, and natural bridges and waterfalls; so that whether visitors take long excursions in carriages, or short ones on foot, they are sure to meet with abundant sources of gratification. In the interesting little work before mentioned,[25](javascript:footNote('E830001-002/note025.html')) are drawings of two most extraordinary bridges, which have so much the appearance of art, that did I not know the accuracy of the draftsman, and the great desire of the author to adhere most strictly to truth, I should have been induced to suspect the fidelity of both the representation and the description.


Nor is the interest with which Kilkee and the vicinity abound, of such a character as to afford delight to the lovers of the picturesque and curious exclusively. The antiquary will find numerous objects worthy of his notice. On each side of the village is an ancient Rath; that on the east, which indicates great antiquity, will best repay attention. The circumference, outside the rampart,



---

p.391



is 250 yards — the top of the mound 126; the height of the top of the Rath, above the fosse, which has been filled considerably, is twenty feet; the height of the centre rampart is ten feet, and twelve above the fosse. At the south side of the top of the mound is a passage, covered with large flags, and leading into the interior; this passage is nearly filled with earth. An inhabitant of Kilkee, who some years ago explored the interior, informed me that he found a chamber of twelve feet diameter, walled at the sides, and covered with broad thick flags. On the opposite side of the chamber there appeared to have been another entrance, but the rubbish having blocked up the passage, he could not proceed far beyond the commencement of the opening. Within his memory, the people, he said, believed this and other Raths to be the abodes of fairies. "About thirty years ago," he added, "a gentleman could not induce his men to open a Rath, unless he would first take off the sod himself, and then he was obliged to ply some courageous fellows with whiskey, in order to raise their spirits for the accomplishment 



---

p.392





of his object. Few," continued my informant, "got any education thirty years since. The schoolmaster was no scholar, all the education he had being a little bad English. He could, to be sure, add, multiply, and divide, and do part of the Rule of Three, but he could not get through it; and this was the only schoolmaster within eight or ten miles! He was generally the clergyman's clerk." Until about two years ago, classical learning was not taught at Kilkee. A school, recently built by subscription, is zealously supported by the Rev. Mr. Dickson, the Protestant clergyman of the place.


Kilkee is the property of Lord Cunningham, an absentee: his income in Clare is said to be about £7000 a year; the property is still in lease for lives. Very many of the people here live to the age of eighty and ninety.


The curraghs, or canoes, of the fishermen on this coast, are of the same description as those used by the ancient Britons and Irish, except that they are covered (probably for the sake of economy) with tarred canvass instead of hides;



---

p.393




such being the alterations that have taken place in the relative value of these two articles. The curraghs consist of wands of willow or hazel, and are so light that a man can easily carry his canoe on his back. I saw several of them laid up for the winter at the cabins of the owners. The cost price, when ready for sea, is from twenty to thirty shillings. They are sharp in front, and, behind, square but narrow; they have neither keel nor rudder, being guided very dexterously with paddles. When damaged, they are easily repaired with a piece of canvass, stuck on with pitch. The fishery of Kilkee is unfortunately declining, the fish having nearly deserted the shores; and the poverty of the fishermen deters them from trying new banks, for fear of losing their tackle.


The people of Kilkee and the neighbourhood are peaceable and well conducted. "A man would not kill another," said an old inhabitant of the place, "for a million of money;"nor does it appear that any destruction of life arises out of the taking of land. The establishment of manufactories



---

p.394




would be hailed here with delight; and a copious stream of water to the north of the village, might be rendered available in working extensive machinery. The farms in this neighbourhood are from six to twenty acres in size; the rent being from twenty to thirty shillings per acre. For the bog, when part of the turf has been got off, and about ten feet in depth remains, the rent is from fifteen to twenty shillings per acre. For conacre, from fourteen to eighteen shillings per rood is paid; but this is for stubble land, not very good, and the farmer manures it. The rent paid by the farmer for the same land, is £1 per acre. Many of the farmers are now sowing clover, and I was told that in two or three years there will be scarcely a farmer who will not sow a little. No turnips, rape, or other green food, is cultivated.


The average prices of produce and living were as follows: — oats 9d. per stone; wheat 1s. 4d.; barley 9d.; potatoes, 2 1/2d.; butter 10d. for 18 oz.; beef, 4d. for the best; mutton and pork the same; a goose, weighing five or six pounds, from 1s. 6d.



---

p.395





to 2s.; turkeys the same. A turbot from 2s. 6d. to 3s.; ling and cod fish, averaging 8 lbs. each, 10s. 6d. a dozen; herrings from 2s. 6d. to 4s. a hundred. There are also shrimps, lobsters, crawfish and mackerel, but no oysters. Whales come near the bay, and sometimes frighten the fishermen in their light curraghs.


During the time of potato digging, the labourers receive 6d. per day and diet, after which there is very little to be done till spring, when they may be employed till July. Early in spring they get 6d.; about May, 8d.; and then 6d. per day again. On an average, they are employed about two-thirds of their time. Some of their wives and children go to beg where they are not known, but generally the people are so industriously disposed, and pay such attention to their little potato-gardens, that not many resort to this degrading practice. In the western part of the county of Clare, I observed that many of the potatoes were in the ground on the 23d of December; and, if dug at all, would have to be got up in the present year. Some of the oats and barley had been returned from



---

p.396



Limerick on account of their badness, arising from the wetness and lateness of the season, and a great quantity of the oats were so bad that not more than one bag of meal could be got from ten of the grain. The people were apprehensive of such a scarcity of provisions as they experienced in the year of 1822.


Kilkee presents no variation from the rest of places, in respect of early marriages. Girls marry at sixteen, boys from seventeen to twenty. The poorer classes marry under a conviction that their condition cannot be worse, and may possibly be more comfortable. The farmers' daughters necessarily associate with the servants; and the father, afraid of their marrying below their class, is more easily induced than he might be under other circumstances, to allow them to marry, when a tolerable offer is made, although very young.


I would advise all who intend travelling in this part of Ireland in the winter, to go well provided with tea, coffee, and any liquor they may consider necessary. The eggs obtained here are not always the best; tea and coffee are both very poor; good 


---

p.397




ham or bacon is difficult to find, though in a country overrun with pigs; the fowls are more skin and bone than flesh; mutton may by chance be got pretty good; but the beef is scarcely fit to eat. I lodged at the house of a Mrs. Shannon, who treated me with the utmost kindness and civility; and had I taken up my abode there at a time when visitors generally come, I doubt not many of the deficiencies I complain of, would have been supplied.


From Kilkee to Miltown Malbay, a distance of only sixteen miles, I travelled in a very jolting car (for which I paid 8s.) drawn by a horse which was either unable or unwilling to travel at an ordinary rate. Three men in succession undertook to drive him, and so far succeeded as to make him perform the journey in five hours — being at the astonishing rate of three miles an hour. At length we reached the immense inn at Miltown Malbay, which did not contain a traveller besides myself. It presented a comfortless appearance, and in many respects resembled the generality of Irish inns in the winter season: it



---

p.398




was, however, comparatively free from the prevailing characteristic of dirt. The rooms were without fires, and the only newspaper they could bring me to read was one of the month of August, the time, I suppose, when visitors began to be scarce. This spacious hotel is a partnership concern, having been built about thirty years ago by four gentlemen, and, including ninety beds, cold and warm baths, and stabling for eighty horses, cost about £7,000. It is built upon a rock, immediately beneath which are the waters of a delightfully sheltered bay, resembling a lake, and occasionally, when the wind blows strong, the spray from the waves dashes against the windows of the house. The water being strong and pure, is well adapted to the purposes of sea-bathing; the sands, moreover, are firm and smooth. The present occupier of the inn pays a rent of £150 per annum; he has five acres of land, and two of bog. Nearly the whole of Miltown Malbay belongs to Mr. Marawley.


Miltown has received the additional name of Malbay, by way of distinction, from the badness



---

p.399




and danger of the bay and coast. In the year 1588, several of the ships of the Spanish Armada were wrecked on the rocks at Spanish Point, at the mouth of this bay; and a large, antique, curiously carved chest, said to have contained the dresses of the bishop or chief ecclesiastic of the expedition, was washed on shore. The chest is now deposited in the ware-room of Henry Owens, an eminent cabinet-maker in Limerick. In the year 1822, when the workmen of the late John Killaley were excavating the earth, preparatory to building the bridge of Miltown, very near to Spanish Point, they discovered a number of skeletons, which, from the place of interment and other circumstances, were supposed to be those of the Spaniards who had been washed ashore when the Armada vessels were wrecked.[26](javascript:footNote('E830001-002/note026.html'))


The principal proprietors in the neighbourhood, are Mr. Marawley, before mentioned, whose income was stated to be about £2,000 per annum, Mr. O'Brien, £1,000 per annum, and Sir William



---

p.400



Fitzgerald, from five to £6,000. This gentleman resides in France, and has also a seat near Newmarket; he comes over to Ireland occasionally, and is reported to be a good landlord.


The population of Miltown is rapidly increasing. The wages of the labourers are generally 6d., and sometimes 8d. and 10d. per day, with diet. They are occasionally much distressed, being employed only half of their time; their wives are accordingly compelled to turn out and beg, but notwithstanding this, the most complete tranquillity prevails. Land near Miltown lets at from £2 to £3. 10s. per acre; bog land, from £2. to £2. 10s. Sea-weed and sea-sand are much used for manure, and the latter is held in such high estimation as to be carted from the shore at Miltown to near Ennis, a distance of eighteen miles. But little encouragement, I am sorry to say, appears to be given to agricultural improvements.


The morning after my arrival here was exceedingly brilliant, and I anticipated with pleasure a visit to the cliffs of Moher, allowed to be the most



---

p.401



stupendous on the wildest coast of Europe. Accustomed as I had latterly been to wet weather, the bright and cheerful view that presented itself when I first looked from my window, was more delightful than I can express. The waves rolled gently over the fine sandy beach; and the sea-gulls, basking on the sand, or, with out-stretched wings skimming the quiet water, were enjoying, unmolested, the influence of a warmth and radiance to which they had long been strangers. The road over which we passed was rendered slippery with frozen snow, and it was with difficulty we got along. A new road from Lahinch to Liscanor was interrupted by a gulph, that had, in consequence of some dispute with the contractor, been cut across it, and we had accordingly to scramble down a deep descent, covered with large stones, rounded by their being rolled by the action of the sea, which is here very powerful. On crossing the beach and the Innistimon River, it was with great exertion we narrowly escaped being swamped in a quick-sand. Between this place and the celebrated cliffs, we passed Birchfield, the residence of



---

p.402



O'Brien, whose hospitality to strangers is distinguished; but I had not time to obtrude myself upon his kindness. He is a good landlord; indeed, the great number of white-washed and comfortable-looking cottages that are scattered over his estate, sufficiently indicate the care and attention of the owner, and have been the frequent objects of warm and just admiration. To each cottage is allotted a small portion of land, on which turnips and other green crops are grown. Mr. O'Brien, according to the expression of my informant, "gives the poor a power of employment." For the purpose of benefiting the poor, as well as for the accommodation of visitors, he built a tower or castle on the cliffs of Moher, to which stables are attached, and all the necessary requisites for the process of cooking supplied. He encourages his tenants in the cultivation of the land, allowing them a car to bring lime from Doolan; and in scarce times he supplies the poor with wool and potatoes, and judiciously takes the price out in work. Mr. O'Brien's steward said that as a good deal of work was generally going


---

p.403




on, an active man need not be out of employment except on wet days. Two gentlemen of the name of Macnamara occupy a portion of their time in teaching the people to grow turnips and mangel wurzel, and pay them for erecting their own cabins, on condition that they shall whitewash them every year, and keep them clean inside. They also give employment to the women and children.


The low land lets for from thirty to forty shillings; the mountainous part, from thirteen to twenty. The cess is 1s. 5d. per acre. In this barony (Corcomroe) the proportion of Catholics to Protestants is said to be one hundred to one.


From Liscanor the road winds up the hill to the Hag's Head, a rock, so called from the striking resemblance of a part of it to the head of an old woman. Here stands an old tower, formerly used as a Telegraph, and afterwards as a Coastguard station. This cliff was stated by the late Alexander Nimmo, in his report to Government, to be more than 600 feet above the ocean. The celebrated cliffs of Moher extend for three miles to the northward of the Hag's Head — the most



---

p.404




remarkable of which is computed to be 900 feet perpendicular. The fearful and sublime effect produced by gazing from the edge of these perpendicular and rugged rocks (the highest in Europe, or perhaps in the world), baffles description. The waves of the sea that rolled below, actually appeared like the diminutive curl upon a pond, when slightly agitated by the wind; and something on the shore, that looked from this dizzy height like rods that a man might grasp and wield in his hand, I was told were large balks of timber. A little southward of the Hag's Head, is a narrow rocky chasm, 500 feet deep, which runs up into the land; within this chasm flows a dark stream. To lie down on these airy heights, and project the head beyond the edge of the precipice, is an act, simple though it may seem, that requires no little resolution. The watery depth below is an awful gulph to gaze into.


Fortunately, my visit to these extraordinary cliffs was attended with a transparent atmosphere, and a great extent of rocky coast was visible — its bold headlands jutting into the sea as far as the



---

p.405



eye could reach. To the south, Ballard's Point boldly projected into the Atlantic. Looking in a northerly direction, the Isles of Arran, with their white limestone cliffs, are seen rising out of the ocean. Across the spacious Galway Bay, the wild and rugged mountains of Cunnemara reared their snowy heads, and reminded me forcibly of the picturesque hills of Cumberland and Westmoreland, as seen from the terrace-walk of the Castle at Lancaster.


Leaving with reluctance the stupendous heights of Moher, which I had been most anxious to see, I returned to Lahinch. The inn is situated at the head of Ballyela Bay, and is much frequented in the summer months by bathers, the sands being remarkably fine. The majority of the company, I was informed, consists of Catholic priests. I was shewn into an immense room, a fire of wet turf being carried along with me; and the keen frosty air having produced as keen an appetite, I called for dinner, and was told that a fowl would presently be served up. The promise was literally fulfilled most certainly, for, by and by, *a goose,*


---

p.406




as white as when it was uncooked, was brought to table. The "fowl" was baked.


Leaving Lahinch by the mail-car at seven in the morning, we passed for many miles through a poor, cold, and barren country, destitute of all objects of interest, except now and then the ruins of an ancient castle. Limestone, composed of masses of oyster shells, prevails, as Ennis, the county town of Clare, is approached; and in the immediate neighbourhood of that town the soil improves considerably. At the inn here I happened to breakfast at the same table with Thomas Steele, one of Mr. O'Connell's friends, and an able writer on the liberal side. "Nothing," said he, in reference to tithe, "nothing will now satisfy the Irish people but its total extinction, stem, root, and branch." Poor-Laws he considered indispensable.


Mr. Steele introduced me to the News-room, where I became acquainted with a gentleman, a magistrate, who, in the true spirit of Irish civility, kindly accompanied me to inspect the Jail, the Mendicity Institution, the Old Abbey, and some 



---

p.407



other objects of interest in the town. Mr. Baggot, I found, was an advocate of the silent system, which was about to be adopted in this prison. The arrangements in this jail, with one exception, were very good. That one exception refers to the non-classification of the boys — a point of the greatest importance. This defect will be remedied, I doubt not, when more room is obtained, for the adult prisoners are already classed, according to the character and quality of the crimes of which they are either suspected or convicted. The Mendicity Institution was also well managed; four hundred persons are fed by it.


The abbey was founded by O'Brien, Prince of Thomond, in 1250, and was considered the most elegant Gothic monastery in Ireland. The masonry of the east window remains; and it is rather extraordinary, considering the great beauty of the ruin, and the inconvenient smallness of the church at present used for Protestant worship, that the ancient edifice is not restored.


Ennis is a much cleaner and neater town than I held lately been accustomed to see, and has a 


---

p.408




population of about 12,000. On the river Fergus, close to the town, are several fine corn-mills.


To Limerick, twenty-two miles, I travelled by the coach, and thence to Dublin, 125 miles, by the mail. This route lay through Nenagh, Roscrea, (whose abbey and round-tower I saw by moonlight) Montrath, Maryborough, Naas, and the Curragh of Kildare. In 1798, Naas was defended against the rebels by the Armagh Militia, under the command of Lord Gosford, and a number of troops called the Ancient Britons..


When at Dublin, I was introduced to **Sir William Betham**, Ulster King-at-Arms, &c, who has for several years devoted much attention to antiquarian researches, respecting the affinity of the Phoenician and Celtic languages, ancient ornaments, and the ring-money. Sir William had, some time before I saw him, astonished the members of the Royal Academy by declaring his conviction that the ancient gold and brass articles which are frequently discovered in most parts of Ireland, in the form of opened rings, with the ends considerably flattened, were formerly used as current money.



---

p.409



Many opinions had previously existed as to the purposes for which they had been intended, some having supposed them to be brooches, and others ornaments worn in the worship of the sun and moon. Many of the specimens found are of different forms, some having the ends so slightly flattened as to be scarcely discernible from an opened ring, and others having them gradually expanded, till the ring connecting them forms only a small part of the whole. They are also invariably graduated to a certain scale of weights, which appears to correspond with our modern Troy weight. These circumstances induced **Sir W. Betham** to conjecture that they formed a part of the same currency as the perfect rings. At the time of my visit, he was receiving much additional information, which enabled him soon after to read a most interesting and conclusive paper to the academy. My space will not allow me to do more than merely notice this paper, in which he throws some light upon the extensive commercial dealings of the Phoenicians, and upon their intercourse with Ireland. He discovered that a regular trade is still carried on by


---

p.410





Sir John Tobin, and other English merchants, with the inhabitants of the coast of Guinea, in these very articles. Their peculiar form so exactly resembles that of the "Monaghan Manilla" (so called from the number which have been found in that county) as to leave no doubt that they are for the same purposes. They are used by the African Negroes as money, and are termed by them "Manillas," a name, which, observes **Sir W. Betham**, is in itself a powerful testimony, as in the Celto-Phoenician language, it literally means the *representation of property.* For his remarks upon the connexion of the Phoenicians, with the nations south of the "Pillars of Hercules," as well as with Ireland, I would refer my antiquarian and numismatical readers to the papers themselves.


In consequence of information received from **Mr. Petrie** respecting the body of a man found in a bog in Donegal, which is in the possession of the Royal Dublin Society, I was gratified on my second visit to the Society with a sight of this antiquated gentleman. In a paper communicated to the Dublin Philosophical Journal, **Mr. Petrie**


---

p.411



says, "In the summer of 1821 the body of a man was found in a bog on the lands of Gallagh, near Newtown Bellew, the seat of C. D. Bellew, Esq., in the county of Galway. The bog was about ten feet and a half deep, and the body lay about nine feet below its surface. It had all the appearance of recent death, when first discovered, excepting that the abdomen was quite collapsed. The face was that of a young man of handsome features and foreign aspect, and his hair, which was long and black, hung loosely over his shoulders. The head, legs, and feet, were without covering, but the body was clothed in a light dress, covering also the limbs as far as the knees and elbows. This dress was composed of the skin of some animal, laced in front with thongs of the same material, and having the hairy side inwards; and it is not improbable that it might have been that of the moose-deer. He had no weapon; but, near him, at each side of the body, was found a long staff or pole, which it was supposed he had used for the purpose of bounding over streams; and, as the body was found near a


---

p.412




rivulet, it was further conjectured by the peasantry that the man had met his death accidentally, in some such manner."[27](javascript:footNote('E830001-002/note027.html')) The dress worn by this body leads **Mr. Petrie** to conclude that it belonged to a period antecedent to the arrival of the English; and this opinion is supported by some very interesting information, for which I regret that I cannot find room. In consequence of the action of the air, the body has shrunk up, but the covering of skin still exists, with the hair in good preservation. The reader who may feel curious on the subject, will be abundantly rewarded by referring to the original communication.


I left Dublin at five in the afternoon of the 28th of December — reached Liverpool at half-past eight the following morning — and was comfortably seated by my own fireside in Lancaster that evening.




---

p.413


GENERAL REMARKS
---------------


Within the limits of a concluding chapter but little can be said respecting the causes which have conduced to the remarkable disparity that exists between the state of this country and that of the land of which I have attempted to give some account in the preceding pages. To detail (as would be necessary, in order to exhibit these causes) the history of Ireland from the period of its connexion with Great Britain as a conquered country, to the present moment, at which, nominally at least, it bears the character of an integral portion of the empire, would be to enter upon a subject of mighty difficulty and of unmanageable extent. A few observations, however, may be offered, even within the contracted space which



---

p.414




remains, on some of the remedies proposed for the national restoration of one of the finest countries in the world.


Ireland presents to those who contemplate her peculiar condition, a striking and fearfully disgraceful anomaly. Possessing a singularly fertile soil, capable of abundantly repaying the labour bestowed upon it, she also possesses a population depressed by more than ordinary destitution, and dishonoured by a long catalogue of more than ordinary crimes. This state of things, so truly deplorable, whether regarded in a moral or a physical point of view, is exclusively referrible to the systematic course of partiality, oppression, and cruelty, with which her people have been treated through successive centuries; and if it were my object to represent the injuries that have been done, rather than to dwell upon the prospect of good things to come, I might, by referring to authentic sources of information, draw a series of terrific pictures of persecution, intolerance, and desolation, to which it would be difficult, perhaps impossible, to find parallels in the history of any



---

p.415



nation not absolutely barbarous.[28](javascript:footNote('E830001-002/note028.html')) It becomes *us,* who are in some degree responsible for the misdeeds of our predecessors, and are certainly bound to repair the evils they have effected; it becomes us, I repeat, to bear constantly in mind, that ever since her connexion with Great Britain, Ireland has been a grievously oppressed country; that for the ignoble purpose of extinguishing her religion,[29](javascript:footNote('E830001-002/note029.html')) and seizing upon the property of its votaries, she has been deprived of those political privileges which were her right, and which, sooner or later, she *will* possess; that so far from the Irish being naturally a turbulent people, they are made so by circumstances *under the control of England;* and that dissatisfied as they are and have been, the wrongs they have endured, the insults they have suffered, would have justified a course of conduct



---

p.416



incomparably more violent than any which Ireland, even in her most excited moments, in her wildest paroxysms of resentment, has displayed. The terms of the Union, let us remember, promised an equality of civil rights, and, until those terms are rigidly complied with, Ireland never will, and Ireland never ought to be, a contented country. Convinced, however, that a brighter day is dawning — nay, has already dawned — I would drop the veil over the frightful transactions of by-gone times, and look cheerfully and confidently towards the future.


As it is not unusual to hear the Irish charged with the several vices of *idleness, cruelty,* and *recklessness,* it may be well perhaps to keep these allegations in view, in the course of the following observations.


As to the charge of *idleness.* When it is considered that they receive comparatively no reward for their labour; that the market is constantly overstocked; that the more they exert themselves, the more they increase the surplus labour, already too great; and that the disappointments they so



---

p.417



repeatedly encounter, have a tendency to destroy their energy, and to produce indifference or despair, the wonder is, not that they are *idle,* but that they are not something infinitely *worse.* It is, in fact, utterly impossible, under the present state of things, for the Irish poor to be anything *but* idle. This, however, is a well-established fact, that as soon as they have any prospect of being *compensated* for their labour, it is applied with skilful and enthusiastic industry. Let the character of Irish labourers be sought in the large seaports; let an appeal be made to the extensive English farmers, who are glad to avail themselves, in harvest-time, of their valuable services. From either of these quarters, an answer, far from discreditable to the objects of the inquiry, will be returned. In confirmation of this opinion I would take the liberty of introducing a passage from the letter of one of the most spirited and experienced of British agriculturists, William Stickney, of Ridgmont, in Holderness. I could not refer to higher authority. This gentleman has for many years annually employed, during the harvest-season,



---

p.418



a number of Irish labourers; and this is the judgment he has formed respecting them. "For honesty," says he,"sobriety, industry, gratitude, and many other good qualities (when working by the piece, or at good wages), they far surpass the same class of English labourers. When the Irish begin to arrive in this country, it is sometimes two or three weeks before the harvest commences, and if they do not immediately find work, many of them are without the means of subsistence. Under these circumstances, they frequently apply to me to lend them a few shillings, which I do in small sums, amounting, in the whole, to several pounds, and this without any injunction that they should work it out with me. They give a verbal promise that they will return the loan before they leave the neighbourhood; and I do not remember an instance in which they have ever deceived me; they have invariably returned the money lent, with a deep sense of gratitude. Admiring the Irish labourers, as I have reason to do, I am always glad to see them when they make their appearance. In the summer season I frequently



---

p.419



have from thirty to fifty, or more, lodging upon my premises; several of them working for other persons in the neighbourhood, and many of them entire strangers to me; yet I would trust my life and my property with them much sooner than I would with the same class of English labourers; and I consider my premises more secure from depredation under their protection, than I should with any other strangers."


If the outrages committed by the Irish people are incapable of vindication, facts and circumstances may at least be produced in extenuation of the excesses into which they are hurried. On an impartial consideration of some of these particulars, it will, I think, be apparent, that the very worst of our fellow-subjects in "the sister isle" are certainly not more cruel and vindictive than any other people would be under similar treatment; and that the outrages of which they are guilty, are, in fact, for the most part, the natural growth of the policy adopted towards them. We often, for instance, hear of murders being perpetrated upon such as have taken land from which


---

p.420




others have been ejected; and it is possible that Englishmen, knowing that similar effects do not follow similar causes in *this* country, may be disposed to consider a case clearly made out against the Irish, on the strength of this single peculiarity in their history. Between the respective systems of taking land in England and in Ireland, there is, however, a material difference; a difference so material as to render any analogy that may be drawn, a very imperfect and fallacious means of reasoning. An English farmer, when ejected, having little or no difficulty in obtaining another farm, has little or nothing to dread; in Ireland, when a man is ejected, it is next to impossible for him to find a farm at liberty. What is he to do? Money he has none — and without a farm he is placed in a situation that offers him three alternatives; he must either beg, or steal, or starve with his family; for, as yet, the reader will bear in mind, no legal provision for the destitute has been provided.[30](javascript:footNote('E830001-002/note030.html'))




---

p.421


In this manner have great numbers been turned adrift — not because they were in arrear of rent — not because they had transgressed the rules of their lease — but simply because they happened to profess a religious or political creed at variance with that of a capricious landlord. It cannot surely be denied, that, systematically and wickedly oppressed as the Irish labourers are, to rise in self-defence, however frightful may be the results of such resistance, is at least a natural mode of procedure.


But other powerful causes operate to increase the hardships which the poor tenants have to endure. In many cases, having purchased a right of possession from the previous occupiers, they consider themselves to have a permanent interest in the farms for which they have paid; accordingly, ejectments are resented by strenuous combinations. Outrages, thus occasioned, are frequently misrepresented, for the very worst of purposes, as arising out of political or religious animosities; and hence it is that in the minds of those unacquainted with the peculiar condition and circumstances



---

p.422



of the country, prejudices, more easily rooted than removed, are established against both the religion and the politics thus stigmatised and calumniated. One instance of an outrage, which occurred within the present year, and which is totally distinct from either of these causes, but susceptible of being converted by party-spirit into a powerful party engine, I will give in an extract from the letter of a gentleman who has long resided in Ireland, and who has the best opportunities for observation.


"During the week in which I received your first letter, there was a reward of fifty pounds offered by the Irish Government for the apprehension of some persons who dug up a grass field in the county of Limerick. This, to persons not knowing the real state of the country, would appear to be a most wanton and malicious destruction of their neighbour's property; you will be astonished when I tell you that dire necessity, not wantonness, led to the act, and that it is most probable that not the slightest degree of malice was entertained by the perpetrators towards the owner of the field.



---

p.423



I have known and seen many such outrages committed on property, and will tell you what I found to be invariably the circumstances connected with them. In the southern and midland counties, the lands are let in large farms to persons who rear and feed cattle, and keep extensive dairies for the making of butter, &c.; and the consequence is, that the poor cottier cannot, in hundreds of cases, procure a piece of land to plant potatoes for his miserable family. Though he is willing to pay an enormous rent for the land to grow a crop of potatoes, the farmer generally thinks it unprofitable to let a field for the accommodation of his poor neighbours. They are therefore urged by their necessities to band together, and go at night, and partially or wholly dig up a field, for then the farmer must let it to them (being unfit for grass) at from 8 to 12 guineas per Irish acre. Thus, you see, actual want compels them to force the farmer to sell them the use of his field for that season. You will say that this is a frightful state for a country to be reduced to, when the people are obliged to risk one of the severest penalties of


---

p.424




the law, that they may get, and for a high price, that which they cannot do without — yet such is the fact. You may think it strange that a farmer should require to be forced to let his land at such a high rate; but when you consider how difficult it is to induce a dairy, or cattle-farmer, to become a tillage-farmer, and when you also take into account that a man having his arrangements for the dairy-farm made (that is, having the quantity of cattle necessary for his farm), if he then gives a ten or twelve-acre field to plant potatoes in, he must sell 10 or 12 cows at a time, when the markets may be depressed, and of course he be a loser — I say that, taking these things into account, you will understand why the farmers are so averse to letting their land in that way."


During the war, when beef and pork sold high, the farmers found it more profitable to feed calves and pigs with their milk and buttermilk, than to sell it to their poor neighbours. The consequence was, that these wretched creatures would band together in a district, go to the farmers at night, and swear them not to rear more than a certain



---

p.425



number of calves and pigs, and to sell the surplus milk. The farmers frequently violated the engagements thus forced upon them. They were again visited, the calves killed, and themselves *carded,* and otherwise dreadfully abused. Many wretches have been transported for these offences. It is indeed a frightful consideration, that a people are driven by poverty to the commission of such crimes! If the £50 reward, which procures the punishment of the guilty parties, had been previously spent in finding them employment on a small portion of the numerous wastes, the crimes for which they justly suffered would not have been committed, nor their unoffending families reduced to beggary and ruin. Although these crimes, so much to be deplored, do not, as I have attempted to shew, arise from the naturally vindictive character of the people, it is obvious that they cannot be perpetrated without a danger of establishing, on a formidable scale, ferocious and lawless habits. When, however, the almost incessant cruelties which the Irish have been obliged to endure ever since the invasion of Henry II.



---

p.426



are considered, the wonder is, not that outrages prevail, but that they are not incomparably more numerous and terrific.


From these topics, painful at the best, let us turn to a consideration of some of the means by whose agency Ireland may be lifted from the degraded condition in which the nations of the earth behold her.


To me it appears that (legislative measures of an exclusively political nature out of the question) Ireland must owe her social regeneration to a successful attention to Agriculture, and that it accordingly behoves all her lovers and well-wishers to bestow upon this great science, with an especial view to her advantage, at least some of the time and some of the interest which have hitherto been engrossed by topics of a more exciting, but not more important character. Whilst, to certain persons, the minute subdivision of land appears pregnant with evils and fraught with danger, by others it is regarded as one of the most feasible projects for the amelioration of the state of the labouring population of Ireland, and consequently



---

p.427



for the advancement and honour of the *whole* of that afflicted country. I have no hesitation in declaring my concurrence with the last of these views. There never was, I sincerely believe, a more egregious and mischievous error than to suppose that small farms, in the present state of Ireland, are a source of evil. Like absenteeism, they are the consequence of evil, not the cause. By the discouragements affecting agriculture, and by the decay of trade, the farmers are so impoverished as to be totally without sufficient capital to enable them to occupy large holdings; the result is, large farms do not exist in any considerable number, nor, if they did, would the imperfect skill of the people be adequate, at present, to their management. But to say, that small farms are the cause of distress, is not a whit less illogical than to assert that a spare dinner, or a threadbare coat, is the cause of a man's poverty. If a poor man in Ireland have no land, he must starve. The misery attendant on small farms is not apparent when they are properly conducted. It was the opinion of the most intelligent agriculturists,



---

p.428



and of all classes best able to judge, in the course of our Examinations (and I would request the reader's particular attention to this fact), that more produce is raised per acre, and more rent paid, on small farms, than on large ones; and that when properly cultivated, four acres enable a man not only to keep his family in comfort, but to save a little money. He pays the rent from butter, and has his milk and potatoes, his pig, and part of his grain, for the consumption of his family, and to meet incidental expenses. The large farmer is, of course, a more scientific and a better educated man, and has a larger capital at command; a poor man's capital is the labour of himself and his family; and although the large farmer has the advantage of the knowledge arising from superior instruction, nothing can be easier than to teach a small farmer, particularly an Irishman, so much, and quickly too, as will qualify him to become an excellent agriculturist. When shown, that by mowing his clover, rape, &c, for his cow, an acre will keep three cows instead of one, and that by keeping them in a yard, where all the 



---

p.429



manure will be preserved, and increased by the addition of various kinds of collected vegetable matter, his crops will be augmented; that, in fact, paradoxical as it may seem, the more cattle he keeps, the more grain his little farm will be susceptible of yielding; his exertions cannot fail to be stimulated by the simplicity and the facility of means which are to produce such incalculably important ends. He attempts the course recommended for his adoption, and finds it answer, even beyond his expectations. This is a beautiful system, and not less practicable than it is beautiful. It is within the scope of the poor man's intellect; it is intelligible to the meanest capacity; and places those who adopt it, on a level, to all practical purposes, with the best-educated farmer. Numerous instances have I witnessed of the admirable tendency of this system.[31](javascript:footNote('E830001-002/note031.html')) No large farm with which I am acquainted


---

p.430



(and I have inspected many of the best managed estates in the three kingdoms) can surpass many of the small ones under Mr. Blacker's care; nor is this remark limited to a score or two of farms, consisting of one peculiar species of land, but comprehends many thousand acres, and a vast variety of soils. Besides, by first having a small farm, they are enabled to exert the only capital they possess, namely labour; and, after a series of successful endeavours, to increase their holdings. Circumstanced as Ireland is, there must be small farmers, before there are large ones; and the small-farm system, apart from its immediate utility, is productive of very important benefits, in a moral point of view. It is a system of social gradation and progression; the higher and more advantageous positions being open to a judicious exercise of energy and industry. By multiplying the number of those who have an


---

p.431




interest in the land, *as holders,* it is the means of diffusing a spirit of independence and self-respect, and has an inevitable tendency to elevate the rank of the agriculturist, in a proportion at least equal to the increase of their physical comforts; for they are lifted above the condition of mere servants, and established in the character of masters.


For the sake of precluding misunderstanding, I would here observe, that I am no advocate for small farms, *except when the circumstances of the country require them,* which I conceive to be the case in Ireland at present. I would not, for instance, recommend that the 300-acre farms of England and Scotland should be divided, although I am persuaded there would be a very signal advantage in dividing those *above* that size. It is much more profitable, even for the farmer himself, to produce a good crop on a small quantity of land, than a middling crop on a large extent.


On commencing the above system, some pecuniary assistance, but to no great amount, is requisite. According to Mr. Blacker's plan, a loan of



---

p.432



lime or clover seed will be sufficient; according to Mr. Rose's, of a cow or a pig. Proofs of complete success, under the judicious management of these gentlemen, may be seen in Armagh, Tyrone, and Monaghan. Not only there, but in other parts of Ireland, I had the pleasure of witnessing a great number of examples of its efficacy; examples of farmers, occupying small holdings of four acres, having been raised from indigence and despair to a condition of positive comfort — in their own words, "to a state of *independence."* Having had abundant opportunities of personally observing the effects of the small-farm system, I may be permitted to speak confidently respecting it; and my firm persuasion is, that so far from being, what some have too hastily pronounced it, a system of pernicious tendency, it can only be followed by pernicious results, when pursued in a careless, slovenly, and injudicious manner. As with all other projects, success or failure in *this* system turns upon the proper or improper mode of conducting it. But, however improperly managed, it would be impossible to be productive



---

p.433



of evils in any degree equal to those which exist under the present course of things. The Irish are at present literally in a state of continual starvation; and it is well known that numbers of them do not obtain four shillings a week; and that if they could get a shilling a day they would be indifferent about land. Farmers of *capital* are out of the question at present: a systematic improvement in the country must take place before they are brought into existence; for such are the political and religious dissensions, that respectable people are unwilling to sacrifice the greater security and privileges which they enjoy in England, for the uncertainties of a life spent in Ireland. Accordingly, before the capitalists of *this* country will venture to embark in extensive speculations in *that,* the legislature must apply remedies for the unhappy differences that distract and disgrace it. The Irish, as I have had repeated occasion to observe in some of the preceding chapters of this work, must be treated as A People — not, as heretofore, as a vast multitude of obnoxious sectarians; and the laws and institutions



---

p.434



conferred upon them, must be devised without reference to religious distinctions. That such is the desire of the Irish *Government* we have recently had the eloquent testimony of the Lord Lieutenant; that such is the desire of the great mass of the people of England, has been incontestably proved over and over again. But, powerful as legislative measures must *ultimately* prove, something more is wanted to effect a speedy adjustment of existing evils; and attention directly turns to the noblemen and wealthy proprietors of Ireland, as the means of accomplishing what parliamentary enactments, if unaccompanied by their co-operation, would be comparatively tardy in achieving. The duty of regarding their poorer fellow-subjects in a spirit of more enlarged and enlightened toleration, imposes a paramount obligation upon these influential individuals; and it is to be hoped that the day is not far distant when the ambition of maintaining or establishing the predominance of *a party,* will yield to the loftier ambition of promoting *the general good.* The moist and genial climate, and the mellow and



---

p.435



fertile soil of Ireland, peculiarly adapt that country to the growth of hemp and flax, and the production of abundance of milk and butter. The latter indeed has always been a staple commodity. Mr. Blacker thinks the duty upon the foreign import of these articles ought to be so much advanced as to make them equal to the present duty on grain.[32](javascript:footNote('E830001-002/note032.html')) This would have an almost immediate tendency to bring more land into cultivation, and ultimately to reduce the price of the articles protected. Mr. Blacker states that the country pays annually for foreign butter, tallow, hemp, and tobacco, in round numbers, £6,000,000: besides many minor articles, all, or most part, of which, might be produced at home. We have seen that the protection of Corn Laws has enabled the British farmer to produce a sufficiency of grain for home consumption; and if the previously mentioned articles were equally protected, we should, I doubt not, have a supply adequate to our necessities: under this plan, not only would more land be



---

p.436



brought into cultivation (in consequence of which, the prices, as I have before said, would be diminished) but that already cultivated would be improved, by reason, first, of the improved mode of feeding cattle,and secondly, of the necessarily additional number of cows. As agriculture became extended, the labour of the people would be in greater demand; they would accordingly receive better wages, and be enabled to live on better food: and it is a self-evident proposition, that the better the food on which a people live, the more the produce is increased—because the more cattle and sheep that are kept upon the land, the more that land is enriched; provided, of course, the food of the cattle, and the manure, be economically husbanded and judiciously applied. Corn and cattle, like agriculture and manufactures, operate favourably towards each other. The more cattle the more corn; and, on the other hand, the increase of corn augments the means of subsistence, both for cattle and man. The increased and improved cultivation of land in Ireland, must, I am firmly persuaded, form one of the principal remedies for


---

p.437




the singularly depressed state of that country. Under a proper system of agriculture, more than double the present population might find profitable employment; and when agriculture and manufactures go hand in hand, as they unquestionably will, if not unfairly interfered with, profitable occupation for four or five times the number of hands at present employed, will, I feel well assured, be provided.


In hazarding this assertion, startling as it may appear to some, I am perfectly convinced that I speak within compass: and having bestowed much of my time upon agricultural pursuits, for the last thirty years, I may perhaps, without incurring a charge of undue presumption, be allowed to feel confidence on subjects to which so much of my attention has been necessarily devoted. Let any one who may be inclined to question the accuracy of my suggestion as to the probability of the produce of Ireland being at least quadrupled, look at the miserable state of the land at present under cultivation (if, indeed, it deserve the name of cultivation) —the ground covered with weeds — in



---

p.438



want of draining — deprived of manure — having, at the best of times, but a scanty allowance of bad seed, and sometimes none — the farmer, with the rudest implements, and ignorant of any proper system of farming — deficient in even a poor description of cattle — possessing very few sheep — the Bailiffs, or "Drivers," regularly pensioned upon him, whether he pays his rent or not — and attending him to market, to prevent him appropriating to his own use the money for his produce! Let him cast his eye, as he travels through the country, over the immense bogs and waste lands, which are everywhere to be seen; and, after observing these things, he cannot fail to be convinced that Ireland might easily be made to yield four or five times as much grain, cattle, butter, hemp, and flax, as she does at present. Nor has the British land-owner, or farmer, any reason to feel alarmed at this prospect. A great part of the additional produce must be consumed by the population of Ireland; this is a certain consequence of the improved cultivation of the country. Where, I would ask, where are now the immense numbers



---

p.439



of shoemakers, and tailors, blacksmiths, and carpenters, coachmakers, and sadlers, with a great variety of trades and professions which I need not stay to particularize, but which will necessarily be called into existence and operation, as the increase of industry and capital is created?


The remedy above suggested, is something more than a vague and impracticable theory; it has the merit, if I mistake not, of being perfectly feasible. Let landlords do as Lord Gosford has done, and it is accomplished.[33](javascript:footNote('E830001-002/note033.html')) Should Government think it expedient to second the endeavours of individuals, by extending protection to the farmers in respect of the several articles before mentioned, and to promote the diffusion of agricultural knowledge, but particularly of the allotment system, the remedy will be secured, not perhaps more surely, but with greater expedition. If this were once adopted, the workhouse-system



---

p.440



might be dispensed with — a system, which, while it will require an enormous expenditure of money to carry it into effect, will be attended with considerable risk, and be of doubtful benefit at the best. For it will scarcely be denied, that unless profitable employment be provided for the inmates of those establishments, no benefit will be conferred upon society, at all comparable with the expense of providing and maintaining them: no useful capital or stock is made available, as in the case of money devoted to agricultural improvements, which accumulates as compound interest, and, instead of destroying the energy of the labourer and his family, stimulates them to perpetual exertion, under the expectation of receiving the reward of their labour, in proportion to the degree in which they employ it. If a man once enter a workhouse, and be reduced to the necessity of being fed as a pauper, his moral energies, I contend, and his sense of shame and independence, are dissipated and broken. Besides this, no comparison can be instituted between the system in England, and that contemplated to be established in Ireland.


---

p.441




In England, a workhouse may *easily* be made less agreeable (independently of the loss of liberty) than a labourer's home; in Ireland, on the contrary, what sort of habitation can you put him in, that will not be infinitely superior to his damp, dark cabin, which admits the rain and wind through various parts of the roof? and how is he to be *fed* in a workhouse, in a manner *inferior* to his ordinary mode of subsistence? You can hardly deny him a sufficiency of potatoes and salt!


I am confident, as I have said before, that the land now in cultivation, would, if properly occupied and conducted, supply plenty of work, not only for all the present population of Ireland, but for a very considerable increase.[34](javascript:footNote('E830001-002/note034.html')) The cultivated lands alone allow *ten and a half acres* for each



---

p.442



family of the whole population, whereas, in Great Britain, the proportion is but *ten acres.* As these lands, however, may not be *immediately* available, it becomes necessary to direct attention to the unreclaimed and useless wastes. The quantity of such wastes is almost incredible. In the county of Cork alone, according to the testimony of the gentleman just mentioned, there are upwards of 700,000 acres; in Donegal, 644,000; and in Ireland, altogether, between five and six millions; a great part of which is suitable for cultivation. This being the case, and seeing that the labouring population is principally agricultural, how much more desirable it is, for labourers to migrate to those parts of the country where the land holds out inducements for profitable labour, than for them to be transported to Canada; and how vastly injurious to their industry and enterprise would be the introduction into the poor-law bill of any settlement clause![35](javascript:footNote('E830001-002/note035.html'))




---

p.443


I am far from being prepared to recommend the expenditure of much capital in extensive drainages in the cultivation of the *bogs,* until all the other land which *can* be brought into cultivation without extraordinary outlay, should be improved; because the returns would be quicker and more certain from the land at present under cultivation, and from the wastes which are not bog. The deep and wet bogs may be reserved to the last; although I know perfectly well that bog-land, when drained, is admirably adapted for growing luxuriant crops, with less labour and manure than almost any other description of land. Besides (and this is an important consideration), the wear and tear of the necessary implements of agriculture, is very light upon a bog-farm. In Lancashire, where some extensive mosses (in Irish phraseology, *bogs)* are


---

p.444



cultivated, the produce, on an average, is from 5 to 7 quarters of oats per acre; and if the system of burning the moss were abandoned, and a quantity of good manure applied, the average would be considerably larger. The bottom moss (after the turf has been dug off, and sold for a handsome sum), where there is a subsoil of marl, gravel, or clay, is most valuable land, and produces excellent wheat and other grain, the finest grasses, and turnips, mangel wurzel, and other green crops, in perfection. These are precisely of the same nature as the Irish bogs.


The cultivation of bogs has been injudiciously decried, and unfairly represented. We perpetually hear of the expenses of cultivation, and the losses that attend it; but these, it is important to remember, are the cases of *Gentlemen Agriculturists;* and when or where did gentlemen *not* lose by cultivating and occupying land, whether good or bad? Nothing, or but little, is said of the many small patches of verdant bog, won by the quiet industry and perseverance of the poor labourer, and rendered fertile by his labour alone. The 


---

p.445




summer stall-feeding being adopted, such an accumulation of manure would be provided, as at once to dispose of all the difficulties attending the cultivation of the most barren lands. The economical use of food, enables the farmer to maintain treble the number of cattle upon the same quantity of land; and, what may seem extraordinary to those unacquainted with the subject, the plants of clover, tares, and grasses, produce, when mown, much more than when pastured. The crops of grain, moreover, which succeed the mown clover (though two, or even three, crops of the clover have been taken from the land in one season) are superior to what they would have been, had the clover been pastured.


The only rational objection that *has* been, or, in my opinion, *can* be urged against this system, refers to the increased labour which it obliges: but, where labour is even of the highest value, the disadvantages bear no comparison to the positive benefits that accrue. One of these benefits, and not perhaps the least of them, is, that under the system I have been recommending, there would



---

p.446




be no danger of the famine and destitution which have so frequently occurred. Such a variety of produce being raised, some of it, whatever the season may be, is certain to suit; besides, there would be in store the cattle, and their food.[36](javascript:footNote('E830001-002/note036.html'))


My opinion, it has been seen, is in favour, strongly in favour, of the possibility of Government and Companies (without the loss of a farthing) profitably employing all the unemployed labourers upon small farms or the waste lands, at piece-work, in draining, gravelling, claying, and bringing them into a state of cultivation sufficiently excellent to attract the attention of purchasers or takers. To provide the people with work by the piece, and to let every man receive a reward proportioned to his industry, is, I am convinced, the only way of creating a proper energy and independence among the people.[37](javascript:footNote('E830001-002/note037.html')) Every other plan with which I am



---

p.447




acquainted, seems likely to be attended with difficulties and expenses of a fearfully formidable extent. When men know that they are working merely for the sake of work, they never work with the same spirit as when employed for some real and beneficial purpose. This feeling (which constitutes one of the distinguishing differences between man and the brute creation) ought, instead of being rudely and cruelly suppressed, to be religiously fostered and preserved; — but within the degrading atmosphere of a workhouse, it will pine, and decay, and become extinct. It is incompatible with the very nature of such an institution, so conducted; an institution of which the bare idea is humiliating and odious.


On the subject of Poor-Laws, at the present moment so peculiarly important and interesting, it may be expected that I should speak in decided terms; and having expressed myself somewhat strongly against the contemplated workhousesystem, I may be understood to be equally opposed



---

p.448



to the principle of the great question with which that system has been latterly connected. Such a supposition would be erroneous. Unless Poor-Laws were constructed upon a wretched plan, it is manifest that vast good cannot fail to accrue from them. They will impose, for instance, the burden upon the landowners, who will accordingly feel bound, by considerations of self-interest, to improve the condition of the surrounding population. Productive, however, as they may be of benefit, they are at the best but a roundabout way of accomplishing the desired end — namely, of *creating labour.* What I should desire would be — when an able-bodied labourer complained of the absence of work, to answer his application in these words; "Here are four acres of waste land, of which you may have a lease for 21 years; you may go there; and, with such assistance as will be provided, you and your family may find abundant employment, and live in comfort." Let this plan be tried first; let the labourer *go* to his new location; let him be supplied with a few poles, worth as many shillings, to build his cabin with; and some lime or



---

p.449



manure, and a few potatoes; and, thus provided, let him work or starve. A system based on these principles, might be easily managed by a Board, similar to that constituted for the superintendence of the Poor-Laws; and the people might be rated for it with as little difficulty as for the maintenance of those laws. The workhouse, pregnant with numerous and mighty evils, should be the last resource. Houses of Refuge for the aged and helpless, would be highly desirable and most admirable institutions; but to send a hale, strong man, anxious to employ himself in profitable and useful labour, to waste the best part of his life in degrading idleness and confinement, is, I feel strongly persuaded, in every respect an act of indefensible policy.


In reference to a subject treated of in a previous page, respecting the employment of professed agriculturists to superintend the early management of small farms, and to impart instruction to the ignorant farmers on the principles of agriculture (which might be done at a trifling cost, the salaries of many of such agriculturists being under


---

p.450




£40 a year), I am aware that it may be urged in opposition to it, that some landlords do not feel *disposed,* and that many are not *able,* to embrace the measures proposed for their adoption. I am aware, too, that it is far from being desirable that Government should advance money, or hold mortgages of estates; but Ireland is an important exception to a general rule, and, by one means or another, must be rescued from her present deplorable condition — a condition sufficiently wretched to reflect disgrace upon any state that should pretend to even the slightest degree of civilization. I would accordingly presume to recommend that Government should advance money to such of the proprietors as were disposed to accept of it, on security of their estates, at 3 1/2 or four per cent — (the rate of interest in Ireland being six) for the purpose, under certain regulations, of improving the respective properties. Nor need the fact of the estates being mortgaged to their present worth, operate as a bar to the further advance of pecuniary assistance; because, provided the money be laid out judiciously in permanent improvements, 


---

p.451



the estates would be increased in value, in proportion to the sum so expended upon them.


To the above, another project may be added. Government might take lands on long leases, and let them to occupiers in small portions for shorter terms; or might at once purchase, in large portions, the waste lands or estates of such as do not feel disposed, or are not able to reclaim or improve them, and sell them out, in smaller allotments, or let them on 21 years' leases, to those who *might* be disposed to cultivate them. These measures, although I am convinced that they would be important and beneficial in their results, do not perhaps properly fall among the *direct* duties of Government, whose legitimate and most effectual method of *ultimately* securing the desired advantages of national comfort and prosperity, is to establish, without reference to sect or party, equal laws to all classes of the community.


One of the most inane of fallacies is that of asserting that Ireland contains a redundant population; and one of the most inane of remedies is that of emigration. If what a distinguished



---

p.452



writer has observed be true, that in every country where the inhabitants have unhappily diminished, there, instead of the means of subsistence having been more liberally dispensed, the population has been invariably still more degraded and reduced in condition than in numbers; it follows, as a matter of course, that emigration would have the effect of augmenting the calamity instead of diminishing it: Emigration, in fact, is the remedy proposed by a narrow and short-sighted policy — a policy that would postpone the consideration of the *great* evil, by appearing to do away with a portion of it. But, admitting emigration to be the only effectual cure for a redundant population — it may be suggested to those who advocate the trial of it, that no population can properly be said to be redundant, until all the resources of which a country is possessed, have been fairly, and fully, and finally applied. Then, and not till then, can a population be pronounced redundant; then, and not till then, should emigration, in a national point of view, and on a national scale, be adopted. Supposing the present condition of



---

p.453



Ireland to exhibit the maximum of advantage obtainable from that country, a fair case is doubtless made out in favour of a transference of large numbers of its people to distant climes; but Ireland does *not* exhibit this maximum. Ireland, it is notorious to those who know anything of its internal history, yields little compared with what it might be made to yield. I have shewn, in the course of these volumes, that double, or even treble the number of labourers might be profitably employed; that the produce of the earth might without difficulty be at least quadrupled; and that a variety of almost unbounded resources of employment and wealth, are unexplored and unproductive. Away, then, with the absurd cry of a surplus population; and away, too, with the equally absurd cry of emigration. The money requisite to carry into operation a comprehensive plan of emigration, would more than provide means for supplying the whole of the unemployed population with work, and accordingly, for augmenting the opulence of Ireland, and for elevating the moral and physical condition of her people. Upon this


---

p.454




subject, I shall indulge in only one additional remark; — that the people who *leave,* are usually the energetic, the industrious, and the monied; those who *stay,* the idle, the dissolute, the spiritless, and the poor.


In conclusion, I would briefly remind the reader of this very important particular: — that so far from the supposition that Ireland contains a surplus population being correct, the truth is, that her labour is perfectly inadequate to the development of her various and almost unbounded resources. No course of policy, founded upon so grand a mistake as is implied in the conclusion that extreme poverty is a necessary sign of a superabundance of labour, can ever lead to permanently judicious and salutary results.














