

#The Irish Lives of Guy of Warwick and Bevis of Hampton


<!-- // 
 function footNote(link) {
 openpopup = window.open(link,"openpopup","width=512,height=128,left=256,top=256,resizable=no,scrollbars=1,menubar=1,statusbar=0,toolbar=0");
}
// -->



#### Corpus of Electronic Texts Edition


### Background details and bibliographic information


The Irish Lives of Guy of Warwick and Bevis of Hampton
======================================================


Author: [unknown]
-----------------


### File Description

ed. by F. N. RobinsonElectronic edition compiled by Benjamin Hazard and Beatrix Färber

Funded by University College, Cork and  
The Higher Education Authority via the LDT Project 1. First draft, revised and corrected.Extent of text: 

61 476 words#### Publication


CELT: Corpus of Electronic Texts: a project of University College, Cork  
College Road, Cork, Ireland — http://www.ucc.ie/celt

 (2005) Distributed by CELT online at University College, Cork, Ireland.  
Text ID Number: T306000Availability [RESTRICTED] 
Available with prior consent of the CELT programme for purposes of academic research and teaching only.


#### Sources


**Manuscript sources**2. Dublin, Trinity College Library, H. 2. 7. For details see T. K. Abbott (ed.) Catalogue of the manuscripts in the library of Trinity College, Dublin (Dublin 1900) 317 ff.
**Editions/Translations**2. Max Nettlau, On some Irish translations from medieval European literature, Revue Celtique 10 (1889) 187-91 [A selection of passages from both Lives and notes on two Irish Franciscan fragments of the story of the Holy Grail].
**Other sources for 'Guy of Warwick' (includes some references from http://www.nls.uk/auchinleck/editorial/bibliography1.html#guy)**2. W. B. D. D. Turnbull (ed.), Sir Beves of Hamtoun: A metrical Romance, Maitland Club Publications 44 (Edinburgh 1838).
3. W. B. D. D. Turnbull (ed.), The Romances of Sir Guy of Warwick and Rembrun his son: now first edited from the Auchinleck manuscript, Abbotsford Club 18 (Edinburgh 1840).
4. John O'Donovan (ed.), The Tribes and Customs of Hy-Many, commonly called O'Kelly's Country (Dublin 1843) 63, note. (This text is available on CELT).
5. Eugene O'Curry, Lectures on the manuscript materials of ancient Irish history (Dublin 1861) 193, 658, with facsimiles (plate 13).
6. Julius Zupitza, Zur Literaturgeschichte des Guy of Warwick, Sitzungsberichte der Kaiserlichen Akademie der Wissenschaften der Philosophisch-Historischen Classe 74 (1873) 1, 623-668.
7. Henri d'Arbois de Jubainville (ed.), Essai d'un Catalogue de la littérature épique de l'Irlande (Paris 1883) 67.
8. Julius Zupitza (ed.), The Romance of Guy of Warwick: edited from the Auchinleck manuscript in the Advocates Library Edinburgh, and from MS 107 in Caius College, Cambridge, 3 vols., Early English Texts Society 42 (1883), 49 (1887), 59 (1891) (Trübner).
9. Eugen Kölbing (ed.), The Romance of Sir Beves of Hamtoun, Early English Texts Society e.s. 46 (1885), 48 (1886), 65 (1894), repr. 197 8(Trübner).
10. Eugen Kölbing (ed.), Amis and Amiloun und Guy of Warwick, Englische Studien 9 (1886) 477-478.
11. Carl Schmirgel, Appendix: Typical expressions and repetitions in Sir Beues of Hamtoun, Early English Texts Society e.s. 65 (Trübner 1894) xlv-lxvi.
12. Marianne Weyrauch, Die Mittelenglischen Fassungen der Sage von Guy of Warwick und ihre altfranzösische Vorlage (Breslau 1901).
13. Theodor Prosiegel, Review of Marianne Weyrauch (1901), Englische Studien 32 (1903) 405-407.
14. R. S. Crane, 'The Vogue of Guy of Warwick, from the Close of the Middle Ages to the Romantic Revival', Proceedings of the Modern Language Association of America 30 (1915) 125-194.
15. E. G. Schleich (ed.), Guy of Warwick, Nach Coplands Druck zum ersten Male herausgegeben, Palaestra 139 (Leipzig 1923).
16. A. Ewert (ed.), Gui de Warewic: Roman du 13e Sièle, 2 vols., Classiques français du moyen âge 74-75 (Paris 1932/33).
17. Laura A. Hibbard Loomis, Chaucer and the Auchinleck manuscript: Thopas and Guy of Wawick, in idem (ed.), Essays and studies in honor of Carleton Brown (New York 1940; repr. 1962) 111-128.
18. Laura A. Hibbard Loomis, Mediaeval Romance in England (Oxford 1924; repr. New York 1960).
19. Dieter Mehl, The Middle-English Romances of the thirteenth and fourteenth centuries (London 1968).
20. Eugene Vinaver, The rise of Romance (Oxford 1971).
21. D. J. Conlon, Le Romaunt de Guy de Warwick et de Herolt d'Ardenne (Chapel Hill 1972).
22. A. C. Baugh, The making of Beves of Hampton, in: William E. Miller and Thomas G. Waldman (eds.), Bibliographical studies in honor of Rudolf Hirsch (University of Pennsylvania 1974) 15-37.
23. Maldwyn Mills and Daniel Huws (eds.), Fragments of an early fourteenth-century Guy of Warwick, Medium AEvum Monographs New Series 4 (Oxford 1974).
24. Madeleine Blaess, L'Abbaye de Bordesley et les livres de Guy de Beauchamp, Romania 78 (1975) 511-518.
25. D. N. Klausner, Didacticism and drama in Guy of Warwick, Medievalia et Humanistica (1975) n.s. 6: 55-66.
26. V. B. Richmond, Chaucer's The Book of the Duchess and Guy of Warwick, Papers on Language and Literature 11 (1975) 404-407.
27. Derek Brewer, The arming of the warrior in European literature and in Chaucer: The Tale of Sir Thopas, in: Edward Vasta and Zacharias P. Thundy (eds.), Chaucerian Problems and Perspectives: Essays Presented to Paul E. Beichner, C. S. C. (University of Notre Dame 1979) 221-43.
28. Jennifer Fellows, 'Bevis of Hampton: Study and Edition', unpublished Ph.D. dissertation, University of Cambridge (1979).
29. E. B. Lyle, Sir Orfeo and the recovery of Amis from the otherworld in Guy of Warwick, Neuphilologische Mitteilungen 80 (1979) 65-68.
30. Judith Weiss, The major interpolation in Sir Beves of Hamtoun, Medium AEvum 48 (1979) 71-79.
31. Nicolas Jacobs, Sir Degarré, Lay le Freine, Beves of Hamtoun, and the 'Auchinleck Bookshop', Notes & Queries 227 (August 1982) 294-301.
32. Susan Dannenbaum, Guy of Warwick and the question of exemplary Romance, Genre 17 (1984) 351-374.
33. Tadahiro Ikegami, The tripartite authorship of the Auchinleck Guy of Warwick, Kyoyo-Ronso 78 (1988) 17-33.
34. Linda Brownrigg, The Taymouth Hours and the Romance of Beves of Hampton, English Manuscript Studies 1100-1700 (1989) 222-41.
35. Mechthild Gretsch, Mittelenglische Lexikographie und literarische Parodie: Zu einigen Wörtern in Chaucers 'Sir Thopas', Anglia: Zeitschrift für Englische Philologie 108 (1990) 113-32.
36. Janet Burton, Narrative patterning and Guy of Warwick, Yearbook of English Studies 22 (1992) 105-116.
37. Douglas Kelly, The art of medieval French Romance (Madison 1992).
38. P. J. Boehne, Lovesickness as contagion, Guy and Tirant, in: Josep M. Solà-Solé (ed.), Tirant lo Blanc: Text and context. The Proceedings of the Second Catalan Symposium: in memory of Pere Masdevall. Catalan Studies: Translations and criticism, volume 11 (Frankfurt am Main 1993) 5-18.
39. Tokuji Shimogasa, Popular expressions in the Romance of Sir Beues of Hamtoun, in: M. Kanno et al (eds.), Medieval heritage, essays in honour of Tadahiro Ikegami (Tokyo 1997) 349-367.
40. D. E. Best, Villains and monsters: enacting evil in Beves of Hamptoun, Medieval Perspectives 13 (1998) 56-68.
41. Roger Dalrymple, A liturgical allusion in Guy of Warwick, Notes & Queries n.s. 45 (1998) 27-28.
42. R. B. Herzman, G. Drake, and E. Salisbury, (eds.), Four Romances of England (Kalamazoo 1999).
43. Ivana Djordjevic, Mapping medieval translation in: Judith Weiss, Jennifer Fellows et al. (eds.), Medieval Insular Romance: translation and innovation (Cambridge 2000) 7-23.
44. Thomas Honegger, Luf-talking and Middle-English Romance, in D. Hans-Jürgen and M. Görlach (eds.), Towards a history of English as a history of genres (Heidelberg 2001) 159-182.
45. Erich Poppe, Beues of Hamtoun in Welsh bardic poetry, Cambrian Medieval Celtic Studies 43 (2002) 49-57.
46. Corinne Saunders, Desire, will and intention in Sir Beves of Hamtoun, in P. Hardman (ed.), The matter of identity in medieval Romance (Cambridge 2002) 29-42.
47. Erich Poppe, Codes of Conduct and Honour in Stair Bibuis. In: Michael Richter and Jean-Michel Picard (eds.) Ogma, essays in Celtic Studies in Honour of Próinséas Ní Chatháin. Dublin. 2002. 200–210.
**The edition used in the digital edition**2. **F. N. Robinson**, The Irish Lives of Guy of Warwick and Bevis of Hampton in Zeitschrift für Celtische Philologie. Volume 6, Halle/Saale, Max Niemeyer (1908) page 9-180; 273-338: 9-23; 105-180; 298-320

### Encoding


#### Project Description


CELT: Corpus of Electronic Texts


#### Editorial Declaration


##### Correction


Text proofread twice. Editorial corrections from p 337 are silently integrated into the electronic edition. Text supplied by the editor is tagged sup resp="FNR".


##### Normalization


The electronic text represents the edited text. Expansions are marked ex. Text supplied by the editor is marked sup resp="FNR". Editorial notes are tagged note type="auth" n="", or integrated into the markup. Text other than in English is indicated. The Irish version is available in a separate file.


##### Quotation


Direct speech is tagged q.


##### Hyphenation


Soft hyphens are silently removed. When a hyphenated word (hard or soft) crosses a page-break or line-break, this break is marked after the completion of the hyphenated word.


##### Segmentation


div0=the whole text; div1=the individual Life; page-breaks and paragraphs are marked. Passages in verse are marked by poem, stanza and line.


##### Standard Values


Dates are standardized in the ISO form yyyy-mm-dd.


##### Interpretation


Personal names, group and place names are not tagged.


#### Canonical References


This text uses the DIV1 element to represent the Life. ### Profile Description


Created: The English translation was created by F. N. Robinson. Date range: 1901-1907.#### Use of language


##### Language: EN


Text is in English.


##### Language: GA


Some words in Irish are contained in the Introduction and notes.


##### Language: LA


Some formulaic phrases are in Latin.


### Revision History


* (2005-03-02) Beatrix Färber (ed.)

* HTML file created.
* (2005-02-23) Beatrix Färber (ed.)

* Header modified and additions made to it; file parsed. Introduction and whole file proofed (2); more content markup applied; direct speech tagged.
* (2005-02-21) Benjamin Hazard (ed.)

* Editorial Introduction and the text of Guy proof-read (1) to p. 153; text of Bevis proof-read (1); structural and content markup applied throughout; addenda and corrigenda integrated; bibliography compiled; header created.
* (2005-02-11) Benjamin Hazard (Data capture.)

* Introduction and the text of the two Lives captured by scanning.




---


#### Corpus of Electronic Texts Edition: T306000


### The Irish Lives of Guy of Warwick and Bevis of Hampton: Author: [unknown]




---

p.9


### The Irish Lives of Guy Of Warwick and Bevis of Hampton.



> 1. 'Men speke of romances of prys,
>   
> Of Horn child and of Ypotys,
>   
> Of Bevis and Sir Gy.'
> 





Since the time of Chaucer's 'Rime of Sir Thopas', and earlier, the romantic heroes Sir Bevis of Hampton and Sir Guy of Warwick have been familiarly associated in English literature. It is not surprising, then, that the lives of the two should be found side by side in an Irish manuscript, and it is not inappropriate that they should appear together in the first printed edition of the Irish texts.


The only[1](javascript:footNote('T306000/note001.html')) existing copy of these texts, so far as I know, is that preserved in MS. H. 2. 7 in Trinity College Library, a vellum folio in various hands, probably of the fifteenth century.[2](javascript:footNote('T306000/note002.html')) A few passages from both romances were printed by Nettlau in the Revue Celtique 10, 187-191. The language, which was long ago characterised by O'Donovan as 'pure and of great value to





---

p.10




the Irish scholar',[3](javascript:footNote('T306000/note003.html')) can doubtless be dated with some definiteness when the verbal forms are fully tabulated and compared with those in other late Middle Irish texts. The Stair Fortibrais, a translation in similar style of which a copy exists in the same manuscript, is vaguely assigned by Dr. Stokes, its editor, to the fourteenth or fifteenth centuries.[4](javascript:footNote('T306000/note004.html')) The translation of John Mandeville, on the other hand, is distinctly stated in the manuscript to have been made by Fingin O'Mahoney in 1475,[5](javascript:footNote('T306000/note005.html')) and a comparison of the grammatical forms of all these pieces with it and with the translation of Marco Polo[6](javascript:footNote('T306000/note006.html')) ought to help in establishing a more precise date for them, and perhaps also to shed some light upon the question of their authorship. But the investigation of these matters cannot be satisfactorily completed while the greater part of the foreign romantic material in Irish, to which Nettlau called attention in his articles in the tenth volume of the Revue Celtique, still remains unpublished.


The exact sources of both the 'Guy' and the 'Bevis' are unknown, though there is good ground for believing that they go back to English originals, as was assumed long ago by O'Donovan[7](javascript:footNote('T306000/note007.html')) and O'Curry.[8](javascript:footNote('T306000/note008.html')) The principal evidence for this opinion is to be found in the proper names. Zimmer,[9](javascript:footNote('T306000/note009.html')) arguing from those in Nettlau's extracts, pointed this out, and an examination of the complete list practically places the matter beyond doubt. To be sure, many of the names are indecisive and might go back equally well to French or to English.




---

p.11


Others are so distorted — like Aimistir Amundae from Amis de la Mountagne — that it is difficult to draw conclusions from them. But a number of forms remain which it is easiest to explain by assuming an English intermediary between the Irish and the French. Thus Heront (Eront), from French Heraut (Heralt) is very likely to have got its n as a result of the errors of English scribes. Compare the way in which Rohand or Roband was made out of the French Rohaut (Rohalt) in some English versions of the story.[10](javascript:footNote('T306000/note010.html')) The Irish Uront shows the same development in the last syllable and apparently corresponds to Yorauld, a name which I have found in Copland's version alone. (The other English versions have Torold, and the Wolfenbüttel French text Corraud.) Pani (for French Pauie) and Gincadh (for French Guichard) both show the same transformation of u into n, and in these instances Copland's 'Guy' has forms with n (Pani and Gincharde). The Irish form Sision probably rests upon an English modification of Sessoigne.[11](javascript:footNote('T306000/note011.html')) Finally the constant use of 'Sir' in titles (Sir Gyi, Sir Heront) is plainly modelled on the English, and there are several instances where the English word 'kin'g ('Cing O Niubie', 'Cing Herrneis',' Cing Caulog') has been taken over intact into the Irish text. All these indications, the last of them practically decisive, point to an English source for the 'Guy'. In the Bevis fragment, which is much shorter, the evidence is not so clear. There is very little difference between the French and the English forms of the names, but where these disagree the Irish stands in every case nearer to the English unless it departs from both alike. The Irish name 'Babilon', too, for the country of Ybor's brother, may be due to the English 'Dabilent' (itself a corruption of French 'd'Abilen't).[12](javascript:footNote('T306000/note012.html')) So far as it goes, then, the testimony of the names in the 'Bevis' is consistent with that of the 'Guy'.




---

p.12


I have not attempted to draw any conclusion from the presence in both texts of a considerable number of loan-words, apparently from English. I have no doubt that words of English origin are more numerous because the author was working with an English romance. But it is obvious that they prove nothing decisively, for the Irish writer need not have taken them from his source. In fact all, or nearly all, of them occur in other texts. Sometimes, moreover, it is not easy to decide whether a word is of English or French origin. A critical study of the foreign elements in the Middle Irish vocabulary, ascertaining the sources of loan-words and the date of their introduction into the language, yet remains to be made.


An analysis of the contents of the Irish 'Guy' and 'Bevis' might be expected to lead much farther toward the determination of the sources. But it does little more than confirm the results already derived from the study of the proper names. Both romances differ in so many features from all the other versions I have seen that I must assume their immediate sources to be unknown. A brief statement, however, of their relations to their respective cycles is of interest, particularly in the case of the 'Guy'.


I have been unable to compare in detail the Irish 'Guy' with the French versions of the story, — since none of these has been published except in summaries or extracts.[13](javascript:footNote('T306000/note013.html')) But it is clear that none of the French texts of which I have suceeded in finding a description stands in any close relation to the Irish, and I have already shown it to be probable that the source of the latter was English. Of the English versions the most important are easily accessible. Zupitza has published metrical texts of the fourteenth and fifteenth centuries,[14](javascript:footNote('T306000/note014.html')) and I have





---

p.13




been able to compare with them the rare edition by William Copland of which the Harvard University Library possesses a copy. I have also examined Rowlands's poem[15](javascript:footNote('T306000/note015.html')) and several later chap-book versions.[16](javascript:footNote('T306000/note016.html')) The Middle English metrical versions, which agree with each other essentially in plot, stand closest to the Irish and I have made them the basis of my comparison. A brief statement with regard to the proper names and the principal incidents will show the relation they bear to the Irish.


More than two-thirds of the Irish names are either the natural equivalents of the English, or can be explained without difficulty as transformations of them.[17](javascript:footNote('T306000/note017.html')) There are seven substitutions,[18](javascript:footNote('T306000/note018.html')) and six names of new persons and places[19](javascript:footNote('T306000/note019.html')) occur without any equivalent in the English. These additions and substitutions are hardly to be regarded as the invention of the Irish author, but probably stood in his English source. Some of them are of special interest. 'Richard' in the place of 'Rohaut', the name of Guy's father, may have chronological significance, as I shall point out below. 'Cing Caulog',[20](javascript:footNote('T306000/note020.html')) who appears once in





---

p.14






the place of King Athelston, is probably King Havelok, the Danish leader (better known as Anlaf Cuaran), whose name became somehow confused with that of his English opponent. John de Alcino belongs in an episode which will be discussed a little later.


With respect to the narrative itself the Irish translation shows considerable independence. It contains every episode of importance in the English and has several additional incidents besides. Such are the fight between Guy and the duke of Lombardy (Chapter 4); the three days' tourney in Brittany (Chapter 5); and the tournament in Normandy (Chapter 7). In all these cases the English has nothing to correspond except general statements that Guy fought in Normandy, Brittany, France and Spain. In Chapter 8 the Irish relates a fight in the market-place at Bruidis, instead of which the English and French versions seem to have a tournament at Benevento. In Chapter 29 the Irish gives an account of a fight with a Turk, not paralleled in English. And in Chapter 34 there is a long discourse on Christian doctrine, not found in the English, concerning which I shall speak more particularly below. These chapters, I should add, are lacking not only in the Middle English romances but also in every other version of the story I have been able to consult.


With the few exceptions mentioned, six chapters out of forty-three, the general plot of the Irish romance agrees, incident for incident, with the Middle English. But there is hardly a paragraph in which there are not differences of detail. In chapter 1, for example, the account of Felice's skill in embroidery is peculiar to the Irish. The description of Siccard's rule is much fuller in the English. Nothing is said in the Irish of Guy's early training by Heront; and much is made of his piety and of the religious ceremonies at his knighting, both unmentioned in the English. In Guy's interviews with Felice





---

p.15






the English, which relates them much more fully, suggests that his proposals were improper, whereas the Irish makes no mention of 'folye'. And the conditions in Chapter 1 are by no means peculiar. I have noted similar variations in thirty-nine out of forty-five chapters. Sometimes they concern unimportant details; sometimes the plot in the Irish is manifestly improved; occasionally the Irish redaction confuses the story; and in a few cases appears to adjust it to the conventions of native tales. It is impossible to say how many of these modifications are deliberate changes on the part of the translator, but when all due allowance is made for his independence I think that many of the variations in plot as well as in the proper names must be attributed to his source.


Guy of Warwick was a mediaeval hero of the type of St. Alexis, and a principal feature of his story in all its forms is the desertion of his bride. All the versions, therefore, make a plea for religion and asceticism. But the Irish, as compared with the English, is particularly insistent on works of piety and charity. This has already been pointed out for Chapter 1. Again in Chapter 39 the pious deeds of Felice are described in Irish, but not in the corresponding portion of the English. In Chapters 19 and 35 the Irish makes special mention of prayers of which the English says nothing. But the most conspicuous addition of a religious nature is Chapter 34, which is otherwise of special interest. When Guy is overcome by remorse for his sins and decides to abandon Felice, the Irish romance alone represents him as seeking spiritual counsel and obtaining instruction in Christian doctrine. He sends for a holy father, John de Alcino, to whom he confesses his sins and by whom he is exhorted to keep the commandments, to avoid the eight[21](javascript:footNote('T306000/note021.html')) mortal sins, to emulate the sufferings of the saints, and to believe in all the articles of the Apostles' Creed. The name of the confessor, John de Alcino, furnishes a clue to the source of this theological chapter. It is a condensation of part of the material





---

p.16




 

found in the Middle English 'Speculum Gy de Warewyke',[22](javascript:footNote('T306000/note022.html')) which rests in turn upon the 'Liber de Virtutibus et Vitiis'[23](javascript:footNote('T306000/note023.html')) of Alcuin. This moral treatise was originally written by Alcuin for a different Guy, Count Guido of Tours, a celebrated military leader under Charlemagne. But as early as the beginning of the thirteenth century it had become attached in England to

Guy of Warwick, who is named as the recipient of the advice in the Auchinleck MS., the earliest copy of the 'Speculum'. On the other hand, in the romance of Guy contained in the same manuscript there is no reference to Alcuin or to the sermon, and I have not found the episode in any version except the Irish. The Irish redactor either made the combination himself, or had before him a romance into which the substance of the 'Speculum' had been woven. The latter of these suppositions appears to me the more probable. There is nothing else in the Irish text to indicate that the author compiled his work from different sources, and the combination in question would have been more naturally made by an Englishman than by a foreigner.


A number of lost versions may intervene between the Irish 'Guy' and the known Middle English texts, and the 'Speculum' may have been several times abridged in the course of transmission. Or the source of the Irish chapter may have been derived in some other way from the 'Liber' of Alcuin. As it stands, it is much shorter than the 'Speculum' and does not agree with that closely in the arrangement of material. But the three principal elements in the Irish are to be found in the English poem. For the list of deadly sins see the 'Speculum'

ll. 107 ff.; for a description of the sufferings of the saints, ll. 176 ff.; and for an exposition of portions of the Creed, ll. 200 ff.


Thus the Irish life of Guy makes probable the existence of an English romance which differed in one important feature, and may have departed in many details, from the known English versions of the story. As to the date of the assumed English original, a lower limit can perhaps be established by the grammatical analysis of the Irish text. Beyond this the Irish supplies another bit of possible evidence. The name of Guy's





---

p.17






father-in-law, as I have already pointed out, is changed from Rohalt (Rohaut, Rohand) to Risderd. The reasons for the substitution are entirely unknown, but it might have arisen from confusion with the name of a living Richard, Earl of Warwick, or from a deliberate purpose of complimenting him. There were two Earls of Warwick of that name in the fifteenth century.[24](javascript:footNote('T306000/note024.html')) Richard de Beauchamp, who was born in 1382, was Earl from 1410 till his death in 1439, and Richard Neville (the kingmaker), born in 1428, obtained the title by marriage in 1449, and died in 1471. As between the two, I think the general probabilities of date are in favor of the earlier. Moreover Beauchamp, we are told,[25](javascript:footNote('T306000/note025.html')) travelling in the Holy Land in 1410, was feasted and given presents by the Lieutenant of the Soldan because of his supposed descent from Guy. In 1422 he endowed the chantry at Guy's Cliff. In view of his active interest in the romantic tradition of the house of Warwick it is quite conceivable that his Christian name may have got into some contemporary version of the story.


The Irish Bevis is only a fragment, though a rather long one. The comparison of its contents with other versions of the story is made easy by Köbing's edition[26](javascript:footNote('T306000/note026.html')) of the Middle English texts and Stimming's edition[27](javascript:footNote('T306000/note027.html')) of the Anglo-French. Both editors discuss the relations of the French, the English, the Welsh and the Norse red actions.[28](javascript:footNote('T306000/note028.html')) Besides these mediaeval versions I have also examined an English chap-book Bevis, probably' of the year 1680.[29](javascript:footNote('T306000/note029.html'))


When compared with the French and English romances the Irish Bevis shows less new material than the Guy. It

 



---

p.18






contains no incident of importance not to be found in both the Middle English and the Anglo-French. But in the matter of minor variations it stands in about the same relation to them that the Guy bears to the texts with which I have compared it. Out of 22 names[30](javascript:footNote('T306000/note030.html')) of persons and places, 17 are the natural equivalents of those in the Middle English, 4 are explicable[31](javascript:footNote('T306000/note031.html')) as modifications of the English, and only two (that of Para, the son of the Emperor, and that of Biroig,[32](javascript:footNote('T306000/note032.html')) a stream on the borders of Scotland) are new. A comparison of the narratives shows constant variation in details. According to the Irish, Bevis's mother is in love with the son of the Emperor; and according to the Middle English and the French, with the Emperor himself. (In the chap-book of 1680 it is the Emperor's brother.) In the Irish account, her determination to marry her lover is awakened by seeing her own beauty in a bath. No such situation is mentioned in the French or the English. In both the French and the English the little Bevis is set to tend sheep, not swine; and there is no conversation parallel to that by which in the Irish version he is impelled to avenge his father's murder. In chapter 8 the Irish represents Bevis as journeying to India and Rhodes, while the Middle English takes him to Jerusalem, and the French to Jerusalem and Egypt. (The chap-book has no eastern travels at this point.) The episode of Sisian and Yvor in chapter 9 is introduced considerably earlier in the English and the French (and in the chap-book as well). The dragon-fight in chapter 11 contains some vivid details about four waves of vomit which are very likely the Irish redactor's own invention. From most of these features of the Irish narrative I am led to conclude that it had its source in a lost version. That this was probably English I infer from the





---

p.19






proper names, as already pointed out, and also from the fact that where the French and English versions differ with regard to the details of the story, the Irish, if it does not depart from both usually resembles the English.[33](javascript:footNote('T306000/note033.html')) In a few cases where the Irish agrees with the French as against the Middle English metrical versions the English prose version of 1680 is like the Irish.


The result, then, of this comparison of both the Guy and the Bevis with the corresponding stories in other languages is to make it probable that the Irish lives are free redactions of lost English versions. The assumed original of the Bevis appears not to have differed in any important particulars from the other existing forms of the story. In the case of the Guy, on the other hand, the Irish text points to the existence in English of a combination, hitherto unknown, of the romantic material proper with the religious material, originally distinct, of the 'Speculum Gy de Warewyke'.


Stylistically regarded, the Irish texts are clearly very free renderings of their originals. Though the number of foreign words in them may be somewhat larger because of their foreign sources, the manner of the narrative is thoroughly Irish, and they read in general like the native stories in the somewhat ornate prose of the period. The accumulation of adjectives and adverbs, often in alliterating groups of three, is characteristic of late Middle Irish, and the Guy and Bevis are by no means extreme examples of the practice. In this matter, and in the general structure of sentences, I have adhered in my translation very closely to the original, though the traditions of English prose are so different from those of Irish that the





---

p.20






resulting style will sound sometimes monotonous, and sometimes redundant and artificial. 


 It is now nine years since I first copied and collated these texts at Dublin. During the interval I have profited several times by the courtesy and liberality of the Librarian and staff of Trinity College, and I now desire to express my grateful acknowledgements. I am also under much obligation to both the editors of the Zeitschrift for reading my proofs and giving me the benefit of their counsel. Wherever it is possible, particular acknowledgment will be made of their suggestions and corrections.


Additional Note


Since only one manuscript of these romances is known to me, I have simply tried to print its readings as accurately as possible. Obvious errors or omissions are occasionally corrected in the text or in foot-notes in order that the narrative may be readable. A certain amount of normalization is also involved in the punctuation and the separation of words and the expansion of contractions. But I have made no attempt to correct the grammar or orthography of the scribe. His errors and in consistencies, for example, in initial mutations and in the general treatment of spirants have all been allowed to stand.


In the form in which my text was sent to press all expanded contractions were indicated by italics, so that the reading of the manuscript could be instantly ascertained in every case from the printed page. But out of regard for the strong preference of Professor Stern I have abandoned that plan and used italics only in cases which are in some respect doubtful or exceptional. The typographical appearance of the text is much improved by the change, and I think there has been no loss in accuracy. The work of the editor, however, has become less easy to control, and it is important for me to make an exact statement of the method I have pursued and the liberties I have allowed myself. Short specimens of the text with all the





---

p.21






abbreviations indicated are furnished by the passages which Nettlau printed in the Revue Celtique 10, 187 ff.


I have silently expanded all the ordinary **compendia scribendi** unless their use appeared to be a given case irregular. The scribe freely employed the signs for *acht (cht, sed), air, ar cet, con, cu, er, (ir), est, et (ed), eth (edh), m, n, nem, or, ra, re, ri, ro, ru, uath, ur, us*; and certain extensions of their use are also so common in the manuscript that have adopted them without resorting to italics. Thus the sign for *ur* clearly means sometimes 'r' (as in 'anoir', 'senoir') and often 'uir' (as in 'docuir' 3 sg. pret.), though in a few cases the latter combination is indicated by an i with the sign for *ur* above it. The sign for *us* also sometimes stands for 'uis'. I have inserted the i in cases where its omission would be grammatically misleading (as in 'romarbuis', 2 sg. pret., or 'fochtuis', 3 sg. pret. absol.), but I have allowed spellings like 'eglus, fiadhnuse', to stand, since the scribe does not consistently observe the principle of **caol le caol** when he spells out words in full. In the same way I have some times expanded the sign for *er* as 'eir' (cf. dobeir, 3 sg. pres., of frequent occurrence), but I have left forms like derc, serc (dat. and acc.) without trying to introduce uniform indication of the i-infection. The abbreviation for *eth* occurs a number of times in the ending of the preterite passive where I have expanded it as edh (docuiredh).


Besides silently expanding the abbreviations which stand for definite letters, I have also made no use of italics in supplying obvious vowels before b, c, d, g, written above the line ; and in cases where there could be no doubt about the construction I have added the endings of nouns and adjectives in -ach, -ech (-aigh, -igh), of preterites in -aigh, -igh, and of preterite passives and verbal nouns. All these are frequently indicated by a simple dash. In the case of verbal nouns in -dh and of preterite passives two abbreviations are usual with the scribe, — a dash (rofer-), and a d above the line ('rofoerd'). For the former cases I have used the spirant 'dh', and for the latter the unaspirated 'd'. Both forms occur in words which the scribe has spelled out in full, and the distinction between them was of no importance.


In addition to the contractions thus far provided for, there are a considerable number of words habitually abbreviated by





---

p.22






the scribe in accordance with the practice of Middle Irish manuscripts. Those which occur oftenest, and about which there can be no real doubt, I have expanded without italics, using the grammatical form required by the context. A list of them is given here. In all other words italics are used unless the manuscript abbreviations represent definite letters or the syllables provided for above.


1. Many proper names, such as *S.* G. o B., Sir Gyi o Berbuic; *S.* B., Sir Bibus.
2. Numerals.
1. adbert, adubairt, adubradar,
2. adbul
3. alludh
4. amach
5. amail (and its compounds)
6. amlaidh
7. archena
8. ata
9. athair
10. bliadain
11. briathar
12. cath
13. cathair
14. cloidhem
15. Crist, Cristaidhe
16. cubaidh
17. diablaidhe
18. didiu
19. diuice
20. dono
21. dochum
22. dun ad
23. esbaid
24. espoc
25. fledh
26. focal
27. gach
28. gabail (and its compounds)
29. galar
30. iarum
31. immorro
32. ingen
33. inbaid
34. itir
35. mac
36. mathair
37. menma
38. menmarc
39. minic
40. mullach
41. nach
42. nech
43. nert
44. no
45. scel
46. senoir
47. slan, slainte
48. slegh
49. slighe
50. sluagh
51. sochraite
52. spirut
53. tabairt
54. talam
55. tapaidh
56. ullam
57. uisce




---

p.23


In the matter of accents I have endeavored to follow the manuscript disregarding those, however, which obviously do not mean quantity but serve only to distinguish the letter i. Probably some of the scribe's accents have been overlooked because of their faintness, but I have not intentionally inserted any of my own. I ought to explain that Professor Stern would have preferred the consistent marking of all long vowels, but I did not wish to go quite so far in the normalization of the text. I am therefore alone responsible for the method adopted. In some other respects, too, my text follows the manuscript rather than the usual practice of modern Irish writers. The preterital prefixes do and ro, for example, I have regularly combined with their verbs, and certain enclitics which are commonly written separately I have set off by hyphens. These are not matters of importance. I cannot claim theoretic consistency in my use of hyphens, but I hope none of them will prove misleading. My general purpose has been to adhere closely to the manuscript, and at the same time to make the printed text easily intelligible.


There are of course endless opportunities for error in reproducing a text of such irregular orthography, and I regret that I cannot compare the proofs with the original. But in order to make the mistakes as few as possible I had the manuscript photographed after copying and collating it.


In the Glossary I have meant to register only such words as are not fully accounted for in Windisch's Wörterbuch. Both there and in the foot-notes references by number and letter (306a, 315b, etc.) are to the pages and columns of the manuscript, which are indicated in the Irish text. Some of the footnotes which accompany the translation will be found to contain comment of a textual nature. I expected at first to have the Irish and English printed on opposite pages, but that method proved to be too wasteful of space.


The Cranberry Isles, Maine, U.S.A. Autumn 1905. F. N. Robinson.


---

p.105


The Irish Life of Guy of Warwick
--------------------------------


#### 1


{Ir. ed. page 24}There was an exceedingly rich earl in England whose name was Richard of Warwick, and he had two earldoms, namely Warwick and Buckingham, and a rich and well-born man was the earl with an abundance of all good things. He had a comely and beautiful daughter worthy of himself, Felice by name, and there was not in her time a woman who was better in form and figure, in handiwork and knowledge, in embroidery and noble manners,[34](javascript:footNote('T306000/note034.html')) than that maiden. A great teacher was set to instruct her in the gentle arts, and it was not long afterwards that she surpassed[35](javascript:footNote('T306000/note035.html')) her master in every art, so that the master gave her the rod[36](javascript:footNote('T306000/note036.html')) of his instruction after being outstripped by her in every kind of knowledge even at the end of her seventeenth year. Her fair fame spread throughout all the world for knowledge, dignity and honor, for piety, gentleness and discretion, for purity, wisdom and prudence, until the princes and nobles of the whole earth were filled with love and longing for her. Now there was at that time a steward, noble and honorable, in the service of the Earl of





---

p.106






Warwick, Siccard by name, and he was a strong man and very brave, winning victory and fame in every exploit that it was suitable for anyone to engage in. If the earl was alone, he had no fear of host or army, provided only that noble baron were there to defend him. It was he that collected the taxes and imposts[37](javascript:footNote('T306000/note037.html')) for the earl; and if there were any who made complaint or resistance[38](javascript:footNote('T306000/note038.html')) to him about the taxes of the earl, he would impose upon them expulsion and banishment from his realm.


That steward had a son worthy of himself, Guy by name; and he surpassed all the young men of his time in size, beauty and gentleness, in courtesy, strength and prowess, in pride, spirit and courage, so that the whole country and the neighbouring provinces were full of his fame and his praise. And everywhere that Guy heard of games at fair or festival or assembly throughout the length and breadth of the free and noble English land, he entered them and won the victory of every company, surpassing all,[39](javascript:footNote('T306000/note039.html')) and defeated the men utterly at every kind of feat.[40](javascript:footNote('T306000/note040.html')) And he gave alms and frequent offerings[41](javascript:footNote('T306000/note041.html')) to the churches, and gave {Ir. ed. page 25} gifts and clothing to God's poor,[42](javascript:footNote('T306000/note042.html')) and buried the dead without murmur and without negligence, and visited the people who were in prison and in bonds, and performed all the works of mercy which the church praised in his time, and he was strong and zealous in the Catholic faith. The Earl of Warwick made Guy a squire at that time.


It was then that a Whitsuntide banquet and feast was prepared for the Earl of Warwick, and he assembled the nobles of his retinue to partake of it. The earl summoned Guy to him, and made him welcome, and said: ‘Guy’, said he, ‘I assign to thee the office of serving and attending Felice throughout this feast which we are celebrating; do it with good cheer and with love.’ Guy answered: ‘My lord’, said he, ‘I will do my best for the noble lady.’[43](javascript:footNote('T306000/note043.html')) As for Guy, then, he put a shirt of thin satin next the brightness of his white skin and a wonderful tunic of gold thread and a fine, scarlet gown outside of it; and in that splendor he went to the maiden's bower, and blessed her (i. e. greeted her with a blessing), and fell on his knees in her presence, and told her that it was to him had been assigned the duty of serving her and her attendant





---

p.107






women. Felice asked for an account of him, who he was and what was his country and race. Guy said, ‘I am the son of a noble baron of thy father's retinue, and my father is steward and marshall of the house to the Earl of Warwick; and my name is Guy’, said he. ‘I have heard of thy repute and thy noble manners’, said the maiden, ‘and thou art welcome[44](javascript:footNote('T306000/note044.html')) to my attendance and service.’


The lady arose, and washed and adorned her face and shining countenance, and her women did the same. As for Guy, then, he dispensed fresh food and old ale without restraint to the lady and her attendants for the space of three days and three nights, till Felice and her women were grateful and blessed Guy for the service he had given them throughout the length of this feast. And the women conceived a very strong love for Guy because of his deeds; and Guy conceived an ardent, unendurable love for the lady, so that he was fierce, drunken and mad by reason of love and great longing for her.


As for Guy, then, he made his obeisance and his humble submission before the lady, and thereupon took leave of her, and went to his chamber; and he was in sickness and heavy affliction there, and his people asked what ailed him. Guy said that he did not know what ailed him, — ‘and it seems to me’, said he, ‘that death is near to me’; and it was reported throughout all the town that Guy was dangerously ill, and much grief did that cause to everyone. The earl, moreover, sent {Ir. ed. page 26} a very skillful physician to Guy, and he asked what ailed him. Guy said it was fiery heat, heavy and strong, and cold, severe and very grievous. The physician said that it was fever with [*...*][45](javascript:footNote('T306000/note045.html')) that was upon him. A fortnight was Guy thus without company, without cheer, without pleasure. And at the end of that time Guy went directly to Felice, and paid her respect and honor, and said: ‘O gentle maiden of the black eyebrows, and O fair damsel of many beauties’, said he, ‘grant me help full truly and faithfully in the honor of the Trinity, for I know no secret or rule to cure my sickness now; for the fulness of it is upon my body and my frame by love and long affection for thee kindled and set on fire; and my life will not be long without decease and everlasting death, unless I obtain from thee the return of my love, O noble lady’, said he. Felice answered: ‘It is shameless, foolish impertinence that thou dost begin to utter, Guy’, said she, ‘for heavy is the insult and the disgrace thou hast put upon me in seeking me for thy wife with thy soft, shameless words. For there is no son of a high king, or duke, strong and very brave, or noble, honored earl,





---

p.108






or rich, landed chieftain in the west of Europe, that has not conceived a great love for me, — as many of them as are in unmarried and single state; and I have not granted the return of his love to any man of them; and it is improper for thee my servant and attendant, to think of taking me as wife.’ Felice said: ‘O Guy’, said she, ‘leave me instantly; and it shall be upon pain of thy life, if thou return where I am until the time of thy death.’ Then Guy went to his chamber, and the increase of his disease and his sickness, lasting and grievous grew upon him because of the answer of the fair woman; and he was lamenting and complaining and defying death, for he preferred death to life; and he was reproaching and reviling love. It was then that Guy looked at the strong tower of stone where the lady was, and said sorrowfully and piteously: ‘It is fair for thee, tower’, said he, ‘if only thou hadst reason, for fair is the sight that is within thee; and it is sad that I cannot get a glimpse of her with my eye.’


The noble baron, Guy's father, was sad because Guy was in such danger, and so likewise was his mother. And as for the Earl of Warwick, he himself and all his company were full of grief and sorrow because Guy was sick. One day, then, Guy said in lamentation: ‘I shall soon get my death from the sharpness of my love for the lady, {Ir. ed. page 27} if I remain long in this state; and I will rather meet death at the earl's hands after beholding his daughter, than be killed by love.’ Then Guy went to the tower where the lady was, and gazed upon her, and fell straightway unconscious; and he rose quickly from his swoon, and no one observed him in that state. And it was reported to Guy that the lady was in a secret arbor beside the tower,[46](javascript:footNote('T306000/note046.html')) and Guy went into the arbor, and knelt at the lady's feet, and begged her favor. And Guy said: ‘I have come to thee, lady’, said he, ‘against thy command, and I have deserved to receive death, and have thou mercy upon me.’ The lady refused him, and threatened him, and said: ‘If the earl were to hear that speech, Guy’, said she, ‘he would put thee to death.’ When Guy heard that he fell in a swoon and a fainting fit, and there never would have come to burial anyone who was fairer in form and countenance than he (?).[47](javascript:footNote('T306000/note047.html')) The woman who attended upon the earl's daughter said: ‘It is a pity, my lady’, said she, ‘for it is cruel, hard and merciless thou art with the gentle, kindly squire. And I gave my word’, said she, ‘if I were the daughter of the emperor, and the high kingdom of the world in my power, I would not leave him there to get his death from love of me without the succor of gentle, sweet-sounding words.’ Felice answered the girl:





---

p.109






‘Raise Guy’, said she, ‘to a sitting-posture, and support him against thy bosom and thy shoulder.’ And the damsel did so. And Guy rose then from his swoon, and again addressed the lady; and she refused him, and threatened him on her father's part, and told him that he would meet his death because he had addressed her. Guy said: ‘Lady’ said he, ‘it is in thy power to put me to death, justly or unjustly, for it is from thee that I choose to receive death’, said he. And he fell in a collapse and a heavy swoon after these words. The lady seized him by the hand and said: ‘O Guy’, said she, ‘I will not give my love to any man except to a knight surpassing in form and in fair figure, surpassing in speech and eloquence, surpassing in honor and wisdom, surpassing in deeds and in feats of war. And if there were anyone like that, I would give myself to him.’


Sweet were these words to Guy, and he quickly left the arbor, and went to his chamber, and put on his accoutrements for the journey and the assembly, and went where the Earl {Ir. ed. page 28} of Warwick was, and he was made welcome there. Guy said: ‘Gracious lord’, said he, ‘every good deed that I have ever done, it is for thee that I have done it, and every good deed that I shall do, it is for thee that I shall be pleased to do it; and do thou now give me the order of knighthood.’ The earl said: ‘I will give it to thee with good heart, and a great present besides.’ And then the earl made a knight of Guy after hearing mass on the Sunday of the Holy Spirit, and twenty were raised that day to the rank of knighthood as an honor to Guy. And the earl with his company prayed the one God who made heaven and earth that the choicest gift of grace and of knighthood should be upon Guy. It was then that Sir Guy, full of joy and love, went in his knightly armor to the daughter of the earl, and showed himself to her, and said: ‘Lady’, said he, ‘understand that until now I have been in great suffering and doubt because of my love for thee, and it is for thee that I have taken upon me the order of knighthood.’ Felice said: ‘Rejoice not in being a knight in the hope of winning my love, for it is a young knight thou art without proof yet of bravery or deeds of arms. And if thou prove thy strength, both near and far, in battles and in conflicts, then I will do thy will.’ Guy thanked the lady for these answers, and went afterwards to his father and mother, and told them that he had taken order of knighthood — ‘and I shall set out to make a circuit of lands and peoples to prove my strength and my bravery.’


The baron said: ‘Our blessing upon thy adventure and thy success’, said he; and his mother said the same. And thereupon Sicart called to him Sir Eront a brave victorious knight, and Sir Uront and Sir Uri and told them to be ‘three strong, brave picked men, and three pillars, manly and truly courageous, about Sir Guy to keep and protect him in the distant foreign lands in which he plans to go; and guard





---

p.110






him well.’[48](javascript:footNote('T306000/note048.html')) And they took it upon themselves to do their best for him. The noble baron put a full supply of food and drink into the ship with them. Thus far the illness and peril of Sir Guy of Warwick for love of the daughter of the earl et reliqua.


#### 2


As for Sir Guy, then, he went into his ship with his three knights, and they pulled an eager, strong, swift-bounding stroke[49](javascript:footNote('T306000/note049.html')) on the old sea, and reached a safe, well-sheltered harbor in Normandy. And afterwards they came to a great city of Normandy, {Ir. ed. page 29} and they found a hostelry for the night there and partook of food and drink. And Guy said to the inn-keeper; ‘I have seen breastplates being rolled (?)[50](javascript:footNote('T306000/note050.html')) and spears being polished, and swords burnished, and shields put in order, and shoes put on chargers and fine horses, and saddles made firm, and daggers sharpened, and all the accoutrements of battle being made ready, and I do not know what is the reason for it.’ The innkeeper said: ‘The emperor has a fair, unmarried daughter, and she will be pleased with no man but him who bears the palm of valor and deeds of arms in the whole world; and the emperor believes that there are not ten valiant knights in the world whom he could not conquer singly. And now the sons of the king of Spain, and of Africa, and of Greece, of France, of Sicily, of Hungary, of Fuardacht, and of Deolann (?)[51](javascript:footNote('T306000/note051.html')) and of the four tribes of Lochlann, and of all the world besides, have come to the city of the Emperor to this jousting; and it is to go against him that the hardy warriors of this city are preparing their arms and their many weapons. Whoever wins the victory in this tournament, he is to receive two shining white falcons, and two steeds with long manes,[52](javascript:footNote('T306000/note052.html')) and two very keen hunting-dogs of the same color, and the noble, famous princess, the emperor's daughter, to wife, and the heritage of the emperor after his death.’


 Now Guy gave a steed, stout and very strong, to the keeper of the house as a reward for his information, and bade his followers be of spirit and good courage, and said they would go to the castle of the emperor to see the fighting and the hard conflict. Thus far the course of Sir Guy in Normandy.


#### 3


As for Sir Guy, on the morning of the next day he set out with his three knights, and he did not stop or delay until





---

p.111






he came to the emperor's castle. And he saw the host on the green, and a single knight, bold and valiant, in his strong trappings of battle on the field of the racing and the jousting; and Sir Guy asked for an account of that knight. And he[53](javascript:footNote('T306000/note053.html')) said: ‘That is one of the sons of the emperor, and he expects to find no man who can overcome him in battle or in conflict, and his name is Sir Gayer.’ When Guy heard that, he went resolutely[54](javascript:footNote('T306000/note054.html')) to meet him, and they fought a fight, bloody and most virulent, for a space and a while, and Sir Gayer sent a spear through Sir Guy's shield and breast plate, and the spear came out, and did no harm to his body; and Sir Guy dealt the Emperor's son a blow vigorous and powerful, and smote him three {Ir. ed. page 30} paces from his saddle, and took his horse from him, and gave it to the squire who was with him. Then came Otun, Duke of Pani,[55](javascript:footNote('T306000/note055.html')) fiercely and very bravely to fight with Guy, and Sir Guy sent a spear through his shield and his shoulder-blade, and threw him to the ground, and took his horse from him. The own brother of Duke Otun's father came proudly[56](javascript:footNote('T306000/note056.html')) and valiantly to the place of battle, and angrily said: ‘Thou hast killed my brother's son’, said he, ‘and evil is the injury, and thou thyself art the compensation.’ And Sir Guy went to meet him, and the duke was thrown to the ground by Sir Guy, and Sir Guy seized his horse by the bridle; and when the duke rose from his swoon, Sir Guy gave him his own horse. And Sir Guy said: ‘Thank me, Duke Rener’, said he, ‘for giving it to thee (?),[57](javascript:footNote('T306000/note057.html')) for it was not to kill men that I came here, but to put them in bonds and fetters without killing them.’ Then Duke Rener mounted his steed, and said: ‘Brave and valiant knight, tell us thy country.’ Sir Guy said: ‘I am from the free and noble land of the English; and Sir Guy of Warwick is my name and title and description among the free and noble hosts of the English.’ Then came Duke Anan to meet Guy, and they waged against each other a fierce, mad fight and the grass was torn and bloody in very truth from this struggle.[58](javascript:footNote('T306000/note058.html')) When Sir Eront saw this, he came to the help of Sir Guy against that attack, and gave the duke a strong, mighty





---

p.112






blow, so that he drove a spear through his shield and through his heart, and the Duke fell dead and lifeless.


Duke Vadiner came against Guy, and a broad-trenched shining,[59](javascript:footNote('T306000/note059.html')) hard sword in his hand, and threatened Guy with instant death. Then Guy went eagerly and swiftly to meet the duke, and they fought a brave, hard fight for a long time; and there came bold, eager hosts of lords and high nobles of the army to the help of Duke Vadiner against Sir Guy. When Sir Heront saw this, and the two other spirited, valiant knights Sir Turont and Sir Uri, they came [*...*][60](javascript:footNote('T306000/note060.html')) brave, manlike and heroic, about Sir Guy to protect him from the arms of his foes. They fought with each other a battle, fierce, bloody and very deadly, till it was not thinly the plain was sown with men laid low by the fierce, eager strokes of Guy and his three knights; and many there were who fell on that day at the hands of those four, and especially at the hands of Guy. {Ir. ed. page 31} And this is the number that is remembered,[61](javascript:footNote('T306000/note061.html')) namely six hundred knights who fell in the fight that day at Guy's hands alone. Then the hosts fled in every direction for fear of Sir Guy, and the plain was left clear before him, and battle and combat was refused him.


Sir Guy with his followers thereupon went into the city, and they found a hostelry there; and Sir Guy took off his armor, and on his body were wounds, wide and very deep. Then the emperor came into his court, and said in the presence of the host: ‘The strong, brave English knight has overcome us all, and there is no man in the world equal to him in combat. And let messengers be sent to him — namely, to Guy of Warwick with the prizes that were promised to the man who should win the tournament.’ Then a squire was sent with the prizes to Sir Guy, and gave them to him: two very beautiful falcons, and two brave, noble hounds, and two steeds with long manes and arching necks; and those six treasures were all of one color, the color of a beautiful swan. And the squire who brought them gave Sir Guy a very fair greeting, and said: ‘May the true God, the excellent, make broad *thy way* before thee in every strait and every difficulty in which thou mayst be, for the courts and cities of the whole world are full of the reports of thy deed and of thy bravery. And Bloinsiflugar, the daughter of the 





---

p.113






emperor sends thee life and health, and thou art her choice of husband, if thou hast not a gentle wife before her.’ Sir Guy gave thanks to the gracious and very noble lady for her gift and her offer, and proposed to make a knight of the squire who came with the gifts from the daughter of the emperor; and the squire refused this, for he said he had not reached the age to receive rank and presents. Sir Guy gave the squire gold and silver without deficiency and after that he left him.


As for Sir Guy, then, he sent messengers with those gifts to England to the Earl of Warwick, and they were given to him; and the messengers spread tales of the perilous and terrible *doings* of Guy from the time when he left England until that hour, and the tales put pride and high spirit into the earl and his company. And the king of England and the nobles of his great household rejoiced at the brave achievements of Guy, when they heard those stories. Thus far Sir Guy's first deed of bravery after leaving England.


#### 4


{Ir. ed. page 32} As for Sir Guy, then, he went to the broad, fair land of France and to the strong, brave land of Lombardy, and he found plenty of fighting and hard battle in those lands, and he wrought destruction among them, and it was not possible to count the number that fell at Guy's hands in those lands; and he obtained plenty of gold and silver and many jewels in those great countries.


And Sir Guy fought a battle after this with the Duke of Lombardy, and defeated him[62](javascript:footNote('T306000/note062.html')) mightily and cruelly, and slew his men, and he was twelve weeks from one month's beginning to another[63](javascript:footNote('T306000/note063.html')) cutting down and killing the Lombards, and he took from them their gold and their treasure and all their possessions. Then Sir Guy saw ten hundred brave and valiant knights of the Lombards coming against them, and strong battle armor upon them, and one knight of great spirit and courage in front of them, and a skittish, prancing horse beneath him. He said to Guy angrily and fiercely: ‘Violent[64](javascript:footNote('T306000/note064.html')) and wicked knight, let us have a share in thy bravery and prowess, and give us part of the spoils of the Lombard land.’ Sir Guy said: ‘Thou shalt have a share of my spoils and my booty’, said he, ‘if thou art asking it in friendliness and courtesy; but if it is in threat and in ill-nature that thou saidst those words, thou shalt have death





---

p.114






and destruction at once.’ It is thus the knight was *armed*: slender, long spear in one hand, and a short, strange (?) jousting spear in the other.[65](javascript:footNote('T306000/note065.html')) And they spurred their horses one against the other, and Sir Guy passed under the long, sharp-bladed spear which the knight had, and put a spear through his side and held him fast[66](javascript:footNote('T306000/note066.html')) on the spear. Sir Guy leaped down, and seized the knight, and said to him: ‘Ask mercy now, or thou shalt get instant death.’ Then the knight uttered a threat and made light of Guy's words. And the knight blew a fierce, mighty blast on the end of the horn that was under his neck, and his followers came to him. Sir Guy said: ‘I understand, knight, that thou art a traitor and a fratricide’, said he, ‘and now defend thyself.’ He spoke thus, and bared his sword, broad-trenched and decorated,[67](javascript:footNote('T306000/note067.html')) and struck the knight a strong, bold blow, so that he drove the sword mightily through his heart, and the knight fell down dead, without life. The other ten hundred brave knights came on the field at the call of the horn, and they fought a hard, fierce fight with one another, and five hundred of them fell at Guy's hand before mid-day, and two hundred more fell {Ir. ed. page 33} after mid-day, and two hundred made off at full speed of their horses. Thus far the destruction of the Lombards by Guy.


#### 5


As for *Guy*, then, [*...*] and went to the land of Britanny; and there was an earl in Britanny whose name was Earl Birri,[68](javascript:footNote('T306000/note068.html')) and he had a fair, unmarried daughter, and she wished no one for husband but the choice of the warriors of the whole world. And the earl proclaimed[69](javascript:footNote('T306000/note069.html')) a tournament of three days to be held by the brave knights of the world for his daughter; and three hundred bold, warlike French knights were coming to this tournament.


As for Sir Guy, now, he maimed and wounded six hundred strong, valiant knights full readily on the first day, some of them on horses and some on foot. Then on the second day Sir Guy came to the tournament, and no man answered him *(i. e. accepted his challenge)*, and some of them said: ‘He is the knight who slew *six hundred* warriors in Lombardy in a single day.’ And they began to recount and to praise his deed and





---

p.115






bravery and they all refused to fight with Sir Guy on that day. And on the third day Sir Guy came to the tournament, and challenged all the hosts before him to fight with him; and they all refused him, and set out thereafter for their own castles. As for the Earl of Birri, moreover, he sent messengers to Sir Guy with two horses, pure white and swift in action; and he offered Guy his daughter as wife with all his possessions besides; and he said there was no man in the whole world whom he would rather have marry his daughter than Sir Guy. Sir Guy thanked the earl for the honor of his offer, but he refused the maiden for the sake of the daughter of the Earl of Warwick; and he said that in recognition of his offer he would serve the earl's profit and advantage in every difficulty he might be in. And Guy gave forty nobles of red gold to the messenger of the earl. Thus far the course of Sir Guy of Warwick in the mighty land of Britanny, et reliqua.


#### 6


As for Guy, then, he returned to England, and went to the king; and the king and the nobles gave Guy a very fair welcome because of the greatness of his fame and honor in the distant lands where he had gone. Then the King of England gave Guy gold and silver and every treasure besides. After this Sir Guy went to the Earl {Ir. ed. page 34} of Warwick, and the earl with his followers paid honor to Sir Guy. And thereupon Sir Guy went to the beautiful bower of Felice, and said to her: ‘I have done many deeds of bravery and prowess for love of thee, lady, and in thy honor’, said he, ‘and now fulfil thy promise to me.’ ‘If I should do that’, said she, ‘thou wouldst do no more fair deeds of valor and of bravery; and in truth thou shalt never be my husband unless thou win the prize of bravery and prowess from the knights of the whole world.’ Sir Guy said: ‘It is not likely that I should win that prize’, said he, ‘for there are many brave knights of good renown in the world, and it is hard to win the prize. Yet I will fall before them or conquer them.’ Then he went to his father and mother, and took leave of them, and both young and old were sorrowing after him. Thus far Guy's course in England.


#### 7


As for Sir Guy after this, he went on to Normandy. And the King of France at that time had a young unmarried daughter, surpassing in form and figure; and the King of France took an oath by the one God Almighty that he would not give her to any man except to him who should bear the palm of bravery of the entire world. Moreover the king of France proclaimed a a three days' tournament to be fought for his daughter upon the green of the castle in the presence of the kings; and whoever should be strongest among them, he should receive the maiden as his wife, along with all her possessions. Now the





---

p.116






son of the Duke of Birri came to this tournament on the first day, and six bold knights were very quickly laid low before him. Then Sir Guy came to the spot, and he laid low the son of the Duke of Birri together with his horse at the first attack, and the followers of the duke's son quickly and courageously lifted him up, and put him on another steed, and he returned boldly and confidently to meet Sir Guy in the battle. As for those two worthy and noble knights, they broke their long sharp-tipped lances on each other, and Sir Guy dealt the son of the Duke of Birri a mighty blow with his spear upon the top of his breast and his bosom, so that he threw him backward upon his saddle, and broke his long, slender, fair-thighed back with that blow, {Ir. ed. page 35} and he died instantly. And Sir Guy *challenged to* combat after this exploit, and everyone refused him; and the hosts departed in every direction when Guy had won the victory in the tournament. The King of France offered his daughter to Guy as wife, and Guy refused her.


#### 8


As for Sir Guy, then, he went to Germany, and he saw a great, noisy city before him, Bruges by name, and the rich, prosperous lord of that land was in the midst of his great retinue on the edge of the market-place with a numerous company. The fierce, strong lord of Bruges said: ‘Sir Guy’, said he, ‘thou hast killed my brother without cause, and thou shalt die for it thyself.’ Guy said: ‘It was not without cause that I killed him, but fighting with him in battle and in tournament; and if he had had the strength, he would have killed me; and I gave him back such payment[70](javascript:footNote('T306000/note070.html')) that he fell before me.’ As for the king of Bruges, then, he sent seven hundred strong, brave knights to fight with Guy and his three knights. Nevertheless Guy fought skilfully, fiercely, savagely[71](javascript:footNote('T306000/note071.html')) against those warriors, and they all fell by mid-day; and at the end of that fight Sir Guy received a deep, incurable spear-wound in his side, so that he was not able to guard or defend himself longer at that time. Thus far Guy's journey to Bruges.


#### 9


After performing this great feat Guy set out through the broad, vast deserts of Lombardy. When Ottun heard this, the Duke of Lombardy, he sent fifteen knights, who had been often tested, to go against Guy in their strong accoutrements of battle. And there was a noble, famous earl at the head of them, and the rest were barons and knights. And they were in ambuscade against Guy in a narrow pass of the forest. And these are the orders the Lombards gave to their followers, to kill without mercy the three knights who were in Guy's





---

p.117






company, and to deliver Guy himself to them for his punishment. As for Sir Guy now, there was no avoiding that road for him, and he was not long advancing on the way when he heard the neighing of the horses in the wood and saw the tops of the helmets. Guy said: ‘Noble knights’, said he, ‘defend yourselves bravely and doughtily, for treachery has been played upon you, and there is an ambush before you in this wood.’ ‘Leave us’, said they, ‘for thou art not able to fight: and if there is a swift horse {Ir. ed. page 36} under thee, make for the broad and open country[72](javascript:footNote('T306000/note072.html')) and leave us to settle with everyone.’ Guy said: ‘Not for the wealth of the whole world would I do that’, said he. It was then moreover, that the ambuscade sprang to attack them, and they fought with each other bravely, manfully and bitterly; and Guy killed two knights quickly, and Eront killed a knight and overthrew another, and Uront killed a knight, and a knight fell at the hands of Uri. And Uron and Uri were slain in that fight. Then *came* Sir Gincadh, the son of Duke Otun's brother, to Guy and said: ‘Guy’, said he, ‘yield thyself, and I will take thee captive to Otun; and thy three knights have been killed, and thou thyself art not able to fight against me, for I see the blood of thy body flowing; and if thou wilt not consent to be captured, I will straightaway kill thee.’ Guy said: ‘I had rather die’, said he, ‘than be taken captive by the Lombards.’ Then Guy struck Sir Ginchadh a fierce, hard blow with his sword, so that he broke off half of his beautiful helmet with violence, and pierced his armor upon his shoulder; but he wounded not his body or his fair flesh. However, Guy gave him another blow and struck off his right arm at the shoulder; and then Sir Gincadh fled, after being disfigured with scars, and Guy pursued, but did not overtake him; and the knight brought the news to Duke Otun.


Guy returned to his followers in high spirit, and found them dead on the same road; and there came back alive of the fifteen knights only one knight with a single arm. Guy leapt down, and found Sir Uri and Sir Uront dead before him, and Sir Eront with little life in him. Guy put Sir Eront across his *saddle(?)* in front of him, and left the forest full quickly, and there was a deep wilderness to be traversed. And a hermit met him and Guy greeted him, and asked information of him, whence he came. The hermit said: ‘In the seclusion of this forest I live’, said he. Guy said: ‘Do thou bury in the forest beside thee the two knights of my company who are dead, and I will give thee a strong,





---

p.118






brave steed in reward for thy work.’ ‘I will do that gladly’, said the servant of God. And they went through the forest together, and took the bodies of the knights with them and buried them honorably. Then Sir Guy set out, with Sir Eront in front of him, and it was not long for him before he saw a great, famous monastery, and the abbot and the company of canons in its door. Sir Guy begged them for God's sake {Ir. ed. page 37} to give honor of burial to the dead knight before him, and promised that he would pay them the reward of their labor. And he told how the Duke of Lombardy had betrayed him, and how his company had been killed. The congregation took pity upon him, and received Sir Heront from him. And it is thus that Duke Otun betrayed Guy.


#### 10


As for Sir Guy, then, he set out from the monastery, and it was not long for him before he saw a special servant of God coming toward him on his road, and he fell on his knees before Guy, and begged alms of him. Now Guy gave him twenty nobles to secure his prayers for himself and his three knights, because he expected that he himself would die of his wounds. The hermit thanked Guy for his alms, and the old man said: ‘O Guy’, said he, ‘stay with me for thy healing and for the cure of thy wounds, for there is not in the whole world a healer of wounds who is better than I.’ As for Guy, then, he stayed twelve days with the old man for his healing, and he was whole and sound thereafter. Thus far the healing of Sir Guy.


#### 11


As for the Abbot with whom Heront was left, he bade every priest of his convent say thirty masses for Sir Heront's soul. And one of the canons said, taking hold of Sir Heront: ‘This knight is still alive’, said he, ‘and let him be cured.’ The abbot said: ‘It is a good reward I would pay for his cure’,[73](javascript:footNote('T306000/note073.html')) said he. Three months and five days was Sir Heront in illness, and thereafter he was well. Thus far the illness of Sir Heront, et reliqua.


#### 12


As for Guy, after getting up from his illness, he proceeded to the castle of the King[74](javascript:footNote('T306000/note074.html')) of Apulia, and the king and his household made him welcome. And Guy told him how the Duke of Lombardy had deceived him, and how his knights had been killed by him. The king said: ‘O, Guy’, said he, ‘I will be in alliance with thee; have good courage, and I will give





---

p.119






three knights proved and manly and brave, and three squires like them and I will give thee a full complement of bold, brave followers of those six.’ {Ir. ed. page 38} Sir Guy gave thanks for this offer to the Heavenly King and to the King of Apulia. And Guy remained there for a while in very great honor.


#### 13


As for Sir Heront now, after getting up from his illness, he said to the abbot and to the community, ‘I will put on the garments of a penitent,’ he said, ‘and I will go to seek my lord; and if I find him alive, I will pay well for my healing; and if I do not find him, there is nothing for me but to pray for you in return for my healing.’ And the abbot and the canons gave him leave to go. As for Sir Heront, then, he proceeded to the country where Sir Guy was. One day when Sir Heront was travelling about that country Sir Guy came upon him clad in his arm or of battle, and he on a hunt and a great chase,[75](javascript:footNote('T306000/note075.html')) and Sir Heront was weeping and complaining mournfully. And Sir Guy asked him the cause of his sorrow, and Sir Heront said: ‘It will not profit thee to know it’, said he. Sir Guy said: ‘Tell me the story for His sake who suffered the passion on our account.’ ‘I will certainly do it’, said Heront. ‘I am journeying about the lands and provinces of the whole world in search of my lord; and if he is alive, there is not in the world a single warrior stronger and braver than he; and if that brave warrior has fallen, could I learn where his grave and his resting-place is, I would dig up the earth, and I would stretch myself upon his neck, and in that manner I would die.’ Guy said: ‘What is thy land’, said he, ‘and who was the lord thou hadst?’ Sir Heront said: ‘I am an Englishman’, said he, ‘and Heront is my name, and Sir Guy of Warwick is my lord. And the Duke of Lombardy deceived us, and slew[76](javascript:footNote('T306000/note076.html')) three knights of us, who were in attendance upon Guy, and two of us were buried, and I got up after a long illness; and there were wide, deep wounds on Sir Guy's body and he came out of the slaughter, alive but wounded,[77](javascript:footNote('T306000/note077.html')) and I do not know whether he is living or dead, and that is the cause of my grief’, said Heront. Guy said: ‘Art thou Eront?’ said he. ‘I am he’, said Heront. Guy leaped down quickly, and cast off his helmet off his head, and gave Heront three kisses when head recognised him, and a swoon and a heavy faint came over both them because of the greatness of their joy. Guy lifted up Heront *and put him* behind him, and then they went into the city, and Guy took leave of the king, and left a farewell for





---

p.120






him and his household. Thus far the course of Sir Guy in Apulia.[78](javascript:footNote('T306000/note078.html'))


#### 14


{Ir. ed. page 39} As for Sir Guy, then, he proceeded with his company, and when he came where Duke Milon was [*...*], and the Duke paid him honor and respect; and the Duke offered Guy gold and silver and abundance of goods, and Guy took them

not from him. And he went thence to Flanders, and he was on the point of going to England, and a pilgrim met him at the end of the day, and Guy asked news of him. And the pilgrim said: ‘I have news’, said he, ‘for there is a war and conflict between the Emperor and[79](javascript:footNote('T306000/note079.html')) Rener and the Duke of Lorraine, and the Emperor's brother fell in that fight against the Duke of Lorraine, and the Emperor has plundered and laid waste the land and fair territory of the Duke of Lorraine, and that is my news’, said the pilgrim. Guy said: ‘Stay with me tonight, man of God’, said he, ‘and thou shalt have food and sustenance for the night in honor of Jesus’; and thus the night passed for them. In the morning Guy said: ‘Heront’, said he ‘what is thy counsel for us today?’ Heront said: ‘My counsel is ready’, said he, ‘namely, that thou shalt go to the support of the Duke of Lorraine, who has shown thee favor and great honor, and who offered thee gold and silver and an abundance of goods. And take with thee fifty knights, strong, tried and invincible, of the fierce, brave men of France.’ They decided upon that plan.


As for Sir Guy he set out, and sixty knights with him into Germany to meet the Duke of Lorraine, and the Duke gave Guy three kisses fondly, fervently, faithfully. The Duke said: ‘Dear brother’, said he, ‘it is well thou hast come to my aid, for I was never in such plight or such need as I am now.’ The Duke of Lorraine said: ‘Guy’, said he, ‘I give thee command over myself and whatever I have of possesions.’ Guy said: ‘It will not be long till I win the battle and conflict with the emperor for thee’, said he. Then they went to mass, and the Duke set Sir Guy on the same seat beside him in the church; and they went out of the church, and Sir Guy saw a host, armed and equipped, surrounding the city, and he made inquiry who they were. Someone said: ‘That is the Emperor's steward’, said he, ‘coming to capture the city from the Duke of Lorraine.’ When Guy heard this he stuck two spurs into the horse, and went to meet the steward. The steward of the emperor said: ‘I see a knight, {Ir. ed. page 40} bold and brave, coming out to meet us, and beneath him a nervous, swift steed that is swifter than any horse in the world; and I think it likely that the horse will remain with me’, said he. The steward came out





---

p.121






fiercely and courageously to meet Guy, and they spurred the horses against each other, and dealt each other two blows on the breast, and the steward was thrown to the ground by that onset. And they bore off the steward in spite of Sir Guy, and his followers were weeping and lamenting about him; and Sir Guy pursued them, and they fought each other boldly and bitterly, and the steward and his followers were defeated by Guy. And *Sir Guy* captured the steward himself with the best of his army, and took them with him as captives, fettered and hard bound and put them in prisons. Guy told the Duke of Lorraine to be kind to the prisoners of the emperor, and that it would be easier for him to make peace by guarding the emperor's followers and protecting them from death and slaughter. Then Sir Guy sent a message to his friends and comrades, in whatever quarter they were, to aid and defend him in that conflict; and they came to him thereupon in companies and troops[80](javascript:footNote('T306000/note080.html')) and confederated (?)[81](javascript:footNote('T306000/note081.html')) battalions from every quarter where they were. As for Sir Guy, then, by him were captured the cities and castles and strongholds[82](javascript:footNote('T306000/note082.html')) of stone that had been captured before this by the emperor from the rule of the Duke of Lorraine. Thus far the first battle of Sir Guy against the emperor.


#### 15


Then news reached the emperor that his followers had been captured and killed by Guy of Warwick. Wrath and keen anger and a red burst of fury (?)[83](javascript:footNote('T306000/note083.html')) seized the emperor when he heard this news, and he made a rally and a muster of his people from every quarter where they were. When the emperor's followers had gathered in one place before him, he complained to them of those exploits. The Duke of Pani[84](javascript:footNote('T306000/note084.html')) said: ‘My lord’, said he, ‘I will give thee good counsel: namely, to let me and Rener, Duke of Sision,[85](javascript:footNote('T306000/note085.html')) and Duke Vadiner seize the city of Greasmont; and we will take it, and make fettered, fast bound captives of the Duke of Lorraine and of Guy of Warwick, and we will slay their followers.’ The emperor said: ‘That is good counsel’, said he. Then the three dukes came boldly and bravely to lay siege to the city of Greasmont, and terrible, vast armies along with them. And there were a hundred full bold warriors in the armies of these three dukes against every man who was in the city of Greasmont. Fear and terror seized the Duke of Lorraine with his household upon





---

p.122






seeing {Ir. ed. page 41} these hosts coming against them. The Duke of Lorraine said: ‘Sir Guy’, said he, ‘what is to be done now?’ ‘To do bravely’,[86](javascript:footNote('T306000/note086.html')) said Guy. Then Sir Guy called Sir Heront to him, and took counsel with him, and said: ‘Sir Heront’, said he, ‘take with thee three hundred knights in their strong battle, phalanx about thee, and fight a brave, hard fight with the Duke of Pani, and conquer the pride and the haughtiness and the high spirit of the Duke of Pani, because he has called us both false and fratricidal traitors, and has put shame and insult upon us. And I will be behind thee, and a thousand knights with me; and O Sir Heront, make a brave fight, for I will be near thee.’ The Duke of Lorraine said: ‘I will be near you and the hosts of the city, in our defence; and we pray the God of all power to strengthen us today’, said he.


Now Sir Heront entered the fight fiercely, bravely and valiantly, and he saw the Duke of Pani coming against him, and he recognised him. And he said: ‘O fratricidal, false and envious duke, thou didst twice deceive my lord and me myself, and by the will of God thou shalt have evil return for this today’, said he. Then they fought with each other bravely and bitterly, mightily, manfully and madly; and afterwards they unhorsed each other, and rose again quickly and very lightly, and bared their decorated swords, and made a fiery, fierce attack upon each other, and the Duke of Pani was thrown on the back of his shield by Heront's mighty blows. Then came the bold, valiant hosts of the Lombards to the aid of the Duke of Pani. When Sir Heront saw them he sprang quickly and very lightly upon his steed, and the duke did the same. And they fought with each other anew[87](javascript:footNote('T306000/note087.html')) and tirelessly, and the Duke of Pani avoided combat[88](javascript:footNote('T306000/note088.html')) with Sir Heront. As for Heront now, he took to cutting down and slaughtering the Lombard warriors. The Duke of Pani said with a loud, terrified and trembling voice: ‘One single knight is killing and slaying us all’, said he, ‘for our friends and comrades have all fallen at his hands; and now fight boldly.’ Then the battle was fought angrily and fiercely, and a multitude of mighty, violent blows were dealt upon Sir Heront's shield at that time. Then anger and great rage seized Sir Heront, and thereupon his followers closed about him, and {Ir. ed. page 42} the followers of the duke of Pani did the same. And this is the number of the army of the duke that fell by Heront's hand in that onslaught: a hundred and twenty knights, either captured or killed did Heront defeat there. And Heront was ten hours





---

p.123






of the day in that fight, and no one came against him in that one whom he did not valiantly overthrow or kill. The Lombards however, gathered very bravely, and the Germans very boldly about Sir Heront, so that he could not put his hand on his bosom nor upon his girdle nor upon his fine garment because of the pressure of the warriors on his back in that fight. It is then that small, broken[89](javascript:footNote('T306000/note089.html')) pieces were made of Sir Heront's shield and his beautiful, soft-silken standard was lowered and badly torn, and the fair, golden helmet was shattered that shielded his head in the fight; and at that time Sir Heront had no strength to guard and defend himself, but only to endure pain and suffering.


Then Sir Guy went into the battle against the Lombards, and he left Sir Heront behind him. Then Sir Guy saw Otun, the Duke of Lombardy, and said to him in a high clear voice: ‘O fratricidal duke’, said he, ‘wickedly and boldly didst thou deceive me, and didst kill my followers.’ The two made for each other swiftly and madly, and they fought a bloody, warlike and ferocious fight, and the Duke of Lombardy was overthrown by Guy on that battle-field. And the duke got up bravely, and mounted his steed, and fought with Guy again, and Guy quickly overthrew him a second time. And he mounted his steed again, and Guy overthrew him the third time, and drove a spear through his shoulder-blade after splitting his shield. But when it pleased Guy to dismount to behead the duke, there came between them a thousand Lombard and German knights, swift and bold and very brave, and they took the duke with them away from Guy. And they all fought together against Sir Guy, and six knights of the fierce, bold warriors fell at that time at the hands of Sir Guy. Guy's followers, moreover, were on every side of him cutting down and utterly destroying the Lombards. Then the battle was won by Guy, and the Lombards fled to a deep, dark glen that was before them. {Ir. ed. page 43}. And the Duke of Sision and Earl Vadiner of Cologne were in this glen with their armies, and Guy saw them and told his followers that they were in that ambuscade. Guy said: ‘The Lombards and the Germans have joined into one force against us’, said he, ‘and we have no way of escape from them; and fight boldly in our defence, and let us rise in the name of God and of John the Baptist to make an attack on them yonder.’ Then did each of the battalions make attack on the other, and no civil strife was ever to be compared to it,[90](javascript:footNote('T306000/note090.html')) for the sore combat there was keener, and the enmity was fiercer, and





---

p.124






the strong men were stronger, and the warriors were braver. Then did Sir Guy see Rener, Duke of Sision, and he fought hard with him fiercely and savagely, and laid him low with the first blow, and weakness and infirmity seized him after his fall. Moreover Sir Heront and Earl Vadiner of Cologne came together, and fought hard and bravely, and the earl fell at the end of the fight and a knight of his company along with him; and Sir Heront was brave and victorious in that combat.


Then Duke Rener rose from his swoon, and mounted his steed, and fought again with Guy desperately, fiercely and savagely. Guy gave the duke a mighty blow, rough and strong, so that he laid him low full bravely for the second time. Then Guy saw Sir Gilmin coming toward him, — a brave, victory-bold knight of the followers of the emperor, and brother to the Duke of Louvain was he; and he had a high commission from the emperor to keep every fair forest that he possessed; and there were a thousand fierce-spirited, arrogant knights in his own strong battle-troop around him. And this was the desire of Sir Gilmin and his company, that Sir Guy should fall full quickly at their hands. Then Sir Guy and Sir Gilmin fought with each other manfully, mightily and full bravely, and Sir Gilmin fell at the end of the fight before Guy's perilous, horrible blows. Thereupon the Duke of Sdragborn, and terrible, mighty hosts about him,[91](javascript:footNote('T306000/note091.html')) came into the fight to seek Sir Guy, and there was not of the great armies of Lombardy, nor of the brave, warlike men of Germany a single hand that was stronger at winning battles and combats than that duke. And fear and terror seized Sir Guy, after being three days and three nights in his armor without food, without drink, and without sleep.


Sir Guy sent messengers then to the city of Greasmont to the Duke of Lorraine to ask for aid. The Duke of Lorraine said: ‘Whatever be the danger or peril in which Sir Guy is’, said he, ‘he is no more glad to receive aid and succor than I am to give it to him.’ And he set out quickly and very readily, and three thousand {Ir. ed. page 44} knights, fierce-spirited and courageous, along with him. Then those two slaughtering armies attacked each other. As for Guy, then, it was not credit, or fame, or honor in his eyes that a battle should be fought and maintained agamst him; and his lion's wrath, and his serpent's venom, and his soldier's strength and his warrior's spirit and his champion's ardor awoke, and his flame of battle rose upon his breath,[92](javascript:footNote('T306000/note092.html')) and he staked his fame on the fight, and he brought defeat upon the Lombards full bravely, and upon the Germans full swiftly, and made a slaughter of them in that battle; and there were captured dukes





---

p.125






and earls and barons and many nobles and high men of the army. And Sir Guy returned to the city of Greasmont in triumph with many spoils[93](javascript:footNote('T306000/note093.html')) and with an abundance of all kinds of possessions. And Sir Guy told the duke to keep of hostages of the emperor well, because ‘it is they whom we expect to bring us peace yet from the emperor.’ Thus far the third fight which Sir Guy fought with the followers of the emperor.


#### 16


The emperor, then, on the day of that great fight, was in his own city, and the King of Hungary along with him, and games of chess going on between them. And they saw Sir Tirri, the son of Earl Aimbri, coming towards them, and a broad-trenched, decorated sword bared in his hand, and wide, deep wounds on his body, and blood flowmg in streams down the sides of his body, and his shield in broken fragments at his side, and Tirri himself with a very sad face upon him. Tirri said: ‘My lord’, said he, ‘though thou art gay and cheerful, strange and unrecognisable are thy followers, for of those who went to battle and to combat against the Duke of Lorraine there remains in safety and alive no one but myself only; and Duke Otun was heavily wounded, and not much remains of him; and Duke Rener and Earl Vadiner have been captured. And it is Sir Guy of Warwick who has done all these deeds, for no one tastes of life upon whom he deals the force of his blow, and the men of the ponderous[94](javascript:footNote('T306000/note094.html')) world could not defeat him by reason of strength or prowess.’ After the emperor heard this news, wrath and quick anger seized him, and his sense and reason left him entirely. The emperor said: ‘I swear’, said he, ‘by the One who made heaven and earth, that I will never stop until I capture the city of Greasmont, and until I hang the Duke of Lorraine and Guy of Warwick.’


The emperor made a rally and a muster of the armies of the whole empire in one place, and then he advanced with them to the city of Greasmont. {Ir. ed. page 45} Sir Gayer, moreover, a fierce-spirited son of the emperor and another noble earl along with him, and five hundred knights, bold-hearted and splendid, came in advance of the armies to reconnoitre the city; and five thousand knights were sent after them to defend and support them strongly and irresistibly, and half a thousand more as a reinforcement to these, and three thousand behind them; for there were thirteen thousand knights and half a thousand supporting each other at the entrance of the road, and the emperor with a great host behind them. Then the people of the city of Greasmont saw the mighty,





---

p.126






multitudinous armies coming against them, and fear and terror seized them at the sight. The Duke of Lorraine put on his battle armor, and mounted his horse, and went to Guy, and told him the news. Guy said to the duke: ‘Do thou keep the city secure’, said he, ‘and I will go out to fight the army’, — and a thousand knights along with him.


As for Guy, then, he went into that conflict quickly and very swiftly, and he saw a detachment of strong, bold footmen coming behind the five hundred knights who were at the head of that heavy army. Then Sir Guy saw the emperor's son coming, and he went straight to meet him, and they fought a bold, valiant battle with each other, and Sir Gayer was thrown, and afterwards captured, and three hundred of his followers with him, and the remaining two hundred fell before Guy. Sir Guy went to the city with the captives for their safe keeping, and afterwards went *back* to fight with the same army, and he saw nothing over all the land at that time except the host, armed and equipped for battle.


When the emperor heard that his son had been captured, sorrow and melancholy seized him; and those heavy forces, strong and brave, came in one body against Sir Guy when they recognised him. And a bloody, angry, violent battle was waged between them; and though there were many strong, brave warriors in that battle, it was Sir Guy and Sir Heront who had the upper hand of them on every side. And though it was thick about every one in that fight, it was broad and open field[95](javascript:footNote('T306000/note095.html')) about them both. Then a multitude of brave hands were laid on them, and it was hard for them at that time, and at that time was the beginning of slaughter for the hosts of the city of Greasmont. The Duke of Lorraine *and* three thousand knights came out of the city then to help Guy. Then Sir Tirri, the son of Earl Aimbri, met the duke, {Ir. ed. page 46} and they fought a manful, angry fight, and the duke was thrown by Sir Tirri, and he got up quickly, and struck Sir Tirri a mighty blow, and it is a long, lasting (uilligi)[96](javascript:footNote('T306000/note096.html')) that he gave there. There collected bold, irresistible, troops of soldiers, fierce-hearted and haughty, around the Duke of Lorraine, and he was suffering pain and punishment, and was wounded bloodily, and had no strength to defend himself.


Sir Guy saw the danger and the peril that the duke was in, and sent to his aid, and killed four knights around the duke with four mighty, mortal blows. Now a fierce-spirited knight was killing and slaying and cutting in pieces and utterly destroying the duke, and he cast him from his saddle, and struck him to the ground, and would fain have beheaded him. And Sir Guy came to the scene of this heroic fighting, and he gave the knight a





---

p.127






mighty blow so that he made two exactly equal pieces of him with one stroke; and Sir Guy then put the duke on his steed. The man[97](javascript:footNote('T306000/note097.html')) said to Guy: ‘I am weak and sorely wounded, and I cannot give thee support or assistance’, said he, ‘and I had rather thou wouldst go into the city with thy followers, for we are not in sufficient number to fight against them yonder, and it is not befitting us to be taken without gaining anything.’ Sir Guy said: ‘I will do thy will in this matter, my lord’, said he.


Thereupon they went together into the city. The emperor told his followers to attack the city boldly and fiercely. Then the army of the emperor came against the gates of the stronghold; and there were many beautiful, variegated standards on the gates of the city, and they began to destroy and to raze the walls and the fortifications. The people of the city began to defend it bravely and strongly: some of them with short, terrible javelins, and some with arrows, sharp-tipped and skilfully made,[98](javascript:footNote('T306000/note098.html')) some with dangerous perilous guns, and others with bulky[99](javascript:footNote('T306000/note099.html')) stones from slings, and others with spears, flat-tipped and smoothly-polished; others still with great rocks and with stones of the wall, big and destructive,[100](javascript:footNote('T306000/note100.html')) throwing them down from the turrets of the great city, — and all sorts of projectiles besides.


Fifteen days they continued that labor and that hardship without peace or rest or repose; and this is the number that fell in that time at the hands of Guy and of Heront, a hundred fierce-hearted horsemen and {Ir. ed. page 47} a thousand strong, bold footmen; and there was no count of those who fell before the armies of the city in addition to them. There came, then, to Guy secretly a dear and beloved friend from the forces of the emperor, and said to him: ‘Sir Guy’, said he, ‘I have good news for thee, for the emperor will come tomorrow morning early with five hundred knights, without arms or weapons, to hunt in this forest; and a tusked boar has been put in it for him; and do thou, Guy, be in the forest tonight with men enough to destroy them, and do thy will with the emperor.’ Sir Guy said: ‘For that news’, said he, ‘I will give thee a thousand plates of beautiful, refined gold.’ The traitor said: ‘Keep me with thee till thou provest it, and if thou do not find it to be truth, I give thee the right to hang me.’


Then went Sir Guy and Sir Heront, and three knights with them, to the duke, and he in his chamber playing skilfully and cleverly at chess; and Guy greeted him, and told him that the emperor was to be alone in the forest in the morning. When the duke heard this news, he rose quickly to





---

p.128






his feet, and he gave Guy three kisses, and said: ‘Forgive me warrior, that I have allowed thee to come to me with a message’, said he, ‘and that it was not I who went to thee.’ Guy said: ‘I will go out yonder to meet the emperor and I will bring him with me by consent or by force to make peace with thee.’ And the duke praised that plan.


As for Sir Guy, then, he proceeded to his inn; and when the early part of the night had come, Sir Guy set out from the city secretly and silently, and a thousand knights along with him, and went into the forest, and they went to *(or upon)* the hill that was there. In the morning, then, Sir Guy saw the emperor coming into the forest with a small company about him, namely, five hundred knights without weapons or armor, of the gentlemen and noblemen of his company. Sir Guy said to his followers: ‘The emperor is coming upon us’, said he, ‘and we are between him and his company, and he has no power to escape us; and fight bravely and well, my bold knights!’ said he. Then the emperor looked off, and saw the hosts, with weapons and armor, coming to surround him. The emperor said: ‘We have been sold and betrayed to Guy of Warwick’, said he, ‘for I see Sir Guy with his followers coming against us.’


Then {Ir. ed. page 48} Sir Guy went before his followers to meet the emperor, and a branch of olive in his hand as a sign of peace. And Sir Guy said to him, as he approached the place: ‘Let no man of you offer battle or conflict to the emperor's company’, said he, ‘and if someone does, I will strike off his head.’ Sir Guy said: ‘God be thy life, noble and brave emperor!’ said he, ‘and there is a feast prepared for thee to eat by the Duke of Louvain; and do thou come to partake of it and to make peace with him; and he will give up himself and all his possessions to thee.’ Then came up the thousand horsemen who were with Sir Guy, and a branch of peace in the hand of every man of them, and Guy bade them pay homage and honor to the emperor, and they did so. Sir Guy said to the emperor: ‘Let us be off now to the city’, said he, ‘for thou hast no power to refuse to go with me whatever way I wish.’ The emperor said: ‘Sir Guy’, said he, ‘if thou wouldst swear to me surely that I shall not be betrayed, I would go with thee.’ Sir Guy said: ‘I swear’, said he, ‘by Him who suffered the passion for the human race have no fear of anything in the city yonder.’ Thereupon the emperor dismounted, and put his two hands about Sir Guy's neck and gave him three kisses fondly, fervently and faithfully, and then said: ‘Brave and victorious knight, pious, merciful and virtuous, I will go with thee.’


After that they went to the city; and there was no wasted (?)[101](javascript:footNote('T306000/note101.html')) old man, nor tender youth without years, nor brave, triumphant





---

p.129






hero, nor strong and valiant warrior, nor soldier courageous and famous, nor maiden fair and very comely, in the whole city who did not pay homage and honor and great respect to the emperor did unto Guy. After that they went to the duke's palace, and and emperor with his retinue was served and provided by Guy with the choicest of every kind of food and drink, and the duke

did not come to them on that night.


And for the duke, he arose he next morning, and released the prisoners of the emperor, and told them to take the roads they chose, and enjoined upon them to ask of the emperor favor for him; and the prisoners all gave thanks to the duke. As for the prisoners, then, they asked the duke to go with them to the emperor; and he went readily, and took off his splendid, silk garments, all except one fine[102](javascript:footNote('T306000/note102.html')) silk shirt next the brightness of his white skin, and he went with them all into the presence of the emperor, and bent his right and left knees beneath him, and knelt in the emperor's presence.


The duke said: ‘My lord’, said he, ‘I am at thy mercy, and I have deserved to receive death {Ir. ed. page 49} at thy hands, for it is I who killed Sir Sadon, thy own brother; and I give myself up to thee without opposition (?),[103](javascript:footNote('T306000/note103.html')) and do thy will with me now’, said he. Sir Gayer, the emperor's son, said: ‘My lord’, said he, ‘give the duke assurance of peace, for he is a brave, victorious man, faithful and very wise, and wrong has been done him.’ Duke Rener said: ‘Do this, my lord’, said he; ‘for it was justly that he slew thy brother's son, and though he should say this were not true, I would undertake to prove it on him.’ Earl Vadiner said: ‘Do this, my lord’, said he, ‘for the duke has not deserved that wrong or injustice should be done him; and he has always been a friend to me, though I am now against him; and if peace is not made with him quickly, I will go back to the city of Cologne, and I will bring hosts of good troops together, and I will make war against thee in company with the Duke of Louvain.’ And the emperor said nothing at that time. Sir Guy said: ‘My lord’, said he, ‘fulfil the promise thou madest to me in the forest. And dost thou not see that the duke has been long on his knees, and that he might refuse thee so? For he is stronger here than thou art, my lord; and I give my word that unless assurance of peace is given to me quickly I will bring destruction and ruin on thee and on thy followers.’ The emperor said: ‘It is for the duke to give thanks to the one God who made heaven and earth for the day when he saw thee, Sir Guy’, said he; ‘and I will fulfil my promise to thee; for I pardon the duke for having killed the





---

p.130






one man who was dearest to me of all who were ever on the earth, — Sir Sadog, my own brother's son; and I give him assurance of peace.’ Then all the hosts rose to their feet and gave the emperor three shouts of blessing for the mercy he had shown to the duke. And the hosts turned together to Sir Guy, and gave him shouts of blessing, and said with the voice of one man: ‘O brave, victorious knight, and strong, valiant warrior, it is because of thy bravery and prowess and that wisdom and skill, that this peace has come to be made.’


The news of this peace was heard by the hosts that were outside around the city. Then came Otun, the Duke of Lombard angrily and wrathfully to the emperor and said: ‘My lord,’ said he, ‘it is wrongly that thou hast made peace with the two traitors, the most false and envious who are in the whole world the Duke of Louvain and Sir Guy of Warwick.’ When Sir Guy heard this, he clenched his fist right boldly, and struck the duke on his nose, and {Ir. ed. page 50} his blood spurted out quickly, and he threw him to the ground. He would fain have struck him again, but the emperor asked him as a favor not to strike him the blow. ‘I will grant thee that favor, not to strike him or any other man today’, said he. Sir Guy said: ‘He has betrayed me twice without cause’, said he; ‘and with God's permission I will not leave that without vengeance yet’, said he. Then the two hosts kissed each other in the greatness of their joy because of this *peace*. And then ended the war between the emperor and the Duke of Louvain.


Duke Rener of Sision said that he would take the daughter of the Duke of Louvain, and that he desired to have friendship with him, and this betrothal was made. And the emperor gave the daughter of his father's own brother's son to the Duke of Louvain for his wife, and promised him great wealth and sovereignty with her, and that alliance was made. Sir Guy said that he would depart. ‘Do not go,’ said the Duke of Louvain, ‘for I will give this city to thee, and half my realm; and do not leave me.’ Sir Guy thanked him, but did not take it.


#### 17


As for the emperor, then, after making that peace and that alliance with him, he took leave of the Duke of Louvain; and Sir Guy set out along with him. As for the Duke of Louvain, he was fifteen days without food or drink or sleep from grief at Sir Guy's departure from him; and little remained of him because of his love and strong affection *for Sir Guy*. Then the emperor came into Germany, and Sir Guy along with him and the emperor offered Sir Guy cities and castles and parks and beautiful forests for hunting; and said that he would give him a dukedom, and that he would give him abundance of gold and treasure and of all kinds of riches. And Sir Guy refused to accept it, and then took leave of the emperor.




---

p.131


#### 18


As for Sir Guy, now, he went on his way and took with him for followers only a hundred tried, brave knights of the German noblemen; and he proceeded along the margins of the vast sea until he saw a great ship with an abundance of all kinds of goods, which had entered the harbor; and Sir Guy asked tidings of it. A brave, well-spoken man of them answered and said: ‘We have come from the city of Constantinople, and this is the reason why {Ir. ed. page 51} we have come: because the Sultan *has won* the realm of the Grecian Emperor, and his followers have been killed in battles and conflicts; and there is none of the realm of the emperor left, which has not been taken from him by the Sultan, save only the city of Constantinople. And the Sultan with his hosts is coming to take it; and we came aboard the ship here to seek some place where we might find peace and quiet to dwell in, and we have brought part our possessions here with us, and those are our tidings’, said the young man; ‘and now do your pleasure with us.’ And there was fear and terror on the *ship's* company. Sir Guy, however, went up ashore, and collected two hundred other knights in addition to those he had, and went to the same ship. And he told the company to make the ship ready, and that they must go back with him over the same course to Constantinople. Thus far Sir Guy's course in Germany.


#### 19


As for Sir Guy, then, he went aboard the ship with his three hundred knights, and the ship's company along with him. And they took a swift course, eager and very bold, through the streams of the ancient sea, and through the perilous, awful waves of the blue sea; and they were fifteen days on the ocean because of a great storm, and they found a harbor sheltered and secure, in the city of Constantinople. And they raised the lofty standard of the English, the banner of St. George, above the boat. The emperor was then on the battlements[104](javascript:footNote('T306000/note104.html')) of the castle praying the Lord for help out of the difficulty he was in and he saw the ship, full of men and very great and the standard of St. George raised upon it. And he sent a messenger to get news, and to make the English welcome, and to bring him into his presence. The messenger went to the ship, and asked tidings of the ship's company. *Sir Guy*[105](javascript:footNote('T306000/note105.html')) arose and answered: ‘An English knight is here’, said he, ‘and Sir Guy of Warwick is his name; and there are three hundred fierce, courageous, high-spirited knights in his company, who have come to the support of the emperor.’ Moreover Sir Guy gave





---

p.132






a scarlet gown to the messenger, and he proceeded to the emperor, and reported this news to him. When the emperor had heard it, he looked up to God, and gave him thanks for it. And he said: ‘If it is Sir Guy {Ir. ed. page 52} of Warwick that is there’, said he, ‘there is not a knight in the world that is stronger of hand.’ And the emperor bade the people of the city go in procession to meet Sir Guy. Then came the men of every church in the city with tapers and with (priceduibh)[106](javascript:footNote('T306000/note106.html')), and with bright lamps, with bells and with staves and with relics; and the people of the city with splendid garments of silk and of gold thread, and the king with his crown on his head, tightly bound,[107](javascript:footNote('T306000/note107.html')) set with jewels and adorned, and the musicians of the city playing the organ, and the guitar(?),[108](javascript:footNote('T306000/note108.html')) and the trumpet, and the tabor and the pipes and the fiddle and the harp, and all the other instruments besides. And they all went out thus to meet Sir Guy, and a great welcome was given him; and the emperor kissed him three times fondly, fervently and faithfully, and took him by the hand, and put his other hand about his neck, and it is thus that the emperor took Guy with him into the royal palace, and the emperor placed Sir Guy at his own side to eat his food.


Then the emperor ordered a high chamber to be made ready for Guy and his followers, *and* everything to be given to them that they might ask for. Then the emperor went to the chamber with Sir Guy. After this the emperor said: ‘Sir Guy’, said he, ‘I look to thee for protection, for the Sultan has taken from me all my realm except only this city; and he is coming to capture this from me, and twice twenty thousand of my followers have fallen in a single day at their hands; and I have no children besides one daughter, and she is my heir; and I will give her to thee as wife, and do thou win my land and my sovereignty for thyself.’ Sir Guy said: ‘It is not to get a wife that I have come, but to fight in thy support; and I will do my best for thee, and I take it upon myself to protect thee.’ And it was not long like this with Guy, after the emperor left him, when he heard a cry and a shout of terror and complaint throughout the length of the city; and Guy sent a messenger to get news, and this is what someone told him: ‘An Amiral[109](javascript:footNote('T306000/note109.html')) whose name was Coscras, the son of the Sultan's uncle, and king of the Turks, has come with a thousand Turks to capture the city; and they have laid siege around it.’ When Sir Guy heard this, he told his followers to put on their armor, and to fight bravely; and Sir Guy went out of the city *with* the three





---

p.133






hundred knights, *and* was himself in the face of the enemy,[110](javascript:footNote('T306000/note110.html')) he fought a fierce, bold, destructive fight in the midst of the brave warriors. And Sir Guy and Coscran[111](javascript:footNote('T306000/note111.html')) fought with the other, and Sir Guy drove a spear through Coscran's shield each powerfully {Ir. ed. page 53} and valiantly, and through his heart mightily, and leaped down upon him, and struck off his head. And he sent a messenger with the head to King[112](javascript:footNote('T306000/note112.html')) Heirrneis, which was the name of the emperor; and he never received, before or after, a gift he was more glad to get than that. The king of the Turks and Sir Heront met each other in the battle, and they fought boldly and valiantly, and the king of the Turks fell at the end of the fight from the warlike, mighty blows of Heront. And six hundred of the Saracens fell at Guy's hands before morn of that day came, and two thousand seven hundred after mid-day. Three days and three nights was Guy fighting that battle.


As for Escladata, a strong knight of the Sultan's army, he left the battle with a spear through his body, and half of his head missing, and he went to the Sultan and said: ‘I have bad news for thee, my lord’, said he, ‘for thy brother *has been slain (?)*, and I saw his head struck off him. And the king of the Turks has been killed, and there has not come out alive any of thy company but myself alone, and I shall die in this hour.’ The Sultan said: ‘They have rallied some strong army’, said he. The knight said: ‘They have’, said he; ‘namely, a Christian knight whose name is Sir Guy of Warwick with three hundred knights in his company.’ The Sultan said: ‘I swear by the gods’, said he, ‘that I will capture that noisy city within fifteen days, and I will hang the emperor and Sir Guy on a single cross.’ Then the knight who brought the news fell down and died.


As for Sir Guy of Warwick, now, he came into the city, after winning victory and triumph, with plenty of spoils in his possession, and he and his followers were weary from the fighting after that battle, having been three days and after three nights making the fight without food or drink or sleep. And after this the people of the city gave him three shouts of blessing.


#### 20


As for the emperor, moreover, he said that there was not in the world any pursuit that was dearer to him than the hunt and the chase, — ‘and I have not dared for a long time and a great while to go out beyond the gate of this city for fear and for terror of the Sultan and of the {Ir. ed. page 54} Turks, until Sir Guy came to my help. And tomorrow I will go into the forest to the hunt and the chase, and I will stay fifteen days in the





---

p.134






forest, and we will have sport and diversion there for that time.’ When the next day came they went into the forest; and some of them set to hunting on the sea with nets to catch fish, and others with hawks to catch birds, and others with dogs and nets to catch stags and tusked boars and swift hares and all the other wild creatures besides. Then the pangs of jealousy came upon the steward of the emperor, — Sir Morgad*ur* the steward's name; for hateful envy towards Sir Guy seized him, because the emperor had offered him his daughter in marriage, for the steward *felt* great and enduring love for the emperor's daughter.


As for Sir Morgadur, he was considering how he could harm Sir Guy, and he came where Sir Guy was in the forest, and said to him: ‘Sir Guy’, said he, ‘I cannot bear[113](javascript:footNote('T306000/note113.html')) in my body and my flesh the strength of my love for thee; and I have courts and castles and land and property and gold and silver and all kinds of wealth besides; and it is to thee that I wish to give them all to control and to enjoy. And come with me to the emperor's daughter, and let us play chess in her presence; and we will return to the emperor, for he will not leave the forest this week.’


Thereupon Sir Guy went with the steward into the city to the emperor's daughter; and Sir Guy won three games from the steward at first. The steward said to Sir Guy: ‘Wait a while here’, said he, ‘until I go on some business.’ The steward went to the emperor in the forest, and the emperor asked him for news, and the steward said: ‘It is bad news I have’, said he, ‘namely that the false, treacherous knight that is with thee, Sir Guy of Warwick, has forced thy daughter in her own chamber; and let him be put to death at once. And I will go at my own cost to the German Emperor to obtain a force and an army to aid thee.’ The emperor said: ‘I do not believe wrong of him’, said he, ‘for I am full of love and great affection for him.’ And since the emperor did not believe that evil report, the steward went to the city to Sir Guy and said to him: ‘So great is my love for thee, Sir Guy’, {Ir. ed. page 55} said he, ‘that I cannot make a secret of the thing that might come to harm thee. Leave this city quickly, for if the emperor find thee in it, he will put thee to death.’ Sir Guy said: ‘It is hard to put trust in a lord after the emperor’, said he, ‘for great is the good I have done him, even though he is on the point of killing me; and still more good would I have been glad to do him until now; and now I will go to the Sultan to get revenge upon the emperor.’


Then Sir Guy went to his followers and told them to put on their armor of battle and to leave city of Constantinople; and they put on their armor quickly, and raised their standards on staffs, and proceeded out of the





---

p.135






city. The emperor was then on the summit of a hill in the forest, and he saw a brave and terrible host[114](javascript:footNote('T306000/note114.html')) leaving the city, and he asked who they were. Someone told him: ‘It is Sir Guy of Warwick yonder’, said he, ‘going away with his followers, since trouble has been made between him and thee.’ The emperor said: ‘Do ye all remain here’, said he, ‘and I will go to Sir Guy.’ And the emperor went eagerly and full swiftly, and asked Sir Guy the cause of his departure. Sir Guy said: ‘I heard’, said he ‘that thou didst not desire to have me with thee, and that thou didst wish me to leave thy land and thy fair realm, and that I am of no more use to thee.’ The emperor said; ‘I swear’, said he, ‘by the God who endured the Passion for my sake, that I did not say that, and that there is no man in the world who is dearer to me than thou art.’ And thus he was reconciled to him. Thus far the injury which the steward did to Sir Guy, et reliqua.


#### 21


As for Sir Guy, then, *his* messengers were getting news in the land of the Sultan; and they came to him and told him that the Sultan would come in full force on the next day to rase and destroy the city; and Sir Guy told this to the emperor, and then they took counsel. The constable of the city said (and he was a noble duke, and had a long white beard down to his breast, and he himself a venerable old man): ‘Do as I shall tell you’, said he; ‘for there is a high mountain between us and the Sultan, and they cannot vary their course, and let us take up our position against them in the open space on the mountain, and let us keep the {Ir. ed. page 56} Sultan and his followers below us in the steep places, and there will be narrow forest passes between us and them. And we will send missiles among them from every kind of engine for projectiles, and neither a wound nor a scratch from them will reach us against the ascent.’ And Sir Guy and everybody praised this plan, and they carried it out.


Then the emperor with his troops came upon the mountain; and they did not see a single bit of the land vacant, but all full of battle-equipped horses and armed men. Then Sir Guy went to the road that leads up the mountain, and he determined that he would not let any man pass him on that road; and the army of the city of Constantinople from this time forth was to defend the narrow passes that led up the mountain. The Sultan bade Eliman of Tyre lead the attack — ‘For there is no man in the world who has overcome thee in battle or in combat’;[115](javascript:footNote('T306000/note115.html')) and he was a noble brave king. So Eliman of Tyre came to the entrance of the road, and a thousand fierce, valiant knights along with him, and they fought a bloody,





---

p.136






violent and venomous battle with each other, until the thousand brave, fierce knights fell by Guy's fearful, perilous blows. Anger and true rage seized Eliman of Tyre, and he said that he would not desist until Sir Guy and his company should fall at his hands in payment for his own company. Then Sir Guy and Eliman of Tyre fought with each other courageously and spiritedly, savagely, fiercely and implacably, and Sir Guy gave Eliman of Tyre a strong, bold blow with his spear, and drove it out through his body backwards so that he fell dead, without life.


The Sultan said to the king of Nubia: ‘Dost thou see my men being slain at the hands of a single knight, and that we are a hundred gallant and noble knights put down by the knight of those who are against us? And do thou take my followers with thee, and surround the enemy there, and bring death and destruction upon them, for I shall have no happiness or rest until mischief is wrought for them there.’ And after this they went together against Sir Guy, and he withstood them alone, and began to kill and destroy them without cessation; and the horse was killed that was under Sir Guy, and his shield was broken. And then he bared his sword, and the sword was of this sort: it is among the Nubians that it was made, and it is in Germany {Ir. ed. page 57} that Sir Guy got it, and quaking and terror came upon him who saw it naked before him, and he whom it wounded tasted not of life.


As for Sir Guy, then, he was killing and injuring the Saracens with that victorious, hard sword, and he was collecting and arranging the wounded bodies around him to defend himself against the missiles of his enemies. As for Sir Guy, then, he ordered a great number of slings to be made and missiles to be thrown from them all in every direction; and in this way very many of the Saracens were mercilessly slain. And it was hard for Guy at this time, and he sent a messenger to ask Sir Heront to help him out of that danger. Then came Mirabala,[116](javascript:footNote('T306000/note116.html')) who had been newly made a knight on that day, and fought bravely, manfully and heroically against Sir Guy, and at the end of the fight Sir Guy dealt Mirabala a strong, savage blow, and inflicted a dangerous wound upon him, and Mirabala got away then by virtue[117](javascript:footNote('T306000/note117.html')) of his spear-swift running. As for Mirabala, then, he went on to meet the Sultan, and told him to take a strong, swift horse, and to flee quickly from the battle, — ‘and I shall not live myself’, said he, ‘with my limb cut off, and it is little that remains of thy army.’ Then the Sultan saw the loss of his army: twenty-eight score of thousands. His dark and devilish gods were watching over him on that day, Termagant and Mahoun, and he said to them: ‘O false and lying gods’, said he, ‘much have I ever done in your honor and





---

p.137






worship and it is ill that ye have treated me today.’ Then he seized a great stout club and set upon them madly; and the Sultan left the battle at that time, and all that survived of the followers along with him.


Sir Guy, moreover, came back to Constantinople with his company after winning the victory and the triumph. Sir Guy said: ‘Noble and adventurous knights, honor and magnify the one God who formed heaven and earth, he who made the creatures out of nothing, for it is He who brings us victory in the battles and the many conflicts in which ye are, and it is good help He has given {Ir. ed. page 58} you today’, said he. Thus far the second battle which Sir Guy fought with the Sultan.


#### 22


The treacherous, envious and horrible steward said to the emperor: ‘My lord’, said he, ‘though many of the hosts of the Sultan have fallen before thee, they are but few in comparison with those whom he has still alive; and he is angry and bitter against thee; and thou hast the one knight whose deeds and whose rank are the greatest in the whole world; and do thou stake thy right and thy claim upon a single combat with the Sultan; and if it goes against thee, give the Sultan satisfaction and show him honor; and if it goes against him, let the same be given you by him.’ And the emperor praised that plan. And this is the reason why the steward gave this counsel to the emperor, because it would be Sir Guy who would go out there and who would be killed there. The emperor collected and gathered together his followers from every direction, and he explained this plan to them. The duke, namely the head of the army and the constable of the city, said: ‘I am a hundred years of age’, said he, ‘and if I were able to fight, I would go on that business and that errand. But I should not come out alive; and the curse of the weak and the strong[118](javascript:footNote('T306000/note118.html')) be upon him who gave thee that counsel, for it is bad counsel.’ Yet the emperor still sought a knight to go to the emperor of the Turks with that message, and everyone there refused to go.


*As for* Sir Guy, now, his eyes flamed brightly and angrily in his head; and Sir Heront understood the reason, and came to Sir Guy, and said to him: ‘Sir Guy’, said he, ‘I know what is in thy thought; and do thou cease considering that, for thou wilt not come back alive from the land of the Sultan if thou goest into it, since his enmity against thee is great. And send me’, said Heront, ‘for my death is a small matter in comparison with thine.’ Sir Guy said: ‘God forbid that I should send my knight to his death to get honor for myself.’ Then Sir Guy rose to the his feet, and put on strong armor of battle, and went into the presence of the emperor, and took leave of him. The





---

p.138






emperor said: ‘The true God, most glorious, who made heaven and earth, forbid that thou shouldst go into so great danger as that!’ ‘I will surely go there’, said Guy. ‘We will go with thee’, said Sir Heront and the three knights. ‘We are of thy retinue.’ ‘No man shall go with me’, said Sir Guy.


And after this he set out alone; and he was not long journeying on the {Ir. ed. page 59} road when he saw the emperor's host in camp; and fifteen miles was the length of that camp, and the same distance it breadth, and they were ranged in a circle like a sphere or compass and the stakes of the tents standing side by side(?)[119](javascript:footNote('T306000/note119.html')). Now the Sultan's tent was in the very middle, and a great spear-shaft rising out of it, and the figure of an eagle, of beautiful, red refined gold, on the top of the shaft; and a carbuncle — that is a precious stone — high above the tent; and a fair summer's day was not brighter for them, and the sun with bright face at hand than were the long winter nights with the virtues *of that stone*: And thus were the Sultan's tents, covered magnificently with cloths of silk and gold thread from the top to the ground.


Sir Guy, now, rode into the tent on his horse; and it is thus that the Sultan was at that time, eating and drinking at many-colored tables with the nobles of his retinue. Sir Guy said: ‘God almighty suffered the passion for the sake of the righteous, and separated day and night from each other; and it is He who made cold and heat, and brings full-tide and ebb-tide upon the seas, and made the world and all things besides, and made every good for thy profit, O Sultan, sinful, false and recreant, — for evil are the devilish gods in whom thou believest, and thy bed is flaming in lower hell. And my lord emperor sends *word* to thee to choose a day for combat, and one knight from thy side and another knight from the emperor's to be there; and whichever of them survives the fight to receive money and tribute for his lord without resistance or strife from the lord of him who is overthrown in the combat. And if it please thee, here am I ready for the battle, and I would come on behalf of the emperor and the right, to prove upon thy champion that the wrong is with thee.’ ‘What is thy name?’ said the Sultan. ‘Sir Guy of Warwick is my name’ said he. ‘It is thou who killed my brother’, said the Sultan ‘and thou shalt die for it[120](javascript:footNote('T306000/note120.html')) thyself.’ And the Sultan gave orders to seize Guy full quickly, and to put him in prison as a bound captive while they were eating their feast. Guy said: ‘If it is killing me without reason that pleases thee’, said he ‘I will give thee cause for killing me.’ And he spoke thus, and stuck two spurs {Ir. ed. page 60} at once into the horse that was beneath him, and made a great, strong leap away, and drew out his bright, hard sword, and struck the Sultan a death-blow,





---

p.139





strong and savage, so that he separated his head from his body; and after that he picked up his head, and placed it in the [*...*][121](javascript:footNote('T306000/note121.html')) of his shield. As for Sir Guy, then, he set out after this exploit, and a cry was raised after him on the east and the west and on the north and the south, and Sir Guy was cutting down and slaying the warriors around him. Then they seized him by the bridle, after they had surrounded him, and they killed the steed that was beneath him, and it was the driving of a flock of birds[122](javascript:footNote('T306000/note122.html')) that he wrought upon them, cutting off their heads and their feet. As for Sir Guy, moreover, he advanced toward a round-topped, rocky hill, and in spite of them he got to the top and summit of the hill; and he began to throw down the huge rocks upon the warriors full mightily; and whoever reached the place, Guy killed him with one stroke of his sword, and he made a great cairn of the bodies of the soldiers and warriors round about him for his defence. And there fell before him thirteen hundred of them at that time. Then two thousand very brave knights of the army surrounded him, and they discharged a swift shower of arrows upon him at that time, and they pierced the body of the valiant fighter with sharp-tipped, easily hurled lances, and with sharp, terrible, dangerous javelins, and with every other missile besides. And Sir Guy at that time was like the fierce wild boar of the wilderness torn to pieces among the hounds, — wounded by every keen, bold thrust that was given him without restraint; *and* not one of the enemy escaped without heavy injury from Guy's perilous, terrible strokes. And yet he did not have strength to guard and protect himself at that time against the heavy fighting that was prostrating him and overwhelming him.


Sir Heront was in deep sleep in the city of Constantinople, and he saw a terrible vision, as it were a field full of lions around Sir Guy, and Guy being slain in the midst of them. At this Sir Heront sprang up from his sleep, and summoned his followers to him, and said that Sir Guy was in difficulty and overpowered by numbers; and he set out full quickly, and the three hundred knights along with him, and they found Sir Guy in the midst of the hosts {Ir. ed. page 61} being beaten and lacerated. As for Sir Heront now he burst upon the hosts strongly and valiantly, and seven hundred strong, brave warriors fell before them in that charge. And from the sea of sand in the south to the fiery sea in the north[123](javascript:footNote('T306000/note123.html')) there was not a Saracen 





---

p.140






capable of fighting who was not in that one army. And the all fled at that time before Sir Guy and his followers, and *Guy's men* wrought great slaughter upon them at that time. Sir Guy came, moreover, with the meed of victory and triumph with plenty of booty, and laid the head upon the ground in the presence of the emperor.[124](javascript:footNote('T306000/note124.html')) Such was the end of the war between the Sultan and Sir Guy.


#### 23


As for the emperor, on the next day he went to the hunt with his retinue, and he was sitting on the top of a hill and Sir Guy in his company there; and they were not there long before they saw a lion, sharp-toothed and full brave, and a dragon, bold, dark and unconquerable, in struggle and conflict with each other; and the lion was weak and lame, and the tail of the dragon coiled around the lion, and the horrible, dark yawning[125](javascript:footNote('T306000/note125.html')) jaw of the dragon opened so that a knight with his armor on could enter its mouth. Sir Guy said that he himself would go quickly to the help of the lion, for it was weak in the fight, and he said that no one should dare to go with him into that fight.


When the emperor heard this he fled with his followers for fear of the dragon. Sir Guy mounted his steed, and spurred the horse against the dragon, and gave the dragon a strong, bold blow of the spear in its mouth, and drove the spear out through the back of its head, and jumped down upon it, and struck off its head. The lion came to Guy, and was licking his feet and his fair body, and Sir Guy stroked the lion's back with his hand, and the lion followed him thereafter everywhere that he went. One day when Sir Guy was eating his meal at the emperor's table, the lion was asleep in the arbor that day at the foot of a tree, and its tail up towards the sun, and the emperor's steward saw it lying thus, and gave the lion a mighty thrust with his spear, and pierced it, and let out its vitals and its entrails at its feet. The lion howled and roared loudly, and went to Sir Guy and crouched {Ir. ed. page 62} at his feet, and its vitals outside of it, and it fell down thereupon, and dropped dead, without life. As for Sir Guy, then, he took his steed, and





---

p.141






mounted it and seized his sword, and went *to* the emperor; and he asked everyone who had killed his lion, and he did not find out from anyone. As for Sir Guy, he said that if anyone find could tell him who killed the lion he would give him his reward, two thousand pounds of beautiful, refined gold; and he did not find it out then. Then a female slave, one of the attendants of the emperor's daughter, came to Sir Guy and told him that it was the emperor's steward who had killed the lion, and told him how it was killed. When Guy heard this, he proceeded to the chamber where the steward was, — and his brother at that time in the chamber with him. Sir Guy said: ‘Steward’, said he, ‘I never yet have done thee harm or injury; why didst thou kill my lion without cause?’ ‘I did not kill it’, said the steward. ‘Thou didst surely’, said Guy. ‘And thou hast deceived me twice before, and thou shalt not do it the fourth time to me or to anyone else.’ And he spoke thus, and gave the steward a fierce strong, evil, deadly blow, so that he made two pieces of him just equal in weight and size. Now the steward's brother drew out a keen-edged sword, and gave Sir Guy a mighty stroke; and Sir Guy struck a strong, bold blow, and cut off his right hand at the shoulder, and let him go thus disfigured. When the emperor heard this news, he said that Guy had killed the steward justly, and that he had deserved death before this at Sir Guy's hands.


#### 24


As for the emperor, then, he said to Sir Guy: ‘Great is the benefit thou hast done me, and I do not know how to describe it for its greatness; and be ready tomorrow morning to marry my daughter; and thou shalt have half my kingdom during my life, and the whole of it after my death.’ Dixit Guy: ‘I will do thy will, my lord’, said he. When the morrow came, Sir Guy went and his three hundred knights with gowns of silk and fur (?)[126](javascript:footNote('T306000/note126.html')) about them; and they went to the church and there came the bishop of the city and his clergy, and they asked Sir Guy whether he had a wedding-ring. Sir Guy opened his pouch, and this is the ring that came to his hand, the ring that had been as a token of remembrance between him and the daughter of the Earl of Warwick; and he meditated upon it then and a swoon and a fainting-fit came upon him.


And when Sir Guy arose from his swoon, he said: {Ir. ed. page 63} ‘My lord’, said he, ‘I am not now able to be married, for the pressure of heavy illness has attacked me; and do thou give me time to regain my health.’ Sir Guy was fifteen days in bed, and he allowed no one to approach him during that time but Sir Heront alone. Sir Guy

 



---

p.142






said to Sir Heront: ‘Heront’, said he, ‘what shall I do with regard to the emperor's daughter? For I have a great unendurable love for the daughter of the Earl of Warwick; and thou knowest that this is true.’ Sir Heront said: ‘I know’, said he, ‘that the emperor's daughter is the woman of fairest form and figure in the whole world, and that thou wilt get the empire along with her; and if it were the daughter of the earl that thou shouldst marry, the wealth thou wouldst have would[127](javascript:footNote('T306000/note127.html')) be no more than the earldom.’ Sir Guy said: ‘I understand from this, Sir Heront, that thou art displeased with me for not taking the emperor's daughter. And dost thou know, Sir Heront’, said he, ‘that it was from love and affection for the daughter of the Earl of Warwick that I did what I have done of bold and brave deeds, and was once at the point of death besides?’ Dixit Sir Heront: ‘I did not know that; and since now I know,[128](javascript:footNote('T306000/note128.html')) I hold her to be better for thee.’


Sir Guy got up after fifteen days, and went thereupon to the emperor; and the emperor was glad that day to see Sir Guy well. And Sir Guy passed that day in the emperor's company. And Sir Guy said to the emperor: ‘My lord’, said he, ‘I cannot take thy daughter to wife, for there is a pledge between me and the daughter of the Earl of Warwick, and I would not change it till the time of my death; and I have been with thee seven years, and now I would fain have leave to depart.’ Greatly did this grieve the emperor and all the hosts of the city. Then the earl[129](javascript:footNote('T306000/note129.html')) gave Guy three great measures of beautiful, refined gold, since he did not take any other lordship from him. And Sir Guy refused to take that, and said that he had plenty of gold and riches, and that it was not to seek anything else that he had come, but only to help the emperor. When Sir Guy did not take the gold, the emperor distributed it to Sir Guy's company. Then the emperor said: ‘Sir Heront’, said he, ‘thou art the other knight who is strongest of hand of all I have seen, — Sir Guy of Warwick and thou. And since Sir Guy has refused the damsel for his wife, {Ir. ed. page 64} I would give thee lordship and riches and treasure, O Sir Heront’, said he. Heront said: ‘If thou wouldst give me the whole empire’, said he,‘I would not take it from thee and desert Sir Guy.’ Then Sir Guy took leave of the emperor, and thereafter he departed. Thus far the adventure of Sir Guy with the Emperor of Constantinople.


#### 25


As for Sir Guy and his followers, they proceeded on their way and they made no stop or delay until they came the city of Cologne in Germany. The emperor with his retinue 





---

p.143






bade Guy welcome, and showed them great honor, and offered Guy treasure and lordship, and Guy refused it, and said that he would not delay until he should come to England. And after this he went onward, and he saw an impregnable city before him at the hour of evening prayer. And Sir Guy said: ‘Sir Heront,’ said he ‘take the knights with thee, and enter the city and find a hostelry for us; and I will remain here a while to say my prayers and to listen to the song of the birds.’ And they did so.


As for Sir Guy, then, he was not long walking in the forest when he fell asleep from the song of the birds; and this is what woke him out of his sleep, a fearful cry of distress that he heard. And he went where he heard the cry, and found a wounded knight, complaining and in peril, and his blood flowing down the steep places of the forest. Sir Guy asked him his story. The wounded knight said: ‘It will not profit thee to have my story’, said he, ‘for it is not likely thou hast the courage to hear my story,[130](javascript:footNote('T306000/note130.html')) and my expectation does not turn to thee for help’[131](javascript:footNote('T306000/note131.html')) Dixit Guy: ‘For the sake of the one God almighty, tell me thy own story’, said he, ‘and I will give thee aid, if I can.’ Dixit the wounded knight: ‘Pledge thy troth’, said he, ‘that thou wilt help me.’ ‘I do’, said Sir Guy. The knight looked up and said: ‘Great thanks to thee for any help’, said he, ‘for thou art a strong, brave knight; and before God who made heaven and earth, it is a pity that thou art not Guy of Warwick.’ ‘Tell me now thy story’, said Guy. ‘I will’, said the knight. ‘I am Sir Tirri, the son of Earl Aimbri; and the daughter of the Duke of Lorraine felt a strong, unendurable love for me, and I felt the same for her; and Otun, the Duke of Lombardy, came to take her; and a day was set for their wedding, namely the seventh day from today; and she sent to me to come for her {Ir. ed. page 65} in that time. And I came’, said he, ‘secretly with ten very brave knights to the city of the Duke of Louvain; and I sent messengers to the damsel and she came out to them in the bright, early morning. And I set her behind me and left the city; and the people of the city saw me setting off and raised a cry after me, and the two dukes pursued me with their hosts, and my ten knights fell before them at that time. And there fell at my hands a bold destructive band of this army; and there happened to be a great-waved arm of the sea in front of me, and I made an eager, light leap on my horse out into the sea, for I chose to be drowned in the sea than to fall at the hands of the Lombards. And the daughter of the Duke of Lorraine chose rather to be drowned than be the wife of the Duke of Lombardy. And the steed





---

p.144






brought us to land, and they could not pursue us in the water, and we came to this wood; and I was weary and heavily wounded, and I put my head on the woman's bosom and told her to keep watch, and that it was necessary for me to have sleep and long slumber. And a fit of sleep and long slumber fell upon me, and fifteen knights came against me and drove their their five *fifteen?* spears through my body, and took my wife away from me, and they are in a small tent in the midst of the forest.’ Dixit Sir Guy: ‘I am in bad plight to go against them’, said he, ‘for I have no arms.’ Tirri said: ‘My sword is in the shadow of the oak yonder at thy disposal’[132](javascript:footNote('T306000/note132.html')) said he. Then Sir Guy seized the sword, and went into the tent and said: ‘Noble knights, why did you slay the son of Earl Aimbri?’ said he. One of them said: ‘Thy honor will not be better,’ said he, ‘for the same shall be done to thee.’ Then Sir Guy bared the sword, fierce and warlike, and the fifteen men fell before him except a single knight from whom he struck off one hand, and who made his escape. And Sir Guy brought the daughter of the Duke of Lorraine and Sir Tirri's horse with him to the place where he had left the wounded knight, and he found nothing there but the place where the knight had been. As for Sir Guy, then, he left the daughter of the Duke of Lorraine there, and went in search of Sir Tirri; and he had not gone far {Ir. ed. page 66} when he saw four very brave knights carrying Sir Tirri on a long, firm bier, and Sir Guy asked them for an account of themselves. One of the men said that it was Sir Uighi, the Duke of Lombardy's brother, that was there, and three knights along with him. ‘And Sir Tirri, the son of Earl Aimbri, is in our hands, to be taken to the Duke of Lombardy for his execution.’ Dixit Sir Guy: ‘Give him up at once’, said he, ‘for he is a dear friend to me, and I will not leave him with you any longer’. One of them said turning to him: ‘We will take thee and Tirri with us, so that ye shall both have one cruel death.’ As for the two knights who had turned to meet him, he struck off both their heads. Dixit Sir Uighi, the own brother of the Duke of Lombardy: ‘Foolish and ignorant young man’, said he, ‘thou art a poor compensation for the deed thou hast done, but thou shalt die for it.’[133](javascript:footNote('T306000/note133.html')) And he fought quickly with Sir Guy, and Sir Guy struck off his head with one blow, and struck off one hand of the fourth knight, and that was his appearance as he went to meet the Duke of Lombardy. After this Sir Guy set Tirri on a horse and brought him back to the spot where he had left the daughter of the Duke of Lorraine, and he found





---

p.145






nothing but her place there. As for Sir Guy, then, he brought Earl Tirri with him into the city, and put him in a hostelry, which Sir Tirri had taken for him.[134](javascript:footNote('T306000/note134.html')) At that time Sir Guy heard a cry and lamentation, sorrowful and wretched, and asked the cause of that complaint. Sir Heront said: ‘Since it seemed long to me not to see thee till night, I came into the into the wood to seek thee, and I found a damsel, fair and resplendent complaining pitifully; and I brought her with me, and it is she who is uttering the cry that thou hearest now; and it is she who was there, namely the daughter of the Duke of Lorraine.’ And Sir Tirri's heart was cheered when he heard this although he was weak. And after this he was treated and became well. Then Sir Tirri remained with Sir Guy, and they became sworn brothers one with the other. And that was the first bond between Sir Guy and Sir Tirri.


#### 26


One day Sir Guy, with his breast against the chamberwindow, was observing the city about him, and he saw a knight approaching, and a swift horse under him, and Guy asked news of him. The knight said: ‘I am of Earl Aimbri's company’, said he, ‘and I am searching for his son, Sir Tirri; and I do not get a word of news about him, and I do not know if he is alive. In revenge for the way he carried off with him the daughter of the Duke of Lorraine, the Duke of Lombardy and the Duke of Louvain {Ir. ed. page 67} are pillaging and destroying the possessions of Earl Aimbri; and he[135](javascript:footNote('T306000/note135.html')) has destroyed it all except Aimbri's city alone, and those two haughty dukes are going to the city of Gormisi[136](javascript:footNote('T306000/note136.html')) to capture it; and that is *my news*’, said the knight. Dixit Sir Guy: ‘Dismount’, said he, ‘and thou shalt stay with us tonight, for it is with us that thou art more likely to get news of Sir Tirri.’ After that the knight came in, and he found Sir Tirri before him, brave and joyful, and he paid him homage and respect. Then Sir Tirri said: ‘Guy’, said he, ‘though thou hast given me much help and great honor hitherto, I have more need of thee more than ever before, for   
[*gap: text omitted*]  
 to plunder and pillage my father and to rob and insult *him* on my account.’ Dixit Sir Guy: ‘I will bring the strength of my hand to thy aid’, said he. After that Sir Guy went into the city and collected ten hundred bold knights. And they advanced thereupon to the city of Gormisi. And Earl Aimbri and his followers paid homage and honor to Sir Tirri. Sir Tirri said: ‘It is better to pay honor and respect to Sir Guy of Warwick than to me’, said he, ‘for it is he who saved my life for me, and it is in his retinue that I am.’ When the earl and his company heard that, they





---

p.146






paid honor to Sir Guy. Then they heard a shout and a clamour and cries

 of distress and helplessness throughout the whole length of the

 city. And Sir Guy asked the cause of those shouts, and somebody told

 him that it was the crafty, bold hosts of Louvain, and the numerous,

 brave warriors of Lombardy, who had come to capture the city of

 Gormisi. Dixit Guy: ‘Sir Tirrui’, said he,

 ‘take with thee two hundred knights, of thy company, and give them

 brave, victorious battle there, and let us have good knowledge[137](javascript:footNote('T306000/note137.html')) of thy bravery and prowess in the day's fighting

 to-day.’


As for Sir Tirri, then, he went boldly and valiantly to meet those battle-brave warriors and ten hundred soldiers, fierce and bold and proud-hearted, were set against him, and they fought each other madly, eagerly and savagely. Ten bold warriors fell at Sir Tirri's hands in the first onslaught, and not long afterwards {Ir. ed. page 68} two hundred, discomfited and wounded, fell round about him. After this a thousand fierce, proud knights were set to fight against him, and Sir Tirri fought the battle anew at that time, and six hundred of them fell quickly before him. Then two thousand knights, heroic and hardy, were set to fight against Sir Tirri, and Sir Tirri was in the battlefield from bright, early dawn until mid-day without having help from anyone but himself and his two hundred knights, and it was hard for him then because of the number of the Lombard warriors about him. Sir Heront said: ‘Guy’, said he, ‘let us bear[138](javascript:footNote('T306000/note138.html')) aid and assistance now to Sir Tirri.’ ‘We will’, said Guy. Then Sir Guy with his two hundred knights went to Tirri's aid, and Guy said to him: ‘Tirri’, said he, ‘give up the fight now, and go into the city, and leave the battle to me for the rest of the time.’[139](javascript:footNote('T306000/note139.html')) Thereupon Tirri went into the city, wounded and victorious in battle, and Sir Guy went into the fight, fiercely and resolutely,[140](javascript:footNote('T306000/note140.html')) and burst upon them like a lion, eagerly and bravely. Sir Guy, moreover, was fighting that battle fiercely and valiantly from midday until night, and the length of the night without cessation cutting down the warriors, until sunrise of the next day and the length of the second day until noon; so that at that time there did not remain alive any of them except sixty of them as prisoners, bound and fast fettered, and twenty more maimed and injured, cross-wounded and deadly pale(?),[141](javascript:footNote('T306000/note141.html')) to go to the two dukes with the news. One of them





---

p.147






said: ‘It is an evil place in which ye put us’, said he, ‘for not a fugitive of our number escaped alive except only twenty of us, wounded and scarred and mutilated, with the loss of limbs and of strength.’ Anger and great rage seized the Duke of Lorraine on hearing this news, and he asked who did these great deeds. The messengers said that there were three columns of defence and pillars of valor who had done it, namely Guy of Warwick, terrible and valiant, from the noble, fair land of the English and Sir Tirri, strong, powerful and contentious, the son of Earl Aimbri, and Sir Heront, brave and high-spirited, the resolute warrior. The Duke of Lombardy said: ‘I had rather {Ir. ed. page 69} come upon those three in the city of Gormisi than have a great part of the wealth of the whole world; and I will surround them’, said he, ‘to-morrow in the bright, early dawn of the morning.’ As for Sir Guy, after the truimph and victory in that battle, he came back to the city of Gormisi with the honors of the adventure and with booty. And this was the end of that battle.


#### 27


As for Sir Guy, on the next morning he went to hear mass, and left the church afterwards, and saw the companies and detachments of a good army approaching the city. Sir Guy said to Tirri: ‘The strong, brave hosts are coming against us, and let us go out on the smooth plains and into the open country to fight and give them hard battle.’ They went at once, and they fought a long, brave battle with each other. Then came the strong, brave Duke of Lombardy and Sir Heront together in the battle-field, and Sir Heront said: ‘Envious and fratricidal duke’, said he, ‘thou hast unjustly deceived me and my lord.’ And he spoke thus, and gave the duke a hard, bold blow, so that he knocked half of the helmet, set with jewels and tight-bound,[142](javascript:footNote('T306000/note142.html')) from the duke's head and he made a wide deep wound in his shoulder, and threw him violently to the ground, and leaped down upon him to cut off his head. And then came a hundred brave Lombards between them, and took the duke away from Sir Heront, and Sir Heront pursued him through the troop. Then numerous warriors of Lombardy collected about Sir Heront, and killed his horse, and his sword was broken. And then a manly, valiant French knight, who was in the retinue of the Duke of Lombardy, came up and said: ‘Sir Heront,’ said he, ‘give thyself up to me now, for thou hast no strength to defend thyself.’ ‘What is thy name?’ said Heront. ‘Sir Gailiard is my name,’ said he. Sir Heront said: ‘I would give myself up to thee, if thou wouldst give thy pledge to save me.’ ‘I give it’, said Gailiard. Then Heront gave himself was taken in captivity to the duke. Then Sir Guy





---

p.148






asked for news of Sir Heront, and someone told him that he saw him taken captive. Sir Guy said: ‘Tirri,’ said he, ‘let us follow Sir Heront, for I shall not find a better time to release him than now.’ And they followed him quickly, and they did not overtake him till he had been brought into the city. Then Sir Gailiard turned upon Guy, and they fought a fierce, terrible battle with each other, and Sir Guy gave Sir Gailiard a keen thrust with his spear. {Ir. ed. page 70} Sir Gailiard said: ‘Sir Guy’, said he ‘give me my life, and let me be thy man; and it is I who saved Sir Heront from his death’ said he; ‘and if I can, I will bring him back with me.’ And he pledged his word to that, and obtained his life. As for Sir Gailiard, after this he proceeded to the Duke of Lombardy, and asked him for Sir Heront, to give him back to Sir Guy, and the duke refused him this. Gailiard said that he would go to fight and make war with Sir Guy against the duke because he would not give up Sir Heront to be sent back to Guy of Warwick, — ‘and I will grant thee no delay but tonight only before I go to accomplish thy destruction.’ Then came another knight of the duke's followers to fight with Guy, and they waged a battle, fierce, angry and heroic, with each other, and Sir Guy gave the knight a very keen thrust with the spear, and threw him to the ground, and leaped down upon him to behead him. The knight dixit: ‘Guy’, said he, ‘grant me my life, and I will bring thee a good hostage for myself, namely Sir Heront.’ ‘If thou wouldst pledge thy word to that’, said Guy, ‘I would give thee thy life.’ Then he gave *the pledge*, and obtained his life, and proceeded to the Duke of Lombardy, and asked for Sir Heront to give him back to Sir Guy, and he obtained this at once; and Sir Guy rejoiced at Sir Heront's coming.


Then the Duke of Lombardy with his company pursued Sir Guy, when he saw him alone without a host, for there was no one with Sir Guy at that time but Sir Tirri and Sir Heront. Sir Guy spurred his steed through the very midst of the Lombard host, and neither Tirri nor Sir Heront expected ever to see him; and the Duke of Lombardy met Sir Guy on that battle-field, and he gave the duke a strong, hard, violent blow, and the duke bent before that blow, and the back part of his helmet was struck off him, and Guy pierced the armor on his back, and through it he cut his fair golden garment and the strong-limbed gelding[143](javascript:footNote('T306000/note143.html')) with a single blow; and *Guy* escaped from them in spite of him, and put the banner of St. George on a staff, and he would fain have attacked the army. The Duke of Lombardy said: ‘The men yonder have done us much harm today’, said he, ‘and they have now attacked





---

p.149






us long and bravely, and let us avoid them, and go to the city of Pani for we are not able to defend ourselves today(?)’,[144](javascript:footNote('T306000/note144.html')) said he. Sir Guy came back to the city of Aimbri with abundance of all kinds of possessions {Ir. ed. page 71} after having won the victory of the enemy. After the Duke of Lombardy got up from his illness, he came to the Duke of Lorraine, and said to him: ‘Duke of Lorraine’, said he, ‘Sir Guy of Warwick and Sir Tirri will take thy realm from thee; and they will do the same to me, if they can; and do thou follow my advice’, said he: ‘send messengers to Sir Tirri and Guy of Warwick, and promise to make an alliance with Tirri and peace with Earl Aimbri and Sir Guy; and say that thou hast a wedding-feast for them. And I will be with my followers in our strong battle-armor in concealment near you; and we will capture Tirri and Sir Guy and Sir Heront; and Sir Tirri and Sir Guy and Sir Heront shall be bound prisoners in my hands, and Earl Aimbri with his followers in thy hands; and do what thou wilt with them.’ The Duke of Lorraine said that he would never betray Sir Guy, ‘for I am under great obligation to him’, said the duke. Dixit the Duke of Lombardy: ‘It was not in earnest that I said that then’, said he. ‘Howbeit, take them to thee and make peace with them.’ Thus the Duke of Lombardy planned treachery against Guy.


#### 28


As for the Duke of Lorraine, then, he sent a bishop of high rank to Earl Aimbri with his followers, and promised them peace and an alliance, and *said that* a banquet, long and bountiful, was prepared for them. Earl Aimbri rejoiced at these words. Dixit Sir Guy: ‘Earl Aimbri,’ said he, ‘believe not those sweetly-false, pleasant words. Duke Otun has betrayed me twice before, and it is he who is counsellor to the Duke of Lorraine, and I would believe that he would do it the third time if he could.’ Dixit Earl Aimbri: ‘Sir Guy’, said he, ‘have no fear or terror, for we do not desire peace with the two dukes there more than they desire it with us, and they will not betray us.’ Sir Guy said: ‘If you go there’, said he, ‘take strong battle-armor with you.’ Dixit Earl Aimbri: ‘We will not take it’, said he; ‘if we go to make peace, there should not be a challenge to battle upon us.’ Then Earl Aimbri went with his followers to the castle of the Duke of Lorraine, without weapon or armor, but with splendid gowns of silk and fur about them. Then they saw the Duke of Lombardy coming toward them with an army, armed and equipped, which took captive Tirri and Heront and the rest of the company besides. As for Sir Guy, he was strong and bold in the midst of the enemy, smiting them

 



---

p.150






bravely with his fists and his elbows. And he seized a stout, strong club out of the hands of one of the knights, and dealt him a blow with it so that {Ir. ed. page 72} he fell before him. Sir Guy saw a knight coming against him, and a very fine steed beneath him, and Sir Guy said to him: ‘If thou wouldst give me that horse under thee’, said he, ‘I would help thee yet, if I should live.’ ‘I swear by my God that thou shalt have it’, said the knight leaping down; and Guy mounted it instantly and sped bravely away among the hosts, and two knights fell full quickly at his hands, and he gave their horses to the knight who had given him the steed before. As for Sir Guy, then, many brave knights of Lombardy collected around him, and he made for himself a path through them, crowded and clamorous;[145](javascript:footNote('T306000/note145.html')) and the Lombards pursued him, and there chanced to be a deep stream before him, and he took an eager, bold leap on his horse into the river, and passed over the stream; and there escaped of his company, without being captured or killed, only Sir Guy and Sir Gailiard. Thus far the account of the treachery. The Duke of Lombardy took Sir Tirri with him in bonds, and the Duke of Lorraine took Sir Heront and the other prisoners away.


#### 29


As for Sir Guy, then, he went to Earl Aimistir Amunndae,[146](javascript:footNote('T306000/note146.html')) and the earl made Sir Guy welcome. Dixit the earl: ‘Sir Guy’, said he, ‘I am thine, and all my possessions.’ Then Sir Guy told how he had been betrayed, and how Earl Aimbri and his son Sir Heront had been taken, and all the hosts besides. Earl Aimistir made complaint and heavy lamentation at this news. Sir Guy was in the city three days, sad and melancholy, and he said: ‘Earl Munndae,’ said he, ‘it is sad for us to be like this.’ Earl Munndae said: ‘There is a great,[147](javascript:footNote('T306000/note147.html')) rich city near us here, and it is said that the third part of the world is in its possession. And the Turk, mighty and powerful, is lord and chief there; and no man ever went against him who came back afterwards alive; and single combat or double is held there, or the number that anyone desires.’ Sir Guy said that he would go himself into that city. ‘Do not go’, said Earl Aimistir, ‘for thou wilt not come back from there alive over the same road.’ Sir Guy said: ‘I would not fail to go there for an abundance of wealth, and I will not take any man with me.’ ‘Indeed I will go with thee’, said Gailiard, ‘for I will not leave thee till the day of my death.’ They went on their way then into the forest, and Sir Guy blew a strong, powerful blast on





---

p.151






the end of the bugle that hung at his neck. When the Turk heard this, he said in anger and in great wrath: ‘Who would dare to make this havoc[148](javascript:footNote('T306000/note148.html')) in my forest?’ said he. {Ir. ed. page 73} A knight of the Turk's company went to Guy, and told him to come into the Turk's presence. 

Sir Guy came to the Turk. The Turk said to him: ‘Knight’, said he, ‘it will prove to be no time of luck or fortune *for thee* that thou didst blow the blast there on the end of the bugle’, said he. Sir Guy said: ‘I did not know’, said he, ‘that there was harm in blowing the blast there, for I was not hunting deer or game, but only myself astray and seeking information.’ There was a very strong steed under the Turk, and Sir Guy said: ‘Rich and prosperous lord, give me that steed under thee’, said he. The Turk said he would not give it, but that he would give him instant death. Sir Guy said: ‘My lord’, said he, ‘it is not warlike of you to kill without mercy two knights who have come into your power; and if it seems best to thee to make trial of us in our arm or, send thy choice of two knights from thy company to fight against us.’ ‘Who art thou thyself?’ said the Turk. Sir Guy said: ‘I am a well-known English knight’, said he, ‘and Guy of Warwick is my name.’ As to the Turk, he gave Guy a good welcome and said to him: ‘Thou hast done a good thing for me before this’, said he, ‘for Duke Otun's brother fell at thy hands, who has done me injury before now. And the good horse shall be thine, Guy’, said he, ‘and there is not in the world altogether a horse equal to it; and if I had three like it, thou shouldst get them.’ The Turk gave another fine horse to Gailiard in Guy's honor. Guy thanked the *Turkish* lord for that present, and they went on to meet Earl Munndae. Thus far Sir Guy's adventure in the land of the Turks.


#### 30


As for Sir Guy, after he had been nine days in the company of the earl, he said: ‘It is a long time’, said he, ‘that I have been without going to get news of Sir Tirri and Sir Heront; and I am afraid they are slain, and I will go now to find out.’ Earl Munndae said: ‘I will send ten hundred knights of my company with thee.’ Guy said that it would delay him long to wait for them, and that he would not take anyone with him. ‘I will go with thee’, said Sir Gailiard. And they went on their way then, and Guy said to Gailiard: ‘Mount thy horse’, said he, ‘and take this good horse beside thee’; and Gailiard did so. As for Guy, now, he rubbed black *stain* {Ir. ed. page 74} on them both, and put a black, dingy, unrecognisable color on them, and in that shape they went to meet the Duke of Lombardy. Guy said: ‘It is a long way, I have come to thee out of the land of





---

p.152






the blue men’,[149](javascript:footNote('T306000/note149.html')) said he; ‘and I have heard that there is not in the world a stronger hand than thine, or a duke who is richer than thou art. And I have brought thee the one best horse in the whole world to sell him to thee; and he has no fault but one, namely, that he will not suffer a driver to manage him except the one driver who has known him well.’ ‘What is thy name?’ said the duke. ‘Gebun Marcel[150](javascript:footNote('T306000/note150.html')) is my name’, said he, ‘and George the gillie.’ ‘Welcome is your coming to me’, said the duke; ‘and I had rather have had that horse than many riches when I captured the prisoner that is with me; for if I had, Sir Guy of Warwick would not have escaped by the speed of his horse.’ ‘Who is the prisoner that thou hast?’ said Guy. ‘Sir Tirri, the son of Earl Aimbri’, said he. ‘Is he with thee?’ said Guy. ‘He is indeed’, said the duke. ‘It is a pity I was not with thee at that time’, said Guy, ‘for I would kill that son mercilessly’, said he, ‘and I would not make a prisoner of him; for Sir Tirri killed my own brother’, said he. ‘And give me charge of those prisoners, for it is I that will have no mercy upon him.’ Then the Duke of Lombardy gave the keys of the prison to Guy. As for Guy, after this he went into the cruel prison where Sir Tirri was, and asked news of him how he was. ‘Who art thou?’ said Tirri. ‘I am Guy of Warwick’, said he. ‘That is ill for me’, said Tirri, ‘for I had hope until now of getting help from thee; and yet it is worse for me that thou shouldst be in the danger thou art in than that I myself should be’, said he. There was a Lombard near by, listening to that conversation. The Lombard said: ‘Sir Guy’, said he, ‘thou shalt not leave this prison till the time of thy[151](javascript:footNote('T306000/note151.html')) death.’ Guy said: ‘Keep it secret about me’, said he, ‘and thou shalt have plenty of gold and treasure from me.’ The Lombard refused to accept that from Guy, and set out to tell the news to the duke; and Guy followed him, and gave him a strong, bold blow with the great iron key that was in his hand, and he dropped dead, without life, and he fell in the presence of the duke. The duke said: ‘Thou shalt fall thyself for that act, false traitor’, said he. Guy said: ‘My lord’, said he, ‘I do not know why it was wrong to kill him, for he was on the point of letting Tirri out of prison, {Ir. ed. page 75} and gave him his choice of the food and drink of the city.’ The duke said: ‘Thou hast killed him justly’, said he; ‘and now we will give thee assurance of





---

p.153






peace.’ Sir Guy went into the prison, and broke the gray-iron fetters that were on Tirri, and gave him a full supply of food and drink and said to him: ‘Tirri’, said he, ‘go out to Earl Aimistir in the early part of the night, and wait for me there; and if it be God's will, it is shortly that I will be with thee there and Uisin, the daughter of the Duke of Louvain.’ Thus went the night with Guy. And the Duke of Lombardy said to the daughter of the Duke of Lorraine: ‘Make thyself ready, lady’, said he, ‘for our marriage mass shall be celebrated tomorrow; for thou didst not ask for more than twelve days' delay before marrying, and they have passed.’ Uisin said: ‘My lord’, said she, ‘I will do thy will in this matter.’ As for the duke, he went forth into the beautiful, wild forest to kill boars and deer and *other* creatures in preparation for the wedding on the morrow. Guy went at that time to the lady, and said to her cheerfully and joyously: ‘Lady’, said he, ‘dost thou recognise me?’ ‘I do not’, said she. ‘I am Guy of Warwick’, said he. The lady said: ‘That was not the color that I saw upon Guy’, said she, ‘for he was fairer than the mass of men.’ Then Sir Guy showed the lady a mark that was upon him, and thereupon she recognised him. Sir Guy said: ‘Lady’, said he, ‘get me good armor and weapons tonight, and by God's will I will carry thee with me away from the Lombards.’ And she gave Guy armor and weapons secretly.


 As for the duke, the next morning he put Uisin on a clear white mule to go to the temple. And Sir Guy followed them on his steed, and strong, indestructible armor upon him, and a warrior's weapons in his hand; and he overtook them, and said: ‘Duke Otun’, said he, ‘I am Sir Guy of Warwick; and now be on thy guard, for thou hast deceived me three times, and hast slain my knights in the wilderness of this land.’ Then Sir Guy drove a spear eagerly and boldly through the duke's body, and afterwards gave him a blow with his sword, and struck off his head, and split him as far as the navel. And he took the duke's head with him, and put the daughter of the Duke of Louvain behind Gailiard, and in this way they left the city. Bold warriors of the Lombards bore down upon them, and the brother of the duke said: ‘Sir Guy’, said he, ‘treacherously hast thou killed the Duke of Lombardy, and thou thyself art a poor compensation for him.’ Guy said: ‘There is nothing better for thee than to let him go his way(?),[152](javascript:footNote('T306000/note152.html')) for the duke deserved to be killed by me many times over.’ {Ir. ed. page 76} Guy turned to the duke's brother, and struck off his head with one blow, and killed ten more of the Lombards along with him, and they left the Lombards thus. When the daughter of the Duke of Louvain had put away her fear, she said: ‘It is a sad deed the Lombards will do now, namely, to kill Tirri without mercy.’ Guy said:

 



---

p.154






‘He has nothing to fear’, said he, ‘for I told the jailer to be kind to him, and by God's will thou shalt see him soon.’ Then they went on their way to the city of Munntani, where Earl Aimistir was, and they found Sir Tirri awaiting them there, having been bathed clean and healed from the wounds of the fetters and the hard irons. As for the Lombards, after they turned from Guy, they went to the prison to kill Tirri, and they found nothing there but the place where he had been. Then they brought the Duke of Lombardy into the church, and he was buried by them there. Thus did Sir Guy put an end to his war with the Duke of Lombardy and his knights.


#### 31


As for Sir Guy, then, he said that he would go to find Sir Heront. ‘I will go with thee, *and* five hundred knights’, said Earl Aimistir. Thereupon they set out, and they pillaged and laid waste every city and castle that they came upon in the possession of the Duke of Louvain, until they came to the city of Gormisi where Earl Aimbri was; and great joy seized Earl Aimbri when he saw his son and Sir Guy approaching, and a swoon and a fainting-fit came upon him through the excess of his joy. Then Sir Guy put the head of the Duke of Lombardy on the top of a stake at a cross-road in the city of Gormisi, and he called Sir Gailiard to him and said to him: ‘Noble and honorable knight’, said he, ‘I will give thee command and leadership of my army, and do thou take six hundred bold knights with thee, and bring me prisoners as a pledge for Heront.’


As for Sir Gailiard, then, he went on to Louvain, and he was destroying it without mercy, and he captured fifteen castles there, and seven earls and ten barons. {Ir. ed. page 77} This news came to the Duke of Lorraine, and fear and terror seized him, and he went to his own steward, and took counsel with him. The duke said: ‘My realm has been laid waste and pillaged’, said he, ‘and the armies and great troop of Guy of Warwick are coming to capture from me this city in which I am; and which is better for me, to mount a swift horse and take flight, or to stay and be captured or re-captured?’ [153](javascript:footNote('T306000/note153.html')) The steward said: ‘Take my advice’, said he, ‘if thou desirest to act for thine own profit; for Guy of Warwick struck off the head of the Duke of Lombardy and put that head on a stake at the cross-road of the market in the city of Gormisi; and he took Sir Tirri, the son of Earl Aimbri, with him, and Uisin, thy own daughter. Battle or combat against him is not possible, and he will take the world if he wishes to; and furthermore, thou hast in thy hands a brave, victorious knight of his company, Sir Heront; and do thou let him out in honor of Sir Guy, and all the other prisoners along with him, and give them their own possessions,





---

p.155






and much besides along with them. And send those prisoners in an embassy to Guy to ask favor of him, and to get assurance of peace, for Heront is one of the two advisers who have the strongest influence with him in the world, — namely Sir Tirri and Sir Heront; and Guy himself is merciful.’ The Duke of Lorraine said: ‘:My blessing straightway upon thee’, said he, ‘for it is good counsel thou hast given me.’ As for the Duke of Lorraine, then, he broke the bonds and fetters of all the prisoners, and gave them every possession that had been taken from them, whether great or small, and an abundance of his wealth besides. And he sent them to Guy, and charged them to procure his advantage and to establish peace for him with Guy for the love of God. Then the Duke of Lorraine told Sir Heront how Sir Guy had killed the Duke of Lombardy, and how he had taken Sir Tirri and Uisin with him, and every other deed that he had done. This news was sweet to Sir Heront, because he had not had a single word of news about Guy from the time he himself was captured until that hour.


As for Sir Gailiard, he advanced with his six hundred knights to the city of Gormisi, and Sir Guy was in consultation that day on the top of a hill over against the city of Gormisi; and there was no one with him but Sir Tirri and Earl Aimistir. Aimistir said: ‘I do not know who the hosts are yonder’, said he; ‘for if they are an army bent on war and battle, they are too near us; and I will go myself on my horse to meet them.’ And he went then, and recognised Sir Heront, and they bade each other a friendly welcome. {Ir. ed. page 78} Sir Heront said: ‘Aimistir’, said he, ‘I beg thee, ask Sir Guy for me to give promise of peace to the Duke of Lorraine, for I am indebted to him, and I partook of food and drink at his table, and he did not put bond or fetter on me; and not a bit of harm has come to me or to any of the other prisoners, and great is our gain from what he has given us.’ They went on then to meet Guy and Tirri, and all together they begged for peace for the Duke of Lorraine; and Guy refused to give them that. Sir Heront went upon his knees in Guy's presence, and the eight hundred knights along with him, and they all together begged Guy to give assurance of peace to the Duke of Lorraine. Guy said: ‘I will grant you that request, though it is hard for me.’


As for Gailiard, now, he and his hosts were at that time laying waste and devastating Louvain, and a messenger was sent to him, and he was brought back to the city of Gormisi. And another messenger was sent to the Duke of Lorraine to ask him to prepare a *wedding-feast for his* daughter, to give her to Sir Tirri, the son of Earl Aimbri. After this they went together to the city of the Duke of Lorraine, and they made peace and an alliance, and celebrated the wedding. And thus was waged the war of the two dukes with Sir Guy of Warwick.




---

p.156


#### 32


Once when Sir Guy went to the hunt in Lorraine, a wild boar started up before him, and he set his dogs upon it and followed it on his horse; and Guy parted from his company at that time, and pursued the boar through many well-defended and prosperous lands. And he overtook it at last, as it was killing his dogs; and he dealt the boar a strong, bold blow, and killed it, and gave its heart to his dogs, and blew a loud blast upon the end of the horn that was hanging at his neck, to proclaim the slaughter [154](javascript:footNote('T306000/note154.html')) of the boar that had fallen before him. And the blast of that horn was heard in the city which was called Florentine, and Duke Florentine bade that the man who blew that horn in his forest be brought to him in dishonor. The son of Duke Florentine went to Sir Guy, and struck him boldly with his fist. Sir Guy said: ‘Thou hast struck me unjustly for killing the boar that I have pursued through many lands.’ The duke's son said: ‘I will inflict death upon thee for that’, said he. When Guy heard this, he struck the son of Duke Florentine on the head with the end of the horn, swinging it by his girdle, {Ir. ed. page 79} and he died. As for Sir Guy then, he proceeded through the forest, and saw the city of Florentine before him, and went into it, and asked food of Duke Florence[155](javascript:footNote('T306000/note155.html')) for the love of God, because he had been three days and three nights without food, or drink, or sleep, in pursuit of that boar. The duke ordered food to be given to Guy, and plenty was given him and he was eating it. Then Guy heard a cry of sorrow and lamentation in the city, and he saw a body laid on the floor in the royal hall, and the duke was asking what body they had. ‘Thy son’, they said, ‘who has been killed.’ ‘Who killed him?’ said the duke. ‘It seems likely to us’, said they, ‘that the knight who is eating at the table yonder killed him.’ When the duke heard this, he seized a broad-trenched, warlike sword, and drew it out, and struck at Guy with it; and Guy dropped behind the shelter of the table and let the blow go by. As for Sir Guy then, he seized a sharp-edged dagger that was at his side, and was defending himself bravely; and all the people of the city collected around him, and six of them fell at his hands. Guy said: ‘My lord’, said he, ‘it is nothing but treachery on your part to kill in your house a single knight or a single man to whom you have given food; and if thou [156](javascript:footNote('T306000/note156.html')) art a true nobleman, give me leave to go out through the gate of the city on my horse, and give me my sword and my shield, and thou shalt have leave to follow me, and it will be less *>disgrace* for you [157](javascript:footNote('T306000/note157.html')) to kill me like that than to kill me like this.’





---

p.157






The duke said: ‘I give thee leave to depart thus’, said he; ‘and take thy horse and thy arms.’ Guy seized his arms, and mounted his horse and set out; and the people of the City were lying in wait for him, and attacked him on every side, and he killed three of them in that onslaught. And the duke struck him a savage blow, and drove a spear through his shield. Sir Guy gave the duke a keen thrust of the spear, and overthrew him and took his horse from him; and after that he looked upon him. And Guy said: ‘Old man, aged and infirm’, said he, ‘it were more fitting for thee to be alone in church praying fervently to God than to be fighting now.’ The duke said: ‘It is seventy years now since I have taken arms before, and it would be a delight to me to have thee fall at my hands in compensation for my son.’ Guy said: ‘I will not kill an old man like thee’, said he, ‘and I will give thee thy horse.’ As for Guy, he went on his way, and the assembled people of the city and of the whole land pursued him, and he killed sixty of them, {Ir. ed. page 80} and got away afterwards in spite of them. And he was travelling on horseback a day and a night, and came to Lorraine, and the people of the city were all glad to see him, for they did not know what had become of him from the day of the hunt until that time; and Sir Guy related his adventure to them from beginning to end. Sir Guy said: ‘Tirri’, said he, ‘I have been seven years without seeing my father or my mother, and now I am going to England.’ ‘Do not go’, said Tirri, ‘for there are many hosts in Lombardy, and they will make war upon me after thy departure, if they hear that thou art gone. And I will give thee the city of Gormisi, and I will stay myself in the city of Lorraine.’ Sir Guy said: ‘I will not accept that’, said he; ‘for it is known to thee, Tirri, that I am in love with the daughter of the Earl of Warwick, and I am going to see her now.’ As for Sir Guy, he proceeded to England, and went to Winchester where the king was, and the English nobles about him; and they made Guy welcome, and heard of every deed of bravery he had done on his wanderings. It was not long thus with them when they saw a knight approaching on a steed. The king asked news of him. The knight said: ‘I have bad news’, said he, ‘for a black, devilish dragon has come to this country, and greater than a well-filled tun is the shaggy, deep-dark neck that is on him. And he kills every animal that he comes upon, whether small or big, and the men of the land are not able to combat him, and it will be necessary to give up the land and the country to him.’ Fear and terror seized the king at this news, and for a time he was silent. Guy said: ‘My lord’, said he, ‘have no fear of this, for by God's will I will win the battle of the dragon yonder for you’, said he. And thereupon Guy rose, and put on his battle-armor and took three knights with him, Sir Heront and two other knights besides,





---

p.158






and went against the dragon. And he left the three knights half a mile behind him, and upon pain of death he forbade them to follow him to give him help. As for Sir Guy then, he was three hours in battle and fierce conflict with that bold dragon and he could not injure him in that time. Then the dragon made a strong, firm knot of his stout, strong-ended tail about Sir Guy and his steed, so that he broke and crushed together the bones and the heart of the brave, strong courser, and Sir Guy was thrown to the ground in peril. As for Sir Guy then he rose in strength and courage and struck him a powerful blow and broke his tail off with great might. The dragon struck Guy a powerful blow with the butt of the tail, and gave {Ir. ed. page 81} him a dangerous wound. And when Sir Guy could not wound[158](javascript:footNote('T306000/note158.html')) him in front, he began to cut and wound him from behind; and he struck him a strong, brave blow in the side, and broke three broad, great ribs in him, and the dragon fell, before him, and let out a horrible howl. And he raised his tail high in the air then, and Guy gave him a swift, sudden blow in the breast, and made two pieces of him, just equal in size and weight, and there issued from him a black, malodorous vapor. And Guy struck off his head, and measured him, and he was thirty feet long; and he went to the king of the Saxons, and showed him the dragon's head, and everyone praised that fight.


#### 33


After Guy had accomplished this feat, the king of the English said: ‘Sir Guy’, said he, ‘I will give thee thy choice of the dukedoms in England, besides gold and silver and an abundance of all riches in addition.’ Sir Guy said: ‘If I had desired it, my lord’, said he, ‘I might have taken the empire of Constantinople, besides every other possession that was offered to me, and I might have taken a dukedom in Germany, and I might have taken an earldom in France, and I might have taken an earldom in Britanny, and I did not take anyone of them, and I will not take this from you, my lord’, said he; ‘and much honor be thine.[159](javascript:footNote('T306000/note159.html')) And my father has died’, said he, ‘and I will go to see my own domain now.’ Guy took leave of the king, and went to his own home, and he found an abundance of gold and silver and precious stones besides sent from the king because he had not taken any other domain from him. Guy said: ‘Sir Heront’, said he, ‘it is long that thou hast followed me, and much of my evil fortune that thou hast had, and thou hast no lordship of thy own; and I give thee this manor, and to thy heirs after thee, and a thousand pounds besides every year.’ And in this way he gave away his whole domain to his knights, and said that the earldom of Warwick





---

p.159






did not seem to him too small for himself. Then Sir Guy went to the Earl of Warwick, and the Earl of Warwick paid him great honor, and thanked God that he had come out of the great perils in which he had been. Then Sir Guy went to Felice, the earl's daughter. Sir Guy said: ‘Felice,’ said he, ‘it would have been easy for me to get for a wife a lady whose wealth and patrimony was greater than thine, and I refused them all for love of thee.’ Felice said: ‘Sir Guy’, said she, ‘it would have been easy for me to marry a king, or a prince, or an emir, {Ir. ed. page 82} or a duke, or an earl, if my love had not been kept for thee.[160](javascript:footNote('T306000/note160.html')) And I should never have had a man or a husband, if thou hadst not returned alive.’ Sweet was that speech to Guy, for the lady had not laid bare her love to Sir Guy up to this time.


Thereupon Guy went to the earl. And the earl asked Guy what kept him without a wife. Guy said: ‘I have felt unendurable love for a woman since my youth, and if I do not obtain that woman, I will never take a wife’, said he. The earl said: ‘Wilt thou be pleased with my daughter, together with all my possessions? For I have no son or daughter but her, and if it should seem fitting to thee to take her there is no son-in-law in the world that we would rather have than thee.’ Guy said: ‘It is thy daughter who is the one woman I choose to marry in all the world.’ That saying gave the Earl great joy. The earl went to Felice and asked her what kept her unmarried, and plenty of noblemen wooing her; or whether she chose to be always without a husband. Felice said: ‘I have loved a man since my youth, and I will take no husband till the time of my death unless I get him.’ The earl said: ‘Does Sir Guy of Warwick please thee?’ said he. ‘He does indeed’, said the lady, ‘for he is my choice for a husband.’ Sweet was this answer to the earl. The earl went to Guy, and set the time for the marriage on the seventh day from that day. And the earl and Sir Guy went to the hunt every day during that time in preparation for the wedding. Then messengers were sent from him to the English nobles, both laity and clergy; and the king of the English, and the queen, and the prince came to that wedding; and there came bishops and archbishops and abbots and **herenachs**, and friars of the orders, and canons, and monks; and that wedding was nobly celebrated. And after this they enjoyed the wedding-feast, and Sir Guy distributed gold and silver and garments of silk and gold-thread and gems of crystal and carbuncle and all kinds of treasures besides. And to all who desired a gift or a reward Guy gave it [*...*][161](javascript:footNote('T306000/note161.html')) to the door of the house that day of gold and silver and virtuous stones. And there were a multitude of knights, gracious and





---

p.160






splendid, attending upon that wedding; and there was much music and minstrelsy at that wedding; and there was not a man of them all whom Guy did not repay with worthy rewards at his own pleasure. {Ir. ed. page 83} They were three days celebrating that wedding, and then they went to their own places and abodes. Thus far the marriage of the Earl of Warwick's daughter with Sir Guy.


#### 34


As for Sir Guy, after this he was forty days and nights with the daughter of the Earl of Warwick. At the end of that time Guy went one day to hunt, and many wild creatures were killed by him that day. And though that was pleasant, it was not there that his mind was, but upon his own sins, for the fear of the Lord was upon him. And it was his desire to make amends for his youth. Sir Guy sent messengers at that time to Johannes de Alcino, a holy father, and he came to him at once. Guy said: ‘Holy father’, said he, ‘I put the charge of my soul upon thee; and hear thou my confession quickly in honor of three Persons, the Father, and the Son, and the Holy Ghost. For many are my sins; for until the sands of the sea are counted, and the grass of the field, and the leaves of the forest, and the stars of the sky, there will not be made a count or an estimate[162](javascript:footNote('T306000/note162.html')) of the men and the innocent lives that fell at my hands because of my love for this world, to get myself honor and high repute, *and* to put my fame above everyone; and yet I never killed a man from love of God.’ Dixit Johannes de Alcino: ‘If thou hadst done a third of that for the love of God, God would be satisfied with thee and would forgive thee thy sin.’ Johannes de Alcino said:[163](javascript:footNote('T306000/note163.html')) ‘Sir Guy’, said he, ‘do thou now take my advice: keep the ten commandments which Christ left on earth with Moses in the tablets; love God beyond every love in heaven and earth, et cetera; avoid the mortal sins, pride, anger, sloth, envy, lust, gluttony, avarice and backbiting; and be merciful, humble, prayerful, pitiful, compassionate, grateful and full of benediction.’ Johannes said: ‘Observe, Guy’, said he, ‘how the saints who are in heaven attained the kingdom: part of them by fasting and prayer, by pilgrimages and vigils, by frequent confession and many alms; others by suffering, by pain, by purgatory in this life,[164](javascript:footNote('T306000/note164.html')) by burning, by crucifixion, by the distress of every disease and every pain, for the love of Jesus.’ And Johannes said: ‘Guy’, said he, ‘make thy confession clean, and be humble before God, {Ir. ed. page 84} and be ashamed of thyself, and know that our parents were without sin in Paradise only three hours because of the deception of the adversary. And they were driven out





---

p.161






of Paradise, and found much evil in the lands everywhere, and afterwards went to hell — and not they alone but everyone who was descended from them. — until Christ suffered passion and punishment for our salvation. O Guy’, said he, ‘believe what the apostles say in the creed: namely, believe in one God Almighty who made heaven and earth; and believe also in Jesus Christ who was born of Mary without loss of her virginity, without the knowledge of a man; and believe that he redeemed the seed of Adam in the midst of the tree of suffering; and believe that he rose from the dead on the third day after the harrowing of hell; and that he went thereafter to the right hand of his Father; and that he shall come to pass judgment upon both the quick and the dead; and believe in the Holy Spirit, the third part of the Deity, and understand further that there is one God in Trinity, namely the Father and the Son and the Holy Spirit; and believe in the resurrection of the men of the world, and the forgiveness of sins, and the life everlasting, and the commnnion of the saints and the angels, where there is life without death and health without disease’.


#### 35


When Guy had completed forty days in his wife's company, he was *there* one night, and the daughter of the earl, with their breasts against the chamber window, and Sir Guy said: ‘Felice’, said he, ‘thou art with child, and shalt bear a son; and name him Roighnebron, and he shall be a good son; and give him to Sir Heront to be brought up. And Felice’, said he, ‘not more numerous are the stars thou seest in the firmament than the men who have fallen at my hands because of my love for thee; and if it had been for the love of God that I had done it, He would be satisfied with me; and now I will do service unto God.’ Felice said: ‘Guy’, said she, ‘build monasteries and temples and chapels and bridges and other spiritual works, and make a house of hospitality for the Lord's poor, and still abide *here*.’ ‘I will not do it’, said Guy: ‘but I will go to traverse the land that my Lord Jesus traversed.’


Guy gave Felice his sword, and told her to keep it for his son; and he said that there was not in the world a sword that was better than this; and he cut short his spear and made a staff of it. Felice said: ‘There is a woman in another land who is dearer to thee than I am, and it is to her thou art going.’ ‘There is none’, said Guy, ‘and yet we will surely not stay and abandon this journey.’ And then they kissed each other, {Ir. ed. page 85} and thereupon they fell in a swoon; and Guy got up after this, and set out on his way. ‘Art thou surely pleased to go?’ said she. ‘I am in truth’, said he. ‘Take half of this ring with thee’, said she; and Guy took the ring, and broke it, and left half of the ring wth her and took the other half himself. And Guy said: ‘Do not believe that I have met death until thou get





---

p.162






my half of the ring.’ Thus did Guy put away from himself the world.


#### 36


As for the earl's daughter, after Sir Guy had left her she was three days and three nights in her chamber without food or sleep; and she took Sir Guy's sword and she would gladly have driven it through herself. And she said: ‘I would kill myself’, said she, ‘but that I fear it would be said that Sir Guy killed me.’ And she went to her father after that and told him that Guy had departed. The earl said: ‘It is to test thee he has done that.’ ‘Not so indeed’, said Felice, ‘and I shall never see him again.’ As for the earl, after he had heard this news, he fell down in a swoon. And afterwards he sent to Sir Heront and related the news to him. Sir Heront said that he would explore the world until he found Sir Guy. He set out again, and he did not leave unexplored a land of those he had traversed before with Guy; and he searched in Rome for him, and got no news of him, and they came together in another city, and Sir Heront did not recognise Sir Guy after his change of name (Poor John, namely, he was calling himself), and his body emaciated[165](javascript:footNote('T306000/note165.html')) with fasting and his hair grown long; and Guy did not betray his identity to Heront. Sir Heront returned to England, and reported that he had not found a word of news about Guy, and great were the lamentations the English made in mourning him. Thus far the sorrow of the English for Guy, and Sir Heront's search.


#### 37


As for Sir Guy, he made a praiseworthy pilgrimage of the world to the city of Jerusalem, and from there to Alexandria, and he was three *years?* travelling in those cities. And outside of the city he came upon an old man, advanced in years,

weeping sorrowfully. And Guy asked him the cause of his grief, and he did not tell him. Guy said: {Ir. ed. page 86} ‘I beg thee for the sake of Christ's passion to tell me thy story.’ ‘I will do so now’, said the old man. ‘Earl Jonutas is my name’, said the old man, ‘and I am a Christian; and Craidhamar,[166](javascript:footNote('T306000/note166.html')) the King of Alexandria came with his followers to lay waste my land and my city, and I fought a battle with them, and defeated them, and we were slaying them mercilessly as far as this city. And they made an ambush for us in the woods yonder, and we were deceived, and I was captured, and my fifteen sons, and my followers were slain; and we have been *here* seven years, and we have not had our half portion of food or drink in that time. And it is a fixed custom with the Sultan every year to celebrate a feast





---

p.163






on the anniversary of the day on which he was born; and all his followers are with him at that feast. And Craidhamar, the lord of this city, and his son Faber went to that feast, and Sodoni, the Sultan's son, asked Faber to play a game with him, and they played the game. The Sultan's son became angry, and struck Faber with his fist, and Faber said: ‘If there were any witness of it, I would not let thee dishonor me’ said he. When Sodoni heard this, he struck him again, so that his blood ran. Faber was angry, and struck him on the head with the chessboard and he fell dead, without life. Faber went to his father, and told him about it, and they fled to this city; and they had been only three days with the Sultan, and that feast lasted six days. As to the Sultan, after he learned of his son's death, he sent a messenger to Craidhamar to charge him with the deed. And the King of Alexandria and his son went to meet the Sultan. The Sultan said: ‘Faber’, said he, ‘it is an evil deed thou hast done, to kill my son without cause.’ ‘Not without cause did I kill him’, said Faber, and he told him how he had done the deed. The Sultan said: ‘I will give thee a year and forty days, time to find a champion; and if thy champion is the stronger, I will relieve thee from thy accusation,[167](javascript:footNote('T306000/note167.html')) and if thy champion is the weaker, I will put thee and thy father to death, and will take away your dominion.’ Then they came to this city’, said Earl Jonutas, ‘and they told me that they would give me and my children our lives, if I would find a champion who would win the battle of the Sultan for them: and if I did not find them one, that they would put me and my children to death. And I travelled through the land of the English and a great part of the islands of the sea besides, and I did not find him whom I was seeking, Sir Guy of Warwick, my lord and chief; and I did not find Sir Heront, a brave knight of the company of Guy of Warwick. And now I am going back, and I shall have to suffer death now, {Ir. ed. page 87} myself and my children; and there is left of the time before that combat only forty days that have not elapsed; and that is the cause of my grief’, said he. Sir Guy said: ‘I will go with thee to that combat’, said he. Earl Jonutas said: ‘Pilgrim’, said he, ‘do not make mockery of me’; and he rose to his feet then, and fell down immediately; and Sir Guy lifted him to a sitting posture, and told him to have good courage, and that he would remove the cause of his grief. Earl Jonutas said, looking at Guy: ‘It would seem likely that thou wert once such an one that thou couldst do a manful, valiant deed;[168](javascript:footNote('T306000/note168.html')) and it is a pity before Him who made heaven and earth





---

p.164






that thou art not Guy of Warwick.’


After that they went into the city, and Craidhamar came upon them, and he asked news of Earl Jonutas, whether he had found a man whom he could ask to undertake the battle. Earl Jonutas said: ‘There is a pilgrim with me who promised to win[169](javascript:footNote('T306000/note169.html')) it.’ The king looked at Guy, and made but little *of him*, and asked him what his country was. Guy said: ‘I am John the Englishman’, said he. The king said: ‘I like it the worse that thou art an Englishman’, said he, ‘for from that land were the two knights that I liked least of all that ever came, Sir Guy of Warwick and Sir Heront; for it is Sir Guy who killed the Sultan, my brother, and Eiliman of Tyre, my father; and I was near the place myself when he struck off the Sultan's head. And *yet* if Sir Guy should come to me now, and settle the combat yonder for me;[170](javascript:footNote('T306000/note170.html')) I would give him assurance of peace.’ And the king said: ‘Old man’, said he, ‘how wilt thou expect to fight the battle yonder? For if thou shouldst fight with the champion of the Sultan, thou wouldst be killed instantly by terror before him; for such is the warrior, — black, horrible, huge, bold and unconquerable.’ Guy said: ‘I have never felt fear yet’, said he, ‘of anything I have seen.’ As for Guy then, service and attendance was given him, frequent baths and food and drink, to the end of forty days and forty nights. When the time had passed the King of Alexandria said: {Ir. ed. page 88} ‘Old man’, said he, ‘on what terms dost thou wish to fight the battle yonder?’ He said: ‘I wish thee’, said he, ‘to release Earl Jonutas and his children, if I am the stronger; and if I am defeated in the battle, do thy will with Earl Jonutas.’ The king said: ‘I will do that with a good heart’, said the king; ‘and all the Christian prisoners that I hold bound I will let out, if thou art the stronger; and I will not make war upon a Christian till the time of my death, if the victory in the battle there is with thee.’ Guy said: ‘Get me strong weapons and armor of the same kind.’ The king said: ‘I have them, if a strong, brave man were found who could carry them, and no such man has been found since the men who owned them came to their death, — the breast-plate of Hector, the son of Priam, and his sword, and the helmet of Alexander, the son of Philip the Blind.’[171](javascript:footNote('T306000/note171.html')) ‘Give them to me’, said Guy. The armor was

 



---

p.165






given to Guy, and he put it on, and it was well that that armor suited Guy. Then he went to the Sultan. The King of Alexandria said: ‘My lord’, said he, ‘the champion is prepared.’ ‘Thou shalt have the battle then’, said he. And they were put on an island to fight the battle. Craidhamar prayed the gods, Mahoun and Termagant, to give Guy strength. ‘I deny them’, said Guy, ‘and I pray for aid from the Son whom the immaculate Virgin bore, and who endured the passion for the race of men.’ Amoront, the champion, came against Guy. Guy said, when he saw him: ‘The man yonder is more like a devil than like a man’, said he. Then the two rode against each other, and they fought with each other a manful, heroic, and valiant fight, and Amoront struck Guy a savage blow, and made *two pieces of* the steed that was under him, and Guy came to his feet. And the Sultan laughed when he saw that. Guy fought fiercely, and gave Amoront a blow, and shattered his warrior's helmet and his old, strange armor, and cut his clothing, and made two pieces of his horse, and Amoront came to the ground, and the King' of Alexandria laughed. Amoront got up quickly, and they smote each other again. And there was fiery heat on that day, the next after the day of John the Baptist in the summer. {Ir. ed. page 89} Amoront said: ‘Warrior’, said he, ‘for God's own sake[172](javascript:footNote('T306000/note172.html')) give me leave to go to the water and bathe.’ ‘I would give it’, said Guy, ‘if thou wouldst give me the same in turn, if I should ask it.’ ‘I will’, said Amoront. The champion went into the water, and bathed himself there, and drank some of it; and then he was strong and valiant, and they fought bravely thereafter. After that the heat overcame Guy, and he asked leave to go into the water. ‘I would give it’, said Amoront, ‘if thou wouldst let me know who thou art.’ ‘I would’, said Guy, ‘for I am Guy of Warwick.’ Amoront said: ‘I thank the gods for that, — for sending thee against me, since it is thou who killed my two brothers and my lord, the Sultan; and for all the gold in the world I would not give thee leave now.’ Amoront dealt Guy a fierce blow then, and brought him to his knees. Guy said: ‘The Trinity and Mary protect me’, said he, ‘for I was never before on my knees against my will.’ Guy sprang up fiercely and savagely, and he drove his sword strongly and boldly. into Amoront's breast, and gave him a broad, deep wound, and his blood flowed terribly, and he fell to the ground. And at that time Sir Guy went into the water, and bathed himself there, and drank enough of it, and came out. Guy said: ‘There was never a time when my strength was greater than now’, (?) said he. And this is the length of time that he was fighting that battle, namely, ten hours before mid-day and six hours after it; and Amoront fell before Guy at the end of the fight, 





---

p.166






and he struck off his head. Craidhamar said: ‘Sultan’, said he, ‘now thou seest that thou hast made an unjust charge against my son; if it were not so, the victory in the battle yonder would not have been on his side.’ The Sultan said: ‘Thou shalt have assurance of peace on that account, and reparation for thy dishonor.’ Thus far the battle between Guy of Warwick and Amoront.


#### 38


After this they returned to the city of Alexandria, the King and Earl Jonutas and Sir Guy, and Earl Jonutas was given his children and all his followers with all their possessions, and they went then to the city of the earl. And Sir Guy was with the earl fifteen days, and Earl Jonutas offered Sir Guy an abundance of possessions; and Guy refused {Ir. ed. page 90} this, and set out to depart, and the earl went to a place apart with him. The earl said: ‘For the love of Christ’, said he, ‘tell me who thou art.’ ‘I will’, said he, ‘and do not tell of me to anyone else, for I am Guy of Warwick.’ And thereupon he left his blessing with him. As for Guy, he fasted and prayed and made a pilgrimage in every land in which Christ had journeyed, and the story does not speak of him for another while.


#### 39


As for Felice, the daughter of the Earl of Warwick, after Sir Guy left her she bore a son at the end of her pregnancy, and he was baptised, and was named Roighnebron, and was brought to Sir Heront for his education. As for Felice then, she built monasteries and chapels and other good works for the soul of Guy of Warwick. As for Roighnebron, at the end of his twelfth year there was not a lad of eighteen in England who was larger than he. Then there came a rich vessel to trade in that land, and they went to the king, and gave him great treasures in return for the privilege of trading. Now Sir Heront had charge of the harbors on the south shore of England at that time, and those merchants brought him many gifts in return for helping them. And they went to Sir Heront's castle, and saw the fierce-spirited lad, soldierly and proud, among the household, and asked information as to who he was. Sir Heront said: ‘That is the son of the best knight that ever walked the earth, Sir Guy of Warwick.’ And not long after that he left the castle, and part of the merchant ship's company stayed behind him in the city. The ship's people stole Roighnebron, after promising him a great treasure if he would go out with them, and he went with them in this way, and they gave another reward to the gate-keepers for letting him out with them. They went aboard their boat, and set forth, and came to a harbor in Africa, and they gave Roighnebron to the King of Africa, and told him that he was the son of Guy of Warwick. When Heront discovered the loss of his ward, he





---

p.167






traversed a great part of the world in search for him, and he did not get news of him, and afterwards he returned. At that time the Norsemen came to capture England, and the King of England summoned the leaders of his army to go to meet them; and among all who came there Sir Heront in particular came with his followers, and the king bade him welcome, and took counsel with him, for there was no better counsellor in war than he, nor a knight stronger of hand, nor one who had been oftener proved. {Ir. ed. page 91} Rage and envy seized Moduiant, the Duke of Cornwall, on this account. And he said: ‘My lord’, said he, ‘bad is the judgment thou hast passed upon us, to abandon us for the false, treacherous traitor who sold his lord's son and his own word to merchants for a petty reward.’ Sir Heront said: ‘It is a lie thou has spoken, and I would undertake to prove that it is.’ The king said: ‘Settle that between you’,[173](javascript:footNote('T306000/note173.html')) said he. Sir Heront said: ‘Duke of Cornwall’, said he, ‘I will explore the whole world in the search for my ward, unless I find him sooner, until I make everyone understand that it was a false reproach thou didst put upon me; and Duke of Cornwall’, said he, ‘if I can, I will make thee repent of that yet.’ Sir Heront said to the King of England: ‘My lord’, said he, ‘send me and my followers, and young English knights along with me, those who receive from thee reward and payment, to fight a battle against the Norsemen.’ And it was not long after that Sir Heront went to fight that battle against the Norsemen; and the battle was fought by him, and the Norsemen were defeated and slaughtered. Sir Heront went after that to look for his ward, and there were not many lands in the world where he did not search for him, and he did not get one word of news of him. And he went into Africa, and was exploring that land, or the great city of the King of Africa, and the whole land was devastated and the city half-devastated; and Heront asked the cause why the city was half-devastated and the entire land devastated. Somebody told him: ‘An Emir, mighty and merciless, has captured all this land except only this city, and he will now soon take the city unless there should be a young knight, not aged, in it to defend it bravely.’ As for Sir Heront, now, he was going from the ship, and the Turk who was attacking the city came upon him, and captured him with his followers, and he was seven years a prisoner, bound and fast fettered, and there was not a word of news about Roighnebron in that time. Thus far the imprisonment of Sir Heront in Africa.


#### 40


As for Sir Guy of Warwick after he had made a praiseworthy pilgrimage of the world, he thought of returning





---

p.168






to his own country; and one day when he was travelling in Lombardy, he came upon a poor man complaining at the foot of a cross. And Guy asked the poor man the cause of his complaining. The poor man said: ‘Thou wilt find no profit in my story’, {Ir. ed. page 92} said he. ‘Tell me in God's honor’, said Guy, ‘and I will give thee freely[174](javascript:footNote('T306000/note174.html')) of my counsel’, said he. ‘I will tell thee in truth’, said Tirri, ‘for I am Sir Tirri, the son of the Earl of Gormisi’, said he, ‘and I and Berard, the Duke of Lombardy fought a battle with each other, and the battle went against me and my followers were slain, and I myself was captured; and I have been seven years in captivity’, said he, ‘in the city of the emperor, and everyone said that it was unjust of the emperor to hold me captive in his city. When the emperor heard this he ordered me to be released on a special condition, namely that a champion should be found on my part within a year and two months; and if that champion should fall, I should be put to death and my domain should be at the disposal of the Duke of Lombardy; and if my champion should be the stronger, my life should be granted me, and my domain given me. And there is not a man in the world who is stronger of hand than the Duke of Lombardy, and he is most powerful with the emperor, and is his steward, and I am not able to fight against him. And I had a dear friend who saved me twice from death, namely, Sir Guy of Warwick; and I have been a year and two months looking for him in England, and in many other islands of the world, and I have not found a word of news about him in that time. And the one son that Guy of Warwick had has been stolen, and Sir Heront is searching for him throughout the world, and no news has been got of either of them; and that is my story’, said Tirri. Guy said: ‘I will go to the emperor with thee’ said he, ‘and perhaps he will take my counsel with regard to thee.’


And after that they set out on their way. And Tirri said that he longed for sleep, and Sir Guy said: ‘Sleep and put thy head on my bosom’, said he. And Tirri put his head on Guy's bosom, and sleep fell upon him; and Sir Guy saw the likeness of a dove or a pure white weasel coming out of Tirri's mouth and going into a hole in the ground in a strong rocky crag on the side of a great hill; and the creature came back again, and went into Sir Tirri's mouth, and wakened Tirri from his sleep. And he said: ‘It is a pity before Him who made heaven and earth that the vision I saw is not true.’ ‘What is that?’ said Guy. ‘I saw’, said he, ‘how I should go, and Guy of Warwick, into the hill thou seest[175](javascript:footNote('T306000/note175.html')) yonder before thee, and





---

p.169






that {Ir. ed. page 93} we should find a deep, dark cave there, and a dragon sleeping in it with his tail in his mouth in the form of a circle, and a decorated sword in the ground within, and an abundance of gold around it.’ Guy said: ‘We will go to see that’, said he; and Guy had observed how the white creature went into the hill, and he entered there, and saw the dragon asleep and the sword on the floor. And Guy sprang quickly on the dragon's floor and took away the sword, and said to Tirri: ‘We are both in want of food’, said he; ‘and take some of the gold with thee.’ And then they went out of the cave; and *Guy* drew the sword from its beautiful gold sheath, and said: ‘There is not a sword in the world that is better than this.’ Tirri said: ‘The city of the emperor is only three miles away from us’, said he, ‘and let us go there.’ 

Then they went to the gate of the city, and Tirri said: ‘Fear will not permit me to go into the city tonight’, said he, ‘and let us wait in this little hostelry outside the city’; and they did so.


The next morning Guy said: ‘I will go to mass’, said he, ‘and do thou stay here, Tirri, until I come to thee’, said he. And Guy went to the temple, and heard mass, and went on his way to meet the emperor, and paid him homage, and asked alms of the emperor. And he said: ‘Follow me to the palace’, said he, ‘and take thy share there, and thou shalt receive alms.’ As for Guy then, he went to the emperor's palace, and the emperor asked him: ‘Hast thou made a great pilgrimage?’ said he. ‘I have’, said Guy, ‘for there is no praiseworthy pilgrimage in the world that I have not made’, said he. The emperor said: ‘Hast thou heard talk of me in those lands?’ said he. Guy said: ‘I have heard good and ill spoken of thee’, said he. ‘What is the reason for speaking ill of me?’ said he, ‘for it is fitting to speak well of me.’ Guy said: ‘That thy proud steward, the Duke of Lombardy, captured Earl Tirri, and took away his domain, and that thou hast suffered that and hast given him more besides.’ Duke Berard said: ‘I swear by the one God,’ said he, ‘that I came near seizing thee by the beard and breaking thy teeth in thy throat.’ Guy said: ‘I give my word that if thou shouldst do that, I would strike my scrip and my staff together on the top of thy head, till I drove thy brains through thy skull.’ The duke said: ‘I had rather {Ir. ed. page 94} than a great part of the wealth of the world that the man who would say that of me should come and prove it against me!’ Guy said: ‘I would come to prove it against thee!’ said he, ‘and here I am in the power of the emperor as a pledge that I will fight that battle tomorrow morning’, said he. Then the Duke of Lombardy gave a pledge and sureties for himself that he would come to combat with the pilgrim on the next morning. Thus passed the night with them. Guy rose in the bright, early dawn of the morning, and asked the emperor for armor, and got his supply of weapons and





---

p.170






armor, and took the sword that he found in the cave under the dragon. And they were from nine strokes of the bell until the black, dark, indistinguishable time of the night cutting and smiting each other. And the emperor made a truce of the battle between them; and the emperor sent Sir Guy to his daughter's chamber to be guarded and ordered care and treatment to be given him. The Duke of Lombardy said to his followers: ‘I never had a fight that was harder for me than the fight of today’, said he, ‘and I have fear of the morrow, and it is a pity for me’, said he, ‘that I have no kinsman who would kill the pilgrim there tonight so that he would not be found for the fight tomorrow.’ A number of the duke's kinsmen said that they would do that. As for Sir Guy, after he had washed and partaken of his food, then he slept; and he was stolen with his bed, and there was an high tide of the sea under the sunny chamber at that time, and a swift, tidal current beneath it running out into the ocean, and a strong pillar supporting the sunny chamber high above the sea; and they cast Sir Guy into that stream. As for Sir Guy then, he was carried away into the ocean, and awoke from his sleep, and sat up on his bed, and looked above him, and prayed God fervently for help. And he said: ‘O Lord’, said he, ‘thou knowest that it was not for the sake of reward nor to achieve fame that I went to battle, but to save my friend from the injustice that had been done him; and O Lord, forgive me’, said he. Then Sir Guy saw a little fishing boat approaching him, and he asked tidings of it. Guy said: ‘Have you heard any mention of the poor man who fought a battle today in the city of *the* emperor?’ ‘We have’, said they, ‘and that was well done of him.’ ‘It was I who did it’, said Guy, ‘and I was betrayed in my sleep, and I do not know how I was put here, and in God's honor give me help!’ {Ir. ed. page 95} The fisherman took Sir Guy into the boat with him, and took him to his own house in the city, and gave him a bath and food and drink, and put him to sleep and long slumber on a high, stately bed. As for the duke then, he rose the next morning, and went to the combat, and the pilgrim was not found anywhere, and the steward said: ‘The pilgrim has taken flight’, said he. The emperor sent a messenger to his daughter to look for the pilgrim, and he got no news of him from her. The emperor said: ‘It is the Duke of Lombardy who has ordered the poor man to be killed’, said he, ‘and I pledge my word that if he is not found I will put my daughter and the duke to death.’ And the duke said that it was not he who had ordered him put to death, and that he would undertake to prove that he had no share in it; and that after that he would go and join the Sultan to take vengeance of the emperor for lying about him. It was then that Guy said to the fisherman: ‘Go to the emperor’, said he, ‘and get from him





---

p.171






thy reward for telling him my story.’ The fisherman went thereupon to the emperor, and told him the story, and he was glad to get that news. And after that Guy was taken to the emperor, and his battle-armor was given him, and he fought with the duke, and the duke fell before Guy at the end of the combat. A messenger went to Earl Tirri and said to him: ‘It is a pity for thee that the bravest combat that was ever fought in the world should take place in the same town with thee, and thou not be seeing it!’ Tirri went with all the rest to see that fight, and after the duke had been killed by Guy, he went to him and said: ‘Unless thou shouldst have the wrong side’, said he, ‘there is not a man in the world who would come out alive from a battle with thee.’ He said: ‘My lord the emperor’, said he, ‘give Earl Tirri his rights now’; and Tirri was brought to the place, and his domain was given him, and the office of steward of the emperor, and assurance of peace; and Guy stayed for a while with Earl Tirri. Guy took Tirri with him a thousand paces from the city, and said: ‘Tirri’, said he, ‘dost thou recognise me? Dost thou not recognise me?’ ‘I do not’, said Tirri. ‘I am Sir Guy of Warwick; and it is I who killed Duke Otun for thy sake; and it is I who killed the fifteen knights when I found thee as if dead in the forest; and it is I who *killed* the four knights who were carrying thee to Duke Otun to thy execution.’ Tirri said: ‘It is thou’, said he, ‘and I saw a resemblance to thy horsemanship when thou wert fighting with the Duke of Lombardy’; and they kissed each other, {Ir. ed. page 96} and then the earl fell in a swoon, and after that Guy departed. As for the earl, moreover, he was a fortnight in his chamber without food or drink or sleep, and his wife asked him the cause of his sorrow. The earl said: ‘Sir Guy of Warwick’, said he, ‘was with me in the disguise of a pilgrim, and it is *he* who killed the Duke of Lombardy for my sake, and got me my domain; and the day he left me he gave me certain knowledge of his story, and my life will not be long after him.’ ‘It was a pity for thee that thou didst not keep him with thee’, said the queen. Thus far Sir Guy's adventure with Earl Tirri.


#### 41


As for Guy, after that he went on his way to England, and he asked information where King Caulog, the King of England, was. Someone told him that the king was at Winchester, — ‘and the king of the Norsemen is coming to capture England and sixty thousand knights along with him; and there is a fierce, ill-boding champion with him; and the Norsemen and the English have staked their cause and their rights on a





---

p.172






combat of two, and it is that black, swarthy, devilish creature who has come to the combat on the part of the Norsemen; and there is not found among the English a man equal to him for there is not in the world a man who can conquer him. And it is on that account that the English are compelled to pay homage and to give fixed tribute to the Norsemen. And the king of the English, and the bishops, and dukes, and earls. and the people of every order besides, have been fasting three days on bread and water, and praying the one God who made heaven and earth to find them a man to overcome Colobron; and that is the news of this land’, said the young man.


Sir Guy came to Winchester. Then in the night an angel came to the king and said to him: ‘My lord’, said he, ‘arise early tomorrow *and go* to the temple, and a poor religious man whom thou shalt find there, him shalt thou ask in honor of Christ's passion to fight the battle for thee against Colobron.’ Now the king arose early in the morning *and went* to the temple, and found Sir Guy praying with crossed hands before the (altar) of the temple imploring the Creator. The king gave Guy a blessing, and Guy answered humbly and looked at the king, and when he recognised him he paid him homage and asked alms of him. The king said: ‘Thou shalt have it’, said he, ‘and do thou grant me a request.’ ‘If it is in my power’, said Guy. ‘Win the battle of Colobron for me’, said he. ‘That is no suitable request to make of me’, said Guy, ‘for I am an old man, infirm and timid’, said he. {Ir. ed. page 97} Then the king fell on his knees, and the English nobles with him, both clergy and laity, and they all besought Sir Guy to conquer Colobron for them. The noble man was overcome with confusion because of the urgent pressure the English put upon him. Then Guy said that he would go to the combat in honor of Jesus, — ‘and get me armor for the fight’; and many suits of armor were brought him, and everyone of them he broke apart by shaking it. And Guy said: ‘Bring me the armor of Guy of Warwick’, said he, ‘for he was a comrade of mine, and his arm or would fit me, and *it* is in keeping in his wife's possession; and do not on any account leave the sword.’ Sir Guy's battle-armor was brought to the place, and the old man put it on, and mounted easily into the saddle of the steed without anyone else to hold it for him. And there was great wonder among the English at the strength of the leap which the old man took into the saddle, and at the weight of the armor that was on him. And he proceeded to the place of battle, and dismounted there, and fell upon his knees, and prayed God fervently, and said: ‘O Lord’, said he, ‘if the right is on my side, save me from this danger with thy great miracles, as thou didst save Enoch from death, and Isaac from the sword and Joseph from prison, and the people of Moses from Egypt, and David from Golias, and





---

p.173






Susanna from the false blame, and Daniel from the lions' den, and Habakkuk[176](javascript:footNote('T306000/note176.html')) from hunger, and Lazarus from death, and Jonah from the belly of the big fish, save me, O Lord, in the same way by thy great mercy, et cetera.’


And Sir Guy mounted his steed again, and went to meet Colobron, and they fought a bloody, angry, venomous fight for a space and a while. Sir Guy gave Colobron a keen, bold thrust of the spear, and broke the two-fold armor that was on him, and gave him himself a bloody, unsightly wound. Colobron dealt Guy a powerful blow, and struck him to the ground; and Sir Guy arose quickly, and gave Colobron a hard, strong sword-blow on the shoulder, and made a deep wound in him after cutting his armor. Colobron gave *him* a powerful blow in the head, and cut the precious talismanic stones that were in his helmet, and that stroke glanced to the ground and did not harm him; and Guy's sword was broken in that fearful onslaught. Colobron said: ‘Give thyself up now’, said he, ‘for thou hast no power to defend thyself since thy sword is broken; and let the English give tax and tribute to the {Ir. ed. page 98} Norsemen forever.’ Guy said: ‘Colobron’, said he, ‘dost thou see the brave knight coming with arms to me?’ Colobron looked around to prevent the arms from being given to Guy. It was then that Guy rushed to the cart in which Colobron's arms were, for he had a cart full of arms, and Sir Guy snatched a broad-headed axe out of it, and struck Colobron a mighty blow with it, and struck him a second time, and at last beheaded him, and took his head away from him, and brought it into the king's presence.


The king came, and the nobles of his retinue, and the clergy of the city, in a procession to meet Guy; and the king took him by the hand, and bade him welcome, and led him thus by the hand into the city. And the king offered Guy his choice of the dukedoms in England, and Guy refused to take it, and he remained three days with the king, and then he asked leave to depart; and thereupon he set out, and the king went a little way apart with him. The king said: ‘O servant of God’, said he, ‘tell me who thou art and what is thy land.’ Guy said: ‘My lord’, said he, ‘if thou wouldst give me thy pledge not to tell my story for forty days, I would tell thee my story.’ The king gave him that assurance. The old man said: ‘I am Sir Guy of Warwick’, said he; and thereafter he parted from the king. Thus far the battle of Colobron and Sir Guy.




---

p.174


#### 42


As for Sir Guy then, he proceeded to Warwick, and found Felice in the door of the hall, and twelve beggars supported by her for the love of God and the soul of Sir Guy of Warwick. And Sir Guy asked an alms of the lady like all the other beggars; and Felice looked at him, and felt love and strong, irresistible affection for the old man, and she did not recognise him. And she said to him: ‘Come with me into the hall’, said she, ‘and thou shalt have thy sustenance there today with me.’ Sir Guy went to the hall, and he received honor at the lady's hands and a pittance from her own table. Felice said: ‘Servant of God’, said she, ‘thou art infirm, and now thou art not strong enough to travel; and do thou stay with me to be supported for the love of God and for the sake of Sir Guy of Warwick.’ Sir Guy said: ‘May the true God, the glorious, reward thee for that honor, lady’, said he, ‘and I will accept that alms from thee; and I will go into this forest beside us’, said he, ‘to pray and implore my God and my Creator, for there is no place for religion in the midst of a great company; and I will *send* my servant to the city every day for my food.’ ‘Thou shalt have that {Ir. ed. page 99} with all my heart’, said the countess.


As for Sir Guy then, he went into the forest, and found a hermit there in an oratory praying to the Creator, and Sir Guy greeted him and begged him for part of the oratory till the end of his life. The hermit looked at him and said: ‘It seems to me’, said he, ‘that there was once a time when thou wert worthy of honor,[177](javascript:footNote('T306000/note177.html')) and thou shalt have a share of it with me so long as thou shalt live.’ Guy thanked the hermit for that. After this Guy quickly bowed his knees. The angel spoke above his head, and said: ‘O Guy, prepare thyself to meet thy Lord, thy heavenly Father, on the eighth day from today.’ ‘Deo gracias’, said Guy.


It was thus with him till the end of the eighth day, and at that time he sent his lad to Felice, and said to him: ‘Bear my nine blessings to the lady, and give her this half-ring as a token, and tell her that I shall meet death in this hour; and ask her to pray to God for me, and let her come if she would visit me alive.’[178](javascript:footNote('T306000/note178.html')) The lad went quickly to Felice, and told her Guy's message, and gave her the half-ring; and she recognised it and knew that it was Guy who was in the oratory in the guise of a *poor* man. As for the countess then, she set out swiftly on her way[179](javascript:footNote('T306000/note179.html')) to the oratory, and she found Guy stretched on the floor of the oratory, and his face to the east, and he yielding up his life; and the lady cried out bitterly and lamented when she recognised





---

p.175






Sir Guy. Guy looked at the lady, and then he drew his legs up toward him, and he struck them out from him quickly and knocked a rock to the ground as he yielded up his life; and it took the strength of seven men to put *the rock* on a barrow. And Felice saw the semblance of a pure white dove coming out of Sir Guy's mouth and going upward to the kingdom of God. So that it is thus that Felice obtained her prayer from the Lord, for she besought God that she might have a look at Guy with her eyes and with her sight before his soul should depart from him. And the oratory was filled with an angelic fragrance, so that it surpassed all herbs and spices and gums in fragrance. Sir Guy was placed on a bier, and they wished to carry him to the city to bury him, and all the men in England could not raise him from that place. And he was buried with regular rites in the oratory {Ir. ed. page 100} at that time. Then a chapel, peaceful and lovely, was built around him, and a great, beautiful monastery around the chapel, and an order of religious canons was established in it; and Felice supported that monastery till the end of her life, and commanded thirty priests to be constantly at service in that monastery.


As for Felice, after that she made herself ready, and she died at the end of thirty days from the completion of the monastery; and she was buried alone beside Sir Guy, after they had won the victory of the world and the devil; and their bodies are still resting in the land of the monastery[180](javascript:footNote('T306000/note180.html')) and their souls are in heaven with the angels. Thus ended the life of the one knight who was least evil of all who lived in his time.


#### 43


As for Sir Heront, he went to search throughout the world for his ward, namely, Roighnebon, the son of Sir Guy of Warwick; and he was captured in Africa, and he was seven years in prison there. And one day he said: ‘My lord’, said he, ‘it is a pity thou didst not put me to death before I was in this prison. Many are the brave deeds I have done in the past, though I have fallen into this prison.’ The jailer was listening to these words, and he went to Ambrail,[181](javascript:footNote('T306000/note181.html')) and told him that news, and said that it seemed to him likely that *the prisoner* could overcome the young knight who was pillaging and laying waste the country. ‘Bring him to us quickly’, said Ambrail. He was quickly brought up, and Ambrail asked information about him, and what his country was. Sir Heront sard: ‘I am an Englishman’, said he. Ambrail said: ‘Didst thou





---

p.176




 

not know Sir Guy of Warwick?’ said he. ‘I did’, said Heront, ‘for I was the first knight that he ever established on his domain.’[182](javascript:footNote('T306000/note182.html')) ‘Happy is the man with whom that knight now is’,[183](javascript:footNote('T306000/note183.html')) said Ambrail. And Ambrail said: ‘A young knight has been smiting and wounding my followers for six years; and if thou couldst conquer him for me, I would let thee out with thy followers.’ Sir Heront said: ‘If any man in the world can overcome him, since Guy is no longer living, I am he’, said he. Then a spirited, swift steed was given to Sir Heront and strong armor of battle, and good, doughty weapons; and after that he answered the challenge to battle, {Ir. ed. page 101} and ten knights quickly fell before him. Roighnebron came to the place of combat, and said: ‘Old man’, said he, ‘terrible is the issue thou art bringing upon the army; and thou thyself shalt die for it.’ Then Sir Heront and Roighnebrou fought with each other, and they made an angry, mighty, bloody and valiant struggle, and it was not known in that time which of them would yield in the combat. And Sir Heront said: ‘Young knight’, said he, ‘neither young man nor old ever held out against me so long before without falling at my hands, except only thee.’ Roighnebron said: ‘Foolish old man’ said he, ‘shortly shalt thou fall before me.’ Sir Heront said: ‘Tell me thy story, who thou art, and what thy country is.’ ‘I will not’, said he, ‘until I have struck off thy hideous head.’ Heront said: ‘I am older than thou’, said he: ‘and tell me thy story in honor of God and of my age, for my heart has rejoiced much in thee, and I have no desire to kill thee.’ Roighnebron said: ‘I will tell thee my story’, said he, ‘and Roighnebron is my name, and I am the son of Sir Guy of Warwick.’


When Sir Heront heard that, he dismounted at once, and kissed Roighnebron fondly, fervently, and faithfully. Heront said: ‘Roighnebron’, said he, ‘dost thou recognise me?’ ‘I do not’, said Roighnebron. ‘I am Sir Heront, thy fosterfather’, said he, ‘and the charge was made against me in England that I had sold thee to a merchant-ship. And I have travelled over a great part of the world in search of thee; and I have been held seven years in captivity by Ambrail in this city beside thee, and it is he who sent me today to fight on his behalf.’


As for Roighnebron, when he had heard this story, his joy was immeasurable. And those two made peace between Argus, the King of Africa, and Ambrail, who was of lower rank than a king and was greater than a duke; and those two gracious and noble kings released all whom they held as prisoners on both sides in honor of those two knights. And Sir Heront said that it was from him that Roighnebron had been

 



---

p.177






stolen, and that he was in search of him. And then they parted from the kings, and thanked them afterwards for the honor, and Sir Heront sent his ship and his followers before him to England. Thus did those two knights leave the land of Africa.


#### 44


{Ir. ed. page 102} As for Roighnebron and Heront, they proceeded for a while on their way through wildernesses broad and vast, *and* they did not see either man or animal, and both they themselves and their horses were tired and hungry at the end of the day. And they saw before them a strong tower of stone, and a firm, impregnable palisade about it, and a broad forest beside this castle; and they asked to have the door opened before them, and the keeper inquired who was there. And they replied: ‘Only two knights alone’; and their request was granted, and they were let in, and their horses were taken from them and their feet were washed, and a supply of food and drink was given them, and they partook of what they needed.


Roighnebron inquired what made that whole land a wilderness. *The lady* replied: ‘A haughty, fiendish, wicked king made war upon us’, said she, ‘and our followers were slain by him, and he took away from us all our possessions, and captured or killed the lord of this land. And that lord was my husband, Earl Aimistir Amundae, and Sir Guy of Warwick has always defended him hitherto, for he was a young follower of Guy.’ Roighnebron said: ‘I will go in search of husband for thee’, said he, ‘for he was a follower of my father.’


Roighnebron arose the next morning, and set out, and he did not let Sir Heront go with him, but went alone; and he was a long time travelling on his way, and he came upon the mouth of a cave, and he went into it, and proceeded three miles under the earth; and as he left the cave a brilliant light rose before him, and he found a swift, strong stream, and thirty feet of depth in it; and Roighnebron found no way across it. And he committed himself to the protection of the Trinity, and made a bold leap upon his horse into the stream, and it bore him across; and he saw a broad, strong city, and went into it, and explored the whole city, and he found no man in it; and after that he went into the great royal hall, and found a single large man, wretched and weak, sitting in the hall, and many irons on him. And he greeted him, and the young warrior answered the greeting. And he said: ‘Young knight’, said he, ‘it is a pity for thee to go into this city to thy death’, said he. ‘Who art thou?’ said Roighnebron. ‘I am Earl Aimistir {Ir. ed. page 103} Amundae’, said he, ‘and I have been here six years in captivity; and Sir Guy of Warwick made a knight of me, and it was his retainer that I was.’ Roighnebron said: ‘Mount behind’ said Roighnebron, ‘and I will take thee with me’, said he. ‘If thou wilt go’, said the earl, ‘take with thee





---

p.178






the king's sword that is by the side of the window yonder, for it is not possible to wound him with other weapons, and perhaps it is not even in the power of his own sword to kill him.’


And they advanced on their way then, and they saw the King of the **Sidh**[184](javascript:footNote('T306000/note184.html')) *approaching them*, and the king cursed Roighnebron. Roighnebron said to Earl Aimistir: ‘Dismount’ and he did so thereupon; and Roighnebron and the King of the Sidh fought a hard, bitter battle with each other from the very beginning of the bright, early morning until midday; and it was not known in that time which of them would win the victory in the battle. Then Roighnebron gave the king of the **Sidh** a violent, venomous blow, and struck him to the ground, and leapt down upon him to behead him. And the king said: ‘My lord’, said he, ‘take me as a retainer, and grant me my life, and I will yield myself and my possessions to thee; and I thought there was no man in the world who would conquer me, except Guy of Warwick or some one of his kin.’ Roighnebron granted the king his life, and the King of the **Sidh** released Earl Aimistir his prisoner to Roighnebron and returned to the earl all his possessions, and conveyed them across the stream. And they went to Sir Heront, and to Earl Aimistir's wife, and the lady rejoiced to see her husband with his followers after they had been seven years where she could not see them, and she gave Roighnebron a kind and friendly welcome. Thus far how Roighnebron overcame the King of the Sidh.


#### 45


After achieving this great feat, Roighnebron then proceeded on his way, and Sir Heront along with him, and they made no stop until they came to the land of Burgundy; and they found it deserted and without cultivation, and its cities in broken and dismantled ruins. And Roighnebron asked what brought the land to that state. *Some one*[185](javascript:footNote('T306000/note185.html')) told him: ‘Earl Salua’, said he, ‘has destroyed the dominion of the Duke of Burgundy; and there has been with him for some time a single knight, young, brave and famous, {MS page 104} and there has not come a knight equal to him since the beginning of the world; and it is he who has plundered and laid waste this land. And he is on the summit of the hill yonder before you, keeping the road, and he does not let a living creature pass him without killing it, and there are two thousand dead knights around him who have fallen at his hands.’ ‘I will go myself to fight with him’, said Roighnebron. ‘I will go with thee’, said Sir Heront; and then they went to the top of the hill, and they were not long there before they saw the knight, brave and resolute, approaching them, and





---

p.179






he *was* advancing indirectly against[186](javascript:footNote('T306000/note186.html'))(?) Roighnebron. Sir Heront said: ‘Roighnebron’, said he, ‘be on thy guard now, for the strong, brave knight is coming toward us.’ And Roighnebron went to meet him, and they fought with each other a perilous and terrible battle, and they were in the battle until midday, and it was not known which of them would win. Roighnebron said: ‘Since I took a warrior's weapons in my hand, no man of thy age has fought with me without falling at my hands’, said he. ‘Thou shalt find me like this always’, said he, ‘until thou fallest before me.’ And they were fighting each other long after that. Sir Heront said: ‘Cease a while from our fighting’, said he, ‘and let us give account of ourselves to each other.’ The knight said: ‘I will give no account of myself to you’, said he, ‘until I strike off the head from one of you.’ ‘Tell us thy story for the sake of thine honor and thy renown, for our hearts are rejoicing in thee, and we do not desire to do thee harm.’ The knight said: ‘I will tell you my story’, said he, ‘for I am an English knight’, said he; ‘and I am Sir Heront's son, and a knight of the retinue of Sir Guy of Warwick, and Sir Aslog is my name’, said he. ‘And Sir Heront, my father, went in search of Roighnebron, his ward, the son of Guy of Warwick, and the men on a trading ship had stolen him away to Africa; and it is seven years since he went on that search, and we have got no word of news about either of the two in that time. And when I came to fighting age, I took the order of chivalry and the weapons of a knight, and I came to travel through the world in search of my father and of my foster-brother. And Earl Salua engaged me to make war upon the Duke of Burgundy, and I have plundered and devastated Burgundy this year. And I have guarded this road for a year, because it is the common road of all who travel through the world eastward or westward, and not a single knight {MS page 105} has travelled this road for a year of whom I have not asked news concerning my father and my foster-brother, and I have got no word of news about them in that time; and when I got no news, I allowed no living man of them to pass me without killing him; and this is my story for you. And now I will do the same by you; I will strike off your two heads[187](javascript:footNote('T306000/note187.html')) before I part from you.’ Sir Heront said: ‘It is not fitting for thee to kill us’, said he, ‘for I am thy father, and he is Roighnebron with whom thou art fighting.’ When Sir Aslocc heard this, he quickly dismounted, and he gave Roighnebron three kisses fondly, fervently, and faithfully, and likewise Sir Heront. And they entered upon sweet speech and fair conversation with each other, and





---

p.180






afterwards went to Earl Salua and made peace between him and the Duke of Burgundy. And after that they came to England, and Roighnebron did not find his mother alive there, and he took possession of the heritage of his ancestors, namely the earldom of Warwick and the earldom of Buckingham; and he gave Sir Heront a barony, and great riches besides.




---

p.298


The Irish Life of Bevis of Hampton
----------------------------------


#### 1


{Ir. ed. page 273}There was a very rich and charitable earl in England whose name was Sir Guy of Hampton, and he passed two thirds of his time and of his life in warfare and in constant strife; and he had no wife at that time. And his friends counselled him to take to wife the daughter of the King of Scotland. And it was thus with that maiden: she felt strong, passionate love for the son of the German Emperor, Para by name, and he felt the same toward her. Howbeit, it was the plan of the King of Scotland to give her to the Earl of Hampton for fear of his might and his vengeance, because there was nothing but the stream of Berwick (?)[188](javascript:footNote('T306000/note188.html')) between them, and it was possible for the earl of Hampton to help him or harm him. The Earl of Hampton took the daughter of the King of Scotland, and celebrated his wedding then, and carried her with him to his own city. And it was not long before she was with child, and gave birth to a fair, gentle son, and Bevis was given him for a name, and he was committed for his education to Sir Saber, a brave knight who was the earl's own brother.


#### 2


One day this hard-spirited countess was bathing in her chamber, and she saw her own form, and said: ‘It is a pity’, said she, ‘to have for my husband an old man, scarred and wounded, who has spent the best part of his life and his time, and my beloved companion and first love of all the men in the world, {Ir. ed. page 274} the young German Emperor, to be still without a wife because of his love and longing for me; and if I can’, said she, ‘I will soon grant him his wish and his long desire.’ The princess summoned a squire of her retinue, and took from him an oath to keep her secret,[189](javascript:footNote('T306000/note189.html')) and made her confession to him, and promised him every gift if he would go with a message from her to the emperor and tell him to have a thousand chosen knights of his great retinue in the hunting forest of the Earl of Hampton on the second day of summer. As for the squire he proceeded after that to the city of the emperor, and found the





---

p.299






emperor and told him secretly his message and commission. And the emperor was joyful at this news; he promised to do what had been told him, and said that he would make the squire a knight at once. The squire returned to the daughter of the King of Scotland. And her spirits were good at that news, and she continued thus until the beginning of summer; and at that time she pretended that a perilous disease had attacked her, and said that she was in danger of death. The earl asked what had befallen her, or whether there was any help for her. The wicked false malicious woman said: ‘There is help for me, if it pleases thee’, said she; ‘namely, to bring me my fill of the flesh of a young wild boar which thou wouldst kill in the forest by the shore’, said she. ‘Thou shalt have it’ said the earl, ‘for I will go tomorrow with my retinue to capture that boar for thee.’ ‘Take no man with thee’, said she, ‘but thy dog-boy and thy sword-bearer, for thou hast no fear of anything by sea or land, and thy hosts would raise great cries of the chase, and the wild creatures of the forest would break the strong palisades of wood that are around them, and the forest would be left without game.’ As for the Earl of Hampton, the next morning he went into the forest, and a small company along with him, and they let loose the dog and followed after it. And the earl rode forward on the path, and noticed nothing until he saw the emperor approaching, after having first closed around him with a bold, brave, irresistible troop; and they discharged an angry, venomous storm of weapons upon him at once. The earl took a quick, warlike, bold grip upon his sword, and dealt the emperor's troop violent blows, so that a hundred brave knights fell before him in the first onslaught. Thereupon he went where he saw the emperor, and he gave him a bold blow so that he knocked him from the saddle, and then he bent over him {Ir. ed. page 275} to kill him and lacerate him.[190](javascript:footNote('T306000/note190.html')) The Germans went between them bravely, and bore the emperor off from that tumult, and put him upon a famous, high-leaping horse. And they closed around the earl and killed his steed; and the earl was on his feet, and brave, fierce and valiant was his fight, and bloody the discomfiture he brought upon the emperor's force. Then the emperor said: ‘Earl of Hampton’, said he, ‘give thyself up now, and thou shalt receive thy life.’ The earl said: ‘If leave were given me to depart, and to take my wife and my son with me, I would yield myself up to thee.’ And the emperor promised him this; and after that he asked the earl for his sword, and the earl gave it to him. And when the sword reached the hand of the wicked, pitiless emperor, he gave the earl a destructive deadly blow so that he parted his head from his body; and he sent a messenger





---

p.300






with the head to the daughter of the king of Scotland as a token of love, and she rejoiced to see her husband's head like that. Bevis of Hampton said, and he at the end of his third year: ‘O wicked, unhappy harlot’, said he, ‘it is a piteous deed thou hast done, to kill the best earl in Christendom and that will turn out ill for thee yet.’ The lady[191](javascript:footNote('T306000/note191.html')) was angry and enraged with her son, and she commanded Sir Saber on peril of his life to put Bevis to death. Sir Saber said that he would do it, and he took him quickly away with him, and rubbed him with grease and oil, and put an ugly and unrecognisable semblance upon him. And he put a wretched garment of poor color about him, and set him in the wild glens of the desert to keep swine. Thus was the violent death of the Earl of Hampton.


#### 3


As for the emperor then, he proceeded to the city with his retinue, and a wedding-feast was prepared for him; and when the feast was ready, a wedding-mass was celebrated for them. And after that they went to enjoy the banquet, and the feast was served among them, and revelry and high spirit rose among the hosts. And Bevis of Hampton was with the swine near the city that day; and one of the sows had a litter of pigs and the swine-herds killed part of the pigs and were eating them by a fire, and Bevis was eating with them, The swine-herds said: ‘Great is thy cowardice,[192](javascript:footNote('T306000/note192.html')) Bevis, to be sharing these pigs with us, while {Ir. ed. page 276} thy mother's marriage-feast is being celebrated today in the castle of thy father and thy grandfather.’ Bevis left them at that, and went to the gate of the city; and he heard the revelry and the lively shouts of the young men enjoying the feast. Bevis came to the gate of the city, and asked to have it opened. The gate-keeper asked who was there. Bevis said that he was Sir Saber's swine-herd. The gate-keeper said that he was well deserving of dishonor for asking to enter the city. [193](javascript:footNote('T306000/note193.html')) ‘Wilt thou let me in?’ said Bevis. ‘I will not’, said he ‘and if I were outside, I would make thee repent of coming to ask admittance’, Bevis said: ‘If thou wert out here with me’, said he, ‘I would make thee repent of not letting me in.’ The gate-keeper was angry at this, and came to kill Bevis. Bevis lifted up the crooked hazel staff that he had for driving the swine and struck the gate-keeper a hard blow with it on the back of the neck, and the gate-keeper died from it. Bevis went in among the hosts, and saw the emperor, and said to 





---

p.301






him in a high, clear voice: ‘My lord emperor’, said he, ‘treacherous and envious is the deed thou hast done, to kill the noble honored earl without cause for the sake of that slanderous, wicked harlot beside thee.’ And he said, ‘Take thy harlot with thee to thine own land and city, and leave me my heritage and city for I am Bevis, the son of the Earl of Hampton.’ The emperor gave orders to bind and fetter Bevis. When Bevis heard this, he seized his staff bravely and firmly, and smote the emperor three blows with it, so that he broke and shattered the tight-bound crown of talismanic stones that was on the emperor's head and shed his blood copiously, and knocked him down under the table. Then the retinue and heavy troop of the emperor sprang up to attack Bevis. As for Bevis then, he sprang up bravely and swiftly, and killed many of them with his staff, and went out of the city; and Sir Saber came to meet him and said: ‘Bevis’, said he, ‘sad is the deed thou hast done, to enter the clamorous city, for fear of thy recognition there; and they would put[194](javascript:footNote('T306000/note194.html')) thee to death, if they knew who thou art. And they would do the same to me if they knew that thou art alive.’ Bevis said: ‘It is a good deed I have done’, said he, ‘for it was fitting for me to avenge my father and to kill the emperor.’ When Sir Saber heard this, he took Bevis {Ir. ed. page 277} with him and concealed him in his own castle. The emperor blamed and reproached the daughter of the King of Scotland, and said that she had promised to put Bevis to death, and that she had been false to her promise. The lady said: ‘I give thee my word’, said she, ‘that I thought he had met his death.’ Then the daughter of the King of Scotland came out and said to Sir Saber: ‘False and traitorous man’, said she, ‘thou saidst thou hadst put Bevis to death; and thou shalt die thyself, with thy wife and thy son, because of the deed Bevis has done.’ And Sir Saber was taken after that, and his wife and Tirri, his son, and they were about to be put to death. When Bevis heard this he came out into the lady's presence, and said: ‘Violent and wicked lady, have Sir Saber with his wife and his son released in their innocence, and do thy will with me for it is I who did the deed.’ Then Bevis was taken, and Sir Saber was released with his wife and his son; and the daughter of the King of Scotland ordered two knights of her retinue to kill him and to bring her proof of his murder. The knights took Bevis with them to be killed; and they took off his clothes, and when they beheld the fair, happy face of the young lad, pity and heavy compassion seized them and the knights said, ‘It is a pity’ said they, ‘for us to have on our souls the death of this innocent lad.’ Sir Saber said: ‘Noble, compassionate knights’, said he,

 



---

p.302






‘do what is right: the lad shall go aboard a pagan ship that is leaving the harbor, and they will carry him off to the eastern part of the world, and there will never be news of him again.’ And they did so, and the knights brought Bevis's garment to the lady after they had cut it in pieces with their weapons covered with blood. This was the exile of Bevis.


#### 4


As for the boat in which Bevis was put, it did not stop until they came to the rich, prosperous land of Mirmidonda[195](javascript:footNote('T306000/note195.html')) the great in Greece. And a strong, valiant pagan was king over that land, Eirmin by name. And the ship's company gave Bevis to the king, and Ermin asked for an account of him, who he was himself, and what his country was. Bevis said: ‘I am the son of an English earl’, said he, ‘and my father was killed by treachery; and the same would have been done to me, if it could have been accomplished.’ The king said: ‘Believe in my gods’, said he, ‘and I will give thee my daughter to wife, and will make thee heir of my kingdom.’ Bevis said that he would not forsake his own Lord, the Heavenly Father, for the wealth of the whole world. As for {Ir. ed. page 278} Bevis then, he was for seven years horse-boy to the king. One day sixty knights of Ermin's retinue went to perform deeds of horsemanship, and Bevis along with them. And a knight said to him: ‘Bevis’, said he, ‘dost thou know why this day is honored in the land and the fair country in which thou wast born?’ Bevis said: ‘I do not remember why today is honored, for it is seven years since I left the country where I was born, and seven years more of my life I left behind there.’ The knight said: ‘It is not so with me’, said he; ‘I remember why the day is honored among you, for last night it was the anniversary of the night when the Lord was born in whom thou believest. And it was our fathers who crucified him, and Christmas is the name of this day among you in England.’ Bevis said: ‘It is a pity that I am without strength’, said he, ‘to take vengeance on you for confessing that it was your fathers who caused my Lord to suffer.’ The pagan knights said: ‘If thou hadst the strength, thou wouldst do it’, said they; ‘and as it is, we have the strength to do it to thee.’ The sixty knights collected to attack Bevis in one onslaught. When Bevis saw this, he took the sword from the knight that was nearest him, and struck him with it so that he made two pieces of him. And after that he dealt blows among the knights, and he killed them all except three men only who escaped by the speed of their horses to the king to report the deed. Bevis went into his chamber in great anger because he had not got the satisfaction of his desire from the pagans. Those three knights





---

p.303






escaped from Bevis with a report to the king, and told him that Bevis had slain the knights. The king sent messengers to Bevis, and the messengers asked Bevis to come with them to the king. Bevis raised his head from his pillow,[196](javascript:footNote('T306000/note196.html')) and his eyes were flaming fiercely in his head with the violence of great wrath. And Bevis said: ‘If it were knights or men of warfare who came with that message, I would not let one of them escape alive; but it is not fitting for me to slay the lowly or to kill a pack of gillies.’ The messengers came to the king and reported that Bevis had refused to come with them. Sisian, the daughter of Ermin, said that she would go to talk with Bevis; and she went, accompanied by a great company of noble ladies, and addressed Bevis in gentle, sweet-voiced words. {Ir. ed. page 279} And that stopped Bevis's wrath, and he came to the king with the princess, and told Ermin the reason why he had slain the knights. The king said: ‘We will forgive thee for killing the knights’, said he, ‘and we will give thee assurance of peace; for we understand now that thou hast love for the King thou hast never seen which is greater than thy love for me, for I am the king thou hast seen.’ Thus was Bevis set free after killing the knights.


#### 5


One day afterwards Ermin was in council in the marketplace of the city, and he saw a knight approaching, with a thin, dirty, tired horse under him, and he leapt to the ground in the king's presence, and greeted him. The king asked news of him, and the knight said: ‘I have great news’, said he, ‘namely, that a fierce, venomous boar has come to thy land and thy fair domain, and that a multitude of men and animals have been killed by it. Courts and castles *are* being razed violently to the ground, and there is not a man of the heavy-sodded earth able to fight with the hostile, unfriendly beast; and this is my news’, said the knight. The king said that he would give land and domain, and silver and gold and all kinds of possessions to the man who would overcome that horrible, destructive beast; and he found no man to serve him in his retinue or in his heavy army. As for Bevis then, when he was left alone, he took armor and weapons and a horse, and went to hunt for the venomous boar. Sisian was in the top of her sunny chamber at that time, and she saw Bevis going out to fight the virulent beast, and Sisian said: ‘Hard is my share in that’, said she, ‘for thou art the man who is dearest to me of all the men in the world, and it is not fitting for me to tell thee my story because of the vast extent of my heritage and my wealth, and I do not know what thy rank is or thy patrimony. And yet, if

 



---

p.304






the boar kills thee, Bevis, I will seek death at once because of sorrow for thee’, said she. Then Bevis went to the forest where the boar was said to be, and he blew a strong, brave blast on the end of a horn that he had, and it was not long before he saw coming toward him a greedy, tusked boar, cruel and quarrelsome, with black, deep, dark eyes to be seen in his head; and great, rough brows over his eyes; and a fierce, bright flame issuing strongly and boldly from his nostrils and from his dark-yawning, hideous mouth; and tough, hard clods of dirt thrown straight as a sword from his feet; and strong, great trees, {Ir. ed. page 280} and heavy boulders of rock torn out with great violence, strongly and mightily, as he was swiftly sharpening and polishing his teeth for that battle and conflict; and hillocks of heavy earth and great boulders of rock cast on every side by the ridge of his snout and his nose. Bevis saw the boar coming toward him, and he stuck spurs vigorously into his horse, and went resolutely and eagerly to meet it. And he gave the boar a keen thrust with his spear, and drove it into its throat, and the boar made little, broken, shattered fragments of the shaft of the spear, after chewing it greedily. And Bevis bared his sword resolutely when his spear was broken, and he made an ungentle and unloving fight against the boar, so that it fell dead and lifeless before him at the end of the combat. And after that he struck off its head, and put it on his spear, and mounted his steed, and left his sword on the spot where he had overcome the boar, and proceeded to the city.


And twelve knights of Ermin's retinue were keeping the forest that day; and they saw Bevis leaving the forest, and the boar's head carried off in his possession. The knights said: ‘Do you see the sly, Christian traitor who has slain the virulent boar? And let us put him to death, and take the boar's head with us to the king, and say that is was we who killed it, and we shall get whatever we ask from the king.’ The twelve knights of the forest went to Bevis to attack and slay him, and Bevis had no weapon with which to defend himself except a man's hand-breadth of the hard handle of a javelin, and he killed six of the knights with three blows of that wood. The six others escaped to the king by the speed of their horses and made complaint of this deed. Sisian, Ermin's daughter, was watching the battle while it was fought, and she went to her father and told him how the knights who kept the forest had played Bevis false, and how he had killed six of them with a small piece of a spear-shaft. And that set Bevis free, namely the excuse that Sisian made for him.


#### 6


Once when Ermin was on the green of his castle he saw a band of knights approaching him with letters under seal; and the letters said that Bramon, the King of Damascus, was coming to get Sisian, Ermin's daughter, by fair means or foul.





---

p.305






Then Ermin asked Sisian whether she would consent {Ir. ed. page 281} to be given to Bramon the King of Damascus; Sisian answered that she would not. ‘What is the reason?’ said the king. ‘This is my reason’, said she; ‘because I am thy heir, and if thou shouldst die, the man who was my husband would be king in this land after thee; and if it should be Bramon who was my husband, he would not remain in this land, but would carry his tribute into his own land, and this land would be put to shame because there would be no king dwelling in it; and that is the reason I will not consent to be given to Bramon.’ The king said: ‘What else is to be done?’ said he. ‘Thou shalt do bravely’[197](javascript:footNote('T306000/note197.html')) said she: ‘make a knight of Bevis of Hampton, and his courage would be the greater for it; and give him the leadership of thy army, and send him before thee into the front of battle, and in my opinion he will do a bold deed of bravery, for I saw him kill the virulent boar and the six knights with a hand breadth of a spear-shaft.’


Then Ermin made a knight of Bevis, and Sisian gave him a shield and a sword and a horse, Arundel the name of the horse, and Morglae the name of the sword. Then came the King of Damascus with his great hosts to ravage and lay waste Mermidonia. Ermin brought his army into one body and went against Bramon. And Bevis went man fully and full bravely in the front of the fight, and battalions and hundreds fell quickly before him. And he fought with the King of Damascus after killing the phalanx that was defending him, and he captured the king in the midst of his retinue, and put bonds and fetters upon him, and brought him in the reins of captivity and bondage, and gave him to the king of Mermidonia for safe-keeping. Sir Bevis turned back then to the hosts of Damascus, and began to slaughter them; and he found two of Ermin's retinue whom the hosts of Damascus were beheading, and released them, and the troop who were beheading them fell at his hands. And those two knights followed Sir Bevis after he had helped them. After winning victory and triumph in that battle Bevis returned to the city of Mermidonia wounded, gashed, and battle-scarred. Ermin told Sisian to take Sir Bevis with her to her own chamber to be healed. Thus did Sir Bevis fight that battle against the King of Damascus, et reliqua.


#### 7


As for the King of Mermidonia then, he took as ransom all the wealth of the King of Damascus, and the promise to pay taxes and tribute all his life and to follow Ermin's counsel in every thing. As for {Ir. ed. page 282} Sisian, Ermin's daughter, she took Bevis with her to be healed, and seated him by the post of her bed, and said to him: ‘Sir Bevis’, said she, ‘I have had until now





---

p.306






no chance to speak with thee, for thou art my choice of a husband and my first love of the men of the world, and it is thou whom I desire to have with me as my companion.’ Bevis said: ‘It is not fitting for thee to be with me’, said he, ‘for there is not in the entire world a man who would not find his satisfaction of a wife in thee; and lady’, said he, ‘I have no wealth or kingdom’, said he, ‘unless I win it by virtue of my strength; and it is for that reason I am not worthy to be thy husband’, said Bevis. The lady said bitterly and angrily: ‘O low-born hireling, and rough, base slave, and wretched, cowardly, wicked outlaw, the answer thou hast given me is churlish and mean; and do thou leave this city, and go away on a sea-voyage as thou art wont to do, and I *promise* to put thee to death *if thou refuse to go*.’[198](javascript:footNote('T306000/note198.html')) Bevis said patiently: ‘Lady’, said he, ‘mayst thou have much honor![199](javascript:footNote('T306000/note199.html')) And yet I am not of low rank, for I am the son of a noble earl who was the best in the world in his time, and the daughter of the King of Scotland is my mother. And the place where I received that insult and that reproach without cause, I will leave it instantly; and the steed and the sword which thou gavest me for a reward, thou shalt have them at once.’ Bevis angrily left the tower, and went to the stable of the horses. The lady said, after her strong anger was assuaged: ‘Boniface’, said she, ‘I regret what I said to Bevis; and if he leaves this household, my life will not last long after him; and do thou go and bring him to me, and I will give him his own demand in his dishonor’ *(i. e. to atone for it)*. Boniface went to Bevis, and asked him to go to the lady, and promised him whatever he might demand from her. Bevis refused to go with him. And Bevis had a noble garment of shining, bright-embroidered silk, and many fine bars (?)[200](javascript:footNote('T306000/note200.html')) of gold and splendid precious stones attached and fastened to that beautiful garment, and Bevis gave it to Boniface to reward him for his errand. Boniface returned to the lady, and told her that Bevis had refused to come to talk with her; and Boniface said many good things about Bevis, and said that it was no lowly man who had given him that noble garment, and that it was not fitting to insult the man who gave that gift and that reward. The lady arose thereupon, and went to Bevis, and said to him: ‘Bevis’, said she, ‘I am sorry for {Ir. ed. page 283} what I said to thee, and thou shalt have thy own demand *to atone* for it; and if it were thy desire to marry me, I would be baptized and would believe in the God in whom thou believest.’ Sir Bevis said: ‘I will accept thee on





---

p.307






those terms’, said he. And he took her hand in his, and then they kissed each other; and after that Bevis went into the tower with her, and treatment and relief were given him so that he was well after his sickness. And the two knights whom Bevis saved from death before this in the battle were listening to that betrothal, and they went to the king and told him the news of the betrothal, and told him to put Bevis to death. The king said that he was under great obligation to Bevis, and that he would not put him to death himself; but he said that he would send him where he would meet his death. Then a letter was written for Ermin, and this is what was in it, to put Bevis to death. And the king told Bevis to go with that letter to the King of Damascus. Bevis said: ‘My lord’, said he, ‘I am not a suitable messenger to go with that letter to Bramon, for it is I who killed his retinue, and defeated him in battle, and made him captive himself, and took away all his possessions as ransom, and put him under tribute to thee.’ ‘None the worse *for* that’, said Ermin, ‘and have no fear of anything there; and thou art the most faithful to me of living men; and take with thee neither thy horse nor thy sword, and do not open the letter until thou reachest Bramon, the King of Damascus; and have under thee a comfortable, easy-riding mule.’ As for Bevis then, he went straight forward on his way, and he was not long travelling over the road when he saw a palmer, manly and strong, on the road before him eating his dinner, — three pigeons[201](javascript:footNote('T306000/note201.html')) and a bottle of sweet wine and white bread. Bevis greeted the pilgrim, and the pilgrim answered him likewise, and offered Bevis part of the dinner. Bevis dismounted, and ate his portion of the dinner; and Bevis asked news of the pilgrim, what his country was, and on what journey he was bound. The pilgrim said: ‘I am an English knight’, said he; ‘Sir Tirri is my name, and I am the son of Sir Saber, and I am in search of Bevis of Hampton, for we two are the children of own brothers, Bevis and I. And my father's whole domain has been taken from him except one strong, impregnable tower in which he is himself; and I have come to travel through the world in search of Bevis of Hampton’, said he; ‘and hast thou a word of news about him?’ said he. ‘I have’, said Bevis, ‘for it is not more than two nights since I saw him, and the same size and shape is upon him and me.’ {Ir. ed. page 284} ‘I understand by this that thou art he’, said Tirri. ‘I am’, said Bevis; ‘and go back to thy father, and give him the strength of thy arm, and Bevis will shortly be with you.’ Sir Tirri said: ‘Give me that letter in thy hand to read, for often has a messenger been entrusted with the order for his own destruction.’ Bevis said: ‘It seems likely to me’,





---

p.308






said he, ‘that thou art no better reader of letters than I, and I do not serve a lord whom I would suspect of betraying me (?).’[202](javascript:footNote('T306000/note202.html')) Bevis took leave of Tirri, and Tirri went to England. As for Bevis after that, he went on his way, and it was not long before he saw the city of Damascus, and it was thirty miles away at that time. And it is thus that the city was: seven strong, impregnable fortifications around it of hard stone walls, and sixty feet between each two walls, and sixty feet of depth in the deep, dark, impassable ditches; and between the walls there was a swift, tidal stream, and a mad, tempestuous sea coursing around it in those broad, great ditches; and broad-bosomed ships, and boats filled with men, and vessels full vast, sailing before those perilous, rough winds; and a draw-bridge going into that city, and a firm,[203](javascript:footNote('T306000/note203.html')) strong pillar of brass supporting it, and ten bells clattering and jingling on that bridge, five bells on each side of it. And if there should tread upon that bridge as much as the weight of the swift, brave birds which is called the wren, those bells would strike noisily and clamorously so that the loud, complaining call of those signal bells would be heard throughout the length of the city. And the valiant youths and battle-hardened warriors of the city would respond bravely and quickly at the bridge to the call of the bells. And there was a splendid, great tower at the end of the bridge nearest to the city, and the figure of a dark, ugly-colored dragon cut on the side of that tower, and he had two great shining stones as eyes; and *there was* a broad, great door of brass in the entrance of that tower, and it is through that door that entrance was made into the city. And there were many stones of crystal and carbuncle and full splendid precious gems skilfully set in gold of Arabia in the windows and the casements[204](javascript:footNote('T306000/note204.html')) of that city. As for Bevis now, he stuck spurs vigorously into the horse, and set it running on the bridge, {Ir. ed. page 285} and the bells sounded loudly and clamorously, and the king with his great retinue hastened to the bridge. And the king said: ‘There is a hostile force coming over the bridge, or some man of ill purpose.’ The king came to the place, and Bevis dismounted on the ground in the king's presence, and made him an obeisance, and gave the letter into his hand; and Bramon read the letter. And he said: ‘I will do everything that this writing says’, said he; ‘for thou art Bevis of Hampton, and it is thou who took me captive, and killed my followers, and got ransom from me, and imposed it upon me to give homage and tribute to a man who was lower than myself.’ And Bramon said: ‘Give Bevis food’, said he, ‘for it is not





---

p.309






fitting to treat the retainer of a noble lord with dishonor.’ Bevis was taken to the king's hall, and food was given him; and they were asking each other what death they should inflict upon him. Some of them said to burn him at once; others said to crucify him with acclaim; others said to drag him after a horse; others to put him in poison for his punishment. Bevis said: ‘That is shameful’, said he, ‘to put to death one who comes[205](javascript:footNote('T306000/note205.html')) with a message; and it is this it would be well for you to do, to set me outside the city, and to give me equipment of battle, and all the hosts of the city to be in battle equipment around me, and all of them to be attacking me and smiting me together; and it is less cause of shame to you to kill me like that than to kill me here.’ One of the companies said: ‘At the time when thou haddest us before in the breadth of the land, thou didst slay our army; and thou wouldst do the same now, if thou shouldst get us out in the field.’ Then a group of bold warriors fell on Bevis's back so that swarms of eager bees would not be quicker at the honey-flowers[206](javascript:footNote('T306000/note206.html')) than were the bold, proud hosts of Damascus at binding and fettering the brave, firm-stepping warrior. And after that they put Bevis as a fettered captive in a cruel prison for his punishment; and Bevis took a stout staff with him into prison. And there was a flowing, ever crashing sea which came twice in a day and a night into that prison. And when Bevis sat down the sea was up to his chin, and when he stood it was up to his buttocks; and there was a strong girdle of iron, as broad as a warrior's neck, bound about his middle, and a heavy pillar of stone attached to that great fetter behind Bevis's back. And there came dark, devilish dragons, {Ir. ed. page 286} and hostile, venomous snakes, and strong, fierce beasts from the corner and from the sides of the prison, and began to tear and destroy the warrior. Then did Bevis implore the Heavenly Father to save him from that punishment; and he remembered the staff that he had taken with him into the prison, and he made a bitter, reckless fight against the many beasts, until he killed them all with the help of God. And the poisonous serpent tore away the flesh and skin of his left eyebrow with a bite. As for Bevis then, he was seven years stifled in that very strong prison, and this was his living for that time: half a small handfull of paltry [207](javascript:footNote('T306000/note207.html')) barley bread every other day; and this was his drink, the ever-crashing sea, et reliqua.




---

p.310


#### 8


One day when Bevis was in that prison in bodily suffering from hunger and confinement, he cried out to God at that time, and said: ‘O thou one God Almighty, who didst make heaven and earth without effort, and didst separate day and night from each other, and dost bring full-tide and ebb-tide upon the sea, and didst make all things out of nothing, it is a pity thou dost not grant me instant death out of the pain and suffering of this prison in which I have been for seven years. And thou dost see, O Lord, that I have not yet abandoned thy faith, though I have been fifteen years in the land of the pagans; and O Lord’, said he, ‘thou knowest that I should get wealth and a great kingdom if I would abandon thy faith; and O Heavenly Father’, said he, ‘help me when it is thine own time.’ An angel spoke above his head, and said: ‘Bevis’, said he, ‘have good courage, and a strong heart, for God has listened to thy complaint, and thou shalt soon have help.’ Then there grew a great light in the prison from the ministration of the angel, and sight and perception departed from the dragon, and the dragon was killed by Bevis.


As for the two knights who were keeping the prison, they heard Bevis praying and worshipping the Lord, and one of them said to the other: ‘Dost thou hear the false, hateful traitor worshipping the traitor whom our fathers crucified, and praising him as God? — And I give my word that I will go down there and strike thee a blow with my fist on thy dark-yawning, ugly mouth.’ {Ir. ed. page 287} The knight went fiercely and boldly into the prison, and when he reached Bevis, Bevis struck his sword out of his hand in spite of him, and smote him on the neck with his fist, and he died. The other knight asked: ‘How is it between thee and the Christian?’ said he. Bevis said: ‘He is wounding me badly, for he is stronger than I.’ The second knight entered the prison to help his companion, and Bevis struck him with his sword, and made two pieces of him. Bevis prayed and thanked God for that great miracle, and he moved himself gently in the midst of his prayer, and his fetters fell instantly from him on every side; and he stood up on the floor of the prison, and seized the strong rope and the firm cord of hemp by which the knights had come into the prison, and went up by it to the floor of the hall. And he found the door open and free, and a taper burning on each side of it in the very middle of the night, and the garrison of the castle all asleep. And Bevis went out to the stable of the horses, and with a single blow of a big, broad beam that was at the foot of the bed he killed the sixty lads who were keeping the horses, and he took his pick of the horses. And he put on strong, indestructible armor; and mounted his steed, and went on to the gate of the city, and asked to have it opened before him and said that the Christian had escaped who had been their prisoner for seven years. ‘That is sad’, said the





---

p.311






gate-keeper, ‘and follow him quickly’; and then he let Bevis out, for he thought it likely that all the hosts of the city were behind him; and thus Bevis got out of the city without hindrance. As for the hosts of the city, not much of the night passed before they discovered that Bevis had escaped, and that his keepers had been killed; and they took their horses and pursued him, and overtook him in the morning. A noble knight of the retinue of the King of Damascus was at the head of the host, and a very swift horse under him, and Grainnder was the knight's name; and Grainnder valued that horse at his own weight of gold, and Treinnsiuis was the name of the horse. And he overtook Bevis with the swiftness of his horse, and said that he would put him to death. Bevis turned and fought with him fiercely, angrily, and bitterly, and gave Grainnder a thrust of the spear, and drove it through his body without breaking it, and Grainnder died from it. And thereupon Bevis took his horse, Treinsiuis, and mounted it. And at that time the King of Damascus and his hosts overtook {Ir. ed. page 288} Bevis, and he killed countless numbers and great troops of them. Then the hosts of Damascus surrounded him, and tried to wound him and to kill him. And with the help of God, Bevis jumped his horse over a great cliff of the sea, and there was a swift, tidal stream, and a bay, roaring and stormy, on the other side of the rock, and it was not possible for any creature in the world to swim it. And Bevis's horse quickly sprang into that fierce water[208](javascript:footNote('T306000/note208.html')) and swam straight through it like a harbor, and crossed the stream swiftly and bravely. Twenty-four hours was Bevis with his horse crossing that water; and after Bevis had reached land he fell from his horse because of the weakness of his breath[209](javascript:footNote('T306000/note209.html')) and the greatness of his hunger. And he implored God earnestly and fervently to save him from that hunger, and he praised the Heavenly Father greatly, and with that there came to him new strength. And he took his horse again, and mounted it, and went straight forward on the way, and saw *a city* beyond him, and proceeded toward it; and on reaching the gate of the city he saw a lady, gracious and noble, on the top of the tower over the gate of the city; and Bevis greeted her, and asked her for food in honor of the Heavenly Father. The lady said: ‘Come in’, said she, ‘and thou shalt have thy fill of food and drink.’ Then Bevis went in, and dismounted in the royal hall, and sat at table, and food was put in his presence. And it was not long before he saw a bold, horrible giant, and a broad-bellied champion, heavy and strong, approaching him; and the giant looked at Bevis and saw Grainnder's horse. And he said





---

p.312






fiercely and angrily: ‘That is Treinnsiuis, the horse of Grainnder, my own brother; and thou, traitor’, said he, ‘hast stolen it.’ Bevis said: ‘I did not steal it’, said he, ‘and yet I killed the man who had it, and struck off his head violently.’ When the champion heard that, he aimed a mighty blow at Bevis with a horrible, perilous dagger, and Bevis dropped under the table and let the blow go past. And the giant cut a piece as large as a warrior's hand from the table above Bevis's head. Bevis sprang from the board at that, and ran at the giant, and seized {Ir. ed. page 289} his dagger in spite of him, and smote the champion a blow with it so that he made two pieces of his body. Thereupon a cry was raised in the city, and Bevis mounted his steed; and the hosts of the city overtook him, and he slew multitudes, and got away in spite of them. As for Bevis then, he was making a long journey through the eastern world until he came in India to the patriarch of the stream,[210](javascript:footNote('T306000/note210.html')) namely, one of the three[211](javascript:footNote('T306000/note211.html')) kings of India, and it is he who is Pope among them. And Bevis remained with him a year as his retainer; and there took place in that year no battle with warrior or soldier, champion or battle-phantom, lion or leopard, dragon or the many venomous beasts besides, that they did not all fall at his hands in the course of that year, and it was an abundance of treasure and spoil that he brought to the patriarch in that time.


Bevis said that he would leave India, and that he would be for another while travelling straight toward the western world. The patriarch said: ‘Do not go’, said he, ‘and I will give thee a kingdom, and thy choice of a wife of this land; and stay with me.’ Bevis made his confession to the Pope of India, and told him that the daughter of the pagan king was his legal wife. The patriarch said that if she was, it would not be right for him to have another woman unless his wife had given herself first to a pagan; and if so, that it would not be right for him to have his wife. As for Bevis then, he took leave of the patriarch, and went straight to the west, and did not stop till he reached Rhodes. And he stayed for another year with the Prior of Rhodes, and great was the number of pagans who fell at his hands in that year, and many Saracens and Jews fell at his hands in that year, and he obtained for the prior in that year an abundance of spoils and treasures. And the prior offered him a great realm, if he would remain with him, and Bevis refused it, and made his confession to the prior and told him that the daughter of the pagan king was his lawful wife; and





---

p.313






the same answer was given him by the prior and the patriarch. And after that Bevis went on his way, and carried off the palm for bravery in every land and every country of the world to which he went in those two years.


#### 9


As for Sisian, Ermin's daughter, when Bevis was sent with the letters to the King of Damascus, it seemed to her that he was long absent, and she went to her father and asked him where Bevis was. Ermin said: ‘It is sad, lady’, said he, ‘for he sent messengers before him to England, and demanded his domain of the emperor; and the emperor gave Bevis his daughter to wife, and he is now an earl in England. Moreover, {Ir. ed. page 290} men of foreign parts are not to be trusted, for in the end they set out for their own country. And I offered him a great domain if he would remain with me, and he refused me, and went on his way.’ As for Sisian now, she was in lamentation for grief about Bevis; and yet she did not believe her father's statements, for she thought that Bevis would not play her false. And it was not long after that before Ybor,[212](javascript:footNote('T306000/note212.html')) the King of Damascus sent messengers to ask for Ermin's daughter in marriage. Ermin went to his daughter, and told her that messengers had come from the King of Damascus to ask her hand. ‘And I will give thee to him’, said he. Sisian said: ‘Father’, said she, ‘I will do thy will.’ Then Ermin told Ybor's messengers to come for the lady at the end of a short period. When Sisian heard this, she made a beautiful girdle of gold thread and of resplendent silk, and wisely and skilfully, by the wisdom of the Greeks, she put into that girdle power to prevent any man in the world from destroying her virginity so long as that girdle should be upon her. And she put it around her inside of her clothing. Then Ybor came with fifteen thousand soldiers to get her, and she was given to him, and their marriage-feast was held, and the horse and sword of Bevis were given him, — Morglae and Airinnel their names. And Ybor hung the sword across him, and mounted the horse; and when Airinnel recognised that it was not Bevis who was on her, she ran roughly and violently, and carried him madly and furiously through deep, black, horrible glens, and over rough, precipitous hills, and high, dangerous cliffs, and it is a pity that she did not kill him. And after that the horse was put in the castle soller, and an iron lattice around her; and no man dared to touch her from that time forth until Bevis returned long afterwards.


#### 10


As for Bevis of Hampton, after he left Rhodes he did not stop until he reached the bounds of great Mermidonia in the beautiful, blue-watered land of Greece. And some one met





---

p.314






him on the road, and Bevis asked him for news of that land and particularly for news of Sisian. The young man said; ‘There is peace, and quiet, and prosperity in this land’, said he ‘and Sisian has been married for nine years to the king of Memroine.’[213](javascript:footNote('T306000/note213.html')) Sadly did Bevis receive that news; {Ir. ed. page 291} and he did not stop after that until he reached the land of Memrointi,[214](javascript:footNote('T306000/note214.html')) near the city of Ybor; and a pilgrim met him as he was leaving the city, and he asked news of him. The pilgrim said: ‘In that city yonder is the one woman who is the best in the whole world, Sisian the daughter of the King of Mirmidonia, the wife of Ybor, King of Memroine, for if all the men in the world should go to her at mid-day,[215](javascript:footNote('T306000/note215.html')) she would give them food and drink and gold and silver. And this is what she says to them with every alms: ‘Take that in honor of God and for the sake of Bevis of Hampton’; and no man understands that word from her.’ Bevis said: ‘Pilgrim’, said he, ‘give me the loan of thy poor clothes’, said he, ‘and take my knightly garments, until I come back.’ The pilgrim said he would not do it. Bevis said: ‘Give me thy poor clothes’, said he, ‘and I will give thee my knightly garments in return for them.’ They did so. And Bevis put on the pilgrim's clothes, and went on his way to the city, and saw the beautiful lady, and her head out of a tower-window. And this is what she said with a lamenting voice: ‘O Bevis’, said she, ‘it is a pity for me that thou art so far away, and the virtues of my girdle have departed, and it is necessary for me now to do Ybor's will.’ Then Bevis greeted her, and she answered him and asked him who he was. Bevis said: ‘I have been journeying about the world’, said he. The lady asked him if he had seen a word of news about Bevis of Hampton in any place where he had been. Bevis said: ‘I have seen him, and it is only three nights since then.’ And Bevis asked alms of the lady, and Sisian said: ‘Come in’, said she, ‘and thou shalt have alms, and shalt be prior of the beggars in this city today.’ Bevis went in, and Sisian came to meet him, and took him with her into the soller where Airindel was; and when the horse saw him and recognised him, she began to neigh and licked his hand. Bevis opened the lattice, and the horse came out and ran through the city. Sisian said: ‘That is a pity’, said she, ‘for the horse there will never again be caught.’ Bevis called the horse to him, and she came quickly, and was licking him, and he put her in again; and the lady looked at him, and when[216](javascript:footNote('T306000/note216.html')) she had raised the hat of leather from his head, she recognised





---

p.315






him though he had lost his left eye-brow since she had seen him before. The lady said: {Ir. ed. page 292} ‘Thou art Bevis thyself’, said she. ‘I am indeed’, said he; and he told her the truth about everything. And Sisian said: ‘Bevis’, said she, ‘go out of the city, and come at mid-day to the king, and tell him that thou wert in Babylon, and that the whole land has been captured except only the city of Babylon, and that there is a great army around it. And say that the King of Babylon sent thee to Ybor to help him out of this difficulty, for he is Ybor's own brother; and Ybor will go to his aid, and will leave this city unguarded, and thus we shall get an opportunity to escape.’ Then Bevis went out of the city, and came into it at mid-day, and went into the king's presence, and told him how Babylon had been taken, all except the great city only, — ‘and I have come secretly to get thee to help thine own brother.’ The king believed that, and collected his army in one place, and left the guarding of the city in charge of a noble knight of his retinue, and set out with his hosts. Sisian said: ‘Bevis’, said she, ‘we are in trouble now; for the knight who was left in charge of the city has a talismanic stone, and there is nothing done in the city which it does not reveal to him.’ Sisian made a potent drink by Greek wisdom, and sent a messenger to the knight, and he came quickly; and she gave him the sleeping-potion, and he fell asleep thereupon, and it was not possible to wake him for twenty-four hours. Thus did Sisian find an opportunity[217](javascript:footNote('T306000/note217.html')) of escape.


#### 11


As for Bevis then, he put Sisian behind Boniface, her chamberlain from the time she was a child until that hour, and mounted Airinndel himself, and in this way they passed out of the city without being noticed. As for Ybor, the King of Memroine, he was not long travelling the road when a pilgrim met him, and Ybor asked news of him, who he was. The pilgrim said: ‘I have been in Babylon’, said he. ‘Hast thou news of that land?’ said the king. ‘Good news’, said he, ‘for there is peace and quiet and prosperity in that land yonder; and it is strong above every land, and no land is strong above it.’ ‘That is true’, said the king, ‘and it is clear to me that it was Bevis of Hampton who came there in a pilgrim's guise to deceive us; and he has probably taken the queen with him, and we must turn[218](javascript:footNote('T306000/note218.html')) back by the same road.’


And {Ir. ed. page 293} they did not find the queen or Boniface in the city. And they followed on their track, and overtook them, and Bevis turned to meet them, and killed great hosts and countless numbers of them; and they came to a deep, dark glen, and one narrow wooded path going

 



---

p.316






through it. The king turned back at that time with his followers for fear that Bevis would kill his followers in the narrow part of the glen, and Bevis descended to the bottom of the glen. And Sisian said: ‘Bevis’, said she, ‘get us food, for hunger has overcome us.’ Bevis said: ‘O queen’, said he, ‘it is not easy for us[219](javascript:footNote('T306000/note219.html')) to get food in this wilderness, for men and cities are far from us.’[220](javascript:footNote('T306000/note220.html')) Sisian said: ‘I have heard’, said she, ‘that brave knights would get food in the wildernesses by their skill in handling spears.’ Bevis left Sisian and Boniface there, and went himself to seek adventure with the spear;[221](javascript:footNote('T306000/note221.html')) and he came upon a marvellous, wild boar, and he got his choice of a cast at him, and he drove a man's hand-breadth of the spear through its body, and it died, and he brought a quarter of it with him to Sisian. As for the King of Memrointe, he had two sharp-toothed lions that he kept, and the strength of a host or an army did not avail against them; and he set them on Bevis's track, and the lions came to where Sisian was, and Boniface rose and fought with them, and the lions killed him, and devoured both him and his horse. Then Bevis came up, and Sisian cried out to him to flee from the lions since he had the swift horse; and Bevis did not do this, but came to the spot. And the lions were licking the lady's feet; and one of them ran at Bevis, and Sisian held the other lion by the front paw, and it stayed by her without struggling. And Bevis killed the lion that fought with him, and called to Sisian *to let* the other lion come out against him; and Sisian asked for protection for the lion that was with her, but Bevis threatened her and said she must let it go. And she let the lion go to Bevis, and Bevis killed the second lion, and afterwards dismounted, and made a fire, and boiled the boar's flesh, and gave the lady plenty of food and pure water.


And then he mounted his horse, and left the glen, and there was a ridge of a high, very cold mountain to be crossed by him. And it was not long for him before he saw coming after him a fierce, warlike, horrible giant, and a rough, savage[222](javascript:footNote('T306000/note222.html')) champion, with a stout, broad-topped tree on his shoulder; and not swifter was a wild boar on the way {Ir. ed. page 294} than the swift, fierce course that the giant took after Bevis. Sisian looked back, and she saw the champion coming in pursuit. Sisian said: ‘O Bevis’, said she, ‘I see the champion of the king of Mermeointi coming toward thee, and I recognize him, and armies and hosts are not his equal in battle because of the 





---

p.317






greatness of his strength and the skill of his hand.’ Bevis said to her: ‘Dismount’; and she did so at once, and Bevis rode his horse against the giant; and the giant aimed at Bevis a rough, powerful blow, and Bevis avoided the blow, and sprang upon the giant under the tree, and put both arms around him, and gave him a hard twist, and threw him. And Bevis bound the giant securely; and when he was about to strike off his head, Sisian asked him to spare the giant's life, and the giant should be[223](javascript:footNote('T306000/note223.html')) his retainer from that time forth for the length of his life; and thus Bevis gave him his life. Those three went on their way, and came to the sea, and they had no ship. And they saw ships on the sea, and Esgobard cried out to them, asking for a ship, and they made him no answer. And the giant went boldly out into the sea, and put his two hands under the ship that was nearest to him; and the crew thought that it was into the ship he wished to go, but he did not do that. He turned the ship upside down, and drowned in the middle of the ocean all that were in it, and brought the ship to Bevis. After that they went aboard the ship, and began eagerly to sail the sea, and they came to a sheltered, secure harbor in Coilin[224](javascript:footNote('T306000/note224.html')) in England.


And a brother of Bevis's father was bishop in that city. And the bishop came to meet Bevis, and paid him honor and respect. Bevis asked whether there was strife of war or of rebellion in England at that time. The bishop said: ‘There is great danger and peril in this land now’, said he; ‘namely, two haughty dukes who were in Germany, and they were thirty years at war with each other, and their troops and armies were killed on both sides in that time. And they made deep, impassable wildernesses of their lands and all their territories, and neither the emperor nor the pope could make peace between them. And finally they themselves went to battle with each other, and God changed them alike to the form of two black, devilish dragons because of the multitude of their sins, and they went up on high above the clouds. And one of the dragons descended in Rome, and he began {Ir. ed. page 295} to kill the Romans and to lay waste the city. And the pope with his clergy prayed the Heavenly Father to help them out of that peril, and God did that for them: God enfeebled the dragon, and the Romans bound it, and put it in a room of a castle under the bridge of Rome, and it is bound there. And the other dragon descended upon this land, and it is only seven miles from here; and it has laid waste a great part of this realm, and has killed a multitude of men and of cattle, and we are afraid that it will make a wilderness of all England.’ It was not long after





---

p.318






that when Bevis escaped the attention of the bishop, and went out of the city secretly, and the giant along with him; and they went to the forest in which the dragon was, and they heard the terrible cry and the fierce roar of the dragon. And Asgobard said: ‘Not for the wealth of the whole world would I stay to meet that angry, hostile beast’; and the giant fled out of the forest and left Bevis alone.






As for Sir Bevis then, it was not long before he saw the black, misshapen dragon approaching; and Bevis spurred his steed vigorously to meet it, and gave the dragon a keen thrust of the spear and did not wound it. And the dragon spouted a flood of green vomit in Bevis's eyes, and did not leave him the strength of a woman in child-bed. The monster passed by him in that charge, and *Bevis* sprang into a well that was near, for he chose rather to be drowned than to be swallowed by the dragon; and after he went into the water his strength returned to him mightily and powerfully. And he went again to meet the beast, and gave it a spear-thrust, and did not hurt it. And the dragon spouted a second flood about him, and did not leave Bevis the strength of a babe; and Bevis sprang into the same well again, and was whole and sound on coming out of it. Three times he sprang thus into the well after being struck by the green vomit, and he was whole and sound on coming out. The fourth wave that smote upon him was colorless and white, and none the weaker was Bevis, for the poison of the monster had been exhausted; and Bevis gave *the dragon* a spear-thrust, and drove the spear through it, and beheaded it afterwards, and took its head away.


As for Asgobard, he proceeded to Coilin, and told the bishop that Sir Bevis had been killed by the dragon. And the bishop went, and the people of the city, in a procession to get Sir Bevis's body; and the bells of the city were all rung in honor of Bevis, and {Ir. ed. page 296} nothing was heard in the city except only the sound of the bells and outcry and lamentation. Then they saw Bevis coming to meet them, with the dragon's head on his spear, and the spear on his shoulder, and he himself in the saddle of his horse. And the people uttered shouts of joy at the sight of Bevis, and greatly praised that deed of bravery; and they went together into the city, and Bevis was held in honor there. Thus far the battle of Bevis against the dragon.


#### 12


for Bevis then, he went on his way to France, and was there a while, and left Sisian in a strong city, and Asgobard to keep and guard her. And Bevis went to carry help to Sir Bir,[225](javascript:footNote('T306000/note225.html')) his foster-father and uncle, in England and it was not long for Sisian after Bevis's departure before a rich, mighty earl, whose name was Earl Milis, came to ask for her [226](javascript:footNote('T306000/note226.html'))


---

p.319






in marriage, after having given her his love (?); and he asked her and she refused him. Earl Milis said that she should be his by fair means or foul. Sisian said that she would not be and that she had sufficient protection about her; and the earl asked what protection she had about her. The lady said it was Asgobard. Not long after that the giant met the earl, and *the earl* brought a letter in his hand, and said Bevis had sent him a message to bring the giant out on an island; and that was three miles from the city out upon the sea. The giant went out to the island, and Earl Milis to escort him;[227](javascript:footNote('T306000/note227.html')) and there was a strong castle on the island, and the earl put —[*gap: illegible/extent: a line and a half*] — back into the same city, and told Sisian that the giant was in his prison of confinement. And the earl said: ‘Sisian’, said he, ‘it is necessary now for thee to do my will.’ Sisian said: ‘Thou art my choice of the men of the world, if I shold get thee as husband; but never shall a man who is not my husband enjoy my favour with my consent.’ The earl said that he would marry her on the morrow. And early in the morning the earl married the lady, *and* the night after to lie with the lady. The lady said: ‘Earl Milis’, said she, ‘the work which thou desirest to do is unknown to me until this time, and I beg thee to let no man come into the same house with us tonight.’ The earl said {Ir. ed. page 297} that he would not let anyone in, and he sent out those that were within, and shut the door, and was taking off his clothes. Sisian sat upright, and seized a tough, strong cord of hemp, and made a slip-knot upon it and put a tight twist *of it* under Earl Milis's head; and there was a strong beam running cross-wise above the floor of the chamber, and Sisian *put* the cord across the beam and drew him up by the neck, and beat the back of his head against the beam strongly and mightily, and strangled him thus. And she let him fall, after his life had left him, and then went to sleep herself.


As for the followers of Earl Milis, the next morning they were joking and making sport about the earl as was customary with a bridal couple. One of them said that it was well pleased the earl was with taming the maiden. [228](javascript:footNote('T306000/note228.html')) And another said that it was fitting *for her* to have [*gap: illegible*] and cookery in preparation for the earl, rather than to be asleep at that time after the night's work he had had. The lady said: ‘  
[*...*]  
’ said she, ‘he does not ask cookery of you, for he is dead *in* revenge for my insult, and *I pledge my word* that I chose rather to die than to be the earl's wife.’ His retinue





---

p.320






uttered (?) [*...*] and cries [*...*] lamenting their lord, and all *the hosts of the city* came to the place. And the lady was taken by them, and they left her *on the market-place of the city*, and made [*...*] a surging, strong-burning *fire* for her, to burn her up; and she asked of them as a favor to let her have a priest that she might make her confession [*...*], and that was granted her. Then it was[*...*] that the giant, Asgobard, and he [*...*] in prison, noticed the terrible, blazing fire on the green of the castle, and he thought in his mind that some wrong or injustice was being done the lady. And a fierce, strong fit of rage seized him [*...*], and he broke the chains and fetters, and the stone ramparts and the partition-walls of the castle, and went out, and set his face towards the rough surging waves, and began to swim strongly and boldly. And he saw a small boat in the middle of the water, and a fisherman in her stern killing a fish; and the giant went into the boat, and the fisherman did not observe anything until he saw the misshapen creature and the rough, ill-boding [*...*] rising *out of the* stormy *sea*, and coming into the {Ir. ed. page 298} boat; and fear [*...*] seized the fisherman, for he thought that it was [*...*] *of hell*. He leaped [*...*]*and* was drowned. As for Esgobard then, he began to row the boat *with his hands   
[*...*]  
, and came to harbor, and ran to the city.*














